package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class ID {
  private static final String name = "id";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public ID() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 2395964;
    n_words[1] = 2929447;
    n_words[2] = 2314802;

    freq.put("┌ ", 142);
    freq.put("⌣̀ ", 337);
    freq.put("̯͡ ", 178);
    freq.put("yu ", 427);
    freq.put("xt ", 34);
    freq.put(" y ", 571);
    freq.put(" ̮Ơ", 55);
    freq.put("e ", 19746);
    freq.put(" yh", 37);
    freq.put(" yn", 26);
    freq.put(" yo", 776);
    freq.put(" ya", 11407);
    freq.put("k", 121529);
    freq.put(" ye", 623);
    freq.put(" yg", 5383);
    freq.put(" yu", 564);
    freq.put("⌣ˆ ", 39);
    freq.put("jm ", 39);
    freq.put("dng", 50);
    freq.put("dny", 238);
    freq.put("˘ʃƪ", 61);
    freq.put(" ̮ ", 89);
    freq.put("dn ", 37);
    freq.put("Lg", 101);
    freq.put("Le", 609);
    freq.put("La", 828);
    freq.put("Lo", 368);
    freq.put("Lh", 66);
    freq.put("Li", 439);
    freq.put("Lu", 322);
    freq.put("̗", 52);
    freq.put("hob", 38);
    freq.put("hoa", 38);
    freq.put("hon", 649);
    freq.put("hoo", 142);
    freq.put("hol", 198);
    freq.put("hom", 62);
    freq.put("hok", 34);
    freq.put("hoh", 100);
    freq.put("how", 33);
    freq.put("hot", 101);
    freq.put("hou", 37);
    freq.put("hor", 92);
    freq.put("hop", 40);
    freq.put(" ▽ ", 51);
    freq.put("A", 7460);
    freq.put(" ̮¬", 39);
    freq.put("L ", 471);
    freq.put("̾̾", 36);
    freq.put("ho ", 429);
    freq.put("xi", 210);
    freq.put("fir", 217);
    freq.put("fis", 50);
    freq.put("fit", 214);
    freq.put("fix", 24);
    freq.put("fic", 28);
    freq.put("Hid", 84);
    freq.put("Hih", 78);
    freq.put("fik", 86);
    freq.put("Hik", 27);
    freq.put("Hil", 26);
    freq.put("fil", 251);
    freq.put("au ", 6745);
    freq.put(" Vi", 86);
    freq.put(" ╥ ", 31);
    freq.put("fi ", 72);
    freq.put("rR", 68);
    freq.put("upa", 890);
    freq.put("mdu", 613);
    freq.put("rt", 3257);
    freq.put("ru", 7529);
    freq.put("rv", 71);
    freq.put("rw", 112);
    freq.put("rp", 714);
    freq.put("rr", 1351);
    freq.put("rs", 1702);
    freq.put("∫", 44);
    freq.put("sms", 397);
    freq.put("¬", 1306);
    freq.put("rz", 45);
    freq.put("smp", 201);
    freq.put("rd", 701);
    freq.put("re", 5626);
    freq.put("rf", 127);
    freq.put("rg", 2313);
    freq.put("ra", 18674);
    freq.put("rb", 1170);
    freq.put("dsi", 24);
    freq.put("rl", 826);
    freq.put("rm", 1048);
    freq.put("rn", 3015);
    freq.put("ro", 2356);
    freq.put("rh", 612);
    freq.put("smb", 45);
    freq.put("sma", 383);
    freq.put("dsa", 30);
    freq.put("ial", 309);
    freq.put("atR", 26);
    freq.put("upu", 252);
    freq.put("atc", 33);
    freq.put("hg", 26);
    freq.put("ata", 3659);
    freq.put("atn", 330);
    freq.put("ato", 292);
    freq.put("⌣ƪ ", 116);
    freq.put("atm", 84);
    freq.put("atk", 201);
    freq.put("ath", 222);
    freq.put("ati", 2686);
    freq.put("atw", 27);
    freq.put("att", 152);
    freq.put("atu", 1716);
    freq.put("r ", 17411);
    freq.put("ats", 63);
    freq.put("ds ", 51);
    freq.put("sm ", 641);
    freq.put("Duh", 44);
    freq.put("̀", 472);
    freq.put("Dul", 36);
    freq.put("Dun", 34);
    freq.put("Dua", 39);
    freq.put("xD", 102);
    freq.put("Cem", 38);
    freq.put("Cew", 62);
    freq.put("xis", 24);
    freq.put("xit", 58);
    freq.put("Cer", 40);
    freq.put("Cep", 43);
    freq.put("xix", 49);
    freq.put("YA ", 79);
    freq.put("knn", 27);
    freq.put("xi ", 36);
    freq.put("Mba", 71);
    freq.put("Ast", 129);
    freq.put("Asa", 42);
    freq.put(" fb", 111);
    freq.put("Ase", 55);
    freq.put("Asi", 115);
    freq.put("Asl", 53);
    freq.put("nen", 679);
    freq.put("nel", 81);
    freq.put(" ˆڡ", 24);
    freq.put("oq ", 80);
    freq.put("lpo", 63);
    freq.put("knp", 290);
    freq.put("Tgl", 26);
    freq.put("ُ ", 25);
    freq.put("┌П", 57);
    freq.put("new", 46);
    freq.put("X", 372);
    freq.put("Rin", 29);
    freq.put("nep", 60);
    freq.put("Rib", 28);
    freq.put("PS ", 32);
    freq.put("wt ", 139);
    freq.put("irr", 70);
    freq.put("irs", 27);
    freq.put("irt", 93);
    freq.put("iru", 397);
    freq.put("iri", 1764);
    freq.put("irk", 66);
    freq.put("irl", 55);
    freq.put("irm", 84);
    freq.put("irn", 269);
    freq.put("iro", 71);
    freq.put("ira", 1155);
    freq.put("ird", 25);
    freq.put("ire", 142);
    freq.put("irg", 34);
    freq.put("cur", 220);
    freq.put("DM ", 58);
    freq.put("oki", 145);
    freq.put("ir ", 2264);
    freq.put("and", 2238);
    freq.put(" ʃ⌣", 116);
    freq.put("fre", 80);
    freq.put("fri", 56);
    freq.put("fro", 42);
    freq.put("anm", 160);
    freq.put("ann", 1421);
    freq.put("cub", 30);
    freq.put("ano", 76);
    freq.put("gx ", 24);
    freq.put("cun", 83);
    freq.put("uy ", 191);
    freq.put("bin", 422);
    freq.put("bio", 77);
    freq.put("bil", 1129);
    freq.put("bim", 53);
    freq.put("bij", 67);
    freq.put("dho", 41);
    freq.put("ˆ ", 119);
    freq.put("╥﹏", 63);
    freq.put("dhl", 76);
    freq.put("dhi", 52);
    freq.put("dhe", 41);
    freq.put("bii", 31);
    freq.put("dha", 252);
    freq.put("╯ ", 24);
    freq.put("big", 40);
    freq.put("jkt", 72);
    freq.put("bic", 51);
    freq.put("˚", 219);
    freq.put("LO ", 40);
    freq.put("dh ", 1151);
    freq.put("Iy ", 25);
    freq.put("هُ ", 24);
    freq.put("haR", 433);
    freq.put("hah", 10715);
    freq.put("hai", 164);
    freq.put("haj", 39);
    freq.put("hak", 114);
    freq.put("hal", 742);
    freq.put("ham", 963);
    freq.put("han", 2161);
    freq.put("haa", 870);
    freq.put("hab", 237);
    freq.put("hac", 33);
    freq.put("had", 260);
    freq.put("hae", 46);
    freq.put("haf", 24);
    freq.put("hag", 186);
    freq.put("hay", 268);
    freq.put("hap", 245);
    freq.put("har", 2489);
    freq.put("has", 540);
    freq.put("hat", 1623);
    freq.put("hau", 41);
    freq.put("bne", 80);
    freq.put("haw", 47);
    freq.put("Iye", 61);
    freq.put("Iya", 928);
    freq.put("anR", 86);
    freq.put("Iyo", 45);
    freq.put("ha ", 6041);
    freq.put("DR ", 35);
    freq.put("ola", 1161);
    freq.put("olb", 77);
    freq.put("old", 41);
    freq.put("ole", 1086);
    freq.put("MP ", 49);
    freq.put("oli", 213);
    freq.put(" X ", 89);
    freq.put("oll", 471);
    freq.put("oln", 28);
    freq.put("olo", 549);
    freq.put("ّهُ", 25);
    freq.put("olu", 39);
    freq.put("an ", 29962);
    freq.put("umu", 286);
    freq.put("ump", 645);
    freq.put("for", 184);
    freq.put("ume", 70);
    freq.put("uma", 2214);
    freq.put("umb", 234);
    freq.put("fol", 411);
    freq.put("uml", 29);
    freq.put("fon", 56);
    freq.put("umn", 91);
    freq.put("umi", 158);
    freq.put("ol ", 883);
    freq.put("o", 65923);
    freq.put("fo ", 113);
    freq.put("um ", 1416);
    freq.put("soa", 274);
    freq.put("mbo", 317);
    freq.put("mbi", 496);
    freq.put("mbe", 785);
    freq.put("sok", 1195);
    freq.put("som", 141);
    freq.put("sol", 209);
    freq.put("soo", 52);
    freq.put("son", 293);
    freq.put("sop", 73);
    freq.put("sos", 55);
    freq.put("sor", 298);
    freq.put("sou", 29);
    freq.put("sot", 45);
    freq.put("mbu", 977);
    freq.put("mbr", 57);
    freq.put("az ", 31);
    freq.put("so ", 278);
    freq.put("mb ", 58);
    freq.put("azi", 57);
    freq.put("ː̖", 39);
    freq.put("ː̗", 25);
    freq.put("aza", 93);
    freq.put("azz", 38);
    freq.put("Sis", 24);
    freq.put("Sir", 24);
    freq.put("Sip", 67);
    freq.put("Sit", 26);
    freq.put("khu", 56);
    freq.put("khi", 646);
    freq.put("Sia", 357);
    freq.put("khl", 78);
    freq.put("kha", 107);
    freq.put("Sin", 144);
    freq.put("Sim", 28);
    freq.put("Sil", 33);
    freq.put("nx ", 25);
    freq.put("E", 1881);
    freq.put("Idu", 117);
    freq.put("Si ", 133);
    freq.put("kh ", 64);
    freq.put("osp", 34);
    freq.put("oss", 104);
    freq.put("ost", 136);
    freq.put("osi", 311);
    freq.put("osh", 37);
    freq.put("osk", 42);
    freq.put("oso", 131);
    freq.put("osa", 263);
    freq.put("ose", 267);
    freq.put("ver", 240);
    freq.put("ves", 28);
    freq.put("ʃƪ˘", 57);
    freq.put("̲", 33);
    freq.put("ven", 59);
    freq.put("vel", 103);
    freq.put("ˇ", 560);
    freq.put("os ", 397);
    freq.put("Tau", 130);
    freq.put("Taw", 24);
    freq.put("Tap", 243);
    freq.put("Tar", 56);
    freq.put("¬͡", 87);
    freq.put("Tad", 67);
    freq.put("Aq ", 47);
    freq.put("ve ", 231);
    freq.put("Tam", 59);
    freq.put("Tan", 180);
    freq.put("Tah", 91);
    freq.put("Tak", 193);
    freq.put("RW ", 91);
    freq.put("M ", 477);
    freq.put("rec", 39);
    freq.put(" ⌣ ", 336);
    freq.put("Me", 1029);
    freq.put("Ma", 3172);
    freq.put("Mb", 107);
    freq.put("Mm", 28);
    freq.put("Mo", 383);
    freq.put("Mn", 46);
    freq.put("Mi", 587);
    freq.put("Mk", 53);
    freq.put("Mu", 534);
    freq.put("Mw", 26);
    freq.put("uff", 34);
    freq.put("Ms", 59);
    freq.put("Mr", 39);
    freq.put("My", 26);
    freq.put("▿▿▿", 110);
    freq.put("ipa", 434);
    freq.put("ipe", 227);
    freq.put("ipi", 296);
    freq.put("ipo", 71);
    freq.put("ipl", 26);
    freq.put("ips", 82);
    freq.put("ipp", 80);
    freq.put("ipt", 43);
    freq.put("ipu", 281);
    freq.put("Щ ", 120);
    freq.put("Bod", 24);
    freq.put("ip ", 599);
    freq.put("Liv", 24);
    freq.put("Wha", 34);
    freq.put("H", 5742);
    freq.put("s ", 15723);
    freq.put("щ", 166);
    freq.put("sR", 79);
    freq.put("¬˛", 61);
    freq.put("sy", 1170);
    freq.put("ss", 1790);
    freq.put("sr", 215);
    freq.put("sp", 555);
    freq.put("sw", 208);
    freq.put("su", 5849);
    freq.put("st", 3551);
    freq.put("sk", 1642);
    freq.put("sj", 130);
    freq.put("si", 14307);
    freq.put("sh", 1583);
    freq.put("so", 3240);
    freq.put("sn", 879);
    freq.put("sm", 2199);
    freq.put("sl", 665);
    freq.put("sc", 161);
    freq.put("sb", 347);
    freq.put("sa", 20520);
    freq.put("sg", 195);
    freq.put("sf", 59);
    freq.put("se", 13565);
    freq.put("sd", 407);
    freq.put("KA ", 32);
    freq.put("ttp", 86);
    freq.put("ttt", 302);
    freq.put("tti", 32);
    freq.put("tta", 51);
    freq.put("ttg", 68);
    freq.put("tte", 428);
    freq.put("jid", 127);
    freq.put("jie", 27);
    freq.put("jib", 90);
    freq.put("jia", 111);
    freq.put("jin", 242);
    freq.put("jil", 63);
    freq.put("jim", 29);
    freq.put("jij", 27);
    freq.put("jik", 151);
    freq.put("jii", 46);
    freq.put("dja", 27);
    freq.put("jiw", 64);
    freq.put("jit", 30);
    freq.put("jir", 154);
    freq.put("jis", 44);
    freq.put("Mel", 67);
    freq.put("tt ", 370);
    freq.put("ji ", 307);
    freq.put("Men", 512);
    freq.put("П", 58);
    freq.put("blu", 98);
    freq.put("bls", 72);
    freq.put("blm", 383);
    freq.put("blo", 338);
    freq.put("bln", 71);
    freq.put("bli", 98);
    freq.put("blh", 46);
    freq.put("blk", 35);
    freq.put("Jog", 24);
    freq.put("ble", 154);
    freq.put("blg", 134);
    freq.put("bla", 208);
    freq.put("Jom", 28);
    freq.put("ʃƪ ", 117);
    freq.put("bl ", 25);
    freq.put("onj", 32);
    freq.put("onk", 248);
    freq.put("oni", 171);
    freq.put("onn", 121);
    freq.put("ono", 215);
    freq.put("onl", 102);
    freq.put("onc", 66);
    freq.put("ona", 338);
    freq.put("onf", 38);
    freq.put("ong", 3433);
    freq.put("ond", 210);
    freq.put("one", 815);
    freq.put("ony", 311);
    freq.put("ons", 189);
    freq.put("ont", 3237);
    freq.put("¬ ", 1069);
    freq.put("uku", 723);
    freq.put("ukt", 93);
    freq.put("uks", 202);
    freq.put("uko", 42);
    freq.put("ukn", 106);
    freq.put("ukm", 41);
    freq.put("ukk", 145);
    freq.put("uki", 163);
    freq.put("uke", 98);
    freq.put("ukb", 90);
    freq.put("uka", 3409);
    freq.put("on ", 2607);
    freq.put(" Za", 27);
    freq.put(" Zz", 31);
    freq.put("AT ", 76);
    freq.put("uk ", 2847);
    freq.put("sak", 878);
    freq.put("saj", 258);
    freq.put("sai", 365);
    freq.put("sah", 1102);
    freq.put("san", 2614);
    freq.put("sam", 3745);
    freq.put("sal", 1532);
    freq.put("sab", 522);
    freq.put("saa", 687);
    freq.put(" ⌣́", 344);
    freq.put("sag", 49);
    freq.put("saf", 40);
    freq.put("sae", 43);
    freq.put("sad", 144);
    freq.put("say", 1332);
    freq.put(" ˘▿", 24);
    freq.put(" ˘▾", 42);
    freq.put(" ˘▽", 41);
    freq.put("sas", 106);
    freq.put("sar", 897);
    freq.put("sap", 220);
    freq.put("saw", 81);
    freq.put("rmh", 232);
    freq.put("sau", 148);
    freq.put("sat", 626);
    freq.put("zon", 24);
    freq.put("Rp ", 57);
    freq.put("ax ", 55);
    freq.put("sa ", 4965);
    freq.put(" Ce", 266);
    freq.put("˛ ", 107);
    freq.put("اَ", 24);
    freq.put("axi", 27);
    freq.put("Skr", 53);
    freq.put("Ska", 24);
    freq.put("cic", 52);
    freq.put("uu", 3015);
    freq.put("cii", 79);
    freq.put("uv", 30);
    freq.put("⌣ˆ", 63);
    freq.put("us", 6486);
    freq.put("ur", 6425);
    freq.put("um", 5388);
    freq.put(" b ", 161);
    freq.put("ul", 7278);
    freq.put("un", 11608);
    freq.put("ui", 879);
    freq.put("Awa", 61);
    freq.put("uk", 8117);
    freq.put("Nda", 32);
    freq.put("cit", 139);
    freq.put("ciy", 63);
    freq.put(" be", 9087);
    freq.put(" bd", 108);
    freq.put(" bg", 1279);
    freq.put(" ba", 10247);
    freq.put(" bc", 26);
    freq.put(" bb", 350);
    freq.put(" bm", 32);
    freq.put(" bl", 1177);
    freq.put(" bo", 2007);
    freq.put(" bn", 450);
    freq.put(" bi", 4409);
    freq.put(" bh", 106);
    freq.put(" bk", 314);
    freq.put(" bj", 24);
    freq.put(" bu", 4345);
    freq.put(" bt", 137);
    freq.put("s", 89686);
    freq.put(" bp", 25);
    freq.put(" bs", 741);
    freq.put(" br", 1275);
    freq.put(" by", 183);
    freq.put(" ˘⌣", 208);
    freq.put("вм ", 35);
    freq.put("ڡˆ", 24);
    freq.put("fin", 231);
    freq.put("╰", 38);
    freq.put("ڡ˘", 32);
    freq.put("Nyo", 24);
    freq.put("ive", 130);
    freq.put("iva", 62);
    freq.put("ivi", 63);
    freq.put("iv ", 45);
    freq.put("I", 4190);
    freq.put("Mas", 515);
    freq.put("Mar", 154);
    freq.put(" gr", 324);
    freq.put("hx ", 45);
    freq.put("DI ", 29);
    freq.put("gdu", 31);
    freq.put(" gd", 24);
    freq.put("My ", 24);
    freq.put("gd ", 26);
    freq.put(" gn", 73);
    freq.put(" go", 651);
    freq.put(" gl", 45);
    freq.put("NA ", 29);
    freq.put("º", 333);
    freq.put(" ¬˛", 61);
    freq.put(" gk", 470);
    freq.put(" gi", 2013);
    freq.put("eza", 38);
    freq.put("ac ", 26);
    freq.put("jgn", 447);
    freq.put("jga", 115);
    freq.put("ddi", 55);
    freq.put("´", 352);
    freq.put("ddd", 34);
    freq.put("ez ", 34);
    freq.put("tv ", 144);
    freq.put("acc", 74);
    freq.put("aca", 1348);
    freq.put("ace", 463);
    freq.put("jg ", 935);
    freq.put("aci", 163);
    freq.put("ach", 144);
    freq.put("aco", 101);
    freq.put("acu", 49);
    freq.put("act", 50);
    freq.put("dd ", 114);
    freq.put("Ni", 219);
    freq.put("Nn", 37);
    freq.put("No", 234);
    freq.put("Na", 668);
    freq.put("Nd", 66);
    freq.put("Ne", 194);
    freq.put("Ng", 697);
    freq.put("Ny", 269);
    freq.put("Nt", 119);
    freq.put("Nu", 92);
    freq.put("heu", 88);
    freq.put("her", 207);
    freq.put("hes", 37);
    freq.put("hey", 65);
    freq.put("hed", 30);
    freq.put("hee", 282);
    freq.put("в", 84);
    freq.put("hea", 56);
    freq.put("heb", 106);
    freq.put("hec", 27);
    freq.put("hel", 156);
    freq.put("hem", 133);
    freq.put("hen", 156);
    freq.put("heh", 1723);
    freq.put("hei", 47);
    freq.put("hek", 25);
    freq.put("N ", 439);
    freq.put("a²", 30);
    freq.put("he ", 1437);
    freq.put("aa", 16114);
    freq.put("ac", 2864);
    freq.put("ab", 4267);
    freq.put("ae", 1428);
    freq.put("ad", 12448);
    freq.put("ag", 6505);
    freq.put("af", 1690);
    freq.put("ai", 7544);
    freq.put("ah", 43297);
    freq.put("ak", 30512);
    freq.put("aj", 6687);
    freq.put("am", 19968);
    freq.put("al", 22283);
    freq.put("ao", 309);
    freq.put("an", 73068);
    freq.put("aq", 357);
    freq.put("ap", 13531);
    freq.put("as", 16502);
    freq.put("ar", 24850);
    freq.put("au", 9195);
    freq.put("at", 19082);
    freq.put("aw", 2773);
    freq.put("av", 424);
    freq.put("ay", 6477);
    freq.put("ax", 106);
    freq.put("az", 286);
    freq.put("aA", 86);
    freq.put("aH", 25);
    freq.put("aL", 44);
    freq.put("aR", 806);
    freq.put("a ", 96194);
    freq.put("oh ", 1557);
    freq.put("at ", 8505);
    freq.put("cpt", 51);
    freq.put("smu", 158);
    freq.put("mny", 233);
    freq.put("Fit", 123);
    freq.put("mnt", 66);
    freq.put("mnu", 39);
    freq.put("ry", 469);
    freq.put("mni", 55);
    freq.put("sct", 26);
    freq.put("mnd", 32);
    freq.put("mne", 25);
    freq.put("Fil", 43);
    freq.put("scr", 25);
    freq.put("smo", 55);
    freq.put("tz", 32);
    freq.put("ty", 281);
    freq.put("Eaa", 27);
    freq.put("tw", 1139);
    freq.put("tt", 1502);
    freq.put("tu", 13354);
    freq.put("tr", 2472);
    freq.put("ts", 350);
    freq.put("tp", 1152);
    freq.put("tn", 1198);
    freq.put("to", 3579);
    freq.put("tl", 290);
    freq.put("tm", 458);
    freq.put("tj", 31);
    freq.put("tk", 655);
    freq.put("th", 1283);
    freq.put("ti", 13150);
    freq.put("tf", 33);
    freq.put("tg", 580);
    freq.put("td", 707);
    freq.put("te", 11281);
    freq.put("tb", 119);
    freq.put("tc", 79);
    freq.put("ta", 21845);
    freq.put("smi", 140);
    freq.put("rc", 646);
    freq.put("smg", 45);
    freq.put("mn ", 677);
    freq.put("sme", 35);
    freq.put("ri", 12468);
    freq.put(" ̴͡", 41);
    freq.put("rj", 844);
    freq.put("rk", 1109);
    freq.put("t ", 24683);
    freq.put("Sms", 24);
    freq.put("Smo", 27);
    freq.put("Sma", 31);
    freq.put("Sm ", 26);
    freq.put("vic", 25);
    freq.put("via", 294);
    freq.put("vid", 97);
    freq.put("vie", 33);
    freq.put("vin", 113);
    freq.put("vil", 39);
    freq.put("vir", 46);
    freq.put("vis", 45);
    freq.put("vit", 110);
    freq.put("kl ", 205);
    freq.put(" d ", 900);
    freq.put("vi ", 48);
    freq.put("ate", 666);
    freq.put(" do", 2794);
    freq.put(" dn", 75);
    freq.put(" dm", 293);
    freq.put(" dl", 371);
    freq.put(" dk", 165);
    freq.put(" dj", 46);
    freq.put(" di", 13109);
    freq.put(" dh", 161);
    freq.put(" dg", 375);
    freq.put(" de", 4640);
    freq.put(" dd", 45);
    freq.put("kli", 110);
    freq.put(" da", 6216);
    freq.put("klu", 178);
    freq.put(" dy", 157);
    freq.put("kls", 50);
    freq.put(" dw", 39);
    freq.put(" dv", 33);
    freq.put(" du", 1973);
    freq.put(" dt", 166);
    freq.put(" ds", 147);
    freq.put(" dr", 856);
    freq.put(" dp", 384);
    freq.put("RS ", 61);
    freq.put("atr", 101);
    freq.put("itn", 129);
    freq.put("ito", 93);
    freq.put("IP ", 41);
    freq.put("itk", 28);
    freq.put("ith", 83);
    freq.put("iti", 522);
    freq.put("ite", 447);
    freq.put("ita", 2525);
    freq.put("ity", 73);
    freq.put("itt", 441);
    freq.put("itu", 4358);
    freq.put("itr", 315);
    freq.put("its", 60);
    freq.put("̶", 76);
    freq.put("it ", 2314);
    freq.put("cc ", 127);
    freq.put(" A ", 157);
    freq.put("gfu", 27);
    freq.put("gfi", 67);
    freq.put("fta", 58);
    freq.put(" Aa", 174);
    freq.put(" Ab", 162);
    freq.put(" Ac", 65);
    freq.put(" Ad", 715);
    freq.put(" Ag", 95);
    freq.put(" Ah", 421);
    freq.put(" Ai", 143);
    freq.put(" Aj", 63);
    freq.put(" Ak", 977);
    freq.put(" Al", 950);
    freq.put(" Am", 422);
    freq.put(" An", 538);
    freq.put(" Ap", 621);
    freq.put(" Aq", 60);
    freq.put(" Ar", 242);
    freq.put(" As", 479);
    freq.put(" At", 120);
    freq.put(" Au", 47);
    freq.put(" Av", 32);
    freq.put(" Aw", 80);
    freq.put(" Ay", 209);
    freq.put(" Az", 30);
    freq.put("NG ", 158);
    freq.put("duh", 343);
    freq.put("ft ", 75);
    freq.put("w", 20989);
    freq.put("jer", 130);
    freq.put("jep", 51);
    freq.put("aa ", 3998);
    freq.put("jet", 29);
    freq.put("jeu", 29);
    freq.put("jeb", 59);
    freq.put("jed", 32);
    freq.put("jee", 55);
    freq.put("jek", 117);
    freq.put("jeh", 28);
    freq.put("jen", 265);
    freq.put("jel", 396);
    freq.put("jem", 212);
    freq.put("aaR", 68);
    freq.put(" ͡ ", 88);
    freq.put("aad", 67);
    freq.put("aaf", 1221);
    freq.put("aaa", 5213);
    freq.put("aac", 54);
    freq.put("aam", 140);
    freq.put("aal", 123);
    freq.put("aan", 2097);
    freq.put("aai", 33);
    freq.put("aah", 1268);
    freq.put("aak", 313);
    freq.put("aau", 37);
    freq.put("aat", 542);
    freq.put("je ", 268);
    freq.put("aap", 249);
    freq.put("aas", 67);
    freq.put("aar", 139);
    freq.put("aay", 61);
    freq.put("¬˛ ", 36);
    freq.put("bha", 113);
    freq.put("bhs", 44);
    freq.put("ex ", 37);
    freq.put("tp ", 972);
    freq.put("bh ", 173);
    freq.put("M", 6651);
    freq.put("Ist", 52);
    freq.put("Isl", 27);
    freq.put("tpi", 122);
    freq.put("exi", 58);
    freq.put("ext", 50);
    freq.put(" ƪ ", 261);
    freq.put("Hah", 1875);
    freq.put("Hai", 61);
    freq.put("ugi", 55);
    freq.put("ugh", 29);
    freq.put("Hal", 80);
    freq.put("Ham", 42);
    freq.put("Han", 87);
    freq.put("Haa", 63);
    freq.put("Hab", 25);
    freq.put("Had", 103);
    freq.put("uge", 44);
    freq.put("Hay", 77);
    freq.put("oje", 33);
    freq.put("Hap", 140);
    freq.put("ojo", 98);
    freq.put("Har", 412);
    freq.put("Has", 37);
    freq.put("Hat", 88);
    freq.put("ugu", 37);
    freq.put("oji", 24);
    freq.put("cr ", 39);
    freq.put("Ha ", 34);
    freq.put("ug ", 85);
    freq.put("cra", 45);
    freq.put("cre", 51);
    freq.put("cri", 61);
    freq.put("rfo", 31);
    freq.put("sew", 31);
    freq.put("seu", 61);
    freq.put("set", 744);
    freq.put("ses", 787);
    freq.put("ser", 1055);
    freq.put("For", 24);
    freq.put("sep", 928);
    freq.put("sey", 28);
    freq.put("seg", 417);
    freq.put("see", 171);
    freq.put("sed", 514);
    freq.put("sec", 93);
    freq.put("seb", 764);
    freq.put("sea", 105);
    freq.put("Fol", 62);
    freq.put("sen", 1669);
    freq.put("sem", 1922);
    freq.put("sel", 1434);
    freq.put("sek", 1645);
    freq.put("sej", 181);
    freq.put("sei", 41);
    freq.put("seh", 342);
    freq.put("zki", 25);
    freq.put("ªª˘", 30);
    freq.put("pd ", 268);
    freq.put("٥ ", 53);
    freq.put(" ╯ ", 24);
    freq.put("se ", 377);
    freq.put("ˆڡˆ", 24);
    freq.put("pdh", 79);
    freq.put("pda", 131);
    freq.put("nr ", 44);
    freq.put("lex", 24);
    freq.put("tiv", 71);
    freq.put("nrn", 27);
    freq.put("mla", 70);
    freq.put("Ole", 47);
    freq.put("mle", 27);
    freq.put("mlh", 24);
    freq.put("mlm", 110);
    freq.put("⌣ ", 417);
    freq.put("vor", 40);
    freq.put("So ", 39);
    freq.put("kn ", 517);
    freq.put("Soa", 43);
    freq.put("kno", 63);
    freq.put(" fr", 149);
    freq.put(" fu", 148);
    freq.put(" ft", 50);
    freq.put("kni", 27);
    freq.put("kng", 31);
    freq.put("Sok", 63);
    freq.put("Som", 29);
    freq.put("Sol", 45);
    freq.put("kna", 153);
    freq.put(" fa", 614);
    freq.put("Sor", 58);
    freq.put(" fe", 128);
    freq.put("kny", 1098);
    freq.put(" fi", 688);
    freq.put("˘▾˘", 42);
    freq.put(" fl", 105);
    freq.put(" fo", 724);
    freq.put("O ", 531);
    freq.put("amp", 2506);
    freq.put("Oo", 141);
    freq.put("On", 70);
    freq.put("Om", 71);
    freq.put("Ol", 67);
    freq.put("Ok", 323);
    freq.put("Oi", 30);
    freq.put("Oh", 358);
    freq.put("Oa", 31);
    freq.put("tsa", 71);
    freq.put("Oy", 24);
    freq.put("Ow", 48);
    freq.put("Ot", 63);
    freq.put("Or", 170);
    freq.put("Op", 78);
    freq.put("d", 74650);
    freq.put("Kha", 25);
    freq.put("lp ", 66);
    freq.put("b ", 1888);
    freq.put("iju", 53);
    freq.put("˘̩ƪ", 90);
    freq.put("ija", 257);
    freq.put("ije", 39);
    freq.put("iji", 120);
    freq.put("ijo", 41);
    freq.put("⌣́", 347);
    freq.put("⌣̀", 344);
    freq.put("bd", 158);
    freq.put("be", 11813);
    freq.put("bg", 1419);
    freq.put("ba", 19321);
    freq.put("bb", 504);
    freq.put("bc", 47);
    freq.put("bl", 1702);
    freq.put("bm", 230);
    freq.put("bn", 604);
    freq.put("bo", 3249);
    freq.put("bh", 372);
    freq.put("bi", 7886);
    freq.put("bj", 45);
    freq.put("bk", 380);
    freq.put("bt", 272);
    freq.put("bu", 8242);
    freq.put("bw", 210);
    freq.put("bp", 40);
    freq.put("ªªª", 37);
    freq.put("br", 1766);
    freq.put("bs", 946);
    freq.put("by", 374);
    freq.put("bz", 27);
    freq.put("Fu", 40);
    freq.put("bR", 34);
    freq.put(" C ", 57);
    freq.put("ڡ", 56);
    freq.put("ci ", 368);
    freq.put("u ", 34563);
    freq.put("Fe", 50);
    freq.put(" Ck", 86);
    freq.put(" Ch", 129);
    freq.put(" Ci", 528);
    freq.put("BK ", 57);
    freq.put(" Co", 290);
    freq.put(" Cl", 24);
    freq.put(" Cc", 51);
    freq.put(" Ca", 322);
    freq.put("uR", 166);
    freq.put(" Cr", 31);
    freq.put("ʃ˘̩", 30);
    freq.put(" Cu", 214);
    freq.put("▾˘", 42);
    freq.put("cib", 24);
    freq.put("cia", 119);
    freq.put("AC ", 27);
    freq.put("uy", 451);
    freq.put("cie", 196);
    freq.put("uz", 66);
    freq.put("cik", 100);
    freq.put("ut", 5116);
    freq.put("uw", 285);
    freq.put("cih", 94);
    freq.put("up", 2802);
    freq.put("cim", 35);
    freq.put("cil", 332);
    freq.put("cis", 32);
    freq.put("cir", 48);
    freq.put("uo", 63);
    freq.put("cip", 104);
    freq.put("ciw", 25);
    freq.put("uh", 4873);
    freq.put("ciu", 78);
    freq.put("uj", 741);
    freq.put("ue", 3208);
    freq.put("ud", 6586);
    freq.put("ug", 2321);
    freq.put("uf", 194);
    freq.put("ua", 9112);
    freq.put("uc", 780);
    freq.put("ub", 1222);
    freq.put("ag ", 231);
    freq.put("ago", 152);
    freq.put("agn", 29);
    freq.put("agi", 3400);
    freq.put("agh", 90);
    freq.put("agf", 63);
    freq.put("age", 225);
    freq.put("aga", 1263);
    freq.put("agu", 922);
    freq.put("agr", 60);
    freq.put("Jia", 52);
    freq.put("Jik", 51);
    freq.put("tr ", 174);
    freq.put("tri", 743);
    freq.put("evi", 87);
    freq.put("tro", 175);
    freq.put("trn", 36);
    freq.put("tra", 536);
    freq.put("eva", 24);
    freq.put("tre", 225);
    freq.put("eve", 119);
    freq.put(" з´", 42);
    freq.put("trs", 122);
    freq.put("tru", 335);
    freq.put("le ", 565);
    freq.put("ody", 66);
    freq.put("uen", 34);
    freq.put("ueh", 37);
    freq.put("uek", 59);
    freq.put("uee", 63);
    freq.put("odu", 51);
    freq.put("Blm", 37);
    freq.put("odi", 65);
    freq.put("odo", 324);
    freq.put("oda", 277);
    freq.put("Bla", 47);
    freq.put("ode", 153);
    freq.put("ues", 29);
    freq.put("uer", 25);
    freq.put("ct ", 93);
    freq.put("rd ", 101);
    freq.put("lea", 111);
    freq.put("leb", 2123);
    freq.put("lec", 24);
    freq.put("led", 78);
    freq.put("lee", 213);
    freq.put("leg", 65);
    freq.put("leh", 1012);
    freq.put("lek", 511);
    freq.put("lel", 103);
    freq.put("ue ", 2830);
    freq.put("len", 368);
    freq.put("lep", 132);
    freq.put("ler", 168);
    freq.put("les", 924);
    freq.put("let", 163);
    freq.put("leu", 50);
    freq.put("lev", 51);
    freq.put("lew", 211);
    freq.put("od ", 185);
    freq.put("ley", 24);
    freq.put("̴̴ ", 82);
    freq.put("rdu", 143);
    freq.put("ctv", 28);
    freq.put("rde", 88);
    freq.put("rda", 151);
    freq.put("rdo", 40);
    freq.put("rdi", 110);
    freq.put("cti", 55);
    freq.put("sga", 26);
    freq.put("zin", 367);
    freq.put("zil", 25);
    freq.put("sg ", 94);
    freq.put("np ", 391);
    freq.put("˘⌣", 214);
    freq.put("npa", 223);
    freq.put("Ɨƚɑ", 43);
    freq.put("Q", 114);
    freq.put("npu", 35);
    freq.put("mjb", 55);
    freq.put("Ya", 1255);
    freq.put("Ayo", 153);
    freq.put("Aya", 32);
    freq.put("Д", 166);
    freq.put("kp ", 30);
    freq.put(" h ", 33);
    freq.put(" ¯٥", 25);
    freq.put("Sak", 112);
    freq.put(" hy", 34);
    freq.put("Sah", 58);
    freq.put("San", 94);
    freq.put("Sam", 407);
    freq.put("Sal", 163);
    freq.put(" hr", 285);
    freq.put("Saa", 84);
    freq.put(" hp", 200);
    freq.put(" hu", 694);
    freq.put(" ht", 49);
    freq.put("kpa", 66);
    freq.put(" hi", 874);
    freq.put(" hh", 461);
    freq.put(" ho", 479);
    freq.put(" hn", 36);
    freq.put(" hm", 170);
    freq.put("Sar", 53);
    freq.put(" ha", 9311);
    freq.put("Sap", 44);
    freq.put(" he", 1799);
    freq.put("kpo", 32);
    freq.put("IT ", 38);
    freq.put("ihu", 36);
    freq.put("ihk", 41);
    freq.put("┐ ", 198);
    freq.put("ihi", 577);
    freq.put("ihn", 38);
    freq.put("iha", 579);
    freq.put("ihR", 30);
    freq.put("UN ", 25);
    freq.put("ih ", 7312);
    freq.put("mna", 294);
    freq.put(" E ", 40);
    freq.put("ck ", 674);
    freq.put("˘̶́", 29);
    freq.put("˘̶̀", 27);
    freq.put(" El", 84);
    freq.put(" Em", 375);
    freq.put(" En", 333);
    freq.put(" Eh", 422);
    freq.put(" Ei", 39);
    freq.put(" Ed", 35);
    freq.put(" Ee", 45);
    freq.put(" Ea", 40);
    freq.put("̴̴̴", 199);
    freq.put("ɑ", 376);
    freq.put(" Ex", 36);
    freq.put(" Et", 36);
    freq.put(" Er", 47);
    freq.put("cke", 48);
    freq.put("AA ", 48);
    freq.put("ckc", 404);
    freq.put("ʃ⌣", 116);
    freq.put("cki", 46);
    freq.put("ckk", 26);
    freq.put(" ۳", 48);
    freq.put(" ¯ ", 33);
    freq.put(" ┌П", 50);
    freq.put("KI ", 30);
    freq.put("⌣˘ ", 197);
    freq.put("jay", 78);
    freq.put("mng", 131);
    freq.put("jaw", 197);
    freq.put("jat", 282);
    freq.put("jau", 292);
    freq.put("jar", 741);
    freq.put("jas", 55);
    freq.put("jan", 1164);
    freq.put("ae ", 451);
    freq.put("jal", 844);
    freq.put("jam", 1220);
    freq.put("jaj", 62);
    freq.put("jak", 922);
    freq.put("jah", 395);
    freq.put("jai", 170);
    freq.put("jag", 200);
    freq.put("jad", 1930);
    freq.put("jab", 52);
    freq.put("jaa", 301);
    freq.put("ayo", 352);
    freq.put("aer", 109);
    freq.put("h", 100481);
    freq.put("aee", 25);
    freq.put("aek", 151);
    freq.put("aem", 58);
    freq.put("ael", 86);
    freq.put("ja ", 4379);
    freq.put("aen", 423);
    freq.put("Pr", 254);
    freq.put("Ps", 25);
    freq.put("btw", 73);
    freq.put("Jgn", 182);
    freq.put("Pu", 409);
    freq.put("oma", 259);
    freq.put("Pa", 1291);
    freq.put("OP ", 26);
    freq.put("Pg", 33);
    freq.put("Pd", 44);
    freq.put("Pe", 1296);
    freq.put("Ph", 28);
    freq.put("Pi", 192);
    freq.put("Pn", 34);
    freq.put("Po", 199);
    freq.put("Pl", 113);
    freq.put("ا", 51);
    freq.put("et ", 4248);
    freq.put("tl ", 26);
    freq.put("̴ ", 107);
    freq.put("lf", 197);
    freq.put("lg", 1698);
    freq.put("P ", 599);
    freq.put("le", 7887);
    freq.put("bt ", 37);
    freq.put("qt ", 50);
    freq.put("lb", 506);
    freq.put("lc", 42);
    freq.put("etr", 127);
    freq.put("ets", 55);
    freq.put("tlp", 28);
    freq.put("etw", 116);
    freq.put("ett", 201);
    freq.put("etu", 485);
    freq.put("ety", 28);
    freq.put("ln", 761);
    freq.put("tla", 103);
    freq.put("eta", 1278);
    freq.put("tle", 36);
    freq.put("lo", 8007);
    freq.put("eth", 31);
    freq.put("eti", 840);
    freq.put("etn", 121);
    freq.put("eto", 112);
    freq.put("ck", 1496);
    freq.put("ucu", 277);
    freq.put("ch", 1064);
    freq.put("co", 4556);
    freq.put("cn", 47);
    freq.put("cm", 219);
    freq.put("cl", 118);
    freq.put("cc", 258);
    freq.put("cb", 34);
    freq.put("lg ", 1376);
    freq.put("Hey", 58);
    freq.put("ce", 2980);
    freq.put("cd", 46);
    freq.put("Hee", 71);
    freq.put("cy", 126);
    freq.put("uca", 135);
    freq.put("uco", 24);
    freq.put("cr", 263);
    freq.put("cp", 97);
    freq.put("uck", 55);
    freq.put("uci", 196);
    freq.put("uch", 56);
    freq.put("Ger", 29);
    freq.put("lr", 55);
    freq.put("Gen", 30);
    freq.put("Gem", 38);
    freq.put("rb ", 139);
    freq.put("lgi", 134);
    freq.put("lp", 195);
    freq.put("lga", 25);
    freq.put("He ", 26);
    freq.put("lgs", 85);
    freq.put("rbu", 204);
    freq.put("rbo", 37);
    freq.put("rbi", 101);
    freq.put("rbe", 119);
    freq.put("ly", 287);
    freq.put("rba", 534);
    freq.put("va", 424);
    freq.put("vd", 36);
    freq.put("ve", 756);
    freq.put("╥﹏╥", 63);
    freq.put("vi", 911);
    freq.put("ph ", 31);
    freq.put("  ", 42);
    freq.put("vo", 175);
    freq.put("vs", 80);
    freq.put("vy", 48);
    freq.put("of ", 62);
    freq.put("▿˘", 38);
    freq.put("v ", 363);
    freq.put("Lal", 51);
    freq.put("pho", 73);
    freq.put("yon", 103);
    freq.put("yok", 222);
    freq.put("off", 90);
    freq.put("Lad", 24);
    freq.put(" ̗ ", 27);
    freq.put("web", 33);
    freq.put("wee", 498);
    freq.put("wed", 42);
    freq.put("wek", 217);
    freq.put("weh", 203);
    freq.put("Oh ", 258);
    freq.put("wen", 59);
    freq.put("mh ", 269);
    freq.put("wel", 92);
    freq.put("wes", 181);
    freq.put("wer", 105);
    freq.put("wew", 52);
    freq.put("wet", 67);
    freq.put("▽", 386);
    freq.put("̾", 101);
    freq.put("Sai", 59);
    freq.put("nvy", 34);
    freq.put("nvi", 48);
    freq.put("mhn", 26);
    freq.put("we ", 439);
    freq.put("Ohh", 55);
    freq.put("Sab", 172);
    freq.put("Say", 197);
    freq.put("kr ", 30);
    freq.put(" j ", 24);
    freq.put("П┐ ", 33);
    freq.put("lle", 53);
    freq.put("vs ", 76);
    freq.put(" hb", 50);
    freq.put(" ju", 2483);
    freq.put(" jt", 29);
    freq.put(" jw", 37);
    freq.put(" jr", 37);
    freq.put("krj", 28);
    freq.put(" jl", 103);
    freq.put(" jo", 559);
    freq.put("kri", 214);
    freq.put("krn", 246);
    freq.put("kpn", 161);
    freq.put(" jk", 93);
    freq.put("krm", 25);
    freq.put(" je", 943);
    freq.put(" jd", 908);
    freq.put(" jg", 1501);
    freq.put("kra", 93);
    freq.put(" ja", 5463);
    freq.put("krg", 350);
    freq.put("kre", 62);
    freq.put("Kl ", 36);
    freq.put(" ː̖", 36);
    freq.put("˘▾", 42);
    freq.put("˘▿", 32);
    freq.put("˘▽", 64);
    freq.put("̩̩ ", 870);
    freq.put("Klo", 143);
    freq.put("ƪ˘ ", 45);
    freq.put("▿ ", 253);
    freq.put("OO ", 24);
    freq.put("int", 1885);
    freq.put("inu", 257);
    freq.put("inv", 48);
    freq.put("ins", 261);
    freq.put("inl", 26);
    freq.put("inn", 425);
    freq.put("ino", 71);
    freq.put("inh", 32);
    freq.put("ini", 4505);
    freq.put("inj", 130);
    freq.put("ink", 271);
    freq.put("ind", 1132);
    freq.put("ine", 392);
    freq.put("inf", 136);
    freq.put("ing", 6513);
    freq.put("ina", 1085);
    freq.put("inc", 100);
    freq.put("eo ", 91);
    freq.put("̩̩͡", 40);
    freq.put("̴̴", 320);
    freq.put("cˇ", 51);
    freq.put("inR", 38);
    freq.put("DA ", 27);
    freq.put("ّ", 49);
    freq.put("U", 1425);
    freq.put("in ", 10538);
    freq.put("eon", 103);
    freq.put("eor", 196);
    freq.put("hp ", 182);
    freq.put("Tur", 43);
    freq.put("̴͡", 24);
    freq.put("aln", 332);
    freq.put("AH ", 123);
    freq.put("MA ", 102);
    freq.put(" G ", 108);
    freq.put("Tuh", 243);
    freq.put("alh", 253);
    freq.put("cm ", 139);
    freq.put("ald", 71);
    freq.put(" Gw", 257);
    freq.put(" Gu", 546);
    freq.put(" Gr", 97);
    freq.put("cwo", 27);
    freq.put(" Gp", 66);
    freq.put(" ˚", 134);
    freq.put(" Ge", 196);
    freq.put(" Ga", 1495);
    freq.put(" Go", 206);
    freq.put(" Gl", 31);
    freq.put(" Gm", 41);
    freq.put(" Gk", 83);
    freq.put(" Gi", 208);
    freq.put("cwe", 38);
    freq.put("cma", 41);
    freq.put("Tug", 27);
    freq.put(" ", 57);
    freq.put(" ", 77);
    freq.put("fa ", 61);
    freq.put("alu", 1250);
    freq.put("gl ", 315);
    freq.put("ak ", 12653);
    freq.put("akR", 60);
    freq.put(" ˆ▽", 29);
    freq.put("Cr", 31);
    freq.put("gli", 41);
    freq.put("aky", 66);
    freq.put("glo", 28);
    freq.put("aks", 612);
    freq.put("gla", 93);
    freq.put("akp", 27);
    freq.put("akw", 49);
    freq.put("gle", 107);
    freq.put("aku", 4402);
    freq.put("akt", 768);
    freq.put("akk", 391);
    freq.put("akj", 24);
    freq.put("aki", 1409);
    freq.put("akh", 584);
    freq.put("ako", 75);
    freq.put("akn", 614);
    freq.put("akm", 61);
    freq.put("akl", 77);
    freq.put("akb", 329);
    freq.put("aka", 6535);
    freq.put("ake", 1379);
    freq.put("akd", 43);
    freq.put("Jer", 24);
    freq.put("bru", 203);
    freq.put("brr", 30);
    freq.put("brp", 217);
    freq.put("bro", 343);
    freq.put("brn", 43);
    freq.put("bri", 87);
    freq.put("brg", 67);
    freq.put("bre", 119);
    freq.put("brb", 32);
    freq.put("Jel", 46);
    freq.put("▽˘", 66);
    freq.put("▽ˇ", 33);
    freq.put("▽ˆ", 31);
    freq.put("er ", 3550);
    freq.put("tn ", 176);
    freq.put("is", 8615);
    freq.put("nka", 237);
    freq.put("Nai", 40);
    freq.put("nke", 45);
    freq.put("iu", 624);
    freq.put("nkk", 26);
    freq.put("nks", 128);
    freq.put("nku", 198);
    freq.put("Nam", 78);
    freq.put("br ", 123);
    freq.put("ert", 1501);
    freq.put("eru", 1399);
    freq.put("erv", 35);
    freq.put("erw", 32);
    freq.put("erp", 320);
    freq.put("err", 239);
    freq.put("ers", 1082);
    freq.put("tny", 780);
    freq.put("ery", 45);
    freq.put("erd", 368);
    freq.put("ere", 1200);
    freq.put("erf", 74);
    freq.put("erg", 421);
    freq.put("tna", 45);
    freq.put("era", 3786);
    freq.put("erb", 783);
    freq.put("erc", 390);
    freq.put("erl", 600);
    freq.put("erm", 361);
    freq.put("ern", 1246);
    freq.put("ero", 209);
    freq.put("erh", 426);
    freq.put("eri", 2304);
    freq.put("erj", 756);
    freq.put("erk", 515);
    freq.put("Aba", 27);
    freq.put("Tp ", 203);
    freq.put("Abi", 95);
    freq.put("uas", 985);
    freq.put("uar", 1002);
    freq.put("la ", 1574);
    freq.put("uat", 2101);
    freq.put("uai", 55);
    freq.put("ia", 11997);
    freq.put("uak", 119);
    freq.put("uam", 72);
    freq.put("ual", 342);
    freq.put("м ", 39);
    freq.put("uan", 1223);
    freq.put("uaa", 173);
    freq.put("uac", 36);
    freq.put("ki ", 849);
    freq.put("lal", 1075);
    freq.put("lam", 2905);
    freq.put("lan", 4525);
    freq.put("lah", 7751);
    freq.put("lai", 1094);
    freq.put("laj", 268);
    freq.put("lak", 880);
    freq.put("lad", 69);
    freq.put("lae", 46);
    freq.put("laf", 32);
    freq.put("lag", 2510);
    freq.put("laa", 429);
    freq.put("lab", 96);
    freq.put("lac", 69);
    freq.put("lay", 363);
    freq.put("lat", 825);
    freq.put("ua ", 2468);
    freq.put("law", 176);
    freq.put("lap", 476);
    freq.put("lar", 327);
    freq.put("las", 1102);
    freq.put("uwi", 56);
    freq.put("fan", 236);
    freq.put("faa", 37);
    freq.put("۳ ", 28);
    freq.put("mbl", 177);
    freq.put("l", 84192);
    freq.put("́", 493);
    freq.put("┒ ", 36);
    freq.put("nt ", 2803);
    freq.put("ntr", 277);
    freq.put("ntu", 1772);
    freq.put("nti", 2524);
    freq.put("nth", 31);
    freq.put("ɐ ", 35);
    freq.put("nto", 764);
    freq.put("Pdh", 24);
    freq.put("nta", 3624);
    freq.put("nte", 1246);
    freq.put(" l ", 85);
    freq.put("i ", 41915);
    freq.put("TU ", 26);
    freq.put("kt ", 296);
    freq.put(" lg", 1355);
    freq.put(" le", 2963);
    freq.put("B", 6377);
    freq.put(" lb", 204);
    freq.put(" la", 7227);
    freq.put(" lo", 2547);
    freq.put(" ln", 27);
    freq.put(" lm", 31);
    freq.put(" li", 1634);
    freq.put(" lh", 352);
    freq.put(" lw", 97);
    freq.put(" lu", 2391);
    freq.put("Set", 157);
    freq.put("Ses", 130);
    freq.put("ɐƗ", 69);
    freq.put("Sep", 196);
    freq.put("ktu", 519);
    freq.put("Seg", 46);
    freq.put("ktm", 50);
    freq.put("See", 25);
    freq.put("Sed", 71);
    freq.put("kti", 347);
    freq.put("Seo", 28);
    freq.put("kte", 143);
    freq.put("Sem", 472);
    freq.put("Sel", 586);
    freq.put("Sek", 161);
    freq.put("kta", 139);
    freq.put("Seh", 33);
    freq.put("Q ", 51);
    freq.put("ʃ⌣ƪ", 115);
    freq.put("ter", 4035);
    freq.put("teu", 194);
    freq.put("Kna", 42);
    freq.put("▽ ", 236);
    freq.put("Knp", 140);
    freq.put("╯", 40);
    freq.put("yp ", 30);
    freq.put("ввм", 40);
    freq.put("Ơ̴͡", 98);
    freq.put("yeh", 86);
    freq.put("ude", 147);
    freq.put("d ", 5497);
    freq.put("̩͡", 40);
    freq.put("em ", 1437);
    freq.put("hru", 33);
    freq.put(" ̾", 42);
    freq.put(" ► ", 29);
    freq.put("hrs", 87);
    freq.put("hri", 226);
    freq.put("hra", 137);
    freq.put("dn", 357);
    freq.put("do", 4656);
    freq.put("dl", 515);
    freq.put("dm", 448);
    freq.put("dj", 73);
    freq.put("dk", 440);
    freq.put("dh", 1671);
    freq.put("di", 20778);
    freq.put("dg", 523);
    freq.put("dd", 285);
    freq.put("de", 7198);
    freq.put("db", 99);
    freq.put("dc", 44);
    freq.put("da", 22163);
    freq.put("dz", 387);
    freq.put("dy", 469);
    freq.put("dv", 40);
    freq.put("dw", 139);
    freq.put("dt", 195);
    freq.put("du", 6463);
    freq.put("dr", 1313);
    freq.put("ds", 230);
    freq.put("dp", 430);
    freq.put("eme", 1155);
    freq.put("emg", 329);
    freq.put("ema", 3075);
    freq.put("emb", 1714);
    freq.put("emm", 108);
    freq.put("emo", 693);
    freq.put("emn", 65);
    freq.put("emi", 589);
    freq.put("emu", 1606);
    freq.put("emp", 1053);
    freq.put("hr ", 225);
    freq.put("̅", 35);
    freq.put("w ", 4473);
    freq.put(" I ", 236);
    freq.put("il ", 1667);
    freq.put("xD ", 61);
    freq.put("co ", 99);
    freq.put("dsn", 35);
    freq.put("wg", 33);
    freq.put(" Iy", 1077);
    freq.put("we", 2098);
    freq.put("wd", 46);
    freq.put("wb", 93);
    freq.put("wa", 5446);
    freq.put("wo", 988);
    freq.put("wn", 183);
    freq.put(" Ir", 86);
    freq.put(" Is", 169);
    freq.put(" It", 316);
    freq.put("bny", 226);
    freq.put("wi", 1397);
    freq.put("wh", 196);
    freq.put(" Ih", 163);
    freq.put(" Ii", 47);
    freq.put("wu", 186);
    freq.put(" Ik", 134);
    freq.put(" Il", 25);
    freq.put(" Im", 39);
    freq.put(" In", 1155);
    freq.put(" Ia", 66);
    freq.put(" Ib", 61);
    freq.put(" Id", 200);
    freq.put(" Ie", 27);
    freq.put("cop", 63);
    freq.put("ild", 27);
    freq.put("ile", 249);
    freq.put("ilb", 34);
    freq.put("cot", 66);
    freq.put("cow", 243);
    freq.put("ila", 2051);
    freq.put("iln", 76);
    freq.put("ilo", 60);
    freq.put("ill", 817);
    freq.put("ilm", 282);
    freq.put("ilk", 41);
    freq.put("ili", 671);
    freq.put("coa", 27);
    freq.put("▼ˇ", 49);
    freq.put("coc", 90);
    freq.put("ilu", 79);
    freq.put("wR", 50);
    freq.put("bnr", 70);
    freq.put("cok", 183);
    freq.put("com", 177);
    freq.put("col", 113);
    freq.put("coo", 58);
    freq.put("ily", 35);
    freq.put("̮", 230);
    freq.put("gn ", 1095);
    freq.put("ai ", 1906);
    freq.put("aiy", 48);
    freq.put("gnt", 46);
    freq.put("aiz", 40);
    freq.put("bng", 99);
    freq.put("gny", 654);
    freq.put("aip", 68);
    freq.put("ais", 58);
    freq.put("air", 234);
    freq.put("aim", 151);
    freq.put("ail", 158);
    freq.put("ET ", 76);
    freq.put("gna", 25);
    freq.put("aii", 115);
    freq.put("aih", 66);
    freq.put("aik", 1150);
    freq.put("gne", 24);
    freq.put("aid", 481);
    freq.put("gni", 50);
    freq.put("aia", 80);
    freq.put("aic", 45);
    freq.put("aib", 38);
    freq.put("ni ", 5448);
    freq.put("Iku", 81);
    freq.put("̯", 241);
    freq.put("ep ", 643);
    freq.put("th ", 267);
    freq.put("nik", 402);
    freq.put("nih", 1551);
    freq.put("nii", 174);
    freq.put("nin", 900);
    freq.put("nio", 54);
    freq.put("nil", 152);
    freq.put("nim", 104);
    freq.put("nic", 110);
    freq.put("nia", 549);
    freq.put("nid", 27);
    freq.put("nie", 79);
    freq.put("niy", 25);
    freq.put("Y", 2324);
    freq.put("nis", 395);
    freq.put("nip", 44);
    freq.put("niv", 49);
    freq.put("nit", 419);
    freq.put("thx", 24);
    freq.put("ept", 163);
    freq.put("epu", 177);
    freq.put("epr", 38);
    freq.put("eps", 66);
    freq.put("epp", 31);
    freq.put("tho", 35);
    freq.put("epo", 248);
    freq.put("epl", 60);
    freq.put("thi", 168);
    freq.put("epi", 471);
    freq.put("the", 256);
    freq.put("epe", 765);
    freq.put("tha", 205);
    freq.put("epa", 1127);
    freq.put("ʃ", 576);
    freq.put("rn ", 328);
    freq.put("Gay", 30);
    freq.put("Gau", 35);
    freq.put("Gat", 54);
    freq.put("Gar", 97);
    freq.put("Gap", 52);
    freq.put("Gan", 74);
    freq.put("Gam", 41);
    freq.put("Gal", 109);
    freq.put("Gak", 327);
    freq.put("Gaj", 25);
    freq.put("Gag", 44);
    freq.put("Gad", 30);
    freq.put("Gab", 38);
    freq.put("Tri", 39);
    freq.put("rni", 90);
    freq.put("rnh", 43);
    freq.put("rno", 33);
    freq.put("Tra", 57);
    freq.put("rna", 995);
    freq.put("rng", 157);
    freq.put("rne", 71);
    freq.put("rny", 1251);
    freq.put("لّه", 35);
    freq.put(" ۳ ", 28);
    freq.put("Tru", 64);
    freq.put("Ga ", 478);
    freq.put("ƚ", 47);
    freq.put("Leb", 411);
    freq.put("Lee", 28);
    freq.put("Ara", 33);
    freq.put("cˇ ", 46);
    freq.put("ykn", 88);
    freq.put("ob ", 100);
    freq.put("plu", 52);
    freq.put("plg", 112);
    freq.put("ple", 171);
    freq.put("pla", 257);
    freq.put("plo", 110);
    freq.put("pli", 174);
    freq.put("obo", 178);
    freq.put("obl", 47);
    freq.put("yk ", 386);
    freq.put("obi", 247);
    freq.put("obe", 69);
    freq.put("obb", 30);
    freq.put("oba", 675);
    freq.put("obr", 70);
    freq.put("Cur", 33);
    freq.put("Cum", 80);
    freq.put("Cuk", 24);
    freq.put("wan", 660);
    freq.put("wam", 30);
    freq.put("wal", 620);
    freq.put("wak", 797);
    freq.put("waj", 94);
    freq.put("wai", 125);
    freq.put("wah", 474);
    freq.put("wae", 124);
    freq.put("wad", 67);
    freq.put("wab", 150);
    freq.put("waa", 179);
    freq.put("way", 77);
    freq.put("waw", 49);
    freq.put("mt ", 28);
    freq.put("wat", 425);
    freq.put("was", 230);
    freq.put("war", 329);
    freq.put("xy ", 32);
    freq.put("wa ", 947);
    freq.put(" n ", 245);
    freq.put("Sat", 70);
    freq.put(" ni", 2798);
    freq.put(" nh", 59);
    freq.put(" nj", 76);
    freq.put(" nm", 61);
    freq.put(" no", 971);
    freq.put(" nn", 229);
    freq.put(" na", 3058);
    freq.put(" ne", 1104);
    freq.put(" nd", 564);
    freq.put(" ng", 5161);
    freq.put(" ny", 3724);
    freq.put(" nu", 588);
    freq.put(" nt", 663);
    freq.put("Sk", 107);
    freq.put("ums", 55);
    freq.put("Tia", 58);
    freq.put("gu ", 1185);
    freq.put("ɑƗ", 217);
    freq.put("umm", 70);
    freq.put("umo", 31);
    freq.put("Kpn", 37);
    freq.put("guc", 61);
    freq.put("gub", 45);
    freq.put("gua", 1181);
    freq.put("gue", 2487);
    freq.put("gud", 55);
    freq.put("guk", 44);
    freq.put("gui", 76);
    freq.put("guh", 134);
    freq.put("gun", 1153);
    freq.put("gum", 141);
    freq.put("gul", 136);
    freq.put("gus", 525);
    freq.put("p", 59599);
    freq.put("gup", 51);
    freq.put("guu", 31);
    freq.put("gut", 35);
    freq.put("guy", 63);
    freq.put(" ˘ڡ", 31);
    freq.put("OK ", 53);
    freq.put("htt", 33);
    freq.put("IN ", 69);
    freq.put("ek ", 3018);
    freq.put("ht ", 79);
    freq.put("ˆ▽ˆ", 30);
    freq.put("﹏", 95);
    freq.put("нª", 27);
    freq.put("eko", 419);
    freq.put("ekn", 140);
    freq.put("ekk", 145);
    freq.put("eki", 246);
    freq.put("eke", 503);
    freq.put("eka", 1874);
    freq.put("˛⌣", 25);
    freq.put("eku", 119);
    freq.put("ekt", 64);
    freq.put("eks", 255);
    freq.put("ekr", 25);
    freq.put(" is", 602);
    freq.put("┈", 26);
    freq.put("kse", 204);
    freq.put(" Ka", 2446);
    freq.put(" Kg", 27);
    freq.put(" Ke", 1531);
    freq.put("ib ", 277);
    freq.put(" Kh", 41);
    freq.put(" Ki", 305);
    freq.put(" Kn", 200);
    freq.put(" Ko", 546);
    freq.put(" Kl", 226);
    freq.put(" Km", 160);
    freq.put(" Kr", 78);
    freq.put(" Kp", 54);
    freq.put(" ik", 963);
    freq.put(" Kw", 24);
    freq.put(" Ku", 305);
    freq.put(" il", 205);
    freq.put(" Ky", 88);
    freq.put("Mon", 24);
    freq.put("F", 1015);
    freq.put("﹏╥", 64);
    freq.put("fb ", 103);
    freq.put("Mob", 32);
    freq.put("kso", 75);
    freq.put("ibi", 215);
    freq.put(" K ", 48);
    freq.put("ibl", 29);
    freq.put("ibo", 61);
    freq.put("cas", 54);
    freq.put("iba", 774);
    freq.put("cap", 357);
    freq.put("ibe", 228);
    freq.put("cau", 51);
    freq.put(" ie", 124);
    freq.put("cak", 283);
    freq.put("cai", 25);
    freq.put("cah", 182);
    freq.put("can", 754);
    freq.put("cam", 216);
    freq.put("cal", 131);
    freq.put("cac", 59);
    freq.put("cab", 98);
    freq.put("caa", 64);
    freq.put("AK ", 99);
    freq.put("ibu", 1017);
    freq.put("cad", 33);
    freq.put("ao ", 70);
    freq.put("spr", 36);
    freq.put("spi", 66);
    freq.put("spo", 79);
    freq.put("spa", 118);
    freq.put("spe", 152);
    freq.put("gh ", 110);
    freq.put("aon", 108);
    freq.put("aol", 29);
    freq.put("aos", 37);
    freq.put("sp ", 26);
    freq.put("ght", 83);
    freq.put("ghu", 33);
    freq.put("ghr", 32);
    freq.put("ghf", 55);
    freq.put("ER ", 58);
    freq.put("gha", 159);
    freq.put("ghh", 47);
    freq.put("ghi", 101);
    freq.put("Ru", 161);
    freq.put(" ̀ ", 68);
    freq.put("Rp", 60);
    freq.put("Che", 33);
    freq.put("Chi", 27);
    freq.put("Jat", 29);
    freq.put("Jau", 29);
    freq.put("no ", 434);
    freq.put("Jan", 340);
    freq.put("Re", 289);
    freq.put("Jal", 112);
    freq.put("sob", 45);
    freq.put("Ra", 551);
    freq.put("Jah", 52);
    freq.put("Jad", 282);
    freq.put("Ro", 98);
    freq.put("Ri", 182);
    freq.put("sod", 153);
    freq.put("nol", 68);
    freq.put("nom", 122);
    freq.put("non", 501);
    freq.put("noh", 48);
    freq.put("nok", 46);
    freq.put("mba", 1978);
    freq.put("R ", 635);
    freq.put("not", 68);
    freq.put("˛", 211);
    freq.put("now", 43);
    freq.put("nop", 41);
    freq.put("nor", 99);
    freq.put("em", 11935);
    freq.put("el", 10968);
    freq.put("eo", 472);
    freq.put("en", 23976);
    freq.put("ei", 447);
    freq.put("eh", 8472);
    freq.put("ek", 6976);
    freq.put("ej", 793);
    freq.put("ee", 5380);
    freq.put("ed", 2766);
    freq.put("eg", 2002);
    freq.put("ef", 190);
    freq.put("ea", 1571);
    freq.put("rl ", 44);
    freq.put("ec", 1275);
    freq.put("eb", 5635);
    freq.put("ey", 659);
    freq.put("ex", 200);
    freq.put("ez", 123);
    freq.put("lm ", 869);
    freq.put("et", 9092);
    freq.put("ew", 1255);
    freq.put("ev", 278);
    freq.put("eq", 43);
    freq.put("ep", 3856);
    freq.put("es", 7198);
    freq.put("er", 21796);
    freq.put("eR", 196);
    freq.put("rli", 82);
    freq.put("rle", 77);
    freq.put("rla", 367);
    freq.put("lmu", 53);
    freq.put("lmi", 29);
    freq.put("lmn", 38);
    freq.put("rlu", 171);
    freq.put("lma", 68);
    freq.put("hh ", 2054);
    freq.put("usk", 37);
    freq.put("zan", 68);
    freq.put("btu", 99);
    freq.put("zal", 33);
    freq.put("zam", 25);
    freq.put("zak", 37);
    freq.put("zah", 28);
    freq.put("xx", 42);
    freq.put("xy", 39);
    freq.put("ºДº", 123);
    freq.put("pn ", 289);
    freq.put("xp", 35);
    freq.put("zar", 64);
    freq.put("xt", 59);
    freq.put("yia", 46);
    freq.put("yim", 49);
    freq.put("yin", 101);
    freq.put("yii", 68);
    freq.put("yik", 75);
    freq.put("pny", 186);
    freq.put("x ", 742);
    freq.put("pnt", 39);
    freq.put("za ", 123);
    freq.put("png", 84);
    freq.put("Btw", 30);
    freq.put("yi ", 226);
    freq.put(" ┌ ", 131);
    freq.put("Lg ", 85);
    freq.put("нªª", 27);
    freq.put("mr ", 59);
    freq.put("mrn", 106);
    freq.put("mri", 33);
    freq.put("mrk", 36);
    freq.put("mre", 81);
    freq.put("Wee", 31);
    freq.put("Wes", 39);
    freq.put(" p ", 1779);
    freq.put("Wew", 24);
    freq.put(" ps", 143);
    freq.put(" pr", 931);
    freq.put(" pp", 32);
    freq.put(" pu", 3054);
    freq.put(" pt", 37);
    freq.put(" pc", 62);
    freq.put(" pa", 6726);
    freq.put(" pg", 120);
    freq.put(" pe", 5890);
    freq.put(" pd", 331);
    freq.put(" pk", 195);
    freq.put(" pi", 1337);
    freq.put(" ph", 53);
    freq.put(" po", 923);
    freq.put(" pn", 261);
    freq.put(" pm", 51);
    freq.put(" pl", 531);
    freq.put(" pR", 201);
    freq.put("º̩̩", 24);
    freq.put("gw ", 2030);
    freq.put(" ˘ʃ", 44);
    freq.put("Kri", 27);
    freq.put("Krn", 25);
    freq.put(" ˘̩", 487);
    freq.put(" ˘̶", 37);
    freq.put("ih", 9127);
    freq.put("ei ", 106);
    freq.put(" ˘͡", 137);
    freq.put("eii", 30);
    freq.put("ein", 128);
    freq.put("yh", 71);
    freq.put("yk", 516);
    freq.put("SD ", 96);
    freq.put("yl", 80);
    freq.put(" Me", 1020);
    freq.put(" Ma", 3149);
    freq.put(" Mb", 107);
    freq.put(" Mm", 27);
    freq.put(" Mn", 40);
    freq.put(" Mo", 380);
    freq.put(" Mi", 581);
    freq.put(" Mk", 51);
    freq.put(" Mu", 506);
    freq.put(" Mw", 26);
    freq.put(" Mr", 38);
    freq.put(" Ms", 59);
    freq.put(" My", 26);
    freq.put("yb", 78);
    freq.put("ye", 2191);
    freq.put("ete", 1202);
    freq.put("rwo", 25);
    freq.put("tli", 28);
    freq.put("yy", 500);
    freq.put(" M ", 58);
    freq.put("cce", 31);
    freq.put("am ", 3106);
    freq.put("ps ", 216);
    freq.put(" ˘ ", 406);
    freq.put("ci", 2795);
    freq.put("ca", 4657);
    freq.put("ami", 1084);
    freq.put("amk", 40);
    freq.put("psi", 64);
    freq.put("amm", 131);
    freq.put("amo", 80);
    freq.put("amn", 80);
    freq.put("ama", 7809);
    freq.put("amb", 1426);
    freq.put("ame", 673);
    freq.put("amd", 610);
    freq.put("amy", 27);
    freq.put("pss", 26);
    freq.put("ams", 61);
    freq.put("amu", 2166);
    freq.put("pst", 73);
    freq.put("t", 101248);
    freq.put("gja", 151);
    freq.put("yng", 34);
    freq.put("td ", 313);
    freq.put("Hel", 30);
    freq.put("Hem", 34);
    freq.put("sr ", 29);
    freq.put("cw", 75);
    freq.put("cu", 2133);
    freq.put("ct", 239);
    freq.put("yny", 44);
    freq.put("tdk", 146);
    freq.put("tdi", 60);
    freq.put("nmu", 175);
    freq.put("nma", 25);
    freq.put("tdr", 83);
    freq.put("tdu", 53);
    freq.put("dza", 50);
    freq.put("sra", 78);
    freq.put("dzi", 297);
    freq.put("sri", 54);
    freq.put("Adu", 110);
    freq.put("Gmn", 33);
    freq.put("tee", 92);
    freq.put("Ade", 67);
    freq.put("Ada", 436);
    freq.put("Adi", 29);
    freq.put("lob", 48);
    freq.put("loc", 28);
    freq.put("loa", 124);
    freq.put("log", 153);
    freq.put("lod", 38);
    freq.put("loe", 49);
    freq.put("lok", 225);
    freq.put("loh", 501);
    freq.put("lon", 542);
    freq.put("loo", 180);
    freq.put("lol", 129);
    freq.put("lom", 462);
    freq.put("lor", 123);
    freq.put("los", 114);
    freq.put("lop", 52);
    freq.put("lov", 68);
    freq.put("low", 394);
    freq.put("lot", 89);
    freq.put("rju", 75);
    freq.put("J", 2677);
    freq.put("rje", 34);
    freq.put("rja", 676);
    freq.put("rjo", 25);
    freq.put("lo ", 4559);
    freq.put(" sk", 814);
    freq.put("˛˘ ", 25);
    freq.put("Gel", 35);
    freq.put(" sc", 90);
    freq.put("yoo", 252);
    freq.put("Lam", 66);
    freq.put("Lan", 71);
    freq.put("yol", 111);
    freq.put("Lah", 160);
    freq.put("Lai", 31);
    freq.put("yoi", 52);
    freq.put("yoh", 34);
    freq.put("yog", 29);
    freq.put("Lag", 174);
    freq.put("yob", 30);
    freq.put(" sg", 94);
    freq.put(" sd", 268);
    freq.put("yoy", 25);
    freq.put("yow", 24);
    freq.put("you", 265);
    freq.put("Lap", 64);
    freq.put("yor", 39);
    freq.put("c ", 625);
    freq.put("Bru", 25);
    freq.put("yo ", 770);
    freq.put("Bro", 25);
    freq.put("IK ", 28);
    freq.put("Bra", 53);
    freq.put("mp ", 134);
    freq.put("mpe", 1303);
    freq.put("mpa", 1440);
    freq.put("mpo", 201);
    freq.put("mpl", 109);
    freq.put("mpi", 577);
    freq.put("mpt", 63);
    freq.put("mpu", 1435);
    freq.put("mpr", 120);
    freq.put("ass", 226);
    freq.put(" щ ", 37);
    freq.put("asu", 795);
    freq.put("ast", 1094);
    freq.put("Nta", 81);
    freq.put(" ru", 996);
    freq.put(" rt", 39);
    freq.put(" re", 1141);
    freq.put(" ra", 2028);
    freq.put(" rb", 113);
    freq.put(" rm", 196);
    freq.put(" ro", 326);
    freq.put(" ri", 627);
    freq.put("ihh", 284);
    freq.put("jri", 55);
    freq.put("ask", 176);
    freq.put("asj", 64);
    freq.put("S ", 552);
    freq.put("aso", 115);
    freq.put("asm", 61);
    freq.put("asl", 132);
    freq.put("Sy", 152);
    freq.put("˛¬", 27);
    freq.put("jr ", 25);
    freq.put("Ss", 26);
    freq.put("Sp", 91);
    freq.put("Su", 735);
    freq.put("St", 151);
    freq.put("FC ", 31);
    freq.put("Si", 928);
    freq.put("Sh", 112);
    freq.put("So", 397);
    freq.put("Sn", 29);
    freq.put("Sm", 173);
    freq.put("Sl", 62);
    freq.put("Sa", 1611);
    freq.put("Se", 2505);
    freq.put("EK ", 28);
    freq.put("ahR", 150);
    freq.put("f ", 1567);
    freq.put("hha", 714);
    freq.put("hhe", 164);
    freq.put("hhh", 1216);
    freq.put("eg ", 145);
    freq.put("fr", 231);
    freq.put("fs", 33);
    freq.put("ft", 215);
    freq.put("fu", 288);
    freq.put("fa", 1049);
    freq.put("fb", 119);
    freq.put("fc", 25);
    freq.put("fd", 25);
    freq.put("fe", 388);
    freq.put("ff", 256);
    freq.put("fi", 1257);
    freq.put("fk", 108);
    freq.put("fl", 154);
    freq.put("fn", 39);
    freq.put("fo", 1100);
    freq.put("a", 443662);
    freq.put("٥", 55);
    freq.put("IB ", 31);
    freq.put("egr", 31);
    freq.put("egu", 62);
    freq.put("egi", 513);
    freq.put("ego", 153);
    freq.put("ega", 749);
    freq.put("ege", 298);
    freq.put("ce ", 336);
    freq.put("y ", 5440);
    freq.put("ffi", 28);
    freq.put("fff", 42);
    freq.put("̮Ơ͡", 53);
    freq.put(" On", 61);
    freq.put(" Oo", 138);
    freq.put(" Ol", 65);
    freq.put(" Om", 71);
    freq.put(" Ok", 321);
    freq.put(" Oh", 358);
    freq.put(" Oi", 30);
    freq.put(" Oa", 30);
    freq.put("if ", 199);
    freq.put(" Ow", 47);
    freq.put(" Ot", 61);
    freq.put(" Or", 169);
    freq.put(" Op", 77);
    freq.put("yi", 676);
    freq.put("rwa", 44);
    freq.put("cee", 29);
    freq.put("ced", 31);
    freq.put("ym", 77);
    freq.put("ceb", 63);
    freq.put("yo", 2079);
    freq.put("yn", 173);
    freq.put("ya", 37546);
    freq.put("cen", 272);
    freq.put("cem", 205);
    freq.put("cel", 212);
    freq.put("cek", 162);
    freq.put("yd", 38);
    freq.put("yg", 5551);
    freq.put("ceh", 57);
    freq.put("cew", 347);
    freq.put("ceu", 31);
    freq.put("cet", 356);
    freq.put("ces", 45);
    freq.put("cer", 374);
    freq.put("cep", 389);
    freq.put("yp", 86);
    freq.put("ys", 214);
    freq.put("yr", 51);
    freq.put("yu", 1950);
    freq.put("yt", 67);
    freq.put("yw", 29);
    freq.put("ff ", 112);
    freq.put("ift", 26);
    freq.put("ifu", 43);
    freq.put(" O ", 300);
    freq.put("ife", 30);
    freq.put("ifa", 84);
    freq.put("yR", 53);
    freq.put("ifi", 89);
    freq.put("Ena", 106);
    freq.put("Eng", 133);
    freq.put("pu ", 246);
    freq.put(" ˚ ", 78);
    freq.put("as ", 3664);
    freq.put("Ent", 49);
    freq.put("pul", 1080);
    freq.put("asr", 67);
    freq.put("pun", 1860);
    freq.put("asp", 47);
    freq.put("puh", 48);
    freq.put("puj", 36);
    freq.put("puk", 162);
    freq.put("asy", 139);
    freq.put("pua", 892);
    freq.put("pub", 24);
    freq.put("asb", 33);
    freq.put("asa", 4788);
    freq.put("ase", 350);
    freq.put("put", 592);
    freq.put("puu", 49);
    freq.put("asi", 4270);
    freq.put("ash", 175);
    freq.put("pup", 74);
    freq.put("asn", 132);
    freq.put("pur", 287);
    freq.put("pus", 368);
    freq.put("͡", 849);
    freq.put(" F ", 38);
    freq.put("nc ", 24);
    freq.put("̶̀", 27);
    freq.put("̶́", 29);
    freq.put("st ", 446);
    freq.put("ncu", 210);
    freq.put("َ", 59);
    freq.put("nch", 51);
    freq.put("nci", 396);
    freq.put("nco", 89);
    freq.put("nca", 490);
    freq.put("nce", 308);
    freq.put("ste", 307);
    freq.put("stg", 30);
    freq.put("sta", 656);
    freq.put("sto", 134);
    freq.put("dtg", 89);
    freq.put("sti", 1245);
    freq.put("dte", 29);
    freq.put("stt", 34);
    freq.put("stu", 156);
    freq.put("str", 403);
    freq.put("sty", 33);
    freq.put("Gol", 24);
    freq.put("Goo", 39);
    freq.put("ka ", 3616);
    freq.put("God", 36);
    freq.put("Aja", 41);
    freq.put("lid", 69);
    freq.put("Nik", 24);
    freq.put("Nih", 52);
    freq.put("lig", 67);
    freq.put("lia", 1850);
    freq.put("lib", 366);
    freq.put("lic", 44);
    freq.put("lil", 781);
    freq.put("lim", 220);
    freq.put("lin", 1621);
    freq.put("lio", 28);
    freq.put("lih", 455);
    freq.put("lii", 209);
    freq.put("lik", 831);
    freq.put("lit", 364);
    freq.put("liv", 68);
    freq.put("² ", 144);
    freq.put("lir", 175);
    freq.put("lis", 566);
    freq.put("ˇ▽ˇ", 33);
    freq.put("kac", 134);
    freq.put("kab", 401);
    freq.put("kaa", 377);
    freq.put("kag", 314);
    freq.put("kaf", 31);
    freq.put("kad", 261);
    freq.put("kak", 2980);
    freq.put("kai", 181);
    freq.put("kah", 598);
    freq.put("rhu", 37);
    freq.put("kan", 9449);
    freq.put("kam", 2493);
    freq.put("kal", 4272);
    freq.put("kas", 1507);
    freq.put("kar", 1894);
    freq.put("kap", 901);
    freq.put("kaw", 194);
    freq.put("kau", 513);
    freq.put("kat", 1250);
    freq.put("rha", 439);
    freq.put("kay", 1002);
    freq.put("rhe", 61);
    freq.put("Tha", 90);
    freq.put("﹏╥ ", 63);
    freq.put("li ", 2275);
    freq.put("Ni ", 41);
    freq.put("kaR", 32);
    freq.put("ّه", 35);
    freq.put("з´ ", 42);
    freq.put("ox ", 41);
    freq.put("ª˘ ", 30);
    freq.put("ym ", 25);
    freq.put(" ┐ ", 155);
    freq.put("x", 1430);
    freq.put("woy", 70);
    freq.put("wow", 53);
    freq.put("wor", 71);
    freq.put("wol", 30);
    freq.put("woo", 119);
    freq.put("won", 124);
    freq.put("woi", 43);
    freq.put("woh", 25);
    freq.put("Pla", 29);
    freq.put("dut", 226);
    freq.put("Pli", 33);
    freq.put("wo ", 202);
    freq.put("Wan", 50);
    freq.put("Wal", 85);
    freq.put("Wak", 140);
    freq.put("Waj", 24);
    freq.put("Wah", 248);
    freq.put("adz", 53);
    freq.put("Wad", 43);
    freq.put("Waa", 48);
    freq.put("War", 41);
    freq.put(" t ", 121);
    freq.put("iy ", 86);
    freq.put(" ̩̩", 521);
    freq.put(" ty", 55);
    freq.put(" tw", 738);
    freq.put(" tv", 102);
    freq.put(" tu", 2816);
    freq.put(" tt", 171);
    freq.put(" ts", 31);
    freq.put(" tr", 940);
    freq.put("N", 2861);
    freq.put(" to", 1022);
    freq.put(" tn", 126);
    freq.put(" tm", 239);
    freq.put(" tl", 118);
    freq.put(" tk", 83);
    freq.put(" ti", 2851);
    freq.put(" th", 660);
    freq.put(" tg", 339);
    freq.put(" te", 5954);
    freq.put(" td", 633);
    freq.put(" tb", 26);
    freq.put(" ta", 7335);
    freq.put("iye", 260);
    freq.put("iya", 1594);
    freq.put("iyo", 102);
    freq.put("м", 54);
    freq.put("adh", 207);
    freq.put(" ̩͡", 40);
    freq.put("iyy", 34);
    freq.put("gs ", 121);
    freq.put("vy ", 40);
    freq.put("lie", 57);
    freq.put("lif", 43);
    freq.put("gsu", 236);
    freq.put("gsa", 98);
    freq.put("gse", 27);
    freq.put("gsg", 71);
    freq.put("gsi", 71);
    freq.put("ˇ▼", 49);
    freq.put("lip", 112);
    freq.put("ee ", 1343);
    freq.put("˛˘", 26);
    freq.put("PI ", 52);
    freq.put("eeR", 31);
    freq.put("eey", 42);
    freq.put("eeu", 26);
    freq.put("eet", 566);
    freq.put("eep", 129);
    freq.put("ees", 77);
    freq.put("eer", 111);
    freq.put("eem", 81);
    freq.put("eel", 85);
    freq.put("een", 209);
    freq.put("eeh", 388);
    freq.put("eek", 197);
    freq.put("eee", 1815);
    freq.put("eed", 49);
    freq.put("eea", 27);
    freq.put("eec", 31);
    freq.put("ru ", 1858);
    freq.put("bg ", 160);
    freq.put("Thx", 24);
    freq.put("з", 104);
    freq.put("id ", 343);
    freq.put("ruj", 24);
    freq.put("ruk", 183);
    freq.put("ruh", 329);
    freq.put("run", 476);
    freq.put("rul", 165);
    freq.put("rum", 1114);
    freq.put("rub", 136);
    freq.put("kao", 35);
    freq.put("للّ", 33);
    freq.put("rua", 142);
    freq.put("ruf", 24);
    freq.put("rug", 40);
    freq.put("rud", 118);
    freq.put("Thr", 25);
    freq.put("rus", 2052);
    freq.put("rup", 197);
    freq.put("rut", 462);
    freq.put("ruu", 87);
    freq.put("idz", 289);
    freq.put("bgi", 35);
    freq.put("idu", 1459);
    freq.put("bgn", 27);
    freq.put("ido", 108);
    freq.put("bgt", 1066);
    freq.put("bgu", 33);
    freq.put("idh", 30);
    freq.put("idi", 380);
    freq.put("ide", 289);
    freq.put(" ͡▿", 25);
    freq.put("┌", 242);
    freq.put("aq ", 228);
    freq.put("The", 63);
    freq.put("Elu", 26);
    freq.put("ut ", 2482);
    freq.put("tuk", 1211);
    freq.put("kus", 162);
    freq.put("aqa", 66);
    freq.put("tum", 157);
    freq.put("uta", 570);
    freq.put("ute", 183);
    freq.put("utk", 250);
    freq.put("uti", 404);
    freq.put("utn", 149);
    freq.put("uto", 47);
    freq.put("utr", 140);
    freq.put("uts", 63);
    freq.put("utt", 56);
    freq.put("utu", 590);
    freq.put("KU ", 30);
    freq.put("Tw", 120);
    freq.put("Tu", 498);
    freq.put("Tr", 208);
    freq.put("Tp", 224);
    freq.put("To", 237);
    freq.put("Th", 221);
    freq.put("Ti", 520);
    freq.put("Tg", 34);
    freq.put("Td", 76);
    freq.put("Te", 1036);
    freq.put("Tb", 30);
    freq.put("Ta", 1220);
    freq.put("nab", 65);
    freq.put("A ", 1008);
    freq.put("⌣", 1609);
    freq.put("naa", 203);
    freq.put("naf", 59);
    freq.put("nag", 84);
    freq.put("nad", 109);
    freq.put("nae", 90);
    freq.put("naj", 53);
    freq.put("nak", 1898);
    freq.put("nah", 936);
    freq.put("nai", 229);
    freq.put("nan", 2711);
    freq.put("nao", 58);
    freq.put("nal", 1134);
    freq.put("nam", 743);
    freq.put("nar", 331);
    freq.put("oom", 59);
    freq.put("nap", 935);
    freq.put("naw", 40);
    freq.put("nat", 186);
    freq.put("nau", 29);
    freq.put("nay", 34);
    freq.put("ooh", 244);
    freq.put("ook", 195);
    freq.put("T ", 35208);
    freq.put("tmu", 128);
    freq.put("Aa", 184);
    freq.put("na ", 4107);
    freq.put("Ab", 163);
    freq.put("e", 149670);
    freq.put("Ad", 721);
    freq.put("Ag", 99);
    freq.put("Ai", 143);
    freq.put("dvd", 33);
    freq.put("Ak", 980);
    freq.put("Aj", 64);
    freq.put("Am", 433);
    freq.put("Al", 1032);
    freq.put("An", 552);
    freq.put("Aq", 61);
    freq.put("Ap", 621);
    freq.put("As", 484);
    freq.put("Ar", 257);
    freq.put("Au", 50);
    freq.put("At", 123);
    freq.put("Aw", 81);
    freq.put("Av", 33);
    freq.put("Ay", 211);
    freq.put("Az", 30);
    freq.put("gw", 2133);
    freq.put("gu", 7695);
    freq.put("Git", 29);
    freq.put("gs", 703);
    freq.put("gr", 762);
    freq.put("gp", 245);
    freq.put("˘ʃ", 64);
    freq.put("gy", 67);
    freq.put("gx", 24);
    freq.put("gg", 5251);
    freq.put("gf", 117);
    freq.put("ge", 7796);
    freq.put("gd", 104);
    freq.put("gb", 95);
    freq.put("ga", 23869);
    freq.put("˚Д", 24);
    freq.put("gn", 1964);
    freq.put("Gim", 52);
    freq.put("Gil", 83);
    freq.put("gk", 2724);
    freq.put("gj", 183);
    freq.put("gi", 8970);
    freq.put("gh", 680);
    freq.put("lko", 26);
    freq.put("Non", 60);
    freq.put("gR", 127);
    freq.put("tmb", 26);
    freq.put("lka", 211);
    freq.put("lku", 24);
    freq.put("kck", 475);
    freq.put("g ", 34798);
    freq.put("hi ", 490);
    freq.put("", 79);
    freq.put("No ", 55);
    freq.put("lk ", 39);
    freq.put("tmn", 95);
    freq.put("Spa", 24);
    freq.put("Spe", 24);
    freq.put("zo", 70);
    freq.put("zh", 39);
    freq.put("zi", 508);
    freq.put("zk", 53);
    freq.put("ze", 84);
    freq.put("za", 448);
    freq.put("zz", 474);
    freq.put("zt", 24);
    freq.put("zu", 65);
    freq.put("Ah ", 165);
    freq.put("ƪ˘", 63);
    freq.put("uwu", 28);
    freq.put("ː̖́", 34);
    freq.put("z ", 437);
    freq.put("Aha", 178);
    freq.put("Ahh", 50);
    freq.put("ʃ ", 123);
    freq.put(" ┒ ", 30);
    freq.put("wid", 51);
    freq.put("win", 158);
    freq.put("wil", 66);
    freq.put("wii", 31);
    freq.put("iet", 38);
    freq.put("wit", 602);
    freq.put("wis", 143);
    freq.put("Ji", 157);
    freq.put("wi ", 139);
    freq.put("ʃƪ", 198);
    freq.put("ieb", 35);
    freq.put("ied", 133);
    freq.put("cd ", 39);
    freq.put("kru", 71);
    freq.put(" va", 76);
    freq.put(" jm", 58);
    freq.put("˘̩", 627);
    freq.put(" ve", 121);
    freq.put(" vi", 516);
    freq.put(" vo", 89);
    freq.put(" vs", 74);
    freq.put(" jn", 38);
    freq.put(" ji", 473);
    freq.put("˘̶", 60);
    freq.put("kro", 56);
    freq.put("˘͡ ", 135);
    freq.put(" v ", 82);
    freq.put("˘͡", 137);
    freq.put(" jb", 51);
    freq.put("ʃ˘", 30);
    freq.put("jng", 34);
    freq.put("´⌣ ", 24);
    freq.put("RA ", 35);
    freq.put("ƪ ", 727);
    freq.put("mas", 3175);
    freq.put("hlo", 28);
    freq.put("hli", 27);
    freq.put("hla", 180);
    freq.put("˘ ", 951);
    freq.put("kdi", 32);
    freq.put("▿▿", 145);
    freq.put("ece", 337);
    freq.put("eca", 231);
    freq.put("eco", 50);
    freq.put("eck", 40);
    freq.put("eci", 318);
    freq.put("ech", 84);
    freq.put("ː", 66);
    freq.put("PK ", 28);
    freq.put("ect", 80);
    freq.put("hl ", 72);
    freq.put("fot", 266);
    freq.put("rs ", 438);
    freq.put("cy ", 30);
    freq.put("AN ", 178);
    freq.put(" Sy", 150);
    freq.put(" Ss", 24);
    freq.put(" Sp", 89);
    freq.put(" St", 144);
    freq.put(" Su", 732);
    freq.put(" Sk", 106);
    freq.put(" Sh", 108);
    freq.put(" Si", 922);
    freq.put(" So", 391);
    freq.put(" Sl", 62);
    freq.put(" Sm", 172);
    freq.put("man", 6159);
    freq.put(" Se", 2493);
    freq.put("rsn", 26);
    freq.put("rso", 46);
    freq.put("rsi", 298);
    freq.put("rse", 388);
    freq.put("rsa", 328);
    freq.put("R", 37712);
    freq.put("rsy", 57);
    freq.put("rsu", 45);
    freq.put("cyi", 43);
    freq.put("bej", 28);
    freq.put("bek", 352);
    freq.put("beh", 139);
    freq.put("ben", 1556);
    freq.put("bel", 2114);
    freq.put("bem", 24);
    freq.put("beb", 354);
    freq.put("bec", 66);
    freq.put("bea", 50);
    freq.put("beg", 391);
    freq.put("bed", 323);
    freq.put("bee", 81);
    freq.put("AL ", 51);
    freq.put("bey", 24);
    freq.put("MU ", 83);
    freq.put("ber", 4506);
    freq.put("bes", 928);
    freq.put(" S ", 59);
    freq.put("bet", 476);
    freq.put("beu", 71);
    freq.put("py ", 258);
    freq.put("aw ", 224);
    freq.put("ur ", 2487);
    freq.put("arm", 105);
    freq.put("bur", 936);
    freq.put("aww", 49);
    freq.put("awu", 39);
    freq.put("awo", 31);
    freq.put("awk", 31);
    freq.put("awi", 131);
    freq.put("awe", 211);
    freq.put("awa", 1950);
    freq.put("ure", 97);
    freq.put("urg", 114);
    freq.put("ura", 1283);
    freq.put("urb", 25);
    freq.put("urn", 197);
    freq.put("uro", 26);
    freq.put("urh", 94);
    freq.put("uri", 307);
    freq.put("urk", 45);
    freq.put("uru", 1349);
    freq.put("urw", 32);
    freq.put("urr", 89);
    freq.put("urs", 41);
    freq.put("bun", 704);
    freq.put("mg ", 512);
    freq.put("bul", 520);
    freq.put("◦ ", 92);
    freq.put("lse", 42);
    freq.put("ngR", 114);
    freq.put("tb ", 35);
    freq.put("ngd", 46);
    freq.put("nge", 5371);
    freq.put("ngf", 36);
    freq.put("ngg", 4627);
    freq.put("nga", 5974);
    freq.put("ngb", 34);
    freq.put("ngl", 175);
    freq.put("ngm", 160);
    freq.put("ngn", 687);
    freq.put("˘ڡ", 32);
    freq.put("ngh", 292);
    freq.put("ngi", 1778);
    freq.put("ngj", 35);
    freq.put("ngk", 2079);
    freq.put("sh ", 731);
    freq.put("ngu", 1137);
    freq.put("ngp", 62);
    freq.put("ngr", 92);
    freq.put("ngs", 522);
    freq.put(" ̃", 29);
    freq.put("wok", 196);
    freq.put("mgk", 37);
    freq.put("¬͡ ", 48);
    freq.put("Ia ", 47);
    freq.put("tba", 30);
    freq.put("dpt", 208);
    freq.put("ƗƗɑ", 265);
    freq.put("ƗƗɐ", 105);
    freq.put("sha", 239);
    freq.put("shb", 27);
    freq.put("she", 63);
    freq.put("dpa", 39);
    freq.put("shh", 40);
    freq.put("dpn", 71);
    freq.put("sho", 213);
    freq.put("luR", 24);
    freq.put("ke ", 4000);
    freq.put("lup", 515);
    freq.put("lur", 180);
    freq.put("lus", 302);
    freq.put("lut", 111);
    freq.put("luu", 86);
    freq.put("ƗɐƗ", 69);
    freq.put("lua", 852);
    freq.put("lub", 53);
    freq.put("luc", 204);
    freq.put("lue", 32);
    freq.put("ื", 32);
    freq.put("luh", 103);
    freq.put("lui", 36);
    freq.put("luk", 231);
    freq.put("lul", 117);
    freq.put("lum", 851);
    freq.put("lun", 164);
    freq.put("ken", 1334);
    freq.put("kem", 1006);
    freq.put("kel", 1246);
    freq.put("kek", 444);
    freq.put("kej", 183);
    freq.put("kei", 69);
    freq.put("keh", 195);
    freq.put("keg", 82);
    freq.put("kee", 143);
    freq.put("ked", 219);
    freq.put("kec", 487);
    freq.put("keb", 523);
    freq.put("kea", 114);
    freq.put("key", 87);
    freq.put("Gk ", 81);
    freq.put("keu", 131);
    freq.put("ket", 1571);
    freq.put("kes", 642);
    freq.put("ker", 1159);
    freq.put("kep", 536);
    freq.put("◦", 133);
    freq.put("Td ", 52);
    freq.put("lu ", 3769);
    freq.put("ot ", 568);
    freq.put("Loh", 52);
    freq.put("Lol", 27);
    freq.put("yaR", 97);
    freq.put("┐", 245);
    freq.put("ڡ˘ ", 31);
    freq.put("Ɨɐ ", 33);
    freq.put("iny", 1233);
    freq.put("yay", 102);
    freq.put("yau", 190);
    freq.put("yat", 535);
    freq.put("yaw", 177);
    freq.put("yap", 115);
    freq.put("yas", 140);
    freq.put("yar", 462);
    freq.put("yam", 618);
    freq.put("yal", 303);
    freq.put("yan", 4147);
    freq.put("yai", 169);
    freq.put("yah", 2114);
    freq.put("yak", 2172);
    freq.put("yad", 162);
    freq.put("yaa", 2527);
    freq.put("oth", 62);
    freq.put("oti", 133);
    freq.put("Lo ", 161);
    freq.put("otn", 29);
    freq.put("oto", 733);
    freq.put("ota", 417);
    freq.put("ote", 179);
    freq.put("ott", 51);
    freq.put("otw", 51);
    freq.put("And", 132);
    freq.put("Ane", 37);
    freq.put("Ang", 67);
    freq.put("Ana", 104);
    freq.put("Anj", 90);
    freq.put("Ant", 45);
    freq.put("ya ", 22721);
    freq.put("bir", 409);
    freq.put("wkk", 204);
    freq.put("Yoi", 40);
    freq.put("wka", 108);
    freq.put("You", 39);
    freq.put("wkt", 88);
    freq.put("wkw", 2699);
    freq.put("wkR", 177);
    freq.put("wk ", 1265);
    freq.put("Yo ", 44);
    freq.put("⌣́ ", 335);
    freq.put("i", 163075);
    freq.put("ksi", 348);
    freq.put(" xD", 102);
    freq.put("Be", 1374);
    freq.put(" xi", 24);
    freq.put("Bg", 42);
    freq.put("Ba", 1701);
    freq.put("Bb", 36);
    freq.put("Bl", 146);
    freq.put("Bn", 48);
    freq.put("Bo", 359);
    freq.put("Bh", 28);
    freq.put("Bi", 641);
    freq.put("Bk", 45);
    freq.put("Bt", 36);
    freq.put("Bu", 730);
    freq.put("Br", 179);
    freq.put("Bs", 76);
    freq.put("By", 39);
    freq.put("B ", 417);
    freq.put(" x ", 363);
    freq.put("TI ", 45);
    freq.put("jln", 53);
    freq.put("U ", 376);
    freq.put("BD ", 30);
    freq.put("ƪ", 834);
    freq.put("pr", 1286);
    freq.put("dui", 207);
    freq.put("Ut", 26);
    freq.put("Up", 39);
    freq.put("Ur", 33);
    freq.put("Um", 43);
    freq.put("Ul", 48);
    freq.put("Un", 168);
    freq.put("Uh", 31);
    freq.put("Ud", 647);
    freq.put("Ua", 28);
    freq.put("dun", 828);
    freq.put("dud", 125);
    freq.put("¬͡͡", 29);
    freq.put("h ", 47130);
    freq.put("dm ", 54);
    freq.put("eah", 49);
    freq.put("eak", 99);
    freq.put("hy", 203);
    freq.put("eam", 85);
    freq.put("eal", 79);
    freq.put("ean", 182);
    freq.put("eaa", 99);
    freq.put("hs", 125);
    freq.put("eac", 36);
    freq.put("ead", 144);
    freq.put("ht", 190);
    freq.put("hu", 2317);
    freq.put("eay", 24);
    freq.put("hk", 477);
    freq.put("hh", 4411);
    freq.put("hi", 4127);
    freq.put("PM ", 28);
    freq.put("ho", 2124);
    freq.put("hl", 365);
    freq.put("hm", 468);
    freq.put("hb", 102);
    freq.put("eas", 143);
    freq.put("ear", 148);
    freq.put("hf", 73);
    freq.put("ph", 168);
    freq.put("hd", 143);
    freq.put("he", 4969);
    freq.put("dma", 55);
    freq.put("dus", 93);
    freq.put("hR", 296);
    freq.put("dmi", 111);
    freq.put("dmn", 188);
    freq.put("duu", 143);
    freq.put("لل", 34);
    freq.put("hª", 26);
    freq.put("لّ", 37);
    freq.put("hn ", 114);
    freq.put("ª", 288);
    freq.put(" Up", 38);
    freq.put(" Ur", 32);
    freq.put(" Ul", 47);
    freq.put(" Um", 43);
    freq.put(" Un", 163);
    freq.put(" Uh", 30);
    freq.put(" Ud", 647);
    freq.put("▼", 56);
    freq.put(" tp", 989);
    freq.put("hny", 467);
    freq.put(" U ", 61);
    freq.put("MS ", 33);
    freq.put("Ehe", 40);
    freq.put("Ehh", 38);
    freq.put("aua", 105);
    freq.put("aud", 382);
    freq.put("aug", 35);
    freq.put("auh", 303);
    freq.put("auk", 72);
    freq.put("aum", 31);
    freq.put("aul", 199);
    freq.put("up ", 862);
    freq.put("aun", 413);
    freq.put("aup", 101);
    freq.put("aus", 167);
    freq.put("aur", 141);
    freq.put("auu", 185);
    freq.put("aut", 122);
    freq.put("BY ", 34);
    freq.put("Eh ", 324);
    freq.put("upo", 45);
    freq.put("upl", 52);
    freq.put("upm", 25);
    freq.put("upk", 36);
    freq.put("upi", 146);
    freq.put("upd", 67);
    freq.put("upe", 166);
    freq.put("╮", 33);
    freq.put("Hha", 117);
    freq.put("Hhe", 39);
    freq.put("Hhh", 28);
    freq.put("ups", 69);
    freq.put("upp", 65);
    freq.put("me ", 606);
    freq.put("Pul", 64);
    freq.put("Pun", 77);
    freq.put("nem", 193);
    freq.put("nek", 288);
    freq.put("neh", 392);
    freq.put("neg", 158);
    freq.put("nee", 100);
    freq.put("neb", 26);
    freq.put("Pua", 93);
    freq.put("ney", 42);
    freq.put("Put", 48);
    freq.put("dr ", 584);
    freq.put("net", 179);
    freq.put("ner", 1108);
    freq.put("nes", 626);
    freq.put("Pur", 39);
    freq.put("Pus", 34);
    freq.put("mee", 70);
    freq.put("med", 166);
    freq.put("meg", 84);
    freq.put("mem", 1141);
    freq.put("mel", 755);
    freq.put("men", 4892);
    freq.put("mei", 27);
    freq.put("meh", 63);
    freq.put("mek", 56);
    freq.put("mej", 47);
    freq.put("meu", 33);
    freq.put("met", 232);
    freq.put("mew", 53);
    freq.put("mes", 394);
    freq.put("mer", 1304);
    freq.put("mey", 26);
    freq.put("Lu ", 115);
    freq.put("drp", 64);
    freq.put("dru", 38);
    freq.put("drt", 28);
    freq.put("ne ", 915);
    freq.put("dri", 207);
    freq.put("sji", 92);
    freq.put("drm", 47);
    freq.put("dro", 93);
    freq.put("dra", 174);
    freq.put("dre", 48);
    freq.put("kg ", 108);
    freq.put("lwa", 31);
    freq.put("´ ", 115);
    freq.put("Sta", 47);
    freq.put("Sto", 24);
    freq.put("kga", 41);
    freq.put("Str", 32);
    freq.put("V", 261);
    freq.put("kgk", 41);
    freq.put("Tim", 104);
    freq.put("Tin", 67);
    freq.put("lw ", 75);
    freq.put("Lia", 70);
    freq.put("Lib", 61);
    freq.put("Lin", 36);
    freq.put("Tik", 24);
    freq.put("Lik", 120);
    freq.put("Tid", 161);
    freq.put("ov ", 24);
    freq.put("Kab", 43);
    freq.put("Kag", 66);
    freq.put("Kad", 39);
    freq.put("Kak", 105);
    freq.put("Kan", 367);
    freq.put("Kam", 312);
    freq.put("Kal", 619);
    freq.put("Kas", 154);
    freq.put("Kar", 130);
    freq.put("Kap", 150);
    freq.put("Kau", 85);
    freq.put("Kat", 145);
    freq.put("Kay", 130);
    freq.put(" sa", 9182);
    freq.put("yg ", 5486);
    freq.put("ove", 211);
    freq.put("ovi", 63);
    freq.put("All", 421);
    freq.put("Ka ", 38);
    freq.put("Alh", 383);
    freq.put("Ali", 41);
    freq.put("Ala", 97);
    freq.put("wur", 26);
    freq.put("PR ", 53);
    freq.put("", 70);
    freq.put("Woy", 24);
    freq.put("Wow", 45);
    freq.put("Woo", 64);
    freq.put(" zo", 38);
    freq.put(" zi", 32);
    freq.put(" za", 127);
    freq.put(" zz", 68);
    freq.put("is ", 2694);
    freq.put(" ´▽", 165);
    freq.put("TK ", 25);
    freq.put("isy", 29);
    freq.put("iss", 277);
    freq.put("isp", 25);
    freq.put("isw", 62);
    freq.put("isu", 191);
    freq.put("ist", 476);
    freq.put("isk", 111);
    freq.put(" ", 43);
    freq.put("isi", 1081);
    freq.put("ish", 128);
    freq.put("iso", 124);
    freq.put("isn", 156);
    freq.put("ism", 146);
    freq.put("isl", 36);
    freq.put("isa", 2640);
    freq.put("ise", 279);
    freq.put("Ɨ", 438);
    freq.put("Hmm", 120);
    freq.put("BB ", 69);
    freq.put("euk", 45);
    freq.put("П┐", 57);
    freq.put("ty ", 126);
    freq.put("do ", 440);
    freq.put("ڡˆ ", 24);
    freq.put("tya", 77);
    freq.put("dok", 173);
    freq.put("doh", 159);
    freq.put("doi", 44);
    freq.put("don", 2255);
    freq.put("doo", 156);
    freq.put("dol", 145);
    freq.put("dom", 105);
    freq.put("doa", 543);
    freq.put("m", 89340);
    freq.put("dod", 47);
    freq.put("doy", 36);
    freq.put("dor", 131);
    freq.put("dos", 183);
    freq.put("dow", 89);
    freq.put("dot", 45);
    freq.put(" We", 213);
    freq.put(" Wa", 768);
    freq.put(" Wo", 207);
    freq.put(" Wk", 484);
    freq.put(" Wh", 70);
    freq.put(" Wi", 120);
    freq.put(" Wu", 48);
    freq.put("Gpp", 64);
    freq.put("ba ", 883);
    freq.put(" W ", 33);
    freq.put("baw", 483);
    freq.put("bat", 1425);
    freq.put("bau", 122);
    freq.put("bar", 4253);
    freq.put("bas", 269);
    freq.put("bap", 119);
    freq.put("bay", 452);
    freq.put("bag", 833);
    freq.put("bad", 371);
    freq.put("bae", 120);
    freq.put("bab", 289);
    freq.put("bac", 580);
    freq.put("baa", 146);
    freq.put("ban", 4309);
    freq.put("bal", 1315);
    freq.put("bam", 30);
    freq.put("baj", 312);
    freq.put("bak", 948);
    freq.put("bah", 1228);
    freq.put("bai", 786);
    freq.put("om ", 884);
    freq.put("Rum", 77);
    freq.put("un ", 2586);
    freq.put("omb", 403);
    freq.put("C", 2321);
    freq.put("ome", 356);
    freq.put("omi", 101);
    freq.put("omo", 431);
    freq.put("omn", 24);
    freq.put("omm", 66);
    freq.put("omp", 262);
    freq.put("omu", 38);
    freq.put("uns", 26);
    freq.put("unt", 900);
    freq.put("unu", 142);
    freq.put("uny", 1586);
    freq.put("fny", 27);
    freq.put("una", 348);
    freq.put("unc", 219);
    freq.put("und", 481);
    freq.put("une", 50);
    freq.put("unf", 51);
    freq.put("ung", 4172);
    freq.put("uni", 561);
    freq.put("unj", 114);
    freq.put("unk", 91);
    freq.put("unn", 113);
    freq.put("C ", 224);
    freq.put(" ⌣̀", 334);
    freq.put("Ck", 86);
    freq.put("Ci", 534);
    freq.put("Ch", 136);
    freq.put("Co", 295);
    freq.put("Cl", 26);
    freq.put("Cc", 51);
    freq.put("Ca", 326);
    freq.put("Ce", 267);
    freq.put("slo", 24);
    freq.put("slh", 48);
    freq.put("sli", 206);
    freq.put("akr", 32);
    freq.put("sle", 46);
    freq.put("sla", 262);
    freq.put("Cu", 214);
    freq.put("iy", 2124);
    freq.put("ix", 147);
    freq.put("iz", 274);
    freq.put("iq", 52);
    freq.put("ip", 2253);
    freq.put("Nah", 118);
    freq.put("ir", 6653);
    freq.put("Nan", 132);
    freq.put("it", 11593);
    freq.put("iw", 319);
    freq.put("iv", 317);
    freq.put("ii", 3794);
    freq.put("Nas", 64);
    freq.put("ik", 9937);
    freq.put("ij", 536);
    freq.put("im", 4053);
    freq.put("il", 6231);
    freq.put("io", 1109);
    freq.put("in", 29486);
    freq.put("Naz", 35);
    freq.put("ic", 1074);
    freq.put("ib", 2697);
    freq.put("ie", 1599);
    freq.put("id", 3927);
    freq.put("ig", 762);
    freq.put("if", 554);
    freq.put("V ", 168);
    freq.put("iP", 30);
    freq.put("iR", 133);
    freq.put("kis", 117);
    freq.put("kir", 951);
    freq.put("kip", 73);
    freq.put("kiw", 37);
    freq.put("kit", 2055);
    freq.put("kik", 72);
    freq.put("kii", 45);
    freq.put("kin", 1836);
    freq.put("kim", 50);
    freq.put("kil", 127);
    freq.put("kic", 32);
    freq.put("kib", 59);
    freq.put("kia", 97);
    freq.put("kie", 37);
    freq.put("kid", 36);
    freq.put("Vi", 95);
    freq.put("nk ", 721);
    freq.put("yek", 56);
    freq.put("yem", 72);
    freq.put("yel", 69);
    freq.put("yeo", 36);
    freq.put("yen", 139);
    freq.put("yea", 53);
    freq.put("yeb", 114);
    freq.put("yee", 361);
    freq.put("yey", 33);
    freq.put("op ", 256);
    freq.put("yep", 28);
    freq.put("yes", 221);
    freq.put("yer", 111);
    freq.put("yeu", 46);
    freq.put("yet", 107);
    freq.put("vd ", 30);
    freq.put("eur", 115);
    freq.put("opt", 25);
    freq.put("opu", 46);
    freq.put("opp", 53);
    freq.put("ops", 26);
    freq.put("ye ", 576);
    freq.put("opy", 25);
    freq.put("ope", 143);
    freq.put("opa", 84);
    freq.put("opl", 49);
    freq.put("opo", 299);
    freq.put("opi", 131);
    freq.put("Ars", 61);
    freq.put("Art", 38);
    freq.put("Aru", 36);
    freq.put("ˆڡ", 24);
    freq.put("Ari", 29);
    freq.put("www", 90);
    freq.put("wwk", 34);
    freq.put("bra", 415);
    freq.put("ww ", 119);
    freq.put("˘", 2418);
    freq.put("Z", 145);
    freq.put(" ˇ ", 302);
    freq.put("Zzz", 36);
    freq.put("nki", 41);
    freq.put("⌣˘̩", 62);
    freq.put("fsu", 24);
    freq.put("di ", 8376);
    freq.put("Tun", 41);
    freq.put("dil", 350);
    freq.put("dim", 617);
    freq.put("din", 1494);
    freq.put("dio", 133);
    freq.put("dih", 491);
    freq.put("dii", 200);
    freq.put("dij", 207);
    freq.put("dik", 1613);
    freq.put("did", 175);
    freq.put("die", 229);
    freq.put("dif", 33);
    freq.put("dig", 163);
    freq.put("dia", 1947);
    freq.put("dib", 687);
    freq.put("dic", 208);
    freq.put("diy", 66);
    freq.put("dit", 712);
    freq.put("diu", 138);
    freq.put("dip", 457);
    freq.put("dir", 1274);
    freq.put("dis", 1059);
    freq.put(" Yo", 219);
    freq.put(" Ya", 1252);
    freq.put(" Ye", 182);
    freq.put(" Yg", 300);
    freq.put("Gra", 39);
    freq.put(" Yu", 137);
    freq.put("tng", 94);
    freq.put("AM ", 32);
    freq.put("bo ", 169);
    freq.put(" Y ", 70);
    freq.put("ˆ⌣ˆ", 62);
    freq.put("box", 38);
    freq.put("boy", 115);
    freq.put("bor", 114);
    freq.put("bos", 259);
    freq.put("bot", 112);
    freq.put("boh", 133);
    freq.put("Wo", 208);
    freq.put("bok", 285);
    freq.put("bol", 885);
    freq.put("ɑƗƚ", 34);
    freq.put("bon", 339);
    freq.put("boo", 215);
    freq.put("boa", 30);
    freq.put("bob", 142);
    freq.put("boc", 102);
    freq.put("bod", 132);
    freq.put("hbs", 29);
    freq.put("bog", 68);
    freq.put("oo ", 759);
    freq.put("ayl", 26);
    freq.put("̀ ", 432);
    freq.put("ayi", 60);
    freq.put("aye", 89);
    freq.put("aya", 4482);
    freq.put("ayb", 24);
    freq.put("ayy", 96);
    freq.put("uap", 27);
    freq.put("ayu", 305);
    freq.put("ul ", 1319);
    freq.put("ays", 67);
    freq.put("ood", 141);
    freq.put("oog", 36);
    freq.put("Ben", 187);
    freq.put("Bel", 262);
    freq.put("Beb", 38);
    freq.put("ool", 102);
    freq.put("ooo", 919);
    freq.put("oon", 310);
    freq.put("Beg", 32);
    freq.put("Bed", 31);
    freq.put("oot", 52);
    freq.put("oow", 33);
    freq.put("oos", 29);
    freq.put("oor", 43);
    freq.put("Ber", 445);
    freq.put("Bes", 195);
    freq.put("ooy", 46);
    freq.put("Bet", 52);
    freq.put("uah", 355);
    freq.put("вв", 29);
    freq.put("uls", 165);
    freq.put("ay ", 853);
    freq.put("ult", 106);
    freq.put("ulu", 1551);
    freq.put("fli", 40);
    freq.put("ulk", 99);
    freq.put("uli", 1436);
    freq.put("uln", 71);
    freq.put("ulo", 46);
    freq.put("ull", 269);
    freq.put("fla", 42);
    freq.put("ula", 1896);
    freq.put("ule", 188);
    freq.put("sn ", 42);
    freq.put("ma ", 6175);
    freq.put("nyu", 494);
    freq.put("nyk", 132);
    freq.put("nyi", 418);
    freq.put("nyo", 372);
    freq.put("nya", 17386);
    freq.put("nye", 780);
    freq.put("sng", 35);
    freq.put("snd", 66);
    freq.put("mar", 1300);
    freq.put("mau", 2465);
    freq.put("mat", 2218);
    freq.put("maw", 54);
    freq.put("sna", 75);
    freq.put("may", 225);
    freq.put("sni", 103);
    freq.put("maa", 1431);
    freq.put("mac", 403);
    freq.put("mab", 66);
    freq.put("mae", 306);
    freq.put("mad", 403);
    freq.put("mag", 126);
    freq.put("mai", 886);
    freq.put("mah", 2420);
    freq.put("mak", 2502);
    freq.put("maj", 93);
    freq.put("mam", 655);
    freq.put("mal", 1960);
    freq.put("sny", 484);
    freq.put("́ ", 422);
    freq.put("q", 1116);
    freq.put("ny ", 719);
    freq.put("ida", 918);
    freq.put("Nge", 146);
    freq.put("Ngg", 140);
    freq.put("Nga", 271);
    freq.put("lsa", 204);
    freq.put("Ngo", 37);
    freq.put("Ngi", 39);
    freq.put("lsu", 33);
    freq.put("kk ", 863);
    freq.put(" aa", 308);
    freq.put(" ab", 911);
    freq.put(" ac", 285);
    freq.put(" ad", 4699);
    freq.put(" ae", 205);
    freq.put(" af", 37);
    freq.put(" ag", 376);
    freq.put(" ah", 1553);
    freq.put(" ai", 665);
    freq.put(" aj", 4537);
    freq.put(" ak", 4873);
    freq.put(" al", 1131);
    freq.put(" am", 1622);
    freq.put(" an", 2947);
    freq.put(" ap", 3423);
    freq.put(" aq", 225);
    freq.put(" ar", 707);
    freq.put(" as", 908);
    freq.put(" at", 1317);
    freq.put(" au", 141);
    freq.put(" av", 177);
    freq.put(" aw", 322);
    freq.put(" ay", 626);
    freq.put(" az", 56);
    freq.put("ls ", 208);
    freq.put("kku", 99);
    freq.put("kkw", 131);
    freq.put("Sha", 34);
    freq.put("kkk", 419);
    freq.put("eny", 1082);
    freq.put("kke", 30);
    freq.put("Shi", 31);
    freq.put("kka", 224);
    freq.put("Sho", 30);
    freq.put(" a ", 536);
    freq.put("۳", 48);
    freq.put("Lup", 57);
    freq.put(" uk", 48);
    freq.put("Luc", 41);
    freq.put("Lum", 30);
    freq.put("or ", 1066);
    freq.put("Ken", 321);
    freq.put("Kem", 174);
    freq.put("Kel", 106);
    freq.put("Kek", 37);
    freq.put("Kej", 26);
    freq.put("Kec", 73);
    freq.put("Keb", 128);
    freq.put("Ket", 173);
    freq.put("Kes", 79);
    freq.put("Ker", 133);
    freq.put("Kep", 57);
    freq.put("RT ", 34396);
    freq.put("G", 3822);
    freq.put("ory", 48);
    freq.put("ort", 211);
    freq.put("oru", 42);
    freq.put("orr", 146);
    freq.put("ors", 31);
    freq.put("orn", 153);
    freq.put("oro", 228);
    freq.put("orl", 29);
    freq.put("orm", 189);
    freq.put("ork", 43);
    freq.put("ori", 252);
    freq.put("org", 582);
    freq.put("ord", 87);
    freq.put("ore", 526);
    freq.put("orb", 98);
    freq.put("ora", 1519);
    freq.put("Ke ", 105);
    freq.put("Apa", 548);
    freq.put("Yau", 101);
    freq.put("Yan", 256);
    freq.put("Yah", 146);
    freq.put("Yak", 61);
    freq.put("lau", 1206);
    freq.put("Yaa", 140);
    freq.put("heR", 76);
    freq.put("Otw", 33);
    freq.put("Ya ", 393);
    freq.put("IS ", 42);
    freq.put("iw ", 58);
    freq.put("Do", 193);
    freq.put("Dm", 35);
    freq.put("Di", 1241);
    freq.put("De", 401);
    freq.put("Da", 668);
    freq.put("²", 166);
    freq.put("Du", 242);
    freq.put("Dr", 110);
    freq.put("Dp", 25);
    freq.put("iwa", 123);
    freq.put("iwo", 31);
    freq.put("iwi", 55);
    freq.put("D ", 2833);
    freq.put("▿˘ ", 24);
    freq.put(" cˇ", 51);
    freq.put("ge ", 363);
    freq.put("ƚɑ", 43);
    freq.put("We", 215);
    freq.put("Wa", 773);
    freq.put("HA ", 130);
    freq.put("Wk", 484);
    freq.put("Wi", 120);
    freq.put("Wh", 71);
    freq.put("Wu", 48);
    freq.put("ges", 111);
    freq.put("ger", 1323);
    freq.put("gep", 81);
    freq.put("geu", 106);
    freq.put("get", 1846);
    freq.put("gec", 63);
    freq.put("geb", 219);
    freq.put("geg", 69);
    freq.put("gef", 30);
    freq.put("gee", 143);
    freq.put("ged", 237);
    freq.put("gek", 69);
    freq.put("gej", 100);
    freq.put("geh", 76);
    freq.put("gen", 1922);
    freq.put("RI ", 72);
    freq.put("gel", 673);
    freq.put("W ", 204);
    freq.put("Wka", 27);
    freq.put("Wkw", 427);
    freq.put("tu ", 6403);
    freq.put("j ", 361);
    freq.put("ain", 2667);
    freq.put("tup", 303);
    freq.put("dk ", 260);
    freq.put("tus", 361);
    freq.put("ه", 41);
    freq.put("jt", 34);
    freq.put("ju", 3931);
    freq.put("tur", 427);
    freq.put("jw", 48);
    freq.put("tut", 229);
    freq.put("tuu", 197);
    freq.put("jr", 131);
    freq.put("jl", 120);
    freq.put("jm", 68);
    freq.put("jn", 45);
    freq.put("jo", 918);
    freq.put("jh", 47);
    freq.put("ji", 1582);
    freq.put("jj", 60);
    freq.put("jk", 111);
    freq.put("jd", 940);
    freq.put("je", 1786);
    freq.put("tub", 78);
    freq.put("jg", 1512);
    freq.put("tud", 61);
    freq.put("ja", 13504);
    freq.put("jb", 120);
    freq.put("tug", 171);
    freq.put("tuh", 1657);
    freq.put("dkt", 51);
    freq.put("tui", 120);
    freq.put("tuj", 153);
    freq.put("dke", 26);
    freq.put("tul", 423);
    freq.put("dki", 25);
    freq.put("bm ", 185);
    freq.put("tun", 843);
    freq.put("tua", 340);
    freq.put("̴", 483);
    freq.put("▽˘ ", 61);
    freq.put("hda", 79);
    freq.put("hdi", 28);
    freq.put("oi ", 213);
    freq.put("pap", 424);
    freq.put("par", 764);
    freq.put("pas", 1655);
    freq.put("pat", 1149);
    freq.put("pau", 37);
    freq.put("pay", 143);
    freq.put(" bw", 196);
    freq.put("paa", 629);
    freq.put("pab", 29);
    freq.put("pac", 537);
    freq.put("pad", 1250);
    freq.put("pag", 411);
    freq.put("pah", 450);
    freq.put("pai", 563);
    freq.put("pak", 1699);
    freq.put("pal", 827);
    freq.put("pam", 112);
    freq.put("pan", 2833);
    freq.put("oin", 82);
    freq.put("oil", 25);
    freq.put("oii", 57);
    freq.put("oid", 42);
    freq.put("oiy", 29);
    freq.put("ois", 24);
    freq.put("uju", 469);
    freq.put("pa ", 5994);
    freq.put("uji", 83);
    freq.put("uja", 175);
    freq.put("mo ", 225);
    freq.put("nas", 761);
    freq.put("mos", 115);
    freq.put("mor", 164);
    freq.put("mov", 35);
    freq.put("mot", 264);
    freq.put("mok", 45);
    freq.put("moh", 286);
    freq.put("moo", 72);
    freq.put("mon", 492);
    freq.put("mom", 48);
    freq.put("mol", 51);
    freq.put("mob", 167);
    freq.put("moa", 24);
    freq.put("mog", 526);
    freq.put("mod", 123);
    freq.put("Nen", 36);
    freq.put("Neg", 26);
    freq.put("Dr ", 34);
    freq.put("Med", 33);
    freq.put(" ch", 406);
    freq.put(" ci", 1375);
    freq.put(" cn", 24);
    freq.put(" co", 3858);
    freq.put(" cl", 76);
    freq.put(" cm", 206);
    freq.put(" cb", 29);
    freq.put(" cc", 115);
    freq.put(" ca", 1635);
    freq.put(" ce", 1463);
    freq.put("Met", 77);
    freq.put("kmu", 269);
    freq.put(" cy", 78);
    freq.put("kmr", 151);
    freq.put("Mes", 60);
    freq.put("kmp", 36);
    freq.put(" cr", 138);
    freq.put(" cp", 90);
    freq.put(" cw", 72);
    freq.put(" cu", 1337);
    freq.put(" ʃƪ", 109);
    freq.put("km ", 650);
    freq.put(" c ", 112);
    freq.put("yyy", 174);
    freq.put("yya", 54);
    freq.put("˘⌣˘", 214);
    freq.put(" ́⌣", 27);
    freq.put(" ʃ ", 113);
    freq.put("Ac", 69);
    freq.put("yy ", 209);
    freq.put("Ah", 430);
    freq.put("Ava", 28);
    freq.put("US ", 49);
    freq.put("u", 122765);
    freq.put("gt", 1686);
    freq.put("hy ", 38);
    freq.put("ws ", 85);
    freq.put("Yg ", 300);
    freq.put("ede", 449);
    freq.put("ium", 139);
    freq.put("iun", 102);
    freq.put("TA ", 53);
    freq.put("aja", 5351);
    freq.put("ius", 249);
    freq.put("hya", 50);
    freq.put("aje", 323);
    freq.put("SI ", 44);
    freq.put("hyu", 77);
    freq.put("go", 1982);
    freq.put("gg ", 311);
    freq.put("gm", 530);
    freq.put("aba", 1424);
    freq.put("abb", 44);
    freq.put("gl", 608);
    freq.put("abe", 181);
    freq.put("abg", 41);
    freq.put("͡▿▿", 24);
    freq.put("abi", 1022);
    freq.put("abl", 77);
    freq.put("abn", 29);
    freq.put("abo", 158);
    freq.put("abr", 101);
    freq.put("abs", 84);
    freq.put("abt", 80);
    freq.put("abu", 570);
    freq.put("aby", 52);
    freq.put("ggu", 1234);
    freq.put("ggr", 98);
    freq.put("K", 6628);
    freq.put("ُ", 31);
    freq.put("gge", 164);
    freq.put("ggg", 255);
    freq.put("gga", 2455);
    freq.put("ggo", 176);
    freq.put("ggi", 440);
    freq.put("ggh", 33);
    freq.put("ggk", 25);
    freq.put("ab ", 336);
    freq.put("ntn", 177);
    freq.put("eya", 64);
    freq.put("twa", 28);
    freq.put("eye", 70);
    freq.put("twe", 314);
    freq.put("twi", 492);
    freq.put("jd ", 779);
    freq.put("de ", 795);
    freq.put("ºщ ", 114);
    freq.put("ey ", 350);
    freq.put("tw ", 273);
    freq.put("jdi", 114);
    freq.put("dep", 401);
    freq.put("der", 344);
    freq.put("des", 205);
    freq.put("det", 101);
    freq.put("deu", 110);
    freq.put("dev", 32);
    freq.put("dew", 154);
    freq.put("deh", 1956);
    freq.put("dek", 826);
    freq.put("del", 231);
    freq.put("dem", 294);
    freq.put("den", 1103);
    freq.put("deo", 62);
    freq.put("dea", 115);
    freq.put("deb", 60);
    freq.put("dec", 27);
    freq.put("ded", 53);
    freq.put("dee", 186);
    freq.put("deg", 61);
    freq.put("͡͡", 29);
    freq.put("bk ", 32);
    freq.put("X ", 142);
    freq.put("rya", 69);
    freq.put("▼ˇ ", 48);
    freq.put("Don", 56);
    freq.put("bka", 81);
    freq.put("̩͡", 50);
    freq.put("bkn", 170);
    freq.put("Doa", 34);
    freq.put("bki", 55);
    freq.put("̯͡", 184);
    freq.put("̴͡", 141);
    freq.put("ry ", 313);
    freq.put("hfi", 48);
    freq.put("uh ", 3534);
    freq.put("ok ", 3975);
    freq.put("pcr", 36);
    freq.put(" ʃ˘", 30);
    freq.put("pcu", 31);
    freq.put("Baw", 38);
    freq.put("Bat", 87);
    freq.put("uhe", 30);
    freq.put("oku", 32);
    freq.put("Bas", 28);
    freq.put("Bap", 24);
    freq.put("uha", 440);
    freq.put("uhn", 83);
    freq.put("uhk", 95);
    freq.put("uhh", 191);
    freq.put("Bay", 47);
    freq.put("oka", 378);
    freq.put("Bag", 158);
    freq.put("Bad", 50);
    freq.put("uhu", 275);
    freq.put("Bab", 48);
    freq.put("Bac", 48);
    freq.put("Ban", 411);
    freq.put("okk", 86);
    freq.put("Baj", 41);
    freq.put("okl", 54);
    freq.put("oko", 326);
    freq.put("okn", 111);
    freq.put("˘ڡ˘", 32);
    freq.put("mm ", 446);
    freq.put("E ", 320);
    freq.put("sbr", 30);
    freq.put("͡ ", 320);
    freq.put("mmy", 36);
    freq.put("´▽ ", 179);
    freq.put("sbu", 35);
    freq.put("sby", 29);
    freq.put("̩ƪ ", 196);
    freq.put("sba", 46);
    freq.put("mmi", 27);
    freq.put("sbg", 34);
    freq.put("sbe", 29);
    freq.put("mme", 46);
    freq.put("Uni", 33);
    freq.put("mma", 114);
    freq.put("sbl", 59);
    freq.put("Em", 375);
    freq.put("El", 88);
    freq.put("Om ", 44);
    freq.put("Ei", 39);
    freq.put("Eh", 426);
    freq.put("Ee", 50);
    freq.put("Ed", 37);
    freq.put("Ea", 42);
    freq.put("Ex", 37);
    freq.put("Et", 37);
    freq.put("Er", 49);
    freq.put("́⌣ ", 27);
    freq.put(" el", 377);
    freq.put(" em", 1356);
    freq.put(" en", 1369);
    freq.put(" eo", 41);
    freq.put(" eh", 853);
    freq.put(" ei", 39);
    freq.put("koo", 32);
    freq.put(" ek", 188);
    freq.put(" ed", 119);
    freq.put(" ee", 145);
    freq.put(" ef", 48);
    freq.put(" eg", 45);
    freq.put("koe", 49);
    freq.put(" ea", 108);
    freq.put(" ec", 45);
    freq.put(" ex", 79);
    freq.put(" ey", 51);
    freq.put("koq", 56);
    freq.put(" eu", 159);
    freq.put(" ev", 52);
    freq.put("kor", 273);
    freq.put(" ep", 47);
    freq.put("kot", 270);
    freq.put(" er", 133);
    freq.put(" es", 159);
    freq.put("Sla", 27);
    freq.put("b", 61652);
    freq.put("ko ", 582);
    freq.put(" e ", 249);
    freq.put("▽ˇ ", 32);
    freq.put("k ", 32512);
    freq.put("Kir", 77);
    freq.put("Kit", 106);
    freq.put("Kim", 26);
    freq.put("Ata", 33);
    freq.put("Ati", 28);
    freq.put("kR", 355);
    freq.put("kc", 536);
    freq.put("kb", 605);
    freq.put("ka", 32632);
    freq.put("kg", 238);
    freq.put("ke", 14306);
    freq.put("kd", 127);
    freq.put("kk", 1939);
    freq.put("kj", 49);
    freq.put("ki", 6553);
    freq.put("kh", 1031);
    freq.put("ko", 4416);
    freq.put("kn", 2260);
    freq.put("km", 1522);
    freq.put("kl", 1453);
    freq.put("ks", 1739);
    freq.put("kr", 1206);
    freq.put("kp", 358);
    freq.put("kw", 3526);
    freq.put("ku", 10395);
    freq.put("kt", 1654);
    freq.put("kz", 32);
    freq.put("ky", 728);
    freq.put("Opo", 44);
    freq.put("bnt", 66);
    freq.put("Ser", 169);
    freq.put(" Be", 1353);
    freq.put(" Bg", 41);
    freq.put(" Ba", 1685);
    freq.put(" Bb", 36);
    freq.put(" Bl", 143);
    freq.put(" Bo", 353);
    freq.put(" Bn", 42);

    init3();
  }
  private static void init3() {
    
    freq.put(" Bi", 632);
    freq.put(" Bh", 28);
    freq.put(" Bk", 45);
    freq.put(" Bu", 728);
    freq.put(" Bt", 36);
    freq.put("ik ", 3794);
    freq.put(" Bs", 76);
    freq.put(" Br", 176);
    freq.put(" By", 39);
    freq.put("kto", 71);
    freq.put("DD ", 30);
    freq.put("Seb", 144);
    freq.put("iks", 163);
    freq.put("̖́", 34);
    freq.put(" B ", 189);
    freq.put("iku", 1063);
    freq.put("ikt", 43);
    freq.put("ika", 1755);
    freq.put("ike", 490);
    freq.put("Sen", 173);
    freq.put("ikk", 165);
    freq.put("iki", 1606);
    freq.put("ikh", 72);
    freq.put("iko", 145);
    freq.put("ikn", 165);
    freq.put("ikm", 143);
    freq.put("ikl", 107);
    freq.put("ikR", 25);
    freq.put("Yea", 32);
    freq.put("Yee", 48);
    freq.put("Sej", 34);
    freq.put("Yes", 52);
    freq.put("rae", 36);
    freq.put("lbu", 61);
    freq.put("ga ", 7874);
    freq.put("fu ", 41);
    freq.put("gay", 125);
    freq.put(" ¬ ", 991);
    freq.put("gaw", 119);
    freq.put("gau", 171);
    freq.put("gat", 908);
    freq.put("gas", 491);
    freq.put("gar", 958);
    freq.put("gap", 633);
    freq.put("gan", 4570);
    freq.put("gam", 561);
    freq.put("gal", 1869);
    freq.put("gak", 3252);
    freq.put("gaj", 399);
    freq.put("gai", 284);
    freq.put("gah", 347);
    freq.put("gag", 204);
    freq.put("gae", 36);
    freq.put("gad", 294);
    freq.put("gac", 72);
    freq.put("gab", 250);
    freq.put("gaa", 297);
    freq.put("lba", 189);
    freq.put("fut", 43);
    freq.put("fun", 33);
    freq.put("lbe", 42);
    freq.put("ful", 101);
    freq.put("dg ", 185);
    freq.put("sy ", 144);
    freq.put("Ira", 56);
    freq.put("ewi", 27);
    freq.put("ewo", 32);
    freq.put("bs ", 421);
    freq.put("ewa", 501);
    freq.put("ewe", 437);
    freq.put("jb ", 79);
    freq.put("ews", 29);
    freq.put("sya", 562);
    freq.put("syg", 131);
    freq.put("sye", 44);
    freq.put("dge", 38);
    freq.put("syi", 72);
    freq.put("dgn", 248);
    freq.put("dgr", 35);
    freq.put("syp", 28);
    freq.put("ˆ⌣", 63);
    freq.put("syu", 117);
    freq.put("ew ", 169);
    freq.put("y", 57783);
    freq.put("lda", 38);
    freq.put("˘▽˘", 64);
    freq.put(" ¬͡", 80);
    freq.put("ldi", 40);
    freq.put("Di ", 308);
    freq.put("bi ", 255);
    freq.put("cuu", 49);
    freq.put("cut", 81);
    freq.put("cus", 43);
    freq.put("rgu", 29);
    freq.put("cup", 94);
    freq.put("cuy", 52);
    freq.put("rga", 671);
    freq.put("cue", 39);
    freq.put("cuc", 85);
    freq.put("rge", 104);
    freq.put("cua", 65);
    freq.put("rgg", 31);
    freq.put("rgh", 39);
    freq.put("rgi", 278);
    freq.put("cum", 663);
    freq.put("cul", 118);
    freq.put("cuk", 216);
    freq.put("rgn", 25);
    freq.put("rgo", 40);
    freq.put("Dil", 26);
    freq.put("Dim", 84);
    freq.put("Din", 69);
    freq.put("ld ", 60);
    freq.put("Dih", 58);
    freq.put("bik", 521);
    freq.put("bih", 819);
    freq.put("Dik", 61);
    freq.put("Die", 34);
    freq.put("bid", 45);
    freq.put("bie", 66);
    freq.put("bib", 71);
    freq.put("Dia", 171);
    freq.put("Dib", 55);
    freq.put("bia", 1107);
    freq.put(" ื", 30);
    freq.put("Dit", 70);
    freq.put("bit", 83);
    freq.put("wih", 48);
    freq.put("Dip", 41);
    freq.put("bis", 2586);
    freq.put("Dir", 47);
    freq.put("Dis", 98);
    freq.put("rg ", 1027);
    freq.put("cu ", 243);
    freq.put("uf ", 34);
    freq.put("oe ", 139);
    freq.put("pey", 30);
    freq.put("pet", 981);
    freq.put("pep", 25);
    freq.put("per", 3196);
    freq.put("pes", 202);
    freq.put("pel", 460);
    freq.put("pem", 488);
    freq.put("pen", 2202);
    freq.put("peh", 31);
    freq.put("pej", 35);
    freq.put("pek", 295);
    freq.put("ped", 217);
    freq.put("pee", 86);
    freq.put("peg", 113);
    freq.put("pea", 75);
    freq.put("pec", 103);
    freq.put("ufa", 25);
    freq.put("Bos", 44);
    freq.put("O", 2157);
    freq.put("Bol", 100);
    freq.put("oen", 25);
    freq.put("Bon", 25);
    freq.put("oel", 29);
    freq.put("uft", 34);
    freq.put("ufu", 31);
    freq.put("ä", 30);
    freq.put("pe ", 1227);
    freq.put("nsi", 223);
    freq.put("usl", 52);
    freq.put("nso", 58);
    freq.put("nsa", 72);
    freq.put("nse", 123);
    freq.put("nsf", 44);
    freq.put("nsy", 201);
    freq.put("sd ", 136);
    freq.put("nsp", 47);
    freq.put("nst", 61);
    freq.put("nsu", 53);
    freq.put("mka", 103);
    freq.put("mkn", 79);
    freq.put("Ooo", 61);
    freq.put("Ooh", 37);
    freq.put("mks", 97);
    freq.put("fer", 80);
    freq.put(" R ", 75);
    freq.put("ns ", 227);
    freq.put("sda", 30);
    freq.put("sdn", 39);
    freq.put("Ula", 30);
    freq.put("sdh", 107);
    freq.put("lya", 35);
    freq.put("New", 24);
    freq.put("Nya", 158);
    freq.put("Nye", 59);
    freq.put(" gw", 2096);
    freq.put(" gt", 454);
    freq.put(" gu", 4076);
    freq.put("Mau", 450);
    freq.put("Mat", 121);
    freq.put(" gp", 168);
    freq.put("Maa", 342);
    freq.put(" gg", 79);
    freq.put("Mac", 75);
    freq.put(" ge", 1209);
    freq.put("Mae", 26);
    freq.put("Mad", 26);
    freq.put(" ga", 9262);
    freq.put("Mai", 62);
    freq.put("Mah", 51);
    freq.put("Mak", 473);
    freq.put(" gm", 325);
    freq.put("Mam", 107);
    freq.put("Mal", 259);
    freq.put(" gh", 25);
    freq.put("Man", 382);
    freq.put(" ck", 287);
    freq.put("ly ", 190);
    freq.put("kma", 246);
    freq.put("Mem", 96);
    freq.put(" g ", 392);
    freq.put("kmn", 105);
    freq.put(" b", 36738);
    freq.put(" c", 11419);
    freq.put(" a", 32680);
    freq.put(" f", 2778);
    freq.put(" g", 21800);
    freq.put(" d", 33088);
    freq.put(" e", 5845);
    freq.put(" j", 12872);
    freq.put(" k", 38371);
    freq.put(" h", 14571);
    freq.put(" i", 13629);
    freq.put(" n", 19423);
    freq.put(" o", 5864);
    freq.put(" l", 19039);
    freq.put(" m", 33465);
    freq.put(" r", 5595);
    freq.put(" s", 36598);
    freq.put(" p", 23386);
    freq.put(" q", 365);
    freq.put(" v", 1060);
    freq.put(" w", 5949);
    freq.put(" t", 25388);
    freq.put(" u", 7365);
    freq.put(" z", 339);
    freq.put("̩ ", 904);
    freq.put(" x", 620);
    freq.put(" y", 19506);
    freq.put(" B", 6305);
    freq.put(" C", 2290);
    freq.put(" A", 7275);
    freq.put(" F", 986);
    freq.put(" G", 3776);
    freq.put(" D", 7133);
    freq.put(" E", 1845);
    freq.put(" J", 2646);
    freq.put(" K", 6573);
    freq.put(" H", 5647);
    freq.put(" I", 4165);
    freq.put(" N", 2785);
    freq.put(" O", 2113);
    freq.put(" L", 3056);
    freq.put(" M", 6564);
    freq.put(" R", 34599);
    freq.put(" S", 8067);
    freq.put(" P", 4864);
    freq.put(" Q", 94);
    freq.put(" V", 247);
    freq.put(" W", 2135);
    freq.put(" T", 5773);
    freq.put(" U", 1403);
    freq.put(" Z", 112);
    freq.put(" X", 358);
    freq.put(" Y", 2309);
    freq.put("Mer", 117);
    freq.put("us ", 3261);
    freq.put("̗ ", 32);
    freq.put("Org", 35);
    freq.put("Ora", 123);
    freq.put("oci", 33);
    freq.put("ock", 84);
    freq.put(" ¬", 1219);
    freq.put(" ´", 255);
    freq.put(" º", 170);
    freq.put(" Do", 190);
    freq.put(" Dm", 35);
    freq.put(" Di", 1231);
    freq.put(" De", 394);
    freq.put(" Da", 661);
    freq.put("ii ", 866);
    freq.put(" Du", 240);
    freq.put(" Dr", 108);
    freq.put(" Dp", 25);
    freq.put("cha", 361);
    freq.put("Fr", 52);
    freq.put("che", 142);
    freq.put("chi", 137);
    freq.put("cho", 55);
    freq.put("Fa", 167);
    freq.put("chu", 54);
    freq.put("Fi", 245);
    freq.put("Fl", 30);
    freq.put("Fo", 135);
    freq.put("iit", 53);
    freq.put("iip", 53);
    freq.put("iis", 60);
    freq.put("iir", 46);
    freq.put(" D ", 2350);
    freq.put("iie", 37);
    freq.put("iia", 44);
    freq.put("iin", 621);
    freq.put("iii", 1395);
    freq.put("iih", 285);
    freq.put("iik", 143);
    freq.put("ch ", 198);
    freq.put("f", 6992);
    freq.put("F ", 122);
    freq.put("ack", 417);
    freq.put("SM ", 39);
    freq.put("̩ƪ", 196);
    freq.put("afi", 200);
    freq.put("Yo", 223);
    freq.put("afk", 91);
    freq.put("Щ", 130);
    freq.put("afe", 55);
    freq.put("aff", 33);
    freq.put("Ye", 182);
    freq.put("afa", 93);
    freq.put("Yg", 300);
    freq.put("aft", 65);
    freq.put("Yu", 138);
    freq.put("afs", 26);
    freq.put(" Ơ", 48);
    freq.put(" ƪ", 274);
    freq.put("sip", 296);
    freq.put("Y ", 181);
    freq.put("af ", 1055);
    freq.put(" Ɨ", 137);
    freq.put("da ", 6722);
    freq.put("lR", 36);
    freq.put("eum", 66);
    freq.put("eul", 48);
    freq.put("ld", 204);
    freq.put("eun", 251);
    freq.put("eui", 79);
    freq.put("euh", 181);
    freq.put("вв", 41);
    freq.put("la", 27929);
    freq.put("вм", 41);
    freq.put("eud", 36);
    freq.put("¯٥", 25);
    freq.put("lm", 1139);
    freq.put("lj", 50);
    freq.put("lk", 387);
    freq.put("lh", 1239);
    freq.put("li", 10352);
    freq.put("lv", 47);
    freq.put("lw", 155);
    freq.put("lt", 234);
    freq.put("lu", 7767);
    freq.put("euy", 113);
    freq.put("ls", 556);
    freq.put(" ɔ", 26);
    freq.put("euu", 54);
    freq.put("eut", 38);
    freq.put("eup", 25);
    freq.put("eus", 54);
    freq.put("sif", 45);
    freq.put("dad", 208);
    freq.put("dae", 79);
    freq.put("daf", 41);
    freq.put("dag", 88);
    freq.put("daa", 343);
    freq.put("dal", 931);
    freq.put("dam", 254);
    freq.put("dan", 3425);
    freq.put("dah", 5055);
    freq.put("dai", 179);
    freq.put("dak", 1076);
    freq.put("dat", 511);
    freq.put("dap", 584);
    freq.put("dar", 1954);
    freq.put("das", 221);
    freq.put("day", 278);
    freq.put("sih", 3698);
    freq.put("l ", 10988);
    freq.put("eu ", 289);
    freq.put("ts ", 158);
    freq.put("̴̴͡", 109);
    freq.put("lfa", 94);
    freq.put("lfo", 31);
    freq.put("lfi", 25);
    freq.put("bw ", 26);
    freq.put("̩̩⌣", 66);
    freq.put("rez", 39);
    freq.put("PA ", 52);
    freq.put(" ˆ", 139);
    freq.put(" ˇ", 403);
    freq.put("res", 508);
    freq.put("rep", 200);
    freq.put("rev", 32);
    freq.put("rew", 47);
    freq.put("ret", 322);
    freq.put("reu", 50);
    freq.put("rej", 64);
    freq.put("rek", 554);
    freq.put(" ː", 61);
    freq.put("Tuk", 26);
    freq.put("ren", 1683);
    freq.put("Tum", 37);
    freq.put("rel", 101);
    freq.put("rem", 335);
    freq.put("reb", 130);
    freq.put(" ˛", 47);
    freq.put(" ˘", 1576);
    freq.put("rea", 365);
    freq.put("ref", 29);
    freq.put("reg", 81);
    freq.put("red", 105);
    freq.put("ree", 229);
    freq.put("bwt", 102);
    freq.put(" iy", 1604);
    freq.put("qua", 32);
    freq.put("bwa", 58);
    freq.put("que", 31);
    freq.put(" ʃ", 466);
    freq.put("re ", 580);
    freq.put(" ͡", 392);
    freq.put("pgn", 81);
    freq.put("aAl", 69);
    freq.put("̩̩", 2117);
    freq.put("ud ", 339);
    freq.put(" ╰ ", 28);
    freq.put("og ", 149);
    freq.put("▿", 444);
    freq.put("udu", 330);
    freq.put(" ̩", 574);
    freq.put(" ̮", 217);
    freq.put(" ̯", 44);
    freq.put("ogr", 47);
    freq.put("ogl", 32);
    freq.put("ogo", 118);
    freq.put("uda", 3701);
    freq.put("ogi", 76);
    freq.put("udd", 49);
    freq.put("ogj", 141);
    freq.put("oge", 73);
    freq.put("udh", 826);
    freq.put("udi", 937);
    freq.put("udn", 130);
    freq.put("Pel", 83);
    freq.put(" ̀", 69);
    freq.put(" ́", 70);
    freq.put("nul", 109);
    freq.put(" ̗", 27);
    freq.put("Pap", 33);
    freq.put("Par", 148);
    freq.put("Pas", 214);
    freq.put("Pat", 35);
    freq.put("Pac", 102);
    freq.put("Pad", 167);
    freq.put("Pag", 71);
    freq.put("Pak", 127);
    freq.put("Pal", 91);
    freq.put("Pan", 210);
    freq.put("mii", 174);
    freq.put("mih", 26);
    freq.put("mik", 203);
    freq.put("mim", 258);
    freq.put("mil", 541);
    freq.put("min", 2249);
    freq.put("mia", 76);
    freq.put("mic", 34);
    freq.put("mie", 122);
    freq.put("mis", 301);
    freq.put("mir", 219);
    freq.put("mit", 118);
    freq.put("˘▿˘", 31);
    freq.put("sfe", 31);
    freq.put("mi ", 786);
    freq.put("̲̅", 25);
    freq.put(" iP", 26);
    freq.put("ksu", 263);
    freq.put("kst", 26);
    freq.put(" iz", 34);
    freq.put("kss", 32);
    freq.put(" ip", 134);
    freq.put(" ir", 156);
    freq.put(" щ", 37);
    freq.put(" it", 3163);
    freq.put("Mot", 25);
    freq.put(" ih", 371);
    freq.put(" ii", 96);
    freq.put(" ij", 66);
    freq.put("Moh", 154);
    freq.put("ksa", 233);
    freq.put(" im", 243);
    freq.put(" in", 4752);
    freq.put(" ia", 177);
    freq.put(" ib", 267);
    freq.put(" ic", 92);
    freq.put(" id", 327);
    freq.put("ksh", 90);
    freq.put("Mod", 29);
    freq.put(" Щ", 110);
    freq.put(" з", 67);
    freq.put(" н", 25);
    freq.put("¯ ", 38);
    freq.put("ks ", 292);
    freq.put(" i ", 124);
    freq.put("wl", 55);
    freq.put("Km ", 81);
    freq.put("wk", 4893);
    freq.put("S", 8155);
    freq.put("ww", 283);
    freq.put("wt", 162);
    freq.put("ws", 106);
    freq.put("wr", 45);
    freq.put("wq", 27);
    freq.put("ohn", 37);
    freq.put("oho", 650);
    freq.put("ohh", 178);
    freq.put("ohi", 26);
    freq.put("ˇ▽", 34);
    freq.put("ys ", 96);
    freq.put("OL ", 66);
    freq.put("oha", 76);
    freq.put("cor", 53);
    freq.put("cou", 39);
    freq.put("uin", 292);
    freq.put("ysi", 33);
    freq.put("uis", 45);
    freq.put("coy", 69);
    freq.put("Hor", 32);
    freq.put("uit", 272);
    freq.put(" Fr", 52);
    freq.put(" Fu", 40);
    freq.put(" Fa", 155);
    freq.put(" Fe", 48);
    freq.put(" Fi", 242);
    freq.put(" Fl", 28);
    freq.put(" Fo", 134);
    freq.put("io ", 219);
    freq.put("cob", 368);
    freq.put("Car", 92);
    freq.put("cod", 27);
    freq.put("iou", 31);
    freq.put("ios", 28);
    freq.put("ior", 59);
    freq.put("ion", 624);
    freq.put("iom", 27);
    freq.put("iol", 38);
    freq.put("iob", 24);
    freq.put("GA ", 26);
    freq.put("con", 2819);
    freq.put("kwa", 68);
    freq.put("adw", 68);
    freq.put("adu", 419);
    freq.put("adr", 34);
    freq.put("gmn", 280);
    freq.put("gma", 65);
    freq.put("gmg", 44);
    freq.put("ady", 55);
    freq.put("в", 30);
    freq.put("add", 71);
    freq.put("ade", 714);
    freq.put("ada", 6341);
    freq.put("ado", 209);
    freq.put("adl", 68);
    freq.put("adm", 109);
    freq.put("kwk", 2992);
    freq.put("gmu", 45);
    freq.put("adi", 3328);
    freq.put(" ا", 43);
    freq.put(" в", 30);
    freq.put("ad ", 630);
    freq.put("Mks", 29);
    freq.put("nja", 759);
    freq.put("nje", 186);
    freq.put("ui ", 160);
    freq.put("nji", 360);
    freq.put("njo", 62);
    freq.put("njr", 52);
    freq.put("nju", 365);
    freq.put("tmp", 63);
    freq.put("esu", 564);
    freq.put("est", 460);
    freq.put("ess", 349);
    freq.put("esr", 26);
    freq.put("esp", 32);
    freq.put("̩", 3408);
    freq.put("tma", 29);
    freq.put("ese", 756);
    freq.put("tme", 64);
    freq.put("esa", 993);
    freq.put("eso", 906);
    freq.put("esn", 42);
    freq.put("esm", 46);
    freq.put("esk", 85);
    freq.put("esj", 31);
    freq.put("esi", 962);
    freq.put("esh", 29);
    freq.put("tm ", 34);
    freq.put("es ", 1790);
    freq.put("Twe", 47);
    freq.put("Twi", 50);
    freq.put("Jd ", 108);
    freq.put("bu ", 655);
    freq.put("rct", 25);
    freq.put("rcu", 42);
    freq.put("rco", 53);
    freq.put("rch", 51);
    freq.put("rci", 48);
    freq.put("rce", 96);
    freq.put("rca", 291);
    freq.put("Dep", 31);
    freq.put("bus", 162);
    freq.put("but", 778);
    freq.put("buu", 69);
    freq.put("buk", 1923);
    freq.put("buh", 329);
    freq.put("Dek", 29);
    freq.put("Del", 27);
    freq.put("Dem", 65);
    freq.put("Den", 85);
    freq.put("bum", 117);
    freq.put("bub", 173);
    freq.put("Dea", 49);
    freq.put("bua", 1642);
    freq.put("bud", 116);
    freq.put("j", 25391);
    freq.put("pih", 38);
    freq.put("pii", 79);
    freq.put("pij", 24);
    freq.put("pik", 340);
    freq.put("pil", 235);
    freq.put("pim", 24);
    freq.put("pin", 1016);
    freq.put("pia", 103);
    freq.put("pic", 41);
    freq.put("pid", 31);
    freq.put("pie", 29);
    freq.put("piy", 27);
    freq.put("piz", 25);
    freq.put("ub ", 86);
    freq.put("pip", 72);
    freq.put("pir", 296);
    freq.put("pis", 269);
    freq.put("pit", 113);
    freq.put("oad", 138);
    freq.put("oaa", 37);
    freq.put("oan", 391);
    freq.put("Bkn", 34);
    freq.put("oal", 391);
    freq.put("oak", 66);
    freq.put("oai", 75);
    freq.put("oar", 31);
    freq.put("ubu", 412);
    freq.put("ubr", 24);
    freq.put("pi ", 2267);
    freq.put("ube", 110);
    freq.put("uba", 333);
    freq.put("ubl", 39);
    freq.put("ubh", 77);
    freq.put("ubi", 83);
    freq.put("oa ", 122);
    freq.put("˚Д˚", 24);
    freq.put("Oke", 210);
    freq.put("G ", 366);
    freq.put("ل", 90);
    freq.put("tR", 96);
    freq.put("هُ", 25);
    freq.put("Gw", 257);
    freq.put("Gu", 548);
    freq.put("Gr", 97);
    freq.put("Gp", 66);
    freq.put("Ok ", 56);
    freq.put("Ge", 200);
    freq.put("mw ", 198);
    freq.put("bgd", 26);
    freq.put("Ga", 1501);
    freq.put("ait", 102);
    freq.put("Go", 215);
    freq.put("Gm", 41);
    freq.put("Gl", 31);
    freq.put("Gk", 83);
    freq.put("Gi", 210);
    freq.put(" kb", 117);
    freq.put(" kc", 27);
    freq.put(" ka", 14942);
    freq.put(" kg", 137);
    freq.put(" kd", 59);
    freq.put(" ke", 10301);
    freq.put(" kk", 268);
    freq.put(" kh", 189);
    freq.put(" ki", 2045);
    freq.put(" kn", 577);
    freq.put(" ko", 2921);
    freq.put(" kl", 1077);
    freq.put(" km", 1232);
    freq.put(" kr", 545);
    freq.put(" ks", 127);
    freq.put(" kp", 253);
    freq.put(" kw", 182);
    freq.put(" kt", 270);
    freq.put(" ku", 2135);
    freq.put(" ky", 497);
    freq.put("kuu", 127);
    freq.put("kut", 1075);
    freq.put("Z ", 26);
    freq.put("kur", 545);
    freq.put("kup", 236);
    freq.put("kun", 433);
    freq.put("kum", 269);
    freq.put("kul", 452);
    freq.put("kuk", 178);
    freq.put("kui", 129);
    freq.put("kuh", 83);
    freq.put("kue", 113);
    freq.put("kud", 105);
    freq.put("kuc", 81);
    freq.put("kub", 71);
    freq.put("kua", 321);
    freq.put(" k ", 388);
    freq.put("TT ", 50);
    freq.put("aif", 40);
    freq.put("Za", 31);
    freq.put("tv", 168);
    freq.put("Zz", 45);
    freq.put("ku ", 5814);
    freq.put("Kok", 195);
    freq.put("Kom", 44);
    freq.put("Kon", 61);
    freq.put("Kor", 56);
    freq.put("Kot", 34);
    freq.put("m ", 11148);
    freq.put("Ko ", 61);
    freq.put("mR", 47);
    freq.put("me", 10068);
    freq.put("md", 687);
    freq.put("mg", 637);
    freq.put("mf", 29);
    freq.put("ma", 33267);
    freq.put("mc", 53);
    freq.put("mb", 4937);
    freq.put("mm", 1143);
    freq.put("ml", 292);
    freq.put("mo", 2727);
    freq.put("mn", 1633);
    freq.put("mi", 5201);
    freq.put("mh", 368);
    freq.put("mk", 343);
    freq.put("mj", 82);
    freq.put("mu", 8700);
    freq.put("mt", 85);
    freq.put("mw", 226);
    freq.put("mp", 5448);
    freq.put("ms", 1207);
    freq.put("mr", 372);
    freq.put("my", 236);
    freq.put("ena", 3554);
    freq.put("enc", 578);
    freq.put("end", 2011);
    freq.put("ene", 1651);
    freq.put("eng", 6107);
    freq.put("eni", 885);
    freq.put("enj", 437);
    freq.put("enk", 101);
    freq.put("enn", 260);
    freq.put("eno", 136);
    freq.put("enr", 27);
    freq.put("ens", 207);
    freq.put("ent", 2036);
    freq.put("enu", 589);
    freq.put("env", 31);
    freq.put("щ ", 166);
    freq.put("ON ", 28);
    freq.put("II ", 29);
    freq.put(" gb", 41);
    freq.put("en ", 4072);
    freq.put(" Hy", 40);
    freq.put(" ˇ▼", 48);
    freq.put(" ˇ▽", 31);
    freq.put(" Hu", 234);
    freq.put(" Hi", 284);
    freq.put(" Hh", 207);
    freq.put(" Ho", 198);
    freq.put(" Hm", 138);
    freq.put("̖", 39);
    freq.put(" Ha", 3198);
    freq.put(" He", 672);
    freq.put("ima", 1571);
    freq.put("imb", 137);
    freq.put("ime", 211);
    freq.put("imi", 245);
    freq.put("imm", 25);
    freq.put("cla", 35);
    freq.put("imo", 51);
    freq.put("imn", 156);
    freq.put("imp", 401);
    freq.put("ims", 75);
    freq.put("imu", 504);
    freq.put("Heh", 327);
    freq.put("´⌣", 24);
    freq.put("SA ", 34);
    freq.put(" H ", 168);
    freq.put("im ", 614);
    freq.put("▾˘ ", 42);
    freq.put(" ̯͡", 161);
    freq.put("gom", 326);
    freq.put("gol", 180);
    freq.put("goo", 99);
    freq.put("gon", 183);
    freq.put("gok", 100);
    freq.put("god", 80);
    freq.put("goa", 27);
    freq.put("aju", 323);
    freq.put("goc", 39);
    freq.put("gob", 74);
    freq.put("aji", 318);
    freq.put("ajj", 34);
    freq.put("goy", 43);
    freq.put("ajo", 49);
    freq.put("got", 75);
    freq.put("gop", 35);
    freq.put("gos", 102);
    freq.put("gor", 262);
    freq.put("W", 2155);
    freq.put("go ", 269);
    freq.put("aj ", 231);
    freq.put("be ", 258);
    freq.put("nho", 41);
    freq.put("nir", 26);
    freq.put("toy", 54);
    freq.put("tor", 467);
    freq.put("tos", 96);
    freq.put("top", 176);
    freq.put("tot", 85);
    freq.put("tok", 179);
    freq.put("toh", 170);
    freq.put("toi", 28);
    freq.put("ton", 814);
    freq.put("too", 70);
    freq.put("tol", 268);
    freq.put("tom", 74);
    freq.put("tob", 60);
    freq.put("tog", 42);
    freq.put("nh ", 114);
    freq.put(" Sa", 1599);
    freq.put("to ", 851);
    freq.put("thu", 36);
    freq.put("raf", 61);
    freq.put("rag", 159);
    freq.put("rad", 246);
    freq.put("lbr", 39);
    freq.put("rab", 327);
    freq.put("rac", 99);
    freq.put("raa", 257);
    freq.put("ran", 7311);
    freq.put("ral", 91);
    freq.put("ram", 951);
    freq.put("raj", 144);
    freq.put("rak", 952);
    freq.put("rah", 1484);
    freq.put("rai", 348);
    freq.put("rav", 39);
    freq.put("raw", 225);
    freq.put("rat", 639);
    freq.put("rau", 33);
    freq.put("rar", 342);
    freq.put("ras", 1273);
    freq.put("rap", 762);
    freq.put("lbh", 130);
    freq.put("raz", 24);
    freq.put("ray", 250);
    freq.put("Sya", 102);
    freq.put("thn", 69);
    freq.put("ra ", 2514);
    freq.put("bso", 86);
    freq.put("bsk", 208);
    freq.put("bse", 38);
    freq.put("bsa", 141);
    freq.put("thd", 81);
    freq.put("AS ", 61);
    freq.put("AU ", 41);
    freq.put("Itu", 282);
    freq.put("pku", 43);
    freq.put("a² ", 25);
    freq.put("pka", 134);
    freq.put("pke", 104);
    freq.put("Bin", 55);
    freq.put("och", 30);
    freq.put("Bil", 48);
    freq.put("Bik", 45);
    freq.put("oco", 210);
    freq.put("oca", 178);
    freq.put("oce", 42);
    freq.put("Bia", 205);
    freq.put("Bir", 24);
    freq.put("Bis", 182);
    freq.put("Aaa", 116);
    freq.put("pk ", 82);
    freq.put("Дºщ", 111);
    freq.put("╰ ", 36);
    freq.put("Pet", 29);
    freq.put("nut", 63);
    freq.put("nur", 166);
    freq.put("nus", 220);
    freq.put("Per", 426);
    freq.put("Pes", 28);
    freq.put("nun", 419);
    freq.put("Pem", 149);
    freq.put("Pen", 464);
    freq.put("num", 331);
    freq.put("nuj", 55);
    freq.put("nuh", 267);
    freq.put("Pek", 26);
    freq.put("nug", 28);
    freq.put("nua", 35);
    freq.put("muu", 101);
    freq.put("mut", 259);
    freq.put("´▽", 179);
    freq.put("mus", 243);
    freq.put("mur", 343);
    freq.put("mud", 927);
    freq.put("mua", 1072);
    freq.put("mum", 115);
    freq.put("mul", 757);
    freq.put("mun", 632);
    freq.put("muh", 65);
    freq.put("muk", 439);
    freq.put("XD ", 101);
    freq.put("bep", 24);
    freq.put("nu ", 200);
    freq.put("▿▿ ", 31);
    freq.put("mu ", 3515);
    freq.put(" md", 32);
    freq.put(" me", 7308);
    freq.put(" mg", 66);
    freq.put(" ma", 16372);
    freq.put(" mb", 797);
    freq.put(" mc", 30);
    freq.put(" ml", 221);
    freq.put(" mm", 91);
    freq.put(" mn", 331);
    freq.put(" mo", 1227);
    freq.put(" mh", 80);
    freq.put(" mi", 2270);
    freq.put(" mj", 68);
    freq.put(" mk", 252);
    freq.put(" mt", 40);
    freq.put(" mu", 2978);
    freq.put(" mw", 190);
    freq.put(" mp", 74);
    freq.put(" mr", 118);
    freq.put(" ms", 535);
    freq.put("Дº", 132);
    freq.put(" my", 126);
    freq.put("kw ", 300);
    freq.put(" m ", 214);
    freq.put("xxx", 24);
    freq.put("̮¬ ", 38);
    freq.put("TV ", 120);
    freq.put("ˆ▽", 30);
    freq.put("n", 190189);
    freq.put("ape", 916);
    freq.put("̩⌣˘", 62);
    freq.put(" ˆ⌣", 61);
    freq.put("̮Ơ", 55);
    freq.put("̾ ", 49);
    freq.put("elk", 24);
    freq.put("eli", 1503);
    freq.put("eln", 37);
    freq.put("elo", 715);
    freq.put("ell", 258);
    freq.put("elm", 52);
    freq.put("elc", 25);
    freq.put("ela", 4197);
    freq.put("elf", 48);
    freq.put("¯", 73);
    freq.put("ele", 1025);
    freq.put(" ◦ ", 60);
    freq.put("els", 56);
    freq.put("elp", 91);
    freq.put("elu", 1551);
    freq.put("UI ", 35);
    freq.put("D", 7290);
    freq.put("el ", 1242);
    freq.put("hs ", 49);
    freq.put(" Ju", 240);
    freq.put(" Jl", 33);
    freq.put(" Jo", 139);
    freq.put(" Ji", 153);
    freq.put(" Je", 187);
    freq.put(" Jd", 126);
    freq.put(" Jg", 189);
    freq.put(" Ja", 1329);
    freq.put("ick", 110);
    freq.put("ici", 186);
    freq.put("Hy", 42);
    freq.put("ico", 80);
    freq.put("ica", 207);
    freq.put("ice", 151);
    freq.put("Hu", 235);
    freq.put("Hh", 211);
    freq.put("Hi", 292);
    freq.put("Ho", 205);
    freq.put("Hm", 139);
    freq.put("Ha", 3229);
    freq.put("icu", 61);
    freq.put("He", 676);
    freq.put("hsy", 26);
    freq.put(" J ", 24);
    freq.put("ic ", 114);
    freq.put("╭", 39);
    freq.put("H ", 500);
    freq.put("thr", 98);
    freq.put("ppa", 53);
    freq.put("aha", 14629);
    freq.put("ahe", 88);
    freq.put("ahk", 281);
    freq.put("ppi", 30);
    freq.put("ahi", 991);
    freq.put("ppo", 52);
    freq.put("aho", 59);
    freq.put("ahl", 127);
    freq.put("ppl", 28);
    freq.put("ahr", 263);
    freq.put("ahs", 36);
    freq.put("ppp", 60);
    freq.put("ahw", 54);
    freq.put("ahu", 942);
    freq.put("ppy", 217);
    freq.put("ahy", 32);
    freq.put("git", 1209);
    freq.put("gis", 310);
    freq.put("gir", 163);
    freq.put("gig", 107);
    freq.put("gie", 26);
    freq.put("gid", 50);
    freq.put("gib", 24);
    freq.put("gia", 396);
    freq.put("gin", 1678);
    freq.put("gim", 333);
    freq.put("gil", 539);
    freq.put("gik", 135);
    freq.put("gii", 122);
    freq.put("gih", 111);
    freq.put("ah ", 23094);
    freq.put("pp ", 388);
    freq.put("eyy", 50);
    freq.put(" ´ ", 45);
    freq.put("gi ", 3590);
    freq.put("nnn", 343);
    freq.put("̃", 33);
    freq.put("nni", 121);
    freq.put("nng", 46);
    freq.put("nne", 63);
    freq.put("nna", 131);
    freq.put("nny", 1622);
    freq.put("nR", 176);
    freq.put("nnt", 194);
    freq.put("nh", 216);
    freq.put("ni", 10764);
    freq.put("nj", 1810);
    freq.put("nk", 1492);
    freq.put("nl", 368);
    freq.put("nm", 277);
    freq.put("nn", 3032);
    freq.put("no", 1674);
    freq.put("tit", 141);
    freq.put("na", 14960);
    freq.put("nb", 91);
    freq.put("nc", 1609);
    freq.put("nd", 7437);
    freq.put("ne", 5043);
    freq.put("nf", 325);
    freq.put("ng", 47436);
    freq.put("nx", 26);
    freq.put("ny", 20421);
    freq.put("nz", 48);
    freq.put("tio", 482);
    freq.put("tih", 259);
    freq.put("tii", 179);
    freq.put("ES ", 44);
    freq.put("np", 702);
    freq.put("nr", 145);
    freq.put("ns", 1219);
    freq.put("nt", 13355);
    freq.put("nu", 1964);
    freq.put("nv", 106);
    freq.put("tic", 43);
    freq.put("ll", 3059);
    freq.put("nn ", 428);
    freq.put("ich", 107);
    freq.put("n ", 54018);
    freq.put("ti ", 4134);
    freq.put("roh", 50);
    freq.put("roi", 41);
    freq.put("roj", 31);
    freq.put("rok", 214);
    freq.put("rol", 107);
    freq.put("rom", 191);
    freq.put("ron", 293);
    freq.put("roo", 74);
    freq.put("roa", 28);
    freq.put("rob", 79);
    freq.put("roc", 36);
    freq.put("rod", 58);
    freq.put("rof", 46);
    freq.put("Lem", 40);
    freq.put("roy", 41);
    freq.put("lli", 83);
    freq.put("llo", 417);
    freq.put("lll", 91);
    freq.put("rop", 63);
    freq.put("llb", 109);
    freq.put("ror", 87);
    freq.put("ros", 108);
    freq.put("rot", 119);
    freq.put("rou", 36);
    freq.put("rov", 34);
    freq.put("row", 41);
    freq.put("Dal", 62);
    freq.put("Dan", 182);
    freq.put("Dah", 33);
    freq.put("Dat", 37);
    freq.put("Dap", 32);
    freq.put("Dar", 127);
    freq.put("Das", 48);
    freq.put("Cia", 26);
    freq.put("Cie", 147);
    freq.put("kle", 38);
    freq.put("ro ", 487);
    freq.put("Cin", 132);
    freq.put("Cir", 31);
    freq.put("Cit", 35);
    freq.put("Ciy", 56);
    freq.put("ll ", 491);
    freq.put("kla", 249);
    freq.put("ªhª", 26);
    freq.put("pmu", 37);
    freq.put("klo", 569);
    freq.put("Res", 42);
    freq.put(" db", 71);
    freq.put("Rek", 25);
    freq.put("Ren", 33);
    freq.put("  ", 39);
    freq.put("Aga", 39);
    freq.put("pm ", 24);
    freq.put("Agu", 42);
    freq.put("ngo", 568);
    freq.put("˚ ", 144);
    freq.put("ngt", 104);
    freq.put("msu", 63);
    freq.put("msn", 29);
    freq.put("Uda", 487);
    freq.put("msk", 55);
    freq.put("msi", 83);
    freq.put("msh", 312);
    freq.put("mse", 30);
    freq.put("msa", 100);
    freq.put("dp ", 47);
    freq.put("ms ", 443);
    freq.put(" on", 346);
    freq.put(" oo", 177);
    freq.put(" ol", 433);
    freq.put(" om", 391);
    freq.put(" oj", 59);
    freq.put(" ok", 469);
    freq.put(" oh", 438);
    freq.put(" oi", 68);
    freq.put(" of", 122);
    freq.put(" og", 102);
    freq.put("kya", 139);
    freq.put(" ob", 119);
    freq.put(" oc", 27);
    freq.put(" oa", 44);
    freq.put(" oy", 36);
    freq.put(" ov", 33);
    freq.put(" ow", 55);
    freq.put(" ot", 156);
    freq.put(" ou", 44);
    freq.put(" or", 1814);
    freq.put(" os", 48);
    freq.put(" op", 297);
    freq.put("ky ", 171);
    freq.put(" o ", 408);
    freq.put("Fan", 24);
    freq.put("gta", 52);
    freq.put("gtu", 243);
    freq.put("HR ", 236);
    freq.put("ahn", 297);
    freq.put("ng ", 22908);
    freq.put("ahm", 138);
    freq.put("shu", 33);
    freq.put("gt ", 1231);
    freq.put("ecu", 76);
    freq.put("º̩", 24);
    freq.put("EN ", 29);
    freq.put("eji", 27);
    freq.put("eje", 174);
    freq.put("eja", 470);
    freq.put("ksd", 63);
    freq.put(" wu", 82);
    freq.put("eju", 87);
    freq.put("shi", 160);
    freq.put("́⌣", 27);
    freq.put("yup", 38);
    freq.put("yus", 86);
    freq.put("yur", 87);
    freq.put("yuu", 196);
    freq.put("yut", 51);
    freq.put("yuh", 51);
    freq.put("yuk", 440);
    freq.put("yum", 180);
    freq.put("yul", 48);
    freq.put("yun", 171);
    freq.put("jwb", 38);
    freq.put("yud", 53);
    freq.put("hu ", 275);
    freq.put("iam", 154);
    freq.put("IM ", 45);
    freq.put("ian", 2440);
    freq.put("iah", 472);
    freq.put("iak", 160);
    freq.put("iaj", 101);
    freq.put("iad", 78);
    freq.put("iaa", 268);
    freq.put("iay", 36);
    freq.put("iau", 42);
    freq.put("iat", 1109);
    freq.put("iaw", 49);
    freq.put("iap", 1645);
    freq.put("ias", 689);
    freq.put("iar", 812);
    freq.put("huf", 42);
    freq.put("hug", 25);
    freq.put("hua", 201);
    freq.put("hub", 156);
    freq.put("hul", 60);
    freq.put("hum", 54);
    freq.put("hun", 530);
    freq.put("huh", 173);
    freq.put("huj", 67);
    freq.put("huk", 92);
    freq.put("hut", 49);
    freq.put("huu", 110);
    freq.put("hur", 270);
    freq.put("hus", 69);
    freq.put("Mis", 42);
    freq.put("ia ", 3235);
    freq.put("r", 84826);
    freq.put("pre", 266);
    freq.put("ane", 617);
    freq.put("anf", 31);
    freq.put("ang", 20795);
    freq.put("pra", 140);
    freq.put("ana", 4492);
    freq.put("anb", 28);
    freq.put("anc", 557);
    freq.put("anl", 118);
    freq.put("ƚɑƗ", 34);
    freq.put("pro", 302);
    freq.put("prn", 71);
    freq.put("pri", 288);
    freq.put("ani", 916);
    freq.put("anj", 881);
    freq.put("ank", 707);
    freq.put("ant", 3870);
    freq.put("prt", 40);
    freq.put("anp", 184);
    freq.put("ans", 393);
    freq.put("any", 4469);
    freq.put("gky", 24);
    freq.put("▽ˆ ", 29);
    freq.put(" L ", 50);
    freq.put("gkr", 73);
    freq.put("gku", 232);
    freq.put("gkt", 24);
    freq.put("gki", 398);
    freq.put("gko", 161);
    freq.put("gkn", 57);
    freq.put("gka", 969);
    freq.put("gke", 201);
    freq.put("uys", 52);
    freq.put("uyu", 89);
    freq.put("pr ", 96);
    freq.put("ˆ", 276);
    freq.put("uyy", 31);
    freq.put("uya", 32);
    freq.put(" Lg", 101);
    freq.put(" Le", 594);
    freq.put(" La", 794);
    freq.put(" Lo", 356);
    freq.put(" Li", 412);
    freq.put(" Lh", 65);
    freq.put(" Lu", 312);
    freq.put("gk ", 539);
    freq.put("tka", 228);
    freq.put("itl", 24);
    freq.put("hku", 77);
    freq.put("nla", 147);
    freq.put("tku", 103);
    freq.put("nli", 57);
    freq.put("dy ", 337);
    freq.put("ss ", 797);
    freq.put("nlo", 116);
    freq.put(" ́ ", 43);
    freq.put("tk ", 257);
    freq.put("sst", 37);
    freq.put("sss", 459);
    freq.put("ssi", 108);
    freq.put("ssh", 38);
    freq.put("sse", 38);
    freq.put("ssa", 131);
    freq.put("dya", 62);
    freq.put("lny", 526);
    freq.put("rmu", 79);
    freq.put("rma", 458);
    freq.put("rme", 54);
    freq.put("lng", 76);
    freq.put("rmi", 92);
    freq.put("rmo", 42);
    freq.put("Ih ", 105);
    freq.put("Ckc", 78);
    freq.put("rm ", 48);
    freq.put("ln ", 117);
    freq.put("Ihh", 38);
    freq.put("pow", 25);
    freq.put("pot", 217);
    freq.put("por", 342);
    freq.put("pos", 177);
    freq.put("pop", 89);
    freq.put("pon", 272);
    freq.put("poo", 71);
    freq.put("pol", 228);
    freq.put("pok", 288);
    freq.put("poh", 35);
    freq.put("poi", 49);
    freq.put("pod", 25);
    freq.put("poc", 56);
    freq.put("Bur", 26);
    freq.put("Bus", 55);
    freq.put("But", 44);
    freq.put("Buk", 256);
    freq.put("Bun", 52);
    freq.put("Bul", 53);
    freq.put("Bub", 24);
    freq.put("Bua", 144);
    freq.put("Bud", 26);
    freq.put("ala", 7404);
    freq.put("po ", 394);
    freq.put("Oal", 27);
    freq.put("oks", 24);
    freq.put("Bau", 24);
    freq.put("Bar", 324);
    freq.put("okt", 90);
    freq.put("yh ", 33);
    freq.put("ºД", 124);
    freq.put("I ", 750);
    freq.put("uhi", 64);
    freq.put("Iy", 1077);
    freq.put("ºщ", 114);
    freq.put("Is", 171);
    freq.put("Ir", 88);
    freq.put("It", 316);
    freq.put("Ii", 49);
    freq.put("Ih", 163);
    freq.put("Ik", 134);
    freq.put("Im", 39);
    freq.put("Il", 25);
    freq.put("In", 1167);
    freq.put("Ia", 69);
    freq.put("oke", 559);
    freq.put("Ib", 61);
    freq.put("Ie", 27);
    freq.put("Id", 201);
    freq.put("tiw", 27);
    freq.put(" qt", 72);
    freq.put(" qu", 39);
    freq.put("tip", 210);
    freq.put(" qa", 64);
    freq.put("tir", 280);
    freq.put("tis", 408);
    freq.put("Bal", 90);
    freq.put("til", 114);
    freq.put("tim", 490);
    freq.put("tin", 2573);
    freq.put("Bak", 56);
    freq.put("Bah", 133);
    freq.put("wb ", 34);
    freq.put("Bai", 55);
    freq.put("yc", 25);
    freq.put("tik", 1175);
    freq.put(" q ", 90);
    freq.put("tid", 1298);
    freq.put("tif", 212);
    freq.put("tig", 77);
    freq.put("Pil", 25);
    freq.put("Pin", 85);
    freq.put("tia", 664);
    freq.put("tib", 143);
    freq.put("wba", 34);
    freq.put("ªh", 29);
    freq.put("Kur", 63);
    freq.put("Kun", 45);
    freq.put("alt", 48);
    freq.put("Kua", 30);
    freq.put("yaA", 63);
    freq.put("o ", 12547);
    freq.put(" ¯", 66);
    freq.put(" ", 52);
    freq.put("oR", 63);
    freq.put("Ku ", 36);
    freq.put("oo", 3111);
    freq.put("on", 12279);
    freq.put("om", 2916);
    freq.put("ol", 4702);
    freq.put("ok", 5968);
    freq.put("oj", 179);
    freq.put("oi", 534);
    freq.put("oh", 2637);
    freq.put("og", 1329);
    freq.put("of", 226);
    freq.put("oe", 328);
    freq.put("od", 1202);
    freq.put("oc", 629);
    freq.put("ob", 1466);
    freq.put("oa", 1348);
    freq.put("oz", 46);
    freq.put("oy", 740);
    freq.put("ox", 66);
    freq.put("ow", 1286);
    freq.put("ov", 338);
    freq.put("ou", 721);
    freq.put("ot", 2331);
    freq.put("os", 1799);
    freq.put("or", 5326);
    freq.put("oq", 83);
    freq.put("op", 1206);
    freq.put("ju ", 476);
    freq.put("ehR", 41);
    freq.put("FB ", 29);
    freq.put("ehe", 2001);
    freq.put("eha", 387);
    freq.put("eho", 24);
    freq.put("ehm", 34);
    freq.put("ehh", 367);
    freq.put("ehi", 124);
    freq.put("jua", 350);
    freq.put("jug", 1730);
    freq.put("jud", 114);
    freq.put("juj", 78);
    freq.put("juk", 112);
    freq.put("jun", 205);
    freq.put("UE ", 32);
    freq.put("jul", 37);
    freq.put("jum", 160);
    freq.put("jur", 222);
    freq.put("jus", 90);
    freq.put("jut", 251);
    freq.put("eh ", 5191);
    freq.put(" ▿ ", 200);
    freq.put("rve", 24);
    freq.put("igu", 49);
    freq.put("ige", 30);
    freq.put("iga", 245);
    freq.put("igo", 46);
    freq.put("ign", 37);
    freq.put("igi", 139);
    freq.put("igh", 117);
    freq.put("hwa", 78);
    freq.put("hmm", 173);
    freq.put("ig ", 56);
    freq.put("pto", 86);
    freq.put("alo", 2169);
    freq.put("all", 609);
    freq.put("alm", 51);
    freq.put("alk", 148);
    freq.put("pti", 61);
    freq.put("ali", 3757);
    freq.put("alf", 96);
    freq.put("pte", 120);
    freq.put("ale", 1424);
    freq.put("alb", 49);
    freq.put("lly", 79);
    freq.put("pta", 55);
    freq.put("┎", 24);
    freq.put("ptu", 27);
    freq.put("uw ", 32);
    freq.put("als", 73);
    freq.put("SH ", 38);
    freq.put(" N ", 38);
    freq.put("far", 75);
    freq.put("fas", 57);
    freq.put("fav", 39);
    freq.put("fat", 69);
    freq.put("pt ", 381);
    freq.put("fak", 50);
    freq.put("fah", 35);
    freq.put("fai", 192);
    freq.put("uwo", 27);
    freq.put("llu", 28);
    freq.put("fal", 39);
    freq.put("fam", 25);
    freq.put("fac", 50);
    freq.put("uwa", 47);
    freq.put("rog", 53);
    freq.put("uwe", 71);
    freq.put(" Ni", 215);
    freq.put(" No", 232);
    freq.put(" Nn", 33);
    freq.put(" Na", 657);
    freq.put(" Ne", 177);
    freq.put(" Nd", 64);
    freq.put(" Ng", 692);
    freq.put(" Ny", 248);
    freq.put(" Nu", 91);
    freq.put(" Nt", 117);
    freq.put("teh", 342);
    freq.put("tek", 260);
    freq.put("tel", 694);
    freq.put("tem", 1784);
    freq.put("ten", 1342);
    freq.put("tea", 63);
    freq.put("teb", 118);
    freq.put("tec", 30);
    freq.put("ted", 87);
    freq.put("BM ", 54);
    freq.put("teg", 155);
    freq.put("tep", 381);
    freq.put("Unt", 97);
    freq.put("nba", 40);
    freq.put("tes", 245);
    freq.put("tet", 503);
    freq.put("lla", 1611);
    freq.put("sug", 38);
    freq.put("sue", 29);
    freq.put("sud", 752);
    freq.put("suc", 31);
    freq.put("sub", 159);
    freq.put("sua", 704);
    freq.put("sun", 547);
    freq.put("sum", 283);
    freq.put("sul", 181);
    freq.put("suk", 1648);
    freq.put("suj", 38);
    freq.put("suh", 91);
    freq.put("suu", 25);
    freq.put("sut", 57);
    freq.put("sus", 387);
    freq.put("sur", 404);
    freq.put("sup", 223);
    freq.put("te ", 832);
    freq.put("mmm", 314);
    freq.put("su ", 181);
    freq.put("rku", 174);
    freq.put("rke", 156);
    freq.put("Ton", 24);
    freq.put("rka", 482);
    freq.put("Tol", 67);
    freq.put(" ºД", 123);
    freq.put("rko", 56);
    freq.put("rki", 84);
    freq.put("sbn", 30);
    freq.put("En", 335);
    freq.put("rk ", 93);
    freq.put("╥", 160);
    freq.put("Int", 43);
    freq.put("Ins", 89);
    freq.put("Inn", 24);
    freq.put("Ini", 366);
    freq.put("v", 2995);
    freq.put("Ind", 430);
    freq.put("Inf", 52);
    freq.put("Ing", 93);
    freq.put("Ina", 26);
    freq.put("ˇ▼ˇ", 49);
    freq.put("Ak ", 71);
    freq.put("Ơ", 105);
    freq.put("oyy", 36);
    freq.put("lh ", 223);
    freq.put("oyo", 118);
    freq.put("Bsk", 45);
    freq.put("oye", 49);
    freq.put("oyb", 25);
    freq.put("oya", 115);
    freq.put("Aku", 706);
    freq.put("Akh", 107);
    freq.put("Aka", 44);
    freq.put("lha", 726);
    freq.put("lho", 226);
    freq.put("oy ", 318);
    freq.put("¯٥ ", 24);
    freq.put("yn ", 31);
    freq.put("L", 3199);
    freq.put("anu", 259);
    freq.put("Rad", 27);
    freq.put("Rab", 53);
    freq.put("Ran", 35);
    freq.put("Ram", 129);
    freq.put("Raj", 33);
    freq.put("Rat", 27);
    freq.put("Ras", 59);
    freq.put("Ray", 76);
    freq.put(" sy", 602);
    freq.put("Mus", 47);
    freq.put(" sr", 51);
    freq.put(" ss", 49);
    freq.put(" sp", 313);
    freq.put(" sw", 84);
    freq.put(" st", 546);
    freq.put(" su", 3118);
    freq.put(" sj", 26);
    freq.put("Mud", 151);
    freq.put(" sh", 529);
    freq.put(" si", 5670);
    freq.put(" sn", 182);
    freq.put(" so", 1604);
    freq.put(" sl", 300);
    freq.put(" sm", 1886);
    freq.put(" sb", 237);
    freq.put("Mul", 82);
    freq.put("Mun", 66);
    freq.put("Muh", 42);
    freq.put("Muk", 28);
    freq.put(" se", 10707);
    freq.put("iza", 38);
    freq.put("gur", 207);
    freq.put("izi", 75);
    freq.put("izk", 34);
    freq.put("izz", 42);
    freq.put("►", 44);
    freq.put("koh", 42);
    freq.put("kok", 1354);
    freq.put("Mu ", 38);
    freq.put("kom", 279);
    freq.put(" s ", 173);
    freq.put("kol", 454);
    freq.put("iz ", 44);
    freq.put("kon", 480);
    freq.put("koc", 49);
    freq.put("kod", 27);
    freq.put("gpa", 44);
    freq.put("TL ", 132);
    freq.put("gpp", 157);
    freq.put(" et", 108);
    freq.put("kop", 138);
    freq.put("kos", 186);
    freq.put("Nun", 28);
    freq.put("kow", 32);
    freq.put("atl", 64);
    freq.put("efa", 32);
    freq.put("efe", 52);
    freq.put("ef ", 24);
    freq.put("rte", 257);
    freq.put("rtd", 27);
    freq.put("rta", 997);
    freq.put("rto", 78);
    freq.put("rtn", 31);
    freq.put("rti", 1292);
    freq.put("rth", 92);
    freq.put("rtu", 183);
    freq.put("Ju", 247);
    freq.put("ies", 73);
    freq.put("ier", 34);
    freq.put("ieu", 87);
    freq.put("IA ", 68);
    freq.put("Jl", 33);
    freq.put("Jo", 141);
    freq.put("iem", 122);
    freq.put("iel", 48);
    freq.put("ien", 129);
    freq.put("Jd", 128);
    freq.put("Je", 189);
    freq.put("Jg", 189);
    freq.put("iee", 215);
    freq.put("Ja", 1336);
    freq.put("hir", 1331);
    freq.put("his", 58);
    freq.put("hit", 126);
    freq.put("rt ", 235);
    freq.put("hiy", 32);
    freq.put("hia", 36);
    freq.put("hib", 57);
    freq.put("hid", 325);
    freq.put("hih", 415);
    freq.put("hii", 94);
    freq.put("hij", 25);
    freq.put("hik", 126);
    freq.put("hil", 223);
    freq.put("him", 49);
    freq.put("hin", 545);
    freq.put("┌П┐", 57);
    freq.put("ie ", 561);
    freq.put("J ", 107);
    freq.put("arp", 35);
    freq.put("arr", 192);
    freq.put("ars", 141);
    freq.put("art", 1180);
    freq.put("aru", 2348);
    freq.put("ary", 92);
    freq.put("ara", 6441);
    freq.put("arb", 62);
    freq.put("arc", 151);
    freq.put("ard", 175);
    freq.put("are", 1254);
    freq.put("arg", 558);
    freq.put("arh", 26);
    freq.put("ari", 4716);
    freq.put("arj", 27);
    freq.put("ark", 354);
    freq.put("arl", 83);
    freq.put("uu ", 858);
    freq.put("arn", 532);
    freq.put("aro", 158);
    freq.put("al ", 4326);
    freq.put("aaw", 36);
    freq.put(" P ", 298);
    freq.put("uuu", 1295);
    freq.put("uut", 67);
    freq.put("uus", 50);
    freq.put("uur", 64);
    freq.put("ar ", 5977);
    freq.put("uul", 33);
    freq.put(" ˛ ", 47);
    freq.put("uun", 103);
    freq.put("uuh", 197);
    freq.put("uuk", 109);
    freq.put(" Ps", 25);
    freq.put(" Pr", 240);
    freq.put("c", 21997);
    freq.put(" Pu", 397);
    freq.put(" Pa", 1269);
    freq.put(" Pg", 33);
    freq.put(" Pe", 1292);
    freq.put(" Pd", 44);
    freq.put(" Pi", 191);
    freq.put(" Po", 191);
    freq.put(" Pn", 30);
    freq.put(" Pl", 113);
    freq.put("pR", 228);
    freq.put("tgg", 26);
    freq.put("tgl", 276);
    freq.put("swi", 24);
    freq.put("ps", 491);
    freq.put("pp", 894);
    freq.put("duk", 357);
    freq.put("dul", 1921);
    freq.put("dum", 45);
    freq.put("pt", 804);
    freq.put("pu", 5799);
    freq.put("swa", 91);
    freq.put("dua", 300);
    freq.put("̖́ ", 24);
    freq.put("py", 298);
    freq.put("swe", 54);
    freq.put("dug", 57);
    freq.put("pc", 107);
    freq.put("pa", 19681);
    freq.put("pg", 146);
    freq.put("pd", 531);
    freq.put("pe", 9840);
    freq.put("dup", 387);
    freq.put("pk", 421);
    freq.put("dur", 1064);
    freq.put("pi", 5086);
    freq.put("pn", 685);
    freq.put("po", 2350);
    freq.put("pl", 970);
    freq.put("pm", 97);
    freq.put("Emg", 96);
    freq.put("Ema", 197);
    freq.put("tg ", 179);
    freq.put("du ", 243);
    freq.put("gem", 289);
    freq.put("p ", 8791);
    freq.put("riz", 60);
    freq.put("riy", 33);
    freq.put("riv", 32);
    freq.put("riw", 26);
    freq.put("rit", 672);
    freq.put("riu", 230);
    freq.put("rir", 41);
    freq.put("ris", 494);
    freq.put("rip", 383);
    freq.put("rin", 1934);
    freq.put("rio", 84);
    freq.put("ril", 98);
    freq.put("rim", 706);
    freq.put("rik", 673);
    freq.put("rih", 49);
    freq.put("rii", 142);
    freq.put("rif", 62);
    freq.put("rig", 53);
    freq.put("rid", 103);
    freq.put("rie", 138);
    freq.put("rib", 365);
    freq.put("ric", 75);
    freq.put("Tib", 24);
    freq.put("ria", 528);
    freq.put("qaq", 55);
    freq.put("Cow", 44);
    freq.put("Cob", 93);
    freq.put("Com", 24);
    freq.put("ri ", 5338);
    freq.put("Con", 42);
    freq.put("qa ", 44);
    freq.put("Air", 26);
    freq.put("Aid", 36);
    freq.put("ahh", 1334);
    freq.put("Nnt", 25);
    freq.put("zz ", 141);
    freq.put("zzz", 222);
    freq.put("zza", 28);
    freq.put("wn ", 70);
    freq.put(" uy", 35);
    freq.put(" ut", 264);
    freq.put(" uu", 36);
    freq.put(" uw", 36);
    freq.put(" up", 255);
    freq.put(" ur", 196);
    freq.put(" us", 392);
    freq.put(" ul", 342);
    freq.put(" um", 216);
    freq.put(" un", 1023);
    freq.put(" uh", 52);
    freq.put(" uj", 118);
    freq.put("Msh", 38);
    freq.put(" ud", 3268);
    freq.put(" ue", 24);
    freq.put(" ua", 127);
    freq.put(" ub", 54);
    freq.put(" uc", 79);
    freq.put("ixi", 65);
    freq.put(" uR", 25);
    freq.put("wnl", 67);
    freq.put(" u ", 626);
    freq.put("Udh", 118);
    freq.put("͡▿", 26);
    freq.put("ca ", 521);
    freq.put("å", 30);
    freq.put("ix ", 63);
    freq.put("z", 2377);
    freq.put("cin", 852);
    freq.put("gru", 53);
    freq.put("¬˛¬", 25);
    freq.put("gre", 98);
    freq.put("gra", 262);
    freq.put("gro", 45);
    freq.put("gri", 141);
    freq.put("gr ", 82);
    freq.put("eda", 750);
    freq.put("⌣ƪ", 116);
    freq.put("edi", 647);
    freq.put("edo", 100);
    freq.put("edl", 29);
    freq.put("⌒", 42);
    freq.put("edu", 236);
    freq.put("edy", 30);
    freq.put("̩̩ƪ", 105);
    freq.put("̾̾ ", 28);
    freq.put("EH ", 32);
    freq.put("˘̩̩", 527);
    freq.put("uga", 2008);
    freq.put("ed ", 425);
    freq.put("cay", 207);
    freq.put("P", 4943);
    freq.put("Kyk", 26);
    freq.put("car", 1419);
    freq.put("Kyu", 28);
    freq.put("rro", 54);
    freq.put("rri", 38);
    freq.put("rrg", 34);
    freq.put("rra", 45);
    freq.put("rry", 172);
    freq.put("cat", 105);
    freq.put("rrr", 499);
    freq.put("bdg", 58);
    freq.put("bda", 33);
    freq.put("ˇ ", 450);
    freq.put("▾", 53);
    freq.put("rr ", 377);
    freq.put("Yuk", 53);
    freq.put("hka", 352);
    freq.put("caf", 26);
    freq.put("̩̩͡", 39);
    freq.put("kyk", 238);
    freq.put("apr", 35);
    freq.put("aps", 53);
    freq.put("app", 310);
    freq.put("apt", 134);
    freq.put("apu", 369);
    freq.put("apk", 127);
    freq.put("api", 1767);
    freq.put("apn", 27);
    freq.put("apo", 166);
    freq.put("apl", 63);
    freq.put("Mim", 36);
    freq.put("apa", 7631);
    freq.put("Mil", 59);
    freq.put("use", 189);
    freq.put("fee", 32);
    freq.put("feb", 29);
    freq.put("Hua", 66);
    freq.put("usa", 1119);
    freq.put("usn", 172);
    freq.put("fel", 25);
    freq.put("Min", 349);
    freq.put("Huh", 29);
    freq.put("fek", 59);
    freq.put("usi", 577);
    freq.put("ush", 90);
    freq.put("Huu", 31);
    freq.put("usu", 341);
    freq.put("ust", 326);
    freq.put("uss", 130);
    freq.put("fes", 28);
    freq.put(" Щ ", 107);
    freq.put(" od", 35);
    freq.put("Gua", 138);
    freq.put("Gue", 297);
    freq.put("º ", 31);
    freq.put("Gun", 39);
    freq.put("Gur", 24);
    freq.put("ap ", 1815);
    freq.put(" Ru", 159);
    freq.put(" Rp", 59);
    freq.put("fe ", 72);
    freq.put("ɑ ", 95);
    freq.put(" Re", 284);
    freq.put(" Ra", 532);
    freq.put(" Ro", 93);
    freq.put(" Ri", 170);
    freq.put("tat", 216);
    freq.put("tau", 2693);
    freq.put("taw", 281);
    freq.put("tap", 1461);
    freq.put("tar", 1677);
    freq.put("tas", 767);
    freq.put("tay", 99);
    freq.put("tad", 518);
    freq.put("tae", 36);
    freq.put("tag", 275);
    freq.put("taa", 274);
    freq.put("tab", 181);
    freq.put("tac", 31);
    freq.put("tal", 361);
    freq.put("tam", 800);
    freq.put("tan", 3609);
    freq.put("tao", 35);
    freq.put("tah", 1229);
    freq.put("tai", 491);
    freq.put("taj", 32);
    freq.put("tak", 1539);
    freq.put("sis", 397);
    freq.put("sir", 184);
    freq.put("Mir", 25);
    freq.put("siu", 41);
    freq.put("sit", 331);
    freq.put("sic", 45);
    freq.put("sib", 223);
    freq.put("sia", 2657);
    freq.put("dwa", 77);
    freq.put("sig", 55);
    freq.put("kyu", 97);
    freq.put("sie", 51);
    freq.put("sid", 135);
    freq.put("sik", 686);
    freq.put("sii", 260);
    freq.put("dwi", 30);
    freq.put("sio", 94);
    freq.put("sin", 1519);
    freq.put("sim", 189);
    freq.put("sil", 311);
    freq.put("ta ", 5042);
    freq.put("Д˚", 24);
    freq.put("si ", 2927);
    freq.put("kbi", 243);
    freq.put("kbo", 30);
    freq.put("kba", 124);
    freq.put("kbe", 124);
    freq.put("kbr", 46);
    freq.put("̮ ", 91);
    freq.put("byk", 86);
    freq.put("ea ", 250);
    freq.put("bye", 53);
    freq.put("bya", 39);
    freq.put(" ∫", 43);
    freq.put("Cap", 66);
    freq.put("ɐ", 108);
    freq.put("Can", 45);
    freq.put("Ibu", 40);
    freq.put("Pre", 68);
    freq.put("Pra", 45);
    freq.put("nfa", 27);
    freq.put("nfo", 225);
    freq.put("Pro", 61);
    freq.put("Pri", 61);
    freq.put("nfi", 27);
    freq.put("by ", 139);
    freq.put("oun", 110);
    freq.put("oul", 36);
    freq.put("► ", 30);
    freq.put("ous", 89);
    freq.put("our", 85);
    freq.put("oup", 28);
    freq.put("̩̩̩", 996);
    freq.put("out", 67);
    freq.put("̮¬", 39);
    freq.put("ou ", 201);
    freq.put("Ɨɑ ", 70);
    freq.put("g", 103926);
    freq.put("̯ ", 196);
    freq.put("lta", 105);
    freq.put("lti", 35);
    freq.put("Fot", 33);
    freq.put("K ", 490);
    freq.put("̩⌣", 67);
    freq.put(" ⌣", 1048);
    freq.put("Ka", 2449);
    freq.put("Kg", 27);
    freq.put("dpe", 25);
    freq.put("Ke", 1543);
    freq.put("Ki", 309);
    freq.put("Kh", 44);
    freq.put("Ko", 546);
    freq.put("Kn", 203);
    freq.put("Km", 160);
    freq.put("Kl", 226);
    freq.put("Kr", 80);
    freq.put("Kp", 56);
    freq.put("Kw", 24);
    freq.put("Ku", 309);
    freq.put("Ky", 91);
    freq.put("ƗɑƗ", 178);
    freq.put("yba", 27);
    freq.put("wh ", 65);
    freq.put("hx", 58);
    freq.put("seo", 179);
    freq.put("oga", 607);
    freq.put("hr", 780);
    freq.put("hp", 228);
    freq.put("wha", 72);
    freq.put("╥ ", 95);
    freq.put("hw", 102);
    freq.put("Pos", 24);
    freq.put("Pon", 28);
    freq.put("Pol", 48);
    freq.put("Pok", 29);
    freq.put("hn", 646);
    freq.put(" ╥﹏", 62);
    freq.put("Cha", 37);
    freq.put("NI ", 38);
    freq.put("ha", 29520);
    freq.put(" w ", 144);
    freq.put("eat", 123);
    freq.put("q ", 560);
    freq.put("Jaw", 34);
    freq.put("⌣˘", 277);
    freq.put("ɔ", 27);
    freq.put(" we", 645);
    freq.put("qu", 117);
    freq.put("qt", 73);
    freq.put("qw", 27);
    freq.put(" wa", 2162);
    freq.put(" wo", 410);
    freq.put(" wk", 1772);
    freq.put(" wh", 95);
    freq.put(" wi", 468);
    freq.put("qa", 136);
    freq.put(" ww", 46);
    freq.put("Jam", 190);
    freq.put("qi", 44);
    freq.put("qm", 25);
    freq.put("qo", 33);
    freq.put("Jak", 154);
    freq.put("ebe", 938);
    freq.put("eba", 2602);
    freq.put("ebl", 44);
    freq.put("ebo", 332);
    freq.put("ebi", 882);
    freq.put("jo ", 166);
    freq.put("ebu", 490);
    freq.put("ebr", 47);
    freq.put("Ɨƚ", 47);
    freq.put("dlh", 29);
    freq.put("dlm", 92);
    freq.put("dll", 42);
    freq.put("dlu", 184);
    freq.put("jor", 39);
    freq.put("jos", 26);
    freq.put("eb ", 209);
    freq.put("lem", 906);
    freq.put("jod", 70);
    freq.put("jog", 153);
    freq.put(" اَ", 24);
    freq.put("jok", 79);
    freq.put("jol", 30);
    freq.put("jom", 112);
    freq.put("jon", 85);
    freq.put("joo", 43);
    freq.put("dl ", 85);
    freq.put("Tet", 75);
    freq.put("rpu", 72);
    freq.put(" ╥", 94);
    freq.put(" ╯", 39);
    freq.put(" ╭", 27);
    freq.put("rpa", 128);
    freq.put(" ╰", 29);
    freq.put("rpe", 73);
    freq.put("rpd", 76);
    freq.put("rpi", 53);
    freq.put("hm ", 68);
    freq.put("rpo", 53);
    freq.put("bbm", 170);
    freq.put("Jua", 26);
    freq.put("Juj", 27);
    freq.put("Jun", 29);
    freq.put("bba", 25);
    freq.put("Jum", 31);
    freq.put("Jus", 30);
    freq.put("bby", 31);
    freq.put("з˘", 25);
    freq.put("hmu", 55);
    freq.put("rp ", 205);
    freq.put("hmi", 44);
    freq.put("ª ", 47);
    freq.put("hma", 82);
    freq.put(" ┎", 24);
    freq.put(" ┌", 216);
    freq.put("bb ", 175);
    freq.put(" ┒", 30);
    freq.put(" ┐", 170);
    freq.put(" ◦", 87);
    freq.put("Gw ", 237);
    freq.put("AR ", 50);
    freq.put("avo", 46);
    freq.put("avi", 69);
    freq.put("ave", 93);
    freq.put("ava", 174);
    freq.put("fka", 93);
    freq.put(" T ", 386);
    freq.put("ªª", 117);
    freq.put(" ►", 43);
    freq.put(" ▿", 209);
    freq.put(" ▽", 57);
    freq.put(" Tw", 104);
    freq.put(" Tu", 488);
    freq.put(" Tr", 204);
    freq.put(" Tp", 223);
    freq.put(" To", 232);
    freq.put(" Ti", 512);
    freq.put(" Th", 212);
    freq.put(" Tg", 33);
    freq.put(" Te", 1020);
    freq.put(" Td", 70);
    freq.put(" Ta", 1193);
    freq.put("┒", 36);
    freq.put("tch", 45);
    freq.put("nov", 74);
    freq.put("sku", 102);
    freq.put(" Ơ͡", 46);
    freq.put("skr", 409);
    freq.put("sky", 26);
    freq.put("ske", 64);
    freq.put("skg", 35);
    freq.put("Fai", 28);
    freq.put("ska", 303);
    freq.put("skl", 37);
    freq.put("sko", 145);
    freq.put("ski", 148);
    freq.put("ِ", 38);
    freq.put("T", 5852);
    freq.put(" Ua", 27);
    freq.put("sk ", 326);
    freq.put("Sud", 104);
    freq.put("Sub", 59);
    freq.put("Sua", 58);
    freq.put("Sun", 46);
    freq.put("Sum", 101);
    freq.put("Suk", 105);
    freq.put("Sus", 47);
    freq.put("Sur", 65);
    freq.put("Sup", 64);
    freq.put("Cc ", 46);
    freq.put("nd ", 485);
    freq.put("kd ", 27);
    freq.put("ndi", 1706);
    freq.put("ndh", 27);
    freq.put("ndk", 34);
    freq.put("ndo", 956);
    freq.put("nda", 2390);
    freq.put("nde", 471);
    freq.put("ndy", 80);
    freq.put("nds", 36);
    freq.put("ndr", 263);
    freq.put("ndu", 864);
    freq.put("owo", 330);
    freq.put("own", 118);
    freq.put("owh", 25);
    freq.put("owe", 165);
    freq.put("owb", 34);
    freq.put("oww", 26);
    freq.put("Ami", 243);
    freq.put("van", 91);
    freq.put("val", 33);
    freq.put("Ama", 46);
    freq.put("Amb", 28);
    freq.put("Amp", 74);
    freq.put("vat", 90);
    freq.put("ow ", 484);
    freq.put("з´", 42);
    freq.put("Ɨɑ", 265);
    freq.put("Ɨɐ", 106);
    freq.put("Tel", 51);
    freq.put("Tem", 121);
    freq.put("Ten", 112);
    freq.put("va ", 126);
    freq.put("Teg", 32);
    freq.put("Ter", 460);
    freq.put("lvi", 26);
    freq.put("Teu", 36);
    freq.put("Ơ͡", 100);
    freq.put("myu", 27);
    freq.put("eu", 1456);
    freq.put("ª˘", 30);
    freq.put("н", 118);
    freq.put("Lha", 30);
    freq.put("з ", 25);
    freq.put("Lho", 32);
    freq.put("my ", 167);
  }
  
}

