package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class IT {
  private static final String name = "it";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public IT() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 2296183;
    n_words[1] = 2790639;
    n_words[2] = 2239250;

    freq.put("rà ", 1032);
    freq.put("ayn", 60);
    freq.put("sn ", 80);
    freq.put("alo", 374);
    freq.put("Tut", 197);
    freq.put("nun", 231);
    freq.put("cag", 140);
    freq.put("all", 4696);
    freq.put("MA ", 247);
    freq.put("alm", 654);
    freq.put(" G ", 71);
    freq.put("Van", 29);
    freq.put("alk", 38);
    freq.put("sè ", 28);
    freq.put("Var", 30);
    freq.put("Val", 159);
    freq.put("aug", 148);
    freq.put("ali", 3107);
    freq.put("aum", 74);
    freq.put("Sce", 24);
    freq.put("up ", 72);
    freq.put("Cro", 98);
    freq.put("Vab", 54);
    freq.put("aus", 174);
    freq.put("lt ", 51);
    freq.put("aut", 363);
    freq.put("G ", 262);
    freq.put("tai", 226);
    freq.put("Joe", 52);
    freq.put(" Gu", 250);
    freq.put(" Gr", 661);
    freq.put("Tun", 28);
    freq.put("alb", 217);
    freq.put("alc", 1410);
    freq.put("ble", 337);
    freq.put("èè", 106);
    freq.put(" Ge", 377);
    freq.put("unt", 882);
    freq.put("Eh ", 48);
    freq.put(" Ga", 380);
    freq.put("ava", 978);
    freq.put(" Go", 375);
    freq.put(" Gl", 171);
    freq.put("ala", 659);
    freq.put("Tub", 44);
    freq.put(" Gh", 77);
    freq.put(" Gi", 700);
    freq.put("upo", 70);
    freq.put("Gu", 251);
    freq.put("Gr", 669);
    freq.put("upi", 129);
    freq.put("Cl", 195);
    freq.put("upa", 198);
    freq.put("Ok ", 97);
    freq.put("Ge", 385);
    freq.put("Ga", 393);
    freq.put("ait", 27);
    freq.put("Go", 377);
    freq.put("drà", 46);
    freq.put("Gl", 174);
    freq.put("Gi", 707);
    freq.put("Gh", 77);
    freq.put(" ka", 32);
    freq.put("me ", 4499);
    freq.put(" ke", 124);
    freq.put(" ki", 41);
    freq.put("NO ", 294);
    freq.put("umm", 33);
    freq.put(" km", 125);
    freq.put("scu", 643);
    freq.put("ais", 24);
    freq.put("Vas", 46);
    freq.put("orz", 235);
    freq.put("è ", 8902);
    freq.put("air", 61);
    freq.put("Tom", 49);
    freq.put("nen", 122);
    freq.put("neo", 76);
    freq.put("Pun", 31);
    freq.put("Puo", 25);
    freq.put("boc", 116);
    freq.put("nei", 244);
    freq.put("nef", 29);
    freq.put("neg", 208);
    freq.put("ned", 197);
    freq.put("nee", 51);
    freq.put("Z ", 39);
    freq.put("nec", 67);
    freq.put("Pub", 41);
    freq.put("nea", 265);
    freq.put("orv", 36);
    freq.put("abi", 653);
    freq.put("slo", 28);
    freq.put("nez", 70);
    freq.put("Uom", 24);
    freq.put("pin", 213);
    freq.put("ney", 54);
    freq.put("nev", 94);
    freq.put("new", 131);
    freq.put("net", 490);
    freq.put("scr", 903);
    freq.put("ner", 968);
    freq.put("nes", 800);
    freq.put("Pur", 44);
    freq.put("mee", 25);
    freq.put("dep", 92);
    freq.put(" k ", 31);
    freq.put("ou ", 108);
    freq.put("ws ", 317);
    freq.put("mem", 68);
    freq.put("orr", 961);
    freq.put("gne", 183);
    freq.put("là ", 70);
    freq.put("zur", 46);
    freq.put("fun", 204);
    freq.put("mes", 754);
    freq.put("sle", 32);
    freq.put("TT ", 108);
    freq.put("mez", 271);
    freq.put("gli", 5552);
    freq.put("Zo", 29);
    freq.put("Zi", 31);
    freq.put("glo", 35);
    freq.put("gla", 26);
    freq.put("k", 3977);
    freq.put("gle", 354);
    freq.put("ne ", 8719);
    freq.put("sla", 46);
    freq.put("dri", 175);
    freq.put("abè", 27);
    freq.put("fez", 37);
    freq.put("aic", 31);
    freq.put("dro", 237);
    freq.put("tw", 900);
    freq.put("dra", 265);
    freq.put("Zu", 28);
    freq.put("dre", 396);
    freq.put("cca", 972);
    freq.put("ake", 82);
    freq.put("nk ", 166);
    freq.put("ED ", 27);
    freq.put("sso", 2242);
    freq.put("uce", 115);
    freq.put("lmo", 43);
    freq.put("aul", 79);
    freq.put("bro", 260);
    freq.put("vog", 772);
    freq.put("bri", 401);
    freq.put("lma", 101);
    freq.put("bre", 975);
    freq.put("cm ", 28);
    freq.put("OR ", 26);
    freq.put("m ", 1966);
    freq.put("voc", 225);
    freq.put("LA ", 258);
    freq.put("lme", 731);
    freq.put("vol", 1822);
    freq.put("aur", 313);
    freq.put("er ", 8236);
    freq.put("nfu", 37);
    freq.put("ni ", 6212);
    freq.put("ssi", 3127);
    freq.put("nka", 24);
    freq.put("nke", 40);
    freq.put("ucc", 719);
    freq.put("ltr", 1230);
    freq.put("ngu", 239);
    freq.put("ti", 20872);
    freq.put("lci", 294);
    freq.put("Sti", 45);
    freq.put("voi", 280);
    freq.put("Stu", 64);
    freq.put("osp", 197);
    freq.put("Str", 106);
    freq.put("V", 2752);
    freq.put("iv", 4692);
    freq.put("rry", 190);
    freq.put("me", 14523);
    freq.put("eru", 45);
    freq.put("erv", 758);
    freq.put("ma", 16112);
    freq.put("ltu", 98);
    freq.put("err", 800);
    freq.put("mb", 2186);
    freq.put("mm", 2355);
    freq.put("ml", 36);
    freq.put("mo", 9719);
    freq.put("mn", 27);
    freq.put("mi", 13378);
    freq.put("mh", 56);
    freq.put("erz", 234);
    freq.put("mu", 1399);
    freq.put("ere", 5147);
    freq.put("erf", 204);
    freq.put("erg", 344);
    freq.put("mq", 304);
    freq.put("mp", 4764);
    freq.put("ms", 196);
    freq.put("erc", 2440);
    freq.put("erl", 679);
    freq.put("erm", 877);
    freq.put("ern", 736);
    freq.put("ero", 2405);
    freq.put("my", 138);
    freq.put("eri", 3397);
    freq.put("erk", 32);
    freq.put("Abb", 69);
    freq.put("Le", 880);
    freq.put("Nat", 81);
    freq.put("Lib", 141);
    freq.put("La", 1724);
    freq.put("Lil", 37);
    freq.put("Lo", 552);
    freq.put("Lin", 70);
    freq.put("Lio", 26);
    freq.put("la ", 14924);
    freq.put("uat", 142);
    freq.put("So ", 25);
    freq.put("Li", 607);
    freq.put("Lit", 23);
    freq.put("Naz", 36);
    freq.put("Abr", 29);
    freq.put("Lu", 316);
    freq.put("ual", 1667);
    freq.put("lov", 88);
    freq.put("arà", 402);
    freq.put("uad", 188);
    freq.put("uag", 34);
    freq.put("ena", 1102);
    freq.put("ib", 1611);
    freq.put("end", 2725);
    freq.put("hoc", 38);
    freq.put("eng", 269);
    freq.put("hon", 349);
    freq.put("hoo", 34);
    freq.put("hol", 28);
    freq.put("hom", 38);
    freq.put("Al ", 101);
    freq.put("eno", 1225);
    freq.put("how", 39);
    freq.put("hot", 97);
    freq.put("hou", 33);
    freq.put("hor", 55);
    freq.put("hos", 33);
    freq.put("hop", 54);
    freq.put("Kat", 38);
    freq.put("al ", 3350);
    freq.put("enz", 1739);
    freq.put("Va ", 36);
    freq.put("uco", 31);
    freq.put("A", 6948);
    freq.put("lam", 284);
    freq.put("lan", 1015);
    freq.put("ovv", 185);
    freq.put("nè ", 30);
    freq.put("L ", 1339);
    freq.put("ovu", 85);
    freq.put("lad", 50);
    freq.put("ON ", 269);
    freq.put("lag", 76);
    freq.put("nua", 173);
    freq.put("lab", 167);
    freq.put("sc ", 24);
    freq.put("ova", 1481);
    freq.put("lax", 74);
    freq.put("II ", 45);
    freq.put("laz", 254);
    freq.put("ove", 1650);
    freq.put("lat", 834);
    freq.put("occ", 1287);
    freq.put("lav", 710);
    freq.put("ovi", 649);
    freq.put("lap", 47);
    freq.put("re ", 18081);
    freq.put("lar", 864);
    freq.put("las", 661);
    freq.put("en ", 463);
    freq.put("All", 279);
    freq.put("Alm", 40);
    freq.put("ho ", 2640);
    freq.put("eró", 26);
    freq.put("Alf", 24);
    freq.put("Ale", 111);
    freq.put("Alb", 63);
    freq.put("Alc", 36);
    freq.put("mpu", 81);
    freq.put("erà", 362);
    freq.put("mpr", 1369);
    freq.put("Alt", 77);
    freq.put(" V ", 40);
    freq.put("alv", 271);
    freq.put("zen", 24);
    freq.put(" Hu", 36);
    freq.put("zer", 131);
    freq.put("zes", 28);
    freq.put(" Hi", 54);
    freq.put("oni", 2619);
    freq.put(" Ho", 744);
    freq.put("zet", 74);
    freq.put(" Ha", 462);
    freq.put(" He", 100);
    freq.put("ono", 5657);
    freq.put("ima", 2102);
    freq.put("fis", 203);
    freq.put("imb", 178);
    freq.put("ime", 1135);
    freq.put("cli", 184);
    freq.put("rò", 1219);
    freq.put("ró", 43);
    freq.put("imi", 748);
    freq.put("cle", 114);
    freq.put("imm", 434);
    freq.put("cla", 243);
    freq.put("imo", 1637);
    freq.put("uog", 56);
    freq.put("ssa", 1662);
    freq.put("imp", 911);
    freq.put("fia", 203);
    freq.put("imu", 23);
    freq.put("fig", 541);
    freq.put("fid", 245);
    freq.put("fie", 106);
    freq.put("clu", 143);
    freq.put("uoi", 719);
    freq.put("fin", 1493);
    freq.put("fio", 77);
    freq.put("fil", 601);
    freq.put("uol", 684);
    freq.put(" Va", 494);
    freq.put("ze ", 512);
    freq.put("xa", 25);
    freq.put(" Ve", 553);
    freq.put("dem", 157);
    freq.put(" Vi", 771);
    freq.put("SA ", 137);
    freq.put("upl", 28);
    freq.put(" Vo", 366);
    freq.put("Mai", 49);
    freq.put(" Vu", 38);
    freq.put("one", 5098);
    freq.put("Dov", 84);
    freq.put("im ", 85);
    freq.put("l", 120428);
    freq.put("fi ", 161);
    freq.put("cy ", 29);
    freq.put("abl", 63);
    freq.put("lbe", 72);
    freq.put("Lan", 35);
    freq.put("drò", 44);
    freq.put("UE ", 39);
    freq.put("zay", 27);
    freq.put("Wor", 33);
    freq.put("bra", 762);
    freq.put("mbo", 93);
    freq.put("nt ", 467);
    freq.put("Pho", 277);
    freq.put("zat", 457);
    freq.put("Pd ", 26);
    freq.put("gom", 73);
    freq.put("gol", 288);
    freq.put("goo", 52);
    freq.put("gon", 312);
    freq.put(" zi", 80);
    freq.put("rr", 3414);
    freq.put("rs", 3223);
    freq.put(" ze", 48);
    freq.put("god", 46);
    freq.put("gog", 114);
    freq.put("Svi", 28);
    freq.put(" za", 89);
    freq.put("ry", 367);
    freq.put("goc", 23);
    freq.put("rd", 3166);
    freq.put("re", 31381);
    freq.put("rf", 249);
    freq.put("rg", 1004);
    freq.put("nic", 943);
    freq.put("ra", 21540);
    freq.put("rb", 335);
    freq.put("goz", 60);
    freq.put(" zu", 42);
    freq.put("rm", 2835);
    freq.put("rn", 3506);
    freq.put("gov", 153);
    freq.put("ri", 20834);
    freq.put("gos", 216);
    freq.put("gor", 106);
    freq.put("nia", 482);
    freq.put("ahu", 38);
    freq.put("ntr", 1697);
    freq.put("ntu", 181);
    freq.put("nti", 3906);
    freq.put("Pdl", 32);
    freq.put("mbi", 762);
    freq.put("W", 794);
    freq.put("nta", 2690);
    freq.put("nie", 603);
    freq.put("nte", 6390);
    freq.put("deb", 112);
    freq.put("acr", 80);
    freq.put("vvo", 36);
    freq.put("Via", 110);
    freq.put("atc", 49);
    freq.put("Vid", 122);
    freq.put("Vie", 40);
    freq.put("iss", 1349);
    freq.put("ato", 5915);
    freq.put("atl", 26);
    freq.put("isp", 858);
    freq.put("Vin", 76);
    freq.put("ì", 1846);
    freq.put("isu", 175);
    freq.put("ist", 3034);
    freq.put(" ùù", 103);
    freq.put("isi", 689);
    freq.put("ish", 55);
    freq.put("r ", 9671);
    freq.put("cmq", 125);
    freq.put("ism", 211);
    freq.put("isl", 23);
    freq.put("isc", 1382);
    freq.put("caf", 91);
    freq.put("isa", 357);
    freq.put("isf", 65);
    freq.put("ise", 190);
    freq.put(" l ", 3327);
    freq.put("Due", 42);
    freq.put("pir", 409);
    freq.put("nir", 256);
    freq.put("xD", 781);
    freq.put("osa", 1806);
    freq.put("rch", 1670);
    freq.put("nip", 26);
    freq.put("aol", 92);
    freq.put("tem", 1333);
    freq.put("Man", 226);
    freq.put("tor", 2575);
    freq.put("Cen", 100);
    freq.put("top", 143);
    freq.put("equ", 104);
    freq.put("tot", 77);
    freq.put("tou", 81);
    freq.put("ae ", 35);
    freq.put("nz ", 34);
    freq.put("Ces", 43);
    freq.put("Cer", 171);
    freq.put("tol", 407);
    freq.put("Se ", 423);
    freq.put("tob", 268);
    freq.put("toc", 170);
    freq.put("tof", 25);
    freq.put("tog", 215);
    freq.put("tod", 69);
    freq.put(" le", 4423);
    freq.put("B", 4271);
    freq.put(" la", 8633);
    freq.put("Roc", 39);
    freq.put(" lo", 3095);
    freq.put(" li", 1984);
    freq.put("tee", 44);
    freq.put("arp", 94);
    freq.put("Tre", 147);
    freq.put(" lu", 829);
    freq.put("Ton", 24);
    freq.put("ain", 138);
    freq.put("Set", 119);
    freq.put("Ses", 25);
    freq.put("Ser", 257);
    freq.put("Ce ", 25);
    freq.put("ca ", 3524);
    freq.put("í", 32);
    freq.put("to ", 21798);
    freq.put("wer", 98);
    freq.put("Seg", 81);
    freq.put("nza", 1734);
    freq.put("Sec", 96);
    freq.put("nze", 324);
    freq.put("iò ", 106);
    freq.put("Sen", 119);
    freq.put("nzi", 836);
    freq.put("PD ", 36);
    freq.put("nzo", 504);
    freq.put("Sei", 108);
    freq.put("gg ", 23);
    freq.put("raf", 368);
    freq.put("rag", 991);
    freq.put("rad", 545);
    freq.put("epu", 132);
    freq.put("rab", 163);
    freq.put("rac", 523);
    freq.put("raa", 28);
    freq.put("ran", 2778);
    freq.put("rao", 30);
    freq.put("ral", 453);
    freq.put("ram", 744);
    freq.put("ty ", 153);
    freq.put("rah", 36);
    freq.put("rai", 370);
    freq.put("rav", 626);
    freq.put("Q ", 52);
    freq.put("rat", 2368);
    freq.put("rau", 26);
    freq.put("rar", 901);
    freq.put("ras", 508);
    freq.put("rap", 252);
    freq.put("dur", 228);
    freq.put("raz", 1336);
    freq.put("ase", 646);
    freq.put("car", 1603);
    freq.put("Ass", 106);
    freq.put("tò ", 26);
    freq.put("Asp", 43);
    freq.put("der", 2144);
    freq.put("do ", 6241);
    freq.put("ack", 220);
    freq.put("Asc", 51);
    freq.put("piz", 97);
    freq.put("Sor", 32);
    freq.put("tev", 316);
    freq.put("ype", 37);
    freq.put("uvi", 60);
    freq.put("sì ", 1033);
    freq.put("on ", 12630);
    freq.put("tyl", 36);
    freq.put("AH ", 324);
    freq.put("Qu", 1074);
    freq.put("ra ", 8214);
    freq.put(" là", 45);
    freq.put(" lì", 119);
    freq.put("nel", 1831);
    freq.put("bis", 281);
    freq.put(" fi", 2759);
    freq.put("sud", 58);
    freq.put("Rus", 31);
    freq.put(" È ", 209);
    freq.put("PO ", 39);
    freq.put("abe", 65);
    freq.put("zel", 30);
    freq.put("don", 693);
    freq.put("dol", 423);
    freq.put("dom", 904);
    freq.put("dob", 77);
    freq.put("doc", 134);
    freq.put("m", 67448);
    freq.put("dog", 25);
    freq.put("Ita", 796);
    freq.put("lpo", 65);
    freq.put("ogl", 1438);
    freq.put("lpi", 75);
    freq.put("Spa", 111);
    freq.put("dor", 493);
    freq.put("dos", 145);
    freq.put("dop", 686);
    freq.put("dov", 907);
    freq.put("dow", 104);
    freq.put("dot", 204);
    freq.put("beh", 184);
    freq.put(" We", 126);
    freq.put(" Wa", 96);
    freq.put("api", 981);
    freq.put(" Wo", 60);
    freq.put("né ", 34);
    freq.put("ude", 219);
    freq.put("d ", 3468);
    freq.put(" Wi", 209);
    freq.put("oge", 126);
    freq.put("TV ", 79);
    freq.put("rta", 1156);
    freq.put("oci", 523);
    freq.put("och", 347);
    freq.put("Bil", 35);
    freq.put("em ", 99);
    freq.put("oco", 473);
    freq.put("oca", 648);
    freq.put("Big", 36);
    freq.put("irò", 85);
    freq.put("Bie", 54);
    freq.put("oce", 328);
    freq.put("Bia", 37);
    freq.put("hri", 31);
    freq.put("ba ", 246);
    freq.put("irà", 86);
    freq.put("ocr", 63);
    freq.put("ocu", 88);
    freq.put("Bis", 40);
    freq.put("abu", 37);
    freq.put("dn", 41);
    freq.put("do", 11245);
    freq.put("dl", 99);
    freq.put("dm", 52);
    freq.put("dj", 39);
    freq.put("dk", 28);
    freq.put("dh", 46);
    freq.put("di", 24498);
    freq.put("df", 64);
    freq.put("dg", 64);
    freq.put("dd", 839);
    freq.put("de", 16709);
    freq.put("db", 32);
    freq.put("dc", 46);
    freq.put("da", 10027);
    freq.put("bi ", 185);
    freq.put("dy", 95);
    freq.put("dv", 42);
    freq.put("dw", 38);
    freq.put("app", 1505);
    freq.put("du", 1472);
    freq.put("dr", 1181);
    freq.put("ds", 150);
    freq.put("eme", 544);
    freq.put("bat", 509);
    freq.put("neu", 44);
    freq.put("ema", 573);
    freq.put("CK ", 30);
    freq.put("emb", 845);
    freq.put("emm", 286);
    freq.put("oc ", 34);
    freq.put("emo", 623);
    freq.put("emi", 680);
    freq.put("Ris", 82);
    freq.put("Rip", 47);
    freq.put("emu", 26);
    freq.put("bag", 250);
    freq.put("bad", 53);
    freq.put("Rim", 36);
    freq.put("ò ", 2011);
    freq.put("emp", 1806);
    freq.put("Rif", 36);
    freq.put("bal", 229);
    freq.put("Rie", 23);
    freq.put("Ric", 171);
    freq.put("bah", 35);
    freq.put("asf", 86);
    freq.put("ua ", 979);
    freq.put("om ", 328);
    freq.put("w ", 641);
    freq.put("Pet", 25);
    freq.put("PS ", 42);
    freq.put("nus", 34);
    freq.put("Per", 718);
    freq.put("Pes", 58);
    freq.put("Pel", 35);
    freq.put("nuo", 1007);
    freq.put("Pen", 114);
    freq.put("num", 178);
    freq.put("nui", 47);
    freq.put(" I ", 682);
    freq.put("nud", 47);
    freq.put("nue", 44);
    freq.put("nuc", 37);
    freq.put("Pec", 25);
    freq.put("mut", 57);
    freq.put("urd", 79);
    freq.put("il ", 7702);
    freq.put("mur", 52);
    freq.put("mm ", 97);
    freq.put("irr", 103);
    freq.put("irs", 56);
    freq.put("irt", 103);
    freq.put("iru", 29);
    freq.put("un ", 5950);
    freq.put("iri", 332);
    freq.put("irl", 160);
    freq.put("irm", 156);
    freq.put("iro", 297);
    freq.put("Tri", 79);
    freq.put("ira", 505);
    freq.put("muo", 164);
    freq.put("irc", 153);
    freq.put("ire", 2352);
    freq.put("irg", 32);
    freq.put("omb", 244);
    freq.put("C", 8002);
    freq.put("men", 5185);
    freq.put("wc", 62);
    freq.put("wa", 272);
    freq.put("XD ", 207);
    freq.put(" Ip", 25);
    freq.put("wn", 89);
    freq.put(" Ir", 58);
    freq.put(" Is", 109);
    freq.put(" It", 789);
    freq.put("Sam", 83);
    freq.put("dà", 39);
    freq.put("wh", 36);
    freq.put("ww", 324);
    freq.put("wu", 26);
    freq.put("omp", 1272);
    freq.put(" Il", 1530);
    freq.put(" Im", 110);
    freq.put(" In", 1140);
    freq.put(" Io", 510);
    freq.put("acq", 191);
    freq.put(" Ib", 28);
    freq.put(" Id", 39);
    freq.put(" Ie", 49);
    freq.put("nu ", 43);
    freq.put("Gaz", 31);
    freq.put("DM ", 29);
    freq.put("gge", 613);
    freq.put("ild", 31);
    freq.put("ile", 1427);
    freq.put("cou", 100);
    freq.put("ell", 8759);
    freq.put("GB ", 23);
    freq.put("ila", 799);
    freq.put("ilo", 294);
    freq.put("ill", 720);
    freq.put("ilm", 400);
    freq.put("tt ", 188);
    freq.put("ili", 1165);
    freq.put("ilv", 98);
    freq.put("una", 3627);
    freq.put("ilt", 65);
    freq.put("ilu", 83);
    freq.put("coe", 24);
    freq.put("cod", 110);
    freq.put("cog", 180);
    freq.put("cof", 27);
    freq.put("ir ", 94);
    freq.put("gga", 38);
    freq.put("com", 4191);
    freq.put("col", 2320);
    freq.put("coo", 61);
    freq.put("ily", 28);
    freq.put("iù", 1839);
    freq.put(" me", 4797);
    freq.put(" ma", 8573);
    freq.put("can", 1620);
    freq.put(" mm", 94);
    freq.put("iò", 111);
    freq.put(" mi", 8118);
    freq.put("Gar", 47);
    freq.put(" mu", 566);
    freq.put("Pas", 85);
    freq.put(" mq", 137);
    freq.put(" ms", 46);
    freq.put("ià", 646);
    freq.put(" my", 63);
    freq.put("san", 718);
    freq.put("fra", 502);
    freq.put("eag", 42);
    freq.put("cam", 1035);
    freq.put("fre", 333);
    freq.put("Ros", 118);
    freq.put("ggi", 3144);
    freq.put("fri", 136);
    freq.put("C ", 517);
    freq.put("fro", 198);
    freq.put("Nas", 27);
    freq.put("Lau", 51);
    freq.put("gn ", 44);
    freq.put("fru", 68);
    freq.put("ann", 3157);
    freq.put("rge", 194);
    freq.put("cal", 1023);
    freq.put(" m ", 168);
    freq.put("pri", 2096);
    freq.put("Nap", 209);
    freq.put("rgh", 53);
    freq.put("Cre", 120);
    freq.put("Cri", 84);
    freq.put("elp", 39);
    freq.put("Ci", 778);
    freq.put("Ch", 983);
    freq.put("Co", 2129);
    freq.put("Cm", 43);
    freq.put("gnu", 42);
    freq.put("aiu", 201);
    freq.put("elv", 25);
    freq.put("Ca", 1518);
    freq.put(" yo", 133);
    freq.put("RI ", 91);
    freq.put("Ce", 381);
    freq.put("n", 156671);
    freq.put("ape", 775);
    freq.put("ail", 259);
    freq.put("ET ", 42);
    freq.put("gna", 1057);
    freq.put("sli", 28);
    freq.put("Ze", 44);
    freq.put("aie", 28);
    freq.put("Cr", 335);
    freq.put("gni", 745);
    freq.put("aia", 89);
    freq.put("gno", 832);
    freq.put("Cu", 126);
    freq.put("anq", 111);
    freq.put("ix", 108);
    freq.put("iz", 2316);
    freq.put("rtu", 279);
    freq.put("Dim", 36);
    freq.put("iq", 54);
    freq.put("ip", 1821);
    freq.put("is", 9649);
    freq.put("ir", 4630);
    freq.put("iu", 2052);
    freq.put("it", 11307);
    freq.put("Za", 82);
    freq.put("ii", 634);
    freq.put("ih", 73);
    freq.put("ik", 267);
    freq.put("ij", 46);
    freq.put("im", 7289);
    freq.put("il", 12924);
    freq.put("io", 21780);
    freq.put("in", 23085);
    freq.put("ia", 21749);
    freq.put("opp", 1133);
    freq.put("ic", 12188);
    freq.put("ki ", 62);
    freq.put("ie", 8150);
    freq.put("id", 3608);
    freq.put("ig", 3356);
    freq.put("if", 1538);
    freq.put("V ", 174);
    freq.put("Tit", 23);
    freq.put("Tro", 134);
    freq.put("art", 2134);
    freq.put("iP", 341);
    freq.put("iS", 31);
    freq.put("bii", 65);
    freq.put("iT", 29);
    freq.put("any", 25);
    freq.put("anz", 1252);
    freq.put("iO", 61);
    freq.put("Die", 29);
    freq.put("HP ", 23);
    freq.put("ep ", 33);
    freq.put("th ", 69);
    freq.put("bie", 167);
    freq.put("nin", 191);
    freq.put("nio", 285);
    freq.put("nil", 62);
    freq.put("nim", 243);
    freq.put("nib", 111);
    freq.put("Oc", 58);
    freq.put("kip", 33);
    freq.put("nif", 162);
    freq.put("nig", 71);
    freq.put("Dia", 45);
    freq.put("niz", 601);
    freq.put("tz ", 23);
    freq.put("kin", 84);
    freq.put("vvi", 332);
    freq.put("Una", 221);
    freq.put("Y", 305);
    freq.put("i ", 78380);
    freq.put("kia", 74);
    freq.put("bia", 1037);
    freq.put("niv", 140);
    freq.put("RE ", 299);
    freq.put("nit", 692);
    freq.put("mil", 589);
    freq.put("Va", 499);
    freq.put("LO ", 171);
    freq.put("Ve", 559);
    freq.put("sme", 176);
    freq.put("Vi", 783);
    freq.put(" L ", 756);
    freq.put("epr", 101);
    freq.put("epp", 88);
    freq.put("Vo", 375);
    freq.put("epo", 60);
    freq.put("epl", 34);
    freq.put("Vu", 39);
    freq.put("thi", 34);
    freq.put("epi", 117);
    freq.put("the", 155);
    freq.put("epe", 39);
    freq.put("tha", 32);
    freq.put("epa", 209);
    freq.put("Sve", 31);
    freq.put("zol", 56);
    freq.put("rn ", 38);
    freq.put("op ", 183);
    freq.put("tin", 1487);
    freq.put("Tip", 37);
    freq.put("yer", 34);
    freq.put("bit", 407);
    freq.put("vig", 200);
    freq.put("hah", 2868);
    freq.put("hai", 826);
    freq.put("eli", 497);
    freq.put("hal", 52);
    freq.put("ham", 89);
    freq.put("han", 717);
    freq.put("elm", 47);
    freq.put("haa", 73);
    freq.put("ela", 483);
    freq.put("Gas", 44);
    freq.put("hae", 29);
    freq.put("ele", 858);
    freq.put("Gam", 24);
    freq.put("Gal", 128);
    freq.put("trò", 29);
    freq.put("Gag", 46);
    freq.put("els", 37);
    freq.put("har", 105);
    freq.put("has", 38);
    freq.put("hat", 107);
    freq.put("bru", 243);
    freq.put("elt", 145);
    freq.put("elu", 78);
    freq.put("uso", 183);
    freq.put("UI ", 28);
    freq.put("rni", 503);
    freq.put("lcu", 455);
    freq.put("rno", 1416);
    freq.put("D", 7053);
    freq.put("opr", 875);
    freq.put("Tra", 273);
    freq.put("ye ", 24);
    freq.put("rna", 1227);
    freq.put("OH ", 23);
    freq.put("rne", 296);
    freq.put("ope", 497);
    freq.put("lce", 111);
    freq.put("opa", 182);
    freq.put("lca", 40);
    freq.put("lco", 436);
    freq.put("opo", 1108);
    freq.put("opi", 147);
    freq.put("lch", 307);
    freq.put("IO ", 275);
    freq.put("Arr", 71);
    freq.put("med", 260);
    freq.put("Art", 81);
    freq.put("vis", 1165);
    freq.put("ha ", 2291);
    freq.put("el ", 4166);
    freq.put("mit", 283);
    freq.put("Ara", 26);
    freq.put("Arc", 52);
    freq.put("Are", 31);
    freq.put("Arg", 23);
    freq.put("Ari", 33);
    freq.put("aud", 82);
    freq.put("ola", 1742);
    freq.put("www", 157);
    freq.put("olc", 150);
    freq.put("old", 197);
    freq.put("ole", 1366);
    freq.put("olf", 34);
    freq.put("olg", 90);
    freq.put(" Ju", 219);
    freq.put("oli", 1546);
    freq.put(" X ", 106);
    freq.put("oll", 1087);
    freq.put("olm", 28);
    freq.put("olo", 3046);
    freq.put("olp", 237);
    freq.put(" Jo", 271);
    freq.put("ufa", 28);
    freq.put(" Ji", 29);
    freq.put("olu", 305);
    freq.put("olv", 77);
    freq.put(" Je", 78);
    freq.put("an ", 1013);
    freq.put(" Ja", 131);
    freq.put("ick", 180);
    freq.put("Lea", 41);
    freq.put("ici", 2018);
    freq.put("ich", 774);
    freq.put("ico", 2717);
    freq.put("ump", 23);
    freq.put("for", 1246);
    freq.put("icl", 117);
    freq.put("icc", 629);
    freq.put("Lei", 73);
    freq.put("ica", 3684);
    freq.put("tio", 351);
    freq.put("ice", 1320);
    freq.put("Hu", 39);
    freq.put("ume", 423);
    freq.put("aww", 27);
    freq.put("Hi", 55);
    freq.put("Let", 72);
    freq.put("Ho", 746);
    freq.put("umb", 72);
    freq.put("ics", 44);
    freq.put("icr", 78);
    freq.put("fon", 568);
    freq.put("Ha", 474);
    freq.put("umi", 136);
    freq.put("icu", 311);
    freq.put("ict", 50);
    freq.put("uò", 317);
    freq.put("plu", 23);
    freq.put("ldo", 178);
    freq.put("VD ", 37);
    freq.put("Tur", 42);
    freq.put("ple", 511);
    freq.put("ww ", 139);
    freq.put("pla", 183);
    freq.put("plo", 106);
    freq.put("rt", 6114);
    freq.put(" J ", 28);
    freq.put("pli", 346);
    freq.put("Le ", 365);
    freq.put("obo", 34);
    freq.put("obl", 261);
    freq.put("obi", 225);
    freq.put("ic ", 243);
    freq.put("obb", 172);
    freq.put("o", 227911);
    freq.put("oba", 246);
    freq.put("zuc", 35);
    freq.put("fo ", 267);
    freq.put("um ", 337);
    freq.put("cn ", 26);
    freq.put("H ", 473);
    freq.put("obu", 30);
    freq.put("obr", 247);
    freq.put("obs", 92);
    freq.put("mbl", 68);
    freq.put("Fed", 51);
    freq.put("Fee", 23);
    freq.put("ars", 468);
    freq.put("Cur", 29);
    freq.put("sog", 480);
    freq.put("sof", 173);
    freq.put("mbe", 119);
    freq.put("Fel", 25);
    freq.put("som", 129);
    freq.put("sol", 2038);
    freq.put("son", 4262);
    freq.put("sop", 260);
    freq.put("sos", 160);
    freq.put("sor", 649);
    freq.put("Fer", 144);
    freq.put("Fes", 97);
    freq.put("ppu", 228);
    freq.put("rv", 889);
    freq.put("mbu", 31);
    freq.put("Cul", 26);
    freq.put("nnò", 36);
    freq.put("mbr", 878);
    freq.put("nè", 33);
    freq.put("né", 38);
    freq.put("giu", 708);
    freq.put("git", 132);
    freq.put("gis", 124);
    freq.put("gir", 326);
    freq.put("az ", 23);
    freq.put("Ue ", 27);
    freq.put("gig", 30);
    freq.put("gie", 54);
    freq.put("gic", 123);
    freq.put("gia", 1184);
    freq.put("gio", 3747);
    freq.put("gin", 673);
    freq.put("nò", 45);
    freq.put("gil", 52);
    freq.put("war", 113);
    freq.put(" né", 26);
    freq.put("so ", 4734);
    freq.put("ah ", 987);
    freq.put("pp ", 123);
    freq.put("TE ", 261);
    freq.put("xy ", 78);
    freq.put("low", 311);
    freq.put("Z", 252);
    freq.put("arv", 60);
    freq.put("ura", 1398);
    freq.put("azi", 3140);
    freq.put("Vog", 135);
    freq.put("urb", 64);
    freq.put("SU ", 34);
    freq.put("iqu", 54);
    freq.put("Voi", 37);
    freq.put("Odi", 40);
    freq.put("azz", 2003);
    freq.put("Lun", 67);
    freq.put("gi ", 1419);
    freq.put("olt", 1965);
    freq.put("Odd", 69);
    freq.put("urn", 57);
    freq.put("nno", 2338);
    freq.put("Sir", 61);
    freq.put("uro", 889);
    freq.put("nni", 809);
    freq.put("Ste", 187);
    freq.put(" n ", 109);
    freq.put("nne", 559);
    freq.put("nna", 633);
    freq.put("uri", 521);
    freq.put("Sic", 114);
    freq.put("Sia", 86);
    freq.put("Sig", 41);
    freq.put("D ", 2122);
    freq.put("nny", 23);
    freq.put("tea", 65);
    freq.put("rrà", 74);
    freq.put("Sin", 68);
    freq.put("Sim", 110);
    freq.put("Sta", 447);
    freq.put("nh", 43);
    freq.put("ni", 12028);
    freq.put("nj", 26);
    freq.put("nk", 334);
    freq.put("nl", 203);
    freq.put("NE ", 181);
    freq.put("nn", 4892);
    freq.put("no", 28588);
    freq.put("tit", 890);
    freq.put("na", 14380);
    freq.put("nb", 44);
    freq.put("nc", 6890);
    freq.put("nd", 10856);
    freq.put("ne", 15095);
    freq.put("nf", 1116);
    freq.put("ng", 3429);
    freq.put("til", 416);
    freq.put("ny", 113);
    freq.put("nz", 3446);
    freq.put("Pom", 29);
    freq.put("già", 586);
    freq.put("np", 37);
    freq.put("nq", 743);
    freq.put("nr", 70);
    freq.put("ns", 3185);
    freq.put("nt", 19251);
    freq.put("nu", 2755);
    freq.put("nv", 1099);
    freq.put("tic", 1817);
    freq.put(" ni", 559);
    freq.put("fot", 758);
    freq.put("Sto", 226);
    freq.put("E", 3235);
    freq.put("urr", 107);
    freq.put(" no", 10284);
    freq.put(" nn", 287);
    freq.put(" na", 583);
    freq.put("urs", 48);
    freq.put(" ne", 3857);
    freq.put("squ", 139);
    freq.put("nn ", 315);
    freq.put("mun", 701);
    freq.put("Lec", 25);
    freq.put("tec", 358);
    freq.put("Rec", 37);
    freq.put("arz", 71);
    freq.put("bo ", 191);
    freq.put(" nu", 1499);
    freq.put("ppa", 497);
    freq.put("fà", 27);
    freq.put("axi", 23);
    freq.put("n ", 27479);
    freq.put("Win", 89);
    freq.put("fos", 310);
    freq.put("mme", 596);
    freq.put("Wik", 35);
    freq.put("Wir", 31);
    freq.put("blo", 293);
    freq.put("rk ", 144);
    freq.put("ti ", 10373);
    freq.put("SS ", 41);
    freq.put("unf", 29);
    freq.put("roi", 201);
    freq.put("lly", 72);
    freq.put("Ci ", 216);
    freq.put("rol", 597);
    freq.put("rom", 446);
    freq.put("ron", 964);
    freq.put("roo", 45);
    freq.put("roa", 29);
    freq.put("rob", 496);
    freq.put("roc", 290);
    freq.put("rod", 198);
    freq.put("ost", 2469);
    freq.put("rof", 467);
    freq.put("rog", 365);
    freq.put("osi", 640);
    freq.put("fè", 80);
    freq.put("roz", 31);
    freq.put("llo", 2843);
    freq.put("ob ", 49);
    freq.put("oso", 481);
    freq.put("lll", 32);
    freq.put("rop", 1603);
    freq.put("ror", 131);
    freq.put("ros", 776);
    freq.put("rot", 388);
    freq.put("rou", 61);
    freq.put("rov", 1320);
    freq.put("row", 28);
    freq.put("Aqu", 28);
    freq.put("vet", 300);
    freq.put("ver", 3643);
    freq.put("ves", 335);
    freq.put("Dal", 126);
    freq.put("afi", 311);
    freq.put("Dan", 93);
    freq.put("di ", 14610);
    freq.put("Dai", 96);
    freq.put("Dat", 49);
    freq.put("veg", 282);
    freq.put("Dav", 69);
    freq.put("fog", 77);
    freq.put("Cmq", 40);
    freq.put("Dar", 34);
    freq.put("ven", 1632);
    freq.put("uma", 177);
    freq.put("vel", 353);
    freq.put("ó ", 78);
    freq.put("Cic", 26);
    freq.put(" do", 3396);
    freq.put("Cia", 165);
    freq.put("ro ", 6359);
    freq.put("Sky", 57);
    freq.put("Cio", 82);
    freq.put("Cin", 95);
    freq.put("fol", 263);
    freq.put("we", 704);
    freq.put("Cit", 70);
    freq.put("erp", 78);
    freq.put("hPa", 27);
    freq.put("ll ", 2097);
    freq.put("umo", 138);
    freq.put("wç ", 30);
    freq.put("dil", 73);
    freq.put("dim", 404);
    freq.put("gua", 902);
    freq.put("EO ", 40);
    freq.put("Da ", 172);
    freq.put("gue", 264);
    freq.put("did", 88);
    freq.put("die", 315);
    freq.put("gui", 408);
    freq.put("ers", 1718);
    freq.put("guo", 81);
    freq.put("dia", 1296);
    freq.put("dib", 95);
    freq.put("dic", 1463);
    freq.put("gus", 108);
    freq.put("p", 60663);
    freq.put("ge ", 421);
    freq.put("diz", 221);
    freq.put("dit", 621);
    freq.put("È ", 212);
    freq.put("He", 102);
    freq.put("dip", 126);
    freq.put(" de", 9832);
    freq.put("dir", 1069);
    freq.put("rz", 555);
    freq.put("ol ", 489);
    freq.put("uck", 70);
    freq.put("M ", 274);
    freq.put("hta", 23);
    freq.put(" Yo", 135);
    freq.put(" Ya", 31);
    freq.put("Rep", 100);
    freq.put(" Ye", 40);
    freq.put("Ret", 41);
    freq.put("ery", 53);
    freq.put("Gre", 92);
    freq.put("Ren", 69);
    freq.put("dev", 961);
    freq.put("ary", 43);
    freq.put("Gra", 469);
    freq.put("Gro", 54);
    freq.put("Rea", 94);
    freq.put("IN ", 127);
    freq.put("Reg", 123);
    freq.put("Red", 33);
    freq.put("Gri", 35);
    freq.put("ade", 673);
    freq.put("erd", 676);
    freq.put("rul", 27);
    freq.put("rum", 168);
    freq.put("ek ", 47);
    freq.put("Qua", 502);
    freq.put("rub", 69);
    freq.put("Que", 360);
    freq.put("oer", 29);
    freq.put("Qui", 151);
    freq.put("zzu", 51);
    freq.put("Quo", 53);
    freq.put("era", 3715);
    freq.put("Me", 654);
    freq.put("lem", 338);
    freq.put("Bos", 90);
    freq.put("Ma", 2553);
    freq.put("erb", 105);
    freq.put("Mc", 33);
    freq.put("ht ", 92);
    freq.put("Agg", 40);
    freq.put("ruf", 23);
    freq.put("Mo", 743);
    freq.put("deo", 681);
    freq.put("Mi", 1470);
    freq.put("clo", 80);
    freq.put("rug", 66);
    freq.put("Mu", 203);
    freq.put("anu", 73);
    freq.put("uff", 336);
    freq.put("Mr", 23);
    freq.put("Re ", 69);
    freq.put("My", 28);
    freq.put(" du", 817);
    freq.put("box", 34);
    freq.put("ruz", 99);
    freq.put("çwç", 51);
    freq.put("dec", 331);
    freq.put("arc", 730);
    freq.put("eke", 45);
    freq.put("bos", 38);
    freq.put("bot", 92);
    freq.put("dee", 89);
    freq.put("boh", 89);
    freq.put("HA ", 191);
    freq.put("ata", 3224);
    freq.put("bol", 142);
    freq.put("bom", 50);
    freq.put("bon", 153);
    freq.put("boo", 372);
    freq.put("deg", 431);
    freq.put("ugh", 24);
    freq.put("ard", 1418);
    freq.put("ipa", 340);
    freq.put("Bon", 72);
    freq.put("Mio", 30);
    freq.put("ipe", 312);
    freq.put("ngh", 141);
    freq.put("iph", 43);
    freq.put("ipi", 126);
    freq.put("ipo", 527);
    freq.put("ipl", 44);
    freq.put("ipr", 139);
    freq.put("ipp", 88);
    freq.put("Lig", 68);
    freq.put("uzz", 144);
    freq.put("Mot", 61);
    freq.put("zze", 353);
    freq.put("Lia", 34);
    freq.put("ayl", 33);
    freq.put(" Ka", 113);
    freq.put("Min", 143);
    freq.put("nem", 262);
    freq.put(" Ke", 51);
    freq.put("aye", 31);
    freq.put("msu", 60);
    freq.put(" Ki", 71);
    freq.put(" Ko", 38);
    freq.put(" Kr", 24);
    freq.put("msn", 27);
    freq.put("Ogn", 63);
    freq.put("zza", 1670);
    freq.put(" Ku", 30);
    freq.put("Ogg", 268);
    freq.put("Udi", 26);
    freq.put("uas", 231);
    freq.put("Mon", 258);
    freq.put("ood", 95);
    freq.put("ip ", 133);
    freq.put("uar", 924);
    freq.put("Ben", 162);
    freq.put("ngr", 144);
    freq.put("Bel", 217);
    freq.put("F", 3309);
    freq.put("oom", 25);
    freq.put("ool", 81);
    freq.put("ooo", 760);
    freq.put("Bea", 46);
    freq.put("Eve", 35);
    freq.put("ook", 437);
    freq.put("ma ", 6564);
    freq.put("oot", 44);
    freq.put("fb ", 50);
    freq.put("oop", 35);
    freq.put("mba", 209);
    freq.put("oor", 46);
    freq.put("Ber", 417);
    freq.put("ibi", 692);
    freq.put("sù", 40);
    freq.put("ibl", 32);
    freq.put("ibo", 48);
    freq.put("cas", 1133);
    freq.put("iba", 72);
    freq.put("DO ", 89);
    freq.put("cap", 1298);
    freq.put("flu", 48);
    freq.put("ibe", 261);
    freq.put("ult", 677);
    freq.put("cat", 1420);
    freq.put("fli", 29);
    freq.put("sè", 30);
    freq.put("ulo", 257);
    freq.put("ull", 957);
    freq.put("sì", 1073);
    freq.put("fla", 35);
    freq.put("cab", 47);
    freq.put("ibr", 350);
    freq.put("sà", 74);
    freq.put("fle", 59);
    freq.put("ibu", 113);
    freq.put("Mic", 109);
    freq.put("ms ", 63);
    freq.put(" on", 466);
    freq.put(" oo", 27);
    freq.put(" ol", 142);
    freq.put(" om", 108);
    freq.put(" ok", 309);
    freq.put(" oh", 177);
    freq.put("ger", 679);
    freq.put(" of", 235);
    freq.put(" og", 1151);
    freq.put(" od", 354);
    freq.put("uan", 1759);
    freq.put(" ob", 81);
    freq.put(" oc", 371);
    freq.put("uls", 35);
    freq.put("spi", 607);
    freq.put("spl", 123);
    freq.put("spo", 939);
    freq.put(" ov", 193);
    freq.put("spa", 568);
    freq.put(" ot", 378);
    freq.put(" ou", 31);
    freq.put(" or", 2176);
    freq.put(" os", 241);
    freq.put(" op", 323);
    freq.put("Ed ", 52);
    freq.put("ST ", 42);
    freq.put("rvi", 423);
    freq.put("ado", 755);
    freq.put("gh ", 34);
    freq.put("mel", 243);
    freq.put("s ", 3587);
    freq.put("oss", 1892);
    freq.put("naa", 23);
    freq.put("map", 35);
    freq.put("mas", 345);
    freq.put("mar", 900);
    freq.put("din", 509);
    freq.put("mav", 59);
    freq.put("max", 27);
    freq.put("fed", 48);
    freq.put(" o ", 1374);
    freq.put("maa", 32);
    freq.put("mac", 256);
    freq.put("enc", 102);
    freq.put("uga", 52);
    freq.put("mad", 189);
    freq.put("mag", 779);
    freq.put("maf", 30);
    freq.put("sp ", 33);
    freq.put("mah", 41);
    freq.put("lmi", 65);
    freq.put("lì ", 127);
    freq.put("mam", 309);
    freq.put("mal", 881);
    freq.put("ene", 2059);
    freq.put("ght", 101);
    freq.put("sy", 43);
    freq.put("dio", 1119);
    freq.put("ss", 9901);
    freq.put("sr", 35);
    freq.put("sq", 140);
    freq.put("sp", 4141);
    freq.put("sw", 44);
    freq.put("sv", 419);
    freq.put("su", 5952);
    freq.put("st", 18659);
    freq.put("q", 9014);
    freq.put("ghe", 223);
    freq.put("si", 14630);
    freq.put("sh", 522);
    freq.put("so", 13758);
    freq.put("sn", 142);
    freq.put("sm", 596);
    freq.put("sl", 163);
    freq.put("sc", 8344);
    freq.put("sb", 330);
    freq.put("sa", 9970);
    freq.put("sg", 108);
    freq.put("sf", 565);
    freq.put("se", 14015);
    freq.put("sd", 90);
    freq.put("Ru", 99);
    freq.put("tty", 30);
    freq.put("ro", 15087);
    freq.put("lsa", 28);
    freq.put("Chi", 313);
    freq.put("ttp", 115);
    freq.put("Jar", 24);
    freq.put("Ry", 23);
    freq.put(" aN", 62);
    freq.put("lsi", 101);
    freq.put("Re", 723);
    freq.put("Chr", 44);
    freq.put("Jam", 25);
    freq.put("tto", 5596);
    freq.put("Ra", 393);
    freq.put("ttl", 26);
    freq.put("tta", 2841);
    freq.put("Ro", 727);
    freq.put("Ri", 618);
    freq.put("tte", 3547);
    freq.put("sod", 120);
    freq.put(" aa", 72);
    freq.put(" ab", 838);
    freq.put(" ac", 879);
    freq.put(" ad", 1349);
    freq.put(" ae", 54);
    freq.put(" af", 244);
    freq.put(" ag", 728);
    freq.put(" ah", 1167);
    freq.put(" ai", 619);
    freq.put(" al", 6928);
    freq.put(" am", 1622);
    freq.put(" an", 5215);
    freq.put("tie", 259);
    freq.put(" ap", 1285);
    freq.put(" ar", 1323);
    freq.put(" as", 1211);
    freq.put(" at", 708);
    freq.put(" au", 577);
    freq.put(" av", 1773);
    freq.put(" aw", 37);
    freq.put("ent", 9577);
    freq.put(" az", 173);
    freq.put("gel", 191);
    freq.put("coi", 88);
    freq.put("enu", 291);
    freq.put("nol", 203);
    freq.put("nom", 470);
    freq.put("àà", 29);
    freq.put("noo", 76);
    freq.put("env", 61);
    freq.put("ls ", 50);
    freq.put(" cc", 52);
    freq.put("uge", 24);
    freq.put("noa", 23);
    freq.put("nob", 23);
    freq.put("noc", 102);
    freq.put("ert", 1586);
    freq.put("aer", 61);
    freq.put("R ", 361);
    freq.put("not", 898);
    freq.put("sht", 27);
    freq.put("nov", 515);
    freq.put(" us", 614);
    freq.put("nor", 466);
    freq.put("nos", 882);
    freq.put(" a ", 8467);
    freq.put("LI ", 125);
    freq.put("TA ", 312);
    freq.put("ppr", 169);
    freq.put(" wo", 54);
    freq.put("ndu", 129);
    freq.put("ony", 41);
    freq.put("sot", 276);
    freq.put("em", 5508);
    freq.put("el", 15785);
    freq.put("eo", 1478);
    freq.put("en", 22537);
    freq.put("ei", 4262);
    freq.put("eh", 782);
    freq.put("ek", 126);
    freq.put("ej", 33);
    freq.put("ee", 1777);
    freq.put("ed", 5363);
    freq.put("eg", 5031);
    freq.put("ef", 996);
    freq.put("ea", 2237);
    freq.put("rl ", 39);
    freq.put("ec", 3759);
    freq.put("eb", 1756);
    freq.put("Luc", 112);
    freq.put("ey", 277);
    freq.put("ex", 245);
    freq.put("ez", 1465);
    freq.put("eu", 417);
    freq.put("et", 9589);
    freq.put("ew", 480);
    freq.put("ev", 3556);
    freq.put("eq", 104);
    freq.put("ep", 865);
    freq.put("es", 14015);
    freq.put("er", 35591);
    freq.put("EN ", 39);
    freq.put("sha", 62);
    freq.put("blu", 52);
    freq.put("blr", 42);
    freq.put("Job", 78);
    freq.put("bli", 572);
    freq.put("dif", 345);
    freq.put("os ", 229);
    freq.put("Doc", 25);
    freq.put("Joh", 35);
    freq.put("ula", 201);
    freq.put("bla", 58);
    freq.put("Jon", 49);
    freq.put("she", 32);
    freq.put("rlo", 603);
    freq.put("rli", 277);
    freq.put("RT ", 458);
    freq.put("G", 3644);
    freq.put("ory", 34);
    freq.put("rle", 163);
    freq.put("rld", 31);
    freq.put("ort", 2043);
    freq.put("oru", 93);
    freq.put("rla", 840);
    freq.put("e ", 95401);
    freq.put("orp", 157);
    freq.put("orn", 2580);
    freq.put("oro", 1216);
    freq.put("orl", 67);
    freq.put("orm", 1029);
    freq.put("ork", 115);
    freq.put("ori", 2278);
    freq.put("rlu", 303);
    freq.put("org", 286);
    freq.put("ord", 966);
    freq.put("ore", 2722);
    freq.put("orb", 35);
    freq.put("orc", 190);
    freq.put("ora", 3290);
    freq.put("cem", 154);
    freq.put("maz", 259);
    freq.put("App", 342);
    freq.put("ael", 68);
    freq.put("sms", 24);
    freq.put("zzz", 30);
    freq.put("lla", 6341);
    freq.put(" ce", 1567);
    freq.put("Ape", 29);
    freq.put("zan", 210);
    freq.put("xk", 36);
    freq.put("xi", 65);
    freq.put("onn", 642);
    freq.put("xo", 35);
    freq.put("onl", 126);
    freq.put("ebe", 107);
    freq.put("onc", 535);
    freq.put("fg", 52);
    freq.put("onf", 372);
    freq.put("ong", 450);
    freq.put("ond", 2001);
    freq.put("xe", 50);
    freq.put("onz", 173);
    freq.put("xx", 28);
    freq.put("xy", 81);
    freq.put("zaz", 95);
    freq.put("lau", 111);
    freq.put("ons", 735);
    freq.put("xp", 35);
    freq.put("onq", 26);
    freq.put("onv", 258);
    freq.put("Dop", 150);
    freq.put("xt", 33);
    freq.put("Eur", 205);
    freq.put("iam", 3159);
    freq.put("ial", 1088);
    freq.put("iao", 398);
    freq.put("ian", 2205);
    freq.put("iai", 62);
    freq.put("€ ", 237);
    freq.put("iad", 41);
    freq.put("iag", 222);
    freq.put("iaa", 29);
    freq.put("adu", 136);
    freq.put("iac", 1182);
    freq.put("iab", 62);
    freq.put("Tot", 25);
    freq.put("ule", 53);
    freq.put("iaz", 244);
    freq.put("iat", 1461);
    freq.put("iav", 138);
    freq.put("Ott", 123);
    freq.put("iap", 106);
    freq.put("ias", 182);
    freq.put("iar", 1325);
    freq.put(" Zo", 24);
    freq.put(" Zi", 24);
    freq.put("hua", 45);
    freq.put(" Ze", 40);
    freq.put("x ", 750);
    freq.put(" Za", 81);
    freq.put("za ", 2608);
    freq.put("ebi", 53);
    freq.put("Tou", 33);
    freq.put("ush", 39);
    freq.put("SE ", 105);
    freq.put(" Zu", 28);
    freq.put(" ya", 28);
    freq.put("gim", 36);
    freq.put("Mis", 81);
    freq.put("rze", 57);
    freq.put("wat", 64);
    freq.put("erò", 772);
    freq.put("rza", 272);
    freq.put("rzo", 102);
    freq.put("Ali", 44);
    freq.put("ia ", 8804);
    freq.put("rzi", 104);
    freq.put("r", 134824);
    freq.put("ehe", 79);
    freq.put("IS ", 54);
    freq.put("kyp", 26);
    freq.put("pre", 3924);
    freq.put("ane", 746);
    freq.put("sai", 234);
    freq.put("ang", 816);
    freq.put("Pao", 67);
    freq.put("ebr", 47);
    freq.put("sam", 232);
    freq.put("sal", 691);
    freq.put("sac", 145);
    freq.put("sab", 219);
    freq.put("pro", 3102);
    freq.put("ano", 3647);
    freq.put("sag", 307);
    freq.put("ani", 2245);
    freq.put("ank", 71);
    freq.put("ant", 4135);
    freq.put("saz", 70);
    freq.put("ry ", 311);
    freq.put("ììì", 33);
    freq.put("sas", 75);
    freq.put("sar", 1421);
    freq.put("sap", 568);
    freq.put("sav", 137);
    freq.put("sau", 32);
    freq.put("sat", 734);
    freq.put("cd ", 43);
    freq.put("Do", 683);
    freq.put("omm", 441);
    freq.put("rmi", 1098);
    freq.put("Ecc", 192);
    freq.put("Di", 817);
    freq.put("Eco", 41);
    freq.put("afr", 27);
    freq.put("De", 613);
    freq.put("lti", 643);
    freq.put("GO ", 37);
    freq.put("zon", 423);
    freq.put("Da", 712);
    freq.put("ax ", 71);
    freq.put("elf", 36);
    freq.put("Du", 124);
    freq.put("Dr", 88);
    freq.put("ts ", 110);
    freq.put("lup", 115);
    freq.put("Off", 114);
    freq.put("sa ", 4211);
    freq.put("ndì", 24);
    freq.put("TG ", 23);
    freq.put(" ye", 37);
    freq.put("Ult", 73);
    freq.put("Sha", 42);
    freq.put("rò ", 1203);
    freq.put("zo ", 1316);
    freq.put(" Le", 865);
    freq.put("Lic", 24);
    freq.put(" La", 1705);
    freq.put("uss", 155);
    freq.put(" Lo", 538);
    freq.put("axy", 50);
    freq.put(" Li", 584);
    freq.put(" Lu", 315);
    freq.put("ò", 2134);
    freq.put("MG ", 25);
    freq.put("oy ", 31);
    freq.put("rix", 29);
    freq.put("Web", 58);
    freq.put("set", 728);
    freq.put("fes", 393);
    freq.put("oog", 155);
    freq.put("upe", 446);
    freq.put("Fla", 32);
    freq.put(" p ", 69);
    freq.put("ama", 746);
    freq.put("nli", 135);
    freq.put("lay", 107);
    freq.put("dy ", 85);
    freq.put("ss ", 239);
    freq.put("nlo", 31);
    freq.put("We", 133);
    freq.put("uh ", 43);
    freq.put("Wa", 106);
    freq.put("Wo", 65);
    freq.put("ce ", 3035);
    freq.put("lub", 47);
    freq.put("Wi", 227);
    freq.put("Wh", 26);
    freq.put("tne", 48);
    freq.put("ià ", 642);
    freq.put("Tar", 45);
    freq.put(" ps", 76);
    freq.put(" pr", 6551);
    freq.put("gev", 32);
    freq.put(" pu", 2036);
    freq.put("get", 266);
    freq.put("ssu", 560);
    freq.put("H", 1930);
    freq.put("sss", 112);
    freq.put("ffr", 154);
    freq.put(" pc", 96);
    freq.put(" pa", 4587);
    freq.put("geg", 24);
    freq.put("fà ", 25);
    freq.put(" pe", 10289);
    freq.put("ged", 34);
    freq.put("sse", 1804);
    freq.put(" pi", 4302);
    freq.put(" ph", 42);
    freq.put(" po", 5115);
    freq.put("gen", 1108);
    freq.put("gem", 30);
    freq.put(" pl", 128);
    freq.put("W ", 104);
    freq.put("cid", 313);
    freq.put("uù ", 36);
    freq.put("Tim", 57);
    freq.put("lum", 74);
    freq.put("Vol", 95);
    freq.put("ó", 82);
    freq.put("lun", 295);
    freq.put("apu", 37);
    freq.put("mmm", 126);
    freq.put("uti", 689);
    freq.put("ffi", 580);
    freq.put("sà ", 73);
    freq.put("uvo", 63);
    freq.put("aio", 175);
    freq.put("cin", 822);
    freq.put("rma", 1081);
    freq.put("alg", 57);
    freq.put("cim", 80);
    freq.put("rme", 396);
    freq.put("tu ", 749);
    freq.put("cil", 286);
    freq.put("j ", 52);
    freq.put("ffe", 489);
    freq.put("cis", 351);
    freq.put("nis", 628);
    freq.put("bio", 294);
    freq.put(" b ", 27);
    freq.put("cir", 300);
    freq.put("mol", 702);
    freq.put("boy", 24);
    freq.put("uve", 125);
    freq.put("cip", 304);
    freq.put("È", 210);
    freq.put("rko", 32);
    freq.put("civ", 77);
    freq.put(" pò", 123);
    freq.put("tuz", 32);
    freq.put("tus", 83);
    freq.put("ciu", 215);
    freq.put("uor", 485);
    freq.put("tup", 227);
    freq.put("ju", 67);
    freq.put("tur", 939);
    freq.put("utu", 239);
    freq.put("tut", 2580);
    freq.put("Leg", 152);
    freq.put("tui", 144);
    freq.put("ue ", 1427);
    freq.put("jo", 107);
    freq.put("ji", 24);
    freq.put("tun", 304);
    freq.put("jk", 36);
    freq.put("jd", 39);
    freq.put("je", 85);
    freq.put("jf", 39);
    freq.put("tud", 405);
    freq.put("ja", 140);
    freq.put("tuf", 32);
    freq.put("uov", 1195);
    freq.put(" be", 2902);
    freq.put(" bg", 25);
    freq.put("uf", 422);
    freq.put(" ba", 1593);
    freq.put("fit", 96);
    freq.put(" bb", 23);
    freq.put("vun", 35);
    freq.put(" bl", 370);
    freq.put(" bo", 594);
    freq.put("fiu", 68);
    freq.put(" bi", 849);
    freq.put(" bh", 48);
    freq.put(" bu", 1004);
    freq.put(" ù ", 94);
    freq.put("s", 107842);
    freq.put("apà", 60);
    freq.put(" br", 689);
    freq.put(" by", 59);
    freq.put("tum", 87);
    freq.put("Sis", 28);
    freq.put("uci", 248);
    freq.put("vre", 525);
    freq.put("pov", 131);
    freq.put("yn ", 57);
    freq.put("pot", 727);
    freq.put("tuo", 584);
    freq.put("por", 1380);
    freq.put("pos", 1873);
    freq.put("pop", 103);
    freq.put("AY ", 24);
    freq.put("pon", 612);
    freq.put("poo", 27);
    freq.put("pol", 824);
    freq.put("pom", 161);
    freq.put("bbr", 177);
    freq.put("poi", 1028);
    freq.put("pog", 46);
    freq.put("pod", 73);
    freq.put("poe", 43);
    freq.put("poc", 486);
    freq.put("uoc", 78);
    freq.put("fic", 1018);
    freq.put("Bur", 26);
    freq.put("Bus", 29);
    freq.put("dis", 1119);
    freq.put("Liv", 62);
    freq.put("ssà", 65);
    freq.put("ei ", 3987);
    freq.put("pà ", 63);
    freq.put("Buo", 385);
    freq.put("AS ", 26);
    freq.put("rà", 1047);
    freq.put("bil", 1134);
    freq.put("cqu", 214);
    freq.put("pò ", 123);
    freq.put("po ", 2980);
    freq.put("mpe", 440);
    freq.put("rgi", 182);
    freq.put("IL ", 146);
    freq.put("au ", 24);
    freq.put("uon", 1190);
    freq.put("CO ", 86);
    freq.put("eic", 45);
    freq.put("uom", 203);
    freq.put("vuo", 555);
    freq.put("ein", 58);
    freq.put("ive", 1751);
    freq.put("iva", 1261);
    freq.put("ivo", 843);
    freq.put("ivi", 785);
    freq.put("oi ", 2498);
    freq.put("zis", 30);
    freq.put("Bar", 184);
    freq.put("nnu", 148);
    freq.put("Bas", 114);
    freq.put("pap", 106);
    freq.put(" Me", 632);
    freq.put("par", 3096);
    freq.put("pas", 732);
    freq.put("pat", 484);
    freq.put(" Ma", 2520);
    freq.put("pav", 47);
    freq.put(" Mc", 32);
    freq.put("paz", 334);
    freq.put(" Mo", 722);
    freq.put(" Mi", 1448);
    freq.put("neb", 23);
    freq.put(" Mu", 199);
    freq.put("pac", 262);
    freq.put("pad", 194);
    freq.put("pae", 122);
    freq.put(" Mr", 23);
    freq.put("cen", 1231);
    freq.put("I ", 2264);
    freq.put("Sil", 96);
    freq.put("pal", 444);
    freq.put(" My", 27);
    freq.put("pan", 326);
    freq.put("pao", 23);
    freq.put("oio", 92);
    freq.put("oin", 67);
    freq.put("oil", 36);
    freq.put("AI ", 100);
    freq.put("nac", 160);
    freq.put("I", 6035);
    freq.put("oie", 65);
    freq.put("oid", 113);
    freq.put("nsa", 691);
    freq.put("oia", 173);
    freq.put("bim", 69);
    freq.put(" gu", 858);
    freq.put("two", 63);
    freq.put("ux ", 26);
    freq.put("osh", 33);
    freq.put("Mau", 29);
    freq.put("mpa", 767);
    freq.put("arb", 111);
    freq.put("Ji", 29);
    freq.put("Mat", 120);
    freq.put("ds ", 102);
    freq.put(" M ", 71);
    freq.put("HO ", 29);
    freq.put("cev", 280);
    freq.put("ccu", 238);
    freq.put("Ip", 25);
    freq.put("Is", 109);
    freq.put("Ir", 58);
    freq.put("DI ", 206);
    freq.put("It", 812);
    freq.put("pa ", 666);
    freq.put("cco", 1804);
    freq.put("Im", 113);
    freq.put("Il", 1540);
    freq.put("Io", 511);
    freq.put("In", 1154);
    freq.put("cce", 638);
    freq.put("ces", 554);
    freq.put("Ic", 24);
    freq.put("Ib", 30);
    freq.put("Ie", 51);
    freq.put("Id", 39);
    freq.put("ccc", 44);
    freq.put("Bac", 34);
    freq.put(" qu", 7233);
    freq.put("tip", 427);
    freq.put("ps ", 79);
    freq.put("vid", 837);
    freq.put("oki", 65);
    freq.put("rpr", 91);
    freq.put("giù", 67);
    freq.put("mpo", 935);
    freq.put("Vi ", 90);
    freq.put("uid", 146);
    freq.put("mo ", 4984);
    freq.put("Bal", 74);
    freq.put("yr", 35);
    freq.put("Her", 28);
    freq.put("nas", 288);
    freq.put("Mac", 86);
    freq.put("ot ", 117);
    freq.put(" ge", 884);
    freq.put("uig", 23);
    freq.put("aly", 58);
    freq.put("ouT", 39);
    freq.put("ami", 1116);
    freq.put("á ", 35);
    freq.put("psi", 56);
    freq.put("amm", 820);
    freq.put("Mag", 124);
    freq.put("amo", 3333);
    freq.put("Rag", 70);
    freq.put("mos", 283);
    freq.put("mor", 1190);
    freq.put(" ga", 442);
    freq.put("oè ", 191);
    freq.put("mov", 46);
    freq.put("mou", 32);
    freq.put("mot", 214);
    freq.put("naz", 213);
    freq.put("azo", 39);
    freq.put("LY ", 57);
    freq.put("mon", 1023);
    freq.put("mom", 260);
    freq.put("gro", 108);
    freq.put("moc", 125);
    freq.put("mob", 87);
    freq.put("ams", 75);
    freq.put("aco", 311);
    freq.put("mog", 61);
    freq.put("tif", 215);
    freq.put("mod", 409);
    freq.put("Lor", 52);
    freq.put("ors", 893);
    freq.put("ttr", 193);
    freq.put("Pin", 67);
    freq.put("oè", 196);
    freq.put("Pia", 143);
    freq.put("Pic", 41);
    freq.put("Pie", 95);
    freq.put("tia", 454);
    freq.put("t", 137785);
    freq.put("oes", 40);
    freq.put("Lov", 56);
    freq.put("Pir", 26);
    freq.put("gri", 196);
    freq.put("odo", 398);
    freq.put("Nel", 140);
    freq.put("ezz", 934);
    freq.put("cs", 73);
    freq.put("alt", 1485);
    freq.put("ezi", 407);
    freq.put("ngl", 187);
    freq.put("New", 267);
    freq.put("Net", 34);
    freq.put("Rai", 75);
    freq.put("Ner", 31);
    freq.put("Nes", 51);
    freq.put("mus", 269);
    freq.put("Med", 102);
    freq.put(" ch", 11473);
    freq.put(" ci", 3187);
    freq.put(" co", 14499);
    freq.put(" cl", 385);
    freq.put(" cm", 156);
    freq.put("cw", 55);
    freq.put(" ca", 6415);
    freq.put(" cd", 47);
    freq.put("o ", 100237);
    freq.put("Met", 63);
    freq.put("ddi", 416);
    freq.put("uo ", 858);
    freq.put("ddo", 187);
    freq.put("ES ", 40);
    freq.put("Mes", 70);
    freq.put("Mer", 128);
    freq.put(" cr", 1134);
    freq.put("dda", 114);
    freq.put("uch", 70);
    freq.put(" cw", 55);
    freq.put("dde", 45);
    freq.put(" cu", 980);
    freq.put("bbo", 91);
    freq.put("mpi", 586);
    freq.put("zit", 44);
    freq.put("lzo", 24);
    freq.put("Ne ", 31);
    freq.put("uTu", 39);
    freq.put("Dra", 35);
    freq.put("ez ", 91);
    freq.put("tv ", 126);
    freq.put("oo", 2113);
    freq.put("on", 36497);
    freq.put("om", 8878);
    freq.put("ol", 12538);
    freq.put("ok", 886);
    freq.put("oj", 40);
    freq.put("oi", 3158);
    freq.put("oh", 399);
    freq.put("og", 4841);
    freq.put("of", 1040);
    freq.put(" c ", 1085);
    freq.put("od", 1874);
    freq.put("oc", 3920);
    freq.put("ob", 1480);
    freq.put("oa", 260);
    freq.put("Rin", 34);
    freq.put("Più", 44);
    freq.put("Umi", 69);
    freq.put("Si ", 363);
    freq.put("oz", 347);
    freq.put("oy", 78);
    freq.put("ox", 113);
    freq.put("ow", 631);
    freq.put("ov", 5456);
    freq.put("ou", 906);
    freq.put("ot", 5516);
    freq.put("os", 9797);
    freq.put("or", 19692);
    freq.put("oq", 27);
    freq.put("op", 4230);
    freq.put("LE ", 212);
    freq.put("Ni", 256);
    freq.put("ys ", 32);
    freq.put("Ads", 29);
    freq.put("No", 1897);
    freq.put("uil", 181);
    freq.put("Na", 449);
    freq.put("alp", 37);
    freq.put("Ne", 666);
    freq.put("Add", 34);
    freq.put("Ade", 86);
    freq.put("bba", 205);
    freq.put("Ado", 29);
    freq.put("Nu", 254);
    freq.put("ung", 404);
    freq.put("het", 156);
    freq.put("loc", 467);
    freq.put("loa", 60);
    freq.put("log", 653);
    freq.put("her", 479);
    freq.put("hes", 51);
    freq.put("EL ", 78);
    freq.put("lon", 383);
    freq.put("loo", 68);
    freq.put("hez", 37);
    freq.put("lom", 58);
    freq.put("hed", 102);
    freq.put("hee", 26);
    freq.put("lop", 40);
    freq.put("heg", 42);
    freq.put("sib", 305);
    freq.put("hea", 36);
    freq.put("lot", 139);
    freq.put("hec", 49);
    freq.put("hel", 101);
    freq.put("hem", 34);
    freq.put("ehm", 35);
    freq.put("heh", 68);
    freq.put("hei", 29);
    freq.put("ehi", 25);
    freq.put("uin", 435);
    freq.put("agn", 614);
    freq.put("N ", 660);
    freq.put("J", 901);
    freq.put("na ", 8459);
    freq.put("agl", 757);
    freq.put(" st", 6073);
    freq.put("Ad ", 24);
    freq.put("uù", 123);
    freq.put("lo ", 7622);
    freq.put("agi", 887);
    freq.put("mat", 1116);
    freq.put("svi", 76);
    freq.put(" sh", 164);
    freq.put("Avr", 39);
    freq.put("Tv ", 26);
    freq.put("agg", 1277);
    freq.put("as ", 240);
    freq.put("he ", 13316);
    freq.put("eh ", 582);
    freq.put(" sn", 74);
    freq.put("Ti ", 188);
    freq.put("aa", 1114);
    freq.put("oth", 31);
    freq.put("ac", 6387);
    freq.put("ab", 2444);
    freq.put("ae", 400);
    freq.put("ad", 4133);
    freq.put("ag", 5679);
    freq.put("af", 1059);
    freq.put("ai", 5135);
    freq.put("ah", 4517);
    freq.put("ak", 243);
    freq.put("aj", 56);
    freq.put("am", 10387);
    freq.put("al", 20698);
    freq.put("ao", 598);
    freq.put("an", 27613);
    freq.put("aq", 34);
    freq.put("ap", 4392);
    freq.put("as", 7985);
    freq.put("ar", 22188);
    freq.put("au", 1330);
    freq.put("at", 19198);
    freq.put("aw", 81);
    freq.put("av", 5332);
    freq.put("ay", 557);
    freq.put("ax", 157);
    freq.put("az", 5259);
    freq.put("nki", 51);
    freq.put("Lam", 39);
    freq.put("igu", 241);
    freq.put("Ovv", 24);
    freq.put("igr", 74);
    freq.put("ciò", 93);
    freq.put("Lad", 38);
    freq.put("IC ", 30);
    freq.put("aN", 82);
    freq.put("igg", 165);
    freq.put("noi", 464);
    freq.put("ige", 149);
    freq.put("aT", 25);
    freq.put("iga", 350);
    freq.put("ota", 472);
    freq.put("igo", 212);
    freq.put("ign", 416);
    freq.put("Lav", 94);
    freq.put("igl", 1076);
    freq.put("igi", 396);
    freq.put("igh", 205);
    freq.put("a ", 93232);
    freq.put("lga", 37);
    freq.put(" g ", 30);
    freq.put("Ho ", 598);
    freq.put("ru", 1391);
    freq.put("sia", 1298);
    freq.put("oh ", 306);
    freq.put(" zo", 104);
    freq.put("ote", 680);
    freq.put("rp", 365);
    freq.put("lge", 42);
    freq.put("agu", 58);
    freq.put("liz", 421);
    freq.put("ú", 23);
    freq.put("uzi", 238);
    freq.put("at ", 208);
    freq.put("US ", 23);
    freq.put("Bru", 79);
    freq.put("La ", 1259);
    freq.put("Bro", 39);
    freq.put("u", 66406);
    freq.put("NA ", 169);
    freq.put("Bri", 90);
    freq.put("ig ", 48);
    freq.put("Bre", 76);
    freq.put("Bra", 92);
    freq.put("Fir", 80);
    freq.put("scl", 99);
    freq.put("sco", 2401);
    freq.put("Vai", 28);
    freq.put("sci", 1599);
    freq.put("sch", 694);
    freq.put("mp ", 75);
    freq.put("lr ", 40);
    freq.put("sce", 1070);
    freq.put("iu ", 104);
    freq.put("ald", 316);
    freq.put("ale", 3316);
    freq.put("sca", 896);
    freq.put("gu", 2180);
    freq.put("Vad", 53);
    freq.put("€", 244);
    freq.put("Fia", 29);
    freq.put("alz", 155);
    freq.put("Fig", 39);
    freq.put("Fie", 28);
    freq.put("ggo", 90);
    freq.put("gs", 36);
    freq.put("fa ", 1049);
    freq.put("alu", 247);
    freq.put("Fin", 183);
    freq.put("Fio", 59);
    freq.put("Fil", 53);
    freq.put("Gir", 34);
    freq.put("hy ", 24);
    freq.put("smo", 217);
    freq.put("tz", 47);
    freq.put("edd", 196);
    freq.put("ty", 218);
    freq.put("tv", 142);
    freq.put(" N ", 43);
    freq.put("tt", 16964);
    freq.put("tu", 7001);
    freq.put("tr", 10097);
    freq.put("ts", 186);
    freq.put("tp", 177);
    freq.put("tn", 72);
    freq.put("to", 27489);
    freq.put("tl", 123);
    freq.put("tm", 74);
    freq.put("th", 349);
    freq.put("GI ", 44);
    freq.put("tf", 35);
    freq.put("te", 22462);
    freq.put("tb", 42);
    freq.put("tc", 124);
    freq.put("ta", 24553);
    freq.put("faz", 39);
    freq.put("edi", 1375);
    freq.put("ium", 77);
    freq.put("iul", 70);
    freq.put("iun", 303);
    freq.put("far", 1900);
    freq.put("fas", 152);
    freq.put("mpl", 479);
    freq.put("rc", 3628);
    freq.put("fav", 143);
    freq.put("iud", 221);
    freq.put("iug", 55);
    freq.put("edo", 773);
    freq.put("ùù", 119);
    freq.put("rl", 2284);
    freq.put("fai", 291);
    freq.put("fan", 865);
    freq.put("llu", 220);
    freq.put("fal", 159);
    freq.put("fam", 274);
    freq.put("fab", 27);
    freq.put("fac", 1150);
    freq.put("ius", 609);
    freq.put("iur", 96);
    freq.put("iut", 462);
    freq.put(" Ni", 251);
    freq.put("gg", 3987);
    freq.put("and", 4717);
    freq.put("is ", 374);
    freq.put(" No", 1818);
    freq.put("gf", 31);
    freq.put(" Na", 437);
    freq.put(" Ne", 639);
    freq.put("ge", 2987);
    freq.put("SI ", 120);
    freq.put("sma", 107);
    freq.put("rk", 325);
    freq.put(" Nu", 253);
    freq.put("t ", 3771);
    freq.put(" w", 739);
    freq.put("nuv", 54);
    freq.put("tei", 34);
    freq.put("tel", 1091);
    freq.put("ga", 3416);
    freq.put("ten", 1327);
    freq.put("teo", 157);
    freq.put("ù ", 2082);
    freq.put("edu", 119);
    freq.put("ted", 212);
    freq.put("pun", 569);
    freq.put("tef", 55);
    freq.put("teg", 225);
    freq.put("Gio", 278);
    freq.put("tez", 134);
    freq.put("puo", 207);
    freq.put(" r ", 34);
    freq.put("rui", 69);
    freq.put("tep", 52);
    freq.put("mmy", 24);
    freq.put("ter", 3820);
    freq.put("tes", 1139);
    freq.put("tet", 206);
    freq.put("gm", 24);
    freq.put("Sma", 30);
    freq.put("sug", 63);
    freq.put("rbo", 67);
    freq.put("sue", 80);
    freq.put("gl", 5987);
    freq.put("suc", 248);
    freq.put("sub", 170);
    freq.put("sua", 321);
    freq.put("suo", 495);
    freq.put("sun", 487);
    freq.put("sum", 67);
    freq.put("sbu", 23);
    freq.put("tò", 26);
    freq.put("sui", 174);
    freq.put("abo", 136);
    freq.put("mmu", 30);
    freq.put("abr", 135);
    freq.put("sut", 29);
    freq.put("sus", 60);
    freq.put("sur", 193);
    freq.put("sup", 260);
    freq.put("aby", 23);
    freq.put("FF ", 27);
    freq.put("tà", 1563);
    freq.put(" ru", 205);
    freq.put("vev", 512);
    freq.put("ggr", 32);
    freq.put("te ", 11557);
    freq.put("K", 495);
    freq.put("smi", 56);
    freq.put(" re", 1953);
    freq.put("ruo", 31);
    freq.put(" ra", 1381);
    freq.put("pub", 451);
    freq.put(" ro", 753);
    freq.put("Leo", 59);
    freq.put(" ri", 4516);
    freq.put("Wil", 38);
    freq.put("Noi", 57);
    freq.put("ab ", 40);
    freq.put("à", 3661);
    freq.put("Mi ", 540);
    freq.put("su ", 1669);
    freq.put("oma", 1573);
    freq.put("Nok", 44);
    freq.put("mmo", 156);
    freq.put("TS ", 23);
    freq.put("ev ", 37);
    freq.put("sba", 218);
    freq.put("rba", 103);
    freq.put("sig", 481);
    freq.put("ana", 1086);
    freq.put("mmi", 407);
    freq.put("oad", 74);
    freq.put("VA ", 58);
    freq.put("mmh", 27);
    freq.put("vic", 299);
    freq.put("via", 1542);
    freq.put("Aud", 33);
    freq.put("Aug", 36);
    freq.put("vie", 372);
    freq.put("Tor", 166);
    freq.put("vez", 44);
    freq.put("Top", 31);
    freq.put("asd", 23);
    freq.put("vin", 700);
    freq.put("vio", 306);
    freq.put("vil", 179);
    freq.put("vim", 41);
    freq.put("vir", 64);
    freq.put("rke", 92);
    freq.put(" Fr", 315);
    freq.put("viv", 314);
    freq.put("Aut", 75);
    freq.put("vit", 883);
    freq.put("Uni", 139);
    freq.put("viz", 188);
    freq.put("S ", 725);
    freq.put(" s ", 246);
    freq.put("Tod", 25);
    freq.put("twa", 29);
    freq.put("twe", 273);
    freq.put("aso", 275);
    freq.put("twi", 514);
    freq.put("ved", 1433);
    freq.put("ov ", 82);
    freq.put(" d ", 583);
    freq.put("anc", 4147);
    freq.put("asm", 87);
    freq.put("VE ", 63);
    freq.put("avu", 81);
    freq.put("de ", 1864);
    freq.put("In ", 383);
    freq.put("vec", 472);
    freq.put("iz ", 44);
    freq.put("vi ", 1457);
    freq.put("Vic", 35);
    freq.put("uno", 1089);
    freq.put("Sp", 509);
    freq.put("Sv", 62);
    freq.put("Su", 358);
    freq.put("St", 1100);
    freq.put("Sk", 74);
    freq.put("Not", 151);
    freq.put("Si", 1105);
    freq.put("Sh", 114);
    freq.put("So", 897);
    freq.put("Sn", 27);
    freq.put("Sm", 63);
    freq.put("Sl", 36);
    freq.put("Sc", 453);
    freq.put("Sa", 1080);
    freq.put("Sf", 27);
    freq.put("Se", 1441);
    freq.put("á", 42);
    freq.put("ey ", 219);
    freq.put(" dm", 30);
    freq.put("vem", 153);
    freq.put(" di", 17827);
    freq.put("Int", 288);
    freq.put("bav", 24);
    freq.put("Inv", 53);
    freq.put("des", 783);
    freq.put("det", 690);
    freq.put(" da", 5489);
    freq.put("Ins", 61);
    freq.put("dei", 1119);
    freq.put("Inn", 24);
    freq.put("avo", 1519);
    freq.put("del", 5796);
    freq.put("Ini", 44);
    freq.put("den", 914);
    freq.put("v", 37748);
    freq.put("Ind", 75);
    freq.put("dea", 191);
    freq.put("Inf", 79);
    freq.put("Ing", 39);
    freq.put("ded", 136);
    freq.put(" dr", 112);
    freq.put("def", 126);
    freq.put("Inc", 59);
    freq.put("abb", 994);
    freq.put("P ", 324);
    freq.put("X ", 160);
    freq.put("RS ", 33);
    freq.put("go ", 889);
    freq.put("f ", 496);
    freq.put("hha", 169);
    freq.put("lal", 27);
    freq.put("Vil", 57);
    freq.put("é ", 978);
    freq.put("pai", 86);
    freq.put("hhh", 135);
    freq.put("Mos", 48);
    freq.put("iPa", 77);
    freq.put("Vis", 67);
    freq.put("zar", 311);
    freq.put("iPh", 226);
    freq.put("iPo", 33);
    freq.put("Yor", 29);
    freq.put("atu", 458);
    freq.put("iso", 778);
    freq.put("ats", 24);
    freq.put("Gli", 116);
    freq.put("fr", 1250);
    freq.put("ft", 109);
    freq.put("fu", 1020);
    freq.put("Dol", 33);
    freq.put("Dom", 230);
    freq.put("dua", 34);
    freq.put("Gle", 27);
    freq.put("rmo", 208);
    freq.put("fa", 7587);
    freq.put("fb", 67);
    freq.put("hh ", 106);
    freq.put("fd", 33);
    freq.put("fe", 2452);
    freq.put("ff", 1845);
    freq.put("Sì", 114);
    freq.put("fh", 33);
    freq.put("fi", 4947);
    freq.put("fj", 27);
    freq.put("fl", 201);
    freq.put("fo", 3587);
    freq.put("a", 253133);
    freq.put("Cir", 30);
    freq.put("ges", 110);
    freq.put("egr", 224);
    freq.put("cs ", 42);
    freq.put("egu", 447);
    freq.put(" dà", 33);
    freq.put("egi", 311);
    freq.put("egh", 82);
    freq.put("ego", 310);
    freq.put("egn", 655);
    freq.put("ari", 2297);
    freq.put("egl", 1129);
    freq.put("ega", 760);
    freq.put("CA ", 77);
    freq.put("egg", 1059);
    freq.put("ege", 29);
    freq.put("Civ", 28);
    freq.put("itn", 26);
    freq.put("ito", 2414);
    freq.put("itm", 24);
    freq.put("ith", 31);
    freq.put("iti", 1157);
    freq.put("y ", 1982);
    freq.put("Occ", 40);
    freq.put("ite", 724);
    freq.put("itc", 30);
    freq.put("ita", 2870);
    freq.put("ffo", 84);
    freq.put("ok ", 628);
    freq.put(" ò ", 53);
    freq.put(" sì", 306);
    freq.put("ity", 79);
    freq.put("fff", 33);
    freq.put("itt", 1734);
    freq.put("itu", 322);
    freq.put("itr", 140);
    freq.put("ve ", 1884);
    freq.put("ffa", 236);
    freq.put("ans", 227);
    freq.put(" On", 94);
    freq.put(" Ol", 77);
    freq.put(" Om", 28);
    freq.put("but", 159);
    freq.put(" Ok", 121);
    freq.put(" Oh", 81);
    freq.put(" Of", 127);
    freq.put(" Og", 327);
    freq.put(" Od", 115);
    freq.put(" Ob", 36);
    freq.put(" Oc", 56);
    freq.put("nto", 3809);
    freq.put("if ", 41);
    freq.put("tp ", 122);
    freq.put(" Ov", 46);
    freq.put(" Ot", 127);
    freq.put(" Or", 406);
    freq.put(" Os", 70);
    freq.put(" Op", 70);
    freq.put("ceg", 76);
    freq.put("Bat", 38);
    freq.put("ced", 214);
    freq.put("ym", 30);
    freq.put("yl", 98);
    freq.put("yo", 185);
    freq.put("yn", 92);
    freq.put("ya", 118);
    freq.put("bè ", 182);
    freq.put("yc", 23);
    freq.put("cel", 572);
    freq.put("ye", 119);
    freq.put("L", 5575);
    freq.put("it ", 504);
    freq.put("oka", 57);
    freq.put("Bag", 26);
    freq.put("cet", 255);
    freq.put("Bab", 34);
    freq.put("Era", 52);
    freq.put("cep", 32);
    freq.put("Ban", 81);
    freq.put("yp", 53);
    freq.put("ys", 76);
    freq.put("Ero", 28);
    freq.put("yu", 32);
    freq.put("cez", 30);
    freq.put("può", 309);
    freq.put("ff ", 128);
    freq.put("Raf", 24);
    freq.put("ifu", 25);
    freq.put("Rad", 56);
    freq.put("Rac", 38);
    freq.put("ifr", 35);
    freq.put("Ran", 25);
    freq.put("MI ", 143);
    freq.put("Tan", 82);
    freq.put("anf", 33);
    freq.put(" O ", 426);
    freq.put("pam", 44);
    freq.put("ife", 260);
    freq.put("iff", 282);
    freq.put("val", 481);
    freq.put("ifa", 84);
    freq.put("man", 3055);
    freq.put("ifl", 35);
    freq.put("pc ", 96);
    freq.put("ifo", 237);
    freq.put("ifi", 508);
    freq.put(" A ", 764);
    freq.put("dig", 160);
    freq.put("Mus", 96);
    freq.put("mq ", 285);
    freq.put("tre", 1455);
    freq.put(" sp", 2067);
    freq.put(" sq", 108);
    freq.put(" sv", 385);
    freq.put("ità", 1060);
    freq.put(" su", 4784);
    freq.put("Un ", 426);
    freq.put(" sk", 42);
    freq.put("Enr", 31);
    freq.put(" si", 5946);
    freq.put("Ent", 48);
    freq.put(" so", 7483);
    freq.put(" sl", 52);
    freq.put(" sm", 270);
    freq.put(" sb", 284);
    freq.put(" sc", 3385);
    freq.put("uda", 69);
    freq.put(" sa", 2996);
    freq.put(" sf", 356);
    freq.put(" sg", 60);
    freq.put(" sd", 30);
    freq.put(" se", 8554);
    freq.put("ftw", 29);
    freq.put("gur", 357);
    freq.put("izi", 1521);
    freq.put("E ", 3053);
    freq.put("tiv", 1133);
    freq.put("vab", 202);
    freq.put("Tag", 23);
    freq.put("Vuo", 24);
    freq.put("izz", 702);
    freq.put("pul", 118);
    freq.put(" Ab", 126);
    freq.put(" Ac", 119);
    freq.put(" Ad", 261);
    freq.put("Tab", 25);
    freq.put(" Af", 62);
    freq.put(" Ag", 204);
    freq.put(" Ah", 300);
    freq.put(" Ai", 60);
    freq.put("pug", 41);
    freq.put(" Al", 845);
    freq.put(" Am", 298);
    freq.put(" An", 813);
    freq.put("puc", 33);
    freq.put(" Ap", 396);
    freq.put(" Aq", 29);
    freq.put(" Ar", 378);
    freq.put(" As", 276);
    freq.put(" At", 112);
    freq.put(" Au", 176);
    freq.put(" Av", 184);
    freq.put(" Aw", 23);
    freq.put("put", 188);
    freq.put("st ", 700);
    freq.put(" Az", 53);
    freq.put("ash", 140);
    freq.put("mma", 873);
    freq.put("div", 703);
    freq.put("pur", 586);
    freq.put("Uno", 57);
    freq.put("Em", 91);
    freq.put("El", 140);
    freq.put("En", 150);
    freq.put("NG ", 48);
    freq.put("Eh", 72);
    freq.put("ion", 6004);
    freq.put("Ed", 130);
    freq.put("Ec", 244);
    freq.put("Spe", 226);
    freq.put("ft ", 58);
    freq.put("Ex", 37);
    freq.put("w", 3860);
    freq.put("HD ", 23);
    freq.put("Eu", 223);
    freq.put("Et", 38);
    freq.put("Mel", 43);
    freq.put("Ev", 78);
    freq.put("Ep", 24);
    freq.put("Es", 196);
    freq.put("Er", 129);
    freq.put("le ", 10752);
    freq.put("Fra", 201);
    freq.put("Clo", 31);
    freq.put("Cli", 46);
    freq.put("Fre", 52);
    freq.put("uel", 1664);
    freq.put("tov", 37);
    freq.put("Fri", 33);
    freq.put("Imm", 44);
    freq.put("Cla", 84);
    freq.put("Imp", 57);
    freq.put("uen", 112);
    freq.put("bul", 47);
    freq.put("Vor", 52);
    freq.put("osc", 589);
    freq.put("zi", 7155);
    freq.put(" el", 290);
    freq.put(" em", 237);
    freq.put(" en", 507);
    freq.put(" eh", 416);
    freq.put("aa ", 172);
    freq.put(" ed", 509);
    freq.put(" ee", 32);
    freq.put(" ef", 142);
    freq.put("Men", 91);
    freq.put(" eb", 34);
    freq.put(" ec", 546);
    freq.put("TL ", 25);
    freq.put(" ex", 103);
    freq.put("Res", 58);
    freq.put(" et", 118);
    freq.put(" eu", 287);
    freq.put(" ev", 280);
    freq.put(" ep", 109);
    freq.put(" eq", 31);
    freq.put(" er", 1067);
    freq.put(" es", 1974);
    freq.put("omu", 690);
    freq.put("ag ", 74);
    freq.put("stu", 625);
    freq.put("ncr", 111);
    freq.put("tom", 155);
    freq.put("ncu", 127);
    freq.put("odu", 106);
    freq.put("nch", 2624);
    freq.put("nci", 1062);
    freq.put("hè ", 767);
    freq.put("ncl", 57);
    freq.put("rra", 576);
    freq.put("lac", 187);
    freq.put("nco", 1369);
    freq.put("nca", 567);
    freq.put("nce", 924);
    freq.put("ste", 2018);
    freq.put("b", 23291);
    freq.put("aaa", 666);
    freq.put("sta", 6249);
    freq.put("ko ", 44);
    freq.put("sto", 3829);
    freq.put(" e ", 9316);
    freq.put("sti", 2701);
    freq.put("i", 238118);
    freq.put("htt", 136);
    freq.put("str", 2397);
    freq.put("osì", 743);
    freq.put("Gol", 30);
    freq.put("Goo", 148);
    freq.put("ka ", 57);
    freq.put("zz", 3950);
    freq.put("nò ", 43);
    freq.put("Goa", 26);
    freq.put("elo", 481);
    freq.put("ofo", 145);
    freq.put("AD ", 27);
    freq.put("oda", 201);
    freq.put("Gov", 46);
    freq.put("Gos", 33);
    freq.put("lid", 92);
    freq.put("Nik", 25);
    freq.put("lif", 52);
    freq.put("k ", 1633);
    freq.put("Nin", 25);
    freq.put("iù ", 1822);
    freq.put("ex ", 124);
    freq.put("lic", 1179);
    freq.put("Nic", 79);
    freq.put("lin", 1077);
    freq.put("Nia", 37);
    freq.put("Nie", 46);
    freq.put("lit", 1014);
    freq.put("efi", 150);
    freq.put("liv", 362);
    freq.put("mak", 26);
    freq.put("lip", 80);
    freq.put("lir", 92);
    freq.put("efo", 208);
    freq.put("arl", 1262);
    freq.put("cci", 1888);
    freq.put("efe", 294);
    freq.put("eff", 162);
    freq.put("cch", 1301);
    freq.put("bab", 158);
    freq.put("unz", 192);
    freq.put("oft", 55);
    freq.put("buf", 23);
    freq.put("ofu", 37);
    freq.put("M", 6708);
    freq.put("tig", 124);
    freq.put("kar", 23);
    freq.put("Att", 68);
    freq.put("utt", 3155);
    freq.put("spu", 93);
    freq.put("kay", 68);
    freq.put("dai", 457);
    freq.put("bac", 173);
    freq.put("kb", 24);
    freq.put("ka", 248);
    freq.put("kg", 28);
    freq.put("kf", 27);
    freq.put("ke", 687);
    freq.put("ND ", 23);
    freq.put("kk", 51);
    freq.put("kj", 32);
    freq.put("ki", 362);
    freq.put("ko", 142);
    freq.put("kn", 33);
    freq.put("km", 136);
    freq.put("kl", 36);
    freq.put("ks", 104);
    freq.put("kr", 34);
    freq.put("ext", 25);
    freq.put("ku", 62);
    freq.put("kt", 28);
    freq.put("ef ", 30);
    freq.put("ky", 123);
    freq.put("une", 370);
    freq.put("exy", 30);
    freq.put("Hah", 32);
    freq.put("Hai", 119);
    freq.put("ugi", 101);
    freq.put("sù ", 37);
    freq.put("Hal", 43);
    freq.put("ugn", 68);
    freq.put("Han", 46);
    freq.put("ugl", 99);
    freq.put("rto", 1076);
    freq.put("rti", 1655);
    freq.put("rth", 32);
    freq.put("ZA ", 75);
    freq.put("hi ", 1604);
    freq.put("rtp", 41);
    freq.put("rts", 30);
    freq.put("rtr", 91);
    freq.put("Har", 105);
    freq.put("èèè", 73);
    freq.put("rty", 35);
    freq.put("ugu", 243);
    freq.put("ati", 2605);
    freq.put("uai", 38);
    freq.put("Ju", 220);
    freq.put("ies", 514);
    freq.put("ier", 1362);
    freq.put("iet", 787);
    freq.put("iew", 31);
    freq.put("iev", 59);
    freq.put("iei", 281);
    freq.put("Ope", 35);
    freq.put("Mir", 32);
    freq.put("Jo", 274);
    freq.put("iem", 233);
    freq.put("iel", 256);
    freq.put("ien", 1642);
    freq.put("Je", 79);
    freq.put("iec", 76);
    freq.put("ieb", 87);
    freq.put("iee", 28);
    freq.put("ied", 434);
    freq.put("ieg", 201);
    freq.put("hip", 41);
    freq.put("hir", 29);
    freq.put("his", 175);
    freq.put("hit", 103);
    freq.put("hiu", 269);
    freq.put("ath", 54);
    freq.put("Ha ", 63);
    freq.put("ose", 605);
    freq.put("bug", 28);
    freq.put("hia", 1180);
    freq.put("hic", 45);
    freq.put("hie", 679);
    freq.put("hif", 122);
    freq.put("hig", 26);
    freq.put("hih", 29);
    freq.put("hil", 79);
    freq.put("him", 47);
    freq.put("hin", 311);
    freq.put("hio", 475);
    freq.put("rfa", 29);
    freq.put("cra", 111);
    freq.put("rfe", 148);
    freq.put("cre", 911);
    freq.put("x", 2067);
    freq.put("rfi", 26);
    freq.put("cri", 1208);
    freq.put("J ", 55);
    freq.put("cro", 239);
    freq.put(" Be", 960);
    freq.put("Ago", 43);
    freq.put("arr", 1203);
    freq.put("chè", 763);
    freq.put(" Ba", 650);
    freq.put("rtà", 46);
    freq.put("For", 260);
    freq.put("sep", 59);
    freq.put(" Bl", 205);
    freq.put(" Bo", 540);
    freq.put(" Bi", 294);
    freq.put("sez", 23);
    freq.put("sex", 33);
    freq.put(" Bu", 514);
    freq.put("ara", 1391);
    freq.put("see", 26);
    freq.put("ik ", 29);
    freq.put("sec", 471);
    freq.put("Rit", 36);
    freq.put(" Br", 380);
    freq.put("Fol", 37);
    freq.put("sen", 1816);
    freq.put("Fon", 34);
    freq.put("sel", 137);
    freq.put("rte", 1298);
    freq.put("uu ", 77);
    freq.put("sei", 893);
    freq.put("aro", 656);
    freq.put("ZO ", 77);
    freq.put("Vit", 64);
    freq.put("Nuo", 200);
    freq.put("uaz", 104);
    freq.put("leg", 812);
    freq.put("use", 170);
    freq.put("wor", 115);
    freq.put("chu", 26);
    freq.put("aci", 466);
    freq.put(" P ", 146);
    freq.put("oke", 53);
    freq.put("atr", 282);
    freq.put("Pla", 44);
    freq.put("tiz", 285);
    freq.put("uah", 69);
    freq.put("DD ", 90);
    freq.put("Age", 66);
    freq.put(" B ", 118);
    freq.put("vra", 165);
    freq.put("web", 130);
    freq.put("uuu", 96);
    freq.put("lel", 26);
    freq.put("be ", 950);
    freq.put("upp", 264);
    freq.put("Oba", 26);
    freq.put("ar ", 492);
    freq.put("ika", 24);
    freq.put("èè ", 27);
    freq.put("fgh", 29);
    freq.put("len", 685);
    freq.put("ike", 107);
    freq.put("se ", 4675);
    freq.put("iki", 63);
    freq.put("leo", 45);
    freq.put("Sem", 86);
    freq.put("TC ", 35);
    freq.put("Zay", 25);
    freq.put(" Ps", 26);
    freq.put(" Pr", 1015);
    freq.put("c", 97835);
    freq.put("Sel", 36);
    freq.put(" Pu", 236);
    freq.put("Far", 58);
    freq.put(" Pa", 1078);
    freq.put(" Pe", 1043);
    freq.put(" Pd", 62);
    freq.put(" Pi", 583);
    freq.put(" Ph", 58);
    freq.put(" Po", 726);
    freq.put(" Pl", 66);
    freq.put("Wal", 30);
    freq.put("sky", 29);
    freq.put("oqu", 23);
    freq.put("lex", 41);
    freq.put("rae", 38);
    freq.put("mh ", 36);
    freq.put("lbu", 149);
    freq.put("ady", 33);
    freq.put(" t ", 164);
    freq.put("pr", 9766);
    freq.put("ps", 188);
    freq.put("pp", 3476);
    freq.put("dul", 31);
    freq.put("dum", 25);
    freq.put("pt", 78);
    freq.put("pu", 2648);
    freq.put("ch ", 274);
    freq.put("dub", 85);
    freq.put("py", 36);
    freq.put("due", 516);
    freq.put("Agr", 23);
    freq.put("geo", 48);
    freq.put("pc", 107);
    freq.put("duz", 61);
    freq.put("pa", 7880);
    freq.put("HE ", 210);
    freq.put("nau", 59);
    freq.put("pd", 34);
    freq.put("pe", 15480);
    freq.put("ph", 208);
    freq.put("pi", 7570);
    freq.put("dut", 200);
    freq.put("po", 10600);
    freq.put("pl", 1191);
    freq.put("nri", 35);
    freq.put("Fal", 31);
    freq.put("gay", 50);
    freq.put(" € ", 236);
    freq.put(" tw", 721);
    freq.put(" tv", 122);
    freq.put(" tu", 4164);
    freq.put(" tt", 32);
    freq.put("Emi", 28);
    freq.put(" tr", 3153);
    freq.put("nre", 24);
    freq.put("N", 4165);
    freq.put(" to", 1127);
    freq.put("gan", 318);
    freq.put("gam", 173);
    freq.put("gal", 260);
    freq.put(" ti", 2623);
    freq.put(" th", 142);
    freq.put("gag", 35);
    freq.put(" te", 3135);
    freq.put("vs ", 33);
    freq.put("gab", 31);
    freq.put(" ta", 1643);
    freq.put("lba", 49);
    freq.put("fut", 119);
    freq.put("fur", 42);
    freq.put("fus", 67);
    freq.put("Oli", 26);
    freq.put("fug", 57);
    freq.put("p ", 971);
    freq.put("fuc", 32);
    freq.put("ù", 2451);
    freq.put("fuo", 275);
    freq.put("ful", 38);
    freq.put("fum", 120);
    freq.put("bor", 180);
    freq.put("sy ", 24);
    freq.put("riz", 186);
    freq.put("Il ", 1504);
    freq.put("moz", 124);
    freq.put("riv", 1506);
    freq.put("unq", 478);
    freq.put("rit", 1683);
    freq.put("riu", 202);
    freq.put("rir", 332);
    freq.put("ris", 1900);
    freq.put("rip", 394);
    freq.put("rin", 1056);
    freq.put("rio", 1353);
    freq.put("ril", 265);
    freq.put("rim", 1869);
    freq.put("vor", 991);
    freq.put("vos", 208);
    freq.put("rif", 331);
    freq.put("rig", 470);
    freq.put("rid", 439);
    freq.put("rie", 1111);
    freq.put("rib", 224);
    freq.put("ric", 1878);
    freq.put("ria", 1742);
    freq.put("pò", 128);
    freq.put("ng ", 737);
    freq.put("tir", 511);
    freq.put("To ", 25);
    freq.put("bs ", 100);
    freq.put(" çw", 62);
    freq.put("ceb", 303);
    freq.put(" f ", 33);
    freq.put("pà", 65);
    freq.put("aha", 2950);
    freq.put("ews", 289);
    freq.put("ohn", 32);
    freq.put("Cop", 44);
    freq.put("Cos", 262);
    freq.put("Cor", 237);
    freq.put("vo ", 3164);
    freq.put("tis", 468);
    freq.put("dge", 45);
    freq.put("ban", 303);
    freq.put("cea", 27);
    freq.put("Coc", 24);
    freq.put("lig", 199);
    freq.put("uto", 1194);
    freq.put("FA ", 30);
    freq.put("Com", 657);
    freq.put("Col", 158);
    freq.put("Coo", 28);
    freq.put("Con", 634);
    freq.put("WS ", 28);
    freq.put("Soc", 69);
    freq.put(" fr", 854);
    freq.put(" fu", 847);
    freq.put("lib", 470);
    freq.put("Sog", 26);
    freq.put("Sof", 30);
    freq.put("ew ", 141);
    freq.put("Sol", 177);
    freq.put("Son", 418);
    freq.put(" fa", 6683);
    freq.put("EI ", 70);
    freq.put("ppe", 625);
    freq.put(" fb", 56);
    freq.put(" fe", 801);
    freq.put("Sot", 26);
    freq.put("lim", 338);
    freq.put("y", 3098);
    freq.put("moo", 42);
    freq.put(" fl", 73);
    freq.put(" fo", 2244);
    freq.put("tim", 1132);
    freq.put("lda", 89);
    freq.put("lio", 2101);
    freq.put("lde", 56);
    freq.put("ceo", 30);
    freq.put("ldi", 166);
    freq.put("osf", 24);
    freq.put("Di ", 175);
    freq.put("ufo", 25);
    freq.put("O ", 2435);
    freq.put("çç", 174);
    freq.put("amp", 656);
    freq.put("lik", 64);
    freq.put("oo ", 282);
    freq.put("cut", 62);
    freq.put("cus", 337);
    freq.put("cur", 494);
    freq.put("cup", 263);
    freq.put("amu", 28);
    freq.put("Tg ", 23);
    freq.put("cug", 46);
    freq.put("rga", 203);
    freq.put("cud", 27);
    freq.put("cuc", 114);
    freq.put("cub", 34);
    freq.put("aps", 27);
    freq.put("cuo", 505);
    freq.put("cun", 460);
    freq.put("cum", 67);
    freq.put("cul", 373);
    freq.put("rgl", 81);
    freq.put("ee ", 366);
    freq.put("cui", 280);
    freq.put("rgo", 227);
    freq.put("bin", 266);
    freq.put("On", 103);
    freq.put("Om", 31);
    freq.put("Ol", 77);
    freq.put("Ok", 125);
    freq.put("Oh", 81);
    freq.put("Og", 333);
    freq.put("Of", 129);
    freq.put("Dif", 30);
    freq.put("Od", 116);
    freq.put("bè", 189);
    freq.put("Ob", 37);
    freq.put("uot", 208);
    freq.put("Dic", 72);
    freq.put("biz", 39);
    freq.put("mia", 1297);
    freq.put("efa", 93);
    freq.put("Ov", 47);
    freq.put("Div", 45);
    freq.put("Ot", 127);
    freq.put("gr", 2715);
    freq.put("Or", 408);
    freq.put("Dir", 92);
    freq.put("Op", 70);
    freq.put("d", 70926);
    freq.put("cc ", 74);
    freq.put("eet", 357);
    freq.put("ppi", 386);
    freq.put("Pio", 53);
    freq.put("eer", 29);
    freq.put("rg ", 34);
    freq.put("eel", 23);
    freq.put("ak ", 47);
    freq.put("een", 157);
    freq.put("ate", 2427);
    freq.put("eeh", 27);
    freq.put("eek", 81);
    freq.put("eee", 548);
    freq.put("eed", 60);
    freq.put("apo", 459);
    freq.put("çw", 62);
    freq.put("b ", 494);
    freq.put("ru ", 26);
    freq.put("tà ", 1493);
    freq.put("ld ", 98);
    freq.put("ovr", 452);
    freq.put("cif", 42);
    freq.put("soc", 274);
    freq.put("zz ", 108);
    freq.put("bg ", 26);
    freq.put(" Qu", 1061);
    freq.put("pez", 160);
    freq.put("pet", 890);
    freq.put("pev", 132);
    freq.put("per", 10531);
    freq.put("pes", 383);
    freq.put("pel", 305);
    freq.put("pen", 1848);
    freq.put("peo", 30);
    freq.put("pei", 28);
    freq.put("aki", 32);
    freq.put("ped", 178);
    freq.put("peg", 272);
    freq.put("pea", 67);
    freq.put("id ", 156);
    freq.put("pec", 289);
    freq.put("vve", 445);
    freq.put("be", 4732);
    freq.put("bg", 32);
    freq.put("run", 70);
    freq.put("ba", 3109);
    freq.put("bb", 2790);
    freq.put("bc", 24);
    freq.put("bl", 1371);
    freq.put("ruc", 135);
    freq.put("Bor", 104);
    freq.put("bo", 1567);
    freq.put("bh", 60);
    freq.put("bi", 4284);
    freq.put("O", 2815);
    freq.put("oet", 28);
    freq.put("Boh", 30);
    freq.put("bu", 1470);
    freq.put("tid", 139);
    freq.put("Bol", 104);
    freq.put("br", 2665);
    freq.put("bs", 129);
    freq.put("rus", 112);
    freq.put("rup", 115);
    freq.put("by", 143);
    freq.put("rut", 321);
    freq.put("che", 13328);
    freq.put("Pis", 46);
    freq.put("Rom", 387);
    freq.put("Rob", 75);
    freq.put("idu", 103);
    freq.put("cad", 250);
    freq.put(" Q ", 27);
    freq.put("ido", 338);
    freq.put("yle", 34);
    freq.put("idi", 541);
    freq.put("DE ", 39);
    freq.put("ylo", 24);
    freq.put("ide", 1819);
    freq.put("pe ", 309);
    freq.put("ida", 556);
    freq.put("ppl", 285);
    freq.put("nsi", 988);
    freq.put("wn ", 39);
    freq.put("Eli", 36);
    freq.put("bui", 49);
    freq.put("ME ", 87);
    freq.put("sfa", 88);
    freq.put("nso", 604);
    freq.put(" ut", 159);
    freq.put(" uu", 171);
    freq.put(" C ", 331);
    freq.put(" up", 52);
    freq.put("nse", 307);
    freq.put(" ur", 125);
    freq.put("Ele", 57);
    freq.put(" ul", 332);
    freq.put(" um", 126);
    freq.put(" un", 10067);
    freq.put(" uo", 204);
    freq.put(" uh", 57);
    freq.put("url", 92);
    freq.put(" uf", 206);
    freq.put(" ug", 73);
    freq.put("nst", 112);
    freq.put("nsu", 180);
    freq.put(" ub", 32);
    freq.put(" uc", 131);
    freq.put("ut ", 88);
    freq.put("ci ", 3603);
    freq.put("Nob", 67);
    freq.put("usu", 42);
    freq.put("ust", 639);
    freq.put("ada", 371);
    freq.put("̸", 24);
    freq.put("u ", 4032);
    freq.put(" R ", 53);
    freq.put(" Ch", 976);
    freq.put(" Ci", 766);
    freq.put(" Co", 2111);
    freq.put(" Cl", 176);
    freq.put(" Cm", 41);
    freq.put("ns ", 202);
    freq.put("uT", 40);
    freq.put(" Ca", 1495);
    freq.put("ffè", 77);
    freq.put("wnl", 31);
    freq.put(" Ce", 378);
    freq.put("uic", 38);
    freq.put("Flo", 26);
    freq.put("zio", 3951);
    freq.put(" Cr", 328);
    freq.put("li ", 5337);
    freq.put(" u ", 804);
    freq.put("ul ", 712);
    freq.put(" Cu", 123);
    freq.put("cic", 139);
    freq.put("cib", 42);
    freq.put("cia", 2929);
    freq.put("uta", 583);
    freq.put("ux", 50);
    freq.put("cie", 256);
    freq.put("uz", 399);
    freq.put("uu", 323);
    freq.put("ut", 6392);
    freq.put("ix ", 69);
    freq.put("uv", 270);
    freq.put("cio", 1686);
    freq.put("up", 1247);
    freq.put("us", 3543);
    freq.put("ur", 4499);
    freq.put("um", 1375);
    freq.put("ul", 3203);
    freq.put("uo", 5733);
    freq.put("un", 14270);
    freq.put("ui", 3056);
    freq.put("uh", 129);
    freq.put("uk", 70);
    freq.put("cit", 879);
    freq.put("ue", 5556);
    freq.put("ud", 1109);
    freq.put("ug", 755);
    freq.put("z", 18465);
    freq.put("ua", 6200);
    freq.put("uc", 1451);
    freq.put("ub", 1164);
    freq.put(" uù", 123);
    freq.put("tib", 44);
    freq.put("Tv", 38);
    freq.put("Tw", 291);
    freq.put("Tu", 440);
    freq.put("Tr", 657);
    freq.put("Beh", 39);
    freq.put("cer", 1570);
    freq.put("To", 489);
    freq.put("SO ", 75);
    freq.put("sul", 1472);
    freq.put("Th", 178);
    freq.put("Ti", 395);
    freq.put("Tg", 26);
    freq.put("Te", 579);
    freq.put("Ta", 291);
    freq.put("A ", 2991);
    freq.put("Mas", 87);
    freq.put("gru", 102);
    freq.put(" gr", 1703);
    freq.put("nag", 133);
    freq.put("nad", 46);
    freq.put("nai", 78);
    freq.put("nan", 588);
    freq.put("nal", 1307);
    freq.put("nam", 309);
    freq.put("nar", 711);
    freq.put(" gg", 26);
    freq.put("nap", 56);
    freq.put("gre", 235);
    freq.put("nav", 103);
    freq.put("Mad", 96);
    freq.put("nat", 1606);
    freq.put("gra", 2049);
    freq.put(" gn", 41);
    freq.put(" go", 447);
    freq.put(" gl", 1205);
    freq.put("ark", 158);
    freq.put("Mam", 54);
    freq.put("Mal", 87);
    freq.put(" gh", 50);
    freq.put(" gi", 3354);
    freq.put("oon", 52);
    freq.put("pau", 185);
    freq.put("Meg", 45);
    freq.put("ac ", 85);
    freq.put("ly ", 177);
    freq.put("tua", 631);
    freq.put("lpe", 30);
    freq.put("T ", 982);
    freq.put("ago", 351);
    freq.put("svo", 34);
    freq.put("Ac", 121);
    freq.put("Ab", 128);
    freq.put("e", 235564);
    freq.put("Ad", 268);
    freq.put("Ag", 204);
    freq.put("Af", 66);
    freq.put("Ai", 62);
    freq.put("Ah", 301);
    freq.put("age", 300);
    freq.put("sve", 271);
    freq.put("Am", 301);
    freq.put("Al", 848);
    freq.put("aga", 1122);
    freq.put("An", 821);
    freq.put("Aq", 29);
    freq.put("Ap", 406);
    freq.put("As", 282);
    freq.put("Ar", 385);
    freq.put("Au", 180);
    freq.put("At", 113);
    freq.put("Aw", 25);
    freq.put("Av", 185);
    freq.put("tub", 77);
    freq.put("uis", 261);
    freq.put("Az", 57);
    freq.put("agr", 122);
    freq.put("ùù ", 38);
    freq.put(" b", 8248);
    freq.put(" c", 41140);
    freq.put("Giu", 129);
    freq.put(" a", 35428);
    freq.put(" f", 14420);
    freq.put(" g", 9074);
    freq.put(" d", 38243);
    freq.put(" e", 16169);
    freq.put(" j", 236);
    freq.put(" k", 442);
    freq.put(" h", 6857);
    freq.put(" i", 27372);
    freq.put(" n", 17296);
    freq.put(" o", 8282);
    freq.put(" l", 22512);
    freq.put(" m", 25539);
    freq.put(" r", 8875);
    freq.put(" s", 43795);
    freq.put(" p", 33539);
    freq.put(" q", 7301);
    freq.put(" v", 13985);
    freq.put("gb", 31);
    freq.put(" t", 17123);
    freq.put(" u", 13696);
    freq.put(" z", 375);
    freq.put("gn", 2922);
    freq.put(" x", 1254);
    freq.put(" y", 234);
    freq.put("ass", 2175);
    freq.put("gi", 9366);
    freq.put("gh", 769);
    freq.put(" B", 4177);
    freq.put(" C", 7904);
    freq.put("Non", 1024);
    freq.put(" A", 6865);
    freq.put(" F", 3266);
    freq.put(" G", 3590);
    freq.put(" D", 6204);
    freq.put(" E", 3196);
    freq.put(" J", 883);
    freq.put(" K", 488);
    freq.put(" H", 1908);
    freq.put(" I", 5980);
    freq.put(" N", 4042);
    freq.put(" O", 2712);
    freq.put(" L", 5480);
    freq.put(" M", 6600);
    freq.put(" R", 3417);
    freq.put(" S", 8831);
    freq.put(" P", 6208);
    freq.put(" Q", 1246);
    freq.put(" V", 2707);
    freq.put(" W", 742);
    freq.put(" T", 4290);
    freq.put(" U", 1918);
    freq.put(" Z", 236);
    freq.put(" X", 913);
    freq.put(" Y", 298);
    freq.put("vot", 197);
    freq.put("Nor", 61);
    freq.put("Azi", 30);
    freq.put("ed ", 739);
    freq.put("caz", 855);
    freq.put("ugg", 94);
    freq.put("Ter", 120);
    freq.put("P", 6645);
    freq.put("tue", 68);
    freq.put(" Wh", 26);
    freq.put("g ", 1304);
    freq.put("OI ", 45);
    freq.put("tri", 1362);
    freq.put("evi", 681);
    freq.put("tro", 3528);
    freq.put("evo", 1383);
    freq.put("tra", 3348);
    freq.put("eva", 699);
    freq.put("us ", 318);
    freq.put("No ", 288);
    freq.put("eve", 673);
    freq.put("Spi", 47);
    freq.put("?", 36);
    freq.put("asp", 501);
    freq.put("Spo", 90);
    freq.put("rdì", 78);
    freq.put("ddd", 28);
    freq.put("tru", 309);
    freq.put("evu", 51);
    freq.put("rro", 319);
    freq.put("ody", 30);
    freq.put("too", 63);
    freq.put("zo", 1968);
    freq.put("uei", 83);
    freq.put(" ç", 718);
    freq.put("rri", 1163);
    freq.put("Blu", 37);
    freq.put("ze", 868);
    freq.put(" è", 7505);
    freq.put(" é", 227);
    freq.put("za", 3925);
    freq.put("edì", 249);
    freq.put("cav", 219);
    freq.put(" ò", 94);
    freq.put("odi", 503);
    freq.put("Blo", 90);
    freq.put("Nov", 117);
    freq.put("cau", 67);
    freq.put("go", 2421);
    freq.put("Già", 45);
    freq.put("zu", 127);
    freq.put("rru", 51);
    freq.put(" ù", 261);
    freq.put("Bla", 71);
    freq.put("rrr", 118);
    freq.put("ues", 2005);
    freq.put("uer", 98);
    freq.put("F ", 173);
    freq.put("Ah ", 128);
    freq.put("zi ", 692);
    freq.put(" È", 209);
    freq.put("fat", 1454);
    freq.put("Oro", 30);
    freq.put("Orm", 28);
    freq.put("ct ", 38);
    freq.put("rd ", 205);
    freq.put("Ori", 23);
    freq.put("Ore", 47);
    freq.put("Ora", 210);
    freq.put("lea", 251);
    freq.put("leb", 35);
    freq.put("lec", 87);
    freq.put("led", 139);
    freq.put("lee", 69);
    freq.put("lef", 219);
    freq.put("obe", 99);
    freq.put("meg", 393);
    freq.put("lei", 267);
    freq.put("ulm", 34);
    freq.put("z ", 374);
    freq.put("ock", 97);
    freq.put(" €", 243);
    freq.put("ozi", 196);
    freq.put("asu", 29);
    freq.put("cac", 149);
    freq.put("ler", 466);
    freq.put("les", 496);
    freq.put("let", 1061);
    freq.put("lev", 310);
    freq.put("od ", 127);
    freq.put("ley", 104);
    freq.put("lez", 237);
    freq.put("ozz", 103);
    freq.put("rdu", 26);
    freq.put("eni", 900);
    freq.put("Aha", 149);
    freq.put("oe ", 106);
    freq.put("rds", 27);
    freq.put("cno", 47);
    freq.put("ast", 1346);
    freq.put("ciz", 66);
    freq.put("rde", 376);
    freq.put("rda", 1031);
    freq.put("wl", 23);
    freq.put("rdo", 680);
    freq.put("cto", 39);
    freq.put("rdi", 679);
    freq.put("cti", 125);
    freq.put(" Do", 663);
    freq.put("wif", 31);
    freq.put("aNo", 69);
    freq.put("Ver", 135);
    freq.put(" Di", 807);
    freq.put("apr", 244);
    freq.put("win", 51);
    freq.put(" De", 604);
    freq.put("sgu", 38);
    freq.put(" Da", 703);
    freq.put("IA ", 244);
    freq.put("Ved", 74);
    freq.put("wit", 761);
    freq.put("ii ", 200);
    freq.put("OS ", 90);
    freq.put("Ven", 250);
    freq.put(" Du", 123);
    freq.put("apa", 185);
    freq.put(" Dr", 82);
    freq.put("Mil", 384);
    freq.put("cha", 175);
    freq.put("Fr", 320);
    freq.put("feb", 40);
    freq.put("Fu", 113);
    freq.put("usa", 666);
    freq.put("fen", 102);
    freq.put("chi", 4284);
    freq.put("fel", 167);
    freq.put("fem", 40);
    freq.put("Li ", 24);
    freq.put("usi", 519);
    freq.put("cho", 66);
    freq.put("The", 133);
    freq.put("Fa", 706);
    freq.put("fet", 330);
    freq.put("zie", 1091);
    freq.put("fer", 1108);
    freq.put("Fe", 371);
    freq.put("zia", 1120);
    freq.put("zin", 125);
    freq.put("Fi", 576);
    freq.put("Fl", 92);
    freq.put("spr", 162);
    freq.put("Fo", 481);
    freq.put("acc", 2932);
    freq.put("Gua", 129);
    freq.put("Gue", 23);
    freq.put("dà ", 36);
    freq.put("Gui", 48);
    freq.put("aca", 286);
    freq.put(" D ", 1278);
    freq.put("ap ", 53);
    freq.put("iii", 332);
    freq.put("Me ", 44);
    freq.put(" Ru", 98);
    freq.put("ace", 1555);
    freq.put("fe ", 69);
    freq.put("f", 23946);
    freq.put("arò", 206);
    freq.put("ox ", 80);
    freq.put("km ", 114);
    freq.put(" Ry", 23);
    freq.put("Ja", 142);
    freq.put(" Re", 710);
    freq.put("nda", 1904);
    freq.put(" Ra", 384);
    freq.put(" ç ", 331);
    freq.put("enn", 381);
    freq.put(" Ro", 715);
    freq.put(" Ri", 595);
    freq.put("oe", 253);
    freq.put("tat", 2525);
    freq.put("wç", 62);
    freq.put("tav", 386);
    freq.put("ach", 128);
    freq.put("tap", 67);
    freq.put("tar", 2061);
    freq.put("tas", 675);
    freq.put("Sca", 84);
    freq.put("ró ", 42);
    freq.put("taz", 309);
    freq.put("tad", 116);
    freq.put("taf", 58);
    freq.put("tag", 546);
    freq.put("taa", 38);
    freq.put("tab", 149);
    freq.put("tac", 357);
    freq.put("tal", 2028);
    freq.put("tam", 792);
    freq.put("tan", 2607);
    freq.put("cni", 73);
    freq.put("rt ", 297);
    freq.put(" va", 1977);
    freq.put("sir", 30);
    freq.put("sip", 48);
    freq.put(" ve", 3684);
    freq.put(" W ", 40);
    freq.put("Yo", 141);
    freq.put("sit", 649);
    freq.put("Ya", 31);
    freq.put("ché", 655);
    freq.put("aff", 518);
    freq.put("Ye", 40);
    freq.put("afa", 36);
    freq.put(" vo", 2999);
    freq.put("spe", 1596);
    freq.put("sic", 801);
    freq.put(" çç", 165);
    freq.put(" vs", 34);
    freq.put("dwa", 25);
    freq.put(" vu", 550);
    freq.put("sif", 52);
    freq.put("sie", 479);
    freq.put("sid", 285);
    freq.put("sii", 51);
    freq.put("sio", 1116);
    freq.put("sin", 667);
    freq.put("sim", 1459);
    freq.put("sil", 177);
    freq.put("sis", 506);
    freq.put("acu", 46);
    freq.put("vut", 184);
    freq.put("act", 37);
    freq.put("HI ", 30);
    freq.put("Scu", 74);
    freq.put("afo", 104);
    freq.put("ta ", 11257);
    freq.put("mi ", 5859);
    freq.put("agh", 100);
    freq.put("von", 179);
    freq.put("ahh", 205);
    freq.put("siv", 123);
    freq.put(" v ", 130);
    freq.put("pag", 664);
    freq.put("lai", 63);
    freq.put("Y ", 211);
    freq.put("tos", 233);
    freq.put("One", 48);
    freq.put(" vi", 4530);
    freq.put("bun", 49);
    freq.put("si ", 5908);
    freq.put("siz", 93);
    freq.put("ovo", 858);
    freq.put("Io ", 499);
    freq.put("asc", 1014);
    freq.put("VI ", 51);
    freq.put("da ", 4459);
    freq.put("ens", 1516);
    freq.put("usc", 765);
    freq.put("own", 76);
    freq.put("X", 926);
    freq.put("lf", 124);
    freq.put("lg", 198);
    freq.put("ld", 629);
    freq.put("le", 16794);
    freq.put("lb", 327);
    freq.put("lc", 1662);
    freq.put("la", 20636);
    freq.put("ln", 25);
    freq.put("lo", 11849);
    freq.put("ll", 16587);
    freq.put("lm", 1224);
    freq.put("lk", 72);
    freq.put("li", 17495);
    freq.put("lv", 495);
    freq.put("lt", 4513);
    freq.put("lu", 2448);
    freq.put("lr", 49);
    freq.put("ls", 263);
    freq.put("lp", 352);
    freq.put("asa", 645);
    freq.put("eut", 46);
    freq.put(" h ", 131);
    freq.put("lz", 184);
    freq.put("ly", 234);
    freq.put("dad", 25);
    freq.put("Caz", 54);
    freq.put("daf", 97);
    freq.put("dag", 186);
    freq.put("RA ", 152);
    freq.put("dac", 90);
    freq.put("Cas", 255);
    freq.put("Car", 264);
    freq.put("dan", 554);
    freq.put(" hP", 24);
    freq.put("Cav", 68);
    freq.put("Cat", 85);
    freq.put("dat", 942);
    freq.put("dav", 513);
    freq.put("Can", 131);
    freq.put("Cam", 174);
    freq.put("Cal", 209);
    freq.put("Cac", 25);
    freq.put("bar", 299);
    freq.put("Cag", 40);
    freq.put("Caf", 30);
    freq.put("daz", 40);
    freq.put("bas", 560);
    freq.put("Pre", 361);
    freq.put("nfe", 217);
    freq.put("Pra", 51);
    freq.put("San", 273);
    freq.put("ç", 997);
    freq.put("Sal", 196);
    freq.put("nfo", 314);
    freq.put("Sab", 66);
    freq.put("Pro", 402);
    freq.put("nfl", 38);
    freq.put("Pri", 205);
    freq.put("eu ", 27);
    freq.put(" hu", 27);
    freq.put(" ht", 158);
    freq.put("Riv", 34);
    freq.put(" hi", 39);
    freq.put("FB ", 37);
    freq.put(" ho", 2688);
    freq.put("nfr", 76);
    freq.put("Sas", 26);
    freq.put("Sar", 213);
    freq.put(" ha", 3664);
    freq.put("Sap", 38);
    freq.put("Sav", 32);
    freq.put(" he", 65);
    freq.put("Sat", 23);
    freq.put("lie", 706);
    freq.put("oui", 51);
    freq.put("ttà", 123);
    freq.put("lfa", 35);
    freq.put("oun", 154);
    freq.put("oul", 25);
    freq.put("ouc", 41);
    freq.put("met", 1203);
    freq.put("seq", 23);
    freq.put("oud", 36);
    freq.put("Dio", 97);
    freq.put("ous", 53);
    freq.put("our", 177);
    freq.put("ogn", 1041);
    freq.put("oup", 33);
    freq.put("pra", 587);
    freq.put("rez", 292);
    freq.put("PA ", 38);
    freq.put("Mia", 57);
    freq.put("là", 79);
    freq.put("tph", 39);
    freq.put("rer", 240);
    freq.put("res", 2524);
    freq.put("lì", 134);
    freq.put("req", 37);
    freq.put("rev", 273);
    freq.put("ret", 979);
    freq.put("puz", 40);
    freq.put("rei", 938);
    freq.put("ren", 1655);
    freq.put("reo", 178);
    freq.put("rel", 365);
    freq.put("rem", 676);
    freq.put("reb", 835);
    freq.put("rec", 597);
    freq.put("cwc", 41);
    freq.put("rea", 825);
    freq.put("ref", 324);
    freq.put("reg", 708);
    freq.put("red", 888);
    freq.put("ree", 201);
    freq.put("dm ", 23);
    freq.put("ece", 535);
    freq.put("ky ", 66);
    freq.put("ecc", 1036);
    freq.put("lf ", 25);
    freq.put("eca", 177);
    freq.put("CE ", 71);
    freq.put("eco", 719);
    freq.put("ecn", 121);
    freq.put("ecl", 29);
    freq.put("eck", 27);
    freq.put("mir", 220);
    freq.put("eci", 745);
    freq.put("ech", 81);
    freq.put("qua", 3334);
    freq.put("Ghe", 62);
    freq.put("ecu", 102);
    freq.put("ect", 113);
    freq.put("que", 4033);
    freq.put("ecr", 42);
    freq.put("ie ", 2043);
    freq.put("qui", 1125);
    freq.put("quo", 92);
    freq.put("cè ", 24);
    freq.put("Q", 1261);
    freq.put("bam", 183);
    freq.put("lod", 44);
    freq.put("g", 38389);
    freq.put("vam", 197);
    freq.put("ask", 34);
    freq.put("Te ", 43);
    freq.put("lta", 1078);
    freq.put("lte", 487);
    freq.put("vac", 196);
    freq.put("Tu ", 82);
    freq.put("lia", 2862);
    freq.put("Ess", 33);
    freq.put("ìì", 53);
    freq.put("lto", 785);
    freq.put("aor", 26);
    freq.put("Fot", 67);
    freq.put("K ", 118);
    freq.put(" é ", 202);
    freq.put("uli", 193);
    freq.put("vaf", 35);
    freq.put("rs ", 244);
    freq.put("IT ", 39);
    freq.put("mai", 1030);
    freq.put("ud ", 86);
    freq.put("ihi", 30);
    freq.put("TO ", 370);
    freq.put("lol", 185);
    freq.put("ses", 173);
    freq.put("og ", 200);
    freq.put("ser", 2399);
    freq.put("lor", 1175);
    freq.put("ao ", 395);

    init3();
  }
  private static void init3() {
    
    freq.put("Gia", 134);
    freq.put("los", 258);
    freq.put("asi", 661);
    freq.put(" Sp", 487);
    freq.put(" Sv", 61);
    freq.put(" St", 1070);
    freq.put(" Su", 350);
    freq.put("UN ", 67);
    freq.put(" Sk", 72);
    freq.put(" Sh", 107);
    freq.put(" Si", 1094);
    freq.put(" Sn", 27);
    freq.put(" So", 892);
    freq.put(" Sl", 36);
    freq.put(" Sm", 61);
    freq.put(" Sc", 442);
    freq.put(" Sa", 1070);
    freq.put(" Sf", 26);
    freq.put("nut", 578);
    freq.put("mer", 1462);
    freq.put(" Se", 1432);
    freq.put("Ka", 114);
    freq.put("rso", 1181);
    freq.put("rsi", 790);
    freq.put("Ke", 53);
    freq.put("ogu", 23);
    freq.put("rse", 495);
    freq.put("Ki", 73);
    freq.put("lou", 56);
    freq.put("Ko", 39);
    freq.put("rsa", 379);
    freq.put("ogr", 340);
    freq.put("Kr", 24);
    freq.put("ogo", 124);
    freq.put("R", 3477);
    freq.put("ogi", 269);
    freq.put("ogh", 40);
    freq.put("Ku", 30);
    freq.put("vas", 126);
    freq.put("rst", 36);
    freq.put("ogg", 1033);
    freq.put("udi", 586);
    freq.put("oga", 161);
    freq.put("udo", 93);
    freq.put("seg", 832);
    freq.put("uhm", 27);
    freq.put("bei", 26);
    freq.put("ben", 1121);
    freq.put("bel", 1353);
    freq.put("bec", 51);
    freq.put("bea", 42);
    freq.put("nul", 216);
    freq.put("rca", 691);
    freq.put("AL ", 89);
    freq.put("sed", 110);
    freq.put("ber", 746);
    freq.put("bes", 70);
    freq.put(" S ", 224);
    freq.put("bev", 45);
    freq.put("bet", 60);
    freq.put("are", 7839);
    freq.put("Pap", 51);
    freq.put("Par", 366);
    freq.put("Edi", 43);
    freq.put("Pat", 47);
    freq.put("Pau", 28);
    freq.put("nqu", 740);
    freq.put("arg", 227);
    freq.put(" E ", 1270);
    freq.put("seo", 42);
    freq.put("Pad", 139);
    freq.put("Pae", 49);
    freq.put("Pag", 39);
    freq.put("py ", 23);
    freq.put("Pal", 149);
    freq.put("sem", 1400);
    freq.put("Pan", 70);
    freq.put("eal", 314);
    freq.put("bib", 31);
    freq.put("sk", 154);
    freq.put("MO ", 101);
    freq.put("ur ", 182);
    freq.put("ck ", 344);
    freq.put("mio", 1102);
    freq.put("min", 1475);
    freq.put("ona", 2181);
    freq.put("Sì ", 109);
    freq.put("mic", 931);
    freq.put("mie", 540);
    freq.put("mid", 112);
    freq.put("mig", 472);
    freq.put("arm", 718);
    freq.put("als", 129);
    freq.put("bur", 67);
    freq.put("arn", 98);
    freq.put(" Sì", 112);
    freq.put("bus", 118);
    freq.put("ER ", 177);
    freq.put("mis", 362);
    freq.put(" è ", 7442);
    freq.put("eac", 34);
    freq.put("bic", 87);
    freq.put(" El", 139);
    freq.put(" Em", 89);
    freq.put(" En", 137);
    freq.put(" Eh", 72);
    freq.put(" Ed", 128);
    freq.put("sfr", 35);
    freq.put(" Ec", 241);
    freq.put("Pa ", 31);
    freq.put("sfo", 169);
    freq.put("ute", 326);
    freq.put(" Ex", 35);
    freq.put("Dev", 110);
    freq.put("sfi", 168);
    freq.put(" Et", 36);
    freq.put(" Eu", 220);
    freq.put(" Ev", 77);
    freq.put("sfe", 66);
    freq.put(" Ep", 24);
    freq.put("ny ", 84);
    freq.put(" Er", 127);
    freq.put(" Es", 192);
    freq.put("cke", 57);
    freq.put("ure", 745);
    freq.put("urg", 63);
    freq.put("òò", 33);
    freq.put("ì ", 1707);
    freq.put("urc", 47);
    freq.put("Pov", 26);
    freq.put("lpa", 150);
    freq.put("Pot", 88);
    freq.put("xD ", 236);
    freq.put("Por", 118);
    freq.put("Pos", 117);
    freq.put("ç ", 450);
    freq.put("ghi", 331);
    freq.put("Pon", 34);
    freq.put("Pol", 107);
    freq.put("eaz", 38);
    freq.put("cks", 30);
    freq.put("Poi", 87);
    freq.put("Del", 135);
    freq.put("Pod", 35);
    freq.put("Poc", 29);
    freq.put("Dem", 51);
    freq.put("aba", 231);
    freq.put("Den", 41);
    freq.put("Cha", 93);
    freq.put(" iP", 326);
    freq.put("NI ", 120);
    freq.put("bum", 150);
    freq.put("uet", 50);
    freq.put("ppo", 1102);
    freq.put(" iO", 57);
    freq.put("zzo", 1168);
    freq.put("Che", 506);
    freq.put("eda", 160);
    freq.put("nge", 504);
    freq.put("ear", 144);
    freq.put("nga", 215);
    freq.put(" w ", 143);
    freq.put("co ", 3966);
    freq.put(" ip", 120);
    freq.put("Mor", 115);
    freq.put(" ir", 80);
    freq.put(" is", 293);
    freq.put(" it", 833);
    freq.put("ngi", 653);
    freq.put("eat", 306);
    freq.put("sh ", 105);
    freq.put("q ", 327);
    freq.put(" il", 7576);
    freq.put(" im", 1188);
    freq.put(" in", 10203);
    freq.put(" io", 2423);
    freq.put("Mob", 25);
    freq.put(" ic", 177);
    freq.put(" id", 408);
    freq.put(" ie", 272);
    freq.put(" ig", 55);
    freq.put("vrò", 61);
    freq.put("oto", 1159);
    freq.put("no ", 16696);
    freq.put("vrà", 44);
    freq.put("ttu", 476);
    freq.put("mul", 74);
    freq.put("Tel", 49);
    freq.put("ttt", 29);
    freq.put("BG ", 30);
    freq.put("aes", 196);
    freq.put(" we", 217);
    freq.put("qu", 8602);
    freq.put(" wa", 57);
    freq.put("h", 37255);
    freq.put("tti", 3754);
    freq.put(" wh", 28);
    freq.put(" wi", 105);
    freq.put(" ww", 101);
    freq.put("età", 172);
    freq.put("ks ", 52);
    freq.put(" i ", 3195);
    freq.put("shi", 109);
    freq.put("va ", 2457);
    freq.put("ja ", 31);
    freq.put("sho", 122);
    freq.put("Pr", 1034);
    freq.put("Ps", 27);
    freq.put("Tec", 29);
    freq.put("eba", 35);
    freq.put("ebb", 915);
    freq.put("Pu", 241);
    freq.put("ebo", 366);
    freq.put("dì", 364);
    freq.put("ke ", 239);
    freq.put("ebu", 28);
    freq.put("Pa", 1198);
    freq.put("Pd", 62);
    freq.put("Pe", 1049);
    freq.put("ede", 1573);
    freq.put("Ph", 294);
    freq.put("Pi", 595);
    freq.put("Po", 763);
    freq.put("Pl", 71);
    freq.put("hé ", 653);
    freq.put("lve", 143);
    freq.put("lus", 491);
    freq.put("lut", 373);
    freq.put("ome", 3101);
    freq.put("luv", 50);
    freq.put("luz", 102);
    freq.put("Jac", 29);
    freq.put("wo", 191);
    freq.put("et ", 722);
    freq.put("luc", 149);
    freq.put("lud", 52);
    freq.put("lue", 49);
    freq.put("lug", 35);
    freq.put("lui", 364);
    freq.put("lul", 79);
    freq.put("omi", 763);
    freq.put("rpi", 37);
    freq.put("luo", 65);
    freq.put("ken", 61);
    freq.put("kel", 31);
    freq.put("eb ", 158);
    freq.put("omo", 395);
    freq.put("ked", 60);
    freq.put("zzi", 557);
    freq.put("S", 8954);
    freq.put("wi", 945);
    freq.put("key", 24);
    freq.put("Ave", 92);
    freq.put("ket", 104);
    freq.put("ker", 98);
    freq.put("jon", 25);
    freq.put("etr", 385);
    freq.put("ets", 29);
    freq.put("dl ", 55);
    freq.put("etw", 124);
    freq.put("ett", 5773);
    freq.put("etu", 27);
    freq.put("è", 9113);
    freq.put("lu ", 58);
    freq.put("etc", 24);
    freq.put("pid", 107);
    freq.put("eta", 439);
    freq.put("tle", 78);
    freq.put("ete", 1182);
    freq.put("ws", 365);
    freq.put("eti", 374);
    freq.put("Tos", 35);
    freq.put("eto", 253);
    freq.put("ck", 607);
    freq.put("Loc", 23);
    freq.put("ci", 12589);
    freq.put("ch", 19654);
    freq.put("co", 25405);
    freq.put("cn", 150);
    freq.put("cm", 161);
    freq.put("cl", 772);
    freq.put("cc", 7001);
    freq.put("ca", 14668);
    freq.put("Lon", 72);
    freq.put("rva", 100);
    freq.put("ce", 8459);
    freq.put("cd", 58);
    freq.put("rpa", 40);
    freq.put("cy", 51);
    freq.put("Est", 53);
    freq.put("rpe", 84);
    freq.put("lis", 740);
    freq.put("uca", 144);
    freq.put("Lou", 53);
    freq.put("Hel", 28);
    freq.put("cr", 2498);
    freq.put("cq", 215);
    freq.put("ucl", 28);
    freq.put("hm ", 79);
    freq.put("cu", 3118);
    freq.put("ct", 244);
    freq.put("Ges", 25);
    freq.put("Ger", 54);
    freq.put("bbl", 511);
    freq.put("uò ", 316);
    freq.put("rve", 270);
    freq.put("bbi", 680);
    freq.put("dò", 24);
    freq.put("bbe", 887);
    freq.put("Esp", 39);
    freq.put("bbb", 23);
    freq.put("uie", 30);
    freq.put("Jus", 62);
    freq.put("yan", 35);
    freq.put("Juv", 114);
    freq.put("pia", 1851);
    freq.put("IE ", 50);
    freq.put("Geo", 31);
    freq.put("Gen", 196);
    freq.put("Gel", 48);
    freq.put("OL ", 111);
    freq.put("oti", 551);
    freq.put("Lo ", 186);
    freq.put("lgi", 33);
    freq.put("lgo", 62);
    freq.put("cop", 526);
    freq.put("rvo", 92);
    freq.put("AM ", 34);
    freq.put("c ", 1789);
    freq.put("cos", 2886);
    freq.put("pie", 571);
    freq.put("cor", 2383);
    freq.put("uio", 32);
    freq.put("ioè", 191);
    freq.put("Mol", 69);
    freq.put("otr", 322);
    freq.put("pig", 55);
    freq.put("ott", 2090);
    freq.put("otu", 42);
    freq.put("cot", 113);
    freq.put("And", 194);
    freq.put("lli", 1512);
    freq.put("Ang", 61);
    freq.put("Ana", 29);
    freq.put("Anc", 253);
    freq.put("é", 1045);
    freq.put("Ann", 86);
    freq.put("cov", 65);
    freq.put("Hot", 40);
    freq.put("Ant", 113);
    freq.put("rpo", 79);
    freq.put("uir", 177);
    freq.put("rbi", 88);
    freq.put("Ier", 40);
    freq.put("Esc", 33);
    freq.put("rbe", 37);
    freq.put("eur", 276);
    freq.put("ya ", 43);
    freq.put("Anz", 23);
    freq.put("uit", 256);
    freq.put("bir", 67);
    freq.put("va", 6815);
    freq.put("cè", 25);
    freq.put(" Fu", 112);
    freq.put("ve", 11130);
    freq.put("vi", 8614);
    freq.put("avv", 570);
    freq.put("non", 7292);
    freq.put("avr", 316);
    freq.put("vo", 7961);
    freq.put(" Fa", 697);
    freq.put("pip", 36);
    freq.put("vr", 829);
    freq.put("vs", 46);
    freq.put(" Fe", 366);
    freq.put("vu", 798);
    freq.put("vv", 847);
    freq.put(" Fi", 567);
    freq.put("ave", 1359);
    freq.put("You", 101);
    freq.put(" Fl", 89);
    freq.put(" Fo", 471);
    freq.put("io ", 10729);
    freq.put("of ", 135);
    freq.put("pis", 416);
    freq.put("edr", 115);
    freq.put("bbè", 141);
    freq.put("coc", 100);
    freq.put("piu", 137);
    freq.put("dal", 1288);
    freq.put("unc", 207);
    freq.put("dam", 147);
    freq.put("und", 111);
    freq.put("AA ", 40);
    freq.put(" T ", 163);
    freq.put("v ", 489);
    freq.put("odd", 218);
    freq.put("phi", 23);
    freq.put("Cap", 133);
    freq.put("pho", 124);
    freq.put("ngo", 519);
    freq.put("ay ", 351);
    freq.put("iov", 369);
    freq.put("iot", 103);
    freq.put("ios", 392);
    freq.put("ior", 2386);
    freq.put("iop", 98);
    freq.put("ioo", 37);
    freq.put(" F ", 51);
    freq.put("iom", 43);
    freq.put("iol", 302);
    freq.put("ioi", 55);
    freq.put("uni", 762);
    freq.put("iog", 142);
    freq.put("Dis", 102);
    freq.put("iod", 102);
    freq.put("ioc", 480);
    freq.put("GA ", 27);
    freq.put("ont", 2677);
    freq.put("off", 298);
    freq.put("ofe", 126);
    freq.put(" Tw", 287);
    freq.put(" Tv", 29);
    freq.put(" Tu", 373);
    freq.put("ofi", 194);
    freq.put(" Tr", 640);
    freq.put(" To", 466);
    freq.put("unn", 103);
    freq.put(" Ti", 389);
    freq.put(" Th", 171);
    freq.put(" Tg", 26);
    freq.put(" Te", 561);
    freq.put("con", 8077);
    freq.put("Usa", 58);
    freq.put(" Ta", 283);
    freq.put("onu", 50);
    freq.put("dar", 965);
    freq.put("das", 38);
    freq.put(" xD", 773);
    freq.put("lza", 105);
    freq.put("tch", 92);
    freq.put("toi", 27);
    freq.put(" xk", 32);
    freq.put("Be", 981);
    freq.put("now", 26);
    freq.put("adr", 425);
    freq.put("Ba", 657);
    freq.put("wee", 391);
    freq.put("Bl", 214);
    freq.put("Fas", 35);
    freq.put("Bo", 565);
    freq.put("Oh ", 72);
    freq.put("Bi", 302);
    freq.put("Fat", 80);
    freq.put("day", 72);
    freq.put("ske", 26);
    freq.put("Bu", 517);
    freq.put("add", 231);
    freq.put("Fai", 26);
    freq.put("Fan", 68);
    freq.put("Br", 389);
    freq.put("Fam", 26);
    freq.put("Fab", 61);
    freq.put("Fac", 260);
    freq.put("Sho", 38);
    freq.put("ski", 40);
    freq.put("adi", 494);
    freq.put("amb", 791);
    freq.put(" mo", 2841);
    freq.put("Laz", 51);
    freq.put("Mod", 51);
    freq.put("Sai", 40);
    freq.put("Lat", 23);
    freq.put("nve", 580);
    freq.put("T", 4462);
    freq.put("nva", 42);
    freq.put("ode", 222);
    freq.put("nvo", 77);
    freq.put("you", 119);
    freq.put("nvi", 392);
    freq.put("ame", 2497);
    freq.put("dì ", 350);
    freq.put("B ", 287);
    freq.put("l ", 23639);
    freq.put(" x ", 344);
    freq.put("ad ", 935);
    freq.put("Fa ", 30);
    freq.put("Las", 41);
    freq.put("TI ", 241);
    freq.put("am ", 273);
    freq.put("Viv", 47);
    freq.put("Sud", 42);
    freq.put("VO ", 47);
    freq.put("ui ", 1359);
    freq.put("Sag", 36);
    freq.put("Sul", 51);
    freq.put("Sui", 27);
    freq.put("nfi", 187);
    freq.put("Sup", 63);
    freq.put("Lui", 74);
    freq.put("U ", 247);
    freq.put("utr", 52);
    freq.put("esu", 60);
    freq.put("est", 4753);
    freq.put("ess", 3999);
    freq.put("esp", 369);
    freq.put("nd ", 330);
    freq.put("fè ", 75);
    freq.put("buo", 664);
    freq.put("tma", 27);
    freq.put("ese", 1167);
    freq.put("ltà", 126);
    freq.put("esc", 1035);
    freq.put("esa", 627);
    freq.put("eso", 406);
    freq.put("ga ", 662);
    freq.put("esi", 1045);
    freq.put("tmo", 25);
    freq.put("Su ", 68);
    freq.put("RO ", 152);
    freq.put("lle", 3383);
    freq.put("Us", 98);
    freq.put("Ur", 38);
    freq.put("Um", 96);
    freq.put("Ul", 77);
    freq.put("Uo", 25);
    freq.put("Un", 882);
    freq.put("Uh", 26);
    freq.put("Ue", 32);
    freq.put("Ud", 41);
    freq.put("LL ", 41);
    freq.put("ndi", 1768);
    freq.put("Sco", 101);
    freq.put("Sci", 65);
    freq.put("Mez", 33);
    freq.put("ndo", 4388);
    freq.put(" ju", 39);
    freq.put("nde", 1746);
    freq.put("Acq", 24);
    freq.put(" jo", 63);
    freq.put("by ", 112);
    freq.put("es ", 445);
    freq.put(" je", 35);
    freq.put("nds", 40);
    freq.put("ndr", 441);
    freq.put(" ja", 59);
    freq.put("EE ", 33);
    freq.put("Scr", 51);
    freq.put("duc", 154);
    freq.put("ubb", 565);
    freq.put("Twe", 23);
    freq.put("owe", 147);
    freq.put("ea ", 462);
    freq.put("Twi", 258);
    freq.put("owa", 72);
    freq.put("à ", 3517);
    freq.put("più", 1718);
    freq.put("De ", 81);
    freq.put("h ", 2988);
    freq.put("ton", 562);
    freq.put("ows", 73);
    freq.put("Ami", 41);
    freq.put("AN ", 72);
    freq.put("vai", 160);
    freq.put("van", 1052);
    freq.put("Amo", 59);
    freq.put("Sch", 49);
    freq.put("Ama", 61);
    freq.put("rcu", 47);
    freq.put("Ame", 69);
    freq.put("vag", 69);
    freq.put("vad", 407);
    freq.put("ubi", 211);
    freq.put("vaz", 49);
    freq.put("rco", 461);
    freq.put("gaz", 558);
    freq.put("rci", 475);
    freq.put("var", 533);
    freq.put("rce", 232);
    freq.put("Aff", 35);
    freq.put("vat", 740);
    freq.put("lob", 40);
    freq.put("eah", 23);
    freq.put("eak", 68);
    freq.put("hy", 52);
    freq.put("eam", 195);
    freq.put("fu ", 42);
    freq.put("ean", 333);
    freq.put("hr", 72);
    freq.put("hs", 31);
    freq.put("hp", 27);
    freq.put("Des", 45);
    freq.put("ead", 129);
    freq.put("ht", 297);
    freq.put("hu", 163);
    freq.put("hj", 43);
    freq.put("hh", 430);
    freq.put("hi", 5310);
    freq.put("hn", 53);
    freq.put("ho", 3481);
    freq.put("hl", 37);
    freq.put("hm", 120);
    freq.put("hb", 27);
    freq.put("buc", 48);
    freq.put("eas", 66);
    freq.put("ha", 7499);
    freq.put("hf", 26);
    freq.put("hg", 29);
    freq.put("hd", 29);
    freq.put("he", 14674);
    freq.put("dus", 59);
    freq.put("lso", 42);
    freq.put("Tem", 133);
    freq.put("Ten", 36);
    freq.put("aah", 128);
    freq.put("avi", 480);
    freq.put("Tea", 57);
    freq.put("hP", 27);
    freq.put("j", 726);
    freq.put("ai ", 3990);
    freq.put("ow ", 172);
    freq.put("lva", 169);
    freq.put("lvo", 39);
    freq.put("Tes", 63);
    freq.put("lvi", 132);
    freq.put("ID ", 39);
    freq.put("çç ", 78);
    freq.put("Os", 73);
    freq.put("pil", 95);
    freq.put("OO ", 56);
    freq.put("inz", 53);
    freq.put("pio", 414);
    freq.put("int", 1498);
    freq.put("inu", 614);
    freq.put("inv", 716);
    freq.put("pic", 414);
    freq.put("Don", 79);
    freq.put("inq", 119);
    freq.put("ins", 588);
    freq.put("lm ", 264);
    freq.put("inn", 184);
    freq.put("ino", 1889);
    freq.put("ub ", 74);
    freq.put("ini", 2565);
    freq.put("ri ", 3648);
    freq.put("ink", 209);
    freq.put("ind", 955);
    freq.put("ine", 1714);
    freq.put("inf", 590);
    freq.put("ing", 1356);
    freq.put("pit", 659);
    freq.put("ina", 2552);
    freq.put("inc", 1563);
    freq.put("lze", 25);
    freq.put("hn ", 26);
    freq.put("eo ", 936);
    freq.put("í ", 30);
    freq.put("urt", 140);
    freq.put("oal", 48);
    freq.put(" Ur", 36);
    freq.put(" Us", 98);
    freq.put(" Ul", 77);
    freq.put(" Um", 96);
    freq.put(" Un", 875);
    freq.put(" Uo", 25);
    freq.put(" Uh", 26);
    freq.put("or ", 405);
    freq.put("gav", 30);
    freq.put(" Ud", 41);
    freq.put(" Ue", 31);
    freq.put("out", 146);
    freq.put("Acc", 48);
    freq.put("gat", 508);
    freq.put("DA ", 86);
    freq.put("ubr", 40);
    freq.put("sva", 28);
    freq.put("pi ", 307);
    freq.put("gas", 87);
    freq.put("nfa", 234);
    freq.put("gar", 603);
    freq.put("ube", 120);
    freq.put("hè", 780);
    freq.put("hé", 656);
    freq.put("U", 1939);
    freq.put("uba", 62);
    freq.put("Sie", 67);
    freq.put("fir", 86);
    freq.put("ubl", 27);
    freq.put("my ", 123);
    freq.put("ubo", 41);
    freq.put("in ", 5790);
    freq.put("Mar", 559);
    freq.put("eoc", 125);
    freq.put("CI ", 61);
    freq.put("eog", 37);
    freq.put("oa ", 30);
    freq.put("Ma ", 932);
    freq.put("big", 84);
    freq.put("eon", 93);
    freq.put("Boo", 32);
    freq.put("eol", 45);
    freq.put("eor", 75);
    freq.put("eop", 49);
    freq.put("rre", 871);
    freq.put(" U ", 113);
    freq.put("rep", 267);
    freq.put("att", 3803);
    freq.put("MS ", 24);
  }
  
}

