package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class JA {
  private static final String name = "ja";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public JA() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 575083;
    n_words[1] = 614554;
    n_words[2] = 513116;

    freq.put("┌ ", 26);
    freq.put("◔౪◔", 8);
    freq.put("丈並並", 22);
    freq.put("あ一年", 10);
    freq.put("あ！大", 8);
    freq.put("ｸあ", 15);
    freq.put("Ｊ", 20);
    freq.put("丈並三", 13);
    freq.put("大並あ", 9);
    freq.put("、国", 9);
    freq.put("三乱あ", 25);
    freq.put("ア倉あ", 67);
    freq.put("中之", 62);
    freq.put("倉両三", 12);
    freq.put(" 『ア", 122);
    freq.put(" ･ ", 211);
    freq.put("丘】 ", 14);
    freq.put("丈並之", 12);
    freq.put("∵ ", 17);
    freq.put("˙︶", 14);
    freq.put("／／ ", 10);
    freq.put(" 『あ", 44);
    freq.put("丘両三", 18);
    freq.put("三年", 29);
    freq.put("之之」", 8);
    freq.put("ﾎﾞ", 9);
    freq.put("ﾎﾟ", 14);
    freq.put("之之ア", 46);
    freq.put("之之、", 11);
    freq.put("彫あ", 16);
    freq.put("╹） ", 12);
    freq.put("之日", 873);
    freq.put("倉三 ", 25);
    freq.put("ア！ ", 290);
    freq.put(" 『【", 10);
    freq.put("▽⌒", 22);
    freq.put("丁並！", 21);
    freq.put(" あД", 20);
    freq.put("倉倉三", 12);
    freq.put("之之あ", 376);
    freq.put(" இɷ", 10);
    freq.put("▃", 26);
    freq.put("中三あ", 11);
    freq.put("「 ", 146);
    freq.put("┘", 54);
    freq.put("丘三 ", 46);
    freq.put("亀丹あ", 10);
    freq.put("乙三あ", 87);
    freq.put("╹ ", 139);
    freq.put("あ乱", 572);
    freq.put("あ←あ", 8);
    freq.put(" 大", 307);
    freq.put("ﾟ･ ", 72);
    freq.put("ｔ", 16);
    freq.put("丘、あ", 9);
    freq.put("丁】【", 15);
    freq.put(" 丘倉", 23);
    freq.put("ア＆ア", 26);
    freq.put("三仕両", 8);
    freq.put(" σ ", 20);
    freq.put("▽≦", 57);
    freq.put("国 ", 15);
    freq.put("あ伎あ", 129);
    freq.put("中丁", 28);
    freq.put(" アд", 16);
    freq.put("あ日。", 40);
    freq.put("三仕万", 21);
    freq.put("あ日々", 8);
    freq.put(" 丑 ", 24);
    freq.put("「並あ", 28);
    freq.put("之丘 ", 62);
    freq.put(" ／あ", 19);
    freq.put(" 〃▽", 16);
    freq.put(" Θ ", 33);
    freq.put("ｗアア", 9);
    freq.put("！】 ", 16);
    freq.put("↓ ", 35);
    freq.put("あ日あ", 70);
    freq.put("三あ日", 26);
    freq.put("ｳｩ", 9);
    freq.put(" ｀･", 15);
    freq.put("あ三ア", 66);
    freq.put("【之両", 8);
    freq.put("【之並", 14);
    freq.put("；ω", 49);
    freq.put("之並", 1607);
    freq.put("ﾛｰあ", 16);
    freq.put("三あ是", 10);
    freq.put("之月", 18);
    freq.put("中丘", 10);
    freq.put("万万あ", 49);
    freq.put("【之三", 10);
    freq.put("中並", 35);
    freq.put("ア』 ", 15);
    freq.put("あ仕並", 8);
    freq.put(" 丁弁", 14);
    freq.put("人あア", 83);
    freq.put("乙）ア", 9);
    freq.put(" ｀）", 12);
    freq.put("あ仕三", 105);
    freq.put(" ⌒ア", 9);
    freq.put("【之之", 24);
    freq.put(" ●´", 26);
    freq.put("ｾ", 10);
    freq.put("亀丁あ", 29);
    freq.put("ڼ◔ ", 9);
    freq.put("人ああ", 507);
    freq.put("乙）あ", 17);
    freq.put("７三", 10);
    freq.put("７並", 9);
    freq.put("あ三々", 13);
    freq.put("あ三。", 8);
    freq.put("一日あ", 34);
    freq.put("あ三、", 39);
    freq.put("【日三", 9);
    freq.put("！！", 2153);
    freq.put("人あ、", 16);
    freq.put(" 乙 ", 585);
    freq.put("！（", 30);
    freq.put("丘的", 11);
    freq.put("一三 ", 10);
    freq.put("！？", 138);
    freq.put("裏之", 35);
    freq.put("あ三あ", 3319);
    freq.put(" ● ", 35);
    freq.put("！＼", 9);
    freq.put("̀", 76);
    freq.put("之是", 9);
    freq.put(" 国万", 9);
    freq.put(" 丁年", 8);
    freq.put("倉両あ", 55);
    freq.put("万年", 21);
    freq.put("仕丈あ", 11);
    freq.put("ｱ ", 14);
    freq.put(" ＜之", 9);
    freq.put("乙之倉", 17);
    freq.put("②", 39);
    freq.put("｡ﾟ ", 66);
    freq.put("之丙", 22);
    freq.put("乞", 340);
    freq.put("丹倉", 12);
    freq.put("圓丘", 11);
    freq.put("ア亀あ", 33);
    freq.put("侶三あ", 10);
    freq.put(" ･ω", 52);
    freq.put("」", 2161);
    freq.put("倉亀あ", 23);
    freq.put("３", 146);
    freq.put("ア亀ア", 13);
    freq.put("⊖", 14);
    freq.put("ア", 84106);
    freq.put("丈あ ", 38);
    freq.put("並三倉", 16);
    freq.put("両三あ", 256);
    freq.put("あ。倉", 10);
    freq.put("ˇωˇ", 9);
    freq.put("˖", 14);
    freq.put(" ﾉ ", 201);
    freq.put("´͈ ", 9);
    freq.put("嗅丁あ", 20);
    freq.put(" ◎ ", 13);
    freq.put("ア丁倉", 16);
    freq.put("₃", 12);
    freq.put(" ┗ ", 22);
    freq.put("万あ！", 11);
    freq.put("ああΣ", 12);
    freq.put("万あ？", 11);
    freq.put("가 ", 70);
    freq.put(" 丁大", 8);
    freq.put(" 之月", 8);
    freq.put("ㅎ", 9);
    freq.put(" あ´", 8);
    freq.put("日丁ア", 8);
    freq.put("万大", 8);
    freq.put("丈三", 76);
    freq.put("「侶あ", 12);
    freq.put("三両万", 12);
    freq.put("Д｀", 49);
    freq.put("━", 244);
    freq.put("日丁あ", 19);
    freq.put("丁々", 44);
    freq.put("Дﾟ", 58);
    freq.put("ｶあ", 8);
    freq.put("ﾞｹﾃ", 8);
    freq.put("国並あ", 12);
    freq.put("「丘」", 12);
    freq.put("］", 23);
    freq.put("￣ ", 360);
    freq.put(" あ ", 602);
    freq.put("丁」", 63);
    freq.put("ﾞﾗｯ", 20);
    freq.put("ｷｰｱ", 193);
    freq.put("三倉 ", 21);
    freq.put("之三、", 16);
    freq.put("兌倉", 36);
    freq.put("「丘あ", 38);
    freq.put("、三倉", 13);
    freq.put("（アア", 93);
    freq.put(" 【あ", 80);
    freq.put(" ﾟア", 12);
    freq.put("ｱｧｱ", 10);
    freq.put(" ＼ ", 85);
    freq.put("丘あ。", 24);
    freq.put("三人両", 10);
    freq.put(" （╹", 16);
    freq.put("？？あ", 16);
    freq.put(" 丹丘", 8);
    freq.put("あ○", 13);
    freq.put("´д｀", 13);
    freq.put(" ＿人", 69);
    freq.put("００％", 8);
    freq.put("ｵｵ", 71);
    freq.put(" 丹両", 19);
    freq.put(" 亙あ", 12);
    freq.put("日弁", 21);
    freq.put(" 丹並", 9);
    freq.put("０００", 10);
    freq.put("亀丁", 85);
    freq.put("亀万", 73);
    freq.put("･アア", 20);
    freq.put("丈両あ", 12);
    freq.put("亀丈", 16);
    freq.put("亀三", 126);
    freq.put("あ） ", 29);
    freq.put(" 両", 1315);
    freq.put("之人", 52);
    freq.put("亀丘", 308);
    freq.put("ˆ ", 35);
    freq.put("亀両", 36);
    freq.put("亀並", 82);
    freq.put(" ¥ ", 12);
    freq.put("あ〜 ", 211);
    freq.put("⌯", 12);
    freq.put("╯ ", 15);
    freq.put("亀丹", 18);
    freq.put("両", 8719);
    freq.put("佇", 34);
    freq.put("亀之", 106);
    freq.put("˚", 33);
    freq.put("ｧ", 121);
    freq.put("並倉あ", 152);
    freq.put(" 【ア", 213);
    freq.put("︶˙", 14);
    freq.put("⊃", 94);
    freq.put("ﾑ", 215);
    freq.put("＼ア", 13);
    freq.put(" 年", 190);
    freq.put("乱」", 21);
    freq.put("乱「", 9);
    freq.put("Ｆ", 10);
    freq.put("̮", 24);
    freq.put("˃", 31);
    freq.put("アあ」", 12);
    freq.put("乱あ", 768);
    freq.put("彦", 10);
    freq.put("並三嗅", 17);
    freq.put("。之並", 11);
    freq.put("丘並ア", 9);
    freq.put("ｰﾝ ", 21);
    freq.put("あ裏", 35);
    freq.put("◞౪◟", 14);
    freq.put("丁アア", 342);
    freq.put("アあ。", 61);
    freq.put("並） ", 14);
    freq.put("ｗああ", 37);
    freq.put("両侶", 10);
    freq.put("！＼ ", 9);
    freq.put(" 之日", 456);
    freq.put("。乙あ", 21);
    freq.put("。之三", 9);
    freq.put("乱ア", 19);
    freq.put("＼　", 23);
    freq.put("万丁あ", 163);
    freq.put("彡 ", 25);
    freq.put("＞＜", 15);
    freq.put("＞＞", 21);
    freq.put("、倉", 69);
    freq.put("＾∇＾", 9);
    freq.put("大万あ", 35);
    freq.put("中あ ", 10);
    freq.put(" 丘", 1393);
    freq.put("｢ああ", 12);
    freq.put("万丁】", 12);
    freq.put("。之之", 12);
    freq.put("あ人！", 9);
    freq.put("乙あ ", 100);
    freq.put("︶ ", 14);
    freq.put(" 彡", 38);
    freq.put("両並", 704);
    freq.put("ﾞああ", 15);
    freq.put("両中", 26);
    freq.put("万三丘", 8);
    freq.put("万三丁", 9);
    freq.put("両丹", 11);
    freq.put("丘両ア", 10);
    freq.put("万三三", 28);
    freq.put("両丁", 387);
    freq.put("ア」 ", 71);
    freq.put("アあ", 9903);
    freq.put("両三", 747);
    freq.put("両丈", 21);
    freq.put(" あω", 13);
    freq.put("ア。。", 11);
    freq.put("万三並", 23);
    freq.put("両丘", 146);
    freq.put("σ", 52);
    freq.put("三、あ", 31);
    freq.put("両乱", 20);
    freq.put("ｐ", 13);
    freq.put("万倉あ", 21);
    freq.put("´ิ ", 26);
    freq.put("万三之", 17);
    freq.put("ア　", 187);
    freq.put("ア、", 357);
    freq.put("ア。", 364);
    freq.put("ア「", 184);
    freq.put("ア」", 200);
    freq.put("ア『", 31);
    freq.put("ア』", 149);
    freq.put("ア。あ", 43);
    freq.put("ア【", 44);
    freq.put("ア】", 253);
    freq.put("ア〜", 27);
    freq.put("１年", 11);
    freq.put("ア。ア", 25);
    freq.put("▓▒░", 12);
    freq.put("両人", 31);
    freq.put("乙丁あ", 158);
    freq.put("両亀", 20);
    freq.put("三、ア", 25);
    freq.put("倣ああ", 48);
    freq.put("アア", 59090);
    freq.put("】【ア", 13);
    freq.put("之あ大", 22);
    freq.put("ﾑﾞ", 8);
    freq.put("乱", 1546);
    freq.put("௰ ", 8);
    freq.put("三大", 67);
    freq.put("あ乙丘", 39);
    freq.put("дﾟ", 31);
    freq.put(" ⃘ ", 8);
    freq.put("󾮔 ", 20);
    freq.put("󾮔?", 12);
    freq.put("丈倉", 22);
    freq.put("並万三", 24);
    freq.put("あ乙丈", 19);
    freq.put("あ乙三", 61);
    freq.put("あ乙万", 15);
    freq.put("並万丁", 8);
    freq.put("あ乙丁", 110);
    freq.put("三国", 57);
    freq.put(" ｡･", 22);
    freq.put("両あ之", 105);
    freq.put("あ٩", 30);
    freq.put("∀； ", 38);
    freq.put("あ乙並", 48);
    freq.put("両あ乙", 22);
    freq.put("並万並", 22);
    freq.put("あ乙両", 53);
    freq.put(" 倣", 28);
    freq.put("┓┛┓", 30);
    freq.put("ˇ", 25);
    freq.put("あ乙乙", 33);
    freq.put("】あ丁", 15);
    freq.put("あ乙之", 88);
    freq.put("並万之", 10);
    freq.put("⃛", 19);
    freq.put(" 倹", 19);
    freq.put("ﾌﾞｰ", 9);
    freq.put("並人的", 13);
    freq.put("両あ丁", 124);
    freq.put("￥", 61);
    freq.put("両あ万", 16);
    freq.put("両あ丈", 16);
    freq.put("両あ三", 179);
    freq.put(" 倉", 430);
    freq.put("倉並並", 9);
    freq.put("⁰", 23);
    freq.put("┓三 ", 11);
    freq.put(" 倖", 33);
    freq.put("両あ丘", 82);
    freq.put("ｺ", 85);
    freq.put("人アア", 57);
    freq.put("！？？", 10);
    freq.put("並侶あ", 28);
    freq.put("´△｀", 11);
    freq.put("！？！", 27);
    freq.put("ア三 ", 56);
    freq.put("あ乙亀", 74);
    freq.put(" 僅", 10);
    freq.put("ﾌﾞﾙ", 8);
    freq.put("ﾌﾞﾗ", 20);
    freq.put("ああ嗅", 18);
    freq.put("並　 ", 14);
    freq.put("ु", 61);
    freq.put(" 傭", 17);
    freq.put("両あ人", 18);
    freq.put(" ｡ﾟ", 34);
    freq.put("両あ亀", 30);
    freq.put("之万 ", 22);
    freq.put("ऀ", 23);
    freq.put("、両並", 29);
    freq.put("、両両", 17);
    freq.put("あ嗅あ", 15);
    freq.put("乙並三", 8);
    freq.put("乱あ ", 28);
    freq.put("「あア", 19);
    freq.put("、両丁", 15);
    freq.put("、両三", 16);
    freq.put(" 兌", 12);
    freq.put("「並」", 26);
    freq.put("丁両】", 8);
    freq.put("之倉あ", 88);
    freq.put("∴", 23);
    freq.put("之丁 ", 72);
    freq.put("丁両あ", 160);
    freq.put("、両之", 17);
    freq.put("之￥ ", 10);
    freq.put("之倉」", 9);
    freq.put("乙乙あ", 26);
    freq.put("（≧", 43);
    freq.put("侶あ ", 39);
    freq.put("ةڼ", 9);
    freq.put("丁両ア", 12);
    freq.put("両両倉", 8);
    freq.put("／", 591);
    freq.put("】", 1598);
    freq.put("　∧＿", 10);
    freq.put(" 凄", 14);
    freq.put("」之", 15);
    freq.put("「あ、", 16);
    freq.put("あ？　", 21);
    freq.put("┳", 33);
    freq.put("」並", 22);
    freq.put("」両", 16);
    freq.put(" ア月", 26);
    freq.put("啓", 15);
    freq.put("年亀あ", 10);
    freq.put("両あ侶", 11);
    freq.put("ア丘並", 14);
    freq.put("」丁", 18);
    freq.put("ღ", 8);
    freq.put("」三", 21);
    freq.put("ア丘三", 15);
    freq.put("「ああ", 450);
    freq.put("ア丘丁", 23);
    freq.put("ｗ」 ", 8);
    freq.put("」丘", 9);
    freq.put("──", 62);
    freq.put("ૢ ", 10);
    freq.put("～～あ", 10);
    freq.put("▓█▇", 12);
    freq.put("´；ω", 41);
    freq.put("」あ倉", 8);
    freq.put("ｷﾁ", 17);
    freq.put("的ア", 10);
    freq.put("´｀ ", 9);
    freq.put("ｷﾝ", 8);
    freq.put("？ア", 36);
    freq.put(" ＾ω", 106);
    freq.put("並ア", 426);
    freq.put("あ∧", 20);
    freq.put("三之￥", 9);
    freq.put("ﾟ｡ ", 35);
    freq.put("乙←", 9);
    freq.put("）┐ｹ", 8);
    freq.put("＜⌒／", 8);
    freq.put("日倉", 20);
    freq.put(" ╹◡", 17);
    freq.put(" ⊃━", 15);
    freq.put("＿／ ", 15);
    freq.put("ﾉ ", 225);
    freq.put("？』", 10);
    freq.put("？」", 144);
    freq.put("亀三之", 13);
    freq.put("仕両あ", 12);
    freq.put(" 三日", 214);
    freq.put("？　", 27);
    freq.put("侶！", 8);
    freq.put("三之：", 27);
    freq.put("日あ侶", 13);
    freq.put("侮", 196);
    freq.put("◎ ", 22);
    freq.put("並あ", 7597);
    freq.put("ア「三", 9);
    freq.put("Ｙ", 11);
    freq.put("三之）", 12);
    freq.put("三之（", 8);
    freq.put("丈丁あ", 97);
    freq.put("ｷｬ", 64);
    freq.put("的あ", 137);
    freq.put("Σ", 54);
    freq.put("亀三三", 15);
    freq.put("三三 ", 264);
    freq.put("ｷｰ", 199);
    freq.put("？あ", 244);
    freq.put("┳┻", 8);
    freq.put("並】", 116);
    freq.put("あ。大", 8);
    freq.put("並〜", 11);
    freq.put("並　", 57);
    freq.put("ﾟ´ω", 18);
    freq.put("並。", 72);
    freq.put("並々", 15);
    freq.put("並「", 49);
    freq.put("並」", 58);
    freq.put("並』", 19);
    freq.put("█▓", 12);
    freq.put("之日あ", 705);
    freq.put(" ； ", 17);
    freq.put("ア　ア", 40);
    freq.put("あ◔ ", 9);
    freq.put("三嗅", 41);
    freq.put("█▇", 12);
    freq.put("丼あ之", 9);
    freq.put(" 倉之", 23);
    freq.put("並並あ", 808);
    freq.put("丘！", 47);
    freq.put("ฅ｀ ", 8);
    freq.put("丘：", 9);
    freq.put("丘？", 10);
    freq.put(" 倉両", 25);
    freq.put("大丁あ", 294);
    freq.put(" 倉並", 35);
    freq.put("丼あ丁", 11);
    freq.put("ア並ア", 8);
    freq.put("あ並丘", 107);
    freq.put("丼あ三", 10);
    freq.put("並並】", 21);
    freq.put(" 倉三", 55);
    freq.put(" 倉丁", 38);
    freq.put("꒳ ", 19);
    freq.put("並並、", 11);
    freq.put(" 倉万", 12);
    freq.put("ア並あ", 171);
    freq.put(" ；´", 20);
    freq.put("´･ ", 88);
    freq.put("丙", 386);
    freq.put("並！！", 16);
    freq.put("丁侶丁", 12);
    freq.put("ア　　", 11);
    freq.put("ア両 ", 18);
    freq.put(" ｼﾞ", 8);
    freq.put("並倉三", 40);
    freq.put("俘", 9);
    freq.put("並並ア", 21);
    freq.put("丼あ亀", 9);
    freq.put("｣", 63);
    freq.put("；） ", 14);
    freq.put("之日ア", 19);
    freq.put("並三：", 8);
    freq.put("ア　あ", 9);
    freq.put(" 倉亀", 15);
    freq.put("ああ伎", 122);
    freq.put(" ऀ ", 18);
    freq.put("ﾍ", 33);
    freq.put("大人", 50);
    freq.put("﹏ ", 13);
    freq.put("̀๑ ", 10);
    freq.put("乙丘 ", 24);
    freq.put("Ｂ", 13);
    freq.put("乙万あ", 25);
    freq.put("ﾟдﾟ", 30);
    freq.put("。三あ", 33);
    freq.put("大亀", 10);
    freq.put("丘丘之", 16);
    freq.put("丘あ並", 104);
    freq.put("！！ア", 49);
    freq.put("』あ並", 28);
    freq.put("ϵ", 11);
    freq.put("万之ア", 9);
    freq.put("！！あ", 129);
    freq.put("「万ア", 15);
    freq.put("あ！？", 67);
    freq.put("～ア ", 8);
    freq.put("ああ侃", 15);
    freq.put("あ倉 ", 32);
    freq.put(" ꒱ ", 10);
    freq.put("並。あ", 9);
    freq.put("之！ ", 35);
    freq.put("大両", 53);
    freq.put("あ！！", 794);
    freq.put("丘あ乙", 37);
    freq.put("万之あ", 168);
    freq.put("あ！（", 14);
    freq.put("ु ", 35);
    freq.put("大丘", 25);
    freq.put("大万", 101);
    freq.put("大丁", 334);
    freq.put("ああ侶", 260);
    freq.put(" ˘⊖", 11);
    freq.put("大三", 100);
    freq.put("大丈", 123);
    freq.put("！！　", 9);
    freq.put("！！」", 46);
    freq.put("あΣ ", 11);
    freq.put("あʕ", 11);
    freq.put(" 亀あ", 189);
    freq.put("丑 ", 59);
    freq.put("大乙", 22);
    freq.put("〉 ", 11);
    freq.put("大之", 46);
    freq.put("｀ﾟ ", 15);
    freq.put("ｗあ", 41);
    freq.put("ああ三", 3419);
    freq.put("ああ丈", 276);
    freq.put("ああ万", 644);
    freq.put("あアア", 6396);
    freq.put("ああ丁", 2749);
    freq.put("ああ一", 252);
    freq.put(" ┛ ", 9);
    freq.put("あ両日", 26);
    freq.put("ああ丙", 52);
    freq.put("ああ丘", 1071);
    freq.put("両両丁", 22);
    freq.put("ああ且", 21);
    freq.put("丹年", 8);
    freq.put("ああ丑", 150);
    freq.put("⌒ア ", 17);
    freq.put("ああ中", 91);
    freq.put("ああ並", 2288);
    freq.put("亀ああ", 947);
    freq.put("ﾟ´Д", 8);
    freq.put("ああ両", 1143);
    freq.put("⇒「あ", 10);
    freq.put("꒱", 78);
    freq.put("月三あ", 27);
    freq.put("ああ丼", 109);
    freq.put("ああ丹", 118);
    freq.put("ああ之", 2721);
    freq.put("両両三", 53);
    freq.put("ｗ」", 12);
    freq.put("ｌ", 8);
    freq.put("ああ乞", 154);
    freq.put("ああ乙", 987);
    freq.put("万並あ", 148);
    freq.put("国ああ", 24);
    freq.put("あ（三", 10);
    freq.put("౪◟", 16);
    freq.put("౪◔", 15);
    freq.put(" 丁倉", 55);
    freq.put("╰", 51);
    freq.put("〜 ", 301);
    freq.put("ああ乱", 334);
    freq.put("ｲﾔ", 10);
    freq.put("丼丼", 109);
    freq.put("あω", 27);
    freq.put("ｻｲﾄ", 8);
    freq.put("ああ亀", 454);
    freq.put("三亀あ", 86);
    freq.put("ああ亙", 13);
    freq.put("丼両", 16);
    freq.put("あア」", 17);
    freq.put(" 嗅", 16);
    freq.put("ああ亥", 8);
    freq.put("丘倉丁", 12);
    freq.put("あア。", 151);
    freq.put("丼丘", 52);
    freq.put("あϵ", 10);
    freq.put("ああ人", 788);
    freq.put("丼丁", 17);
    freq.put("万並ア", 13);
    freq.put(" 之侶", 28);
    freq.put("国あア", 10);
    freq.put("丼三", 29);
    freq.put("＿＿", 145);
    freq.put("倖ああ", 105);
    freq.put("⇒「ア", 11);
    freq.put("ああ仕", 82);
    freq.put("＿；", 29);
    freq.put("ｗア", 12);
    freq.put("あΣ", 13);
    freq.put("「之日", 11);
    freq.put("あアあ", 1847);
    freq.put("＿／", 20);
    freq.put("あε", 8);
    freq.put("丈之あ", 20);
    freq.put("丼之", 14);
    freq.put("裏之 ", 9);
    freq.put("ﾋｮｵ", 8);
    freq.put("両之並", 36);
    freq.put("丹両あ", 18);
    freq.put("両之丘", 9);
    freq.put("並之あ", 372);
    freq.put("あ倣あ", 33);
    freq.put(" ｗｗ", 15);
    freq.put("両之三", 28);
    freq.put("両之丁", 14);
    freq.put("一三三", 9);
    freq.put("是之あ", 12);
    freq.put("あ一倉", 97);
    freq.put("ｹｲ", 8);
    freq.put(" ┌┛", 10);
    freq.put(" ˙︶", 14);
    freq.put("（╹", 16);
    freq.put("あ ", 17507);
    freq.put("中 ", 85);
    freq.put("並之、", 19);
    freq.put("両之之", 25);
    freq.put("ｶ", 81);
    freq.put(" ･ิ", 9);
    freq.put("並之】", 13);
    freq.put("あ?", 55);
    freq.put("一三並", 10);
    freq.put("亀", 2581);
    freq.put("あ】あ", 12);
    freq.put("傭あ", 39);
    freq.put("『 ", 31);
    freq.put("あ×", 11);
    freq.put(" 国", 24);
    freq.put(" 丈 ", 13);
    freq.put("「丁三", 9);
    freq.put("ｹﾃ", 10);
    freq.put("「丁丁", 10);
    freq.put("´", 2166);
    freq.put("ｹﾞ", 11);
    freq.put("並之ア", 54);
    freq.put("三倉", 290);
    freq.put("ﾔｧ", 23);
    freq.put("乙アア", 69);
    freq.put("▃▃▃", 10);
    freq.put("之あ倉", 69);
    freq.put("。ア", 216);
    freq.put("「丁之", 8);
    freq.put("並あ人", 26);
    freq.put("あ´", 21);
    freq.put("三倣", 9);
    freq.put(" ／／", 14);
    freq.put("之両丁", 13);
    freq.put("之両万", 10);
    freq.put("▇", 24);
    freq.put("之両三", 40);
    freq.put(" ／＜", 8);
    freq.put(" 万日", 9);
    freq.put(" ω ", 680);
    freq.put("之両丘", 10);
    freq.put(" 坂", 18);
    freq.put("之両両", 28);
    freq.put("ლ", 20);
    freq.put("之両並", 39);
    freq.put(" ／＼", 9);
    freq.put("丘倉あ", 67);
    freq.put("之両之", 28);
    freq.put(" 在", 8);
    freq.put("「あ三", 11);
    freq.put("裏両", 8);
    freq.put("乖", 11);
    freq.put("̼̮ ", 9);
    freq.put(" 圓", 8);
    freq.put(" 年あ", 35);
    freq.put("並丁丘", 15);
    freq.put("＋", 40);
    freq.put(" ω´", 8);
    freq.put("並丁三", 57);
    freq.put(" ＝ ", 8);
    freq.put("之大万", 8);
    freq.put("！← ", 12);
    freq.put("並丁丁", 42);
    freq.put("丘倉ア", 8);
    freq.put("＝ア", 14);
    freq.put("侶之あ", 17);
    freq.put("並丁両", 22);
    freq.put("並丁並", 47);
    freq.put("丁！", 77);
    freq.put("丁丁！", 19);
    freq.put("丁）", 24);
    freq.put("丁（", 22);
    freq.put("並丁之", 36);
    freq.put("一並並", 16);
    freq.put("丁：", 15);
    freq.put("丁＜", 8);
    freq.put("丁？", 31);
    freq.put("、大", 54);
    freq.put("一日", 67);
    freq.put("あ倉三", 136);
    freq.put("倹ああ", 81);
    freq.put(" ﾟ▽", 138);
    freq.put("両大", 16);
    freq.put("あ一乙", 20);
    freq.put("三仕", 65);
    freq.put("両並あ", 275);
    freq.put("裏丁", 10);
    freq.put("ｷﾁｷ", 9);
    freq.put("あ一之", 59);
    freq.put("人人 ", 11);
    freq.put("　 ", 1113);
    freq.put("ω； ", 19);
    freq.put("三！ ", 41);
    freq.put("あ丁ア", 23);
    freq.put("＾∀", 12);
    freq.put("。←", 22);
    freq.put("＾∇", 9);
    freq.put("ア日三", 8);
    freq.put("！　あ", 8);
    freq.put("あ一丘", 61);
    freq.put("両並、", 11);
    freq.put("両並。", 12);
    freq.put("之あ人", 33);
    freq.put("あ一万", 10);
    freq.put("あ一三", 69);
    freq.put("三亀", 149);
    freq.put("三┏ ", 9);
    freq.put(" 三：", 9);
    freq.put("三人", 149);
    freq.put("之あ亀", 42);
    freq.put("／丁", 9);
    freq.put("アア ", 4049);
    freq.put("あ一両", 21);
    freq.put("あ一並", 23);
    freq.put(" （あ", 10);
    freq.put("三乙", 207);
    freq.put("､あ", 11);
    freq.put("三之", 2139);
    freq.put("あ丁々", 15);
    freq.put("⌒ ", 145);
    freq.put("乱丁 ", 9);
    freq.put("アア×", 11);
    freq.put(" （ア", 20);
    freq.put("之あ乱", 23);
    freq.put("之あ之", 247);
    freq.put("乙之 ", 41);
    freq.put("三乱", 41);
    freq.put("之あ乙", 72);
    freq.put("亥丘", 8);
    freq.put("　´", 25);
    freq.put(" ↓ ", 27);
    freq.put("·˚", 14);
    freq.put("三丙", 29);
    freq.put("三丘", 497);
    freq.put("之あ中", 15);
    freq.put("三丑", 10);
    freq.put("之あ両", 132);
    freq.put("之あ並", 201);
    freq.put("三且", 15);
    freq.put("三三", 3070);
    freq.put("三丈", 70);
    freq.put("之あ丹", 16);
    freq.put("あ丁あ", 2961);
    freq.put("三丁", 1137);
    freq.put("三一", 46);
    freq.put("三万", 781);
    freq.put("万】【", 9);
    freq.put("三丹", 49);
    freq.put("之あ丈", 18);
    freq.put("之あ三", 352);
    freq.put("三丼", 31);
    freq.put("之あ一", 21);
    freq.put("之あ丁", 204);
    freq.put("丘万あ", 52);
    freq.put("之あ万", 48);
    freq.put("両並ア", 30);
    freq.put("之あ丘", 112);
    freq.put("之あ丙", 10);
    freq.put("三中", 43);
    freq.put("≡┗", 12);
    freq.put("三両", 574);
    freq.put("ああ叶", 14);
    freq.put("之あ丑", 11);
    freq.put("三並", 1870);
    freq.put(" 　 ", 411);
    freq.put("倉あ！", 8);
    freq.put(" 倹あ", 11);
    freq.put(" ꒳ ", 9);
    freq.put("丈三あ", 25);
    freq.put("ﾆ ", 20);
    freq.put("۶ ", 30);
    freq.put("両丁ア", 13);
    freq.put("仕", 607);
    freq.put("日並あ", 35);
    freq.put("之あ侶", 16);
    freq.put("僅ああ", 11);
    freq.put("三侶", 33);
    freq.put("人万あ", 18);
    freq.put("、", 5777);
    freq.put("ｗｗＷ", 10);
    freq.put("三万】", 12);
    freq.put("： ", 183);
    freq.put("並亀あ", 41);
    freq.put("あ侶あ", 279);
    freq.put("三万、", 8);
    freq.put(" 　´", 24);
    freq.put("ﾞﾝﾊ", 16);
    freq.put("伎あ両", 13);
    freq.put("！三あ", 16);
    freq.put("両丁あ", 203);
    freq.put("丁亀 ", 16);
    freq.put("丘日", 13);
    freq.put("丘アア", 122);
    freq.put("丁」 ", 39);
    freq.put("嗅三あ", 11);
    freq.put("三万あ", 463);
    freq.put("三伎", 15);
    freq.put("ｗｗｗ", 1277);
    freq.put("侶丁あ", 22);
    freq.put("丁三 ", 143);
    freq.put("ﾉ", 569);
    freq.put("一丘あ", 30);
    freq.put("）アア", 39);
    freq.put("日三ア", 18);
    freq.put("･あ", 75);
    freq.put("＞", 219);
    freq.put(" 大並", 11);
    freq.put("｣あ", 17);
    freq.put("嗅 ", 8);
    freq.put("꒰ ", 42);
    freq.put("ア】【", 13);
    freq.put("̶", 35);
    freq.put("ㅂ", 12);
    freq.put("嗅", 104);
    freq.put("亥ああ", 16);
    freq.put("· ", 20);
    freq.put("　丁三", 11);
    freq.put("ˋ", 10);
    freq.put("ꞌᴥꞌ", 25);
    freq.put("丑」 ", 9);
    freq.put("ਊ՞ ", 10);
    freq.put("日", 2866);
    freq.put("　丁並", 12);
    freq.put("倉並あ", 116);
    freq.put("【両三", 18);
    freq.put("ア】ア", 28);
    freq.put("丁乙両", 8);
    freq.put("┗━━", 12);
    freq.put("乱三あ", 8);
    freq.put("丁之！", 13);
    freq.put("日あ丁", 56);
    freq.put("。並あ", 28);
    freq.put(" 倖あ", 25);
    freq.put("。あ", 673);
    freq.put("、丑あ", 22);
    freq.put("大倉", 20);
    freq.put("之」あ", 17);
    freq.put("ああ凄", 20);
    freq.put("日あ三", 50);
    freq.put("ﾟωﾟ", 22);
    freq.put("倉』→", 11);
    freq.put("日三あ", 92);
    freq.put("〈", 16);
    freq.put("之月あ", 8);
    freq.put("三】 ", 65);
    freq.put("ああ倉", 815);
    freq.put("一ああ", 42);
    freq.put("　乙あ", 14);
    freq.put("万乙", 17);
    freq.put(" 丁乱", 10);
    freq.put("ああ倖", 44);
    freq.put("万之", 384);
    freq.put("あ万 ", 20);
    freq.put("꒱۶", 11);
    freq.put("両」 ", 21);
    freq.put(" 丁之", 168);
    freq.put("ああ倣", 24);
    freq.put("倉丁 ", 28);
    freq.put("ア） ", 50);
    freq.put(" 大之", 10);
    freq.put("ああ倹", 38);
    freq.put("丘丁 ", 47);
    freq.put(" 丁乙", 63);
    freq.put("月 ", 226);
    freq.put("丘ア丁", 16);
    freq.put(" 丁両", 88);
    freq.put("あ", 279324);
    freq.put(" 丁並", 262);
    freq.put("伎あ乙", 11);
    freq.put("万丘", 72);
    freq.put("万万", 98);
    freq.put("之： ", 82);
    freq.put("万丁", 355);
    freq.put(" 丁丹", 11);
    freq.put("万三", 433);
    freq.put("万丈", 14);
    freq.put(" 丁丁", 202);
    freq.put("丁あア", 208);
    freq.put("ू ", 30);
    freq.put(" 丁万", 36);
    freq.put(" 丁丈", 15);
    freq.put(" 丁三", 282);
    freq.put("万並", 349);
    freq.put("◆ア", 8);
    freq.put("万両", 163);
    freq.put(" 丁丘", 88);
    freq.put(" ◡ु", 14);
    freq.put("丁ああ", 4866);
    freq.put("之弁日", 38);
    freq.put("ア丈あ", 48);
    freq.put("並亀之", 9);
    freq.put(" ▂▅", 12);
    freq.put("ああ傭", 13);
    freq.put("之侶 ", 12);
    freq.put("之的", 15);
    freq.put("あ」「", 11);
    freq.put("丁倉あ", 162);
    freq.put("￣￣ ", 31);
    freq.put("丁あ　", 12);
    freq.put("丁あ、", 49);
    freq.put("丁あ。", 62);
    freq.put("〜アア", 21);
    freq.put("弁万", 16);
    freq.put("丁あ「", 8);
    freq.put("ア꒰", 12);
    freq.put("万亀", 16);
    freq.put("･ิ", 30);
    freq.put(" 丁人", 13);
    freq.put("≡", 131);
    freq.put("万人", 20);
    freq.put("▽〃", 17);
    freq.put("」あ並", 20);
    freq.put("」あ両", 12);
    freq.put("、乙あ", 52);
    freq.put("丑ああ", 341);
    freq.put(" ？ ", 52);
    freq.put("ｺﾄﾞ", 9);
    freq.put("」あ三", 25);
    freq.put("日之", 136);
    freq.put("並～ ", 8);
    freq.put("」あ丁", 26);
    freq.put("日乙", 9);
    freq.put("両三ア", 40);
    freq.put("丼", 665);
    freq.put("日中", 11);
    freq.put(" ˘ ", 20);
    freq.put("日並", 99);
    freq.put("日両", 55);
    freq.put("丘乙 ", 13);
    freq.put("日三", 303);
    freq.put("日之三", 9);
    freq.put("」あ之", 47);
    freq.put("ﾗｯ", 216);
    freq.put("日万", 28);
    freq.put("日丁", 65);
    freq.put("日一", 16);
    freq.put("´艸｀", 42);
    freq.put("ｲ", 319);
    freq.put("日丘", 38);
    freq.put("ア⌒", 31);
    freq.put("並中 ", 12);
    freq.put("｡ア", 11);
    freq.put("２ ", 9);
    freq.put("　＼ ", 20);
    freq.put("三嗅あ", 23);
    freq.put("、乱三", 13);
    freq.put("⃘ ", 8);
    freq.put("̫̮ ", 10);
    freq.put("→ああ", 31);
    freq.put("ｶｰﾄ", 11);
    freq.put("あ丘 ", 16);
    freq.put("💖 ", 9);
    freq.put("）（", 25);
    freq.put("ｩ ", 8);
    freq.put("人並之", 11);
    freq.put("　両あ", 8);
    freq.put("━━ ", 8);
    freq.put("日亀", 13);
    freq.put("⌒▽⌒", 22);
    freq.put("）Ｏ", 11);
    freq.put(" 　／", 8);
    freq.put("倉アア", 53);
    freq.put(" 両 ", 162);
    freq.put("丁日", 18);
    freq.put("倉両並", 8);
    freq.put("並国ア", 9);
    freq.put("三大万", 9);
    freq.put("在両", 20);
    freq.put("丘両並", 22);
    freq.put("ﾟアﾟ", 8);
    freq.put("ア∀", 62);
    freq.put("乙三ア", 103);
    freq.put("倉両丁", 9);
    freq.put(" 倉倉", 13);
    freq.put("⁰ ", 14);
    freq.put("丘両丁", 9);
    freq.put("ア∞", 8);
    freq.put("在丁", 10);
    freq.put("ｼﾝ", 46);
    freq.put(" 。 ", 137);
    freq.put("～？", 14);
    freq.put("、中", 15);
    freq.put("～４", 13);
    freq.put("侶丘 ", 8);
    freq.put("あ！』", 11);
    freq.put("～！", 31);
    freq.put("ﾜ", 33);
    freq.put(" ๑╹", 25);
    freq.put("並国あ", 15);
    freq.put("ﾄ ", 10);
    freq.put("（之）", 13);
    freq.put("～～", 64);
    freq.put("⇒「", 22);
    freq.put("日侶", 16);
    freq.put("、あ ", 10);
    freq.put("！伎あ", 11);
    freq.put("；∀；", 38);
    freq.put("꒱ ", 33);
    freq.put("ああ国", 15);
    freq.put("丈丘", 43);
    freq.put("！両両", 12);
    freq.put("丈丈", 17);
    freq.put(" 乱", 457);
    freq.put("あ乙倉", 12);
    freq.put("あ　之", 22);
    freq.put("丈丁", 172);
    freq.put("→アア", 38);
    freq.put("Ｔああ", 12);
    freq.put(" 之", 2983);
    freq.put("両万あ", 42);
    freq.put("三乙三", 15);
    freq.put("丈両", 26);
    freq.put("丈並", 215);
    freq.put("丈乙", 33);
    freq.put(" 並", 2081);
    freq.put("₍ ", 9);
    freq.put("あ　丘", 13);
    freq.put(" 中", 100);
    freq.put("あ　丁", 12);
    freq.put("丈之", 43);
    freq.put("〜（あ", 35);
    freq.put("あ　三", 24);
    freq.put(" 丹", 240);
    freq.put(" 丼", 115);
    freq.put(" 一", 218);
    freq.put(" 丁", 2367);
    freq.put(" 万", 637);
    freq.put("両あ倉", 28);
    freq.put(" 丈", 258);
    freq.put(" 三", 3801);
    freq.put("丁乙 ", 37);
    freq.put("アあ、", 112);
    freq.put("アあ　", 8);
    freq.put("あ　両", 8);
    freq.put("あ大丈", 53);
    freq.put(" 丑", 134);
    freq.put(" 且", 32);
    freq.put("あ　並", 15);
    freq.put("乱人あ", 9);
    freq.put(" 丙", 65);
    freq.put("両並並", 39);
    freq.put("亀丘あ", 87);
    freq.put("丘並あ", 124);
    freq.put("！！！", 955);
    freq.put("丈亀", 32);
    freq.put("｡あ", 14);
    freq.put("ああ喫", 20);
    freq.put("ア⇒", 15);
    freq.put(" 仕", 76);
    freq.put("ｯ ", 60);
    freq.put(" 亥", 10);
    freq.put("ﾉああ", 25);
    freq.put("アあア", 918);
    freq.put("　三 ", 12);
    freq.put(" ∇ ", 55);
    freq.put(" 人", 340);
    freq.put("１丘乙", 10);
    freq.put("＊あ", 9);
    freq.put(" 亀", 474);
    freq.put("あ｣あ", 8);
    freq.put("Ｏ ", 13);
    freq.put("○ああ", 14);
    freq.put("ア←", 11);
    freq.put("ア→", 65);
    freq.put(" 亙", 15);
    freq.put("】丁あ", 14);
    freq.put("о ", 18);
    freq.put("∀＾ ", 12);
    freq.put(" 月：", 10);
    freq.put("¥", 17);
    freq.put("乩ああ", 17);
    freq.put(" 佐", 31);
    freq.put("乱両並", 8);
    freq.put("󾮔", 52);
    freq.put("◡ ", 56);
    freq.put("僅", 34);
    freq.put("１人", 11);
    freq.put("丁丙あ", 13);
    freq.put("ああ呟", 9);
    freq.put("ﾘﾘ", 13);
    freq.put(" 彡 ", 19);
    freq.put("）（乙", 9);
    freq.put(" ⌒▽", 22);
    freq.put(" 伎", 231);
    freq.put("？乙 ", 31);
    freq.put("日万あ", 8);
    freq.put(" ┳┻", 8);
    freq.put("【並あ", 10);
    freq.put("々", 220);
    freq.put("о´", 11);
    freq.put("≦ ", 96);
    freq.put("ิ∀", 20);
    freq.put("三： ", 8);
    freq.put("ｽﾔ", 21);
    freq.put("̣", 77);
    freq.put("両両並", 32);
    freq.put("両両両", 27);
    freq.put("両両中", 13);
    freq.put("ｽﾞ", 13);
    freq.put("ｽﾀ", 8);
    freq.put("ﾘｽ", 12);
    freq.put("乙。 ", 9);
    freq.put("θ", 18);
    freq.put("１之", 9);
    freq.put(" ﾟ∀", 52);
    freq.put("▿◝ ", 8);
    freq.put("丁月", 17);
    freq.put("侮あ", 135);
    freq.put(" 侮", 48);
    freq.put("両両之", 18);
    freq.put("๑", 411);
    freq.put("並丘あ", 161);
    freq.put(" 侶", 392);
    freq.put(" ﾌｫ", 16);
    freq.put("両両乙", 8);
    freq.put("あ三╰", 8);
    freq.put(" 侃", 13);
    freq.put("之アア", 412);
    freq.put("１丘", 20);
    freq.put("´∇｀", 13);
    freq.put("ア丘倉", 8);
    freq.put("１三", 25);
    freq.put("ﾅ", 27);
    freq.put("ﾝﾊﾞ", 15);
    freq.put("之伎あ", 8);
    freq.put("、仕", 16);
    freq.put("年之", 12);
    freq.put(" ´･", 198);
    freq.put("：", 454);
    freq.put("˘⊖", 11);
    freq.put("　ｽﾔ", 8);
    freq.put(" 乱あ", 130);
    freq.put("（≧∇", 43);
    freq.put(" ｶﾞ", 8);
    freq.put("■ア", 8);
    freq.put("、亀", 48);
    freq.put("三乙之", 21);
    freq.put("。ア ", 15);
    freq.put("年三", 58);
    freq.put("年丁", 11);
    freq.put(" ´；", 50);
    freq.put(" ≧▽", 56);
    freq.put("年並", 38);
    freq.put("、人", 19);
    freq.put("年両", 13);
    freq.put("（丁）", 10);
    freq.put("〜ああ", 98);
    freq.put("、之", 332);
    freq.put("∂）", 37);
    freq.put("町あ", 13);
    freq.put("、乙", 107);
    freq.put("、乞", 10);
    freq.put("人之あ", 13);
    freq.put("、乱", 46);
    freq.put("･ア", 26);
    freq.put("；´Д", 19);
    freq.put("、丁", 317);
    freq.put("、一", 26);
    freq.put("亀あ！", 13);
    freq.put("、万", 71);
    freq.put("、三", 442);
    freq.put("、丈", 46);
    freq.put("、丑", 30);
    freq.put("∑ ", 11);
    freq.put("あ丙丈", 8);
    freq.put("あ丙三", 11);
    freq.put("、丙", 15);
    freq.put("、丘", 168);
    freq.put("年亀", 32);
    freq.put("、両", 175);
    freq.put(" з ", 16);
    freq.put("、並", 265);
    freq.put("喫あ並", 14);
    freq.put("、丹", 25);
    freq.put("´ω｀", 55);
    freq.put("、丼", 8);
    freq.put("ﾝああ", 11);
    freq.put("あ並 ", 58);
    freq.put("三丘「", 10);
    freq.put("ﾙﾙ", 13);
    freq.put("０ ", 14);
    freq.put("∀；", 42);
    freq.put("あア꒰", 9);
    freq.put(" 가가", 66);
    freq.put("両倉", 110);
    freq.put("ฺ", 12);
    freq.put("∀＾", 12);
    freq.put("（日）", 8);
    freq.put("о", 30);
    freq.put("∀｀", 116);
    freq.put("あ喫あ", 24);
    freq.put("三丘あ", 189);
    freq.put(" ´︶", 11);
    freq.put("！三日", 13);
    freq.put("▇▅", 12);
    freq.put("ｧ ", 34);
    freq.put("▇█", 12);
    freq.put("∀･", 37);
    freq.put("┏━", 11);
    freq.put("┓三", 16);
    freq.put("、侶", 44);
    freq.put("┏┗", 37);
    freq.put("◠ ", 235);
    freq.put("！ア ", 11);
    freq.put("∀ﾟ", 61);
    freq.put("澤", 15);
    freq.put("三丘ア", 12);
    freq.put("人", 2615);
    freq.put("日（之", 9);
    freq.put("人的あ", 15);
    freq.put("三侶あ", 15);
    freq.put("丘並三", 37);
    freq.put("ﾄﾞｺ", 13);
    freq.put("佐 ", 16);
    freq.put("･д", 13);
    freq.put("丘々", 11);
    freq.put("ૢ", 18);
    freq.put("之日三", 30);
    freq.put("ア？あ", 15);
    freq.put("〜〜 ", 9);
    freq.put("伎", 586);
    freq.put("。丁あ", 39);
    freq.put("Д", 257);
    freq.put("〜", 776);
    freq.put("僅丈", 11);
    freq.put("之！", 95);
    freq.put("丘】", 31);
    freq.put("ああ大", 265);
    freq.put("之）", 93);
    freq.put("之（", 30);
    freq.put("之：", 104);
    freq.put("之？", 15);
    freq.put("●´ω", 8);
    freq.put("両丘 ", 8);
    freq.put("伎アア", 21);
    freq.put("╹ω╹", 11);
    freq.put("ｮ", 34);
    freq.put("▇▅▂", 12);
    freq.put(" Д ", 18);
    freq.put("アアｗ", 26);
    freq.put(" ５月", 9);
    freq.put("冲", 24);
    freq.put("あ、 ", 417);
    freq.put("之￥", 10);
    freq.put("＞アア", 10);
    freq.put("丁】 ", 65);
    freq.put("、伎", 21);
    freq.put("〃▽〃", 16);
    freq.put(" ◡ ", 23);
    freq.put("˂̶", 8);
    freq.put("並並！", 9);
    freq.put(" ŧ ", 15);
    freq.put("´๑ ", 11);
    freq.put("三あ！", 46);
    freq.put("？←", 11);
    freq.put("┐ ", 17);
    freq.put("三あ？", 16);
    freq.put("一之人", 9);
    freq.put(" Ａ", 12);
    freq.put("丁之的", 8);
    freq.put("ﾚｪ", 8);
    freq.put("あ」あ", 147);
    freq.put("３之", 8);
    freq.put("之】ア", 16);
    freq.put("٩꒰", 13);
    freq.put("（あ", 82);
    freq.put("之三 ", 113);
    freq.put("並→", 9);
    freq.put("』三", 11);
    freq.put("乙ア", 76);
    freq.put("３三", 19);
    freq.put("（三三", 9);
    freq.put("＃", 53);
    freq.put("三ア ", 13);
    freq.put("亀倉", 15);
    freq.put("ﾆ", 53);
    freq.put("∑", 12);
    freq.put("ﾘ", 68);
    freq.put("並： ", 11);
    freq.put("꒪", 34);
    freq.put("ア「 ", 13);
    freq.put("アア＆", 36);
    freq.put("（ア", 95);
    freq.put("乙」", 27);
    freq.put("乙「", 13);
    freq.put("乙』", 12);
    freq.put("乙、", 20);
    freq.put("乙　", 12);
    freq.put("／￣￣", 11);
    freq.put("乙。", 21);
    freq.put("乙々", 8);
    freq.put("之】あ", 9);
    freq.put("◔", 96);
    freq.put("乙】", 41);
    freq.put("∀｀ ", 101);
    freq.put("▅▂あ", 8);
    freq.put(" 「あ", 143);
    freq.put("並あ。", 35);
    freq.put("【 ", 129);
    freq.put("並あ　", 10);
    freq.put("ア侮あ", 8);
    freq.put("並あ「", 19);
    freq.put("ｿﾞ", 9);
    freq.put("三並】", 26);
    freq.put("アア３", 12);
    freq.put("￣ア", 28);
    freq.put("アア２", 10);
    freq.put("三並、", 11);
    freq.put("三並。", 10);
    freq.put("あ→あ", 9);
    freq.put("꒰๑", 8);
    freq.put("あ乩あ", 10);
    freq.put(" 之）", 56);
    freq.put("大佐ア", 9);
    freq.put("並ああ", 4947);
    freq.put("丑ア", 10);
    freq.put("あ？ ", 721);
    freq.put(" ﹏ ", 8);
    freq.put("█▓▒", 12);
    freq.put("三並あ", 651);
    freq.put("あ。侶", 19);
    freq.put("倉ア", 64);
    freq.put("アア１", 15);
    freq.put("「三之", 9);
    freq.put("三並ア", 172);
    freq.put("夙", 8);
    freq.put("倉あ", 2295);
    freq.put("日。あ", 16);
    freq.put("ﾉﾞ ", 14);
    freq.put("大佐あ", 29);
    freq.put("並あア", 248);
    freq.put("丑あ", 483);
    freq.put("ڼ", 10);
    freq.put(" 日（", 18);
    freq.put("「三丁", 9);
    freq.put("倉】", 12);
    freq.put("「三三", 16);
    freq.put("倉」", 28);
    freq.put("倉』", 13);
    freq.put("倉、", 17);
    freq.put("倉　", 11);
    freq.put("倉。", 22);
    freq.put("あ→ア", 13);
    freq.put("丹侶", 8);
    freq.put("?三?", 12);
    freq.put("「三並", 8);
    freq.put("「三両", 8);
    freq.put("あ「両", 12);
    freq.put("中国あ", 11);
    freq.put("丑」", 9);
    freq.put("?三 ", 8);
    freq.put("┳┻ ", 8);
    freq.put("あωあ", 11);
    freq.put("↓", 52);
    freq.put("且 ", 17);
    freq.put("丹之", 31);
    freq.put("三丁 ", 138);
    freq.put("丹 ", 49);
    freq.put("丹乙", 39);
    freq.put("「乱」", 20);
    freq.put("◉ ", 15);
    freq.put("あ之 ", 69);
    freq.put("丹両", 38);
    freq.put("丹並", 45);
    freq.put("！！←", 10);
    freq.put("꒪ ", 12);
    freq.put("･´", 34);
    freq.put("丹三", 56);
    freq.put(" 、丁", 21);
    freq.put("ﾛｰ", 38);
    freq.put("丹丁", 36);
    freq.put(" ￣ ", 127);
    freq.put(" ）（", 11);
    freq.put("丹丘", 25);
    freq.put("あ。人", 10);
    freq.put(" 丈あ", 102);
    freq.put("ああ年", 13);
    freq.put("あ。之", 81);
    freq.put("三万丁", 26);
    freq.put("ﾞﾄﾞ", 8);
    freq.put("〉", 19);
    freq.put("๑ ", 267);
    freq.put("並三両", 34);
    freq.put("並三並", 93);
    freq.put("あ。乙", 102);
    freq.put("丘あ！", 21);
    freq.put("。 ", 3026);
    freq.put("꒦", 8);
    freq.put("並三丘", 25);
    freq.put("並丼あ", 23);
    freq.put("ア丁乙", 9);
    freq.put("～！ ", 10);
    freq.put("並三丁", 69);
    freq.put("並三万", 26);
    freq.put("┻", 31);
    freq.put("並三三", 99);
    freq.put("ア丁之", 36);
    freq.put("あ。乱", 13);
    freq.put("あ。三", 99);
    freq.put("あ。丈", 11);
    freq.put("あ。万", 14);
    freq.put("あ丼両", 11);
    freq.put("･ ", 619);
    freq.put("あ。丁", 74);
    freq.put("あ。一", 11);
    freq.put("ア丁並", 63);
    freq.put("ｗ", 1946);
    freq.put("あ。丘", 41);
    freq.put("あ。丑", 9);
    freq.put("あ丼三", 10);
    freq.put("＿＿ ", 45);
    freq.put("丹亀", 9);
    freq.put("あ。両", 59);
    freq.put("三三丈", 9);
    freq.put("ア丁万", 16);
    freq.put("ω｀ ", 42);
    freq.put("あ。丹", 8);
    freq.put("ア丁丁", 30);
    freq.put("並三之", 110);
    freq.put("ア丁三", 48);
    freq.put("ﾁ", 81);
    freq.put("一丁あ", 8);
    freq.put("侶ア", 12);
    freq.put("̥ω ", 10);
    freq.put("６", 66);
    freq.put("└ ", 60);
    freq.put("◡ु", 15);
    freq.put("── ", 11);
    freq.put("･ω", 174);
    freq.put("▽", 837);
    freq.put("一乙あ", 19);
    freq.put("三」あ", 18);
    freq.put("５人", 8);
    freq.put("　丘丁", 193);
    freq.put("裏", 76);
    freq.put("！乙あ", 16);
    freq.put("之乙三", 8);
    freq.put("丘丈並", 15);
    freq.put("～～～", 22);
    freq.put("之的あ", 10);
    freq.put("、之日", 30);
    freq.put("∧＿", 21);
    freq.put("劈", 31);
    freq.put("ア之之", 26);
    freq.put("ア（乙", 21);
    freq.put("⊖˘", 11);
    freq.put("◡╹）", 16);
    freq.put("並」 ", 36);
    freq.put("侶", 1419);
    freq.put("ｳｩｯ", 8);
    freq.put("ア之万", 11);
    freq.put("ア之丁", 26);
    freq.put("之", 17657);
    freq.put("ア之三", 60);
    freq.put("≦） ", 17);
    freq.put(" 丘侶", 8);
    freq.put("並乙 ", 17);
    freq.put("ア之両", 8);
    freq.put("５三", 8);
    freq.put(" 人、", 11);
    freq.put(" 人　", 9);
    freq.put("人ア", 59);
    freq.put(" ｀ア", 16);
    freq.put("╯╭ ", 15);
    freq.put("！三万", 8);
    freq.put(" 丘之", 107);
    freq.put("三万之", 30);
    freq.put("＆ア", 36);
    freq.put("あ』 ", 24);
    freq.put("丘侶あ", 9);
    freq.put("　　＿", 8);
    freq.put("　　＼", 19);
    freq.put("あ∧ ", 20);
    freq.put("｀", 939);
    freq.put(" 丘中", 14);
    freq.put("両あ大", 8);
    freq.put("ωア ", 114);
    freq.put("乱之あ", 27);
    freq.put(" 丘両", 44);
    freq.put(" 丘並", 66);
    freq.put(" 人あ", 130);
    freq.put("▿ ", 19);
    freq.put(" 丘三", 129);
    freq.put(" 丘丈", 15);
    freq.put("三丹あ", 18);
    freq.put(" 丘丁", 115);
    freq.put(" 並侶", 12);
    freq.put(" 丘万", 19);
    freq.put("万あ並", 58);
    freq.put(" 丘丘", 43);
    freq.put(" 丹三", 10);
    freq.put("両丁三", 27);
    freq.put("～　", 14);
    freq.put("Ｏ＾）", 8);
    freq.put("ᴗ", 58);
    freq.put("人「", 15);
    freq.put(" 乙", 1633);
    freq.put("̴̶", 17);
    freq.put("人　", 12);
    freq.put("人、", 39);
    freq.put("人。", 12);
    freq.put(" 乞", 65);
    freq.put("乞ああ", 235);
    freq.put(" 丘人", 14);
    freq.put("＆あ", 10);
    freq.put("⇔", 8);
    freq.put(" ≧∀", 13);
    freq.put("ωア´", 17);
    freq.put("·˚ ", 11);
    freq.put(" 丘亀", 8);
    freq.put("人あ", 1083);
    freq.put("倉あ三", 108);
    freq.put("　　", 1058);
    freq.put("喫あ", 40);
    freq.put("倉あ丁", 57);
    freq.put("アアあ", 7914);
    freq.put("　「", 50);
    freq.put("倉あ万", 17);
    freq.put("倉あ丘", 21);
    freq.put("　【", 26);
    freq.put("　】", 8);
    freq.put("⌒ア", 47);
    freq.put(" （ ", 34);
    freq.put("倉あ中", 9);
    freq.put("倉あ両", 57);
    freq.put("ω˘ ", 71);
    freq.put("之々あ", 39);
    freq.put("倉あ並", 59);
    freq.put(" 万あ", 142);
    freq.put("アア』", 148);
    freq.put("アア『", 31);
    freq.put("アア」", 180);
    freq.put("アア「", 166);
    freq.put("ु⁾⁾", 14);
    freq.put("アア。", 193);
    freq.put("アア、", 245);
    freq.put("アア　", 158);
    freq.put("　三三", 23);
    freq.put("アア〜", 27);
    freq.put("　三丁", 13);
    freq.put("アア】", 247);
    freq.put("アア【", 40);
    freq.put("あ丈倉", 10);
    freq.put(" ˙", 55);
    freq.put("↓↓", 10);
    freq.put("ｪ", 48);
    freq.put("両並 ", 80);
    freq.put("之並ア", 55);
    freq.put("三人三", 22);
    freq.put("倉あ乱", 9);
    freq.put("４あ", 10);
    freq.put("倉あ亀", 8);
    freq.put("ｵｱ", 10);
    freq.put("丘万 ", 14);
    freq.put("之並あ", 772);
    freq.put("∗", 11);
    freq.put(" ア乙", 18);
    freq.put("、三あ", 66);
    freq.put("　ア", 236);
    freq.put("ﾜｸ", 8);
    freq.put("あ｀ ", 10);
    freq.put("倉あ人", 11);
    freq.put("あ丁 ", 96);
    freq.put("ア３ ", 9);
    freq.put("乙之あ", 113);
    freq.put(" ア万", 8);
    freq.put(" ア丁", 31);
    freq.put("之並】", 22);
    freq.put("丁倉", 280);
    freq.put(" ア三", 29);
    freq.put(" ア丈", 21);
    freq.put("之並。", 17);
    freq.put("之並、", 13);
    freq.put("之並「", 9);
    freq.put(" ア丘", 24);
    freq.put("╯╭", 16);
    freq.put(" ア並", 20);
    freq.put(" ア両", 14);
    freq.put("アアア", 40609);
    freq.put("一人あ", 45);
    freq.put("乱丁あ", 34);
    freq.put("▽〃 ", 17);
    freq.put("இ", 40);
    freq.put("ﾁｷﾁ", 9);
    freq.put(" 三乙", 35);
    freq.put(" 　　", 419);
    freq.put("倹あ", 87);
    freq.put(" 　「", 26);
    freq.put(" あ◔", 11);
    freq.put(" 三之", 500);
    freq.put("日並 ", 22);
    freq.put("´Д ", 54);
    freq.put("¥ ", 17);
    freq.put("／＼", 11);
    freq.put(" 三中", 11);
    freq.put(" 三両", 131);
    freq.put(" 三並", 292);
    freq.put("／／", 16);
    freq.put(" 　あ", 65);
    freq.put(" 三丈", 19);
    freq.put(" 三三", 634);
    freq.put("／＜", 8);
    freq.put("･･･", 52);
    freq.put(" 三丁", 371);
    freq.put(" 三万", 173);
    freq.put(" 　ア", 43);
    freq.put("：三", 17);
    freq.put("⊂", 90);
    freq.put("三～", 13);
    freq.put(" 倣丁", 10);
    freq.put("／￣", 13);
    freq.put("▂ああ", 8);
    freq.put("ﾔ", 53);
    freq.put("ﾟああ", 17);
    freq.put("▒░", 12);
    freq.put("▒▓", 12);
    freq.put("丁」あ", 12);
    freq.put(" 三仕", 36);
    freq.put("三万 ", 38);
    freq.put("　並之", 12);
    freq.put(" 三人", 31);
    freq.put("̫͡ ", 9);
    freq.put("両丁 ", 22);
    freq.put("三？", 21);
    freq.put("丁亀あ", 55);
    freq.put("三５", 8);
    freq.put("的あ並", 15);
    freq.put("三）", 42);
    freq.put("三（", 31);
    freq.put("　並並", 9);
    freq.put("三！", 117);
    freq.put("的あ丁", 9);
    freq.put("之あ！", 21);
    freq.put(" ￥ ", 32);
    freq.put("　並丁", 9);
    freq.put("あ侶 ", 8);
    freq.put("之あ？", 14);
    freq.put(" 三亀", 30);
    freq.put("∀", 499);
    freq.put("ア】 ", 101);
    freq.put("「", 2104);
    freq.put("ﾝﾄ", 9);
    freq.put("倉並 ", 12);
    freq.put("ﾝﾊ", 18);
    freq.put("日弁日", 18);
    freq.put("丁之侶", 9);
    freq.put("日両両", 27);
    freq.put("｣ ", 35);
    freq.put(" ･∀", 18);
    freq.put("万：", 24);
    freq.put("嗅あ", 46);
    freq.put(" ◝ ", 10);
    freq.put(" 丼あ", 67);
    freq.put("×", 126);
    freq.put("ﾟ▽ﾟ", 139);
    freq.put("三】ア", 32);
    freq.put("́", 73);
    freq.put("日三 ", 20);
    freq.put("（　", 9);
    freq.put("三】あ", 20);
    freq.put("並之丘", 37);
    freq.put("之」 ", 44);
    freq.put("▽⌒ ", 22);
    freq.put("三】『", 8);
    freq.put("アдア", 18);
    freq.put("丘乱あ", 8);
    freq.put("≫", 14);
    freq.put("ﾝｸ", 63);
    freq.put("ﾝｯ", 9);
    freq.put("、丁人", 11);
    freq.put("並丘中", 10);
    freq.put("丘丁、", 12);
    freq.put("並丘並", 18);
    freq.put("並丘両", 14);
    freq.put("༎ຶ", 16);
    freq.put("丞", 44);
    freq.put("ﾚｼ", 10);
    freq.put("亀乙", 30);
    freq.put("之中！", 8);
    freq.put("並丘三", 13);
    freq.put("並丘丁", 21);
    freq.put("あ万あ", 547);
    freq.put("兌", 61);
    freq.put("三之国", 8);
    freq.put("倉丁あ", 144);
    freq.put("月あ", 96);
    freq.put("丘丁あ", 211);
    freq.put("▿", 42);
    freq.put("並丘之", 9);
    freq.put("あ」 ", 300);
    freq.put("丁之丘", 10);
    freq.put("ω＾ ", 109);
    freq.put("丁之三", 89);
    freq.put("あ兌倉", 22);
    freq.put("両之ア", 20);
    freq.put("丁之丁", 28);
    freq.put("２ああ", 11);
    freq.put("あ！倉", 8);
    freq.put("伎三", 11);
    freq.put("あ万ア", 15);
    freq.put("並！", 95);
    freq.put("伎丁", 24);
    freq.put("̫", 45);
    freq.put("ア）ア", 8);
    freq.put("ア＼ ", 30);
    freq.put("倉丁ア", 15);
    freq.put("伎丘", 9);
    freq.put("丁之中", 23);
    freq.put("月ア", 11);
    freq.put("丁之両", 17);
    freq.put("丁之並", 35);
    freq.put("⑅", 8);
    freq.put("倉両 ", 11);
    freq.put("丁之之", 47);
    freq.put("ｓ", 10);
    freq.put("▽ ", 356);
    freq.put("丁あ ", 263);
    freq.put("伎之", 32);
    freq.put("丁！ ", 28);
    freq.put("ア』→", 94);
    freq.put("╯", 54);
    freq.put("◆ ", 15);
    freq.put("伎乙", 10);
    freq.put("一丁", 28);
    freq.put("ฅω", 9);
    freq.put("一万", 24);
    freq.put("ああ月", 21);
    freq.put("一丈", 21);
    freq.put("一三", 137);
    freq.put("！万あ", 13);
    freq.put("２", 168);
    freq.put("一丘", 104);
    freq.put("並中あ", 19);
    freq.put("ﾞｹ", 10);
    freq.put("ﾞｺ", 14);
    freq.put("一両", 55);
    freq.put("ﾞｼ", 12);
    freq.put("ﾞｰ", 34);
    freq.put("ﾞｱ", 11);
    freq.put("ﾞｲ", 25);
    freq.put("ﾞｶ", 9);
    freq.put("丘乙あ", 66);
    freq.put("ﾞｫ", 9);
    freq.put("ﾞｬ", 15);
    freq.put("ﾞｯ", 20);
    freq.put("あ丘ア", 20);
    freq.put("丘倉", 127);
    freq.put("一之", 112);
    freq.put("Д｀ ", 42);
    freq.put("一乙", 44);
    freq.put("丘倣", 9);
    freq.put("丑あ ", 8);
    freq.put(" ̀๑", 9);
    freq.put("一亀", 15);
    freq.put("万", 4667);
    freq.put("～三", 12);
    freq.put("あ丘、", 10);
    freq.put(" ＊ ", 13);
    freq.put("丁丑あ", 14);
    freq.put("一人", 68);
    freq.put(" 万之", 92);
    freq.put("～並", 9);
    freq.put("ﾞﾙ", 15);
    freq.put("ﾞﾛ", 8);
    freq.put("ﾞﾝ", 37);
    freq.put("ﾞﾗ", 27);
    freq.put(" 万並", 53);
    freq.put("～之", 10);
    freq.put(" 万両", 56);
    freq.put("あ丘あ", 1288);
    freq.put("ﾞﾄ", 11);
    freq.put("×丘", 8);
    freq.put("ア中あ", 10);
    freq.put("×並", 8);
    freq.put("！大", 12);
    freq.put("あｗｗ", 173);
    freq.put(" 万万", 27);
    freq.put("･´ ", 28);
    freq.put("２あ", 14);
    freq.put(" 万丁", 61);
    freq.put("ｽ", 105);
    freq.put(" 万三", 81);
    freq.put("─", 100);
    freq.put(" 。ア", 17);
    freq.put(" 両】", 8);
    freq.put("あ＞＜", 8);
    freq.put("ああ是", 9);
    freq.put("＼", 509);
    freq.put("丈乙あ", 15);
    freq.put("乙あ", 1991);
    freq.put(" 両日", 35);
    freq.put("、あア", 35);
    freq.put("日）", 14);
    freq.put("日（", 20);
    freq.put("日！", 20);
    freq.put("´ิ∀", 17);
    freq.put("、ああ", 1502);
    freq.put("ｮｵｱ", 8);
    freq.put("）之", 14);
    freq.put(" 両ア", 31);
    freq.put(" 。。", 8);
    freq.put("侶倉", 8);
    freq.put("倉之丁", 10);
    freq.put("倹", 101);
    freq.put("三之倉", 18);
    freq.put("ਊ ", 107);
    freq.put("ㅤㅤㅤ", 11);
    freq.put("、あ、", 33);
    freq.put("ﾄあ", 16);
    freq.put("）三", 16);
    freq.put("╹", 225);
    freq.put("ｧｧｧ", 19);
    freq.put("）丁", 9);
    freq.put("ア両丁", 12);
    freq.put("乙三 ", 32);
    freq.put(" 。あ", 25);
    freq.put("侶丘あ", 11);
    freq.put("あ伎 ", 10);
    freq.put("丘冴", 10);
    freq.put("ʃ", 17);
    freq.put("「之三", 10);
    freq.put("丁乙あ", 79);
    freq.put("▼ ", 10);
    freq.put("「之並", 9);
    freq.put(" ﹏", 8);
    freq.put("「之両", 9);
    freq.put(" 月三", 17);
    freq.put(" 月丁", 9);
    freq.put(" 月万", 14);
    freq.put("´ฅω", 8);
    freq.put("ㅤㅤ", 12);
    freq.put("あ両人", 11);
    freq.put("両万 ", 20);
    freq.put("ᵒ", 14);
    freq.put("ʕ ", 17);
    freq.put("ﾟｰ", 13);
    freq.put("ﾟｯ", 9);
    freq.put("ﾟ･", 82);
    freq.put("ﾟ｡", 67);
    freq.put("ﾟﾟ", 10);
    freq.put("□ ", 11);
    freq.put("▂", 24);
    freq.put("ﾟﾛ", 12);
    freq.put(" Σ", 21);
    freq.put("国ア", 28);
    freq.put("あ｣ ", 11);
    freq.put("傭ああ", 22);
    freq.put("՞ਊ", 103);
    freq.put("人　 ", 9);
    freq.put("┣━", 10);
    freq.put("あ両乙", 19);
    freq.put("之万あ", 104);
    freq.put("あ】 ", 65);
    freq.put("＊ ", 33);
    freq.put("あ両之", 171);
    freq.put("｡ ", 573);
    freq.put("＜アア", 21);
    freq.put("◡ु ", 14);
    freq.put("あ＼ ", 142);
    freq.put("ア」⇒", 22);
    freq.put("あ両両", 183);
    freq.put("人並あ", 91);
    freq.put(" ◟ ", 11);
    freq.put("１０", 42);
    freq.put("之是之", 9);
    freq.put("１２", 11);
    freq.put("１５", 10);
    freq.put(" あ∀", 11);
    freq.put("丘並 ", 23);
    freq.put("ああ日", 126);
    freq.put("･∀･", 33);
    freq.put("あ両丘", 38);
    freq.put("あ両万", 17);
    freq.put("あ両丁", 134);
    freq.put("あ両三", 163);
    freq.put(" 侶丁", 15);
    freq.put(" ｣", 21);
    freq.put(" ｡", 558);
    freq.put(" ､", 30);
    freq.put(" ･", 465);
    freq.put(" 侶三", 11);
    freq.put(" ｲ", 14);
    freq.put("、あ丘", 8);
    freq.put(" ｰ", 36);
    freq.put(" ｱ", 33);
    freq.put(" ｶ", 16);
    freq.put(" ｷ", 37);
    freq.put(" ｵ", 8);
    freq.put("⊙", 53);
    freq.put("丁丘之", 18);
    freq.put(" ｸ", 18);
    freq.put(" ｼ", 18);
    freq.put(" ｽ", 25);
    freq.put(" ｀", 214);
    freq.put(" 侶並", 56);
    freq.put(" ｉ", 23);
    freq.put(" ｏ", 11);
    freq.put(" ■乱", 8);
    freq.put(" ｗ", 25);
    freq.put(" ～", 126);
    freq.put(" ｜", 52);
    freq.put(" ＠", 44);
    freq.put("̸̸̸", 22);
    freq.put("」∠ ", 46);
    freq.put(" Ｊ", 11);
    freq.put("丁丘丘", 8);
    freq.put(" Ｏ", 12);
    freq.put(" Ｒ", 8);
    freq.put("あ？？", 99);
    freq.put("丁丘丁", 32);
    freq.put(" Ｔ", 10);
    freq.put(" ［", 17);
    freq.put("丁丘三", 20);
    freq.put(" ＾", 154);
    freq.put(" ＿", 194);
    freq.put(" ＼", 142);
    freq.put("´▽｀", 92);
    freq.put(" ＃", 37);
    freq.put(" ！", 326);
    freq.put("ㅤ", 13);
    freq.put(" ％", 40);
    freq.put(" ＊", 47);
    freq.put(" ＋", 19);
    freq.put(" （", 227);
    freq.put(" ）", 157);
    freq.put(" ／", 411);
    freq.put(" ２", 34);
    freq.put(" ３", 27);
    freq.put(" １", 61);
    freq.put("丁丘並", 15);
    freq.put(" ７", 11);
    freq.put(" ４", 15);
    freq.put(" ５", 24);
    freq.put(" ：", 31);
    freq.put(" ；", 139);
    freq.put(" ＞", 117);
    freq.put(" ？", 128);
    freq.put(" ＜", 103);
    freq.put(" ＝", 24);
    freq.put(" ￣", 395);
    freq.put("丁坂", 11);
    freq.put("あ１あ", 11);
    freq.put(" ￥", 34);
    freq.put("ﾐ", 47);
    freq.put("┗", 124);
    freq.put("౪◟◉", 8);
    freq.put("艸 ", 24);
    freq.put("倉万あ", 28);
    freq.put(" ﾃ", 12);
    freq.put(" ³˘", 8);
    freq.put(" ﾁ", 17);
    freq.put(" ﾆ", 26);
    freq.put(" ﾄ", 18);
    freq.put("あ５", 25);
    freq.put(" ﾊ", 29);
    freq.put(" ﾉ", 512);
    freq.put("ฅ ", 28);
    freq.put(" ﾌ", 57);
    freq.put(" ﾐ", 22);
    freq.put(" ˖", 13);
    freq.put("両倉三", 11);
    freq.put(" ﾗ", 10);
    freq.put("ア｡ ", 11);
    freq.put(" ﾛ", 9);
    freq.put(" ﾟ", 563);
    freq.put("가가", 176);
    freq.put("ア三三", 90);
    freq.put("ア三万", 25);
    freq.put("ア三丁", 29);
    freq.put("【", 1612);
    freq.put("´◡ ", 10);
    freq.put("ω＼ ", 14);
    freq.put("ア三並", 63);
    freq.put("あ８", 9);
    freq.put("丘」 ", 15);
    freq.put("。アあ", 10);
    freq.put("ア三両", 17);
    freq.put("˙³˙", 13);
    freq.put("ᵒ̴", 9);
    freq.put("ア三之", 94);
    freq.put("▂あ", 8);
    freq.put("丈三 ", 11);
    freq.put("あ＠", 11);
    freq.put("之） ", 74);
    freq.put("三的", 58);
    freq.put(" ˚", 15);
    freq.put("並あ、", 76);
    freq.put("･ิ ", 10);
    freq.put("´∀ ", 43);
    freq.put("■ ", 19);
    freq.put("日亀あ", 12);
    freq.put("。アア", 183);
    freq.put("﹏", 18);
    freq.put("◞", 43);
    freq.put("〜あ ", 21);
    freq.put("｀･ω", 16);
    freq.put("丁倉 ", 26);
    freq.put("』ああ", 58);
    freq.put("。（三", 55);
    freq.put("あ並、", 21);
    freq.put("三丘 ", 53);
    freq.put(" ；∀", 36);
    freq.put(" ﾟд", 13);
    freq.put("両】 ", 29);
    freq.put("？あ？", 10);
    freq.put("亀あ亀", 10);
    freq.put(" ₃ ", 10);
    freq.put("佐ア", 11);
    freq.put("あ並あ", 2462);
    freq.put("７日", 8);
    freq.put("。（乙", 12);
    freq.put("ｼﾝｸ", 44);
    freq.put("あ並ア", 15);
    freq.put("ฅ", 49);
    freq.put("ア？ ", 44);
    freq.put("丈亀あ", 14);
    freq.put("亀あ之", 36);
    freq.put("亀あ乙", 9);
    freq.put("万あ乱", 11);
    freq.put("´･∀", 12);
    freq.put("佐あ", 30);
    freq.put("??", 20);
    freq.put("亀あ丁", 38);
    freq.put("〜〜〜", 40);
    freq.put("亙あ", 53);
    freq.put("亀あ三", 50);
    freq.put("丘三ア", 17);
    freq.put("ｏ", 16);
    freq.put("、１", 12);
    freq.put("亀あ丘", 26);
    freq.put("? ", 9);
    freq.put("ｰﾄﾞ", 14);
    freq.put("亀あ並", 32);
    freq.put("亀あ両", 13);
    freq.put("◉◞౪", 9);
    freq.put("▽； ", 27);
    freq.put(" ̀ω", 18);
    freq.put("丁並之", 84);
    freq.put("』あア", 12);
    freq.put("！→", 9);
    freq.put(" ﾟД", 41);
    freq.put("三あ丈", 30);
    freq.put("両両", 622);
    freq.put(" ̀ ", 15);
    freq.put("三あ一", 39);
    freq.put("三あ丁", 346);
    freq.put("．", 24);
    freq.put("三あ丘", 140);
    freq.put("三あ丙", 8);
    freq.put("三あ丑", 11);
    freq.put(" ´◔", 12);
    freq.put("三あ両", 146);
    freq.put("之伎", 16);
    freq.put("三あ並", 364);
    freq.put("両丘あ", 84);
    freq.put("三あ丹", 21);
    freq.put("あ、ア", 331);
    freq.put("あ꒰ ", 27);
    freq.put("ू", 43);
    freq.put(" 爬", 16);
    freq.put("三あ乙", 96);
    freq.put("丁】ア", 17);
    freq.put("３０", 20);
    freq.put("三あ乱", 32);
    freq.put("三あ亀", 56);
    freq.put("之侮", 10);
    freq.put("之侶", 110);
    freq.put("あ、、", 47);
    freq.put("あ、『", 9);
    freq.put("あ、「", 18);
    freq.put("՞ة", 9);
    freq.put("三あ人", 38);
    freq.put("あ、あ", 1440);
    freq.put("三あ仕", 11);
    freq.put("両万", 107);
    freq.put("、伎あ", 17);
    freq.put("あ꒰", 36);
    freq.put("ｹ", 36);
    freq.put("之両", 598);
    freq.put("━━┓", 12);
    freq.put("三アア", 548);
    freq.put("∇＾）", 8);
    freq.put("之中", 83);
    freq.put("万あ倉", 25);
    freq.put("あ｡ ", 25);
    freq.put("之丹", 27);
    freq.put("亙ああ", 38);
    freq.put("之丼", 10);
    freq.put("之丁", 909);
    freq.put("之一", 24);
    freq.put("之万", 262);
    freq.put("三両之", 24);
    freq.put(" ﾄﾞ", 11);
    freq.put("之三", 1498);
    freq.put("之丈", 39);
    freq.put("之丑", 16);
    freq.put("あ是之", 25);
    freq.put("之且", 22);
    freq.put("之三あ", 616);
    freq.put("（ ", 180);
    freq.put("之丘", 526);
    freq.put("三両並", 50);
    freq.put("三両両", 26);
    freq.put("Σ･", 10);
    freq.put("あ└", 9);
    freq.put("之乱", 37);
    freq.put("あ┗", 11);
    freq.put(" ͈ ", 14);
    freq.put(" 一あ", 10);
    freq.put("三両三", 60);
    freq.put(" ┌ ", 11);
    freq.put("之之", 975);
    freq.put("之三】", 8);
    freq.put("三両丁", 15);
    freq.put("之三「", 28);
    freq.put("之三。", 12);
    freq.put("之乙", 122);
    freq.put("あ◆", 8);
    freq.put("＜ああ", 16);
    freq.put("人三 ", 9);
    freq.put("７月", 8);
    freq.put("あ◔", 11);
    freq.put("圓", 39);
    freq.put(" ＾∀", 11);
    freq.put("･ิω", 10);
    freq.put("之亀", 112);
    freq.put("（´", 29);
    freq.put("之】 ", 26);
    freq.put("三あ侶", 25);
    freq.put("国あ", 72);
    freq.put("侶並あ", 264);
    freq.put("之三ア", 63);
    freq.put("三町", 12);
    freq.put("乙 ", 1157);
    freq.put("之仕", 20);
    freq.put("가", 263);
    freq.put("ﾁあ", 8);
    freq.put("Ｍ", 19);
    freq.put("あ？あ", 153);
    freq.put("三並 ", 339);
    freq.put("丘あ亀", 22);
    freq.put("丘あ人", 10);
    freq.put("੭ु⁾", 16);
    freq.put("【　", 8);
    freq.put("並あ ", 332);
    freq.put("ε", 101);
    freq.put("あ∀", 12);
    freq.put("あ？」", 104);
    freq.put("あ？』", 8);
    freq.put("▃▃", 18);
    freq.put("ω･´", 25);
    freq.put("あ→ ", 17);
    freq.put("｢", 57);
    freq.put(" 「 ", 44);
    freq.put("【あ", 109);
    freq.put("･∴ ", 10);
    freq.put("両之", 451);
    freq.put("丘あ丘", 57);
    freq.put("倣倣", 9);
    freq.put("丘あ丑", 10);
    freq.put("╬", 20);
    freq.put("【ア", 273);
    freq.put("◡╹", 50);
    freq.put(" ﾛ ", 9);
    freq.put("丘あ三", 204);
    freq.put("丘あ万", 31);
    freq.put("丘あ丁", 110);
    freq.put("】乙", 10);
    freq.put("σ ", 23);
    freq.put("꒰", 76);
    freq.put("並三！", 18);
    freq.put("５月２", 8);
    freq.put("՞ ", 104);
    freq.put("】之", 36);
    freq.put("並三）", 14);
    freq.put("丘あ両", 100);
    freq.put("̥̥ ", 13);
    freq.put("両日", 108);
    freq.put("あ⊂", 9);
    freq.put("あ。（", 75);
    freq.put("大佐 ", 13);
    freq.put("】両", 14);
    freq.put("両乙", 73);
    freq.put("丘丘並", 8);
    freq.put("丘あ之", 104);
    freq.put("】並", 32);
    freq.put("ω･ ", 135);
    freq.put("д｀", 13);
    freq.put("之丁丘", 13);
    freq.put("】丘", 19);
    freq.put("あ？ア", 18);
    freq.put("丘あ乱", 12);
    freq.put("】丁", 45);
    freq.put("丘丘丁", 12);
    freq.put("人三あ", 80);
    freq.put("】万", 8);
    freq.put("】三", 45);
    freq.put("倉 ", 195);
    freq.put("丘丘三", 8);
    freq.put("д･", 15);
    freq.put("ु⁾", 16);
    freq.put("三丁「", 12);
    freq.put(" 之之", 207);
    freq.put("三丁、", 10);
    freq.put("三丁。", 12);
    freq.put(" 之乙", 24);
    freq.put("˖ ", 13);
    freq.put("あ之あ", 2433);
    freq.put("並丑あ", 15);
    freq.put("三】丁", 13);
    freq.put("丘あ侶", 11);
    freq.put("。之日", 24);
    freq.put(" 之丁", 178);
    freq.put("日あ亀", 16);
    freq.put(" 之万", 35);
    freq.put(" 之丈", 11);
    freq.put(" 之三", 267);
    freq.put("三丁あ", 337);
    freq.put("あ⌒", 9);
    freq.put(" 之丘", 124);
    freq.put(" 「ア", 93);
    freq.put("あ之々", 25);
    freq.put(" 之両", 127);
    freq.put(" 之並", 289);
    freq.put("あ之、", 12);
    freq.put("あ之。", 14);
    freq.put("丘大", 16);
    freq.put("且あ", 32);
    freq.put("。　", 73);
    freq.put("。。", 187);
    freq.put(" 日之", 16);
    freq.put("。「", 17);
    freq.put("。」", 41);
    freq.put("。』", 14);
    freq.put("ﾌ", 165);
    freq.put("日あ之", 56);
    freq.put("。【", 24);
    freq.put("乞」", 10);
    freq.put(" 之仕", 9);
    freq.put("┛", 128);
    freq.put("伎あ並", 18);
    freq.put("伎あ丘", 33);
    freq.put("⊙ ", 27);
    freq.put("中", 773);
    freq.put("三丁ア", 131);
    freq.put("伎あ三", 27);
    freq.put("◇ ", 15);
    freq.put("伎あ丁", 14);
    freq.put(" 之亀", 20);
    freq.put("日あ万", 25);
    freq.put("日あ一", 14);
    freq.put(" 日三", 86);
    freq.put("あ之ア", 37);
    freq.put("！倉", 15);
    freq.put(" 日丁", 9);
    freq.put("ア｀ ", 72);
    freq.put(" 日丘", 9);
    freq.put("＾ω＾", 140);
    freq.put("乞あ", 254);
    freq.put("日あ丘", 34);
    freq.put("｀ ", 768);
    freq.put("日あ両", 25);
    freq.put(" ￣ア", 27);
    freq.put(" 日並", 26);
    freq.put(" 日両", 24);
    freq.put("伎あ之", 26);
    freq.put(" 之人", 10);
    freq.put(" 並乙", 33);
    freq.put("　　三", 11);
    freq.put("｀ω", 34);
    freq.put("〔", 12);
    freq.put("　∧ ", 9);
    freq.put(" 並之", 253);
    freq.put("。丘あ", 28);
    freq.put("๑´", 60);
    freq.put(" 並乱", 10);
    freq.put("三」 ", 14);
    freq.put(" ̥̥", 32);
    freq.put("あ大之", 12);
    freq.put("⌒ア⌒", 29);
    freq.put("あ大乙", 12);
    freq.put(" 並丑", 8);
    freq.put("あ大両", 28);
    freq.put(" 並丘", 77);
    freq.put(" 並丁", 130);
    freq.put(" 並万", 40);
    freq.put(" 並三", 269);
    freq.put(" 並丈", 9);
    freq.put("あ大丼", 18);
    freq.put("あ大丁", 156);
    freq.put("あ大万", 25);
    freq.put("ア･ア", 17);
    freq.put("あ大三", 47);
    freq.put(" 並両", 94);
    freq.put(" 並並", 282);
    freq.put("並乙あ", 76);
    freq.put("あ的あ", 16);
    freq.put(" ；▽", 27);
    freq.put("Ａ", 19);
    freq.put(" 丹日", 86);
    freq.put("！並あ", 12);
    freq.put(" ´๑", 10);
    freq.put("丁年", 28);
    freq.put("ｱｱｧ", 15);
    freq.put("ア꒰ ", 9);
    freq.put("、丁倉", 8);
    freq.put(" 並亀", 23);
    freq.put("ｱｱｱ", 138);
    freq.put("あ大人", 16);
    freq.put("（＾Ｏ", 10);
    freq.put(" ＞＞", 9);
    freq.put(" 並人", 19);
    freq.put("並」あ", 12);
    freq.put("　⊂", 15);
    freq.put("ﾟд", 33);
    freq.put("あ「乙", 9);
    freq.put("三丹 ", 8);
    freq.put("あ「之", 28);
    freq.put("侃ああ", 28);
    freq.put("─ ", 19);
    freq.put("あ「乱", 9);
    freq.put(" 人 ", 47);
    freq.put("あ大佐", 14);
    freq.put("；＿；", 28);
    freq.put("ｸﾚｪ", 8);
    freq.put("ア乱あ", 19);
    freq.put("あ「丘", 18);
    freq.put("◇", 29);
    freq.put("倉丘あ", 37);
    freq.put(" ⊃ ", 23);
    freq.put("∀･ ", 20);
    freq.put("ア万あ", 57);
    freq.put("あ「三", 12);
    freq.put("あ三 ", 104);
    freq.put("あ』あ", 21);
    freq.put("あ「丁", 21);
    freq.put(" ！！", 60);
    freq.put(" ՞", 209);
    freq.put("あ「並", 16);
    freq.put("あ丹あ", 94);
    freq.put(" 〜（", 35);
    freq.put("人 ", 152);
    freq.put("乱並あ", 29);
    freq.put("´･ω", 78);
    freq.put(" ╹ ", 57);
    freq.put("！！乙", 24);
    freq.put("「亀あ", 10);
    freq.put("̥̥̥", 167);
    freq.put("丁弁", 30);
    freq.put("亀」 ", 13);
    freq.put("、亀あ", 25);
    freq.put("ｋ", 8);
    freq.put("あ←", 118);
    freq.put("あ→", 79);
    freq.put("あ。亀", 11);
    freq.put("「亀」", 13);
    freq.put("丁並倉", 8);
    freq.put("═", 8);
    freq.put("ᴗ ", 48);
    freq.put("５０", 15);
    freq.put("͈ ", 29);
    freq.put("┳ ", 10);
    freq.put(" 乙あ", 340);
    freq.put("　", 4927);
    freq.put("ω；", 49);
    freq.put("ω＜", 8);
    freq.put("＊", 92);
    freq.put(" ･あ", 66);
    freq.put("ｲｸﾝ", 8);
    freq.put("＜之", 10);
    freq.put("ω＼", 15);
    freq.put("ω＾", 140);
    freq.put("爬", 59);
    freq.put("＾＾ ", 14);
    freq.put("ｩｯﾋ", 8);
    freq.put("∧＿∧", 19);
    freq.put("｀ア", 22);
    freq.put("ｸ ", 12);
    freq.put("｀●", 18);
    freq.put("ア！ア", 68);
    freq.put(" 並倉", 45);
    freq.put("ω｀", 55);
    freq.put(" ≡ ", 39);
    freq.put(" ๑´", 60);
    freq.put("ω･", 193);
    freq.put("乙両あ", 66);
    freq.put("／　　", 15);
    freq.put("的", 179);
    freq.put("ωﾟ", 23);
    freq.put("、丁之", 32);
    freq.put("（三日", 56);
    freq.put("之之 ", 75);
    freq.put("　ﾟд", 8);
    freq.put("ﾄああ", 12);
    freq.put("両々あ", 11);
    freq.put("ア！あ", 68);
    freq.put("倉三あ", 136);
    freq.put("、丁丁", 36);
    freq.put("、丁三", 32);
    freq.put("あ侃あ", 23);
    freq.put("ｪｪ", 9);
    freq.put("、丁並", 25);
    freq.put("、丁両", 14);
    freq.put(" 『 ", 17);
    freq.put(" ๑ ", 194);
    freq.put("ｵ", 119);
    freq.put("ア！」", 25);
    freq.put("ア万之", 23);
    freq.put(" 三年", 11);
    freq.put("̥ ", 18);
    freq.put("倖", 159);
    freq.put("△｀", 11);
    freq.put("ﾟ", 1323);
    freq.put("あ← ", 63);
    freq.put("あ亥あ", 9);
    freq.put("あ乱人", 8);
    freq.put("「」", 14);
    freq.put("Ｔ", 28);
    freq.put("亀丁 ", 10);
    freq.put("丘三あ", 211);
    freq.put("々あア", 9);
    freq.put("之丘ア", 14);
    freq.put("ア｜", 8);
    freq.put("万両三", 12);
    freq.put(" 乙「", 8);
    freq.put("「あ", 532);
    freq.put("万両並", 9);
    freq.put("之呟", 57);
    freq.put("「ア", 270);
    freq.put("「両」", 19);
    freq.put("あ日 ", 10);
    freq.put("՞ਊ՞", 8);
    freq.put("あ亀之", 20);
    freq.put("アア⇒", 14);
    freq.put("┣", 13);
    freq.put("両あ並", 82);
    freq.put("々ああ", 62);
    freq.put("＼＼＼", 12);
    freq.put(" ∧＿", 11);
    freq.put("之丘あ", 273);
    freq.put("」アア", 30);
    freq.put("丁並乙", 12);
    freq.put("̷", 22);
    freq.put("大あ", 99);
    freq.put("━━━", 93);
    freq.put("あ亀丘", 54);
    freq.put("丁並並", 45);
    freq.put("丁並両", 44);
    freq.put("あ亀丁", 18);
    freq.put(" 丑あ", 77);
    freq.put("あ亀万", 61);
    freq.put("あ亀三", 36);
    freq.put("アア→", 65);
    freq.put("━━┛", 11);
    freq.put("丁並三", 80);
    freq.put("╮╯", 16);
    freq.put("丁並丁", 110);
    freq.put("＾ω", 141);
    freq.put(" 是之", 18);
    freq.put("あ亀並", 17);
    freq.put("̥̥", 199);
    freq.put("之在", 36);
    freq.put("。ああ", 600);
    freq.put("ああ「", 128);
    freq.put("＾ ", 159);
    freq.put("一倉あ", 155);
    freq.put("　∧", 19);
    freq.put(" ₃", 10);
    freq.put("あ乱之", 20);
    freq.put("ア』あ", 25);
    freq.put("あ乱並", 30);
    freq.put("あ乱両", 29);
    freq.put(" 乙ア", 19);
    freq.put("。あ、", 10);
    freq.put("＞＞＞", 9);
    freq.put("～", 970);
    freq.put("⑤", 9);
    freq.put("あ乱丁", 19);
    freq.put("：ア", 67);
    freq.put("あ乱三", 15);
    freq.put("ああ〜", 456);
    freq.put("！侶", 14);
    freq.put("丁三ア", 39);
    freq.put("『丁あ", 9);
    freq.put(" ˚ ", 12);
    freq.put("：あ", 17);
    freq.put("∀≦ ", 14);
    freq.put("丘あ倉", 46);
    freq.put("丁三あ", 577);
    freq.put("倣三", 12);
    freq.put("　･ω", 8);
    freq.put("両あ丑", 10);
    freq.put("亨", 13);
    freq.put("倣丁", 17);
    freq.put("「アア", 264);
    freq.put("◡◝", 13);
    freq.put("∀ﾟ ", 57);
    freq.put("ア２", 12);
    freq.put("丁三】", 8);
    freq.put("！伎", 15);
    freq.put("亀丈あ", 14);
    freq.put("丁三、", 13);
    freq.put("丁三　", 10);
    freq.put("丁三。", 11);
    freq.put("͡", 56);
    freq.put("≡Σ ", 8);
    freq.put("̥ω", 10);
    freq.put("乙） ", 125);
    freq.put("人あ ", 51);
    freq.put("。あア", 17);
    freq.put(" ⌒ ", 78);
    freq.put("϶", 11);
    freq.put("】倉", 8);
    freq.put("ア丁両", 12);
    freq.put("、万あ", 10);
    freq.put("　⌒", 10);
    freq.put("̶̷", 16);
    freq.put("₍₍ ", 9);
    freq.put("三日並", 12);
    freq.put("三日丘", 9);
    freq.put("、日", 16);
    freq.put("丈あア", 31);
    freq.put("三日三", 19);
    freq.put("三日丁", 9);
    freq.put("三日万", 18);
    freq.put("！亀", 12);
    freq.put("あ凄あ", 30);
    freq.put(" 之倉", 26);
    freq.put("●", 150);
    freq.put("アд", 22);
    freq.put("並、ア", 16);
    freq.put("̶͈", 8);
    freq.put("アД", 19);
    freq.put("三日之", 72);
    freq.put("⃝ ", 16);
    freq.put("あ。並", 62);
    freq.put("ﾈ", 8);
    freq.put("！之", 103);
    freq.put("丈あ。", 20);
    freq.put(" 伎乙", 8);
    freq.put("ア丁丘", 25);
    freq.put("！乙", 163);
    freq.put(" 　⊂", 8);
    freq.put("ア、乙", 8);
    freq.put("！乱", 15);
    freq.put("伎あ倉", 8);
    freq.put(" ﾉあ", 29);
    freq.put("ア、之", 20);
    freq.put("！丁", 82);
    freq.put("！一", 8);
    freq.put("！万", 32);
    freq.put("！三", 109);
    freq.put("日あ倉", 16);
    freq.put("丈ああ", 431);
    freq.put("ア、並", 10);
    freq.put("ア、両", 10);
    freq.put("並、あ", 13);
    freq.put("！丘", 44);
    freq.put("̨̨̨", 10);
    freq.put("両三 ", 115);
    freq.put("之国", 22);
    freq.put("！両", 58);
    freq.put("！並", 57);
    freq.put("ア、丘", 9);
    freq.put("ア、丁", 11);
    freq.put("！丹", 10);
    freq.put("ア、三", 22);
    freq.put("三あ倉", 108);
    freq.put("□", 37);
    freq.put("ｬｯ", 50);
    freq.put("三あ倣", 8);
    freq.put("倉あ、", 8);
    freq.put("００両", 9);
    freq.put(" ٩", 19);
    freq.put(" あア", 703);
    freq.put("三×", 8);
    freq.put("三倉ア", 12);
    freq.put("①", 35);
    freq.put("在ああ", 20);
    freq.put("一年", 15);
    freq.put("∇≦ ", 14);
    freq.put("乙あ丘", 23);
    freq.put("倖あ", 115);
    freq.put("亀！", 11);
    freq.put("在あア", 8);
    freq.put("＝", 93);
    freq.put("　三あ", 16);
    freq.put("丁。 ", 40);
    freq.put("ᴥꞌ", 25);
    freq.put(" ああ", 13074);
    freq.put("アω", 171);
    freq.put("万あ侶", 8);
    freq.put("三倉あ", 124);
    freq.put("▅▇", 12);
    freq.put("＠⌒ア", 24);
    freq.put("ｬﾋ", 8);
    freq.put("▅▂", 12);
    freq.put("ｬﾝ", 8);
    freq.put(" ＿＿", 44);
    freq.put("アあ（", 8);
    freq.put(" あ、", 237);
    freq.put(" あ　", 20);
    freq.put(" あ。", 16);
    freq.put(" あ「", 10);
    freq.put("日倉あ", 8);
    freq.put(" あ〜", 17);
    freq.put("丙三", 26);
    freq.put("丙丈", 21);
    freq.put("亀両並", 10);
    freq.put("万あ丁", 60);
    freq.put("丙丁", 30);
    freq.put("⌒▽", 22);
    freq.put(" ﾟ´", 32);
    freq.put("中ああ", 135);
    freq.put("万あ三", 108);
    freq.put("丙丘", 21);
    freq.put(" ┓三", 16);
    freq.put("　┗", 8);
    freq.put(" ＼　", 9);
    freq.put("５日", 11);
    freq.put("丹あア", 12);
    freq.put("万あ丘", 33);
    freq.put("　「万", 12);
    freq.put("）」 ", 12);
    freq.put(" ──", 12);
    freq.put("？？ ", 66);
    freq.put("万あ両", 36);
    freq.put("之倉", 210);
    freq.put("丙並", 11);
    freq.put("（並三", 9);
    freq.put("三之！", 13);
    freq.put("丙之", 11);
    freq.put("○", 135);
    freq.put("万あ之", 45);
    freq.put("丙乙", 10);
    freq.put(" ﾌﾞ", 27);
    freq.put("万あ乙", 20);
    freq.put("ﾞｰﾝ", 11);
    freq.put("三両倉", 8);
    freq.put("丹並あ", 17);
    freq.put("！乙 ", 91);
    freq.put(" Σ･", 10);
    freq.put(" 【 ", 91);
    freq.put("【あア", 11);
    freq.put("両。 ", 10);
    freq.put("、之丘", 11);
    freq.put("ああ的", 12);
    freq.put("あ〜、", 8);
    freq.put("₎", 14);
    freq.put("あ〜〜", 19);
    freq.put("、之三", 33);
    freq.put("【ああ", 81);
    freq.put("、之丁", 24);
    freq.put("、之万", 8);
    freq.put(" ﾟ ", 111);
    freq.put("あ）」", 10);
    freq.put("大人あ", 36);
    freq.put("、之両", 17);
    freq.put("万あ人", 11);
    freq.put("、之並", 33);
    freq.put("ิ ", 63);
    freq.put("≡ ", 62);
    freq.put("あ〜あ", 134);
    freq.put("、之之", 22);
    freq.put("アア一", 35);
    freq.put("∪ ", 13);
    freq.put("இɷஇ", 10);
    freq.put("両亀あ", 13);
    freq.put("あ）あ", 12);
    freq.put("中あア", 23);
    freq.put("三󾮔", 18);
    freq.put("丹ああ", 188);
    freq.put("丁） ", 12);
    freq.put("並あ？", 20);
    freq.put("＆", 91);
    freq.put("→並", 9);
    freq.put("あ～～", 33);
    freq.put("∇｀", 14);
    freq.put("両！", 53);
    freq.put("´Д｀", 44);
    freq.put("両）", 16);
    freq.put("両（", 13);
    freq.put("乱 ", 49);
    freq.put("→万", 9);
    freq.put("→丁", 9);
    freq.put("両：", 10);
    freq.put("→三", 15);
    freq.put("両？", 13);
    freq.put("≡Σ", 8);
    freq.put("あ～！", 25);
    freq.put("アア中", 31);
    freq.put("あ～？", 14);
    freq.put("ิω", 19);
    freq.put("丙ああ", 114);
    freq.put("∇＾", 9);
    freq.put("「両並", 9);
    freq.put("あ倣", 59);
    freq.put("⊖˘ ", 8);
    freq.put(" ﾟω", 18);
    freq.put("艸", 76);
    freq.put("乙あア", 57);
    freq.put("両～", 10);
    freq.put("̣̣", 58);
    freq.put("丹日", 116);
    freq.put("ｯｼﾝ", 41);
    freq.put("̣̥", 9);
    freq.put("＼ ", 386);
    freq.put("乙ああ", 1392);
    freq.put("的アア", 8);
    freq.put(" 並国", 26);
    freq.put(" 伎丁", 10);
    freq.put("　乱", 12);
    freq.put("∇￣", 19);
    freq.put("з", 34);
    freq.put("あ呟あ", 14);
    freq.put("乙あ、", 19);
    freq.put("乙あ。", 30);
    freq.put("Ｏ─", 11);
    freq.put("Ｄ", 17);
    freq.put("₍₍", 11);
    freq.put("ｱ", 483);
    freq.put("丹丁あ", 12);
    freq.put("ア」　", 12);
    freq.put("┌", 62);
    freq.put("ア。 ", 161);
    freq.put(" ３三", 9);
    freq.put("三　之", 8);
    freq.put("ﾛ", 94);
    freq.put("並両両", 23);
    freq.put("並両並", 49);
    freq.put(" 之呟", 57);
    freq.put("之、あ", 21);
    freq.put("並両丘", 9);
    freq.put("並", 17929);
    freq.put("Ｐ", 15);
    freq.put("並両三", 31);
    freq.put("ア乙之", 31);
    freq.put(" 月弁", 10);
    freq.put("並両丁", 20);
    freq.put("並両万", 10);
    freq.put("ア」あ", 46);
    freq.put("　之あ", 19);
    freq.put("ア ", 5985);
    freq.put("佐", 158);
    freq.put("三　三", 15);
    freq.put("ˡ̼", 9);
    freq.put("並両之", 25);
    freq.put("あ且丁", 8);
    freq.put(" 並在", 26);
    freq.put("՞ਊ ", 95);
    freq.put(" ॢ ", 20);
    freq.put("大佐", 93);
    freq.put("之！⇒", 8);
    freq.put("ア×", 11);
    freq.put("「乙」", 14);
    freq.put("あ人之", 14);
    freq.put("之、ア", 12);
    freq.put("あア乙", 39);
    freq.put("、仕三", 13);
    freq.put("ア´", 33);
    freq.put(" ﾉ　", 11);
    freq.put("あ人両", 32);
    freq.put("あ人丘", 9);
    freq.put("あ人万", 10);
    freq.put("５月", 14);
    freq.put("「乙あ", 12);
    freq.put("۶", 64);
    freq.put("乙丁 ", 29);
    freq.put("あ人三", 128);
    freq.put("！丘あ", 21);
    freq.put("ω｀●", 8);
    freq.put("倉」 ", 13);
    freq.put("弁日", 92);
    freq.put("あ乞丁", 12);
    freq.put("͒", 17);
    freq.put("丹乙あ", 25);
    freq.put("呟ああ", 74);
    freq.put("丈あ並", 13);
    freq.put("丁、之", 9);
    freq.put(" ア　", 9);
    freq.put("∧", 154);
    freq.put("一両三", 8);
    freq.put("万日", 26);
    freq.put("ｵｱｱ", 9);
    freq.put("ｫﾛｰ", 24);
    freq.put("◉◞", 9);
    freq.put("๑╹", 25);
    freq.put("丁、三", 8);
    freq.put("╮ ", 15);
    freq.put(" ￣▽", 94);
    freq.put("あ両倉", 37);
    freq.put("๑꒱", 13);
    freq.put("侶あア", 38);
    freq.put("丁両 ", 19);
    freq.put("　仕", 190);
    freq.put("万】 ", 21);
    freq.put("乙乙 ", 57);
    freq.put("、丘之", 8);
    freq.put("ﾊﾞﾝ", 23);
    freq.put("大乙あ", 9);
    freq.put("之丁あ", 417);
    freq.put("丁　 ", 12);
    freq.put("＆アア", 36);
    freq.put("亀乙あ", 9);
    freq.put("˘ω", 74);
    freq.put("日両日", 9);
    freq.put("ア之並", 52);
    freq.put("アิ", 8);
    freq.put("、丘丁", 13);
    freq.put("之倉 ", 21);
    freq.put("両あ！", 16);
    freq.put("之丁、", 9);
    freq.put("之丁　", 9);
    freq.put("日丘あ", 23);
    freq.put("月弁日", 19);
    freq.put("乱ああ", 584);
    freq.put(" 三国", 24);
    freq.put("乱あア", 26);
    freq.put("ωฅ｀", 8);
    freq.put("〜。 ", 12);
    freq.put(" ﾊﾟ", 9);
    freq.put(" ﾊﾞ", 9);
    freq.put("̴̶̷", 16);
    freq.put("ｲﾃﾑ", 193);
    freq.put("ｮｵ", 9);
    freq.put("∴ ", 17);
    freq.put("之丁ア", 32);
    freq.put(" ̫͡", 9);
    freq.put("ｗｗあ", 30);
    freq.put("三月", 10);
    freq.put("丼両両", 8);
    freq.put("侶ああ", 437);
    freq.put("両、丁", 8);
    freq.put("ﾊﾞｲ", 8);
    freq.put("丘之", 374);
    freq.put("一倉", 171);
    freq.put("丘乙", 137);
    freq.put("ﾉあ", 30);
    freq.put("之弁", 51);
    freq.put("国人あ", 11);
    freq.put("並在両", 20);
    freq.put("■乱あ", 8);
    freq.put("丘乱", 23);
    freq.put("｜　　", 12);
    freq.put("丘丈", 48);
    freq.put("丘三", 490);
    freq.put("　　／", 17);
    freq.put("丘一", 15);
    freq.put("丘丁", 816);
    freq.put("丘万", 117);
    freq.put("丘丘", 200);
    freq.put("丘丙", 9);
    freq.put("丘丞", 13);
    freq.put("三三ア", 98);
    freq.put("ﾉ　", 12);
    freq.put("！あア", 13);
    freq.put("丘中", 74);
    freq.put(" 丁月", 11);
    freq.put("丘両", 190);
    freq.put("丘並", 301);
    freq.put("ʅ ", 10);
    freq.put("～～ ", 16);
    freq.put("丘丹", 16);
    freq.put("丘丼", 20);
    freq.put("丘之之", 13);
    freq.put("！ああ", 617);
    freq.put(" １丘", 11);
    freq.put("日。三", 8);
    freq.put("→", 564);
    freq.put("９", 66);
    freq.put(" １三", 10);
    freq.put("▿◝", 8);
    freq.put("丈丁 ", 21);
    freq.put("˘ ", 129);
    freq.put("ωﾟ ", 20);
    freq.put("三三あ", 1311);
    freq.put("？ ", 990);
    freq.put("丘之三", 25);
    freq.put("丘亀", 58);
    freq.put("丘之丁", 14);
    freq.put("並 ", 1664);
    freq.put("呟", 75);
    freq.put("三三】", 167);
    freq.put("：アア", 67);
    freq.put("丘之両", 19);
    freq.put("丘之並", 21);
    freq.put("丘人", 75);
    freq.put("三三、", 31);
    freq.put("三三　", 11);
    freq.put("三三。", 19);
    freq.put("三三」", 11);
    freq.put("≧∀≦", 14);
    freq.put("ﾉア", 14);
    freq.put("───", 37);
    freq.put("丁万之", 11);
    freq.put(" 万年", 8);
    freq.put("└", 66);
    freq.put(" 丘乙", 24);
    freq.put("三之亀", 9);
    freq.put("ア両ア", 10);
    freq.put("三日", 533);
    freq.put("裏丁あ", 9);
    freq.put("丁万三", 14);
    freq.put("丁万丁", 8);
    freq.put("之年", 79);
    freq.put("ㅜ", 20);
    freq.put("並並 ", 305);
    freq.put("丁万並", 13);
    freq.put("丁万両", 12);
    freq.put("之日 ", 11);
    freq.put("侶両", 10);
    freq.put(" ≧∇", 13);
    freq.put("侶並", 273);
    freq.put("●´∀", 8);
    freq.put("ア　 ", 36);
    freq.put("三之両", 68);
    freq.put("三之並", 113);
    freq.put("侶丁", 54);
    freq.put("並』→", 9);
    freq.put("侶万", 15);
    freq.put("侶丈", 10);
    freq.put("侶三", 30);
    freq.put("三之丘", 33);
    freq.put("三之丁", 168);
    freq.put("三之一", 8);
    freq.put("あ一日", 47);
    freq.put("丹", 855);
    freq.put("三之三", 172);
    freq.put("並】 ", 45);
    freq.put("ｃ", 8);
    freq.put(" 日", 504);
    freq.put("あ人、", 22);
    freq.put("ア両あ", 108);
    freq.put("͟͟͞", 8);
    freq.put("┏┗┏", 33);
    freq.put("ア並 ", 14);
    freq.put("٩", 78);
    freq.put("丁人あ", 46);
    freq.put("侶之", 38);
    freq.put("三之之", 106);
    freq.put("あϵ ", 10);
    freq.put("丘侶", 26);
    freq.put("ε ", 42);
    freq.put("兕あ", 8);
    freq.put("͟͟", 8);
    freq.put("͟͞", 8);
    freq.put("あ中丁", 9);
    freq.put("之大", 24);
    freq.put("ああ＊", 8);
    freq.put("ああ）", 45);
    freq.put("ああ（", 351);
    freq.put("～アア", 21);
    freq.put("あ中三", 8);
    freq.put("；ﾟ", 13);
    freq.put("ああ！", 3555);
    freq.put("ああ？", 1264);
    freq.put("ああ＞", 12);
    freq.put("ああ＜", 10);
    freq.put("１日", 26);
    freq.put("ああ：", 10);
    freq.put("ああ５", 12);
    freq.put("ああ４", 8);
    freq.put("ああ３", 15);
    freq.put("ああ２", 15);
    freq.put("ああ１", 37);
    freq.put("あ！侶", 11);
    freq.put("あ中並", 9);
    freq.put("　⊂ ", 9);
    freq.put("˚ ", 26);
    freq.put("ああ＠", 10);
    freq.put("ああ＿", 17);
    freq.put("ああ＾", 22);
    freq.put("ああ＼", 124);
    freq.put("　　｜", 11);
    freq.put("ああＲ", 8);
    freq.put("◜◡◝", 11);
    freq.put(" 之弁", 20);
    freq.put("＿人", 69);
    freq.put("あ中之", 24);
    freq.put("￥ ", 54);
    freq.put("┏ ", 47);
    freq.put("ああ～", 522);
    freq.put("あ（＾", 31);
    freq.put("ああｗ", 206);
    freq.put("両両日", 12);
    freq.put("ああ･", 20);
    freq.put("ああ､", 21);
    freq.put("ああ｣", 20);
    freq.put("ああ｡", 63);
    freq.put("ㅋㅋ", 24);
    freq.put("あ（；", 15);
    freq.put("░▒▓", 12);
    freq.put("ああｺ", 9);
    freq.put("乙丘あ", 57);
    freq.put("ああｰ", 10);
    freq.put("ああﾌ", 12);
    freq.put("Дﾟ ", 54);
    freq.put("。両両", 8);
    freq.put("あ！伎", 8);
    freq.put("；）", 26);
    freq.put("；＿", 28);
    freq.put("。両万", 14);
    freq.put("Ｗｗｗ", 8);
    freq.put(" 日弁", 11);
    freq.put("；｀", 41);
    freq.put("˘ω˘", 70);
    freq.put("！之あ", 33);
    freq.put("╭ ", 23);
    freq.put("！！ ", 569);
    freq.put("◦", 10);
    freq.put("ｭ", 38);
    freq.put("並。 ", 35);
    freq.put("。』 ", 8);
    freq.put("万之 ", 28);
    freq.put("←並あ", 8);
    freq.put("（乙）", 256);
    freq.put("ﾝｸﾞ", 51);
    freq.put(" ﾆ ", 15);
    freq.put("ﾝｸﾚ", 8);
    freq.put("ﾗ", 278);
    freq.put("仕並", 12);
    freq.put("仕両", 21);
    freq.put("ｰｰ", 128);
    freq.put("ｰｱ", 193);
    freq.put("日之あ", 23);
    freq.put("三あ大", 32);
    freq.put("仕三", 384);
    freq.put("仕丈", 26);
    freq.put(" 之年", 38);
    freq.put("仕万", 21);
    freq.put("仕丁", 9);
    freq.put("〜〜", 64);
    freq.put("〜。", 28);
    freq.put("〜、", 9);
    freq.put("大ああ", 80);
    freq.put("ｗ ", 167);
    freq.put("⌓", 11);
    freq.put("三。 ", 40);
    freq.put("仕之", 13);
    freq.put(" └ ", 20);
    freq.put("▂▅", 12);
    freq.put(" ░▒", 11);
    freq.put("仕人", 10);
    freq.put("あ！丘", 27);
    freq.put("あア ", 1095);
    freq.put("あ！万", 18);
    freq.put("丁之倉", 8);
    freq.put("あ！丁", 46);
    freq.put("あ！三", 61);
    freq.put("੭ु ", 10);
    freq.put("、並あ", 82);
    freq.put("あ！並", 34);
    freq.put(" ⇒ ", 14);
    freq.put("丼 ", 35);
    freq.put("あ！両", 30);
    freq.put("̿", 10);
    freq.put("一亀あ", 10);
    freq.put("ｰﾙ", 9);
    freq.put("あ！乙", 110);
    freq.put("ｰﾄ", 23);
    freq.put("あ？←", 8);
    freq.put("Дあ ", 14);
    freq.put("あ！之", 58);
    freq.put("あД", 23);
    freq.put("丁並万", 15);
    freq.put("三亀 ", 8);
    freq.put("ｲ ", 9);
    freq.put("（；＿", 19);
    freq.put("倉あ倉", 24);
    freq.put("´；", 50);
    freq.put("･ああ", 11);
    freq.put("中あ", 308);
    freq.put("『ア", 172);
    freq.put("丁仕", 14);
    freq.put("裏之】", 10);
    freq.put("あ丈之", 8);
    freq.put(" ～４", 12);
    freq.put(" ､ ", 16);
    freq.put("両乱あ", 8);
    freq.put("丁亀", 119);
    freq.put("中、", 11);
    freq.put("あ、", 4137);
    freq.put("あ。", 4653);
    freq.put("中。", 12);
    freq.put("並之 ", 100);
    freq.put("あ」", 548);
    freq.put("あ『", 65);
    freq.put("あ』", 79);
    freq.put(" 是", 20);
    freq.put("あ丈並", 99);
    freq.put("あ【", 60);
    freq.put("あ】", 131);
    freq.put("ｖ", 10);
    freq.put("あ〜", 529);
    freq.put("´｀", 13);
    freq.put("あ丈三", 16);
    freq.put("両アア", 201);
    freq.put("あ丈丁", 12);
    freq.put("´ｰ", 10);
    freq.put("あ丈丘", 17);
    freq.put("´･", 205);
    freq.put("丁之", 852);
    freq.put("丁丁之", 46);
    freq.put("▒", 24);
    freq.put("←並", 8);
    freq.put("丁乙", 241);
    freq.put("並丁！", 15);
    freq.put("三的あ", 46);
    freq.put("、大丁", 14);
    freq.put("丁乱", 49);
    freq.put("←丁", 9);
    freq.put("三大あ", 9);
    freq.put("͞ ", 9);
    freq.put("あｷｬ", 25);
    freq.put("⌒／ア", 8);
    freq.put("?", 59);
    freq.put("丁丁", 1083);
    freq.put("丁一", 23);
    freq.put("丁丁万", 8);
    freq.put("丁丁丁", 79);
    freq.put("丁万", 217);
    freq.put("ア之日", 9);
    freq.put("丁三", 1293);
    freq.put("丁丈", 93);
    freq.put("丁丁三", 58);
    freq.put("丁丑", 24);
    freq.put("丁丙", 29);
    freq.put("丁丘", 360);
    freq.put("丁丁丘", 28);
    freq.put("丁両", 352);
    freq.put("丁丁並", 92);
    freq.put("丁丁両", 21);
    freq.put("┻┳ ", 8);
    freq.put("あア", 10537);
    freq.put("中ア", 12);
    freq.put("『あ", 78);
    freq.put("丁中", 18);
    freq.put("丁丹", 35);
    freq.put("喫", 60);
    freq.put("仕三並", 200);
    freq.put("￣￣", 212);
    freq.put("あ〜ア", 11);
    freq.put(" 年 ", 73);
    freq.put("丘倉 ", 11);
    freq.put("´︶", 11);
    freq.put("̨", 14);
    freq.put("＝ ", 21);
    freq.put("並並之", 62);
    freq.put("三「三", 9);
    freq.put(" ￣∇", 19);
    freq.put("坂丘", 14);
    freq.put(" 月", 312);
    freq.put(" 三倉", 34);
    freq.put("丁侶", 24);
    freq.put("ﾀ", 67);
    freq.put("丁佇", 9);
    freq.put("！丁あ", 27);
    freq.put(" 佐丘", 9);
    freq.put("仕三人", 12);
    freq.put("！倉あ", 8);
    freq.put("侶アア", 8);
    freq.put("両的", 10);
    freq.put("￣∇￣", 19);
    freq.put("嘱", 8);
    freq.put("▼", 31);
    freq.put("々丁", 18);
    freq.put("ア´ ", 23);
    freq.put("￣＼", 8);
    freq.put("侶之 ", 10);
    freq.put("٩ ", 61);
    freq.put(" ิ ", 14);
    freq.put("￣）", 9);
    freq.put("凄ああ", 20);
    freq.put("･∀", 33);
    freq.put("´ア｀", 22);
    freq.put("三「あ", 25);
    freq.put("＝＝", 9);
    freq.put("　倉", 21);
    freq.put(" ／　", 31);
    freq.put("あ之", 5070);
    freq.put("ｰｰｰ", 113);
    freq.put("あ乞", 202);
    freq.put("両之 ", 45);
    freq.put("あ乙", 1703);
    freq.put("あ丈あ", 265);
    freq.put("あ乩", 12);
    freq.put("ิ", 131);
    freq.put("中万", 37);
    freq.put("あ万", 1142);
    freq.put("あ一", 499);
    freq.put("あ丁", 4990);
    freq.put("アア倉", 108);
    freq.put("あ丈", 485);
    freq.put("あ三", 6870);
    freq.put("あ且", 34);
    freq.put("あ丑", 336);
    freq.put("あ丞", 11);
    freq.put("あ丘", 2155);
    freq.put("あ丙", 117);
    freq.put("あ並", 4647);
    freq.put("丁ア", 384);
    freq.put("あ両", 2446);
    freq.put("丁丁ア", 23);
    freq.put("あ中", 236);
    freq.put("╮", 34);
    freq.put("　三之", 27);
    freq.put("あ丼", 174);
    freq.put("⇔ああ", 8);
    freq.put("あ丹", 228);
    freq.put("┛┓", 30);
    freq.put("丁あ", 7197);
    freq.put("丁丁あ", 360);
    freq.put("》", 42);
    freq.put("『並", 18);
    freq.put("あ仕", 156);
    freq.put("̸̸", 24);
    freq.put("５", 114);
    freq.put("´ア ", 17);
    freq.put("丟", 10);
    freq.put("『丈", 8);
    freq.put("『三", 28);
    freq.put("³˙ ", 13);
    freq.put("『丁", 36);
    freq.put(" ／ア", 20);
    freq.put("是", 68);
    freq.put("『万", 8);
    freq.put("『丘", 19);
    freq.put("丁、", 74);
    freq.put("丁　", 48);
    freq.put("丁。", 69);
    freq.put("あ亀", 865);
    freq.put("丁丁　", 10);
    freq.put("丁丁。", 14);
    freq.put("あ丈ア", 13);
    freq.put("卍", 12);
    freq.put("丁「", 86);
    freq.put("丁』", 12);
    freq.put("丁】", 158);
    freq.put("丁丁】", 66);
    freq.put("ア：ア", 16);
    freq.put("『乱", 8);
    freq.put("年アア", 14);
    freq.put("あ亙", 25);
    freq.put("之並倉", 8);
    freq.put("╹ω", 11);
    freq.put("あ亥", 14);
    freq.put("『之", 32);
    freq.put("三「ア", 12);
    freq.put("←あ", 34);
    freq.put("三大丁", 10);
    freq.put("ああϵ", 8);
    freq.put("！　 ", 16);
    freq.put("あ人", 1035);
    freq.put("あ佇", 9);
    freq.put(" ～ ", 74);
    freq.put("あʕ ", 8);
    freq.put("ωฅ", 9);
    freq.put("▽￣ ", 94);
    freq.put("之両 ", 44);
    freq.put("╰╯", 11);
    freq.put("´ ", 704);
    freq.put("。」 ", 20);
    freq.put("あ伎", 178);
    freq.put("あ〜。", 26);
    freq.put("之並 ", 295);
    freq.put("仕三あ", 108);
    freq.put("並之！", 19);
    freq.put("並倉 ", 12);
    freq.put("大丈丁", 119);
    freq.put("丈あ倉", 11);
    freq.put("之年あ", 34);
    freq.put("　あ", 286);
    freq.put("┃", 66);
    freq.put("あ侮丼", 11);
    freq.put("。。。", 70);
    freq.put("々あ", 137);
    freq.put("倉あ之", 63);
    freq.put("ああʕ", 10);
    freq.put("之年ア", 9);
    freq.put("並、", 110);
    freq.put("´´", 18);
    freq.put(" あ丑", 34);
    freq.put("並丁 ", 110);
    freq.put("＿", 575);
    freq.put("！丁丁", 11);
    freq.put("あ侃", 25);
    freq.put("ｵｵｵ", 62);
    freq.put("！丁三", 10);
    freq.put("。。あ", 10);
    freq.put("三！あ", 8);
    freq.put("！丁並", 9);
    freq.put("倉あ乙", 17);
    freq.put("あ侮", 79);
    freq.put("あ侶", 483);
    freq.put("〃▽", 16);
    freq.put("ｯﾋｮ", 9);
    freq.put("万並：", 10);
    freq.put("▅", 24);
    freq.put("丈", 1668);
    freq.put("ｗｗ", 1566);
    freq.put("丘亀あ", 28);
    freq.put("乙丘並", 12);
    freq.put("　　∧", 13);
    freq.put("万あ、", 18);
    freq.put("あ倉亀", 9);
    freq.put("ｬｯｼ", 41);
    freq.put("ρ", 12);
    freq.put("ｲﾝ", 8);
    freq.put("ｲﾄ", 16);
    freq.put("´͈", 12);
    freq.put("ｲﾃ", 196);
    freq.put("之三大", 11);
    freq.put("あ之弁", 14);
    freq.put("あ٩ ", 22);
    freq.put("ｗＷ", 12);
    freq.put("ｰ ", 72);
    freq.put("あ倉並", 76);
    freq.put("丁傭", 9);
    freq.put("あ倉両", 34);
    freq.put("！之三", 16);
    freq.put("あア＼", 19);
    freq.put("大 ", 10);
    freq.put("█▇▅", 12);
    freq.put(" ´◡", 11);
    freq.put("´θ", 15);
    freq.put("あア（", 30);
    freq.put("あ倉万", 14);
    freq.put("´ε", 35);
    freq.put("ｲｸ", 8);
    freq.put("あﾟ･", 61);
    freq.put("あア！", 327);
    freq.put("あ倉丁", 125);
    freq.put("あア？", 68);
    freq.put("あ倉丘", 15);
    freq.put(" ´▽", 102);
    freq.put(" ´△", 13);
    freq.put("´ω", 144);
    freq.put("あ倉之", 34);
    freq.put("ｩ", 34);
    freq.put("。両あ", 26);
    freq.put("あ倉乙", 11);
    freq.put("大両あ", 33);
    freq.put("中万あ", 8);
    freq.put("あ万倉", 22);
    freq.put("あ之年", 22);
    freq.put("ﾓ", 26);
    freq.put("┛┓┛", 29);
    freq.put("ア並丘", 13);
    freq.put("；´", 21);
    freq.put("Ｈ", 10);
    freq.put("ああ ", 13919);
    freq.put("ああ?", 51);
    freq.put("＆ああ", 10);
    freq.put("あ！ア", 114);
    freq.put("あ（ ", 71);
    freq.put(" 』あ", 39);
    freq.put(" ア之", 46);
    freq.put("´艸", 61);
    freq.put("日之丁", 9);
    freq.put("´アω", 76);
    freq.put("仕あ", 54);
    freq.put("あ！】", 13);
    freq.put("アあ日", 14);
    freq.put("あ！　", 33);
    freq.put("◡◝ ", 11);
    freq.put("あ！」", 82);
    freq.put("大", 1223);
    freq.put("、並之", 21);
    freq.put("๑´╹", 39);
    freq.put("あ、大", 36);
    freq.put("； ", 124);
    freq.put("、並乙", 19);
    freq.put("ああ´", 10);
    freq.put("ﾃﾞｹ", 10);
    freq.put("爬あ", 28);
    freq.put("´˘", 8);
    freq.put("、並並", 28);
    freq.put("！！（", 8);
    freq.put("あ！あ", 406);
    freq.put("之日、", 16);
    freq.put("！！？", 16);
    freq.put("あ（´", 13);
    freq.put("、並三", 43);
    freq.put("、並丁", 15);
    freq.put("、並丘", 8);
    freq.put("倉大", 8);
    freq.put("ﾉ乙", 18);
    freq.put("丘あ", 3656);
    freq.put("／ああ", 20);
    freq.put("あ三的", 9);
    freq.put("ア三倉", 10);
    freq.put("月あア", 9);
    freq.put("◟", 39);
    freq.put("並！ア", 8);
    freq.put(" 倉丘", 12);
    freq.put("丘「", 61);
    freq.put("丘」", 18);
    freq.put("丘。", 31);
    freq.put("丘　", 23);
    freq.put("丘、", 50);
    freq.put("亀両あ", 13);
    freq.put("並在あ", 21);
    freq.put("ﾉ三", 9);
    freq.put("ｒ", 13);
    freq.put("艸｀ ", 42);
    freq.put("冴あ", 8);
    freq.put("∀≦", 14);
    freq.put("丘之ア", 17);
    freq.put("´˘ ", 8);
    freq.put("三三亀", 8);
    freq.put("ｧｱｱ", 12);
    freq.put("丘之あ", 143);
    freq.put("三。あ", 11);
    freq.put("ਊ՞", 10);
    freq.put("％あ", 17);
    freq.put("あ丘倉", 29);
    freq.put("ε｀", 35);
    freq.put("倣", 168);
    freq.put("。大", 14);
    freq.put("中万三", 16);
    freq.put("三三乙", 20);
    freq.put("之→", 12);
    freq.put("三三之", 159);
    freq.put("丘之「", 9);
    freq.put("％　", 16);
    freq.put("月ああ", 51);
    freq.put("三三並", 166);
    freq.put("三三両", 57);
    freq.put("佐アア", 9);
    freq.put("三三中", 9);
    freq.put("あ丑 ", 10);
    freq.put("丹三あ", 27);
    freq.put("丘ア", 152);
    freq.put("ア￣ ", 22);
    freq.put("三三丘", 44);
    freq.put("三三万", 66);
    freq.put("三三丁", 81);
    freq.put("三三一", 13);
    freq.put("亀三 ", 11);
    freq.put("並並　", 8);
    freq.put("三三三", 276);
    freq.put("乙！ ", 10);
    freq.put("丁丈 ", 10);
    freq.put("万アア", 95);
    freq.put("　ああ", 225);
    freq.put(" 両倉", 15);
    freq.put("´Д", 102);
    freq.put("ਊ", 124);
    freq.put("丁万あ", 90);
    freq.put("三之ア", 84);
    freq.put("´д", 23);
    freq.put("･д･", 12);
    freq.put("┗┏ ", 9);
    freq.put("丼あ ", 12);
    freq.put("　あ　", 16);
    freq.put(" 倉 ", 8);
    freq.put("ああ٩", 27);
    freq.put("ั ", 20);
    freq.put("侶丘", 32);
    freq.put(" ᴗ", 43);
    freq.put(" ´∇", 19);
    freq.put("年あア", 13);
    freq.put("ｼ", 153);
    freq.put(" ´∀", 111);
    freq.put("？？", 195);
    freq.put("℃", 31);
    freq.put("是之", 64);
    freq.put("ア両丘", 9);
    freq.put("？（", 19);
    freq.put("年ああ", 77);
    freq.put("？！", 78);
    freq.put("ア両三", 34);
    freq.put("三之】", 11);
    freq.put("並～", 20);
    freq.put("ア両並", 39);
    freq.put("之乱あ", 21);
    freq.put("三之、", 33);
    freq.put("ア両両", 21);
    freq.put("三之「", 10);
    freq.put("並＼", 9);
    freq.put("▅▇█", 12);
    freq.put(" ◜◡", 13);
    freq.put("ア両之", 14);
    freq.put("丙丁あ", 21);
    freq.put("並２", 8);
    freq.put(" ◜◒", 12);
    freq.put(" ´⊙", 8);
    freq.put("≡┏ ", 11);
    freq.put("並：", 39);
    freq.put("並？", 15);
    freq.put("三之あ", 891);
    freq.put("並（", 13);
    freq.put("並）", 23);
    freq.put("両丈あ", 10);
    freq.put("在両之", 20);
    freq.put("あ乞あ", 165);
    freq.put("。　　", 13);
    freq.put("。　「", 8);
    freq.put("之弁あ", 8);
    freq.put("󾮔三", 20);
    freq.put("丁あ日", 18);
    freq.put("（´ ", 12);
    freq.put("ｴｴ", 61);
    freq.put("丘！ ", 15);
    freq.put("並万 ", 39);
    freq.put("あ乙 ", 134);
    freq.put("両あ ", 111);
    freq.put("￣ア￣", 25);
    freq.put(" ┘ ", 12);
    freq.put("ωあ ", 10);
    freq.put("ﾘﾘﾘ", 10);
    freq.put("ꞌᴥ", 25);
    freq.put("』", 566);
    freq.put("１", 266);
    freq.put("︶˙ ", 14);
    freq.put("━┛ ", 11);
    freq.put("「あ？", 14);
    freq.put("～ああ", 86);
    freq.put("ア丼あ", 10);
    freq.put("˘", 249);
    freq.put("）Ｏ─", 11);
    freq.put(" ˘ω", 67);
    freq.put("一両あ", 23);
    freq.put("人倉あ", 11);
    freq.put("→之", 9);
    freq.put("○○あ", 9);
    freq.put(" ∀ ", 50);
    freq.put("之丹あ", 13);
    freq.put("、丘あ", 86);
    freq.put("乱あ並", 14);
    freq.put("並丈あ", 34);
    freq.put("乙並 ", 9);
    freq.put("之丁之", 46);
    freq.put("∀´ิ", 17);
    freq.put("乱あ丁", 11);
    freq.put(" 】ア", 14);
    freq.put("乱あ三", 15);
    freq.put("之丁乙", 9);
    freq.put("　´ ", 22);
    freq.put("之丁両", 9);
    freq.put("之丁並", 57);
    freq.put("℃、", 14);
    freq.put("̀๑", 10);
    freq.put("之丁丁", 33);
    freq.put("之丁万", 19);
    freq.put("之丁三", 72);
    freq.put("乱あ之", 15);
    freq.put("侶あ両", 14);
    freq.put("侶あ並", 28);
    freq.put("ξ ", 15);
    freq.put("亀倉あ", 8);
    freq.put("侶あ丁", 30);
    freq.put("侶あ万", 11);
    freq.put("両、あ", 9);
    freq.put("侶あ三", 39);
    freq.put("´θ｀", 15);
    freq.put("「之あ", 34);
    freq.put("［", 23);
    freq.put("侶あ丘", 16);
    freq.put("」 ", 1209);
    freq.put(" 】あ", 10);
    freq.put("！？あ", 18);
    freq.put("ア丘 ", 26);
    freq.put(" ｡ア", 8);
    freq.put("侶あ之", 39);
    freq.put("侶あ乙", 10);
    freq.put("ア･", 24);
    freq.put("ア｡", 15);
    freq.put("「両あ", 14);
    freq.put("あ亙あ", 21);
    freq.put("ア｀", 83);
    freq.put("꒳", 22);
    freq.put("アｗ", 32);
    freq.put("→　", 21);
    freq.put("→「", 13);
    freq.put("ア～", 43);
    freq.put(" 三丘", 119);
    freq.put("ア＼", 31);
    freq.put("ア＿", 8);
    freq.put("՞", 232);
    freq.put("ア＆", 36);
    freq.put("ア丑あ", 11);
    freq.put("ア！", 842);
    freq.put("ア／", 12);
    freq.put("ア（", 120);
    freq.put("ア）", 90);
    freq.put("ア１", 21);
    freq.put("→あ", 32);
    freq.put("ア３", 15);
    freq.put("ア＜", 15);
    freq.put("ア＝", 11);
    freq.put("ア＞", 10);
    freq.put("ア？", 123);
    freq.put("ア：", 64);
    freq.put("乙あ乙", 17);
    freq.put("○ ", 44);
    freq.put("日、あ", 8);
    freq.put("∇", 184);
    freq.put("ア￣", 32);
    freq.put("両あア", 128);
    freq.put("乙あ之", 39);
    freq.put("→ア", 39);
    freq.put("乙あ乱", 9);
    freq.put("！」あ", 23);
    freq.put(" ლ", 17);
    freq.put("Ｔ ", 11);
    freq.put("」「あ", 18);
    freq.put(" ： ", 15);
    freq.put("乙あ丈", 10);
    freq.put("乙あ三", 70);
    freq.put("乙あ丁", 45);
    freq.put("💕", 8);
    freq.put("💖", 11);
    freq.put("･", 1356);
    freq.put("💓", 12);
    freq.put("アﾉ", 11);
    freq.put("乙あ両", 22);
    freq.put("アﾟ", 13);
    freq.put("乙あ並", 40);
    freq.put(" ｽﾔ", 12);
    freq.put("両 ", 527);
    freq.put("ﾏ", 29);
    freq.put("三　あ", 14);
    freq.put("ｹｲｸ", 8);
    freq.put("̀ ", 22);
    freq.put("⊂ ", 59);
    freq.put("　大", 10);
    freq.put("⇒⇒", 16);
    freq.put("之、之", 11);
    freq.put("あ並倉", 135);
    freq.put("△", 29);
    freq.put("万三 ", 55);
    freq.put("万丁 ", 41);
    freq.put("ア乙あ", 44);
    freq.put("吾", 31);
    freq.put("彫ああ", 11);
    freq.put("ああ⊂", 8);
    freq.put("あ人ア", 28);
    freq.put("之、丁", 15);
    freq.put("╬ ", 10);
    freq.put("アア大", 59);
    freq.put("之、三", 14);
    freq.put("あ～ ", 256);
    freq.put("∇ ", 62);
    freq.put("並両あ", 285);
    freq.put("＞ア", 10);
    freq.put("侮あ ", 8);
    freq.put("あ倹あ", 51);
    freq.put("之　 ", 14);
    freq.put("＼＿", 14);
    freq.put("＼＼", 32);
    freq.put("あ裏之", 17);
    freq.put("並両ア", 10);
    freq.put("＞あ", 11);
    freq.put("あ人あ", 551);
    freq.put("三並日", 24);
    freq.put("＞　", 10);
    freq.put("あ裏丁", 8);
    freq.put("́ ", 55);
    freq.put("੭", 36);
    freq.put("三　ア", 13);
    freq.put(" ← ", 44);
    freq.put("あ人。", 8);
    freq.put("並あ日", 10);
    freq.put("【亀丘", 62);
    freq.put("？？？", 44);
    freq.put("三丼あ", 13);
    freq.put("д", 141);
    freq.put("あ之在", 36);
    freq.put("😭", 9);
    freq.put("丈並あ", 121);
    freq.put(" あ亀", 24);
    freq.put("。丈あ", 8);
    freq.put("😊", 9);
    freq.put(" ▿◝", 8);
    freq.put("◜◒◝", 12);
    freq.put("」→「", 10);
    freq.put("三：", 57);
    freq.put(" あ乱", 8);
    freq.put("あ、倉", 44);
    freq.put("ᴥ", 25);
    freq.put("┗ ", 58);
    freq.put(" あ之", 107);
    freq.put("三１", 9);
    freq.put("ॢ◡ ", 9);
    freq.put("（両両", 9);
    freq.put(" あ乙", 46);
    freq.put("三倉之", 12);
    freq.put("━━", 146);
    freq.put(" あ並", 119);
    freq.put(" あ両", 34);
    freq.put("̀ω", 19);
    freq.put("ｽﾔｧ", 20);
    freq.put("▽≦ ", 55);
    freq.put("━┓", 14);
    freq.put("三倉並", 19);
    freq.put("｡･ﾟ", 9);
    freq.put("倖丘", 13);
    freq.put("━┛", 15);
    freq.put(" ﾟ｡", 59);
    freq.put(" あ万", 16);
    freq.put(" あ丁", 97);
    freq.put("дﾟ ", 20);
    freq.put("ア乙乙", 13);
    freq.put(" あ三", 150);
    freq.put("三倉丁", 16);
    freq.put("三倉三", 21);
    freq.put(" あ丘", 28);
    freq.put("万あ。", 11);
    freq.put("中あ之", 19);
    freq.put("アﾟ ", 10);
    freq.put("万あ「", 59);
    freq.put("亙", 79);
    freq.put("●´", 26);
    freq.put(" 一倉", 31);
    freq.put("≧▽≦", 57);
    freq.put("大丼", 31);
    freq.put("万ああ", 1193);
    freq.put("中あ三", 8);
    freq.put("丙あ", 158);
    freq.put("中あ一", 8);
    freq.put("中あ丁", 28);
    freq.put("∂） ", 15);
    freq.put("∇≦）", 43);
    freq.put("大丹", 15);
    freq.put("⃝", 20);
    freq.put("￣", 893);
    freq.put("ㅂ ", 9);
    freq.put("　「あ", 19);
    freq.put("ｬ ", 11);
    freq.put("大並", 30);
    freq.put("中あ並", 17);
    freq.put("之三倉", 29);
    freq.put("ｸ", 169);
    freq.put("Дあ", 15);
    freq.put("ｶﾞ", 28);
    freq.put("ﾌｫｯ", 9);
    freq.put("● ", 66);
    freq.put("ｶｰ", 12);
    freq.put("丹あ並", 14);
    freq.put("亀 ", 105);
    freq.put("万あア", 72);
    freq.put("△｀ ", 11);
    freq.put("丙ア", 8);
    freq.put("丹あ三", 17);
    freq.put("丹あ丁", 11);
    freq.put("ああ裏", 15);
    freq.put("ɷஇ ", 10);
    freq.put("⋆", 10);
    freq.put("、之あ", 114);
    freq.put("ﾞｺﾄ", 9);
    freq.put("丹あ之", 8);
    freq.put(" ＿ ", 54);
    freq.put("丁之→", 9);
    freq.put("＾∀＾", 12);
    freq.put("月弁", 30);
    freq.put("あ【ア", 10);
    freq.put("あ乱あ", 409);
    freq.put("ﾙﾙﾙ", 9);
    freq.put("圓ああ", 11);
    freq.put("а", 8);
    freq.put("【倉", 18);
    freq.put("⇔あ", 8);
    freq.put("。あ丁", 8);
    freq.put("之倉丘", 11);
    freq.put("丁三亀", 18);
    freq.put(" 乙亀", 16);
    freq.put("並あ丁", 168);
    freq.put("並的", 22);
    freq.put("　＜ ", 16);
    freq.put("１００", 22);
    freq.put(" ¨ ", 14);
    freq.put("丁三乙", 16);
    freq.put("：之", 15);
    freq.put("｀アω", 12);
    freq.put("ᴥꞌ ", 25);
    freq.put("－", 21);
    freq.put("；｀ ", 41);
    freq.put("丁三之", 70);
    freq.put("ㅋㅋ ", 8);
    freq.put("丁三丘", 19);
    freq.put("『之あ", 8);
    freq.put(" 乙之", 63);
    freq.put(" 」∠", 45);
    freq.put(" 乙乙", 40);
    freq.put("丁乱 ", 8);
    freq.put("４ああ", 10);
    freq.put("あ【あ", 10);
    freq.put(" ア∀", 46);
    freq.put("◆", 58);
    freq.put(" 乙両", 24);
    freq.put("：丁", 18);
    freq.put(" 乙並", 43);
    freq.put("丁三三", 96);
    freq.put("丁三万", 22);
    freq.put("丁三丁", 36);
    freq.put(" 乙丈", 19);
    freq.put(" 乙三", 146);
    freq.put("丁三丹", 10);
    freq.put(" 乙丁", 63);
    freq.put("：並", 14);
    freq.put(" 乙万", 8);
    freq.put(" 乙丘", 38);
    freq.put("：丘", 14);
    freq.put("丁三並", 62);
    freq.put("丁三両", 29);
    freq.put("三丁倉", 24);
    freq.put("＾＾", 40);
    freq.put("ﾟ∀ﾟ", 60);
    freq.put("＾Ｏ", 11);
    freq.put("、丹あ", 9);
    freq.put("＾）", 54);
    freq.put("ﾛ ", 10);
    freq.put("̴", 31);
    freq.put("三日、", 16);
    freq.put("並あ並", 205);
    freq.put("丼三あ", 21);
    freq.put("亀アア", 36);
    freq.put("、万丁", 10);
    freq.put("ア、ア", 95);
    freq.put(" ＜ ", 45);
    freq.put("！ア", 279);
    freq.put("、万並", 10);
    freq.put("あ之倉", 65);
    freq.put("＞＞ ", 9);
    freq.put("倣あ", 74);
    freq.put("三日あ", 300);
    freq.put("国", 291);
    freq.put("Θ ", 35);
    freq.put("！あ", 688);
    freq.put("　之並", 195);
    freq.put("丈あ丈", 11);
    freq.put(" 伎あ", 139);
    freq.put("丈あ丁", 23);
    freq.put("。倉", 15);
    freq.put("乞倖", 16);
    freq.put("並、三", 15);
    freq.put("丈あ丘", 16);
    freq.put("三日ア", 22);
    freq.put(" ﾉ乙", 15);
    freq.put("　之丁", 13);
    freq.put("Ｏ──", 11);
    freq.put("　之三", 9);
    freq.put("丈あ両", 8);
    freq.put("あ三！", 14);
    freq.put("弁日あ", 53);
    freq.put("ア、あ", 62);
    freq.put("Ｗ", 25);
    freq.put("ω˘", 74);
    freq.put(" 伎「", 33);
    freq.put("丈あ之", 21);
    freq.put("！」", 224);
    freq.put("乙）（", 8);
    freq.put("！』", 19);
    freq.put("！】", 44);
    freq.put("！【", 18);
    freq.put("丈あ乙", 17);
    freq.put("ωˇ", 9);
    freq.put("両三！", 10);
    freq.put(" ﾉ三", 9);
    freq.put("ﾛｰﾝ", 12);
    freq.put("一", 1035);
    freq.put("万！", 13);
    freq.put("之。 ", 41);
    freq.put("あ並在", 16);
    freq.put("乙】　", 8);
    freq.put("並あ之", 231);
    freq.put("＜あ", 24);
    freq.put("、万之", 14);
    freq.put("「伎", 27);
    freq.put("艸｀", 42);
    freq.put("万」 ", 12);
    freq.put("丈倉あ", 14);
    freq.put("乙両三", 10);
    freq.put("あ侶並", 121);
    freq.put(" ◔ ", 11);
    freq.put("　ア ", 22);
    freq.put("ω", 1771);
    freq.put("伎「 ", 8);
    freq.put("一丈あ", 11);
    freq.put("◝", 57);
    freq.put("͞", 20);
    freq.put("国両両", 9);
    freq.put(" → ", 35);
    freq.put("△ ", 9);
    freq.put("、丁あ", 121);
    freq.put("「侶", 14);
    freq.put("並人あ", 15);
    freq.put("･ﾟ", 26);
    freq.put("ア！乙", 16);
    freq.put(" ∧ ", 45);
    freq.put("＼＼ ", 17);
    freq.put("ア！之", 10);
    freq.put("倉三之", 22);
    freq.put("）┐", 11);
    freq.put("Σ･∴", 10);
    freq.put("兕", 8);
    freq.put("｡", 846);
    freq.put("人丘あ", 9);
    freq.put("あ人並", 64);
    freq.put("倉三丁", 19);
    freq.put("ｰああ", 19);
    freq.put("倉三三", 17);
    freq.put("（日", 17);

    init3();
  }
  private static void init3() {
    
    freq.put("「並", 103);
    freq.put("丘三丁", 15);
    freq.put("「両", 68);
    freq.put("丘三三", 36);
    freq.put("ﾋ", 64);
    freq.put("国人", 16);
    freq.put("丘三丘", 11);
    freq.put("「丼", 17);
    freq.put("´ฅ", 8);
    freq.put("万両あ", 64);
    freq.put("「丹", 11);
    freq.put("＠", 104);
    freq.put("丘三並", 32);
    freq.put("「丁", 115);
    freq.put("´ิ", 43);
    freq.put("「丈", 14);
    freq.put("「三", 97);
    freq.put("＾＾＾", 11);
    freq.put("ｲﾄあ", 8);
    freq.put("ω ", 827);
    freq.put("「丘", 93);
    freq.put("。（", 78);
    freq.put("丘三之", 36);
    freq.put("丁並ア", 27);
    freq.put("´๑", 11);
    freq.put("「乱", 28);
    freq.put("ɞ", 8);
    freq.put("「之", 131);
    freq.put("「乞", 10);
    freq.put("「乙", 41);
    freq.put("､ああ", 10);
    freq.put("国並", 38);
    freq.put("国両", 13);
    freq.put("ωº", 8);
    freq.put("「亀", 37);
    freq.put("ω´", 42);
    freq.put("丁並あ", 489);
    freq.put("々あ之", 10);
    freq.put("国万", 23);
    freq.put("国丁", 17);
    freq.put("ああ←", 104);
    freq.put("国三", 24);
    freq.put("あ並国", 17);
    freq.put("↑↑", 10);
    freq.put("之丘三", 35);
    freq.put(" ꞌᴥ", 25);
    freq.put("之丘丁", 24);
    freq.put("大佐之", 11);
    freq.put("丁並、", 15);
    freq.put("丁並。", 8);
    freq.put("ｸﾚ", 15);
    freq.put("倉乱", 11);
    freq.put("ｸﾞ", 69);
    freq.put("ｸﾝ", 11);
    freq.put("丁並】", 19);
    freq.put("国之", 13);
    freq.put("　　　", 466);
    freq.put("◍ ", 31);
    freq.put("凄あ", 48);
    freq.put("あ（乙", 155);
    freq.put(" 並あ", 531);
    freq.put("且", 169);
    freq.put("あ大あ", 38);
    freq.put("∀･｀", 11);
    freq.put("─Ｏ", 11);
    freq.put("あ年", 33);
    freq.put("万倉", 50);
    freq.put(" ！ ", 115);
    freq.put("　　あ", 17);
    freq.put("之乙 ", 12);
    freq.put("´╹ ", 39);
    freq.put("日ああ", 541);
    freq.put(" 〜 ", 42);
    freq.put("あ┗ ", 10);
    freq.put("▓▓", 75);
    freq.put("▓▒", 12);
    freq.put("ア月", 64);
    freq.put("▓█", 12);
    freq.put("並乙之", 8);
    freq.put("人＿", 67);
    freq.put("･ω･", 169);
    freq.put("　　ア", 24);
    freq.put("ﾉ乙 ", 8);
    freq.put(" 裏", 12);
    freq.put("人？", 8);
    freq.put(" 【日", 8);
    freq.put("並乙三", 23);
    freq.put("◎", 55);
    freq.put("＿∧", 20);
    freq.put("倉三", 373);
    freq.put("④", 11);
    freq.put("ア之 ", 14);
    freq.put("！並三", 12);
    freq.put("】 ", 647);
    freq.put("ア（ ", 12);
    freq.put("◡╹ ", 33);
    freq.put("乙」 ", 18);
    freq.put(" 並ア", 19);
    freq.put("　＞ ", 8);
    freq.put(" ॢ", 43);
    freq.put("丘三倉", 11);
    freq.put("あ丹並", 12);
    freq.put("丈あ三", 33);
    freq.put("あ丹両", 14);
    freq.put(" ू", 30);
    freq.put("←←", 13);
    freq.put(" ु", 8);
    freq.put("あ丹丘", 9);
    freq.put("◒◝", 12);
    freq.put("あ彫", 9);
    freq.put("あ丹三", 12);
    freq.put(" 丘 ", 48);
    freq.put("ア乱之", 9);
    freq.put("僅あ", 12);
    freq.put("丁→", 8);
    freq.put("大佐三", 8);
    freq.put("丼並", 9);
    freq.put(" ऀ", 22);
    freq.put("あ丹乙", 25);
    freq.put("ｴ", 81);
    freq.put("͡͡", 26);
    freq.put("ｱｱ ", 8);
    freq.put("乱三 ", 16);
    freq.put("̼̮", 9);
    freq.put("並、丁", 9);
    freq.put("？（乙", 8);
    freq.put("；ω；", 49);
    freq.put("三あ中", 27);
    freq.put("¶", 14);
    freq.put("丑三", 25);
    freq.put("乱並三", 8);
    freq.put(" ＞ ", 49);
    freq.put(" д ", 14);
    freq.put("之丘倉", 10);
    freq.put("｢あ", 15);
    freq.put("乱並並", 193);
    freq.put("あ「ア", 43);
    freq.put("🎶", 11);
    freq.put("あ？之", 14);
    freq.put("あ！←", 14);
    freq.put(" ╬ ", 8);
    freq.put(" ੭", 35);
    freq.put("あ？乙", 47);
    freq.put("【両", 49);
    freq.put("【並", 90);
    freq.put("あア、", 104);
    freq.put("◟◉", 8);
    freq.put("【中", 9);
    freq.put("【丘", 29);
    freq.put(" 嗅丁", 14);
    freq.put("。侶", 22);
    freq.put("【丁", 99);
    freq.put("【万", 23);
    freq.put("（＾ω", 23);
    freq.put("∵", 21);
    freq.put(" ）あ", 18);
    freq.put("【三", 303);
    freq.put("丘あア", 117);
    freq.put("あ？三", 14);
    freq.put("【乱", 9);
    freq.put("あ？丁", 14);
    freq.put("丘中 ", 9);
    freq.put("あ？丘", 10);
    freq.put("丘丘ア", 8);
    freq.put("】ア", 171);
    freq.put("｀ﾟ", 15);
    freq.put(" ਊ", 13);
    freq.put("【乙", 36);
    freq.put("あ？並", 9);
    freq.put("ﾑﾞｫ", 8);
    freq.put("【之", 97);
    freq.put("ア日", 17);
    freq.put("🌲", 8);
    freq.put("🌳", 21);
    freq.put("！　", 65);
    freq.put("）", 1204);
    freq.put("。伎", 10);
    freq.put("🌽", 27);
    freq.put("人三並", 88);
    freq.put("丘あ「", 8);
    freq.put(" ՞ ", 89);
    freq.put("丘あ、", 33);
    freq.put("ﾞ", 510);
    freq.put("ＲＴあ", 14);
    freq.put("丘丘あ", 88);
    freq.put("【亀", 71);
    freq.put("】あ", 146);
    freq.put("三丁侶", 8);
    freq.put("人三三", 13);
    freq.put("͡ ", 15);
    freq.put("｀）", 21);
    freq.put("！「", 11);
    freq.put("。侶あ", 14);
    freq.put("あ之侶", 35);
    freq.put("丁三倉", 18);
    freq.put("丘ああ", 2252);
    freq.put("】【", 82);
    freq.put("並、之", 9);
    freq.put("₃ ", 10);
    freq.put("】　", 37);
    freq.put("乱アア", 16);
    freq.put("】「", 15);
    freq.put("】『", 16);
    freq.put(" 之あ", 662);
    freq.put("ア大丁", 28);
    freq.put("。亀", 12);
    freq.put("ア大万", 9);
    freq.put("三丁万", 13);
    freq.put("₍", 23);
    freq.put("ｴｴｴ", 52);
    freq.put("並あ！", 53);
    freq.put("あ之乱", 8);
    freq.put("←ああ", 21);
    freq.put("且並", 13);
    freq.put("伎あア", 24);
    freq.put("￣▽￣", 94);
    freq.put("三丁並", 51);
    freq.put("三丁両", 24);
    freq.put("あ之之", 257);
    freq.put("三並！", 18);
    freq.put(" ∩ ", 39);
    freq.put("あ之乙", 30);
    freq.put("。人", 12);
    freq.put("且丁", 17);
    freq.put(" 、 ", 74);
    freq.put("あ之並", 505);
    freq.put(" 之、", 12);
    freq.put("あ之両", 188);
    freq.put("三丁之", 57);
    freq.put(" 之々", 26);
    freq.put("あ之中", 13);
    freq.put(" 之「", 23);
    freq.put("三丁乙", 15);
    freq.put("あ之万", 62);
    freq.put("あ之丁", 262);
    freq.put("日あア", 118);
    freq.put("౪", 44);
    freq.put("あ之三", 357);
    freq.put(" 日ア", 13);
    freq.put("且之", 17);
    freq.put("　之之", 8);
    freq.put("あ之丘", 182);
    freq.put("。万", 18);
    freq.put("。一", 13);
    freq.put("。丁", 93);
    freq.put("⁾⁾", 24);
    freq.put("。丈", 14);
    freq.put("。三", 156);
    freq.put(" 日あ", 106);
    freq.put(" ௰", 8);
    freq.put("− ", 24);
    freq.put("。丑", 15);
    freq.put("ω･｡", 9);
    freq.put("乞丁", 19);
    freq.put("。丘", 60);
    freq.put("両日両", 11);
    freq.put("。並", 93);
    freq.put("。両", 73);
    freq.put(" ∩´", 11);
    freq.put("Ｓ", 12);
    freq.put("ω･｀", 9);
    freq.put("且ああ", 13);
    freq.put("。丹", 13);
    freq.put("д ", 32);
    freq.put("倉：", 10);
    freq.put("日あ、", 21);
    freq.put("丙三あ", 14);
    freq.put("。之", 116);
    freq.put("三三大", 14);
    freq.put("ア丁 ", 37);
    freq.put("倉！", 17);
    freq.put("。乙", 125);
    freq.put("あ之人", 14);
    freq.put(" 之ア", 52);
    freq.put("あ之亀", 42);
    freq.put("乞倖あ", 13);
    freq.put("あ。 ", 2347);
    freq.put("？」あ", 12);
    freq.put(" ﾐ ", 8);
    freq.put("。乱", 20);
    freq.put("仕ああ", 35);
    freq.put("丑）", 8);
    freq.put("伎ああ", 121);
    freq.put("あ爬あ", 9);
    freq.put("（；", 19);
    freq.put("가가가", 92);
    freq.put("三あ「", 28);
    freq.put("三あ」", 14);
    freq.put(" ౪", 12);
    freq.put("三あ、", 94);
    freq.put("三あ。", 48);
    freq.put("Σ ", 33);
    freq.put("あ、亀", 34);
    freq.put(" 〃ω", 10);
    freq.put("（＾", 52);
    freq.put("あ、人", 12);
    freq.put("あ、仕", 11);
    freq.put("兌倉あ", 26);
    freq.put("三ああ", 5362);
    freq.put(" 之 ", 126);
    freq.put("劈ああ", 17);
    freq.put("̨̨", 12);
    freq.put("両丘両", 9);
    freq.put("◡", 155);
    freq.put("◒◝ ", 12);
    freq.put("՞ةڼ", 9);
    freq.put("ｺﾄ", 15);
    freq.put("ｺﾞ", 18);
    freq.put("両丘三", 8);
    freq.put("日、三", 10);
    freq.put("〃", 93);
    freq.put("（ﾟ", 9);
    freq.put("之「あ", 28);
    freq.put("あ、丑", 22);
    freq.put("あ、丘", 118);
    freq.put("あ、丙", 10);
    freq.put("あ、万", 50);
    freq.put("あ、一", 19);
    freq.put("あ、丁", 218);
    freq.put("あ、丈", 36);
    freq.put("あ、三", 296);
    freq.put("̥", 247);
    freq.put("丼丼丼", 104);
    freq.put("あ｡ﾟ", 25);
    freq.put("三あア", 421);
    freq.put("▇█▓", 12);
    freq.put("あ、丹", 17);
    freq.put("あ、並", 197);
    freq.put("あ、両", 120);
    freq.put("　一人", 12);
    freq.put("乙）", 269);
    freq.put("ﾗｯｸ", 20);
    freq.put("ﾟДﾟ", 57);
    freq.put("乙！", 20);
    freq.put("ﾗｯｷ", 193);
    freq.put("あ、乙", 77);
    freq.put("「丑」", 9);
    freq.put("あ、之", 236);
    freq.put("あ、乱", 28);
    freq.put(" あ倉", 49);
    freq.put("ཽ", 8);
    freq.put(" 一両", 17);
    freq.put(" 一並", 8);
    freq.put("ア∀ア", 57);
    freq.put("＜", 250);
    freq.put("あ、侶", 28);
    freq.put("之。", 67);
    freq.put("之三乙", 22);
    freq.put("之　", 57);
    freq.put("之々", 65);
    freq.put("ア侶あ", 21);
    freq.put(" ２三", 9);
    freq.put(" 一三", 31);
    freq.put("之』", 17);
    freq.put("之」", 77);
    freq.put("之「", 69);
    freq.put("之三之", 105);
    freq.put("之】", 88);
    freq.put(" 一丘", 21);
    freq.put("๑╹◡", 16);
    freq.put("【三三", 176);
    freq.put("』 ", 148);
    freq.put("あ叶あ", 24);
    freq.put(" 仕丈", 11);
    freq.put(" 仕三", 43);
    freq.put("之三両", 35);
    freq.put("３ ", 17);
    freq.put("之三並", 78);
    freq.put("之あ", 6569);
    freq.put("之三丘", 21);
    freq.put(" 一之", 38);
    freq.put("両「 ", 12);
    freq.put("之三三", 127);
    freq.put("之三丁", 45);
    freq.put("之三万", 45);
    freq.put("之ア", 465);
    freq.put("一之 ", 8);
    freq.put("１日あ", 10);
    freq.put("丘「あ", 23);
    freq.put("あ、伎", 19);
    freq.put(" 一人", 13);
    freq.put("ॢ◡", 9);
    freq.put("■", 70);
    freq.put("伎之あ", 23);
    freq.put("之三人", 8);
    freq.put("三両ア", 16);
    freq.put("三ア之", 8);
    freq.put("乱」 ", 20);
    freq.put("之三亀", 12);
    freq.put("アああ", 5308);
    freq.put("〜！ ", 13);
    freq.put("呟あ", 75);
    freq.put("三乙 ", 16);
    freq.put("万あ万", 9);
    freq.put("〆", 8);
    freq.put("人両あ", 38);
    freq.put(" ๑", 325);
    freq.put("ア。並", 12);
    freq.put("ア三あ", 261);
    freq.put(" ั", 17);
    freq.put(" ิ", 34);
    freq.put(" ฺ", 9);
    freq.put("あ】ア", 18);
    freq.put("丘丁ア", 13);
    freq.put(" ง", 8);
    freq.put(" ฅ", 25);
    freq.put(" ｷｬ", 18);
    freq.put("४", 10);
    freq.put("˘⊖˘", 11);
    freq.put("＠⌒", 24);
    freq.put("年 ", 87);
    freq.put("三、丘", 10);
    freq.put("三丙あ", 14);
    freq.put(" ╮ ", 12);
    freq.put("ア～ ", 13);
    freq.put("あ並侶", 11);
    freq.put("丘！！", 12);
    freq.put("之侶あ", 66);
    freq.put("౪◔ ", 11);
    freq.put("∀ア", 58);
    freq.put("万三「", 10);
    freq.put("ア三ア", 15);
    freq.put("国之あ", 10);
    freq.put("ア？？", 11);
    freq.put("並在", 63);
    freq.put(" ┃ ", 12);
    freq.put("人両ア", 13);
    freq.put("乙あ倉", 8);
    freq.put("、 ", 612);
    freq.put("あ並両", 154);
    freq.put("あ並並", 565);
    freq.put("丘丈あ", 15);
    freq.put(" ┏━", 8);
    freq.put("０両", 10);
    freq.put("０並", 11);
    freq.put("´∀｀", 111);
    freq.put("あ並丹", 8);
    freq.put("あ並丼", 23);
    freq.put("あ並丁", 150);
    freq.put("あ並万", 66);
    freq.put("あ並三", 427);
    freq.put("あ並丈", 20);
    freq.put("ア丘之", 15);
    freq.put("̸", 26);
    freq.put("０三", 21);
    freq.put(" ´あ", 12);
    freq.put("あ三日", 69);
    freq.put("あ並乱", 8);
    freq.put("┓ ", 18);
    freq.put("並丹あ", 13);
    freq.put("あ大", 449);
    freq.put("万丘あ", 31);
    freq.put("亀あア", 32);
    freq.put("あ並之", 227);
    freq.put("アωア", 167);
    freq.put("ｰ", 611);
    freq.put("あ並乙", 43);
    freq.put(" 丙あ", 20);
    freq.put("乙倉あ", 18);
    freq.put("あ並人", 19);
    freq.put("あ並亀", 18);
    freq.put("丁年あ", 18);
    freq.put("三、之", 15);
    freq.put("ア中", 32);
    freq.put("佐之", 24);
    freq.put("乩あ", 19);
    freq.put("；ﾟД", 11);
    freq.put("大丼丘", 29);
    freq.put(" 〃 ", 18);
    freq.put("丁倉！", 9);
    freq.put(" ´ア", 114);
    freq.put("佐丘", 15);
    freq.put("佐丁", 15);
    freq.put("佐三", 16);
    freq.put("≡┗ ", 12);
    freq.put("´▽ ", 13);
    freq.put("「大", 11);
    freq.put("「之」", 37);
    freq.put("丁乙之", 10);
    freq.put("↑", 27);
    freq.put("ｼｮ", 12);
    freq.put("ｼｬ", 12);
    freq.put("、丘三", 9);
    freq.put("丈 ", 74);
    freq.put("是之是", 9);
    freq.put("丁乙三", 17);
    freq.put("乙丈あ", 31);
    freq.put("丁乙丁", 11);
    freq.put("ア万", 174);
    freq.put("あ両ア", 16);
    freq.put("丁乙丘", 13);
    freq.put("ア。之", 13);
    freq.put(" ?", 24);
    freq.put("人、ア", 9);
    freq.put("˙︶˙", 14);
    freq.put("あ　 ", 64);
    freq.put(" 月あ", 29);
    freq.put("ア万並", 13);
    freq.put("乙亀 ", 12);
    freq.put("】【丁", 9);
    freq.put("％", 67);
    freq.put("。∂）", 37);
    freq.put("、、あ", 11);
    freq.put("ア月あ", 28);
    freq.put("人、あ", 10);
    freq.put("ฅ｀", 8);
    freq.put("万： ", 9);
    freq.put("ﾚ", 37);
    freq.put(" ◠ ", 234);
    freq.put("之丁】", 20);
    freq.put("両乙あ", 30);
    freq.put("?🌳", 14);
    freq.put("あ両あ", 1387);
    freq.put(" ×", 31);
    freq.put("中国", 36);
    freq.put("あ国", 31);
    freq.put("之万之", 40);
    freq.put("?🌽", 20);
    freq.put("┻┳", 13);
    freq.put("、、、", 33);
    freq.put(" ¥", 12);
    freq.put(" ¨", 15);
    freq.put(" ¯", 11);
    freq.put("之万両", 10);
    freq.put(" ³", 13);
    freq.put(" ·", 13);
    freq.put(" ´", 1664);
    freq.put("之万並", 20);
    freq.put(" º", 26);
    freq.put("一並", 43);
    freq.put(" ¸", 13);
    freq.put("ڼ◔", 9);
    freq.put("≧", 141);
    freq.put("ｼﾞ", 34);
    freq.put(" ６月", 13);
    freq.put("⊃ ", 28);
    freq.put("之万丁", 18);
    freq.put("倉三並", 10);
    freq.put("⇒　", 9);
    freq.put("之万三", 14);
    freq.put(" ŧ", 15);
    freq.put("丁丘あ", 144);
    freq.put(" ｰ ", 30);
    freq.put("？乙乙", 8);
    freq.put("）（ ", 11);
    freq.put("ﾄ", 149);
    freq.put("亥", 49);
    freq.put("人的", 16);
    freq.put("アあ～", 8);
    freq.put(" ？」", 8);
    freq.put("̣̣̥", 8);
    freq.put("̼", 9);
    freq.put("̣̣̣", 40);
    freq.put("ﾟ ", 570);
    freq.put(" 侶あ", 262);
    freq.put(" ％ ", 10);
    freq.put("アあ＼", 11);
    freq.put("あ圓", 14);
    freq.put("一丹", 8);
    freq.put("←", 403);
    freq.put("之丁倉", 10);
    freq.put("アあ！", 138);
    freq.put("アあ？", 30);
    freq.put("ﾔｧ ", 17);
    freq.put(" ┓≡", 11);
    freq.put("ア→ア", 12);
    freq.put("｡ﾟ", 73);
    freq.put("｡･", 41);
    freq.put("┓", 194);
    freq.put("¸¸ ", 9);
    freq.put("ア→あ", 10);
    freq.put("万之万", 34);
    freq.put("両両 ", 46);
    freq.put("ﾟ´", 32);
    freq.put("Ｏ", 54);
    freq.put("＜ア", 22);
    freq.put("両倉あ", 49);
    freq.put("あ＞ω", 8);
    freq.put("亀丘！", 8);
    freq.put("ア！丁", 13);
    freq.put("あ１三", 8);
    freq.put("」⇒「", 22);
    freq.put("丁丘ア", 15);
    freq.put("ア！三", 10);
    freq.put("亀之 ", 11);
    freq.put("」あ ", 10);
    freq.put("２人", 10);
    freq.put("༎", 16);
    freq.put("あ丘亀", 29);
    freq.put("之在あ", 23);
    freq.put("あ呟", 14);
    freq.put("あ丘人", 36);
    freq.put(" ੭ु", 31);
    freq.put("丘三万", 9);
    freq.put("＿人人", 68);
    freq.put("～ア", 41);
    freq.put("一あ", 72);
    freq.put("᷅", 8);
    freq.put("┏━━", 11);
    freq.put("日 ", 226);
    freq.put(" 万ア", 25);
    freq.put("１人あ", 8);
    freq.put("ॢ", 55);
    freq.put("͡͡͡", 24);
    freq.put("ｹﾃﾞ", 8);
    freq.put("θ｀", 15);
    freq.put("＾） ", 27);
    freq.put("あ丘丘", 62);
    freq.put("弁ああ", 23);
    freq.put(" ˡ", 9);
    freq.put("〇", 11);
    freq.put("あ丘三", 120);
    freq.put("あ丘丈", 14);
    freq.put("２並", 14);
    freq.put("～」", 13);
    freq.put("あ丘丁", 123);
    freq.put("～、", 11);
    freq.put("～。", 16);
    freq.put("あ丘万", 37);
    freq.put("一ア", 14);
    freq.put(" ˃", 17);
    freq.put(" ˆ", 37);
    freq.put(" ˇ", 8);
    freq.put(" ˊ", 9);
    freq.put("º", 66);
    freq.put("あ丘中", 22);
    freq.put("あ丘両", 47);
    freq.put(" ˘", 110);
    freq.put("∞", 25);
    freq.put("２三", 13);
    freq.put("あ丘並", 86);
    freq.put("あ丘乙", 37);
    freq.put("丘三両", 9);
    freq.put("あωア", 11);
    freq.put("あ丘之", 85);
    freq.put("⇒", 127);
    freq.put("ﾟω", 22);
    freq.put("ｙ", 10);
    freq.put("～あ", 154);
    freq.put(" ʃ", 12);
    freq.put("あ丘乱", 8);
    freq.put("Ｏ（≧", 11);
    freq.put("アД ", 16);
    freq.put(" ʔ", 14);
    freq.put("三三倉", 22);
    freq.put("２之", 12);
    freq.put(" 両丁", 67);
    freq.put("ﾃ", 257);
    freq.put(" ͡", 9);
    freq.put(" 両万", 18);
    freq.put(" 両三", 178);
    freq.put("【日", 9);
    freq.put("̩̩", 12);
    freq.put(" ╰ ", 10);
    freq.put(" 両丘", 26);
    freq.put("８", 43);
    freq.put(" 両両", 118);
    freq.put("ऀ ", 18);
    freq.put(" 両並", 116);
    freq.put(" ͈", 26);
    freq.put("あ丘侶", 10);
    freq.put(" ͒", 10);
    freq.put(" ͞", 9);
    freq.put("･あﾟ", 61);
    freq.put("◜◒", 12);
    freq.put(" ̥", 38);
    freq.put(" ̫", 30);
    freq.put("）ああ", 72);
    freq.put(" 両之", 53);
    freq.put("之　あ", 8);
    freq.put("、乞あ", 8);
    freq.put("丘両 ", 20);
    freq.put(" 両乙", 12);
    freq.put("在 ", 12);
    freq.put(" ̀", 54);
    freq.put(" ́", 54);
    freq.put("◜◡", 15);
    freq.put("ﾞ ", 52);
    freq.put("）ア", 46);
    freq.put("伎丁あ", 13);
    freq.put("あ嗅", 23);
    freq.put("ꞌ ", 25);
    freq.put("丞ああ", 15);
    freq.put("、あ之", 12);
    freq.put("並之日", 14);
    freq.put(" ϶", 11);
    freq.put("）あ", 109);
    freq.put(" σ", 45);
    freq.put("！⇒⇒", 9);
    freq.put("ア万丁", 32);
    freq.put("ة", 10);
    freq.put(" ω", 729);
    freq.put("】　 ", 16);
    freq.put("、あ丁", 13);
    freq.put("、あ三", 16);
    freq.put("、あ丑", 9);
    freq.put("）」", 22);
    freq.put("中アア", 9);
    freq.put(" ε", 28);
    freq.put("）、", 9);
    freq.put("）　", 14);
    freq.put("）。", 8);
    freq.put(" ξ", 17);
    freq.put("´︶ ", 11);
    freq.put("あ喫", 29);
    freq.put("倉之あ", 53);
    freq.put("ｷｬｯ", 45);
    freq.put(" Θ", 34);
    freq.put("嗅三", 13);
    freq.put(" ᴗ ", 42);
    freq.put("之中 ", 26);
    freq.put("¸ ", 13);
    freq.put("嗅丁", 22);
    freq.put("░", 24);
    freq.put("！⇒", 10);
    freq.put("▽￣", 94);
    freq.put(" 丼三", 8);
    freq.put("日両あ", 11);
    freq.put("･ﾟ･", 14);
    freq.put("ｂ", 8);
    freq.put("丼丘あ", 23);
    freq.put("！←", 29);
    freq.put("アあ「", 19);
    freq.put(" з", 17);
    freq.put(" д", 19);
    freq.put(" о", 26);
    freq.put("┘└", 8);
    freq.put("▽ﾟ", 139);
    freq.put("¯ ", 9);
    freq.put(" Д", 25);
    freq.put("乱倉あ", 11);
    freq.put("¸¸", 10);
    freq.put("ʔ", 22);
    freq.put("▒░ ", 11);
    freq.put("ア万三", 12);
    freq.put("丞あ", 22);
    freq.put("ω＾）", 24);
    freq.put("乞」 ", 10);
    freq.put("あ倉倉", 11);
    freq.put(" ´θ", 15);
    freq.put("▽｀", 93);
    freq.put("ｉ ", 22);
    freq.put(" ´ε", 35);
    freq.put("丁あ！", 60);
    freq.put("丁！！", 13);
    freq.put("あ劈", 8);
    freq.put("？アア", 33);
    freq.put("丁あ？", 24);
    freq.put("▓", 104);
    freq.put("▽；", 28);
    freq.put("丘丁丘", 8);
    freq.put("あ万丁", 130);
    freq.put("あ万万", 26);
    freq.put("あ万三", 106);
    freq.put("伎ア", 24);
    freq.put("ﾟД", 57);
    freq.put("､ ", 30);
    freq.put("丘丁丈", 8);
    freq.put("丘丁三", 70);
    freq.put("月三", 38);
    freq.put("あ万丘", 16);
    freq.put("丘丁丁", 148);
    freq.put("月丁", 19);
    freq.put("月万", 19);
    freq.put("あ万両", 29);
    freq.put("あ万並", 87);
    freq.put("倉丁並", 8);
    freq.put("＿∧ ", 17);
    freq.put("　｜ ", 8);
    freq.put("丁之ア", 26);
    freq.put("月並", 8);
    freq.put("丘丁並", 218);
    freq.put(" 丁 ", 78);
    freq.put("＜⌒", 8);
    freq.put("倉丁之", 10);
    freq.put("あ万之", 104);
    freq.put("あ･･", 19);
    freq.put("月之", 13);
    freq.put("丘丁之", 19);
    freq.put("あ＾＾", 16);
    freq.put("ิω･", 10);
    freq.put("之亀あ", 67);
    freq.put("ｬ", 120);
    freq.put("あ亀あ", 590);
    freq.put("兕ああ", 8);
    freq.put("万 ", 278);
    freq.put("〕", 12);
    freq.put("⁾", 50);
    freq.put("あ之日", 276);
    freq.put("丁之】", 19);
    freq.put("】アア", 169);
    freq.put("》 ", 25);
    freq.put("丁之。", 22);
    freq.put("並丘ア", 9);
    freq.put("伎「", 35);
    freq.put("あ叶", 24);
    freq.put("三国あ", 21);
    freq.put("ﾝ ", 49);
    freq.put("あ傭あ", 15);
    freq.put("之丘之", 25);
    freq.put("日あ乙", 18);
    freq.put("丁之あ", 308);
    freq.put("、並倉", 8);
    freq.put("　ﾗｯ", 191);
    freq.put("伎あ", 367);
    freq.put("並亀 ", 11);
    freq.put("あ中国", 10);
    freq.put(" ┓┛", 13);
    freq.put("　一", 14);
    freq.put("　丁", 73);
    freq.put("アア之", 323);
    freq.put("　万", 15);
    freq.put(" ┓┓", 13);
    freq.put("倉あ。", 12);
    freq.put("　三", 136);
    freq.put("／ア ", 9);
    freq.put("アア乙", 99);
    freq.put("ｗｗア", 11);
    freq.put("　丘", 221);
    freq.put("叶ああ", 24);
    freq.put("　両", 47);
    freq.put("　並", 74);
    freq.put(" و", 15);
    freq.put("４三", 10);
    freq.put("　丹", 9);
    freq.put("･･ ", 19);
    freq.put("アア乱", 38);
    freq.put("アア三", 643);
    freq.put("アア丈", 55);
    freq.put("アア万", 151);
    freq.put("　之", 277);
    freq.put("倉ああ", 1584);
    freq.put("あ倉", 1552);
    freq.put("アア丁", 452);
    freq.put("／ ", 261);
    freq.put("あ倖", 65);
    freq.put("アア丙", 8);
    freq.put("アア丘", 243);
    freq.put("　乙", 26);
    freq.put("アア丑", 10);
    freq.put("倉三日", 99);
    freq.put("｡ああ", 10);
    freq.put(" アア", 6270);
    freq.put("アア並", 355);
    freq.put("之並人", 9);
    freq.put("アア両", 253);
    freq.put("アア丼", 14);
    freq.put("あ倹", 54);
    freq.put("！", 8306);
    freq.put("あ僅", 10);
    freq.put("　亀", 16);
    freq.put("乙之万", 18);
    freq.put("人人人", 284);
    freq.put(" アあ", 75);
    freq.put("乙之三", 21);
    freq.put(" ۶", 49);
    freq.put("、三之", 57);
    freq.put("ﾖ", 15);
    freq.put("乙之丘", 10);
    freq.put("之並之", 51);
    freq.put("並的あ", 18);
    freq.put("乙之並", 9);
    freq.put("̩", 20);
    freq.put("倉あア", 75);
    freq.put("あ＜ ", 12);
    freq.put("乙之中", 25);
    freq.put("丁？ ", 11);
    freq.put("ｗｗ」", 11);
    freq.put("ξ", 27);
    freq.put("、三丘", 10);
    freq.put(" 」あ", 44);
    freq.put(" ア。", 10);
    freq.put(" ア「", 13);
    freq.put("之あ ", 159);
    freq.put("之並丘", 30);
    freq.put("アア亀", 66);
    freq.put("之並万", 10);
    freq.put("◒", 17);
    freq.put("、三三", 95);
    freq.put("之並丁", 21);
    freq.put("、三万", 33);
    freq.put("、三丁", 29);
    freq.put("之並三", 99);
    freq.put("三?", 18);
    freq.put("あ傭", 28);
    freq.put("｀ω´", 34);
    freq.put("　／　", 11);
    freq.put("之並並", 61);
    freq.put("アア人", 10);
    freq.put("之並両", 33);
    freq.put("三 ", 1663);
    freq.put("、三並", 40);
    freq.put("、三両", 18);
    freq.put(" 　両", 8);
    freq.put(" 　並", 17);
    freq.put("あ兌", 29);
    freq.put("　伎", 8);
    freq.put(" ̫ ", 17);
    freq.put("並日", 31);
    freq.put("｜　", 16);
    freq.put(" 　丁", 11);
    freq.put(" 　三", 27);
    freq.put("」　あ", 14);
    freq.put("丶", 9);
    freq.put(" 三あ", 525);
    freq.put(" 　丘", 190);
    freq.put("アア伎", 8);
    freq.put("両人あ", 14);
    freq.put("両並！", 13);
    freq.put(" 　之", 206);
    freq.put(" 三】", 15);
    freq.put("ﾐ ", 11);
    freq.put("┌┛", 11);
    freq.put(" 三「", 14);
    freq.put(" 三　", 23);
    freq.put("！（乙", 13);
    freq.put("あ凄", 30);
    freq.put("丁亀三", 10);
    freq.put("あ丁？", 8);
    freq.put("『【", 11);
    freq.put(" 両あ", 378);
    freq.put("丁亀丘", 8);
    freq.put("╹◡╹", 49);
    freq.put("Ｋ", 9);
    freq.put("的ああ", 59);
    freq.put("倣丁之", 8);
    freq.put("　並あ", 14);
    freq.put("　侶", 8);
    freq.put("冴", 28);
    freq.put("ຶ", 30);
    freq.put("ア一三", 9);
    freq.put("之呟あ", 57);
    freq.put("仕並あ", 8);
    freq.put("侮丼あ", 9);
    freq.put(" 三ア", 33);
    freq.put("░▒", 12);
    freq.put("彫", 22);
    freq.put("あ冴", 8);
    freq.put(" 　仕", 189);
    freq.put("アア侶", 38);
    freq.put("　丘あ", 9);
    freq.put("┗┏┗", 34);
    freq.put(" ！あ", 20);
    freq.put("　　 ", 328);
    freq.put("ωア｀", 43);
    freq.put("之乙あ", 54);
    freq.put(" ॢ◡", 9);
    freq.put("⌒＠ ", 24);
    freq.put("ア之ア", 12);
    freq.put("ア（ア", 19);
    freq.put(" ！」", 41);
    freq.put(" 並 ", 92);
    freq.put("（╹◡", 16);
    freq.put("ア之あ", 132);
    freq.put(" ｳｩ", 8);
    freq.put("┓┓┓", 48);
    freq.put("之之倉", 13);
    freq.put("┓┓┃", 12);
    freq.put("５あ", 8);
    freq.put("並＼ ", 9);
    freq.put(" 〜ア", 8);
    freq.put(" アิ", 8);
    freq.put("、日三", 11);
    freq.put("∂", 55);
    freq.put(" 人三", 28);
    freq.put("あ（≧", 24);
    freq.put("４", 85);
    freq.put("人人", 362);
    freq.put("丘人あ", 35);
    freq.put("ﾀﾞ", 19);
    freq.put("ああ∧", 18);
    freq.put(" 丘あ", 594);
    freq.put(" 人並", 40);
    freq.put("──Ｏ", 11);
    freq.put("並日あ", 16);
    freq.put("＿；）", 19);
    freq.put("͒ ", 10);
    freq.put(" ＞ア", 9);
    freq.put(" 丘「", 35);
    freq.put("並之弁", 8);
    freq.put(" 丘、", 10);
    freq.put("あ「 ", 19);
    freq.put("人並", 142);
    freq.put("人両", 93);
    freq.put("；∀", 38);
    freq.put("∧ ", 99);
    freq.put("＆三", 8);
    freq.put("人三", 228);
    freq.put("人万", 31);
    freq.put("人丁", 23);
    freq.put("人丘", 23);
    freq.put(" 人人", 9);
    freq.put(" ＞あ", 8);
    freq.put("˂", 29);
    freq.put(" 丘ア", 20);
    freq.put("ㅋ", 37);
    freq.put("≦）Ｏ", 11);
    freq.put(" ┻┳", 8);
    freq.put("人之", 27);
    freq.put("人乙", 9);
    freq.put(" ＞　", 9);
    freq.put("ｿ", 22);
    freq.put("並あ丑", 14);
    freq.put("並あ丘", 96);
    freq.put(" 「之", 55);
    freq.put("三並並", 93);
    freq.put("並あ一", 31);
    freq.put("並あ万", 50);
    freq.put("三並両", 56);
    freq.put("並あ三", 348);
    freq.put("並あ丈", 27);
    freq.put("ｯｷｰ", 194);
    freq.put(" 「乙", 22);
    freq.put("叶あ", 29);
    freq.put("並あ丹", 8);
    freq.put("三並丘", 17);
    freq.put("丘中あ", 42);
    freq.put("並あ丼", 8);
    freq.put("並あ両", 132);
    freq.put("三並万", 21);
    freq.put("三並丁", 88);
    freq.put(" 「乱", 15);
    freq.put("町", 38);
    freq.put("三並三", 110);
    freq.put("並あ中", 25);
    freq.put("＾", 499);
    freq.put(" 「万", 9);
    freq.put(" 「丁", 52);
    freq.put("並あ乙", 87);
    freq.put(" 「三", 36);
    freq.put("並アア", 391);
    freq.put(" ） ", 61);
    freq.put("倉亀", 41);
    freq.put("ｯｸあ", 12);
    freq.put(" 「丘", 37);
    freq.put(" 「並", 43);
    freq.put("並あ乱", 21);
    freq.put("倉人", 10);
    freq.put("あ之！", 17);
    freq.put(" 「両", 30);
    freq.put("◞౪", 14);
    freq.put("三並之", 79);
    freq.put("倉乙", 24);
    freq.put("「三あ", 13);
    freq.put("･･", 93);
    freq.put("％　あ", 8);
    freq.put("･｡", 48);
    freq.put("倉之", 134);
    freq.put("並あ亀", 47);
    freq.put("ああ→", 67);
    freq.put("ʔ ", 8);
    freq.put("」∠", 46);
    freq.put("あ三倉", 90);
    freq.put("丑乙", 9);
    freq.put(" ￣￣", 34);
    freq.put("･｀", 42);
    freq.put("／＜ ", 8);
    freq.put("丑之", 12);
    freq.put("丘あ ", 202);
    freq.put("倉丙", 13);
    freq.put("倉丘", 69);
    freq.put("－ ", 8);
    freq.put(" 「亀", 18);
    freq.put("＿＿／", 17);
    freq.put("三人あ", 86);
    freq.put("人あ倉", 11);
    freq.put("丑両", 8);
    freq.put("倉丈", 12);
    freq.put("丘丘 ", 11);
    freq.put("丑並", 14);
    freq.put("倉丁", 270);
    freq.put("倉一", 8);
    freq.put("倉万", 57);
    freq.put("：ああ", 17);
    freq.put("丑丘", 8);
    freq.put("￣∇", 19);
    freq.put("倉中", 13);
    freq.put("叶", 30);
    freq.put("倉両", 133);
    freq.put("＿＿＿", 73);
    freq.put("倉並", 210);
    freq.put("丹日 ", 9);
    freq.put("並三ア", 41);
    freq.put("´∇", 19);
    freq.put(" 丈並", 42);
    freq.put("´∀", 157);
    freq.put(" 、あ", 23);
    freq.put(" 丈丘", 11);
    freq.put("丹あ", 291);
    freq.put("ﾁｭ", 9);
    freq.put("ﾁｬ", 10);
    freq.put(" 丈三", 18);
    freq.put("ﾁｷ", 9);
    freq.put("あ： ", 15);
    freq.put(" 丈丁", 12);
    freq.put("дア", 18);
    freq.put("あ？（", 9);
    freq.put("あ？！", 31);
    freq.put(" ´д", 13);
    freq.put("≖", 8);
    freq.put("、丈あ", 26);
    freq.put(" 丈乙", 8);
    freq.put("ｨ", 27);
    freq.put(" ´Д", 68);
    freq.put("あ。ア", 136);
    freq.put("◯", 14);
    freq.put("倉侶", 13);
    freq.put(" 丈之", 13);
    freq.put("あ丁。", 11);
    freq.put(" ┘└", 8);
    freq.put("´⊙", 9);
    freq.put("三", 25091);
    freq.put("あ。あ", 510);
    freq.put("？」 ", 110);
    freq.put("伎あ ", 16);
    freq.put("亞", 11);
    freq.put("並あ侶", 35);
    freq.put("あ丼あ", 119);
    freq.put("並三。", 15);
    freq.put("並三、", 16);
    freq.put("ア丁あ", 214);
    freq.put("あ。』", 10);
    freq.put("あ。」", 35);
    freq.put("あ。「", 9);
    freq.put("あ。。", 90);
    freq.put("あ。　", 71);
    freq.put("並大", 22);
    freq.put("乎", 8);
    freq.put("ﾁﾝ", 8);
    freq.put("、侶あ", 26);
    freq.put("あ。【", 22);
    freq.put("万年あ", 13);
    freq.put("日あ ", 60);
    freq.put(" 日 ", 132);
    freq.put("並三あ", 669);
    freq.put("௰", 15);
    freq.put("人！", 15);
    freq.put("三あ ", 322);
    freq.put("о´∀", 10);
    freq.put("┘└ ", 8);
    freq.put("┐ｹ", 8);
    freq.put("´あω", 11);
    freq.put("あ三国", 9);
    freq.put("。丁丁", 8);
    freq.put("。丁三", 8);
    freq.put("嗅ああ", 28);
    freq.put("´╹", 39);
    freq.put("〃 ", 51);
    freq.put("丁「あ", 27);
    freq.put("╰ ", 31);
    freq.put("之三！", 13);
    freq.put("ง", 8);
    freq.put("あ＿ ", 17);
    freq.put("丁「ア", 9);
    freq.put("ああ┗", 9);
    freq.put("ﾒ", 13);
    freq.put(" ◞ ", 10);
    freq.put("´▽", 105);
    freq.put("兌あ", 13);
    freq.put("年あ", 144);
    freq.put("中丁あ", 9);
    freq.put("´△", 13);
    freq.put("？！？", 28);
    freq.put("丁日あ", 9);
    freq.put(" ´ω", 101);
    freq.put("̀ω ", 18);
    freq.put("「日", 13);
    freq.put("ෆ", 11);
    freq.put("´◔", 22);
    freq.put("００", 48);
    freq.put("⃘", 12);
    freq.put("⊃━ ", 18);
    freq.put("´◡", 12);
    freq.put("之 ", 943);
    freq.put("ʅ", 12);
    freq.put(" ´艸", 55);
    freq.put("（丑", 8);
    freq.put("『", 570);
    freq.put(" ՞ة", 9);
    freq.put("（三", 92);
    freq.put("¯", 28);
    freq.put("（丁", 34);
    freq.put("あ日三", 59);
    freq.put("』あ", 131);
    freq.put("３あ", 9);
    freq.put("（両", 19);
    freq.put("（並", 25);
    freq.put("（乙", 267);
    freq.put("─Ｏ（", 11);
    freq.put("乙亀", 116);
    freq.put("」⇒", 22);
    freq.put("三両 ", 54);
    freq.put("乙亙", 10);
    freq.put("（之", 41);
    freq.put("￣▽", 94);
    freq.put(" 【倉", 14);
    freq.put("ิ∀´", 17);
    freq.put("』【", 8);
    freq.put("乙之", 299);
    freq.put("あ一人", 22);
    freq.put("乙乙", 150);
    freq.put("≡┏", 11);
    freq.put("（亀", 16);
    freq.put(" ਊ ", 11);
    freq.put("ﾞｫｰ", 8);
    freq.put("Ｇ", 10);
    freq.put(" ´˘", 8);
    freq.put("┛ ", 36);
    freq.put("乙乱", 13);
    freq.put("乙三", 335);
    freq.put("乙丈", 51);
    freq.put("ɷ", 14);
    freq.put(" × ", 24);
    freq.put("乙丁", 251);
    freq.put(" ฅ ", 20);
    freq.put("乙万", 50);
    freq.put("乙丙", 11);
    freq.put("乙丘", 133);
    freq.put("アあ ", 665);
    freq.put("一之あ", 51);
    freq.put("。← ", 13);
    freq.put(" 乱両", 28);
    freq.put("乙両", 120);
    freq.put("～。 ", 8);
    freq.put("乙並", 156);
    freq.put("乙丹", 20);
    freq.put("日あ並", 243);
    freq.put("ｧｱ", 17);
    freq.put("ア～ア", 12);
    freq.put("ｧｧ", 30);
    freq.put("乱倉", 14);
    freq.put("ああ└", 8);
    freq.put("？ああ", 207);
    freq.put("丁弁日", 17);
    freq.put("∀ ", 106);
    freq.put("；▽", 28);
    freq.put("０％", 10);
    freq.put("三之万", 22);
    freq.put(" 乱之", 9);
    freq.put("三乙あ", 90);
    freq.put("ºωº", 8);
    freq.put("ｼﾞｬ", 12);
    freq.put(" 乱並", 212);
    freq.put("丘あ大", 10);
    freq.put("、ア", 559);
    freq.put(" 乱丁", 21);
    freq.put("」→", 19);
    freq.put(" 乱三", 14);
    freq.put("亀あ", 1362);
    freq.put("、あ", 1690);
    freq.put("喫ああ", 18);
    freq.put("■乱", 8);
    freq.put("あ丙あ", 67);
    freq.put("᷄", 11);
    freq.put("ﾙ ", 18);
    freq.put(" 侮あ", 32);
    freq.put("∀´", 23);
    freq.put("あ「あ", 64);
    freq.put("、、", 94);
    freq.put("、。", 10);
    freq.put("ああ○", 10);
    freq.put("丁倉丘", 10);
    freq.put("╹◡", 49);
    freq.put("、「", 23);
    freq.put("、『", 9);
    freq.put("ｑ", 8);
    freq.put(" ＠⌒", 24);
    freq.put("丁倉三", 9);
    freq.put(" 中国", 15);
    freq.put("丁倉丁", 9);
    freq.put("╭", 26);
    freq.put("", 10);
    freq.put("๑´ ", 10);
    freq.put("丁倉並", 8);
    freq.put("年ア", 15);
    freq.put("｣ああ", 13);
    freq.put("〃ω〃", 10);
    freq.put("三丘三", 32);
    freq.put("･｡ ", 28);
    freq.put("三丘丁", 42);
    freq.put("三丘万", 10);
    freq.put("０", 171);
    freq.put("三丘丘", 16);
    freq.put("両両！", 11);
    freq.put("「倉", 24);
    freq.put(" ＋ ", 17);
    freq.put("両国", 15);
    freq.put("三丘両", 9);
    freq.put("三丘並", 17);
    freq.put("┬", 11);
    freq.put("あДあ", 14);
    freq.put("三丘之", 22);
    freq.put("＋ ", 21);
    freq.put("ああ侮", 41);
    freq.put("ア＞ ", 8);
    freq.put("˙", 95);
    freq.put(" ´ ", 515);
    freq.put("🌳?", 15);
    freq.put("ア倉", 132);
    freq.put("三之乙", 9);
    freq.put("〃ω", 10);
    freq.put("Θ", 38);
    freq.put("´ω ", 88);
    freq.put("ºั", 18);
    freq.put("三侶並", 10);
    freq.put("∂ ", 12);
    freq.put("ั", 53);
    freq.put("ああ꒰", 30);
    freq.put(" ´´", 17);
    freq.put("乞丁あ", 10);
    freq.put("亀あ ", 64);
    freq.put("日侶並", 14);
    freq.put("?三", 20);
    freq.put("ｻ", 46);
    freq.put("ああ／", 12);
    freq.put("あ　あ", 77);
    freq.put("丈。", 9);
    freq.put("丈　", 9);
    freq.put(" 月 ", 205);
    freq.put("アあ乱", 17);
    freq.put(" あ", 15841);
    freq.put("アあ之", 300);
    freq.put("∇｀ ", 14);
    freq.put(" о´", 11);
    freq.put("アあ乙", 96);
    freq.put("ああ＆", 15);
    freq.put("アあ中", 14);
    freq.put("◉", 35);
    freq.put("アあ並", 307);
    freq.put("アあ両", 183);
    freq.put("あ　　", 16);
    freq.put("アあ丼", 12);
    freq.put("ﾃﾞ", 35);
    freq.put("アあ丹", 18);
    freq.put("丈あ", 726);
    freq.put("ﾃﾑ", 193);
    freq.put(" 。", 275);
    freq.put(" 〃", 59);
    freq.put(" 　", 2082);
    freq.put(" 、", 178);
    freq.put("ｸﾝｸ", 8);
    freq.put("アあ三", 432);
    freq.put("！両あ", 22);
    freq.put("アあ万", 62);
    freq.put("あ是", 25);
    freq.put(" 『", 378);
    freq.put(" 』", 88);
    freq.put("アあ丁", 339);
    freq.put("アあ一", 41);
    freq.put(" 【", 1250);
    freq.put(" 】", 156);
    freq.put("アあ丙", 11);
    freq.put("アあ丘", 150);
    freq.put("あ三人", 53);
    freq.put(" 〜", 98);
    freq.put("丘並之", 24);
    freq.put("̫͡", 9);
    freq.put("両→", 8);
    freq.put("丈ア", 49);
    freq.put("≦）", 43);
    freq.put("アあ仕", 13);
    freq.put("丘人 ", 12);
    freq.put(" ア", 7437);
    freq.put("╹）", 16);
    freq.put("亀丘三", 8);
    freq.put("「倉」", 8);
    freq.put("亀丘丁", 135);
    freq.put("⊃　", 11);
    freq.put("ア〜 ", 12);
    freq.put("丘並万", 13);
    freq.put("⇒ ", 36);
    freq.put("アあ人", 24);
    freq.put("あ両 ", 21);
    freq.put("乙亀あ", 80);
    freq.put("あ両並", 168);
    freq.put("、、 ", 22);
    freq.put("̫̮", 10);
    freq.put("アあ亀", 35);
    freq.put("あ　ア", 39);
    freq.put("?󾮔", 12);
    freq.put("乱両、", 8);
    freq.put("º·", 24);
    freq.put(" 侶 ", 15);
    freq.put("ｸﾞあ", 21);
    freq.put("両両ア", 45);
    freq.put(" ％あ", 14);
    freq.put("侮人", 10);
    freq.put(" ՞ਊ", 99);
    freq.put("╮╯╭", 16);
    freq.put("＾Ｏ＾", 11);
    freq.put(" ´ิ", 8);
    freq.put("あ月", 31);
    freq.put("ﾌﾞ", 47);
    freq.put("１ア", 9);
    freq.put("乱両あ", 33);
    freq.put("両乙三", 11);
    freq.put("´д ", 9);
    freq.put("ﾟあ", 19);
    freq.put("之！！", 16);
    freq.put(" ■ ", 13);
    freq.put("､", 87);
    freq.put("之ア並", 9);
    freq.put("日万之", 9);
    freq.put("丁丘 ", 32);
    freq.put(" ´ฅ", 8);
    freq.put("！之日", 16);
    freq.put("ةڼ◔", 9);
    freq.put("亀丘 ", 20);
    freq.put("█", 38);
    freq.put("【並之", 13);
    freq.put(" ｉ ", 22);
    freq.put("両両】", 10);
    freq.put(" 󾮔", 22);
    freq.put("倉乙あ", 9);
    freq.put("１あ", 19);
    freq.put("侮丼", 15);
    freq.put("乱両ア", 10);
    freq.put("ﾟア", 15);
    freq.put("【並丁", 11);
    freq.put("【並万", 8);
    freq.put("両両あ", 262);
    freq.put("┓┃ ", 8);
    freq.put("アあ侶", 31);
    freq.put("両倉 ", 12);
    freq.put("【並両", 12);
    freq.put("【並並", 14);
    freq.put("Ｏ＾", 11);
    freq.put("ア→ ", 10);
    freq.put(" ｢", 29);
    freq.put("ﾄﾞ", 66);
    freq.put("⊂⌒", 9);
    freq.put("丘", 7903);
    freq.put("丑あ之", 8);
    freq.put("」あ「", 16);
    freq.put("一 ", 13);
    freq.put("」あ、", 11);
    freq.put("日あ", 1443);
    freq.put("و", 15);
    freq.put("丑あ三", 14);
    freq.put("日」", 9);
    freq.put("日「", 8);
    freq.put("ºω", 8);
    freq.put(" ｳ", 31);
    freq.put("日々", 9);
    freq.put(" ﾉﾟ", 9);
    freq.put("日、", 56);
    freq.put("日　", 9);
    freq.put("」ああ", 174);
    freq.put("日。", 46);
    freq.put("丑あ両", 64);
    freq.put("亀之ア", 27);
    freq.put("【丁乙", 10);
    freq.put("」あア", 29);
    freq.put("ﾎ", 34);
    freq.put(" ｺ", 13);
    freq.put(" ｻ", 9);
    freq.put("【丁之", 9);
    freq.put("；▽；", 28);
    freq.put("、倉あ", 27);
    freq.put("瀧", 11);
    freq.put("～ ", 406);
    freq.put("˃̶", 9);
    freq.put("φ", 8);
    freq.put("三：ア", 21);
    freq.put("日ア", 76);
    freq.put("【丁丁", 27);
    freq.put(" 万 ", 26);
    freq.put("、乱あ", 19);
    freq.put("【丁三", 9);
    freq.put("× ", 59);
    freq.put("三） ", 31);
    freq.put("中三", 37);
    freq.put("【丁両", 8);
    freq.put(" ▽ ", 339);
    freq.put("【丁並", 13);
    freq.put("並倉", 284);
    freq.put("侃", 46);
    freq.put("月", 558);
    freq.put("´艸 ", 19);
    freq.put(" 亀 ", 14);
    freq.put("ﾞあ", 39);
    freq.put(" ？？", 13);
    freq.put("中並あ", 9);
    freq.put("）あ ", 13);
    freq.put("在", 124);
    freq.put("丑三あ", 12);
    freq.put("∇≦", 57);
    freq.put("在あ", 46);
    freq.put("丘両あ", 73);
    freq.put("丹丘あ", 14);
    freq.put("中之あ", 24);
    freq.put("┃ ", 35);
    freq.put("並並倉", 12);
    freq.put("ॢ ", 27);
    freq.put("あ三大", 15);
    freq.put(" ｜ ", 27);
    freq.put("乙三之", 15);
    freq.put("あ伎之", 22);
    freq.put("倉之 ", 16);
    freq.put("ｩｯ", 8);
    freq.put("あ日", 248);
    freq.put("Ｃ", 13);
    freq.put("２０", 9);
    freq.put("２９", 13);
    freq.put("年並あ", 15);
    freq.put("】並三", 12);
    freq.put("乙三万", 14);
    freq.put("ˆ", 72);
    freq.put("並国並", 8);
    freq.put("乙三三", 18);
    freq.put("乙", 5915);
    freq.put(" アД", 19);
    freq.put("̫ ", 25);
    freq.put("🌽?", 20);
    freq.put("～？ ", 8);
    freq.put("¨", 17);
    freq.put("） ", 579);
    freq.put("月：", 10);
    freq.put("　丁あ", 20);
    freq.put("ｼ ", 12);
    freq.put("月２", 16);
    freq.put("日三人", 18);
    freq.put("並国", 63);
    freq.put("丈アア", 44);
    freq.put("一丘乙", 8);
    freq.put("三中あ", 24);
    freq.put("丼丘 ", 11);
    freq.put("ア】三", 9);
    freq.put("³", 33);
    freq.put("倉並丁", 10);
    freq.put("並「あ", 15);
    freq.put("倉並三", 11);
    freq.put(" ́ ", 43);
    freq.put("一丘三", 8);
    freq.put("一丘丁", 12);
    freq.put("⇒⇒ ", 8);
    freq.put("「万", 34);
    freq.put("之中あ", 28);
    freq.put("丁あ侶", 22);
    freq.put("あ『ア", 18);
    freq.put("￣￣￣", 151);
    freq.put("倉並之", 11);
    freq.put("（あ。", 37);
    freq.put("日三両", 15);
    freq.put("日三並", 44);
    freq.put("あ『あ", 11);
    freq.put("￣￣＼", 8);
    freq.put("。並之", 12);
    freq.put("日三丘", 8);
    freq.put("日三三", 29);
    freq.put(" ６", 22);
    freq.put("ϵ ", 11);
    freq.put(" 大佐", 47);
    freq.put("∠", 67);
    freq.put("６月", 22);
    freq.put("月弁あ", 11);
    freq.put("ｍ", 10);
    freq.put("（ああ", 37);
    freq.put("【両ア", 9);
    freq.put("並「ア", 9);
    freq.put("￢", 9);
    freq.put("。並三", 15);
    freq.put("日三之", 20);
    freq.put("。並丘", 8);
    freq.put(" ⊂ ", 23);
    freq.put(" アω", 60);
    freq.put("，", 14);
    freq.put("万あ", 1942);
    freq.put("並丘 ", 29);
    freq.put(" 丁あ", 751);
    freq.put(" 大人", 19);
    freq.put("あ三乱", 13);
    freq.put("丁あ亀", 35);
    freq.put("万】", 48);
    freq.put("万【", 8);
    freq.put("万、", 20);
    freq.put("万　", 19);
    freq.put("万」", 17);
    freq.put("万「", 10);
    freq.put("月万あ", 10);
    freq.put(" ۶ ", 22);
    freq.put("大之あ", 17);
    freq.put(" 丁々", 22);
    freq.put("○○", 23);
    freq.put(" 丁「", 50);
    freq.put("【乙三", 9);
    freq.put("丁あ人", 34);
    freq.put("弁あ", 35);
    freq.put("伎 ", 26);
    freq.put("あ倉あ", 1001);
    freq.put("丁あ之", 208);
    freq.put(" 大丘", 10);
    freq.put(" 大万", 25);
    freq.put("ああ兌", 15);
    freq.put(" 大丁", 71);
    freq.put("丁あ乙", 59);
    freq.put(" 大丈", 33);
    freq.put(" 大三", 23);
    freq.put("あア倉", 9);
    freq.put("б", 12);
    freq.put("丁あ乱", 32);
    freq.put(" 大両", 9);
    freq.put("丁之 ", 85);
    freq.put("丁あ一", 10);
    freq.put("丁あ丁", 180);
    freq.put(" 丁ア", 38);
    freq.put("丁あ万", 41);
    freq.put("丁あ丈", 12);
    freq.put("丁あ三", 338);
    freq.put("ˊ", 10);
    freq.put("丁あ丑", 8);
    freq.put("ﾝあ", 34);
    freq.put("丁あ丘", 91);
    freq.put("丁あ丙", 9);
    freq.put("乙』→", 8);
    freq.put("͟", 16);
    freq.put("丁あ両", 107);
    freq.put("丁あ並", 166);
    freq.put("■アア", 8);
    freq.put("丁あ中", 18);
    freq.put("ア丈並", 11);
    freq.put("万ア", 114);
    freq.put("ｷ", 341);
    freq.put("之丈あ", 13);
    freq.put("ㅋ ", 8);
    freq.put("両並之", 27);
    freq.put("あ一あ", 29);
    freq.put("あ丁亀", 38);
    freq.put(" ∵ ", 14);
    freq.put("◕ ", 10);
    freq.put(" 　＼", 15);
    freq.put("倉あ ", 71);
    freq.put("あ丁人", 26);
    freq.put("／あ", 21);
    freq.put(" （三", 8);
    freq.put("Ｖ", 10);
    freq.put("◞ ", 16);
    freq.put(" 　＜", 17);
    freq.put("ア大", 66);
    freq.put("両並三", 68);
    freq.put(" 　･", 16);
    freq.put("之あア", 229);
    freq.put("両並万", 8);
    freq.put("両並丁", 46);
    freq.put("ア】あ", 36);
    freq.put(" ╭", 8);
    freq.put("･･あ", 9);
    freq.put("並之倉", 9);
    freq.put(" （乙", 38);
    freq.put("┐", 60);
    freq.put("┐ｹｲ", 8);
    freq.put("両並両", 36);
    freq.put("／　", 43);
    freq.put(" ア´", 14);
    freq.put(" ٩ ", 17);
    freq.put("〜あ", 144);
    freq.put("三ア", 617);
    freq.put("「日三", 8);
    freq.put("／アア", 23);
    freq.put("あ丁丘", 81);
    freq.put("あ丁万", 71);
    freq.put("ｗｗ ", 125);
    freq.put("あ丁丁", 233);
    freq.put("三あ", 9150);
    freq.put("あ丁丈", 29);
    freq.put("あ丁三", 386);
    freq.put(" 」 ", 177);
    freq.put("丘万三", 8);
    freq.put("之ああ", 4229);
    freq.put("あ丁丹", 10);
    freq.put("あ丁並", 381);
    freq.put(" 　ﾗ", 187);
    freq.put("あ丁両", 92);
    freq.put(" （亀", 9);
    freq.put(" 　ﾟ", 15);
    freq.put("ｸああ", 11);
    freq.put("両！ ", 28);
    freq.put("三】", 231);
    freq.put("／ア", 36);
    freq.put("　／ ", 15);
    freq.put("あ丁乙", 63);
    freq.put("三」", 43);
    freq.put("三「", 93);
    freq.put("三』", 15);
    freq.put("三『", 8);
    freq.put("三、", 168);
    freq.put("三　", 105);
    freq.put("三。", 92);
    freq.put("三々", 24);
    freq.put("あ丁之", 223);
    freq.put("彡", 55);
    freq.put(" ア ", 422);
    freq.put("あ丁乱", 13);
    freq.put("之あ。", 30);
    freq.put("之あ、", 54);
    freq.put("亥あ", 22);
    freq.put("「丑", 14);
    freq.put("人人＿", 66);
    freq.put("　＃", 9);
    freq.put("　（", 18);
    freq.put("三！！", 24);
    freq.put("　／", 40);
    freq.put("アア～", 32);
    freq.put("ｫﾛ", 35);
    freq.put("　＞", 8);
    freq.put("　＜", 29);
    freq.put("丹之あ", 13);
    freq.put("並】あ", 12);
    freq.put("アア･", 20);
    freq.put("三万人", 10);
    freq.put("｜ ", 43);
    freq.put("︶", 34);
    freq.put("　＿", 16);
    freq.put("　＼", 42);
    freq.put("アア／", 8);
    freq.put("ω；｀", 29);
    freq.put("アア）", 84);
    freq.put("アア（", 87);
    freq.put("͈", 63);
    freq.put("アア！", 487);
    freq.put("アア？", 51);
    freq.put("アア＞", 10);
    freq.put("アア＝", 11);
    freq.put("アア＜", 15);
    freq.put("アア：", 58);
    freq.put(" 三 ", 360);
    freq.put("　～", 9);
    freq.put("万並 ", 34);
    freq.put("　｜", 16);
    freq.put("乙倉 ", 14);
    freq.put("丘あ」", 9);
    freq.put("　｡", 11);
    freq.put("＞ω＜", 8);
    freq.put("　･", 17);
    freq.put("アア＼", 11);
    freq.put("大倉あ", 8);
    freq.put(" ▿ ", 10);
    freq.put("　ｽ", 8);
    freq.put("丁", 16286);
    freq.put("┗━", 12);
    freq.put("┗┏", 43);
    freq.put("　ﾉ", 8);
    freq.put("三万丘", 9);
    freq.put("⌒＠", 24);
    freq.put("　ﾗ", 191);
    freq.put("！三之", 16);
    freq.put("あ侶之", 16);
    freq.put("丙アア", 8);
    freq.put("　ﾟ", 19);
    freq.put("三万三", 56);
    freq.put("๑꒱ ", 8);
    freq.put("あ､あ", 10);
    freq.put("両丁之", 16);
    freq.put("三万並", 50);
    freq.put("三万両", 8);
    freq.put("⌒／", 8);
    freq.put("両丁並", 21);
    freq.put("両丁両", 9);
    freq.put("並】ア", 16);
    freq.put("あ侶丘", 13);
    freq.put("之人あ", 29);
    freq.put("！三三", 22);
    freq.put("之並！", 10);
    freq.put("¨ ", 16);
    freq.put("！三丁", 8);
    freq.put("◜", 57);
    freq.put("━ ", 34);
    freq.put("両丁丁", 17);
    freq.put("両あ両", 59);
    freq.put("ｫｫ", 9);
    freq.put("｀･", 17);
    freq.put("ｫｯ", 9);
    freq.put("ｫｰ", 10);
    freq.put(" − ", 23);
    freq.put("？！ ", 17);
    freq.put(" ω＼", 13);
    freq.put("亀万あ", 61);
    freq.put("並之両", 35);
    freq.put("一三あ", 57);
    freq.put("丼丁あ", 8);
    freq.put("並之之", 47);
    freq.put(" ／ ", 180);
    freq.put(" ¸¸", 10);
    freq.put("？之あ", 12);
    freq.put("∀ア ", 53);
    freq.put(" ˙ ", 12);
    freq.put("あ丈 ", 8);
    freq.put("ㅜㅜ", 13);
    freq.put("並之並", 58);
    freq.put("ア侶並", 17);
    freq.put("ア： ", 11);
    freq.put("三々あ", 13);
    freq.put(" ω･", 11);
    freq.put("◔ ", 60);
    freq.put("並之三", 108);
    freq.put("並之丁", 28);
    freq.put("並之万", 16);
    freq.put("≧∇", 57);
    freq.put("年", 463);
    freq.put("≧∀", 15);
    freq.put("両之あ", 217);
    freq.put("´◔ ", 12);
    freq.put("ア三丘", 15);
    freq.put("ﾊ", 125);
    freq.put("← ", 173);
    freq.put(" ◇ ", 10);
    freq.put("ア『ア", 10);
    freq.put("あ丁倉", 116);
    freq.put("இɷ", 10);
    freq.put("「丁」", 34);
    freq.put("丈、", 12);
    freq.put(" ┓", 74);
    freq.put("丁大万", 8);
    freq.put("丿", 8);
    freq.put(" ┗", 32);
    freq.put("´´ิ", 17);
    freq.put(" ˙³", 12);
    freq.put("「乞」", 10);
    freq.put("丁 ", 918);
    freq.put("ｱｲﾃ", 193);
    freq.put("丁丁 ", 126);
    freq.put("「丁あ", 25);
    freq.put("∞ ", 8);
    freq.put("ア⌒＠", 24);
    freq.put("仕三 ", 11);
    freq.put("あ｀", 10);
    freq.put("∇￣ ", 19);
    freq.put("之両「", 13);
    freq.put("之両】", 10);
    freq.put("あｗ", 229);
    freq.put(" 年並", 19);
    freq.put("あ～", 610);
    freq.put("あ､", 32);
    freq.put("あ･", 29);
    freq.put("あ｡", 68);
    freq.put("あ｢", 12);
    freq.put("あ｣", 21);
    freq.put("あｯ", 11);
    freq.put(" 大あ", 21);
    freq.put("あｷ", 30);
    freq.put("あｰ", 10);
    freq.put(" 年三", 25);
    freq.put("丘「 ", 8);
    freq.put("並丁ア", 42);
    freq.put("あｺ", 11);
    freq.put("之両あ", 292);
    freq.put("あ＆", 15);
    freq.put("中！", 32);
    freq.put("あ！", 4059);
    freq.put(" 乙倉", 12);
    freq.put("あ／", 13);
    freq.put("あ（", 390);
    freq.put("あ）", 73);
    freq.put("あ＊", 9);
    freq.put("あ４", 17);
    freq.put("２日", 10);
    freq.put("º·˚", 12);
    freq.put("あ７", 13);
    freq.put("あ１", 71);
    freq.put("あ２", 40);
    freq.put("あ３", 38);
    freq.put("あ＜", 16);
    freq.put("あ＞", 21);
    freq.put("あ？", 1502);
    freq.put("´あ", 14);
    freq.put("あ９", 9);
    freq.put("あ：", 18);
    freq.put("坂 ", 8);
    freq.put("あＲ", 10);
    freq.put("あ＼", 148);
    freq.put("あ＾", 25);
    freq.put("あ＿", 20);
    freq.put("。乙 ", 65);
    freq.put("並丁】", 32);
    freq.put("丕", 12);
    freq.put("あ中あ", 136);
    freq.put("？", 2301);
    freq.put("之両ア", 12);
    freq.put("。。 ", 67);
    freq.put("一並あ", 18);
    freq.put("両万並", 9);
    freq.put("´ア", 133);
    freq.put(" 年亀", 14);
    freq.put("▽｀ ", 91);
    freq.put("あﾌ", 15);
    freq.put("あ。∂", 39);
    freq.put("並丁あ", 229);
    freq.put("▒▓█", 12);
    freq.put("あﾞ", 9);
    freq.put("あﾟ", 66);
    freq.put("あ一丁", 12);
    freq.put("々 ", 13);
    freq.put("･｀ ", 41);
    freq.put("人三之", 10);
    freq.put("並　ア", 8);
    freq.put(" 凄あ", 14);
    freq.put("ｰあ", 33);
    freq.put("大ア", 19);
    freq.put("三丁三", 83);
    freq.put("あ中 ", 12);
    freq.put("。三之", 33);
    freq.put("ლ ", 18);
    freq.put("·", 48);
    freq.put(" 人両", 21);
    freq.put("丈丘あ", 25);
    freq.put("両三之", 50);
    freq.put("。三並", 8);
    freq.put("〜？", 15);
    freq.put("。三両", 10);
    freq.put("〜！", 34);
    freq.put("〜（", 41);
    freq.put("あ。←", 18);
    freq.put("┓┛", 42);
    freq.put("。三三", 27);
    freq.put("┓┓", 61);
    freq.put("。三万", 16);
    freq.put("アあ丈", 23);
    freq.put(" 《", 24);
    freq.put("日之：", 54);
    freq.put("┓┃", 14);
    freq.put("三丁丘", 31);
    freq.put(" 亀並", 23);
    freq.put(" ■", 43);
    freq.put("！！之", 16);
    freq.put("万之之", 19);
    freq.put(" 「", 731);
    freq.put(" 」", 348);
    freq.put(" ε ", 26);
    freq.put(" 亀丁", 23);
    freq.put(" 亀三", 26);
    freq.put(" 亀丘", 109);
    freq.put("万之丘", 29);
    freq.put("！アア", 266);
    freq.put("！！丁", 12);
    freq.put("ｉ", 37);
    freq.put("！！三", 15);
    freq.put("万之三", 33);
    freq.put("ｰﾝ", 38);
    freq.put("国アア", 25);
    freq.put("＿ ", 214);
    freq.put("！！両", 12);
    freq.put(" 亀之", 23);
    freq.put("アあ丑", 29);
    freq.put("இ ", 13);
    freq.put(" ˡ̼", 9);
    freq.put("万之並", 19);
    freq.put("ああ』", 56);
    freq.put("ああ『", 27);
    freq.put("ああ」", 470);
    freq.put("。", 6161);
    freq.put("（", 1235);
    freq.put("ああ。", 4191);
    freq.put("ああ、", 3201);
    freq.put("ああ　", 277);
    freq.put("劈あ", 20);
    freq.put("万並三", 29);
    freq.put("丼ア", 11);
    freq.put("万並丁", 10);
    freq.put("仕 ", 14);
    freq.put("ああ】", 93);
    freq.put("ああ【", 40);
    freq.put("丁三！", 18);
    freq.put("傭", 86);
    freq.put(" 』 ", 32);
    freq.put("万並両", 8);
    freq.put("万並並", 28);
    freq.put("あああ", 131231);
    freq.put("万並之", 20);
    freq.put("ˡ", 9);
    freq.put("ω〃 ", 10);
    freq.put("三並）", 10);
    freq.put(" 乙！", 12);
    freq.put("丘。 ", 18);
    freq.put("あア並", 13);
    freq.put("あア両", 10);
    freq.put("両日あ", 29);
    freq.put("あア三", 34);
    freq.put("º· ", 12);
    freq.put("ああア", 6516);
    freq.put("あア丁", 24);
    freq.put("≧∇≦", 57);
    freq.put("あ！ ", 1537);
    freq.put("あア丘", 14);
    freq.put("〜ア", 27);
    freq.put("丼」", 8);
    freq.put("ε｀ ", 35);
    freq.put(" ╮╯", 15);
    freq.put("丁あ倉", 48);
    freq.put("⁾ ", 8);
    freq.put("三亀三", 12);
    freq.put("三╰ ", 9);
    freq.put("あア之", 20);
    freq.put("乩", 21);
    freq.put("ｳ", 68);
    freq.put("丼あ", 294);
    freq.put("（＾∇", 8);
    freq.put("並乱あ", 11);
    freq.put("ﾝ", 286);
    freq.put("ア「ア", 19);
    freq.put("ああ", 190369);
    freq.put("Ｒ", 29);
    freq.put("坂", 49);
    freq.put("！』 ", 13);
    freq.put("並人", 62);
    freq.put(" о ", 14);
    freq.put(" 가", 68);
    freq.put("あ月弁", 13);
    freq.put("丘 ", 414);
    freq.put("並亀", 97);
    freq.put("並乱", 32);
    freq.put("丹日あ", 71);
    freq.put("あ丑あ", 274);
    freq.put("？丘", 14);
    freq.put("？三", 23);
    freq.put("！【ア", 9);
    freq.put("亀三あ", 47);
    freq.put("？丁", 22);
    freq.put("的並", 8);
    freq.put("並乙", 172);
    freq.put(" ；ﾟ", 12);
    freq.put("？並", 14);
    freq.put("並！ ", 29);
    freq.put("並之", 1027);
    freq.put("༽", 8);
    freq.put("？乙", 67);
    freq.put("並丹", 35);
    freq.put("並丼", 46);
    freq.put("並両", 574);
    freq.put("？之", 22);
    freq.put("並並", 1619);
    freq.put("並中", 43);
    freq.put("並丑", 21);
    freq.put("並且", 16);
    freq.put("並丘", 355);
    freq.put("丘之 ", 38);
    freq.put("％ ", 10);
    freq.put("並一", 17);
    freq.put("並丁", 741);
    freq.put("並万", 266);
    freq.put("並丈", 68);
    freq.put("並三", 1482);
    freq.put("』→", 192);
    freq.put("ア「あ", 69);
    freq.put("之日之", 8);
    freq.put("あ１０", 12);
    freq.put(" 中三", 11);
    freq.put("дア ", 13);
    freq.put("┓≡", 11);
    freq.put("丼ああ", 210);
    freq.put("ﾉｼ", 12);
    freq.put("並あ大", 18);
    freq.put("、三日", 33);
    freq.put(" 倉あ", 161);
    freq.put("＠ ", 39);
    freq.put("並侶", 54);
    freq.put("之日丁", 14);
    freq.put("┏", 108);
    freq.put("並並並", 62);
    freq.put("｜", 106);
    freq.put("並並両", 38);
    freq.put("丁丈あ", 49);
    freq.put("　あ ", 13);
    freq.put("並並丘", 17);
    freq.put("之日並", 20);
    freq.put("並三 ", 106);
    freq.put("丁万 ", 28);
    freq.put("並並三", 92);
    freq.put("並並万", 22);
    freq.put("並並丁", 29);
    freq.put("侶 ", 51);
    freq.put("³˙", 13);
    freq.put("³˘", 8);
    freq.put("ア並之", 29);
    freq.put("仕万 ", 15);
    freq.put("ꞌ", 50);
    freq.put("三之 ", 183);
    freq.put("あ　", 396);
    freq.put("丘並並", 12);
    freq.put("∥", 8);
    freq.put("アア日", 13);
    freq.put("あ「", 337);
    freq.put("　仕三", 190);
    freq.put("д｀ ", 10);
    freq.put("ア　三", 11);
    freq.put(" º·", 23);
    freq.put("！あ！", 12);
    freq.put("ア並丁", 26);
    freq.put("ア並万", 27);
    freq.put("ﾉﾟ", 9);
    freq.put("ﾉﾞ", 17);
    freq.put("ア並三", 33);
    freq.put("一万丁", 10);
    freq.put("あ》", 8);
    freq.put("◠", 235);
    freq.put("ア並両", 18);
    freq.put("ア並並", 25);
    freq.put("三三！", 24);
    freq.put("ア　之", 9);
    freq.put("並伎", 8);
    freq.put("並並亀", 15);
    freq.put("並万】", 13);
    freq.put("】ああ", 99);
    freq.put("両ああ", 2554);
    freq.put("。　 ", 24);
    freq.put("亀並あ", 31);
    freq.put("◍", 35);
    freq.put("あ乙あ", 892);
    freq.put("並万あ", 102);
    freq.put("両あ、", 41);
    freq.put("両あ。", 16);
    freq.put("アあ倉", 121);
    freq.put("、「あ", 8);
    freq.put("中三丁", 9);
    freq.put("ｻｲ", 9);
    freq.put(" ＾＾", 8);
    freq.put("～あ ", 30);
    freq.put("侶あ", 798);
    freq.put("あ乙ア", 13);
    freq.put("亀丘倉", 11);
    freq.put("丁人", 73);
    freq.put("あ万日", 8);
    freq.put("並侶並", 9);
    freq.put("『ああ", 62);
    freq.put("＝アア", 13);
    freq.put("丁両並", 37);
    freq.put("丁両両", 8);
    freq.put("д･ ", 13);
    freq.put(" 丹あ", 61);
    freq.put("乙並】", 8);
    freq.put("丁両丁", 21);
    freq.put("丁両三", 19);
    freq.put("あ』→", 16);
    freq.put(" 丁亀", 26);
    freq.put("乙並あ", 73);
    freq.put("」ア", 33);
    freq.put("］ ", 12);
    freq.put("之倉並", 17);
    freq.put(" இ", 13);
    freq.put(" ｡ ", 430);
    freq.put(" ━━", 11);
    freq.put("③", 27);
    freq.put("、両あ", 60);
    freq.put("】三万", 8);
    freq.put("℃ ", 9);
    freq.put("乙乙乙", 12);
    freq.put("丁両之", 10);
    freq.put("之倉三", 12);
    freq.put("ﾊｧ", 15);
    freq.put("ﾊﾞ", 56);
    freq.put("ﾊﾟ", 23);
    freq.put("侃あ", 34);
    freq.put("大乙之", 8);
    freq.put("丑", 721);
    freq.put("ฅωฅ", 9);
    freq.put("；", 407);
    freq.put("丈並ア", 9);
    freq.put("乙並ア", 9);
    freq.put("」あ", 419);
    freq.put("丁丁乙", 10);
    freq.put(" 】 ", 83);
    freq.put("ﾌｫﾛ", 34);
    freq.put("！？ ", 40);
    freq.put("ξ　", 8);
    freq.put("ア丘あ", 142);
    freq.put("之ア丁", 9);
    freq.put("凄", 48);
    freq.put("≧▽", 57);
    freq.put("人＿ ", 67);
    freq.put("」　", 37);
    freq.put("」「", 46);
    freq.put(" 坂丘", 12);
    freq.put("◟ ", 17);
    freq.put("○ア", 8);
    freq.put("ｯﾌ", 12);
    freq.put("ｯﾋ", 10);
    freq.put("乱丘", 21);
    freq.put("ｯﾄ", 12);
    freq.put("乱丁", 61);
    freq.put(" ⁰", 9);
    freq.put("⌒", 290);
    freq.put("→ ", 101);
    freq.put("乱三", 56);
    freq.put("가가 ", 68);
    freq.put("乱両", 83);
    freq.put("乱並", 269);
    freq.put("乱乙", 12);
    freq.put("ﾑ ", 196);
    freq.put("乱之", 60);
    freq.put("乱乱", 8);
    freq.put("ア伎", 13);
    freq.put("年三あ", 36);
    freq.put("ຶ ", 16);
    freq.put("ａ", 10);
    freq.put("？丘あ", 9);
    freq.put("Г", 8);
    freq.put("爬ああ", 23);
    freq.put("大万三", 33);
    freq.put("【三之", 31);
    freq.put("乱人", 21);
    freq.put("万丁之", 42);
    freq.put(" ⃛", 14);
    freq.put(" ⃘", 8);
    freq.put("「伎あ", 16);
    freq.put("あ的", 17);
    freq.put("ｅ", 11);
    freq.put("！」 ", 160);
    freq.put("ア侮", 10);
    freq.put("【三並", 29);
    freq.put("ア侶", 45);
    freq.put("万丁並", 14);
    freq.put("且日", 10);
    freq.put("Ｔあ", 16);
    freq.put("万丁両", 11);
    freq.put("ｯｯ", 12);
    freq.put("○あ", 16);
    freq.put("。之あ", 37);
    freq.put("【三丁", 22);
    freq.put("ω´ ", 39);
    freq.put("【三万", 8);
    freq.put("ˡ̼̮", 9);
    freq.put("ｯｼ", 44);
    freq.put("万丁三", 19);
    freq.put("ｯｸ", 29);
    freq.put("ｯｷ", 198);
    freq.put("万丁丁", 14);
    freq.put("之　ア", 8);
    freq.put("三丘倉", 14);
    freq.put("三、三", 17);
    freq.put(" ˖ ", 12);
    freq.put("あ～あ", 115);
    freq.put(" ั ", 8);
    freq.put("−", 38);
    freq.put("ア乱", 49);
    freq.put("侮ああ", 84);
    freq.put("並両 ", 53);
    freq.put("θ｀ ", 15);
    freq.put("両、", 49);
    freq.put("両　", 19);
    freq.put("両。", 30);
    freq.put("両々", 14);
    freq.put("ア。三", 11);
    freq.put("三、並", 10);
    freq.put("両」", 31);
    freq.put("両「", 21);
    freq.put("両』", 8);
    freq.put("ア之", 409);
    freq.put("両】", 59);
    freq.put("ア乞", 9);
    freq.put("ア乙", 162);
    freq.put("ア並", 410);
    freq.put("ア両", 292);
    freq.put("あ～」", 10);
    freq.put("あ～。", 14);
    freq.put("あ～、", 9);
    freq.put("あｗ ", 30);
    freq.put("万三あ", 216);
    freq.put("ア丼", 16);
    freq.put("ア丹", 12);
    freq.put("ア乙 ", 22);
    freq.put(" ℃", 29);
    freq.put("両あ", 3795);
    freq.put("ア一", 39);
    freq.put("ア丁", 560);
    freq.put("┘ ", 12);
    freq.put("丁並", 1403);
    freq.put("ア丈", 86);
    freq.put("ア三", 738);
    freq.put("三　 ", 8);
    freq.put("ア丑", 20);
    freq.put("ア。乙", 9);
    freq.put("ア丘", 296);
    freq.put("ア丙", 12);
    freq.put("彡ﾟ", 9);
    freq.put("両ア", 222);
    freq.put("アｗｗ", 28);
    freq.put(" ←あ", 16);
    freq.put("℃、乱", 13);
    freq.put(" ⇒", 41);
    freq.put("万三ア", 9);
    freq.put("丙丘あ", 9);
    freq.put("丁々あ", 36);
    freq.put("｀● ", 17);
    freq.put("乙丁三", 10);
    freq.put("あ人 ", 38);
    freq.put("｡･ω", 10);
    freq.put("乙あ！", 11);
    freq.put("乙丁丁", 10);
    freq.put("ﾍﾟ", 16);
    freq.put("ア人", 15);
    freq.put(" ○ ", 33);
    freq.put("ア亀", 78);
    freq.put("亀乙 ", 8);
    freq.put("あ～ア", 11);
    freq.put("ｯ", 453);
    freq.put("丁丼", 12);
    freq.put(" →", 85);
    freq.put(" ↓", 30);
    freq.put(" ←", 134);
    freq.put("＞ ", 99);
    freq.put(" ≡", 68);
    freq.put(" ≧", 92);
    freq.put("三丁丁", 84);
    freq.put(" ≪", 12);
    freq.put("＞ω", 8);
    freq.put("ﾙ", 83);
    freq.put("̮ ", 22);
    freq.put(" ＼＼", 10);
    freq.put("▓▓▓", 70);
    freq.put("Ｎ", 11);
    freq.put(" ∠", 18);
    freq.put("੭ु", 31);
    freq.put(" ∧", 81);
    freq.put(" ∩", 74);
    freq.put("░ ", 11);
    freq.put("◕", 25);
    freq.put("あ└ ", 8);
    freq.put(" ∴", 8);
    freq.put(" ∵", 16);
    freq.put(" ∀", 57);
    freq.put("丼アア", 11);
    freq.put(" ∇", 57);
    freq.put(" −", 27);
    freq.put("ﾋﾟ", 19);
    freq.put("ﾋﾞ", 13);
    freq.put("あ〜！", 29);
    freq.put("ﾋｮ", 9);
    freq.put("ﾋｬ", 9);
    freq.put("あ〜？", 15);
    freq.put("▽ﾟ ", 139);
    freq.put("大アア", 18);
    freq.put("％ああ", 8);
    freq.put("Ｏ（", 11);
    freq.put("「丘丁", 11);
    freq.put("ﾗｲ", 10);
    freq.put("日丁丁", 8);
    freq.put("▂▅▇", 12);
    freq.put("之国あ", 9);
    freq.put("あ丹日", 14);
    freq.put(" ⊂", 34);
    freq.put(" ⊃", 64);
    freq.put("丁あ大", 18);
    freq.put(" ℃、", 14);
    freq.put("日丁並", 12);
    freq.put("仕三三", 10);
    freq.put(" ⊙", 19);
    freq.put("「丘之", 8);
    freq.put(" 【乙", 31);
    freq.put("●ア", 8);
    freq.put("１ああ", 13);
    freq.put(" 【之", 73);
    freq.put("∩ ", 68);
    freq.put("Д ", 102);
    freq.put("ﾟ∀", 63);
    freq.put("亀ア", 40);
    freq.put(" 【乱", 8);
    freq.put("万あ ", 71);
    freq.put("丙 ", 28);
    freq.put("丼」 ", 8);
    freq.put(" 【丘", 15);
    freq.put("倖丘あ", 10);
    freq.put(" 【丁", 71);
    freq.put(" 【万", 15);
    freq.put("ŧ ", 16);
    freq.put(" 【三", 272);
    freq.put("ˇω", 9);
    freq.put("丁大", 45);
    freq.put("≦", 143);
    freq.put("【丁あ", 12);
    freq.put(" ⌒", 128);
    freq.put(" 【両", 42);
    freq.put(" 【並", 71);
    freq.put("´ε｀", 35);
    freq.put(" あﾞ", 9);
    freq.put(" 【中", 8);
    freq.put("亀、", 9);
    freq.put("Д´", 8);
    freq.put("三年あ", 9);
    freq.put("∩´", 14);
    freq.put("亀「", 9);
    freq.put("亀」", 16);
    freq.put("丑アア", 10);
    freq.put("並倉両", 10);
    freq.put("並倉並", 8);
    freq.put(" あ｀", 8);
    freq.put("三╰", 9);
    freq.put("Ｗｗ", 10);
    freq.put("並倉丁", 8);
    freq.put(" あ～", 24);
    freq.put("乙倉", 50);
    freq.put(" 【亀", 66);
    freq.put("三┏", 9);
    freq.put(" あ！", 29);
    freq.put("ŧ", 16);
    freq.put(" ｣ ", 13);
    freq.put("並倉之", 16);
    freq.put(" あ？", 54);
    freq.put(" あ＞", 8);
    freq.put(" ③", 20);
    freq.put(" ④", 10);
    freq.put(" ①", 22);
    freq.put(" ②", 29);
    freq.put(" ⑤", 8);
    freq.put("三あ三", 524);
    freq.put("◔౪", 8);
    freq.put("並あ倉", 55);
    freq.put("あ三亀", 40);
    freq.put("あ仕あ", 15);
    freq.put("ﾌﾟ", 24);
    freq.put("三並倉", 20);
    freq.put("あ乱 ", 9);
    freq.put("人あ亀", 8);
    freq.put(" 「倉", 14);
    freq.put("¸", 24);
    freq.put("三あ万", 76);
    freq.put("ｱｱ", 178);
    freq.put("ｱｲ", 196);
    freq.put(" ﾉﾞ", 17);
    freq.put("【万丁", 10);
    freq.put("あ爬", 11);
    freq.put("【之あ", 9);
    freq.put("三三的", 21);
    freq.put("◝ ", 54);
    freq.put("ｱｧ", 18);
    freq.put("あ三仕", 8);
    freq.put("万万三", 10);
    freq.put("ｱｯ", 13);
    freq.put("ﾂ", 13);
    freq.put(" ﾉｼ", 11);
    freq.put("あ三並", 459);
    freq.put("倣 ", 11);
    freq.put("人あ之", 48);
    freq.put(" ლ ", 16);
    freq.put("あ三両", 143);
    freq.put("人あ乙", 15);
    freq.put("あ【 ", 8);
    freq.put("ﾟ▽", 139);
    freq.put("あ三丈", 16);
    freq.put("あ三三", 929);
    freq.put("あ三万", 247);
    freq.put("あ三丁", 242);
    freq.put("あ、乞", 8);
    freq.put("あ三丘", 141);
    freq.put("あ三丙", 12);
    freq.put("｀） ", 9);
    freq.put("『アア", 171);
    freq.put("人あ万", 10);
    freq.put("人あ丁", 55);
    freq.put("人あ一", 14);
    freq.put(" ꒪", 16);
    freq.put("ﾌｫ", 49);
    freq.put("人あ三", 80);
    freq.put("倉倉", 50);
    freq.put(" ꒳", 10);
    freq.put(" ꒱", 30);
    freq.put("丁乱あ", 29);
    freq.put("人あ丘", 23);
    freq.put("人あ並", 41);
    freq.put("あ三之", 614);
    freq.put("人あ両", 28);
    freq.put("あ三乙", 57);
    freq.put("丑倉", 15);
    freq.put("日アア", 70);
    freq.put(" ╮", 30);
    freq.put(" ╯", 20);
    freq.put(" ╬", 14);
    freq.put("月アア", 11);
    freq.put(" ╰", 17);
    freq.put("ʕ", 23);
    freq.put("三日 ", 21);
    freq.put(" ╹", 78);
    freq.put("。∂", 39);
    freq.put("ア亀丘", 11);
    freq.put(" ＜あ", 17);
    freq.put("圓あ", 13);
    freq.put(" ｀ ", 119);
    freq.put(" ┳", 10);
    freq.put(" ┻", 9);
    freq.put("┌┛ ", 9);
    freq.put(" ┃", 30);
    freq.put(" ─", 14);
    freq.put(" ━", 17);
    freq.put("≪", 14);
    freq.put(" ┏", 16);
    freq.put(" ┌", 31);
    freq.put("人あ侶", 11);
    freq.put(" ┐", 30);
    freq.put("大三あ", 57);
    freq.put(" └", 21);
    freq.put("三丈あ", 24);
    freq.put(" ┛", 50);
    freq.put(" ┘", 52);
    freq.put("／⌒", 8);
    freq.put(" ◠", 234);
    freq.put(" ◡", 41);
    freq.put(" ◦", 8);
    freq.put("倉", 4236);
    freq.put("三あ之", 379);
    freq.put("７", 65);
    freq.put(" ◆", 26);
    freq.put(" ◇", 12);
    freq.put(" ○", 60);
    freq.put(" ◉", 11);
    freq.put(" ◎", 29);
    freq.put(" ●", 87);
    freq.put(" ◍", 32);
    freq.put(" ◔", 16);
    freq.put(" ◕", 13);
    freq.put(" ◞", 17);
    freq.put(" ◟", 18);
    freq.put(" ◜", 54);
    freq.put(" ◝", 10);
    freq.put("、アア", 555);
    freq.put(" □", 12);
    freq.put("丁三：", 8);
    freq.put("⊃━", 18);
    freq.put("弁日 ", 15);
    freq.put("┻ ", 8);
    freq.put(" ＜ア", 8);
    freq.put("ア、 ", 35);
    freq.put("佐ああ", 10);
    freq.put("両三並", 51);
    freq.put("両三両", 14);
    freq.put(" ▿", 18);
    freq.put(" ▼", 20);
    freq.put(" ▽", 349);
    freq.put(" ▂", 12);
    freq.put("！ ", 2823);
    freq.put("丈丁？", 12);
    freq.put("両三丘", 14);
    freq.put(" 伎 ", 8);
    freq.put("φ ", 8);
    freq.put(" ░", 11);
    freq.put("両三三", 81);
    freq.put("ㅋㅋㅋ", 11);
    freq.put("∪", 25);
    freq.put("両三万", 22);
    freq.put("両三丁", 19);
    freq.put(" 中並", 14);
    freq.put("ア倉三", 18);
    freq.put("ﾟ･｡", 9);
    freq.put("ア倉丁", 19);
    freq.put(" 中万", 18);
    freq.put("乙】 ", 18);
    freq.put("伎「あ", 10);
    freq.put("亀之あ", 31);
    freq.put("∠ ", 63);
    freq.put(" →　", 10);
    freq.put(" ◍ ", 30);
    freq.put("　ア　", 14);
    freq.put("˙ ", 49);
    freq.put(" 中之", 9);
    freq.put("＜ ", 117);
    freq.put(" 乞あ", 48);
    freq.put("弁", 160);
    freq.put(" 『之", 20);
    freq.put("【アア", 273);
    freq.put("ω╹", 11);
    freq.put("之之並", 87);
    freq.put("之之両", 31);
    freq.put("？万", 11);
    freq.put("之之丘", 13);
    freq.put(" ｀ω", 34);
    freq.put("々丁あ", 9);
    freq.put("あ倖あ", 52);
    freq.put("之之三", 124);
    freq.put("倉倉あ", 24);
    freq.put("之之万", 16);
    freq.put("之之丁", 31);
    freq.put(" 『三", 23);
    freq.put("ɷஇ", 10);
    freq.put(" 一日", 14);
    freq.put("　アア", 186);
    freq.put(" 『丁", 26);
    freq.put("之、", 120);
    freq.put(" 『万", 8);
    freq.put(" 『丘", 12);
    freq.put("ｰｱｲ", 193);
    freq.put("あ丁年", 11);
    freq.put(" ∠ ", 15);
    freq.put("倉。 ", 13);
    freq.put(" 『並", 11);
    freq.put("之之之", 68);
    freq.put("˙³", 13);
    freq.put("ﾍﾞ", 9);
    freq.put("《", 40);
    freq.put(" ･｀", 14);
    freq.put("･∴", 10);
    freq.put("ω〃", 10);
    freq.put("三両あ", 231);
    freq.put(" ･･", 10);
    freq.put("ﾃﾑ ", 193);
    freq.put(" ･｡", 16);
    freq.put("┌（", 11);
    freq.put("アあ大", 22);
    freq.put("ωあ", 13);
    freq.put("あ、日", 10);
    freq.put("万両 ", 22);
    freq.put("々並", 9);
    freq.put("あ丁弁", 12);
    freq.put("「並並", 8);
    freq.put("人倉", 13);
    freq.put("∩", 118);
    freq.put("ωア", 185);
    freq.put(" ू ", 21);
    freq.put("з ", 21);
    freq.put("月丁あ", 8);
    freq.put("丁並 ", 309);
    freq.put(" ･ﾟ", 16);
    freq.put("あ侮あ", 60);
    freq.put("あ日之", 12);
    freq.put("ｫ", 82);
    freq.put(" ꞌ", 25);
    freq.put("あ亀 ", 10);
    freq.put("ア！！", 182);
    freq.put("ああｷ", 11);
  }
  
}

