package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class MK {
  private static final String name = "mk";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public MK() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 380519;
    n_words[1] = 461908;
    n_words[2] = 370732;

    freq.put("Вик", 14);
    freq.put("Вин", 8);
    freq.put("Вие", 11);
    freq.put("Вид", 30);
    freq.put("пок", 78);
    freq.put("пол", 229);
    freq.put("пои", 23);
    freq.put("поо", 5);
    freq.put("поп", 64);
    freq.put("пом", 171);
    freq.put("пон", 71);
    freq.put("пов", 211);
    freq.put("пог", 84);
    freq.put("поа", 5);
    freq.put("поб", 85);
    freq.put("пож", 11);
    freq.put("поз", 124);
    freq.put("под", 291);
    freq.put("пое", 23);
    freq.put("пош", 58);
    freq.put("че ", 214);
    freq.put("пот", 212);
    freq.put("поу", 14);
    freq.put("пор", 269);
    freq.put("пос", 387);
    freq.put("поч", 144);
    freq.put("поф", 7);
    freq.put("пој", 43);
    freq.put("Дел", 20);
    freq.put("со ", 881);
    freq.put("ј", 6780);
    freq.put("Вис", 10);
    freq.put("Вит", 7);
    freq.put("Деб", 7);
    freq.put(" Ап", 13);
    freq.put("ќед", 7);
    freq.put("ле ", 464);
    freq.put("ќен", 28);
    freq.put("НЕ ", 26);
    freq.put("љи ", 9);
    freq.put("смр", 13);
    freq.put("смо", 17);
    freq.put("сми", 32);
    freq.put("сме", 276);
    freq.put("сма", 24);
    freq.put("ќер", 15);
    freq.put("ќет", 8);
    freq.put("ИИ ", 9);
    freq.put("вча", 15);
    freq.put("ези", 37);
    freq.put("вче", 44);
    freq.put("езн", 47);
    freq.put("вчи", 5);
    freq.put("езб", 12);
    freq.put("еза", 42);
    freq.put("езе", 60);
    freq.put("езд", 22);
    freq.put("љоп", 9);
    freq.put("ам ", 2071);
    freq.put("адб", 19);
    freq.put("лти", 7);
    freq.put("ФА ", 8);
    freq.put("уми", 73);
    freq.put("езу", 16);
    freq.put("Ве", 143);
    freq.put("Енц", 5);
    freq.put("Ва", 70);
    freq.put("Вн", 8);
    freq.put("Во", 119);
    freq.put("Ви", 122);
    freq.put("Вк", 8);
    freq.put("Вл", 39);
    freq.put("ИВ ", 5);
    freq.put("Ско", 106);
    freq.put("Ска", 6);
    freq.put("аос", 8);
    freq.put("аоч", 5);
    freq.put("аоѓ", 8);
    freq.put("Е ", 187);
    freq.put("Отк", 10);
    freq.put("Оти", 9);
    freq.put("Вр", 35);
    freq.put("Вт", 17);
    freq.put("Ву", 8);
    freq.put("Отв", 5);
    freq.put("С ", 49);
    freq.put("оо ", 44);
    freq.put("Ш ", 22);
    freq.put("За ", 74);
    freq.put("омб", 20);
    freq.put("ома", 171);
    freq.put("оме", 219);
    freq.put("тиќ", 5);
    freq.put("оми", 114);
    freq.put("омн", 33);
    freq.put("омп", 66);
    freq.put("омо", 108);
    freq.put("тиш", 42);
    freq.put("тис", 58);
    freq.put("тир", 111);
    freq.put("тит", 222);
    freq.put("тиф", 8);
    freq.put("тич", 100);
    freq.put("тиц", 23);
    freq.put("тии", 8);
    freq.put("тил", 53);
    freq.put("тик", 124);
    freq.put("тин", 163);
    freq.put("тим", 82);
    freq.put("тип", 52);
    freq.put("тио", 22);
    freq.put("тиб", 5);
    freq.put("тиг", 49);
    freq.put("тив", 255);
    freq.put("тие", 51);
    freq.put("тид", 23);
    freq.put("тиз", 22);
    freq.put("омс", 26);
    freq.put("омр", 10);
    freq.put("ому", 20);
    freq.put("омч", 12);
    freq.put("омц", 8);
    freq.put("омш", 19);
    freq.put("ЕТ ", 5);
    freq.put("јо ", 15);
    freq.put("де ", 504);
    freq.put("уз ", 6);
    freq.put("зењ", 10);
    freq.put("зет", 10);
    freq.put("зер", 42);
    freq.put("зеш", 5);
    freq.put("зев", 7);
    freq.put("зез", 10);
    freq.put("зед", 7);
    freq.put("зел", 27);
    freq.put("зен", 40);
    freq.put("зем", 105);
    freq.put("јал", 86);
    freq.put("јак", 69);
    freq.put("ии ", 188);
    freq.put("јап", 6);
    freq.put("јан", 110);
    freq.put("јам", 57);
    freq.put("јаг", 10);
    freq.put("јав", 171);
    freq.put("јаб", 5);
    freq.put("јаа", 6);
    freq.put("јаз", 12);
    freq.put("јад", 75);
    freq.put("Ноќ", 5);
    freq.put("Тол", 11);
    freq.put("Топ", 17);
    freq.put("Тог", 6);
    freq.put("Тоа", 41);
    freq.put("х", 1042);
    freq.put("Тор", 11);
    freq.put("Точ", 6);
    freq.put("Тој", 7);
    freq.put("Ибр", 5);
    freq.put("јат", 353);
    freq.put("јас", 212);
    freq.put("јар", 11);
    freq.put("јач", 19);
    freq.put("јај", 18);
    freq.put("дзе", 12);
    freq.put("дзи", 5);
    freq.put("Ви ", 22);
    freq.put("чет", 89);
    freq.put("чес", 88);
    freq.put("чер", 138);
    freq.put("по ", 276);
    freq.put("чеш", 16);
    freq.put("соф", 6);
    freq.put("соц", 15);
    freq.put("соч", 10);
    freq.put("сор", 28);
    freq.put("сос", 37);
    freq.put("сот", 60);
    freq.put("чењ", 23);
    freq.put("сош", 5);
    freq.put("сод", 7);
    freq.put("соз", 6);
    freq.put("соа", 8);
    freq.put("соб", 98);
    freq.put("сов", 109);
    freq.put("сог", 7);
    freq.put("сом", 14);
    freq.put("сон", 75);
    freq.put("соо", 23);
    freq.put("соп", 19);
    freq.put("сок", 47);
    freq.put("сол", 38);
    freq.put("чег", 5);
    freq.put("чев", 57);
    freq.put("чел", 11);
    freq.put("чек", 125);
    freq.put("чен", 99);
    freq.put("чем", 9);
    freq.put("дја", 6);
    freq.put("ќе ", 1059);
    freq.put("љив", 5);
    freq.put("ТЕ ", 30);
    freq.put("их ", 12);
    freq.put("вљу", 5);
    freq.put("уд ", 23);
    freq.put("ез ", 118);
    freq.put("аме", 413);
    freq.put("амб", 36);
    freq.put("ама", 399);
    freq.put("амп", 39);
    freq.put("амо", 378);
    freq.put("амн", 16);
    freq.put("амк", 13);
    freq.put("ами", 148);
    freq.put("ДМ ", 9);
    freq.put("аму", 71);
    freq.put("амт", 7);
    freq.put("амс", 23);
    freq.put("Епа", 12);
    freq.put("В ", 44);
    freq.put("Еј", 28);
    freq.put("ао ", 58);
    freq.put("Оба", 10);
    freq.put("Еф", 5);
    freq.put("Ес", 9);
    freq.put("Ер", 6);
    freq.put("Еу", 5);
    freq.put("Ет", 9);
    freq.put("Ен", 14);
    freq.put("Ем", 9);
    freq.put("Еп", 19);
    freq.put("Ел", 29);
    freq.put("Ек", 45);
    freq.put("Ее", 5);
    freq.put("Ед", 56);
    freq.put("Ев", 101);
    freq.put("ВН ", 5);
    freq.put("Заш", 17);
    freq.put("Зар", 11);
    freq.put("Зат", 17);
    freq.put("езо", 35);
    freq.put("ооп", 18);
    freq.put("ооо", 100);
    freq.put("тку", 7);
    freq.put("ткр", 31);
    freq.put("Шт", 97);
    freq.put("Шу", 12);
    freq.put("оод", 15);
    freq.put("ооб", 14);
    freq.put("Ши", 20);
    freq.put("Шо", 27);
    freq.put("Шп", 11);
    freq.put("тка", 158);
    freq.put("ооч", 5);
    freq.put("ЗаЕ", 20);
    freq.put("Ша", 24);
    freq.put("Ше", 15);
    freq.put("Зам", 6);
    freq.put("Зап", 17);
    freq.put("Зак", 9);
    freq.put("Зае", 10);
    freq.put("Заб", 8);
    freq.put("Зав", 9);
    freq.put("Заг", 9);
    freq.put("З", 425);
    freq.put("аљо", 11);
    freq.put("аља", 5);
    freq.put("аљд", 12);
    freq.put("ом ", 68);
    freq.put("ти ", 1105);
    freq.put("аљу", 5);
    freq.put("деи", 11);
    freq.put("СЕ ", 9);
    freq.put("дек", 482);
    freq.put("дел", 284);
    freq.put("дем", 59);
    freq.put("ден", 735);
    freq.put("део", 65);
    freq.put("деп", 13);
    freq.put("деа", 27);
    freq.put("деб", 31);
    freq.put("дев", 102);
    freq.put("дед", 14);
    freq.put("дее", 7);
    freq.put("деж", 13);
    freq.put("зап", 84);
    freq.put("јод", 8);
    freq.put("јон", 8);
    freq.put("ој ", 732);
    freq.put("мец", 5);
    freq.put("зал", 21);
    freq.put("Таа", 7);
    freq.put("Тад", 5);
    freq.put("цид", 9);
    freq.put("Так", 15);
    freq.put("Там", 5);
    freq.put("Тат", 7);
    freq.put("зе ", 38);
    freq.put("циг", 16);
    freq.put("Тај", 8);
    freq.put("цив", 19);
    freq.put("деј", 45);
    freq.put("јор", 5);
    freq.put("дењ", 20);
    freq.put("јот", 91);
    freq.put("деш", 69);
    freq.put("дер", 91);
    freq.put("дес", 57);
    freq.put("дет", 94);
    freq.put("деф", 20);
    freq.put("дец", 47);
    freq.put("деч", 56);
    freq.put("иив", 5);
    freq.put("иии", 35);
    freq.put("Чис", 6);
    freq.put("Чит", 6);
    freq.put("Чик", 11);
    freq.put("иит", 38);
    freq.put("Уби", 5);
    freq.put("Уба", 14);
    freq.put(" Њу", 9);
    freq.put("ког", 358);
    freq.put("ков", 218);
    freq.put("коб", 5);
    freq.put("коа", 54);
    freq.put("коз", 6);
    freq.put("кое", 56);
    freq.put("код", 9);
    freq.put("кол", 331);
    freq.put("Ј", 277);
    freq.put("кои", 129);
    freq.put("Иго", 7);
    freq.put("коо", 9);
    freq.put("кон", 239);
    freq.put("ком", 214);
    freq.put("ик ", 170);
    freq.put("јве", 16);
    freq.put("јва", 17);
    freq.put("от ", 1620);
    freq.put("коњ", 15);
    freq.put("кој", 590);
    freq.put("кот", 172);
    freq.put("Игр", 6);
    freq.put("лба", 37);
    freq.put("коч", 11);
    freq.put("коц", 7);
    freq.put("кох", 11);
    freq.put("коф", 7);
    freq.put("дбо", 6);
    freq.put("кош", 29);
    freq.put("дби", 10);
    freq.put("имп", 19);
    freq.put("имо", 46);
    freq.put("имн", 16);
    freq.put("ими", 77);
    freq.put("име", 292);
    freq.put("имб", 8);
    freq.put("има", 671);
    freq.put("Еј ", 21);
    freq.put("орх", 8);
    freq.put("орч", 19);
    freq.put("орц", 5);
    freq.put("пи ", 77);
    freq.put("ору", 48);
    freq.put("орт", 101);
    freq.put("Цр", 12);
    freq.put("џаб", 17);
    freq.put("џан", 10);
    freq.put("ист", 535);
    freq.put("ису", 10);
    freq.put("орѓ", 5);
    freq.put("исч", 11);
    freq.put("иси", 49);
    freq.put("иск", 220);
    freq.put("исл", 264);
    freq.put("исм", 25);
    freq.put("Це", 32);
    freq.put("исо", 41);
    freq.put("исп", 81);
    freq.put("иса", 37);
    freq.put("исв", 8);
    freq.put("исе", 43);
    freq.put("орн", 91);
    freq.put("орм", 82);
    freq.put("оро", 160);
    freq.put("ори", 327);
    freq.put("орк", 23);
    freq.put("оре", 198);
    freq.put("орд", 37);
    freq.put("орб", 16);
    freq.put("ора", 371);
    freq.put("орг", 47);
    freq.put("орв", 6);
    freq.put("иму", 14);
    freq.put("имс", 16);
    freq.put("лси", 9);
    freq.put("Ма ", 11);
    freq.put("пка", 41);
    freq.put("нф", 66);
    freq.put("пки", 10);
    freq.put("циј", 390);
    freq.put("ее ", 85);
    freq.put("ст ", 337);
    freq.put("меа", 24);
    freq.put("рги", 28);
    freq.put("рго", 7);
    freq.put("ргн", 13);
    freq.put("рга", 43);
    freq.put("рге", 9);
    freq.put("мег", 6);
    freq.put("мед", 44);
    freq.put("мее", 30);
    freq.put("ДО ", 5);
    freq.put("зум", 16);
    freq.put("ьо", 6);
    freq.put("ргу", 8);
    freq.put("циц", 40);
    freq.put("зар", 59);
    freq.put("цир", 19);
    freq.put("јџе", 5);
    freq.put("егу", 33);
    freq.put("вук", 5);
    freq.put("егр", 15);
    freq.put("вуд", 6);
    freq.put("вув", 81);
    freq.put("Си ", 27);
    freq.put("еше", 235);
    freq.put("сро", 6);
    freq.put("срп", 6);
    freq.put("еша", 41);
    freq.put("ешо", 24);
    freq.put("сра", 31);
    freq.put("срб", 5);
    freq.put("ешк", 98);
    freq.put("еши", 35);
    freq.put("сре", 115);
    freq.put("ешт", 142);
    freq.put("срц", 30);
    freq.put("Ел ", 5);
    freq.put("егз", 6);
    freq.put("еге", 19);
    freq.put("егд", 7);
    freq.put("вуш", 10);
    freq.put("ега", 216);
    freq.put("его", 140);
    freq.put("егн", 33);
    freq.put("вуч", 15);
    freq.put("егл", 8);
    freq.put("еги", 27);
    freq.put("П ", 38);
    freq.put("ххх", 7);
    freq.put("П", 1053);
    freq.put("Соб", 8);
    freq.put("Сов", 8);
    freq.put("Сон", 13);
    freq.put("Сол", 10);
    freq.put("Соф", 8);
    freq.put("Сор", 5);
    freq.put("Сос", 5);
    freq.put("ххе", 7);
    freq.put("хха", 24);
    freq.put(" б ", 14);
    freq.put("Аме", 19);
    freq.put("Амд", 6);
    freq.put("Ама", 40);
    freq.put("ов ", 415);
    freq.put("КО ", 14);
    freq.put(" гл", 340);
    freq.put(" ги", 408);
    freq.put(" го", 1153);
    freq.put(" гн", 7);
    freq.put(" га", 104);
    freq.put(" ге", 39);
    freq.put("оал", 12);
    freq.put("Зош", 28);
    freq.put("ЕО ", 19);
    freq.put(" ол", 15);
    freq.put("оаѓ", 27);
    freq.put("це ", 127);
    freq.put("оар", 9);
    freq.put("рс ", 25);
    freq.put(" гу", 56);
    freq.put(" гр", 259);
    freq.put("ике", 37);
    freq.put("ика", 556);
    freq.put("икв", 12);
    freq.put("икн", 24);
    freq.put("ико", 179);
    freq.put("ики", 65);
    freq.put("икл", 18);
    freq.put("ко ", 1266);
    freq.put("оту", 18);
    freq.put("отс", 36);
    freq.put("отр", 81);
    freq.put("Хри", 6);
    freq.put("отк", 130);
    freq.put("оти", 292);
    freq.put("отп", 32);
    freq.put("ото", 444);
    freq.put("отн", 52);
    freq.put("отв", 109);
    freq.put("ота", 166);
    freq.put("оте", 150);
    freq.put(" Ќе", 75);
    freq.put("икс", 12);
    freq.put("икр", 7);
    freq.put("ику", 27);
    freq.put("икт", 12);
    freq.put("Л", 277);
    freq.put("им ", 213);
    freq.put("џа ", 8);
    freq.put("пин", 29);
    freq.put("пио", 24);
    freq.put("пип", 7);
    freq.put("пик", 13);
    freq.put("пил", 26);
    freq.put("пие", 68);
    freq.put("пиз", 14);
    freq.put("пив", 43);
    freq.put("пиш", 138);
    freq.put("пиц", 16);
    freq.put("пич", 23);
    freq.put("пир", 67);
    freq.put("пис", 53);
    freq.put("пит", 37);
    freq.put("Ц ", 28);
    freq.put("пиј", 66);
    freq.put("ис ", 78);
    freq.put("Ман", 18);
    freq.put("Мам", 6);
    freq.put("Мал", 30);
    freq.put("Мак", 225);
    freq.put("Маж", 7);
    freq.put("Мад", 15);
    freq.put("рба", 42);
    freq.put("рбе", 14);
    freq.put("рби", 45);
    freq.put("рбо", 10);
    freq.put("очн", 149);
    freq.put("Маш", 14);
    freq.put("Мат", 7);
    freq.put("Мар", 65);
    freq.put("Мај", 34);
    freq.put("еем", 13);
    freq.put("еее", 83);
    freq.put("ста", 791);
    freq.put("ств", 298);
    freq.put("сте", 282);
    freq.put("сти", 516);
    freq.put("рг ", 18);
    freq.put("сто", 389);
    freq.put("стр", 287);
    freq.put(" Ба", 142);
    freq.put("сту", 69);
    freq.put("дл", 101);
    freq.put("ееј", 5);
    freq.put("еењ", 13);
    freq.put("ееш", 26);
    freq.put("еер", 6);
    freq.put("еет", 6);
    freq.put(" Бл", 24);
    freq.put("лд ", 6);
    freq.put("да", 3730);
    freq.put("Ист", 24);
    freq.put("Ису", 5);
    freq.put("ву ", 5);
    freq.put("Ѓо", 11);
    freq.put("еш ", 246);
    freq.put("Сим", 7);
    freq.put("Син", 11);
    freq.put("ДИ ", 5);
    freq.put("Сит", 44);
    freq.put("Сир", 9);
    freq.put("ќ", 1569);
    freq.put("Иск", 12);
    freq.put("Исп", 5);
    freq.put("Еле", 14);
    freq.put("Ако", 94);
    freq.put("ипр", 5);
    freq.put("Со ", 41);
    freq.put("Акт", 19);
    freq.put(" ба", 331);
    freq.put(" бе", 573);
    freq.put(" би", 505);
    freq.put(" бл", 87);
    freq.put(" бо", 176);
    freq.put("овл", 8);
    freq.put("овк", 12);
    freq.put("ови", 535);
    freq.put("ово", 373);
    freq.put("овн", 58);
    freq.put("овм", 10);
    freq.put("ова", 379);
    freq.put("ове", 307);
    freq.put("овд", 22);
    freq.put("в", 14209);
    freq.put("шпа", 9);
    freq.put("ову", 5);
    freq.put("овт", 39);
    freq.put("овс", 89);
    freq.put("овр", 61);
    freq.put("овч", 14);
    freq.put("овц", 29);
    freq.put(" бр", 254);
    freq.put(" бу", 114);
    freq.put("рст", 50);
    freq.put("црв", 11);
    freq.put("црн", 29);
    freq.put("црк", 21);
    freq.put(" г ", 14);
    freq.put("цет", 36);
    freq.put("цер", 19);
    freq.put("цес", 5);
    freq.put("оа ", 540);
    freq.put("цед", 17);
    freq.put("цев", 13);
    freq.put("тиј", 63);
    freq.put("цеп", 30);
    freq.put("очу", 15);
    freq.put("цел", 118);
    freq.put("рса", 17);
    freq.put("рсе", 30);
    freq.put("црт", 7);
    freq.put("рси", 12);
    freq.put("рск", 169);
    freq.put("рсн", 8);
    freq.put("рсо", 12);
    freq.put(" ем", 27);
    freq.put(" ен", 19);
    freq.put("Над", 12);
    freq.put(" еп", 46);
    freq.put("Нав", 6);
    freq.put("Наг", 6);
    freq.put(" ек", 82);
    freq.put(" ел", 43);
    freq.put(" ед", 373);
    freq.put("Нап", 10);
    freq.put("Нам", 9);
    freq.put(" ез", 5);
    freq.put(" еб", 42);
    freq.put(" ев", 140);
    freq.put(" ег", 10);
    freq.put("оже", 267);
    freq.put("ожд", 23);
    freq.put("фор", 77);
    freq.put("ожб", 6);
    freq.put("фот", 51);
    freq.put("ожн", 18);
    freq.put("ожи", 44);
    freq.put("ктр", 15);
    freq.put("мх ", 7);
    freq.put("хо", 121);
    freq.put("ЕМ ", 12);
    freq.put(" еј", 19);
    freq.put("фог", 5);
    freq.put("фон", 44);
    freq.put("ру ", 11);
    freq.put("Нај", 75);
    freq.put("фок", 7);
    freq.put("Нат", 5);
    freq.put("Нау", 9);
    freq.put("Нар", 8);
    freq.put("Нас", 12);
    freq.put(" еф", 12);
    freq.put(" ех", 5);
    freq.put(" ер", 6);
    freq.put(" ес", 15);
    freq.put(" ет", 25);
    freq.put("аса", 104);
    freq.put("асв", 8);
    freq.put("асе", 47);
    freq.put("аси", 106);
    freq.put("аск", 71);
    freq.put("асл", 47);
    freq.put("асм", 54);
    freq.put("асн", 100);
    freq.put("асо", 63);
    freq.put("асп", 54);
    freq.put("шив", 21);
    freq.put("јд ", 13);
    freq.put("шил", 24);
    freq.put("шик", 7);
    freq.put("шио", 28);
    freq.put("шин", 39);
    freq.put("гир", 16);
    freq.put("гис", 16);
    freq.put("гит", 42);
    freq.put("гич", 7);
    freq.put("мче", 14);
    freq.put("гиј", 31);
    freq.put("ури", 94);
    freq.put("гив", 5);
    freq.put("гиг", 5);
    freq.put("гии", 5);
    freq.put("гик", 12);
    freq.put("гин", 31);
    freq.put("гио", 15);
    freq.put("шит", 53);
    freq.put("шир", 30);
    freq.put("шич", 6);
    freq.put("лг ", 6);
    freq.put("жрт", 9);
    freq.put("шиш", 18);
    freq.put("асс", 12);
    freq.put("аст", 177);
    freq.put("асу", 19);
    freq.put("рхи", 10);
    freq.put("нзе", 6);
    freq.put("рхе", 11);
    freq.put("шиј", 15);
    freq.put("Изл", 9);
    freq.put("леш", 24);
    freq.put("леч", 46);
    freq.put("лец", 13);
    freq.put("леф", 27);
    freq.put("Изв", 15);
    freq.put("лет", 147);
    freq.put("лес", 59);
    freq.put("лер", 50);
    freq.put("Што", 72);
    freq.put("лењ", 11);
    freq.put("леј", 38);
    freq.put("Ште", 6);
    freq.put("Шта", 5);
    freq.put("Тие", 7);
    freq.put("зга", 17);
    freq.put("згл", 72);
    freq.put("зго", 47);
    freq.put("згр", 26);
    freq.put("згу", 19);
    freq.put("Тит", 6);
    freq.put("ио ", 36);
    freq.put("леп", 41);
    freq.put("лен", 247);
    freq.put("лем", 165);
    freq.put("лел", 47);
    freq.put("лек", 136);
    freq.put("лез", 64);
    freq.put("ејт", 45);
    freq.put("лее", 10);
    freq.put("лед", 427);
    freq.put("лег", 91);
    freq.put("лев", 80);
    freq.put("леб", 12);
    freq.put("леа", 41);
    freq.put(" Вр", 34);
    freq.put(" Ву", 8);
    freq.put(" Вт", 17);
    freq.put("сар", 9);
    freq.put("офт", 5);
    freq.put("офи", 61);
    freq.put("офо", 14);
    freq.put("офа", 13);
    freq.put("офе", 25);
    freq.put(" Ве", 142);
    freq.put(" Ва", 67);
    freq.put(" Вн", 8);
    freq.put(" Во", 117);
    freq.put(" Ви", 118);
    freq.put(" Вл", 39);
    freq.put(" Вк", 8);
    freq.put("иак", 7);
    freq.put("иан", 6);
    freq.put("иам", 25);
    freq.put("Ѕв", 6);
    freq.put("бг ", 5);
    freq.put("Ит", 7);
    freq.put("Ир", 7);
    freq.put("Ис", 52);
    freq.put("хор", 18);
    freq.put("хот", 24);
    freq.put(" ри", 53);
    freq.put(" ро", 100);
    freq.put("иха", 10);
    freq.put("ихо", 13);
    freq.put("ре ", 183);
    freq.put("Тра", 17);
    freq.put("Тре", 25);
    freq.put("Три", 24);
    freq.put("Тро", 8);
    freq.put("хов", 5);
    freq.put("ход", 21);
    freq.put("хол", 21);
    freq.put("Ил", 30);
    freq.put("Им", 80);
    freq.put("Ин", 80);
    freq.put("Ив", 27);
    freq.put("Иг", 14);
    freq.put("Иб", 5);
    freq.put("Из", 60);
    freq.put("Ид", 23);
    freq.put("Мон", 10);
    freq.put("Мом", 10);
    freq.put("Мол", 8);
    freq.put("ќна", 13);
    freq.put("Мод", 5);
    freq.put("Мож", 32);
    freq.put("ља ", 16);
    freq.put("рзе", 5);
    freq.put("рза", 30);
    freq.put("рзо", 17);
    freq.put("рзн", 13);
    freq.put("рзи", 32);
    freq.put("ец ", 110);
    freq.put("ме ", 1062);
    freq.put("рзу", 5);
    freq.put("еб ", 29);
    freq.put("Мос", 7);
    freq.put("Мор", 24);
    freq.put("ои", 345);
    freq.put("ок", 694);
    freq.put("ол", 1603);
    freq.put("ом", 908);
    freq.put("он", 1514);
    freq.put("оо", 219);
    freq.put("оп", 704);
    freq.put("оа", 612);
    freq.put("об", 1116);
    freq.put("ов", 2378);
    freq.put("ог", 1190);
    freq.put("од", 2649);
    freq.put("ое", 192);
    freq.put("ож", 487);
    freq.put("оз", 446);
    freq.put("ефа", 8);
    freq.put("сфе", 8);
    freq.put("оМ", 5);
    freq.put("сфа", 24);
    freq.put("ефе", 17);
    freq.put("сфо", 6);
    freq.put("ефи", 22);
    freq.put("ефо", 40);
    freq.put("к", 14720);
    freq.put("ејз", 18);
    freq.put("ефт", 6);
    freq.put("ој", 1403);
    freq.put("ољ", 37);
    freq.put("оњ", 22);
    freq.put("оќ", 71);
    freq.put("еја", 29);
    freq.put("оџ", 6);
    freq.put("ге ", 5);
    freq.put("ош", 416);
    freq.put("ејо", 7);
    freq.put("ор", 1844);
    freq.put("ос", 1476);
    freq.put("от", 3180);
    freq.put("оу", 80);
    freq.put("оф", 145);
    freq.put("ејм", 9);
    freq.put("оц", 107);
    freq.put("оч", 460);
    freq.put("ејн", 16);
    freq.put("Ч ", 7);
    freq.put("јт", 245);
    freq.put("ју", 117);
    freq.put("еже", 8);
    freq.put("Јув", 10);
    freq.put("Југ", 7);
    freq.put("игд", 13);
    freq.put("Еее", 5);
    freq.put(" Ел", 29);
    freq.put("Јун", 11);
    freq.put("игл", 15);
    freq.put("руш", 28);
    freq.put("Лим", 5);
    freq.put("Лин", 11);
    freq.put("ож ", 6);
    freq.put("рут", 18);
    freq.put("Лив", 9);
    freq.put("рус", 23);
    freq.put("руч", 17);
    freq.put("руј", 27);
    freq.put("На ", 87);
    freq.put("аџе", 8);
    freq.put(" е ", 1545);
    freq.put("збу", 37);
    freq.put("збр", 29);
    freq.put("збо", 126);
    freq.put("зби", 53);
    freq.put("збе", 26);
    freq.put("рук", 15);
    freq.put("рул", 6);
    freq.put("фо ", 16);
    freq.put("рум", 41);
    freq.put("рун", 6);
    freq.put("рув", 114);
    freq.put("руг", 222);
    freq.put("руа", 11);
    freq.put("руж", 39);
    freq.put("руд", 20);
    freq.put("руе", 27);
    freq.put("јде", 164);
    freq.put("ши ", 96);
    freq.put("лгр", 11);
    freq.put("јда", 41);
    freq.put("јдо", 69);
    freq.put("кми", 9);
    freq.put("јди", 17);
    freq.put("ас ", 366);
    freq.put("Гру", 27);
    freq.put("Грц", 28);
    freq.put("Грч", 6);
    freq.put("ги ", 471);
    freq.put("Гри", 9);
    freq.put("Гра", 19);
    freq.put("Гре", 7);
    freq.put("игр", 138);
    freq.put("дго", 55);
    freq.put("лга", 15);
    freq.put("лго", 16);
    freq.put("иор", 6);
    freq.put("иот", 426);
    freq.put(" Ај", 79);
    freq.put(" Ау", 7);
    freq.put(" Ат", 12);
    freq.put(" Ас", 5);
    freq.put(" Ар", 38);
    freq.put(" Ац", 5);
    freq.put(" Ах", 31);
    freq.put("Дер", 7);
    freq.put("Дес", 5);
    freq.put("Дет", 15);
    freq.put("Деф", 5);
    freq.put("Деч", 12);
    freq.put("ж", 1779);
    freq.put("Ти ", 32);
    freq.put("оце", 36);
    freq.put("оцн", 9);
    freq.put("оцк", 7);
    freq.put("оци", 52);
    freq.put(" Аг", 7);
    freq.put(" Ав", 29);
    freq.put("АЛ ", 5);
    freq.put(" Аа", 11);
    freq.put("Дем", 14);
    freq.put("Ден", 55);
    freq.put(" Ад", 21);
    freq.put(" Ал", 75);
    freq.put(" Ак", 119);
    freq.put("Дев", 9);
    freq.put("Дед", 5);
    freq.put(" Ан", 75);
    freq.put(" Ам", 71);
    freq.put("иов", 10);
    freq.put("иод", 15);
    freq.put("иоз", 28);
    freq.put("иол", 12);
    freq.put("ион", 142);
    freq.put("иоп", 17);
    freq.put("иум", 58);
    freq.put("бја", 39);
    freq.put("бје", 7);
    freq.put("оф ", 13);
    freq.put("иа ", 19);
    freq.put(" В ", 5);
    freq.put("Ќ", 91);
    freq.put("рем", 324);
    freq.put("рен", 261);
    freq.put("рео", 12);
    freq.put("реп", 67);
    freq.put("реи", 14);
    freq.put("рек", 206);
    freq.put("рел", 36);
    freq.put("ред", 443);
    freq.put("рее", 13);
    freq.put("реж", 26);
    freq.put("рез", 60);
    freq.put("реа", 51);
    freq.put("реб", 250);
    freq.put("рев", 114);
    freq.put("рег", 45);
    freq.put("чну", 21);
    freq.put("реќ", 73);
    freq.put("чни", 81);
    freq.put("реј", 33);
    freq.put("чно", 155);
    freq.put("рењ", 21);
    freq.put("чна", 136);
    freq.put("чне", 24);
    freq.put("реш", 108);
    freq.put("реф", 18);
    freq.put("рец", 41);
    freq.put("реч", 68);
    freq.put("рер", 12);
    freq.put("рес", 219);
    freq.put("рет", 216);
    freq.put("ВР ", 11);
    freq.put("И ", 276);
    freq.put("хо ", 5);
    freq.put("мер", 131);
    freq.put("мес", 163);
    freq.put("мет", 261);
    freq.put("вст", 50);
    freq.put("рз ", 8);
    freq.put("меч", 14);
    freq.put("меш", 41);
    freq.put("ебр", 14);
    freq.put("ебу", 12);
    freq.put("љан", 8);
    freq.put("меѓ", 53);
    freq.put(" јо", 12);
    freq.put("меј", 34);
    freq.put("мењ", 10);
    freq.put(" ја", 950);
    freq.put("ау ", 10);
    freq.put(" је", 76);
    freq.put("еци", 40);
    freq.put("ецк", 8);
    freq.put("сци", 6);
    freq.put("ецо", 27);
    freq.put("еца", 61);
    freq.put("сце", 18);
    freq.put("еце", 20);
    freq.put(" ју", 31);
    freq.put("љат", 6);
    freq.put("еби", 49);
    freq.put("мев", 18);
    freq.put("все", 9);
    freq.put("ебн", 27);
    freq.put("љач", 9);
    freq.put("ебо", 23);
    freq.put("еба", 292);
    freq.put("мек", 24);
    freq.put("мел", 16);
    freq.put("ебе", 201);
    freq.put("мен", 520);
    freq.put("ЦА ", 7);
    freq.put("о ", 10633);
    freq.put("Сми", 7);
    freq.put("Сме", 11);
    freq.put("хум", 12);
    freq.put("ѕид", 6);
    freq.put("Фуд", 9);
    freq.put("Че", 58);
    freq.put("Ча", 28);
    freq.put("Чо", 18);
    freq.put("Чи", 32);
    freq.put("э", 8);
    freq.put("Чу", 16);
    freq.put("Дун", 5);
    freq.put("тне", 18);
    freq.put("зје", 5);
    freq.put("зја", 21);
    freq.put("Дур", 10);
    freq.put("од ", 1221);
    freq.put("ајт", 185);
    freq.put("Но ", 7);
    freq.put("ајч", 16);
    freq.put("фи ", 12);
    freq.put("век", 95);
    freq.put("вел", 78);
    freq.put("вен", 238);
    freq.put("вев", 7);
    freq.put("веа", 25);
    freq.put("веб", 11);
    freq.put("веж", 21);
    freq.put("вез", 32);
    freq.put("вед", 91);
    freq.put("вее", 30);
    freq.put("КИ ", 15);
    freq.put("мс ", 15);
    freq.put("о", 35159);
    freq.put("веш", 18);
    freq.put("не ", 1719);
    freq.put("вет", 242);
    freq.put("вер", 199);
    freq.put("вес", 95);
    freq.put("вец", 24);
    freq.put("веч", 99);
    freq.put("вењ", 8);
    freq.put("веј", 8);
    freq.put("веќ", 148);
    freq.put("веѓ", 5);
    freq.put("ахо", 6);
    freq.put("њак", 5);
    freq.put("њам", 13);
    freq.put("Лош", 5);
    freq.put("њав", 7);
    freq.put("аха", 242);
    freq.put("нгр", 7);
    freq.put("муз", 42);
    freq.put("муд", 13);
    freq.put("мув", 12);
    freq.put("муа", 39);
    freq.put("шми", 6);
    freq.put("мун", 21);
    freq.put("мук", 7);
    freq.put("мул", 10);
    freq.put("шма", 5);
    freq.put("пљ", 7);
    freq.put("пј", 128);
    freq.put("пш", 37);
    freq.put("пч", 32);
    freq.put("пц", 23);
    freq.put("пу", 283);
    freq.put("пт", 91);
    freq.put("пс", 133);
    freq.put("пр", 2461);
    freq.put("пп", 7);
    freq.put("по", 2898);
    freq.put("пн", 47);
    freq.put("пм", 8);
    freq.put("пл", 377);
    freq.put("пк", 54);
    freq.put("пи", 723);
    freq.put("пе", 636);
    freq.put("па", 1358);
    freq.put("ки ", 912);
    freq.put("АН ", 5);
    freq.put("мур", 11);
    freq.put("мус", 13);
    freq.put("муш", 9);
    freq.put("нго", 9);
    freq.put("Лон", 8);
    freq.put("нгл", 22);
    freq.put("Лоз", 7);
    freq.put("нге", 22);
    freq.put("ус ", 91);
    freq.put("нга", 17);
    freq.put("Д", 865);
    freq.put("ууу", 43);
    freq.put("цна", 9);
    freq.put("шва", 5);
    freq.put("Џеј", 10);
    freq.put("ив ", 245);
    freq.put(" Д ", 9);
    freq.put("па ", 364);
    freq.put("ајз", 9);
    freq.put(" са", 694);
    freq.put(" св", 292);
    freq.put(" сд", 6);
    freq.put(" се", 2539);
    freq.put("идс", 8);
    freq.put("идр", 8);
    freq.put(" си", 820);
    freq.put(" ск", 129);
    freq.put("пју", 13);
    freq.put(" см", 239);
    freq.put(" сн", 85);
    freq.put(" со", 1198);
    freq.put(" сп", 291);
    freq.put(" Че", 58);
    freq.put("ич ", 41);
    freq.put("куз", 7);
    freq.put("кув", 97);
    freq.put("кум", 18);
    freq.put("кун", 7);
    freq.put("куп", 86);
    freq.put("кук", 6);
    freq.put("кул", 64);
    freq.put("куц", 5);
    freq.put("куч", 25);
    freq.put("кур", 83);
    freq.put("кус", 44);
    freq.put("кут", 8);
    freq.put("куш", 6);
    freq.put(" Жа", 9);
    freq.put("л ", 1029);
    freq.put(" Же", 19);
    freq.put("куќ", 17);
    freq.put(" Жи", 17);
    freq.put("куј", 6);
    freq.put(" ср", 177);
    freq.put("иде", 397);
    freq.put(" су", 375);
    freq.put(" сф", 26);
    freq.put(" сх", 6);
    freq.put(" сц", 13);
    freq.put("ида", 96);
    freq.put("идо", 57);
    freq.put("идн", 41);
    freq.put("идл", 8);
    freq.put("иди", 111);
    freq.put(" сѐ", 7);
    freq.put("ТЛ ", 7);
    freq.put("иља", 13);
    freq.put("Кли", 11);
    freq.put("Му ", 11);
    freq.put("Кла", 7);
    freq.put("Ми ", 31);
    freq.put("јнш", 5);
    freq.put("беб", 5);
    freq.put("беа", 22);
    freq.put("бег", 20);
    freq.put("бев", 25);
    freq.put("бее", 13);
    freq.put("бед", 83);
    freq.put("без", 112);
    freq.put("рле", 13);
    freq.put("бел", 67);
    freq.put("бек", 13);
    freq.put("бен", 100);
    freq.put("ет ", 310);
    freq.put("Лок", 5);
    freq.put("ѕ", 33);
    freq.put("ахх", 25);
    freq.put("њат", 23);
    freq.put("беј", 6);
    freq.put("беџ", 5);
    freq.put("бес", 42);
    freq.put("бер", 62);
    freq.put("бет", 54);
    freq.put("беш", 144);
    freq.put("њац", 5);
    freq.put("лја", 17);
    freq.put("А", 855);
    freq.put("ЈА ", 24);
    freq.put("фиј", 17);
    freq.put("Нов", 79);
    freq.put("оди", 366);
    freq.put("одл", 38);
    freq.put("одк", 5);
    freq.put("одн", 123);
    freq.put("АТ ", 13);
    freq.put("одп", 5);
    freq.put("одо", 154);
    freq.put("фич", 7);
    freq.put("ода", 212);
    freq.put("одг", 54);
    freq.put("одв", 18);
    freq.put("оде", 215);
    freq.put("фит", 5);
    freq.put("фис", 7);
    freq.put("фир", 16);
    freq.put("ољи", 8);
    freq.put("оља", 8);
    freq.put("оље", 18);
    freq.put("фин", 84);
    freq.put("фил", 107);
    freq.put("фик", 35);
    freq.put("фии", 16);
    freq.put("одс", 14);
    freq.put("одр", 57);
    freq.put("оду", 21);
    freq.put(" зд", 48);
    freq.put(" зе", 125);
    freq.put(" зв", 21);
    freq.put(" зг", 44);
    freq.put(" за", 2392);
    freq.put(" зб", 103);
    freq.put("Нор", 8);
    freq.put(" зм", 5);
    freq.put(" зн", 366);
    freq.put(" зл", 22);
    freq.put(" зи", 30);
    freq.put("аук", 7);
    freq.put("неч", 34);
    freq.put("нец", 60);
    freq.put("нес", 252);
    freq.put("нер", 110);
    freq.put("неу", 12);
    freq.put("аун", 5);
    freq.put("ве ", 326);
    freq.put("ауз", 8);
    freq.put("шке", 7);
    freq.put("шка", 109);
    freq.put("шко", 83);
    freq.put("шки", 59);
    freq.put("мск", 58);
    freq.put("мст", 17);
    freq.put("рче", 47);
    freq.put("рча", 32);
    freq.put("рчк", 22);
    freq.put("рчи", 24);
    freq.put("нее", 7);
    freq.put("нед", 94);
    freq.put("нез", 42);
    freq.put("неж", 20);
    freq.put("неб", 11);
    freq.put("неа", 42);
    freq.put("нег", 144);
    freq.put("нев", 76);
    freq.put("аут", 24);
    freq.put("ауу", 6);
    freq.put("неп", 31);
    freq.put("аус", 10);
    freq.put("ауч", 29);
    freq.put("нел", 46);
    freq.put("нек", 440);
    freq.put("кис", 11);
    freq.put("кир", 49);
    freq.put("кит", 151);
    freq.put("му ", 256);
    freq.put("јру", 10);
    freq.put("уст", 90);
    freq.put("ах ", 32);
    freq.put("зни", 78);
    freq.put("зно", 34);
    freq.put("зна", 570);
    freq.put("зне", 35);
    freq.put("зну", 13);
    freq.put("ё", 5);
    freq.put("п ", 195);
    freq.put("усл", 14);
    freq.put("уск", 30);
    freq.put("уси", 33);
    freq.put("усп", 68);
    freq.put("усо", 19);
    freq.put("усн", 19);
    freq.put("лзи", 17);
    freq.put("уса", 5);
    freq.put("усе", 13);
    freq.put("нг ", 74);
    freq.put("кив", 19);
    freq.put("кие", 10);
    freq.put("кид", 7);
    freq.put("кил", 19);
    freq.put("кин", 78);
    freq.put("ким", 10);
    freq.put("кип", 23);
    freq.put("кио", 99);
    freq.put("ивш", 8);
    freq.put("ивц", 6);
    freq.put("ивр", 6);
    freq.put("иву", 10);
    freq.put("ивт", 12);
    freq.put(" Ду", 27);
    freq.put(" Др", 57);
    freq.put("Цен", 11);
    freq.put("Цел", 15);
    freq.put(" сè", 12);
    freq.put(" До", 194);
    freq.put(" Дн", 8);
    freq.put(" Ди", 44);
    freq.put(" Де", 176);
    freq.put(" Дв", 23);
    freq.put(" Да", 220);
    freq.put("ивн", 115);
    freq.put("ивм", 23);
    freq.put("иво", 231);
    freq.put("иви", 62);
    freq.put("ивк", 22);
    freq.put("иве", 210);
    freq.put("уу ", 24);
    freq.put(" с ", 39);
    freq.put("пад", 80);
    freq.put("паз", 24);
    freq.put("паа", 12);
    freq.put("пав", 22);
    freq.put("пам", 71);
    freq.put("пан", 66);
    freq.put("пап", 7);
    freq.put("пак", 113);
    freq.put("пал", 62);
    freq.put("ДЕ ", 5);
    freq.put("ку ", 468);
    freq.put("Ч", 168);
    freq.put("лј", 20);
    freq.put("лу", 687);
    freq.put("лт", 106);
    freq.put("лс", 94);
    freq.put("ичн", 170);
    freq.put("лч", 21);
    freq.put("лц", 50);
    freq.put("ичи", 34);
    freq.put("лф", 21);
    freq.put("лш", 5);
    freq.put("ича", 44);
    freq.put("лг", 53);
    freq.put("лв", 19);
    freq.put("лб", 61);
    freq.put("ла", 2124);
    freq.put("лз", 21);
    freq.put("лж", 46);
    freq.put("ле", 2276);
    freq.put("лд", 25);
    freq.put("лл", 9);
    freq.put("лк", 471);
    freq.put("ли", 2292);
    freq.put("ло", 994);
    freq.put("лн", 477);
    freq.put("лм", 94);
    freq.put("пац", 10);
    freq.put("пач", 10);
    freq.put("пар", 221);
    freq.put("пас", 53);
    freq.put("хмм", 5);
    freq.put("пау", 8);
    freq.put("хме", 5);
    freq.put("ид ", 61);
    freq.put("пај", 15);
    freq.put("пањ", 15);
    freq.put("Мит", 8);
    freq.put("Мис", 27);
    freq.put("Мир", 18);
    freq.put("Муз", 6);
    freq.put("аџи", 8);
    freq.put("тде", 6);
    freq.put("Мур", 12);
    freq.put("мир", 99);
    freq.put("иду", 19);
    freq.put("Мин", 18);
    freq.put("Мил", 41);
    freq.put(" ќе", 929);
    freq.put("јра", 6);
    freq.put(" ќо", 6);
    freq.put("љда", 12);
    freq.put("мбу", 11);
    freq.put("бе ", 416);
    freq.put("ете", 412);
    freq.put(" сл", 408);
    freq.put("ета", 240);
    freq.put("етв", 37);
    freq.put("етм", 5);
    freq.put("етн", 96);
    freq.put("ето", 516);
    freq.put("етп", 8);
    freq.put("ети", 203);
    freq.put("етк", 48);
    freq.put("етл", 23);
    freq.put("нè ", 5);
    freq.put("етх", 7);
    freq.put("етч", 5);
    freq.put("етр", 53);
    freq.put("етс", 75);
    freq.put("етт", 10);
    freq.put("ету", 30);
    freq.put("мбо", 11);
    freq.put("мби", 18);
    freq.put("мбе", 9);
    freq.put("мба", 28);
    freq.put("рне", 77);
    freq.put("бли", 47);
    freq.put("рна", 61);
    freq.put("бло", 38);
    freq.put("рно", 221);
    freq.put("бла", 61);
    freq.put("рни", 96);
    freq.put("бле", 77);
    freq.put("И", 597);
    freq.put("Хор", 11);
    freq.put("ер ", 537);
    freq.put("гур", 48);
    freq.put("блу", 5);
    freq.put(" Ру", 21);
    freq.put("è ", 17);
    freq.put("ДА ", 15);
    freq.put("ффф", 12);
    freq.put("мни", 32);
    freq.put("мно", 172);
    freq.put("мна", 49);
    freq.put("мне", 11);
    freq.put(" Ра", 79);
    freq.put(" Ре", 85);
    freq.put(" Ри", 29);
    freq.put(" Ро", 47);
    freq.put("ѓи", 12);
    freq.put("ѓа", 128);
    freq.put("ѓе", 95);
    freq.put(" ст", 666);
    freq.put("ѓу", 64);
    freq.put("м ", 2924);
    freq.put("љ", 238);
    freq.put(" С", 1292);
    freq.put("Ниш", 22);
    freq.put("шо ", 268);
    freq.put(" ну", 19);
    freq.put("Сег", 28);
    freq.put("оѓа", 9);
    freq.put("го ", 966);
    freq.put(" не", 2823);
    freq.put(" на", 4025);
    freq.put("ач ", 39);
    freq.put(" но", 388);
    freq.put(" ни", 484);
    freq.put("Ник", 40);
    freq.put("Ние", 13);
    freq.put("шал", 35);
    freq.put("с", 16169);
    freq.put("шан", 45);
    freq.put("шам", 77);
    freq.put("шав", 39);
    freq.put("шаа", 12);
    freq.put("Едн", 26);
    freq.put("гај", 18);
    freq.put("гањ", 7);
    freq.put("гаќ", 7);
    freq.put("гум", 9);
    freq.put("гаш", 142);
    freq.put("гар", 122);
    freq.put("Чек", 16);
    freq.put("гат", 71);
    freq.put("Чес", 11);
    freq.put("гал", 15);
    freq.put("Фил", 26);
    freq.put("ган", 80);
    freq.put("ух ", 8);
    freq.put("гаа", 8);
    freq.put("гав", 21);
    freq.put("Чеш", 6);
    freq.put("гад", 11);
    freq.put("гаж", 5);
    freq.put("газ", 31);
    freq.put("шањ", 59);
    freq.put("шај", 19);
    freq.put("шаш", 6);
    freq.put("шат", 68);
    freq.put("шар", 30);
    freq.put("шач", 8);
    freq.put(" у ", 390);
    freq.put("Ги ", 16);
    freq.put("зли", 45);
    freq.put("зло", 19);
    freq.put("зла", 19);
    freq.put("учу", 27);
    freq.put("зле", 45);
    freq.put("кс ", 80);
    freq.put(" И ", 164);
    freq.put("учи", 94);
    freq.put("лне", 15);
    freq.put("учк", 10);
    freq.put("учн", 17);
    freq.put("лна", 97);
    freq.put("лно", 187);
    freq.put("уче", 63);
    freq.put("лни", 161);
    freq.put("кве", 11);
    freq.put("ква", 113);
    freq.put("кво", 40);
    freq.put("кви", 82);
    freq.put("Ѕ", 15);
    freq.put(" хм", 7);
    freq.put(" хо", 51);
    freq.put(" хи", 29);
    freq.put(" хе", 80);
    freq.put(" ха", 145);
    freq.put("еља", 23);
    freq.put(" Кр", 47);
    freq.put(" Ку", 76);
    freq.put("Зе", 15);
    freq.put("Зд", 23);
    freq.put("Зв", 5);
    freq.put("Зб", 6);
    freq.put("За", 227);
    freq.put("Зо", 35);
    freq.put("Зн", 49);
    freq.put("Зл", 11);
    freq.put("Зи", 5);
    freq.put("хи ", 7);
    freq.put(" Ко", 306);
    freq.put(" Ки", 63);
    freq.put("сбу", 29);
    freq.put(" Ке", 22);
    freq.put(" Ка", 309);
    freq.put("тач", 11);
    freq.put("К ", 55);
    freq.put(" ху", 14);
    freq.put("Роб", 10);
    freq.put("Рем", 6);
    freq.put("Рен", 5);
    freq.put("Реп", 11);
    freq.put("Рек", 12);
    freq.put("Реа", 27);
    freq.put("Рег", 5);
    freq.put("рн ", 14);
    freq.put("еро", 162);
    freq.put("ерп", 27);
    freq.put("ерм", 34);
    freq.put("ерн", 158);
    freq.put("ерк", 58);
    freq.put("ерл", 11);
    freq.put("ери", 338);
    freq.put("ерж", 13);
    freq.put("ерз", 25);
    freq.put("ерд", 9);
    freq.put("ере", 178);
    freq.put("ерв", 81);
    freq.put("ерг", 23);
    freq.put("ера", 191);
    freq.put("ерб", 26);
    freq.put("чле", 16);
    freq.put("ерџ", 43);
    freq.put("ерц", 14);
    freq.put("ерч", 10);
    freq.put("ерф", 5);
    freq.put("ерт", 37);
    freq.put("еру", 68);
    freq.put("ерс", 73);
    freq.put("Рет", 5);
    freq.put("фф ", 14);
    freq.put("ѕве", 16);
    freq.put(" Р ", 16);
    freq.put("Жа", 12);
    freq.put("Же", 21);
    freq.put("мн ", 10);
    freq.put(" Чу", 16);
    freq.put("рла", 35);
    freq.put("оол", 7);
    freq.put("рли", 23);
    freq.put("рло", 12);
    freq.put("Жив", 15);
    freq.put("јци", 6);
    freq.put("мд", 11);
    freq.put("ме", 2512);
    freq.put("мв", 19);
    freq.put("ма", 2922);
    freq.put("мб", 83);
    freq.put("мо", 1513);
    freq.put("мп", 141);
    freq.put("мм", 41);
    freq.put("мн", 276);
    freq.put("мк", 42);
    freq.put("мл", 70);
    freq.put("ми", 1706);
    freq.put(" лу", 123);
    freq.put("вга", 5);
    freq.put("ИТ ", 8);
    freq.put("Шв", 20);
    freq.put("тко", 67);
    freq.put("жба", 27);
    freq.put("жбе", 7);
    freq.put("тки", 51);
    freq.put(" ла", 122);
    freq.put(" ле", 196);
    freq.put(" ли", 277);
    freq.put(" ло", 112);
    freq.put("мј", 65);
    freq.put("мц", 12);
    freq.put("мч", 19);
    freq.put("мф", 17);
    freq.put("мх", 11);
    freq.put("мт", 10);
    freq.put("му", 455);
    freq.put("мр", 135);
    freq.put("мс", 95);
    freq.put("мш", 20);
    freq.put("шов", 5);
    freq.put("ачу", 28);
    freq.put("шол", 13);
    freq.put("шок", 11);
    freq.put("шоп", 6);
    freq.put("нбу", 7);
    freq.put("гот", 68);
    freq.put("Фор", 5);
    freq.put("гор", 68);
    freq.put("гос", 46);
    freq.put("год", 280);
    freq.put("гов", 164);
    freq.put("тур", 140);
    freq.put("гон", 13);
    freq.put("гол", 143);
    freq.put("нба", 5);
    freq.put("рш ", 6);
    freq.put("Ни ", 8);
    freq.put("шоу", 10);
    freq.put("аче", 73);
    freq.put(" н ", 9);
    freq.put("ача", 69);
    freq.put("ачо", 17);
    freq.put("ачн", 22);
    freq.put("ачк", 95);
    freq.put("ачи", 208);
    freq.put("Шит", 12);
    freq.put("ша ", 100);
    freq.put(" нè", 5);
    freq.put("га ", 613);
    freq.put("ухо", 12);
    freq.put(" ук", 19);
    freq.put(" ул", 62);
    freq.put(" уп", 45);
    freq.put(" ум", 57);
    freq.put(" ун", 15);
    freq.put(" ув", 20);
    freq.put(" уг", 5);
    freq.put(" уа", 8);
    freq.put(" уб", 131);
    freq.put(" уж", 16);
    freq.put(" уд", 29);
    freq.put(" Ит", 7);
    freq.put(" Ис", 52);
    freq.put(" Ир", 6);
    freq.put("ксо", 14);
    freq.put("ксп", 20);
    freq.put("кск", 11);
    freq.put("кси", 56);
    freq.put("ксе", 16);
    freq.put("кса", 20);
    freq.put("т", 22864);
    freq.put("лн ", 10);
    freq.put("кст", 75);
    freq.put("ксу", 19);
    freq.put(" Ил", 30);
    freq.put(" Ин", 80);
    freq.put(" Им", 80);
    freq.put(" Иг", 13);
    freq.put(" Ив", 27);
    freq.put(" Иб", 5);
    freq.put(" Из", 60);
    freq.put(" Ид", 23);
    freq.put("ижи", 15);
    freq.put(" уш", 152);
    freq.put("ижн", 5);
    freq.put(" ут", 136);
    freq.put("ижа", 13);
    freq.put(" ур", 27);
    freq.put(" ус", 108);
    freq.put("иже", 11);
    freq.put(" уч", 55);
    freq.put(" уф", 11);
    freq.put("Кр", 47);
    freq.put("Ку", 77);
    freq.put("хих", 7);
    freq.put("хит", 15);
    freq.put("З ", 6);
    freq.put("бру", 11);
    freq.put("хиј", 6);
    freq.put("брк", 15);
    freq.put("бри", 93);
    freq.put("бро", 230);
    freq.put("бра", 268);
    freq.put("брз", 40);
    freq.put("бре", 65);
    freq.put("хип", 10);
    freq.put("Ко", 311);
    freq.put("Ки", 66);
    freq.put("Кл", 26);
    freq.put("Ке", 22);
    freq.put("Ка", 313);
    freq.put("аб ", 18);
    freq.put(" че", 170);
    freq.put(" ча", 81);
    freq.put(" чо", 93);
    freq.put(" чл", 16);
    freq.put(" чи", 124);
    freq.put("х ", 98);
    freq.put(" Му", 41);
    freq.put(" Мр", 13);
    freq.put(" Ме", 128);
    freq.put(" Ма", 454);
    freq.put(" Мо", 123);
    freq.put(" Мн", 34);
    freq.put(" Мл", 5);
    freq.put(" Ми", 159);
    freq.put("н ", 1771);
    freq.put(" чу", 110);
    freq.put("тчи", 7);
    freq.put("уро", 20);
    freq.put("Кел", 5);
    freq.put("Кен", 5);
    freq.put("агл", 12);
    freq.put("аги", 68);
    freq.put("иџе", 5);
    freq.put("аго", 81);
    freq.put("агн", 7);
    freq.put("ага", 94);
    freq.put("нè", 5);
    freq.put("аге", 18);
    freq.put("Луѓ", 10);
    freq.put("г", 5934);
    freq.put("еин", 5);
    freq.put(" у", 1300);
    freq.put(" р", 1289);
    freq.put("Лук", 7);
    freq.put("ѐ ", 9);
    freq.put("Срп", 5);
    freq.put(" ц", 352);
    freq.put("Срб", 25);
    freq.put("Сре", 30);
    freq.put("агу", 10);
    freq.put("агр", 57);
    freq.put("Кер", 6);
    freq.put(" ш", 1142);
    freq.put("азд", 23);
    freq.put("ЦИ ", 7);
    freq.put("азб", 60);
    freq.put("мп ", 5);
    freq.put("ур ", 42);
    freq.put(" Т ", 5);
    freq.put(" џ", 59);
    freq.put(" У", 194);
    freq.put("Љ", 27);
    freq.put(" Фу", 11);
    freq.put(" Фр", 28);
    freq.put("Бес", 10);
    freq.put("Бер", 15);
    freq.put("фре", 9);
    freq.put("Бет", 5);
    freq.put("фра", 19);
    freq.put("фро", 8);
    freq.put("фрл", 28);
    freq.put("фри", 23);
    freq.put("Бев", 5);
    freq.put("Без", 10);
    freq.put("Бел", 22);
    freq.put("Бен", 6);
    freq.put(" Фо", 28);
    freq.put(" Фи", 45);
    freq.put(" Фе", 39);
    freq.put(" Фа", 63);
    freq.put("узи", 61);
    freq.put(" л", 837);
    freq.put("узн", 10);
    freq.put(" и", 4275);
    freq.put("тек", 109);
    freq.put("тел", 309);
    freq.put("теи", 7);
    freq.put("тео", 12);
    freq.put("теп", 66);
    freq.put("тем", 69);
    freq.put("тен", 264);
    freq.put("тев", 16);
    freq.put("тег", 22);
    freq.put("теа", 12);
    freq.put("теб", 95);
    freq.put("теж", 12);
    freq.put("тез", 6);
    freq.put("тед", 28);
    freq.put("тее", 7);
    freq.put("уза", 12);
    freq.put("Ј ", 13);
    freq.put("тењ", 15);
    freq.put("теј", 7);
    freq.put("узе", 12);
    freq.put("теш", 43);
    freq.put("тет", 107);
    freq.put("тер", 668);
    freq.put("тес", 53);
    freq.put("теч", 15);
    freq.put("теф", 9);
    freq.put("тех", 11);
    freq.put("АШ ", 5);
    freq.put("јов", 6);
    freq.put("ук ", 53);
    freq.put("умф", 11);
    freq.put("лту", 19);
    freq.put("умр", 16);
    freq.put("умс", 7);
    freq.put("уму", 5);
    freq.put(" Г", 383);
    freq.put(" Б", 596);
    freq.put(" Е", 436);
    freq.put("дма", 48);
    freq.put("фа ", 19);
    freq.put("дми", 31);
    freq.put("дмо", 11);
    freq.put("умн", 26);
    freq.put("умо", 25);
    freq.put("лто", 7);
    freq.put("уме", 49);
    freq.put("лта", 35);
    freq.put("ума", 36);
    freq.put("умб", 6);
    freq.put("лте", 29);
    freq.put(" М", 1098);
    freq.put(" п ", 12);
    freq.put("вну", 7);
    freq.put("же ", 203);
    freq.put("КА ", 30);
    freq.put("Ве ", 12);
    freq.put("Рус", 15);
    freq.put("вна", 84);
    freq.put("вне", 7);
    freq.put("вни", 131);
    freq.put("вно", 116);
    freq.put("одм", 59);
    freq.put("одб", 33);
    freq.put("пчи", 14);
    freq.put("фиц", 24);
    freq.put("пче", 13);
    freq.put("пча", 5);
    freq.put("ЕА ", 7);
    freq.put("одд", 25);
    freq.put("одз", 14);
    freq.put("нла", 6);
    freq.put("нли", 6);
    freq.put("риу", 20);
    freq.put("Јеб", 8);
    freq.put("ка ", 2153);
    freq.put("рис", 160);
    freq.put("рир", 60);
    freq.put("рич", 44);
    freq.put("хни", 5);
    freq.put("аба", 107);
    freq.put("абе", 133);
    freq.put(" ч ", 14);
    freq.put("аби", 56);
    freq.put("абл", 20);
    freq.put("або", 401);
    freq.put("Стр", 23);
    freq.put("Сту", 5);
    freq.put("нџ", 26);
    freq.put("нх", 10);
    freq.put("зур", 8);
    freq.put("нч", 79);
    freq.put("нц", 259);
    freq.put("нс", 509);
    freq.put("нр", 13);
    freq.put("ну", 349);
    freq.put("нт", 707);
    freq.put("нш", 16);
    freq.put("не", 4078);
    freq.put("нд", 353);
    freq.put("нз", 84);
    freq.put("зув", 6);
    freq.put("нб", 15);
    freq.put("на", 7593);
    freq.put("нг", 164);
    freq.put("нв", 24);
    freq.put("зул", 17);
    freq.put("но", 2774);
    freq.put("ни", 3428);
    freq.put("нл", 14);
    freq.put("нк", 278);
    freq.put("Ста", 44);
    freq.put("Сте", 16);
    freq.put("Сти", 8);
    freq.put("Сто", 25);
    freq.put("абр", 36);
    freq.put("рпо", 21);
    freq.put("аг ", 27);
    freq.put("рпе", 15);
    freq.put("Кре", 8);
    freq.put(" Ст", 124);
    freq.put("рил", 86);
    freq.put("рик", 92);
    freq.put("анк", 92);
    freq.put("рпу", 9);
    freq.put("рпс", 11);
    freq.put(" Тр", 83);
    freq.put(" Ту", 34);
    freq.put("рим", 107);
    freq.put("риг", 17);
    freq.put("рив", 99);
    freq.put("риб", 22);
    freq.put("риа", 7);
    freq.put("баз", 7);
    freq.put("рие", 45);
    freq.put("мпј", 13);
    freq.put("прс", 21);
    freq.put("ја ", 1757);
    freq.put("ц", 2430);
    freq.put("пру", 9);
    freq.put("мпа", 35);
    freq.put("мпе", 11);
    freq.put("мпл", 23);
    freq.put("мпи", 38);
    freq.put("мпо", 7);
    freq.put(" Те", 92);
    freq.put(" Та", 75);
    freq.put(" Тв", 46);
    freq.put(" То", 121);
    freq.put(" Ти", 63);
    freq.put("виш", 46);
    freq.put(" зо", 74);
    freq.put("уку", 47);
    freq.put("укр", 8);
    freq.put("укс", 11);
    freq.put("укц", 10);
    freq.put("М", 1116);
    freq.put("Јо", 27);
    freq.put("Ја", 159);
    freq.put("нет", 197);
    freq.put("Је", 19);
    freq.put("те ", 2610);
    freq.put("неш", 198);
    freq.put("Ју", 35);
    freq.put("зра", 38);
    freq.put("укл", 7);
    freq.put("уки", 18);
    freq.put("уко", 12);
    freq.put("укн", 11);
    freq.put("укв", 16);
    freq.put("ука", 115);
    freq.put("уке", 5);
    freq.put("Кру", 5);
    freq.put(" пт", 8);
    freq.put(" пу", 119);
    freq.put(" пр", 2084);
    freq.put(" пс", 9);
    freq.put("Црв", 9);
    freq.put("фаќ", 22);
    freq.put("фај", 8);
    freq.put("фац", 20);
    freq.put("фат", 61);
    freq.put("фас", 11);
    freq.put("фар", 9);
    freq.put("фаш", 5);
    freq.put("фаз", 7);
    freq.put("фав", 9);
    freq.put("фаб", 5);
    freq.put("фан", 42);
    freq.put("фам", 11);
    freq.put("фал", 70);
    freq.put("фак", 47);
    freq.put(" по", 2333);
    freq.put(" пм", 6);
    freq.put(" пл", 205);
    freq.put(" пи", 284);
    freq.put(" пе", 327);
    freq.put(" па", 748);
    freq.put("ум ", 329);
    freq.put("шве", 10);
    freq.put("Вер", 11);
    freq.put("Вес", 37);
    freq.put("Веч", 17);
    freq.put("жев", 6);
    freq.put("жеб", 14);
    freq.put("жем", 14);
    freq.put("жен", 172);
    freq.put("жел", 41);
    freq.put("жет", 31);
    freq.put("БА ", 7);
    freq.put("РИ ", 10);
    freq.put("жеш", 58);
    freq.put("пут", 12);
    freq.put("жењ", 9);
    freq.put("Вел", 28);
    freq.put("Вен", 17);
    freq.put("Веб", 5);
    freq.put("кај", 215);
    freq.put("кањ", 22);
    freq.put("каш", 86);
    freq.put("кас", 41);
    freq.put("кар", 151);
    freq.put("кау", 9);
    freq.put("кат", 318);
    freq.put("каф", 71);
    freq.put("кач", 48);
    freq.put("кац", 54);
    freq.put(" мо", 732);
    freq.put("каи", 9);
    freq.put("кал", 93);
    freq.put("как", 489);
    freq.put("кан", 130);
    freq.put("кам", 224);
    freq.put("кап", 65);
    freq.put("као", 37);
    freq.put("каб", 12);
    freq.put("каа", 57);
    freq.put("каг", 11);
    freq.put("кав", 48);
    freq.put("кад", 96);
    freq.put("каз", 68);
    freq.put("каж", 199);
    freq.put("лбу", 13);
    freq.put("псе", 8);
    freq.put("гуш", 12);
    freq.put("псо", 18);
    freq.put("гус", 14);
    freq.put("пск", 62);
    freq.put("пси", 12);
    freq.put("дбр", 16);
    freq.put("ОН ", 8);
    freq.put("кок", 27);
    freq.put("рѓи", 5);
    freq.put("коп", 178);
    freq.put(" ѕв", 18);
    freq.put("Шо ", 21);
    freq.put("пст", 21);
    freq.put("гул", 17);
    freq.put("гуж", 5);
    freq.put("губ", 36);
    freq.put("јт ", 29);
    freq.put("гуг", 10);
    freq.put("гув", 24);
    freq.put("се ", 1829);
    freq.put("Го ", 23);
    freq.put("нен", 34);
    freq.put("нем", 426);
    freq.put(" О ", 10);
    freq.put("нео", 22);
    freq.put("Шам", 7);
    freq.put("туц", 5);
    freq.put("ае ", 70);
    freq.put("тус", 22);
    freq.put("тут", 15);
    freq.put("сли", 178);
    freq.put("сло", 91);
    freq.put("еѓа", 7);
    freq.put("сла", 212);
    freq.put("сле", 274);
    freq.put("туѓ", 6);
    freq.put("еор", 16);
    freq.put("еот", 20);
    freq.put("Гал", 8);
    freq.put("еоф", 5);
    freq.put("кич", 12);
    freq.put("ю", 8);
    freq.put("Ќе ", 75);
    freq.put("еоб", 8);
    freq.put("еог", 7);
    freq.put("еод", 5);
    freq.put(" Шп", 11);
    freq.put("еон", 6);
    freq.put("еоп", 5);
    freq.put("еѓу", 58);
    freq.put("слу", 185);
    freq.put("тун", 9);
    freq.put("туп", 6);
    freq.put("туи", 5);
    freq.put("тук", 76);
    freq.put("тул", 23);
    freq.put("туд", 40);
    freq.put("туе", 31);
    freq.put("туж", 6);
    freq.put("туа", 21);
    freq.put("туб", 6);
    freq.put("тув", 86);
    freq.put("иѓа", 11);
    freq.put("азе", 30);
    freq.put("азв", 16);
    freq.put("азг", 23);
    freq.put("аза", 82);
    freq.put("еду", 62);
    freq.put("азо", 42);
    freq.put("азм", 22);
    freq.put("азн", 88);
    freq.put("азл", 43);
    freq.put("ази", 72);
    freq.put("киј", 15);
    freq.put("хај", 8);
    freq.put("хаш", 7);
    freq.put("хах", 254);
    freq.put("хау", 6);
    freq.put("хар", 17);
    freq.put("хам", 6);
    freq.put("хан", 5);
    freq.put("хак", 12);
    freq.put("хаа", 9);
    freq.put("азу", 14);
    freq.put("фт ", 7);
    freq.put("сѐ ", 7);
    freq.put("Ф", 286);
    freq.put(" Ц ", 8);
    freq.put("Абе", 48);
    freq.put("Спо", 30);
    freq.put(" Шу", 12);
    freq.put(" Шт", 96);
    freq.put("држ", 105);
    freq.put("дре", 32);
    freq.put("дрв", 6);
    freq.put("дра", 134);
    freq.put("дро", 55);
    freq.put("кос", 35);
    freq.put(" ам", 292);
    freq.put("дри", 43);
    freq.put("кор", 113);
    freq.put("дба", 93);
    freq.put("маф", 8);
    freq.put("јле", 59);
    freq.put("ѓун", 6);
    freq.put("дру", 228);
    freq.put("НИ ", 19);
    freq.put("дрш", 11);
    freq.put("Пре", 74);
    freq.put("лби", 5);
    freq.put("Пра", 41);
    freq.put(" Шо", 26);
    freq.put("Прв", 16);
    freq.put(" Шв", 20);
    freq.put("Про", 89);
    freq.put(" Ша", 23);
    freq.put("При", 55);
    freq.put(" Ше", 15);
    freq.put("нц ", 6);
    freq.put("Зем", 9);
    freq.put("до ", 295);
    freq.put("нфи", 8);
    freq.put("нфо", 39);
    freq.put("нфе", 14);
    freq.put("По ", 14);
    freq.put("диш", 72);
    freq.put("уар", 26);
    freq.put("диц", 8);
    freq.put("диу", 32);
    freq.put("дит", 90);
    freq.put("дис", 61);
    freq.put("дир", 48);
    freq.put("диќ", 5);
    freq.put("диј", 63);
    freq.put("дип", 15);
    freq.put("дио", 43);
    freq.put("дин", 276);
    freq.put("лце", 29);
    freq.put("дил", 30);
    freq.put("дик", 20);
    freq.put("дии", 12);
    freq.put("диз", 21);
    freq.put("уаб", 39);
    freq.put("дие", 11);
    freq.put("дид", 8);
    freq.put("диг", 20);
    freq.put("див", 34);
    freq.put("лци", 18);
    freq.put("Њу", 9);
    freq.put("ски", 646);
    freq.put("орс", 25);
    freq.put("пс ", 8);
    freq.put("Р", 331);
    freq.put("где", 23);
    freq.put("ЛШ ", 8);
    freq.put("јто", 16);
    freq.put("јте", 170);
    freq.put("гу ", 191);
    freq.put("исц", 8);
    freq.put("Ца", 9);
    freq.put("себ", 60);
    freq.put("сеа", 80);
    freq.put("сег", 141);
    freq.put("сев", 14);
    freq.put("сед", 82);
    freq.put("сез", 23);
    freq.put("сеи", 9);
    freq.put("сел", 81);
    freq.put("сек", 224);
    freq.put("сен", 93);
    freq.put("сем", 27);
    freq.put("сеп", 34);
    freq.put("исн", 22);
    freq.put("Год", 8);
    freq.put("Гол", 17);
    freq.put("Ци", 9);
    freq.put("еу", 46);
    freq.put(" Ос", 55);
    freq.put(" Ор", 10);
    freq.put(" От", 35);
    freq.put(" Ох", 22);
    freq.put(" Оч", 13);
    freq.put(" Ол", 10);
    freq.put(" Ок", 11);
    freq.put(" Он", 51);
    freq.put(" Оп", 23);
    freq.put(" Об", 29);
    freq.put(" Ог", 13);
    freq.put(" Ов", 55);
    freq.put(" Од", 121);
    freq.put(" Оз", 7);
    freq.put("Гоц", 7);
    freq.put("Гор", 13);
    freq.put("Гос", 24);
    freq.put("сес", 18);
    freq.put("сер", 101);
    freq.put("сеу", 15);
    freq.put("сет", 91);
    freq.put("сеч", 35);
    freq.put("сец", 37);
    freq.put("сеш", 5);
    freq.put(" а ", 406);
    freq.put("тхо", 7);
    freq.put("сељ", 12);
    freq.put("сеќ", 37);
    freq.put("ОЈ ", 7);
    freq.put("сл ", 10);
    freq.put("аем", 28);
    freq.put("аен", 10);
    freq.put("аел", 19);
    freq.put("аед", 24);
    freq.put("аеб", 46);
    freq.put("аев", 20);
    freq.put("ео ", 63);
    freq.put("Чув", 6);
    freq.put("Чуд", 5);
    freq.put("аеш", 53);
    freq.put("РТ ", 13);
    freq.put("аец", 5);
    freq.put("ту ", 34);
    freq.put("аес", 11);
    freq.put("ает", 26);
    freq.put("аењ", 7);
    freq.put("аз ", 28);
    freq.put("зам", 117);
    freq.put("ха ", 87);
    freq.put("дич", 6);
    freq.put("зао", 5);
    freq.put("бно", 14);
    freq.put("бна", 15);
    freq.put("фти", 8);
    freq.put("уац", 7);
    freq.put("фта", 5);
    freq.put("фтв", 5);
    freq.put("мле", 10);
    freq.put("мла", 55);
    freq.put(" Ца", 9);
    freq.put(" Це", 32);
    freq.put(" Ци", 9);
    freq.put("Бла", 17);
    freq.put("ѕи", 11);
    freq.put("ѕв", 18);
    freq.put("нцу", 7);
    freq.put("Сам", 59);
    freq.put("зад", 86);
    freq.put("Сан", 9);
    freq.put("з", 5933);
    freq.put("др ", 9);
    freq.put("ѓу ", 47);
    freq.put("нца", 7);
    freq.put("нце", 81);
    freq.put("нци", 151);
    freq.put("нцо", 6);
    freq.put("ива", 179);
    freq.put("дим", 53);
    freq.put("уан", 7);
    freq.put("доф", 6);
    freq.put("доч", 16);
    freq.put("доц", 11);
    freq.put("дос", 85);
    freq.put("дор", 30);
    freq.put("дот", 105);
    freq.put("дош", 15);
    freq.put("дој", 69);
    freq.put("дод", 59);
    freq.put("доз", 32);
    freq.put("дож", 21);
    freq.put("доб", 339);
    freq.put("доа", 39);
    freq.put("дог", 36);
    freq.put("дов", 168);
    freq.put("дон", 352);
    freq.put("дом", 93);
    freq.put("доп", 29);
    freq.put("дол", 116);
    freq.put("док", 73);
    freq.put("лфа", 13);
    freq.put("Пок", 7);
    freq.put("Пол", 31);
    freq.put("Поп", 16);
    freq.put("Пом", 8);
    freq.put("Пон", 9);
    freq.put("Пов", 16);
    freq.put("Пог", 23);
    freq.put("Поб", 10);
    freq.put("Поз", 21);
    freq.put("Под", 18);
    freq.put("Кур", 14);
    freq.put("уа ", 7);
    freq.put("ди ", 399);
    freq.put(" Ѓо", 11);
    freq.put("Кум", 14);
    freq.put("Куп", 21);
    freq.put("Кул", 5);
    freq.put("Пош", 8);
    freq.put("Пот", 15);
    freq.put("Пор", 29);
    freq.put("Пос", 36);
    freq.put("Поч", 35);
    freq.put("вле", 59);
    freq.put("вла", 50);
    freq.put("вло", 7);
    freq.put("вли", 30);
    freq.put("Тек", 13);
    freq.put("Тел", 18);
    freq.put("Тем", 6);
    freq.put("Тен", 5);
    freq.put("цве", 13);
    freq.put("Ш", 246);
    freq.put("увр", 9);
    freq.put("увс", 34);
    freq.put("ичк", 202);
    freq.put("ифу", 7);
    freq.put("ува", 1146);
    freq.put("уве", 35);
    freq.put("РМ ", 6);
    freq.put("јли", 9);
    freq.put("цвр", 5);
    freq.put("јло", 11);
    freq.put("Има", 73);
    freq.put("Теш", 5);
    freq.put("Тет", 9);
    freq.put("Тер", 5);
    freq.put("Тес", 5);
    freq.put("рт", 397);
    freq.put("ру", 667);
    freq.put("рр", 16);
    freq.put("рс", 331);
    freq.put("рц", 121);
    freq.put("рч", 131);
    freq.put("рф", 16);
    freq.put("рх", 27);
    freq.put("рш", 118);
    freq.put("рѓ", 6);
    freq.put("пу ", 5);
    freq.put("рј", 8);
    freq.put("рџ", 50);
    freq.put("Аха", 15);
    freq.put("ќта", 9);
    freq.put("шу ", 5);
    freq.put("Умр", 5);
    freq.put("еЗа", 22);
    freq.put("рв", 286);
    freq.put("рг", 128);
    freq.put("ра", 4800);
    freq.put("рб", 114);
    freq.put("рж", 132);
    freq.put("рз", 112);
    freq.put("рд", 160);
    freq.put("ре", 2936);
    freq.put("рк", 328);
    freq.put("рл", 90);
    freq.put("ри", 2324);
    freq.put("ро", 2110);
    freq.put("рп", 65);
    freq.put("рм", 169);
    freq.put("рн", 481);
    freq.put("жно", 42);
    freq.put("жни", 24);
    freq.put("у ", 1624);
    freq.put("жна", 16);
    freq.put("Вни", 5);
    freq.put("пат", 156);
    freq.put("пна", 17);
    freq.put("пне", 10);
    freq.put("пни", 9);
    freq.put("пно", 7);
    freq.put("јјј", 12);
    freq.put("јја", 11);
    freq.put("ем ", 143);
    freq.put("паѓ", 33);
    freq.put("ЗА ", 27);
    freq.put("тс ", 6);
    freq.put("спе", 100);
    freq.put("спа", 59);
    freq.put("спо", 225);
    freq.put("спл", 29);
    freq.put("спи", 117);
    freq.put("ѓев", 5);
    freq.put("вју", 11);
    freq.put("екр", 29);
    freq.put("екс", 200);
    freq.put("ект", 119);
    freq.put("еку", 122);
    freq.put("екн", 29);
    freq.put("еко", 615);
    freq.put("еки", 51);
    freq.put("екл", 47);
    freq.put("еке", 21);
    freq.put("ека", 742);
    freq.put("екв", 5);
    freq.put("ѓет", 24);
    freq.put("спу", 12);
    freq.put("спр", 76);
    freq.put("алт", 18);
    freq.put("алу", 18);
    freq.put("алс", 18);
    freq.put("алц", 36);
    freq.put("алф", 6);
    freq.put("јта", 20);
    freq.put("Ор", 10);
    freq.put("Ос", 55);
    freq.put("От", 36);
    freq.put("Ох", 22);
    freq.put("Оч", 13);
    freq.put("п", 9519);
    freq.put("Ок", 11);
    freq.put("Ол", 11);
    freq.put("Он", 51);
    freq.put("ИП ", 5);
    freq.put("Оп", 23);
    freq.put("Об", 29);
    freq.put("Ов", 57);
    freq.put("Ог", 13);
    freq.put("Од", 123);
    freq.put("Оз", 7);
    freq.put("Сеа", 20);
    freq.put("ала", 288);
    freq.put("алб", 21);
    freq.put("Сед", 13);
    freq.put("алд", 13);
    freq.put("але", 276);
    freq.put("алк", 129);
    freq.put("али", 464);
    freq.put("Сек", 39);
    freq.put("ало", 163);
    freq.put("алн", 236);
    freq.put("сè ", 11);
    freq.put("ол ", 94);
    freq.put("афр", 8);
    freq.put("фф", 26);
    freq.put("фт", 30);
    freq.put("фу", 78);
    freq.put("фр", 98);
    freq.put("фс", 6);
    freq.put("Е", 464);
    freq.put("Љу", 20);
    freq.put("афе", 60);
    freq.put("фо", 233);
    freq.put("фк", 7);
    freq.put("фл", 18);
    freq.put("фи", 351);
    freq.put("фе", 215);
    freq.put("нт ", 94);
    freq.put("фа", 349);
    freq.put("фб", 29);
    freq.put("урл", 7);
    freq.put("Те ", 12);
    freq.put("Пив", 9);
    freq.put("Укр", 5);
    freq.put("АА ", 9);
    freq.put("Ауу", 5);
    freq.put("Пис", 6);
    freq.put("Пит", 10);
    freq.put("Пиј", 11);
    freq.put("јл ", 15);
    freq.put("пул", 26);
    freq.put("пук", 26);
    freq.put("пун", 16);
    freq.put("пуб", 14);
    freq.put("пув", 37);
    freq.put("иша", 66);
    freq.put("ише", 83);
    freq.put("ишл", 6);
    freq.put("ишк", 13);
    freq.put("иши", 19);
    freq.put("ишо", 10);
    freq.put("ишн", 27);
    freq.put("шув", 92);
    freq.put("шуе", 7);
    freq.put("шум", 5);
    freq.put("л", 11055);
    freq.put("Ах ", 11);
    freq.put("ину", 85);
    freq.put("шут", 11);
    freq.put("шур", 6);
    freq.put("РО ", 18);
    freq.put("ишу", 56);
    freq.put("ишт", 105);
    freq.put("р ", 1242);
    freq.put("пуш", 100);
    freq.put("пус", 28);
    freq.put("Уст", 7);
    freq.put("меб", 6);
    freq.put("Фан", 7);
    freq.put("Фал", 31);
    freq.put("Фак", 10);
    freq.put("ул", 303);
    freq.put("ук", 319);
    freq.put("уи", 13);
    freq.put("уп", 331);
    freq.put("уо", 5);
    freq.put("ун", 187);
    freq.put("ум", 616);
    freq.put("уг", 294);
    freq.put("ув", 1239);
    freq.put("уб", 402);
    freq.put("уа", 131);
    freq.put("уз", 110);
    freq.put("уж", 98);
    freq.put("уе", 112);
    freq.put("рта", 69);
    freq.put("уш", 527);
    freq.put("уу", 71);
    freq.put("ут", 378);
    freq.put("ус", 397);
    freq.put("ур", 534);
    freq.put("уч", 282);
    freq.put("уц", 35);
    freq.put("ух", 26);
    freq.put("уф", 34);
    freq.put("уњ", 5);
    freq.put("уј", 67);
    freq.put("уџ", 12);
    freq.put("Фат", 6);
    freq.put("уќ", 21);
    freq.put("уѓ", 95);
    freq.put("јца", 37);
    freq.put("ешн", 90);
    freq.put("оќ ", 26);
    freq.put("Шве", 14);
    freq.put("Шва", 5);
    freq.put("јга", 10);
    freq.put("Б", 606);
    freq.put("Гва", 6);
    freq.put("тст", 41);
    freq.put("ему", 9);
    freq.put("емс", 8);
    freq.put("емј", 62);
    freq.put("уџе", 7);
    freq.put("емк", 6);
    freq.put("еми", 169);
    freq.put("јј ", 7);
    freq.put("емо", 119);
    freq.put("емп", 12);
    freq.put("емн", 26);
    freq.put("емв", 15);
    freq.put("ема", 530);
    freq.put("емб", 9);
    freq.put("еме", 349);
    freq.put("тсе", 40);
    freq.put("ине", 97);
    freq.put("тск", 73);
    freq.put("тсл", 5);
    freq.put("ѓе ", 61);
    freq.put("ек ", 161);
    freq.put("т ", 3912);
    freq.put("Ово", 13);
    freq.put("Ова", 36);
    freq.put("?", 11);
    freq.put("ВО ", 21);
    freq.put("Се ", 109);
    freq.put("ал ", 339);
    freq.put("О ", 219);
    freq.put("олс", 21);
    freq.put("олт", 19);
    freq.put("олу", 109);
    freq.put("олц", 7);
    freq.put("олч", 12);
    freq.put("олј", 5);
    freq.put("риц", 20);
    freq.put("ола", 224);
    freq.put("олг", 32);
    freq.put("олд", 5);
    freq.put("оле", 269);
    freq.put("олж", 45);
    freq.put("олз", 10);
    freq.put("оли", 210);
    freq.put("олк", 282);
    freq.put("олн", 102);
    freq.put("оло", 137);
    freq.put("тпи", 14);
    freq.put("тпо", 5);
    freq.put("тпа", 10);
    freq.put("нтр", 36);
    freq.put("нтс", 5);
    freq.put("нту", 21);
    freq.put(" ќу", 14);
    freq.put("нтн", 12);
    freq.put("нто", 43);
    freq.put("нти", 148);
    freq.put("нтк", 5);
    freq.put("тпр", 27);
    freq.put("нте", 201);
    freq.put("тпу", 5);
    freq.put("нта", 131);
    freq.put("ф ", 65);
    freq.put("опш", 27);
    freq.put("опц", 12);
    freq.put("опч", 8);
    freq.put("опр", 45);
    freq.put("опс", 62);
    freq.put("опт", 11);
    freq.put("опу", 55);
    freq.put("опј", 113);
    freq.put("Хам", 7);
    freq.put("лаб", 77);
    freq.put("Хаг", 6);
    freq.put("дво", 69);
    freq.put("Хах", 16);
    freq.put("лак", 30);
    freq.put("сја", 5);
    freq.put("инч", 11);
    freq.put("лам", 197);
    freq.put("лан", 134);
    freq.put("опн", 8);
    freq.put("опо", 45);
    freq.put("опи", 61);
    freq.put("опк", 13);
    freq.put("опл", 32);
    freq.put("опе", 35);
    freq.put("ај ", 586);
    freq.put("опа", 116);
    freq.put("тле", 9);
    freq.put("тла", 9);
    freq.put("ца ", 293);
    freq.put("аер", 34);
    freq.put("тло", 10);
    freq.put("тли", 18);
    freq.put("лат", 219);
    freq.put("ует", 7);
    freq.put("инк", 74);
    freq.put("Лет", 5);
    freq.put("инд", 26);
    freq.put("ЕУ ", 17);
    freq.put("у", 8732);
    freq.put("Ру", 21);
    freq.put("Лел", 16);
    freq.put("Лек", 11);
    freq.put("ање", 421);
    freq.put("ања", 69);
    freq.put("МА ", 14);
    freq.put("мја", 31);
    freq.put("мјо", 20);
    freq.put("јн ", 33);
    freq.put("мји", 11);
    freq.put("ужј", 5);
    freq.put("ужн", 9);
    freq.put("ужи", 34);
    freq.put("уже", 16);
    freq.put("ужв", 6);
    freq.put("ужа", 10);
    freq.put("ужб", 13);
    freq.put("јпа", 7);
    freq.put("јпо", 8);
    freq.put("По", 312);
    freq.put("Пл", 25);
    freq.put("До ", 13);
    freq.put("Пи", 57);
    freq.put("Пе", 75);
    freq.put("Па", 168);
    freq.put("Пф", 5);
    freq.put("Пу", 27);
    freq.put("Пс", 5);
    freq.put("Пр", 277);
    freq.put(" мх", 9);
    freq.put("итн", 79);
    freq.put(" мр", 70);
    freq.put("пеј", 11);
    freq.put("осе", 149);
    freq.put("неј", 27);
    freq.put("ите", 1855);
    freq.put("Дим", 13);
    freq.put("Ме ", 9);
    freq.put("Дир", 5);
    freq.put("осн", 26);
    freq.put("раѓ", 31);
    freq.put("рањ", 75);
    freq.put("рај", 168);
    freq.put("раќ", 61);
    freq.put("рат", 415);
    freq.put("рас", 152);
    freq.put("рар", 7);
    freq.put("рач", 96);
    freq.put("рац", 60);
    freq.put("раф", 48);
    freq.put("раш", 215);
    freq.put("хн", 10);
    freq.put("хм", 15);
    freq.put("Л ", 26);
    freq.put("хи", 67);
    freq.put("хе", 132);
    freq.put("ха", 451);
    freq.put("хв", 5);
    freq.put("јќи", 39);
    freq.put("хх", 40);
    freq.put("јќе", 9);
    freq.put("хр", 53);
    freq.put("ху", 25);
    freq.put("еи ", 13);
    freq.put("раг", 54);
    freq.put("рав", 548);
    freq.put("раб", 310);
    freq.put("раа", 140);
    freq.put("раз", 292);
    freq.put("раж", 27);
    freq.put("рае", 46);
    freq.put("рад", 327);
    freq.put("рал", 104);
    freq.put("рак", 158);
    freq.put("раи", 45);
    freq.put("рап", 20);
    freq.put("рао", 9);
    freq.put("ран", 419);
    freq.put("рам", 322);
    freq.put("сус", 11);
    freq.put("сур", 8);
    freq.put("суш", 12);
    freq.put("ут ", 25);
    freq.put(" ѓу", 5);
    freq.put("јк", 188);
    freq.put("јл", 101);
    freq.put("ји", 29);
    freq.put("јо", 151);
    freq.put("јп", 19);
    freq.put("јм", 95);
    freq.put("јн", 179);
    freq.put("јв", 53);
    freq.put("јг", 38);
    freq.put("ја", 3060);
    freq.put("јб", 47);
    freq.put("јз", 34);
    freq.put("јд", 311);
    freq.put("је", 278);
    freq.put("ежи", 42);
    freq.put("јш", 8);
    freq.put("У ", 55);
    freq.put("ежн", 19);
    freq.put("ежо", 5);
    freq.put("ежа", 24);
    freq.put("ежб", 8);
    freq.put("јр", 19);
    freq.put("јс", 105);
    freq.put("јц", 49);
    freq.put("јч", 37);
    freq.put("јф", 6);
    freq.put("јј", 31);
    freq.put("јџ", 10);
    freq.put("јќ", 53);
    freq.put("њ", 871);
    freq.put("ан ", 289);
    freq.put("сè", 12);
    freq.put("сув", 43);
    freq.put("суб", 8);
    freq.put("суа", 16);
    freq.put("суз", 5);
    freq.put("суд", 68);
    freq.put("суп", 25);
    freq.put("сун", 6);
    freq.put("сум", 273);
    freq.put("апч", 8);
    freq.put("апт", 10);
    freq.put("апу", 29);
    freq.put("апр", 155);
    freq.put("апс", 26);
    freq.put("ФБ ", 10);
    freq.put("с ", 978);
    freq.put("бни", 16);
    freq.put(" Цр", 12);
    freq.put("апо", 67);
    freq.put("апн", 20);
    freq.put("апк", 17);
    freq.put("апл", 45);
    freq.put("апи", 77);
    freq.put("апе", 30);
    freq.put("апа", 117);
    freq.put("рин", 78);
    freq.put("тна", 99);
    freq.put("ајј", 11);
    freq.put("ајќ", 13);
    freq.put("тни", 122);
    freq.put("тно", 143);
    freq.put("ајш", 6);
    freq.put("ају", 37);
    freq.put("пје", 102);
    freq.put("ајс", 45);
    freq.put("ајр", 8);
    freq.put("пја", 13);
    freq.put("ајц", 37);
    freq.put("Збо", 5);
    freq.put("нри", 5);
    freq.put("ајл", 75);
    freq.put("ајк", 103);
    freq.put("аји", 7);
    freq.put("ајп", 14);
    freq.put("ајо", 34);
    freq.put("ајн", 117);
    freq.put("ајм", 66);
    freq.put("ајг", 38);
    freq.put("ајв", 31);
    freq.put("ајб", 26);
    freq.put("аја", 74);
    freq.put("оп ", 53);
    freq.put("аје", 9);
    freq.put("ајд", 175);
    freq.put("оји", 6);
    freq.put("тл ", 5);
    freq.put("удр", 21);
    freq.put("удс", 8);
    freq.put("ашт", 66);
    freq.put("ддр", 19);
    freq.put("уде", 62);
    freq.put("уда", 91);
    freq.put("удб", 59);
    freq.put("удн", 25);
    freq.put("удо", 37);
    freq.put("уди", 87);
    freq.put("јно", 42);
    freq.put("јни", 39);
    freq.put("цар", 14);
    freq.put("цат", 46);
    freq.put("јне", 9);
    freq.put("јна", 34);
    freq.put("цај", 6);
    freq.put("џел", 6);
    freq.put("џем", 5);
    freq.put(" Љу", 20);
    freq.put("Ж ", 27);
    freq.put("гро", 23);
    freq.put("АД ", 22);
    freq.put("гра", 445);
    freq.put("џет", 6);
    freq.put("џер", 18);
    freq.put("Дод", 19);
    freq.put("Доб", 90);
    freq.put("Дон", 5);
    freq.put("Дом", 15);
    freq.put("Дол", 8);
    freq.put("Док", 12);
    freq.put("Дос", 8);
    freq.put("Дор", 5);
    freq.put("Вла", 32);
    freq.put("Дој", 7);
    freq.put("Мер", 13);
    freq.put("Мес", 15);
    freq.put("Мет", 23);
    freq.put("Меѓ", 6);
    freq.put("Мед", 10);
    freq.put("Мек", 12);
    freq.put("Мел", 6);
    freq.put("Мен", 23);
    freq.put("цр", 73);
    freq.put("сни", 163);
    freq.put("сно", 112);
    freq.put("сна", 117);
    freq.put("сне", 69);
    freq.put("уфо", 5);
    freq.put("Ла", 48);
    freq.put("Ле", 71);
    freq.put("уфи", 12);
    freq.put("Ли", 57);
    freq.put("Ло", 40);
    freq.put("уѓи", 5);
    freq.put("еир", 11);
    freq.put("еис", 8);
    freq.put("уѓе", 89);
    freq.put("вце", 7);
    freq.put("еим", 5);
    freq.put("вци", 35);
    freq.put("Лу", 30);
    freq.put("Бри", 12);
    freq.put("Бро", 8);
    freq.put("Бра", 45);
    freq.put("Бре", 11);
    freq.put("ра ", 620);
    freq.put("ТВ ", 25);
    freq.put("анф", 6);
    freq.put("анц", 80);
    freq.put("анч", 31);
    freq.put("анс", 150);
    freq.put("ант", 109);
    freq.put("ану", 64);
    freq.put("Слу", 13);
    freq.put("анџ", 11);
    freq.put("ј ", 1494);
    freq.put("еж ", 6);
    freq.put("су ", 11);
    freq.put("анд", 97);
    freq.put("ане", 141);
    freq.put("анз", 9);
    freq.put("ана", 354);
    freq.put("Сло", 20);
    freq.put("анг", 35);
    freq.put("ано", 216);
    freq.put("Сла", 7);
    freq.put("ани", 436);
    freq.put("Сле", 10);
    freq.put("сб", 32);
    freq.put("са", 1019);
    freq.put("св", 391);
    freq.put("се", 3065);
    freq.put("сд", 7);
    freq.put("си", 1300);
    freq.put("сл", 951);
    freq.put("ск", 1581);
    freq.put("сн", 468);
    freq.put("см", 370);
    freq.put("сп", 622);
    freq.put("со", 1506);
    freq.put("сс", 15);
    freq.put("ср", 200);
    freq.put("су", 503);
    freq.put("ст", 2994);
    freq.put("сх", 10);
    freq.put("сф", 41);
    freq.put("сч", 15);
    freq.put("сц", 26);
    freq.put("сѐ", 7);
    freq.put("сј", 5);
    freq.put("ап ", 26);
    freq.put("ЛИ ", 7);
    freq.put("кец", 5);
    freq.put("едв", 20);
    freq.put("еда", 354);
    freq.put("едб", 23);
    freq.put("еде", 332);
    freq.put("едл", 26);
    freq.put("еди", 202);
    freq.put("едо", 367);
    freq.put("едм", 17);
    freq.put("едн", 466);
    freq.put("ца", 397);
    freq.put("едр", 6);
    freq.put("едс", 22);
    freq.put("це", 451);
    freq.put("Спа", 9);
    freq.put("Од ", 66);
    freq.put("Спи", 8);
    freq.put("ци", 1118);
    freq.put("ИЕ ", 7);
    freq.put("цо", 49);
    freq.put("гу", 380);
    freq.put("гр", 659);
    freq.put("Осв", 10);
    freq.put("Алу", 7);
    freq.put("Алф", 8);
    freq.put("Оск", 8);
    freq.put("Осо", 13);
    freq.put("Ита", 7);
    freq.put("Еко", 6);
    freq.put("Фра", 16);
    freq.put("Фри", 5);
    freq.put("Не ", 187);
    freq.put("Екс", 33);
    freq.put("Ост", 13);
    freq.put("Ала", 7);
    freq.put("Алб", 12);
    freq.put("Але", 15);
    freq.put("Али", 8);
    freq.put("Ало", 12);
    freq.put("гл", 580);
    freq.put("ги", 682);
    freq.put("го", 1771);
    freq.put("гн", 157);
    freq.put("гв", 5);
    freq.put("гб", 5);
    freq.put("га", 1227);
    freq.put("гз", 8);
    freq.put("ге", 134);
    freq.put("гд", 27);
    freq.put("он ", 223);
    freq.put("огр", 121);
    freq.put("огу", 200);
    freq.put(" вч", 32);
    freq.put(" вс", 15);
    freq.put(" вр", 370);
    freq.put(" ву", 10);
    freq.put(" вт", 42);
    freq.put(" ве", 412);
    freq.put(" ва", 250);
    freq.put(" вн", 18);
    freq.put(" вм", 8);
    freq.put(" во", 1525);
    freq.put(" ви", 646);
    freq.put(" вл", 121);
    freq.put(" вк", 30);
    freq.put("цу ", 7);
    freq.put("оги", 33);
    freq.put("огл", 80);
    freq.put("огн", 34);
    freq.put("ого", 154);
    freq.put("ога", 493);
    freq.put("огб", 5);
    freq.put("оге", 7);
    freq.put("М ", 74);
    freq.put("ЕП ", 7);
    freq.put("љу", 90);
    freq.put("мфа", 6);
    freq.put("изи", 113);
    freq.put("љи", 17);
    freq.put("љк", 5);
    freq.put("љо", 17);
    freq.put("ља", 66);
    freq.put("ље", 23);
    freq.put("љд", 12);
    freq.put("цки", 38);
    freq.put("цка", 21);
    freq.put("уш ", 7);
    freq.put("да ", 2543);
    freq.put("рте", 22);
    freq.put("д", 14484);
    freq.put("ртв", 16);
    freq.put("ртн", 16);
    freq.put("рто", 36);
    freq.put("рти", 117);
    freq.put("Иде", 8);
    freq.put("ртс", 8);
    freq.put("вск", 157);
    freq.put("рту", 18);
    freq.put("ртт", 5);
    freq.put("јго", 20);
    freq.put("Иди", 7);
    freq.put("ил ", 183);
    freq.put("Па ", 44);
    freq.put("Цар", 5);
    freq.put("оу ", 19);
    freq.put("ир ", 65);
    freq.put("љуб", 76);
    freq.put("лаа", 13);
    freq.put("дви", 22);
    freq.put("лав", 142);
    freq.put("лаг", 81);
    freq.put("лад", 155);
    freq.put("лаж", 54);
    freq.put("лаз", 8);
    freq.put("инф", 35);
    freq.put("два", 88);
    freq.put("инц", 24);
    freq.put("лал", 9);
    freq.put("две", 64);
    freq.put("инс", 115);
    freq.put("инт", 172);
    freq.put("лап", 17);
    freq.put("лар", 54);
    freq.put("лас", 136);
    freq.put("ино", 120);
    freq.put("ини", 326);
    freq.put("лац", 27);
    freq.put("лач", 40);
    freq.put("лаш", 23);
    freq.put("двр", 6);
    freq.put("ина", 623);
    freq.put("инб", 7);
    freq.put("инв", 15);
    freq.put("инг", 92);
    freq.put("лај", 62);
    freq.put("лањ", 7);
    freq.put("лаќ", 13);
    freq.put("Еди", 9);
    freq.put("осв", 65);
    freq.put("оса", 76);
    freq.put("ито", 104);
    freq.put("ити", 137);
    freq.put("итл", 5);
    freq.put("итк", 30);
    freq.put("оск", 57);
    freq.put("осл", 186);
    freq.put("оси", 53);
    freq.put("Њ", 13);
    freq.put("осо", 57);
    freq.put("осп", 48);
    freq.put("осм", 13);
    freq.put("итв", 14);
    freq.put("пеш", 44);
    freq.put("пет", 71);
    freq.put("пес", 93);
    freq.put("пер", 144);
    freq.put("печ", 11);
    freq.put("пец", 11);
    freq.put("пех", 13);
    freq.put("Уда", 5);
    freq.put(" Џо", 28);
    freq.put(" Џе", 22);
    freq.put(" Џа", 21);
    freq.put("ТА ", 19);
    freq.put("ќа ", 77);
    freq.put("пел", 16);
    freq.put("пек", 21);
    freq.put("пеп", 7);
    freq.put("пен", 69);
    freq.put("пев", 8);
    freq.put("пеа", 20);
    freq.put("пее", 36);
    freq.put("пед", 32);
    freq.put("ост", 648);
    freq.put("осу", 24);
    freq.put("оср", 5);
    freq.put("рв ", 31);
    freq.put("осф", 8);
    freq.put("итс", 6);
    freq.put("итр", 17);
    freq.put("иту", 75);
    freq.put("Сва", 7);
    freq.put("ча ", 34);
    freq.put("аже", 79);
    freq.put("Све", 40);
    freq.put("рџи", 46);
    freq.put("ажо", 8);
    freq.put("рдо", 18);
    freq.put("рдн", 10);
    freq.put("рди", 37);
    freq.put("рде", 15);
    freq.put("рда", 44);
    freq.put("НА ", 38);
    freq.put("ед ", 242);
    freq.put("а", 53843);
    freq.put("Оди", 7);
    freq.put("Одл", 12);
    freq.put("Одн", 5);
    freq.put("Ода", 7);
    freq.put("онц", 78);
    freq.put("онч", 24);
    freq.put("онф", 16);
    freq.put("онт", 72);
    freq.put("ону", 32);
    freq.put("онс", 136);
    freq.put("ВИ ", 8);
    freq.put(" ај", 111);
    freq.put("Неш", 9);
    freq.put(" ау", 30);
    freq.put(" ат", 22);
    freq.put(" ас", 19);
    freq.put(" ар", 37);
    freq.put(" ах", 18);
    freq.put(" аф", 6);
    freq.put(" аг", 15);
    freq.put(" ав", 99);
    freq.put(" аб", 49);
    freq.put(" аа", 13);
    freq.put(" аз", 7);
    freq.put(" ае", 15);
    freq.put(" ад", 23);
    freq.put(" ал", 115);
    freq.put(" ак", 287);
    freq.put(" ап", 90);
    freq.put(" ан", 76);
    freq.put("ор ", 248);
    freq.put("Нед", 14);
    freq.put("Неа", 5);
    freq.put("Нег", 9);
    freq.put("Нев", 9);
    freq.put("Нем", 56);
    freq.put("Нео", 5);
    freq.put("Нел", 6);
    freq.put("Нек", 45);
    freq.put("онз", 13);
    freq.put("онд", 43);
    freq.put("оне", 154);
    freq.put("онг", 9);
    freq.put("она", 230);
    freq.put("оно", 80);
    freq.put("онк", 34);
    freq.put("онл", 7);
    freq.put("они", 345);
    freq.put("г ", 268);
    freq.put("Му", 41);
    freq.put("Мр", 14);
    freq.put("Зна", 49);
    freq.put("цур", 5);
    freq.put("цус", 6);
    freq.put("аќе", 10);
    freq.put(" в ", 33);
    freq.put("аќа", 101);
    freq.put("аќи", 17);
    freq.put("Ме", 131);
    freq.put("Ма", 461);
    freq.put("Мо", 128);
    freq.put("Мн", 34);
    freq.put("Мл", 6);
    freq.put("Ми", 162);
    freq.put("ог ", 57);
    freq.put("зда", 34);
    freq.put("зде", 10);
    freq.put("зди", 20);
    freq.put("здо", 6);
    freq.put("ром", 103);
    freq.put("ррр", 6);
    freq.put("јбо", 13);
    freq.put("јба", 12);
    freq.put("Ива", 21);
    freq.put("ита", 239);
    freq.put("здр", 78);
    freq.put("зду", 18);
    freq.put("тф", 8);
    freq.put("тх", 7);
    freq.put("тц", 5);
    freq.put("тч", 18);
    freq.put("тр", 1216);
    freq.put("ЕН ", 15);
    freq.put("Пат", 10);
    freq.put("ту", 549);
    freq.put("Пај", 6);
    freq.put("илј", 12);
    freq.put("рт ", 77);
    freq.put("уша", 128);
    freq.put("даж", 14);
    freq.put("дае", 8);
    freq.put("дад", 68);
    freq.put("дав", 128);
    freq.put("даа", 29);
    freq.put("илт", 8);
    freq.put("илу", 14);
    freq.put("ушк", 25);
    freq.put("дам", 242);
    freq.put("дал", 164);
    freq.put("ушн", 27);
    freq.put("дач", 18);
    freq.put("дац", 8);
    freq.put("или", 364);
    freq.put("ило", 92);
    freq.put("дат", 200);
    freq.put("дас", 7);
    freq.put("дар", 97);
    freq.put("ила", 145);
    freq.put("илд", 5);
    freq.put("иле", 194);
    freq.put("дањ", 10);
    freq.put("дај", 69);
    freq.put("тд", 7);
    freq.put("те", 4615);
    freq.put("Паз", 10);
    freq.put("та", 3889);
    freq.put("тв", 896);
    freq.put("тг", 6);
    freq.put("тм", 24);
    freq.put("Пан", 17);
    freq.put("то", 3889);
    freq.put("Пап", 6);
    freq.put("ти", 2677);
    freq.put("тк", 318);
    freq.put("Пал", 6);
    freq.put("ирк", 20);
    freq.put("ири", 96);
    freq.put("иро", 53);
    freq.put("ирн", 16);
    freq.put("ирм", 13);
    freq.put("ира", 592);
    freq.put("ире", 49);
    freq.put("кен", 30);
    freq.put("плу", 17);
    freq.put("оум", 7);
    freq.put("оуб", 17);
    freq.put("оуд", 5);
    freq.put("ла ", 590);
    freq.put("ч", 3391);
    freq.put("ин ", 138);
    freq.put("пла", 192);
    freq.put("пле", 49);
    freq.put("пли", 64);
    freq.put("пло", 50);
    freq.put("иру", 14);
    freq.put("ирч", 9);
    freq.put("рвј", 8);
    freq.put("ос ", 58);
    freq.put("ит ", 108);
    freq.put("ќаш", 9);
    freq.put("ќат", 17);
    freq.put("ќањ", 5);
    freq.put("ќај", 17);
    freq.put("ожа", 107);
    freq.put("ќам", 43);
    freq.put("ќав", 12);
    freq.put("ќаа", 14);
    freq.put("СТ ", 9);
    freq.put("рва", 89);
    freq.put("рво", 36);
    freq.put("рви", 71);
    freq.put("пе ", 16);
    freq.put("чам", 53);
    freq.put("чан", 40);
    freq.put("чао", 8);
    freq.put("чак", 24);
    freq.put("чал", 20);
    freq.put("чаа", 7);
    freq.put("чав", 5);
    freq.put("втр", 11);
    freq.put("вто", 143);
    freq.put("вти", 9);
    freq.put("вте", 47);
    freq.put("ТО ", 50);
    freq.put("вта", 7);
    freq.put("чаш", 17);
    freq.put("чар", 50);
    freq.put("час", 44);
    freq.put("чат", 42);
    freq.put("чај", 54);
    freq.put("чањ", 6);
    freq.put("ссн", 7);
    freq.put("рд ", 23);
    freq.put("Мра", 11);
    freq.put("Тук", 9);
    freq.put("ржу", 13);
    freq.put("Н ", 43);
    freq.put("и", 31373);
    freq.put("Мно", 34);
    freq.put("Чел", 14);
    freq.put("рже", 18);
    freq.put("бве", 5);
    freq.put("гас", 25);
    freq.put("бви", 11);
    freq.put("ржи", 20);
    freq.put("ело", 129);
    freq.put("еч ", 7);
    freq.put("Тур", 15);
    freq.put("А ", 389);
    freq.put("НО ", 25);
    freq.put("ехх", 7);
    freq.put("ели", 301);
    freq.put("Фин", 7);
    freq.put("елз", 10);
    freq.put("гам", 22);
    freq.put("ев ", 137);
    freq.put("елг", 12);
    freq.put(" љу", 64);
    freq.put("њо", 18);
    freq.put("њи", 13);
    freq.put("елб", 22);
    freq.put("ње", 611);
    freq.put("ња", 213);
    freq.put("Раб", 13);
    freq.put("Раз", 9);
    freq.put("Рад", 14);
    freq.put("Рак", 9);
    freq.put("њу", 5);
    freq.put("схе", 7);
    freq.put("ехн", 9);
    freq.put("ехо", 7);
    freq.put("ехе", 21);
    freq.put("еха", 5);
    freq.put("еам", 63);
    freq.put("еан", 16);
    freq.put("еак", 6);
    freq.put("еал", 56);
    freq.put("еав", 12);
    freq.put("еаг", 9);
    freq.put("Држ", 8);
    freq.put("Дра", 25);
    freq.put("Дро", 7);
    freq.put("еат", 48);
    freq.put("еар", 5);
    freq.put("дбе", 17);
    freq.put("ако", 921);
    freq.put("Џок", 5);
    freq.put("об ", 8);
    freq.put("Џол", 5);
    freq.put("Охр", 17);
    freq.put(" д ", 18);
    freq.put("оњ ", 9);
    freq.put("озј", 5);
    freq.put("озд", 49);
    freq.put("озе", 29);
    freq.put("СИ ", 5);
    freq.put("ар ", 312);
    freq.put("оза", 76);
    freq.put("озб", 21);
    freq.put("озв", 23);
    freq.put("озм", 5);
    freq.put("озн", 115);
    freq.put("озо", 32);
    freq.put("ози", 61);
    freq.put("елч", 6);
    freq.put("елф", 5);
    freq.put("Зла", 9);
    freq.put("ЕЛ ", 6);
    freq.put("оје", 6);
    freq.put("ојд", 94);
    freq.put("ојз", 6);
    freq.put("ојб", 10);
    freq.put("оја", 305);
    freq.put("ојн", 34);
    freq.put("ојм", 10);
    freq.put("ојо", 56);
    freq.put("за ", 1657);
    freq.put("ци ", 315);
    freq.put("ојк", 65);
    freq.put("њет", 76);
    freq.put(" жа", 33);
    freq.put("атч", 9);
    freq.put("атс", 32);
    freq.put("атр", 33);
    freq.put("ату", 77);
    freq.put(" жи", 191);
    freq.put(" жо", 6);
    freq.put("ате", 406);
    freq.put(" жр", 9);
    freq.put(" жу", 19);
    freq.put("ата", 1517);
    freq.put("атв", 37);
    freq.put("атн", 91);
    freq.put("атм", 7);
    freq.put("атп", 24);
    freq.put("ато", 242);
    freq.put("ати", 370);
    freq.put("атл", 13);
    freq.put("атк", 67);
    freq.put("је ", 198);
    freq.put("АК ", 5);
    freq.put("мро", 9);
    freq.put("ојч", 20);
    freq.put("ојц", 7);
    freq.put("ојс", 9);
    freq.put("њеЗ", 20);
    freq.put("оју", 11);
    freq.put("ојт", 12);
    freq.put("мрз", 19);
    freq.put("мре", 22);
    freq.put("мрд", 10);
    freq.put("мра", 32);
    freq.put("ојќ", 7);
    freq.put("зву", 18);
    freq.put("звр", 15);
    freq.put("бј", 46);
    freq.put("бс", 9);
    freq.put("бр", 734);
    freq.put("бу", 280);
    freq.put("иш ", 238);
    freq.put("гла", 155);
    freq.put("гло", 7);
    freq.put("гли", 23);
    freq.put("рца", 6);
    freq.put("рце", 36);
    freq.put("рци", 62);
    freq.put("јбе", 7);
    freq.put("Шут", 6);
    freq.put("клу", 69);
    freq.put("кло", 27);
    freq.put("јзн", 5);
    freq.put("кли", 33);
    freq.put("јзи", 9);
    freq.put("кле", 19);
    freq.put("јзе", 6);
    freq.put("кла", 91);
    freq.put("јзб", 7);
    freq.put("ба", 1330);
    freq.put("бг", 6);
    freq.put("Баб", 9);
    freq.put("бе", 1204);
    freq.put("глу", 55);
    freq.put("би", 1060);
    freq.put("бл", 234);
    freq.put("бн", 47);
    freq.put("бо", 940);
    freq.put("зве", 29);
    freq.put(" Со", 106);
    freq.put("зва", 20);
    freq.put("зво", 58);
    freq.put(" Сп", 54);
    freq.put("зви", 38);
    freq.put("кфа", 5);
    freq.put("Х", 172);
    freq.put("ип ", 40);
    freq.put(" Б ", 7);
    freq.put("лдо", 7);
    freq.put("лде", 5);
    freq.put("Бар", 53);
    freq.put("д ", 1898);
    freq.put("иф ", 8);
    freq.put("Ко ", 11);
    freq.put("ечу", 8);
    freq.put("учо", 6);
    freq.put("уча", 59);
    freq.put("Пар", 37);
    freq.put("тс", 169);
    freq.put("Не", 379);
    freq.put("Фе", 39);
    freq.put("тт", 24);
    freq.put("Пау", 5);
    freq.put("Ни", 104);
    freq.put("Фа", 68);
    freq.put("Ну", 7);
    freq.put("ечк", 82);
    freq.put("ечи", 36);
    freq.put("ечн", 58);
    freq.put("счи", 6);
    freq.put("сче", 8);
    freq.put("еча", 40);
    freq.put("ече", 194);
    freq.put("аБ", 6);
    freq.put("аЕ", 21);
    freq.put("аН", 7);
    freq.put("аЈ", 5);
    freq.put("ав", 2179);
    freq.put("аг", 377);
    freq.put("аа", 1080);
    freq.put("аб", 779);
    freq.put("аж", 411);
    freq.put("аз", 551);
    freq.put("ад", 1276);
    freq.put("ае", 362);
    freq.put("ак", 2563);
    freq.put("ал", 2048);
    freq.put("аи", 122);
    freq.put("ао", 99);
    freq.put("ап", 635);
    freq.put("ам", 3671);
    freq.put("ан", 2160);
    freq.put("аТ", 5);
    freq.put("еве", 120);
    freq.put("аС", 5);
    freq.put("вре", 224);
    freq.put("врд", 22);
    freq.put("врз", 22);
    freq.put("евм", 13);
    freq.put("евн", 25);
    freq.put("ево", 164);
    freq.put("мди", 6);
    freq.put("врн", 11);
    freq.put("евк", 9);
    freq.put("вро", 110);
    freq.put("врс", 40);
    freq.put("аѓ", 97);
    freq.put("вру", 8);
    freq.put("евч", 8);
    freq.put("евр", 114);
    freq.put("евс", 70);
    freq.put("евт", 16);
    freq.put("еву", 5);
    freq.put("ањ", 495);
    freq.put("врш", 67);
    freq.put("ај", 1743);
    freq.put("аљ", 44);
    freq.put("аџ", 19);
    freq.put("аќ", 131);
    freq.put("ат", 4172);
    freq.put("ау", 120);
    freq.put("ар", 2132);
    freq.put("ас", 1240);
    freq.put("ац", 347);
    freq.put("ач", 554);
    freq.put("аф", 173);
    freq.put("ах", 323);
    freq.put("аш", 1286);
    freq.put("Сне", 13);
    freq.put("ех ", 13);
    freq.put("Оче", 5);
    freq.put("Оча", 6);
    freq.put("Ант", 18);
    freq.put("еа ", 194);
    freq.put("Анџ", 6);
    freq.put("уше", 24);
    freq.put("ЛО ", 7);
    freq.put("Анд", 14);
    freq.put("уши", 39);
    freq.put("Ана", 16);
    freq.put("Анг", 12);
    freq.put("дан", 46);
    freq.put("илс", 14);
    freq.put("дак", 12);
    freq.put(" њ", 10);
    freq.put("илк", 10);
    freq.put("ушт", 265);
    freq.put("С", 1316);
    freq.put("обу", 43);
    freq.put("обр", 350);
    freq.put("обс", 5);
    freq.put("илм", 71);
    freq.put("илн", 59);
    freq.put("обј", 41);
    freq.put(" ду", 126);
    freq.put(" др", 346);
    freq.put(" до", 1073);
    freq.put(" дн", 16);
    freq.put(" дл", 10);
    freq.put(" ди", 169);
    freq.put(" де", 1242);
    freq.put(" дв", 156);
    freq.put(" да", 2554);
    freq.put("обв", 12);
    freq.put("оба", 156);
    freq.put("обе", 110);
    freq.put("обл", 91);
    freq.put("оби", 206);
    freq.put("даш", 30);
    freq.put("обо", 77);
    freq.put("обн", 10);
    freq.put("оња", 6);
    freq.put("жур", 22);
    freq.put("арј", 5);
    freq.put("ару", 25);
    freq.put("арт", 155);
    freq.put("арс", 83);
    freq.put("арч", 18);
    freq.put("арц", 19);
    freq.put("арх", 14);
    freq.put("арф", 7);
    freq.put("арш", 17);
    freq.put("ншт", 7);
    freq.put("арг", 9);
    freq.put("арб", 8);
    freq.put("ара", 425);
    freq.put("оз ", 16);
    freq.put("аре", 126);
    freq.put("ард", 67);
    freq.put("арл", 27);
    freq.put("арк", 135);
    freq.put("ари", 382);
    freq.put("арп", 14);
    freq.put("аро", 138);
    freq.put("арн", 104);
    freq.put("арм", 26);
    freq.put("жув", 87);
    freq.put("ег ", 39);
    freq.put("мци", 10);
    freq.put("цин", 13);
    freq.put("зан", 37);
    freq.put("цип", 7);
    freq.put("цио", 41);
    freq.put("заи", 9);
    freq.put("ции", 84);
    freq.put("зак", 60);
    freq.put("Џон", 12);
    freq.put("цие", 5);
    freq.put("зае", 60);
    freq.put("циз", 5);
    freq.put("заб", 95);
    freq.put("зав", 96);
    freq.put("заг", 44);
    freq.put("рфо", 5);
    freq.put("јер", 5);
    freq.put("јет", 8);
    freq.put("рфи", 5);
    freq.put("кну", 25);
    freq.put("јед", 15);
    freq.put("кни", 47);
    freq.put("јеб", 15);
    freq.put("јев", 7);
    freq.put("кна", 41);
    freq.put("јек", 9);
    freq.put("кне", 22);
    freq.put("ње ", 486);
    freq.put("СО ", 13);
    freq.put("ат ", 1221);
    freq.put("тн", 386);
    freq.put("тп", 67);
    freq.put("зај", 25);
    freq.put("заљ", 5);
    freq.put("заш", 45);
    freq.put("зац", 34);
    freq.put("зач", 13);
    freq.put("цис", 17);
    freq.put("зас", 54);
    freq.put("зат", 125);
    freq.put("цит", 112);
    freq.put("кци", 76);
    freq.put("гл ", 16);
    freq.put("Гул", 9);
    freq.put("рц ", 5);
    freq.put("лве", 9);
    freq.put("МК ", 12);
    freq.put("кл ", 8);
    freq.put("цо ", 5);
    freq.put("б ", 122);
    freq.put("оче", 72);
    freq.put("оча", 61);
    freq.put("ифт", 9);
    freq.put(" хр", 23);
    freq.put("Кој", 71);
    freq.put("очи", 128);
    freq.put("очк", 29);
    freq.put("Кос", 17);
    freq.put("Кор", 6);
    freq.put("Коц", 8);
    freq.put("до", 2013);
    freq.put("дп", 9);
    freq.put("дм", 105);
    freq.put("дн", 831);
    freq.put("дк", 8);
    freq.put(" Бе", 85);
    freq.put("ди", 1347);
    freq.put("АМ ", 12);
    freq.put(" Би", 83);
    freq.put("дз", 21);
    freq.put("дд", 27);
    freq.put("де", 2863);
    freq.put("дв", 250);
    freq.put("дг", 61);
    freq.put(" Бо", 84);
    freq.put("дб", 142);
    freq.put("ипе", 21);
    freq.put("ипа", 40);
    freq.put("ипо", 34);
    freq.put("ипл", 19);
    freq.put("ипи", 19);
    freq.put("ипу", 7);
    freq.put("дј", 7);
    freq.put("ипс", 11);
    freq.put(" Бр", 75);
    freq.put(" Бу", 50);
    freq.put("дц", 8);
    freq.put("ду", 313);
    freq.put("др", 633);
    freq.put("дс", 71);
    freq.put("Ког", 59);
    freq.put("Кол", 50);
    freq.put("Кок", 10);
    freq.put("Кои", 5);
    freq.put("Кон", 22);
    freq.put("Ком", 20);
    freq.put("ифа", 9);
    freq.put("ифи", 23);
    freq.put("кту", 32);
    freq.put("Да ", 129);
    freq.put(" ру", 47);
    freq.put("урк", 19);
    freq.put("лже", 6);
    freq.put("урм", 6);
    freq.put("урн", 59);
    freq.put("лжа", 5);
    freq.put("ура", 96);
    freq.put("урб", 14);
    freq.put("урв", 14);
    freq.put("ург", 24);
    freq.put("уре", 46);
    freq.put("лжи", 17);
    freq.put(" Ши", 20);
    freq.put(" Г ", 8);
    freq.put(" ра", 675);
    freq.put("лжу", 15);
    freq.put(" ре", 392);
    freq.put("урс", 51);
    freq.put("урт", 7);
    freq.put("уру", 7);
    freq.put(" ?", 6);
    freq.put("урц", 12);
    freq.put("урч", 7);
    freq.put("иц ", 21);
    freq.put("кте", 32);
    freq.put("кта", 9);
    freq.put("кто", 80);
    freq.put("ктн", 14);
    freq.put("кти", 67);
    freq.put("Два", 12);
    freq.put("Две", 7);
    freq.put(" Ем", 8);
    freq.put(" Ен", 14);
    freq.put("ига", 88);
    freq.put(" Еп", 19);
    freq.put(" Ек", 23);
    freq.put("иге", 7);
    freq.put(" Ед", 56);
    freq.put(" Ее", 5);
    freq.put("иги", 38);
    freq.put("иго", 13);
    freq.put(" Ев", 101);
    freq.put("игн", 59);
    freq.put(" Еј", 27);
    freq.put("ба ", 332);
    freq.put("ри ", 645);
    freq.put("игу", 44);
    freq.put("ѓ", 302);
    freq.put(" Еф", 5);
    freq.put(" Ер", 6);
    freq.put(" Ес", 7);
    freq.put(" Ет", 8);
    freq.put(" Еу", 5);
    freq.put("ија", 1507);
    freq.put("ије", 29);
    freq.put("ијо", 12);
    freq.put("буг", 6);
    freq.put("був", 23);
    freq.put("буб", 6);
    freq.put("буд", 42);
    freq.put("бул", 12);
    freq.put("бук", 63);
    freq.put("бун", 17);
    freq.put("бум", 14);
    freq.put("Ќе", 79);
    freq.put("рку", 11);
    freq.put("ркн", 6);
    freq.put("рко", 39);
    freq.put("рки", 49);
    freq.put("аци", 283);
    freq.put("рке", 30);
    freq.put("ље ", 19);
    freq.put("рка", 143);
    freq.put("ркв", 18);
    freq.put("чо ", 14);
    freq.put("буј", 9);
    freq.put("бут", 12);
    freq.put("бус", 26);
    freq.put("бур", 34);
    freq.put("оус", 5);
    freq.put("чис", 45);
    freq.put("чит", 150);
    freq.put("чиш", 21);
    freq.put("чиќ", 5);
    freq.put("еср", 9);
    freq.put("есу", 32);
    freq.put("ест", 430);
    freq.put("чиј", 7);
    freq.put("чињ", 56);
    freq.put("ма ", 1171);
    freq.put("еси", 107);
    freq.put("есл", 10);
    freq.put("еск", 88);
    freq.put("есн", 193);
    freq.put("есм", 22);
    freq.put("есп", 29);
    freq.put("есо", 47);
    freq.put("еса", 40);
    freq.put("есе", 145);
    freq.put("чиз", 5);
    freq.put("чив", 14);
    freq.put("чиг", 13);
    freq.put("чим", 18);
    freq.put("чин", 95);
    freq.put("чии", 7);
    freq.put("чик", 6);
    freq.put("чил", 26);
    freq.put("вд", 38);
    freq.put("ве", 1814);
    freq.put("ва", 3360);
    freq.put("вг", 15);
    freq.put("вм", 98);
    freq.put("вн", 346);
    freq.put("во", 3139);
    freq.put("вп", 7);
    freq.put("ви", 2393);
    freq.put("вк", 94);
    freq.put("вл", 147);
    freq.put("нџи", 5);
    freq.put("нџа", 9);
    freq.put("вј", 34);
    freq.put("вљ", 9);
    freq.put("нџе", 10);
    freq.put("АС ", 13);
    freq.put("мвр", 17);
    freq.put("вц", 43);
    freq.put("вч", 65);
    freq.put("вр", 781);
    freq.put("вс", 226);
    freq.put("вт", 220);
    freq.put("ву", 134);
    freq.put("вш", 8);
    freq.put("е ", 14674);
    freq.put("Еве", 34);
    freq.put("ое ", 76);
    freq.put("Евр", 60);
    freq.put("ш ", 1166);
    freq.put("езг", 6);
    freq.put("Ајм", 6);
    freq.put("Ајд", 30);
    freq.put(" и ", 1924);
    freq.put("СМ ", 15);
    freq.put("аф ", 5);
    freq.put("оќа", 7);
    freq.put("оќе", 13);
    freq.put("жав", 81);
    freq.put("жан", 22);
    freq.put("жам", 136);
    freq.put("уте", 44);
    freq.put("оќн", 7);
    freq.put("жал", 50);
    freq.put("фле", 9);
    freq.put("фла", 5);
    freq.put("ути", 69);
    freq.put("нд ", 51);
    freq.put(" кн", 31);
    freq.put(" ко", 1398);
    freq.put(" ки", 77);
    freq.put(" кл", 76);
    freq.put(" ке", 69);
    freq.put(" кд", 6);
    freq.put("утн", 18);
    freq.put(" ка", 1154);
    freq.put(" кв", 24);
    freq.put("Јов", 7);
    freq.put(" кр", 260);
    freq.put(" ку", 223);
    freq.put("шно", 46);
    freq.put("шни", 74);
    freq.put("шне", 6);
    freq.put("шна", 69);
    freq.put("лин", 113);
    freq.put("лио", 70);
    freq.put("оќт", 9);
    freq.put("жар", 9);
    freq.put("жат", 49);
    freq.put("шшш", 8);
    freq.put("охо", 14);
    freq.put("лиг", 31);
    freq.put("охи", 7);
    freq.put("ицу", 5);
    freq.put("оха", 6);
    freq.put("Дан", 9);
    freq.put("Дам", 6);
    freq.put("Дал", 52);
    freq.put(" т", 3348);
    freq.put(" Гл", 37);
    freq.put(" Ги", 23);
    freq.put(" с", 8034);
    freq.put(" Го", 101);
    freq.put(" ч", 614);
    freq.put(" ф", 765);
    freq.put(" х", 358);
    freq.put(" Гв", 9);
    freq.put(" Га", 25);
    freq.put(" Ге", 25);
    freq.put("иби", 13);
    freq.put(" ѓ", 10);
    freq.put("ибл", 10);
    freq.put("ибо", 5);
    freq.put(" ѕ", 30);
    freq.put("иба", 20);
    freq.put(" ј", 1076);
    freq.put(" љ", 64);
    freq.put("ибе", 13);
    freq.put(" ќ", 954);
    freq.put(" Т", 577);
    freq.put("рве", 42);
    freq.put(" Р", 323);
    freq.put(" р ", 7);
    freq.put(" Ц", 90);
    freq.put(" Ч", 165);
    freq.put(" Ф", 277);
    freq.put(" Х", 169);
    freq.put("ибр", 7);
    freq.put(" Ш", 244);
    freq.put(" в", 3534);
    freq.put(" г", 2389);
    freq.put(" а", 1736);
    freq.put(" б", 2060);
    freq.put(" ж", 420);
    freq.put(" з", 3243);
    freq.put(" д", 5728);
    freq.put(" е", 2440);
    freq.put(" к", 3349);
    freq.put(" Гу", 21);
    freq.put(" Гр", 94);
    freq.put(" о", 3085);
    freq.put(" п", 6148);
    freq.put(" м", 3768);
    freq.put(" н", 7763);
    freq.put(" Ѓ", 12);
    freq.put(" Ѕ", 13);
    freq.put(" Њ", 10);
    freq.put(" Ј", 267);
    freq.put(" Љ", 24);
    freq.put(" Џ", 80);
    freq.put(" Ќ", 85);
    freq.put(" В", 652);
    freq.put("ици", 264);
    freq.put(" А", 844);
    freq.put("ицк", 38);
    freq.put(" Ж", 87);
    freq.put(" З", 393);
    freq.put(" Д", 855);
    freq.put("ицо", 9);
    freq.put(" К", 931);
    freq.put("ица", 234);
    freq.put(" И", 594);
    freq.put("ице", 35);
    freq.put(" П", 1034);
    freq.put("охр", 6);
    freq.put(" Н", 990);
    freq.put("ејб", 8);
    freq.put("баш", 73);
    freq.put("риш", 42);
    freq.put("бат", 73);
    freq.put("рит", 223);
    freq.put("бар", 236);
    freq.put("бас", 23);

    init3();
  }
  private static void init3() {
    
    freq.put("бац", 11);
    freq.put("бач", 6);
    freq.put("рих", 9);
    freq.put("риф", 19);
    freq.put("рињ", 13);
    freq.put("бај", 57);
    freq.put("риј", 231);
    freq.put(" Е ", 50);
    freq.put("бак", 14);
    freq.put("бал", 103);
    freq.put("рии", 37);
    freq.put("рип", 22);
    freq.put("рио", 65);
    freq.put("бам", 49);
    freq.put("бан", 83);
    freq.put("бав", 183);
    freq.put("баг", 11);
    freq.put("баа", 12);
    freq.put("баб", 19);
    freq.put("риз", 61);
    freq.put("риж", 16);
    freq.put("бад", 6);
    freq.put("рид", 59);
    freq.put(" те", 612);
    freq.put("è", 18);
    freq.put("иј ", 20);
    freq.put("екц", 29);
    freq.put("чот", 18);
    freq.put("чор", 8);
    freq.put("еус", 7);
    freq.put(" Л", 272);
    freq.put("еуш", 19);
    freq.put("рк ", 22);
    freq.put("Џо", 28);
    freq.put("ТИ ", 6);
    freq.put("Џе", 24);
    freq.put("Џа", 22);
    freq.put("чов", 67);
    freq.put(" О", 548);
    freq.put("чое", 6);
    freq.put("чок", 18);
    freq.put("ќи ", 55);
    freq.put("ел ", 290);
    freq.put("Н", 1005);
    freq.put("ман", 158);
    freq.put("мам", 187);
    freq.put("мал", 260);
    freq.put("мак", 132);
    freq.put("маи", 11);
    freq.put("маз", 12);
    freq.put("маж", 44);
    freq.put("мад", 10);
    freq.put("маг", 37);
    freq.put("мав", 53);
    freq.put("маа", 89);
    freq.put("маш", 204);
    freq.put("мач", 31);
    freq.put("мац", 14);
    freq.put("еќн", 13);
    freq.put("мат", 211);
    freq.put("мас", 55);
    freq.put("мар", 96);
    freq.put("Жи", 19);
    freq.put("маќ", 11);
    freq.put("мањ", 17);
    freq.put("мај", 81);
    freq.put("чи ", 224);
    freq.put("ВА ", 14);
    freq.put("ес ", 164);
    freq.put("еќ", 279);
    freq.put("еџ", 10);
    freq.put("ељ", 30);
    freq.put("еј", 403);
    freq.put("ењ", 202);
    freq.put("еѓ", 68);
    freq.put("еш", 928);
    freq.put("хри", 26);
    freq.put("Еде", 15);
    freq.put("ех", 68);
    freq.put("еф", 103);
    freq.put("еч", 430);
    freq.put("ец", 272);
    freq.put("ес", 1337);
    freq.put("ер", 2149);
    freq.put("хра", 21);
    freq.put("ет", 2103);
    freq.put("вје", 18);
    freq.put("Дек", 7);
    freq.put("в ", 1182);
    freq.put("м", 13168);
    freq.put("еЗ", 24);
    freq.put("ен", 3393);
    freq.put("ем", 1461);
    freq.put("еп", 388);
    freq.put("ео", 148);
    freq.put("еи", 56);
    freq.put("ел", 1509);
    freq.put("ек", 2186);
    freq.put("ее", 261);
    freq.put("ед", 2147);
    freq.put("ез", 403);
    freq.put("еж", 118);
    freq.put("еб", 654);
    freq.put("еа", 428);
    freq.put("ег", 550);
    freq.put("ев", 851);
    freq.put("Ж", 97);
    freq.put("шш", 10);
    freq.put("шт", 1488);
    freq.put("шу", 140);
    freq.put("Жен", 13);
    freq.put("шч", 5);
    freq.put("оет", 20);
    freq.put("оењ", 5);
    freq.put("јви", 5);
    freq.put("цен", 73);
    freq.put("ОТ ", 14);
    freq.put("вде", 23);
    freq.put("оем", 7);
    freq.put("оен", 27);
    freq.put("оек", 25);
    freq.put("вда", 8);
    freq.put("оез", 7);
    freq.put("оев", 5);
    freq.put("шк", 260);
    freq.put("шл", 36);
    freq.put("ши", 365);
    freq.put("шо", 338);
    freq.put("шп", 22);
    freq.put("шм", 15);
    freq.put("шн", 199);
    freq.put("шв", 16);
    freq.put("ша", 514);
    freq.put("ше", 596);
    freq.put("кт ", 42);
    freq.put("жва", 8);
    freq.put("Сер", 12);
    freq.put("В", 664);
    freq.put("Ај ", 32);
    freq.put(" ил", 193);
    freq.put(" ик", 8);
    freq.put(" ип", 7);
    freq.put(" ин", 277);
    freq.put(" им", 775);
    freq.put(" иг", 132);
    freq.put(" иб", 6);
    freq.put(" иа", 30);
    freq.put(" из", 410);
    freq.put("афт", 8);
    freq.put(" ид", 145);
    freq.put("афо", 8);
    freq.put("афи", 57);
    freq.put(" ит", 13);
    freq.put(" ис", 306);
    freq.put(" ир", 11);
    freq.put(" ич", 22);
    freq.put("афа", 16);
    freq.put("шли", 6);
    freq.put(" ѕи", 9);
    freq.put("шла", 22);
    freq.put("шле", 5);
    freq.put("гно", 21);
    freq.put("жа ", 47);
    freq.put("гни", 6);
    freq.put("гне", 43);
    freq.put("гна", 69);
    freq.put("ршк", 11);
    freq.put("рши", 50);
    freq.put("рша", 15);
    freq.put(" к ", 16);
    freq.put("рше", 20);
    freq.put("нди", 61);
    freq.put("ндо", 50);
    freq.put("нда", 71);
    freq.put("нде", 55);
    freq.put("јмо", 8);
    freq.put("нду", 17);
    freq.put("ндр", 32);
    freq.put("ршу", 9);
    freq.put("ока", 141);
    freq.put("гну", 18);
    freq.put("зми", 48);
    freq.put("змо", 17);
    freq.put("зма", 8);
    freq.put("зме", 9);
    freq.put("фек", 16);
    freq.put("фен", 8);
    freq.put("фев", 7);
    freq.put("ЕЕ ", 5);
    freq.put("пшт", 32);
    freq.put("ац ", 11);
    freq.put(" ме", 716);
    freq.put(" ма", 771);
    freq.put("Кин", 23);
    freq.put(" мн", 149);
    freq.put(" мл", 40);
    freq.put(" мк", 15);
    freq.put(" ми", 931);
    freq.put(" ее", 5);
    freq.put("Јас", 54);
    freq.put("Јак", 11);
    freq.put("Јан", 14);
    freq.put("шпи", 6);
    freq.put("Јад", 12);
    freq.put("Ра", 83);
    freq.put(" му", 311);
    freq.put("Ре", 89);
    freq.put("Ри", 30);
    freq.put("Ро", 47);
    freq.put("ОК ", 12);
    freq.put("фер", 42);
    freq.put("фес", 24);
    freq.put("фет", 9);
    freq.put("феј", 43);
    freq.put("зо ", 24);
    freq.put("Ѓ", 13);
    freq.put("Пек", 6);
    freq.put("гба", 5);
    freq.put("зиј", 95);
    freq.put("зиц", 18);
    freq.put("зич", 10);
    freq.put("зир", 46);
    freq.put("зис", 11);
    freq.put("зит", 32);
    freq.put("Пеп", 7);
    freq.put("зиш", 9);
    freq.put("наз", 14);
    freq.put("над", 108);
    freq.put("нае", 182);
    freq.put("нав", 201);
    freq.put("наг", 32);
    freq.put("наа", 62);
    freq.put("наб", 11);
    freq.put("нао", 16);
    freq.put("нап", 192);
    freq.put("нам", 301);
    freq.put("нан", 33);
    freq.put("нак", 111);
    freq.put("нал", 236);
    freq.put("наи", 8);
    freq.put("ашл", 6);
    freq.put("ашк", 67);
    freq.put("аши", 121);
    freq.put("ашо", 21);
    freq.put("ашн", 48);
    freq.put("ли ", 894);
    freq.put("аша", 159);
    freq.put("аше", 158);
    freq.put(" т ", 11);
    freq.put("ашу", 35);
    freq.put("наџ", 9);
    freq.put("нај", 350);
    freq.put("нац", 43);
    freq.put("нач", 148);
    freq.put("наф", 8);
    freq.put("нат", 497);
    freq.put("нау", 29);
    freq.put("нар", 168);
    freq.put("нас", 176);
    freq.put("Пед", 5);
    freq.put("наш", 139);
    freq.put("ња ", 143);
    freq.put("зив", 19);
    freq.put("зиг", 6);
    freq.put("зим", 44);
    freq.put("зин", 33);
    freq.put("зио", 13);
    freq.put("зии", 11);
    freq.put("зик", 47);
    freq.put("зил", 19);
    freq.put("Глу", 6);
    freq.put("свр", 8);
    freq.put("лка", 67);
    freq.put("цу", 33);
    freq.put("цц", 11);
    freq.put("лки", 19);
    freq.put("лко", 42);
    freq.put("кеб", 5);
    freq.put("кед", 284);
    freq.put("кел", 11);
    freq.put(" фу", 66);
    freq.put("кем", 10);
    freq.put(" фр", 74);
    freq.put("ие ", 361);
    freq.put("Инт", 24);
    freq.put("кеј", 16);
    freq.put("кет", 64);
    freq.put(" фо", 103);
    freq.put("кер", 33);
    freq.put("кес", 6);
    freq.put(" фл", 11);
    freq.put(" фи", 153);
    freq.put(" фе", 74);
    freq.put(" фб", 29);
    freq.put(" фа", 248);
    freq.put("сва", 50);
    freq.put("лку", 329);
    freq.put("цв", 22);
    freq.put("све", 194);
    freq.put("сви", 31);
    freq.put("цк", 62);
    freq.put("цн", 15);
    freq.put("сво", 103);
    freq.put("Гле", 22);
    freq.put("Гла", 6);
    freq.put("ење", 181);
    freq.put("ења", 20);
    freq.put("изо", 24);
    freq.put("аат", 521);
    freq.put("изм", 46);
    freq.put("изн", 85);
    freq.put("изл", 53);
    freq.put("аах", 8);
    freq.put("изд", 24);
    freq.put("изе", 20);
    freq.put("изв", 99);
    freq.put("изг", 94);
    freq.put("иза", 99);
    freq.put("изб", 59);
    freq.put("Сев", 9);
    freq.put("ош ", 53);
    freq.put("изј", 17);
    freq.put("ааа", 205);
    freq.put("рм ", 5);
    freq.put("аал", 12);
    freq.put("изу", 8);
    freq.put("изр", 25);
    freq.put("аам", 30);
    freq.put("иќн", 5);
    freq.put("ржа", 74);
    freq.put("Суд", 6);
    freq.put("зре", 5);
    freq.put("Суп", 13);
    freq.put("Сум", 6);
    freq.put("рој", 80);
    freq.put("рош", 48);
    freq.put("рос", 117);
    freq.put("рор", 16);
    freq.put("роу", 7);
    freq.put("рот", 303);
    freq.put("роф", 50);
    freq.put("роч", 43);
    freq.put("роц", 15);
    freq.put("рои", 50);
    freq.put("рол", 86);
    freq.put("рок", 48);
    freq.put("рон", 61);
    freq.put("ф", 1520);
    freq.put("роп", 93);
    freq.put("роо", 5);
    freq.put("роб", 104);
    freq.put("роа", 8);
    freq.put("рог", 83);
    freq.put("ров", 157);
    freq.put("рое", 31);
    freq.put("род", 239);
    freq.put("роз", 41);
    freq.put("ожу", 13);
    freq.put("фол", 23);
    freq.put("ЗТ ", 12);
    freq.put("мм ", 12);
    freq.put("Наш", 12);
    freq.put("нзу", 6);
    freq.put("К", 943);
    freq.put("мон", 26);
    freq.put("мом", 64);
    freq.put("мои", 23);
    freq.put("мол", 54);
    freq.put("мок", 14);
    freq.put("мое", 19);
    freq.put("мод", 45);
    freq.put("моз", 12);
    freq.put("мож", 325);
    freq.put("моб", 43);
    freq.put("Фу", 11);
    freq.put("Фр", 28);
    freq.put("мов", 51);
    freq.put(" Са", 123);
    freq.put("Бал", 16);
    freq.put(" Св", 53);
    freq.put(" Се", 255);
    freq.put(" Си", 113);
    freq.put(" Ск", 118);
    freq.put(" Сл", 53);
    freq.put(" См", 19);
    freq.put(" Сн", 16);
    freq.put("Бад", 5);
    freq.put("Бае", 11);
    freq.put(" Ср", 63);
    freq.put("моќ", 7);
    freq.put("Баш", 20);
    freq.put(" Су", 33);
    freq.put("мој", 100);
    freq.put("Бат", 5);
    freq.put("Рис", 10);
    freq.put("ОР ", 8);
    freq.put("Фо", 29);
    freq.put("Бај", 10);
    freq.put("Риј", 6);
    freq.put("мош", 27);
    freq.put("Фи", 45);
    freq.put("моч", 12);
    freq.put("моц", 7);
    freq.put("мос", 24);
    freq.put("мор", 140);
    freq.put("моу", 6);
    freq.put("мот", 107);
    freq.put("У", 197);
    freq.put("ва ", 1223);
    freq.put("фе ", 53);
    freq.put("зот", 18);
    freq.put("зор", 27);
    freq.put("зоч", 10);
    freq.put("зош", 67);
    freq.put("а ", 22172);
    freq.put("аца", 17);
    freq.put("аце", 23);
    freq.put(" м ", 10);
    freq.put("нве", 19);
    freq.put("р", 17425);
    freq.put("Р ", 53);
    freq.put("é ", 6);
    freq.put("Ја ", 55);
    freq.put("зов", 12);
    freq.put("зод", 11);
    freq.put("зок", 11);
    freq.put("зом", 7);
    freq.put("зон", 34);
    freq.put("крш", 15);
    freq.put("крс", 14);
    freq.put("кру", 15);
    freq.put("Ул", 5);
    freq.put("Ук", 6);
    freq.put("ута", 34);
    freq.put("Ум", 10);
    freq.put("утк", 18);
    freq.put("Уб", 20);
    freq.put("уто", 15);
    freq.put("Уд", 6);
    freq.put("лии", 6);
    freq.put("лик", 193);
    freq.put("лил", 22);
    freq.put("лим", 60);
    freq.put(" тр", 482);
    freq.put(" ту", 159);
    freq.put("лип", 25);
    freq.put("лив", 88);
    freq.put("аш ", 596);
    freq.put("лид", 9);
    freq.put("лие", 7);
    freq.put("лиж", 8);
    freq.put("лиз", 54);
    freq.put("на ", 4476);
    freq.put("лиј", 98);
    freq.put("лињ", 5);
    freq.put("лиш", 45);
    freq.put(" та", 414);
    freq.put(" тв", 347);
    freq.put("лир", 25);
    freq.put("лис", 76);
    freq.put("лит", 151);
    freq.put(" то", 737);
    freq.put("лиф", 16);
    freq.put(" ти", 576);
    freq.put("лиц", 124);
    freq.put("лич", 138);
    freq.put("уту", 12);
    freq.put("утр", 137);
    freq.put("Уш", 28);
    freq.put("Ут", 27);
    freq.put("Ус", 13);
    freq.put("Ур", 9);
    freq.put("кри", 127);
    freq.put("еќи", 6);
    freq.put("зи ", 82);
    freq.put("кро", 40);
    freq.put("кра", 184);
    freq.put("еќа", 75);
    freq.put("крв", 7);
    freq.put("кре", 76);
    freq.put("еќе", 182);
    freq.put("уф ", 8);
    freq.put(" Зд", 23);
    freq.put(" Зе", 14);
    freq.put(" Зв", 5);
    freq.put(" За", 199);
    freq.put(" Зб", 6);
    freq.put(" Зо", 35);
    freq.put(" Зн", 46);
    freq.put(" Зл", 11);
    freq.put(" Зи", 5);
    freq.put("иед", 6);
    freq.put("Кир", 21);
    freq.put("иев", 20);
    freq.put("ием", 17);
    freq.put("иен", 28);
    freq.put("иел", 11);
    freq.put("ке ", 88);
    freq.put("Фот", 15);
    freq.put("иењ", 20);
    freq.put("иец", 6);
    freq.put("иер", 36);
    freq.put("иет", 36);
    freq.put("Кил", 6);
    freq.put("јкл", 5);
    freq.put("иеш", 16);
    freq.put("ѓи ", 7);
    freq.put("иња", 105);
    freq.put("ињо", 13);
    freq.put("ц ", 173);
    freq.put("нза", 8);
    freq.put("рму", 6);
    freq.put("из ", 38);
    freq.put("рме", 20);
    freq.put("аа ", 274);
    freq.put("рма", 93);
    freq.put("рмо", 8);
    freq.put("рми", 37);
    freq.put("елн", 80);
    freq.put("нзи", 59);
    freq.put("иќ ", 46);
    freq.put("елс", 31);
    freq.put("чку", 5);
    freq.put(" џу", 5);
    freq.put("Мла", 6);
    freq.put(" џи", 8);
    freq.put(" џе", 14);
    freq.put(" џа", 27);
    freq.put("Изг", 11);
    freq.put("ро ", 303);
    freq.put("чко", 73);
    freq.put("чки", 178);
    freq.put("чке", 7);
    freq.put("чка", 176);
    freq.put("Шти", 9);
    freq.put("ммм", 21);
    freq.put("шот", 6);
    freq.put("си ", 620);
    freq.put(" С ", 12);
    freq.put("Дру", 15);
    freq.put("мо ", 361);
    freq.put("Ф ", 13);
    freq.put("ваљ", 12);
    freq.put("вај", 120);
    freq.put("вањ", 213);
    freq.put("вас", 32);
    freq.put("вар", 200);
    freq.put("ват", 296);
    freq.put("вач", 58);
    freq.put("вац", 8);
    freq.put("ваш", 145);
    freq.put("ваа", 234);
    freq.put("вав", 35);
    freq.put("вад", 52);
    freq.put("важ", 24);
    freq.put("вал", 93);
    freq.put("вак", 95);
    freq.put("ван", 94);
    freq.put("вам", 363);
    freq.put("че", 897);
    freq.put("ча", 427);
    freq.put("чо", 136);
    freq.put("чн", 418);
    freq.put("чл", 19);
    freq.put("чк", 441);
    freq.put("чи", 715);
    freq.put("лс ", 6);
    freq.put("ул ", 39);
    freq.put("Ал", 75);
    freq.put("ш", 5208);
    freq.put("чу", 200);
    freq.put("во ", 1820);
    freq.put("уно", 9);
    freq.put("луз", 19);
    freq.put("луж", 19);
    freq.put("луб", 19);
    freq.put("унк", 14);
    freq.put("луг", 5);
    freq.put("лув", 77);
    freq.put("лун", 8);
    freq.put("лум", 34);
    freq.put("луп", 55);
    freq.put("унд", 23);
    freq.put("лук", 23);
    freq.put(" А ", 141);
    freq.put(" о ", 19);
    freq.put("РЕ ", 5);
    freq.put("вмр", 7);
    freq.put("луѓ", 79);
    freq.put("вме", 91);
    freq.put("луф", 8);
    freq.put("луч", 115);
    freq.put("луц", 10);
    freq.put("лус", 21);
    freq.put("лур", 8);
    freq.put("леж", 19);
    freq.put("луш", 95);
    freq.put("жд ", 9);
    freq.put("Изр", 12);
    freq.put("О", 553);
    freq.put("но ", 1458);
    freq.put("ОО ", 6);
    freq.put("лм ", 32);
    freq.put("гет", 8);
    freq.put("гер", 29);
    freq.put("геј", 13);
    freq.put(" ц ", 12);
    freq.put("ПЦ ", 5);
    freq.put("гед", 5);
    freq.put("еј ", 90);
    freq.put("са ", 100);
    freq.put("гел", 13);
    freq.put("уја", 32);
    freq.put("ује", 5);
    freq.put("ујн", 9);
    freq.put("ујо", 8);
    freq.put("лоо", 7);
    freq.put("лоп", 12);
    freq.put("лом", 23);
    freq.put("лон", 49);
    freq.put("лок", 37);
    freq.put("лол", 19);
    freq.put("лож", 37);
    freq.put("лоз", 15);
    freq.put("лод", 8);
    freq.put("лов", 129);
    freq.put("лог", 94);
    freq.put("лоб", 48);
    freq.put("јси", 8);
    freq.put("јск", 14);
    freq.put("јсб", 29);
    freq.put("јсе", 7);
    freq.put(" шу", 24);
    freq.put(" шт", 674);
    freq.put(" шл", 9);
    freq.put(" шк", 16);
    freq.put(" ши", 48);
    freq.put(" шп", 20);
    freq.put("ав ", 287);
    freq.put(" шм", 9);
    freq.put(" шв", 14);
    freq.put(" ша", 53);
    freq.put(" ше", 47);
    freq.put("јст", 20);
    freq.put("лош", 86);
    freq.put("лоч", 7);
    freq.put("лот", 111);
    freq.put("лоу", 18);
    freq.put("лор", 11);
    freq.put("лос", 22);
    freq.put("ујр", 8);
    freq.put(" Не", 375);
    freq.put(" На", 257);
    freq.put(" Но", 110);
    freq.put("иС", 7);
    freq.put(" Ни", 104);
    freq.put("хе ", 19);
    freq.put("ик", 1131);
    freq.put("ил", 1184);
    freq.put("ии", 291);
    freq.put("ио", 706);
    freq.put("ип", 213);
    freq.put("им", 1380);
    freq.put("ин", 1983);
    freq.put("ив", 1149);
    freq.put("иг", 423);
    freq.put("иа", 80);
    freq.put("иб", 74);
    freq.put("иж", 47);
    freq.put("из", 806);
    freq.put("ид", 814);
    freq.put("ие", 567);
    freq.put("ген", 51);
    freq.put("аду", 42);
    freq.put("адс", 7);
    freq.put("адр", 33);
    freq.put("Ас", 5);
    freq.put("адо", 164);
    freq.put("адн", 112);
    freq.put("адм", 17);
    freq.put("ади", 239);
    freq.put("аде", 260);
    freq.put("адв", 34);
    freq.put("џ", 212);
    freq.put("ада", 176);
    freq.put("иш", 631);
    freq.put("ит", 2688);
    freq.put("иу", 68);
    freq.put("ир", 950);
    freq.put("ис", 1447);
    freq.put("иц", 616);
    freq.put("ич", 583);
    freq.put("иф", 67);
    freq.put("их", 54);
    freq.put("ињ", 121);
    freq.put("иј", 1582);
    freq.put("иљ", 23);
    freq.put("иџ", 13);
    freq.put("иќ", 57);
    freq.put(" Ну", 7);
    freq.put("иѓ", 12);
    freq.put("Ѕве", 6);
    freq.put("би ", 188);
    freq.put("Вра", 5);
    freq.put("Вре", 23);
    freq.put("ПО ", 5);
    freq.put("ми ", 712);
    freq.put(" Ж ", 27);
    freq.put("луд", 24);
    freq.put(" У ", 23);
    freq.put("бод", 52);
    freq.put("бож", 20);
    freq.put("е", 37912);
    freq.put("боб", 5);
    freq.put("бов", 61);
    freq.put("бог", 36);
    freq.put("бом", 14);
    freq.put("бон", 6);
    freq.put("бок", 22);
    freq.put("бол", 71);
    freq.put("боч", 5);
    freq.put("бор", 198);
    freq.put("бос", 7);
    freq.put("бот", 345);
    freq.put("бој", 18);
    freq.put("бољ", 25);
    freq.put("ЛЕ ", 5);
    freq.put("уле", 18);
    freq.put("вој", 235);
    freq.put("ула", 79);
    freq.put("лск", 55);
    freq.put("уло", 13);
    freq.put("ули", 73);
    freq.put("улк", 5);
    freq.put("вош", 6);
    freq.put("ч ", 119);
    freq.put(" Кл", 26);
    freq.put("вот", 221);
    freq.put("вос", 28);
    freq.put("вор", 263);
    freq.put("воч", 5);
    freq.put("вол", 107);
    freq.put("вок", 16);
    freq.put("вои", 50);
    freq.put("воп", 5);
    freq.put("воо", 22);
    freq.put("вон", 13);
    freq.put("вог", 10);
    freq.put("вов", 26);
    freq.put("воб", 11);
    freq.put("воз", 96);
    freq.put("вое", 27);
    freq.put("вод", 138);
    freq.put("лст", 20);
    freq.put("улс", 6);
    freq.put("улу", 6);
    freq.put("улт", 53);
    freq.put("Ушт", 25);
    freq.put(" ок", 63);
    freq.put(" он", 180);
    freq.put(" ом", 30);
    freq.put(" оп", 116);
    freq.put(" оо", 9);
    freq.put(" об", 185);
    freq.put(" ог", 40);
    freq.put(" ов", 340);
    freq.put(" од", 1361);
    freq.put(" оз", 13);
    freq.put("лу ", 31);
    freq.put("ун ", 24);
    freq.put(" ој", 7);
    freq.put("мши", 18);
    freq.put(" ош", 6);
    freq.put(" ос", 263);
    freq.put(" ор", 60);
    freq.put(" от", 246);
    freq.put(" ох", 8);
    freq.put(" оф", 38);
    freq.put(" оч", 72);
    freq.put(" оц", 5);
    freq.put("жда", 10);
    freq.put("аЕк", 20);
    freq.put("фб ", 27);
    freq.put("нок", 42);
    freq.put("нол", 10);
    freq.put("ном", 35);
    freq.put("нон", 16);
    freq.put("ноо", 5);
    freq.put("ноп", 8);
    freq.put("нов", 334);
    freq.put("ног", 202);
    freq.put("нож", 10);
    freq.put("ноз", 20);
    freq.put("ној", 26);
    freq.put("ноќ", 49);
    freq.put("нош", 5);
    freq.put("нор", 37);
    freq.put("нос", 270);
    freq.put("нот", 195);
    freq.put("Џаб", 7);
    freq.put("ихи", 14);
    freq.put("сањ", 6);
    freq.put("сај", 35);
    freq.put("ејџ", 8);
    freq.put("ејќ", 33);
    freq.put("лма", 17);
    freq.put("уци", 21);
    freq.put("ејс", 47);
    freq.put("сат", 39);
    freq.put("лмо", 31);
    freq.put("сач", 6);
    freq.put("уца", 7);
    freq.put("б", 6056);
    freq.put(" цр", 67);
    freq.put(" цу", 8);
    freq.put(" цц", 5);
    freq.put(" ца", 18);
    freq.put(" цв", 20);
    freq.put(" це", 149);
    freq.put(" ци", 69);
    freq.put("сак", 229);
    freq.put("сал", 31);
    freq.put("ејд", 12);
    freq.put("еје", 7);
    freq.put("ејв", 18);
    freq.put("сам", 377);
    freq.put("сан", 36);
    freq.put("сав", 9);
    freq.put("саа", 26);
    freq.put("саб", 48);
    freq.put("ејк", 18);
    freq.put("ејл", 24);
    freq.put("сад", 46);
    freq.put(" Ла", 47);
    freq.put(" Ле", 71);
    freq.put(" Ли", 55);
    freq.put(" Ло", 40);
    freq.put("ло ", 238);
    freq.put("уј ", 5);
    freq.put("авч", 6);
    freq.put("авс", 8);
    freq.put("авр", 69);
    freq.put("аву", 55);
    freq.put("авт", 95);
    freq.put("јс ", 8);
    freq.put("авј", 21);
    freq.put("аве", 126);
    freq.put("авд", 8);
    freq.put("ава", 677);
    freq.put("авг", 5);
    freq.put("авн", 122);
    freq.put("авм", 43);
    freq.put("аво", 196);
    freq.put("ави", 422);
    freq.put("авл", 7);
    freq.put("авк", 16);
    freq.put("Здр", 23);
    freq.put(" Лу", 29);
    freq.put("и ", 11394);
    freq.put("хем", 14);
    freq.put(" Н ", 6);
    freq.put("хел", 9);
    freq.put("ад ", 156);
    freq.put("Оли", 5);
    freq.put("Вто", 17);
    freq.put("хех", 21);
    freq.put("хер", 11);
    freq.put("хеј", 26);
    freq.put("ќни", 11);
    freq.put("Са", 123);
    freq.put("Св", 55);
    freq.put("Се", 260);
    freq.put("Си", 115);
    freq.put("Сл", 53);
    freq.put("Ск", 118);
    freq.put("Сн", 16);
    freq.put("См", 22);
    freq.put("Сп", 55);
    freq.put("Со", 107);
    freq.put("бив", 62);
    freq.put("Мое", 5);
    freq.put("биб", 8);
    freq.put("биз", 14);
    freq.put("бид", 221);
    freq.put("бие", 30);
    freq.put("бик", 8);
    freq.put("бил", 208);
    freq.put("био", 9);
    freq.put("бин", 24);
    freq.put("бит", 62);
    freq.put("бир", 72);
    freq.put("бис", 29);
    freq.put("биц", 20);
    freq.put("бич", 35);
    freq.put("ИК ", 5);
    freq.put("биј", 45);
    freq.put("Ср", 63);
    freq.put("Су", 36);
    freq.put("Ст", 127);
    freq.put("уд", 422);
    freq.put("миз", 11);
    freq.put("мрч", 13);
    freq.put("мие", 31);
    freq.put("мид", 7);
    freq.put("миг", 5);
    freq.put("мив", 6);
    freq.put("мио", 16);
    freq.put("мин", 233);
    freq.put("мил", 116);
    freq.put("мик", 11);
    freq.put("мии", 5);
    freq.put("бо ", 38);
    freq.put("мрт", 18);
    freq.put(" Ук", 6);
    freq.put(" Ул", 5);
    freq.put(" Ум", 10);
    freq.put(" Уб", 20);
    freq.put(" Уд", 6);
    freq.put(" Уш", 28);
    freq.put(" Ут", 24);
    freq.put(" Ур", 9);
    freq.put(" Ус", 13);
    freq.put("мич", 10);
    freq.put("миц", 32);
    freq.put("мит", 61);
    freq.put("мис", 285);
    freq.put("Пуш", 5);
    freq.put("миш", 7);
    freq.put("мињ", 22);
    freq.put("миљ", 5);
    freq.put("миј", 21);
    freq.put("мк ", 13);
    freq.put("ГА ", 5);
    freq.put("фур", 6);
    freq.put("Ааа", 9);
    freq.put("Гу", 21);
    freq.put(" же", 151);
    freq.put("Гр", 97);
    freq.put("Гл", 38);
    freq.put("Бит", 28);
    freq.put("Ги", 23);
    freq.put("Го", 102);
    freq.put("Гв", 9);
    freq.put("Га", 26);
    freq.put("Ге", 25);
    freq.put("фун", 10);
    freq.put("фуд", 49);
    freq.put("елу", 31);
    freq.put("тв ", 11);
    freq.put("њев", 6);
    freq.put("елт", 6);
    freq.put("тас", 66);
    freq.put("тар", 211);
    freq.put("тат", 202);
    freq.put("Рон", 6);
    freq.put("Ром", 6);
    freq.put(" Ча", 28);
    freq.put("тац", 15);
    freq.put(" Чо", 16);
    freq.put("таш", 31);
    freq.put("МИ ", 6);
    freq.put("Род", 6);
    freq.put(" Чи", 31);
    freq.put("тај", 91);
    freq.put("тањ", 25);
    freq.put("таб", 22);
    freq.put("таа", 80);
    freq.put("таг", 18);
    freq.put("тав", 205);
    freq.put("тае", 5);
    freq.put("тад", 25);
    freq.put("таз", 13);
    freq.put("таж", 15);
    freq.put("Рос", 7);
    freq.put("таи", 8);
    freq.put("тал", 169);
    freq.put("так", 194);
    freq.put("тан", 287);
    freq.put("там", 219);
    freq.put("тап", 60);
    freq.put("уп ", 29);
    freq.put("аѓа", 96);
    freq.put("Мој", 9);
    freq.put("мри", 5);
    freq.put("њи ", 6);
    freq.put("убл", 14);
    freq.put("лча", 6);
    freq.put("уби", 84);
    freq.put("лче", 10);
    freq.put("убо", 78);
    freq.put("убв", 5);
    freq.put("уба", 144);
    freq.put("убе", 36);
    freq.put("Т ", 90);
    freq.put("ои ", 194);
    freq.put("убу", 7);
    freq.put("убр", 10);
    freq.put("жи ", 110);
    freq.put("Атл", 6);
    freq.put("нк ", 22);
    freq.put("штр", 6);
    freq.put("шту", 11);
    freq.put("Кри", 12);
    freq.put("Кра", 18);
    freq.put("џу", 8);
    freq.put("цот", 25);
    freq.put("ше ", 398);
    freq.put("вил", 45);
    freq.put("вик", 161);
    freq.put("вин", 134);
    freq.put("вим", 30);
    freq.put("вио", 74);
    freq.put("виа", 12);
    freq.put("вив", 71);
    freq.put("вие", 96);
    freq.put("вид", 227);
    freq.put("виз", 72);
    freq.put("виж", 11);
    freq.put("пре", 682);
    freq.put("пра", 605);
    freq.put("прв", 112);
    freq.put("вис", 84);
    freq.put("вир", 56);
    freq.put("про", 645);
    freq.put("вит", 493);
    freq.put("при", 372);
    freq.put("вич", 21);
    freq.put("виц", 26);
    freq.put("виј", 30);
    freq.put("виќ", 11);
    freq.put("виѓ", 9);
    freq.put("џо", 7);
    freq.put("џи", 79);
    freq.put("џе", 57);
    freq.put("жол", 6);
    freq.put("џа", 46);
    freq.put("што", 980);
    freq.put("шти", 87);
    freq.put("ште", 270);
    freq.put("шта", 115);
    freq.put("штв", 13);
    freq.put("ју ", 25);
    freq.put("Џ", 84);
    freq.put("нио", 167);
    freq.put("ним", 57);
    freq.put("нин", 59);
    freq.put("ник", 283);
    freq.put("нил", 23);
    freq.put("нии", 7);
    freq.put("низ", 70);
    freq.put("ние", 158);
    freq.put("нив", 91);
    freq.put("ниг", 42);
    freq.put("Вол", 10);
    freq.put("Вои", 5);
    freq.put("Воз", 10);
    freq.put("Вод", 8);
    freq.put("тче", 7);
    freq.put("ниш", 97);
    freq.put("ниц", 228);
    freq.put("нич", 93);
    freq.put("нит", 295);
    freq.put("ниу", 6);
    freq.put("нир", 51);
    freq.put("нис", 100);
    freq.put("ниј", 267);
    freq.put("ѓањ", 7);
    freq.put("еп ", 16);
    freq.put("уќа", 14);
    freq.put("ѓаш", 6);
    freq.put(" П ", 12);
    freq.put("скр", 61);
    freq.put("ску", 34);
    freq.put("Св ", 6);
    freq.put("аж ", 22);
    freq.put("скл", 27);
    freq.put("ско", 227);
    freq.put("ска", 537);
    freq.put("скв", 10);
    freq.put("ске", 22);
    freq.put("ѓам", 11);
    freq.put("ѓан", 35);
    freq.put("ѓаа", 12);
    freq.put("ене", 385);
    freq.put("енд", 125);
    freq.put("енз", 54);
    freq.put("ена", 414);
    freq.put("енг", 12);
    freq.put("ено", 334);
    freq.put("ени", 496);
    freq.put("енк", 55);
    freq.put("Сањ", 6);
    freq.put("тра", 268);
    freq.put("трг", 21);
    freq.put("тре", 433);
    freq.put("три", 149);
    freq.put("трк", 10);
    freq.put("тро", 220);
    freq.put("Саш", 7);
    freq.put("аиш", 12);
    freq.put("аит", 6);
    freq.put("Сар", 10);
    freq.put("аир", 13);
    freq.put("аич", 8);
    freq.put("Сак", 16);
    freq.put("аин", 11);
    freq.put("аим", 10);
    freq.put("аив", 13);
    freq.put("Саб", 7);
    freq.put("тру", 87);
    freq.put("трч", 18);
    freq.put("ИМ ", 5);
    freq.put("енч", 11);
    freq.put("енц", 66);
    freq.put("енс", 89);
    freq.put("ену", 31);
    freq.put("ент", 294);
    freq.put("уни", 49);
    freq.put("енш", 5);
    freq.put("уне", 9);
    freq.put("мки", 5);
    freq.put("мка", 8);
    freq.put("уна", 33);
    freq.put("тву", 27);
    freq.put("твр", 36);
    freq.put(" Хо", 25);
    freq.put(" Хи", 14);
    freq.put(" Хе", 20);
    freq.put(" Ха", 59);
    freq.put(" Хр", 15);
    freq.put(" Ху", 5);
    freq.put("бв", 19);
    freq.put("Г ", 13);
    freq.put("тво", 304);
    freq.put("тви", 337);
    freq.put("тве", 58);
    freq.put("тва", 121);
    freq.put("оѓ", 11);
    freq.put("нче", 56);
    freq.put("нчи", 8);
    freq.put("цов", 12);
    freq.put("та ", 1849);
    freq.put("нчу", 6);
    freq.put("ох", 37);
    freq.put("јко", 26);
    freq.put("лут", 24);
    freq.put("дна", 304);
    freq.put("упа", 72);
    freq.put("Арс", 13);
    freq.put("упе", 40);
    freq.put("дне", 92);
    freq.put("дни", 169);
    freq.put("упи", 55);
    freq.put("упл", 12);
    freq.put("упк", 13);
    freq.put("упн", 10);
    freq.put("дно", 254);
    freq.put("упо", 46);
    freq.put("унт", 13);
    freq.put("упр", 15);
    freq.put("упу", 25);
    freq.put("дну", 10);
    freq.put("Ѓор", 9);
    freq.put("жиш", 8);
    freq.put("уб ", 16);
    freq.put("жит", 18);
    freq.put("жиќ", 9);
    freq.put("Тр", 86);
    freq.put("Ту", 34);
    freq.put("ји ", 14);
    freq.put("вка", 41);
    freq.put("вко", 7);
    freq.put("вкл", 5);
    freq.put("вки", 15);
    freq.put("вку", 23);
    freq.put("пци", 17);
    freq.put("Те", 93);
    freq.put("Та", 75);
    freq.put("Тв", 49);
    freq.put("То", 122);
    freq.put("Ти", 66);
    freq.put("жин", 17);
    freq.put("жим", 17);
    freq.put("Чаи", 10);
    freq.put("жил", 12);
    freq.put("ќт", 9);
    freq.put("жив", 216);
    freq.put("Фер", 10);
    freq.put("Феј", 16);
    freq.put("нке", 19);
    freq.put("нка", 90);
    freq.put("нко", 51);
    freq.put(" К ", 7);
    freq.put("нки", 47);
    freq.put("ви ", 643);
    freq.put("Вал", 8);
    freq.put("Вак", 12);
    freq.put("Ван", 5);
    freq.put(" Аб", 51);
    freq.put("гри", 29);
    freq.put("шев", 16);
    freq.put("шем", 5);
    freq.put("шен", 71);
    freq.put("гре", 94);
    freq.put("шек", 5);
    freq.put("шел", 9);
    freq.put("шеф", 5);
    freq.put("шер", 9);
    freq.put("шес", 6);
    freq.put("шет", 36);
    freq.put("гру", 28);
    freq.put("шеш", 7);
    freq.put("ь", 10);
    freq.put("грч", 18);
    freq.put("Вас", 5);
    freq.put("Вар", 19);
    freq.put("пр ", 6);
    freq.put("Ваш", 5);
    freq.put("шењ", 7);
    freq.put("нкц", 5);
    freq.put("нкр", 6);
    freq.put("нку", 24);
    freq.put("шт ", 5);
    freq.put("гле", 324);
    freq.put("џ ", 8);
    freq.put("мог", 28);
    freq.put("уња", 5);
    freq.put("ни ", 1289);
    freq.put("јув", 8);
    freq.put("југ", 5);
    freq.put("јуб", 31);
    freq.put("јун", 9);
    freq.put("Шпа", 9);
    freq.put("Во ", 69);
    freq.put("јут", 21);
    freq.put(" По", 306);
    freq.put(" Пл", 25);
    freq.put(" Пи", 57);
    freq.put(" Пе", 67);
    freq.put(" Па", 167);
    freq.put("епа", 102);
    freq.put("епе", 41);
    freq.put("епк", 7);
    freq.put("епи", 34);
    freq.put("епо", 66);
    freq.put("Каљ", 8);
    freq.put("Кај", 28);
    freq.put("Т", 591);
    freq.put("ажу", 48);
    freq.put("Кар", 34);
    freq.put("тте", 5);
    freq.put("Кат", 7);
    freq.put("Каф", 6);
    freq.put("тта", 13);
    freq.put("ажб", 10);
    freq.put("ажа", 132);
    freq.put("Кал", 25);
    freq.put("Как", 118);
    freq.put("Кан", 17);
    freq.put("Кам", 13);
    freq.put("Кап", 12);
    freq.put("ск ", 11);
    freq.put("ажи", 68);
    freq.put("ажн", 33);
    freq.put("Кад", 18);
    freq.put("Каж", 8);
    freq.put("епу", 14);
    freq.put("епт", 48);
    freq.put("епс", 7);
    freq.put("епр", 34);
    freq.put("епч", 6);
    freq.put("ѓа ", 46);
    freq.put(" Пф", 5);
    freq.put(" Пу", 27);
    freq.put(" Пр", 273);
    freq.put(" Пс", 5);
    freq.put("ен ", 994);
    freq.put("уе ", 22);
    freq.put("Опш", 5);
    freq.put("Опе", 5);
    freq.put("аи ", 24);
    freq.put("Љуб", 17);
    freq.put("км", 23);
    freq.put("кн", 139);
    freq.put("ко", 4115);
    freq.put("елм", 10);
    freq.put("ки", 1460);
    freq.put("елк", 42);
    freq.put("кк", 7);
    freq.put("кл", 248);
    freq.put("кд", 9);
    freq.put("ке", 573);
    freq.put("еле", 278);
    freq.put("ка", 4760);
    freq.put("кв", 249);
    freq.put("ела", 216);
    freq.put("Буг", 12);
    freq.put("Бул", 5);
    freq.put("акф", 6);
    freq.put("акц", 29);
    freq.put("акс", 32);
    freq.put("акр", 29);
    freq.put("аку", 77);
    freq.put("акт", 98);
    freq.put("акн", 23);
    freq.put("акм", 10);
    freq.put("Лиг", 12);
    freq.put("аки", 56);
    freq.put("акл", 27);
    freq.put("аке", 303);
    freq.put("ака", 549);
    freq.put("акв", 150);
    freq.put("Бур", 5);
    freq.put("Он ", 14);
    freq.put("Буш", 5);
    freq.put("кш", 5);
    freq.put("кф", 9);
    freq.put("кц", 78);
    freq.put("кч", 7);
    freq.put("кр", 487);
    freq.put("кс", 318);
    freq.put("кт", 306);
    freq.put("ку", 967);
    freq.put("Есм", 6);
    freq.put("Г", 390);
    freq.put("Огл", 5);
    freq.put("ГО ", 12);
    freq.put("љак", 9);
    freq.put("На", 264);
    freq.put("дс ", 9);
    freq.put("ж ", 43);
    freq.put("Би ", 8);
    freq.put("Но", 114);
    freq.put("душ", 52);
    freq.put("дух", 18);
    freq.put("дур", 45);
    freq.put("ок ", 157);
    freq.put("Аде", 11);
    freq.put("то ", 1931);
    freq.put("тл", 57);
    freq.put("дуп", 28);
    freq.put("дум", 17);
    freq.put("дук", 9);
    freq.put("дуе", 7);
    freq.put("дув", 98);
    freq.put("Бож", 13);
    freq.put("Бог", 10);
    freq.put("Бок", 8);
    freq.put("иче", 83);
    freq.put("пљу", 5);
    freq.put("оид", 22);
    freq.put("оиз", 25);
    freq.put("оин", 25);
    freq.put("оим", 15);
    freq.put("ну ", 19);
    freq.put("оит", 36);
    freq.put("оиш", 9);
    freq.put("тмо", 8);
    freq.put("тме", 5);
    freq.put("тма", 5);
    freq.put("Бор", 12);
    freq.put("Бос", 14);
    freq.put("Бој", 7);
    freq.put("уг ", 21);
    freq.put("нса", 14);
    freq.put("нсе", 12);
    freq.put("Лаз", 13);
    freq.put("нси", 24);
    freq.put("нск", 319);
    freq.put("нсп", 18);
    freq.put("нсо", 13);
    freq.put("МЕ ", 6);
    freq.put("јк ", 15);
    freq.put("ќ ", 74);
    freq.put("Тви", 46);
    freq.put("Лат", 11);
    freq.put("нст", 85);
    freq.put("ќут", 14);
    freq.put("уев", 26);
    freq.put("дла", 17);
    freq.put("дло", 24);
    freq.put("уем", 14);
    freq.put("уел", 29);
    freq.put("дли", 43);
    freq.put("чу ", 10);
    freq.put("јмн", 9);
    freq.put("јмл", 21);
    freq.put("јми", 7);
    freq.put("Инд", 14);
    freq.put("јме", 14);
    freq.put("Ина", 19);
    freq.put("јма", 19);
    freq.put("Бр", 77);
    freq.put("Бу", 50);
    freq.put("Пет", 18);
    freq.put("Пес", 6);
    freq.put("Пер", 15);
    freq.put("руп", 32);
    freq.put("Ба", 143);
    freq.put("Бе", 89);
    freq.put("Би", 83);
    freq.put("Бл", 25);
    freq.put("Рам", 14);
    freq.put("Бо", 85);
    freq.put("ццц", 6);
    freq.put("Инс", 11);
    freq.put("пт ", 12);
    freq.put("длу", 12);
    freq.put(" Јо", 27);
    freq.put(" Ја", 158);
    freq.put(" Је", 18);
    freq.put("Д ", 65);
    freq.put("Чов", 9);
    freq.put("Дне", 7);
    freq.put(" Ју", 34);
    freq.put("зу", 55);
    freq.put("зр", 44);
    freq.put("зј", 26);
    freq.put("Утр", 22);
    freq.put("зе", 312);
    freq.put("зд", 168);
    freq.put("зг", 182);
    freq.put("зв", 180);
    freq.put("зб", 273);
    freq.put("за", 2755);
    freq.put("зо", 237);
    freq.put("зн", 731);
    freq.put("зм", 83);
    freq.put("зл", 130);
    freq.put("зк", 6);
    freq.put("зи", 503);
    freq.put("Вку", 6);
    freq.put("рја", 8);
    freq.put("Ав", 29);
    freq.put("Аг", 7);
    freq.put("Аа", 11);
    freq.put("Аб", 51);
    freq.put("Ад", 21);
    freq.put("Ак", 120);
    freq.put("њ ", 9);
    freq.put("к ", 891);
    freq.put("Ап", 16);
    freq.put("Ам", 71);
    freq.put("Ан", 79);
    freq.put("врб", 8);
    freq.put("вра", 190);
    freq.put("врв", 7);
    freq.put("ева", 95);
    freq.put("Она", 23);
    freq.put("Оно", 6);
    freq.put("Они", 7);
    freq.put("ѐ", 9);
    freq.put("ври", 25);
    freq.put("ак ", 235);
    freq.put("уал", 33);
    freq.put("еви", 55);
    freq.put("Ај", 80);
    freq.put("Ат", 12);
    freq.put("Ау", 7);
    freq.put("Ар", 38);
    freq.put("Хо", 26);
    freq.put("Ац", 5);
    freq.put("Ах", 31);
    freq.put("Хи", 14);
    freq.put("Хе", 20);
    freq.put("врт", 40);
    freq.put("Хеј", 7);
    freq.put("дст", 16);
    freq.put("Ха", 59);
    freq.put("Авс", 6);
    freq.put("Авт", 10);
    freq.put("дск", 39);
    freq.put("жа", 401);
    freq.put("жб", 38);
    freq.put("жв", 9);
    freq.put("Биб", 5);
    freq.put("жд", 26);
    freq.put("же", 562);
    freq.put("Бид", 7);
    freq.put("жи", 435);
    freq.put("Бил", 11);
    freq.put("жл", 5);
    freq.put("жн", 86);
    freq.put("жо", 20);
    freq.put("Пул", 6);
    freq.put("Ц", 92);
    freq.put("тот", 288);
    freq.put("тос", 11);
    freq.put("тор", 292);
    freq.put("точ", 58);
    freq.put("тоц", 10);
    freq.put("окв", 9);
    freq.put("тој", 114);
    freq.put("оке", 19);
    freq.put("окл", 23);
    freq.put("оки", 39);
    freq.put("Хрв", 8);
    freq.put("око", 148);
    freq.put("окн", 12);
    freq.put("оку", 22);
    freq.put("окт", 43);
    freq.put("окс", 21);
    freq.put("окр", 42);
    freq.put("тол", 124);
    freq.put("ток", 89);
    freq.put("тои", 43);
    freq.put("топ", 72);
    freq.put("тоо", 6);
    freq.put("тон", 62);
    freq.put("том", 56);
    freq.put("тог", 80);
    freq.put("тов", 152);
    freq.put("тоб", 24);
    freq.put("тоа", 434);
    freq.put("тое", 7);
    freq.put("тод", 11);
    freq.put("жр", 9);
    freq.put("жу", 118);
    freq.put("é", 6);
    freq.put("жј", 8);
    freq.put("Биј", 6);
    freq.put("ду ", 15);
    freq.put(" шо", 220);
    freq.put("нул", 6);
    freq.put("нук", 6);
    freq.put("нуе", 6);
    freq.put("нуд", 30);
    freq.put("нув", 209);
    freq.put("нуа", 14);
    freq.put("нут", 39);
    freq.put("нус", 5);
    freq.put("нс ", 14);
    freq.put("уго", 55);
    freq.put("уги", 68);
    freq.put("угл", 16);
    freq.put("уга", 119);
    freq.put("јке", 16);
    freq.put("Или", 27);
    freq.put("ќе", 1147);
    freq.put("јка", 86);
    freq.put("ќа", 204);
    freq.put("ќо", 7);
    freq.put("ќн", 26);
    freq.put("јки", 28);
    freq.put("ќи", 71);
    freq.put("Плу", 5);
    freq.put("њо ", 12);
    freq.put("џиј", 24);
    freq.put("Пла", 12);
    freq.put("џии", 28);
    freq.put("ќу", 22);
    freq.put("Хр", 15);
    freq.put("Ху", 6);
    freq.put("ошу", 10);
    freq.put("ошт", 166);
    freq.put("чув", 95);
    freq.put("чуе", 8);
    freq.put("чуд", 48);
    freq.put("ОД ", 17);
    freq.put("чук", 11);
    freq.put("јм ", 11);
    freq.put("пто", 7);
    freq.put("чур", 6);
    freq.put("пти", 31);
    freq.put("пте", 33);
    freq.put("пта", 5);
    freq.put("Б ", 29);
    freq.put("оше", 21);
    freq.put("оша", 41);
    freq.put("ошо", 53);
    freq.put("оши", 25);
    freq.put("ошл", 12);
    freq.put("ошк", 27);
    freq.put("До", 195);
    freq.put("Дн", 8);
    freq.put("Ди", 46);
    freq.put("Де", 178);
    freq.put("Дв", 23);
    freq.put("Да", 224);
    freq.put("Ду", 27);
    freq.put("Др", 58);
    freq.put("јчи", 11);
    freq.put("јче", 22);
    freq.put("Гер", 12);
    freq.put("сиј", 60);
    freq.put("сит", 232);
    freq.put("сир", 64);
    freq.put("сис", 25);
    freq.put("сич", 12);
    freq.put("сих", 13);
    freq.put("сиш", 9);
    freq.put("н", 22685);
    freq.put("сив", 15);
    freq.put("сиг", 41);
    freq.put("сиб", 7);
    freq.put("з ", 226);
    freq.put("сик", 17);
    freq.put("сил", 52);
    freq.put("сии", 8);
    freq.put("сио", 6);
    freq.put("сип", 15);
    freq.put("сим", 33);
    freq.put("син", 52);
  }
  
}

