package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class NL {
  private static final String name = "nl";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public NL() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 2008978;
    n_words[1] = 2457524;
    n_words[2] = 1943506;

    freq.put("sn ", 198);
    freq.put("alo", 113);
    freq.put("woo", 1489);
    freq.put("dez", 576);
    freq.put("bob", 46);
    freq.put("nwe", 182);
    freq.put("vr ", 29);
    freq.put("nwa", 22);
    freq.put(" G ", 49);
    freq.put("nwo", 63);
    freq.put("nwi", 44);
    freq.put("alk", 90);
    freq.put("aub", 35);
    freq.put("lke", 445);
    freq.put("mp ", 121);
    freq.put("aug", 27);
    freq.put("uww", 32);
    freq.put("ali", 365);
    freq.put("aul", 57);
    freq.put("up ", 137);
    freq.put("TV ", 53);
    freq.put("aus", 59);
    freq.put("lt ", 815);
    freq.put("Oke", 197);
    freq.put("gaa", 2525);
    freq.put("auw", 338);
    freq.put("G ", 266);
    freq.put("auz", 122);
    freq.put("ald", 261);
    freq.put(" Gv", 23);
    freq.put(" Gu", 39);
    freq.put(" Gr", 336);
    freq.put("til", 135);
    freq.put("rug", 634);
    freq.put("wja", 26);
    freq.put("ble", 236);
    freq.put(" Ge", 909);
    freq.put("unt", 364);
    freq.put(" Ga", 319);
    freq.put(" Go", 485);
    freq.put("air", 120);
    freq.put("ala", 129);
    freq.put(" Gi", 111);
    freq.put("Gv", 23);
    freq.put("Gu", 42);
    freq.put("Gr", 338);
    freq.put("MA ", 27);
    freq.put("ë", 161);
    freq.put("upe", 322);
    freq.put("AG ", 27);
    freq.put("Ok ", 49);
    freq.put("Ge", 933);
    freq.put("mw ", 66);
    freq.put("vn ", 23);
    freq.put("aas", 552);
    freq.put("Ga", 322);
    freq.put("slu", 120);
    freq.put("Go", 488);
    freq.put("VD ", 32);
    freq.put("Gi", 111);
    freq.put(" ka", 2934);
    freq.put(" kf", 22);
    freq.put(" kg", 31);
    freq.put(" ke", 1245);
    freq.put(" kk", 173);
    freq.put(" kh", 50);
    freq.put(" ki", 1665);
    freq.put(" kn", 329);
    freq.put(" ko", 2812);
    freq.put(" kl", 1359);
    freq.put(" km", 90);
    freq.put(" kr", 907);
    freq.put("scu", 44);
    freq.put(" kw", 444);
    freq.put(" ku", 1033);
    freq.put("orz", 63);
    freq.put("è ", 115);
    freq.put(" ky", 26);
    freq.put("alt", 1009);
    freq.put("nen", 2322);
    freq.put("nel", 532);
    freq.put("nem", 261);
    freq.put("nek", 89);
    freq.put("oze", 111);
    freq.put("nei", 39);
    freq.put("neg", 89);
    freq.put("ned", 268);
    freq.put("nee", 1709);
    freq.put("Z ", 83);
    freq.put("nec", 30);
    freq.put("nea", 26);
    freq.put("orv", 21);
    freq.put("abi", 52);
    freq.put("slo", 179);
    freq.put("vro", 651);
    freq.put("pin", 328);
    freq.put("ney", 51);
    freq.put("nev", 67);
    freq.put("dr ", 166);
    freq.put("ruz", 36);
    freq.put("scr", 38);
    freq.put("ner", 434);
    freq.put("nes", 179);
    freq.put("nep", 50);
    freq.put("Ff ", 75);
    freq.put("oee", 151);
    freq.put("dep", 38);
    freq.put(" k ", 541);
    freq.put("ecl", 78);
    freq.put("ait", 62);
    freq.put("TL ", 81);
    freq.put("mem", 24);
    freq.put("orr", 343);
    freq.put("men", 3170);
    freq.put("mei", 387);
    freq.put("ors", 238);
    freq.put("meu", 33);
    freq.put("met", 4842);
    freq.put("mev", 32);
    freq.put("urv", 38);
    freq.put("zat", 338);
    freq.put("mes", 115);
    freq.put("sle", 296);
    freq.put("mez", 94);
    freq.put("gli", 43);
    freq.put("dio", 155);
    freq.put("Zo", 867);
    freq.put("Zi", 276);
    freq.put("glo", 21);
    freq.put("aks", 324);
    freq.put("gla", 61);
    freq.put("k", 68171);
    freq.put("wn ", 253);
    freq.put("dru", 306);
    freq.put("gle", 126);
    freq.put("ne ", 1201);
    freq.put("akt", 786);
    freq.put("dri", 412);
    freq.put("akj", 49);
    freq.put("aki", 50);
    freq.put("orm", 387);
    freq.put("Kun", 53);
    freq.put("sjo", 21);
    freq.put("dro", 332);
    freq.put("tw", 2018);
    freq.put("dra", 439);
    freq.put("Zu", 102);
    freq.put("aka", 319);
    freq.put("Zw", 86);
    freq.put("dre", 183);
    freq.put("ake", 1207);
    freq.put("sje", 736);
    freq.put("Jer", 24);
    freq.put("ED ", 24);
    freq.put("tu", 1892);
    freq.put("sso", 49);
    freq.put("Koo", 35);
    freq.put("Kon", 43);
    freq.put("Jez", 28);
    freq.put("bru", 339);
    freq.put("Koe", 25);
    freq.put("bro", 525);
    freq.put("Naa", 142);
    freq.put("bri", 187);
    freq.put("Jee", 33);
    freq.put("bre", 249);
    freq.put("Kor", 29);
    freq.put("aak", 1112);
    freq.put("OR ", 27);
    freq.put("m ", 7505);
    freq.put("dni", 26);
    freq.put("lme", 66);
    freq.put("vol", 1131);
    freq.put("aur", 104);
    freq.put("er ", 19450);
    freq.put("det", 41);
    freq.put("ora", 154);
    freq.put("ni ", 106);
    freq.put("Zeg", 54);
    freq.put("lwe", 268);
    freq.put("ssi", 341);
    freq.put("nka", 57);
    freq.put("ir", 739);
    freq.put("nke", 952);
    freq.put("ucc", 177);
    freq.put("Maa", 697);
    freq.put("nki", 51);
    freq.put("nkj", 226);
    freq.put("Sto", 74);
    freq.put("nkl", 47);
    freq.put("Sti", 35);
    freq.put("Ooh", 23);
    freq.put("kga", 34);
    freq.put("kst", 157);
    freq.put("Je ", 477);
    freq.put("nks", 157);
    freq.put("kge", 31);
    freq.put("web", 119);
    freq.put("Str", 122);
    freq.put("V", 2437);
    freq.put("oez", 94);
    freq.put("nkz", 33);
    freq.put("iv", 479);
    freq.put("tmo", 37);
    freq.put("jme", 54);
    freq.put("me", 16931);
    freq.put("md", 596);
    freq.put("mg", 281);
    freq.put("mf", 33);
    freq.put("ma", 11552);
    freq.put("dn ", 31);
    freq.put("mc", 23);
    freq.put("mb", 571);
    freq.put("mm", 1624);
    freq.put("ml", 69);
    freq.put("mo", 6382);
    freq.put("mn", 846);
    freq.put("mi", 5343);
    freq.put("mh", 72);
    freq.put("mk", 92);
    freq.put("mj", 23);
    freq.put("mu", 525);
    freq.put("mt", 918);
    freq.put("mw", 129);
    freq.put("mv", 32);
    freq.put("mp", 805);
    freq.put("ms", 1137);
    freq.put("mr", 88);
    freq.put("erl", 1432);
    freq.put("erm", 427);
    freq.put("ern", 486);
    freq.put("ero", 350);
    freq.put("my", 187);
    freq.put("eri", 1142);
    freq.put("erj", 134);
    freq.put("mz", 29);
    freq.put("Lie", 75);
    freq.put("Le", 634);
    freq.put("Nat", 41);
    freq.put("La", 350);
    freq.put("Lo", 219);
    freq.put("Lin", 40);
    freq.put("uar", 29);
    freq.put("la ", 241);
    freq.put("uts", 73);
    freq.put("Lij", 28);
    freq.put("Li", 318);
    freq.put("tzi", 49);
    freq.put("ov ", 50);
    freq.put("Lu", 84);
    freq.put("wc ", 37);
    freq.put("hof", 31);
    freq.put("hog", 56);
    freq.put("enb", 202);
    freq.put("ib", 170);
    freq.put("end", 2749);
    freq.put("hoc", 103);
    freq.put("enf", 36);
    freq.put("eng", 452);
    freq.put("hon", 383);
    freq.put("ie", 27753);
    freq.put("hol", 174);
    freq.put("hom", 114);
    freq.put("enl", 421);
    freq.put("hok", 27);
    freq.put("Al ", 81);
    freq.put("hoi", 38);
    freq.put("hov", 48);
    freq.put("how", 71);
    freq.put("hot", 110);
    freq.put("hou", 798);
    freq.put("hor", 194);
    freq.put("enu", 91);
    freq.put("hop", 287);
    freq.put("enw", 148);
    freq.put("sse", 1138);
    freq.put("enz", 280);
    freq.put("aid", 39);
    freq.put("A", 3422);
    freq.put("dho", 47);
    freq.put("lan", 2071);
    freq.put("pig", 177);
    freq.put("lai", 41);
    freq.put("L ", 451);
    freq.put("lak", 111);
    freq.put("lad", 195);
    freq.put("mpj", 107);
    freq.put("lag", 331);
    freq.put("ngb", 23);
    freq.put("laa", 2518);
    freq.put("lac", 426);
    freq.put("ova", 34);
    freq.put("lax", 44);
    freq.put("lay", 65);
    freq.put("laz", 43);
    freq.put("ove", 2499);
    freq.put("lat", 557);
    freq.put("lau", 127);
    freq.put("lav", 36);
    freq.put("pt ", 599);
    freq.put("lap", 1019);
    freq.put("ou ", 2404);
    freq.put("lar", 95);
    freq.put("las", 553);
    freq.put("en ", 56306);
    freq.put("All", 204);
    freq.put("Alm", 28);
    freq.put("ho ", 44);
    freq.put("fak", 30);
    freq.put("cat", 140);
    freq.put("mpt", 24);
    freq.put("lou", 45);
    freq.put("mpu", 62);
    freq.put("vou", 26);
    freq.put("Alw", 37);
    freq.put("Alt", 75);
    freq.put("Als", 424);
    freq.put(" V ", 27);
    freq.put(" Hy", 36);
    freq.put("zeg", 1019);
    freq.put("zee", 142);
    freq.put("zek", 345);
    freq.put("fam", 98);
    freq.put("zen", 684);
    freq.put(" Hu", 146);
    freq.put("loz", 31);
    freq.put("zer", 113);
    freq.put("zes", 41);
    freq.put(" Hi", 300);
    freq.put("pge", 200);
    freq.put(" Ho", 810);
    freq.put("oef", 283);
    freq.put(" Hm", 69);
    freq.put("zeu", 35);
    freq.put(" Ha", 1148);
    freq.put("uwa", 25);
    freq.put(" He", 1747);
    freq.put("ono", 97);
    freq.put("ima", 128);
    freq.put("fis", 26);
    freq.put("imb", 44);
    freq.put("ime", 229);
    freq.put("cli", 53);
    freq.put("fit", 65);
    freq.put(" f ", 32);
    freq.put("imi", 41);
    freq.put("cle", 27);
    freq.put("bep", 64);
    freq.put("imm", 70);
    freq.put("cla", 103);
    freq.put("imo", 36);
    freq.put("ssa", 169);
    freq.put("imp", 63);
    freq.put("ims", 25);
    freq.put("fif", 22);
    freq.put("Hie", 66);
    freq.put("uck", 267);
    freq.put("fie", 586);
    freq.put("Hih", 38);
    freq.put("clu", 110);
    freq.put("Hij", 129);
    freq.put("uwd", 162);
    freq.put("Hil", 27);
    freq.put("fil", 348);
    freq.put(" Va", 712);
    freq.put("Ey ", 30);
    freq.put("ze ", 2665);
    freq.put("ona", 182);
    freq.put(" Ve", 453);
    freq.put("au ", 74);
    freq.put(" Vi", 160);
    freq.put(" Vl", 39);
    freq.put(" Vo", 585);
    freq.put("ong", 893);
    freq.put(" Vr", 198);
    freq.put("oks", 35);
    freq.put("ond", 3293);
    freq.put(" H ", 44);
    freq.put("cas", 67);
    freq.put("zei", 233);
    freq.put("im ", 181);
    freq.put("den", 4631);
    freq.put("zwa", 266);
    freq.put("ssc", 240);
    freq.put("l", 75538);
    freq.put("tsb", 23);
    freq.put("fi ", 57);
    freq.put("ony", 31);
    freq.put("upd", 56);
    freq.put("too", 164);
    freq.put("deo", 116);
    freq.put("nik", 454);
    freq.put("Wow", 41);
    freq.put("mda", 375);
    freq.put("mde", 57);
    freq.put("Woo", 66);
    freq.put("eum", 32);
    freq.put("mbo", 60);
    freq.put("nt ", 2674);
    freq.put("ofn", 24);
    freq.put("rt", 4282);
    freq.put("gol", 54);
    freq.put("goo", 292);
    freq.put("gon", 108);
    freq.put(" zi", 5158);
    freq.put("won", 292);
    freq.put("rr", 1411);
    freq.put("rs", 4540);
    freq.put("goe", 1708);
    freq.put("god", 91);
    freq.put("dst", 327);
    freq.put("goa", 41);
    freq.put("ry", 471);
    freq.put("goc", 23);
    freq.put("rd", 6449);
    freq.put("re", 9790);
    freq.put("rf", 304);
    freq.put("rg", 3396);
    freq.put(" zy", 32);
    freq.put("ra", 6556);
    freq.put("rb", 747);
    freq.put("rc", 312);
    freq.put("gou", 36);
    freq.put("got", 25);
    freq.put(" zw", 405);
    freq.put("is ", 8389);
    freq.put("rh", 505);
    freq.put("ri", 7009);
    freq.put("rj", 225);
    freq.put("gor", 28);
    freq.put("ntz", 30);
    freq.put("nts", 125);
    freq.put("ntr", 287);
    freq.put("ntu", 41);
    freq.put("ntw", 195);
    freq.put("ntv", 86);
    freq.put("nti", 521);
    freq.put("nth", 71);
    freq.put("ntj", 355);
    freq.put("ntm", 32);
    freq.put("Twe", 113);
    freq.put("W", 4268);
    freq.put("nta", 371);
    freq.put("tpa", 30);
    freq.put("ntb", 113);
    freq.put("nte", 1340);
    freq.put("ntd", 31);
    freq.put("ada", 92);
    freq.put("ate", 1378);
    freq.put("atc", 26);
    freq.put("Vie", 24);
    freq.put("iss", 692);
    freq.put("ato", 77);
    freq.put("isp", 23);
    freq.put("isw", 175);
    freq.put("go ", 80);
    freq.put("ath", 63);
    freq.put("ist", 1311);
    freq.put("isk", 139);
    freq.put("isj", 285);
    freq.put("isi", 115);
    freq.put("ish", 64);
    freq.put("iso", 26);
    freq.put("isn", 21);
    freq.put("ism", 35);
    freq.put("isl", 33);
    freq.put("isc", 446);
    freq.put("isb", 41);
    freq.put("isa", 92);
    freq.put("dec", 85);
    freq.put("isg", 40);
    freq.put("be ", 129);
    freq.put("ise", 161);
    freq.put("isd", 29);
    freq.put("nhe", 81);
    freq.put("Dui", 96);
    freq.put("nha", 74);
    freq.put("gy ", 29);
    freq.put("uks", 62);
    freq.put("nho", 80);
    freq.put("on ", 2243);
    freq.put("pir", 62);
    freq.put("tsj", 35);
    freq.put("nhu", 67);
    freq.put("tek", 337);
    freq.put("jjj", 21);
    freq.put("jke", 1357);
    freq.put("tel", 1161);
    freq.put("Dus", 174);
    freq.put("me ", 3738);
    freq.put("Kla", 98);
    freq.put("lmp", 87);
    freq.put("tor", 298);
    freq.put("Cen", 26);
    freq.put("lm ", 177);
    freq.put("equ", 23);
    freq.put("euh", 30);
    freq.put("tot", 677);
    freq.put("tou", 61);
    freq.put("tok", 57);
    freq.put("xtr", 75);
    freq.put("nz ", 34);
    freq.put("ton", 237);
    freq.put("kie", 257);
    freq.put("tol", 37);
    freq.put("tom", 169);
    freq.put("tob", 140);
    freq.put("toc", 1217);
    freq.put("kt ", 2025);
    freq.put("tog", 145);
    freq.put("arh", 49);
    freq.put("toe", 1089);
    freq.put(" le", 3850);
    freq.put("B", 3017);
    freq.put("uip", 44);
    freq.put("uki", 21);
    freq.put(" la", 2489);
    freq.put(" lo", 980);
    freq.put("gym", 71);
    freq.put(" ll", 59);
    freq.put(" li", 1997);
    freq.put(" lu", 546);
    freq.put("Fuc", 44);
    freq.put(" ly", 38);
    freq.put("jj ", 41);
    freq.put("ain", 344);
    freq.put("vac", 23);
    freq.put("lla", 279);
    freq.put("Ser", 25);
    freq.put("tsi", 36);
    freq.put("bek", 236);
    freq.put("avo", 1012);
    freq.put("zev", 22);
    freq.put(" ¤ ", 35);
    freq.put("aal", 2019);
    freq.put("nza", 25);
    freq.put("kto", 141);
    freq.put("Pvd", 22);
    freq.put("nze", 356);
    freq.put("Loo", 36);
    freq.put("kte", 273);
    freq.put("nzi", 85);
    freq.put("nzo", 191);
    freq.put("kta", 22);
    freq.put("gg ", 86);
    freq.put("raf", 148);
    freq.put("rag", 321);
    freq.put("rad", 208);
    freq.put("ew ", 87);
    freq.put("rab", 90);
    freq.put("rac", 500);
    freq.put("Sla", 123);
    freq.put("raa", 1624);
    freq.put("ran", 825);
    freq.put("epr", 92);
    freq.put("ral", 178);
    freq.put("ram", 268);
    freq.put("ty ", 176);
    freq.put("rak", 451);
    freq.put("ose", 69);
    freq.put("rai", 293);
    freq.put("rav", 77);
    freq.put("Q ", 24);
    freq.put("rat", 518);
    freq.put("rau", 34);
    freq.put("rar", 90);
    freq.put("ras", 113);
    freq.put("rap", 401);
    freq.put("dur", 99);
    freq.put("uni", 109);
    freq.put("bs ", 40);
    freq.put("nba", 62);
    freq.put("Ass", 26);
    freq.put("Jus", 30);
    freq.put("eud", 47);
    freq.put("rte", 625);
    freq.put("do ", 116);
    freq.put("epl", 84);
    freq.put("teu", 130);
    freq.put("hul", 108);
    freq.put("piz", 42);
    freq.put("Omw", 30);
    freq.put("tev", 158);
    freq.put("ogt", 38);
    freq.put(" fe", 326);
    freq.put("hun", 191);
    freq.put("mpe", 155);
    freq.put("lp ", 79);
    freq.put("tyl", 32);
    freq.put("wd ", 141);
    freq.put("AH ", 83);
    freq.put("Qu", 22);
    freq.put("thi", 64);
    freq.put("ra ", 309);
    freq.put("aba", 63);
    freq.put("tyd", 32);
    freq.put("huh", 52);
    freq.put("ugg", 82);
    freq.put("rsa", 22);
    freq.put(" fi", 1000);
    freq.put("ogs", 74);
    freq.put("Rus", 34);
    freq.put("rsc", 346);
    freq.put("typ", 94);
    freq.put("abe", 71);
    freq.put("dok", 43);
    freq.put("don", 256);
    freq.put("doo", 1384);
    freq.put("dol", 35);
    freq.put("dom", 190);
    freq.put("doc", 112);
    freq.put("lpu", 22);
    freq.put("lpt", 35);
    freq.put("m", 56067);
    freq.put("dod", 31);
    freq.put("doe", 2659);
    freq.put("uda", 21);
    freq.put("tha", 149);
    freq.put("lph", 22);
    freq.put("dor", 112);
    freq.put("ogi", 97);
    freq.put("dop", 36);
    freq.put("dow", 119);
    freq.put("dou", 254);
    freq.put(" We", 972);
    freq.put("udd", 42);
    freq.put("Kli", 23);
    freq.put(" Wa", 1518);
    freq.put("api", 74);
    freq.put(" Wo", 306);
    freq.put("ude", 783);
    freq.put(" Wh", 110);
    freq.put(" Wi", 913);
    freq.put("oge", 502);
    freq.put(" Wt", 40);
    freq.put("xox", 34);
    freq.put("én", 94);
    freq.put("éc", 21);
    freq.put("ké ", 51);
    freq.put("ogg", 53);
    freq.put("rta", 87);
    freq.put("Bin", 50);
    freq.put("och", 1818);
    freq.put("ock", 165);
    freq.put("Bij", 217);
    freq.put("em ", 1066);
    freq.put("oco", 81);
    freq.put("kun", 773);
    freq.put("oca", 72);
    freq.put("oga", 51);
    freq.put("Bie", 38);
    freq.put("oce", 66);
    freq.put("abr", 23);
    freq.put("zak", 171);
    freq.put("ama", 302);
    freq.put("hro", 33);
    freq.put("hri", 262);
    freq.put("NU ", 31);
    freq.put("ba ", 26);
    freq.put("ngr", 114);
    freq.put("hre", 99);
    freq.put("lta", 56);
    freq.put("ocr", 21);
    freq.put("ocu", 31);
    freq.put("dn", 99);
    freq.put("do", 5427);
    freq.put("dl", 134);
    freq.put("dm", 125);
    freq.put("dj", 814);
    freq.put("dk", 123);
    freq.put("dh", 143);
    freq.put("di", 7538);
    freq.put("df", 76);
    freq.put("dg", 98);
    freq.put("dd", 1089);
    freq.put("de", 25067);
    freq.put("db", 107);
    freq.put("dc", 34);
    freq.put("da", 16155);
    freq.put("ga ", 1522);
    freq.put("bei", 113);
    freq.put("dz", 70);
    freq.put("dy", 166);
    freq.put("dv", 220);
    freq.put("dw", 190);
    freq.put("dt", 845);
    freq.put("du", 1828);
    freq.put("dr", 1863);
    freq.put("ds", 1662);
    freq.put("dp", 115);
    freq.put(" el", 446);
    freq.put("eme", 740);
    freq.put("emd", 125);
    freq.put("bat", 84);
    freq.put("neu", 136);
    freq.put("ema", 1976);
    freq.put("CK ", 22);
    freq.put("emb", 247);
    freq.put("emm", 122);
    freq.put("emo", 290);
    freq.put("emi", 260);
    freq.put("dA", 25);
    freq.put("emt", 102);
    freq.put("bad", 106);
    freq.put("Rij", 47);
    freq.put("emp", 107);
    freq.put("ems", 40);
    freq.put("ump", 29);
    freq.put("ban", 480);
    freq.put("ldw", 24);
    freq.put("bal", 462);
    freq.put("bam", 22);
    freq.put(" em", 131);
    freq.put("bah", 43);
    freq.put("dsp", 21);
    freq.put("mee", 2487);
    freq.put("om ", 3091);
    freq.put("w ", 2011);
    freq.put("Pet", 32);
    freq.put("PS ", 21);
    freq.put("nuu", 87);
    freq.put("nur", 21);
    freq.put("nus", 29);
    freq.put("Per", 43);
    freq.put("éé", 85);
    freq.put("num", 183);
    freq.put("nui", 57);
    freq.put(" I ", 93);
    freq.put("oma", 309);
    freq.put(" en", 7792);
    freq.put("aan", 5666);
    freq.put("azi", 52);
    freq.put("muu", 23);
    freq.put("bez", 313);
    freq.put("yer", 35);
    freq.put("il ", 1533);
    freq.put("xD ", 140);
    freq.put("irr", 118);
    freq.put("irt", 82);
    freq.put("muz", 215);
    freq.put("un ", 423);
    freq.put("iri", 46);
    freq.put("mug", 34);
    freq.put("irl", 39);
    freq.put("mel", 356);
    freq.put("Tri", 29);
    freq.put("ira", 65);
    freq.put("irc", 22);
    freq.put("ird", 21);
    freq.put("ire", 174);
    freq.put("Rut", 27);
    freq.put("pni", 52);
    freq.put("omb", 67);
    freq.put("C", 1149);
    freq.put("wd", 185);
    freq.put("wc", 45);
    freq.put("wb", 46);
    freq.put("wa", 8063);
    freq.put("elk", 749);
    freq.put("wo", 3771);
    freq.put("wn", 388);
    freq.put(" Ir", 21);
    freq.put(" Is", 253);
    freq.put(" It", 32);
    freq.put("wj", 36);
    freq.put("wi", 4968);
    freq.put("wh", 334);
    freq.put("ww", 393);
    freq.put("wv", 22);
    freq.put("wu", 48);
    freq.put(" Ik", 2911);
    freq.put("ws", 415);
    freq.put("wr", 111);
    freq.put(" In", 473);
    freq.put("omt", 705);
    freq.put("eln", 40);
    freq.put(" Ie", 186);
    freq.put("nu ", 2080);
    freq.put("elo", 476);
    freq.put("DM ", 44);
    freq.put("gge", 704);
    freq.put("ild", 194);
    freq.put("ile", 281);
    freq.put("ilb", 42);
    freq.put("ell", 1233);
    freq.put("GB ", 22);
    freq.put("ila", 85);
    freq.put("alv", 153);
    freq.put("ilo", 76);
    freq.put("ill", 809);
    freq.put("ilm", 323);
    freq.put("ilj", 79);
    freq.put("tt ", 172);
    freq.put("ili", 374);
    freq.put("ilv", 32);
    freq.put("una", 22);
    freq.put("ilt", 248);
    freq.put("kza", 33);
    freq.put("und", 235);
    freq.put("ils", 52);
    freq.put("unf", 24);
    freq.put("elc", 27);
    freq.put("ir ", 82);
    freq.put("gga", 37);
    freq.put("unk", 25);
    freq.put("com", 308);
    freq.put("col", 227);
    freq.put("fni", 22);
    freq.put("con", 538);
    freq.put("kwa", 318);
    freq.put(" me", 11950);
    freq.put("ela", 751);
    freq.put("kwe", 84);
    freq.put(" ma", 7696);
    freq.put("ead", 67);
    freq.put("kwi", 135);
    freq.put(" mm", 64);
    freq.put(" mn", 740);
    freq.put(" mo", 5502);
    freq.put(" mi", 3961);
    freq.put("kwo", 22);
    freq.put("elg", 76);
    freq.put(" mt", 24);
    freq.put(" mu", 376);
    freq.put("ië", 101);
    freq.put(" mw", 50);
    freq.put("Iem", 57);
    freq.put(" mr", 44);
    freq.put(" ms", 213);
    freq.put("wh ", 48);
    freq.put("ele", 2544);
    freq.put(" my", 129);
    freq.put("mpi", 101);
    freq.put("fra", 112);
    freq.put("eag", 137);
    freq.put("che", 1189);
    freq.put("fre", 60);
    freq.put("ak ", 869);
    freq.put("ggi", 39);
    freq.put("fri", 127);
    freq.put("C ", 262);
    freq.put("fro", 35);
    freq.put("gn ", 29);
    freq.put("fru", 22);
    freq.put("agd", 97);
    freq.put("pro", 822);
    freq.put("BB ", 29);
    freq.put("ano", 113);
    freq.put(" m ", 712);
    freq.put("Rot", 60);
    freq.put("pri", 375);
    freq.put("xxx", 301);
    freq.put("Utr", 74);
    freq.put("ank", 1259);
    freq.put("elp", 217);
    freq.put("pad", 49);
    freq.put("moe", 2899);
    freq.put("pru", 70);
    freq.put("Ci", 50);
    freq.put("Ch", 223);
    freq.put("Co", 281);
    freq.put("Cl", 39);
    freq.put("deu", 123);
    freq.put("elv", 41);
    freq.put("Ca", 150);
    freq.put(" yo", 154);
    freq.put("Ce", 43);
    freq.put("n", 175899);
    freq.put("ail", 238);
    freq.put("ET ", 132);
    freq.put("gna", 25);
    freq.put("Zoo", 49);
    freq.put("Gaa", 102);
    freq.put("gne", 58);
    freq.put("aie", 120);
    freq.put("Cr", 46);
    freq.put("aig", 22);
    freq.put("sla", 1674);
    freq.put("Cu", 38);
    freq.put("ix", 106);
    freq.put("iz", 363);
    freq.put("rtu", 78);
    freq.put("bio", 134);
    freq.put("iq", 35);
    freq.put("ip", 776);
    freq.put("is", 12374);
    freq.put(" ef", 95);
    freq.put("iu", 73);
    freq.put("it", 8666);
    freq.put("Za", 168);
    freq.put("ii", 275);
    freq.put("ih", 398);
    freq.put("ik", 13181);
    freq.put("ij", 22877);
    freq.put("im", 914);
    freq.put("il", 4221);
    freq.put("io", 942);
    freq.put("in", 19759);
    freq.put("ia", 1220);
    freq.put("opp", 368);
    freq.put("ic", 2339);
    freq.put("ki ", 51);
    freq.put("jk ", 2937);
    freq.put("id", 2501);
    freq.put("ig", 5035);
    freq.put("if", 296);
    freq.put("V ", 214);
    freq.put("akk", 876);
    freq.put("Afg", 29);
    freq.put("Tro", 40);
    freq.put("art", 1314);
    freq.put("iP", 118);
    freq.put("dhe", 54);
    freq.put("any", 24);
    freq.put("ld ", 1057);
    freq.put("anz", 65);
    freq.put("Die", 292);
    freq.put("ep ", 436);
    freq.put("th ", 71);
    freq.put("nij", 65);
    freq.put("Int", 72);
    freq.put("Na ", 90);
    freq.put("Woe", 43);
    freq.put("nin", 644);
    freq.put("nio", 25);
    freq.put("nim", 23);
    freq.put("jkt", 315);
    freq.put("nic", 212);
    freq.put("kip", 78);
    freq.put("nig", 385);
    freq.put("jks", 100);
    freq.put("kik", 21);
    freq.put("kij", 1240);
    freq.put("jkh", 51);
    freq.put("kin", 645);
    freq.put("kim", 23);
    freq.put("kil", 83);
    freq.put("Y", 290);
    freq.put("i ", 2433);
    freq.put("nip", 37);
    freq.put("kig", 242);
    freq.put("jkb", 39);
    freq.put("kid", 68);
    freq.put("Va", 714);
    freq.put("sja", 47);
    freq.put("Ve", 459);
    freq.put("noe", 337);
    freq.put("sme", 100);
    freq.put("Vi", 164);
    freq.put("ept", 177);
    freq.put(" L ", 74);
    freq.put("Vl", 42);
    freq.put("eps", 78);
    freq.put("epp", 63);
    freq.put("Vo", 588);
    freq.put("tho", 119);
    freq.put("epo", 51);
    freq.put("Vr", 213);
    freq.put("Ik ", 2881);
    freq.put("epj", 37);
    freq.put("asi", 95);
    freq.put("enj", 29);
    freq.put("epi", 71);
    freq.put("the", 408);
    freq.put("epe", 222);
    freq.put("dev", 27);
    freq.put("epa", 187);
    freq.put("nk ", 1162);
    freq.put("cam", 95);
    freq.put("dse", 119);
    freq.put("yen", 114);
    freq.put("yea", 61);
    freq.put("zol", 38);
    freq.put("rn ", 99);
    freq.put("nci", 60);
    freq.put("Dit", 161);
    freq.put("via", 416);
    freq.put("op ", 6336);
    freq.put("tin", 620);
    freq.put("lco", 49);
    freq.put("Kom", 165);
    freq.put("yes", 46);
    freq.put("Ech", 114);
    freq.put("bak", 134);
    freq.put("bit", 106);
    freq.put("vig", 22);
    freq.put("hah", 4993);
    freq.put("hai", 37);
    freq.put("elh", 29);
    freq.put("hak", 87);
    freq.put("hal", 913);
    freq.put("ham", 100);
    freq.put("han", 657);
    freq.put("elm", 55);
    freq.put("elb", 55);
    freq.put("haa", 1333);
    freq.put("hac", 23);
    freq.put("had", 1007);
    freq.put("hae", 28);
    freq.put("eld", 1481);
    freq.put("hag", 60);
    freq.put("elz", 21);
    freq.put("vd ", 107);
    freq.put("ely", 34);
    freq.put("jy ", 45);
    freq.put("tlo", 31);
    freq.put("hap", 257);
    freq.put("els", 563);
    freq.put("har", 619);
    freq.put("has", 21);
    freq.put("hat", 578);
    freq.put("hau", 34);
    freq.put("hav", 46);
    freq.put("elu", 436);
    freq.put("opt", 441);
    freq.put("rni", 83);
    freq.put("rnh", 36);
    freq.put("rno", 65);
    freq.put("D", 5622);
    freq.put("opr", 83);
    freq.put("ops", 189);
    freq.put("Tra", 52);
    freq.put("ye ", 32);
    freq.put("rna", 361);
    freq.put("Tre", 21);
    freq.put("rne", 295);
    freq.put("opd", 99);
    freq.put("cho", 1360);
    freq.put("opg", 206);
    freq.put("opa", 103);
    freq.put("opb", 32);
    freq.put("rns", 25);
    freq.put("opm", 66);
    freq.put("opn", 76);
    freq.put("TF ", 25);
    freq.put("oph", 106);
    freq.put("opi", 76);
    freq.put("opj", 78);
    freq.put("opk", 26);
    freq.put("oni", 290);
    freq.put("zel", 1123);
    freq.put("vis", 144);
    freq.put("ha ", 2441);
    freq.put("mr ", 35);
    freq.put("el ", 7770);
    freq.put("ï", 43);
    freq.put("mit", 41);
    freq.put("lja", 42);
    freq.put("weg", 831);
    freq.put("Are", 22);
    freq.put("bn ", 30);
    freq.put("aud", 34);
    freq.put("Arn", 26);
    freq.put("Ga ", 130);
    freq.put("ola", 157);
    freq.put("www", 167);
    freq.put("tub", 37);
    freq.put("old", 199);
    freq.put("ole", 168);
    freq.put("olf", 81);
    freq.put("olg", 948);
    freq.put(" Ju", 140);
    freq.put("oli", 329);
    freq.put(" X ", 34);
    freq.put("oll", 721);
    freq.put("olo", 116);
    freq.put("olp", 26);
    freq.put(" Jo", 285);
    freq.put("ols", 60);
    freq.put(" Ji", 185);
    freq.put("olu", 42);
    freq.put("olw", 29);
    freq.put(" Je", 628);
    freq.put("noc", 65);
    freq.put("jep", 22);
    freq.put(" Ja", 707);
    freq.put("wha", 192);
    freq.put("ick", 250);
    freq.put("fou", 113);
    freq.put("ici", 332);
    freq.put("Hy", 36);
    freq.put("ico", 54);
    freq.put("Lee", 112);
    freq.put("for", 179);
    freq.put("tei", 155);
    freq.put("Lei", 22);
    freq.put("ica", 147);
    freq.put("Lek", 212);
    freq.put("ice", 205);
    freq.put("Hu", 147);
    freq.put("ume", 59);
    freq.put("foe", 38);
    freq.put("Hi", 301);
    freq.put("Let", 36);
    freq.put("Ho", 813);
    freq.put("Hm", 69);
    freq.put("fol", 157);
    freq.put("fon", 37);
    freq.put("Ha", 1152);
    freq.put("dia", 148);
    freq.put("ict", 38);
    freq.put("ol ", 1253);
    freq.put("plu", 46);
    freq.put("who", 26);
    freq.put("upl", 28);
    freq.put("buu", 100);
    freq.put("ple", 499);
    freq.put(" Xx", 37);
    freq.put("ww ", 186);
    freq.put("pla", 684);
    freq.put("plo", 151);
    freq.put(" J ", 27);
    freq.put("pli", 96);
    freq.put("obo", 23);
    freq.put("obl", 130);
    freq.put("eef", 1591);
    freq.put("obi", 189);
    freq.put("ic ", 96);
    freq.put("obb", 41);
    freq.put("o", 126700);
    freq.put("oba", 33);
    freq.put("zuc", 31);
    freq.put("ome", 1326);
    freq.put("ai ", 164);
    freq.put("fo ", 72);
    freq.put("um ", 329);
    freq.put("H ", 203);
    freq.put("zui", 106);
    freq.put("gec", 47);
    freq.put("obs", 23);
    freq.put("zul", 118);
    freq.put("okt", 211);
    freq.put("mbl", 23);
    freq.put("soc", 79);
    freq.put("Fee", 25);
    freq.put("soe", 53);
    freq.put("chu", 165);
    freq.put("ppe", 747);
    freq.put("sof", 101);
    freq.put("Vee", 108);
    freq.put("mbe", 225);
    freq.put("ppi", 305);
    freq.put("Uit", 101);
    freq.put("som", 303);
    freq.put("sol", 45);
    freq.put("soo", 208);
    freq.put("son", 151);
    freq.put("sop", 26);
    freq.put("oin", 45);
    freq.put("sor", 179);
    freq.put("Fer", 35);
    freq.put("ën ", 33);
    freq.put("sow", 88);
    freq.put("rv", 786);
    freq.put("ijt", 329);
    freq.put("ppy", 24);
    freq.put("awe", 69);
    freq.put("Fey", 55);
    freq.put("tem", 339);
    freq.put(" éé", 64);
    freq.put("wam", 116);
    freq.put("git", 52);
    freq.put("gis", 317);
    freq.put("gir", 30);
    freq.put("Pff", 133);
    freq.put("wag", 89);
    freq.put("eac", 102);
    freq.put("waa", 1435);
    freq.put("lsc", 28);
    freq.put("olh", 24);
    freq.put("gie", 167);
    freq.put("Ita", 24);
    freq.put("rw", 719);
    freq.put("way", 33);
    freq.put("aii", 32);
    freq.put("gio", 63);
    freq.put("gin", 1016);
    freq.put("Din", 34);
    freq.put("gil", 32);
    freq.put("was", 1606);
    freq.put("war", 650);
    freq.put("so ", 241);
    freq.put("ah ", 798);
    freq.put("pp ", 159);
    freq.put("Tij", 77);
    freq.put("TE ", 33);
    freq.put("ues", 28);
    freq.put("Eer", 114);
    freq.put("xy ", 41);
    freq.put("Een", 322);
    freq.put("ME ", 35);
    freq.put("low", 242);
    freq.put("Z", 2011);
    freq.put("ura", 72);
    freq.put("eën", 25);
    freq.put("lwa", 27);
    freq.put("ami", 180);
    freq.put("aja", 159);
    freq.put("iqu", 32);
    freq.put("Voo", 209);
    freq.put("aze", 83);
    freq.put("AA ", 29);
    freq.put("wa ", 45);
    freq.put("urm", 37);
    freq.put("olt", 36);
    freq.put("mte", 50);
    freq.put("nno", 60);
    freq.put("nnn", 143);
    freq.put("nni", 244);
    freq.put("Ste", 133);
    freq.put(" n ", 1135);
    freq.put("nne", 2376);
    freq.put("nna", 166);
    freq.put("afl", 62);
    freq.put("nsd", 186);
    freq.put("D ", 868);
    freq.put("nny", 43);
    freq.put("kho", 31);
    freq.put("tea", 102);
    freq.put("kha", 33);
    freq.put("afi", 44);
    freq.put("khe", 91);
    freq.put("Sta", 148);
    freq.put("nh", 320);
    freq.put("ni", 10403);
    freq.put("nj", 162);
    freq.put("nk", 3413);
    freq.put("nl", 1101);
    freq.put("nm", 466);
    freq.put("nn", 3352);
    freq.put("no", 5815);
    freq.put("not", 116);
    freq.put("na", 7485);
    freq.put("nb", 363);
    freq.put("nc", 544);
    freq.put("nd", 14071);
    freq.put("ne", 8669);
    freq.put("nf", 245);
    freq.put("ng", 7873);
    freq.put("nx", 72);
    freq.put("ny", 124);
    freq.put("nz", 701);
    freq.put("tio", 260);
    freq.put("nx ", 46);
    freq.put("tij", 1753);
    freq.put("ES ", 35);
    freq.put("np", 180);
    freq.put("tie", 2075);
    freq.put("nr", 199);
    freq.put("ns", 5589);
    freq.put("nt", 6576);
    freq.put("nu", 2817);
    freq.put("nv", 360);
    freq.put("nw", 332);
    freq.put(" ni", 7866);
    freq.put("fot", 425);
    freq.put("rdt", 515);
    freq.put("kve", 22);
    freq.put("E", 2878);
    freq.put(" nl", 298);
    freq.put(" no", 4532);
    freq.put("cor", 128);
    freq.put(" na", 4344);
    freq.put(" ne", 2374);
    freq.put("nn ", 212);
    freq.put("mun", 56);
    freq.put("ich", 1152);
    freq.put("tec", 46);
    freq.put("arz", 28);
    freq.put(" nr", 33);
    freq.put(" nu", 2300);
    freq.put(" Qu", 22);
    freq.put("FC ", 37);
    freq.put("Wie", 400);
    freq.put("fsc", 38);
    freq.put("ums", 23);
    freq.put("Stu", 40);
    freq.put("n ", 91058);
    freq.put("Win", 102);
    freq.put("lot", 247);
    freq.put("fsl", 34);
    freq.put("nkr", 37);
    freq.put("tse", 460);
    freq.put("fso", 79);
    freq.put("fsp", 86);
    freq.put("Wit", 24);
    freq.put("fst", 190);
    freq.put("urz", 30);
    freq.put("rk ", 722);
    freq.put("uiz", 104);
    freq.put("ti ", 89);
    freq.put("nab", 26);
    freq.put("Tru", 36);
    freq.put("roi", 22);
    freq.put("roj", 63);
    freq.put("rok", 231);
    freq.put("rol", 231);
    freq.put("rom", 760);
    freq.put("ron", 567);
    freq.put("roo", 756);
    freq.put("lls", 41);
    freq.put("rob", 339);
    freq.put("roc", 70);
    freq.put("rod", 135);
    freq.put("roe", 1277);
    freq.put("rof", 84);
    freq.put("rog", 146);
    freq.put("osi", 74);
    freq.put("osh", 36);
    freq.put("roz", 31);
    freq.put("osj", 22);
    freq.put("llo", 299);
    freq.put("ob ", 74);
    freq.put("lll", 105);
    freq.put("rop", 222);
    freq.put("ror", 32);
    freq.put("ros", 68);
    freq.put("rot", 414);
    freq.put("rou", 625);
    freq.put("rov", 70);
    freq.put("row", 29);
    freq.put("vet", 161);
    freq.put("Dag", 51);
    freq.put("ver", 6158);
    freq.put("Daa", 135);
    freq.put("gea", 46);
    freq.put("Dam", 50);
    freq.put("Dan", 342);
    freq.put("xd ", 154);
    freq.put("di ", 43);
    freq.put("vey", 32);
    freq.put("Dat", 368);
    freq.put("dba", 21);
    freq.put("vas", 291);
    freq.put("vee", 1304);
    freq.put("vec", 57);
    freq.put("Das", 28);
    freq.put("ven", 2751);
    freq.put("uma", 37);
    freq.put("vel", 325);
    freq.put("vem", 86);
    freq.put("aut", 329);
    freq.put("jve", 324);
    freq.put("Leu", 131);
    freq.put(" do", 4440);
    freq.put("Dre", 23);
    freq.put(" dn", 34);
    freq.put("ro ", 373);
    freq.put("foc", 41);
    freq.put("erv", 622);
    freq.put("umm", 196);
    freq.put("erw", 617);
    freq.put("erp", 272);
    freq.put("ll ", 344);
    freq.put("umo", 35);
    freq.put(" dj", 27);
    freq.put("Wes", 31);
    freq.put("din", 1051);
    freq.put("foo", 206);
    freq.put("err", 412);
    freq.put("gue", 30);
    freq.put("dik", 145);
    freq.put("die", 3799);
    freq.put("ers", 3826);
    freq.put("gun", 46);
    freq.put("dic", 162);
    freq.put("p", 31101);
    freq.put("ge ", 1486);
    freq.put("ve ", 635);
    freq.put("dit", 817);
    freq.put("diu", 29);
    freq.put("div", 43);
    freq.put("He", 1750);
    freq.put("dip", 21);
    freq.put("der", 5316);
    freq.put("dir", 76);
    freq.put("dis", 124);
    freq.put("htg", 23);
    freq.put("hte", 1457);
    freq.put("des", 126);
    freq.put("M ", 305);
    freq.put(" Yo", 58);
    freq.put("hto", 38);
    freq.put(" Ya", 21);
    freq.put("oid", 46);
    freq.put(" Ye", 119);
    freq.put("hti", 351);
    freq.put("ery", 35);
    freq.put("htw", 27);
    freq.put("htv", 23);
    freq.put("uk ", 1200);
    freq.put("htt", 93);
    freq.put("hts", 126);
    freq.put("erz", 296);
    freq.put("Gra", 90);
    freq.put("Gro", 154);
    freq.put("Rea", 30);
    freq.put("IN ", 44);
    freq.put("Reg", 63);
    freq.put("Gri", 52);
    freq.put("kti", 49);
    freq.put("erd", 2445);
    freq.put("rul", 30);
    freq.put("ugk", 26);
    freq.put("ere", 3471);
    freq.put("rum", 112);
    freq.put("erf", 183);
    freq.put("ek ", 2091);
    freq.put("oes", 377);
    freq.put("erg", 1169);
    freq.put("aaw", 30);
    freq.put("ruc", 60);
    freq.put("bo ", 63);
    freq.put("Bor", 22);
    freq.put("rva", 205);
    freq.put("era", 694);
    freq.put("Me", 810);
    freq.put("Bos", 32);
    freq.put("Ma", 1314);
    freq.put("erb", 414);
    freq.put("arb", 88);
    freq.put("ht ", 4166);
    freq.put("oew", 26);
    freq.put("Mo", 815);
    freq.put("Mn", 34);
    freq.put("Mi", 527);
    freq.put("spu", 83);
    freq.put("clo", 21);
    freq.put("Bou", 23);
    freq.put("Mu", 73);
    freq.put(" dw", 33);
    freq.put("ngg", 31);
    freq.put("O", 2862);
    freq.put("lop", 528);
    freq.put("dea", 93);
    freq.put("oet", 3278);
    freq.put("My", 24);
    freq.put("deb", 69);
    freq.put("or ", 5970);
    freq.put("zac", 24);
    freq.put("eko", 288);
    freq.put("ij ", 6913);
    freq.put("ekl", 56);
    freq.put("ekk", 1623);
    freq.put(" w ", 58);
    freq.put("eki", 123);
    freq.put("erh", 402);
    freq.put("eke", 2250);
    freq.put("bos", 70);
    freq.put("bot", 53);
    freq.put("bou", 181);
    freq.put("eka", 40);
    freq.put("dee", 504);
    freq.put("HA ", 186);
    freq.put("ata", 84);
    freq.put("bol", 54);
    freq.put("def", 27);
    freq.put("bon", 104);
    freq.put("Mor", 328);
    freq.put("ekw", 23);
    freq.put("boa", 22);
    freq.put("eku", 22);
    freq.put("erk", 2242);
    freq.put("eks", 159);
    freq.put("ekr", 112);
    freq.put("oen", 2125);
    freq.put("ugh", 27);
    freq.put("ard", 1138);
    freq.put("ipa", 29);
    freq.put("Bon", 21);
    freq.put("ipe", 43);
    freq.put("jar", 196);
    freq.put("iph", 57);
    freq.put("Boo", 26);
    freq.put("ipo", 54);
    freq.put("snu", 24);
    freq.put("ngi", 38);
    freq.put("ips", 84);
    freq.put("ipp", 134);
    freq.put("Lig", 27);
    freq.put("ipv", 41);
    freq.put("ipt", 47);
    freq.put("are", 587);
    freq.put("jan", 117);
    freq.put("ma ", 684);
    freq.put(" Ka", 375);
    freq.put("lms", 29);
    freq.put(" Ke", 133);
    freq.put("aye", 26);
    freq.put(" Kk", 26);
    freq.put(" Kh", 24);
    freq.put(" Ki", 221);
    freq.put(" Kn", 31);
    freq.put(" ij", 84);
    freq.put(" Kl", 193);
    freq.put("Boe", 58);
    freq.put(" Kr", 94);
    freq.put("msn", 205);
    freq.put(" ik", 11153);
    freq.put(" Kw", 31);
    freq.put(" Ku", 135);
    freq.put(" il", 38);
    freq.put("mse", 43);
    freq.put("oed", 2240);
    freq.put("ays", 21);
    freq.put("Mon", 32);
    freq.put("ooe", 28);
    freq.put("Bek", 44);
    freq.put("ip ", 210);
    freq.put("oof", 468);
    freq.put("Ben", 393);
    freq.put("jah", 60);
    freq.put("Bel", 82);
    freq.put("F", 1194);
    freq.put("oom", 236);
    freq.put("ool", 1153);
    freq.put("ooo", 1133);
    freq.put("Bea", 22);
    freq.put("ooi", 1632);
    freq.put("Eve", 146);
    freq.put("Bed", 77);
    freq.put("Bee", 73);
    freq.put("Bez", 21);
    freq.put("oot", 447);
    freq.put("oow", 135);
    freq.put("yk ", 46);
    freq.put("msj", 27);
    freq.put("oop", 732);
    freq.put("oos", 384);
    freq.put("oor", 8078);
    freq.put("Ber", 85);
    freq.put("Bes", 98);
    freq.put("Bet", 71);
    freq.put("ibi", 48);
    freq.put(" K ", 75);
    freq.put("Ron", 27);
    freq.put("uss", 464);
    freq.put("car", 114);
    freq.put("ulp", 56);
    freq.put("zuu", 22);
    freq.put("flu", 44);
    freq.put("ibe", 26);
    freq.put("ult", 118);
    freq.put(" ie", 1672);
    freq.put("fli", 123);
    freq.put("ulk", 44);
    freq.put("uli", 64);
    freq.put("Moe", 183);
    freq.put("flo", 50);
    freq.put("cal", 31);
    freq.put("fla", 63);
    freq.put("caa", 31);
    freq.put("ula", 97);
    freq.put("fle", 119);
    freq.put("caf", 24);
    freq.put("uld", 105);
    freq.put("ms ", 390);
    freq.put(" on", 2142);
    freq.put(" oo", 3595);
    freq.put(" ol", 51);
    freq.put(" om", 2279);
    freq.put(" oj", 25);
    freq.put(" ok", 778);
    freq.put(" oh", 227);
    freq.put("ger", 1218);
    freq.put(" of", 1775);
    freq.put(" og", 86);
    freq.put("spr", 573);
    freq.put(" oe", 149);
    freq.put("one", 498);
    freq.put(" oc", 100);
    freq.put(" oa", 22);
    freq.put("Til", 23);
    freq.put("spi", 234);
    freq.put("We ", 218);
    freq.put("spl", 46);
    freq.put("ter", 5520);
    freq.put("spo", 321);
    freq.put(" ov", 1706);
    freq.put(" ow", 80);
    freq.put("Mis", 119);
    freq.put(" ou", 418);
    freq.put(" or", 166);
    freq.put(" os", 22);
    freq.put(" op", 6777);
    freq.put("wrm", 44);
    freq.put("zn ", 122);
    freq.put("ST ", 23);
    freq.put("Wha", 74);
    freq.put("ase", 110);
    freq.put("rl", 2030);
    freq.put("rvi", 91);
    freq.put("wst", 21);
    freq.put("gh ", 72);
    freq.put("gez", 936);
    freq.put("s ", 32290);
    freq.put("oss", 153);
    freq.put("naa", 3453);
    freq.put("mas", 87);
    freq.put("sne", 510);
    freq.put("mat", 216);
    freq.put("ena", 274);
    freq.put("sno", 109);
    freq.put("ky ", 33);
    freq.put("wac", 479);
    freq.put(" o ", 276);
    freq.put("sni", 38);
    freq.put("maa", 6197);
    freq.put("mac", 122);
    freq.put("hoe", 1416);
    freq.put("ark", 299);
    freq.put("mad", 38);
    freq.put("mag", 481);
    freq.put("mai", 177);
    freq.put("lfe", 22);
    freq.put("mam", 201);
    freq.put("mal", 81);
    freq.put("ene", 951);
    freq.put("ght", 137);
    freq.put("sz", 57);
    freq.put("sy", 90);
    freq.put("cod", 54);
    freq.put("tl ", 55);
    freq.put("nl ", 242);
    freq.put("ss", 2838);
    freq.put("sr", 93);
    freq.put("gef", 190);
    freq.put("sp", 2224);
    freq.put("sw", 391);
    freq.put("sv", 193);
    freq.put("su", 779);
    freq.put(" cl", 138);
    freq.put("q", 465);
    freq.put("sj", 829);
    freq.put("si", 1554);
    freq.put("sh", 863);
    freq.put("so", 1576);
    freq.put("sn", 1200);
    freq.put("sm", 531);
    freq.put("hoo", 2777);
    freq.put("sc", 4251);
    freq.put("sb", 249);
    freq.put("sa", 1066);
    freq.put("sg", 181);
    freq.put("sf", 95);
    freq.put("se", 4655);
    freq.put("sd", 351);
    freq.put("Ru", 112);
    freq.put("eï", 30);
    freq.put("enk", 1214);
    freq.put("gee", 1780);
    freq.put("eë", 42);
    freq.put("nsi", 65);
    freq.put("lsn", 37);
    freq.put("Chi", 62);
    freq.put("ttp", 42);
    freq.put("no ", 167);
    freq.put("ppa", 107);
    freq.put("zus", 241);
    freq.put("enm", 119);
    freq.put("Jan", 81);
    freq.put("Re", 349);
    freq.put("Chr", 28);
    freq.put("Jam", 64);
    freq.put("tto", 57);
    freq.put("Ra", 148);
    freq.put("Jah", 22);
    freq.put("ttl", 33);
    freq.put("Zin", 30);
    freq.put("tta", 42);
    freq.put("Ro", 298);
    freq.put("Zij", 65);
    freq.put("Ri", 172);
    freq.put("tte", 1693);
    freq.put("Jaa", 90);
    freq.put(" aa", 3135);
    freq.put(" ab", 68);
    freq.put(" ac", 712);
    freq.put(" ad", 147);
    freq.put("gte", 63);
    freq.put(" af", 903);
    freq.put(" ag", 89);
    freq.put(" ah", 268);
    freq.put(" ai", 61);
    freq.put(" aj", 66);
    freq.put(" ak", 55);
    freq.put("jij", 1344);
    freq.put(" am", 153);
    freq.put(" an", 1097);
    freq.put(" ap", 214);
    freq.put(" ar", 226);
    freq.put("gts", 42);
    freq.put(" at", 64);
    freq.put(" au", 360);
    freq.put(" av", 404);
    freq.put(" aw", 43);
    freq.put("ent", 2383);
    freq.put("gel", 2133);
    freq.put("dij", 57);
    freq.put("tja", 57);
    freq.put("nom", 163);
    freq.put("non", 42);
    freq.put(" uw", 59);
    freq.put("tje", 2901);
    freq.put("env", 117);
    freq.put("ls ", 3055);
    freq.put("nod", 234);
    freq.put(" cc", 31);
    freq.put("Hol", 84);
    freq.put("nog", 2844);
    freq.put("kkr", 57);
    freq.put("ert", 1341);
    freq.put("kko", 48);
    freq.put("kki", 355);
    freq.put("kkk", 60);
    freq.put("kke", 2982);
    freq.put("sht", 22);
    freq.put("nov", 152);
    freq.put(" us", 25);
    freq.put("kka", 43);
    freq.put("Ja ", 346);
    freq.put("nos", 23);
    freq.put(" a ", 299);
    freq.put("bab", 95);
    freq.put("gal", 62);
    freq.put("eru", 637);
    freq.put("tti", 236);
    freq.put("omo", 101);
    freq.put(" wo", 2169);
    freq.put("aap", 397);
    freq.put("sou", 29);
    freq.put("ahw", 32);
    freq.put("em", 5160);
    freq.put("el", 20674);
    freq.put("eo", 328);
    freq.put("en", 74147);
    freq.put("ei", 4411);
    freq.put("eh", 1357);
    freq.put("ek", 7392);
    freq.put("ej", 228);
    freq.put("ee", 36290);
    freq.put("ed", 7686);
    freq.put("eg", 6088);
    freq.put("ef", 3454);
    freq.put("ea", 1403);
    freq.put("rl ", 39);
    freq.put("ec", 3969);
    freq.put("eb", 5556);
    freq.put("oké", 34);
    freq.put("Luc", 25);
    freq.put("ey", 587);
    freq.put("ex", 471);
    freq.put("ez", 2966);
    freq.put("eu", 4407);
    freq.put("et", 31066);
    freq.put("ew", 2271);
    freq.put("ev", 3822);
    freq.put("eq", 23);
    freq.put("ep", 1575);
    freq.put("es", 8689);
    freq.put("er", 43213);
    freq.put("EN ", 250);
    freq.put("Ken", 44);
    freq.put("ejo", 46);
    freq.put("Jou", 40);
    freq.put("sha", 100);
    freq.put("blu", 25);
    freq.put("Kee", 22);
    freq.put("Dom", 23);
    freq.put("eja", 29);
    freq.put("blo", 245);
    freq.put("bli", 836);
    freq.put("os ", 427);
    freq.put("Joh", 38);
    freq.put("bla", 227);
    freq.put("Ker", 21);
    freq.put("Jon", 79);
    freq.put(" ws", 35);
    freq.put("rlo", 205);
    freq.put("rli", 888);
    freq.put("RT ", 2523);
    freq.put("G", 2603);
    freq.put("wan", 675);
    freq.put("rle", 273);
    freq.put("rld", 29);
    freq.put("ort", 920);
    freq.put("oru", 52);
    freq.put("rla", 539);
    freq.put("e ", 66157);
    freq.put("orp", 113);
    freq.put("orn", 158);
    freq.put("rgs", 32);
    freq.put("orl", 130);
    freq.put("dig", 819);
    freq.put("ork", 109);
    freq.put("orh", 42);
    freq.put("ori", 327);
    freq.put("orf", 29);
    freq.put("org", 1930);
    freq.put("ord", 2652);
    freq.put("ore", 414);
    freq.put("orb", 206);
    freq.put("orc", 37);
    freq.put(" cd", 21);
    freq.put("cem", 44);
    freq.put("App", 76);
    freq.put("ej ", 104);
    freq.put("rgt", 30);
    freq.put("sms", 115);
    freq.put("coo", 214);
    freq.put("lie", 1980);
    freq.put("fc", 47);
    freq.put("dpi", 48);
    freq.put(" ce", 102);
    freq.put("nia", 73);
    freq.put("Ape", 26);
    freq.put("zan", 51);
    freq.put("onk", 172);
    freq.put("zal", 318);
    freq.put("xi", 81);
    freq.put("onn", 383);
    freq.put("xo", 90);
    freq.put("onl", 141);
    freq.put("onm", 56);
    freq.put("onb", 45);
    freq.put("xc", 53);
    freq.put("xa", 57);
    freq.put("onf", 30);
    freq.put(" Z ", 28);
    freq.put("xd", 491);
    freq.put("xe", 98);
    freq.put("onz", 273);
    freq.put("Dor", 32);
    freq.put("xx", 579);
    freq.put("xy", 51);
    freq.put("xpe", 27);
    freq.put("ua ", 22);
    freq.put("ons", 558);
    freq.put("xp", 90);
    freq.put("onv", 76);
    freq.put("onw", 50);
    freq.put("xt", 137);
    freq.put("Eur", 83);
    freq.put("iam", 26);
    freq.put("ial", 171);
    freq.put("ian", 116);
    freq.put("€ ", 154);
    freq.put("tni", 30);
    freq.put("ukt", 160);
    freq.put("iaa", 139);
    freq.put("xD", 416);
    freq.put("Hmm", 64);
    freq.put("Tot", 81);
    freq.put("usi", 99);
    freq.put("ukk", 427);
    freq.put("ukj", 77);
    freq.put("Jij", 161);
    freq.put("iat", 43);
    freq.put("uke", 388);
    freq.put("Dou", 33);
    freq.put("ias", 23);
    freq.put("fma", 27);
    freq.put(" Zo", 850);
    freq.put(" Zi", 274);
    freq.put(" Ze", 347);
    freq.put("hum", 58);
    freq.put("x ", 993);
    freq.put(" Za", 167);
    freq.put("hui", 1448);
    freq.put("za ", 62);
    freq.put("ebi", 45);
    freq.put("hut", 31);
    freq.put("huu", 65);
    freq.put("huw", 32);
    freq.put("hur", 26);
    freq.put(" Zu", 99);
    freq.put(" Zw", 86);
    freq.put(" ya", 32);
    freq.put("JK ", 25);
    freq.put("mt ", 825);
    freq.put("nex", 22);
    freq.put("ebt", 378);
    freq.put("rze", 97);
    freq.put("wat", 2310);
    freq.put("rza", 70);
    freq.put("rzo", 134);
    freq.put("bil", 89);
    freq.put("ia ", 447);
    freq.put("rzi", 89);
    freq.put("lho", 33);
    freq.put("r", 104626);
    freq.put("nie", 7810);
    freq.put("OP ", 44);
    freq.put("IS ", 43);
    freq.put("ost", 416);
    freq.put("pre", 657);
    freq.put("ane", 168);
    freq.put("Of ", 107);
    freq.put("cap", 31);
    freq.put("pra", 520);
    freq.put("san", 109);
    freq.put("sam", 263);
    freq.put("sal", 73);
    freq.put("anl", 24);
    freq.put("anm", 214);
    freq.put("saa", 128);
    freq.put("ebs", 89);
    freq.put("sag", 51);
    freq.put("ani", 222);
    freq.put("anj", 82);
    freq.put("sad", 22);
    freq.put("fc ", 25);
    freq.put("uy ", 22);
    freq.put("anv", 66);
    freq.put("anw", 101);
    freq.put("anp", 33);
    freq.put("anr", 46);
    freq.put("ans", 712);
    freq.put("sar", 41);
    freq.put("sap", 84);
    freq.put("sav", 26);
    freq.put("sau", 25);
    freq.put("sat", 58);
    freq.put("Do", 448);
    freq.put("omm", 436);
    freq.put("zoc", 60);
    freq.put("Pho", 70);
    freq.put("zoe", 609);
    freq.put("Di", 602);
    freq.put("zoi", 45);
    freq.put("zoj", 27);
    freq.put("De", 1192);
    freq.put("lti", 729);
    freq.put("zom", 233);
    freq.put("zon", 756);
    freq.put("Da", 1074);
    freq.put("zor", 157);
    freq.put("zou", 543);
    freq.put("zov", 150);
    freq.put("zow", 59);
    freq.put("new", 38);
    freq.put("Du", 350);
    freq.put("Dr", 133);
    freq.put("ts ", 1865);
    freq.put("dje", 771);
    freq.put("all", 2490);
    freq.put("adr", 48);
    freq.put("an ", 16299);
    freq.put("ust", 463);
    freq.put("sa ", 104);
    freq.put("axi", 35);
    freq.put(" ye", 129);
    freq.put("Sha", 22);
    freq.put("net", 1005);
    freq.put("mok", 24);
    freq.put("zo ", 2679);
    freq.put(" Le", 624);
    freq.put("orw", 40);
    freq.put(" La", 326);
    freq.put("Sne", 36);
    freq.put(" Lo", 217);
    freq.put(" Li", 308);
    freq.put("eha", 495);
    freq.put(" Lu", 84);
    freq.put("tze", 129);
    freq.put("oy ", 108);
    freq.put("Web", 22);
    freq.put("rka", 68);
    freq.put("fes", 62);
    freq.put("Wee", 325);
    freq.put("tka", 27);
    freq.put("tko", 27);
    freq.put("oog", 379);
    freq.put("Wel", 186);
    freq.put("nla", 75);
    freq.put("Wer", 89);
    freq.put(" p ", 303);
    freq.put("nle", 48);
    freq.put("ais", 29);
    freq.put("nli", 526);
    freq.put("dy ", 115);
    freq.put("ss ", 478);
    freq.put("nlo", 131);
    freq.put("Lim", 32);
    freq.put("We", 981);
    freq.put("uh ", 151);
    freq.put("Wa", 1522);
    freq.put("Wo", 312);
    freq.put("ce ", 329);
    freq.put("lub", 91);
    freq.put("Wi", 918);
    freq.put("Wh", 111);
    freq.put("tne", 42);
    freq.put("Wt", 40);
    freq.put("y ", 2357);
    freq.put("tic", 118);
    freq.put(" ps", 61);
    freq.put(" pr", 1490);
    freq.put("gep", 226);
    freq.put(" pw", 28);
    freq.put("gev", 952);
    freq.put(" pu", 186);
    freq.put("get", 455);
    freq.put("ssu", 21);
    freq.put("H", 4913);
    freq.put("voe", 860);
    freq.put("sss", 206);
    freq.put(" pc", 54);
    freq.put("geb", 643);
    freq.put(" pa", 1518);
    freq.put("geg", 291);
    freq.put(" pf", 199);
    freq.put(" pe", 549);
    freq.put("ged", 582);
    freq.put("gek", 678);
    freq.put("fde", 247);
    freq.put(" pi", 650);
    freq.put("geh", 584);
    freq.put(" po", 645);
    freq.put("gen", 7696);
    freq.put("gem", 617);
    freq.put(" pl", 736);
    freq.put("luk", 470);
    freq.put("W ", 143);
    freq.put("ute", 382);
    freq.put("Tim", 29);
    freq.put("lum", 36);
    freq.put("Vol", 227);
    freq.put("ó", 56);
    freq.put("boy", 119);
    freq.put("lun", 32);
    freq.put("cij", 66);
    freq.put("itz", 121);
    freq.put("Toc", 69);
    freq.put("uw", 2930);
    freq.put("uti", 55);
    freq.put("zet", 431);
    freq.put("rmu", 26);
    freq.put("rsf", 25);
    freq.put("jor", 35);
    freq.put("cin", 33);
    freq.put("rma", 401);
    freq.put("alg", 35);
    freq.put("fff", 256);
    freq.put("lne", 31);
    freq.put("eb ", 2978);
    freq.put("rmi", 141);
    freq.put("j ", 7189);
    freq.put("ffe", 332);
    freq.put("utr", 37);
    freq.put("nis", 359);
    freq.put(" b ", 43);
    freq.put("fdp", 54);
    freq.put("jf ", 214);
    freq.put("fds", 29);
    freq.put("uve", 32);
    freq.put("jtj", 28);
    freq.put("jte", 66);
    freq.put("tur", 237);
    freq.put("hze", 43);
    freq.put("tus", 296);
    freq.put("jy", 46);
    freq.put("jz", 155);
    freq.put("uns", 63);
    freq.put("jt", 334);
    freq.put("ju", 776);
    freq.put("jv", 369);
    freq.put("jw", 54);
    freq.put("jp", 138);
    freq.put("tuu", 562);
    freq.put("js", 462);
    freq.put("jl", 201);
    freq.put("jm", 89);
    freq.put("jn", 5227);
    freq.put("jo", 1748);
    freq.put("jh", 45);
    freq.put("ji", 1397);
    freq.put("jj", 80);
    freq.put("jk", 4995);
    freq.put("jd", 2434);
    freq.put("je", 14847);
    freq.put("jf", 557);
    freq.put("jg", 649);
    freq.put("tud", 168);
    freq.put("ja", 3708);
    freq.put("jb", 70);
    freq.put("gwe", 32);
    freq.put("rpl", 51);
    freq.put("uf", 176);
    freq.put(" ba", 1129);
    freq.put("wel", 3709);
    freq.put("kje", 557);
    freq.put(" bl", 1180);
    freq.put(" bo", 1215);
    freq.put("gwn", 195);
    freq.put(" bi", 3368);
    freq.put("P ", 334);
    freq.put("jfe", 90);
    freq.put("vui", 23);
    freq.put(" bu", 812);
    freq.put(" bt", 44);
    freq.put("s", 74679);
    freq.put("Kri", 49);
    freq.put("Zek", 29);
    freq.put(" br", 981);
    freq.put("jfs", 21);
    freq.put("dko", 35);
    freq.put(" by", 81);
    freq.put("jt ", 194);
    freq.put("Wis", 44);
    freq.put("jft", 190);
    freq.put("erc", 88);
    freq.put("vre", 167);
    freq.put("pot", 288);
    freq.put("uth", 31);
    freq.put("por", 301);
    freq.put("pos", 141);
    freq.put("pop", 81);
    freq.put("ue ", 98);
    freq.put("pon", 83);
    freq.put("poo", 105);
    freq.put("pol", 172);
    freq.put("ado", 53);
    freq.put("pok", 26);
    freq.put("tua", 23);
    freq.put("pog", 22);
    freq.put("pod", 65);
    freq.put("poe", 181);
    freq.put("ad ", 1482);
    freq.put("lma", 42);
    freq.put("twe", 1171);
    freq.put("fic", 75);
    freq.put("Bus", 29);
    freq.put("lys", 21);
    freq.put("éch", 21);
    freq.put("tue", 27);
    freq.put("fey", 54);
    freq.put("Bui", 36);
    freq.put("rko", 199);
    freq.put("nit", 62);
    freq.put("Man", 114);
    freq.put("imt", 42);
    freq.put(" be", 8237);
    freq.put("ady", 31);
    freq.put("ële", 21);
    freq.put("Zal", 51);
    freq.put("Teg", 29);
    freq.put("odu", 82);
    freq.put("fij", 228);
    freq.put("ltu", 26);
    freq.put("nsm", 36);
    freq.put("ooh", 160);
    freq.put("po ", 32);
    freq.put("wez", 69);
    freq.put("ïn", 28);
    freq.put("eis", 377);
    freq.put("eir", 22);
    freq.put("eit", 297);
    freq.put("fin", 84);
    freq.put(" bb", 188);
    freq.put("eie", 214);
    freq.put("eid", 858);
    freq.put("eig", 513);
    freq.put("eii", 22);
    freq.put("eih", 38);
    freq.put("eik", 157);
    freq.put("eij", 43);
    freq.put("eim", 35);
    freq.put("eil", 293);
    freq.put("ein", 979);
    freq.put("ive", 262);
    freq.put(" bn", 30);
    freq.put("iva", 71);
    freq.put("Tja", 22);
    freq.put("pje", 364);
    freq.put("ivm", 24);
    freq.put("mil", 214);
    freq.put("ivi", 91);
    freq.put("oi ", 618);
    freq.put("uxe", 22);
    freq.put("Bar", 76);
    freq.put("ceb", 104);
    freq.put("pap", 157);
    freq.put(" Me", 796);
    freq.put("par", 420);
    freq.put("pas", 488);
    freq.put("pat", 80);
    freq.put(" Ma", 1288);
    freq.put("én ", 91);
    freq.put(" Mn", 34);
    freq.put(" Mo", 813);
    freq.put(" Mi", 523);
    freq.put("Sin", 88);
    freq.put(" Mu", 73);
    freq.put("Vra", 43);
    freq.put("eta", 222);
    freq.put("rwe", 245);
    freq.put("AZ ", 24);
    freq.put("rwi", 264);
    freq.put("I ", 169);
    freq.put("Vri", 73);
    freq.put("pak", 342);
    freq.put("pal", 25);
    freq.put(" My", 23);
    freq.put("pan", 227);
    freq.put("fs ", 104);
    freq.put("cel", 62);
    freq.put("tle", 130);
    freq.put("A ", 679);
    freq.put("I", 4344);
    freq.put("oie", 478);
    freq.put("dka", 50);
    freq.put("oic", 36);
    freq.put("yd", 65);
    freq.put(" gu", 96);
    freq.put("yg", 29);
    freq.put("niv", 31);
    freq.put("Ete", 24);
    freq.put("naf", 179);
    freq.put("rwo", 27);
    freq.put("ois", 59);
    freq.put("Ji", 185);
    freq.put("nag", 111);
    freq.put("oka", 103);
    freq.put("bt ", 379);
    freq.put(" M ", 80);
    freq.put("odj", 82);
    freq.put("vul", 45);
    freq.put("Is", 253);
    freq.put("Ir", 21);
    freq.put("It", 32);
    freq.put("eto", 52);
    freq.put("pa ", 256);
    freq.put("tit", 100);
    freq.put("Ik", 2911);
    freq.put("cci", 24);
    freq.put("In", 481);
    freq.put("cce", 221);
    freq.put("oke", 801);
    freq.put("uie", 45);
    freq.put("Ie", 190);
    freq.put("uja", 31);
    freq.put("ck", 1249);
    freq.put("aga", 116);
    freq.put("geo", 41);
    freq.put(" qu", 40);
    freq.put("Bak", 26);
    freq.put("nsc", 113);
    freq.put("tip", 84);
    freq.put("ps ", 230);
    freq.put("cep", 56);
    freq.put("oki", 49);
    freq.put("rpr", 43);
    freq.put("gde", 60);
    freq.put("mpo", 47);
    freq.put("uid", 273);
    freq.put("bsi", 86);
    freq.put("nam", 147);
    freq.put("okk", 143);
    freq.put("unc", 67);
    freq.put("ohh", 68);
    freq.put("okj", 44);
    freq.put("hw ", 117);
    freq.put("tim", 102);
    freq.put("Mac", 40);
    freq.put("fva", 21);
    freq.put("yt", 47);
    freq.put("ot ", 1222);
    freq.put(" ge", 10361);
    freq.put("oko", 21);
    freq.put("uig", 96);
    freq.put("ff ", 1020);
    freq.put("lg ", 145);
    freq.put("odm", 23);
    freq.put("amh", 21);
    freq.put("Mid", 26);
    freq.put("amm", 385);
    freq.put("Mag", 46);
    freq.put("amo", 44);
    freq.put("amn", 54);
    freq.put("mos", 48);
    freq.put("psc", 35);
    freq.put(" ga", 4026);
    freq.put("ame", 1078);
    freq.put("mov", 38);
    freq.put("pse", 28);
    freq.put("gd ", 265);
    freq.put("moo", 809);
    freq.put("Lol", 29);
    freq.put("mom", 135);
    freq.put("gro", 710);
    freq.put("moc", 62);
    freq.put("mob", 138);
    freq.put("unn", 464);
    freq.put("Ze", 350);
    freq.put("mog", 212);
    freq.put("tif", 32);
    freq.put("pst", 129);
    freq.put("mod", 77);
    freq.put("tig", 569);
    freq.put("Pin", 38);
    freq.put("oad", 114);
    freq.put("atj", 324);
    freq.put("Pie", 34);
    freq.put("tia", 32);
    freq.put("alw", 207);
    freq.put("t", 124963);
    freq.put("BO ", 23);
    freq.put("Lov", 34);
    freq.put("aaf", 238);
    freq.put("gri", 258);
    freq.put("tty", 25);
    freq.put("noo", 631);
    freq.put("HT ", 39);
    freq.put("ezu", 78);
    freq.put("Ned", 278);
    freq.put("Nee", 262);
    freq.put("Me ", 128);
    freq.put("zwe", 133);
    freq.put("cs", 49);
    freq.put("tvo", 59);
    freq.put("ezo", 336);
    freq.put("ezi", 708);
    freq.put("ngl", 45);
    freq.put("tve", 70);
    freq.put("eze", 1754);
    freq.put("Net", 162);
    freq.put("anu", 69);
    freq.put("tva", 129);
    freq.put("eza", 27);
    freq.put("Mee", 102);
    freq.put(" ck", 30);
    freq.put(" ch", 580);
    freq.put(" ci", 97);
    freq.put(" co", 998);
    freq.put("kma", 34);
    freq.put("ër", 26);
    freq.put("hm ", 84);
    freq.put(" ca", 342);
    freq.put("Mei", 51);
    freq.put("jge", 216);
    freq.put("gvd", 26);
    freq.put("o ", 6715);
    freq.put("Met", 235);
    freq.put("ddi", 39);
    freq.put("ddo", 36);
    freq.put("rpo", 33);
    freq.put("Mer", 36);
    freq.put(" cr", 130);
    freq.put("dda", 277);
    freq.put("uch", 488);
    freq.put("jgt", 151);
    freq.put("dde", 367);
    freq.put(" cu", 102);
    freq.put("bbo", 22);
    freq.put("uik", 373);
    freq.put("tda", 81);
    freq.put("zit", 916);
    freq.put("Dru", 30);
    freq.put("dwa", 42);
    freq.put("tde", 66);
    freq.put("Dri", 37);
    freq.put("nme", 45);
    freq.put("acc", 148);
    freq.put("nma", 106);
    freq.put("nmo", 69);
    freq.put("oro", 26);
    freq.put("ez ", 29);
    freq.put("tv ", 189);
    freq.put("nmi", 230);
    freq.put("oo", 21106);
    freq.put("on", 10490);
    freq.put("om", 7502);
    freq.put("ol", 4511);
    freq.put("ok", 5068);
    freq.put("oj", 141);
    freq.put("oi", 1941);
    freq.put("oh", 696);
    freq.put("og", 4605);
    freq.put("of", 2856);
    freq.put("oe", 15691);
    freq.put("od", 1743);
    freq.put("oc", 2401);
    freq.put("ob", 872);
    freq.put("oa", 446);
    freq.put("vei", 60);
    freq.put("ngo", 59);
    freq.put("oz", 143);
    freq.put("oy", 224);
    freq.put("ox", 130);
    freq.put("ow", 1139);
    freq.put("ov", 2645);
    freq.put("ou", 5749);
    freq.put("ot", 3256);
    freq.put("os", 1396);
    freq.put("or", 14569);
    freq.put("op", 9996);
    freq.put("Ni", 589);
    freq.put("XD ", 76);
    freq.put("No", 608);
    freq.put("uil", 194);
    freq.put("Na", 355);
    freq.put("zoa", 108);
    freq.put("yyy", 30);
    freq.put("Ne", 805);
    freq.put("odd", 45);
    freq.put("MG ", 52);
    freq.put("Nu", 503);
    freq.put("ung", 57);
    freq.put("het", 6274);
    freq.put("heu", 109);
    freq.put("ehu", 25);
    freq.put("lof", 58);
    freq.put("log", 248);
    freq.put("her", 463);
    freq.put("hes", 53);
    freq.put("lok", 116);
    freq.put("EL ", 48);
    freq.put("lon", 167);
    freq.put("hey", 56);
    freq.put("lol", 184);
    freq.put("lom", 56);
    freq.put("hed", 73);
    freq.put("hee", 2523);
    freq.put("hef", 39);
    freq.put("ehe", 236);
    freq.put("lov", 175);
    freq.put("hea", 156);
    freq.put("heb", 3811);
    freq.put("hec", 115);
    freq.put("hel", 1398);
    freq.put("hem", 528);
    freq.put("hen", 445);
    freq.put("heo", 36);
    freq.put("heh", 111);
    freq.put("hei", 441);
    freq.put("ehh", 57);
    freq.put("hek", 41);
    freq.put("ago", 43);
    freq.put("uin", 179);
    freq.put("sid", 37);
    freq.put("agn", 48);
    freq.put("N ", 496);
    freq.put("jui", 112);
    freq.put("dvo", 34);
    freq.put("jul", 485);
    freq.put("jur", 42);
    freq.put("jus", 29);
    freq.put("yy ", 48);
    freq.put("rja", 203);
    freq.put("dvi", 60);
    freq.put("Wor", 100);
    freq.put("agj", 147);
    freq.put("lo ", 179);
    freq.put("agi", 161);
    freq.put("agh", 24);
    freq.put("dve", 83);
    freq.put("as ", 2864);
    freq.put("he ", 1042);
    freq.put("eh ", 221);
    freq.put("wak", 365);
    freq.put("aa", 32682);
    freq.put("oth", 66);
    freq.put("ac", 3810);
    freq.put("ab", 543);
    freq.put("ae", 85);
    freq.put("ad", 3065);
    freq.put("ag", 6630);
    freq.put("af", 1723);
    freq.put("ai", 1243);
    freq.put("ah", 6699);
    freq.put("ak", 4635);
    freq.put("aj", 223);
    freq.put("am", 3745);
    freq.put("al", 13388);
    freq.put("ao", 96);
    freq.put("an", 30719);
    freq.put("ap", 3533);
    freq.put("as", 5076);
    freq.put("ar", 17730);
    freq.put("au", 1277);
    freq.put("at", 16750);
    freq.put("aw", 167);
    freq.put("av", 1412);
    freq.put("ay", 422);
    freq.put("ax", 304);
    freq.put("az", 197);
    freq.put("uis", 1706);
    freq.put("Lan", 75);
    freq.put("igt", 192);
    freq.put("igs", 40);
    freq.put("thu", 494);
    freq.put("swe", 226);
    freq.put("oul", 27);
    freq.put("Laa", 129);
    freq.put("mm ", 242);
    freq.put("igg", 205);
    freq.put("ë ", 30);
    freq.put("ige", 1441);
    freq.put("igd", 54);
    freq.put("iga", 47);
    freq.put("Ove", 124);
    freq.put("ri ", 79);
    freq.put("ign", 54);
    freq.put("you", 163);
    freq.put("igi", 149);
    freq.put("igh", 218);
    freq.put("a ", 11784);
    freq.put(" g ", 30);
    freq.put("ru", 2404);
    freq.put("otd", 27);
    freq.put("oh ", 431);
    freq.put(" zo", 4612);
    freq.put("Zoe", 40);
    freq.put("zoo", 267);
    freq.put(" zn", 123);
    freq.put("rp", 432);
    freq.put("lge", 792);
    freq.put("max", 34);
    freq.put("uzi", 273);
    freq.put("at ", 11985);
    freq.put("rp ", 96);
    freq.put("nss", 27);
    freq.put("Bru", 38);
    freq.put("Bro", 44);
    freq.put(" ze", 3823);
    freq.put("boe", 447);
    freq.put("u", 39914);
    freq.put("Bri", 43);
    freq.put("ig ", 2439);
    freq.put("uit", 2868);
    freq.put("sin", 302);
    freq.put("Bre", 62);
    freq.put("Bra", 73);
    freq.put("pto", 124);
    freq.put("gw", 254);
    freq.put("sco", 213);
    freq.put("alm", 29);
    freq.put("Van", 605);
    freq.put("sch", 3863);
    freq.put("pti", 74);
    freq.put("gv", 75);
    freq.put("alf", 360);
    freq.put(" za", 1040);
    freq.put("pte", 195);
    freq.put("ale", 867);
    freq.put("sca", 43);
    freq.put("lly", 56);
    freq.put("€", 156);
    freq.put("gt", 1221);
    freq.put("ndu", 54);
    freq.put("rz", 419);
    freq.put("Hop", 68);
    freq.put("Fie", 28);
    freq.put("Fij", 64);
    freq.put(" f", 4224);
    freq.put("fa ", 51);
    freq.put("uw ", 903);
    freq.put("Fin", 22);
    freq.put("ptr", 44);
    freq.put("Fil", 27);
    freq.put("gr", 2002);
    freq.put("hy ", 57);
    freq.put("smo", 54);
    freq.put("ots", 195);
    freq.put("tz", 288);
    freq.put("edd", 103);
    freq.put("ty", 403);
    freq.put("tv", 487);
    freq.put(" N ", 31);
    freq.put("tt", 2438);
    freq.put("gp", 42);
    freq.put("tr", 3417);
    freq.put("ts", 3690);
    freq.put("tp", 180);
    freq.put("tn", 125);
    freq.put("to", 5800);
    freq.put("tl", 302);
    freq.put("tm", 166);
    freq.put("tj", 3002);
    freq.put("tk", 124);
    freq.put("th", 1367);
    freq.put("ti", 6595);
    freq.put("tf", 190);
    freq.put("tg", 297);
    freq.put("td", 202);
    freq.put("te", 22365);
    freq.put("tb", 538);
    freq.put("tc", 223);
    freq.put("ta", 4127);
    freq.put("edi", 422);
    freq.put("ium", 47);
    freq.put("smi", 79);
    freq.put("mpa", 37);
    freq.put("vri", 874);
    freq.put("fas", 30);
    freq.put("mpl", 92);
    freq.put("ajo", 22);
    freq.put("fav", 41);
    freq.put("al ", 4603);
    freq.put("gz", 69);
    freq.put(" zu", 419);
    freq.put("nko", 216);
    freq.put("fai", 28);
    freq.put("fan", 110);
    freq.put("gy", 113);
    freq.put("rm", 1308);
    freq.put("mn ", 793);
    freq.put("fac", 145);
    freq.put("ruk", 303);
    freq.put("faa", 50);
    freq.put("rn", 1006);
    freq.put("mbu", 109);
    freq.put("yna", 22);
    freq.put(" Ni", 574);
    freq.put("gg", 1024);
    freq.put("and", 5349);
    freq.put("ro", 6613);
    freq.put(" No", 597);
    freq.put("gf", 21);
    freq.put(" Na", 352);
    freq.put(" Ne", 789);
    freq.put("ge", 23282);
    freq.put("dsc", 104);
    freq.put("hyp", 26);
    freq.put("wss", 26);
    freq.put("gd", 387);
    freq.put("sma", 134);
    freq.put("hyv", 65);
    freq.put("gc", 21);
    freq.put("pbo", 21);
    freq.put("rk", 2809);
    freq.put(" Nu", 502);
    freq.put("rbu", 33);
    freq.put("t ", 63189);
    freq.put("gb", 98);
    freq.put("SS ", 29);
    freq.put("sbr", 56);
    freq.put("eiz", 112);
    freq.put("xcu", 26);
    freq.put("ga", 4917);
    freq.put("ten", 5679);
    freq.put("nbr", 36);
    freq.put("teb", 31);
    freq.put("edu", 45);
    freq.put("ted", 83);
    freq.put("tee", 1168);
    freq.put("nbu", 44);
    freq.put("teg", 751);
    freq.put("go", 2589);
    freq.put("nbi", 36);
    freq.put("asp", 30);
    freq.put("nbo", 74);
    freq.put(" r ", 64);
    freq.put("tep", 44);
    freq.put("mmy", 22);
    freq.put("sth", 22);
    freq.put("tes", 163);
    freq.put("gm", 110);
    freq.put("nbe", 97);
    freq.put("Voe", 76);
    freq.put("rbo", 65);
    freq.put("abb", 53);
    freq.put("gl", 265);
    freq.put("suc", 129);
    freq.put("sub", 29);
    freq.put("sun", 30);
    freq.put("sum", 45);
    freq.put("sbu", 21);
    freq.put("suk", 41);
    freq.put("sui", 27);
    freq.put("abo", 70);
    freq.put("mmu", 37);
    freq.put("pzi", 36);
    freq.put("rbl", 25);
    freq.put("sus", 49);
    freq.put("sur", 44);
    freq.put("tzo", 63);
    freq.put("sup", 280);
    freq.put("aci", 23);
    freq.put("aby", 94);
    freq.put("Jac", 22);
    freq.put("md ", 137);
    freq.put(" ru", 439);
    freq.put(" rt", 132);
    freq.put("wau", 69);
    freq.put("lko", 113);
    freq.put("te ", 6294);
    freq.put("zie", 1936);
    freq.put("K", 1952);
    freq.put("tsc", 86);
    freq.put(" re", 1562);
    freq.put("ggg", 54);
    freq.put("Noo", 105);
    freq.put(" ra", 564);
    freq.put("pub", 38);
    freq.put(" ro", 777);
    freq.put("kzi", 37);
    freq.put(" ri", 521);
    freq.put("Wil", 201);
    freq.put("ves", 163);
    freq.put("ab ", 37);
    freq.put("mmm", 117);
    freq.put("ass", 460);
    freq.put("NL ", 82);
    freq.put("nkt", 359);
    freq.put("fwe", 32);
    freq.put("lki", 22);
    freq.put("fwa", 43);
    freq.put("olk", 76);
    freq.put("Dal", 22);
    freq.put("zij", 2343);
    freq.put("sba", 46);
    freq.put("sig", 77);
    freq.put("ana", 931);
    freq.put("mmi", 221);
    freq.put("rkt", 339);
    freq.put("rku", 30);
    freq.put("Nog", 282);
    freq.put("nto", 122);
    freq.put("rkr", 38);
    freq.put("rks", 83);
    freq.put("vij", 31);
    freq.put("Top", 50);
    freq.put("sbe", 69);
    freq.put("vin", 981);
    freq.put("vil", 33);
    freq.put("rkd", 24);
    freq.put("rke", 917);
    freq.put("udt", 51);
    freq.put("Aut", 31);
    freq.put("rdj", 49);
    freq.put("asj", 57);
    freq.put("rkl", 124);
    freq.put("vd", 146);
    freq.put("S ", 531);
    freq.put("rme", 286);
    freq.put("rki", 92);
    freq.put("Toe", 44);
    freq.put("twa", 68);
    freq.put("eye", 120);
    freq.put("yve", 97);
    freq.put("twi", 587);
    freq.put("ull", 760);
    freq.put("jd ", 1492);
    freq.put("eyo", 32);
    freq.put(" d ", 162);
    freq.put("mme", 803);
    freq.put("mui", 33);
    freq.put("anc", 195);
    freq.put("de ", 11711);
    freq.put("In ", 270);
    freq.put("iz ", 27);
    freq.put("Sp", 222);
    freq.put("Sw", 21);
    freq.put("Su", 144);
    freq.put("St", 565);
    freq.put("Sk", 22);
    freq.put("Sj", 25);
    freq.put("Si", 163);
    freq.put("Sh", 77);
    freq.put("So", 302);
    freq.put("Sn", 73);
    freq.put("Sm", 36);
    freq.put("Sl", 181);
    freq.put("Sc", 231);
    freq.put("NG ", 48);
    freq.put("Sa", 191);
    freq.put("tru", 208);
    freq.put("Se", 123);
    freq.put("á", 44);
    freq.put("kle", 508);
    freq.put(" dm", 52);
    freq.put("jdi", 42);
    freq.put("kla", 778);
    freq.put(" di", 5207);
    freq.put("jdj", 38);
    freq.put("jde", 529);
    freq.put(" de", 11212);
    freq.put("klo", 238);
    freq.put("jda", 177);
    freq.put("kli", 143);
    freq.put(" da", 11257);
    freq.put("dew", 52);
    freq.put("bur", 228);
    freq.put("klu", 44);
    freq.put("dek", 86);
    freq.put("del", 1019);
    freq.put("dem", 196);
    freq.put(" dy", 24);
    freq.put("v", 35768);
    freq.put("Ind", 40);
    freq.put("jdt", 34);
    freq.put(" du", 1550);
    freq.put(" dt", 31);
    freq.put("ded", 37);
    freq.put(" dr", 1151);
    freq.put("jds", 43);
    freq.put("deg", 37);
    freq.put("qq ", 37);
    freq.put("uif", 25);
    freq.put("Vin", 45);
    freq.put(" ft", 24);
    freq.put("ann", 842);
    freq.put(" z ", 132);
    freq.put("f ", 5596);
    freq.put("hha", 268);
    freq.put("é ", 141);
    freq.put("hhh", 142);
    freq.put("yd ", 35);
    freq.put("iPa", 32);
    freq.put("ft ", 1728);
    freq.put("Om ", 45);
    freq.put("iPh", 62);
    freq.put("oys", 59);
    freq.put("iPo", 23);
    freq.put("ava", 148);
    freq.put("uij", 26);
    freq.put("vla", 41);
    freq.put("lam", 158);
    freq.put("atu", 353);
    freq.put("r ", 38877);
    freq.put("eg ", 1645);
    freq.put("awh", 28);
    freq.put("ats", 796);
    freq.put("fp", 24);
    freq.put("fr", 360);
    freq.put("fs", 562);
    freq.put("ft", 2003);
    freq.put("fu", 312);
    freq.put("fv", 59);
    freq.put("fw", 87);
    freq.put("our", 142);
    freq.put("fy", 28);
    freq.put("fz", 403);
    freq.put("UT ", 22);
    freq.put("Doe", 163);
    freq.put("rmo", 105);
    freq.put("fa", 675);
    freq.put("fb", 54);
    freq.put("hh ", 284);
    freq.put("fd", 665);
    freq.put("fe", 1454);
    freq.put("ff", 1993);
    freq.put("fg", 240);
    freq.put("fh", 45);
    freq.put("fi", 1555);
    freq.put("fj", 117);
    freq.put("fk", 59);
    freq.put("fl", 412);
    freq.put("fm", 71);
    freq.put("fn", 36);
    freq.put("fo", 1322);
    freq.put("a", 169096);
    freq.put("omh", 26);
    freq.put("lhe", 28);
    freq.put("Ren", 28);
    freq.put("sli", 181);
    freq.put("ges", 918);
    freq.put("egr", 185);
    freq.put("pho", 93);
    freq.put("cs ", 36);
    freq.put("ry ", 393);
    freq.put("egt", 482);
    freq.put("wit", 731);
    freq.put("egi", 507);
    freq.put("egh", 32);
    freq.put("ego", 157);
    freq.put("ds ", 898);
    freq.put("egm", 21);
    freq.put("ö", 27);
    freq.put("ega", 244);
    freq.put("egg", 486);
    freq.put("ege", 2031);
    freq.put("egd", 103);
    freq.put("itn", 45);
    freq.put("Mel", 45);
    freq.put("itl", 95);
    freq.put("itm", 22);
    freq.put("itj", 53);
    freq.put("itk", 38);
    freq.put("ith", 52);
    freq.put("iti", 387);
    freq.put("itg", 190);
    freq.put("itd", 37);
    freq.put("ite", 1210);
    freq.put("lah", 32);
    freq.put("itc", 104);
    freq.put("ita", 228);
    freq.put("top", 524);
    freq.put("ok ", 3474);
    freq.put("opw", 31);
    freq.put("ffl", 22);
    freq.put("Er ", 178);
    freq.put("ffi", 231);
    freq.put("ity", 57);
    freq.put("itv", 68);
    freq.put("itw", 24);
    freq.put("itt", 1074);
    freq.put("itu", 48);
    freq.put("itr", 36);
    freq.put("its", 436);
    freq.put("itp", 28);
    freq.put(" On", 273);
    freq.put(" Oo", 245);
    freq.put(" Ol", 30);
    freq.put(" Om", 247);
    freq.put(" Ok", 299);
    freq.put(" Oh", 167);
    freq.put("paa", 326);
    freq.put(" Of", 134);
    freq.put(" Oe", 78);
    freq.put("yn ", 63);
    freq.put("pac", 38);
    freq.put("if ", 29);
    freq.put("tp ", 44);
    freq.put(" Ov", 126);
    freq.put(" Ow", 35);
    freq.put("lgi", 32);
    freq.put(" Ou", 50);
    freq.put(" Or", 48);
    freq.put(" Op", 428);
    freq.put("yi", 25);
    freq.put("rwa", 176);
    freq.put("yk", 80);
    freq.put("ym", 111);
    freq.put("yl", 84);
    freq.put("yo", 242);
    freq.put("yn", 140);
    freq.put("ya", 102);
    freq.put("cen", 237);
    freq.put("yc", 50);
    freq.put("yb", 62);
    freq.put("ye", 337);
    freq.put("L", 1901);
    freq.put("it ", 4112);
    freq.put("yf", 38);
    freq.put("yy", 86);
    freq.put("Erg", 24);
    freq.put("ces", 205);
    freq.put("cer", 79);
    freq.put("akb", 24);
    freq.put("Baa", 21);
    freq.put("Ban", 34);
    freq.put("yp", 186);
    freq.put("ys", 204);
    freq.put("yr", 49);
    freq.put("yu", 22);
    freq.put("Eri", 22);
    freq.put("Bah", 22);
    freq.put("yv", 101);
    freq.put("ift", 75);
    freq.put("uat", 23);
    freq.put("epu", 21);
    freq.put("Raa", 27);
    freq.put("Vro", 79);
    freq.put("Tan", 26);
    freq.put("ën", 53);
    freq.put(" O ", 204);
    freq.put("ël", 28);
    freq.put("ife", 65);
    freq.put("iff", 24);
    freq.put("ifa", 34);
    freq.put("man", 1833);
    freq.put("tw ", 44);
    freq.put("pc ", 52);
    freq.put("ifi", 44);
    freq.put("kfc", 21);
    freq.put(" A ", 228);
    freq.put(" sy", 37);
    freq.put("iën", 25);
    freq.put("Eng", 63);
    freq.put("tre", 739);
    freq.put(" sp", 1274);
    freq.put("cc ", 32);
    freq.put("oms", 330);
    freq.put(" sw", 129);
    freq.put(" st", 4218);
    freq.put(" su", 569);
    freq.put(" sj", 57);
    freq.put(" sk", 122);
    freq.put(" sh", 379);
    freq.put(" si", 406);
    freq.put(" sn", 842);
    freq.put(" so", 856);
    freq.put(" sl", 1617);
    freq.put(" sm", 275);
    freq.put(" sc", 2341);
    freq.put(" sa", 549);
    freq.put(" sg", 31);
    freq.put(" se", 644);
    freq.put("iza", 24);
    freq.put("Omg", 84);
    freq.put("ize", 134);
    freq.put("Omd", 37);
    freq.put("izi", 24);
    freq.put("E ", 480);
    freq.put("izo", 87);
    freq.put("NS ", 25);
    freq.put("abl", 45);
    freq.put("fte", 99);
    freq.put("Wtf", 39);
    freq.put("wk ", 22);
    freq.put("fti", 78);
    freq.put("izz", 61);
    freq.put("En ", 768);
    freq.put(" Aa", 245);
    freq.put("pun", 151);
    freq.put(" Ac", 88);
    freq.put(" Ad", 63);
    freq.put(" Af", 74);
    freq.put(" Ag", 21);
    freq.put(" Ah", 115);
    freq.put(" Ai", 46);
    freq.put(" Aj", 109);
    freq.put(" Al", 967);
    freq.put(" Am", 282);
    freq.put(" An", 205);
    freq.put(" Ap", 101);
    freq.put("Tal", 21);
    freq.put(" Ar", 131);
    freq.put(" As", 52);
    freq.put(" At", 22);
    freq.put(" Au", 63);
    freq.put(" Av", 23);
    freq.put(" Aw", 34);
    freq.put("put", 69);
    freq.put(" eh", 153);
    freq.put(" s ", 890);
    freq.put("ash", 77);
    freq.put("mma", 122);
    freq.put("sbo", 22);
    freq.put("asm", 41);
    freq.put(" ei", 866);
    freq.put("Em", 37);
    freq.put("El", 86);
    freq.put("En", 908);
    freq.put("Ei", 161);
    freq.put("Eh", 29);
    freq.put("omp", 210);
    freq.put("ion", 383);
    freq.put("Ee", 483);
    freq.put("Ed", 31);
    freq.put("kon", 236);
    freq.put("Ec", 127);
    freq.put("Spe", 51);
    freq.put(" ed", 39);
    freq.put("bb ", 145);
    freq.put("Ey", 40);
    freq.put("Ex", 37);
    freq.put("w", 37774);
    freq.put("tos", 73);
    freq.put("Eu", 95);
    freq.put("Et", 33);
    freq.put("Ev", 165);
    freq.put("koc", 102);
    freq.put("Es", 27);
    freq.put("Er", 265);
    freq.put("le ", 1611);
    freq.put("Fra", 76);
    freq.put("dt ", 776);
    freq.put("Fre", 28);
    freq.put("uel", 35);
    freq.put("vaa", 229);
    freq.put("Fri", 27);
    freq.put("agm", 38);
    freq.put("tf ", 115);
    freq.put("ië ", 29);
    freq.put("bul", 100);
    freq.put(" ec", 2201);
    freq.put("osc", 47);
    freq.put("htb", 50);
    freq.put("jer", 56);
    freq.put("jes", 1275);
    freq.put("kok", 68);
    freq.put("oit", 521);
    freq.put("kom", 1932);
    freq.put("jew", 88);
    freq.put("koo", 251);
    freq.put("jeu", 52);
    freq.put("jez", 80);
    freq.put(" ee", 9188);
    freq.put("X ", 63);
    freq.put(" eg", 140);
    freq.put("koe", 162);
    freq.put("Men", 112);
    freq.put("kof", 125);
    freq.put("jeb", 32);
    freq.put("jec", 80);
    freq.put("koz", 21);
    freq.put(" ex", 233);
    freq.put(" ey", 35);
    freq.put("jee", 215);
    freq.put(" et", 613);
    freq.put("kop", 373);
    freq.put("kos", 75);
    freq.put("kor", 261);
    freq.put("jen", 46);
    freq.put("kot", 32);
    freq.put(" er", 3381);
    freq.put(" es", 60);
    freq.put("tfo", 33);
    freq.put("ods", 69);
    freq.put("ag ", 4261);
    freq.put("xt ", 29);
    freq.put("Zwa", 37);
    freq.put("oho", 42);
    freq.put("nct", 25);
    freq.put("Zwe", 21);
    freq.put("vog", 40);
    freq.put("htj", 85);
    freq.put("nch", 88);
    freq.put("eli", 2374);
    freq.put("hè ", 103);
    freq.put("ncl", 34);
    freq.put("odv", 49);
    freq.put(" eu", 192);
    freq.put("oja", 25);
    freq.put("opz", 88);
    freq.put(" ev", 1119);
    freq.put("iël", 23);
    freq.put("ste", 4383);
    freq.put("aag", 1746);
    freq.put("b", 29789);
    freq.put("lyk", 49);
    freq.put("sta", 2121);
    freq.put("stb", 27);
    freq.put("OK ", 38);
    freq.put("stl", 24);
    freq.put("kou", 210);
    freq.put("ké", 54);
    freq.put("sto", 768);
    freq.put(" e ", 413);
    freq.put("sti", 862);
    freq.put("stj", 114);
    freq.put("stt", 25);
    freq.put("i", 128473);
    freq.put("je ", 12559);
    freq.put("stw", 27);
    freq.put("Nu ", 484);
    freq.put("str", 1138);
    freq.put("aar", 13424);
    freq.put("odl", 22);
    freq.put("sty", 42);
    freq.put("pma", 30);
    freq.put("Goo", 94);
    freq.put("ka ", 102);
    freq.put("js ", 232);
    freq.put("rry", 333);
    freq.put("sh ", 90);
    freq.put("Goe", 236);
    freq.put("God", 48);
    freq.put("Mus", 21);
    freq.put("tui", 164);
    freq.put("oda", 81);
    freq.put("Aja", 107);
    freq.put("Is ", 222);
    freq.put("Nij", 30);
    freq.put("Nik", 33);
    freq.put("lif", 56);
    freq.put("k ", 28345);
    freq.put("lia", 77);
    freq.put("ex ", 102);
    freq.put("lic", 482);
    freq.put("Nic", 63);
    freq.put("lin", 1017);
    freq.put("efs", 104);
    freq.put("eft", 1434);
    freq.put("cco", 77);
    freq.put("lij", 4101);
    freq.put("Nie", 419);
    freq.put("lit", 262);
    freq.put("efi", 73);
    freq.put("efj", 86);
    freq.put("mak", 958);
    freq.put("efl", 23);
    freq.put("Kin", 30);
    freq.put("ope", 1156);
    freq.put("efo", 196);
    freq.put("efd", 149);
    freq.put("efe", 286);
    freq.put("eff", 157);
    freq.put("kab", 36);
    freq.put("kaa", 476);
    freq.put("oft", 80);
    freq.put("kad", 48);
    freq.put("kak", 21);
    freq.put("Thu", 51);
    freq.put("M", 4072);
    freq.put("kan", 2359);
    freq.put("kam", 313);
    freq.put("kal", 78);
    freq.put("jst", 107);
    freq.put("kar", 46);
    freq.put("kap", 266);
    freq.put("kau", 29);
    freq.put("jss", 21);
    freq.put("rha", 193);
    freq.put("rg ", 532);
    freq.put("kay", 39);
    freq.put("rhe", 177);
    freq.put("stv", 43);
    freq.put("bac", 91);
    freq.put("Kwa", 21);
    freq.put("kb", 252);
    freq.put("ka", 4078);
    freq.put("kg", 84);
    freq.put("kf", 53);
    freq.put("ke", 13505);
    freq.put("kd", 58);
    freq.put("kk", 3764);
    freq.put("kj", 578);
    freq.put("ki", 2806);
    freq.put("kh", 177);
    freq.put("ko", 3917);
    freq.put("kn", 433);
    freq.put("km", 141);
    freq.put("kl", 1720);
    freq.put("ks", 1504);
    freq.put("kr", 1227);
    freq.put("ext", 100);
    freq.put("kp", 107);
    freq.put("kw", 564);
    freq.put("kv", 61);
    freq.put("ku", 1282);
    freq.put("kt", 2650);
    freq.put("ef ", 797);
    freq.put("kz", 87);
    freq.put("ky", 108);
    freq.put("une", 62);
    freq.put("exy", 34);
    freq.put("Hah", 646);
    freq.put("oju", 35);
    freq.put("Hal", 70);
    freq.put("Han", 56);
    freq.put(" qq", 99);
    freq.put("Haa", 132);
    freq.put("rto", 78);
    freq.put("nco", 31);
    freq.put("Had", 62);
    freq.put("rth", 41);
    freq.put("uge", 81);
    freq.put("rtj", 706);
    freq.put("hi ", 222);
    freq.put("oje", 65);
    freq.put("arf", 24);
    freq.put("rtp", 21);
    freq.put("rts", 155);
    freq.put("rtr", 164);
    freq.put("Har", 89);
    freq.put("baa", 386);
    freq.put("rty", 76);
    freq.put("ati", 994);
    freq.put("iez", 167);
    freq.put("nal", 262);
    freq.put("iep", 200);
    freq.put("ies", 841);
    freq.put("ier", 1624);
    freq.put("ieu", 1449);
    freq.put("iet", 7781);
    freq.put("iew", 83);
    freq.put("iev", 376);
    freq.put("ieh", 38);
    freq.put("iek", 857);
    freq.put("Jo", 289);
    freq.put("iem", 727);
    freq.put("iel", 447);
    freq.put("ien", 1964);
    freq.put("Je", 628);
    freq.put("ieb", 110);
    freq.put("iee", 227);
    freq.put("Ja", 709);
    freq.put("ieg", 196);
    freq.put("ief", 790);
    freq.put("hip", 88);
    freq.put("hir", 72);
    freq.put("his", 50);
    freq.put("hit", 189);
    freq.put("rt ", 1688);
    freq.put("aad", 242);
    freq.put("ug ", 542);
    freq.put("hic", 51);
    freq.put("hie", 1167);
    freq.put("hih", 288);
    freq.put("aaa", 1615);
    freq.put("hij", 919);
    freq.put("hik", 53);
    freq.put("hil", 342);
    freq.put("hin", 158);
    freq.put("elf", 866);
    freq.put("rfs", 50);
    freq.put("mbi", 48);
    freq.put("rft", 25);
    freq.put("ym ", 48);
    freq.put("cra", 45);
    freq.put("Op ", 282);
    freq.put("rfe", 67);
    freq.put("ko ", 32);
    freq.put("x", 3904);
    freq.put("cri", 68);
    freq.put("J ", 100);
    freq.put("cro", 41);
    freq.put(" Be", 1041);
    freq.put("seu", 35);
    freq.put("set", 50);
    freq.put(" Ba", 280);
    freq.put("ser", 420);
    freq.put("For", 35);
    freq.put("sep", 89);
    freq.put("opl", 157);
    freq.put(" Bl", 188);
    freq.put(" Bo", 284);
    freq.put(" Bi", 379);
    freq.put("ade", 708);
    freq.put("sex", 76);
    freq.put(" Bu", 119);
    freq.put("sef", 31);
    freq.put("see", 104);
    freq.put("ik ", 11411);
    freq.put("sec", 78);
    freq.put("ype", 107);
    freq.put("sea", 25);
    freq.put(" Br", 269);
    freq.put("Fol", 28);
    freq.put("sen", 2231);
    freq.put("sem", 39);
    freq.put("sel", 317);
    freq.put("sek", 34);
    freq.put("uu ", 50);
    freq.put("sei", 75);
    freq.put("Ze ", 129);
    freq.put("vra", 431);
    freq.put("aau", 35);
    freq.put("uuh", 27);
    freq.put("mo ", 89);
    freq.put("lef", 201);
    freq.put("stu", 722);
    freq.put("wou", 139);
    freq.put("wow", 50);
    freq.put("leg", 374);
    freq.put("use", 107);
    freq.put("Xx", 40);
    freq.put("wor", 1548);
    freq.put("wol", 88);
    freq.put("Ple", 36);
    freq.put(" P ", 183);
    freq.put("atr", 47);
    freq.put("Pla", 56);
    freq.put("woe", 109);
    freq.put("tam", 91);
    freq.put("iks", 472);
    freq.put("adv", 84);
    freq.put("ikp", 39);
    freq.put("Oud", 39);
    freq.put(" B ", 97);
    freq.put("ikt", 140);
    freq.put("uuu", 168);
    freq.put("lel", 110);
    freq.put("upp", 58);
    freq.put("¤ ", 36);
    freq.put("uur", 2085);
    freq.put("ar ", 10980);
    freq.put("ikb", 56);
    freq.put("ika", 86);
    freq.put("Rec", 22);
    freq.put("len", 2969);
    freq.put("ike", 349);
    freq.put("se ", 854);
    freq.put("ikk", 389);
    freq.put("fge", 191);
    freq.put("iki", 35);
    freq.put("iko", 24);
    freq.put("to ", 692);
    freq.put("ads", 45);
    freq.put(" Pr", 242);
    freq.put("c", 23132);
    freq.put("arn", 275);
    freq.put(" Pv", 23);
    freq.put(" Pu", 27);
    freq.put("Yea", 53);
    freq.put("Zel", 31);
    freq.put("pdr", 76);
    freq.put("wek", 216);
    freq.put(" Pa", 286);
    freq.put("gei", 59);
    freq.put(" Pf", 138);
    freq.put(" Pe", 122);
    freq.put(" Pi", 122);
    freq.put(" Ph", 26);
    freq.put(" Po", 178);
    freq.put("wei", 134);
    freq.put("pda", 78);
    freq.put(" Pl", 123);
    freq.put("Wan", 109);
    freq.put("dmo", 24);
    freq.put("Wak", 53);
    freq.put("sky", 34);
    freq.put("wt ", 70);
    freq.put("nr ", 57);
    freq.put("Wac", 65);
    freq.put("Waa", 369);
    freq.put("wen", 629);
    freq.put("lex", 54);
    freq.put("tga", 33);
    freq.put("SV ", 34);
    freq.put("tge", 234);
    freq.put("lbu", 71);
    freq.put("Wau", 61);
    freq.put("Wat", 633);
    freq.put("Was", 134);
    freq.put("War", 31);
    freq.put(" t ", 1047);
    freq.put("pr", 2462);
    freq.put("ps", 565);
    freq.put("pp", 1563);
    freq.put("uus", 30);
    freq.put("pv", 123);
    freq.put("pw", 78);
    freq.put("pt", 1088);
    freq.put("pu", 445);
    freq.put("pz", 102);
    freq.put("ND ", 38);
    freq.put("dub", 57);
    freq.put("py", 71);
    freq.put("dud", 24);
    freq.put("ei ", 392);
    freq.put("tiv", 99);
    freq.put("pb", 66);
    freq.put("pc", 84);
    freq.put("pa", 2676);
    freq.put("pf", 219);
    freq.put("pg", 241);
    freq.put("pd", 179);
    freq.put("pe", 5354);
    freq.put("pj", 380);
    freq.put("pk", 51);
    freq.put("ph", 259);
    freq.put("pi", 1754);
    freq.put("pn", 100);
    freq.put("po", 1559);
    freq.put("pl", 1500);
    freq.put("pm", 86);
    freq.put("box", 53);
    freq.put("nri", 48);
    freq.put("Zat", 46);
    freq.put(" ty", 108);
    freq.put("ekn", 32);
    freq.put(" tw", 1403);
    freq.put(" tv", 193);
    freq.put(" tu", 435);
    freq.put("gat", 75);
    freq.put(" ts", 29);
    freq.put(" tr", 1087);
    freq.put("nre", 36);
    freq.put("N", 3347);
    freq.put(" to", 3322);
    freq.put("gan", 211);
    freq.put("gam", 66);
    freq.put(" tl", 47);
    freq.put("cee", 53);
    freq.put(" tj", 72);
    freq.put(" ti", 1056);
    freq.put(" th", 915);
    freq.put("gaf", 29);
    freq.put(" te", 5131);
    freq.put("gad", 56);
    freq.put(" ta", 521);
    freq.put("ekj", 139);
    freq.put("lba", 46);
    freq.put("fuu", 22);
    freq.put("adj", 43);
    freq.put("p ", 9071);
    freq.put("fuc", 161);
    freq.put("nau", 31);
    freq.put("fun", 55);
    freq.put("lbe", 40);
    freq.put("adi", 151);
    freq.put("nda", 1711);
    freq.put("bor", 146);
    freq.put("ant", 1706);
    freq.put("ogr", 139);
    freq.put("vic", 33);
    freq.put("sy ", 28);
    freq.put("voc", 41);
    freq.put("riv", 60);
    freq.put("rit", 262);
    freq.put("voo", 4605);
    freq.put("jpe", 42);
    freq.put("ris", 296);
    freq.put("rip", 60);
    freq.put("rin", 968);
    freq.put("rio", 73);
    freq.put("ril", 111);
    freq.put("rim", 119);
    freq.put("rij", 2366);
    freq.put("rik", 203);
    freq.put("vor", 204);
    freq.put("Val", 40);
    freq.put("rif", 31);
    freq.put("rig", 444);
    freq.put("rid", 50);
    freq.put("rie", 1289);
    freq.put("rib", 29);
    freq.put("jpt", 31);
    freq.put("ria", 95);
    freq.put("ng ", 3844);
    freq.put("ewi", 108);
    freq.put("ewo", 1223);
    freq.put("ewa", 78);
    freq.put("elw", 37);
    freq.put("ewe", 684);
    freq.put("gs ", 262);
    freq.put("aha", 5268);
    freq.put("mor", 1355);
    freq.put("ews", 28);
    freq.put("Tel", 50);
    freq.put("ohn", 34);
    freq.put("bom", 33);
    freq.put("lid", 49);
    freq.put("Cor", 32);
    freq.put("vo ", 47);
    freq.put("tis", 370);
    freq.put("dge", 63);
    freq.put("jp ", 47);
    freq.put("rdb", 31);
    freq.put("OW ", 28);
    freq.put("amd", 30);
    freq.put("sys", 23);
    freq.put("lig", 965);
    freq.put("uto", 312);
    freq.put("bui", 347);
    freq.put("mot", 101);
    freq.put("Com", 63);
    freq.put("Col", 38);
    freq.put("Coo", 24);
    freq.put("Con", 56);
    freq.put("kno", 111);
    freq.put("Soc", 28);
    freq.put(" fr", 257);
    freq.put(" fu", 230);
    freq.put("gst", 176);
    freq.put("kni", 85);
    freq.put("bod", 84);
    freq.put("kne", 29);
    freq.put("Som", 133);
    freq.put("kna", 124);
    freq.put(" fa", 520);
    freq.put("jbe", 47);
    freq.put("Sor", 40);
    freq.put("gse", 28);
    freq.put(" ff", 691);
    freq.put("y", 4596);
    freq.put("gsk", 21);
    freq.put("knu", 68);
    freq.put(" fm", 24);
    freq.put(" fl", 240);
    freq.put(" fo", 790);
    freq.put("mon", 259);
    freq.put("wig", 21);
    freq.put("lda", 41);
    freq.put("lio", 28);
    freq.put("Hyv", 21);
    freq.put("lde", 616);
    freq.put("wif", 36);
    freq.put("ldi", 221);
    freq.put("mol", 32);
    freq.put("ldo", 103);
    freq.put("bi ", 45);
    freq.put("O ", 413);
    freq.put("lds", 34);
    freq.put("hja", 63);
    freq.put("ldt", 22);
    freq.put("lik", 211);
    freq.put("ams", 168);
    freq.put("oo ", 404);
    freq.put("rgr", 40);
    freq.put("cut", 45);
    freq.put("cus", 78);
    freq.put("cur", 50);
    freq.put("Kij", 124);
    freq.put("liv", 96);
    freq.put("Dis", 21);
    freq.put("rga", 165);
    freq.put("rge", 2351);
    freq.put("ohj", 25);
    freq.put("uze", 186);
    freq.put("pv ", 41);
    freq.put("rgi", 100);
    freq.put("cum", 21);
    freq.put("cul", 40);
    freq.put("anb", 55);
    freq.put("ee ", 2886);
    freq.put("gs", 683);
    freq.put("rgo", 27);
    freq.put("Oo", 250);
    freq.put("On", 275);
    freq.put("Om", 247);
    freq.put("Ol", 30);
    freq.put("Ok", 302);
    freq.put("bik", 27);
    freq.put("mop", 53);
    freq.put("Oh", 168);
    freq.put("urd", 174);
    freq.put("Of", 134);
    freq.put("Oe", 81);
    freq.put("lis", 199);
    freq.put("Oc", 21);
    freq.put("bra", 248);
    freq.put("ngt", 120);
    freq.put("Ow", 36);
    freq.put("Ov", 128);
    freq.put("Ou", 52);
    freq.put("één", 70);
    freq.put("Or", 48);
    freq.put("Op", 428);
    freq.put("apj", 127);
    freq.put("eey", 60);
    freq.put("d", 81794);
    freq.put("ljo", 47);
    freq.put("eez", 26);
    freq.put("eeu", 187);
    freq.put("eet", 2845);
    freq.put("ahh", 327);
    freq.put("eep", 124);
    freq.put("ees", 988);
    freq.put("eer", 7544);
    freq.put("eem", 424);
    freq.put("eel", 2769);
    freq.put("ule", 62);
    freq.put("een", 12099);
    freq.put("eeh", 96);
    freq.put("eek", 1110);
    freq.put("eej", 119);
    freq.put("eee", 2142);
    freq.put("eed", 732);
    freq.put("eeg", 238);
    freq.put("elt", 529);
    freq.put("two", 131);
    freq.put("apo", 181);
    freq.put("ijp", 136);
    freq.put("kut", 340);
    freq.put("ijs", 447);
    freq.put("b ", 3540);
    freq.put("apl", 45);
    freq.put("ijv", 368);
    freq.put("ijw", 31);
    freq.put("uf ", 27);
    freq.put("ijz", 155);
    freq.put("ijb", 52);
    freq.put("ijd", 2423);
    freq.put("ije", 128);
    freq.put("ijf", 552);
    freq.put("ijg", 648);
    freq.put("ijh", 23);
    freq.put("VV ", 43);
    freq.put("ijk", 4986);
    freq.put("ijl", 198);
    freq.put("ijm", 76);
    freq.put("ijn", 5216);
    freq.put("zz ", 28);
    freq.put("rf ", 63);
    freq.put("tza", 26);
    freq.put("¤", 37);
    freq.put("ppo", 51);
    freq.put("pet", 100);
    freq.put("peu", 41);
    freq.put("pep", 24);
    freq.put("per", 1109);
    freq.put("pes", 84);
    freq.put("pel", 657);
    freq.put("pen", 2440);
    freq.put("tik", 107);
    freq.put("ped", 38);
    freq.put("pee", 363);
    freq.put("ape", 930);
    freq.put("pea", 33);
    freq.put("id ", 646);
    freq.put("pec", 152);
    freq.put("bd", 28);
    freq.put("be", 10920);
    freq.put("rui", 728);
    freq.put("run", 49);
    freq.put("ba", 2236);
    freq.put("bb", 1232);
    freq.put("bc", 29);
    freq.put("bl", 1615);
    freq.put("rhu", 39);
    freq.put("bn", 39);
    freq.put("bo", 2061);
    freq.put("bh", 21);
    freq.put("bi", 4218);
    freq.put("bj", 25);
    freq.put("rue", 28);
    freq.put("bt", 445);
    freq.put("bu", 1205);
    freq.put("oei", 558);
    freq.put("oeh", 58);
    freq.put("jsj", 23);
    freq.put("br", 1576);
    freq.put("bs", 186);
    freq.put("rus", 303);
    freq.put("oeg", 736);
    freq.put("by", 235);
    freq.put("rut", 32);
    freq.put("fec", 66);
    freq.put("uff", 116);
    freq.put("kas", 90);
    freq.put("gje", 174);
    freq.put("ws ", 265);
    freq.put("Rom", 24);
    freq.put("odn", 26);
    freq.put("Roo", 26);
    freq.put("Rob", 32);
    freq.put("ids", 202);
    freq.put("cad", 55);
    freq.put("ido", 28);
    freq.put("yle", 32);
    freq.put("aa ", 719);
    freq.put("eeë", 21);
    freq.put("idi", 157);
    freq.put("DE ", 51);
    freq.put("idd", 556);
    freq.put("ide", 714);
    freq.put("pe ", 240);
    freq.put("chj", 22);
    freq.put("ida", 42);
    freq.put("ppl", 74);
    freq.put("Elk", 30);
    freq.put("nsj", 27);
    freq.put("mst", 364);
    freq.put("nsl", 61);
    freq.put("rho", 83);
    freq.put("nso", 58);
    freq.put(" ut", 73);
    freq.put(" uu", 1069);
    freq.put(" C ", 86);
    freq.put("kat", 88);
    freq.put(" up", 143);
    freq.put("nse", 1104);
    freq.put(" ur", 32);
    freq.put(" Ko", 375);
    freq.put(" un", 99);
    freq.put(" uh", 70);
    freq.put(" ui", 2076);
    freq.put("nsp", 109);
    freq.put("enc", 53);
    freq.put(" ug", 21);
    freq.put("nst", 569);
    freq.put("The", 106);
    freq.put("fd ", 242);
    freq.put("ut ", 549);
    freq.put("ci ", 24);
    freq.put("nje", 72);
    freq.put("tuk", 225);
    freq.put("zig", 250);
    freq.put("Ooo", 30);
    freq.put("ctu", 41);
    freq.put("chr", 367);
    freq.put("Ook", 126);
    freq.put("kus", 75);
    freq.put("fzo", 356);
    freq.put("Tha", 50);
    freq.put("Oos", 29);
    freq.put("voi", 27);
    freq.put("cht", 6407);
    freq.put("u ", 5548);
    freq.put("ekt", 256);
    freq.put("Fe", 148);
    freq.put(" Ch", 221);
    freq.put(" Ci", 50);
    freq.put(" Co", 277);
    freq.put(" Cl", 35);
    freq.put("US ", 29);
    freq.put("ns ", 3015);
    freq.put("lka", 194);
    freq.put(" Ca", 142);
    freq.put("wnl", 77);
    freq.put(" Ce", 39);
    freq.put("Fli", 26);
    freq.put("sde", 38);
    freq.put("sda", 224);
    freq.put(" Cr", 46);
    freq.put("li ", 62);
    freq.put(" u ", 286);
    freq.put("sdi", 28);
    freq.put(" Cu", 38);
    freq.put("cia", 197);
    freq.put("ca ", 99);
    freq.put("uy", 51);
    freq.put("ux", 40);
    freq.put("cie", 207);
    freq.put("uz", 487);
    freq.put("uu", 2552);
    freq.put("ut", 1835);
    freq.put("ix ", 53);
    freq.put("uv", 49);
    freq.put("up", 686);
    freq.put("us", 3460);
    freq.put("ur", 4216);
    freq.put("um", 810);
    freq.put("ul", 1528);
    freq.put("uo", 33);
    freq.put("un", 1953);
    freq.put("ui", 6262);
    freq.put("uh", 283);
    freq.put("uk", 2403);
    freq.put("uj", 70);
    freq.put("ue", 256);
    freq.put("ud", 1507);
    freq.put("ug", 948);
    freq.put("z", 22704);
    freq.put("ua", 154);
    freq.put("uc", 1114);
    freq.put("ub", 422);
    freq.put("tun", 38);
    freq.put("tpl", 39);
    freq.put("ood", 655);
    freq.put("Tw", 265);
    freq.put("enp", 64);
    freq.put("Tu", 105);
    freq.put("Tr", 183);
    freq.put("Ts", 23);
    freq.put("To", 337);
    freq.put("tov", 21);
    freq.put("Tj", 32);
    freq.put("sul", 42);
    freq.put("Th", 260);
    freq.put("Ti", 213);
    freq.put("Te", 340);
    freq.put("Ta", 128);
    freq.put(" gv", 28);
    freq.put(" gw", 212);
    freq.put(" gt", 58);
    freq.put("gru", 27);
    freq.put(" gr", 1393);
    freq.put(" gs", 28);
    freq.put("nad", 76);
    freq.put("naj", 40);
    freq.put("nak", 42);
    freq.put("nah", 26);
    freq.put("nai", 32);
    freq.put("nan", 72);
    freq.put("sv ", 21);
    freq.put(" gy", 70);
    freq.put("nar", 70);
    freq.put("nas", 43);
    freq.put("nap", 333);
    freq.put("gre", 121);
    freq.put("nav", 558);
    freq.put("nat", 334);
    freq.put("gra", 851);
    freq.put("zam", 43);
    freq.put(" go", 2130);
    freq.put(" gl", 96);
    freq.put("Mam", 40);
    freq.put(" gh", 58);
    freq.put(" gi", 627);
    freq.put("oon", 1616);
    freq.put("exp", 59);
    freq.put("Mn ", 33);
    freq.put("ovi", 40);
    freq.put("pau", 106);
    freq.put("Beg", 30);
    freq.put("ac ", 63);
    freq.put("ly ", 131);
    freq.put("ook", 3384);
    freq.put("Zui", 53);
    freq.put("oxo", 29);
    freq.put("T ", 3084);
    freq.put("Kut", 47);
    freq.put("Aa", 252);
    freq.put("svo", 38);
    freq.put("Ac", 91);
    freq.put("e", 345069);
    freq.put("Ad", 66);
    freq.put("Ag", 21);
    freq.put("Af", 75);
    freq.put("Ai", 46);
    freq.put("Ah", 121);
    freq.put("age", 1160);
    freq.put("Aj", 109);
    freq.put("Am", 284);
    freq.put("Al", 973);
    freq.put("Ret", 81);
    freq.put("An", 207);
    freq.put(" l ", 47);
    freq.put("Ap", 111);
    freq.put("As", 53);
    freq.put("Ar", 134);
    freq.put("Au", 64);
    freq.put("At", 26);
    freq.put("Aw", 36);
    freq.put("Av", 23);
    freq.put("uws", 269);
    freq.put("agt", 96);
    freq.put("ags", 48);
    freq.put("agr", 58);
    freq.put(" b", 17400);
    freq.put(" c", 2698);
    freq.put("gu", 221);
    freq.put(" a", 15223);
    freq.put("Gis", 46);
    freq.put(" g", 19270);
    freq.put(" d", 35352);
    freq.put(" e", 27202);
    freq.put(" j", 15343);
    freq.put(" k", 13732);
    freq.put(" h", 28543);
    freq.put(" i", 27944);
    freq.put(" n", 23018);
    freq.put(" o", 20959);
    freq.put(" l", 10076);
    freq.put(" m", 31575);
    freq.put(" r", 4104);
    freq.put(" s", 15532);
    freq.put(" p", 7234);
    freq.put(" q", 184);
    freq.put(" v", 23695);
    freq.put(" w", 24554);
    freq.put(" t", 15454);
    freq.put(" u", 4028);
    freq.put(" z", 15810);
    freq.put("gn", 150);
    freq.put(" x", 2043);
    freq.put(" y", 357);
    freq.put("gk", 60);
    freq.put("gj", 186);
    freq.put("gi", 1800);
    freq.put("gh", 453);
    freq.put(" B", 2967);
    freq.put(" C", 1127);
    freq.put(" A", 3349);
    freq.put(" F", 1176);
    freq.put(" G", 2565);
    freq.put(" D", 5147);
    freq.put(" E", 2854);
    freq.put(" J", 2148);
    freq.put(" K", 1934);
    freq.put(" H", 4897);
    freq.put(" I", 4328);
    freq.put(" N", 3283);
    freq.put(" O", 2826);
    freq.put(" L", 1844);
    freq.put(" M", 4022);
    freq.put(" R", 3819);
    freq.put(" S", 3024);
    freq.put(" P", 2091);
    freq.put(" Q", 49);
    freq.put(" V", 2406);
    freq.put(" W", 4239);
    freq.put(" T", 2220);
    freq.put(" U", 438);
    freq.put(" Z", 1978);
    freq.put("Nou", 114);
    freq.put(" X", 425);
    freq.put(" Y", 286);
    freq.put("lks", 23);
    freq.put("tme", 35);
    freq.put("vli", 113);
    freq.put("ch ", 2018);
    freq.put("ed ", 2194);
    freq.put("spe", 722);
    freq.put("vlo", 61);
    freq.put("pme", 32);
    freq.put("rti", 348);
    freq.put("vle", 63);
    freq.put("P", 2255);
    freq.put("aai", 361);
    freq.put("d ", 16527);
    freq.put("g ", 17432);
    freq.put("Boy", 24);
    freq.put("ugd", 45);
    freq.put("vlu", 22);
    freq.put("esm", 37);
    freq.put("ax ", 208);
    freq.put("tri", 458);
    freq.put("evi", 170);
    freq.put("tro", 655);
    freq.put("evo", 362);
    freq.put("tra", 1315);
    freq.put("eva", 329);
    freq.put("us ", 1895);
    freq.put("zag", 178);
    freq.put("eve", 2765);
    freq.put("lk ", 145);
    freq.put("esj", 65);
    freq.put("dfe", 47);
    freq.put("Spi", 37);
    freq.put("min", 778);
    freq.put("opv", 52);
    freq.put("Spo", 36);
    freq.put("Spa", 64);
    freq.put("evr", 143);
    freq.put("ddd", 63);
    freq.put("Wij", 124);
    freq.put("mhe", 21);
    freq.put("rro", 77);
    freq.put("ody", 30);
    freq.put("zn", 126);

    init3();
  }
  private static void init3() {
    
    freq.put("zo", 5929);
    freq.put("zi", 6597);
    freq.put("rri", 240);
    freq.put("uee", 42);
    freq.put("ze", 6914);
    freq.put("rre", 165);
    freq.put(" é", 101);
    freq.put("za", 1425);
    freq.put("rra", 88);
    freq.put("asa", 27);
    freq.put("odi", 278);
    freq.put("Blo", 55);
    freq.put("Bli", 53);
    freq.put("zy", 48);
    freq.put("zz", 179);
    freq.put("Ble", 24);
    freq.put("zu", 538);
    freq.put("zw", 442);
    freq.put("Bla", 48);
    freq.put("rrr", 259);
    freq.put("ul ", 157);
    freq.put("F ", 122);
    freq.put("Ah ", 48);
    freq.put("med", 195);
    freq.put("sws", 40);
    freq.put("cit", 288);
    freq.put("ct ", 267);
    freq.put("rd ", 2238);
    freq.put("Thi", 21);
    freq.put("urr", 52);
    freq.put("can", 60);
    freq.put("oci", 97);
    freq.put("leb", 67);
    freq.put("enh", 147);
    freq.put("led", 365);
    freq.put("lee", 1532);
    freq.put(" ¤", 36);
    freq.put("obe", 327);
    freq.put("meg", 60);
    freq.put("lei", 477);
    freq.put("uwt", 51);
    freq.put("lek", 1186);
    freq.put("z ", 370);
    freq.put("lem", 1012);
    freq.put(" €", 156);
    freq.put("rr ", 157);
    freq.put("lep", 27);
    freq.put("ler", 743);
    freq.put("les", 852);
    freq.put("let", 344);
    freq.put("leu", 1195);
    freq.put("lev", 503);
    freq.put("od ", 500);
    freq.put("ley", 50);
    freq.put("lez", 319);
    freq.put("eni", 772);
    freq.put("rdw", 44);
    freq.put("Aha", 33);
    freq.put("oe ", 1955);
    freq.put("rds", 58);
    freq.put("rdr", 96);
    freq.put("ast", 1074);
    freq.put("rde", 1734);
    freq.put("cte", 152);
    freq.put("rdf", 44);
    freq.put("rda", 940);
    freq.put("wl", 61);
    freq.put("Ju", 140);
    freq.put("rdl", 31);
    freq.put("rdo", 160);
    freq.put("cto", 49);
    freq.put("rdi", 304);
    freq.put("cti", 443);
    freq.put("Uh", 23);
    freq.put(" Do", 426);
    freq.put("kyk", 24);
    freq.put("wie", 641);
    freq.put("Ver", 265);
    freq.put(" Di", 600);
    freq.put("bov", 140);
    freq.put("win", 614);
    freq.put(" De", 1183);
    freq.put("wil", 1559);
    freq.put("wik", 61);
    freq.put("wij", 980);
    freq.put(" Da", 1070);
    freq.put("sgi", 26);
    freq.put("Don", 60);
    freq.put("Mij", 234);
    freq.put("wis", 244);
    freq.put("ii ", 93);
    freq.put("sgo", 45);
    freq.put("OS ", 42);
    freq.put("Ven", 23);
    freq.put("NT ", 24);
    freq.put(" Du", 348);
    freq.put("apa", 136);
    freq.put("sge", 77);
    freq.put(" Dr", 130);
    freq.put("Mil", 30);
    freq.put("zaa", 185);
    freq.put("cha", 934);
    freq.put("Fr", 144);
    freq.put("fee", 246);
    freq.put("uwi", 56);
    freq.put("Fu", 77);
    freq.put("Ope", 44);
    freq.put("fen", 161);
    freq.put("chi", 1165);
    freq.put("fel", 400);
    freq.put("Min", 35);
    freq.put("Hui", 52);
    freq.put("chn", 41);
    freq.put("fei", 43);
    freq.put("Fa", 153);
    freq.put("JE ", 43);
    freq.put("feu", 65);
    freq.put("fer", 167);
    freq.put(" R ", 48);
    freq.put("Ff", 82);
    freq.put("zin", 739);
    freq.put("Fi", 172);
    freq.put("chz", 44);
    freq.put("Fl", 73);
    freq.put("Mic", 41);
    freq.put("Fo", 122);
    freq.put("dza", 23);
    freq.put("pff", 177);
    freq.put("aca", 44);
    freq.put(" D ", 380);
    freq.put("iie", 24);
    freq.put("iig", 28);
    freq.put("utj", 58);
    freq.put("ap ", 749);
    freq.put("gza", 47);
    freq.put("iii", 59);
    freq.put("ndl", 29);
    freq.put(" Ru", 110);
    freq.put("ace", 194);
    freq.put("fe ", 141);
    freq.put("f", 18372);
    freq.put("ayb", 25);
    freq.put("ox ", 54);
    freq.put("km ", 82);
    freq.put("ied", 753);
    freq.put(" Re", 325);
    freq.put("jg ", 264);
    freq.put("npl", 28);
    freq.put(" Ra", 146);
    freq.put("ric", 409);
    freq.put("enn", 492);
    freq.put(" Ro", 296);
    freq.put("exc", 35);
    freq.put(" Ri", 171);
    freq.put(" c ", 58);
    freq.put("taa", 1224);
    freq.put("tat", 332);
    freq.put("tau", 31);
    freq.put("ach", 2456);
    freq.put("tap", 160);
    freq.put("tar", 247);
    freq.put("tas", 143);
    freq.put("tac", 76);
    freq.put("tad", 221);
    freq.put("taf", 53);
    freq.put("tag", 163);
    freq.put("eno", 528);
    freq.put("tab", 37);
    freq.put("spa", 225);
    freq.put("tal", 419);
    freq.put("Aaa", 48);
    freq.put("tan", 503);
    freq.put("tai", 61);
    freq.put("tak", 52);
    freq.put(" va", 8624);
    freq.put("mix", 34);
    freq.put("kyp", 27);
    freq.put(" ve", 4526);
    freq.put(" W ", 32);
    freq.put("Yo", 59);
    freq.put("sit", 299);
    freq.put("Ya", 21);
    freq.put("afe", 97);
    freq.put("aff", 66);
    freq.put("afg", 178);
    freq.put("Ye", 120);
    freq.put(" vl", 217);
    freq.put(" vo", 6376);
    freq.put(" vn", 57);
    freq.put("sic", 52);
    freq.put("sia", 24);
    freq.put(" vr", 1911);
    freq.put(" vu", 77);
    freq.put("sie", 445);
    freq.put("exa", 43);
    freq.put("aft", 48);
    freq.put("pul", 82);
    freq.put("afv", 24);
    freq.put("dwi", 56);
    freq.put("sio", 70);
    freq.put("dwo", 21);
    freq.put("sim", 48);
    freq.put("afs", 170);
    freq.put("sis", 103);
    freq.put("npo", 26);
    freq.put("Aan", 143);
    freq.put("afm", 24);
    freq.put("act", 434);
    freq.put("npa", 86);
    freq.put("apt", 283);
    freq.put("Q", 56);
    freq.put("ta ", 256);
    freq.put(" vd", 52);
    freq.put(" v ", 120);
    freq.put("rtl", 21);
    freq.put("dd ", 235);
    freq.put("rm ", 271);
    freq.put("pag", 91);
    freq.put("vuu", 36);
    freq.put("ndt", 112);
    freq.put("Y ", 76);
    freq.put("afk", 35);
    freq.put("af ", 718);
    freq.put("Ond", 104);
    freq.put("enr", 47);
    freq.put("Onz", 29);
    freq.put(" vi", 1651);
    freq.put("si ", 28);
    freq.put("agg", 78);
    freq.put("uwb", 30);
    freq.put("ndv", 33);
    freq.put("asc", 22);
    freq.put("Ont", 53);
    freq.put("jns", 28);
    freq.put("nac", 255);
    freq.put("da ", 280);
    freq.put("kbo", 21);
    freq.put("jnt", 80);
    freq.put("Zoa", 23);
    freq.put("kba", 120);
    freq.put("ens", 3656);
    freq.put("kbe", 75);
    freq.put("jna", 379);
    freq.put("own", 146);
    freq.put("jne", 211);
    freq.put("X", 446);
    freq.put("jni", 31);
    freq.put("jnl", 78);
    freq.put("lf", 1322);
    freq.put("lg", 1086);
    freq.put("ld", 2301);
    freq.put("le", 14438);
    freq.put("lb", 204);
    freq.put("lc", 82);
    freq.put("euk", 1280);
    freq.put("la", 8738);
    freq.put("ln", 74);
    freq.put("lo", 3650);
    freq.put("ll", 6412);
    freq.put("lm", 466);
    freq.put("lj", 101);
    freq.put("lk", 1037);
    freq.put("lh", 76);
    freq.put("li", 9963);
    freq.put("lv", 271);
    freq.put("lw", 319);
    freq.put("lt", 2058);
    freq.put("lu", 1563);
    freq.put("lr", 55);
    freq.put("ls", 3554);
    freq.put("lp", 342);
    freq.put("euz", 66);
    freq.put("bin", 465);
    freq.put("eut", 64);
    freq.put("euw", 1437);
    freq.put(" h ", 65);
    freq.put("lz", 52);
    freq.put("eup", 21);
    freq.put("eus", 251);
    freq.put("ly", 267);
    freq.put("dad", 50);
    freq.put("na ", 1345);
    freq.put("daf", 40);
    freq.put("dag", 2538);
    freq.put("daa", 2482);
    freq.put("dac", 390);
    freq.put("dal", 75);
    freq.put("Car", 44);
    freq.put("dan", 3749);
    freq.put("dwe", 65);
    freq.put("vm ", 29);
    freq.put("dak", 44);
    freq.put("dat", 5714);
    freq.put("jn ", 4230);
    freq.put("dap", 23);
    freq.put("Cam", 22);
    freq.put("das", 113);
    freq.put("bar", 156);
    freq.put("day", 81);
    freq.put("ogl", 75);
    freq.put("bas", 85);
    freq.put("Pre", 42);
    freq.put(" hy", 124);
    freq.put("afw", 49);
    freq.put("Pra", 44);
    freq.put("San", 37);
    freq.put("l ", 16383);
    freq.put("nfo", 146);
    freq.put("oep", 372);
    freq.put("Pro", 87);
    freq.put(" hw", 77);
    freq.put("eu ", 40);
    freq.put(" hu", 1148);
    freq.put(" ht", 107);
    freq.put(" hi", 1769);
    freq.put(" hh", 27);
    freq.put(" ho", 4088);
    freq.put("afr", 29);
    freq.put(" hm", 114);
    freq.put("kpi", 36);
    freq.put(" ha", 5689);
    freq.put("EG ", 21);
    freq.put("kpl", 24);
    freq.put("wsg", 24);
    freq.put(" he", 15079);
    freq.put("ouk", 27);
    freq.put("ouj", 31);
    freq.put("oun", 128);
    freq.put("ec ", 36);
    freq.put("ouc", 282);
    freq.put("lfo", 31);
    freq.put("uwe", 1261);
    freq.put("oud", 1086);
    freq.put("lft", 85);
    freq.put("mar", 286);
    freq.put("lfs", 107);
    freq.put("wes", 66);
    freq.put("ous", 102);
    freq.put("pam", 28);
    freq.put("oup", 28);
    freq.put("ouw", 962);
    freq.put("oww", 42);
    freq.put("ouu", 39);
    freq.put("out", 340);
    freq.put("exi", 29);
    freq.put("rer", 52);
    freq.put("res", 694);
    freq.put("rep", 93);
    freq.put("sna", 294);
    freq.put("rev", 80);
    freq.put("Tuu", 21);
    freq.put("ret", 202);
    freq.put("reu", 50);
    freq.put("bij", 2822);
    freq.put("rek", 525);
    freq.put("rei", 467);
    freq.put("ren", 3109);
    freq.put("wer", 1726);
    freq.put("rel", 364);
    freq.put("rem", 88);
    freq.put("reb", 21);
    freq.put("rec", 614);
    freq.put("rea", 384);
    freq.put("ref", 60);
    freq.put("reg", 417);
    freq.put("red", 367);
    freq.put("ree", 994);
    freq.put("dm ", 42);
    freq.put("ece", 69);
    freq.put("lf ", 828);
    freq.put("loc", 69);
    freq.put("eco", 166);
    freq.put("cre", 96);
    freq.put("eck", 155);
    freq.put("eci", 209);
    freq.put("ech", 2778);
    freq.put("qua", 37);
    freq.put("zzz", 46);
    freq.put("ect", 402);
    freq.put("que", 64);
    freq.put("ecr", 30);
    freq.put("ie ", 8851);
    freq.put("qui", 25);
    freq.put("van", 7728);
    freq.put("by ", 168);
    freq.put("utt", 101);
    freq.put("ltr", 32);
    freq.put("aps", 77);
    freq.put("g", 58202);
    freq.put("anh", 34);
    freq.put("lty", 27);
    freq.put("loe", 245);
    freq.put("ask", 42);
    freq.put("Ric", 48);
    freq.put(" hé", 36);
    freq.put(" hè", 111);
    freq.put("lte", 135);
    freq.put("nva", 90);
    freq.put("ltj", 149);
    freq.put("re ", 1113);
    freq.put("lto", 23);
    freq.put("K ", 330);
    freq.put("rs ", 1961);
    freq.put("arr", 160);
    freq.put("IT ", 71);
    freq.put("loo", 640);
    freq.put("ud ", 355);
    freq.put("ihi", 317);
    freq.put("lib", 36);
    freq.put("ses", 86);
    freq.put("iha", 45);
    freq.put("og ", 3385);
    freq.put("lor", 83);
    freq.put("ao ", 24);
    freq.put("arv", 87);
    freq.put("los", 176);
    freq.put("usj", 172);
    freq.put(" Sp", 219);
    freq.put("arw", 22);
    freq.put(" Sw", 21);
    freq.put(" St", 556);
    freq.put(" Su", 144);
    freq.put(" Sj", 25);
    freq.put(" Sk", 22);
    freq.put(" Sh", 75);
    freq.put(" Si", 160);
    freq.put(" Sn", 72);
    freq.put(" So", 299);
    freq.put(" Sl", 180);
    freq.put(" Sm", 35);
    freq.put(" Sc", 228);
    freq.put(" Sa", 188);
    freq.put("nut", 191);
    freq.put("mer", 1235);
    freq.put(" Se", 120);
    freq.put("rsl", 191);
    freq.put("uds", 24);
    freq.put("Ka", 379);
    freq.put("rso", 189);
    freq.put("rsi", 85);
    freq.put("Ke", 133);
    freq.put("Kk", 27);
    freq.put("rse", 157);
    freq.put("Ki", 224);
    freq.put("Kh", 24);
    freq.put("Ko", 376);
    freq.put("Kn", 31);
    freq.put("rsb", 29);
    freq.put("Kl", 195);
    freq.put("ogm", 22);
    freq.put("Kr", 94);
    freq.put("ogo", 34);
    freq.put("R", 3864);
    freq.put("Kw", 31);
    freq.put("ogh", 27);
    freq.put("Ku", 136);
    freq.put("eho", 244);
    freq.put("rst", 1152);
    freq.put("rsu", 44);
    freq.put("rsv", 21);
    freq.put("udi", 142);
    freq.put("rsp", 88);
    freq.put("beh", 130);
    freq.put("lim", 151);
    freq.put("rss", 31);
    freq.put("vie", 362);
    freq.put("pva", 28);
    freq.put("uhm", 47);
    freq.put("ehm", 28);
    freq.put("ben", 3799);
    freq.put("bel", 709);
    freq.put("ara", 202);
    freq.put("nou", 577);
    freq.put("lea", 84);
    freq.put("bea", 64);
    freq.put("onc", 107);
    freq.put("beg", 602);
    freq.put("bed", 976);
    freq.put("bee", 703);
    freq.put("Zom", 83);
    freq.put("lpe", 101);
    freq.put("AL ", 42);
    freq.put("arc", 137);
    freq.put("ber", 991);
    freq.put("yba", 21);
    freq.put(" S ", 145);
    freq.put("bev", 110);
    freq.put("bew", 155);
    freq.put("bet", 697);
    freq.put("beu", 174);
    freq.put("Pap", 31);
    freq.put("alb", 70);
    freq.put("Par", 61);
    freq.put("Pas", 25);
    freq.put("Pat", 21);
    freq.put("Pau", 60);
    freq.put("Kle", 30);
    freq.put("dA ", 21);
    freq.put("Med", 44);
    freq.put("arg", 44);
    freq.put(" E ", 52);
    freq.put("eak", 85);
    freq.put("nuf", 61);
    freq.put("Kap", 23);
    freq.put("Pad", 36);
    freq.put("fdd", 21);
    freq.put("py ", 35);
    freq.put("alc", 30);
    freq.put("st", 14108);
    freq.put("arj", 67);
    freq.put("Pan", 23);
    freq.put("she", 57);
    freq.put("sk", 483);
    freq.put("mik", 21);
    freq.put("mij", 2606);
    freq.put("ur ", 1476);
    freq.put("ck ", 530);
    freq.put("lec", 275);
    freq.put("ghe", 133);
    freq.put("arl", 158);
    freq.put("mic", 36);
    freq.put("ang", 1623);
    freq.put("mie", 147);
    freq.put("mid", 398);
    freq.put("mig", 190);
    freq.put("arm", 355);
    freq.put("als", 2358);
    freq.put("eaa", 84);
    freq.put("pvo", 28);
    freq.put("bus", 270);
    freq.put("ER ", 113);
    freq.put("mis", 789);
    freq.put("aro", 660);
    freq.put("uhh", 36);
    freq.put("Der", 22);
    freq.put("gha", 39);
    freq.put(" El", 86);
    freq.put(" Em", 36);
    freq.put(" En", 902);
    freq.put("J", 2158);
    freq.put(" Eh", 28);
    freq.put(" Ei", 160);
    freq.put(" Ed", 31);
    freq.put(" Ee", 475);
    freq.put("sl", 2475);
    freq.put(" Ec", 127);
    freq.put("sfo", 34);
    freq.put(" Ex", 37);
    freq.put(" Ey", 40);
    freq.put("st ", 3505);
    freq.put(" Et", 33);
    freq.put(" Eu", 95);
    freq.put(" Ev", 164);
    freq.put("sfe", 39);
    freq.put("ny ", 85);
    freq.put(" Er", 258);
    freq.put(" Es", 26);
    freq.put("cke", 216);
    freq.put("ure", 474);
    freq.put("urf", 64);
    freq.put("urg", 194);
    freq.put("mus", 55);
    freq.put("urb", 21);
    freq.put("ckb", 56);
    freq.put("url", 261);
    freq.put("mi ", 52);
    freq.put("urn", 43);
    freq.put("uro", 302);
    freq.put("cki", 189);
    freq.put("uri", 90);
    freq.put("fje", 103);
    freq.put("urk", 126);
    freq.put("urt", 446);
    freq.put("ckt", 46);
    freq.put("Pol", 59);
    freq.put("urw", 29);
    freq.put("urp", 28);
    freq.put("cks", 78);
    freq.put("urs", 137);
    freq.put("Del", 31);
    freq.put("Pod", 29);
    freq.put("ota", 102);
    freq.put("mg ", 195);
    freq.put("Den", 135);
    freq.put("Cha", 62);
    freq.put(" iP", 115);
    freq.put("bum", 38);
    freq.put("dbe", 40);
    freq.put("Zit", 63);
    freq.put("lse", 77);
    freq.put("Che", 57);
    freq.put("eda", 639);
    freq.put("nge", 2770);
    freq.put("ear", 67);
    freq.put("nga", 56);
    freq.put("jax", 159);
    freq.put("co ", 108);
    freq.put(" ip", 133);
    freq.put("jaw", 41);
    freq.put(" ir", 136);
    freq.put(" is", 6772);
    freq.put(" it", 109);
    freq.put("jas", 98);
    freq.put(" iv", 29);
    freq.put("kse", 91);
    freq.put("q ", 78);
    freq.put("jal", 48);
    freq.put("jam", 173);
    freq.put("jaj", 34);
    freq.put(" im", 39);
    freq.put(" in", 7042);
    freq.put("ngs", 396);
    freq.put("eav", 23);
    freq.put(" id", 376);
    freq.put("jac", 38);
    freq.put("ngz", 47);
    freq.put("jaa", 1096);
    freq.put("uut", 78);
    freq.put("mge", 49);
    freq.put("lsj", 32);
    freq.put("bud", 26);
    freq.put("bby", 27);
    freq.put("tbi", 124);
    freq.put("ush", 65);
    freq.put("mul", 39);
    freq.put("tba", 312);
    freq.put("Kan", 181);
    freq.put("ttt", 60);
    freq.put("tbe", 26);
    freq.put("qq", 123);
    freq.put(" we", 11574);
    freq.put("qu", 143);
    freq.put(" wc", 41);
    freq.put(" wa", 6717);
    freq.put("h", 58454);
    freq.put("ars", 287);
    freq.put("lst", 113);
    freq.put(" wh", 243);
    freq.put(" wi", 3314);
    freq.put("zic", 349);
    freq.put(" ww", 105);
    freq.put(" wt", 94);
    freq.put("Zie", 105);
    freq.put(" wr", 86);
    freq.put("ks ", 1063);
    freq.put("Kam", 46);
    freq.put(" i ", 111);
    freq.put("shi", 252);
    freq.put("dpl", 21);
    freq.put("ael", 38);
    freq.put("ja ", 1507);
    freq.put("sho", 274);
    freq.put("Pr", 250);
    freq.put("ebe", 301);
    freq.put("btw", 34);
    freq.put("Pv", 23);
    freq.put("eba", 98);
    freq.put("ebb", 861);
    freq.put("Pu", 28);
    freq.put("ebl", 83);
    freq.put("uim", 171);
    freq.put("ebo", 316);
    freq.put("we", 16420);
    freq.put("Zon", 72);
    freq.put("ke ", 2117);
    freq.put("jo ", 39);
    freq.put("ebu", 28);
    freq.put("Pa", 336);
    freq.put("Pf", 138);
    freq.put("Zou", 73);
    freq.put("ebr", 312);
    freq.put("Pe", 122);
    freq.put("ede", 2570);
    freq.put("omg", 181);
    freq.put("Ph", 89);
    freq.put("Pi", 123);
    freq.put("tof", 122);
    freq.put("Po", 204);
    freq.put("Pl", 124);
    freq.put("hé ", 26);
    freq.put("lve", 147);
    freq.put("lus", 113);
    freq.put("lut", 25);
    freq.put(" ii", 32);
    freq.put("dle", 34);
    freq.put("lux", 25);
    freq.put("dli", 23);
    freq.put("omd", 376);
    freq.put("dlo", 52);
    freq.put("kk ", 181);
    freq.put("omk", 43);
    freq.put("et ", 23237);
    freq.put("luc", 121);
    freq.put("edj", 251);
    freq.put("Zee", 46);
    freq.put("lui", 467);
    freq.put("lip", 120);
    freq.put("lul", 84);
    freq.put("omi", 137);
    freq.put("rpi", 39);
    freq.put("Zo ", 453);
    freq.put("ken", 5717);
    freq.put("kem", 68);
    freq.put("kel", 704);
    freq.put("kek", 93);
    freq.put("jou", 850);
    freq.put("kei", 81);
    freq.put("eul", 32);
    freq.put("wk", 62);
    freq.put("kee", 1027);
    freq.put("ked", 54);
    freq.put("tsl", 116);
    freq.put("Kar", 26);
    freq.put("S", 3061);
    freq.put("eun", 78);
    freq.put("edk", 38);
    freq.put("joe", 87);
    freq.put("key", 60);
    freq.put("joh", 132);
    freq.put("joi", 21);
    freq.put("keu", 124);
    freq.put("ket", 145);
    freq.put("kes", 43);
    freq.put("ker", 3109);
    freq.put("jon", 389);
    freq.put("joo", 44);
    freq.put("etr", 168);
    freq.put("ets", 1648);
    freq.put("etp", 25);
    freq.put("loa", 105);
    freq.put("etw", 211);
    freq.put("ett", 495);
    freq.put("etu", 31);
    freq.put("etz", 61);
    freq.put("è", 168);
    freq.put("llu", 24);
    freq.put("euj", 25);
    freq.put("aho", 30);
    freq.put("etb", 276);
    freq.put("etc", 32);
    freq.put("tla", 56);
    freq.put("wt", 185);
    freq.put("etd", 37);
    freq.put("ete", 2887);
    freq.put("etj", 918);
    freq.put("omw", 35);
    freq.put("eth", 44);
    freq.put("eti", 215);
    freq.put("etn", 26);
    freq.put("eug", 122);
    freq.put("Moo", 155);
    freq.put("Het", 641);
    freq.put("ci", 930);
    freq.put("ch", 13847);
    freq.put("co", 1840);
    freq.put("wtf", 83);
    freq.put("Her", 54);
    freq.put("cl", 332);
    freq.put("cc", 413);
    freq.put(" al", 6707);
    freq.put("ca", 816);
    freq.put("bis", 24);
    freq.put("Hey", 58);
    freq.put("ce", 1245);
    freq.put("cd", 40);
    freq.put("rpa", 40);
    freq.put("Hee", 298);
    freq.put("cy", 49);
    freq.put("Hoe", 320);
    freq.put("rpe", 86);
    freq.put("Heb", 385);
    freq.put("Hel", 137);
    freq.put("cr", 261);
    freq.put("Hen", 35);
    freq.put("tsa", 74);
    freq.put("Heh", 24);
    freq.put("Hei", 31);
    freq.put("cu", 306);
    freq.put("ct", 1032);
    freq.put("Ges", 47);
    freq.put("Ger", 32);
    freq.put("vit", 51);
    freq.put("Gew", 93);
    freq.put("rve", 319);
    freq.put("bbi", 24);
    freq.put("Gez", 100);
    freq.put("bbe", 959);
    freq.put("ys ", 89);
    freq.put("Jul", 50);
    freq.put("uct", 96);
    freq.put("Hon", 38);
    freq.put(" as", 108);
    freq.put("Gef", 70);
    freq.put("Gee", 204);
    freq.put("Hoo", 128);
    freq.put("Gek", 24);
    freq.put("IE ", 53);
    freq.put("Gen", 75);
    freq.put("Gem", 28);
    freq.put("Gel", 142);
    freq.put("OL ", 48);
    freq.put("oti", 111);
    freq.put("otj", 98);
    freq.put("ey ", 342);
    freq.put("oto", 498);
    freq.put("rvo", 130);
    freq.put("AM ", 63);
    freq.put("c ", 566);
    freq.put("edo", 328);
    freq.put("ote", 625);
    freq.put("lgd", 30);
    freq.put("oha", 25);
    freq.put("hmm", 118);
    freq.put("otz", 21);
    freq.put("IK ", 62);
    freq.put("He ", 22);
    freq.put("inr", 26);
    freq.put("uc ", 24);
    freq.put("cou", 117);
    freq.put("Aar", 23);
    freq.put("Hoi", 34);
    freq.put("ott", 189);
    freq.put("tst", 650);
    freq.put("lgt", 34);
    freq.put("And", 78);
    freq.put("inl", 41);
    freq.put("lli", 1212);
    freq.put("euv", 25);
    freq.put("ndr", 134);
    freq.put("é", 402);
    freq.put("Ann", 41);
    freq.put("rbr", 50);
    freq.put("tss", 42);
    freq.put("Ant", 40);
    freq.put("bie", 391);
    freq.put("Hou", 71);
    freq.put("tsp", 78);
    freq.put("rbi", 226);
    freq.put("ub ", 114);
    freq.put("rbe", 224);
    freq.put("eur", 809);
    freq.put("ya ", 25);
    freq.put("rba", 96);
    freq.put("yst", 50);
    freq.put("va", 9832);
    freq.put(" Fr", 143);
    freq.put(" Fu", 76);
    freq.put("ve", 11852);
    freq.put("vi", 2259);
    freq.put("uiv", 35);
    freq.put("vl", 310);
    freq.put("vm", 36);
    freq.put("vn", 65);
    freq.put("vo", 8181);
    freq.put(" Fa", 152);
    freq.put("Shi", 26);
    freq.put("vr", 2168);
    freq.put("vs", 24);
    freq.put(" Fe", 147);
    freq.put("vu", 122);
    freq.put("vv", 34);
    freq.put(" Ff", 81);
    freq.put(" Fi", 170);
    freq.put("ave", 157);
    freq.put("You", 42);
    freq.put("zod", 50);
    freq.put(" Fl", 69);
    freq.put(" Fo", 117);
    freq.put("io ", 249);
    freq.put("coa", 25);
    freq.put("of ", 1521);
    freq.put("pis", 37);
    freq.put("edr", 228);
    freq.put("umb", 39);
    freq.put("utu", 30);
    freq.put("dam", 456);
    freq.put(" éc", 21);
    freq.put(" T ", 64);
    freq.put("v ", 581);
    freq.put("phi", 26);
    freq.put("eds", 616);
    freq.put("ay ", 231);
    freq.put("mkl", 50);
    freq.put("pha", 83);
    freq.put("iot", 27);
    freq.put("ios", 62);
    freq.put("ior", 37);
    freq.put("phe", 35);
    freq.put("ioo", 25);
    freq.put(" F ", 29);
    freq.put("app", 813);
    freq.put("iol", 26);
    freq.put("AT ", 88);
    freq.put("coh", 23);
    freq.put("Tip", 23);
    freq.put("ioe", 37);
    freq.put("iod", 22);
    freq.put("von", 1170);
    freq.put("Yes", 42);
    freq.put("ont", 900);
    freq.put("off", 310);
    freq.put("ofd", 304);
    freq.put("ofe", 27);
    freq.put(" Tw", 260);
    freq.put(" Tu", 84);
    freq.put("ofi", 58);
    freq.put(" Ts", 23);
    freq.put(" Tr", 181);
    freq.put(" To", 333);
    freq.put("ofs", 86);
    freq.put(" Tj", 32);
    freq.put(" Ti", 206);
    freq.put(" Th", 257);
    freq.put("ofz", 367);
    freq.put("R ", 277);
    freq.put(" Te", 332);
    freq.put(" Ta", 121);
    freq.put("oal", 179);
    freq.put("dar", 65);
    freq.put("xen", 33);
    freq.put("ksh", 41);
    freq.put(" xD", 409);
    freq.put("tco", 21);
    freq.put("Wal", 21);
    freq.put("tch", 136);
    freq.put("sre", 33);
    freq.put("AR ", 34);
    freq.put("sku", 115);
    freq.put("Be", 1064);
    freq.put("gmi", 25);
    freq.put("now", 66);
    freq.put(" xo", 54);
    freq.put("Ba", 286);
    freq.put("wee", 5954);
    freq.put("wed", 262);
    freq.put("Bl", 190);
    freq.put("nop", 81);
    freq.put("gma", 50);
    freq.put("Bo", 294);
    freq.put("Oh ", 122);
    freq.put("Bi", 385);
    freq.put("wem", 82);
    freq.put(" xd", 454);
    freq.put("ske", 86);
    freq.put("Bu", 120);
    freq.put("add", 152);
    freq.put(" xx", 234);
    freq.put("ska", 64);
    freq.put("nor", 243);
    freq.put("Br", 271);
    freq.put("wet", 354);
    freq.put("Fac", 75);
    freq.put("sko", 48);
    freq.put("Sho", 23);
    freq.put("ski", 66);
    freq.put("adk", 24);
    freq.put("oar", 33);
    freq.put("gt ", 1030);
    freq.put("amb", 88);
    freq.put("xe ", 24);
    freq.put("nvr", 33);
    freq.put("oer", 724);
    freq.put("nfe", 24);
    freq.put("boo", 371);
    freq.put("Iet", 26);
    freq.put("Lat", 36);
    freq.put("nve", 113);
    freq.put("T", 2275);
    freq.put("Eig", 30);
    freq.put("ode", 314);
    freq.put("nvo", 51);
    freq.put("edt", 38);
    freq.put("nvl", 24);
    freq.put("ack", 357);
    freq.put("tc ", 38);
    freq.put("Ein", 121);
    freq.put("we ", 2198);
    freq.put("B ", 260);
    freq.put("Sam", 51);
    freq.put(" x ", 412);
    freq.put("eïn", 24);
    freq.put("xx ", 74);
    freq.put("sk ", 26);
    freq.put("zza", 44);
    freq.put("Zet", 22);
    freq.put("Las", 26);
    freq.put("am ", 1013);
    freq.put("nja", 48);
    freq.put("Suc", 52);
    freq.put("mba", 65);
    freq.put("nce", 239);
    freq.put("ui ", 88);
    freq.put("Pri", 71);
    freq.put("njo", 32);
    freq.put("kda", 29);
    freq.put("jle", 52);
    freq.put("tpr", 22);
    freq.put("nfi", 27);
    freq.put("Sup", 49);
    freq.put("Lui", 27);
    freq.put("U ", 131);
    freq.put("tum", 59);
    freq.put("esv", 22);
    freq.put("esu", 48);
    freq.put("est", 2509);
    freq.put("ess", 569);
    freq.put("esp", 416);
    freq.put("atw", 29);
    freq.put("nd ", 5014);
    freq.put("Ied", 79);
    freq.put("tma", 60);
    freq.put("ese", 267);
    freq.put("esd", 27);
    freq.put("esc", 330);
    freq.put("esb", 24);
    freq.put("esa", 22);
    freq.put("eso", 115);
    freq.put("kr ", 78);
    freq.put("esl", 284);
    freq.put("esk", 28);
    freq.put(" j ", 34);
    freq.put("esi", 79);
    freq.put("esh", 52);
    freq.put("vid", 122);
    freq.put("swi", 41);
    freq.put("oev", 193);
    freq.put("afd", 66);
    freq.put("dui", 245);
    freq.put("Ut", 78);
    freq.put("lle", 3983);
    freq.put("aam", 395);
    freq.put("tso", 21);
    freq.put("Un", 31);
    freq.put("Ui", 101);
    freq.put("jl ", 122);
    freq.put("Sar", 27);
    freq.put("dul", 23);
    freq.put("dum", 22);
    freq.put("ndi", 489);
    freq.put("ndh", 79);
    freq.put("ndj", 292);
    freq.put(" jy", 46);
    freq.put("dun", 29);
    freq.put("ndo", 174);
    freq.put(" ju", 708);
    freq.put("ndb", 30);
    freq.put("nde", 4977);
    freq.put("ndd", 44);
    freq.put("kru", 81);
    freq.put("ndy", 29);
    freq.put("swa", 67);
    freq.put(" jo", 1497);
    freq.put("kri", 591);
    freq.put(" ji", 1356);
    freq.put("kro", 81);
    freq.put("es ", 3563);
    freq.put(" je", 8873);
    freq.put("nds", 528);
    freq.put("kra", 211);
    freq.put(" ja", 2738);
    freq.put("EE ", 32);
    freq.put("ndw", 44);
    freq.put("kre", 175);
    freq.put("owl", 31);
    freq.put("duc", 93);
    freq.put("owi", 103);
    freq.put("lfd", 125);
    freq.put("owe", 173);
    freq.put("ea ", 112);
    freq.put("Twi", 141);
    freq.put("owa", 37);
    freq.put("pzo", 39);
    freq.put("De ", 766);
    freq.put("sve", 85);
    freq.put("h ", 4518);
    freq.put("oek", 1140);
    freq.put("ows", 31);
    freq.put("jzo", 36);
    freq.put("vak", 359);
    freq.put("AN ", 69);
    freq.put("wsb", 25);
    freq.put("zyn", 30);
    freq.put("val", 702);
    freq.put("Sch", 206);
    freq.put("Te ", 40);
    freq.put("rcu", 24);
    freq.put("jze", 98);
    freq.put("Amb", 45);
    freq.put("Ame", 56);
    freq.put("Roe", 36);
    freq.put("vad", 121);
    freq.put("ubi", 22);
    freq.put("dzo", 21);
    freq.put("rco", 43);
    freq.put("rch", 43);
    freq.put("rci", 45);
    freq.put("var", 94);
    freq.put("rce", 67);
    freq.put("Ams", 167);
    freq.put("bes", 872);
    freq.put("rca", 53);
    freq.put("vat", 104);
    freq.put("xam", 31);
    freq.put("hz", 51);
    freq.put("eah", 85);
    freq.put("Dez", 89);
    freq.put("hy", 168);
    freq.put("eam", 121);
    freq.put("eal", 103);
    freq.put("ean", 50);
    freq.put("hr", 429);
    freq.put("hs", 34);
    freq.put("hp", 23);
    freq.put("Klo", 43);
    freq.put("hv", 26);
    freq.put("hw", 155);
    freq.put("ht", 6686);
    freq.put("hu", 2110);
    freq.put("hj", 89);
    freq.put("hh", 747);
    freq.put("hi", 3782);
    freq.put("hn", 132);
    freq.put("ho", 6740);
    freq.put("hl", 34);
    freq.put("hm", 250);
    freq.put("hb", 45);
    freq.put("eas", 84);
    freq.put("ha", 13940);
    freq.put("eau", 127);
    freq.put("eat", 126);
    freq.put("hd", 24);
    freq.put("he", 17881);
    freq.put("dus", 1005);
    freq.put("lso", 88);
    freq.put("Tem", 33);
    freq.put("Ten", 26);
    freq.put("aah", 345);
    freq.put("avi", 62);
    freq.put("va ", 139);
    freq.put("j", 45787);
    freq.put("duu", 123);
    freq.put("ow ", 447);
    freq.put("eok", 22);
    freq.put("lva", 68);
    freq.put("Ter", 72);
    freq.put("Tes", 21);
    freq.put("lvi", 27);
    freq.put("pij", 425);
    freq.put("pik", 34);
    freq.put("pil", 56);
    freq.put("OO ", 24);
    freq.put("inz", 39);
    freq.put("pio", 36);
    freq.put("int", 917);
    freq.put("inu", 211);
    freq.put("inv", 62);
    freq.put("pic", 46);
    freq.put("inp", 51);
    freq.put("pie", 360);
    freq.put("Gvd", 22);
    freq.put("ins", 467);
    freq.put("IJ ", 38);
    freq.put("inm", 47);
    freq.put("inn", 909);
    freq.put("ino", 74);
    freq.put("inh", 63);
    freq.put("ini", 407);
    freq.put("ink", 721);
    freq.put("ind", 2165);
    freq.put("ine", 891);
    freq.put("inf", 110);
    freq.put("ing", 4695);
    freq.put("pit", 80);
    freq.put("ina", 259);
    freq.put("inb", 34);
    freq.put("inc", 101);
    freq.put("wal", 86);
    freq.put("hn ", 29);
    freq.put("eo ", 113);
    freq.put("oac", 25);
    freq.put(" Ut", 76);
    freq.put("Doo", 76);
    freq.put(" € ", 154);
    freq.put("ari", 502);
    freq.put(" Un", 28);
    freq.put(" Uh", 23);
    freq.put(" Ui", 100);
    freq.put("gav", 65);
    freq.put("nra", 30);
    freq.put("Acc", 21);
    freq.put("DA ", 50);
    freq.put("ubs", 32);
    freq.put("gas", 105);
    freq.put("Ach", 44);
    freq.put("gar", 67);
    freq.put("oem", 243);
    freq.put("ube", 72);
    freq.put("hè", 116);
    freq.put("hé", 40);
    freq.put("U", 450);
    freq.put("ubb", 70);
    freq.put("ubl", 42);
    freq.put("my ", 135);
    freq.put("in ", 7282);
    freq.put("Mar", 202);
    freq.put("aat", 3669);
    freq.put("Kat", 23);
    freq.put("amp", 258);
    freq.put("oa ", 34);
    freq.put("hni", 36);
    freq.put("big", 25);
    freq.put("oel", 1018);
    freq.put("eor", 43);
    freq.put("eop", 44);
    freq.put("gew", 1606);
    freq.put("sst", 63);
    freq.put("hnx", 24);
    freq.put("Mau", 44);
    freq.put(" U ", 45);
    freq.put("Tur", 25);
    freq.put("att", 349);
    freq.put("Zul", 21);
  }
  
}

