package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class NO {
  private static final String name = "no";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public NO() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 238444;
    n_words[1] = 292214;
    n_words[2] = 232643;

    freq.put("ørl", 5);
    freq.put("ørn", 17);
    freq.put("øri", 19);
    freq.put("xtr", 3);
    freq.put("ørk", 14);
    freq.put("øre", 215);
    freq.put("ørd", 26);
    freq.put("ørg", 3);
    freq.put("øra", 6);
    freq.put("ørb", 3);
    freq.put("ørt", 58);
    freq.put("ørs", 108);
    freq.put("ørr", 31);
    freq.put("ør ", 248);
    freq.put("tjå", 3);
    freq.put(" yn", 3);
    freq.put(" yo", 19);
    freq.put("k", 10199);
    freq.put(" ye", 5);
    freq.put(" yt", 9);
    freq.put("Læ", 3);
    freq.put("Lå", 6);
    freq.put("Lø", 11);
    freq.put("dne", 12);
    freq.put(" £ ", 4);
    freq.put("dni", 23);
    freq.put("Le", 52);
    freq.put("La", 52);
    freq.put("Lo", 31);
    freq.put("Li", 98);
    freq.put("Lu", 27);
    freq.put("Ly", 18);
    freq.put("hod", 25);
    freq.put("hon", 16);
    freq.put("hoo", 3);
    freq.put("hol", 66);
    freq.put("hom", 12);
    freq.put("hoi", 4);
    freq.put("hov", 21);
    freq.put("how", 5);
    freq.put("hot", 12);
    freq.put("hor", 7);
    freq.put("hos", 17);
    freq.put("hop", 20);
    freq.put("A", 376);
    freq.put("L ", 39);
    freq.put("ho ", 10);
    freq.put(" V ", 3);
    freq.put("AP ", 4);
    freq.put("fir", 19);
    freq.put("fis", 17);
    freq.put("jøs", 3);
    freq.put("jør", 193);
    freq.put("Hit", 4);
    freq.put("Lør", 5);
    freq.put("fit", 4);
    freq.put("jøv", 7);
    freq.put("rü", 6);
    freq.put("rø", 198);
    freq.put("fic", 3);
    freq.put("ræ", 9);
    freq.put("jøe", 4);
    freq.put("fie", 12);
    freq.put("fik", 56);
    freq.put("små", 40);
    freq.put("Hil", 4);
    freq.put("Him", 5);
    freq.put("fil", 46);
    freq.put("jøn", 47);
    freq.put(" Va", 37);
    freq.put(" Ve", 90);
    freq.put(" Vi", 142);
    freq.put(" Vo", 10);
    freq.put("ews", 4);
    freq.put(" Vu", 8);
    freq.put("jø ", 4);
    freq.put("fi ", 5);
    freq.put("atø", 3);
    freq.put("rP", 11);
    freq.put("mde", 4);
    freq.put("rF", 3);
    freq.put("Eg ", 11);
    freq.put("rt", 1058);
    freq.put("ru", 376);
    freq.put("rv", 95);
    freq.put("rw", 8);
    freq.put("rp", 77);
    freq.put("rr", 259);
    freq.put("rs", 631);
    freq.put("dst", 16);
    freq.put("dsr", 3);
    freq.put("ry", 157);
    freq.put("rz", 4);
    freq.put("rd", 504);
    freq.put("re", 2957);
    freq.put("rf", 118);
    freq.put("rg", 263);
    freq.put("dsj", 7);
    freq.put("ra", 1180);
    freq.put("rb", 112);
    freq.put("rc", 13);
    freq.put("rl", 163);
    freq.put("dsg", 3);
    freq.put("rn", 285);
    freq.put("ro", 591);
    freq.put("rh", 70);
    freq.put("ri", 1023);
    freq.put("rj", 8);
    freq.put("rk", 262);
    freq.put(" Vå", 15);
    freq.put(" Væ", 5);
    freq.put("syn", 83);
    freq.put("Ego", 3);
    freq.put("sys", 9);
    freq.put("ate", 154);
    freq.put("atc", 8);
    freq.put("ata", 38);
    freq.put("atn", 4);
    freq.put("ato", 13);
    freq.put("atl", 4);
    freq.put("atm", 3);
    freq.put("ath", 6);
    freq.put("ati", 65);
    freq.put("att", 302);
    freq.put("atu", 41);
    freq.put("r ", 8786);
    freq.put("ats", 29);
    freq.put("ds ", 27);
    freq.put("Swe", 4);
    freq.put("Du ", 66);
    freq.put("Sof", 6);
    freq.put("nze", 4);
    freq.put("kna", 18);
    freq.put("Ass", 3);
    freq.put("vgj", 11);
    freq.put("vga", 3);
    freq.put("Asi", 3);
    freq.put("lp ", 20);
    freq.put("nen", 195);
    freq.put(" ff", 3);
    freq.put("knu", 9);
    freq.put("lpu", 3);
    freq.put("vg ", 3);
    freq.put("lpe", 22);
    freq.put("lpa", 4);
    freq.put("X", 14);
    freq.put("net", 197);
    freq.put("Ris", 5);
    freq.put("Rih", 3);
    freq.put("PS ", 6);
    freq.put("øtt", 52);
    freq.put("irr", 17);
    freq.put("irs", 11);
    freq.put("irt", 4);
    freq.put("iru", 3);
    freq.put("iri", 10);
    freq.put("øte", 29);
    freq.put("irk", 60);
    freq.put("irm", 10);
    freq.put("iro", 7);
    freq.put("ira", 17);
    freq.put("ire", 56);
    freq.put("mrå", 7);
    freq.put("DM ", 5);
    freq.put("øt ", 8);
    freq.put("ir ", 250);
    freq.put("pre", 84);
    freq.put("fra", 240);
    freq.put("fre", 104);
    freq.put("fri", 60);
    freq.put("fro", 14);
    freq.put("Låt", 3);
    freq.put("fru", 11);
    freq.put("fry", 9);
    freq.put("pro", 100);
    freq.put("bå", 34);
    freq.put("Nav", 4);
    freq.put("bæ", 10);
    freq.put("dhj", 3);
    freq.put("frå", 7);
    freq.put("dhe", 21);
    freq.put("bie", 4);
    freq.put("LO ", 4);
    freq.put("sme", 30);
    freq.put("hah", 56);
    freq.put("hai", 4);
    freq.put("hak", 5);
    freq.put("hal", 41);
    freq.put("ham", 26);
    freq.put("han", 227);
    freq.put("bø", 42);
    freq.put("hab", 3);
    freq.put("hac", 4);
    freq.put("had", 109);
    freq.put("hag", 14);
    freq.put("hap", 3);
    freq.put("har", 669);
    freq.put("hat", 62);
    freq.put("hau", 9);
    freq.put("hav", 18);
    freq.put("ha ", 182);
    freq.put("ola", 34);
    freq.put("olb", 8);
    freq.put("old", 103);
    freq.put("ole", 81);
    freq.put("olf", 7);
    freq.put("olg", 7);
    freq.put("oli", 115);
    freq.put("olj", 6);
    freq.put("olk", 114);
    freq.put("oll", 80);
    freq.put("olm", 6);
    freq.put("oln", 3);
    freq.put("olo", 18);
    freq.put("ols", 16);
    freq.put("olt", 25);
    freq.put("olu", 13);
    freq.put("olv", 9);
    freq.put("fot", 52);
    freq.put("umt", 4);
    freq.put("ump", 10);
    freq.put("for", 1076);
    freq.put("fos", 4);
    freq.put("ume", 22);
    freq.put("umf", 3);
    freq.put("umb", 3);
    freq.put("fol", 119);
    freq.put("fon", 27);
    freq.put("fok", 11);
    freq.put("ol ", 51);
    freq.put("o", 10819);
    freq.put("fo ", 10);
    freq.put("um ", 50);
    freq.put("lm ", 16);
    freq.put("mbo", 9);
    freq.put("sod", 9);
    freq.put("sof", 13);
    freq.put("mbe", 24);
    freq.put("Fem", 5);
    freq.put("som", 683);
    freq.put("sol", 42);
    freq.put("Fei", 5);
    freq.put("sop", 6);
    freq.put("Fet", 4);
    freq.put("sor", 25);
    freq.put("Fer", 5);
    freq.put("sov", 43);
    freq.put("mbu", 5);
    freq.put("so ", 10);
    freq.put("mb ", 3);
    freq.put("azi", 5);
    freq.put("azz", 3);
    freq.put("Sis", 6);
    freq.put("Siv", 6);
    freq.put("Sit", 18);
    freq.put("Sig", 5);
    freq.put("Sie", 3);
    freq.put("kho", 4);
    freq.put("Sik", 6);
    freq.put("kha", 4);
    freq.put("khe", 4);
    freq.put("Sim", 5);
    freq.put("Sil", 3);
    freq.put("xkj", 3);
    freq.put("mro", 3);
    freq.put("E", 364);
    freq.put("Ido", 4);
    freq.put("Si ", 6);
    freq.put("Ida", 5);
    freq.put("osy", 3);
    freq.put("Byt", 4);
    freq.put("ost", 75);
    freq.put("osv", 9);
    freq.put("osi", 29);
    freq.put("osh", 7);
    freq.put("osj", 9);
    freq.put("osl", 10);
    freq.put("oso", 5);
    freq.put("osa", 11);
    freq.put("ose", 57);
    freq.put("vet", 164);
    freq.put("ver", 546);
    freq.put("ves", 52);
    freq.put("VA ", 3);
    freq.put("vez", 3);
    freq.put("vey", 3);
    freq.put("veg", 29);
    freq.put("ved", 71);
    freq.put("Ta ", 8);
    freq.put("ven", 168);
    freq.put("vel", 317);
    freq.put("vem", 42);
    freq.put("vek", 17);
    freq.put("vei", 68);
    freq.put("Må", 30);
    freq.put("lre", 3);
    freq.put("os ", 47);
    freq.put("Mø", 10);
    freq.put("Tat", 3);
    freq.put("Tar", 10);
    freq.put("ve ", 139);
    freq.put("Tal", 4);
    freq.put("Tan", 3);
    freq.put("Tak", 51);
    freq.put("M ", 28);
    freq.put("yd ", 23);
    freq.put("Me", 181);
    freq.put("Ma", 105);
    freq.put("Mc", 3);
    freq.put("Mm", 3);
    freq.put("ydd", 15);
    freq.put("yde", 28);
    freq.put("Mi", 60);
    freq.put("yda", 4);
    freq.put("Mu", 9);
    freq.put("Mv", 8);
    freq.put("uff", 21);
    freq.put("My", 11);
    freq.put("Bom", 3);
    freq.put("ipe", 20);
    freq.put("iph", 3);
    freq.put("ipi", 3);
    freq.put("ipl", 3);
    freq.put("ips", 18);
    freq.put("ipp", 55);
    freq.put("Lig", 5);
    freq.put("ipt", 4);
    freq.put("Bod", 3);
    freq.put("øvs", 4);
    freq.put("øvr", 5);
    freq.put("øvi", 6);
    freq.put("øvn", 7);
    freq.put("øve", 62);
    freq.put("øvd", 9);
    freq.put("ip ", 5);
    freq.put("sø", 133);
    freq.put("Liv", 20);
    freq.put("øv ", 6);
    freq.put("sæ", 10);
    freq.put("så", 569);
    freq.put("Out", 4);
    freq.put("ære", 193);
    freq.put("æri", 6);
    freq.put("ærh", 3);
    freq.put("ærn", 11);
    freq.put("ærm", 10);
    freq.put("ærl", 11);
    freq.put("ærs", 7);
    freq.put("ærr", 3);
    freq.put("ært", 82);
    freq.put("s ", 1570);
    freq.put("bøl", 3);
    freq.put("sy", 173);
    freq.put("ær ", 37);
    freq.put("ss", 591);
    freq.put("sr", 30);
    freq.put("sp", 413);
    freq.put("sv", 167);
    freq.put("su", 179);
    freq.put("st", 2171);
    freq.put("sk", 1552);
    freq.put("sj", 319);
    freq.put("si", 717);
    freq.put("sh", 92);
    freq.put("so", 930);
    freq.put("sn", 172);
    freq.put("sm", 140);
    freq.put("sl", 327);
    freq.put("sc", 41);
    freq.put("sb", 48);
    freq.put("sa", 496);
    freq.put("sg", 26);
    freq.put("sf", 43);
    freq.put("se", 1890);
    freq.put("sd", 73);
    freq.put("tty", 9);
    freq.put("tts", 28);
    freq.put("ttr", 11);
    freq.put("dyk", 4);
    freq.put("ttv", 4);
    freq.put("ttu", 8);
    freq.put("ttt", 4);
    freq.put("ttk", 5);
    freq.put("tti", 48);
    freq.put("tth", 7);
    freq.put("tto", 36);
    freq.put("ttl", 8);
    freq.put("ttb", 7);
    freq.put("tta", 69);
    freq.put("ttf", 3);
    freq.put("Råd", 3);
    freq.put("blø", 3);
    freq.put("jin", 4);
    freq.put("dje", 4);
    freq.put("jip", 5);
    freq.put("blå", 17);
    freq.put("tt ", 960);
    freq.put("FN ", 3);
    freq.put("Men", 112);
    freq.put("kø ", 6);
    freq.put("Jos", 7);
    freq.put("Joa", 4);
    freq.put("blo", 69);
    freq.put("bli", 322);
    freq.put("Joh", 10);
    freq.put("bla", 43);
    freq.put("Jon", 11);
    freq.put("kød", 6);
    freq.put("Jo ", 9);
    freq.put("bl ", 3);
    freq.put("onk", 21);
    freq.put("oni", 21);
    freq.put("onn", 10);
    freq.put("ono", 20);
    freq.put("onl", 10);
    freq.put("onb", 3);
    freq.put("ona", 25);
    freq.put("onf", 20);
    freq.put("ong", 54);
    freq.put("ond", 59);
    freq.put("one", 150);
    freq.put("ony", 7);
    freq.put("ons", 126);
    freq.put("onp", 3);
    freq.put("onv", 4);
    freq.put("ont", 63);
    freq.put("ovn", 16);
    freq.put("ukt", 48);
    freq.put("uks", 26);
    freq.put("uko", 6);
    freq.put("Hmm", 7);
    freq.put("ukl", 5);
    freq.put("ukk", 29);
    freq.put("ukj", 3);
    freq.put("uke", 100);
    freq.put("ukb", 3);
    freq.put("uka", 18);
    freq.put("on ", 166);
    freq.put("rza", 3);
    freq.put("Hm ", 7);
    freq.put("vfe", 3);
    freq.put("uk ", 11);
    freq.put("sak", 33);
    freq.put("san", 81);
    freq.put("sam", 132);
    freq.put("sal", 19);
    freq.put("sab", 4);
    freq.put("sag", 16);
    freq.put("sad", 5);
    freq.put("sas", 6);
    freq.put("sar", 18);
    freq.put("sav", 14);
    freq.put("sau", 5);
    freq.put("sat", 70);
    freq.put("ax ", 8);
    freq.put("sa ", 84);
    freq.put("Sku", 16);
    freq.put("Ull", 4);
    freq.put("Skr", 15);
    freq.put("Sky", 6);
    freq.put("Ske", 4);
    freq.put("øø", 5);
    freq.put("Ska", 61);
    freq.put("Sko", 10);
    freq.put("Ski", 5);
    freq.put("Skj", 15);
    freq.put("økk", 14);
    freq.put("økn", 3);
    freq.put("øko", 13);
    freq.put("øke", 32);
    freq.put("økt", 15);
    freq.put(" bå", 27);
    freq.put(" bæ", 5);
    freq.put("kjæ", 26);
    freq.put("øk ", 25);
    freq.put("kjø", 173);
    freq.put(" bø", 35);
    freq.put("øk", 109);
    freq.put("øh", 8);
    freq.put("øi", 3);
    freq.put("øn", 140);
    freq.put("øl", 169);
    freq.put("øm", 51);
    freq.put("øb", 7);
    freq.put("øf", 16);
    freq.put("øg", 11);
    freq.put("ød", 90);
    freq.put("øe", 6);
    freq.put("Skå", 3);
    freq.put("øy", 182);
    freq.put("NE ", 3);
    freq.put("ør", 762);
    freq.put("øs", 102);
    freq.put("øp", 112);
    freq.put("øv", 102);
    freq.put("øt", 93);
    freq.put("cis", 4);
    freq.put("VG ", 17);
    freq.put("vka", 3);
    freq.put("jøp", 74);
    freq.put("ø ", 38);
    freq.put("jøt", 11);
    freq.put(" be", 338);
    freq.put("kja", 4);
    freq.put(" ba", 311);
    freq.put("kje", 301);
    freq.put(" bl", 455);
    freq.put(" bo", 116);
    freq.put("kji", 3);
    freq.put(" bi", 127);
    freq.put("kjo", 19);
    freq.put(" bu", 97);
    freq.put("s", 12919);
    freq.put("kju", 3);
    freq.put(" by", 54);
    freq.put("ivå", 5);
    freq.put("rå", 76);
    freq.put("jøk", 3);
    freq.put("fin", 153);
    freq.put("ré", 8);
    freq.put("ive", 145);
    freq.put("iva", 30);
    freq.put("ivi", 28);
    freq.put("ivt", 27);
    freq.put("ivs", 7);
    freq.put("lyk", 33);
    freq.put("uic", 3);
    freq.put("iv ", 66);
    freq.put("I", 294);
    freq.put("ét ", 4);
    freq.put("Mar", 23);
    freq.put("gde", 15);
    freq.put("gdi", 3);
    freq.put("gdo", 11);
    freq.put("Mac", 4);
    freq.put("SV ", 10);
    freq.put("gd ", 8);
    freq.put("Mak", 4);
    freq.put("Mam", 4);
    freq.put("Man", 34);
    freq.put("Mye", 5);
    freq.put("tvi", 37);
    freq.put("tve", 13);
    freq.put("tva", 3);
    freq.put("ac ", 4);
    freq.put("dds", 6);
    freq.put("ddi", 8);
    freq.put("dda", 23);
    freq.put("dde", 202);
    freq.put("ez ", 9);
    freq.put("tv ", 22);
    freq.put("aca", 3);
    freq.put("ace", 31);
    freq.put("ack", 22);
    freq.put("ach", 8);
    freq.put("aco", 5);
    freq.put("dd ", 51);
    freq.put("Ni", 12);
    freq.put("Nj", 5);
    freq.put("No", 159);
    freq.put("uil", 4);
    freq.put("Na", 26);
    freq.put("Ne", 91);
    freq.put("Ny", 61);
    freq.put("Nr", 3);
    freq.put("Nu", 5);
    freq.put("het", 153);
    freq.put("hev", 5);
    freq.put("her", 133);
    freq.put("ei ", 187);
    freq.put("hee", 4);
    freq.put("hef", 4);
    freq.put("hea", 5);
    freq.put("hel", 270);
    freq.put("hem", 7);
    freq.put("hen", 55);
    freq.put("heh", 32);
    freq.put("hei", 47);
    freq.put("hek", 3);
    freq.put("N ", 38);
    freq.put("he ", 70);
    freq.put("aa", 54);
    freq.put("ac", 81);
    freq.put("oho", 11);
    freq.put("ae", 73);
    freq.put("ad", 412);
    freq.put("ag", 784);
    freq.put("af", 117);
    freq.put("ai", 53);
    freq.put("ah", 126);
    freq.put("Hol", 12);
    freq.put("aj", 12);
    freq.put("am", 579);
    freq.put("Hok", 4);
    freq.put("ao", 11);
    freq.put("an", 2399);
    freq.put("Hov", 5);
    freq.put("ap", 219);
    freq.put("as", 590);
    freq.put("ar", 2305);
    freq.put("au", 79);
    freq.put("at", 1241);
    freq.put("aw", 13);
    freq.put("av", 755);
    freq.put("ay", 44);
    freq.put("ax", 13);
    freq.put("az", 10);
    freq.put("bjø", 7);
    freq.put("a ", 2290);
    freq.put("oh ", 5);
    freq.put("at ", 555);
    freq.put("smu", 9);
    freq.put("Fir", 4);
    freq.put("Fis", 6);
    freq.put("sco", 18);
    freq.put("sci", 5);
    freq.put("sch", 8);
    freq.put("Fit", 3);
    freq.put("sce", 4);
    freq.put("sms", 4);
    freq.put("dss", 6);
    freq.put("mni", 11);
    freq.put("dsp", 12);
    freq.put("Fik", 17);
    freq.put("Fin", 25);
    freq.put("mne", 7);
    freq.put("scr", 3);
    freq.put("smo", 7);
    freq.put("tz", 3);
    freq.put("dso", 7);
    freq.put("tv", 82);
    freq.put("tw", 104);
    freq.put("tt", 2041);
    freq.put("tu", 248);
    freq.put("tr", 726);
    freq.put("dsl", 8);
    freq.put("tp", 20);
    freq.put("tn", 39);
    freq.put("to", 508);
    freq.put("tl", 125);
    freq.put("dsm", 4);
    freq.put("tj", 52);
    freq.put("tk", 33);
    freq.put("th", 69);
    freq.put("ti", 1912);
    freq.put("tf", 72);
    freq.put("tg", 19);
    freq.put("td", 17);
    freq.put("te", 3439);
    freq.put("tb", 52);
    freq.put("tc", 24);
    freq.put("dsk", 15);
    freq.put("smi", 17);
    freq.put("sc ", 3);
    freq.put("dsf", 4);
    freq.put("rm", 144);
    freq.put("mn ", 5);
    freq.put("dsd", 5);
    freq.put("Må ", 24);
    freq.put("dse", 9);
    freq.put("dsb", 5);
    freq.put("sma", 28);
    freq.put("dsa", 16);
    freq.put("t ", 6725);
    freq.put("Smi", 3);
    freq.put("Sma", 9);
    freq.put("ømm", 27);
    freq.put("tø", 119);
    freq.put("tæ", 3);
    freq.put("tå", 107);
    freq.put("ømp", 4);
    freq.put("øm ", 7);
    freq.put("vic", 10);
    freq.put("via", 34);
    freq.put("vig", 8);
    freq.put("vid", 42);
    freq.put("vik", 61);
    freq.put("vin", 116);
    freq.put("vil", 202);
    freq.put("vim", 3);
    freq.put("vir", 49);
    freq.put("vis", 179);
    freq.put("vip", 4);
    freq.put("vit", 65);
    freq.put("kl ", 27);
    freq.put("üne", 4);
    freq.put("etc", 9);
    freq.put(" d ", 21);
    freq.put("vi ", 184);
    freq.put(" do", 37);
    freq.put("kle", 49);
    freq.put(" dm", 3);
    freq.put("kla", 133);
    freq.put(" di", 151);
    freq.put(" de", 2123);
    freq.put("klo", 37);
    freq.put(" db", 3);
    freq.put(" da", 463);
    freq.put("klu", 21);
    freq.put(" dy", 17);
    freq.put(" du", 503);
    freq.put(" dr", 133);
    freq.put("atr", 9);
    freq.put("øse", 13);
    freq.put("øsk", 3);
    freq.put("klæ", 12);
    freq.put(" dé", 3);
    freq.put(" dæ", 5);
    freq.put(" då", 39);
    freq.put(" dø", 49);
    freq.put("klø", 3);
    freq.put("itn", 3);
    freq.put("itl", 5);
    freq.put("tål", 3);
    freq.put("itk", 3);
    freq.put("iti", 110);
    freq.put("ite", 184);
    freq.put("tåe", 9);
    freq.put("ita", 35);
    freq.put("ity", 15);
    freq.put("itv", 3);
    freq.put("tår", 44);
    freq.put("itu", 12);
    freq.put("itr", 11);
    freq.put("its", 13);
    freq.put("tå ", 26);
    freq.put("it ", 97);
    freq.put("ått", 109);
    freq.put(" A ", 14);
    freq.put("gfr", 3);
    freq.put("evd", 6);
    freq.put("gfa", 3);
    freq.put("fts", 10);
    freq.put("ævl", 24);
    freq.put("fta", 5);
    freq.put("fte", 56);
    freq.put("fti", 17);
    freq.put("fth", 3);
    freq.put("fto", 3);
    freq.put(" Aa", 3);
    freq.put(" Ab", 13);
    freq.put(" Ad", 11);
    freq.put(" Af", 18);
    freq.put(" Ag", 5);
    freq.put(" Ah", 14);
    freq.put(" Ak", 14);
    freq.put(" Al", 63);
    freq.put(" Am", 6);
    freq.put(" An", 42);
    freq.put(" Ap", 22);
    freq.put(" Ar", 40);
    freq.put(" As", 12);
    freq.put(" At", 19);
    freq.put(" Au", 5);
    freq.put(" Av", 24);
    freq.put("NG ", 3);
    freq.put("evt", 8);
    freq.put("ft ", 34);
    freq.put("w", 319);
    freq.put("Fra", 11);
    freq.put("Fre", 26);
    freq.put("Fri", 10);
    freq.put("Fro", 7);
    freq.put("KE ", 11);
    freq.put("æ ", 30);
    freq.put("Frp", 13);
    freq.put("Fry", 4);
    freq.put("jer", 152);
    freq.put("jes", 13);
    freq.put("jep", 9);
    freq.put("jev", 7);
    freq.put("aa ", 15);
    freq.put("jet", 18);
    freq.put("dfr", 3);
    freq.put("jea", 3);
    freq.put("jef", 15);
    freq.put("jeg", 889);
    freq.put("jed", 40);
    freq.put("jek", 75);
    freq.put("jen", 283);
    freq.put("jel", 91);
    freq.put("jem", 96);
    freq.put("ær", 369);
    freq.put("æs", 6);
    freq.put("æt", 4);
    freq.put("æv", 32);
    freq.put("æk", 4);
    freq.put("æl", 12);
    freq.put("aaa", 21);
    freq.put("aal", 6);
    freq.put("aah", 3);
    freq.put("je ", 135);
    freq.put("aar", 3);
    freq.put("uet", 11);
    freq.put("yhe", 20);
    freq.put("dfø", 11);
    freq.put("ex ", 11);
    freq.put("tp ", 4);
    freq.put("Bla", 11);
    freq.put("Øst", 15);
    freq.put("bh ", 3);
    freq.put("M", 539);
    freq.put("ææ", 16);
    freq.put("åvi", 8);
    freq.put("tpa", 5);
    freq.put("åva", 4);
    freq.put("exk", 3);
    freq.put("tpr", 3);
    freq.put("exy", 3);
    freq.put("Hah", 41);
    freq.put("Hal", 12);
    freq.put("Ham", 6);
    freq.put("Han", 31);
    freq.put("ugl", 6);
    freq.put("uga", 5);
    freq.put("Had", 15);
    freq.put("uge", 14);
    freq.put("Hag", 9);
    freq.put("ugs", 3);
    freq.put("Har", 126);
    freq.put("Hat", 7);
    freq.put("Hau", 11);
    freq.put("ugu", 9);
    freq.put("rf ", 3);
    freq.put("Ha ", 4);
    freq.put("ug ", 8);
    freq.put("Ord", 6);
    freq.put("rfr", 4);
    freq.put("rfy", 5);
    freq.put("rfa", 18);
    freq.put("cra", 3);
    freq.put("rfe", 22);
    freq.put("cre", 4);
    freq.put("rfo", 56);
    freq.put("Fot", 4);
    freq.put("sev", 7);
    freq.put("seu", 4);
    freq.put("set", 186);
    freq.put("ses", 59);
    freq.put("ser", 426);
    freq.put("For", 81);
    freq.put("sep", 26);
    freq.put("Fox", 3);
    freq.put("sey", 3);
    freq.put("sex", 10);
    freq.put("seg", 154);
    freq.put("sef", 8);
    freq.put("see", 6);
    freq.put("sed", 5);
    freq.put("seb", 11);
    freq.put("sea", 6);
    freq.put("Fol", 15);
    freq.put("sen", 386);
    freq.put("sem", 16);
    freq.put("sel", 168);
    freq.put("sek", 35);
    freq.put("sei", 36);
    freq.put("seh", 3);
    freq.put("evn", 25);
    freq.put("lem", 64);
    freq.put("se ", 325);
    freq.put("rfø", 5);
    freq.put("pdr", 7);
    freq.put("pda", 15);
    freq.put("nr ", 18);
    freq.put("ml ", 3);
    freq.put("tiv", 92);
    freq.put("Job", 10);
    freq.put("nri", 7);
    freq.put("nry", 3);
    freq.put("efø", 3);
    freq.put("Ola", 6);
    freq.put("Old", 4);
    freq.put("Ole", 6);
    freq.put("mle", 35);
    freq.put(" fø", 236);
    freq.put("mli", 11);
    freq.put(" få", 241);
    freq.put(" fæ", 3);
    freq.put("ami", 10);
    freq.put("vol", 26);
    freq.put("vom", 4);
    freq.put("von", 11);
    freq.put("vok", 9);
    freq.put("vor", 156);
    freq.put("amo", 6);
    freq.put(" f ", 12);
    freq.put("amb", 22);
    freq.put("ame", 68);
    freq.put("nrø", 3);
    freq.put("amf", 18);
    freq.put("kno", 5);
    freq.put(" fr", 392);
    freq.put(" fu", 83);
    freq.put("Sog", 3);
    freq.put("kni", 39);
    freq.put(" fy", 28);
    freq.put("kne", 24);
    freq.put("Som", 15);
    freq.put("Sol", 23);
    freq.put("Son", 6);
    freq.put(" fa", 255);
    freq.put(" fb", 6);
    freq.put(" fe", 160);
    freq.put("kny", 6);
    freq.put(" fi", 224);
    freq.put(" fj", 24);
    freq.put(" fm", 3);
    freq.put(" fl", 152);
    freq.put(" fo", 1079);
    freq.put("O ", 23);
    freq.put("ams", 11);
    freq.put("On", 5);
    freq.put("Om", 19);
    freq.put("Ol", 17);
    freq.put("Ok", 13);
    freq.put("Oi", 3);
    freq.put("Oh", 4);
    freq.put("Og", 74);
    freq.put("Of", 4);
    freq.put("Od", 5);
    freq.put("Ob", 3);
    freq.put("Ov", 14);
    freq.put("Ou", 4);
    freq.put("Os", 61);
    freq.put("Or", 15);
    freq.put("Op", 29);
    freq.put("d", 9165);
    freq.put("b ", 78);
    freq.put(" Du", 71);
    freq.put("man", 269);
    freq.put("bd", 4);
    freq.put("be", 605);
    freq.put("ba", 511);
    freq.put("bb", 134);
    freq.put("bl", 561);
    freq.put("bo", 196);
    freq.put("bh", 4);
    freq.put("bi", 236);
    freq.put("bj", 13);
    freq.put("bk", 4);
    freq.put("bu", 155);
    freq.put("bp", 3);
    freq.put("br", 320);
    freq.put("bs", 36);
    freq.put("by", 87);
    freq.put("Fu", 14);
    freq.put("bør", 30);
    freq.put("bøt", 4);
    freq.put("røt", 6);
    freq.put("høl", 4);
    freq.put("Osl", 56);
    freq.put("Fy", 11);
    freq.put(" C ", 6);
    freq.put("u ", 600);
    freq.put(" Ch", 31);
    freq.put(" Ci", 9);
    freq.put("BK ", 4);
    freq.put(" Co", 18);
    freq.put(" Cl", 6);
    freq.put(" Ca", 48);
    freq.put(" Ce", 9);
    freq.put(" Cr", 6);
    freq.put(" Cu", 3);
    freq.put("cia", 4);
    freq.put("uy", 4);
    freq.put("ux", 4);
    freq.put("uu", 14);
    freq.put("ut", 639);
    freq.put("uv", 18);
    freq.put("cin", 7);
    freq.put("us", 423);
    freq.put("ur", 371);
    freq.put("um", 133);
    freq.put("ul", 386);
    freq.put("uo", 3);
    freq.put("un", 620);
    freq.put("ui", 26);
    freq.put("uh", 9);
    freq.put("uk", 256);
    freq.put("uj", 4);
    freq.put("ue", 72);
    freq.put("ud", 120);
    freq.put("ug", 57);
    freq.put("uf", 53);
    freq.put("ua", 53);
    freq.put("uc", 20);
    freq.put("ub", 44);
    freq.put("ag ", 355);
    freq.put("ago", 14);
    freq.put("agn", 10);
    freq.put("agl", 9);
    freq.put("agi", 4);
    freq.put("agg", 15);
    freq.put("age", 247);
    freq.put("agd", 6);
    freq.put("agb", 7);
    freq.put("aga", 18);
    freq.put("agu", 4);
    freq.put("agt", 35);
    freq.put("ags", 33);
    freq.put("agr", 7);
    freq.put("odø", 7);
    freq.put("o ", 596);
    freq.put("pul", 14);
    freq.put("ev ", 25);
    freq.put("tr ", 6);
    freq.put("åt ", 11);
    freq.put("tri", 75);
    freq.put("evi", 31);
    freq.put("evl", 4);
    freq.put("tro", 162);
    freq.put("evo", 6);
    freq.put("tra", 132);
    freq.put("eva", 20);
    freq.put("tre", 215);
    freq.put("eve", 111);
    freq.put("try", 42);
    freq.put("åta", 3);
    freq.put("åte", 35);
    freq.put("tru", 41);
    freq.put("åtm", 3);
    freq.put("le ", 642);
    freq.put("uel", 20);
    freq.put("uen", 7);
    freq.put("odt", 80);
    freq.put("odu", 14);
    freq.put("odi", 8);
    freq.put("Blo", 4);
    freq.put("odk", 4);
    freq.put("Bli", 42);
    freq.put("Ble", 12);
    freq.put("oda", 10);
    freq.put("odd", 32);
    freq.put("ode", 93);
    freq.put("ues", 5);
    freq.put("uer", 15);
    freq.put("rd ", 78);
    freq.put("lea", 9);
    freq.put("leb", 9);
    freq.put("led", 95);
    freq.put("lee", 8);
    freq.put("lef", 27);
    freq.put("leg", 110);
    freq.put("leh", 5);
    freq.put("lei", 48);
    freq.put("lej", 5);
    freq.put("lek", 58);
    freq.put("lel", 25);
    freq.put("ue ", 11);
    freq.put("len", 267);
    freq.put("lep", 17);
    freq.put("ler", 543);
    freq.put("les", 150);
    freq.put("let", 145);
    freq.put("lev", 53);
    freq.put("od ", 98);
    freq.put("ley", 3);
    freq.put("rdt", 22);
    freq.put("rdp", 3);
    freq.put("rds", 11);
    freq.put("rdr", 19);
    freq.put("trå", 13);
    freq.put("evå", 3);
    freq.put("evæ", 3);
    freq.put("rde", 155);
    freq.put("trø", 34);
    freq.put("rdf", 12);
    freq.put("rda", 91);
    freq.put("rdm", 8);
    freq.put("rdl", 8);
    freq.put("rdn", 11);
    freq.put("rdi", 69);
    freq.put("sgr", 9);
    freq.put("sgj", 5);
    freq.put("sga", 4);
    freq.put("pfo", 5);
    freq.put("npo", 3);
    freq.put("Q", 9);
    freq.put("pfø", 3);
    freq.put("npr", 6);
    freq.put("bån", 6);
    freq.put("æ", 477);
    freq.put("båd", 18);
    freq.put("bås", 3);
    freq.put("båt", 7);
    freq.put("vmo", 3);
    freq.put(" h ", 3);
    freq.put("Kjæ", 11);
    freq.put("Kjø", 9);
    freq.put(" hy", 30);
    freq.put("San", 16);
    freq.put("Sam", 27);
    freq.put("Sal", 7);
    freq.put(" hv", 308);
    freq.put(" hu", 107);
    freq.put(" ht", 9);
    freq.put(" hj", 108);
    freq.put(" hi", 43);
    freq.put(" ho", 110);
    freq.put(" hm", 3);
    freq.put("Sar", 5);
    freq.put(" ha", 1222);
    freq.put("Sav", 3);
    freq.put(" he", 503);
    freq.put("Sat", 11);
    freq.put("pør", 32);
    freq.put("pøk", 4);
    freq.put("pøn", 3);
    freq.put("Kje", 22);
    freq.put(" hø", 146);
    freq.put(" hæ", 3);
    freq.put(" hå", 50);
    freq.put("OM ", 3);
    freq.put("ihv", 6);
    freq.put("IT ", 6);
    freq.put("ihi", 4);
    freq.put("iha", 4);
    freq.put("ihe", 6);
    freq.put("høs", 19);
    freq.put("hør", 87);
    freq.put("igå", 9);
    freq.put("DG ", 3);
    freq.put("kål", 4);
    freq.put("kås", 3);
    freq.put("kår", 4);
    freq.put("mna", 3);
    freq.put(" E ", 20);
    freq.put("ck ", 27);
    freq.put(" El", 45);
    freq.put(" Em", 3);
    freq.put(" En", 82);
    freq.put(" Eh", 3);
    freq.put(" Ei", 14);
    freq.put(" Ek", 8);
    freq.put(" Eg", 16);
    freq.put(" Ex", 3);
    freq.put(" Et", 30);
    freq.put(" Eu", 5);
    freq.put(" Ev", 8);
    freq.put(" Ep", 5);
    freq.put(" Er", 96);
    freq.put(" Es", 3);
    freq.put("cke", 19);
    freq.put("cka", 4);
    freq.put("cki", 5);
    freq.put("rgå", 3);
    freq.put("dbo", 4);
    freq.put("dba", 6);
    freq.put("dbe", 3);
    freq.put("På", 58);
    freq.put("dbr", 3);
    freq.put("jav", 3);
    freq.put("jar", 7);
    freq.put("jas", 3);
    freq.put("jap", 6);
    freq.put("jan", 16);
    freq.put("jal", 6);
    freq.put("jam", 5);
    freq.put("jak", 23);
    freq.put("jag", 7);
    freq.put("db ", 3);
    freq.put("Fv ", 6);
    freq.put("aet", 3);
    freq.put("gba", 4);
    freq.put("h", 3683);
    freq.put("gbl", 6);
    freq.put("tlø", 3);
    freq.put("gbr", 3);
    freq.put("ael", 14);
    freq.put("ja ", 100);
    freq.put("aen", 54);
    freq.put("Pr", 27);
    freq.put("Ps", 3);
    freq.put("Pu", 9);
    freq.put("C", 147);
    freq.put("Pa", 50);
    freq.put("Pe", 34);
    freq.put("Ph", 11);
    freq.put("Pi", 14);
    freq.put("Po", 33);
    freq.put("Pl", 14);
    freq.put("et ", 2564);
    freq.put("år ", 615);
    freq.put("lg", 243);
    freq.put("ld", 557);
    freq.put("P ", 43);
    freq.put("le", 2294);
    freq.put("årt", 9);
    freq.put("ets", 69);
    freq.put("etw", 9);
    freq.put("ett", 681);
    freq.put("års", 19);
    freq.put("la", 952);
    freq.put("ård", 6);
    freq.put("åre", 48);
    freq.put("tla", 20);
    freq.put("eta", 44);
    freq.put("tle", 19);
    freq.put("lo", 456);
    freq.put("årl", 40);
    freq.put("etk", 3);
    freq.put("tli", 77);
    freq.put("eti", 19);
    freq.put("etn", 6);
    freq.put("åri", 19);
    freq.put("ck", 69);
    freq.put("ci", 21);
    freq.put("lm", 54);
    freq.put("co", 80);
    freq.put("vå", 51);
    freq.put("cm", 3);
    freq.put("cl", 4);
    freq.put("cc", 5);
    freq.put("lj", 30);
    freq.put("ca", 60);
    freq.put("ce", 73);
    freq.put("cy", 7);
    freq.put("vø", 9);
    freq.put("cr", 12);
    freq.put("Hen", 7);
    freq.put("li", 1953);
    freq.put("uck", 17);
    freq.put("Hei", 22);
    freq.put("cu", 10);
    freq.put("ct", 7);
    freq.put("åse", 17);
    freq.put("Gea", 3);
    freq.put("Gei", 3);
    freq.put("Geo", 3);
    freq.put("Tv ", 4);
    freq.put("lgj", 9);
    freq.put("lgk", 11);
    freq.put("lgi", 6);
    freq.put("lgo", 6);
    freq.put("lgl", 5);
    freq.put("c ", 35);
    freq.put("lgf", 6);
    freq.put("lge", 101);
    freq.put("lgs", 7);
    freq.put("lgt", 21);
    freq.put("lgu", 3);
    freq.put("rbu", 8);
    freq.put("rbr", 5);
    freq.put("rbo", 8);
    freq.put("rbl", 4);
    freq.put("rbk", 3);
    freq.put("rbi", 11);
    freq.put("rbe", 59);
    freq.put("reå", 3);
    freq.put("rba", 7);
    freq.put("Bjø", 6);
    freq.put("va", 793);
    freq.put("vb", 5);
    freq.put("vd", 25);
    freq.put("ve", 1628);
    freq.put("vf", 20);
    freq.put("vg", 20);
    freq.put("vh", 17);
    freq.put("vi", 967);
    freq.put("vj", 12);
    freq.put("vk", 7);
    freq.put("vl", 40);
    freq.put("vm", 4);
    freq.put("vn", 97);
    freq.put("vo", 212);
    freq.put("vp", 6);
    freq.put("vr", 15);
    freq.put("vs", 42);
    freq.put("vt", 48);
    freq.put("vu", 14);
    freq.put("vv", 15);
    freq.put("of ", 6);
    freq.put("v ", 800);
    freq.put("phi", 4);
    freq.put("pho", 8);
    freq.put("Sån", 8);
    freq.put("Bje", 3);
    freq.put("ofa", 9);
    freq.put("off", 19);
    freq.put("ofe", 11);
    freq.put("ofi", 16);
    freq.put("ofo", 8);
    freq.put("oft", 10);
    freq.put("web", 9);
    freq.put("wee", 54);
    freq.put("wer", 11);
    freq.put("xe ", 4);
    freq.put("nve", 20);
    freq.put("nva", 4);
    freq.put("nvi", 14);
    freq.put(" jø", 3);
    freq.put("mhe", 4);
    freq.put(" jæ", 22);
    freq.put("vst", 6);
    freq.put("vsu", 4);
    freq.put("vsa", 6);
    freq.put("vse", 3);
    freq.put("vsl", 7);
    freq.put("vsn", 3);
    freq.put("kr ", 11);
    freq.put("lle", 796);
    freq.put("vs ", 9);
    freq.put("kry", 13);
    freq.put("Sch", 3);
    freq.put(" ju", 37);
    freq.put("kru", 20);
    freq.put(" jo", 283);
    freq.put("kri", 101);
    freq.put(" ji", 4);
    freq.put("kro", 31);
    freq.put(" je", 938);
    freq.put(" jg", 6);
    freq.put("kra", 31);
    freq.put(" ja", 113);
    freq.put("øl ", 27);
    freq.put("kre", 68);
    freq.put("yri", 7);
    freq.put("nål", 3);
    freq.put("yrk", 6);
    freq.put("någ", 4);
    freq.put("yre", 56);
    freq.put("nåt", 3);
    freq.put("når", 159);
    freq.put("Tho", 7);
    freq.put("Kla", 13);
    freq.put("Klo", 4);
    freq.put("yr ", 38);
    freq.put("nå ", 189);
    freq.put("inx", 3);
    freq.put("iny", 3);
    freq.put("int", 109);
    freq.put("inu", 27);
    freq.put("inv", 17);
    freq.put("ins", 53);
    freq.put("inn", 398);
    freq.put("ino", 8);
    freq.put("ini", 23);
    freq.put("inj", 4);
    freq.put("ink", 51);
    freq.put("ind", 51);
    freq.put("ine", 166);
    freq.put("inf", 19);
    freq.put("ing", 699);
    freq.put("ina", 60);
    freq.put("inc", 5);
    freq.put("væ", 224);
    freq.put("eo ", 7);
    freq.put("yrå", 5);
    freq.put("mæ ", 4);
    freq.put("U", 114);
    freq.put("in ", 282);
    freq.put("åme", 3);
    freq.put("eoe", 3);
    freq.put("eor", 16);
    freq.put("eop", 7);
    freq.put("sst", 44);
    freq.put("Tur", 4);
    freq.put("tså", 38);
    freq.put("AH ", 3);
    freq.put(" G ", 11);
    freq.put("pte", 37);
    freq.put(" Gu", 23);
    freq.put(" Gr", 50);
    freq.put("Tun", 6);
    freq.put(" Ge", 15);
    freq.put(" Ga", 41);
    freq.put(" Go", 47);
    freq.put(" Gl", 37);
    freq.put(" Gj", 22);
    freq.put(" Gi", 19);
    freq.put("AG ", 3);
    freq.put("glø", 4);
    freq.put("lø", 131);
    freq.put("vær", 221);
    freq.put("KK ", 4);
    freq.put("gl ", 4);
    freq.put("ptr", 7);
    freq.put("ak ", 61);
    freq.put(" Gø", 5);
    freq.put(" Gå", 9);
    freq.put("Cr", 6);
    freq.put("gli", 21);
    freq.put("glo", 5);
    freq.put("aks", 50);
    freq.put("gla", 48);
    freq.put("gle", 93);
    freq.put("aku", 5);
    freq.put("akt", 144);
    freq.put("akk", 255);
    freq.put("aki", 8);
    freq.put("akh", 6);
    freq.put("ako", 10);
    freq.put("akn", 5);
    freq.put("akl", 7);
    freq.put("aka", 20);
    freq.put("akg", 6);
    freq.put("ake", 107);
    freq.put("Jer", 5);
    freq.put("Jes", 6);
    freq.put("Jep", 8);
    freq.put("bry", 24);
    freq.put("bru", 103);
    freq.put("bro", 8);
    freq.put("Jeg", 277);
    freq.put("bri", 19);
    freq.put("Jee", 4);
    freq.put("bre", 27);
    freq.put("Jen", 14);
    freq.put("bra", 125);
    freq.put("er ", 5222);
    freq.put("Nak", 3);
    freq.put("åp ", 3);
    freq.put("nka", 8);
    freq.put("nke", 147);
    freq.put("iu", 8);
    freq.put("nkj", 3);
    freq.put("nkl", 13);
    freq.put("nkr", 5);
    freq.put("nks", 4);
    freq.put("nkt", 42);
    freq.put("nku", 10);
    freq.put("ert", 314);
    freq.put("ii", 31);
    freq.put("erv", 57);
    freq.put("erp", 42);
    freq.put("err", 95);
    freq.put("ers", 192);
    freq.put("ery", 6);
    freq.put("åpn", 22);
    freq.put("ere", 582);
    freq.put("erf", 61);
    freq.put("erg", 61);
    freq.put("era", 72);
    freq.put("erb", 20);
    freq.put("erc", 3);
    freq.put("erl", 49);
    freq.put("erm", 31);
    freq.put("ern", 137);
    freq.put("ero", 16);
    freq.put("erh", 35);
    freq.put("eri", 172);
    freq.put("erj", 3);
    freq.put("erk", 77);
    freq.put("io", 110);
    freq.put("brø", 12);
    freq.put("uas", 6);
    freq.put("uar", 4);
    freq.put("la ", 80);
    freq.put("Abs", 7);
    freq.put("ual", 5);
    freq.put("uan", 15);
    freq.put("ki ", 10);
    freq.put("fas", 17);
    freq.put("lal", 4);
    freq.put("lam", 29);
    freq.put("lan", 231);
    freq.put("lak", 28);
    freq.put("lad", 81);
    freq.put("lag", 163);
    freq.put("lab", 5);
    freq.put("lay", 5);
    freq.put("lat", 55);
    freq.put("ua ", 16);
    freq.put("lav", 27);
    freq.put("lap", 19);
    freq.put("lar", 99);
    freq.put("las", 102);
    freq.put("erø", 7);
    freq.put("mpu", 3);
    freq.put("zel", 3);
    freq.put("zer", 5);
    freq.put("l", 12126);
    freq.put("tøm", 5);
    freq.put("tøk", 3);
    freq.put("tøf", 7);
    freq.put("øen", 5);
    freq.put("tøy", 17);
    freq.put("tøv", 6);
    freq.put("tøt", 23);
    freq.put("tør", 48);
    freq.put(" Åp", 3);
    freq.put("kip", 5);
    freq.put("nts", 10);
    freq.put("ntr", 55);
    freq.put("ntu", 9);
    freq.put("nti", 32);
    freq.put("nth", 5);
    freq.put("ntl", 68);
    freq.put("nto", 18);
    freq.put("ntn", 3);
    freq.put("nta", 104);
    freq.put("kit", 12);
    freq.put("nte", 265);
    freq.put("ntf", 4);
    freq.put("mve", 4);
    freq.put("mvi", 4);
    freq.put("VM ", 4);
    freq.put("kia", 8);
    freq.put("Nrk", 3);
    freq.put("Se ", 20);
    freq.put("kt ", 193);
    freq.put(" le", 268);
    freq.put("B", 432);
    freq.put(" la", 245);
    freq.put(" lo", 83);
    freq.put(" li", 487);
    freq.put(" lu", 53);
    freq.put(" ly", 83);
    freq.put("Set", 6);
    freq.put("Ser", 51);
    freq.put("ktu", 9);
    freq.put("ktr", 12);
    freq.put("kts", 6);
    freq.put("ktl", 3);
    freq.put("ktn", 3);
    freq.put("kto", 18);
    freq.put("kti", 138);
    freq.put("Sen", 17);
    freq.put("Sem", 5);
    freq.put("Sel", 26);
    freq.put("kta", 20);
    freq.put("Q ", 4);
    freq.put("Vo", 10);
    freq.put("ter", 1012);
    freq.put("ypp", 4);
    freq.put("ypt", 4);
    freq.put("ypa", 6);
    freq.put("nbe", 18);
    freq.put("ype", 16);
    freq.put("ypi", 8);
    freq.put(" læ", 20);
    freq.put(" lå", 28);
    freq.put("Qu", 3);
    freq.put(" lø", 68);
    freq.put("ktø", 13);
    freq.put("yp ", 5);
    freq.put("d ", 1679);
    freq.put("em ", 172);
    freq.put("én ", 6);
    freq.put("åk ", 3);
    freq.put("hro", 3);
    freq.put("dn", 42);
    freq.put("do", 109);
    freq.put("dl", 86);
    freq.put("dm", 15);
    freq.put("dj", 5);
    freq.put("dk", 11);
    freq.put("dh", 27);
    freq.put("di", 524);
    freq.put("df", 25);
    freq.put("dg", 18);
    freq.put("dd", 296);
    freq.put("de", 3718);
    freq.put("db", 21);
    freq.put("dc", 5);
    freq.put("da", 941);
    freq.put("dy", 29);
    freq.put("dv", 25);
    freq.put("dw", 6);
    freq.put("dt", 227);
    freq.put("du", 536);
    freq.put("dr", 503);
    freq.put("ds", 156);
    freq.put("dp", 8);
    freq.put("eme", 50);
    freq.put("emd", 4);
    freq.put("åkl", 6);
    freq.put("ema", 25);
    freq.put("CK ", 3);
    freq.put("emb", 18);
    freq.put("emm", 102);
    freq.put("eml", 7);
    freq.put("åke", 17);
    freq.put("emn", 13);
    freq.put("emi", 19);
    freq.put("emu", 6);
    freq.put("emt", 39);
    freq.put("emp", 24);
    freq.put("ems", 16);
    freq.put("hr ", 3);
    freq.put("w ", 39);
    freq.put(" I ", 88);
    freq.put("il ", 1001);
    freq.put("xD ", 4);
    freq.put("co ", 8);
    freq.put("we", 86);
    freq.put("dè", 3);
    freq.put("dé", 5);
    freq.put("dæ", 6);
    freq.put("wn", 6);
    freq.put(" Ir", 8);
    freq.put(" Is", 12);
    freq.put(" Iv", 5);
    freq.put("wh", 9);
    freq.put("ww", 22);
    freq.put(" Ik", 64);
    freq.put("ws", 8);
    freq.put(" Im", 5);
    freq.put(" In", 49);
    freq.put(" Ib", 3);
    freq.put(" Id", 11);
    freq.put(" Ig", 5);
    freq.put("ilf", 12);
    freq.put("ilg", 9);
    freq.put("ild", 75);
    freq.put("ile", 65);
    freq.put("ilb", 53);
    freq.put("ila", 9);
    freq.put("ilo", 5);
    freq.put("ill", 329);
    freq.put("ilm", 28);
    freq.put("ilj", 16);
    freq.put("ilk", 49);
    freq.put("ilh", 5);
    freq.put("ili", 43);
    freq.put("ilv", 4);
    freq.put("ilt", 42);
    freq.put("ils", 35);
    freq.put("com", 16);
    freq.put("emø", 4);
    freq.put("coo", 3);
    freq.put("con", 15);
    freq.put("gn ", 28);
    freq.put("ai ", 7);
    freq.put("air", 5);
    freq.put("ail", 16);
    freq.put("ET ", 13);
    freq.put("ain", 7);
    freq.put("gne", 70);
    freq.put("aid", 4);
    freq.put("gni", 14);
    freq.put("gno", 4);
    freq.put("ni ", 22);
    freq.put("Ikv", 5);
    freq.put("Ikk", 60);
    freq.put("ep ", 17);
    freq.put("th ", 8);
    freq.put("nik", 25);
    freq.put("nin", 187);
    freq.put("nio", 3);
    freq.put("nil", 12);
    freq.put("nim", 8);
    freq.put("nic", 6);
    freq.put("nia", 17);
    freq.put("nif", 3);
    freq.put("nig", 37);
    freq.put("nie", 5);
    freq.put("Y", 32);
    freq.put("nis", 33);
    freq.put("nip", 4);
    freq.put("niv", 9);
    freq.put("nit", 30);
    freq.put("thu", 4);
    freq.put("epu", 9);
    freq.put("ths", 3);
    freq.put("eps", 12);
    freq.put("epp", 43);
    freq.put("tho", 5);
    freq.put("epo", 7);
    freq.put("epl", 17);
    freq.put("thi", 5);
    freq.put("epi", 15);
    freq.put("the", 27);
    freq.put("epe", 22);
    freq.put("tha", 13);
    freq.put("epa", 9);
    freq.put("rn ", 47);
    freq.put("Gat", 5);
    freq.put("Gar", 7);
    freq.put("Gam", 11);
    freq.put("Gal", 7);
    freq.put("Gah", 3);
    freq.put("Gad", 3);
    freq.put("Tri", 9);
    freq.put("rni", 10);
    freq.put("rno", 6);
    freq.put("rnm", 3);
    freq.put("Tra", 5);
    freq.put("rna", 40);
    freq.put("Tre", 20);
    freq.put("rne", 139);
    freq.put("plø", 8);
    freq.put("plæ", 3);
    freq.put("rny", 3);
    freq.put("rns", 4);
    freq.put("Tru", 4);
    freq.put("rnu", 8);
    freq.put("rke", 135);
    freq.put("gør", 5);
    freq.put("gøy", 15);
    freq.put("Led", 6);
    freq.put("yke", 23);
    freq.put("ykd", 3);
    freq.put("ykk", 76);
    freq.put("ykj", 3);
    freq.put("yko", 3);
    freq.put("ob ", 3);
    freq.put("ykl", 8);
    freq.put("Ler", 3);
    freq.put("Les", 12);
    freq.put("Lev", 4);
    freq.put("ykt", 58);
    freq.put("plu", 21);
    freq.put("ply", 10);
    freq.put("Trø", 3);
    freq.put("ple", 54);
    freq.put("rnø", 16);
    freq.put("pla", 96);
    freq.put("plo", 7);
    freq.put("pli", 9);
    freq.put("obl", 24);
    freq.put("yk ", 12);
    freq.put("obj", 5);
    freq.put("obi", 26);
    freq.put("obe", 19);
    freq.put("obb", 119);
    freq.put("oba", 5);
    freq.put("obr", 3);
    freq.put("obs", 11);
    freq.put("øgn", 6);
    freq.put("wal", 3);
    freq.put("way", 4);
    freq.put("mt ", 66);
    freq.put("war", 4);
    freq.put(" X ", 6);
    freq.put(" nå", 352);
    freq.put(" næ", 20);
    freq.put("xy ", 4);
    freq.put(" nø", 21);
    freq.put("mti", 16);
    freq.put("mta", 4);
    freq.put("Odd", 5);
    freq.put("mte", 17);
    freq.put(" n ", 14);
    freq.put("ün", 5);
    freq.put(" ni", 12);
    freq.put("umu", 5);
    freq.put(" nj", 4);
    freq.put(" no", 448);
    freq.put("kva", 27);
    freq.put(" na", 96);
    freq.put(" ne", 285);
    freq.put("kvi", 31);
    freq.put(" ny", 165);
    freq.put(" nr", 17);
    freq.put(" nu", 10);
    freq.put("Sk", 135);
    freq.put("ums", 6);
    freq.put("Sn", 14);
    freq.put("Sm", 16);
    freq.put("gu ", 4);
    freq.put("yve", 6);
    freq.put(" Øk", 4);
    freq.put(" Øn", 4);
    freq.put(" Øl", 4);
    freq.put("umm", 17);
    freq.put(" Øy", 6);
    freq.put(" Øs", 15);
    freq.put("umo", 4);
    freq.put("gue", 4);
    freq.put("gud", 17);
    freq.put("gum", 3);
    freq.put("gul", 25);
    freq.put("gus", 10);
    freq.put("p", 5201);
    freq.put("yv ", 3);
    freq.put("gut", 27);
    freq.put("OK ", 7);
    freq.put("Fåt", 3);
    freq.put("htt", 7);
    freq.put("hts", 4);
    freq.put("ek ", 22);
    freq.put("Få ", 3);
    freq.put("ht ", 8);
    freq.put("eko", 32);
    freq.put("ekn", 17);
    freq.put("ekl", 22);
    freq.put("ekk", 142);
    freq.put("ekj", 9);
    freq.put("eke", 25);
    freq.put("eka", 20);
    freq.put("Mos", 18);
    freq.put("eky", 6);
    freq.put("ekv", 9);
    freq.put("PC ", 4);
    freq.put("ekt", 121);
    freq.put("eks", 83);
    freq.put("ekr", 13);
    freq.put("spø", 35);
    freq.put("kym", 6);
    freq.put("spå", 4);
    freq.put("kse", 43);
    freq.put(" Ka", 110);
    freq.put("kyl", 18);
    freq.put(" Ke", 7);
    freq.put(" Kj", 47);
    freq.put(" Ki", 20);
    freq.put(" Kn", 3);
    freq.put(" Ko", 70);
    freq.put(" Kl", 30);
    freq.put(" Kr", 40);
    freq.put("Moh", 5);
    freq.put(" Kv", 16);
    freq.put(" Ku", 17);
    freq.put("ksa", 8);
    freq.put(" Ky", 4);
    freq.put("Mon", 12);
    freq.put("F", 526);
    freq.put("fb ", 5);
    freq.put("ksl", 3);
    freq.put("kso", 21);
    freq.put("ibi", 5);
    freq.put("ibl", 14);
    freq.put("cas", 5);
    freq.put("car", 3);
    freq.put("cap", 6);
    freq.put("ibe", 9);
    freq.put("cat", 3);
    freq.put("can", 4);
    freq.put("cam", 5);
    freq.put("cal", 3);
    freq.put("ksj", 29);
    freq.put("ibu", 7);
    freq.put("spy", 4);
    freq.put("ao ", 5);
    freq.put("spr", 46);
    freq.put("spu", 12);
    freq.put("spi", 152);
    freq.put("spl", 9);
    freq.put("spm", 8);
    freq.put("spo", 29);
    freq.put("spa", 30);
    freq.put("spe", 79);
    freq.put(" Kå", 5);
    freq.put("gh ", 3);
    freq.put("use", 74);
    freq.put("aos", 3);
    freq.put("sp ", 3);
    freq.put("ght", 12);
    freq.put("ghu", 4);
    freq.put("ghe", 68);
    freq.put("ER ", 15);
    freq.put("gha", 6);
    freq.put("Ru", 10);
    freq.put("Rv", 3);
    freq.put("Che", 7);
    freq.put("eå", 4);
    freq.put("Chi", 8);
    freq.put("Jar", 4);
    freq.put("Ry", 6);
    freq.put("Jan", 9);
    freq.put("Re", 54);
    freq.put("Chr", 3);
    freq.put("Jam", 3);
    freq.put("Jaj", 5);
    freq.put("Ra", 29);
    freq.put("Jad", 5);
    freq.put("Ro", 43);
    freq.put("Ri", 19);
    freq.put("mbi", 9);
    freq.put("nol", 4);
    freq.put("nom", 68);
    freq.put("non", 20);
    freq.put("tje", 40);
    freq.put("noi", 4);
    freq.put("nok", 97);
    freq.put("noe", 240);
    freq.put("nog", 3);
    freq.put("mba", 10);
    freq.put("R ", 47);
    freq.put("rlø", 4);
    freq.put("not", 5);
    freq.put("nov", 7);
    freq.put("son", 75);
    freq.put("nop", 9);
    freq.put("Ja ", 64);
    freq.put("nos", 5);
    freq.put("sos", 16);
    freq.put("sou", 3);
    freq.put("em", 544);
    freq.put("el", 2085);
    freq.put("eo", 46);
    freq.put("en", 5939);
    freq.put("ei", 672);
    freq.put("eh", 115);
    freq.put("ek", 531);
    freq.put("ej", 25);
    freq.put("ee", 165);
    freq.put("ed", 1286);
    freq.put("eg", 2375);
    freq.put("Afg", 3);
    freq.put("ea", 118);
    freq.put("rl ", 13);
    freq.put("ec", 19);
    freq.put("eb", 158);
    freq.put("Rå", 3);
    freq.put("Sø", 23);
    freq.put("ey", 27);
    freq.put("ex", 26);
    freq.put("ez", 13);
    freq.put("eu", 22);
    freq.put("et", 3699);
    freq.put("ew", 14);
    freq.put("ev", 248);
    freq.put("ep", 203);
    freq.put("es", 1394);
    freq.put("er", 7452);
    freq.put("rlo", 4);
    freq.put("rli", 101);
    freq.put("rle", 11);
    freq.put("rld", 3);
    freq.put("rla", 20);
    freq.put("e ", 7917);
    freq.put(" i ", 1381);
    freq.put("lme", 21);
    freq.put("xk", 3);
    freq.put("xi", 4);
    freq.put("Sov", 7);
    freq.put("xe", 9);
    freq.put("xy", 5);
    freq.put("xp", 4);
    freq.put("xt", 5);
    freq.put("Eur", 5);
    freq.put("xD", 11);
    freq.put("fn", 3);
    freq.put("x ", 36);
    freq.put("za ", 11);
    freq.put("pni", 5);
    freq.put("pne", 17);
    freq.put("jæl", 5);
    freq.put("egr", 23);
    freq.put("jær", 36);
    freq.put("jæv", 22);
    freq.put("øyp", 4);
    freq.put("øyr", 28);
    freq.put("øys", 8);
    freq.put("øyt", 18);
    freq.put("øya", 22);
    freq.put("øyd", 19);
    freq.put("øye", 30);
    freq.put("øyk", 11);
    freq.put("øyn", 3);
    freq.put("Pho", 10);
    freq.put("åel", 5);
    freq.put("øy ", 37);
    freq.put("ò", 3);
    freq.put("mre", 7);
    freq.put("Wen", 5);
    freq.put("Wes", 4);
    freq.put(" p ", 8);
    freq.put(" ps", 6);
    freq.put(" pr", 227);
    freq.put(" pu", 33);
    freq.put(" py", 5);
    freq.put(" pc", 8);
    freq.put(" pa", 140);
    freq.put(" pg", 22);
    freq.put(" pe", 92);
    freq.put(" pi", 37);
    freq.put(" ph", 3);
    freq.put(" po", 128);
    freq.put(" pl", 87);
    freq.put("ytt", 109);
    freq.put("ytr", 6);
    freq.put("yto", 4);
    freq.put("tea", 11);
    freq.put("yti", 3);
    freq.put("yte", 22);
    freq.put(" pø", 8);
    freq.put("Kri", 16);
    freq.put("Kro", 6);
    freq.put(" på", 1465);
    freq.put("Kra", 6);
    freq.put("Kre", 5);
    freq.put("EM ", 4);
    freq.put("vun", 3);
    freq.put("vra", 3);
    freq.put("vur", 10);
    freq.put("KrF", 3);
    freq.put("yt ", 21);
    freq.put("hvi", 51);
    freq.put("hvo", 96);
    freq.put("hva", 83);
    freq.put("hve", 96);
    freq.put(" Må", 30);
    freq.put("Måt", 3);
    freq.put("åg ", 4);
    freq.put(" Mø", 10);
    freq.put("etr", 20);
    freq.put("eis", 42);
    freq.put("eir", 30);
    freq.put("eit", 59);
    freq.put("IL ", 3);
    freq.put("eiv", 9);
    freq.put("ågr", 4);
    freq.put("etu", 10);
    freq.put("eia", 16);
    freq.put("eie", 73);
    freq.put("eid", 62);
    freq.put("eig", 9);
    freq.put("eii", 4);
    freq.put("eik", 15);
    freq.put("eim", 32);
    freq.put("eil", 71);
    freq.put("ein", 57);
    freq.put("ety", 17);
    freq.put("yh", 21);
    freq.put("yl", 81);
    freq.put(" Me", 179);
    freq.put(" Ma", 102);
    freq.put(" Mc", 3);
    freq.put(" Mm", 3);
    freq.put(" Mo", 82);
    freq.put(" Mi", 60);
    freq.put("Sin", 8);
    freq.put(" Mu", 9);
    freq.put(" Mv", 8);
    freq.put(" My", 11);
    freq.put("yb", 10);
    freq.put("etd", 3);
    freq.put("ete", 175);
    freq.put("eth", 7);
    freq.put(" M ", 7);
    freq.put("eto", 10);
    freq.put("am ", 67);
    freq.put("ps ", 30);
    freq.put("ch", 74);
    freq.put("Her", 38);
    freq.put("yv", 13);
    freq.put("lg ", 45);
    freq.put("psj", 7);
    freq.put("psk", 10);
    freq.put("psi", 7);
    freq.put("amm", 161);
    freq.put("aml", 40);
    freq.put("psl", 8);
    freq.put("amn", 8);
    freq.put("psb", 3);
    freq.put("psa", 3);
    freq.put("psf", 4);
    freq.put("ynn", 36);
    freq.put("pse", 9);
    freq.put("amy", 3);
    freq.put("psy", 4);
    freq.put("amp", 97);
    freq.put("psp", 4);
    freq.put("amu", 5);
    freq.put("amt", 23);
    freq.put("pst", 10);
    freq.put("amv", 3);
    freq.put("gjo", 60);
    freq.put("t", 18149);
    freq.put("gje", 217);
    freq.put("gja", 3);
    freq.put("cs", 3);
    freq.put("Heh", 22);
    freq.put("Mør", 3);
    freq.put("Col", 3);
    freq.put("tda", 8);
    freq.put("tde", 5);
    freq.put("nme", 18);
    freq.put("nma", 10);
    freq.put("sra", 10);
    freq.put("gjø", 121);
    freq.put("sre", 7);
    freq.put("sri", 3);
    freq.put("sru", 7);
    freq.put("Adr", 3);
    freq.put("Ada", 4);
    freq.put("lob", 5);
    freq.put("log", 90);
    freq.put("lod", 10);
    freq.put("lok", 54);
    freq.put("lon", 13);
    freq.put("loo", 9);
    freq.put("lol", 8);
    freq.put("lom", 43);
    freq.put("lor", 4);
    freq.put("los", 13);
    freq.put("lop", 14);
    freq.put("lov", 53);
    freq.put("low", 17);
    freq.put("lot", 37);
    freq.put("lou", 3);
    freq.put("høy", 41);
    freq.put("J", 525);
    freq.put("rje", 4);
    freq.put("rja", 3);
    freq.put("lo ", 73);
    freq.put("Brø", 3);
    freq.put("Gen", 3);
    freq.put("Wil", 5);
    freq.put("yon", 3);
    freq.put("Lan", 6);
    freq.put("yog", 3);
    freq.put("Lag", 7);
    freq.put("Lat", 3);
    freq.put("you", 14);
    freq.put("Lap", 3);
    freq.put("Lar", 11);
    freq.put("Las", 4);
    freq.put("lga", 14);
    freq.put("Bru", 10);
    freq.put("La ", 5);
    freq.put("Bro", 5);
    freq.put("Bre", 13);
    freq.put("Bra", 29);
    freq.put("mp ", 46);
    freq.put("oss", 86);
    freq.put("ysk", 13);
    freq.put("mpe", 73);
    freq.put("mpa", 19);
    freq.put("mpo", 18);
    freq.put("mpl", 10);
    freq.put(" rø", 36);
    freq.put("mpi", 9);
    freq.put(" rå", 12);
    freq.put(" ræ", 5);
    freq.put("Uan", 6);
    freq.put("ass", 177);
    freq.put("håp", 31);
    freq.put("hår", 14);
    freq.put("hån", 17);
    freq.put(" ru", 61);
    freq.put(" ry", 22);
    freq.put(" re", 284);
    freq.put(" ra", 68);
    freq.put(" rb", 3);
    freq.put("Mvh", 8);
    freq.put(" ro", 61);
    freq.put(" ri", 57);
    freq.put("yst", 50);
    freq.put("ask", 52);
    freq.put("S ", 37);
    freq.put("asm", 5);
    freq.put("Sy", 52);
    freq.put("fø", 293);
    freq.put("Sp", 54);
    freq.put("Sw", 5);
    freq.put("Sv", 23);
    freq.put("Su", 24);
    freq.put("St", 154);
    freq.put("FC ", 3);
    freq.put("Sj", 24);
    freq.put("Si", 70);
    freq.put("Sh", 6);
    freq.put("So", 67);
    freq.put("få", 242);
    freq.put("fæ", 4);
    freq.put("Sl", 22);
    freq.put("Sc", 5);
    freq.put("Sa", 75);
    freq.put("Se", 135);
    freq.put("egå", 8);
    freq.put("f ", 69);
    freq.put("hhh", 8);
    freq.put("eg ", 1872);
    freq.put("fr", 445);
    freq.put("fs", 6);
    freq.put("ft", 135);
    freq.put("fu", 115);
    freq.put("fy", 44);
    freq.put("fa", 364);
    freq.put("fb", 9);
    freq.put("hh ", 5);
    freq.put("fe", 341);
    freq.put("ff", 130);
    freq.put("fg", 5);
    freq.put("fi", 324);
    freq.put("fj", 42);
    freq.put("fk", 3);
    freq.put("fl", 182);
    freq.put("fm", 3);
    freq.put("Så", 69);
    freq.put("fo", 1305);
    freq.put("a", 14499);
    freq.put("egy", 41);
    freq.put("ået", 4);
    freq.put("egv", 7);
    freq.put("egu", 17);
    freq.put("egj", 14);
    freq.put("egi", 19);
    freq.put("åen", 14);
    freq.put("ego", 9);
    freq.put("egn", 77);
    freq.put("egl", 14);
    freq.put("ega", 34);
    freq.put("egg", 98);
    freq.put("ege", 125);
    freq.put("ce ", 21);
    freq.put("y ", 312);
    freq.put("ffo", 3);
    freq.put("ffi", 7);
    freq.put("ffe", 76);
    freq.put("uve", 10);
    freq.put("ffa", 8);
    freq.put(" On", 5);
    freq.put(" Ol", 17);
    freq.put(" Om", 19);
    freq.put(" Ok", 13);
    freq.put(" Oh", 4);
    freq.put(" Oi", 3);
    freq.put(" Of", 4);
    freq.put(" Og", 74);
    freq.put(" Od", 5);
    freq.put(" Ob", 3);
    freq.put(" Ov", 14);
    freq.put(" Ou", 4);
    freq.put(" Or", 14);
    freq.put(" Os", 60);
    freq.put(" Op", 29);
    freq.put("rwa", 3);
    freq.put("yk", 190);
    freq.put("ym", 41);
    freq.put("ceb", 22);
    freq.put("yo", 25);
    freq.put("yn", 207);
    freq.put("ya", 36);
    freq.put("cen", 8);
    freq.put("yc", 7);
    freq.put("cel", 9);
    freq.put("ye", 258);
    freq.put("yd", 90);
    freq.put("yg", 69);
    freq.put("yf", 8);
    freq.put("yy", 6);
    freq.put("ces", 3);
    freq.put("cer", 3);
    freq.put("yp", 48);
    freq.put("ys", 135);
    freq.put("yr", 129);
    freq.put("yt", 167);
    freq.put("yw", 3);
    freq.put("ff ", 24);
    freq.put("ift", 46);
    freq.put("ifr", 6);
    freq.put("ify", 5);
    freq.put(" O ", 6);
    freq.put("ife", 9);
    freq.put("iff", 4);
    freq.put("ifo", 4);
    freq.put("ifi", 12);
    freq.put("End", 8);
    freq.put("Ene", 3);
    freq.put("Eng", 7);
    freq.put("Eni", 9);
    freq.put("Åle", 7);
    freq.put("as ", 55);
    freq.put("Ent", 4);
    freq.put("En ", 42);
    freq.put("pum", 3);
    freq.put("pun", 11);
    freq.put("asp", 5);
    freq.put("asu", 3);
    freq.put("ast", 107);
    freq.put("asy", 6);
    freq.put("pub", 8);
    freq.put("asc", 8);
    freq.put("asa", 7);
    freq.put("asf", 4);
    freq.put("ase", 29);
    freq.put("put", 5);
    freq.put("asj", 97);
    freq.put("asi", 17);
    freq.put("ash", 7);
    freq.put("pup", 8);
    freq.put("pur", 13);
    freq.put("pus", 11);
    freq.put(" F ", 5);
    freq.put("Imp", 4);
    freq.put("Clu", 3);
    freq.put("st ", 330);
    freq.put("dt ", 181);
    freq.put("tfl", 3);
    freq.put("tfo", 33);
    freq.put("tfi", 3);
    freq.put("tfe", 4);
    freq.put("tfa", 22);
    freq.put("nch", 6);
    freq.put("rhå", 10);
    freq.put("nce", 6);
    freq.put("ste", 765);
    freq.put("stf", 14);
    freq.put("sta", 242);
    freq.put("stb", 6);
    freq.put("stl", 21);
    freq.put("stn", 9);
    freq.put("sto", 151);
    freq.put("sti", 182);
    freq.put("stj", 10);
    freq.put("stk", 12);
    freq.put("stu", 49);
    freq.put("stv", 4);
    freq.put("stp", 3);
    freq.put("str", 168);
    freq.put("sts", 3);
    freq.put("dts", 3);
    freq.put("dtr", 3);
    freq.put("sty", 47);
    freq.put("Goo", 6);
    freq.put("ka ", 97);
    freq.put("ncy", 3);
    freq.put("God", 33);
    freq.put("lid", 8);
    freq.put("lie", 17);
    freq.put("lif", 9);
    freq.put("lig", 649);
    freq.put("Nin", 3);
    freq.put("lia", 9);
    freq.put("lib", 3);
    freq.put("lic", 3);
    freq.put("lil", 12);
    freq.put("lim", 22);
    freq.put("lin", 116);
    freq.put("lio", 18);
    freq.put("lii", 4);
    freq.put("lik", 211);
    freq.put("lit", 390);
    freq.put("Nix", 3);
    freq.put("lip", 28);
    freq.put("lir", 213);
    freq.put("lis", 78);
    freq.put("kab", 4);
    freq.put("kaf", 32);
    freq.put("kad", 15);
    freq.put("kak", 23);
    freq.put("rhu", 6);
    freq.put("kan", 312);
    freq.put("kam", 81);
    freq.put("kal", 326);
    freq.put("rhi", 3);
    freq.put("kar", 50);
    freq.put("kap", 60);
    freq.put("Thi", 4);
    freq.put("kat", 43);
    freq.put("rha", 5);
    freq.put("The", 13);
    freq.put("rhe", 14);
    freq.put("stå", 83);
    freq.put("li ", 99);
    freq.put("stø", 53);
    freq.put("så ", 490);
    freq.put("ymp", 7);
    freq.put("ymr", 6);
    freq.put("ymt", 3);
    freq.put("yma", 3);
    freq.put("yme", 10);
    freq.put("ox ", 4);
    freq.put("ymo", 3);
    freq.put("x", 90);
    freq.put("ydn", 5);
    freq.put("dte", 27);
    freq.put("wor", 7);
    freq.put("Ple", 3);
    freq.put("Pla", 8);
    freq.put("Mo", 82);
    freq.put("ydb", 3);
    freq.put("Øk", 4);
    freq.put("Øn", 4);
    freq.put("Øl", 4);
    freq.put("Øy", 6);
    freq.put("Øs", 15);
    freq.put("dæ ", 3);
    freq.put("Wal", 6);
    freq.put(" t ", 11);
    freq.put("rP ", 10);
    freq.put(" ty", 36);
    freq.put(" tw", 91);
    freq.put(" tv", 41);
    freq.put(" tu", 59);
    freq.put(" ts", 3);
    freq.put(" tr", 356);
    freq.put("N", 518);
    freq.put(" to", 158);
    freq.put(" tj", 20);
    freq.put(" ti", 1084);
    freq.put(" th", 23);
    freq.put(" te", 193);
    freq.put(" ta", 298);
    freq.put("gså", 107);
    freq.put("Kve", 3);
    freq.put("Kva", 7);
    freq.put("Kvi", 6);
    freq.put("gs ", 24);
    freq.put(" tø", 27);
    freq.put(" tå", 15);
    freq.put("gsp", 13);
    freq.put("gss", 7);
    freq.put("gst", 30);
    freq.put("gsv", 7);
    freq.put("gsa", 10);
    freq.put("EI ", 5);
    freq.put("gsb", 5);
    freq.put("gse", 9);
    freq.put("gsg", 3);
    freq.put("gsf", 12);
    freq.put("gsi", 5);
    freq.put("gsk", 12);
    freq.put("gsm", 10);
    freq.put("gsl", 6);
    freq.put("gso", 3);
    freq.put("hje", 116);
    freq.put("åh", 13);
    freq.put("liv", 58);
    freq.put("ee ", 10);
    freq.put("eez", 6);
    freq.put("eet", 61);
    freq.put("eep", 4);
    freq.put("ees", 3);
    freq.put("eer", 7);
    freq.put("eel", 4);
    freq.put("een", 17);
    freq.put("eek", 6);
    freq.put("eee", 29);
    freq.put("eed", 10);
    freq.put("ru ", 14);
    freq.put("hjø", 6);
    freq.put(" Qu", 3);
    freq.put("id ", 116);
    freq.put("ruk", 103);
    freq.put("run", 97);
    freq.put("rul", 9);
    freq.put("rum", 36);
    freq.put("kao", 5);
    freq.put("rua", 6);
    freq.put("rug", 5);
    freq.put("rud", 22);
    freq.put("rue", 6);
    freq.put("rur", 4);
    freq.put("rus", 27);
    freq.put("rup", 10);
    freq.put("rhv", 9);
    freq.put("rut", 26);
    freq.put("kas", 40);
    freq.put("idt", 16);
    freq.put("idr", 16);
    freq.put("ids", 30);
    freq.put(" Q ", 3);
    freq.put("ido", 3);
    freq.put("idl", 33);
    freq.put("idi", 20);
    freq.put("idg", 3);
    freq.put("idd", 40);
    freq.put("ide", 194);
    freq.put("ida", 74);
    freq.put("Eli", 4);
    freq.put("rho", 17);
    freq.put("Ell", 27);
    freq.put("oha", 8);
    freq.put("Els", 9);
    freq.put("Tå", 5);
    freq.put("ut ", 195);
    freq.put(" æ ", 16);
    freq.put("løt", 6);
    freq.put("løs", 31);
    freq.put("lør", 25);
    freq.put("løp", 30);
    freq.put("løy", 8);
    freq.put("løf", 8);
    freq.put("løn", 10);
    freq.put("løk", 8);
    freq.put(" ær", 4);
    freq.put("utf", 10);
    freq.put("utg", 10);
    freq.put("utd", 8);
    freq.put("ute", 137);
    freq.put("svæ", 4);
    freq.put("uti", 20);
    freq.put("utn", 6);
    freq.put("uto", 11);
    freq.put("utl", 10);
    freq.put("utr", 21);
    freq.put("uts", 44);
    freq.put("utv", 18);
    freq.put("utt", 123);
    freq.put("utu", 8);
    freq.put("Vår", 7);
    freq.put("Ty", 17);
    freq.put("Tv", 7);
    freq.put("Tw", 34);
    freq.put("Tu", 27);
    freq.put("Tr", 120);
    freq.put("To", 60);
    freq.put("Tj", 11);
    freq.put("Th", 27);
    freq.put("Ti", 56);
    freq.put("Vål", 4);
    freq.put("Te", 33);
    freq.put("Våk", 3);
    freq.put("Ta", 85);
    freq.put("nab", 7);
    freq.put("nac", 5);
    freq.put("naa", 3);
    freq.put("nag", 5);
    freq.put("nad", 17);
    freq.put("nak", 60);
    freq.put("nan", 18);
    freq.put("sv ", 8);
    freq.put("nam", 5);
    freq.put("nar", 55);
    freq.put("nas", 23);
    freq.put("nap", 7);
    freq.put("nav", 25);
    freq.put("nat", 61);
    freq.put("Beg", 4);
    freq.put("ook", 27);
    freq.put("T ", 101);
    freq.put("Aa", 3);
    freq.put("svo", 7);
    freq.put("na ", 106);
    freq.put("Ab", 13);
    freq.put("dvi", 5);
    freq.put("Ad", 12);
    freq.put("Ag", 5);
    freq.put("svi", 23);
    freq.put("dve", 11);
    freq.put("Ah", 15);
    freq.put("Ak", 14);
    freq.put("sve", 46);
    freq.put("Am", 7);
    freq.put("Al", 63);
    freq.put("An", 44);
    freq.put("Ap", 22);
    freq.put("As", 13);
    freq.put("Ar", 41);
    freq.put("Au", 5);
    freq.put("At", 19);
    freq.put("Av", 24);
    freq.put("gv", 23);
    freq.put("gu", 102);
    freq.put("gt", 131);
    freq.put("gs", 272);
    freq.put("gr", 322);
    freq.put("gp", 9);
    freq.put("gy", 49);
    freq.put("gg", 285);
    freq.put("gf", 10);
    freq.put("ge", 1600);
    freq.put("gd", 41);
    freq.put("gb", 19);
    freq.put("ga", 419);
    freq.put("go", 228);
    freq.put("gn", 138);
    freq.put("gm", 7);
    freq.put("Gil", 3);
    freq.put("gk", 20);
    freq.put("gj", 406);
    freq.put("gi", 233);
    freq.put("gh", 96);
    freq.put("Tja", 6);
    freq.put("lko", 25);
    freq.put("Nok", 7);
    freq.put("Noe", 46);
    freq.put("lke", 78);
    freq.put("Nob", 3);
    freq.put("lka", 12);
    freq.put("Not", 4);
    freq.put("Nov", 5);
    freq.put("Nor", 85);
    freq.put("Nos", 3);
    freq.put("Gi ", 4);
    freq.put("hi ", 10);
    freq.put("Spr", 5);
    freq.put("Spu", 3);
    freq.put("lk ", 99);
    freq.put("Spi", 6);
    freq.put("Spo", 8);
    freq.put("Spa", 7);
    freq.put("esh", 4);
    freq.put("Spe", 20);
    freq.put("zo", 4);
    freq.put("zi", 6);
    freq.put("flu", 3);
    freq.put("za", 16);
    freq.put("gø", 22);
    freq.put("gæ", 3);
    freq.put("gå", 204);
    freq.put("zz", 18);
    freq.put("Ah ", 5);
    freq.put("ull", 141);
    freq.put("z ", 22);
    freq.put("Aha", 7);
    freq.put(" åå", 5);
    freq.put("win", 4);
    freq.put("wil", 3);
    freq.put("wit", 87);
    freq.put(" vå", 42);
    freq.put(" væ", 208);
    freq.put("rås", 5);
    freq.put("råt", 9);
    freq.put("råk", 14);
    freq.put("rål", 5);
    freq.put("råd", 25);
    freq.put("wi ", 3);
    freq.put("rå ", 11);
    freq.put(" va", 403);
    freq.put(" ve", 562);
    freq.put(" vi", 587);
    freq.put(" vo", 34);
    freq.put(" vs", 5);
    freq.put(" vr", 4);
    freq.put(" vu", 8);
    freq.put("lå ", 10);
    freq.put("sær", 8);
    freq.put("lån", 13);
    freq.put("lår", 10);
    freq.put("lås", 16);
    freq.put("låt", 16);
    freq.put("EG ", 6);
    freq.put("mar", 68);
    freq.put("hle", 4);
    freq.put("max", 3);
    freq.put("eck", 5);
    freq.put("eci", 4);
    freq.put("ech", 3);
    freq.put("pær", 3);
    freq.put("hl ", 3);
    freq.put("Æ ", 4);
    freq.put("yra", 3);
    freq.put("rs ", 102);
    freq.put("cy ", 4);
    freq.put("AN ", 4);
    freq.put(" Sy", 52);
    freq.put("be ", 25);
    freq.put(" Sv", 23);
    freq.put(" Sw", 5);
    freq.put(" St", 154);
    freq.put(" Su", 24);
    freq.put(" Sj", 24);
    freq.put(" Sk", 135);
    freq.put(" Sh", 6);
    freq.put(" Si", 70);
    freq.put(" Sn", 14);
    freq.put(" So", 67);
    freq.put(" Sl", 22);
    freq.put(" Sm", 16);
    freq.put(" Sc", 5);
    freq.put(" Sa", 75);
    freq.put(" Se", 135);
    freq.put("rsl", 15);
    freq.put("rsm", 21);
    freq.put("rso", 59);
    freq.put("rsh", 6);
    freq.put("rsi", 25);
    freq.put("rsj", 4);
    freq.put("rsk", 93);
    freq.put("rsd", 40);
    freq.put("rse", 45);
    freq.put("rsf", 3);
    freq.put("rsg", 3);
    freq.put("rsa", 7);
    freq.put("AS ", 4);
    freq.put("rsy", 4);
    freq.put("rst", 142);
    freq.put("rsv", 20);
    freq.put("rsp", 9);
    freq.put("yrr", 3);
    freq.put("NU ", 3);
    freq.put("rss", 5);
    freq.put("bek", 16);
    freq.put("beh", 12);
    freq.put("bei", 52);
    freq.put("ben", 30);
    freq.put("bel", 25);
    freq.put("yrt", 3);
    freq.put("bea", 3);
    freq.put("bef", 17);
    freq.put("beg", 67);
    freq.put("bed", 59);
    freq.put("ber", 112);
    freq.put("bes", 107);
    freq.put(" S ", 7);
    freq.put("bev", 19);
    freq.put("bet", 56);
    freq.put("Kle", 8);
    freq.put("py ", 6);
    freq.put("itt", 564);
    freq.put("ur ", 74);
    freq.put("Dep", 3);
    freq.put(" Så", 69);
    freq.put("rså", 3);
    freq.put("rsø", 20);
    freq.put("pyn", 3);
    freq.put("Jø", 4);
    freq.put("awa", 5);
    freq.put("urd", 45);
    freq.put("ure", 51);
    freq.put("urf", 3);
    freq.put("urg", 5);
    freq.put("fjo", 21);
    freq.put("ura", 43);
    freq.put("Hvo", 41);
    freq.put("Dei", 3);
    freq.put("url", 3);
    freq.put("urm", 3);
    freq.put("urn", 15);
    freq.put("uro", 11);
    freq.put("urh", 3);
    freq.put("uri", 4);
    freq.put("fje", 18);
    freq.put("urk", 6);
    freq.put("urt", 34);
    freq.put("urr", 22);
    freq.put("urs", 39);
    freq.put("Del", 3);
    freq.put("mg ", 8);
    freq.put("Den", 51);
    freq.put("ngd", 18);
    freq.put("nge", 573);
    freq.put("nga", 55);
    freq.put("ngb", 4);
    freq.put("ngl", 26);
    freq.put("ngo", 7);
    freq.put("ngh", 5);
    freq.put("ngi", 10);
    freq.put("ngj", 6);
    freq.put("ngk", 4);
    freq.put("sh ", 11);
    freq.put("ngp", 3);
    freq.put("ngr", 32);
    freq.put("ngs", 99);
    freq.put("tby", 5);
    freq.put("mga", 9);
    freq.put("ttp", 9);
    freq.put("tbu", 4);
    freq.put("tba", 37);
    freq.put("ng ", 535);
    freq.put("shu", 7);
    freq.put("sha", 12);
    freq.put("she", 7);
    freq.put("shi", 21);
    freq.put("sho", 27);
    freq.put("ke ", 1294);
    freq.put("lup", 4);
    freq.put("ngå", 8);
    freq.put("lur", 25);
    freq.put("lus", 18);
    freq.put("lut", 69);
    freq.put("lub", 10);
    freq.put("lud", 5);
    freq.put("tte", 801);
    freq.put("luf", 12);
    freq.put("luk", 18);
    freq.put("ngø", 3);
    freq.put("lum", 4);
    freq.put("lun", 10);
    freq.put("ken", 212);
    freq.put("kem", 11);
    freq.put("kel", 149);
    freq.put("kek", 4);
    freq.put("kei", 8);
    freq.put("keh", 9);
    freq.put("keg", 10);
    freq.put("kef", 6);
    freq.put("kee", 4);
    freq.put("ked", 23);
    freq.put("keb", 11);
    freq.put("key", 7);
    freq.put("kev", 20);
    freq.put("ket", 116);
    freq.put("kes", 57);
    freq.put("ker", 497);
    freq.put("kep", 16);
    freq.put("Lof", 4);
    freq.put("ot ", 97);
    freq.put(" Å ", 16);
    freq.put("Lou", 4);
    freq.put("pim", 3);
    freq.put("yan", 3);
    freq.put("yak", 3);
    freq.put("oth", 6);
    freq.put("oti", 14);
    freq.put(" Åj", 3);
    freq.put("oto", 28);
    freq.put("ota", 9);
    freq.put("otb", 32);
    freq.put("ote", 56);
    freq.put("ots", 16);
    freq.put("ott", 65);
    freq.put(" År", 5);
    freq.put(" br", 254);
    freq.put("And", 18);
    freq.put("Ane", 7);
    freq.put("Ang", 3);
    freq.put("Ana", 4);
    freq.put("Anb", 3);
    freq.put("Ant", 3);
    freq.put("ya ", 22);
    freq.put("Då ", 5);
    freq.put("You", 7);
    freq.put("Yor", 3);
    freq.put("ls ", 30);
    freq.put("Dår", 5);
    freq.put("i", 13767);
    freq.put("ksi", 13);
    freq.put(" xD", 11);
    freq.put("Be", 62);
    freq.put("Ba", 51);
    freq.put("Bl", 74);
    freq.put("Bo", 62);
    freq.put("Bi", 30);
    freq.put("Bj", 10);
    freq.put("Bu", 19);
    freq.put("Br", 64);
    freq.put("By", 10);
    freq.put("B ", 32);
    freq.put(" x ", 6);
    freq.put("U ", 16);
    freq.put("Går", 5);
    freq.put("Bø", 7);
    freq.put("Ut", 29);
    freq.put("Up", 4);
    freq.put("Us", 5);
    freq.put("Ur", 3);
    freq.put("Ul", 5);
    freq.put("Un", 17);
    freq.put("Uk", 4);
    freq.put("LL ", 5);
    freq.put("Ua", 8);
    freq.put("Gå ", 3);
    freq.put("ea ", 20);
    freq.put("h ", 112);
    freq.put("eak", 9);
    freq.put("hy", 40);
    freq.put("eam", 13);
    freq.put("eal", 18);
    freq.put("ean", 9);
    freq.put("hr", 10);
    freq.put("hs", 5);
    freq.put("hv", 326);
    freq.put("ead", 6);
    freq.put("eag", 8);
    freq.put("hu", 146);
    freq.put("hj", 128);
    freq.put("hh", 16);
    freq.put("hi", 112);
    freq.put("hn", 7);
    freq.put("ho", 227);
    freq.put("hl", 9);
    freq.put("hm", 12);
    freq.put("eas", 9);
    freq.put("ear", 13);
    freq.put("ph", 17);
    freq.put("he", 808);
    freq.put("dma", 5);
    freq.put("dus", 18);
    freq.put("dme", 3);
    freq.put("hP", 3);
    freq.put("ID ", 3);
    freq.put("hn ", 3);
    freq.put(" Ut", 29);
    freq.put(" Up", 3);
    freq.put(" Ur", 3);
    freq.put(" Us", 4);
    freq.put(" Ul", 5);
    freq.put(" Un", 17);
    freq.put(" Uk", 4);
    freq.put(" Ua", 8);
    freq.put("hø", 161);
    freq.put("hæ", 3);
    freq.put("hå", 64);
    freq.put(" U ", 5);
    freq.put("MS ", 4);
    freq.put("aug", 23);
    freq.put("auk", 7);
    freq.put("aul", 3);
    freq.put("up ", 8);
    freq.put("esb", 5);
    freq.put("aus", 22);
    freq.put("aur", 6);
    freq.put("aut", 12);
    freq.put("Jod", 4);
    freq.put("ble", 99);
    freq.put("drø", 10);
    freq.put("sjø", 20);
    freq.put("upe", 23);
    freq.put("dré", 4);
    freq.put("ups", 7);
    freq.put("upp", 33);
    freq.put("sjå", 4);
    freq.put("me ", 239);
    freq.put("Pul", 3);
    freq.put("nel", 49);
    freq.put("nem", 10);
    freq.put("nek", 15);
    freq.put("neh", 10);
    freq.put("nei", 50);
    freq.put("nef", 4);
    freq.put("neg", 14);
    freq.put("ned", 73);
    freq.put("nee", 4);
    freq.put("neb", 9);
    freq.put("Pub", 4);
    freq.put("nex", 3);
    freq.put("ney", 5);
    freq.put("nev", 21);
    freq.put("new", 5);
    freq.put("sj ", 17);
    freq.put("ner", 443);
    freq.put("nes", 255);
    freq.put("nep", 9);
    freq.put("med", 654);
    freq.put("meg", 368);
    freq.put("meb", 8);
    freq.put("mel", 141);
    freq.put("men", 569);
    freq.put("mei", 10);
    freq.put("mek", 12);
    freq.put("met", 76);
    freq.put("mes", 80);
    freq.put("mer", 407);
    freq.put("dru", 3);
    freq.put("ne ", 842);
    freq.put("sju", 5);
    freq.put("dri", 159);
    freq.put("sjo", 155);
    freq.put("dro", 20);
    freq.put("dra", 76);
    freq.put("sja", 19);
    freq.put("dre", 231);
    freq.put("sje", 95);
    freq.put("St ", 3);
    freq.put("riv", 75);
    freq.put("Ste", 24);
    freq.put("kgr", 6);
    freq.put("Sta", 39);
    freq.put("Sto", 28);
    freq.put("Sti", 14);
    freq.put("Stj", 3);
    freq.put("Stu", 9);
    freq.put("Str", 19);
    freq.put("V", 349);
    freq.put("Til", 27);
    freq.put("Tin", 3);
    freq.put("vfø", 13);
    freq.put("ygg", 50);
    freq.put("ygd", 4);
    freq.put("Lil", 10);
    freq.put("Lin", 6);
    freq.put("Lio", 4);
    freq.put("Lik", 24);
    freq.put("Lit", 21);
    freq.put("Tid", 7);
    freq.put("ov ", 37);
    freq.put("ygt", 7);
    freq.put("Lis", 4);
    freq.put("Kaf", 4);
    freq.put("Kai", 5);
    freq.put("Kan", 72);
    freq.put("Kam", 4);
    freq.put("Kal", 6);
    freq.put("Kar", 12);
    freq.put("Kat", 8);
    freq.put("Stå", 5);
    freq.put("ova", 9);
    freq.put("ove", 235);
    freq.put("ovi", 7);
    freq.put("Stø", 7);
    freq.put("ovl", 4);
    freq.put("All", 21);
    freq.put("Ald", 5);
    freq.put("Alt", 24);
    freq.put("£ ", 4);
    freq.put("PR ", 3);
    freq.put("Wow", 4);
    freq.put("Wor", 3);
    freq.put("øs ", 15);
    freq.put("is ", 176);
    freq.put("øss", 5);
    freq.put("øst", 53);
    freq.put("iss", 67);
    freq.put("isr", 4);
    freq.put("isp", 5);
    freq.put("isv", 3);
    freq.put("isu", 9);
    freq.put("ist", 266);
    freq.put("isk", 214);
    freq.put("isj", 14);
    freq.put("isi", 20);
    freq.put("ish", 5);
    freq.put("iso", 13);
    freq.put("isn", 6);
    freq.put("ism", 10);
    freq.put("isl", 5);
    freq.put("isc", 3);
    freq.put("isb", 7);
    freq.put("isa", 16);
    freq.put("øsn", 7);
    freq.put("ise", 151);
    freq.put("ød ", 18);
    freq.put("BB ", 10);
    freq.put("Coo", 3);
    freq.put("gyn", 40);
    freq.put("gym", 4);
    freq.put("På ", 54);
    freq.put("ty ", 32);
    freq.put("FK ", 6);
    freq.put("do ", 5);
    freq.put("tyl", 5);
    freq.put("tyn", 9);
    freq.put("tyk", 5);
    freq.put("tyd", 12);
    freq.put("tyg", 11);
    freq.put("tyv", 3);
    freq.put("typ", 13);
    freq.put("tyr", 37);
    freq.put("tys", 6);
    freq.put("dok", 8);
    freq.put("don", 19);
    freq.put("dol", 8);
    freq.put("dom", 36);
    freq.put("dob", 6);
    freq.put("m", 7626);
    freq.put("dog", 6);
    freq.put("dor", 3);
    freq.put("dos", 3);
    freq.put("dop", 3);
    freq.put("dov", 3);
    freq.put("dow", 4);
    freq.put(" We", 14);
    freq.put(" Wa", 7);
    freq.put(" Wo", 10);
    freq.put(" Wh", 6);
    freq.put(" Wi", 12);
    freq.put("kul", 107);
    freq.put("ba ", 8);
    freq.put("bat", 25);
    freq.put("bar", 236);
    freq.put("bas", 11);
    freq.put("unø", 3);
    freq.put("bay", 3);
    freq.put("bag", 6);
    freq.put("bad", 7);
    freq.put("bab", 3);
    freq.put("bac", 13);
    freq.put("ban", 58);
    freq.put("bal", 47);
    freq.put("bam", 4);
    freq.put("bak", 86);
    freq.put("om ", 1194);
    freq.put("øde", 22);
    freq.put("Run", 5);
    freq.put("un ", 82);
    freq.put("Så ", 58);
    freq.put("omb", 17);
    freq.put("oma", 27);
    freq.put("omg", 15);
    freq.put("omf", 4);
    freq.put("ome", 24);
    freq.put("omk", 6);
    freq.put("omi", 21);
    freq.put("omh", 4);
    freq.put("omo", 5);
    freq.put("omn", 3);
    freq.put("omm", 297);
    freq.put("oms", 53);
    freq.put("omr", 9);
    freq.put("omp", 30);
    freq.put("omv", 4);
    freq.put("omt", 24);
    freq.put("Ø", 37);
    freq.put("uns", 14);
    freq.put("unt", 11);
    freq.put("Hje", 11);
    freq.put("una", 3);
    freq.put("und", 160);
    freq.put("une", 39);
    freq.put("unf", 7);
    freq.put("ung", 64);
    freq.put("uni", 17);
    freq.put("unk", 33);
    freq.put("unn", 181);
    freq.put("iø", 18);
    freq.put("Ut ", 5);
    freq.put("C ", 18);
    freq.put("Utd", 3);
    freq.put("Ute", 7);
    freq.put("Ci", 10);
    freq.put("Ch", 31);
    freq.put("Co", 18);
    freq.put("Vå", 15);
    freq.put("Væ", 5);
    freq.put("Cl", 7);
    freq.put("slu", 39);
    freq.put("Ca", 49);
    freq.put("Ce", 10);
    freq.put("slo", 79);
    freq.put("sli", 83);
    freq.put("akr", 11);
    freq.put("sle", 36);
    freq.put("sla", 54);
    freq.put("Cu", 3);
    freq.put("ix", 7);
    freq.put("iz", 20);
    freq.put("iq", 4);
    freq.put("ip", 118);
    freq.put("is", 1002);
    freq.put("ir", 454);
    freq.put("Nan", 3);
    freq.put("it", 1073);
    freq.put("iw", 3);
    freq.put("iv", 314);
    freq.put("Nar", 4);
    freq.put("ih", 26);
    freq.put("ik", 1677);
    freq.put("ij", 3);
    freq.put("im", 216);
    freq.put("il", 1800);
    freq.put("Nat", 5);
    freq.put("in", 1983);
    freq.put("ia", 191);
    freq.put("ic", 63);
    freq.put("ib", 43);
    freq.put("ie", 397);
    freq.put("id", 559);
    freq.put("ig", 1218);
    freq.put("if", 93);
    freq.put("V ", 42);
    freq.put("iP", 12);
    freq.put("iT", 3);
    freq.put("iO", 3);
    freq.put("Svi", 4);
    freq.put("kis", 3);
    freq.put("kir", 6);
    freq.put("Sve", 12);
    freq.put("Sva", 3);
    freq.put("kik", 20);
    freq.put("kin", 60);
    freq.put("kim", 3);
    freq.put("kil", 22);
    freq.put("kic", 3);
    freq.put("i ", 2291);
    freq.put("Utø", 9);
    freq.put("kig", 3);
    freq.put("kif", 6);
    freq.put("kie", 4);
    freq.put("kid", 8);
    freq.put("Va", 37);
    freq.put("slø", 9);
    freq.put("Ve", 93);
    freq.put("Vi", 143);
    freq.put("øhl", 3);
    freq.put("Vu", 8);
    freq.put("slå", 22);
    freq.put("nk ", 33);
    freq.put("yen", 31);
    freq.put("yeb", 6);
    freq.put("op ", 23);
    freq.put("yes", 9);
    freq.put("yer", 12);
    freq.put("yet", 6);
    freq.put("vd ", 13);
    freq.put("opt", 10);
    freq.put("opu", 7);
    freq.put("opp", 376);
    freq.put("ye ", 185);
    freq.put("ope", 17);
    freq.put("opa", 7);
    freq.put("opl", 5);
    freq.put("opo", 5);
    freq.put("opi", 8);
    freq.put("opk", 3);
    freq.put("Ars", 8);
    freq.put("Art", 5);
    freq.put("Arv", 3);
    freq.put("Arb", 13);
    freq.put("vde", 11);
    freq.put("Are", 3);
    freq.put("Arn", 3);
    freq.put("www", 11);
    freq.put("OR ", 7);
    freq.put("ww ", 11);
    freq.put("enå", 4);
    freq.put("DN ", 4);
    freq.put("Å", 50);
    freq.put("Z", 4);
    freq.put("iqu", 3);
    freq.put("nki", 5);
    freq.put("EA ", 3);
    freq.put("RK ", 28);
    freq.put("Win", 3);
    freq.put("Søk", 4);
    freq.put("Søn", 3);
    freq.put("Sør", 12);
    freq.put("Wir", 3);
    freq.put("Lær", 3);
    freq.put("Grü", 4);
    freq.put("Grø", 4);
    freq.put("di ", 48);
    freq.put("eru", 15);
    freq.put("din", 75);
    freq.put("dio", 35);
    freq.put("dik", 10);
    freq.put("did", 9);
    freq.put("die", 25);
    freq.put("dig", 186);
    freq.put("dia", 17);
    freq.put("dit", 30);
    freq.put("div", 5);
    freq.put("dir", 19);
    freq.put("dis", 59);
    freq.put(" Yo", 11);
    freq.put(" Ye", 6);
    freq.put("Mob", 4);
    freq.put("Gre", 9);
    freq.put("Gra", 24);
    freq.put("Gri", 4);
    freq.put("erd", 111);
    freq.put("åpl", 4);
    freq.put("bo ", 13);
    freq.put("boy", 5);
    freq.put("åpe", 69);
    freq.put("tni", 17);
    freq.put("bor", 58);
    freq.put("bos", 4);
    freq.put("bot", 5);
    freq.put("boi", 3);
    freq.put("bok", 34);
    freq.put("bol", 15);
    freq.put("bom", 10);
    freq.put("bon", 3);
    freq.put("boo", 25);
    freq.put("åpa", 6);
    freq.put("bod", 8);
    freq.put("boe", 7);
    freq.put("åm", 6);
    freq.put("ål", 92);
    freq.put("ån", 125);
    freq.put("oo ", 13);
    freq.put("åk", 50);
    freq.put("åj", 3);
    freq.put("åe", 25);
    freq.put("åd", 57);
    freq.put("åg", 15);
    freq.put("åf", 9);
    freq.put("åb", 3);
    freq.put("åt", 168);
    freq.put("åv", 14);
    freq.put("åp", 108);
    freq.put("ås", 55);
    freq.put("år", 772);
    freq.put("aye", 5);
    freq.put("ul ", 20);
    freq.put("ays", 5);
    freq.put("ood", 10);
    freq.put("oog", 10);
    freq.put("Ben", 11);
    freq.put("Bel", 7);
    freq.put("oom", 4);
    freq.put("ool", 22);
    freq.put("ooo", 24);
    freq.put("oon", 6);
    freq.put("å ", 3566);
    freq.put("Bed", 5);
    freq.put("oot", 6);
    freq.put("oop", 6);
    freq.put("oos", 4);
    freq.put("Ber", 20);
    freq.put("Bes", 7);
    freq.put("fly", 45);
    freq.put("uly", 4);
    freq.put("uls", 5);
    freq.put("ulp", 3);
    freq.put("ulv", 5);
    freq.put("ay ", 27);
    freq.put("ult", 65);
    freq.put("fli", 19);
    freq.put("ulk", 6);
    freq.put("uli", 51);
    freq.put("ulo", 5);
    freq.put("flo", 26);
    freq.put("fla", 23);
    freq.put("ula", 10);
    freq.put("fle", 58);
    freq.put("ulg", 5);
    freq.put("uld", 5);
    freq.put("ule", 53);
    freq.put("åå", 15);
    freq.put("ma ", 59);
    freq.put("ljø", 10);
    freq.put("nys", 4);
    freq.put("nyt", 36);
    freq.put("nyh", 12);
    freq.put("nyn", 5);
    freq.put("nyo", 3);
    freq.put("nyl", 3);
    freq.put("nym", 5);
    freq.put("nya", 4);
    freq.put("nyg", 8);
    freq.put("nyd", 3);
    freq.put("nye", 69);
    freq.put("mas", 47);
    freq.put("sne", 11);
    freq.put("Fjo", 6);
    freq.put("mat", 67);
    freq.put("sna", 77);
    freq.put("sno", 5);
    freq.put("sni", 47);
    freq.put("maa", 3);
    freq.put("mac", 4);
    freq.put("snu", 19);
    freq.put("mag", 11);
    freq.put("mai", 14);
    freq.put("mak", 20);
    freq.put("mam", 13);
    freq.put("mal", 26);
    freq.put("sny", 6);
    freq.put("flø", 6);
    freq.put("q", 13);
    freq.put("ny ", 66);
    freq.put("ulæ", 3);
    freq.put("lse", 131);
    freq.put("lsb", 3);
    freq.put("lsa", 5);
    freq.put("lso", 6);
    freq.put("lsk", 94);
    freq.put("lsi", 3);
    freq.put("lsv", 5);
    freq.put("lst", 17);
    freq.put("eno", 13);
    freq.put("kk ", 358);
    freq.put("lsy", 6);
    freq.put(" ab", 9);
    freq.put(" ac", 5);
    freq.put(" ad", 13);
    freq.put("Tø", 11);
    freq.put(" ag", 5);
    freq.put(" ah", 3);
    freq.put(" ai", 3);
    freq.put(" ak", 60);
    freq.put(" al", 350);
    freq.put(" am", 20);
    freq.put(" an", 221);
    freq.put(" ap", 20);
    freq.put(" ar", 60);
    freq.put(" as", 29);
    freq.put(" at", 455);
    freq.put(" au", 20);
    freq.put(" av", 555);
    freq.put(" aw", 5);
    freq.put("orø", 4);
    freq.put("kku", 35);
    freq.put("kkv", 4);
    freq.put("kks", 4);
    freq.put("kko", 6);
    freq.put("kkn", 3);
    freq.put("kki", 14);
    freq.put("kkh", 3);
    freq.put("kkj", 46);
    freq.put("kke", 1225);
    freq.put("kka", 45);
    freq.put(" a ", 27);
    freq.put("Lur", 12);
    freq.put("Luk", 6);
    freq.put("or ", 880);
    freq.put("Ken", 3);
    freq.put("Ap ", 9);
    freq.put("RT ", 54);
    freq.put("G", 296);
    freq.put("orv", 18);
    freq.put("orw", 4);
    freq.put("ort", 299);
    freq.put("oru", 11);
    freq.put("orr", 63);
    freq.put("ors", 212);
    freq.put("orp", 9);
    freq.put("orn", 42);
    freq.put("oro", 11);
    freq.put("orl", 19);
    freq.put("orm", 53);
    freq.put("ork", 27);
    freq.put("orh", 24);
    freq.put("ori", 58);
    freq.put("orf", 43);
    freq.put("org", 166);
    freq.put("ord", 258);
    freq.put("ore", 122);
    freq.put("orb", 25);
    freq.put("ora", 39);
    freq.put("App", 12);
    freq.put("vju", 12);
    freq.put("døv", 4);
    freq.put("dør", 16);
    freq.put("Før", 18);
    freq.put("Føl", 21);
    freq.put("døm", 8);
    freq.put("lau", 10);
    freq.put("døg", 5);
    freq.put("død", 17);
    freq.put("Då", 10);
    freq.put("en ", 3550);
    freq.put("fei", 46);
    freq.put("dø ", 5);
    freq.put("rF ", 3);
    freq.put("Do", 19);
    freq.put("Di", 24);
    freq.put("De", 450);
    freq.put("Da", 113);
    freq.put("Dy", 4);
    freq.put("Du", 71);
    freq.put("Dr", 26);
    freq.put("iwi", 3);
    freq.put("D ", 66);
    freq.put("ge ", 361);
    freq.put("We", 14);
    freq.put("Wa", 7);
    freq.put("Wo", 12);
    freq.put("Wi", 12);
    freq.put("Wh", 6);
    freq.put("ges", 33);
    freq.put("ger", 429);
    freq.put("gep", 4);
    freq.put("jø", 375);
    freq.put("gev", 5);
    freq.put("get", 111);
    freq.put("geb", 3);
    freq.put("uta", 10);
    freq.put("ged", 4);
    freq.put("jå", 7);
    freq.put("jæ", 66);
    freq.put("gen", 560);
    freq.put("gem", 4);
    freq.put("gel", 70);
    freq.put("W ", 8);
    freq.put("æsj", 4);
    freq.put("tu ", 6);
    freq.put("j ", 32);
    freq.put("svø", 5);
    freq.put("ju", 72);
    freq.put("tur", 82);
    freq.put("tus", 20);
    freq.put("tut", 6);
    freq.put("jo", 571);
    freq.put("tul", 28);
    freq.put("ji", 11);
    freq.put("tun", 38);
    freq.put("jk", 3);
    freq.put("tua", 12);
    freq.put("tub", 6);
    freq.put("jg", 7);
    freq.put("tud", 23);
    freq.put("ja", 187);
    freq.put("dko", 3);
    freq.put("dkj", 4);
    freq.put("tum", 4);
    freq.put("je", 1834);
    freq.put("tue", 17);
    freq.put("oi ", 7);
    freq.put("pap", 23);
    freq.put("par", 100);
    freq.put("pas", 50);
    freq.put("pat", 9);
    freq.put("pau", 5);
    freq.put("pad", 5);
    freq.put("æl ", 3);
    freq.put("pak", 15);
    freq.put("pal", 4);
    freq.put("pan", 33);
    freq.put("oin", 6);
    freq.put("mån", 9);
    freq.put("oik", 5);
    freq.put("A ", 53);
    freq.put("oid", 13);
    freq.put("ois", 4);
    freq.put("oir", 3);
    freq.put("pa ", 43);
    freq.put("æle", 3);
    freq.put("nal", 65);
    freq.put("mo ", 5);
    freq.put("Sjø", 3);
    freq.put("mor", 150);
    freq.put("mov", 6);
    freq.put("mot", 102);
    freq.put("mok", 11);
    freq.put("mon", 17);
    freq.put("mom", 3);
    freq.put("mob", 22);
    freq.put("mof", 5);
    freq.put("moe", 4);
    freq.put("mod", 21);
    freq.put("Nei", 47);
    freq.put("ptu", 3);
    freq.put("New", 6);
    freq.put("Net", 15);
    freq.put("Ner", 4);
    freq.put("Nes", 12);
    freq.put("Med", 22);
    freq.put(" ch", 18);
    freq.put(" ci", 4);
    freq.put(" co", 38);
    freq.put("kma", 4);
    freq.put(" cm", 3);
    freq.put("Mel", 10);
    freq.put(" ca", 36);
    freq.put("Mei", 3);
    freq.put(" ce", 4);
    freq.put("Met", 6);
    freq.put(" cy", 3);
    freq.put("Mer", 17);
    freq.put(" cr", 8);
    freq.put(" cu", 8);
    freq.put("Dri", 9);
    freq.put("Dro", 3);
    freq.put("Dra", 8);
    freq.put("Dre", 3);
    freq.put("Sje", 15);
    freq.put("øll", 7);
    freq.put("ølk", 4);
    freq.put("Me ", 4);
    freq.put("km ", 4);
    freq.put("ølg", 61);
    freq.put("øle", 48);
    freq.put("ølv", 6);
    freq.put("ølt", 5);
    freq.put("øls", 3);
    freq.put("yyy", 5);
    freq.put("Av ", 5);
    freq.put("vh ", 8);
    freq.put("dvo", 3);
    freq.put("RR ", 3);
    freq.put("e", 35367);
    freq.put("Af", 18);
    freq.put("Avi", 10);
    freq.put("vhe", 4);
    freq.put("Ave", 3);
    freq.put("dva", 4);
    freq.put("nt ", 271);
    freq.put("sva", 72);
    freq.put("Ove", 13);
    freq.put("Vi ", 62);
    freq.put("u", 4012);
    freq.put("Van", 5);
    freq.put("Val", 9);
    freq.put("Var", 18);
    freq.put("hy ", 3);
    freq.put("ws ", 5);
    freq.put("DJ ", 3);
    freq.put("ium", 3);
    freq.put("aja", 8);
    freq.put("hyg", 15);
    freq.put("hyl", 9);
    freq.put("hym", 3);
    freq.put("hyt", 4);
    freq.put("gg ", 68);
    freq.put("aba", 5);
    freq.put("abb", 3);
    freq.put("gl", 179);
    freq.put("abe", 8);
    freq.put("abi", 13);
    freq.put("abl", 10);
    freq.put("abo", 10);
    freq.put("abr", 11);
    freq.put("abs", 6);
    freq.put("aby", 4);
    freq.put("ggu", 4);
    freq.put("lkn", 4);
    freq.put("ggs", 3);
    freq.put("ggr", 4);
    freq.put("K", 390);
    freq.put("gge", 155);
    freq.put("gga", 9);
    freq.put("ggi", 20);
    freq.put("ggj", 9);
    freq.put("ab ", 5);
    freq.put("Tjo", 4);
    freq.put("twe", 42);
    freq.put("twi", 59);
    freq.put("de ", 859);
    freq.put("ey ", 19);
    freq.put("tw ", 3);
    freq.put("dep", 11);
    freq.put("der", 540);
    freq.put("des", 57);
    freq.put("det", 1212);
    freq.put("dei", 20);
    freq.put("dej", 3);
    freq.put("dek", 10);
    freq.put("del", 170);
    freq.put("dem", 52);
    freq.put("den", 548);
    freq.put("deo", 16);
    freq.put("dea", 7);
    freq.put("deb", 20);
    freq.put("dec", 3);
    freq.put("ded", 3);
    freq.put("dee", 5);
    freq.put("def", 16);
    freq.put("deg", 152);
    freq.put("ryn", 12);
    freq.put("ryl", 7);
    freq.put("iPa", 5);
    freq.put("ryk", 49);
    freq.put("ryg", 13);
    freq.put("ryd", 14);
    freq.put("ryt", 19);
    freq.put("ryr", 6);
    freq.put("rys", 11);
    freq.put("Tyr", 3);
    freq.put("Tys", 3);
    freq.put("Dok", 3);
    freq.put("ry ", 21);
    freq.put("g ", 4785);
    freq.put("ok ", 165);
    freq.put("Bat", 3);
    freq.put("okr", 7);
    freq.put("oku", 18);
    freq.put("okt", 12);
    freq.put("oka", 31);
    freq.put(" òg", 3);
    freq.put("okb", 4);
    freq.put("oke", 23);
    freq.put("oki", 5);
    freq.put("okk", 45);
    freq.put("okm", 3);
    freq.put("Bak", 3);
    freq.put("oko", 28);
    freq.put("pc ", 7);
    freq.put("fa ", 7);
    freq.put("mm ", 19);
    freq.put("E ", 52);
    freq.put("bær", 7);
    freq.put("sbr", 5);
    freq.put("mmy", 4);
    freq.put("sbu", 4);
    freq.put("mmu", 33);
    freq.put("mmm", 9);
    freq.put("sba", 13);
    freq.put("mmi", 5);
    freq.put("sbe", 10);
    freq.put("mme", 548);
    freq.put("Uni", 8);
    freq.put("sbi", 7);
    freq.put("mma", 31);
    freq.put("sbo", 4);
    freq.put("Unn", 4);
    freq.put("Em", 3);
    freq.put("El", 45);
    freq.put("Om ", 17);
    freq.put("Ei", 14);
    freq.put("Eh", 3);
    freq.put("Ek", 8);
    freq.put("Eg", 16);
    freq.put("Ex", 3);
    freq.put("Eu", 5);
    freq.put("Et", 30);
    freq.put("Ev", 8);
    freq.put("Ep", 5);
    freq.put("Es", 4);
    freq.put("Er", 98);
    freq.put(" el", 184);
    freq.put(" em", 11);
    freq.put(" en", 865);
    freq.put(" eh", 5);
    freq.put(" ei", 53);
    freq.put(" ej", 6);
    freq.put(" ek", 49);
    freq.put(" ed", 3);
    freq.put(" ef", 10);
    freq.put(" eg", 124);
    freq.put("koe", 3);
    freq.put("kod", 10);
    freq.put("kog", 10);
    freq.put("kof", 3);
    freq.put(" ex", 3);
    freq.put("ze", 15);
    freq.put(" et", 335);
    freq.put(" eu", 5);
    freq.put("kos", 58);
    freq.put("kor", 63);
    freq.put(" ep", 21);
    freq.put("kot", 11);
    freq.put(" er", 1236);
    freq.put("Slu", 5);
    freq.put("Slo", 4);
    freq.put("Sli", 6);
    freq.put("Sle", 4);
    freq.put("Sla", 3);
    freq.put("øns", 30);
    freq.put("b", 3042);
    freq.put("ønt", 20);
    freq.put("kå", 14);
    freq.put("ko ", 14);
    freq.put(" e ", 40);
    freq.put("ååh", 4);
    freq.put("kø", 21);
    freq.put("ønl", 4);
    freq.put("ønn", 59);
    freq.put("At ", 15);
    freq.put("vn ", 22);
    freq.put("rru", 5);
    freq.put("k ", 1170);
    freq.put("Kir", 4);
    freq.put("Kin", 7);
    freq.put("Kim", 3);
    freq.put("vne", 55);
    freq.put("vna", 5);
    freq.put("Atl", 3);
    freq.put("RP ", 4);
    freq.put("vnt", 8);
    freq.put("kb", 8);
    freq.put("ka", 1099);
    freq.put("kg", 8);
    freq.put("kf", 6);
    freq.put("ke", 2469);
    freq.put("kd", 6);
    freq.put("kk", 1757);
    freq.put("kj", 531);
    freq.put("ki", 178);
    freq.put("kh", 18);
    freq.put("ko", 779);
    freq.put("kn", 105);
    freq.put("km", 11);
    freq.put("kl", 320);
    freq.put("ks", 255);
    freq.put("kr", 282);
    freq.put("kp", 7);
    freq.put("kv", 156);
    freq.put("ku", 330);
    freq.put("kt", 581);
    freq.put("ååå", 6);
    freq.put("ky", 54);
    freq.put(" Bå", 9);
    freq.put(" Bø", 7);
    freq.put("£", 4);
    freq.put("Opp", 23);
    freq.put("Ops", 3);
    freq.put("Ope", 3);
    freq.put("ré ", 8);
    freq.put(" Be", 62);
    freq.put(" Ba", 50);
    freq.put(" Bl", 74);
    freq.put(" Bo", 60);
    freq.put(" Bi", 30);
    freq.put(" Bj", 10);
    freq.put(" Bu", 19);
    freq.put("ik ", 75);
    freq.put(" Br", 64);
    freq.put(" By", 10);
    freq.put("iks", 48);
    freq.put("ikr", 14);
    freq.put(" B ", 12);
    freq.put("iku", 5);
    freq.put("ikt", 107);
    freq.put("ika", 43);
    freq.put("ike", 198);
    freq.put("kte", 154);
    freq.put("ikk", 1121);
    freq.put("ikj", 5);
    freq.put("iki", 9);
    freq.put("ikh", 4);
    freq.put("iko", 18);
    freq.put("ikn", 3);
    freq.put("ikl", 17);
    freq.put("Yes", 3);
    freq.put("lbr", 9);
    freq.put("lbu", 11);
    freq.put("ga ", 86);
    freq.put("ND ", 4);
    freq.put("ran", 169);
    freq.put("gav", 22);
    freq.put("gat", 26);
    freq.put("gas", 28);
    freq.put("gar", 31);
    freq.put("gan", 153);
    freq.put("gam", 37);
    freq.put("gal", 19);
    freq.put("gae", 3);
    freq.put("lba", 46);
    freq.put("fus", 5);
    freq.put("fug", 5);
    freq.put("fuc", 10);
    freq.put("fun", 56);
    freq.put("lbe", 8);
    freq.put("ful", 34);
    freq.put("fuk", 4);
    freq.put("sy ", 5);
    freq.put("iør", 3);
    freq.put("iøs", 15);
    freq.put("dge", 6);
    freq.put("syk", 56);
    freq.put("dgi", 3);
    freq.put("OW ", 3);
    freq.put("sym", 7);
    freq.put("syl", 3);
    freq.put("dgr", 3);
    freq.put("syr", 3);
    freq.put("ew ", 8);
    freq.put("ahl", 3);
    freq.put("y", 1870);
    freq.put("lda", 10);
    freq.put("lde", 174);
    freq.put("ldi", 107);
    freq.put("ldn", 6);
    freq.put("bi ", 7);
    freq.put("lds", 14);
    freq.put("ldr", 73);
    freq.put("ldt", 34);
    freq.put("rgr", 7);
    freq.put("rgu", 4);
    freq.put("cup", 5);
    freq.put("rga", 12);
    freq.put("rge", 183);
    freq.put("rgi", 14);
    freq.put("rgo", 5);
    freq.put("bin", 18);
    freq.put("bil", 142);
    freq.put("ld ", 128);
    freq.put("bid", 13);
    freq.put("Dig", 7);
    freq.put("bib", 10);
    freq.put("bia", 9);
    freq.put("apt", 18);
    freq.put("Dit", 3);
    freq.put("bit", 17);
    freq.put("bis", 9);
    freq.put("Dis", 5);
    freq.put("rg ", 33);
    freq.put("oe ", 123);
    freq.put("pet", 53);
    freq.put("pep", 6);
    freq.put("per", 226);
    freq.put("pes", 36);
    freq.put("pel", 25);
    freq.put("pen", 180);
    freq.put("pei", 10);
    freq.put("pek", 25);
    freq.put("ped", 13);
    freq.put("pef", 5);
    freq.put("peg", 3);
    freq.put("pea", 3);
    freq.put("peb", 3);
    freq.put("ufo", 6);
    freq.put("oer", 8);
    freq.put("Bor", 14);
    freq.put("fed", 3);
    freq.put("O", 307);
    freq.put("Boi", 3);
    freq.put("Bok", 7);
    freq.put("Bol", 9);
    freq.put("oen", 207);
    freq.put("Bon", 7);
    freq.put("Boa", 4);
    freq.put("uft", 20);
    freq.put("fen", 21);
    freq.put("pe ", 131);
    freq.put("Hun", 14);
    freq.put("nsi", 25);
    freq.put("nsj", 15);
    freq.put("nsk", 198);
    freq.put("nsl", 8);
    freq.put("nsm", 4);
    freq.put("nso", 11);
    freq.put("al", 1389);
    freq.put("nsa", 21);
    freq.put("nsb", 5);
    freq.put("nsd", 14);
    freq.put("nse", 181);
    freq.put("nsf", 4);
    freq.put("usj", 26);
    freq.put("nsy", 17);
    freq.put("nsp", 14);
    freq.put("nss", 9);
    freq.put("nst", 86);
    freq.put("nsu", 19);
    freq.put("nsv", 6);
    freq.put("mko", 4);
    freq.put("mkj", 4);
    freq.put(" gø", 19);
    freq.put(" gæ", 3);
    freq.put(" gå", 168);
    freq.put("fer", 71);
    freq.put(" R ", 4);
    freq.put("ns ", 205);
    freq.put("Flu", 3);
    freq.put("sdy", 3);
    freq.put("Fli", 5);
    freq.put("sda", 59);
    freq.put("Flo", 12);
    freq.put("Fla", 6);
    freq.put("Fle", 8);
    freq.put("sdi", 5);
    freq.put("lyt", 29);
    freq.put("lyp", 5);
    freq.put("lyr", 3);
    freq.put("lys", 61);
    freq.put("Nys", 4);
    freq.put("Hve", 17);
    freq.put("Nyt", 15);
    freq.put("lyd", 15);
    freq.put("lye", 6);
    freq.put("Nyh", 8);
    freq.put("Nyd", 6);
    freq.put("Nye", 4);
    freq.put("Mas", 8);
    freq.put(" gu", 53);
    freq.put(" gr", 178);
    freq.put("Mat", 9);
    freq.put("Sna", 7);
    freq.put("Max", 3);
    freq.put(" gy", 6);
    freq.put("fåt", 45);
    freq.put(" ge", 23);
    freq.put("får", 114);
    freq.put("Mad", 4);
    freq.put("Mag", 6);
    freq.put(" ga", 188);
    freq.put(" gn", 3);
    freq.put(" go", 175);
    freq.put(" gl", 104);
    freq.put(" gj", 264);
    freq.put(" gi", 116);
    freq.put("Meg", 4);
    freq.put("ly ", 22);
    freq.put("Ny ", 15);
    freq.put("Flå", 3);
    freq.put("få ", 82);
    freq.put(" g ", 3);
    freq.put(" b", 1830);
    freq.put(" c", 126);
    freq.put(" a", 1862);
    freq.put(" f", 2905);
    freq.put(" g", 1307);
    freq.put(" d", 3559);
    freq.put(" e", 2982);
    freq.put(" j", 1409);
    freq.put(" k", 1810);
    freq.put(" h", 2652);
    freq.put(" i", 2802);
    freq.put(" n", 1446);
    freq.put(" o", 2129);
    freq.put(" l", 1337);
    freq.put(" m", 3124);
    freq.put(" r", 612);
    freq.put(" s", 5003);
    freq.put(" p", 2289);
    freq.put(" q", 3);
    freq.put(" v", 1859);
    freq.put(" w", 49);
    freq.put(" t", 2420);
    freq.put(" u", 658);
    freq.put(" x", 21);
    freq.put(" y", 39);
    freq.put(" B", 428);
    freq.put(" C", 144);
    freq.put(" A", 373);
    freq.put(" F", 522);
    freq.put(" G", 295);
    freq.put(" D", 853);
    freq.put(" E", 362);
    freq.put(" J", 525);
    freq.put(" K", 386);
    freq.put(" H", 858);
    freq.put(" I", 289);
    freq.put(" N", 516);
    freq.put(" O", 303);
    freq.put(" L", 331);
    freq.put(" M", 532);
    freq.put(" R", 252);
    freq.put(" S", 1026);
    freq.put(" P", 307);
    freq.put(" Q", 9);
    freq.put(" V", 346);
    freq.put(" W", 61);
    freq.put(" T", 543);
    freq.put(" U", 110);
    freq.put(" Z", 4);
    freq.put(" X", 14);
    freq.put(" Y", 32);
    freq.put("vli", 20);
    freq.put("vla", 13);
    freq.put("vle", 5);
    freq.put(" æ", 26);
    freq.put(" å", 1121);
    freq.put(" é", 6);
    freq.put(" ò", 3);
    freq.put("æææ", 14);
    freq.put(" ø", 108);
    freq.put(" Æ", 6);
    freq.put(" Å", 50);
    freq.put("fat", 11);
    freq.put(" Ø", 37);
    freq.put(" £", 4);
    freq.put("ock", 12);
    freq.put("nær", 23);
    freq.put(" Do", 18);
    freq.put("Vet", 12);
    freq.put("Ver", 9);
    freq.put("Ves", 6);
    freq.put(" Di", 24);
    freq.put(" De", 449);
    freq.put(" Da", 112);
    freq.put("Veg", 8);
    freq.put("ii ", 4);
    freq.put(" Dy", 4);
    freq.put("Ven", 18);
    freq.put("Vel", 33);
    freq.put(" Dr", 26);
    freq.put("Vei", 3);

    init3();
  }
  private static void init3() {
    
    freq.put("cha", 13);
    freq.put("Fr", 82);
    freq.put("che", 15);
    freq.put("Fv", 6);
    freq.put("chi", 11);
    freq.put("cho", 3);
    freq.put("Fa", 64);
    freq.put("JE ", 3);
    freq.put("Fe", 27);
    freq.put("Fi", 61);
    freq.put("Fj", 6);
    freq.put("Fl", 39);
    freq.put("Fo", 108);
    freq.put(" D ", 43);
    freq.put("iid", 3);
    freq.put("iin", 5);
    freq.put("iii", 12);
    freq.put("ch ", 18);
    freq.put("f", 4071);
    freq.put("F ", 18);
    freq.put("jg ", 5);
    freq.put(" Då", 10);
    freq.put("Øns", 4);
    freq.put("afl", 3);
    freq.put("afo", 3);
    freq.put("afi", 21);
    freq.put("Yo", 11);
    freq.put("Fø", 40);
    freq.put("afe", 9);
    freq.put("aff", 54);
    freq.put("Ye", 6);
    freq.put("afa", 3);
    freq.put("Få", 28);
    freq.put("aft", 15);
    freq.put("Y ", 3);
    freq.put("af ", 4);
    freq.put("fem", 14);
    freq.put("da ", 271);
    freq.put("bje", 5);
    freq.put("lf", 41);
    freq.put("tso", 8);
    freq.put("tsl", 5);
    freq.put("tsm", 5);
    freq.put("lb", 91);
    freq.put("tsk", 21);
    freq.put("tsh", 3);
    freq.put("tsi", 12);
    freq.put("tsf", 3);
    freq.put("eud", 3);
    freq.put("ll", 1328);
    freq.put("tse", 55);
    freq.put("tsb", 6);
    freq.put("lk", 226);
    freq.put("lh", 16);
    freq.put("tsa", 39);
    freq.put("lv", 199);
    freq.put("lt", 566);
    freq.put("lu", 185);
    freq.put("lr", 6);
    freq.put("ls", 319);
    freq.put("lp", 51);
    freq.put("tsv", 4);
    freq.put("eut", 5);
    freq.put("tst", 17);
    freq.put("tsr", 5);
    freq.put("tss", 6);
    freq.put("tsp", 15);
    freq.put("eur", 7);
    freq.put("dae", 4);
    freq.put("daf", 6);
    freq.put("dag", 435);
    freq.put("daa", 7);
    freq.put("åkn", 11);
    freq.put("dal", 34);
    freq.put("dam", 35);
    freq.put("dan", 70);
    freq.put("dak", 5);
    freq.put("dat", 36);
    freq.put("dar", 11);
    freq.put("das", 6);
    freq.put("day", 6);
    freq.put("åkj", 3);
    freq.put("l ", 2074);
    freq.put("ts ", 79);
    freq.put("uhe", 3);
    freq.put("ås ", 10);
    freq.put("emo", 34);
    freq.put("lfe", 7);
    freq.put("lfa", 6);
    freq.put("lfo", 7);
    freq.put("lfr", 10);
    freq.put("læ", 44);
    freq.put("lå", 74);
    freq.put("rer", 292);
    freq.put("res", 244);
    freq.put("rep", 41);
    freq.put("Tus", 10);
    freq.put("rev", 52);
    freq.put("ret", 172);
    freq.put("reu", 3);
    freq.put("rek", 110);
    freq.put("reh", 4);
    freq.put("rei", 90);
    freq.put("ren", 301);
    freq.put("reo", 3);
    freq.put("rel", 67);
    freq.put("rem", 87);
    freq.put("reb", 10);
    freq.put("rec", 4);
    freq.put("rea", 32);
    freq.put("ref", 28);
    freq.put("reg", 102);
    freq.put("red", 118);
    freq.put("ree", 17);
    freq.put("lf ", 5);
    freq.put("que", 3);
    freq.put("qui", 8);
    freq.put("hes", 9);
    freq.put("òg ", 3);
    freq.put("re ", 1155);
    freq.put("pga", 31);
    freq.put("ud ", 42);
    freq.put("pgr", 4);
    freq.put("og ", 1026);
    freq.put("uds", 8);
    freq.put("sfø", 3);
    freq.put("nur", 4);
    freq.put("ogs", 108);
    freq.put("ogr", 26);
    freq.put("ogl", 9);
    freq.put("ogo", 3);
    freq.put("ogn", 12);
    freq.put("ogi", 18);
    freq.put("ogh", 6);
    freq.put("udd", 16);
    freq.put("ude", 28);
    freq.put("oge", 27);
    freq.put("ogg", 57);
    freq.put("udi", 9);
    freq.put("ogb", 3);
    freq.put("Pen", 4);
    freq.put("rün", 5);
    freq.put("Pap", 4);
    freq.put("Par", 21);
    freq.put("Pas", 3);
    freq.put("Pau", 3);
    freq.put("Pad", 6);
    freq.put("Pal", 3);
    freq.put("Pan", 3);
    freq.put("mik", 4);
    freq.put("mil", 52);
    freq.put("min", 225);
    freq.put("mie", 10);
    freq.put("mid", 32);
    freq.put("mis", 39);
    freq.put("mit", 54);
    freq.put("sfu", 3);
    freq.put("sfr", 3);
    freq.put("sfo", 12);
    freq.put("sfi", 4);
    freq.put("sfe", 10);
    freq.put("sfa", 3);
    freq.put("mi ", 16);
    freq.put(" iP", 12);
    freq.put(" iO", 3);
    freq.put("ksu", 6);
    freq.put("kst", 41);
    freq.put("ksp", 13);
    freq.put("kss", 8);
    freq.put("ksr", 4);
    freq.put(" ip", 3);
    freq.put("Mor", 17);
    freq.put(" ir", 14);
    freq.put(" is", 37);
    freq.put(" it", 8);
    freq.put(" iv", 3);
    freq.put("Mot", 5);
    freq.put(" ih", 8);
    freq.put("ksd", 3);
    freq.put(" ik", 784);
    freq.put(" il", 9);
    freq.put(" im", 24);
    freq.put(" in", 348);
    freq.put("Mol", 11);
    freq.put("ksm", 3);
    freq.put(" ia", 8);
    freq.put(" ib", 3);
    freq.put(" id", 50);
    freq.put(" if", 4);
    freq.put(" ig", 93);
    freq.put("øbl", 3);
    freq.put("ks ", 45);
    freq.put("øbe", 3);
    freq.put("wa", 20);
    freq.put("wo", 11);
    freq.put("då", 41);
    freq.put("S", 1027);
    freq.put("wi", 103);
    freq.put("vre", 4);
    freq.put("vri", 7);
    freq.put("è", 5);
    freq.put("dø", 62);
    freq.put(" Fø", 40);
    freq.put("ohn", 6);
    freq.put("ab", 79);
    freq.put(" Få", 28);
    freq.put("ånd", 29);
    freq.put("åne", 23);
    freq.put("ång", 4);
    freq.put("ys ", 15);
    freq.put("ånn", 48);
    freq.put("ånt", 14);
    freq.put("ak", 702);
    freq.put("emå", 4);
    freq.put("Nå", 95);
    freq.put("cor", 14);
    freq.put("fød", 5);
    freq.put("cou", 3);
    freq.put("ån ", 6);
    freq.put("ysi", 3);
    freq.put("ysn", 5);
    freq.put("cov", 3);
    freq.put("ysg", 5);
    freq.put("uis", 6);
    freq.put("yse", 18);
    freq.put("yss", 8);
    freq.put("Hor", 7);
    freq.put("ysp", 3);
    freq.put("Hos", 7);
    freq.put(" Fr", 82);
    freq.put(" Fu", 14);
    freq.put("Hop", 7);
    freq.put(" Fv", 6);
    freq.put(" Fy", 11);
    freq.put(" Fa", 64);
    freq.put(" Fe", 27);
    freq.put(" Fi", 61);
    freq.put(" Fj", 6);
    freq.put(" Fl", 38);
    freq.put(" Fo", 108);
    freq.put("io ", 24);
    freq.put("uiz", 5);
    freq.put("coc", 3);
    freq.put("ng", 1462);
    freq.put("iou", 3);
    freq.put("iot", 14);
    freq.put("ios", 4);
    freq.put("ior", 9);
    freq.put("ion", 42);
    freq.put("iol", 4);
    freq.put("ioe", 3);
    freq.put("iod", 4);
    freq.put("col", 7);
    freq.put("fy ", 3);
    freq.put("adv", 6);
    freq.put("adr", 6);
    freq.put("ads", 5);
    freq.put("gma", 3);
    freq.put("esø", 24);
    freq.put("add", 136);
    freq.put("ade", 84);
    freq.put("ada", 19);
    freq.put("adn", 3);
    freq.put("adl", 6);
    freq.put("adi", 40);
    freq.put("fyl", 27);
    freq.put("fym", 4);
    freq.put("fyr", 6);
    freq.put("ad ", 93);
    freq.put("nja", 8);
    freq.put("nje", 10);
    freq.put("esv", 13);
    freq.put("esu", 36);
    freq.put("est", 498);
    freq.put("ess", 133);
    freq.put("esp", 26);
    freq.put("esy", 3);
    freq.put("tma", 3);
    freq.put("ese", 101);
    freq.put("esc", 4);
    freq.put("tme", 5);
    freq.put("esa", 17);
    freq.put("eso", 30);
    freq.put("esn", 8);
    freq.put("esm", 3);
    freq.put("esl", 9);
    freq.put("esk", 73);
    freq.put("esj", 3);
    freq.put("esi", 40);
    freq.put("tmo", 4);
    freq.put("dco", 3);
    freq.put("avl", 6);
    freq.put("OS ", 5);
    freq.put("es ", 351);
    freq.put("Twe", 4);
    freq.put("Twi", 30);
    freq.put("De ", 46);
    freq.put("rce", 6);
    freq.put("jøl", 26);
    freq.put("bur", 47);
    freq.put("bus", 37);
    freq.put("Der", 30);
    freq.put("Des", 11);
    freq.put("Det", 286);
    freq.put("but", 14);
    freq.put("buk", 10);
    freq.put("bui", 3);
    freq.put("bun", 11);
    freq.put("Dem", 6);
    freq.put("bul", 5);
    freq.put("bum", 5);
    freq.put("Dea", 3);
    freq.put("Deb", 4);
    freq.put("bud", 15);
    freq.put("Iva", 3);
    freq.put("j", 3178);
    freq.put("pik", 7);
    freq.put("pil", 119);
    freq.put("Ryk", 5);
    freq.put("pin", 25);
    freq.put("pic", 3);
    freq.put("pie", 10);
    freq.put("pig", 4);
    freq.put("piz", 6);
    freq.put("ub ", 5);
    freq.put("pir", 19);
    freq.put("pis", 60);
    freq.put("pit", 5);
    freq.put(" øk", 21);
    freq.put(" øn", 22);
    freq.put(" øl", 11);
    freq.put("oak", 4);
    freq.put(" ød", 7);
    freq.put(" øy", 17);
    freq.put("oas", 3);
    freq.put(" øs", 4);
    freq.put(" ør", 11);
    freq.put(" øv", 9);
    freq.put("ubs", 3);
    freq.put("pi ", 5);
    freq.put("ube", 9);
    freq.put("ubb", 10);
    freq.put("ubl", 10);
    freq.put("ubi", 3);
    freq.put("oa ", 9);
    freq.put(" kå", 5);
    freq.put(" kø", 18);
    freq.put("øft", 9);
    freq.put("Oke", 3);
    freq.put("G ", 58);
    freq.put("Gu", 23);
    freq.put("Gr", 50);
    freq.put("Ok ", 5);
    freq.put("Ge", 16);
    freq.put("Ga", 41);
    freq.put("Go", 47);
    freq.put("Gl", 37);
    freq.put("Gj", 22);
    freq.put("Gi", 19);
    freq.put(" ka", 435);
    freq.put(" ke", 4);
    freq.put(" kj", 220);
    freq.put(" ki", 37);
    freq.put(" kn", 36);
    freq.put(" ko", 507);
    freq.put(" kl", 211);
    freq.put(" km", 4);
    freq.put(" kr", 78);
    freq.put(" kv", 118);
    freq.put(" ku", 123);
    freq.put(" ky", 3);
    freq.put("mnd", 10);
    freq.put("kut", 21);
    freq.put("kus", 21);
    freq.put("kur", 60);
    freq.put("Mmm", 3);
    freq.put("kun", 76);
    freq.put("kum", 17);
    freq.put("gna", 11);
    freq.put("kuf", 8);
    freq.put("kue", 5);
    freq.put("kud", 4);
    freq.put(" k ", 3);
    freq.put("ødd", 10);
    freq.put("ødv", 9);
    freq.put("ødt", 11);
    freq.put("øds", 7);
    freq.put("ødr", 6);
    freq.put("TT ", 6);
    freq.put("ty", 141);
    freq.put("Gø", 5);
    freq.put("Gå", 9);
    freq.put("ku ", 5);
    freq.put("Kom", 29);
    freq.put("Kol", 3);
    freq.put("Kon", 18);
    freq.put("ts", 331);
    freq.put("Kos", 8);
    freq.put("Kor", 6);
    freq.put("m ", 1690);
    freq.put("tm", 17);
    freq.put("vpa", 6);
    freq.put("me", 2581);
    freq.put("md", 10);
    freq.put("mg", 19);
    freq.put("mf", 28);
    freq.put("ma", 612);
    freq.put("ltu", 16);
    freq.put("mb", 66);
    freq.put("mm", 652);
    freq.put("ml", 55);
    freq.put("mo", 355);
    freq.put("mn", 38);
    freq.put("mi", 441);
    freq.put("mh", 8);
    freq.put("mk", 15);
    freq.put("mu", 147);
    freq.put("mt", 108);
    freq.put("mv", 9);
    freq.put("mp", 189);
    freq.put("ms", 102);
    freq.put("mr", 23);
    freq.put("ta", 1001);
    freq.put("my", 136);
    freq.put("ena", 21);
    freq.put("enb", 19);
    freq.put("åli", 3);
    freq.put("end", 291);
    freq.put("ene", 455);
    freq.put("enf", 20);
    freq.put("eng", 272);
    freq.put("enh", 17);
    freq.put("eni", 75);
    freq.put("enk", 108);
    freq.put("enl", 6);
    freq.put("enn", 367);
    freq.put("åle", 42);
    freq.put("enp", 6);
    freq.put("enr", 7);
    freq.put("ens", 234);
    freq.put("ent", 399);
    freq.put("env", 5);
    freq.put("eny", 8);
    freq.put("Hel", 42);
    freq.put("må", 260);
    freq.put("mæ", 5);
    freq.put("ål ", 33);
    freq.put("ü", 9);
    freq.put("mø", 51);
    freq.put(" Hy", 5);
    freq.put("må ", 144);
    freq.put(" Hv", 151);
    freq.put(" Hu", 56);
    freq.put(" Hj", 14);
    freq.put(" Hi", 21);
    freq.put(" Ho", 50);
    freq.put(" Hm", 14);
    freq.put(" Ha", 272);
    freq.put(" He", 144);
    freq.put("ima", 14);
    freq.put("ime", 84);
    freq.put("imi", 5);
    freq.put("imm", 21);
    freq.put("imo", 17);
    freq.put("imp", 13);
    freq.put("ims", 6);
    freq.put("imr", 4);
    freq.put("imt", 3);
    freq.put("JA ", 5);
    freq.put("mål", 56);
    freq.put("SA ", 10);
    freq.put("måt", 38);
    freq.put("mås", 3);
    freq.put("mår", 3);
    freq.put(" H ", 9);
    freq.put("im ", 38);
    freq.put(" Hø", 43);
    freq.put(" Hæ", 3);
    freq.put(" Hå", 37);
    freq.put("gom", 5);
    freq.put("gol", 4);
    freq.put("goo", 8);
    freq.put("gon", 13);
    freq.put("god", 156);
    freq.put("got", 7);
    freq.put("gov", 3);
    freq.put("gos", 3);
    freq.put("gor", 4);
    freq.put("W", 62);
    freq.put("Vid", 3);
    freq.put("Vik", 11);
    freq.put("Vin", 9);
    freq.put("go ", 16);
    freq.put("Vil", 41);
    freq.put("Vir", 3);
    freq.put("Vis", 5);
    freq.put(" Sp", 54);
    freq.put("nhe", 19);
    freq.put("nha", 4);
    freq.put("nho", 6);
    freq.put("tor", 147);
    freq.put("tos", 7);
    freq.put("top", 80);
    freq.put("tov", 5);
    freq.put("tot", 7);
    freq.put("tou", 5);
    freq.put("tok", 22);
    freq.put("ton", 24);
    freq.put("tol", 36);
    freq.put("tom", 24);
    freq.put("tob", 10);
    freq.put("tof", 6);
    freq.put("tog", 27);
    freq.put("tod", 11);
    freq.put("toe", 3);
    freq.put("Fun", 6);
    freq.put("Ful", 4);
    freq.put("to ", 84);
    freq.put("ept", 30);
    freq.put("raf", 50);
    freq.put("rag", 19);
    freq.put("rad", 40);
    freq.put("rae", 13);
    freq.put("rab", 5);
    freq.put("rac", 6);
    freq.put("raa", 3);
    freq.put("lby", 4);
    freq.put("epr", 20);
    freq.put("ral", 21);
    freq.put("ram", 80);
    freq.put("rak", 54);
    freq.put("rah", 6);
    freq.put("rai", 5);
    freq.put("rav", 28);
    freq.put("rat", 110);
    freq.put("rar", 42);
    freq.put("ras", 54);
    freq.put("rap", 36);
    freq.put("lbi", 7);
    freq.put("bs ", 8);
    freq.put("lbo", 3);
    freq.put("Syk", 11);
    freq.put("Syn", 36);
    freq.put("ra ", 426);
    freq.put("bst", 3);
    freq.put("møt", 23);
    freq.put("mør", 14);
    freq.put("møl", 3);
    freq.put("bso", 13);
    freq.put("bsi", 3);
    freq.put("bse", 4);
    freq.put("mød", 3);
    freq.put("møb", 3);
    freq.put("up", 78);
    freq.put("R", 252);
    freq.put("ét", 4);
    freq.put("cyk", 3);
    freq.put("én", 6);
    freq.put("Bil", 9);
    freq.put("oca", 3);
    freq.put("Bie", 3);
    freq.put("Bib", 3);
    freq.put("òg", 3);
    freq.put("Bir", 8);
    freq.put("ømt", 8);
    freq.put("é ", 14);
    freq.put("Pet", 7);
    freq.put("nut", 27);
    freq.put("Pep", 6);
    freq.put("nus", 23);
    freq.put("Per", 8);
    freq.put("Pel", 3);
    freq.put("nul", 5);
    freq.put("num", 6);
    freq.put("nuf", 7);
    freq.put("mus", 49);
    freq.put("mul", 44);
    freq.put("mun", 43);
    freq.put("Hø", 43);
    freq.put("nu ", 6);
    freq.put(" me", 1645);
    freq.put(" ma", 375);
    freq.put(" mm", 5);
    freq.put(" mn", 11);
    freq.put(" mo", 259);
    freq.put(" mi", 333);
    freq.put(" mk", 3);
    freq.put(" mu", 78);
    freq.put(" my", 124);
    freq.put(" m ", 37);
    freq.put("øff", 7);
    freq.put("Cre", 3);
    freq.put("TV ", 25);
    freq.put("elv", 140);
    freq.put("n", 16177);
    freq.put("elu", 4);
    freq.put(" må", 203);
    freq.put(" mæ", 5);
    freq.put(" mø", 35);
    freq.put("Tro", 73);
    freq.put("vvv", 4);
    freq.put(" Sø", 23);
    freq.put("vvi", 3);
    freq.put("vva", 4);
    freq.put(" Jø", 4);
    freq.put("elk", 26);
    freq.put("elh", 3);
    freq.put("eli", 278);
    freq.put("elo", 13);
    freq.put("ell", 323);
    freq.put("elm", 6);
    freq.put("elb", 10);
    freq.put("ela", 44);
    freq.put("elf", 8);
    freq.put("elg", 81);
    freq.put("eld", 261);
    freq.put("ele", 183);
    freq.put("ely", 3);
    freq.put("els", 196);
    freq.put("elp", 39);
    freq.put("Hæ", 3);
    freq.put("elt", 182);
    freq.put("Hå", 37);
    freq.put("D", 867);
    freq.put("ævv", 4);
    freq.put("Lys", 6);
    freq.put("el ", 258);
    freq.put("nøy", 25);
    freq.put("Lyd", 5);
    freq.put("nød", 12);
    freq.put("Lyn", 3);
    freq.put(" Ju", 18);
    freq.put(" Jo", 62);
    freq.put(" Je", 316);
    freq.put(" Ja", 103);
    freq.put("ick", 10);
    freq.put("Hy", 5);
    freq.put("vår", 26);
    freq.put("ica", 8);
    freq.put("Hv", 151);
    freq.put("ice", 16);
    freq.put("Hu", 56);
    freq.put("Hj", 14);
    freq.put("elø", 15);
    freq.put("Hi", 21);
    freq.put("Ho", 51);
    freq.put("Hm", 14);
    freq.put("vål", 3);
    freq.put("Ha", 272);
    freq.put("våk", 11);
    freq.put("He", 144);
    freq.put("ic ", 12);
    freq.put("vå ", 3);
    freq.put("H ", 19);
    freq.put("ppb", 4);
    freq.put("ppa", 32);
    freq.put("aha", 97);
    freq.put("ppg", 14);
    freq.put("ppf", 12);
    freq.put("ppe", 148);
    freq.put("ppd", 23);
    freq.put("ppk", 3);
    freq.put("ppi", 16);
    freq.put("pph", 3);
    freq.put("ppo", 15);
    freq.put("ppm", 6);
    freq.put("ppl", 56);
    freq.put("pps", 28);
    freq.put("ppr", 13);
    freq.put("ppv", 7);
    freq.put("ppt", 22);
    freq.put("ppy", 3);
    freq.put("giv", 12);
    freq.put("git", 29);
    freq.put("gis", 28);
    freq.put("gir", 25);
    freq.put("nå", 367);
    freq.put("næ", 23);
    freq.put("gig", 5);
    freq.put("gif", 10);
    freq.put("gie", 4);
    freq.put("gid", 12);
    freq.put("gia", 4);
    freq.put("gio", 8);
    freq.put("gin", 21);
    freq.put("gim", 3);
    freq.put("gik", 34);
    freq.put("Hvi", 26);
    freq.put("ah ", 15);
    freq.put("pp ", 216);
    freq.put("Vol", 7);
    freq.put("Hva", 67);
    freq.put("gi ", 32);
    freq.put("nno", 58);
    freq.put("nnm", 3);
    freq.put("nnl", 37);
    freq.put("nnk", 4);
    freq.put("nni", 36);
    freq.put("nnh", 11);
    freq.put("nng", 7);
    freq.put("nnf", 15);
    freq.put("nne", 606);
    freq.put("nnb", 8);
    freq.put("nna", 43);
    freq.put("nny", 12);
    freq.put("nnv", 9);
    freq.put("nnu", 4);
    freq.put("nnt", 10);
    freq.put("nns", 70);
    freq.put("nnr", 7);
    freq.put("nnp", 4);
    freq.put("nh", 30);
    freq.put("ni", 409);
    freq.put("nj", 21);
    freq.put("nk", 275);
    freq.put("nl", 109);
    freq.put("nm", 30);
    freq.put("nn", 1325);
    freq.put("no", 601);
    freq.put("tit", 19);
    freq.put("na", 473);
    freq.put("nb", 44);
    freq.put("nc", 21);
    freq.put("nd", 1038);
    freq.put("ne", 2236);
    freq.put("nf", 87);
    freq.put("giø", 4);
    freq.put("nx", 4);
    freq.put("ny", 226);
    freq.put("nz", 6);
    freq.put("tio", 17);
    freq.put("tik", 99);
    freq.put("np", 13);
    freq.put("tie", 42);
    freq.put("nr", 35);
    freq.put("ns", 855);
    freq.put("nt", 858);
    freq.put("nu", 91);
    freq.put("nv", 42);
    freq.put("Bør", 4);
    freq.put("nn ", 362);
    freq.put("ich", 6);
    freq.put("ico", 5);
    freq.put("n ", 5357);
    freq.put("Leg", 8);
    freq.put("Lei", 7);
    freq.put("ti ", 32);
    freq.put("roi", 6);
    freq.put("lly", 12);
    freq.put("rok", 13);
    freq.put("rol", 49);
    freq.put("rom", 56);
    freq.put("ron", 57);
    freq.put("lls", 20);
    freq.put("rob", 26);
    freq.put("llp", 3);
    freq.put("rod", 42);
    freq.put("roe", 3);
    freq.put("rof", 18);
    freq.put("rog", 28);
    freq.put("llk", 4);
    freq.put("lli", 69);
    freq.put("llo", 60);
    freq.put("Len", 3);
    freq.put("llm", 3);
    freq.put("rop", 37);
    freq.put("llb", 3);
    freq.put("ror", 112);
    freq.put("ros", 40);
    freq.put("rot", 23);
    freq.put("llf", 6);
    freq.put("rov", 9);
    freq.put("lld", 3);
    freq.put("Dag", 27);
    freq.put("Dam", 6);
    freq.put("Dan", 11);
    freq.put("Dat", 3);
    freq.put("Dav", 3);
    freq.put("Daw", 3);
    freq.put("ro ", 56);
    freq.put("Cit", 8);
    freq.put("hPa", 3);
    freq.put("ll ", 233);
    freq.put("Da ", 55);
    freq.put("llø", 3);
    freq.put("Res", 6);
    freq.put("Ret", 8);
    freq.put("kli", 33);
    freq.put("Rek", 3);
    freq.put("Rei", 5);
    freq.put("Ren", 3);
    freq.put("Rea", 8);
    freq.put("Reg", 12);
    freq.put("Red", 3);
    freq.put("Agd", 3);
    freq.put("pm ", 9);
    freq.put("Mil", 5);
    freq.put("kly", 4);
    freq.put("ngt", 52);
    freq.put("Min", 28);
    freq.put("msu", 5);
    freq.put("mst", 27);
    freq.put("mss", 9);
    freq.put("Ogs", 4);
    freq.put("msp", 3);
    freq.put("msn", 5);
    freq.put("msk", 10);
    freq.put("msi", 3);
    freq.put("mse", 7);
    freq.put("ial", 41);
    freq.put("Eve", 5);
    freq.put("Og ", 69);
    freq.put("ms ", 14);
    freq.put(" on", 24);
    freq.put(" ol", 7);
    freq.put(" om", 407);
    freq.put(" ok", 22);
    freq.put(" oh", 4);
    freq.put(" oi", 5);
    freq.put(" of", 22);
    freq.put(" og", 1105);
    freq.put(" od", 6);
    freq.put(" ob", 9);
    freq.put("kye", 6);
    freq.put(" ov", 132);
    freq.put(" ot", 3);
    freq.put("kyp", 4);
    freq.put(" or", 62);
    freq.put(" os", 67);
    freq.put(" op", 235);
    freq.put("kyt", 11);
    freq.put("msø", 10);
    freq.put("vøm", 4);
    freq.put("Æ", 6);
    freq.put(" o ", 10);
    freq.put("dét", 3);
    freq.put("iPh", 6);
    freq.put("Fan", 18);
    freq.put("vta", 5);
    freq.put("gte", 9);
    freq.put("ahe", 4);
    freq.put("gto", 4);
    freq.put("ly", 185);
    freq.put("nnå", 6);
    freq.put("Ks ", 3);
    freq.put("dpr", 3);
    freq.put("gt ", 112);
    freq.put("vt ", 37);
    freq.put("Typ", 7);
    freq.put("vøs", 3);
    freq.put("EN ", 12);
    freq.put("eje", 6);
    freq.put("eja", 4);
    freq.put("Båd", 4);
    freq.put("ej ", 10);
    freq.put("åh ", 8);
    freq.put("prå", 9);
    freq.put("hu ", 4);
    freq.put("prø", 56);
    freq.put("iam", 3);
    freq.put("nø", 45);
    freq.put("ian", 28);
    freq.put("iak", 3);
    freq.put("iag", 4);
    freq.put("iab", 3);
    freq.put("iat", 6);
    freq.put("ias", 8);
    freq.put("iar", 3);
    freq.put("hud", 4);
    freq.put("hua", 5);
    freq.put("hul", 5);
    freq.put("hum", 7);
    freq.put("hun", 53);
    freq.put("hur", 9);
    freq.put("hus", 50);
    freq.put(" Læ", 3);
    freq.put(" Lå", 6);
    freq.put("ia ", 74);
    freq.put("r", 19551);
    freq.put(" Lø", 11);
    freq.put("and", 354);
    freq.put("ane", 79);
    freq.put("ang", 308);
    freq.put("pra", 24);
    freq.put("ana", 50);
    freq.put("anb", 10);
    freq.put("anc", 11);
    freq.put("anl", 40);
    freq.put("anm", 20);
    freq.put("ann", 210);
    freq.put("ano", 18);
    freq.put("pri", 57);
    freq.put("ani", 33);
    freq.put("anj", 7);
    freq.put("ank", 49);
    freq.put("ant", 183);
    freq.put("anu", 6);
    freq.put("anv", 4);
    freq.put("ans", 293);
    freq.put("pry", 4);
    freq.put("any", 9);
    freq.put(" L ", 5);
    freq.put("gko", 3);
    freq.put("gka", 12);
    freq.put("an ", 705);
    freq.put("pr ", 4);
    freq.put(" Le", 52);
    freq.put(" La", 52);
    freq.put(" Lo", 31);
    freq.put(" Li", 98);
    freq.put(" Lu", 27);
    freq.put(" Ly", 18);
    freq.put("tka", 14);
    freq.put("nla", 16);
    freq.put("tku", 4);
    freq.put("nle", 39);
    freq.put("rmå", 5);
    freq.put("nli", 51);
    freq.put("dy ", 3);
    freq.put("ss ", 183);
    freq.put("Kåf", 3);
    freq.put("tne", 16);
    freq.put("lue", 4);
    freq.put("tk ", 5);
    freq.put("ssu", 10);
    freq.put("H", 859);
    freq.put("ssv", 12);
    freq.put("dyp", 6);
    freq.put("ssp", 3);
    freq.put("dyr", 12);
    freq.put("itc", 7);
    freq.put("ssl", 3);
    freq.put("sso", 21);
    freq.put("ssn", 4);
    freq.put("ssi", 32);
    freq.put("ssh", 3);
    freq.put("ssk", 21);
    freq.put("ssj", 3);
    freq.put("sse", 190);
    freq.put("tåg", 3);
    freq.put("ssa", 45);
    freq.put("Fy ", 6);
    freq.put("rmt", 4);
    freq.put("rma", 32);
    freq.put("rme", 45);
    freq.put("rmi", 15);
    freq.put("rmo", 6);
    freq.put("tåt", 14);
    freq.put("rm ", 32);
    freq.put("pot", 20);
    freq.put("por", 39);
    freq.put("pos", 39);
    freq.put("pop", 10);
    freq.put("pon", 13);
    freq.put("poo", 18);
    freq.put("pol", 73);
    freq.put("pom", 3);
    freq.put("poe", 20);
    freq.put("Bur", 4);
    freq.put("Bus", 10);
    freq.put("Nja", 3);
    freq.put("oks", 22);
    freq.put("Et ", 12);
    freq.put("gå ", 47);
    freq.put("Bar", 31);
    freq.put("I ", 102);
    freq.put("går", 124);
    freq.put("Ett", 15);
    freq.put("gåt", 17);
    freq.put("dsh", 3);
    freq.put("Åre", 3);
    freq.put("gåe", 10);
    freq.put("gån", 3);
    freq.put("Is", 12);
    freq.put("Ir", 8);
    freq.put("Iv", 5);
    freq.put("Ik", 65);
    freq.put("uhu", 3);
    freq.put("Im", 5);
    freq.put("In", 52);
    freq.put("Ib", 3);
    freq.put("Id", 11);
    freq.put("Ig", 5);
    freq.put(" qu", 3);
    freq.put("tip", 19);
    freq.put("Ban", 3);
    freq.put("tir", 12);
    freq.put("tis", 155);
    freq.put("Bal", 3);
    freq.put("til", 930);
    freq.put("tim", 67);
    freq.put("tin", 109);
    freq.put("Lon", 8);
    freq.put("ES ", 3);
    freq.put("tid", 165);
    freq.put("tif", 13);
    freq.put("Tøn", 3);
    freq.put("røk", 5);
    freq.put("tig", 116);
    freq.put("røm", 27);
    freq.put("røn", 24);
    freq.put("rød", 26);
    freq.put("tia", 14);
    freq.put("røy", 26);
    freq.put("tib", 3);
    freq.put("røs", 5);
    freq.put("rør", 12);
    freq.put("Tør", 5);
    freq.put("røv", 63);
    freq.put("Kun", 9);
    freq.put("Kul", 8);
    freq.put("gvi", 15);
    freq.put("gve", 6);
    freq.put("åls", 4);
    freq.put("oo", 138);
    freq.put("on", 778);
    freq.put("om", 1750);
    freq.put("ol", 704);
    freq.put("ok", 374);
    freq.put("oj", 4);
    freq.put("oi", 40);
    freq.put("oh", 35);
    freq.put("og", 1304);
    freq.put("of", 88);
    freq.put("oe", 344);
    freq.put("od", 363);
    freq.put("oc", 21);
    freq.put("ob", 221);
    freq.put("oa", 25);
    freq.put("oz", 4);
    freq.put("oy", 8);
    freq.put("ox", 7);
    freq.put("ow", 49);
    freq.put("ov", 315);
    freq.put("ou", 70);
    freq.put("ot", 333);
    freq.put("os", 356);
    freq.put("or", 2401);
    freq.put("op", 466);
    freq.put("LE ", 5);
    freq.put("ju ", 4);
    freq.put("FB ", 3);
    freq.put("bba", 4);
    freq.put("rvø", 3);
    freq.put("ehu", 6);
    freq.put("åfj", 3);
    freq.put("ehe", 55);
    freq.put("eha", 26);
    freq.put("eho", 6);
    freq.put("ehj", 6);
    freq.put("jue", 7);
    freq.put("juk", 13);
    freq.put("jui", 3);
    freq.put("jun", 4);
    freq.put("jul", 26);
    freq.put("jur", 4);
    freq.put("jus", 5);
    freq.put("OD ", 3);
    freq.put("eh ", 8);
    freq.put(" Ål", 7);
    freq.put("rva", 7);
    freq.put("rve", 47);
    freq.put("rvj", 12);
    freq.put("rvi", 20);
    freq.put("rvu", 3);
    freq.put("igv", 12);
    freq.put("igt", 9);
    freq.put("igs", 12);
    freq.put("igr", 9);
    freq.put("igp", 3);
    freq.put("igg", 56);
    freq.put("ige", 135);
    freq.put("igd", 3);
    freq.put("igb", 3);
    freq.put("iga", 20);
    freq.put("ign", 27);
    freq.put("igk", 3);
    freq.put("igj", 80);
    freq.put("igi", 17);
    freq.put("igh", 76);
    freq.put("ig ", 727);
    freq.put("pto", 6);
    freq.put("alo", 11);
    freq.put("all", 364);
    freq.put("alm", 7);
    freq.put("alj", 4);
    freq.put("alk", 11);
    freq.put("pti", 13);
    freq.put("ali", 49);
    freq.put("alg", 77);
    freq.put("ald", 77);
    freq.put("ale", 137);
    freq.put("alb", 13);
    freq.put("pta", 10);
    freq.put("ala", 30);
    freq.put("aly", 3);
    freq.put("alv", 26);
    freq.put("alt", 165);
    freq.put("Når", 45);
    freq.put("als", 25);
    freq.put(" N ", 4);
    freq.put("far", 54);
    freq.put("pmø", 3);
    freq.put("fav", 11);
    freq.put("Nå ", 48);
    freq.put("pt ", 27);
    freq.put("fak", 45);
    freq.put("fai", 3);
    freq.put("fan", 56);
    freq.put("llu", 6);
    freq.put("fal", 77);
    freq.put("fam", 7);
    freq.put("fab", 6);
    freq.put("fac", 13);
    freq.put("ln", 9);
    freq.put("llt", 48);
    freq.put("fag", 15);
    freq.put("fad", 5);
    freq.put("fae", 33);
    freq.put(" Ni", 12);
    freq.put(" Nj", 5);
    freq.put(" No", 156);
    freq.put(" Na", 26);
    freq.put(" Ne", 91);
    freq.put(" Ny", 61);
    freq.put(" Nr", 3);
    freq.put(" Nu", 5);
    freq.put("teh", 4);
    freq.put("tei", 24);
    freq.put("nby", 3);
    freq.put("tek", 51);
    freq.put("tel", 82);
    freq.put("tem", 97);
    freq.put("ten", 593);
    freq.put("teo", 9);
    freq.put("nbr", 5);
    freq.put("teb", 13);
    freq.put("ted", 66);
    freq.put("tee", 7);
    freq.put("tef", 4);
    freq.put("teg", 31);
    freq.put("nbl", 6);
    freq.put("tep", 11);
    freq.put("nba", 7);
    freq.put("tes", 81);
    freq.put("tet", 193);
    freq.put("lla", 40);
    freq.put("tev", 11);
    freq.put("sug", 10);
    freq.put("sue", 4);
    freq.put("sub", 3);
    freq.put("sua", 3);
    freq.put("sun", 36);
    freq.put("sum", 9);
    freq.put("sul", 34);
    freq.put("suk", 5);
    freq.put("sut", 12);
    freq.put("sus", 14);
    freq.put("sur", 21);
    freq.put("sup", 25);
    freq.put("te ", 1122);
    freq.put(" Nå", 95);
    freq.put("rkt", 9);
    freq.put("rku", 5);
    freq.put("rks", 8);
    freq.put("Tor", 25);
    freq.put("Top", 4);
    freq.put("Tot", 3);
    freq.put("Tok", 7);
    freq.put("rka", 15);
    freq.put("Tom", 6);
    freq.put("rkl", 7);
    freq.put("rkn", 6);
    freq.put("rko", 12);
    freq.put("rki", 13);
    freq.put("rkj", 7);
    freq.put("Å ", 20);
    freq.put("In ", 4);
    freq.put("En", 82);
    freq.put("rk ", 35);
    freq.put("To ", 5);
    freq.put("Vær", 5);
    freq.put("á", 3);
    freq.put("Ål", 7);
    freq.put("Åj", 3);
    freq.put("Int", 12);
    freq.put("Inn", 9);
    freq.put("v", 5088);
    freq.put("avh", 5);
    freq.put("Inf", 3);
    freq.put("Ing", 19);
    freq.put("Åp", 3);
    freq.put("År", 5);
    freq.put("oys", 3);
    freq.put("jål", 3);
    freq.put("Gli", 4);
    freq.put("Gla", 8);
    freq.put("Gle", 24);
    freq.put("Akk", 4);
    freq.put("Ake", 7);
    freq.put("lhe", 5);
    freq.put("lha", 6);
    freq.put("oy ", 3);
    freq.put(" sø", 66);
    freq.put("Er ", 87);
    freq.put(" sæ", 10);
    freq.put(" så", 410);
    freq.put("yn ", 16);
    freq.put("L", 332);
    freq.put("ksk", 6);
    freq.put("Eri", 7);
    freq.put("ynl", 9);
    freq.put("Rad", 9);
    freq.put("yno", 4);
    freq.put("ynk", 4);
    freq.put("ynd", 23);
    freq.put("yne", 54);
    freq.put("yng", 23);
    freq.put("Rak", 3);
    freq.put("Ras", 5);
    freq.put("Rap", 3);
    freq.put("ynt", 19);
    freq.put("yns", 15);
    freq.put(" sy", 120);
    freq.put("Mus", 3);
    freq.put(" sp", 277);
    freq.put(" sv", 82);
    freq.put(" st", 602);
    freq.put(" su", 75);
    freq.put(" sj", 94);
    freq.put(" sk", 664);
    freq.put(" sh", 30);
    freq.put(" si", 422);
    freq.put(" sn", 120);
    freq.put(" so", 726);
    freq.put(" sl", 161);
    freq.put(" sm", 72);
    freq.put(" sc", 15);
    freq.put(" sa", 275);
    freq.put(" se", 738);
    freq.put("ize", 3);
    freq.put("gur", 3);
    freq.put("då ", 5);
    freq.put("izz", 9);
    freq.put("koh", 5);
    freq.put("kok", 7);
    freq.put("kom", 300);
    freq.put(" s ", 36);
    freq.put("kol", 100);
    freq.put("iz ", 5);
    freq.put("ræv", 5);
    freq.put("dår", 32);
    freq.put("kon", 166);
    freq.put("X ", 12);
    freq.put("såv", 4);
    freq.put("kob", 4);
    freq.put("sås", 4);
    freq.put("sår", 4);
    freq.put("såp", 5);
    freq.put("sån", 50);
    freq.put("gpl", 3);
    freq.put("FrP", 10);
    freq.put("kop", 18);
    freq.put(" ev", 28);
    freq.put("dfa", 4);
    freq.put("åå ", 5);
    freq.put("Får", 22);
    freq.put("ådg", 3);
    freq.put("åde", 35);
    freq.put("åds", 3);
    freq.put("efr", 4);
    freq.put("eft", 26);
    freq.put("efi", 20);
    freq.put("efj", 7);
    freq.put("efl", 5);
    freq.put("efo", 32);
    freq.put("efa", 20);
    freq.put("efe", 13);
    freq.put("eff", 18);
    freq.put("åd ", 6);
    freq.put("ef ", 5);
    freq.put("rte", 207);
    freq.put("rtf", 23);
    freq.put("rta", 28);
    freq.put("rtm", 3);
    freq.put("rto", 9);
    freq.put("rti", 99);
    freq.put("rth", 3);
    freq.put("rtj", 16);
    freq.put("rtu", 7);
    freq.put("rtv", 3);
    freq.put("rts", 52);
    freq.put("rtr", 10);
    freq.put("rty", 9);
    freq.put("Ju", 18);
    freq.put("ies", 7);
    freq.put("ier", 126);
    freq.put("iet", 48);
    freq.put("Jo", 62);
    freq.put("iem", 3);
    freq.put("iel", 27);
    freq.put("ien", 96);
    freq.put("Je", 316);
    freq.put("ieb", 4);
    freq.put("Ja", 103);
    freq.put("ieg", 3);
    freq.put("ief", 3);
    freq.put("hip", 7);
    freq.put("his", 12);
    freq.put("hit", 17);
    freq.put("rt ", 567);
    freq.put("hia", 4);
    freq.put("hic", 4);
    freq.put("hie", 5);
    freq.put("hih", 3);
    freq.put("hil", 16);
    freq.put("him", 14);
    freq.put("hin", 7);
    freq.put("hio", 3);
    freq.put(" På", 58);
    freq.put("ie ", 63);
    freq.put("J ", 7);
    freq.put("arp", 9);
    freq.put("arr", 21);
    freq.put("ars", 34);
    freq.put("art", 249);
    freq.put("arv", 9);
    freq.put("pva", 7);
    freq.put("ara", 52);
    freq.put("arb", 47);
    freq.put("arc", 8);
    freq.put("ard", 49);
    freq.put("are", 287);
    freq.put("arf", 6);
    freq.put("arg", 20);
    freq.put("ari", 49);
    freq.put("ark", 61);
    freq.put("arl", 30);
    freq.put("arm", 34);
    freq.put("arn", 57);
    freq.put("aro", 11);
    freq.put(" ån", 6);
    freq.put(" åh", 8);
    freq.put(" åk", 4);
    freq.put("smø", 4);
    freq.put("al ", 378);
    freq.put(" P ", 18);
    freq.put(" åt", 4);
    freq.put(" åp", 30);
    freq.put(" år", 138);
    freq.put("ønd", 24);
    freq.put("uuu", 6);
    freq.put("ar ", 1256);
    freq.put("Rv ", 3);
    freq.put("fgh", 3);
    freq.put(" Pr", 27);
    freq.put("c", 474);
    freq.put(" Pu", 9);
    freq.put(" å ", 923);
    freq.put(" Pa", 41);
    freq.put(" Pe", 33);
    freq.put("ø", 2011);
    freq.put(" Pi", 13);
    freq.put(" Ph", 5);
    freq.put(" Po", 31);
    freq.put(" Pl", 14);
    freq.put("tgr", 4);
    freq.put("riø", 11);
    freq.put("tgu", 3);
    freq.put("tga", 7);
    freq.put("pr", 339);
    freq.put("ps", 109);
    freq.put("pp", 630);
    freq.put("duk", 19);
    freq.put("pv", 8);
    freq.put("dum", 14);
    freq.put("pt", 105);
    freq.put("pu", 78);
    freq.put("py", 14);
    freq.put("due", 6);
    freq.put("pb", 7);
    freq.put("pc", 11);
    freq.put("pa", 297);
    freq.put("pf", 13);
    freq.put("pg", 40);
    freq.put("pd", 25);
    freq.put("pe", 735);
    freq.put("pk", 6);
    freq.put("dur", 4);
    freq.put("pi", 272);
    freq.put("pn", 26);
    freq.put("po", 242);
    freq.put("pl", 210);
    freq.put("pm", 18);
    freq.put("Fab", 8);
    freq.put("Fac", 14);
    freq.put("du ", 466);
    freq.put("p ", 436);
    freq.put("Fae", 4);
    freq.put("Tit", 3);
    freq.put("rit", 92);
    freq.put("riu", 4);
    freq.put("Tip", 9);
    freq.put("ris", 104);
    freq.put("rip", 18);
    freq.put("rin", 222);
    freq.put("rio", 9);
    freq.put("ril", 22);
    freq.put("rim", 16);
    freq.put("rik", 143);
    freq.put("rih", 6);
    freq.put("rif", 30);
    freq.put("rig", 42);
    freq.put("rid", 20);
    freq.put("rie", 86);
    freq.put("rib", 8);
    freq.put("ric", 9);
    freq.put("ria", 13);
    freq.put("pø", 46);
    freq.put("pæ", 3);
    freq.put("på", 1488);
    freq.put("Com", 3);
    freq.put("eku", 6);
    freq.put("ri ", 87);
    freq.put("Eid", 3);
    freq.put("søk", 52);
    freq.put("søm", 3);
    freq.put("søn", 18);
    freq.put("søp", 3);
    freq.put("sør", 13);
    freq.put("søs", 11);
    freq.put("søt", 10);
    freq.put("søv", 7);
    freq.put("sø ", 10);
    freq.put("lje", 16);
    freq.put("yl ", 4);
    freq.put("Isr", 6);
    freq.put("zzz", 5);
    freq.put("zza", 8);
    freq.put("ylt", 9);
    freq.put("Rom", 15);
    freq.put("Roo", 4);
    freq.put("Rob", 5);
    freq.put("Roc", 4);
    freq.put("åst", 15);
    freq.put("yld", 17);
    freq.put("yle", 5);
    freq.put("yll", 24);
    freq.put("Ros", 5);
    freq.put("ylk", 11);
    freq.put("yli", 4);
    freq.put("wn ", 3);
    freq.put(" ut", 387);
    freq.put(" uv", 8);
    freq.put(" up", 7);
    freq.put(" ur", 7);
    freq.put(" us", 20);
    freq.put(" ul", 9);
    freq.put(" um", 6);
    freq.put(" un", 105);
    freq.put(" uk", 61);
    freq.put(" ud", 4);
    freq.put(" ue", 3);
    freq.put(" uf", 8);
    freq.put(" ug", 4);
    freq.put(" ua", 18);
    freq.put("ahr", 3);
    freq.put("grø", 13);
    freq.put("grå", 7);
    freq.put(" u ", 5);
    freq.put("ca ", 25);
    freq.put("å", 5125);
    freq.put("ix ", 5);
    freq.put("z", 89);
    freq.put("gru", 70);
    freq.put("gry", 3);
    freq.put("gre", 115);
    freq.put("gra", 79);
    freq.put("gro", 7);
    freq.put("gri", 26);
    freq.put("Bå", 9);
    freq.put("edb", 3);
    freq.put("eda", 41);
    freq.put("edf", 5);
    freq.put("edd", 37);
    freq.put("ede", 178);
    freq.put("edk", 5);
    freq.put("edi", 44);
    freq.put("edn", 9);
    freq.put("edo", 11);
    freq.put("edl", 10);
    freq.put("edr", 88);
    freq.put("eds", 31);
    freq.put("edt", 5);
    freq.put("edu", 4);
    freq.put("påt", 4);
    freq.put("påv", 5);
    freq.put("påp", 4);
    freq.put("pår", 5);
    freq.put("pås", 8);
    freq.put("påk", 7);
    freq.put("påg", 3);
    freq.put("ed ", 797);
    freq.put("ugg", 5);
    freq.put("P", 339);
    freq.put("ugd", 4);
    freq.put("iba", 3);
    freq.put("på ", 1429);
    freq.put("Gøy", 5);
    freq.put("rro", 18);
    freq.put("rri", 34);
    freq.put("rre", 99);
    freq.put("rra", 56);
    freq.put("rry", 14);
    freq.put("edø", 3);
    freq.put("bdi", 4);
    freq.put("IG ", 6);
    freq.put("rr ", 25);
    freq.put("apr", 3);
    freq.put("aps", 18);
    freq.put("app", 78);
    freq.put("Mik", 6);
    freq.put("AL ", 4);
    freq.put("aph", 3);
    freq.put("api", 9);
    freq.put("apa", 8);
    freq.put("ape", 50);
    freq.put("Huf", 4);
    freq.put("fee", 6);
    freq.put("feb", 5);
    freq.put("usb", 3);
    freq.put("usa", 4);
    freq.put("uso", 3);
    freq.put("fel", 30);
    freq.put("usl", 12);
    freq.put("usk", 42);
    freq.put("fek", 27);
    freq.put("usi", 47);
    freq.put("ush", 18);
    freq.put("fet", 21);
    freq.put("ust", 42);
    freq.put("uss", 55);
    freq.put("fes", 48);
    freq.put("Hur", 13);
    freq.put("Hus", 18);
    freq.put("Mic", 4);
    freq.put("Gud", 8);
    freq.put("Gun", 4);
    freq.put("Gul", 3);
    freq.put("Gut", 3);
    freq.put("ap ", 25);
    freq.put(" Ru", 10);
    freq.put(" Rv", 3);
    freq.put("fe ", 45);
    freq.put("us ", 83);
    freq.put(" Ry", 6);
    freq.put(" Re", 54);
    freq.put(" Ra", 29);
    freq.put(" Ro", 43);
    freq.put(" Ri", 19);
    freq.put("tat", 116);
    freq.put("tau", 7);
    freq.put("tav", 23);
    freq.put("tap", 13);
    freq.put("tar", 135);
    freq.put("tas", 90);
    freq.put("tad", 49);
    freq.put("tae", 5);
    freq.put("taf", 4);
    freq.put("tag", 15);
    freq.put("tab", 11);
    freq.put("tac", 3);
    freq.put("tal", 115);
    freq.put("tam", 6);
    freq.put("tan", 96);
    freq.put("Mis", 6);
    freq.put("tak", 116);
    freq.put("sis", 83);
    freq.put("sir", 3);
    freq.put("sip", 6);
    freq.put("siv", 15);
    freq.put("sit", 75);
    freq.put("Mit", 8);
    freq.put("sia", 26);
    freq.put("dwa", 3);
    freq.put("sig", 31);
    freq.put("sif", 3);
    freq.put("sie", 78);
    freq.put("sid", 88);
    freq.put("sik", 121);
    freq.put("sin", 103);
    freq.put("sil", 7);
    freq.put("ta ", 185);
    freq.put("Eks", 3);
    freq.put(" Rø", 10);
    freq.put(" Rå", 3);
    freq.put("si ", 67);
    freq.put("kbl", 3);
    freq.put("Hør", 21);
    freq.put("Høy", 16);
    freq.put("kve", 95);
    freq.put("byt", 14);
    freq.put("byr", 13);
    freq.put("bys", 3);
    freq.put("før", 199);
    freq.put("føl", 86);
    freq.put("byg", 16);
    freq.put("bye", 20);
    freq.put("Car", 14);
    freq.put("Can", 15);
    freq.put("Cam", 4);
    freq.put("Cal", 3);
    freq.put("Caf", 3);
    freq.put("Pre", 5);
    freq.put("nfe", 12);
    freq.put("Pra", 3);
    freq.put("nfo", 43);
    freq.put("Pro", 4);
    freq.put("nfl", 7);
    freq.put("Pri", 8);
    freq.put("nfi", 7);
    freq.put("nfu", 4);
    freq.put("nfr", 7);
    freq.put("by ", 11);
    freq.put("oui", 6);
    freq.put("oun", 10);
    freq.put("oul", 3);
    freq.put("ous", 10);
    freq.put("our", 17);
    freq.put("out", 7);
    freq.put("lt ", 336);
    freq.put("ou ", 11);
    freq.put("lts", 39);
    freq.put("ltr", 8);
    freq.put("g", 9669);
    freq.put("lta", 31);
    freq.put("ltf", 7);
    freq.put("lte", 80);
    freq.put("lti", 30);
    freq.put("lto", 5);
    freq.put("Prø", 6);
    freq.put("nfø", 5);
    freq.put("K ", 59);
    freq.put("Ka", 111);
    freq.put("Ke", 8);
    freq.put("Kj", 47);
    freq.put("Ki", 21);
    freq.put("Ko", 71);
    freq.put("Kn", 3);
    freq.put("Kl", 30);
    freq.put("Ks", 3);
    freq.put("Kr", 40);
    freq.put("Kv", 16);
    freq.put("Ku", 17);
    freq.put("Ky", 4);
    freq.put("yba", 4);
    freq.put("Håv", 3);
    freq.put("Håp", 28);
    freq.put("øpi", 3);
    freq.put("øpe", 63);
    freq.put("øpt", 13);
    freq.put("Kå", 5);
    freq.put("whi", 3);
    freq.put("Rød", 6);
    freq.put("ht", 23);
    freq.put("øp ", 22);
    freq.put("Por", 4);
    freq.put("Pos", 4);
    freq.put("Poo", 3);
    freq.put("Pol", 10);
    freq.put("Poi", 3);
    freq.put("ebæ", 3);
    freq.put("Cha", 11);
    freq.put("lær", 41);
    freq.put("ha", 1449);
    freq.put("eat", 7);
    freq.put("no ", 51);
    freq.put(" we", 13);
    freq.put("qu", 12);
    freq.put("lvs", 7);
    freq.put(" wa", 4);
    freq.put(" wo", 6);
    freq.put(" wh", 7);
    freq.put(" wi", 5);
    freq.put(" ww", 11);
    freq.put("Jak", 3);
    freq.put("ebe", 17);
    freq.put("eba", 39);
    freq.put("ebl", 14);
    freq.put("ebo", 30);
    freq.put("ebi", 12);
    freq.put("jo ", 153);
    freq.put("ebu", 9);
    freq.put("ebr", 13);
    freq.put("eby", 7);
    freq.put("ikv", 7);
    freq.put("dla", 5);
    freq.put("dle", 32);
    freq.put("dli", 40);
    freq.put("dly", 5);
    freq.put("jor", 115);
    freq.put("jos", 5);
    freq.put("eb ", 6);
    freq.put("jou", 9);
    freq.put("joa", 3);
    freq.put("job", 100);
    freq.put("joi", 4);
    freq.put("jok", 20);
    freq.put("jol", 8);
    freq.put("lvo", 6);
    freq.put("jon", 141);
    freq.put("dl ", 3);
    freq.put("rps", 6);
    freq.put("rpa", 7);
    freq.put("rpe", 10);
    freq.put("PL ", 10);
    freq.put("hm ", 10);
    freq.put("rpl", 3);
    freq.put("rpo", 17);
    freq.put("bbi", 6);
    freq.put("bbe", 69);
    freq.put("bbd", 3);
    freq.put("Jul", 3);
    freq.put("Jus", 7);
    freq.put("bby", 3);
    freq.put("tær", 3);
    freq.put("bbs", 3);
    freq.put("rp ", 17);
    freq.put(" Tø", 11);
    freq.put("é", 27);
    freq.put("bb ", 43);
    freq.put("Øya", 5);
    freq.put(" Tå", 5);
    freq.put("avt", 6);
    freq.put("avs", 15);
    freq.put("AR ", 8);
    freq.put("avn", 47);
    freq.put("avo", 12);
    freq.put("rpå", 16);
    freq.put("avi", 41);
    freq.put("avk", 5);
    freq.put("avd", 5);
    freq.put("ave", 55);
    freq.put("avf", 7);
    freq.put("avg", 16);
    freq.put("ava", 13);
    freq.put("avb", 3);
    freq.put(" én", 6);
    freq.put(" T ", 6);
    freq.put("av ", 504);
    freq.put(" Ty", 17);
    freq.put(" Tw", 34);
    freq.put(" Tv", 7);
    freq.put(" Tu", 24);
    freq.put(" Tr", 120);
    freq.put(" To", 59);
    freq.put(" Tj", 11);
    freq.put(" Ti", 56);
    freq.put(" Th", 27);
    freq.put("tju", 4);
    freq.put(" Te", 32);
    freq.put(" Ta", 85);
    freq.put("mfa", 3);
    freq.put("mfi", 3);
    freq.put("mfu", 13);
    freq.put("tch", 17);
    freq.put("sku", 98);
    freq.put("skt", 16);
    freq.put("skv", 5);
    freq.put("skr", 124);
    freq.put("Far", 5);
    freq.put("Moe", 4);
    freq.put("sky", 36);
    freq.put("ske", 316);
    freq.put("Fak", 3);
    freq.put("ska", 346);
    freq.put("nor", 77);
    freq.put("Fal", 4);
    freq.put("skm", 3);
    freq.put("skl", 8);
    freq.put("sko", 89);
    freq.put("skn", 11);
    freq.put("ski", 69);
    freq.put("skj", 197);
    freq.put("Eir", 3);
    freq.put("T", 550);
    freq.put("tc ", 4);
    freq.put("Ein", 3);
    freq.put("sk ", 225);
    freq.put("kdo", 4);
    freq.put("Sun", 6);
    freq.put("Sup", 8);
    freq.put("nd ", 182);
    freq.put("ndi", 47);
    freq.put("ndh", 23);
    freq.put("ndl", 28);
    freq.put("ndo", 24);
    freq.put("ndn", 4);
    freq.put("nda", 106);
    freq.put("ndb", 4);
    freq.put("nde", 361);
    freq.put("ndg", 3);
    freq.put("nds", 37);
    freq.put("ndr", 144);
    freq.put("ndu", 8);
    freq.put("ndt", 52);
    freq.put("own", 5);
    freq.put("owe", 19);
    freq.put("ama", 31);
    freq.put("ows", 4);
    freq.put("vak", 32);
    freq.put("van", 90);
    freq.put("val", 91);
    freq.put("vag", 3);
    freq.put("vad", 4);
    freq.put("lv ", 97);
    freq.put("var", 342);
    freq.put("vas", 15);
    freq.put("vap", 3);
    freq.put("vat", 14);
    freq.put("ef", 156);
    freq.put("Rø", 10);
    freq.put("ow ", 12);
    freq.put("Gjo", 3);
    freq.put("Gje", 9);
    freq.put("lvt", 4);
    freq.put("lvv", 3);
    freq.put("Tel", 5);
    freq.put("lvp", 3);
    freq.put("Ten", 10);
    freq.put("Tea", 5);
    freq.put("va ", 190);
    freq.put("lve", 43);
    freq.put("lvf", 9);
    freq.put("lva", 9);
    freq.put("Ter", 3);
    freq.put("Tes", 4);
    freq.put("lvi", 5);
    freq.put("myr", 4);
    freq.put("Aft", 8);
    freq.put("myk", 6);
    freq.put("mye", 104);
    freq.put("Afr", 6);
    freq.put("Gjø", 10);
    freq.put("my ", 12);
  }
  
}

