package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class PA {
  private static final String name = "pa";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public PA() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 89609;
    n_words[1] = 113266;
    n_words[2] = 83000;

    freq.put("ਦੁੱ", 21);
    freq.put("ਜ਼ਿ", 21);
    freq.put("ਜ਼ਾ", 19);
    freq.put("ੱਗ", 118);
    freq.put("आ", 6);
    freq.put("ੱਘ", 3);
    freq.put("ੱਛ", 38);
    freq.put("ਜ਼ਰ", 13);
    freq.put("ੱਝ", 28);
    freq.put("ਮਰ ", 27);
    freq.put("ੀਏ ", 75);
    freq.put("ਆਉ ", 3);
    freq.put("ਰਤੇ", 3);
    freq.put("ਜ਼ਮ", 6);
    freq.put("ਜ਼ਬ", 4);
    freq.put("਼੍ਰ", 12);
    freq.put("ੱਕ", 223);
    freq.put("ਟੱਕ", 7);
    freq.put("ਜ", 2015);
    freq.put("ਅਣ", 15);
    freq.put("रति", 3);
    freq.put("ਬਰਾ", 9);
    freq.put("ੂਗਾ", 3);
    freq.put("ੱਲ", 284);
    freq.put("ਸੁ", 114);
    freq.put("ੱਹ", 3);
    freq.put("ੰਨੂ", 3);
    freq.put("ੰਨੁ", 4);
    freq.put("ੰਨੀ", 21);
    freq.put("ੰਨੇ", 16);
    freq.put("ਜ਼ਖ", 4);
    freq.put("ੂਜੀ", 3);
    freq.put("ੱਡ", 101);
    freq.put("ੱਠ", 36);
    freq.put("ੱਣ", 6);
    freq.put("ੱਢ", 12);
    freq.put("ੱਥ", 55);
    freq.put("ਧਰਤ", 8);
    freq.put("ੱਧ", 38);
    freq.put("ੱਦ", 34);
    freq.put("ਬਰਦ", 4);
    freq.put("ੱਫ", 7);
    freq.put("ਗੇ ", 106);
    freq.put("ੱਭ", 36);
    freq.put("ਰਚ ", 6);
    freq.put("ੇਵਾ", 12);
    freq.put("ਫ਼", 39);
    freq.put(" ਹਨ", 30);
    freq.put("ੱਚ", 200);
    freq.put("िस", 3);
    freq.put("ੋਲ ", 32);
    freq.put("ੈਠ ", 5);
    freq.put("ੱੜ", 5);
    freq.put("ੱਜ", 130);
    freq.put("ਆਨ ", 11);
    freq.put("ਮੰਡ", 8);
    freq.put("ੰਨਿ", 11);
    freq.put("ੰਨਾ", 34);
    freq.put("ਉਮੀ", 4);
    freq.put("ੜ", 663);
    freq.put("ੰਨਵ", 4);
    freq.put("ਬਰੀ", 4);
    freq.put("ੈ।", 5);
    freq.put("ਹੀ ", 353);
    freq.put("ਸੇ", 158);
    freq.put("ਨਰ", 13);
    freq.put("ਜਰ", 40);
    freq.put("ਖਤ ", 6);
    freq.put("↓↓", 7);
    freq.put("ਘ ", 40);
    freq.put(" ਆਦ", 13);
    freq.put("ਜ਼ੋ", 3);
    freq.put("ਨਾ ", 365);
    freq.put("ਯਾ", 171);
    freq.put("ੁੰ", 251);
    freq.put("ਧੂ ", 9);
    freq.put("ਖ਼ੁਸ਼", 3);
    freq.put("ਜ਼ੀ", 5);
    freq.put("ਜ਼", 112);
    freq.put("ਧਾਇ", 4);
    freq.put("ਪੈ ", 16);
    freq.put(" ਰੱ", 136);
    freq.put(" ਰੰ", 23);
    freq.put("ਸ਼ੀ ", 11);
    freq.put("ਇ", 625);
    freq.put("ਣਬ", 3);
    freq.put("ਰਨਜ", 4);
    freq.put("ੈ। ", 4);
    freq.put("ਣਦ", 18);
    freq.put("ਣਤ", 3);
    freq.put("ੱਲਰ", 5);
    freq.put(" ੳਹ", 3);
    freq.put("ਣਿ", 19);
    freq.put("ਣਾ", 269);
    freq.put(" ਜ਼ਿ", 18);
    freq.put("ਝਾ ", 6);
    freq.put("ਅਪਨ", 4);
    freq.put("ੋਰਟ", 10);
    freq.put("ੌਂਦ", 3);
    freq.put("ੱਲਾ", 39);
    freq.put("ੱਲਿ", 10);
    freq.put("ਜਦ", 92);
    freq.put("ਂਆ ", 3);
    freq.put("ਮਦ ", 3);
    freq.put("ਉੱ", 55);
    freq.put("ਐਮ", 3);
    freq.put("ਿਸ ", 39);
    freq.put("ਏਗੀ", 4);
    freq.put("ਸਬ ", 9);
    freq.put(" ਉਨ", 14);
    freq.put(" ਰੂ", 23);
    freq.put(" ਰੁ", 33);
    freq.put(" ਰੀ", 6);
    freq.put(" ਰੇ", 10);
    freq.put("ਤੁਹ", 27);
    freq.put("ਨੋਟ", 3);
    freq.put("ਕਣ ", 14);
    freq.put(" ਰੋ", 88);
    freq.put("ੁਕਾ", 9);
    freq.put("ਣਗ", 31);
    freq.put("ਣਖ", 6);
    freq.put("ਣਕ", 21);
    freq.put(" ਰੌ", 7);
    freq.put("ੁੜ੍", 4);
    freq.put(" ਰਲ", 3);
    freq.put("ς", 6);
    freq.put("ਉਝ", 5);
    freq.put("ਹਟ", 5);
    freq.put("ੇ", 5210);
    freq.put("ੱਰ", 3);
    freq.put("ੱਪ ", 16);
    freq.put("ਚੱਲ", 15);
    freq.put("ਿਉਕ", 4);
    freq.put(" ਰਸ", 7);
    freq.put(" ਰਿ", 60);
    freq.put(" ਰਾ", 121);
    freq.put("ਉਖ", 3);
    freq.put("ਜਮ", 12);
    freq.put("ਪਛਾ", 4);
    freq.put("ਦੂਰ", 15);
    freq.put("ਉਂਝ", 5);
    freq.put("ਉਏ", 3);
    freq.put("ਈਨ", 4);
    freq.put("ਅਣਖ", 6);
    freq.put("ਉਂ", 82);
    freq.put("ਧਾ ", 9);
    freq.put("ਿਉਂ", 28);
    freq.put("ਉਂਗ", 5);
    freq.put("ੱਲੀ", 26);
    freq.put("ਉਸ", 45);
    freq.put("ਫ ", 32);
    freq.put(" ਰਗ", 3);
    freq.put(" ਰਖ", 12);
    freq.put("ੱਲੇ", 39);
    freq.put("ਜਪ", 17);
    freq.put("ਲਕ ", 9);
    freq.put("ੱਲੋ", 21);
    freq.put("ਣੇ", 129);
    freq.put("ੀਰਾ", 13);
    freq.put("ਉਂਦ", 44);
    freq.put(" ਰਜ", 4);
    freq.put("ਸ਼ੇ", 9);
    freq.put("ਿਫ਼", 5);
    freq.put("ਉਪ", 3);
    freq.put("ਜਦ ", 29);
    freq.put("ਉਮ", 26);
    freq.put("ਉਡ", 14);
    freq.put("ਾਇ ", 11);
    freq.put("ਉਣ", 115);
    freq.put("ਿਉਣ", 5);
    freq.put("ਮਾ ", 37);
    freq.put("ੈਠਕ", 3);
    freq.put("ਉਦ", 53);
    freq.put("ਗਤ ", 10);
    freq.put("ਦੂਸ", 4);
    freq.put("ਸ਼ਤ", 10);
    freq.put("ੱਖੋ", 3);
    freq.put("ਸ਼ਨ", 25);
    freq.put("ਉਮਰ", 20);
    freq.put("ਚੜਾ", 5);
    freq.put("ੱਖੀ", 26);
    freq.put("ੁਨੀ", 46);
    freq.put("ਸ਼ਮ", 4);
    freq.put("ਜਰ ", 5);
    freq.put("ੱਖੜ", 6);
    freq.put("ਮੇਵ", 3);
    freq.put("ਖਰੇ", 7);
    freq.put("ਚੜਦ", 4);
    freq.put("ਮੇਰ", 190);
    freq.put("ਖਰੀ", 15);
    freq.put("ਘਿਰ", 3);
    freq.put("ਦਰਤ", 4);
    freq.put("ਨਪ", 7);
    freq.put("ਸ਼ਹ", 8);
    freq.put(" ਈ ", 23);
    freq.put("ਮੇਸ", 6);
    freq.put("ਮੇਹ", 8);
    freq.put("ਸ਼ਾ", 46);
    freq.put("ਸ਼ਿ", 21);
    freq.put(" ਓਪ", 3);
    freq.put("ਾਂਭ", 3);
    freq.put("ਮੇਂ", 14);
    freq.put("ਦੁਆ", 11);
    freq.put("ਲਤਾ", 3);
    freq.put("ਣੀਏ", 6);
    freq.put("ਰਟੀ", 6);
    freq.put("ਲਿਆ", 79);
    freq.put("र", 14);
    freq.put("ੋਜ", 25);
    freq.put("ਲ", 2942);
    freq.put(" ਢੱ", 3);
    freq.put("ਸ਼ਕ", 17);
    freq.put("ਨਫ", 9);
    freq.put("ਰਣ ", 5);
    freq.put("ਂਕੀ", 3);
    freq.put("ਮੇਟ", 6);
    freq.put("ਬਾ ", 45);
    freq.put("ਸ਼ਟ", 6);
    freq.put("ਵਾ ", 58);
    freq.put("ਰਕੇ", 38);
    freq.put("ੜ ", 132);
    freq.put("ਤੁੰ", 3);
    freq.put("ਇਹ", 92);
    freq.put("ਕੱ", 74);
    freq.put("ਉਸ ", 27);
    freq.put(" ਤੂ", 143);
    freq.put("ਸ਼ੱ", 3);
    freq.put("ਲਤੀ", 6);
    freq.put(" ਤੀ", 12);
    freq.put("ਲਲਲ", 6);
    freq.put("ਸ਼ੀ", 26);
    freq.put("ਸ਼ੁ", 9);
    freq.put("ਕਬਰ", 3);
    freq.put("ਕਿ ", 66);
    freq.put("ੇਦਾ", 6);
    freq.put("ਲੰ", 33);
    freq.put("ਜਲ ", 4);
    freq.put("ੱਖਦ", 9);
    freq.put("ਖਰਾ", 7);
    freq.put("ਸ਼ੌ", 4);
    freq.put("ਿਛੜ", 5);
    freq.put("ੁੱਠ", 3);
    freq.put("ੱਖਣ", 9);
    freq.put("ੱਖਾ", 25);
    freq.put("ੲ", 12);
    freq.put("ੈਲੋ", 3);
    freq.put("ਣਵਾ", 3);
    freq.put("ਚੜ੍", 5);
    freq.put("ੱਖਵ", 11);
    freq.put("ਿਛੋ", 3);
    freq.put(" ਢਾ", 4);
    freq.put("ੱਖਰ", 10);
    freq.put("ਲੜ ", 3);
    freq.put("ੰਤ ", 11);
    freq.put("ਸਿਆ", 21);
    freq.put("ਲਕੇ", 3);
    freq.put("ਦਾਸ", 17);
    freq.put("ਦੁਸ਼", 6);
    freq.put("ਇਨਾ", 5);
    freq.put("ਸ਼ਰਾ", 9);
    freq.put("ਇਨਸ", 15);
    freq.put("ਸਣ ", 3);
    freq.put("ਿੱ", 375);
    freq.put("ਿੰ", 379);
    freq.put("ਸਿਖ", 18);
    freq.put("ਖਦਾ", 10);
    freq.put("ਸ਼ਰਧ", 3);
    freq.put("ਸਿਕ", 4);
    freq.put("ੂਤਰ", 4);
    freq.put("ਂਝ", 12);
    freq.put("ਗੇੜ", 7);
    freq.put("ਝ", 229);
    freq.put("ਬੇਵ", 17);
    freq.put("ਸਿਧ", 3);
    freq.put("ਅਰਜ", 4);
    freq.put("ੇਠੇ", 3);
    freq.put(" ਅਪ", 17);
    freq.put("ਸਿਮ", 3);
    freq.put("਼ਰ ", 6);
    freq.put("ਇਆ ", 116);
    freq.put("ਸਿਵ", 6);
    freq.put("ਸਿਲ", 5);
    freq.put("ਂਚ", 5);
    freq.put("ਸਿਰ", 29);
    freq.put(" ਖ਼ੁ", 3);
    freq.put("ਖੈ", 3);
    freq.put("ਸਿਹ", 4);
    freq.put("ਿਥੋ", 4);
    freq.put("ਪਾ ", 54);
    freq.put("ਿੰ ", 3);
    freq.put("ਿਹ", 204);
    freq.put("ਿਸ", 234);
    freq.put("ਿਸ਼", 25);
    freq.put("ਿਵ", 53);
    freq.put("ਪਰੀ", 7);
    freq.put("ਿਥੇ", 12);
    freq.put("ਿਲ", 331);
    freq.put("ੱਜ ", 86);
    freq.put("ਿਰ", 145);
    freq.put("ਵਾਨ", 25);
    freq.put("ਿਮ", 26);
    freq.put("ਿਭ", 18);
    freq.put("ੀਆਂ", 257);
    freq.put("ਿਫ", 14);
    freq.put("ਿਪ", 8);
    freq.put("ਖਾ ", 42);
    freq.put("ਿਧ", 15);
    freq.put("ਿਦ", 34);
    freq.put("ਿਥ", 17);
    freq.put("ਿਤ", 77);
    freq.put("ਆਊਗ", 3);
    freq.put("ਿਡ", 6);
    freq.put("ਇਹਦ", 3);
    freq.put("ਿਟ", 7);
    freq.put("ਂਟ ", 7);
    freq.put("ਿਜ", 16);
    freq.put("ਿਛ", 13);
    freq.put("ਿਚ", 83);
    freq.put("ੀਬ ", 8);
    freq.put("ਖਦੇ", 6);
    freq.put("ਉਣਗ", 5);
    freq.put("ਿਕ", 104);
    freq.put("ੇਰੇ", 203);
    freq.put("ਚ ", 438);
    freq.put("ਖਦੀ", 3);
    freq.put("ੜੀਏ", 13);
    freq.put("ਸ਼ਰੀ", 5);
    freq.put("ਸਿੰ", 40);
    freq.put("ਸਿੱ", 34);
    freq.put("ਭੰ", 3);
    freq.put("ਿਆ", 653);
    freq.put("ਿਅ", 11);
    freq.put("ਿਉ ", 20);
    freq.put("ਿਂ", 5);
    freq.put("ਮੁ", 204);
    freq.put("ੁਗੀ", 3);
    freq.put("ਫਰੈ", 3);
    freq.put("ਵੜ", 5);
    freq.put("ਹਲੀ", 3);
    freq.put("ਚੀ ", 20);
    freq.put("ਇਸ਼ਕ", 4);
    freq.put("ਦਗੀ", 66);
    freq.put("ਵਾਪ", 6);
    freq.put("ਹਲੇ", 4);
    freq.put("ਓਂ ", 5);
    freq.put("ਜੱਗ", 11);
    freq.put("ਖੋ", 45);
    freq.put("ਰਨਾ", 28);
    freq.put("ਵੋ", 22);
    freq.put("ੰਧਾ", 3);
    freq.put("ਵੇ", 298);
    freq.put(" →ㅤ", 3);
    freq.put("ਵੁ", 3);
    freq.put("ਵੀ", 368);
    freq.put("ਪਸ", 19);
    freq.put("ਨਣ", 7);
    freq.put("ਭੁ ", 4);
    freq.put("ਲਸ ", 11);
    freq.put("ਜ਼ ", 28);
    freq.put("ਵੱ", 88);
    freq.put("ਵੰ", 7);
    freq.put("ਰ", 4850);
    freq.put("ਲਖ", 10);
    freq.put("਼ੇ", 21);
    freq.put(" ਅਲ", 6);
    freq.put("ੂੰਗ", 4);
    freq.put("ੇ ", 3758);
    freq.put("ਾਂਟ", 3);
    freq.put("ਐਸ ", 3);
    freq.put("ਗੱ", 82);
    freq.put("ੋਣੀ", 14);
    freq.put("ਵਜ", 14);
    freq.put("ਵਟ", 5);
    freq.put("ਾਲ਼", 4);
    freq.put("ਪੱਪ", 3);
    freq.put("ਕੋ", 212);
    freq.put("ਕਲੇ", 3);
    freq.put("ਵਕ", 15);
    freq.put("ਇਜ਼", 3);
    freq.put("ਪੱਤ", 6);
    freq.put("ਮਸਤ", 4);
    freq.put("ੋਰੀ", 14);
    freq.put("ਲਗ", 56);
    freq.put("ੀਐ ", 5);
    freq.put("ਾਸ਼", 30);
    freq.put("ਬੀਤ", 4);
    freq.put("ੇਖੀ", 10);
    freq.put("ੁੱਕ", 40);
    freq.put("ਲਿੰ", 3);
    freq.put("ਕੇ", 392);
    freq.put("ਵਿ", 292);
    freq.put("ਵਾ", 605);
    freq.put("ਵਹ", 12);
    freq.put("ਭ ", 48);
    freq.put("ੰਧੀ", 3);
    freq.put("ੂਪ ", 8);
    freq.put("ਊ ", 6);
    freq.put("ਰਨੀ", 8);
    freq.put("ਵਰ", 69);
    freq.put("ਵਲ", 18);
    freq.put("ੰ", 2127);
    freq.put("ਾਫ", 20);
    freq.put("ਵਨ", 11);
    freq.put("ਹਲਾ", 15);
    freq.put("ਸ਼ਾ ", 11);
    freq.put("ਪੱਖ", 6);
    freq.put("ੁਝ ", 52);
    freq.put("ਅਜੀ", 3);
    freq.put(" ਤੰ", 7);
    freq.put("ਵਡ", 5);
    freq.put("ਖੁ ", 6);
    freq.put("ਵਣ", 13);
    freq.put("ੋਆਣ", 4);
    freq.put("ਤਿਸ", 3);
    freq.put("ਤਿਹ", 13);
    freq.put("ਫਸਾ", 5);
    freq.put("ੰਦ ", 39);
    freq.put("ੌਲੀ", 4);
    freq.put("੍ਸ ", 3);
    freq.put("ਾਯ", 6);
    freq.put("ਦਿਆ", 33);
    freq.put(" ਯਾ", 158);
    freq.put("ਤਿਨ", 11);
    freq.put("ਦਮੀ", 3);
    freq.put("ੋਦੀ", 3);
    freq.put("ਛ", 177);
    freq.put("ਸੀ ", 245);
    freq.put("ਪੁਲ", 14);
    freq.put("ੀਡੀ", 38);
    freq.put("ੋਣਕ", 3);
    freq.put(" ਏਕ", 3);
    freq.put("ं ", 4);
    freq.put("ਹੇ ", 52);
    freq.put("ਸਚਾ", 3);
    freq.put("ਮਿਲ", 87);
    freq.put("ਤਿਕ", 6);
    freq.put("ਪੇ ", 6);
    freq.put("ੇਣ ", 12);
    freq.put("ਨਿ ", 9);
    freq.put("ੁੰ ", 10);
    freq.put(" ਯਕ", 3);
    freq.put("ਤਿਆ", 27);
    freq.put("ਆਮ ", 4);
    freq.put("ਨੁ ", 23);
    freq.put("਼ੀ", 30);
    freq.put("ਤਿੰ", 8);
    freq.put("ਾਏਗ", 5);
    freq.put("ਂਦਰ", 10);
    freq.put("ੋਜ ", 13);
    freq.put("ਰੂ ", 98);
    freq.put("ਰਹ ", 3);
    freq.put("ਾਜ", 72);
    freq.put("ਜ਼", 119);
    freq.put("ਂਦਾ", 60);
    freq.put("ਾਝ", 6);
    freq.put("ਾਬ ", 69);
    freq.put("ਣਤੀ", 3);
    freq.put("ੀਂ ", 218);
    freq.put("ਘਟ ", 5);
    freq.put("ਰਕ ", 9);
    freq.put("ਾਟ", 9);
    freq.put("ਸਭ ", 26);
    freq.put(" ● ", 4);
    freq.put("ੁਬਾ", 10);
    freq.put("ੈਦ", 20);
    freq.put("ਦਰਦ", 14);
    freq.put("ੱਡਿ", 6);
    freq.put("ਕਨ", 5);
    freq.put("਼ਕ ", 8);
    freq.put("ੱਡਾ", 9);
    freq.put(" ਸਗ", 3);
    freq.put("ਆ", 1951);
    freq.put("ਣਕਾ", 7);
    freq.put("ਬਜੀ", 4);
    freq.put("ਕਰ ", 110);
    freq.put("ਚਨਾ", 4);
    freq.put("ღ ", 3);
    freq.put("ੱਲਣ", 4);
    freq.put("ਲਵਾ", 16);
    freq.put("ੇਸਬ", 10);
    freq.put("ਐਕ", 4);
    freq.put("ਾਗ", 74);
    freq.put("ज", 5);
    freq.put(" ੴ ", 7);
    freq.put("ਾਈ", 175);
    freq.put("ਵਲ ", 6);
    freq.put("ੱਲਦ", 11);
    freq.put("ਾਉ", 146);
    freq.put("ਔਖ", 15);
    freq.put("ੱਗਦ", 24);
    freq.put("ਔਕ", 4);
    freq.put("­", 3);
    freq.put("ੰੂ", 4);
    freq.put("ਤੂੰ", 124);
    freq.put("ੱਗਿ", 7);
    freq.put("ੱਗਾ", 10);
    freq.put("ਸਕੇ", 4);
    freq.put("ਕਣ", 27);
    freq.put("ਾਲ ", 273);
    freq.put("ਿਆਸ", 6);
    freq.put(" ਡਾ", 14);
    freq.put(" ਡਿ", 12);
    freq.put("ੇਸ ", 10);
    freq.put(" ਡੂ", 3);
    freq.put("ਸਾਂ", 19);
    freq.put("ਗਏ", 44);
    freq.put("ਲੇਆ", 5);
    freq.put("ਸਾਇ", 3);
    freq.put(" ਡੇ", 6);
    freq.put("ਸਾਉ", 5);
    freq.put("ਸਾਈ", 9);
    freq.put("ਸ਼", 284);
    freq.put("ਕਟ", 17);
    freq.put("ੱਗੀ", 7);
    freq.put("ਜ਼ੀ ", 6);
    freq.put("ਥਿਆ", 4);
    freq.put(" ਫੁ", 25);
    freq.put("੍ਸ", 6);
    freq.put("ਸਾਗ", 5);
    freq.put("ਸਾਖ", 4);
    freq.put("ੀਹਾ", 3);
    freq.put("ਾਂ", 1175);
    freq.put("ਸਾਡ", 120);
    freq.put("ਲਵੋ", 5);
    freq.put("ੰਤਰ", 21);
    freq.put("ਸਾਥ", 23);
    freq.put("ਸਾਧ", 6);
    freq.put("ਸਾਨ", 79);
    freq.put("ੈੰ", 4);
    freq.put(" ਤਨ", 4);
    freq.put("ਸਾਬ", 14);
    freq.put("ਸਾਮ", 6);
    freq.put("ਣਕੇ", 7);
    freq.put("ਸਾਰ", 75);
    freq.put("ੰ ", 730);
    freq.put("ਸਾਲ", 53);
    freq.put("ਸਾਵ", 4);
    freq.put("ੱਝੀ", 3);
    freq.put("ਸਾਹ", 52);
    freq.put("ਸਾਸ", 7);
    freq.put("ਾਝੋ", 3);
    freq.put("੍ਰ", 152);
    freq.put("ਰਦ ", 14);
    freq.put("ਧਵ", 3);
    freq.put("ਧਰ", 32);
    freq.put("ਧਿ", 24);
    freq.put("ਧਾ", 52);
    freq.put("ਭਾਣ", 3);
    freq.put("ੋਲਿ", 6);
    freq.put("ੇਜ", 43);
    freq.put("ਕਟਰ", 8);
    freq.put("ੰੂ ", 4);
    freq.put("ਭਾਰ", 22);
    freq.put("ਾੳ", 4);
    freq.put("ਭਾਲ", 6);
    freq.put(" ਚੱ", 27);
    freq.put("ਾਣਕ", 4);
    freq.put("ਾਣਗ", 7);
    freq.put("ਕਾ ", 64);
    freq.put(" ਚੌ", 5);
    freq.put("ਮਨੇ", 3);
    freq.put("ੀਅਨ", 3);
    freq.put(" ਚੈ", 10);
    freq.put(" ਚੋ", 64);
    freq.put("ਤੂ", 149);
    freq.put("ੀਅਤ", 6);
    freq.put(" ਚੇ", 16);
    freq.put("ਖੂਨ", 5);
    freq.put(" ਚੁ", 29);
    freq.put(" ਚੀ", 20);
    freq.put("ਾਣਦ", 6);
    freq.put("ਖੂਬ", 7);
    freq.put("ਣਦਾ", 8);
    freq.put(" ਚੜ", 21);
    freq.put("ਭਾਜ", 8);
    freq.put("ੀਅਹ", 3);
    freq.put("ਾਣਾ", 29);
    freq.put("ੈਕਟ", 6);
    freq.put("ੀਅਰ", 4);
    freq.put("ਸਕਾ", 6);
    freq.put("ਭਾਗ", 4);
    freq.put("ਚੋ", 83);
    freq.put("ਜੇਹ", 6);
    freq.put("ਨਜ਼", 3);
    freq.put("े", 6);
    freq.put(" ਚਪ", 4);
    freq.put("ਜੇਲ", 12);
    freq.put("ਉਸਦ", 9);
    freq.put("ੇਚ", 13);
    freq.put("ਾਣੇ", 21);
    freq.put("ੁਸ ", 3);
    freq.put(" ਚਾ", 84);
    freq.put(" ਚਹ", 5);
    freq.put("ਆਏ ", 8);
    freq.put("ੱਖ", 235);
    freq.put("ਜੇਠ", 3);
    freq.put("ਰਸ ", 22);
    freq.put(" ਚਰ", 13);
    freq.put(" ਚਲ", 35);
    freq.put("ਣਨ ", 4);
    freq.put("ਵਾਰ", 93);
    freq.put("ਤੀ", 155);
    freq.put("ਂਨੂ", 8);
    freq.put("ੁਆਫ", 3);
    freq.put("ੁਨਾ", 4);
    freq.put("ਧੜ", 10);
    freq.put("ਈਏ", 16);
    freq.put("ਵਾਲ", 158);
    freq.put("ਜੇਕ", 6);
    freq.put("ੱ", 2186);
    freq.put("ਧੂ", 15);
    freq.put("ਧੁ", 6);
    freq.put("ਧੀ", 25);
    freq.put(" ਚਕ", 3);
    freq.put("ੁਆਵ", 6);
    freq.put("ੁਆਰ", 10);
    freq.put("ਤੁ", 75);
    freq.put("ਹੈਨ", 6);
    freq.put("ਖੀਆ", 16);
    freq.put("ਿਸ਼ਤ", 8);
    freq.put(" ਜੰ", 18);
    freq.put("ਿੳ ", 3);
    freq.put("ਿਸ਼ਨ", 4);
    freq.put("ਬਦਲ", 25);
    freq.put("ਜੁੱ", 4);
    freq.put("ੈਗਾ", 4);
    freq.put("ੇਅਰ", 4);
    freq.put("ਇਥੇ", 7);
    freq.put("ਵੱਜ", 4);
    freq.put("ਵੱਟ", 7);
    freq.put("ਹੈਲ", 3);
    freq.put("ਤੇਜ਼", 3);
    freq.put("ੋਗਾ", 3);
    freq.put("ਗਰੇ", 8);
    freq.put("ਿਸ਼ਾ", 3);
    freq.put("ਰੇਜ਼", 3);
    freq.put("ਗਰੂ", 4);
    freq.put("ਵੱਖ", 13);
    freq.put("੍ਕ", 3);
    freq.put("ਉਜ", 4);
    freq.put("ਐਂ", 7);
    freq.put("ਹੈਂ", 7);
    freq.put(" ਜੜ", 5);
    freq.put("ਾਡਾ", 33);
    freq.put("ਵੱਧ", 13);
    freq.put(" ਜੇ", 132);
    freq.put("ਵੱਸ", 7);
    freq.put(" ਜੂ", 6);
    freq.put(" ਜੁ", 17);
    freq.put("ੱਭਰ", 4);
    freq.put("ੱਬੇ", 8);
    freq.put("ਈ ", 537);
    freq.put("ਵੱਲ", 19);
    freq.put("ੱਬੂ", 9);
    freq.put("ਹੈਗ", 4);
    freq.put("ੱਬੀ", 4);
    freq.put(" ਜੈ", 8);
    freq.put("ੱਬਾ", 21);
    freq.put(" ਜਵ", 27);
    freq.put("ਨੱ", 11);
    freq.put("ਰੇਂ", 4);
    freq.put(" ਜਲ", 8);
    freq.put("ਈਂ", 6);
    freq.put(" ਜਰ", 23);
    freq.put(" ਜਿ", 267);
    freq.put(" ਜਾ", 373);
    freq.put(" ਜ਼", 41);
    freq.put("ਜੁਰ", 3);
    freq.put("ੱਬਰ", 3);
    freq.put(" ਜਸ", 5);
    freq.put("ਰੇਖ", 4);
    freq.put(" ਜਦ", 84);
    freq.put("ਾਡੀ", 38);
    freq.put(" ਜਤ", 6);
    freq.put("ੱਭ ", 12);
    freq.put("ਾਡੇ", 63);
    freq.put("ਕਫਨ", 3);
    freq.put(" ਜਮ", 9);
    freq.put("ਜੁਦ", 3);
    freq.put(" ਜਬ", 5);
    freq.put("ਛੇੜ", 5);
    freq.put("ਓਥ", 3);
    freq.put(" ਜਨ", 25);
    freq.put(" ਜਗ", 14);
    freq.put(" ਜਖ", 6);
    freq.put("ਗਰਾ", 7);
    freq.put("ਬੀਬ", 7);
    freq.put("ਗਰਸ", 16);
    freq.put("ੁਣ", 90);
    freq.put("ਬੀਨ", 4);
    freq.put("ਰੇਮ", 6);
    freq.put("ਦੋਂ", 42);
    freq.put("ਜੁਗ", 4);
    freq.put("ਰੇਪ", 4);
    freq.put("ਧਵਾ", 3);
    freq.put("ਰੇਸ਼", 5);
    freq.put("ਜਰੇ", 5);
    freq.put("ਗਰਮ", 10);
    freq.put("ਥਾ", 30);
    freq.put("ਰੇਲ", 6);
    freq.put("ੴ", 10);
    freq.put("ਓਂ", 6);
    freq.put("ਾਉ ", 20);
    freq.put("ਟਨ ", 4);
    freq.put("ਮੀ ", 45);
    freq.put("ੀਟ ", 3);
    freq.put("ਬੀਰ", 15);
    freq.put("ਦੰ", 6);
    freq.put("ਮਜੀ", 5);
    freq.put("ਨਵਜ", 4);
    freq.put("ਰਜ ", 9);
    freq.put("उ", 3);
    freq.put("ੱਖ ", 104);
    freq.put("ਾਟ ", 4);
    freq.put("ਜਾਰ", 12);
    freq.put("ਜਾਲ", 4);
    freq.put("ਚੰਨ", 7);
    freq.put("ੁੰਦ", 164);
    freq.put("ਜਾਮ", 5);
    freq.put("ਜਾਨ", 46);
    freq.put("ਜਾਪ", 3);
    freq.put("ਚੰਡ", 5);
    freq.put("ਜਾਤ", 4);
    freq.put("ਜਾਦ", 18);
    freq.put("ਿਨ ", 52);
    freq.put("ੱਭਣ", 10);
    freq.put("ਟ", 565);
    freq.put("ਚੰਦ", 13);
    freq.put("ੋਕਾ", 19);
    freq.put("ਵਪਾ", 8);
    freq.put("ੇਗਾ", 32);
    freq.put("ਜਾਕ", 3);
    freq.put("ਜਾਗ", 7);
    freq.put("ਇਥ", 8);
    freq.put("ਚੰਗ", 26);
    freq.put("ਥਰ", 11);
    freq.put("ਦੀ", 917);
    freq.put("ਦੁ", 113);
    freq.put("ਜਾਏ", 9);
    freq.put("ਛ ", 7);
    freq.put("ਜਾਉ", 8);
    freq.put("ਜਾਈ", 12);
    freq.put("੍ਯ", 3);
    freq.put("ਦੇ", 986);
    freq.put("ਦੈ", 12);
    freq.put("ੋਕਦ", 3);
    freq.put("ਜਾਇ", 7);
    freq.put("ੱਭਦ", 7);
    freq.put("ਦੌ", 16);
    freq.put(" ਰਹ", 116);
    freq.put("ਈਆ", 23);
    freq.put("ਜਾਂ", 111);
    freq.put("ਖਣ ", 12);
    freq.put("ਦਲ", 61);
    freq.put("ੀਆ", 426);
    freq.put("ਦਵ", 11);
    freq.put("ੀਅ", 20);
    freq.put("ਦਸ", 21);
    freq.put("ਦਹ", 5);
    freq.put("ਡੀ ", 87);
    freq.put("ਵਾਗ", 11);
    freq.put("ੀਏ", 78);
    freq.put("ਦਾ", 1053);
    freq.put("ਦਿ", 341);
    freq.put("ੀਓ", 40);
    freq.put("ੀਐ", 5);
    freq.put("ਠੇਕ", 3);
    freq.put("ਦਤ", 17);
    freq.put("ੀਗ", 5);
    freq.put("ਦਦ", 4);
    freq.put("ੀਕ", 48);
    freq.put("ਸੁ ", 7);
    freq.put("ਦਫ", 6);
    freq.put("ਰਣ", 10);
    freq.put("ੀਟ", 11);
    freq.put("ੀਜ", 17);
    freq.put("ੋਕੀ", 8);
    freq.put("ੰਡੀ", 26);
    freq.put("ੀਠ", 7);
    freq.put("ੀਡ", 43);
    freq.put("ੀਦ", 49);
    freq.put("ਉਲਝ", 3);
    freq.put("ੀਤ", 120);
    freq.put("ਦਗ", 71);
    freq.put("ੀਪ", 5);
    freq.put("ੱਸਾ", 11);
    freq.put("ੀਨ", 52);
    freq.put("ਤੈ ", 4);
    freq.put("ੀਮ", 22);
    freq.put("ਆਦਾ", 15);
    freq.put("ਕਹਿ", 108);
    freq.put("ਕਹਾ", 9);
    freq.put("ੀਲ", 18);
    freq.put("ਪਸ ", 6);
    freq.put("ੀਰ", 89);
    freq.put("ੀਸ਼", 3);
    freq.put("ੀਵ", 23);
    freq.put("ੀਸ", 18);
    freq.put("਼ਬਰ", 3);
    freq.put("ਮਜ਼", 3);
    freq.put("ਣੀਆ", 17);
    freq.put("ਮਜਾ", 3);
    freq.put("๋ ", 3);
    freq.put(" ਲੱ", 136);
    freq.put(" ਲੰ", 29);
    freq.put("ਭਰ ", 11);
    freq.put("ਣਗੇ", 27);
    freq.put("ਊ", 32);
    freq.put("ੋਹੇ", 4);
    freq.put("ਨੂ ", 55);
    freq.put("ਿਉ", 59);
    freq.put("→ㅤㅤ", 3);
    freq.put("ਕੇਹ", 9);
    freq.put("ਕੇਸ", 10);
    freq.put("ੌਕਾ", 5);
    freq.put("ਜ਼ਖ", 3);
    freq.put("ਚੈ", 11);
    freq.put("ੂਣ", 4);
    freq.put("ਅੰਤ", 4);
    freq.put("ੁਣੇ", 4);
    freq.put("਼ਾਹ", 6);
    freq.put("ਨੋ", 17);
    freq.put("हैं", 3);
    freq.put("ਕੇਂ", 6);
    freq.put("ਆਬਾ", 3);
    freq.put("਼ਾਰ", 8);
    freq.put("ਉਂਕ", 3);
    freq.put("ਿੱਖ", 33);
    freq.put("ਸਮ ", 9);
    freq.put(" ਲੇ", 18);
    freq.put("ਟੋਲ", 4);
    freq.put("ਗਜ਼", 4);
    freq.put("਼ਾਨ", 11);
    freq.put(" ਲੈ", 94);
    freq.put("ਜੋ ", 82);
    freq.put(" ਲਵ", 16);
    freq.put("ਣੋ", 5);
    freq.put("ੂਬ", 11);
    freq.put("ਜੂ ", 6);
    freq.put("ै", 6);
    freq.put(" ਲਿ", 61);
    freq.put(" ਲਾ", 103);
    freq.put(" ਲਹ", 5);
    freq.put("ਲਗ ", 7);
    freq.put("ਤ ", 437);
    freq.put("ਦਲਾ", 5);
    freq.put("ਫ਼ਤ", 4);
    freq.put("ਬੇਲ", 5);
    freq.put("ਜੀ।", 3);
    freq.put(" ਲਫ", 3);
    freq.put(" ਲਕ", 3);
    freq.put(" ਲਗ", 44);
    freq.put(" ਲਖ", 8);
    freq.put(" ਲਓ", 4);
    freq.put("ਇਹ ", 69);
    freq.put("ੋਹਣ", 38);
    freq.put("ਜ਼ਮ ", 5);
    freq.put("ਨੀਂ", 14);
    freq.put("ਲਓ ", 4);
    freq.put("ਨੇ", 403);
    freq.put("ਆਹ ", 21);
    freq.put("ਵਾਇ", 5);
    freq.put("ੋਹਿ", 5);
    freq.put("ੋਹਾ", 5);
    freq.put("ਮਾਇ", 4);
    freq.put(" ਲਏ", 7);
    freq.put("ਵੀਡ", 36);
    freq.put("ਦੇ ", 799);
    freq.put(" ਲਈ", 109);
    freq.put("٠·", 4);
    freq.put("ੀਤਮ", 3);
    freq.put(" ਤ੍", 5);
    freq.put(" ਤੌ", 8);
    freq.put(" ਤੋ", 204);
    freq.put("ਿਕਾ", 27);
    freq.put("ਗਲਵ", 4);
    freq.put(" ਤੈ", 48);
    freq.put(" ਤੇ", 673);
    freq.put("ਿਕਲ", 17);
    freq.put("ਾਂਡ", 5);
    freq.put("ਿਕਰ", 18);
    freq.put("ਾਂਧ", 5);
    freq.put("ਾਂਦ", 93);
    freq.put(" ਤੁ", 70);
    freq.put("ਾਂਤ", 4);
    freq.put("ੀਤਿ", 4);
    freq.put("ੀਤਾ", 45);
    freq.put("ਾਂਹ", 4);
    freq.put("ਾਂਸ", 8);
    freq.put("ਰੁਲ", 3);
    freq.put("ਣਜ", 3);
    freq.put("ਥੋਡ", 4);
    freq.put("੍ਹ ", 16);
    freq.put("ਿਕਦ", 10);
    freq.put("ਾਂਵ", 10);
    freq.put("ਰਲ ", 3);
    freq.put("ਕੜ", 16);
    freq.put("ਪਹੁ", 11);
    freq.put("ਾਂਈ", 4);
    freq.put("ुद", 3);
    freq.put("ੱਦਾ", 6);
    freq.put("ੁਰੇ", 4);
    freq.put("ਕ੍", 10);
    freq.put("੍ਰੰ", 4);
    freq.put("ਵ", 1966);
    freq.put("ਕੈ", 31);
    freq.put("ਾਂਝ", 7);
    freq.put("ਾਂਜ", 3);
    freq.put("ਰਚ", 14);
    freq.put("ਾਂਗ", 59);
    freq.put("।।", 6);
    freq.put(" ਤੱ", 27);
    freq.put("ㅤㅤㅤ", 69);
    freq.put("ਡ", 611);
    freq.put("ਕਿ", 425);
    freq.put("ਕਾ", 370);
    freq.put("ਕਹ", 127);
    freq.put("ਕਸ", 23);
    freq.put(" ਮ ", 3);
    freq.put("ਨਿਕ", 19);
    freq.put("ਕਵ", 4);
    freq.put("ਜਣ", 27);
    freq.put("ੂਕ", 9);
    freq.put("ਕਸ਼", 12);
    freq.put("ਕਰ", 510);
    freq.put("ਕਲ", 68);
    freq.put("ਕਬ", 12);
    freq.put("ਕਮ", 58);
    freq.put("ਲਵ", 33);
    freq.put("ਕਫ", 5);
    freq.put("ਕਪ", 5);
    freq.put("ਕਤ", 30);
    freq.put(" ਤਕ", 21);
    freq.put("ਕਦ", 161);
    freq.put("ਡਰਦ", 8);
    freq.put("ਕਠ", 8);
    freq.put("ਭਲਾ", 4);
    freq.put("ਕ੍ਰ", 8);
    freq.put(" ਤਮ", 3);
    freq.put("ਪੱਥ", 4);
    freq.put(" ਤਬ", 6);
    freq.put("●๋", 3);
    freq.put("ਸਿ ", 4);
    freq.put("ਚਹੁ", 4);
    freq.put("ੀਤੇ", 14);
    freq.put("ਰਾਮ", 21);
    freq.put("ਨਣਾ", 3);
    freq.put("ਿੰਘ", 35);
    freq.put("ੀਤੀ", 24);
    freq.put(" ਤਿ", 35);
    freq.put(" ਤਾ", 332);
    freq.put("ਝਣ", 7);
    freq.put("ਕਉ", 8);
    freq.put("ਕਈ", 16);
    freq.put(" ੧ ", 6);
    freq.put(" ਤਸ", 8);
    freq.put("ਵੇਟ", 3);
    freq.put("ਕਇ", 3);
    freq.put("ਡੱ", 4);
    freq.put(" ਤਲ", 4);
    freq.put(" ਤਰ", 33);
    freq.put("ਵੀਟ", 5);
    freq.put("ਖਾੜ", 5);
    freq.put("ਵੀਚ", 3);
    freq.put("ਬੇੜ", 3);
    freq.put("ਜੀਹ", 3);
    freq.put("ਲੋੜ", 18);
    freq.put("ਈ", 629);
    freq.put("ਜੀਵ", 4);
    freq.put("ੌਕੇ", 3);
    freq.put(" ਛਾ", 12);
    freq.put(" ਛਿ", 5);
    freq.put("ੇਂਗ", 7);
    freq.put("ਥਿ", 7);
    freq.put(" ਛਡ", 8);
    freq.put("ਬੇਟ", 4);
    freq.put("ਜੀਨ", 7);
    freq.put("ਜਣਾ", 14);
    freq.put("ਾਸ਼ਾ", 4);
    freq.put("ਹਜ਼", 4);
    freq.put("ਜੀਤ", 13);
    freq.put("ਵੀਂ", 17);
    freq.put("ਬੇਗ", 9);
    freq.put("ੜੀਆ", 39);
    freq.put("ਜੀਠ", 5);
    freq.put("ੇਂਦ", 12);
    freq.put("ਬੇਨ", 4);
    freq.put("ਜੀਜ", 3);
    freq.put("ੁਪਾ", 3);
    freq.put("ਬੇਬ", 10);
    freq.put("ੈਦੀ", 6);
    freq.put("ਨਦ", 10);
    freq.put("ਬੇਠ", 3);
    freq.put("ੂਰਾ", 6);
    freq.put("ਵੀਰ", 20);
    freq.put("ਪਏ ", 8);
    freq.put("ਬੇਹ", 3);
    freq.put("ਝ ", 112);
    freq.put("ਭੰਗ", 3);
    freq.put("ਾਸ਼ਟ", 6);
    freq.put("ਜੀਆ", 4);
    freq.put("ਬੇਸ਼", 4);
    freq.put("ਕੋ ", 15);
    freq.put("ਤੰਗ", 6);
    freq.put("ਲੋਕ", 62);
    freq.put(" ਛੰ", 3);
    freq.put("ੱਖੇ", 10);
    freq.put("ਥੌ", 5);
    freq.put("ੈ", 964);
    freq.put("ㅤㅤ", 88);
    freq.put("ਕਬੱ", 3);
    freq.put("ੁਸ", 57);
    freq.put("ਾਜ਼ਮ", 3);
    freq.put("ਗਣਾ", 4);
    freq.put("ੌਕੀ", 4);
    freq.put("ਧਨੁ", 4);
    freq.put("ਲੋਂ", 36);
    freq.put("ਰਾਰ", 4);
    freq.put("੍ਹਦ", 3);
    freq.put("ਮਨੁ", 7);
    freq.put("ਥੱ", 9);
    freq.put("ਆਣਾ", 9);
    freq.put("ੇਪ ", 5);
    freq.put("ਠੀਆ", 13);
    freq.put("ਵਫਾ", 13);
    freq.put("ਵਫ਼", 3);
    freq.put("ੇਜ਼", 4);
    freq.put("ਥੋ", 38);
    freq.put("ਗਣਗ", 4);
    freq.put("ੇਜਿ", 4);
    freq.put("ੀਮ ", 9);
    freq.put("ਥੇ", 66);
    freq.put("ਲੋਹ", 4);
    freq.put("ਰਜ", 53);
    freq.put("ਚੱ", 27);
    freq.put(" ਛੁ", 9);
    freq.put(" ਛੇ", 6);
    freq.put("ੜਗੀ", 3);
    freq.put(" ਛੋ", 7);
    freq.put("ੁਝਾ", 3);
    freq.put("ਆਣਿ", 3);
    freq.put("ਲੋਨ", 5);
    freq.put("ੇਜਦ", 3);
    freq.put("ਸ਼ਵ", 4);
    freq.put("ਦਗਾ", 3);
    freq.put("ਿੰਤ", 4);
    freq.put("ਮੁ ", 8);
    freq.put("ਸਰ", 101);
    freq.put("ਮੇਲ", 12);
    freq.put("ਮਿਆ", 3);
    freq.put("ਰਪਤ", 8);
    freq.put(" ਬਥ", 12);
    freq.put("ਵਹਿ", 6);
    freq.put("ਨਗ", 13);
    freq.put("ਬਣਦ", 7);
    freq.put("ਾ ", 3094);
    freq.put("ੇਵ ", 4);
    freq.put("ਰਪਾ", 8);
    freq.put("ਟੈਨ", 3);
    freq.put("ਹਰੇ", 14);
    freq.put("ਬਲ ", 3);
    freq.put("ੀੜ੍", 3);
    freq.put("ਨਕ", 31);
    freq.put("ੇਲ", 82);
    freq.put("ਬਣਨ", 4);
    freq.put("ਿੰਡ", 25);
    freq.put("ਬਣਕ", 4);
    freq.put("ਤੇਜ", 3);
    freq.put(" ਿੲ", 3);
    freq.put("ਨਈ", 18);
    freq.put("ੋਧ ", 8);
    freq.put("ਲ਼", 7);
    freq.put("ਡਾ ", 87);
    freq.put("रत", 4);
    freq.put("ਇਆਂ", 3);
    freq.put("ਹਾਗ", 3);
    freq.put("ਬਿੱ", 10);
    freq.put("ਿੰਮ", 4);
    freq.put("ੁਰਸ", 6);
    freq.put("ਕੈਦ", 7);
    freq.put(" ਿਜ", 5);
    freq.put("ੁਣ ", 63);
    freq.put("ਸ਼ਟਰ", 6);
    freq.put("ਿੱਚ", 116);
    freq.put("ੰਜ ", 10);
    freq.put("ਕੈਮ", 3);
    freq.put("ਗੋ ", 5);
    freq.put("ਕੈਪ", 3);
    freq.put("ਕੈਨ", 4);
    freq.put("ੱਜਣ", 21);
    freq.put("ਂਗ ", 9);
    freq.put("ਾਜ ", 20);
    freq.put("ਕੈਲ", 3);
    freq.put("ਢਿਆ", 3);
    freq.put("ਭਗਤ", 4);
    freq.put(" ↓↓", 7);
    freq.put(" ਬਨ", 8);
    freq.put("ੁਲੇ", 10);
    freq.put("ਵੜਗ", 3);
    freq.put("ੋਰ", 109);
    freq.put("ੇਨਤ", 3);
    freq.put("ਕੈਂ", 4);
    freq.put("ਮਝ ", 18);
    freq.put("ਪਰੋ", 3);
    freq.put("ੂਨ ", 7);
    freq.put("ਹਰਾ", 4);
    freq.put("ਹਰਿ", 11);
    freq.put("ਤਨ ", 6);
    freq.put("ਵਹੁ", 3);
    freq.put("ੀਂ", 236);
    freq.put("ੳ", 19);
    freq.put("ਖਲ ", 3);
    freq.put(" ਿਪ", 3);
    freq.put("ੜਾਈ", 9);
    freq.put("ਬਣੀ", 5);
    freq.put("ੋਏ ", 17);
    freq.put(" ਿਦ", 5);
    freq.put("ਂਸੀ", 3);
    freq.put("ਨਅ", 3);
    freq.put("ਹਰਬ", 5);
    freq.put("ਫੀਕ", 3);
    freq.put("ੋਰਨ", 3);
    freq.put("ਨੂਂ", 5);
    freq.put(" ਸਵ", 35);
    freq.put("ੈਡਮ", 6);
    freq.put("ਯੂ", 4);
    freq.put("ਡੇ ", 105);
    freq.put("ੁਲੀ", 4);
    freq.put("ਇਮ ", 4);
    freq.put("ਓਹੀ", 5);
    freq.put("ਵਰ ", 7);
    freq.put(" ਬਾ", 152);
    freq.put("ੋਨੀ", 5);
    freq.put("ਹਦਾ", 12);
    freq.put("ੋਕਰ", 3);
    freq.put("ਿੱਡ", 3);
    freq.put("ੋਨੇ", 5);
    freq.put("ਘਰੋ", 5);
    freq.put("ਫੇਰ", 20);
    freq.put("ਸਜ਼", 3);
    freq.put("ਮੁੱ", 61);
    freq.put("ੜਨ", 15);
    freq.put("ੜਿਆ", 8);
    freq.put("ਫੇਸ", 13);
    freq.put("ਘਰੁ", 3);
    freq.put("ਲੀਆ", 27);
    freq.put("ਘਰੇ", 3);
    freq.put("ੈਂ ", 122);
    freq.put("ਬਣਾ", 42);
    freq.put("ਪਥ", 4);
    freq.put("ਰਧ", 12);
    freq.put(" ਬਹ", 84);
    freq.put("ੜ੍ਹ", 31);
    freq.put(" ਆਸ", 17);
    freq.put("ਫੜ ", 6);
    freq.put(" ਬਸ", 22);
    freq.put("ਠੱਗ", 4);
    freq.put("ਿਚੋ", 7);
    freq.put("ਹੋ ", 101);
    freq.put("ਈਕ ", 4);
    freq.put("ੁਲਕ", 5);
    freq.put("ਿਨ", 127);
    freq.put("ਿਚਾ", 12);
    freq.put("ਖਾਕ", 3);
    freq.put("ਹੈ।", 5);
    freq.put("ੈਦ ", 3);
    freq.put("ति", 4);
    freq.put("੨੨", 4);
    freq.put("ਇਕਠ", 3);
    freq.put("ਘਰਾ", 6);
    freq.put("ੈਨੀ", 6);
    freq.put("ਕੁਸ਼", 3);
    freq.put("ਘਰਵ", 4);
    freq.put("ਫ਼", 23);
    freq.put("ਤਿਗ", 7);
    freq.put("ਹਦੇ", 27);
    freq.put("ਹਦੀ", 26);
    freq.put("ㅤ", 108);
    freq.put("ਖੜਾ", 10);
    freq.put("ੈਡੀ", 4);
    freq.put("ਥਾ ", 4);
    freq.put("ੁਲਾ", 29);
    freq.put("ੁਲਿ", 6);
    freq.put("ਸ਼ਬ", 3);
    freq.put("ਵਕਤ", 9);
    freq.put("ੂਹੀ", 4);
    freq.put("ਖੜਦ", 3);
    freq.put("ਗਇ", 3);
    freq.put("ੂੰ ", 706);
    freq.put("ੀਕਾ", 11);
    freq.put("ਚਦਾ", 4);
    freq.put("ਮਣੇ", 7);
    freq.put("ਉ", 670);
    freq.put("ੇਜੀ", 4);
    freq.put("ਸਰੀ", 4);
    freq.put("ਸਰੇ", 6);
    freq.put("ਿਤੇ", 15);
    freq.put("ਕਮ ", 5);
    freq.put("ਮੌਕ", 6);
    freq.put("ਗਜ", 10);
    freq.put("ੂਨ", 7);
    freq.put("ਂਕਿ", 4);
    freq.put("ਯੁ", 3);
    freq.put("ੱਕਰ", 14);
    freq.put("ੱਕਲ", 4);
    freq.put("ਇਸ ", 43);
    freq.put("ੀ।", 5);
    freq.put(" ਬਖ", 6);
    freq.put("ਗਮ", 20);
    freq.put("ਭਦੀ", 3);
    freq.put("ੋਣਾ", 17);
    freq.put("ੱਕਾ", 6);
    freq.put("ੱਕਠ", 3);
    freq.put("ੱਕਣ", 9);
    freq.put("ਿੰਗ", 18);
    freq.put("ਗਲ", 63);
    freq.put("ੱਕਦ", 7);
    freq.put("ਗਿ", 116);
    freq.put("ਗਾ", 181);
    freq.put("ਧੋ", 17);
    freq.put(" ਆਮ", 4);
    freq.put("ਡਰ", 24);
    freq.put("ਾਰ ", 327);
    freq.put("ਗਹ", 5);
    freq.put("ਚਹ", 6);
    freq.put("ਗੇ", 124);
    freq.put("ੇਜ ", 23);
    freq.put("ੁਖਾ", 3);
    freq.put("ਗੂ", 20);
    freq.put("ਗੁ", 159);
    freq.put("ਗੀ", 207);
    freq.put(" ਜ਼ਾ", 3);
    freq.put("ਗ੍", 23);
    freq.put("ਗੌ", 3);
    freq.put("ਗੋ", 24);
    freq.put("ੱਕੜ", 3);
    freq.put("ਚੋਂ", 33);
    freq.put("ੀ। ", 5);
    freq.put("ੁਖਬ", 12);
    freq.put("ੱਕੀ", 11);
    freq.put("ੱਸ", 107);
    freq.put("ੱਕੇ", 8);
    freq.put("ਚਵ", 3);
    freq.put("ਕੁਝ", 50);
    freq.put("ਈਆਂ", 16);
    freq.put("ਿਣ", 44);
    freq.put("ਸਰਕ", 32);
    freq.put("ੌਸਲ", 4);
    freq.put("ਿੰਟ", 9);
    freq.put(" ਆਗ", 7);
    freq.put("ਪਣ", 108);
    freq.put("ਸਰਬ", 5);
    freq.put("ੁਰਦ", 9);
    freq.put("ਗੁਨ", 3);
    freq.put("ਸਰਦ", 21);
    freq.put("ਸ਼ਰ", 24);
    freq.put("ੂਂ ", 6);
    freq.put("ਿਤਸ", 6);
    freq.put("ਆਵੇ", 9);
    freq.put(" ਸ੍", 9);
    freq.put("ਚਲ", 36);
    freq.put("ਿਤਾ", 25);
    freq.put("ਗੰ", 11);
    freq.put("ਿਤਰ", 7);
    freq.put("ਆਦਤ", 8);
    freq.put("ਚਦੀ", 3);
    freq.put("ਚਦੇ", 3);
    freq.put("ਹਨ ", 31);
    freq.put("ਸਰਵ", 3);
    freq.put("ਾਈਕ", 8);
    freq.put("ੇਖ", 123);
    freq.put("ਭੇ", 26);
    freq.put("ਭੁ", 69);
    freq.put("ਭੀ", 4);
    freq.put("ੰਧ ", 3);
    freq.put("ਚੀਮ", 3);
    freq.put("ੇਟ", 27);
    freq.put("ਖਬੀ", 12);
    freq.put("ਾਈਟ", 4);
    freq.put("ਰਨ ", 73);
    freq.put("ਫੋਟ", 10);
    freq.put("ਭੋ", 11);
    freq.put("ੇਆ", 18);
    freq.put(" ਸੌ", 14);
    freq.put("ਾਈਆ", 9);
    freq.put("ੇਂ", 94);
    freq.put("ਚਿਆ", 11);
    freq.put("ा ", 6);
    freq.put("ਭੜ", 4);
    freq.put("ਾਈਏ", 7);
    freq.put("ਿਟਾ", 3);
    freq.put("ੁਕਣ", 5);
    freq.put("ੁਝੇ", 4);
    freq.put("ੇਈ", 4);
    freq.put("ਚਿਰ", 6);
    freq.put("ੇਸ਼", 31);
    freq.put("ਆਰੇ", 13);
    freq.put("ੁਡਾ", 5);
    freq.put("ਰਹਾ", 10);
    freq.put("ੇਰ", 498);
    freq.put("ਜਸ", 8);
    freq.put("ਚਿਹ", 4);
    freq.put("ਕ਼ ", 6);
    freq.put("ਰਹਿ", 51);
    freq.put("ਬ", 1546);
    freq.put("ੇਹ", 35);
    freq.put("ਚੀਆ", 7);
    freq.put("ੇਦ", 12);
    freq.put("ੇਤ", 31);
    freq.put("ਚਿਤ", 3);
    freq.put("ਚੀਜ", 9);
    freq.put("ੇਡ", 29);
    freq.put("ਲਸਾ", 8);
    freq.put("ੇਯ", 4);
    freq.put("ੇਮ", 11);
    freq.put(" ੨ ", 7);
    freq.put("ਾਈਨ", 4);
    freq.put("ਡਾਰ", 6);
    freq.put("ੇਨ", 28);
    freq.put("ਆਰਥ", 5);
    freq.put("ਂਧੀ", 5);
    freq.put("ਐਨੀ", 5);
    freq.put("ੀਰੀ", 4);
    freq.put("ਂਉਦ", 3);
    freq.put("ਫਿਰ", 44);
    freq.put("ਇੱਥ", 7);
    freq.put("ੇੜ", 26);
    freq.put("ੇਜ਼", 7);
    freq.put("ੱਸ ", 47);
    freq.put("ੇਖ਼", 4);
    freq.put("ਂਗੂ", 8);
    freq.put("ਭਗ", 7);
    freq.put("ਸ਼ਾਂ", 4);
    freq.put("ੌਸਮ", 3);
    freq.put("ੰਹ ", 11);
    freq.put("ਲੈਦ", 5);
    freq.put("ਆਰਿ", 3);
    freq.put("ਆਰਾ", 12);
    freq.put("ੈਰ ", 21);
    freq.put("ੇਣ", 37);
    freq.put("ਚਿੰ", 4);
    freq.put("ਚਿੱ", 10);
    freq.put("ਤਮਾ", 4);
    freq.put("ੰਚਾ", 7);
    freq.put("ਭਣ", 10);
    freq.put("ਣਵ", 3);
    freq.put("ਹਲ ", 3);
    freq.put("ੱਟੀ", 15);
    freq.put("ਸ਼ਾਹ", 8);
    freq.put("ਇੱਟ", 3);
    freq.put("ਇੱਜ", 4);
    freq.put("ਭਰ", 52);
    freq.put("ਭਲ", 6);
    freq.put("ਖਬਰ", 6);
    freq.put("ਇੱਕ", 89);
    freq.put("ਭਾ", 106);
    freq.put("ੋਕੇ", 8);
    freq.put("ਵ ", 15);
    freq.put("ਸ਼ਾਨ", 7);
    freq.put("ੋਣੇ", 3);
    freq.put("ਾਬੀ", 28);
    freq.put("ਾਬੂ", 6);
    freq.put(" ღ", 3);
    freq.put("ਦਰੀ", 4);
    freq.put("ਾਬੇ", 4);
    freq.put("ੋਖੇ", 10);
    freq.put("ਉਤੇ", 6);
    freq.put("ਸਭੁ", 3);
    freq.put("ਰੰਭ", 3);
    freq.put("ਸ਼੍", 4);
    freq.put("ਹੇਗ", 7);
    freq.put("ਅਕਾ", 17);
    freq.put("ਸੀਨ", 7);
    freq.put("ਤਸ", 16);
    freq.put("ਤੇਨ", 14);
    freq.put("ਗ", 1538);
    freq.put("ਸੀਬ", 6);
    freq.put("ਾਪ", 59);
    freq.put("ਤਿ ", 19);
    freq.put("ਸ਼ੁੱ", 3);
    freq.put("ਨਿਸ਼", 3);
    freq.put(" ਵਧ", 21);
    freq.put("ਨਿਰ", 5);
    freq.put("ਨਿਸ", 4);
    freq.put("ਾਲੋ", 14);
    freq.put("ਰਾ ", 216);
    freq.put("ੱਖਿ", 18);
    freq.put("ਰੇਜ", 6);
    freq.put("ਹੇਲ", 16);
    freq.put("ਬੋਲ", 28);
    freq.put("ਜਬ", 11);
    freq.put("ਨਿਮ", 5);
    freq.put("ਠਾ ", 34);
    freq.put("ਨਿਭ", 13);
    freq.put("ਰੰਟ", 3);
    freq.put("ਸੀਆ", 3);
    freq.put("ੀਡ ", 4);
    freq.put("ਘਾ ", 3);
    freq.put("ਰੂਰ", 30);
    freq.put(" ਮੈ", 262);
    freq.put("ੋਜ਼", 3);
    freq.put("ੋਜਾ", 3);
    freq.put("ਇ ", 14);
    freq.put("ਰੂਹ", 14);
    freq.put("ਠੀ", 34);
    freq.put("ੈਠੇ", 7);
    freq.put("ਰੂਤ", 4);
    freq.put("ਜ ", 183);
    freq.put("ਦਰਜ", 5);
    freq.put("ਸ਼ੁਰ", 5);
    freq.put("ਵਲੋ", 9);
    freq.put("ੋਜਨ", 5);
    freq.put(" ਢਿ", 3);
    freq.put("ਇਬਾ", 3);
    freq.put("ਰੂਪ", 9);
    freq.put("ਲੱਖ", 30);
    freq.put("ਲੱਗ", 71);
    freq.put("ਾਬਣ", 3);
    freq.put("ਲੱਕ", 4);
    freq.put("ਨਿੰ", 3);
    freq.put("ਨਿੱ", 16);
    freq.put("ਦਰਬ", 6);
    freq.put("ਘਟਨ", 3);
    freq.put("ੈਲੀ", 6);
    freq.put("ਫਰਤ", 6);
    freq.put("ਸਭਾ", 7);
    freq.put("ਦਰਸ਼", 4);
    freq.put("ੋਜ਼ ", 4);
    freq.put("ਸ ", 333);
    freq.put(" ਮੀ", 17);
    freq.put("ਘਟਾ", 3);
    freq.put("ਦਰਾ", 9);
    freq.put("ਾਏ ", 30);
    freq.put("ਨੁਕ", 3);
    freq.put("ਾਬਾ", 14);
    freq.put("ਕਰਮ", 13);
    freq.put("ਂ", 2559);
    freq.put("ੰਝ ", 4);
    freq.put("ਕਰਨ", 63);
    freq.put("ਾਲਜ", 5);
    freq.put("ਕਰਦ", 109);
    freq.put(" ਉੱ", 55);
    freq.put("ਕਰਤ", 13);
    freq.put("ੀਸ਼", 3);
    freq.put("ਾਲਗ", 5);
    freq.put("ਾਲਕ", 6);
    freq.put("ਤੂ ", 15);
    freq.put("ਕਰਾ", 22);
    freq.put("ਕਰਿ", 8);
    freq.put("ς੭", 6);
    freq.put(" ਗਲ", 33);
    freq.put("ੜਾਂ", 7);
    freq.put(" ਗਰ", 25);
    freq.put("ਕਰਹ", 3);
    freq.put(" ਗਾ", 36);
    freq.put(" ਗਿ", 88);
    freq.put("ੀਓ ", 40);
    freq.put("ਕੋਰ", 9);
    freq.put("਼ਕ਼", 4);
    freq.put("ਰਸ਼ਨ", 5);
    freq.put(" ਗਹ", 5);
    freq.put("ਡਦੇ", 4);
    freq.put(" ਗਇ", 3);
    freq.put("ਾਲਸ", 9);
    freq.put("ਾਲਿ", 30);
    freq.put("ਾਲਾ", 64);
    freq.put("੧॥ ", 10);
    freq.put(" ਗਏ", 44);
    freq.put("ਤਵ", 5);
    freq.put("ਗਵਾ", 4);
    freq.put(" ਗਈ", 54);
    freq.put("ਰਪੰ", 5);
    freq.put("ਬਾਬ", 12);
    freq.put("ੇਬ", 23);
    freq.put("ਕਰਜ", 5);
    freq.put("ਪੰਚ", 8);
    freq.put("ਐੱਸ", 6);
    freq.put(" ਗਜ", 4);
    freq.put("ਕਰਕ", 36);
    freq.put("ਾਲਦ", 4);
    freq.put("ਾਲਤ", 9);
    freq.put(" ਉਸ", 45);
    freq.put("ी", 11);
    freq.put("ੂ", 1336);
    freq.put("ਿਗ", 78);
    freq.put("ੰਕ", 7);
    freq.put("ਨੀਲ", 3);
    freq.put("ਿੳ", 5);
    freq.put(" ਉਲ", 6);
    freq.put("ਉਨ", 16);
    freq.put("ੰਟ", 21);
    freq.put("ੰਜ", 98);
    freq.put("ੰਝ", 10);
    freq.put("→ㅤ", 3);
    freq.put("ਝਦ", 3);
    freq.put("ਧਾਰ", 7);
    freq.put("ਹਤ ", 8);
    freq.put(" ਉਮ", 25);
    freq.put(" ਗੱ", 82);
    freq.put(" ਉਠ", 5);
    freq.put(" ਉਡ", 14);
    freq.put("ਾਲੀ", 63);
    freq.put("ਾਲੇ", 84);
    freq.put("ਰਵ", 40);
    freq.put(" ਉਦ", 18);
    freq.put("ਓਹਦ", 8);
    freq.put("ਧਾਂ", 3);
    freq.put(" ਗੇ", 14);
    freq.put("ਿਖ", 61);
    freq.put(" ਉਜ", 4);
    freq.put(" ਉਝ", 5);
    freq.put(" ਗੀ", 7);
    freq.put("਼ਕੇ", 3);
    freq.put("ਭੂਤ", 3);
    freq.put("ਕਰੇ", 23);
    freq.put("ਧਾਈ", 10);
    freq.put(" ਗ੍", 17);
    freq.put(" ਗੋ", 17);
    freq.put("ਕਰੀ", 42);
    freq.put("ੰਢ", 3);
    freq.put("ੰਡ", 127);
    freq.put("ੰਦ", 530);
    freq.put("ੰਧ", 16);
    freq.put("ੰਤ", 43);
    freq.put(" ਉਏ", 3);
    freq.put("ੀਜ਼ਾ", 3);
    freq.put(" ਉਂ", 10);
    freq.put("ੰਮ", 71);
    freq.put(" ਆਜ਼", 4);
    freq.put("ੰਬ", 31);
    freq.put("ੰਭ", 8);
    freq.put("ਦੀਪ", 3);
    freq.put("ਤਾਵ", 5);
    freq.put("ਕਾਂ", 62);
    freq.put("ਕਟ ", 5);
    freq.put("ਦਿਲ", 129);
    freq.put("ਕੌੜ", 4);
    freq.put("ਕਾਇ", 6);
    freq.put("ਭਾ ", 14);
    freq.put("ਟਾਈ", 4);
    freq.put("ਰਦਰ", 5);
    freq.put("ਠੀ ", 11);
    freq.put("▓ ", 4);
    freq.put("ਕਾਕ", 4);
    freq.put("ਕਾਗ", 8);
    freq.put("ਿਂਦ", 3);
    freq.put("ੂਕ ", 7);
    freq.put("ਧੰਨ", 11);
    freq.put("ਤਸਵ", 7);
    freq.put("ਸਖਤ", 4);
    freq.put("ਰਦਿ", 5);
    freq.put("ਰਦਾ", 107);
    freq.put("ੇਤ ", 11);
    freq.put("ਕਾਤ", 13);
    freq.put("ੱਤ ", 47);
    freq.put("ਾਣ ", 37);
    freq.put("ਦਿਸ", 4);
    freq.put("ਕਾਫ", 3);
    freq.put("ਭ", 401);
    freq.put("ਟਾਉ", 4);
    freq.put("ਕਾਮ", 8);
    freq.put("ਨਸ਼", 7);
    freq.put("ਕਾਰ", 105);
    freq.put("ੋਲੋ", 12);
    freq.put("ਕਾਲ", 35);
    freq.put("ਐਕਟ", 3);
    freq.put("ਕਾਸ਼", 6);
    freq.put("ਰਸ", 61);
    freq.put("ਕਾਸ", 12);
    freq.put("ਕਾਹ", 7);
    freq.put("ੋਲੀ", 14);
    freq.put("ਰਸੀ", 5);
    freq.put("ੋਲੇ", 9);
    freq.put("ੰਚ", 21);
    freq.put("ਤਲ ", 10);
    freq.put("ਰਸਿ", 4);
    freq.put("ਰਸਾ", 4);
    freq.put("ਰਸ਼", 7);
    freq.put(" ਬੌ", 3);
    freq.put(" ਚ ", 202);
    freq.put("ੁਸ਼", 13);
    freq.put("ਨੱਕ", 5);
    freq.put("ਯੋ", 10);
    freq.put("ਫਤਾ", 8);
    freq.put("੨੨ ", 4);
    freq.put("ਫਤਹ", 3);
    freq.put("ੁਸਤ", 4);
    freq.put("ੰਗਲ", 15);
    freq.put("ਜੇ ", 122);
    freq.put("ਅੱ", 148);
    freq.put("ੋਲਦ", 11);
    freq.put("ਰਸਤ", 12);
    freq.put("ਰਦੁ", 3);
    freq.put("ਰਦੀ", 54);
    freq.put("ਣੋ ", 3);
    freq.put("ੂਬੀ", 3);
    freq.put("ਰਦੇ", 54);
    freq.put("ღ", 7);
    freq.put("ਣਗੀ", 3);
    freq.put("ਕੌਰ", 6);
    freq.put("ੁਆ ", 5);
    freq.put("ਝੇ", 9);
    freq.put("ੋਸ ", 5);
    freq.put("ਕੌਮ", 6);
    freq.put("ਲਾਈ", 24);
    freq.put("ੰਗਿ", 6);
    freq.put("ਕੌਣ", 8);
    freq.put(" ਦਾ", 413);
    freq.put("ੰਘ", 49);
    freq.put("ਝੀ", 3);
    freq.put("ਘੋ", 6);
    freq.put("ਘੈ", 3);
    freq.put("ं", 7);
    freq.put("ਿਮਾ", 10);
    freq.put("ਮਰਨ", 9);
    freq.put("ੂਹਿ", 3);
    freq.put("ੰਥ ", 4);
    freq.put("ਮਰਤ", 3);
    freq.put("ਿਮਰ", 3);
    freq.put("ਮਰਦ", 12);
    freq.put("ਘੇ", 4);
    freq.put("ਟਾਇ", 3);
    freq.put("ਰਿ", 184);
    freq.put("ਮਰਿ", 5);
    freq.put("ਮਰਾ", 6);
    freq.put("ਘੜ", 3);
    freq.put("ਧਿਆ", 13);
    freq.put("ਜ਼ ", 25);
    freq.put("ੱਬ", 127);
    freq.put("ੇਵੇ", 12);
    freq.put("ਪਣਿ", 4);
    freq.put("ੇਵੋ", 6);
    freq.put("ੀਵੀ", 4);
    freq.put("ਡਦ", 7);
    freq.put("ਸ਼ਹਿ", 3);
    freq.put("ਠਿ", 7);
    freq.put("ਮਰਜ", 19);
    freq.put("ਡਨ", 5);
    freq.put("ਘੱ", 18);
    freq.put("ੇਸ਼ ", 10);
    freq.put("ਬੜਾ", 16);
    freq.put("ਹੀਂ", 121);
    freq.put("ੀ", 5175);
    freq.put("ੁੱਗ", 4);
    freq.put("ੁੱਖ", 59);
    freq.put("ਹੀਆ", 3);
    freq.put("ੁਖੁ", 4);
    freq.put("ਬੈਠ", 33);
    freq.put("ਦੱ", 44);
    freq.put("ੁੱਟ", 42);
    freq.put("ੰਨ ", 25);
    freq.put("ਹੀਏ", 5);
    freq.put("ੁੱਛ", 18);
    freq.put("ਆਈ ", 27);
    freq.put("ਛੁਡ", 5);
    freq.put("ਅਵਾ", 4);
    freq.put("ㅤ ", 12);
    freq.put("ਨਾਇ", 4);
    freq.put("ਪੱਟ", 10);
    freq.put("ਨਾਉ", 8);
    freq.put("ਛੁਪ", 3);
    freq.put("ਰਚੇ", 3);
    freq.put("ਉੱਡ", 6);
    freq.put("ਉੱਠ", 5);
    freq.put("ੌਰ ", 11);
    freq.put("ਨਾਰ", 11);
    freq.put("ਨਾਲ", 203);
    freq.put("ਹੀਦ", 23);
    freq.put("ਬੈਂ", 5);
    freq.put("●๋ ", 3);
    freq.put("ਨਾਹ", 7);
    freq.put("ਨਾਸ", 3);
    freq.put("ਹੀਨ", 4);
    freq.put("ਘਦ", 4);
    freq.put("ਲਾਗ", 4);
    freq.put("ਮਰੂ", 3);
    freq.put("ੁੱਤ", 35);
    freq.put("ਹੀਰ", 9);
    freq.put("ੁੱਦ", 10);
    freq.put("ਘਾ", 10);
    freq.put("ਘਿ", 4);
    freq.put("ੇਵਕ", 4);
    freq.put("ਤਾਜ", 5);
    freq.put(" ੩ ", 4);
    freq.put("ਡਵ", 3);
    freq.put("ਘਰ", 55);
    freq.put("ਨਾਪ", 3);
    freq.put("ਨਾਭ", 4);
    freq.put("ਨਾਬ", 7);
    freq.put("ਨਾਮ", 57);
    freq.put("ੱਲ ", 116);
    freq.put("ਨਗਰ", 4);
    freq.put("ਕਣਕ", 3);
    freq.put("ਫੀ", 13);
    freq.put("ਫੇ", 35);
    freq.put("ੂਹੇ", 5);
    freq.put("ਪੈਦ", 7);
    freq.put("ਰੁਸ", 5);
    freq.put("ਪੈਨ", 3);
    freq.put("ਣ ", 437);
    freq.put("ਸ਼ੀਨ", 3);
    freq.put("ਆਗੂ", 4);
    freq.put("ਨੀਤ", 6);
    freq.put(" ਖੱ", 10);
    freq.put(" ਖੰ", 8);
    freq.put("ਿਸਟ", 6);
    freq.put("ਨਤਾ", 6);
    freq.put("ਜਦੌ", 3);
    freq.put("ਰੁਪ", 4);
    freq.put("ਨੀਰ", 3);
    freq.put("ਲੰਬ", 3);
    freq.put("ਜਦੋ", 52);
    freq.put("ਲੰਮ", 4);
    freq.put(" ਖੁ", 49);
    freq.put("ਮਦਦ", 3);
    freq.put("ਿਸਮ", 19);
    freq.put(" ਖੂ", 12);
    freq.put("ਿਸਨ", 4);
    freq.put("ਰੁਕ", 4);
    freq.put(" ਖੇ", 26);
    freq.put("ਿਸਤ", 14);
    freq.put("ਕਣਾ", 4);
    freq.put("ਫ", 397);
    freq.put("ਬੁ", 73);
    freq.put("भ", 6);
    freq.put("ਨੀਆ", 56);
    freq.put("ਨੀਅ", 3);
    freq.put(" ਸਖ", 6);
    freq.put("ਿਸ਼", 20);
    freq.put("ੀਜ਼ ", 3);
    freq.put("ਫੰ", 3);
    freq.put("ੱਪੜ", 6);
    freq.put("ਡਿ", 27);
    freq.put("ਮਦਰ", 3);
    freq.put("ਮਦਾ", 4);
    freq.put("ਝਾਂ", 4);
    freq.put("ਡਾ", 121);
    freq.put(" ਖੜ", 17);
    freq.put("ਧੇ ", 5);
    freq.put("ਰੀਤ", 14);
    freq.put("ਰੁੱ", 15);
    freq.put("ਬੜੀ", 17);
    freq.put(" ਖਤ", 4);
    freq.put("ਇੱ", 104);
    freq.put("ਿਸੇ", 101);
    freq.put("ਦੁਖ", 12);
    freq.put(" ਖਬ", 6);
    freq.put("ਸਬੁ", 9);
    freq.put("ਦੁਕ", 4);
    freq.put(" ਖਰ", 10);
    freq.put("ਸੱਚ", 34);
    freq.put("ੇੜਾ", 6);
    freq.put("ਸੱਜ", 24);
    freq.put("ਕਣੀ", 4);
    freq.put("ੂਸ ", 5);
    freq.put("ੱਪਲ", 3);
    freq.put("ਫਟ", 4);
    freq.put(" ਖ਼", 9);
    freq.put(" ਖਿ", 25);
    freq.put(" ਖਾ", 54);
    freq.put("ਿਯ", 9);
    freq.put("ਸੱਪ", 3);
    freq.put("ਰਦ", 247);
    freq.put("ਸੱਭ", 9);
    freq.put("ੁਂਦ", 6);
    freq.put("ੰਗੇ", 11);
    freq.put("ਉਂ ", 23);
    freq.put("ਅਣਮ", 3);
    freq.put("੫", 20);
    freq.put("ਜਦਾ", 4);
    freq.put("ਸੱਤ", 5);
    freq.put("ਸੱਸ", 4);
    freq.put("ਫਲ", 5);
    freq.put("ਦੁਨ", 49);
    freq.put("ੀਰ ", 62);
    freq.put("ਲਕਾ", 9);
    freq.put("ਉ ", 56);
    freq.put("ਫਸ", 12);
    freq.put("ਫਿ", 70);
    freq.put("ਫਾ", 40);
    freq.put(" ਖਟ", 5);
    freq.put("ਸਬੰ", 3);
    freq.put("ਸ਼ ", 44);
    freq.put("ਲਿਸ", 4);
    freq.put("ੱਸੀ", 10);
    freq.put("ਮੇ ", 12);
    freq.put("ੱਸੇ", 4);
    freq.put("ਧਿਕ", 3);
    freq.put("ੱਸੋ", 7);
    freq.put("਼ਦਾ", 3);
    freq.put(" ਸਦ", 25);
    freq.put("ਜਰਾ", 4);
    freq.put("ਆਓ", 5);
    freq.put("ਢੇ", 7);
    freq.put("ਚੜ ", 3);
    freq.put("ਖ", 895);
    freq.put("ਵਰਗ", 47);
    freq.put("ਵਰਕ", 6);
    freq.put("ਰਥੀ", 7);
    freq.put("ਬੜ", 39);
    freq.put("ਆਕ", 11);
    freq.put("ਐਂਵ", 4);
    freq.put("↓ ", 33);
    freq.put("ਬਦੀ", 6);
    freq.put("ਵਿਧ", 9);
    freq.put("ਗਾਮ", 3);
    freq.put("ਫੜਿ", 3);
    freq.put("਼ੁਰ", 4);
    freq.put("ब", 3);
    freq.put("ਦੀ ", 767);
    freq.put("ਕਿੱ", 21);
    freq.put("ਕਿੰ", 28);
    freq.put("ਸਕੀ", 6);
    freq.put("ਲਤ ", 11);
    freq.put("ਸਕੂ", 13);
    freq.put("ਡਕ", 5);
    freq.put("ਿਠ", 8);
    freq.put("ਰਥ", 14);
    freq.put("ਆਦ ", 3);
    freq.put("ਫੀ ", 7);
    freq.put("ਉਸਨ", 7);
    freq.put("ੰਤਜ", 3);
    freq.put("ਵਿਦ", 6);
    freq.put("ੁਡ ", 3);
    freq.put("ਵਾਦ", 18);
    freq.put("ਵਾਧ", 7);
    freq.put("ਲੜਕ", 7);
    freq.put("ਥੱਕ", 3);
    freq.put("ਕਿਉ", 40);
    freq.put(" ਸ਼", 66);
    freq.put("ਵਾਬ", 8);
    freq.put("ਬਦਨ", 8);
    freq.put("ਰਟ ", 8);
    freq.put("ਕਿਓ", 5);
    freq.put("ਸਕਦ", 33);
    freq.put("ਇਕ ", 70);
    freq.put("ਸਕਣ", 3);
    freq.put("ਵਾਸ", 9);
    freq.put("ਵਾਹ", 64);
    freq.put("ਐੱਚ", 3);
    freq.put("ਦਦ ", 4);
    freq.put("ਗਤੀ", 3);
    freq.put("ੱਸਣ", 5);
    freq.put("ਵਾਂ", 78);
    freq.put("ਲੜਾ", 6);
    freq.put("ੱਸਦ", 13);
    freq.put("ਕਿਦ", 3);
    freq.put("ਕਿਥ", 6);
    freq.put("ਕਿਤ", 18);
    freq.put("ਕਿਫ", 3);
    freq.put("ਵਾਉ", 4);
    freq.put("ਕਿਨ", 5);
    freq.put(" ਤੜ", 5);
    freq.put("ਜਰੂ", 17);
    freq.put("ਣਦੀ", 6);
    freq.put("ਜਰੀ", 4);
    freq.put("ਕਿਲ", 7);
    freq.put("ਕਿਰ", 12);
    freq.put("ਮਝ", 40);
    freq.put("ਖਰ ", 5);
    freq.put("ਕਿਵ", 9);
    freq.put("ੰਤਨ", 4);
    freq.put("ਮੁਸ਼", 4);
    freq.put("ਕਿਹ", 52);
    freq.put("ਕਿਸ", 131);
    freq.put("ਵਾਜ", 9);
    freq.put("ੱਸਿ", 6);
    freq.put("੫ ", 11);
    freq.put("ਚੌ", 5);
    freq.put("ਚ੍", 3);
    freq.put("ਇਕੀ", 3);
    freq.put("ਭਣਾ", 3);
    freq.put("ੂਤ ", 4);
    freq.put("ਦਨ", 13);
    freq.put("ੀਬੀ", 4);
    freq.put("ਇਕੋ", 3);
    freq.put("ਿਓ", 21);
    freq.put("ਚੇ", 39);
    freq.put("ਚੀ", 48);
    freq.put("ਚੁ", 33);
    freq.put("ਚੂ", 4);
    freq.put("● ", 4);
    freq.put("ਚੜ", 22);
    freq.put("ਆਈ", 32);
    freq.put("ਝੱਲ", 4);
    freq.put("ੁਹਾ", 31);
    freq.put("ਇਨ ", 3);
    freq.put("ੈਮ", 3);
    freq.put("ग", 5);
    freq.put(" ਬੰ", 54);
    freq.put("ਲਾਕ", 13);
    freq.put("ੇਬੀ", 3);
    freq.put("ਹਣੀ", 25);
    freq.put("ਹਣੇ", 11);
    freq.put("ਆਊ", 4);
    freq.put("ਅਰ ", 5);
    freq.put(" ਬੇ", 70);
    freq.put("਼ਰਪ", 3);
    freq.put(" ਬੁ", 61);
    freq.put(" ਬੀ", 19);
    freq.put("ੱਜੇ", 5);
    freq.put(" ਬ੍", 4);
    freq.put("਼ਰਤ", 3);
    freq.put(" ਬੋ", 44);
    freq.put(" ਬੈ", 41);
    freq.put("਼ਰਾ", 4);
    freq.put("ਲੇ", 263);
    freq.put("ੇਨੁ", 3);
    freq.put("ੇਨੂ", 11);
    freq.put("ਨਗੇ", 4);
    freq.put("ਦਿਖ", 8);
    freq.put("ਢਿੱ", 3);
    freq.put(" ਬੜ", 38);
    freq.put("ਚੰ", 52);
    freq.put("ਸੋ ", 18);
    freq.put("ੌਂਹ", 3);
    freq.put("ਿਊ", 12);
    freq.put("ੁ", 1840);
    freq.put(" ਬਦ", 36);
    freq.put("ਖਾਵ", 4);
    freq.put(" ਸੀ", 183);
    freq.put(" ਬਣ", 91);
    freq.put("ਖਾਲ", 8);
    freq.put("ਲੀ ", 186);
    freq.put("਼ਰੇ", 3);
    freq.put("ੱਜਤ", 4);
    freq.put("ੇਹੰ", 3);
    freq.put("ਿੰਨ", 49);
    freq.put("਼ਰੂ", 6);
    freq.put("ਖਾਹ", 3);
    freq.put("ਖਾਸ", 5);
    freq.put("ਪਰ ", 99);
    freq.put("ਖਾਤ", 5);
    freq.put("ਖਾਣ", 4);
    freq.put(" ਬਲ", 23);
    freq.put(" ਬਰ", 12);
    freq.put(" ਬਿ", 77);
    freq.put("ਖਾਮ", 3);
    freq.put("ੱਜਲ", 3);
    freq.put("ੁਰ ", 27);
    freq.put("є ", 3);
    freq.put("ਖਾਨ", 4);
    freq.put(" ਸਜ਼", 5);
    freq.put("ी ", 10);
    freq.put("ਹਣ ", 6);
    freq.put("ਚਨ", 5);
    freq.put("ਹਣਾ", 3);
    freq.put("ਚਪ", 7);
    freq.put("ੈਬਸ", 3);
    freq.put("ੌਰ", 17);
    freq.put("ਚਦ", 10);
    freq.put("ੀੜ", 11);
    freq.put("ੁਹੀ", 3);
    freq.put(" ਬਈ", 4);
    freq.put("ੀਆ ", 160);
    freq.put("ਚਾ", 154);
    freq.put("ਚਿ", 40);
    freq.put("ਖਾਂ", 36);
    freq.put("ਆਹ", 22);
    freq.put("ਿੰਜ", 4);
    freq.put("ੀਬਾ", 9);
    freq.put(" ਬਜ", 4);
    freq.put("ਚਰ", 20);
    freq.put(" ਬਚ", 17);
    freq.put("ਖਾਉ", 3);
    freq.put("ਖਾਈ", 7);
    freq.put("ੋਵਾ", 4);
    freq.put(" ਫੋ", 23);
    freq.put("ਗਈ", 55);
    freq.put("ੰਸਾ", 3);
    freq.put("ਜਣ ", 10);
    freq.put("ਾਸ਼ ", 14);
    freq.put("ਰਮ", 56);
    freq.put("ਕੋਕ", 3);
    freq.put(" ਸੜ", 18);
    freq.put("ਥ ", 42);
    freq.put("ਪਾਪ", 5);
    freq.put("ਤੇਲ", 3);
    freq.put("ੇੜੀ", 8);
    freq.put("ਠੇ ", 23);
    freq.put("ਕੋਈ", 136);
    freq.put(" ਮੱ", 16);
    freq.put(" ਮੰ", 88);
    freq.put("ੰਸਦ", 4);
    freq.put("ਜੀ ", 97);
    freq.put(" ਫੈ", 15);
    freq.put(" ਮੋ", 46);
    freq.put("ੳਣ", 5);
    freq.put(" ਮੌ", 37);
    freq.put("ੇਂ ", 71);
    freq.put(" ਮੁ", 188);
    freq.put("ਕੋਸ਼", 6);
    freq.put("ਝਿ", 3);
    freq.put(" ਮੂ", 22);
    freq.put("ਕੋਲ", 23);
    freq.put(" ਮੇ", 214);
    freq.put("म", 7);
    freq.put("ੌਕ ", 3);
    freq.put(" ਮਜ਼", 4);
    freq.put("ੱਣ ", 5);
    freq.put("ਧਨ ", 4);
    freq.put("ਪੰਜ", 69);
    freq.put("ਬਈ", 4);
    freq.put("ੂੰਨ", 7);
    freq.put("ਜਗਾ", 6);
    freq.put("ਿੱਥ", 17);
    freq.put("ਕੋਣ", 4);
    freq.put("ਵੀ ", 274);
    freq.put("ਕੋਠ", 7);
    freq.put("ਾਜ਼ ", 7);
    freq.put(" ਮਨ", 48);
    freq.put("ਤਾਰ", 37);
    freq.put("ਖ਼ਿ", 4);
    freq.put("ਖ਼ਾ", 3);
    freq.put("ੂਠੀ", 4);
    freq.put("ੋਂਦ", 4);
    freq.put("ਪੋ ", 5);
    freq.put("ਤਾਹ", 3);
    freq.put(" ਮਤ", 7);
    freq.put("ੇਪਰ", 3);
    freq.put(" ਮਦ", 5);
    freq.put(" ਮਹ", 40);
    freq.put(" ਮਸ", 10);
    freq.put("ਰੋੜ", 10);
    freq.put("ਡੂ", 3);
    freq.put("ਝੁ", 7);
    freq.put("ਖ਼ਬ", 3);
    freq.put(" ਮਿ", 157);
    freq.put(" ਮਾ", 202);
    freq.put(" ਮਰ", 61);
    freq.put(" ਮਲ", 5);
    freq.put("ਆਪ", 156);
    freq.put("ਝੋ", 13);
    freq.put(" ਮਸ਼", 3);
    freq.put("ਇਤ ", 3);
    freq.put("ਆਫ", 5);
    freq.put("ਝੱ", 5);
    freq.put("ਝੰ", 11);
    freq.put(" ੳ", 9);
    freq.put("ਆਬ", 5);
    freq.put("ੀਮਤ", 5);
    freq.put("ਮੁਟ", 8);
    freq.put("ੁਲਸ", 8);
    freq.put("ਰਹੋ", 6);
    freq.put("ਲੋ ", 45);
    freq.put(" ਮਜ", 14);
    freq.put("ੋਵੈ", 3);
    freq.put("ਰਹੀ", 20);
    freq.put("ਰਹੁ", 3);
    freq.put("ਰਹੂ", 3);
    freq.put("ਤਾਉ", 5);
    freq.put(" ਮਗ", 4);
    freq.put("ਰਹੇ", 19);
    freq.put("ਂਗਰ", 20);
    freq.put(" ਠੀ", 7);
    freq.put(" ਠੇ", 3);
    freq.put(" ●๋", 3);
    freq.put(" ਠੋ", 4);
    freq.put("ਅਦ ", 21);
    freq.put("ਵੈ", 31);
    freq.put("ਂਗਲ", 4);
    freq.put("ਮੁਬ", 5);
    freq.put("ਮੁਲ", 17);
    freq.put("ੂੰਹ", 12);
    freq.put("ਮੁਰ", 5);
    freq.put("ਡਾਇ", 3);
    freq.put("ਝੁਕ", 4);
    freq.put("ਭਿ", 9);
    freq.put("ਬਣ ", 27);
    freq.put("ੇਤੇ", 8);
    freq.put("ੋਮ", 8);
    freq.put("ਮੁਸ", 6);
    freq.put("ਮੁਹ", 13);
    freq.put("ਡਾਈ", 3);
    freq.put("ਡਾਉ", 6);
    freq.put("ु ", 7);
    freq.put("ੁਣੀ", 8);
    freq.put("ਮੁਆ", 4);
    freq.put("ੰਜੂ", 3);
    freq.put("ਥੱਲ", 5);
    freq.put("ਲਦਾ", 39);
    freq.put("ਯ", 205);
    freq.put("ਮਹਿ", 18);
    freq.put("ਂਗੀ", 11);
    freq.put("ਾਜੀ", 3);
    freq.put(" ਠੱ", 5);
    freq.put(" ਠੰ", 9);
    freq.put("ਮੁਖ", 3);
    freq.put("ਾਜੇ", 3);
    freq.put("ਮੁਕ", 11);
    freq.put("ਾਜੋ", 5);
    freq.put(" ਧੜ", 10);
    freq.put("दर", 3);
    freq.put("ੀਵਾ", 7);
    freq.put("ਆਜ਼", 6);
    freq.put("ਾਜਵ", 6);
    freq.put("ਕੈ ", 4);
    freq.put("ਟਦਾ", 9);
    freq.put("ਾਜ਼", 11);
    freq.put("ਮਨਾ", 15);
    freq.put("ਾਜਾ", 5);
    freq.put("ਮੁੰ", 43);
    freq.put("ਲਦੀ", 24);
    freq.put("ਲਦੇ", 19);
    freq.put("ਂਗਾ", 11);
    freq.put("ੰਜਰ", 6);
    freq.put("ੰਜਿ", 6);
    freq.put("ਗੋਰ", 4);
    freq.put("ਾਜਪ", 8);
    freq.put("ੁਣਿ", 4);
    freq.put("ੜਾ ", 93);
    freq.put("ਡਮ ", 6);
    freq.put("ੈਥ", 4);
    freq.put("ੇਤਰ", 3);
    freq.put("ੀਠੀ", 5);
    freq.put("ਜੂ", 12);
    freq.put("ਗੈ", 21);
    freq.put("ੇਤਾ", 7);
    freq.put("ਹਰ ", 59);
    freq.put(" ਠਰ", 5);
    freq.put("ਟਾਕ", 5);
    freq.put("ਅਕਤ", 6);
    freq.put("ਏਸ ", 4);
    freq.put("ਆਸ਼ਕ", 3);
    freq.put("ੈਰੀ", 10);
    freq.put("ਮਤ ", 28);
    freq.put("ਮੁੜ", 8);
    freq.put("ਥੀ", 15);
    freq.put("ੰਸ", 9);
    freq.put("ੇਸ਼ਨ", 4);
    freq.put("ਸੂਹ", 6);
    freq.put("ਪਰਿ", 18);
    freq.put("ਵੀਆ", 4);
    freq.put("ਬੋਤ", 6);
    freq.put("ਖਣ", 26);
    freq.put("ਇਮਾ", 5);
    freq.put("ਸੂਰ", 20);
    freq.put("ਸੂਲ", 4);
    freq.put("ਤਾ ", 272);
    freq.put("ਫਨ ", 3);
    freq.put("ੈਂਟ", 6);
    freq.put("ਖ਼ ", 4);
    freq.put("ੇਸ਼ਾ", 10);
    freq.put("ਇਮਤ", 4);
    freq.put("ੰਜਾ", 64);
    freq.put("ੈਂਕ", 5);
    freq.put("ਕਠੇ", 4);
    freq.put("੨ ", 11);
    freq.put("ਚ", 1066);
    freq.put("ुदर", 3);
    freq.put("ੂਹ ", 13);
    freq.put("ੀਮਾ", 6);
    freq.put("ੈਂਬ", 3);
    freq.put("ਤੱਕ", 24);
    freq.put("ਗੋਲ", 4);
    freq.put("ਪਹਲ", 3);
    freq.put("ਿਫਤ", 7);
    freq.put("ੋਸ਼ ", 4);
    freq.put("ਣਨ", 6);
    freq.put("ਪਹਿ", 36);
    freq.put("ੈਂਦ", 26);
    freq.put("ੈਂਡ", 3);
    freq.put("ਮਾਸ਼", 3);
    freq.put("ਥੀ ", 12);
    freq.put("ਆਵਾ", 11);
    freq.put("ਨਰਮ", 3);
    freq.put("ਪੇੜ", 4);
    freq.put("ੈਂਸ", 4);
    freq.put("ੌਣ ", 9);
    freq.put("ਗਏ ", 43);
    freq.put("ਾਈ ", 126);
    freq.put("ਹੋਣ", 47);
    freq.put("ਪੇਪ", 3);
    freq.put("ਟਨ", 9);
    freq.put("ਖੋ ", 21);
    freq.put("ਪੰ", 87);
    freq.put("ਘਰ ", 28);
    freq.put("ਪੱ", 52);
    freq.put("ੋਈ ", 154);
    freq.put("ਹੋਲ", 5);
    freq.put("ਹੋਰ", 52);
    freq.put("ਹੋਵ", 54);
    freq.put("ਬਨਾ", 5);
    freq.put("ੇਹ ", 3);
    freq.put("ਗ਼", 7);
    freq.put("ਸ਼ੇਰ", 5);
    freq.put("ਹੋਂ", 3);
    freq.put("ੱਛ ", 4);
    freq.put("ਹੋਇ", 39);
    freq.put("ਿਵਾ", 22);
    freq.put("ਨਿਆ", 32);
    freq.put("ਹੋਈ", 22);
    freq.put("ਹੋਏ", 17);
    freq.put("ਧੋਖ", 14);
    freq.put("ੁਲ ", 11);
    freq.put("ੁੰਚ", 9);
    freq.put("ਪੇਚ", 3);
    freq.put("ਹੋਗ", 9);
    freq.put("ਹੋਕ", 4);
    freq.put("ਪੇਟ", 4);
    freq.put("ੋਨ ", 14);
    freq.put("ਖੜ ", 4);
    freq.put("ਅਕਲ", 9);
    freq.put("ਿਠਾ", 5);
    freq.put("ਕਮਰ", 3);
    freq.put("ਾਰਜ", 3);
    freq.put("ਾਰਟ", 4);
    freq.put("ਅ", 626);
    freq.put("ਫਤ ", 3);
    freq.put("ਾਰਚ", 3);
    freq.put("ਾਰਕ", 12);
    freq.put("ਉੱਪ", 4);
    freq.put("ੈਂਗ", 4);
    freq.put("ਕਮਾ", 7);
    freq.put("ਕਮਿ", 5);
    freq.put("ਓਪਨ", 3);
    freq.put("ਾਓ ", 7);
    freq.put("ੇਕੇ", 4);
    freq.put("੪੫ ", 7);
    freq.put("ਣਿਆ", 18);
    freq.put("ਆਰ ", 120);
    freq.put("ਅਮੀ", 5);
    freq.put("ਾਰਿ", 27);
    freq.put("ਾਰਾ", 101);
    freq.put("ਛਦੀ", 3);
    freq.put("ਗ ", 151);
    freq.put("ਥਾਂ", 13);
    freq.put("ਪਲ ", 23);
    freq.put("ਦਾਜ", 4);
    freq.put("ੱਕ ", 150);
    freq.put("ਾਰਮ", 3);
    freq.put("ਾਰਨ", 23);
    freq.put("ਜ਼ਮਾ", 4);
    freq.put("ਇਸ਼", 15);
    freq.put("ਾਰਤ", 16);
    freq.put("ਤਾਲ", 7);
    freq.put("ਾਰਦ", 15);
    freq.put("ਊਣਾ", 3);
    freq.put("ਾਰਣ", 4);
    freq.put("ੇਡ ", 10);
    freq.put("ਔਖਾ", 13);
    freq.put("ੇਚ ", 9);
    freq.put("ੁਤੀ", 4);
    freq.put("ਢੀ", 8);
    freq.put("ਗਦ", 54);
    freq.put("ਨੇ ", 368);
    freq.put("ਅਮਰ", 12);
    freq.put("ਅਮਲ", 13);
    freq.put("ਗਤ", 18);
    freq.put("ਾਰੋ", 9);
    freq.put("ੁਟਿ", 9);
    freq.put("ਛਦਾ", 4);
    freq.put("ਗਣ", 22);
    freq.put("ਾਰੇ", 60);
    freq.put("ਾਰੁ", 3);
    freq.put("ਾਰੀ", 113);
    freq.put("ਾਰੂ", 8);
    freq.put("ਲ੍ਲ", 3);
    freq.put("ਿਤ ", 14);
    freq.put("ਸਰ ", 13);
    freq.put("ਚੋ ", 24);
    freq.put("ਕਮੀ", 6);
    freq.put("ਲਾਉ", 23);
    freq.put("ਈਂ ", 6);
    freq.put("ਕਮੇ", 7);
    freq.put("ਈਆ ", 6);
    freq.put("ਪਰਖ", 3);
    freq.put("ਗਭ", 4);
    freq.put("਼ੌਕ", 6);
    freq.put("ਿਸ਼ ", 7);
    freq.put("ਔਰਤ", 6);
    freq.put("ਈਟ", 6);
    freq.put("ਖਿਲ", 13);
    freq.put("ਮਣ", 17);
    freq.put("ਹੈ ", 187);
    freq.put("ਲਹੂ", 3);
    freq.put("ਆਖਰ", 9);
    freq.put("ਝੂਲ", 3);
    freq.put("ਈਕ", 8);
    freq.put("ਆਣੀ", 4);
    freq.put("ਨਜਾ", 3);
    freq.put("ਨਜ਼", 5);
    freq.put(" ਭਰ", 44);
    freq.put("ਖਿਡ", 3);
    freq.put(" ਭਲ", 6);
    freq.put("ਆਣੇ", 5);
    freq.put("ਛੁ", 11);
    freq.put("ਘ", 176);
    freq.put(" ਭਾ", 74);
    freq.put(" ਭਿ", 6);
    freq.put("ਝੂਠ", 13);
    freq.put("ਚੁੰ", 6);
    freq.put("ਚੁੱ", 15);
    freq.put("ਛੇ ", 17);
    freq.put("ਦਾ ", 870);
    freq.put("ਖੀ ", 41);
    freq.put("ਡਿੱ", 6);
    freq.put("ਮਤ", 46);
    freq.put("ਈਲ", 3);
    freq.put("ਪੱਲ", 11);
    freq.put("ਈਰ", 4);
    freq.put("ਗਵ", 4);
    freq.put("ਖਿਚ", 5);
    freq.put("ਈਵ", 3);
    freq.put("ਖਿਆ", 32);
    freq.put(" ਭਗ", 5);
    freq.put("ਿੱਘ", 3);
    freq.put("ਈਦ", 6);
    freq.put("ਓਏ", 4);
    freq.put("ਡਿਗ", 3);
    freq.put("ਅਚ", 3);
    freq.put("ਖਿੱ", 3);
    freq.put("ਘਰਦ", 4);
    freq.put("ਚੋਣ", 11);
    freq.put("ਦੋ ", 56);
    freq.put("ਪੋ", 21);
    freq.put("त ", 5);
    freq.put("ਡਿਆ", 14);
    freq.put(" ਭੰ", 3);
    freq.put(" ਭੱ", 7);
    freq.put("ਾਉਂ", 18);
    freq.put(" ਆ", 648);
    freq.put("ਓ ", 90);
    freq.put("ß", 4);
    freq.put("ਮੀਂ", 3);
    freq.put("ਭਦੇ", 4);
    freq.put("ਡਾਂ", 6);
    freq.put(" ਭੇ", 22);
    freq.put(" ਭੀ", 4);
    freq.put(" ਭੁ", 64);
    freq.put(" ਭੂ", 4);
    freq.put("ੁਖੀ", 10);
    freq.put("ਬਚਾ", 8);
    freq.put(" ਭੈ", 6);
    freq.put("↓", 40);
    freq.put("ੀਟਰ", 3);
    freq.put(" ਭੋ", 8);
    freq.put("ਲਹਿ", 3);
    freq.put(" ਲੋ", 90);
    freq.put("ि", 13);
    freq.put(" ਭੜ", 4);
    freq.put("ਾਉਣ", 87);
    freq.put("ੁਮਾ", 7);
    freq.put("ਚੁਕ", 5);
    freq.put("ਾਉਦ", 17);
    freq.put("ੋਤਲ", 6);
    freq.put("ਸ਼ਿ", 10);
    freq.put("ਸ਼ਾ", 28);
    freq.put("ਛੱਡ", 40);
    freq.put("ਿਨਿ", 4);
    freq.put("अ", 3);
    freq.put("ਸ਼ਹ", 5);
    freq.put("ਚਪਨ", 3);
    freq.put("ਇੰਤ", 4);
    freq.put("ਛੱਪ", 3);
    freq.put("ਸ਼ਵ", 3);
    freq.put("ਬੋਹ", 3);
    freq.put("ਪਾ", 228);
    freq.put("ਸ਼ਰ", 11);
    freq.put("ਉਠ", 5);
    freq.put("ਸ਼ਿਆ", 4);
    freq.put("ੲੇ", 5);
    freq.put("ਗੈਰ", 13);
    freq.put("।। ", 5);
    freq.put("ति ", 3);
    freq.put("ਸ਼ਨ", 16);
    freq.put("ਰਜਾ", 16);
    freq.put("ਸ਼ਤ", 13);
    freq.put("੪ ", 3);
    freq.put("ਜਾ ", 51);
    freq.put("ਪਹ", 53);
    freq.put("ਸ਼ਟ", 3);
    freq.put("ਪਸੰ", 8);
    freq.put("ਸ਼ਿਸ਼", 5);
    freq.put("ਭਿੰ", 3);
    freq.put("ਗੈਂ", 4);
    freq.put("ਖਣੇ", 3);
    freq.put("ਿਵੇ", 22);
    freq.put("ਸ਼ਕ", 18);
    freq.put("ਅਜ ", 3);
    freq.put("ਛਿ", 12);
    freq.put("ਛਾ", 21);
    freq.put("ਇਸੇ", 4);
    freq.put("ਇੰਝ", 4);
    freq.put("ਛਡ", 8);
    freq.put(" ੨੨", 4);
    freq.put("ੁਖ", 43);
    freq.put("ਬੋਰ", 4);
    freq.put("ਲੈ ", 42);
    freq.put("ੇਟ ", 11);
    freq.put("ਨਮਾ", 4);
    freq.put("ਸੁਹ", 4);
    freq.put(" ੫ ", 3);
    freq.put("ਿਯਾ", 5);
    freq.put("ਵਫ", 16);
    freq.put("ਨਾਈ", 8);
    freq.put("ਸੁਰ", 13);
    freq.put("ਪਦੇ", 4);
    freq.put("ਵਪ", 10);
    freq.put("ਰੱਬ", 83);
    freq.put("ਤਲੀ", 5);
    freq.put("ਛੜ", 5);
    freq.put("ਸੁਨ", 4);
    freq.put("ਸੁਪ", 11);
    freq.put("ਛੀ", 4);
    freq.put("ਛੇ", 23);
    freq.put("ਪਲ", 37);
    freq.put("ਪੱਗ", 5);
    freq.put("ਛੋ", 14);
    freq.put("ਸੁਣ", 24);
    freq.put("ਵਧ", 21);
    freq.put("ਖਣਾ", 11);
    freq.put("ਸੁਧ", 3);
    freq.put("ੋਟੋ", 10);
    freq.put("ੀ ", 3702);
    freq.put("ਵਦ", 3);
    freq.put("ਓਹ", 53);
    freq.put("­ ", 3);
    freq.put("ੇਰਾ", 95);
    freq.put("ਰਜੀ", 11);
    freq.put("ਚਪੇ", 4);
    freq.put("੫੪੫", 7);
    freq.put("ੈਂਪ", 7);
    freq.put("ਡੀਆ", 10);
    freq.put("ਸੁਖ", 23);
    freq.put("ੰਚ ", 6);
    freq.put("ੱਢ ", 7);
    freq.put("ਿਨ੍", 11);
    freq.put("ਸ਼੍", 12);
    freq.put("ਸ਼ੌ", 6);
    freq.put("ਸ਼ੋ", 3);
    freq.put("ਰੱਕ", 4);
    freq.put("ਰੱਖ", 53);
    freq.put("ਸ਼ੇ", 15);
    freq.put("ਡੀਓ", 36);
    freq.put("ਆਇਆ", 23);
    freq.put("ਿਨੇ", 3);
    freq.put("ਿਨੀ", 3);
    freq.put("ਡੀਗ", 5);
    freq.put("ਸੁਆ", 5);
    freq.put("ਸ਼ੀ", 16);
    freq.put("ਭਰਦ", 9);
    freq.put("ਲਰ ", 6);
    freq.put("ਪਾਕ", 20);
    freq.put("ਦੇਖ਼", 3);
    freq.put("ਤੋਰ", 3);
    freq.put("ਇਹੀ", 3);
    freq.put("ਜੋਗ", 7);
    freq.put("ਆਕੜ", 7);
    freq.put("ਕੇ ", 354);
    freq.put("ਸਮਝ", 39);
    freq.put("ੁਛ", 9);
    freq.put("ਤੋਹ", 3);
    freq.put("ਪਤ", 48);
    freq.put("ਤੋਤ", 3);
    freq.put("ਸ਼ਲ", 3);
    freq.put("ਂਈ ", 3);
    freq.put("ੰਮ ", 22);
    freq.put("ਜੋਆ", 4);
    freq.put("ਭਰਿ", 4);
    freq.put(" ਘੱ", 18);
    freq.put("ਜ਼ਬ", 3);
    freq.put("ਤੰ", 11);
    freq.put("ਤੱ", 27);
    freq.put(" ਘੋ", 6);
    freq.put("ਸਮਰ", 4);
    freq.put("ਤੌ", 10);
    freq.put(" ਘੈ", 3);
    freq.put("ੈਂਚ", 3);
    freq.put("ਤੋ", 224);
    freq.put("ਤੈ", 50);
    freq.put("ਜੋਸ਼", 3);
    freq.put("ਤੇ", 826);
    freq.put(" ਘੁ", 7);
    freq.put("ਸਭ", 40);
    freq.put(" ਘੇ", 3);
    freq.put("ੌਂ ", 4);
    freq.put("ਜੋਰ", 3);
    freq.put("ਸਮਾ", 27);
    freq.put("ਤਿਲ", 3);
    freq.put("ਤੜ", 5);
    freq.put("ਤੋਂ", 141);
    freq.put("ਸਮਤ", 8);
    freq.put("ਮਤਿ", 6);
    freq.put(" ਘੜ", 3);
    freq.put("ਾਭਾ", 4);
    freq.put("ਜੋਤ", 5);
    freq.put("ਮਤਲ", 3);
    freq.put("਼ਾ ", 22);
    freq.put("ਤਮ", 17);
    freq.put("ਅਧ", 12);
    freq.put("ਜੋੜ", 8);
    freq.put("ੰਥ", 5);
    freq.put("ਤਪ", 4);
    freq.put("ਤਨ", 13);
    freq.put("ਹਥ ", 4);
    freq.put("ਦੇਖ", 70);
    freq.put("਼ਖਮ", 3);
    freq.put("ਤਣ", 3);
    freq.put("ੌਕ", 17);
    freq.put("ਸਮੁ", 5);
    freq.put("ਤਿ", 109);
    freq.put("ਸਮੂ", 5);
    freq.put(" ਘਿ", 3);
    freq.put(" ਘਾ", 3);
    freq.put("ਸਮੇ", 11);
    freq.put("ਤਹ", 7);
    freq.put("ਆਸ ", 7);
    freq.put("ਦੇਆ", 3);
    freq.put(" ਘਰ", 54);
    freq.put("ਤਲ", 27);
    freq.put("ਨੂੰ", 591);
    freq.put("ਤਰ", 114);
    freq.put("ਭਰੇ", 4);
    freq.put("ੜਿ ", 9);
    freq.put("ਹੂ", 11);
    freq.put("ਭਰੂ", 7);
    freq.put("ਭਰੀ", 5);
    freq.put("ੁਜ", 9);
    freq.put("ਦੇਵ", 22);
    freq.put("ਦੇਸ਼", 6);
    freq.put("ੋਹ ", 7);
    freq.put("ਦੇਰ", 6);
    freq.put("ਇਹਨ", 9);
    freq.put("ਹੁਕ", 8);
    freq.put("ਤਜ", 5);
    freq.put("ਸਹ", 46);
    freq.put(" ਘਟ", 10);
    freq.put("ੀਲ ", 3);
    freq.put("ਕਿਆ", 14);
    freq.put("ਪਕ", 6);
    freq.put("ਸਾ", 528);
    freq.put("ਤਕ", 38);
    freq.put("ਾਹ ", 60);
    freq.put("ਸਿ", 183);
    freq.put("ਰੁ", 56);
    freq.put("ਸ਼", 190);
    freq.put("ਔਕਾ", 4);
    freq.put("ਬਈ ", 4);
    freq.put("ਾਂ ", 954);
    freq.put("ਰਤਾ", 22);
    freq.put("ੀਤ ", 27);
    freq.put("ਸਲ", 42);
    freq.put("੍ਰਕ", 5);
    freq.put("ਗਦਾ", 29);
    freq.put("ਪੁ ", 3);
    freq.put("ਜਲਦ", 4);
    freq.put("ਅਸੀ", 69);
    freq.put("ਿਕ ", 17);
    freq.put("↓↓ ", 7);
    freq.put("ਊਂ", 4);
    freq.put("੍ਰਦ", 7);
    freq.put("ੰਦੀ", 120);
    freq.put("ੰਦੂ", 6);
    freq.put("ਉਨਾ", 6);
    freq.put("ੰਦੇ", 113);
    freq.put("ੀਵੇ", 3);
    freq.put("੍ਰਭ", 5);
    freq.put("य", 3);
    freq.put("੍ਰਾ", 3);
    freq.put("੍ਰਿ", 29);
    freq.put("ਊਦ", 3);
    freq.put("ੁਵਾ", 3);
    freq.put("ਏਥ", 3);
    freq.put("੍ਰਸ", 9);
    freq.put("ਊਣ", 5);
    freq.put("੍ਰੇ", 16);
    freq.put("ਗਨ", 4);
    freq.put("੍ਰੀ", 38);
    freq.put("ੂਰੀ", 23);
    freq.put("ਪਾਏ", 3);
    freq.put("੍ਰੋ", 9);
    freq.put("ਰੋਟ", 8);
    freq.put("ੰਦਰ", 44);
    freq.put("ਂਦੀ", 57);
    freq.put("ਏਡ", 3);
    freq.put("ਉਨ੍", 5);
    freq.put("ਖ਼", 18);
    freq.put("ਂਦੇ", 69);
    freq.put("ਡਰ ", 12);
    freq.put("ਕ ", 463);
    freq.put("ੰਦਿ", 6);
    freq.put("ੰਦਾ", 131);
    freq.put("ਭੁੱ", 43);
    freq.put("ੀਕੇ", 6);
    freq.put("ਰਖੀ", 4);
    freq.put("ਚੋਰ", 12);
    freq.put("ਗਦੀ", 15);
    freq.put("ੂਤੀ", 4);
    freq.put("ੈਰਾ", 12);
    freq.put("ਗਦੇ", 10);
    freq.put(" ਕਢ", 3);
    freq.put("ਜਲੀ", 6);
    freq.put("ਸੋਹ", 39);
    freq.put("ਆਵੈ", 3);
    freq.put("ੰਦਗ", 64);
    freq.put("ਖਤ", 13);
    freq.put("ੇਠ ", 3);
    freq.put("ਈਏ ", 15);
    freq.put("ਰੋਇ", 7);
    freq.put("ੇਗ", 60);
    freq.put("ਫ਼ਰ", 4);
    freq.put("ਿਚ ", 61);
    freq.put("ਥੋਂ", 17);
    freq.put("ਐਵ", 10);
    freq.put("ਫ਼ਾ", 7);
    freq.put("ਫ਼ਿ", 3);
    freq.put("ੇਕ", 24);
    freq.put("ਦੂਜ", 12);
    freq.put("ਫ਼ਤ", 5);
    freq.put("ੱਥਰ", 5);
    freq.put(" ਓਏ", 4);
    freq.put("ੇਲ ", 24);
    freq.put("ੇਓ", 4);
    freq.put("ਐਨ", 11);
    freq.put("ੇਬੇ", 10);
    freq.put(" ਅੰ", 59);
    freq.put(" ਅੱ", 147);
    freq.put("ਮੋ ", 3);
    freq.put("ਦਤ ", 13);
    freq.put(" ਓਸ", 10);
    freq.put(" ਓਹ", 52);
    freq.put(" ਫ਼ਿ", 5);
    freq.put("द", 10);
    freq.put("ਕੂੜ", 3);
    freq.put("ਸਕਿ", 5);
    freq.put("ਭੂ", 7);
    freq.put("ਨਕਸ਼", 6);
    freq.put(" ਅੜ", 6);
    freq.put("ੋਂ ", 293);
    freq.put(" ਓਨ", 6);
    freq.put("ਵੈਲ", 5);
    freq.put("ਅਹਿ", 9);
    freq.put("ਵੈਰ", 8);
    freq.put(" ।।", 5);
    freq.put("ਣਾਕ", 3);
    freq.put("਼", 396);
    freq.put(" ਓਥ", 3);
    freq.put("਼ਿ", 38);
    freq.put("ਪਾਣ", 19);
    freq.put(" ਅਮ", 32);
    freq.put("ਐੱ", 11);
    freq.put(" ਅਨ", 11);
    freq.put("ਨਕਲ", 3);
    freq.put("ਕੂਲ", 13);
    freq.put(" ਅਫ", 5);
    freq.put(" ਅਤ", 34);
    freq.put(" ਅਦ", 8);
    freq.put(" ਅਧ", 11);
    freq.put("ਤਾਨ", 16);
    freq.put(" ਅਣ", 14);
    freq.put("ਆਪਨ", 3);
    freq.put("ੌਤ ", 19);
    freq.put(" ਅਸ", 90);
    freq.put(" ਅਹ", 8);
    freq.put("ਹਾ", 378);
    freq.put(" ਅਵ", 5);
    freq.put(" ਅਸ਼", 3);
    freq.put(" ਅਰ", 13);
    freq.put("ਜਵਾ", 41);
    freq.put("ਡੀਕ", 10);
    freq.put("ੜਕ ", 4);
    freq.put("ੁਕ ", 10);
    freq.put("ੂ ", 265);
    freq.put("ੱਥੇ", 25);
    freq.put("ਰੱ", 146);
    freq.put("▓▓", 20);
    freq.put("ੱਥੋ", 3);
    freq.put("ੇਅ", 8);
    freq.put("ਗੁ ", 7);
    freq.put(" ਅਜ", 16);
    freq.put("ਫ਼ੇ", 3);
    freq.put("ਫ਼ੀ", 3);
    freq.put(" ਅਚ", 3);
    freq.put("ਾਦ ", 57);
    freq.put(" ਅਕ", 29);
    freq.put(" ਅਖ", 11);
    freq.put(" ਅਗ", 7);
    freq.put("ਮਾਈ", 3);
    freq.put("ਿਆਲ", 10);
    freq.put("ਿਆਰ", 148);
    freq.put("ਸੈ ", 4);
    freq.put("ਹਸਾ", 5);
    freq.put("ਿਆਵ", 4);
    freq.put("ਨੰ", 21);
    freq.put("ੰਵ", 5);
    freq.put("ਖੰਟ", 3);
    freq.put("ਿਆਹ", 6);
    freq.put("ਦੈ ", 10);
    freq.put("ਠਕ", 3);
    freq.put("੍ਵ", 3);
    freq.put("ਿਆਣ", 15);
    freq.put("ਿਆਦ", 13);
    freq.put("ਿਲੀ", 14);
    freq.put("੍ਲ", 4);
    freq.put("ਿਆਪ", 6);
    freq.put("ਿਆਨ", 13);
    freq.put("ਸ਼ੋ", 3);
    freq.put("੍ਹ", 73);
    freq.put("ੰਚੇ", 4);
    freq.put("ੰਡਰ", 3);
    freq.put(" ਸ਼ੇ", 5);
    freq.put("ਧ", 268);
    freq.put("ਪਾਲ", 5);
    freq.put("ਦਲੇ", 6);
    freq.put("ਰੈ ", 3);
    freq.put("ਜੇ", 159);
    freq.put("ੜਤਾ", 4);
    freq.put("ੰਡਾ", 33);
    freq.put("ੰਡਿ", 8);
    freq.put("ਿਆਂ", 97);
    freq.put("ਸ਼ਤ ", 3);
    freq.put("ਖੰਡ", 3);
    freq.put("ਠੋ", 4);
    freq.put("ਚਲੀ", 3);
    freq.put("ੰਡਨ", 3);
    freq.put("ਪੇਜ", 17);
    freq.put(" ↓ ", 26);
    freq.put("ਚਲੋ", 4);
    freq.put("ਲਜ ", 3);
    freq.put("ਤਿੱ", 4);
    freq.put("ਾਇਰ", 4);
    freq.put("ਾਇਲ", 3);
    freq.put("ਵਿਗ", 4);
    freq.put("ਚਲਾ", 12);
    freq.put("ਉਣ ", 71);
    freq.put("ੇਵ", 57);
    freq.put("ਬਕਾ", 3);
    freq.put(" ਸ਼ੌ", 4);
    freq.put("ਾਇਤ", 6);
    freq.put("ਚਲਦ", 12);
    freq.put("ਾਇਦ", 6);
    freq.put("ਦੰਦ", 4);
    freq.put("ਅੰਨ", 3);
    freq.put("ੰਡੇ", 23);
    freq.put("ਅੰਦ", 15);
    freq.put("ਾਇਮ", 4);
    freq.put("ਾਇਨ", 4);
    freq.put("ਆਰੀ", 9);
    freq.put("ਾਇਕ", 13);
    freq.put("ਓਨ", 7);
    freq.put("ਪਾਸ", 12);
    freq.put("ਵਿਖ", 5);
    freq.put("੧", 20);
    freq.put("ਉਤ", 14);
    freq.put("ਅੰਗ", 14);
    freq.put("ੁਫ", 3);
    freq.put("ਦਫ਼", 3);
    freq.put("ਾਇਆ", 45);
    freq.put(" ਬੱ", 61);
    freq.put("ਬੰਨ", 4);
    freq.put("ਬੰਧ", 5);
    freq.put("ਬੰਦ", 50);
    freq.put("ੋਠੀ", 3);
    freq.put("ੱਟਦ", 11);
    freq.put("ਗਇਆ", 3);
    freq.put("ੱਟਣ", 10);
    freq.put("ਨਸਲ", 3);
    freq.put(" ।", 36);
    freq.put(" ॥", 99);
    freq.put("ੁਪਰ", 6);
    freq.put("ਾਕੇ", 18);
    freq.put("ਨਜ਼ ", 3);
    freq.put("ਐਵੇ", 10);
    freq.put("ਕਮਲ", 20);
    freq.put("ਾਕੀ", 3);
    freq.put("ੁਸ਼ਿ", 4);
    freq.put("ਲੇ ", 213);
    freq.put("ਨੌਜ", 8);
    freq.put("ਰਬ ", 5);
    freq.put("ੱਟਿ", 7);
    freq.put("ੱਟਾ", 13);
    freq.put("ਝੜ", 4);
    freq.put("ੇਸ", 54);
    freq.put("ੇਆ ", 9);
    freq.put("¡", 5);
    freq.put("ਹੜੇ", 13);
    freq.put("ੰਜ਼", 5);
    freq.put("਼ਰ", 31);
    freq.put("ਹੜੀ", 12);
    freq.put("ਣੇ ", 125);
    freq.put("ੁਜਾ", 3);
    freq.put("ਹਮਦ", 3);
    freq.put("ੇਰ ", 37);
    freq.put("ਗ਼", 7);
    freq.put(" ਏ ", 147);
    freq.put("ਹਮਣ", 7);
    freq.put("ੱਟਗ", 3);
    freq.put("ਖ਼ੁ", 3);
    freq.put("ਪਤਾ", 28);
    freq.put("ੱਡ ", 40);
    freq.put("ਕਸ ", 7);
    freq.put("ਬਾਤ", 7);
    freq.put("ਨਪ੍", 4);
    freq.put("ਭੱ", 8);
    freq.put("ਜੜ ", 4);
    freq.put("ਹਮਲ", 10);
    freq.put("ਿਓ ", 14);
    freq.put("ਪਈ ", 14);
    freq.put(" ਜ਼ਰ", 4);
    freq.put("ਬਾਦ", 31);
    freq.put(" द", 3);
    freq.put(" त", 3);
    freq.put(" प", 3);
    freq.put("ਹਮੇ", 13);
    freq.put(" म", 5);
    freq.put("ਸੈ", 13);
    freq.put("ਟਨਾ", 5);
    freq.put("ੰਟ ", 16);
    freq.put("ਹੜਾ", 25);
    freq.put("ਤੁ ", 5);
    freq.put(" स", 9);
    freq.put(" ह", 6);
    freq.put(" ਜ਼ਮ", 4);
    freq.put("ਦਰ ", 58);
    freq.put("ੱਟੇ", 11);
    freq.put("ਤ੍ਰ", 4);
    freq.put("ਨਸ", 35);
    freq.put("ਦੇਣ", 32);
    freq.put(" आ", 4);
    freq.put("ਸੌ", 15);
    freq.put(" अ", 3);
    freq.put("ਦੱਬ", 6);
    freq.put("ਮੌਸ", 3);
    freq.put("ਬੀ ", 35);
    freq.put("ੋੜੀ", 8);
    freq.put("ਭੱਜ", 4);
    freq.put("ਾਕਾ", 13);
    freq.put("ਾਕਿ", 17);
    freq.put("ਥੋੜ", 14);
    freq.put("ਮੌਤ", 21);
    freq.put(" क", 10);
    freq.put("ਪਾਨ", 5);
    freq.put("ਤਲਾ", 4);
    freq.put("ਪਣਾ", 26);
    freq.put(" ज", 3);
    freq.put("ਢੱ", 3);
    freq.put("ਦਿਤ", 11);
    freq.put(" ਥੌ", 3);
    freq.put(" ਨਰ", 7);
    freq.put("ੁਮ", 14);
    freq.put(" ਯੂ", 4);
    freq.put("ਦਿਮ", 4);
    freq.put("ਦਿਨ", 51);
    freq.put(" ਰੜ", 3);
    freq.put("ਿਬਾ", 6);
    freq.put("ਆਨੀ", 3);
    freq.put("ਬਖ", 6);
    freq.put("ਕਮਨ", 5);
    freq.put("ੈਣ ", 22);
    freq.put("ਬਕ", 4);
    freq.put("ਮਲਿ", 6);
    freq.put("ਮਲਾ", 13);
    freq.put("ਫੁ", 26);
    freq.put("ਟਾਲ", 3);
    freq.put("ਬਜ", 10);
    freq.put("ਨਜੀ", 5);
    freq.put("ਬਚ", 17);
    freq.put("ਰੀਦ", 7);
    freq.put("ਟਾਵ", 3);
    freq.put("ਬਦ", 44);
    freq.put("ਬਤ", 18);
    freq.put("ਬਥ", 12);
    freq.put("ਸਜ਼ਾ", 5);
    freq.put("ਬਣ", 95);
    freq.put("ੰਗਰ", 10);
    freq.put("ਬੂ ", 17);
    freq.put("ੰਗਾ", 30);
    freq.put("ੀਕ ", 18);
    freq.put("ਮੈਂ", 125);
    freq.put("ਦਰ", 121);
    freq.put("ਦਿਉ", 4);
    freq.put("ਬਨ", 14);
    freq.put("ੰਗਦ", 4);
    freq.put("ੰਗਤ", 9);
    freq.put("ਬਲ", 26);
    freq.put("ੰਗਣ", 5);
    freq.put("ਬਰ", 56);
    freq.put("ੇਜ਼ ", 4);
    freq.put("ਬਾ", 266);
    freq.put("ਬਿ", 81);
    freq.put("ਟੂ", 3);
    freq.put("ਬਸ", 28);
    freq.put("ਬਹ", 84);
    freq.put("ਗਾਲ", 3);
    freq.put("ਬੇ", 97);
    freq.put("ਗਾਰ", 7);
    freq.put("ਬੂ", 38);
    freq.put("ੁਗ", 8);
    freq.put("ਜਪਾ", 10);
    freq.put("ੰਗੜ", 4);
    freq.put("ਗਾਹ", 5);
    freq.put("ਬੜੇ", 6);
    freq.put("ਬੋ", 46);
    freq.put("ਬੈ", 41);
    freq.put("ਪਤੀ", 10);
    freq.put("ੲੇ ", 5);
    freq.put("ਗਾਣ", 3);
    freq.put("ਉੱਚ", 8);
    freq.put("਼ਕ", 19);
    freq.put("ਦਿੰ", 33);
    freq.put("ਦਿੱ", 51);
    freq.put("ੰਗੀ", 18);
    freq.put("ਦਵਾ", 7);
    freq.put("ਥ", 236);
    freq.put("ਗਾਨ", 16);
    freq.put("ੇਹੜ", 3);
    freq.put("ਸ੍ਰ", 9);
    freq.put("ੌਜਵ", 8);
    freq.put("ੋਵ", 58);
    freq.put("ੁਸਨ", 4);
    freq.put("ਮੈਕ", 3);
    freq.put("ਟੋਰ", 5);
    freq.put("ਮਲੀ", 22);
    freq.put("ਮਲੇ", 19);
    freq.put("ਗਾਂ", 18);
    freq.put("ਕੌ", 26);
    freq.put("ਪਤਲ", 3);
    freq.put("ਗਾਇ", 9);
    freq.put("ਬੰ", 63);
    freq.put("ਬੱ", 64);
    freq.put("ै ", 3);
    freq.put("ਗਾਉ", 9);
    freq.put("ਲਣ ", 14);
    freq.put("ਣਕ ", 6);
    freq.put("ਢੇ ", 7);
    freq.put(" ੧", 10);
    freq.put("ੋਗ ", 9);
    freq.put(" ੫", 12);
    freq.put(" ੨", 13);
    freq.put(" ੩", 4);
    freq.put("ੁਦ ", 7);
    freq.put("ੋਡ", 12);
    freq.put(" ੲ", 5);
    freq.put("ਐ", 89);
    freq.put("ਠੰਡ", 9);
    freq.put("ੋਠ", 7);
    freq.put(" ੴ", 10);
    freq.put("ਪਲਾ", 9);
    freq.put("ਬਨੇ", 4);
    freq.put("ਬਾਂ", 6);
    freq.put("ਤੀ ", 123);
    freq.put("ਭੇਜ", 12);
    freq.put("ਥਰਾ", 4);
    freq.put("ਜ਼ਰੂ", 3);
    freq.put("ਜਗਮ", 6);
    freq.put("ਅਵ", 6);
    freq.put("ਭੇਦ", 3);
    freq.put("ਾ।", 3);
    freq.put("ੋਤ", 21);
    freq.put("ਟੇਡ", 3);
    freq.put("ਏਂ ", 3);
    freq.put("ੇਕਰ", 6);
    freq.put("ਲਈ", 109);
    freq.put("·", 7);
    freq.put("ੋਪ", 3);
    freq.put(" ਗ਼", 5);
    freq.put(" ਜ਼", 39);
    freq.put(" ਖ਼", 8);
    freq.put(" ਫ਼", 9);
    freq.put("ੇਕਾ", 3);
    freq.put("ਜ਼ਾਰ", 4);
    freq.put("ਮਾਹ", 4);
    freq.put(" ਢ", 16);
    freq.put(" ਠ", 35);
    freq.put(" ਡ", 72);
    freq.put(" ਦ", 2061);
    freq.put(" ਧ", 108);
    freq.put(" ਤ", 1659);
    freq.put(" ਥ", 56);
    freq.put(" ਪ", 1175);
    freq.put(" ਫ", 257);
    freq.put(" ਨ", 1945);
    freq.put("ਦਮ ", 5);
    freq.put(" ਮ", 1462);
    freq.put(" ਯ", 171);
    freq.put(" ਬ", 966);
    freq.put(" ਭ", 265);
    freq.put(" ਲ", 786);
    freq.put("ਠੇ", 27);
    freq.put(" ਰ", 668);
    freq.put("ਭਦ", 10);
    freq.put(" ਸ਼", 82);
    freq.put("ਔਰ", 7);
    freq.put(" ਵ", 1231);
    freq.put("ਥਾਨ", 4);
    freq.put(" ਸ", 1778);
    freq.put(" ਹ", 1388);
    freq.put(" ਿ", 24);
    freq.put("ੋਰ ", 64);
    freq.put(" ਸ਼੍", 4);
    freq.put("ਟਰ ", 22);
    freq.put(" ਇ", 440);
    freq.put(" ਅ", 543);
    freq.put(" ਊ", 3);
    freq.put("ਨੰਬ", 9);
    freq.put(" ਈ", 29);
    freq.put(" ਉ", 376);
    freq.put(" ਏ", 207);
    freq.put("ਭੈ", 6);
    freq.put(" ਓ", 102);
    freq.put(" ਐ", 82);
    freq.put("ਬਚਪ", 3);
    freq.put(" ਖ", 271);
    freq.put(" ਗ", 573);
    freq.put(" ਔ", 30);
    freq.put(" ਕ", 2429);
    freq.put(" ਚ", 632);
    freq.put(" ਛ", 99);
    freq.put(" ਘ", 118);
    freq.put(" ਟ", 103);
    freq.put(" ਜ", 1371);
    freq.put(" ਝ", 60);
    freq.put("ਸਪ", 15);
    freq.put("ਸਫ", 10);
    freq.put("ਸਨ", 33);
    freq.put("ਿਰ ", 54);
    freq.put("ੀਨਾ", 10);
    freq.put("ਸਬ", 27);
    freq.put("ਸਤ ", 17);
    freq.put("ਜਨ", 38);
    freq.put("ਲਟ ", 3);
    freq.put("ਅੱਲ", 3);
    freq.put("ਸਦ", 67);
    freq.put("ਹੈ", 221);
    freq.put("ਸਤ", 102);
    freq.put("ਮੈਨ", 70);
    freq.put(" ਨੋ", 6);
    freq.put("ੈਨੂ", 102);
    freq.put(" ਨੈ", 9);
    freq.put(" ਸ਼ਕ", 4);
    freq.put("ਲਮਾ", 5);
    freq.put("ਬਾਣ", 9);
    freq.put(" ਨੌ", 11);
    freq.put("ਅੱਡ", 3);
    freq.put(" ਨੂ", 411);
    freq.put(" ਨੁ", 8);
    freq.put(" ਨੀ", 182);
    freq.put(" ਨੇ", 299);
    freq.put("ਅੱਤ", 15);
    freq.put("ੜਵਾ", 3);
    freq.put("ਸਵ", 47);
    freq.put("ਭਵ", 3);
    freq.put("ਫੈ", 15);
    freq.put("ਅੱਜ", 80);
    freq.put("ੂਰੇ", 4);
    freq.put("ਪੂਜ", 3);
    freq.put("ਲਏ ", 6);
    freq.put(" ਨੱ", 9);
    freq.put(" ਨੰ", 14);
    freq.put("ਗੀ ", 173);
    freq.put("ਸੇ ", 139);
    freq.put("ਅੱਖ", 28);
    freq.put("ਸਚ", 10);
    freq.put(" ਸ਼ਰ", 21);
    freq.put("ਰ ", 1353);
    freq.put("ੱਤ", 177);
    freq.put("ਾਧ ", 4);
    freq.put("ਸਟ", 33);
    freq.put("ਸਜ", 9);
    freq.put(" ਸ਼ਹ", 7);
    freq.put(" ਬੂ", 10);
    freq.put("ਨਕਾ", 4);
    freq.put("ਸਖ", 6);
    freq.put("ਸਗ", 4);
    freq.put(" ਸ਼ਿ", 4);
    freq.put(" ਸ਼ਾ", 12);
    freq.put(" ਸ਼ੁ", 9);
    freq.put(" ਨਚ", 3);
    freq.put("ਰਬਜ", 3);
    freq.put("ੂਰਤ", 12);
    freq.put("ਗਲ ", 24);
    freq.put(" ਨਜ", 6);
    freq.put("ਬੀ", 82);
    freq.put("ੂਰਨ", 3);
    freq.put(" ਸ਼ੋ", 3);
    freq.put(" ਨਗ", 6);
    freq.put(" ਨਖ", 4);
    freq.put(" ਨਕ", 7);
    freq.put(" ਨਈ", 17);
    freq.put("ੇਬਾ", 3);
    freq.put("ਸ਼ਾਮ", 4);
    freq.put("ੋਇ", 50);
    freq.put("ਸੰ", 67);
    freq.put("ਸੱ", 86);
    freq.put(" कु", 3);
    freq.put("੭ ", 3);
    freq.put("ਖ ", 193);
    freq.put("ਸੋ", 108);
    freq.put(" ਨਹ", 235);
    freq.put(" ਨਸ", 10);
    freq.put(" ਨਿ", 85);
    freq.put(" ਨਾ", 548);
    freq.put("ਗਣ ", 13);
    freq.put("ਸ੍", 11);
    freq.put("ਸੂ", 43);
    freq.put("ਸੀ", 335);
    freq.put("ਦ", 4259);
    freq.put("ੈਦਾ", 9);
    freq.put(" ਨਸ਼", 7);
    freq.put(" ਨਵ", 27);
    freq.put(" ਨਫ", 9);
    freq.put("ਸਜ਼", 5);
    freq.put("ਮੰਨ", 11);
    freq.put("ੜਗ", 3);
    freq.put("ਸੜ", 18);
    freq.put("ਨਜ", 14);
    freq.put("ੀਨੀ", 5);
    freq.put("ੀਨੇ", 13);
    freq.put("ੋਣ", 76);
    freq.put("ੋਢ", 8);
    freq.put("ਰਜ਼ ", 4);
    freq.put("ੋਈ", 163);
    freq.put("ੋਧ", 12);
    freq.put("ੋਦ", 10);
    freq.put("ਵਨ ", 5);
    freq.put("ਨਿਗ", 5);
    freq.put("ੱਗਣ", 14);
    freq.put("ੋਨ", 27);
    freq.put("ਨੱਖ", 4);
    freq.put("ਖੂ", 13);
    freq.put("ੋਭ", 3);
    freq.put("ੋਬ", 4);
    freq.put("ਰਗੇ", 13);
    freq.put("੧॥", 10);
    freq.put("ਸੀਸ", 3);
    freq.put("ਫੈਸ", 9);
    freq.put("ਰਗੀ", 25);
    freq.put("ਿਖ ", 6);
    freq.put("ਪਰਤ", 4);
    freq.put("ੋਸ", 35);
    freq.put("ੳੁ", 3);
    freq.put("ਨੋ ", 5);
    freq.put("ਵੋ ", 14);
    freq.put(" ਡਰ", 18);
    freq.put("ਨੁੰ", 7);
    freq.put("ਸਵਰ", 3);
    freq.put("ਰੰਥ", 5);
    freq.put("ਿਣਾ", 12);
    freq.put("ੁਖ ", 9);
    freq.put("ਸਵਾ", 24);
    freq.put("ਖੇ", 71);
    freq.put("ੋਏ", 19);
    freq.put("ਹੁ ", 14);
    freq.put("ੜਕ", 39);
    freq.put("ਮਾਗ", 9);
    freq.put("ੀਚਾ", 3);
    freq.put("ੋਗ", 34);
    freq.put("ੋਖ", 19);
    freq.put("ੋਕ", 94);
    freq.put("ਿਸਾ", 16);
    freq.put("ਂਵੇ", 6);
    freq.put("ੋਚ", 30);
    freq.put("ਕੁ", 249);
    freq.put("ੋਟ", 42);
    freq.put("ਿਣਤ", 3);
    freq.put("ਪੇ", 49);
    freq.put("ਬੌ", 3);
    freq.put("ਦਾਦ", 4);
    freq.put("ੋਡੀ", 6);
    freq.put("ਦਾਣ", 5);
    freq.put("ਪੜ ", 13);
    freq.put("ਂਟੀ", 3);
    freq.put("ਖੌ", 3);
    freq.put(" सु", 3);
    freq.put("ਿਭਾ", 12);
    freq.put("●", 7);
    freq.put("ਦਾਨ", 4);
    freq.put("ਸਵੇ", 8);
    freq.put("ਸਵੀ", 10);
    freq.put("ਗੀਂ", 3);
    freq.put("ੰਬ ", 4);
    freq.put("ਕੀ", 273);
    freq.put("ਤਾਂ", 243);
    freq.put("ਟਿਸ", 3);
    freq.put("ਬ੍", 4);
    freq.put("ਹੁ", 345);
    freq.put("ਆਉਂ", 24);
    freq.put("ਦਾਅ", 3);
    freq.put("ਟਿਆ", 25);
    freq.put("ਦਾਂ", 24);
    freq.put("ਰਗਾ", 11);
    freq.put("ਧੀ ", 16);
    freq.put("ਗ੍ਰ", 22);
    freq.put("਼ਮ ", 3);
    freq.put("ਦਾਈ", 3);
    freq.put("ਇੰ", 28);
    freq.put(" ਐ ", 16);
    freq.put(" ਗ਼ਜ਼", 3);
    freq.put("ੌਰਾ", 3);
    freq.put("ੋਜ਼", 4);
    freq.put("ੱਠ ", 11);
    freq.put("ਪਨਾ", 3);
    freq.put("ਹੀ", 527);
    freq.put("ੋੜ", 87);
    freq.put("ਕਦੈ", 3);
    freq.put("ਅਸਤ", 3);
    freq.put("ਕਦੋ", 8);
    freq.put("ਆਪੇ", 3);
    freq.put("ਪਿਆ", 135);
    freq.put("ਕਦੀ", 39);
    freq.put("ਮਾਮ", 16);
    freq.put("ਾਨਿ", 6);
    freq.put("ਾਨਾ", 26);
    freq.put("ਛੜਨ", 3);
    freq.put("ਾਨਸ", 3);
    freq.put("ਗਿਣ", 7);
    freq.put("ਕਦੇ", 70);
    freq.put("ਾਨਤ", 3);
    freq.put("ਾਨਦ", 6);
    freq.put("ਅਸਲ", 6);
    freq.put("ੱਦਲ", 3);
    freq.put("ਾਨਣ", 4);
    freq.put("ਸਤਾ", 25);
    freq.put("ਅਸਾ", 7);
    freq.put("ਪਿਛ", 3);
    freq.put("ਗਿਰ", 5);
    freq.put("ਗਿਲ", 3);
    freq.put("ਾਨਕ", 20);
    freq.put("ਝਣਾ", 3);
    freq.put("ਆਂਗ", 4);
    freq.put("ਪਨੇ", 8);
    freq.put(" ▓", 4);
    freq.put("ਬ੍ਰ", 3);
    freq.put("ਭੈਣ", 5);
    freq.put("ਗਿਆ", 90);
    freq.put("ਸੌਂ", 7);
    freq.put("ੱਗੇ", 8);
    freq.put("ੂਜਾ", 8);
    freq.put("ਪਿਸ", 3);
    freq.put("਼ੂ", 3);
    freq.put("ਟ ", 156);
    freq.put("ਬਿਲ", 4);
    freq.put(" ਡੋ", 3);
    freq.put("ਗਈ ", 50);
    freq.put("ਬਾਜ਼", 3);
    freq.put("ਸਟ ", 4);
    freq.put("ਇਲਾ", 4);
    freq.put("ਦੇਂ", 4);
    freq.put("ਬਿਸ", 6);
    freq.put("ਣੀ ", 144);
    freq.put("ਲਾਇ", 9);
    freq.put("ਾਰ", 746);
    freq.put("ੱਦਤ", 3);
    freq.put("ਕ਼", 10);
    freq.put("ਂਡ", 11);
    freq.put("ਬਿਤ", 3);
    freq.put("ਫੋ", 24);
    freq.put("ਹੱਕ", 8);
    freq.put("੍ਰਧ", 9);
    freq.put("ਬਿਨ", 28);
    freq.put("ਗਿੱ", 4);
    freq.put("਼ੌ", 7);
    freq.put("दरत", 3);
    freq.put("਼੍", 12);
    freq.put("ਅਸੂ", 3);
    freq.put("ਾਵੈ", 6);
    freq.put("ਕਦਮ", 3);
    freq.put("ੈਕਸ", 3);
    freq.put("ਹੱਥ", 22);
    freq.put("ਹੱਤ", 6);
    freq.put("ਪ੍ਰ", 74);
    freq.put("ਹੱਦ", 8);
    freq.put("ਅ ", 14);
    freq.put("ਰਿ ", 23);
    freq.put("ਪਿੰ", 24);
    freq.put("ਪਿੱ", 17);
    freq.put("ਾਨੇ", 12);
    freq.put("ੋੰ", 4);
    freq.put("ਾਨੁ", 5);
    freq.put("ਾਨੀ", 47);
    freq.put("ਕਦਾ", 27);
    freq.put("ਾਵੇ", 72);
    freq.put("ਕਦਰ", 7);
    freq.put("ਮਾਵ", 9);
    freq.put("ਾਨੋ", 3);
    freq.put("ਹੱਲ", 4);
    freq.put("ਾਮਿ", 3);
    freq.put("ਘੈਂ", 3);
    freq.put("ਨਕ ", 13);
    freq.put("ਿਹੋ", 3);
    freq.put("ਯੋਗ", 6);
    freq.put("ਲਕ", 28);
    freq.put("ਗਹਿ", 4);
    freq.put("ੋਵੇ", 49);
    freq.put("ਦਾਰ", 58);
    freq.put("ਾਮਲ", 15);
    freq.put("ਿਹੀ", 9);
    freq.put("ੀਦ ", 12);
    freq.put("ਕਤੀ", 8);
    freq.put("ਿਹੜ", 42);
    freq.put("ਔ", 30);
    freq.put("ਾਮਦ", 4);
    freq.put("ਫ਼ਿਲ", 3);
    freq.put("ਆਉਣ", 16);
    freq.put("ਰੀਜ਼", 3);
    freq.put("ਖਵ", 15);
    freq.put(" ॥੧", 9);
    freq.put("ੁਹੱ", 10);
    freq.put("ਉਕ", 4);
    freq.put("ਲਜ", 9);
    freq.put("ਜੱਟ", 33);
    freq.put("ਲ ", 803);
    freq.put("ਬਹੁ", 69);
    freq.put("ਝੋ ", 8);
    freq.put("ਰੰਗ", 21);
    freq.put("ਨੰ ", 4);
    freq.put("ਸ਼੍ਰ", 4);
    freq.put("ਿਹੰ", 9);
    freq.put("ਰੀਰ", 3);
    freq.put("ਤਮ ", 9);
    freq.put("ਤੈਨ", 38);
    freq.put("ਬਹਾ", 3);
    freq.put("ਬਹਿ", 11);
    freq.put("ੋਚਣ", 3);
    freq.put("ੋਚਦ", 5);
    freq.put("ਖੇ ", 41);
    freq.put("ਸੀਂ", 54);
    freq.put("ਰੀਫ", 5);
    freq.put("ਡੱਬ", 3);
    freq.put("ਲਾ ", 192);
    freq.put("ਰੀਮ", 9);
    freq.put("ਰੀਬ", 9);
    freq.put("ਕਤਲ", 5);
    freq.put("ਮਾਤ", 3);
    freq.put("ੰਝੂ", 6);
    freq.put("ਰੀਕ", 16);
    freq.put("ਿਹਨ", 17);
    freq.put("ਿਹਦ", 8);
    freq.put("ਤਲਵ", 3);
    freq.put("ਿਹਤ", 3);
    freq.put("ੋਣ ", 34);
    freq.put("ਪੋਲ", 4);
    freq.put("ਜੈਸ", 3);
    freq.put("ਿਹਾ", 88);
    freq.put(" ਦੂ", 29);
    freq.put("ਸਫਾ", 3);
    freq.put("ਰੀਆ", 47);
    freq.put("ਰੀਅ", 5);
    freq.put("ਾਮੇ", 4);
    freq.put("ਸਫਰ", 3);
    freq.put("ਰੀਏ", 19);
    freq.put("ਿਹਲ", 4);
    freq.put("ਾਮੁ", 6);
    freq.put("ਾਮੀ", 10);
    freq.put("ु", 17);
    freq.put("ਕਲਦ", 3);
    freq.put(" ਕਟ", 4);
    freq.put("ਮਜ਼ਦ", 3);
    freq.put(" ਇੰ", 28);
    freq.put(" ਇੱ", 104);
    freq.put("ਤਸਰ", 6);
    freq.put("ਕਲਮ", 5);
    freq.put("ਪੂ ", 21);
    freq.put("ੇਖੇ", 10);
    freq.put("ਤਕਦ", 10);
    freq.put("ਲਵੇ", 7);
    freq.put("ਦੱਸ", 37);
    freq.put("ੂਠ ", 6);
    freq.put("ਦੀਆ", 101);
    freq.put(" ਕਈ", 16);
    freq.put(" ਕਉ", 7);
    freq.put("ਤਕਾ", 12);
    freq.put("ੂਲੀ", 4);
    freq.put("ਕਲਾ", 11);
    freq.put("ਕਲਿ", 5);
    freq.put("ਸੰਗ", 17);
    freq.put("ਆਖ", 20);
    freq.put("ਦੀਵ", 5);
    freq.put("ਕੀੜ", 4);
    freq.put(" ਕਿ", 379);
    freq.put(" ਕਸ", 8);
    freq.put("ਸੰਮ", 12);
    freq.put(" ਡੱ", 4);
    freq.put("ਸਣ", 15);
    freq.put("ਆਖਦ", 4);
    freq.put(" ਕਰ", 451);
    freq.put("ਸੰਦ", 10);
    freq.put(" ਕਲ", 22);
    freq.put("ਸ਼ੱਕ", 3);
    freq.put(" ਕਬ", 11);
    freq.put("ੇਬ ", 5);
    freq.put(" ਕਮ", 48);
    freq.put("ਸੰਸ", 6);
    freq.put(" ਕਪ", 4);
    freq.put(" ਕਫ", 5);
    freq.put(" ਕਤ", 6);
    freq.put("ਫਾਇ", 7);
    freq.put(" ਕਦ", 85);
    freq.put("ੱਚੇ", 11);
    freq.put("ਫਾਂ", 5);
    freq.put("ਚਣ", 6);
    freq.put("ਸੰਵ", 3);
    freq.put(" ਕਣ", 4);
    freq.put(" ਇਸ਼", 6);
    freq.put("ਲਾਜ਼", 3);
    freq.put("ਤੋ ", 50);
    freq.put(" ਇਲ", 9);
    freq.put("ਅਤੇ", 32);
    freq.put("ਂਕ ", 4);
    freq.put("ਕੀਹ", 5);
    freq.put("ਕੀਰ", 3);
    freq.put(" ਇਹ", 91);
    freq.put("ਕੀਮ", 6);
    freq.put(" ਕ੍", 6);
    freq.put(" ਇਤ", 9);
    freq.put(" ਇਥ", 8);
    freq.put(" ਕੈ", 30);
    freq.put("ਕੀਨ", 10);
    freq.put("ਜਥੇ", 3);
    freq.put(" ਇਮ", 9);
    freq.put("ਲੁਟ", 4);
    freq.put("ਕੀਤ", 73);
    freq.put(" ਕੇ", 258);
    freq.put(" ਕੀ", 203);
    freq.put(" ਕੁ", 236);
    freq.put(" ਇਨ", 20);
    freq.put("ि ", 5);
    freq.put("ਰੂ", 167);
    freq.put(" ਇਕ", 75);
    freq.put("ਕਲੀ", 11);
    freq.put("ਹੜ", 57);
    freq.put("ੇਖਣ", 9);
    freq.put(" ਇਜ", 4);
    freq.put(" ਕੰ", 44);
    freq.put(" ਕੱ", 72);
    freq.put("ਗੜ", 15);
    freq.put(" ੲੇ", 3);
    freq.put("ਝੇ ", 9);
    freq.put("ੇਖਾ", 11);
    freq.put("ਫੈਨ", 3);
    freq.put("ਘੱਟ", 16);
    freq.put("ਕੀਆ", 3);
    freq.put("ਾਤ ", 39);
    freq.put("ੈ ", 351);
    freq.put("ㅤㅤ ", 11);
    freq.put("ਫੜ", 16);
    freq.put("ਪੀ ", 19);
    freq.put("ਰੇ", 410);
    freq.put(" है", 3);
    freq.put("ਪੂ", 50);
    freq.put(" ਹੋ", 335);
    freq.put("ਹਾਸ", 10);
    freq.put("ਹਾਹ", 3);
    freq.put("ੋਆ", 7);
    freq.put(" ਹੀ", 169);
    freq.put(" ਹੁ", 225);
    freq.put("ਜੜ", 8);
    freq.put("ਹਾਰ", 27);
    freq.put("ਬਿੰ", 5);
    freq.put("ਹਾਲ", 34);
    freq.put(" ਹੇ", 9);
    freq.put("ैं", 3);
    freq.put("੩ ", 7);
    freq.put("ਾਪ ", 8);
    freq.put("ਹਾਨ", 21);
    freq.put("ਵਿਵ", 4);
    freq.put("ਜੁ", 21);
    freq.put("ਹਾਤ", 3);
    freq.put("ਹੰ", 29);
    freq.put("ਹਾਦ", 8);
    freq.put("ਵਿਸ", 7);
    freq.put("ਹਾਡ", 14);
    freq.put("ਜੈ", 9);
    freq.put("ਹਾਣ", 8);
    freq.put("ਹਾਜ", 3);
    freq.put("ਿ ", 203);
    freq.put("ਹੋ", 360);
    freq.put("ਲੱਭ", 23);
    freq.put("ਹ੍", 3);
    freq.put("ਵਿਆ", 10);
    freq.put("ਵਿਅ", 5);
    freq.put("ਜੱ", 52);
    freq.put("ਓਸਨ", 3);
    freq.put("न", 7);
    freq.put("ੰਵੇ", 3);
    freq.put("ैं ", 3);
    freq.put("ਫਰਾ", 5);
    freq.put("ੈਟ ", 3);
    freq.put("ਦਮ", 9);
    freq.put("ੋਰੂ", 3);
    freq.put("ਹਾਏ", 8);
    freq.put("ਹਾਈ", 9);
    freq.put("ਹਾਉ", 4);
    freq.put("ਵਿਕ", 16);
    freq.put("ਦੌਰ", 5);
    freq.put(" ਹੰ", 14);
    freq.put(" ਹੱ", 63);
    freq.put("ਗੰਦ", 6);
    freq.put("ਹਾਂ", 97);
    freq.put("ਜਖ", 6);
    freq.put("ਹਨ", 115);
    freq.put("ਹਫ", 3);
    freq.put("ਤੌ ", 3);
    freq.put("ਹਬ", 7);
    freq.put("ਬੂਰ", 4);
    freq.put("ਹਣ", 47);
    freq.put("ਵਧ ", 6);
    freq.put("ਹਥ", 9);
    freq.put("ਹਤ", 15);
    freq.put("ੋਰਾ", 8);
    freq.put("ਹਦ", 66);
    freq.put("ਵਾਈ", 17);
    freq.put("ਚਰਨ", 7);
    freq.put("ਵਿੱ", 116);
    freq.put("ਵਿੰ", 4);
    freq.put("ਸ਼ਕਲ", 3);
    freq.put("ਗ਼ਜ਼ਲ", 3);
    freq.put("ਹਿ", 403);
    freq.put(" ਹਟ", 3);
    freq.put("ਾਅਦ", 21);
    freq.put("ਸ਼ਕਿ", 4);
    freq.put("ਹਲ", 30);
    freq.put("ਸਥ", 5);
    freq.put("ਰਤੂ", 3);
    freq.put("ਸਲ ", 6);
    freq.put("ਹਾੜ", 7);
    freq.put("ਚਰਚ", 3);
    freq.put("ਜਲ", 19);
    freq.put("ਉਹੀ", 12);
    freq.put(" ਹਮ", 31);
    freq.put("ਬਥੇ", 12);
    freq.put("ਜਾ", 508);
    freq.put("ਜਿ", 286);
    freq.put("਼ਲ", 3);
    freq.put("੪", 14);
    freq.put(" ਹਥ", 8);
    freq.put(" ਹਦ", 3);
    freq.put("ਜਹ", 17);
    freq.put(" ਹਸ", 6);
    freq.put("ਬੂਹ", 5);
    freq.put("ਾਮ", 142);
    freq.put("ਪਿਓ", 5);
    freq.put("ਲਪ", 3);
    freq.put(" ਹਾ", 127);
    freq.put(" ਹਿ", 22);
    freq.put(" ਹਰ", 72);
    freq.put("ੋੜ ", 45);
    freq.put(" ਹਲ", 7);
    freq.put("ਹਕ", 3);
    freq.put(" ਹਵ", 7);
    freq.put("ੁੜ ", 8);
    freq.put("ਆਂਦ", 3);
    freq.put("ਿੱਧ", 9);
    freq.put("ਿੱਦ", 4);
    freq.put("ਂਆ", 4);
    freq.put("ਿੱਤ", 79);
    freq.put("ਗੜ੍", 3);
    freq.put(" ਫਤ", 5);
    freq.put("ਿੱਠ", 21);
    freq.put("ਗੜੀ", 3);
    freq.put("ਖਬ", 19);
    freq.put("॥੧", 9);
    freq.put("ਂਈ", 4);
    freq.put("ੋਢੇ", 3);
    freq.put("ਂਕ", 14);
    freq.put(" ਫਰ", 17);
    freq.put("ਆਸਾ", 4);
    freq.put("ਕ", 3733);
    freq.put("ਿੱਲ", 35);
    freq.put("ਪੈਣ", 12);
    freq.put("ੜਨ ", 12);
    freq.put("ਂਜ", 6);
    freq.put("ਰਮ ", 21);
    freq.put(" ਫਸ", 10);
    freq.put("ਂਟ", 12);
    freq.put(" ਫਾ", 16);
    freq.put(" ਫਿ", 65);
    freq.put(" ਫ਼", 15);
    freq.put("ਿੱਸ", 4);
    freq.put("ਂਤ", 4);
    freq.put("ੁ ", 118);
    freq.put("ਂਦ", 203);
    freq.put("ਪੀੜ", 5);
    freq.put("ਾਸ ", 40);
    freq.put("ਣਾ ", 220);
    freq.put("ਂਣ", 3);
    freq.put("ਂਬ", 3);
    freq.put("ਂਭ", 3);
    freq.put("ਂਮ", 3);
    freq.put("ਮੂੰ", 13);
    freq.put("ਂਨ", 9);
    freq.put("ਂਪ", 7);
    freq.put(" ਚੰ", 52);
    freq.put("ਿੱਗ", 6);
    freq.put("ਫੁਲ", 4);
    freq.put("ੁਰੂ", 83);
    freq.put("ਿੱਟ", 13);
    freq.put("ਧਨ", 12);
    freq.put("ਂਸ", 14);
    freq.put("ਂਹ", 13);
    freq.put("ੱਧ ", 20);
    freq.put("ਭਾਈ", 12);
    freq.put("ਭਾਉ", 10);
    freq.put("ੇਆਂ", 3);
    freq.put("ਿਜਲ", 6);
    freq.put(" ਫੱ", 6);
    freq.put("ਚਾਇ", 4);
    freq.put("ਚਾਅ", 3);
    freq.put("ੁਟਾ", 3);
    freq.put("ੌ ", 21);
    freq.put("ਿਜਹ", 3);
    freq.put("ਚਾਉ", 8);
    freq.put("ਚਾਈ", 6);
    freq.put("ਘੇਰ", 3);
    freq.put("ਮੂਹ", 9);
    freq.put("ਚਾਰ", 30);
    freq.put(" ਫੇ", 35);
    freq.put("ਢੀ ", 5);
    freq.put("ੀਂਹ", 4);
    freq.put("ਚਾਹ", 47);
    freq.put("कु", 3);
    freq.put("ਧਰ ", 8);
    freq.put("ੋਚ ", 12);
    freq.put("ੁਰੀ", 5);
    freq.put("ਵਸ", 10);
    freq.put("ਵੁੱ", 3);
    freq.put("ਫੁੱ", 16);
    freq.put("ਰੀ ", 386);
    freq.put("ਗੜਾ", 6);
    freq.put("ਚਾਨ", 5);
    freq.put("ਧਾਨ", 15);
    freq.put("ੁਨਿ", 6);
    freq.put(" ਫੜ", 15);
    freq.put("ਲੁ", 19);
    freq.put("ਲਗੀ", 7);
    freq.put("ो ", 4);
    freq.put("ਦੂ ", 5);
    freq.put("ਾਣ", 161);
    freq.put("ਬਸਾ", 3);
    freq.put("ਉਦਾ", 18);
    freq.put("ਵਣ ", 10);
    freq.put("ਅੰ", 61);
    freq.put("ਹੰਜ", 3);
    freq.put("ਹੰਝ", 6);
    freq.put("ੋ ", 527);
    freq.put("ਟਦ", 13);
    freq.put("ੀਲਾ", 7);
    freq.put(" ਚੂ", 4);
    freq.put("ੱਤੇ", 39);
    freq.put("ਮੀਆ", 5);
    freq.put("ਦਸਤ", 4);
    freq.put(" ㅤ", 16);
    freq.put("ੱਤੀ", 18);
    freq.put("ਨ", 3567);
    freq.put("प", 7);
    freq.put("ੇਠ", 7);
    freq.put(" ਗਮ", 4);
    freq.put("ਨੈ", 12);
    freq.put("ਹੰਦ", 15);
    freq.put("ੱਬ ", 68);
    freq.put("ਨੌ", 11);
    freq.put("ਨ੍", 23);
    freq.put("ι", 4);
    freq.put("ਨੀ", 363);
    freq.put("ਲੋ", 178);
    freq.put("ਸ਼ੂ", 3);
    freq.put("ਠ ", 32);
    freq.put("ਨਹ", 244);
    freq.put("ਨਾ", 814);
    freq.put("ਸਪੀ", 4);
    freq.put("ੈਸ਼ਨ", 3);
    freq.put("ਨਲ", 7);
    freq.put(" ਔਖ", 15);
    freq.put(" ਔਕ", 4);
    freq.put("ਫਿਲ", 11);
    freq.put("ਨਸ਼", 12);
    freq.put("ਤੇ ", 562);
    freq.put("ਜਗ", 18);
    freq.put("ਨਵ", 36);
    freq.put("ਓਥੇ", 3);
    freq.put(" ਏਹ", 5);
    freq.put("ਦਲ ", 40);
    freq.put("ੱਤਲ", 3);
    freq.put("ੂੜ", 4);
    freq.put("ੱਤਰ", 27);
    freq.put("ੱਤਾ", 29);
    freq.put("ੱਤਿ", 7);
    freq.put("ਵੇਗ", 27);
    freq.put("ਵੇਖ", 39);
    freq.put("ਨਤ", 17);
    freq.put("ਨਚ", 4);
    freq.put("٠", 5);
    freq.put("ਰੇ ", 343);
    freq.put("ਲਗਦ", 23);
    freq.put("੨", 19);
    freq.put("ੇਓ ", 3);
    freq.put("ਲਾਜ", 3);
    freq.put("ਫਿਕ", 11);
    freq.put("ਜਤਾ", 3);
    freq.put(" ਔਰ", 7);
    freq.put("ਲਾਓ", 3);
    freq.put("ਵੇਹ", 3);
    freq.put("ਉਦੇ", 5);
    freq.put("ਉਦੀ", 19);
    freq.put("ਬਸੂ", 3);
    freq.put("ਠੀਕ", 7);
    freq.put("ਵੇਲ", 13);
    freq.put("ਵੇਰ", 8);
    freq.put("ੁਸ਼ ", 6);
    freq.put("ਲਗਾ", 12);
    freq.put("ਉਦੋ", 6);
    freq.put(" ਆਰ", 7);
    freq.put(" ਆਲ", 6);
    freq.put(" ਆਵ", 20);
    freq.put("ਂਗੇ", 21);
    freq.put(" ਆਸ਼", 5);
    freq.put(" ਆਹ", 15);
    freq.put("ਕੁਰ", 6);
    freq.put("ਕੁਲ", 5);
    freq.put("਼ਤਿ", 3);
    freq.put("਼ਤਾ", 6);
    freq.put("ਹਿੱ", 8);
    freq.put("ਹਿੰ", 104);
    freq.put("ਓ", 193);
    freq.put(" ਚਮ", 3);
    freq.put("क", 12);
    freq.put(" ਆਤ", 4);
    freq.put("ੁਤ ", 57);
    freq.put("ਕੁਮ", 7);
    freq.put("ੇਲੀ", 23);
    freq.put(" ਆਨ", 3);
    freq.put(" ਆਪ", 150);
    freq.put(" ਗ਼", 5);
    freq.put("ੁੰਮ", 3);
    freq.put("ਕੁਦ", 4);
    freq.put("ਲੀਡ", 3);
    freq.put(" ਆਓ", 5);
    freq.put("ਕਰਵ", 14);
    freq.put(" ਆਕ", 10);
    freq.put("¤", 3);
    freq.put("ਕੁਟ", 5);
    freq.put(" ਆਖ", 19);
    freq.put("਼ੇਲ", 3);
    freq.put("ਕਰਲ", 5);
    freq.put("਼ੇਰ", 7);
    freq.put("ਧੰ", 11);
    freq.put(" ਆਜ", 4);
    freq.put(" ਆਟ", 3);
    freq.put("ਖਨ ", 3);
    freq.put("ਆ ", 812);
    freq.put("ਾਣੀ", 49);
    freq.put(" ਆਂ", 24);
    freq.put("਼ਹ", 8);
    freq.put(" ਆਇ", 22);
    freq.put(" ਆਉ", 57);
    freq.put(" ਆਈ", 27);
    freq.put(" ਆਊ", 4);
    freq.put("ਖੱ", 11);
    freq.put("ੂਜੇ", 4);
    freq.put(" ਆਏ", 9);
    freq.put("ਕੁਆ", 3);
    freq.put(" ਚਿ", 29);
    freq.put("ਓਏ ", 4);
    freq.put("ੇਗੀ", 25);
    freq.put("ਖੱਜ", 3);
    freq.put("ਹਿਸ", 12);
    freq.put("ਕੁੱ", 34);
    freq.put("ਕੁੰ", 3);
    freq.put("ਹਿਲ", 39);
    freq.put("ਆਲ ", 4);
    freq.put("ਹਿਰ", 17);
    freq.put("ਹਿਯ", 3);
    freq.put("ਹਿਮ", 5);
    freq.put("ਰਤੀ", 20);
    freq.put("ਹਿਬ", 31);
    freq.put("ਟਦੇ", 3);
    freq.put("ਲਾਂ", 81);
    freq.put("ਆਉ", 59);
    freq.put("ਹਿਦ", 9);
    freq.put("ਹਿਤ", 8);
    freq.put("ਹਿਣ", 36);
    freq.put("ੇਰੀ", 155);
    freq.put("ς੭ ", 3);
    freq.put("ਮੀਦ", 4);
    freq.put("ਾਗ ", 14);
    freq.put("ਕੁੜ", 108);
    freq.put("ਟੁੱ", 21);
    freq.put("ਹਿਗ", 52);
    freq.put("ਗਰ ", 10);
    freq.put("ਹਿਕ", 8);
    freq.put("ਓਹਨ", 6);
    freq.put("ਗੱਲ", 65);
    freq.put("ੌਲ ", 3);
    freq.put("ੜਵ", 3);
    freq.put("ਗੱਭ", 3);
    freq.put("ਗੱਬ", 3);
    freq.put("਼ਤੇ", 4);
    freq.put("ਖੱਬ", 4);
    freq.put("ਆਤ", 5);
    freq.put("ਚੇ ", 23);
    freq.put("ਹਿਆ", 7);
    freq.put("ੈਠਾ", 13);
    freq.put("ਗੱਡ", 10);
    freq.put("ਖਨ", 3);
    freq.put(" ਪੜ", 33);
    freq.put("ਡਣ", 4);
    freq.put("ਬੱਚ", 19);
    freq.put("ਸ਼ਿਕ", 5);
    freq.put("ਸਦ ", 3);
    freq.put("ਥੇਰ", 12);
    freq.put("ਿਨਾ", 41);
    freq.put("ਿਲ ", 154);
    freq.put("ਡਮ", 6);
    freq.put(" ਪ੍", 66);
    freq.put(" ਸਚ", 10);
    freq.put("ਰਵਾ", 35);
    freq.put(" ਸਟ", 13);
    freq.put(" ਪੈ", 80);
    freq.put(" ਪੋ", 13);
    freq.put(" ਸਜ", 7);
    freq.put("ਿਬ", 34);
    freq.put("ਇੰਨ", 12);
    freq.put(" ਪੇ", 35);
    freq.put("ੱਗ ", 43);
    freq.put(" ਪੁ", 86);
    freq.put(" ਪੀ", 27);
    freq.put(" ਸਕ", 66);
    freq.put(" ਪੂ", 24);
    freq.put(" ਸਫ", 10);
    freq.put(" ਸਪ", 11);
    freq.put(" ਸਨ", 9);
    freq.put("ਬੱਸ", 16);
    freq.put(" ਸਮ", 88);
    freq.put(" ਸਭ", 40);
    freq.put(" ਸਬ", 17);
    freq.put(" ਸਣ", 7);
    freq.put("ਤਰਾ", 29);
    freq.put(" ਪੱ", 50);
    freq.put(" ਪੰ", 81);
    freq.put("ਬੱਲ", 6);
    freq.put(" ਸਤ", 30);
    freq.put("ਬੱਬ", 9);
    freq.put("ਰਖ ", 5);
    freq.put(" ਸਹ", 45);
    freq.put(" ਸਿ", 155);
    freq.put(" ਸਾ", 415);
    freq.put("ਗੂ ", 8);
    freq.put("ਸੁੱ", 14);
    freq.put(" ਸਲ", 14);
    freq.put("ਬੱਦ", 3);
    freq.put(" ਸਰ", 80);
    freq.put("ਬੱਡ", 3);
    freq.put("ਾਥ ", 13);
    freq.put("ਾ", 8410);
    freq.put(" ਸੋ", 95);
    freq.put(" ਪਟ", 13);
    freq.put(" ਸੈ", 8);
    freq.put(" ਪਛ", 5);
    freq.put("ਹੱਬ", 10);
    freq.put(" ਸੂ", 25);
    freq.put(" ਸੁ", 108);
    freq.put("ਿਓਂ", 4);
    freq.put(" ਸੇ", 15);
    freq.put("ੇਮਿ", 4);
    freq.put("ਏ ", 361);
    freq.put("ਾਫ ", 12);
    freq.put("ਖਸ਼", 3);
    freq.put(" ਪਏ", 6);
    freq.put("ੈਕੇ", 4);
    freq.put("ਉਹਦ", 25);
    freq.put(" ਪਈ", 13);
    freq.put("ਕਢ", 3);
    freq.put("ਜਨ ", 10);
    freq.put("ਪੈਰ", 16);
    freq.put("ਪੁੱ", 37);
    freq.put("ਤਰੋ", 3);
    freq.put("ੈਂਨ", 6);
    freq.put("ਨ੍ਹ", 22);
    freq.put("ਡੀ", 162);
    freq.put(" ਪਿ", 190);
    freq.put(" ਪਾ", 158);
    freq.put(" ਪਹ", 53);
    freq.put(" ਪਸ", 11);
    freq.put("ਡੇ", 110);
    freq.put("ੈਸਲ", 7);
    freq.put(" ਪਵ", 8);
    freq.put("ਡੈ", 3);
    freq.put("ਡੋ", 3);
    freq.put("ਤਬਾ", 6);
    freq.put(" ਪਰ", 147);
    freq.put("ਝੂ ", 5);
    freq.put(" ਪਲ", 28);
    freq.put("ਰੋ ", 54);
    freq.put("ਨਖਰ", 4);
    freq.put("ਜੰ", 22);
    freq.put(" ਪਥ", 4);
    freq.put(" ਪਤ", 33);
    freq.put(" ਸੱ", 84);
    freq.put(" ਸੰ", 57);
    freq.put("ੌਤਾ", 3);
    freq.put(" ­ ", 3);
    freq.put("ੂਬਸ", 3);
    freq.put("ਨਫ਼", 3);
    freq.put("ਖਮੀ", 4);
    freq.put("ੈਨਸ਼", 4);
    freq.put("ਨਫਰ", 6);
    freq.put("ਹੁੱ", 8);
    freq.put("ਹੁੰ", 168);
    freq.put("ਮਾਲ", 15);
    freq.put("ਾੜ ", 9);
    freq.put("ੋਣਗ", 5);
    freq.put("ਬਿਜ", 6);
    freq.put("਼ ", 67);
    freq.put("ੁਟੀ", 3);
    freq.put("ਭਣ ", 3);
    freq.put("ੌੜੀ", 5);
    freq.put("कुद", 3);
    freq.put("ਪੜ", 46);
    freq.put("ਧੇ", 7);
    freq.put("ਸਨ ", 12);
    freq.put("ਆਲੇ", 4);
    freq.put("ਮ੍ਰ", 8);
    freq.put("ੀਜਾ", 4);
    freq.put("ਇਜ", 4);
    freq.put("ੀਜ਼", 4);
    freq.put("ਂਝਾ", 3);
    freq.put("਼ਟਰ", 3);
    freq.put("ਸਹੀ", 5);
    freq.put("ਪ੍", 74);
    freq.put("ਪੈ", 83);
    freq.put("ਫਾ ", 10);
    freq.put("ਸਹੇ", 14);
    freq.put("ਜ਼ਖਮ", 3);
    freq.put("ਬਿਆ", 3);
    freq.put("ੳ ", 4);
    freq.put("ਪੀ", 41);
    freq.put("ਪੁ", 97);
    freq.put("ਿਯੋ", 3);
    freq.put("ਹੱਸ", 16);
    freq.put("ਟਣਾ", 4);
    freq.put("ਵਜੋ", 5);
    freq.put("਼ਮ", 8);
    freq.put("ਪਿ", 202);
    freq.put("ਢ ", 9);
    freq.put("ਹੁਸ", 4);
    freq.put("ਫੱ", 6);
    freq.put("ਪਵ", 9);
    freq.put("ਸੜਕ", 7);
    freq.put("ਾਨੂ", 75);
    freq.put("ਪਰ", 160);
    freq.put("ੁਜ਼", 3);
    freq.put("ਸਹਾ", 4);
    freq.put("ਹੁਲ", 5);
    freq.put("ਮਣੀ", 3);
    freq.put("ਕੰ", 46);
    freq.put("ਪਨ", 21);
    freq.put("ਲਈਏ", 3);
    freq.put("ਮਨਜ", 3);
    freq.put("ਬੁਝ", 4);
    freq.put("ਹੁਤ", 66);
    freq.put("ਪਦ", 8);
    freq.put("ਾਏ", 37);
    freq.put("ਆਲਾ", 7);
    freq.put("ਹੁਣ", 57);
    freq.put("ਲੂ ", 3);
    freq.put("ਆਓ ", 3);
    freq.put("ਖੋਹ", 5);
    freq.put("ਗਮ ", 10);
    freq.put("ਪਟ", 17);
    freq.put("ੰਘਾ", 3);
    freq.put("ਇਹੋ", 3);
    freq.put("ਪਛ", 5);
    freq.put("੩", 7);
    freq.put("ਾਓ", 12);
    freq.put("ਖੋਲ", 10);
    freq.put("ਇਤ", 15);
    freq.put("ੌਮ ", 4);
    freq.put("ਪਏ", 9);
    freq.put("ਪਈ", 15);
    freq.put("਼ਨ ", 12);
    freq.put("ੇਸ਼", 15);
    freq.put("ਸੜਦ", 4);
    freq.put("ੇਸਾ", 3);
    freq.put("ਖੋਣ", 4);
    freq.put("ੱਦ ", 13);
    freq.put("ੰਘਦ", 4);
    freq.put("ਹੁਂ", 6);
    freq.put("ਟਰੀ", 3);
    freq.put(" ਗੰ", 10);
    freq.put("ਸਲੋ", 4);
    freq.put("ਾਮਾ", 12);
    freq.put("ਨਤ ", 4);
    freq.put("ਸਲੇ", 7);
    freq.put("ਆਂ ", 386);
    freq.put("ਸਲੀ", 3);
    freq.put("ਤੈਥ", 4);
    freq.put("ਿਦੇ", 5);
    freq.put("ਜ਼ਾਂ", 3);
    freq.put("ਸ਼ਮਣ", 3);
    freq.put("ੀਗੜ", 5);
    freq.put("ੁਦਰ", 4);
    freq.put("ੇਣਾ", 15);
    freq.put("ਛਣ", 4);
    freq.put("ੇਲਾ", 8);
    freq.put("ਭੇ ", 3);
    freq.put("ੱਛਿ", 3);
    freq.put(" ਜੱ", 52);
    freq.put("ੋਲ", 96);

    init3();
  }
  private static void init3() {
    
    freq.put("ਘੁੰ", 4);
    freq.put(" ਉਤ", 14);
    freq.put("ਪੂਰ", 24);
    freq.put("ਟੇ ", 21);
    freq.put("ਜ਼ਾ ", 8);
    freq.put("ਿਹੇ", 4);
    freq.put(" ਥਾ", 19);
    freq.put("ਛਡ ", 6);
    freq.put("ਮਕੀ", 3);
    freq.put(" ੫੪", 9);
    freq.put(" ਜ਼ਖ", 3);
    freq.put("ੱਛਦ", 6);
    freq.put("ਥਰ ", 6);
    freq.put("ਛਦ", 8);
    freq.put("ਕੰਮ", 21);
    freq.put("ਨਸ਼ਨ", 4);
    freq.put("ਕੰਬ", 3);
    freq.put("ਆਪ ", 12);
    freq.put("ਫਰਕ", 4);
    freq.put("ੇਡੀ", 5);
    freq.put(" ਥੋ", 18);
    freq.put("ੴ ", 7);
    freq.put("ੌ", 186);
    freq.put("ਘਟ", 11);
    freq.put("ਕੰਡ", 6);
    freq.put("ੱਛੋ", 3);
    freq.put("ਨਸ਼ਿ", 3);
    freq.put("ਨਤੀ", 6);
    freq.put(" ਗੂ", 3);
    freq.put("ਪਵੇ", 5);
    freq.put("ਥੋ ", 3);
    freq.put("ੱਛੇ", 16);
    freq.put("ਦਿਵ", 3);
    freq.put("ਕਰੋ", 36);
    freq.put("ਿਦਲ", 3);
    freq.put("ੇਣੀ", 6);
    freq.put("ਮੈਡ", 8);
    freq.put(" ਐਵ", 10);
    freq.put("ੇਣੇ", 3);
    freq.put("ਯਾਦ", 51);
    freq.put(" ਗੁ", 89);
    freq.put("ਿਦਾ", 13);
    freq.put("ਿਦਿ", 5);
    freq.put("ਟਰਪ", 8);
    freq.put("ਰਡ ", 4);
    freq.put("ਟ੍ਰ", 4);
    freq.put("ਕੰਜ", 4);
    freq.put("ਸਲਾ", 19);
    freq.put("?", 6);
    freq.put("ਟਰਾ", 6);
    freq.put("ੋਕ ", 45);
    freq.put(" ਥੱ", 9);
    freq.put("ਖੀ", 65);
    freq.put("ਖੁ", 55);
    freq.put("ਿਰਦ", 21);
    freq.put("ੰਹ", 16);
    freq.put("ਰਖ", 22);
    freq.put("ਰਗ", 59);
    freq.put("ਰਕ", 107);
    freq.put("ਸੇਆ", 3);
    freq.put("ਗੀਆ", 14);
    freq.put("ਲਮ ", 14);
    freq.put("ਿਰਨ", 3);
    freq.put("ਰਟ", 17);
    freq.put("ਿਰਪ", 8);
    freq.put("ਿਰਫ", 5);
    freq.put(" ਡੈ", 3);
    freq.put("ੂਗ", 5);
    freq.put("ਫ਼ਤਾ", 4);
    freq.put(" ਗੈ", 17);
    freq.put("ਿਰਲ", 5);
    freq.put(" ㅤㅤ", 15);
    freq.put("ਸਤਿ", 25);
    freq.put("ਟਣ ", 8);
    freq.put("ਿਰਾ", 19);
    freq.put("ੀਨ ", 16);
    freq.put("ਖੜ", 24);
    freq.put("ਮਾਂ", 58);
    freq.put("ਫੱਟ", 5);
    freq.put("ਰਲ", 18);
    freq.put("ਗਲੇ", 5);
    freq.put("ਪਕ ", 5);
    freq.put("ਰਸ਼", 8);
    freq.put("ਗਲੀ", 8);
    freq.put("ਮਾਸ", 11);
    freq.put("ਗੀਤ", 4);
    freq.put("ਗਰੀ", 13);
    freq.put("ਾਧਾ", 3);
    freq.put("ਰਹ", 121);
    freq.put("ਰਾ", 570);
    freq.put("ਜਮੀ", 4);
    freq.put("ਾਵੀ", 10);
    freq.put("ਮਾਰ", 67);
    freq.put("ਖੰ", 10);
    freq.put("ਲਾਟ", 3);
    freq.put("ਰਡ", 5);
    freq.put("ਆਉਦ", 14);
    freq.put("ਮਾਪ", 5);
    freq.put("ਰਤ", 91);
    freq.put("ਮਾਨ", 43);
    freq.put("ਰਪ", 29);
    freq.put("ਰਫ", 9);
    freq.put("ਰਨ", 123);
    freq.put("ਸੇਵ", 8);
    freq.put("ਗੀਰ", 3);
    freq.put("ਰਬ", 33);
    freq.put("ਰਭ", 7);
    freq.put("ੂਰ ", 46);
    freq.put("ਗਲਤ", 8);
    freq.put("ਮਾੜ", 19);
    freq.put("ਾਵਨ", 3);
    freq.put("ੁੱਝ", 21);
    freq.put("ਰਜ਼", 4);
    freq.put("ਓਨੇ", 3);
    freq.put("ਰਫ਼", 3);
    freq.put("ਾਵਣ", 7);
    freq.put("ਰੜ", 3);
    freq.put(" ­", 3);
    freq.put("ਾਵਾ", 57);
    freq.put("ੇਈਏ", 3);
    freq.put("ਰੀ", 548);
    freq.put("ਜਮਾ", 7);
    freq.put(" ·", 3);
    freq.put("ਗ਼ਜ਼", 3);
    freq.put("ਗਲਾ", 10);
    freq.put("ਰੋ", 175);
    freq.put("ਰੈ", 13);
    freq.put("ਾਵਲ", 4);
    freq.put("ੰਨ", 128);
    freq.put("ਰੌ", 9);
    freq.put("ਖਟ", 5);
    freq.put("ਸਤੇ", 9);
    freq.put("ਦ ", 229);
    freq.put("ਰੰ", 36);
    freq.put("ਿਰੇ", 7);
    freq.put("ਿਰੀ", 3);
    freq.put("ਿਰੁ", 3);
    freq.put("ਖਦ", 19);
    freq.put("ਸਤੀ", 9);
    freq.put("ਇਲ ", 3);
    freq.put("ਠਰਕ", 3);
    freq.put("ਂਪ ", 4);
    freq.put("ਸਤੋ", 7);
    freq.put("ਰਫ ", 7);
    freq.put("ਖਮ", 12);
    freq.put("ਿਰੋ", 6);
    freq.put("ਖਰ", 37);
    freq.put("ਵੱਡ", 20);
    freq.put("ਖਲ", 5);
    freq.put("ੈਨ ", 7);
    freq.put("ਤੁਰ", 14);
    freq.put("ਬੂਤ", 3);
    freq.put("ਪਰਾ", 6);
    freq.put("ਅਤ ", 7);
    freq.put("ਖਸ", 5);
    freq.put("ਖਹ", 3);
    freq.put(" ਨ ", 16);
    freq.put("ਖ਼", 22);
    freq.put("ਨਸਾ", 19);
    freq.put("ਖਾ", 146);
    freq.put("ਖਿ", 63);
    freq.put("ਵੱਢ", 3);
    freq.put("ਮੈ ", 55);
    freq.put(" ▓▓", 4);
    freq.put("ੈਂ", 191);
    freq.put("▓", 24);
    freq.put("ਡੀਏ", 3);
    freq.put("ੋਸ਼", 21);
    freq.put("ਭੋਰ", 3);
    freq.put("ਤੁਸ", 19);
    freq.put("ੱਠੀ", 9);
    freq.put("ੂਮ ", 3);
    freq.put("ੱਠੇ", 5);
    freq.put("ਹਰ", 104);
    freq.put("ਾੜ", 48);
    freq.put("ਵੋਟ", 3);
    freq.put(" ਐੱ", 11);
    freq.put("ਢ", 48);
    freq.put("ਚਣ ", 5);
    freq.put("ੇਹਰ", 6);
    freq.put("ਮੱਕ", 3);
    freq.put("ਪੜ੍", 7);
    freq.put("ਦਨ ", 4);
    freq.put("ਮੱਝ", 6);
    freq.put("ਟਗ", 3);
    freq.put("ਏਨਾ", 6);
    freq.put("ਂਹ ", 9);
    freq.put("ਫਨ", 5);
    freq.put("ੰਬੀ", 3);
    freq.put("ੋਗੇ", 7);
    freq.put("ਿਣ ", 20);
    freq.put("ੁੱਲ", 80);
    freq.put("ਭੋਜ", 3);
    freq.put("ੋੜਾ", 13);
    freq.put("ਤਰਸ", 7);
    freq.put("ਪੜਦ", 4);
    freq.put(" ਐਕ", 4);
    freq.put("ੰਬਰ", 15);
    freq.put("ੰਬਾ", 3);
    freq.put(" ਜੀ", 107);
    freq.put("ਏਨੀ", 8);
    freq.put("ਛੱ", 48);
    freq.put(" ਐਂ", 7);
    freq.put("ੀਹਦ", 6);
    freq.put("ਛੰ", 3);
    freq.put("ਨਰ ", 5);
    freq.put("ੋਚੋ", 3);
    freq.put("ਜਸਟ", 3);
    freq.put("ਮਿਸ", 6);
    freq.put("ਪੜਿ", 10);
    freq.put("ਸੌ ", 3);
    freq.put("ਓੁ", 3);
    freq.put("ਭਦਾ", 3);
    freq.put("ਪੁਛ", 8);
    freq.put("ੋਗੀ", 11);
    freq.put("ੱਠਾ", 8);
    freq.put("ਲੁ ", 3);
    freq.put("ਵਨੀ", 3);
    freq.put(" ਜੋ", 101);
    freq.put("ਵਾਏ", 5);
    freq.put(" ਐਸ", 9);
    freq.put("ੈਲ", 16);
    freq.put("਼ਮਾ", 3);
    freq.put("ਪੈਂ", 13);
    freq.put("ਰਗ ", 4);
    freq.put("ਹਵ", 12);
    freq.put("ਦਾਤ", 14);
    freq.put("ा", 13);
    freq.put(" ਐਮ", 3);
    freq.put("ਰੇਆ", 3);
    freq.put("ੂਟ", 6);
    freq.put("ਪੀਂ", 3);
    freq.put("ਭਾਵ", 18);
    freq.put("ੈਸ਼", 5);
    freq.put("ਟਕ", 8);
    freq.put("ਧ ", 41);
    freq.put("ਗਿ ", 3);
    freq.put("ਿਫ਼ਤ", 4);
    freq.put("ਛਿਆ", 6);
    freq.put("ਰਿਫ਼", 4);
    freq.put("ਅੜ", 6);
    freq.put("ਓਸ", 10);
    freq.put("ਨੀ ", 255);
    freq.put("ਾਨ ", 148);
    freq.put("ਦੌ ", 7);
    freq.put("ਮਣ ", 4);
    freq.put("ਉਲ", 6);
    freq.put("ਂਵੀ", 3);
    freq.put("ਡੀਅ", 3);
    freq.put("ੜੇ ", 68);
    freq.put("ਸਮ", 115);
    freq.put("ਟਿ", 34);
    freq.put("ਸਟੇ", 6);
    freq.put("ਰਜ਼", 7);
    freq.put("ਹਵਾ", 9);
    freq.put("ਟਵ", 4);
    freq.put("ਜ਼ਲ", 4);
    freq.put("ਟਲ", 3);
    freq.put("ਟਰ", 49);
    freq.put("ਟਮ", 5);
    freq.put("ੇਪ", 10);
    freq.put("ੇਖ ", 50);
    freq.put("ਬੀਆ", 12);
    freq.put("ਓਪ", 3);
    freq.put("ਰਕਸ", 3);
    freq.put("ੌੜ", 14);
    freq.put("ਟਣ", 15);
    freq.put("ਸ਼ਨ ", 19);
    freq.put("ਰਿੰ", 6);
    freq.put("ਝਣ ", 4);
    freq.put("ਣਮ", 3);
    freq.put("ੌਤ", 24);
    freq.put("ੌਣ", 12);
    freq.put("ਟਾ", 68);
    freq.put("ਰਿਆ", 34);
    freq.put("ਰਫ਼ ", 3);
    freq.put("ो", 5);
    freq.put("੍", 257);
    freq.put("ਰਾਲ", 3);
    freq.put("ੱਪ", 33);
    freq.put("ਘੋਲ", 3);
    freq.put("ਟ੍", 4);
    freq.put("ਟੌ", 4);
    freq.put("ਟੋ", 27);
    freq.put(" ਜਹ", 11);
    freq.put("ਸਟਰ", 10);
    freq.put("ਟੈ", 8);
    freq.put("ਸਟਾ", 4);
    freq.put("ਸਟਿ", 4);
    freq.put("ਅਗ", 7);
    freq.put("ਰਿਕ", 3);
    freq.put("ੰਜ਼ਿ", 5);
    freq.put("ਟੁ", 22);
    freq.put("ਟੀ", 74);
    freq.put("ਰਿਮ", 4);
    freq.put("ਦੋਸ", 19);
    freq.put("ਗਈਆ", 5);
    freq.put("ਰਿਭ", 4);
    freq.put("ੌਂ", 13);
    freq.put("ਰਿਫ", 7);
    freq.put("ਅਫ", 5);
    freq.put("ਰੇਗ", 10);
    freq.put("ਕਦ ", 3);
    freq.put("ਅਤ", 44);
    freq.put("ਰਿਤ", 13);
    freq.put("ਅਦ", 29);
    freq.put("ੌਊ", 3);
    freq.put(" ਜਥ", 3);
    freq.put("ਟੱ", 11);
    freq.put(" →", 5);
    freq.put("ਕਾਨ", 16);
    freq.put("ਅਰਮ", 3);
    freq.put("ਰੇਕ", 6);
    freq.put("ਅਹ", 11);
    freq.put("ਅਸ", 91);
    freq.put("ਰਿਸ", 16);
    freq.put("ਰਿਹ", 35);
    freq.put("ਛਿੱ", 4);
    freq.put("ੈਸੇ", 9);
    freq.put("ੌਜ", 13);
    freq.put("ਰਿਵ", 13);
    freq.put("ਅਰ", 24);
    freq.put("ਿਅਕ", 5);
    freq.put("ਜਬਾ", 5);
    freq.put("ੜਕੀ", 8);
    freq.put("ੱਥ ", 18);
    freq.put("ੜਕੂ", 3);
    freq.put("ਕੱਪ", 6);
    freq.put("ਚੈਕ", 3);
    freq.put("ੜਕੇ", 8);
    freq.put("ਕੱਡ", 8);
    freq.put("ਕਾਬ", 8);
    freq.put("ੌਂਕ", 3);
    freq.put("ਕੱਢ", 8);
    freq.put("ਡਦੀ", 3);
    freq.put("ਖਤਾ", 3);
    freq.put("ਾਦੇ", 10);
    freq.put(" ਛੱ", 45);
    freq.put("ਫ਼ ", 6);
    freq.put("ਾਦੀ", 11);
    freq.put("ਨਾਵ", 8);
    freq.put("ਮਹੀ", 4);
    freq.put("ਕੱਲ", 26);
    freq.put("ੱਬਤ", 11);
    freq.put("ਖਤਮ", 4);
    freq.put("ਠ", 172);
    freq.put("ਮੋਢ", 5);
    freq.put("ਲਖ ", 8);
    freq.put("ਮੋਤ", 4);
    freq.put("ਸਣੇ", 7);
    freq.put("ਵੈ ", 13);
    freq.put("ੜਾ", 114);
    freq.put("ੜਿ", 19);
    freq.put("ਮੇਸ਼", 6);
    freq.put("ਮਹੱ", 3);
    freq.put("ੁਸੀ", 23);
    freq.put("▓▓▓", 16);
    freq.put(" ਜਪ", 9);
    freq.put("ੜਦ", 27);
    freq.put("ਕੱਛ", 3);
    freq.put("ਿਧਾ", 10);
    freq.put("ੂੰ", 746);
    freq.put("ਦੋਸ਼", 8);
    freq.put("ੋਟਰ", 3);
    freq.put("ਮੋਸ", 3);
    freq.put("ਮੋਹ", 13);
    freq.put(" ਓ ", 15);
    freq.put("ਖੁੱ", 7);
    freq.put("ੜਪ", 3);
    freq.put("ਗੁੱ", 8);
    freq.put("ਕੱਖ", 3);
    freq.put("ਜੰਮ", 8);
    freq.put("ੂਆ", 4);
    freq.put("ੂਂ", 7);
    freq.put("ਗੁਆ", 4);
    freq.put("ਜਵ", 42);
    freq.put("ਖੁਆ", 4);
    freq.put("ੂਸਰ", 4);
    freq.put("ਨੇਰ", 7);
    freq.put("ੋਟੀ", 16);
    freq.put("ਫ਼ ", 5);
    freq.put("ੇਹਾ", 5);
    freq.put("ਗੁਜ", 4);
    freq.put("ਕੂ ", 3);
    freq.put("є", 4);
    freq.put("ੜੀ", 177);
    freq.put("੧ ", 6);
    freq.put("ੂਜ", 16);
    freq.put("ਨੇਤ", 3);
    freq.put("ੜ੍", 34);
    freq.put("ਸਣਾ", 5);
    freq.put("੪੫", 7);
    freq.put("ਨੇਡ", 6);
    freq.put("ੂਤ", 17);
    freq.put("ੂਥ", 4);
    freq.put("ੂਦ", 3);
    freq.put("ਨਵੇ", 3);
    freq.put("ਨਵੀ", 10);
    freq.put("ਾਦਲ", 23);
    freq.put("ੜਕਦ", 4);
    freq.put("ਾਦਰ", 4);
    freq.put("ਮਹਲ", 9);
    freq.put("ਾਦਾ", 26);
    freq.put("ਵੰਤ", 3);
    freq.put("ਖੁਦ", 11);
    freq.put("ਸ਼ੋਕ", 3);
    freq.put("ਗੁਡ", 3);
    freq.put("ਾਦਸ", 5);
    freq.put("ੇਲੇ", 17);
    freq.put("ਖੁਸ", 14);
    freq.put("ਾਦਤ", 6);
    freq.put("ੂਰ", 106);
    freq.put("ੂਲ", 27);
    freq.put("ਜੰਗ", 11);
    freq.put("ਖੁਰ", 3);
    freq.put("ਆਨ", 16);
    freq.put("ਖੁਸ਼", 8);
    freq.put("ਗੁਲ", 8);
    freq.put("ੁਕਿ", 4);
    freq.put("ਗੁਰ", 106);
    freq.put("ਤੀਆ", 14);
    freq.put("ੁੜੀ", 95);
    freq.put(" ਜਜ", 3);
    freq.put("੍ ", 4);
    freq.put("ੜੀ ", 124);
    freq.put("ੋਤ ", 8);
    freq.put(" ਝਾ", 3);
    freq.put("ਭਰਾ", 5);
    freq.put("ਿਆ ", 314);
    freq.put("→", 5);
    freq.put("ੁਛਿ", 3);
    freq.put("ਮਾਣ", 18);
    freq.put("ੁੜੇ", 13);
    freq.put("ਬਸ ", 22);
    freq.put("ੋਲਾ", 5);
    freq.put("ਰੈਕ", 4);
    freq.put("ਮਨ ", 16);
    freq.put("ਲਜ਼", 4);
    freq.put("ਰੀਂ", 11);
    freq.put("ਉਣੀ", 9);
    freq.put("ਉਣੇ", 5);
    freq.put("ਤੇਰ", 228);
    freq.put("ਧੁੱ", 3);
    freq.put("ਇਤਿ", 5);
    freq.put("ੰਡ ", 27);
    freq.put("ੌਮ", 6);
    freq.put("ੌੜ ", 5);
    freq.put(" ٠·", 4);
    freq.put("ਬੁਹ", 3);
    freq.put("ਮੰਜ਼", 5);
    freq.put("ਤੀਰ", 4);
    freq.put("ਾਮੋ", 4);
    freq.put("ਬੁਰ", 17);
    freq.put("ਬੁਲ", 6);
    freq.put("ਅਜੇ", 5);
    freq.put("ਮਨ", 59);
    freq.put("ਮੰਮ", 8);
    freq.put(" ਝੰ", 10);
    freq.put(" ਝੱ", 5);
    freq.put("ਟੋ ", 11);
    freq.put("ਮੰਤ", 17);
    freq.put("ੋ", 2016);
    freq.put("ਮੰਦ", 12);
    freq.put("्", 7);
    freq.put("ਅਪਣ", 8);
    freq.put("ਬੁੜ", 4);
    freq.put("ੱਚ ", 127);
    freq.put("ਤ੍", 8);
    freq.put("ਚੱਪ", 3);
    freq.put("ਉਣਾ", 23);
    freq.put("ਸ਼ਤੇ", 6);
    freq.put("ਂਵ", 15);
    freq.put("ੇਡਾ", 9);
    freq.put("ੇਕ ", 7);
    freq.put("ਦਨਾ", 9);
    freq.put("ਅਜ", 17);
    freq.put(" ਝੜ", 4);
    freq.put("ਿੱਕ", 14);
    freq.put("ਰੁ ", 13);
    freq.put("ਚੱਕ", 6);
    freq.put("ੋਇਆ", 45);
    freq.put("ਝਿਆ", 3);
    freq.put("ਮੰਜ", 6);
    freq.put("ੈਨੇ", 5);
    freq.put("ਇਰ", 5);
    freq.put(" ਝੁ", 7);
    freq.put(" ਝੂ", 19);
    freq.put("ੌਲ", 10);
    freq.put("ਮੰਗ", 27);
    freq.put("ੂਲ ", 11);
    freq.put("ਬਲਦ", 3);
    freq.put("ਬੁੱ", 35);
    freq.put("ਕਪੂ", 3);
    freq.put(" ਝੋ", 5);
    freq.put("ਾਸ", 107);
    freq.put("ਾਹ", 277);
    freq.put("ਲੇਲ", 5);
    freq.put(" ਟਕ", 3);
    freq.put("ਜਿਆ", 16);
    freq.put("ਲੇਵ", 4);
    freq.put("ੱਟ ", 63);
    freq.put("ਜਿਊ", 7);
    freq.put("ਰਬਾ", 20);
    freq.put("ਾਲ", 578);
    freq.put("ਜਿਉ", 7);
    freq.put(" ਏਂ", 3);
    freq.put("ਾਵ", 166);
    freq.put("ਫਸਦ", 3);
    freq.put("ਾਨ", 368);
    freq.put("ਟੇ", 35);
    freq.put("਼ਿੰ", 18);
    freq.put("ਲੇਣ", 3);
    freq.put("ਾਬ", 137);
    freq.put("ਾਭ", 6);
    freq.put("ਲੇਦ", 3);
    freq.put("ਜਿਕ", 4);
    freq.put("ਾਡ", 139);
    freq.put("ਮ", 2287);
    freq.put("ਾਤ", 108);
    freq.put("ਾਥ", 29);
    freq.put("ਾਦ", 150);
    freq.put("ਾਧ", 15);
    freq.put("ਮਝਦ", 3);
    freq.put("ਫਰ ", 3);
    freq.put("ਾਚ", 4);
    freq.put("ਅਖ", 11);
    freq.put("ਜਿਦ", 7);
    freq.put("ਮਝਣ", 5);
    freq.put(" ਏਨ", 14);
    freq.put("ਜਿਥ", 8);
    freq.put("ਕਸਾ", 3);
    freq.put("ਜਿਨ", 19);
    freq.put(" ਏਥ", 3);
    freq.put("ਹਮ ", 5);
    freq.put("ਾਕ", 89);
    freq.put("ਾਖ", 14);
    freq.put("ਲੇਟ", 4);
    freq.put("ਜਿਲ", 10);
    freq.put("ਜਾਵ", 65);
    freq.put("ਾਊ", 7);
    freq.put("ੱਡਦ", 4);
    freq.put("ੌਸ", 10);
    freq.put(" ਏਸ", 7);
    freq.put("ਜਿਵ", 11);
    freq.put("ਮਝਾ", 4);
    freq.put("ਜਿਸ", 30);
    freq.put("ਜਿਹ", 73);
    freq.put("ਂਉ", 3);
    freq.put("ਾਅ", 34);
    freq.put("ਾਇ", 101);
    freq.put("ਕਉ ", 7);
    freq.put("ਇਕ", 89);
    freq.put("ੂਮ", 5);
    freq.put("ਹੜ ", 3);
    freq.put("ਲੈਕ", 3);
    freq.put("ਮਤਾ", 3);
    freq.put("ਮਝੋ", 5);
    freq.put("਼ਿਲ", 4);
    freq.put("ਇਆ", 121);
    freq.put("ੱਡੇ", 12);
    freq.put("ਅਮ", 33);
    freq.put("ਕਸੂ", 5);
    freq.put("ੱਡੀ", 25);
    freq.put("ਂਵਾ", 5);
    freq.put("ਂਡ ", 9);
    freq.put("ਅਨ", 14);
    freq.put("ਇਸ਼", 6);
    freq.put("ਾਜ਼", 14);
    freq.put("਼ਿਆ", 3);
    freq.put("ਇਲ", 13);
    freq.put("ਜਾਬ", 60);
    freq.put("ਭਾਅ", 3);
    freq.put("ਅਪ", 17);
    freq.put("ਜ਼ਿੰ", 13);
    freq.put("ਾਕ ", 33);
    freq.put("ਇਸ", 70);
    freq.put("ਇਦ", 7);
    freq.put("ਜਿੰ", 66);
    freq.put("ਜਿੱ", 20);
    freq.put("ੜਦਾ", 6);
    freq.put("ਨਹਾ", 6);
    freq.put("਼ਿਕ", 9);
    freq.put("ਇਮ", 13);
    freq.put("ਰਤ ", 33);
    freq.put("ੀਚ", 7);
    freq.put("ਰਦੋ", 3);
    freq.put("्र", 3);
    freq.put("ਰਾਉ", 3);
    freq.put("ਰਾਈ", 7);
    freq.put("ਿੱਛ", 14);
    freq.put("ਿਊਣ", 3);
    freq.put("੭", 6);
    freq.put("ਟਾ ", 24);
    freq.put("ਰਾਂ", 157);
    freq.put("ੈਣਾ", 16);
    freq.put("ੳਣ ", 4);
    freq.put("ਰਾਇ", 3);
    freq.put("ਿਬ ", 27);
    freq.put("ਰਾਜ", 20);
    freq.put("ਦਾਲ", 8);
    freq.put("ੀਜ਼", 7);
    freq.put("ਹੂ ", 5);
    freq.put("ਝੂ", 25);
    freq.put("ੁਰੁ", 5);
    freq.put("ਰਾਕ", 3);
    freq.put("ਦੀਏ", 3);
    freq.put("ਰਾਗ", 7);
    freq.put("ਰਾਖ", 4);
    freq.put(" ς", 6);
    freq.put("ਰਾਨ", 6);
    freq.put("ਲੈਂ", 18);
    freq.put("ਰਾਬ", 14);
    freq.put("ਬ ", 214);
    freq.put(" ↓", 33);
    freq.put("ਰਾਣ", 6);
    freq.put("ੁਰੱ", 6);
    freq.put("ੋਸਤ", 19);
    freq.put("ਰਾਤ", 25);
    freq.put("ਰਾਹ", 32);
    freq.put("ਰਾਸ", 6);
    freq.put("ੋੜੇ", 10);
    freq.put("ੋਸ਼", 7);
    freq.put("ਜਾਣ", 73);
    freq.put("ੰਗ ", 53);
    freq.put("ਮਤੀ", 4);
    freq.put("ਿਊਟ", 3);
    freq.put("ਸ਼ ", 22);
    freq.put("ਰਾਵ", 11);
    freq.put("ਰਾਸ਼", 10);
    freq.put("ਈਟ ", 4);
    freq.put("ਂਸ ", 5);
    freq.put("ਨਮ ", 9);
    freq.put("ੇਖੋ", 15);
    freq.put("ੁਰਖ", 3);
    freq.put(" ਕਾ", 144);
    freq.put("ਰਿਸ਼", 10);
    freq.put("ਗਾ ", 92);
    freq.put("ਉਕਿ", 3);
    freq.put("ਮਗਰ", 3);
    freq.put("ਧੀਆ", 6);
    freq.put("ਮੇ", 261);
    freq.put(" ਕਹ", 127);
    freq.put("ਤਾ", 607);
    freq.put("ਲਣਾ", 5);
    freq.put("ਅਸ਼", 3);
    freq.put("ੁਰਾ", 20);
    freq.put("੫੪", 9);
    freq.put("ੁਰਗ", 4);
    freq.put("ਂਗ", 88);
    freq.put("ੋਸ਼ਿ", 6);
    freq.put("ਨਮ", 18);
    freq.put("ੈਣੀ", 6);
    freq.put("ਮਜ਼", 6);
    freq.put("ਣਦੇ", 3);
    freq.put("ੁਰਬ", 10);
    freq.put("ਮੂਲ", 3);
    freq.put("ਦੇਈ", 4);
    freq.put("ਅਲ", 9);
    freq.put("ੋਹ", 79);
    freq.put("॥੧॥", 9);
    freq.put("ਲ੍ਹ", 12);
    freq.put(" ਵਾ", 285);
    freq.put(" ਵਿ", 282);
    freq.put(" ਵਸ", 8);
    freq.put(" ਵਹ", 6);
    freq.put("ਮੱਖ", 4);
    freq.put("ਤਵੀ", 3);
    freq.put("। ", 51);
    freq.put("ਠੋਕ", 3);
    freq.put(" ਵਰ", 57);
    freq.put("ਜਤ", 10);
    freq.put(" ਵਲ", 11);
    freq.put("ਤਬ", 9);
    freq.put("ੋਖਾ", 7);
    freq.put("ਠੰ", 9);
    freq.put("ਠੱ", 5);
    freq.put("ਟਾਂ", 12);
    freq.put("ਝੰਡ", 10);
    freq.put(" ਵਪ", 8);
    freq.put(" ਵਫ", 3);
    freq.put("ਸੰਤ", 8);
    freq.put("ੁਸ਼ੀ", 6);
    freq.put(" ਵਡ", 5);
    freq.put("ੱਪੂ", 3);
    freq.put(" ਵਜ", 9);
    freq.put("ਨੈਣ", 4);
    freq.put("ਰਲੇ", 3);
    freq.put(" ਵਟ", 4);
    freq.put("ਤ", 2961);
    freq.put("ਦਰੋ", 4);
    freq.put("ਆਫੀ", 3);
    freq.put(" ਵਕ", 10);
    freq.put("ਜਥ", 3);
    freq.put("ਦੂ", 40);
    freq.put("ਰਲੋ", 3);
    freq.put(" । ", 24);
    freq.put("ਮੀਹ", 4);
    freq.put("ਕਲਗ", 3);
    freq.put("ੀਵਨ", 3);
    freq.put("ਫੋਨ", 11);
    freq.put("ਸਕ", 75);
    freq.put("ਕੱਠ", 3);
    freq.put("ੂਠ", 13);
    freq.put(" ਐਨ", 11);
    freq.put("ਘੁ", 7);
    freq.put("ਫਾਈ", 5);
    freq.put("ਵੇਂ", 50);
    freq.put(" ਖੋ", 24);
    freq.put("ੁਸ਼ਕ", 5);
    freq.put("ਲੁੱ", 8);
    freq.put(" ਵੰ", 4);
    freq.put(" ਵੱ", 87);
    freq.put("ਲੇਖ", 7);
    freq.put("ਠਰ", 5);
    freq.put("ੇਟੀ", 8);
    freq.put("ੜੇ", 74);
    freq.put("ਦੇਸ", 19);
    freq.put("ਨ ", 545);
    freq.put("ਰਲਾ", 5);
    freq.put("ਠਾ", 39);
    freq.put("ਲੈਣ", 25);
    freq.put("ਲੀਏ", 12);
    freq.put(" ਵੜ", 5);
    freq.put("ਨੇਂ", 5);
    freq.put("ਦੋ", 136);
    freq.put("ਧਿਰ", 5);
    freq.put("ਹਜ", 9);
    freq.put("ਵੇ ", 137);
    freq.put("ਐ ", 23);
    freq.put("ਦ੍", 3);
    freq.put("ੁਸ਼ਮ", 3);
    freq.put("ਜਤ ", 5);
    freq.put(" ਵੈ", 18);
    freq.put("ਿ", 3528);
    freq.put(" ਵੋ", 7);
    freq.put(" ਵੇ", 77);
    freq.put(" ਵੀ", 320);
    freq.put("ਤੋੜ", 14);
    freq.put("ੈਥੋ", 4);
    freq.put("ਰਾਜ਼", 4);
    freq.put(" ਕੜ", 5);
    freq.put("ਾਗੇ", 9);
    freq.put("ਾਗੀ", 8);
    freq.put("ਾਗੁ", 4);
    freq.put("ਾਗੂ", 4);
    freq.put("ਆਗ", 7);
    freq.put("ੁਤਾ", 4);
    freq.put("ਆਜ", 4);
    freq.put("ਏ", 438);
    freq.put("ਆਟ", 3);
    freq.put(" ਆ ", 188);
    freq.put("ਆਂ", 405);
    freq.put("਼ਤ ", 5);
    freq.put("ਿਠੀ", 3);
    freq.put("ਆਇ", 23);
    freq.put("ਖਵਾ", 14);
    freq.put("ਕੁ ", 13);
    freq.put("ਕੂ", 23);
    freq.put("ਨਵਾ", 15);
    freq.put("ਇਬ", 5);
    freq.put("ਆਏ", 9);
    freq.put("ਆਰ", 167);
    freq.put("ਿਖਣ", 5);
    freq.put("ਆਲ", 20);
    freq.put("ਮਹੁ", 3);
    freq.put("ਿਖਦ", 3);
    freq.put("ਆਵ", 30);
    freq.put(" ਧਰ", 23);
    freq.put("ਨਦਾ", 6);
    freq.put("ਆਸ", 23);
    freq.put(" ਧਿ", 11);
    freq.put("ਲਿਓ", 3);
    freq.put("ਲਿਕ", 3);
    freq.put("ਲਿਖ", 29);
    freq.put("ਪਵਿ", 3);
    freq.put("ਲੈ", 101);
    freq.put("ਆਣ", 22);
    freq.put("ਹਨਾ", 28);
    freq.put("ਫ਼ਿ", 6);
    freq.put("ਆਦ", 32);
    freq.put("ह", 8);
    freq.put("ਾ। ", 3);
    freq.put("਼ੇ ", 7);
    freq.put("ਮੋਟ", 5);
    freq.put("ਿਖਾ", 19);
    freq.put("ਿਖਿ", 9);
    freq.put(" ਧਨ", 12);
    freq.put("ਜ਼ਦ", 3);
    freq.put("ਿਖੀ", 6);
    freq.put("ਬਤ ", 17);
    freq.put("ਪਨ ", 7);
    freq.put("ਿਖੇ", 8);
    freq.put("ਹਨੂ", 28);
    freq.put("ਲਿੱ", 10);
    freq.put("ਹਨੀ", 3);
    freq.put("ੀਸ ", 7);
    freq.put("ਆੜ", 3);
    freq.put("ਹਨੇ", 14);
    freq.put("ਪਰਦ", 3);
    freq.put("ਬੇ ", 26);
    freq.put("ਆਮ", 6);
    freq.put(" ਧੂ", 3);
    freq.put(" ਇਸ", 70);
    freq.put(" ਧੀ", 7);
    freq.put(" ਧੁ", 5);
    freq.put("ਾਗਜ", 4);
    freq.put("ਿੰਦ", 222);
    freq.put("ਪਰਵ", 7);
    freq.put(" ਧੋ", 17);
    freq.put("ਹਿ ", 52);
    freq.put("ਵਤ", 4);
    freq.put(" ਕੌ", 26);
    freq.put("ਓਹ ", 33);
    freq.put("ਦਰਸ", 5);
    freq.put("ਮੋਦ", 4);
    freq.put(" ਧੰ", 11);
    freq.put("ਾਗਮ", 5);
    freq.put("सु", 5);
    freq.put("ਟੀਆ", 10);
    freq.put("ਵਾਕ", 20);
    freq.put("ੳਹ", 3);
    freq.put("ੁਤੇ", 3);
    freq.put("ਾਗਰ", 3);
    freq.put("ਾਗਲ", 3);
    freq.put("ਨਲ ", 3);
    freq.put("ਾਗਾ", 6);
    freq.put("ਾਗਿ", 3);
    freq.put("ਚੇਤ", 11);
    freq.put("ਵਟਾ", 4);
    freq.put("ਅੱਗ", 11);
    freq.put("ਿਲਮ", 9);
    freq.put("ਡ ", 110);
    freq.put("ਹੌਲ", 5);
    freq.put("ਣਾਇ", 4);
    freq.put("ਿਲਦ", 26);
    freq.put("ਰੋਜ਼", 4);
    freq.put(" ਕੋ", 200);
    freq.put("ਿਲਣ", 8);
    freq.put("ਹੌਸ", 4);
    freq.put("ਛੋਂ", 3);
    freq.put("ਿਲਾ", 68);
    freq.put("ਿਲਿ", 8);
    freq.put("ਛੋਟ", 5);
    freq.put("ਊਟ", 4);
    freq.put("ੈਨ", 134);
    freq.put("ਸਦਾ", 31);
    freq.put("ਥੇ ", 51);
    freq.put(" ਇਬ", 3);
    freq.put("ੁੱਸ", 12);
    freq.put("ੁੰਡ", 40);
    freq.put("ੁਆ", 34);
    freq.put("ੜਤ", 8);
    freq.put("ਦਭ", 3);
    freq.put("ਲਆ ", 4);
    freq.put("ੰਕਾ", 3);
    freq.put("ਕੱਚ", 10);
    freq.put(" ਕੂ", 4);
    freq.put("ਵੇਚ", 6);
    freq.put("ਤਰ ", 31);
    freq.put("ੇੜ ", 4);
    freq.put("स", 15);
    freq.put("ੇਸੀ", 8);
    freq.put("ਿਲਕ", 4);
    freq.put("ੂਹਾ", 9);
    freq.put("ਮੀਰ", 9);
    freq.put("ੁਰਮ", 3);
    freq.put("ਪਾਂ", 12);
    freq.put("ਸੋਨ", 5);
    freq.put("ਊਗ", 4);
    freq.put("ਪਾਇ", 11);
    freq.put("ਰੋਗ", 8);
    freq.put("ਰੋਕ", 8);
    freq.put("ਜਨਾ", 6);
    freq.put("ਪਾਉ", 29);
    freq.put("ਪਾਈ", 5);
    freq.put("ਾਫ਼", 6);
    freq.put("ਸੋਧ", 3);
    freq.put("ਰੋਜ", 14);
    freq.put("ਰੋਂ", 14);
    freq.put("ਛੋੜ", 5);
    freq.put("ੇਮ ", 3);
    freq.put("ਜਨਤ", 5);
    freq.put("ਪਾਗ", 3);
    freq.put("ਾਥੋ", 7);
    freq.put("ਏਹ", 5);
    freq.put("ਏਸ", 7);
    freq.put("ਜਨਮ", 12);
    freq.put("ਰੋਈ", 3);
    freq.put("ੂਫ", 3);
    freq.put("ਾਥੀ", 3);
    freq.put("ਦਕ", 6);
    freq.put("ਰੋਲ", 5);
    freq.put("ੂਸ", 10);
    freq.put("ਿਲ੍", 3);
    freq.put("ੋਂ", 307);
    freq.put("ਿਲੋ", 10);
    freq.put("ਗੂੰ", 9);
    freq.put("ਪਾਤ", 7);
    freq.put("ਸੋਂ", 3);
    freq.put("ਸਦੀ", 18);
    freq.put("ਰੋਸ", 5);
    freq.put("ਰੋਹ", 7);
    freq.put("ਏਂ", 5);
    freq.put("ਸਦੇ", 11);
    freq.put("ਫਤ", 17);
    freq.put("ਸੋਚ", 25);
    freq.put("ਰੋਣ", 6);
    freq.put("ਪਾਰ", 18);
    freq.put("ੋਸ਼ੀ", 10);
    freq.put("ਰੋਧ", 6);
    freq.put("ੀਫ", 10);
    freq.put("ਏਗ", 5);
    freq.put("ਠੀਏ", 3);
    freq.put("ਏਕ", 3);
    freq.put("ਬਰ ", 30);
    freq.put("ਰੋਮ", 4);
    freq.put("ਪੜੇ", 8);
    freq.put("¡ ", 5);
    freq.put("਼ਵ", 4);
    freq.put("ਅਧਿ", 8);
    freq.put("ਬਾਨ", 15);
    freq.put("ਕਈ ", 15);
    freq.put("ਬਾਪ", 22);
    freq.put("਼ਾ", 59);
    freq.put("ਗਮੋ", 6);
    freq.put("ਾਹੀ", 38);
    freq.put("ਾਹੁ", 15);
    freq.put("ਾਹੇ", 10);
    freq.put("਼ੋਰ", 3);
    freq.put("ਾੜਾ", 14);
    freq.put("਼ਦ", 3);
    freq.put("਼ਤ", 22);
    freq.put("ਬਾਹ", 15);
    freq.put("ੀਬ", 25);
    freq.put("਼ਨੀ", 4);
    freq.put("ਬਾਵ", 3);
    freq.put("਼ਬ", 9);
    freq.put("ਬਾਰ", 34);
    freq.put("਼ਨ", 18);
    freq.put("ਬਾਲ", 11);
    freq.put("਼ਖ", 6);
    freq.put("ण", 3);
    freq.put("ੁਚ", 3);
    freq.put("ਾੜਕ", 4);
    freq.put("ਬਾਈ", 6);
    freq.put("ਬਾਅ", 21);
    freq.put("਼ਟ", 3);
    freq.put("਼ੋਕ", 3);
    freq.put(" ●", 7);
    freq.put("ਸਾ ", 32);
    freq.put("ਬਾਝ", 3);
    freq.put("ਬਾਜ", 10);
    freq.put("ਂਝ ", 7);
    freq.put("ੰਮ੍", 8);
    freq.put("ੁੱਧ", 11);
    freq.put("ੀਜ ", 5);
    freq.put("ਬਾਕ", 4);
    freq.put("ੰਮੀ", 13);
    freq.put("ਬਾਗ", 4);
    freq.put("ੰਮੇ", 4);
    freq.put("ੇਖਿ", 7);
    freq.put("ਯਕ", 3);
    freq.put("ਸਨੂ", 9);
    freq.put("ਡਨ ", 3);
    freq.put("ਇਨ", 26);
    freq.put("ਸਨੇ", 7);
    freq.put("ੰਮਾ", 3);
    freq.put("ੇਵਫ", 13);
    freq.put("ਯਕੀ", 3);
    freq.put("ਬਲਾ", 12);
    freq.put("ਂਧ", 5);
    freq.put("ਨਾਜ", 3);
    freq.put("ਚਕ", 6);
    freq.put("ਭੁਲ", 19);
    freq.put("ਬੇਕ", 3);
    freq.put("ਢਾ", 7);
    freq.put("ਢਿ", 6);
    freq.put("ਪ ", 68);
    freq.put("ੰਮਤ", 13);
    freq.put("ਾਹਨ", 4);
    freq.put("ੀਹ", 17);
    freq.put("ਾਹਮ", 7);
    freq.put("ੁਧ", 5);
    freq.put("ਖਮ ", 6);
    freq.put("ਾਹਣ", 3);
    freq.put("ੁਦ", 23);
    freq.put("ਾਹਦ", 5);
    freq.put("ਧੜਕ", 9);
    freq.put("ਾਹਤ", 6);
    freq.put("ਦਸ ", 4);
    freq.put("ਾੜੀ", 7);
    freq.put("ਤਰੀ", 31);
    freq.put("ਨਾਂ", 84);
    freq.put("ਾਹਾ", 22);
    freq.put("ਾਹਿ", 84);
    freq.put("ਾੜੇ", 8);
    freq.put("਼ੁ", 7);
    freq.put("ਾਹਲ", 3);
    freq.put("ਲਈ ", 104);
    freq.put("ਾਹਰ", 8);
    freq.put("ੰਘ ", 39);
    freq.put("਼ੋ", 6);
    freq.put("ੁੰਜ", 3);
    freq.put("ਾਹਵ", 3);
    freq.put(" ਹੈ", 219);
    freq.put(" ٠", 4);
    freq.put("ਿਗਾ", 5);
    freq.put("ੀਦਵ", 3);
    freq.put("ਲਓ", 4);
    freq.put("ਆਪਣ", 100);
    freq.put("ਲਝ", 3);
    freq.put("ੰਭ ", 4);
    freq.put("ਲਟ", 7);
    freq.put("ਿਗਰ", 4);
    freq.put("ਲਚ", 3);
    freq.put("ੀਦਾ", 18);
    freq.put(" ਦੁ", 107);
    freq.put(" ਦੀ", 456);
    freq.put("ਲਆ", 4);
    freq.put("ੱਚੋ", 7);
    freq.put("ਆਪਿ", 3);
    freq.put("ਆਪਾ", 21);
    freq.put(" ਦੇ", 530);
    freq.put("ਉੱਤ", 22);
    freq.put("ੱਚੀ", 19);
    freq.put(" ਹੌ", 14);
    freq.put(" ਦੋ", 61);
    freq.put("ਲਏ", 7);
    freq.put(" ਦ੍", 3);
    freq.put(" ਦੌ", 10);
    freq.put("ਾਮ ", 73);
    freq.put(" ਦੱ", 43);
    freq.put(" ਦੰ", 4);
    freq.put("ਣੀ", 171);
    freq.put("ਮੱ", 17);
    freq.put("ਲਰ", 10);
    freq.put("ਝੋਲ", 3);
    freq.put("ਲਲ", 7);
    freq.put("ਲ਼", 4);
    freq.put("ਮੋੜ", 13);
    freq.put("ਲਾ", 471);
    freq.put("ਲਿ", 143);
    freq.put("ਲਸ", 20);
    freq.put("ਲਹ", 10);
    freq.put("ਮੀਨ", 7);
    freq.put("ਲਤ", 23);
    freq.put(" ς੭", 6);
    freq.put("ਲਦ", 84);
    freq.put("ੁਲ", 89);
    freq.put("ੂਚ", 3);
    freq.put("ਲਣ", 22);
    freq.put("ਲਬ", 5);
    freq.put("ਸ", 3015);
    freq.put("ਲਮ", 21);
    freq.put("ਨੰਦ", 5);
    freq.put("ਆਪਕ", 5);
    freq.put("ਲਫ", 6);
    freq.put("ਆਸ਼", 4);
    freq.put("ਲਾਹ", 8);
    freq.put("ਲਾਸ", 10);
    freq.put("ਨੂ", 654);
    freq.put("ਲੜ", 21);
    freq.put("ਲਾਲ", 9);
    freq.put("ਲਾਰ", 7);
    freq.put("ਲਾਸ਼", 6);
    freq.put("ਲਾਵ", 11);
    freq.put("ਉਹਨ", 28);
    freq.put("ਲਾਫ", 12);
    freq.put("ੁਹ", 50);
    freq.put("ਮਨਪ", 4);
    freq.put("ਲਾਨ", 3);
    freq.put("ਲੀ", 240);
    freq.put("ਲਾਮ", 9);
    freq.put("ਲੂ", 6);
    freq.put("ਲਾਬ", 5);
    freq.put("ਲ੍", 20);
    freq.put("ਲਾਡ", 3);
    freq.put("ਆਤਮ", 4);
    freq.put("ਜਹਾ", 7);
    freq.put("ਲਾਤ", 15);
    freq.put("ਆਪੋ", 4);
    freq.put(" ਦਰ", 40);
    freq.put("ਪਥਰ", 4);
    freq.put(" ਦਲ", 6);
    freq.put(" ਦਵ", 7);
    freq.put("ਲੱ", 138);
    freq.put("ੱਚਾ", 22);
    freq.put("ੱਚਿ", 8);
    freq.put(" ਦਹ", 5);
    freq.put(" ਦਸ", 16);
    freq.put("ਜਖਮ", 5);
    freq.put(" ॥ ", 82);
    freq.put("ੀਲੇ", 3);
    freq.put(" ਦਿ", 316);
    freq.put("ਿਹ ", 4);
    freq.put("ੀਦੀ", 12);
    freq.put("ਕਤ ", 12);
    freq.put("ਵਿਰ", 12);
    freq.put("ਆਸ਼", 5);
    freq.put(" ਹੜ", 4);
    freq.put(" ਦਫ", 6);
    freq.put("ਿਗੁ", 58);
    freq.put("ਮਰੇ", 6);
    freq.put(" ਦਮ", 4);
    freq.put("ਕਲ ", 22);
    freq.put("ਜੀ", 154);
    freq.put("ੁੱਬ", 5);
    freq.put("ਤਕ ", 12);
    freq.put("ਗੁਣ", 5);
    freq.put("ਏਨ", 14);
    freq.put("ਿਹਰ", 11);
    freq.put("ਰਕੀ", 3);
    freq.put("ਪੁੰ", 7);
    freq.put("ਮਰੀ", 10);
    freq.put("ਹੱ", 78);
    freq.put("ਾਤੋ", 3);
    freq.put("ੂਪ", 11);
    freq.put("ਦਸੋ", 5);
    freq.put("ਿੲ", 3);
    freq.put("ਾਤੀ", 12);
    freq.put("ਵੰਡ", 4);
    freq.put("ੈਸਿ", 3);
    freq.put("ਵਿਹ", 6);
    freq.put("ਾਤੇ", 4);
    freq.put("ਨੁ", 38);
    freq.put("ਣ", 1141);
    freq.put("ਦੀਦ", 9);
    freq.put("ੁਕਰ", 3);
    freq.put("ਿਡਾ", 4);
    freq.put("ਯਾਰ", 100);
    freq.put("ੈੱ", 3);
    freq.put("ਮਿੰ", 11);
    freq.put("ਮਿੱ", 34);
    freq.put("ਜੋ", 118);
    freq.put("ਪਿਤ", 5);
    freq.put("ੈਰ", 49);
    freq.put("ਾਖਲ", 3);
    freq.put("ੁੰਨ", 10);
    freq.put("ੁੱਡ", 7);
    freq.put(" ਕ ", 5);
    freq.put("ਯਾਤ", 4);
    freq.put("ਨਾਤ", 4);
    freq.put("ਰਤਿ", 7);
    freq.put("ਮਿਟ", 4);
    freq.put("ੁਪ", 19);
    freq.put("ੈਟ", 7);
    freq.put("ਾਖੀ", 3);
    freq.put("ਮਿਕ", 5);
    freq.put("๋", 3);
    freq.put("ੋਹਨ", 10);
    freq.put("ਾਤਕ", 10);
    freq.put("ੈਗ", 8);
    freq.put("ਪੁਰ", 14);
    freq.put("ੈਕ", 19);
    freq.put("ੁੰਗ", 3);
    freq.put("ਾੳਣ", 3);
    freq.put("ਗਰ", 77);
    freq.put("ਨਾਨ", 22);
    freq.put("ਫਰ", 28);
    freq.put("ਅਦਾ", 7);
    freq.put("ਸਥਾ", 4);
    freq.put("ੁਕਮ", 8);
    freq.put("ਪੁਣ", 3);
    freq.put("ਕੀ ", 164);
    freq.put("ਹੌ", 15);
    freq.put("ਚਮ", 3);
    freq.put("ੈਸ", 26);
    freq.put("ੇਲ੍", 4);
    freq.put("॥", 115);
    freq.put("ਮਿਹ", 6);
    freq.put("ਾਤਿ", 4);
    freq.put("ਾਤਾ", 24);
    freq.put("ਖੇਤ", 9);
    freq.put("ਾਤਰ", 10);
    freq.put("ਮਿਸ਼", 4);
    freq.put("ਅੰਮ", 10);
    freq.put("ਖੇਡ", 14);
    freq.put(" ਉਹ", 148);
    freq.put("ੂਹ", 40);
    freq.put("ੈਪ", 8);
    freq.put("ਮ ", 247);
    freq.put("ਰਕਾ", 45);
    freq.put("ਟੀ ", 54);
    freq.put("ੜਕਾ", 7);
    freq.put("ੈਬ", 4);
    freq.put(" ਲੜ", 18);
    freq.put("ਮਿਤ", 7);
    freq.put("ੈਣ", 48);
    freq.put("ੈਠ", 33);
    freq.put("ੈਡ", 12);
    freq.put("ਮਿਠ", 6);
    freq.put("਼ੀ ", 27);
    freq.put(" ਟਾ", 11);
    freq.put("ਇਕਾ", 4);
    freq.put("ਪ", 1632);
    freq.put("ਉਹ ", 82);
    freq.put("ਦਾਖ", 3);
    freq.put("ਭੜਕ", 4);
    freq.put("ੀਹ ", 5);
    freq.put("ਾਪਸ", 5);
    freq.put("ਾਪਿ", 4);
    freq.put("ਾਪਾ", 8);
    freq.put(" ਟਰ", 9);
    freq.put("ਰਧਾ", 12);
    freq.put("ਜ਼ੀ", 6);
    freq.put("ਮਜ", 15);
    freq.put("ਹੇ", 80);
    freq.put("ਾਪਤ", 3);
    freq.put("੍ਹੀ", 6);
    freq.put("ਹਾ ", 106);
    freq.put("ਮਕ", 5);
    freq.put("੍ਹੇ", 10);
    freq.put("ਮਗ", 7);
    freq.put("ਓਸ ", 5);
    freq.put("है", 3);
    freq.put("ਇਦਾ", 4);
    freq.put("त", 14);
    freq.put("ਮਮ", 3);
    freq.put("ੂਲਦ", 3);
    freq.put("ਅੰਬ", 8);
    freq.put("ਵਧੀ", 4);
    freq.put("ਸਹਿ", 19);
    freq.put("ਉਡੀ", 8);
    freq.put("ਮਦ", 19);
    freq.put("ੁੜ", 125);
    freq.put("ਮਸ", 12);
    freq.put("ਮਹ", 43);
    freq.put("ਣਖ ", 4);
    freq.put("ਮਾ", 333);
    freq.put("ਮਿ", 175);
    freq.put("ਮਰ", 107);
    freq.put(" ਲੁ", 16);
    freq.put("ਮਲ", 65);
    freq.put("ੁੱਪ", 8);
    freq.put("ਮਸ਼", 3);
    freq.put(" ਲੀ", 5);
    freq.put("ਮੈ", 269);
    freq.put("ਮੋ", 59);
    freq.put("ਮੌ", 37);
    freq.put("ਮ੍", 10);
    freq.put("ਸ਼ਕ ", 5);
    freq.put("ਮੀ", 88);
    freq.put("ਹ ", 355);
    freq.put("ਮੂ", 30);
    freq.put("ੜਦੇ", 13);
    freq.put("ੁਪਨ", 5);
    freq.put(" ਟੱ", 11);
    freq.put("ੋਟਾ", 6);
    freq.put("ਵਿਛ", 8);
    freq.put("ਤਹਿ", 4);
    freq.put("ਉਡਾ", 4);
    freq.put("ਵਧਾ", 11);
    freq.put("ਵਿਚ", 75);
    freq.put("ਨੋਂ", 3);
    freq.put("ਚਰ ", 5);
    freq.put("ਇਦ ", 3);
    freq.put("ਾਅ ", 10);
    freq.put("ਉਏ ", 3);
    freq.put("ਲੰਡ", 4);
    freq.put("ਜ਼ਰ", 6);
    freq.put("।", 70);
    freq.put("੍ਹਿ", 3);
    freq.put("੍ਹਾ", 29);
    freq.put("ਪਟਾ", 3);
    freq.put("ਜ਼ਹ", 3);
    freq.put("ੱਟ", 139);
    freq.put("ਜ਼ਿ", 23);
    freq.put("ਜ਼ਾ", 23);
    freq.put("ਾਪੂ", 18);
    freq.put("ਾਪੁ", 3);
    freq.put("ਨਈ ", 15);
    freq.put("ਾਪੇ", 3);
    freq.put(" ਟੋ", 11);
    freq.put(" ਟੈ", 7);
    freq.put("ਮੰ", 95);
    freq.put(" ਟੇ", 6);
    freq.put("ਜ਼ਮ", 11);
    freq.put(" ਟੀ", 11);
    freq.put(" ਟੁ", 22);
    freq.put("ਨਹੀ", 235);
    freq.put("ਝਾ", 17);
    freq.put("ੁਂ", 7);
    freq.put("ਣਾਂ", 19);
    freq.put("ਪਟਿ", 6);
    freq.put("ਰਮਾ", 12);
    freq.put("ਅਖੀ", 3);
    freq.put("ੱਝ ", 23);
    freq.put("ਕੜ ", 10);
    freq.put("ਧਰੀ", 6);
    freq.put("ਣਾਈ", 6);
    freq.put("ਣਾਉ", 7);
    freq.put("ਅਕ", 35);
    freq.put("ਦੀਰ", 10);
    freq.put("ੁਕ", 46);
    freq.put("ਯਾ ", 14);
    freq.put("ਪੈਸ", 9);
    freq.put("ਜ਼ਲ ", 3);
    freq.put("ੰਗ", 177);
    freq.put("ਾਸਟ", 5);
    freq.put(" ਤ ", 3);
    freq.put("ੁਝ", 60);
    freq.put("▓▓ ", 4);
    freq.put("ੁਟ", 24);
    freq.put("ੁਡ", 10);
    freq.put("ਾਸਤ", 4);
    freq.put("ੀਫ ", 6);
    freq.put("ਂ ", 2092);
    freq.put("ੁਤ", 71);
    freq.put("ਕਸ਼ਾ", 7);
    freq.put("ਉਝ ", 4);
    freq.put("ੁਨ", 62);
    freq.put("ੱਧਵ", 3);
    freq.put("ਹਮ", 41);
    freq.put("ੁਭ", 3);
    freq.put("ੁਬ", 11);
    freq.put("ੱਧਰ", 4);
    freq.put("ਨਖ", 5);
    freq.put("ੁਰ", 196);
    freq.put("ਐਸ", 9);
    freq.put("ਚਾ ", 34);
    freq.put("ੁਵ", 3);
    freq.put("ਨੀਵ", 8);
    freq.put("ਹਬ ", 4);
    freq.put("ੁਸ਼", 25);
    freq.put("ਹ", 3348);
    freq.put("ਾਸ਼", 17);
    freq.put("ਾਸਿ", 9);
    freq.put("ਾਸਾ", 4);
    freq.put("ਜਜ", 3);
    freq.put("ੋਈਆ", 6);
    freq.put("ਿਜ ", 3);
    freq.put("ਾਸੇ", 8);
    freq.put("ਾਸੀ", 14);
    freq.put("ਾਸੂ", 3);
    freq.put("ਂਚ ", 4);
    freq.put("ਛਾਂ", 5);
    freq.put("॥ ", 96);
    freq.put("ਨਿ", 127);
    freq.put("ਂਬਰ", 3);
    freq.put("ੁਦਾ", 5);
    freq.put("ਸ਼ੀਆ", 7);
    freq.put("ਪਣੇ", 47);
    freq.put("ਰਮੀ", 10);
    freq.put("ਜਹੜ", 3);
    freq.put("ਨੀਏ", 5);
    freq.put("ੁਜ਼", 3);
    freq.put("ੱਧੂ", 7);
    freq.put("ਗਾਈ", 4);
    freq.put("ਧਰਮ", 6);
    freq.put("ਛਾਪ", 3);
    freq.put("ਲੰਗ", 8);
    freq.put("ਹਸ", 10);
    freq.put("ਗੜ ", 3);
    freq.put("ਉਹ", 149);
    freq.put("ਛਾਣ", 4);
    freq.put("ੁੱ", 365);
    freq.put("ਰਮੈ", 3);
    freq.put("ਪਣੀ", 31);
    freq.put("ਿਲੇ", 17);
    freq.put("ਅਖਾ", 3);
    freq.put("ਲੰਘ", 12);
    freq.put(" ਹਜ", 8);
    freq.put("ਜ਼ਿਲ", 8);
    freq.put("ਿਸਦ", 4);
    freq.put("ੜਦੀ", 8);
  }
  
}

