package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class PL {
  private static final String name = "pl";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public PL() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 259048;
    n_words[1] = 310832;
    n_words[2] = 251827;

    freq.put("JN ", 4);
    freq.put("dną", 12);
    freq.put("SP ", 3);
    freq.put("dnę", 4);
    freq.put("ątr", 5);
    freq.put("ątp", 6);
    freq.put("NO ", 4);
    freq.put("ąta", 6);
    freq.put("ąte", 18);
    freq.put("ątk", 27);
    freq.put(" y ", 4);
    freq.put("czł", 16);
    freq.put("Ł", 29);
    freq.put("hoć", 8);
    freq.put("lmu", 9);
    freq.put("MB ", 3);
    freq.put("czę", 112);
    freq.put("oO ", 3);
    freq.put(" yo", 7);
    freq.put("k", 8089);
    freq.put(" ye", 8);
    freq.put("czą", 62);
    freq.put("ED ", 4);
    freq.put("czó", 5);
    freq.put("jm ", 4);
    freq.put("dne", 48);
    freq.put("dna", 49);
    freq.put("dno", 42);
    freq.put("dni", 252);
    freq.put("dny", 26);
    freq.put("jmy", 13);
    freq.put("aną", 11);
    freq.put("jmu", 16);
    freq.put("jmi", 5);
    freq.put("jmn", 25);
    freq.put("jmo", 6);
    freq.put("ajg", 6);
    freq.put("Le", 65);
    freq.put("La", 31);
    freq.put("Lo", 30);
    freq.put("czw", 10);
    freq.put("czt", 8);
    freq.put("Li", 49);
    freq.put("czk", 63);
    freq.put("Lu", 39);
    freq.put("czn", 219);
    freq.put("czo", 91);
    freq.put("czm", 3);
    freq.put("czc", 10);
    freq.put("cza", 272);
    freq.put("cze", 532);
    freq.put("hod", 133);
    freq.put("hoc", 27);
    freq.put("hon", 13);
    freq.put("hoo", 7);
    freq.put("hol", 22);
    freq.put("hom", 9);
    freq.put("hoj", 3);
    freq.put("hoh", 7);
    freq.put("hoi", 3);
    freq.put("how", 39);
    freq.put("hot", 23);
    freq.put("hou", 5);
    freq.put("hor", 22);
    freq.put("hop", 4);
    freq.put("A", 481);
    freq.put("L ", 35);
    freq.put("cz ", 108);
    freq.put("ho ", 17);
    freq.put("zam", 137);
    freq.put("łby", 31);
    freq.put("łbr", 4);
    freq.put("fir", 12);
    freq.put("His", 8);
    freq.put("ró", 228);
    freq.put("fiz", 10);
    freq.put("zai", 16);
    freq.put("fic", 22);
    freq.put("fia", 10);
    freq.put("fig", 3);
    freq.put("fie", 10);
    freq.put("fik", 16);
    freq.put("fii", 3);
    freq.put("fin", 12);
    freq.put("fio", 3);
    freq.put("fil", 56);
    freq.put(" Va", 6);
    freq.put(" Ve", 7);
    freq.put("au ", 3);
    freq.put(" Vi", 7);
    freq.put(" Vo", 6);
    freq.put("zaa", 3);
    freq.put("fi ", 11);
    freq.put("ató", 9);
    freq.put("Ż ", 7);
    freq.put("dsB", 6);
    freq.put("zat", 29);
    freq.put("rt", 256);
    freq.put("ru", 266);
    freq.put("rv", 4);
    freq.put("rw", 269);
    freq.put("dsz", 12);
    freq.put("rr", 66);
    freq.put("rs", 208);
    freq.put("smu", 6);
    freq.put("dsu", 6);
    freq.put("sms", 10);
    freq.put("ry", 444);
    freq.put("rz", 1875);
    freq.put("rd", 297);
    freq.put("re", 699);
    freq.put("rf", 9);
    freq.put("rg", 61);
    freq.put("ra", 2008);
    freq.put("rb", 38);
    freq.put("rc", 146);
    freq.put("rl", 29);
    freq.put("rm", 134);
    freq.put("rn", 193);
    freq.put("ro", 1561);
    freq.put("ri", 201);
    freq.put("sma", 16);
    freq.put("rk", 135);
    freq.put("IM ", 5);
    freq.put("Ży", 11);
    freq.put("Ża", 4);
    freq.put("Że", 6);
    freq.put("atf", 9);
    freq.put("ate", 72);
    freq.put("atc", 13);
    freq.put("ata", 107);
    freq.put("atn", 55);
    freq.put("ato", 73);
    freq.put("atm", 15);
    freq.put("atk", 71);
    freq.put("ati", 17);
    freq.put("atw", 18);
    freq.put("att", 9);
    freq.put("atu", 65);
    freq.put("r ", 393);
    freq.put("kty", 37);
    freq.put("ds ", 10);
    freq.put("aty", 55);
    freq.put("Swo", 3);
    freq.put("Dur", 3);
    freq.put("Cen", 9);
    freq.put("Cel", 4);
    freq.put("Ces", 3);
    freq.put("fię", 5);
    freq.put(" fr", 26);
    freq.put("fią", 6);
    freq.put("kni", 30);
    freq.put("nza", 3);
    freq.put("bne", 12);
    freq.put("rł", 14);
    freq.put("dsł", 4);
    freq.put("atę", 8);
    freq.put("ść ", 167);
    freq.put("rż", 3);
    freq.put("eńs", 15);
    freq.put("atł", 5);
    freq.put("kny", 7);
    freq.put("rę", 85);
    freq.put("rą", 51);
    freq.put("rć", 3);
    freq.put("noż", 8);
    freq.put("eń ", 83);
    freq.put("neg", 100);
    freq.put("zto", 7);
    freq.put("użą", 3);
    freq.put("zte", 8);
    freq.put("zta", 22);
    freq.put("zty", 6);
    freq.put("ztu", 16);
    freq.put("wtó", 8);
    freq.put("yfi", 8);
    freq.put("yfr", 5);
    freq.put("X", 140);
    freq.put("ner", 43);
    freq.put("zt ", 5);
    freq.put("Rib", 4);
    freq.put("abó", 10);
    freq.put("uć", 8);
    freq.put("iry", 10);
    freq.put("irs", 3);
    freq.put("irt", 8);
    freq.put("iri", 3);
    freq.put("irl", 6);
    freq.put("irm", 17);
    freq.put("iro", 10);
    freq.put("ira", 11);
    freq.put("łęd", 7);
    freq.put("łęb", 4);
    freq.put("ire", 12);
    freq.put("płu", 4);
    freq.put("pły", 31);
    freq.put("pła", 42);
    freq.put("wte", 23);
    freq.put("wtf", 4);
    freq.put("pło", 7);
    freq.put("wto", 5);
    freq.put("ir ", 8);
    freq.put("łę ", 13);
    freq.put("and", 98);
    freq.put("fra", 17);
    freq.put("fre", 5);
    freq.put("fri", 3);
    freq.put("fro", 7);
    freq.put("fry", 4);
    freq.put("mez", 6);
    freq.put("ann", 18);
    freq.put("ztą", 5);
    freq.put("anu", 20);
    freq.put("tzw", 3);
    freq.put("cił", 39);
    freq.put("Wy ", 5);
    freq.put("ałb", 22);
    freq.put("bim", 6);
    freq.put("żku", 4);
    freq.put("jk ", 7);
    freq.put("tzn", 7);
    freq.put(" źl", 18);
    freq.put("Naw", 6);
    freq.put("Oh", 3);
    freq.put("dha", 3);
    freq.put("bie", 342);
    freq.put("jku", 4);
    freq.put("śmy", 60);
    freq.put("bic", 36);
    freq.put("ić ", 192);
    freq.put("wcu", 5);
    freq.put("bia", 51);
    freq.put("jka", 11);
    freq.put("śmi", 51);
    freq.put("LO ", 3);
    freq.put("gół", 4);
    freq.put("yły", 20);
    freq.put("ęsi", 4);
    freq.put("azę", 3);
    freq.put("yło", 106);
    freq.put("yła", 108);
    freq.put("yłb", 3);
    freq.put("yłe", 20);
    freq.put("hah", 399);
    freq.put("bny", 4);
    freq.put("soł", 3);
    freq.put("hal", 17);
    freq.put("ham", 65);
    freq.put("umó", 4);
    freq.put("haa", 15);
    freq.put("hac", 15);
    freq.put("bni", 12);
    freq.put("bno", 12);
    freq.put("har", 24);
    freq.put("has", 14);
    freq.put("hat", 12);
    freq.put("hav", 3);
    freq.put("haw", 5);
    freq.put("azł", 13);
    freq.put("ył ", 72);
    freq.put("ha ", 179);
    freq.put("ola", 85);
    freq.put("old", 6);
    freq.put("ole", 215);
    freq.put("olf", 7);
    freq.put("oli", 125);
    freq.put(" X ", 10);
    freq.put("oll", 36);
    freq.put("oln", 51);
    freq.put("olo", 65);
    freq.put("ols", 152);
    freq.put("olu", 24);
    freq.put("olv", 4);
    freq.put("olw", 14);
    freq.put("an ", 87);
    freq.put("umu", 8);
    freq.put("ump", 12);
    freq.put("for", 70);
    freq.put("Idę", 12);
    freq.put("umy", 9);
    freq.put("ume", 18);
    freq.put("uma", 30);
    freq.put("umb", 6);
    freq.put("fol", 19);
    freq.put("fon", 38);
    freq.put("umn", 8);
    freq.put("umi", 94);
    freq.put("upę", 3);
    freq.put("Się", 3);
    freq.put("o", 18793);
    freq.put("fo ", 11);
    freq.put("um ", 43);
    freq.put("Wyb", 13);
    freq.put("mbl", 3);
    freq.put("soc", 8);
    freq.put("sob", 162);
    freq.put("mbi", 5);
    freq.put("mbe", 6);
    freq.put("sok", 12);
    freq.put("som", 3);
    freq.put("sol", 12);
    freq.put("son", 26);
    freq.put("Ust", 5);
    freq.put("Fer", 4);
    freq.put("Fes", 13);
    freq.put("sow", 50);
    freq.put("b ", 105);
    freq.put("az ", 238);
    freq.put("so ", 6);
    freq.put("hać", 28);
    freq.put("azi", 38);
    freq.put("azj", 24);
    freq.put("azk", 5);
    freq.put("azm", 3);
    freq.put("azn", 16);
    freq.put("azo", 9);
    freq.put("aza", 41);
    freq.put("azd", 51);
    freq.put("aze", 62);
    freq.put("azg", 3);
    freq.put("azy", 30);
    freq.put("azz", 3);
    freq.put("azu", 36);
    freq.put("azw", 23);
    freq.put("Sie", 10);
    freq.put("Sik", 3);
    freq.put("Dwi", 3);
    freq.put("Sio", 3);
    freq.put("Sim", 5);
    freq.put("Sil", 3);
    freq.put("E", 143);
    freq.put("olą", 8);
    freq.put("olę", 13);
    freq.put("osy", 26);
    freq.put("łko", 8);
    freq.put("osp", 17);
    freq.put("żż", 3);
    freq.put("osu", 14);
    freq.put("ost", 256);
    freq.put("osi", 51);
    freq.put("osh", 6);
    freq.put("Byl", 3);
    freq.put("osj", 9);
    freq.put("osm", 7);
    freq.put("oso", 53);
    freq.put("osn", 18);
    freq.put("osa", 6);
    freq.put("osc", 26);
    freq.put("ose", 48);
    freq.put("osf", 3);
    freq.put("ver", 23);
    freq.put("pem", 3);
    freq.put("ełm", 3);
    freq.put("ełn", 32);
    freq.put("eło", 6);
    freq.put("ełk", 6);
    freq.put("Ta ", 8);
    freq.put("ven", 7);
    freq.put("hód", 5);
    freq.put("ępu", 9);
    freq.put("hów", 3);
    freq.put("Mó", 11);
    freq.put("os ", 50);
    freq.put("ępn", 26);
    freq.put("Tat", 4);
    freq.put("eł ", 9);
    freq.put("Tar", 10);
    freq.put("RY ", 3);
    freq.put("żę", 6);
    freq.put("żą", 15);
    freq.put("Taa", 3);
    freq.put("ve ", 40);
    freq.put("Tam", 3);
    freq.put("Tan", 4);
    freq.put("Taj", 3);
    freq.put("Tak", 44);
    freq.put("sę", 9);
    freq.put("M ", 47);
    freq.put("osó", 32);
    freq.put("yd ", 4);
    freq.put("są", 95);
    freq.put("zrz", 6);
    freq.put("zry", 6);
    freq.put("zre", 9);
    freq.put("zro", 86);
    freq.put("Me", 45);
    freq.put("ydo", 24);
    freq.put("Ma", 195);
    freq.put("ydk", 4);
    freq.put("Mc", 3);
    freq.put("śpi", 25);
    freq.put("Mo", 77);
    freq.put("yde", 10);
    freq.put("Mi", 103);
    freq.put("yda", 53);
    freq.put("Mu", 27);
    freq.put("ydz", 28);
    freq.put("bły", 4);
    freq.put("Mr", 7);
    freq.put("sł", 267);
    freq.put("ydu", 4);
    freq.put("My", 10);
    freq.put("bt", 6);
    freq.put("ipc", 7);
    freq.put("ipa", 7);
    freq.put("żr", 3);
    freq.put("żs", 11);
    freq.put("ipe", 3);
    freq.put("iph", 4);
    freq.put("ipo", 3);
    freq.put("ży", 209);
    freq.put("ips", 4);
    freq.put("żd", 45);
    freq.put("czy", 696);
    freq.put("żb", 7);
    freq.put("żc", 8);
    freq.put("ipt", 6);
    freq.put("ża", 114);
    freq.put("żn", 111);
    freq.put("żo", 69);
    freq.put("żl", 13);
    freq.put("żk", 44);
    freq.put("osł", 32);
    freq.put("Był", 16);
    freq.put("ip ", 9);
    freq.put("Lio", 4);
    freq.put("ż ", 553);
    freq.put("czu", 77);
    freq.put("só", 62);
    freq.put("DO ", 4);
    freq.put("żó", 5);
    freq.put("TF ", 7);
    freq.put("gza", 5);
    freq.put("ąpi", 5);
    freq.put("ST ", 8);
    freq.put("oeJ", 3);
    freq.put("błą", 4);
    freq.put("błę", 7);
    freq.put("s ", 567);
    freq.put("Mę", 3);
    freq.put("zrę", 5);
    freq.put("sB", 6);
    freq.put("sz", 2275);
    freq.put("sy", 186);
    freq.put("Mł", 6);
    freq.put("ss", 38);
    freq.put("sr", 17);
    freq.put("sq", 3);
    freq.put("sp", 491);
    freq.put("sw", 106);
    freq.put("dyn", 45);
    freq.put("su", 194);
    freq.put("st", 2113);
    freq.put("sk", 711);
    freq.put("sj", 52);
    freq.put("si", 1576);
    freq.put("sh", 33);
    freq.put("so", 301);
    freq.put("sn", 109);
    freq.put("sm", 70);
    freq.put("sl", 63);
    freq.put("sc", 215);
    freq.put("sb", 13);
    freq.put("sa", 427);
    freq.put("sf", 14);
    freq.put("se", 324);
    freq.put("rzą", 50);
    freq.put("KA ", 15);
    freq.put("ttp", 6);
    freq.put("iąt", 26);
    freq.put("sse", 3);
    freq.put("tti", 3);
    freq.put("tto", 3);
    freq.put("tta", 4);
    freq.put("iąd", 5);
    freq.put("tte", 44);
    freq.put(" żr", 3);
    freq.put("łów", 38);
    freq.put(" ży", 86);
    freq.put(" że", 563);
    freq.put("dje", 9);
    freq.put(" ża", 38);
    freq.put("nsa", 5);
    freq.put("łód", 4);
    freq.put("sBi", 6);
    freq.put("ois", 6);
    freq.put("Świ", 15);
    freq.put("ukę", 3);
    freq.put("ią ", 89);
    freq.put("tt ", 17);
    freq.put("ji ", 164);
    freq.put(" Zł", 5);
    freq.put("dj ", 3);
    freq.put("onę", 12);
    freq.put("łną", 3);
    freq.put("zoł", 3);
    freq.put("zoś", 12);
    freq.put(" żó", 4);
    freq.put("móz", 9);
    freq.put("blu", 8);
    freq.put("sał", 39);
    freq.put("blr", 3);
    freq.put("blo", 44);
    freq.put("bli", 69);
    freq.put("mój", 36);
    freq.put("hce", 98);
    freq.put("ble", 40);
    freq.put("hci", 66);
    freq.put("bla", 7);
    freq.put("Jon", 9);
    freq.put("iS ", 16);
    freq.put(" gó", 10);
    freq.put("sać", 28);
    freq.put("mkn", 10);
    freq.put("onk", 33);
    freq.put("oni", 139);
    freq.put("onn", 8);
    freq.put("iąż", 37);
    freq.put("onl", 5);
    freq.put("onc", 53);
    freq.put("ona", 175);
    freq.put("onf", 13);
    freq.put(" Z ", 23);
    freq.put("ond", 28);
    freq.put("one", 114);
    freq.put("łni", 19);
    freq.put("ony", 99);
    freq.put("łno", 9);
    freq.put("ons", 21);
    freq.put("łna", 3);
    freq.put("łne", 3);
    freq.put("onu", 22);
    freq.put("łóż", 13);
    freq.put("rz ", 55);
    freq.put("uku", 7);
    freq.put("ukt", 11);
    freq.put("uks", 3);
    freq.put("ukr", 6);
    freq.put("uko", 8);
    freq.put("uki", 19);
    freq.put("iął", 3);
    freq.put("ukc", 14);
    freq.put("uka", 47);
    freq.put("fma", 4);
    freq.put(" Zm", 3);
    freq.put(" Zl", 5);
    freq.put("ęka", 6);
    freq.put(" Zn", 17);
    freq.put(" Zi", 13);
    freq.put("dję", 53);
    freq.put(" Zd", 20);
    freq.put(" Zg", 7);
    freq.put("ęko", 6);
    freq.put("ękn", 26);
    freq.put(" Zb", 3);
    freq.put("ęks", 28);
    freq.put(" żą", 3);
    freq.put("ęku", 29);
    freq.put(" Zw", 7);
    freq.put(" Zr", 9);
    freq.put("rze", 998);
    freq.put("rzc", 3);
    freq.put("rza", 84);
    freq.put("rzo", 23);
    freq.put("rzn", 5);
    freq.put("rzm", 12);
    freq.put("rzw", 5);
    freq.put("rzu", 47);
    freq.put("Hm ", 5);
    freq.put("rzy", 550);
    freq.put("uk ", 10);
    freq.put("sak", 15);
    freq.put("sai", 5);
    freq.put("óci", 34);
    freq.put("óch", 13);
    freq.put("sam", 142);
    freq.put("sal", 26);
    freq.put("sac", 22);
    freq.put("sad", 24);
    freq.put("ócz", 6);
    freq.put("sas", 5);
    freq.put("sar", 4);
    freq.put("sat", 5);
    freq.put("zob", 42);
    freq.put("zod", 4);
    freq.put("zok", 9);
    freq.put("zon", 80);
    freq.put("Ech", 3);
    freq.put("zor", 68);
    freq.put("zos", 52);
    freq.put("zow", 38);
    freq.put("sa ", 73);
    freq.put("óc ", 5);
    freq.put("hcą", 15);
    freq.put("zo ", 76);
    freq.put("ood", 16);
    freq.put("rzó", 7);
    freq.put("Skr", 5);
    freq.put("Sky", 3);
    freq.put("Ska", 3);
    freq.put("zpł", 4);
    freq.put("XI ", 3);
    freq.put("uu", 60);
    freq.put(" bó", 6);
    freq.put("Krz", 4);
    freq.put("up", 212);
    freq.put("Kry", 3);
    freq.put("us", 411);
    freq.put("ur", 428);
    freq.put("cis", 20);
    freq.put(" b ", 7);
    freq.put("żby", 5);
    freq.put("ui", 9);
    freq.put("Awa", 4);
    freq.put("uk", 137);
    freq.put(" be", 155);
    freq.put(" bd", 23);
    freq.put(" ba", 178);
    freq.put(" bl", 58);
    freq.put(" bo", 292);
    freq.put(" bi", 90);
    freq.put(" bu", 75);
    freq.put(" bt", 6);
    freq.put("s", 10357);
    freq.put("jąć", 3);
    freq.put(" br", 105);
    freq.put(" by", 445);
    freq.put("MY ", 11);
    freq.put("zpr", 3);
    freq.put("zpi", 19);
    freq.put("zpo", 26);
    freq.put("zpa", 21);
    freq.put("śro", 18);
    freq.put("yzw", 9);
    freq.put("yzy", 5);
    freq.put("śre", 11);
    freq.put("yza", 7);
    freq.put("yzi", 3);
    freq.put("yzj", 6);
    freq.put("yzm", 4);
    freq.put("yzn", 18);
    freq.put("yzo", 4);
    freq.put("Ską", 3);
    freq.put("ive", 23);
    freq.put("jąt", 8);
    freq.put("jąc", 90);
    freq.put("PW ", 3);
    freq.put(" bę", 211);
    freq.put(" bł", 15);
    freq.put("I", 217);
    freq.put("wpu", 6);
    freq.put("wpr", 7);
    freq.put("ją ", 240);
    freq.put("Mar", 36);
    freq.put("wpi", 14);
    freq.put("śró", 7);
    freq.put("wpa", 7);
    freq.put("Owc", 3);
    freq.put("erk", 28);
    freq.put("ort", 48);
    freq.put("gdy", 75);
    freq.put("gdz", 51);
    freq.put("gda", 5);
    freq.put("heł", 3);
    freq.put("Mac", 14);
    freq.put("My ", 4);
    freq.put("wśr", 5);
    freq.put("Mak", 5);
    freq.put("NA ", 19);
    freq.put("Maj", 12);
    freq.put("jci", 32);
    freq.put("BO ", 3);
    freq.put("Man", 6);
    freq.put("ezy", 19);
    freq.put("ezu", 10);
    freq.put("ezw", 11);
    freq.put("ezp", 18);
    freq.put("ezr", 10);
    freq.put("ezs", 6);
    freq.put("ezm", 5);
    freq.put("ezn", 8);
    freq.put("tvn", 4);
    freq.put("ezi", 13);
    freq.put("ezj", 3);
    freq.put("ezk", 6);
    freq.put("ezd", 10);
    freq.put("eze", 48);
    freq.put("aź", 25);
    freq.put("eza", 14);
    freq.put("ezb", 4);
    freq.put("ezc", 9);
    freq.put("ddz", 5);
    freq.put("ał", 1226);
    freq.put("ań", 70);
    freq.put("jgo", 4);
    freq.put("ńc", 116);
    freq.put("aś", 211);
    freq.put("ńs", 96);
    freq.put("ddd", 3);
    freq.put("ez ", 170);
    freq.put("tv ", 8);
    freq.put("aca", 29);
    freq.put("ać", 478);
    freq.put("ack", 20);
    freq.put("acj", 209);
    freq.put("aci", 87);
    freq.put("ach", 255);
    freq.put("AĆ ", 5);
    freq.put("ń ", 111);
    freq.put("acp", 3);
    freq.put("acu", 18);
    freq.put("act", 8);
    freq.put("acz", 301);
    freq.put("acy", 59);
    freq.put("dd ", 3);
    freq.put("Ni", 242);
    freq.put("No", 146);
    freq.put("Na", 150);
    freq.put("Dni", 6);
    freq.put("Ne", 22);
    freq.put("Nu", 7);
    freq.put("het", 8);
    freq.put("her", 18);
    freq.put("hes", 6);
    freq.put("hed", 3);
    freq.put("hel", 9);
    freq.put("hem", 25);
    freq.put("hen", 3);
    freq.put("heh", 7);
    freq.put("hej", 4);
    freq.put("N ", 42);
    freq.put("agi", 25);
    freq.put("he ", 38);
    freq.put("Hof", 4);
    freq.put("ac", 1157);
    freq.put("ab", 224);
    freq.put("ae", 8);
    freq.put("ad", 875);
    freq.put("ag", 193);
    freq.put("af", 82);
    freq.put("ai", 63);
    freq.put("ah", 461);
    freq.put("ak", 1741);
    freq.put("aj", 951);
    freq.put("am", 2072);
    freq.put("al", 1440);
    freq.put("ao", 11);
    freq.put("an", 1479);
    freq.put("ap", 376);
    freq.put("as", 984);
    freq.put("ar", 1197);
    freq.put("au", 111);
    freq.put("at", 802);
    freq.put("aw", 881);
    freq.put("av", 22);
    freq.put("ay", 59);
    freq.put("ax", 11);
    freq.put("acę", 4);
    freq.put("az", 606);
    freq.put("ezł", 10);
    freq.put("a ", 7115);
    freq.put("oh ", 4);
    freq.put("rp", 49);
    freq.put("smy", 8);
    freq.put("cpe", 3);
    freq.put("dst", 32);
    freq.put("Fir", 10);
    freq.put("mny", 8);
    freq.put("sco", 5);
    freq.put("sci", 37);
    freq.put("sch", 26);
    freq.put("ęć ", 29);
    freq.put("sce", 47);
    freq.put("sca", 17);
    freq.put(" śc", 16);
    freq.put("Śmi", 5);
    freq.put("scy", 48);
    freq.put("Fig", 3);
    freq.put("mno", 17);
    freq.put("scu", 6);
    freq.put("mna", 15);
    freq.put("Fin", 4);
    freq.put("mne", 4);
    freq.put("Fil", 9);
    freq.put(" śm", 35);
    freq.put("smo", 5);
    freq.put("zmi", 59);
    freq.put("tz", 14);
    freq.put("zmo", 13);
    freq.put("ty", 1008);
    freq.put("tv", 13);
    freq.put("tw", 291);
    freq.put("tt", 86);
    freq.put("zma", 24);
    freq.put("tr", 843);
    freq.put("ts", 19);
    freq.put("tp", 17);
    freq.put("zme", 3);
    freq.put("tn", 216);
    freq.put("to", 1666);
    freq.put("tl", 14);
    freq.put("tm", 28);
    freq.put("tj", 4);
    freq.put("tk", 371);
    freq.put("th", 41);
    freq.put("ti", 119);
    freq.put("tf", 17);
    freq.put("td", 7);
    freq.put("te", 1481);
    freq.put("tb", 6);
    freq.put("tc", 28);
    freq.put("zmu", 9);
    freq.put("smi", 19);
    freq.put("sc ", 27);
    freq.put("sme", 5);
    freq.put("zm ", 9);
    freq.put(" q", 4);
    freq.put("dsa", 3);
    freq.put("t ", 1038);
    freq.put(" w", 3487);
    freq.put("wę ", 25);
    freq.put("Smo", 6);
    freq.put("Smi", 4);
    freq.put("Sma", 3);
    freq.put("CO ", 3);
    freq.put("tó", 220);
    freq.put("doś", 18);
    freq.put("vic", 3);
    freq.put("via", 14);
    freq.put("vid", 7);
    freq.put("vie", 4);
    freq.put("vin", 4);
    freq.put("vil", 4);
    freq.put("Aut", 5);
    freq.put("tł", 22);
    freq.put("żli", 12);
    freq.put("żo ", 35);
    freq.put(" d ", 19);
    freq.put(" Q", 5);
    freq.put("vi ", 3);
    freq.put("ęty", 11);
    freq.put("ętu", 3);
    freq.put("ętr", 3);
    freq.put("ętn", 25);
    freq.put("zmę", 5);
    freq.put("tą", 54);
    freq.put("ęta", 35);
    freq.put(" do", 1045);
    freq.put(" dn", 70);
    freq.put(" dm", 3);
    freq.put(" dl", 196);
    freq.put("kla", 69);
    freq.put(" di", 13);
    freq.put(" de", 76);
    freq.put("klo", 7);
    freq.put(" db", 4);
    freq.put(" da", 159);
    freq.put("klu", 16);
    freq.put(" dz", 428);
    freq.put(" dy", 28);
    freq.put(" dw", 53);
    freq.put(" du", 94);
    freq.put(" dr", 99);
    freq.put("tył", 5);
    freq.put("atr", 88);
    freq.put("♥", 4);
    freq.put("itn", 3);
    freq.put("ito", 13);
    freq.put("ith", 6);
    freq.put("jeś", 42);
    freq.put("itd", 7);
    freq.put("ite", 22);
    freq.put("itc", 3);
    freq.put("ita", 52);
    freq.put("ity", 42);
    freq.put("itw", 6);
    freq.put("itt", 37);
    freq.put("itu", 7);
    freq.put("its", 4);
    freq.put("itp", 3);
    freq.put("wre", 13);
    freq.put("UR ", 4);
    freq.put("wra", 36);
    freq.put("jeź", 4);
    freq.put("wro", 19);
    freq.put("jeż", 12);
    freq.put("wrz", 31);
    freq.put("it ", 25);
    freq.put(" A ", 128);
    freq.put("MG ", 5);
    freq.put("at ", 95);
    freq.put("SH ", 3);
    freq.put("Wte", 3);
    freq.put(" Aa", 4);
    freq.put(" Ab", 4);
    freq.put(" Ac", 6);
    freq.put(" Ad", 11);
    freq.put(" Af", 4);
    freq.put(" Ag", 5);
    freq.put(" Ah", 12);
    freq.put(" Ak", 9);
    freq.put(" Al", 100);
    freq.put(" Am", 7);
    freq.put(" An", 59);
    freq.put(" Ap", 15);
    freq.put(" Ar", 22);
    freq.put(" As", 7);
    freq.put(" At", 4);
    freq.put(" Au", 11);
    freq.put(" Av", 3);
    freq.put(" Aw", 7);
    freq.put(" Az", 4);
    freq.put("NG ", 3);
    freq.put("ŁA ", 3);
    freq.put("eśc", 27);
    freq.put("ft ", 4);
    freq.put("w", 8845);
    freq.put("Fra", 10);
    freq.put("Fre", 3);
    freq.put("KE ", 3);
    freq.put("BB ", 3);
    freq.put("jer", 9);
    freq.put("jes", 712);
    freq.put("jew", 6);
    freq.put("jez", 14);
    freq.put("jeb", 70);
    freq.put("jec", 47);
    freq.put("jeg", 74);
    freq.put("jed", 150);
    freq.put("jee", 4);
    freq.put("jej", 69);
    freq.put("jek", 23);
    freq.put("jen", 12);
    freq.put("opy", 7);
    freq.put("jem", 57);
    freq.put("omu", 67);
    freq.put("Zwi", 3);
    freq.put("aaa", 101);
    freq.put("aam", 3);
    freq.put("aah", 6);
    freq.put("aak", 10);
    freq.put("aaj", 3);
    freq.put("je ", 421);
    freq.put("aas", 3);
    freq.put("aar", 6);
    freq.put("eką", 4);
    freq.put("Ir", 3);
    freq.put("odo", 93);
    freq.put("ex ", 5);
    freq.put("tp ", 8);
    freq.put("odd", 21);
    freq.put("oń ", 5);
    freq.put("Będ", 10);
    freq.put("odg", 5);
    freq.put("M", 572);
    freq.put("lną", 6);
    freq.put(" Aż", 3);
    freq.put("ońs", 3);
    freq.put("tpi", 4);
    freq.put("exi", 5);
    freq.put("ext", 3);
    freq.put("exu", 3);
    freq.put("exp", 4);
    freq.put("ońc", 100);
    freq.put("Hah", 17);
    freq.put("ugi", 43);
    freq.put("oju", 24);
    freq.put("ugo", 27);
    freq.put("Han", 5);
    freq.put("uga", 13);
    freq.put(" ów", 5);
    freq.put("oje", 190);
    freq.put("ojc", 9);
    freq.put("oja", 98);
    freq.put("Hap", 5);
    freq.put("ugr", 3);
    freq.put("Har", 12);
    freq.put("ugu", 8);
    freq.put("am ", 1369);
    freq.put("zkó", 5);
    freq.put("Ha ", 4);
    freq.put("ug ", 5);
    freq.put("oj ", 27);
    freq.put("cra", 4);
    freq.put("rfe", 4);
    freq.put("rfo", 4);
    freq.put("cro", 4);
    freq.put("set", 10);
    freq.put("ses", 7);
    freq.put("ser", 72);
    freq.put("For", 9);
    freq.put("kną", 10);
    freq.put("sez", 17);
    freq.put("sex", 3);
    freq.put("lec", 83);
    freq.put("sea", 3);
    freq.put("knę", 7);
    freq.put("Fol", 3);
    freq.put("sen", 70);
    freq.put("sem", 54);
    freq.put("sel", 17);
    freq.put("sek", 24);
    freq.put("sej", 7);
    freq.put("zkm", 4);
    freq.put("zko", 122);
    freq.put("zki", 41);
    freq.put("zke", 4);
    freq.put("zka", 53);
    freq.put("ągł", 3);
    freq.put("lem", 59);
    freq.put("se ", 24);
    freq.put("óg ", 7);
    freq.put("lep", 130);
    freq.put("ągó", 3);
    freq.put("nr ", 5);
    freq.put("lex", 6);
    freq.put("oog", 14);
    freq.put("Ola", 3);
    freq.put("Ole", 3);
    freq.put("mln", 3);
    freq.put("mlo", 5);
    freq.put("ugą", 6);
    freq.put("oję", 17);
    freq.put("oją", 33);
    freq.put("xa ", 3);
    freq.put("vol", 3);
    freq.put("von", 5);
    freq.put("ągu", 9);
    freq.put("ągi", 3);
    freq.put("ągn", 16);
    freq.put("ągl", 7);
    freq.put("ąga", 10);
    freq.put("żno", 4);
    freq.put("żni", 24);
    freq.put("żne", 27);
    freq.put("żna", 48);
    freq.put("ama", 92);
    freq.put("żny", 7);
    freq.put("seł", 5);
    freq.put("ógł", 16);
    freq.put("vo ", 6);
    freq.put("zką", 4);
    freq.put("zkę", 7);
    freq.put("ąg ", 8);
    freq.put("rdo", 52);
    freq.put("kno", 6);
    freq.put("Soc", 3);
    freq.put("Sob", 3);
    freq.put(" fu", 17);
    freq.put("Sof", 3);
    freq.put("kne", 10);
    freq.put("Som", 3);
    freq.put("kna", 14);
    freq.put(" fa", 150);
    freq.put("Sos", 4);
    freq.put(" fb", 4);
    freq.put(" fe", 23);
    freq.put(" ff", 3);
    freq.put(" fi", 82);
    freq.put(" fo", 58);
    freq.put("cić", 24);
    freq.put("cią", 91);
    freq.put("O ", 179);
    freq.put("cię", 49);
    freq.put("amw", 3);
    freq.put("Oo", 6);
    freq.put("On", 22);
    freq.put("Ol", 13);
    freq.put("Ok", 21);
    freq.put("Oj", 11);
    freq.put("uś", 36);
    freq.put("ciń", 4);
    freq.put("Og", 14);
    freq.put("Of", 4);
    freq.put("Od", 32);
    freq.put("Oc", 10);
    freq.put("Ob", 24);
    freq.put("Oz", 3);
    freq.put("bó", 31);
    freq.put("Ow", 5);
    freq.put("uń", 3);
    freq.put("Ot", 12);
    freq.put("Os", 18);
    freq.put("Or", 10);
    freq.put("uł", 46);
    freq.put("uż", 337);
    freq.put("d", 8315);
    freq.put("uź", 4);
    freq.put(" Dz", 82);
    freq.put("ijs", 4);
    freq.put("IV ", 3);
    freq.put("ija", 33);
    freq.put("ijc", 3);
    freq.put("ije", 8);
    freq.put("agę", 5);
    freq.put("ijk", 4);
    freq.put("man", 45);
    freq.put("tyd", 24);
    freq.put("Źró", 3);
    freq.put("bd", 24);
    freq.put("be", 299);
    freq.put("bg", 4);
    freq.put("ba", 609);
    freq.put("bb", 10);
    freq.put("bc", 36);
    freq.put("bl", 174);
    freq.put("bm", 4);
    freq.put("bn", 47);
    freq.put("bo", 494);
    freq.put("bi", 847);
    freq.put("bj", 5);
    freq.put("bk", 39);
    freq.put("ij ", 17);
    freq.put("bu", 149);
    freq.put("bw", 3);
    freq.put("br", 412);
    freq.put("bs", 33);
    freq.put("by", 786);
    freq.put("Fu", 7);
    freq.put("Pis", 5);
    freq.put("Ost", 6);
    freq.put("Oso", 3);
    freq.put("Osc", 3);
    freq.put("ME ", 6);
    freq.put(" C ", 28);
    freq.put(" łó", 15);
    freq.put("Ślą", 4);
    freq.put("ci ", 237);
    freq.put("JE ", 4);
    freq.put("PO ", 22);
    freq.put("qua", 4);
    freq.put("u ", 1347);
    freq.put("Fe", 25);
    freq.put(" Ch", 91);
    freq.put(" Ci", 156);
    freq.put(" Co", 67);
    freq.put(" Cl", 6);
    freq.put("uT", 4);
    freq.put(" Ca", 33);
    freq.put(" Ce", 20);
    freq.put(" Cz", 90);
    freq.put(" Cy", 5);
    freq.put(" ś", 201);
    freq.put(" Cr", 7);
    freq.put(" Cu", 6);
    freq.put("cic", 6);
    freq.put("cia", 224);
    freq.put("cig", 6);
    freq.put("ux", 4);
    freq.put("cie", 687);
    freq.put("uz", 118);
    freq.put("cik", 4);
    freq.put("ut", 292);
    freq.put("uw", 76);
    freq.put("cio", 16);
    freq.put("cin", 33);
    freq.put("cim", 4);
    freq.put("cil", 7);
    freq.put("um", 263);
    freq.put("ul", 159);
    freq.put("uo", 4);
    freq.put("un", 124);
    freq.put("ciw", 17);
    freq.put("uh", 10);
    freq.put("ciu", 40);
    freq.put("uj", 433);
    freq.put("ue", 26);
    freq.put("ud", 292);
    freq.put("ug", 110);
    freq.put("uf", 9);
    freq.put("ua", 61);
    freq.put("uc", 275);
    freq.put("ub", 209);
    freq.put(" łe", 7);
    freq.put(" ła", 62);
    freq.put(" ło", 7);
    freq.put("ózg", 9);
    freq.put(" łu", 3);
    freq.put("Są ", 4);
    freq.put(" ły", 5);
    freq.put("rł ", 6);
    freq.put("bą", 24);
    freq.put("jcz", 11);
    freq.put("ag ", 6);
    freq.put("bę", 223);
    freq.put("óz ", 3);
    freq.put("rło", 3);
    freq.put(" Źr", 3);
    freq.put("rła", 5);
    freq.put("ago", 11);
    freq.put("agn", 13);
    freq.put("agm", 5);
    freq.put("agl", 15);
    freq.put("bł", 22);
    freq.put("iję", 6);
    freq.put("age", 14);
    freq.put("aga", 38);
    freq.put("ció", 12);
    freq.put("iją", 3);
    freq.put("agu", 6);
    freq.put("agr", 46);
    freq.put("odó", 5);
    freq.put("ziś", 72);
    freq.put("ziń", 3);
    freq.put("ził", 33);
    freq.put("tr ", 31);
    freq.put("cne", 7);
    freq.put("zię", 85);
    freq.put("zić", 29);
    freq.put("zią", 8);
    freq.put("tri", 18);
    freq.put("evi", 6);
    freq.put("tro", 229);
    freq.put("tra", 170);
    freq.put("tre", 47);
    freq.put("eve", 26);
    freq.put("try", 15);
    freq.put("trz", 249);
    freq.put("tru", 42);
    freq.put("trw", 23);
    freq.put("le ", 778);
    freq.put("ody", 37);
    freq.put("odz", 310);
    freq.put("ueh", 5);
    freq.put("odp", 56);
    freq.put("odr", 31);
    freq.put("ods", 38);
    freq.put("odt", 3);
    freq.put("odu", 42);
    freq.put("odw", 30);
    freq.put("odi", 6);
    freq.put("Blo", 8);
    freq.put("odk", 34);
    freq.put("odl", 12);
    freq.put("odm", 10);
    freq.put("odn", 87);
    freq.put("wąt", 9);
    freq.put("oda", 119);
    freq.put("odb", 14);
    freq.put("odc", 56);
    freq.put("Bla", 7);
    freq.put("ode", 53);
    freq.put("uer", 4);
    freq.put("rd ", 13);
    freq.put("leb", 10);
    freq.put("wą ", 42);
    freq.put("led", 24);
    freq.put("lee", 11);
    freq.put("lef", 32);
    freq.put("leg", 35);
    freq.put("lei", 5);
    freq.put("lej", 75);
    freq.put("lek", 87);
    freq.put("ue ", 12);
    freq.put("len", 83);
    freq.put("róż", 33);
    freq.put("ler", 43);
    freq.put("les", 33);
    freq.put("let", 62);
    freq.put("lew", 31);
    freq.put("od ", 209);
    freq.put("ley", 3);
    freq.put("lez", 10);
    freq.put("rdu", 6);
    freq.put("ctw", 13);
    freq.put("rds", 6);
    freq.put("rdy", 7);
    freq.put("rdz", 144);
    freq.put("rde", 38);
    freq.put("rda", 15);
    freq.put("tró", 9);
    freq.put("cto", 5);
    freq.put("cti", 3);
    freq.put("rdk", 3);
    freq.put("Rz ", 4);
    freq.put("trą", 4);
    freq.put("Ukr", 3);
    freq.put("trę", 3);
    freq.put("ziw", 54);
    freq.put("ziu", 4);
    freq.put("Cla", 3);
    freq.put("zis", 125);
    freq.put("zie", 818);
    freq.put("zib", 6);
    freq.put("zic", 35);
    freq.put("zia", 228);
    freq.put("zin", 79);
    freq.put("zio", 17);
    freq.put("zil", 9);
    freq.put("zim", 22);
    freq.put("zik", 9);
    freq.put("Rze", 4);
    freq.put("pff", 7);
    freq.put("ótc", 3);
    freq.put("zi ", 130);
    freq.put("cji", 123);
    freq.put("oz ", 5);
    freq.put("odź", 3);
    freq.put("ńsz", 4);
    freq.put("ńst", 21);
    freq.put("rdę", 3);
    freq.put("np ", 10);
    freq.put("ńsk", 70);
    freq.put("cni", 9);
    freq.put("odś", 4);
    freq.put("leć", 8);
    freq.put("On ", 7);
    freq.put("odł", 7);
    freq.put("ról", 7);
    freq.put("rój", 8);
    freq.put("ród", 14);
    freq.put("rób", 28);
    freq.put("róc", 44);
    freq.put("Q", 6);
    freq.put("rdł", 3);
    freq.put("rót", 18);
    freq.put("leź", 10);
    freq.put("rów", 74);
    freq.put("leż", 33);
    freq.put("odę", 13);
    freq.put("leń", 13);
    freq.put("Ona", 4);
    freq.put("One", 9);
    freq.put("Ż", 36);
    freq.put("leś", 10);
    freq.put("odą", 3);
    freq.put("TY ", 3);
    freq.put(" h ", 35);
    freq.put("San", 4);
    freq.put("Sam", 14);
    freq.put("Sac", 3);
    freq.put(" hu", 20);
    freq.put(" ht", 9);
    freq.put(" hi", 26);
    freq.put(" ho", 20);
    freq.put(" hm", 13);
    freq.put(" ha", 211);
    freq.put(" he", 26);
    freq.put("cką", 3);
    freq.put("mni", 386);
    freq.put("baz", 3);
    freq.put("Zna", 10);
    freq.put("Zno", 3);
    freq.put("zap", 104);
    freq.put("lon", 50);
    freq.put("IT ", 6);
    freq.put("JB ", 11);
    freq.put("lly", 4);
    freq.put("GF ", 3);
    freq.put("eść", 14);
    freq.put("ck ", 37);
    freq.put(" El", 10);
    freq.put(" Em", 7);
    freq.put(" En", 9);
    freq.put(" Ej", 8);
    freq.put(" Ek", 6);
    freq.put(" Ed", 7);
    freq.put(" Ef", 3);
    freq.put(" Eg", 3);
    freq.put(" Ec", 4);
    freq.put(" Ex", 5);
    freq.put(" Eu", 26);
    freq.put(" Ev", 3);
    freq.put(" Ew", 5);
    freq.put(" Ep", 3);
    freq.put(" Es", 6);
    freq.put("cke", 5);
    freq.put("cka", 20);
    freq.put("AA ", 5);
    freq.put("cko", 12);
    freq.put("cki", 47);
    freq.put("cku", 7);
    freq.put("cks", 5);
    freq.put("dbi", 7);
    freq.put("szk", 135);
    freq.put("szn", 41);
    freq.put("szo", 31);
    freq.put("szl", 21);
    freq.put("szm", 6);
    freq.put("dba", 4);
    freq.put("szc", 300);
    freq.put("sza", 234);
    freq.put("sze", 312);
    freq.put("OD ", 5);
    freq.put("szy", 403);
    freq.put("szp", 23);
    freq.put("KI ", 9);
    freq.put("szt", 55);
    freq.put("szu", 51);
    freq.put("jaz", 22);
    freq.put("cł", 6);
    freq.put("jat", 3);
    freq.put("jar", 22);
    freq.put("jas", 12);
    freq.put("jap", 8);
    freq.put("jan", 18);
    freq.put("jal", 31);
    freq.put("jam", 11);
    freq.put("jaj", 15);
    freq.put("jak", 645);
    freq.put("jad", 27);
    freq.put("jac", 30);
    freq.put("jaa", 4);
    freq.put("sz ", 449);
    freq.put("etó", 4);
    freq.put("h", 3101);
    freq.put("cą", 41);
    freq.put("cę", 58);
    freq.put("ael", 4);
    freq.put("ja ", 593);
    freq.put("Pr", 179);
    freq.put("Ps", 3);
    freq.put("btw", 6);
    freq.put("Pu", 16);
    freq.put("Py", 4);
    freq.put("oma", 48);
    freq.put("Pa", 119);
    freq.put("OP ", 7);
    freq.put("lęd", 5);
    freq.put("Pe", 29);
    freq.put("Ph", 10);
    freq.put("Pi", 93);
    freq.put("Po", 362);
    freq.put("Pl", 19);
    freq.put("et ", 142);
    freq.put("lf", 14);
    freq.put("P ", 84);
    freq.put("ogę", 48);
    freq.put("etr", 24);
    freq.put("ett", 4);
    freq.put("etu", 22);
    freq.put("ety", 80);
    freq.put("etc", 3);
    freq.put("CR ", 3);
    freq.put("eta", 40);
    freq.put("tle", 8);
    freq.put("lo", 421);
    freq.put("etk", 11);
    freq.put("eth", 3);
    freq.put("eti", 6);
    freq.put("etn", 55);
    freq.put("eto", 32);
    freq.put("ck", 145);
    freq.put("cj", 417);
    freq.put("ci", 1545);
    freq.put("ch", 1828);
    freq.put("co", 570);
    freq.put("cn", 37);
    freq.put("Her", 3);
    freq.put("cl", 9);
    freq.put("cc", 6);
    freq.put("cb", 7);
    freq.put("ca", 333);
    freq.put("ucz", 87);
    freq.put("ce", 584);
    freq.put("cd", 6);
    freq.put("cz", 2288);
    freq.put("uce", 11);
    freq.put("uca", 9);
    freq.put("Hel", 7);
    freq.put("cr", 13);
    freq.put("ęc ", 41);
    freq.put("uck", 11);
    freq.put("ucj", 3);
    freq.put("uci", 37);
    freq.put("uch", 111);
    freq.put("Ger", 4);
    freq.put("jaź", 3);
    freq.put("szł", 49);
    freq.put("cD", 3);
    freq.put("Gee", 3);
    freq.put("tsz", 3);
    freq.put("Gen", 4);
    freq.put("rb ", 6);
    freq.put("ęcz", 29);
    freq.put("ęcy", 7);
    freq.put("lgi", 3);
    freq.put("lgo", 13);
    freq.put("c ", 531);
    freq.put("ęci", 89);
    freq.put("lgr", 3);
    freq.put("ęca", 8);
    freq.put("ęce", 43);
    freq.put("lli", 13);
    freq.put("szą", 34);
    freq.put("rbo", 4);
    freq.put("szę", 121);
    freq.put("rbi", 5);
    freq.put("rbe", 5);
    freq.put("ly", 45);
    freq.put("rba", 8);
    freq.put("va", 18);
    freq.put("ve", 83);
    freq.put("vi", 45);
    freq.put("etę", 7);
    freq.put("źci", 3);
    freq.put("vn", 4);
    freq.put("vo", 17);
    freq.put("vs", 3);
    freq.put("có", 34);
    freq.put("of ", 10);
    freq.put("zgr", 13);
    freq.put("Ś ", 5);
    freq.put("zgu", 6);
    freq.put("zgi", 7);
    freq.put("zgl", 8);
    freq.put("zgo", 5);
    freq.put("zga", 7);
    freq.put("v ", 16);
    freq.put("pho", 14);
    freq.put("phe", 5);
    freq.put("udż", 4);
    freq.put("Śl", 7);
    freq.put("Śm", 5);
    freq.put("ofa", 7);
    freq.put("ofe", 13);
    freq.put("ofi", 29);
    freq.put("ofm", 4);
    freq.put("oft", 4);
    freq.put("zg ", 5);
    freq.put("Św", 16);
    freq.put("ącą", 4);
    freq.put("weg", 52);
    freq.put("wee", 49);
    freq.put("wek", 7);
    freq.put("wej", 74);
    freq.put("wei", 5);
    freq.put("wen", 14);
    freq.put("wem", 7);
    freq.put("wel", 4);
    freq.put("wes", 16);
    freq.put("wer", 43);
    freq.put("wew", 3);
    freq.put("wet", 70);
    freq.put("wez", 3);
    freq.put("ię", 1407);
    freq.put("we ", 158);
    freq.put("kró", 20);
    freq.put("gur", 11);
    freq.put("Un", 12);
    freq.put(" j ", 5);
    freq.put("tmy", 5);
    freq.put("vs ", 3);
    freq.put("krz", 32);
    freq.put("kry", 25);
    freq.put("inę", 17);
    freq.put(" ju", 334);
    freq.put("krw", 3);
    freq.put("kru", 5);
    freq.put("Mni", 9);
    freq.put(" jo", 6);
    freq.put("kro", 34);
    freq.put(" je", 1006);
    freq.put("iną", 7);
    freq.put("kra", 53);
    freq.put(" ja", 1058);
    freq.put("kre", 29);
    freq.put("weł", 6);
    freq.put("yrk", 3);
    freq.put("ąc ", 65);
    freq.put("yra", 7);
    freq.put("yre", 9);
    freq.put("weź", 4);
    freq.put("Zle", 4);
    freq.put("Kle", 4);
    freq.put("Kla", 5);
    freq.put("Kli", 3);
    freq.put("Klu", 3);
    freq.put("ące", 33);
    freq.put("ąca", 12);
    freq.put("ąco", 6);
    freq.put("ąci", 3);
    freq.put("ącz", 46);
    freq.put("ący", 42);
    freq.put("krę", 20);
    freq.put(" ję", 16);
    freq.put("iny", 43);
    freq.put("int", 65);
    freq.put("inu", 35);
    freq.put("inw", 6);
    freq.put("ins", 17);
    freq.put("inn", 97);
    freq.put("ino", 25);
    freq.put("ini", 76);
    freq.put("inj", 3);
    freq.put("ink", 56);
    freq.put("ind", 15);
    freq.put("ine", 42);
    freq.put("inf", 33);
    freq.put("ing", 57);
    freq.put("ina", 109);
    freq.put("inc", 12);
    freq.put("eo ", 18);
    freq.put("tma", 8);
    freq.put("DA ", 5);
    freq.put("U", 122);
    freq.put("in ", 108);
    freq.put("CI ", 3);
    freq.put("eog", 4);
    freq.put("eon", 3);
    freq.put("eor", 5);
    freq.put("eop", 3);
    freq.put("rep", 13);
    freq.put("aln", 147);
    freq.put("Wre", 3);
    freq.put("Wro", 13);
    freq.put("erę", 6);
    freq.put("Jeż", 7);
    freq.put("tną", 3);
    freq.put("MA ", 6);
    freq.put("erć", 3);
    freq.put(" G ", 4);
    freq.put("pti", 3);
    freq.put("Jeś", 13);
    freq.put("ołą", 16);
    freq.put("ołę", 5);
    freq.put("ren", 45);
    freq.put(" Gw", 5);
    freq.put(" Gu", 5);
    freq.put(" Gr", 35);
    freq.put(" Gd", 29);
    freq.put(" Ge", 12);
    freq.put(" Ga", 29);
    freq.put(" Go", 30);
    freq.put(" Gl", 11);
    freq.put(" Gm", 3);
    freq.put(" Gi", 4);
    freq.put("akó", 19);
    freq.put("brą", 5);
    freq.put("Mło", 6);
    freq.put("uaż", 3);
    freq.put("że", 848);
    freq.put("Wró", 5);
    freq.put("ptu", 8);
    freq.put("gl ", 20);
    freq.put("lać", 10);
    freq.put("ką ", 84);
    freq.put("ak ", 837);
    freq.put(" Gó", 3);
    freq.put("laż", 3);
    freq.put("Cr", 7);
    freq.put("gli", 15);
    freq.put("glo", 9);
    freq.put("aks", 6);
    freq.put("gla", 28);
    freq.put("kąd", 11);
    freq.put("gle", 34);
    freq.put("aku", 60);
    freq.put("akt", 70);
    freq.put("aki", 336);
    freq.put("ako", 95);
    freq.put("akn", 3);
    freq.put("akl", 8);
    freq.put("akc", 41);
    freq.put("akb", 32);
    freq.put("aka", 139);
    freq.put("ake", 9);
    freq.put("nk ", 20);
    freq.put("Jes", 66);
    freq.put("brz", 98);
    freq.put("bry", 42);
    freq.put("Jez", 6);
    freq.put("bru", 7);
    freq.put("brr", 3);
    freq.put("oł ", 7);
    freq.put("bro", 36);
    freq.put("Jed", 17);
    freq.put("bre", 33);
    freq.put("OR ", 4);
    freq.put("er ", 178);
    freq.put("oło", 29);
    freq.put("nkc", 5);
    freq.put("nke", 4);
    freq.put("nki", 51);
    freq.put("ołe", 5);
    freq.put("oła", 36);
    freq.put("nkt", 7);
    freq.put("nku", 36);
    freq.put("oły", 25);
    freq.put("ołu", 13);
    freq.put("br ", 5);
    freq.put("ert", 50);
    freq.put("eru", 17);
    freq.put("erw", 151);
    freq.put("erp", 44);
    freq.put("err", 13);
    freq.put("ih", 5);
    freq.put("iór", 6);
    freq.put("tny", 33);
    freq.put("ery", 45);
    freq.put("erz", 108);
    freq.put("erd", 88);
    freq.put("ere", 58);
    freq.put("erf", 9);
    freq.put("erg", 18);
    freq.put(" Gł", 10);
    freq.put("era", 289);
    freq.put("erb", 12);
    freq.put("erc", 39);
    freq.put("erl", 8);
    freq.put("erm", 20);
    freq.put("ern", 72);
    freq.put("ąć ", 44);
    freq.put("tni", 128);
    freq.put("eri", 55);
    freq.put("il", 389);
    freq.put("Nat", 9);
    freq.put("Nau", 3);
    freq.put("la ", 305);
    freq.put("glą", 105);
    freq.put("glę", 5);
    freq.put("ual", 26);
    freq.put("uan", 3);
    freq.put("uac", 15);
    freq.put("aką", 31);
    freq.put("ki ", 569);
    freq.put("lal", 15);
    freq.put("lam", 97);
    freq.put("lan", 94);
    freq.put("laj", 12);
    freq.put("lak", 24);
    freq.put("lad", 45);
    freq.put("lag", 5);
    freq.put("laa", 3);
    freq.put("lab", 8);
    freq.put("lac", 71);
    freq.put("nkó", 5);
    freq.put("kąś", 7);
    freq.put("lay", 8);
    freq.put("laz", 18);
    freq.put("lat", 97);
    freq.put("akł", 14);
    freq.put("law", 10);
    freq.put("lap", 17);
    freq.put("lar", 29);
    freq.put("las", 82);
    freq.put("eró", 14);
    freq.put("łą ", 14);
    freq.put("zeb", 102);
    freq.put("zec", 160);
    freq.put("zef", 3);
    freq.put("zeg", 142);
    freq.put("zed", 134);
    freq.put("zej", 110);
    freq.put("zek", 113);
    freq.put("zen", 186);
    freq.put("zel", 31);
    freq.put("zem", 108);
    freq.put("zer", 82);
    freq.put("zes", 134);
    freq.put("zep", 48);
    freq.put("zew", 38);
    freq.put("zet", 16);
    freq.put("zez", 78);
    freq.put(" lą", 3);
    freq.put("ze ", 765);
    freq.put("ł", 3627);
    freq.put("ntó", 15);
    freq.put("zła", 46);
    freq.put("łty", 3);
    freq.put("l", 6375);
    freq.put("zło", 52);
    freq.put("łta", 4);
    freq.put("łto", 3);
    freq.put("ćwi", 6);
    freq.put("nt ", 64);
    freq.put("wgl", 16);
    freq.put("Oj ", 4);
    freq.put("nty", 33);
    freq.put("nts", 3);
    freq.put("ntr", 31);
    freq.put("ntu", 22);
    freq.put("nti", 6);
    freq.put("ntk", 4);
    freq.put("nto", 27);
    freq.put("ntn", 6);
    freq.put("nta", 69);
    freq.put("nte", 77);
    freq.put("wg ", 8);
    freq.put(" l ", 4);
    freq.put("kib", 17);
    freq.put("zeź", 4);
    freq.put("zeż", 7);
    freq.put("zeł", 4);
    freq.put("zeń", 9);
    freq.put("ześ", 42);
    freq.put("kt ", 39);
    freq.put(" le", 185);
    freq.put("B", 404);
    freq.put(" la", 96);
    freq.put(" lo", 73);
    freq.put(" li", 113);
    freq.put(" lu", 139);
    freq.put(" ly", 4);
    freq.put("zeć", 26);
    freq.put("ktu", 34);
    freq.put("ktr", 3);
    freq.put("See", 3);
    freq.put("kto", 132);
    freq.put("WY ", 4);
    freq.put("Sen", 4);
    freq.put("Sel", 13);
    freq.put("Sek", 4);
    freq.put("Sej", 10);
    freq.put("Q ", 4);
    freq.put("ypr", 6);
    freq.put("ypu", 6);
    freq.put("ypy", 5);
    freq.put("ogu", 13);
    freq.put("ypa", 36);
    freq.put("ype", 10);
    freq.put("ypi", 22);
    freq.put("ypo", 34);
    freq.put("ypl", 3);
    freq.put("mba", 6);
    freq.put("któ", 159);
    freq.put("ogn", 3);
    freq.put("ówc", 5);
    freq.put("suk", 11);
    freq.put("gnę", 6);
    freq.put("d ", 647);
    freq.put("oge", 19);
    freq.put("gną", 10);
    freq.put("aić", 3);
    freq.put("lą ", 17);
    freq.put("KP ", 4);
    freq.put("em ", 884);
    freq.put("hrz", 4);
    freq.put("dów", 18);
    freq.put("wzr", 9);
    freq.put("hro", 8);
    freq.put("hri", 11);
    freq.put("wzi", 19);
    freq.put("wzg", 6);
    freq.put("Joh", 3);
    freq.put("wza", 3);
    freq.put("dn", 437);
    freq.put("do", 1399);
    freq.put("dl", 248);
    freq.put("dm", 26);
    freq.put("dj", 67);
    freq.put("dk", 84);
    freq.put("dh", 3);
    freq.put("di", 118);
    freq.put("df", 3);
    freq.put("dg", 11);
    freq.put("dd", 47);
    freq.put("de", 427);
    freq.put("db", 22);
    freq.put("dc", 79);
    freq.put("da", 926);
    freq.put("dz", 1952);
    freq.put("dy", 458);
    freq.put("dw", 96);
    freq.put("dt", 3);
    freq.put("du", 227);
    freq.put("dr", 255);
    freq.put("ds", 84);
    freq.put("dp", 62);
    freq.put("dN", 6);
    freq.put("ląc", 3);
    freq.put("ema", 42);
    freq.put("CK ", 4);
    freq.put("emc", 13);
    freq.put("emo", 31);
    freq.put("emn", 16);
    freq.put("emi", 103);
    freq.put("emk", 6);
    freq.put("emu", 72);
    freq.put("ląs", 9);
    freq.put("emp", 23);
    freq.put("emy", 85);
    freq.put("w ", 1647);
    freq.put(" I ", 95);
    freq.put("mą ", 10);
    freq.put("il ", 26);
    freq.put("xD ", 98);
    freq.put("nić", 15);
    freq.put("nią", 31);
    freq.put("co ", 314);
    freq.put("nię", 44);
    freq.put("wg", 26);
    freq.put("we", 525);
    freq.put("wd", 108);
    freq.put("wc", 170);
    freq.put("wb", 11);
    freq.put("wa", 1325);
    freq.put("wo", 513);
    freq.put("wn", 305);
    freq.put(" Ir", 3);
    freq.put("wl", 29);
    freq.put("wk", 95);
    freq.put("wj", 3);
    freq.put(" Iv", 4);
    freq.put("wh", 5);
    freq.put("ww", 34);
    freq.put("wu", 66);
    freq.put("wt", 41);
    freq.put(" Il", 6);
    freq.put(" Im", 5);
    freq.put(" In", 36);
    freq.put("wp", 37);
    freq.put(" Ia", 3);
    freq.put(" Id", 18);
    freq.put("dó", 20);
    freq.put("wy", 924);
    freq.put("ilg", 13);
    freq.put("cos", 13);
    freq.put("ile", 77);
    freq.put("ilc", 3);
    freq.put("GB ", 3);
    freq.put("ila", 32);
    freq.put("iln", 12);
    freq.put("ilo", 15);
    freq.put("ill", 27);
    freq.put("ilm", 50);
    freq.put("ilk", 42);
    freq.put("ili", 61);
    freq.put("ilv", 3);
    freq.put("ilu", 9);
    freq.put("cod", 10);
    freq.put("emó", 10);
    freq.put("cof", 3);
    freq.put("cok", 3);
    freq.put("com", 16);
    freq.put("col", 4);
    freq.put("coo", 4);
    freq.put("ily", 4);
    freq.put("ąłe", 5);
    freq.put("dą", 55);
    freq.put("mbu", 4);
    freq.put("haz", 3);
    freq.put("gn ", 3);
    freq.put("dę", 203);
    freq.put("dż", 21);
    freq.put("dź", 47);
    freq.put("nió", 3);
    freq.put("bna", 4);
    freq.put("gnu", 3);
    freq.put("ait", 7);
    freq.put("dł", 104);
    freq.put("ais", 4);
    freq.put("air", 6);
    freq.put("ail", 15);
    freq.put("gna", 9);
    freq.put("dś", 4);
    freq.put("gne", 5);
    freq.put("aid", 6);
    freq.put("gni", 22);
    freq.put("gno", 4);
    freq.put("ilą", 3);
    freq.put("ni ", 210);
    freq.put("ilę", 4);
    freq.put("wą", 56);
    freq.put("ep ", 10);
    freq.put("th ", 5);
    freq.put("nij", 13);
    freq.put("nik", 156);
    freq.put("nii", 8);
    freq.put("nin", 22);
    freq.put("nio", 83);
    freq.put("nil", 9);
    freq.put("nim", 52);
    freq.put("nib", 16);
    freq.put("nic", 196);
    freq.put("coś", 118);
    freq.put("nia", 473);
    freq.put("nig", 36);
    freq.put("nie", 3124);
    freq.put("niz", 28);
    freq.put("Y", 40);
    freq.put("nis", 41);
    freq.put("niw", 3);
    freq.put("nit", 16);
    freq.put("niu", 92);
    freq.put("wł", 140);
    freq.put("epy", 3);
    freq.put("ept", 8);
    freq.put("epu", 11);
    freq.put("epr", 57);
    freq.put("eps", 72);
    freq.put("epp", 15);
    freq.put("epn", 4);
    freq.put("epo", 19);
    freq.put("epl", 7);
    freq.put("epk", 3);
    freq.put("epi", 71);
    freq.put("mąż", 3);
    freq.put("the", 14);
    freq.put("thd", 4);
    freq.put("wś", 6);
    freq.put("tha", 7);
    freq.put("epa", 8);
    freq.put("mie", 428);
    freq.put("wań", 5);
    freq.put("wał", 142);
    freq.put("waś", 7);
    freq.put("mtą", 3);
    freq.put("opo", 42);
    freq.put("Gaz", 7);
    freq.put("ęga", 3);
    freq.put("ęgn", 5);
    freq.put("Gar", 6);
    freq.put("ęgi", 4);
    freq.put("ykó", 9);
    freq.put("ęgu", 3);
    freq.put("waż", 57);
    freq.put("Gab", 4);
    freq.put("Tri", 3);
    freq.put("rni", 68);
    freq.put("rno", 21);
    freq.put("Tro", 7);
    freq.put("Tra", 8);
    freq.put("rna", 22);
    freq.put("Tre", 7);
    freq.put("rne", 55);
    freq.put("rny", 13);
    freq.put("Trz", 16);
    freq.put("lca", 5);
    freq.put("Tru", 4);
    freq.put("lci", 3);
    freq.put("obó", 6);
    freq.put("głę", 4);
    freq.put("zce", 8);
    freq.put("ą", 1709);
    freq.put("Ewa", 3);
    freq.put("zch", 6);
    freq.put("zci", 29);
    freq.put("pl ", 41);
    freq.put("zcz", 292);
    freq.put("Lea", 3);
    freq.put("yka", 57);
    freq.put("Lec", 7);
    freq.put("Leg", 10);
    freq.put("yki", 26);
    freq.put("Lek", 6);
    freq.put("yko", 33);
    freq.put("ykn", 3);
    freq.put("ob ", 4);
    freq.put("ykl", 19);
    freq.put("Lep", 19);
    freq.put("ykr", 6);
    freq.put("Les", 6);
    freq.put("Let", 6);
    freq.put("yku", 23);
    freq.put("Lew", 3);
    freq.put("plu", 15);
    freq.put("ple", 39);
    freq.put("pla", 55);
    freq.put("plo", 5);
    freq.put("pli", 23);
    freq.put("obn", 25);
    freq.put("obo", 47);
    freq.put("obl", 32);
    freq.put("yk ", 30);
    freq.put("obj", 3);
    freq.put("obi", 362);
    freq.put("obe", 46);
    freq.put("obb", 4);
    freq.put("obc", 19);
    freq.put("oba", 117);
    freq.put("oby", 42);
    freq.put("obu", 12);
    freq.put("obr", 229);
    freq.put("obs", 16);
    freq.put("głe", 5);
    freq.put("głb", 7);
    freq.put("Cup", 3);
    freq.put("gło", 77);
    freq.put("głu", 26);
    freq.put("gły", 8);
    freq.put("wan", 199);
    freq.put("wam", 32);
    freq.put("wal", 103);
    freq.put("wak", 28);
    freq.put("waj", 35);
    freq.put("wag", 19);
    freq.put("wad", 27);
    freq.put("wac", 36);
    freq.put("wab", 4);
    freq.put("rną", 6);
    freq.put("waz", 8);
    freq.put("way", 7);
    freq.put("waw", 8);
    freq.put("wat", 26);
    freq.put("was", 28);
    freq.put("war", 111);
    freq.put("olk", 10);
    freq.put("gł ", 11);
    freq.put("mty", 4);
    freq.put("Odp", 5);
    freq.put("wa ", 320);
    freq.put("Odd", 7);
    freq.put("chy", 124);
    freq.put("mte", 3);
    freq.put("ykł", 24);
    freq.put("obą", 15);
    freq.put("głó", 14);
    freq.put("oly", 5);
    freq.put("dło", 17);
    freq.put("dła", 18);
    freq.put("dłe", 6);
    freq.put("dły", 4);
    freq.put("iów", 4);
    freq.put("dłu", 39);
    freq.put(" ni", 1800);
    freq.put("fot", 14);
    freq.put(" no", 420);
    freq.put(" na", 1821);
    freq.put(" ne", 36);
    freq.put(" np", 10);
    freq.put("ykę", 16);
    freq.put(" nr", 5);
    freq.put(" nu", 36);
    freq.put("Sk", 21);
    freq.put("dł ", 16);
    freq.put("umr", 5);
    freq.put("Kto", 23);
    freq.put("Pó", 6);
    freq.put("Zde", 4);
    freq.put("cać", 9);
    freq.put("gu ", 34);
    freq.put("cał", 75);
    freq.put("umo", 19);
    freq.put("gub", 4);
    freq.put("EO ", 3);
    freq.put("gue", 4);
    freq.put("ós", 10);
    freq.put("guj", 4);
    freq.put("ów", 550);
    freq.put("gun", 4);
    freq.put("gum", 4);
    freq.put("ót", 19);
    freq.put("gus", 7);
    freq.put("p", 6246);
    freq.put("ól", 64);
    freq.put("óc", 62);
    freq.put("ób", 51);
    freq.put("óg", 24);
    freq.put("ód", 38);
    freq.put("ol ", 45);
    freq.put("OK ", 6);
    freq.put("htt", 6);
    freq.put("Ins", 6);
    freq.put("IN ", 7);
    freq.put("ek ", 215);
    freq.put("ht ", 11);
    freq.put("alę", 6);
    freq.put("fał", 6);
    freq.put("St", 79);
    freq.put("eko", 50);
    freq.put("ekn", 7);
    freq.put("ekl", 20);
    freq.put("ekk", 4);
    freq.put("eki", 29);
    freq.put("eke", 24);
    freq.put("ekc", 37);
    freq.put("eka", 162);
    freq.put("ęść", 9);
    freq.put("jaw", 24);
    freq.put("ekw", 5);
    freq.put("PC ", 3);
    freq.put("ekt", 73);
    freq.put("eks", 46);
    freq.put("ekr", 17);
    freq.put("uzn", 4);
    freq.put("uzo", 8);
    freq.put("uzi", 7);
    freq.put("uzj", 7);
    freq.put("uze", 4);
    freq.put("spó", 28);
    freq.put("uza", 9);
    freq.put("uzb", 3);
    freq.put("uzy", 29);
    freq.put(" Ka", 90);
    freq.put(" Ke", 12);
    freq.put(" Ki", 39);
    freq.put(" Kn", 6);
    freq.put(" Ko", 96);
    freq.put(" Kl", 17);
    freq.put(" Kr", 51);
    freq.put(" Ks", 3);
    freq.put(" Kw", 6);
    freq.put(" Kt", 27);
    freq.put(" Ku", 56);
    freq.put(" il", 32);
    freq.put(" Ky", 4);
    freq.put("Mon", 9);
    freq.put(" in", 183);
    freq.put("F", 188);
    freq.put("uz ", 37);
    freq.put("fb ", 3);
    freq.put("ół", 69);
    freq.put("ibi", 18);
    freq.put(" K ", 4);
    freq.put("ibl", 7);
    freq.put("óż", 63);
    freq.put("cas", 7);
    freq.put("iba", 4);
    freq.put("ibb", 3);
    freq.put("ibe", 4);
    freq.put("iby", 33);
    freq.put("can", 7);
    freq.put("cam", 34);
    freq.put("cal", 27);
    freq.put("cac", 17);
    freq.put("AK ", 6);
    freq.put("cad", 3);
    freq.put("spy", 7);
    freq.put("ao ", 7);
    freq.put("spr", 93);
    freq.put("ęśc", 26);
    freq.put("spi", 32);
    freq.put("spl", 4);
    freq.put("spo", 188);
    freq.put("spa", 102);
    freq.put("spe", 30);
    freq.put("ęśl", 5);
    freq.put("ślą", 6);
    freq.put("gh ", 4);
    freq.put("ekł", 8);
    freq.put("ght", 10);
    freq.put("zów", 11);
    freq.put("zór", 4);
    freq.put("KO ", 5);
    freq.put("ER ", 4);
    freq.put("tj ", 3);
    freq.put("Rv", 3);
    freq.put("Chc", 21);
    freq.put("Che", 5);
    freq.put("Chi", 7);
    freq.put("Jar", 15);
    freq.put("Ry", 12);
    freq.put("Rz", 12);
    freq.put("Cho", 18);
    freq.put("Jan", 13);
    freq.put("Re", 51);
    freq.put("Chr", 11);
    freq.put("mbo", 8);
    freq.put("Chu", 3);
    freq.put("Chy", 12);
    freq.put("Jad", 3);
    freq.put("Ro", 75);
    freq.put("Rh", 3);
    freq.put("Ri", 15);
    freq.put("śr", 36);
    freq.put("ór ", 23);
    freq.put("śp", 26);
    freq.put("św", 92);
    freq.put("zał", 83);
    freq.put("śc", 292);
    freq.put("zaś", 4);
    freq.put("śk", 4);
    freq.put("hał", 34);
    freq.put("śm", 111);
    freq.put("śl", 186);
    freq.put("nol", 7);
    freq.put("nom", 14);
    freq.put("non", 4);
    freq.put("noo", 15);
    freq.put("nok", 8);
    freq.put("nog", 16);
    freq.put("orą", 11);
    freq.put("noc", 49);
    freq.put("R ", 31);
    freq.put("noz", 5);
    freq.put("not", 14);
    freq.put("now", 257);
    freq.put("Ja ", 69);
    freq.put("nos", 36);
    freq.put("órc", 7);
    freq.put("óra", 22);
    freq.put("óre", 50);
    freq.put("zać", 21);
    freq.put("órn", 3);
    freq.put("sor", 13);
    freq.put("órz", 21);
    freq.put("óry", 74);
    freq.put("em", 1324);
    freq.put("el", 560);
    freq.put("eo", 38);
    freq.put("en", 1105);
    freq.put("ei", 36);
    freq.put("eh", 32);
    freq.put("ek", 729);
    freq.put("Ró", 5);
    freq.put("ee", 237);
    freq.put("ed", 858);
    freq.put("eg", 870);
    freq.put("ef", 61);
    freq.put("ea", 81);
    freq.put("rl ", 3);
    freq.put("ec", 863);
    freq.put("eb", 430);
    freq.put("ey", 16);
    freq.put("ex", 24);
    freq.put("ez", 403);
    freq.put("eu", 36);
    freq.put("et", 465);
    freq.put("ew", 333);
    freq.put("ev", 38);
    freq.put("ep", 307);
    freq.put("es", 1532);
    freq.put("er", 1486);
    freq.put("eJ", 3);
    freq.put("ższ", 11);
    freq.put("ąść", 3);
    freq.put("lmy", 3);
    freq.put("rlo", 8);
    freq.put("rli", 7);
    freq.put("e ", 8530);
    freq.put("lmi", 17);
    freq.put("lmo", 5);
    freq.put("źć ", 9);
    freq.put("lma", 4);
    freq.put("rls", 3);
    freq.put("Szk", 17);
    freq.put("Szc", 8);
    freq.put("Sza", 4);
    freq.put("Szy", 6);
    freq.put("Szt", 4);
    freq.put("Szu", 5);
    freq.put("zan", 64);
    freq.put("zal", 72);
    freq.put("xi", 7);
    freq.put("zaj", 87);
    freq.put("zak", 46);
    freq.put("órą", 8);
    freq.put("zaf", 7);
    freq.put("zag", 34);
    freq.put("zad", 38);
    freq.put("xa", 4);
    freq.put("zab", 53);
    freq.put("zac", 134);
    freq.put("xd", 167);
    freq.put("xe", 3);
    freq.put("xx", 5);
    freq.put("zaz", 18);
    freq.put("zaw", 122);
    freq.put("xp", 7);
    freq.put("zau", 5);
    freq.put("zar", 98);
    freq.put("zas", 198);
    freq.put("xt", 3);
    freq.put("xu", 4);
    freq.put("wcó", 8);
    freq.put("noć", 3);
    freq.put("xD", 293);
    freq.put("xP", 3);
    freq.put("pny", 12);
    freq.put("x ", 48);
    freq.put("za ", 402);
    freq.put("pni", 34);
    freq.put("ść", 174);
    freq.put("pna", 4);
    freq.put("pne", 16);
    freq.put("noś", 71);
    freq.put("eż", 240);
    freq.put("eź", 33);
    freq.put("zgł", 6);
    freq.put("ąś ", 7);
    freq.put("Pho", 8);
    freq.put("wcy", 4);
    freq.put("eń", 102);
    freq.put("wcz", 95);
    freq.put("eł", 61);
    freq.put("wca", 18);
    freq.put("wce", 7);
    freq.put("eś", 277);
    freq.put("wci", 20);
    freq.put("wch", 10);
    freq.put("Off", 3);
    freq.put("ąż ", 9);
    freq.put("eć", 101);
    freq.put("Ucz", 3);
    freq.put("mro", 5);
    freq.put("Uck", 3);
    freq.put("mra", 3);
    freq.put("Web", 6);
    freq.put("Wee", 4);
    freq.put("Wej", 3);
    freq.put("Wen", 3);
    freq.put("Wes", 8);
    freq.put(" p ", 28);
    freq.put("ojn", 28);
    freq.put(" ps", 23);
    freq.put(" pr", 1075);
    freq.put(" pp", 5);
    freq.put(" pu", 52);
    freq.put(" pt", 4);
    freq.put("Kró", 9);
    freq.put(" py", 36);
    freq.put(" px", 4);
    freq.put("hh ", 21);
    freq.put(" pa", 222);
    freq.put(" pf", 9);
    freq.put(" pe", 117);
    freq.put(" pk", 6);
    freq.put(" pi", 343);
    freq.put(" ph", 10);
    freq.put(" po", 1401);
    freq.put(" pl", 118);
    freq.put("IĘ ", 8);
    freq.put(" Mł", 6);
    freq.put("yty", 24);
    freq.put("ytu", 52);
    freq.put("ytr", 14);
    freq.put("yto", 11);
    freq.put("ytk", 16);
    freq.put("yte", 9);
    freq.put("jta", 6);
    freq.put("yta", 141);
    freq.put(" pó", 54);
    freq.put("LD ", 15);
    freq.put("Kro", 3);
    freq.put("Kra", 27);
    freq.put(" Mę", 3);
    freq.put("gwa", 8);
    freq.put("EM ", 7);
    freq.put("gwi", 18);
    freq.put("yłą", 13);
    freq.put("yt ", 23);
    freq.put("ii", 91);
    freq.put("ei ", 5);
    freq.put(" Mó", 11);
    freq.put("ik", 330);
    freq.put("eis", 3);
    freq.put(" pł", 68);
    freq.put("eic", 3);
    freq.put("eig", 3);
    freq.put("eik", 4);
    freq.put("ein", 9);
    freq.put("asó", 5);
    freq.put("yh", 7);
    freq.put("ać ", 462);
    freq.put("yj", 186);
    freq.put("ór", 232);
    freq.put("cec", 3);
    freq.put("rwe", 7);
    freq.put(" Me", 43);
    freq.put(" Ma", 192);
    freq.put(" Mc", 3);
    freq.put(" Mn", 11);
    freq.put(" Mo", 77);
    freq.put(" Mi", 101);
    freq.put(" Mu", 27);
    freq.put(" Mr", 7);
    freq.put("cen", 45);
    freq.put(" My", 10);
    freq.put("yb", 277);
    freq.put("ytę", 7);
    freq.put("cek", 3);
    freq.put("ete", 22);
    freq.put("cej", 50);
    freq.put("yf", 18);
    freq.put(" M ", 4);
    freq.put("odj", 4);
    freq.put("cet", 6);
    freq.put("cer", 44);
    freq.put("iłk", 20);
    freq.put("iło", 51);
    freq.put("iła", 119);
    freq.put("ps ", 7);
    freq.put("iłe", 32);
    freq.put("iły", 17);
    freq.put("yp", 125);
    freq.put("loś", 3);
    freq.put("jaś", 4);
    freq.put("cm", 5);
    freq.put("ami", 245);
    freq.put("psk", 10);
    freq.put("amk", 21);
    freq.put("psi", 3);
    freq.put("amo", 73);
    freq.put("ił ", 87);
    freq.put("amb", 6);
    freq.put("ame", 44);
    freq.put("Rad", 23);
    freq.put("pse", 9);
    freq.put("psz", 67);
    freq.put("psy", 9);
    freq.put("amp", 24);
    freq.put("ams", 12);
    freq.put("amr", 3);
    freq.put("amu", 16);
    freq.put("amt", 9);
    freq.put("pst", 3);
    freq.put("psu", 7);
    freq.put("ók", 4);
    freq.put("cy", 321);
    freq.put("t", 9941);
    freq.put("td ", 4);
    freq.put("dz ", 19);
    freq.put("cp", 4);
    freq.put("ót ", 4);
    freq.put("cw", 3);
    freq.put("cu", 94);
    freq.put("ct", 23);
    freq.put("psó", 4);
    freq.put("amó", 5);
    freq.put("dza", 46);
    freq.put("wóc", 13);
    freq.put("sra", 5);
    freq.put("dze", 79);
    freq.put("wód", 9);
    freq.put("sre", 3);
    freq.put("dzi", 1571);
    freq.put("dzk", 9);
    freq.put("wój", 32);
    freq.put("sro", 5);
    freq.put("dzo", 77);
    freq.put("ótk", 11);
    freq.put("wór", 15);
    freq.put("dzw", 13);
    freq.put("dzy", 36);
    freq.put("wóz", 5);
    freq.put("Gmi", 3);
    freq.put("Ada", 7);
    freq.put("lob", 3);
    freq.put("loc", 8);
    freq.put("loa", 3);
    freq.put("lof", 3);
    freq.put("log", 69);
    freq.put("lod", 19);
    freq.put("lok", 15);
    freq.put("amą", 6);
    freq.put("loo", 4);
    freq.put("lol", 36);
    freq.put("lom", 3);
    freq.put("lor", 20);
    freq.put("los", 17);
    freq.put("lop", 10);
    freq.put("low", 73);
    freq.put("lot", 26);
    freq.put("loz", 8);
    freq.put("J", 532);
    freq.put("Muz", 3);
    freq.put("lo ", 46);
    freq.put("iłę", 6);
    freq.put("dzą", 31);
    freq.put("Esc", 3);
    freq.put("dzę", 64);
    freq.put(" sa", 170);
    freq.put("Lad", 3);
    freq.put("yob", 8);
    freq.put("Lab", 4);
    freq.put("Lat", 4);
    freq.put("you", 6);
    freq.put("Las", 8);
    freq.put("aws", 72);
    freq.put("Brz", 3);
    freq.put("Bru", 4);
    freq.put("Bro", 10);
    freq.put("Bra", 13);
    freq.put("mp ", 13);
    freq.put("Zło", 4);
    freq.put("osz", 142);
    freq.put("oss", 7);
    freq.put("Są", 5);
    freq.put("mpe", 21);
    freq.put(" ró", 38);
    freq.put("mpa", 31);
    freq.put("mpo", 4);
    freq.put("mpl", 19);
    freq.put("mpk", 3);
    freq.put("mpi", 21);
    freq.put("mpu", 16);
    freq.put("mpr", 13);
    freq.put("ęp ", 9);
    freq.put("Sł", 19);
    freq.put("ass", 10);
    freq.put("Wgl", 4);
    freq.put(" r ", 11);
    freq.put("asu", 32);
    freq.put("fę", 4);
    freq.put(" ru", 24);
    freq.put(" ry", 28);
    freq.put(" rz", 77);
    freq.put(" re", 124);
    freq.put(" ra", 251);
    freq.put("egł", 15);
    freq.put(" ro", 362);
    freq.put(" ri", 6);
    freq.put("ask", 34);
    freq.put("S ", 71);
    freq.put("jrz", 53);
    freq.put("ojr", 6);
    freq.put("pus", 32);
    freq.put("Sz", 48);
    freq.put("Sy", 17);
    freq.put("Zdz", 4);
    freq.put("Sq", 3);
    freq.put("Sp", 75);
    freq.put("Sw", 6);
    freq.put("Su", 23);
    freq.put("Zdr", 6);
    freq.put("FC ", 11);
    freq.put("Si", 36);
    freq.put("Sh", 19);
    freq.put("So", 28);
    freq.put("Sn", 3);
    freq.put("Sm", 13);
    freq.put("Sl", 10);
    freq.put("Sc", 8);
    freq.put("fé", 3);
    freq.put("Sa", 33);
    freq.put("Zda", 4);
    freq.put("Se", 56);
    freq.put("egó", 10);
    freq.put("EK ", 3);
    freq.put("pł", 91);
    freq.put("f ", 45);
    freq.put("hha", 23);
    freq.put("hhh", 15);
    freq.put("ąży", 11);
    freq.put(" rę", 13);
    freq.put(" rą", 4);
    freq.put("ążk", 15);
    freq.put("eg ", 10);
    freq.put("ąże", 6);
    freq.put("fr", 39);
    freq.put("fs", 3);
    freq.put("ft", 10);
    freq.put("fu", 26);
    freq.put("fy", 8);
    freq.put("Któ", 4);
    freq.put("fa", 181);
    freq.put("fb", 4);
    freq.put("fc", 3);
    freq.put("fe", 79);
    freq.put("ff", 41);
    freq.put("fg", 4);
    freq.put("fi", 186);
    freq.put("fk", 3);
    freq.put("fl", 9);
    freq.put("fm", 4);
    freq.put("fn", 5);
    freq.put("fo", 161);
    freq.put("a", 25533);
    freq.put("egz", 4);
    freq.put("egr", 21);
    freq.put("egu", 14);
    freq.put("egi", 20);
    freq.put("ego", 712);
    freq.put("egn", 6);
    freq.put("egl", 11);
    freq.put("ega", 39);
    freq.put("CA ", 3);
    freq.put("ege", 4);
    freq.put("rw ", 11);
    freq.put("stą", 12);
    freq.put("ce ", 291);
    freq.put("y ", 3101);
    freq.put("fff", 18);
    freq.put("ffe", 3);
    freq.put("stę", 63);
    freq.put(" On", 22);
    freq.put(" Oo", 6);
    freq.put(" Ol", 12);
    freq.put(" Oj", 11);
    freq.put(" Ok", 21);
    freq.put(" Oh", 3);
    freq.put(" Of", 4);
    freq.put(" Og", 14);
    freq.put(" Od", 32);
    freq.put(" Ob", 24);
    freq.put(" Oc", 10);
    freq.put(" Ow", 5);
    freq.put(" Ot", 12);
    freq.put(" Or", 10);
    freq.put(" Os", 16);
    freq.put(" Op", 20);
    freq.put("ceg", 10);
    freq.put("rwa", 100);
    freq.put("yk", 253);
    freq.put("ced", 4);
    freq.put("ym", 683);
    freq.put("ceb", 18);
    freq.put("yo", 17);
    freq.put("yn", 267);
    freq.put("ya", 13);
    freq.put("rwi", 44);
    freq.put("cem", 16);
    freq.put("cel", 20);
    freq.put("ye", 12);
    freq.put("yd", 142);
    freq.put("yg", 139);
    freq.put("rwo", 15);
    freq.put("yy", 32);
    freq.put("ceu", 5);
    freq.put("yz", 63);
    freq.put("ces", 38);
    freq.put("rwu", 4);
    freq.put("cep", 12);
    freq.put("rwy", 7);
    freq.put("ys", 568);
    freq.put("yr", 41);
    freq.put("yu", 5);
    freq.put("yt", 307);
    freq.put("yw", 251);
    freq.put("ff ", 12);
    freq.put("MI ", 6);
    freq.put(" O ", 87);
    freq.put("ifi", 4);
    freq.put("liń", 3);
    freq.put(" Ży", 11);
    freq.put("Ene", 6);
    freq.put("lił", 29);
    freq.put("pu ", 21);
    freq.put("łaś", 155);
    freq.put("as ", 186);
    freq.put("liś", 47);
    freq.put("kać", 28);
    freq.put("liż", 17);
    freq.put("pul", 5);
    freq.put("lią", 3);
    freq.put("pun", 7);
    freq.put("lić", 24);
    freq.put("puj", 13);
    freq.put("ast", 137);
    freq.put("pud", 4);
    freq.put("asz", 299);
    freq.put("asy", 40);
    freq.put("pub", 19);
    freq.put("puc", 5);
    freq.put("asc", 5);
    freq.put("asa", 63);
    freq.put("ase", 30);
    freq.put("put", 14);
    freq.put("asi", 36);
    freq.put("ash", 4);
    freq.put("aso", 11);
    freq.put("asn", 59);
    freq.put("każ", 39);
    freq.put("kał", 23);
    freq.put("kań", 6);
    freq.put("KS ", 6);
    freq.put("kaś", 22);
    freq.put("Cli", 3);
    freq.put("tf ", 5);
    freq.put("st ", 473);
    freq.put("rwą", 3);
    freq.put("yć", 172);
    freq.put("rwę", 3);
    freq.put("Im ", 3);
    freq.put("tfo", 11);
    freq.put("ncu", 11);
    freq.put("nch", 9);
    freq.put("nci", 22);
    freq.put("ncj", 28);
    freq.put("yż", 33);
    freq.put("nco", 3);
    freq.put("nca", 5);
    freq.put("nce", 54);
    freq.put("ste", 289);
    freq.put("sta", 474);
    freq.put("stl", 3);
    freq.put("stm", 5);
    freq.put("stn", 22);
    freq.put("sto", 116);
    freq.put("sti", 53);
    freq.put("stk", 143);
    freq.put("stu", 44);
    freq.put("yś", 191);
    freq.put("stw", 74);
    freq.put("str", 231);
    freq.put("sts", 4);
    freq.put("sty", 97);
    freq.put("Gol", 4);
    freq.put("Goo", 12);
    freq.put("ka ", 540);
    freq.put("ncy", 3);
    freq.put("ncz", 19);
    freq.put("Got", 5);
    freq.put("lid", 10);
    freq.put("Nik", 5);
    freq.put("lif", 5);
    freq.put("lig", 13);
    freq.put("lia", 15);
    freq.put("lib", 13);
    freq.put("lic", 121);
    freq.put("Nib", 6);
    freq.put("Nic", 11);
    freq.put("lin", 78);
    freq.put("lio", 20);
    freq.put("Nig", 3);
    freq.put("lij", 7);
    freq.put("Nie", 211);
    freq.put("lit", 36);
    freq.put("liv", 17);
    freq.put("liw", 37);
    freq.put("lip", 19);
    freq.put("lis", 87);
    freq.put("liz", 36);
    freq.put("kac", 94);
    freq.put("kab", 4);
    freq.put("kad", 20);
    freq.put("kak", 13);
    freq.put("kaj", 17);
    freq.put("kan", 62);
    freq.put("kam", 88);
    freq.put("kal", 22);
    freq.put("kas", 35);
    freq.put("kar", 89);
    freq.put("kap", 10);
    freq.put("kaw", 87);
    freq.put("kat", 23);
    freq.put("kaz", 66);
    freq.put("The", 16);
    freq.put("wyl", 6);
    freq.put("li ", 331);
    freq.put("puł", 3);
    freq.put("asł", 14);
    freq.put("stó", 7);
    freq.put("ZA ", 3);
    freq.put("ymp", 4);
    freq.put("ymu", 8);
    freq.put(" tę", 12);
    freq.put("ymy", 29);
    freq.put("Wał", 6);
    freq.put("yma", 58);
    freq.put("ymc", 3);
    freq.put("ymb", 6);
    freq.put("ymi", 58);
    freq.put(" tą", 24);
    freq.put("ox ", 5);
    freq.put("ymo", 6);
    freq.put("ym ", 493);
    freq.put("x", 567);
    freq.put(" tł", 12);
    freq.put("ył", 347);
    freq.put("yń", 26);
    freq.put("woz", 4);
    freq.put("wot", 5);
    freq.put("wow", 20);
    freq.put("wos", 8);
    freq.put("wor", 31);
    freq.put("wom", 3);
    freq.put("wol", 72);
    freq.put("woo", 6);
    freq.put("won", 24);
    freq.put("woi", 35);
    freq.put("wok", 10);
    freq.put("woj", 90);
    freq.put("wod", 49);
    freq.put("wog", 3);
    freq.put("woc", 9);
    freq.put("wob", 3);
    freq.put("Mn", 11);
    freq.put("Obe", 7);
    freq.put("Oby", 3);
    freq.put("Obr", 4);
    freq.put("iść", 30);
    freq.put("wo ", 96);
    freq.put("Wan", 4);
    freq.put("Wam", 10);
    freq.put("Wal", 8);
    freq.put("Wak", 3);
    freq.put("ymś", 4);
    freq.put("gme", 7);
    freq.put("Waw", 4);
    freq.put("ady", 27);
    freq.put("Was", 15);
    freq.put("War", 40);
    freq.put(" t ", 9);
    freq.put("ydr", 3);
    freq.put(" tz", 10);
    freq.put(" ty", 486);
    freq.put(" tw", 108);
    freq.put(" tv", 12);
    freq.put(" tu", 75);
    freq.put(" tt", 16);
    freq.put(" tr", 254);
    freq.put("N", 652);
    freq.put(" to", 1067);
    freq.put(" tn", 4);
    freq.put(" tl", 4);
    freq.put(" tk", 3);
    freq.put(" ti", 5);
    freq.put(" th", 17);
    freq.put(" te", 715);
    freq.put(" ta", 661);
    freq.put("jpi", 13);
    freq.put("woś", 23);
    freq.put("bą ", 21);
    freq.put("iśm", 32);
    freq.put("iśl", 3);
    freq.put("nós", 4);
    freq.put("nów", 56);
    freq.put("boi", 10);
    freq.put("boj", 16);
    freq.put("mał", 56);
    freq.put("iś ", 97);
    freq.put("lie", 33);
    freq.put("lil", 5);
    freq.put("lim", 19);
    freq.put("lii", 7);
    freq.put("żu", 7);
    freq.put("utę", 3);
    freq.put("ee ", 46);
    freq.put("tut", 15);
    freq.put("eez", 3);
    freq.put("eet", 25);
    freq.put("eep", 3);
    freq.put("eem", 6);
    freq.put("een", 8);
    freq.put("eek", 23);
    freq.put("eej", 9);
    freq.put("eee", 91);
    freq.put("eed", 10);
    freq.put("eeb", 3);
    freq.put("nał", 38);
    freq.put("nań", 4);
    freq.put("ru ", 25);
    freq.put("ld ", 13);
    freq.put("naś", 3);
    freq.put("tłu", 13);
    freq.put("tła", 4);
    freq.put("id ", 11);
    freq.put("ruj", 14);
    freq.put("ruk", 12);
    freq.put("run", 23);
    freq.put("nać", 15);
    freq.put("rum", 20);
    freq.put("rub", 9);
    freq.put("ruc", 11);
    freq.put("rug", 43);
    freq.put("rud", 33);
    freq.put("rue", 3);
    freq.put("ruz", 6);
    freq.put("rus", 22);
    freq.put("rup", 22);
    freq.put("rut", 7);
    freq.put("idz", 150);
    freq.put("ido", 18);
    freq.put("idl", 5);
    freq.put("idi", 12);
    freq.put("ide", 46);
    freq.put("Aż", 3);
    freq.put("ida", 26);
    freq.put("Eli", 4);
    freq.put("oha", 6);
    freq.put("ut ", 30);
    freq.put("kus", 7);
    freq.put("Fan", 5);
    freq.put("rws", 71);
    freq.put("utb", 3);
    freq.put("tum", 3);
    freq.put("uta", 24);
    freq.put("ute", 32);
    freq.put("utk", 13);
    freq.put("uti", 5);
    freq.put("utn", 6);
    freq.put("uto", 39);
    freq.put("utr", 98);
    freq.put("utw", 3);
    freq.put("utu", 6);
    freq.put("uty", 25);
    freq.put("KU ", 3);
    freq.put("tun", 9);
    freq.put("Ty", 69);
    freq.put("Tw", 43);
    freq.put("Tu", 29);
    freq.put("Tr", 47);
    freq.put("Ts", 3);
    freq.put("To", 154);
    freq.put("Th", 17);
    freq.put("Ti", 10);
    freq.put("idą", 3);
    freq.put("Ta", 84);
    freq.put("nab", 11);
    freq.put("A ", 291);
    freq.put("naa", 5);
    freq.put("Bel", 21);
    freq.put("nad", 127);
    freq.put("naj", 224);
    freq.put("nak", 43);
    freq.put("nan", 49);
    freq.put("nal", 75);
    freq.put("nam", 89);
    freq.put("nar", 41);
    freq.put("nas", 149);
    freq.put("nap", 112);
    freq.put("naw", 107);
    freq.put("nat", 14);
    freq.put("nau", 38);
    freq.put("naz", 29);
    freq.put("puś", 6);
    freq.put("ruż", 7);
    freq.put("T ", 95);
    freq.put("adó", 5);
    freq.put("Aa", 4);
    freq.put("idż", 4);
    freq.put("Ab", 4);
    freq.put("idź", 3);
    freq.put("Ad", 13);
    freq.put("Ag", 5);
    freq.put("Af", 4);
    freq.put("Ah", 12);
    freq.put("Ak", 9);
    freq.put("Am", 7);
    freq.put("Al", 100);
    freq.put("ruń", 3);
    freq.put("An", 60);
    freq.put("ruś", 3);
    freq.put("As", 7);
    freq.put("Ar", 23);
    freq.put("Au", 11);
    freq.put("At", 4);
    freq.put("Aw", 7);
    freq.put("Av", 3);
    freq.put("Az", 5);
    freq.put("pił", 37);
    freq.put("snó", 5);
    freq.put("gw", 27);
    freq.put("gu", 88);
    freq.put("gt", 3);
    freq.put("gs", 4);
    freq.put("gr", 309);
    freq.put("życ", 68);
    freq.put("żyn", 9);
    freq.put("gz", 5);
    freq.put("żyj", 17);
    freq.put("gg", 8);
    freq.put("Ber", 8);
    freq.put("ge", 106);
    freq.put("gd", 132);
    freq.put("ąc", 215);
    freq.put("ga", 309);
    freq.put("żys", 4);
    freq.put("go", 1091);
    freq.put("gn", 62);
    freq.put("gm", 15);
    freq.put("gl", 217);
    freq.put("gi", 214);
    freq.put("zó", 17);
    freq.put("lko", 175);
    freq.put("wił", 52);
    freq.put("Nok", 7);
    freq.put("lka", 43);
    freq.put("Now", 57);
    freq.put("wiś", 30);
    freq.put("kce", 11);
    freq.put("ży ", 36);
    freq.put("kci", 22);
    freq.put("kcj", 70);
    freq.put("g ", 148);
    freq.put("kcy", 5);
    freq.put("wić", 34);
    freq.put("hi ", 3);
    freq.put("wią", 41);
    freq.put("Spr", 23);
    freq.put("No ", 70);
    freq.put("ąp", 6);
    freq.put("Spi", 10);
    freq.put("esi", 59);
    freq.put("Spo", 21);
    freq.put("Spa", 10);
    freq.put("Spe", 7);
    freq.put("wię", 129);
    freq.put("zl", 48);
    freq.put("zm", 136);
    freq.put("zn", 591);
    freq.put("zo", 393);
    freq.put("gó", 73);
    freq.put("zi", 1775);
    freq.put("zj", 67);
    freq.put("zk", 262);
    freq.put("zd", 252);
    freq.put("ze", 2360);
    freq.put("zg", 60);
    freq.put("za", 1788);
    freq.put("zb", 60);
    freq.put("zc", 336);
    freq.put("zy", 1886);
    freq.put("zz", 9);
    freq.put("zt", 72);
    freq.put("zu", 297);
    freq.put("zw", 188);
    freq.put("zp", 75);
    freq.put("zr", 118);
    freq.put("zs", 18);
    freq.put("ycz", 130);
    freq.put("ycy", 12);
    freq.put("yck", 3);
    freq.put("ycj", 23);
    freq.put("yci", 114);
    freq.put("ych", 333);
    freq.put("yce", 10);
    freq.put("ozg", 10);
    freq.put("agł", 6);
    freq.put("oze", 37);
    freq.put("ozb", 10);
    freq.put("oza", 23);
    freq.put("ozn", 58);
    freq.put("ozo", 13);
    freq.put("ozl", 4);
    freq.put("ozm", 26);
    freq.put("z ", 1815);
    freq.put("ozk", 13);
    freq.put("ozi", 11);
    freq.put("ozw", 25);
    freq.put("ozu", 40);
    freq.put("ozr", 5);
    freq.put("ozs", 9);
    freq.put("ozp", 32);
    freq.put("ozy", 22);
    freq.put("Aha", 7);
    freq.put("Ahh", 3);
    freq.put("iep", 49);
    freq.put("yc ", 27);
    freq.put("wie", 791);
    freq.put("wid", 151);
    freq.put("wic", 68);
    freq.put("wia", 289);
    freq.put("wio", 22);
    freq.put("win", 65);
    freq.put("wim", 3);
    freq.put("wil", 43);
    freq.put("wij", 8);
    freq.put("IA ", 14);
    freq.put("wit", 58);
    freq.put("wis", 54);
    freq.put("wir", 8);
    freq.put("wiz", 32);
    freq.put("żył", 12);
    freq.put("Jo", 35);
    freq.put("gł", 181);
    freq.put("iem", 368);
    freq.put("wi ", 76);
    freq.put("lką", 5);
    freq.put("lkę", 6);
    freq.put("Sch", 5);
    freq.put("źwi", 4);
    freq.put("żyć", 13);
    freq.put("źwa", 3);
    freq.put("swo", 69);
    freq.put("gę", 58);
    freq.put("Ja", 217);
    freq.put("gą", 20);
    freq.put("Wcz", 7);
    freq.put("pią", 26);
    freq.put("cd ", 3);
    freq.put("sę ", 7);
    freq.put(" ve", 3);
    freq.put(" vi", 23);
    freq.put(" vo", 6);
    freq.put("śla", 38);
    freq.put("zą", 183);
    freq.put("zę", 345);
    freq.put("TO ", 14);
    freq.put("jny", 43);
    freq.put("jna", 17);
    freq.put("jne", 48);
    freq.put(" Sł", 19);
    freq.put("jni", 55);
    freq.put("jno", 14);
    freq.put("RA ", 6);
    freq.put("óża", 3);
    freq.put(" Są", 5);
    freq.put("ec ", 84);
    freq.put("mar", 84);
    freq.put("hli", 3);
    freq.put("urę", 6);
    freq.put("ków", 80);
    freq.put("maw", 21);
    freq.put("awę", 8);
    freq.put("kór", 5);
    freq.put("max", 6);
    freq.put("kój", 6);
    freq.put("ece", 24);
    freq.put("eca", 34);
    freq.put("CE ", 5);
    freq.put("eco", 6);
    freq.put("ecn", 17);
    freq.put("eck", 52);
    freq.put("ecj", 15);
    freq.put("eci", 201);
    freq.put("ech", 136);
    freq.put("ecu", 3);
    freq.put("ect", 5);
    freq.put("ecz", 228);
    freq.put("ecy", 39);
    freq.put("OC ", 4);
    freq.put("yro", 11);
    freq.put("rs ", 25);
    freq.put("cy ", 187);
    freq.put(" Sz", 48);
    freq.put(" Sy", 17);
    freq.put("be ", 15);
    freq.put(" Sq", 3);
    freq.put(" Sw", 6);
    freq.put(" St", 79);
    freq.put(" Su", 22);
    freq.put(" Sk", 21);
    freq.put(" Sh", 17);
    freq.put(" Si", 36);
    freq.put(" Sn", 3);
    freq.put(" So", 26);
    freq.put(" Sl", 9);
    freq.put(" Sm", 13);
    freq.put(" Sc", 8);
    freq.put(" Sa", 31);
    freq.put(" Se", 55);
    freq.put("cyr", 3);
    freq.put("rso", 12);
    freq.put("rsi", 7);
    freq.put("rsj", 15);
    freq.put("rsk", 29);
    freq.put("rse", 12);
    freq.put("rsa", 3);
    freq.put("cyc", 18);
    freq.put("R", 310);
    freq.put("rsy", 6);
    freq.put("rsz", 66);
    freq.put("cyd", 26);
    freq.put("rst", 13);
    freq.put("rsu", 8);
    freq.put("cyn", 6);
    freq.put("cym", 9);
    freq.put("bej", 32);
    freq.put("bek", 7);
    freq.put("ben", 4);
    freq.put("bel", 17);
    freq.put("bec", 20);
    freq.put("bed", 51);
    freq.put("bez", 91);
    freq.put("AL ", 4);
    freq.put("jną", 5);
    freq.put("ber", 48);
    freq.put(" S ", 6);
    freq.put("ż", 2076);
    freq.put("bet", 6);
    freq.put("ydł", 7);
    freq.put("ińs", 18);
    freq.put("kół", 6);
    freq.put("py ", 25);
    freq.put("aw ", 31);
    freq.put("ecą", 7);
    freq.put("ur ", 19);
    freq.put("el ", 39);
    freq.put("arm", 13);
    freq.put("ecę", 6);
    freq.put("BA ", 8);
    freq.put("awy", 35);
    freq.put("aww", 6);
    freq.put("awu", 3);
    freq.put("pys", 4);
    freq.put("Ej ", 7);
    freq.put("awo", 35);
    freq.put("awn", 36);
    freq.put("awk", 15);
    freq.put("but", 14);
    freq.put("awi", 285);
    freq.put("awe", 118);
    freq.put("awd", 99);
    freq.put("awc", 12);
    freq.put("ny ", 430);
    freq.put("awa", 118);
    freq.put("rsó", 9);
    freq.put("urd", 27);
    freq.put("ure", 6);
    freq.put("urg", 8);
    freq.put("ura", 81);
    freq.put("urc", 6);
    freq.put("url", 3);
    freq.put("urn", 21);
    freq.put("uro", 66);
    freq.put("uri", 5);
    freq.put("urk", 4);
    freq.put("urt", 3);
    freq.put("uru", 5);
    freq.put("urw", 71);
    freq.put("urs", 28);
    freq.put("ury", 19);
    freq.put("urz", 44);
    freq.put("Ian", 3);
    freq.put("ksy", 7);
    freq.put("iąz", 25);
    freq.put("nge", 15);
    freq.put("nga", 4);
    freq.put("ngl", 12);
    freq.put("ngo", 8);
    freq.put("ngi", 24);
    freq.put("sh ", 9);
    freq.put("ngu", 5);
    freq.put("dp ", 4);
    freq.put("ój ", 84);
    freq.put("Pla", 13);
    freq.put("tbo", 3);
    freq.put("tba", 3);
    freq.put("dpu", 4);
    freq.put("ng ", 37);
    freq.put("ójs", 3);
    freq.put("sha", 4);
    freq.put("dpa", 4);
    freq.put("dpo", 33);
    freq.put("shi", 8);
    freq.put("ójd", 18);
    freq.put("sho", 7);
    freq.put("zyć", 69);
    freq.put("ke ", 42);
    freq.put("iąc", 25);
    freq.put("lup", 4);
    freq.put("lus", 13);
    freq.put("lut", 14);
    freq.put("yć ", 168);
    freq.put("luz", 10);
    freq.put("lub", 107);
    freq.put("luc", 15);
    freq.put("lud", 64);
    freq.put("rzę", 31);
    freq.put("lug", 5);
    freq.put("luj", 17);
    freq.put("luk", 3);
    freq.put("lul", 3);
    freq.put("lum", 6);
    freq.put("ken", 23);
    freq.put("zyń", 20);
    freq.put("kel", 5);
    freq.put("zył", 81);
    freq.put("kej", 16);
    freq.put("Dzi", 82);
    freq.put("ięć", 15);
    freq.put("key", 4);
    freq.put("ker", 11);
    freq.put("Cha", 12);
    freq.put("wkę", 9);
    freq.put("zyż", 13);
    freq.put("ot ", 27);
    freq.put(" al", 469);
    freq.put("Lon", 6);
    freq.put("Lol", 6);
    freq.put("Lov", 3);
    freq.put("Lot", 4);
    freq.put("Lou", 4);
    freq.put("iżs", 6);
    freq.put("iże", 10);
    freq.put("iża", 3);
    freq.put("oth", 7);
    freq.put(" Ps", 3);
    freq.put("otk", 56);
    freq.put("otn", 35);
    freq.put("oto", 46);
    freq.put("pid", 5);
    freq.put("ote", 83);
    freq.put(" żo", 11);
    freq.put("otr", 67);
    freq.put("ott", 13);
    freq.put("otu", 12);
    freq.put("otw", 31);
    freq.put("And", 23);
    freq.put("mgł", 3);
    freq.put("Ang", 7);
    freq.put("Ann", 3);
    freq.put("Ano", 4);
    freq.put("Ani", 10);
    freq.put("Ant", 4);
    freq.put("iż ", 37);
    freq.put(" Py", 4);
    freq.put("wki", 19);
    freq.put("wkl", 3);
    freq.put("wko", 8);
    freq.put("wka", 22);
    freq.put("wke", 5);
    freq.put(" ją", 17);
    freq.put("You", 12);
    freq.put("wkr", 6);
    freq.put("wku", 21);
    freq.put("zy ", 509);
    freq.put("krą", 3);
    freq.put("otó", 9);
    freq.put("zyg", 16);
    freq.put("zyd", 33);
    freq.put("rią", 3);
    freq.put("zyb", 34);
    freq.put("zyc", 106);
    freq.put("zyn", 111);
    freq.put("zyl", 71);
    freq.put("zym", 147);
    freq.put("zyj", 66);
    freq.put("zyk", 89);
    freq.put("ksi", 33);
    freq.put("zyw", 77);
    freq.put("zyt", 103);
    freq.put("zys", 257);
    freq.put("zyp", 43);
    freq.put("zyz", 23);
    freq.put(" xD", 293);
    freq.put(" xP", 3);
    freq.put("Be", 57);
    freq.put("hę", 54);
    freq.put("Ba", 53);
    freq.put("Bl", 18);
    freq.put("Bo", 66);
    freq.put("Bi", 68);
    freq.put(" xd", 166);
    freq.put("Bu", 21);
    freq.put(" xx", 3);
    freq.put("Br", 33);
    freq.put("By", 25);
    freq.put("B ", 38);
    freq.put(" x ", 12);
    freq.put("hł", 22);
    freq.put("jle", 47);
    freq.put("jla", 3);
    freq.put("hnę", 3);
    freq.put("oną", 9);
    freq.put("U ", 28);
    freq.put(" Uż", 5);
    freq.put("zą ", 79);
    freq.put("swi", 14);
    freq.put("Uw", 8);
    freq.put("pp", 42);
    freq.put("Us", 5);
    freq.put("Ur", 7);
    freq.put("Ul", 5);
    freq.put("cła", 5);
    freq.put("Uk", 4);
    freq.put("amy", 127);
    freq.put("LL ", 6);
    freq.put("Uc", 6);
    freq.put("ież", 45);
    freq.put("ząc", 26);
    freq.put("pt", 40);
    freq.put("ząd", 39);
    freq.put("ząt", 18);
    freq.put("duc", 6);
    freq.put("ea ", 6);
    freq.put("Dla", 12);
    freq.put("h ", 823);
    freq.put("mię", 71);
    freq.put("eah", 5);
    freq.put("eak", 8);
    freq.put("hy", 146);
    freq.put("eam", 8);
    freq.put("eal", 20);
    freq.put("ean", 6);
    freq.put("hr", 28);
    freq.put("ead", 6);
    freq.put("eag", 6);
    freq.put("hu", 78);
    freq.put("hh", 62);
    freq.put("hi", 69);
    freq.put("hn", 24);
    freq.put("ho", 349);
    freq.put("hl", 8);
    freq.put("hm", 29);
    freq.put("hc", 223);
    freq.put("eas", 3);
    freq.put("ha", 920);
    freq.put("hf", 3);
    freq.put("ph", 21);
    freq.put("hd", 7);
    freq.put("he", 138);
    freq.put("dma", 7);
    freq.put("dus", 14);
    freq.put("dmi", 10);
    freq.put("ząć", 8);
    freq.put(" Uw", 8);
    freq.put(" Up", 3);
    freq.put(" Ur", 7);
    freq.put(" Us", 5);
    freq.put(" Ul", 5);
    freq.put(" Un", 12);
    freq.put(" Uk", 4);
    freq.put(" Uc", 5);
    freq.put("zął", 6);
    freq.put("Uż", 5);
    freq.put("hó", 10);
    freq.put("Op", 20);
    freq.put("bch", 11);
    freq.put("bci", 16);
    freq.put("hni", 11);
    freq.put("hno", 6);
    freq.put("mów", 113);
    freq.put("bcz", 4);
    freq.put(" U ", 10);
    freq.put("łe ", 29);
    freq.put("auc", 27);
    freq.put("aud", 6);
    freq.put("aug", 4);
    freq.put("auk", 8);
    freq.put("żeś", 3);
    freq.put("aul", 10);
    freq.put("up ", 11);
    freq.put("aus", 5);
    freq.put("aur", 3);
    freq.put("aut", 33);
    freq.put("auw", 5);
    freq.put("auz", 3);
    freq.put("Joe", 13);
    freq.put("łej", 10);
    freq.put("łek", 17);
    freq.put("łem", 131);
    freq.put("łeb", 3);
    freq.put("łec", 4);
    freq.put("łeg", 18);
    freq.put("móg", 15);
    freq.put("upo", 15);
    freq.put("upk", 7);
    freq.put("upi", 81);
    freq.put("móc", 5);
    freq.put("dró", 13);
    freq.put("upe", 33);
    freq.put("upc", 6);
    freq.put("upa", 18);
    freq.put("upy", 10);
    freq.put("upu", 6);
    freq.put("upr", 3);
    freq.put("ups", 9);
    freq.put("me ", 29);
    freq.put("orz", 72);
    freq.put("nen", 7);
    freq.put("nel", 6);
    freq.put("nem", 33);
    freq.put("nej", 86);
    freq.put("nek", 37);
    freq.put("Puk", 3);
    freq.put("esn", 12);
    freq.put("nec", 27);
    freq.put("ney", 5);
    freq.put("Put", 3);
    freq.put("new", 9);
    freq.put("net", 64);
    freq.put("ól ", 7);
    freq.put("nes", 8);
    freq.put("Każ", 8);
    freq.put("med", 18);
    freq.put("meg", 14);
    freq.put("mec", 57);
    freq.put("meb", 5);
    freq.put("mem", 5);
    freq.put("mel", 5);
    freq.put("men", 85);
    freq.put("mek", 7);
    freq.put("mej", 8);
    freq.put("met", 20);
    freq.put("mes", 6);
    freq.put("mer", 41);
    freq.put("nką", 11);
    freq.put("dry", 12);
    freq.put("drz", 32);
    freq.put("ólu", 4);
    freq.put("źni", 30);
    freq.put("dru", 53);
    freq.put("ne ", 452);
    freq.put("dri", 5);
    freq.put("óln", 20);
    freq.put("sji", 17);
    freq.put("sjo", 3);
    freq.put("dro", 91);
    freq.put("dra", 33);
    freq.put("óle", 29);
    freq.put("sja", 17);
    freq.put("dre", 9);
    freq.put("upó", 3);
    freq.put("sje", 3);
    freq.put("ęsk", 12);
    freq.put("iśc", 51);
    freq.put("żer", 5);
    freq.put("żes", 12);
    freq.put("żet", 3);
    freq.put("ęsa", 3);
    freq.put("kg ", 6);
    freq.put("żeb", 59);
    freq.put("żec", 4);
    freq.put("żeg", 6);
    freq.put("żej", 23);
    freq.put("żek", 5);
    freq.put("żel", 15);
    freq.put("żem", 14);
    freq.put("żen", 29);
    freq.put("ęst", 12);
    freq.put("źd", 18);
    freq.put("lwi", 18);
    freq.put("pę ", 4);
    freq.put("ora", 131);
    freq.put("Ste", 10);
    freq.put("Sta", 34);
    freq.put("Sto", 7);
    freq.put("że ", 665);
    freq.put("Stu", 3);
    freq.put("Str", 19);
    freq.put("V", 37);
    freq.put("rio", 30);
    freq.put("łeś", 28);
    freq.put("pęd", 8);
    freq.put("Lid", 6);
    freq.put("sję", 11);
    freq.put("Lia", 3);
    freq.put("yga", 9);
    freq.put("ygo", 42);
    freq.put("ygn", 6);
    freq.put("Lin", 3);
    freq.put("ygl", 46);
    freq.put("ygi", 3);
    freq.put("Lik", 3);
    freq.put("Lit", 4);
    freq.put("Liv", 4);
    freq.put("ygr", 28);
    freq.put("Lis", 6);
    freq.put("Kac", 19);
    freq.put("Kab", 3);
    freq.put("źw", 7);
    freq.put("Kan", 8);
    freq.put("Kam", 4);
    freq.put("Kal", 10);
    freq.put("Kar", 11);
    freq.put("Kat", 18);
    freq.put("Kaz", 3);
    freq.put("woł", 14);
    freq.put("ova", 3);
    freq.put("ove", 11);
    freq.put("ovi", 3);
    freq.put("All", 9);
    freq.put("Ale", 78);
    freq.put("Alb", 5);
    freq.put("mnę", 3);
    freq.put("iół", 11);
    freq.put("wuj", 16);
    freq.put("ono", 34);
    freq.put("zw ", 8);
    freq.put("iąg", 56);
    freq.put("ęże", 3);
    freq.put("ężc", 5);
    freq.put("ęża", 8);
    freq.put("bów", 3);
    freq.put("ężk", 10);
    freq.put("bór", 8);
    freq.put("ong", 4);
    freq.put("ból", 7);
    freq.put(" F ", 3);
    freq.put("wu ", 42);
    freq.put("bój", 11);
    freq.put("ęży", 3);
    freq.put("zwi", 42);
    freq.put("osk", 31);
    freq.put("zwo", 32);
    freq.put("isó", 4);
    freq.put("zwa", 38);
    freq.put("zwy", 45);
    freq.put("zwr", 9);
    freq.put("Wor", 3);
    freq.put("Wol", 14);
    freq.put("Woo", 3);
    freq.put("Ile", 4);
    freq.put("Woj", 7);
    freq.put(" zm", 65);
    freq.put(" zl", 20);
    freq.put(" zo", 86);
    freq.put(" zn", 203);
    freq.put(" zi", 27);
    freq.put(" zj", 15);
    freq.put(" ze", 245);
    freq.put(" zd", 143);
    freq.put(" zg", 27);
    freq.put(" za", 980);
    freq.put("Ge", 12);
    freq.put(" zb", 37);
    freq.put("Gd", 29);
    freq.put(" zy", 11);
    freq.put("ont", 77);
    freq.put(" zu", 12);
    freq.put(" zw", 82);
    freq.put("is ", 62);
    freq.put(" zr", 92);
    freq.put("Ga", 31);
    freq.put("doł", 7);
    freq.put("Go", 30);
    freq.put("NY ", 4);
    freq.put("isz", 187);
    freq.put("isy", 14);
    freq.put(" z ", 709);
    freq.put("isu", 12);
    freq.put("ist", 183);
    freq.put("isk", 37);
    freq.put("isj", 9);
    freq.put("isi", 107);
    freq.put("ish", 6);
    freq.put("iso", 5);
    freq.put("isn", 7);
    freq.put("ism", 7);
    freq.put("isc", 16);
    freq.put("isa", 106);
    freq.put("zwó", 5);
    freq.put("ise", 10);
    freq.put("Eur", 25);
    freq.put("on ", 153);
    freq.put("Col", 4);
    freq.put("EC ", 3);
    freq.put("zwł", 5);
    freq.put("ąsk", 9);
    freq.put("LN ", 4);
    freq.put("jj ", 7);
    freq.put(" kt", 239);
    freq.put("ty ", 274);
    freq.put(" Zo", 23);
    freq.put(" zł", 66);
    freq.put("do ", 555);
    freq.put(" Ze", 8);
    freq.put("ęki", 35);
    freq.put("tyl", 184);
    freq.put("tym", 167);
    freq.put("tyn", 19);
    freq.put("tyk", 57);
    freq.put(" zą", 3);
    freq.put(" Za", 121);
    freq.put("tyf", 9);
    freq.put("tyg", 32);
    freq.put("tyc", 127);
    freq.put("CY ", 3);
    freq.put(" zę", 3);
    freq.put("tyy", 3);
    freq.put("tyz", 6);
    freq.put("tyt", 16);
    freq.put("isł", 14);
    freq.put("tyw", 33);
    freq.put("typ", 9);
    freq.put("tyr", 3);
    freq.put("tys", 17);
    freq.put("doj", 10);
    freq.put("dok", 36);
    freq.put("don", 9);
    freq.put("doo", 4);
    freq.put("dol", 61);
    freq.put("dom", 113);
    freq.put("dob", 225);
    freq.put("doc", 15);
    freq.put("m", 9206);
    freq.put("dog", 7);
    freq.put("dod", 43);
    freq.put("doz", 4);
    freq.put("dor", 9);
    freq.put("dos", 85);
    freq.put("dop", 41);
    freq.put("dow", 138);
    freq.put("dot", 16);
    freq.put(" Wg", 4);
    freq.put(" We", 27);
    freq.put(" Wc", 10);
    freq.put(" Wa", 98);
    freq.put(" Wn", 3);
    freq.put(" Wo", 35);
    freq.put(" Wl", 3);
    freq.put(" Wi", 128);
    freq.put(" Wt", 5);
    freq.put(" Wu", 3);
    freq.put(" Wr", 24);
    freq.put(" Ws", 35);
    freq.put(" Wp", 4);
    freq.put(" Wy", 90);
    freq.put("aź ", 3);
    freq.put("kul", 11);
    freq.put("ba ", 230);
    freq.put("kuj", 73);
    freq.put(" W ", 105);
    freq.put("omó", 11);
    freq.put("AW ", 3);
    freq.put("baw", 30);
    freq.put("bat", 13);
    freq.put("bar", 107);
    freq.put("bas", 16);
    freq.put("aźn", 9);
    freq.put("aźd", 12);
    freq.put("bad", 11);
    freq.put("bab", 15);
    freq.put("bac", 68);
    freq.put("baa", 3);
    freq.put("ban", 54);
    freq.put("bal", 10);
    freq.put("bam", 8);
    freq.put("baj", 9);
    freq.put("bak", 3);
    freq.put("hę ", 39);
    freq.put("om ", 61);
    freq.put("iż", 61);
    freq.put("jęt", 8);
    freq.put("ę", 3260);
    freq.put("iś", 217);
    freq.put("Ruc", 7);
    freq.put("un ", 10);
    freq.put("Rus", 5);
    freq.put("ił", 338);
    freq.put("iń", 20);
    freq.put("omc", 4);
    freq.put("omb", 13);
    freq.put("C", 582);
    freq.put("hęc", 5);
    freq.put("omg", 6);
    freq.put("łci", 6);
    freq.put("ome", 86);
    freq.put("omk", 4);
    freq.put("łce", 5);
    freq.put("omi", 77);
    freq.put("omo", 81);
    freq.put("omn", 38);
    freq.put("omm", 5);
    freq.put("omp", 57);
    freq.put("hęt", 7);
    freq.put("łcz", 7);
    freq.put("omy", 42);
    freq.put("kiś", 25);
    freq.put("IS ", 7);
    freq.put(" uś", 14);
    freq.put("una", 6);
    freq.put("und", 18);
    freq.put("une", 13);
    freq.put("ung", 3);
    freq.put("uni", 24);
    freq.put("unk", 27);
    freq.put("ią", 277);
    freq.put("ić", 198);
    freq.put("uno", 4);
    freq.put("nwe", 6);
    freq.put("ió", 26);
    freq.put("bać", 5);
    freq.put("san", 26);
    freq.put(" Wł", 31);
    freq.put("C ", 67);
    freq.put("oć ", 11);
    freq.put("wda", 18);
    freq.put("mca", 3);
    freq.put("bał", 15);
    freq.put("mcz", 5);
    freq.put("mcy", 8);
    freq.put("wde", 8);
    freq.put("źle", 24);
    freq.put("Ci", 157);
    freq.put("Ch", 92);
    freq.put("Co", 68);
    freq.put("Cl", 6);
    freq.put("slu", 10);
    freq.put("Ca", 34);
    freq.put("źli", 7);
    freq.put("Ce", 20);
    freq.put("Cz", 90);
    freq.put("Cy", 5);
    freq.put("slo", 4);
    freq.put("sli", 21);
    freq.put("akr", 21);
    freq.put("sle", 9);
    freq.put("sla", 15);
    freq.put("Cu", 7);
    freq.put("ix", 10);
    freq.put("iz", 127);
    freq.put("Nag", 3);
    freq.put("Nad", 6);
    freq.put("Naj", 19);
    freq.put("ip", 55);
    freq.put("is", 793);
    freq.put("ir", 100);
    freq.put("iu", 183);
    freq.put("it", 240);
    freq.put("iw", 147);
    freq.put("iv", 27);
    freq.put("Nar", 10);
    freq.put("Nas", 13);
    freq.put("Nap", 18);
    freq.put("ij", 84);
    freq.put("im", 337);
    freq.put("uną", 4);
    freq.put("io", 404);
    freq.put("in", 835);
    freq.put("ia", 1832);
    freq.put("ic", 685);
    freq.put("ib", 74);
    freq.put("ie", 8069);
    freq.put("id", 325);
    freq.put("ig", 105);
    freq.put("if", 14);
    freq.put("V ", 21);
    freq.put("hęć", 3);
    freq.put("iP", 10);
    freq.put("iS", 19);
    freq.put("Na ", 50);
    freq.put("kis", 12);
    freq.put("kip", 8);
    freq.put("kiw", 7);
    freq.put("kij", 3);
    freq.put("kin", 19);
    freq.put("kim", 88);
    freq.put("kil", 32);
    freq.put("kic", 49);
    freq.put("i ", 3460);
    freq.put("kia", 4);
    freq.put("kie", 582);
    freq.put("Va", 6);
    freq.put("Ve", 7);
    freq.put("łąc", 38);
    freq.put("orę", 6);
    freq.put("łąd", 7);
    freq.put("Vo", 6);
    freq.put("yea", 5);
    freq.put("ną ", 95);
    freq.put("op ", 17);
    freq.put("ax ", 9);
    freq.put("opt", 7);
    freq.put("opu", 14);
    freq.put("opr", 49);
    freq.put("ops", 6);
    freq.put("nąc", 3);
    freq.put("ope", 17);
    freq.put("opa", 56);
    freq.put("opc", 16);
    freq.put("opl", 5);
    freq.put("opn", 14);
    freq.put("Ś", 34);
    freq.put("oph", 3);
    freq.put("opi", 76);
    freq.put("Jeb", 3);
    freq.put("Ars", 8);
    freq.put("Art", 4);
    freq.put("ZY ", 6);
    freq.put("Ark", 3);
    freq.put("www", 16);
    freq.put("Wię", 12);
    freq.put("zu ", 65);
    freq.put("bra", 177);
    freq.put("hcę", 44);
    freq.put("opó", 3);
    freq.put("ww ", 16);
    freq.put("ąba", 3);
    freq.put("zur", 7);
    freq.put("zup", 10);
    freq.put("zut", 11);
    freq.put("ślę", 18);
    freq.put("zuc", 40);
    freq.put("zuj", 47);
    freq.put("zuk", 40);
    freq.put("zul", 13);
    freq.put("zum", 40);
    freq.put("słu", 60);
    freq.put("nąć", 28);
    freq.put("sły", 33);
    freq.put("sła", 72);
    freq.put("słe", 5);
    freq.put("słi", 3);
    freq.put("sło", 73);
    freq.put("Å", 3);
    freq.put("Z", 303);
    freq.put("ÓW ", 5);
    freq.put("nął", 12);
    freq.put("sł ", 9);
    freq.put("opł", 3);
    freq.put("ślu", 3);
    freq.put("nka", 66);
    freq.put("śle", 27);
    freq.put("zuć", 4);
    freq.put("ślo", 5);
    freq.put("śli", 86);
    freq.put("słó", 12);
    freq.put("NE ", 10);
    freq.put("zuł", 9);
    freq.put("nko", 20);
    freq.put("Wie", 34);
    freq.put("Wid", 17);
    freq.put("Wia", 14);
    freq.put("AH ", 4);
    freq.put("Win", 8);
    freq.put("Wil", 9);
    freq.put("Wit", 19);
    freq.put("Wis", 9);
    freq.put("ajb", 20);
    freq.put("cąc", 6);
    freq.put("łać", 13);
    freq.put("Wło", 8);
    freq.put("ąb ", 3);
    freq.put("din", 6);
    freq.put("dio", 36);
    freq.put("dii", 8);
    freq.put("cą ", 34);
    freq.put("die", 13);
    freq.put("ers", 62);
    freq.put("dia", 28);
    freq.put("dic", 3);
    freq.put("łań", 5);
    freq.put(" Ża", 4);
    freq.put("łał", 28);
    freq.put(" Że", 6);
    freq.put("diu", 7);
    freq.put("dis", 5);
    freq.put("Gru", 10);
    freq.put(" Yo", 13);
    freq.put(" Ya", 5);
    freq.put(" Ye", 6);
    freq.put("Gre", 6);
    freq.put("Gra", 11);
    freq.put("Gro", 4);
    freq.put("znę", 8);
    freq.put(" Yu", 3);
    freq.put("tne", 27);
    freq.put("sną", 7);
    freq.put("ółt", 6);
    freq.put("mt", 10);
    freq.put("ółc", 6);
    freq.put("mać", 13);
    freq.put("AM ", 16);
    freq.put("bo ", 260);

    init3();
  }
  private static void init3() {
    
    freq.put("ółk", 10);
    freq.put("ółn", 5);
    freq.put("snę", 3);
    freq.put("mr", 18);
    freq.put("tno", 16);
    freq.put("box", 3);
    freq.put("boy", 4);
    freq.put("boz", 4);
    freq.put("ero", 78);
    freq.put("bor", 41);
    freq.put("bos", 12);
    freq.put("bot", 24);
    freq.put("bow", 26);
    freq.put("boh", 3);
    freq.put("Wo", 35);
    freq.put("ół ", 32);
    freq.put("bok", 11);
    freq.put("bol", 30);
    freq.put("bom", 5);
    freq.put("bon", 6);
    freq.put("boo", 19);
    freq.put("boc", 8);
    freq.put("oo ", 54);
    freq.put("Be ", 3);
    freq.put("ła ", 333);
    freq.put("ayl", 11);
    freq.put("ayn", 7);
    freq.put("aya", 4);
    freq.put("ul ", 9);
    freq.put("ays", 3);
    freq.put("ław", 37);
    freq.put("łat", 27);
    freq.put("uar", 4);
    freq.put("Ben", 6);
    freq.put("łas", 43);
    freq.put("łap", 8);
    freq.put("oob", 6);
    freq.put("ool", 8);
    freq.put("ooo", 111);
    freq.put("oon", 4);
    freq.put("ook", 27);
    freq.put("Bez", 10);
    freq.put("łag", 4);
    freq.put("ład", 106);
    freq.put("ylu", 12);
    freq.put("łab", 40);
    freq.put("łac", 34);
    freq.put("oos", 6);
    freq.put("łaa", 4);
    freq.put("łan", 11);
    freq.put("łam", 440);
    freq.put("łaj", 3);
    freq.put("łak", 9);
    freq.put("uls", 5);
    freq.put("ay ", 28);
    freq.put("ult", 7);
    freq.put("ulu", 34);
    freq.put("znó", 13);
    freq.put("ulk", 8);
    freq.put("uli", 38);
    freq.put("ulo", 5);
    freq.put("ull", 5);
    freq.put("fla", 4);
    freq.put("ula", 26);
    freq.put("fle", 3);
    freq.put("ulg", 3);
    freq.put("ule", 8);
    freq.put("ma ", 288);
    freq.put("zn ", 12);
    freq.put("nys", 3);
    freq.put("nyw", 5);
    freq.put("nym", 89);
    freq.put("nyc", 110);
    freq.put("dNe", 6);
    freq.put("mas", 78);
    freq.put("sne", 24);
    freq.put("mat", 87);
    freq.put("Urb", 3);
    freq.put("sna", 9);
    freq.put("sno", 9);
    freq.put("maz", 3);
    freq.put("sni", 31);
    freq.put("mac", 75);
    freq.put("mad", 7);
    freq.put("mag", 23);
    freq.put("mai", 11);
    freq.put("mak", 21);
    freq.put("maj", 39);
    freq.put("mam", 307);
    freq.put("mal", 56);
    freq.put("Urz", 3);
    freq.put("sny", 18);
    freq.put("zna", 236);
    freq.put("boż", 5);
    freq.put("zne", 76);
    freq.put("zni", 128);
    freq.put("zno", 59);
    freq.put("q", 16);
    freq.put("zny", 55);
    freq.put("yli", 88);
    freq.put("lse", 3);
    freq.put("lsc", 28);
    freq.put("lsa", 4);
    freq.put("aś ", 91);
    freq.put("lsk", 158);
    freq.put("żar", 17);
    freq.put("żas", 6);
    freq.put("żal", 8);
    freq.put("żam", 11);
    freq.put("żan", 10);
    freq.put("żaj", 9);
    freq.put("żad", 11);
    freq.put("lsz", 8);
    freq.put(" aa", 22);
    freq.put(" ab", 23);
    freq.put(" ac", 6);
    freq.put(" ad", 7);
    freq.put(" af", 4);
    freq.put(" ag", 13);
    freq.put(" ah", 25);
    freq.put(" ai", 3);
    freq.put(" aj", 3);
    freq.put(" ak", 54);
    freq.put("Żyw", 4);
    freq.put(" am", 21);
    freq.put(" an", 72);
    freq.put(" ap", 10);
    freq.put(" ar", 25);
    freq.put(" as", 8);
    freq.put(" at", 19);
    freq.put(" au", 35);
    freq.put(" av", 6);
    freq.put(" aw", 11);
    freq.put("Życ", 4);
    freq.put(" az", 3);
    freq.put("aśn", 105);
    freq.put("ls ", 6);
    freq.put("aśc", 9);
    freq.put("oró", 26);
    freq.put("Sha", 9);
    freq.put("kki", 6);
    freq.put("ięż", 21);
    freq.put("aśp", 3);
    freq.put("ża ", 16);
    freq.put("Sho", 4);
    freq.put(" a ", 418);
    freq.put("ięł", 9);
    freq.put("Lub", 26);
    freq.put("Lud", 6);
    freq.put("or ", 68);
    freq.put("Ken", 6);
    freq.put("Dż", 3);
    freq.put("uż ", 242);
    freq.put("dąż", 3);
    freq.put("RT ", 41);
    freq.put("G", 227);
    freq.put("ory", 41);
    freq.put("orw", 6);
    freq.put("sów", 38);
    freq.put("oru", 36);
    freq.put("orr", 11);
    freq.put("ors", 19);
    freq.put("orn", 10);
    freq.put("oro", 65);
    freq.put("orl", 3);
    freq.put("orm", 79);
    freq.put("ork", 27);
    freq.put("ori", 25);
    freq.put("org", 20);
    freq.put("ord", 19);
    freq.put("ore", 62);
    freq.put("orb", 4);
    freq.put("orc", 28);
    freq.put("sób", 23);
    freq.put("App", 10);
    freq.put("Apl", 3);
    freq.put("Apa", 4);
    freq.put("Yay", 3);
    freq.put("ię ", 1015);
    freq.put("lau", 5);
    freq.put("Oto", 3);
    freq.put(" aż", 28);
    freq.put("żał", 12);
    freq.put("Otw", 6);
    freq.put("ięd", 18);
    freq.put("ięg", 7);
    freq.put("ięc", 103);
    freq.put("ięb", 6);
    freq.put("ięk", 127);
    freq.put("ięt", 64);
    freq.put("ięs", 8);
    freq.put("JK ", 5);
    freq.put("zst", 4);
    freq.put("akż", 14);
    freq.put("zsz", 8);
    freq.put("zse", 4);
    freq.put("żać", 5);
    freq.put("iw ", 4);
    freq.put("dą ", 47);
    freq.put("Dn", 7);
    freq.put("Do", 90);
    freq.put("Dl", 13);
    freq.put("Di", 14);
    freq.put("De", 32);
    freq.put("Da", 33);
    freq.put("Dz", 82);
    freq.put("Dy", 5);
    freq.put("Dw", 4);
    freq.put("Du", 13);
    freq.put("Dr", 17);
    freq.put("iwe", 17);
    freq.put("iwa", 29);
    freq.put("iwo", 20);
    freq.put("iwn", 30);
    freq.put("iwk", 4);
    freq.put("iwi", 25);
    freq.put("dąc", 5);
    freq.put("iwy", 12);
    freq.put("SW ", 5);
    freq.put("D ", 387);
    freq.put("ge ", 28);
    freq.put("śni", 166);
    freq.put("śne", 6);
    freq.put("Wg", 4);
    freq.put("We", 27);
    freq.put("Wc", 10);
    freq.put("Wa", 99);
    freq.put("HA ", 8);
    freq.put("Wn", 4);
    freq.put("Wl", 3);
    freq.put("Wi", 132);
    freq.put("Wu", 3);
    freq.put("Wt", 5);
    freq.put("Ws", 36);
    freq.put("Wr", 24);
    freq.put("Wp", 4);
    freq.put("Wy", 90);
    freq.put("ger", 13);
    freq.put("get", 9);
    freq.put("jó", 7);
    freq.put("onó", 11);
    freq.put("ged", 4);
    freq.put("gej", 7);
    freq.put("geo", 5);
    freq.put("gen", 30);
    freq.put("gel", 4);
    freq.put("W ", 132);
    freq.put("ó", 1345);
    freq.put("uję", 86);
    freq.put("pał", 13);
    freq.put("pań", 8);
    freq.put("tu ", 125);
    freq.put("ują", 67);
    freq.put("j ", 1197);
    freq.put("paź", 9);
    freq.put("FO ", 3);
    freq.put("CH ", 10);
    freq.put("tuz", 3);
    freq.put("jw", 20);
    freq.put("łoż", 20);
    freq.put("jz", 3);
    freq.put("jt", 10);
    freq.put("ju", 384);
    freq.put("tur", 59);
    freq.put("tus", 9);
    freq.put("jp", 19);
    freq.put("jr", 55);
    freq.put("js", 142);
    freq.put("jl", 51);
    freq.put("jm", 76);
    freq.put("jn", 188);
    freq.put("jo", 51);
    freq.put("tul", 27);
    freq.put("ji", 169);
    freq.put("jj", 8);
    freq.put("jk", 28);
    freq.put("jd", 89);
    freq.put("je", 1740);
    freq.put("jf", 4);
    freq.put("jg", 7);
    freq.put("tud", 14);
    freq.put("ja", 1487);
    freq.put("jb", 28);
    freq.put("jc", 53);
    freq.put("łoś", 29);
    freq.put("dkr", 6);
    freq.put("tuj", 62);
    freq.put("tuk", 8);
    freq.put("dka", 17);
    freq.put("dko", 14);
    freq.put("łoń", 20);
    freq.put("dki", 16);
    freq.put("eży", 24);
    freq.put("Wł", 31);
    freq.put("pać", 40);
    freq.put("żół", 4);
    freq.put("tua", 36);
    freq.put("eża", 11);
    freq.put("tub", 4);
    freq.put("eżd", 6);
    freq.put("eże", 14);
    freq.put("tuc", 6);
    freq.put("idę", 36);
    freq.put("dku", 20);
    freq.put("eż ", 173);
    freq.put("bmy", 4);
    freq.put("hda", 5);
    freq.put("hło", 21);
    freq.put("dkę", 6);
    freq.put("ło ", 316);
    freq.put("eć ", 100);
    freq.put("pap", 8);
    freq.put("par", 57);
    freq.put("pas", 17);
    freq.put("pat", 47);
    freq.put("ję", 295);
    freq.put("paz", 7);
    freq.put("pac", 29);
    freq.put("pad", 92);
    freq.put("pai", 3);
    freq.put("pak", 21);
    freq.put("uj ", 32);
    freq.put("pam", 46);
    freq.put("pan", 77);
    freq.put("oin", 7);
    freq.put("oim", 48);
    freq.put("nac", 80);
    freq.put("łop", 20);
    freq.put("łor", 3);
    freq.put("łos", 67);
    freq.put("łot", 15);
    freq.put("łow", 87);
    freq.put("łok", 4);
    freq.put("łom", 7);
    freq.put("łon", 16);
    freq.put("łoo", 6);
    freq.put("nży", 4);
    freq.put("łob", 7);
    freq.put("łoc", 6);
    freq.put("łod", 37);
    freq.put("łog", 4);
    freq.put("jś", 29);
    freq.put("kę ", 103);
    freq.put("pa ", 51);
    freq.put("ujo", 4);
    freq.put("uje", 221);
    freq.put("tuł", 7);
    freq.put("uja", 9);
    freq.put("ób ", 24);
    freq.put("mo ", 60);
    freq.put("zl ", 3);
    freq.put(" có", 12);
    freq.put(" Śm", 5);
    freq.put(" Śl", 7);
    freq.put("óbu", 5);
    freq.put("mos", 14);
    freq.put("mor", 45);
    freq.put("mow", 75);
    freq.put("mot", 14);
    freq.put("mok", 5);
    freq.put("moj", 111);
    freq.put("moi", 40);
    freq.put("óba", 3);
    freq.put("mon", 22);
    freq.put("mom", 24);
    freq.put("mol", 15);
    freq.put("moc", 53);
    freq.put("mob", 14);
    freq.put(" Św", 16);
    freq.put("mog", 103);
    freq.put("óbo", 5);
    freq.put("óbl", 3);
    freq.put("mod", 12);
    freq.put("zle", 10);
    freq.put("zla", 12);
    freq.put("zlo", 5);
    freq.put("zli", 15);
    freq.put("nęł", 27);
    freq.put("eżn", 8);
    freq.put("Nee", 6);
    freq.put("New", 5);
    freq.put("Med", 9);
    freq.put(" ch", 534);
    freq.put(" ci", 250);
    freq.put("żę ", 6);
    freq.put(" co", 493);
    freq.put("Mec", 5);
    freq.put(" cm", 4);
    freq.put(" cb", 7);
    freq.put("Mel", 5);
    freq.put(" ca", 91);
    freq.put(" cd", 6);
    freq.put(" ce", 28);
    freq.put(" cz", 597);
    freq.put("Met", 6);
    freq.put(" cy", 20);
    freq.put("Mes", 3);
    freq.put("Mer", 8);
    freq.put(" cu", 14);
    freq.put("Dru", 6);
    freq.put("póź", 17);
    freq.put("Dra", 4);
    freq.put("km ", 26);
    freq.put("pół", 39);
    freq.put(" c ", 10);
    freq.put("yyy", 19);
    freq.put("nę ", 68);
    freq.put("tę ", 56);
    freq.put("moż", 178);
    freq.put("Ac", 6);
    freq.put("nęt", 3);
    freq.put("yy ", 8);
    freq.put("e", 22536);
    freq.put("moś", 21);
    freq.put("tęp", 53);
    freq.put("tęs", 8);
    freq.put("Ap", 17);
    freq.put("pój", 20);
    freq.put("pól", 7);
    freq.put("rań", 3);
    freq.put("pów", 3);
    freq.put("US ", 5);
    freq.put("uń ", 3);
    freq.put("u", 5543);
    freq.put("jdą", 5);
    freq.put("iu ", 131);
    freq.put("jdę", 17);
    freq.put("hy ", 19);
    freq.put("ws ", 12);
    freq.put("ajk", 7);
    freq.put("iuk", 5);
    freq.put("iuj", 5);
    freq.put("ium", 9);
    freq.put("iul", 5);
    freq.put("twą", 3);
    freq.put("LA ", 7);
    freq.put("iuc", 3);
    freq.put("TA ", 5);
    freq.put("aja", 38);
    freq.put("deł", 4);
    freq.put("iur", 6);
    freq.put("iut", 6);
    freq.put("żyt", 17);
    freq.put("hyb", 119);
    freq.put("wsi", 5);
    freq.put("wsk", 69);
    freq.put("aje", 98);
    freq.put("wsp", 41);
    freq.put("żyw", 24);
    freq.put("wst", 40);
    freq.put("jdź", 11);
    freq.put("wsy", 3);
    freq.put("wsz", 299);
    freq.put("gg ", 5);
    freq.put("ażą", 3);
    freq.put("aba", 29);
    freq.put("abc", 9);
    freq.put("abe", 5);
    freq.put("abi", 43);
    freq.put("abk", 7);
    freq.put("abl", 19);
    freq.put("abo", 7);
    freq.put("abr", 22);
    freq.put("abs", 7);
    freq.put("aby", 58);
    freq.put("gh", 17);
    freq.put("bkę", 3);
    freq.put("K", 464);
    freq.put("Doł", 5);
    freq.put("lki", 36);
    freq.put("wsó", 3);
    freq.put("eźć", 9);
    freq.put("Gło", 4);
    freq.put("twa", 72);
    freq.put("iąć", 5);
    freq.put("twe", 25);
    freq.put("twi", 75);
    freq.put("two", 75);
    freq.put("de ", 94);
    freq.put("twy", 5);
    freq.put("FM ", 8);
    freq.put("Vic", 3);
    freq.put("oi ", 11);
    freq.put("ey ", 11);
    freq.put("tw ", 12);
    freq.put("lku", 11);
    freq.put("dep", 4);
    freq.put("der", 45);
    freq.put("des", 18);
    freq.put("dej", 18);
    freq.put("dek", 22);
    freq.put("del", 12);
    freq.put("dem", 39);
    freq.put("den", 55);
    freq.put("jdz", 38);
    freq.put("dea", 9);
    freq.put("deb", 17);
    freq.put("dec", 47);
    freq.put("ded", 7);
    freq.put("deg", 8);
    freq.put("abł", 3);
    freq.put("Do ", 12);
    freq.put("eźw", 3);
    freq.put("eźl", 9);
    freq.put("eźd", 4);
    freq.put("ryn", 13);
    freq.put("Tym", 8);
    freq.put("ryl", 4);
    freq.put("rym", 32);
    freq.put("ryj", 10);
    freq.put("ryk", 20);
    freq.put("Tyd", 3);
    freq.put("ryg", 6);
    freq.put("iPh", 6);
    freq.put("ryb", 9);
    freq.put("ryc", 37);
    freq.put("twó", 20);
    freq.put("ryz", 15);
    freq.put("ryw", 38);
    freq.put("ryt", 35);
    freq.put("Typ", 4);
    freq.put("rys", 19);
    freq.put("ryp", 3);
    freq.put("Dok", 3);
    freq.put("Don", 4);
    freq.put("bka", 7);
    freq.put("Dol", 6);
    freq.put("Dom", 10);
    freq.put("Dob", 30);
    freq.put("bko", 18);
    freq.put("bki", 9);
    freq.put("Dod", 4);
    freq.put("Dor", 4);
    freq.put("Dos", 3);
    freq.put("Dop", 3);
    freq.put("eź ", 6);
    freq.put("Dow", 3);
    freq.put("aży", 10);
    freq.put("Ty ", 29);
    freq.put("ry ", 188);
    freq.put("ażn", 30);
    freq.put("ażo", 6);
    freq.put("ażd", 38);
    freq.put("aże", 28);
    freq.put("aża", 31);
    freq.put("Czę", 3);
    freq.put("pw", 3);
    freq.put("koł", 53);
    freq.put("koń", 75);
    freq.put("ok ", 82);
    freq.put("koś", 39);
    freq.put("pcz", 3);
    freq.put("pcy", 3);
    freq.put("AY ", 3);
    freq.put("pcj", 16);
    freq.put("pci", 6);
    freq.put("oks", 7);
    freq.put("okr", 31);
    freq.put("Bar", 25);
    freq.put("oka", 72);
    freq.put("okc", 7);
    freq.put("jów", 7);
    freq.put("Bab", 3);
    freq.put("ją", 345);
    freq.put("Ban", 5);
    freq.put("Bal", 4);
    freq.put("okl", 5);
    freq.put("oko", 114);
    freq.put("okn", 7);
    freq.put("pal", 25);
    freq.put("ką", 108);
    freq.put("sb ", 4);
    freq.put("ód ", 18);
    freq.put("kę", 109);
    freq.put("UŻ ", 4);
    freq.put("mm ", 19);
    freq.put("E ", 110);
    freq.put("kł", 101);
    freq.put("okó", 10);
    freq.put("oid", 5);
    freq.put("sbu", 4);
    freq.put("mmu", 3);
    freq.put("oic", 31);
    freq.put("ódz", 5);
    freq.put("mmm", 12);
    freq.put("Und", 3);
    freq.put("Uni", 7);
    freq.put("sbi", 3);
    freq.put("Em", 7);
    freq.put("El", 10);
    freq.put("fę ", 4);
    freq.put("En", 9);
    freq.put("zji", 25);
    freq.put("Ej", 8);
    freq.put("Ed", 7);
    freq.put("zje", 14);
    freq.put("Ef", 3);
    freq.put("zja", 19);
    freq.put("Ex", 5);
    freq.put("Eu", 26);
    freq.put("zju", 5);
    freq.put("Ev", 3);
    freq.put("Ep", 3);
    freq.put("Es", 6);
    freq.put("kż", 14);
    freq.put("ql ", 3);
    freq.put(" el", 9);
    freq.put(" em", 31);
    freq.put(" en", 12);
    freq.put("koj", 50);
    freq.put(" eh", 10);
    freq.put("kol", 136);
    freq.put(" ej", 20);
    freq.put(" ek", 25);
    freq.put(" ed", 5);
    freq.put(" ee", 11);
    freq.put("X ", 17);
    freq.put(" eg", 10);
    freq.put("kod", 31);
    freq.put("kog", 22);
    freq.put("koz", 4);
    freq.put(" ex", 4);
    freq.put(" et", 5);
    freq.put(" eu", 10);
    freq.put(" ev", 4);
    freq.put(" ew", 7);
    freq.put(" ep", 7);
    freq.put("kot", 32);
    freq.put("kow", 162);
    freq.put(" es", 5);
    freq.put("Sli", 3);
    freq.put("Sla", 4);
    freq.put("b", 4395);
    freq.put("ko ", 391);
    freq.put(" e ", 5);
    freq.put("Czw", 3);
    freq.put("kó", 97);
    freq.put("okł", 28);
    freq.put("Cza", 21);
    freq.put("Cze", 20);
    freq.put("vn ", 4);
    freq.put("zję", 3);
    freq.put("świ", 91);
    freq.put("k ", 1370);
    freq.put("Kir", 3);
    freq.put("Kin", 7);
    freq.put("Kie", 20);
    freq.put("ódź", 3);
    freq.put("kc", 110);
    freq.put("kb", 33);
    freq.put("ka", 1309);
    freq.put("kg", 6);
    freq.put("ke", 114);
    freq.put("kk", 10);
    freq.put("ki", 1438);
    freq.put("kh", 5);
    freq.put("ko", 1533);
    freq.put("kn", 85);
    freq.put("km", 36);
    freq.put("kl", 165);
    freq.put("ks", 138);
    freq.put("kr", 227);
    freq.put("kp", 4);
    freq.put("kw", 29);
    freq.put("ku", 589);
    freq.put("kt", 426);
    freq.put("ky", 9);
    freq.put("uły", 6);
    freq.put("ułe", 4);
    freq.put("Opa", 7);
    freq.put("gać", 4);
    freq.put("uło", 4);
    freq.put("Opi", 3);
    freq.put("ikó", 17);
    freq.put("Ser", 9);
    freq.put("uł ", 12);
    freq.put("gał", 4);
    freq.put(" Be", 56);
    freq.put(" Ba", 52);
    freq.put(" Bl", 18);
    freq.put(" Bo", 63);
    freq.put(" Bi", 59);
    freq.put("ozd", 42);
    freq.put(" Bu", 21);
    freq.put("ik ", 73);
    freq.put(" Br", 32);
    freq.put(" By", 25);
    freq.put("syć", 7);
    freq.put("DD ", 25);
    freq.put("iks", 7);
    freq.put("ćmi", 3);
    freq.put("ikw", 5);
    freq.put("iku", 18);
    freq.put("ikt", 11);
    freq.put("ika", 81);
    freq.put("ike", 17);
    freq.put("kte", 6);
    freq.put("iki", 42);
    freq.put("iko", 45);
    freq.put("ikn", 4);
    freq.put("dgł", 3);
    freq.put("sył", 10);
    freq.put("Bąd", 6);
    freq.put("kta", 11);
    freq.put("SK ", 3);
    freq.put("Ź", 4);
    freq.put("Yes", 4);
    freq.put("lbu", 11);
    freq.put("ga ", 67);
    freq.put("ND ", 5);
    freq.put("HE ", 5);
    freq.put("fu ", 3);
    freq.put("ewó", 4);
    freq.put("gaz", 14);
    freq.put("gat", 6);
    freq.put("gas", 5);
    freq.put("gar", 41);
    freq.put("gap", 6);
    freq.put("gan", 36);
    freq.put("gam", 13);
    freq.put("gal", 22);
    freq.put("gaj", 11);
    freq.put("gag", 3);
    freq.put("gad", 50);
    freq.put("gac", 14);
    freq.put("fut", 3);
    freq.put("fuu", 3);
    freq.put("dża", 10);
    freq.put("fuc", 3);
    freq.put("fun", 6);
    freq.put("fuj", 3);
    freq.put("sy ", 81);
    freq.put("rap", 11);
    freq.put("moz", 35);
    freq.put("Mów", 3);
    freq.put("Mój", 7);
    freq.put("ewk", 3);
    freq.put("ewi", 47);
    freq.put("ewo", 14);
    freq.put("ewn", 103);
    freq.put("ewc", 30);
    freq.put("ewa", 62);
    freq.put("ewe", 4);
    freq.put("ewy", 4);
    freq.put("ews", 28);
    freq.put("ewr", 5);
    freq.put("syc", 8);
    freq.put(" Ła", 8);
    freq.put("dge", 4);
    freq.put("syk", 3);
    freq.put("syj", 4);
    freq.put("syn", 11);
    freq.put("sym", 11);
    freq.put(" Ło", 6);
    freq.put("sys", 19);
    freq.put("syp", 8);
    freq.put("syw", 8);
    freq.put(" Łu", 3);
    freq.put("syt", 11);
    freq.put(" Bą", 6);
    freq.put("ew ", 24);
    freq.put("Te", 77);
    freq.put("jbe", 3);
    freq.put("jba", 13);
    freq.put("y", 8386);
    freq.put("jbl", 7);
    freq.put(" Bę", 10);
    freq.put("ał ", 237);
    freq.put("lde", 5);
    freq.put("bi ", 32);
    freq.put("cus", 8);
    freq.put("rgu", 5);
    freq.put("yśc", 16);
    freq.put("rga", 28);
    freq.put("cud", 11);
    freq.put("cuc", 5);
    freq.put("rge", 8);
    freq.put("rgi", 12);
    freq.put("cuj", 13);
    freq.put("yśm", 13);
    freq.put("yśl", 101);
    freq.put("bin", 7);
    freq.put("bio", 49);
    freq.put("bil", 46);
    freq.put("ałc", 10);
    freq.put("bij", 27);
    freq.put("ałe", 142);
    freq.put("Die", 3);
    freq.put("ałk", 17);
    freq.put("bib", 4);
    freq.put("Dia", 4);
    freq.put("ało", 133);
    freq.put("ałs", 4);
    freq.put("ałt", 4);
    freq.put("ału", 28);
    freq.put("ały", 92);
    freq.put("bit", 9);
    freq.put("biu", 9);
    freq.put("bis", 48);
    freq.put("Dir", 4);
    freq.put("rg ", 4);
    freq.put("nsę", 3);
    freq.put("yś ", 56);
    freq.put("cu ", 48);
    freq.put(" gł", 88);
    freq.put("Bo ", 16);
    freq.put("oe ", 13);
    freq.put("łka", 23);
    freq.put("pet", 15);
    freq.put("pew", 88);
    freq.put("łki", 14);
    freq.put("per", 83);
    freq.put("pes", 3);
    freq.put("pel", 13);
    freq.put("łku", 5);
    freq.put("pen", 5);
    freq.put("pej", 6);
    freq.put("pek", 14);
    freq.put("ped", 4);
    freq.put("pea", 5);
    freq.put("pec", 13);
    freq.put("Bos", 4);
    freq.put("O", 390);
    freq.put("Boj", 4);
    freq.put("ałó", 9);
    freq.put("Bol", 11);
    freq.put("Bon", 3);
    freq.put("Bob", 3);
    freq.put("bió", 5);
    freq.put("Bog", 4);
    freq.put("fen", 5);
    freq.put("pe ", 10);
    freq.put("nsh", 3);
    freq.put("nsi", 4);
    freq.put("nsk", 6);
    freq.put("nsm", 5);
    freq.put("nso", 15);
    freq.put("fej", 11);
    freq.put("nse", 11);
    freq.put("nsf", 7);
    freq.put("usj", 3);
    freq.put("nsy", 5);
    freq.put("nsp", 10);
    freq.put("nst", 23);
    freq.put("nsu", 5);
    freq.put("ałą", 12);
    freq.put("mka", 9);
    freq.put("mko", 3);
    freq.put("bić", 40);
    freq.put("Ooo", 5);
    freq.put("bią", 11);
    freq.put("mki", 9);
    freq.put("ają", 189);
    freq.put("bię", 51);
    freq.put("ałę", 4);
    freq.put(" R ", 4);
    freq.put("ns ", 21);
    freq.put("Flo", 3);
    freq.put("gór", 15);
    freq.put("gów", 10);
    freq.put("źdz", 18);
    freq.put("bił", 59);
    freq.put("ezo", 20);
    freq.put("biś", 7);
    freq.put("gól", 41);
    freq.put("lyc", 3);
    freq.put("lyn", 4);
    freq.put("peł", 29);
    freq.put(" gw", 21);
    freq.put("Mas", 17);
    freq.put(" gu", 10);
    freq.put(" gr", 123);
    freq.put("Mat", 10);
    freq.put("Maz", 5);
    freq.put("aż", 223);
    freq.put("żą ", 8);
    freq.put(" gg", 5);
    freq.put(" gd", 95);
    freq.put(" ge", 28);
    freq.put("Mad", 13);
    freq.put("Mag", 3);
    freq.put(" ga", 80);
    freq.put("Mai", 3);
    freq.put(" go", 188);
    freq.put(" gl", 13);
    freq.put(" gm", 6);
    freq.put("Mam", 49);
    freq.put("Mal", 7);
    freq.put(" gi", 21);
    freq.put("Boż", 8);
    freq.put("ac ", 86);
    freq.put("ly ", 30);
    freq.put("łkę", 5);
    freq.put("mik", 24);
    freq.put("Ma ", 4);
    freq.put("żąc", 3);
    freq.put("żąd", 4);
    freq.put(" g ", 4);
    freq.put(" b", 1673);
    freq.put(" c", 2091);
    freq.put("chł", 22);
    freq.put(" a", 1287);
    freq.put(" f", 369);
    freq.put(" g", 698);
    freq.put(" d", 2373);
    freq.put(" e", 194);
    freq.put(" j", 2450);
    freq.put(" k", 1614);
    freq.put(" h", 367);
    freq.put(" i", 1420);
    freq.put(" n", 4138);
    freq.put(" o", 1788);
    freq.put(" l", 621);
    freq.put(" m", 3066);
    freq.put(" r", 945);
    freq.put(" s", 3293);
    freq.put(" p", 3649);
    freq.put(" Dż", 3);
    freq.put(" v", 38);
    freq.put("kmi", 4);
    freq.put(" t", 3502);
    freq.put(" u", 563);
    freq.put(" z", 2838);
    freq.put(" x", 492);
    freq.put(" y", 27);
    freq.put(" B", 388);
    freq.put(" C", 575);
    freq.put(" A", 474);
    freq.put(" F", 181);
    freq.put(" G", 223);
    freq.put(" D", 819);
    freq.put(" E", 143);
    freq.put(" J", 525);
    freq.put(" K", 460);
    freq.put(" H", 185);
    freq.put(" I", 216);
    freq.put(" N", 643);
    freq.put(" O", 381);
    freq.put(" L", 251);
    freq.put(" M", 565);
    freq.put(" R", 306);
    freq.put(" S", 597);
    freq.put(" P", 1074);
    freq.put("haj", 19);
    freq.put(" V", 36);
    freq.put(" W", 658);
    freq.put(" T", 634);
    freq.put(" U", 118);
    freq.put(" Z", 302);
    freq.put(" X", 140);
    freq.put(" Y", 37);
    freq.put("eś ", 123);
    freq.put("węg", 3);
    freq.put("hak", 3);
    freq.put("chę", 52);
    freq.put("dda", 21);
    freq.put("żow", 13);
    freq.put("eśn", 39);
    freq.put("eśm", 16);
    freq.put("eśl", 56);
    freq.put("żon", 17);
    freq.put(" ó", 7);
    freq.put("han", 45);
    freq.put("Ora", 4);
    freq.put("och", 179);
    freq.put("ock", 23);
    freq.put("zęł", 13);
    freq.put("lał", 32);
    freq.put("Big", 4);
    freq.put("zęś", 40);
    freq.put(" Do", 88);
    freq.put(" Dn", 7);
    freq.put(" Dl", 13);
    freq.put("Ver", 3);
    freq.put(" Di", 14);
    freq.put(" De", 32);
    freq.put(" Da", 33);
    freq.put("ii ", 64);
    freq.put(" Dy", 5);
    freq.put(" Dw", 4);
    freq.put(" Ż", 36);
    freq.put(" Du", 13);
    freq.put(" Ź", 4);
    freq.put(" Dr", 17);
    freq.put(" ż", 712);
    freq.put(" ł", 103);
    freq.put("cha", 243);
    freq.put("Fr", 17);
    freq.put("chc", 202);
    freq.put("che", 52);
    freq.put("chi", 18);
    freq.put("chl", 7);
    freq.put("chm", 15);
    freq.put("chn", 22);
    freq.put("cho", 253);
    freq.put("Fa", 36);
    freq.put("chr", 14);
    freq.put("cht", 4);
    freq.put("chu", 43);
    freq.put("chw", 38);
    freq.put(" Ś", 34);
    freq.put("Fi", 30);
    freq.put("Fl", 7);
    freq.put("Fo", 17);
    freq.put("iit", 3);
    freq.put(" D ", 188);
    freq.put("GG ", 5);
    freq.put("iii", 18);
    freq.put("ch ", 684);
    freq.put(" ć", 9);
    freq.put("f", 827);
    freq.put("F ", 21);
    freq.put("zę ", 248);
    freq.put("aco", 18);
    freq.put("Zro", 5);
    freq.put("afi", 46);
    freq.put("Yo", 13);
    freq.put("Ya", 6);
    freq.put("afe", 5);
    freq.put("aff", 3);
    freq.put("Ye", 6);
    freq.put("afa", 10);
    freq.put("chó", 10);
    freq.put("afy", 3);
    freq.put("aft", 3);
    freq.put("Yu", 3);
    freq.put("dwr", 3);
    freq.put("zęd", 12);
    freq.put("zęb", 3);
    freq.put("zęc", 5);
    freq.put("zęt", 5);
    freq.put("zęs", 13);
    freq.put("Y ", 47);
    freq.put("af ", 5);
    freq.put("wó", 77);
    freq.put("laś", 4);
    freq.put("da ", 220);
    freq.put("zł", 158);
    freq.put("eum", 8);
    freq.put("lg", 22);
    freq.put("ld", 28);
    freq.put("le", 1687);
    freq.put("lb", 88);
    freq.put("lc", 25);
    freq.put("la", 1003);
    freq.put("ln", 259);
    freq.put("eud", 3);
    freq.put("ll", 117);
    freq.put("lm", 56);
    freq.put("lk", 286);
    freq.put("euc", 5);
    freq.put("li", 1104);
    freq.put("lv", 8);
    freq.put("lw", 23);
    freq.put("lt", 17);
    freq.put("lu", 341);
    freq.put("lr", 3);
    freq.put("ls", 212);
    freq.put("lp", 4);
    freq.put("ogą", 11);
    freq.put("lz", 4);
    freq.put("eus", 3);
    freq.put("eur", 10);
    freq.put("dad", 4);
    freq.put("eme", 18);
    freq.put("dac", 26);
    freq.put("dal", 94);
    freq.put("dam", 84);
    freq.put("dan", 89);
    freq.put("daj", 90);
    freq.put("dak", 10);
    freq.put("dat", 28);
    freq.put("daw", 46);
    freq.put("dar", 46);
    freq.put("das", 14);
    freq.put("ląd", 108);
    freq.put("day", 10);
    freq.put("ęły", 7);
    freq.put("l ", 373);
    freq.put("ts ", 8);
    freq.put("dwo", 13);
    freq.put("ęło", 10);
    freq.put("ęła", 34);
    freq.put("ogł", 34);
    freq.put("óźn", 19);
    freq.put("mił", 27);
    freq.put("lfi", 3);
    freq.put("ęli", 4);
    freq.put("rez", 63);
    freq.put("res", 91);
    freq.put("Tur", 3);
    freq.put("Tus", 14);
    freq.put("rew", 13);
    freq.put("ret", 23);
    freq.put("rej", 27);
    freq.put("rek", 55);
    freq.put("Pał", 3);
    freq.put("rei", 4);
    freq.put("Pań", 5);
    freq.put("ló", 3);
    freq.put("rel", 14);
    freq.put("rem", 77);
    freq.put("reb", 4);
    freq.put("rec", 23);
    freq.put("Tub", 4);
    freq.put("rea", 26);
    freq.put("ref", 10);
    freq.put("reg", 33);
    freq.put("red", 45);
    freq.put("ree", 7);
    freq.put("ękk", 3);
    freq.put("Bę", 10);
    freq.put("Tu ", 3);
    freq.put("re ", 109);
    freq.put("og ", 24);
    freq.put("dać", 51);
    freq.put("łit", 5);
    freq.put("Ład", 3);
    freq.put("lą", 139);
    freq.put("udu", 8);
    freq.put("udz", 100);
    freq.put("udy", 17);
    freq.put("ogr", 63);
    freq.put("ogl", 73);
    freq.put("ogo", 72);
    freq.put("uda", 38);
    freq.put("ogi", 34);
    freq.put("ude", 17);
    freq.put("daż", 16);
    freq.put("ogd", 3);
    freq.put("udi", 11);
    freq.put("udn", 43);
    freq.put("udo", 37);
    freq.put("lę", 60);
    freq.put("dań", 10);
    freq.put("dał", 77);
    freq.put("Fel", 3);
    freq.put("Pap", 5);
    freq.put("reś", 8);
    freq.put("Par", 14);
    freq.put("Pas", 6);
    freq.put("Pat", 9);
    freq.put("Pau", 6);
    freq.put("Paw", 8);
    freq.put("Pac", 3);
    freq.put("Pad", 4);
    freq.put("Pal", 12);
    freq.put("Pam", 6);
    freq.put("Pan", 25);
    freq.put("mii", 5);
    freq.put("uśm", 10);
    freq.put("mij", 8);
    freq.put("mim", 10);
    freq.put("mil", 39);
    freq.put("mio", 12);
    freq.put("min", 148);
    freq.put("mia", 188);
    freq.put("mic", 8);
    freq.put("uśc", 6);
    freq.put("mig", 5);
    freq.put("mix", 4);
    freq.put("miz", 6);
    freq.put("mis", 44);
    freq.put("mir", 3);
    freq.put("miu", 6);
    freq.put("mit", 20);
    freq.put("ął ", 15);
    freq.put("ogó", 45);
    freq.put("Pa ", 5);
    freq.put("sfe", 10);
    freq.put("mi ", 518);
    freq.put("uś ", 15);
    freq.put("xd ", 58);
    freq.put(" iP", 10);
    freq.put("pą ", 5);
    freq.put("ksu", 4);
    freq.put("kst", 20);
    freq.put(" iz", 4);
    freq.put("ksp", 5);
    freq.put(" ip", 3);
    freq.put("Mor", 7);
    freq.put(" ir", 7);
    freq.put(" is", 20);
    freq.put(" it", 15);
    freq.put("ksz", 32);
    freq.put("kse", 7);
    freq.put("ądó", 3);
    freq.put("Moi", 4);
    freq.put(" ik", 8);
    freq.put("ksa", 8);
    freq.put(" im", 44);
    freq.put("ksc", 4);
    freq.put("kso", 5);
    freq.put(" ic", 33);
    freq.put(" id", 94);
    freq.put(" ig", 4);
    freq.put("xdd", 10);
    freq.put("VN ", 8);
    freq.put("ysł", 39);
    freq.put("ks ", 10);
    freq.put(" i ", 917);
    freq.put("Zob", 9);
    freq.put(" Iz", 4);
    freq.put("Zos", 10);
    freq.put("ąda", 99);
    freq.put("ąde", 6);
    freq.put("ądk", 5);
    freq.put("ądn", 4);
    freq.put("ądo", 6);
    freq.put("ądr", 5);
    freq.put("ądu", 9);
    freq.put("ądz", 36);
    freq.put("oot", 3);
    freq.put("wm", 4);
    freq.put("wyś", 12);
    freq.put("cją", 15);
    freq.put("S", 621);
    freq.put("cję", 44);
    freq.put("wył", 12);
    freq.put("ąd ", 30);
    freq.put("żcz", 5);
    freq.put("wyż", 13);
    freq.put("ws", 487);
    freq.put("ioł", 9);
    freq.put("wr", 141);
    freq.put("aa", 204);
    freq.put(" iś", 32);
    freq.put("niż", 37);
    freq.put("rę ", 36);
    freq.put("oho", 14);
    freq.put(" iż", 3);
    freq.put("Moż", 24);
    freq.put("epł", 8);
    freq.put("ys ", 18);
    freq.put("wz", 44);
    freq.put("nu ", 32);
    freq.put("Hol", 8);
    freq.put("Hom", 3);
    freq.put("ręk", 6);
    freq.put("mąd", 5);
    freq.put("ręg", 5);
    freq.put("ręd", 5);
    freq.put("ręc", 31);
    freq.put("uil", 3);
    freq.put("cor", 16);
    freq.put("ysk", 43);
    freq.put("ysi", 18);
    freq.put("yso", 12);
    freq.put("cow", 33);
    freq.put("ysm", 4);
    freq.put("ysl", 21);
    freq.put("ysc", 39);
    freq.put("ysb", 3);
    freq.put("ysa", 3);
    freq.put("cov", 4);
    freq.put("uis", 4);
    freq.put("ysz", 100);
    freq.put("ysy", 14);
    freq.put("ysp", 10);
    freq.put("ysu", 3);
    freq.put("yst", 234);
    freq.put(" Fr", 17);
    freq.put(" Fu", 7);
    freq.put(" Fa", 36);
    freq.put(" Fe", 23);
    freq.put(" Fi", 29);
    freq.put(" Fl", 7);
    freq.put(" Fo", 14);
    freq.put("io ", 74);
    freq.put("yże", 9);
    freq.put("cjo", 5);
    freq.put("yża", 3);
    freq.put("yżo", 4);
    freq.put("cja", 153);
    freq.put("yżk", 3);
    freq.put("cje", 76);
    freq.put("wy ", 175);
    freq.put("ądź", 8);
    freq.put("yży", 4);
    freq.put("iow", 33);
    freq.put("iot", 37);
    freq.put("ios", 53);
    freq.put("ior", 25);
    freq.put("ion", 119);
    freq.put("iom", 10);
    freq.put("iol", 14);
    freq.put("iog", 4);
    freq.put("iod", 9);
    freq.put("ioc", 4);
    freq.put("iob", 6);
    freq.put("GA ", 3);
    freq.put("wyw", 32);
    freq.put("wyt", 21);
    freq.put("wys", 101);
    freq.put("wyr", 21);
    freq.put("yż ", 4);
    freq.put("wyp", 49);
    freq.put("wyz", 9);
    freq.put("wyg", 68);
    freq.put("wyd", 36);
    freq.put("wyc", 96);
    freq.put("wyb", 66);
    freq.put("wyo", 6);
    freq.put("wyn", 25);
    freq.put("wym", 73);
    freq.put("con", 24);
    freq.put("wyk", 54);
    freq.put("wyj", 46);
    freq.put("fy ", 6);
    freq.put("gmi", 5);
    freq.put("adu", 30);
    freq.put("adr", 16);
    freq.put("adz", 137);
    freq.put("Ą ", 4);
    freq.put("łę", 29);
    freq.put("kwi", 10);
    freq.put("ade", 47);
    freq.put("adc", 16);
    freq.put("ada", 204);
    freq.put("adn", 91);
    freq.put("ado", 75);
    freq.put("adl", 10);
    freq.put("adk", 24);
    freq.put("adi", 34);
    freq.put("Wsc", 6);
    freq.put("ocł", 6);
    freq.put("Wsp", 3);
    freq.put("Wst", 3);
    freq.put("Wsz", 23);
    freq.put("ad ", 90);
    freq.put("buł", 3);
    freq.put("nja", 4);
    freq.put("dc ", 4);
    freq.put("esu", 14);
    freq.put("est", 706);
    freq.put("ess", 12);
    freq.put("esr", 3);
    freq.put("ąk", 3);
    freq.put("esp", 37);
    freq.put("ąd", 214);
    freq.put("ąg", 59);
    freq.put("EW ", 3);
    freq.put("esz", 493);
    freq.put("esy", 7);
    freq.put("ąb", 8);
    freq.put("Co ", 38);
    freq.put("ubą", 3);
    freq.put("ese", 11);
    freq.put("esc", 15);
    freq.put("tme", 5);
    freq.put("esa", 18);
    freq.put("ąz", 29);
    freq.put("eso", 16);
    freq.put("ąt", 67);
    freq.put("esm", 3);
    freq.put("esl", 12);
    freq.put("esk", 18);
    freq.put("esj", 12);
    freq.put("ąs", 16);
    freq.put("tmo", 5);
    freq.put("dch", 16);
    freq.put("dci", 25);
    freq.put("dcz", 23);
    freq.put("dcy", 4);
    freq.put("OS ", 5);
    freq.put("tę", 120);
    freq.put("ą ", 950);
    freq.put("pić", 14);
    freq.put("pię", 52);
    freq.put("es ", 61);
    freq.put("ęby", 3);
    freq.put("óżn", 19);
    freq.put("óżo", 7);
    freq.put("óżk", 12);
    freq.put("Twi", 11);
    freq.put("Two", 22);
    freq.put("ębi", 8);
    freq.put("adł", 29);
    freq.put("bu ", 3);
    freq.put("rcy", 6);
    freq.put("rcz", 37);
    freq.put("rcu", 5);
    freq.put("rch", 5);
    freq.put("rci", 41);
    freq.put("rcj", 6);
    freq.put("rce", 25);
    freq.put("rca", 14);
    freq.put("buz", 4);
    freq.put("bur", 21);
    freq.put("bus", 14);
    freq.put("Des", 9);
    freq.put("óż ", 17);
    freq.put("Deu", 5);
    freq.put("Dev", 3);
    freq.put("adę", 24);
    freq.put("buj", 22);
    freq.put("buk", 3);
    freq.put("adą", 7);
    freq.put("Dem", 8);
    freq.put("bum", 12);
    freq.put("bud", 39);
    freq.put("gę ", 55);
    freq.put("j", 6516);
    freq.put("rc ", 3);
    freq.put("pij", 11);
    freq.put("pik", 13);
    freq.put("pil", 13);
    freq.put("pin", 12);
    freq.put("pio", 45);
    freq.put("pia", 26);
    freq.put("pic", 8);
    freq.put("Ryb", 3);
    freq.put("pie", 356);
    freq.put("ął", 21);
    freq.put("Twó", 7);
    freq.put("ub ", 23);
    freq.put("esł", 18);
    freq.put("ąś", 10);
    freq.put("pip", 3);
    freq.put("pir", 18);
    freq.put("pis", 205);
    freq.put("pit", 11);
    freq.put("piw", 5);
    freq.put("oal", 8);
    freq.put("rcó", 3);
    freq.put("ąż", 44);
    freq.put("ubu", 4);
    freq.put("ubr", 6);
    freq.put("pi ", 13);
    freq.put("ąć", 44);
    freq.put("Ach", 5);
    freq.put("ube", 17);
    freq.put("uba", 11);
    freq.put("ubl", 31);
    freq.put("ubn", 3);
    freq.put("ubo", 6);
    freq.put("ubi", 99);
    freq.put("Gdy", 16);
    freq.put("Gdz", 5);
    freq.put("Gda", 8);
    freq.put("mą", 18);
    freq.put(" śr", 23);
    freq.put("żkę", 7);
    freq.put(" śp", 18);
    freq.put(" kó", 3);
    freq.put("mę", 29);
    freq.put(" św", 80);
    freq.put("Oka", 3);
    freq.put("mwa", 4);
    freq.put("G ", 28);
    freq.put("zd ", 7);
    freq.put("mł", 10);
    freq.put("mś", 12);
    freq.put("Gw", 5);
    freq.put("Gu", 5);
    freq.put("zdy", 10);
    freq.put("Gr", 35);
    freq.put("zdz", 20);
    freq.put("zdu", 9);
    freq.put("zdr", 54);
    freq.put("Ok ", 8);
    freq.put("zdo", 8);
    freq.put("zdn", 3);
    freq.put("zdk", 3);
    freq.put("zdj", 61);
    freq.put("zde", 31);
    freq.put("Gm", 3);
    freq.put("Gl", 11);
    freq.put("zda", 42);
    freq.put("Gi", 4);
    freq.put(" kc", 4);
    freq.put(" ka", 194);
    freq.put(" kg", 6);
    freq.put(" ki", 181);
    freq.put(" kn", 5);
    freq.put(" ko", 562);
    freq.put(" kl", 83);
    freq.put(" km", 28);
    freq.put(" kr", 98);
    freq.put(" ks", 27);
    freq.put(" kw", 14);
    freq.put("ję ", 191);
    freq.put(" ku", 153);
    freq.put("kuz", 4);
    freq.put(" śn", 13);
    freq.put("kut", 5);
    freq.put("Z ", 44);
    freq.put("kur", 144);
    freq.put("kup", 64);
    freq.put("kun", 6);
    freq.put("kum", 11);
    freq.put("ain", 17);
    freq.put(" śl", 16);
    freq.put("kuc", 6);
    freq.put("kub", 3);
    freq.put(" k ", 3);
    freq.put("eną", 3);
    freq.put("jęz", 12);
    freq.put("jęc", 63);
    freq.put("enę", 6);
    freq.put("TT ", 8);
    freq.put("Zl", 5);
    freq.put("Zm", 3);
    freq.put("Zn", 17);
    freq.put("Zo", 23);
    freq.put("Gó", 3);
    freq.put("Zi", 13);
    freq.put("Zd", 20);
    freq.put("Ze", 8);
    freq.put("Zg", 7);
    freq.put("Za", 121);
    freq.put("Zb", 3);
    freq.put("wdo", 6);
    freq.put("fé ", 3);
    freq.put("wdy", 3);
    freq.put("wdz", 37);
    freq.put("Zw", 7);
    freq.put("Zr", 9);
    freq.put("ku ", 224);
    freq.put("tu", 395);
    freq.put("Kom", 10);
    freq.put("Kol", 16);
    freq.put("Kon", 15);
    freq.put("Koc", 16);
    freq.put("Kob", 4);
    freq.put("Kog", 3);
    freq.put("Kos", 8);
    freq.put("Kor", 12);
    freq.put("Kot", 3);
    freq.put("m ", 3147);
    freq.put("zmy", 9);
    freq.put("Gł", 10);
    freq.put("me", 310);
    freq.put("mg", 12);
    freq.put("mf", 3);
    freq.put("ma", 1232);
    freq.put("ltu", 6);
    freq.put("mc", 23);
    freq.put("mb", 36);
    freq.put("mm", 45);
    freq.put("ml", 13);
    freq.put("mo", 843);
    freq.put("mn", 457);
    freq.put("mi", 1588);
    freq.put("mk", 33);
    freq.put("mu", 413);
    freq.put("żko", 11);
    freq.put("mw", 6);
    freq.put("mp", 144);
    freq.put("ms", 40);
    freq.put("żki", 9);
    freq.put("ta", 1772);
    freq.put("my", 534);
    freq.put("żka", 11);
    freq.put("użo", 36);
    freq.put("użb", 3);
    freq.put("muł", 4);
    freq.put("uże", 13);
    freq.put("rć ", 3);
    freq.put("uży", 37);
    freq.put("wdę", 31);
    freq.put("kuł", 9);
    freq.put(" kł", 7);
    freq.put("ena", 59);
    freq.put("enc", 49);
    freq.put("end", 49);
    freq.put("ene", 33);
    freq.put("eng", 4);
    freq.put("eni", 394);
    freq.put("enk", 47);
    freq.put("enn", 40);
    freq.put("eno", 15);
    freq.put("jęć", 13);
    freq.put("ens", 25);
    freq.put("ent", 169);
    freq.put("enu", 6);
    freq.put("eny", 14);
    freq.put("enz", 4);
    freq.put("ON ", 7);
    freq.put("Zł", 5);
    freq.put(" dł", 33);
    freq.put("II ", 11);
    freq.put("en ", 178);
    freq.put(" ką", 4);
    freq.put("jęł", 3);
    freq.put("mó", 180);
    freq.put("wdź", 3);
    freq.put("UK ", 5);
    freq.put("toś", 55);
    freq.put(" Hu", 11);
    freq.put(" Hi", 18);
    freq.put(" Ho", 26);
    freq.put(" Hm", 7);
    freq.put(" Ha", 61);
    freq.put("ius", 6);
    freq.put(" He", 23);
    freq.put("ima", 14);
    freq.put("ime", 6);
    freq.put("imi", 48);
    freq.put("cle", 3);
    freq.put("imm", 3);
    freq.put("imo", 15);
    freq.put("imn", 15);
    freq.put("imp", 16);
    freq.put("ims", 6);
    freq.put("imu", 3);
    freq.put("Heh", 4);
    freq.put("imy", 22);
    freq.put("JA ", 12);
    freq.put("SA ", 16);
    freq.put("wsc", 12);
    freq.put(" H ", 3);
    freq.put("im ", 172);
    freq.put("hyh", 4);
    freq.put("Hej", 3);
    freq.put("wę", 33);
    freq.put("raż", 32);
    freq.put("raź", 9);
    freq.put("gol", 17);
    freq.put("goo", 7);
    freq.put("gon", 5);
    freq.put("rał", 41);
    freq.put("męż", 7);
    freq.put("ajp", 18);
    freq.put("god", 118);
    freq.put("ajr", 13);
    freq.put("ajs", 15);
    freq.put("ajt", 6);
    freq.put("aju", 9);
    freq.put("ajw", 19);
    freq.put(" dż", 3);
    freq.put("ajl", 49);
    freq.put("ajm", 45);
    freq.put("ajn", 83);
    freq.put("ajo", 20);
    freq.put("got", 28);
    freq.put("gow", 23);
    freq.put("ajc", 29);
    freq.put("ajd", 33);
    freq.put("gop", 3);
    freq.put("gos", 18);
    freq.put("gor", 39);
    freq.put("W", 662);
    freq.put("rać", 34);
    freq.put("Vid", 3);
    freq.put("go ", 770);
    freq.put("aj ", 218);
    freq.put(" Sp", 75);
    freq.put("bsł", 6);
    freq.put("nho", 3);
    freq.put("imś", 7);
    freq.put("tor", 121);
    freq.put("tos", 18);
    freq.put("top", 37);
    freq.put("tow", 145);
    freq.put("tot", 11);
    freq.put("tou", 3);
    freq.put("toj", 12);
    freq.put("tok", 11);
    freq.put("lęg", 4);
    freq.put("ton", 18);
    freq.put("tol", 15);
    freq.put("tom", 18);
    freq.put("tob", 18);
    freq.put("toc", 8);
    freq.put("toa", 4);
    freq.put("tog", 8);
    freq.put("tod", 5);
    freq.put("toe", 3);
    freq.put("ace", 48);
    freq.put("lę ", 49);
    freq.put("to ", 1148);
    freq.put("raf", 52);
    freq.put("rag", 19);
    freq.put("rad", 71);
    freq.put("Vi", 9);
    freq.put("rab", 19);
    freq.put("rac", 183);
    freq.put("raa", 3);
    freq.put("ran", 158);
    freq.put("ral", 40);
    freq.put("ram", 95);
    freq.put("raj", 87);
    freq.put("rak", 92);
    freq.put("thr", 3);
    freq.put("lba", 3);
    freq.put("raw", 224);
    freq.put("rat", 93);
    freq.put("rau", 3);
    freq.put("ras", 101);
    freq.put("ań ", 18);
    freq.put("lbi", 21);
    freq.put("raz", 348);
    freq.put("lbo", 48);
    freq.put("męs", 3);
    freq.put("cyt", 13);
    freq.put("Syn", 3);
    freq.put("Sym", 3);
    freq.put("Syl", 5);
    freq.put("cyz", 6);
    freq.put("męc", 8);
    freq.put("aję", 24);
    freq.put("ańs", 38);
    freq.put("ra ", 266);
    freq.put("bst", 3);
    freq.put("bso", 4);
    freq.put("ańc", 13);
    freq.put("bsk", 4);
    freq.put("bse", 6);
    freq.put("bsa", 5);
    freq.put("epe", 6);
    freq.put("AS ", 4);
    freq.put("mę ", 11);
    freq.put("cyf", 5);
    freq.put("pkt", 5);
    freq.put("cyk", 4);
    freq.put("pka", 6);
    freq.put("cyj", 32);
    freq.put("Up", 3);
    freq.put("pki", 8);
    freq.put("pko", 3);
    freq.put("oci", 73);
    freq.put("Bio", 4);
    freq.put("Bil", 5);
    freq.put("ocj", 16);
    freq.put("ocl", 4);
    freq.put(" mł", 9);
    freq.put("ocn", 19);
    freq.put("oca", 12);
    freq.put("łus", 4);
    freq.put("łup", 34);
    freq.put("Bie", 31);
    freq.put("oce", 18);
    freq.put("Bia", 11);
    freq.put("łuj", 12);
    freq.put("ocz", 156);
    freq.put("łum", 14);
    freq.put("łuc", 51);
    freq.put("Bir", 4);
    freq.put("ług", 38);
    freq.put("łud", 6);
    freq.put("rn ", 4);
    freq.put("Aaa", 3);
    freq.put("é ", 4);
    freq.put(" mą", 6);
    freq.put("oc ", 37);
    freq.put("łu ", 25);
    freq.put(" mę", 14);
    freq.put("nut", 34);
    freq.put("Pew", 8);
    freq.put("nus", 6);
    freq.put("Per", 6);
    freq.put("num", 15);
    freq.put("nuj", 19);
    freq.put("nud", 24);
    freq.put("nua", 6);
    freq.put("mut", 4);
    freq.put("mus", 111);
    freq.put("mur", 17);
    freq.put("muz", 21);
    freq.put("muc", 4);
    freq.put("mul", 11);
    freq.put("mun", 15);
    freq.put("muj", 27);
    freq.put("zba", 6);
    freq.put("XD ", 30);
    freq.put("zbo", 3);
    freq.put("zbl", 4);
    freq.put("zbi", 23);
    freq.put("zbu", 5);
    freq.put("zbr", 5);
    freq.put("Exp", 3);
    freq.put("yba", 129);
    freq.put("na ", 1624);
    freq.put("zby", 10);
    freq.put("mu ", 186);
    freq.put("elc", 7);
    freq.put("kwa", 11);
    freq.put(" me", 103);
    freq.put(" mg", 4);
    freq.put("kwe", 7);
    freq.put(" ma", 798);
    freq.put(" ml", 11);
    freq.put(" mm", 10);
    freq.put(" mn", 352);
    freq.put(" mo", 559);
    freq.put(" mi", 750);
    freq.put(" mu", 167);
    freq.put(" mr", 7);
    freq.put(" my", 101);
    freq.put("łuż", 18);
    freq.put("Gal", 6);
    freq.put(" m ", 23);
    freq.put("Cra", 3);
    freq.put("TV ", 14);
    freq.put("Że ", 3);
    freq.put("Ę ", 14);
    freq.put("n", 12784);
    freq.put(" ef", 5);
    freq.put("muś", 5);
    freq.put(" mó", 144);
    freq.put("Ć ", 7);
    freq.put("wać", 107);
    freq.put("Peł", 3);
    freq.put("lcz", 9);
    freq.put("lce", 7);
    freq.put("rą ", 22);
    freq.put("elk", 40);
    freq.put("eli", 115);
    freq.put("eln", 19);
    freq.put("elo", 32);
    freq.put("ell", 15);
    freq.put("elb", 24);
    freq.put("ę ", 2193);
    freq.put("ela", 52);
    freq.put("elg", 5);
    freq.put("eld", 7);
    freq.put("ele", 139);
    freq.put("yw ", 5);
    freq.put("els", 33);
    freq.put("elu", 15);
    freq.put("rąz", 4);
    freq.put("D", 1116);
    freq.put("Słu", 10);
    freq.put("gię", 5);
    freq.put("gią", 3);
    freq.put("Sła", 3);
    freq.put("rąb", 3);
    freq.put("rąc", 14);
    freq.put("Sło", 5);
    freq.put("rąd", 3);
    freq.put("IO ", 5);
    freq.put("ęk", 134);
    freq.put("ęl", 4);
    freq.put("ęc", 221);
    freq.put("ęb", 15);
    freq.put("ęd", 289);
    freq.put("ęg", 20);
    freq.put("ęz", 14);
    freq.put("ywc", 3);
    freq.put("ywa", 112);
    freq.put("ywo", 20);
    freq.put("ywn", 23);
    freq.put("ęs", 35);
    freq.put("ywk", 6);
    freq.put("ęt", 90);
    freq.put("ywi", 71);
    freq.put(" Ju", 79);
    freq.put(" Jo", 31);
    freq.put(" Je", 124);
    freq.put(" Ja", 217);
    freq.put("ick", 30);
    freq.put("icj", 30);
    freq.put("ici", 29);
    freq.put("ich", 150);
    freq.put("ico", 18);
    freq.put("ica", 35);
    freq.put("ice", 70);
    freq.put("cny", 11);
    freq.put("icz", 134);
    freq.put("icy", 39);
    freq.put("Hi", 18);
    freq.put("nż", 7);
    freq.put("Ho", 28);
    freq.put("Hm", 7);
    freq.put("cno", 10);
    freq.put("Ha", 61);
    freq.put("He", 24);
    freq.put("pyt", 51);
    freq.put("ną", 144);
    freq.put("nę", 100);
    freq.put("ęp", 53);
    freq.put("tią", 3);
    freq.put(" J ", 14);
    freq.put("nną", 4);
    freq.put("ic ", 128);
    freq.put("nnę", 4);
    freq.put("H ", 23);
    freq.put("dę ", 197);
    freq.put("aha", 378);
    freq.put("ppe", 17);
    freq.put("ahh", 27);
    freq.put("ęć", 31);
    freq.put("ppl", 9);
    freq.put("ppy", 4);
    freq.put("git", 3);
    freq.put("gis", 3);
    freq.put("gir", 5);
    freq.put("gie", 56);
    freq.put("gic", 10);
    freq.put("Głó", 4);
    freq.put("gia", 18);
    freq.put("gio", 3);
    freq.put("gin", 11);
    freq.put("gim", 12);
    freq.put("nó", 63);
    freq.put("gii", 10);
    freq.put("ah ", 48);
    freq.put("pp ", 6);
    freq.put("ń", 330);
    freq.put("ęł", 52);
    freq.put("ęś", 42);
    freq.put("elę", 9);
    freq.put("Vol", 4);
    freq.put("ęż", 33);
    freq.put("gi ", 65);
    freq.put("nno", 9);
    freq.put("nni", 37);
    freq.put("nne", 41);
    freq.put("nna", 29);
    freq.put("nny", 44);
    freq.put("nh", 5);
    freq.put("ni", 4735);
    freq.put("nj", 5);
    freq.put("nk", 250);
    freq.put("nl", 9);
    freq.put("nm", 3);
    freq.put("tiz", 3);
    freq.put("no", 915);
    freq.put("na", 2923);
    freq.put("nb", 4);
    freq.put("tiw", 15);
    freq.put("nd", 240);
    freq.put("ne", 901);
    freq.put("nf", 65);
    freq.put("ng", 116);
    freq.put("ny", 650);
    freq.put("nz", 10);
    freq.put("tio", 7);
    freq.put("tii", 6);
    freq.put("tik", 4);
    freq.put("np", 13);
    freq.put("tie", 4);
    freq.put("nr", 5);
    freq.put("ns", 126);
    freq.put("nt", 359);
    freq.put("nu", 145);
    freq.put("nv", 3);
    freq.put("nw", 12);
    freq.put("óst", 5);
    freq.put("icą", 5);
    freq.put("nn ", 7);
    freq.put("sql", 3);
    freq.put("n ", 613);
    freq.put("roi", 6);
    freq.put("roj", 30);
    freq.put("Ci ", 39);
    freq.put("rol", 27);
    freq.put("yją", 10);
    freq.put("ron", 110);
    freq.put("roo", 5);
    freq.put("rob", 219);
    freq.put("roc", 97);
    freq.put("rod", 135);
    freq.put("rof", 23);
    freq.put("rog", 46);
    freq.put("roz", 168);
    freq.put("mg ", 6);
    freq.put("llo", 25);
    freq.put("rop", 42);
    freq.put("yję", 7);
    freq.put("lla", 14);
    freq.put("Hu", 11);
    freq.put("rot", 38);
    freq.put("lle", 24);
    freq.put("row", 155);
    freq.put("ęte", 11);
    freq.put("Dal", 4);
    freq.put("Dam", 5);
    freq.put("Daj", 4);
    freq.put("Daw", 4);
    freq.put("Dar", 8);
    freq.put("Cia", 3);
    freq.put("Cie", 71);
    freq.put("kle", 34);
    freq.put("ro ", 178);
    freq.put("Cit", 8);
    freq.put("yjś", 9);
    freq.put("jde", 5);
    freq.put("gą ", 19);
    freq.put("ict", 9);
    freq.put("Res", 5);
    freq.put("Rep", 4);
    freq.put("kli", 34);
    freq.put("Rek", 3);
    freq.put("Ren", 3);
    freq.put("Rel", 3);
    freq.put("Rem", 3);
    freq.put("Reb", 3);
    freq.put("Rea", 7);
    freq.put("Red", 8);
    freq.put("łsz", 4);
    freq.put("Mił", 6);
    freq.put(" oł", 3);
    freq.put("cę ", 57);
    freq.put(" oś", 5);
    freq.put("Age", 3);
    freq.put("deo", 15);
    freq.put("Mil", 14);
    freq.put("mną", 20);
    freq.put("Mię", 3);
    freq.put("jdr", 4);
    freq.put("tąd", 3);
    freq.put("otą", 3);
    freq.put("roż", 6);
    freq.put("yj ", 20);
    freq.put("otę", 16);
    freq.put("mst", 6);
    freq.put("roń", 7);
    freq.put("Ogl", 6);
    freq.put("roś", 15);
    freq.put("msk", 5);
    freq.put("Cię", 28);
    freq.put("msa", 3);
    freq.put("ngs", 3);
    freq.put("yja", 29);
    freq.put("yjd", 19);
    freq.put("yje", 47);
    freq.put("yjn", 38);
    freq.put("Mic", 7);
    freq.put("ms ", 15);
    freq.put(" on", 113);
    freq.put(" oo", 24);
    freq.put(" ol", 3);
    freq.put(" om", 13);
    freq.put(" oj", 28);
    freq.put(" ok", 124);
    freq.put(" oh", 6);
    freq.put("Min", 14);
    freq.put(" of", 29);
    freq.put(" og", 137);
    freq.put(" od", 386);
    freq.put(" ob", 177);
    freq.put(" oc", 63);
    freq.put(" oz", 8);
    freq.put(" ow", 16);
    freq.put(" ot", 35);
    freq.put("kyp", 4);
    freq.put(" or", 31);
    freq.put(" os", 110);
    freq.put(" op", 75);
    freq.put(" oO", 6);
    freq.put("msó", 3);
    freq.put("Ogó", 3);
    freq.put("Tyl", 19);
    freq.put("Mi ", 5);
    freq.put("ky ", 3);
    freq.put(" o ", 357);
    freq.put("iPa", 3);
    freq.put("VP ", 5);
    freq.put("ś", 1718);
    freq.put("iał", 402);
    freq.put("Zie", 5);
    freq.put("Zio", 7);
    freq.put("Ksi", 3);
    freq.put("gła", 27);
    freq.put("iaż", 23);
    freq.put("LP ", 3);
    freq.put("iać", 21);
    freq.put(" we", 98);
    freq.put("ała", 504);
    freq.put("qu", 8);
    freq.put("tą ", 46);
    freq.put("aż ", 66);
    freq.put("anż", 4);
    freq.put("EN ", 7);
    freq.put("ejm", 26);
    freq.put("ejn", 35);
    freq.put("ejo", 8);
    freq.put("ejj", 4);
    freq.put("ejk", 12);
    freq.put("ejd", 14);
    freq.put("eje", 60);
    freq.put("eja", 21);
    freq.put("ejb", 7);
    freq.put("dże", 6);
    freq.put("eju", 6);
    freq.put("ejr", 35);
    freq.put("ejs", 115);
    freq.put("ójc", 7);
    freq.put("jwy", 5);
    freq.put("ej ", 767);
    freq.put("jwi", 10);
    freq.put("dpi", 14);
    freq.put("jwa", 5);
    freq.put(" wy", 600);
    freq.put("prę", 5);
    freq.put("anę", 8);
    freq.put("hu ", 19);
    freq.put("pró", 25);
    freq.put("anó", 19);
    freq.put("iam", 84);
    freq.put("ial", 108);
    freq.put("ian", 66);
    freq.put("iak", 30);
    freq.put("iaj", 100);
    freq.put("iad", 121);
    freq.put("iag", 15);
    freq.put("iaa", 6);
    freq.put("iac", 44);
    freq.put("iab", 3);
    freq.put("iaz", 23);
    freq.put("iat", 104);
    freq.put("ias", 53);
    freq.put("iar", 36);
    freq.put("hud", 3);
    freq.put("hue", 7);
    freq.put("hug", 3);
    freq.put("hum", 15);
    freq.put("huj", 21);
    freq.put("Od ", 12);
    freq.put("SE ", 12);
    freq.put("Lig", 10);
    freq.put("ia ", 554);
    freq.put("r", 9760);
    freq.put("pre", 79);
    freq.put("ane", 118);
    freq.put("ang", 40);
    freq.put("pra", 318);
    freq.put("ana", 129);
    freq.put("ć", 1238);
    freq.put("anc", 43);
    freq.put("pro", 234);
    freq.put("ano", 76);
    freq.put("pri", 4);
    freq.put("ani", 542);
    freq.put("ank", 65);
    freq.put("ant", 33);
    freq.put("lów", 3);
    freq.put("ejś", 15);
    freq.put("pry", 20);
    freq.put("any", 108);
    freq.put("anz", 4);
    freq.put("prz", 745);
    freq.put(" L ", 3);
    freq.put("GO ", 6);
    freq.put("AJ ", 5);
    freq.put("Wys", 23);
    freq.put("Wyp", 3);
    freq.put("eją", 9);
    freq.put("Wyg", 10);
    freq.put("Wyd", 7);
    freq.put("Wyc", 7);
    freq.put("eję", 25);
    freq.put("Wyn", 4);
    freq.put("Wyk", 5);
    freq.put("Wyj", 4);
    freq.put(" Le", 64);
    freq.put(" La", 30);
    freq.put(" Lo", 28);
    freq.put(" Li", 47);
    freq.put(" Lu", 38);
    freq.put("poż", 10);
    freq.put("tke", 3);
    freq.put("tka", 81);
    freq.put("tkn", 6);
    freq.put("tko", 105);
    freq.put("ędą", 26);
    freq.put("tki", 124);
    freq.put("tku", 24);
    freq.put("ędę", 61);
    freq.put("nli", 6);
    freq.put("dy ", 235);
    freq.put("ss ", 13);
    freq.put("poś", 15);
    freq.put("poł", 27);
    freq.put("dyt", 4);
    freq.put("H", 188);
    freq.put("dyw", 6);
    freq.put("dyr", 4);
    freq.put("dys", 31);
    freq.put("dym", 16);
    freq.put("sso", 3);
    freq.put("ssi", 8);
    freq.put("dyk", 13);
    freq.put("dyd", 8);
    freq.put("ssa", 8);
    freq.put("dyb", 26);
    freq.put("dyc", 20);
    freq.put("Dże", 3);
    freq.put("lny", 54);
    freq.put("rmu", 10);
    freq.put("rmy", 6);
    freq.put("jśc", 9);
    freq.put("lno", 26);
    freq.put("rma", 74);
    freq.put("lni", 96);
    freq.put("tkó", 15);
    freq.put("rme", 4);
    freq.put("lne", 44);
    freq.put("rmi", 13);
    freq.put("lna", 23);
    freq.put("rmo", 16);
    freq.put("tna", 9);
    freq.put("ocy", 18);
    freq.put("jś ", 3);
    freq.put("rm ", 7);
    freq.put("ln ", 4);
    freq.put("poz", 82);
    freq.put("pow", 252);
    freq.put("pot", 127);
    freq.put("pou", 6);
    freq.put("por", 98);
    freq.put("pos", 95);
    freq.put("pop", 71);
    freq.put("pon", 47);
    freq.put("poo", 13);
    freq.put("pol", 148);
    freq.put("pom", 126);
    freq.put("poj", 62);
    freq.put("pok", 107);
    freq.put("poi", 6);
    freq.put("pog", 38);
    freq.put("pod", 248);
    freq.put("poc", 91);
    freq.put("WA ", 14);
    freq.put("Bud", 10);
    freq.put("dyż", 3);
    freq.put("Zam", 6);
    freq.put("po ", 179);
    freq.put("ędn", 6);
    freq.put("dyś", 33);
    freq.put("ęde", 3);
    freq.put("ędz", 177);
    freq.put("dyń", 4);
    freq.put("ędu", 5);
    freq.put("tkę", 11);
    freq.put("oku", 65);
    freq.put("lu ", 70);
    freq.put("yl", 370);
    freq.put("I ", 140);
    freq.put("Iz", 4);
    freq.put("lnę", 5);
    freq.put("nn", 178);
    freq.put("jść", 17);
    freq.put("Iv", 4);
    freq.put("yhy", 5);
    freq.put("Im", 5);
    freq.put("Il", 6);
    freq.put("In", 37);
    freq.put("Ia", 3);
    freq.put("oke", 27);
    freq.put("Id", 18);
    freq.put("nc", 160);
    freq.put("oki", 31);
    freq.put(" wą", 11);
    freq.put("tis", 6);
    freq.put("tim", 3);
    freq.put("tin", 41);
    freq.put("yc", 657);
    freq.put("ES ", 5);
    freq.put("PiS", 19);
    freq.put("już", 223);
    freq.put("ożs", 3);
    freq.put("Pin", 3);
    freq.put("Pio", 13);
    freq.put("oży", 22);
    freq.put("Pie", 31);
    freq.put("tia", 12);
    freq.put("oże", 171);
    freq.put("tic", 5);
    freq.put("ożl", 11);
    freq.put("ożn", 51);
    freq.put("wbi", 8);
    freq.put("Kur", 25);
    freq.put("Kup", 12);
    freq.put("alt", 4);
    freq.put("Kul", 5);
    freq.put("Zgo", 3);
    freq.put("Kub", 7);
    freq.put("o ", 5620);
    freq.put(" wę", 5);
    freq.put("oO", 6);
    freq.put("uTu", 4);
    freq.put("oo", 260);
    freq.put("on", 1023);
    freq.put("om", 603);
    freq.put("ol", 882);
    freq.put("ok", 491);
    freq.put("oj", 447);
    freq.put("oi", 115);
    freq.put("oh", 30);
    freq.put("og", 503);
    freq.put("of", 75);
    freq.put("oe", 24);
    freq.put("od", 1308);
    freq.put("oc", 567);
    freq.put("ob", 990);
    freq.put("oa", 16);
    freq.put("oz", 393);
    freq.put("oy", 8);
    freq.put("ox", 7);
    freq.put("ow", 1742);
    freq.put("ov", 20);
    freq.put("ou", 67);
    freq.put("ot", 509);
    freq.put("os", 837);
    freq.put("or", 821);
    freq.put("op", 339);
    freq.put("LE ", 6);
    freq.put("ju ", 38);
    freq.put("Pię", 6);
    freq.put("FB ", 5);
    freq.put("ehu", 4);
    freq.put("EL ", 3);
    freq.put("ehe", 9);
    freq.put("ehh", 9);
    freq.put("Jut", 23);
    freq.put("Pił", 6);
    freq.put("jum", 6);
    freq.put("jus", 3);
    freq.put("jut", 72);
    freq.put("juz", 35);
    freq.put("Źr", 3);
    freq.put("kło", 8);
    freq.put("kła", 80);
    freq.put("kły", 8);
    freq.put("eh ", 7);
    freq.put("ści", 290);
    freq.put("oć", 11);
    freq.put("igu", 5);
    freq.put("igr", 3);
    freq.put("ige", 5);
    freq.put("igd", 34);
    freq.put("nkę", 19);
    freq.put("iga", 11);
    freq.put("ota", 44);
    freq.put("ign", 7);
    freq.put("igi", 12);
    freq.put("igh", 12);
    freq.put("cb ", 7);
    freq.put("hwi", 16);
    freq.put("oń", 109);
    freq.put("Jak", 93);
    freq.put("oł", 143);
    freq.put("hwa", 15);
    freq.put("oś", 475);
    freq.put("hwy", 7);
    freq.put("oty", 52);
    freq.put("oż", 264);
    freq.put("oź", 4);
    freq.put("ig ", 6);
    freq.put("pto", 14);
    freq.put("alo", 55);
    freq.put("all", 21);
    freq.put("alk", 22);
    freq.put("ość", 99);
    freq.put("ali", 209);
    freq.put("ald", 7);
    freq.put("ale", 573);
    freq.put("alb", 56);
    freq.put("alc", 10);
    freq.put("ala", 152);
    freq.put("rok", 76);
    freq.put("pty", 5);
    freq.put("aly", 13);
    freq.put("alw", 3);
    freq.put("fa ", 8);
    freq.put("alu", 29);
    freq.put("als", 14);
    freq.put("rom", 36);
    freq.put("zł ", 30);
    freq.put("mś ", 11);
    freq.put("wró", 36);
    freq.put("faz", 5);
    freq.put("far", 11);
    freq.put("fas", 4);
    freq.put("al ", 109);
    freq.put("pt ", 5);
    freq.put("faj", 54);
    freq.put("fak", 18);
    freq.put("uwi", 26);
    freq.put("fan", 42);
    freq.put("llu", 3);
    freq.put("fal", 8);
    freq.put("fab", 3);
    freq.put("fac", 14);
    freq.put("uwa", 44);
    freq.put("nił", 20);
    freq.put(" Ni", 241);
    freq.put("złe", 12);
    freq.put(" No", 145);
    freq.put(" Na", 150);
    freq.put(" Ne", 16);
    freq.put("rkę", 7);
    freq.put("rką", 3);
    freq.put(" Nu", 7);
    freq.put("zły", 15);
    freq.put("tei", 5);
    freq.put("tej", 45);
    freq.put("tek", 57);
    freq.put("tel", 90);
    freq.put("tem", 259);
    freq.put("ten", 93);
    freq.put("teo", 4);
    freq.put("tea", 5);
    freq.put("tec", 21);
    freq.put("ted", 32);
    freq.put("tef", 3);
    freq.put("teg", 166);
    freq.put("tez", 36);
    freq.put("tep", 8);
    freq.put("ter", 295);
    freq.put("tes", 22);
    freq.put("tet", 29);
    freq.put("tev", 5);
    freq.put("ówi", 93);
    freq.put("ówk", 30);
    freq.put("ros", 127);
    freq.put("suc", 8);
    freq.put("sua", 4);
    freq.put("ówn", 44);
    freq.put("sun", 13);
    freq.put("sum", 27);
    freq.put("sul", 3);
    freq.put("ówe", 6);
    freq.put("suj", 29);
    freq.put("suw", 9);
    freq.put("sus", 4);
    freq.put("sur", 5);
    freq.put("sup", 16);
    freq.put("te ", 114);
    freq.put("su ", 56);
    freq.put("ów ", 349);
    freq.put("ya ", 5);
    freq.put("mmi", 4);
    freq.put("rku", 12);
    freq.put("Tor", 6);
    freq.put("Tou", 12);
    freq.put("rke", 7);
    freq.put("rka", 37);
    freq.put("Tom", 7);
    freq.put("Tob", 10);
    freq.put("rko", 10);
    freq.put("rki", 37);
    freq.put("oś ", 213);
    freq.put("rk ", 16);
    freq.put("To ", 104);
    freq.put("ośc", 127);
    freq.put("Ek", 6);
    freq.put("Int", 6);
    freq.put("ośm", 5);
    freq.put("ośl", 5);
    freq.put("ośn", 10);
    freq.put("Inn", 3);
    freq.put("ośr", 7);
    freq.put("ośw", 6);
    freq.put("v", 194);
    freq.put("Ind", 3);
    freq.put("Inf", 14);
    freq.put("Eg", 3);
    freq.put("też", 124);
    freq.put("Ec", 4);
    freq.put("dź ", 40);
    freq.put("Łod", 3);
    freq.put("oys", 3);
    freq.put("teś", 61);
    freq.put("Gli", 4);
    freq.put("Glo", 3);
    freq.put("Gle", 3);
    freq.put("Akt", 4);
    freq.put("Ew", 5);
    freq.put("dźc", 3);
    freq.put("goł", 3);
    freq.put("ęzy", 12);
    freq.put("dźm", 3);
    freq.put("oy ", 3);
    freq.put("Ocz", 8);
    freq.put("ćw", 7);
    freq.put("ll ", 32);
    freq.put("yn ", 21);
    freq.put("cóż", 9);
    freq.put("ćm", 5);
    freq.put("óz", 18);
    freq.put("L", 257);
    freq.put("kże", 14);
    freq.put("Raf", 5);
    freq.put("ynn", 5);
    freq.put("yno", 10);
    freq.put("yni", 60);
    freq.put("ynk", 21);
    freq.put("yne", 18);
    freq.put("yna", 83);
    freq.put("yny", 18);
    freq.put("Rap", 5);
    freq.put("ć ", 1192);
    freq.put("ynt", 3);
    freq.put("ynu", 13);
    freq.put("yns", 3);
    freq.put("Raz", 6);
    freq.put("Ray", 3);
    freq.put(" sz", 287);
    freq.put(" sy", 41);
    freq.put("Mus", 21);
    freq.put(" sr", 12);
    freq.put(" sp", 356);
    freq.put(" sq", 3);
    freq.put(" sw", 100);
    freq.put(" st", 320);
    freq.put(" su", 69);
    freq.put(" sk", 130);
    freq.put(" sh", 10);
    freq.put(" si", 1151);
    freq.put(" sn", 9);
    freq.put(" so", 154);
    freq.put(" sl", 25);
    freq.put(" sm", 39);
    freq.put(" sb", 4);
    freq.put(" sc", 17);
    freq.put("gul", 7);
    freq.put(" se", 156);
    freq.put("iza", 22);
    freq.put("ize", 9);
    freq.put("ój", 121);
    freq.put("izj", 8);
    freq.put("izm", 10);
    freq.put("izn", 7);
    freq.put("izo", 21);
    freq.put("izu", 10);
    freq.put("goś", 40);
    freq.put("izy", 21);
    freq.put("koh", 4);
    freq.put("SZ ", 11);
    freq.put("kok", 6);
    freq.put("kom", 132);
    freq.put(" s ", 12);
    freq.put("aa ", 64);
    freq.put("iz ", 9);
    freq.put("kon", 194);
    freq.put("koa", 4);
    freq.put("wla", 26);
    freq.put("koc", 74);
    freq.put("kob", 13);
    freq.put("yną", 5);
    freq.put("ans", 49);
    freq.put("ynę", 4);
    freq.put("nag", 31);
    freq.put("lik", 62);
    freq.put("ązu", 4);
    freq.put("ązo", 3);
    freq.put("ązk", 9);
    freq.put("ców", 22);
    freq.put("ąza", 11);
    freq.put("cór", 3);
    freq.put("kop", 16);
    freq.put("kos", 39);
    freq.put("kor", 51);
    freq.put("i", 21371);
    freq.put(" er", 3);
    freq.put(" ćw", 7);
    freq.put("js ", 6);
    freq.put("EJ ", 5);
    freq.put("efu", 3);
    freq.put("efi", 5);
    freq.put("efo", 34);
    freq.put(" sł", 131);
    freq.put("efa", 3);
    freq.put("efe", 8);
    freq.put("jsc", 37);
    freq.put("jsi", 4);
    freq.put("jsk", 14);
    freq.put("jst", 7);
    freq.put("jsz", 66);
    freq.put("Kwa", 4);
    freq.put(" są", 91);
    freq.put("rte", 25);
    freq.put("aró", 10);
    freq.put("rta", 29);
    freq.put("rtm", 5);
    freq.put("rto", 29);
    freq.put("rti", 10);
    freq.put("rth", 6);
    freq.put("rtk", 13);
    freq.put("rtu", 18);
    freq.put("rtw", 12);
    freq.put("rty", 41);
    freq.put("iez", 51);
    freq.put("Ju", 79);
    freq.put("ies", 279);
    freq.put("ier", 449);
    freq.put("ieu", 4);
    freq.put("iet", 70);
    freq.put("iew", 110);
    freq.put("iev", 14);
    freq.put("iei", 4);
    freq.put("iek", 174);
    freq.put("iej", 457);
    freq.put("duż", 46);
    freq.put("iel", 208);
    freq.put("ieo", 3);
    freq.put("ien", 222);
    freq.put("Je", 124);
    freq.put("iec", 319);
    freq.put("ieb", 118);
    freq.put("iee", 22);
    freq.put("ied", 322);
    freq.put("ieg", 175);
    freq.put("hip", 7);
    freq.put("his", 21);
    freq.put("hit", 6);
    freq.put("rt ", 55);
    freq.put("pę", 12);
    freq.put("Czy", 41);
    freq.put("pą", 5);
    freq.put("hih", 3);
    freq.put("hil", 6);
    freq.put("hin", 11);
    freq.put(" Pó", 6);
    freq.put("ie ", 4324);
    freq.put("J ", 30);
    freq.put("arp", 3);
    freq.put("arr", 14);
    freq.put("ars", 83);
    freq.put("art", 140);
    freq.put("aru", 12);
    freq.put("arw", 5);
    freq.put("ary", 37);
    freq.put("arz", 154);
    freq.put("ara", 111);
    freq.put("arb", 15);
    freq.put("arc", 64);
    freq.put("ard", 158);
    freq.put("are", 70);
    freq.put("arg", 11);
    freq.put("ari", 38);
    freq.put("będ", 216);
    freq.put("ark", 48);
    freq.put("arl", 6);
    freq.put("uu ", 15);
    freq.put("arn", 85);
    freq.put("aro", 59);
    freq.put("Ł ", 4);
    freq.put(" P ", 35);
    freq.put("uuu", 35);
    freq.put("ar ", 22);
    freq.put("fga", 3);
    freq.put("bę ", 6);
    freq.put("Ła", 8);
    freq.put(" Pr", 177);
    freq.put("c", 8939);
    freq.put(" Pu", 15);
    freq.put("rię", 4);
    freq.put("Coś", 5);
    freq.put("źć", 9);
    freq.put("Ło", 6);
    freq.put(" Pa", 112);
    freq.put("Łu", 3);
    freq.put(" Pe", 29);
    freq.put(" Pi", 93);
    freq.put(" Ph", 4);
    freq.put(" Po", 356);
    freq.put(" Pl", 19);
    freq.put("ieś", 67);
    freq.put("ieł", 4);
    freq.put("ień", 78);
    freq.put("pr", 1435);
    freq.put("ps", 125);
    freq.put("duj", 15);
    freq.put("duk", 16);
    freq.put("dum", 6);
    freq.put("dun", 3);
    freq.put("pu", 131);
    freq.put("swa", 4);
    freq.put("px", 4);
    freq.put("py", 84);
    freq.put("swe", 8);
    freq.put("pc", 38);
    freq.put("duz", 9);
    freq.put("pa", 563);
    freq.put("pf", 10);
    freq.put("pe", 298);
    freq.put("dup", 20);
    freq.put("pk", 27);
    freq.put("dur", 7);
    freq.put("pi", 883);
    freq.put("pn", 69);
    freq.put("po", 1856);
    freq.put("pl", 196);
    freq.put("spę", 3);
    freq.put("Emi", 3);
    freq.put("Emp", 3);
    freq.put("Fac", 11);
    freq.put("Uwa", 3);
    freq.put("ieć", 66);
    freq.put("du ", 75);
    freq.put("p ", 144);
    freq.put("hiń", 5);
    freq.put("rtę", 3);
    freq.put("źl", 32);
    freq.put("źm", 4);
    freq.put("źn", 32);
    freq.put("rix", 3);
    freq.put("riv", 3);
    freq.put("rit", 3);
    freq.put("riu", 10);
    freq.put("ris", 15);
    freq.put("rip", 6);
    freq.put("źc", 3);
    freq.put("rin", 12);
    freq.put("Tim", 6);
    freq.put("ril", 3);
    freq.put("rik", 3);
    freq.put("rii", 14);
    freq.put("rid", 3);
    freq.put("rie", 18);
    freq.put("ric", 11);
    freq.put("ria", 46);
    freq.put("pó", 91);
    freq.put("ńci", 3);
    freq.put("ńce", 12);
    freq.put("Squ", 3);
    freq.put("ńca", 26);
    freq.put("arł", 13);
    freq.put("ńcz", 44);
    freq.put("swó", 8);
    freq.put("ńcu", 25);
    freq.put("Cor", 5);
    freq.put("ź ", 50);
    freq.put("Com", 3);
    freq.put("eku", 21);
    freq.put("ri ", 8);
    freq.put("Con", 3);
    freq.put("arę", 12);
    freq.put("arą", 6);
    freq.put(" uż", 19);
    freq.put("wną", 10);
    freq.put("wnę", 4);
    freq.put(" uł", 5);
    freq.put("Uży", 5);
    freq.put("ź", 160);
    freq.put("yl ", 14);
    freq.put("Wła", 23);
    freq.put("Też", 9);
    freq.put("Epi", 3);
    freq.put("zza", 4);
    freq.put("ylw", 5);
    freq.put("Rok", 3);
    freq.put("Rom", 4);
    freq.put("Ron", 3);
    freq.put("Rob", 12);
    freq.put("Roc", 8);
    freq.put("Rod", 3);
    freq.put("yly", 3);
    freq.put("Roz", 21);
    freq.put("yle", 37);
    freq.put("yla", 23);
    freq.put("ylo", 21);
    freq.put("Ros", 12);
    freq.put("ylk", 162);
    freq.put("Row", 3);
    freq.put("wn ", 4);
    freq.put(" uz", 13);
    freq.put(" ut", 9);
    freq.put(" uu", 7);
    freq.put(" uw", 53);
    freq.put(" up", 14);
    freq.put(" ur", 48);
    freq.put(" us", 55);
    freq.put(" ul", 33);
    freq.put(" um", 52);
    freq.put(" un", 4);
    freq.put(" uj", 11);
    freq.put(" uk", 14);
    freq.put(" ud", 55);
    freq.put(" uf", 4);
    freq.put(" ug", 4);
    freq.put(" ub", 13);
    freq.put(" uc", 53);
    freq.put("xpr", 3);
    freq.put("wna", 30);
    freq.put("wne", 49);
    freq.put("wni", 120);
    freq.put("wno", 54);
    freq.put("wny", 30);
    freq.put(" u ", 79);
    freq.put("ca ", 127);
    freq.put("ix ", 8);
    freq.put("z", 13339);
    freq.put("tpl", 3);
    freq.put(" ź", 22);
    freq.put("gru", 26);
    freq.put("grr", 3);
    freq.put("grz", 26);
    freq.put("gry", 34);
    freq.put("gre", 6);
    freq.put("gra", 172);
    freq.put("gro", 37);
    freq.put("gri", 4);
    freq.put("ódł", 3);
    freq.put("eda", 64);
    freq.put("usł", 6);
    freq.put("ede", 37);
    freq.put("edi", 23);
    freq.put("edn", 127);
    freq.put("edo", 11);
    freq.put("edl", 11);
    freq.put("edm", 5);
    freq.put("edr", 7);
    freq.put("eds", 24);
    freq.put("edw", 7);
    freq.put("edu", 7);
    freq.put("edz", 239);
    freq.put("Hal", 7);
    freq.put("edy", 190);
    freq.put("apł", 3);
    freq.put("ed ", 72);
    freq.put("óź", 19);
    freq.put("P", 1097);
    freq.put("uć ", 7);
    freq.put("włą", 9);
    freq.put("car", 5);
    freq.put("Kyu", 3);
    freq.put("rro", 8);
    freq.put("rri", 4);
    freq.put("taż", 4);
    freq.put("rre", 5);
    freq.put("rra", 5);
    freq.put("sił", 23);
    freq.put("rry", 18);
    freq.put("ojo", 3);
    freq.put("rrr", 15);
    freq.put("caj", 11);
    freq.put("taś", 4);
    freq.put("tań", 13);
    freq.put("sąd", 20);
    freq.put("tał", 79);
    freq.put("się", 854);
    freq.put("rr ", 8);
    freq.put("sić", 9);
    freq.put("sią", 45);
    freq.put("bd ", 21);
    freq.put(" Ł", 28);
    freq.put("DT ", 5);
    freq.put("tać", 42);
    freq.put("są ", 71);
    freq.put("apy", 11);
    freq.put("apr", 90);
    freq.put("aps", 5);
    freq.put("app", 8);
    freq.put("Mik", 4);
    freq.put("apt", 13);
    freq.put("apu", 3);
    freq.put("apk", 6);
    freq.put("api", 112);
    freq.put("apo", 56);
    freq.put("apl", 12);
    freq.put("wła", 103);
    freq.put("edź", 11);
    freq.put("wło", 26);
    freq.put("apa", 25);
    freq.put("ape", 21);
    freq.put("edł", 18);
    freq.put("dwó", 19);
    freq.put("use", 4);
    freq.put("afé", 3);
    freq.put("usa", 9);
    freq.put("Ope", 3);
    freq.put("uso", 3);
    freq.put("fem", 6);
    freq.put("usk", 25);
    freq.put("fek", 6);
    freq.put("usi", 75);
    freq.put("Mia", 12);
    freq.put("usu", 15);
    freq.put("ust", 71);
    freq.put("fer", 32);
    freq.put("fes", 8);
    freq.put("usp", 5);
    freq.put("usz", 154);
    freq.put("uła", 12);
    freq.put("Mie", 14);
    freq.put("wi", 1967);
    freq.put("ap ", 4);
    freq.put("px ", 4);
    freq.put(" Ru", 18);
    freq.put(" Rv", 3);
    freq.put("us ", 32);
    freq.put(" Ry", 11);
    freq.put(" Rz", 10);
    freq.put(" Re", 49);
    freq.put(" Ra", 46);
    freq.put(" Ro", 75);
    freq.put(" Ri", 15);
    freq.put(" Rh", 3);
    freq.put("tat", 86);
    freq.put("taw", 102);
    freq.put("tap", 7);
    freq.put("tar", 123);
    freq.put("tas", 19);
    freq.put("tay", 3);
    freq.put("tad", 8);
    freq.put("taa", 12);
    freq.put("tab", 12);
    freq.put("tac", 73);
    freq.put("tal", 86);
    freq.put("tam", 140);
    freq.put("tan", 144);
    freq.put("Mis", 17);
    freq.put("taj", 60);
    freq.put("tak", 485);
    freq.put("sis", 12);
    freq.put("siu", 5);
    freq.put("dwy", 3);
    freq.put("sic", 7);
    freq.put("sia", 149);
    freq.put("dwa", 33);
    freq.put("sie", 367);
    freq.put("sid", 5);
    freq.put("sik", 3);
    freq.put("dwi", 19);
    freq.put("sio", 21);
    freq.put("sin", 10);
    freq.put("sim", 6);
    freq.put("sil", 12);
    freq.put("ta ", 258);
    freq.put("Eks", 6);
    freq.put("rai", 5);
    freq.put(" Ró", 5);
    freq.put("si ", 39);
    freq.put("kby", 32);
    freq.put("byw", 9);
    freq.put("byt", 11);
    freq.put("bys", 7);
    freq.put("Dyr", 3);
    freq.put("byl", 50);
    freq.put("bym", 95);
    freq.put("jał", 3);
    freq.put("byc", 20);
    freq.put("łą", 62);
    freq.put("Car", 5);
    freq.put("Cam", 7);
    freq.put("Caf", 3);
    freq.put("Pre", 27);
    freq.put("nfe", 6);
    freq.put("Pra", 23);
    freq.put("nfo", 46);
    freq.put("Pro", 33);
    freq.put("Pri", 7);
    freq.put("nfi", 6);
    freq.put("by ", 271);
    freq.put("Prz", 87);
    freq.put("oun", 4);
    freq.put("ouc", 5);
    freq.put("ous", 4);
    freq.put("our", 19);
    freq.put("out", 9);
    freq.put("owr", 14);
    freq.put("WO ", 4);
    freq.put("ouT", 4);
    freq.put("Moz", 4);
    freq.put("ou ", 14);
    freq.put("Poł", 3);
    freq.put("g", 3101);
    freq.put("yńs", 22);
    freq.put("lta", 3);
    freq.put("K ", 47);
    freq.put("byś", 31);
    freq.put("był", 209);
    freq.put("nfę", 4);
    freq.put("ojó", 4);
    freq.put("łd", 5);
    freq.put("łe", 248);
    freq.put("ła", 1314);
    freq.put("łb", 36);
    freq.put("łc", 23);
    freq.put("łm", 5);
    freq.put("łn", 40);
    freq.put("ło", 672);
    freq.put("łi", 7);
    freq.put("łk", 59);
    freq.put("łt", 11);
    freq.put("łu", 207);
    freq.put("łp", 3);
    freq.put("łs", 4);
    freq.put("ły", 278);
    freq.put("Ka", 92);
    freq.put("Ke", 14);
    freq.put("Ki", 40);
    freq.put("Ko", 96);
    freq.put("Kn", 6);
    freq.put("Kl", 17);
    freq.put("Ks", 4);
    freq.put("Kr", 51);
    freq.put("Kw", 6);
    freq.put("Ku", 56);
    freq.put("Kt", 27);
    freq.put("być", 76);
    freq.put("Ky", 4);
    freq.put("yby", 31);
    freq.put("ł ", 550);
    freq.put("ybr", 11);
    freq.put("ybu", 4);
    freq.put("ybi", 28);
    freq.put("ybk", 24);
    freq.put("ybo", 33);
    freq.put("Cał", 9);
    freq.put("ybc", 5);
    freq.put("ybe", 3);
    freq.put("Bą", 6);
    freq.put("oga", 56);
    freq.put("łó", 58);
    freq.put("tów", 50);
    freq.put("tór", 168);
    freq.put("Po ", 35);
    freq.put("hw", 41);
    freq.put("ht", 23);
    freq.put("why", 3);
    freq.put("Poz", 40);
    freq.put("Pow", 18);
    freq.put("Pot", 15);
    freq.put("ybó", 4);
    freq.put("Por", 15);
    freq.put("Pos", 15);
    freq.put("Pop", 5);
    freq.put("Pon", 5);
    freq.put("Pol", 145);
    freq.put("Pom", 6);
    freq.put("Poj", 3);
    freq.put("Pok", 7);
    freq.put("Pog", 5);
    freq.put("Pod", 28);
    freq.put("Poc", 12);
    freq.put("Ru", 18);
    freq.put(" w ", 1104);
    freq.put("GP ", 7);
    freq.put("eat", 6);
    freq.put("tąp", 5);
    freq.put("Już", 17);
    freq.put("no ", 359);
    freq.put("Jas", 6);
    freq.put("dśw", 3);
    freq.put("zku", 17);
    freq.put(" wg", 24);
    freq.put(" wd", 4);
    freq.put("mło", 10);
    freq.put(" wb", 9);
    freq.put(" wc", 84);
    freq.put(" wa", 145);
    freq.put(" wn", 11);
    freq.put(" wo", 85);
    freq.put(" wl", 25);
    freq.put(" wk", 30);
    freq.put(" wh", 4);
    freq.put(" wi", 633);
    freq.put(" ww", 8);
    freq.put(" wt", 31);
    freq.put(" wu", 5);
    freq.put(" wr", 102);
    freq.put(" ws", 245);
    freq.put(" wp", 35);
    freq.put(" wz", 40);
    freq.put("ql", 3);
    freq.put("Ra", 49);
    freq.put("ebe", 40);
    freq.put("eba", 86);
    freq.put("ebl", 5);
    freq.put("ebn", 15);
    freq.put("ebo", 28);
    freq.put("ebi", 121);
    freq.put("ebu", 18);
    freq.put("ebr", 17);
    freq.put("ebs", 4);
    freq.put("eby", 77);
    freq.put("dla", 202);
    freq.put("Moj", 12);
    freq.put("dle", 16);
    freq.put("dli", 4);
    freq.put("dlo", 9);
    freq.put("Za ", 14);
    freq.put("Jac", 7);
    freq.put("dlu", 5);
    freq.put("eb ", 12);
    freq.put("jow", 14);
    freq.put("joj", 3);
    freq.put("jom", 16);
    freq.put("jon", 9);
    freq.put("dl ", 9);
    freq.put("Zaj", 11);
    freq.put("Zak", 4);
    freq.put("Zab", 7);
    freq.put("Zac", 11);
    freq.put(" wó", 6);
    freq.put("Zay", 5);
    freq.put("Zaw", 10);
    freq.put("Zar", 9);
    freq.put("Zas", 7);
    freq.put("Zap", 27);
    freq.put("rpr", 3);
    freq.put("rpe", 5);
    freq.put("PL ", 8);
    freq.put("rpi", 8);
    freq.put("hm ", 3);
    freq.put("rpl", 7);
    freq.put("rpn", 21);
    freq.put("bbo", 3);
    freq.put("Jul", 4);
    freq.put("Jus", 29);
    freq.put("bby", 3);
    freq.put("IE ", 38);
    freq.put(" wł", 130);
    freq.put("hmu", 15);
    freq.put("hmm", 11);
    freq.put(" wś", 6);
    freq.put("é", 7);
    freq.put("śn", 174);
    freq.put("avo", 3);
    freq.put("avi", 4);
    freq.put("ave", 7);
    freq.put("ava", 5);
    freq.put(" T ", 14);
    freq.put("lmó", 3);
    freq.put("łd ", 3);
    freq.put("ieź", 8);
    freq.put("Gwi", 4);
    freq.put(" Ty", 69);
    freq.put(" Tw", 43);
    freq.put(" Tu", 25);
    freq.put(" Tr", 47);
    freq.put("Mog", 4);
    freq.put(" To", 153);
    freq.put(" Ti", 10);
    freq.put(" Th", 16);
    freq.put(" Te", 77);
    freq.put(" Ta", 84);
    freq.put("łyż", 3);
    freq.put(" ♥", 3);
    freq.put("tch", 12);
    freq.put("ajz", 3);
    freq.put("tce", 10);
    freq.put("tca", 3);
    freq.put("sku", 44);
    freq.put("łyś", 9);
    freq.put("skr", 21);
    freq.put("Far", 4);
    freq.put("sky", 4);
    freq.put("Faj", 6);
    freq.put("Fak", 3);
    freq.put("Uwi", 5);
    freq.put("ska", 132);
    freq.put("nor", 34);
    freq.put("skl", 18);
    freq.put("sko", 105);
    freq.put("skn", 9);
    freq.put("ski", 302);
    freq.put("żdż", 8);
    freq.put("T", 642);
    freq.put("ową", 35);
    freq.put("owę", 10);
    freq.put("sk ", 25);
    freq.put("órk", 16);
    freq.put("Sup", 7);
    freq.put("myś", 92);
    freq.put("skó", 4);
    freq.put("nd ", 52);
    freq.put("ś ", 617);
    freq.put("ndN", 6);
    freq.put("ndi", 13);
    freq.put("ndk", 4);
    freq.put("ndl", 10);
    freq.put("ndo", 18);
    freq.put("nda", 26);
    freq.put("nde", 21);
    freq.put("ndy", 20);
    freq.put("ndz", 15);
    freq.put("nds", 6);
    freq.put("ndr", 24);
    freq.put("ndu", 6);
    freq.put("owl", 4);
    freq.put("owo", 99);
    freq.put("own", 56);
    freq.put("owi", 370);
    freq.put("owk", 6);
    freq.put("owe", 212);
    freq.put("ływ", 7);
    freq.put("łyt", 17);
    freq.put("owa", 497);
    freq.put("łys", 30);
    freq.put("owc", 28);
    freq.put("łyn", 4);
    freq.put("łym", 13);
    freq.put("owy", 195);
    freq.put("skł", 12);
    freq.put("owu", 48);
    freq.put("owt", 10);
    freq.put("łyc", 19);
    freq.put("ows", 67);
    freq.put("mrę", 3);
    freq.put("van", 6);
    freq.put("Te ", 8);
    freq.put("ej", 1184);
    freq.put("Ame", 3);
    freq.put("var", 3);
    freq.put("vat", 4);
    freq.put("żdy", 21);
    freq.put("skę", 4);
    freq.put("ow ", 79);
    freq.put("ską", 21);
    freq.put("żda", 3);
    freq.put("żde", 11);
    freq.put("ły ", 166);
    freq.put("Tel", 5);
    freq.put("Tem", 3);
    freq.put("Ten", 13);
    freq.put("Tea", 3);
    freq.put("va ", 4);
    freq.put("Tec", 3);
    freq.put("Tee", 4);
    freq.put("Teg", 3);
    freq.put("lve", 4);
    freq.put("Ter", 24);
    freq.put("mys", 30);
    freq.put("ndę", 3);
    freq.put("lm ", 14);
    freq.put("myk", 5);
    freq.put("myj", 3);
    freq.put("mym", 13);
    freq.put("myl", 9);
    freq.put("myc", 7);
    freq.put("owó", 5);
    freq.put("Map", 3);
    freq.put("ułę", 3);
    freq.put("zyś", 5);
    freq.put("my ", 366);
  }
  
}

