package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class PT {
  private static final String name = "pt";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public PT() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 2001858;
    n_words[1] = 2476365;
    n_words[2] = 1935786;

    freq.put("PQ ", 33);
    freq.put("Ork", 27);
    freq.put("req", 26);
    freq.put("gai", 45);
    freq.put("sn ", 351);
    freq.put("rev", 504);
    freq.put("Pel", 60);
    freq.put("bec", 28);
    freq.put("dez", 52);
    freq.put("eja", 671);
    freq.put("bob", 93);
    freq.put("MA ", 208);
    freq.put("bon", 295);
    freq.put("oçã", 92);
    freq.put("unc", 677);
    freq.put(" G ", 67);
    freq.put("mbl", 134);
    freq.put("ufi", 32);
    freq.put("Mat", 65);
    freq.put("reu", 129);
    freq.put("iár", 45);
    freq.put("téd", 46);
    freq.put("çao", 104);
    freq.put("amr", 80);
    freq.put("gad", 802);
    freq.put("tít", 24);
    freq.put("xtr", 44);
    freq.put("aui", 44);
    freq.put("awn", 62);
    freq.put("Vam", 197);
    freq.put("aum", 166);
    freq.put("âni", 51);
    freq.put("gab", 62);
    freq.put("VC ", 88);
    freq.put("fiq", 230);
    freq.put("aus", 411);
    freq.put("rei", 1064);
    freq.put("auu", 22);
    freq.put("gaa", 69);
    freq.put("xta", 237);
    freq.put("G ", 245);
    freq.put("tai", 49);
    freq.put("ére", 21);
    freq.put("uru", 21);
    freq.put("reo", 93);
    freq.put("dão", 185);
    freq.put("meç", 502);
    freq.put(" Gu", 121);
    freq.put(" Gr", 165);
    freq.put("alc", 82);
    freq.put("ídi", 24);
    freq.put("ble", 237);
    freq.put(" Ge", 167);
    freq.put("unt", 551);
    freq.put(" Ga", 359);
    freq.put("ra ", 13978);
    freq.put(" Go", 269);
    freq.put(" Gl", 82);
    freq.put("ala", 1962);
    freq.put(" Gi", 68);
    freq.put("upo", 121);
    freq.put("Gu", 124);
    freq.put("sáb", 119);
    freq.put("Gr", 166);
    freq.put("upi", 33);
    freq.put("cmg", 73);
    freq.put("The", 77);
    freq.put("OS ", 469);
    freq.put("upe", 284);
    freq.put("epr", 104);
    freq.put("upa", 234);
    freq.put("dré", 26);
    freq.put("Ok ", 35);
    freq.put("Ge", 174);
    freq.put("aas", 67);
    freq.put("Ga", 371);
    freq.put("mlk", 51);
    freq.put("Go", 271);
    freq.put("alz", 32);
    freq.put("Gl", 84);
    freq.put("lín", 25);
    freq.put("Gi", 74);
    freq.put("áre", 32);
    freq.put(" ka", 80);
    freq.put("me ", 4382);
    freq.put(" kd", 37);
    freq.put(" ke", 58);
    freq.put(" kk", 2571);
    freq.put(" ki", 112);
    freq.put("ído", 38);
    freq.put(" km", 21);
    freq.put(" kr", 22);
    freq.put(" ks", 51);
    freq.put("róp", 66);
    freq.put("és ", 61);
    freq.put("Vas", 52);
    freq.put("lbu", 31);
    freq.put("air", 554);
    freq.put("KK ", 342);
    freq.put("fér", 30);
    freq.put("nel", 171);
    freq.put("nem", 1252);
    freq.put("nej", 46);
    freq.put("neh", 104);
    freq.put("nei", 253);
    freq.put(" y ", 49);
    freq.put("neg", 235);
    freq.put("nee", 74);
    freq.put("Z ", 136);
    freq.put("p ", 899);
    freq.put("nea", 43);
    freq.put("tia", 170);
    freq.put("orv", 33);
    freq.put("abi", 234);
    freq.put("daí", 39);
    freq.put("Put", 29);
    freq.put("net", 295);
    freq.put("scr", 264);
    freq.put("ner", 192);
    freq.put("nes", 561);
    freq.put("cav", 67);
    freq.put("mee", 116);
    freq.put("À", 32);
    freq.put(" k ", 44);
    freq.put("ou ", 7698);
    freq.put("mea", 41);
    freq.put("orç", 147);
    freq.put("ws ", 56);
    freq.put("mem", 340);
    freq.put("orr", 1547);
    freq.put("íce", 21);
    freq.put("men", 3324);
    freq.put("mei", 863);
    freq.put("ors", 33);
    freq.put("meu", 2884);
    freq.put("fun", 215);
    freq.put("mes", 1547);
    freq.put("mer", 989);
    freq.put("aue", 34);
    freq.put("ícu", 30);
    freq.put("TT ", 52);
    freq.put("mex", 61);
    freq.put("aud", 533);
    freq.put("díc", 21);
    freq.put(" yn", 54);
    freq.put("glo", 52);
    freq.put("aks", 46);
    freq.put("gla", 27);
    freq.put("k", 23537);
    freq.put("dru", 65);
    freq.put("gle", 119);
    freq.put("ne ", 591);
    freq.put("dri", 118);
    freq.put("fé ", 120);
    freq.put("orm", 1236);
    freq.put("ako", 22);
    freq.put("óli", 23);
    freq.put("dro", 199);
    freq.put("tw", 728);
    freq.put("dra", 112);
    freq.put("lan", 816);
    freq.put("aka", 36);
    freq.put("dre", 102);
    freq.put("ake", 107);
    freq.put("nk ", 155);
    freq.put("Jes", 87);
    freq.put("sso", 3698);
    freq.put("Lá", 23);
    freq.put("bru", 52);
    freq.put("lmo", 244);
    freq.put("ádi", 50);
    freq.put("bro", 405);
    freq.put("tp", 56);
    freq.put("bri", 1016);
    freq.put("lma", 175);
    freq.put("uço", 24);
    freq.put("bre", 714);
    freq.put("cm ", 64);
    freq.put("OR ", 237);
    freq.put("lor", 378);
    freq.put("enã", 29);
    freq.put("m ", 30945);
    freq.put("enç", 327);
    freq.put("Te ", 81);
    freq.put("LA ", 200);
    freq.put("lme", 748);
    freq.put("líd", 23);
    freq.put("vol", 1068);
    freq.put("tíc", 52);
    freq.put("er ", 9562);
    freq.put(" mí", 33);
    freq.put("ora", 4197);
    freq.put("rit", 447);
    freq.put("Val", 120);
    freq.put("Á", 49);
    freq.put("vc ", 1543);
    freq.put("ãos", 70);
    freq.put("riu", 52);
    freq.put("Sta", 36);
    freq.put("pé ", 82);
    freq.put("qdo", 59);
    freq.put("laç", 101);
    freq.put(" mé", 63);
    freq.put("xto", 48);
    freq.put("nks", 43);
    freq.put("osp", 50);
    freq.put("Tir", 33);
    freq.put("Str", 23);
    freq.put("V", 3778);
    freq.put("upç", 28);
    freq.put("rry", 83);
    freq.put("br ", 27);
    freq.put("me", 16701);
    freq.put("vot", 120);
    freq.put("mg", 161);
    freq.put("mba", 222);
    freq.put("ma", 18780);
    freq.put("ltu", 49);
    freq.put("mc", 34);
    freq.put("mb", 2003);
    freq.put("mm", 492);
    freq.put("ml", 74);
    freq.put("mo", 9818);
    freq.put("mn", 25);
    freq.put("mi", 8051);
    freq.put("mu", 3464);
    freq.put("mt", 546);
    freq.put("erf", 225);
    freq.put("erg", 448);
    freq.put("mp", 3651);
    freq.put("ms", 738);
    freq.put("mr", 98);
    freq.put("erl", 28);
    freq.put("erm", 429);
    freq.put("ern", 641);
    freq.put("ero", 1422);
    freq.put("my", 175);
    freq.put("eri", 1659);
    freq.put("Le", 289);
    freq.put("blz", 38);
    freq.put("Nat", 42);
    freq.put("Lib", 26);
    freq.put("La", 207);
    freq.put("Mul", 65);
    freq.put("Lo", 186);
    freq.put("ógi", 53);
    freq.put(" mó", 61);
    freq.put("la ", 4424);
    freq.put("uts", 42);
    freq.put("Li", 330);
    freq.put("uai", 104);
    freq.put("So ", 25);
    freq.put("Abr", 81);
    freq.put("Lu", 217);
    freq.put("uam", 23);
    freq.put("ual", 736);
    freq.put("rq ", 34);
    freq.put("Lis", 24);
    freq.put("uaa", 33);
    freq.put("uae", 28);
    freq.put("rid", 410);
    freq.put("uag", 23);
    freq.put("rmá", 22);
    freq.put("ena", 758);
    freq.put("ib", 517);
    freq.put("end", 2900);
    freq.put("hoc", 85);
    freq.put("enf", 118);
    freq.put("eng", 366);
    freq.put("hon", 81);
    freq.put("hoo", 130);
    freq.put("hol", 31);
    freq.put("hom", 281);
    freq.put("hoj", 1328);
    freq.put("enn", 35);
    freq.put("eno", 621);
    freq.put("hov", 67);
    freq.put("how", 348);
    freq.put("hot", 95);
    freq.put("hou", 175);
    freq.put("hor", 1963);
    freq.put("ig", 4001);
    freq.put("hop", 109);
    freq.put("Kat", 22);
    freq.put("enx", 28);
    freq.put("mpl", 315);
    freq.put("uco", 626);
    freq.put("A", 7497);
    freq.put("lam", 344);
    freq.put("Not", 21);
    freq.put("éri", 411);
    freq.put("lah", 35);
    freq.put("lai", 22);
    freq.put("L ", 450);
    freq.put("icó", 22);
    freq.put("lad", 590);
    freq.put("ON ", 34);
    freq.put("lag", 88);
    freq.put("ost", 1512);
    freq.put("laa", 55);
    freq.put("lab", 60);
    freq.put("lac", 124);
    freq.put("ova", 661);
    freq.put("lax", 74);
    freq.put("II ", 43);
    freq.put("prá", 22);
    freq.put("ove", 627);
    freq.put("lat", 158);
    freq.put("lau", 33);
    freq.put("lav", 278);
    freq.put("ovi", 164);
    freq.put("lap", 21);
    freq.put("re ", 1999);
    freq.put("lar", 1338);
    freq.put("las", 539);
    freq.put("en ", 165);
    freq.put("Alm", 23);
    freq.put("má", 178);
    freq.put("ho ", 4265);
    freq.put("Ali", 38);
    freq.put("mí", 133);
    freq.put("Alg", 113);
    freq.put("AO ", 174);
    freq.put("Ale", 85);
    freq.put("mé", 177);
    freq.put("mê", 63);
    freq.put("mô", 26);
    freq.put("erç", 60);
    freq.put("mul", 325);
    freq.put("erá", 456);
    freq.put("mó", 92);
    freq.put("erã", 70);
    freq.put("fan", 97);
    freq.put("mó ", 55);
    freq.put("núm", 42);
    freq.put("mú", 270);
    freq.put(" V ", 29);
    freq.put("rád", 23);
    freq.put("ays", 33);
    freq.put("ngu", 448);
    freq.put("fam", 179);
    freq.put("zen", 385);
    freq.put(" Hu", 80);
    freq.put("zem", 148);
    freq.put("zer", 1492);
    freq.put(" Hj", 77);
    freq.put(" Hi", 44);
    freq.put("OM ", 204);
    freq.put(" Ho", 502);
    freq.put("rás", 93);
    freq.put("ráp", 61);
    freq.put("Mag", 29);
    freq.put("peã", 43);
    freq.put(" Ha", 312);
    freq.put(" He", 163);
    freq.put("ono", 456);
    freq.put("ima", 1053);
    freq.put("rõ", 23);
    freq.put("imb", 46);
    freq.put("ime", 883);
    freq.put("Bjo", 26);
    freq.put("osi", 144);
    freq.put("ró", 245);
    freq.put("imi", 296);
    freq.put("cle", 40);
    freq.put("imm", 25);
    freq.put("cla", 383);
    freq.put("imo", 613);
    freq.put("ssa", 3552);
    freq.put("imp", 622);
    freq.put("ims", 27);
    freq.put("rç", 248);
    freq.put("imu", 42);
    freq.put("rá", 1038);
    freq.put("râ", 39);
    freq.put("rã", 264);
    freq.put("cap", 189);
    freq.put("rí", 177);
    freq.put("fin", 480);
    freq.put("ré", 169);
    freq.put("JA ", 67);
    freq.put("fim", 306);
    freq.put(" Va", 577);
    freq.put(" Vc", 100);
    freq.put("ona", 829);
    freq.put(" Ve", 318);
    freq.put("rá ", 649);
    freq.put("au ", 250);
    freq.put(" Vi", 410);
    freq.put("pré", 39);
    freq.put("SA ", 275);
    freq.put("glê", 58);
    freq.put(" Vo", 1092);
    freq.put("¬¬", 407);
    freq.put("JO ", 28);
    freq.put("vão", 197);
    freq.put("Mai", 175);
    freq.put("oks", 36);
    freq.put("ntá", 82);
    freq.put("ntã", 529);
    freq.put(" H ", 34);
    freq.put("im ", 2727);
    freq.put("osk", 44);
    freq.put("maç", 133);
    freq.put("çõe", 315);
    freq.put("saú", 32);
    freq.put("isó", 26);
    freq.put("l", 48239);
    freq.put("até", 790);
    freq.put("pã", 76);
    freq.put("isé", 25);
    freq.put("ría", 21);
    freq.put("ári", 574);
    freq.put("ató", 32);
    freq.put("isã", 91);
    freq.put("dep", 768);
    freq.put("Lan", 42);
    freq.put("deo", 278);
    freq.put("UE ", 539);
    freq.put("uto", 357);
    freq.put("bra", 1066);
    freq.put("nt ", 182);
    freq.put(" Há", 39);
    freq.put("SS ", 37);
    freq.put("lll", 65);
    freq.put("rt", 3920);
    freq.put("gol", 237);
    freq.put("imã", 42);
    freq.put("gon", 123);
    freq.put("goi", 23);
    freq.put("rq", 771);
    freq.put("rr", 3861);
    freq.put("rs", 2344);
    freq.put(" ze", 38);
    freq.put("god", 52);
    freq.put("ajs", 24);
    freq.put("goa", 41);
    freq.put("¬", 732);
    freq.put("goc", 44);
    freq.put("rd", 3025);
    freq.put("re", 14317);
    freq.put("rf", 285);
    freq.put("rg", 947);
    freq.put("ra", 26493);
    freq.put("rb", 158);
    freq.put("rc", 1024);
    freq.put("gou", 251);
    freq.put("got", 25);
    freq.put("rn", 978);
    freq.put("gov", 62);
    freq.put("ri", 9982);
    freq.put("gos", 1119);
    freq.put("gor", 1595);
    freq.put(" tô", 318);
    freq.put("hã ", 722);
    freq.put("ce ", 1359);
    freq.put("ial", 340);
    freq.put("tud", 1373);
    freq.put("ahu", 385);
    freq.put("ntr", 1542);
    freq.put("ntu", 92);
    freq.put("nti", 1096);
    freq.put("nth", 130);
    freq.put("pip", 31);
    freq.put("cio", 727);
    freq.put("omé", 27);
    freq.put("W", 340);
    freq.put("nta", 2856);
    freq.put("Dê", 37);
    freq.put("kit", 27);
    freq.put("nte", 6071);
    freq.put("deb", 53);
    freq.put("Vic", 23);
    freq.put("Via", 44);
    freq.put("bás", 25);
    freq.put("Vid", 56);
    freq.put("ata", 949);
    freq.put("iss", 1917);
    freq.put("alv", 209);
    freq.put("atl", 38);
    freq.put("isp", 87);
    freq.put("Vin", 31);
    freq.put("go ", 2698);
    freq.put("Nov", 107);
    freq.put("ist", 2062);
    freq.put("Vir", 25);
    freq.put("fud", 85);
    freq.put("isi", 192);
    freq.put("ish", 85);
    freq.put("iso", 533);
    freq.put("t ", 1945);
    freq.put("ism", 136);
    freq.put("isc", 217);
    freq.put("caf", 97);
    freq.put("isa", 1875);
    freq.put("isf", 25);
    freq.put("ise", 277);
    freq.put("sm ", 132);
    freq.put("nhe", 685);
    freq.put("raç", 1074);
    freq.put("unh", 102);
    freq.put("nha", 5584);
    freq.put("nho", 3162);
    freq.put("raí", 21);
    freq.put("lá ", 741);
    freq.put("pir", 187);
    freq.put("nhu", 174);
    freq.put("Coi", 36);
    freq.put("zes", 302);
    freq.put(" St", 87);
    freq.put("osa", 389);
    freq.put("nis", 183);
    freq.put("TU ", 27);
    freq.put("tel", 238);
    freq.put("iab", 44);
    freq.put("tem", 3536);
    freq.put("prê", 23);
    freq.put("xib", 25);
    freq.put("xic", 30);
    freq.put("Man", 164);
    freq.put("Cea", 30);
    freq.put("tor", 694);
    freq.put("Cen", 54);
    freq.put("top", 93);
    freq.put("toq", 40);
    freq.put("equ", 254);
    freq.put("euh", 39);
    freq.put("xin", 85);
    freq.put("tou", 1090);
    freq.put("rão", 252);
    freq.put("xis", 200);
    freq.put("ton", 122);
    freq.put("Cer", 30);
    freq.put("tol", 79);
    freq.put("Se ", 495);
    freq.put("toc", 197);
    freq.put(" ôn", 41);
    freq.put("toa", 29);
    freq.put("tog", 43);
    freq.put("tod", 1336);
    freq.put("ax ", 25);
    freq.put("Fut", 22);
    freq.put("B", 3758);
    freq.put("uip", 40);
    freq.put(" la", 1128);
    freq.put(" lo", 1000);
    freq.put("NO ", 262);
    freq.put("lág", 28);
    freq.put("mbe", 144);
    freq.put("ads", 23);
    freq.put(" li", 2537);
    freq.put(" lh", 73);
    freq.put(" lu", 461);
    freq.put("Sob", 27);
    freq.put("abé", 215);
    freq.put("Fun", 35);
    freq.put("xim", 179);
    freq.put("fil", 649);
    freq.put("Opa", 27);
    freq.put("Fui", 69);
    freq.put("xi ", 42);
    freq.put("vac", 71);
    freq.put("Seu", 71);
    freq.put("Set", 41);
    freq.put("Ser", 180);
    freq.put("ca ", 3189);
    freq.put("í", 2096);
    freq.put("to ", 9358);
    freq.put("Sex", 58);
    freq.put("Seg", 204);
    freq.put("nza", 25);
    freq.put("Sec", 24);
    freq.put("égi", 73);
    freq.put("aoi", 32);
    freq.put("Sen", 111);
    freq.put("nzi", 26);
    freq.put("Sel", 34);
    freq.put("Sej", 40);
    freq.put("Sei", 51);
    freq.put("raf", 159);
    freq.put("rag", 201);
    freq.put("rad", 1188);
    freq.put("epu", 30);
    freq.put("rab", 807);
    freq.put("rac", 275);
    freq.put("nhã", 772);
    freq.put("raa", 168);
    freq.put("ran", 1743);
    freq.put("aúd", 50);
    freq.put("ral", 444);
    freq.put("ram", 1257);
    freq.put("usu", 36);
    freq.put("rah", 23);
    freq.put("rai", 337);
    freq.put("rav", 382);
    freq.put("Q ", 164);
    freq.put("rat", 381);
    freq.put("rau", 45);
    freq.put("rar", 1640);
    freq.put("ras", 1617);
    freq.put("rap", 177);
    freq.put("dur", 230);
    freq.put("raz", 199);
    freq.put("ase", 478);
    freq.put("mát", 62);
    freq.put("Ass", 115);
    freq.put("rte", 1058);
    freq.put("do ", 21084);
    freq.put("Ã ", 31);
    freq.put("cai", 253);
    freq.put("Jus", 48);
    freq.put("teu", 210);
    freq.put("hul", 26);
    freq.put("piz", 64);
    freq.put("íve", 258);
    freq.put("tev", 120);
    freq.put("máx", 25);
    freq.put("uvi", 445);
    freq.put("Sou", 158);
    freq.put("ça ", 1585);
    freq.put("on ", 434);
    freq.put("JÁ ", 29);
    freq.put("nen", 233);
    freq.put("AH ", 114);
    freq.put("Qu", 1471);
    freq.put(" lá", 749);
    freq.put("suf", 37);
    freq.put("bst", 32);
    freq.put(" lí", 49);
    freq.put("Chu", 34);
    freq.put("ãoo", 37);
    freq.put("hui", 22);
    freq.put("ull", 52);
    freq.put(" fi", 3284);
    freq.put("sud", 24);
    freq.put("oq ", 120);
    freq.put("suc", 91);
    freq.put("ogr", 254);
    freq.put("PO ", 39);
    freq.put("abe", 1845);
    freq.put("apó", 48);
    freq.put("Tam", 47);
    freq.put("doi", 285);
    freq.put("don", 158);
    freq.put("doo", 282);
    freq.put("dol", 69);
    freq.put("dom", 268);
    freq.put("dob", 30);
    freq.put("doc", 81);
    freq.put("doa", 61);
    freq.put("m", 98225);
    freq.put("doe", 120);
    freq.put("Tom", 70);
    freq.put("ÇA ", 72);
    freq.put("As ", 134);
    freq.put("AU ", 50);
    freq.put("sun", 90);
    freq.put("dor", 1972);
    freq.put("dos", 1967);
    freq.put("lpe", 37);
    freq.put("dow", 33);
    freq.put("lpa", 182);
    freq.put("dou", 205);
    freq.put(" We", 40);
    freq.put("cau", 155);
    freq.put(" Wa", 57);
    freq.put("api", 163);
    freq.put(" Wo", 33);
    freq.put("és", 127);
    freq.put("ér", 494);
    freq.put("éu", 59);
    freq.put("ét", 99);
    freq.put("d ", 1409);
    freq.put(" Wi", 94);
    freq.put("éi", 99);
    freq.put("éh", 32);
    freq.put("ém", 1114);
    freq.put("él", 33);
    freq.put("éo", 22);
    freq.put("én", 218);
    freq.put("éc", 86);
    freq.put("abo", 344);
    freq.put("ée", 76);
    freq.put("éd", 219);
    freq.put("ég", 81);
    freq.put("oci", 258);
    freq.put(" úl", 87);
    freq.put("úvi", 43);
    freq.put(" ún", 85);
    freq.put("uen", 374);
    freq.put("em ", 12964);
    freq.put("oco", 359);
    freq.put("oca", 929);
    freq.put("Bie", 36);
    freq.put("oce", 532);
    freq.put("hrs", 47);
    freq.put("Dan", 78);
    freq.put("hri", 47);
    freq.put("rsr", 559);
    freq.put("ba ", 428);
    freq.put("dói", 40);
    freq.put("téc", 45);
    freq.put("irá", 49);
    freq.put("irã", 67);
    freq.put("ocu", 272);
    freq.put("abu", 58);
    freq.put("dn", 35);
    freq.put("do", 27161);
    freq.put("dl", 37);
    freq.put("dm", 121);
    freq.put("dj", 48);
    freq.put("dk", 43);
    freq.put("dh", 87);
    freq.put("di", 8043);
    freq.put("df", 36);
    freq.put("dd", 139);
    freq.put("de", 26927);
    freq.put("acu", 150);
    freq.put("dc", 31);
    freq.put("da", 18396);
    freq.put("ga ", 1418);
    freq.put("bi ", 117);
    freq.put("dy", 101);
    freq.put("dv", 69);
    freq.put("X", 254);
    freq.put("du", 916);
    freq.put("dr", 655);
    freq.put("ds", 299);
    freq.put("dp", 159);
    freq.put("eme", 200);
    freq.put("çç", 32);
    freq.put("bat", 344);
    freq.put("ema", 1260);
    freq.put("ilã", 23);
    freq.put("emb", 774);
    freq.put("emm", 30);
    freq.put("oc ", 53);
    freq.put("emo", 830);
    freq.put("ilê", 29);
    freq.put("bas", 190);
    freq.put("PA ", 35);
    freq.put("Rio", 114);
    freq.put("f ", 479);
    freq.put("bab", 75);
    freq.put("emp", 1653);
    freq.put("coç", 21);
    freq.put("unç", 70);
    freq.put("ban", 777);
    freq.put("bal", 629);
    freq.put("bam", 45);
    freq.put(" em", 3672);
    freq.put("dó ", 36);
    freq.put("bai", 293);
    freq.put("om ", 6156);
    freq.put("w ", 786);
    freq.put("PS ", 23);
    freq.put("nus", 37);
    freq.put("Per", 141);
    freq.put("Pes", 91);
    freq.put("éé", 137);
    freq.put("Pen", 100);
    freq.put("num", 416);
    freq.put(" I ", 139);
    freq.put("Peg", 26);
    freq.put("aan", 69);
    freq.put("alç", 50);
    freq.put("nua", 140);
    freq.put("muu", 101);
    freq.put("Lul", 22);
    freq.put("ocê", 2424);
    freq.put("íci", 252);
    freq.put("il ", 926);
    freq.put("mur", 41);
    freq.put("irr", 146);
    freq.put("Rua", 21);
    freq.put("irt", 32);
    freq.put("iru", 32);
    freq.put("un ", 55);
    freq.put("iri", 214);
    freq.put("ate", 1030);
    freq.put("Hj ", 74);
    freq.put("ísi", 44);
    freq.put("iro", 1317);
    freq.put("Nao", 55);
    freq.put("ira", 1923);
    freq.put("irc", 40);
    freq.put("mui", 1626);
    freq.put("ire", 522);
    freq.put("irg", 36);
    freq.put("só ", 1838);
    freq.put("omb", 183);
    freq.put("C", 5064);
    freq.put("dí", 69);
    freq.put("dê", 196);
    freq.put("õe", 526);
    freq.put("wa", 80);
    freq.put("dé", 56);
    freq.put("wo", 69);
    freq.put("wn", 181);
    freq.put(" Ir", 62);
    freq.put(" Is", 152);
    freq.put(" It", 45);
    freq.put("dã", 194);
    freq.put("wi", 751);
    freq.put("Exi", 23);
    freq.put("ww", 297);
    freq.put("omp", 884);
    freq.put("dú", 52);
    freq.put(" Im", 69);
    freq.put(" In", 366);
    freq.put("bes", 137);
    freq.put("ued", 36);
    freq.put("dso", 35);
    freq.put(" Id", 21);
    freq.put("dó", 86);
    freq.put("nu ", 39);
    freq.put(" Ig", 33);
    freq.put("DM ", 54);
    freq.put("cop", 92);
    freq.put("ild", 38);
    freq.put("ile", 295);
    freq.put("emá", 43);
    freq.put("ell", 118);
    freq.put("ila", 236);
    freq.put("oki", 22);
    freq.put("ilo", 233);
    freq.put("ill", 133);
    freq.put("ilm", 334);
    freq.put("emé", 31);
    freq.put("tt ", 83);
    freq.put("ilh", 623);
    freq.put("ili", 308);
    freq.put("ilv", 67);
    freq.put("una", 49);
    freq.put("coc", 60);
    freq.put("ilu", 78);
    freq.put("coe", 30);
    freq.put("ils", 37);
    freq.put("unf", 48);
    freq.put("ung", 34);
    freq.put("úde", 50);
    freq.put("uni", 362);
    freq.put("ai ", 4049);
    freq.put("unk", 74);
    freq.put("com", 8223);
    freq.put("col", 1238);
    freq.put("coo", 114);
    freq.put("con", 3719);
    freq.put(" me", 10570);
    freq.put("iú", 36);
    freq.put(" ma", 8522);
    freq.put(" mc", 26);
    freq.put(" ml", 66);
    freq.put("ópr", 63);
    freq.put(" mo", 1680);
    freq.put("iõ", 30);
    freq.put(" mi", 3856);
    freq.put("Gar", 35);
    freq.put(" mt", 511);
    freq.put(" mu", 3235);
    freq.put("iê", 99);
    freq.put("avo", 301);
    freq.put(" ms", 577);
    freq.put("iá", 86);
    freq.put("ão", 12359);
    freq.put("iã", 148);
    freq.put("Kkk", 131);
    freq.put(" my", 135);
    freq.put("iç", 548);
    freq.put("ana", 964);
    freq.put("nár", 55);
    freq.put("fra", 215);
    freq.put("uár", 23);
    freq.put("Bal", 33);
    freq.put("che", 1427);
    freq.put("fre", 348);
    freq.put("Ros", 28);
    freq.put("lti", 327);
    freq.put("fri", 372);
    freq.put("C ", 395);
    freq.put("fro", 42);
    freq.put("obe", 136);
    freq.put("Nas", 21);
    freq.put("noo", 126);
    freq.put("áli", 39);
    freq.put("fru", 37);
    freq.put("sab", 1114);
    freq.put("ark", 45);
    freq.put("pro", 2636);
    freq.put("rge", 122);
    freq.put("ab ", 37);
    freq.put("oná", 24);
    freq.put(" m ", 83);
    freq.put("Cru", 46);
    freq.put("sag", 158);
    freq.put("xxx", 37);
    freq.put("ani", 573);
    freq.put("Gag", 37);
    freq.put("fic", 1909);
    freq.put("anj", 105);
    freq.put("Cre", 42);
    freq.put("ááá", 35);
    freq.put("Cri", 113);
    freq.put("TV ", 100);
    freq.put("xam", 45);
    freq.put("cac", 124);
    freq.put("Ci", 108);
    freq.put("Ch", 361);
    freq.put("Co", 1287);
    freq.put("aix", 462);
    freq.put("gnt", 41);
    freq.put("Cl", 156);
    freq.put("aiu", 139);
    freq.put("ait", 29);
    freq.put("Ca", 928);
    freq.put(" yo", 60);
    freq.put("RI ", 35);
    freq.put("Ce", 155);
    freq.put("n", 96790);
    freq.put("ape", 369);
    freq.put("ail", 189);
    freq.put("ET ", 32);
    freq.put("ain", 1300);
    freq.put("aii", 133);
    freq.put("sli", 56);
    freq.put("gne", 25);
    freq.put("Cr", 224);
    freq.put("gni", 66);
    freq.put("aia", 236);
    freq.put("gno", 72);
    freq.put("Cu", 145);
    freq.put("aib", 50);
    freq.put("ix", 1316);
    freq.put("iz", 2162);
    freq.put(" má", 74);
    freq.put("Nad", 55);
    freq.put(" mã", 560);
    freq.put("iq", 432);
    freq.put("ip", 932);
    freq.put("is", 13430);
    freq.put("ir", 8430);
    freq.put("iu", 1130);
    freq.put("it", 7457);
    freq.put(" mê", 62);
    freq.put("iv", 2690);
    freq.put("ii", 2184);
    freq.put("ih", 268);
    freq.put("ik", 203);
    freq.put("ij", 674);
    freq.put("im", 6514);
    freq.put("il", 3529);
    freq.put("io", 5428);
    freq.put("in", 17830);
    freq.put("ia", 10600);
    freq.put("opp", 65);
    freq.put("ic", 6178);
    freq.put("ki ", 254);
    freq.put("ie", 953);
    freq.put("id", 4812);
    freq.put(" Aí", 34);
    freq.put("if", 645);
    freq.put("V ", 162);
    freq.put("Tit", 22);
    freq.put("uje", 24);
    freq.put("Tro", 26);
    freq.put("art", 1078);
    freq.put("iP", 45);
    freq.put("aki", 271);
    freq.put("dha", 29);
    freq.put("nun", 546);
    freq.put("add", 37);
    freq.put("anz", 26);
    freq.put("big", 30);
    freq.put("íng", 21);
    freq.put("bid", 60);
    freq.put("ep ", 33);
    freq.put("th ", 60);
    freq.put("cir", 35);
    freq.put("Na ", 125);
    freq.put("Dig", 31);
    freq.put("nin", 800);
    freq.put("nio", 109);
    freq.put("nil", 29);
    freq.put("nim", 251);
    freq.put("nib", 76);
    freq.put("nic", 478);
    freq.put("nia", 171);
    freq.put("nif", 102);
    freq.put("nig", 28);
    freq.put("nid", 132);
    freq.put("Ob", 171);
    freq.put("niz", 73);
    freq.put("tz ", 44);
    freq.put("kii", 22);
    freq.put("êmi", 67);
    freq.put("UI ", 86);
    freq.put("kin", 80);
    freq.put("Y", 176);
    freq.put("i ", 15763);
    freq.put("urd", 29);
    freq.put("niv", 283);
    freq.put("RE ", 97);
    freq.put("kie", 22);
    freq.put("mil", 373);
    freq.put("Va", 582);
    freq.put("LO ", 78);
    freq.put("Vc", 102);
    freq.put("Ve", 320);
    freq.put("los", 312);
    freq.put("Vi", 417);
    freq.put(" L ", 73);
    freq.put("Vl", 21);
    freq.put("Vo", 1095);
    freq.put("epo", 761);
    freq.put("epl", 25);
    freq.put("thi", 144);
    freq.put("epi", 67);
    freq.put("the", 127);
    freq.put("epe", 189);
    freq.put("ôni", 137);
    freq.put("epc", 31);
    freq.put("tha", 28);
    freq.put("epa", 162);
    freq.put("olã", 30);
    freq.put("cam", 799);
    freq.put("vic", 115);
    freq.put("olé", 85);
    freq.put("olê", 22);
    freq.put("uge", 35);
    freq.put("olí", 71);
    freq.put("Dil", 26);
    freq.put("via", 599);
    freq.put("op ", 117);
    freq.put(" É ", 844);
    freq.put("tró", 22);
    freq.put("Tip", 21);
    freq.put("uja", 25);
    freq.put(" Já", 253);
    freq.put("Div", 32);
    freq.put("uím", 28);
    freq.put("hah", 3009);
    freq.put("hai", 47);
    freq.put("elh", 1156);
    freq.put("eli", 862);
    freq.put("hal", 29);
    freq.put("ham", 565);
    freq.put("han", 377);
    freq.put("hao", 23);
    freq.put("haa", 225);
    freq.put("hab", 26);
    freq.put("hac", 34);
    freq.put("had", 250);
    freq.put("hae", 40);
    freq.put("eld", 50);
    freq.put("ele", 2558);
    freq.put("Gan", 65);
    freq.put("Gam", 28);
    freq.put("Gal", 100);
    freq.put("blr", 126);
    freq.put("hap", 37);
    freq.put("els", 25);
    freq.put("har", 813);
    freq.put("Há", 39);
    freq.put("hat", 237);
    freq.put("hau", 623);
    freq.put("hav", 113);
    freq.put("elu", 199);
    freq.put("uso", 73);
    freq.put("opu", 27);
    freq.put("rni", 55);
    freq.put("rno", 244);
    freq.put("D", 5688);
    freq.put("opr", 37);
    freq.put("ops", 39);
    freq.put("Tra", 69);
    freq.put("ye ", 22);
    freq.put("rna", 440);
    freq.put("Tre", 30);
    freq.put("rne", 199);
    freq.put("vio", 110);
    freq.put("ope", 116);
    freq.put("opa", 168);
    freq.put("lca", 26);
    freq.put("lco", 56);
    freq.put("ub ", 50);
    freq.put("peç", 64);
    freq.put("opi", 112);
    freq.put("IO ", 214);
    freq.put("Arr", 26);
    freq.put("mir", 656);
    freq.put("Art", 42);
    freq.put("ang", 221);
    freq.put("ha ", 6105);
    freq.put("mr ", 76);
    freq.put("el ", 836);
    freq.put("zaç", 56);
    freq.put("uê ", 48);
    freq.put("Ara", 24);
    freq.put("rva", 109);
    freq.put("trô", 31);
    freq.put("vdd", 40);
    freq.put("ião", 146);
    freq.put("vés", 28);
    freq.put("ola", 1070);
    freq.put("hs ", 54);
    freq.put("tub", 65);
    freq.put("old", 34);
    freq.put("ole", 357);
    freq.put("olg", 47);
    freq.put(" Ju", 209);
    freq.put("oli", 258);
    freq.put(" X ", 91);
    freq.put("oll", 151);
    freq.put("abs", 61);
    freq.put("mã ", 96);
    freq.put(" Jo", 306);
    freq.put("ols", 79);
    freq.put("olt", 1135);
    freq.put("ees", 47);
    freq.put("olv", 175);
    freq.put(" Je", 129);
    freq.put("an ", 390);
    freq.put("cal", 418);
    freq.put("wwn", 26);
    freq.put(" Ja", 234);
    freq.put("ick", 68);
    freq.put("Lea", 23);
    freq.put("ici", 850);
    freq.put("ich", 134);
    freq.put("ico", 1290);
    freq.put("ump", 38);
    freq.put("for", 1051);
    freq.put("icl", 47);
    freq.put("Lei", 65);
    freq.put("ica", 3345);
    freq.put("Lem", 52);
    freq.put("ice", 163);
    freq.put("haç", 89);
    freq.put("Hj", 77);
    freq.put("aww", 23);
    freq.put("fof", 177);
    freq.put("Hi", 44);
    freq.put("Tá ", 123);
    freq.put("Ho", 507);
    freq.put("Lev", 26);
    freq.put("foc", 43);
    freq.put("fol", 127);
    freq.put("icr", 23);
    freq.put("fon", 113);
    freq.put("Ha", 326);
    freq.put("umi", 210);
    freq.put("foi", 1111);
    freq.put("icu", 71);
    freq.put("ict", 24);
    freq.put("mão", 356);
    freq.put("hsa", 148);
    freq.put("hsh", 27);
    freq.put("cu ", 72);
    freq.put("rsá", 104);
    freq.put("ple", 265);
    freq.put("opç", 31);
    freq.put("ww ", 81);
    freq.put("Edu", 31);
    freq.put("hsu", 258);
    freq.put("plo", 105);
    freq.put("rsã", 46);
    freq.put(" J ", 33);
    freq.put("pli", 176);
    freq.put("obo", 121);
    freq.put("obl", 206);
    freq.put("Dá ", 29);
    freq.put("arr", 1003);
    freq.put("obi", 52);
    freq.put("obg", 26);
    freq.put("www", 184);
    freq.put("ic ", 74);
    freq.put("o", 208382);
    freq.put("oba", 72);
    freq.put("pág", 33);
    freq.put("zua", 61);
    freq.put("fo ", 93);
    freq.put("um ", 4563);
    freq.put("sív", 108);
    freq.put("meg", 36);
    freq.put("H ", 356);
    freq.put("obr", 879);
    freq.put("obs", 48);
    freq.put("zul", 36);
    freq.put("soa", 1199);
    freq.put("ót", 149);
    freq.put("sob", 420);
    freq.put("ars", 50);
    freq.put("Cur", 68);
    freq.put("sof", 170);
    freq.put("soi", 26);
    freq.put("soh", 31);
    freq.put("Fel", 93);
    freq.put("ahi", 54);
    freq.put("som", 214);
    freq.put("sol", 442);
    freq.put("soo", 36);
    freq.put("Fei", 32);
    freq.put("sop", 40);
    freq.put("sos", 243);
    freq.put("sor", 586);
    freq.put("Fer", 108);
    freq.put("Fes", 39);
    freq.put("rv", 409);
    freq.put("mbu", 56);
    freq.put("Cul", 22);
    freq.put("opo", 173);
    freq.put("zad", 177);
    freq.put("Cui", 31);
    freq.put("BR ", 36);
    freq.put("am ", 2112);
    freq.put("né", 1006);
    freq.put("giu", 23);
    freq.put("git", 87);
    freq.put("gis", 37);
    freq.put("ní", 49);
    freq.put("az ", 733);
    freq.put("ná", 110);
    freq.put("nã", 5361);
    freq.put("ÇO ", 30);
    freq.put("nç", 1037);
    freq.put("gig", 22);
    freq.put("olh", 760);
    freq.put("nú", 79);
    freq.put("gid", 21);
    freq.put("gic", 82);
    freq.put("gia", 157);
    freq.put("alé", 69);
    freq.put("gio", 164);
    freq.put("gin", 354);
    freq.put("mt ", 256);
    freq.put("nó", 204);
    freq.put("nô", 22);
    freq.put("war", 36);
    freq.put(" né", 950);
    freq.put("so ", 3635);
    freq.put("ah ", 732);
    freq.put("pp ", 22);
    freq.put("ãe ", 453);
    freq.put("oz ", 124);
    freq.put("TE ", 362);
    freq.put(" nã", 5311);
    freq.put("Kar", 24);
    freq.put("mb ", 26);
    freq.put("aul", 733);
    freq.put("ues", 163);
    freq.put("rp", 202);
    freq.put("ME ", 184);
    freq.put("low", 106);
    freq.put(" nó", 182);
    freq.put("Z", 171);
    freq.put("ura", 866);
    freq.put("azi", 103);
    freq.put("urb", 27);
    freq.put("aja", 156);
    freq.put("Voc", 338);
    freq.put("iqu", 426);
    freq.put("aza", 73);
    freq.put("Von", 22);
    freq.put("Voo", 22);
    freq.put("écn", 50);
    freq.put("Vot", 33);
    freq.put("Vou", 532);
    freq.put("taç", 151);
    freq.put("íri", 27);
    freq.put("mtm", 26);
    freq.put("Há ", 38);
    freq.put("mta", 25);
    freq.put("Com", 518);
    freq.put("Ode", 32);
    freq.put("ããã", 22);
    freq.put("olu", 112);
    freq.put("nnn", 98);
    freq.put("uro", 350);
    freq.put("mbé", 438);
    freq.put("XA ", 22);
    freq.put(" n ", 395);
    freq.put("nne", 37);
    freq.put("aha", 3054);
    freq.put("nna", 62);
    freq.put("uri", 222);
    freq.put("Sig", 137);
    freq.put("D ", 840);
    freq.put("elo", 979);
    freq.put("Viv", 57);
    freq.put("ós ", 255);
    freq.put("Sim", 129);
    freq.put("Sil", 59);
    freq.put("nh", 10446);
    freq.put("ni", 3293);
    freq.put("nj", 181);
    freq.put("nk", 253);
    freq.put("nl", 80);
    freq.put("pre", 3026);
    freq.put("nn", 336);
    freq.put("no", 11155);
    freq.put("tit", 119);
    freq.put("na", 11152);
    freq.put("tiv", 790);
    freq.put("nc", 3143);
    freq.put("nd", 16105);
    freq.put("ne", 4411);
    freq.put("nf", 919);
    freq.put("ng", 2136);
    freq.put("nx", 41);
    freq.put("ny", 75);
    freq.put("nz", 76);
    freq.put("tio", 120);
    freq.put("giã", 31);
    freq.put("tii", 38);
    freq.put("ES ", 188);
    freq.put("tid", 279);
    freq.put("nq", 286);
    freq.put("nr", 102);
    freq.put("ns", 3924);
    freq.put("nt", 15293);
    freq.put("nu", 1452);
    freq.put("nv", 727);
    freq.put("tic", 681);
    freq.put(" ni", 396);
    freq.put(" nh", 44);
    freq.put("OU ", 264);
    freq.put("E", 5891);
    freq.put("urr", 139);
    freq.put(" no", 7854);
    freq.put(" nn", 40);
    freq.put(" na", 6133);
    freq.put("urs", 153);
    freq.put(" ne", 2581);
    freq.put(" nd", 36);
    freq.put(" ng", 45);
    freq.put("nn ", 68);
    freq.put("elé", 21);
    freq.put("tec", 341);
    freq.put("uau", 56);
    freq.put("lão", 85);
    freq.put("Ú", 25);
    freq.put(" nu", 974);
    freq.put("FC ", 63);
    freq.put("Tri", 37);
    freq.put("axi", 42);
    freq.put("lár", 35);
    freq.put("n ", 2773);
    freq.put("Win", 25);
    freq.put("elí", 31);
    freq.put("afo", 88);
    freq.put("nxe", 22);
    freq.put("mec", 73);
    freq.put("fã", 125);
    freq.put("rk ", 32);
    freq.put("ti ", 330);
    freq.put("roi", 48);
    freq.put("roj", 79);
    freq.put("rol", 393);
    freq.put("rom", 301);
    freq.put("ron", 320);
    freq.put("roo", 114);
    freq.put("roa", 23);
    freq.put("rob", 232);
    freq.put("roc", 415);
    freq.put("rod", 197);
    freq.put("roe", 22);
    freq.put("rof", 271);
    freq.put("rog", 255);
    freq.put("rox", 84);
    freq.put("osh", 39);
    freq.put("roz", 26);
    freq.put("mg ", 130);
    freq.put("llo", 124);
    freq.put("ob ", 38);
    freq.put("oso", 366);
    freq.put("ld ", 41);
    freq.put("rop", 203);
    freq.put("ror", 60);
    freq.put("Hu", 89);
    freq.put("Grê", 25);
    freq.put("rou", 512);
    freq.put("rov", 492);
    freq.put("row", 30);
    freq.put("Aqu", 107);
    freq.put("fod", 395);
    freq.put("vet", 60);
    freq.put("one", 385);
    freq.put("ver", 2988);
    freq.put("ves", 313);
    freq.put("Dam", 24);
    freq.put("CÊ ", 78);
    freq.put("di ", 312);
    freq.put("veg", 22);
    freq.put("fog", 109);
    freq.put("ép", 39);
    freq.put("Daq", 65);
    freq.put("véi", 29);
    freq.put("uma", 3678);
    freq.put("vel", 861);
    freq.put("ó ", 2415);
    freq.put("vej", 311);
    freq.put("aut", 95);
    freq.put("cov", 48);
    freq.put(" do", 7965);
    freq.put("lé ", 38);
    freq.put("Mã", 36);
    freq.put("ro ", 5294);
    freq.put("umb", 188);
    freq.put("erv", 336);
    freq.put("▀", 42);
    freq.put("umm", 46);
    freq.put("Tiv", 23);
    freq.put("eló", 29);
    freq.put("erp", 28);
    freq.put("Pat", 26);
    freq.put("lsa", 68);
    freq.put("caa", 54);
    freq.put("Gab", 31);
    freq.put("Mú", 27);
    freq.put("dil", 28);
    freq.put("ry", 163);
    freq.put("gua", 467);
    freq.put("foo", 46);
    freq.put("Da ", 34);
    freq.put("err", 690);
    freq.put("gue", 1434);
    freq.put("rmã", 250);
    freq.put("ós", 291);
    freq.put("ór", 326);
    freq.put("gui", 1377);
    freq.put("ers", 721);
    freq.put("gun", 646);
    freq.put("gum", 413);
    freq.put("gul", 147);
    freq.put("gus", 32);
    freq.put("p", 44239);
    freq.put("ói", 124);
    freq.put("ge ", 202);
    freq.put("diz", 694);
    freq.put("ól", 46);
    freq.put("óc", 81);
    freq.put("ób", 21);
    freq.put("div", 244);
    freq.put("He", 165);
    freq.put("óg", 75);
    freq.put("der", 1290);
    freq.put("dir", 457);
    freq.put("rz", 42);
    freq.put("ol ", 471);
    freq.put("uck", 32);
    freq.put("uva", 123);
    freq.put("M ", 1465);
    freq.put("UH ", 51);
    freq.put(" Yo", 53);
    freq.put("Res", 105);
    freq.put("Rep", 26);
    freq.put("Rev", 29);
    freq.put("ída", 29);
    freq.put("Ret", 22);
    freq.put("OK ", 21);
    freq.put("Gre", 21);
    freq.put("Ren", 49);
    freq.put("dev", 434);
    freq.put("Rel", 29);
    freq.put("Gra", 73);
    freq.put("Reb", 33);
    freq.put("Rec", 90);
    freq.put("Rea", 140);
    freq.put("IN ", 39);
    freq.put("Reg", 30);
    freq.put("Red", 43);
    freq.put("zzz", 86);
    freq.put("erd", 1335);
    freq.put("rul", 43);
    freq.put("Tum", 30);
    freq.put("ere", 1202);
    freq.put("Sáb", 28);
    freq.put("Qua", 389);
    freq.put("rub", 37);
    freq.put("Que", 1034);
    freq.put("bib", 25);
    freq.put("coz", 30);
    freq.put("Qui", 38);
    freq.put("mãe", 452);
    freq.put("DS ", 40);
    freq.put("era", 1928);
    freq.put("Me", 866);
    freq.put("rua", 134);
    freq.put("Ma", 1373);
    freq.put("erb", 30);
    freq.put("Mc", 30);
    freq.put("ht ", 32);
    freq.put(" Y ", 39);
    freq.put("Mo", 294);
    freq.put("erc", 382);
    freq.put("Mi", 501);
    freq.put("clo", 29);
    freq.put("rug", 78);
    freq.put("Mu", 340);
    freq.put("aê ", 38);
    freq.put("lou", 386);
    freq.put("O", 3930);
    freq.put("dea", 29);
    freq.put("Agu", 23);
    freq.put("PT ", 28);
    freq.put(" du", 461);
    freq.put("or ", 5458);
    freq.put("ksp", 23);
    freq.put("box", 31);
    freq.put("boy", 36);
    freq.put("dec", 237);
    freq.put("arc", 356);
    freq.put("Dê ", 35);
    freq.put("Mil", 54);
    freq.put("guê", 40);
    freq.put("gué", 540);
    freq.put("diç", 78);
    freq.put("bot", 118);
    freq.put("bou", 182);
    freq.put("dee", 123);
    freq.put("HA ", 507);
    freq.put("bol", 375);
    freq.put("bom", 1045);
    freq.put("Uni", 68);
    freq.put("ngm", 42);
    freq.put("boa", 726);
    freq.put("PC ", 42);
    freq.put(" dp", 95);
    freq.put("uve", 103);
    freq.put("oen", 90);
    freq.put("Sér", 49);
    freq.put("ard", 843);
    freq.put("ipa", 225);
    freq.put("Bon", 30);
    freq.put("bm ", 316);
    freq.put("ipe", 211);
    freq.put("ott", 73);
    freq.put("jar", 110);
    freq.put("Boo", 64);
    freq.put("ipo", 324);
    freq.put("ipl", 24);
    freq.put("jas", 35);
    freq.put("Lig", 38);
    freq.put("dia", 2494);
    freq.put("rus", 46);
    freq.put("afa", 173);
    freq.put("éh ", 31);
    freq.put("ugo", 21);
    freq.put("viç", 49);
    freq.put("jan", 178);
    freq.put(" Ka", 76);
    freq.put("Min", 291);
    freq.put(" ii", 41);
    freq.put(" Kk", 130);
    freq.put(" Ki", 41);
    freq.put(" Kl", 24);
    freq.put("msn", 371);
    freq.put("msm", 148);
    freq.put("lô ", 22);
    freq.put("qer", 29);
    freq.put("zza", 82);
    freq.put("Lim", 26);
    freq.put("msg", 56);
    freq.put("jaj", 71);
    freq.put("ul ", 149);
    freq.put("vê ", 120);
    freq.put("Lin", 100);
    freq.put("Rsr", 27);
    freq.put("Mon", 52);
    freq.put("ood", 59);
    freq.put("ip ", 46);
    freq.put("Bei", 140);
    freq.put("Ben", 28);
    freq.put("ngr", 228);
    freq.put("Bel", 60);
    freq.put("F", 3079);
    freq.put("oom", 130);
    freq.put("ool", 101);
    freq.put("ooo", 2848);
    freq.put("úbl", 42);
    freq.put("ooi", 104);
    freq.put("ze ", 85);
    freq.put("ook", 194);
    freq.put("ooj", 37);
    freq.put("oou", 85);
    freq.put("oot", 24);
    freq.put("oow", 46);
    freq.put("oop", 21);
    freq.put("oos", 149);
    freq.put("oor", 199);
    freq.put("Ber", 28);
    freq.put("obj", 24);
    freq.put("uav", 28);
    freq.put("kso", 36);
    freq.put("ibi", 91);
    freq.put(" K ", 24);
    freq.put("ibl", 24);
    freq.put("Ron", 29);
    freq.put("uah", 567);
    freq.put("só", 1909);
    freq.put("iba", 105);
    freq.put("DO ", 857);
    freq.put("sus", 230);
    freq.put("flu", 26);
    freq.put("ibe", 126);
    freq.put("sõ", 39);
    freq.put("cat", 107);
    freq.put("ñ", 176);
    freq.put("fli", 26);
    freq.put("sé", 255);
    freq.put("Abs", 24);
    freq.put("cao", 54);
    freq.put("ulo", 352);
    freq.put("sí", 142);
    freq.put("Vo ", 37);
    freq.put("sã", 828);
    freq.put("xad", 49);
    freq.put("ibr", 22);
    freq.put("ula", 976);
    freq.put("fle", 38);
    freq.put("ibu", 119);
    freq.put("Mic", 34);
    freq.put("Out", 30);
    freq.put(" on", 913);
    freq.put(" oo", 147);
    freq.put(" ol", 597);
    freq.put(" om", 36);
    freq.put(" ok", 163);
    freq.put(" oh", 26);
    freq.put(" oi", 164);
    freq.put(" of", 153);
    freq.put("█", 73);
    freq.put(" od", 180);
    freq.put("uan", 1557);
    freq.put(" ob", 345);
    freq.put(" oc", 70);
    freq.put("spi", 162);
    freq.put("êêê", 21);
    freq.put("spo", 600);
    freq.put(" ov", 29);
    freq.put(" ow", 62);
    freq.put(" ot", 75);
    freq.put(" ou", 1840);
    freq.put(" or", 332);
    freq.put(" os", 1441);
    freq.put(" op", 190);
    freq.put(" oq", 189);
    freq.put("rõe", 23);
    freq.put(" oO", 24);
    freq.put(" à ", 149);
    freq.put("Tud", 125);
    freq.put("dim", 92);
    freq.put("rl", 207);
    freq.put("fís", 39);
    freq.put("rvi", 89);
    freq.put("uad", 97);
    freq.put("gar", 1445);
    freq.put("mel", 892);
    freq.put("s ", 39932);
    freq.put("fíc", 113);
    freq.put("iás", 23);
    freq.put("naa", 73);
    freq.put("maq", 26);
    freq.put("mas", 2477);
    freq.put("mar", 1475);
    freq.put("mau", 39);
    freq.put("din", 630);
    freq.put("mav", 35);
    freq.put("aoo", 24);
    freq.put("aon", 42);
    freq.put("use", 104);
    freq.put("aok", 22);
    freq.put(" o ", 9989);
    freq.put("pqp", 129);
    freq.put("mac", 155);
    freq.put("enc", 678);
    freq.put("mae", 123);
    freq.put("sss", 575);
    freq.put("mag", 328);
    freq.put("mai", 3700);
    freq.put("mam", 198);
    freq.put("mal", 602);
    freq.put("mao", 62);
    freq.put("ene", 160);
    freq.put("ght", 39);
    freq.put("sz", 40);
    freq.put("dio", 433);
    freq.put("déi", 31);
    freq.put("ss", 12786);
    freq.put("sr", 633);
    freq.put("sq", 606);
    freq.put("sp", 2057);
    freq.put("sv", 23);
    freq.put("su", 2627);
    freq.put("st", 9684);
    freq.put("q", 26084);
    freq.put("sj", 58);
    freq.put("si", 5481);
    freq.put("sh", 1149);
    freq.put("so", 9096);
    freq.put("sn", 434);
    freq.put("sm", 1735);
    freq.put("sl", 128);
    freq.put("sc", 2457);
    freq.put("sb", 64);
    freq.put("sa", 12977);
    freq.put("sg", 158);
    freq.put("sf", 194);
    freq.put("se", 16566);
    freq.put("sd", 244);
    freq.put("Ru", 74);
    freq.put("ro", 10697);
    freq.put("Rs", 63);
    freq.put("Chi", 45);
    freq.put("eç", 1238);
    freq.put("ttp", 37);
    freq.put("no ", 6008);
    freq.put("soc", 133);
    freq.put("eã", 58);
    freq.put("Cho", 33);
    freq.put("fã ", 72);
    freq.put("Re", 662);
    freq.put("Chr", 43);
    freq.put("mbo", 171);
    freq.put("tto", 47);
    freq.put("Ra", 179);
    freq.put("sár", 144);
    freq.put("tta", 86);
    freq.put("Ro", 255);
    freq.put("Ri", 258);
    freq.put("tte", 617);
    freq.put("Í ", 23);
    freq.put(" aa", 404);
    freq.put(" ab", 661);
    freq.put(" ac", 2953);
    freq.put(" ad", 603);
    freq.put(" ae", 321);
    freq.put(" af", 405);
    freq.put(" ag", 1940);
    freq.put(" ah", 429);
    freq.put(" ai", 1961);
    freq.put(" aj", 253);
    freq.put(" ak", 243);
    freq.put(" al", 2081);
    freq.put(" am", 3753);
    freq.put(" an", 1553);
    freq.put(" ao", 781);
    freq.put(" ap", 1261);
    freq.put(" aq", 1926);
    freq.put(" ar", 793);
    freq.put(" as", 2720);
    freq.put(" at", 1692);
    freq.put(" au", 731);
    freq.put(" av", 324);
    freq.put(" aw", 74);
    freq.put(" ax", 40);
    freq.put("ent", 7651);
    freq.put(" az", 39);
    freq.put(" pl", 240);
    freq.put("Tô", 122);
    freq.put("hos", 598);
    freq.put("nol", 44);
    freq.put("nom", 280);
    freq.put("non", 32);
    freq.put("fãs", 49);
    freq.put("env", 93);
    freq.put("Ç", 23);
    freq.put("Mel", 69);
    freq.put("QP ", 37);
    freq.put("ros", 786);
    freq.put("gam", 252);
    freq.put("noc", 22);
    freq.put("pla", 259);
    freq.put("ert", 1081);
    freq.put(" we", 48);
    freq.put("R ", 1407);
    freq.put("nsf", 23);
    freq.put("kkk", 14769);
    freq.put("not", 218);
    freq.put("dps", 82);
    freq.put("nov", 1051);
    freq.put(" us", 329);
    freq.put("Ja ", 59);
    freq.put("nos", 2008);
    freq.put(" a ", 9060);
    freq.put("aew", 27);
    freq.put("TA ", 394);
    freq.put("ahs", 255);
    freq.put("áci", 127);
    freq.put("óri", 285);
    freq.put(" wo", 24);
    freq.put("did", 271);
    freq.put("Tor", 43);
    freq.put("fen", 56);
    freq.put("em", 18347);
    freq.put("el", 9698);
    freq.put("eo", 631);
    freq.put("en", 17676);
    freq.put("ei", 11399);
    freq.put("eh", 1005);
    freq.put("ek", 60);
    freq.put("ej", 962);
    freq.put("ee", 3628);
    freq.put("ed", 2318);
    freq.put("eg", 4866);
    freq.put("ef", 537);
    freq.put("ea", 1371);
    freq.put("rl ", 36);
    freq.put("ec", 3928);
    freq.put("eb", 1195);
    freq.put("Lua", 74);
    freq.put("Luc", 39);
    freq.put("ey", 236);
    freq.put("ex", 1411);
    freq.put("ez", 1463);
    freq.put("eu", 13511);
    freq.put("et", 2798);
    freq.put("ew", 126);
    freq.put("ev", 1757);
    freq.put("eq", 266);
    freq.put("ep", 1514);
    freq.put("es", 21408);
    freq.put("er", 23105);
    freq.put("aea", 28);
    freq.put("Jor", 44);
    freq.put("ejo", 232);
    freq.put(" aç", 52);
    freq.put("blu", 41);
    freq.put("eje", 26);
    freq.put(" aê", 37);
    freq.put("Dom", 46);
    freq.put(" aí", 311);
    freq.put("nsu", 65);
    freq.put("Joa", 21);
    freq.put("blo", 213);
    freq.put("AI ", 243);
    freq.put("bli", 135);
    freq.put("dif", 319);
    freq.put("os ", 10704);
    freq.put("Jog", 61);
    freq.put("Joh", 23);
    freq.put("eju", 21);
    freq.put("cá ", 42);
    freq.put("bla", 48);
    freq.put("Jon", 22);
    freq.put("qd", 72);
    freq.put("rlo", 44);
    freq.put("rli", 30);
    freq.put("RT ", 938);
    freq.put("G", 1913);
    freq.put("rle", 25);
    freq.put("ort", 1368);
    freq.put("oru", 27);
    freq.put("rla", 30);
    freq.put("e ", 71339);
    freq.put("orp", 82);
    freq.put("orq", 668);
    freq.put("orn", 220);
    freq.put("qi", 76);
    freq.put("orl", 21);
    freq.put("ci ", 145);
    freq.put("ork", 113);
    freq.put("ven", 854);
    freq.put("ori", 620);
    freq.put("orf", 25);
    freq.put("org", 166);
    freq.put("ord", 789);
    freq.put("ore", 989);
    freq.put("orc", 214);
    freq.put("gir", 104);
    freq.put("Hom", 32);
    freq.put("Apr", 59);
    freq.put("ume", 256);
    freq.put("ael", 47);
    freq.put("sms", 57);
    freq.put("fc", 21);
    freq.put("lla", 75);
    freq.put("cos", 341);
    freq.put("qqq", 28);
    freq.put("sho", 417);
    freq.put(" ce", 1205);
    freq.put("Ape", 30);
    freq.put("onj", 21);
    freq.put("onh", 708);
    freq.put("xi", 636);
    freq.put("hu ", 55);
    freq.put("xo", 582);
    freq.put("saí", 49);
    freq.put("xc", 114);
    freq.put("otí", 50);
    freq.put("xa", 1144);
    freq.put("saç", 57);
    freq.put("rgu", 385);
    freq.put("ond", 803);
    freq.put("xe", 384);
    freq.put("by ", 42);
    freq.put("fh", 27);
    freq.put("xx", 77);
    freq.put("ony", 29);
    freq.put("uld", 62);
    freq.put("pró", 156);
    freq.put("ua ", 1227);
    freq.put("onr", 23);
    freq.put("ons", 1024);
    freq.put("xp", 273);
    freq.put("onq", 55);
    freq.put("onv", 372);
    freq.put("UU ", 32);
    freq.put("xt", 361);
    freq.put("xu", 54);
    freq.put("iam", 197);
    freq.put("IM ", 132);
    freq.put("iao", 38);
    freq.put("ian", 688);
    freq.put("iai", 140);
    freq.put("iah", 39);
    freq.put("¬ ", 159);
    freq.put("iaj", 68);
    freq.put("iad", 353);
    freq.put("iag", 131);
    freq.put("iaa", 77);
    freq.put("xD", 99);
    freq.put("Dá", 30);
    freq.put("ule", 54);
    freq.put("ábi", 31);
    freq.put("aí ", 387);
    freq.put("iau", 34);
    freq.put("iat", 52);
    freq.put("Dou", 25);
    freq.put("ias", 705);
    freq.put("iar", 289);
    freq.put("ty ", 75);
    freq.put("hue", 32);
    freq.put("lás", 22);
    freq.put("aiz", 24);
    freq.put("hua", 478);
    freq.put("huc", 58);
    freq.put(" Ze", 34);
    freq.put("hum", 313);
    freq.put("x ", 584);
    freq.put("dic", 454);
    freq.put("huh", 91);
    freq.put("Eu ", 1158);
    freq.put("za ", 564);
    freq.put("ebi", 102);
    freq.put("hut", 39);
    freq.put("huu", 81);
    freq.put("huv", 136);
    freq.put("hup", 37);
    freq.put("hur", 60);
    freq.put("hus", 107);
    freq.put("Mis", 49);
    freq.put("tiç", 44);
    freq.put("mã", 916);
    freq.put(" Lá", 23);
    freq.put("Tal", 33);
    freq.put("ia ", 6912);
    freq.put("rzi", 34);
    freq.put("lho", 2108);
    freq.put("r", 118219);
    freq.put("bag", 89);
    freq.put("nie", 22);
    freq.put("ehe", 473);
    freq.put("IS ", 196);
    freq.put("ney", 61);
    freq.put("xou", 64);
    freq.put("sak", 24);
    freq.put("lóg", 50);
    freq.put("sai", 1036);
    freq.put("sah", 113);
    freq.put("óci", 59);
    freq.put("san", 685);
    freq.put("sam", 314);
    freq.put("sal", 386);
    freq.put("sac", 256);
    freq.put("xã", 48);
    freq.put("saa", 79);
    freq.put("rme", 230);
    freq.put("kao", 32);
    freq.put("saf", 72);
    freq.put("sae", 21);
    freq.put("sad", 493);
    freq.put("ant", 2714);
    freq.put("íni", 46);
    freq.put("SE ", 260);
    freq.put("lór", 27);
    freq.put("egu", 2285);
    freq.put("ans", 568);
    freq.put("sas", 917);
    freq.put("sar", 941);
    freq.put("car", 2854);
    freq.put("sap", 79);
    freq.put("sav", 71);
    freq.put("sau", 523);
    freq.put("sat", 59);
    freq.put("cd ", 33);
    freq.put("Do", 288);
    freq.put("omm", 22);
    freq.put("rmi", 1036);
    freq.put("Pho", 63);
    freq.put("Jac", 23);
    freq.put("Di", 505);
    freq.put("vei", 362);
    freq.put("iaç", 34);
    freq.put("De", 1239);
    freq.put(" ál", 33);
    freq.put("GO ", 145);
    freq.put("zon", 38);
    freq.put("Da", 333);
    freq.put("ás ", 155);
    freq.put("Sam", 30);
    freq.put(" ár", 43);
    freq.put("tér", 87);
    freq.put("wer", 35);
    freq.put("Du", 75);
    freq.put("Dr", 57);
    freq.put("ts ", 199);
    freq.put("dên", 41);
    freq.put("iõe", 30);
    freq.put("all", 92);
    freq.put("loq", 89);
    freq.put("Tav", 47);
    freq.put("tiu", 93);
    freq.put("sód", 25);
    freq.put("sa ", 5178);
    freq.put("têm", 36);
    freq.put("ípi", 25);
    freq.put("Sha", 30);
    freq.put("erí", 30);
    freq.put("tô ", 317);
    freq.put("Já ", 252);
    freq.put(" b ", 23);
    freq.put("zo ", 58);
    freq.put(" Le", 280);
    freq.put("RJ ", 21);
    freq.put(" La", 199);
    freq.put("uss", 95);
    freq.put(" Lo", 179);
    freq.put("ER ", 348);
    freq.put(" Li", 327);
    freq.put("aiv", 100);
    freq.put("dê ", 138);
    freq.put(" Lu", 210);
    freq.put(" nú", 43);
    freq.put("MG ", 71);
    freq.put("ô ", 608);
    freq.put("oy ", 42);
    freq.put("axo", 32);
    freq.put("ri ", 335);
    freq.put("fes", 439);
    freq.put("êni", 30);
    freq.put("bad", 361);
    freq.put("uiu", 58);
    freq.put("Fla", 90);
    freq.put(" p ", 359);
    freq.put("ama", 2154);
    freq.put("ais", 4030);
    freq.put("nli", 39);
    freq.put("uem", 1509);
    freq.put("lay", 71);
    freq.put("dy ", 84);
    freq.put("ss ", 316);
    freq.put("nlo", 29);
    freq.put("ába", 135);
    freq.put("We", 42);
    freq.put("uh ", 59);
    freq.put("Wa", 67);
    freq.put("XO ", 25);
    freq.put("Wo", 33);
    freq.put(" u ", 538);
    freq.put("ugu", 102);
    freq.put("Leg", 51);
    freq.put("lub", 82);
    freq.put("Wi", 94);
    freq.put("Wh", 25);
    freq.put("sou", 891);
    freq.put("tne", 27);
    freq.put(" só", 1870);
    freq.put("É ", 935);
    freq.put("alh", 926);
    freq.put("hão", 96);
    freq.put("êm ", 38);
    freq.put(" ps", 43);
    freq.put(" pr", 9426);
    freq.put("HS ", 27);
    freq.put("zei", 67);
    freq.put(" pu", 499);
    freq.put("get", 24);
    freq.put("ssu", 162);
    freq.put("H", 2354);
    freq.put("lít", 32);
    freq.put("rvo", 66);
    freq.put("oxa", 136);
    freq.put(" pc", 101);
    freq.put(" pa", 5897);
    freq.put("ssi", 1437);
    freq.put(" pf", 38);
    freq.put(" pe", 5333);
    freq.put("lui", 77);
    freq.put("sse", 2600);
    freq.put("dit", 424);
    freq.put(" pi", 790);
    freq.put("líc", 59);
    freq.put(" po", 6134);
    freq.put("já", 1078);
    freq.put("gem", 478);
    freq.put("jã", 45);
    freq.put("ráv", 35);
    freq.put(" bá", 23);
    freq.put("W ", 84);
    freq.put("cid", 531);
    freq.put("rát", 50);
    freq.put("Tim", 45);
    freq.put(" bê", 31);
    freq.put("sum", 153);
    freq.put("Vol", 85);
    freq.put("ó", 3880);
    freq.put("asm", 27);
    freq.put("amí", 85);
    freq.put("alf", 25);
    freq.put("rár", 82);
    freq.put("ult", 336);
    freq.put("mmm", 274);
    freq.put("uti", 110);
    freq.put("ooc", 32);
    freq.put("hõe", 33);
    freq.put("uq", 85);
    freq.put("pçã", 62);
    freq.put("aio", 363);
    freq.put("cin", 283);
    freq.put("Mas", 401);
    freq.put("kel", 33);
    freq.put("alg", 1080);
    freq.put("tõ", 30);
    freq.put("fff", 152);
    freq.put("tu ", 439);
    freq.put("cil", 346);
    freq.put("j ", 608);
    freq.put("ffe", 21);
    freq.put("cis", 725);
    freq.put(" sá", 126);
    freq.put("bio", 88);
    freq.put("jov", 36);
    freq.put("ítu", 33);
    freq.put("fdp", 40);
    freq.put("xa ", 514);
    freq.put("fds", 53);
    freq.put("uza", 43);
    freq.put("cip", 239);
    freq.put(" pú", 29);
    freq.put("mto", 186);
    freq.put(" pó", 34);
    freq.put("rô", 59);
    freq.put("tus", 26);
    freq.put("ciu", 56);
    freq.put(" pô", 34);
    freq.put("tup", 25);
    freq.put("ju", 853);
    freq.put("tur", 487);
    freq.put("cit", 75);
    freq.put("aíd", 37);
    freq.put("js", 188);
    freq.put(" pã", 32);
    freq.put("utz", 28);
    freq.put(" pá", 84);
    freq.put("jo", 2025);
    freq.put("tul", 62);
    freq.put("ji", 107);
    freq.put("tun", 41);
    freq.put("fez", 221);
    freq.put("jd", 22);
    freq.put("je", 2144);
    freq.put(" pé", 116);
    freq.put("tuc", 27);
    freq.put("ssá", 31);
    freq.put("ja", 2075);
    freq.put("ssã", 147);
    freq.put("cli", 143);
    freq.put(" be", 2068);
    freq.put("ssí", 95);
    freq.put(" bg", 28);
    freq.put("uf", 114);
    freq.put(" ba", 1843);
    freq.put("EM ", 576);
    freq.put(" bb", 32);
    freq.put(" bl", 289);
    freq.put(" bo", 2905);
    freq.put(" bi", 315);
    freq.put("P ", 370);
    freq.put(" bj", 277);
    freq.put(" bu", 308);
    freq.put("fiz", 204);
    freq.put("s", 124874);
    freq.put("odr", 43);
    freq.put(" br", 894);
    freq.put(" by", 28);
    freq.put("rtu", 218);
    freq.put("uci", 37);
    freq.put("sul", 96);
    freq.put("pov", 192);
    freq.put("pow", 33);
    freq.put("pot", 68);
    freq.put("pou", 582);
    freq.put("por", 3346);
    freq.put("pos", 1017);
    freq.put("pop", 59);
    freq.put("ís ", 48);
    freq.put("pon", 601);
    freq.put("poo", 88);
    freq.put("pol", 164);
    freq.put("ado", 4304);
    freq.put("pok", 40);
    freq.put("poh", 25);
    freq.put("poi", 956);
    freq.put("pod", 1065);
    freq.put("poe", 26);
    freq.put("pob", 47);
    freq.put("aís", 62);
    freq.put("azu", 31);
    freq.put("poa", 26);
    freq.put("lw ", 67);
    freq.put("¬¬ ", 150);
    freq.put(" Mã", 36);
    freq.put("amã", 41);
    freq.put("vro", 132);
    freq.put("dis", 660);
    freq.put("Liv", 37);
    freq.put("fom", 152);
    freq.put("ei ", 4330);
    freq.put("tên", 36);
    freq.put("fia", 187);
    freq.put("paç", 81);
    freq.put("nit", 261);
    freq.put("bil", 123);
    freq.put("tug", 83);
    freq.put("paí", 40);
    freq.put(" Mú", 27);
    freq.put("fig", 28);
    freq.put("nív", 26);
    freq.put("nsã", 24);
    freq.put("É", 879);
    freq.put("fie", 34);
    freq.put("ÊS ", 21);
    freq.put("ls ", 97);
    freq.put("odu", 101);
    freq.put("fik", 53);
    freq.put("lê ", 32);
    freq.put("po ", 1146);
    freq.put("aid", 51);
    freq.put("irm", 407);
    freq.put("eis", 194);
    freq.put("eir", 2240);
    freq.put("eiu", 22);
    freq.put("eit", 1242);
    freq.put("IL ", 56);
    freq.put("eix", 672);
    freq.put("ãs ", 63);
    freq.put("fio", 53);
    freq.put("eia", 432);
    freq.put("CO ", 106);
    freq.put("rê", 166);
    freq.put("eii", 87);
    freq.put("lhi", 42);
    freq.put("Sho", 61);
    freq.put("eij", 601);
    freq.put("eim", 141);
    freq.put("eil", 35);
    freq.put("eio", 747);
    freq.put("ein", 452);
    freq.put("ive", 1294);
    freq.put("uia", 125);
    freq.put("iva", 455);
    freq.put("éti", 71);
    freq.put("seg", 1645);
    freq.put("ivo", 433);
    freq.put("ivi", 223);
    freq.put("oi ", 1363);
    freq.put("ivu", 62);
    freq.put("há ", 126);
    freq.put("SD ", 26);
    freq.put("ivr", 207);
    freq.put("rê ", 21);
    freq.put("Bar", 88);
    freq.put("Bas", 26);
    freq.put("pap", 131);
    freq.put(" Me", 850);
    freq.put("par", 3764);
    freq.put("pas", 1130);
    freq.put("pat", 173);
    freq.put(" Ma", 1349);
    freq.put("pav", 21);
    freq.put(" Mc", 28);
    freq.put("chi", 164);
    freq.put("EZ ", 30);
    freq.put("paz", 121);
    freq.put(" Mo", 285);
    freq.put(" Mi", 493);
    freq.put("Sin", 63);
    freq.put(" Mu", 333);
    freq.put("pac", 126);
    freq.put("pad", 166);
    freq.put("pag", 274);
    freq.put("IR ", 131);
    freq.put("I ", 979);
    freq.put("vs ", 53);
    freq.put("pal", 439);
    freq.put("pam", 27);
    freq.put("pan", 342);
    freq.put("pao", 27);
    freq.put("oio", 47);
    freq.put("fs ", 26);
    freq.put("oim", 24);
    freq.put("cel", 369);
    freq.put("rês", 46);
    freq.put("Tch", 38);
    freq.put("oii", 54);
    freq.put("nac", 65);
    freq.put("I", 1563);
    freq.put("oie", 37);
    freq.put("oid", 114);
    freq.put("nsa", 915);
    freq.put("oib", 23);
    freq.put("oia", 90);
    freq.put(" Vl", 21);
    freq.put(" gu", 252);
    freq.put("ães", 27);
    freq.put("cei", 310);
    freq.put("maa", 125);
    freq.put("rên", 35);
    freq.put("rêm", 58);
    freq.put("oit", 778);
    freq.put("ois", 2442);
    freq.put("oir", 41);
    freq.put("nag", 101);
    freq.put("ds ", 192);
    freq.put(" M ", 44);
    freq.put("HO ", 168);
    freq.put("vul", 79);
    freq.put("Is", 152);
    freq.put("Ir", 62);
    freq.put("It", 45);
    freq.put("pa ", 648);
    freq.put("uhu", 150);
    freq.put("Im", 72);
    freq.put("eiç", 28);
    freq.put("In", 383);
    freq.put("Rei", 29);
    freq.put("oke", 33);
    freq.put("uie", 52);
    freq.put("Id", 24);
    freq.put("Ig", 34);
    freq.put("uhs", 148);
    freq.put("áa", 35);
    freq.put(" qq", 65);
    freq.put(" qr", 40);
    freq.put("áb", 177);
    freq.put(" qu", 16617);
    freq.put("ág", 178);
    freq.put("áf", 26);
    freq.put("nsc", 59);
    freq.put("tip", 238);
    freq.put("ps ", 148);
    freq.put("vid", 1330);
    freq.put("ál", 100);
    freq.put("óv", 23);
    freq.put("uu ", 135);
    freq.put("áp", 74);
    freq.put("ás", 236);
    freq.put("vã", 199);
    freq.put(" qd", 72);
    freq.put(" qe", 261);
    freq.put("mpo", 1101);
    freq.put("áv", 138);
    freq.put("uid", 308);
    freq.put("CD ", 58);
    freq.put("nam", 342);
    freq.put(" ql", 26);
    freq.put(" qm", 41);
    freq.put(" qn", 85);
    freq.put("cn", 80);
    freq.put(" cê", 28);
    freq.put("til", 172);
    freq.put(" cé", 62);
    freq.put("Her", 28);
    freq.put("tim", 836);
    freq.put(" câ", 22);
    freq.put("BA ", 45);
    freq.put(" cá", 44);
    freq.put("tin", 1375);
    freq.put("Men", 105);
    freq.put("ot ", 62);
    freq.put(" ge", 1137);
    freq.put("aq ", 39);
    freq.put("oko", 70);
    freq.put("iça", 193);
    freq.put("iço", 81);
    freq.put(" có", 21);
    freq.put("Bai", 49);
    freq.put("vê", 136);
    freq.put("áss", 26);
    freq.put("á ", 5141);
    freq.put("psi", 41);
    freq.put("amm", 23);
    freq.put("pso", 24);
    freq.put("nec", 117);
    freq.put("ást", 24);
    freq.put("mos", 1906);
    freq.put("mor", 2221);
    freq.put(" ga", 1443);
    freq.put("ame", 1123);
    freq.put("mov", 56);
    freq.put("mou", 112);
    freq.put("ês", 469);
    freq.put(" q ", 1915);
    freq.put("êm", 121);
    freq.put("ên", 360);
    freq.put("azo", 30);
    freq.put("ími", 32);
    freq.put("mon", 242);
    freq.put("mom", 182);
    freq.put("gro", 69);
    freq.put("moc", 88);
    freq.put("êe", 30);
    freq.put("Ze", 38);
    freq.put("amu", 32);
    freq.put("mof", 24);
    freq.put("êb", 27);
    freq.put("mod", 138);
    freq.put("oin", 45);
    freq.put("NA ", 245);
    freq.put("tig", 175);
    freq.put("Pin", 35);
    freq.put("Pio", 24);
    freq.put("oç", 415);
    freq.put("úni", 101);
    freq.put("oã", 51);
    freq.put("nai", 63);
    freq.put("uei", 748);
    freq.put("uii", 108);
    freq.put("vó", 65);
    freq.put("tee", 143);
    freq.put("t", 79747);
    freq.put("oes", 71);
    freq.put("BO ", 28);
    freq.put("Lov", 36);
    freq.put("gri", 268);
    freq.put("NE ", 46);
    freq.put("áá", 56);
    freq.put("são", 824);
    freq.put("Nem", 135);
    freq.put("Neg", 37);
    freq.put("td ", 86);
    freq.put("uih", 27);
    freq.put("sib", 26);
    freq.put("uaç", 81);
    freq.put("ezi", 37);
    freq.put("Ney", 31);
    freq.put("eze", 267);
    freq.put("uic", 28);
    freq.put("anu", 75);
    freq.put("eza", 405);
    freq.put("mbi", 145);
    freq.put("jão", 42);
    freq.put(" ch", 2502);
    freq.put(" ci", 495);
    freq.put("xce", 48);
    freq.put(" co", 14228);
    freq.put(" cl", 442);
    freq.put(" cm", 143);
    freq.put("AS ", 440);
    freq.put("hm ", 36);
    freq.put(" ca", 5553);
    freq.put("fi ", 26);
    freq.put(" cd", 37);
    freq.put("o ", 94997);
    freq.put("Meu", 277);
    freq.put("Met", 26);
    freq.put("uo ", 42);
    freq.put("içã", 222);
    freq.put("´", 86);
    freq.put("Mes", 52);
    freq.put("Mer", 39);
    freq.put(" cr", 650);
    freq.put("uch", 32);
    freq.put(" cu", 826);
    freq.put("oO", 48);
    freq.put("tdo", 33);
    freq.put("und", 1150);
    freq.put("mpi", 79);
    freq.put("édi", 210);
    freq.put("oC", 23);
    freq.put("qi ", 56);
    freq.put("qnd", 71);
    freq.put("TÁ ", 71);
    freq.put("squ", 597);
    freq.put("êê", 38);
    freq.put("tds", 35);
    freq.put("fác", 102);
    freq.put("oro", 412);
    freq.put("ez ", 703);
    freq.put("tv ", 84);
    freq.put("oo", 5363);
    freq.put("on", 9487);
    freq.put("om", 13057);
    freq.put("ol", 5611);
    freq.put("ok", 577);
    freq.put("oj", 1918);
    freq.put("oi", 5186);
    freq.put("oh", 197);
    freq.put("og", 2147);
    freq.put("of", 871);
    freq.put("oe", 441);
    freq.put("od", 3963);
    freq.put("oc", 5044);
    freq.put("ob", 1638);
    freq.put("oa", 2800);
    freq.put("srs", 552);
    freq.put("lda", 117);
    freq.put("oz", 382);
    freq.put("oy", 79);
    freq.put("ox", 312);
    freq.put("ow", 744);
    freq.put("ov", 2346);
    freq.put("ou", 10362);
    freq.put("ot", 2272);
    freq.put("os", 15485);
    freq.put("or", 18662);
    freq.put("oq", 425);
    freq.put("op", 975);
    freq.put("LE ", 105);
    freq.put("Ni", 120);
    freq.put("ju ", 33);
    freq.put("ys ", 45);
    freq.put(" ág", 72);
    freq.put("aze", 1634);
    freq.put("aç", 2604);
    freq.put("No", 735);
    freq.put("uil", 158);
    freq.put("Na", 390);
    freq.put("aê", 44);
    freq.put("aí", 542);
    freq.put("Ne", 338);
    freq.put("qro", 21);
    freq.put("bju", 24);
    freq.put("Ade", 22);
    freq.put("bjs", 107);
    freq.put("Ado", 93);
    freq.put("aú", 78);
    freq.put("Nu", 122);
    freq.put("Adi", 24);
    freq.put("het", 39);
    freq.put("heu", 103);
    freq.put("sõe", 39);
    freq.put("ehu", 37);
    freq.put("log", 536);
    freq.put("her", 468);
    freq.put("hes", 49);
    freq.put("ni ", 128);
    freq.put("lok", 74);
    freq.put("EL ", 48);
    freq.put("loi", 34);
    freq.put("lon", 207);
    freq.put("ngi", 61);
    freq.put("lol", 26);
    freq.put("lom", 31);
    freq.put("ode", 1358);
    freq.put("hee", 54);
    freq.put("hef", 22);
    freq.put("heg", 957);
    freq.put("lov", 44);
    freq.put("hea", 39);
    freq.put("Jan", 48);
    freq.put("hec", 258);
    freq.put("hel", 52);
    freq.put("hem", 52);
    freq.put("hen", 65);
    freq.put("heh", 448);
    freq.put("hei", 926);
    freq.put("ehh", 26);
    freq.put("boo", 273);
    freq.put("Pq ", 65);
    freq.put("mpu", 105);
    freq.put("sid", 212);
    freq.put("jud", 269);
    freq.put("bj ", 32);
    freq.put("N ", 295);
    freq.put("jui", 38);
    freq.put("jun", 198);
    freq.put("na ", 5288);
    freq.put("jul", 56);
    freq.put("jur", 78);
    freq.put("jus", 99);
    freq.put("e", 219127);
    freq.put(" su", 1709);
    freq.put("mpr", 1351);
    freq.put("lo ", 1702);
    freq.put("agi", 301);
    freq.put(" sk", 51);
    freq.put("mat", 551);
    freq.put("lên", 41);
    freq.put("upl", 31);
    freq.put("uês", 40);
    freq.put("pá ", 58);
    freq.put("dve", 23);
    freq.put("cão", 69);
    freq.put("as ", 11925);
    freq.put("he ", 506);
    freq.put("eh ", 361);
    freq.put("ciê", 58);
    freq.put("BE ", 23);
    freq.put("Ava", 30);
    freq.put("Mãe", 28);
    freq.put("aa", 5507);
    freq.put("Né", 21);
    freq.put("ac", 5004);
    freq.put("ab", 4420);
    freq.put("ae", 749);
    freq.put("ad", 11881);
    freq.put("ag", 3836);
    freq.put("af", 892);
    freq.put("ai", 11881);
    freq.put("ah", 4962);
    freq.put("ak", 541);
    freq.put("aj", 513);
    freq.put("am", 11120);
    freq.put("al", 12124);
    freq.put("ao", 3077);
    freq.put("an", 17854);
    freq.put("aq", 2583);
    freq.put("ap", 2196);
    freq.put("as", 18452);
    freq.put("ar", 23986);
    freq.put("au", 2974);
    freq.put("at", 5168);
    freq.put("aw", 128);
    freq.put("av", 2768);
    freq.put("ay", 326);
    freq.put("ax", 210);
    freq.put("Nó", 24);
    freq.put("uis", 389);
    freq.put("uí", 103);
    freq.put("igu", 355);
    freq.put("Mun", 62);
    freq.put("igr", 70);
    freq.put("Lad", 38);
    freq.put("ãão", 22);
    freq.put("mm ", 144);
    freq.put("noi", 751);
    freq.put("ige", 67);
    freq.put("heç", 97);
    freq.put("iga", 1563);
    freq.put("ota", 664);
    freq.put("igo", 1495);
    freq.put("ign", 160);
    freq.put("you", 48);
    freq.put("éee", 23);
    freq.put("igi", 145);
    freq.put("igh", 42);
    freq.put("a ", 90856);
    freq.put("lga", 148);
    freq.put(" g ", 28);
    freq.put("ru", 1383);
    freq.put("sia", 109);
    freq.put("uê", 101);
    freq.put("oh ", 95);
    freq.put("goo", 133);
    freq.put("ote", 309);
    freq.put(" ñ ", 160);
    freq.put(" zi", 22);
    freq.put("Hor", 48);
    freq.put("lês", 60);
    freq.put("uzi", 59);
    freq.put("oão", 49);
    freq.put("US ", 150);
    freq.put("AZ ", 32);
    freq.put("mud", 303);
    freq.put("Bru", 48);
    freq.put("gên", 36);
    freq.put("ué ", 34);
    freq.put("u", 92572);
    freq.put("Bri", 64);
    freq.put("ig ", 37);
    freq.put("ée ", 37);
    freq.put("úsi", 290);
    freq.put("Bra", 389);
    freq.put("alo", 648);
    freq.put("sco", 959);
    freq.put("Fiq", 53);
    freq.put("sci", 120);
    freq.put("mp ", 37);
    freq.put("lr ", 122);
    freq.put("sce", 177);
    freq.put("iu ", 820);
    freq.put("ald", 225);
    freq.put("ale", 1117);
    freq.put("sca", 401);
    freq.put("rrí", 33);
    freq.put("izm", 24);
    freq.put("Fic", 75);
    freq.put("gt", 23);
    freq.put("ndu", 46);
    freq.put("Fig", 21);
    freq.put("scu", 459);
    freq.put("gs", 77);
    freq.put("fa ", 148);
    freq.put("alu", 93);
    freq.put("Fin", 58);
    freq.put("oad", 70);
    freq.put("Fil", 61);
    freq.put("Fim", 23);
    freq.put("smo", 1233);
    freq.put("tz", 56);
    freq.put("ty", 97);
    freq.put("tv", 103);
    freq.put(" N ", 67);
    freq.put("tt", 966);
    freq.put("tu", 3259);
    freq.put("tr", 5665);
    freq.put("ts", 268);
    freq.put("Ess", 278);
    freq.put("zme", 24);
    freq.put("tn", 51);
    freq.put("to", 15528);
    freq.put("tl", 95);
    freq.put("tm", 105);
    freq.put("th", 401);
    freq.put("ti", 6827);
    freq.put("td", 169);
    freq.put("te", 20031);
    freq.put("tb", 498);
    freq.put("tc", 258);
    freq.put("ta", 17350);
    freq.put("faz", 2035);
    freq.put("iuh", 38);
    freq.put("edi", 778);
    freq.put("ium", 56);
    freq.put("smi", 40);
    freq.put("mpa", 389);
    freq.put("iua", 40);
    freq.put("fas", 124);
    freq.put("soz", 104);
    freq.put("Não", 813);
    freq.put("fav", 223);
    freq.put("sc ", 25);
    freq.put("fat", 85);
    freq.put("edo", 652);
    freq.put(" zu", 93);
    freq.put("fai", 36);
    freq.put(" rá", 91);
    freq.put("fal", 2101);
    freq.put("rm", 2375);
    freq.put("fab", 23);
    freq.put("fac", 342);
    freq.put("ius", 37);
    freq.put("zã", 64);
    freq.put("uze", 70);
    freq.put("sme", 44);
    freq.put("fad", 71);
    freq.put(" Ni", 120);
    freq.put("gg", 53);
    freq.put("ód", 68);
    freq.put("is ", 5620);
    freq.put(" No", 705);
    freq.put(" Na", 387);
    freq.put(" Ne", 332);
    freq.put("ge", 2410);
    freq.put("aje", 24);
    freq.put("ngo", 472);
    freq.put("eço", 360);
    freq.put("sma", 183);
    freq.put("dúv", 40);
    freq.put("mio", 126);
    freq.put("eça", 713);
    freq.put("rk", 190);
    freq.put(" Nu", 122);
    freq.put("eçe", 33);
    freq.put("ane", 368);
    freq.put("tei", 798);
    freq.put("tej", 57);
    freq.put("Ano", 34);
    freq.put("Log", 29);
    freq.put("ga", 6497);
    freq.put("ten", 2038);
    freq.put("teo", 32);
    freq.put("tea", 131);
    freq.put("teb", 117);
    freq.put("edu", 113);
    freq.put("ted", 38);
    freq.put("pun", 30);
    freq.put("teg", 64);
    freq.put("tex", 41);
    freq.put("go", 6566);
    freq.put("tez", 199);
    freq.put("asp", 28);
    freq.put("rui", 210);
    freq.put("aos", 194);
    freq.put("ter", 2908);
    freq.put("tes", 901);
    freq.put("tet", 38);
    freq.put("gm", 69);
    freq.put("uçã", 79);
    freq.put("rô ", 21);
    freq.put("sug", 27);
    freq.put("rbo", 36);
    freq.put(" y", 187);
    freq.put("tú", 24);
    freq.put("sub", 113);
    freq.put("sua", 1058);
    freq.put("rot", 346);
    freq.put("tô", 339);
    freq.put(" Ag", 293);
    freq.put("uiz", 84);
    freq.put("tó", 271);
    freq.put("sui", 39);
    freq.put("suh", 141);
    freq.put("pud", 65);
    freq.put("abr", 426);
    freq.put("tí", 116);
    freq.put("tê", 86);
    freq.put("sur", 148);
    freq.put("té", 1060);
    freq.put("xon", 112);
    freq.put("aby", 27);
    freq.put("FF ", 38);
    freq.put("tâ", 51);
    freq.put("tã", 1390);
    freq.put("tá", 1719);
    freq.put(" ru", 370);
    freq.put(" rt", 22);
    freq.put("HU ", 40);
    freq.put("umo", 125);
    freq.put(" rs", 747);
    freq.put("Nom", 23);
    freq.put("te ", 7779);
    freq.put("lég", 70);
    freq.put("K", 1103);
    freq.put("ças", 178);
    freq.put("çar", 365);
    freq.put(" re", 2954);
    freq.put("çan", 108);
    freq.put("çam", 120);
    freq.put("veu", 48);
    freq.put(" ra", 501);
    freq.put("pub", 50);
    freq.put("qm ", 39);
    freq.put(" ro", 708);
    freq.put("çad", 192);
    freq.put(" ri", 538);
    freq.put("faç", 226);
    freq.put("Noi", 71);
    freq.put(" Né", 21);
    freq.put("à", 281);
    freq.put("Rod", 30);
    freq.put("su ", 22);
    freq.put("oma", 612);
    freq.put("PE ", 30);
    freq.put(" Nã", 814);
    freq.put("íli", 116);
    freq.put("asa", 1139);
    freq.put("xe ", 123);
    freq.put("lly", 46);
    freq.put("anq", 77);
    freq.put("rba", 53);
    freq.put("xo ", 350);
    freq.put("eçã", 118);
    freq.put("pux", 31);
    freq.put(" Nó", 24);
    freq.put(" ª ", 70);
    freq.put("CK ", 29);
    freq.put("rku", 120);
    freq.put("lke", 23);
    freq.put("nto", 2609);
    freq.put("Sua", 37);
    freq.put("va", 6728);
    freq.put("Ela", 112);
    freq.put("vez", 656);
    freq.put("vii", 49);
    freq.put("uém", 534);
    freq.put("Aul", 25);
    freq.put("vil", 165);
    freq.put("vim", 97);
    freq.put("vir", 496);
    freq.put("vis", 491);
    freq.put("vc", 1860);
    freq.put("viv", 358);
    freq.put("mun", 712);
    freq.put("vit", 157);
    freq.put("viu", 377);
    freq.put("viz", 46);
    freq.put("vd", 66);
    freq.put("S ", 2007);
    freq.put("asi", 534);
    freq.put("Tod", 144);
    freq.put("bêb", 26);
    freq.put("ear", 162);
    freq.put("twi", 562);
    freq.put("twe", 147);
    freq.put("etc", 56);
    freq.put("eym", 40);
    freq.put("iúm", 31);
    freq.put(" d ", 253);
    freq.put("vee", 50);
    freq.put("anc", 512);
    freq.put("uar", 475);
    freq.put("VE ", 66);
    freq.put("vi", 5381);
    freq.put("de ", 16404);
    freq.put("Ta ", 100);
    freq.put("NÉ ", 36);
    freq.put("dex", 30);
    freq.put("iz ", 996);
    freq.put("vi ", 415);
    freq.put("fó", 22);
    freq.put("EH ", 21);
    freq.put("ÉM ", 50);
    freq.put("uno", 78);
    freq.put("Sp", 43);
    freq.put("Su", 231);
    freq.put("St", 94);
    freq.put("Sk", 27);
    freq.put("fá", 124);
    freq.put("Si", 432);
    freq.put("Sh", 116);
    freq.put("So", 503);
    freq.put("Sc", 30);
    freq.put("fé", 173);
    freq.put("Sa", 686);
    freq.put("fí", 157);
    freq.put("Se", 1526);
    freq.put("á", 7352);
    freq.put("ey ", 139);
    freq.put(" dm", 61);
    freq.put("vem", 539);
    freq.put("lhã", 25);
    freq.put(" di", 4561);
    freq.put("Int", 102);
    freq.put("aba", 1092);
    freq.put(" de", 18212);
    freq.put("des", 2282);
    freq.put("det", 84);
    freq.put("deu", 611);
    freq.put(" da", 5818);
    freq.put("Ins", 31);
    freq.put("bur", 79);
    freq.put("dei", 1509);
    freq.put("lhõ", 32);
    freq.put("uxe", 29);
    freq.put("del", 725);
    freq.put("dem", 943);
    freq.put("den", 646);
    freq.put("v", 33055);
    freq.put("Ind", 104);
    freq.put(" dv", 24);
    freq.put("Inf", 30);
    freq.put("Ing", 21);
    freq.put("ded", 113);
    freq.put(" dr", 141);
    freq.put("def", 108);
    freq.put("Inc", 22);
    freq.put(" ô ", 23);
    freq.put("qq ", 37);
    freq.put("çou", 94);
    freq.put("Do ", 59);
    freq.put("uxa", 61);
    freq.put("RS ", 42);
    freq.put("ann", 71);
    freq.put(" z ", 22);
    freq.put(" Às", 22);
    freq.put(" Fi", 355);
    freq.put("hha", 136);
    freq.put("lal", 43);
    freq.put("Vil", 22);
    freq.put("uxo", 30);
    freq.put("pai", 534);
    freq.put("hhh", 230);
    freq.put("Vis", 33);
    freq.put("iPh", 22);
    freq.put("ano", 1201);
    freq.put("att", 27);
    freq.put("uns", 329);
    freq.put("ava", 1489);
    freq.put("ôn", 166);
    freq.put("réd", 44);
    freq.put("ôm", 23);
    freq.put("r ", 31164);
    freq.put("cag", 37);
    freq.put("fr", 1025);
    freq.put("fs", 43);
    freq.put("ft", 36);
    freq.put("fu", 1118);
    freq.put("Glo", 46);
    freq.put("Só", 318);
    freq.put("pri", 709);
    freq.put("Olh", 111);
    freq.put("Cin", 29);
    freq.put("rmo", 164);
    freq.put("fa", 5920);
    freq.put("Sé", 56);
    freq.put("hh ", 163);
    freq.put("fd", 108);
    freq.put("fe", 2817);
    freq.put("ff", 421);
    freq.put("não", 5333);
    freq.put("Sã", 165);
    freq.put("fi", 4622);
    freq.put("Sá", 33);
    freq.put("fl", 332);
    freq.put("fo", 4095);
    freq.put("a", 253113);
    freq.put("bar", 409);
    freq.put("lhe", 563);
    freq.put(" dê", 58);
    freq.put("lha", 1281);
    freq.put("ges", 48);
    freq.put("egr", 241);
    freq.put(" dã", 26);
    freq.put("cs ", 296);
    freq.put(" dá", 313);
    freq.put("uhe", 54);
    freq.put("afé", 87);
    freq.put("egi", 119);
    freq.put("ês ", 457);
    freq.put("ego", 470);
    freq.put(" dú", 44);
    freq.put("ari", 1099);
    freq.put("ega", 1599);
    freq.put("CA ", 193);
    freq.put(" dó", 75);
    freq.put("ege", 57);
    freq.put("deç", 21);
    freq.put("itn", 22);
    freq.put("ito", 2912);
    freq.put("ith", 27);
    freq.put("iti", 288);
    freq.put("y ", 1118);
    freq.put("ite", 1243);
    freq.put("itc", 60);
    freq.put("ita", 1702);
    freq.put("ok ", 315);
    freq.put(" sé", 202);
    freq.put("ity", 26);
    freq.put(" sã", 439);
    freq.put("itt", 643);
    freq.put("itu", 219);
    freq.put("itr", 39);
    freq.put("ve ", 1191);
    freq.put("pid", 145);
    freq.put(" On", 111);
    freq.put(" Oo", 26);
    freq.put(" Ol", 196);
    freq.put("ll ", 127);
    freq.put("ank", 28);
    freq.put(" Ok", 44);
    freq.put(" Oh", 27);
    freq.put(" Oi", 136);
    freq.put(" Of", 21);
    freq.put(" Od", 36);
    freq.put(" Ob", 170);
    freq.put("ae ", 369);
    freq.put("Às", 22);
    freq.put("usp", 47);
    freq.put("pci", 31);
    freq.put("tp ", 41);
    freq.put(" Ow", 28);
    freq.put("ar ", 11930);
    freq.put(" Ou", 164);
    freq.put(" Or", 101);
    freq.put(" Os", 153);
    freq.put(" Op", 62);
    freq.put("ouv", 410);
    freq.put("zoa", 24);
    freq.put("Bat", 49);
    freq.put("ced", 247);
    freq.put("ym", 61);
    freq.put("yl", 48);
    freq.put("yo", 91);
    freq.put("yn", 88);
    freq.put("ya", 49);
    freq.put("cen", 408);
    freq.put("cem", 118);
    freq.put("yb", 22);
    freq.put("ye", 58);
    freq.put("L", 1965);
    freq.put("it ", 72);
    freq.put("oka", 53);
    freq.put("ceu", 191);
    freq.put("cet", 25);
    freq.put("ces", 383);
    freq.put("cer", 1178);
    freq.put("dig", 212);
    freq.put("cep", 65);
    freq.put("Ban", 77);
    freq.put("yp", 27);
    freq.put("ys", 70);
    freq.put("yr", 21);
    freq.put("Bah", 43);
    freq.put("ff ", 166);
    freq.put("Raf", 29);
    freq.put("uat", 31);
    freq.put("Tar", 52);
    freq.put("nvi", 179);
    freq.put("MI ", 30);
    freq.put(" O ", 1795);
    freq.put(" ée", 30);
    freq.put("ife", 191);
    freq.put("val", 450);
    freq.put("man", 3138);
    freq.put("die", 35);
    freq.put("pc ", 90);
    freq.put("stá", 624);
    freq.put("ifi", 254);
    freq.put(" A ", 1240);
    freq.put("Enc", 37);
    freq.put("Enf", 28);
    freq.put("Eng", 25);
    freq.put(" sr", 24);
    freq.put("tre", 747);
    freq.put(" sp", 43);
    freq.put("rôn", 34);
    freq.put(" st", 102);
    freq.put("itá", 35);
    freq.put("Enq", 28);
    freq.put(" sh", 468);
    freq.put(" si", 1603);
    freq.put("Ent", 210);
    freq.put(" so", 3261);
    freq.put(" sl", 32);
    freq.put(" sm", 94);
    freq.put("stâ", 31);
    freq.put("uda", 1206);
    freq.put(" sa", 3491);
    freq.put("Mui", 129);
    freq.put("itó", 75);
    freq.put(" sd", 28);
    freq.put(" se", 11477);
    freq.put("Wil", 43);
    freq.put("iza", 417);
    freq.put("ize", 472);
    freq.put("adm", 47);
    freq.put("gur", 181);
    freq.put("izi", 93);
    freq.put("at ", 92);
    freq.put("E ", 3821);
    freq.put("izo", 49);
    freq.put("SH ", 41);
    freq.put("NS ", 70);
    freq.put("abl", 42);
    freq.put("afi", 228);
    freq.put("stã", 301);
    freq.put("izz", 85);
    freq.put("uui", 129);
    freq.put("pul", 129);
    freq.put(" Aa", 37);
    freq.put(" Ab", 130);
    freq.put(" Ac", 464);
    freq.put(" Ad", 189);
    freq.put(" Ae", 43);
    freq.put(" Af", 100);
    freq.put("HE ", 21);
    freq.put(" Ah", 186);
    freq.put(" Ai", 277);
    freq.put(" Al", 395);
    freq.put(" Am", 547);
    freq.put(" An", 337);
    freq.put(" Ao", 58);
    freq.put(" Ap", 162);
    freq.put(" Aq", 109);
    freq.put(" Ar", 171);
    freq.put(" As", 271);
    freq.put(" At", 212);
    freq.put(" Au", 57);
    freq.put(" Av", 88);
    freq.put("diu", 67);
    freq.put("put", 301);
    freq.put("st ", 166);
    freq.put(" s ", 705);
    freq.put("ash", 222);
    freq.put("aso", 139);
    freq.put("ódi", 63);
    freq.put("pur", 63);
    freq.put("tif", 48);
    freq.put("Em", 195);
    freq.put("El", 348);
    freq.put("En", 372);
    freq.put("Ei", 92);
    freq.put("alt", 706);
    freq.put("ion", 581);
    freq.put("Ed", 78);
    freq.put("Ea", 22);
    freq.put("últ", 89);
    freq.put("Ex", 116);
    freq.put("w", 2690);
    freq.put("HD ", 27);
    freq.put("Eu", 1194);
    freq.put("ifí", 106);
    freq.put("Ev", 34);
    freq.put(" ef", 39);
    freq.put("Es", 942);
    freq.put("Er", 45);
    freq.put("Ima", 27);
    freq.put("le ", 2274);
    freq.put("Fra", 59);
    freq.put("Cli", 25);
    freq.put("Fre", 46);
    freq.put("uel", 590);
    freq.put("óxi", 98);
    freq.put("Fri", 28);
    freq.put("Cla", 83);
    freq.put("EU ", 578);
    freq.put("Imp", 35);
    freq.put("ude", 343);
    freq.put("zo", 173);
    freq.put("tot", 56);
    freq.put("ur ", 44);
    freq.put("Clu", 22);
    freq.put("uuu", 874);
    freq.put("osc", 52);
    freq.put("zi", 652);
    freq.put(" el", 2563);
    freq.put("jes", 26);
    freq.put(" en", 2686);
    freq.put("liç", 42);
    freq.put(" eh", 245);
    freq.put(" ei", 220);
    freq.put("jet", 93);
    freq.put(" ed", 150);
    freq.put(" ee", 111);
    freq.put("X ", 145);
    freq.put(" ea", 37);
    freq.put(" ec", 29);
    freq.put(" ex", 785);
    freq.put("jee", 26);
    freq.put(" et", 127);
    freq.put(" eu", 7049);
    freq.put(" ev", 129);
    freq.put("jei", 239);
    freq.put(" ep", 52);
    freq.put(" eq", 46);
    freq.put(" er", 686);
    freq.put(" es", 7493);
    freq.put("omu", 78);
    freq.put("ag ", 59);
    freq.put("ém ", 1081);
    freq.put("ncr", 72);
    freq.put("tom", 639);
    freq.put("mbr", 640);
    freq.put("ncu", 29);
    freq.put("Até", 86);
    freq.put("nch", 186);
    freq.put("nci", 801);
    freq.put("ofa", 80);
    freq.put("ncl", 36);
    freq.put("uec", 374);
    freq.put("nco", 626);
    freq.put("nca", 888);
    freq.put("ueb", 95);
    freq.put("nce", 433);
    freq.put("ste", 986);
    freq.put("b", 21173);
    freq.put("aaa", 3496);
    freq.put("sta", 3204);
    freq.put("dam", 130);
    freq.put("odi", 222);
    freq.put("aam", 37);
    freq.put("ko ", 71);
    freq.put("aao", 46);
    freq.put("sto", 1656);
    freq.put(" e ", 9608);
    freq.put("sti", 1094);
    freq.put("bjo", 64);
    freq.put("Nun", 82);
    freq.put("i", 119596);
    freq.put("je ", 1659);
    freq.put("htt", 43);
    freq.put("str", 895);
    freq.put("sts", 28);
    freq.put("águ", 71);
    freq.put("íti", 63);
    freq.put("vá ", 54);
    freq.put("Gom", 23);
    freq.put("Gol", 28);
    freq.put("Goo", 54);
    freq.put("ka ", 106);
    freq.put("js ", 62);
    freq.put("gá", 24);
    freq.put("sh ", 107);
    freq.put("udi", 154);
    freq.put("odo", 1117);
    freq.put("Mus", 24);
    freq.put(" le", 1554);
    freq.put("ofo", 119);
    freq.put("oda", 917);
    freq.put("aci", 412);
    freq.put("Gov", 23);
    freq.put("Gos", 72);
    freq.put("vaz", 36);
    freq.put("lid", 312);
    freq.put("ofr", 122);
    freq.put("lif", 23);
    freq.put("k ", 2342);
    freq.put("Nin", 53);
    freq.put("lia", 409);
    freq.put("ex ", 76);
    freq.put("lic", 579);
    freq.put("lim", 225);
    freq.put("efr", 21);
    freq.put("lio", 59);
    freq.put("bic", 89);
    freq.put("lii", 78);
    freq.put("ção", 1986);
    freq.put("rrr", 244);
    freq.put("lit", 152);
    freq.put("efi", 131);
    freq.put("liv", 412);
    freq.put("lip", 125);
    freq.put("liq", 35);
    freq.put("efo", 72);
    freq.put("víd", 100);
    freq.put("efa", 39);
    freq.put("lix", 46);
    freq.put("efe", 227);
    freq.put("liz", 634);
    freq.put("apã", 21);
    freq.put("Ate", 38);
    freq.put("kak", 28);
    freq.put("elm", 45);
    freq.put("Atl", 39);
    freq.put(" vã", 183);
    freq.put("M", 5469);
    freq.put("Ah ", 123);
    freq.put("kas", 43);
    freq.put("kar", 37);
    freq.put("Vai", 150);
    freq.put("Thi", 34);
    freq.put("jss", 28);
    freq.put("pés", 35);
    freq.put("às", 117);
    freq.put("Tha", 27);
    freq.put("bac", 76);
    freq.put("ka", 378);
    freq.put("â", 259);
    freq.put("li ", 178);
    freq.put("exc", 92);
    freq.put("ke", 455);
    freq.put("kd", 59);
    freq.put("kk", 17500);
    freq.put("exo", 130);
    freq.put("ki", 493);
    freq.put("ko", 182);
    freq.put("sté", 35);
    freq.put("km", 31);
    freq.put("kl", 34);
    freq.put("ks", 266);
    freq.put("kr", 30);
    freq.put("ext", 340);
    freq.put("kp", 38);
    freq.put("ku", 148);
    freq.put("stó", 123);
    freq.put("yn ", 57);
    freq.put("luç", 27);
    freq.put("ky", 40);
    freq.put("une", 29);
    freq.put("Hah", 145);
    freq.put("ath", 44);
    freq.put("ugi", 34);
    freq.put("boc", 121);
    freq.put("rta", 922);
    freq.put("rto", 793);
    freq.put("âns", 24);
    freq.put("rti", 652);
    freq.put("ác", 155);
    freq.put(" ót", 133);
    freq.put("hi ", 84);
    freq.put("lum", 76);
    freq.put("oje", 1757);
    freq.put("góc", 49);
    freq.put("oja", 62);
    freq.put("ojo", 63);
    freq.put("Har", 45);
    freq.put("baa", 48);
    freq.put("To ", 261);
    freq.put("ões", 503);
    freq.put("ád", 56);
    freq.put("Ju", 211);
    freq.put("ies", 50);
    freq.put("ier", 59);
    freq.put("IA ", 275);
    freq.put("iei", 56);
    freq.put("adã", 47);
    freq.put("Jo", 311);
    freq.put("iem", 26);
    freq.put("iel", 73);
    freq.put("ien", 180);
    freq.put("Je", 130);
    freq.put("ieb", 44);
    freq.put("ox ", 54);
    freq.put("ied", 65);
    freq.put("VD ", 29);
    freq.put("rd ", 90);
    freq.put("hip", 48);
    freq.put("ela", 2661);
    freq.put("his", 191);
    freq.put("hit", 21);
    freq.put("hiu", 24);
    freq.put("aad", 52);
    freq.put("ose", 109);
    freq.put("õe ", 22);
    freq.put("arm", 119);
    freq.put("hia", 239);
    freq.put("hic", 39);
    freq.put("hih", 118);
    freq.put(" ó ", 32);
    freq.put("íde", 137);
    freq.put("hil", 54);
    freq.put("hin", 117);
    freq.put("hio", 26);
    freq.put("ã", 14026);
    freq.put("áx", 30);
    freq.put("ági", 65);
    freq.put("rfu", 26);
    freq.put("cru", 57);
    freq.put("lli", 84);
    freq.put("utu", 144);
    freq.put("rfa", 22);
    freq.put("ár", 641);
    freq.put("dav", 47);
    freq.put("oxi", 69);
    freq.put("rfe", 149);
    freq.put("cre", 612);
    freq.put("ie ", 230);
    freq.put("rfi", 43);
    freq.put("cri", 456);
    freq.put("J ", 107);
    freq.put("cro", 63);
    freq.put("át", 161);
    freq.put(" Be", 409);
    freq.put("Ago", 213);
    freq.put("seu", 1060);
    freq.put("set", 171);
    freq.put(" Ba", 424);
    freq.put("ser", 2162);
    freq.put("For", 81);
    freq.put("sep", 53);
    freq.put(" Bl", 100);
    freq.put(" Bo", 1037);
    freq.put(" Bi", 135);
    freq.put("lot", 65);
    freq.put(" Bj", 75);
    freq.put("Fod", 43);
    freq.put("ara", 4630);
    freq.put("see", 53);
    freq.put("ik ", 25);
    freq.put("sec", 68);
    freq.put("are", 1152);
    freq.put("sea", 35);
    freq.put(" Br", 540);
    freq.put("sen", 1149);
    freq.put("sem", 1942);
    freq.put("sel", 154);
    freq.put("arl", 91);
    freq.put("Foi", 67);
    freq.put("sei", 1064);
    freq.put("lee", 67);
    freq.put("vra", 197);
    freq.put("uuh", 26);
    freq.put("mo ", 3918);
    freq.put("Vit", 39);
    freq.put("stu", 448);
    freq.put("ê ", 2731);
    freq.put("leg", 520);
    freq.put("al ", 2715);
    freq.put("vas", 198);
    freq.put("úme", 76);
    freq.put("chu", 297);
    freq.put("rça", 190);
    freq.put(" P ", 103);
    freq.put("atr", 427);
    freq.put("Pla", 48);
    freq.put("lei", 524);
    freq.put("ms ", 135);
    freq.put("DD ", 54);
    freq.put("Já", 253);
    freq.put("rço", 43);
    freq.put("bén", 207);
    freq.put("adv", 28);
    freq.put("bém", 438);
    freq.put(" B ", 71);
    freq.put("oss", 1672);
    freq.put("web", 32);
    freq.put("Dor", 55);
    freq.put("lel", 24);
    freq.put("be ", 785);
    freq.put("uus", 28);
    freq.put("lem", 714);
    freq.put("uum", 34);
    freq.put("uul", 26);
    freq.put("ika", 61);
    freq.put("adu", 80);
    freq.put("poc", 112);
    freq.put("len", 305);
    freq.put("ike", 75);
    freq.put("se ", 5752);
    freq.put("bia", 167);
    freq.put("ozi", 189);
    freq.put("Obr", 132);
    freq.put("Sem", 158);
    freq.put("skp", 22);
    freq.put(" Pr", 777);
    freq.put("c", 58671);
    freq.put("arn", 62);
    freq.put(" Pu", 56);
    freq.put("éns", 212);
    freq.put("ágr", 30);
    freq.put("rma", 627);
    freq.put("çoe", 59);
    freq.put(" Pa", 1083);
    freq.put("gei", 22);
    freq.put(" Pe", 565);
    freq.put("SP ", 80);
    freq.put(" Pi", 165);
    freq.put(" Ph", 46);
    freq.put(" Po", 806);
    freq.put(" Pl", 62);
    freq.put("Wan", 22);
    freq.put("Em ", 130);
    freq.put("rpr", 68);
    freq.put("çoa", 25);
    freq.put("oqu", 275);
    freq.put("Ita", 30);
    freq.put("Fat", 29);
    freq.put("aur", 68);
    freq.put("riç", 34);
    freq.put("pão", 71);
    freq.put("ubo", 31);
    freq.put("iên", 95);
    freq.put(" t ", 207);
    freq.put("pr", 11578);
    freq.put("ps", 281);
    freq.put("pp", 151);
    freq.put("pq", 792);
    freq.put(" pq", 787);
    freq.put("pt", 80);
    freq.put("pu", 734);
    freq.put("dua", 171);
    freq.put("xar", 300);
    freq.put("óp", 93);
    freq.put("xat", 39);
    freq.put(" º ", 120);
    freq.put("Agr", 24);
    freq.put("geo", 26);
    freq.put("pc", 138);
    freq.put("duz", 61);
    freq.put("pa", 8256);
    freq.put("pf", 47);
    freq.put("nau", 127);
    freq.put("xan", 69);
    freq.put("pe", 7941);
    freq.put("dup", 22);
    freq.put("pk", 35);
    freq.put("ph", 88);
    freq.put("pi", 1644);
    freq.put("pn", 21);
    freq.put("ir ", 3509);
    freq.put("pl", 841);
    freq.put("nri", 31);
    freq.put("nro", 35);
    freq.put("Fal", 132);
    freq.put("gay", 66);
    freq.put("ach", 1291);
    freq.put(" tw", 693);
    freq.put(" tv", 81);
    freq.put(" tu", 1683);
    freq.put(" tt", 67);
    freq.put("gas", 238);
    freq.put(" tr", 1796);
    freq.put("gen", 1296);
    freq.put("N", 3962);
    freq.put(" to", 4579);
    freq.put("gan", 1048);
    freq.put(" tm", 34);
    freq.put("gal", 608);
    freq.put("cee", 31);
    freq.put(" ti", 1604);
    freq.put(" th", 84);
    freq.put(" te", 7508);
    freq.put(" td", 158);
    freq.put(" tc", 108);
    freq.put(" tb", 486);
    freq.put(" ta", 4115);
    freq.put("tir", 1033);
    freq.put("fut", 183);
    freq.put("fuu", 21);
    freq.put("fur", 46);
    freq.put("fus", 27);
    freq.put("du ", 36);
    freq.put("Oli", 22);
    freq.put("oqe", 22);
    freq.put(" fá", 108);
    freq.put("fug", 26);
    freq.put(" fã", 123);
    freq.put("ói ", 66);
    freq.put("aru", 61);
    freq.put(" fé", 74);
    freq.put("lbe", 21);
    freq.put("aro", 563);
    freq.put("fum", 68);
    freq.put(" fí", 41);
    freq.put("eke", 24);
    freq.put("fui", 376);
    freq.put("nói", 32);
    freq.put("bos", 81);
    freq.put("riz", 125);
    freq.put("pq ", 644);
    freq.put("beç", 199);
    freq.put("voc", 2546);
    freq.put("riv", 94);
    freq.put("gel", 109);
    freq.put("raq", 32);
    freq.put("rir", 278);
    freq.put("ris", 676);
    freq.put("rip", 71);
    freq.put("riq", 35);
    freq.put("rin", 1001);
    freq.put("rio", 1524);
    freq.put("ril", 123);
    freq.put("rim", 652);
    freq.put("vor", 256);
    freq.put("rii", 46);
    freq.put("rif", 35);
    freq.put("rig", 666);
    freq.put("exi", 222);
    freq.put("rie", 194);
    freq.put("rib", 58);
    freq.put("ric", 353);
    freq.put("voz", 103);
    freq.put("ria", 2698);
    freq.put("pó", 125);
    freq.put("Um ", 183);
    freq.put("amo", 2994);
    freq.put("pô", 37);
    freq.put("ÃO ", 469);
    freq.put("pú", 41);
    freq.put("bs ", 43);
    freq.put("ceb", 385);
    freq.put("duç", 48);
    freq.put("gs ", 44);
    freq.put("clu", 147);
    freq.put("pá", 136);
    freq.put("pç", 82);
    freq.put("SN ", 48);
    freq.put("pé", 146);
    freq.put("õ ", 59);
    freq.put("ohn", 23);
    freq.put("pí", 31);
    freq.put("Cop", 21);
    freq.put("Cor", 203);
    freq.put("vo ", 1680);
    freq.put("tis", 184);
    freq.put("lie", 78);
    freq.put(" ¬¬", 299);
    freq.put("OW ", 39);
    freq.put(" tí", 38);
    freq.put("lig", 587);
    freq.put(" tê", 45);
    freq.put(" té", 117);
    freq.put("gaç", 68);
    freq.put("sao", 135);
    freq.put("mot", 167);
    freq.put(" tã", 476);
    freq.put("Col", 88);
    freq.put(" tá", 896);
    freq.put("Con", 327);
    freq.put("Olá", 33);
    freq.put("Soc", 31);
    freq.put(" fr", 773);
    freq.put(" fu", 993);
    freq.put("lib", 71);
    freq.put("ew ", 67);
    freq.put("Som", 43);
    freq.put("Sol", 47);
    freq.put("Son", 69);
    freq.put(" fa", 5452);
    freq.put("EI ", 177);
    freq.put("ueç", 67);
    freq.put("Sor", 58);
    freq.put(" fe", 1758);
    freq.put(" fd", 91);
    freq.put("y", 1876);
    freq.put("moo", 179);
    freq.put("Ê ", 124);
    freq.put(" fl", 251);
    freq.put(" fo", 3505);
    freq.put("aty", 30);
    freq.put("çõ", 316);
    freq.put(" vô", 25);
    freq.put("lde", 80);
    freq.put("ldi", 98);
    freq.put("mol", 82);
    freq.put("ldo", 68);
    freq.put("oa ", 1483);
    freq.put("O ", 5830);
    freq.put("hje", 21);
    freq.put("ijã", 27);
    freq.put("çã", 1999);
    freq.put("éé ", 49);
    freq.put("mob", 22);
    freq.put("Ver", 98);
    freq.put("lik", 27);
    freq.put("od ", 90);
    freq.put("Ai ", 138);
    freq.put("oo ", 946);
    freq.put("Á ", 197);
    freq.put("cut", 213);
    freq.put("cus", 97);
    freq.put("cur", 627);
    freq.put("cup", 147);
    freq.put("tõe", 29);
    freq.put("Dis", 32);
    freq.put("rga", 181);
    freq.put("cub", 27);
    freq.put("┈", 31);
    freq.put("cun", 27);
    freq.put("cum", 78);
    freq.put("cul", 563);
    freq.put("ee ", 508);
    freq.put("cui", 112);
    freq.put("rgo", 110);
    freq.put("Oo", 42);
    freq.put("On", 118);
    freq.put("Din", 23);
    freq.put("Ol", 200);
    freq.put("Ok", 47);
    freq.put("bá", 49);
    freq.put("Oi", 142);
    freq.put("Oh", 28);
    freq.put("voa", 44);
    freq.put("Of", 21);
    freq.put("ufa", 27);
    freq.put("Od", 36);
    freq.put("oha", 39);
    freq.put("bé", 666);
    freq.put("bê", 58);
    freq.put("Dic", 24);
    freq.put("qp ", 99);
    freq.put("Ain", 100);
    freq.put("Aii", 26);
    freq.put("hj ", 445);
    freq.put("Diz", 25);
    freq.put("Ow", 28);
    freq.put("Ou", 167);
    freq.put("gr", 2117);
    freq.put("Or", 104);
    freq.put("Dir", 27);
    freq.put("Op", 64);
    freq.put("aço", 501);
    freq.put("ná ", 23);
    freq.put("MO ", 204);
    freq.put("d", 85930);
    freq.put("OA ", 77);
    freq.put("eeu", 95);
    freq.put("eet", 173);
    freq.put("ppi", 54);
    freq.put("aça", 634);
    freq.put("eer", 91);
    freq.put("eem", 183);
    freq.put("eel", 46);
    freq.put("tuu", 21);
    freq.put("een", 167);
    freq.put("eei", 223);
    freq.put("eeh", 25);
    freq.put("idé", 32);
    freq.put("eee", 1865);
    freq.put("eed", 32);
    freq.put("eeg", 21);
    freq.put("idã", 55);
    freq.put("apo", 282);
    freq.put("aee", 77);
    freq.put("çu", 24);
    freq.put("gm ", 47);
    freq.put("b ", 412);
    freq.put("apl", 31);
    freq.put("mpe", 213);
    freq.put("aqi", 65);
    freq.put("ru ", 25);
    freq.put("LÁ ", 27);
    freq.put("ija", 90);
    freq.put("çe", 51);
    freq.put("ça", 2757);
    freq.put("cif", 36);
    freq.put("ço", 1250);
    freq.put("iji", 37);
    freq.put("lec", 59);
    freq.put("oe ", 83);
    freq.put("ijo", 478);
    freq.put("púb", 32);
    freq.put("apa", 725);
    freq.put("vin", 382);
    freq.put(" Qu", 1463);
    freq.put("pet", 121);
    freq.put("ush", 262);
    freq.put("peq", 83);
    freq.put("per", 2616);
    freq.put("pes", 1308);
    freq.put("pel", 1017);
    freq.put("Iss", 118);
    freq.put("pen", 1105);
    freq.put("peo", 22);
    freq.put("pei", 149);
    freq.put("ped", 400);
    freq.put("Os ", 135);
    freq.put("peg", 403);
    freq.put("pea", 37);
    freq.put("id ", 56);
    freq.put("pec", 183);
    freq.put("be", 4987);
    freq.put("ue ", 13188);
    freq.put("bg", 72);
    freq.put("run", 72);
    freq.put("ba", 3875);
    freq.put("bb", 74);
    freq.put("rum", 330);
    freq.put("bl", 857);
    freq.put("bm", 349);
    freq.put("Bor", 59);
    freq.put("bo", 3996);
    freq.put("Bot", 43);
    freq.put("bi", 1111);
    freq.put("bj", 324);
    freq.put("Ric", 56);
    freq.put("ruz", 83);
    freq.put("bu", 607);
    freq.put("oei", 41);
    freq.put("Bol", 40);
    freq.put("Bom", 407);
    freq.put("br", 3314);
    freq.put("bs", 179);
    freq.put("Boa", 329);
    freq.put("rup", 99);
    freq.put("ééé", 67);
    freq.put("by", 65);
    freq.put("rut", 57);
    freq.put("fec", 116);
    freq.put("uff", 23);
    freq.put("bor", 271);
    freq.put("xas", 30);
    freq.put("TI ", 22);
    freq.put("Rob", 37);
    freq.put("Roc", 35);
    freq.put("açã", 1230);
    freq.put(" Q ", 110);
    freq.put("ido", 1163);
    freq.put("va ", 2080);
    freq.put("bso", 33);
    freq.put("aa ", 860);
    freq.put("idi", 251);
    freq.put("DE ", 627);
    freq.put("açõ", 198);
    freq.put("ide", 530);
    freq.put("pe ", 288);
    freq.put("ida", 2612);
    freq.put("nsi", 404);
    freq.put("wn ", 133);
    freq.put("fem", 27);
    freq.put("nsm", 24);
    freq.put("sfa", 43);
    freq.put("nso", 258);
    freq.put(" ut", 24);
    freq.put(" uu", 31);
    freq.put(" C ", 65);
    freq.put("kat", 29);
    freq.put("nse", 778);
    freq.put(" ur", 37);
    freq.put("Ele", 183);
    freq.put(" ul", 135);
    freq.put(" um", 6647);
    freq.put(" un", 488);
    freq.put(" uh", 102);
    freq.put("kut", 117);
    freq.put("aeh", 29);
    freq.put("nsp", 48);
    freq.put(" uf", 21);
    freq.put("cho", 1318);
    freq.put("nst", 193);
    freq.put(" ua", 98);
    freq.put("Tá", 126);
    freq.put("ut ", 161);
    freq.put("ixi", 48);
    freq.put("xpo", 23);
    freq.put("ixo", 344);
    freq.put("xpl", 117);
    freq.put("ixa", 668);
    freq.put(" vó", 42);
    freq.put("xpe", 67);
    freq.put("ixe", 149);
    freq.put("urm", 145);
    freq.put("ada", 3430);
    freq.put("grá", 29);
    freq.put("ack", 90);
    freq.put("siç", 48);
    freq.put("auh", 389);
    freq.put("Tô ", 122);
    freq.put("u ", 23473);
    freq.put("xpu", 28);
    freq.put(" R ", 187);
    freq.put("aqu", 2458);
    freq.put(" Ch", 357);
    freq.put(" Ci", 105);
    freq.put(" Co", 1278);
    freq.put(" Cl", 153);
    freq.put("ns ", 1043);
    freq.put(" Ca", 918);
    freq.put("Flu", 28);
    freq.put(" Ce", 152);
    freq.put("sde", 99);
    freq.put("exe", 128);
    freq.put("Flo", 36);
    freq.put(" Cr", 207);
    freq.put("Ou ", 56);
    freq.put("uA", 21);
    freq.put("ué", 582);
    freq.put("zan", 60);
    freq.put(" Cu", 145);
    freq.put("cic", 51);
    freq.put("cia", 1190);
    freq.put("uta", 534);
    freq.put("cig", 23);
    freq.put("ux", 160);
    freq.put("cie", 114);
    freq.put("uz", 281);
    freq.put("uu", 1385);
    freq.put("ut", 2251);
    freq.put("ix ", 43);
    freq.put("uv", 696);
    freq.put("Aí", 34);
    freq.put("up", 797);
    freq.put("us", 3662);
    freq.put("ur", 2596);
    freq.put("um", 9157);
    freq.put("ul", 2993);
    freq.put("uo", 105);
    freq.put("un", 3639);
    freq.put("ui", 7336);
    freq.put("uh", 870);
    freq.put("uk", 48);
    freq.put("uj", 89);
    freq.put("ue", 19932);
    freq.put("ud", 3031);
    freq.put("ug", 516);
    freq.put("z", 7990);
    freq.put("ua", 5901);
    freq.put("uc", 1230);
    freq.put("ub", 604);
    freq.put("tib", 48);
    freq.put("PM ", 28);
    freq.put("Tw", 146);
    freq.put("Tu", 250);
    freq.put("Tr", 185);
    freq.put("oog", 79);
    freq.put("To", 628);
    freq.put(" ué", 22);
    freq.put("Th", 156);
    freq.put("Ti", 208);
    freq.put("ooa", 62);
    freq.put("Te", 680);
    freq.put("Tb", 21);
    freq.put("Tc", 39);
    freq.put("ayl", 25);
    freq.put("Ta", 383);
    freq.put("niã", 68);
    freq.put("A ", 5703);
    freq.put("ng ", 241);
    freq.put("gru", 58);
    freq.put(" gr", 843);
    freq.put("cim", 169);
    freq.put("nad", 1136);
    freq.put("stõ", 23);
    freq.put("ixã", 33);
    freq.put("nah", 22);
    freq.put("Bem", 68);
    freq.put("nan", 267);
    freq.put("nao", 1242);
    freq.put("nal", 791);
    freq.put("Nes", 32);
    freq.put("nar", 365);
    freq.put("nas", 796);
    freq.put("Mac", 44);
    freq.put("gre", 393);
    freq.put("nav", 39);
    freq.put("Mad", 33);
    freq.put("nat", 171);
    freq.put("gra", 1128);
    freq.put(" gn", 41);
    freq.put(" go", 1150);
    freq.put(" gl", 89);
    freq.put("º", 157);
    freq.put("Mal", 68);
    freq.put(" gi", 83);
    freq.put("oon", 50);
    freq.put("exp", 233);

    init3();
  }
  private static void init3() {
    
    freq.put("Med", 24);
    freq.put("bin", 113);
    freq.put("pau", 117);
    freq.put("sr ", 31);
    freq.put("suj", 40);
    freq.put("uz ", 88);
    freq.put("ly ", 72);
    freq.put("hê ", 29);
    freq.put("tmt", 24);
    freq.put("tua", 302);
    freq.put("coi", 1217);
    freq.put("asd", 37);
    freq.put("T ", 1258);
    freq.put("Aa", 41);
    freq.put("agn", 28);
    freq.put("Ac", 466);
    freq.put("Ab", 134);
    freq.put("Ae", 45);
    freq.put("Ad", 189);
    freq.put("Ag", 300);
    freq.put("Af", 100);
    freq.put("Ai", 282);
    freq.put("Ah", 203);
    freq.put("age", 692);
    freq.put("Aj", 23);
    freq.put("Am", 554);
    freq.put("Al", 401);
    freq.put("Ao", 59);
    freq.put("An", 344);
    freq.put("Aq", 109);
    freq.put("Ap", 163);
    freq.put("As", 276);
    freq.put("Ar", 181);
    freq.put("Au", 75);
    freq.put("At", 215);
    freq.put("gr ", 143);
    freq.put("Av", 91);
    freq.put("far", 140);
    freq.put("ciú", 28);
    freq.put("uç", 169);
    freq.put("ú", 939);
    freq.put("uá", 28);
    freq.put("agr", 357);
    freq.put("´´", 30);
    freq.put(" b", 9130);
    freq.put(" c", 26549);
    freq.put("gu", 5328);
    freq.put(" a", 37487);
    freq.put(" f", 16553);
    freq.put(" g", 5123);
    freq.put(" d", 38231);
    freq.put(" e", 35872);
    freq.put(" j", 3837);
    freq.put(" k", 3114);
    freq.put(" h", 6495);
    freq.put(" i", 6760);
    freq.put(" n", 25095);
    freq.put(" o", 17168);
    freq.put(" l", 7656);
    freq.put(" m", 30453);
    freq.put(" r", 6019);
    freq.put(" s", 26031);
    freq.put(" p", 30179);
    freq.put(" q", 19249);
    freq.put(" v", 20265);
    freq.put(" w", 235);
    freq.put(" t", 25187);
    freq.put(" u", 8760);
    freq.put(" z", 290);
    freq.put("gn", 243);
    freq.put(" x", 775);
    freq.put("Gil", 21);
    freq.put("ass", 2634);
    freq.put("ap ", 28);
    freq.put("gi", 1175);
    freq.put("gh", 65);
    freq.put(" B", 3697);
    freq.put(" C", 5005);
    freq.put(" A", 7392);
    freq.put(" F", 3047);
    freq.put(" G", 1864);
    freq.put(" D", 5536);
    freq.put(" E", 5835);
    freq.put(" J", 1507);
    freq.put(" K", 1088);
    freq.put(" H", 2311);
    freq.put(" I", 1540);
    freq.put(" N", 3926);
    freq.put(" O", 3839);
    freq.put(" L", 1916);
    freq.put(" M", 5404);
    freq.put(" R", 3127);
    freq.put(" S", 6342);
    freq.put(" P", 5853);
    freq.put(" Q", 2392);
    freq.put(" V", 3761);
    freq.put(" W", 326);
    freq.put(" T", 4594);
    freq.put(" U", 1420);
    freq.put(" Z", 147);
    freq.put(" X", 249);
    freq.put(" Y", 174);
    freq.put("né ", 823);
    freq.put("Nor", 70);
    freq.put("Nos", 215);
    freq.put("ch ", 36);
    freq.put("ed ", 174);
    freq.put("leç", 92);
    freq.put("âm", 43);
    freq.put("ân", 208);
    freq.put("Ter", 74);
    freq.put("rth", 21);
    freq.put("P", 5938);
    freq.put("ulg", 109);
    freq.put(" Wh", 24);
    freq.put("g ", 843);
    freq.put("asq", 25);
    freq.put("UA ", 149);
    freq.put("OI ", 52);
    freq.put("vlw", 30);
    freq.put("oas", 688);
    freq.put("tri", 432);
    freq.put("evi", 274);
    freq.put("vos", 199);
    freq.put("fe ", 69);
    freq.put("tro", 1370);
    freq.put("evo", 206);
    freq.put("tra", 2716);
    freq.put("eva", 372);
    freq.put("us ", 1592);
    freq.put("No ", 144);
    freq.put("eve", 886);
    freq.put("lk ", 39);
    freq.put("cas", 1486);
    freq.put("sé ", 41);
    freq.put("rdã", 30);
    freq.put("uls", 59);
    freq.put("ry ", 133);
    freq.put("bg ", 48);
    freq.put("tru", 105);
    freq.put("ulp", 210);
    freq.put("rro", 571);
    freq.put("zm", 28);
    freq.put(" à", 271);
    freq.put(" á", 192);
    freq.put("gó", 52);
    freq.put(" ç", 41);
    freq.put("rri", 474);
    freq.put("qe ", 258);
    freq.put("uee", 72);
    freq.put("ze", 2540);
    freq.put("rre", 903);
    freq.put(" é", 6921);
    freq.put("uea", 47);
    freq.put("za", 1120);
    freq.put("rra", 1085);
    freq.put(" í", 39);
    freq.put(" ó", 223);
    freq.put("Blo", 47);
    freq.put(" ñ", 163);
    freq.put("gã", 72);
    freq.put("flw", 48);
    freq.put(" ô", 75);
    freq.put(" õ", 65);
    freq.put(" ú", 202);
    freq.put("zu", 159);
    freq.put("rru", 309);
    freq.put("Bla", 32);
    freq.put("gê", 45);
    freq.put("gé", 43);
    freq.put("uer", 2443);
    freq.put(" Re", 644);
    freq.put(" À", 30);
    freq.put(" Á", 39);
    freq.put(" Ç", 21);
    freq.put("med", 288);
    freq.put(" É", 877);
    freq.put("ulh", 397);
    freq.put("SÓ ", 60);
    freq.put(" Ó", 52);
    freq.put("uli", 158);
    freq.put(" ód", 24);
    freq.put(" Ô", 28);
    freq.put(" Ú", 25);
    freq.put("Org", 36);
    freq.put("atu", 292);
    freq.put("xD ", 28);
    freq.put("can", 1066);
    freq.put("lea", 46);
    freq.put("leb", 42);
    freq.put("enh", 1511);
    freq.put("flo", 75);
    freq.put("lef", 50);
    freq.put("och", 49);
    freq.put(" ª", 74);
    freq.put("IU ", 58);
    freq.put("lek", 21);
    freq.put("z ", 2830);
    freq.put("ock", 93);
    freq.put(" ¬", 322);
    freq.put("rr ", 59);
    freq.put("asu", 141);
    freq.put("fla", 100);
    freq.put("ler", 533);
    freq.put("les", 676);
    freq.put("let", 349);
    freq.put("leu", 135);
    freq.put("lev", 388);
    freq.put("cab", 1184);
    freq.put(" º", 141);
    freq.put("ley", 47);
    freq.put("lez", 121);
    freq.put(" õ ", 48);
    freq.put("sá", 285);
    freq.put("eni", 492);
    freq.put("trê", 41);
    freq.put("nço", 97);
    freq.put("trá", 135);
    freq.put("té ", 842);
    freq.put("Ahh", 43);
    freq.put("rde", 1152);
    freq.put("ast", 433);
    freq.put("Ouv", 50);
    freq.put("gl", 300);
    freq.put("rda", 1111);
    freq.put("cta", 49);
    freq.put("céu", 42);
    freq.put("rdo", 335);
    freq.put("cto", 37);
    freq.put("rdi", 238);
    freq.put("sup", 237);
    freq.put("Uh", 36);
    freq.put(" Do", 273);
    freq.put("pf ", 24);
    freq.put("xer", 80);
    freq.put("ago", 1533);
    freq.put(" Di", 504);
    freq.put("apr", 377);
    freq.put("aps", 26);
    freq.put(" De", 1227);
    freq.put("sgr", 34);
    freq.put(" Da", 317);
    freq.put("iet", 71);
    freq.put("wit", 678);
    freq.put("ii ", 370);
    freq.put("sgo", 22);
    freq.put(" zo", 49);
    freq.put("sga", 23);
    freq.put("áve", 117);
    freq.put(" Du", 71);
    freq.put("Vem", 47);
    freq.put("Vej", 67);
    freq.put(" Dr", 55);
    freq.put("taq", 56);
    freq.put(" vá", 99);
    freq.put("cha", 1438);
    freq.put("Fr", 138);
    freq.put("fee", 24);
    freq.put("usc", 110);
    freq.put("Fu", 165);
    freq.put("usa", 548);
    freq.put(" vé", 39);
    freq.put("Hum", 35);
    freq.put("fel", 470);
    freq.put(" vê", 122);
    freq.put(" ví", 133);
    freq.put("usi", 316);
    freq.put("fei", 699);
    freq.put("rao", 30);
    freq.put("Fa", 502);
    freq.put("JE ", 59);
    freq.put("ust", 316);
    freq.put("fer", 579);
    freq.put("Fe", 337);
    freq.put("zia", 69);
    freq.put("zin", 435);
    freq.put("Fi", 356);
    freq.put("zil", 31);
    freq.put("Fl", 172);
    freq.put("spr", 25);
    freq.put("Fo", 299);
    freq.put("iiu", 21);
    freq.put("iit", 43);
    freq.put("Gua", 31);
    freq.put("iis", 44);
    freq.put("iir", 36);
    freq.put("eão", 55);
    freq.put("º ", 136);
    freq.put("Gui", 42);
    freq.put("aca", 1185);
    freq.put(" D ", 510);
    freq.put("ogu", 73);
    freq.put("iig", 25);
    freq.put("iia", 80);
    freq.put("xcl", 57);
    freq.put("iim", 80);
    freq.put("sg ", 49);
    freq.put("bo ", 253);
    freq.put("iin", 182);
    freq.put("iii", 1130);
    freq.put("Ô ", 50);
    freq.put("Me ", 200);
    freq.put(" Ru", 72);
    freq.put("ocr", 23);
    freq.put("ace", 480);
    freq.put(" Rs", 62);
    freq.put("f", 21872);
    freq.put("ahe", 49);
    freq.put("paa", 27);
    freq.put("wh", 29);
    freq.put("Ja", 235);
    freq.put("F ", 188);
    freq.put("nda", 2906);
    freq.put(" Ra", 175);
    freq.put("áxi", 29);
    freq.put(" Ro", 250);
    freq.put(" Ri", 249);
    freq.put(" c ", 151);
    freq.put("dii", 65);
    freq.put("tat", 210);
    freq.put("tau", 56);
    freq.put("tav", 893);
    freq.put("shs", 25);
    freq.put("tap", 51);
    freq.put(" Dê", 37);
    freq.put("tar", 2920);
    freq.put("tas", 857);
    freq.put("aco", 1003);
    freq.put("tac", 80);
    freq.put(" Dá", 30);
    freq.put("óti", 142);
    freq.put("tad", 1042);
    freq.put("taf", 40);
    freq.put("tag", 109);
    freq.put("taa", 138);
    freq.put("tab", 60);
    freq.put("spa", 174);
    freq.put("tal", 607);
    freq.put("Aaa", 26);
    freq.put("tan", 1378);
    freq.put("tao", 232);
    freq.put("tah", 82);
    freq.put("cni", 56);
    freq.put("rt ", 124);
    freq.put(" va", 3276);
    freq.put(" vc", 1856);
    freq.put("chã", 40);
    freq.put(" ve", 3790);
    freq.put(" vd", 40);
    freq.put("Yo", 53);
    freq.put("sit", 395);
    freq.put(" vi", 3432);
    freq.put("afe", 39);
    freq.put("chê", 28);
    freq.put("ré ", 79);
    freq.put(" vl", 40);
    freq.put(" vo", 7032);
    freq.put("spe", 1005);
    freq.put("sic", 719);
    freq.put("Fá", 22);
    freq.put(" vs", 74);
    freq.put("sig", 454);
    freq.put("sie", 23);
    freq.put("exa", 122);
    freq.put("meo", 24);
    freq.put("sii", 61);
    freq.put("sio", 136);
    freq.put("sin", 494);
    freq.put("sim", 1351);
    freq.put("ô", 865);
    freq.put("sis", 612);
    freq.put("rói", 32);
    freq.put("ará", 168);
    freq.put("act", 30);
    freq.put("and", 6709);
    freq.put("Q", 2408);
    freq.put("enq", 99);
    freq.put("oço", 132);
    freq.put("alq", 179);
    freq.put("ta ", 6988);
    freq.put("São", 165);
    freq.put("mi ", 305);
    freq.put("usã", 49);
    freq.put("née", 22);
    freq.put("nós", 146);
    freq.put("miz", 77);
    freq.put("siv", 136);
    freq.put("arã", 54);
    freq.put(" v ", 23);
    freq.put("dd ", 76);
    freq.put("siu", 32);
    freq.put("míl", 84);
    freq.put("vcs", 271);
    freq.put("Y ", 153);
    freq.put("af ", 67);
    freq.put("ueh", 60);
    freq.put("Ond", 39);
    freq.put("enr", 69);
    freq.put("bun", 74);
    freq.put("si ", 96);
    freq.put("ato", 694);
    freq.put("ovo", 840);
    freq.put("asc", 254);
    freq.put("aff", 134);
    freq.put("Ont", 44);
    freq.put("úl", 97);
    freq.put("úm", 87);
    freq.put("ún", 129);
    freq.put("da ", 11692);
    freq.put("úd", 77);
    freq.put("ouç", 48);
    freq.put("ens", 1419);
    freq.put("úb", 48);
    freq.put("úc", 30);
    freq.put("uet", 80);
    freq.put("lgu", 968);
    freq.put("own", 69);
    freq.put("é ", 9013);
    freq.put("lz ", 44);
    freq.put("úv", 44);
    freq.put("ús", 318);
    freq.put("lf", 49);
    freq.put("lg", 1367);
    freq.put("ld", 438);
    freq.put("le", 7191);
    freq.put("lb", 61);
    freq.put("lc", 141);
    freq.put("la", 9402);
    freq.put("eue", 22);
    freq.put("lo", 4734);
    freq.put("ll", 654);
    freq.put("lm", 1189);
    freq.put("eua", 40);
    freq.put("lk", 115);
    freq.put("lh", 4078);
    freq.put("li", 5911);
    freq.put("lv", 490);
    freq.put("lw", 104);
    freq.put("lt", 2345);
    freq.put("lu", 1282);
    freq.put("lr", 138);
    freq.put("ls", 340);
    freq.put("lp", 257);
    freq.put("lq", 203);
    freq.put("euu", 36);
    freq.put(" h ", 282);
    freq.put("lz", 106);
    freq.put("reç", 146);
    freq.put("eus", 1275);
    freq.put("ly", 123);
    freq.put("dad", 2100);
    freq.put("dae", 24);
    freq.put(" za", 32);
    freq.put("daa", 133);
    freq.put("RA ", 702);
    freq.put("Cas", 83);
    freq.put("enu", 28);
    freq.put("ecí", 22);
    freq.put("Cap", 45);
    freq.put("dah", 25);
    freq.put("dai", 92);
    freq.put("Cat", 27);
    freq.put("dat", 56);
    freq.put("Cai", 53);
    freq.put("Can", 83);
    freq.put("Cam", 103);
    freq.put("Cal", 66);
    freq.put("arç", 38);
    freq.put("Cab", 23);
    freq.put("quê", 60);
    freq.put("quí", 21);
    freq.put("day", 24);
    freq.put("Cad", 107);
    freq.put("Pre", 253);
    freq.put("nfe", 180);
    freq.put("Pra", 167);
    freq.put("San", 167);
    freq.put("ç", 6556);
    freq.put("Sal", 57);
    freq.put(" hs", 77);
    freq.put(" hr", 78);
    freq.put("Pro", 241);
    freq.put("nfl", 31);
    freq.put("Pri", 76);
    freq.put("eu ", 11843);
    freq.put(" hu", 266);
    freq.put(" ht", 50);
    freq.put(" hj", 482);
    freq.put(" hi", 322);
    freq.put(" ho", 2471);
    freq.put("nfr", 45);
    freq.put(" hm", 90);
    freq.put("Sar", 22);
    freq.put(" ha", 1552);
    freq.put("sil", 506);
    freq.put(" he", 642);
    freq.put("bis", 35);
    freq.put("oun", 45);
    freq.put("ouc", 720);
    freq.put("emi", 307);
    freq.put("met", 251);
    freq.put("Às ", 22);
    freq.put("seq", 37);
    freq.put("naç", 39);
    freq.put("oux", 32);
    freq.put("aré", 23);
    freq.put("ous", 94);
    freq.put("our", 145);
    freq.put("ouq", 56);
    freq.put("oup", 119);
    freq.put("oww", 21);
    freq.put("pra", 4934);
    freq.put("rez", 78);
    freq.put("lç", 66);
    freq.put("lã", 95);
    freq.put("zar", 143);
    freq.put("lá", 914);
    freq.put("rer", 382);
    freq.put("res", 2913);
    freq.put("rep", 354);
    freq.put("lí", 189);
    freq.put("lê", 139);
    freq.put("CS ", 27);
    freq.put("ret", 514);
    freq.put("lé", 263);
    freq.put("rej", 98);
    freq.put("ñ ", 161);
    freq.put("lô", 33);
    freq.put("cra", 67);
    freq.put("ren", 1075);
    freq.put("ló", 96);
    freq.put("rel", 314);
    freq.put("rem", 700);
    freq.put("reb", 82);
    freq.put("rec", 1803);
    freq.put("rea", 461);
    freq.put("ref", 262);
    freq.put("reg", 505);
    freq.put("red", 543);
    freq.put("ree", 168);
    freq.put("dm ", 31);
    freq.put("ece", 1595);
    freq.put("daç", 64);
    freq.put("ão ", 12009);
    freq.put("eca", 219);
    freq.put("CE ", 79);
    freq.put("eco", 253);
    freq.put("ecn", 22);
    freq.put("boi", 36);
    freq.put("ecl", 157);
    freq.put("eci", 1212);
    freq.put("ech", 163);
    freq.put("qua", 2057);
    freq.put("ecu", 75);
    freq.put("ect", 84);
    freq.put("que", 17138);
    freq.put("ecr", 55);
    freq.put("onn", 24);
    freq.put("x", 4635);
    freq.put("qui", 2730);
    freq.put("oni", 368);
    freq.put("ltr", 29);
    freq.put("Vc ", 86);
    freq.put("lod", 46);
    freq.put("g", 26184);
    freq.put("Ao ", 35);
    freq.put("anh", 2473);
    freq.put("uha", 373);
    freq.put("ask", 86);
    freq.put("hr ", 23);
    freq.put("loj", 40);
    freq.put("lta", 1211);
    freq.put("bah", 22);
    freq.put("lte", 259);
    freq.put("naq", 54);
    freq.put("Tu ", 36);
    freq.put("róx", 100);
    freq.put(" há", 114);
    freq.put("fot", 425);
    freq.put("lto", 429);
    freq.put("já ", 1050);
    freq.put("mad", 348);
    freq.put("Fot", 24);
    freq.put("táv", 36);
    freq.put("K ", 468);
    freq.put("tár", 108);
    freq.put("arq", 79);
    freq.put("ãã", 52);
    freq.put("ihs", 21);
    freq.put("rs ", 485);
    freq.put("xão", 48);
    freq.put("acr", 254);
    freq.put("loo", 73);
    freq.put("onl", 30);
    freq.put("ihi", 111);
    freq.put("TO ", 443);
    freq.put("fet", 44);
    freq.put("ses", 459);
    freq.put("às ", 117);
    freq.put("iha", 44);
    freq.put("og ", 159);
    freq.put("exu", 21);
    freq.put("has", 663);
    freq.put("ao ", 2633);
    freq.put("rtã", 33);
    freq.put("bje", 26);
    freq.put("sha", 268);
    freq.put("oça", 153);
    freq.put(" Sp", 43);
    freq.put("vou", 2482);
    freq.put("ahh", 215);
    freq.put("gão", 71);
    freq.put(" Su", 225);
    freq.put(" Sk", 25);
    freq.put(" Sh", 106);
    freq.put(" Si", 425);
    freq.put(" So", 498);
    freq.put(" Sc", 25);
    freq.put(" Sa", 681);
    freq.put("ali", 756);
    freq.put("nut", 139);
    freq.put("uas", 715);
    freq.put(" Se", 1513);
    freq.put("aai", 195);
    freq.put("Ka", 78);
    freq.put("rso", 258);
    freq.put("rsi", 60);
    freq.put("Kk", 137);
    freq.put("rse", 40);
    freq.put("Ki", 44);
    freq.put("eha", 40);
    freq.put("rsa", 263);
    freq.put("Kl", 24);
    freq.put("ogl", 63);
    freq.put("ogo", 826);
    freq.put("R", 3179);
    freq.put("ogi", 103);
    freq.put("too", 169);
    freq.put("rce", 330);
    freq.put("oge", 25);
    freq.put("ih ", 31);
    freq.put("sex", 320);
    freq.put("oga", 561);
    freq.put("udo", 1227);
    freq.put("zz", 223);
    freq.put("rss", 61);
    freq.put("vie", 58);
    freq.put(" Bu", 65);
    freq.put("bei", 682);
    freq.put("ben", 283);
    freq.put("bel", 398);
    freq.put("bem", 1207);
    freq.put("beb", 209);
    freq.put("Av ", 24);
    freq.put("sok", 22);
    freq.put("onc", 310);
    freq.put("arb", 56);
    freq.put("bed", 24);
    freq.put("rca", 301);
    freq.put("oth", 58);
    freq.put("AL ", 125);
    freq.put("sed", 63);
    freq.put("mês", 60);
    freq.put("ber", 782);
    freq.put("Uma", 128);
    freq.put(" S ", 140);
    freq.put("aar", 94);
    freq.put("bet", 21);
    freq.put("beu", 36);
    freq.put("Pap", 21);
    freq.put("Par", 467);
    freq.put("Pas", 81);
    freq.put("dá ", 310);
    freq.put("Pau", 171);
    freq.put("nqu", 275);
    freq.put("ãa", 51);
    freq.put("arg", 154);
    freq.put(" E ", 1108);
    freq.put("ãe", 494);
    freq.put("lin", 1527);
    freq.put("Ped", 47);
    freq.put("aer", 40);
    freq.put("Pad", 22);
    freq.put("ac ", 42);
    freq.put("Pag", 22);
    freq.put("ãs", 66);
    freq.put("Pai", 69);
    freq.put("Pal", 136);
    freq.put("loc", 398);
    freq.put("Pan", 24);
    freq.put("IZ ", 40);
    freq.put("sk", 244);
    freq.put("nue", 30);
    freq.put("mim", 868);
    freq.put("ck ", 197);
    freq.put("Oii", 29);
    freq.put("min", 3355);
    freq.put("mia", 152);
    freq.put(" Só", 318);
    freq.put("mic", 129);
    freq.put("mús", 266);
    freq.put("mid", 153);
    freq.put("mig", 1163);
    freq.put("sej", 307);
    freq.put("als", 105);
    freq.put("Dep", 101);
    freq.put(" Sé", 56);
    freq.put("Mor", 98);
    freq.put("bus", 188);
    freq.put(" Sã", 164);
    freq.put("mis", 337);
    freq.put(" Sá", 33);
    freq.put("miu", 54);
    freq.put("mit", 162);
    freq.put("Dia", 212);
    freq.put(" El", 345);
    freq.put(" Em", 186);
    freq.put(" En", 365);
    freq.put("J", 1522);
    freq.put(" Ei", 91);
    freq.put("onf", 401);
    freq.put(" Ed", 78);
    freq.put("ã ", 959);
    freq.put("fos", 205);
    freq.put("ead", 233);
    freq.put("sfo", 49);
    freq.put("dáv", 24);
    freq.put("ute", 184);
    freq.put(" Ex", 115);
    freq.put("Dev", 47);
    freq.put("sfi", 40);
    freq.put(" Eu", 1188);
    freq.put(" Ev", 34);
    freq.put("ny ", 45);
    freq.put(" Er", 45);
    freq.put(" Es", 920);
    freq.put("cke", 37);
    freq.put("ure", 92);
    freq.put("urf", 26);
    freq.put("urg", 67);
    freq.put("ong", 189);
    freq.put("mus", 274);
    freq.put("Pox", 28);
    freq.put("caç", 146);
    freq.put("Pot", 48);
    freq.put("tór", 228);
    freq.put("Por", 352);
    freq.put("Pos", 47);
    freq.put("ç ", 41);
    freq.put("Oi ", 87);
    freq.put("Pon", 31);
    freq.put("rân", 36);
    freq.put("Pol", 30);
    freq.put("urp", 63);
    freq.put("cks", 21);
    freq.put("Poi", 52);
    freq.put("Del", 25);
    freq.put("Pod", 118);
    freq.put("Só ", 315);
    freq.put("Dem", 53);
    freq.put("son", 728);
    freq.put("lém", 76);
    freq.put("ngl", 114);
    freq.put("sér", 191);
    freq.put("Cha", 72);
    freq.put(" iP", 44);
    freq.put("íss", 25);
    freq.put("bum", 33);
    freq.put("rív", 80);
    freq.put("ebê", 27);
    freq.put("░", 33);
    freq.put("agu", 328);
    freq.put("buc", 22);
    freq.put(" às", 115);
    freq.put("tb ", 140);
    freq.put("wor", 25);
    freq.put("Che", 125);
    freq.put("eda", 175);
    freq.put("nge", 230);
    freq.put("Dec", 26);
    freq.put("urn", 29);
    freq.put("nga", 205);
    freq.put("co ", 2219);
    freq.put(" ip", 26);
    freq.put("eau", 28);
    freq.put(" ir", 1323);
    freq.put(" is", 1189);
    freq.put(" it", 39);
    freq.put(" iu", 23);
    freq.put("jap", 38);
    freq.put("Mot", 28);
    freq.put(" ih", 26);
    freq.put("q ", 2897);
    freq.put("aná", 31);
    freq.put("jam", 136);
    freq.put("ksa", 60);
    freq.put(" im", 691);
    freq.put(" in", 2339);
    freq.put("dp ", 38);
    freq.put(" ia", 262);
    freq.put("jad", 22);
    freq.put(" id", 285);
    freq.put(" ig", 246);
    freq.put("anç", 620);
    freq.put("moç", 324);
    freq.put("tui", 78);
    freq.put("alá", 34);
    freq.put("Ó", 52);
    freq.put("tbm", 312);
    freq.put("¬¬¬", 105);
    freq.put("lsi", 25);
    freq.put("qq", 99);
    freq.put("qp", 144);
    freq.put("tmb", 26);
    freq.put("qr", 54);
    freq.put("qu", 22057);
    freq.put("shu", 166);
    freq.put("VA ", 74);
    freq.put(" wa", 26);
    freq.put("h", 36733);
    freq.put("xpr", 32);
    freq.put(" wh", 24);
    freq.put(" wi", 34);
    freq.put("éu ", 50);
    freq.put(" ww", 55);
    freq.put("etá", 30);
    freq.put("qe", 340);
    freq.put("ks ", 78);
    freq.put("dmi", 51);
    freq.put(" i ", 53);
    freq.put("shi", 72);
    freq.put("tlé", 33);
    freq.put("qm", 41);
    freq.put("ql", 33);
    freq.put("ja ", 1349);
    freq.put("qn", 87);
    freq.put("Pr", 783);
    freq.put("ebe", 409);
    freq.put("Pq", 81);
    freq.put("eba", 122);
    freq.put("Pu", 58);
    freq.put("uim", 200);
    freq.put("ebo", 298);
    freq.put("we", 273);
    freq.put("ke ", 115);
    freq.put("jo ", 523);
    freq.put("Pa", 1108);
    freq.put("ebr", 159);
    freq.put("Pe", 569);
    freq.put("ede", 263);
    freq.put("Ph", 68);
    freq.put("Pi", 167);
    freq.put("Po", 817);
    freq.put("Pl", 63);
    freq.put("lve", 236);
    freq.put("lus", 113);
    freq.put("lut", 130);
    freq.put("ome", 2428);
    freq.put("olo", 625);
    freq.put("ngã", 21);
    freq.put("luz", 59);
    freq.put("kk ", 1408);
    freq.put("épo", 32);
    freq.put("lua", 51);
    freq.put("et ", 399);
    freq.put("luc", 69);
    freq.put("lud", 31);
    freq.put("lue", 25);
    freq.put("lug", 189);
    freq.put("tá ", 1480);
    freq.put("õ", 606);
    freq.put("SU ", 23);
    freq.put("lul", 185);
    freq.put("omi", 809);
    freq.put("lun", 72);
    freq.put("ken", 22);
    freq.put("jor", 63);
    freq.put("jos", 295);
    freq.put("eb ", 26);
    freq.put("kei", 24);
    freq.put("omo", 1700);
    freq.put("ked", 66);
    freq.put("éia", 52);
    freq.put("joa", 30);
    freq.put("S", 6422);
    freq.put("eun", 58);
    freq.put("joe", 29);
    freq.put("vre", 51);
    freq.put("jog", 865);
    freq.put("eui", 21);
    freq.put("dá", 369);
    freq.put("kes", 35);
    freq.put("ker", 57);
    freq.put("joo", 63);
    freq.put("etr", 165);
    freq.put("ets", 59);
    freq.put("bee", 136);
    freq.put("ápi", 72);
    freq.put("etw", 23);
    freq.put("ett", 42);
    freq.put("etu", 31);
    freq.put("nçã", 168);
    freq.put("aho", 30);
    freq.put("lu ", 31);
    freq.put("jin", 62);
    freq.put("eta", 665);
    freq.put("tle", 52);
    freq.put("ete", 579);
    freq.put("ami", 1194);
    freq.put("ws", 67);
    freq.put("eti", 269);
    freq.put("TÉ ", 27);
    freq.put("eto", 412);
    freq.put(" il", 95);
    freq.put("ck", 309);
    freq.put("vá", 118);
    freq.put("ci", 4879);
    freq.put("ch", 4806);
    freq.put("co", 19666);
    freq.put("Exp", 38);
    freq.put("cm", 147);
    freq.put("cl", 772);
    freq.put("cc", 71);
    freq.put("vé", 78);
    freq.put("ca", 13440);
    freq.put("Lon", 25);
    freq.put("ví", 139);
    freq.put("ce", 5161);
    freq.put("cd", 44);
    freq.put(" Fá", 22);
    freq.put("uce", 85);
    freq.put("Est", 388);
    freq.put("vô", 32);
    freq.put("lis", 267);
    freq.put("uca", 347);
    freq.put("cs", 324);
    freq.put("cr", 1397);
    freq.put("Hen", 27);
    freq.put("Heh", 38);
    freq.put("cu", 2043);
    freq.put("ct", 178);
    freq.put("Ger", 29);
    freq.put("rve", 140);
    freq.put("uua", 21);
    freq.put("Esp", 177);
    freq.put("Jun", 34);
    freq.put("méd", 94);
    freq.put("Jul", 36);
    freq.put("zag", 28);
    freq.put("Jur", 25);
    freq.put(" éé", 36);
    freq.put("Joã", 41);
    freq.put("pia", 127);
    freq.put("ânc", 87);
    freq.put("mér", 42);
    freq.put("Gen", 113);
    freq.put("aem", 28);
    freq.put("aua", 121);
    freq.put("OL ", 53);
    freq.put("oti", 254);
    freq.put("egó", 49);
    freq.put("Nã", 814);
    freq.put("bit", 46);
    freq.put("lgo", 221);
    freq.put("oto", 684);
    freq.put("Hoj", 330);
    freq.put("AM ", 119);
    freq.put("c ", 2236);
    freq.put(" Pq", 81);
    freq.put("pie", 29);
    freq.put("vó ", 49);
    freq.put("hmm", 41);
    freq.put("cor", 1641);
    freq.put("pis", 129);
    freq.put("uio", 33);
    freq.put("cou", 256);
    freq.put("uin", 751);
    freq.put("ª ", 74);
    freq.put("cot", 60);
    freq.put("And", 81);
    freq.put("mín", 32);
    freq.put("Ang", 39);
    freq.put("Ana", 37);
    freq.put("leo", 35);
    freq.put("é", 12154);
    freq.put(" Tô", 122);
    freq.put("Ani", 40);
    freq.put("bb ", 29);
    freq.put("Ant", 58);
    freq.put("rpo", 79);
    freq.put("uir", 409);
    freq.put("UM ", 177);
    freq.put("rbi", 32);
    freq.put("cox", 22);
    freq.put("Esc", 72);
    freq.put("eur", 40);
    freq.put("ati", 618);
    freq.put(" Tá", 126);
    freq.put("uit", 1944);
    freq.put("bir", 68);
    freq.put("cê", 2481);
    freq.put("cé", 89);
    freq.put(" Fr", 138);
    freq.put(" Fu", 164);
    freq.put("ve", 8316);
    freq.put("cí", 71);
    freq.put("cã", 74);
    freq.put("câ", 29);
    freq.put("cá", 63);
    freq.put("uiv", 29);
    freq.put("vl", 43);
    freq.put("avr", 194);
    freq.put("vo", 9013);
    freq.put(" Fa", 498);
    freq.put("cú", 24);
    freq.put("vr", 413);
    freq.put("vs", 84);
    freq.put(" Fe", 334);
    freq.put("vu", 97);
    freq.put("có", 54);
    freq.put("ave", 348);
    freq.put("You", 35);
    freq.put(" Fl", 165);
    freq.put(" Fo", 295);
    freq.put("io ", 3137);
    freq.put("of ", 81);
    freq.put("az", 2690);
    freq.put("yma", 38);
    freq.put("noj", 30);
    freq.put("edr", 91);
    freq.put("AE ", 36);
    freq.put(" ép", 35);
    freq.put("cad", 994);
    freq.put("dal", 53);
    freq.put("cob", 194);
    freq.put("Car", 265);
    freq.put("vár", 40);
    freq.put("ãao", 31);
    freq.put("MT ", 22);
    freq.put("AA ", 126);
    freq.put("uqu", 76);
    freq.put("dan", 581);
    freq.put(" T ", 77);
    freq.put("v ", 202);
    freq.put("SO ", 211);
    freq.put("dao", 45);
    freq.put("pho", 35);
    freq.put("Bro", 30);
    freq.put("ay ", 167);
    freq.put("ú ", 60);
    freq.put("iou", 69);
    freq.put("iot", 109);
    freq.put("ios", 541);
    freq.put("ior", 531);
    freq.put("azã", 32);
    freq.put("ioo", 33);
    freq.put(" F ", 45);
    freq.put("app", 31);
    freq.put("iol", 105);
    freq.put("ioj", 30);
    freq.put("tân", 50);
    freq.put("ioe", 24);
    freq.put("dak", 46);
    freq.put("von", 267);
    freq.put("ioa", 30);
    freq.put("GA ", 82);
    freq.put("lzi", 37);
    freq.put("ont", 2696);
    freq.put("cré", 27);
    freq.put("off", 28);
    freq.put("ofe", 220);
    freq.put(" Tw", 144);
    freq.put("Aí ", 31);
    freq.put(" Tu", 233);
    freq.put("ofi", 147);
    freq.put(" Tr", 180);
    freq.put(" To", 626);
    freq.put(" Ti", 208);
    freq.put(" Th", 151);
    freq.put(" é ", 6752);
    freq.put(" Te", 677);
    freq.put("crí", 61);
    freq.put(" Tc", 39);
    freq.put(" Tb", 21);
    freq.put(" Ta", 375);
    freq.put("daq", 335);
    freq.put("oal", 169);
    freq.put("dar", 1232);
    freq.put("─", 25);
    freq.put("xem", 58);
    freq.put("das", 1250);
    freq.put("xei", 57);
    freq.put(" xD", 98);
    freq.put("Ei ", 33);
    freq.put("udh", 27);
    freq.put("oai", 25);
    freq.put("tch", 156);
    freq.put("nou", 92);
    freq.put("AR ", 386);
    freq.put("lex", 52);
    freq.put("tca", 42);
    freq.put("Faz", 91);
    freq.put("Be", 417);
    freq.put(" xi", 70);
    freq.put("now", 21);
    freq.put("adr", 205);
    freq.put("Ba", 437);
    freq.put("wee", 158);
    freq.put("Bl", 101);
    freq.put(" xa", 49);
    freq.put("Bo", 1040);
    freq.put("sky", 26);
    freq.put("Bi", 139);
    freq.put("Bj", 75);
    freq.put("ady", 37);
    freq.put("ske", 45);
    freq.put("Bu", 71);
    freq.put("ger", 160);
    freq.put("ade", 2764);
    freq.put("ska", 62);
    freq.put("nor", 234);
    freq.put("Br", 554);
    freq.put("Fam", 26);
    freq.put("Fab", 24);
    freq.put("Fac", 89);
    freq.put("sko", 27);
    freq.put("orá", 56);
    freq.put("ços", 106);
    freq.put("adi", 514);
    freq.put("amb", 759);
    freq.put("zão", 63);
    freq.put("DÁ ", 22);
    freq.put("Eit", 35);
    freq.put("Sai", 134);
    freq.put("nve", 430);
    freq.put("T", 4654);
    freq.put("nva", 28);
    freq.put("nvo", 58);
    freq.put("lqu", 176);
    freq.put("Vi ", 21);
    freq.put("tc ", 37);
    freq.put("ndê", 32);
    freq.put("B ", 198);
    freq.put("l ", 5336);
    freq.put("bie", 40);
    freq.put("éss", 28);
    freq.put("ndã", 23);
    freq.put(" x ", 318);
    freq.put("ço ", 892);
    freq.put("áti", 138);
    freq.put("nfo", 187);
    freq.put("voo", 128);
    freq.put("sk ", 23);
    freq.put("ad ", 188);
    freq.put("Sab", 122);
    freq.put(" já", 1054);
    freq.put("axa", 88);
    freq.put("nja", 67);
    freq.put("VO ", 98);
    freq.put("Sub", 25);
    freq.put("nhi", 36);
    freq.put("ui ", 2291);
    freq.put("Sul", 27);
    freq.put("njo", 62);
    freq.put("rgi", 106);
    freq.put("ênc", 295);
    freq.put("rqu", 727);
    freq.put("nfi", 369);
    freq.put("nju", 22);
    freq.put("Sup", 54);
    freq.put("amp", 346);
    freq.put(" sz", 37);
    freq.put("Lui", 23);
    freq.put("amg", 50);
    freq.put("U ", 1224);
    freq.put("tum", 165);
    freq.put("utr", 636);
    freq.put("esu", 177);
    freq.put("est", 4521);
    freq.put("ess", 5110);
    freq.put("ubr", 53);
    freq.put("esq", 529);
    freq.put("esp", 1527);
    freq.put("alm", 778);
    freq.put("nd ", 181);
    freq.put("Ó ", 81);
    freq.put("nfu", 48);
    freq.put("esg", 61);
    freq.put("esf", 97);
    freq.put("ese", 627);
    freq.put("esd", 98);
    freq.put("esc", 1609);
    freq.put("esb", 25);
    freq.put("esa", 431);
    freq.put("eso", 228);
    freq.put("esn", 21);
    freq.put("esm", 1282);
    freq.put("esl", 62);
    freq.put("adê", 88);
    freq.put("Faç", 27);
    freq.put("esi", 276);
    freq.put("óis", 34);
    freq.put("êba", 27);
    freq.put("dui", 21);
    freq.put("RO ", 278);
    freq.put("lle", 84);
    freq.put("lça", 46);
    freq.put("kd ", 31);
    freq.put("Ven", 56);
    freq.put("Us", 24);
    freq.put("Ur", 29);
    freq.put("Um", 317);
    freq.put("Ul", 22);
    freq.put("Un", 96);
    freq.put("Ô", 29);
    freq.put("Mús", 26);
    freq.put("dul", 24);
    freq.put("LL ", 32);
    freq.put("ndi", 758);
    freq.put("tos", 1323);
    freq.put("ZA ", 36);
    freq.put("mii", 58);
    freq.put("ndo", 10035);
    freq.put("ube", 159);
    freq.put(" ju", 474);
    freq.put("nde", 1843);
    freq.put("aal", 37);
    freq.put("ndy", 26);
    freq.put(" jo", 1034);
    freq.put("Sau", 73);
    freq.put("es ", 4468);
    freq.put(" je", 232);
    freq.put("nds", 46);
    freq.put("ndr", 143);
    freq.put(" ja", 962);
    freq.put("EE ", 63);
    freq.put("duc", 78);
    freq.put("pox", 63);
    freq.put("owe", 44);
    freq.put("ea ", 73);
    freq.put("Twi", 120);
    freq.put("à ", 153);
    freq.put("xau", 23);
    freq.put("dvd", 21);
    freq.put("my ", 163);
    freq.put("De ", 129);
    freq.put("h ", 2215);
    freq.put("alã", 26);
    freq.put("iná", 34);
    freq.put("ows", 46);
    freq.put("içõ", 48);
    freq.put("Ami", 75);
    freq.put("lét", 43);
    freq.put("AN ", 29);
    freq.put("vai", 2131);
    freq.put("van", 227);
    freq.put("vao", 45);
    freq.put("Amo", 162);
    freq.put("vam", 599);
    freq.put("Ama", 208);
    freq.put("rcu", 34);
    freq.put("ucu", 32);
    freq.put("vaa", 62);
    freq.put("Ame", 38);
    freq.put("vag", 80);
    freq.put("vad", 166);
    freq.put("ubi", 59);
    freq.put("Amy", 21);
    freq.put("uiç", 179);
    freq.put("rco", 142);
    freq.put("rci", 166);
    freq.put("oub", 124);
    freq.put("var", 366);
    freq.put("cês", 238);
    freq.put("vav", 30);
    freq.put("Aff", 52);
    freq.put("vat", 73);
    freq.put("lob", 83);
    freq.put("eai", 65);
    freq.put("eah", 43);
    freq.put("ma ", 5128);
    freq.put("hy", 23);
    freq.put("eam", 50);
    freq.put("eal", 312);
    freq.put("ean", 90);
    freq.put("hr", 152);
    freq.put("hs", 572);
    freq.put("Des", 169);
    freq.put("eae", 37);
    freq.put("Deu", 494);
    freq.put("ht", 105);
    freq.put("hu", 1616);
    freq.put("hj", 487);
    freq.put("Dei", 65);
    freq.put("hh", 581);
    freq.put("hi", 1100);
    freq.put("hn", 39);
    freq.put("ho", 9779);
    freq.put("bul", 64);
    freq.put("hm", 110);
    freq.put("ía", 52);
    freq.put("eas", 46);
    freq.put("ha", 14074);
    freq.put("hf", 25);
    freq.put("eat", 103);
    freq.put("hd", 65);
    freq.put("he", 4326);
    freq.put("aju", 251);
    freq.put("lso", 97);
    freq.put("Tem", 251);
    freq.put("Ten", 164);
    freq.put("aah", 277);
    freq.put("avi", 375);
    freq.put("dut", 62);
    freq.put("cê ", 2174);
    freq.put("j", 9359);
    freq.put("po", 9734);
    freq.put("ow ", 503);
    freq.put("dms", 22);
    freq.put("lva", 142);
    freq.put("duv", 42);
    freq.put("lvo", 34);
    freq.put("lvi", 67);
    freq.put("Os", 163);
    freq.put("ín", 112);
    freq.put("pil", 49);
    freq.put("OO ", 108);
    freq.put("pin", 281);
    freq.put("pio", 303);
    freq.put("int", 1145);
    freq.put("inu", 340);
    freq.put("inv", 214);
    freq.put("pic", 92);
    freq.put("Don", 25);
    freq.put("inq", 25);
    freq.put("rud", 26);
    freq.put("ins", 267);
    freq.put("tão", 1359);
    freq.put("inn", 26);
    freq.put("ino", 504);
    freq.put("inh", 5574);
    freq.put("ini", 399);
    freq.put("inj", 29);
    freq.put("ink", 138);
    freq.put("ind", 4154);
    freq.put("ine", 474);
    freq.put("inf", 279);
    freq.put("ing", 1162);
    freq.put("pit", 110);
    freq.put("ina", 1803);
    freq.put("inc", 469);
    freq.put("Amé", 37);
    freq.put("hn ", 24);
    freq.put("eo ", 301);
    freq.put("í ", 457);
    freq.put("ít", 111);
    freq.put("urt", 268);
    freq.put("oan", 49);
    freq.put("ª", 78);
    freq.put("oak", 33);
    freq.put("vaç", 48);
    freq.put(" Ur", 29);
    freq.put(" Us", 22);
    freq.put(" Ul", 21);
    freq.put(" Um", 313);
    freq.put(" Un", 90);
    freq.put("oat", 31);
    freq.put(" Uh", 23);
    freq.put("oar", 81);
    freq.put(" mú", 270);
    freq.put("gav", 21);
    freq.put("tma", 23);
    freq.put("out", 684);
    freq.put("íp", 29);
    freq.put("tam", 1102);
    freq.put("Aca", 138);
    freq.put("gat", 231);
    freq.put("DA ", 616);
    freq.put("Ace", 46);
    freq.put("pi ", 24);
    freq.put("Ach", 173);
    freq.put("Aco", 69);
    freq.put("nfa", 29);
    freq.put("eaç", 37);
    freq.put("hõ", 33);
    freq.put("hê", 37);
    freq.put("Acr", 23);
    freq.put("Jos", 28);
    freq.put("U", 1466);
    freq.put("uba", 114);
    freq.put("uga", 275);
    freq.put("fir", 262);
    freq.put("ubl", 72);
    freq.put("hã", 851);
    freq.put("há", 149);
    freq.put("in ", 625);
    freq.put("Mar", 291);
    freq.put("uça", 50);
    freq.put("nça", 749);
    freq.put("eoc", 81);
    freq.put("íd", 229);
    freq.put("eog", 31);
    freq.put("íc", 314);
    freq.put("íb", 29);
    freq.put("ím", 58);
    freq.put("íl", 122);
    freq.put("pós", 91);
    freq.put("ê", 3866);
    freq.put("eon", 29);
    freq.put("oel", 55);
    freq.put("aga", 466);
    freq.put("eos", 55);
    freq.put("eor", 27);
    freq.put("ív", 277);
    freq.put("fis", 110);
    freq.put("ís", 156);
    freq.put("ír", 51);
    freq.put("óx", 102);
    freq.put(" U ", 95);
    freq.put("Tur", 22);
    freq.put("íz", 26);
  }
  
}

