package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class RO {
  private static final String name = "ro";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public RO() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 187054;
    n_words[1] = 226134;
    n_words[2] = 181585;

    freq.put("pto", 14);
    freq.put("ţi", 477);
    freq.put("mă", 100);
    freq.put("alo", 41);
    freq.put("rev", 40);
    freq.put("ţa", 82);
    freq.put("all", 16);
    freq.put("ţe", 64);
    freq.put("ădi", 3);
    freq.put("MA ", 6);
    freq.put("alm", 4);
    freq.put("unc", 85);
    freq.put(" G ", 10);
    freq.put("eră", 20);
    freq.put("sci", 5);
    freq.put("În ", 17);
    freq.put("ţu", 23);
    freq.put("alk", 3);
    freq.put("aua", 29);
    freq.put("făr", 14);
    freq.put("ţi ", 180);
    freq.put("xtr", 9);
    freq.put("efo", 26);
    freq.put("IX ", 3);
    freq.put("XP ", 4);
    freq.put("âni", 67);
    freq.put("eîn", 3);
    freq.put("cm ", 3);
    freq.put("aus", 10);
    freq.put("făc", 12);
    freq.put("aut", 66);
    freq.put("Pos", 11);
    freq.put("G ", 23);
    freq.put("tai", 29);
    freq.put("ren", 98);
    freq.put("auz", 34);
    freq.put("ald", 14);
    freq.put("xti", 5);
    freq.put("reo", 17);
    freq.put(" Gu", 26);
    freq.put(" Gr", 39);
    freq.put(" Gs", 5);
    freq.put("nul", 175);
    freq.put("sca", 79);
    freq.put("erş", 3);
    freq.put("Ci", 56);
    freq.put(" Gy", 3);
    freq.put("ânc", 7);
    freq.put(" Ge", 25);
    freq.put("pta", 61);
    freq.put(" Ga", 59);
    freq.put("SP ", 3);
    freq.put(" Go", 38);
    freq.put("ala", 172);
    freq.put("âna", 6);
    freq.put(" Gh", 27);
    freq.put(" Gi", 22);
    freq.put("upo", 9);
    freq.put("Gu", 26);
    freq.put("şov", 9);
    freq.put("Gs", 5);
    freq.put("Gr", 41);
    freq.put("mţ", 3);
    freq.put("upi", 5);
    freq.put("ref", 35);
    freq.put("ţii", 61);
    freq.put("upe", 52);
    freq.put("ţio", 36);
    freq.put("ţin", 43);
    freq.put("Gy", 3);
    freq.put("zdr", 3);
    freq.put("du ", 21);
    freq.put("Ge", 25);
    freq.put("şof", 3);
    freq.put("şoa", 8);
    freq.put("âne", 11);
    freq.put("Ga", 59);
    freq.put("xt ", 7);
    freq.put("Go", 38);
    freq.put("upt", 14);
    freq.put("upu", 9);
    freq.put("upr", 16);
    freq.put("mma", 3);
    freq.put("Gi", 23);
    freq.put("Gh", 27);
    freq.put("", 5);
    freq.put(" ka", 4);
    freq.put(" kg", 5);
    freq.put("ţâ", 3);
    freq.put(" ki", 13);
    freq.put(" kn", 3);
    freq.put("ajo", 8);
    freq.put(" km", 11);
    freq.put("scu", 158);
    freq.put("lu ", 36);
    freq.put("ăţi", 18);
    freq.put("Iga", 5);
    freq.put("Vas", 12);
    freq.put("ăţe", 4);
    freq.put("uaţ", 3);
    freq.put("air", 4);
    freq.put("Tom", 3);
    freq.put("di ", 11);
    freq.put("nen", 12);
    freq.put("neo", 8);
    freq.put("nel", 57);
    freq.put("enţ", 39);
    freq.put("răz", 8);
    freq.put("neh", 5);
    freq.put("nei", 38);
    freq.put("nef", 7);
    freq.put("neg", 6);
    freq.put("ned", 13);
    freq.put("nee", 7);
    freq.put("Z ", 8);
    freq.put("aio", 11);
    freq.put("Pub", 11);
    freq.put("nea", 112);
    freq.put("orv", 3);
    freq.put("abi", 46);
    freq.put("ain", 70);
    freq.put("nez", 26);
    freq.put("alp", 10);
    freq.put("pin", 20);
    freq.put("ney", 5);
    freq.put("Put", 6);
    freq.put("new", 5);
    freq.put("net", 43);
    freq.put("scr", 45);
    freq.put("ner", 92);
    freq.put("nes", 67);
    freq.put("nep", 3);
    freq.put("mee", 3);
    freq.put("dep", 33);
    freq.put(" k ", 5);
    freq.put("ou ", 88);
    freq.put("mea", 80);
    freq.put("loo", 6);
    freq.put("mec", 35);
    freq.put("exy", 6);
    freq.put("raş", 20);
    freq.put("men", 230);
    freq.put("mei", 38);
    freq.put("auc", 3);
    freq.put("tiu", 67);
    freq.put("meu", 28);
    freq.put("fun", 23);
    freq.put("orp", 3);
    freq.put("mes", 49);
    freq.put("aid", 9);
    freq.put("oln", 3);
    freq.put("aud", 17);
    freq.put("gli", 6);
    freq.put("dio", 36);
    freq.put("Zo", 8);
    freq.put("Zi", 23);
    freq.put(" yo", 4);
    freq.put("Ze", 8);
    freq.put("k", 311);
    freq.put("Zg", 3);
    freq.put("dru", 26);
    freq.put("gle", 23);
    freq.put("bro", 14);
    freq.put("dri", 29);
    freq.put("aki", 4);
    freq.put("aic", 47);
    freq.put("dro", 20);
    freq.put("tw", 34);
    freq.put("dra", 46);
    freq.put("Zu", 4);
    freq.put("aka", 4);
    freq.put("aib", 5);
    freq.put("dre", 56);
    freq.put("glu", 7);
    freq.put("ake", 7);
    freq.put("ork", 5);
    freq.put("nk ", 7);
    freq.put("St ", 4);
    freq.put("bru", 6);
    freq.put("ori", 292);
    freq.put("upă", 41);
    freq.put("aul", 11);
    freq.put("pia", 16);
    freq.put("kg ", 5);
    freq.put("Jea", 3);
    freq.put("up ", 19);
    freq.put("bri", 95);
    freq.put("lma", 8);
    freq.put("nde", 121);
    freq.put("bre", 7);
    freq.put("aun", 7);
    freq.put("Jen", 3);
    freq.put("OR ", 15);
    freq.put("lor", 299);
    freq.put("¦", 4);
    freq.put("m ", 1002);
    freq.put("met", 32);
    freq.put("Iub", 5);
    freq.put("Ora", 8);
    freq.put("LA ", 16);
    freq.put("lme", 18);
    freq.put("Tit", 6);
    freq.put("aur", 36);
    freq.put("er ", 225);
    freq.put("det", 34);
    freq.put("Din", 28);
    freq.put("ora", 125);
    freq.put(" mî", 4);
    freq.put("Val", 28);
    freq.put("Ste", 51);
    freq.put("Rei", 3);
    freq.put("Sta", 28);
    freq.put("ătă", 8);
    freq.put("erS", 3);
    freq.put("ngu", 38);
    freq.put("Sto", 10);
    freq.put("lci", 8);
    freq.put("Sti", 52);
    freq.put("it", 1241);
    freq.put("tf", 9);
    freq.put("osp", 3);
    freq.put("ât ", 30);
    freq.put("Str", 19);
    freq.put("V", 397);
    freq.put("Lup", 8);
    freq.put("iv", 256);
    freq.put("ţiş", 8);
    freq.put("me", 904);
    freq.put("md", 3);
    freq.put("erv", 76);
    freq.put("mf", 14);
    freq.put("ma", 1381);
    freq.put("alt", 71);
    freq.put("err", 13);
    freq.put("mb", 207);
    freq.put("mm", 16);
    freq.put("ml", 4);
    freq.put("mo", 306);
    freq.put("mn", 114);
    freq.put("mi", 832);
    freq.put("ery", 4);
    freq.put("erz", 12);
    freq.put("tc", 19);
    freq.put("mu", 413);
    freq.put("mt", 26);
    freq.put("erf", 20);
    freq.put("mv", 9);
    freq.put("CT ", 3);
    freq.put("mp", 324);
    freq.put("ms", 14);
    freq.put("uă ", 22);
    freq.put("erl", 10);
    freq.put("erm", 55);
    freq.put("ern", 76);
    freq.put("ero", 29);
    freq.put("my", 12);
    freq.put("eri", 350);
    freq.put("găt", 9);
    freq.put("Lif", 4);
    freq.put("Le", 34);
    freq.put("Nat", 21);
    freq.put("Lib", 11);
    freq.put("La", 68);
    freq.put("Lil", 3);
    freq.put("Lo", 23);
    freq.put("Lin", 7);
    freq.put("uar", 32);
    freq.put("la ", 970);
    freq.put("uat", 30);
    freq.put("Li", 73);
    freq.put("uai", 3);
    freq.put("tzi", 5);
    freq.put("ov ", 21);
    freq.put("Lu", 33);
    freq.put("uam", 4);
    freq.put("ual", 42);
    freq.put("uan", 9);
    freq.put("Ly", 4);
    freq.put("ena", 55);
    freq.put("ib", 108);
    freq.put("end", 44);
    freq.put("ene", 95);
    freq.put("enf", 3);
    freq.put("eng", 6);
    freq.put("hon", 30);
    freq.put("hoo", 7);
    freq.put("enj", 5);
    freq.put("deş", 3);
    freq.put("ec ", 25);
    freq.put("neţ", 3);
    freq.put("enn", 8);
    freq.put("eno", 17);
    freq.put("oy ", 6);
    freq.put("how", 6);
    freq.put("hot", 23);
    freq.put("hou", 6);
    freq.put("hor", 4);
    freq.put("enu", 42);
    freq.put("hop", 9);
    freq.put("mpo", 40);
    freq.put("mbl", 4);
    freq.put("enz", 19);
    freq.put("nvă", 3);
    freq.put("fap", 11);
    freq.put("A", 800);
    freq.put("lam", 26);
    freq.put("Not", 3);
    freq.put("ţ ", 8);
    freq.put("lah", 4);
    freq.put("lai", 7);
    freq.put("L ", 78);
    freq.put("lad", 12);
    freq.put("lae", 10);
    freq.put("ON ", 29);
    freq.put("lag", 4);
    freq.put("ost", 238);
    freq.put("lab", 15);
    freq.put("nţu", 4);
    freq.put("ova", 45);
    freq.put("lax", 14);
    freq.put("II ", 18);
    freq.put("dba", 3);
    freq.put("ove", 52);
    freq.put("lat", 124);
    freq.put("ua ", 114);
    freq.put("lav", 5);
    freq.put("pt ", 56);
    freq.put("lap", 13);
    freq.put("ovo", 7);
    freq.put("lar", 98);
    freq.put("las", 49);
    freq.put("en ", 47);
    freq.put("ogl", 20);
    freq.put("Înt", 7);
    freq.put("ho ", 4);
    freq.put("mâ", 120);
    freq.put("mî", 8);
    freq.put("Alb", 14);
    freq.put("onv", 6);
    freq.put("Ala", 4);
    freq.put("mpu", 30);
    freq.put("mul", 258);
    freq.put("Pon", 8);
    freq.put("TA ", 11);
    freq.put("Alt", 5);
    freq.put("Alu", 3);
    freq.put("ăţă", 3);
    freq.put("UK ", 3);
    freq.put(" V ", 7);
    freq.put("lba", 17);
    freq.put("zea", 15);
    freq.put("toş", 5);
    freq.put(" Hr", 3);
    freq.put("zei", 6);
    freq.put("zen", 28);
    freq.put(" Hu", 12);
    freq.put("loz", 5);
    freq.put("zer", 17);
    freq.put("zes", 11);
    freq.put(" Hi", 6);
    freq.put("xi", 51);
    freq.put(" Ho", 32);
    freq.put("zeu", 14);
    freq.put("zez", 9);
    freq.put(" Ha", 28);
    freq.put(" He", 12);
    freq.put("ono", 25);
    freq.put("ima", 113);
    freq.put("fis", 14);
    freq.put("imb", 65);
    freq.put("ime", 116);
    freq.put("cli", 36);
    freq.put("fit", 8);
    freq.put("fiu", 11);
    freq.put("imi", 188);
    freq.put("cle", 15);
    freq.put("fix", 4);
    freq.put("imm", 3);
    freq.put("cla", 51);
    freq.put("imo", 13);
    freq.put("imn", 4);
    freq.put("ssa", 3);
    freq.put("imp", 115);
    freq.put("fia", 13);
    freq.put("imu", 55);
    freq.put("rţi", 5);
    freq.put("râ", 17);
    freq.put("fie", 56);
    freq.put("moa", 33);
    freq.put("rţe", 3);
    freq.put("fii", 31);
    freq.put("fin", 44);
    freq.put("fil", 30);
    freq.put(" Va", 108);
    freq.put("Pol", 15);
    freq.put("ze ", 54);
    freq.put("soa", 50);
    freq.put(" Ve", 53);
    freq.put("PR ", 7);
    freq.put("RS ", 4);
    freq.put(" Vi", 96);
    freq.put("ăi ", 4);
    freq.put("SA ", 4);
    freq.put(" Vl", 8);
    freq.put(" Vo", 39);
    freq.put("ong", 13);
    freq.put("¦ ", 4);
    freq.put(" Vr", 15);
    freq.put("ţig", 7);
    freq.put("ntâ", 7);
    freq.put("li ", 29);
    freq.put("im ", 69);
    freq.put("ava", 32);
    freq.put("atâ", 5);
    freq.put("ţie", 41);
    freq.put("Opt", 6);
    freq.put("şor", 5);
    freq.put("l", 8796);
    freq.put("fi ", 101);
    freq.put("ony", 6);
    freq.put("lbe", 7);
    freq.put("th ", 6);
    freq.put("Și ", 10);
    freq.put("deo", 50);
    freq.put("raţ", 24);
    freq.put("rS", 4);
    freq.put("Cse", 3);
    freq.put("Wor", 3);
    freq.put("bra", 35);
    freq.put("nii", 107);
    freq.put("cma", 10);
    freq.put("mbo", 9);
    freq.put("nşe", 3);
    freq.put("upa", 76);
    freq.put("xp", 38);
    freq.put("gom", 3);
    freq.put("gol", 14);
    freq.put("goo", 8);
    freq.put("gon", 5);
    freq.put("goi", 3);
    freq.put("rr", 37);
    freq.put("rs", 202);
    freq.put(" ze", 9);
    freq.put(" zd", 3);
    freq.put(" zg", 4);
    freq.put("nim", 61);
    freq.put("goa", 5);
    freq.put("ry", 22);
    freq.put("goc", 3);
    freq.put("rd", 131);
    freq.put("re", 3182);
    freq.put("rf", 37);
    freq.put("rg", 151);
    freq.put("ra", 1671);
    freq.put("rb", 127);
    freq.put("rc", 215);
    freq.put("rl", 38);
    freq.put("rm", 238);
    freq.put("rn", 149);
    freq.put("is ", 113);
    freq.put("rh", 15);
    freq.put("ri", 2326);
    freq.put("gos", 15);
    freq.put("gor", 17);
    freq.put(" Vâ", 3);
    freq.put("ţiu", 15);
    freq.put("ial", 117);
    freq.put("iţă", 7);
    freq.put("ţit", 3);
    freq.put("ntu", 131);
    freq.put("ajă", 3);
    freq.put("nti", 135);
    freq.put("şom", 3);
    freq.put("FR ", 5);
    freq.put("mbi", 20);
    freq.put("W", 67);
    freq.put("nta", 257);
    freq.put("Î", 52);
    freq.put("aps", 8);
    freq.put("deb", 11);
    freq.put("ada", 46);
    freq.put("Vic", 25);
    freq.put("Via", 4);
    freq.put("bţi", 7);
    freq.put("Vid", 8);
    freq.put("xus", 3);
    freq.put("iss", 8);
    freq.put("ato", 143);
    freq.put("isp", 31);
    freq.put("Cân", 10);
    freq.put("go ", 12);
    freq.put("isu", 15);
    freq.put("ist", 257);
    freq.put("Vir", 9);
    freq.put("Vis", 4);
    freq.put("isi", 63);
    freq.put("ish", 4);
    freq.put("iso", 43);
    freq.put("isn", 3);
    freq.put("ism", 33);
    freq.put("isl", 4);
    freq.put("Viz", 10);
    freq.put("caf", 7);
    freq.put("isa", 14);
    freq.put("dec", 96);
    freq.put("be ", 21);
    freq.put("ise", 41);
    freq.put("Cod", 12);
    freq.put("kfu", 5);
    freq.put("Dum", 7);
    freq.put(" l ", 69);
    freq.put("ăre", 7);
    freq.put("Dub", 3);
    freq.put("api", 30);
    freq.put("on ", 133);
    freq.put("pir", 11);
    freq.put("iţa", 9);
    freq.put(" Şa", 4);
    freq.put("nir", 21);
    freq.put("ăcu", 16);
    freq.put("xD", 4);
    freq.put("osa", 11);
    freq.put("nis", 76);
    freq.put("Dup", 11);
    freq.put("tel", 223);
    freq.put("nip", 3);
    freq.put("Îm", 6);
    freq.put(" Vă", 5);
    freq.put("ză ", 80);
    freq.put("ten", 71);
    freq.put("Cea", 9);
    freq.put("tor", 307);
    freq.put("Cen", 13);
    freq.put("top", 26);
    freq.put("Cel", 27);
    freq.put("xim", 10);
    freq.put("Cei", 3);
    freq.put("Ceh", 3);
    freq.put("Cev", 3);
    freq.put("ae ", 9);
    freq.put("xis", 26);
    freq.put("ton", 27);
    freq.put("xiu", 3);
    freq.put("tol", 7);
    freq.put("Se ", 25);
    freq.put("tob", 7);
    freq.put("toc", 37);
    freq.put("toa", 134);
    freq.put("tof", 7);
    freq.put("zeş", 3);
    freq.put("tod", 14);
    freq.put(" le", 120);
    freq.put("B", 644);
    freq.put("Fur", 5);
    freq.put("Mul", 23);
    freq.put(" la", 897);
    freq.put("Roc", 7);
    freq.put(" lo", 172);
    freq.put("lty", 3);
    freq.put("Soc", 6);
    freq.put(" li", 115);
    freq.put("arp", 3);
    freq.put("atr", 58);
    freq.put(" lu", 316);
    freq.put("Fun", 5);
    freq.put("Fum", 4);
    freq.put("Fuj", 3);
    freq.put(" ly", 3);
    freq.put("Sev", 3);
    freq.put("njo", 3);
    freq.put("Set", 3);
    freq.put("lla", 13);
    freq.put("Ser", 30);
    freq.put("nzu", 4);
    freq.put("Sep", 9);
    freq.put("eCo", 3);
    freq.put("Sez", 7);
    freq.put("Sex", 4);
    freq.put("Jum", 3);
    freq.put("nza", 52);
    freq.put("Sec", 4);
    freq.put("Seb", 5);
    freq.put("zăr", 9);
    freq.put("Vi", 97);
    freq.put("Sen", 9);
    freq.put("Sem", 3);
    freq.put("Sel", 3);
    freq.put("raf", 56);
    freq.put("rag", 52);
    freq.put("rad", 67);
    freq.put("epu", 42);
    freq.put("rab", 20);
    freq.put("rac", 74);
    freq.put("ran", 171);
    freq.put("epr", 31);
    freq.put("ral", 44);
    freq.put("rş", 15);
    freq.put("usu", 13);
    freq.put("rah", 3);
    freq.put("rai", 53);
    freq.put("rav", 29);
    freq.put("tep", 39);
    freq.put("rat", 294);
    freq.put("rau", 20);
    freq.put("rar", 88);
    freq.put("ras", 79);
    freq.put("rap", 19);
    freq.put("dur", 35);
    freq.put("isă", 3);
    freq.put("î", 537);
    freq.put("raz", 14);
    freq.put("că ", 228);
    freq.put("ray", 3);
    freq.put("VC ", 3);
    freq.put("iţi", 75);
    freq.put("ţea", 12);
    freq.put("der", 75);
    freq.put("Ast", 22);
    freq.put("do ", 3);
    freq.put("daţ", 8);
    freq.put("epl", 9);
    freq.put("iţe", 6);
    freq.put("teu", 6);
    freq.put("Asc", 3);
    freq.put("hul", 4);
    freq.put("Asa", 5);
    freq.put("thl", 3);
    freq.put("ype", 3);
    freq.put("Asi", 7);
    freq.put("Len", 3);
    freq.put("x ", 42);
    freq.put("iţu", 3);
    freq.put("lp ", 4);
    freq.put("tyl", 6);
    freq.put("Qu", 4);
    freq.put(" lâ", 3);
    freq.put("ra ", 424);
    freq.put("căz", 3);
    freq.put("cău", 8);
    freq.put("căt", 20);
    freq.put("Chu", 6);
    freq.put("căp", 3);
    freq.put("căs", 5);
    freq.put("căr", 11);
    freq.put("căm", 6);
    freq.put("căl", 6);
    freq.put("sud", 4);
    freq.put("bsi", 5);
    freq.put("ră", 188);
    freq.put("căd", 6);
    freq.put("cap", 37);
    freq.put("Pui", 6);
    freq.put("doi", 23);
    freq.put("don", 12);
    freq.put("dol", 10);
    freq.put("dom", 29);
    freq.put("dob", 4);
    freq.put("doc", 10);
    freq.put("doa", 79);
    freq.put("m", 5842);
    freq.put("Ita", 6);
    freq.put("doz", 5);
    freq.put("dox", 3);
    freq.put("uda", 13);
    freq.put("lpi", 5);
    freq.put("sun", 167);
    freq.put("dor", 42);
    freq.put("dos", 13);
    freq.put("dop", 3);
    freq.put("dov", 27);
    freq.put("dow", 12);
    freq.put("dou", 32);
    freq.put(" We", 10);
    freq.put(" Wa", 8);
    freq.put("Că", 5);
    freq.put(" Wo", 6);
    freq.put("ude", 38);
    freq.put(" Wh", 6);
    freq.put(" Wi", 19);
    freq.put("şca", 7);
    freq.put("ogd", 4);
    freq.put("rta", 104);
    freq.put("Bin", 4);
    freq.put("och", 30);
    freq.put("Bil", 11);
    freq.put("ocm", 11);
    freq.put("em ", 92);
    freq.put("oco", 14);
    freq.put("oca", 90);
    freq.put("oga", 14);
    freq.put("aos", 3);
    freq.put("Bia", 6);
    freq.put("me ", 127);
    freq.put("sut", 14);
    freq.put("hri", 7);
    freq.put("cau", 56);
    freq.put("ba ", 73);
    freq.put("ngr", 9);
    freq.put("sus", 33);
    freq.put("Joh", 5);
    freq.put("ocr", 7);
    freq.put("Bir", 5);
    freq.put("oct", 19);
    freq.put("eş", 132);
    freq.put("do", 312);
    freq.put("dl", 3);
    freq.put("dm", 13);
    freq.put("dj", 5);
    freq.put("nex", 5);
    freq.put("dh", 6);
    freq.put("di", 1012);
    freq.put("dd", 13);
    freq.put("de", 2554);
    freq.put("db", 4);
    freq.put("dc", 6);
    freq.put("da", 610);
    freq.put("nev", 54);
    freq.put("gă ", 18);
    freq.put("cat", 253);
    freq.put("bi ", 11);
    freq.put("dy", 13);
    freq.put("dv", 8);
    freq.put("X", 30);
    freq.put("Afl", 7);
    freq.put("du", 373);
    freq.put("dr", 177);
    freq.put("ds", 10);
    freq.put("dp", 3);
    freq.put("eme", 83);
    freq.put("bat", 62);
    freq.put("bau", 4);
    freq.put("ema", 31);
    freq.put("Ope", 8);
    freq.put(" mă", 35);
    freq.put("oc ", 83);
    freq.put("emo", 26);
    freq.put("emn", 38);
    freq.put("emi", 72);
    freq.put("Ris", 3);
    freq.put("emu", 23);
    freq.put("bag", 18);
    freq.put("bad", 5);
    freq.put("uş", 26);
    freq.put("emp", 14);
    freq.put("Rih", 3);
    freq.put("ban", 71);
    freq.put("ăş", 10);
    freq.put("bal", 42);
    freq.put("bam", 9);
    freq.put("�", 3);
    freq.put("tiţ", 22);
    freq.put("bai", 18);
    freq.put(" ru", 47);
    freq.put("Vă", 5);
    freq.put("w ", 54);
    freq.put("Pet", 16);
    freq.put("PS ", 3);
    freq.put("nuu", 3);
    freq.put("Pep", 5);
    freq.put("nus", 10);
    freq.put("Per", 12);
    freq.put("Pes", 14);
    freq.put("nun", 106);
    freq.put("Pen", 31);
    freq.put("num", 73);
    freq.put("DN ", 5);
    freq.put("nui", 35);
    freq.put(" I ", 34);
    freq.put("iţ", 102);
    freq.put("epă", 3);
    freq.put("nua", 28);
    freq.put("ârş", 9);
    freq.put("mut", 6);
    freq.put("il ", 87);
    freq.put("mur", 49);
    freq.put("irp", 3);
    freq.put("mm ", 3);
    freq.put("RD ", 5);
    freq.put("irt", 11);
    freq.put("iru", 9);
    freq.put("muz", 19);
    freq.put("un ", 426);
    freq.put("iri", 90);
    freq.put("toţ", 8);
    freq.put("noş", 4);
    freq.put("irl", 3);
    freq.put("irm", 25);
    freq.put("iro", 20);
    freq.put("Tri", 15);
    freq.put("ira", 28);
    freq.put("irc", 15);
    freq.put("mui", 3);
    freq.put("ire", 135);
    freq.put("irg", 3);
    freq.put("omb", 33);
    freq.put("C", 1030);
    freq.put("Exe", 4);
    freq.put("zba", 3);
    freq.put("Exa", 3);
    freq.put("zbo", 7);
    freq.put("wn", 13);
    freq.put(" Ir", 12);
    freq.put(" Is", 10);
    freq.put(" It", 7);
    freq.put(" Iu", 17);
    freq.put("wi", 37);
    freq.put("Exi", 3);
    freq.put("ww", 32);
    freq.put("Ext", 3);
    freq.put("cut", 129);
    freq.put(" Il", 9);
    freq.put(" Im", 17);
    freq.put("Exp", 6);
    freq.put(" Io", 28);
    freq.put(" Ia", 32);
    freq.put("laţ", 10);
    freq.put(" Id", 4);
    freq.put(" Ie", 7);
    freq.put("nu ", 453);
    freq.put(" Ig", 5);
    freq.put("gge", 12);
    freq.put("ild", 7);
    freq.put("ile", 340);
    freq.put("cou", 13);
    freq.put("ell", 20);
    freq.put("Pok", 3);
    freq.put("ila", 35);
    freq.put("oki", 12);
    freq.put("ilo", 164);
    freq.put("ill", 26);
    freq.put("ilm", 28);
    freq.put("tt ", 6);
    freq.put("Epi", 8);
    freq.put("ili", 135);
    freq.put("ilv", 8);
    freq.put("una", 85);
    freq.put("coc", 3);
    freq.put("ilu", 17);
    freq.put("und", 71);
    freq.put("cod", 8);
    freq.put("unf", 5);
    freq.put("cof", 3);
    freq.put("ir ", 7);
    freq.put("uni", 127);
    freq.put("mnă", 9);
    freq.put("com", 135);
    freq.put("epţ", 4);
    freq.put("coo", 9);
    freq.put("ily", 3);
    freq.put(" md", 3);
    freq.put(" me", 251);
    freq.put(" mf", 9);
    freq.put("ela", 58);
    freq.put(" ma", 732);
    freq.put("emă", 3);
    freq.put("can", 129);
    freq.put(" ml", 3);
    freq.put(" mn", 6);
    freq.put(" mo", 139);
    freq.put(" mi", 317);
    freq.put("Gar", 12);
    freq.put(" mu", 218);
    freq.put("Pas", 6);
    freq.put(" mp", 14);
    freq.put("eld", 4);
    freq.put(" ms", 3);
    freq.put(" my", 4);
    freq.put("lân", 5);
    freq.put("fra", 33);
    freq.put("eag", 20);
    freq.put("che", 89);
    freq.put("fre", 12);
    freq.put("lti", 78);
    freq.put("fri", 15);
    freq.put("C ", 71);
    freq.put("fro", 7);
    freq.put("dă", 45);
    freq.put("şo", 32);
    freq.put("şn", 3);
    freq.put("gn ", 5);
    freq.put("rmă", 24);
    freq.put("fru", 40);
    freq.put("One", 5);
    freq.put("ane", 104);
    freq.put("şc", 23);
    freq.put("ann", 6);
    freq.put("şa", 34);
    freq.put("piz", 4);
    freq.put("ano", 12);
    freq.put(" m ", 61);
    freq.put("Cru", 5);
    freq.put("Naţ", 7);
    freq.put("pri", 261);
    freq.put("Cer", 7);
    freq.put("xxx", 3);
    freq.put("sso", 3);
    freq.put("Nap", 9);
    freq.put("VR ", 6);
    freq.put("anj", 7);
    freq.put("Cre", 20);
    freq.put("Cri", 20);
    freq.put("TV ", 26);
    freq.put("€", 4);
    freq.put("Vâ", 3);
    freq.put("Ch", 51);
    freq.put("Co", 236);
    freq.put("Cl", 63);
    freq.put("aiu", 6);
    freq.put("elv", 3);
    freq.put("Ca", 168);
    freq.put("RI ", 7);
    freq.put("Ce", 116);
    freq.put("n", 11555);
    freq.put("aim", 6);
    freq.put("ail", 21);
    freq.put("ET ", 7);
    freq.put("slo", 3);
    freq.put("aii", 4);
    freq.put("baţ", 5);
    freq.put("gne", 5);
    freq.put("Cs", 4);
    freq.put("Cr", 60);
    freq.put("aif", 5);
    freq.put("aia", 72);
    freq.put("sla", 10);
    freq.put("Cu", 130);
    freq.put("ş ", 34);
    freq.put("ază", 66);
    freq.put("ix", 13);
    freq.put("ă", 1897);
    freq.put("iz", 243);
    freq.put("ilă", 11);
    freq.put(" mâ", 14);
    freq.put("Dim", 3);
    freq.put("ip", 163);
    freq.put("is", 688);
    freq.put("ir", 356);
    freq.put("iu", 507);
    freq.put("Gaz", 6);
    freq.put("Za", 6);
    freq.put("ii", 819);
    freq.put("ih", 36);
    freq.put("ik", 22);
    freq.put("ij", 18);
    freq.put("im", 776);
    freq.put("il", 868);
    freq.put("io", 335);
    freq.put("in", 3167);
    freq.put("ia", 1225);
    freq.put("ic", 1112);
    freq.put("ki ", 4);
    freq.put("ie", 1091);
    freq.put("id", 243);
    freq.put("ig", 188);
    freq.put("if", 102);
    freq.put("V ", 44);
    freq.put("lvi", 3);
    freq.put("riv", 44);
    freq.put("ajn", 3);
    freq.put("ado", 25);
    freq.put("art", 250);
    freq.put("iP", 24);
    freq.put("bii", 3);
    freq.put("iT", 3);
    freq.put("dha", 4);
    freq.put("Pan", 10);
    freq.put("iN", 3);
    freq.put("iA", 4);
    freq.put("ep ", 13);
    freq.put("iF", 3);
    freq.put("tsu", 3);
    freq.put("bie", 32);
    freq.put("nin", 20);
    freq.put("nio", 5);
    freq.put("nil", 46);
    freq.put("zoa", 3);
    freq.put("kis", 5);
    freq.put("nic", 121);
    freq.put("nia", 153);
    freq.put("nif", 10);
    freq.put("nig", 3);
    freq.put("Dia", 9);
    freq.put("kik", 3);
    freq.put("tz ", 4);
    freq.put("mij", 3);
    freq.put("kin", 7);
    freq.put("kil", 6);
    freq.put("Y", 22);
    freq.put("i ", 5647);
    freq.put("kia", 11);
    freq.put("ăm ", 21);
    freq.put("niv", 30);
    freq.put("RE ", 21);
    freq.put("kie", 5);
    freq.put("niu", 21);
    freq.put("Va", 108);
    freq.put("LO ", 4);
    freq.put("Ve", 53);
    freq.put("sme", 9);
    freq.put("nem", 16);
    freq.put("Câ", 21);
    freq.put("ept", 102);
    freq.put(" L ", 4);
    freq.put("Vl", 8);
    freq.put("eps", 4);
    freq.put("Vo", 39);
    freq.put("tho", 4);
    freq.put("epo", 11);
    freq.put("Vr", 15);
    freq.put("unţ", 25);
    freq.put("Vu", 4);
    freq.put("epi", 18);
    freq.put("the", 15);
    freq.put("epe", 33);
    freq.put("nuă", 4);
    freq.put("tha", 3);
    freq.put("epa", 32);
    freq.put("rus", 18);
    freq.put("soţ", 6);
    freq.put("cam", 83);
    freq.put("diş", 3);
    freq.put("rn ", 13);
    freq.put("op ", 26);
    freq.put("lmu", 5);
    freq.put("Ș", 14);
    freq.put("Ech", 7);
    freq.put("hah", 5);
    freq.put("hai", 35);
    freq.put("eli", 73);
    freq.put("ham", 6);
    freq.put("han", 16);
    freq.put("mix", 3);
    freq.put("elc", 4);
    freq.put("Gat", 4);
    freq.put("hae", 5);
    freq.put("haf", 4);
    freq.put("ele", 516);
    freq.put("Ar ", 3);
    freq.put("Gal", 22);
    freq.put("ris", 86);
    freq.put("har", 17);
    freq.put("Gad", 5);
    freq.put("hat", 11);
    freq.put("Gab", 4);
    freq.put("elt", 6);
    freq.put("elu", 55);
    freq.put("uso", 11);
    freq.put("opu", 43);
    freq.put("rni", 22);
    freq.put("vii", 28);
    freq.put("rno", 6);
    freq.put("D", 654);
    freq.put("Tro", 6);
    freq.put("fov", 4);
    freq.put("Tra", 51);
    freq.put("vin", 108);
    freq.put("rna", 46);
    freq.put("Tre", 18);
    freq.put("rne", 39);
    freq.put("RL ", 3);
    freq.put("ope", 73);
    freq.put("lcd", 3);
    freq.put("lce", 25);
    freq.put("Tot", 6);
    freq.put("reţ", 19);
    freq.put("opl", 3);
    freq.put("lco", 6);
    freq.put("osi", 48);
    freq.put("opo", 25);
    freq.put("Tru", 4);
    freq.put("opi", 38);
    freq.put("rnu", 18);
    freq.put("IO ", 6);
    freq.put("ăst", 15);
    freq.put("Ars", 3);
    freq.put("Art", 20);
    freq.put("rke", 8);
    freq.put("ha ", 13);
    freq.put("miu", 4);
    freq.put("el ", 207);
    freq.put("oră", 5);
    freq.put("Ara", 9);
    freq.put("rva", 12);
    freq.put("şe", 52);
    freq.put("Are", 7);
    freq.put("Arh", 3);
    freq.put("Ari", 4);
    freq.put("Lyn", 3);
    freq.put("aug", 31);
    freq.put("Arm", 3);
    freq.put("pâ", 4);
    freq.put("ola", 62);
    freq.put("www", 16);
    freq.put("old", 30);
    freq.put("vit", 66);
    freq.put("olf", 3);
    freq.put(" Ju", 41);
    freq.put("oli", 77);
    freq.put(" X ", 13);
    freq.put("oll", 27);
    freq.put("abs", 11);
    freq.put("olo", 61);
    freq.put(" Jo", 47);
    freq.put(" Ji", 3);
    freq.put("olu", 53);
    freq.put("olv", 13);
    freq.put("nş", 7);
    freq.put(" Je", 8);
    freq.put("an ", 258);
    freq.put("noc", 3);
    freq.put("mbă", 6);
    freq.put(" Ja", 11);
    freq.put("ick", 10);
    freq.put("Lea", 10);
    freq.put("ici", 276);
    freq.put("ich", 8);
    freq.put("ico", 62);
    freq.put("ump", 43);
    freq.put("for", 76);
    freq.put("icl", 19);
    freq.put("Hr", 3);
    freq.put("von", 3);
    freq.put("ica", 234);
    freq.put("nţ", 128);
    freq.put("ice", 132);
    freq.put("Hu", 12);
    freq.put("ume", 125);
    freq.put("Hi", 6);
    freq.put("uma", 65);
    freq.put("Ho", 33);
    freq.put("Lev", 3);
    freq.put("foc", 6);
    freq.put("ics", 8);
    freq.put("icr", 12);
    freq.put("fon", 34);
    freq.put("Ha", 28);
    freq.put("umi", 50);
    freq.put("icu", 69);
    freq.put("ict", 50);
    freq.put("ţil", 11);
    freq.put("plu", 34);
    freq.put("Ofi", 7);
    freq.put("pls", 6);
    freq.put("Bd ", 4);
    freq.put("nă", 115);
    freq.put("ast", 277);
    freq.put("ril", 175);
    freq.put("PT ", 7);
    freq.put("ple", 76);
    freq.put("ww ", 16);
    freq.put("pla", 104);
    freq.put("plo", 23);
    freq.put("rt", 518);
    freq.put("Gsm", 3);
    freq.put("âtă", 3);
    freq.put("pli", 55);
    freq.put("Iul", 10);
    freq.put("zur", 5);
    freq.put("obo", 11);
    freq.put("obl", 27);
    freq.put("zut", 31);
    freq.put("sfo", 8);
    freq.put("ND ", 4);
    freq.put("ic ", 153);
    freq.put("o", 8590);
    freq.put("oba", 21);
    freq.put("ome", 81);
    freq.put("zua", 9);
    freq.put("fo ", 5);
    freq.put("um ", 204);
    freq.put("adă", 15);
    freq.put("zuk", 3);
    freq.put("H ", 6);
    freq.put("zui", 3);
    freq.put("zun", 4);
    freq.put("obs", 29);
    freq.put("zul", 29);
    freq.put("xu", 18);
    freq.put("Cuv", 3);
    freq.put("Fed", 3);
    freq.put("Fee", 5);
    freq.put("ars", 22);
    freq.put("Cur", 19);
    freq.put("ppe", 7);
    freq.put("Cup", 13);
    freq.put("mbe", 12);
    freq.put("Fel", 8);
    freq.put("Fem", 4);
    freq.put("som", 11);
    freq.put("sol", 31);
    freq.put("son", 29);
    freq.put("Fet", 10);
    freq.put("sor", 40);
    freq.put("Fer", 8);
    freq.put("Fes", 17);
    freq.put("lii", 32);
    freq.put("rv", 83);
    freq.put("IV ", 5);
    freq.put("Cum", 52);
    freq.put("Cul", 8);
    freq.put("mbr", 84);
    freq.put("ole", 52);
    freq.put("oţi", 34);
    freq.put("giu", 17);
    freq.put("git", 14);
    freq.put("gis", 9);
    freq.put("gir", 9);
    freq.put("gip", 3);
    freq.put("rnă", 3);
    freq.put("suf", 8);
    freq.put("orţ", 8);
    freq.put("cac", 4);
    freq.put("gie", 14);
    freq.put("LT ", 3);
    freq.put("gic", 10);
    freq.put("gia", 11);
    freq.put("gio", 4);
    freq.put("gin", 51);
    freq.put("gim", 11);
    freq.put("gil", 4);
    freq.put("gii", 11);
    freq.put("so ", 6);
    freq.put("ah ", 17);
    freq.put("eSt", 3);
    freq.put("TE ", 28);
    freq.put("mb ", 15);
    freq.put("aţa", 25);
    freq.put("xy ", 13);
    freq.put("rp", 28);
    freq.put("nte", 341);
    freq.put("Cu ", 20);
    freq.put("caţ", 8);
    freq.put("Z", 60);
    freq.put("ura", 163);
    freq.put("azi", 94);
    freq.put("rii", 136);
    freq.put("aja", 10);
    freq.put("Voc", 8);
    freq.put("Vol", 4);
    freq.put("aza", 96);
    freq.put("bs ", 19);
    freq.put("azd", 4);
    freq.put("Voi", 13);
    freq.put("Pov", 4);
    freq.put("azz", 3);
    freq.put("mti", 6);
    freq.put("Vor", 6);
    freq.put("gi ", 30);
    freq.put("olt", 21);
    freq.put("Îmi", 4);
    freq.put("azu", 31);
    freq.put("azv", 3);
    freq.put("mte", 6);
    freq.put("Sis", 7);
    freq.put("fâr", 7);
    freq.put("uro", 103);
    freq.put("Şti", 3);
    freq.put("nni", 4);
    freq.put("Au ", 7);
    freq.put(" n ", 55);
    freq.put("nne", 16);
    freq.put("nna", 8);
    freq.put("uri", 455);
    freq.put("Sib", 6);
    freq.put("afl", 30);
    freq.put("Sig", 3);
    freq.put("D ", 76);
    freq.put("nny", 6);
    freq.put("elo", 105);
    freq.put("oşi", 11);
    freq.put("Sin", 8);
    freq.put("Sim", 12);
    freq.put(" �", 3);
    freq.put("ni", 1177);
    freq.put("nj", 20);
    freq.put("nk", 25);
    freq.put("nl", 72);
    freq.put("nm", 7);
    freq.put("nn", 41);
    freq.put("no", 370);
    freq.put("icţ", 3);
    freq.put("na", 879);
    freq.put("nb", 6);
    freq.put("nc", 542);
    freq.put("nd", 634);
    freq.put("ne", 1234);
    freq.put("nf", 73);
    freq.put("ng", 280);
    freq.put("nx", 3);
    freq.put("ny", 16);
    freq.put("nz", 86);
    freq.put("tio", 61);
    freq.put("plă", 17);
    freq.put("tii", 177);
    freq.put("ES ", 3);
    freq.put("tid", 13);
    freq.put("tie", 151);
    freq.put("nr", 17);
    freq.put("ns", 393);
    freq.put("nt", 1850);
    freq.put("nu", 961);
    freq.put("nv", 83);
    freq.put("tic", 146);
    freq.put(" ni", 89);
    freq.put("fot", 38);
    freq.put("E", 315);
    freq.put("urr", 4);
    freq.put(" no", 244);
    freq.put("naţ", 16);
    freq.put(" na", 45);
    freq.put("EA ", 11);
    freq.put("abu", 5);
    freq.put(" nb", 3);
    freq.put(" ne", 156);
    freq.put(" nd", 3);
    freq.put("nn ", 4);
    freq.put("mun", 50);
    freq.put("ăzb", 5);
    freq.put("Si ", 32);
    freq.put("tec", 34);
    freq.put("umă", 19);
    freq.put(" nr", 7);
    freq.put(" nu", 475);
    freq.put("pau", 7);
    freq.put("FC ", 11);
    freq.put("amb", 20);
    freq.put("Stu", 11);
    freq.put("n ", 2483);
    freq.put("Win", 8);
    freq.put("Wil", 3);
    freq.put("mme", 4);
    freq.put("fâ", 9);
    freq.put("Lei", 3);
    freq.put("rk ", 8);
    freq.put("tră", 14);
    freq.put("Poa", 5);
    freq.put("ti ", 544);
    freq.put("nku", 4);
    freq.put("roi", 51);
    freq.put("lly", 6);
    freq.put("rok", 3);
    freq.put("rol", 37);
    freq.put("rom", 106);
    freq.put("ron", 41);
    freq.put("roo", 4);
    freq.put("lls", 5);
    freq.put("roa", 42);
    freq.put("rob", 49);
    freq.put("roc", 28);
    freq.put("rod", 37);
    freq.put("roe", 6);
    freq.put("rof", 25);
    freq.put("rog", 38);
    freq.put("rox", 4);
    freq.put("osh", 5);
    freq.put("roz", 7);
    freq.put("înl", 4);
    freq.put("osm", 10);
    freq.put("per", 230);
    freq.put("oso", 7);
    freq.put("îş", 7);
    freq.put("rop", 87);
    freq.put("flă", 8);
    freq.put("ros", 52);
    freq.put("ău ", 13);
    freq.put("rou", 23);
    freq.put("rov", 12);
    freq.put("row", 8);
    freq.put("cît", 3);
    freq.put("Și", 10);
    freq.put("ver", 113);
    freq.put("ves", 54);
    freq.put("Dac", 45);
    freq.put("Dal", 3);
    freq.put("Dam", 5);
    freq.put("Dan", 26);
    freq.put("îţ", 7);
    freq.put("vez", 21);
    freq.put("aj ", 26);
    freq.put("tă", 240);
    freq.put("Dat", 10);
    freq.put("cţ", 28);
    freq.put("ved", 36);
    freq.put("vec", 14);
    freq.put("Dar", 15);
    freq.put("vea", 36);
    freq.put("cîn", 3);
    freq.put("vel", 35);
    freq.put("vem", 15);
    freq.put("foa", 37);
    freq.put("Cic", 7);
    freq.put("ert", 76);
    freq.put("ăsi", 8);
    freq.put("Mâ", 5);
    freq.put("sîn", 5);
    freq.put(" îţ", 6);
    freq.put("umb", 13);
    freq.put("Cio", 8);
    freq.put("Vân", 3);
    freq.put("fol", 25);
    freq.put(" on", 55);
    freq.put("Ciu", 3);
    freq.put("Cit", 7);
    freq.put("ăsu", 4);
    freq.put("erp", 7);
    freq.put("ll ", 20);
    freq.put("umo", 32);
    freq.put("Tat", 3);
    freq.put("ipă", 5);
    freq.put("din", 529);
    freq.put("foo", 3);
    freq.put("Da ", 20);
    freq.put("dii", 15);
    freq.put("gue", 10);
    freq.put("did", 13);
    freq.put("die", 25);
    freq.put("gui", 6);
    freq.put("ers", 101);
    freq.put("dia", 65);
    freq.put("gum", 8);
    freq.put("gul", 30);
    freq.put("gus", 25);
    freq.put("p", 5124);
    freq.put("ge ", 67);
    freq.put("guv", 11);
    freq.put("Tab", 12);
    freq.put("gut", 6);
    freq.put("Tal", 5);
    freq.put("ulţ", 19);
    freq.put("Tan", 3);
    freq.put("He", 15);
    freq.put("iN ", 3);
    freq.put(" de", 2040);
    freq.put("dir", 23);
    freq.put("dis", 62);
    freq.put("Rez", 9);
    freq.put("ol ", 60);
    freq.put("mân", 113);
    freq.put("M ", 54);
    freq.put(" Yo", 10);
    freq.put(" Ya", 6);
    freq.put("Rep", 21);
    freq.put("Rev", 7);
    freq.put("Ret", 6);
    freq.put("ală", 43);
    freq.put("ngl", 9);
    freq.put("Gre", 15);
    freq.put("dev", 65);
    freq.put("ary", 3);
    freq.put("Gra", 10);
    freq.put("să", 225);
    freq.put("Gro", 6);
    freq.put("Rea", 22);
    freq.put("IN ", 4);
    freq.put("Reg", 7);
    freq.put("Red", 3);
    freq.put("Gri", 5);
    freq.put("ade", 57);
    freq.put("erd", 30);
    freq.put("rul", 220);
    freq.put("tez", 23);
    freq.put("ere", 301);
    freq.put("ara", 311);
    freq.put("Va ", 14);
    freq.put("Târ", 10);
    freq.put("dej", 15);
    freq.put("ciu", 78);
    freq.put("Nu ", 64);
    freq.put("erg", 51);
    freq.put("Que", 3);
    freq.put("lip", 35);
    freq.put("ruc", 26);
    freq.put("bo ", 7);
    freq.put("tăţ", 17);
    freq.put("DS ", 6);
    freq.put("era", 170);
    freq.put("Me", 69);
    freq.put("lem", 37);
    freq.put("Ma", 222);
    freq.put("erb", 21);
    freq.put("arb", 26);
    freq.put("ht ", 4);
    freq.put("Mo", 96);
    freq.put("erc", 68);
    freq.put("Mi", 109);
    freq.put("NA ", 12);
    freq.put("clo", 3);
    freq.put("rug", 10);
    freq.put("Mu", 77);
    freq.put("Iat", 4);
    freq.put("rud", 6);
    freq.put("Re ", 4);
    freq.put("My", 5);
    freq.put(" du", 135);
    freq.put("or ", 450);
    freq.put("lbi", 5);
    freq.put("boy", 3);
    freq.put("EO ", 31);
    freq.put("arc", 78);
    freq.put("Mil", 7);
    freq.put("tni", 4);
    freq.put("eke", 7);
    freq.put("bos", 6);
    freq.put("suc", 12);
    freq.put("rut", 42);
    freq.put(" dr", 62);
    freq.put("jav", 3);
    freq.put("ata", 333);
    freq.put("bol", 4);
    freq.put("bom", 5);
    freq.put("bon", 5);
    freq.put("boo", 26);
    freq.put("sţ", 9);
    freq.put("boa", 7);
    freq.put("PC ", 8);
    freq.put("deg", 5);
    freq.put("poi", 10);
    freq.put("jat", 4);
    freq.put("Lon", 5);
    freq.put("gră", 5);
    freq.put("şii", 3);
    freq.put("ard", 42);
    freq.put("ipa", 41);
    freq.put("Bon", 4);
    freq.put("ipe", 17);
    freq.put("ouă", 21);
    freq.put("jar", 3);
    freq.put("iph", 6);
    freq.put("ipi", 7);
    freq.put("ipo", 8);
    freq.put("ipl", 4);
    freq.put("ngi", 17);
    freq.put("ips", 12);
    freq.put("ipp", 3);
    freq.put("Lig", 13);
    freq.put("afi", 62);
    freq.put("ipt", 5);
    freq.put("ipu", 13);
    freq.put("uzu", 9);
    freq.put("Mot", 10);
    freq.put("rup", 29);
    freq.put("Udr", 8);
    freq.put("îi", 14);
    freq.put(" Ka", 14);
    freq.put("îl", 10);
    freq.put("îm", 25);
    freq.put("în", 462);
    freq.put(" Ke", 6);
    freq.put("Vla", 8);
    freq.put("msu", 6);
    freq.put(" Ki", 6);
    freq.put(" Ko", 8);
    freq.put("ăsă", 5);
    freq.put("mă ", 50);
    freq.put("zza", 6);
    freq.put("rve", 17);
    freq.put("Lim", 4);
    freq.put("Moo", 3);
    freq.put("ul ", 1209);
    freq.put("Bog", 4);
    freq.put("ît", 5);
    freq.put("ree", 33);
    freq.put("arf", 14);
    freq.put("ănă", 4);
    freq.put(" îi", 12);
    freq.put("ood", 13);
    freq.put("ip ", 36);
    freq.put("lţu", 6);
    freq.put("Ben", 10);
    freq.put(" îl", 9);
    freq.put("Bel", 9);
    freq.put("F", 381);
    freq.put(" ăs", 9);
    freq.put("Eva", 5);
    freq.put("ooo", 6);
    freq.put("Bea", 3);
    freq.put("uz ", 4);
    freq.put("Eve", 11);
    freq.put("ook", 31);
    freq.put("ma ", 250);
    freq.put("oot", 4);
    freq.put("diţ", 4);
    freq.put("lis", 52);
    freq.put("oop", 3);
    freq.put("mba", 45);
    freq.put("oor", 7);
    freq.put("Ber", 13);
    freq.put("Bes", 3);
    freq.put("arg", 24);
    freq.put("păş", 3);
    freq.put("ibi", 52);
    freq.put(" K ", 3);
    freq.put("ibl", 6);
    freq.put("neş", 8);
    freq.put("uss", 4);
    freq.put("iba", 8);
    freq.put("ulp", 3);
    freq.put("tma", 3);
    freq.put("flu", 9);
    freq.put("ibe", 23);
    freq.put("ult", 224);
    freq.put(" ie", 45);
    freq.put("fli", 6);
    freq.put("cai", 15);
    freq.put("uli", 32);
    freq.put("sî", 6);
    freq.put("flo", 9);
    freq.put("cal", 133);
    freq.put("fla", 34);
    freq.put("sâ", 8);
    freq.put("ibr", 12);
    freq.put("ula", 75);
    freq.put("fle", 11);
    freq.put("ibu", 5);
    freq.put("Mic", 11);
    freq.put("ule", 47);
    freq.put("ipâ", 4);
    freq.put("ges", 4);
    freq.put(" ol", 5);
    freq.put(" om", 25);
    freq.put("om ", 39);
    freq.put(" ok", 11);
    freq.put("Mio", 6);
    freq.put("ger", 57);
    freq.put(" of", 63);
    freq.put("Rod", 3);
    freq.put(" od", 11);
    freq.put("Lis", 3);
    freq.put(" ob", 38);
    freq.put(" oc", 42);
    freq.put(" oa", 43);
    freq.put("spi", 20);
    freq.put("ter", 278);
    freq.put("spo", 41);
    freq.put("ari", 302);
    freq.put("spa", 48);
    freq.put("Mis", 7);
    freq.put(" ou", 4);
    freq.put(" or", 152);
    freq.put("spe", 71);
    freq.put(" op", 40);
    freq.put("nur", 13);
    freq.put("tăz", 5);
    freq.put("Mă", 9);
    freq.put("dim", 29);
    freq.put("tăt", 5);
    freq.put("get", 20);
    freq.put("tăr", 17);
    freq.put("Whi", 4);
    freq.put("rvi", 51);
    freq.put("Iri", 7);
    freq.put("tăm", 15);
    freq.put("mel", 65);
    freq.put("s ", 770);
    freq.put("oss", 5);
    freq.put("Sfa", 6);
    freq.put("mas", 56);
    freq.put("mar", 153);
    freq.put("mat", 100);
    freq.put("vey", 4);
    freq.put("fed", 3);
    freq.put(" o ", 373);
    freq.put("sni", 5);
    freq.put("mac", 16);
    freq.put("Alţ", 3);
    freq.put("ss ", 22);
    freq.put("aor", 4);
    freq.put("mag", 42);
    freq.put("sp ", 4);
    freq.put("Kin", 3);
    freq.put("în ", 283);
    freq.put("mam", 8);
    freq.put("mal", 22);
    freq.put("Urz", 4);
    freq.put("man", 251);
    freq.put("ght", 6);
    freq.put("sy", 5);
    freq.put("Ros", 5);
    freq.put("Răz", 4);
    freq.put("ss", 50);
    freq.put("Hug", 3);
    freq.put("sp", 390);
    freq.put("gea", 17);
    freq.put("su", 491);
    freq.put("Răs", 5);
    freq.put("q", 11);
    freq.put("ghe", 19);
    freq.put("si", 1096);
    freq.put("sh", 43);
    freq.put("so", 246);
    freq.put("Gră", 3);
    freq.put("sm", 75);
    freq.put("sl", 24);
    freq.put("Răd", 3);
    freq.put("sa", 947);
    freq.put("oad", 25);
    freq.put("sf", 57);
    freq.put("tă ", 170);
    freq.put(" pf", 4);
    freq.put("Ru", 20);
    freq.put("Ziu", 7);
    freq.put("Che", 5);
    freq.put("ăru", 20);
    freq.put("Chi", 24);
    freq.put("îi ", 13);
    freq.put("ttp", 5);
    freq.put("no ", 21);
    freq.put("zaţ", 10);
    freq.put("Jap", 8);
    freq.put("lsi", 3);
    freq.put("ărb", 9);
    freq.put("Re", 128);
    freq.put("iaş", 4);
    freq.put("Cut", 6);
    freq.put("mne", 18);
    freq.put("Ra", 49);
    freq.put("Zia", 3);
    freq.put("Zil", 6);
    freq.put("Ro", 192);
    freq.put("Ri", 8);
    freq.put("tte", 25);
    freq.put("sod", 11);
    freq.put(" aa", 4);
    freq.put(" ab", 30);
    freq.put(" ac", 240);
    freq.put(" ad", 102);
    freq.put(" ae", 9);
    freq.put(" af", 62);
    freq.put(" ag", 13);
    freq.put("jin", 5);
    freq.put(" ai", 171);
    freq.put(" aj", 55);
    freq.put("sof", 11);
    freq.put(" al", 269);
    freq.put(" am", 313);
    freq.put("iaţ", 19);
    freq.put(" ap", 126);
    freq.put("jit", 3);
    freq.put(" as", 243);
    freq.put(" at", 99);
    freq.put(" au", 251);
    freq.put(" av", 99);
    freq.put("ent", 695);
    freq.put(" az", 39);
    freq.put(" pl", 176);
    freq.put("djo", 4);
    freq.put("nol", 4);
    freq.put("nom", 18);
    freq.put("non", 11);
    freq.put("usa", 10);
    freq.put("lă ", 61);
    freq.put("ls ", 16);
    freq.put("ahn", 3);
    freq.put("noa", 31);
    freq.put("aho", 9);
    freq.put("Sha", 5);
    freq.put("ăr ", 7);
    freq.put("aer", 9);
    freq.put("R ", 80);
    freq.put("She", 4);
    freq.put("not", 10);
    freq.put("Shi", 3);
    freq.put("nov", 7);
    freq.put(" us", 19);
    freq.put("nop", 5);
    freq.put("tem", 81);
    freq.put("nor", 46);
    freq.put("Sho", 5);
    freq.put(" a ", 654);
    freq.put("ji ", 3);
    freq.put("pes", 34);
    freq.put("gal", 25);
    freq.put("bes", 21);
    freq.put("sos", 5);
    freq.put("eru", 75);
    freq.put("omo", 39);
    freq.put("Cuc", 3);
    freq.put("Map", 4);
    freq.put("mem", 13);
    freq.put("îşi", 7);
    freq.put("em", 448);
    freq.put("el", 1079);
    freq.put("eo", 119);
    freq.put("en", 1354);
    freq.put("ei", 486);
    freq.put("eh", 31);
    freq.put("ek", 11);
    freq.put("ej", 30);
    freq.put("ee", 152);
    freq.put("ed", 339);
    freq.put("eg", 206);
    freq.put("ef", 112);
    freq.put("ea", 1527);
    freq.put("Afa", 4);
    freq.put("ec", 719);
    freq.put("eb", 179);
    freq.put("ărâ", 4);
    freq.put("Doi", 10);
    freq.put("ey", 28);
    freq.put("ex", 177);
    freq.put("ez", 342);
    freq.put("eu", 283);
    freq.put("et", 622);
    freq.put("ew", 31);
    freq.put("ev", 314);
    freq.put("ră ", 105);
    freq.put("ep", 307);
    freq.put("es", 1258);
    freq.put("er", 1816);
    freq.put("ăde", 11);
    freq.put("Jor", 3);
    freq.put("Ă ", 3);
    freq.put("laj", 8);
    freq.put("blu", 8);
    freq.put("nst", 78);
    freq.put("Dom", 6);
    freq.put("eja", 17);
    freq.put("eC", 3);
    freq.put("ânt", 26);
    freq.put("ădu", 4);
    freq.put("blo", 67);
    freq.put("Joc", 7);
    freq.put("bli", 51);
    freq.put("dif", 22);
    freq.put("os ", 69);
    freq.put("ble", 45);
    freq.put("eju", 5);
    freq.put("Top", 10);
    freq.put("anş", 3);
    freq.put("bla", 13);
    freq.put("laf", 4);
    freq.put("eS", 4);
    freq.put("ând", 49);
    freq.put("mpa", 61);
    freq.put("rlo", 3);
    freq.put("rli", 10);
    freq.put("RT ", 123);
    freq.put("G", 303);
    freq.put("răt", 12);
    freq.put("rău", 3);
    freq.put("ort", 121);
    freq.put("oru", 83);
    freq.put("rla", 13);
    freq.put("e ", 8078);
    freq.put("răr", 7);
    freq.put("răs", 5);
    freq.put("orn", 13);
    freq.put("răm", 10);
    freq.put("răn", 8);
    freq.put("orm", 83);
    freq.put("orj", 5);
    freq.put("răi", 10);
    freq.put("cuţ", 4);
    freq.put("răd", 4);
    freq.put("org", 38);
    freq.put("ord", 54);
    freq.put("ore", 93);
    freq.put("orb", 49);
    freq.put("orc", 19);
    freq.put("răc", 5);
    freq.put("cem", 13);
    freq.put("nec", 21);
    freq.put("ăd ", 5);
    freq.put("fa", 416);
    freq.put("Apr", 5);
    freq.put("osu", 11);
    freq.put("App", 17);
    freq.put("ăl", 26);
    freq.put("ej ", 3);
    freq.put("az ", 14);
    freq.put("cţi", 27);
    freq.put("Apo", 4);
    freq.put("Apl", 3);
    freq.put("ud ", 10);
    freq.put("Apa", 16);
    freq.put(" ce", 478);
    freq.put("lay", 14);
    freq.put("zan", 10);
    freq.put("zam", 9);
    freq.put("onn", 5);
    freq.put("xo", 8);
    freq.put("onl", 45);
    freq.put("nt ", 320);
    freq.put("xc", 22);
    freq.put("xa", 40);
    freq.put("onf", 27);
    freq.put(" Z ", 3);
    freq.put("ond", 60);
    freq.put("xe", 29);
    freq.put("by ", 19);
    freq.put("xx", 8);
    freq.put("xy", 13);
    freq.put("alţ", 3);
    freq.put("Yah", 4);
    freq.put("lau", 18);
    freq.put("zav", 3);
    freq.put("ons", 101);
    freq.put("zat", 58);
    freq.put("zau", 5);
    freq.put("zar", 86);
    freq.put("xt", 24);
    freq.put("Eur", 32);
    freq.put("iam", 14);
    freq.put("IM ", 5);
    freq.put("ian", 108);
    freq.put("€ ", 4);
    freq.put("iaj", 4);
    freq.put("iad", 3);
    freq.put("Pal", 10);
    freq.put("NL ", 4);
    freq.put("Ote", 4);
    freq.put("iac", 11);
    freq.put("iab", 3);
    freq.put("uki", 3);
    freq.put("iaz", 6);
    freq.put("iau", 9);
    freq.put("iat", 97);
    freq.put("Dou", 6);
    freq.put("ias", 16);
    freq.put("iar", 111);
    freq.put(" Zo", 7);
    freq.put(" Zi", 23);
    freq.put("way", 3);
    freq.put("rlu", 3);
    freq.put(" Ze", 8);
    freq.put("hum", 3);
    freq.put(" Zg", 3);
    freq.put("dic", 62);
    freq.put(" Za", 6);
    freq.put("Eu ", 11);
    freq.put("za ", 160);
    freq.put("Leg", 4);
    freq.put("NG ", 7);
    freq.put("hur", 6);
    freq.put("SE ", 8);
    freq.put(" Zu", 4);
    freq.put("rsă", 3);
    freq.put("ke ", 15);
    freq.put("mt ", 11);
    freq.put("tta", 4);
    freq.put("ors", 14);
    freq.put("AT ", 9);
    freq.put("zâ", 3);
    freq.put("Ali", 6);
    freq.put("ia ", 569);
    freq.put("rzi", 24);
    freq.put("ăv", 4);
    freq.put("ără", 21);
    freq.put("r", 12535);
    freq.put("rce", 41);
    freq.put("nie", 68);
    freq.put("Ră", 15);
    freq.put("ehe", 3);
    freq.put("ăt", 95);
    freq.put("Mir", 9);
    freq.put("mov", 16);
    freq.put("ait", 5);
    freq.put("pre", 372);
    freq.put("saj", 15);
    freq.put("sai", 5);
    freq.put("Ale", 14);
    freq.put("pra", 26);
    freq.put("san", 37);
    freq.put("sam", 12);
    freq.put("sal", 46);
    freq.put("sac", 3);
    freq.put("sab", 6);
    freq.put("pro", 248);
    freq.put("ebs", 9);
    freq.put("sag", 3);
    freq.put("ani", 335);
    freq.put("eţ", 62);
    freq.put("ank", 9);
    freq.put("pru", 3);
    freq.put("anu", 152);
    freq.put("niz", 21);
    freq.put("ry ", 17);
    freq.put("ans", 107);
    freq.put("sar", 60);
    freq.put("ang", 48);
    freq.put("sap", 16);
    freq.put("any", 3);
    freq.put("sau", 60);
    freq.put("sat", 64);
    freq.put("cd ", 4);
    freq.put("Do", 62);
    freq.put("Phi", 3);
    freq.put("ă ", 1211);
    freq.put("Pho", 19);
    freq.put("aze", 7);
    freq.put("Di", 67);
    freq.put("vei", 8);
    freq.put("De", 152);
    freq.put("zol", 13);
    freq.put("zon", 41);
    freq.put("Da", 143);
    freq.put("zor", 13);
    freq.put(" ăş", 3);
    freq.put("Mit", 3);
    freq.put("mot", 40);
    freq.put("Du", 33);
    freq.put("Dr", 31);
    freq.put("ts ", 6);
    freq.put("lăc", 10);
    freq.put("Off", 4);
    freq.put("Ofe", 13);
    freq.put("ust", 66);
    freq.put("ştr", 4);
    freq.put("sa ", 602);
    freq.put("şti", 117);
    freq.put("lus", 31);
    freq.put("Ult", 20);
    freq.put("ână", 26);
    freq.put("şta", 3);
    freq.put("şul", 4);
    freq.put("şte", 65);
    freq.put(" Le", 34);
    freq.put("pân", 15);
    freq.put("Lic", 3);
    freq.put("Ucr", 3);
    freq.put(" La", 66);
    freq.put("fer", 131);
    freq.put(" Lo", 22);
    freq.put("aţi", 136);
    freq.put("axy", 7);
    freq.put("slu", 9);
    freq.put(" Li", 73);
    freq.put(" Lu", 33);
    freq.put("axa", 12);
    freq.put("tze", 3);
    freq.put("rse", 23);
    freq.put("rsi", 36);
    freq.put("axi", 10);
    freq.put("luz", 13);
    freq.put(" Ly", 4);
    freq.put(" aş", 34);
    freq.put("Web", 6);
    freq.put("înm", 3);
    freq.put("SI ", 14);
    freq.put("fes", 16);
    freq.put("îni", 3);
    freq.put("zec", 8);
    freq.put("−", 4);
    freq.put("înd", 8);
    freq.put("înc", 48);
    freq.put("îna", 7);
    freq.put("ch ", 26);
    freq.put(" p ", 14);
    freq.put("nli", 56);
    freq.put("înv", 10);
    freq.put("înt", 63);
    freq.put("dy ", 10);
    freq.put("uf", 14);
    freq.put("nlo", 14);
    freq.put("We", 10);
    freq.put("Wa", 9);
    freq.put("lua", 41);
    freq.put("Wo", 6);
    freq.put("stă", 34);
    freq.put("lub", 17);
    freq.put("Wi", 19);
    freq.put("Wh", 7);
    freq.put("tne", 4);
    freq.put("paţ", 6);
    freq.put("păr", 24);
    freq.put("bsc", 6);
    freq.put("lud", 4);
    freq.put("deţ", 13);
    freq.put(" ps", 3);
    freq.put(" pr", 656);
    freq.put("gev", 3);
    freq.put(" pu", 183);
    freq.put(" pt", 24);
    freq.put("H", 128);
    freq.put("sc ", 107);
    freq.put("eun", 5);
    freq.put("oce", 27);
    freq.put(" pa", 268);
    freq.put("AC ", 4);
    freq.put("ssi", 7);
    freq.put("zel", 10);
    freq.put(" pe", 937);
    freq.put("sse", 6);
    freq.put("dit", 46);
    freq.put(" pi", 118);
    freq.put(" ph", 4);
    freq.put(" po", 276);
    freq.put("gen", 48);
    freq.put("gem", 14);
    freq.put("Ş", 25);
    freq.put("azn", 4);
    freq.put("W ", 10);
    freq.put("Lun", 6);
    freq.put("ute", 100);
    freq.put("Tim", 32);
    freq.put("lum", 72);
    freq.put("wh", 3);
    freq.put("ut", 673);
    freq.put(" sî", 5);
    freq.put("ptă", 21);
    freq.put("dih", 3);
    freq.put("cii", 44);
    freq.put("uti", 99);
    freq.put("rmu", 5);
    freq.put("up", 259);
    freq.put("ăut", 6);
    freq.put("lni", 13);
    freq.put("NE ", 10);
    freq.put("uva", 5);
    freq.put("tu ", 63);
    freq.put("cil", 27);
    freq.put("j ", 59);
    freq.put("rmo", 7);
    freq.put("utr", 10);
    freq.put("bio", 4);
    freq.put("cir", 12);
    freq.put("uve", 30);
    freq.put("mim", 10);
    freq.put("cip", 28);
    freq.put("Toa", 7);
    freq.put("civ", 3);
    freq.put("CH ", 3);
    freq.put("tus", 14);
    freq.put("utt", 3);
    freq.put(" Mă", 9);
    freq.put("tup", 4);
    freq.put("ju", 154);
    freq.put("tur", 235);
    freq.put("utu", 47);
    freq.put("tut", 28);
    freq.put("ad ", 47);
    freq.put("jr", 4);
    freq.put("jl", 4);
    freq.put(" pâ", 12);
    freq.put("jn", 5);
    freq.put("jo", 81);
    freq.put("tul", 304);
    freq.put("ji", 13);
    freq.put("tun", 31);
    freq.put("ciz", 8);
    freq.put("jd", 3);
    freq.put("je", 40);
    freq.put("afo", 12);
    freq.put("tud", 25);
    freq.put("ja", 47);
    freq.put("jb", 3);
    freq.put(" be", 53);
    freq.put("z", 1526);
    freq.put(" ba", 159);
    freq.put("oen", 3);
    freq.put("ivă", 4);
    freq.put(" bl", 68);
    freq.put(" bo", 26);
    freq.put(" bi", 96);
    freq.put("job", 21);
    freq.put("alb", 31);
    freq.put("ntă", 19);
    freq.put(" bu", 130);
    freq.put("fiz", 5);
    freq.put("s", 7738);
    freq.put("oft", 7);
    freq.put("odr", 5);
    freq.put(" br", 34);
    freq.put("ali", 210);
    freq.put(" by", 12);
    freq.put("tum", 34);
    freq.put("unu", 65);
    freq.put("sţi", 9);
    freq.put("ăie", 4);
    freq.put("Sir", 6);
    freq.put("pov", 11);
    freq.put("Şte", 3);
    freq.put("pot", 73);
    freq.put("nţa", 40);
    freq.put("por", 99);
    freq.put("ăin", 7);
    freq.put("pop", 10);
    freq.put("pon", 35);
    freq.put("poo", 3);
    freq.put("pol", 44);
    freq.put("pom", 4);
    freq.put("tua", 30);
    freq.put("Lec", 3);
    freq.put("pod", 4);
    freq.put("AI ", 6);
    freq.put("poc", 11);
    freq.put("poa", 60);
    freq.put("Buz", 6);
    freq.put("twe", 15);
    freq.put(" Mâ", 5);
    freq.put("fic", 92);
    freq.put("Bur", 9);
    freq.put("Sit", 14);
    freq.put("But", 5);
    freq.put(" pă", 24);
    freq.put("ei ", 373);
    freq.put("Bun", 18);
    freq.put("Bul", 12);
    freq.put("AS ", 3);
    freq.put("nit", 90);
    freq.put("Buc", 75);
    freq.put("bil", 104);
    freq.put("Bud", 4);
    freq.put("imt", 18);
    freq.put("aie", 35);
    freq.put("mil", 71);
    freq.put("Aer", 4);
    freq.put("Job", 25);
    freq.put("smo", 4);
    freq.put("nou", 114);
    freq.put("ltu", 49);
    freq.put("clu", 28);
    freq.put("po ", 7);
    freq.put("mpe", 20);
    freq.put("ncă", 20);
    freq.put("eiu", 4);
    freq.put("eit", 3);
    freq.put("pti", 23);
    freq.put("eiv", 3);
    freq.put("MR ", 3);
    freq.put("Kad", 3);
    freq.put("eia", 19);
    freq.put("eie", 12);
    freq.put("eii", 3);
    freq.put("oşa", 4);
    freq.put("eim", 3);
    freq.put("eil", 15);
    freq.put("ein", 7);
    freq.put("ive", 97);
    freq.put("iva", 53);
    freq.put(" bă", 22);
    freq.put("Oan", 6);
    freq.put("ivo", 4);
    freq.put("ivi", 43);
    freq.put("oi ", 113);
    freq.put("ivu", 5);
    freq.put("uxe", 4);
    freq.put("SD ", 8);
    freq.put("Oar", 3);
    freq.put("ivr", 8);
    freq.put("Bar", 30);
    freq.put("mod", 35);
    freq.put("Măs", 3);
    freq.put("Bas", 13);
    freq.put(" Me", 68);
    freq.put("par", 260);
    freq.put("pas", 21);
    freq.put("pat", 53);
    freq.put(" Ma", 221);
    freq.put("etc", 5);
    freq.put("chi", 228);
    freq.put(" Mo", 95);
    freq.put("NR ", 11);
    freq.put(" Mi", 109);
    freq.put("neb", 5);
    freq.put(" Mu", 77);
    freq.put("Vra", 3);
    freq.put("pac", 19);
    freq.put("pad", 5);
    freq.put("Vre", 12);
    freq.put("rie", 211);
    freq.put("I ", 127);
    freq.put("Şi ", 6);
    freq.put("Sil", 5);
    freq.put("uj ", 23);
    freq.put(" My", 5);
    freq.put("pan", 101);
    freq.put("jă", 4);
    freq.put("oin", 10);
    freq.put("oil", 13);
    freq.put("iv ", 38);
    freq.put("diu", 39);
    freq.put("şel", 6);
    freq.put("I", 419);
    freq.put("oie", 73);
    freq.put("oid", 14);
    freq.put("oic", 6);
    freq.put("ăpt", 8);
    freq.put("oia", 10);
    freq.put("Mă ", 4);
    freq.put("şez", 3);
    freq.put("Eta", 4);
    freq.put("cei", 26);
    freq.put("ux ", 5);
    freq.put("şes", 5);
    freq.put("oiu", 9);
    freq.put("tuţ", 4);
    freq.put("ois", 5);
    freq.put("Ji", 3);
    freq.put("bso", 7);
    freq.put("Mat", 3);
    freq.put(" M ", 15);
    freq.put("tiz", 14);
    freq.put("Ip", 3);
    freq.put("Is", 10);
    freq.put("Ir", 12);
    freq.put("Iu", 17);
    freq.put("It", 8);
    freq.put("ody", 3);
    freq.put("pa ", 141);
    freq.put("tit", 78);
    freq.put("puş", 5);
    freq.put("uhu", 3);
    freq.put("Im", 17);
    freq.put("Il", 9);
    freq.put("Io", 28);
    freq.put("In", 165);
    freq.put("Ia", 32);
    freq.put("ces", 83);
    freq.put("uie", 58);
    freq.put("Ie", 7);
    freq.put("Id", 4);
    freq.put("Ig", 5);
    freq.put("cer", 128);
    freq.put("nai", 27);
    freq.put("ant", 200);
    freq.put("Loc", 8);
    freq.put("nsc", 8);
    freq.put("tip", 19);
    freq.put("ps ", 6);
    freq.put("vid", 52);
    freq.put("vâ", 15);
    freq.put("gda", 6);
    freq.put("uct", 24);
    freq.put("tir", 67);
    freq.put("uid", 4);
    freq.put("CD ", 4);
    freq.put("tis", 39);
    freq.put("Bal", 9);
    freq.put("cn", 5);
    freq.put("til", 56);
    freq.put("ncţ", 3);
    freq.put(" cî", 3);
    freq.put("Her", 6);
    freq.put("tim", 147);
    freq.put(" câ", 59);
    freq.put("tin", 199);
    freq.put("ndă", 7);
    freq.put("oda", 44);
    freq.put(" ge", 37);
    freq.put("mpl", 67);
    freq.put("My ", 3);
    freq.put("Bai", 13);
    freq.put("RU ", 5);
    freq.put("ami", 61);
    freq.put("psi", 11);
    freq.put("amm", 4);
    freq.put("Mag", 13);
    freq.put("amo", 27);
    freq.put("amn", 34);
    freq.put("ama", 97);
    freq.put("înţ", 5);
    freq.put(" ga", 88);
    freq.put("ame", 159);
    freq.put("taz", 12);
    freq.put("mou", 4);
    freq.put("pos", 44);
    freq.put("Kar", 3);
    freq.put("azo", 6);
    freq.put("rit", 124);
    freq.put("mon", 26);
    freq.put("alv", 11);
    freq.put("gro", 11);
    freq.put("moc", 6);
    freq.put("amp", 49);
    freq.put("ams", 8);
    freq.put("amu", 28);
    freq.put("tif", 12);
    freq.put("amv", 4);
    freq.put("nsf", 18);
    freq.put("tig", 48);
    freq.put("ce ", 452);
    freq.put("Pia", 15);
    freq.put("Nă", 4);
    freq.put("Pie", 6);
    freq.put("tia", 106);
    freq.put("uru", 18);
    freq.put("t", 12379);
    freq.put("lic", 104);
    freq.put("gri", 13);
    freq.put("Pit", 10);
    freq.put("ătu", 12);
    freq.put("aţ", 186);
    freq.put("ătr", 13);
    freq.put("ezu", 23);
    freq.put("ezv", 15);
    freq.put("td ", 3);
    freq.put("obu", 24);
    freq.put("Nea", 17);
    freq.put("omp", 66);
    freq.put("cs", 17);
    freq.put("ptu", 10);
    freq.put("ezo", 31);
    freq.put("ezi", 108);
    freq.put("Nex", 3);
    freq.put("Zgo", 3);
    freq.put("Nev", 3);
    freq.put("eze", 80);
    freq.put("Net", 3);
    freq.put("ăto", 26);
    freq.put("eza", 20);
    freq.put("ezb", 5);
    freq.put("mus", 15);
    freq.put("Med", 20);
    freq.put(" ch", 64);
    freq.put(" ci", 136);
    freq.put("ock", 13);
    freq.put(" co", 468);
    freq.put(" cl", 45);
    freq.put(" cm", 3);
    freq.put("Mem", 3);
    freq.put(" cc", 25);
    freq.put(" ca", 969);
    freq.put("Hol", 4);
    freq.put("o ", 748);
    freq.put("Ion", 11);
    freq.put("lov", 16);
    freq.put("na ", 378);
    freq.put("uci", 19);
    freq.put("Mes", 7);
    freq.put("Mer", 9);
    freq.put(" cr", 126);
    freq.put("dda", 5);
    freq.put("uch", 14);
    freq.put("Ioa", 13);
    freq.put(" cu", 718);
    freq.put("one", 82);
    freq.put("Juc", 7);
    freq.put("dee", 8);
    freq.put("mpi", 25);
    freq.put("zit", 63);
    freq.put("Dru", 4);
    freq.put("Ne ", 8);
    freq.put("Dri", 8);
    freq.put("igă", 14);
    freq.put("acc", 23);
    freq.put("uTu", 4);
    freq.put("Dra", 15);
    freq.put("nmo", 3);
    freq.put("oro", 23);
    freq.put("oS", 3);
    freq.put("tv ", 9);
    freq.put("nje", 8);
    freq.put("oo", 111);
    freq.put("on", 985);
    freq.put("om", 609);
    freq.put("ol", 482);
    freq.put("ok", 68);
    freq.put("oj", 9);
    freq.put("oi", 266);
    freq.put("km ", 11);
    freq.put("og", 191);
    freq.put("of", 124);
    freq.put("oe", 15);
    freq.put("od", 206);
    freq.put("oc", 446);
    freq.put("ob", 198);
    freq.put("oa", 748);
    freq.put("acs", 3);
    freq.put("acr", 9);
    freq.put("oz", 81);
    freq.put("oy", 10);
    freq.put("ox", 16);
    freq.put("ow", 52);
    freq.put("ov", 159);
    freq.put("ou", 275);
    freq.put("ot", 396);
    freq.put("os", 456);
    freq.put("or", 1526);
    freq.put("nz ", 8);
    freq.put("op", 297);
    freq.put("LE ", 14);
    freq.put("Ni", 34);
    freq.put("Adr", 13);
    freq.put("nan", 16);
    freq.put("No", 68);
    freq.put("uil", 5);
    freq.put("Na", 48);
    freq.put("Roş", 8);
    freq.put("lil", 5);
    freq.put("Ne", 68);
    freq.put("ngh", 13);
    freq.put("tza", 3);
    freq.put("Ade", 7);
    freq.put("Ada", 3);
    freq.put("Adm", 3);
    freq.put("Nu", 75);
    freq.put("Adi", 8);
    freq.put("het", 24);
    freq.put("loc", 145);
    freq.put("loa", 44);
    freq.put("ehr", 3);
    freq.put("ată", 65);
    freq.put("her", 28);
    freq.put("hes", 12);
    freq.put("ni ", 264);
    freq.put("lli", 9);
    freq.put("EL ", 3);
    freq.put("loi", 7);
    freq.put("lon", 30);
    freq.put("Gea", 3);
    freq.put("hez", 9);
    freq.put("lom", 8);
    freq.put("hed", 3);
    freq.put("hee", 3);
    freq.put("lop", 5);
    freq.put("pţi", 6);
    freq.put("fir", 25);
    freq.put("hea", 10);
    freq.put("lot", 8);
    freq.put("lou", 12);
    freq.put("hel", 5);
    freq.put("eho", 6);
    freq.put("hen", 8);
    freq.put("heo", 10);
    freq.put("hei", 18);
    freq.put("ehi", 6);
    freq.put("juc", 24);
    freq.put("nkf", 5);
    freq.put("sid", 6);
    freq.put("jud", 14);
    freq.put("agn", 5);
    freq.put("N ", 71);
    freq.put("J", 120);
    freq.put("jun", 40);
    freq.put("UE ", 8);
    freq.put("jul", 19);
    freq.put("jum", 13);
    freq.put("jur", 17);
    freq.put("jus", 3);
    freq.put("olă", 3);
    freq.put("jut", 20);
    freq.put("şia", 7);
    freq.put("Vam", 8);
    freq.put("e", 20478);
    freq.put("Muz", 9);
    freq.put("mpr", 17);
    freq.put("asl", 6);
    freq.put("lo ", 28);
    freq.put("nţe", 22);
    freq.put("agi", 58);
    freq.put("eşt", 89);
    freq.put("lca", 5);
    freq.put("Piţ", 4);
    freq.put("nfo", 30);
    freq.put("dve", 4);
    freq.put("as ", 57);
    freq.put("he ", 37);
    freq.put("Avi", 3);
    freq.put("eh ", 4);
    freq.put("Ave", 3);
    freq.put("eşi", 7);
    freq.put("le ", 839);
    freq.put("Ava", 3);
    freq.put("aa", 41);
    freq.put("oth", 3);
    freq.put("ac", 961);
    freq.put("ab", 185);
    freq.put("ae", 28);
    freq.put("ad", 357);
    freq.put("ag", 227);
    freq.put("af", 167);
    freq.put("S", 888);
    freq.put("ah", 46);
    freq.put("ak", 24);
    freq.put("aj", 146);
    freq.put("am", 911);
    freq.put("al", 1361);
    freq.put("ao", 14);
    freq.put("an", 1878);
    freq.put("ap", 363);
    freq.put("as", 901);
    freq.put("ar", 2682);
    freq.put("au", 589);
    freq.put("at", 2342);
    freq.put("aw", 4);
    freq.put("av", 187);
    freq.put("ay", 41);
    freq.put("ax", 36);
    freq.put("az", 331);
    freq.put("uis", 3);
    freq.put("sii", 20);
    freq.put("yon", 4);
    freq.put("igu", 37);
    freq.put("aB", 3);
    freq.put("igr", 3);
    freq.put("Gig", 9);
    freq.put("Ma ", 14);
    freq.put("Mui", 3);
    freq.put("ngă", 5);
    freq.put("oul", 46);
    freq.put("SS ", 3);
    freq.put("noi", 61);
    freq.put("ige", 10);
    freq.put("iga", 59);
    freq.put("ota", 17);
    freq.put("igo", 8);
    freq.put("ign", 8);
    freq.put("you", 3);
    freq.put("Ovi", 5);
    freq.put("otb", 24);
    freq.put("igi", 31);
    freq.put("igh", 6);
    freq.put("ânz", 7);
    freq.put("a ", 7341);
    freq.put("lga", 9);
    freq.put("şă", 3);
    freq.put("ru", 896);
    freq.put(" că", 123);
    freq.put("sia", 22);
    freq.put("oh ", 3);
    freq.put(" zo", 16);
    freq.put("lod", 14);
    freq.put("ote", 55);
    freq.put("oş", 24);
    freq.put("DL ", 15);
    freq.put(" zi", 152);
    freq.put("pil", 17);
    freq.put("ş", 737);
    freq.put("acţ", 10);
    freq.put("tlu", 4);
    freq.put("max", 7);
    freq.put("at ", 744);
    freq.put("uv ", 3);
    freq.put("Bru", 3);
    freq.put("liţ", 21);
    freq.put("oţ", 36);
    freq.put("Bro", 5);
    freq.put("pei", 14);
    freq.put("ăne", 7);
    freq.put("u", 11137);
    freq.put(" − ", 4);
    freq.put("Bri", 11);
    freq.put("ig ", 7);
    freq.put("uit", 103);
    freq.put("Met", 13);
    freq.put("Bre", 10);
    freq.put("smu", 11);
    freq.put("Bra", 24);
    freq.put("eză", 4);
    freq.put("Fir", 7);
    freq.put("viţ", 5);
    freq.put("sco", 72);
    freq.put("Pic", 4);
    freq.put("Van", 31);
    freq.put("sch", 55);
    freq.put("Fit", 5);
    freq.put("Fiu", 4);
    freq.put("sce", 15);
    freq.put("iu ", 183);
    freq.put("pte", 64);
    freq.put("ale", 212);
    freq.put(" dă", 18);
    freq.put("gu", 195);
    freq.put("Vad", 3);
    freq.put("uno", 27);
    freq.put("mni", 11);
    freq.put("gt", 3);
    freq.put("ndu", 51);
    freq.put("rz", 26);
    freq.put("Fie", 3);
    freq.put("Var", 6);
    freq.put("gs", 4);
    freq.put("fa ", 13);
    freq.put("alu", 104);
    freq.put("Fin", 9);
    freq.put("als", 6);
    freq.put("Fil", 10);
    freq.put("gr", 202);
    freq.put("ws ", 17);
    freq.put("tz", 16);
    freq.put("ty", 20);
    freq.put("tv", 9);
    freq.put(" N ", 13);
    freq.put("tt", 44);
    freq.put("tu", 821);
    freq.put("tr", 1304);
    freq.put("ts", 22);
    freq.put("tp", 13);
    freq.put("zme", 4);
    freq.put("tn", 10);
    freq.put("to", 774);
    freq.put("tl", 13);
    freq.put("tm", 10);
    freq.put("th", 36);
    freq.put("ti", 2106);
    freq.put("Să", 16);
    freq.put("teg", 13);
    freq.put("td", 8);
    freq.put("te", 2344);
    freq.put("tb", 30);
    freq.put("câş", 13);
    freq.put("ta", 2036);
    freq.put("faz", 9);
    freq.put("edi", 152);
    freq.put("ium", 5);
    freq.put("iul", 93);
    freq.put("iun", 109);
    freq.put("iua", 29);
    freq.put("fas", 5);
    freq.put("iuc", 8);
    freq.put("iub", 16);
    freq.put("iud", 6);
    freq.put("fat", 29);
    freq.put("edo", 9);
    freq.put("nţi", 36);
    freq.put("Fi ", 7);
    freq.put("fai", 4);
    freq.put("fan", 26);
    freq.put("gy", 3);
    freq.put("fal", 11);
    freq.put(" râ", 6);
    freq.put("fab", 7);
    freq.put("fac", 216);
    freq.put("ius", 16);
    freq.put("iur", 22);
    freq.put("uze", 18);
    freq.put("iut", 7);
    freq.put("mbu", 10);
    freq.put(" Ni", 34);
    freq.put("gg", 14);
    freq.put("and", 244);
    freq.put("ro", 842);
    freq.put("wse", 3);
    freq.put(" No", 68);
    freq.put(" Na", 48);
    freq.put(" Ne", 65);
    freq.put("ge", 255);
    freq.put("aje", 21);
    freq.put("gd", 6);
    freq.put("rj", 6);
    freq.put("AN ", 7);
    freq.put("llo", 16);
    freq.put("rk", 18);
    freq.put(" Nu", 75);
    freq.put("rbu", 8);
    freq.put("t ", 2373);
    freq.put("gb", 8);
    freq.put("teh", 6);
    freq.put("tei", 28);
    freq.put("Ist", 5);
    freq.put("îng", 7);
    freq.put("văd", 5);
    freq.put(" Ră", 15);
    freq.put("În", 38);
    freq.put("teo", 11);
    freq.put("tea", 213);
    freq.put("edu", 19);
    freq.put("ted", 7);
    freq.put("tee", 3);
    freq.put("tef", 7);
    freq.put("Ani", 8);
    freq.put("Smo", 3);
    freq.put("go", 91);
    freq.put("văr", 9);
    freq.put("asp", 29);
    freq.put("îns", 10);
    freq.put("egă", 8);
    freq.put("mmy", 3);
    freq.put("văz", 7);
    freq.put("tes", 73);
    freq.put("tet", 24);
    freq.put("gm", 9);
    freq.put("tev", 32);
    freq.put("Unu", 3);
    freq.put("sug", 4);
    freq.put("rbo", 8);
    freq.put(" în", 437);
    freq.put("gl", 40);
    freq.put("rma", 120);
    freq.put("sub", 43);
    freq.put("rot", 29);
    freq.put("sum", 9);
    freq.put("sul", 73);
    freq.put("abl", 25);
    freq.put("abo", 15);
    freq.put("tî", 3);
    freq.put("abr", 14);
    freq.put("fă", 29);
    freq.put("ică", 60);
    freq.put("r ", 1279);
    freq.put("sup", 48);
    freq.put("aby", 4);
    freq.put("osf", 4);
    freq.put("tâ", 16);
    freq.put("ag ", 14);
    freq.put("vă ", 24);
    freq.put(" rt", 4);
    freq.put("ntr", 600);
    freq.put("nam", 22);
    freq.put("te ", 1112);
    freq.put("K", 43);
    freq.put("smi", 14);
    freq.put("vet", 23);
    freq.put("tex", 5);
    freq.put(" re", 362);
    freq.put("îl ", 10);
    freq.put("gu ", 16);
    freq.put(" ra", 102);
    freq.put("pub", 35);
    freq.put("usţ", 9);
    freq.put(" ro", 168);
    freq.put("puc", 7);
    freq.put(" ri", 28);
    freq.put("Noi", 6);
    freq.put("ab ", 7);
    freq.put("asc", 64);
    freq.put("Mi ", 13);
    freq.put("cve", 4);
    freq.put("lcu", 11);
    freq.put("su ", 14);
    freq.put("oma", 156);
    freq.put("Nok", 11);
    freq.put("asa", 164);
    freq.put(" Tâ", 10);
    freq.put("sti", 431);
    freq.put("ev ", 5);
    freq.put("sig", 34);
    freq.put("tr ", 71);
    freq.put("ana", 168);
    freq.put("Und", 3);
    freq.put("omâ", 86);
    freq.put("VA ", 6);
    freq.put("Une", 5);
    freq.put("vic", 54);
    freq.put("via", 125);
    freq.put("Rai", 3);
    freq.put("zic", 68);
    freq.put("Aug", 5);
    freq.put("vie", 8);
    freq.put("Tor", 4);
    freq.put("vik", 3);
    freq.put(" Nă", 4);
    freq.put("câi", 7);
    freq.put("cân", 28);
    freq.put("vio", 17);
    freq.put("vil", 13);
    freq.put("Tou", 4);
    freq.put("vir", 10);
    freq.put("vis", 29);
    freq.put("Aus", 4);
    freq.put("Aur", 6);
    freq.put("Aut", 17);
    freq.put("cât", 26);
    freq.put("viu", 15);
    freq.put("viz", 39);
    freq.put("S ", 83);
    freq.put("rme", 37);
    freq.put(" s ", 95);
    freq.put("ve", 551);
    freq.put("ear", 52);
    freq.put("ash", 6);
    freq.put("mpă", 8);
    freq.put("veg", 10);
    freq.put("aso", 21);
    freq.put("New", 18);
    freq.put("twi", 17);
    freq.put("rub", 3);
    freq.put("Dav", 13);
    freq.put(" d ", 18);
    freq.put("Ple", 5);
    freq.put("leg", 75);
    freq.put("ăzi", 12);
    freq.put("anc", 106);
    freq.put("asm", 5);
    freq.put("VE ", 6);
    freq.put("vi", 600);
    freq.put("de ", 1725);
    freq.put("nţă", 26);
    freq.put("In ", 36);
    freq.put("FM ", 3);
    freq.put("ziţ", 8);
    freq.put("iz ", 5);
    freq.put("vi ", 19);
    freq.put("şe ", 4);
    freq.put("şef", 7);
    freq.put("jr ", 4);
    freq.put("mu ", 8);
    freq.put("Sp", 70);
    freq.put("Sw", 3);
    freq.put("Su", 71);
    freq.put("St", 177);
    freq.put("Sk", 5);
    freq.put("ven", 100);
    freq.put("Si", 96);
    freq.put("Sh", 17);
    freq.put("So", 43);
    freq.put("Sm", 4);
    freq.put("Sl", 8);
    freq.put("Sc", 33);
    freq.put("faţ", 20);
    freq.put("Sa", 86);
    freq.put("umn", 8);
    freq.put("sân", 4);
    freq.put("Sf", 9);
    freq.put("Se", 114);
    freq.put(" do", 209);
    freq.put("ey ", 18);
    freq.put("dez", 27);
    freq.put(" di", 609);
    freq.put("Int", 42);
    freq.put("aba", 24);
    freq.put("Inv", 11);
    freq.put("des", 172);
    freq.put(" dc", 4);
    freq.put("kli", 3);
    freq.put(" da", 333);
    freq.put("Ins", 10);
    freq.put("bur", 34);
    freq.put("dei", 12);
    freq.put("Inn", 5);
    freq.put("avo", 14);
    freq.put("del", 47);
    freq.put("dem", 33);
    freq.put("den", 56);
    freq.put("v", 2327);
    freq.put("Ind", 11);
    freq.put("dea", 47);
    freq.put("Inf", 6);
    freq.put("Ing", 7);
    freq.put("ded", 12);
    freq.put("Ina", 4);
    freq.put("def", 6);
    freq.put("Inc", 30);
    freq.put("oo ", 14);
    freq.put("văţ", 3);
    freq.put("upl", 11);
    freq.put("Azi", 15);
    freq.put("Vin", 12);
    freq.put("teţ", 7);
    freq.put("exc", 21);
    freq.put("Vio", 5);
    freq.put("f ", 61);
    freq.put("rmi", 32);
    freq.put("Vil", 3);
    freq.put("mîn", 6);
    freq.put("pai", 23);
    freq.put("ati", 373);
    freq.put("Mos", 3);
    freq.put("ob ", 16);
    freq.put("low", 16);
    freq.put("iPa", 8);
    freq.put("mva", 8);
    freq.put("iPh", 14);
    freq.put(" ţa", 6);
    freq.put("att", 3);
    freq.put(" Fl", 18);
    freq.put("WC ", 3);
    freq.put("anz", 46);
    freq.put(" ră", 31);
    freq.put("teş", 11);
    freq.put("opt", 19);
    freq.put("Viv", 5);
    freq.put("eg ", 15);
    freq.put("âmb", 7);
    freq.put("fr", 109);
    freq.put("fs", 4);
    freq.put("ft", 38);
    freq.put("fu", 93);
    freq.put("Ubu", 3);
    freq.put("our", 15);
    freq.put("ăsa", 4);
    freq.put("lac", 62);
    freq.put("Doa", 13);
    freq.put("Cin", 26);
    freq.put("lan", 109);
    freq.put("isc", 44);
    freq.put("âmp", 3);
    freq.put("ută", 13);
    freq.put("fe", 285);
    freq.put("ff", 21);
    freq.put("Dor", 11);
    freq.put("fi", 442);
    freq.put("fl", 79);
    freq.put("Dow", 3);
    freq.put("fo", 352);
    freq.put("a", 22734);
    freq.put("bar", 41);
    freq.put("lăt", 9);
    freq.put("niş", 10);
    freq.put(" Îm", 6);
    freq.put("lăs", 5);
    freq.put("poz", 49);
    freq.put(" În", 38);
    freq.put("IB ", 3);
    freq.put("egr", 9);
    freq.put("cs ", 8);
    freq.put("egu", 21);
    freq.put("ne ", 579);
    freq.put("egi", 35);
    freq.put("egh", 5);
    freq.put("ego", 11);
    freq.put("ds ", 7);
    freq.put("egm", 4);
    freq.put("apă", 8);
    freq.put("ega", 59);
    freq.put("CA ", 18);
    freq.put("ege", 37);
    freq.put("bas", 12);
    freq.put("itn", 4);
    freq.put("ito", 68);
    freq.put("itl", 3);
    freq.put("iti", 177);
    freq.put("y ", 188);
    freq.put("ite", 173);
    freq.put("itc", 3);
    freq.put("ita", 353);
    freq.put("uvi", 9);
    freq.put(" eş", 14);
    freq.put("itz", 6);
    freq.put("ffi", 8);
    freq.put("ity", 8);
    freq.put(" sâ", 8);
    freq.put("fff", 3);
    freq.put("itt", 22);
    freq.put("itu", 69);
    freq.put("itr", 16);
    freq.put("its", 3);
    freq.put("SF ", 4);
    freq.put(" On", 18);
    freq.put(" Ol", 10);
    freq.put(" Om", 6);
    freq.put("UR ", 6);
    freq.put(" Ok", 3);
    freq.put(" Oh", 3);
    freq.put(" Of", 26);
    freq.put("şan", 7);
    freq.put(" Ob", 16);
    freq.put(" Oc", 13);
    freq.put(" Oa", 11);
    freq.put("nto", 26);
    freq.put("usp", 5);
    freq.put("luţ", 7);
    freq.put("if ", 5);
    freq.put("Mon", 28);
    freq.put("MW ", 6);
    freq.put(" Ov", 6);
    freq.put("oar", 287);
    freq.put(" Ot", 5);
    freq.put("ţa ", 60);
    freq.put(" Or", 22);
    freq.put(" Op", 18);
    freq.put("dil", 5);
    freq.put("Bat", 4);
    freq.put("ced", 14);
    freq.put("ym", 6);
    freq.put("yl", 14);
    freq.put("yo", 8);
    freq.put("yn", 8);
    freq.put("ya", 7);
    freq.put("cen", 63);
    freq.put("yc", 4);
    freq.put("cel", 137);
    freq.put("ye", 4);
    freq.put("L", 276);
    freq.put("it ", 281);
    freq.put("Cla", 8);
    freq.put("cev", 37);
    freq.put("ceu", 6);
    freq.put("cet", 28);
    freq.put("Bab", 7);
    freq.put("Bac", 25);
    freq.put("cep", 68);
    freq.put("Ban", 20);
    freq.put("yp", 3);
    freq.put("ys", 13);
    freq.put("yr", 3);
    freq.put("yu", 5);
    freq.put("cez", 13);
    freq.put("ow ", 23);
    freq.put("ff ", 8);
    freq.put("ift", 8);
    freq.put("ifu", 9);
    freq.put("Rad", 16);
    freq.put("Ţ", 8);
    freq.put("mah", 3);
    freq.put("Tar", 14);
    freq.put("ţar", 8);
    freq.put("Ral", 5);
    freq.put("opr", 20);
    freq.put(" O ", 52);
    freq.put("ţat", 11);
    freq.put("jă ", 3);
    freq.put("ife", 24);
    freq.put("Ras", 3);
    freq.put("Rap", 8);
    freq.put("dak", 3);
    freq.put("ifo", 8);
    freq.put("Raz", 4);
    freq.put("ifi", 44);
    freq.put(" A ", 47);
    freq.put("Mut", 3);
    freq.put("dig", 7);
    freq.put("End", 3);
    freq.put("Ene", 9);
    freq.put("Mus", 5);
    freq.put("Mur", 17);
    freq.put("AF ", 3);
    freq.put("No ", 4);
    freq.put(" sp", 179);
    freq.put("pu ", 12);
    freq.put("eţe", 15);
    freq.put(" st", 242);
    freq.put(" su", 327);
    freq.put("Un ", 59);
    freq.put(" sh", 12);
    freq.put(" si", 652);
    freq.put("Mua", 3);
    freq.put(" so", 90);
    freq.put(" sl", 11);
    freq.put(" sm", 13);
    freq.put(" sc", 167);
    freq.put("uvâ", 3);
    freq.put(" sa", 582);
    freq.put(" sf", 26);
    freq.put("ţă ", 53);
    freq.put(" se", 454);
    freq.put("uşc", 5);
    freq.put("iza", 100);
    freq.put("ftu", 4);
    freq.put("ize", 35);
    freq.put("uşe", 4);
    freq.put("gur", 75);
    freq.put("izi", 55);
    freq.put("uşi", 9);
    freq.put("E ", 185);
    freq.put("izo", 14);
    freq.put("NS ", 3);
    freq.put("izu", 12);
    freq.put("Omu", 4);
    freq.put("ate", 444);
    freq.put("fti", 16);
    freq.put("izz", 6);
    freq.put("Mar", 85);
    freq.put("pul", 67);
    freq.put(" el", 75);
    freq.put(" Ab", 3);
    freq.put(" Ac", 55);
    freq.put(" Ad", 40);
    freq.put(" Ae", 4);
    freq.put(" Af", 14);
    freq.put(" Ag", 12);
    freq.put(" Ah", 4);
    freq.put(" Ai", 17);
    freq.put(" Al", 60);
    freq.put(" Am", 66);
    freq.put(" An", 112);
    freq.put("tât", 4);
    freq.put(" Ap", 48);
    freq.put("Una", 3);
    freq.put(" Ar", 58);
    freq.put(" As", 44);
    freq.put(" At", 21);
    freq.put(" Au", 44);
    freq.put(" Av", 11);
    freq.put("Ung", 6);
    freq.put("put", 100);
    freq.put("Uni", 24);
    freq.put(" Az", 16);
    freq.put("şed", 19);
    freq.put("pup", 4);
    freq.put("div", 9);
    freq.put("pur", 20);
    freq.put("pus", 49);
    freq.put("Em", 21);
    freq.put("El", 26);
    freq.put("En", 15);
    freq.put("Ei", 3);
    freq.put("La ", 43);
    freq.put(" şt", 21);
    freq.put("Ed", 7);
    freq.put("lug", 6);
    freq.put("but", 10);
    freq.put("eţu", 7);
    freq.put("Ec", 12);
    freq.put("Tai", 4);
    freq.put("nfi", 13);
    freq.put("ft ", 12);
    freq.put("luă", 3);
    freq.put("Ex", 22);
    freq.put("w", 241);
    freq.put("HD ", 5);
    freq.put("Eu", 44);
    freq.put("Et", 8);
    freq.put("Mel", 6);
    freq.put("Ev", 24);
    freq.put("Ep", 11);
    freq.put("Es", 15);
    freq.put("Er", 8);
    freq.put("Ima", 6);
    freq.put("rro", 4);
    freq.put("Fra", 26);
    freq.put("Clo", 5);
    freq.put("Cli", 8);
    freq.put("Fre", 3);
    freq.put("uel", 6);
    freq.put("Imi", 6);
    freq.put("Cle", 4);
    freq.put("Să ", 6);
    freq.put("Imo", 3);
    freq.put(" ea", 7);
    freq.put("uen", 4);
    freq.put("bul", 20);
    freq.put("tot", 67);
    freq.put("Fru", 3);
    freq.put("aş ", 13);
    freq.put("nc ", 4);
    freq.put("Clu", 38);
    freq.put("tou", 5);
    freq.put("osc", 22);
    freq.put("Of ", 3);
    freq.put("mâi", 7);
    freq.put("jer", 5);
    freq.put(" em", 23);
    freq.put(" en", 18);
    freq.put("obţ", 3);
    freq.put("st ", 245);
    freq.put(" ei", 25);
    freq.put("ase", 109);
    freq.put(" ed", 19);
    freq.put(" ee", 4);
    freq.put("X ", 27);
    freq.put(" eg", 11);
    freq.put("anţ", 25);
    freq.put(" Oţ", 3);
    freq.put(" ec", 41);
    freq.put("Blu", 3);
    freq.put("jea", 7);
    freq.put(" ex", 107);
    freq.put("Res", 12);
    freq.put(" et", 18);
    freq.put(" eu", 152);
    freq.put(" ev", 27);
    freq.put("jen", 4);
    freq.put("rre", 3);
    freq.put("jel", 5);
    freq.put(" es", 160);
    freq.put("omu", 21);
    freq.put("aşu", 5);
    freq.put("Săn", 4);
    freq.put("ceţ", 3);
    freq.put("vag", 4);
    freq.put("împ", 14);
    freq.put("tfe", 7);
    freq.put("ncr", 6);
    freq.put("tom", 33);
    freq.put("nct", 21);
    freq.put("ncu", 49);
    freq.put("odu", 51);
    freq.put("nch", 61);
    freq.put("nci", 82);
    freq.put("aşe", 6);
    freq.put("ncl", 13);
    freq.put("rra", 8);
    freq.put("aşa", 15);
    freq.put("nco", 12);
    freq.put("aşo", 8);
    freq.put("nca", 111);
    freq.put("Sla", 7);
    freq.put("aşi", 28);
    freq.put("îmi", 8);
    freq.put("ste", 410);
    freq.put("b", 1922);
    freq.put("aaa", 20);
    freq.put("sta", 362);
    freq.put("stl", 3);
    freq.put(" ep", 14);
    freq.put("sto", 41);
    freq.put(" e ", 217);
    freq.put("ită", 43);
    freq.put("abă", 11);
    freq.put("tog", 24);
    freq.put("Nun", 4);
    freq.put("i", 19648);
    freq.put("je ", 14);
    freq.put("htt", 6);
    freq.put(" er", 47);
    freq.put("str", 192);
    freq.put("uju", 3);
    freq.put("fec", 23);
    freq.put("ârt", 3);
    freq.put("sty", 4);
    freq.put("spr", 112);
    freq.put("Mac", 7);
    freq.put("Gol", 3);
    freq.put("Goo", 14);
    freq.put("ka ", 8);
    freq.put("rry", 7);
    freq.put("OT ", 6);
    freq.put("God", 3);
    freq.put("Rem", 5);
    freq.put("imă", 13);
    freq.put("ofo", 4);
    freq.put("Reb", 6);
    freq.put("aşt", 20);
    freq.put("− ", 4);
    freq.put("lfo", 6);
    freq.put("Rec", 13);
    freq.put(" lc", 4);
    freq.put("rel", 78);
    freq.put("Gos", 4);
    freq.put("Gor", 3);
    freq.put("lid", 6);
    freq.put("lie", 54);
    freq.put("lif", 10);
    freq.put("k ", 114);
    freq.put("lia", 59);
    freq.put("ex ", 17);
    freq.put("tp ", 6);
    freq.put("ăşi", 4);
    freq.put("Bla", 9);
    freq.put("lin", 139);
    freq.put("lio", 33);
    freq.put("eft", 15);
    freq.put("efu", 6);
    freq.put("ode", 34);
    freq.put("asă", 19);
    freq.put("efi", 18);
    freq.put("liv", 15);
    freq.put("efl", 4);
    freq.put("ăşt", 3);
    freq.put("lir", 4);
    freq.put("Aş ", 4);
    freq.put("cci", 21);
    freq.put("efe", 22);
    freq.put("liz", 67);
    freq.put("uji", 4);
    freq.put("rin", 187);
    freq.put("bab", 11);
    freq.put("iză", 12);
    freq.put(" fi", 250);
    freq.put("Ata", 8);
    freq.put("nib", 13);
    freq.put("Ţo", 4);
    freq.put("M", 674);
    freq.put("puţ", 14);
    freq.put("rhi", 10);
    freq.put("kar", 3);
    freq.put("uje", 3);
    freq.put("spu", 83);
    freq.put("The", 8);
    freq.put("rhe", 4);
    freq.put("Tha", 3);
    freq.put("bac", 16);
    freq.put("ka", 17);
    freq.put("â", 351);
    freq.put("kg", 5);
    freq.put("kf", 5);
    freq.put("ke", 56);
    freq.put("Zee", 4);
    freq.put(" vâ", 12);
    freq.put("ki", 46);
    freq.put("kh", 4);
    freq.put("ko", 5);
    freq.put("kn", 4);
    freq.put("km", 11);
    freq.put("kl", 5);
    freq.put("ks", 8);
    freq.put("ext", 20);
    freq.put("exu", 14);
    freq.put("ujb", 3);
    freq.put("Aşa", 3);
    freq.put("ef ", 6);
    freq.put(" să", 177);
    freq.put("ky", 6);
    freq.put("aln", 13);
    freq.put("une", 176);
    freq.put("RM ", 5);
    freq.put(" Aş", 9);
    freq.put("rte", 122);
    freq.put("Hai", 10);
    freq.put("ugi", 7);
    freq.put("ugh", 3);
    freq.put("ugo", 4);
    freq.put("Han", 3);
    freq.put("ugb", 7);
    freq.put("uga", 12);
    freq.put("rti", 115);
    freq.put("rth", 5);
    freq.put("uge", 13);
    freq.put("hi ", 30);
    freq.put("rtp", 5);
    freq.put("rts", 7);
    freq.put("Har", 5);
    freq.put("ugu", 26);
    freq.put("săm", 4);
    freq.put("iez", 12);
    freq.put("Ju", 41);
    freq.put("ies", 54);
    freq.put("ier", 148);
    freq.put("iet", 40);
    freq.put("iew", 5);
    freq.put("iev", 3);
    freq.put("iei", 95);
    freq.put("pţ", 6);
    freq.put("Jo", 47);
    freq.put("iem", 10);
    freq.put("iel", 18);
    freq.put("ien", 55);
    freq.put("Je", 8);
    freq.put("iec", 65);
    freq.put(" tă", 3);
    freq.put("Ja", 11);
    freq.put("ief", 16);
    freq.put("hip", 31);
    freq.put("hir", 25);
    freq.put("his", 22);
    freq.put("hit", 17);
    freq.put("hiu", 3);
    freq.put("hiv", 5);
    freq.put("ose", 16);
    freq.put("hiz", 12);
    freq.put("arm", 26);
    freq.put("dmi", 10);
    freq.put("hia", 50);
    freq.put("hic", 7);
    freq.put("hid", 19);
    freq.put("hie", 7);
    freq.put("hih", 3);
    freq.put("hii", 17);
    freq.put("găr", 5);
    freq.put("hil", 20);
    freq.put("him", 35);
    freq.put("hin", 31);
    freq.put("hio", 3);
    freq.put("gaş", 3);
    freq.put("ã", 4);
    freq.put("rfu", 7);
    freq.put("cru", 22);
    freq.put("nut", 41);
    freq.put("Ce ", 45);
    freq.put("să ", 184);
    freq.put("rfa", 6);
    freq.put("cra", 44);
    freq.put("oxi", 8);
    freq.put("rfe", 12);
    freq.put("cre", 121);
    freq.put("ie ", 514);
    freq.put("cri", 65);
    freq.put("J ", 6);
    freq.put("elg", 3);
    freq.put(" Be", 58);
    freq.put(" Bd", 4);
    freq.put("seu", 8);
    freq.put("set", 11);
    freq.put(" Ba", 128);
    freq.put("ser", 72);
    freq.put("For", 21);
    freq.put("Fos", 6);
    freq.put(" Bl", 30);
    freq.put(" Bo", 67);
    freq.put(" Bi", 41);
    freq.put("sez", 20);
    freq.put("sex", 19);
    freq.put(" Bu", 139);
    freq.put("sef", 5);
    freq.put(" fă", 26);
    freq.put("ik ", 5);
    freq.put("sec", 32);
    freq.put("Foa", 5);
    freq.put("sea", 81);
    freq.put(" Br", 55);
    freq.put("Fol", 3);
    freq.put("dus", 44);
    freq.put("sem", 41);
    freq.put("sel", 32);
    freq.put("arl", 18);
    freq.put("uu ", 8);
    freq.put("sei", 10);
    freq.put("ăli", 4);
    freq.put("vra", 12);
    freq.put("Plu", 4);
    freq.put("mo ", 10);
    freq.put("Pls", 4);
    freq.put("Vit", 5);
    freq.put("stu", 69);
    freq.put("oza", 19);
    freq.put("al ", 337);
    freq.put("aci", 67);
    freq.put("ses", 54);
    freq.put(" P ", 11);
    freq.put("oke", 14);
    freq.put(" ya", 3);
    freq.put("use", 37);
    freq.put("Plo", 7);
    freq.put("ms ", 4);
    freq.put("Age", 7);
    freq.put("Pli", 3);
    freq.put(" B ", 17);
    freq.put("web", 16);
    freq.put("uuu", 19);
    freq.put("lel", 36);
    freq.put("upp", 3);
    freq.put("Oba", 7);
    freq.put("ar ", 424);
    freq.put("îţi", 5);
    freq.put("adu", 57);
    freq.put("len", 36);
    freq.put("ike", 9);
    freq.put("se ", 342);
    freq.put("iki", 4);
    freq.put("leo", 4);
    freq.put("to ", 41);
    freq.put("TC ", 8);
    freq.put(" Pr", 172);
    freq.put("c", 8557);
    freq.put(" Pu", 31);
    freq.put("Oct", 9);
    freq.put("Far", 8);
    freq.put(" Pa", 125);
    freq.put(" Pe", 96);
    freq.put(" Pi", 47);
    freq.put(" Ph", 11);
    freq.put(" Po", 86);
    freq.put("pda", 4);
    freq.put(" Pl", 38);
    freq.put("ârg", 10);
    freq.put("utz", 3);
    freq.put("naş", 4);
    freq.put("ieş", 7);
    freq.put("rpr", 16);
    freq.put("nr ", 7);
    freq.put("Oţe", 3);
    freq.put("cră", 5);
    freq.put("ley", 5);
    freq.put("lbu", 15);
    freq.put("oşt", 6);
    freq.put("ady", 3);
    freq.put("lez", 8);
    freq.put("ga ", 75);
    freq.put("pr", 918);
    freq.put("ps", 32);
    freq.put("pp", 32);
    freq.put("dul", 68);
    freq.put("dum", 7);
    freq.put("pt", 253);
    freq.put("pu", 429);
    freq.put("dua", 6);
    freq.put("dub", 7);
    freq.put("py", 3);
    freq.put("xat", 7);
    freq.put("ăsp", 8);
    freq.put("tiv", 108);
    freq.put("pc", 7);
    freq.put("pa", 706);
    freq.put("HE ", 4);
    freq.put("xam", 5);
    freq.put("pd", 5);
    freq.put("pe", 1290);
    freq.put("dup", 64);
    freq.put("şt", 190);
    freq.put("ph", 20);
    freq.put("pi", 289);
    freq.put("dut", 24);
    freq.put("po", 478);
    freq.put("pl", 318);
    freq.put("ram", 78);
    freq.put("gaz", 32);
    freq.put("ctu", 47);
    freq.put(" tw", 30);
    freq.put(" tv", 6);
    freq.put(" tu", 90);
    freq.put("gat", 77);
    freq.put("Emi", 14);
    freq.put(" tr", 296);
    freq.put("nre", 6);
    freq.put("iA ", 4);
    freq.put(" to", 186);
    freq.put("gan", 57);
    freq.put("gam", 4);
    freq.put("hiţ", 3);
    freq.put("cee", 22);
    freq.put("gaj", 14);
    freq.put(" ti", 153);
    freq.put(" th", 12);
    freq.put(" te", 212);
    freq.put(" ta", 177);
    freq.put("Mun", 13);
    freq.put("Ola", 7);
    freq.put("fur", 29);
    freq.put("fus", 3);
    freq.put("rtă", 12);
    freq.put("ugă", 3);
    freq.put("fuz", 6);
    freq.put("eş ", 9);
    freq.put("fug", 3);
    freq.put("p ", 192);
    freq.put("Olt", 3);
    freq.put("nau", 13);
    freq.put("xa ", 6);
    freq.put("ăci", 7);
    freq.put("ful", 8);
    freq.put("fum", 15);
    freq.put("sma", 9);
    freq.put("bor", 19);
    freq.put("ogr", 55);
    freq.put("acă", 50);
    freq.put("riz", 37);
    freq.put("voa", 4);
    freq.put("ca ", 666);
    freq.put("voc", 19);
    freq.put("vol", 32);
    freq.put("vom", 8);
    freq.put("gel", 22);
    freq.put("riu", 55);
    freq.put("rir", 9);
    freq.put("voi", 44);
    freq.put("rip", 19);
    freq.put(" Pă", 5);
    freq.put("vou", 5);
    freq.put("Tin", 6);
    freq.put("rim", 167);
    freq.put("rij", 9);
    freq.put("bov", 4);
    freq.put("vor", 80);
    freq.put("vos", 4);
    freq.put("rif", 26);
    freq.put("rig", 24);
    freq.put("rid", 26);
    freq.put("CM ", 3);
    freq.put("rib", 7);
    freq.put("ric", 139);
    freq.put("ria", 156);
    freq.put("ng ", 87);
    freq.put("Şi", 6);
    freq.put("seş", 5);
    freq.put("ăca", 7);
    freq.put(" ţi", 22);
    freq.put("ceb", 26);
    freq.put("arş", 3);
    freq.put("pâ", 19);
    freq.put(" f ", 5);
    freq.put("nuţ", 3);
    freq.put("aha", 15);
    freq.put("mor", 45);
    freq.put("ews", 12);
    freq.put("ohn", 6);
    freq.put("Ilf", 3);
    freq.put("Cop", 10);
    freq.put("Cos", 18);
    freq.put("Cor", 15);
    freq.put("vo ", 4);
    freq.put("Cot", 3);
    freq.put("cea", 137);
    freq.put("Ili", 4);
    freq.put("Coa", 7);
    freq.put("Coc", 5);
    freq.put("lig", 17);
    freq.put("uto", 64);
    freq.put("Şa", 4);
    freq.put("FA ", 3);
    freq.put("pse", 5);
    freq.put("Com", 44);
    freq.put("Col", 15);
    freq.put("ri ", 590);
    freq.put("Con", 96);
    freq.put("Soa", 7);
    freq.put("ţ", 719);
    freq.put(" fr", 91);
    freq.put(" fu", 54);
    freq.put(" ft", 4);
    freq.put(" Bă", 31);
    freq.put("Sof", 3);
    freq.put("ew ", 13);
    freq.put("Sol", 10);
    freq.put("opa", 38);
    freq.put("Son", 7);
    freq.put(" fa", 336);
    freq.put("EI ", 7);
    freq.put("Sor", 4);
    freq.put(" fe", 93);
    freq.put("Nic", 25);
    freq.put("y", 291);
    freq.put("moo", 4);
    freq.put("bog", 9);
    freq.put(" fl", 19);
    freq.put(" fo", 248);
    freq.put(" Do", 60);
    freq.put("lda", 8);
    freq.put("elp", 4);
    freq.put("mom", 12);
    freq.put("lde", 3);
    freq.put("Joi", 3);
    freq.put("ldi", 3);
    freq.put("mol", 9);
    freq.put("ldo", 24);
    freq.put("ăma", 4);
    freq.put("O ", 127);
    freq.put("UB ", 5);
    freq.put("ldu", 3);
    freq.put("mob", 25);
    freq.put("lik", 6);
    freq.put("Ai ", 9);
    freq.put("uă", 28);
    freq.put("uzi", 38);
    freq.put("cuv", 11);
    freq.put(" uş", 3);
    freq.put("cus", 5);
    freq.put("cur", 237);
    freq.put("cup", 26);
    freq.put("ăţ", 26);
    freq.put(" Că", 5);
    freq.put("cuz", 17);
    freq.put("Num", 5);
    freq.put("amt", 6);
    freq.put("rga", 20);
    freq.put("cuc", 4);
    freq.put("rge", 46);
    freq.put("cua", 3);
    freq.put("veş", 3);
    freq.put("rgh", 11);
    freq.put("cun", 27);
    freq.put("cum", 180);
    freq.put("cul", 138);
    freq.put("ee ", 26);
    freq.put("cui", 29);
    freq.put("rgo", 5);
    freq.put("bin", 63);
    freq.put("On", 19);
    freq.put("Om", 6);
    freq.put("Ol", 11);
    freq.put("Ok", 3);
    freq.put("mop", 3);
    freq.put("Oh", 3);
    freq.put("Of", 27);
    freq.put("nze", 4);
    freq.put("rţ", 10);
    freq.put("Oc", 13);
    freq.put("Ob", 16);
    freq.put("Oa", 11);
    freq.put("Air", 5);
    freq.put("ror", 21);
    freq.put("apt", 70);
    freq.put("efa", 13);
    freq.put("poţ", 8);
    freq.put("Ov", 6);
    freq.put("bit", 33);
    freq.put("Ot", 5);
    freq.put("bir", 18);
    freq.put("Or", 22);
    freq.put("Dir", 13);
    freq.put("Op", 18);
    freq.put("âng", 8);
    freq.put("d", 5670);
    freq.put("cc ", 9);
    freq.put("eet", 23);
    freq.put("nsă", 12);
    freq.put("dun", 9);
    freq.put("ees", 3);
    freq.put("rg ", 16);
    freq.put("eel", 12);
    freq.put("ak ", 6);
    freq.put("een", 10);
    freq.put("eek", 7);
    freq.put("cu ", 624);
    freq.put("eee", 18);
    freq.put("eed", 4);
    freq.put("neu", 8);
    freq.put("eea", 37);
    freq.put("uţ", 39);
    freq.put("Vec", 7);
    freq.put("ămî", 4);
    freq.put("şi", 350);
    freq.put("b ", 105);
    freq.put("cce", 24);
    freq.put("gaţ", 3);
    freq.put("odo", 13);
    freq.put("ru ", 399);
    freq.put(" şi", 270);
    freq.put("agă", 5);
    freq.put("ămâ", 17);
    freq.put("kul", 3);
    freq.put("ija", 3);
    freq.put("ld ", 15);
    freq.put("Ate", 5);
    freq.put("şa ", 21);
    freq.put("iji", 5);
    freq.put("soc", 19);
    freq.put("ijl", 4);
    freq.put("Vel", 3);
    freq.put("Ep ", 3);
    freq.put("rf ", 3);
    freq.put("apa", 90);
    freq.put(" Qu", 3);
    freq.put("Vii", 5);
    freq.put("pet", 28);
    freq.put("rio", 28);
    freq.put(" şc", 11);
    freq.put("pel", 22);
    freq.put("bst", 6);
    freq.put("pen", 334);
    freq.put("MM ", 4);
    freq.put("uns", 44);
    freq.put("ped", 15);
    freq.put("ape", 35);
    freq.put("pea", 22);
    freq.put("id ", 44);
    freq.put("pec", 42);
    freq.put("be", 176);
    freq.put("rui", 18);
    freq.put("ufl", 6);
    freq.put("ba", 397);
    freq.put("bb", 5);
    freq.put("rum", 69);
    freq.put("bl", 186);
    freq.put("bm", 3);
    freq.put("Bor", 15);
    freq.put("bo", 112);
    freq.put("Bot", 6);
    freq.put("bi", 337);
    freq.put("O", 248);
    freq.put("bt", 9);
    freq.put("bu", 281);
    freq.put("bv", 4);
    freq.put("dăm", 3);
    freq.put("Bol", 4);
    freq.put(" gă", 9);
    freq.put("br", 159);
    freq.put("bs", 54);
    freq.put("rur", 16);
    freq.put("usc", 10);
    freq.put("Bob", 3);
    freq.put("Boc", 21);
    freq.put("Bod", 3);
    freq.put("by", 25);
    freq.put("Aş", 9);
    freq.put("zis", 30);
    freq.put("Rol", 3);
    freq.put("Rom", 140);
    freq.put("lb ", 4);
    freq.put("Roa", 5);
    freq.put("Rob", 3);
    freq.put("idu", 13);
    freq.put("idr", 4);
    freq.put("Rox", 3);
    freq.put("ido", 3);
    freq.put("yle", 3);
    freq.put("aa ", 10);
    freq.put("idi", 27);
    freq.put("DE ", 12);
    freq.put("ylo", 4);
    freq.put("ide", 121);
    freq.put("pe ", 536);
    freq.put("fel", 38);
    freq.put("Rov", 4);
    freq.put("ida", 21);
    freq.put("ppl", 19);
    freq.put("nsi", 41);
    freq.put("wn ", 7);
    freq.put("bui", 59);
    freq.put("nsm", 9);
    freq.put("sfa", 18);
    freq.put("nso", 6);
    freq.put(" ut", 19);
    freq.put("nsa", 46);
    freq.put(" C ", 20);
    freq.put("Năs", 4);
    freq.put(" up", 7);
    freq.put("nse", 47);
    freq.put(" ur", 95);
    freq.put("Ele", 9);
    freq.put(" ul", 90);
    freq.put(" um", 15);
    freq.put(" un", 533);
    freq.put(" ui", 43);
    freq.put("bse", 9);
    freq.put("nsp", 14);
    freq.put("enc", 13);
    freq.put("Tâ", 10);
    freq.put("nsu", 40);
    freq.put("mn ", 21);
    freq.put("ut ", 235);
    freq.put("ci ", 239);
    freq.put("xpo", 6);
    freq.put("ăn", 35);
    freq.put("ăm", 49);
    freq.put("xpl", 15);
    freq.put("ăc", 42);
    freq.put("ăg", 3);
    freq.put("fet", 20);
    freq.put("xpe", 11);
    freq.put("ixe", 3);
    freq.put("ăz", 34);
    freq.put("feu", 5);
    freq.put(" gâ", 3);
    freq.put("ăs", 63);
    freq.put("xpr", 3);
    freq.put("ăp", 14);
    freq.put("u ", 2573);
    freq.put("ău", 26);
    freq.put("Fe", 60);
    freq.put("cab", 4);
    freq.put(" Ch", 51);
    freq.put(" Ci", 56);
    freq.put(" Co", 229);
    freq.put(" Cl", 63);
    freq.put("ns ", 65);
    freq.put("uT", 4);
    freq.put("El ", 8);
    freq.put(" Ca", 166);
    freq.put("Oţ", 3);
    freq.put(" Şt", 6);
    freq.put("wnl", 5);
    freq.put(" Ce", 116);
    freq.put(" Şi", 6);
    freq.put("tru", 443);
    freq.put("exe", 12);
    freq.put("Flo", 10);
    freq.put(" Cr", 59);
    freq.put(" Cs", 4);
    freq.put("Pag", 3);
    freq.put(" u ", 9);
    freq.put(" Cu", 130);
    freq.put("cic", 20);
    freq.put("cia", 106);
    freq.put("uta", 93);
    freq.put("uy", 4);
    freq.put("ux", 11);
    freq.put("cie", 23);
    freq.put("uz", 129);
    freq.put("uu", 32);
    freq.put("Fl", 19);
    freq.put("ix ", 5);
    freq.put("uv", 50);
    freq.put("cio", 28);
    freq.put("vân", 13);
    freq.put("us", 355);
    freq.put("ur", 1219);
    freq.put("um", 612);
    freq.put("ul", 1915);
    freq.put("un", 1484);
    freq.put("ui", 628);
    freq.put("uh", 5);
    freq.put("uk", 5);
    freq.put("uj", 38);
    freq.put("ue", 35);
    freq.put("ud", 105);
    freq.put("ug", 77);
    freq.put("Fo", 63);
    freq.put("ua", 241);
    freq.put("ath", 6);
    freq.put("uc", 363);
    freq.put("ub", 156);
    freq.put("cin", 84);
    freq.put("Tw", 8);
    freq.put("Tu", 54);
    freq.put("Tr", 96);
    freq.put("oog", 18);
    freq.put("To", 41);
    freq.put("vot", 6);
    freq.put("Th", 13);
    freq.put("Ti", 52);
    freq.put(" îm", 24);
    freq.put("pă ", 48);
    freq.put("Te", 59);
    freq.put("Ta", 48);
    freq.put("A ", 189);
    freq.put("Mas", 8);
    freq.put("gru", 10);
    freq.put(" gr", 106);
    freq.put("nag", 12);
    freq.put("bă", 47);
    freq.put("naj", 11);
    freq.put("Evo", 7);
    freq.put("run", 22);
    freq.put("nal", 144);
    freq.put("Suz", 3);
    freq.put("nar", 47);
    freq.put("nas", 26);
    freq.put("nap", 9);
    freq.put("gre", 35);
    freq.put("nav", 5);
    freq.put("Mad", 10);
    freq.put("nat", 118);
    freq.put("gra", 127);
    freq.put("naz", 3);
    freq.put(" go", 31);
    freq.put(" gl", 8);
    freq.put("Maj", 3);
    freq.put("Mam", 8);
    freq.put("Mal", 3);
    freq.put(" gh", 6);
    freq.put(" gi", 8);
    freq.put("rds", 4);
    freq.put("ku", 8);
    freq.put("ot ", 88);
    freq.put("bţ", 7);
    freq.put(" Câ", 21);
    freq.put("ruţ", 3);
    freq.put("ddy", 3);
    freq.put("păt", 4);
    freq.put("Beg", 5);
    freq.put("orr", 5);
    freq.put("ac ", 81);
    freq.put("ly ", 19);
    freq.put("păl", 3);
    freq.put("dăr", 3);
    freq.put("păc", 5);
    freq.put("bot", 4);

    init3();
  }
  private static void init3() {
    
    freq.put("T ", 194);
    freq.put("ago", 15);
    freq.put("cis", 9);
    freq.put("Ac", 56);
    freq.put("Ab", 3);
    freq.put("Ae", 4);
    freq.put("Ad", 40);
    freq.put("Ag", 12);
    freq.put("Af", 14);
    freq.put("Ai", 17);
    freq.put("Ah", 4);
    freq.put("age", 38);
    freq.put("Am", 66);
    freq.put("Al", 60);
    freq.put("aga", 55);
    freq.put("An", 112);
    freq.put("Ap", 48);
    freq.put("As", 44);
    freq.put("Ar", 58);
    freq.put("Au", 44);
    freq.put("At", 21);
    freq.put(" g ", 8);
    freq.put("Av", 11);
    freq.put("far", 51);
    freq.put("agu", 17);
    freq.put("Az", 16);
    freq.put("nvi", 33);
    freq.put("agr", 14);
    freq.put(" b", 609);
    freq.put(" c", 3239);
    freq.put("Giu", 5);
    freq.put(" a", 3282);
    freq.put(" f", 1131);
    freq.put(" g", 328);
    freq.put(" d", 3442);
    freq.put(" e", 987);
    freq.put(" j", 146);
    freq.put(" k", 50);
    freq.put(" h", 117);
    freq.put(" i", 1534);
    freq.put(" n", 1083);
    freq.put(" o", 874);
    freq.put(" l", 1708);
    freq.put(" m", 1821);
    freq.put(" r", 753);
    freq.put(" s", 3050);
    freq.put(" p", 2709);
    freq.put(" q", 3);
    freq.put(" v", 1047);
    freq.put(" w", 61);
    freq.put(" t", 1179);
    freq.put(" u", 840);
    freq.put(" z", 199);
    freq.put("gn", 14);
    freq.put(" x", 20);
    freq.put(" y", 10);
    freq.put("ass", 5);
    freq.put(" îş", 7);
    freq.put("gi", 204);
    freq.put("gh", 50);
    freq.put(" B", 636);
    freq.put(" C", 1021);
    freq.put(" A", 795);
    freq.put(" F", 372);
    freq.put(" G", 299);
    freq.put(" D", 643);
    freq.put(" E", 311);
    freq.put(" J", 119);
    freq.put(" K", 43);
    freq.put(" H", 125);
    freq.put(" I", 416);
    freq.put(" N", 335);
    freq.put(" O", 244);
    freq.put(" L", 272);
    freq.put(" M", 670);
    freq.put(" R", 609);
    freq.put(" S", 870);
    freq.put(" P", 743);
    freq.put(" Q", 8);
    freq.put(" V", 396);
    freq.put(" W", 64);
    freq.put(" T", 458);
    freq.put(" U", 223);
    freq.put(" Z", 59);
    freq.put("Nou", 24);
    freq.put(" X", 29);
    freq.put(" Y", 21);
    freq.put("rto", 12);
    freq.put("Nor", 13);
    freq.put("Băl", 3);
    freq.put("ed ", 54);
    freq.put("Man", 17);
    freq.put("caz", 29);
    freq.put("âl", 5);
    freq.put("âm", 11);
    freq.put("ân", 218);
    freq.put("âi", 17);
    freq.put("obi", 50);
    freq.put("ât", 44);
    freq.put("P", 774);
    freq.put("Fă", 3);
    freq.put("d ", 471);
    freq.put("âr", 27);
    freq.put("g ", 195);
    freq.put("pun", 102);
    freq.put("UA ", 14);
    freq.put("ga", 365);
    freq.put("tri", 112);
    freq.put("evi", 72);
    freq.put("mp ", 46);
    freq.put("tro", 70);
    freq.put("evo", 33);
    freq.put("tra", 250);
    freq.put("eva", 113);
    freq.put("Mol", 16);
    freq.put("us ", 123);
    freq.put("tre", 337);
    freq.put("eve", 68);
    freq.put("Spi", 8);
    freq.put("aş", 98);
    freq.put("Spo", 11);
    freq.put("Spa", 27);
    freq.put("evr", 10);
    freq.put("chr", 3);
    freq.put("Spe", 19);
    freq.put("zl", 4);
    freq.put("zm", 6);
    freq.put("zn", 5);
    freq.put("zo", 71);
    freq.put("zh", 3);
    freq.put("zi", 556);
    freq.put("rri", 4);
    freq.put("zd", 8);
    freq.put("ze", 180);
    freq.put("ty ", 13);
    freq.put("zg", 6);
    freq.put(" î", 496);
    freq.put("za", 354);
    freq.put("zb", 14);
    freq.put("ay ", 23);
    freq.put("odi", 32);
    freq.put("Blo", 16);
    freq.put("mia", 8);
    freq.put("gâ", 5);
    freq.put("zz", 9);
    freq.put("taţ", 18);
    freq.put("zu", 90);
    freq.put("zv", 21);
    freq.put("ulu", 224);
    freq.put("wo", 6);
    freq.put("rrr", 9);
    freq.put("ues", 4);
    freq.put("F ", 15);
    freq.put("nzi", 13);
    freq.put("â", 5);
    freq.put("med", 38);
    freq.put(" Î", 51);
    freq.put("KA ", 4);
    freq.put("rem", 89);
    freq.put("cit", 78);
    freq.put("ct ", 73);
    freq.put("rd ", 35);
    freq.put("Ori", 7);
    freq.put("nă ", 95);
    freq.put("gă", 48);
    freq.put("atu", 137);
    freq.put("ulo", 15);
    freq.put("sur", 57);
    freq.put(" vă", 33);
    freq.put("oze", 21);
    freq.put("ull", 3);
    freq.put("lef", 22);
    freq.put("obe", 8);
    freq.put("meg", 4);
    freq.put("lei", 59);
    freq.put("z ", 92);
    freq.put("ue ", 9);
    freq.put(" €", 4);
    freq.put("ozi", 35);
    freq.put("asu", 27);
    freq.put("¦ ", 4);
    freq.put("ler", 29);
    freq.put("les", 48);
    freq.put("let", 72);
    freq.put("tde", 5);
    freq.put("lev", 19);
    freq.put("ulc", 18);
    freq.put("od ", 19);
    freq.put("vul", 8);
    freq.put(" Și", 10);
    freq.put("iş ", 3);
    freq.put("ocl", 18);
    freq.put("rdu", 29);
    freq.put("eni", 219);
    freq.put("âş", 15);
    freq.put("ctr", 22);
    freq.put("ulf", 4);
    freq.put("năr", 3);
    freq.put("trâ", 3);
    freq.put("năt", 7);
    freq.put("âte", 10);
    freq.put("ulg", 11);
    freq.put("rde", 33);
    freq.put("cte", 43);
    freq.put("rda", 9);
    freq.put("cta", 31);
    freq.put("ăt ", 3);
    freq.put("rdo", 8);
    freq.put("SM ", 5);
    freq.put("rdi", 8);
    freq.put("cti", 107);
    freq.put(" Ţ", 8);
    freq.put(" ţ", 31);
    freq.put("Vet", 4);
    freq.put("Mec", 3);
    freq.put("Ver", 4);
    freq.put("Ves", 4);
    freq.put(" Di", 65);
    freq.put("Mih", 20);
    freq.put("apr", 34);
    freq.put("win", 5);
    freq.put(" De", 152);
    freq.put("evă", 10);
    freq.put("Vez", 19);
    freq.put(" Da", 140);
    freq.put("IA ", 12);
    freq.put(" şo", 10);
    freq.put("wit", 22);
    freq.put("ii ", 663);
    freq.put("apl", 7);
    freq.put("OS ", 5);
    freq.put("Ven", 9);
    freq.put("NT ", 6);
    freq.put(" Du", 31);
    freq.put(" şe", 9);
    freq.put(" Dr", 31);
    freq.put("lne", 5);
    freq.put(" şa", 7);
    freq.put("cha", 8);
    freq.put("Fr", 33);
    freq.put("ziu", 40);
    freq.put("zir", 3);
    freq.put("Fu", 23);
    freq.put("zip", 3);
    freq.put("fea", 8);
    freq.put("fen", 6);
    freq.put("ez ", 49);
    freq.put("dăd", 3);
    freq.put("fem", 24);
    freq.put("usi", 51);
    freq.put("ush", 8);
    freq.put("rao", 3);
    freq.put("Fa", 60);
    freq.put("zid", 6);
    freq.put("zie", 19);
    freq.put("zib", 4);
    freq.put(" R ", 5);
    freq.put("zia", 18);
    freq.put("zin", 43);
    freq.put("Fi", 53);
    freq.put("zil", 47);
    freq.put("zim", 3);
    freq.put(" Ş", 25);
    freq.put(" ş", 332);
    freq.put("spă", 9);
    freq.put("zii", 18);
    freq.put("iit", 27);
    freq.put("Gue", 3);
    freq.put("âţ", 3);
    freq.put("ăzu", 10);
    freq.put("aca", 172);
    freq.put(" D ", 36);
    freq.put("Guv", 16);
    freq.put("săt", 4);
    freq.put("iil", 65);
    freq.put("ap ", 17);
    freq.put("iin", 14);
    freq.put("iii", 27);
    freq.put("ocs", 3);
    freq.put(" Ru", 20);
    freq.put(" ă", 12);
    freq.put("Băn", 9);
    freq.put("ace", 222);
    freq.put("fe ", 6);
    freq.put("f", 1945);
    freq.put("ocu", 90);
    freq.put("oh", 11);
    freq.put("dă ", 33);
    freq.put("săp", 8);
    freq.put(" Re", 127);
    freq.put("ack", 28);
    freq.put(" Ra", 49);
    freq.put("Mai", 38);
    freq.put("zi ", 168);
    freq.put("Şt", 6);
    freq.put(" Ro", 190);
    freq.put("săr", 15);
    freq.put(" Ri", 8);
    freq.put(" c ", 17);
    freq.put("Băs", 12);
    freq.put("tat", 408);
    freq.put("tau", 34);
    freq.put("tav", 3);
    freq.put("ach", 22);
    freq.put("tap", 12);
    freq.put("tar", 232);
    freq.put("xce", 12);
    freq.put("aco", 52);
    freq.put("raj", 15);
    freq.put("tax", 11);
    freq.put("xcl", 5);
    freq.put("tad", 12);
    freq.put("taf", 4);
    freq.put("tag", 7);
    freq.put("tab", 29);
    freq.put("tac", 38);
    freq.put("tal", 133);
    freq.put("tam", 94);
    freq.put("tan", 118);
    freq.put("cni", 3);
    freq.put("taj", 5);
    freq.put("rt ", 80);
    freq.put(" va", 279);
    freq.put("sir", 9);
    freq.put("Bec", 8);
    freq.put(" ve", 133);
    freq.put("siv", 12);
    freq.put("Yo", 11);
    freq.put("¦", 4);
    freq.put("Ya", 6);
    freq.put("afe", 17);
    freq.put("afa", 25);
    freq.put(" vo", 136);
    freq.put("ălă", 7);
    freq.put("sic", 17);
    freq.put("sib", 21);
    freq.put(" vs", 5);
    freq.put(" vr", 101);
    freq.put(" vu", 4);
    freq.put("sif", 4);
    freq.put("sie", 11);
    freq.put("exa", 20);
    freq.put("afu", 7);
    freq.put("fam", 9);
    freq.put("măt", 13);
    freq.put("sio", 17);
    freq.put("sin", 62);
    freq.put("sim", 48);
    freq.put("sil", 35);
    freq.put("sis", 13);
    freq.put("acu", 136);
    freq.put("paf", 6);
    freq.put("vut", 19);
    freq.put("act", 81);
    freq.put("ălţ", 3);
    freq.put("Q", 9);
    freq.put("sip", 5);
    freq.put("ta ", 779);
    freq.put("mi ", 141);
    freq.put("agh", 4);
    freq.put("ung", 58);
    freq.put("ST ", 7);
    freq.put("miz", 8);
    freq.put("oză", 4);
    freq.put("rl ", 4);
    freq.put(" v ", 20);
    freq.put("rm ", 9);
    freq.put("siu", 43);
    freq.put("Onl", 12);
    freq.put("pă", 99);
    freq.put("mez", 3);
    freq.put("Y ", 6);
    freq.put("sit", 115);
    freq.put("af ", 7);
    freq.put("tos", 11);
    freq.put("ză", 96);
    freq.put(" vi", 320);
    freq.put("bun", 82);
    freq.put("exo", 5);
    freq.put("măr", 25);
    freq.put("TO ", 12);
    freq.put("Scr", 4);
    freq.put("leş", 3);
    freq.put("VI ", 6);
    freq.put("da ", 152);
    freq.put("ţă", 60);
    freq.put("bă ", 14);
    freq.put("ens", 36);
    freq.put("Min", 23);
    freq.put("jna", 3);
    freq.put("own", 11);
    freq.put("dw", 3);
    freq.put("Ca ", 11);
    freq.put("TVu", 3);
    freq.put("lf", 16);
    freq.put("lg", 17);
    freq.put("ld", 60);
    freq.put("le", 1529);
    freq.put("lb", 49);
    freq.put("lc", 60);
    freq.put("la", 1604);
    freq.put("ln", 23);
    freq.put("lo", 753);
    freq.put("ll", 97);
    freq.put("lm", 37);
    freq.put("lk", 4);
    freq.put("euc", 3);
    freq.put("li", 912);
    freq.put("lv", 38);
    freq.put("lt", 351);
    freq.put("lu", 931);
    freq.put("ls", 26);
    freq.put("lp", 19);
    freq.put("cto", 92);
    freq.put("eut", 4);
    freq.put("şcă", 4);
    freq.put(" h ", 13);
    freq.put("lz", 3);
    freq.put("ndi", 68);
    freq.put("eus", 9);
    freq.put("ly", 23);
    freq.put("dad", 3);
    freq.put("Caz", 7);
    freq.put("băn", 6);
    freq.put(" za", 7);
    freq.put("ecâ", 13);
    freq.put("RA ", 10);
    freq.put("dac", 66);
    freq.put("Cas", 18);
    freq.put("Car", 27);
    freq.put("dan", 19);
    freq.put("Cap", 9);
    freq.put("dai", 14);
    freq.put("Cau", 6);
    freq.put("Cat", 18);
    freq.put("dat", 136);
    freq.put("dau", 27);
    freq.put("dav", 4);
    freq.put("dap", 3);
    freq.put("Can", 16);
    freq.put("Cam", 22);
    freq.put("Cal", 23);
    freq.put("băt", 9);
    freq.put(" Să", 16);
    freq.put("day", 10);
    freq.put("băr", 11);
    freq.put("Cad", 3);
    freq.put("Pre", 57);
    freq.put("nfe", 10);
    freq.put("sih", 5);
    freq.put("Pra", 6);
    freq.put("San", 19);
    freq.put("l ", 2029);
    freq.put("Sal", 18);
    freq.put("tph", 5);
    freq.put(" hr", 3);
    freq.put("Pro", 57);
    freq.put("emb", 60);
    freq.put("Pri", 52);
    freq.put("eu ", 155);
    freq.put(" hu", 4);
    freq.put(" ht", 8);
    freq.put(" −", 4);
    freq.put(" hi", 10);
    freq.put("FB ", 3);
    freq.put(" ho", 21);
    freq.put("nfr", 10);
    freq.put(" hm", 4);
    freq.put("Sar", 5);
    freq.put(" Ș", 14);
    freq.put("pal", 21);
    freq.put(" he", 13);
    freq.put("Sat", 3);
    freq.put("oui", 3);
    freq.put("ăce", 6);
    freq.put("oun", 11);
    freq.put("ură", 26);
    freq.put("ouc", 9);
    freq.put("baz", 8);
    freq.put("tch", 6);
    freq.put("lfi", 7);
    freq.put("bim", 3);
    freq.put("miş", 13);
    freq.put("ous", 9);
    freq.put("pam", 11);
    freq.put("oup", 5);
    freq.put("ovi", 26);
    freq.put("bu ", 8);
    freq.put("out", 10);
    freq.put("rez", 120);
    freq.put("lâ", 5);
    freq.put("exi", 29);
    freq.put("rer", 16);
    freq.put("res", 234);
    freq.put("Tur", 21);
    freq.put("Lit", 3);
    freq.put("Tut", 4);
    freq.put("CS ", 6);
    freq.put("ret", 89);
    freq.put("reu", 34);
    freq.put("rej", 3);
    freq.put("rei", 80);
    freq.put("Tul", 6);
    freq.put("wer", 3);
    freq.put("Tun", 5);
    freq.put("Urm", 10);
    freq.put("reb", 84);
    freq.put("rec", 161);
    freq.put("Tub", 4);
    freq.put("rea", 503);
    freq.put("Tud", 3);
    freq.put("reg", 54);
    freq.put("red", 98);
    freq.put("uet", 4);
    freq.put("âin", 16);
    freq.put("ece", 60);
    freq.put("ky ", 4);
    freq.put("eca", 68);
    freq.put("CE ", 13);
    freq.put("eco", 51);
    freq.put("boi", 7);
    freq.put("ecl", 26);
    freq.put("eck", 4);
    freq.put("AX ", 4);
    freq.put("eci", 121);
    freq.put("ech", 54);
    freq.put("ouT", 4);
    freq.put("Ghe", 14);
    freq.put("ecu", 65);
    freq.put("ect", 199);
    freq.put("ecr", 21);
    freq.put("x", 312);
    freq.put("qui", 4);
    freq.put("lgi", 4);
    freq.put("Ghi", 12);
    freq.put("log", 78);
    freq.put("oni", 64);
    freq.put("ltr", 4);
    freq.put("val", 53);
    freq.put("g", 1722);
    freq.put("rfo", 7);
    freq.put("Cra", 12);
    freq.put("Înc", 10);
    freq.put("cro", 22);
    freq.put("ltc", 6);
    freq.put("otă", 4);
    freq.put("lta", 63);
    freq.put("snu", 3);
    freq.put("ltf", 7);
    freq.put("lte", 59);
    freq.put("rcu", 33);
    freq.put("Tu ", 10);
    freq.put(" hâ", 3);
    freq.put("re ", 1122);
    freq.put("umu", 38);
    freq.put("amă", 4);
    freq.put("Fot", 19);
    freq.put("K ", 16);
    freq.put("mos", 25);
    freq.put("ţe ", 11);
    freq.put("mit", 79);
    freq.put("lţe", 3);
    freq.put("rs ", 43);
    freq.put("arr", 4);
    freq.put("IT ", 14);
    freq.put("hey", 3);
    freq.put("mai", 438);
    freq.put("euş", 5);
    freq.put("ihi", 5);
    freq.put("ihn", 3);
    freq.put("iho", 4);
    freq.put("onj", 3);
    freq.put("lib", 23);
    freq.put("toi", 6);
    freq.put("iha", 23);
    freq.put("og ", 39);
    freq.put("aru", 63);
    freq.put("vaz", 16);
    freq.put("maj", 7);
    freq.put("lţ", 31);
    freq.put("av ", 6);
    freq.put("los", 18);
    freq.put("asi", 99);
    freq.put(" Sp", 68);
    freq.put("sep", 32);
    freq.put(" Sw", 3);
    freq.put(" St", 170);
    freq.put(" Su", 71);
    freq.put(" Sk", 5);
    freq.put(" Sh", 13);
    freq.put(" Si", 96);
    freq.put("mnu", 9);
    freq.put(" So", 42);
    freq.put(" Sl", 8);
    freq.put(" Sm", 4);
    freq.put("mno", 3);
    freq.put(" Sc", 33);
    freq.put(" Sa", 85);
    freq.put(" Sf", 9);
    freq.put("arz", 8);
    freq.put("mer", 148);
    freq.put(" Se", 113);
    freq.put("aai", 4);
    freq.put("Ka", 14);
    freq.put("rso", 37);
    freq.put("lă", 103);
    freq.put("Ke", 6);
    freq.put("udu", 6);
    freq.put("ogu", 17);
    freq.put("ţen", 5);
    freq.put("Ki", 6);
    freq.put("ţel", 27);
    freq.put("Ko", 8);
    freq.put("rsa", 19);
    freq.put("rsc", 4);
    freq.put("ehn", 8);
    freq.put("ogo", 9);
    freq.put("R", 613);
    freq.put("ogi", 14);
    freq.put("umv", 4);
    freq.put("şco", 10);
    freq.put("vas", 6);
    freq.put("rst", 4);
    freq.put("rsu", 27);
    freq.put("ogg", 12);
    freq.put("udi", 30);
    freq.put("sfâ", 8);
    freq.put("udo", 5);
    freq.put("NU ", 8);
    freq.put("bej", 3);
    freq.put("seg", 5);
    freq.put("bei", 5);
    freq.put("ben", 13);
    freq.put("zne", 3);
    freq.put("bel", 20);
    freq.put("bem", 3);
    freq.put("bec", 5);
    freq.put("lea", 79);
    freq.put("bea", 16);
    freq.put("onc", 66);
    freq.put("see", 3);
    freq.put("apu", 15);
    freq.put("nuc", 8);
    freq.put("lim", 59);
    freq.put("AL ", 15);
    freq.put("sed", 19);
    freq.put("mna", 41);
    freq.put("scă", 20);
    freq.put("lna", 3);
    freq.put("ber", 48);
    freq.put("exp", 32);
    freq.put(" S ", 29);
    freq.put("bet", 13);
    freq.put("are", 945);
    freq.put("Pap", 3);
    freq.put("buz", 14);
    freq.put("Par", 58);
    freq.put("Edi", 5);
    freq.put("Pat", 9);
    freq.put("reş", 65);
    freq.put("Pav", 3);
    freq.put("leb", 6);
    freq.put("Foc", 3);
    freq.put(" E ", 40);
    freq.put("eak", 6);
    freq.put("urm", 36);
    freq.put("ltă", 6);
    freq.put("arh", 11);
    freq.put("Pac", 6);
    freq.put("Pad", 10);
    freq.put("sen", 37);
    freq.put("py ", 3);
    freq.put("Pai", 10);
    freq.put("st", 1803);
    freq.put("sm ", 24);
    freq.put("ool", 9);
    freq.put("sf ", 3);
    freq.put("eal", 55);
    freq.put("mii", 25);
    freq.put("sk", 8);
    freq.put("ark", 12);
    freq.put("ur ", 69);
    freq.put("ck ", 34);
    freq.put("lec", 70);
    freq.put("min", 210);
    freq.put("ona", 152);
    freq.put("mic", 78);
    freq.put("ean", 68);
    freq.put("mie", 54);
    freq.put("mid", 3);
    freq.put("riţ", 14);
    freq.put("Dep", 13);
    freq.put("Şas", 4);
    freq.put("si ", 594);
    freq.put("arn", 22);
    freq.put("bug", 7);
    freq.put("ro ", 104);
    freq.put("ER ", 7);
    freq.put("mis", 93);
    freq.put("aro", 14);
    freq.put("SL ", 9);
    freq.put("oua", 49);
    freq.put("bic", 16);
    freq.put("sn", 11);
    freq.put(" El", 26);
    freq.put(" Em", 20);
    freq.put(" En", 15);
    freq.put("eab", 21);
    freq.put("ecţ", 7);
    freq.put(" Ei", 3);
    freq.put("edb", 3);
    freq.put(" Ed", 7);
    freq.put("fos", 119);
    freq.put(" Ec", 12);
    freq.put("sc", 569);
    freq.put(" Ex", 22);
    freq.put("Dev", 4);
    freq.put("Liv", 13);
    freq.put(" Et", 8);
    freq.put(" Eu", 44);
    freq.put(" Ev", 23);
    freq.put("sfe", 16);
    freq.put(" Ep", 11);
    freq.put("ny ", 14);
    freq.put(" Er", 8);
    freq.put(" Es", 14);
    freq.put("cke", 8);
    freq.put("ure", 141);
    freq.put("lee", 4);
    freq.put("urg", 17);
    freq.put("Poz", 6);
    freq.put("iş", 58);
    freq.put("urb", 12);
    freq.put("urc", 27);
    freq.put("url", 3);
    freq.put("ckl", 3);
    freq.put("urn", 36);
    freq.put("rât", 4);
    freq.put("Por", 17);
    freq.put("ckh", 3);
    freq.put("Pop", 8);
    freq.put("ghi", 23);
    freq.put("urt", 30);
    freq.put("Cât", 9);
    freq.put("urv", 3);
    freq.put("eaz", 134);
    freq.put("urp", 11);
    freq.put("se", 839);
    freq.put("cks", 3);
    freq.put("urs", 58);
    freq.put("Del", 9);
    freq.put("bia", 18);
    freq.put("oci", 34);
    freq.put("Dem", 5);
    freq.put("Ian", 5);
    freq.put("Den", 3);
    freq.put("Cha", 13);
    freq.put(" iP", 21);
    freq.put("NI ", 10);
    freq.put("bum", 15);
    freq.put("au ", 338);
    freq.put("moţ", 4);
    freq.put("ăni", 11);
    freq.put("eî", 3);
    freq.put("ucţ", 4);
    freq.put(" iN", 3);
    freq.put("buc", 23);
    freq.put(" iA", 3);
    freq.put("rbă", 3);
    freq.put("eas", 84);
    freq.put("Ias", 7);
    freq.put("Iar", 4);
    freq.put("eda", 20);
    freq.put("nge", 50);
    freq.put("Dec", 16);
    freq.put("nga", 38);
    freq.put("co ", 9);
    freq.put(" ip", 8);
    freq.put("Mor", 4);
    freq.put(" ir", 4);
    freq.put(" is", 30);
    freq.put(" it", 39);
    freq.put(" iu", 22);
    freq.put("jap", 3);
    freq.put("eat", 56);
    freq.put("sh ", 13);
    freq.put(" ii", 26);
    freq.put(" il", 22);
    freq.put(" im", 114);
    freq.put(" in", 1022);
    freq.put(" io", 5);
    freq.put(" ia", 63);
    freq.put("Moa", 3);
    freq.put("eav", 6);
    freq.put(" id", 16);
    freq.put("jac", 3);
    freq.put("onz", 6);
    freq.put("Mod", 13);
    freq.put("oto", 71);
    freq.put("lit", 114);
    freq.put("Pla", 14);
    freq.put("tui", 32);
    freq.put("Ok ", 3);
    freq.put("Ia ", 5);
    freq.put("Men", 3);
    freq.put("Rus", 13);
    freq.put("tba", 28);
    freq.put("liu", 21);
    freq.put(" we", 27);
    freq.put("qu", 7);
    freq.put("ărc", 5);
    freq.put("că", 300);
    freq.put("h", 944);
    freq.put("ăse", 15);
    freq.put("Chr", 3);
    freq.put(" wh", 3);
    freq.put(" wi", 10);
    freq.put(" ww", 15);
    freq.put("lţi", 21);
    freq.put("ăra", 16);
    freq.put("ucă", 8);
    freq.put("ks ", 3);
    freq.put("Am ", 44);
    freq.put(" i ", 79);
    freq.put("shi", 11);
    freq.put("şi ", 301);
    freq.put("ael", 6);
    freq.put("ja ", 23);
    freq.put("gby", 6);
    freq.put("Pr", 174);
    freq.put("ebe", 14);
    freq.put("eba", 26);
    freq.put("Pu", 32);
    freq.put("ebl", 5);
    freq.put("ebo", 27);
    freq.put("we", 51);
    freq.put("Zon", 3);
    freq.put("Zoo", 3);
    freq.put("ebu", 67);
    freq.put("lol", 6);
    freq.put("Pa", 135);
    freq.put("ok ", 38);
    freq.put("ebr", 8);
    freq.put("Pe", 98);
    freq.put("ede", 74);
    freq.put("pag", 20);
    freq.put("Ph", 25);
    freq.put("Pi", 47);
    freq.put("bti", 7);
    freq.put("Po", 86);
    freq.put("Pl", 38);
    freq.put("lup", 14);
    freq.put("lur", 13);
    freq.put("ări", 73);
    freq.put("lut", 37);
    freq.put("wa", 9);
    freq.put("pui", 10);
    freq.put("lux", 5);
    freq.put("ve ", 64);
    freq.put("Obi", 7);
    freq.put("Jac", 3);
    freq.put(" Ip", 3);
    freq.put("et ", 96);
    freq.put("luc", 46);
    freq.put("sot", 6);
    freq.put("lue", 5);
    freq.put("niţ", 12);
    freq.put("lui", 353);
    freq.put("luj", 33);
    freq.put("ăi", 20);
    freq.put("lul", 117);
    freq.put("omi", 52);
    freq.put("lun", 73);
    freq.put("ken", 6);
    freq.put("jor", 9);
    freq.put("jos", 5);
    freq.put("eb ", 20);
    freq.put("eşe", 25);
    freq.put("vru", 8);
    freq.put("eul", 32);
    freq.put("joy", 3);
    freq.put("sho", 14);
    freq.put("omn", 23);
    freq.put("joa", 14);
    freq.put("P ", 30);
    freq.put("joc", 15);
    freq.put("lt ", 68);
    freq.put("vre", 100);
    freq.put("joi", 7);
    freq.put("ket", 7);
    freq.put("âşt", 14);
    freq.put("ker", 19);
    freq.put("etr", 44);
    freq.put("ets", 4);
    freq.put("vă", 52);
    freq.put("etw", 3);
    freq.put("ett", 5);
    freq.put("etu", 61);
    freq.put("ară", 47);
    freq.put("llu", 5);
    freq.put("sov", 14);
    freq.put(" ah", 11);
    freq.put(" Fă", 3);
    freq.put("eta", 110);
    freq.put("tle", 6);
    freq.put("ete", 134);
    freq.put("ws", 21);
    freq.put("eth", 4);
    freq.put("eti", 127);
    freq.put("eto", 10);
    freq.put("ck", 59);
    freq.put("uia", 8);
    freq.put("ci", 826);
    freq.put("ch", 363);
    freq.put("co", 767);
    freq.put(" In", 165);
    freq.put("cm", 14);
    freq.put("cl", 134);
    freq.put("cc", 71);
    freq.put("ca", 1882);
    freq.put("bis", 15);
    freq.put("uic", 5);
    freq.put("ce", 1268);
    freq.put("cd", 5);
    freq.put("uce", 55);
    freq.put("Est", 14);
    freq.put("ucc", 11);
    freq.put(" an", 221);
    freq.put("uca", 58);
    freq.put("rgu", 18);
    freq.put("Hel", 3);
    freq.put("cr", 279);
    freq.put("ucl", 3);
    freq.put("uck", 3);
    freq.put("cv", 7);
    freq.put("cu", 1448);
    freq.put("ct", 419);
    freq.put("Ger", 5);
    freq.put("Gev", 3);
    freq.put("Jud", 7);
    freq.put("Pe ", 13);
    freq.put("ys ", 6);
    freq.put(" ar", 231);
    freq.put("Jul", 3);
    freq.put("uza", 49);
    freq.put("Jur", 13);
    freq.put("ai", 967);
    freq.put("Iaş", 4);
    freq.put("liş", 5);
    freq.put("Juv", 4);
    freq.put("Hoo", 3);
    freq.put("IE ", 13);
    freq.put("Mom", 3);
    freq.put("Geo", 7);
    freq.put("Gen", 5);
    freq.put("rb ", 3);
    freq.put("OL ", 5);
    freq.put("oti", 71);
    freq.put("ănu", 3);
    freq.put("cop", 63);
    freq.put("pid", 10);
    freq.put("AM ", 6);
    freq.put("c ", 529);
    freq.put("cos", 29);
    freq.put(" lă", 7);
    freq.put("cor", 55);
    freq.put("ănc", 7);
    freq.put("uc ", 28);
    freq.put("unt", 260);
    freq.put("otr", 11);
    freq.put("uin", 13);
    freq.put("ott", 4);
    freq.put("otu", 36);
    freq.put("cot", 6);
    freq.put("And", 31);
    freq.put("biu", 7);
    freq.put("Ang", 15);
    freq.put("Ana", 9);
    freq.put("Ann", 3);
    freq.put("cov", 7);
    freq.put("Hot", 13);
    freq.put("Ant", 12);
    freq.put("Anu", 30);
    freq.put("rpo", 6);
    freq.put("uir", 11);
    freq.put("rbi", 24);
    freq.put("ăte", 10);
    freq.put("Hor", 8);
    freq.put("rbe", 26);
    freq.put("eur", 62);
    freq.put("ya ", 3);
    freq.put("rba", 49);
    freq.put("yst", 4);
    freq.put("va", 604);
    freq.put(" Fr", 33);
    freq.put(" Fu", 23);
    freq.put("cî", 6);
    freq.put("câ", 76);
    freq.put("vl", 3);
    freq.put("daf", 10);
    freq.put("vo", 214);
    freq.put(" Fa", 60);
    freq.put("etă", 8);
    freq.put("vr", 122);
    freq.put("vs", 7);
    freq.put(" Fe", 60);
    freq.put("vu", 29);
    freq.put(" Fi", 50);
    freq.put("ave", 82);
    freq.put("You", 7);
    freq.put("olţ", 3);
    freq.put("Yor", 3);
    freq.put(" Fo", 61);
    freq.put("io ", 36);
    freq.put("coa", 31);
    freq.put("of ", 9);
    freq.put("pis", 27);
    freq.put("tas", 21);
    freq.put("edr", 3);
    freq.put("şin", 18);
    freq.put("onu", 46);
    freq.put("cad", 20);
    freq.put("piu", 3);
    freq.put("dal", 23);
    freq.put("cob", 7);
    freq.put("dam", 7);
    freq.put("oxa", 4);
    freq.put("maş", 14);
    freq.put(" T ", 3);
    freq.put("v ", 110);
    freq.put("leu", 9);
    freq.put("pho", 15);
    freq.put("ioz", 3);
    freq.put("ân ", 8);
    freq.put("iov", 10);
    freq.put("dex", 3);
    freq.put("iot", 5);
    freq.put("ios", 15);
    freq.put("ior", 21);
    freq.put("eţi", 37);
    freq.put("cas", 79);
    freq.put("ion", 158);
    freq.put("app", 7);
    freq.put("iol", 12);
    freq.put("tâm", 3);
    freq.put("tân", 4);
    freq.put("iog", 3);
    freq.put("oac", 18);
    freq.put("Dis", 6);
    freq.put("iod", 6);
    freq.put("ioc", 5);
    freq.put("iob", 4);
    freq.put("ioa", 48);
    freq.put("Sa ", 15);
    freq.put("ont", 134);
    freq.put("off", 6);
    freq.put("oov", 3);
    freq.put("ofe", 66);
    freq.put(" Tw", 8);
    freq.put(" Tu", 47);
    freq.put("ofi", 27);
    freq.put(" Tr", 96);
    freq.put("ună", 18);
    freq.put("col", 127);
    freq.put(" To", 41);
    freq.put("Pă", 5);
    freq.put("unn", 5);
    freq.put(" Ti", 52);
    freq.put(" Th", 11);
    freq.put(" Te", 59);
    freq.put("con", 256);
    freq.put("rtu", 42);
    freq.put("oam", 58);
    freq.put(" Ta", 47);
    freq.put("avu", 18);
    freq.put("oal", 34);
    freq.put("dar", 107);
    freq.put("xec", 6);
    freq.put("xel", 3);
    freq.put("xem", 7);
    freq.put("das", 3);
    freq.put(" xD", 4);
    freq.put("Ei ", 3);
    freq.put("oai", 15);
    freq.put("xer", 3);
    freq.put("bău", 3);
    freq.put("LR ", 3);
    freq.put("AR ", 6);
    freq.put("tce", 4);
    freq.put("lex", 24);
    freq.put("Bd", 4);
    freq.put("Be", 60);
    freq.put("rân", 9);
    freq.put("adr", 23);
    freq.put("Ba", 130);
    freq.put("wee", 20);
    freq.put("Bl", 31);
    freq.put("vaţ", 5);
    freq.put("gma", 4);
    freq.put("Bo", 67);
    freq.put("ît ", 4);
    freq.put("Bi", 41);
    freq.put("gme", 5);
    freq.put("wel", 3);
    freq.put("Bu", 140);
    freq.put("add", 8);
    freq.put(" xx", 4);
    freq.put("Br", 56);
    freq.put("Fam", 5);
    freq.put("Fab", 7);
    freq.put("Fac", 25);
    freq.put("adm", 7);
    freq.put("adh", 3);
    freq.put("adi", 60);
    freq.put("mf ", 9);
    freq.put("ăd", 24);
    freq.put("psa", 8);
    freq.put("Ier", 4);
    freq.put("xe ", 7);
    freq.put("ţir", 3);
    freq.put("Twi", 7);
    freq.put("eaţ", 12);
    freq.put("uză", 8);
    freq.put("lăr", 4);
    freq.put("Ţo ", 4);
    freq.put("nve", 32);
    freq.put("hâr", 3);
    freq.put("T", 468);
    freq.put("nva", 14);
    freq.put("abe", 17);
    freq.put("şit", 13);
    freq.put("igm", 3);
    freq.put("tc ", 3);
    freq.put("rcă", 12);
    freq.put("we ", 4);
    freq.put("B ", 40);
    freq.put("Sam", 8);
    freq.put("car", 336);
    freq.put(" x ", 8);
    freq.put("ană", 24);
    freq.put("GS ", 4);
    freq.put("ops", 3);
    freq.put("Uit", 3);
    freq.put("eaş", 3);
    freq.put("Fa ", 3);
    freq.put("Las", 9);
    freq.put("TI ", 6);
    freq.put("am ", 407);
    freq.put("işo", 9);
    freq.put("ubt", 6);
    freq.put("nja", 4);
    freq.put("nfl", 6);
    freq.put("Suc", 5);
    freq.put("Sub", 4);
    freq.put("nce", 157);
    freq.put("ui ", 385);
    freq.put("Sun", 15);
    freq.put("Sum", 3);
    freq.put("Sul", 7);
    freq.put("işc", 7);
    freq.put("dc ", 4);
    freq.put("rgi", 29);
    freq.put("Sur", 6);
    freq.put("nju", 3);
    freq.put("Sup", 18);
    freq.put("jlo", 4);
    freq.put("işt", 30);
    freq.put("U ", 30);
    freq.put("inţ", 34);
    freq.put("esu", 13);
    freq.put("est", 561);
    freq.put("ess", 22);
    freq.put("tmu", 3);
    freq.put("esp", 114);
    freq.put("nd ", 207);
    freq.put("Co ", 3);
    freq.put("rşi", 10);
    freq.put("ese", 65);
    freq.put("esc", 235);
    freq.put("esa", 75);
    freq.put("eso", 14);
    freq.put("esi", 59);
    freq.put("esh", 4);
    freq.put("nda", 92);
    freq.put("RO ", 15);
    freq.put("lle", 21);
    freq.put("ml ", 4);
    freq.put("găs", 9);
    freq.put("Ur", 21);
    freq.put("vs ", 6);
    freq.put("Ul", 21);
    freq.put("Un", 103);
    freq.put("Ui", 4);
    freq.put("mir", 21);
    freq.put("Ud", 10);
    freq.put("LL ", 3);
    freq.put(" ha", 36);
    freq.put("Uc", 3);
    freq.put("Ub", 3);
    freq.put("ăti", 4);
    freq.put("Sco", 4);
    freq.put("ndj", 3);
    freq.put("Sch", 10);
    freq.put("ndo", 14);
    freq.put("alc", 30);
    freq.put(" ju", 67);
    freq.put("Sca", 8);
    freq.put("nos", 29);
    freq.put(" jr", 3);
    freq.put(" jo", 62);
    freq.put("apo", 37);
    freq.put("Sau", 6);
    freq.put("es ", 78);
    freq.put("Scu", 3);
    freq.put("esă", 3);
    freq.put("ndr", 54);
    freq.put(" ja", 9);
    freq.put("şu", 7);
    freq.put("ină", 24);
    freq.put("aţă", 23);
    freq.put("duc", 81);
    freq.put("owe", 5);
    freq.put("ea ", 765);
    freq.put("Act", 14);
    freq.put("ubl", 48);
    freq.put("De ", 53);
    freq.put("h ", 90);
    freq.put("ows", 9);
    freq.put("ţia", 60);
    freq.put("vai", 6);
    freq.put("van", 75);
    freq.put("ţur", 7);
    freq.put("Amo", 3);
    freq.put("Te ", 8);
    freq.put("vac", 15);
    freq.put("ucu", 89);
    freq.put("Amb", 4);
    freq.put("Ame", 9);
    freq.put("xul", 13);
    freq.put("vad", 25);
    freq.put("ubi", 29);
    freq.put("Amy", 3);
    freq.put("Lux", 3);
    freq.put("rch", 13);
    freq.put("rci", 44);
    freq.put("CU ", 3);
    freq.put("var", 63);
    freq.put("pf", 5);
    freq.put("ţum", 6);
    freq.put("ţul", 8);
    freq.put("veţ", 7);
    freq.put("rca", 59);
    freq.put("vat", 46);
    freq.put("eai", 15);
    freq.put("Vă ", 5);
    freq.put("Dez", 5);
    freq.put("hy", 3);
    freq.put("eam", 62);
    freq.put("xan", 12);
    freq.put("Bă", 31);
    freq.put("hr", 13);
    freq.put("bus", 5);
    freq.put("eac", 29);
    freq.put("Des", 28);
    freq.put("Det", 4);
    freq.put("ead", 7);
    freq.put("ht", 17);
    freq.put("hu", 21);
    freq.put("hi", 346);
    freq.put("hn", 21);
    freq.put("ho", 103);
    freq.put("hl", 3);
    freq.put("hm", 5);
    freq.put("eap", 24);
    freq.put("Deb", 3);
    freq.put("ha", 130);
    freq.put("eau", 56);
    freq.put("ieţ", 3);
    freq.put("he", 179);
    freq.put("aju", 72);
    freq.put("xac", 6);
    freq.put("Tel", 11);
    freq.put("Ten", 7);
    freq.put("Teo", 3);
    freq.put("avi", 32);
    freq.put("Tea", 10);
    freq.put("va ", 279);
    freq.put("j", 427);
    freq.put("ăr", 166);
    freq.put("ai ", 656);
    freq.put("lve", 14);
    freq.put("Luc", 9);
    freq.put("lva", 19);
    freq.put("Ter", 12);
    freq.put("rc ", 9);
    freq.put(" Ţo", 4);
    freq.put("ID ", 3);
    freq.put("pii", 20);
    freq.put("ucr", 45);
    freq.put("inz", 4);
    freq.put("pio", 16);
    freq.put("int", 408);
    freq.put("inu", 109);
    freq.put("inv", 55);
    freq.put("pic", 31);
    freq.put("Don", 3);
    freq.put("pie", 63);
    freq.put("inr", 4);
    freq.put("ins", 82);
    freq.put("inl", 6);
    freq.put("lm ", 6);
    freq.put("inn", 6);
    freq.put("ino", 24);
    freq.put("ub ", 30);
    freq.put("ini", 155);
    freq.put("ink", 13);
    freq.put("ind", 105);
    freq.put("ine", 484);
    freq.put("inf", 31);
    freq.put("ing", 111);
    freq.put("pit", 34);
    freq.put("ina", 234);
    freq.put("inc", 165);
    freq.put("hn ", 6);
    freq.put("eo ", 41);
    freq.put("zvo", 8);
    freq.put("oan", 77);
    freq.put("zva", 9);
    freq.put(" € ", 4);
    freq.put(" Ur", 21);
    freq.put("Lum", 5);
    freq.put(" Ul", 21);
    freq.put(" Un", 103);
    freq.put("oat", 116);
    freq.put("oas", 75);
    freq.put(" Ui", 4);
    freq.put("oap", 33);
    freq.put(" Ud", 10);
    freq.put("esf", 6);
    freq.put("UL ", 13);
    freq.put("gau", 4);
    freq.put(" Ub", 3);
    freq.put(" Uc", 3);
    freq.put("Acc", 11);
    freq.put("ubu", 9);
    freq.put("Aca", 5);
    freq.put("DA ", 6);
    freq.put("Ace", 3);
    freq.put("ubs", 5);
    freq.put("pi ", 9);
    freq.put("gas", 32);
    freq.put("Ach", 8);
    freq.put("Aco", 5);
    freq.put("lal", 8);
    freq.put("gar", 30);
    freq.put("ube", 13);
    freq.put("U", 224);
    freq.put("uba", 5);
    freq.put("Acu", 9);
    freq.put("â¦", 4);
    freq.put("hâ", 3);
    freq.put("my ", 11);
    freq.put("N", 341);
    freq.put("in ", 1100);
    freq.put(" gu", 19);
    freq.put("eoc", 18);
    freq.put("CI ", 5);
    freq.put("enr", 3);
    freq.put("cid", 22);
    freq.put("eod", 10);
    freq.put("hni", 6);
    freq.put("big", 3);
    freq.put("eon", 5);
    freq.put("eol", 3);
    freq.put("eor", 27);
    freq.put("eop", 3);
    freq.put("ăta", 18);
    freq.put("eot", 3);
    freq.put("uţi", 34);
    freq.put(" U ", 3);
    freq.put("rep", 63);
  }
  
}

