package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class RU {
  private static final String name = "ru";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public RU() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 509415;
    n_words[1] = 599306;
    n_words[2] = 489415;

    freq.put("Вик", 11);
    freq.put("Вид", 32);
    freq.put("пок", 208);
    freq.put("пол", 458);
    freq.put("пои", 27);
    freq.put("пой", 80);
    freq.put("поо", 14);
    freq.put("поп", 106);
    freq.put("пом", 258);
    freq.put("пон", 208);
    freq.put("пов", 133);
    freq.put("пог", 85);
    freq.put("поб", 46);
    freq.put("пож", 60);
    freq.put("поз", 166);
    freq.put("под", 431);
    freq.put("пое", 60);
    freq.put("пош", 25);
    freq.put("че ", 118);
    freq.put("поя", 48);
    freq.put("поэ", 21);
    freq.put("пот", 203);
    freq.put("пор", 253);
    freq.put("пос", 450);
    freq.put("поц", 11);
    freq.put("поч", 144);
    freq.put("пох", 185);
    freq.put("ею ", 22);
    freq.put(" Аа", 9);
    freq.put("со ", 91);
    freq.put("Вит", 16);
    freq.put(" Ай", 12);
    freq.put("ей ", 677);
    freq.put(" Ам", 16);
    freq.put("НЕ ", 60);
    freq.put("смы", 16);
    freq.put("сму", 7);
    freq.put("смс", 17);
    freq.put("смо", 454);
    freq.put("сми", 7);
    freq.put("сме", 99);
    freq.put("сма", 34);
    freq.put("езл", 13);
    freq.put("ези", 41);
    freq.put("езо", 74);
    freq.put("езн", 85);
    freq.put("езв", 11);
    freq.put("еза", 46);
    freq.put("езж", 26);
    freq.put("вчо", 8);
    freq.put("езд", 97);
    freq.put("ам ", 461);
    freq.put("Ю", 59);
    freq.put("умо", 12);
    freq.put("чёт", 8);
    freq.put("уми", 20);
    freq.put("уме", 83);
    freq.put("езу", 48);
    freq.put("Ве", 80);
    freq.put("ьны", 263);
    freq.put("Ва", 134);
    freq.put("Вн", 13);
    freq.put("Во", 165);
    freq.put("Вп", 11);
    freq.put("Ви", 73);
    freq.put("Вк", 9);
    freq.put("Вл", 27);
    freq.put("Ско", 42);
    freq.put("аоб", 7);
    freq.put("обу", 76);
    freq.put("Е ", 208);
    freq.put("Отл", 11);
    freq.put("Отк", 14);
    freq.put("Вч", 12);
    freq.put("Вр", 16);
    freq.put("Вс", 146);
    freq.put("Вт", 7);
    freq.put("Вь", 29);
    freq.put("Отв", 13);
    freq.put("Отб", 86);
    freq.put("Отз", 7);
    freq.put("ьне", 18);
    freq.put("Оте", 9);
    freq.put("Вы", 109);
    freq.put("оо ", 36);
    freq.put("Ш ", 7);
    freq.put("За ", 17);
    freq.put("ня ", 709);
    freq.put(" Яп", 8);
    freq.put(" Ян", 20);
    freq.put("омб", 40);
    freq.put("ома", 274);
    freq.put("оме", 198);
    freq.put("оми", 116);
    freq.put("омк", 14);
    freq.put("омн", 108);
    freq.put("омм", 34);
    freq.put("омп", 101);
    freq.put("омо", 303);
    freq.put("тиш", 16);
    freq.put("тия", 67);
    freq.put("тис", 23);
    freq.put("тир", 85);
    freq.put("тит", 313);
    freq.put("тих", 39);
    freq.put("тич", 105);
    freq.put("тиц", 9);
    freq.put("тий", 26);
    freq.put("тии", 20);
    freq.put("тил", 127);
    freq.put("тик", 205);
    freq.put("тин", 183);
    freq.put("тим", 98);
    freq.put("тип", 34);
    freq.put("тиг", 14);
    freq.put("тив", 205);
    freq.put("тие", 48);
    freq.put("тиз", 21);
    freq.put("тиж", 24);
    freq.put("омс", 223);
    freq.put("ому", 233);
    freq.put("Зве", 7);
    freq.put("омы", 36);
    freq.put("омя", 24);
    freq.put("ЕТ ", 33);
    freq.put("ыг", 65);
    freq.put("ыв", 358);
    freq.put("ыб", 109);
    freq.put("ыз", 26);
    freq.put("ыж", 83);
    freq.put("ые", 825);
    freq.put("ыд", 66);
    freq.put("ыл", 399);
    freq.put("ык", 158);
    freq.put("ый", 993);
    freq.put("ыи", 8);
    freq.put("ып", 116);
    freq.put("ын", 82);
    freq.put("ым", 335);
    freq.put("зет", 20);
    freq.put("зер", 87);
    freq.put("зец", 8);
    freq.put("ю ", 1446);
    freq.put("зей", 28);
    freq.put("зен", 25);
    freq.put("зем", 81);
    freq.put("ыу", 9);
    freq.put("ыт", 277);
    freq.put("ыс", 232);
    freq.put("ыр", 93);
    freq.put("ыч", 51);
    freq.put("ых", 648);
    freq.put("ыы", 7);
    freq.put("ыщ", 153);
    freq.put("ыш", 156);
    freq.put("ляй", 7);
    freq.put("лял", 25);
    freq.put("лян", 36);
    freq.put("лям", 26);
    freq.put("ляп", 7);
    freq.put("ляб", 14);
    freq.put("ляе", 69);
    freq.put("ляд", 57);
    freq.put("ии ", 719);
    freq.put("Тол", 45);
    freq.put("Том", 10);
    freq.put("Тог", 8);
    freq.put("х", 4615);
    freq.put("Тот", 12);
    freq.put("юте", 29);
    freq.put("яяя", 17);
    freq.put("ыл ", 86);
    freq.put("уща", 10);
    freq.put("ляя", 7);
    freq.put("ляю", 61);
    freq.put("ляр", 22);
    freq.put("лят", 102);
    freq.put("лях", 7);
    freq.put("чет", 145);
    freq.put("чес", 366);
    freq.put("чер", 274);
    freq.put("по ", 551);
    freq.put("чеш", 39);
    freq.put("соф", 11);
    freq.put("сох", 18);
    freq.put("соц", 29);
    freq.put("соч", 28);
    freq.put("сор", 57);
    freq.put("сос", 74);
    freq.put("сот", 30);
    freq.put("сою", 17);
    freq.put("сод", 10);
    freq.put("сое", 14);
    freq.put("сож", 8);
    freq.put("соз", 49);
    freq.put("соб", 474);
    freq.put("сов", 288);
    freq.put("сог", 23);
    freq.put("сом", 30);
    freq.put("сон", 53);
    freq.put("соо", 49);
    freq.put("соп", 13);
    freq.put("сок", 94);
    freq.put("сол", 48);
    freq.put("чег", 108);
    freq.put("чев", 18);
    freq.put("чеб", 51);
    freq.put("чел", 182);
    freq.put("чек", 49);
    freq.put("чей", 23);
    freq.put("чен", 558);
    freq.put("чем", 277);
    freq.put("ть ", 3491);
    freq.put("ейб", 7);
    freq.put("ейд", 10);
    freq.put("ейл", 22);
    freq.put("ейк", 23);
    freq.put("ейн", 42);
    freq.put("ейм", 9);
    freq.put("ейп", 8);
    freq.put("тье", 46);
    freq.put("ТЕ ", 17);
    freq.put("тья", 38);
    freq.put("тью", 36);
    freq.put("их ", 475);
    freq.put("тьс", 324);
    freq.put("нюк", 8);
    freq.put("ейс", 87);
    freq.put("ейт", 32);
    freq.put("ейч", 83);
    freq.put("ейш", 13);
    freq.put("ёб", 10);
    freq.put("мын", 9);
    freq.put("ез ", 307);
    freq.put("ёз", 12);
    freq.put("ьтр", 9);
    freq.put("арс", 68);
    freq.put("аме", 199);
    freq.put("Сде", 7);
    freq.put("амб", 19);
    freq.put("ама", 135);
    freq.put("амп", 23);
    freq.put("амо", 151);
    freq.put("амн", 21);
    freq.put("амм", 101);
    freq.put("амк", 11);
    freq.put("ами", 404);
    freq.put("аму", 34);
    freq.put("амс", 18);
    freq.put("амя", 12);
    freq.put("ён", 26);
    freq.put("амы", 99);
    freq.put("ём", 29);
    freq.put("ьга", 11);
    freq.put("ьги", 36);
    freq.put("арв", 7);
    freq.put("В ", 340);
    freq.put("ьте", 35);
    freq.put("ао ", 13);
    freq.put("Ещ", 15);
    freq.put("Обе", 8);
    freq.put("Обл", 7);
    freq.put("Обо", 7);
    freq.put("с", 25224);
    freq.put("Обр", 7);
    freq.put("нше", 9);
    freq.put("Ел", 8);
    freq.put("Ед", 12);
    freq.put("Общ", 8);
    freq.put("Еб", 9);
    freq.put("Ег", 12);
    freq.put("Ев", 37);
    freq.put("От ", 7);
    freq.put("ённ", 9);
    freq.put("ёно", 7);
    freq.put(" Эм", 8);
    freq.put("Зах", 9);
    freq.put("Зач", 11);
    freq.put("Зар", 11);
    freq.put("МЫ ", 10);
    freq.put(" Эл", 20);
    freq.put("ооп", 7);
    freq.put("ооо", 66);
    freq.put("тку", 33);
    freq.put("ткр", 87);
    freq.put("ооб", 146);
    freq.put("Шк", 10);
    freq.put("Шл", 8);
    freq.put("Ши", 10);
    freq.put("Шо", 14);
    freq.put("тка", 114);
    freq.put("Шв", 7);
    freq.put("тко", 40);
    freq.put("Ша", 20);
    freq.put("ткл", 11);
    freq.put("оот", 17);
    freq.put("оор", 7);
    freq.put("езе", 35);
    freq.put(" Эф", 8);
    freq.put("Зап", 20);
    freq.put(" Эс", 9);
    freq.put(" Эт", 91);
    freq.put("Зад", 18);
    freq.put("Япо", 8);
    freq.put("Заб", 14);
    freq.put("Зав", 34);
    freq.put("Заг", 15);
    freq.put(" Я ", 512);
    freq.put("нял", 52);
    freq.put("няк", 15);
    freq.put("няй", 13);
    freq.put("З", 429);
    freq.put("ням", 10);
    freq.put("няе", 23);
    freq.put("ом ", 996);
    freq.put("ти ", 662);
    freq.put("няш", 24);
    freq.put("няя", 38);
    freq.put("няю", 17);
    freq.put("нят", 116);
    freq.put("нях", 11);
    freq.put("Экс", 19);
    freq.put("СЕ ", 20);
    freq.put("дек", 35);
    freq.put("ы ", 3229);
    freq.put("дем", 70);
    freq.put("ден", 514);
    freq.put("део", 178);
    freq.put("деп", 25);
    freq.put("деа", 13);
    freq.put("деб", 16);
    freq.put("дев", 178);
    freq.put("дед", 7);
    freq.put("дее", 12);
    freq.put("деж", 37);
    freq.put("цио", 69);
    freq.put("ций", 32);
    freq.put("ции", 261);
    freq.put("юш", 24);
    freq.put("ющ", 127);
    freq.put("мец", 15);
    freq.put("юю", 17);
    freq.put("юр", 40);
    freq.put("юс", 154);
    freq.put("ют", 450);
    freq.put("цик", 7);
    freq.put("юх", 52);
    freq.put("юц", 13);
    freq.put("юч", 90);
    freq.put("Таб", 10);
    freq.put("меш", 62);
    freq.put("вся", 23);
    freq.put("Тай", 8);
    freq.put("Так", 66);
    freq.put("Тан", 13);
    freq.put("Там", 20);
    freq.put("япо", 7);
    freq.put("циа", 77);
    freq.put("юк", 29);
    freq.put("зе ", 23);
    freq.put("юм", 34);
    freq.put("юн", 47);
    freq.put("юб", 350);
    freq.put("юг", 13);
    freq.put("юд", 189);
    freq.put("юж", 7);
    freq.put("юз", 32);
    freq.put("деш", 66);
    freq.put("узы", 58);
    freq.put("узь", 28);
    freq.put("дею", 29);
    freq.put("дея", 33);
    freq.put("дер", 159);
    freq.put("дес", 79);
    freq.put("дет", 472);
    freq.put("дец", 47);
    freq.put("ыль", 14);
    freq.put("яя ", 49);
    freq.put("иии", 47);
    freq.put("ужн", 87);
    freq.put("ля ", 963);
    freq.put("джи", 25);
    freq.put("ужи", 79);
    freq.put("Чит", 7);
    freq.put("дже", 37);
    freq.put("ёт", 53);
    freq.put("ужд", 31);
    freq.put("ужа", 48);
    freq.put("ка ", 1009);
    freq.put("ужб", 17);
    freq.put("дз ", 12);
    freq.put("эп ", 9);
    freq.put("ыло", 136);
    freq.put("ыли", 50);
    freq.put("ылк", 22);
    freq.put("ыле", 26);
    freq.put("ыла", 61);
    freq.put("ког", 441);
    freq.put("ков", 479);
    freq.put("коб", 13);
    freq.put("коз", 209);
    freq.put("кож", 12);
    freq.put("кое", 125);
    freq.put("код", 18);
    freq.put("кол", 354);
    freq.put("кок", 8);
    freq.put("кой", 381);
    freq.put("коп", 64);
    freq.put("коо", 12);
    freq.put("кон", 580);
    freq.put("ком", 768);
    freq.put("ик ", 283);
    freq.put("ящи", 44);
    freq.put("яще", 19);
    freq.put("яща", 12);
    freq.put("от ", 667);
    freq.put("ия ", 1290);
    freq.put("кот", 251);
    freq.put("Игр", 30);
    freq.put("лба", 14);
    freq.put("коф", 13);
    freq.put("эне", 16);
    freq.put("энд", 11);
    freq.put("дбо", 11);
    freq.put("кош", 25);
    freq.put("имп", 41);
    freq.put("имо", 150);
    freq.put("имн", 37);
    freq.put("имк", 12);
    freq.put("ими", 152);
    freq.put("име", 131);
    freq.put("има", 207);
    freq.put("Для", 19);
    freq.put("ыпу", 41);
    freq.put("орь", 21);
    freq.put("оря", 80);
    freq.put("орю", 17);
    freq.put("орщ", 7);
    freq.put("оры", 189);
    freq.put("орч", 19);
    freq.put("орц", 9);
    freq.put("орс", 60);
    freq.put("орр", 89);
    freq.put("ору", 113);
    freq.put("орт", 139);
    freq.put("исы", 12);
    freq.put("ись", 150);
    freq.put("ися", 7);
    freq.put("исс", 35);
    freq.put("ист", 500);
    freq.put("ису", 27);
    freq.put("исх", 25);
    freq.put("иси", 35);
    freq.put("иск", 124);
    freq.put("исл", 48);
    freq.put("Це", 25);
    freq.put("исо", 117);
    freq.put("исп", 55);
    freq.put("иса", 220);
    freq.put("исе", 26);
    freq.put("орн", 88);
    freq.put("орм", 222);
    freq.put("орп", 13);
    freq.put("оро", 876);
    freq.put("ори", 260);
    freq.put("орк", 51);
    freq.put("оре", 109);
    freq.put("орд", 39);
    freq.put("орж", 17);
    freq.put("орб", 15);
    freq.put("ора", 204);
    freq.put("орг", 64);
    freq.put("орв", 15);
    freq.put("ыпи", 9);
    freq.put("ыпл", 7);
    freq.put("ыпо", 21);
    freq.put("ыпа", 29);
    freq.put("имя", 9);
    freq.put("имы", 40);
    freq.put("имф", 8);
    freq.put("иму", 31);
    freq.put("имс", 34);
    freq.put("Вз", 14);
    freq.put("пка", 8);
    freq.put("пко", 9);
    freq.put("пки", 14);
    freq.put("зут", 7);
    freq.put("ьну", 13);
    freq.put("зуч", 7);
    freq.put("зуб", 234);
    freq.put("ее ", 291);
    freq.put("ст ", 166);
    freq.put("ьч", 30);
    freq.put("ьф", 14);
    freq.put("ьт", 143);
    freq.put("ьс", 509);
    freq.put("ью", 248);
    freq.put("ья", 198);
    freq.put("рга", 84);
    freq.put("ьш", 349);
    freq.put("рге", 55);
    freq.put("ебк", 8);
    freq.put("ьё", 10);
    freq.put("мед", 65);
    freq.put("зул", 22);
    freq.put("щ", 1581);
    freq.put("зум", 24);
    freq.put("ьз", 95);
    freq.put("ьд", 16);
    freq.put("юк ", 8);
    freq.put("ьв", 17);
    freq.put("ьг", 51);
    freq.put("ьб", 61);
    freq.put("ьо", 11);
    freq.put("ргу", 11);
    freq.put("ьм", 183);
    freq.put("ьн", 805);
    freq.put("ьк", 419);
    freq.put("ьи", 27);
    freq.put("вск", 170);
    freq.put("цир", 8);
    freq.put("еч", 649);
    freq.put("егу", 20);
    freq.put("вук", 16);
    freq.put("егр", 12);
    freq.put("вуе", 19);
    freq.put("егэ", 8);
    freq.put("я ", 7055);
    freq.put("Был", 7);
    freq.put("Быв", 8);
    freq.put("еше", 94);
    freq.put("сро", 27);
    freq.put("еша", 47);
    freq.put("ешо", 7);
    freq.put("сра", 54);
    freq.put("ешн", 57);
    freq.put("ешк", 17);
    freq.put("еши", 45);
    freq.put("сре", 71);
    freq.put("тч ", 21);
    freq.put("ешь", 281);
    freq.put("Ска", 80);
    freq.put("вую", 70);
    freq.put("егд", 80);
    freq.put("вуш", 84);
    freq.put("ега", 51);
    freq.put("его", 704);
    freq.put("вуч", 10);
    freq.put("егк", 28);
    freq.put("вут", 9);
    freq.put("еги", 86);
    freq.put("П", 1405);
    freq.put("Соб", 20);
    freq.put("Сов", 24);
    freq.put("Чел", 23);
    freq.put("Сол", 9);
    freq.put("Соц", 11);
    freq.put("хха", 17);
    freq.put("учш", 166);
    freq.put(" б ", 17);
    freq.put("Аме", 9);
    freq.put("ов ", 1087);
    freq.put("КО ", 7);
    freq.put(" гл", 131);
    freq.put(" ги", 50);
    freq.put(" го", 703);
    freq.put(" гн", 8);
    freq.put(" га", 89);
    freq.put(" гд", 81);
    freq.put(" ге", 70);
    freq.put("ны ", 374);
    freq.put("оан", 9);
    freq.put("ьни", 73);
    freq.put("ьно", 352);
    freq.put("Зол", 10);
    freq.put("ьна", 77);
    freq.put("це ", 100);
    freq.put("рс ", 24);
    freq.put("шёл", 11);
    freq.put("ыть", 115);
    freq.put(" гу", 62);
    freq.put(" гр", 691);
    freq.put("Отд", 9);
    freq.put("ике", 62);
    freq.put("ика", 444);
    freq.put("икн", 13);
    freq.put("ико", 553);
    freq.put("ики", 296);
    freq.put("икл", 24);
    freq.put("ко ", 499);
    freq.put("оты", 183);
    freq.put("отя", 56);
    freq.put("оть", 56);
    freq.put("оту", 45);
    freq.put("отт", 15);
    freq.put("отс", 29);
    freq.put("отр", 348);
    freq.put("отч", 18);
    freq.put("отц", 7);
    freq.put("иях", 43);
    freq.put("ият", 55);
    freq.put("иям", 33);
    freq.put("иян", 15);
    freq.put("отл", 53);
    freq.put("отк", 169);
    freq.put("оти", 126);
    freq.put("отп", 50);
    freq.put("ото", 616);
    freq.put("отн", 99);
    freq.put("отм", 24);
    freq.put("отв", 92);
    freq.put("отб", 144);
    freq.put("ота", 147);
    freq.put("отз", 44);
    freq.put("ХА ", 14);
    freq.put("отд", 64);
    freq.put("ыне", 12);
    freq.put("ына", 9);
    freq.put("ыно", 17);
    freq.put("эн ", 7);
    freq.put("ыни", 8);
    freq.put("икс", 42);
    freq.put("икр", 26);
    freq.put("ику", 71);
    freq.put("икт", 49);
    freq.put("Л", 481);
    freq.put("им ", 333);
    freq.put("пин", 41);
    freq.put("пио", 29);
    freq.put("пик", 16);
    freq.put("пил", 77);
    freq.put("пид", 21);
    freq.put("пиз", 50);
    freq.put("пиа", 21);
    freq.put("пив", 23);
    freq.put("пия", 17);
    freq.put("пиш", 63);
    freq.put("пищ", 12);
    freq.put("пиц", 9);
    freq.put("пич", 18);
    freq.put("пир", 40);
    freq.put("пис", 342);
    freq.put("пит", 178);
    freq.put("Ц ", 10);
    freq.put("ис ", 46);
    freq.put("ытк", 8);
    freq.put("ыкл", 7);
    freq.put("Ман", 10);
    freq.put("Мам", 17);
    freq.put("Мал", 18);
    freq.put("Мак", 14);
    freq.put("Маз", 7);
    freq.put("рба", 32);
    freq.put("КУ ", 8);
    freq.put("рби", 10);
    freq.put("рбу", 52);
    freq.put("Маш", 10);
    freq.put("Мат", 11);
    freq.put("Мас", 12);
    freq.put("Мар", 28);
    freq.put("еем", 8);
    freq.put("вхо", 15);
    freq.put("еее", 72);
    freq.put("еев", 12);
    freq.put("Нью", 7);
    freq.put("ста", 953);
    freq.put("ств", 835);
    freq.put("сте", 296);
    freq.put("сти", 784);
    freq.put("рг ", 33);
    freq.put("стл", 29);
    freq.put("стн", 116);
    freq.put("сто", 744);
    freq.put("стр", 834);
    freq.put("до", 1777);
    freq.put("сту", 137);
    freq.put("ь ", 6101);
    freq.put("сты", 91);
    freq.put("сть", 540);
    freq.put("стю", 9);
    freq.put("стя", 42);
    freq.put("дн", 1132);
    freq.put("ГЭ ", 17);
    freq.put("Дже", 17);
    freq.put("еер", 11);
    freq.put("еет", 25);
    freq.put("йка", 25);
    freq.put("де", 2944);
    freq.put("йки", 20);
    freq.put("йко", 13);
    freq.put("Джа", 7);
    freq.put("яп", 14);
    freq.put("ян", 259);
    freq.put("ям", 181);
    freq.put("ял", 129);
    freq.put("як", 101);
    freq.put("яй", 39);
    freq.put("яи", 8);
    freq.put("яз", 145);
    freq.put("яж", 40);
    freq.put("яе", 109);
    freq.put("яд", 285);
    freq.put("ву ", 77);
    freq.put("яв", 155);
    freq.put("яб", 58);
    freq.put("Сиж", 7);
    freq.put("еш ", 7);
    freq.put("ую ", 292);
    freq.put("ДИ ", 13);
    freq.put("Сир", 17);
    freq.put("яя", 75);
    freq.put("яю", 89);
    freq.put("ящ", 79);
    freq.put("Исп", 16);
    freq.put("яч", 58);
    freq.put("яц", 38);
    freq.put("ях", 87);
    freq.put("ят", 778);
    freq.put("яс", 73);
    freq.put("яр", 79);
    freq.put("йку", 7);
    freq.put(" © ", 11);
    freq.put("дю", 17);
    freq.put("дэ", 15);
    freq.put(" ба", 229);
    freq.put(" бе", 625);
    freq.put(" би", 132);
    freq.put(" бл", 237);
    freq.put(" бо", 550);
    freq.put("овл", 73);
    freq.put("овк", 102);
    freq.put("дх", 12);
    freq.put("ово", 599);
    freq.put("овн", 121);
    freq.put("овм", 13);
    freq.put("овг", 14);
    freq.put("ова", 776);
    freq.put("ове", 629);
    freq.put("в", 19991);
    freq.put("овы", 238);
    freq.put("овщ", 9);
    freq.put("овь", 99);
    freq.put("ову", 65);
    freq.put("овт", 16);
    freq.put("овс", 169);
    freq.put("овр", 27);
    freq.put("овц", 8);
    freq.put(" бр", 139);
    freq.put(" бу", 440);
    freq.put(" бы", 593);
    freq.put(" бь", 10);
    freq.put("ные", 466);
    freq.put("нын", 7);
    freq.put("ным", 205);
    freq.put("ный", 600);
    freq.put("ьчи", 29);
    freq.put(" г ", 100);
    freq.put("цер", 35);
    freq.put("цес", 14);
    freq.put("цев", 83);
    freq.put("цеп", 55);
    freq.put("цем", 9);
    freq.put("цен", 207);
    freq.put("цел", 60);
    freq.put("цей", 18);
    freq.put("рса", 22);
    freq.put("ных", 292);
    freq.put("рсе", 26);
    freq.put("рси", 51);
    freq.put("рск", 141);
    freq.put("рсо", 23);
    freq.put(" ем", 51);
    freq.put("Наз", 12);
    freq.put("Над", 29);
    freq.put("Нав", 14);
    freq.put(" ей", 21);
    freq.put(" ек", 16);
    freq.put("Наб", 9);
    freq.put(" ед", 190);
    freq.put("Нап", 12);
    freq.put("Нам", 9);
    freq.put(" ез", 10);
    freq.put("Нак", 11);
    freq.put(" еб", 31);
    freq.put(" ев", 31);
    freq.put("Най", 15);
    freq.put("оже", 662);
    freq.put("ожд", 105);
    freq.put("фор", 145);
    freq.put("ожа", 230);
    freq.put("ожн", 275);
    freq.put("ожк", 19);
    freq.put("ожи", 95);
    freq.put("Да ", 42);
    freq.put("Л ", 37);
    freq.put("ЕМ ", 17);
    freq.put("ям ", 64);
    freq.put("ожу", 22);
    freq.put("фон", 164);
    freq.put("ру ", 135);
    freq.put("ожь", 13);
    freq.put(" её", 26);
    freq.put("фол", 19);
    freq.put("Нач", 9);
    freq.put("Нах", 7);
    freq.put("Нат", 8);
    freq.put(" ещ", 251);
    freq.put("Нар", 21);
    freq.put("Нас", 25);
    freq.put(" ех", 11);
    freq.put(" ес", 288);
    freq.put("Наш", 19);
    freq.put("аса", 61);
    freq.put("асе", 39);
    freq.put("аси", 198);
    freq.put("аск", 73);
    freq.put("асл", 44);
    freq.put("асн", 174);
    freq.put("асо", 49);
    freq.put("асп", 141);
    freq.put("эд", 7);
    freq.put("шиб", 24);
    freq.put("жра", 9);
    freq.put("шие", 45);
    freq.put("эв", 11);
    freq.put("АЙ ", 7);
    freq.put("эм", 25);
    freq.put("эп", 20);
    freq.put("эй", 41);
    freq.put("эл", 85);
    freq.put("эк", 151);
    freq.put("гир", 8);
    freq.put("гис", 66);
    freq.put("гит", 16);
    freq.put("гих", 14);
    freq.put("гич", 40);
    freq.put("мча", 7);
    freq.put("гия", 36);
    freq.put("ури", 57);
    freq.put("гиб", 30);
    freq.put("гие", 36);
    freq.put("гии", 27);
    freq.put("гий", 8);
    freq.put("гик", 8);
    freq.put("гил", 12);
    freq.put("гим", 13);
    freq.put("гин", 35);
    freq.put("гио", 16);
    freq.put("гип", 16);
    freq.put("эх", 12);
    freq.put("эф", 27);
    freq.put("шис", 13);
    freq.put("шир", 78);
    freq.put("эс", 18);
    freq.put("эр", 45);
    freq.put("ших", 66);
    freq.put("эт", 728);
    freq.put("ээ", 19);
    freq.put("шиш", 7);
    freq.put("аср", 7);
    freq.put("асс", 405);
    freq.put("рхо", 7);
    freq.put("асу", 9);
    freq.put("рхи", 9);
    freq.put("асх", 8);
    freq.put("асч", 16);
    freq.put("асш", 75);
    freq.put("асы", 30);
    freq.put("ась", 176);
    freq.put("кко", 8);
    freq.put("ург", 105);
    freq.put("лещ", 7);
    freq.put("леш", 7);
    freq.put("леч", 149);
    freq.put("лец", 10);
    freq.put("кке", 11);
    freq.put("леф", 94);
    freq.put("лет", 348);
    freq.put("лес", 48);
    freq.put("лер", 55);
    freq.put(" рэ", 7);
    freq.put("Тим", 7);
    freq.put("зга", 15);
    freq.put("зги", 7);
    freq.put("згл", 26);
    freq.put("зго", 25);
    freq.put("ио ", 13);
    freq.put("чуж", 13);
    freq.put("леп", 25);
    freq.put("лен", 442);
    freq.put("лем", 83);
    freq.put("лел", 14);
    freq.put("лек", 184);
    freq.put("лей", 137);
    freq.put("лез", 90);
    freq.put("леж", 22);
    freq.put("лее", 71);
    freq.put("лед", 145);
    freq.put("лег", 67);
    freq.put("лев", 81);
    freq.put("леб", 18);
    freq.put("иат", 13);
    freq.put("иар", 17);
    freq.put("иац", 9);
    freq.put(" Вч", 12);
    freq.put(" Вс", 146);
    freq.put(" Вр", 16);
    freq.put(" Вт", 7);
    freq.put(" Вь", 29);
    freq.put(" Вы", 109);
    freq.put("офт", 10);
    freq.put("офи", 85);
    freq.put("офо", 25);
    freq.put("офе", 38);
    freq.put(" Ве", 80);
    freq.put(" Вз", 14);
    freq.put(" Ва", 134);
    freq.put(" Вн", 13);
    freq.put(" Вп", 10);
    freq.put(" Во", 165);
    freq.put(" Ви", 73);
    freq.put(" Вл", 27);
    freq.put(" Вк", 9);
    freq.put("иал", 134);
    freq.put("иак", 8);
    freq.put("уры", 29);
    freq.put("иан", 45);
    freq.put("иаг", 10);
    freq.put("иаб", 64);
    freq.put("иаз", 16);
    freq.put("иад", 7);
    freq.put("Ищ", 14);
    freq.put("ТП ", 15);
    freq.put("Ир", 26);
    freq.put("Ис", 41);
    freq.put("хор", 187);
    freq.put("хот", 132);
    freq.put("хох", 9);
    freq.put("хоч", 180);
    freq.put("уру", 12);
    freq.put(" ?", 65);
    freq.put("иха", 16);
    freq.put("ихо", 73);
    freq.put("ре ", 184);
    freq.put("Тра", 8);
    freq.put("Тре", 12);
    freq.put("иху", 17);
    freq.put("Три", 8);
    freq.put("Тро", 7);
    freq.put("хов", 38);
    freq.put("ход", 339);
    freq.put("ЖЕ ", 20);
    freq.put("хоз", 14);
    freq.put("хой", 8);
    freq.put("хок", 12);
    freq.put("хол", 62);
    freq.put("хом", 34);
    freq.put("хон", 18);
    freq.put("Ил", 23);
    freq.put("Им", 13);
    freq.put("Ин", 89);
    freq.put("Ив", 10);
    freq.put("Иг", 38);
    freq.put("Из", 31);
    freq.put("Ид", 13);
    freq.put("Мон", 7);
    freq.put("Мой", 16);
    freq.put("Мол", 32);
    freq.put("Мое", 22);
    freq.put("Мод", 8);
    freq.put("Мож", 60);
    freq.put("де ", 270);
    freq.put("уз ", 8);
    freq.put("ец ", 134);
    freq.put("ме ", 90);
    freq.put("Ё ", 14);
    freq.put("еб ", 19);
    freq.put("Моя", 16);
    freq.put("Мос", 61);
    freq.put("Мор", 18);
    freq.put("ои", 589);
    freq.put("вящ", 9);
    freq.put("ок", 1255);
    freq.put("ол", 3054);
    freq.put("ом", 2816);
    freq.put("он", 2597);
    freq.put("оо", 316);
    freq.put("оп", 825);
    freq.put("оа", 30);
    freq.put("об", 1979);
    freq.put("вят", 43);
    freq.put("ог", 2207);
    freq.put("од", 2762);
    freq.put("ое", 1068);
    freq.put("ож", 1453);
    freq.put("оз", 874);
    freq.put("ефа", 7);
    freq.put("сфа", 7);
    freq.put("ефе", 16);
    freq.put("ефи", 7);
    freq.put("ефо", 100);
    freq.put("к", 19948);
    freq.put("ху ", 19);
    freq.put("ефт", 10);
    freq.put("оё", 26);
    freq.put("сан", 188);
    freq.put("ош", 513);
    freq.put("ощ", 191);
    freq.put("оэ", 36);
    freq.put("ою", 118);
    freq.put("оя", 305);
    freq.put("ор", 2911);
    freq.put("ос", 3244);
    freq.put("от", 3276);
    freq.put("оу", 114);
    freq.put("оф", 183);
    freq.put("ох", 477);
    freq.put("оц", 136);
    freq.put("оч", 1147);
    freq.put("йму", 8);
    freq.put("Ч ", 7);
    freq.put("хст", 15);
    freq.put("зел", 21);
    freq.put("юме", 11);
    freq.put("юмо", 12);
    freq.put("иге", 21);
    freq.put("йме", 13);
    freq.put("йма", 16);
    freq.put("йми", 7);
    freq.put("нщи", 74);
    freq.put("руш", 81);
    freq.put("рую", 49);
    freq.put("Лип", 7);
    freq.put("рут", 88);
    freq.put("рур", 20);
    freq.put("рус", 171);
    freq.put("руч", 72);
    freq.put("Лиз", 8);
    freq.put("ьси", 11);
    freq.put("ьск", 63);
    freq.put("игн", 19);
    freq.put(" е ", 15);
    freq.put("ямы", 9);
    freq.put("збу", 13);
    freq.put("збс", 8);
    freq.put("збр", 11);
    freq.put("збо", 9);
    freq.put("зби", 32);
    freq.put("ями", 65);
    freq.put("збе", 16);
    freq.put("ямо", 25);
    freq.put("зба", 31);
    freq.put("ься", 375);
    freq.put("ьст", 56);
    freq.put("рук", 207);
    freq.put("рул", 7);
    freq.put("руй", 10);
    freq.put("руп", 76);
    freq.put("рум", 44);
    freq.put("рун", 13);
    freq.put("руг", 178);
    freq.put("руб", 62);
    freq.put("руж", 71);
    freq.put("руз", 84);
    freq.put("руд", 342);
    freq.put("руе", 27);
    freq.put("ши ", 65);
    freq.put("э ", 35);
    freq.put("ас ", 428);
    freq.put("бно", 54);
    freq.put("Гру", 10);
    freq.put("ги ", 155);
    freq.put(" ©", 14);
    freq.put("Гри", 8);
    freq.put("Гро", 7);
    freq.put("Гра", 9);
    freq.put("Гре", 16);
    freq.put("эле", 62);
    freq.put("рх ", 7);
    freq.put("дго", 8);
    freq.put("лга", 36);
    freq.put("лго", 54);
    freq.put("иос", 7);
    freq.put("иот", 36);
    freq.put(" Ау", 7);
    freq.put(" Ас", 16);
    freq.put(" Ар", 28);
    freq.put(" Ах", 22);
    freq.put(" Аф", 8);
    freq.put("Дер", 9);
    freq.put("Дет", 13);
    freq.put("ях ", 70);
    freq.put("Из ", 10);
    freq.put("ж", 4775);
    freq.put("оце", 76);
    freq.put("оци", 38);
    freq.put(" Аг", 8);
    freq.put(" Ав", 40);
    freq.put("АЛ ", 10);
    freq.put("Дел", 9);
    freq.put(" Аз", 11);
    freq.put("Ден", 38);
    freq.put("щь ", 30);
    freq.put(" Ад", 14);
    freq.put(" Ал", 65);
    freq.put(" Ак", 18);
    freq.put("Дев", 26);
    freq.put(" Ап", 11);
    freq.put(" Ан", 87);
    freq.put("ле ", 230);
    freq.put("уя ", 26);
    freq.put("иог", 7);
    freq.put("иод", 10);
    freq.put("иоз", 7);
    freq.put("эй ", 20);
    freq.put("иол", 18);
    freq.put("иок", 13);
    freq.put("ион", 167);
    freq.put("цин", 26);
    freq.put("иум", 9);
    freq.put("иа ", 16);
    freq.put(" В ", 311);
    freq.put("цип", 22);
    freq.put("рем", 262);
    freq.put("рен", 556);
    freq.put("рео", 14);
    freq.put("реп", 114);
    freq.put("реи", 8);
    freq.put("рей", 70);
    freq.put("рек", 126);
    freq.put("рел", 122);
    freq.put("ред", 714);
    freq.put("рее", 46);
    freq.put("реж", 55);
    freq.put("рез", 201);
    freq.put("реа", 51);
    freq.put("реб", 115);
    freq.put("рев", 152);
    freq.put("рег", 106);
    freq.put("чны", 122);
    freq.put("чну", 24);
    freq.put("чни", 50);
    freq.put("чно", 308);
    freq.put("чна", 28);
    freq.put("чне", 17);
    freq.put("рея", 7);
    freq.put("реш", 104);
    freq.put("рещ", 16);
    freq.put("реф", 18);
    freq.put("рех", 36);
    freq.put("рец", 58);
    freq.put("реч", 63);
    freq.put("рер", 9);
    freq.put("рес", 228);
    freq.put("рет", 265);
    freq.put("И ", 278);
    freq.put("хо ", 57);
    freq.put("мер", 254);
    freq.put("мес", 183);
    freq.put("ебы", 10);
    freq.put("вст", 134);
    freq.put("мех", 11);
    freq.put("ебя", 270);
    freq.put("меч", 71);
    freq.put("всю", 25);
    freq.put("мещ", 10);
    freq.put("ебу", 28);
    freq.put("мею", 21);
    freq.put("мея", 11);
    freq.put("всё", 81);
    freq.put("цие", 13);
    freq.put("еци", 41);
    freq.put("ецк", 52);
    freq.put("сце", 18);
    freq.put("еце", 44);
    freq.put("еби", 42);
    freq.put("ебл", 9);
    freq.put("все", 649);
    freq.put("ебн", 62);
    freq.put("мее", 11);
    freq.put("меж", 44);
    freq.put("ебо", 46);
    freq.put("всп", 21);
    freq.put("мел", 53);
    freq.put("ебе", 251);
    freq.put("мен", 875);
    freq.put("йон", 22);
    freq.put("ЦА ", 7);
    freq.put("Фут", 23);
    freq.put("о ", 9032);
    freq.put("Смо", 30);
    freq.put("хуя", 21);
    freq.put("Сме", 12);
    freq.put("хуж", 17);
    freq.put("хуе", 34);
    freq.put("худ", 161);
    freq.put("хул", 7);
    freq.put("хуй", 54);
    freq.put("Че", 103);
    freq.put("Ча", 24);
    freq.put("Чи", 23);
    freq.put("уще", 63);
    freq.put("дзе", 7);
    freq.put("э", 1300);
    freq.put("ущи", 15);
    freq.put("йм ", 7);
    freq.put("Чу", 16);
    freq.put("Чт", 80);
    freq.put("Дум", 10);
    freq.put("АР ", 7);
    freq.put("йве", 103);
    freq.put("од ", 265);
    freq.put("Но ", 60);
    freq.put("сы ", 107);
    freq.put(" з ", 12);
    freq.put("век", 176);
    freq.put("вел", 358);
    freq.put("вей", 11);
    freq.put("вен", 260);
    freq.put("веж", 12);
    freq.put("вез", 48);
    freq.put("вед", 130);
    freq.put("вее", 9);
    freq.put("КИ ", 21);
    freq.put("еюс", 27);
    freq.put("еют", 13);
    freq.put("Йо", 19);
    freq.put("мс ", 24);
    freq.put("о", 50127);
    freq.put("нгу", 7);
    freq.put("веш", 7);
    freq.put("вещ", 45);
    freq.put("не ", 2043);
    freq.put("вет", 254);
    freq.put("вер", 692);
    freq.put("вес", 198);
    freq.put("вец", 16);
    freq.put("веч", 85);
    freq.put(" йо", 11);
    freq.put("ьят", 13);
    freq.put("ахн", 9);
    freq.put("ахо", 77);
    freq.put("ахе", 9);
    freq.put("аха", 263);
    freq.put("нгр", 39);
    freq.put("муж", 87);
    freq.put("муз", 50);
    freq.put("муд", 23);
    freq.put("мум", 10);
    freq.put("мун", 14);
    freq.put("мул", 50);
    freq.put("шма", 8);
    freq.put("пя", 100);
    freq.put("пь", 63);
    freq.put("пы", 156);
    freq.put("пч", 16);
    freq.put("пц", 11);
    freq.put("пу", 378);
    freq.put("пт", 115);
    freq.put("пс", 66);
    freq.put("пр", 3434);
    freq.put("пп", 107);
    freq.put("по", 4248);
    freq.put("пн", 52);
    freq.put("пл", 710);
    freq.put("пк", 47);
    freq.put("пи", 992);
    freq.put("пе", 1241);
    freq.put("пб", 18);
    freq.put("па", 1059);
    freq.put("пят", 91);
    freq.put("ки ", 1259);
    freq.put("мут", 20);
    freq.put("мур", 36);
    freq.put("мус", 21);
    freq.put("мущ", 8);
    freq.put("ьяв", 8);
    freq.put("нго", 21);
    freq.put("Лон", 15);
    freq.put("нгл", 37);
    freq.put("нги", 8);
    freq.put("ьяк", 9);
    freq.put("ахх", 17);
    freq.put("нге", 24);
    freq.put("ус ", 41);
    freq.put("ахс", 15);
    freq.put("ьям", 14);
    freq.put("ьян", 48);
    freq.put("ясь", 15);
    freq.put("Д", 755);
    freq.put("ууу", 43);
    freq.put("яка", 18);
    freq.put("яко", 18);
    freq.put("яки", 12);
    freq.put("ив ", 69);
    freq.put("ясе", 8);
    freq.put("ясн", 26);
    freq.put("кже", 8);
    freq.put("па ", 73);
    freq.put("идё", 8);
    freq.put(" са", 479);
    freq.put(" сб", 68);
    freq.put(" св", 519);
    freq.put(" сг", 10);
    freq.put("иду", 65);
    freq.put("идт", 15);
    freq.put("идя", 20);
    freq.put(" ск", 712);
    freq.put(" сл", 337);
    freq.put("иды", 11);
    freq.put(" сн", 147);
    freq.put(" со", 963);
    freq.put(" сп", 451);
    freq.put(" Жу", 9);
    freq.put("ич ", 39);
    freq.put("куд", 43);
    freq.put("куз", 10);
    freq.put("куб", 7);
    freq.put("кум", 21);
    freq.put("кун", 9);
    freq.put("куп", 133);
    freq.put("кук", 14);
    freq.put("кул", 46);
    freq.put("куч", 46);
    freq.put("кур", 114);
    freq.put("кус", 42);
    freq.put("кут", 15);
    freq.put("кую", 49);
    freq.put("куш", 13);
    freq.put(" Жа", 13);
    freq.put("л ", 1455);
    freq.put(" Же", 39);
    freq.put(" Жд", 7);
    freq.put(" Жи", 33);
    freq.put(" ср", 131);
    freq.put(" сс", 24);
    freq.put(" ст", 812);
    freq.put(" су", 184);
    freq.put(" сх", 100);
    freq.put(" сц", 12);
    freq.put(" сч", 103);
    freq.put("идо", 35);
    freq.put(" съ", 23);
    freq.put(" сы", 39);
    freq.put("идк", 23);
    freq.put(" сю", 8);
    freq.put("иди", 99);
    freq.put("?🙋", 12);
    freq.put("Кли", 17);
    freq.put("Кла", 11);
    freq.put("муч", 13);
    freq.put("дь ", 231);
    freq.put("бег", 21);
    freq.put("бед", 72);
    freq.put("без", 235);
    freq.put("беж", 31);
    freq.put("бей", 15);
    freq.put("бел", 304);
    freq.put("бек", 10);
    freq.put("рло", 10);
    freq.put("щик", 57);
    freq.put("щий", 56);
    freq.put("щим", 18);
    freq.put("щин", 76);
    freq.put("щив", 8);
    freq.put("щие", 31);
    freq.put("ет ", 1695);
    freq.put("биш", 14);
    freq.put("ычн", 34);
    freq.put("щит", 37);
    freq.put("щих", 37);
    freq.put("бес", 259);
    freq.put("бер", 126);
    freq.put("бет", 67);
    freq.put("ахт", 11);
    freq.put("бещ", 21);
    freq.put("аху", 34);
    freq.put("А", 736);
    freq.put("Джи", 13);
    freq.put("ют ", 305);
    freq.put(" зу", 236);
    freq.put(" зр", 220);
    freq.put("Нов", 60);
    freq.put("вза", 9);
    freq.put("оди", 425);
    freq.put("одл", 13);
    freq.put("взг", 15);
    freq.put("одн", 655);
    freq.put("одп", 13);
    freq.put("одо", 180);
    freq.put("одб", 14);
    freq.put("ода", 357);
    freq.put("одг", 11);
    freq.put("взл", 32);
    freq.put("оде", 224);
    freq.put("одд", 22);
    freq.put("взо", 23);
    freq.put("одж", 7);
    freq.put("фи", 422);
    freq.put("удк", 11);
    freq.put("взр", 25);
    freq.put("оды", 91);
    freq.put("одъ", 11);
    freq.put("фил", 124);
    freq.put("фик", 31);
    freq.put("одя", 59);
    freq.put("фии", 23);
    freq.put("одс", 63);
    freq.put("одр", 62);
    freq.put("оду", 137);
    freq.put("одт", 13);
    freq.put("одх", 12);
    freq.put("одч", 12);
    freq.put("взя", 41);
    freq.put(" зд", 61);
    freq.put(" зе", 47);
    freq.put(" зв", 69);
    freq.put(" за", 1551);
    freq.put(" зб", 8);
    freq.put("Нор", 10);
    freq.put("Нот", 8);
    freq.put(" зн", 358);
    freq.put(" зл", 17);
    freq.put(" зи", 17);
    freq.put("Ноч", 10);
    freq.put("аук", 13);
    freq.put("аул", 7);
    freq.put("неч", 81);
    freq.put("нец", 69);
    freq.put("нес", 137);
    freq.put("нер", 109);
    freq.put("неу", 20);
    freq.put("аун", 22);
    freq.put("ве ", 158);
    freq.put("ауз", 15);
    freq.put("ауд", 19);
    freq.put("шке", 16);
    freq.put("шка", 117);
    freq.put("шко", 160);
    freq.put("шки", 95);
    freq.put("мск", 41);
    freq.put("©", 14);
    freq.put("Й ", 100);
    freq.put("гки", 20);
    freq.put("мся", 49);
    freq.put("гко", 16);
    freq.put("гка", 21);
    freq.put("мст", 212);
    freq.put("мсу", 7);
    freq.put("рче", 20);
    freq.put("шку", 22);
    freq.put("ё ", 208);
    freq.put(" й ", 9);
    freq.put("рчи", 9);
    freq.put("нее", 103);
    freq.put("нед", 122);
    freq.put("ауш", 8);
    freq.put("неж", 35);
    freq.put("неб", 26);
    freq.put("нег", 108);
    freq.put("нев", 83);
    freq.put("аут", 7);
    freq.put("нем", 101);
    freq.put("неп", 40);
    freq.put("нео", 45);
    freq.put("ней", 118);
    freq.put("ауч", 12);
    freq.put("нел", 44);
    freq.put("нек", 45);
    freq.put("кис", 63);
    freq.put("кир", 37);
    freq.put("кит", 18);
    freq.put("ких", 147);
    freq.put("ячи", 13);
    freq.put("му ", 509);
    freq.put("яче", 13);
    freq.put("киш", 10);
    freq.put("кия", 7);
    freq.put("усы", 29);
    freq.put("йт ", 58);
    freq.put("усь", 41);
    freq.put("ИТ ", 16);
    freq.put("уст", 213);
    freq.put("усс", 122);
    freq.put("ах ", 361);
    freq.put("зни", 98);
    freq.put("зно", 119);
    freq.put("зна", 531);
    freq.put("зне", 99);
    freq.put("зны", 59);
    freq.put("знь", 76);
    freq.put("зну", 9);
    freq.put("ё", 444);
    freq.put("п ", 175);
    freq.put("усл", 59);
    freq.put("уск", 70);
    freq.put("ья ", 88);
    freq.put("уси", 28);
    freq.put("усп", 46);
    freq.put("усо", 35);
    freq.put("усн", 23);
    freq.put("уса", 30);
    freq.put("усе", 15);
    freq.put("нг ", 71);
    freq.put("киа", 11);
    freq.put("кие", 308);
    freq.put("кид", 32);
    freq.put("кий", 338);
    freq.put("кил", 9);
    freq.put("кин", 108);
    freq.put("ким", 117);
    freq.put("кип", 14);
    freq.put("ивш", 21);
    freq.put("ивы", 60);
    freq.put("иву", 24);
    freq.put(" Ду", 24);
    freq.put(" Др", 24);
    freq.put("як ", 47);
    freq.put("Цен", 21);
    freq.put("узи", 21);
    freq.put(" До", 151);
    freq.put(" Дн", 12);
    freq.put(" Дл", 18);
    freq.put(" Ди", 80);
    freq.put(" Дж", 61);
    freq.put(" Де", 123);
    freq.put(" Дв", 10);
    freq.put(" Да", 112);
    freq.put("ивн", 84);
    freq.put("иво", 112);
    freq.put("иви", 66);
    freq.put("ивл", 19);
    freq.put("ивк", 13);
    freq.put("иве", 105);
    freq.put("ива", 550);
    freq.put(" с ", 1053);
    freq.put("пад", 67);
    freq.put("пае", 13);
    freq.put("пав", 20);
    freq.put("пам", 18);
    freq.put("пан", 67);
    freq.put("пап", 19);
    freq.put("пай", 7);
    freq.put("пак", 16);
    freq.put("пал", 101);
    freq.put("Кни", 8);
    freq.put("ку ", 366);
    freq.put("Ч", 310);
    freq.put("лу", 681);
    freq.put("лт", 41);
    freq.put("лс", 194);
    freq.put("ичн", 132);
    freq.put("ичк", 34);
    freq.put("ичи", 196);
    freq.put("лы", 307);
    freq.put("иче", 502);
    freq.put("ля", 1468);
    freq.put("лю", 808);
    freq.put("ича", 46);
    freq.put("ль", 2454);
    freq.put("лг", 108);
    freq.put(" р ", 20);
    freq.put("ла", 3229);
    freq.put("лз", 7);
    freq.put("лж", 130);
    freq.put("ле", 2365);
    freq.put("лд", 43);
    freq.put("лл", 195);
    freq.put("лк", 243);
    freq.put("ли", 3405);
    freq.put("ичт", 7);
    freq.put("ло", 2348);
    freq.put("лн", 138);
    freq.put("лм", 21);
    freq.put("пах", 26);
    freq.put("пац", 8);
    freq.put("пар", 226);
    freq.put("пас", 179);
    freq.put("пат", 151);
    freq.put("паю", 20);
    freq.put("ид ", 46);
    freq.put("лнц", 10);
    freq.put("Мис", 7);
    freq.put("Мир", 9);
    freq.put("узо", 12);
    freq.put("бзо", 11);
    freq.put("Муж", 16);
    freq.put("дьт", 10);
    freq.put("дья", 9);
    freq.put("тде", 26);
    freq.put("дьб", 20);
    freq.put("дьм", 11);
    freq.put("тда", 19);
    freq.put(" сд", 159);
    freq.put("Мин", 32);
    freq.put("Мил", 14);
    freq.put(" се", 782);
    freq.put("щи ", 62);
    freq.put("бе ", 230);
    freq.put("ете", 286);
    freq.put("ета", 223);
    freq.put("етв", 34);
    freq.put("етн", 130);
    freq.put("ето", 164);
    freq.put("ети", 189);
    freq.put("съе", 22);
    freq.put("етк", 62);
    freq.put("етл", 12);
    freq.put("етр", 63);
    freq.put("етс", 338);
    freq.put("етт", 10);
    freq.put("ету", 36);
    freq.put("еть", 308);
    freq.put("етя", 14);
    freq.put("еты", 113);
    freq.put("мбо", 11);
    freq.put("мби", 27);
    freq.put("мбл", 8);
    freq.put("мба", 10);
    freq.put("рне", 83);
    freq.put("бли", 133);
    freq.put("рна", 85);
    freq.put("бло", 66);
    freq.put("рно", 201);
    freq.put("бла", 133);
    freq.put("рни", 45);
    freq.put("бле", 118);
    freq.put("И", 551);
    freq.put("Вче", 12);
    freq.put("Хор", 15);
    freq.put("Хот", 20);
    freq.put("Хоч", 34);
    freq.put("ер ", 393);
    freq.put("дши", 10);
    freq.put("дше", 9);
    freq.put("Хол", 9);
    freq.put("гур", 17);
    freq.put("пси", 18);
    freq.put("бля", 77);
    freq.put("блю", 99);
    freq.put("рну", 53);
    freq.put("блу", 9);
    freq.put("рня", 22);
    freq.put("рны", 100);
    freq.put(" Ру", 45);
    freq.put(" Ря", 12);
    freq.put("сюд", 9);
    freq.put("мны", 41);
    freq.put("мню", 13);
    freq.put("мня", 7);
    freq.put("ДА ", 24);
    freq.put("ффе", 26);
    freq.put("едк", 9);
    freq.put("Ж ", 11);
    freq.put("мно", 169);
    freq.put("мна", 35);
    freq.put("мне", 347);
    freq.put(" Ра", 118);
    freq.put(" Ре", 112);
    freq.put("чуд", 16);
    freq.put(" Ри", 26);
    freq.put(" Ро", 170);
    freq.put("идж", 12);
    freq.put("иде", 408);
    freq.put("ида", 88);
    freq.put("идн", 31);
    freq.put("уир", 8);
    freq.put("м ", 3062);
    freq.put("ыс ", 7);
    freq.put("Нич", 7);
    freq.put("шо ", 75);
    freq.put(" нр", 64);
    freq.put(" ну", 244);
    freq.put(" ня", 19);
    freq.put(" ны", 10);
    freq.put("ёт ", 34);
    freq.put("ры ", 256);
    freq.put("го ", 1437);
    freq.put(" не", 2165);
    freq.put(" на", 2962);
    freq.put("ач ", 16);
    freq.put("Ес", 87);
    freq.put(" но", 775);
    freq.put(" ни", 374);
    freq.put("Ник", 34);
    freq.put("Ниж", 9);
    freq.put("П ", 37);
    freq.put("шал", 33);
    freq.put("мяг", 26);
    freq.put("шай", 10);
    freq.put("шан", 11);
    freq.put("шам", 12);
    freq.put("мяк", 22);
    freq.put("шае", 17);
    freq.put("ОЛ ", 7);
    freq.put("ёрн", 7);
    freq.put("яд ", 21);
    freq.put("Я", 571);
    freq.put("гаю", 30);
    freq.put("гая", 11);
    freq.put("гар", 64);
    freq.put("гас", 13);
    freq.put("гат", 46);
    freq.put("гах", 17);
    freq.put("Чем", 18);
    freq.put("гай", 9);
    freq.put("Фин", 20);
    freq.put("Чер", 25);
    freq.put("Фил", 20);
    freq.put("ган", 96);
    freq.put("Чех", 14);
    freq.put("ух ", 26);
    freq.put("гав", 10);
    freq.put("гад", 37);
    freq.put("гае", 42);
    freq.put("газ", 50);
    freq.put("рэп", 8);
    freq.put("ыуч", 8);
    freq.put("пыт", 66);
    freq.put("мят", 14);
    freq.put("шаш", 7);
    freq.put("шая", 69);
    freq.put("шаю", 30);
    freq.put("аща", 23);
    freq.put("шат", 45);
    freq.put("шар", 19);
    freq.put("лл ", 9);
    freq.put("шах", 9);
    freq.put(" у ", 426);
    freq.put("кву", 8);
    freq.put("квы", 49);
    freq.put("зли", 14);
    freq.put("лну", 11);
    freq.put("зло", 64);
    freq.put("лня", 7);
    freq.put("зла", 7);
    freq.put("учу", 8);
    freq.put("лны", 15);
    freq.put("кс ", 247);
    freq.put("цию", 58);
    freq.put(" И ", 158);
    freq.put("учи", 170);
    freq.put("лне", 26);
    freq.put("учк", 17);
    freq.put("учн", 27);
    freq.put("лна", 7);
    freq.put("лно", 23);
    freq.put("уче", 144);
    freq.put("лни", 28);
    freq.put("кве", 86);
    freq.put("ква", 124);
    freq.put("кви", 16);
    freq.put(" ры", 49);
    freq.put("Шко", 10);
    freq.put(" хм", 13);
    freq.put(" хо", 619);
    freq.put(" хи", 47);
    freq.put(" хл", 14);
    freq.put(" хд", 36);
    freq.put(" хе", 17);
    freq.put(" ха", 74);
    freq.put(" хв", 38);
    freq.put("сбе", 19);
    freq.put("сбо", 26);
    freq.put(" Кс", 13);
    freq.put(" Кр", 135);
    freq.put(" Ку", 75);
    freq.put(" Кт", 165);
    freq.put("Зе", 18);
    freq.put("Зд", 7);
    freq.put("Зв", 11);
    freq.put("За", 213);
    freq.put("Зо", 15);
    freq.put("Зн", 75);
    freq.put("Зи", 10);
    freq.put("Зу", 7);
    freq.put("хи ", 58);
    freq.put("Зр", 11);
    freq.put(" Кн", 9);
    freq.put(" Ко", 225);
    freq.put(" Ки", 80);
    freq.put(" Кл", 42);
    freq.put(" Ке", 19);
    freq.put(" Ка", 604);
    freq.put("тач", 8);
    freq.put("К ", 112);
    freq.put(" ху", 89);
    freq.put("тащ", 13);
    freq.put("Рек", 11);
    freq.put("Реа", 11);
    freq.put("Реб", 9);
    freq.put("Рег", 9);
    freq.put("вых", 99);
    freq.put("выч", 11);
    freq.put("выр", 34);
    freq.put("выс", 78);
    freq.put("выу", 7);
    freq.put("сши", 72);
    freq.put("бл ", 13);
    freq.put("выш", 52);
    freq.put("еро", 156);
    freq.put("ерп", 18);
    freq.put("ерм", 65);
    freq.put("ерн", 283);
    freq.put("ерк", 55);
    freq.put("ерл", 21);
    freq.put("ери", 262);
    freq.put("ерж", 94);
    freq.put("ерз", 8);
    freq.put("ерд", 61);
    freq.put("ере", 664);
    freq.put("ерв", 221);
    freq.put("ерг", 64);
    freq.put("ера", 424);
    freq.put("ерб", 85);
    freq.put("чле", 10);
    freq.put("ерё", 8);
    freq.put("ерю", 12);
    freq.put("еря", 56);
    freq.put("ерь", 325);
    freq.put("еры", 65);
    freq.put("ерш", 59);
    freq.put("ерч", 13);
    freq.put("ерф", 9);
    freq.put("ерх", 23);
    freq.put("ерт", 134);
    freq.put("еру", 49);
    freq.put("ерр", 31);
    freq.put("ерс", 113);
    freq.put("выд", 41);
    freq.put("вые", 151);
    freq.put("выж", 11);
    freq.put("выз", 18);
    freq.put("выб", 51);
    freq.put("выв", 29);
    freq.put("выг", 32);
    freq.put("вым", 40);
    freq.put("вын", 14);
    freq.put("вып", 78);
    freq.put("выи", 7);
    freq.put("вый", 155);
    freq.put("вык", 19);
    freq.put("выл", 28);
    freq.put("Реш", 14);
    freq.put("Рец", 11);
    freq.put("Рет", 8);
    freq.put("Жу", 9);
    freq.put("сю ", 21);
    freq.put(" Эк", 26);
    freq.put("фф ", 11);
    freq.put(" Р ", 9);
    freq.put("Жа", 13);
    freq.put("Жд", 7);
    freq.put("Же", 39);
    freq.put("Жи", 34);
    freq.put("тае", 90);
    freq.put("тад", 17);
    freq.put("рла", 20);
    freq.put("тай", 63);
    freq.put("Жит", 8);
    freq.put("уше", 74);
    freq.put("рли", 13);
    freq.put("бен", 64);
    freq.put("Жиз", 11);
    freq.put("Жив", 7);
    freq.put("мд", 7);
    freq.put("ме", 1981);
    freq.put("мв", 13);
    freq.put("ма", 2013);
    freq.put("мб", 80);
    freq.put("мо", 2582);
    freq.put("мп", 205);
    freq.put("мм", 183);
    freq.put("мн", 673);
    freq.put("мк", 54);
    freq.put("мл", 85);
    freq.put("ми", 1335);
    freq.put(" лу", 137);
    freq.put("вго", 14);
    freq.put("вге", 9);
    freq.put(" лю", 405);
    freq.put(" ля", 7);
    freq.put(" ль", 13);
    freq.put("жба", 8);
    freq.put("Ше", 16);
    freq.put("юшк", 10);
    freq.put(" ла", 120);
    freq.put(" лб", 7);
    freq.put(" ле", 424);
    freq.put(" ли", 374);
    freq.put(" ло", 92);
    freq.put("мц", 61);
    freq.put("мч", 12);
    freq.put("мф", 13);
    freq.put("мт", 8);
    freq.put("му", 865);
    freq.put("мр", 18);
    freq.put("мс", 349);
    freq.put("мя", 173);
    freq.put("мь", 60);
    freq.put("мэ", 14);
    freq.put("мы", 547);
    freq.put("шое", 8);
    freq.put("ачу", 21);
    freq.put("шой", 15);
    freq.put("шок", 25);
    freq.put("шоп", 23);
    freq.put("нбу", 21);
    freq.put("ысл", 53);
    freq.put("ыси", 8);
    freq.put("ысп", 8);
    freq.put("ысо", 25);
    freq.put("йше", 10);
    freq.put("рыт", 72);
    freq.put("рых", 18);
    freq.put("рыш", 18);
    freq.put("рыщ", 148);
    freq.put("гот", 83);
    freq.put("Фор", 20);
    freq.put("гор", 281);
    freq.put("Фот", 22);
    freq.put("Зам", 18);
    freq.put("УТ ", 9);
    freq.put("гое", 11);
    freq.put("гов", 218);
    freq.put("гог", 23);
    freq.put("гоп", 7);
    freq.put("гом", 39);
    freq.put("гон", 37);
    freq.put("гол", 153);
    freq.put("гой", 29);
    freq.put("рыв", 52);
    freq.put("рыг", 7);
    freq.put("рыб", 20);
    freq.put("рыж", 65);
    freq.put("рыд", 7);
    freq.put("рые", 81);
    freq.put("рыл", 40);
    freq.put("рый", 70);
    freq.put("рым", 25);
    freq.put("рын", 19);
    freq.put("ыст", 80);
    freq.put("Зак", 15);
    freq.put("ысы", 7);
    freq.put("ысш", 14);
    freq.put("ыся", 17);
    freq.put("шоу", 9);
    freq.put("аче", 132);
    freq.put(" н ", 14);
    freq.put("ача", 553);
    freq.put("ачн", 48);
    freq.put("ачк", 20);
    freq.put("ачи", 144);
    freq.put("пы ", 59);
    freq.put("мя ", 86);
    freq.put("ллю", 11);
    freq.put("ша ", 60);
    freq.put("гэ ", 9);
    freq.put("😂?", 12);
    freq.put("уху", 14);
    freq.put("яди", 22);
    freq.put("ядк", 143);
    freq.put("ядо", 34);
    freq.put("яда", 12);
    freq.put("яде", 18);
    freq.put("яду", 8);
    freq.put("уха", 24);
    freq.put("га ", 208);
    freq.put("ухо", 24);
    freq.put("ъем", 9);
    freq.put("ухи", 19);
    freq.put("лло", 38);
    freq.put("лли", 44);
    freq.put("лле", 47);
    freq.put("лла", 25);
    freq.put("кдо", 13);
    freq.put(" ук", 53);
    freq.put(" ул", 99);
    freq.put(" уп", 66);
    freq.put(" ум", 89);
    freq.put(" ун", 31);
    freq.put(" ув", 290);
    freq.put(" уг", 72);
    freq.put("ижу", 67);
    freq.put(" уб", 86);
    freq.put(" уж", 294);
    freq.put(" уз", 49);
    freq.put(" уд", 147);
    freq.put(" уе", 16);
    freq.put(" Ищ", 14);
    freq.put(" Ит", 19);
    freq.put(" Ис", 41);
    freq.put(" Ир", 26);
    freq.put("ксо", 13);
    freq.put("ксп", 42);
    freq.put("кск", 8);
    freq.put("кси", 45);
    freq.put("ксе", 16);
    freq.put("кса", 64);
    freq.put("т", 32732);
    freq.put("лн ", 10);
    freq.put("кст", 42);
    freq.put("ксу", 16);
    freq.put(" Ил", 23);
    freq.put(" Ин", 89);
    freq.put(" Им", 13);
    freq.put(" Иг", 38);
    freq.put(" Ив", 10);
    freq.put(" Из", 31);
    freq.put(" Ид", 13);
    freq.put("ижи", 11);
    freq.put(" уш", 23);
    freq.put("ижк", 7);
    freq.put("ижн", 37);
    freq.put(" ут", 114);
    freq.put("ижа", 20);
    freq.put(" ур", 87);
    freq.put(" ус", 213);
    freq.put("иже", 74);
    freq.put(" уч", 150);
    freq.put(" уф", 10);
    freq.put(" ух", 20);
    freq.put("нян", 12);
    freq.put(" х ", 23);
    freq.put("Кс", 13);
    freq.put("Кт", 165);
    freq.put("Ку", 75);
    freq.put("хих", 10);
    freq.put("хит", 14);
    freq.put("хир", 20);
    freq.put("З ", 21);
    freq.put("бры", 13);
    freq.put("брю", 8);
    freq.put("бря", 32);
    freq.put("бру", 11);
    freq.put("бри", 29);
    freq.put("бро", 128);
    freq.put("бра", 510);
    freq.put(" К ", 25);
    freq.put("бре", 38);
    freq.put("хие", 10);
    freq.put("зск", 11);
    freq.put("хим", 35);
    freq.put("хии", 9);
    freq.put("Кн", 9);
    freq.put("Ко", 234);
    freq.put("Ки", 81);
    freq.put("Кл", 42);
    freq.put("Ке", 20);
    freq.put("Ка", 605);
    freq.put("аб ", 10);
    freq.put("가가", 10);
    freq.put(" че", 549);
    freq.put(" ча", 175);
    freq.put("СЯ ", 23);
    freq.put(" чо", 21);
    freq.put(" чл", 12);
    freq.put(" чи", 99);
    freq.put("Ло", 42);
    freq.put("зя ", 24);
    freq.put(" Му", 41);
    freq.put(" Мы", 33);
    freq.put(" Ме", 91);
    freq.put(" Ма", 150);
    freq.put(" Мо", 264);
    freq.put(" Мн", 132);
    freq.put(" Ми", 86);
    freq.put("зу ", 48);
    freq.put("н ", 1529);
    freq.put(" чё", 13);
    freq.put("тча", 12);
    freq.put(" чт", 915);
    freq.put(" чу", 112);
    freq.put("тчи", 16);
    freq.put("уро", 93);
    freq.put("агл", 12);
    freq.put("аги", 41);
    freq.put("аго", 81);
    freq.put("агн", 22);
    freq.put("ага", 116);
    freq.put("аге", 33);
    freq.put("г", 7742);
    freq.put("хдд", 17);
    freq.put(" у", 2370);
    freq.put(" р", 2319);
    freq.put("Лук", 10);
    freq.put("Сро", 9);
    freq.put(" ц", 245);
    freq.put("Сре", 21);
    freq.put("агу", 8);
    freq.put("агр", 49);
    freq.put(" ш", 441);
    freq.put("сь ", 738);
    freq.put(" э", 1042);
    freq.put("ибл", 25);
    freq.put("мп ", 8);
    freq.put("Сбо", 8);
    freq.put("ур ", 18);
    freq.put(" Т ", 13);
    freq.put("убк", 14);
    freq.put(" Фу", 32);
    freq.put(" Фр", 28);
    freq.put("Бес", 28);
    freq.put("Бер", 17);
    freq.put("ибы", 13);
    freq.put("фра", 23);
    freq.put("фри", 9);
    freq.put("??", 12);
    freq.put(" Щ", 13);
    freq.put("Без", 19);
    freq.put("Бел", 31);
    freq.put(" Фо", 48);
    freq.put(" Фи", 48);
    freq.put(" Фе", 14);
    freq.put(" Фа", 16);
    freq.put("дей", 112);
    freq.put(" см", 487);
    freq.put("дел", 568);
    freq.put(" л", 1609);
    freq.put("узн", 49);
    freq.put(" и", 3789);
    freq.put("тек", 61);
    freq.put("тел", 752);
    freq.put(" й", 24);
    freq.put("тео", 20);
    freq.put("теп", 110);
    freq.put("тем", 172);
    freq.put("тен", 87);
    freq.put("тев", 12);
    freq.put("тег", 10);
    freq.put("теа", 11);
    freq.put("теб", 313);
    freq.put("Слу", 13);
    freq.put("узе", 91);
    freq.put("теш", 11);
    freq.put("тет", 48);
    freq.put("тер", 599);
    freq.put("тес", 93);
    freq.put("теч", 35);
    freq.put("тех", 59);
    freq.put("ук ", 33);
    freq.put("умы", 19);
    freq.put("ици", 112);
    freq.put("ицк", 8);
    freq.put("ицо", 18);
    freq.put("дме", 10);
    freq.put(" Л", 475);
    freq.put("дми", 12);
    freq.put("умм", 7);
    freq.put("умн", 31);
    freq.put("лти", 7);
    freq.put("лто", 8);
    freq.put(" О", 827);
    freq.put("лта", 9);
    freq.put("ума", 145);
    freq.put("умб", 7);
    freq.put("лте", 7);
    freq.put(" М", 980);
    freq.put(" п ", 17);
    freq.put("вну", 35);
    freq.put("вны", 93);
    freq.put("вня", 15);
    freq.put("ых ", 562);
    freq.put("Рум", 8);
    freq.put("оё ", 20);
    freq.put("же ", 845);
    freq.put("Ю ", 41);
    freq.put("юту", 8);
    freq.put("КА ", 32);
    freq.put("ютс", 82);
    freq.put("убы", 16);
    freq.put("ъ", 109);
    freq.put("ря ", 74);
    freq.put("фия", 12);
    freq.put("фию", 8);
    freq.put("Рус", 17);
    freq.put("вна", 31);
    freq.put("одк", 47);
    freq.put("вне", 35);
    freq.put("вни", 58);
    freq.put("вно", 223);
    freq.put("нн ", 10);
    freq.put("йти", 146);
    freq.put("мым", 13);
    freq.put("ёв", 13);
    freq.put("ёд", 7);
    freq.put("йто", 15);
    freq.put("мый", 57);
    freq.put("йта", 13);
    freq.put("ёл", 21);
    freq.put("мые", 48);
    freq.put("мыв", 8);
    freq.put("йте", 120);
    freq.put("фич", 15);
    freq.put("аэр", 11);
    freq.put("фиц", 31);
    freq.put("пче", 8);
    freq.put("цка", 7);
    freq.put("одв", 26);
    freq.put("нля", 7);
    freq.put("ОП ", 7);
    freq.put("фит", 11);
    freq.put("фис", 16);
    freq.put("Кан", 17);
    freq.put("фир", 23);
    freq.put("рищ", 7);
    freq.put("нла", 128);
    freq.put("рию", 26);
    freq.put("ёс", 8);
    freq.put("ёр", 27);
    freq.put("юл", 19);
    freq.put("тке", 14);
    freq.put("мыш", 21);
    freq.put("ёш", 9);
    freq.put("мых", 35);
    freq.put("жье", 10);
    freq.put("рис", 140);
    freq.put("мыс", 51);
    freq.put("가", 12);
    freq.put("рир", 43);
    freq.put("хни", 18);
    freq.put("аба", 42);
    freq.put("абе", 77);
    freq.put("аби", 49);
    freq.put("абл", 65);
    freq.put("або", 230);
    freq.put("Стр", 38);
    freq.put("Сту", 7);
    freq.put("нё", 19);
    freq.put("нх", 9);
    freq.put("нф", 84);
    freq.put("нч", 81);
    freq.put("нц", 213);
    freq.put("нс", 646);
    freq.put("нр", 140);
    freq.put("ну", 862);
    freq.put("нт", 1080);
    freq.put("нь", 697);
    freq.put("ня", 1070);
    freq.put("ню", 83);
    freq.put("нщ", 74);
    freq.put("нш", 20);
    freq.put("ны", 2002);
    freq.put("зую", 7);
    freq.put("не", 4066);
    freq.put("нд", 390);
    freq.put("нз", 33);
    freq.put("нж", 9);
    freq.put("нб", 25);
    freq.put("на", 5359);
    freq.put("нг", 251);
    freq.put("нв", 51);
    freq.put("нн", 907);
    freq.put("нп", 9);
    freq.put("но", 5051);
    freq.put("ни", 5144);
    freq.put("нл", 140);
    freq.put("нк", 807);
    freq.put("Ста", 29);
    freq.put("Сте", 7);
    freq.put(" М ", 7);
    freq.put("Сти", 8);
    freq.put("Сто", 33);
    freq.put("абр", 27);
    freq.put("абс", 10);
    freq.put("абу", 25);
    freq.put("абы", 43);
    freq.put("рпо", 8);
    freq.put("рпл", 10);
    freq.put("рпи", 8);
    freq.put("аг ", 13);
    freq.put("рпе", 12);
    freq.put("узс", 10);
    freq.put("рил", 97);
    freq.put("бал", 69);
    freq.put("рии", 84);
    freq.put("ЕР ", 14);
    freq.put("рпу", 7);
    freq.put(" Тр", 39);
    freq.put(" Ту", 41);
    freq.put("рим", 98);
    freq.put(" Ты", 175);
    freq.put("ИЙ ", 15);
    freq.put("риг", 54);
    freq.put("сьм", 13);
    freq.put("мпт", 9);
    freq.put("мпу", 8);
    freq.put("мпр", 7);
    freq.put("риа", 79);
    freq.put("мпь", 28);
    freq.put("баз", 19);
    freq.put("дъе", 10);
    freq.put("рид", 72);
    freq.put("Мы ", 31);
    freq.put("ъез", 16);
    freq.put("ц", 2283);
    freq.put("фин", 41);
    freq.put("мпа", 45);
    freq.put("мпе", 16);
    freq.put("мпл", 21);
    freq.put("мпи", 35);
    freq.put("мпо", 18);
    freq.put("пря", 64);
    freq.put("фий", 7);
    freq.put(" Те", 116);
    freq.put("физ", 31);
    freq.put(" Та", 149);
    freq.put(" Тв", 29);
    freq.put("тки", 218);
    freq.put(" То", 99);
    freq.put(" Ти", 27);
    freq.put("виш", 10);
    freq.put("фиг", 34);
    freq.put("йду", 42);
    freq.put("юди", 86);
    freq.put("юда", 14);
    freq.put("юде", 48);
    freq.put("ыша", 26);
    freq.put(" зо", 171);
    freq.put("юдь", 7);
    freq.put("юдя", 15);
    freq.put("тзы", 51);
    freq.put("йдо", 7);
    freq.put("йди", 10);
    freq.put("йде", 35);
    freq.put("неф", 11);
    freq.put("укт", 34);
    freq.put("уку", 15);
    freq.put("укр", 44);
    freq.put("укц", 120);
    freq.put("М", 985);
    freq.put("нет", 422);
    freq.put("ъяс", 10);
    freq.put("св", 557);
    freq.put("те ", 608);
    freq.put("сд", 167);
    freq.put("ъяв", 25);
    freq.put("неш", 21);
    freq.put("укл", 12);
    freq.put("уки", 38);
    freq.put("ьма", 30);
    freq.put("уко", 49);
    freq.put("укв", 7);
    freq.put("ука", 79);
    freq.put("уке", 10);
    freq.put("ьме", 17);
    freq.put("Кру", 15);
    freq.put("ьмы", 21);
    freq.put("ТЫ ", 25);
    freq.put("впе", 33);
    freq.put(" пя", 53);
    freq.put(" пь", 27);
    freq.put(" пы", 38);
    freq.put(" пт", 12);
    freq.put(" пу", 137);
    freq.put(" пр", 2903);
    freq.put(" пс", 37);
    freq.put("фар", 11);
    freq.put("фаш", 7);
    freq.put("я", 10392);
    freq.put("фан", 24);
    freq.put("фам", 28);
    freq.put("фал", 12);
    freq.put("фак", 30);
    freq.put(" по", 3598);
    freq.put("Ы ", 60);
    freq.put(" пл", 284);
    freq.put(" пи", 290);
    freq.put(" пе", 595);
    freq.put(" па", 345);
    freq.put("ум ", 59);
    freq.put("шве", 9);
    freq.put("Вер", 17);
    freq.put("Вес", 14);
    freq.put("Веч", 8);
    freq.put("ыхо", 51);
    freq.put("нны", 322);
    freq.put("нну", 23);
    freq.put("ыха", 18);
    freq.put("ряю", 11);
    freq.put("рящ", 8);
    freq.put("ряч", 16);
    freq.put("рят", 62);
    freq.put("ряс", 12);
    freq.put("Юл", 12);
    freq.put("жев", 13);
    freq.put("фот", 169);
    freq.put("Юб", 7);
    freq.put("жем", 16);
    freq.put("жен", 337);
    freq.put("жек", 7);
    freq.put("жел", 97);
    freq.put("жей", 17);
    freq.put("жет", 293);
    freq.put("жер", 27);
    freq.put("жес", 43);
    freq.put("Юр", 9);
    freq.put("БА ", 8);
    freq.put("жеш", 59);
    freq.put("рям", 53);
    freq.put("рян", 18);
    freq.put("ряк", 15);
    freq.put("ряж", 8);
    freq.put("ряз", 15);
    freq.put("ряд", 206);
    freq.put("ряе", 12);
    freq.put("ряг", 10);
    freq.put("нно", 362);
    freq.put("нни", 62);
    freq.put("нне", 32);
    freq.put("нна", 91);
    freq.put("Вел", 11);
    freq.put("Вед", 12);
    freq.put("каш", 11);
    freq.put("кая", 311);
    freq.put("каю", 10);
    freq.put("кас", 28);
    freq.put("кар", 186);
    freq.put("кау", 8);
    freq.put("кат", 104);
    freq.put("ках", 161);
    freq.put("каф", 9);
    freq.put("кач", 508);
    freq.put("кац", 12);
    freq.put("ов", 4485);
    freq.put("кай", 30);
    freq.put("кал", 87);
    freq.put("как", 719);
    freq.put("кан", 118);
    freq.put("кам", 163);
    freq.put("кап", 39);
    freq.put("каб", 18);
    freq.put("жь ", 9);
    freq.put("кав", 7);
    freq.put("кае", 12);
    freq.put("кад", 40);
    freq.put("каз", 293);
    freq.put("каж", 138);
    freq.put("мет", 140);
    freq.put("ыщи", 72);
    freq.put("псо", 18);
    freq.put("ыща", 8);
    freq.put("гус", 8);
    freq.put("пск", 7);
    freq.put("ыще", 59);
    freq.put("гут", 37);
    freq.put("аяс", 10);
    freq.put("шск", 8);
    freq.put("ОН ", 18);
    freq.put("хма", 7);
    freq.put("аяв", 34);
    freq.put("гум", 7);
    freq.put("псу", 8);
    freq.put("гул", 50);
    freq.put("губ", 21);
    freq.put("гуг", 9);
    freq.put("се ", 465);
    freq.put("Шар", 7);
    freq.put("нез", 33);
    freq.put("РА ", 14);
    freq.put("УЮ ", 9);
    freq.put("нен", 184);
    freq.put(" О ", 61);
    freq.put("неи", 10);
    freq.put("ячн", 9);
    freq.put("тую", 9);
    freq.put("туч", 7);
    freq.put("ае ", 18);
    freq.put("тус", 28);
    freq.put("тут", 221);
    freq.put("сли", 270);
    freq.put("сло", 164);
    freq.put("сла", 117);
    freq.put("сле", 289);
    freq.put("еор", 13);
    freq.put("Гал", 9);
    freq.put("еох", 14);
    freq.put("ВД ", 7);
    freq.put(" Шк", 10);
    freq.put("ю", 3218);
    freq.put("еоб", 38);
    freq.put("еод", 9);
    freq.put("еож", 13);
    freq.put("Гар", 10);
    freq.put("еом", 8);
    freq.put("еон", 8);
    freq.put("слы", 35);
    freq.put("сля", 12);
    freq.put("слу", 164);
    freq.put("туп", 111);
    freq.put("тук", 9);
    freq.put("тул", 17);
    freq.put("туд", 43);
    freq.put("туз", 48);
    freq.put("туа", 36);
    freq.put("туб", 12);
    freq.put("азд", 57);
    freq.put("азе", 69);
    freq.put("азв", 92);
    freq.put("азг", 28);
    freq.put("аза", 310);
    freq.put("азб", 40);
    freq.put("азо", 81);
    freq.put("азм", 38);
    freq.put("азн", 66);
    freq.put("азк", 11);
    freq.put("азл", 16);
    freq.put("ази", 72);
    freq.put("усу", 8);
    freq.put("хах", 176);
    freq.put("хат", 31);
    freq.put("хар", 75);
    freq.put("хам", 14);
    freq.put("хан", 26);
    freq.put("хал", 43);
    freq.put("хай", 7);
    freq.put("хаа", 8);
    freq.put("хаб", 8);
    freq.put("ща ", 14);
    freq.put("Я ", 624);
    freq.put("азу", 49);
    freq.put("азр", 30);
    freq.put("азь", 7);
    freq.put("азы", 81);
    freq.put("фт ", 122);
    freq.put("Ф", 243);
    freq.put("маз", 19);
    freq.put("Пры", 14);
    freq.put("дре", 44);
    freq.put("дра", 170);
    freq.put("дро", 88);
    freq.put("кос", 65);
    freq.put("дри", 16);
    freq.put("кор", 216);
    freq.put("ын ", 9);
    freq.put("мат", 271);
    freq.put("дру", 194);
    freq.put("НИ ", 11);
    freq.put("дря", 8);
    freq.put(" Шл", 8);
    freq.put("Пре", 53);
    freq.put(" Ши", 10);
    freq.put("Пра", 39);
    freq.put(" Шо", 14);
    freq.put(" Шв", 7);
    freq.put("Про", 176);
    freq.put(" Ша", 20);
    freq.put("При", 126);
    freq.put(" Ше", 16);
    freq.put("нц ", 7);
    freq.put("тор", 633);
    freq.put("тбе", 225);
    freq.put("тбо", 96);
    freq.put("Зем", 9);
    freq.put("до ", 273);
    freq.put("нфо", 50);
    freq.put("тбу", 11);
    freq.put("нфе", 19);
    freq.put("По ", 22);
    freq.put("© ", 11);
    freq.put("дия", 14);
    freq.put("дию", 11);
    freq.put("диш", 15);
    freq.put("дич", 21);
    freq.put("диц", 33);
    freq.put("уат", 9);
    freq.put("дит", 619);
    freq.put("дис", 54);
    freq.put("дир", 12);
    freq.put("дип", 13);
    freq.put("дио", 47);
    freq.put("дин", 178);
    freq.put("дим", 78);
    freq.put("дил", 94);
    freq.put("дик", 39);
    freq.put("дий", 10);
    freq.put("дии", 18);
    freq.put("диз", 17);
    freq.put("дие", 109);
    freq.put("див", 48);
    freq.put("диа", 84);
    freq.put("пи ", 12);
    freq.put("ыщ ", 8);
    freq.put("яво", 10);
    freq.put("Р", 585);
    freq.put("явк", 16);
    freq.put("явл", 64);
    freq.put("яви", 47);
    freq.put("где", 75);
    freq.put("гдз", 10);
    freq.put("гда", 396);
    freq.put("гу ", 129);
    freq.put("ая ", 1094);
    freq.put(" ща", 14);
    freq.put(" ще", 14);
    freq.put("себ", 141);
    freq.put("сег", 246);
    freq.put("сев", 15);
    freq.put("сед", 48);
    freq.put("сез", 50);
    freq.put("сей", 94);
    freq.put("сел", 91);
    freq.put("сек", 101);
    freq.put("сен", 77);
    freq.put("сем", 170);
    freq.put("исн", 11);
    freq.put("хре", 12);
    freq.put("Гов", 14);
    freq.put("Гон", 7);
    freq.put("Гол", 29);
    freq.put("хра", 43);
    freq.put(" Ос", 42);
    freq.put(" Ор", 15);
    freq.put(" От", 182);
    freq.put(" Ох", 7);
    freq.put(" Оф", 7);
    freq.put(" Оч", 25);
    freq.put(" Ой", 10);
    freq.put(" Ол", 30);
    freq.put(" Ок", 13);
    freq.put(" Он", 74);
    freq.put(" Ом", 7);
    freq.put(" Оп", 34);
    freq.put(" Об", 68);
    freq.put(" Ог", 10);
    freq.put(" Од", 78);
    freq.put("Гот", 7);
    freq.put("Гор", 20);
    freq.put("Гос", 21);
    freq.put("сес", 26);
    freq.put("сер", 222);
    freq.put("сет", 53);
    freq.put("сех", 63);
    freq.put("сеч", 12);
    freq.put("сещ", 9);
    freq.put("сл ", 8);
    freq.put("аем", 88);
    freq.put("аеб", 36);
    freq.put("аев", 17);
    freq.put("зят", 35);
    freq.put("ео ", 158);
    freq.put("зяй", 7);
    freq.put("зял", 13);
    freq.put("ье ", 80);
    freq.put("аеш", 101);
    freq.put("РТ ", 8);
    freq.put("ту ", 181);
    freq.put("ает", 529);
    freq.put("щат", 30);
    freq.put("бны", 37);
    freq.put("щас", 8);
    freq.put("щаю", 20);
    freq.put("щая", 26);
    freq.put("Все", 110);
    freq.put("аз ", 130);
    freq.put("Ь ", 154);
    freq.put("бъе", 15);
    freq.put("бъя", 36);
    freq.put("ха ", 89);
    freq.put("ЛА ", 11);
    freq.put("Вст", 8);
    freq.put("Яп", 8);
    freq.put("бни", 43);
    freq.put("Ян", 20);
    freq.put("щад", 16);
    freq.put("Всё", 21);
    freq.put("бна", 23);
    freq.put("щай", 7);
    freq.put("бне", 9);
    freq.put("мы ", 279);
    freq.put("Бля", 14);
    freq.put("уац", 12);
    freq.put("фта", 9);
    freq.put("ИН ", 7);
    freq.put("дце", 22);
    freq.put("дца", 19);
    freq.put("млн", 10);
    freq.put("мли", 12);
    freq.put("мле", 40);
    freq.put("Бли", 17);
    freq.put(" Це", 24);
    freq.put("Бло", 9);
    freq.put("Бла", 9);
    freq.put("нцу", 19);
    freq.put("нцы", 16);
    freq.put("Сам", 49);
    freq.put("Сан", 22);
    freq.put("з", 8045);
    freq.put("др ", 42);
    freq.put("нца", 25);
    freq.put("нце", 71);
    freq.put("нци", 61);
    freq.put("нцо", 10);
    freq.put("уу ", 19);
    freq.put("уал", 49);
    freq.put("уан", 10);
    freq.put("ыв ", 8);
    freq.put("дох", 39);
    freq.put("доч", 35);
    freq.put("дос", 163);
    freq.put("дор", 139);
    freq.put("дот", 18);
    freq.put("дош", 7);
    freq.put("дое", 21);
    freq.put("доз", 22);
    freq.put("дож", 55);
    freq.put("доб", 145);
    freq.put("дог", 31);
    freq.put("дов", 193);
    freq.put("дон", 51);
    freq.put("дом", 270);
    freq.put("доп", 17);
    freq.put("дой", 36);
    freq.put("дол", 195);
    freq.put("док", 51);
    freq.put("влю", 31);
    freq.put("вля", 119);
    freq.put("Пок", 13);
    freq.put("Пол", 57);
    freq.put("Пои", 8);
    freq.put("Поп", 37);
    freq.put("Пом", 23);
    freq.put("Пон", 7);
    freq.put("Пог", 12);
    freq.put("Поб", 14);
    freq.put("Пож", 9);
    freq.put("Поз", 23);
    freq.put("Под", 36);
    freq.put("шс", 8);
    freq.put("Кур", 16);
    freq.put("ывы", 51);
    freq.put("ывш", 12);
    freq.put("ыво", 19);
    freq.put("юри", 13);
    freq.put("ыва", 249);
    freq.put("лё", 23);
    freq.put("ди ", 302);
    freq.put("Аст", 10);
    freq.put("Куб", 12);
    freq.put("Куп", 20);
    freq.put("Пош", 7);
    freq.put("Пот", 19);
    freq.put("Пор", 21);
    freq.put("Пос", 66);
    freq.put("Поч", 52);
    freq.put("Пох", 23);
    freq.put("вле", 181);
    freq.put("вла", 41);
    freq.put("АЮ ", 12);
    freq.put("вло", 21);
    freq.put("вли", 25);
    freq.put("щё ", 48);
    freq.put("Тел", 12);
    freq.put("Эс", 9);
    freq.put("Теп", 60);
    freq.put("Эт", 93);
    freq.put("Теб", 9);
    freq.put("цве", 38);
    freq.put("Ш", 131);
    freq.put("дку", 9);
    freq.put("лр", 8);
    freq.put("лч", 23);
    freq.put("дка", 39);
    freq.put("ува", 25);
    freq.put("дке", 12);
    freq.put("уве", 220);
    freq.put("дки", 172);
    freq.put("дкл", 15);
    freq.put("уво", 10);
    freq.put("дко", 32);
    freq.put("лше", 9);
    freq.put("лш", 9);
    freq.put("Име", 7);
    freq.put("лэ", 8);
    freq.put("Эм", 8);
    freq.put("Тер", 7);
    freq.put("Эл", 20);
    freq.put("Эк", 27);
    freq.put("рт", 583);
    freq.put("ру", 1768);
    freq.put("рр", 153);
    freq.put("рс", 353);
    freq.put("рц", 18);
    freq.put("рч", 41);
    freq.put("рф", 25);
    freq.put("рх", 41);
    freq.put("ры", 923);
    freq.put("рш", 95);
    freq.put("рщ", 8);
    freq.put("рю", 77);
    freq.put("ря", 545);
    freq.put("рь", 406);
    freq.put("рэ", 17);
    freq.put("рё", 27);
    freq.put("пу ", 33);
    freq.put("Аха", 14);
    freq.put("шу ", 43);
    freq.put("лп", 12);
    freq.put("рв", 252);
    freq.put("рг", 261);
    freq.put("ра", 5219);
    freq.put("рб", 116);
    freq.put("рж", 132);
    freq.put("рз", 13);
    freq.put("рд", 159);
    freq.put("ре", 3719);
    freq.put("рк", 264);
    freq.put("рл", 57);
    freq.put("ри", 2567);
    freq.put("ро", 5011);
    freq.put("рп", 59);
    freq.put("рм", 368);
    freq.put("рн", 600);
    freq.put("пну", 7);
    freq.put("пны", 15);
    freq.put("жно", 351);
    freq.put("Вну", 8);
    freq.put("ощи", 9);
    freq.put("жни", 45);
    freq.put("ощн", 10);
    freq.put("оща", 36);
    freq.put("жне", 50);
    freq.put("жна", 46);
    freq.put("още", 19);
    freq.put("ыже", 10);
    freq.put("ыжа", 22);
    freq.put("ыжи", 35);
    freq.put("жны", 78);
    freq.put("ощь", 101);
    freq.put("ощу", 11);
    freq.put("йфо", 21);
    freq.put("пни", 11);
    freq.put("пно", 14);
    freq.put("её ", 32);
    freq.put("ьц", 33);
    freq.put("ем ", 716);
    freq.put("рги", 42);
    freq.put("рго", 14);
    freq.put("ЗА ", 13);
    freq.put("Ну ", 55);
    freq.put("РФ ", 16);
    freq.put("тс ", 11);
    freq.put("спе", 128);
    freq.put("спб", 17);
    freq.put("спа", 193);
    freq.put("еял", 11);
    freq.put("спо", 239);
    freq.put("спл", 225);
    freq.put(" яр", 22);
    freq.put("спи", 205);
    freq.put("Где", 27);
    freq.put("ай ", 302);
    freq.put("тят", 44);
    freq.put("тях", 10);
    freq.put("екц", 44);
    freq.put("екр", 54);
    freq.put("екс", 177);
    freq.put("ект", 191);
    freq.put("еку", 26);
    freq.put("УЙ ", 8);
    freq.put("ВА ", 7);
    freq.put("еко", 82);
    freq.put("еки", 27);
    freq.put("екл", 36);
    freq.put("екд", 10);
    freq.put("еке", 18);
    freq.put("ека", 141);
    freq.put("тяк", 9);
    freq.put("тям", 10);
    freq.put("тян", 26);
    freq.put("тяб", 19);
    freq.put("тяж", 18);
    freq.put("еят", 23);
    freq.put(" ян", 27);
    freq.put("спу", 30);
    freq.put("спр", 86);
    freq.put(" яз", 68);
    freq.put(" яд", 11);
    freq.put(" яв", 22);
    freq.put("тве", 259);
    freq.put(" яб", 11);
    freq.put("алт", 12);
    freq.put("Сер", 40);
    freq.put("алс", 58);
    freq.put("алы", 46);
    freq.put("алю", 17);
    freq.put("аля", 36);
    freq.put("аль", 537);
    freq.put("Ор", 15);
    freq.put("Ос", 43);
    freq.put("От", 182);
    freq.put("Оф", 7);
    freq.put("Ох", 7);
    freq.put("Оч", 25);
    freq.put("зы ", 49);
    freq.put("п", 13059);
    freq.put("Ой", 10);
    freq.put("Ок", 13);
    freq.put("Ол", 30);
    freq.put("Ом", 7);
    freq.put("Он", 74);
    freq.put("Оп", 36);
    freq.put("Об", 71);
    freq.put("Ог", 10);
    freq.put("Од", 79);
    freq.put("Сег", 50);
    freq.put("ье", 227);
    freq.put("але", 164);
    freq.put("Сей", 9);
    freq.put("алл", 34);
    freq.put("али", 526);
    freq.put("Сек", 13);
    freq.put("ало", 222);
    freq.put("Сем", 8);
    freq.put("алм", 11);
    freq.put("Выб", 10);
    freq.put("Вып", 7);
    freq.put("Муз", 7);
    freq.put("бье", 7);
    freq.put("ьва", 8);
    freq.put("бью", 13);
    freq.put("узк", 14);
    freq.put("ол ", 82);
    freq.put("Выс", 18);
    freq.put(" ид", 112);
    freq.put("фы", 11);
    freq.put("ойт", 83);
    freq.put("фф", 46);
    freq.put("ойс", 18);
    freq.put("фт", 165);
    freq.put("фу", 92);
    freq.put("фр", 48);
    freq.put("фс", 12);
    freq.put("Е", 269);
    freq.put("ЯТ ", 9);
    freq.put(" ис", 170);
    freq.put("ины", 130);
    freq.put("ойк", 25);
    freq.put("фл", 38);
    freq.put("ойм", 26);
    freq.put("ойн", 82);
    freq.put("шло", 47);
    freq.put("фе", 208);
    freq.put("нт ", 131);
    freq.put("ойд", 53);
    freq.put("чре", 7);
    freq.put("эск", 8);
    freq.put("цки", 25);
    freq.put("Кст", 7);
    freq.put("Укр", 38);
    freq.put("АА ", 13);
    freq.put("яц ", 16);
    freq.put("ыде", 16);
    freq.put("ыда", 28);
    freq.put("цке", 14);
    freq.put("Э ", 20);
    freq.put("Пит", 14);
    freq.put("эст", 7);
    freq.put("Усл", 7);
    freq.put("пул", 30);
    freq.put("пун", 11);
    freq.put("пуп", 8);
    freq.put("пуб", 26);
    freq.put("пуг", 15);
    freq.put("пуз", 8);
    freq.put("ише", 49);
    freq.put("ишл", 35);
    freq.put("ишк", 41);
    freq.put("иши", 36);
    freq.put("ишн", 14);
    freq.put("жпо", 14);
    freq.put("л", 19838);
    freq.put("юци", 13);
    freq.put("ебр", 16);
    freq.put("шут", 26);
    freq.put("РО ", 11);
    freq.put("шую", 11);
    freq.put("ишу", 18);
    freq.put("р ", 869);
    freq.put("Впе", 9);
    freq.put("ишь", 122);
    freq.put("йца", 15);
    freq.put("пус", 147);
    freq.put("пут", 66);
    freq.put("ёшь", 8);
    freq.put("ул", 526);
    freq.put("ук", 452);
    freq.put("уй", 158);
    freq.put("уи", 30);
    freq.put("уп", 481);
    freq.put("уо", 12);
    freq.put("ун", 195);
    freq.put("мег", 9);
    freq.put("уг", 367);
    freq.put("ув", 373);
    freq.put("уб", 576);
    freq.put("уа", 94);
    freq.put("уз", 310);
    freq.put("уж", 674);
    freq.put("уе", 205);
    freq.put("рта", 77);
    freq.put("ущ", 92);
    freq.put("уш", 365);
    freq.put("уя", 42);
    freq.put("ую", 375);
    freq.put("уу", 80);
    freq.put("ут", 1098);
    freq.put("ус", 783);
    freq.put("ур", 635);
    freq.put("уч", 693);
    freq.put("уц", 13);
    freq.put("ух", 132);
    freq.put("уф", 21);
    freq.put("ЛЬ ", 12);
    freq.put(" эф", 24);
    freq.put(" эр", 10);
    freq.put(" эс", 15);
    freq.put(" эт", 694);
    freq.put("Б", 666);
    freq.put("тст", 60);
    freq.put("тсу", 8);
    freq.put("тся", 578);
    freq.put("емы", 81);
    freq.put("емя", 82);
    freq.put("емь", 45);
    freq.put("ему", 225);
    freq.put("емс", 24);
    freq.put("емц", 57);
    freq.put("Нуж", 12);
    freq.put("емл", 43);
    freq.put("еми", 52);
    freq.put("емо", 67);
    freq.put("емп", 32);
    freq.put("емн", 47);
    freq.put("ема", 167);
    freq.put("еме", 148);
    freq.put("мей", 24);
    freq.put("тск", 96);
    freq.put(" эм", 13);
    freq.put(" эн", 33);
    freq.put(" эп", 8);
    freq.put(" эй", 14);
    freq.put(" эк", 129);
    freq.put(" эл", 72);
    freq.put("айк", 33);
    freq.put("айл", 14);
    freq.put("айм", 22);
    freq.put("айн", 304);
    freq.put("айо", 26);
    freq.put("айп", 17);
    freq.put("айв", 109);
    freq.put("айд", 44);
    freq.put("айз", 8);
    freq.put("ея ", 34);
    freq.put("ек ", 172);
    freq.put(" я ", 999);
    freq.put("айш", 12);
    freq.put("тя ", 42);
    freq.put("айс", 42);
    freq.put("айт", 229);
    freq.put("айф", 26);
    freq.put("инв", 23);
    freq.put("риу", 7);
    freq.put("еге", 18);
    freq.put("зык", 109);
    freq.put("упп", 51);
    freq.put("зыв", 136);
    freq.put("?", 194);
    freq.put("зыр", 8);
    freq.put("вух", 16);
    freq.put("ал ", 616);
    freq.put("О ", 300);
    freq.put("олс", 15);
    freq.put("олт", 13);
    freq.put("олу", 161);
    freq.put("олч", 21);
    freq.put("олш", 9);
    freq.put("олы", 50);
    freq.put("оль", 881);
    freq.put("олю", 26);
    freq.put("оля", 49);
    freq.put("щае", 26);
    freq.put("Вы ", 45);
    freq.put("дти", 15);
    freq.put("дтв", 7);
    freq.put("ола", 83);
    freq.put("олб", 15);
    freq.put("олг", 88);
    freq.put("олд", 34);
    freq.put("оле", 275);
    freq.put("олж", 122);
    freq.put("оли", 180);
    freq.put("олк", 92);
    freq.put("олл", 65);
    freq.put("олм", 7);
    freq.put("олн", 126);
    freq.put("оло", 629);
    freq.put("олп", 10);
    freq.put("нтя", 7);
    freq.put("нты", 49);
    freq.put("хва", 48);
    freq.put("нтр", 77);
    freq.put("нтс", 19);
    freq.put("нту", 17);
    freq.put("нтн", 20);
    freq.put("нто", 64);
    freq.put("нти", 106);
    freq.put("нтл", 7);
    freq.put("тпр", 29);
    freq.put("нте", 194);
    freq.put("ой ", 1446);
    freq.put("тпу", 17);
    freq.put("нта", 357);
    freq.put("ф ", 45);
    freq.put("опя", 30);
    freq.put("йши", 9);
    freq.put("опы", 40);
    freq.put("опр", 148);
    freq.put("опт", 20);
    freq.put("опу", 54);
    freq.put("№", 8);
    freq.put("дви", 54);
    freq.put(" Юр", 9);
    freq.put("иня", 50);
    freq.put("ым ", 213);
    freq.put("лаз", 76);
    freq.put(" Юл", 12);
    freq.put("лай", 173);
    freq.put(" Юб", 7);
    freq.put("лак", 39);
    freq.put("Хар", 8);
    freq.put("лам", 72);
    freq.put("фек", 34);
    freq.put("лан", 189);
    freq.put("опо", 89);
    freq.put("опп", 12);
    freq.put("опи", 51);
    freq.put("опл", 29);
    freq.put("опе", 135);
    freq.put("опа", 135);
    freq.put("тле", 22);
    freq.put("тла", 7);
    freq.put("ца ", 135);
    freq.put("инн", 41);
    freq.put("тло", 10);
    freq.put("тли", 87);
    freq.put("лат", 437);
    freq.put("дня", 231);
    freq.put("фев", 10);
    freq.put("нюю", 9);
    freq.put("Леч", 41);
    freq.put("инл", 7);
    freq.put("Лет", 12);
    freq.put("лаш", 22);
    freq.put("у", 14023);
    freq.put("Лео", 8);
    freq.put("Лен", 17);
    freq.put("уд ", 25);
    freq.put("Лек", 7);
    freq.put("дд ", 8);
    freq.put("Лев", 8);
    freq.put("ыря", 8);
    freq.put("льф", 13);
    freq.put("льц", 33);
    freq.put("льч", 30);
    freq.put("льс", 131);
    freq.put("льт", 112);
    freq.put("ужч", 52);
    freq.put("лья", 53);
    freq.put("льш", 299);
    freq.put("ужс", 15);
    freq.put("льд", 14);
    freq.put("лье", 30);
    freq.put("льз", 95);
    freq.put("ужк", 8);
    freq.put("льб", 26);
    freq.put("льв", 11);
    freq.put("льг", 11);
    freq.put("льм", 119);
    freq.put("льн", 805);
    freq.put("льо", 8);
    freq.put("уже", 282);
    freq.put("джа", 13);
    freq.put("льк", 327);
    freq.put("Час", 13);
    freq.put("НЬ ", 16);
    freq.put("чь ", 56);
    freq.put("Й", 27);
    freq.put("По", 473);
    freq.put("Пл", 40);
    freq.put("До ", 7);
    freq.put("Пи", 50);
    freq.put("Пе", 123);
    freq.put("Па", 64);
    freq.put("ийс", 106);
    freq.put("оя ", 92);
    freq.put("ийн", 9);
    freq.put("Пя", 10);
    freq.put("Пу", 52);
    freq.put("Пр", 411);
    freq.put("пп ", 8);
    freq.put("итн", 81);
    freq.put(" мр", 10);
    freq.put("июн", 27);
    freq.put("ОЕ ", 19);
    freq.put(" мэ", 9);
    freq.put("ыка", 38);
    freq.put("ыке", 17);
    freq.put(" мы", 172);
    freq.put("ыки", 18);
    freq.put("итк", 10);
    freq.put("ыко", 10);
    freq.put("йся", 37);
    freq.put("ите", 549);
    freq.put("Дим", 8);
    freq.put("Дие", 46);
    freq.put("ита", 339);
    freq.put("ыку", 28);
    freq.put("итв", 12);
    freq.put("оэт", 23);
    freq.put("йст", 91);
    freq.put("Уче", 10);
    freq.put("рау", 18);
    freq.put("рат", 347);
    freq.put("рас", 556);
    freq.put("рач", 36);
    freq.put("рац", 134);
    freq.put("рах", 64);
    freq.put("раф", 215);
    freq.put("ращ", 43);
    freq.put("раш", 55);
    freq.put("рая", 32);
    freq.put("раю", 41);
    freq.put("вы ", 219);
    freq.put("хн", 85);
    freq.put("хм", 22);
    freq.put("хо", 1176);
    freq.put("хи", 193);
    freq.put("хл", 30);
    freq.put("хе", 134);
    freq.put("хд", 39);
    freq.put("ха", 533);
    freq.put("хв", 53);
    freq.put("хэ", 11);
    freq.put("хх", 30);
    freq.put("хс", 20);
    freq.put("хр", 81);
    freq.put("ху", 337);
    freq.put("хт", 21);
    freq.put("еи ", 11);
    freq.put("раг", 36);
    freq.put("рав", 486);
    freq.put("раб", 211);
    freq.put("раа", 11);
    freq.put("раз", 495);
    freq.put("раж", 98);
    freq.put("рае", 27);
    freq.put("рад", 232);
    freq.put("рал", 274);
    freq.put("рак", 116);
    freq.put("рай", 163);
    freq.put("раи", 76);
    freq.put("рап", 27);
    freq.put("ран", 556);
    freq.put("рам", 196);
    freq.put("сут", 32);
    freq.put("сус", 7);
    freq.put("сур", 13);
    freq.put("сух", 7);
    freq.put("сущ", 25);
    freq.put("суш", 7);
    freq.put("тых", 150);
    freq.put("тыр", 24);
    freq.put("тыс", 22);
    freq.put("ежу", 10);
    freq.put("ДУ ", 8);
    freq.put("ежи", 48);
    freq.put("ежк", 11);
    freq.put("ежн", 43);
    freq.put("ежп", 14);
    freq.put("ежа", 29);
    freq.put("ежд", 80);
    freq.put("еже", 19);
    freq.put("тыд", 10);
    freq.put("тые", 32);
    freq.put("тыв", 33);
    freq.put("тым", 11);
    freq.put("тый", 25);
    freq.put("тыл", 9);
    freq.put("ан ", 331);
    freq.put("зиц", 16);
    freq.put("суг", 19);
    freq.put("суб", 7);
    freq.put("суа", 9);
    freq.put("суж", 24);
    freq.put("суе", 9);
    freq.put("суд", 78);
    freq.put("сул", 24);
    freq.put("сук", 14);
    freq.put("суп", 25);
    freq.put("сун", 17);
    freq.put("сум", 26);
    freq.put("апы", 14);
    freq.put("апт", 12);
    freq.put("апу", 27);
    freq.put("апр", 105);
    freq.put("апс", 8);
    freq.put("с ", 2156);
    freq.put("зия", 14);
    freq.put("ьм ", 50);
    freq.put("йле", 9);
    freq.put("йли", 15);
    freq.put("щал", 25);
    freq.put("апо", 41);
    freq.put("апп", 21);
    freq.put("апн", 9);
    freq.put("апк", 7);
    freq.put("апл", 22);
    freq.put("апи", 135);
    freq.put("апе", 25);
    freq.put("апа", 70);
    freq.put("рин", 176);
    freq.put("тна", 78);
    freq.put("тне", 27);
    freq.put("тни", 95);
    freq.put("тно", 400);
    freq.put("Эль", 7);
    freq.put("Эле", 8);
    freq.put("ём ", 23);
    freq.put("нра", 131);
    freq.put("оп ", 57);
    freq.put("тну", 17);
    freq.put("тны", 183);
    freq.put("тню", 10);
    freq.put("тня", 10);
    freq.put("цан", 10);
    freq.put("цам", 24);
    freq.put("осу", 63);
    freq.put("фте", 16);
    freq.put("итя", 9);
    freq.put("удр", 11);
    freq.put("уду", 152);
    freq.put("удь", 206);
    freq.put("удя", 8);
    freq.put("удш", 7);
    freq.put("уде", 407);
    freq.put("уда", 235);
    freq.put("ню ", 53);
    freq.put("удн", 41);
    freq.put("удо", 70);
    freq.put("уди", 220);
    freq.put("дде", 20);
    freq.put("ддд", 15);
    freq.put("цах", 11);
    freq.put("цар", 21);
    freq.put("цат", 15);
    freq.put("итр", 30);
    freq.put("иту", 173);
    freq.put("чью", 17);
    freq.put("Вам", 15);
    freq.put("√", 8);
    freq.put("шед", 14);
    freq.put("мни", 53);
    freq.put("шев", 51);
    freq.put("шег", 53);
    freq.put("шем", 42);
    freq.put("ль ", 287);
    freq.put("уж ", 37);
    freq.put("вщи", 9);
    freq.put("шей", 41);
    freq.put("эээ", 8);
    freq.put("ппу", 10);
    freq.put("ппы", 15);
    freq.put("шеч", 10);
    freq.put("оян", 39);
    freq.put("оял", 11);
    freq.put("ояб", 7);
    freq.put("ояв", 47);
    freq.put("Доб", 33);
    freq.put("Дон", 9);
    freq.put("Дом", 37);
    freq.put("ыиг", 8);
    freq.put("Дол", 9);
    freq.put("Док", 14);
    freq.put("Дос", 13);
    freq.put("Дор", 12);
    freq.put("ий ", 712);
    freq.put("Вла", 20);
    freq.put("оящ", 27);
    freq.put("ояр", 29);
    freq.put("ояс", 12);
    freq.put("оят", 36);
    freq.put("Вас", 24);
    freq.put("ппе", 16);
    freq.put("ппа", 33);
    freq.put("ппо", 10);
    freq.put("ию ", 241);
    freq.put("Мер", 8);
    freq.put("Мет", 12);
    freq.put("БО ", 9);
    freq.put("ык ", 26);
    freq.put("Мед", 15);
    freq.put("Меж", 16);
    freq.put("Мен", 24);
    freq.put("сни", 284);
    freq.put("сно", 241);
    freq.put("сна", 54);
    freq.put("сне", 48);
    freq.put("Йор", 7);
    freq.put("Ла", 54);
    freq.put("тат", 285);
    freq.put("Ле", 120);
    freq.put("Ли", 57);
    freq.put("х ", 1684);
    freq.put("еис", 10);
    freq.put("еиз", 9);
    freq.put("вца", 8);
    freq.put("Лу", 58);
    freq.put("Лю", 71);
    freq.put("Ль", 8);
    freq.put("Бри", 9);
    freq.put("Бра", 11);
    freq.put("сны", 65);
    freq.put("ра ", 623);
    freq.put("сня", 49);
    freq.put("сню", 15);
    freq.put("сну", 38);
    freq.put("ТВ ", 8);
    freq.put("анф", 8);
    freq.put("анц", 68);
    freq.put("анч", 16);
    freq.put("анс", 152);
    freq.put("ант", 120);
    freq.put("ану", 52);
    freq.put("ань", 79);
    freq.put("аня", 50);
    freq.put("анш", 12);
    freq.put("аны", 83);
    freq.put("ятк", 13);
    freq.put("ты ", 796);
    freq.put("су ", 31);
    freq.put("анд", 154);
    freq.put("ане", 153);
    freq.put("ана", 193);
    freq.put("Сло", 21);
    freq.put("анг", 63);
    freq.put("анн", 182);
    freq.put("ано", 231);
    freq.put("ани", 1043);
    freq.put("анк", 231);
    freq.put("сб", 85);
    freq.put("са", 1069);
    freq.put("сг", 15);
    freq.put("ьми", 26);
    freq.put("се", 1920);
    freq.put("ьмо", 22);
    freq.put("сж", 10);
    freq.put("си", 1094);
    freq.put("сл", 1071);
    freq.put("ск", 2781);
    freq.put("сн", 798);
    freq.put("см", 641);
    freq.put("сп", 1141);
    freq.put("со", 1524);
    freq.put("сс", 923);
    freq.put("ср", 157);
    freq.put("су", 398);
    freq.put("ст", 5642);
    freq.put("сх", 145);
    freq.put("сф", 22);
    freq.put("сч", 138);
    freq.put("сц", 26);
    freq.put("ьму", 16);
    freq.put("сш", 96);
    freq.put("сы", 218);
    freq.put("съ", 24);
    freq.put("сэ", 8);
    freq.put("сь", 800);
    freq.put("ся", 1368);
    freq.put("сю", 39);
    freq.put("сё", 106);
    freq.put("йл ", 7);
    freq.put("лён", 9);
    freq.put("ап ", 9);
    freq.put("тая", 37);
    freq.put("ЛИ ", 19);
    freq.put("юли", 9);
    freq.put("Спр", 9);
    freq.put("едв", 31);
    freq.put("еда", 109);
    freq.put("едж", 12);
    freq.put("еде", 192);
    freq.put("👍", 8);
    freq.put("едл", 56);
    freq.put("еди", 476);
    freq.put("едо", 105);
    freq.put("едп", 23);
    freq.put("едм", 10);
    freq.put("едн", 137);
    freq.put("еду", 88);
    freq.put("едр", 10);
    freq.put("едс", 113);
    freq.put("еды", 154);
    freq.put("едш", 11);
    freq.put("едь", 43);
    freq.put("све", 69);
    freq.put("Спа", 41);
    freq.put("Спо", 22);
    freq.put("Спи", 14);
    freq.put("сви", 25);
    freq.put("ИЕ ", 13);
    freq.put("сво", 389);
    freq.put("гэ", 12);
    freq.put("гу", 315);
    freq.put("гт", 8);
    freq.put("гс", 8);
    freq.put("гр", 1413);
    freq.put("Осо", 11);
    freq.put("Ита", 14);
    freq.put("Аль", 17);
    freq.put("Фра", 18);
    freq.put("Не ", 110);
    freq.put("Ост", 18);
    freq.put(" а ", 549);
    freq.put("Але", 30);
    freq.put("гл", 353);
    freq.put("гк", 59);
    freq.put("ги", 570);
    freq.put("го", 2817);
    freq.put("гн", 83);
    freq.put("гм", 8);
    freq.put("гв", 9);
    freq.put("га", 782);
    freq.put("ге", 281);
    freq.put("гд", 485);
    freq.put("он ", 380);
    freq.put("огр", 208);
    freq.put("огу", 131);
    freq.put(" вх", 15);
    freq.put(" вч", 27);
    freq.put(" вс", 828);
    freq.put(" вр", 193);
    freq.put(" ву", 8);
    freq.put(" вт", 58);
    freq.put(" вь", 11);
    freq.put(" вы", 632);
    freq.put(" ве", 514);
    freq.put(" вд", 23);
    freq.put(" вз", 132);
    freq.put(" ва", 521);
    freq.put(" вв", 19);
    freq.put(" вн", 68);
    freq.put(" вм", 51);
    freq.put(" вп", 51);
    freq.put(" во", 800);
    freq.put(" ви", 507);
    freq.put(" вл", 67);
    freq.put(" вк", 102);
    freq.put("цу ", 64);
    freq.put("нь ", 466);
    freq.put("оги", 175);
    freq.put("огл", 56);
    freq.put("огн", 24);
    freq.put("ого", 1042);
    freq.put("ога", 125);
    freq.put("огд", 318);
    freq.put("оге", 29);
    freq.put("М ", 78);
    freq.put("зд ", 17);
    freq.put("рр ", 10);
    freq.put("яю ", 28);
    freq.put("лю ", 125);
    freq.put("изи", 64);
    freq.put("еба", 67);
    freq.put("янв", 15);
    freq.put("яна", 14);
    freq.put("цко", 13);
    freq.put("яне", 16);
    freq.put("янд", 14);
    freq.put("янк", 9);
    freq.put("зжа", 27);
    freq.put("яни", 33);
    freq.put("яно", 18);
    freq.put("янн", 29);
    freq.put("зже", 7);
    freq.put("да ", 973);
    freq.put("уно", 10);
    freq.put("рте", 21);
    freq.put("д", 15222);
    freq.put("ртв", 20);
    freq.put("ртн", 22);
    freq.put("рто", 77);
    freq.put("рти", 144);
    freq.put("🙋", 13);
    freq.put("ртф", 16);
    freq.put("рту", 43);
    freq.put("рть", 8);
    freq.put("рты", 39);
    freq.put("яшн", 11);
    freq.put("яшк", 9);
    freq.put("ил ", 280);
    freq.put("т ", 4665);
    freq.put("😘", 10);
    freq.put("яну", 24);
    freq.put("янс", 35);
    freq.put("😂", 18);
    freq.put("яны", 13);
    freq.put("оу ", 39);
    freq.put("ынк", 14);
    freq.put("ир ", 53);
    freq.put("унк", 21);
    freq.put("инь", 16);
    freq.put("лаб", 26);
    freq.put("лав", 131);
    freq.put("лаг", 78);
    freq.put("лад", 129);
    freq.put("лае", 52);
    freq.put("лаж", 17);
    freq.put("дво", 38);
    freq.put("инф", 51);
    freq.put("два", 35);
    freq.put("инц", 38);
    freq.put("лал", 48);
    freq.put("две", 59);
    freq.put("инс", 276);
    freq.put("инт", 189);
    freq.put("ину", 134);
    freq.put("лар", 29);
    freq.put("лас", 618);
    freq.put("ино", 205);
    freq.put("лау", 8);
    freq.put("ини", 202);
    freq.put("лах", 20);
    freq.put("инк", 220);
    freq.put("лач", 31);
    freq.put("инд", 35);
    freq.put("ине", 125);
    freq.put("дву", 18);
    freq.put("инз", 8);
    freq.put("ина", 327);
    freq.put("инб", 16);
    freq.put("лаю", 32);
    freq.put("инг", 137);
    freq.put("осв", 22);
    freq.put("оса", 52);
    freq.put("ито", 155);
    freq.put("ити", 101);
    freq.put("итл", 8);
    freq.put("осе", 63);
    freq.put("оск", 292);
    freq.put("осл", 262);
    freq.put("оси", 119);
    freq.put("осо", 144);
    freq.put("осп", 73);
    freq.put("осм", 104);
    freq.put("осн", 55);
    freq.put("пеш", 29);
    freq.put("пет", 66);
    freq.put("пес", 67);
    freq.put("пер", 722);
    freq.put("печ", 56);
    freq.put("пец", 49);
    freq.put("пех", 16);
    freq.put("Уда", 16);
    freq.put("ТА ", 14);
    freq.put("пел", 26);
    freq.put("пек", 23);
    freq.put("пей", 21);
    freq.put("пен", 55);
    freq.put("пев", 17);
    freq.put("пед", 39);
    freq.put("ост", 1415);
    freq.put("ить", 954);
    freq.put("оср", 14);
    freq.put("осс", 217);
    freq.put("иты", 69);
    freq.put("осх", 9);
    freq.put("осы", 40);
    freq.put("итс", 174);
    freq.put("ося", 13);
    freq.put("ось", 181);
    freq.put("итт", 61);
    freq.put("ча ", 45);
    freq.put("рдц", 29);
    freq.put("Све", 13);
    freq.put("рдо", 18);
    freq.put("сс ", 67);
    freq.put("рди", 17);
    freq.put("рде", 17);
    freq.put("рда", 19);
    freq.put("НА ", 41);
    freq.put("ед ", 71);
    freq.put("Ира", 15);
    freq.put("ьон", 7);
    freq.put("а", 42769);
    freq.put("ьи ", 14);
    freq.put(" 😂", 9);
    freq.put("Оди", 19);
    freq.put("Одн", 48);
    freq.put("нзы", 7);
    freq.put("Оде", 11);
    freq.put("ьбо", 23);
    freq.put("онц", 66);
    freq.put("онч", 44);
    freq.put("онф", 20);
    freq.put("онт", 313);
    freq.put("ону", 31);
    freq.put("онр", 67);
    freq.put("онс", 68);
    freq.put("оня", 62);
    freq.put("онь", 8);
    freq.put("оны", 51);
    freq.put("Нес", 7);
    freq.put("Нет", 24);
    freq.put("зра", 34);
    freq.put(" ау", 22);
    freq.put(" ат", 22);
    freq.put(" ас", 28);
    freq.put(" ар", 67);
    freq.put(" ах", 93);
    freq.put(" аф", 8);
    freq.put(" аэ", 10);
    freq.put(" аг", 26);
    freq.put(" ав", 160);
    freq.put(" аб", 9);
    freq.put(" аа", 19);
    freq.put(" аж", 7);
    freq.put(" ад", 49);
    freq.put(" ал", 59);
    freq.put(" ак", 87);
    freq.put(" ай", 25);
    freq.put(" ап", 46);
    freq.put(" ан", 129);
    freq.put(" ам", 32);
    freq.put("Нед", 11);
    freq.put("Нев", 7);
    freq.put("Нем", 14);
    freq.put("Нео", 7);
    freq.put("Нек", 9);
    freq.put("онд", 48);
    freq.put("оне", 337);
    freq.put("онг", 13);
    freq.put("она", 296);
    freq.put("оно", 161);
    freq.put("онн", 116);
    freq.put("онк", 75);
    freq.put("онл", 118);
    freq.put("они", 281);
    freq.put("г ", 455);
    freq.put("Му", 41);
    freq.put("Зна", 75);
    freq.put("Мы", 33);
    freq.put("ньш", 50);
    freq.put("нью", 7);
    freq.put("нья", 20);
    freq.put("ньг", 37);
    freq.put("нье", 12);
    freq.put("ньк", 64);
    freq.put("ьце", 15);
    freq.put(" в ", 2667);
    freq.put("бку", 9);
    freq.put("Ма", 151);
    freq.put("Мо", 266);
    freq.put("Мн", 132);
    freq.put("Ми", 87);
    freq.put("ог ", 82);
    freq.put("зда", 101);
    freq.put("бки", 18);
    freq.put("зде", 97);
    freq.put("зди", 13);
    freq.put("здн", 43);
    freq.put("здо", 60);
    freq.put("ром", 224);
    freq.put("яющ", 10);
    freq.put("бко", 12);
    freq.put("яют", 41);
    freq.put("яюс", 9);
    freq.put("бка", 32);
    freq.put("люш", 8);
    freq.put("люц", 13);
    freq.put("люч", 89);
    freq.put("люх", 42);
    freq.put("лют", 17);
    freq.put("рро", 10);
    freq.put("люс", 36);
    freq.put("рру", 7);
    freq.put("люл", 7);
    freq.put("люз", 9);
    freq.put("люд", 151);
    freq.put("бке", 10);
    freq.put("щно", 7);
    freq.put("Ива", 9);
    freq.put("здр", 32);
    freq.put("зду", 18);
    freq.put("зды", 9);
    freq.put("тф", 32);
    freq.put("тх", 7);
    freq.put("тц", 14);
    freq.put("тч", 73);
    freq.put("тр", 2084);
    freq.put("тс", 780);
    freq.put("тт", 109);
    freq.put("ту", 880);
    freq.put("ть", 4122);
    freq.put("тэ", 11);
    freq.put("тю", 45);
    freq.put("тя", 194);
    freq.put("ты", 1187);
    freq.put("ян ", 23);
    freq.put("тё", 16);
    freq.put("цк ", 11);
    freq.put("рт ", 87);
    freq.put("юрь", 7);
    freq.put("юря", 7);
    freq.put("уша", 71);
    freq.put("илы", 23);
    freq.put("дае", 52);
    freq.put("дад", 13);
    freq.put("даг", 7);
    freq.put("иля", 17);
    freq.put("иль", 258);
    freq.put("даа", 17);
    freq.put("уши", 34);
    freq.put("илу", 11);
    freq.put("дан", 171);
    freq.put("дам", 57);
    freq.put("дал", 228);
    freq.put("дак", 32);
    freq.put("дай", 28);
    freq.put("дач", 75);
    freq.put("дац", 8);
    freq.put("дах", 11);
    freq.put("ушу", 7);
    freq.put("ило", 190);
    freq.put("аю ", 327);
    freq.put("дас", 13);
    freq.put("дар", 132);
    freq.put("дая", 7);
    freq.put("даю", 71);
    freq.put("ила", 287);
    freq.put("иле", 84);
    freq.put("зря", 8);
    freq.put("чше", 83);
    freq.put("чша", 18);
    freq.put("чши", 62);
    freq.put("тд", 77);
    freq.put("те", 3240);
    freq.put("тз", 54);
    freq.put("та", 3513);
    freq.put("тб", 340);
    freq.put("тв", 1227);
    freq.put("тг", 7);
    freq.put("тм", 38);
    freq.put("тн", 826);
    freq.put("то", 5786);
    freq.put("тп", 56);
    freq.put("ти", 2404);
    freq.put("тк", 525);
    freq.put("тл", 139);
    freq.put("ирк", 20);
    freq.put("ири", 46);
    freq.put("иро", 251);
    freq.put("ирн", 13);
    freq.put("ирм", 10);
    freq.put("ира", 121);
    freq.put("ире", 124);
    freq.put("плу", 8);
    freq.put("оум", 11);
    freq.put("пля", 10);
    freq.put("плю", 24);
    freq.put("ла ", 931);
    freq.put("Уве", 95);
    freq.put("ыми", 93);
    freq.put("ч", 7257);
    freq.put("ыве", 12);
    freq.put("ин ", 293);
    freq.put("пла", 404);
    freq.put("пле", 93);
    freq.put("оус", 9);
    freq.put("оут", 18);
    freq.put("пло", 137);
    freq.put("иры", 11);
    freq.put("иру", 112);
    freq.put("ирт", 10);
    freq.put("ирс", 15);
    freq.put("ос ", 82);
    freq.put("рву", 11);
    freq.put("ит ", 591);
    freq.put("рвы", 81);
    freq.put("ЩЕ ", 9);
    freq.put("шаг", 10);
    freq.put("рве", 25);
    freq.put("рва", 37);
    freq.put("рвн", 8);
    freq.put("рво", 48);
    freq.put("рви", 31);
    freq.put("пе ", 37);
    freq.put("ссу", 10);
    freq.put("сст", 75);
    freq.put("ещь", 10);
    freq.put("ссы", 20);
    freq.put("ещё", 47);
    freq.put("чан", 25);
    freq.put("чай", 51);
    freq.put("чал", 96);
    freq.put("чае", 69);
    freq.put("Н", 1053);
    freq.put("цуз", 14);
    freq.put("ьет", 45);
    freq.put("лб", 29);
    freq.put("втр", 110);
    freq.put("вто", 207);
    freq.put("ТО ", 92);
    freq.put("ШЬ ", 8);
    freq.put("чаю", 35);
    freq.put("чая", 19);
    freq.put("чащ", 15);
    freq.put("чар", 16);
    freq.put("час", 315);
    freq.put("чат", 586);
    freq.put("ссе", 37);
    freq.put("еща", 46);
    freq.put("еще", 237);
    freq.put("сса", 53);
    freq.put("ссн", 205);
    freq.put("ещи", 21);
    freq.put("ссо", 38);
    freq.put("сси", 230);
    freq.put("ссл", 16);
    freq.put("рд ", 26);
    freq.put("Эф", 8);
    freq.put("Тул", 7);
    freq.put("ржу", 10);
    freq.put("Н ", 56);
    freq.put("и", 35380);
    freq.put("Мно", 24);
    freq.put("Мне", 108);
    freq.put("ржа", 41);
    freq.put("Ме", 91);
    freq.put("рже", 13);
    freq.put("ржд", 11);
    freq.put("Зре", 10);
    freq.put("бви", 22);
    freq.put("ржи", 35);
    freq.put("ржк", 11);
    freq.put("кн", 185);
    freq.put("Тур", 12);
    freq.put("ко", 4564);
    freq.put("Тут", 7);
    freq.put("НО ", 38);
    freq.put("елл", 24);
    freq.put("кл", 612);
    freq.put("гал", 56);
    freq.put("гам", 27);
    freq.put("кж", 8);
    freq.put("ев ", 154);
    freq.put("ка", 4122);
    freq.put("Рас", 33);
    freq.put("нга", 27);
    freq.put("кг", 21);
    freq.put("Раб", 10);
    freq.put("Раз", 43);
    freq.put("Рад", 7);
    freq.put("Рам", 7);
    freq.put("йп ", 7);
    freq.put("схе", 86);
    freq.put("дёт", 14);
    freq.put("тюм", 12);
    freq.put("схо", 53);
    freq.put("ехн", 36);
    freq.put("ехо", 29);
    freq.put("ехи", 17);
    freq.put("еха", 66);
    freq.put("еан", 11);
    freq.put("еак", 9);
    freq.put("еал", 49);
    freq.put("еаг", 7);
    freq.put("еат", 19);
    freq.put("хте", 9);
    freq.put("ащи", 50);
    freq.put("йна", 31);
    freq.put("йне", 19);
    freq.put("йни", 11);
    freq.put("йнк", 110);
    freq.put("уви", 46);
    freq.put("йно", 63);
    freq.put("об ", 63);
    freq.put("йны", 54);
    freq.put(" д ", 17);
    freq.put("аще", 45);
    freq.put("озр", 46);
    freq.put("озу", 10);
    freq.put("озь", 15);
    freq.put("озя", 13);
    freq.put("озы", 14);
    freq.put("жу ", 121);
    freq.put("рре", 77);
    freq.put("озд", 97);
    freq.put("озе", 41);

    init3();
  }
  private static void init3() {
    
    freq.put("озж", 10);
    freq.put("ар ", 64);
    freq.put("оза", 81);
    freq.put("озб", 7);
    freq.put("озв", 92);
    freq.put("озг", 37);
    freq.put("озм", 63);
    freq.put("озн", 186);
    freq.put("озо", 26);
    freq.put("ози", 53);
    freq.put("стк", 33);
    freq.put("озл", 14);
    freq.put("рри", 37);
    freq.put("стс", 8);
    freq.put("кр", 1336);
    freq.put("кт", 865);
    freq.put("за ", 521);
    freq.put("рф ", 7);
    freq.put(" жа", 56);
    freq.put("атч", 37);
    freq.put("атс", 23);
    freq.put("атр", 47);
    freq.put("ату", 95);
    freq.put(" жи", 260);
    freq.put("атя", 14);
    freq.put("аты", 114);
    freq.put(" жо", 26);
    freq.put("ате", 283);
    freq.put(" жр", 11);
    freq.put(" жу", 43);
    freq.put("ата", 162);
    freq.put("атв", 7);
    freq.put("атн", 251);
    freq.put("ато", 187);
    freq.put("ати", 233);
    freq.put("атл", 13);
    freq.put("атк", 28);
    freq.put("жск", 24);
    freq.put("люб", 290);
    freq.put("АК ", 39);
    freq.put("яже", 21);
    freq.put("мра", 9);
    freq.put("зву", 27);
    freq.put("звр", 26);
    freq.put("зле", 16);
    freq.put("звы", 7);
    freq.put("гле", 9);
    freq.put("бр", 789);
    freq.put("бу", 753);
    freq.put("бх", 21);
    freq.put("мог", 197);
    freq.put("бщ", 189);
    freq.put("бы", 891);
    freq.put("бъ", 51);
    freq.put("гли", 52);
    freq.put("бя", 303);
    freq.put("бю", 8);
    freq.put("Бал", 7);
    freq.put("рци", 9);
    freq.put("клю", 92);
    freq.put("нже", 7);
    freq.put("клы", 8);
    freq.put("клу", 37);
    freq.put("кло", 23);
    freq.put("кли", 52);
    freq.put("кле", 31);
    freq.put("Бан", 30);
    freq.put("кла", 358);
    freq.put("чты", 9);
    freq.put("Бав", 8);
    freq.put("бб", 17);
    freq.put("ба", 652);
    freq.put("бв", 27);
    freq.put("бе", 1469);
    freq.put("бз", 13);
    freq.put("бж", 10);
    freq.put("би", 714);
    freq.put("гля", 57);
    freq.put("бк", 82);
    freq.put("бн", 176);
    freq.put("бм", 19);
    freq.put("бо", 1713);
    freq.put("зве", 58);
    freq.put("цов", 33);
    freq.put("зва", 53);
    freq.put("зво", 128);
    freq.put("цом", 8);
    freq.put("яйт", 10);
    freq.put("зви", 35);
    freq.put("оч ", 10);
    freq.put("Х", 269);
    freq.put("ип ", 24);
    freq.put(" Б ", 9);
    freq.put("лдо", 16);
    freq.put("лда", 15);
    freq.put("д ", 653);
    freq.put("щущ", 11);
    freq.put("Бас", 14);
    freq.put("уют", 45);
    freq.put("ующ", 24);
    freq.put("가가가", 8);
    freq.put("ечь", 23);
    freq.put("ечу", 12);
    freq.put("ечт", 33);
    freq.put("уча", 145);
    freq.put("Пар", 25);
    freq.put("ЕН ", 8);
    freq.put("Не", 232);
    freq.put("На", 303);
    freq.put("мос", 234);
    freq.put("Но", 169);
    freq.put("Ни", 69);
    freq.put("Ну", 72);
    freq.put("Нь", 7);
    freq.put("ечк", 21);
    freq.put("ечи", 62);
    freq.put("ечн", 109);
    freq.put("счи", 39);
    freq.put("сче", 35);
    freq.put("еча", 118);
    freq.put("ече", 261);
    freq.put("сча", 59);
    freq.put("ег ", 40);
    freq.put("Ист", 17);
    freq.put("ав", 1606);
    freq.put("аг", 388);
    freq.put("аа", 310);
    freq.put("аб", 595);
    freq.put("аж", 555);
    freq.put("аз", 1198);
    freq.put("ад", 1097);
    freq.put("ае", 811);
    freq.put("ак", 3117);
    freq.put("яг", 54);
    freq.put("аи", 152);
    freq.put("ай", 1226);
    freq.put("ао", 36);
    freq.put("ап", 520);
    freq.put("ам", 1723);
    freq.put("ан", 3265);
    freq.put("еве", 66);
    freq.put("евз", 23);
    freq.put("вре", 147);
    freq.put("евн", 41);
    freq.put("ево", 175);
    freq.put("еви", 33);
    freq.put("вро", 102);
    freq.put("вру", 9);
    freq.put("евч", 14);
    freq.put("евр", 51);
    freq.put("евс", 42);
    freq.put("еву", 88);
    freq.put("ы", 8713);
    freq.put("евя", 10);
    freq.put("евы", 58);
    freq.put("ат", 3402);
    freq.put("ау", 123);
    freq.put("ар", 2024);
    freq.put("ас", 2539);
    freq.put("ац", 360);
    freq.put("ач", 953);
    freq.put("аф", 260);
    freq.put("ах", 904);
    freq.put("аш", 444);
    freq.put("ащ", 124);
    freq.put("аю", 742);
    freq.put("ая", 1196);
    freq.put("аэ", 14);
    freq.put("Сне", 7);
    freq.put("ех ", 111);
    freq.put("ьки", 44);
    freq.put("Ант", 12);
    freq.put("даж", 115);
    freq.put("ька", 34);
    freq.put("дав", 118);
    freq.put("ЛО ", 10);
    freq.put("Анд", 22);
    freq.put("Ана", 13);
    freq.put("Анг", 9);
    freq.put("Анн", 8);
    freq.put("ьку", 8);
    freq.put("ушк", 152);
    freq.put("илс", 80);
    freq.put("ушн", 11);
    freq.put("илк", 14);
    freq.put("илл", 50);
    freq.put("или", 458);
    freq.put("чёр", 8);
    freq.put("дат", 118);
    freq.put("С", 1443);
    freq.put("йн ", 128);
    freq.put("обр", 509);
    freq.put("обс", 64);
    freq.put("обх", 20);
    freq.put("объ", 49);
    freq.put("обы", 179);
    freq.put("общ", 180);
    freq.put("обя", 14);
    freq.put(" дь", 7);
    freq.put(" ды", 11);
    freq.put(" ду", 147);
    freq.put(" др", 310);
    freq.put(" до", 908);
    freq.put(" дн", 123);
    freq.put(" дл", 803);
    freq.put("чта", 19);
    freq.put(" ди", 276);
    freq.put(" дж", 26);
    freq.put(" де", 900);
    freq.put(" дв", 126);
    freq.put(" да", 463);
    freq.put("обв", 10);
    freq.put("что", 931);
    freq.put("оба", 82);
    freq.put("обб", 8);
    freq.put("обе", 140);
    freq.put("обк", 13);
    freq.put("обл", 157);
    freq.put("оби", 124);
    freq.put("обо", 159);
    freq.put("обм", 16);
    freq.put("обн", 86);
    freq.put("чти", 30);
    freq.put("сби", 18);
    freq.put("мцы", 7);
    freq.put("жур", 29);
    freq.put("жут", 17);
    freq.put("ару", 99);
    freq.put("арт", 255);
    freq.put("ьту", 15);
    freq.put("арр", 18);
    freq.put("ьтф", 14);
    freq.put("арх", 14);
    freq.put("ары", 50);
    freq.put("арш", 23);
    freq.put("аря", 43);
    freq.put("арь", 37);
    freq.put("арг", 11);
    freq.put("ьта", 33);
    freq.put("арб", 7);
    freq.put("ара", 243);
    freq.put("оз ", 51);
    freq.put("аре", 116);
    freq.put("ард", 46);
    freq.put("арл", 17);
    freq.put("арк", 99);
    freq.put("ари", 383);
    freq.put("арп", 18);
    freq.put("аро", 206);
    freq.put("арн", 132);
    freq.put("арм", 41);
    freq.put("жул", 8);
    freq.put("мце", 47);
    freq.put("яш", 32);
    freq.put("Люд", 21);
    freq.put("зам", 126);
    freq.put("зан", 103);
    freq.put("зао", 7);
    freq.put("зап", 134);
    freq.put("заи", 15);
    freq.put("зай", 47);
    freq.put("зак", 151);
    freq.put("зал", 143);
    freq.put("зад", 114);
    freq.put("зае", 36);
    freq.put("заз", 7);
    freq.put("заб", 87);
    freq.put("зав", 178);
    freq.put("заг", 59);
    freq.put("Люб", 44);
    freq.put(" ж ", 27);
    freq.put("бь", 24);
    freq.put("кну", 17);
    freq.put("кни", 101);
    freq.put("кно", 43);
    freq.put("Пав", 8);
    freq.put("кна", 8);
    freq.put("кне", 12);
    freq.put("ат ", 115);
    freq.put("ция", 255);
    freq.put("зая", 32);
    freq.put("заш", 16);
    freq.put("защ", 26);
    freq.put("зах", 54);
    freq.put("зац", 45);
    freq.put("зач", 33);
    freq.put("зар", 81);
    freq.put("зас", 54);
    freq.put("зат", 115);
    freq.put("цит", 9);
    freq.put("кци", 204);
    freq.put("гл ", 12);
    freq.put("ЕЙ ", 11);
    freq.put("Гул", 8);
    freq.put("яй ", 9);
    freq.put("экз", 59);
    freq.put("эко", 25);
    freq.put("экр", 11);
    freq.put("экс", 41);
    freq.put("цо ", 14);
    freq.put("б ", 195);
    freq.put("оче", 406);
    freq.put("оча", 23);
    freq.put("ифт", 8);
    freq.put("очн", 191);
    freq.put("очи", 108);
    freq.put("очк", 151);
    freq.put("Кос", 13);
    freq.put("Кор", 28);
    freq.put("Коф", 7);
    freq.put(" Ба", 102);
    freq.put("дп", 50);
    freq.put("дм", 36);
    freq.put("Джо", 16);
    freq.put("дк", 284);
    freq.put(" Бе", 109);
    freq.put("ди", 1864);
    freq.put("АМ ", 17);
    freq.put(" Би", 36);
    freq.put("дз", 28);
    freq.put("дд", 66);
    freq.put(" Бл", 61);
    freq.put("дв", 207);
    freq.put("дг", 13);
    freq.put(" Бо", 117);
    freq.put("дб", 22);
    freq.put("ипе", 57);
    freq.put("ипа", 33);
    freq.put("ипо", 34);
    freq.put("ипп", 9);
    freq.put("ипл", 21);
    freq.put("ипи", 16);
    freq.put("ипт", 13);
    freq.put("ипы", 15);
    freq.put("дё", 25);
    freq.put(" Бр", 37);
    freq.put("дя", 132);
    freq.put("дь", 316);
    freq.put(" Бу", 45);
    freq.put("дъ", 15);
    freq.put("ды", 433);
    freq.put("дш", 24);
    freq.put("дц", 51);
    freq.put("дч", 15);
    freq.put(" Бы", 28);
    freq.put("дт", 38);
    freq.put("ду", 867);
    freq.put("др", 579);
    freq.put("дс", 202);
    freq.put("Ког", 53);
    freq.put("Код", 9);
    freq.put("Кол", 22);
    freq.put("Кон", 39);
    freq.put("Ком", 36);
    freq.put("очт", 52);
    freq.put("очу", 146);
    freq.put("очь", 58);
    freq.put("ифи", 24);
    freq.put("кту", 16);
    freq.put("ктр", 69);
    freq.put("ктя", 14);
    freq.put("кты", 20);
    freq.put("дл", 890);
    freq.put("ох ", 20);
    freq.put(" ру", 248);
    freq.put(" рт", 8);
    freq.put("урк", 13);
    freq.put("лже", 34);
    freq.put("урм", 18);
    freq.put("урн", 46);
    freq.put("лжа", 19);
    freq.put(" рф", 7);
    freq.put("иб ", 9);
    freq.put("лжн", 62);
    freq.put(" ря", 36);
    freq.put("уре", 41);
    freq.put("лжи", 10);
    freq.put("яца", 9);
    freq.put("пб ", 8);
    freq.put(" ра", 1065);
    freq.put(" рж", 14);
    freq.put(" ре", 496);
    freq.put("урс", 59);
    freq.put("урт", 19);
    freq.put(" ри", 49);
    freq.put(" ро", 292);
    freq.put("иц ", 16);
    freq.put("кте", 200);
    freq.put("дж", 94);
    freq.put("кта", 52);
    freq.put("кто", 262);
    freq.put("кти", 102);
    freq.put("сше", 10);
    freq.put("ига", 112);
    freq.put(" Ел", 8);
    freq.put(" Ед", 12);
    freq.put("игл", 24);
    freq.put("иги", 43);
    freq.put("иго", 27);
    freq.put(" Еб", 9);
    freq.put(" Ев", 37);
    freq.put(" Ег", 12);
    freq.put("ба ", 72);
    freq.put("ри ", 278);
    freq.put("игу", 31);
    freq.put("игр", 292);
    freq.put(" Ещ", 15);
    freq.put("у ", 3241);
    freq.put(" Ес", 87);
    freq.put("був", 7);
    freq.put("буе", 11);
    freq.put("буд", 434);
    freq.put("бул", 11);
    freq.put("бук", 26);
    freq.put("буй", 28);
    freq.put("бум", 8);
    freq.put("хло", 8);
    freq.put("да", 2324);
    freq.put("хле", 11);
    freq.put("рку", 28);
    freq.put("ьша", 15);
    freq.put("рко", 68);
    freq.put("рки", 38);
    freq.put("ьшо", 28);
    freq.put("рке", 41);
    freq.put("рка", 45);
    freq.put("чо ", 16);
    freq.put("бут", 9);
    freq.put("бус", 28);
    freq.put("бур", 85);
    freq.put("буч", 13);
    freq.put("бух", 14);
    freq.put("пли", 18);
    freq.put("буш", 15);
    freq.put("бую", 7);
    freq.put("чис", 49);
    freq.put("чит", 440);
    freq.put("чищ", 7);
    freq.put("есь", 111);
    freq.put("еся", 76);
    freq.put("есс", 97);
    freq.put("есу", 15);
    freq.put("ест", 808);
    freq.put("Щ", 13);
    freq.put("вь ", 76);
    freq.put("ма ", 434);
    freq.put("Пят", 9);
    freq.put("ыш ", 7);
    freq.put("аци", 334);
    freq.put("еси", 30);
    freq.put("есл", 153);
    freq.put("еск", 300);
    freq.put("есн", 148);
    freq.put("есм", 18);
    freq.put("есп", 242);
    freq.put("есо", 30);
    freq.put("еса", 50);
    freq.put("есе", 104);
    freq.put("чие", 12);
    freq.put("чив", 40);
    freq.put("чим", 10);
    freq.put("чин", 152);
    freq.put("чий", 11);
    freq.put("чик", 77);
    freq.put("чил", 104);
    freq.put("вд", 80);
    freq.put("ве", 2509);
    freq.put("вз", 159);
    freq.put("ва", 3125);
    freq.put("вв", 20);
    freq.put("вг", 30);
    freq.put("вм", 68);
    freq.put("вн", 495);
    freq.put("во", 2790);
    freq.put("вп", 54);
    freq.put("ви", 1761);
    freq.put("вк", 298);
    freq.put("вл", 425);
    freq.put("вё", 10);
    freq.put("Кро", 9);
    freq.put("АС ", 14);
    freq.put("вх", 17);
    freq.put("вц", 17);
    freq.put("вч", 48);
    freq.put("вр", 357);
    freq.put("вс", 1116);
    freq.put("вт", 331);
    freq.put("ву", 335);
    freq.put("вь", 135);
    freq.put("вя", 94);
    freq.put("вш", 84);
    freq.put("вщ", 10);
    freq.put("вы", 1230);
    freq.put("е ", 10105);
    freq.put("Евг", 8);
    freq.put("вче", 36);
    freq.put("ое ", 674);
    freq.put("ови", 234);
    freq.put("Евр", 28);
    freq.put("ш ", 67);
    freq.put(" и ", 1733);
    freq.put("аш ", 36);
    freq.put("вве", 12);
    freq.put("ью ", 193);
    freq.put("аф ", 10);
    freq.put("утв", 8);
    freq.put("жае", 46);
    freq.put("жав", 9);
    freq.put("жан", 20);
    freq.put("уте", 33);
    freq.put("жай", 149);
    freq.put("жал", 107);
    freq.put("утк", 169);
    freq.put("фле", 11);
    freq.put("фла", 8);
    freq.put("фло", 8);
    freq.put("ути", 70);
    freq.put("шня", 16);
    freq.put("мья", 7);
    freq.put("шны", 24);
    freq.put("цы ", 75);
    freq.put("уто", 70);
    freq.put("нд ", 25);
    freq.put(" кн", 87);
    freq.put(" ко", 1341);
    freq.put(" ки", 166);
    freq.put(" кл", 237);
    freq.put(" ке", 45);
    freq.put("утн", 10);
    freq.put(" ка", 1209);
    freq.put(" кг", 17);
    freq.put(" кв", 94);
    freq.put(" кс", 25);
    freq.put(" кр", 731);
    freq.put(" ку", 250);
    freq.put(" кт", 135);
    freq.put("шно", 45);
    freq.put("шни", 62);
    freq.put("шне", 22);
    freq.put("мье", 23);
    freq.put("лин", 186);
    freq.put("ял ", 34);
    freq.put("лио", 29);
    freq.put("зм ", 25);
    freq.put("жас", 25);
    freq.put("жар", 37);
    freq.put("жат", 55);
    freq.put("жаю", 42);
    freq.put("жащ", 9);
    freq.put("лив", 335);
    freq.put("охо", 175);
    freq.put("ицы", 34);
    freq.put("охн", 23);
    freq.put("охл", 10);
    freq.put("охи", 31);
    freq.put("ицу", 51);
    freq.put("оха", 12);
    freq.put("ицц", 8);
    freq.put("Даж", 13);
    freq.put("Дав", 19);
    freq.put(" т", 4172);
    freq.put(" Гл", 42);
    freq.put(" Ги", 17);
    freq.put(" с", 7919);
    freq.put(" Го", 109);
    freq.put(" ч", 1915);
    freq.put(" ф", 771);
    freq.put(" х", 1026);
    freq.put(" ы", 9);
    freq.put(" Га", 39);
    freq.put(" щ", 38);
    freq.put(" ю", 85);
    freq.put(" я", 1210);
    freq.put(" Гд", 27);
    freq.put(" Ге", 52);
    freq.put("иби", 21);
    freq.put("ибк", 18);
    freq.put(" ё", 8);
    freq.put("ибо", 147);
    freq.put("иба", 13);
    freq.put("ибе", 21);
    freq.put(" Т", 864);
    freq.put(" У", 641);
    freq.put(" Р", 581);
    freq.put(" С", 1429);
    freq.put(" Ц", 54);
    freq.put(" Ч", 308);
    freq.put(" Ф", 232);
    freq.put(" Х", 268);
    freq.put(" Ш", 131);
    freq.put("ибу", 45);
    freq.put(" Ю", 59);
    freq.put(" Я", 571);
    freq.put(" Э", 244);
    freq.put(" в", 7319);
    freq.put(" г", 2007);
    freq.put(" а", 1464);
    freq.put(" б", 2991);
    freq.put(" ж", 898);
    freq.put(" з", 2788);
    freq.put(" д", 4149);
    freq.put(" е", 1189);
    freq.put(" к", 4597);
    freq.put(" Гу", 29);
    freq.put(" Гр", 60);
    freq.put(" яс", 8);
    freq.put(" о", 3966);
    freq.put(" п", 8387);
    freq.put(" м", 3988);
    freq.put(" н", 6673);
    freq.put("кт ", 109);
    freq.put(" В", 1324);
    freq.put(" Г", 451);
    freq.put(" А", 723);
    freq.put(" Б", 654);
    freq.put(" Ж", 153);
    freq.put(" З", 426);
    freq.put(" Д", 746);
    freq.put(" Е", 269);
    freq.put(" К", 1545);
    freq.put("ица", 105);
    freq.put(" И", 550);
    freq.put(" Й", 26);
    freq.put("ице", 104);
    freq.put("оху", 163);
    freq.put("охр", 35);
    freq.put(" Н", 1037);
    freq.put("хне", 10);
    freq.put("баш", 16);
    freq.put("риш", 68);
    freq.put("рия", 151);
    freq.put("бая", 7);
    freq.put("бат", 36);
    freq.put("рит", 223);
    freq.put("бар", 39);
    freq.put("бас", 22);
    freq.put("рич", 107);
    freq.put("риц", 20);
    freq.put("рих", 49);
    freq.put("риф", 13);
    freq.put("иг ", 18);
    freq.put("бак", 34);
    freq.put("рик", 338);
    freq.put("рий", 49);
    freq.put("бай", 12);
    freq.put("рип", 30);
    freq.put("рио", 30);
    freq.put("бам", 13);
    freq.put("бан", 162);
    freq.put("бав", 67);
    freq.put("рив", 128);
    freq.put("риб", 34);
    freq.put("баб", 29);
    freq.put("риз", 81);
    freq.put("риж", 9);
    freq.put("рие", 59);
    freq.put("бае", 14);
    freq.put("лиш", 61);
    freq.put(" тв", 196);
    freq.put("рст", 47);
    freq.put("бу ", 36);
    freq.put("сыр", 10);
    freq.put("рк ", 29);
    freq.put("ТИ ", 7);
    freq.put("ЫЕ ", 7);
    freq.put("сыл", 24);
    freq.put("чам", 7);
    freq.put("еуд", 14);
    freq.put("сып", 30);
    freq.put("сын", 13);
    freq.put("сыг", 7);
    freq.put("сыв", 13);
    freq.put("уты", 20);
    freq.put("чон", 10);
    freq.put("юня", 24);
    freq.put(" П", 1393);
    freq.put("ман", 174);
    freq.put("мам", 58);
    freq.put("мал", 227);
    freq.put("мак", 40);
    freq.put("май", 146);
    freq.put("маи", 7);
    freq.put("вье", 23);
    freq.put("мае", 42);
    freq.put("маг", 59);
    freq.put("мая", 95);
    freq.put("маю", 94);
    freq.put("вья", 7);
    freq.put("вью", 17);
    freq.put("маш", 78);
    freq.put("мац", 31);
    freq.put("мах", 14);
    freq.put("нём", 7);
    freq.put("мас", 65);
    freq.put("мар", 111);
    freq.put("Кам", 10);
    freq.put("чи ", 121);
    freq.put("ес ", 55);
    freq.put("её", 32);
    freq.put("хро", 11);
    freq.put("ея", 74);
    freq.put("ею", 70);
    freq.put("ещ", 362);
    freq.put("еш", 582);
    freq.put("хри", 12);
    freq.put("ех", 281);
    freq.put("еф", 143);
    freq.put("Еди", 7);
    freq.put("ец", 303);
    freq.put("ес", 2269);
    freq.put("ер", 3811);
    freq.put("еу", 33);
    freq.put("ет", 3779);
    freq.put("в ", 4116);
    freq.put("м", 14607);
    freq.put("чте", 13);
    freq.put("ен", 4927);
    freq.put("ем", 1831);
    freq.put("еп", 472);
    freq.put("ео", 305);
    freq.put("ей", 1106);
    freq.put("еи", 41);
    freq.put("ел", 3025);
    freq.put("ек", 1003);
    freq.put("ее", 469);
    freq.put("ед", 1673);
    freq.put("ез", 823);
    freq.put("еж", 274);
    freq.put("еб", 841);
    freq.put("еа", 109);
    freq.put("ег", 1061);
    freq.put("ев", 950);
    freq.put("шё", 16);
    freq.put("шь", 427);
    freq.put("шт", 63);
    freq.put("шу", 104);
    freq.put("шр", 11);
    freq.put("Жен", 22);
    freq.put("Жел", 10);
    freq.put("вдр", 10);
    freq.put("оех", 15);
    freq.put("оет", 8);
    freq.put("иед", 9);
    freq.put("ОТ ", 16);
    freq.put("оем", 42);
    freq.put("оен", 70);
    freq.put("оек", 32);
    freq.put("вда", 40);
    freq.put("ИЯ ", 7);
    freq.put("оей", 59);
    freq.put("оез", 41);
    freq.put("оед", 25);
    freq.put("вдо", 12);
    freq.put("оев", 14);
    freq.put("оег", 41);
    freq.put("оеб", 7);
    freq.put("шк", 415);
    freq.put("шл", 242);
    freq.put("ши", 639);
    freq.put("шо", 190);
    freq.put("шп", 18);
    freq.put("шм", 13);
    freq.put("шн", 187);
    freq.put("шв", 14);
    freq.put("спы", 12);
    freq.put("ша", 350);
    freq.put("ше", 1027);
    freq.put("алу", 44);
    freq.put("В", 1326);
    freq.put("пью", 35);
    freq.put("пья", 17);
    freq.put("шлы", 13);
    freq.put("шлю", 43);
    freq.put(" ил", 131);
    freq.put(" ик", 18);
    freq.put(" ип", 19);
    freq.put("лиг", 27);
    freq.put(" ин", 433);
    freq.put(" им", 108);
    freq.put(" иг", 272);
    freq.put(" иб", 22);
    freq.put("афф", 7);
    freq.put(" из", 593);
    freq.put("афт", 136);
    freq.put("ьют", 36);
    freq.put("афо", 18);
    freq.put(" ищ", 12);
    freq.put("уем", 16);
    freq.put(" ию", 29);
    freq.put("ьти", 22);
    freq.put("афи", 62);
    freq.put(" ит", 23);
    freq.put("афе", 7);
    freq.put(" ир", 14);
    freq.put(" их", 78);
    freq.put("афа", 10);
    freq.put("шли", 44);
    freq.put("жчи", 52);
    freq.put("шла", 81);
    freq.put("шле", 9);
    freq.put("оте", 198);
    freq.put("бах", 8);
    freq.put("ура", 88);
    freq.put("ялс", 8);
    freq.put("змы", 8);
    freq.put("лиж", 14);
    freq.put("гно", 21);
    freq.put("жа ", 49);
    freq.put("гни", 17);
    freq.put("гне", 10);
    freq.put("гна", 18);
    freq.put("рши", 39);
    freq.put("рша", 12);
    freq.put(" к ", 239);
    freq.put("рше", 31);
    freq.put("нди", 55);
    freq.put("ндо", 40);
    freq.put("БЯ ", 9);
    freq.put("нда", 73);
    freq.put("ндж", 12);
    freq.put("нде", 40);
    freq.put("нды", 20);
    freq.put("нду", 24);
    freq.put("ндр", 79);
    freq.put("мь ", 14);
    freq.put("ссм", 9);
    freq.put("гня", 7);
    freq.put("гну", 8);
    freq.put("урд", 7);
    freq.put("яла", 48);
    freq.put("змо", 66);
    freq.put("зма", 25);
    freq.put("яли", 24);
    freq.put("сск", 135);
    freq.put("зме", 63);
    freq.put("жжж", 8);
    freq.put("фей", 10);
    freq.put("ющи", 79);
    freq.put("фел", 15);
    freq.put("фен", 10);
    freq.put("юща", 12);
    freq.put("фед", 10);
    freq.put("ЕЕ ", 8);
    freq.put("юще", 32);
    freq.put("Ру", 45);
    freq.put(" ме", 819);
    freq.put(" мд", 7);
    freq.put(" ма", 678);
    freq.put(" мо", 1213);
    freq.put(" мн", 424);
    freq.put(" мм", 12);
    freq.put(" мл", 22);
    freq.put("Ря", 12);
    freq.put(" ми", 306);
    freq.put(" ее", 49);
    freq.put("шпи", 10);
    freq.put("ыра", 26);
    freq.put("Ра", 119);
    freq.put(" му", 231);
    freq.put("ыре", 20);
    freq.put("Ре", 113);
    freq.put(" мя", 35);
    freq.put("Ри", 26);
    freq.put(" ег", 167);
    freq.put("Ро", 172);
    freq.put("ыро", 11);
    freq.put("ОК ", 10);
    freq.put("фер", 51);
    freq.put("фес", 31);
    freq.put("фет", 7);
    freq.put("ор ", 167);
    freq.put("язь", 7);
    freq.put("ут ", 281);
    freq.put("язы", 66);
    freq.put("У ", 174);
    freq.put("рье", 32);
    freq.put("зич", 13);
    freq.put("зир", 20);
    freq.put("зис", 13);
    freq.put("зит", 44);
    freq.put("рьм", 16);
    freq.put("рьк", 18);
    freq.put("наж", 20);
    freq.put("наз", 97);
    freq.put("над", 231);
    freq.put("нае", 92);
    freq.put("нав", 100);
    freq.put("наг", 18);
    freq.put("наб", 28);
    freq.put("нап", 153);
    freq.put("нам", 156);
    freq.put("нан", 71);
    freq.put("нак", 361);
    freq.put("нал", 210);
    freq.put("наи", 15);
    freq.put("най", 50);
    freq.put("ашл", 33);
    freq.put("ашк", 30);
    freq.put("аши", 109);
    freq.put("ашн", 66);
    freq.put("ли ", 1243);
    freq.put("аша", 39);
    freq.put("аше", 101);
    freq.put(" т ", 32);
    freq.put("ашу", 8);
    freq.put("нац", 20);
    freq.put("нач", 204);
    freq.put("нах", 79);
    freq.put("нат", 123);
    freq.put("нау", 34);
    freq.put("нар", 161);
    freq.put("нас", 235);
    freq.put("наю", 103);
    freq.put("ная", 386);
    freq.put("наш", 105);
    freq.put("зид", 28);
    freq.put("зим", 16);
    freq.put("зин", 42);
    freq.put("зии", 13);
    freq.put("зик", 19);
    freq.put("зил", 22);
    freq.put("язи", 13);
    freq.put("яза", 37);
    freq.put("язв", 10);
    freq.put("уфе", 7);
    freq.put("лка", 60);
    freq.put("цу", 89);
    freq.put("цц", 9);
    freq.put("лке", 12);
    freq.put("лки", 92);
    freq.put("цы", 89);
    freq.put("лко", 30);
    freq.put("свя", 38);
    freq.put("кеа", 7);
    freq.put("кее", 7);
    freq.put("кел", 8);
    freq.put("кей", 15);
    freq.put(" фу", 83);
    freq.put("кем", 28);
    freq.put(" фр", 27);
    freq.put("ято", 32);
    freq.put("ятн", 74);
    freq.put("ие ", 1641);
    freq.put("Инт", 40);
    freq.put("яти", 75);
    freq.put("яте", 35);
    freq.put("ята", 26);
    freq.put("ять", 248);
    freq.put("яты", 12);
    freq.put("ятт", 13);
    freq.put("ятс", 37);
    freq.put("кет", 48);
    freq.put(" фо", 262);
    freq.put("кер", 24);
    freq.put(" фл", 24);
    freq.put(" фи", 189);
    freq.put(" фе", 63);
    freq.put(" фа", 102);
    freq.put("ца", 233);
    freq.put("лку", 31);
    freq.put("цв", 38);
    freq.put("це", 604);
    freq.put("ци", 854);
    freq.put("цк", 72);
    freq.put("цо", 57);
    freq.put("Гла", 31);
    freq.put("бс ", 8);
    freq.put(" Йо", 19);
    freq.put("изо", 40);
    freq.put("изм", 84);
    freq.put("изн", 240);
    freq.put("изк", 30);
    freq.put("изл", 8);
    freq.put("аах", 10);
    freq.put("изд", 69);
    freq.put("изе", 8);
    freq.put("изв", 67);
    freq.put("ала", 451);
    freq.put("иза", 78);
    freq.put("изб", 56);
    freq.put("Сев", 10);
    freq.put("щ ", 12);
    freq.put("алк", 64);
    freq.put("ааа", 197);
    freq.put("изы", 22);
    freq.put("рм ", 31);
    freq.put("аак", 9);
    freq.put("изу", 10);
    freq.put("зро", 24);
    freq.put("зри", 13);
    freq.put("Суд", 13);
    freq.put("зре", 238);
    freq.put("дя ", 30);
    freq.put("Суп", 8);
    freq.put("рощ", 31);
    freq.put("рош", 322);
    freq.put("роя", 22);
    freq.put("рою", 10);
    freq.put("рос", 729);
    freq.put("рор", 20);
    freq.put("рот", 161);
    freq.put("рох", 30);
    freq.put("роф", 54);
    freq.put("роч", 78);
    freq.put("роц", 43);
    freq.put("рой", 160);
    freq.put("рои", 143);
    freq.put("рол", 100);
    freq.put("рок", 148);
    freq.put("рон", 112);
    freq.put("ф", 1798);
    freq.put("роп", 118);
    freq.put("ся ", 1198);
    freq.put("роб", 141);
    freq.put("рог", 241);
    freq.put("ров", 837);
    freq.put("рое", 145);
    freq.put("род", 553);
    freq.put("роз", 79);
    freq.put("рож", 226);
    freq.put("шил", 42);
    freq.put("Сур", 7);
    freq.put("зры", 11);
    freq.put("фы ", 10);
    freq.put("Д ", 45);
    freq.put("мм ", 18);
    freq.put("К", 1553);
    freq.put("мон", 219);
    freq.put("мом", 74);
    freq.put("моо", 7);
    freq.put("мой", 191);
    freq.put("мои", 53);
    freq.put("мол", 127);
    freq.put("мок", 14);
    freq.put("мое", 101);
    freq.put("мод", 57);
    freq.put("моз", 38);
    freq.put("мож", 479);
    freq.put("моб", 55);
    freq.put("Фу", 34);
    freq.put("Фр", 28);
    freq.put("мов", 53);
    freq.put(" Са", 148);
    freq.put(" Сб", 14);
    freq.put(" Св", 32);
    freq.put(" Сд", 11);
    freq.put(" Се", 143);
    freq.put("Рим", 7);
    freq.put(" Си", 61);
    freq.put(" Ск", 143);
    freq.put(" Сл", 43);
    freq.put(" См", 49);
    freq.put(" Сн", 14);
    freq.put(" Со", 123);
    freq.put(" Сп", 95);
    freq.put(" Ср", 32);
    freq.put(" Ст", 123);
    freq.put(" Су", 35);
    freq.put(" Сч", 9);
    freq.put("Бар", 16);
    freq.put(" Сы", 12);
    freq.put("моё", 11);
    freq.put("Фо", 50);
    freq.put("моя", 47);
    freq.put("мою", 14);
    freq.put("мощ", 118);
    freq.put("мош", 8);
    freq.put("Фи", 53);
    freq.put("моч", 15);
    freq.put("Фе", 15);
    freq.put("АХ ", 14);
    freq.put("мор", 84);
    freq.put("Фа", 16);
    freq.put("мот", 298);
    freq.put("шив", 29);
    freq.put("мё", 7);
    freq.put("эн", 55);
    freq.put("шик", 13);
    freq.put("ший", 68);
    freq.put("уй ", 83);
    freq.put("шин", 73);
    freq.put("шим", 35);
    freq.put("У", 642);
    freq.put("ва ", 525);
    freq.put("яеш", 9);
    freq.put("фе ", 18);
    freq.put("яет", 81);
    freq.put("зот", 8);
    freq.put("зор", 36);
    freq.put("зош", 10);
    freq.put("а ", 9535);
    freq.put("аца", 10);
    freq.put("ьше", 279);
    freq.put(" м ", 27);
    freq.put("нве", 10);
    freq.put("нва", 36);
    freq.put("ьши", 25);
    freq.put("р", 24849);
    freq.put("Р ", 49);
    freq.put("зов", 134);
    freq.put("зоб", 30);
    freq.put("зол", 143);
    freq.put("зой", 26);
    freq.put("зоп", 13);
    freq.put("зом", 24);
    freq.put("зон", 67);
    freq.put("яем", 14);
    freq.put("кры", 154);
    freq.put("кря", 14);
    freq.put("рь ", 309);
    freq.put("кру", 172);
    freq.put("Ул", 19);
    freq.put("Ук", 44);
    freq.put("ута", 51);
    freq.put("утб", 98);
    freq.put("Уп", 14);
    freq.put("Ун", 8);
    freq.put("Ум", 7);
    freq.put("Уг", 10);
    freq.put("Ув", 100);
    freq.put("Уб", 11);
    freq.put("Уз", 7);
    freq.put("Уж", 19);
    freq.put("Уд", 22);
    freq.put("лии", 39);
    freq.put("лий", 36);
    freq.put("лик", 101);
    freq.put("лил", 49);
    freq.put("лим", 39);
    freq.put(" тр", 306);
    freq.put(" ту", 226);
    freq.put("лип", 41);
    freq.put("лиа", 15);
    freq.put("либ", 27);
    freq.put(" тя", 23);
    freq.put(" тю", 23);
    freq.put("лид", 35);
    freq.put("лие", 12);
    freq.put(" ты", 383);
    freq.put("лиз", 79);
    freq.put("на ", 2238);
    freq.put("кза", 63);
    freq.put("ярн", 20);
    freq.put("яро", 7);
    freq.put("ярк", 8);
    freq.put("ярс", 28);
    freq.put(" те", 811);
    freq.put("лищ", 13);
    freq.put(" та", 863);
    freq.put("лию", 9);
    freq.put("лия", 29);
    freq.put("лир", 17);
    freq.put("лис", 164);
    freq.put("лит", 173);
    freq.put(" то", 1217);
    freq.put("лиф", 17);
    freq.put(" ти", 64);
    freq.put("лиц", 157);
    freq.put("лич", 417);
    freq.put("утр", 120);
    freq.put("утс", 37);
    freq.put("Ут", 7);
    freq.put("Ус", 22);
    freq.put("Ур", 156);
    freq.put("Уч", 19);
    freq.put("уть", 107);
    freq.put("Уф", 8);
    freq.put("кри", 65);
    freq.put("зи ", 23);
    freq.put("кро", 123);
    freq.put("кра", 427);
    freq.put("кре", 373);
    freq.put("лк ", 12);
    freq.put(" Зд", 7);
    freq.put(" Зе", 18);
    freq.put(" Зв", 11);
    freq.put(" За", 210);
    freq.put("Ж", 154);
    freq.put(" Зо", 15);
    freq.put(" Зн", 75);
    freq.put(" Зи", 10);
    freq.put("Кис", 11);
    freq.put("Кир", 16);
    freq.put("Кит", 14);
    freq.put("иев", 44);
    freq.put("ием", 93);
    freq.put("иен", 12);
    freq.put("ией", 30);
    freq.put("ят ", 201);
    freq.put("ке ", 304);
    freq.put("шит", 61);
    freq.put("гос", 67);
    freq.put("иех", 14);
    freq.put("Кие", 16);
    freq.put("иес", 10);
    freq.put("иет", 150);
    freq.put("ушл", 8);
    freq.put(" Зу", 7);
    freq.put(" Зр", 11);
    freq.put("ц ", 197);
    freq.put("ъел", 8);
    freq.put("гоз", 7);
    freq.put("🙋?", 12);
    freq.put("год", 380);
    freq.put("бсл", 8);
    freq.put("бск", 8);
    freq.put("щи", 408);
    freq.put("щн", 22);
    freq.put("Ан", 88);
    freq.put("ща", 196);
    freq.put("ще", 716);
    freq.put("аст", 572);
    freq.put("нза", 7);
    freq.put("рму", 12);
    freq.put("рмс", 7);
    freq.put("рмя", 7);
    freq.put("рмь", 9);
    freq.put("рмы", 10);
    freq.put("из ", 448);
    freq.put("рме", 25);
    freq.put("аа ", 50);
    freq.put("рма", 183);
    freq.put("щё", 50);
    freq.put("рмо", 27);
    freq.put("рмл", 11);
    freq.put("рми", 42);
    freq.put("щь", 116);
    freq.put("щу", 49);
    freq.put("юю ", 13);
    freq.put("нзи", 10);
    freq.put("ётс", 7);
    freq.put("бсу", 24);
    freq.put("бст", 38);
    freq.put("дям", 14);
    freq.put("дян", 12);
    freq.put("чку", 49);
    freq.put("сяч", 24);
    freq.put("сяц", 32);
    freq.put("сят", 38);
    freq.put("щью", 84);
    freq.put("ВЫ ", 12);
    freq.put("ро ", 256);
    freq.put("кка", 9);
    freq.put("сяк", 18);
    freq.put("Ты ", 174);
    freq.put("чко", 32);
    freq.put("дящ", 20);
    freq.put("чки", 83);
    freq.put("дят", 44);
    freq.put("чке", 8);
    freq.put("чка", 82);
    freq.put("юбы", 8);
    freq.put("юбя", 14);
    freq.put("вши", 52);
    freq.put("мми", 11);
    freq.put("ммо", 8);
    freq.put("ммм", 15);
    freq.put("вша", 10);
    freq.put(" си", 274);
    freq.put("ЫЙ ", 22);
    freq.put("вше", 19);
    freq.put("мме", 24);
    freq.put(" хр", 32);
    freq.put("ммы", 22);
    freq.put("мму", 40);
    freq.put("юбв", 13);
    freq.put("юбл", 91);
    freq.put("юби", 135);
    freq.put("юбо", 78);
    freq.put("зе", 322);
    freq.put(" С ", 99);
    freq.put("йзе", 8);
    freq.put("зк", 67);
    freq.put("Дру", 11);
    freq.put("мо ", 66);
    freq.put("Ф ", 32);
    freq.put("юз ", 12);
    freq.put("фо", 511);
    freq.put("Э", 247);
    freq.put("уйн", 15);
    freq.put("вас", 199);
    freq.put("вар", 301);
    freq.put("ват", 419);
    freq.put("вах", 12);
    freq.put("вац", 14);
    freq.put("ваш", 37);
    freq.put("вая", 111);
    freq.put("ваю", 139);
    freq.put("вав", 16);
    freq.put("вае", 166);
    freq.put("вад", 27);
    freq.put("важ", 43);
    freq.put("вай", 77);
    freq.put("вал", 272);
    freq.put("вак", 21);
    freq.put("ван", 553);
    freq.put("вам", 84);
    freq.put("уйт", 15);
    freq.put("уйс", 27);
    freq.put("фа", 161);
    freq.put("ТЬ ", 89);
    freq.put("мма", 42);
    freq.put("Аб", 8);
    freq.put("ьт ", 8);
    freq.put("че", 2232);
    freq.put("Ад", 14);
    freq.put("ча", 1301);
    freq.put("чо", 47);
    freq.put("чн", 555);
    freq.put("чл", 13);
    freq.put("чк", 259);
    freq.put("чи", 1054);
    freq.put("ул ", 36);
    freq.put("чё", 23);
    freq.put("ш", 3816);
    freq.put("чу", 323);
    freq.put("чт", 1011);
    freq.put("чр", 8);
    freq.put("чь", 101);
    freq.put("чш", 166);
    freq.put("шь ", 375);
    freq.put("луд", 11);
    freq.put("луж", 32);
    freq.put("луб", 64);
    freq.put("луа", 9);
    freq.put("луг", 40);
    freq.put("уни", 44);
    freq.put("лун", 8);
    freq.put("лум", 8);
    freq.put("луп", 11);
    freq.put("унд", 17);
    freq.put("луй", 33);
    freq.put("лук", 14);
    freq.put(" А ", 257);
    freq.put(" о ", 244);
    freq.put("вме", 63);
    freq.put("ыт ", 11);
    freq.put("лух", 18);
    freq.put("луч", 293);
    freq.put("уны", 10);
    freq.put("лую", 8);
    freq.put("луш", 60);
    freq.put("кку", 11);
    freq.put("ыба", 25);
    freq.put("жку", 11);
    freq.put("рю ", 48);
    freq.put("ыби", 7);
    freq.put("ыбо", 37);
    freq.put("О", 836);
    freq.put("но ", 1715);
    freq.put("жки", 19);
    freq.put("жко", 11);
    freq.put("жка", 20);
    freq.put("гет", 12);
    freq.put("гес", 9);
    freq.put("гер", 48);
    freq.put("кг ", 14);
    freq.put("яги", 10);
    freq.put("ягк", 26);
    freq.put("яга", 8);
    freq.put("гео", 10);
    freq.put("са ", 164);
    freq.put("гел", 19);
    freq.put("гей", 26);
    freq.put("лоп", 18);
    freq.put("лом", 125);
    freq.put("Хо", 100);
    freq.put("лок", 51);
    freq.put("Хи", 21);
    freq.put("лой", 30);
    freq.put("Хе", 11);
    freq.put("лод", 131);
    freq.put("лое", 16);
    freq.put("лов", 513);
    freq.put("Ха", 40);
    freq.put("лоб", 11);
    freq.put(" шу", 31);
    freq.put(" шт", 39);
    freq.put(" шл", 56);
    freq.put(" шк", 97);
    freq.put(" ши", 29);
    freq.put(" шп", 15);
    freq.put(" шо", 35);
    freq.put(" шв", 10);
    freq.put(" ша", 64);
    freq.put(" ше", 46);
    freq.put("лош", 7);
    freq.put("лощ", 19);
    freq.put("лоч", 30);
    freq.put("лох", 84);
    freq.put("лот", 200);
    freq.put("лоу", 19);
    freq.put("Ху", 12);
    freq.put("лос", 274);
    freq.put(" Не", 229);
    freq.put(" На", 293);
    freq.put(" Но", 167);
    freq.put(" Ни", 68);
    freq.put("хе ", 12);
    freq.put("ик", 1888);
    freq.put("ил", 1773);
    freq.put("ии", 877);
    freq.put("ий", 885);
    freq.put("ио", 301);
    freq.put("ип", 248);
    freq.put("им", 1209);
    freq.put("ин", 2565);
    freq.put("ив", 1141);
    freq.put("иг", 591);
    freq.put("иа", 353);
    freq.put("иб", 328);
    freq.put("иж", 223);
    freq.put("из", 1241);
    freq.put("ид", 878);
    freq.put("ие", 2090);
    freq.put("адя", 7);
    freq.put("адь", 22);
    freq.put("ады", 29);
    freq.put("адц", 12);
    freq.put("аду", 92);
    freq.put("адс", 16);
    freq.put("адр", 48);
    freq.put("Ас", 18);
    freq.put("тфо", 13);
    freq.put("тфи", 14);
    freq.put("адп", 10);
    freq.put("адо", 210);
    freq.put("адн", 33);
    freq.put("адм", 9);
    freq.put("адк", 33);
    freq.put("ади", 110);
    freq.put("адж", 12);
    freq.put("аде", 123);
    freq.put("адв", 9);
    freq.put("ада", 182);
    freq.put("иш", 330);
    freq.put("ищ", 82);
    freq.put("ию", 291);
    freq.put("ия", 1648);
    freq.put("ит", 3376);
    freq.put("иу", 20);
    freq.put("ир", 814);
    freq.put("ис", 1456);
    freq.put("иц", 461);
    freq.put("ич", 981);
    freq.put("иф", 68);
    freq.put("их", 630);
    freq.put(" Ну", 72);
    freq.put(" Нь", 7);
    freq.put("ОЙ ", 33);
    freq.put("С ", 153);
    freq.put("зьм", 18);
    freq.put("быт", 110);
    freq.put("быс", 47);
    freq.put("быч", 32);
    freq.put("Усп", 7);
    freq.put("Сча", 9);
    freq.put("би ", 29);
    freq.put("Вре", 8);
    freq.put("ды ", 304);
    freq.put("ПО ", 11);
    freq.put("был", 268);
    freq.put("зья", 29);
    freq.put("быв", 54);
    freq.put("ми ", 559);
    freq.put(" У ", 101);
    freq.put("бод", 26);
    freq.put("бое", 9);
    freq.put("бож", 36);
    freq.put("е", 41948);
    freq.put("бов", 311);
    freq.put("бог", 30);
    freq.put("бом", 43);
    freq.put("бон", 10);
    freq.put("бои", 15);
    freq.put("бой", 66);
    freq.put("бок", 25);
    freq.put("бол", 531);
    freq.put("боч", 34);
    freq.put("бор", 167);
    freq.put("бос", 19);
    freq.put("бот", 189);
    freq.put("бою", 12);
    freq.put("боя", 12);
    freq.put("дхо", 12);
    freq.put("ъя", 44);
    freq.put("уле", 14);
    freq.put("ула", 51);
    freq.put("воё", 12);
    freq.put("уло", 14);
    freq.put("ули", 102);
    freq.put("улк", 9);
    freq.put("Ит", 19);
    freq.put("воя", 18);
    freq.put("вою", 47);
    freq.put("ч ", 124);
    freq.put("вот", 154);
    freq.put("вос", 180);
    freq.put("вор", 247);
    freq.put("воч", 74);
    freq.put("вол", 155);
    freq.put("вок", 56);
    freq.put("вой", 199);
    freq.put("вои", 219);
    freq.put("воп", 54);
    freq.put("воо", 88);
    freq.put("вон", 91);
    freq.put("вом", 66);
    freq.put("вог", 69);
    freq.put("вов", 70);
    freq.put("воб", 24);
    freq.put("воз", 174);
    freq.put("вож", 19);
    freq.put("вое", 173);
    freq.put("вод", 215);
    freq.put("лст", 15);
    freq.put("улс", 18);
    freq.put("улу", 20);
    freq.put("уль", 135);
    freq.put("уля", 69);
    freq.put("лся", 169);
    freq.put("улы", 42);
    freq.put("ъе", 58);
    freq.put("жду", 68);
    freq.put("жды", 54);
    freq.put("ждь", 18);
    freq.put(" ой", 9);
    freq.put("ыты", 22);
    freq.put(" ол", 14);
    freq.put(" ок", 119);
    freq.put(" он", 511);
    freq.put(" ом", 21);
    freq.put(" оп", 230);
    freq.put(" оо", 16);
    freq.put(" об", 577);
    freq.put(" ог", 51);
    freq.put(" ов", 12);
    freq.put(" од", 406);
    freq.put(" оз", 18);
    freq.put(" ож", 22);
    freq.put("лу ", 51);
    freq.put("ун ", 11);
    freq.put(" ощ", 8);
    freq.put(" ош", 21);
    freq.put("ыти", 43);
    freq.put("ыто", 18);
    freq.put(" ос", 268);
    freq.put(" ор", 87);
    freq.put("ыта", 54);
    freq.put(" от", 1022);
    freq.put(" ох", 55);
    freq.put(" оф", 53);
    freq.put(" оч", 165);
    freq.put(" оц", 18);
    freq.put("жда", 89);
    freq.put("жде", 120);
    freq.put("жди", 11);
    freq.put("шьс", 48);
    freq.put("ждо", 30);
    freq.put("рюк", 7);
    freq.put("ябр", 26);
    freq.put("зку", 9);
    freq.put("ной", 445);
    freq.put("нок", 250);
    freq.put("нол", 24);
    freq.put("ном", 268);
    freq.put("нон", 13);
    freq.put("ноо", 10);
    freq.put("ноп", 15);
    freq.put("ноб", 12);
    freq.put("нов", 613);
    freq.put("ног", 518);
    freq.put("нод", 37);
    freq.put("ное", 325);
    freq.put("нож", 17);
    freq.put("ноз", 21);
    freq.put("шту", 8);
    freq.put("Кр", 136);
    freq.put("нош", 30);
    freq.put("фа ", 23);
    freq.put("ноя", 34);
    freq.put("нор", 106);
    freq.put("нос", 336);
    freq.put("нот", 24);
    freq.put("ноу", 19);
    freq.put("ноч", 115);
    freq.put("зко", 16);
    freq.put("рюш", 7);
    freq.put("зки", 30);
    freq.put("ихи", 20);
    freq.put("ябл", 11);
    freq.put("зка", 10);
    freq.put("яби", 14);
    freq.put("КБ ", 9);
    freq.put("лма", 13);
    freq.put("сат", 63);
    freq.put("сар", 31);
    freq.put("сас", 7);
    freq.put("сах", 50);
    freq.put("б", 8953);
    freq.put(" ца", 13);
    freq.put(" цв", 33);
    freq.put(" це", 171);
    freq.put(" ци", 18);
    freq.put("сал", 92);
    freq.put("сай", 83);
    freq.put("сам", 267);
    freq.put("ге ", 44);
    freq.put("сав", 7);
    freq.put("саж", 33);
    freq.put("сад", 28);
    freq.put("ОМ ", 15);
    freq.put(" Ла", 53);
    freq.put(" Ле", 119);
    freq.put(" Ли", 57);
    freq.put(" Ло", 39);
    freq.put("Х ", 35);
    freq.put("ло ", 395);
    freq.put("авс", 21);
    freq.put("авр", 17);
    freq.put("аву", 11);
    freq.put("авт", 226);
    freq.put("авя", 23);
    freq.put("авш", 39);
    freq.put("авы", 26);
    freq.put("тцо", 8);
    freq.put("аве", 91);
    freq.put("авд", 53);
    freq.put("ава", 179);
    freq.put("авн", 164);
    freq.put("аво", 70);
    freq.put("ави", 398);
    freq.put("авл", 178);
    freq.put("авк", 57);
    freq.put("хож", 56);
    freq.put(" Лу", 58);
    freq.put(" Лю", 70);
    freq.put(" Ль", 8);
    freq.put("и ", 8115);
    freq.put("хем", 84);
    freq.put("Еще", 14);
    freq.put("СЬ ", 19);
    freq.put("ад ", 105);
    freq.put("Оле", 10);
    freq.put("Оли", 11);
    freq.put("хер", 27);
    freq.put("бхо", 20);
    freq.put("дых", 32);
    freq.put("дыш", 7);
    freq.put("Сб", 14);
    freq.put("Са", 149);
    freq.put("Св", 32);
    freq.put("Се", 145);
    freq.put("Сд", 13);
    freq.put("зь ", 11);
    freq.put("Си", 62);
    freq.put("Сл", 48);
    freq.put("Ск", 144);
    freq.put("Сн", 14);
    freq.put("См", 49);
    freq.put("Сп", 95);
    freq.put("Со", 123);
    freq.put("лая", 24);
    freq.put("бив", 35);
    freq.put("биб", 10);
    freq.put("биз", 63);
    freq.put("бид", 16);
    freq.put("бил", 153);
    freq.put("бий", 15);
    freq.put("био", 19);
    freq.put("бим", 59);
    freq.put("бин", 45);
    freq.put("бит", 131);
    freq.put("бир", 70);
    freq.put("бис", 13);
    freq.put("Ой ", 10);
    freq.put("ум", 417);
    freq.put("ИК ", 9);
    freq.put("Ср", 32);
    freq.put("Су", 36);
    freq.put("Ст", 125);
    freq.put("Сч", 10);
    freq.put("Сы", 12);
    freq.put("бы ", 348);
    freq.put("дыв", 17);
    freq.put("дым", 15);
    freq.put("уд", 1413);
    freq.put("дый", 31);
    freq.put("миз", 9);
    freq.put("мид", 8);
    freq.put("мин", 197);
    freq.put("мим", 19);
    freq.put("мил", 109);
    freq.put("мик", 44);
    freq.put("тды", 24);
    freq.put("мии", 20);
    freq.put("бо ", 156);
    freq.put(" Ук", 44);
    freq.put(" Ул", 19);
    freq.put(" Уп", 14);
    freq.put(" Ум", 7);
    freq.put(" Ун", 8);
    freq.put(" Ув", 100);
    freq.put(" Уг", 10);
    freq.put(" Уб", 11);
    freq.put(" Уж", 19);
    freq.put(" Уз", 7);
    freq.put(" Уд", 22);
    freq.put(" Ут", 7);
    freq.put(" Ур", 154);
    freq.put(" Ус", 22);
    freq.put(" Уч", 19);
    freq.put(" Уф", 8);
    freq.put("сё ", 98);
    freq.put("йты", 18);
    freq.put("мич", 18);
    freq.put("мит", 72);
    freq.put("мис", 20);
    freq.put("мир", 139);
    freq.put("мия", 12);
    freq.put("миш", 7);
    freq.put("тог", 182);
    freq.put("фут", 67);
    freq.put("Ааа", 8);
    freq.put("Гу", 30);
    freq.put(" же", 400);
    freq.put("Гр", 60);
    freq.put("бма", 9);
    freq.put(" жд", 65);
    freq.put("Гл", 42);
    freq.put("Ги", 17);
    freq.put("Го", 109);
    freq.put("Га", 40);
    freq.put("Ге", 52);
    freq.put("Гд", 27);
    freq.put("фун", 8);
    freq.put("ать", 1761);
    freq.put("дчи", 13);
    freq.put("тв ", 79);
    freq.put("тас", 21);
    freq.put("тар", 138);
    freq.put(" Че", 102);
    freq.put("тах", 33);
    freq.put("Ром", 7);
    freq.put(" Ча", 24);
    freq.put("тац", 48);
    freq.put("Роб", 9);
    freq.put("МИ ", 10);
    freq.put("Род", 9);
    freq.put(" Чи", 23);
    freq.put("таю", 52);
    freq.put("сва", 31);
    freq.put("таб", 35);
    freq.put("таа", 9);
    freq.put("таг", 9);
    freq.put("тав", 172);
    freq.put(" Чт", 80);
    freq.put(" Чу", 16);
    freq.put("таз", 14);
    freq.put("таж", 33);
    freq.put("Рос", 117);
    freq.put("тал", 339);
    freq.put("так", 851);
    freq.put("тан", 356);
    freq.put("там", 194);
    freq.put("тап", 15);
    freq.put("тур", 99);
    freq.put("уп ", 14);
    freq.put("йш", 28);
    freq.put("йс", 295);
    freq.put("йт", 381);
    freq.put("йф", 32);
    freq.put("йч", 90);
    freq.put("йц", 23);
    freq.put("йл", 43);
    freq.put("йк", 87);
    freq.put("йн", 457);
    freq.put("йм", 64);
    freq.put("йп", 25);
    freq.put("йо", 40);
    freq.put("йб", 10);
    freq.put("йг", 7);
    freq.put("йв", 111);
    freq.put("йе", 10);
    freq.put("йд", 119);
    freq.put("йз", 12);
    freq.put("убл", 44);
    freq.put("лча", 8);
    freq.put("дпи", 22);
    freq.put("уби", 69);
    freq.put("дпо", 7);
    freq.put("убо", 246);
    freq.put("убн", 13);
    freq.put("уба", 50);
    freq.put("убе", 44);
    freq.put("вк ", 7);
    freq.put("эту", 23);
    freq.put("й", 6332);
    freq.put("НУ ", 11);
    freq.put("Т ", 124);
    freq.put("это", 589);
    freq.put("эти", 72);
    freq.put("эта", 27);
    freq.put("йс ", 9);
    freq.put("№ ", 8);
    freq.put("убу", 8);
    freq.put("дпр", 17);
    freq.put("убр", 14);
    freq.put("жи ", 58);
    freq.put("юст", 9);
    freq.put("нк ", 66);
    freq.put("ой", 1810);
    freq.put("ыез", 9);
    freq.put("штр", 7);
    freq.put("юсь", 120);
    freq.put("Кри", 10);
    freq.put("жор", 8);
    freq.put("Кра", 44);
    freq.put("Кре", 52);
    freq.put("во ", 337);
    freq.put("ше ", 341);
    freq.put("гр ", 9);
    freq.put("вии", 9);
    freq.put("вил", 237);
    freq.put("вик", 29);
    freq.put("вин", 238);
    freq.put("вим", 9);
    freq.put("ъек", 7);
    freq.put("виа", 28);
    freq.put("виг", 15);
    freq.put("вив", 13);
    freq.put("вие", 26);
    freq.put("вид", 373);
    freq.put("виз", 23);
    freq.put("виж", 68);
    freq.put("ыши", 14);
    freq.put("пре", 408);
    freq.put("ышк", 26);
    freq.put("ышл", 24);
    freq.put("пра", 303);
    freq.put("вия", 51);
    freq.put("вис", 73);
    freq.put("вир", 25);
    freq.put("про", 1659);
    freq.put("вит", 398);
    freq.put("при", 834);
    freq.put("ыше", 37);
    freq.put("вич", 50);
    freq.put("виц", 10);
    freq.put("бс", 92);
    freq.put("жоп", 21);
    freq.put("жон", 12);
    freq.put("што", 13);
    freq.put("Улу", 7);
    freq.put("ОВ ", 14);
    freq.put("шта", 30);
    freq.put("гла", 173);
    freq.put("ним", 212);
    freq.put("нин", 70);
    freq.put("ник", 749);
    freq.put("нил", 74);
    freq.put("нии", 181);
    freq.put("ний", 168);
    freq.put("ниж", 50);
    freq.put("низ", 53);
    freq.put("ние", 1276);
    freq.put("нив", 33);
    freq.put("ниг", 95);
    freq.put("ниа", 7);
    freq.put("ниб", 44);
    freq.put("Вол", 26);
    freq.put("гло", 22);
    freq.put("Воз", 17);
    freq.put("Вод", 9);
    freq.put("йча", 81);
    freq.put("тче", 20);
    freq.put("Вот", 52);
    freq.put("Вос", 22);
    freq.put("нию", 95);
    freq.put("ния", 894);
    freq.put("ниш", 17);
    freq.put("нищ", 10);
    freq.put("ниц", 152);
    freq.put("нич", 141);
    freq.put("ниф", 7);
    freq.put("них", 87);
    freq.put("нит", 179);
    freq.put("нир", 39);
    freq.put("нис", 60);
    freq.put("хно", 28);
    freq.put("пры", 143);
    freq.put("еп ", 10);
    freq.put("скр", 74);
    freq.put("ску", 105);
    freq.put("ски", 642);
    freq.put("аж ", 48);
    freq.put("скл", 21);
    freq.put("скн", 23);
    freq.put("ско", 649);
    freq.put("ска", 831);
    freq.put("скв", 167);
    freq.put("ске", 86);
    freq.put("щу ", 20);
    freq.put("ене", 115);
    freq.put("енд", 55);
    freq.put("енз", 18);
    freq.put("ена", 185);
    freq.put("енг", 9);
    freq.put("енн", 513);
    freq.put("ено", 126);
    freq.put("ени", 1807);
    freq.put("енк", 111);
    freq.put("тра", 595);
    freq.put("тре", 460);
    freq.put("три", 224);
    freq.put("тро", 458);
    freq.put("Саш", 12);
    freq.put("Сар", 8);
    freq.put("Сах", 8);
    freq.put("аил", 20);
    freq.put("увс", 51);
    freq.put("Сай", 21);
    freq.put("аин", 75);
    freq.put("аим", 11);
    freq.put("аив", 25);
    freq.put("тру", 209);
    freq.put("тры", 20);
    freq.put("тря", 28);
    freq.put("трю", 24);
    freq.put("енц", 24);
    freq.put("енс", 95);
    freq.put("ену", 30);
    freq.put("ент", 380);
    freq.put("ень", 504);
    freq.put("еня", 457);
    freq.put("еню", 13);
    freq.put("енщ", 70);
    freq.put("ены", 109);
    freq.put("уне", 14);
    freq.put("унг", 11);
    freq.put("мки", 17);
    freq.put("твы", 7);
    freq.put("мко", 12);
    freq.put("мка", 8);
    freq.put("уна", 25);
    freq.put("тву", 65);
    freq.put("твр", 9);
    freq.put("Луч", 32);
    freq.put(" Хо", 100);
    freq.put(" Хи", 21);
    freq.put(" Хе", 11);
    freq.put(" Ха", 40);
    freq.put(" Ху", 12);
    freq.put("Г ", 15);
    freq.put("тво", 330);
    freq.put("глу", 22);
    freq.put("тви", 199);
    freq.put("мку", 9);
    freq.put("тва", 248);
    freq.put("бл", 665);
    freq.put("нча", 15);
    freq.put("нче", 19);
    freq.put("нчи", 43);
    freq.put("ёл ", 11);
    freq.put("вян", 8);
    freq.put("та ", 571);
    freq.put("яйс", 11);
    freq.put("вяз", 33);
    freq.put("дна", 77);
    freq.put("упа", 57);
    freq.put("упе", 37);
    freq.put("дне", 103);
    freq.put("дни", 144);
    freq.put("упи", 134);
    freq.put("упл", 26);
    freq.put("упк", 16);
    freq.put("упн", 22);
    freq.put("дно", 429);
    freq.put("упо", 49);
    freq.put("эфф", 17);
    freq.put("унт", 13);
    freq.put("й ", 4249);
    freq.put("эфи", 7);
    freq.put(" ел", 12);
    freq.put("упр", 40);
    freq.put("упу", 10);
    freq.put("дну", 22);
    freq.put("упц", 7);
    freq.put("упы", 9);
    freq.put("дны", 112);
    freq.put("Арм", 7);
    freq.put("днё", 7);
    freq.put("ыга", 8);
    freq.put("жих", 7);
    freq.put("ыго", 8);
    freq.put("жис", 8);
    freq.put("жир", 26);
    freq.put("ыгл", 21);
    freq.put("жит", 109);
    freq.put("Кто", 165);
    freq.put("Тр", 39);
    freq.put("Ту", 42);
    freq.put("Ты", 175);
    freq.put("вке", 17);
    freq.put("вка", 71);
    freq.put("вко", 84);
    freq.put("вкл", 12);
    freq.put("вки", 56);
    freq.put("вку", 48);
    freq.put("йск", 140);
    freq.put("пци", 7);
    freq.put("Те", 118);
    freq.put("Та", 149);
    freq.put("Тв", 30);
    freq.put("То", 101);
    freq.put("Ти", 27);
    freq.put("жин", 26);
    freq.put("жим", 30);
    freq.put("ыгр", 19);
    freq.put("жил", 67);
    freq.put("жик", 34);
    freq.put("жие", 14);
    freq.put("жид", 38);
    freq.put("жиз", 115);
    freq.put("жиг", 14);
    freq.put("жив", 116);
    freq.put("нке", 43);
    freq.put("нка", 99);
    freq.put("нко", 105);
    freq.put("нки", 108);
    freq.put("ые ", 796);
    freq.put("ви ", 51);
    freq.put("Вал", 8);
    freq.put("Ван", 7);
    freq.put(" Аб", 7);
    freq.put("гри", 50);
    freq.put("шее", 39);
    freq.put("шеб", 18);
    freq.put("гро", 81);
    freq.put("ыбк", 12);
    freq.put("гра", 452);
    freq.put("шен", 188);
    freq.put("гре", 59);
    freq.put("шек", 24);
    freq.put("шел", 111);
    freq.put("шех", 9);
    freq.put("гры", 158);
    freq.put("шер", 10);
    freq.put("шес", 22);
    freq.put("шет", 31);
    freq.put("гря", 142);
    freq.put("гру", 452);
    freq.put("шеш", 10);
    freq.put("ь", 9869);
    freq.put("ающ", 84);
    freq.put("Вар", 53);
    freq.put("пр ", 8);
    freq.put("аюс", 44);
    freq.put("Ваш", 9);
    freq.put("ают", 276);
    freq.put("нкц", 14);
    freq.put("нкр", 124);
    freq.put("нкс", 136);
    freq.put("нкт", 45);
    freq.put("нку", 49);
    freq.put("Фед", 7);
    freq.put("ни ", 410);
    freq.put("сде", 110);
    freq.put("сда", 41);
    freq.put("сдо", 11);
    freq.put(" По", 470);
    freq.put(" Пл", 40);
    freq.put(" Пи", 50);
    freq.put(" Пе", 123);
    freq.put(" Па", 64);
    freq.put("епа", 41);
    freq.put("епе", 150);
    freq.put("епл", 53);
    freq.put("епк", 12);
    freq.put("епи", 28);
    freq.put("епо", 47);
    freq.put("Т", 870);
    freq.put("ажу", 30);
    freq.put("тти", 22);
    freq.put("Кар", 32);
    freq.put("тте", 62);
    freq.put("Кат", 10);
    freq.put("ажа", 63);
    freq.put("Кал", 37);
    freq.put("Как", 438);
    freq.put("аже", 169);
    freq.put("ажд", 111);
    freq.put("Кап", 11);
    freq.put("ск ", 135);
    freq.put("ажи", 56);
    freq.put("ажн", 62);
    freq.put("Сво", 8);
    freq.put("Каж", 15);
    freq.put("уар", 7);
    freq.put("епу", 21);
    freq.put("епт", 47);
    freq.put("епр", 44);
    freq.put("уб ", 37);
    freq.put(" Пя", 10);
    freq.put("Это", 82);
    freq.put(" Пу", 52);
    freq.put(" Пр", 404);
    freq.put("ьев", 24);
    freq.put("ен ", 250);
    freq.put("ьез", 15);
    freq.put("ьем", 12);
    freq.put("Что", 80);
    freq.put("тр ", 52);
    freq.put("Опе", 7);
    freq.put("ьер", 29);
    freq.put("оел", 14);
    freq.put("бще", 162);
    freq.put("бща", 20);
    freq.put("хну", 24);
    freq.put("км", 10);
    freq.put("ело", 355);
    freq.put("А ", 517);
    freq.put("ки", 2605);
    freq.put("елк", 36);
    freq.put("кк", 46);
    freq.put("ели", 766);
    freq.put("кд", 16);
    freq.put("ке", 532);
    freq.put("еле", 315);
    freq.put("кз", 74);
    freq.put("елг", 7);
    freq.put("кб", 8);
    freq.put("кв", 296);
    freq.put("ела", 475);
    freq.put("тюн", 7);
    freq.put("Буд", 22);
    freq.put("ож ", 17);
    freq.put(" юм", 11);
    freq.put(" юб", 15);
    freq.put(" юг", 8);
    freq.put("акц", 25);
    freq.put("акс", 33);
    freq.put("акр", 57);
    freq.put("аку", 48);
    freq.put("акт", 370);
    freq.put("акн", 11);
    freq.put("ако", 604);
    freq.put("аки", 240);
    freq.put("акл", 23);
    freq.put("акк", 11);
    freq.put("аке", 32);
    freq.put(" юр", 13);
    freq.put("акж", 8);
    freq.put("ака", 256);
    freq.put("Бур", 7);
    freq.put("Он ", 23);
    freq.put("тюр", 14);
    freq.put("еля", 143);
    freq.put("елю", 28);
    freq.put("ель", 539);
    freq.put("елы", 53);
    freq.put("кц", 208);
    freq.put("елу", 25);
    freq.put("кс", 504);
    freq.put("елс", 9);
    freq.put("ку", 971);
    freq.put("бя ", 240);
    freq.put("Есл", 66);
    freq.put("На ", 81);
    freq.put("ьбе", 8);
    freq.put("ьба", 16);
    freq.put("Г", 454);
    freq.put("пти", 24);
    freq.put("ще ", 342);
    freq.put("ыбр", 19);
    freq.put("Огр", 8);
    freq.put("ГО ", 19);
    freq.put("ьбы", 7);
    freq.put("Ест", 19);
    freq.put("ж ", 159);
    freq.put("дую", 30);
    freq.put("душ", 44);
    freq.put("дущ", 24);
    freq.put("дух", 22);
    freq.put("дут", 70);
    freq.put("дур", 40);
    freq.put("дус", 11);
    freq.put("ок ", 283);
    freq.put("то ", 2510);
    freq.put("дум", 112);
    freq.put("дун", 19);
    freq.put("дук", 29);
    freq.put("дуй", 9);
    freq.put("дуе", 65);
    freq.put("дуг", 7);
    freq.put("дуа", 13);
    freq.put("дуб", 9);
    freq.put("ошо", 103);
    freq.put("Бож", 9);
    freq.put("Бог", 12);
    freq.put("Бол", 53);
    freq.put("оид", 23);
    freq.put("оиз", 33);
    freq.put("оиг", 13);
    freq.put("оин", 13);
    freq.put("оим", 81);
    freq.put("оил", 13);
    freq.put("ну ", 298);
    freq.put("оих", 36);
    freq.put("оис", 48);
    freq.put("оит", 102);
    freq.put("тме", 25);
    freq.put("Бор", 17);
    freq.put("Янд", 7);
    freq.put("уг ", 68);
    freq.put("нса", 15);
    freq.put("Лав", 10);
    freq.put("Лаз", 13);
    freq.put("нси", 34);
    freq.put("нск", 272);
    freq.put("нсп", 20);
    freq.put("нсо", 25);
    freq.put("АЯ ", 20);
    freq.put("Тво", 9);
    freq.put("Тви", 13);
    freq.put("нсу", 12);
    freq.put("нст", 203);
    freq.put("нсы", 19);
    freq.put(" √", 8);
    freq.put("дле", 12);
    freq.put("дла", 17);
    freq.put("дло", 32);
    freq.put("уен", 16);
    freq.put("НЯ ", 29);
    freq.put("дли", 34);
    freq.put("лым", 17);
    freq.put("лый", 46);
    freq.put("лык", 7);
    freq.put("лые", 31);
    freq.put("лыб", 26);
    freq.put("чу ", 178);
    freq.put("Ино", 7);
    freq.put("Инд", 12);
    freq.put("Инв", 7);
    freq.put("Бр", 38);
    freq.put("Бу", 45);
    freq.put("Пет", 26);
    freq.put("Бы", 29);
    freq.put("Пер", 69);
    freq.put("Печ", 9);
    freq.put("Ба", 108);
    freq.put("Бе", 110);
    freq.put("Пен", 7);
    freq.put("Би", 36);
    freq.put("Бл", 61);
    freq.put("Бо", 118);
    freq.put("Инс", 7);
    freq.put("пт ", 11);
    freq.put("юч ", 15);
    freq.put("лыш", 43);
    freq.put("лых", 11);
    freq.put("ует", 125);
    freq.put("для", 792);
    freq.put("уеш", 16);
    freq.put("Упр", 11);
    freq.put("оют", 9);
    freq.put("оюс", 15);
    freq.put("оюз", 20);
    freq.put("Дне", 8);
    freq.put("юхи", 37);
    freq.put("юха", 8);
    freq.put("Вко", 7);
    freq.put("зу", 382);
    freq.put("зс", 13);
    freq.put("зр", 333);
    freq.put("зя", 90);
    freq.put("зь", 62);
    freq.put("зы", 318);
    freq.put("зж", 41);
    freq.put("си ", 48);
    freq.put("зд", 405);
    freq.put("зг", 88);
    freq.put("зв", 350);
    freq.put("зб", 130);
    freq.put("за", 2230);
    freq.put("зо", 515);
    freq.put("зн", 1005);
    freq.put("зм", 194);
    freq.put("зл", 110);
    freq.put("ген", 69);
    freq.put("зи", 303);
    freq.put("ал", 2876);
    freq.put("Ав", 41);
    freq.put("Аг", 8);
    freq.put("Аа", 9);
    freq.put("Ищу", 14);
    freq.put("ьзо", 50);
    freq.put("Аз", 11);
    freq.put("Сын", 7);
    freq.put("Ак", 18);
    freq.put("Ал", 65);
    freq.put("Ай", 12);
    freq.put("к ", 2774);
    freq.put("Ап", 11);
    freq.put("Ам", 17);
    freq.put("ел ", 232);
    freq.put("бят", 37);
    freq.put("вра", 85);
    freq.put(" ю ", 8);
    freq.put("аС", 7);
    freq.put("ева", 150);
    freq.put("Она", 19);
    freq.put("Оно", 7);
    freq.put("Онл", 12);
    freq.put("Они", 13);
    freq.put("Вье", 29);
    freq.put("ак ", 1365);
    freq.put("бяз", 14);
    freq.put("Ау", 7);
    freq.put("Ар", 28);
    freq.put("лон", 58);
    freq.put("ьзя", 24);
    freq.put("Аф", 8);
    freq.put("Ах", 23);
    freq.put("ьзу", 16);
    freq.put("лол", 21);
    freq.put("лож", 106);
    freq.put("дст", 134);
    freq.put("лог", 178);
    freq.put("щей", 71);
    freq.put("щен", 125);
    freq.put("щем", 21);
    freq.put("щег", 25);
    freq.put("щев", 14);
    freq.put("щее", 15);
    freq.put("Авт", 27);
    freq.put("щес", 65);
    freq.put("щет", 8);
    freq.put("Уже", 16);
    freq.put("тей", 99);
    freq.put("дсе", 9);
    freq.put("дск", 48);
    freq.put("жа", 584);
    freq.put("жб", 17);
    freq.put("жг", 7);
    freq.put("жд", 404);
    freq.put("же", 1794);
    freq.put("жж", 18);
    freq.put("жи", 693);
    freq.put("Бил", 8);
    freq.put("жк", 70);
    freq.put("ША ", 29);
    freq.put("жн", 582);
    freq.put("жо", 67);
    freq.put("жп", 15);
    freq.put("тош", 32);
    freq.put("тоя", 92);
    freq.put("Ц", 55);
    freq.put("тот", 98);
    freq.put("тос", 22);
    freq.put("ИА ", 9);
    freq.put("точ", 119);
    freq.put("тоф", 10);
    freq.put("ока", 202);
    freq.put("окз", 7);
    freq.put("оке", 34);
    freq.put("окл", 204);
    freq.put("окк", 17);
    freq.put("оки", 81);
    freq.put("око", 173);
    freq.put("окн", 30);
    freq.put("оку", 75);
    freq.put("окт", 28);
    freq.put("окс", 20);
    freq.put("окр", 70);
    freq.put("тол", 308);
    freq.put("ток", 89);
    freq.put("той", 88);
    freq.put("тои", 107);
    freq.put("топ", 44);
    freq.put("тоо", 13);
    freq.put("тон", 66);
    freq.put("том", 414);
    freq.put("Пус", 12);
    freq.put("тов", 422);
    freq.put("тоб", 164);
    freq.put("Пут", 31);
    freq.put("тож", 243);
    freq.put("тое", 18);
    freq.put("тод", 48);
    freq.put("жр", 20);
    freq.put("жс", 25);
    freq.put("жу", 207);
    freq.put("жч", 52);
    freq.put("жь", 24);
    freq.put("ду ", 335);
    freq.put("ав ", 26);
    freq.put("нул", 99);
    freq.put("ои ", 214);
    freq.put("нуж", 92);
    freq.put("нув", 7);
    freq.put("нуа", 7);
    freq.put("ную", 99);
    freq.put("нуш", 9);
    freq.put("нут", 163);
    freq.put("нус", 31);
    freq.put("нс ", 27);
    freq.put("уго", 64);
    freq.put("уги", 53);
    freq.put("угл", 33);
    freq.put("уга", 77);
    freq.put("Или", 14);
    freq.put("Пла", 25);
    freq.put("эра", 8);
    freq.put("эро", 24);
    freq.put("н", 31028);
    freq.put("угр", 45);
    freq.put("угу", 16);
    freq.put("ошё", 7);
    freq.put("лы ", 96);
    freq.put("лор", 23);
    freq.put("ошу", 20);
    freq.put("ищу", 8);
    freq.put("з ", 1010);
    freq.put("чув", 54);
    freq.put("пты", 32);
    freq.put("ОД ", 8);
    freq.put("пто", 22);
    freq.put("чут", 32);
    freq.put("Уро", 136);
    freq.put("Оче", 22);
    freq.put("Ура", 18);
    freq.put("пте", 13);
    freq.put("ища", 11);
    freq.put("Б ", 32);
    freq.put("ище", 47);
    freq.put("ищн", 9);
    freq.put("оше", 149);
    freq.put("оша", 25);
    freq.put("ько", 326);
    freq.put("оши", 82);
    freq.put("ошл", 76);
    freq.put("ошк", 30);
    freq.put("юче", 24);
    freq.put("юча", 14);
    freq.put("ючи", 27);
    freq.put("ызо", 10);
    freq.put("До", 154);
    freq.put("Дн", 12);
    freq.put("Дл", 20);
    freq.put("Ди", 80);
    freq.put("Дж", 61);
    freq.put("Де", 124);
    freq.put("Дв", 10);
    freq.put("Да", 112);
    freq.put("ый ", 965);
    freq.put("Ду", 24);
    freq.put("Др", 24);
    freq.put("ою ", 69);
    freq.put("ЛЯ ", 9);
    freq.put("Гер", 16);
    freq.put("сит", 104);
    freq.put("сир", 29);
    freq.put("сис", 55);
    freq.put("сиф", 7);
    freq.put("сих", 26);
    freq.put("сиш", 7);
    freq.put("сию", 34);
    freq.put("сия", 67);
    freq.put("сив", 61);
    freq.put("сиг", 13);
    freq.put("сиб", 97);
    freq.put("сиж", 26);
    freq.put("сид", 46);
    freq.put("сие", 10);
    freq.put("сик", 27);
    freq.put("сил", 135);
    freq.put("сии", 104);
    freq.put("сий", 40);
    freq.put("сио", 30);
    freq.put("сип", 11);
    freq.put("сим", 66);
    freq.put("син", 35);
    freq.put("Гео", 8);
    freq.put("Ген", 11);
    freq.put("Гел", 9);
  }
  
}

