package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class SQ {
  private static final String name = "sq";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public SQ() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 158125;
    n_words[1] = 193924;
    n_words[2] = 146801;

    freq.put("xt ", 4);
    freq.put(" y ", 5);
    freq.put("oOn", 3);
    freq.put("e ", 6998);
    freq.put(" yj", 3);
    freq.put(" yl", 5);
    freq.put(" yo", 16);
    freq.put("k", 5158);
    freq.put(" ye", 9);
    freq.put(" yt", 4);
    freq.put(" yu", 4);
    freq.put("Lë", 4);
    freq.put("jm ", 59);
    freq.put("jmi", 4);
    freq.put("jme", 47);
    freq.put("Le", 39);
    freq.put("Lc", 3);
    freq.put("La", 91);
    freq.put("Lo", 29);
    freq.put("Ll", 3);
    freq.put("Lj", 6);
    freq.put("Lk", 3);
    freq.put("Li", 73);
    freq.put("Lu", 28);
    freq.put("Lr", 3);
    freq.put("Ly", 8);
    freq.put("hof", 8);
    freq.put("hod", 11);
    freq.put("hob", 4);
    freq.put("hon", 54);
    freq.put("hoo", 7);
    freq.put("hol", 10);
    freq.put("hom", 21);
    freq.put("hoj", 33);
    freq.put("hok", 17);
    freq.put("hoh", 21);
    freq.put("how", 4);
    freq.put("hot", 37);
    freq.put("hor", 23);
    freq.put("hos", 6);
    freq.put("hop", 8);
    freq.put("hoq", 33);
    freq.put("hox", 4);
    freq.put("A", 705);
    freq.put("L ", 44);
    freq.put("jmë", 14);
    freq.put("ho ", 14);
    freq.put(" V ", 3);
    freq.put(" ën", 4);
    freq.put("xh", 94);
    freq.put(" ëm", 3);
    freq.put(" ës", 53);
    freq.put("xi", 15);
    freq.put("zaj", 8);
    freq.put("xo", 31);
    freq.put("fir", 8);
    freq.put("fis", 21);
    freq.put("fiq", 9);
    freq.put("Hit", 3);
    freq.put("fit", 37);
    freq.put("fiz", 8);
    freq.put("fic", 14);
    freq.put("rç", 3);
    freq.put("fid", 4);
    freq.put("fij", 4);
    freq.put("fik", 14);
    freq.put("fin", 33);
    freq.put("fil", 34);
    freq.put("rë", 201);
    freq.put(" Va", 27);
    freq.put(" Ve", 36);
    freq.put(" Vd", 3);
    freq.put("au ", 24);
    freq.put(" Vi", 31);
    freq.put("xf", 3);
    freq.put(" Vj", 6);
    freq.put(" Vl", 15);
    freq.put(" Vo", 12);
    freq.put(" Vu", 3);
    freq.put("zaa", 4);
    freq.put("lSo", 5);
    freq.put("atë", 46);
    freq.put("fi ", 35);
    freq.put("rV", 3);
    freq.put("mdo", 5);
    freq.put("rR", 5);
    freq.put("rS", 3);
    freq.put("rY", 3);
    freq.put("rF", 3);
    freq.put("rG", 4);
    freq.put("rA", 3);
    freq.put("rB", 3);
    freq.put("rL", 5);
    freq.put("rM", 4);
    freq.put("xp", 8);
    freq.put("rJ", 7);
    freq.put("mdu", 6);
    freq.put("rt", 354);
    freq.put("ru", 203);
    freq.put("rv", 38);
    freq.put("rw", 9);
    freq.put("rp", 40);
    freq.put("rq", 13);
    freq.put("rr", 527);
    freq.put("rs", 134);
    freq.put("smu", 13);
    freq.put("rx", 8);
    freq.put("ry", 129);
    freq.put("rz", 78);
    freq.put("rd", 170);
    freq.put("re", 1288);
    freq.put("rf", 39);
    freq.put("rg", 114);
    freq.put("ra", 921);
    freq.put("rb", 98);
    freq.put("rc", 68);
    freq.put("rl", 47);
    freq.put("rm", 119);
    freq.put("rn", 69);
    freq.put("ro", 400);
    freq.put("rh", 18);
    freq.put("ri", 1356);
    freq.put("rj", 70);
    freq.put("rk", 115);
    freq.put("Egz", 4);
    freq.put("OW ", 3);
    freq.put("zaK", 3);
    freq.put("atf", 4);
    freq.put("ate", 105);
    freq.put("atc", 3);
    freq.put("ata", 86);
    freq.put("ato", 66);
    freq.put("atl", 8);
    freq.put("atm", 7);
    freq.put("atj", 23);
    freq.put("atk", 3);
    freq.put("ath", 11);
    freq.put("ati", 119);
    freq.put("att", 10);
    freq.put("atu", 31);
    freq.put("r ", 1884);
    freq.put("ats", 7);
    freq.put("atz", 5);
    freq.put("ds ", 5);
    freq.put("aty", 29);
    freq.put("Duh", 8);
    freq.put("kfu", 3);
    freq.put("Dua", 5);
    freq.put("qka", 76);
    freq.put("Dur", 11);
    freq.put("oqë", 4);
    freq.put("ëhe", 5);
    freq.put("alt", 21);
    freq.put("qk ", 10);
    freq.put("Soc", 4);
    freq.put("tëv", 14);
    freq.put(" ft", 29);
    freq.put("xi ", 5);
    freq.put("nzi", 4);
    freq.put("iar", 6);
    freq.put("oqe", 19);
    freq.put("oqn", 6);
    freq.put("Son", 15);
    freq.put("oqk", 13);
    freq.put("oqj", 3);
    freq.put("oqi", 7);
    freq.put("Asd", 4);
    freq.put("nel", 16);
    freq.put("Mbr", 3);
    freq.put("tëp", 4);
    freq.put("Lj ", 3);
    freq.put("SE ", 7);
    freq.put("irë", 32);
    freq.put("X", 111);
    freq.put("Rit", 7);
    freq.put("zt ", 13);
    freq.put("oke", 30);
    freq.put("Rik", 3);
    freq.put("Ric", 4);
    freq.put("PS ", 5);
    freq.put("irJ", 3);
    freq.put("irr", 24);
    freq.put("irs", 3);
    freq.put("irt", 20);
    freq.put("iru", 6);
    freq.put("irw", 3);
    freq.put("iri", 76);
    freq.put("irj", 9);
    freq.put("irk", 3);
    freq.put("irl", 4);
    freq.put("irm", 14);
    freq.put("iro", 14);
    freq.put("ira", 79);
    freq.put("irc", 20);
    freq.put("ire", 72);
    freq.put("Yll", 14);
    freq.put("cur", 3);
    freq.put("oki", 8);
    freq.put("ir ", 129);
    freq.put("and", 62);
    freq.put("fra", 6);
    freq.put("dhë", 13);
    freq.put("fre", 3);
    freq.put("fri", 15);
    freq.put("fro", 5);
    freq.put("fry", 15);
    freq.put("ann", 21);
    freq.put("smi", 13);
    freq.put("BE ", 8);
    freq.put("për", 201);
    freq.put("pës", 3);
    freq.put("bil", 15);
    freq.put("bim", 16);
    freq.put("jk ", 8);
    freq.put("dho", 9);
    freq.put("dhm", 9);
    freq.put("dhl", 3);
    freq.put("dhj", 61);
    freq.put("dhi", 41);
    freq.put("dhe", 506);
    freq.put("dha", 25);
    freq.put("dhu", 21);
    freq.put("dht", 12);
    freq.put("dhs", 9);
    freq.put("jku", 3);
    freq.put("bic", 4);
    freq.put("pë ", 4);
    freq.put("jke", 8);
    freq.put("jka", 12);
    freq.put("dh ", 87);
    freq.put("kMo", 5);
    freq.put("hah", 743);
    freq.put("hai", 5);
    freq.put("haj", 76);
    freq.put("hak", 10);
    freq.put("hal", 69);
    freq.put("ham", 40);
    freq.put("han", 75);
    freq.put("haa", 29);
    freq.put("hab", 12);
    freq.put("hac", 13);
    freq.put("had", 3);
    freq.put("haf", 12);
    freq.put("hax", 4);
    freq.put("hap", 25);
    freq.put("haq", 11);
    freq.put("har", 91);
    freq.put("has", 52);
    freq.put("hat", 52);
    freq.put("hau", 7);
    freq.put("hav", 7);
    freq.put("ha ", 333);
    freq.put("ola", 18);
    freq.put("old", 3);
    freq.put("ole", 17);
    freq.put("oli", 70);
    freq.put("olj", 3);
    freq.put(" X ", 5);
    freq.put("oll", 133);
    freq.put("olo", 11);
    freq.put("olt", 5);
    freq.put("olu", 8);
    freq.put("fot", 46);
    freq.put("umt", 17);
    freq.put("for", 61);
    freq.put("umr", 8);
    freq.put("foz", 10);
    freq.put("haç", 6);
    freq.put("ume", 64);
    freq.put("uma", 20);
    freq.put("umb", 22);
    freq.put("fol", 53);
    freq.put("fon", 12);
    freq.put("foo", 3);
    freq.put("umi", 33);
    freq.put("ol ", 46);
    freq.put(" Xh", 18);
    freq.put(" Xa", 5);
    freq.put(" Xy", 3);
    freq.put("o", 8308);
    freq.put("um ", 191);
    freq.put("mbl", 8);
    freq.put("mbo", 10);
    freq.put("mbi", 25);
    freq.put("mbj", 12);
    freq.put("mbe", 26);
    freq.put("sok", 5);
    freq.put("Fem", 4);
    freq.put("som", 3);
    freq.put("sol", 8);
    freq.put("son", 75);
    freq.put("Fet", 5);
    freq.put("sor", 24);
    freq.put("Fer", 9);
    freq.put("Fes", 5);
    freq.put("sov", 155);
    freq.put("mbu", 18);
    freq.put("Ee ", 4);
    freq.put("mbr", 19);
    freq.put("mbs", 3);
    freq.put("az ", 18);
    freq.put("jLi", 3);
    freq.put("so ", 26);
    freq.put("mb ", 13);
    freq.put("Rro", 4);
    freq.put("azi", 31);
    freq.put("azl", 7);
    freq.put("azm", 6);
    freq.put("Rri", 4);
    freq.put("azo", 9);
    freq.put("aza", 6);
    freq.put("Rre", 4);
    freq.put("aze", 23);
    freq.put("azz", 3);
    freq.put("Rru", 3);
    freq.put("qim", 7);
    freq.put("qil", 5);
    freq.put("qin", 18);
    freq.put("qik", 24);
    freq.put("qij", 7);
    freq.put("qie", 3);
    freq.put("qif", 10);
    freq.put("CgD", 6);
    freq.put("kho", 10);
    freq.put("qit", 47);
    freq.put("qiv", 4);
    freq.put("qip", 225);
    freq.put("qis", 11);
    freq.put("qir", 21);
    freq.put("E", 356);
    freq.put("qi ", 65);
    freq.put("Si ", 15);
    freq.put("kh ", 5);
    freq.put("Ida", 3);
    freq.put("eAl", 5);
    freq.put("nxe", 7);
    freq.put("yCh", 5);
    freq.put("nxo", 4);
    freq.put("nxi", 6);
    freq.put("nxj", 3);
    freq.put("osp", 3);
    freq.put("oss", 9);
    freq.put("osu", 7);
    freq.put("ost", 40);
    freq.put("osi", 9);
    freq.put("osh", 172);
    freq.put("osk", 3);
    freq.put("osj", 12);
    freq.put("oso", 153);
    freq.put("osa", 7);
    freq.put("ose", 24);
    freq.put("vet", 115);
    freq.put("ver", 64);
    freq.put("ves", 46);
    freq.put("vep", 3);
    freq.put("veq", 100);
    freq.put("vez", 4);
    freq.put("veg", 3);
    freq.put("ved", 4);
    freq.put("vee", 6);
    freq.put("vec", 16);
    freq.put("ven", 83);
    freq.put("vel", 13);
    freq.put("lre", 4);
    freq.put("Më", 5);
    freq.put("os ", 153);
    freq.put("VAi", 3);
    freq.put("Tas", 8);
    freq.put("ëjn", 3);
    freq.put("gDm", 6);
    freq.put("Aq ", 5);
    freq.put("ve ", 242);
    freq.put("Tal", 5);
    freq.put("Tam", 3);
    freq.put("Tan", 8);
    freq.put("Tah", 4);
    freq.put("M ", 62);
    freq.put("veç", 3);
    freq.put("Me", 114);
    freq.put("Md", 3);
    freq.put("Mg", 3);
    freq.put("Ma", 150);
    freq.put("Mc", 3);
    freq.put("Mb", 11);
    freq.put("Mm", 4);
    freq.put("Ml", 6);
    freq.put("Mo", 51);
    freq.put("Mi", 96);
    freq.put("Mj", 10);
    freq.put("Mu", 50);
    freq.put("Ms", 6);
    freq.put("Mr", 6);
    freq.put("My", 4);
    freq.put("bt", 17);
    freq.put("ugi", 4);
    freq.put("ipa", 8);
    freq.put("ipe", 63);
    freq.put("ipi", 13);
    freq.put("ipn", 8);
    freq.put("ipo", 4);
    freq.put("ipl", 4);
    freq.put("ipr", 5);
    freq.put("ipp", 3);
    freq.put("ipt", 72);
    freq.put("ip ", 65);
    freq.put("së", 108);
    freq.put("gzo", 23);
    freq.put("gzi", 4);
    freq.put("ipë", 10);
    freq.put("tnd", 3);
    freq.put("gzu", 5);
    freq.put("çdo", 3);
    freq.put("s ", 976);
    freq.put("sY", 3);
    freq.put("sS", 5);
    freq.put("sR", 6);
    freq.put("sW", 4);
    freq.put("sK", 6);
    freq.put("sI", 3);
    freq.put("sO", 4);
    freq.put("sM", 8);
    freq.put("sL", 3);
    freq.put("sB", 4);
    freq.put("sA", 4);
    freq.put("sF", 4);
    freq.put("NCg", 6);
    freq.put("sy", 52);
    freq.put("ss", 91);
    freq.put("sr", 13);
    freq.put("sq", 9);
    freq.put("sp", 115);
    freq.put("sw", 6);
    freq.put("sv", 12);
    freq.put("su", 132);
    freq.put("st", 380);
    freq.put("sk", 141);
    freq.put("sj", 79);
    freq.put("si", 552);
    freq.put("sh", 3186);
    freq.put("so", 422);
    freq.put("sn", 67);
    freq.put("sm", 75);
    freq.put("sl", 47);
    freq.put("sc", 15);
    freq.put("sb", 18);
    freq.put("sa", 387);
    freq.put("sg", 12);
    freq.put("sf", 15);
    freq.put("se", 801);
    freq.put("sd", 39);
    freq.put("──", 7);
    freq.put("KA ", 8);
    freq.put("ttp", 814);
    freq.put("ttt", 19);
    freq.put("tti", 3);
    freq.put("tth", 4);
    freq.put("tto", 6);
    freq.put("tta", 13);
    freq.put("tte", 28);
    freq.put("jig", 12);
    freq.put("jid", 4);
    freq.put("ëzi", 11);
    freq.put("jin", 30);
    freq.put("jim", 7);
    freq.put("jik", 7);
    freq.put("dja", 31);
    freq.put("jit", 103);
    freq.put("jir", 7);
    freq.put("jis", 6);
    freq.put("Ç", 14);
    freq.put("tt ", 43);
    freq.put("aft", 13);
    freq.put("LI ", 7);
    freq.put("ji ", 23);
    freq.put("blu", 6);
    freq.put("bll", 8);
    freq.put("blo", 3);
    freq.put("bli", 26);
    freq.put("Joh", 4);
    freq.put("bla", 4);
    freq.put("Jo ", 11);
    freq.put("Huh", 3);
    freq.put("onj", 22);
    freq.put("onk", 9);
    freq.put("oni", 193);
    freq.put("onn", 15);
    freq.put("ono", 17);
    freq.put("onb", 3);
    freq.put("onc", 10);
    freq.put("ona", 130);
    freq.put("onf", 11);
    freq.put("ong", 24);
    freq.put("ond", 32);
    freq.put("one", 79);
    freq.put("ons", 22);
    freq.put("onv", 3);
    freq.put("ont", 54);
    freq.put("onu", 8);
    freq.put("onK", 5);
    freq.put("rz ", 19);
    freq.put("onB", 5);
    freq.put("uku", 25);
    freq.put("rmu", 7);
    freq.put("uks", 10);
    freq.put("ukr", 6);
    freq.put("ukn", 3);
    freq.put("uki", 7);
    freq.put("fmi", 9);
    freq.put("onR", 4);
    freq.put("onS", 3);
    freq.put("uke", 36);
    freq.put("uka", 10);
    freq.put(" Zo", 15);
    freq.put(" Zi", 6);
    freq.put(" Zh", 5);
    freq.put(" Ze", 19);
    freq.put("on ", 521);
    freq.put(" Za", 10);
    freq.put(" Zb", 4);
    freq.put(" Zy", 5);
    freq.put(" Zv", 3);
    freq.put("rze", 3);
    freq.put("rza", 8);
    freq.put("rzo", 3);
    freq.put("rzi", 28);
    freq.put("rzv", 3);
    freq.put("rzu", 3);
    freq.put("rzt", 9);
    freq.put("uk ", 203);
    freq.put("sak", 14);
    freq.put("saj", 30);
    freq.put("sai", 3);
    freq.put("sah", 10);
    freq.put("san", 28);
    freq.put("sam", 5);
    freq.put("sal", 14);
    freq.put("sab", 10);
    freq.put("saf", 7);
    freq.put("zoN", 5);
    freq.put("sad", 10);
    freq.put("saz", 5);
    freq.put("say", 3);
    freq.put("sas", 4);
    freq.put("sar", 22);
    freq.put("sap", 5);
    freq.put("sav", 5);
    freq.put(" Co", 16);
    freq.put("saN", 3);
    freq.put("saL", 6);
    freq.put("zoh", 19);
    freq.put("zoj", 4);
    freq.put("zol", 4);
    freq.put("zon", 42);
    freq.put("zor", 4);
    freq.put("zot", 19);
    freq.put(" Zë", 3);
    freq.put("sa ", 167);
    freq.put(" Ce", 6);
    freq.put("zo ", 4);
    freq.put("axh", 17);
    freq.put("qov", 5);
    freq.put("qor", 3);
    freq.put("Sky", 3);
    freq.put("Ske", 3);
    freq.put("qof", 8);
    freq.put("Ska", 5);
    freq.put("qon", 4);
    freq.put("Ski", 6);
    freq.put("qoj", 4);
    freq.put("ytj", 5);
    freq.put("yti", 3);
    freq.put("uy", 8);
    freq.put("uz", 40);
    freq.put(" bë", 21);
    freq.put("uu", 72);
    freq.put("uq", 24);
    freq.put("up", 106);
    freq.put("us", 339);
    freq.put("ur", 729);
    freq.put("um", 413);
    freq.put("ël ", 6);
    freq.put(" b ", 11);
    freq.put("Ndo", 3);
    freq.put("uj", 165);
    freq.put("Nde", 5);
    freq.put("ud", 45);
    freq.put(" be", 138);
    freq.put("kja", 3);
    freq.put(" ba", 197);
    freq.put("kje", 11);
    freq.put("ëll", 7);
    freq.put(" bl", 48);
    freq.put(" bo", 264);
    freq.put(" bn", 4);
    freq.put(" bi", 51);
    freq.put("kjo", 50);
    freq.put(" bk", 5);
    freq.put(" bj", 16);
    freq.put(" bu", 70);
    freq.put(" bt", 5);
    freq.put("s", 7865);
    freq.put("ëlq", 4);
    freq.put(" br", 85);
    freq.put(" by", 3);
    freq.put("RU ", 3);
    freq.put("Qe ", 18);
    freq.put("gës", 4);
    freq.put("gër", 3);
    freq.put("fia", 3);
    freq.put("gël", 5);
    freq.put("gën", 5);
    freq.put("Qen", 16);
    freq.put("Qes", 4);
    freq.put("Qer", 3);
    freq.put("Qev", 6);
    freq.put("gë ", 9);
    freq.put("fim", 4);
    freq.put("ive", 45);
    freq.put("iva", 15);
    freq.put("tën", 26);
    freq.put("ivo", 6);
    freq.put("ivi", 17);
    freq.put("ivj", 4);
    freq.put("orx", 3);
    freq.put("tët", 9);
    freq.put("tër", 19);
    freq.put("tës", 31);
    freq.put("ivr", 3);
    freq.put("tëz", 4);
    freq.put("UT ", 4);
    freq.put("IR ", 6);
    freq.put("ësu", 6);
    freq.put("iv ", 11);
    freq.put("të ", 475);
    freq.put("I", 230);
    freq.put("Mar", 33);
    freq.put("DI ", 5);
    freq.put("ezë", 3);
    freq.put("çfa", 5);
    freq.put("Mah", 4);
    freq.put("ëso", 9);
    freq.put("NA ", 6);
    freq.put("º", 4);
    freq.put(" gj", 235);
    freq.put("Mal", 6);
    freq.put(" gi", 9);
    freq.put("ezz", 4);
    freq.put("ezu", 10);
    freq.put("tvo", 3);
    freq.put("ezo", 12);
    freq.put("tvi", 5);
    freq.put("ezi", 25);
    freq.put("tve", 16);
    freq.put("eze", 20);
    freq.put("eza", 15);
    freq.put("ac ", 7);
    freq.put("jgn", 3);
    freq.put("jga", 8);
    freq.put("ddm", 9);
    freq.put("aIb", 3);
    freq.put("dde", 3);
    freq.put("Zyr", 4);
    freq.put("ez ", 20);
    freq.put("tv ", 7);
    freq.put("aca", 7);
    freq.put("ace", 23);
    freq.put("ack", 4);
    freq.put("aci", 34);
    freq.put("ach", 3);
    freq.put("aco", 3);
    freq.put("acm", 16);
    freq.put("act", 3);
    freq.put("dd ", 4);
    freq.put("Ni", 31);
    freq.put("Nj", 29);
    freq.put("Nm", 4);
    freq.put("aç", 14);
    freq.put("ohë", 9);
    freq.put("Na", 46);
    freq.put("Nd", 19);
    freq.put("Ne", 62);
    freq.put("Ng", 10);
    freq.put("Nx", 5);
    freq.put("Nz", 3);
    freq.put("Np", 5);
    freq.put("Ns", 5);
    freq.put("Nu", 44);
    freq.put("het", 257);
    freq.put("heu", 5);
    freq.put("hev", 9);
    freq.put("hep", 8);
    freq.put("heq", 7);
    freq.put("her", 127);
    freq.put("hes", 56);
    freq.put("hez", 4);
    freq.put("hee", 15);
    freq.put("hef", 10);
    freq.put("hea", 4);
    freq.put("hec", 5);
    freq.put("hel", 30);
    freq.put("hem", 73);
    freq.put("hen", 119);
    freq.put("heh", 52);
    freq.put("hei", 4);
    freq.put("hej", 25);
    freq.put("hek", 18);
    freq.put("qr ", 3);
    freq.put("N ", 92);
    freq.put("nSh", 5);
    freq.put("nSa", 3);
    freq.put("he ", 666);
    freq.put("umë", 22);
    freq.put("aa", 275);
    freq.put("ac", 107);
    freq.put("Në", 21);
    freq.put("ohh", 3);
    freq.put("ad", 238);
    freq.put("ag", 87);
    freq.put("af", 135);
    freq.put("ai", 79);
    freq.put("ah", 1007);
    freq.put("Hol", 3);
    freq.put("aj", 677);
    freq.put("am", 516);
    freq.put("al", 849);
    freq.put("ao", 19);
    freq.put("an", 1076);
    freq.put("aq", 216);
    freq.put("ap", 175);
    freq.put("as", 966);
    freq.put("ar", 1361);
    freq.put("au", 74);
    freq.put("at", 876);
    freq.put("aw", 12);
    freq.put("av", 150);
    freq.put("ay", 50);
    freq.put("ax", 28);
    freq.put("az", 156);
    freq.put("Hox", 8);
    freq.put("aA", 25);
    freq.put("aC", 7);
    freq.put("aB", 25);
    freq.put("aE", 6);
    freq.put("aD", 13);
    freq.put("aG", 12);
    freq.put("aF", 4);
    freq.put("aI", 11);
    freq.put("aH", 19);
    freq.put("aK", 23);
    freq.put("aJ", 7);
    freq.put("aM", 22);
    freq.put("aL", 23);
    freq.put("aO", 4);
    freq.put("aN", 11);
    freq.put("aQ", 3);
    freq.put("aP", 5);
    freq.put("aS", 37);
    freq.put("aR", 21);
    freq.put("aU", 7);
    freq.put("aT", 14);
    freq.put("aV", 7);
    freq.put("aX", 13);
    freq.put("rK", 6);
    freq.put("a ", 3955);
    freq.put("oh ", 26);
    freq.put("rxh", 5);
    freq.put("at ", 278);
    freq.put("Fis", 7);
    freq.put("sco", 3);
    freq.put("tZ", 4);
    freq.put("sch", 5);
    freq.put("Fit", 10);
    freq.put("tV", 3);
    freq.put("sms", 3);
    freq.put("tT", 10);
    freq.put("sca", 3);
    freq.put("tS", 3);
    freq.put("tP", 4);
    freq.put("mni", 4);
    freq.put("tM", 6);
    freq.put("tK", 10);
    freq.put("tH", 5);
    freq.put("tI", 4);
    freq.put("tF", 4);
    freq.put("mna", 18);
    freq.put("tD", 4);
    freq.put("tE", 3);
    freq.put("tB", 5);
    freq.put("mne", 4);
    freq.put("Fil", 6);
    freq.put("tA", 5);
    freq.put("zmi", 4);
    freq.put("tz", 12);
    freq.put("ty", 157);
    freq.put("tv", 34);
    freq.put("tw", 42);
    freq.put("tt", 941);
    freq.put("tu", 474);
    freq.put("tr", 270);
    freq.put("ts", 58);
    freq.put("tp", 850);
    freq.put("tq", 8);
    freq.put("tn", 38);
    freq.put("to", 540);
    freq.put("tl", 36);
    freq.put("tm", 74);
    freq.put("tj", 194);
    freq.put("tk", 55);
    freq.put("th", 478);
    freq.put("ti", 1022);
    freq.put("tf", 20);
    freq.put("tg", 15);
    freq.put("td", 25);
    freq.put("te", 1469);
    freq.put("tb", 33);
    freq.put("tc", 14);
    freq.put("ta", 1017);
    freq.put("dsh", 6);
    freq.put("Ë", 4);
    freq.put("dsi", 3);
    freq.put("mn ", 7);
    freq.put("sme", 13);
    freq.put(" zv", 3);
    freq.put("sma", 22);
    freq.put("eça", 7);
    freq.put("t ", 3618);
    freq.put("Smi", 4);
    freq.put("të", 597);
    freq.put("▄", 6);
    freq.put("xom", 3);
    freq.put("xoj", 6);
    freq.put("vic", 9);
    freq.put("via", 24);
    freq.put("vig", 4);
    freq.put("vid", 18);
    freq.put("vij", 11);
    freq.put("vik", 11);
    freq.put("vin", 14);
    freq.put("vil", 7);
    freq.put("vim", 6);
    freq.put("vis", 19);
    freq.put("Aus", 3);
    freq.put("viq", 3);
    freq.put("vit", 49);
    freq.put("viz", 25);
    freq.put("kl ", 4);
    freq.put("ën ", 103);
    freq.put(" d ", 10);
    freq.put("VE ", 8);
    freq.put("vi ", 12);
    freq.put(" dP", 3);
    freq.put(" do", 261);
    freq.put("kle", 4);
    freq.put(" dm", 9);
    freq.put(" dj", 42);
    freq.put(" di", 337);
    freq.put(" dh", 229);
    freq.put(" dg", 4);
    freq.put("ëng", 5);
    freq.put(" de", 162);
    freq.put("klo", 4);
    freq.put("kli", 6);
    freq.put(" da", 134);
    freq.put("ëna", 10);
    freq.put("klu", 5);
    freq.put(" dy", 61);
    freq.put(" du", 170);
    freq.put("ënu", 4);
    freq.put(" dr", 59);
    freq.put(" dp", 3);
    freq.put("RS ", 3);
    freq.put("tsi", 6);
    freq.put("xue", 3);
    freq.put("atr", 17);
    freq.put(" dë", 13);
    freq.put("ënë", 14);
    freq.put("Qka", 4);
    freq.put("itn", 5);
    freq.put("ito", 58);
    freq.put("IP ", 7);
    freq.put("Xh ", 6);
    freq.put("itj", 12);
    freq.put("itk", 5);
    freq.put("ith", 92);
    freq.put("iti", 95);
    freq.put("itg", 3);
    freq.put("ite", 150);
    freq.put("itc", 3);
    freq.put("ita", 120);
    freq.put("Duk", 3);
    freq.put("ity", 4);
    freq.put("itt", 36);
    freq.put("itu", 56);
    freq.put("itr", 4);
    freq.put("its", 11);
    freq.put("ftë", 10);
    freq.put("itR", 3);
    freq.put("Xha", 3);
    freq.put("Xhe", 19);
    freq.put("it ", 485);
    freq.put("DK ", 6);
    freq.put(" A ", 61);
    freq.put("itë", 29);
    freq.put("tre", 59);
    freq.put("ftu", 5);
    freq.put("fty", 13);
    freq.put("fta", 3);
    freq.put("fte", 13);
    freq.put("fti", 14);
    freq.put("fto", 20);
    freq.put(" Ab", 7);
    freq.put(" Ac", 6);
    freq.put(" Ad", 16);
    freq.put(" Af", 9);
    freq.put(" Ag", 15);
    freq.put(" Ah", 5);
    freq.put(" Ai", 18);
    freq.put(" Aj", 20);
    freq.put(" Ak", 6);
    freq.put(" Al", 135);
    freq.put(" Am", 19);
    freq.put(" An", 32);
    freq.put(" Ap", 7);
    freq.put(" Aq", 5);
    freq.put(" Ar", 86);
    freq.put(" As", 14);
    freq.put(" At", 12);
    freq.put(" Au", 7);
    freq.put(" Av", 3);
    freq.put(" Ay", 3);
    freq.put(" Az", 10);
    freq.put("trr", 10);
    freq.put("NG ", 3);
    freq.put("ft ", 23);
    freq.put("w", 305);
    freq.put("Fra", 6);
    freq.put("uel", 5);
    freq.put("Fri", 3);
    freq.put("KE ", 6);
    freq.put("zSa", 3);
    freq.put("jer", 153);
    freq.put("jes", 99);
    freq.put("jep", 12);
    freq.put("jev", 12);
    freq.put("aa ", 70);
    freq.put("jet", 246);
    freq.put("jeg", 6);
    freq.put("jed", 34);
    freq.put("jee", 9);
    freq.put("jej", 26);
    freq.put("jek", 15);
    freq.put("jeh", 16);
    freq.put("jen", 171);
    freq.put("jeo", 3);
    freq.put("jel", 26);
    freq.put("jem", 54);
    freq.put("aaa", 126);
    freq.put("aam", 3);
    freq.put("aal", 7);
    freq.put("aan", 7);
    freq.put("aah", 13);
    freq.put("aaj", 6);
    freq.put("aat", 3);
    freq.put("je ", 403);
    freq.put("aas", 7);
    freq.put("aar", 3);
    freq.put("OT ", 4);
    freq.put("Dhe", 9);
    freq.put("mdh", 10);
    freq.put("tp ", 808);
    freq.put("jeç", 7);
    freq.put("M", 651);
    freq.put("Ish", 10);
    freq.put("Isl", 10);
    freq.put("tpe", 7);
    freq.put("tpa", 14);
    freq.put("exo", 6);
    freq.put("exh", 19);
    freq.put("tph", 3);
    freq.put("ext", 5);
    freq.put("exu", 4);
    freq.put("tps", 10);
    freq.put("tpr", 3);
    freq.put("exp", 4);
    freq.put("Hah", 8);
    freq.put("Hai", 4);
    freq.put("Haj", 10);
    freq.put("Hak", 4);
    freq.put("Hal", 14);
    freq.put("ojs", 17);
    freq.put("uga", 3);
    freq.put("uge", 12);
    freq.put("Hax", 4);
    freq.put("oje", 42);
    freq.put("oja", 22);
    freq.put("ojn", 117);
    freq.put("ojo", 3);
    freq.put("Har", 15);
    freq.put("Has", 13);
    freq.put("ojj", 3);
    freq.put("ojk", 8);
    freq.put("oji", 3);
    freq.put("rf ", 4);
    freq.put("oj ", 146);
    freq.put("rfs", 7);
    freq.put("rfu", 11);
    freq.put("rfa", 9);
    freq.put("cre", 3);
    freq.put("knp", 4);
    freq.put("rfo", 4);
    freq.put("Fot", 6);
    freq.put("sev", 4);
    freq.put("set", 14);
    freq.put("ses", 23);
    freq.put("ser", 55);
    freq.put("For", 10);
    freq.put("sep", 10);
    freq.put("sez", 5);
    freq.put("see", 7);
    freq.put("sec", 8);
    freq.put("sea", 12);
    freq.put("sen", 70);
    freq.put("sem", 10);
    freq.put("sel", 16);
    freq.put("sek", 17);
    freq.put("sej", 3);
    freq.put(" qm", 5);
    freq.put("ue ", 18);
    freq.put("se ", 535);
    freq.put("let", 54);
    freq.put("nr ", 3);
    freq.put("lex", 9);
    freq.put("tiv", 28);
    freq.put("nri", 3);
    freq.put("nre", 3);
    freq.put("tip", 5);
    freq.put("mlm", 3);
    freq.put(" fë", 8);
    freq.put("vod", 4);
    freq.put("vog", 12);
    freq.put("vol", 3);
    freq.put("von", 12);
    freq.put("voo", 5);
    freq.put("voj", 20);
    freq.put("vok", 4);
    freq.put("vot", 17);
    freq.put("amj", 15);
    freq.put("vor", 12);
    freq.put("tir", 19);
    freq.put("kn ", 7);
    freq.put(" f ", 5);
    freq.put("lxu", 8);
    freq.put("vo ", 11);
    freq.put("tis", 18);
    freq.put("lxo", 15);
    freq.put("kno", 11);
    freq.put(" fs", 9);
    freq.put(" fr", 26);
    freq.put(" fu", 83);
    freq.put("ëpu", 4);
    freq.put("kni", 5);
    freq.put("Sok", 3);
    freq.put("kne", 10);
    freq.put("kna", 24);
    freq.put(" fa", 127);
    freq.put(" fb", 9);
    freq.put(" fe", 65);
    freq.put("Sot", 11);
    freq.put(" fi", 91);
    freq.put("ëpi", 3);
    freq.put(" fk", 3);
    freq.put(" fj", 51);
    freq.put(" fm", 11);
    freq.put(" fl", 70);
    freq.put(" fo", 135);
    freq.put(" fn", 3);
    freq.put("O ", 110);
    freq.put("ijë", 8);
    freq.put("Veq", 3);
    freq.put("Oo", 5);
    freq.put("On", 9);
    freq.put("Om", 5);
    freq.put("Ol", 4);
    freq.put("Ok", 3);
    freq.put("Oj", 10);
    freq.put("Oi", 6);
    freq.put("Oh", 5);
    freq.put("Of", 12);
    freq.put("Od", 3);
    freq.put("Ob", 3);
    freq.put("bë", 51);
    freq.put("tsa", 7);
    freq.put("Ow", 3);
    freq.put("Os", 12);
    freq.put("Or", 10);
    freq.put("Op", 6);
    freq.put("d", 4004);
    freq.put("Kha", 3);
    freq.put("b ", 103);
    freq.put("iju", 5);
    freq.put("tof", 7);
    freq.put("ija", 39);
    freq.put("ije", 31);
    freq.put("ijn", 8);
    freq.put("bd", 6);
    freq.put("be", 269);
    freq.put("bg", 3);
    freq.put("ba", 346);
    freq.put("bb", 12);
    freq.put("bl", 107);
    freq.put("bm", 4);
    freq.put("bn", 9);
    freq.put("bo", 352);
    freq.put("bi", 189);
    freq.put("bj", 31);
    freq.put("bk", 8);
    freq.put("ij ", 30);
    freq.put("bu", 130);
    freq.put("bv", 3);
    freq.put("bw", 3);
    freq.put("bp", 5);
    freq.put("bq", 4);
    freq.put("br", 152);
    freq.put("bs", 17);
    freq.put("by", 14);
    freq.put("Fu", 20);
    freq.put("bD", 3);
    freq.put("bG", 4);
    freq.put("Fv", 4);
    freq.put("bC", 3);
    freq.put("bL", 4);
    freq.put("bM", 3);
    freq.put("bN", 5);
    freq.put("bJ", 3);
    freq.put("bT", 48);
    freq.put("Osm", 3);
    freq.put("Fy", 5);
    freq.put("bZ", 3);
    freq.put("ME ", 24);
    freq.put(" C ", 9);
    freq.put("ci ", 37);
    freq.put("tyr", 36);
    freq.put("u ", 1070);
    freq.put(" Ck", 3);
    freq.put(" Ch", 24);
    freq.put(" Ci", 9);
    freq.put("uX", 3);
    freq.put(" Cl", 6);
    freq.put("uT", 6);
    freq.put(" Ca", 20);
    freq.put(" Cf", 4);
    freq.put(" Cd", 3);
    freq.put("uR", 4);
    freq.put("uM", 3);
    freq.put("Vde", 3);
    freq.put("uH", 3);
    freq.put("uK", 4);
    freq.put(" Cr", 5);
    freq.put("uD", 7);
    freq.put("uG", 3);
    freq.put("zan", 16);
    freq.put("cic", 10);
    freq.put("cia", 31);
    freq.put("AC ", 4);
    freq.put("cig", 3);
    freq.put("ux", 11);
    freq.put("cid", 6);
    freq.put("cik", 6);
    freq.put("ut", 197);
    freq.put("uv", 25);
    freq.put("cio", 23);
    freq.put("cin", 10);
    freq.put("cim", 4);
    freq.put("cil", 32);
    freq.put("cis", 3);
    freq.put("ul", 184);
    freq.put("uo", 5);
    freq.put("un", 526);
    freq.put("ui", 13);
    freq.put("uh", 141);
    freq.put("uk", 317);
    freq.put("cit", 6);
    freq.put("ue", 83);
    freq.put("ciz", 3);
    freq.put("ug", 33);
    freq.put("uf", 34);
    freq.put("ua", 308);
    freq.put("uc", 36);
    freq.put("ub", 53);
    freq.put("qP", 5);
    freq.put("tic", 6);
    freq.put("ag ", 12);
    freq.put("ago", 12);
    freq.put("agj", 12);
    freq.put("age", 7);
    freq.put("aga", 13);
    freq.put("agu", 12);
    freq.put("agr", 4);
    freq.put("Dje", 4);
    freq.put("tr ", 3);
    freq.put("tri", 89);
    freq.put("evi", 8);
    freq.put("tro", 24);
    freq.put("evo", 18);
    freq.put("tra", 65);
    freq.put("eva", 15);
    freq.put("evd", 3);
    freq.put("eve", 83);
    freq.put("evr", 5);
    freq.put("evs", 4);
    freq.put("tru", 13);
    freq.put("le ", 124);
    freq.put("ody", 5);
    freq.put("uen", 3);
    freq.put("uee", 3);
    freq.put("ued", 4);
    freq.put("odr", 7);
    freq.put("odu", 4);
    freq.put("odh", 28);
    freq.put("odi", 12);
    freq.put("Blo", 7);
    freq.put("Ble", 15);
    freq.put("oda", 9);
    freq.put("uev", 3);
    freq.put("odd", 3);
    freq.put("ode", 13);
    freq.put("ues", 33);
    freq.put("rd ", 9);
    freq.put("lea", 8);
    freq.put("led", 16);
    freq.put("lee", 14);
    freq.put("lef", 9);
    freq.put("leg", 23);
    freq.put("leh", 12);
    freq.put("lej", 39);
    freq.put("lek", 18);
    freq.put("lel", 3);
    freq.put("lem", 38);
    freq.put("len", 65);
    freq.put("leo", 6);
    freq.put("lep", 6);
    freq.put("leq", 5);
    freq.put("ler", 54);
    freq.put("les", 33);
    freq.put("rdA", 3);
    freq.put("lev", 8);
    freq.put("od ", 18);
    freq.put("ley", 4);
    freq.put("lez", 10);
    freq.put("leH", 3);
    freq.put("leL", 3);
    freq.put("rde", 9);
    freq.put("rda", 19);
    freq.put("rdo", 22);
    freq.put("rdi", 34);
    freq.put("rdh", 67);
    freq.put("sgt", 4);
    freq.put("ziv", 5);
    freq.put("zit", 46);
    freq.put("zir", 4);
    freq.put("zis", 13);
    freq.put("ziz", 7);
    freq.put("zia", 3);
    freq.put("zin", 11);
    freq.put("zio", 9);
    freq.put("zim", 17);
    freq.put("zij", 3);
    freq.put("zik", 15);
    freq.put("aBa", 5);
    freq.put("aBe", 15);
    freq.put("pff", 3);
    freq.put("zi ", 37);
    freq.put("oz ", 5);
    freq.put("Ë ", 14);
    freq.put("ËN ", 4);
    freq.put("On ", 3);
    freq.put("npe", 6);
    freq.put("Q", 205);
    freq.put("afi", 51);
    freq.put("mje", 25);
    freq.put("mja", 23);
    freq.put("lz ", 4);
    freq.put("hë ", 22);
    freq.put("Sa ", 22);
    freq.put("ër ", 188);
    freq.put(" h ", 16);
    freq.put("hër", 4);
    freq.put("hës", 9);
    freq.put("Yq", 3);
    freq.put("hën", 28);
    freq.put("hëm", 13);
    freq.put("lza", 12);
    freq.put(" hy", 15);
    freq.put("Sah", 7);
    freq.put("San", 5);
    freq.put("Sam", 8);
    freq.put("Sal", 15);
    freq.put("ërr", 9);
    freq.put("ërs", 3);
    freq.put("ërp", 7);
    freq.put("ërt", 12);
    freq.put("ëru", 3);
    freq.put("ërk", 32);
    freq.put("ërh", 3);
    freq.put("ëri", 24);
    freq.put("ërn", 4);
    freq.put("ëro", 5);
    freq.put(" hm", 7);
    freq.put("ërm", 6);
    freq.put("ërb", 8);
    freq.put(" hb", 6);
    freq.put(" ha", 387);
    freq.put("Sap", 3);
    freq.put("ërf", 11);
    freq.put("ërg", 11);
    freq.put("ërd", 9);
    freq.put("ëre", 3);
    freq.put("Rin", 8);
    freq.put("toj", 54);
    freq.put("Kjo", 6);
    freq.put("Ës", 3);
    freq.put("bam", 4);
    freq.put(" hë", 5);
    freq.put("ërë", 7);
    freq.put("OM ", 9);
    freq.put("IT ", 10);
    freq.put("ihu", 3);
    freq.put("Ah ", 3);
    freq.put("ihi", 13);
    freq.put("ihm", 9);
    freq.put("iha", 17);
    freq.put("ihe", 52);
    freq.put("UN ", 4);
    freq.put("mno", 4);
    freq.put("?😂", 4);
    freq.put("ih ", 8);
    freq.put(" E ", 73);
    freq.put("ck ", 18);
    freq.put(" El", 39);
    freq.put(" Em", 12);
    freq.put(" En", 20);
    freq.put(" Ek", 9);
    freq.put(" Ed", 38);
    freq.put(" Eg", 6);
    freq.put("mnd", 4);
    freq.put("Kës", 4);
    freq.put(" Eu", 13);
    freq.put(" Ev", 16);
    freq.put("Vje", 4);
    freq.put(" Es", 4);
    freq.put("cke", 3);
    freq.put("cka", 17);
    freq.put("cki", 5);
    freq.put("cks", 3);
    freq.put("cky", 7);
    freq.put("lB", 4);
    freq.put("jaz", 5);
    freq.put("jay", 3);
    freq.put("jav", 23);
    freq.put("jat", 38);
    freq.put("jau", 16);
    freq.put("jar", 15);
    freq.put("jas", 26);
    freq.put("jap", 12);
    freq.put("jaq", 5);
    freq.put("jan", 62);
    freq.put("ae ", 3);
    freq.put("jal", 79);
    freq.put("jam", 35);
    freq.put("jaj", 3);
    freq.put("jak", 28);
    freq.put("jaf", 7);
    freq.put("jag", 4);
    freq.put("jad", 3);
    freq.put("jaa", 13);
    freq.put("EX ", 4);
    freq.put("h", 8883);
    freq.put("etë", 53);
    freq.put("ja ", 369);
    freq.put("Pr", 62);
    freq.put("Ps", 11);
    freq.put("Pq", 4);
    freq.put("Pv", 5);
    freq.put("Pu", 15);
    freq.put("Py", 3);
    freq.put("oma", 16);
    freq.put("Pb", 4);
    freq.put("Pa", 81);
    freq.put("qta", 4);
    freq.put("Pj", 4);
    freq.put("Ph", 7);
    freq.put("Pi", 11);
    freq.put("Pn", 4);
    freq.put("Po", 61);
    freq.put("Pl", 14);
    freq.put("Pm", 4);
    freq.put("et ", 759);
    freq.put("lg", 9);
    freq.put("P ", 78);
    freq.put("bt ", 7);
    freq.put("qt ", 12);
    freq.put("etr", 20);
    freq.put("ets", 6);
    freq.put("ett", 22);
    freq.put("etu", 24);
    freq.put("ety", 6);
    freq.put("eta", 152);
    freq.put("tle", 8);
    freq.put("ete", 152);
    freq.put("etj", 19);
    freq.put("eth", 33);
    freq.put("eti", 128);
    freq.put("etn", 5);
    freq.put("eto", 61);
    freq.put("etl", 4);
    freq.put("etm", 9);
    freq.put("ck", 63);
    freq.put("cj", 7);
    freq.put("ci", 180);
    freq.put("lm", 62);
    freq.put("co", 856);
    freq.put("cn", 20);
    freq.put("cm", 24);
    freq.put("cc", 11);
    freq.put("cb", 4);
    freq.put("ca", 94);
    freq.put("vë", 58);
    freq.put("cg", 4);
    freq.put("cf", 8);
    freq.put("ce", 132);
    freq.put("cd", 6);
    freq.put("cy", 7);
    freq.put("cs", 5);
    freq.put("cr", 10);
    freq.put("cq", 4);
    freq.put("cp", 4);
    freq.put("cw", 3);
    freq.put("cu", 14);
    freq.put("ct", 8);
    freq.put("cM", 3);
    freq.put("cB", 3);
    freq.put("cG", 4);
    freq.put("cF", 3);
    freq.put("cD", 3);
    freq.put("Geo", 3);
    freq.put("cV", 4);
    freq.put("cU", 4);
    freq.put("rb ", 12);
    freq.put("lga", 4);
    freq.put("iKr", 3);
    freq.put("rbr", 3);
    freq.put("rbl", 7);
    freq.put("rbi", 30);
    freq.put("rbe", 18);
    freq.put("eur", 17);
    freq.put("rba", 14);
    freq.put("cë", 24);
    freq.put("va", 310);
    freq.put("vc", 9);
    freq.put("vd", 29);
    freq.put("ve", 723);
    freq.put("vf", 3);
    freq.put("vg", 4);
    freq.put("vi", 223);
    freq.put("vj", 73);
    freq.put("vk", 4);
    freq.put("vl", 40);
    freq.put("vn", 4);
    freq.put("vo", 109);
    freq.put("vr", 48);
    freq.put("vs", 9);
    freq.put("vu", 15);
    freq.put("vv", 3);
    freq.put("vy", 9);
    freq.put("vz", 7);
    freq.put("daa", 5);
    freq.put("vA", 5);
    freq.put("of ", 15);
    freq.put("vE", 3);
    freq.put("vQ", 3);
    freq.put("zgj", 26);
    freq.put("zga", 3);
    freq.put("v ", 84);
    freq.put("pho", 10);
    freq.put("yol", 3);
    freq.put("ofa", 5);
    freq.put("off", 10);
    freq.put("ofe", 22);
    freq.put("ofi", 7);
    freq.put("ofr", 3);
    freq.put("ofs", 9);
    freq.put("rbë", 4);
    freq.put("oft", 28);
    freq.put("xen", 3);
    freq.put("xet", 3);
    freq.put("web", 3);
    freq.put("umn", 3);
    freq.put("wee", 21);
    freq.put("wel", 3);
    freq.put("wer", 4);
    freq.put("nve", 26);
    freq.put("nva", 4);
    freq.put("you", 15);
    freq.put("nvi", 3);
    freq.put("we ", 3);
    freq.put("Ohh", 3);
    freq.put("daB", 5);
    freq.put("ëtë", 7);
    freq.put(" hq", 3);
    freq.put("AT ", 10);
    freq.put("llg", 3);
    freq.put(" hu", 51);
    freq.put(" ht", 817);
    freq.put(" hj", 4);
    freq.put(" hi", 90);
    freq.put(" hh", 7);
    freq.put(" ho", 31);
    freq.put("kr ", 5);
    freq.put("ët ", 57);
    freq.put(" j ", 4);
    freq.put(" hn", 4);
    freq.put("lle", 49);
    freq.put("Sar", 7);
    freq.put("kry", 39);
    freq.put(" ju", 91);
    freq.put(" jv", 3);
    freq.put("kru", 37);
    freq.put(" jm", 3);
    freq.put(" jo", 197);
    freq.put("kri", 26);
    freq.put("ëti", 5);
    freq.put(" je", 234);
    freq.put(" jg", 5);
    freq.put("kra", 31);
    freq.put(" ja", 236);
    freq.put("ëta", 15);
    freq.put("kre", 91);
    freq.put("inë", 42);
    freq.put("yri", 25);
    freq.put("yrj", 4);
    freq.put("yro", 3);
    freq.put("yra", 26);
    freq.put("yre", 28);
    freq.put("jza", 6);
    freq.put("hpë", 11);
    freq.put("yrt", 13);
    freq.put("Kla", 5);
    freq.put("Klu", 4);
    freq.put("bsu", 3);
    freq.put("yr ", 45);
    freq.put("OO ", 3);
    freq.put("int", 39);
    freq.put("inu", 14);
    freq.put("inv", 5);
    freq.put("inq", 3);
    freq.put("ins", 9);
    freq.put("inm", 6);
    freq.put("inn", 14);
    freq.put("ino", 10);
    freq.put("inh", 4);
    freq.put("ini", 77);
    freq.put("inj", 15);
    freq.put("ink", 9);
    freq.put("ind", 71);
    freq.put("ine", 59);
    freq.put("inf", 4);
    freq.put("ing", 40);
    freq.put("ina", 139);
    freq.put("inc", 12);
    freq.put("eo ", 25);
    freq.put("hpr", 27);
    freq.put("hpu", 5);
    freq.put("inS", 4);
    freq.put("hpi", 33);
    freq.put("hpa", 6);
    freq.put("hpe", 42);
    freq.put("U", 168);
    freq.put("in ", 608);
    freq.put("eog", 3);
    freq.put("eon", 16);
    freq.put("eor", 4);
    freq.put("eot", 3);
    freq.put("Tur", 8);
    freq.put("AH ", 8);
    freq.put("MA ", 4);
    freq.put(" G ", 6);
    freq.put("ali", 147);
    freq.put("Tul", 3);
    freq.put(" Gu", 5);
    freq.put(" Gr", 29);
    freq.put("Tun", 3);
    freq.put(" Gz", 4);
    freq.put(" Ge", 38);
    freq.put(" Ga", 16);
    freq.put(" Go", 13);
    freq.put(" Gj", 48);
    freq.put(" Gh", 6);
    freq.put(" Gi", 3);
    freq.put("iTu", 4);
    freq.put("cmi", 16);
    freq.put("AG ", 5);
    freq.put("ptu", 3);
    freq.put("qut", 3);
    freq.put("tmi", 29);
    freq.put("ak ", 83);
    freq.put("gli", 9);
    freq.put("aks", 14);
    freq.put("gla", 4);
    freq.put("gle", 7);
    freq.put("aku", 39);
    freq.put("sla", 22);
    freq.put("akk", 3);
    freq.put("aki", 28);
    freq.put("akh", 9);
    freq.put("ako", 40);
    freq.put("akl", 4);
    freq.put("aka", 34);
    freq.put("ake", 12);
    freq.put("Jer", 3);
    freq.put("Jet", 18);
    freq.put("bru", 3);
    freq.put("brr", 3);
    freq.put("bro", 14);
    freq.put("bri", 17);
    freq.put("bre", 81);
    freq.put("OR ", 4);
    freq.put("er ", 608);
    freq.put("nka", 20);
    freq.put("nke", 10);
    freq.put("iu", 52);
    freq.put("nko", 6);
    freq.put("Je ", 7);
    freq.put("nks", 7);
    freq.put("nku", 6);
    freq.put("ert", 67);
    freq.put("eru", 9);
    freq.put("erv", 17);
    freq.put("erp", 22);
    freq.put("erq", 4);
    freq.put("err", 77);
    freq.put("ih", 108);
    freq.put("erz", 51);
    freq.put("erd", 33);
    freq.put("ere", 99);
    freq.put("erf", 18);
    freq.put("erg", 21);
    freq.put("tna", 7);
    freq.put("era", 88);
    freq.put("erb", 52);
    freq.put("erl", 14);
    freq.put("erm", 35);
    freq.put("ern", 41);
    freq.put("ero", 20);
    freq.put("erh", 7);
    freq.put("eri", 305);
    freq.put("erj", 12);
    freq.put("erk", 42);
    freq.put("Aba", 5);
    freq.put("Nat", 10);
    freq.put("uas", 8);
    freq.put("uar", 134);
    freq.put("la ", 194);
    freq.put("uat", 5);
    freq.put("uaj", 57);
    freq.put("uam", 7);
    freq.put("ual", 9);
    freq.put("uan", 26);
    freq.put("uaa", 3);
    freq.put("uad", 5);
    freq.put("ki ", 88);
    freq.put("mpl", 7);
    freq.put("lal", 9);
    freq.put("lam", 60);
    freq.put("lan", 81);
    freq.put("lah", 55);
    freq.put("lai", 3);
    freq.put("laj", 49);
    freq.put("lak", 34);
    freq.put("lad", 7);
    freq.put("lag", 15);
    freq.put("laa", 12);
    freq.put("lab", 4);
    freq.put("lay", 7);
    freq.put("laz", 12);
    freq.put("lat", 26);
    freq.put("lau", 8);
    freq.put("lav", 5);
    freq.put("law", 3);
    freq.put("lap", 4);
    freq.put("laq", 4);
    freq.put("lar", 55);
    freq.put("las", 44);
    freq.put("laB", 3);
    freq.put("çës", 4);
    freq.put("laR", 3);
    freq.put("erë", 34);
    freq.put("zef", 3);
    freq.put("zen", 13);
    freq.put("zem", 49);
    freq.put("zer", 12);
    freq.put("zes", 8);
    freq.put("zeq", 4);
    freq.put("zet", 17);
    freq.put("lqi", 3);
    freq.put("ze ", 20);
    freq.put("pje", 23);
    freq.put("aFe", 3);
    freq.put("pja", 10);
    freq.put("ntë", 6);
    freq.put("pju", 12);
    freq.put("l", 4487);
    freq.put("nt ", 56);
    freq.put("Oj ", 3);
    freq.put("qja", 8);
    freq.put("nts", 7);
    freq.put("ntr", 14);
    freq.put("ntu", 12);
    freq.put("ntw", 3);
    freq.put("nti", 65);
    freq.put("nto", 19);
    freq.put("nta", 33);
    freq.put("nte", 98);
    freq.put("dAl", 3);
    freq.put("ntT", 8);
    freq.put("ntD", 3);
    freq.put(" l ", 7);
    freq.put("alë", 8);
    freq.put("Se ", 11);
    freq.put("kt ", 35);
    freq.put(" le", 97);
    freq.put("B", 442);
    freq.put(" la", 126);
    freq.put(" lo", 102);
    freq.put(" ll", 24);
    freq.put(" li", 127);
    freq.put(" lh", 3);
    freq.put(" lu", 73);
    freq.put(" ls", 3);
    freq.put(" lp", 4);
    freq.put("Që", 3);
    freq.put(" ly", 11);
    freq.put("Set", 3);
    freq.put("kty", 3);
    freq.put("Sep", 5);
    freq.put("ktu", 22);
    freq.put("ktv", 3);
    freq.put("kto", 31);
    freq.put("kth", 33);
    freq.put("kti", 33);
    freq.put("kte", 13);
    freq.put("Sel", 7);
    freq.put("kta", 22);
    freq.put("Q ", 36);
    freq.put("ter", 180);
    freq.put("tev", 10);
    freq.put("ypi", 3);
    freq.put("Qu", 9);
    freq.put("Qy", 20);
    freq.put(" lë", 8);
    freq.put("Qa", 11);
    freq.put("Qe", 52);
    freq.put("Qf", 10);
    freq.put("Qi", 8);
    freq.put("Qh", 3);
    freq.put("Qk", 6);
    freq.put("Qm", 3);
    freq.put("Ql", 6);
    freq.put("Qo", 3);
    freq.put("Qn", 4);
    freq.put("yp ", 8);
    freq.put("ude", 5);
    freq.put("d ", 228);
    freq.put("em ", 163);
    freq.put("hri", 6);
    freq.put("hre", 5);
    freq.put("dn", 5);
    freq.put("do", 518);
    freq.put("dl", 6);
    freq.put("dm", 36);
    freq.put("dj", 92);
    freq.put("dk", 6);
    freq.put("dh", 804);
    freq.put("di", 677);
    freq.put("df", 5);
    freq.put("dg", 10);
    freq.put("dd", 28);
    freq.put("de", 508);
    freq.put("db", 3);
    freq.put("dc", 4);
    freq.put("da", 337);
    freq.put("dy", 80);
    freq.put("dv", 7);
    freq.put("dw", 5);
    freq.put("dt", 5);
    freq.put("du", 238);
    freq.put("dr", 231);
    freq.put("ds", 21);
    freq.put("dp", 5);
    freq.put("eme", 68);
    freq.put("dO", 5);
    freq.put("dL", 5);
    freq.put("dM", 3);
    freq.put("ema", 49);
    freq.put("CK ", 3);
    freq.put("emb", 19);
    freq.put("dF", 8);
    freq.put("emo", 11);
    freq.put("dE", 3);
    freq.put("emi", 107);
    freq.put("ilë", 5);
    freq.put("emk", 3);
    freq.put("dA", 9);
    freq.put("emu", 3);
    freq.put("emt", 19);
    freq.put("emp", 4);
    freq.put("ems", 5);
    freq.put("dY", 4);
    freq.put("dV", 3);
    freq.put("dP", 6);
    freq.put("qën", 6);
    freq.put("w ", 53);
    freq.put(" I ", 43);
    freq.put("qër", 4);
    freq.put("il ", 13);
    freq.put("xD ", 5);
    freq.put("co ", 816);
    freq.put("wf", 3);
    freq.put("we", 41);
    freq.put("wd", 5);
    freq.put("dë", 63);
    freq.put("wa", 18);
    freq.put("wo", 11);
    freq.put("wn", 5);
    freq.put(" Ir", 4);
    freq.put(" Is", 21);
    freq.put(" It", 7);
    freq.put("wi", 43);
    freq.put("wh", 5);
    freq.put("ww", 21);
    freq.put("wu", 3);
    freq.put("wt", 4);
    freq.put(" Il", 8);
    freq.put(" Im", 8);
    freq.put(" In", 27);
    freq.put("wp", 3);
    freq.put(" Ib", 7);
    freq.put(" Id", 6);
    freq.put("wy", 4);
    freq.put("wx", 4);
    freq.put("wG", 5);
    freq.put("cop", 3);
    freq.put("ild", 3);
    freq.put("ile", 37);
    freq.put("ila", 66);
    freq.put("ilo", 11);
    freq.put("ill", 72);
    freq.put("ilm", 12);
    freq.put("ilj", 15);
    freq.put("wJ", 3);
    freq.put("emë", 10);
    freq.put("ili", 59);
    freq.put("wU", 3);
    freq.put("ils", 4);
    freq.put("wQ", 4);
    freq.put("com", 11);
    freq.put("col", 6);
    freq.put("con", 5);
    freq.put("─", 9);
    freq.put("gn ", 9);
    freq.put("ai ", 23);
    freq.put("aiz", 3);
    freq.put("ait", 6);
    freq.put("ais", 5);
    freq.put("air", 4);
    freq.put("aim", 8);
    freq.put("ail", 7);
    freq.put("ET ", 16);
    freq.put("ain", 7);
    freq.put("thë", 17);
    freq.put("epë", 3);
    freq.put("gne", 6);
    freq.put("aid", 6);
    freq.put("ni ", 474);
    freq.put("ep ", 8);
    freq.put("th ", 62);
    freq.put("nij", 9);
    freq.put("nik", 36);
    freq.put("nih", 17);
    freq.put("nii", 9);
    freq.put("nin", 66);
    freq.put("nio", 4);
    freq.put("nil", 9);
    freq.put("nim", 44);
    freq.put("nic", 9);
    freq.put("nia", 33);
    freq.put("nif", 11);
    freq.put("nie", 19);
    freq.put("niz", 5);
    freq.put("niy", 3);
    freq.put("Y", 107);
    freq.put("nis", 89);
    freq.put("niq", 20);
    freq.put("niv", 9);
    freq.put("nit", 79);
    freq.put("niK", 3);
    freq.put("thy", 12);
    freq.put("niB", 3);
    freq.put("ept", 4);
    freq.put("epu", 3);
    freq.put("epr", 8);
    freq.put("eps", 16);
    freq.put("thq", 11);
    freq.put("tho", 87);
    freq.put("epl", 6);
    freq.put("thk", 6);
    freq.put("thj", 10);
    freq.put("thi", 36);
    freq.put("epi", 22);
    freq.put("the", 76);
    freq.put("epe", 24);
    freq.put("tha", 89);
    freq.put("epa", 7);
    freq.put("rn ", 10);
    freq.put("Gaz", 5);
    freq.put("Gat", 3);
    freq.put("Gas", 7);
    freq.put("Gal", 5);
    freq.put("Tri", 4);
    freq.put("rni", 17);
    freq.put("Tra", 15);
    freq.put("rna", 12);
    freq.put("Tre", 7);
    freq.put("rne", 11);
    freq.put("rnd", 11);
    freq.put("lca", 3);
    freq.put("Tru", 5);
    freq.put("obë", 3);
    freq.put("gM ", 3);
    freq.put("Lea", 4);
    freq.put("yka", 3);
    freq.put("😂?", 5);
    freq.put("Len", 4);
    freq.put("Leo", 8);
    freq.put("Lev", 4);
    freq.put("Lex", 3);
    freq.put("vde", 15);
    freq.put("plu", 9);
    freq.put("ple", 14);
    freq.put("aDe", 3);
    freq.put("pla", 36);
    freq.put("plo", 17);
    freq.put("pli", 13);
    freq.put("Le ", 5);
    freq.put("obl", 20);
    freq.put("obi", 5);
    freq.put("obe", 9);
    freq.put("obt", 7);
    freq.put("obu", 3);
    freq.put("obr", 3);
    freq.put("obs", 4);
    freq.put("wan", 4);
    freq.put("wal", 4);
    freq.put(" Er", 19);
    freq.put("mt ", 11);
    freq.put(" në", 255);
    freq.put("eSe", 3);
    freq.put("eSa", 3);
    freq.put("mtu", 18);
    freq.put("mth", 20);
    freq.put("mti", 10);
    freq.put("mta", 14);
    freq.put("mte", 5);
    freq.put(" n ", 136);
    freq.put("VS ", 4);
    freq.put(" ni", 199);
    freq.put("Mje", 4);
    freq.put(" nk", 23);
    freq.put(" nj", 280);
    freq.put(" nm", 17);
    freq.put(" nl", 4);
    freq.put(" no", 66);
    freq.put(" nn", 3);
    freq.put(" na", 194);
    freq.put(" nc", 15);
    freq.put(" nb", 9);
    freq.put(" ne", 349);
    freq.put(" nd", 193);
    freq.put(" ng", 190);
    freq.put(" nf", 31);
    freq.put(" nx", 21);
    freq.put(" nz", 4);
    freq.put(" nq", 9);
    freq.put(" np", 8);
    freq.put(" ns", 25);
    freq.put(" nr", 8);
    freq.put(" nu", 180);
    freq.put(" nt", 21);
    freq.put(" nv", 13);
    freq.put("Sk", 19);
    freq.put(" nK", 3);
    freq.put(" nR", 3);
    freq.put("htë", 79);
    freq.put("gu ", 24);
    freq.put("yve", 7);
    freq.put("jvo", 3);
    freq.put("jve", 6);
    freq.put("umm", 10);
    freq.put("Zhi", 4);
    freq.put("umo", 4);
    freq.put("gua", 5);
    freq.put("EO ", 30);
    freq.put("ekë", 3);
    freq.put("yin", 3);
    freq.put("gun", 5);
    freq.put("gul", 7);
    freq.put("gus", 9);
    freq.put("p", 4721);
    freq.put("gut", 11);
    freq.put("gux", 3);
    freq.put("hte", 145);
    freq.put("hta", 61);
    freq.put("hto", 36);
    freq.put("htj", 11);
    freq.put("hti", 91);
    freq.put("OK ", 3);
    freq.put("htu", 82);
    freq.put("htt", 819);
    freq.put("htr", 25);
    freq.put("Pë", 12);
    freq.put("IN ", 12);
    freq.put("kë ", 12);
    freq.put("hty", 13);
    freq.put("ek ", 46);
    freq.put("ekN", 3);
    freq.put("ht ", 203);
    freq.put("kët", 18);
    freq.put("këp", 3);
    freq.put("kës", 9);
    freq.put("kër", 20);
    freq.put("këm", 3);
    freq.put("kël", 3);
    freq.put("kën", 17);
    freq.put("fëm", 8);
    freq.put("eko", 20);
    freq.put("ekn", 9);
    freq.put("ekl", 8);
    freq.put("ekj", 14);
    freq.put("eki", 25);
    freq.put("ekh", 3);
    freq.put("ekf", 4);
    freq.put("eke", 8);
    freq.put("eka", 22);
    freq.put(" ip", 3);
    freq.put("ekz", 3);
    freq.put("eky", 5);
    freq.put("PC ", 3);
    freq.put("ekt", 32);
    freq.put("eks", 36);
    freq.put("nBe", 4);
    freq.put("uzi", 19);
    freq.put("uze", 4);
    freq.put("uzu", 3);
    freq.put(" Kc", 3);
    freq.put(" Ka", 61);
    freq.put(" Kf", 3);
    freq.put("Vll", 7);
    freq.put("Vlo", 3);
    freq.put(" Ke", 26);
    freq.put(" Kj", 6);
    freq.put(" Kh", 7);
    freq.put(" Ki", 21);
    freq.put("Vle", 5);
    freq.put(" Ko", 157);
    freq.put(" Kl", 11);
    freq.put(" Kr", 44);
    freq.put(" Kt", 3);
    freq.put(" Ku", 87);
    freq.put(" il", 8);
    freq.put(" Ky", 6);
    freq.put("Mon", 5);
    freq.put("F", 368);
    freq.put("uz ", 4);
    freq.put("fb ", 14);
    freq.put("fër", 4);
    freq.put(" K ", 16);
    freq.put("iba", 6);
    freq.put("ibe", 9);
    freq.put("cat", 3);
    freq.put("caj", 6);
    freq.put("can", 4);
    freq.put("cam", 3);
    freq.put("cal", 7);
    freq.put("ibr", 13);
    freq.put("AK ", 6);
    freq.put("ao ", 6);
    freq.put("spi", 8);
    freq.put("spo", 75);
    freq.put("spa", 8);
    freq.put("spe", 20);
    freq.put(" Kë", 6);
    freq.put("gh ", 3);
    freq.put("??", 5);
    freq.put("aoo", 3);
    freq.put("aos", 3);
    freq.put("aor", 5);
    freq.put("ght", 7);
    freq.put("KO ", 3);
    freq.put("mdr", 3);
    freq.put("ghe", 3);
    freq.put("ER ", 10);
    freq.put("gha", 10);
    freq.put("gho", 3);
    freq.put("ghi", 5);
    freq.put("Rt", 4);
    freq.put("Ru", 11);
    freq.put("Rq", 3);
    freq.put("Rr", 21);
    freq.put("Rs", 4);
    freq.put("eç", 12);
    freq.put("no ", 29);
    freq.put("Jas", 10);
    freq.put("Jan", 6);
    freq.put("Re", 63);
    freq.put("Rg", 4);
    freq.put("Ra", 45);
    freq.put("Jah", 3);
    freq.put("Rc", 3);
    freq.put("Ro", 35);
    freq.put("Rh", 4);
    freq.put("Ri", 35);
    freq.put("sod", 12);
    freq.put("soh", 9);
    freq.put("nol", 3);
    freq.put("nom", 11);
    freq.put("non", 39);
    freq.put("soj", 36);
    freq.put("noh", 6);
    freq.put("noj", 15);
    freq.put("nog", 3);
    freq.put("tjo", 4);
    freq.put("mba", 41);
    freq.put("R ", 72);
    freq.put("not", 10);
    freq.put("nou", 3);
    freq.put("nov", 16);
    freq.put("now", 5);
    freq.put("Ja ", 12);
    freq.put("nos", 10);
    freq.put("sos", 11);
    freq.put("mby", 5);
    freq.put("em", 554);
    freq.put("el", 401);
    freq.put("eo", 55);
    freq.put("en", 1403);
    freq.put("ei", 23);
    freq.put("eh", 173);
    freq.put("ek", 267);
    freq.put("ej", 492);
    freq.put("ee", 258);
    freq.put("ed", 465);
    freq.put("eg", 128);
    freq.put("ef", 87);
    freq.put("ea", 109);
    freq.put("ec", 93);
    freq.put("eb", 60);
    freq.put("ey", 37);
    freq.put("ex", 46);
    freq.put("ez", 119);
    freq.put("eu", 44);
    freq.put("et", 1494);
    freq.put("ew", 16);
    freq.put("ev", 147);
    freq.put("eq", 214);
    freq.put("ep", 112);
    freq.put("es", 1182);
    freq.put("er", 1766);
    freq.put("eM", 5);
    freq.put("eL", 8);
    freq.put("eO", 4);
    freq.put("eN", 3);
    freq.put("eH", 4);
    freq.put("eK", 3);
    freq.put("eJ", 7);
    freq.put("eE", 3);
    freq.put("eD", 3);
    freq.put("eG", 6);
    freq.put("eA", 9);
    freq.put("eC", 6);
    freq.put("eB", 8);
    freq.put("eT", 9);
    freq.put("eQ", 3);
    freq.put("eP", 6);
    freq.put("eS", 10);
    freq.put("iMa", 14);
    freq.put("rli", 15);
    freq.put("rle", 6);
    freq.put("rla", 12);
    freq.put("lmu", 4);
    freq.put("lmi", 13);
    freq.put("lmo", 5);
    freq.put("lma", 13);
    freq.put("lme", 8);
    freq.put("rlr", 4);
    freq.put("xj", 6);
    freq.put("xk", 4);
    freq.put("zal", 3);
    freq.put("zam", 5);
    freq.put("xn", 4);
    freq.put("zak", 10);
    freq.put("xl", 5);
    freq.put("zai", 3);
    freq.put("xb", 3);
    freq.put("xa", 6);
    freq.put("zab", 4);
    freq.put("xg", 4);
    freq.put("xd", 3);
    freq.put("xe", 10);
    freq.put("xx", 6);
    freq.put("xy", 3);
    freq.put("zav", 5);
    freq.put("zat", 13);
    freq.put("zar", 7);
    freq.put("zas", 8);
    freq.put("xt", 6);
    freq.put("xu", 17);
    freq.put("xI", 4);
    freq.put("xO", 3);
    freq.put("zaH", 5);
    freq.put("xM", 3);
    freq.put("xA", 3);
    freq.put("xF", 3);
    freq.put("xD", 10);
    freq.put("xY", 4);
    freq.put("xR", 4);
    freq.put("xP", 6);
    freq.put("xT", 5);
    freq.put("x ", 41);
    freq.put("za ", 35);
    freq.put("pni", 9);
    freq.put("mrë", 4);
    freq.put("xë", 3);
    freq.put("Pe", 63);
    freq.put("Pho", 3);
    freq.put("egj", 19);
    freq.put("usu", 7);
    freq.put("mr ", 10);
    freq.put("Off", 8);
    freq.put("uss", 5);
    freq.put("mrr", 4);
    freq.put("mri", 24);
    freq.put("mre", 25);
    freq.put("mra", 38);
    freq.put(" p ", 51);
    freq.put("ytë", 3);
    freq.put("jtë", 12);
    freq.put(" ps", 63);
    freq.put(" pr", 261);
    freq.put(" pv", 3);
    freq.put(" pu", 90);
    freq.put(" pt", 6);
    freq.put(" py", 13);
    freq.put(" pa", 512);
    freq.put(" pf", 3);
    freq.put(" pe", 499);
    freq.put(" pj", 24);
    freq.put(" pi", 85);
    freq.put(" ph", 11);
    freq.put(" po", 548);
    freq.put("ëzo", 7);
    freq.put(" pl", 63);
    freq.put("azn", 4);
    freq.put("Kr ", 4);
    freq.put("yty", 6);
    freq.put("jtu", 17);
    freq.put("jtt", 8);
    freq.put("jtv", 9);
    freq.put("jto", 13);
    freq.put("jti", 18);
    freq.put("jtj", 13);
    freq.put("jte", 18);
    freq.put("yte", 31);
    freq.put("jta", 22);
    freq.put("yta", 4);
    freq.put("Kry", 11);
    freq.put("Kro", 3);
    freq.put(" pë", 173);
    freq.put("Kra", 18);
    freq.put("azr", 3);
    freq.put("Kre", 20);
    freq.put("vua", 6);
    freq.put("vul", 3);
    freq.put("vra", 17);
    freq.put("jt ", 234);
    freq.put("yt ", 22);
    freq.put("Sir", 8);
    freq.put("hve", 4);
    freq.put("mbë", 21);
    freq.put(" Më", 5);
    freq.put("ei ", 7);
    freq.put("tlu", 6);
    freq.put("PE ", 3);
    freq.put("eil", 3);
    freq.put("yj", 17);
    freq.put("kha", 10);
    freq.put("uxo", 3);
    freq.put("uxh", 4);
    freq.put("ceb", 13);
    freq.put(" Me", 103);
    freq.put(" Ma", 120);
    freq.put(" Mb", 10);
    freq.put(" Ml", 3);
    freq.put(" Mo", 37);
    freq.put(" Mi", 90);
    freq.put(" Mj", 6);
    freq.put("khe", 6);
    freq.put(" Mu", 39);
    freq.put("Sim", 3);
    freq.put(" Mr", 4);
    freq.put(" Ms", 5);
    freq.put(" My", 3);
    freq.put("yb", 10);
    freq.put("tli", 10);
    freq.put(" M ", 14);
    freq.put("tlo", 4);
    freq.put("cco", 3);
    freq.put("yz", 7);
    freq.put("cce", 4);
    freq.put("tll", 5);
    freq.put("am ", 146);
    freq.put("ps ", 14);
    freq.put("asë", 8);
    freq.put("ch", 105);
    freq.put("Her", 3);
    freq.put("yv", 8);
    freq.put("gj ", 8);
    freq.put("ami", 92);
    freq.put("psh", 16);
    freq.put("psi", 6);
    freq.put("amm", 6);
    freq.put("amo", 42);
    freq.put("ama", 84);
    freq.put("amb", 14);
    freq.put("ame", 51);
    freq.put("pse", 60);
    freq.put("amp", 18);
    freq.put("amu", 25);
    freq.put("amt", 4);
    freq.put("ceA", 3);
    freq.put("gjy", 24);
    freq.put("gju", 47);
    freq.put("gjo", 28);
    freq.put("t", 12302);
    freq.put("gji", 162);
    freq.put("gjd", 3);
    freq.put("gje", 136);
    freq.put("gja", 47);
    freq.put("ëh", 6);
    freq.put("td ", 4);
    freq.put("yna", 5);
    freq.put("rwN", 6);
    freq.put("Hen", 3);
    freq.put("ife", 10);
    freq.put("uck", 17);
    freq.put("uci", 9);
    freq.put("uch", 3);
    freq.put("Ras", 8);
    freq.put("eLi", 3);
    freq.put("tdo", 5);
    freq.put("nme", 9);
    freq.put("nma", 10);
    freq.put("tdu", 5);
    freq.put("srb", 3);
    freq.put("sra", 3);
    freq.put("gjë", 8);
    freq.put("Gez", 5);
    freq.put("Adr", 3);
    freq.put("Add", 3);
    freq.put("Ade", 6);
    freq.put("Adm", 5);
    freq.put("loc", 3);
    freq.put("loa", 4);
    freq.put("lof", 3);
    freq.put("log", 22);
    freq.put("lod", 14);
    freq.put("loj", 50);
    freq.put("lok", 30);
    freq.put("loh", 12);
    freq.put("loi", 10);
    freq.put("lon", 61);
    freq.put("loo", 8);
    freq.put("lol", 7);
    freq.put("lor", 22);
    freq.put("los", 8);
    freq.put("lop", 11);
    freq.put("loq", 12);
    freq.put("lov", 18);
    freq.put("low", 10);
    freq.put("lot", 30);
    freq.put("loz", 4);
    freq.put("J", 259);
    freq.put("rje", 39);
    freq.put("rja", 27);
    freq.put("lo ", 15);
    freq.put("Gen", 25);
    freq.put("izS", 5);
    freq.put("Mua", 5);
    freq.put(" sc", 3);
    freq.put(" he", 107);
    freq.put("Esh", 3);
    freq.put("Lam", 8);
    freq.put("Lan", 3);
    freq.put("Mun", 7);
    freq.put("Laj", 49);
    freq.put("Muh", 7);
    freq.put("Lat", 5);
    freq.put("Lau", 5);
    freq.put("Lav", 3);
    freq.put("Lar", 5);
    freq.put("c ", 102);
    freq.put("aH ", 6);
    freq.put("Bru", 3);
    freq.put("IK ", 3);
    freq.put("Bri", 5);
    freq.put("Bra", 5);
    freq.put("bë ", 5);
    freq.put("mp ", 4);
    freq.put("mpe", 10);
    freq.put("mpa", 4);
    freq.put("bël", 3);
    freq.put("bën", 8);
    freq.put("mpj", 9);
    freq.put("bëj", 8);
    freq.put("mpi", 13);
    freq.put("bët", 11);
    freq.put("mpu", 4);
    freq.put("bër", 7);
    freq.put("bës", 6);
    freq.put(" rë", 9);
    freq.put("ass", 12);
    freq.put("asq", 4);
    freq.put(" r ", 13);
    freq.put(" ru", 15);
    freq.put(" rt", 4);
    freq.put(" rw", 6);
    freq.put(" rr", 126);
    freq.put(" re", 108);
    freq.put(" ra", 69);
    freq.put(" ro", 34);
    freq.put("kzi", 5);
    freq.put(" ri", 65);
    freq.put(" rk", 7);
    freq.put("ojt", 18);
    freq.put("rRe", 4);
    freq.put("jra", 16);
    freq.put("jri", 5);
    freq.put("ask", 35);
    freq.put("jru", 3);
    freq.put(" Fr", 11);
    freq.put("S ", 86);
    freq.put("aso", 13);
    freq.put("asn", 38);
    freq.put("asm", 8);
    freq.put("Sy", 9);
    freq.put("jr ", 4);
    freq.put("Sp", 29);
    freq.put("Sw", 3);
    freq.put("Su", 19);
    freq.put("St", 19);
    freq.put("FC ", 5);
    freq.put("Sj", 3);
    freq.put("Si", 42);
    freq.put("Sh", 298);
    freq.put("So", 41);
    freq.put("Sn", 4);
    freq.put("Sm", 6);
    freq.put("Sl", 4);
    freq.put("Sa", 86);
    freq.put("fë", 12);
    freq.put("Sf", 4);
    freq.put("Se", 63);
    freq.put("Sd", 5);
    freq.put("EK ", 3);
    freq.put("egë", 5);
    freq.put("RE ", 4);
    freq.put("f ", 79);
    freq.put("hha", 76);
    freq.put("hhe", 5);
    freq.put("hhh", 45);
    freq.put("ob ", 7);
    freq.put("eg ", 5);
    freq.put("fp", 4);
    freq.put("fq", 7);
    freq.put("fr", 46);
    freq.put("fs", 46);
    freq.put("ft", 106);
    freq.put("fu", 122);
    freq.put("fv", 3);
    freq.put("fx", 3);
    freq.put("fy", 4);
    freq.put("fa", 254);
    freq.put("fb", 20);
    freq.put("hh ", 42);
    freq.put("fd", 3);
    freq.put("fe", 154);
    freq.put("ff", 33);
    freq.put("fg", 4);
    freq.put("fh", 5);
    freq.put("fi", 238);
    freq.put("fj", 55);
    freq.put("fk", 7);
    freq.put("fl", 85);
    freq.put("fm", 12);
    freq.put("fn", 8);
    freq.put("fo", 194);
    freq.put("a", 14092);
    freq.put("egz", 15);
    freq.put("fR", 5);
    freq.put("egr", 19);
    freq.put("fZ", 3);
    freq.put("egu", 19);
    freq.put("fA", 3);
    freq.put("egi", 4);
    freq.put("fC", 3);
    freq.put("ego", 20);
    freq.put("ega", 15);
    freq.put("CA ", 4);
    freq.put("ce ", 33);
    freq.put("y ", 276);
    freq.put("ffi", 15);
    freq.put("uve", 20);
    freq.put(" On", 3);
    freq.put(" Oo", 4);
    freq.put(" Ol", 3);
    freq.put(" Oj", 4);
    freq.put(" Ok", 3);
    freq.put(" Oh", 4);
    freq.put(" Ob", 3);
    freq.put("vR", 4);
    freq.put(" Or", 7);
    freq.put(" Os", 5);
    freq.put(" Op", 5);
    freq.put("yi", 9);
    freq.put("yh", 14);
    freq.put("yk", 12);
    freq.put("ced", 3);
    freq.put("ym", 24);
    freq.put("yl", 29);
    freq.put("yo", 27);
    freq.put("yn", 41);
    freq.put("ya", 32);
    freq.put("cen", 8);
    freq.put("yc", 7);
    freq.put("cel", 23);
    freq.put("ye", 103);
    freq.put("cej", 3);
    freq.put("yf", 6);
    freq.put("yy", 14);
    freq.put("yx", 4);
    freq.put("cet", 3);
    freq.put("ces", 10);
    freq.put("cer", 21);
    freq.put("cep", 4);
    freq.put("yq", 21);
    freq.put("yp", 19);
    freq.put("ys", 156);
    freq.put("yr", 156);
    freq.put("yu", 11);
    freq.put("yt", 87);
    freq.put("ff ", 7);
    freq.put("ift", 12);
    freq.put("yH", 6);
    freq.put("yK", 3);
    freq.put("yJ", 6);
    freq.put("yM", 4);
    freq.put("yL", 4);
    freq.put("yO", 5);
    freq.put("ifs", 7);
    freq.put("MI ", 6);
    freq.put("yC", 7);
    freq.put("yB", 5);
    freq.put("yE", 5);
    freq.put("yD", 4);
    freq.put(" O ", 18);
    freq.put("yF", 4);
    freq.put("did", 9);
    freq.put("iff", 3);
    freq.put("ifa", 14);
    freq.put("yQ", 3);
    freq.put("yP", 3);
    freq.put("yS", 5);
    freq.put("ifo", 14);
    freq.put("ifi", 20);
    freq.put("yV", 3);
    freq.put("dig", 5);
    freq.put("End", 6);
    freq.put("Eng", 3);
    freq.put("Eni", 5);
    freq.put("as ", 169);
    freq.put("ëjm", 4);
    freq.put("pul", 13);
    freq.put("pun", 58);
    freq.put("asp", 8);
    freq.put("asu", 4);
    freq.put("ast", 79);
    freq.put("asy", 4);
    freq.put("pub", 13);
    freq.put("asa", 39);
    freq.put("ase", 20);
    freq.put("asd", 5);
    freq.put("put", 8);
    freq.put("asj", 5);
    freq.put("asi", 42);
    freq.put("ash", 459);
    freq.put("pup", 4);
    freq.put("puq", 4);
    freq.put("pur", 4);
    freq.put("pus", 18);
    freq.put(" F ", 7);
    freq.put("Ime", 6);
    freq.put("Cli", 3);
    freq.put("Cla", 3);
    freq.put("nc ", 10);
    freq.put("st ", 40);
    freq.put("Sad", 7);
    freq.put("tfo", 9);
    freq.put("tfa", 3);
    freq.put("nch", 15);
    freq.put("nci", 15);
    freq.put("ncn", 13);
    freq.put("nco", 5);
    freq.put("tfu", 3);
    freq.put("nca", 13);
    freq.put("nce", 16);
    freq.put("ste", 54);
    freq.put("sta", 68);
    freq.put("sto", 36);
    freq.put("sti", 68);
    freq.put("stu", 16);
    freq.put("stp", 3);
    freq.put("str", 64);
    freq.put("sty", 9);
    freq.put("Gol", 5);
    freq.put("Goo", 4);
    freq.put("ka ", 527);
    freq.put("liM", 13);
    freq.put("Ajo", 10);
    freq.put("lid", 45);
    freq.put("Nik", 3);
    freq.put("lif", 5);
    freq.put("lig", 17);
    freq.put("lia", 21);
    freq.put("lib", 15);
    freq.put("lic", 26);
    freq.put("lil", 8);
    freq.put("Nic", 3);
    freq.put("lin", 107);
    freq.put("lio", 15);
    freq.put("lih", 4);
    freq.put("lii", 3);
    freq.put("lik", 40);
    freq.put("lit", 67);
    freq.put("liu", 16);
    freq.put("liv", 17);
    freq.put("lip", 9);
    freq.put("liq", 6);
    freq.put("lir", 46);
    freq.put("lis", 48);
    freq.put("Nis", 3);
    freq.put("Nit", 13);
    freq.put("rhy", 4);
    freq.put("iAl", 3);
    freq.put("kaa", 9);
    freq.put("kaf", 12);
    freq.put("kad", 9);
    freq.put("kak", 12);
    freq.put("kaj", 29);
    freq.put("Thu", 4);
    freq.put("kah", 4);
    freq.put("kao", 3);
    freq.put("kan", 154);
    freq.put("kam", 57);
    freq.put("kal", 77);
    freq.put("kas", 11);
    freq.put("kar", 37);
    freq.put("kaq", 8);
    freq.put("kap", 20);
    freq.put("kav", 5);
    freq.put("Thi", 8);
    freq.put("kat", 64);
    freq.put("Aj ", 4);
    freq.put("kaz", 3);
    freq.put("kay", 6);
    freq.put("rhe", 4);
    freq.put("Tha", 23);
    freq.put("kaC", 4);
    freq.put("li ", 144);
    freq.put("Ni ", 3);
    freq.put("stë", 11);
    freq.put("kaR", 3);
    freq.put("aNe", 3);
    freq.put("yma", 7);
    freq.put("yme", 6);
    freq.put("ox ", 3);
    freq.put("ym ", 4);
    freq.put("oxh", 15);
    freq.put("x", 365);
    freq.put("zë ", 4);
    freq.put("vY", 4);
    freq.put("wor", 3);
    freq.put("Plo", 3);
    freq.put("Pli", 3);
    freq.put("JU ", 5);
    freq.put("wo ", 4);
    freq.put("▀▀", 28);
    freq.put("Wal", 3);
    freq.put(" t ", 1008);
    freq.put(" ty", 60);
    freq.put(" tw", 33);
    freq.put(" tv", 15);
    freq.put(" tu", 135);
    freq.put(" tt", 5);
    freq.put(" ts", 13);
    freq.put(" tr", 90);
    freq.put(" tq", 4);
    freq.put("N", 405);
    freq.put(" to", 63);
    freq.put(" tn", 13);
    freq.put(" tm", 41);
    freq.put(" tl", 4);
    freq.put(" tk", 41);
    freq.put(" tj", 96);
    freq.put(" ti", 214);
    freq.put(" th", 259);
    freq.put(" tg", 4);
    freq.put(" tf", 14);
    freq.put(" te", 509);
    freq.put(" td", 19);
    freq.put(" tb", 4);
    freq.put(" ta", 210);
    freq.put("iya", 3);
    freq.put(" tP", 3);
    freq.put("jpg", 3);
    freq.put("lie", 8);
    freq.put(" të", 298);
    freq.put("FA ", 4);
    freq.put("lim", 58);
    freq.put("vyn", 8);
    freq.put("▄▄", 3);
    freq.put("hje", 97);
    freq.put("hja", 21);
    freq.put(" Që", 3);
    freq.put("ee ", 65);
    freq.put("PI ", 6);
    freq.put("tut", 13);
    freq.put("eet", 27);
    freq.put("ees", 4);
    freq.put("eer", 6);
    freq.put("eem", 9);
    freq.put("tuu", 4);
    freq.put("een", 12);
    freq.put("liz", 21);
    freq.put("eej", 3);
    freq.put("eee", 105);
    freq.put("ru ", 30);
    freq.put(" Qu", 5);
    freq.put(" Qy", 19);
    freq.put(" Qa", 7);
    freq.put(" Qe", 46);
    freq.put(" Qf", 7);
    freq.put(" Qi", 5);
    freq.put(" Qk", 5);
    freq.put("id ", 12);
    freq.put(" Qo", 3);
    freq.put("ruj", 20);
    freq.put("ruk", 5);
    freq.put("ruh", 6);
    freq.put("run", 13);
    freq.put("rul", 3);
    freq.put("rum", 14);
    freq.put("rua", 32);
    freq.put("rug", 14);
    freq.put("rud", 5);
    freq.put("rue", 11);
    freq.put("rur", 10);
    freq.put("rus", 21);
    freq.put("rup", 9);
    freq.put("Tho", 3);
    freq.put(" Q ", 9);
    freq.put("ido", 14);
    freq.put("ncë", 11);
    freq.put("idh", 49);
    freq.put("idi", 16);
    freq.put("ide", 62);
    freq.put("ida", 15);
    freq.put("Eli", 20);
    freq.put("Elo", 4);
    freq.put("Elm", 3);
    freq.put("rha", 7);
    freq.put("Të", 14);
    freq.put("The", 13);
    freq.put("ut ", 53);
    freq.put("kus", 80);
    freq.put("aqu", 9);
    freq.put("tul", 8);
    freq.put("aqs", 3);
    freq.put("El ", 4);
    freq.put("aqe", 47);
    freq.put("aqa", 5);
    freq.put("aqi", 23);
    freq.put("aqj", 4);
    freq.put("utb", 22);
    freq.put("tum", 14);
    freq.put("uta", 21);
    freq.put("ute", 26);
    freq.put("utj", 6);
    freq.put("uth", 7);
    freq.put("uti", 11);
    freq.put("utn", 5);
    freq.put("uto", 9);
    freq.put("utr", 6);
    freq.put("utt", 4);
    freq.put("utu", 15);
    freq.put("KU ", 4);
    freq.put("naB", 4);
    freq.put("naA", 5);
    freq.put("Tz", 5);
    freq.put("naG", 5);
    freq.put("naD", 5);
    freq.put("Bek", 4);
    freq.put("Tw", 11);
    freq.put("naH", 5);
    freq.put("Tu", 27);
    freq.put("Tr", 35);
    freq.put("Beh", 6);
    freq.put("naM", 5);
    freq.put("naS", 10);
    freq.put("Tj", 7);
    freq.put("naT", 3);
    freq.put("Ti", 77);
    freq.put("naX", 9);
    freq.put("Te", 62);
    freq.put("Ta", 41);
    freq.put("nab", 3);
    freq.put("nac", 3);
    freq.put("naa", 17);
    freq.put("naf", 3);
    freq.put("nag", 4);
    freq.put("nad", 4);
    freq.put("naj", 50);
    freq.put("nak", 10);
    freq.put("nah", 7);
    freq.put("nan", 20);
    freq.put("nal", 61);
    freq.put("nam", 15);
    freq.put("nar", 15);
    freq.put("nas", 26);
    freq.put("nap", 9);
    freq.put("naq", 24);
    freq.put("nav", 14);
    freq.put("nat", 52);
    freq.put("naz", 10);
    freq.put("T ", 470);
    freq.put("Aa", 5);
    freq.put("Ac", 7);
    freq.put("Ab", 17);
    freq.put("e", 17006);
    freq.put("Ad", 20);
    freq.put("Ag", 18);
    freq.put("Af", 14);
    freq.put("Ai", 23);
    freq.put("Ah", 15);
    freq.put("Ak", 8);
    freq.put("Aj", 25);
    freq.put("Am", 23);
    freq.put("Al", 154);
    freq.put("An", 36);
    freq.put("Aq", 6);
    freq.put("Ap", 10);
    freq.put("As", 15);
    freq.put("Ar", 94);
    freq.put("Au", 7);
    freq.put("At", 13);
    freq.put("Av", 7);
    freq.put("Ay", 3);
    freq.put("Az", 17);
    freq.put("gv", 3);
    freq.put("gu", 100);
    freq.put("gt", 13);
    freq.put("gs", 6);
    freq.put("gr", 111);
    freq.put("zë", 13);
    freq.put("gz", 34);
    freq.put("gy", 5);
    freq.put("gg", 8);
    freq.put("gf", 7);
    freq.put("ge", 108);
    freq.put("gd", 3);
    freq.put("gc", 3);
    freq.put("gb", 6);
    freq.put("ga", 308);
    freq.put("go", 139);
    freq.put("gn", 17);
    freq.put("gl", 27);
    freq.put("gk", 3);
    freq.put("gj", 471);
    freq.put("gi", 37);
    freq.put("gh", 36);
    freq.put("gV", 3);
    freq.put("gT", 4);
    freq.put("Tje", 3);
    freq.put("gQ", 5);
    freq.put("tma", 11);
    freq.put("lke", 6);
    freq.put("lka", 10);
    freq.put("gF", 3);
    freq.put("gD", 7);
    freq.put("gC", 3);
    freq.put("gB", 3);
    freq.put("gA", 4);
    freq.put("tmd", 8);
    freq.put("gM", 4);
    freq.put("lku", 3);
    freq.put("Nor", 8);
    freq.put("tme", 6);
    freq.put("rtn", 4);
    freq.put("g ", 130);
    freq.put("tmj", 3);
    freq.put("hi ", 126);
    freq.put("Spo", 17);
    freq.put("Spa", 3);
    freq.put("Spe", 5);
    freq.put("zl", 16);
    freq.put("zm", 14);
    freq.put("zn", 17);
    freq.put("zo", 108);
    freq.put("zh", 64);
    freq.put("zi", 185);
    freq.put("zj", 8);
    freq.put("zk", 3);
    freq.put("zd", 9);
    freq.put("ze", 137);
    freq.put("zf", 3);
    freq.put("zg", 32);
    freq.put("za", 147);
    freq.put("zb", 16);
    freq.put("zy", 13);
    freq.put("zz", 22);
    freq.put("zt", 15);
    freq.put("zu", 47);
    freq.put("zv", 14);
    freq.put("gë", 28);
    freq.put("zq", 4);
    freq.put("zr", 6);
    freq.put("zs", 3);
    freq.put("aLo", 5);
    freq.put("zN", 3);
    freq.put("zE", 3);
    freq.put("zG", 4);
    freq.put("zB", 5);
    freq.put("aLa", 7);
    freq.put("zV", 3);
    freq.put("zP", 3);
    freq.put("zS", 7);
    freq.put("oze", 11);
    freq.put("ull", 78);
    freq.put("oza", 7);
    freq.put("ozo", 3);
    freq.put("z ", 107);
    freq.put("ozh", 3);
    freq.put("ozi", 16);
    freq.put("aL ", 3);
    freq.put("Ahm", 10);
    freq.put("ies", 3);
    freq.put("win", 9);
    freq.put("Jq", 3);
    freq.put("wit", 27);
    freq.put(" vë", 11);
    freq.put("Ji", 6);
    freq.put("ien", 11);
    freq.put(" vA", 3);
    freq.put("rt ", 93);
    freq.put(" va", 76);
    freq.put(" ve", 333);
    freq.put(" vd", 16);
    freq.put(" vi", 132);
    freq.put(" vj", 60);
    freq.put(" vl", 34);
    freq.put(" vo", 42);
    freq.put(" vr", 23);
    freq.put(" vu", 12);
    freq.put(" vy", 5);
    freq.put("kro", 8);
    freq.put(" v ", 15);
    freq.put("hic", 4);
    freq.put("TO ", 22);
    freq.put(" jb", 4);
    freq.put("zme", 6);
    freq.put("jna", 8);
    freq.put("jne", 26);
    freq.put("jni", 3);
    freq.put("bin", 26);
    freq.put("RA ", 5);
    freq.put("jn ", 81);
    freq.put("ç", 74);
    freq.put("ec ", 35);
    freq.put("hlu", 3);
    freq.put("mas", 54);
    freq.put("mar", 122);
    freq.put("hli", 5);
    freq.put("jnë", 39);
    freq.put("aHa", 10);
    freq.put("mav", 3);
    freq.put("max", 9);
    freq.put("ece", 14);
    freq.put("eca", 7);
    freq.put("CE ", 6);
    freq.put("eci", 21);
    freq.put("ech", 4);
    freq.put("hl ", 5);
    freq.put("───", 5);
    freq.put("rs ", 18);
    freq.put("AN ", 5);
    freq.put(" Sy", 5);
    freq.put(" Sp", 26);
    freq.put(" St", 16);
    freq.put(" Su", 17);
    freq.put(" Sk", 16);
    freq.put(" Sh", 266);
    freq.put(" Si", 37);
    freq.put(" So", 33);
    freq.put(" Sl", 4);
    freq.put(" Sm", 6);
    freq.put(" Sa", 64);
    freq.put(" Sd", 4);
    freq.put(" Se", 50);
    freq.put("rso", 24);
    freq.put("rsh", 29);
    freq.put("rsi", 19);
    freq.put("rse", 15);
    freq.put("rsa", 8);
    freq.put("R", 685);
    freq.put("rsy", 10);
    freq.put("bej", 7);
    freq.put("beh", 17);
    freq.put("ben", 17);
    freq.put("bel", 13);
    freq.put("beg", 4);
    freq.put("bed", 4);
    freq.put("urë", 8);
    freq.put("ber", 46);
    freq.put("bes", 40);
    freq.put(" S ", 22);
    freq.put("zni", 6);
    freq.put("bet", 32);
    freq.put("ur ", 296);
    freq.put("arm", 15);
    freq.put("BA ", 9);
    freq.put("aww", 3);
    freq.put("pyt", 5);
    freq.put("pye", 4);
    freq.put("awa", 4);
    freq.put("urd", 4);
    freq.put("ure", 27);
    freq.put("urg", 18);
    freq.put("ura", 48);
    freq.put("urm", 4);
    freq.put("fja", 46);
    freq.put("uro", 54);
    freq.put("tC", 3);
    freq.put("uri", 80);
    freq.put("fje", 4);
    freq.put("urk", 9);
    freq.put("urt", 53);
    freq.put("uru", 7);
    freq.put("urv", 15);
    freq.put("urp", 5);
    freq.put("urr", 71);
    freq.put("urs", 8);
    freq.put("Ush", 4);
    freq.put("mg ", 4);
    freq.put("bul", 18);
    freq.put("nge", 34);
    freq.put("nga", 144);
    freq.put("ngl", 11);
    freq.put("ngn", 4);
    freq.put("ngo", 22);
    freq.put("ngi", 4);
    freq.put("ngj", 65);
    freq.put("Pse", 7);
    freq.put("ngt", 3);
    freq.put("ngu", 21);
    freq.put("ngr", 11);
    freq.put("tbo", 27);
    freq.put("shp", 107);
    freq.put("shq", 135);
    freq.put("dpt", 3);
    freq.put("sht", 703);
    freq.put("shu", 273);
    freq.put("shw", 4);
    freq.put("shy", 24);
    freq.put("sha", 238);
    freq.put("she", 235);
    freq.put("shf", 12);
    freq.put("shg", 4);
    freq.put("shh", 17);
    freq.put("shi", 255);
    freq.put("shj", 32);
    freq.put("shk", 300);
    freq.put("shl", 12);
    freq.put("shm", 56);
    freq.put("shn", 22);
    freq.put("sho", 126);
    freq.put("ke ", 185);
    freq.put("lup", 3);
    freq.put("lur", 3);
    freq.put("lus", 13);
    freq.put("lut", 22);
    freq.put("luz", 7);
    freq.put("lua", 34);
    freq.put("lub", 8);
    freq.put("luc", 5);
    freq.put("lue", 4);
    freq.put("luf", 11);
    freq.put("luh", 5);
    freq.put("luj", 16);
    freq.put("luk", 3);
    freq.put("lul", 7);
    freq.put("lum", 29);
    freq.put("lun", 7);
    freq.put("ken", 85);
    freq.put("kem", 33);
    freq.put("kel", 11);
    freq.put("kej", 24);
    freq.put("kef", 4);
    freq.put("ket", 80);
    freq.put("kes", 49);
    freq.put("ker", 39);
    freq.put("keq", 48);
    freq.put("ëmb", 8);
    freq.put("lu ", 14);
    freq.put("shë", 32);
    freq.put("qfa", 31);
    freq.put("keP", 3);
    freq.put("ot ", 143);
    freq.put("Lon", 5);
    freq.put("Lor", 8);
    freq.put("Lov", 4);
    freq.put("ëmi", 9);
    freq.put("Lot", 3);
    freq.put("aGj", 3);
    freq.put("cë ", 8);
    freq.put("aRa", 7);
    freq.put("yan", 9);
    freq.put("yah", 3);
    freq.put("dje", 56);
    freq.put("oth", 3);
    freq.put("oti", 51);
    freq.put("otj", 3);
    freq.put("otm", 3);
    freq.put("oto", 73);
    freq.put("ota", 24);
    freq.put("ote", 50);
    freq.put("otr", 12);
    freq.put("ots", 3);
    freq.put("ott", 6);
    freq.put("otu", 8);
    freq.put("And", 8);
    freq.put("Ang", 5);
    freq.put("cën", 7);
    freq.put("Ani", 7);
    freq.put("Ant", 3);
    freq.put("cës", 4);
    freq.put("cër", 3);
    freq.put("Any", 3);
    freq.put("You", 8);
    freq.put("zy ", 4);
    freq.put("otë", 23);
    freq.put("yrë", 4);
    freq.put("mza", 3);
    freq.put("i", 10992);
    freq.put("ksi", 34);
    freq.put("zyr", 8);
    freq.put("inU", 4);
    freq.put("She", 31);
    freq.put(" xD", 9);
    freq.put("Be", 89);
    freq.put(" xi", 3);
    freq.put(" xh", 31);
    freq.put("Ba", 92);
    freq.put("Bc", 3);
    freq.put("Bl", 27);
    freq.put("Bo", 24);
    freq.put("Bi", 22);
    freq.put("Bu", 33);
    freq.put("Br", 19);
    freq.put("Bs", 3);
    freq.put("By", 8);
    freq.put("Bz", 4);
    freq.put("NN ", 4);
    freq.put("B ", 50);
    freq.put(" x ", 12);
    freq.put("tga", 5);
    freq.put("TI ", 9);
    freq.put("jli", 8);
    freq.put("U ", 44);
    freq.put("?", 37);
    freq.put("duh", 68);
    freq.put("Uy", 3);
    freq.put("Uz", 3);
    freq.put("RO ", 3);
    freq.put("Uv", 4);
    freq.put("duj", 3);
    freq.put("Us", 5);
    freq.put("Ur", 18);
    freq.put("Um", 3);
    freq.put("Ul", 4);
    freq.put("pq", 5);
    freq.put("Ui", 3);
    freq.put("Uk", 5);
    freq.put("Ue", 5);
    freq.put("dul", 14);
    freq.put("Ug", 3);
    freq.put("LL ", 6);
    freq.put("Ua", 3);
    freq.put("Uc", 4);
    freq.put("Ub", 5);
    freq.put("ea ", 11);
    freq.put("h ", 1005);
    freq.put("dm ", 22);
    freq.put("hz", 5);
    freq.put("hy", 68);
    freq.put("eal", 28);
    freq.put("ean", 8);
    freq.put("hr", 17);
    freq.put("hs", 22);
    freq.put("hp", 127);
    freq.put("hq", 259);
    freq.put("hv", 7);
    freq.put("ead", 6);
    freq.put("eag", 4);
    freq.put("hu", 506);
    freq.put("hj", 124);
    freq.put("hk", 347);
    freq.put("hh", 182);
    freq.put("hi", 577);
    freq.put("hn", 51);
    freq.put("ho", 319);
    freq.put("hl", 26);
    freq.put("hm", 126);
    freq.put("hb", 13);
    freq.put("eas", 7);
    freq.put("ear", 5);
    freq.put("eau", 3);
    freq.put("eat", 16);
    freq.put("hd", 30);
    freq.put("he", 1520);
    freq.put("hZ", 3);
    freq.put("dus", 9);
    freq.put("hQ", 5);
    freq.put("duu", 5);
    freq.put("hK", 6);
    freq.put("hH", 6);
    freq.put("dmt", 8);
    freq.put("hO", 4);
    freq.put("hB", 3);
    freq.put("hC", 3);
    freq.put("hA", 8);
    freq.put("hE", 3);
    freq.put("hn ", 5);
    freq.put(" Ur", 16);
    freq.put(" Us", 5);
    freq.put(" Ul", 4);
    freq.put(" Un", 30);
    freq.put(" Ue", 3);
    freq.put(" Ub", 3);
    freq.put("hë", 84);
    freq.put("rqa", 5);
    freq.put(" tp", 23);
    freq.put("hna", 8);
    freq.put("hni", 21);
    freq.put("hno", 4);
    freq.put("hnt", 4);
    freq.put(" U ", 11);
    freq.put("aug", 4);
    freq.put("auh", 9);
    freq.put("aul", 3);
    freq.put("up ", 32);
    freq.put("aus", 4);
    freq.put("aur", 10);
    freq.put("aut", 8);
    freq.put("ble", 56);
    freq.put("upo", 3);
    freq.put("upl", 3);
    freq.put("upi", 17);
    freq.put("ë", 2561);
    freq.put("upe", 11);
    freq.put("upa", 7);
    freq.put("upt", 23);
    freq.put("me ", 1284);
    freq.put("neS", 3);
    freq.put("nen", 47);
    freq.put("Pun", 4);
    freq.put("nem", 17);
    freq.put("nej", 40);
    freq.put("nek", 3);
    freq.put("neg", 3);
    freq.put("nee", 5);
    freq.put("nez", 3);
    freq.put("Puy", 3);
    freq.put("ney", 6);
    freq.put("nev", 27);
    freq.put("dr ", 4);
    freq.put("net", 55);
    freq.put("ner", 25);
    freq.put("nes", 120);
    freq.put("nep", 7);
    freq.put("mee", 11);
    freq.put("med", 14);
    freq.put("meg", 8);
    freq.put("mem", 19);
    freq.put("mel", 14);
    freq.put("men", 183);
    freq.put("meh", 6);
    freq.put("mek", 4);
    freq.put("mej", 11);
    freq.put("met", 97);
    freq.put("mev", 14);
    freq.put("mes", 41);
    freq.put("mer", 107);
    freq.put("mey", 3);
    freq.put("mez", 10);
    freq.put("dry", 33);
    freq.put("drr", 12);
    freq.put("dru", 6);
    freq.put("ne ", 405);
    freq.put("sju", 4);
    freq.put("dri", 55);
    freq.put("sjo", 13);
    freq.put("dro", 25);
    freq.put("dra", 15);
    freq.put("sja", 27);
    freq.put("dre", 77);
    freq.put("sje", 31);
    freq.put("kg ", 4);
    freq.put("xh ", 5);
    freq.put("orc", 10);
    freq.put("Sta", 8);
    freq.put("qdo", 6);
    freq.put("Tir", 5);
    freq.put("Str", 3);
    freq.put("V", 274);
    freq.put("ovë", 38);
    freq.put("kgj", 3);
    freq.put("xha", 34);
    freq.put("VB ", 3);
    freq.put("xhe", 24);
    freq.put("Tim", 48);
    freq.put("xhi", 13);
    freq.put("Tin", 3);
    freq.put("xhu", 13);
    freq.put("rik", 51);
    freq.put("Lid", 6);
    freq.put("Lig", 9);
    freq.put("Lib", 3);
    freq.put("Lim", 4);
    freq.put("Lin", 16);
    freq.put("Lik", 10);
    freq.put("ov ", 3);
    freq.put("Lir", 8);
    freq.put("Lis", 7);
    freq.put("Kaf", 3);
    freq.put("Kak", 3);
    freq.put("Kan", 6);
    freq.put("Kam", 7);
    freq.put("Kal", 8);
    freq.put("Kas", 8);
    freq.put("Kar", 7);
    freq.put("Kap", 4);
    freq.put("Kat", 8);
    freq.put("nua", 15);
    freq.put("ovc", 4);
    freq.put("ova", 154);
    freq.put("ove", 55);
    freq.put("ovi", 19);
    freq.put("ovo", 12);
    freq.put("All", 31);
    freq.put("Ka ", 12);
    freq.put("Alk", 3);
    freq.put("Ali", 17);
    freq.put("Ale", 4);
    freq.put("Alb", 84);
    freq.put("mx ", 3);
    freq.put(" Z ", 5);
    freq.put("JO ", 4);
    freq.put("isë", 34);
    freq.put("tTh", 8);
    freq.put("kqi", 9);
    freq.put(" zo", 35);
    freq.put(" zi", 12);
    freq.put(" zh", 12);
    freq.put(" ze", 58);
    freq.put(" zd", 6);
    freq.put(" zg", 29);
    freq.put(" za", 28);
    freq.put(" zb", 12);
    freq.put(" zy", 9);
    freq.put(" zz", 3);
    freq.put(" zu", 4);
    freq.put("is ", 62);
    freq.put("TK ", 4);
    freq.put("aRe", 4);
    freq.put("iss", 18);
    freq.put("isp", 9);
    freq.put(" z ", 6);
    freq.put("isu", 4);
    freq.put("ist", 77);
    freq.put("isj", 4);
    freq.put("isi", 41);
    freq.put("ish", 370);
    freq.put("iso", 7);
    freq.put("isn", 7);
    freq.put("ism", 6);
    freq.put("isl", 11);
    freq.put("isa", 35);
    freq.put("ise", 21);
    freq.put("Eur", 13);
    freq.put("ukt", 3);
    freq.put("jjt", 3);
    freq.put("jjj", 8);
    freq.put("jje", 7);
    freq.put("Col", 4);
    freq.put("jj ", 12);
    freq.put("oNa", 5);
    freq.put("ty ", 80);
    freq.put("Izz", 3);
    freq.put("do ", 179);
    freq.put(" Zg", 3);
    freq.put("tyn", 12);
    freq.put("tyb", 6);
    freq.put("typ", 8);
    freq.put("PO ", 7);
    freq.put("doj", 29);
    freq.put("dok", 37);
    freq.put("doh", 14);
    freq.put("don", 99);
    freq.put("doo", 5);
    freq.put("dol", 6);
    freq.put("dom", 9);
    freq.put("dob", 4);
    freq.put("m", 6552);
    freq.put("dod", 17);
    freq.put("dor", 58);
    freq.put("dos", 38);
    freq.put("dop", 3);
    freq.put("dov", 3);
    freq.put("dow", 3);
    freq.put(" We", 7);
    freq.put(" Wa", 5);
    freq.put(" Wo", 4);
    freq.put(" Wi", 12);
    freq.put("ba ", 25);
    freq.put(" W ", 3);
    freq.put("omë", 4);
    freq.put("bav", 3);
    freq.put("bat", 9);
    freq.put("bar", 42);
    freq.put("bas", 71);
    freq.put("baz", 14);
    freq.put("bay", 5);
    freq.put("bad", 5);
    freq.put("bab", 14);
    freq.put("bac", 3);
    freq.put("baa", 3);
    freq.put("ban", 62);
    freq.put("bal", 25);
    freq.put("unë", 25);
    freq.put("baj", 36);
    freq.put("bah", 13);
    freq.put("bai", 4);
    freq.put("om ", 245);
    freq.put("un ", 153);
    freq.put("Rus", 4);
    freq.put("omb", 22);
    freq.put("C", 204);
    freq.put("omg", 3);
    freq.put("ome", 45);
    freq.put("omi", 20);
    freq.put("omo", 5);
    freq.put("omp", 19);
    freq.put("omu", 19);
    freq.put("omt", 3);
    freq.put("unt", 17);
    freq.put("unu", 7);
    freq.put("una", 19);
    freq.put("und", 131);
    freq.put("une", 85);
    freq.put("ung", 17);
    freq.put("uni", 40);
    freq.put("unj", 3);
    freq.put("unk", 5);
    freq.put("unn", 5);
    freq.put("uno", 10);
    freq.put("onë", 22);
    freq.put("iç", 7);
    freq.put("C ", 42);
    freq.put("Ck", 6);
    freq.put("Cj", 4);
    freq.put("Ci", 11);
    freq.put("Ch", 31);
    freq.put("Co", 17);
    freq.put("Cm", 3);
    freq.put("Cl", 9);
    freq.put("Cc", 5);
    freq.put("Ca", 25);
    freq.put("Cg", 9);
    freq.put("Cf", 4);
    freq.put("Ce", 8);
    freq.put("Cd", 5);
    freq.put("sll", 3);
    freq.put("sli", 14);
    freq.put("akr", 10);
    freq.put("Cr", 6);
    freq.put("Cv", 3);
    freq.put("Cu", 3);
    freq.put("iy", 8);
    freq.put("ix", 11);
    freq.put("iz", 134);
    freq.put("iq", 123);
    freq.put("ip", 299);
    freq.put("is", 721);
    freq.put("ir", 527);
    freq.put("Nan", 4);
    freq.put("it", 1218);
    freq.put("iw", 5);
    freq.put("iv", 106);
    freq.put("ii", 164);
    freq.put("Nas", 9);
    freq.put("ik", 449);
    freq.put("ij", 133);
    freq.put("im", 659);
    freq.put("il", 312);
    freq.put("io", 147);
    freq.put("in", 1222);
    freq.put("ia", 334);
    freq.put("ic", 139);
    freq.put("ib", 34);
    freq.put("ie", 129);
    freq.put("id", 182);
    freq.put("ig", 128);
    freq.put("if", 90);
    freq.put("V ", 24);
    freq.put("lqy", 6);
    freq.put("iP", 11);
    freq.put("iS", 4);
    freq.put("iU", 3);
    freq.put("iT", 11);
    freq.put("iW", 3);
    freq.put("iV", 5);
    freq.put("iH", 9);
    freq.put("iK", 8);
    freq.put("iJ", 3);
    freq.put("iM", 19);
    freq.put("iL", 13);
    freq.put("iO", 3);
    freq.put("iN", 5);
    freq.put("iA", 5);
    freq.put("lqe", 25);
    freq.put("iB", 7);
    freq.put("iD", 5);
    freq.put("iF", 4);
    freq.put("Na ", 5);
    freq.put("kis", 92);
    freq.put("kir", 7);
    freq.put("kip", 19);
    freq.put("qje", 3);
    freq.put("kit", 15);
    freq.put("kij", 5);
    freq.put("kii", 3);
    freq.put("kin", 28);
    freq.put("kim", 32);
    freq.put("kil", 4);
    freq.put("i ", 3322);
    freq.put("kia", 4);
    freq.put("ëka", 5);
    freq.put("xje", 4);
    freq.put("Va", 27);
    freq.put("Vd", 5);
    freq.put("Ve", 39);
    freq.put("Vi", 32);
    freq.put("Vj", 6);
    freq.put("Vk", 5);
    freq.put("Vl", 17);
    freq.put("Vo", 17);
    freq.put("Vq", 5);
    freq.put("Vr", 4);
    freq.put("Vt", 3);
    freq.put("Vu", 6);
    freq.put("Vw", 4);
    freq.put("nk ", 13);
    freq.put("yem", 5);
    freq.put("yen", 4);
    freq.put("yez", 3);
    freq.put("op ", 30);
    freq.put("yeq", 4);
    freq.put("yes", 14);
    freq.put("yer", 13);
    freq.put("yet", 16);
    freq.put("ax ", 5);
    freq.put("aVo", 3);
    freq.put("opt", 8);
    freq.put("opu", 11);
    freq.put("opp", 4);
    freq.put("ye ", 32);
    freq.put("ope", 17);
    freq.put("opa", 13);
    freq.put("opo", 6);
    freq.put("opi", 14);
    freq.put("opj", 5);
    freq.put("Arr", 4);
    freq.put("Ars", 9);
    freq.put("Art", 9);
    freq.put("vdy", 3);
    freq.put("Ara", 3);
    freq.put("Arb", 11);
    freq.put("Ard", 21);
    freq.put("Arg", 3);
    freq.put("vdi", 7);
    freq.put("Ari", 20);
    freq.put("Arl", 4);
    freq.put("Arm", 6);
    freq.put("www", 12);
    freq.put("JMa", 3);
    freq.put("zu ", 10);
    freq.put("bra", 28);
    freq.put("ww ", 4);
    freq.put("JM ", 3);
    freq.put("opë", 6);
    freq.put("zur", 3);
    freq.put("zua", 12);
    freq.put("zud", 3);
    freq.put("zun", 3);
    freq.put("zul", 9);
    freq.put("iq ", 40);
    freq.put("TE ", 14);
    freq.put("Z", 171);
    freq.put("iqy", 3);
    freq.put("iqu", 4);
    freq.put("iqt", 6);
    freq.put("iqi", 29);
    freq.put("iqk", 24);
    freq.put("iqe", 4);
    freq.put("NE ", 17);
    freq.put("nki", 3);
    freq.put("fsh", 42);
    freq.put("Win", 3);
    freq.put("Wil", 3);
    freq.put("Wik", 5);
    freq.put("nkr", 3);
    freq.put("di ", 125);
    freq.put("👍", 3);
    freq.put("diL", 4);
    freq.put("diT", 3);
    freq.put("dil", 17);
    freq.put("dim", 25);
    freq.put("din", 82);
    freq.put("dio", 7);
    freq.put("jhe", 6);
    freq.put("dij", 15);
    freq.put("dik", 45);
    freq.put("jhi", 3);
    freq.put("die", 15);
    freq.put("ers", 66);
    freq.put("dia", 18);
    freq.put("dic", 4);
    freq.put("diz", 4);
    freq.put("dit", 187);
    freq.put("diu", 6);
    freq.put("diq", 29);
    freq.put("dir", 4);
    freq.put("dis", 38);
    freq.put("Gru", 5);
    freq.put(" Yl", 14);
    freq.put(" Yo", 10);
    freq.put(" Ye", 4);
    freq.put("Gre", 13);
    freq.put("Gra", 10);
    freq.put("tne", 6);
    freq.put("Chu", 6);
    freq.put("tng", 3);
    freq.put("Jn ", 4);
    freq.put("bo ", 101);
    freq.put("DS ", 3);
    freq.put(" Y ", 5);
    freq.put("tni", 10);
    freq.put("bor", 15);
    freq.put("bos", 10);
    freq.put("bot", 35);
    freq.put("boh", 22);
    freq.put("Wo", 4);
    freq.put("boj", 31);
    freq.put("bol", 43);
    freq.put("bom", 4);
    freq.put("bon", 51);
    freq.put("boo", 23);
    freq.put("💋", 3);
    freq.put("bog", 3);
    freq.put("oo ", 46);
    freq.put("Be ", 3);
    freq.put("Abe", 4);
    freq.put("ayo", 4);
    freq.put("aye", 14);
    freq.put("aya", 7);
    freq.put("ul ", 18);
    freq.put("ays", 3);
    freq.put("ood", 16);
    freq.put("oog", 6);
    freq.put("ooa", 4);
    freq.put("Bel", 9);
    freq.put("oob", 3);
    freq.put("oom", 3);
    freq.put("ool", 4);
    freq.put("ooo", 60);
    freq.put("oon", 12);
    freq.put("Beg", 5);
    freq.put("ook", 16);
    freq.put("oot", 8);
    freq.put("Bey", 3);
    freq.put("oos", 7);
    freq.put("oor", 8);
    freq.put("Ber", 23);
    freq.put("Bes", 17);
    freq.put("Beq", 4);
    freq.put("Bet", 7);
    freq.put("flu", 3);
    freq.put("ay ", 11);
    freq.put("ult", 14);
    freq.put("ulu", 3);
    freq.put("fli", 6);
    freq.put("uli", 14);
    freq.put("flm", 4);
    freq.put("ulo", 11);
    freq.put("flo", 14);
    freq.put("ulm", 13);
    freq.put("fla", 22);
    freq.put("ula", 15);
    freq.put("fle", 27);
    freq.put("ule", 9);
    freq.put("sn ", 5);
    freq.put("ma ", 255);
    freq.put("nyr", 4);
    freq.put("nyl", 3);
    freq.put("nya", 3);
    freq.put("nye", 7);
    freq.put("maq", 6);
    freq.put("snd", 3);
    freq.put("sne", 4);
    freq.put("Fjo", 8);
    freq.put("mat", 67);
    freq.put("sna", 5);
    freq.put("sno", 3);
    freq.put("Fja", 4);
    freq.put("maz", 10);
    freq.put("snj", 14);
    freq.put("Uri", 11);
    freq.put("sni", 32);
    freq.put("maa", 4);
    freq.put("mac", 5);
    freq.put("mad", 54);
    freq.put("mag", 3);
    freq.put("mai", 8);
    freq.put("mah", 9);
    freq.put("mak", 15);
    freq.put("maj", 37);
    freq.put("mam", 26);
    freq.put("mal", 38);
    freq.put("man", 70);
    freq.put("zne", 4);
    freq.put("Edh", 23);
    freq.put("q", 2271);
    freq.put("Edu", 7);
    freq.put("ny ", 8);
    freq.put("lse", 11);
    freq.put("Nga", 5);
    freq.put(" aL", 3);
    freq.put("lsh", 10);
    freq.put("lsi", 4);
    freq.put("kk ", 16);
    freq.put(" aa", 11);
    freq.put(" ab", 12);
    freq.put(" ac", 16);
    freq.put(" ad", 29);
    freq.put(" ae", 3);
    freq.put(" af", 20);
    freq.put(" ag", 11);
    freq.put(" ah", 53);
    freq.put(" ai", 21);
    freq.put(" aj", 67);
    freq.put(" ak", 36);
    freq.put(" al", 40);
    freq.put(" am", 66);
    freq.put(" an", 80);
    freq.put(" ap", 32);
    freq.put(" aq", 80);
    freq.put(" ar", 135);
    freq.put(" as", 94);
    freq.put(" at", 125);
    freq.put(" au", 15);
    freq.put(" av", 8);
    freq.put(" aw", 4);
    freq.put(" ay", 4);
    freq.put(" az", 16);
    freq.put("Shp", 17);
    freq.put("Shq", 105);
    freq.put("qhq", 4);
    freq.put("Sht", 12);
    freq.put("Shu", 28);
    freq.put("ls ", 5);
    freq.put("Sha", 26);
    freq.put("orë", 16);
    freq.put("kkk", 5);
    freq.put("Shi", 17);
    freq.put("Shk", 38);
    freq.put("kka", 8);
    freq.put("Sho", 14);
    freq.put(" a ", 163);
    freq.put("ëm ", 25);
    freq.put("😝", 3);
    freq.put("Cfa", 3);
    freq.put("😂", 7);
    freq.put("aq ", 106);
    freq.put("Lut", 3);
    freq.put("aTu", 3);
    freq.put("Luf", 3);
    freq.put("Lug", 3);
    freq.put("Lum", 6);
    freq.put("or ", 126);
    freq.put("Ken", 6);
    freq.put("Kel", 4);
    freq.put("Keh", 3);
    freq.put(" Ës", 3);
    freq.put("Keq", 3);
    freq.put("orz", 7);
    freq.put("RT ", 376);
    freq.put("G", 274);
    freq.put("ort", 77);
    freq.put("oru", 7);
    freq.put("orr", 22);
    freq.put("ors", 6);
    freq.put("orn", 3);
    freq.put("oro", 11);
    freq.put("orl", 3);
    freq.put("orm", 32);
    freq.put("orj", 8);
    freq.put("ori", 92);
    freq.put("org", 10);
    freq.put("ord", 17);
    freq.put("ore", 114);
    freq.put("Qfa", 5);
    freq.put("ora", 51);
    freq.put("Ke ", 6);
    freq.put("vje", 72);
    freq.put("ua ", 41);
    freq.put("Dë", 3);
    freq.put("IS ", 4);
    freq.put("aqq", 4);
    freq.put("Dn", 5);
    freq.put("Do", 52);
    freq.put("Dm", 9);
    freq.put("Dj", 8);
    freq.put("Dh", 14);
    freq.put("Di", 67);
    freq.put("Dd", 3);
    freq.put("De", 34);
    freq.put("Dc", 4);
    freq.put("Da", 46);
    freq.put("Dx", 6);
    freq.put("Dy", 5);
    freq.put("Du", 35);
    freq.put("Dr", 30);
    freq.put("D ", 71);
    freq.put("ge ", 21);
    freq.put("We", 8);
    freq.put("Wd", 4);
    freq.put("Wc", 3);
    freq.put("Wa", 10);
    freq.put("HA ", 18);
    freq.put("Wk", 3);
    freq.put("Wi", 14);
    freq.put("Wh", 3);
    freq.put("Ws", 3);
    freq.put("ges", 12);
    freq.put("ger", 18);
    freq.put("get", 5);
    freq.put("gez", 5);
    freq.put("jë", 126);
    freq.put("gen", 20);
    freq.put("RI ", 3);
    freq.put("gel", 17);
    freq.put("W ", 24);
    freq.put("imS", 3);
    freq.put("fqe", 3);
    freq.put("oJn", 3);
    freq.put("tu ", 224);
    freq.put("j ", 638);
    freq.put("tup", 4);
    freq.put("FO ", 4);
    freq.put("tur", 74);
    freq.put("jx", 3);
    freq.put("jy", 39);
    freq.put("jz", 14);
    freq.put("jt", 382);
    freq.put("ju", 188);
    freq.put("jv", 14);
    freq.put("tus", 29);
    freq.put("jp", 3);
    freq.put("jq", 10);
    freq.put("jr", 33);
    freq.put("js", 58);
    freq.put("jl", 16);
    freq.put("jm", 131);
    freq.put("jn", 168);
    freq.put("jo", 431);
    freq.put("jh", 13);
    freq.put("ji", 211);
    freq.put("jj", 35);
    freq.put("jk", 39);
    freq.put("jd", 48);
    freq.put("je", 1319);
    freq.put("jf", 10);
    freq.put("jg", 17);
    freq.put("ja", 764);
    freq.put("jb", 6);
    freq.put("jc", 3);
    freq.put("jfo", 3);
    freq.put("yFa", 3);
    freq.put("jZ", 5);
    freq.put("jP", 4);
    freq.put("jfe", 3);
    freq.put("jL", 5);
    freq.put("jN", 7);
    freq.put("jH", 3);
    freq.put("jK", 3);
    freq.put("jE", 3);
    freq.put("jA", 6);
    freq.put("jB", 3);
    freq.put("jC", 5);
    freq.put("tun", 14);
    freq.put("tua", 53);
    freq.put("tub", 8);
    freq.put("Tx", 3);
    freq.put("Ty", 4);
    freq.put("tue", 12);
    freq.put("naK", 6);
    freq.put("kNa", 3);
    freq.put("Dmr", 6);
    freq.put("To", 20);
    freq.put(" bb", 3);
    freq.put("hde", 4);
    freq.put("hdo", 19);
    freq.put("Th", 58);
    freq.put("oi ", 31);
    freq.put("jR", 4);
    freq.put("pap", 7);
    freq.put("paq", 3);
    freq.put("par", 125);
    freq.put("pas", 155);
    freq.put("pat", 41);
    freq.put("pav", 9);
    freq.put("gXi", 3);
    freq.put("paa", 4);
    freq.put("pac", 3);
    freq.put("pad", 5);
    freq.put("pag", 8);
    freq.put("paj", 10);
    freq.put("pak", 52);
    freq.put("pal", 38);
    freq.put("pam", 14);
    freq.put("pan", 10);
    freq.put("oin", 6);
    freq.put("oii", 6);
    freq.put("A ", 185);
    freq.put("oid", 3);
    freq.put("oic", 3);
    freq.put("ujt", 70);
    freq.put("uju", 7);
    freq.put("ujs", 6);
    freq.put("pa ", 112);
    freq.put("ujn", 4);
    freq.put("ujo", 3);
    freq.put("uji", 4);
    freq.put("ujk", 3);
    freq.put("ujd", 7);
    freq.put("uje", 8);
    freq.put("uja", 9);
    freq.put("mo ", 48);
    freq.put("moz", 5);
    freq.put("hqy", 7);
    freq.put("mos", 124);
    freq.put("mor", 43);

    init3();
  }
  private static void init3() {
    
    freq.put("mov", 4);
    freq.put("mot", 23);
    freq.put("moj", 14);
    freq.put("moh", 4);
    freq.put("moo", 10);
    freq.put("mon", 32);
    freq.put("mom", 14);
    freq.put("mol", 4);
    freq.put("moc", 3);
    freq.put("mod", 3);
    freq.put("zle", 3);
    freq.put("zll", 4);
    freq.put("zli", 4);
    freq.put("iç ", 4);
    freq.put("Nen", 4);
    freq.put("Neh", 3);
    freq.put("Nez", 3);
    freq.put("Ney", 7);
    freq.put("Dr ", 5);
    freq.put("Nes", 13);
    freq.put(" ck", 15);
    freq.put(" ch", 34);
    freq.put(" ci", 47);
    freq.put(" cn", 3);
    freq.put(" co", 828);
    freq.put(" cm", 6);
    freq.put("Mem", 7);
    freq.put("Mel", 8);
    freq.put("Men", 14);
    freq.put(" cf", 6);
    freq.put("Meh", 6);
    freq.put(" cd", 4);
    freq.put(" ce", 21);
    freq.put("Met", 5);
    freq.put("Mes", 13);
    freq.put("Mer", 8);
    freq.put(" cr", 3);
    freq.put(" cu", 6);
    freq.put("Ne ", 17);
    freq.put("Dri", 9);
    freq.put("Dre", 11);
    freq.put("qni", 10);
    freq.put("bNe", 3);
    freq.put("Me ", 40);
    freq.put(" c ", 6);
    freq.put("yyy", 4);
    freq.put("aZe", 9);
    freq.put("aqë", 5);
    freq.put("na ", 317);
    freq.put("RR ", 7);
    freq.put("yy ", 5);
    freq.put("Ae", 3);
    freq.put("utë", 6);
    freq.put("Avd", 5);
    freq.put("rët", 28);
    freq.put("rëv", 14);
    freq.put("sve", 4);
    freq.put("rës", 24);
    freq.put("rëz", 14);
    freq.put("rën", 22);
    freq.put("ajz", 7);
    freq.put("rë ", 90);
    freq.put("u", 5091);
    freq.put("IQ ", 3);
    freq.put("Vaj", 3);
    freq.put("Val", 17);
    freq.put("iu ", 28);
    freq.put("Vaz", 4);
    freq.put("hy ", 13);
    freq.put("ws ", 5);
    freq.put("DJ ", 3);
    freq.put("ium", 6);
    freq.put("iun", 6);
    freq.put("TA ", 7);
    freq.put("iut", 4);
    freq.put("hye", 7);
    freq.put("hyn", 3);
    freq.put("hyq", 8);
    freq.put("hyr", 21);
    freq.put("SI ", 3);
    freq.put("ajf", 5);
    freq.put("ajg", 6);
    freq.put("gg ", 3);
    freq.put("ça ", 4);
    freq.put("aba", 25);
    freq.put("abe", 18);
    freq.put("abi", 41);
    freq.put("abo", 6);
    freq.put("abr", 6);
    freq.put("Nës", 7);
    freq.put("abu", 6);
    freq.put("lko", 5);
    freq.put("K", 639);
    freq.put("çar", 6);
    freq.put("Në ", 12);
    freq.put("akt", 52);
    freq.put("gX", 6);
    freq.put("eya", 4);
    freq.put("twe", 18);
    freq.put("twi", 18);
    freq.put("eym", 8);
    freq.put("de ", 75);
    freq.put("tëm", 10);
    freq.put("Për", 12);
    freq.put("ey ", 12);
    freq.put("jdo", 5);
    freq.put("jdi", 8);
    freq.put("jde", 26);
    freq.put("der", 113);
    freq.put("des", 78);
    freq.put("det", 32);
    freq.put("dev", 5);
    freq.put("dej", 14);
    freq.put("dek", 33);
    freq.put("del", 28);
    freq.put("dem", 23);
    freq.put("den", 37);
    freq.put("deo", 23);
    freq.put("dea", 8);
    freq.put("deb", 6);
    freq.put("dec", 3);
    freq.put("dee", 3);
    freq.put("def", 4);
    freq.put("deg", 6);
    freq.put("qq ", 6);
    freq.put("Do ", 5);
    freq.put("rym", 7);
    freq.put("ryj", 3);
    freq.put("ryh", 4);
    freq.put("rye", 31);
    freq.put("ryt", 10);
    freq.put("rys", 37);
    freq.put("ryq", 3);
    freq.put("Dok", 3);
    freq.put("Don", 17);
    freq.put("Dob", 3);
    freq.put("qqq", 6);
    freq.put("Dor", 12);
    freq.put("Dos", 6);
    freq.put("P", 614);
    freq.put("hfr", 6);
    freq.put("Ty ", 4);
    freq.put("cs ", 3);
    freq.put("ry ", 22);
    freq.put("hfa", 3);
    freq.put("uh ", 12);
    freq.put("ok ", 52);
    freq.put("Ba ", 3);
    freq.put("oks", 6);
    freq.put("okr", 4);
    freq.put("oku", 16);
    freq.put("okt", 12);
    freq.put("uha", 20);
    freq.put("uhh", 6);
    freq.put("Bay", 5);
    freq.put("oka", 21);
    freq.put("uhu", 9);
    freq.put("Bab", 3);
    freq.put("Ban", 9);
    freq.put("okk", 4);
    freq.put("Unë", 7);
    freq.put("Baj", 13);
    freq.put("oko", 15);
    freq.put("uj ", 37);
    freq.put("Un ", 9);
    freq.put("mm ", 14);
    freq.put("E ", 208);
    freq.put("sbu", 4);
    freq.put("mmm", 16);
    freq.put("sba", 3);
    freq.put("Une", 7);
    freq.put("mme", 6);
    freq.put("Uni", 6);
    freq.put("okë", 4);
    freq.put("mma", 4);
    freq.put("Em", 15);
    freq.put("El", 46);
    freq.put("En", 20);
    freq.put("Ei", 5);
    freq.put("Eh", 3);
    freq.put("Ek", 10);
    freq.put("Ej", 4);
    freq.put("Ee", 5);
    freq.put("Ed", 40);
    freq.put("Eg", 6);
    freq.put("Ef", 6);
    freq.put("Ec", 3);
    freq.put("Eb", 5);
    freq.put("Eu", 15);
    freq.put("Ev", 16);
    freq.put("Eq", 4);
    freq.put("Ep", 3);
    freq.put("Es", 5);
    freq.put("Er", 19);
    freq.put("ql ", 4);
    freq.put(" el", 11);
    freq.put(" em", 44);
    freq.put(" en", 29);
    freq.put("koj", 47);
    freq.put(" eh", 14);
    freq.put("kol", 57);
    freq.put(" ej", 16);
    freq.put(" ek", 39);
    freq.put(" ed", 298);
    freq.put(" ee", 7);
    freq.put(" ef", 3);
    freq.put(" eg", 12);
    freq.put("kod", 3);
    freq.put(" ec", 15);
    freq.put(" ex", 3);
    freq.put(" et", 14);
    freq.put(" eu", 15);
    freq.put(" ev", 9);
    freq.put("kor", 12);
    freq.put(" ep", 8);
    freq.put("kot", 5);
    freq.put(" er", 36);
    freq.put(" es", 86);
    freq.put("tob", 4);
    freq.put("Xh", 31);
    freq.put("Xi", 5);
    freq.put("Xo", 4);
    freq.put("kë", 89);
    freq.put("ko ", 37);
    freq.put("Xa", 5);
    freq.put(" e ", 1119);
    freq.put("Xd", 3);
    freq.put("Xy", 7);
    freq.put("ëve", 40);
    freq.put("aXh", 9);
    freq.put("hk ", 6);
    freq.put("k ", 597);
    freq.put("Kis", 3);
    freq.put("Kin", 4);
    freq.put("Kim", 3);
    freq.put("kB", 5);
    freq.put("kA", 4);
    freq.put("Ate", 3);
    freq.put("kD", 3);
    freq.put("kJ", 3);
    freq.put("kN", 3);
    freq.put("kM", 9);
    freq.put("Ati", 3);
    freq.put("kQ", 4);
    freq.put("kV", 3);
    freq.put("kT", 3);
    freq.put("kZ", 5);
    freq.put("ëvi", 5);
    freq.put("Aty", 3);
    freq.put("kc", 4);
    freq.put("kb", 6);
    freq.put("ka", 1071);
    freq.put("kg", 10);
    freq.put("kf", 11);
    freq.put("ke", 579);
    freq.put("kd", 3);
    freq.put("kk", 36);
    freq.put("kj", 65);
    freq.put("ki", 311);
    freq.put("kh", 44);
    freq.put("ko", 697);
    freq.put("kn", 69);
    freq.put("km", 8);
    freq.put("kl", 60);
    freq.put("ks", 147);
    freq.put("kr", 243);
    freq.put("kq", 50);
    freq.put("kp", 10);
    freq.put("kv", 5);
    freq.put("ku", 696);
    freq.put("kt", 203);
    freq.put("kz", 10);
    freq.put("ky", 45);
    freq.put("Ki ", 7);
    freq.put("Xig", 3);
    freq.put("ikë", 12);
    freq.put("Ser", 21);
    freq.put("ph", 21);
    freq.put(" Be", 61);
    freq.put(" Ba", 76);
    freq.put(" Bl", 20);
    freq.put(" Bo", 20);
    freq.put(" Bi", 16);
    freq.put(" Bu", 27);
    freq.put("ik ", 78);
    freq.put(" Br", 15);
    freq.put("Ye ", 3);
    freq.put("iks", 5);
    freq.put("ikq", 3);
    freq.put(" B ", 15);
    freq.put("iku", 68);
    freq.put("ikt", 20);
    freq.put("iky", 3);
    freq.put("ika", 59);
    freq.put("ike", 70);
    freq.put("ikk", 10);
    freq.put("ikj", 4);
    freq.put("iki", 24);
    freq.put("ikh", 3);
    freq.put("iko", 58);
    freq.put("ikm", 3);
    freq.put("ikl", 8);
    freq.put("ikZ", 4);
    freq.put("Sej", 3);
    freq.put("ikM", 5);
    freq.put("ga ", 148);
    freq.put("ND ", 6);
    freq.put("HE ", 10);
    freq.put("QE ", 7);
    freq.put("gaz", 11);
    freq.put("gat", 25);
    freq.put("gas", 12);
    freq.put("gar", 36);
    freq.put("gan", 14);
    freq.put("gam", 6);
    freq.put("gal", 3);
    freq.put("gaj", 6);
    freq.put("gah", 3);
    freq.put("gad", 6);
    freq.put("gac", 4);
    freq.put("gab", 16);
    freq.put("lba", 31);
    freq.put("fut", 19);
    freq.put("fur", 3);
    freq.put("fus", 14);
    freq.put("fuq", 7);
    freq.put("fuz", 5);
    freq.put("tj ", 5);
    freq.put("fuc", 5);
    freq.put("fun", 54);
    freq.put("lbe", 3);
    freq.put("ful", 4);
    freq.put("fum", 3);
    freq.put("fuk", 3);
    freq.put("sy ", 6);
    freq.put("Ira", 3);
    freq.put("bs ", 3);
    freq.put("jb ", 3);
    freq.put("ews", 3);
    freq.put("sya", 4);
    freq.put("sye", 6);
    freq.put("syj", 4);
    freq.put("syn", 5);
    freq.put("mHa", 5);
    freq.put("syr", 5);
    freq.put("syv", 3);
    freq.put("syt", 10);
    freq.put("ab", 119);
    freq.put("ew ", 7);
    freq.put("y", 1191);
    freq.put("lda", 4);
    freq.put("lde", 3);
    freq.put("ldo", 10);
    freq.put("bi ", 31);
    freq.put("çë", 5);
    freq.put("cut", 3);
    freq.put("rgu", 10);
    freq.put("rga", 15);
    freq.put("rge", 5);
    freq.put("rgh", 3);
    freq.put("rgi", 5);
    freq.put("rgj", 40);
    freq.put("cul", 4);
    freq.put("rgo", 11);
    freq.put("Dil", 3);
    freq.put("bio", 7);
    freq.put("Din", 6);
    freq.put("ld ", 7);
    freq.put("bij", 8);
    freq.put("bik", 3);
    freq.put("Dij", 4);
    freq.put("Dik", 6);
    freq.put("Die", 6);
    freq.put("bie", 12);
    freq.put("Dia", 5);
    freq.put("bia", 13);
    freq.put("biz", 3);
    freq.put("AL ", 9);
    freq.put("Dit", 15);
    freq.put("bit", 11);
    freq.put("bir", 9);
    freq.put("bis", 21);
    freq.put("Dis", 6);
    freq.put("rg ", 21);
    freq.put("çu", 3);
    freq.put("çf", 5);
    freq.put("çe", 6);
    freq.put("çd", 3);
    freq.put("ça", 14);
    freq.put("ço", 4);
    freq.put("çm", 3);
    freq.put("çk", 6);
    freq.put("çi", 12);
    freq.put("pet", 21);
    freq.put("per", 494);
    freq.put("pes", 18);
    freq.put("pel", 31);
    freq.put("pen", 32);
    freq.put("pej", 35);
    freq.put("pek", 11);
    freq.put("ped", 10);
    freq.put("ape", 28);
    freq.put("pea", 3);
    freq.put("pec", 10);
    freq.put("ufi", 13);
    freq.put("aC ", 4);
    freq.put("Bor", 3);
    freq.put("Bot", 4);
    freq.put("O", 157);
    freq.put(" çu", 3);
    freq.put("ç ", 12);
    freq.put("Boa", 3);
    freq.put("uft", 16);
    freq.put("uso", 4);
    freq.put("pe ", 74);
    freq.put("nsh", 34);
    freq.put("nsi", 10);
    freq.put("usl", 8);
    freq.put("nsm", 4);
    freq.put("nso", 5);
    freq.put("nsa", 16);
    freq.put("nse", 6);
    freq.put("nsf", 4);
    freq.put("usj", 3);
    freq.put("nst", 14);
    freq.put("nsu", 3);
    freq.put(" a", 1159);
    freq.put("mke", 4);
    freq.put("mka", 16);
    freq.put(" çd", 3);
    freq.put("mki", 6);
    freq.put("zh ", 9);
    freq.put("fer", 48);
    freq.put(" gë", 3);
    freq.put(" R ", 6);
    freq.put("sdu", 3);
    freq.put("sdr", 4);
    freq.put("ns ", 10);
    freq.put("Flm", 3);
    freq.put("Flo", 9);
    freq.put("Fla", 8);
    freq.put("Fle", 4);
    freq.put("sdi", 28);
    freq.put("zha", 5);
    freq.put("zhe", 6);
    freq.put("zhd", 23);
    freq.put("zhg", 3);
    freq.put("zhi", 8);
    freq.put("lyp", 7);
    freq.put("New", 8);
    freq.put(" gM", 3);
    freq.put("Maq", 18);
    freq.put("Mas", 20);
    freq.put(" gu", 15);
    freq.put(" gr", 44);
    freq.put("Mat", 6);
    freq.put("kqy", 35);
    freq.put(" gz", 12);
    freq.put(" gy", 3);
    freq.put("ëse", 17);
    freq.put(" ge", 20);
    freq.put("ësa", 3);
    freq.put("Mad", 11);
    freq.put(" j", 805);
    freq.put(" ga", 58);
    freq.put("Mai", 3);
    freq.put(" go", 41);
    freq.put("Mak", 7);
    freq.put("Maj", 10);
    freq.put("ësi", 32);
    freq.put("ësh", 98);
    freq.put(" gh", 8);
    freq.put("Man", 8);
    freq.put("ly ", 11);
    freq.put("Ma ", 6);
    freq.put("ës ", 98);
    freq.put(" g ", 9);
    freq.put(" b", 942);
    freq.put(" c", 1019);
    freq.put(" ca", 11);
    freq.put(" f", 738);
    freq.put(" g", 484);
    freq.put(" d", 1530);
    freq.put(" e", 1802);
    freq.put("Az ", 3);
    freq.put(" k", 2407);
    freq.put(" h", 1566);
    freq.put(" i", 791);
    freq.put(" n", 2279);
    freq.put(" o", 399);
    freq.put(" l", 607);
    freq.put(" m", 3014);
    freq.put(" r", 482);
    freq.put(" s", 2552);
    freq.put(" p", 2513);
    freq.put(" q", 1101);
    freq.put(" v", 804);
    freq.put(" w", 74);
    freq.put(" t", 3201);
    freq.put(" u", 386);
    freq.put(" z", 239);
    freq.put(" x", 96);
    freq.put(" y", 76);
    freq.put(" B", 327);
    freq.put(" C", 134);
    freq.put(" A", 573);
    freq.put(" F", 293);
    freq.put(" G", 206);
    freq.put(" D", 381);
    freq.put(" E", 293);
    freq.put(" J", 186);
    freq.put(" K", 535);
    freq.put(" H", 202);
    freq.put(" I", 177);
    freq.put(" N", 327);
    freq.put(" O", 93);
    freq.put(" L", 286);
    freq.put(" M", 527);
    freq.put(" R", 597);
    freq.put(" S", 688);
    freq.put(" P", 538);
    freq.put(" Q", 147);
    freq.put(" V", 213);
    freq.put(" W", 68);
    freq.put(" T", 347);
    freq.put(" U", 116);
    freq.put(" Z", 110);
    freq.put(" X", 69);
    freq.put(" Y", 64);
    freq.put("Azi", 6);
    freq.put("vll", 9);
    freq.put("vlo", 5);
    freq.put("vle", 21);
    freq.put("Aze", 3);
    freq.put(" ?", 21);
    freq.put("us ", 21);
    freq.put(" ç", 29);
    freq.put(" ë", 62);
    freq.put("nKa", 3);
    freq.put(" Ç", 14);
    freq.put(" Ë", 4);
    freq.put("nKr", 3);
    freq.put("Ora", 6);
    freq.put(" Do", 46);
    freq.put("Vet", 16);
    freq.put("Ver", 6);
    freq.put(" Dj", 8);
    freq.put(" Di", 63);
    freq.put(" Dh", 11);
    freq.put(" De", 26);
    freq.put(" Da", 40);
    freq.put("ii ", 76);
    freq.put(" Dy", 3);
    freq.put("Ven", 6);
    freq.put(" Du", 31);
    freq.put(" Dr", 24);
    freq.put("cha", 19);
    freq.put("Fr", 12);
    freq.put("Fs", 6);
    freq.put("che", 51);
    freq.put("Të ", 14);
    freq.put("Fx", 3);
    freq.put("chi", 16);
    freq.put("cho", 3);
    freq.put("Fa", 66);
    freq.put("JE ", 7);
    freq.put("Fc", 4);
    freq.put("Fe", 33);
    freq.put("Fi", 35);
    freq.put("Fj", 14);
    freq.put("Fk", 3);
    freq.put("Fl", 28);
    freq.put("Fo", 22);
    freq.put("iit", 3);
    freq.put("iir", 6);
    freq.put(" D ", 35);
    freq.put("iin", 4);
    freq.put("iii", 65);
    freq.put("ch ", 6);
    freq.put("f", 1568);
    freq.put("F ", 25);
    freq.put(" Dë", 3);
    freq.put("siK", 3);
    freq.put("lën", 8);
    freq.put("afo", 4);
    freq.put("Ym", 3);
    freq.put("Yl", 15);
    freq.put("Yo", 11);
    freq.put("Yn", 3);
    freq.put("afe", 22);
    freq.put("Yb", 3);
    freq.put("Ye", 7);
    freq.put("afa", 19);
    freq.put("çme", 3);
    freq.put("Yx", 5);
    freq.put("lëv", 3);
    freq.put("Yp", 4);
    freq.put("lët", 4);
    freq.put("lës", 9);
    freq.put("afr", 4);
    freq.put("afs", 11);
    freq.put("sip", 10);
    freq.put("Y ", 25);
    freq.put("sit", 34);
    freq.put("af ", 3);
    freq.put("lë ", 15);
    freq.put("lF", 8);
    freq.put("lD", 5);
    freq.put("lE", 4);
    freq.put("da ", 48);
    freq.put("lA", 6);
    freq.put("lM", 4);
    freq.put("lJ", 5);
    freq.put("bje", 21);
    freq.put("mV ", 3);
    freq.put("lS", 8);
    freq.put("lf", 11);
    freq.put("sic", 7);
    freq.put("ld", 32);
    freq.put("le", 578);
    freq.put("lb", 109);
    freq.put("lc", 7);
    freq.put("tsh", 25);
    freq.put("la", 719);
    freq.put("ln", 11);
    freq.put("lo", 360);
    freq.put("ll", 716);
    freq.put("No", 21);
    freq.put("lj", 47);
    freq.put("lk", 28);
    freq.put("lh", 10);
    freq.put("li", 771);
    freq.put("lv", 10);
    freq.put("lt", 56);
    freq.put("lu", 194);
    freq.put("lr", 7);
    freq.put("ls", 33);
    freq.put("lp", 7);
    freq.put("lq", 41);
    freq.put("eut", 9);
    freq.put("lz", 17);
    freq.put("lx", 24);
    freq.put("ly", 30);
    freq.put("daf", 4);
    freq.put("sie", 4);
    freq.put("dal", 73);
    freq.put("dam", 5);
    freq.put("dan", 28);
    freq.put("daj", 25);
    freq.put("dak", 5);
    freq.put("dat", 15);
    freq.put("dar", 29);
    freq.put("das", 62);
    freq.put("arç", 3);
    freq.put("day", 4);
    freq.put("daG", 4);
    freq.put("l ", 460);
    freq.put("taH", 3);
    freq.put("eu ", 7);
    freq.put("ts ", 5);
    freq.put("sin", 54);
    freq.put("emm", 3);
    freq.put("emn", 18);
    freq.put("lfa", 4);
    freq.put("qu ", 20);
    freq.put("emj", 3);
    freq.put("rez", 36);
    freq.put("PA ", 4);
    freq.put("rex", 8);
    freq.put("iTi", 3);
    freq.put("res", 189);
    freq.put("rep", 8);
    freq.put("req", 23);
    freq.put("rev", 11);
    freq.put("lë", 41);
    freq.put("ret", 80);
    freq.put("rej", 193);
    freq.put("rek", 31);
    freq.put("reh", 20);
    freq.put("rei", 4);
    freq.put("ren", 136);
    freq.put("rel", 10);
    freq.put("rem", 36);
    freq.put("reb", 4);
    freq.put("Tub", 5);
    freq.put("rea", 28);
    freq.put("ref", 15);
    freq.put("reg", 41);
    freq.put("red", 14);
    freq.put("ree", 16);
    freq.put("qur", 9);
    freq.put("lf ", 4);
    freq.put("emr", 60);
    freq.put("qua", 8);
    freq.put("que", 7);
    freq.put("Tu ", 3);
    freq.put("re ", 355);
    freq.put("aAb", 5);
    freq.put("aAl", 4);
    freq.put("aAv", 3);
    freq.put("og ", 5);
    freq.put("ogu", 5);
    freq.put("ogr", 19);
    freq.put("ogl", 5);
    freq.put("ogo", 5);
    freq.put("uda", 10);
    freq.put("ogh", 3);
    freq.put("ogj", 10);
    freq.put("oge", 15);
    freq.put("udh", 8);
    freq.put("udi", 10);
    freq.put("oga", 13);
    freq.put("udo", 4);
    freq.put("Par", 17);
    freq.put("Pas", 18);
    freq.put("Pat", 4);
    freq.put("Lëv", 3);
    freq.put("Pac", 4);
    freq.put("Pad", 9);
    freq.put("nqe", 5);
    freq.put("Paj", 5);
    freq.put("Pak", 7);
    freq.put("Pal", 3);
    freq.put("Pam", 4);
    freq.put("mii", 8);
    freq.put("mik", 15);
    freq.put("mij", 18);
    freq.put("mim", 14);
    freq.put("mil", 56);
    freq.put("min", 133);
    freq.put("mia", 11);
    freq.put("mic", 3);
    freq.put("mie", 3);
    freq.put("mid", 6);
    freq.put("mig", 9);
    freq.put("miz", 7);
    freq.put("miq", 7);
    freq.put("mis", 45);
    freq.put("mir", 235);
    freq.put("mit", 52);
    freq.put("sfu", 5);
    freq.put("Pa ", 4);
    freq.put("ogë", 9);
    freq.put("sfi", 3);
    freq.put("sfe", 4);
    freq.put("mi ", 283);
    freq.put(" iP", 7);
    freq.put(" iT", 3);
    freq.put("ksu", 5);
    freq.put("kst", 8);
    freq.put(" iz", 6);
    freq.put("ksp", 3);
    freq.put("Mos", 23);
    freq.put("Mor", 13);
    freq.put(" ir", 6);
    freq.put(" is", 67);
    freq.put(" it", 27);
    freq.put("kse", 7);
    freq.put(" ik", 19);
    freq.put("ksa", 10);
    freq.put(" im", 18);
    freq.put(" in", 70);
    freq.put(" ia", 10);
    freq.put("kso", 5);
    freq.put(" id", 10);
    freq.put("ksh", 55);
    freq.put("ks ", 15);
    freq.put(" i ", 500);
    freq.put(" Iz", 3);
    freq.put("Zot", 11);
    freq.put("sës", 7);
    freq.put("sër", 5);
    freq.put("sëm", 3);
    freq.put("sën", 3);
    freq.put("wl", 5);
    freq.put("S", 808);
    freq.put("vre", 3);
    freq.put("vri", 6);
    freq.put("vro", 15);
    freq.put("zbu", 7);
    freq.put("së ", 88);
    freq.put("ws", 8);
    freq.put("ohn", 5);
    freq.put("oho", 4);
    freq.put("ae", 14);
    freq.put("ohi", 8);
    freq.put("ohj", 3);
    freq.put("ys ", 8);
    freq.put("Hon", 3);
    freq.put("ohe", 162);
    freq.put("ak", 343);
    freq.put("oha", 17);
    freq.put("cor", 4);
    freq.put("ysh", 127);
    freq.put("ysm", 3);
    freq.put("ysa", 3);
    freq.put("Hot", 9);
    freq.put("yse", 6);
    freq.put("wN", 8);
    freq.put("uit", 3);
    freq.put(" Fs", 3);
    freq.put("wL", 3);
    freq.put(" Fu", 19);
    freq.put(" Fy", 4);
    freq.put(" Fa", 59);
    freq.put("oht", 6);
    freq.put(" Fe", 24);
    freq.put("ohu", 11);
    freq.put(" Fi", 31);
    freq.put(" Fj", 13);
    freq.put(" Fl", 28);
    freq.put(" Fo", 20);
    freq.put("io ", 9);
    freq.put("wR", 3);
    freq.put("ioz", 7);
    freq.put("iot", 12);
    freq.put("ior", 3);
    freq.put("ion", 98);
    freq.put("iol", 7);
    freq.put("iog", 4);
    freq.put("GA ", 6);
    freq.put("një", 74);
    freq.put("adu", 7);
    freq.put("adr", 27);
    freq.put("ady", 4);
    freq.put("add", 9);
    freq.put("ade", 16);
    freq.put("ada", 27);
    freq.put("ado", 14);
    freq.put("adm", 6);
    freq.put("esë", 26);
    freq.put("adh", 62);
    freq.put("adi", 39);
    freq.put("QI ", 3);
    freq.put("Hys", 4);
    freq.put("aZ", 12);
    freq.put("ad ", 20);
    freq.put("nja", 36);
    freq.put("nje", 196);
    freq.put("nji", 9);
    freq.put("njo", 52);
    freq.put("njt", 3);
    freq.put("esu", 8);
    freq.put("est", 68);
    freq.put("ess", 37);
    freq.put("tmu", 6);
    freq.put("esp", 10);
    freq.put("esf", 3);
    freq.put("ese", 95);
    freq.put("esc", 3);
    freq.put("esb", 3);
    freq.put("esa", 83);
    freq.put("eso", 54);
    freq.put("esn", 5);
    freq.put("esm", 5);
    freq.put("esk", 4);
    freq.put("esi", 102);
    freq.put("esh", 399);
    freq.put("nj ", 4);
    freq.put("OS ", 7);
    freq.put("tm ", 3);
    freq.put("es ", 251);
    freq.put("Twi", 9);
    freq.put("bu ", 5);
    freq.put("rch", 21);
    freq.put("rci", 3);
    freq.put("rce", 26);
    freq.put("rca", 9);
    freq.put("bux", 3);
    freq.put("bur", 30);
    freq.put("bus", 11);
    freq.put("Der", 4);
    freq.put("Des", 4);
    freq.put("but", 10);
    freq.put("buj", 4);
    freq.put("buk", 25);
    freq.put("bun", 4);
    freq.put("Dem", 4);
    freq.put("Den", 3);
    freq.put("Dea", 4);
    freq.put("bua", 5);
    freq.put("bud", 6);
    freq.put("j", 4802);
    freq.put("hll", 6);
    freq.put("rc ", 3);
    freq.put("pij", 5);
    freq.put("pik", 12);
    freq.put("pim", 6);
    freq.put("pin", 33);
    freq.put("pio", 11);
    freq.put("pia", 8);
    freq.put("pic", 3);
    freq.put("pie", 13);
    freq.put("aGa", 3);
    freq.put("piz", 3);
    freq.put("ub ", 5);
    freq.put("pir", 20);
    freq.put("pis", 20);
    freq.put("pit", 19);
    freq.put("oad", 3);
    freq.put("oaa", 4);
    freq.put("oat", 6);
    freq.put("oas", 3);
    freq.put("Acc", 4);
    freq.put("pi ", 86);
    freq.put("ube", 15);
    freq.put("ubl", 17);
    freq.put("ubi", 8);
    freq.put(" kë", 54);
    freq.put("G ", 28);
    freq.put("tR", 4);
    freq.put("Gu", 8);
    freq.put("Gr", 32);
    freq.put("Zë", 3);
    freq.put("Gz", 6);
    freq.put("Ge", 41);
    freq.put("Ga", 24);
    freq.put("Go", 17);
    freq.put("Gm", 3);
    freq.put("Gj", 56);
    freq.put("Gi", 5);
    freq.put("Gh", 8);
    freq.put(" kb", 4);
    freq.put(" kc", 4);
    freq.put(" ka", 588);
    freq.put(" kg", 5);
    freq.put(" ke", 322);
    freq.put(" kj", 43);
    freq.put(" kk", 3);
    freq.put(" kh", 22);
    freq.put(" ki", 138);
    freq.put(" kn", 49);
    freq.put(" ko", 369);
    freq.put(" kl", 24);
    freq.put(" kr", 158);
    freq.put(" ks", 58);
    freq.put(" kq", 37);
    freq.put(" kt", 78);
    freq.put(" ku", 402);
    freq.put(" ky", 19);
    freq.put("wd ", 4);
    freq.put("Fin", 4);
    freq.put("kuu", 4);
    freq.put("kut", 6);
    freq.put("Z ", 31);
    freq.put("kur", 272);
    freq.put("kuq", 3);
    freq.put("kup", 45);
    freq.put("kun", 29);
    freq.put("kum", 10);
    freq.put("kul", 26);
    freq.put("kuk", 7);
    freq.put("kuj", 36);
    freq.put("kuf", 5);
    freq.put("kue", 10);
    freq.put("kud", 3);
    freq.put("kuc", 3);
    freq.put("kua", 18);
    freq.put(" k ", 10);
    freq.put("Zo", 16);
    freq.put("Zh", 11);
    freq.put("Zi", 7);
    freq.put("Zk", 4);
    freq.put("Zd", 3);
    freq.put("Ze", 29);
    freq.put("Zg", 6);
    freq.put("Za", 17);
    freq.put("Zb", 5);
    freq.put("Zx", 3);
    freq.put("Zy", 6);
    freq.put("që ", 74);
    freq.put("Zu", 5);
    freq.put("Zv", 3);
    freq.put("Zw", 4);
    freq.put("Zp", 4);
    freq.put("ku ", 129);
    freq.put("Koh", 3);
    freq.put("Kok", 3);
    freq.put("Kom", 27);
    freq.put("Kol", 5);
    freq.put("Kon", 9);
    freq.put("Kos", 102);
    freq.put("Kor", 7);
    freq.put("m ", 1122);
    freq.put("enë", 8);
    freq.put("mE", 4);
    freq.put("mD", 3);
    freq.put("mA", 5);
    freq.put("mC", 4);
    freq.put("mB", 4);
    freq.put("mO", 3);
    freq.put("mH", 7);
    freq.put("mK", 3);
    freq.put("mU", 3);
    freq.put("mT", 4);
    freq.put("mV", 3);
    freq.put("mQ", 5);
    freq.put("mP", 6);
    freq.put("mS", 5);
    freq.put("mY", 4);
    freq.put("me", 1846);
    freq.put("md", 27);
    freq.put("mg", 9);
    freq.put("mf", 5);
    freq.put("ma", 808);
    freq.put("g", 1686);
    freq.put("mc", 5);
    freq.put("mb", 203);
    freq.put("mm", 49);
    freq.put("ml", 14);
    freq.put("mo", 342);
    freq.put("mn", 48);
    freq.put("mi", 925);
    freq.put("mh", 4);
    freq.put("mk", 35);
    freq.put("mj", 52);
    freq.put("mu", 404);
    freq.put("mt", 83);
    freq.put("mw", 3);
    freq.put("mv", 12);
    freq.put("mq", 7);
    freq.put("mp", 60);
    freq.put("ms", 71);
    freq.put("mr", 109);
    freq.put("my", 26);
    freq.put("mx", 5);
    freq.put("mz", 10);
    freq.put("enA", 3);
    freq.put("ena", 73);
    freq.put("enc", 28);
    freq.put("end", 240);
    freq.put("ene", 56);
    freq.put("eng", 40);
    freq.put("enh", 3);
    freq.put("eni", 116);
    freq.put("enj", 23);
    freq.put("enk", 7);
    freq.put("enn", 12);
    freq.put("eno", 22);
    freq.put("enq", 3);
    freq.put("enr", 3);
    freq.put("ens", 10);
    freq.put("ent", 126);
    freq.put("enu", 15);
    freq.put("enx", 4);
    freq.put("eny", 4);
    freq.put("enz", 6);
    freq.put("ON ", 14);
    freq.put("en ", 564);
    freq.put("yqi", 3);
    freq.put("më", 145);
    freq.put("yqy", 10);
    freq.put("yqt", 4);
    freq.put("UK ", 3);
    freq.put("imA", 3);
    freq.put("imH", 5);
    freq.put(" Hp", 3);
    freq.put(" Hu", 10);
    freq.put("imP", 4);
    freq.put(" Hi", 11);
    freq.put(" Ho", 21);
    freq.put(" Hm", 5);
    freq.put(" Ha", 63);
    freq.put(" He", 13);
    freq.put("ima", 44);
    freq.put("imb", 9);
    freq.put("ime", 181);
    freq.put("imd", 3);
    freq.put("imi", 169);
    freq.put("imm", 3);
    freq.put("imo", 12);
    freq.put("imn", 8);
    freq.put("imp", 5);
    freq.put("ajë", 3);
    freq.put("imu", 11);
    freq.put("imt", 14);
    freq.put("JA ", 9);
    freq.put("SA ", 7);
    freq.put(" H ", 8);
    freq.put("im ", 157);
    freq.put("hqh", 4);
    freq.put("hqi", 228);
    freq.put("hqk", 6);
    freq.put("hqe", 4);
    freq.put("ajL", 3);
    freq.put("ajA", 3);
    freq.put("gom", 6);
    freq.put("gol", 18);
    freq.put("goo", 6);
    freq.put("gon", 40);
    freq.put("goh", 7);
    freq.put("goj", 21);
    freq.put("ajq", 9);
    freq.put("ajr", 20);
    freq.put("ajs", 10);
    freq.put("ajt", 76);
    freq.put("aju", 3);
    freq.put("goc", 3);
    freq.put("ajh", 6);
    freq.put("aji", 14);
    freq.put("ajj", 6);
    freq.put("ajk", 17);
    freq.put("ajl", 12);
    freq.put("ajm", 80);
    freq.put("ajn", 25);
    freq.put("ajo", 35);
    freq.put("aja", 38);
    freq.put("gov", 4);
    freq.put("ajd", 28);
    freq.put("aje", 32);
    freq.put("gos", 8);
    freq.put("gor", 5);
    freq.put("W", 98);
    freq.put("Vid", 6);
    freq.put("Vie", 3);
    freq.put("Vik", 4);
    freq.put("go ", 11);
    freq.put("Vil", 3);
    freq.put("Vis", 5);
    freq.put("Vit", 3);
    freq.put("çi ", 6);
    freq.put("aj ", 233);
    freq.put("be ", 65);
    freq.put("nha", 7);
    freq.put("nho", 4);
    freq.put("eqy", 4);
    freq.put("tor", 81);
    freq.put("tos", 17);
    freq.put("top", 8);
    freq.put("tov", 14);
    freq.put("tot", 13);
    freq.put("eqi", 25);
    freq.put("tok", 10);
    freq.put("toh", 30);
    freq.put("toi", 7);
    freq.put("ton", 133);
    freq.put("too", 9);
    freq.put("tol", 7);
    freq.put("tom", 3);
    freq.put("eqa", 4);
    freq.put("eqe", 15);
    freq.put("tog", 6);
    freq.put("Fut", 9);
    freq.put("Fuc", 3);
    freq.put("Fun", 4);
    freq.put("eq ", 147);
    freq.put("to ", 121);
    freq.put("thu", 34);
    freq.put("raf", 35);
    freq.put("rag", 9);
    freq.put("rad", 34);
    freq.put("tht", 4);
    freq.put("rab", 11);
    freq.put("rac", 13);
    freq.put("raa", 12);
    freq.put("ran", 99);
    freq.put("ths", 3);
    freq.put("ral", 21);
    freq.put("ram", 46);
    freq.put("raj", 22);
    freq.put("rak", 37);
    freq.put("rah", 37);
    freq.put("rai", 4);
    freq.put("rav", 16);
    freq.put("rat", 88);
    freq.put("rau", 3);
    freq.put("rar", 11);
    freq.put("ras", 66);
    freq.put("rap", 25);
    freq.put("raq", 8);
    freq.put("lbi", 11);
    freq.put("raz", 9);
    freq.put("qy ", 6);
    freq.put("lbo", 6);
    freq.put("lbT", 45);
    freq.put("thm", 17);
    freq.put("Syl", 4);
    freq.put("iHa", 3);
    freq.put("lbN", 3);
    freq.put("ra ", 283);
    freq.put("qyt", 18);
    freq.put("qys", 68);
    freq.put("qyr", 50);
    freq.put("bsh", 5);
    freq.put("Ita", 5);
    freq.put("AS ", 4);
    freq.put("jë ", 106);
    freq.put("aEl", 3);
    freq.put("oci", 13);
    freq.put("ock", 3);
    freq.put("oca", 5);
    freq.put("Big", 5);
    freq.put("abs", 3);
    freq.put("Biv", 4);
    freq.put("Bis", 3);
    freq.put("jës", 8);
    freq.put("xon", 15);
    freq.put("jën", 3);
    freq.put("Pet", 3);
    freq.put("nut", 7);
    freq.put("nur", 8);
    freq.put("nus", 10);
    freq.put("Per", 33);
    freq.put("nun", 3);
    freq.put("nul", 3);
    freq.put("num", 10);
    freq.put("nuk", 162);
    freq.put("Pej", 13);
    freq.put("Pec", 5);
    freq.put("muu", 4);
    freq.put("mut", 15);
    freq.put("mus", 23);
    freq.put("mur", 25);
    freq.put("muz", 9);
    freq.put("mue", 5);
    freq.put("mua", 16);
    freq.put("mum", 5);
    freq.put("mul", 7);
    freq.put("mun", 110);
    freq.put("KB ", 3);
    freq.put("muj", 42);
    freq.put("elj", 3);
    freq.put("eT ", 3);
    freq.put("zbr", 3);
    freq.put("nu ", 18);
    freq.put("mu ", 132);
    freq.put(" md", 13);
    freq.put(" me", 1232);
    freq.put(" mg", 3);
    freq.put(" ma", 459);
    freq.put(" mb", 98);
    freq.put(" mc", 4);
    freq.put(" ml", 6);
    freq.put(" mn", 16);
    freq.put(" mo", 219);
    freq.put(" mi", 352);
    freq.put(" mj", 20);
    freq.put(" mk", 26);
    freq.put(" mt", 14);
    freq.put(" mu", 293);
    freq.put(" mv", 8);
    freq.put(" mp", 5);
    freq.put(" mr", 24);
    freq.put(" ms", 55);
    freq.put(" my", 20);
    freq.put(" mz", 3);
    freq.put("YR ", 3);
    freq.put("bTi", 45);
    freq.put("Sdi", 4);
    freq.put("ab ", 8);
    freq.put(" m ", 45);
    freq.put("tDr", 3);
    freq.put("Cri", 4);
    freq.put("TV ", 4);
    freq.put("n", 8844);
    freq.put("▀", 29);
    freq.put(" më", 80);
    freq.put("Ësh", 3);
    freq.put("icë", 8);
    freq.put("elk", 3);
    freq.put("eli", 61);
    freq.put("elo", 22);
    freq.put("ell", 76);
    freq.put("elm", 11);
    freq.put("ela", 25);
    freq.put("eld", 4);
    freq.put("ele", 55);
    freq.put("els", 11);
    freq.put("elq", 29);
    freq.put("elt", 3);
    freq.put("elu", 3);
    freq.put("D", 469);
    freq.put("jyr", 11);
    freq.put("jys", 8);
    freq.put("Lyr", 7);
    freq.put("jyq", 4);
    freq.put("el ", 80);
    freq.put("nM ", 4);
    freq.put("jyn", 4);
    freq.put("vsk", 4);
    freq.put("jyk", 7);
    freq.put(" Ju", 26);
    freq.put(" Jo", 25);
    freq.put(" Ji", 3);
    freq.put(" Je", 33);
    freq.put(" Ja", 43);
    freq.put("ick", 17);
    freq.put("elë", 4);
    freq.put("ici", 28);
    freq.put("Hy", 7);
    freq.put("ico", 4);
    freq.put("Hp", 3);
    freq.put("Hq", 3);
    freq.put("Ht", 3);
    freq.put("Hu", 15);
    freq.put("Hk", 3);
    freq.put("Hi", 11);
    freq.put("Ho", 31);
    freq.put("rJa", 4);
    freq.put("Hm", 7);
    freq.put("Hb", 5);
    freq.put("Ha", 89);
    freq.put("Hg", 3);
    freq.put("He", 16);
    freq.put("hse", 3);
    freq.put("hsh", 10);
    freq.put(" J ", 9);
    freq.put("ic ", 16);
    freq.put("H ", 57);
    freq.put("aha", 678);
    freq.put("ppe", 3);
    freq.put("ahe", 23);
    freq.put("ahj", 8);
    freq.put("ahh", 86);
    freq.put("ahi", 40);
    freq.put("ahn", 4);
    freq.put("aho", 4);
    freq.put("ahm", 4);
    freq.put("ahs", 3);
    freq.put("aht", 5);
    freq.put("ahu", 34);
    freq.put("në", 469);
    freq.put("gis", 4);
    freq.put("gir", 3);
    freq.put("gie", 3);
    freq.put("çka", 6);
    freq.put("gin", 6);
    freq.put("gim", 7);
    freq.put("ah ", 88);
    freq.put("pp ", 6);
    freq.put("qës", 4);
    freq.put("Voi", 3);
    freq.put("Vok", 3);
    freq.put("Vot", 6);
    freq.put("gi ", 6);
    freq.put("urn", 4);
    freq.put("nI", 3);
    freq.put("nK", 12);
    freq.put("nL", 4);
    freq.put("nM", 10);
    freq.put("nN", 3);
    freq.put("nA", 8);
    freq.put("nB", 12);
    freq.put("nC", 3);
    freq.put("nD", 3);
    freq.put("nF", 5);
    freq.put("nG", 4);
    freq.put("nny", 8);
    freq.put("nP", 3);
    freq.put("nR", 9);
    freq.put("nS", 15);
    freq.put("nT", 9);
    freq.put("nU", 6);
    freq.put("nV", 4);
    freq.put("nh", 14);
    freq.put("ni", 978);
    freq.put("nj", 384);
    freq.put("nk", 77);
    freq.put("nl", 12);
    freq.put("nm", 31);
    freq.put("nn", 75);
    freq.put("no", 198);
    freq.put("tit", 72);
    freq.put("na", 745);
    freq.put("nb", 17);
    freq.put("nc", 108);
    freq.put("nd", 813);
    freq.put("ne", 805);
    freq.put("nf", 53);
    freq.put("ng", 382);
    freq.put("nx", 28);
    freq.put("ny", 30);
    freq.put("nz", 14);
    freq.put("tio", 5);
    freq.put("tii", 19);
    freq.put("tij", 24);
    freq.put("ES ", 8);
    freq.put("np", 14);
    freq.put("nq", 18);
    freq.put("nr", 15);
    freq.put("ns", 111);
    freq.put("nt", 345);
    freq.put("nu", 245);
    freq.put("nv", 36);
    freq.put("nw", 3);
    freq.put("sqy", 3);
    freq.put("nn ", 22);
    freq.put("ich", 7);
    freq.put("sqa", 3);
    freq.put("n ", 2588);
    freq.put(" çë", 4);
    freq.put("ti ", 418);
    freq.put("ica", 28);
    freq.put("roh", 16);
    freq.put("roi", 7);
    freq.put("roj", 44);
    freq.put("rok", 8);
    freq.put("rol", 10);
    freq.put("rom", 9);
    freq.put("ron", 54);
    freq.put("roo", 5);
    freq.put("lls", 3);
    freq.put("roa", 5);
    freq.put("rob", 28);
    freq.put("rof", 19);
    freq.put("rog", 16);
    freq.put("llk", 7);
    freq.put("llj", 8);
    freq.put("lli", 110);
    freq.put("llo", 69);
    freq.put("ice", 25);
    freq.put("llm", 3);
    freq.put("lll", 4);
    freq.put("rop", 30);
    freq.put("ror", 13);
    freq.put("ros", 24);
    freq.put("rot", 15);
    freq.put("rov", 29);
    freq.put("row", 4);
    freq.put("Daf", 6);
    freq.put("Dal", 3);
    freq.put("Dam", 6);
    freq.put("Dan", 4);
    freq.put("Dar", 8);
    freq.put("Das", 6);
    freq.put("kZh", 3);
    freq.put("cnc", 12);
    freq.put("Cic", 5);
    freq.put("ëno", 4);
    freq.put("ro ", 47);
    freq.put("tw ", 3);
    freq.put("ll ", 121);
    freq.put("kla", 18);
    freq.put("ëni", 4);
    freq.put("kll", 14);
    freq.put("ënd", 34);
    freq.put("Rez", 5);
    freq.put("Rex", 9);
    freq.put(" dd", 5);
    freq.put("jda", 4);
    freq.put("aKu", 5);
    freq.put("llë", 13);
    freq.put("Ren", 3);
    freq.put("Rea", 12);
    freq.put("Red", 12);
    freq.put("Agn", 3);
    freq.put("Agj", 6);
    freq.put("Agr", 3);
    freq.put("ëns", 6);
    freq.put("yj ", 3);
    freq.put("sh ", 570);
    freq.put("msu", 21);
    freq.put("mso", 15);
    freq.put("msi", 8);
    freq.put("msh", 12);
    freq.put("Evr", 13);
    freq.put("yja", 8);
    freq.put("yje", 5);
    freq.put("ms ", 5);
    freq.put(" on", 11);
    freq.put(" oo", 15);
    freq.put(" om", 10);
    freq.put(" oj", 12);
    freq.put(" ok", 11);
    freq.put(" oh", 4);
    freq.put("Min", 9);
    freq.put(" of", 22);
    freq.put("█", 6);
    freq.put(" ob", 6);
    freq.put(" ot", 3);
    freq.put("Mir", 33);
    freq.put(" or", 47);
    freq.put(" os", 101);
    freq.put(" op", 16);
    freq.put("kyH", 3);
    freq.put("Mi ", 3);
    freq.put("ky ", 28);
    freq.put(" o ", 102);
    freq.put("iPa", 5);
    freq.put("dih", 21);
    freq.put("Fan", 7);
    freq.put("qs", 8);
    freq.put("qr", 7);
    freq.put("ng ", 44);
    freq.put("gt ", 5);
    freq.put("qx", 5);
    freq.put("EN ", 14);
    freq.put("ejm", 3);
    freq.put("ejn", 7);
    freq.put("ejo", 6);
    freq.put("ejh", 5);
    freq.put("ejj", 8);
    freq.put("ejk", 4);
    freq.put("ejd", 4);
    freq.put("eje", 29);
    freq.put("ejg", 3);
    freq.put("eja", 47);
    freq.put("ejz", 3);
    freq.put("ejt", 204);
    freq.put("eju", 3);
    freq.put("ejr", 3);
    freq.put("ejs", 16);
    freq.put("ahA", 3);
    freq.put("ej ", 134);
    freq.put("qn", 15);
    freq.put("hu ", 61);
    freq.put("anë", 55);
    freq.put("iam", 9);
    freq.put("ial", 33);
    freq.put("ian", 58);
    freq.put("iah", 3);
    freq.put("iak", 5);
    freq.put("iaj", 3);
    freq.put("vër", 6);
    freq.put("vës", 23);
    freq.put("iaa", 3);
    freq.put("vën", 6);
    freq.put("iat", 6);
    freq.put("ias", 3);
    freq.put("PD ", 5);
    freq.put("hue", 3);
    freq.put("ebo", 20);
    freq.put("hua", 21);
    freq.put("huc", 6);
    freq.put("hum", 238);
    freq.put("hun", 27);
    freq.put("huh", 12);
    freq.put("huj", 14);
    freq.put("huk", 9);
    freq.put("hut", 9);
    freq.put("huu", 3);
    freq.put("hup", 18);
    freq.put("hur", 59);
    freq.put("hus", 10);
    freq.put(" Lë", 4);
    freq.put("ia ", 167);
    freq.put("r", 8632);
    freq.put("vë ", 22);
    freq.put("pre", 131);
    freq.put("ane", 66);
    freq.put("ang", 42);
    freq.put("pra", 39);
    freq.put("ana", 67);
    freq.put("anc", 25);
    freq.put("pro", 72);
    freq.put("ano", 34);
    freq.put("pri", 77);
    freq.put("ani", 193);
    freq.put("anj", 11);
    freq.put("ank", 18);
    freq.put("ant", 62);
    freq.put("anu", 9);
    freq.put("anv", 3);
    freq.put("ans", 34);
    freq.put("any", 4);
    freq.put("anA", 4);
    freq.put("anB", 6);
    freq.put(" L ", 3);
    freq.put("anM", 5);
    freq.put("anK", 3);
    freq.put("an ", 304);
    freq.put("uyo", 3);
    freq.put(" Le", 34);
    freq.put(" La", 74);
    freq.put(" Lo", 21);
    freq.put(" Li", 58);
    freq.put(" Lu", 22);
    freq.put("gk ", 3);
    freq.put(" Ly", 7);
    freq.put("tke", 7);
    freq.put("tka", 14);
    freq.put("tko", 11);
    freq.put("eMo", 3);
    freq.put("itl", 11);
    freq.put("hku", 78);
    freq.put("tki", 9);
    freq.put("tkr", 3);
    freq.put("rmë", 7);
    freq.put("dy ", 33);
    freq.put("ss ", 34);
    freq.put("nlo", 4);
    freq.put("tk ", 4);
    freq.put("dyt", 8);
    freq.put("H", 289);
    freq.put("sss", 7);
    freq.put("dys", 6);
    freq.put("dyl", 3);
    freq.put("sso", 4);
    freq.put("ssi", 17);
    freq.put("ssh", 3);
    freq.put("dyj", 5);
    freq.put("dye", 9);
    freq.put("ssa", 11);
    freq.put("dyC", 5);
    freq.put("iLa", 6);
    freq.put("rmb", 3);
    freq.put("rma", 43);
    freq.put("lni", 3);
    freq.put("rme", 25);
    freq.put("rmj", 3);
    freq.put("jot", 13);
    freq.put("rmi", 16);
    freq.put("rmo", 3);
    freq.put("rm ", 7);
    freq.put("JË ", 3);
    freq.put("poz", 7);
    freq.put("pot", 15);
    freq.put("por", 71);
    freq.put("pos", 28);
    freq.put("pop", 12);
    freq.put("pon", 23);
    freq.put("poo", 9);
    freq.put("pol", 26);
    freq.put("pom", 32);
    freq.put("pod", 7);
    freq.put("poe", 3);
    freq.put("eOf", 3);
    freq.put("ëgj", 3);
    freq.put("nni", 6);
    freq.put("Bur", 5);
    freq.put("Bus", 3);
    freq.put("Buj", 5);
    freq.put("Bul", 3);
    freq.put("Bum", 6);
    freq.put("Buc", 3);
    freq.put("nne", 11);
    freq.put("nna", 12);
    freq.put("po ", 457);
    freq.put("Nje", 15);
    freq.put("Njo", 3);
    freq.put("azh", 39);
    freq.put("uhe", 83);
    freq.put("ePi", 3);
    freq.put("Bar", 31);
    freq.put("Bas", 9);
    freq.put("nnt", 4);
    freq.put("I ", 110);
    freq.put("uhi", 4);
    freq.put("që", 90);
    freq.put("Iz", 7);
    freq.put("tiz", 4);
    freq.put("Një", 9);
    freq.put("Is", 25);
    freq.put("Ir", 5);
    freq.put("It", 8);
    freq.put("yhe", 6);
    freq.put("Ik", 4);
    freq.put("Im", 12);
    freq.put("Il", 12);
    freq.put("In", 29);
    freq.put("🏢", 3);
    freq.put("Ib", 16);
    freq.put("Id", 9);
    freq.put("If", 4);
    freq.put(" qt", 3);
    freq.put(" qu", 38);
    freq.put(" qy", 76);
    freq.put(" qa", 131);
    freq.put(" qd", 6);
    freq.put(" qe", 524);
    freq.put(" qf", 31);
    freq.put(" qi", 101);
    freq.put(" qk", 43);
    freq.put("Bal", 13);
    freq.put(" qo", 25);
    freq.put("til", 12);
    freq.put("tim", 98);
    freq.put("tin", 144);
    freq.put("dë ", 6);
    freq.put("tik", 61);
    freq.put(" q ", 15);
    freq.put("tid", 4);
    freq.put("tie", 6);
    freq.put("tif", 19);
    freq.put("VV ", 4);
    freq.put("tig", 4);
    freq.put("dër", 32);
    freq.put("dës", 18);
    freq.put("oç", 4);
    freq.put("tia", 20);
    freq.put("dëg", 3);
    freq.put("Piq", 3);
    freq.put("Pis", 3);
    freq.put("Kuv", 4);
    freq.put("Kus", 15);
    freq.put("Kur", 44);
    freq.put("Kuq", 5);
    freq.put("Zgj", 3);
    freq.put("Kul", 4);
    freq.put("Kuk", 5);
    freq.put("Kuj", 3);
    freq.put(" që", 80);
    freq.put("Mja", 3);
    freq.put("o ", 2362);
    freq.put("oO", 7);
    freq.put("oN", 8);
    freq.put("oM", 3);
    freq.put("oL", 6);
    freq.put("oK", 5);
    freq.put("oJ", 6);
    freq.put("oC", 3);
    freq.put("oB", 3);
    freq.put("oA", 4);
    freq.put("uTu", 4);
    freq.put("oV", 3);
    freq.put("oT", 5);
    freq.put("Ku ", 6);
    freq.put("oo", 210);
    freq.put("on", 1221);
    freq.put("om", 414);
    freq.put("ol", 338);
    freq.put("ok", 179);
    freq.put("oj", 441);
    freq.put("oi", 53);
    freq.put("oh", 260);
    freq.put("og", 92);
    freq.put("of", 103);
    freq.put("oe", 11);
    freq.put("od", 104);
    freq.put("oc", 30);
    freq.put("ob", 67);
    freq.put("oa", 22);
    freq.put("oz", 54);
    freq.put("oy", 5);
    freq.put("ox", 21);
    freq.put("ow", 30);
    freq.put("ov", 287);
    freq.put("ou", 41);
    freq.put("ot", 416);
    freq.put("os", 606);
    freq.put("or", 633);
    freq.put("oq", 58);
    freq.put("op", 124);
    freq.put("ju ", 86);
    freq.put("nAh", 5);
    freq.put("eht", 10);
    freq.put("ehu", 11);
    freq.put("ehr", 4);
    freq.put("ehe", 70);
    freq.put("RD ", 3);
    freq.put("eha", 9);
    freq.put("ehn", 3);
    freq.put("ehl", 4);
    freq.put("ehm", 8);
    freq.put("ehh", 10);
    freq.put("ehi", 3);
    freq.put("jua", 15);
    freq.put("juj", 4);
    freq.put("juk", 4);
    freq.put("juh", 7);
    freq.put("jum", 26);
    freq.put("jus", 8);
    freq.put("jup", 8);
    freq.put("juv", 7);
    freq.put("jut", 10);
    freq.put("eh ", 34);
    freq.put("rva", 11);
    freq.put("rve", 13);
    freq.put("rvi", 5);
    freq.put("Yq ", 3);
    freq.put("igX", 3);
    freq.put("igu", 12);
    freq.put("igr", 4);
    freq.put("ige", 7);
    freq.put("iga", 17);
    freq.put("igo", 23);
    freq.put("ign", 4);
    freq.put("igl", 3);
    freq.put("igj", 35);
    freq.put("igh", 9);
    freq.put("rv ", 7);
    freq.put("yne", 8);
    freq.put("pto", 19);
    freq.put("alo", 43);
    freq.put("all", 194);
    freq.put("alm", 6);
    freq.put("alj", 11);
    freq.put("alk", 11);
    freq.put("pti", 8);
    freq.put("llz", 11);
    freq.put("alf", 3);
    freq.put("ald", 14);
    freq.put("ale", 121);
    freq.put("alb", 22);
    freq.put("lly", 5);
    freq.put("pta", 70);
    freq.put("ala", 67);
    freq.put("llx", 22);
    freq.put("fa ", 16);
    freq.put("alu", 25);
    freq.put("als", 4);
    freq.put("SH ", 12);
    freq.put("ptK", 3);
    freq.put(" N ", 15);
    freq.put("Që ", 3);
    freq.put("alS", 6);
    freq.put("faz", 6);
    freq.put("far", 71);
    freq.put("fas", 3);
    freq.put("faq", 19);
    freq.put("fav", 8);
    freq.put("fat", 22);
    freq.put("pt ", 15);
    freq.put("faj", 12);
    freq.put("fak", 11);
    freq.put("fan", 19);
    freq.put("llu", 25);
    freq.put("fal", 35);
    freq.put("fam", 13);
    freq.put("fab", 3);
    freq.put("fac", 4);
    freq.put("llt", 5);
    freq.put(" Ni", 26);
    freq.put(" Nj", 27);
    freq.put(" No", 19);
    freq.put(" Na", 33);
    freq.put(" Ne", 54);
    freq.put(" Nd", 17);
    freq.put(" Ng", 9);
    freq.put(" Nx", 4);
    freq.put(" Np", 3);
    freq.put(" Nu", 42);
    freq.put("lln", 3);
    freq.put("tej", 13);
    freq.put("tek", 27);
    freq.put("tel", 44);
    freq.put("tem", 67);
    freq.put("ten", 92);
    freq.put("tea", 4);
    freq.put("ted", 7);
    freq.put("tee", 7);
    freq.put("teg", 7);
    freq.put("tex", 3);
    freq.put("tez", 8);
    freq.put("nbo", 8);
    freq.put("tep", 20);
    freq.put("nba", 4);
    freq.put("tes", 93);
    freq.put("tet", 163);
    freq.put("lla", 237);
    freq.put("nbe", 3);
    freq.put("suf", 5);
    freq.put("sue", 5);
    freq.put("sub", 3);
    freq.put("sua", 11);
    freq.put("sun", 13);
    freq.put("sum", 9);
    freq.put("sul", 13);
    freq.put("suk", 7);
    freq.put("sut", 4);
    freq.put("sus", 12);
    freq.put("sur", 21);
    freq.put("sup", 3);
    freq.put("ËR ", 5);
    freq.put("te ", 700);
    freq.put("sbb", 3);
    freq.put(" Në", 21);
    freq.put("su ", 20);
    freq.put("ya ", 9);
    freq.put("rku", 26);
    freq.put("rkq", 6);
    freq.put("rkr", 6);
    freq.put("Top", 7);
    freq.put("Tot", 3);
    freq.put("rke", 10);
    freq.put("rka", 8);
    freq.put("rko", 33);
    freq.put("rki", 9);
    freq.put("rkk", 3);
    freq.put("In ", 3);
    freq.put("rk ", 10);
    freq.put("To ", 3);
    freq.put("Int", 11);
    freq.put("avo", 20);
    freq.put("v", 1849);
    freq.put("Ind", 5);
    freq.put("zja", 6);
    freq.put("ave", 56);
    freq.put("lh ", 4);
    freq.put("Qyt", 5);
    freq.put("Qys", 11);
    freq.put("WC ", 3);
    freq.put("lha", 4);
    freq.put(" së", 38);
    freq.put("ë ", 1475);
    freq.put("izë", 3);
    freq.put("yn ", 17);
    freq.put("L", 386);
    freq.put("Erz", 3);
    freq.put("Eri", 3);
    freq.put("Rad", 4);
    freq.put("ëg", 3);
    freq.put("ëf", 3);
    freq.put("ëd", 3);
    freq.put("ëk", 7);
    freq.put("ëj", 10);
    freq.put("Ram", 21);
    freq.put("ën", 189);
    freq.put("ëm", 46);
    freq.put("ël", 21);
    freq.put("ës", 269);
    freq.put("ër", 352);
    freq.put("ëp", 11);
    freq.put("ëv", 48);
    freq.put("Rap", 3);
    freq.put("ët", 88);
    freq.put("ëz", 22);
    freq.put("ynv", 5);
    freq.put(" sy", 27);
    freq.put("Mus", 11);
    freq.put(" sr", 7);
    freq.put(" sp", 79);
    freq.put(" sq", 5);
    freq.put(" sv", 5);
    freq.put(" st", 55);
    freq.put(" su", 54);
    freq.put(" sj", 50);
    freq.put(" sk", 84);
    freq.put(" sh", 1038);
    freq.put(" si", 195);
    freq.put(" sn", 6);
    freq.put(" so", 119);
    freq.put(" sl", 10);
    freq.put(" sm", 31);
    freq.put(" sb", 9);
    freq.put("Mul", 3);
    freq.put(" sa", 148);
    freq.put(" sf", 4);
    freq.put(" sg", 6);
    freq.put(" sd", 28);
    freq.put(" se", 463);
    freq.put("iza", 39);
    freq.put("ize", 6);
    freq.put("gur", 19);
    freq.put("izi", 22);
    freq.put("izj", 5);
    freq.put("izl", 5);
    freq.put("izn", 6);
    freq.put("izo", 9);
    freq.put("izu", 11);
    freq.put("izz", 5);
    freq.put("JT ", 3);
    freq.put("koi", 6);
    freq.put("koh", 65);
    freq.put("kok", 15);
    freq.put("Mu ", 8);
    freq.put("kom", 160);
    freq.put(" s ", 70);
    freq.put("iz ", 6);
    freq.put("koo", 6);
    freq.put("kon", 179);
    freq.put("X ", 23);
    freq.put("kof", 4);
    freq.put("zën", 4);
    freq.put("bja", 5);
    freq.put("Res", 6);
    freq.put("koq", 4);
    freq.put("kop", 10);
    freq.put("kos", 55);
    freq.put("Nur", 5);
    freq.put("Nuk", 33);
    freq.put("aKo", 4);
    freq.put("kov", 25);
    freq.put("js ", 4);
    freq.put("efq", 5);
    freq.put("eft", 3);
    freq.put("efi", 17);
    freq.put("aKe", 4);
    freq.put("efo", 9);
    freq.put("efa", 7);
    freq.put("efe", 11);
    freq.put("eff", 3);
    freq.put("jse", 18);
    freq.put("jsh", 32);
    freq.put("Zek", 9);
    freq.put("Zen", 3);
    freq.put("Zem", 8);
    freq.put("Zeq", 5);
    freq.put("ef ", 25);
    freq.put("rte", 59);
    freq.put("yR", 4);
    freq.put("rta", 47);
    freq.put("rtm", 7);
    freq.put("rto", 15);
    freq.put("cdo", 4);
    freq.put("rti", 66);
    freq.put("rth", 5);
    freq.put("rtu", 20);
    freq.put("rtt", 3);
    freq.put("rtp", 3);
    freq.put("rtr", 3);
    freq.put("arë", 53);
    freq.put("rty", 3);
    freq.put("Ju", 29);
    freq.put("Jv", 3);
    freq.put("ier", 10);
    freq.put("IA ", 5);
    freq.put("Jr", 3);
    freq.put("Jn", 6);
    freq.put("Jo", 27);
    freq.put("iem", 4);
    freq.put("iel", 20);
    freq.put("Jk", 3);
    freq.put("Je", 36);
    freq.put("iec", 13);
    freq.put("ieb", 9);
    freq.put("Ja", 51);
    freq.put("Jc", 3);
    freq.put("hip", 9);
    freq.put("hiq", 27);
    freq.put("hir", 55);
    freq.put("his", 17);
    freq.put("hit", 54);
    freq.put("hiu", 5);
    freq.put("hiv", 3);
    freq.put("hia", 10);
    freq.put("b", 1956);
    freq.put("hid", 9);
    freq.put("hie", 4);
    freq.put("hif", 4);
    freq.put("hih", 23);
    freq.put("hii", 13);
    freq.put("hij", 8);
    freq.put("hik", 23);
    freq.put("hil", 20);
    freq.put("him", 67);
    freq.put("hin", 80);
    freq.put(" Pë", 12);
    freq.put("ie ", 36);
    freq.put("J ", 35);
    freq.put("arr", 133);
    freq.put("ars", 29);
    freq.put("art", 90);
    freq.put("aru", 13);
    freq.put("arz", 6);
    freq.put("rtë", 8);
    freq.put("ara", 134);
    freq.put("arb", 12);
    freq.put("arc", 31);
    freq.put("ard", 84);
    freq.put("are", 159);
    freq.put("arf", 3);
    freq.put("arg", 43);
    freq.put("ari", 156);
    freq.put("arj", 17);
    freq.put("ark", 16);
    freq.put("arl", 15);
    freq.put("uu ", 22);
    freq.put("arn", 8);
    freq.put("aro", 18);
    freq.put("arR", 3);
    freq.put("al ", 129);
    freq.put(" P ", 54);
    freq.put("uuu", 31);
    freq.put("uur", 5);
    freq.put("ar ", 296);
    freq.put(" xn", 3);
    freq.put(" Ps", 10);
    freq.put(" Pr", 56);
    freq.put("c", 1763);
    freq.put(" Pu", 10);
    freq.put("oT ", 3);
    freq.put(" Py", 3);
    freq.put(" Pa", 73);
    freq.put(" Pe", 57);
    freq.put(" Pj", 3);
    freq.put(" Pi", 8);
    freq.put(" Ph", 4);
    freq.put(" Po", 57);
    freq.put(" Pn", 4);
    freq.put(" Pl", 12);
    freq.put("pY", 3);
    freq.put("pB", 3);
    freq.put("pC", 4);
    freq.put("pA", 5);
    freq.put("pG", 3);
    freq.put("pD", 3);
    freq.put("pE", 4);
    freq.put("pM", 3);
    freq.put("pr", 326);
    freq.put("ps", 99);
    freq.put("pp", 17);
    freq.put("duk", 36);
    freq.put("pv", 5);
    freq.put("dum", 3);
    freq.put("pt", 125);
    freq.put("pu", 137);
    freq.put("pz", 4);
    freq.put("dua", 30);
    freq.put("py", 16);
    freq.put("swe", 3);
    freq.put("due", 3);
    freq.put("pc", 6);
    freq.put("pa", 607);
    freq.put("pf", 5);
    freq.put("pg", 5);
    freq.put("pd", 3);
    freq.put("pe", 752);
    freq.put("pj", 48);
    freq.put("pk", 6);
    freq.put("dur", 17);
    freq.put("pi", 250);
    freq.put("pn", 15);
    freq.put("po", 701);
    freq.put("pl", 101);
    freq.put("pm", 3);
    freq.put("Emi", 8);
    freq.put("tg ", 4);
    freq.put("Emr", 4);
    freq.put("du ", 36);
    freq.put("p ", 1065);
    freq.put("riz", 20);
    freq.put("riv", 11);
    freq.put("rit", 201);
    freq.put("riu", 13);
    freq.put("ris", 106);
    freq.put("rip", 9);
    freq.put("riq", 6);
    freq.put("rin", 178);
    freq.put("rio", 27);
    freq.put("ril", 10);
    freq.put("rim", 109);
    freq.put("rij", 5);
    freq.put("nBu", 3);
    freq.put("rih", 19);
    freq.put("rii", 9);
    freq.put("rif", 20);
    freq.put("rig", 27);
    freq.put("rid", 18);
    freq.put("rie", 13);
    freq.put("ric", 12);
    freq.put("ria", 90);
    freq.put("qat", 52);
    freq.put("qaq", 11);
    freq.put("qas", 17);
    freq.put("qar", 15);
    freq.put("pë", 211);
    freq.put("qao", 3);
    freq.put("qan", 4);
    freq.put("qaj", 16);
    freq.put("Ili", 5);
    freq.put("Coc", 3);
    freq.put("Ti ", 10);
    freq.put("eku", 18);
    freq.put("ri ", 371);
    freq.put("qa ", 37);
    freq.put("Ai ", 12);
    freq.put("aç ", 4);
    freq.put("Ain", 6);
    freq.put("açi", 9);
    freq.put("lja", 17);
    freq.put("lje", 25);
    freq.put("zz ", 5);
    freq.put("zzo", 3);
    freq.put("xën", 3);
    freq.put("zza", 8);
    freq.put("Rom", 6);
    freq.put("Ron", 18);
    freq.put("aMa", 4);
    freq.put("Rob", 5);
    freq.put("aMe", 5);
    freq.put("Roz", 3);
    freq.put("yle", 3);
    freq.put("yla", 9);
    freq.put("yll", 7);
    freq.put("aMu", 3);
    freq.put("yli", 4);
    freq.put(" uz", 3);
    freq.put(" uu", 5);
    freq.put(" ur", 33);
    freq.put(" us", 11);
    freq.put(" ul", 10);
    freq.put(" um", 11);
    freq.put(" un", 138);
    freq.put(" ui", 4);
    freq.put(" uj", 9);
    freq.put(" ud", 6);
    freq.put(" ue", 4);
    freq.put(" ua", 4);
    freq.put("xu ", 9);
    freq.put("Sum", 3);
    freq.put("Sul", 3);
    freq.put("aKr", 6);
    freq.put(" u ", 122);
    freq.put("ca ", 45);
    freq.put("z", 1073);
    freq.put("▌", 5);
    freq.put("gru", 17);
    freq.put("gre", 19);
    freq.put("gra", 50);
    freq.put("gro", 4);
    freq.put("gri", 15);
    freq.put("QZ ", 4);
    freq.put("gr ", 3);
    freq.put("ojv", 4);
    freq.put("eda", 9);
    freq.put("rrë", 31);
    freq.put("ede", 6);
    freq.put("edj", 12);
    freq.put("edh", 321);
    freq.put("edi", 43);
    freq.put("LA ", 7);
    freq.put("edo", 37);
    freq.put("edr", 9);
    freq.put("edu", 3);
    freq.put("Ham", 7);
    freq.put("Ky ", 4);
    freq.put("ed ", 16);
    freq.put("jqi", 8);
    freq.put("hkë", 12);
    freq.put("car", 9);
    freq.put("rro", 46);
    freq.put("rrj", 13);
    freq.put("rri", 93);
    freq.put("rre", 90);
    freq.put("rrc", 3);
    freq.put("rra", 37);
    freq.put("cfa", 6);
    freq.put("rrz", 4);
    freq.put("rry", 17);
    freq.put("rru", 38);
    freq.put("rrr", 21);
    freq.put("ojm", 37);
    freq.put("mën", 4);
    freq.put("mëk", 4);
    freq.put("mës", 12);
    freq.put("mër", 19);
    freq.put("hkr", 40);
    freq.put("rr ", 120);
    freq.put("hki", 12);
    freq.put("hko", 115);
    freq.put("hkl", 6);
    freq.put("hka", 53);
    freq.put("hke", 20);
    freq.put("më ", 102);
    freq.put("Un", 32);
    freq.put("sat", 14);
    freq.put("apr", 9);
    freq.put("aps", 6);
    freq.put("app", 3);
    freq.put("apt", 3);
    freq.put("apu", 8);
    freq.put("api", 19);
    freq.put("apo", 33);
    freq.put("apl", 6);
    freq.put("NT ", 3);
    freq.put("apa", 13);
    freq.put("Mil", 26);
    freq.put("use", 15);
    freq.put("fee", 3);
    freq.put("usa", 11);
    freq.put("fen", 13);
    freq.put("Hum", 5);
    freq.put("usm", 3);
    freq.put("fem", 37);
    freq.put("fej", 5);
    freq.put("fek", 3);
    freq.put("usi", 14);
    freq.put("ush", 211);
    freq.put(" çf", 5);
    freq.put("Mia", 4);
    freq.put("fet", 7);
    freq.put("ust", 26);
    freq.put("siç", 3);
    freq.put("fes", 22);
    freq.put(" ça", 3);
    freq.put(" çk", 3);
    freq.put("ap ", 35);
    freq.put(" Ru", 9);
    freq.put("fe ", 8);
    freq.put(" Rr", 16);
    freq.put(" Re", 52);
    freq.put(" Ra", 29);
    freq.put(" Ro", 30);
    freq.put(" Ri", 31);
    freq.put("tat", 59);
    freq.put("tav", 10);
    freq.put("tap", 3);
    freq.put("taq", 3);
    freq.put("tar", 199);
    freq.put("tas", 97);
    freq.put("tay", 4);
    freq.put("taz", 6);
    freq.put("tad", 8);
    freq.put("taf", 8);
    freq.put("tag", 7);
    freq.put("taa", 8);
    freq.put("tab", 10);
    freq.put("tac", 4);
    freq.put("tal", 29);
    freq.put("tam", 11);
    freq.put("tan", 46);
    freq.put("tah", 13);
    freq.put("Mis", 5);
    freq.put("taj", 19);
    freq.put("tak", 18);
    freq.put("sis", 26);
    freq.put("sir", 6);
    freq.put(" ou", 3);
    freq.put("siv", 6);
    freq.put("taR", 7);
    freq.put("taS", 15);
    freq.put("taZ", 5);
    freq.put("Mit", 6);
    freq.put("taD", 4);
    freq.put("sia", 15);
    freq.put("sig", 11);
    freq.put("taA", 5);
    freq.put("taB", 3);
    freq.put("sid", 17);
    freq.put("sik", 21);
    freq.put("taM", 4);
    freq.put("sii", 7);
    freq.put("sih", 3);
    freq.put("sio", 26);
    freq.put("taI", 5);
    freq.put("sim", 41);
    freq.put("sil", 7);
    freq.put("ta ", 376);
    freq.put("Eks", 3);
    freq.put("si ", 245);
    freq.put("Pr ", 3);
    freq.put("byt", 3);
    freq.put("byl", 4);
    freq.put("Cas", 9);
    freq.put("Car", 3);
    freq.put("Can", 3);
    freq.put("Ibr", 8);
    freq.put("Pre", 24);
    freq.put("nfe", 7);
    freq.put("Pra", 3);
    freq.put("nfb", 7);
    freq.put("nfo", 11);
    freq.put("Pro", 4);
    freq.put("nfl", 3);
    freq.put("Pri", 27);
    freq.put("nfi", 9);
    freq.put("nfu", 8);
    freq.put("hH ", 3);
    freq.put("by ", 3);
    freq.put("▀▀▀", 27);
    freq.put("oun", 4);
    freq.put("our", 4);
    freq.put("out", 12);
    freq.put("vci", 5);
    freq.put("AX ", 3);
    freq.put("lt ", 9);
    freq.put("ouT", 4);
    freq.put("vaj", 9);
    freq.put("ou ", 9);
    freq.put("ltr", 7);
    freq.put("ltu", 4);
    freq.put("Te ", 16);
    freq.put("lta", 10);
    freq.put("lte", 4);
    freq.put("lti", 13);
    freq.put("lto", 4);
    freq.put("ü", 3);
    freq.put("ugë", 4);
    freq.put("K ", 66);
    freq.put("aS ", 3);
    freq.put("Kc", 3);
    freq.put("Kb", 5);
    freq.put("Ka", 76);
    freq.put("Kf", 6);
    freq.put("Ke", 31);
    freq.put("Kd", 3);
    freq.put("Kj", 6);
    freq.put("Ki", 24);
    freq.put("Kh", 8);
    freq.put("Ko", 169);
    freq.put("Km", 3);
    freq.put("Kl", 14);
    freq.put("Ks", 4);
    freq.put("Kr", 65);
    freq.put("Ku", 95);
    freq.put("Kt", 5);
    freq.put("Ky", 7);
    freq.put("aSa", 7);
    freq.put("aSe", 5);
    freq.put("aSh", 14);
    freq.put("ybe", 7);
    freq.put("ojë", 16);
    freq.put("Po ", 24);
    freq.put("Kë", 6);
    freq.put("hw", 5);
    freq.put("ht", 1578);
    freq.put("Por", 9);
    freq.put("Pos", 4);
    freq.put("Pol", 12);
    freq.put("Cha", 11);
    freq.put("NI ", 7);
    freq.put("Che", 8);
    freq.put("ha", 1728);
    freq.put(" w ", 8);
    freq.put("hf", 18);
    freq.put("hg", 11);
    freq.put("q ", 350);
    freq.put("TH ", 5);
    freq.put("qQ", 3);
    freq.put(" wG", 4);
    freq.put("qS", 3);
    freq.put("qT", 3);
    freq.put("qV", 3);
    freq.put("qG", 4);
    freq.put("qF", 4);
    freq.put("qJ", 5);
    freq.put("qq", 14);
    freq.put("qp", 3);
    freq.put(" wd", 3);
    freq.put(" we", 11);
    freq.put("qu", 62);
    freq.put("qt", 21);
    freq.put(" wa", 6);
    freq.put("qy", 148);
    freq.put(" wo", 5);
    freq.put(" wl", 3);
    freq.put(" wi", 8);
    freq.put("qa", 160);
    freq.put("qc", 3);
    freq.put("Jam", 7);
    freq.put("qe", 657);
    freq.put("qd", 9);
    freq.put("qf", 33);
    freq.put("qi", 453);
    freq.put("qh", 6);
    freq.put("qk", 91);
    freq.put("qj", 13);
    freq.put("qm", 11);
    freq.put("ql", 8);
    freq.put("qo", 30);
    freq.put("Jak", 5);
    freq.put("ebe", 9);
    freq.put("eba", 8);
    freq.put("RN ", 5);
    freq.put("ebi", 4);
    freq.put("jo ", 190);
    freq.put("ebu", 6);
    freq.put("sL ", 3);
    freq.put("sot", 49);
    freq.put("hN", 4);
    freq.put("jor", 7);
    freq.put("jos", 4);
    freq.put("eb ", 7);
    freq.put("jof", 15);
    freq.put("joh", 16);
    freq.put("joj", 10);
    freq.put("jol", 17);
    freq.put("jom", 67);
    freq.put("jon", 68);
    freq.put("joo", 7);
    freq.put("Zan", 7);
    freq.put("Zat", 4);
    freq.put("rpa", 8);
    freq.put("avë", 6);
    freq.put("rpi", 16);
    freq.put("hm ", 3);
    freq.put("rpl", 5);
    freq.put("Jus", 5);
    freq.put("Juv", 6);
    freq.put("IE ", 3);
    freq.put("hmu", 5);
    freq.put("hmm", 4);
    freq.put("hmo", 27);
    freq.put("hmi", 11);
    freq.put("hmj", 3);
    freq.put("hme", 60);
    freq.put("hma", 5);
    freq.put("Ju ", 9);
    freq.put("é", 4);
    freq.put("bb ", 6);
    freq.put(" Të", 14);
    freq.put("tja", 30);
    freq.put("AR ", 11);
    freq.put("noo", 6);
    freq.put("avi", 13);
    freq.put("tje", 138);
    freq.put("ava", 24);
    freq.put("uqi", 13);
    freq.put(" T ", 16);
    freq.put("hmë", 4);
    freq.put("av ", 21);
    freq.put(" Tz", 3);
    freq.put(" Ty", 3);
    freq.put(" Tw", 8);
    freq.put("uq ", 5);
    freq.put(" Tu", 14);
    freq.put(" Tr", 33);
    freq.put(" To", 18);
    freq.put(" Tj", 5);
    freq.put(" Ti", 24);
    freq.put(" Th", 41);
    freq.put("tju", 5);
    freq.put(" Te", 54);
    freq.put(" Ta", 34);
    freq.put("mfa", 3);
    freq.put("tch", 6);
    freq.put("sku", 6);
    freq.put("skr", 3);
    freq.put("Faq", 4);
    freq.put("sky", 3);
    freq.put("Fat", 12);
    freq.put("ske", 16);
    freq.put("Fai", 4);
    freq.put("ska", 68);
    freq.put("nor", 28);
    freq.put("Fal", 11);
    freq.put("Fac", 14);
    freq.put("sko", 10);
    freq.put("ski", 23);
    freq.put("T", 500);
    freq.put("ndë", 43);
    freq.put("sk ", 6);
    freq.put("Sue", 4);
    freq.put("qee", 5);
    freq.put("qed", 23);
    freq.put("qef", 28);
    freq.put("qeh", 3);
    freq.put("qek", 10);
    freq.put("qej", 6);
    freq.put("qel", 14);
    freq.put("qen", 52);
    freq.put("qes", 26);
    freq.put("qer", 14);
    freq.put("qet", 72);
    freq.put("qev", 5);
    freq.put("nd ", 101);
    freq.put("qe ", 388);
    freq.put("ndA", 3);
    freq.put("ndi", 114);
    freq.put("ndk", 3);
    freq.put("ndj", 34);
    freq.put("ndo", 97);
    freq.put("nda", 96);
    freq.put("nde", 163);
    freq.put("ndd", 4);
    freq.put("nds", 12);
    freq.put("ndr", 102);
    freq.put("ndu", 23);
    freq.put("own", 3);
    freq.put("owi", 3);
    freq.put("owe", 4);
    freq.put("ows", 3);
    freq.put("Ami", 6);
    freq.put("vak", 3);
    freq.put("van", 11);
    freq.put("val", 40);
    freq.put("Ama", 6);
    freq.put("Amb", 3);
    freq.put("vaz", 21);
    freq.put("Afe", 3);
    freq.put("var", 39);
    freq.put("vas", 6);
    freq.put("vat", 9);
    freq.put("Gjy", 9);
    freq.put("Gju", 3);
    freq.put("ow ", 15);
    freq.put("Gji", 12);
    freq.put("Gje", 9);
    freq.put("Gja", 15);
    freq.put("Tel", 7);
    freq.put("Tea", 4);
    freq.put("va ", 129);
    freq.put("lve", 4);
    freq.put("lva", 3);
    freq.put("Tet", 11);
    freq.put("Teu", 6);
    freq.put("Tev", 3);
    freq.put("në ", 400);
    freq.put("mys", 4);
    freq.put("myt", 12);
    freq.put("lm ", 16);
    freq.put("zvi", 5);
    freq.put("zve", 5);
    freq.put("nën", 28);
    freq.put("nës", 27);
    freq.put("nët", 10);
    freq.put("nëv", 3);
    freq.put("my ", 5);
  }
  
}

