package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class SV {
  private static final String name = "sv";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public SV() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 2530426;
    n_words[1] = 3087909;
    n_words[2] = 2457504;

    freq.put("xtr", 199);
    freq.put("xte", 95);
    freq.put("mle", 69);
    freq.put("xt ", 98);
    freq.put("HL ", 27);
    freq.put("Jäm", 35);
    freq.put("Jät", 40);
    freq.put("Jäv", 66);
    freq.put(" yn", 35);
    freq.put(" yo", 125);
    freq.put("k", 80261);
    freq.put(" ye", 68);
    freq.put(" yr", 37);
    freq.put(" yt", 85);
    freq.put("Lä", 509);
    freq.put("Lå", 193);
    freq.put("aul", 31);
    freq.put("Lö", 126);
    freq.put("äla", 75);
    freq.put("dna", 147);
    freq.put("älf", 68);
    freq.put("äle", 31);
    freq.put("äld", 492);
    freq.put("älk", 176);
    freq.put("älj", 406);
    freq.put("dni", 694);
    freq.put("äll", 3118);
    freq.put("äls", 576);
    freq.put("älp", 307);
    freq.put("älv", 882);
    freq.put("ält", 206);
    freq.put("Gär", 28);
    freq.put("äl ", 870);
    freq.put("Le", 270);
    freq.put("La", 339);
    freq.put("Lo", 256);
    freq.put("Lj", 42);
    freq.put("Li", 771);
    freq.put("Lu", 260);
    freq.put("Ly", 236);
    freq.put("hoc", 131);
    freq.put("hon", 971);
    freq.put("hoo", 70);
    freq.put("hol", 608);
    freq.put("hom", 78);
    freq.put("hok", 84);
    freq.put("hov", 71);
    freq.put("how", 57);
    freq.put("hot", 178);
    freq.put("hou", 34);
    freq.put("hor", 94);
    freq.put("hos", 323);
    freq.put("hop", 855);
    freq.put("A", 3958);
    freq.put("L ", 285);
    freq.put("Ö", 356);
    freq.put("ho ", 68);
    freq.put(" V ", 49);
    freq.put("fir", 126);
    freq.put("fis", 145);
    freq.put("rö", 1989);
    freq.put("Hit", 94);
    freq.put("fit", 78);
    freq.put("smö", 103);
    freq.put("fix", 182);
    freq.put("rä", 3620);
    freq.put("fic", 592);
    freq.put("fia", 26);
    freq.put("fig", 45);
    freq.put("fie", 74);
    freq.put("fik", 346);
    freq.put("små", 207);
    freq.put("smä", 165);
    freq.put("fin", 1649);
    freq.put("ré", 40);
    freq.put("fil", 629);
    freq.put(" Va", 1683);
    freq.put(" Ve", 496);
    freq.put(" Vi", 1721);
    freq.put(" Vo", 65);
    freq.put("ews", 47);
    freq.put("atö", 63);
    freq.put("fi ", 112);
    freq.put("mda", 43);
    freq.put("mde", 133);
    freq.put("upa", 42);
    freq.put("rt", 7440);
    freq.put("ru", 2745);
    freq.put("rv", 1197);
    freq.put("rw", 43);
    freq.put("rp", 327);
    freq.put("rr", 2308);
    freq.put("rs", 6673);
    freq.put("dsv", 90);
    freq.put("dst", 167);
    freq.put("dsr", 42);
    freq.put("ry", 1611);
    freq.put("dsp", 75);
    freq.put("rd", 4187);
    freq.put("re", 15194);
    freq.put("rf", 1409);
    freq.put("rg", 2762);
    freq.put("dsj", 37);
    freq.put("ra", 23879);
    freq.put("rb", 1569);
    freq.put("rc", 168);
    freq.put("rl", 2373);
    freq.put("rm", 1604);
    freq.put("rn", 5564);
    freq.put("dse", 107);
    freq.put("rh", 505);
    freq.put("ri", 10600);
    freq.put("rj", 1371);
    freq.put("rk", 3644);
    freq.put(" Vå", 104);
    freq.put(" Vä", 569);
    freq.put("md ", 58);
    freq.put("sys", 244);
    freq.put("ate", 816);
    freq.put("atc", 411);
    freq.put("ata", 1109);
    freq.put("ato", 340);
    freq.put("atl", 69);
    freq.put("atm", 29);
    freq.put("ath", 73);
    freq.put("ati", 1445);
    freq.put("att", 14797);
    freq.put("atu", 280);
    freq.put("r ", 92666);
    freq.put("upp", 2501);
    freq.put("ds ", 405);
    freq.put("sm ", 108);
    freq.put("Swe", 57);
    freq.put("kfi", 28);
    freq.put("xig", 51);
    freq.put("Cen", 49);
    freq.put("xis", 38);
    freq.put("vgö", 39);
    freq.put("Du ", 584);
    freq.put("xi ", 47);
    freq.put("Sof", 36);
    freq.put("kfö", 37);
    freq.put("fäl", 148);
    freq.put("hug", 28);
    freq.put("Son", 27);
    freq.put("Ass", 58);
    freq.put("vgi", 30);
    freq.put("fär", 476);
    freq.put("mlö", 29);
    freq.put("lp ", 163);
    freq.put("knu", 30);
    freq.put("lpt", 31);
    freq.put("lpr", 34);
    freq.put("lpl", 30);
    freq.put("lpe", 68);
    freq.put("lpa", 80);
    freq.put("hus", 315);
    freq.put("yfa", 34);
    freq.put("yfi", 59);
    freq.put("yft", 114);
    freq.put("yfs", 26);
    freq.put("X", 120);
    freq.put("Lju", 40);
    freq.put("Ris", 31);
    freq.put("Rin", 45);
    freq.put("Rik", 84);
    freq.put("Ric", 30);
    freq.put("PS ", 30);
    freq.put("irr", 170);
    freq.put("irt", 44);
    freq.put("iri", 53);
    freq.put("irk", 59);
    freq.put("irl", 42);
    freq.put("irm", 30);
    freq.put("iro", 53);
    freq.put("Tri", 55);
    freq.put("ira", 258);
    freq.put("ire", 309);
    freq.put("DM ", 41);
    freq.put("ir ", 1342);
    freq.put("and", 5547);
    freq.put("fra", 771);
    freq.put("fre", 353);
    freq.put("fri", 490);
    freq.put("fro", 81);
    freq.put("Lån", 35);
    freq.put("Låt", 146);
    freq.put("fru", 316);
    freq.put("fry", 42);
    freq.put("ann", 1697);
    freq.put("pri", 712);
    freq.put("ää", 264);
    freq.put("ant", 1487);
    freq.put("fr ", 34);
    freq.put("Upp", 209);
    freq.put("bå", 305);
    freq.put("bil", 1329);
    freq.put("ä ", 399);
    freq.put("änd", 2076);
    freq.put("äng", 1881);
    freq.put("äna", 285);
    freq.put("ado", 65);
    freq.put("frå", 2394);
    freq.put("frä", 96);
    freq.put("änl", 42);
    freq.put("dhe", 28);
    freq.put("änn", 2283);
    freq.put("äni", 214);
    freq.put("änh", 28);
    freq.put("änk", 1421);
    freq.put("änt", 860);
    freq.put("äns", 594);
    freq.put("än", 11147);
    freq.put("äl", 7291);
    freq.put("äm", 1579);
    freq.put("äk", 1114);
    freq.put("äh", 59);
    freq.put("äf", 453);
    freq.put("äg", 2967);
    freq.put("jkv", 37);
    freq.put("äe", 36);
    freq.put("äb", 28);
    freq.put("äc", 703);
    freq.put("äx", 206);
    freq.put("äv", 1488);
    freq.put("jke", 26);
    freq.put("ät", 3976);
    freq.put("är", 24464);
    freq.put("äs", 3377);
    freq.put("äp", 371);
    freq.put("än ", 1358);
    freq.put("ED ", 28);
    freq.put("hah", 1255);
    freq.put("hai", 49);
    freq.put("haj", 30);
    freq.put("hak", 41);
    freq.put("hal", 482);
    freq.put("ham", 246);
    freq.put("han", 2458);
    freq.put("haa", 42);
    freq.put("hac", 51);
    freq.put("had", 912);
    freq.put("haf", 198);
    freq.put("hag", 57);
    freq.put("hap", 39);
    freq.put("har", 5393);
    freq.put("has", 61);
    freq.put("hat", 364);
    freq.put("hau", 31);
    freq.put("hav", 62);
    freq.put("kön", 461);
    freq.put("köl", 28);
    freq.put("kök", 77);
    freq.put("köt", 166);
    freq.put("kör", 556);
    freq.put("köp", 708);
    freq.put("d", 96689);
    freq.put("ha ", 2653);
    freq.put("ola", 654);
    freq.put("old", 91);
    freq.put("ole", 208);
    freq.put("olf", 62);
    freq.put("oli", 1270);
    freq.put("olj", 26);
    freq.put("olk", 707);
    freq.put("oll", 1741);
    freq.put("olm", 472);
    freq.put("oln", 54);
    freq.put("olo", 227);
    freq.put("ols", 91);
    freq.put("olt", 233);
    freq.put("olu", 184);
    freq.put("olv", 100);
    freq.put("oly", 133);
    freq.put("fot", 386);
    freq.put("umt", 61);
    freq.put("ump", 156);
    freq.put("for", 1062);
    freq.put("fos", 29);
    freq.put("jör", 139);
    freq.put("ume", 242);
    freq.put("Säg", 60);
    freq.put("uma", 33);
    freq.put("jön", 60);
    freq.put("jöl", 84);
    freq.put("fol", 626);
    freq.put("fon", 219);
    freq.put("jöd", 29);
    freq.put("ol ", 294);
    freq.put("o", 95997);
    freq.put("fo ", 90);
    freq.put("um ", 443);
    freq.put("jö ", 94);
    freq.put("mbl", 38);
    freq.put("soc", 187);
    freq.put("mbo", 105);
    freq.put("Usc", 32);
    freq.put("mbi", 100);
    freq.put("sof", 201);
    freq.put("mbe", 191);
    freq.put("som", 7549);
    freq.put("mba", 95);
    freq.put("son", 1193);
    freq.put("sop", 84);
    freq.put("sos", 38);
    freq.put("sor", 363);
    freq.put("sou", 30);
    freq.put("sov", 409);
    freq.put("mbu", 47);
    freq.put("äst", 2000);
    freq.put("äss", 158);
    freq.put("äsn", 113);
    freq.put("äso", 138);
    freq.put("äsk", 148);
    freq.put("äse", 189);
    freq.put("äsc", 36);
    freq.put("äsa", 322);
    freq.put("so ", 70);
    freq.put("azi", 43);
    freq.put("azz", 29);
    freq.put("äs ", 187);
    freq.put("Sis", 67);
    freq.put("Sir", 26);
    freq.put("Sit", 132);
    freq.put("khu", 46);
    freq.put("kho", 357);
    freq.put("tea", 83);
    freq.put("kha", 34);
    freq.put("khe", 33);
    freq.put("Sim", 47);
    freq.put("Sil", 35);
    freq.put("E", 2959);
    freq.put("Ido", 30);
    freq.put("tec", 129);
    freq.put("Ida", 308);
    freq.put("lr ", 60);
    freq.put("Str", 130);
    freq.put("oss", 557);
    freq.put("ost", 790);
    freq.put("osv", 109);
    freq.put("osi", 130);
    freq.put("osh", 40);
    freq.put("osk", 71);
    freq.put("oso", 75);
    freq.put("osa", 120);
    freq.put("ose", 150);
    freq.put("ögl", 33);
    freq.put("vet", 1860);
    freq.put("ögo", 165);
    freq.put("ver", 4355);
    freq.put("ves", 84);
    freq.put("öge", 60);
    freq.put("öga", 98);
    freq.put("veg", 37);
    freq.put("ved", 57);
    freq.put("Ta ", 67);
    freq.put("vec", 775);
    freq.put("ögt", 85);
    freq.put("vel", 175);
    freq.put("vem", 273);
    freq.put("vek", 58);
    freq.put("ögr", 48);
    freq.put("ögs", 108);
    freq.put("lra", 45);
    freq.put("Mä", 105);
    freq.put("lre", 74);
    freq.put("lri", 53);
    freq.put("Mö", 74);
    freq.put("os ", 570);
    freq.put("Tar", 73);
    freq.put("ög ", 106);
    freq.put("Tag", 29);
    freq.put("ve ", 359);
    freq.put("Tac", 599);
    freq.put("Tal", 36);
    freq.put("Tan", 38);
    freq.put("M ", 423);
    freq.put("rmå", 31);
    freq.put("yd ", 36);
    freq.put("osä", 36);
    freq.put("Me", 1944);
    freq.put("ydl", 269);
    freq.put("Ma", 1531);
    freq.put("lrä", 59);
    freq.put("Mc", 33);
    freq.put("Mm", 54);
    freq.put("Mo", 418);
    freq.put("yde", 117);
    freq.put("Mi", 893);
    freq.put("Mj", 27);
    freq.put("Mu", 117);
    freq.put("Mv", 66);
    freq.put("uff", 203);
    freq.put("My", 182);
    freq.put("ipa", 47);
    freq.put("ipe", 48);
    freq.put("iph", 75);
    freq.put("ipl", 51);
    freq.put("ips", 474);
    freq.put("ipp", 441);
    freq.put("yga", 72);
    freq.put("ugn", 170);
    freq.put("ip ", 109);
    freq.put("Liv", 106);
    freq.put("så", 7621);
    freq.put("sä", 3191);
    freq.put("Lis", 39);
    freq.put("ST ", 47);
    freq.put("H", 7117);
    freq.put("s ", 21102);
    freq.put("sss", 27);
    freq.put("sy", 833);
    freq.put("ss", 6721);
    freq.put("sr", 349);
    freq.put("sq", 27);
    freq.put("sp", 3403);
    freq.put("sw", 57);
    freq.put("sv", 2559);
    freq.put("su", 1243);
    freq.put("st", 22986);
    freq.put("sk", 16391);
    freq.put("sj", 1666);
    freq.put("si", 5756);
    freq.put("sh", 931);
    freq.put("so", 10555);
    freq.put("sn", 2570);
    freq.put("sm", 1588);
    freq.put("sl", 3189);
    freq.put("sc", 834);
    freq.put("sb", 622);
    freq.put("sa", 8221);
    freq.put("sg", 275);
    freq.put("sf", 545);
    freq.put("se", 9076);
    freq.put("sd", 603);
    freq.put("tty", 26);
    freq.put("KA ", 33);
    freq.put("tts", 206);
    freq.put("ttr", 991);
    freq.put("ttp", 84);
    freq.put("ttv", 49);
    freq.put("ttk", 41);
    freq.put("ttj", 39);
    freq.put("tti", 676);
    freq.put("tth", 31);
    freq.put("tto", 148);
    freq.put("ttn", 296);
    freq.put("ttm", 36);
    freq.put("ttl", 98);
    freq.put("ttb", 54);
    freq.put("tta", 3415);
    freq.put("ttf", 82);
    freq.put("tte", 3156);
    freq.put("ssf", 43);
    freq.put("dju", 161);
    freq.put("blö", 58);
    freq.put("dja", 48);
    freq.put("dje", 135);
    freq.put("blå", 151);
    freq.put("blä", 41);
    freq.put("Ac", 47);
    freq.put("tt ", 20690);
    freq.put("äh ", 34);
    freq.put("Jos", 28);
    freq.put("blu", 36);
    freq.put("Job", 139);
    freq.put("bli", 2497);
    freq.put("djä", 26);
    freq.put("Joh", 142);
    freq.put("bla", 651);
    freq.put("Jon", 70);
    freq.put("bbe", 513);
    freq.put("Jo ", 148);
    freq.put("ÄR ", 112);
    freq.put("bl ", 41);
    freq.put("onk", 130);
    freq.put("oni", 168);
    freq.put("onn", 87);
    freq.put("ono", 509);
    freq.put("onl", 106);
    freq.put("onb", 136);
    freq.put("onc", 56);
    freq.put("ona", 322);
    freq.put("onf", 117);
    freq.put("ong", 350);
    freq.put("ond", 307);
    freq.put("one", 1571);
    freq.put("ony", 55);
    freq.put("ons", 1194);
    freq.put("onp", 42);
    freq.put("onv", 59);
    freq.put("ont", 828);
    freq.put("onu", 40);
    freq.put("ukt", 744);
    freq.put("uks", 30);
    freq.put("uko", 163);
    freq.put("Hmm", 65);
    freq.put("mkt", 169);
    freq.put("ukh", 46);
    freq.put("uke", 36);
    freq.put("ukd", 32);
    freq.put("uka", 290);
    freq.put(" Zl", 68);
    freq.put("bäs", 658);
    freq.put("ööö", 138);
    freq.put("on ", 4895);
    freq.put(" Za", 26);
    freq.put("bba", 746);
    freq.put("uk ", 189);
    freq.put("sak", 733);
    freq.put("saj", 50);
    freq.put("san", 967);
    freq.put("sam", 1696);
    freq.put("sal", 234);
    freq.put("sab", 26);
    freq.put("sag", 242);
    freq.put("saf", 34);
    freq.put("onä", 52);
    freq.put("sad", 331);
    freq.put("say", 31);
    freq.put("sas", 158);
    freq.put("sar", 949);
    freq.put("onö", 53);
    freq.put("sat", 713);
    freq.put("zon", 33);
    freq.put("ax ", 167);
    freq.put("sa ", 1919);
    freq.put("öör", 27);
    freq.put("ööf", 36);
    freq.put("axe", 26);
    freq.put("axi", 70);
    freq.put("Sku", 149);
    freq.put("Skr", 116);
    freq.put("Sky", 41);
    freq.put("Ske", 36);
    freq.put("Ska", 555);
    freq.put("Sko", 77);
    freq.put("Ski", 112);
    freq.put("Cyk", 36);
    freq.put("umö", 48);
    freq.put("ux", 113);
    freq.put(" bå", 266);
    freq.put(" bä", 1302);
    freq.put(" bö", 1171);
    freq.put("Skö", 150);
    freq.put("up", 3002);
    freq.put("Skå", 49);
    freq.put("Skä", 61);
    freq.put("cis", 548);
    freq.put(" b ", 37);
    freq.put("ul", 3611);
    freq.put("un", 5920);
    freq.put("vkl", 114);
    freq.put("SÅ ", 50);
    freq.put(" be", 2718);
    freq.put(" ba", 3479);
    freq.put(" bl", 3642);
    freq.put(" bo", 1987);
    freq.put(" bi", 1266);
    freq.put("kjo", 41);
    freq.put(" bj", 156);
    freq.put(" bu", 557);
    freq.put(" bt", 40);
    freq.put("s", 134928);
    freq.put("kju", 67);
    freq.put(" by", 417);
    freq.put("ivä", 70);
    freq.put("ivå", 72);
    freq.put("rå", 3729);
    freq.put("mpe", 197);
    freq.put("Nyh", 144);
    freq.put("ive", 978);
    freq.put("iva", 702);
    freq.put("ivl", 34);
    freq.put("ivn", 86);
    freq.put("ivo", 41);
    freq.put("ivi", 493);
    freq.put("ivt", 172);
    freq.put("ivs", 129);
    freq.put("iv ", 540);
    freq.put("I", 3430);
    freq.put("Mar", 265);
    freq.put("vux", 82);
    freq.put("gda", 51);
    freq.put("gde", 164);
    freq.put("två", 529);
    freq.put("tvä", 220);
    freq.put("gdo", 72);
    freq.put("fåt", 308);
    freq.put("får", 1566);
    freq.put("gd ", 96);
    freq.put(" gn", 65);
    freq.put("NA ", 37);
    freq.put(" gj", 529);
    freq.put("Mys", 33);
    freq.put("Myc", 103);
    freq.put("Sny", 54);
    freq.put("tvu", 57);
    freq.put("tvi", 290);
    freq.put("tve", 284);
    freq.put("tva", 29);
    freq.put("ac ", 65);
    freq.put("dds", 44);
    freq.put("ddi", 74);
    freq.put("ddn", 47);
    freq.put("dda", 723);
    freq.put("dde", 482);
    freq.put("Än", 141);
    freq.put("tv ", 182);
    freq.put("acc", 87);
    freq.put("ace", 379);
    freq.put("ack", 2377);
    freq.put("aci", 29);
    freq.put("ach", 101);
    freq.put("aco", 58);
    freq.put("act", 38);
    freq.put("dd ", 225);
    freq.put("Ni", 377);
    freq.put("Nj", 63);
    freq.put("No", 392);
    freq.put("Na", 189);
    freq.put("Ne", 532);
    freq.put("Äls", 105);
    freq.put("Ny", 515);
    freq.put("bju", 211);
    freq.put("Nu", 1074);
    freq.put("het", 1634);
    freq.put("her", 295);
    freq.put("hed", 50);
    freq.put("hee", 50);
    freq.put("hef", 159);
    freq.put("hea", 45);
    freq.put("hec", 62);
    freq.put("hel", 2158);
    freq.put("hem", 1220);
    freq.put("hen", 545);
    freq.put("heh", 140);
    freq.put("hej", 166);
    freq.put("N ", 603);
    freq.put("he ", 526);
    freq.put("aa", 735);
    freq.put("ohn", 50);
    freq.put("oho", 115);
    freq.put("ae", 142);
    freq.put("ad", 11141);
    freq.put("ag", 23383);
    freq.put("af", 1837);
    freq.put("ai", 559);
    freq.put("ah", 2366);
    freq.put("Hol", 65);
    freq.put("aj", 542);
    freq.put("Nä", 790);
    freq.put("Nå", 328);
    freq.put("ao", 106);
    freq.put("an", 32498);
    freq.put("ap", 2295);
    freq.put("as", 7970);
    freq.put("ar", 44652);
    freq.put("au", 420);
    freq.put("at", 24486);
    freq.put("aw", 134);
    freq.put("av", 5037);
    freq.put("ay", 418);
    freq.put("ax", 347);
    freq.put("az", 140);
    freq.put("Nö", 35);
    freq.put("a ", 62120);
    freq.put("oh ", 55);
    freq.put("smy", 54);
    freq.put("uit", 44);
    freq.put("smu", 80);
    freq.put("Fir", 32);
    freq.put("sco", 73);
    freq.put("sci", 49);
    freq.put("sch", 531);
    freq.put("sce", 65);
    freq.put("sms", 100);
    freq.put("sca", 53);
    freq.put("dss", 67);
    freq.put("mni", 111);
    freq.put("mna", 560);
    freq.put("Fin", 292);
    freq.put("mne", 191);
    freq.put("Fil", 71);
    freq.put("scr", 37);
    freq.put("smo", 81);
    freq.put("tz", 60);
    freq.put("dso", 63);
    freq.put("tv", 1613);
    freq.put("tw", 1063);
    freq.put("tt", 30338);
    freq.put(" e", 17099);
    freq.put("tr", 7734);
    freq.put("dsl", 107);
    freq.put("tp", 228);
    freq.put("tn", 800);
    freq.put("to", 5011);
    freq.put("tl", 1014);
    freq.put("dsm", 62);
    freq.put("tj", 828);
    freq.put("tk", 277);
    freq.put("th", 888);
    freq.put("ti", 16778);
    freq.put("tf", 666);
    freq.put("tg", 153);
    freq.put("td", 107);
    freq.put("te", 28634);
    freq.put("tb", 680);
    freq.put("tc", 577);
    freq.put("göt", 98);
    freq.put("dsk", 211);
    freq.put("smi", 169);
    freq.put("dsf", 83);
    freq.put("mn ", 316);
    freq.put("sme", 95);
    freq.put("ro", 6309);
    freq.put("dsb", 80);
    freq.put("sma", 409);
    freq.put("dsa", 66);
    freq.put("t ", 79959);
    freq.put("Sma", 36);
    freq.put("xor", 76);
    freq.put("tö", 772);
    freq.put("té", 26);
    freq.put("ågo", 1861);
    freq.put("tä", 3065);
    freq.put("tå", 1500);
    freq.put(" E", 2948);
    freq.put("vic", 103);
    freq.put("via", 296);
    freq.put("vig", 106);
    freq.put("vid", 974);
    freq.put("vik", 465);
    freq.put("vin", 1098);
    freq.put("vil", 2163);
    freq.put("vir", 87);
    freq.put("vis", 1288);
    freq.put("viv", 34);
    freq.put("vit", 598);
    freq.put("kl ", 248);
    freq.put("öks", 40);
    freq.put("ökt", 150);
    freq.put(" d ", 148);
    freq.put("ökn", 71);
    freq.put("öka", 382);
    freq.put("öke", 472);
    freq.put("vi ", 2305);
    freq.put(" do", 1320);
    freq.put("kle", 61);
    freq.put(" dj", 153);
    freq.put(" di", 2731);
    freq.put(" de", 18591);
    freq.put("klo", 233);
    freq.put("kli", 1242);
    freq.put(" da", 2233);
    freq.put("klu", 179);
    freq.put(" dy", 216);
    freq.put("ök ", 262);
    freq.put(" dv", 52);
    freq.put(" du", 4901);
    freq.put(" dr", 1039);
    freq.put("tsi", 68);
    freq.put("atr", 74);
    freq.put("ats", 820);
    freq.put("önk", 45);
    freq.put("yxo", 60);
    freq.put("klä", 326);
    freq.put(" då", 1852);
    freq.put(" dä", 1552);
    freq.put(" dö", 559);
    freq.put("ito", 37);
    freq.put("IP ", 26);
    freq.put("tål", 42);
    freq.put("itk", 27);
    freq.put("tån", 114);
    freq.put("iti", 620);
    freq.put("ite", 2616);
    freq.put("itb", 32);
    freq.put("itc", 34);
    freq.put("ita", 406);
    freq.put("ity", 88);
    freq.put("itt", 3991);
    freq.put("tås", 64);
    freq.put("tåt", 49);
    freq.put("its", 169);
    freq.put("åts", 64);
    freq.put("tå ", 188);
    freq.put("it ", 2215);
    freq.put("ht", 327);
    freq.put("tro", 1550);
    freq.put(" A ", 104);
    freq.put("MG ", 29);
    freq.put("fts", 60);
    freq.put("at ", 3937);
    freq.put("fta", 372);
    freq.put("fte", 1658);
    freq.put("kna", 1018);
    freq.put("fti", 72);
    freq.put("fto", 134);
    freq.put(" Aa", 33);
    freq.put(" Ab", 77);
    freq.put(" Ac", 47);
    freq.put(" Ad", 81);
    freq.put(" Af", 131);
    freq.put(" Ag", 38);
    freq.put(" Ah", 124);
    freq.put(" Ai", 29);
    freq.put(" Aj", 52);
    freq.put(" Ak", 43);
    freq.put(" Al", 943);
    freq.put(" Am", 103);
    freq.put(" An", 641);
    freq.put(" Ap", 141);
    freq.put(" Ar", 256);
    freq.put(" As", 127);
    freq.put(" At", 341);
    freq.put(" Au", 54);
    freq.put(" Av", 121);
    freq.put(" Ax", 27);
    freq.put("NG ", 57);
    freq.put("ft ", 468);
    freq.put("w", 3269);
    freq.put("vgå", 58);
    freq.put("Fra", 108);
    freq.put("Fre", 113);
    freq.put("uel", 130);
    freq.put("Fri", 94);
    freq.put("Fro", 29);
    freq.put("Fru", 46);
    freq.put("jer", 600);
    freq.put("jes", 56);
    freq.put("aa ", 172);
    freq.put("jet", 170);
    freq.put("äds", 40);
    freq.put("ädr", 57);
    freq.put("ädj", 86);
    freq.put("jea", 33);
    freq.put("jej", 261);
    freq.put("jek", 131);
    freq.put("äda", 110);
    freq.put("ädg", 32);
    freq.put("äde", 319);
    freq.put("ädd", 271);
    freq.put("aaa", 276);
    freq.put("tsd", 32);
    freq.put("aab", 53);
    freq.put("aan", 44);
    freq.put("åvä", 34);
    freq.put("aah", 49);
    freq.put("je ", 396);
    freq.put("aar", 31);
    freq.put("odl", 67);
    freq.put("äd ", 29);
    freq.put("Äng", 26);
    freq.put("Frå", 157);
    freq.put("Änn", 27);
    freq.put("Änt", 54);
    freq.put("ex ", 322);
    freq.put("tp ", 63);
    freq.put("Bla", 65);
    freq.put("dfö", 44);
    freq.put("M", 6370);
    freq.put("Isl", 27);
    freq.put("exe", 84);
    freq.put("tpa", 34);
    freq.put("exa", 145);
    freq.put("åva", 37);
    freq.put("åve", 43);
    freq.put("exi", 86);
    freq.put("ext", 342);
    freq.put("exu", 36);
    freq.put("tpr", 42);
    freq.put("exp", 100);
    freq.put("Hah", 598);
    freq.put("Hal", 134);
    freq.put("Ham", 74);
    freq.put("Han", 463);
    freq.put("uga", 125);
    freq.put("Had", 166);
    freq.put("uge", 199);
    freq.put("Hag", 27);
    freq.put("oje", 115);
    freq.put("oja", 78);
    freq.put("Har", 1165);
    freq.put("Hat", 68);
    freq.put("ojk", 108);
    freq.put("ugu", 48);
    freq.put("lör", 211);
    freq.put("am ", 935);
    freq.put("Ha ", 116);
    freq.put("ug ", 32);
    freq.put("oj ", 112);
    freq.put("rfr", 43);
    freq.put("rfa", 203);
    freq.put("cra", 58);
    freq.put("rfe", 141);
    freq.put("cre", 55);
    freq.put("rfi", 38);
    freq.put("rfo", 34);
    freq.put("cro", 70);
    freq.put("rfl", 34);
    freq.put("Fot", 78);
    freq.put("set", 765);
    freq.put("ses", 249);
    freq.put("ser", 2322);
    freq.put("For", 138);
    freq.put("sep", 139);
    freq.put("sex", 196);
    freq.put("seg", 151);
    freq.put("sef", 42);
    freq.put("see", 69);
    freq.put("sed", 425);
    freq.put("seb", 30);
    freq.put("sea", 39);
    freq.put("Fol", 83);
    freq.put("sen", 2505);
    freq.put("sem", 139);
    freq.put("sel", 166);
    freq.put("sek", 158);
    freq.put("eå ", 104);
    freq.put("ue ", 105);
    freq.put("se ", 1542);
    freq.put("rfö", 829);
    freq.put("pdr", 59);
    freq.put("pda", 152);
    freq.put("nr ", 53);
    freq.put("od ", 555);
    freq.put("xar", 74);
    freq.put("xat", 29);
    freq.put("tiv", 673);
    freq.put("xak", 96);
    freq.put("xan", 52);
    freq.put("nri", 53);
    freq.put("nre", 51);
    freq.put("Ola", 26);
    freq.put("mla", 411);
    freq.put(" fö", 11351);
    freq.put("knä", 91);
    freq.put("mli", 229);
    freq.put("iär", 118);
    freq.put(" få", 2698);
    freq.put(" fä", 272);
    freq.put("xa ", 135);
    freq.put("amh", 179);
    freq.put("vol", 91);
    freq.put("trå", 262);
    freq.put("vok", 26);
    freq.put("vor", 289);
    freq.put("amm", 1442);
    freq.put(" f ", 79);
    freq.put("amb", 137);
    freq.put("vo ", 26);
    freq.put("amf", 162);
    freq.put("kno", 53);
    freq.put("Soc", 57);
    freq.put(" fr", 3868);
    freq.put(" fu", 923);
    freq.put("kni", 564);
    freq.put(" fy", 395);
    freq.put("kne", 35);
    freq.put("Som", 243);
    freq.put("Sol", 79);
    freq.put("fän", 38);
    freq.put(" fa", 2989);
    freq.put(" fb", 50);
    freq.put(" fe", 1006);
    freq.put("Sov", 75);
    freq.put(" fi", 2920);
    freq.put(" fj", 78);
    freq.put(" fl", 1081);
    freq.put(" fo", 1834);
    freq.put("O ", 212);
    freq.put("ams", 143);
    freq.put("amr", 47);
    freq.put("bä", 1456);
    freq.put("On", 78);
    freq.put("Om", 557);
    freq.put("Ol", 127);
    freq.put("Ok", 217);
    freq.put("Oj", 91);
    freq.put("Oh", 87);
    freq.put("Of", 58);
    freq.put("Oc", 743);
    freq.put("Ob", 46);
    freq.put("bö", 1277);
    freq.put("Ov", 30);
    freq.put("Ot", 45);
    freq.put("Os", 84);
    freq.put("Or", 140);
    freq.put("Op", 44);
    freq.put("sön", 232);
    freq.put("söm", 77);
    freq.put("sök", 982);
    freq.put("sög", 39);
    freq.put("söd", 53);
    freq.put("Kha", 31);
    freq.put("söt", 143);
    freq.put("sör", 65);
    freq.put("b ", 784);
    freq.put("be", 5025);
    freq.put("bg", 72);
    freq.put("ba", 5988);
    freq.put("bb", 2272);
    freq.put("bl", 4896);
    freq.put("bm", 31);
    freq.put("bo", 3519);
    freq.put("bh", 39);
    freq.put("bi", 2540);
    freq.put("bj", 313);
    freq.put("bt", 163);
    freq.put("bu", 1037);
    freq.put("br", 3733);
    freq.put("bs", 356);
    freq.put("by", 867);
    freq.put("Fu", 233);
    freq.put("Fy", 105);
    freq.put("DE ", 42);
    freq.put(" C ", 102);
    freq.put("SJ ", 35);
    freq.put("u ", 11626);
    freq.put(" Ch", 240);
    freq.put(" Ci", 82);
    freq.put(" Co", 237);
    freq.put(" Cl", 79);
    freq.put(" Ca", 272);
    freq.put(" Ce", 80);
    freq.put(" Cy", 49);
    freq.put("Fi", 672);
    freq.put(" Cr", 78);
    freq.put("don", 150);
    freq.put(" Cu", 27);
    freq.put("cia", 237);
    freq.put("dol", 145);
    freq.put("cie", 161);
    freq.put("cid", 30);
    freq.put("uu", 202);
    freq.put("ut", 5916);
    freq.put("uv", 432);
    freq.put("cin", 100);
    freq.put("us", 3732);
    freq.put("ur", 4133);
    freq.put("um", 1694);
    freq.put("cir", 38);
    freq.put("cip", 53);
    freq.put("ui", 199);
    freq.put("uh", 149);
    freq.put("uk", 1609);
    freq.put("cit", 96);
    freq.put("ue", 405);
    freq.put("ud", 1556);
    freq.put("ug", 977);
    freq.put("uf", 322);
    freq.put("ua", 193);
    freq.put("uc", 394);
    freq.put("ub", 787);
    freq.put("äml", 65);
    freq.put("ämm", 226);
    freq.put("äft", 158);
    freq.put("ag ", 18084);
    freq.put("äff", 290);
    freq.put("ago", 108);
    freq.put("agn", 289);
    freq.put("agl", 132);
    freq.put("agi", 299);
    freq.put("agg", 195);
    freq.put("age", 1863);
    freq.put("agd", 38);
    freq.put("agb", 30);
    freq.put("aga", 816);
    freq.put("agu", 32);
    freq.put("agt", 296);
    freq.put("ags", 902);
    freq.put("agr", 82);
    freq.put("Dju", 51);
    freq.put("qvi", 32);
    freq.put("odå", 35);
    freq.put("ev ", 781);
    freq.put("åt ", 1005);
    freq.put("döm", 83);
    freq.put("leå", 47);
    freq.put("tri", 438);
    freq.put("evi", 179);
    freq.put("evl", 302);
    freq.put("ått", 743);
    freq.put("evo", 37);
    freq.put("tra", 1502);
    freq.put("eva", 189);
    freq.put("tre", 1846);
    freq.put("eve", 556);
    freq.put("try", 326);
    freq.put("åta", 251);
    freq.put("åte", 642);
    freq.put("tru", 282);
    freq.put("åtm", 30);
    freq.put("le ", 1959);
    freq.put("ody", 28);
    freq.put("ods", 31);
    freq.put("odu", 118);
    freq.put("odi", 171);
    freq.put("Blo", 106);
    freq.put("odk", 45);
    freq.put("Bli", 166);
    freq.put("odm", 64);
    freq.put("odn", 73);
    freq.put("odo", 53);
    freq.put("Ble", 126);
    freq.put("oda", 140);
    freq.put("odd", 284);
    freq.put("ode", 388);
    freq.put("ues", 30);
    freq.put("uer", 81);
    freq.put("ct ", 37);
    freq.put("rd ", 900);
    freq.put("lea", 70);
    freq.put("leb", 60);
    freq.put("led", 661);
    freq.put("lee", 49);
    freq.put("lef", 234);
    freq.put("leg", 199);
    freq.put("lek", 475);
    freq.put("lel", 27);
    freq.put("lem", 382);
    freq.put("len", 1484);
    freq.put("ler", 3482);
    freq.put("les", 343);
    freq.put("let", 1162);
    freq.put("lev", 957);
    freq.put("lex", 112);
    freq.put("ley", 39);
    freq.put("rds", 146);
    freq.put("rdr", 78);
    freq.put("evä", 29);
    freq.put("trä", 897);
    freq.put("rde", 1601);
    freq.put("rdf", 146);
    freq.put("rda", 619);
    freq.put("rdb", 26);
    freq.put("rdo", 108);
    freq.put("cto", 47);
    freq.put("rdi", 218);
    freq.put("cti", 52);
    freq.put("trö", 583);
    freq.put("sgr", 65);
    freq.put("sga", 77);
    freq.put("Cla", 34);
    freq.put("pfa", 46);
    freq.put("on", 11284);
    freq.put("häs", 81);
    freq.put("här", 2100);
    freq.put("mjö", 70);
    freq.put("npa", 40);
    freq.put("Q", 68);
    freq.put("hän", 634);
    freq.put("häm", 93);
    freq.put("npr", 40);
    freq.put("ot", 4735);
    freq.put("Yo", 105);
    freq.put("båg", 27);
    freq.put("båd", 222);
    freq.put("mju", 40);
    freq.put("båt", 45);
    freq.put("vmo", 42);
    freq.put(" h ", 112);
    freq.put("bat", 281);
    freq.put("bar", 3141);
    freq.put("Sak", 73);
    freq.put(" hy", 191);
    freq.put("San", 95);
    freq.put("Sam", 202);
    freq.put("Sal", 49);
    freq.put("Saa", 59);
    freq.put("Hög", 52);
    freq.put(" ht", 99);
    freq.put("kpa", 27);
    freq.put(" hi", 1063);
    freq.put(" ho", 1934);
    freq.put(" hm", 75);
    freq.put("Sar", 32);
    freq.put(" ha", 11093);
    freq.put("Hör", 118);
    freq.put(" he", 4207);
    freq.put("Sat", 46);
    freq.put("bag", 27);
    freq.put("bad", 169);
    freq.put("bal", 165);
    freq.put(" hö", 1246);
    freq.put(" hå", 956);
    freq.put(" hä", 2994);
    freq.put("OM ", 66);
    freq.put("IT ", 61);
    freq.put("ihj", 30);
    freq.put("ihi", 82);
    freq.put("iho", 193);
    freq.put("Nil", 39);
    freq.put("ihe", 56);
    freq.put("Tän", 241);
    freq.put("kån", 68);
    freq.put("kål", 37);
    freq.put("kåd", 44);
    freq.put("kåt", 34);
    freq.put("én ", 62);
    freq.put("kåp", 42);
    freq.put(" E ", 65);
    freq.put("ihå", 66);
    freq.put("ck ", 3209);
    freq.put("SL ", 36);
    freq.put(" El", 462);
    freq.put(" Em", 65);
    freq.put(" En", 940);
    freq.put(" Eh", 33);
    freq.put(" Ek", 134);
    freq.put(" Ed", 43);
    freq.put(" Ef", 155);
    freq.put(" Eg", 35);
    freq.put(" Ex", 140);
    freq.put(" Et", 216);
    freq.put(" Eu", 75);
    freq.put(" Ev", 48);
    freq.put(" Er", 128);
    freq.put(" Es", 51);
    freq.put("cke", 2870);
    freq.put("ckf", 27);
    freq.put("cka", 2770);
    freq.put("ckb", 35);
    freq.put("ckl", 484);
    freq.put("cko", 242);
    freq.put("ckn", 112);
    freq.put("cki", 125);
    freq.put("ckh", 356);
    freq.put("ckt", 287);
    freq.put("ckv", 30);
    freq.put("cks", 1215);
    freq.put("ckr", 107);
    freq.put("dbo", 77);
    freq.put("dba", 75);
    freq.put("dbe", 56);
    freq.put("På", 399);
    freq.put("jat", 158);
    freq.put("jar", 711);
    freq.put("jas", 47);
    freq.put("jap", 63);
    freq.put("jan", 245);
    freq.put("jam", 39);
    freq.put("jaj", 42);
    freq.put("jak", 63);
    freq.put("jah", 50);
    freq.put("jag", 11077);
    freq.put("jad", 161);
    freq.put("jac", 63);
    freq.put("jaa", 62);
    freq.put("tlö", 47);
    freq.put("gba", 27);
    freq.put("gbo", 54);
    freq.put("tlå", 35);
    freq.put("tlä", 61);
    freq.put("åre", 322);
    freq.put("ja ", 1850);
    freq.put("Pr", 412);
    freq.put("btw", 40);
    freq.put("Pu", 122);
    freq.put("C", 1450);
    freq.put("Pa", 486);
    freq.put("Pe", 360);
    freq.put("Ph", 140);
    freq.put("Pi", 217);
    freq.put("Po", 296);
    freq.put("Pl", 175);
    freq.put("et ", 23331);
    freq.put("år ", 5003);
    freq.put("tsn", 49);
    freq.put("tso", 27);
    freq.put("llv", 157);
    freq.put("tsl", 197);
    freq.put("P ", 380);
    freq.put("åst", 1113);
    freq.put("bt ", 90);
    freq.put("tsk", 176);
    freq.put("etr", 115);
    freq.put("ets", 971);
    freq.put("årv", 34);
    freq.put("etv", 34);
    freq.put("etw", 50);
    freq.put("ett", 4129);
    freq.put("etu", 40);
    freq.put("ety", 165);
    freq.put("ård", 448);
    freq.put("etc", 90);
    freq.put("tla", 124);
    freq.put("eta", 1058);
    freq.put("åra", 265);
    freq.put("tle", 114);
    freq.put("lo", 3077);
    freq.put("eth", 36);
    freq.put("eti", 131);
    freq.put("tlo", 48);
    freq.put("eto", 79);
    freq.put("ck", 12051);
    freq.put("ci", 1383);
    freq.put("ch", 13001);
    freq.put("vä", 7044);
    freq.put("vå", 1915);
    freq.put("Her", 70);
    freq.put("cl", 87);
    freq.put("cc", 189);
    freq.put("tsb", 56);
    freq.put("ca", 668);
    freq.put("ce", 1385);
    freq.put("tsc", 29);
    freq.put("Hed", 27);
    freq.put("cy", 169);
    freq.put("ucc", 42);
    freq.put("vö", 47);
    freq.put("cs", 63);
    freq.put("cr", 216);
    freq.put("Hen", 54);
    freq.put("tsa", 387);
    freq.put("Heh", 74);
    freq.put("cu", 104);
    freq.put("ct", 166);
    freq.put("åse", 78);
    freq.put("Gen", 58);
    freq.put("lgi", 36);
    freq.put("åsa", 51);
    freq.put("c ", 492);
    freq.put("lge", 206);
    freq.put("lgr", 46);
    freq.put("rby", 89);
    freq.put("åsk", 36);
    freq.put("rbu", 79);
    freq.put("rbr", 74);
    freq.put("rbo", 71);
    freq.put("Bjö", 65);
    freq.put("rbl", 36);
    freq.put("ofö", 31);
    freq.put("rbj", 83);
    freq.put("rbi", 162);
    freq.put("rbe", 557);
    freq.put("ly", 1628);
    freq.put("rba", 340);
    freq.put("va", 13108);
    freq.put("vb", 93);
    freq.put("vd", 202);
    freq.put("ve", 9435);
    freq.put("vf", 103);
    freq.put("vg", 166);
    freq.put("vh", 136);
    freq.put("vi", 9626);
    freq.put("vj", 128);
    freq.put("vk", 165);
    freq.put("vl", 1313);
    freq.put("vm", 85);
    freq.put("vn", 203);
    freq.put("vo", 542);
    freq.put("vr", 270);
    freq.put("dag", 4976);
    freq.put("vt", 360);
    freq.put("vu", 517);
    freq.put("vv", 79);
    freq.put("of ", 134);
    freq.put("vD", 46);
    freq.put("unc", 218);
    freq.put("v ", 6173);
    freq.put("pho", 127);
    freq.put("umm", 376);
    freq.put("lgå", 34);
    freq.put("uni", 208);
    freq.put("ägr", 93);
    freq.put("off", 361);
    freq.put("ofe", 45);
    freq.put("ofi", 103);
    freq.put("ofo", 32);
    freq.put("ofs", 82);
    freq.put("oft", 283);
    freq.put("Två", 97);
    freq.put("rbä", 42);
    freq.put("xel", 42);
    freq.put("xem", 86);
    freq.put("xen", 78);
    freq.put("xer", 37);
    freq.put("web", 135);
    freq.put("wee", 418);
    freq.put("wed", 53);
    freq.put("Oh ", 61);
    freq.put("wel", 28);
    freq.put("wes", 52);
    freq.put("wer", 102);
    freq.put("nve", 91);
    freq.put("nva", 92);
    freq.put("nvi", 95);
    freq.put("mhe", 108);
    freq.put("krö", 55);
    freq.put(" jä", 1046);
    freq.put("mhu", 37);
    freq.put("krä", 391);
    freq.put("krå", 40);
    freq.put("ömn", 94);
    freq.put("ömm", 201);
    freq.put("vst", 82);
    freq.put("ömd", 143);
    freq.put("öme", 36);
    freq.put("llg", 73);
    freq.put("öma", 32);
    freq.put("vse", 59);
    freq.put("ömt", 84);
    freq.put("vsk", 66);
    freq.put("vsl", 153);
    freq.put("öms", 48);
    freq.put("vsn", 100);
    freq.put(" hj", 466);
    freq.put("kr ", 159);
    freq.put(" j ", 34);
    freq.put("lle", 5638);
    freq.put("SR ", 38);
    freq.put("öm ", 224);
    freq.put("vs ", 229);
    freq.put("nvä", 411);
    freq.put("Hös", 41);
    freq.put("kry", 120);
    freq.put("Sch", 47);
    freq.put(" ju", 2964);
    freq.put("mhä", 98);
    freq.put("kru", 57);
    freq.put(" jo", 1457);
    freq.put("kri", 1281);
    freq.put("kro", 336);
    freq.put(" je", 79);
    freq.put("kra", 646);
    freq.put(" ja", 12162);
    freq.put("kre", 314);
    freq.put("inä", 28);
    freq.put("nån", 346);
    freq.put("yri", 39);
    freq.put("nål", 33);
    freq.put("yrk", 160);
    freq.put("yra", 243);
    freq.put("yre", 106);
    freq.put("yrr", 30);
    freq.put("yrt", 34);
    freq.put("Zla", 67);
    freq.put("Kla", 132);
    freq.put("Klo", 60);
    freq.put("Kli", 31);
    freq.put("jäk", 65);
    freq.put("yr ", 185);
    freq.put("nå ", 58);
    freq.put("int", 8292);
    freq.put("inu", 300);
    freq.put("inv", 142);
    freq.put("inr", 63);
    freq.put("ins", 1069);
    freq.put("inl", 276);
    freq.put("inn", 2726);
    freq.put("ino", 238);
    freq.put("inh", 41);
    freq.put("ini", 322);
    freq.put("inj", 96);
    freq.put("ink", 374);
    freq.put("ind", 607);
    freq.put("ine", 557);
    freq.put("inf", 524);
    freq.put("ing", 8190);
    freq.put("ina", 1580);
    freq.put("inb", 114);
    freq.put("inc", 76);
    freq.put("eo ", 90);
    freq.put("yrå", 42);
    freq.put("DA ", 27);
    freq.put("U", 1301);
    freq.put("in ", 4908);
    freq.put("eok", 32);
    freq.put("åmi", 72);
    freq.put("eon", 43);
    freq.put("eol", 26);
    freq.put("eor", 63);
    freq.put("tsä", 226);
    freq.put("aln", 53);
    freq.put("AH ", 37);
    freq.put("MA ", 30);
    freq.put(" G ", 55);
    freq.put("lö", 1598);
    freq.put("alg", 32);
    freq.put("ald", 609);
    freq.put(" Åk", 69);
    freq.put(" Gu", 252);
    freq.put(" Gr", 468);
    freq.put("Tun", 39);
    freq.put("teå", 39);
    freq.put(" Ge", 182);
    freq.put(" Gb", 47);
    freq.put(" Ga", 282);
    freq.put(" Go", 450);
    freq.put(" Gl", 189);
    freq.put(" Gj", 26);
    freq.put(" Gi", 226);
    freq.put("glä", 90);
    freq.put("AG ", 89);
    freq.put("ärp", 46);
    freq.put("Ca", 290);
    freq.put("glö", 204);
    freq.put("alt", 433);
    freq.put("ärk", 397);
    freq.put("als", 266);
    freq.put("xjö", 36);
    freq.put("ak ", 306);
    freq.put("sli", 462);
    freq.put(" Gö", 309);
    freq.put(" Gä", 93);
    freq.put(" Gå", 158);
    freq.put("Cr", 81);
    freq.put("löt", 119);
    freq.put("löv", 31);
    freq.put("löp", 79);
    freq.put("lös", 506);
    freq.put("glo", 58);
    freq.put("aks", 70);
    freq.put("gla", 610);
    freq.put("gle", 216);
    freq.put("aku", 55);
    freq.put("sla", 809);
    freq.put("löd", 87);
    freq.put("lög", 38);
    freq.put("ako", 156);
    freq.put("Cu", 27);
    freq.put("akl", 42);
    freq.put("löm", 250);
    freq.put("aka", 705);
    freq.put("lön", 114);
    freq.put("akg", 29);
    freq.put("glu", 27);
    freq.put("lök", 43);
    freq.put("löj", 79);
    freq.put("nk ", 400);
    freq.put("Jes", 29);
    freq.put("bry", 150);
    freq.put("bru", 307);
    freq.put("bro", 395);
    freq.put("bri", 263);
    freq.put("bre", 250);
    freq.put("Jen", 28);
    freq.put("bra", 2065);
    freq.put("er ", 25245);
    freq.put("nka", 848);
    freq.put("nke", 840);
    freq.put("nki", 44);
    freq.put("nkl", 119);
    freq.put("nkn", 29);
    freq.put("nko", 115);
    freq.put("nkr", 55);
    freq.put("nks", 37);
    freq.put("nkt", 584);
    freq.put("nku", 58);
    freq.put("ert", 606);
    freq.put("eru", 69);
    freq.put("erv", 501);
    freq.put("erp", 105);
    freq.put("err", 303);
    freq.put("ers", 1801);
    freq.put("ery", 47);
    freq.put("erd", 89);
    freq.put("ere", 417);
    freq.put("erf", 282);
    freq.put("erg", 491);
    freq.put("tna", 204);
    freq.put("era", 3820);
    freq.put("erb", 473);
    freq.put("erc", 27);
    freq.put("erl", 368);
    freq.put("erm", 225);
    freq.put("ern", 1848);
    freq.put("ero", 254);
    freq.put("erh", 258);
    freq.put("eri", 1743);
    freq.put("erk", 1307);
    freq.put("io", 2737);
    freq.put("brö", 156);
    freq.put("uar", 75);
    freq.put("la ", 6251);
    freq.put("uat", 29);
    freq.put("Abs", 44);
    freq.put("ual", 31);
    freq.put("brå", 50);
    freq.put("brä", 87);
    freq.put("ki ", 56);
    freq.put("lal", 28);
    freq.put("lam", 349);
    freq.put("lan", 2821);
    freq.put("lak", 91);
    freq.put("lad", 1217);
    freq.put("laf", 78);
    freq.put("lag", 1184);
    freq.put("lab", 44);
    freq.put("lac", 144);
    freq.put("lax", 42);
    freq.put("lay", 95);
    freq.put("nkö", 108);
    freq.put("lat", 1052);
    freq.put("lav", 42);
    freq.put("lap", 169);
    freq.put("lar", 3610);
    freq.put("las", 937);
    freq.put("erö", 75);
    freq.put("erä", 235);
    freq.put("erå", 63);
    freq.put("faa", 27);
    freq.put("ntä", 69);
    freq.put("l", 126950);
    freq.put("mvä", 40);
    freq.put("nt ", 2496);
    freq.put("Oj ", 78);
    freq.put("äd", 1001);
    freq.put("nty", 29);
    freq.put("Sve", 560);
    freq.put("nts", 61);
    freq.put("ntr", 792);
    freq.put("ntu", 74);
    freq.put("nti", 460);
    freq.put("ntl", 439);
    freq.put("nto", 321);
    freq.put("ntn", 30);
    freq.put("nta", 1534);
    freq.put("ntb", 37);
    freq.put("nte", 8645);
    freq.put("tsm", 92);
    freq.put("mve", 35);
    freq.put("mvh", 26);
    freq.put("öss", 58);
    freq.put("öst", 760);
    freq.put("VM ", 38);
    freq.put("miä", 81);
    freq.put("ösa", 144);
    freq.put("öse", 98);
    freq.put("ösn", 80);
    freq.put("jka", 51);
    freq.put("Se ", 83);
    freq.put("kt ", 2914);
    freq.put(" le", 994);
    freq.put("B", 4095);
    freq.put(" la", 1205);
    freq.put(" lo", 556);
    freq.put(" lj", 214);
    freq.put(" li", 3869);
    freq.put("ös ", 151);
    freq.put(" lu", 597);
    freq.put(" ly", 666);
    freq.put("Ses", 36);
    freq.put("kty", 30);
    freq.put("ktu", 153);
    freq.put("ktr", 56);
    freq.put("kts", 75);
    freq.put("ktl", 36);
    freq.put("ktn", 29);
    freq.put("Sed", 30);
    freq.put("kti", 1926);
    freq.put("Sen", 180);
    freq.put("Sem", 29);
    freq.put("kta", 485);
    freq.put("tsf", 49);
    freq.put("ter", 8589);
    freq.put("tsg", 35);
    freq.put("ypa", 34);
    freq.put("tev", 105);
    freq.put("ype", 71);
    freq.put("ypi", 43);
    freq.put(" lå", 1170);
    freq.put(" lä", 2950);
    freq.put(" Ön", 39);
    freq.put(" lö", 636);
    freq.put(" Ös", 64);
    freq.put(" Ör", 66);
    freq.put(" Öv", 80);
    freq.put("tse", 255);
    freq.put("ktö", 55);
    freq.put("yp ", 543);
    freq.put("uda", 139);
    freq.put("mäk", 32);
    freq.put("män", 663);
    freq.put("mäl", 163);
    freq.put("d ", 18460);
    freq.put("mär", 284);
    freq.put("mäs", 171);
    freq.put("ogg", 562);
    freq.put("mät", 61);
    freq.put("em ", 1637);
    freq.put("åk ", 61);
    freq.put("hri", 57);
    freq.put("dn", 879);
    freq.put("do", 2259);
    freq.put("dl", 1015);
    freq.put("dm", 204);
    freq.put("dj", 402);
    freq.put("dk", 196);
    freq.put("dh", 115);
    freq.put("di", 5652);
    freq.put("df", 246);
    freq.put("dg", 232);
    freq.put("dd", 1716);
    freq.put("de", 36072);
    freq.put("db", 276);
    freq.put("dc", 42);
    freq.put("da", 11249);
    freq.put("dy", 361);
    freq.put("dv", 398);
    freq.put("dw", 35);
    freq.put("dt", 267);
    freq.put("du", 5197);
    freq.put("dr", 4158);
    freq.put("ds", 1806);
    freq.put("dp", 100);
    freq.put("eme", 370);
    freq.put("åkl", 106);
    freq.put("ema", 315);
    freq.put("CK ", 51);
    freq.put("åki", 184);
    freq.put("emb", 187);
    freq.put("emm", 482);
    freq.put("eml", 73);
    freq.put("emo", 396);
    freq.put("emi", 300);
    freq.put("emk", 26);
    freq.put("emt", 78);
    freq.put("emp", 146);
    freq.put("ems", 213);
    freq.put("åkt", 92);
    freq.put("emy", 29);
    freq.put("w ", 422);
    freq.put(" I ", 660);
    freq.put("il ", 490);
    freq.put("xD ", 36);
    freq.put("co ", 45);
    freq.put("we", 857);
    freq.put("wa", 239);
    freq.put("dé", 127);
    freq.put(" Ip", 30);
    freq.put("wn", 66);
    freq.put(" Ir", 44);
    freq.put(" Is", 115);
    freq.put(" It", 48);
    freq.put("wi", 1037);
    freq.put("wh", 100);
    freq.put("ww", 102);
    freq.put(" Ik", 95);
    freq.put("ws", 94);
    freq.put(" Im", 141);
    freq.put(" In", 1171);
    freq.put("dö", 667);
    freq.put(" Ib", 87);
    freq.put(" Ic", 36);
    freq.put(" Id", 374);
    freq.put(" Ig", 79);
    freq.put("emå", 31);
    freq.put("väs", 123);
    freq.put("vär", 1640);
    freq.put("ilb", 35);
    freq.put("vät", 160);
    freq.put("ila", 302);
    freq.put("ilo", 75);
    freq.put("ill", 9461);
    freq.put("ilm", 492);
    freq.put("ilj", 714);
    freq.put("ilk", 675);
    freq.put("ili", 144);
    freq.put("ilv", 40);
    freq.put("ilt", 167);
    freq.put("emö", 29);
    freq.put("ils", 154);
    freq.put("väg", 702);
    freq.put("com", 136);
    freq.put("väl", 2575);
    freq.put("coo", 104);
    freq.put("con", 147);
    freq.put("gn ", 283);
    freq.put("ai ", 39);
    freq.put("gns", 33);
    freq.put("gnt", 69);
    freq.put("gnu", 42);
    freq.put("dsh", 29);
    freq.put("ail", 258);
    freq.put("ET ", 111);
    freq.put("gna", 413);
    freq.put("ÅR ", 26);
    freq.put("gne", 181);
    freq.put("aid", 26);
    freq.put("gni", 202);
    freq.put("gno", 70);
    freq.put("ni ", 1159);
    freq.put("Ikv", 74);
    freq.put("sf ", 34);
    freq.put("ep ", 83);
    freq.put("th ", 116);
    freq.put("nik", 260);
    freq.put("nin", 3792);
    freq.put("nio", 76);
    freq.put("nil", 40);
    freq.put("nim", 35);
    freq.put("nic", 170);
    freq.put("nia", 48);
    freq.put("nif", 34);
    freq.put("nig", 128);
    freq.put("nie", 152);
    freq.put("Y", 287);
    freq.put("nis", 776);
    freq.put("nip", 36);
    freq.put("niv", 143);
    freq.put("nit", 342);
    freq.put("tsr", 28);
    freq.put("ept", 231);
    freq.put("epr", 112);
    freq.put("eps", 43);
    freq.put("epp", 256);
    freq.put("epo", 70);
    freq.put("epl", 57);
    freq.put("thl", 153);
    freq.put("gnä", 45);
    freq.put("epi", 48);
    freq.put("the", 297);
    freq.put("epe", 43);
    freq.put("tha", 102);
    freq.put("epa", 88);
    freq.put("rn ", 1068);
    freq.put("tsp", 103);
    freq.put("Gan", 27);
    freq.put("Gam", 60);
    freq.put("Gal", 73);
    freq.put("Gad", 32);
    freq.put("rnk", 38);
    freq.put("plö", 94);
    freq.put("rni", 186);
    freq.put("rno", 42);
    freq.put("Tro", 358);
    freq.put("Tra", 168);
    freq.put("rnb", 31);
    freq.put("rna", 3406);
    freq.put("Tre", 143);
    freq.put("rne", 338);
    freq.put("plå", 64);
    freq.put("rns", 143);
    freq.put("Tru", 32);
    freq.put("rnv", 37);
    freq.put("rnt", 26);
    freq.put("Tob", 33);
    freq.put("yka", 34);
    freq.put("Led", 49);
    freq.put("yke", 125);
    freq.put("Lek", 30);
    freq.put("yko", 52);
    freq.put("Len", 31);
    freq.put("ykl", 90);
    freq.put("Lev", 32);
    freq.put("ykt", 101);
    freq.put("plu", 200);
    freq.put("Ä", 1171);
    freq.put("Trå", 32);
    freq.put("Trä", 56);
    freq.put("ply", 35);
    freq.put("ple", 268);
    freq.put("pla", 1013);
    freq.put("plo", 134);
    freq.put("pli", 187);
    freq.put("Trö", 57);
    freq.put("obo", 40);
    freq.put("obl", 286);
    freq.put("obi", 269);
    freq.put("obe", 235);
    freq.put("obb", 1306);
    freq.put("oba", 33);
    freq.put("obs", 90);
    freq.put("wal", 54);
    freq.put("MP ", 33);
    freq.put("way", 45);
    freq.put("mt ", 709);
    freq.put("war", 70);
    freq.put("kvä", 1233);
    freq.put(" X ", 41);
    freq.put(" nå", 2633);
    freq.put(" nä", 3416);
    freq.put("xy ", 34);
    freq.put(" nö", 220);
    freq.put("Ön", 39);
    freq.put("Öp", 29);
    freq.put("Ör", 66);
    freq.put("Ös", 64);
    freq.put("Öv", 80);
    freq.put("mta", 208);
    freq.put("mte", 65);
    freq.put(" n ", 84);
    freq.put(" ni", 1218);
    freq.put(" nj", 75);
    freq.put(" no", 1208);
    freq.put("kva", 557);
    freq.put(" na", 800);
    freq.put(" ne", 1027);
    freq.put(" ng", 162);
    freq.put("kvi", 292);
    freq.put(" ny", 1605);
    freq.put(" nr", 47);
    freq.put(" nu", 2966);
    freq.put("ums", 66);
    freq.put("Sj", 254);
    freq.put("umr", 31);
    freq.put("So", 597);
    freq.put("Sn", 381);
    freq.put("Bät", 33);
    freq.put("Bäs", 91);
    freq.put("umb", 58);
    freq.put("Säl", 30);
    freq.put("umo", 39);
    freq.put("gub", 108);
    freq.put("gue", 36);
    freq.put("gud", 115);
    freq.put("gui", 38);
    freq.put("gum", 86);
    freq.put("gul", 174);
    freq.put("gus", 58);
    freq.put("p", 48333);
    freq.put("fok", 44);
    freq.put("hta", 38);
    freq.put("OK ", 44);
    freq.put("htt", 77);
    freq.put("Får", 213);
    freq.put("IN ", 40);
    freq.put("ek ", 200);
    freq.put("yvä", 229);
    freq.put("ht ", 144);
    freq.put("eko", 265);
    freq.put("ekn", 147);
    freq.put("ekl", 236);
    freq.put("eki", 42);
    freq.put("eke", 128);
    freq.put("eka", 186);
    freq.put("ekv", 65);
    freq.put("eku", 81);
    freq.put("ekt", 892);
    freq.put("eks", 100);
    freq.put("ekr", 92);
    freq.put("spö", 39);
    freq.put("spä", 251);
    freq.put("spå", 117);
    freq.put(" Ka", 1067);
    freq.put(" Ke", 102);
    freq.put(" Kh", 34);
    freq.put(" Ki", 212);
    freq.put(" Kn", 57);
    freq.put(" Ko", 791);
    freq.put(" Kl", 278);
    freq.put(" Kr", 239);
    freq.put(" ik", 460);
    freq.put("Öns", 37);
    freq.put(" Ku", 307);
    freq.put(" il", 163);
    freq.put(" Ky", 30);
    freq.put("Mon", 47);
    freq.put("F", 5075);
    freq.put("ksb", 32);
    freq.put("fb ", 49);
    freq.put("Mob", 28);
    freq.put("kso", 201);
    freq.put("ibl", 226);
    freq.put("cas", 61);
    freq.put("iba", 30);
    freq.put("ibb", 40);
    freq.put("ibe", 84);
    freq.put("cat", 28);
    freq.put("iby", 39);
    freq.put(" if", 193);
    freq.put("cam", 33);
    freq.put("cal", 34);
    freq.put("Mod", 94);
    freq.put("caf", 27);
    freq.put("spy", 33);
    freq.put("ao ", 28);
    freq.put("spr", 546);
    freq.put("spi", 177);
    freq.put("spl", 113);
    freq.put("spo", 294);
    freq.put("spa", 346);
    freq.put("spe", 1422);
    freq.put(" Kä", 493);
    freq.put("ärj", 46);
    freq.put("asö", 29);
    freq.put(" Kö", 174);
    freq.put("aos", 35);
    freq.put("sp ", 31);
    freq.put("ght", 158);
    freq.put("ghe", 442);
    freq.put("ER ", 89);
    freq.put("gha", 28);
    freq.put("Ru", 89);
    freq.put("Che", 61);
    freq.put("eå", 128);
    freq.put("Chi", 34);
    freq.put("no ", 142);
    freq.put("Ry", 68);
    freq.put("Jap", 89);
    freq.put("Jan", 63);
    freq.put("Re", 409);
    freq.put("Chr", 54);
    freq.put("Jam", 36);
    freq.put("Ra", 222);
    freq.put("Jah", 82);
    freq.put("Jag", 3239);
    freq.put("Ro", 320);
    freq.put("Ri", 261);
    freq.put("Jaa", 31);
    freq.put("nol", 97);
    freq.put("nom", 1019);
    freq.put("non", 154);
    freq.put("tje", 252);
    freq.put("rlå", 95);
    freq.put("rlä", 101);
    freq.put("nog", 688);
    freq.put("lmö", 196);
    freq.put("sol", 361);
    freq.put("R ", 602);
    freq.put("not", 99);
    freq.put("nov", 111);
    freq.put("now", 40);
    freq.put("lmä", 100);
    freq.put("nor", 575);
    freq.put("nos", 108);
    freq.put("h", 51356);
    freq.put("em", 4415);
    freq.put("el", 11108);
    freq.put("eo", 358);
    freq.put("en", 44983);
    freq.put("ei", 273);
    freq.put("eh", 1294);
    freq.put("ek", 2524);
    freq.put("ej", 2415);
    freq.put("ee", 1231);
    freq.put("ed", 10652);
    freq.put("eg", 1989);
    freq.put("ef", 2221);
    freq.put("ea", 1043);
    freq.put("rl ", 85);
    freq.put("ec", 2082);
    freq.put("eb", 1453);
    freq.put("Rä", 102);
    freq.put("Rå", 39);
    freq.put("ey", 315);
    freq.put("ex", 1195);
    freq.put("ez", 46);
    freq.put("lm ", 697);
    freq.put("et", 32167);
    freq.put("ew", 163);
    freq.put("ev", 2170);
    freq.put("ep", 1090);
    freq.put("es", 6746);
    freq.put("er", 41076);
    freq.put("rlo", 121);
    freq.put("rli", 732);
    freq.put("tjä", 315);
    freq.put("rle", 241);
    freq.put("rld", 537);
    freq.put("lms", 153);
    freq.put("rla", 177);
    freq.put("e ", 39654);
    freq.put("rly", 34);
    freq.put("rlu", 113);
    freq.put("lma", 162);
    freq.put("lme", 227);
    freq.put("rls", 83);
    freq.put("ael", 70);
    freq.put("usk", 97);
    freq.put("xj", 42);
    freq.put("xi", 191);
    freq.put("xn", 50);
    freq.put("xo", 110);
    freq.put("xl", 63);
    freq.put("xa", 447);
    freq.put("xf", 26);
    freq.put("xe", 290);
    freq.put("xx", 124);
    freq.put("xy", 36);
    freq.put("xp", 162);
    freq.put("xt", 454);
    freq.put("xu", 37);
    freq.put("yin", 34);
    freq.put("xD", 83);
    freq.put("Sor", 39);
    freq.put("fn", 39);
    freq.put("Sä", 212);
    freq.put("x ", 754);
    freq.put("za ", 92);
    freq.put("pni", 121);
    freq.put("pna", 181);
    freq.put("mrå", 86);
    freq.put("xå", 102);
    freq.put("Pho", 109);
    freq.put("mr ", 30);
    freq.put("ust", 1161);
    freq.put("ö", 35163);
    freq.put("mre", 101);
    freq.put("mra", 64);
    freq.put("Web", 28);
    freq.put("Wel", 32);
    freq.put("Wes", 34);
    freq.put(" p ", 93);
    freq.put(" ps", 69);
    freq.put(" pr", 2514);
    freq.put(" pu", 305);
    freq.put(" py", 29);
    freq.put("uvu", 234);
    freq.put(" pa", 1257);
    freq.put(" pg", 244);
    freq.put(" pe", 1046);
    freq.put(" pi", 435);
    freq.put(" po", 1000);
    freq.put(" pl", 997);
    freq.put("ölj", 566);
    freq.put("ytt", 741);
    freq.put("jte", 30);
    freq.put("yte", 138);
    freq.put("jta", 29);
    freq.put("yta", 194);
    freq.put("Kri", 76);
    freq.put(" på", 12767);
    freq.put(" pä", 43);
    freq.put("Kra", 67);
    freq.put("vud", 236);
    freq.put("EM ", 46);
    freq.put("vun", 138);
    freq.put("vul", 34);
    freq.put("jt ", 87);
    freq.put("yt ", 41);
    freq.put(" Mä", 105);
    freq.put(" Må", 357);
    freq.put("Äl", 123);
    freq.put("Mål", 26);
    freq.put("Mån", 113);
    freq.put(" Mö", 74);
    freq.put("Mås", 175);
    freq.put("Mår", 28);
    freq.put("Äv", 51);
    freq.put("åg ", 598);
    freq.put("Är", 644);
    freq.put("årt", 487);
    freq.put("eis", 30);
    freq.put("ågs", 37);
    freq.put("ågr", 398);
    freq.put("års", 134);
    freq.put("ccé", 26);
    freq.put("åga", 760);
    freq.put("åge", 188);
    freq.put("ein", 102);
    freq.put("yh", 302);
    freq.put("uxe", 63);
    freq.put("SD ", 87);
    freq.put("uxn", 36);
    freq.put("ceb", 256);
    freq.put(" Me", 1935);
    freq.put(" Ma", 1515);
    freq.put(" Mc", 33);
    freq.put(" Mm", 51);
    freq.put(" Mo", 416);
    freq.put(" Mi", 892);
    freq.put(" Mj", 27);
    freq.put(" Mu", 117);
    freq.put(" Mv", 66);
    freq.put(" My", 182);
    freq.put("yb", 128);
    freq.put("ete", 1500);
    freq.put("tli", 547);
    freq.put(" M ", 96);
    freq.put("åri", 235);
    freq.put("cci", 40);
    freq.put("cce", 58);
    freq.put("ågå", 26);
    freq.put("Nä ", 124);
    freq.put("ps ", 473);
    freq.put("äxt", 55);
    freq.put("äxl", 31);
    freq.put("äxj", 38);
    freq.put("co", 728);
    freq.put("äxe", 27);
    freq.put("äxa", 34);
    freq.put(" Fö", 1087);
    freq.put("yv", 246);
    freq.put("lg ", 146);
    freq.put("ami", 293);
    freq.put("psk", 89);
    freq.put("amk", 32);
    freq.put("Näm", 26);
    freq.put("aml", 373);
    freq.put("amo", 78);
    freq.put("amn", 452);
    freq.put("ama", 262);
    freq.put("psa", 202);
    freq.put("ame", 460);
    freq.put("Rad", 56);
    freq.put("amg", 39);
    freq.put("pse", 79);
    freq.put("nmä", 99);
    freq.put("psy", 69);
    freq.put("amp", 369);
    freq.put("Näs", 108);
    freq.put("När", 469);
    freq.put("amt", 548);
    freq.put("pst", 117);
    freq.put("amv", 35);
    freq.put("srä", 57);
    freq.put("uce", 36);
    freq.put("gjo", 558);
    freq.put("t", 213799);
    freq.put("Hel", 309);
    freq.put("Hem", 103);
    freq.put("uck", 246);
    freq.put("Hej", 249);
    freq.put("uch", 39);
    freq.put("amå", 55);
    freq.put("tde", 27);
    freq.put("nma", 42);
    freq.put("amö", 40);
    freq.put("Käm", 30);
    freq.put("Kän", 388);
    freq.put("sra", 67);
    freq.put("sre", 85);
    freq.put("sri", 30);
    freq.put("sru", 50);
    freq.put("Kär", 45);
    freq.put("lob", 51);
    freq.put("loc", 411);
    freq.put("log", 762);
    freq.put("lod", 112);
    freq.put("lok", 118);
    freq.put("lon", 163);
    freq.put("loo", 57);
    freq.put("lol", 56);
    freq.put("lom", 99);
    freq.put("lor", 321);
    freq.put("los", 112);
    freq.put("lop", 112);
    freq.put("lov", 244);
    freq.put("low", 118);
    freq.put("lot", 107);
    freq.put("lou", 57);
    freq.put("J", 6038);
    freq.put("rje", 275);
    freq.put("rja", 1042);
    freq.put("lo ", 113);
    freq.put("gär", 336);
    freq.put("gäs", 81);
    freq.put("gäl", 169);
    freq.put("gän", 109);
    freq.put("Lan", 45);
    freq.put("Lad", 57);
    freq.put("Lag", 38);
    freq.put("you", 120);
    freq.put("Lar", 66);
    freq.put("Las", 30);
    freq.put("jäm", 138);
    freq.put("jäl", 1371);
    freq.put("jän", 217);
    freq.put("Bry", 31);
    freq.put("Bru", 61);
    freq.put("Bro", 69);
    freq.put("IK ", 78);
    freq.put("Bri", 52);
    freq.put("jät", 245);
    freq.put("Bre", 59);
    freq.put("jäv", 648);
    freq.put("Bra", 371);
    freq.put("jär", 374);
    freq.put("mp ", 127);
    freq.put("töt", 40);
    freq.put("töv", 27);
    freq.put("tör", 496);
    freq.put("tön", 35);
    freq.put("töd", 89);
    freq.put("där", 1662);
    freq.put("ån ", 2410);
    freq.put(" rö", 497);
    freq.put("mpa", 367);
    freq.put("mpo", 151);
    freq.put("mpl", 131);
    freq.put("mpi", 212);
    freq.put(" rå", 201);
    freq.put(" rä", 1050);
    freq.put("mpr", 49);
    freq.put("mps", 26);
    freq.put("näl", 233);
    freq.put("ysa", 61);
    freq.put("pul", 68);
    freq.put(" r ", 30);
    freq.put("hår", 332);
    freq.put("håg", 67);
    freq.put("hål", 887);
    freq.put("hån", 36);
    freq.put(" ru", 534);
    freq.put(" ry", 216);
    freq.put(" re", 2245);
    freq.put(" ra", 672);
    freq.put("Mvh", 66);
    freq.put(" ro", 677);
    freq.put(" ri", 1126);
    freq.put("cé", 27);
    freq.put("ask", 322);
    freq.put("S ", 559);
    freq.put("Sy", 166);
    freq.put("fö", 13437);
    freq.put("Sp", 473);
    freq.put("Sw", 67);
    freq.put("Sv", 789);
    freq.put("Su", 291);
    freq.put("St", 1438);
    freq.put("Sk", 1352);
    freq.put("ven", 1333);
    freq.put("Si", 397);
    freq.put("Sh", 133);
    freq.put("fä", 704);
    freq.put("få", 2715);
    freq.put("Sm", 118);
    freq.put("Sl", 203);
    freq.put("Sc", 106);
    freq.put("fé", 35);
    freq.put("Sa", 653);
    freq.put("Se", 713);
    freq.put("vs", 831);
    freq.put("egå", 64);
    freq.put("egä", 26);
    freq.put("Må", 357);
    freq.put("f ", 1019);
    freq.put("hha", 36);
    freq.put("hhh", 74);
    freq.put("ob ", 45);
    freq.put("eg ", 135);
    freq.put("fr", 4603);
    freq.put("fs", 246);
    freq.put("ft", 2876);
    freq.put("fu", 1061);
    freq.put("fy", 538);
    freq.put("Sö", 213);
    freq.put("fa", 4718);
    freq.put("fb", 72);
    freq.put("hh ", 90);
    freq.put("fe", 2260);
    freq.put("ff", 1780);
    freq.put("fi", 4042);
    freq.put("fj", 95);
    freq.put("fl", 1399);
    freq.put("fm", 31);
    freq.put("Så", 870);
    freq.put("fo", 2551);
    freq.put("a", 248335);
    freq.put("egr", 161);
    freq.put("egu", 53);
    freq.put("egi", 129);
    freq.put("åen", 99);
    freq.put("ego", 101);
    freq.put("egn", 264);
    freq.put("egl", 91);
    freq.put("ega", 247);
    freq.put("egg", 27);
    freq.put("ege", 639);
    freq.put("ce ", 308);
    freq.put("y ", 2289);
    freq.put("fft", 40);
    freq.put("ffs", 39);
    freq.put("ffr", 71);
    freq.put("ffl", 59);
    freq.put("ffi", 170);
    freq.put("uva", 66);
    freq.put("ffe", 455);
    freq.put("uve", 45);
    freq.put("ffa", 590);
    freq.put(" On", 75);
    freq.put(" Ol", 126);
    freq.put(" Om", 556);
    freq.put(" Oj", 91);
    freq.put(" Ok", 217);
    freq.put(" Oh", 87);
    freq.put(" Of", 57);
    freq.put(" Ob", 46);
    freq.put(" Oc", 743);
    freq.put("if ", 26);
    freq.put("Öre", 52);
    freq.put(" Ov", 29);
    freq.put(" Ot", 45);
    freq.put(" Or", 139);
    freq.put(" Os", 80);
    freq.put(" Op", 43);
    freq.put("yi", 42);
    freq.put("rwa", 29);
    freq.put("yk", 475);
    freq.put("ym", 592);
    freq.put("yl", 782);
    freq.put("yo", 174);
    freq.put("yn", 738);
    freq.put("ya", 786);
    freq.put("cen", 327);
    freq.put("yc", 2750);
    freq.put("cel", 46);
    freq.put("ye", 185);
    freq.put("yd", 628);
    freq.put("yg", 1115);
    freq.put("yf", 280);
    freq.put("yy", 56);
    freq.put("yx", 119);
    freq.put("ces", 49);
    freq.put("cer", 214);
    freq.put("cep", 102);
    freq.put("yp", 784);
    freq.put("ys", 1816);
    freq.put("yr", 923);
    freq.put("yt", 1213);
    freq.put("ff ", 159);
    freq.put("ift", 266);
    freq.put("ifr", 235);
    freq.put("ify", 66);
    freq.put(" O ", 87);
    freq.put("ife", 75);
    freq.put("iff", 107);
    freq.put("ifa", 52);
    freq.put("ifi", 102);
    freq.put("Eng", 49);
    freq.put("ffö", 32);
    freq.put("Enl", 27);
    freq.put("as ", 3161);
    freq.put("ffä", 88);
    freq.put("En ", 752);
    freq.put("pum", 29);
    freq.put("pun", 124);
    freq.put("asp", 32);
    freq.put("ast", 2113);
    freq.put("asy", 39);
    freq.put("pub", 101);
    freq.put("puc", 27);
    freq.put("asc", 80);
    freq.put("asa", 120);
    freq.put("ase", 184);
    freq.put("put", 33);
    freq.put("asi", 245);
    freq.put("ash", 147);
    freq.put("aso", 31);
    freq.put("asm", 36);
    freq.put("pus", 73);
    freq.put(" än", 1856);
    freq.put(" äm", 61);
    freq.put(" äl", 433);
    freq.put(" äk", 28);
    freq.put(" F ", 48);
    freq.put(" äg", 171);
    freq.put(" äc", 67);
    freq.put(" äv", 370);
    freq.put(" ät", 387);
    freq.put(" är", 12314);
    freq.put(" äp", 34);
    freq.put("tf ", 36);
    freq.put("Imo", 109);
    freq.put("Imp", 26);
    freq.put("st ", 4805);
    freq.put("dt ", 91);
    freq.put("tfo", 43);
    freq.put("tfi", 52);
    freq.put("tfa", 296);
    freq.put("rhö", 60);
    freq.put("nch", 282);
    freq.put("nci", 71);
    freq.put("rhå", 91);
    freq.put("nce", 136);
    freq.put("tfr", 34);
    freq.put("std", 27);
    freq.put("ste", 4010);
    freq.put("stf", 43);
    freq.put("sta", 5298);
    freq.put("stb", 67);
    freq.put("stl", 81);
    freq.put("stm", 55);
    freq.put("stn", 204);
    freq.put("sto", 1333);
    freq.put("sth", 56);
    freq.put("sti", 1334);
    freq.put("stj", 126);
    freq.put("stk", 49);
    freq.put("stt", 27);
    freq.put("stu", 466);
    freq.put("stv", 32);
    freq.put("str", 1284);
    freq.put("sts", 67);
    freq.put("dtr", 39);
    freq.put("sty", 236);
    freq.put("Goo", 112);
    freq.put("ka ", 8414);
    freq.put("God", 200);
    freq.put("Got", 38);
    freq.put("lid", 108);
    freq.put("lie", 137);
    freq.put("lif", 58);
    freq.put("lig", 5647);
    freq.put("lia", 137);
    freq.put("lib", 52);
    freq.put("lic", 328);
    freq.put("lil", 184);
    freq.put("Nic", 57);
    freq.put("lin", 1073);
    freq.put("lio", 77);
    freq.put("lik", 987);
    freq.put("lit", 2321);
    freq.put("liv", 915);
    freq.put("lip", 360);
    freq.put("lir", 1338);
    freq.put("lis", 698);
    freq.put("lix", 46);
    freq.put("kab", 32);
    freq.put("kaf", 337);
    freq.put("kad", 786);
    freq.put("kak", 142);
    freq.put("tfä", 45);
    freq.put("rhu", 34);
    freq.put("Go ", 33);
    freq.put("kam", 234);
    freq.put("kal", 758);
    freq.put("kas", 460);
    freq.put("kar", 2928);
    freq.put("kap", 556);
    freq.put("kav", 50);
    freq.put("rho", 50);
    freq.put("kat", 834);
    freq.put("rha", 74);
    freq.put("The", 165);
    freq.put("tfö", 76);
    freq.put("rhe", 137);
    freq.put("Tha", 41);
    freq.put("stä", 1674);
    freq.put("stå", 1096);
    freq.put("li ", 938);
    freq.put("Ni ", 182);
    freq.put("stö", 481);
    freq.put("rlö", 26);
    freq.put("ymp", 60);
    freq.put("ymt", 117);
    freq.put("yma", 27);
    freq.put("ymd", 34);
    freq.put("ymm", 92);
    freq.put("ymn", 54);
    freq.put("ym ", 126);
    freq.put("oxe", 34);
    freq.put("dta", 38);
    freq.put("Plu", 52);
    freq.put("wor", 119);
    freq.put("woo", 30);
    freq.put("Pla", 82);
    freq.put("ydd", 91);
    freq.put("yda", 33);
    freq.put("oxå", 86);
    freq.put("Wal", 42);
    freq.put("War", 27);
    freq.put(" t ", 227);
    freq.put("Kvä", 41);
    freq.put(" ty", 1727);
    freq.put(" tw", 898);
    freq.put(" tv", 1068);
    freq.put(" tu", 589);
    freq.put("ada", 303);
    freq.put(" tr", 3462);
    freq.put("N", 4632);
    freq.put(" to", 1057);
    freq.put(" tj", 488);
    freq.put(" ti", 7840);
    freq.put(" th", 308);
    freq.put(" te", 1039);
    freq.put(" ta", 2976);
    freq.put("gsä", 26);
    freq.put("bot", 113);
    freq.put("Kva", 30);
    freq.put("Kvi", 34);
    freq.put("gs ", 767);
    freq.put("sät", 749);
    freq.put("sär", 89);
    freq.put("säs", 129);
    freq.put(" tö", 60);
    freq.put("säg", 921);
    freq.put("säc", 26);
    freq.put("säl", 316);
    freq.put("säm", 114);
    freq.put("sän", 397);
    freq.put(" tä", 1001);
    freq.put("säk", 439);
    freq.put("gsp", 106);
    freq.put("gss", 108);
    freq.put("gsr", 72);
    freq.put("gst", 307);
    freq.put("gsv", 108);
    freq.put("gsa", 70);
    freq.put("gsb", 93);
    freq.put("gse", 47);
    freq.put("gsd", 40);
    freq.put("gsg", 34);
    freq.put("gsf", 85);
    freq.put("gsi", 30);
    freq.put("gsh", 42);
    freq.put("gsk", 167);
    freq.put("gsm", 104);
    freq.put("gsl", 119);
    freq.put("gsn", 27);
    freq.put("EJ ", 37);
    freq.put("åh", 264);
    freq.put("ee ", 85);
    freq.put("eet", 430);
    freq.put("eep", 62);
    freq.put("eer", 31);
    freq.put("eel", 56);
    freq.put("een", 150);
    freq.put("eej", 30);
    freq.put("eee", 157);
    freq.put("eed", 103);
    freq.put("ru ", 101);
    freq.put("hjä", 524);
    freq.put("bg ", 66);
    freq.put("Öpp", 28);
    freq.put("id ", 1728);
    freq.put("ruk", 509);
    freq.put("run", 585);
    freq.put("rul", 141);
    freq.put("rum", 373);
    freq.put("rub", 54);
    freq.put("ruc", 36);
    freq.put("rud", 53);
    freq.put("rue", 53);
    freq.put("rus", 166);
    freq.put("rup", 223);
    freq.put("ruv", 45);
    freq.put("rut", 316);
    freq.put("Tho", 39);
    freq.put("idr", 159);
    freq.put("ids", 198);
    freq.put("idn", 195);
    freq.put("ido", 133);
    freq.put("idi", 559);
    freq.put("idd", 281);
    freq.put("ide", 968);
    freq.put("ida", 1825);
    freq.put("Eli", 28);
    freq.put("Ell", 347);
    freq.put("Tä", 256);
    freq.put("Tå", 35);
    freq.put("ut ", 1797);
    freq.put("utb", 150);
    freq.put("uta", 1205);
    freq.put("utf", 76);
    freq.put("utg", 50);
    freq.put("ute", 778);
    freq.put("dvä", 88);
    freq.put("svä", 331);
    freq.put("svå", 297);
    freq.put("utn", 62);
    freq.put("uto", 320);
    freq.put("utl", 76);
    freq.put("utm", 92);
    freq.put("utr", 94);
    freq.put("uts", 326);
    freq.put("utv", 194);
    freq.put("utt", 271);
    freq.put("utu", 40);
    freq.put("Vår", 69);
    freq.put("Ty", 386);
    freq.put("Tv", 160);
    freq.put("Tw", 300);
    freq.put("Tu", 225);
    freq.put("Tr", 924);
    freq.put("oog", 159);
    freq.put("To", 331);
    freq.put("Tj", 98);
    freq.put("Th", 278);
    freq.put("Ti", 512);
    freq.put("Te", 297);
    freq.put("Ta", 926);
    freq.put("nab", 218);
    freq.put("nac", 225);
    freq.put("nag", 80);
    freq.put("nad", 1184);
    freq.put("naj", 26);
    freq.put("nak", 44);
    freq.put("ät ", 113);
    freq.put("nan", 1299);
    freq.put("nal", 598);
    freq.put("nam", 327);
    freq.put("nar", 2423);
    freq.put("nas", 852);
    freq.put("nap", 232);
    freq.put("nav", 26);
    freq.put("nat", 1380);
    freq.put("T ", 1493);
    freq.put("Aa", 33);
    freq.put("äti", 62);
    freq.put("Ab", 77);
    freq.put("dvi", 157);
    freq.put("Ad", 82);
    freq.put("Ag", 41);
    freq.put("svi", 294);
    freq.put("dve", 56);
    freq.put("Ah", 126);
    freq.put("äta", 239);
    freq.put("Aj", 53);
    freq.put("Am", 104);
    freq.put("Al", 946);
    freq.put("äte", 223);
    freq.put("An", 642);
    freq.put("Ap", 144);
    freq.put("As", 133);
    freq.put("Ar", 259);
    freq.put("Au", 54);
    freq.put("At", 342);
    freq.put("Av", 122);
    freq.put("Ax", 27);
    freq.put("svu", 37);
    freq.put("ätv", 48);
    freq.put("dvs", 29);
    freq.put("ätt", 3226);
    freq.put("gv", 72);
    freq.put("gu", 730);
    freq.put("gt", 5336);
    freq.put("gs", 2474);
    freq.put("gr", 3471);
    freq.put("gp", 87);
    freq.put("gy", 177);
    freq.put("gg", 3129);
    freq.put("gf", 99);
    freq.put("ge", 13158);
    freq.put("gd", 408);
    freq.put("gb", 184);
    freq.put("ga", 9642);
    freq.put("go", 4471);
    freq.put("gn", 1376);
    freq.put("gm", 103);
    freq.put("Gil", 118);
    freq.put("gk", 96);
    freq.put("gj", 583);
    freq.put("gi", 2203);
    freq.put("gh", 741);
    freq.put("lkn", 39);
    freq.put("lko", 338);
    freq.put("lkl", 47);
    freq.put("Tje", 33);
    freq.put("lki", 31);
    freq.put("lke", 594);
    freq.put("lka", 258);
    freq.put("Not", 44);
    freq.put("Nor", 208);
    freq.put("g ", 35346);
    freq.put("hi ", 87);
    freq.put("Spr", 42);
    freq.put("lk ", 543);
    freq.put("Spo", 140);
    freq.put("Spa", 60);
    freq.put("Spe", 119);
    freq.put("gö", 2051);
    freq.put("zo", 75);
    freq.put("zi", 66);
    freq.put("ze", 71);
    freq.put("za", 164);
    freq.put("sö", 1636);
    freq.put("gå", 3565);
    freq.put("gä", 707);
    freq.put("zz", 156);
    freq.put("Ah ", 65);
    freq.put("yck", 2727);
    freq.put("ull", 1767);
    freq.put("z ", 151);
    freq.put("Aha", 38);
    freq.put(" åå", 46);
    freq.put("Spä", 57);
    freq.put("win", 34);
    freq.put("wil", 34);
    freq.put("wit", 887);
    freq.put(" vå", 697);
    freq.put(" vä", 3842);
    freq.put("rås", 65);
    freq.put("råt", 156);
    freq.put("råk", 404);
    freq.put("rån", 1956);
    freq.put("rål", 60);
    freq.put("råg", 693);
    freq.put("råd", 251);
    freq.put("Ji", 42);
    freq.put("ox ", 60);
    freq.put("rå ", 85);
    freq.put(" va", 8831);
    freq.put(" ve", 2827);
    freq.put(" vi", 7006);
    freq.put(" vo", 190);
    freq.put(" vs", 40);
    freq.put(" vr", 48);
    freq.put(" vu", 108);
    freq.put("Här", 310);
    freq.put("Hän", 40);
    freq.put("Häl", 35);
    freq.put(" v ", 66);
    freq.put("lå ", 141);
    freq.put("jni", 56);
    freq.put("låd", 77);
    freq.put("RA ", 58);
    freq.put("låg", 116);
    freq.put("lån", 460);
    freq.put("lår", 114);
    freq.put("lås", 142);
    freq.put("låt", 772);
    freq.put("ec ", 27);
    freq.put("hlm", 151);
    freq.put("mar", 1528);
    freq.put("max", 33);
    freq.put("ece", 119);
    freq.put("eco", 36);
    freq.put("eck", 1051);
    freq.put("eci", 709);
    freq.put("ech", 33);
    freq.put("ect", 51);
    freq.put("x", 3220);
    freq.put("IF ", 73);
    freq.put("någ", 1898);
    freq.put("rs ", 1224);
    freq.put("AN ", 114);
    freq.put(" Sy", 164);
    freq.put("DU ", 43);
    freq.put(" Sp", 470);
    freq.put(" Sv", 785);
    freq.put(" Sw", 66);
    freq.put(" St", 1426);
    freq.put(" Su", 288);
    freq.put(" Sj", 254);
    freq.put(" Sk", 1349);
    freq.put(" Sh", 129);
    freq.put(" Si", 396);
    freq.put(" Sn", 381);
    freq.put(" So", 597);
    freq.put(" Sl", 201);
    freq.put(" Sm", 117);
    freq.put(" Sc", 103);
    freq.put("Öve", 69);
    freq.put("man", 4622);
    freq.put(" Se", 702);
    freq.put("rsl", 155);
    freq.put("rsm", 45);
    freq.put("rso", 553);
    freq.put("rsh", 35);
    freq.put("rsi", 182);
    freq.put("rsj", 30);
    freq.put("rsk", 510);
    freq.put("rsd", 147);
    freq.put("rse", 339);
    freq.put("rsa", 205);
    freq.put("rsb", 47);
    freq.put("R", 2553);
    freq.put("rst", 1771);
    freq.put("rsu", 40);
    freq.put("rsv", 198);
    freq.put("rsp", 109);
    freq.put("nåt", 306);
    freq.put("NU ", 69);
    freq.put("rss", 122);
    freq.put("bek", 129);
    freq.put("beh", 672);
    freq.put("ben", 297);
    freq.put("bel", 245);
    freq.put("bem", 37);
    freq.put("beb", 52);
    freq.put("når", 54);
    freq.put("bea", 41);
    freq.put("bef", 82);
    freq.put("beg", 142);
    freq.put("bed", 55);
    freq.put("fjä", 54);
    freq.put("ber", 1093);
    freq.put("bes", 689);
    freq.put(" S ", 134);
    freq.put("bev", 90);
    freq.put("bet", 1152);
    freq.put("py ", 55);
    freq.put("ur ", 2234);
    freq.put(" Sö", 213);
    freq.put("arm", 351);
    freq.put(" Sä", 212);
    freq.put(" Så", 869);
    freq.put("itu", 66);
    freq.put("rsä", 260);
    freq.put("rså", 47);
    freq.put("pyr", 30);
    freq.put("Åh ", 141);
    freq.put("rsö", 525);
    freq.put("ure", 193);
    freq.put("urf", 57);
    freq.put("urg", 105);
    freq.put("ura", 230);
    freq.put("urb", 31);
    freq.put("url", 58);
    freq.put("urm", 27);
    freq.put("urn", 181);
    freq.put("uro", 138);
    freq.put("uri", 101);
    freq.put("urk", 106);
    freq.put("urt", 65);
    freq.put("uru", 28);
    freq.put("urv", 32);
    freq.put("urr", 156);
    freq.put("urs", 276);
    freq.put("bun", 72);
    freq.put("mg ", 32);
    freq.put("bul", 113);
    freq.put("ngd", 263);
    freq.put("nge", 4403);
    freq.put("ngf", 48);
    freq.put("nga", 2516);
    freq.put("ngb", 68);
    freq.put("ngl", 181);
    freq.put("ngn", 127);
    freq.put("ngo", 98);
    freq.put("ngi", 64);
    freq.put("ngk", 31);
    freq.put("sh ", 132);
    freq.put("ngv", 35);
    freq.put("ngr", 397);
    freq.put("ngs", 1073);
    freq.put("tbr", 53);
    freq.put("tbu", 48);
    freq.put("tbi", 135);
    freq.put(" åt", 636);
    freq.put("tbo", 265);
    freq.put("tba", 64);
    freq.put("tbe", 37);
    freq.put("ävl", 812);
    freq.put("sht", 30);
    freq.put("shu", 33);
    freq.put("äve", 513);
    freq.put("äva", 46);
    freq.put("sha", 188);
    freq.put("shb", 26);
    freq.put("she", 69);
    freq.put("shi", 141);
    freq.put(" ås", 91);
    freq.put("ävs", 29);
    freq.put("sho", 220);
    freq.put("ke ", 1371);
    freq.put("ngå", 74);
    freq.put("lur", 114);
    freq.put("lus", 240);
    freq.put("lut", 1142);
    freq.put("lub", 135);
    freq.put("lue", 31);
    freq.put("luf", 84);
    freq.put("lug", 312);
    freq.put("luk", 109);
    freq.put("lum", 67);
    freq.put("lun", 358);
    freq.put("ken", 1774);
    freq.put("kel", 460);
    freq.put("kej", 279);
    freq.put("mgå", 99);
    freq.put("ked", 112);
    freq.put("keb", 44);
    freq.put("key", 132);
    freq.put("ket", 1772);
    freq.put("kes", 138);
    freq.put("ker", 3264);
    freq.put("kep", 64);
    freq.put("shå", 30);
    freq.put("ot ", 1873);
    freq.put("Lon", 54);
    freq.put("Lov", 54);
    freq.put("Lot", 27);
    freq.put("yan", 27);
    freq.put("oth", 56);
    freq.put("oti", 232);
    freq.put(" Åh", 169);
    freq.put("oto", 237);
    freq.put("ota", 281);
    freq.put("otb", 221);
    freq.put("ote", 346);
    freq.put(" Åt", 64);
    freq.put("otr", 98);
    freq.put("ots", 268);
    freq.put("ott", 933);
    freq.put(" År", 51);
    freq.put(" br", 2971);
    freq.put("And", 198);
    freq.put("Ang", 38);
    freq.put("Ann", 195);
    freq.put("Ant", 87);
    freq.put("ya ", 695);
    freq.put("Föl", 61);
    freq.put("Då ", 323);
    freq.put("You", 64);
    freq.put("Yor", 30);
    freq.put("Dål", 33);
    freq.put("i", 135417);
    freq.put("ksi", 26);
    freq.put(" xD", 83);
    freq.put("Be", 511);
    freq.put("Ba", 665);
    freq.put("Bl", 532);
    freq.put("Bo", 496);
    freq.put("Bi", 272);
    freq.put("Bj", 81);
    freq.put("Bu", 148);
    freq.put(" xx", 79);
    freq.put("Br", 678);
    freq.put("By", 59);
    freq.put("B ", 287);
    freq.put(" x ", 64);
    freq.put("jla", 26);
    freq.put("jli", 224);
    freq.put("U ", 245);
    freq.put("Bä", 133);
    freq.put("Går", 109);
    freq.put("Bö", 119);
    freq.put("Ut", 177);
    freq.put("Up", 226);
    freq.put("Us", 53);
    freq.put("Ur", 57);
    freq.put("Um", 36);
    freq.put("Ul", 58);
    freq.put("Un", 369);
    freq.put("LL ", 49);
    freq.put("dun", 42);
    freq.put("Gå ", 39);
    freq.put("py", 153);
    freq.put("ea ", 99);
    freq.put("gör", 1907);
    freq.put("h ", 12910);
    freq.put("eak", 104);
    freq.put("hy", 299);
    freq.put("eam", 74);
    freq.put("eal", 78);
    freq.put("ean", 81);
    freq.put("hr", 127);
    freq.put("hs", 34);
    freq.put("eac", 27);
    freq.put("ead", 70);
    freq.put("eag", 54);
    freq.put("hu", 2182);
    freq.put("hj", 570);
    freq.put("hh", 209);
    freq.put("hi", 1740);
    freq.put("hn", 93);
    freq.put("ho", 3691);
    freq.put("hl", 258);
    freq.put("hm", 136);
    freq.put("hb", 41);
    freq.put("eas", 81);
    freq.put("ear", 139);
    freq.put("eat", 157);
    freq.put("hd", 34);
    freq.put("he", 7169);
    freq.put("dma", 36);
    freq.put("dus", 119);
    freq.put("dmi", 30);
    freq.put("dmo", 66);
    freq.put("hn ", 44);
    freq.put(" Ut", 176);
    freq.put(" Up", 222);
    freq.put(" Ur", 56);
    freq.put(" Us", 49);
    freq.put(" Ul", 58);
    freq.put(" Um", 36);
    freq.put(" Un", 369);
    freq.put("Lun", 92);
    freq.put("xå ", 92);
    freq.put("hö", 2039);
    freq.put("hä", 3327);
    freq.put("hå", 1356);
    freq.put(" U ", 31);
    freq.put("MS ", 36);
    freq.put("Igå", 63);
    freq.put("aud", 32);
    freq.put("aug", 42);
    freq.put("auf", 27);
    freq.put("blo", 616);
    freq.put("up ", 153);
    freq.put("aus", 81);
    freq.put("aur", 61);
    freq.put("aut", 90);
    freq.put("meå", 31);
    freq.put("ble", 764);
    freq.put("upe", 195);
    freq.put("sjö", 95);
    freq.put("drö", 182);
    freq.put("upt", 26);
    freq.put("drä", 54);
    freq.put("sjä", 796);
    freq.put("me ", 534);
    freq.put("nen", 1348);
    freq.put("nel", 263);
    freq.put("nem", 58);
    freq.put("nej", 302);
    freq.put("nek", 50);
    freq.put("neh", 76);
    freq.put("neg", 58);
    freq.put("ned", 161);
    freq.put("nee", 29);
    freq.put("neb", 93);
    freq.put("nec", 26);
    freq.put("nea", 52);
    freq.put("ney", 35);
    freq.put("nev", 27);
    freq.put("net", 532);
    freq.put("ner", 2698);
    freq.put("nes", 381);
    freq.put("nep", 40);
    freq.put("Pus", 37);
    freq.put("med", 6924);
    freq.put("meb", 36);
    freq.put("mel", 382);
    freq.put("men", 4489);
    freq.put("mej", 99);
    freq.put("met", 524);
    freq.put("mes", 449);
    freq.put("mer", 3113);
    freq.put("dry", 53);
    freq.put("äpp", 310);
    freq.put("dru", 69);
    freq.put("ne ", 940);
    freq.put("sju", 713);
    freq.put("dri", 1008);
    freq.put("dro", 231);
    freq.put("dra", 2152);
    freq.put("dre", 381);
    freq.put("Tit", 85);
    freq.put("Ste", 145);
    freq.put("kgr", 38);
    freq.put("Sta", 281);
    freq.put("Sto", 491);
    freq.put("Sth", 115);
    freq.put("Sti", 38);
    freq.put("Stu", 58);
    freq.put("ovä", 84);
    freq.put("V", 5052);
    freq.put("Sty", 26);
    freq.put("gpl", 35);
    freq.put("Til", 136);
    freq.put("Tim", 59);
    freq.put("Tin", 30);
    freq.put("vfö", 52);
    freq.put("ygg", 639);
    freq.put("yge", 85);
    freq.put("Lig", 52);
    freq.put("Lib", 40);
    freq.put("Lil", 40);
    freq.put("ygn", 74);
    freq.put("Lin", 178);
    freq.put("Lik", 51);
    freq.put("Lit", 181);
    freq.put("Tid", 73);
    freq.put("ov ", 221);
    freq.put("ygp", 35);
    freq.put("Kaf", 36);
    freq.put("Kan", 663);
    freq.put("Kam", 33);
    freq.put("Kal", 87);
    freq.put("Kar", 111);
    freq.put("Kat", 41);
    freq.put("Stä", 71);
    freq.put("ovs", 35);
    freq.put("yg ", 85);
    freq.put("Stö", 39);
    freq.put("ova", 554);
    freq.put("ove", 377);
    freq.put("ovi", 136);
    freq.put("ovo", 31);
    freq.put("All", 665);
    freq.put("Alm", 28);
    freq.put("Ali", 31);
    freq.put("Ald", 38);
    freq.put("Ale", 62);
    freq.put("isö", 26);
    freq.put("Wor", 106);
    freq.put("SS ", 29);
    freq.put(" zo", 29);
    freq.put("is ", 1964);
    freq.put("isy", 28);
    freq.put("iss", 1427);
    freq.put("isp", 38);
    freq.put("ist", 2245);
    freq.put("isk", 2567);
    freq.put("xue", 26);
    freq.put("isi", 73);
    freq.put("ish", 89);
    freq.put("iso", 49);
    freq.put("isn", 100);
    freq.put("ism", 138);
    freq.put("isl", 53);
    freq.put("isc", 60);
    freq.put("isb", 36);
    freq.put("isa", 614);
    freq.put("isf", 45);
    freq.put("ise", 527);
    freq.put("isd", 95);
    freq.put("Eur", 74);
    freq.put(" tå", 319);
    freq.put("jja", 30);
    freq.put("Col", 40);
    freq.put("Coo", 39);
    freq.put("Con", 40);
    freq.put("gym", 108);
    freq.put("På ", 350);
    freq.put("Läg", 64);
    freq.put("Län", 93);
    freq.put("Läs", 192);
    freq.put("Lär", 70);
    freq.put("Lät", 43);
    freq.put("ty ", 139);
    freq.put("äm ", 31);
    freq.put("do ", 146);
    freq.put("tyl", 27);
    freq.put("tym", 31);
    freq.put("tyd", 364);
    freq.put("tyg", 126);
    freq.put("tyc", 719);
    freq.put("tyv", 162);
    freq.put("typ", 543);
    freq.put("tyr", 196);
    freq.put("tys", 136);
    freq.put("dok", 77);
    freq.put("ämd", 42);
    freq.put("äme", 38);
    freq.put("ämf", 61);
    freq.put("dom", 846);
    freq.put("doc", 387);
    freq.put("m", 84288);
    freq.put("dog", 39);
    freq.put("ämn", 472);
    freq.put("ämp", 138);
    freq.put("ämr", 58);
    freq.put("äms", 141);
    freq.put("ämt", 279);
    freq.put("dor", 155);
    freq.put("dos", 31);
    freq.put("dop", 51);
    freq.put("dov", 26);
    freq.put("dow", 44);
    freq.put("dot", 73);
    freq.put(" We", 142);
    freq.put(" Wa", 129);
    freq.put(" Wo", 164);
    freq.put(" Wh", 46);
    freq.put(" Wi", 183);
    freq.put("mö ", 167);
    freq.put("ba ", 393);
    freq.put("omä", 32);
    freq.put("vös", 37);
    freq.put("omö", 48);
    freq.put("mör", 259);
    freq.put("mös", 38);
    freq.put("möt", 324);
    freq.put("bas", 163);
    freq.put("Hjä", 79);
    freq.put("möb", 32);
    freq.put("bab", 54);
    freq.put("bac", 219);
    freq.put("ban", 598);
    freq.put("möj", 183);
    freq.put("baj", 65);
    freq.put("bak", 628);
    freq.put("om ", 14273);
    freq.put("Eft", 148);
    freq.put("un ", 158);
    freq.put("Så ", 645);
    freq.put("omb", 189);
    freq.put("oma", 318);
    freq.put("omg", 83);
    freq.put("omf", 39);
    freq.put("ome", 372);
    freq.put("omd", 27);
    freq.put("omk", 66);
    freq.put("omi", 278);
    freq.put("omh", 60);
    freq.put("omo", 77);
    freq.put("omn", 210);
    freq.put("omm", 2802);
    freq.put("oml", 49);
    freq.put("oms", 227);
    freq.put("omr", 104);
    freq.put("omp", 327);
    freq.put("omv", 36);
    freq.put("omt", 69);
    freq.put("uns", 92);
    freq.put("unt", 280);
    freq.put("Såg", 105);
    freq.put("una", 98);
    freq.put("Såd", 31);
    freq.put("und", 2690);
    freq.put("une", 80);
    freq.put("ung", 1012);
    freq.put("Sån", 35);
    freq.put("unk", 488);
    freq.put("unn", 543);
    freq.put("iö", 131);
    freq.put("iä", 120);
    freq.put("C ", 263);
    freq.put("är ", 18851);
    freq.put("Uta", 33);
    freq.put("gli", 256);
    freq.put("Svå", 55);
    freq.put("onå", 36);
    freq.put("Ci", 83);
    freq.put("Ch", 242);
    freq.put("Vä", 570);
    freq.put("Vå", 105);
    freq.put("Cl", 90);
    freq.put("slu", 887);
    freq.put("ärs", 319);
    freq.put("ärr", 376);
    freq.put("ärt", 493);
    freq.put("Ce", 82);
    freq.put("ärv", 92);
    freq.put("äri", 99);
    freq.put("ärh", 36);
    freq.put("Cy", 49);
    freq.put("slo", 135);
    freq.put("ärm", 344);
    freq.put("ärl", 974);
    freq.put("äro", 53);
    freq.put("ärn", 564);
    freq.put("ära", 598);
    freq.put("sle", 113);
    freq.put("äre", 260);
    freq.put("ärd", 497);
    freq.put("ärg", 143);
    freq.put("ärf", 140);
    freq.put("ix", 349);
    freq.put("iz", 142);
    freq.put("ip", 1352);
    freq.put("is", 10302);
    freq.put("ir", 2461);
    freq.put("iu", 129);
    freq.put("it", 10649);
    freq.put("iv", 3413);
    freq.put("ii", 239);
    freq.put("ih", 471);
    freq.put("ik", 5431);
    freq.put("ij", 30);
    freq.put("im", 2026);
    freq.put("il", 14022);
    freq.put("Nat", 85);
    freq.put("in", 30624);
    freq.put("ia", 1958);
    freq.put("ic", 3086);
    freq.put("ib", 514);
    freq.put("ie", 1894);
    freq.put("id", 6314);
    freq.put("ig", 18604);
    freq.put("if", 981);
    freq.put("V ", 316);
    freq.put("iP", 151);
    freq.put("aki", 90);
    freq.put("iO", 37);
    freq.put("akn", 500);
    freq.put("kis", 190);
    freq.put("kip", 34);
    freq.put("kiv", 123);
    freq.put("kit", 415);
    freq.put("kik", 37);
    freq.put("kin", 333);
    freq.put("kil", 540);
    freq.put("kic", 298);
    freq.put("i ", 17025);
    freq.put("kig", 361);
    freq.put("kie", 42);
    freq.put("kid", 59);
    freq.put("Va", 1683);
    freq.put("Ve", 499);
    freq.put("Vi", 1725);
    freq.put("slö", 171);
    freq.put("Vo", 65);
    freq.put("ake", 679);
    freq.put("slä", 375);
    freq.put("slå", 175);
    freq.put("yen", 34);
    freq.put("op ", 408);
    freq.put("yes", 43);
    freq.put("yer", 31);
    freq.put("öf ", 32);
    freq.put("vd ", 38);
    freq.put("opt", 54);
    freq.put("opu", 34);
    freq.put("opp", 1551);
    freq.put("opr", 32);
    freq.put("ops", 58);
    freq.put("ye ", 30);
    freq.put("ope", 147);
    freq.put("opa", 181);
    freq.put("opc", 26);
    freq.put("opl", 28);
    freq.put("opo", 42);
    freq.put("opi", 93);
    freq.put("Ars", 32);
    freq.put("Arb", 39);
    freq.put("vde", 104);
    freq.put("www", 43);
    freq.put("pär", 68);
    freq.put("pän", 260);
    freq.put("Tur", 120);
    freq.put("idé", 122);
    freq.put("opå", 27);
    freq.put("ww ", 57);
    freq.put("DN ", 106);
    freq.put("Å", 505);
    freq.put("TE ", 121);
    freq.put("kop", 200);
    freq.put("Z", 178);
    freq.put("fs ", 107);
    freq.put("EA ", 30);
    freq.put("fsa", 31);
    freq.put("Win", 57);
    freq.put("Wil", 49);
    freq.put("fss", 31);
    freq.put("Grö", 37);
    freq.put("di ", 40);
    freq.put("Rät", 62);
    freq.put("dil", 28);
    freq.put("Bör", 106);
    freq.put("din", 740);
    freq.put("dio", 305);
    freq.put("dik", 83);
    freq.put("did", 42);
    freq.put("die", 257);
    freq.put("dig", 2520);
    freq.put("dia", 230);
    freq.put("dic", 72);
    freq.put("dit", 432);
    freq.put("div", 54);
    freq.put("dir", 194);
    freq.put("dis", 564);
    freq.put(" Yo", 104);
    freq.put(" Ye", 56);
    freq.put("Gry", 51);
    freq.put("Gre", 84);
    freq.put("Gra", 205);
    freq.put("tne", 70);
    freq.put("bo ", 119);
    freq.put("box", 71);
    freq.put("boy", 28);
    freq.put("åpe", 35);
    freq.put("tni", 417);
    freq.put("bor", 1495);
    freq.put("bos", 83);
    freq.put("hba", 27);
    freq.put("Wo", 167);
    freq.put("bok", 512);
    freq.put("bol", 393);
    freq.put("bom", 57);
    freq.put("bon", 98);
    freq.put("boo", 315);
    freq.put("bod", 59);
    freq.put("boe", 45);
    freq.put("åm", 89);
    freq.put("ål", 2173);
    freq.put("ån", 5960);
    freq.put("oo ", 90);
    freq.put("åk", 1033);
    freq.put("åe", 137);
    freq.put("åd", 922);
    freq.put("åg", 3974);
    freq.put("åf", 44);
    freq.put("åa", 42);
    freq.put("åb", 64);
    freq.put("åt", 2830);
    freq.put("åv", 142);
    freq.put("åp", 99);
    freq.put("ås", 1646);
    freq.put("år", 7065);
    freq.put("fl ", 29);
    freq.put("ul ", 665);
    freq.put("ays", 32);
    freq.put("ood", 123);
    freq.put("snä", 167);
    freq.put("Ben", 49);
    freq.put("Bel", 34);
    freq.put("oom", 46);
    freq.put("ool", 171);
    freq.put("ooo", 153);
    freq.put("Bea", 28);
    freq.put("å ", 25302);
    freq.put("ook", 360);
    freq.put("snö", 88);
    freq.put("oot", 47);
    freq.put("oop", 56);
    freq.put("oor", 41);
    freq.put("Ber", 143);
    freq.put("Bes", 58);
    freq.put("fly", 398);
    freq.put("uls", 50);
    freq.put("flu", 59);
    freq.put("ay ", 238);
    freq.put("ult", 334);
    freq.put("fli", 177);
    freq.put("ulk", 32);
    freq.put("uli", 68);
    freq.put("flo", 45);
    freq.put("fla", 149);
    freq.put("ula", 147);
    freq.put("fle", 392);
    freq.put("uld", 159);
    freq.put("ule", 191);
    freq.put("åå", 438);
    freq.put("ma ", 1976);
    freq.put("nys", 160);
    freq.put("nyt", 309);
    freq.put("nyk", 28);
    freq.put("nyh", 144);
    freq.put("nyl", 37);
    freq.put("nym", 32);
    freq.put("nyb", 32);
    freq.put("nyc", 41);
    freq.put("nya", 605);
    freq.put("nyf", 70);
    freq.put("nyg", 293);
    freq.put("map", 29);
    freq.put("mas", 552);
    freq.put("sne", 45);
    freq.put("mat", 1259);
    freq.put("sna", 1181);
    freq.put("sno", 77);
    freq.put("sni", 574);
    freq.put("mac", 99);
    freq.put("snu", 122);
    freq.put("mad", 65);
    freq.put("mag", 203);
    freq.put("Urs", 26);
    freq.put("mai", 152);
    freq.put("mak", 255);
    freq.put("maj", 37);
    freq.put("mam", 221);
    freq.put("mal", 334);
    freq.put("sny", 267);
    freq.put("åll", 948);
    freq.put("flö", 83);
    freq.put("q", 155);
    freq.put("ny ", 381);
    freq.put("ljö", 106);
    freq.put("flä", 56);
    freq.put("ulä", 48);
    freq.put("lsf", 27);
    freq.put("lse", 557);
    freq.put("lsb", 42);
    freq.put("lsa", 271);
    freq.put("lsn", 30);
    freq.put("lso", 68);
    freq.put("lsl", 32);
    freq.put("lsm", 55);
    freq.put("lsk", 821);
    freq.put("lsi", 84);
    freq.put("lsv", 71);
    freq.put("lst", 453);
    freq.put("lss", 111);
    freq.put("lsp", 67);
    freq.put("åle", 75);
    freq.put(" aa", 55);
    freq.put(" ab", 145);
    freq.put(" ac", 98);
    freq.put(" ad", 130);
    freq.put(" af", 117);
    freq.put(" ag", 77);
    freq.put(" ah", 86);
    freq.put(" aj", 39);
    freq.put(" ak", 182);
    freq.put(" al", 4160);
    freq.put(" am", 133);
    freq.put(" an", 2813);
    freq.put(" ap", 225);
    freq.put(" ar", 793);
    freq.put(" as", 256);
    freq.put(" at", 12168);
    freq.put(" au", 132);
    freq.put(" av", 4043);
    freq.put(" aw", 53);
    freq.put(" ax", 28);
    freq.put("ls ", 572);
    freq.put("Äve", 51);
    freq.put("Sha", 33);
    freq.put("kko", 28);
    freq.put("åls", 29);
    freq.put("Shi", 39);
    freq.put("orä", 27);
    freq.put("orå", 50);
    freq.put("Sho", 35);
    freq.put(" a ", 330);
    freq.put("xla", 42);
    freq.put("lså", 31);
    freq.put("Lul", 49);
    freq.put("or ", 3376);
    freq.put("Ken", 47);
    freq.put("öd ", 240);
    freq.put("RT ", 796);
    freq.put("G", 3070);
    freq.put("ory", 50);
    freq.put("orv", 67);
    freq.put("ort", 2512);
    freq.put("oru", 60);
    freq.put("orr", 428);
    freq.put("ors", 681);
    freq.put("orp", 45);
    freq.put("orn", 649);
    freq.put("oro", 114);
    freq.put("orl", 122);
    freq.put("orm", 449);
    freq.put("ork", 342);
    freq.put("ori", 542);
    freq.put("orf", 39);
    freq.put("org", 1712);
    freq.put("ord", 1910);
    freq.put("ore", 455);
    freq.put("orb", 36);
    freq.put("ora", 370);
    freq.put("öds", 68);
    freq.put("ödr", 47);
    freq.put("ödv", 43);
    freq.put("App", 100);
    freq.put("vju", 117);
    freq.put("öda", 164);
    freq.put("öde", 332);
    freq.put("ödd", 54);
    freq.put("ödi", 75);
    freq.put("Dä", 135);
    freq.put("Då", 358);
    freq.put("Dö", 63);
    freq.put("Otr", 28);
    freq.put("en ", 34261);
    freq.put("xpr", 47);
    freq.put("IS ", 41);
    freq.put("Do", 303);
    freq.put("Dj", 67);
    freq.put("Di", 216);
    freq.put("De", 3824);
    freq.put("Da", 660);
    freq.put("Dy", 32);
    freq.put("Du", 676);
    freq.put("Dr", 216);
    freq.put("D ", 750);
    freq.put("ge ", 1253);
    freq.put("We", 142);
    freq.put("Wa", 130);
    freq.put("HA ", 106);
    freq.put("Wi", 183);
    freq.put("Wh", 46);
    freq.put("air", 32);
    freq.put("ges", 290);
    freq.put("ger", 2404);
    freq.put("get", 1251);
    freq.put("jö", 547);
    freq.put("gef", 91);
    freq.put("ged", 26);
    freq.put("jä", 3114);
    freq.put("gen", 7245);
    freq.put("gem", 78);
    freq.put("gel", 409);
    freq.put("W ", 117);
    freq.put("dkä", 36);
    freq.put("utk", 33);
    freq.put("uti", 229);
    freq.put("tu ", 28);
    freq.put("j ", 2265);
    freq.put("ain", 95);
    freq.put("tup", 58);
    freq.put("CH ", 57);
    freq.put("jt", 164);
    freq.put("ju", 4946);
    freq.put("tur", 585);
    freq.put("tus", 144);
    freq.put("tut", 57);
    freq.put("js", 179);
    freq.put("jl", 284);
    freq.put("jm", 33);
    freq.put("jn", 76);
    freq.put("jo", 2494);
    freq.put("tul", 69);
    freq.put("ji", 63);
    freq.put("jj", 63);
    freq.put("jk", 188);
    freq.put("jd", 326);
    freq.put("je", 2060);
    freq.put("tub", 64);
    freq.put("tud", 220);
    freq.put("ja", 14747);
    freq.put("tuf", 58);
    freq.put("tug", 89);
    freq.put("z", 798);
    freq.put("dka", 48);
    freq.put("dko", 34);
    freq.put("tum", 158);
    freq.put("tun", 321);
    freq.put("tua", 33);
    freq.put("tue", 104);
    freq.put(" hu", 1851);
    freq.put("pap", 213);
    freq.put("par", 1268);
    freq.put("pas", 999);
    freq.put("pat", 233);
    freq.put("pau", 53);
    freq.put("pac", 99);
    freq.put("pad", 242);
    freq.put("pag", 49);
    freq.put("paj", 42);
    freq.put("pak", 69);
    freq.put("pal", 81);
    freq.put("pam", 42);
    freq.put("pan", 409);
    freq.put("oin", 75);
    freq.put("SA ", 108);
    freq.put("A ", 869);
    freq.put("oid", 59);
    freq.put("pa ", 1122);
    freq.put("röd", 185);
    freq.put("rök", 108);
    freq.put("röj", 95);
    freq.put("rön", 149);
    freq.put("röm", 408);
    freq.put("röl", 55);
    freq.put("rös", 246);
    freq.put("rör", 177);
    freq.put("röv", 81);
    freq.put("röt", 425);
    freq.put("mo ", 67);
    freq.put("kmä", 39);
    freq.put("mos", 94);
    freq.put("mor", 1589);
    freq.put("Sjö", 37);
    freq.put("mot", 1147);
    freq.put("mok", 80);
    freq.put("mon", 207);
    freq.put("mom", 45);
    freq.put("mol", 47);
    freq.put("mob", 207);
    freq.put("Sjä", 118);
    freq.put("mod", 288);
    freq.put("höj", 107);
    freq.put("Nej", 328);
    freq.put("höl", 64);
    freq.put("hög", 378);
    freq.put("New", 83);
    freq.put("hös", 202);
    freq.put("hör", 628);
    freq.put("höv", 595);
    freq.put("Med", 235);
    freq.put(" ch", 506);
    freq.put(" ci", 145);
    freq.put(" co", 404);
    freq.put(" cl", 49);
    freq.put("Mel", 50);
    freq.put("Men", 1419);
    freq.put(" ce", 101);
    freq.put("Met", 38);
    freq.put(" cy", 127);
    freq.put("kmr", 26);
    freq.put("Mes", 44);
    freq.put("Mer", 76);
    freq.put(" cr", 84);
    freq.put(" cu", 51);
    freq.put("Sju", 96);
    freq.put("Dri", 54);
    freq.put("Dra", 66);
    freq.put("km ", 71);
    freq.put(" c ", 42);
    freq.put("xna", 39);
    freq.put("yyy", 30);
    freq.put("Av ", 31);
    freq.put("vh ", 92);
    freq.put("na ", 6860);
    freq.put("e", 213645);
    freq.put("Af", 134);
    freq.put("Avs", 28);
    freq.put("Ai", 31);
    freq.put("öjl", 223);
    freq.put("öja", 134);
    freq.put("Ak", 44);
    freq.put("öje", 76);
    freq.put("öjd", 201);
    freq.put("sve", 569);
    freq.put("dva", 38);
    freq.put("sva", 867);
    freq.put("Vi ", 707);
    freq.put("u", 47172);
    freq.put("Vak", 55);
    freq.put("Van", 38);
    freq.put("Val", 38);
    freq.put("sly", 41);
    freq.put("Vad", 644);
    freq.put("Var", 743);
    freq.put("ws ", 55);
    freq.put("täk", 30);
    freq.put("edi", 547);
    freq.put("ium", 90);
    freq.put("tän", 1170);
    freq.put("täm", 267);
    freq.put("täl", 1030);
    freq.put("täc", 139);
    freq.put("edn", 178);
    freq.put("Va ", 73);
    freq.put("täd", 132);
    freq.put("TA ", 58);
    freq.put("aja", 111);
    freq.put("tär", 110);
    freq.put("ius", 27);
    freq.put("akr", 38);
    freq.put("täv", 137);
    freq.put("tät", 29);
    freq.put("hyl", 66);
    freq.put("hyr", 70);
    freq.put("hys", 49);
    freq.put("gg ", 710);
    freq.put("aba", 76);
    freq.put("abb", 343);
    freq.put("gl", 1477);
    freq.put("abe", 89);
    freq.put("abi", 73);
    freq.put("abl", 71);
    freq.put("abo", 66);
    freq.put("abr", 53);
    freq.put("abs", 119);
    freq.put("aby", 29);
    freq.put("ggt", 113);
    freq.put("ggs", 52);
    freq.put("ggr", 83);
    freq.put("K", 4216);
    freq.put("gge", 695);
    freq.put("ggd", 30);
    freq.put("gga", 1043);
    freq.put("ggl", 59);
    freq.put("ggo", 28);
    freq.put("ggn", 75);
    freq.put("ggi", 97);
    freq.put("ab ", 87);
    freq.put("akt", 1395);
    freq.put("twe", 338);
    freq.put("twi", 621);
    freq.put("jd ", 145);
    freq.put("eys", 26);
    freq.put("LT ", 54);
    freq.put("de ", 10670);
    freq.put("ey ", 198);
    freq.put("äkt", 265);
    freq.put("äkr", 80);
    freq.put("dep", 60);
    freq.put("der", 4049);
    freq.put("des", 768);
    freq.put("det", 12303);
    freq.put("dev", 35);
    freq.put("dej", 60);
    freq.put("äke", 319);
    freq.put("del", 1351);
    freq.put("dem", 554);
    freq.put("den", 5478);
    freq.put("deo", 156);
    freq.put("äkn", 152);
    freq.put("dea", 44);
    freq.put("deb", 167);
    freq.put("dec", 53);
    freq.put("ded", 30);
    freq.put("dee", 38);
    freq.put("def", 91);
    freq.put("deg", 32);
    freq.put("ryn", 70);
    freq.put("ryl", 34);
    freq.put("rym", 276);
    freq.put("ryk", 86);
    freq.put("Tyd", 36);
    freq.put("ryg", 179);
    freq.put("ryd", 58);
    freq.put("ryc", 246);
    freq.put("rya", 29);
    freq.put("ryt", 129);
    freq.put("ryr", 44);
    freq.put("rys", 150);
    freq.put("ryp", 39);
    freq.put("Tys", 45);
    freq.put("Don", 50);
    freq.put("Dom", 77);
    freq.put("Doc", 93);
    freq.put("jdå", 57);
    freq.put("cs ", 34);
    freq.put("ry ", 246);
    freq.put("uh ", 32);
    freq.put("ok ", 660);
    freq.put("Bat", 30);
    freq.put("okr", 91);
    freq.put("oku", 129);
    freq.put("Bas", 27);
    freq.put("uho", 80);
    freq.put("oka", 303);
    freq.put("oke", 364);
    freq.put("oki", 72);
    freq.put("Bal", 26);
    freq.put("okm", 41);
    freq.put("okl", 132);
    freq.put("oko", 50);
    freq.put("mm ", 239);
    freq.put("E ", 392);
    freq.put("akf", 27);
    freq.put("sbr", 104);
    freq.put("mmy", 33);
    freq.put("sbu", 34);
    freq.put("mmu", 185);
    freq.put("sby", 65);
    freq.put("mmm", 99);
    freq.put("mmo", 72);
    freq.put("sba", 82);
    freq.put("mmi", 216);
    freq.put("sbe", 85);
    freq.put("mme", 2577);
    freq.put("Uni", 41);
    freq.put("sbi", 70);
    freq.put("mma", 3036);
    freq.put("sbo", 107);
    freq.put("sbl", 29);
    freq.put("Em", 67);
    freq.put("El", 463);
    freq.put("Om ", 518);
    freq.put("Eh", 33);
    freq.put("Ek", 135);
    freq.put("Ed", 43);
    freq.put("Eg", 35);
    freq.put("Ef", 155);
    freq.put("Ex", 141);
    freq.put("Eu", 75);
    freq.put("Et", 216);
    freq.put("Ev", 48);
    freq.put("Es", 52);
    freq.put("Er", 129);
    freq.put("Är ", 626);
    freq.put(" el", 1529);
    freq.put(" em", 270);
    freq.put(" en", 8596);
    freq.put("koj", 77);
    freq.put(" eh", 55);
    freq.put("kol", 1339);
    freq.put(" ej", 217);
    freq.put(" ek", 111);
    freq.put(" ef", 1225);
    freq.put(" eg", 459);
    freq.put("kod", 68);
    freq.put("kog", 108);
    freq.put("kof", 27);
    freq.put(" ex", 570);
    freq.put(" et", 2596);
    freq.put(" eu", 44);
    freq.put("kos", 324);
    freq.put("kor", 1185);
    freq.put(" ep", 32);
    freq.put("kot", 156);
    freq.put(" er", 670);
    freq.put(" es", 31);
    freq.put("Slu", 84);
    freq.put("Sla", 27);
    freq.put("b", 34832);
    freq.put("kå", 254);
    freq.put("kä", 2083);
    freq.put("ko ", 53);
    freq.put(" e ", 436);
    freq.put("ååh", 41);
    freq.put("k ", 8229);
    freq.put("Kin", 71);
    freq.put("Kim", 26);
    freq.put("Kil", 38);
    freq.put("vna", 37);
    freq.put("vni", 143);
    freq.put("Att", 320);
    freq.put("Slä", 28);
    freq.put("kb", 132);
    freq.put("ka", 20433);
    freq.put("kg", 76);
    freq.put("kf", 135);
    freq.put("ke", 9536);
    freq.put("kd", 100);
    freq.put("kk", 120);
    freq.put("kj", 127);
    freq.put("ki", 2597);
    freq.put("kh", 502);
    freq.put("ko", 8253);
    freq.put("kn", 1842);
    freq.put("km", 224);
    freq.put("kl", 4357);
    freq.put("ks", 2157);
    freq.put("kr", 3408);
    freq.put("kp", 100);
    freq.put("kv", 2175);
    freq.put("ku", 3253);
    freq.put("kt", 7243);
    freq.put("ååå", 243);
    freq.put("ky", 585);
    freq.put(" Bå", 41);
    freq.put(" Bä", 132);
    freq.put(" Bö", 119);
    freq.put("Ser", 214);
    freq.put(" Be", 504);
    freq.put(" Ba", 664);
    freq.put(" Bl", 526);
    freq.put(" Bo", 479);
    freq.put(" Bi", 270);
    freq.put(" Bj", 81);
    freq.put(" Bu", 147);
    freq.put("ik ", 850);
    freq.put(" Br", 678);
    freq.put(" By", 59);
    freq.put("kto", 201);
    freq.put("iks", 373);
    freq.put(" B ", 67);
    freq.put("ikt", 1233);
    freq.put("ika", 1097);
    freq.put("ike", 897);
    freq.put("kte", 1132);
    freq.put("ikk", 33);
    freq.put("iki", 59);

    init3();
  }
  private static void init3() {
    
    freq.put("ikh", 30);
    freq.put("iko", 112);
    freq.put("ikn", 75);
    freq.put("ikl", 70);
    freq.put("SK ", 30);
    freq.put("Yes", 37);
    freq.put("raf", 519);
    freq.put("lbu", 97);
    freq.put("ga ", 4237);
    freq.put("ran", 1821);
    freq.put("dgå", 50);
    freq.put("gav", 70);
    freq.put("gat", 422);
    freq.put("gas", 391);
    freq.put("gar", 2803);
    freq.put("gan", 751);
    freq.put("gam", 356);
    freq.put("gal", 185);
    freq.put("gag", 61);
    freq.put("gad", 212);
    freq.put("lba", 443);
    freq.put("fus", 33);
    freq.put("fuc", 62);
    freq.put("fun", 539);
    freq.put("lbe", 62);
    freq.put("ful", 409);
    freq.put("sy ", 29);
    freq.put("bs ", 92);
    freq.put("lbo", 39);
    freq.put("äe ", 31);
    freq.put("syf", 40);
    freq.put("dge", 67);
    freq.put("syk", 62);
    freq.put("syn", 280);
    freq.put("sym", 36);
    freq.put("syl", 29);
    freq.put("dgr", 44);
    freq.put("syr", 77);
    freq.put("Drö", 40);
    freq.put("vD ", 44);
    freq.put("ew ", 86);
    freq.put("y", 16578);
    freq.put("lda", 216);
    freq.put("lde", 1052);
    freq.put("ldi", 358);
    freq.put("ldo", 30);
    freq.put("ldn", 95);
    freq.put("bi ", 154);
    freq.put("lds", 159);
    freq.put("ldr", 666);
    freq.put("ldt", 93);
    freq.put("rgr", 34);
    freq.put("rgs", 134);
    freq.put("rgu", 47);
    freq.put("cup", 42);
    freq.put("rga", 224);
    freq.put("rge", 214);
    freq.put("rgh", 26);
    freq.put("rgi", 149);
    freq.put("rgl", 51);
    freq.put("rgo", 1099);
    freq.put("bin", 116);
    freq.put("bio", 99);
    freq.put("Din", 39);
    freq.put("ld ", 602);
    freq.put("bif", 28);
    freq.put("big", 183);
    freq.put("bid", 72);
    freq.put("bie", 46);
    freq.put("bib", 76);
    freq.put("bia", 38);
    freq.put("bit", 219);
    freq.put("bis", 117);
    freq.put("Dis", 38);
    freq.put("rg ", 534);
    freq.put("pet", 326);
    freq.put("pep", 91);
    freq.put("per", 1404);
    freq.put("pes", 29);
    freq.put("pel", 1235);
    freq.put("pen", 987);
    freq.put("peh", 30);
    freq.put("rgå", 118);
    freq.put("pek", 151);
    freq.put("ped", 54);
    freq.put("peg", 32);
    freq.put("pea", 32);
    freq.put("pec", 177);
    freq.put("oes", 27);
    freq.put("oer", 39);
    freq.put("Bor", 189);
    freq.put("O", 2905);
    freq.put("Bok", 47);
    freq.put("Bol", 30);
    freq.put("oen", 140);
    freq.put("Bon", 34);
    freq.put("Boo", 36);
    freq.put("usc", 136);
    freq.put("Kna", 32);
    freq.put("uft", 75);
    freq.put("ä", 60963);
    freq.put(" Öp", 29);
    freq.put("pe ", 180);
    freq.put("Hun", 39);
    freq.put("nsi", 352);
    freq.put("nsk", 2430);
    freq.put("nsl", 318);
    freq.put("nsm", 39);
    freq.put("nso", 84);
    freq.put("al", 11411);
    freq.put("nsa", 528);
    freq.put("nsb", 53);
    freq.put("nsc", 44);
    freq.put("nsd", 121);
    freq.put("nse", 589);
    freq.put("nsf", 57);
    freq.put("nsg", 37);
    freq.put("nsp", 184);
    freq.put("nsr", 40);
    freq.put("nss", 160);
    freq.put("nst", 1411);
    freq.put("nsu", 87);
    freq.put("nsv", 199);
    freq.put(" gö", 1938);
    freq.put("Snä", 46);
    freq.put("mko", 41);
    freq.put("bän", 34);
    freq.put("bät", 522);
    freq.put(" gä", 591);
    freq.put(" gå", 2427);
    freq.put("Kör", 70);
    freq.put("mkr", 40);
    freq.put("Köp", 82);
    freq.put("bär", 161);
    freq.put("uss", 497);
    freq.put(" R ", 36);
    freq.put("Fly", 36);
    freq.put("ns ", 4417);
    freq.put("Fli", 26);
    freq.put("sde", 44);
    freq.put("sda", 453);
    freq.put("Fla", 37);
    freq.put("Fle", 55);
    freq.put("lyt", 233);
    freq.put("lys", 414);
    freq.put("lyx", 32);
    freq.put("nså", 57);
    freq.put("Nyt", 92);
    freq.put("lyf", 64);
    freq.put("lyg", 175);
    freq.put("Jön", 40);
    freq.put("lyc", 419);
    freq.put("Nyb", 41);
    freq.put("lym", 35);
    freq.put("Nya", 61);
    freq.put("nsö", 38);
    freq.put("lyk", 29);
    freq.put("Mas", 38);
    freq.put(" gu", 414);
    freq.put(" gr", 1543);
    freq.put("Mat", 145);
    freq.put("Sna", 227);
    freq.put("fån", 56);
    freq.put("Max", 34);
    freq.put(" gy", 123);
    freq.put(" gg", 44);
    freq.put("Mac", 84);
    freq.put(" ge", 855);
    freq.put(" gb", 32);
    freq.put("Mad", 31);
    freq.put("Mag", 79);
    freq.put(" ga", 893);
    freq.put("Mai", 28);
    freq.put(" go", 901);
    freq.put(" gl", 671);
    freq.put("Mam", 38);
    freq.put("Mal", 216);
    freq.put("Man", 457);
    freq.put("ly ", 136);
    freq.put("Ny ", 91);
    freq.put("Gul", 36);
    freq.put("kma", 47);
    freq.put("få ", 756);
    freq.put(" g ", 53);
    freq.put(" b", 20045);
    freq.put(" c", 1890);
    freq.put(" a", 26105);
    freq.put(" f", 29638);
    freq.put(" g", 12048);
    freq.put(" d", 35418);
    freq.put("ön ", 222);
    freq.put(" j", 17810);
    freq.put(" k", 19316);
    freq.put(" h", 26336);
    freq.put(" i", 28653);
    freq.put(" n", 15497);
    freq.put(" o", 21208);
    freq.put(" l", 12940);
    freq.put(" m", 32918);
    freq.put(" r", 7278);
    freq.put(" s", 51214);
    freq.put(" p", 20971);
    freq.put(" v", 23711);
    freq.put(" w", 691);
    freq.put(" t", 23125);
    freq.put(" u", 7088);
    freq.put(" z", 69);
    freq.put(" x", 291);
    freq.put(" y", 407);
    freq.put(" B", 4052);
    freq.put(" C", 1406);
    freq.put(" A", 3935);
    freq.put(" F", 5046);
    freq.put(" G", 3047);
    freq.put(" D", 7760);
    freq.put("sv ", 102);
    freq.put(" J", 6034);
    freq.put(" K", 4206);
    freq.put(" H", 7105);
    freq.put(" I", 3404);
    freq.put(" N", 4605);
    freq.put(" O", 2857);
    freq.put(" L", 3254);
    freq.put(" M", 6343);
    freq.put(" R", 2537);
    freq.put(" S", 10495);
    freq.put(" P", 3110);
    freq.put(" Q", 62);
    freq.put(" V", 5043);
    freq.put(" W", 800);
    freq.put(" T", 5183);
    freq.put(" U", 1288);
    freq.put(" Z", 176);
    freq.put(" X", 109);
    freq.put(" Y", 282);
    freq.put("´", 28);
    freq.put("vli", 551);
    freq.put("öne", 67);
    freq.put("önd", 263);
    freq.put("öna", 126);
    freq.put("vla", 664);
    freq.put("vle", 40);
    freq.put("öni", 46);
    freq.put("önt", 326);
    freq.put("öns", 289);
    freq.put(" ä", 15776);
    freq.put(" å", 2835);
    freq.put(" ö", 2356);
    freq.put(" Ä", 1171);
    freq.put(" Å", 503);
    freq.put(" Ö", 356);
    freq.put("Ork", 54);
    freq.put("Ord", 26);
    freq.put("ock", 2677);
    freq.put(" Do", 279);
    freq.put("Vet", 167);
    freq.put("Ver", 122);
    freq.put(" Dj", 65);
    freq.put(" Di", 215);
    freq.put(" De", 3810);
    freq.put(" Da", 655);
    freq.put(" Dy", 32);
    freq.put(" Du", 674);
    freq.put("Vem", 159);
    freq.put(" Dr", 212);
    freq.put("cha", 410);
    freq.put("Fr", 610);
    freq.put("che", 658);
    freq.put("chi", 134);
    freq.put("dö ", 57);
    freq.put("cho", 160);
    freq.put("Fa", 831);
    freq.put("Fe", 149);
    freq.put("chy", 41);
    freq.put("Fl", 192);
    freq.put("Fo", 338);
    freq.put(" D ", 310);
    freq.put("iii", 122);
    freq.put("ch ", 11337);
    freq.put("f", 44363);
    freq.put("död", 242);
    freq.put("F ", 313);
    freq.put("döt", 28);
    freq.put("döp", 27);
    freq.put("dör", 165);
    freq.put(" Då", 358);
    freq.put(" Dä", 135);
    freq.put(" Dö", 63);
    freq.put("AB ", 55);
    freq.put("afi", 246);
    freq.put("Fö", 1088);
    freq.put("Ya", 26);
    freq.put("afe", 81);
    freq.put("aff", 631);
    freq.put("Ye", 56);
    freq.put("afa", 113);
    freq.put("tai", 33);
    freq.put("Fä", 51);
    freq.put("Få", 275);
    freq.put("Död", 26);
    freq.put("aft", 384);
    freq.put("afr", 30);
    freq.put("Y ", 75);
    freq.put("af ", 246);
    freq.put("lfä", 98);
    freq.put("äg ", 410);
    freq.put("da ", 2222);
    freq.put("lfö", 43);
    freq.put("lf", 445);
    freq.put("lg", 604);
    freq.put("ld", 3422);
    freq.put("le", 11888);
    freq.put("lb", 785);
    freq.put("lc", 34);
    freq.put("tsh", 26);
    freq.put("la", 18315);
    freq.put("ln", 843);
    freq.put("eud", 110);
    freq.put("ll", 26655);
    freq.put("lm", 1724);
    freq.put("lj", 2055);
    freq.put("lk", 2022);
    freq.put("lh", 156);
    freq.put("li", 15593);
    freq.put("lv", 1786);
    freq.put("lt", 4888);
    freq.put("lu", 2702);
    freq.put("lr", 336);
    freq.put("ls", 3461);
    freq.put("lp", 466);
    freq.put("rdn", 113);
    freq.put("tsv", 58);
    freq.put("tst", 187);
    freq.put("tsu", 35);
    freq.put("lz", 26);
    freq.put("tss", 67);
    freq.put("åsi", 63);
    freq.put("eur", 57);
    freq.put("dad", 211);
    freq.put("daf", 73);
    freq.put("äga", 539);
    freq.put("ägg", 788);
    freq.put("äge", 970);
    freq.put("dal", 127);
    freq.put("dam", 149);
    freq.put("dan", 1504);
    freq.put("ägn", 53);
    freq.put("dak", 70);
    freq.put("dat", 597);
    freq.put("ägs", 67);
    freq.put("dar", 948);
    freq.put("das", 197);
    freq.put("day", 60);
    freq.put("l ", 15462);
    freq.put("KT ", 29);
    freq.put("ts ", 1491);
    freq.put("ås ", 213);
    freq.put("åke", 161);
    freq.put("lfa", 35);
    freq.put("lft", 33);
    freq.put("åka", 349);
    freq.put("lfr", 60);
    freq.put("lä", 4697);
    freq.put("lå", 1908);
    freq.put("rer", 564);
    freq.put("res", 1709);
    freq.put("rep", 250);
    freq.put("tså", 631);
    freq.put("rev", 601);
    freq.put("ret", 998);
    freq.put("lé", 30);
    freq.put("rej", 291);
    freq.put("rek", 588);
    freq.put("rei", 28);
    freq.put("ren", 1511);
    freq.put("reo", 30);
    freq.put("rel", 403);
    freq.put("rem", 266);
    freq.put("reb", 126);
    freq.put("rec", 649);
    freq.put("rea", 298);
    freq.put("ref", 97);
    freq.put("reg", 454);
    freq.put("red", 1284);
    freq.put("ree", 101);
    freq.put("lf ", 73);
    freq.put("que", 35);
    freq.put("qui", 29);
    freq.put("re ", 4765);
    freq.put("pga", 241);
    freq.put("pgi", 76);
    freq.put("ud ", 438);
    freq.put("og ", 1053);
    freq.put(" öd", 29);
    freq.put(" ög", 158);
    freq.put(" ök", 84);
    freq.put(" öl", 163);
    freq.put(" ön", 146);
    freq.put(" öp", 210);
    freq.put(" ös", 51);
    freq.put(" ör", 84);
    freq.put(" öv", 1344);
    freq.put("uds", 98);
    freq.put("udv", 42);
    freq.put("sfö", 160);
    freq.put("ogs", 41);
    freq.put("ogr", 324);
    freq.put("ogl", 165);
    freq.put("ogn", 32);
    freq.put("ogi", 174);
    freq.put("udg", 47);
    freq.put("udd", 99);
    freq.put("ude", 391);
    freq.put("oge", 131);
    freq.put("sfä", 34);
    freq.put("udi", 152);
    freq.put("oga", 82);
    freq.put(" ö ", 37);
    freq.put("nul", 31);
    freq.put("lim", 125);
    freq.put("Pap", 62);
    freq.put("Par", 82);
    freq.put("Pas", 34);
    freq.put("Pat", 53);
    freq.put("Pac", 27);
    freq.put("Pad", 51);
    freq.put("Pal", 50);
    freq.put("Pan", 44);
    freq.put("mik", 44);
    freq.put("mil", 527);
    freq.put("min", 3460);
    freq.put("mic", 60);
    freq.put("mie", 36);
    freq.put("mid", 289);
    freq.put("mig", 3050);
    freq.put("mif", 32);
    freq.put("mix", 32);
    freq.put("mis", 622);
    freq.put("mit", 895);
    freq.put("sfu", 30);
    freq.put("sfr", 65);
    freq.put("sfo", 39);
    freq.put("sfi", 45);
    freq.put("sfe", 47);
    freq.put("sfa", 55);
    freq.put("mi ", 156);
    freq.put(" iP", 150);
    freq.put(" iO", 37);
    freq.put("kst", 115);
    freq.put("ksp", 29);
    freq.put("kss", 40);
    freq.put(" ip", 73);
    freq.put("Mor", 95);
    freq.put(" ir", 109);
    freq.put(" is", 517);
    freq.put(" it", 144);
    freq.put(" iv", 76);
    freq.put("Mot", 62);
    freq.put(" ih", 262);
    freq.put("ksd", 66);
    freq.put("ksf", 27);
    freq.put("ksa", 187);
    freq.put(" im", 600);
    freq.put(" in", 12280);
    freq.put(" io", 85);
    freq.put(" ia", 249);
    freq.put(" ib", 159);
    freq.put(" ic", 47);
    freq.put(" id", 1480);
    freq.put("ksk", 36);
    freq.put(" ig", 1239);
    freq.put("vrå", 32);
    freq.put("ks ", 244);
    freq.put(" i ", 10226);
    freq.put("öl ", 154);
    freq.put("kså", 995);
    freq.put("wo", 201);
    freq.put("dä", 1719);
    freq.put("ölk", 66);
    freq.put("då", 2519);
    freq.put("öll", 136);
    freq.put("öld", 29);
    freq.put("S", 10550);
    freq.put("vre", 32);
    freq.put("vri", 132);
    freq.put("käl", 118);
    freq.put("käm", 204);
    freq.put("kän", 1249);
    freq.put("käk", 43);
    freq.put("käf", 37);
    freq.put("käg", 47);
    freq.put("ac", 3193);
    freq.put("ab", 1044);
    freq.put(" Få", 275);
    freq.put(" Fä", 51);
    freq.put("kär", 364);
    freq.put("uid", 44);
    freq.put("åna", 402);
    freq.put("ånd", 260);
    freq.put("åne", 76);
    freq.put("ång", 2377);
    freq.put("nä ", 108);
    freq.put("ys ", 190);
    freq.put("ånn", 35);
    freq.put("Hon", 166);
    freq.put("åns", 90);
    freq.put("ånt", 196);
    freq.put("ak", 4170);
    freq.put("OL ", 32);
    freq.put("am", 6146);
    freq.put("ild", 783);
    freq.put("oha", 127);
    freq.put("ile", 361);
    freq.put("byg", 184);
    freq.put("cou", 30);
    freq.put("ysk", 136);
    freq.put("ysi", 134);
    freq.put("näm", 148);
    freq.put("ysn", 27);
    freq.put("bjö", 67);
    freq.put("näc", 35);
    freq.put("uis", 26);
    freq.put("yse", 124);
    freq.put("Hou", 27);
    freq.put("väx", 127);
    freq.put("yss", 621);
    freq.put("näp", 28);
    freq.put("näs", 644);
    freq.put("när", 2519);
    freq.put("nät", 211);
    freq.put("yst", 440);
    freq.put(" Fr", 608);
    freq.put(" Fu", 233);
    freq.put("Hop", 260);
    freq.put(" Fy", 105);
    freq.put(" Fa", 828);
    freq.put(" Fe", 145);
    freq.put(" Fi", 664);
    freq.put(" Fl", 192);
    freq.put(" Fo", 333);
    freq.put("io ", 292);
    freq.put("coa", 27);
    freq.put("väc", 60);
    freq.put("väd", 130);
    freq.put("iot", 171);
    freq.put("ios", 46);
    freq.put("ior", 72);
    freq.put("iop", 26);
    freq.put("ion", 1862);
    freq.put("iol", 34);
    freq.put("iof", 72);
    freq.put("iod", 49);
    freq.put("GA ", 30);
    freq.put("väm", 31);
    freq.put("col", 62);
    freq.put("vän", 1462);
    freq.put("fy ", 102);
    freq.put("esö", 182);
    freq.put("adr", 86);
    freq.put("ads", 244);
    freq.put("gma", 47);
    freq.put("add", 356);
    freq.put("ade", 5063);
    freq.put("tmä", 47);
    freq.put(" mm", 83);
    freq.put("ca ", 238);
    freq.put("adm", 26);
    freq.put("adk", 30);
    freq.put("adi", 265);
    freq.put("fyn", 27);
    freq.put("fyl", 220);
    freq.put("fyr", 108);
    freq.put("fys", 32);
    freq.put("ad ", 4404);
    freq.put("nja", 74);
    freq.put("nje", 96);
    freq.put("nju", 65);
    freq.put("esv", 113);
    freq.put("esu", 136);
    freq.put("est", 1928);
    freq.put("ess", 1243);
    freq.put("esp", 187);
    freq.put("tma", 144);
    freq.put("ese", 301);
    freq.put("adå", 63);
    freq.put("esc", 26);
    freq.put("esa", 170);
    freq.put("eso", 109);
    freq.put("tmi", 43);
    freq.put("esm", 34);
    freq.put("esl", 161);
    freq.put("esk", 179);
    freq.put("esi", 145);
    freq.put("tmo", 26);
    freq.put("OS ", 69);
    freq.put("es ", 1672);
    freq.put("Twe", 31);
    freq.put("Twi", 264);
    freq.put("De ", 337);
    freq.put("rch", 36);
    freq.put("rce", 28);
    freq.put("rca", 37);
    freq.put("bur", 112);
    freq.put("bus", 294);
    freq.put("Des", 73);
    freq.put("Det", 2680);
    freq.put("but", 145);
    freq.put("Del", 47);
    freq.put("Den", 523);
    freq.put("bum", 68);
    freq.put("Dea", 28);
    freq.put("bud", 129);
    freq.put("j", 31699);
    freq.put("pik", 33);
    freq.put("pil", 74);
    freq.put("pin", 338);
    freq.put("pia", 50);
    freq.put("pic", 35);
    freq.put("pie", 58);
    freq.put("pig", 129);
    freq.put("piz", 72);
    freq.put("ub ", 46);
    freq.put(" Äv", 51);
    freq.put("pir", 116);
    freq.put("pis", 292);
    freq.put("pit", 76);
    freq.put("oad", 27);
    freq.put("oac", 32);
    freq.put("oal", 45);
    freq.put("oav", 39);
    freq.put("oar", 66);
    freq.put("ubr", 37);
    freq.put("pi ", 34);
    freq.put("ube", 80);
    freq.put("ubb", 409);
    freq.put("ubl", 118);
    freq.put("oa ", 59);
    freq.put(" kä", 1474);
    freq.put(" kå", 43);
    freq.put(" kö", 1291);
    freq.put("Oke", 97);
    freq.put("G ", 391);
    freq.put("Gu", 255);
    freq.put("Gr", 470);
    freq.put("Fic", 172);
    freq.put("Ok ", 96);
    freq.put("Ge", 187);
    freq.put("Gb", 48);
    freq.put("Ga", 284);
    freq.put("Go", 452);
    freq.put("Gl", 190);
    freq.put("Gj", 27);
    freq.put("Gi", 228);
    freq.put(" ka", 4712);
    freq.put(" ke", 85);
    freq.put(" ki", 429);
    freq.put(" kn", 404);
    freq.put(" ko", 4764);
    freq.put(" kl", 1872);
    freq.put(" km", 100);
    freq.put(" kr", 1266);
    freq.put(" kv", 1251);
    freq.put(" ku", 1389);
    freq.put(" ky", 135);
    freq.put("mnd", 52);
    freq.put("kut", 117);
    freq.put("kus", 192);
    freq.put("kur", 200);
    freq.put("kup", 45);
    freq.put("Mmm", 37);
    freq.put("kun", 820);
    freq.put("kum", 104);
    freq.put("kul", 1659);
    freq.put("kuk", 26);
    freq.put(" k ", 48);
    freq.put("TT ", 76);
    freq.put("Zl", 68);
    freq.put("Gö", 309);
    freq.put("ty", 2485);
    freq.put("Za", 26);
    freq.put("Gå", 159);
    freq.put("Gä", 93);
    freq.put("tu", 2013);
    freq.put("Kom", 350);
    freq.put("Kol", 204);
    freq.put("Kon", 138);
    freq.put("ts", 4361);
    freq.put("ör ", 9926);
    freq.put("Gör", 106);
    freq.put("Kor", 47);
    freq.put("Göt", 192);
    freq.put("enä", 34);
    freq.put("m ", 20093);
    freq.put("tm", 346);
    freq.put("enö", 28);
    freq.put("örs", 2558);
    freq.put("örr", 563);
    freq.put("örv", 297);
    freq.put("öru", 183);
    freq.put("ört", 442);
    freq.put("örb", 376);
    freq.put("öra", 1398);
    freq.put("örg", 51);
    freq.put("örf", 126);
    freq.put("öre", 784);
    freq.put("örd", 678);
    freq.put("örk", 390);
    freq.put("örj", 1029);
    freq.put("öri", 75);
    freq.put("örh", 131);
    freq.put("öro", 79);
    freq.put("örn", 264);
    freq.put("örm", 137);
    freq.put("örl", 317);
    freq.put("me", 16757);
    freq.put("md", 284);
    freq.put("mg", 179);
    freq.put("mf", 331);
    freq.put("ma", 11494);
    freq.put("g", 92312);
    freq.put("mb", 661);
    freq.put("mm", 6519);
    freq.put("ml", 775);
    freq.put("mo", 3892);
    freq.put("mn", 1322);
    freq.put("mi", 9347);
    freq.put("mh", 291);
    freq.put("mk", 347);
    freq.put("mj", 141);
    freq.put("mu", 930);
    freq.put("mt", 1352);
    freq.put("mv", 132);
    freq.put("mp", 1364);
    freq.put("ms", 1213);
    freq.put("mr", 328);
    freq.put("ta", 20843);
    freq.put("my", 1313);
    freq.put("ena", 1001);
    freq.put("enb", 124);
    freq.put("enc", 52);
    freq.put("end", 953);
    freq.put("ene", 307);
    freq.put("enf", 33);
    freq.put("eng", 447);
    freq.put("enh", 257);
    freq.put("eni", 217);
    freq.put("enk", 181);
    freq.put("enl", 129);
    freq.put("enn", 841);
    freq.put("eno", 454);
    freq.put("enp", 30);
    freq.put("enr", 49);
    freq.put("ens", 2872);
    freq.put("ent", 2032);
    freq.put("enu", 48);
    freq.put("env", 37);
    freq.put("eny", 33);
    freq.put("ålv", 28);
    freq.put("ålt", 30);
    freq.put("ON ", 50);
    freq.put("örä", 172);
    freq.put("må", 2480);
    freq.put("mä", 1389);
    freq.put("ål ", 248);
    freq.put("mö", 1089);
    freq.put(" Hy", 46);
    freq.put("må ", 138);
    freq.put(" Hu", 656);
    freq.put(" Hj", 84);
    freq.put(" Hi", 206);
    freq.put(" Ho", 695);
    freq.put(" Hm", 90);
    freq.put(" Ha", 2915);
    freq.put(" He", 955);
    freq.put("ima", 126);
    freq.put("ime", 202);
    freq.put("imi", 93);
    freq.put("imm", 523);
    freq.put("iml", 141);
    freq.put("imo", 543);
    freq.put("imp", 109);
    freq.put("ims", 34);
    freq.put("imr", 29);
    freq.put("JA ", 38);
    freq.put("mål", 349);
    freq.put("mån", 855);
    freq.put("måt", 104);
    freq.put("mås", 824);
    freq.put("mår", 114);
    freq.put(" H ", 39);
    freq.put("im ", 114);
    freq.put(" Hö", 246);
    freq.put(" Hå", 176);
    freq.put(" Hä", 448);
    freq.put("gom", 55);
    freq.put("gol", 87);
    freq.put("goo", 110);
    freq.put("gon", 2347);
    freq.put("god", 404);
    freq.put("ajs", 110);
    freq.put("ajt", 61);
    freq.put("got", 982);
    freq.put("aje", 44);
    freq.put("gos", 48);
    freq.put("gor", 227);
    freq.put("W", 808);
    freq.put("Vic", 31);
    freq.put("Vid", 34);
    freq.put("Vik", 67);
    freq.put("Vin", 74);
    freq.put("go ", 113);
    freq.put("Vil", 562);
    freq.put("Vis", 175);
    freq.put("aj ", 108);
    freq.put("be ", 169);
    freq.put("nhe", 254);
    freq.put("nha", 74);
    freq.put(" gi", 942);
    freq.put("tor", 1936);
    freq.put("tos", 51);
    freq.put("top", 302);
    freq.put("EU ", 42);
    freq.put("tot", 97);
    freq.put("tou", 27);
    freq.put("tok", 64);
    freq.put("ton", 467);
    freq.put("too", 31);
    freq.put("tol", 233);
    freq.put("tom", 509);
    freq.put("tob", 76);
    freq.put("toc", 372);
    freq.put("toa", 78);
    freq.put("tof", 31);
    freq.put("tog", 256);
    freq.put("tod", 136);
    freq.put("äck", 700);
    freq.put("Fuc", 29);
    freq.put("Fun", 136);
    freq.put("Ful", 43);
    freq.put(" Sa", 646);
    freq.put("to ", 300);
    freq.put("thu", 35);
    freq.put("nhå", 30);
    freq.put("rag", 351);
    freq.put("rad", 1349);
    freq.put("lbr", 42);
    freq.put("rab", 183);
    freq.put("rac", 109);
    freq.put("lby", 28);
    freq.put("ral", 313);
    freq.put("ram", 1269);
    freq.put("rak", 328);
    freq.put("rah", 46);
    freq.put("rai", 66);
    freq.put("rav", 199);
    freq.put("rat", 2015);
    freq.put("rar", 2609);
    freq.put("ras", 862);
    freq.put("rap", 245);
    freq.put("lbi", 48);
    freq.put("raz", 26);
    freq.put("rax", 63);
    freq.put("Syd", 32);
    freq.put("Syn", 82);
    freq.put("thi", 81);
    freq.put("ra ", 11277);
    freq.put("bst", 42);
    freq.put("bso", 131);
    freq.put("AS ", 37);
    freq.put("cyk", 131);
    freq.put("én", 80);
    freq.put("ée", 48);
    freq.put("oci", 186);
    freq.put("och", 10113);
    freq.put("Bil", 130);
    freq.put("oce", 84);
    freq.put("Bir", 30);
    freq.put("é ", 197);
    freq.put("bec", 30);
    freq.put("nuv", 27);
    freq.put("nut", 298);
    freq.put("Pep", 27);
    freq.put("nus", 141);
    freq.put("Per", 154);
    freq.put("Pen", 36);
    freq.put("num", 186);
    freq.put("nuf", 29);
    freq.put("nub", 47);
    freq.put("mut", 48);
    freq.put("mus", 400);
    freq.put("mum", 33);
    freq.put("mul", 88);
    freq.put("mun", 259);
    freq.put("Exa", 29);
    freq.put("Exp", 52);
    freq.put("nu ", 2912);
    freq.put(" me", 11654);
    freq.put(" ma", 5808);
    freq.put("elf", 50);
    freq.put(" mo", 2112);
    freq.put(" mi", 7557);
    freq.put(" mj", 89);
    freq.put(" mk", 174);
    freq.put(" mu", 505);
    freq.put(" mv", 29);
    freq.put(" my", 1140);
    freq.put(" m ", 290);
    freq.put("xxx", 33);
    freq.put("TV ", 180);
    freq.put("n", 188732);
    freq.put("ape", 194);
    freq.put("elt", 981);
    freq.put("elu", 27);
    freq.put(" mä", 735);
    freq.put(" må", 2061);
    freq.put(" mö", 565);
    freq.put("öp ", 85);
    freq.put("öpt", 240);
    freq.put("öpp", 227);
    freq.put("öpe", 120);
    freq.put("öpa", 317);
    freq.put("öpn", 37);
    freq.put("öpi", 92);
    freq.put(" Jö", 62);
    freq.put(" Jä", 186);
    freq.put("elk", 59);
    freq.put("elh", 46);
    freq.put("eli", 274);
    freq.put("eln", 324);
    freq.put("elo", 85);
    freq.put("ell", 2743);
    freq.put("elm", 57);
    freq.put("elb", 134);
    freq.put("ela", 1747);
    freq.put("Hö", 247);
    freq.put("elg", 384);
    freq.put("eld", 103);
    freq.put("ele", 699);
    freq.put("ely", 28);
    freq.put("elr", 44);
    freq.put("els", 993);
    freq.put("elp", 50);
    freq.put("elv", 213);
    freq.put("Hä", 448);
    freq.put("Hå", 177);
    freq.put("D", 7943);
    freq.put("Lys", 106);
    freq.put("el ", 1792);
    freq.put("Lyc", 94);
    freq.put(" Ju", 340);
    freq.put(" Jo", 650);
    freq.put(" Ji", 42);
    freq.put(" Je", 124);
    freq.put(" Ja", 4352);
    freq.put("ick", 2097);
    freq.put("ici", 113);
    freq.put("Hy", 46);
    freq.put("ico", 28);
    freq.put("ica", 104);
    freq.put("ice", 325);
    freq.put("Hu", 656);
    freq.put("Hj", 84);
    freq.put("våg", 114);
    freq.put("Hi", 206);
    freq.put("Ho", 699);
    freq.put("Hm", 90);
    freq.put("ics", 43);
    freq.put("icr", 37);
    freq.put("vål", 75);
    freq.put("Ha", 2922);
    freq.put("elö", 47);
    freq.put("He", 956);
    freq.put("Fär", 33);
    freq.put(" J ", 42);
    freq.put("ic ", 206);
    freq.put("vå ", 610);
    freq.put("H ", 223);
    freq.put("ppa", 1627);
    freq.put("aha", 1908);
    freq.put("ppg", 124);
    freq.put("ppf", 106);
    freq.put("ppe", 906);
    freq.put("ppd", 210);
    freq.put("ppk", 26);
    freq.put("ppi", 108);
    freq.put("pph", 43);
    freq.put("ppo", 194);
    freq.put("ppn", 233);
    freq.put("ppm", 64);
    freq.put("ppl", 394);
    freq.put("pps", 387);
    freq.put("ppr", 79);
    freq.put("ppv", 32);
    freq.put("ppt", 311);
    freq.put("ppy", 33);
    freq.put("awe", 40);
    freq.put("né", 37);
    freq.put("git", 285);
    freq.put("gis", 307);
    freq.put("nä", 4021);
    freq.put("nå", 2731);
    freq.put("gig", 47);
    freq.put("gif", 171);
    freq.put("gie", 41);
    freq.put("gic", 308);
    freq.put("AD ", 40);
    freq.put("gio", 72);
    freq.put("gin", 160);
    freq.put("gil", 452);
    freq.put("nö", 480);
    freq.put("Sön", 31);
    freq.put("ah ", 268);
    freq.put("pp ", 1941);
    freq.put("Sök", 57);
    freq.put("Söd", 83);
    freq.put("Vor", 27);
    freq.put("gi ", 126);
    freq.put("nno", 263);
    freq.put("nnl", 42);
    freq.put("nni", 775);
    freq.put("nne", 2128);
    freq.put("nna", 3070);
    freq.put("nny", 82);
    freq.put("nnu", 215);
    freq.put("nns", 1487);
    freq.put("nh", 442);
    freq.put("ni", 7273);
    freq.put("nj", 305);
    freq.put("nk", 3332);
    freq.put("nl", 1122);
    freq.put("nm", 190);
    freq.put("nn", 8538);
    freq.put("no", 3200);
    freq.put("tit", 489);
    freq.put("na", 15976);
    freq.put("nb", 488);
    freq.put("nc", 547);
    freq.put("nd", 13543);
    freq.put("ne", 7274);
    freq.put("nf", 1014);
    freq.put("ng", 15514);
    freq.put("til", 5927);
    freq.put("ny", 2237);
    freq.put("nz", 32);
    freq.put("tio", 1416);
    freq.put("ES ", 27);
    freq.put("np", 178);
    freq.put("tie", 134);
    freq.put("nr", 228);
    freq.put("ns", 11382);
    freq.put("nt", 15164);
    freq.put("nu", 3873);
    freq.put("nv", 720);
    freq.put("tic", 122);
    freq.put("cor", 57);
    freq.put("nn ", 339);
    freq.put("ich", 63);
    freq.put("vår", 930);
    freq.put("n ", 67877);
    freq.put("ti ", 230);
    freq.put("roi", 64);
    freq.put("roj", 127);
    freq.put("rok", 38);
    freq.put("rol", 835);
    freq.put("rom", 274);
    freq.put("ron", 464);
    freq.put("roo", 44);
    freq.put("lls", 1023);
    freq.put("roa", 55);
    freq.put("rob", 311);
    freq.put("roc", 153);
    freq.put("rod", 370);
    freq.put("roe", 89);
    freq.put("rof", 144);
    freq.put("llt", 2431);
    freq.put("pmä", 34);
    freq.put("lli", 448);
    freq.put("llh", 57);
    freq.put("llo", 256);
    freq.put("elä", 132);
    freq.put("llm", 126);
    freq.put("rop", 389);
    freq.put("llb", 418);
    freq.put("ror", 1129);
    freq.put("ros", 253);
    freq.put("rot", 446);
    freq.put("rou", 30);
    freq.put("rov", 241);
    freq.put("row", 28);
    freq.put("Dag", 345);
    freq.put("Dam", 41);
    freq.put("Dan", 129);
    freq.put("Dav", 35);
    freq.put("ro ", 414);
    freq.put("tw ", 67);
    freq.put("vån", 121);
    freq.put("Cit", 46);
    freq.put("ll ", 9330);
    freq.put("kla", 2005);
    freq.put("jde", 55);
    freq.put("ict", 34);
    freq.put("jda", 35);
    freq.put("Rep", 26);
    freq.put("Rei", 41);
    freq.put("pma", 28);
    freq.put("Reg", 56);
    freq.put("llå", 83);
    freq.put("llä", 64);
    freq.put("dek", 27);
    freq.put("äka", 140);
    freq.put("äkl", 103);
    freq.put("ngt", 507);
    freq.put("Min", 428);
    freq.put("msu", 40);
    freq.put("mst", 283);
    freq.put("msp", 30);
    freq.put("mso", 28);
    freq.put("msl", 31);
    freq.put("msk", 149);
    freq.put("msi", 112);
    freq.put("mse", 30);
    freq.put("msa", 52);
    freq.put("Åte", 38);
    freq.put("ms ", 315);
    freq.put(" on", 409);
    freq.put(" oo", 28);
    freq.put(" ol", 270);
    freq.put(" om", 4957);
    freq.put(" oj", 84);
    freq.put(" ok", 509);
    freq.put(" oh", 48);
    freq.put("kyl", 221);
    freq.put(" of", 462);
    freq.put(" og", 33);
    freq.put("Mic", 60);
    freq.put(" oe", 43);
    freq.put(" ob", 137);
    freq.put(" oc", 11094);
    freq.put(" oa", 53);
    freq.put(" ox", 98);
    freq.put(" ov", 156);
    freq.put("kyr", 110);
    freq.put(" ot", 155);
    freq.put(" ou", 61);
    freq.put(" or", 872);
    freq.put(" os", 659);
    freq.put(" op", 117);
    freq.put("dé ", 67);
    freq.put("ky ", 56);
    freq.put(" o ", 830);
    freq.put("iPa", 49);
    freq.put("dée", 38);
    freq.put("iPh", 93);
    freq.put("Fan", 197);
    freq.put("Tyc", 147);
    freq.put("vta", 32);
    freq.put("gta", 153);
    freq.put("ejä", 50);
    freq.put("gti", 26);
    freq.put("åhä", 87);
    freq.put("gtv", 61);
    freq.put("ahh", 49);
    freq.put("övs", 61);
    freq.put("övr", 110);
    freq.put("ahl", 41);
    freq.put("ng ", 5246);
    freq.put("öve", 1690);
    freq.put("övd", 52);
    freq.put("Tyv", 59);
    freq.put("öva", 155);
    freq.put("dpr", 34);
    freq.put("gt ", 4943);
    freq.put("vt ", 263);
    freq.put("Typ", 90);
    freq.put("qv", 35);
    freq.put(" ca", 303);
    freq.put("ejl", 54);
    freq.put("ejj", 28);
    freq.put("ejk", 45);
    freq.put("ejd", 59);
    freq.put("eje", 276);
    freq.put("eja", 85);
    freq.put("ejt", 37);
    freq.put("ejs", 30);
    freq.put("giv", 135);
    freq.put("Båd", 37);
    freq.put("ej ", 1654);
    freq.put("åh ", 131);
    freq.put("prå", 115);
    freq.put("prä", 62);
    freq.put("prö", 48);
    freq.put("iam", 30);
    freq.put("ial", 364);
    freq.put("ian", 245);
    freq.put("iag", 45);
    freq.put("iaf", 207);
    freq.put("iat", 80);
    freq.put("ias", 135);
    freq.put("iar", 37);
    freq.put("Löö", 37);
    freq.put("hum", 106);
    freq.put("hun", 272);
    freq.put("huv", 235);
    freq.put("hur", 1125);
    freq.put("SE ", 29);
    freq.put(" Lå", 193);
    freq.put(" Lä", 509);
    freq.put("ia ", 556);
    freq.put(" Lö", 126);
    freq.put("r", 206469);
    freq.put("pre", 1013);
    freq.put("ane", 411);
    freq.put("anf", 234);
    freq.put("ang", 500);
    freq.put("pra", 557);
    freq.put("ana", 609);
    freq.put("anc", 103);
    freq.put("anl", 406);
    freq.put("anm", 117);
    freq.put("pro", 1166);
    freq.put("ano", 166);
    freq.put("kao", 30);
    freq.put("ani", 449);
    freq.put("anj", 49);
    freq.put("ank", 545);
    freq.put("pru", 63);
    freq.put("anu", 54);
    freq.put("anv", 368);
    freq.put("anp", 35);
    freq.put("ans", 3203);
    freq.put("pry", 41);
    freq.put("any", 42);
    freq.put("kan", 4695);
    freq.put("an ", 16165);
    freq.put("Lör", 30);
    freq.put(" Le", 269);
    freq.put(" La", 337);
    freq.put(" Lo", 250);
    freq.put(" Lj", 41);
    freq.put(" Li", 765);
    freq.put(" Lu", 257);
    freq.put(" Ly", 236);
    freq.put("tka", 47);
    freq.put("tko", 78);
    freq.put("tkl", 39);
    freq.put("Beh", 81);
    freq.put("itl", 68);
    freq.put("nla", 76);
    freq.put("tku", 31);
    freq.put("nle", 132);
    freq.put("rmä", 26);
    freq.put("iös", 124);
    freq.put("nli", 602);
    freq.put("dy ", 99);
    freq.put("ss ", 1246);
    freq.put("ith", 59);
    freq.put("åli", 375);
    freq.put("Fyr", 29);
    freq.put("ssy", 31);
    freq.put("ssu", 159);
    freq.put("sst", 581);
    freq.put("ssv", 42);
    freq.put("ssp", 53);
    freq.put("dyr", 77);
    freq.put("tåe", 43);
    freq.put("ssm", 34);
    freq.put("ssl", 123);
    freq.put("sso", 560);
    freq.put("ssn", 424);
    freq.put("ssi", 374);
    freq.put("ssh", 70);
    freq.put("ssk", 129);
    freq.put("dyk", 48);
    freq.put("sse", 737);
    freq.put("dyg", 64);
    freq.put("ssa", 1688);
    freq.put("ssc", 35);
    freq.put("ssb", 35);
    freq.put("Fy ", 35);
    freq.put("rms", 31);
    freq.put("rmt", 70);
    freq.put("rmu", 38);
    freq.put("rma", 473);
    freq.put("lni", 403);
    freq.put("nlä", 216);
    freq.put("Rö", 83);
    freq.put("rme", 279);
    freq.put("lne", 27);
    freq.put("rmi", 160);
    freq.put("lna", 152);
    freq.put("rmo", 154);
    freq.put("rml", 31);
    freq.put("jou", 106);
    freq.put("fön", 72);
    freq.put("föl", 495);
    freq.put("itr", 49);
    freq.put("föd", 131);
    freq.put("mti", 263);
    freq.put("föt", 44);
    freq.put("för", 12662);
    freq.put("rm ", 200);
    freq.put("sså", 162);
    freq.put("ssä", 42);
    freq.put("ln ", 213);
    freq.put("joc", 62);
    freq.put("pow", 30);
    freq.put("pot", 163);
    freq.put("por", 563);
    freq.put("pos", 258);
    freq.put("pop", 106);
    freq.put("pon", 171);
    freq.put("poo", 36);
    freq.put("pol", 407);
    freq.put("poj", 89);
    freq.put("pod", 33);
    freq.put("åla", 144);
    freq.put("Bus", 48);
    freq.put("Gbg", 44);
    freq.put("po ", 36);
    freq.put("Nja", 38);
    freq.put("åld", 203);
    freq.put("Tja", 26);
    freq.put("oks", 76);
    freq.put("gå ", 674);
    freq.put("Bar", 330);
    freq.put("poä", 119);
    freq.put("okt", 123);
    freq.put("I ", 801);
    freq.put("gås", 45);
    freq.put("går", 1474);
    freq.put("Ett", 199);
    freq.put("gåt", 173);
    freq.put("Åre", 35);
    freq.put("gåe", 54);
    freq.put("gån", 1112);
    freq.put("Ip", 31);
    freq.put("Is", 118);
    freq.put("Ir", 44);
    freq.put("It", 52);
    freq.put("yhe", 283);
    freq.put("Ik", 95);
    freq.put("Im", 141);
    freq.put("Il", 28);
    freq.put("In", 1185);
    freq.put("Ic", 36);
    freq.put("Ib", 87);
    freq.put("Id", 375);
    freq.put("Ig", 80);
    freq.put("tip", 346);
    freq.put("Ban", 73);
    freq.put("tir", 42);
    freq.put("tis", 1684);
    freq.put("tim", 551);
    freq.put("Baj", 32);
    freq.put("tin", 622);
    freq.put("Bak", 26);
    freq.put(" Å ", 34);
    freq.put("tik", 643);
    freq.put("tid", 2070);
    freq.put("tif", 125);
    freq.put("tig", 1535);
    freq.put("Pin", 102);
    freq.put("oä", 133);
    freq.put("tia", 110);
    freq.put("Pit", 27);
    freq.put("Kun", 77);
    freq.put("Kul", 191);
    freq.put("öta", 152);
    freq.put("öte", 488);
    freq.put("gva", 30);
    freq.put("o ", 3564);
    freq.put("öts", 113);
    freq.put("ött", 769);
    freq.put("oo", 1359);
    freq.put("öt ", 134);
    freq.put("om", 19795);
    freq.put("ol", 6683);
    freq.put("ok", 2213);
    freq.put("oj", 486);
    freq.put("oi", 218);
    freq.put("oh", 401);
    freq.put("og", 2649);
    freq.put("of", 1141);
    freq.put("oe", 278);
    freq.put("od", 2147);
    freq.put("oc", 13166);
    freq.put("ob", 2360);
    freq.put("oa", 342);
    freq.put("häf", 32);
    freq.put("oz", 29);
    freq.put("oy", 69);
    freq.put("ox", 232);
    freq.put("ow", 463);
    freq.put("ov", 1553);
    freq.put("ou", 816);
    freq.put("häl", 284);
    freq.put("os", 2798);
    freq.put("or", 14153);
    freq.put("op", 2754);
    freq.put("ju ", 2172);
    freq.put("rvå", 81);
    freq.put("rvä", 216);
    freq.put("FB ", 61);
    freq.put("rvö", 37);
    freq.put("igå", 458);
    freq.put("ehe", 231);
    freq.put("eha", 106);
    freq.put("eho", 62);
    freq.put("jua", 37);
    freq.put("jug", 51);
    freq.put("jud", 321);
    freq.put("jue", 27);
    freq.put("juk", 646);
    freq.put("jun", 191);
    freq.put("jul", 153);
    freq.put("jur", 212);
    freq.put("jus", 774);
    freq.put("jup", 47);
    freq.put("juv", 46);
    freq.put("jut", 171);
    freq.put("eh ", 96);
    freq.put("rva", 248);
    freq.put("rve", 148);
    freq.put("rvj", 114);
    freq.put("rvi", 212);
    freq.put("ehö", 610);
    freq.put("igt", 4227);
    freq.put("igs", 27);
    freq.put("igr", 41);
    freq.put("éer", 41);
    freq.put("igg", 485);
    freq.put("ige", 2510);
    freq.put("ehå", 111);
    freq.put("iga", 1830);
    freq.put("ign", 143);
    freq.put("igi", 106);
    freq.put("igh", 581);
    freq.put("rv ", 76);
    freq.put("dof", 38);
    freq.put("Hor", 42);
    freq.put("Män", 44);
    freq.put("hmm", 56);
    freq.put("ig ", 7990);
    freq.put("Mär", 34);
    freq.put("Nån", 61);
    freq.put("alo", 92);
    freq.put("all", 5251);
    freq.put("alm", 341);
    freq.put("alj", 56);
    freq.put("alk", 219);
    freq.put("pti", 86);
    freq.put("ali", 528);
    freq.put("alf", 63);
    freq.put("Någ", 228);
    freq.put("pte", 333);
    freq.put("ale", 765);
    freq.put("alb", 113);
    freq.put("lly", 65);
    freq.put("pta", 56);
    freq.put("ala", 992);
    freq.put("aly", 70);
    freq.put("alv", 302);
    freq.put("fa ", 239);
    freq.put("alu", 67);
    freq.put("ptr", 26);
    freq.put("alp", 43);
    freq.put("llr", 186);
    freq.put("far", 818);
    freq.put("fas", 449);
    freq.put("fav", 120);
    freq.put("fat", 463);
    freq.put("pt ", 359);
    freq.put("fak", 455);
    freq.put("fai", 34);
    freq.put("fan", 1134);
    freq.put("llu", 36);
    freq.put("fal", 532);
    freq.put("fam", 148);
    freq.put("fab", 31);
    freq.put("fac", 142);
    freq.put("rog", 380);
    freq.put("fad", 81);
    freq.put(" Ni", 375);
    freq.put("llk", 60);
    freq.put(" Nj", 63);
    freq.put(" No", 388);
    freq.put(" Na", 185);
    freq.put(" Ne", 527);
    freq.put(" Ny", 510);
    freq.put("Sva", 88);
    freq.put(" Nu", 1071);
    freq.put("lln", 327);
    freq.put("tei", 30);
    freq.put("tek", 259);
    freq.put("tel", 473);
    freq.put("tem", 373);
    freq.put("ten", 3155);
    freq.put("teo", 46);
    freq.put("nbr", 54);
    freq.put("teb", 228);
    freq.put("ptä", 81);
    freq.put("ted", 104);
    freq.put("tee", 40);
    freq.put("tef", 99);
    freq.put("teg", 220);
    freq.put("tex", 176);
    freq.put("nbi", 31);
    freq.put("nbo", 43);
    freq.put("nbl", 115);
    freq.put("tep", 53);
    freq.put("nba", 105);
    freq.put("tes", 382);
    freq.put("tet", 1058);
    freq.put("lla", 5245);
    freq.put("nbe", 51);
    freq.put("sug", 187);
    freq.put("suc", 45);
    freq.put("sub", 40);
    freq.put("sun", 114);
    freq.put("sum", 70);
    freq.put("sul", 114);
    freq.put("llf", 115);
    freq.put("sut", 198);
    freq.put("sus", 54);
    freq.put("sur", 154);
    freq.put("sup", 202);
    freq.put("lld", 292);
    freq.put("te ", 12865);
    freq.put(" Nå", 327);
    freq.put(" Nä", 790);
    freq.put("Und", 247);
    freq.put(" Nö", 35);
    freq.put("rkt", 189);
    freq.put("rku", 56);
    freq.put("rkv", 28);
    freq.put("rkr", 47);
    freq.put("rks", 138);
    freq.put("Tor", 75);
    freq.put("Ung", 65);
    freq.put("rky", 66);
    freq.put("rke", 446);
    freq.put("rka", 1041);
    freq.put("Tom", 52);
    freq.put("rkl", 671);
    freq.put("rkn", 153);
    freq.put("rko", 198);
    freq.put("rki", 88);
    freq.put("Å ", 144);
    freq.put("In ", 39);
    freq.put("äää", 153);
    freq.put("En", 946);
    freq.put("rk ", 383);
    freq.put("Glö", 72);
    freq.put("AR ", 125);
    freq.put("Åh", 169);
    freq.put("Åk", 69);
    freq.put("Int", 510);
    freq.put("Ins", 96);
    freq.put("lhö", 36);
    freq.put("Inn", 46);
    freq.put("v", 52763);
    freq.put("Ind", 43);
    freq.put("Åt", 64);
    freq.put("Inf", 39);
    freq.put("Ing", 302);
    freq.put("År", 52);
    freq.put("rkö", 37);
    freq.put("rkä", 57);
    freq.put("För", 1008);
    freq.put("åni", 38);
    freq.put("Gla", 51);
    freq.put("anh", 44);
    freq.put("lhe", 32);
    freq.put("lho", 29);
    freq.put("ää ", 29);
    freq.put("oy ", 29);
    freq.put("Och", 717);
    freq.put(" sö", 747);
    freq.put(" sä", 2433);
    freq.put(" så", 5591);
    freq.put("yn ", 126);
    freq.put("L", 3279);
    freq.put("Eri", 84);
    freq.put("ynn", 30);
    freq.put("ynk", 33);
    freq.put("ynd", 222);
    freq.put("yne", 40);
    freq.put("yng", 54);
    freq.put("yna", 30);
    freq.put("ynt", 33);
    freq.put("yns", 59);
    freq.put(" sy", 530);
    freq.put("Mus", 43);
    freq.put(" sp", 2239);
    freq.put(" sv", 1487);
    freq.put(" sw", 32);
    freq.put(" st", 4769);
    freq.put(" su", 626);
    freq.put(" sj", 1479);
    freq.put(" sk", 7959);
    freq.put(" sh", 197);
    freq.put(" si", 3316);
    freq.put(" sn", 1464);
    freq.put(" so", 8357);
    freq.put(" sl", 1540);
    freq.put(" sm", 841);
    freq.put(" sc", 221);
    freq.put(" sa", 2727);
    freq.put(" se", 4173);
    freq.put("gur", 35);
    freq.put("då ", 2081);
    freq.put("izz", 84);
    freq.put("koh", 68);
    freq.put("kok", 74);
    freq.put("kom", 3191);
    freq.put(" s ", 434);
    freq.put("iz ", 27);
    freq.put("kon", 1286);
    freq.put("dål", 321);
    freq.put("X ", 74);
    freq.put("sås", 50);
    freq.put("ådä", 103);
    freq.put("såg", 330);
    freq.put("såd", 217);
    freq.put("sån", 441);
    freq.put("sål", 58);
    freq.put("såk", 91);
    freq.put("såh", 67);
    freq.put("GT ", 37);
    freq.put("VT ", 79);
    freq.put("Res", 45);
    freq.put("efä", 88);
    freq.put("Nu ", 1044);
    freq.put("dfe", 104);
    freq.put("så ", 6188);
    freq.put(" ev", 189);
    freq.put("jen", 277);
    freq.put("åå ", 106);
    freq.put("åda", 319);
    freq.put("js ", 77);
    freq.put("åde", 303);
    freq.put("såå", 53);
    freq.put("SvD", 45);
    freq.put("efr", 59);
    freq.put("efs", 33);
    freq.put("eft", 1227);
    freq.put("efi", 138);
    freq.put("efl", 42);
    freq.put("Red", 58);
    freq.put("efo", 228);
    freq.put("efa", 74);
    freq.put("efe", 104);
    freq.put("eff", 91);
    freq.put("åd ", 98);
    freq.put("jsa", 45);
    freq.put("ef ", 100);
    freq.put("rte", 436);
    freq.put("rtf", 329);
    freq.put("rta", 687);
    freq.put("rtl", 27);
    freq.put("rto", 116);
    freq.put("rtn", 37);
    freq.put("rti", 509);
    freq.put("rth", 38);
    freq.put("rtk", 26);
    freq.put("rtj", 75);
    freq.put("rtu", 29);
    freq.put("rts", 395);
    freq.put("rtr", 136);
    freq.put("rty", 104);
    freq.put("Ju", 341);
    freq.put("ies", 90);
    freq.put("ier", 416);
    freq.put("iet", 218);
    freq.put("Jo", 650);
    freq.put("iel", 264);
    freq.put("ien", 373);
    freq.put("Je", 124);
    freq.put("ieb", 38);
    freq.put("Ja", 4353);
    freq.put("hip", 120);
    freq.put("his", 208);
    freq.put("hit", 670);
    freq.put("rt ", 4278);
    freq.put("hih", 55);
    freq.put("hil", 76);
    freq.put("him", 135);
    freq.put("hin", 229);
    freq.put(" På", 398);
    freq.put("ie ", 305);
    freq.put("J ", 160);
    freq.put("arp", 84);
    freq.put("rtä", 32);
    freq.put("arr", 216);
    freq.put("ars", 769);
    freq.put("art", 2700);
    freq.put("aru", 70);
    freq.put("arv", 127);
    freq.put("ary", 35);
    freq.put("ara", 4958);
    freq.put("arb", 541);
    freq.put("arc", 94);
    freq.put("ard", 484);
    freq.put("are", 3529);
    freq.put("arf", 730);
    freq.put("arg", 192);
    freq.put("arh", 38);
    freq.put("ari", 1072);
    freq.put("arj", 258);
    freq.put("ark", 746);
    freq.put("arl", 390);
    freq.put("uu ", 29);
    freq.put("arn", 1942);
    freq.put("aro", 137);
    freq.put(" ål", 72);
    freq.put(" ån", 88);
    freq.put(" åh", 95);
    freq.put(" åk", 434);
    freq.put("Jö", 62);
    freq.put("al ", 996);
    freq.put(" P ", 159);
    freq.put("Jä", 187);
    freq.put(" år", 1093);
    freq.put("kö", 2091);
    freq.put("uuu", 101);
    freq.put("ar ", 24930);
    freq.put(" Pr", 401);
    freq.put("c", 30906);
    freq.put("Öst", 59);
    freq.put(" Pu", 121);
    freq.put(" å ", 266);
    freq.put(" Pa", 416);
    freq.put(" Pe", 358);
    freq.put("Fas", 215);
    freq.put(" Pi", 212);
    freq.put(" Ph", 46);
    freq.put(" Po", 285);
    freq.put(" Pl", 174);
    freq.put("riö", 111);
    freq.put("riä", 34);
    freq.put("pr", 3790);
    freq.put("ps", 1230);
    freq.put("pp", 6919);
    freq.put("duk", 182);
    freq.put("pv", 38);
    freq.put("dum", 123);
    freq.put("pt", 1003);
    freq.put("pu", 522);
    freq.put("dub", 75);
    freq.put("duc", 40);
    freq.put("swe", 30);
    freq.put("dug", 29);
    freq.put("pb", 57);
    freq.put("pc", 53);
    freq.put("pa", 4976);
    freq.put("pf", 130);
    freq.put("pg", 391);
    freq.put("pd", 230);
    freq.put("pe", 4799);
    freq.put("pk", 50);
    freq.put("ph", 217);
    freq.put("pi", 1382);
    freq.put("pn", 332);
    freq.put("po", 2120);
    freq.put("pl", 2043);
    freq.put("pm", 91);
    freq.put("Åke", 50);
    freq.put("Fac", 193);
    freq.put("du ", 4460);
    freq.put("p ", 4166);
    freq.put("riv", 967);
    freq.put("rit", 1064);
    freq.put("riu", 54);
    freq.put("Tip", 74);
    freq.put("ris", 1112);
    freq.put("rip", 134);
    freq.put("rin", 1858);
    freq.put("rio", 131);
    freq.put("ril", 159);
    freq.put("rim", 172);
    freq.put("rik", 1188);
    freq.put("rih", 60);
    freq.put("tgå", 40);
    freq.put("rif", 101);
    freq.put("rig", 1530);
    freq.put("rid", 277);
    freq.put("rie", 510);
    freq.put("rib", 60);
    freq.put("ric", 387);
    freq.put("ria", 355);
    freq.put("pö", 57);
    freq.put("pä", 368);
    freq.put("på", 12997);
    freq.put("Väs", 95);
    freq.put("Vär", 146);
    freq.put("Väx", 39);
    freq.put("Com", 39);
    freq.put("Väl", 145);
    freq.put("ri ", 283);
    freq.put("Vän", 87);
    freq.put("lj ", 157);
    freq.put("ljo", 99);
    freq.put("ljn", 35);
    freq.put("lja", 671);
    freq.put("lje", 601);
    freq.put("ljd", 40);
    freq.put("lju", 259);
    freq.put("ljt", 29);
    freq.put("bör", 1073);
    freq.put("böc", 109);
    freq.put("bög", 27);
    freq.put("bön", 30);
    freq.put("yl ", 29);
    freq.put("ass", 1254);
    freq.put("zza", 82);
    freq.put("ylt", 37);
    freq.put("Rol", 60);
    freq.put("Rom", 27);
    freq.put("Rob", 58);
    freq.put("Roc", 32);
    freq.put("yld", 53);
    freq.put("yle", 49);
    freq.put("yla", 61);
    freq.put("yln", 36);
    freq.put("yll", 389);
    freq.put("Ros", 49);
    freq.put("yli", 59);
    freq.put("wn ", 44);
    freq.put(" ut", 2966);
    freq.put(" up", 2177);
    freq.put(" ur", 337);
    freq.put(" us", 85);
    freq.put(" um", 26);
    freq.put(" un", 1369);
    freq.put("oän", 128);
    freq.put(" ug", 28);
    freq.put("grö", 92);
    freq.put("ixa", 201);
    freq.put("xpe", 68);
    freq.put("grä", 183);
    freq.put("grå", 100);
    freq.put(" Kv", 107);
    freq.put(" u ", 35);
    freq.put("rät", 1018);
    freq.put("räv", 158);
    freq.put("å", 52523);
    freq.put("räs", 106);
    freq.put("ix ", 68);
    freq.put("räd", 342);
    freq.put("räf", 363);
    freq.put("räc", 220);
    freq.put("räm", 109);
    freq.put("räl", 142);
    freq.put("rän", 874);
    freq.put("räk", 221);
    freq.put("läc", 54);
    freq.put("läg", 881);
    freq.put("läd", 284);
    freq.put("läk", 152);
    freq.put("län", 1084);
    freq.put("läm", 267);
    freq.put("läs", 792);
    freq.put("lär", 500);
    freq.put("läp", 244);
    freq.put("lät", 344);
    freq.put("läx", 32);
    freq.put("gru", 305);
    freq.put("gry", 193);
    freq.put("gre", 725);
    freq.put("gra", 1524);
    freq.put("gro", 61);
    freq.put("gri", 227);
    freq.put("lä ", 40);
    freq.put("Bå", 41);
    freq.put("gr ", 53);
    freq.put("edb", 85);
    freq.put("eda", 1513);
    freq.put("edd", 179);
    freq.put("ede", 379);
    freq.put("edj", 73);
    freq.put("rrä", 70);
    freq.put("LA ", 105);
    freq.put("edo", 97);
    freq.put("edl", 100);
    freq.put("edr", 182);
    freq.put("eds", 131);
    freq.put("edv", 125);
    freq.put("edt", 27);
    freq.put("FF ", 85);
    freq.put("påt", 29);
    freq.put("påv", 52);
    freq.put("pår", 102);
    freq.put("pås", 127);
    freq.put("påm", 50);
    freq.put("ed ", 6809);
    freq.put("ugg", 317);
    freq.put("P", 3321);
    freq.put("Ge ", 42);
    freq.put("car", 71);
    freq.put("på ", 12392);
    freq.put("rro", 112);
    freq.put("rrn", 66);
    freq.put("rrl", 41);
    freq.put("rri", 198);
    freq.put("rre", 558);
    freq.put("rra", 489);
    freq.put("edö", 33);
    freq.put("rry", 129);
    freq.put("rru", 44);
    freq.put("rrr", 34);
    freq.put("IG ", 63);
    freq.put("can", 94);
    freq.put("rr ", 411);
    freq.put("wl", 28);
    freq.put("apr", 55);
    freq.put("aps", 71);
    freq.put("app", 1240);
    freq.put("Mik", 32);
    freq.put("apt", 50);
    freq.put("api", 67);
    freq.put("apo", 37);
    freq.put("apl", 66);
    freq.put("NT ", 26);
    freq.put("apa", 248);
    freq.put("Mil", 63);
    freq.put("use", 382);
    freq.put("fee", 62);
    freq.put("feb", 53);
    freq.put("afé", 28);
    freq.put("usa", 104);
    freq.put("fen", 143);
    freq.put("fel", 489);
    freq.put("fem", 173);
    freq.put("fej", 35);
    freq.put("fek", 193);
    freq.put("usi", 354);
    freq.put("ush", 82);
    freq.put("fet", 218);
    freq.put("feu", 101);
    freq.put("fer", 183);
    freq.put("fes", 303);
    freq.put("Hur", 475);
    freq.put("Hus", 42);
    freq.put(" od", 40);
    freq.put("Gud", 86);
    freq.put("Gun", 28);
    freq.put("Mid", 28);
    freq.put("Gus", 31);
    freq.put("ap ", 224);
    freq.put("kyd", 55);
    freq.put(" Ru", 87);
    freq.put("fe ", 223);
    freq.put("us ", 682);
    freq.put(" Ry", 68);
    freq.put(" Re", 407);
    freq.put(" Ra", 221);
    freq.put(" Ro", 318);
    freq.put(" Ri", 258);
    freq.put("tat", 1211);
    freq.put("tau", 47);
    freq.put("tav", 156);
    freq.put("tap", 143);
    freq.put("tar", 3813);
    freq.put("tas", 662);
    freq.put("tax", 37);
    freq.put("tad", 1166);
    freq.put("taf", 56);
    freq.put("tag", 884);
    freq.put("tab", 101);
    freq.put("tac", 697);
    freq.put("tal", 1327);
    freq.put("tam", 83);
    freq.put("tan", 2599);
    freq.put("Mis", 125);
    freq.put("tak", 178);
    freq.put("sis", 463);
    freq.put("siv", 69);
    freq.put("sit", 768);
    freq.put("Mit", 109);
    freq.put("sic", 43);
    freq.put("sia", 35);
    freq.put("dwa", 28);
    freq.put("sig", 1723);
    freq.put("sif", 47);
    freq.put("sie", 104);
    freq.put("sid", 504);
    freq.put("sik", 497);
    freq.put("sio", 312);
    freq.put("sin", 962);
    freq.put("sim", 69);
    freq.put("sil", 48);
    freq.put("Eko", 96);
    freq.put("ta ", 7509);
    freq.put(" Rö", 83);
    freq.put(" Rå", 39);
    freq.put(" Rä", 102);
    freq.put("si ", 62);
    freq.put("usl", 63);
    freq.put("öc", 115);
    freq.put("kve", 44);
    freq.put("byx", 64);
    freq.put("byt", 255);
    freq.put("byr", 46);
    freq.put("öh", 49);
    freq.put("gh ", 55);
    freq.put("bye", 36);
    freq.put("Ibl", 72);
    freq.put("Car", 112);
    freq.put("Cam", 37);
    freq.put("Cal", 34);
    freq.put("Pre", 141);
    freq.put("nfe", 103);
    freq.put("Pra", 40);
    freq.put("nfa", 106);
    freq.put("nfo", 191);
    freq.put("Pro", 137);
    freq.put("nfl", 81);
    freq.put("Pri", 83);
    freq.put("nfi", 48);
    freq.put("by ", 185);
    freq.put(" Än", 141);
    freq.put(" Äl", 123);
    freq.put("oun", 81);
    freq.put("oud", 29);
    freq.put("ous", 65);
    freq.put("our", 242);
    freq.put(" Är", 644);
    freq.put("out", 153);
    freq.put("lt ", 2733);
    freq.put("Säk", 28);
    freq.put("ou ", 127);
    freq.put("lts", 652);
    freq.put("ltr", 53);
    freq.put("ltu", 122);
    freq.put("nfö", 433);
    freq.put("lta", 247);
    freq.put("ÖR ", 48);
    freq.put("lte", 230);
    freq.put("lti", 655);
    freq.put("lto", 45);
    freq.put("ü", 32);
    freq.put("K ", 379);
    freq.put("Där", 132);
    freq.put("Ka", 1068);
    freq.put("Ke", 105);
    freq.put("Ki", 213);
    freq.put("Kh", 34);
    freq.put("Ko", 791);
    freq.put("Kn", 57);
    freq.put("Kl", 280);
    freq.put("Kr", 240);
    freq.put("tnä", 40);
    freq.put("Kv", 107);
    freq.put("Ku", 308);
    freq.put("Ky", 31);
    freq.put("Ume", 31);
    freq.put("ybl", 36);
    freq.put("Hål", 109);
    freq.put("Håk", 41);
    freq.put("wha", 35);
    freq.put("Kä", 493);
    freq.put("whi", 35);
    freq.put("Kö", 175);
    freq.put("Pot", 28);
    freq.put("Por", 27);
    freq.put("Pos", 55);
    freq.put("Pol", 85);
    freq.put("ebä", 48);
    freq.put("Cha", 68);
    freq.put("Aft", 77);
    freq.put("ha", 14590);
    freq.put("dlä", 44);
    freq.put(" we", 199);
    freq.put("qu", 86);
    freq.put(" wa", 80);
    freq.put(" wo", 147);
    freq.put(" wh", 87);
    freq.put(" wi", 97);
    freq.put(" ww", 43);
    freq.put("ebe", 127);
    freq.put("eba", 245);
    freq.put("ebb", 125);
    freq.put("ebo", 487);
    freq.put("ebi", 75);
    freq.put("jo ", 150);
    freq.put("ebu", 54);
    freq.put("ebr", 166);
    freq.put("eby", 31);
    freq.put("ikv", 458);
    freq.put("dla", 375);
    freq.put("dle", 100);
    freq.put("dli", 436);
    freq.put("jor", 756);
    freq.put("nöt", 40);
    freq.put("eb ", 33);
    freq.put("nör", 87);
    freq.put("job", 1138);
    freq.put("nöd", 104);
    freq.put("jol", 28);
    freq.put("nöj", 169);
    freq.put("jon", 125);
    freq.put("vti", 32);
    freq.put("rpr", 59);
    freq.put("rpa", 77);
    freq.put("rpe", 37);
    freq.put("hm ", 50);
    freq.put("rpo", 31);
    freq.put("bbl", 87);
    freq.put("bbi", 199);
    freq.put("Juh", 79);
    freq.put("Jul", 39);
    freq.put("Jus", 157);
    freq.put("bby", 32);
    freq.put("bbt", 102);
    freq.put("bbs", 47);
    freq.put("rp ", 37);
    freq.put("é", 397);
    freq.put("bb ", 385);
    freq.put(" Tå", 35);
    freq.put(" Tä", 256);
    freq.put("tja", 101);
    freq.put("avt", 40);
    freq.put("avu", 34);
    freq.put("avv", 39);
    freq.put("avr", 27);
    freq.put("avs", 412);
    freq.put("avl", 80);
    freq.put("avn", 43);
    freq.put("avo", 124);
    freq.put("avi", 181);
    freq.put("avk", 59);
    freq.put("avd", 48);
    freq.put("ave", 140);
    freq.put("avf", 59);
    freq.put("avg", 137);
    freq.put("ava", 148);
    freq.put("avb", 38);
    freq.put(" T ", 52);
    freq.put("tjo", 85);
    freq.put("av ", 3348);
    freq.put(" Ty", 386);
    freq.put(" Tw", 299);
    freq.put(" Tv", 159);
    freq.put(" Tu", 197);
    freq.put(" Tr", 918);
    freq.put(" To", 325);
    freq.put(" Tj", 98);
    freq.put(" Ti", 507);
    freq.put(" Th", 276);
    freq.put("tju", 57);
    freq.put(" Te", 293);
    freq.put(" Ta", 917);
    freq.put("tch", 476);
    freq.put("sku", 1184);
    freq.put("skt", 951);
    freq.put("skv", 90);
    freq.put("skr", 1322);
    freq.put("Far", 48);
    freq.put("nop", 29);
    freq.put("sky", 259);
    freq.put("Fat", 52);
    freq.put("ske", 1250);
    freq.put("ska", 6495);
    freq.put("Ja ", 675);
    freq.put("Fal", 37);
    freq.put("skl", 152);
    freq.put("sko", 1342);
    freq.put("skn", 97);
    freq.put("ski", 1237);
    freq.put("skj", 95);
    freq.put("T", 5247);
    freq.put("tåg", 267);
    freq.put("tc ", 68);
    freq.put("ndå", 468);
    freq.put("sk ", 913);
    freq.put("Sug", 27);
    freq.put("kdo", 36);
    freq.put("Suc", 28);
    freq.put("Sun", 72);
    freq.put("Sui", 32);
    freq.put("mfö", 224);
    freq.put("Sup", 57);
    freq.put("skö", 394);
    freq.put("nd ", 1850);
    freq.put("skå", 125);
    freq.put("skä", 363);
    freq.put("ndi", 386);
    freq.put("ndh", 31);
    freq.put("ndk", 40);
    freq.put("ndl", 456);
    freq.put("ndo", 203);
    freq.put("ndn", 110);
    freq.put("nda", 1756);
    freq.put("ndb", 79);
    freq.put("nde", 5484);
    freq.put("ndg", 39);
    freq.put("ndf", 26);
    freq.put("ndy", 54);
    freq.put("nds", 588);
    freq.put("ndr", 1637);
    freq.put("ndu", 55);
    freq.put("ndt", 67);
    freq.put("ndv", 72);
    freq.put("öa", 49);
    freq.put("öb", 73);
    freq.put("own", 55);
    freq.put("öd", 1114);
    freq.put("öe", 28);
    freq.put("öf", 80);
    freq.put("ög", 780);
    freq.put("owe", 125);
    freq.put("öj", 714);
    freq.put("ök", 1451);
    freq.put("öl", 1046);
    freq.put("öm", 900);
    freq.put("ön", 1452);
    freq.put("öp", 1169);
    freq.put("ör", 20075);
    freq.put("ös", 1357);
    freq.put("öt", 1720);
    freq.put("öv", 2182);
    freq.put("Pet", 80);
    freq.put("ows", 44);
    freq.put("vaj", 28);
    freq.put("vak", 348);
    freq.put("van", 751);
    freq.put("val", 559);
    freq.put("vam", 54);
    freq.put("Ama", 31);
    freq.put("vac", 124);
    freq.put("öck", 114);
    freq.put("Ame", 38);
    freq.put("vag", 144);
    freq.put("vad", 1615);
    freq.put("lv ", 699);
    freq.put("var", 7170);
    freq.put("vas", 90);
    freq.put("vat", 378);
    freq.put("ö ", 509);
    freq.put("ow ", 166);
    freq.put("lvt", 58);
    freq.put("Tek", 36);
    freq.put("Tel", 57);
    freq.put("Tea", 26);
    freq.put("va ", 1728);
    freq.put("lve", 260);
    freq.put("lva", 314);
    freq.put("lvm", 30);
    freq.put("Tes", 52);
    freq.put("lvi", 71);
    freq.put("lvk", 86);
    freq.put("mys", 187);
    freq.put("eu", 268);
    freq.put("öö", 251);
    freq.put("myn", 32);
    freq.put("myc", 920);
    freq.put("myg", 50);
    freq.put("tår", 711);
    freq.put("Afr", 26);
    freq.put("EN ", 180);
    freq.put("KD ", 28);
    freq.put("my ", 87);
    freq.put("Co", 243);
    freq.put("lvå", 33);
    freq.put("lvä", 50);
  }
  
}

