package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class TL {
  private static final String name = "tl";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public TL() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 642331;
    n_words[1] = 778348;
    n_words[2] = 610756;

    freq.put("woo", 19);
    freq.put("xtr", 9);
    freq.put("xte", 15);
    freq.put("xtm", 7);
    freq.put("xti", 8);
    freq.put("yu ", 41);
    freq.put("SP ", 7);
    freq.put("xt ", 195);
    freq.put("NO ", 52);
    freq.put(" y ", 38);
    freq.put("gaL", 19);
    freq.put("gaF", 22);
    freq.put(" yi", 15);
    freq.put(" yn", 9);
    freq.put(" yo", 283);
    freq.put(" ya", 581);
    freq.put("k", 24384);
    freq.put(" ye", 141);
    freq.put(" yg", 13);
    freq.put("PH ", 26);
    freq.put(" yr", 12);
    freq.put(" yu", 1425);
    freq.put("ED ", 16);
    freq.put("RL ", 7);
    freq.put("txt", 14);
    freq.put("dne", 16);
    freq.put("sNa", 8);
    freq.put("dni", 31);
    freq.put("mAn", 10);
    freq.put("dn ", 31);
    freq.put("Le", 95);
    freq.put("La", 352);
    freq.put("Lo", 293);
    freq.put("Ll", 10);
    freq.put("Lh", 7);
    freq.put("Li", 193);
    freq.put("Lu", 63);
    freq.put("Ly", 14);
    freq.put("hod", 12);
    freq.put("hoe", 7);
    freq.put("hob", 12);
    freq.put("hoc", 21);
    freq.put("hoa", 11);
    freq.put("hon", 211);
    freq.put("hoo", 126);
    freq.put("hol", 51);
    freq.put("hom", 34);
    freq.put("hok", 25);
    freq.put("hoh", 35);
    freq.put("hoi", 19);
    freq.put("how", 59);
    freq.put("hot", 59);
    freq.put("hou", 56);
    freq.put("hor", 46);
    freq.put("hos", 54);
    freq.put("hop", 32);
    freq.put("hoy", 22);
    freq.put("A", 3138);
    freq.put("L ", 312);
    freq.put("hn", 148);
    freq.put("ho ", 108);
    freq.put("AO ", 12);
    freq.put("DP ", 15);
    freq.put(" V ", 12);
    freq.put("zal", 23);
    freq.put("AP ", 42);
    freq.put("fir", 31);
    freq.put("uor", 12);
    freq.put("Hir", 21);
    freq.put("uot", 123);
    freq.put("fic", 94);
    freq.put("fia", 9);
    freq.put("fig", 12);
    freq.put("Hig", 8);
    freq.put("Hih", 35);
    freq.put("fin", 49);
    freq.put("uon", 36);
    freq.put("Hin", 280);
    freq.put(" Va", 19);
    freq.put(" Ve", 18);
    freq.put("au ", 51);
    freq.put(" Vi", 40);
    freq.put(" Vo", 20);
    freq.put("zaa", 12);
    freq.put("lSa", 9);
    freq.put("Hi ", 30);
    freq.put("fi ", 20);
    freq.put("uo ", 16);
    freq.put("rT", 11);
    freq.put("rP", 24);
    freq.put("rS", 17);
    freq.put("mda", 108);
    freq.put("rD", 21);
    freq.put("rE", 15);
    freq.put("rF", 12);
    freq.put("rG", 13);
    freq.put("rA", 17);
    freq.put("rB", 74);
    freq.put("rC", 8);
    freq.put("rL", 31);
    freq.put("rM", 27);
    freq.put("rN", 11);
    freq.put("rO", 10);
    freq.put("rJ", 21);
    freq.put("rK", 13);
    freq.put("rt", 651);
    freq.put("ru", 385);
    freq.put("rv", 87);
    freq.put("rw", 30);
    freq.put("rp", 75);
    freq.put("rq", 18);
    freq.put("rr", 481);
    freq.put("rs", 479);
    freq.put("rx", 12);
    freq.put("ry", 600);
    freq.put("rz", 17);
    freq.put("rd", 295);
    freq.put("re", 2273);
    freq.put("rf", 33);
    freq.put("rg", 123);
    freq.put("ra", 3673);
    freq.put("rb", 85);
    freq.put("rc", 150);
    freq.put("rl", 377);
    freq.put("rm", 233);
    freq.put("rn", 297);
    freq.put("ro", 1873);
    freq.put("rh", 58);
    freq.put("ri", 2344);
    freq.put("rj", 32);
    freq.put("rk", 180);
    freq.put("IM ", 11);
    freq.put("atg", 8);
    freq.put("atd", 8);
    freq.put("ate", 586);
    freq.put("atc", 55);
    freq.put("ata", 1300);
    freq.put("atn", 11);
    freq.put("ato", 140);
    freq.put("atl", 24);
    freq.put("atm", 8);
    freq.put("ath", 198);
    freq.put("ati", 776);
    freq.put("atw", 11);
    freq.put("att", 85);
    freq.put("atu", 328);
    freq.put("r ", 1844);
    freq.put("ats", 84);
    freq.put("ds ", 90);
    freq.put("sm ", 24);
    freq.put("Dum", 7);
    freq.put("Swa", 13);
    freq.put("Swe", 15);
    freq.put("kfa", 8);
    freq.put("xia", 8);
    freq.put("xie", 17);
    freq.put("Cel", 18);
    freq.put("nz ", 42);
    freq.put("Ces", 8);
    freq.put("YA ", 76);
    freq.put("WS ", 8);
    freq.put("Sob", 42);
    freq.put("eCh", 18);
    freq.put("nza", 31);
    freq.put("nze", 7);
    freq.put("nzk", 23);
    freq.put("nzo", 16);
    freq.put("oqu", 8);
    freq.put("Son", 20);
    freq.put("Ass", 11);
    freq.put("Ast", 16);
    freq.put("Asa", 10);
    freq.put("Sor", 60);
    freq.put("Ash", 26);
    freq.put("lp ", 11);
    freq.put("neo", 11);
    freq.put("nel", 57);
    freq.put("nem", 27);
    freq.put("lph", 35);
    freq.put("lpe", 7);
    freq.put("lpa", 30);
    freq.put("SE ", 19);
    freq.put("yfe", 14);
    freq.put("Di ", 241);
    freq.put("hS", 11);
    freq.put("nev", 12);
    freq.put("yfr", 22);
    freq.put("X", 448);
    freq.put("Riz", 8);
    freq.put("Ris", 10);
    freq.put("nep", 19);
    freq.put("Ric", 16);
    freq.put("iry", 11);
    freq.put("irp", 8);
    freq.put("irr", 10);
    freq.put("irs", 41);
    freq.put("irt", 51);
    freq.put("iru", 10);
    freq.put("iri", 85);
    freq.put("irl", 153);
    freq.put("irm", 15);
    freq.put("irn", 8);
    freq.put("iro", 27);
    freq.put("ira", 362);
    freq.put("uee", 33);
    freq.put("irc", 12);
    freq.put("ird", 33);
    freq.put("ire", 138);
    freq.put("wts", 31);
    freq.put("wti", 24);
    freq.put("cur", 20);
    freq.put("DM ", 23);
    freq.put("Nam", 59);
    freq.put("ir ", 69);
    freq.put("and", 951);
    freq.put("fra", 32);
    freq.put("fre", 39);
    freq.put("fri", 169);
    freq.put("fro", 22);
    freq.put("ann", 263);
    freq.put("hK", 10);
    freq.put("anh", 19);
    freq.put("anu", 286);
    freq.put("BE ", 25);
    freq.put("Dil", 7);
    freq.put("bil", 155);
    freq.put("Dio", 7);
    freq.put("jk ", 32);
    freq.put("dhi", 9);
    freq.put("dha", 17);
    freq.put("bic", 7);
    freq.put("jkl", 15);
    freq.put("tz ", 22);
    freq.put("yAn", 7);
    freq.put("bia", 31);
    freq.put("LO ", 29);
    freq.put("hah", 4892);
    freq.put("hai", 53);
    freq.put("hak", 24);
    freq.put("hal", 511);
    freq.put("ham", 61);
    freq.put("han", 927);
    freq.put("haa", 107);
    freq.put("hab", 107);
    freq.put("hac", 30);
    freq.put("had", 25);
    freq.put("hae", 27);
    freq.put("hag", 29);
    freq.put("hay", 328);
    freq.put("haz", 15);
    freq.put("bno", 8);
    freq.put("hap", 137);
    freq.put("har", 199);
    freq.put("has", 65);
    freq.put("hat", 441);
    freq.put("hav", 19);
    freq.put("haw", 32);
    freq.put("ha ", 2468);
    freq.put("ola", 115);
    freq.put("old", 41);
    freq.put("ole", 100);
    freq.put("olf", 7);
    freq.put("oli", 68);
    freq.put("olj", 12);
    freq.put(" X ", 16);
    freq.put("oll", 218);
    freq.put("olo", 141);
    freq.put("olp", 7);
    freq.put("ols", 19);
    freq.put("olu", 13);
    freq.put("olv", 7);
    freq.put("oly", 11);
    freq.put("olz", 7);
    freq.put("umu", 168);
    freq.put("fou", 7);
    freq.put("ump", 50);
    freq.put("for", 189);
    freq.put("ume", 34);
    freq.put("uma", 699);
    freq.put("umb", 71);
    freq.put("fol", 81);
    freq.put("umo", 22);
    freq.put("foo", 17);
    freq.put("umi", 185);
    freq.put("ol ", 368);
    freq.put(" Xi", 15);
    freq.put("o", 37483);
    freq.put("um ", 39);
    freq.put("mbl", 29);
    freq.put("soc", 15);
    freq.put("sob", 129);
    freq.put("mbi", 43);
    freq.put("sog", 29);
    freq.put("sof", 18);
    freq.put("Uso", 7);
    freq.put("mbe", 58);
    freq.put("sok", 158);
    freq.put("som", 40);
    freq.put("sol", 26);
    freq.put("soo", 29);
    freq.put("dMo", 8);
    freq.put("sop", 14);
    freq.put("sos", 19);
    freq.put("sor", 90);
    freq.put("Fer", 14);
    freq.put("sot", 9);
    freq.put("soy", 7);
    freq.put("mbu", 14);
    freq.put("mbr", 13);
    freq.put("az ", 19);
    freq.put("so ", 343);
    freq.put("azi", 26);
    freq.put("aza", 16);
    freq.put("aze", 20);
    freq.put("azz", 13);
    freq.put("Sis", 13);
    freq.put("Sir", 28);
    freq.put("hNi", 40);
    freq.put("Siy", 19);
    freq.put("khi", 8);
    freq.put("Sia", 7);
    freq.put("Sig", 83);
    freq.put("Sik", 8);
    freq.put("kha", 138);
    freq.put("khe", 11);
    freq.put("Sim", 22);
    freq.put("Sil", 13);
    freq.put("SiD", 10);
    freq.put("E", 764);
    freq.put("Si ", 54);
    freq.put("osy", 14);
    freq.put("lr ", 26);
    freq.put("osp", 14);
    freq.put("oss", 64);
    freq.put("ost", 94);
    freq.put("osi", 78);
    freq.put("osh", 43);
    freq.put("veB", 17);
    freq.put("oso", 56);
    freq.put("osa", 88);
    freq.put("eMa", 13);
    freq.put("Bye", 8);
    freq.put("ose", 145);
    freq.put("vet", 16);
    freq.put("ver", 279);
    freq.put("ves", 76);
    freq.put("tef", 13);
    freq.put("vey", 25);
    freq.put("ved", 8);
    freq.put("vee", 7);
    freq.put("veb", 25);
    freq.put("ven", 65);
    freq.put("vel", 66);
    freq.put("vem", 8);
    freq.put("vej", 7);
    freq.put("vek", 7);
    freq.put("lre", 7);
    freq.put("os ", 695);
    freq.put("Tat", 15);
    freq.put("Taw", 13);
    freq.put("Tap", 50);
    freq.put("Tar", 30);
    freq.put("Tas", 24);
    freq.put("Tay", 30);
    freq.put("Tae", 14);
    freq.put("Tag", 86);
    freq.put("Taa", 12);
    freq.put("Tab", 7);
    freq.put("Tal", 29);
    freq.put("Tam", 49);
    freq.put("Tan", 132);
    freq.put("Tao", 11);
    freq.put("Tak", 26);
    freq.put("M ", 198);
    freq.put("yd ", 11);
    freq.put("Me", 209);
    freq.put("ydo", 9);
    freq.put("Mg", 100);
    freq.put("Ma", 1426);
    freq.put("Mc", 9);
    freq.put("Mm", 11);
    freq.put("Mo", 217);
    freq.put("Mn", 8);
    freq.put("Mi", 362);
    freq.put("yda", 22);
    freq.put("Mu", 62);
    freq.put("uff", 19);
    freq.put("Ms", 24);
    freq.put("Mr", 24);
    freq.put("My", 88);
    freq.put("ipa", 242);
    freq.put("ipe", 9);
    freq.put("ipi", 170);
    freq.put("ipo", 88);
    freq.put("ipr", 12);
    freq.put("ips", 26);
    freq.put("ipp", 24);
    freq.put("ipt", 7);
    freq.put("ipu", 11);
    freq.put("yga", 9);
    freq.put("ygo", 9);
    freq.put("XT ", 10);
    freq.put("ugn", 7);
    freq.put("ip ", 205);
    freq.put("DO ", 16);
    freq.put("Liv", 12);
    freq.put("Out", 9);
    freq.put("Whe", 12);
    freq.put("ST ", 32);
    freq.put("Wha", 22);
    freq.put("Who", 11);
    freq.put("Whi", 7);
    freq.put("oKa", 11);
    freq.put("sst", 14);
    freq.put("s ", 5590);
    freq.put("Why", 9);
    freq.put("sY", 10);
    freq.put("sS", 27);
    freq.put("sR", 13);
    freq.put("sP", 15);
    freq.put("sW", 10);
    freq.put("sV", 8);
    freq.put("gz ", 7);
    freq.put("sT", 32);
    freq.put("sK", 22);
    freq.put("sJ", 19);
    freq.put("sI", 23);
    freq.put("sH", 8);
    freq.put("sO", 12);
    freq.put("sN", 19);
    freq.put("sM", 57);
    freq.put("sL", 20);
    freq.put("sC", 19);
    freq.put("sB", 27);
    freq.put("sA", 34);
    freq.put("sG", 23);
    freq.put("sF", 12);
    freq.put("sE", 12);
    freq.put("sD", 52);
    freq.put("sz", 19);
    freq.put("sy", 680);
    freq.put("sx", 7);
    freq.put("ss", 1269);
    freq.put("sr", 34);
    freq.put("sq", 20);
    freq.put("sp", 253);
    freq.put("sw", 120);
    freq.put("sv", 7);
    freq.put("su", 872);
    freq.put("st", 2038);
    freq.put("sk", 263);
    freq.put("sj", 34);
    freq.put("si", 3441);
    freq.put("sh", 914);
    freq.put("so", 1157);
    freq.put("sn", 113);
    freq.put("sm", 308);
    freq.put("sl", 171);
    freq.put("sc", 250);
    freq.put("sb", 66);
    freq.put("sa", 7780);
    freq.put("sg", 64);
    freq.put("sf", 31);
    freq.put("se", 1269);
    freq.put("sd", 76);
    freq.put("tty", 38);
    freq.put("KA ", 125);
    freq.put("ttp", 564);
    freq.put("tev", 9);
    freq.put("ttt", 35);
    freq.put("tti", 21);
    freq.put("tth", 9);
    freq.put("tto", 30);
    freq.put("ttl", 17);
    freq.put("tta", 23);
    freq.put("tte", 224);
    freq.put("jil", 8);
    freq.put("yGi", 7);
    freq.put("sBa", 10);
    freq.put("mMi", 7);
    freq.put("yGr", 7);
    freq.put("tt ", 34);
    freq.put("bbi", 13);
    freq.put("LI ", 19);
    freq.put("ji ", 10);
    freq.put("dj ", 9);
    freq.put("sU", 8);
    freq.put("kOf", 7);
    freq.put("Jos", 15);
    freq.put("blu", 20);
    freq.put("Joy", 15);
    freq.put("blr", 17);
    freq.put("Joa", 7);
    freq.put("blo", 45);
    freq.put("bli", 23);
    freq.put("Joh", 20);
    freq.put("Jok", 14);
    freq.put("Jol", 9);
    freq.put("Jon", 13);
    freq.put("onk", 10);
    freq.put("oni", 77);
    freq.put("onn", 55);
    freq.put("ono", 35);
    freq.put("onl", 36);
    freq.put("onm", 9);
    freq.put("onb", 26);
    freq.put("onc", 57);
    freq.put("ona", 120);
    freq.put("onf", 18);
    freq.put("ong", 2054);
    freq.put("ond", 86);
    freq.put("one", 210);
    freq.put("onz", 24);
    freq.put("ony", 61);
    freq.put("ons", 111);
    freq.put("onv", 15);
    freq.put("ont", 187);
    freq.put("onu", 10);
    freq.put("uku", 42);
    freq.put("onA", 9);
    freq.put("uks", 21);
    freq.put("uko", 33);
    freq.put("Hmm", 20);
    freq.put("uki", 30);
    freq.put("ukh", 117);
    freq.put("onT", 8);
    freq.put(" Ze", 7);
    freq.put("on ", 1606);
    freq.put(" Za", 13);
    freq.put("AT ", 84);
    freq.put("uk ", 12);
    freq.put("sak", 522);
    freq.put("sai", 35);
    freq.put("sah", 56);
    freq.put("san", 860);
    freq.put("sam", 313);
    freq.put("sal", 248);
    freq.put("sac", 7);
    freq.put("sab", 447);
    freq.put("saa", 78);
    freq.put("sag", 104);
    freq.put("sad", 81);
    freq.put("say", 548);
    freq.put("sas", 180);
    freq.put("sar", 256);
    freq.put("sap", 135);
    freq.put("saw", 74);
    freq.put("sav", 16);
    freq.put("sau", 27);
    freq.put("sat", 33);
    freq.put("zon", 37);
    freq.put("ax ", 23);
    freq.put("saT", 9);
    freq.put("sa ", 3702);
    freq.put(" Ce", 37);
    freq.put("zo ", 11);
    freq.put("gYo", 7);
    freq.put("YE ", 13);
    freq.put("uz", 87);
    freq.put("up", 491);
    freq.put("us", 1479);
    freq.put("ur", 838);
    freq.put("um", 1352);
    freq.put(" b ", 24);
    freq.put("Aww", 25);
    freq.put("un", 5149);
    freq.put("Awa", 16);
    freq.put("uj", 15);
    freq.put(" be", 300);
    freq.put(" bd", 21);
    freq.put(" bg", 16);
    freq.put(" bf", 21);
    freq.put(" ba", 2349);
    freq.put(" bb", 18);
    freq.put(" bl", 88);
    freq.put(" bo", 248);
    freq.put(" bn", 8);
    freq.put(" bi", 458);
    freq.put(" bh", 16);
    freq.put(" bk", 22);
    freq.put(" bu", 646);
    freq.put(" bt", 9);
    freq.put(" bw", 36);
    freq.put(" bs", 8);
    freq.put(" br", 135);
    freq.put(" by", 40);
    freq.put("Aw ", 9);
    freq.put("yz ", 7);
    freq.put("yzz", 12);
    freq.put("fie", 22);
    freq.put("yza", 19);
    freq.put("yze", 8);
    freq.put("fil", 24);
    freq.put("ive", 164);
    freq.put("iva", 33);
    freq.put("ivi", 20);
    freq.put("ivy", 7);
    freq.put("UT ", 10);
    freq.put("lyo", 9);
    freq.put("uic", 10);
    freq.put(" gw", 80);
    freq.put("I", 1344);
    freq.put("Mar", 174);
    freq.put("Mau", 12);
    freq.put("DI ", 86);
    freq.put("Owy", 9);
    freq.put("uie", 12);
    freq.put("gda", 79);
    freq.put("gde", 13);
    freq.put("gdi", 14);
    freq.put("gdo", 10);
    freq.put(" gf", 9);
    freq.put(" ge", 95);
    freq.put("My ", 13);
    freq.put("TY ", 7);
    freq.put("gd ", 15);
    freq.put(" gn", 33);
    freq.put("MyJ", 14);
    freq.put(" go", 149);
    freq.put(" gl", 27);
    freq.put("NA ", 233);
    freq.put("Myr", 12);
    freq.put("BO ", 12);
    freq.put(" gi", 342);
    freq.put("ezz", 15);
    freq.put("eze", 13);
    freq.put("eza", 16);
    freq.put("ddy", 17);
    freq.put("ac ", 23);
    freq.put("sDr", 38);
    freq.put("ddi", 19);
    freq.put("dda", 8);
    freq.put("dde", 11);
    freq.put("ddd", 11);
    freq.put("ez ", 88);
    freq.put("tv ", 20);
    freq.put("acc", 41);
    freq.put("aca", 61);
    freq.put("ace", 119);
    freq.put("ack", 147);
    freq.put("aci", 33);
    freq.put("ach", 96);
    freq.put("aco", 36);
    freq.put("acl", 7);
    freq.put("acs", 7);
    freq.put("acr", 18);
    freq.put("acq", 7);
    freq.put("acu", 12);
    freq.put("act", 88);
    freq.put("acy", 7);
    freq.put("dd ", 23);
    freq.put("Ni", 186);
    freq.put("bje", 18);
    freq.put("heW", 7);
    freq.put("heR", 8);
    freq.put("heS", 7);
    freq.put("uil", 17);
    freq.put("Na", 956);
    freq.put("Nd", 9);
    freq.put("Ne", 104);
    freq.put("Ng", 218);
    freq.put("Ny", 35);
    freq.put("heA", 10);
    freq.put("heB", 11);
    freq.put("heL", 7);
    freq.put("heM", 11);
    freq.put("Ns", 8);
    freq.put("Nt", 7);
    freq.put("Nu", 43);
    freq.put("het", 60);
    freq.put("hew", 7);
    freq.put("her", 192);
    freq.put("hes", 54);
    freq.put("hey", 61);
    freq.put("hez", 11);
    freq.put("hed", 28);
    freq.put("hee", 62);
    freq.put("hef", 12);
    freq.put("heg", 8);
    freq.put("hea", 90);
    freq.put("hec", 21);
    freq.put("hel", 100);
    freq.put("hem", 56);
    freq.put("hen", 94);
    freq.put("heo", 12);
    freq.put("heh", 280);
    freq.put("hei", 28);
    freq.put("N ", 583);
    freq.put("nSa", 13);
    freq.put("he ", 310);
    freq.put("aa", 2525);
    freq.put("ohm", 14);
    freq.put("ac", 714);
    freq.put("oho", 51);
    freq.put("ae", 397);
    freq.put("ad", 1725);
    freq.put("ag", 7514);
    freq.put("af", 176);
    freq.put("ai", 1518);
    freq.put("ah", 8869);
    freq.put("Hol", 8);
    freq.put("aj", 95);
    freq.put("am", 5637);
    freq.put("al", 7905);
    freq.put("ao", 511);
    freq.put("an", 20636);
    freq.put("aq", 56);
    freq.put("ap", 3425);
    freq.put("as", 5046);
    freq.put("ar", 4019);
    freq.put("au", 578);
    freq.put("at", 5423);
    freq.put("aw", 2313);
    freq.put("av", 209);
    freq.put("ay", 7100);
    freq.put("ax", 52);
    freq.put("az", 115);
    freq.put("nki", 19);
    freq.put("Hoy", 12);
    freq.put("aA", 75);
    freq.put("aC", 34);
    freq.put("aB", 77);
    freq.put("aE", 16);
    freq.put("aD", 61);
    freq.put("aG", 22);
    freq.put("aF", 43);
    freq.put("aI", 13);
    freq.put("aH", 10);
    freq.put("aK", 85);
    freq.put("aJ", 24);
    freq.put("aM", 62);
    freq.put("aL", 63);
    freq.put("aO", 11);
    freq.put("aN", 95);
    freq.put("aP", 56);
    freq.put("aS", 59);
    freq.put("aR", 26);
    freq.put("aT", 44);
    freq.put("aW", 7);
    freq.put("aV", 15);
    freq.put("aY", 21);
    freq.put("a ", 29563);
    freq.put("oh ", 174);
    freq.put("agu", 180);
    freq.put("smy", 15);
    freq.put("uit", 24);
    freq.put("lYo", 8);
    freq.put("Fir", 18);
    freq.put("scl", 8);
    freq.put("sco", 44);
    freq.put("sci", 11);
    freq.put("sch", 103);
    freq.put("sce", 13);
    freq.put("tW", 8);
    freq.put("tT", 12);
    freq.put("sca", 28);
    freq.put("tS", 11);
    freq.put("tP", 17);
    freq.put("tN", 12);
    freq.put("tO", 12);
    freq.put("tL", 10);
    freq.put("tM", 16);
    freq.put("tK", 9);
    freq.put("tH", 40);
    freq.put("tI", 11);
    freq.put("scu", 18);
    freq.put("mna", 10);
    freq.put("tD", 11);
    freq.put("tB", 16);
    freq.put("mne", 8);
    freq.put("Fil", 14);
    freq.put("tA", 12);
    freq.put("smo", 27);
    freq.put("tz", 43);
    freq.put("tx", 19);
    freq.put("dso", 10);
    freq.put("tv", 26);
    freq.put("tw", 287);
    freq.put("tt", 1017);
    freq.put("tu", 1178);
    freq.put("tr", 586);
    freq.put("ts", 797);
    freq.put("tp", 605);
    freq.put("tn", 86);
    freq.put("to", 2632);
    freq.put("tl", 176);
    freq.put("tm", 60);
    freq.put("tj", 23);
    freq.put("tk", 20);
    freq.put("th", 958);
    freq.put("ti", 2575);
    freq.put("tf", 40);
    freq.put("tg", 34);
    freq.put("td", 37);
    freq.put("Ear", 9);
    freq.put("tb", 46);
    freq.put("tc", 133);
    freq.put("ta", 6097);
    freq.put("smi", 48);
    freq.put("Rya", 7);
    freq.put("mn ", 91);
    freq.put(" m", 10414);
    freq.put("sme", 87);
    freq.put("sma", 83);
    freq.put("t ", 6419);
    freq.put("Smi", 16);
    freq.put("Sma", 7);
    freq.put("xox", 7);
    freq.put("PE ", 8);
    freq.put("xo ", 19);
    freq.put("vib", 12);
    freq.put("vic", 100);
    freq.put("via", 20);
    freq.put("vid", 59);
    freq.put("vie", 95);
    freq.put("vin", 80);
    freq.put("vio", 11);
    freq.put("vil", 36);
    freq.put("vir", 10);
    freq.put("vis", 20);
    freq.put("fLo", 10);
    freq.put("kl ", 10);
    freq.put(" d ", 76);
    freq.put("VE ", 25);
    freq.put(" do", 157);
    freq.put(" dn", 30);
    freq.put(" dl", 10);
    freq.put(" dk", 7);
    freq.put(" dj", 11);
    freq.put(" di", 1529);
    freq.put(" dh", 16);
    freq.put(" de", 176);
    freq.put(" dd", 8);
    freq.put(" db", 28);
    freq.put(" da", 1014);
    freq.put(" dy", 90);
    freq.put(" dw", 14);
    freq.put(" du", 265);
    freq.put(" dt", 8);
    freq.put(" dr", 87);
    freq.put(" dp", 19);
    freq.put("RS ", 12);
    freq.put("atr", 63);
    freq.put("aYa", 14);
    freq.put("aty", 14);
    freq.put("itn", 18);
    freq.put("ito", 428);
    freq.put("IP ", 18);
    freq.put("ith", 92);
    freq.put("iti", 213);
    freq.put("ite", 158);
    freq.put("itb", 12);
    freq.put("itc", 28);
    freq.put("ita", 829);
    freq.put("itz", 16);
    freq.put("ity", 77);
    freq.put("itw", 11);
    freq.put("itt", 169);
    freq.put("itu", 26);
    freq.put("itr", 12);
    freq.put("its", 216);
    freq.put("itH", 38);
    freq.put("it ", 1588);
    freq.put(" A ", 31);
    freq.put("MG ", 33);
    freq.put("tre", 94);
    freq.put("at ", 1642);
    freq.put("SH ", 34);
    freq.put("fte", 41);
    freq.put(" Aa", 34);
    freq.put(" Ab", 42);
    freq.put(" Ac", 20);
    freq.put(" Ad", 43);
    freq.put(" Af", 11);
    freq.put(" Ag", 25);
    freq.put(" Ah", 68);
    freq.put(" Ai", 31);
    freq.put(" Ak", 130);
    freq.put(" Al", 152);
    freq.put(" Am", 49);
    freq.put(" An", 919);
    freq.put(" Ap", 20);
    freq.put(" Ar", 69);
    freq.put(" As", 54);
    freq.put(" At", 93);
    freq.put(" Au", 17);
    freq.put(" Av", 10);
    freq.put(" Aw", 57);
    freq.put(" Ay", 244);
    freq.put("gf ", 7);
    freq.put("NG ", 650);
    freq.put("ft ", 28);
    freq.put("w", 6838);
    freq.put("Fra", 16);
    freq.put("Fre", 10);
    freq.put("uel", 32);
    freq.put("Fri", 46);
    freq.put("KE ", 17);
    freq.put("jer", 21);
    freq.put("jes", 21);
    freq.put("aa ", 287);
    freq.put("jet", 7);
    freq.put("jey", 11);
    freq.put("sFo", 7);
    freq.put("jea", 18);
    freq.put("jee", 21);
    freq.put("jej", 9);
    freq.put("dfg", 25);
    freq.put("jen", 25);
    freq.put("jel", 19);
    freq.put("jem", 16);
    freq.put("aad", 22);
    freq.put("aag", 61);
    freq.put("aaa", 848);
    freq.put("aac", 10);
    freq.put("aab", 59);
    freq.put("aam", 38);
    freq.put("aal", 142);
    freq.put("aan", 496);
    freq.put("aai", 7);
    freq.put("aah", 103);
    freq.put("aak", 18);
    freq.put("aat", 21);
    freq.put("aaw", 36);
    freq.put("aap", 18);
    freq.put("aas", 112);
    freq.put("aar", 69);
    freq.put("aay", 124);
    freq.put("bhi", 13);
    freq.put("yha", 12);
    freq.put("OT ", 34);
    freq.put("uez", 28);
    freq.put("bhe", 10);
    freq.put("uet", 8);
    freq.put("kSi", 9);
    freq.put("ex ", 26);
    freq.put("tp ", 534);
    freq.put("M", 3288);
    freq.put("Isa", 52);
    freq.put("exc", 35);
    freq.put("tpa", 23);
    freq.put("exa", 33);
    freq.put("tpo", 22);
    freq.put("exo", 15);
    freq.put("exi", 11);
    freq.put("ext", 204);
    freq.put("tps", 15);
    freq.put("exp", 36);
    freq.put("Jk ", 8);
    freq.put("exy", 26);
    freq.put("Hah", 1196);
    freq.put("ugi", 16);
    freq.put("ugh", 58);
    freq.put("Hal", 43);
    freq.put("Ham", 7);
    freq.put("Han", 66);
    freq.put("Haa", 18);
    freq.put("Hab", 9);
    freq.put("ugg", 9);
    freq.put("uge", 7);
    freq.put("Hay", 47);
    freq.put("oje", 16);
    freq.put("Hap", 89);
    freq.put("ojo", 15);
    freq.put("Har", 27);
    freq.put("Has", 8);
    freq.put("Hav", 7);
    freq.put("ugt", 13);
    freq.put("Ha ", 12);
    freq.put("ug ", 53);
    freq.put("cru", 100);
    freq.put("cra", 25);
    freq.put("rfe", 8);
    freq.put("cre", 43);
    freq.put("cri", 31);
    freq.put("cro", 11);
    freq.put("Umu", 7);
    freq.put("sev", 7);
    freq.put("seu", 7);
    freq.put("set", 50);
    freq.put("ses", 115);
    freq.put("ser", 155);
    freq.put("For", 56);
    freq.put("sep", 15);
    freq.put("sey", 17);
    freq.put("sex", 23);
    freq.put("see", 47);
    freq.put("sed", 22);
    freq.put("sec", 41);
    freq.put("sea", 39);
    freq.put("Fol", 26);
    freq.put("sen", 129);
    freq.put("sem", 26);
    freq.put("sel", 80);
    freq.put("sei", 10);
    freq.put("seP", 10);
    freq.put("zky", 22);
    freq.put("ue ", 87);
    freq.put("se ", 423);
    freq.put("pda", 17);
    freq.put("lex", 30);
    freq.put("YY ", 7);
    freq.put("xam", 27);
    freq.put("nri", 27);
    freq.put("nro", 22);
    freq.put("nra", 9);
    freq.put("Ola", 8);
    freq.put("mla", 11);
    freq.put("ctr", 11);
    freq.put("mle", 9);
    freq.put("Oli", 18);
    freq.put("mlo", 32);
    freq.put("xa ", 20);
    freq.put("vol", 12);
    freq.put("von", 15);
    freq.put("voi", 12);
    freq.put("vot", 11);
    freq.put("amj", 15);
    freq.put("vor", 27);
    freq.put("So ", 40);
    freq.put("amn", 30);
    freq.put(" f ", 13);
    freq.put("vo ", 12);
    freq.put("kno", 37);
    freq.put(" fr", 152);
    freq.put(" fu", 29);
    freq.put("kni", 22);
    freq.put("kne", 7);
    freq.put("Som", 11);
    freq.put("Sol", 13);
    freq.put("kna", 23);
    freq.put(" fa", 184);
    freq.put(" fb", 42);
    freq.put(" fe", 186);
    freq.put(" fi", 91);
    freq.put(" fl", 44);
    freq.put(" fo", 188);
    freq.put("O ", 893);
    freq.put("amp", 155);
    freq.put("Oo", 122);
    freq.put("On", 111);
    freq.put("Om", 27);
    freq.put("Ol", 32);
    freq.put("Ok", 98);
    freq.put("Oh", 59);
    freq.put("Of", 78);
    freq.put("Oc", 7);
    freq.put("Ob", 7);
    freq.put("tsa", 55);
    freq.put("Oy", 20);
    freq.put("Ow", 27);
    freq.put("Ov", 12);
    freq.put("Ou", 19);
    freq.put("Os", 12);
    freq.put("Or", 42);
    freq.put("Op", 23);
    freq.put("d", 12052);
    freq.put("amN", 11);
    freq.put("dun", 186);
    freq.put("Kha", 9);
    freq.put("b ", 290);
    freq.put("ija", 16);
    freq.put("ije", 7);
    freq.put("UP ", 23);
    freq.put("bd", 33);
    freq.put("be", 940);
    freq.put("bf", 22);
    freq.put("bg", 25);
    freq.put("ba", 4417);
    freq.put("bb", 95);
    freq.put("bc", 12);
    freq.put("bl", 341);
    freq.put("bm", 7);
    freq.put("bn", 31);
    freq.put("bo", 791);
    freq.put("bh", 42);
    freq.put("bi", 1599);
    freq.put("bj", 22);
    freq.put("bk", 25);
    freq.put("bt", 20);
    freq.put("bu", 941);
    freq.put("bv", 8);
    freq.put("bw", 45);
    freq.put("br", 506);
    freq.put("bs", 95);
    freq.put("by", 213);
    freq.put("bz", 8);
    freq.put("Fu", 28);
    freq.put("bO", 21);
    freq.put("DE ", 14);
    freq.put("ME ", 20);
    freq.put(" C ", 9);
    freq.put("ci ", 8);
    freq.put("u ", 731);
    freq.put("Fe", 57);
    freq.put(" Ch", 182);
    freq.put(" Ci", 15);
    freq.put(" Co", 101);
    freq.put(" Cl", 50);
    freq.put(" Ca", 96);
    freq.put("uR", 7);
    freq.put("Fi", 84);
    freq.put(" Cr", 40);
    freq.put(" Cu", 25);
    freq.put("cia", 145);
    freq.put("uy", 298);
    freq.put("ux", 13);
    freq.put("cie", 12);
    freq.put("cid", 11);
    freq.put("uu", 269);
    freq.put("ut", 1014);
    freq.put("uw", 234);
    freq.put("uv", 19);
    freq.put("cio", 64);
    freq.put("cin", 30);
    freq.put("NE ", 30);
    freq.put("cil", 11);
    freq.put("cis", 20);
    freq.put("ul", 1538);
    freq.put("uo", 274);
    freq.put("cip", 14);
    freq.put("ui", 263);
    freq.put("uh", 601);
    freq.put("uk", 632);
    freq.put("cit", 55);
    freq.put("ue", 335);
    freq.put("ud", 277);
    freq.put("ug", 336);
    freq.put("uf", 22);
    freq.put("ua", 244);
    freq.put("uc", 205);
    freq.put("ub", 296);
    freq.put("ag ", 1998);
    freq.put("agA", 9);
    freq.put("agT", 19);
    freq.put("ago", 356);
    freq.put("agn", 35);
    freq.put("agm", 131);
    freq.put("agl", 156);
    freq.put("agk", 363);
    freq.put("agi", 506);
    freq.put("agh", 118);
    freq.put("agg", 31);
    freq.put("agf", 12);
    freq.put("age", 120);
    freq.put("agd", 114);
    freq.put("agc", 28);
    freq.put("agb", 146);
    freq.put("aga", 2183);
    freq.put("agy", 47);
    freq.put("agw", 26);
    freq.put("uis", 37);
    freq.put("agt", 209);
    freq.put("ags", 263);
    freq.put("agr", 93);
    freq.put("agp", 341);
    freq.put("ebo", 65);
    freq.put("tri", 198);
    freq.put("evi", 69);
    freq.put("tro", 66);
    freq.put("evo", 9);
    freq.put("tra", 153);
    freq.put("eva", 33);
    freq.put("zag", 8);
    freq.put("eve", 162);
    freq.put("try", 38);
    freq.put("tru", 24);
    freq.put("le ", 427);
    freq.put("ody", 17);
    freq.put("uen", 30);
    freq.put("Blu", 12);
    freq.put("odr", 7);
    freq.put("ods", 8);
    freq.put("odi", 24);
    freq.put("Blo", 13);
    freq.put("odl", 20);
    freq.put("odm", 12);
    freq.put("odn", 29);
    freq.put("odo", 26);
    freq.put("Ble", 11);
    freq.put("oda", 32);
    freq.put("odb", 7);
    freq.put("uev", 11);
    freq.put("Bla", 15);
    freq.put("ode", 66);
    freq.put("ues", 42);
    freq.put("uer", 19);
    freq.put("ct ", 91);
    freq.put("rd ", 130);
    freq.put("lea", 124);
    freq.put("leb", 17);
    freq.put("lec", 51);
    freq.put("led", 24);
    freq.put("lee", 100);
    freq.put("lef", 9);
    freq.put("leg", 53);
    freq.put("leh", 15);
    freq.put("lei", 22);
    freq.put("lek", 22);
    freq.put("lel", 21);
    freq.put("lem", 97);
    freq.put("len", 127);
    freq.put("leo", 15);
    freq.put("lep", 12);
    freq.put("ler", 77);
    freq.put("les", 190);
    freq.put("let", 101);
    freq.put("lev", 24);
    freq.put("lew", 12);
    freq.put("od ", 492);
    freq.put("ley", 62);
    freq.put("lez", 8);
    freq.put("ctu", 89);
    freq.put("rds", 26);
    freq.put("cts", 19);
    freq.put("leM", 7);
    freq.put("rde", 24);
    freq.put("cte", 24);
    freq.put("rda", 21);
    freq.put("rdo", 32);
    freq.put("cto", 40);
    freq.put("rdi", 17);
    freq.put("cti", 97);
    freq.put("Nor", 12);
    freq.put("sgi", 7);
    freq.put("sga", 19);
    freq.put("sge", 15);
    freq.put("zie", 12);
    freq.put("zia", 7);
    freq.put("zin", 26);
    freq.put("aBa", 17);
    freq.put("aBe", 22);
    freq.put("aBr", 13);
    freq.put("sg ", 7);
    freq.put("GT ", 9);
    freq.put("xci", 44);
    freq.put("baP", 7);
    freq.put("On ", 15);
    freq.put("XO ", 9);
    freq.put("AB ", 7);
    freq.put("npo", 13);
    freq.put("npe", 9);
    freq.put("npa", 18);
    freq.put("Q", 262);
    freq.put("mja", 9);
    freq.put("Onl", 12);
    freq.put("mjo", 18);
    freq.put("Ong", 30);
    freq.put("One", 12);
    freq.put("afe", 18);
    freq.put("Ayo", 65);
    freq.put("Aya", 58);
    freq.put("Ayy", 42);
    freq.put("Ayu", 12);
    freq.put("lz ", 9);
    freq.put("Sa ", 179);
    freq.put(" h ", 14);
    freq.put("Ay ", 54);
    freq.put("Sak", 50);
    freq.put(" hy", 18);
    freq.put("San", 206);
    freq.put("Sam", 61);
    freq.put("Sal", 69);
    freq.put(" hr", 12);
    freq.put("Saa", 18);
    freq.put("Sag", 14);
    freq.put(" hu", 183);
    freq.put(" ht", 553);
    freq.put("kpa", 26);
    freq.put(" hi", 890);
    freq.put(" hh", 8);
    freq.put(" ho", 163);
    freq.put(" hn", 49);
    freq.put(" hm", 25);
    freq.put("Sas", 13);
    freq.put("Sar", 62);
    freq.put(" ha", 2352);
    freq.put(" he", 303);
    freq.put("kpo", 14);
    freq.put("Nka", 9);
    freq.put("OM ", 23);
    freq.put("IT ", 74);
    freq.put("ihh", 8);
    freq.put("ihi", 311);
    freq.put("iha", 136);
    freq.put("ihe", 8);
    freq.put("UN ", 33);
    freq.put("clo", 37);
    freq.put("?😂", 23);
    freq.put("DG ", 8);
    freq.put("ih ", 12);
    freq.put("cli", 15);
    freq.put("?😭", 13);
    freq.put("cea", 7);
    freq.put(" E ", 29);
    freq.put("ck ", 229);
    freq.put(" El", 42);
    freq.put(" Em", 9);
    freq.put(" En", 47);
    freq.put(" Eh", 70);
    freq.put(" Ei", 7);
    freq.put(" Ek", 8);
    freq.put(" Ed", 28);
    freq.put(" Ea", 18);
    freq.put("BI ", 17);
    freq.put(" Ex", 35);
    freq.put(" Et", 24);
    freq.put(" Ev", 16);
    freq.put(" Ew", 22);
    freq.put(" Ep", 8);
    freq.put(" Er", 24);
    freq.put(" Es", 7);
    freq.put("cke", 44);
    freq.put("ckg", 8);
    freq.put("cka", 15);
    freq.put("AA ", 31);
    freq.put("ckb", 11);
    freq.put("ckm", 9);
    freq.put("ckl", 11);
    freq.put("cki", 21);
    freq.put("cks", 53);
    freq.put("cky", 15);
    freq.put("dba", 21);
    freq.put("lB", 13);
    freq.put("KI ", 16);
    freq.put("jay", 43);
    freq.put("jar", 7);
    freq.put("jas", 23);
    freq.put("jap", 19);
    freq.put("jan", 103);
    freq.put("ae ", 163);
    freq.put("LQn", 12);
    freq.put("jam", 39);
    freq.put("jaj", 9);
    freq.put("jai", 11);
    freq.put("jae", 12);
    freq.put("jac", 12);
    freq.put("jaa", 10);
    freq.put("db ", 10);
    freq.put("aes", 9);
    freq.put("gbe", 12);
    freq.put("aet", 9);
    freq.put("gba", 103);
    freq.put("gbo", 9);
    freq.put("aez", 8);
    freq.put("gbi", 33);
    freq.put("gbu", 16);
    freq.put("aee", 11);
    freq.put("aek", 8);
    freq.put("aem", 17);
    freq.put("ael", 33);
    freq.put("ja ", 26);
    freq.put("aen", 70);
    freq.put("Pr", 119);
    freq.put("Ps", 8);
    freq.put("btw", 9);
    freq.put("Pw", 31);
    freq.put("Pu", 115);
    freq.put("oma", 57);
    freq.put("Pa", 986);
    freq.put("OP ", 26);
    freq.put("Pe", 210);
    freq.put("Ph", 59);
    freq.put("Pi", 202);
    freq.put("Po", 92);
    freq.put("Pl", 46);
    freq.put("et ", 537);
    freq.put("EY ", 10);
    freq.put("P ", 285);
    freq.put("eun", 14);
    freq.put("tsj", 10);
    freq.put("tsk", 64);
    freq.put("etr", 32);
    freq.put("ets", 88);
    freq.put("etw", 24);
    freq.put("ett", 111);
    freq.put("etu", 9);
    freq.put("tly", 8);
    freq.put("tsi", 16);
    freq.put("etb", 12);
    freq.put("etc", 25);
    freq.put("tla", 13);
    freq.put("eta", 61);
    freq.put("tlg", 52);
    freq.put("tle", 61);
    freq.put("ete", 63);
    freq.put("eth", 58);
    freq.put("eti", 39);
    freq.put("tlo", 26);
    freq.put("eto", 94);
    freq.put("ck", 490);
    freq.put("cj", 11);
    freq.put("ci", 391);
    freq.put("ch", 1160);
    freq.put("co", 1291);
    freq.put("cn", 18);
    freq.put("cm", 21);
    freq.put("cl", 191);
    freq.put("cc", 89);
    freq.put("cb", 13);
    freq.put("lg ", 19);
    freq.put("cg", 41);
    freq.put("Hey", 26);
    freq.put("ce", 837);
    freq.put("cd", 30);
    freq.put("cz", 13);
    freq.put("cy", 80);
    freq.put("ucc", 9);
    freq.put("Hea", 18);
    freq.put("uca", 14);
    freq.put("cs", 118);
    freq.put("cr", 222);
    freq.put("cq", 8);
    freq.put("cp", 24);
    freq.put("Heh", 52);
    freq.put("cv", 9);
    freq.put("cu", 175);
    freq.put("ct", 385);
    freq.put("Ger", 10);
    freq.put("cM", 7);
    freq.put("Get", 8);
    freq.put("cE", 9);
    freq.put("Gen", 25);
    freq.put("Gel", 11);
    freq.put("lga", 67);
    freq.put("lge", 13);
    freq.put("He ", 7);
    freq.put("iKu", 7);
    freq.put("rbu", 7);
    freq.put("rbo", 19);
    freq.put("rbi", 9);
    freq.put("rbe", 14);
    freq.put("ly", 475);
    freq.put("rba", 15);
    freq.put("Thr", 9);
    freq.put("va", 193);
    freq.put("vb", 13);
    freq.put("vd", 8);
    freq.put("ve", 1010);
    freq.put("vh", 13);
    freq.put("vi", 484);
    freq.put("ph ", 30);
    freq.put("vl", 9);
    freq.put("vo", 95);
    freq.put("vr", 16);
    freq.put("vs", 28);
    freq.put("vy", 19);
    freq.put("vz", 8);
    freq.put("of ", 71);
    freq.put("v ", 87);
    freq.put("yoo", 31);
    freq.put("phi", 30);
    freq.put("pho", 90);
    freq.put("yon", 679);
    freq.put("pha", 8);
    freq.put("yom", 10);
    freq.put("phe", 16);
    freq.put("phy", 13);
    freq.put("yok", 106);
    freq.put("off", 61);
    freq.put("Nit", 7);
    freq.put("ofi", 11);
    freq.put("gAs", 9);
    freq.put("oft", 18);
    freq.put("wec", 8);
    freq.put("wea", 18);
    freq.put("wee", 287);
    freq.put("wed", 179);
    freq.put("wei", 24);
    freq.put("weh", 13);
    freq.put("Oh ", 33);
    freq.put("gum", 118);
    freq.put("wel", 37);
    freq.put("wes", 34);
    freq.put("wer", 84);
    freq.put("wew", 10);
    freq.put("wet", 13);
    freq.put("eWa", 7);
    freq.put("yow", 15);
    freq.put("nve", 11);
    freq.put("nvo", 11);
    freq.put("nvi", 12);
    freq.put("we ", 24);
    freq.put("Ohh", 9);
    freq.put("mhi", 7);
    freq.put("yos", 122);
    freq.put("mhe", 10);
    freq.put("mha", 12);
    freq.put("Sab", 69);
    freq.put("yop", 13);
    freq.put("Sad", 10);
    freq.put("Say", 71);
    freq.put("kr ", 7);
    freq.put("vs ", 20);
    freq.put("Sch", 19);
    freq.put(" ju", 110);
    freq.put(" js", 8);
    freq.put(" jm", 12);
    freq.put(" jo", 160);
    freq.put("kri", 58);
    freq.put(" ji", 25);
    freq.put(" jh", 20);
    freq.put(" jk", 25);
    freq.put(" je", 129);
    freq.put("kra", 10);
    freq.put(" ja", 201);
    freq.put("kre", 7);
    freq.put("eBo", 20);
    freq.put("tIb", 7);
    freq.put("yri", 18);
    freq.put("yro", 21);
    freq.put("yra", 17);
    freq.put("yre", 9);
    freq.put("yrt", 8);
    freq.put("yru", 9);
    freq.put("yr ", 8);
    freq.put("OO ", 53);
    freq.put("inz", 8);
    freq.put("int", 260);
    freq.put("inu", 158);
    freq.put("inv", 16);
    freq.put("inw", 8);
    freq.put("inp", 9);
    freq.put("ins", 240);
    freq.put("inl", 40);
    freq.put("inm", 8);
    freq.put("inn", 67);
    freq.put("ino", 455);
    freq.put("inh", 11);
    freq.put("ini", 608);
    freq.put("inj", 10);
    freq.put("ink", 70);
    freq.put("ind", 1009);
    freq.put("ine", 442);
    freq.put("inf", 23);
    freq.put("ing", 2528);
    freq.put("ina", 1588);
    freq.put("inb", 9);
    freq.put("inc", 105);
    freq.put("eo ", 66);
    freq.put("inK", 7);
    freq.put("hpa", 7);
    freq.put("DA ", 43);
    freq.put("U", 443);
    freq.put("in ", 2807);
    freq.put("eof", 9);
    freq.put("eon", 36);
    freq.put("eol", 10);
    freq.put("eor", 8);
    freq.put("eop", 10);
    freq.put("eou", 9);
    freq.put("Tur", 14);
    freq.put("aln", 11);
    freq.put("AH ", 57);
    freq.put("CS ", 15);
    freq.put("MA ", 56);
    freq.put(" G ", 28);
    freq.put("alh", 12);
    freq.put("Tul", 33);
    freq.put("ald", 56);
    freq.put("Tum", 18);
    freq.put(" Gw", 26);
    freq.put(" Gu", 182);
    freq.put(" Gr", 98);
    freq.put("Tun", 13);
    freq.put("alc", 13);
    freq.put("Vho", 7);
    freq.put(" Ge", 61);
    freq.put(" Ga", 210);
    freq.put(" Gn", 7);
    freq.put(" Go", 180);
    freq.put(" Gl", 17);
    freq.put(" Gi", 98);
    freq.put("cma", 7);
    freq.put("AG ", 85);
    freq.put("ak ", 312);
    freq.put("LS ", 20);
    freq.put("Cr", 66);
    freq.put("gli", 61);
    freq.put("aky", 28);
    freq.put("glo", 33);
    freq.put("aks", 50);
    freq.put("gla", 202);
    freq.put("akp", 9);
    freq.put("gle", 62);
    freq.put("aku", 105);
    freq.put("akt", 117);
    freq.put("akk", 7);
    freq.put("aki", 1273);
    freq.put("ako", 2559);
    freq.put("akn", 8);
    freq.put("akl", 51);
    freq.put("akb", 13);
    freq.put("aka", 2512);
    freq.put("glu", 16);
    freq.put("ake", 205);
    freq.put("akd", 8);
    freq.put("Jer", 16);
    freq.put("iy", 986);
    freq.put("bry", 17);
    freq.put("bro", 80);
    freq.put("iz", 223);
    freq.put("bri", 32);
    freq.put("Jee", 11);
    freq.put("bre", 102);
    freq.put("OR ", 11);
    freq.put("er ", 1029);
    freq.put("tn ", 7);
    freq.put("Nak", 236);
    freq.put("is", 2526);
    freq.put("nka", 48);
    freq.put("Nai", 33);
    freq.put("erP", 11);
    freq.put("nke", 13);
    freq.put("iu", 59);
    freq.put("nkk", 12);
    freq.put("nkl", 9);
    freq.put("nko", 19);
    freq.put("erD", 10);
    freq.put("erE", 9);
    freq.put("erF", 7);
    freq.put("nks", 51);
    freq.put("Nal", 13);
    freq.put("erB", 64);
    freq.put("erL", 20);
    freq.put("erM", 10);
    freq.put("erO", 7);
    freq.put("erJ", 8);
    freq.put("ert", 99);
    freq.put("ii", 739);
    freq.put("erv", 44);
    freq.put("erw", 12);
    freq.put("erp", 32);
    freq.put("err", 102);
    freq.put("ih", 489);
    freq.put("ik", 1046);
    freq.put("erd", 22);
    freq.put("ere", 156);
    freq.put("erf", 19);
    freq.put("erg", 21);
    freq.put("CT ", 17);
    freq.put("era", 202);
    freq.put("erb", 25);
    freq.put("erc", 27);
    freq.put("erl", 32);
    freq.put("erm", 63);
    freq.put("ern", 107);
    freq.put("ero", 740);
    freq.put("erh", 10);
    freq.put("eri", 122);
    freq.put("erj", 7);
    freq.put("Naw", 11);
    freq.put("Aba", 27);
    freq.put("io", 553);
    freq.put("uas", 9);
    freq.put("in", 10671);
    freq.put("la ", 2445);
    freq.put("uat", 40);
    freq.put("ual", 31);
    freq.put("uan", 91);
    freq.put("ki ", 169);
    freq.put("lal", 576);
    freq.put("lam", 645);
    freq.put("lan", 3562);
    freq.put("lao", 17);
    freq.put("lah", 272);
    freq.put("lai", 82);
    freq.put("lak", 320);
    freq.put("lad", 70);
    freq.put("laf", 10);
    freq.put("lag", 849);
    freq.put("laa", 69);
    freq.put("lab", 237);
    freq.put("lac", 61);
    freq.put("lax", 15);
    freq.put("lay", 237);
    freq.put("laz", 14);
    freq.put("lat", 262);
    freq.put("lau", 39);
    freq.put("lav", 17);
    freq.put("law", 116);
    freq.put("lap", 130);
    freq.put("lar", 162);
    freq.put("las", 372);
    freq.put("laL", 8);
    freq.put("laC", 10);
    freq.put("zen", 8);
    freq.put("zel", 27);
    freq.put("zer", 9);
    freq.put("zet", 7);
    freq.put("ze ", 32);
    freq.put("aFr", 22);
    freq.put("l", 24950);
    freq.put("uod", 76);
    freq.put("nt ", 235);
    freq.put("tso", 16);
    freq.put("nts", 90);
    freq.put("ntr", 33);
    freq.put("ntu", 25);
    freq.put("nti", 231);
    freq.put("nth", 56);
    freq.put("ntl", 11);
    freq.put("nto", 286);
    freq.put("ntn", 8);
    freq.put("nta", 538);
    freq.put("nte", 210);
    freq.put("dAn", 14);
    freq.put("YS ", 10);
    freq.put("tsm", 78);
    freq.put(" l ", 10);
    freq.put("kt ", 14);
    freq.put(" lg", 16);
    freq.put(" le", 153);
    freq.put("B", 2188);
    freq.put(" la", 3004);
    freq.put("VMi", 7);
    freq.put(" lo", 487);
    freq.put(" ln", 161);
    freq.put(" ll", 15);
    freq.put(" li", 329);
    freq.put(" lh", 15);
    freq.put(" lu", 204);
    freq.put("nbu", 10);
    freq.put(" ly", 18);
    freq.put("Ser", 17);
    freq.put("ktu", 7);
    freq.put("See", 7);
    freq.put("kto", 37);
    freq.put("kte", 13);
    freq.put("kta", 108);
    freq.put("Q ", 26);
    freq.put("ter", 645);
    freq.put("ypa", 22);
    freq.put("sSh", 8);
    freq.put("ype", 35);
    freq.put("ypo", 18);
    freq.put("Qu", 128);
    freq.put("teL", 7);
    freq.put("Qn", 14);
    freq.put("tse", 17);
    freq.put("yp ", 9);
    freq.put("d ", 2391);
    freq.put("tsc", 7);
    freq.put("hry", 22);
    freq.put("em ", 69);
    freq.put("udn", 7);
    freq.put("yen", 37);
    freq.put("hrs", 14);
    freq.put("hro", 24);
    freq.put("hri", 59);
    freq.put("hre", 7);
    freq.put("sur", 89);
    freq.put("dn", 104);
    freq.put("do", 735);
    freq.put("dl", 79);
    freq.put("dm", 59);
    freq.put("dj", 29);
    freq.put("dk", 20);
    freq.put("dh", 41);
    freq.put("di", 3131);
    freq.put("df", 37);
    freq.put("dg", 61);
    freq.put("dd", 117);
    freq.put("de", 1016);
    freq.put("db", 53);
    freq.put("dc", 24);
    freq.put("da", 2554);
    freq.put("dz", 29);
    freq.put("dy", 376);
    freq.put("dv", 33);
    freq.put("dw", 28);
    freq.put("dt", 75);
    freq.put("du", 394);
    freq.put("dr", 234);
    freq.put("ds", 158);
    freq.put("dp", 32);
    freq.put("eme", 76);
    freq.put("dO", 7);
    freq.put("dM", 20);
    freq.put("ema", 138);
    freq.put("dK", 10);
    freq.put("dI", 12);
    freq.put("emm", 17);
    freq.put("emo", 59);
    freq.put("dE", 8);
    freq.put("dB", 12);
    freq.put("dC", 7);
    freq.put("dA", 29);
    freq.put("PA ", 70);
    freq.put("emp", 68);
    freq.put("ems", 11);
    freq.put("nLi", 8);
    freq.put("emy", 12);
    freq.put("hr ", 9);
    freq.put("dP", 8);
    freq.put("w ", 1518);
    freq.put(" I ", 213);
    freq.put("MO ", 94);
    freq.put("il ", 297);
    freq.put("xD ", 46);
    freq.put("co ", 623);
    freq.put("we", 839);
    freq.put("wd", 20);
    freq.put("wb", 32);
    freq.put("wa", 2716);
    freq.put(" Ip", 35);
    freq.put("wn", 92);
    freq.put(" Ir", 13);
    freq.put(" Is", 72);
    freq.put(" It", 70);
    freq.put("wi", 714);
    freq.put("wh", 118);
    freq.put("ww", 127);
    freq.put(" Ii", 9);
    freq.put("wu", 15);
    freq.put(" Ik", 87);
    freq.put(" Il", 35);
    freq.put(" Im", 61);
    freq.put(" In", 200);
    freq.put("wp", 8);
    freq.put(" Ia", 57);
    freq.put(" Ib", 28);
    freq.put(" Ic", 12);
    freq.put(" If", 7);
    freq.put(" Ig", 7);
    freq.put("cop", 15);
    freq.put("ild", 25);
    freq.put("cor", 66);
    freq.put("ilb", 8);
    freq.put("cot", 8);
    freq.put("ila", 1071);
    freq.put("ilo", 161);
    freq.put("ill", 257);
    freq.put("ilm", 12);
    freq.put("wK", 7);
    freq.put("ilk", 14);
    freq.put("ili", 624);
    freq.put("ilv", 10);
    freq.put("AE ", 19);
    freq.put("ilt", 7);
    freq.put("ilu", 14);
    freq.put("wS", 9);
    freq.put("ils", 11);
    freq.put("com", 101);
    freq.put("col", 102);
    freq.put("coo", 32);
    freq.put("ily", 53);
    freq.put("gn ", 23);
    freq.put("ai ", 64);
    freq.put("aiy", 37);
    freq.put("aiz", 20);
    freq.put("bng", 10);
    freq.put("aiw", 21);
    freq.put("aip", 16);
    freq.put("ais", 49);
    freq.put("air", 110);
    freq.put("aim", 19);
    freq.put("ail", 250);
    freq.put("ET ", 32);
    freq.put("gna", 113);
    freq.put("aii", 92);
    freq.put("aih", 8);
    freq.put("aik", 12);
    freq.put("gne", 9);
    freq.put("aid", 18);
    freq.put("aig", 32);
    freq.put("gni", 16);
    freq.put("aia", 12);
    freq.put("aic", 11);
    freq.put("gnm", 7);
    freq.put("ni ", 600);
    freq.put("Ika", 81);
    freq.put("ep ", 73);
    freq.put("th ", 170);
    freq.put("nik", 68);
    freq.put("nih", 16);
    freq.put("nii", 59);
    freq.put("nin", 530);
    freq.put("nio", 25);
    freq.put("nil", 385);
    freq.put("nim", 41);
    freq.put("nib", 31);
    freq.put("nic", 124);
    freq.put("nia", 44);
    freq.put("nif", 20);
    freq.put("nig", 150);
    freq.put("nid", 14);
    freq.put("nie", 163);
    freq.put("niz", 11);
    freq.put("thN", 40);
    freq.put("nix", 7);
    freq.put("niy", 381);
    freq.put("Y", 1092);
    freq.put("nis", 183);
    freq.put("nip", 49);
    freq.put("niq", 8);
    freq.put("niv", 26);
    freq.put("niw", 55);
    freq.put("nit", 198);
    freq.put("thy", 21);
    freq.put("epy", 7);
    freq.put("ept", 13);
    freq.put("epu", 9);
    freq.put("epr", 7);
    freq.put("eps", 14);
    freq.put("epp", 7);
    freq.put("tho", 51);
    freq.put("epo", 27);
    freq.put("epl", 84);
    freq.put("thl", 15);
    freq.put("eph", 32);
    freq.put("epi", 35);
    freq.put("the", 302);
    freq.put("epe", 25);
    freq.put("tha", 79);
    freq.put("epa", 55);
    freq.put("rn ", 32);
    freq.put("Gay", 15);
    freq.put("Gaw", 12);
    freq.put("Gar", 8);
    freq.put("Gan", 85);
    freq.put("Gam", 16);
    freq.put("Gal", 40);
    freq.put("Gag", 38);
    freq.put("Gab", 18);
    freq.put("Tri", 30);
    freq.put("rni", 93);
    freq.put("rno", 22);
    freq.put("Tra", 17);
    freq.put("rna", 57);
    freq.put("Tre", 9);
    freq.put("rne", 46);
    freq.put("Try", 18);
    freq.put("rny", 19);
    freq.put("lca", 16);
    freq.put("lco", 26);
    freq.put("Tru", 8);
    freq.put("Ewa", 18);
    freq.put("Lea", 8);
    freq.put("yka", 14);
    freq.put("😂?", 28);
    freq.put("Lee", 9);
    freq.put("yke", 11);
    freq.put("Lei", 7);
    freq.put("yki", 10);
    freq.put("yko", 8);
    freq.put("ob ", 76);
    freq.put("Les", 7);
    freq.put("Let", 10);
    freq.put("😂 ", 7);
    freq.put("obO", 16);
    freq.put("plu", 21);
    freq.put("pls", 11);
    freq.put("gMa", 9);
    freq.put("ply", 77);
    freq.put("ple", 142);
    freq.put("pla", 168);
    freq.put("plo", 24);
    freq.put("pli", 23);
    freq.put("obo", 59);
    freq.put("obl", 74);
    freq.put("obi", 32);
    freq.put("obe", 43);
    freq.put("obb", 9);
    freq.put("oba", 32);
    freq.put("obr", 172);
    freq.put("Cut", 15);
    freq.put("Cur", 8);
    freq.put("wan", 315);
    freq.put("wal", 828);
    freq.put("wak", 39);
    freq.put("wai", 39);
    freq.put("wah", 88);
    freq.put("wag", 294);
    freq.put("wad", 7);
    freq.put("waa", 29);
    freq.put("way", 108);
    freq.put("waw", 57);
    freq.put("wat", 80);
    freq.put("was", 63);
    freq.put("war", 76);
    freq.put("wap", 107);
    freq.put("eSu", 8);
    freq.put("xy ", 21);
    freq.put("eSa", 11);
    freq.put("eSi", 8);
    freq.put("wa ", 565);
    freq.put("mta", 9);
    freq.put(" n ", 93);
    freq.put("Sat", 10);
    freq.put(" ni", 1389);
    freq.put(" nk", 73);
    freq.put(" nm", 116);
    freq.put(" nl", 69);
    freq.put(" no", 298);
    freq.put(" nn", 12);
    freq.put(" na", 9603);
    freq.put(" nb", 11);
    freq.put(" ne", 207);
    freq.put(" nd", 52);
    freq.put(" ng", 3834);
    freq.put(" ny", 417);
    freq.put(" np", 11);
    freq.put(" ns", 14);
    freq.put(" nu", 314);
    freq.put(" nt", 14);
    freq.put("Sk", 10);
    freq.put("TW ", 10);
    freq.put("ums", 9);
    freq.put("Sge", 15);
    freq.put("gu ", 10);
    freq.put("yve", 10);
    freq.put("umm", 50);
    freq.put("gua", 26);
    freq.put("gug", 21);
    freq.put("gue", 56);
    freq.put("gud", 21);
    freq.put("gui", 45);
    freq.put("gun", 47);
    freq.put("RY ", 13);
    freq.put("gul", 87);
    freq.put("gus", 284);
    freq.put("p", 16246);
    freq.put("gup", 11);
    freq.put("guu", 8);
    freq.put("gut", 58);
    freq.put("guy", 44);
    freq.put("hte", 7);
    freq.put("hta", 17);
    freq.put("OK ", 25);
    freq.put("htt", 549);
    freq.put("hts", 17);
    freq.put("htr", 11);
    freq.put("IN ", 122);
    freq.put("ek ", 70);
    freq.put("ht ", 142);
    freq.put("eko", 9);
    freq.put("ekl", 9);
    freq.put("eki", 23);
    freq.put("eke", 23);
    freq.put("eka", 57);
    freq.put(" ip", 136);
    freq.put("ekt", 23);
    freq.put("eks", 69);
    freq.put("nBe", 10);
    freq.put(" it", 320);
    freq.put(" iu", 11);
    freq.put("SB ", 8);
    freq.put("uzz", 9);
    freq.put(" iw", 23);
    freq.put("kse", 28);
    freq.put(" Ka", 844);
    freq.put("kyl", 34);
    freq.put(" Ke", 71);
    freq.put("ib ", 9);
    freq.put(" Kh", 10);
    freq.put(" Ki", 116);
    freq.put(" Ko", 57);
    freq.put(" Kl", 7);
    freq.put(" Kr", 27);
    freq.put(" Kw", 13);
    freq.put(" Ku", 251);
    freq.put("ksa", 33);
    freq.put(" Ky", 14);
    freq.put(" im", 267);
    freq.put("Mom", 40);
    freq.put("F", 677);
    freq.put("uz ", 42);
    freq.put("fb ", 34);
    freq.put("BS ", 14);
    freq.put(" ib", 276);
    freq.put("ibi", 242);
    freq.put(" K ", 48);
    freq.put("ibl", 27);
    freq.put("ibo", 52);
    freq.put("cas", 58);
    freq.put("iba", 358);
    freq.put("cap", 26);
    freq.put("ibe", 46);
    freq.put("cau", 8);
    freq.put("cat", 49);
    freq.put("cak", 22);
    freq.put("cai", 12);
    freq.put("cah", 11);
    freq.put("can", 71);
    freq.put("cam", 77);
    freq.put("cal", 65);
    freq.put("cab", 20);
    freq.put("ibr", 57);
    freq.put("AK ", 25);
    freq.put("ibu", 12);
    freq.put("cad", 17);
    freq.put("ao ", 218);
    freq.put("spr", 9);
    freq.put("spi", 56);
    freq.put("spl", 10);
    freq.put("spo", 28);
    freq.put("yQu", 11);
    freq.put("spa", 35);
    freq.put("spe", 91);
    freq.put("😭?", 17);
    freq.put("gh ", 47);
    freq.put("??", 9);
    freq.put("aon", 212);
    freq.put("aol", 15);
    freq.put("aot", 7);
    freq.put("aos", 9);
    freq.put("sp ", 8);
    freq.put("? ", 7);
    freq.put("ght", 180);
    freq.put("ghu", 23);
    freq.put("KO ", 218);
    freq.put("ghe", 11);
    freq.put("ER ", 68);
    freq.put("gha", 91);
    freq.put("ghi", 79);
    freq.put("ghj", 23);
    freq.put("Ru", 26);
    freq.put("Che", 39);
    freq.put("Jay", 18);
    freq.put("Chi", 82);
    freq.put("no ", 960);
    freq.put("Ry", 26);
    freq.put("Jap", 25);
    freq.put("Cho", 23);
    freq.put("Jan", 26);
    freq.put("Re", 149);
    freq.put("Chr", 30);
    freq.put("mbo", 37);
    freq.put("Ra", 95);
    freq.put("Jai", 10);
    freq.put("Ro", 112);
    freq.put("Rh", 12);
    freq.put("Jac", 24);
    freq.put("sod", 15);
    freq.put("Usa", 8);
    freq.put("nol", 17);
    freq.put("nom", 50);
    freq.put("non", 414);
    freq.put("noo", 160);
    freq.put("noh", 41);
    freq.put("nod", 51);
    freq.put("eNi", 13);
    freq.put("nog", 21);
    freq.put("nob", 27);
    freq.put("mba", 115);
    freq.put("aer", 10);
    freq.put("R ", 187);
    freq.put("noy", 72);
    freq.put("not", 74);
    freq.put("nou", 22);
    freq.put("nov", 12);
    freq.put("son", 180);
    freq.put("nop", 12);
    freq.put("nor", 34);
    freq.put("nos", 24);
    freq.put("h", 22655);
    freq.put("sou", 14);
    freq.put("em", 553);
    freq.put("el", 1967);
    freq.put("eo", 190);
    freq.put("en", 2424);
    freq.put("ei", 259);
    freq.put("eh", 1456);
    freq.put("ek", 308);
    freq.put("ej", 94);
    freq.put("ee", 1836);
    freq.put("ed", 859);
    freq.put("eg", 343);
    freq.put("ef", 156);
    freq.put("ea", 1115);
    freq.put("rl ", 102);
    freq.put("ec", 473);
    freq.put("eb", 301);
    freq.put("ey", 564);
    freq.put("ex", 408);
    freq.put("ez", 173);
    freq.put("lm ", 15);
    freq.put("et", 1219);
    freq.put("ew", 259);
    freq.put("ev", 289);
    freq.put("eq", 34);
    freq.put("ep", 410);
    freq.put("es", 1971);
    freq.put("er", 3484);
    freq.put("eM", 51);
    freq.put("eL", 60);
    freq.put("eO", 19);
    freq.put("eN", 21);
    freq.put("eI", 15);
    freq.put("eH", 16);
    freq.put("eK", 35);
    freq.put("eJ", 43);
    freq.put("eE", 15);
    freq.put("eD", 34);
    freq.put("eG", 21);
    freq.put("eF", 27);
    freq.put("eA", 39);
    freq.put("eC", 46);
    freq.put("eB", 69);
    freq.put("eY", 18);
    freq.put("eX", 9);
    freq.put("eU", 11);
    freq.put("eT", 37);
    freq.put("eW", 14);
    freq.put("eV", 10);
    freq.put("eP", 58);
    freq.put("eS", 46);
    freq.put("eR", 34);
    freq.put("iMa", 7);
    freq.put("rlo", 47);
    freq.put("rli", 17);
    freq.put("rle", 35);
    freq.put("rld", 18);
    freq.put("rlf", 17);
    freq.put("rla", 56);
    freq.put("e ", 6688);
    freq.put("lmi", 13);
    freq.put("rly", 23);
    freq.put("lmo", 27);
    freq.put("lma", 34);
    freq.put("lme", 25);
    freq.put("rls", 25);
    freq.put("usk", 19);
    freq.put("zan", 16);
    freq.put("xh", 9);
    freq.put("xi", 54);
    freq.put("xn", 11);
    freq.put("xo", 38);
    freq.put("xm", 7);
    freq.put("xc", 64);
    freq.put("xa", 69);
    freq.put("xe", 25);
    freq.put("xz", 7);
    freq.put("xx", 49);
    freq.put("xy", 46);
    freq.put("xs", 13);
    freq.put("xp", 50);
    freq.put("zar", 27);
    freq.put("xt", 248);
    freq.put("yie", 9);
    freq.put("yin", 77);
    freq.put("yii", 11);
    freq.put("xD", 140);
    freq.put("yit", 11);
    freq.put("x ", 206);
    freq.put("pnt", 7);
    freq.put("za ", 60);
    freq.put("aJa", 14);
    freq.put("kyp", 11);
    freq.put("Phi", 28);
    freq.put("Pho", 16);
    freq.put("fB", 7);
    freq.put("mr ", 8);
    freq.put("Off", 42);
    freq.put("fL", 13);
    freq.put("Ph ", 8);
    freq.put("OfL", 10);
    freq.put("Wed", 7);
    freq.put("Weh", 8);
    freq.put("Wel", 10);
    freq.put(" p ", 61);
    freq.put(" ps", 15);
    freq.put(" pr", 321);
    freq.put("HS ", 12);
    freq.put(" pp", 18);
    freq.put(" pw", 165);
    freq.put(" pu", 418);
    freq.put(" pt", 7);
    freq.put(" pc", 9);
    freq.put(" pb", 7);
    freq.put(" pa", 4645);
    freq.put(" pg", 24);
    freq.put(" pe", 563);
    freq.put(" pd", 10);
    freq.put(" pk", 7);
    freq.put(" pi", 598);
    freq.put(" ph", 86);
    freq.put(" po", 595);
    freq.put(" pn", 18);
    freq.put(" pm", 27);
    freq.put(" pl", 192);
    freq.put("yto", 7);
    freq.put("yth", 15);
    freq.put("yti", 7);
    freq.put("yte", 7);
    freq.put("yta", 13);
    freq.put("Kri", 32);
    freq.put("gwa", 105);
    freq.put("EM ", 7);
    freq.put("gwi", 8);
    freq.put("yt ", 28);
    freq.put("OE ", 16);
    freq.put("ei ", 26);
    freq.put("eis", 30);
    freq.put("eir", 28);
    freq.put("eit", 10);
    freq.put("IL ", 8);
    freq.put("eiv", 7);
    freq.put("eia", 11);
    freq.put("eig", 28);
    freq.put("eii", 13);
    freq.put("eim", 8);
    freq.put("eil", 16);
    freq.put("ein", 38);
    freq.put("ceg", 51);
    freq.put("yh", 33);
    freq.put("yk", 62);
    freq.put("yj", 34);
    freq.put("yl", 230);
    freq.put(" Me", 142);
    freq.put(" Mg", 95);
    freq.put(" Ma", 1252);
    freq.put(" Mc", 7);
    freq.put(" Mm", 7);
    freq.put(" Mo", 126);
    freq.put(" Mi", 292);
    freq.put("Sin", 142);
    freq.put(" Mu", 46);
    freq.put(" Mr", 20);
    freq.put(" Ms", 15);
    freq.put(" My", 66);
    freq.put("yb", 106);
    freq.put("NS ", 11);
    freq.put("two", 13);
    freq.put("ux ", 7);
    freq.put("tli", 11);
    freq.put(" M ", 16);
    freq.put("MK ", 8);
    freq.put("cco", 38);
    freq.put("cce", 8);
    freq.put("cca", 7);
    freq.put("ccc", 11);
    freq.put("Uma", 23);
    freq.put("am ", 625);
    freq.put("ps ", 86);
    freq.put("Her", 8);
    freq.put("yv", 20);
    freq.put("ca", 714);
    freq.put("ami", 1096);
    freq.put("ift", 22);
    freq.put("amk", 11);
    freq.put("psi", 10);
    freq.put("amm", 34);
    freq.put("aml", 13);
    freq.put("amo", 175);
    freq.put("ifu", 19);
    freq.put("ama", 2597);
    freq.put("amc", 19);
    freq.put("amb", 136);
    freq.put("ame", 272);
    freq.put("amd", 93);
    freq.put("amg", 19);
    freq.put("amy", 16);
    freq.put("LY ", 16);
    freq.put("pss", 8);
    freq.put("ams", 59);
    freq.put("amr", 11);
    freq.put("amu", 77);
    freq.put("amt", 14);
    freq.put("pst", 12);
    freq.put("amK", 9);
    freq.put("amJ", 7);
    freq.put("amM", 15);
    freq.put("amL", 8);
    freq.put("Hee", 7);
    freq.put("amA", 14);
    freq.put("amC", 10);
    freq.put("amB", 7);
    freq.put("uce", 18);
    freq.put("gjo", 12);
    freq.put("t", 26869);
    freq.put("amP", 8);
    freq.put("amS", 10);
    freq.put("amT", 7);
    freq.put("yng", 7);
    freq.put("eL ", 9);
    freq.put("Hel", 28);
    freq.put(" O ", 81);
    freq.put("dz ", 8);
    freq.put("uck", 77);
    freq.put("uch", 70);
    freq.put("eLi", 16);
    freq.put("tdo", 10);
    freq.put("eLo", 7);
    freq.put("tda", 7);
    freq.put("eLe", 9);
    freq.put("nme", 16);
    freq.put("nma", 76);
    freq.put("nmn", 59);
    freq.put("nmo", 11);
    freq.put("nmi", 18);
    freq.put("yR", 16);
    freq.put("sro", 9);
    freq.put("ifi", 39);
    freq.put("Adv", 7);
    freq.put("Add", 10);
    freq.put("Ada", 7);
    freq.put("Adm", 7);
    freq.put("Adi", 7);
    freq.put("lob", 22);
    freq.put("loc", 40);
    freq.put("loa", 111);
    freq.put("log", 371);
    freq.put("lod", 10);
    freq.put("loe", 7);
    freq.put("lok", 105);
    freq.put("loi", 16);
    freq.put("lon", 160);
    freq.put("loo", 107);
    freq.put("lol", 262);
    freq.put("lom", 14);
    freq.put("lor", 79);
    freq.put("los", 120);
    freq.put("lop", 20);
    freq.put("lov", 276);
    freq.put("low", 166);
    freq.put("lot", 39);
    freq.put("lou", 42);
    freq.put("loy", 137);
    freq.put("J", 852);
    freq.put("lo ", 433);
    freq.put("Est", 13);
    freq.put("Esp", 7);
    freq.put("Lal", 34);
    freq.put("Lam", 13);
    freq.put("Lan", 78);
    freq.put(" sa", 4909);
    freq.put("Lah", 31);
    freq.put("Lak", 21);
    freq.put("Lag", 24);
    freq.put("Laa", 15);
    freq.put("Lab", 22);
    freq.put("Lat", 10);
    freq.put("Lau", 15);
    freq.put("you", 247);
    freq.put("yot", 18);
    freq.put("Lap", 11);
    freq.put("yor", 20);
    freq.put("Lar", 8);
    freq.put("Las", 21);
    freq.put("c ", 365);
    freq.put("gIn", 17);
    freq.put("Bry", 9);
    freq.put("La ", 16);
    freq.put("yo ", 1563);
    freq.put("Bro", 33);
    freq.put("Bri", 9);
    freq.put("Bre", 13);
    freq.put("Bra", 13);
    freq.put("mp ", 30);
    freq.put("mpe", 11);
    freq.put("mpa", 102);
    freq.put("mpo", 94);
    freq.put("mpl", 78);
    freq.put("mpi", 46);
    freq.put("mpu", 33);
    freq.put("mpr", 42);
    freq.put("YU ", 8);
    freq.put("ass", 184);
    freq.put("gTa", 22);
    freq.put("asq", 7);
    freq.put(" r ", 11);
    freq.put(" ru", 33);
    freq.put(" ry", 13);
    freq.put(" rx", 7);
    freq.put(" re", 374);
    freq.put(" rd", 8);
    freq.put(" ra", 196);
    freq.put(" ro", 104);
    freq.put(" ri", 347);
    freq.put(" rh", 26);
    freq.put("TS ", 21);
    freq.put("yJa", 17);
    freq.put("ase", 242);
    freq.put("ask", 55);
    freq.put("S ", 491);
    freq.put("sIn", 9);
    freq.put("aso", 299);
    freq.put("asm", 19);
    freq.put("asl", 42);
    freq.put("Sy", 26);
    freq.put("Ss", 9);
    freq.put("Sp", 31);
    freq.put("Sw", 37);
    freq.put("Su", 191);
    freq.put("St", 101);
    freq.put("FC ", 7);
    freq.put("Si", 430);
    freq.put("Sh", 224);
    freq.put("So", 220);
    freq.put("Sn", 11);
    freq.put("Sm", 34);
    freq.put("Sl", 23);
    freq.put("Sc", 32);
    freq.put("Sa", 875);
    freq.put("Sg", 17);
    freq.put("Se", 108);
    freq.put("duh", 12);
    freq.put("RE ", 25);
    freq.put("f ", 263);
    freq.put("hha", 150);
    freq.put("hhe", 7);
    freq.put("hhh", 158);
    freq.put("OG ", 14);
    freq.put("eg ", 56);
    freq.put("fr", 279);
    freq.put("fs", 14);
    freq.put("ft", 100);
    freq.put("fu", 91);
    freq.put("PG ", 9);
    freq.put("fy", 26);
    freq.put("fa", 274);
    freq.put("fb", 44);
    freq.put("hh ", 202);
    freq.put("fe", 374);
    freq.put("ff", 237);
    freq.put("fg", 33);
    freq.put("fh", 11);
    freq.put("fi", 296);
    freq.put("fl", 94);
    freq.put("fm", 10);
    freq.put("fo", 324);
    freq.put("a", 128012);
    freq.put("egs", 12);
    freq.put("egr", 21);
    freq.put("egu", 18);
    freq.put("wle", 8);
    freq.put("egi", 32);
    freq.put("ego", 23);
    freq.put("ega", 94);
    freq.put("CA ", 7);
    freq.put("egg", 17);
    freq.put("ege", 50);
    freq.put("ffy", 9);
    freq.put("ce ", 341);
    freq.put("y ", 5503);
    freq.put("ffo", 24);
    freq.put("ffl", 10);
    freq.put("ffi", 78);
    freq.put("fff", 9);
    freq.put("ffe", 31);
    freq.put(" On", 38);
    freq.put(" Oo", 120);
    freq.put(" Ol", 20);
    freq.put(" Om", 23);
    freq.put(" Ok", 98);
    freq.put(" Oh", 53);
    freq.put(" Of", 30);
    freq.put("if ", 26);
    freq.put(" Oy", 19);
    freq.put(" Ow", 15);
    freq.put(" Ou", 12);
    freq.put(" Or", 33);
    freq.put(" Os", 7);
    freq.put(" Op", 20);
    freq.put("yi", 133);
    freq.put("rwa", 7);
    freq.put("cee", 31);
    freq.put("ced", 15);
    freq.put("ym", 84);
    freq.put("ceb", 27);
    freq.put("yo", 2910);
    freq.put("yn", 254);
    freq.put("ya", 4498);
    freq.put("cen", 44);
    freq.put("cem", 12);
    freq.put("cel", 71);
    freq.put("ye", 504);
    freq.put("yd", 79);
    freq.put("yg", 61);
    freq.put("yf", 55);
    freq.put("yy", 400);
    freq.put(" iy", 51);
    freq.put("yz", 52);
    freq.put("ces", 77);
    freq.put("cer", 75);
    freq.put("cep", 15);
    freq.put("yp", 107);
    freq.put("ys", 281);
    freq.put("yr", 111);
    freq.put("yu", 1638);
    freq.put("yt", 90);
    freq.put("yw", 25);
    freq.put("ff ", 46);
    freq.put("yI", 11);
    freq.put("yH", 11);
    freq.put("yK", 17);
    freq.put("yJ", 23);
    freq.put("yM", 46);
    freq.put("yL", 29);
    freq.put("yO", 10);
    freq.put("yN", 12);
    freq.put("yA", 29);
    freq.put("MI ", 15);
    freq.put("yC", 20);
    freq.put("yB", 78);
    freq.put("yE", 18);
    freq.put("yD", 17);
    freq.put("yG", 32);
    freq.put("yF", 15);
    freq.put("yY", 9);
    freq.put("ife", 69);
    freq.put("iff", 13);
    freq.put("yQ", 14);
    freq.put("yP", 21);
    freq.put("yS", 22);
    freq.put("ifo", 13);
    freq.put("yT", 41);
    freq.put("yW", 8);
    freq.put("yV", 7);
    freq.put("dig", 11);
    freq.put("Ene", 9);
    freq.put("Eng", 16);
    freq.put("Enr", 13);
    freq.put("as ", 1219);
    freq.put("dib", 58);
    freq.put("pul", 35);
    freq.put("pum", 111);
    freq.put("pun", 150);
    freq.put("asp", 18);
    freq.put("puh", 10);
    freq.put("ve ", 328);
    freq.put("asu", 124);
    freq.put("ast", 327);
    freq.put("pud", 18);
    freq.put("asy", 158);
    freq.put("pua", 9);
    freq.put("pub", 10);
    freq.put("puc", 9);
    freq.put("asc", 21);
    freq.put("asa", 1409);
    freq.put("puy", 31);
    freq.put("puz", 9);
    freq.put("asd", 28);
    freq.put("put", 68);
    freq.put("asi", 675);
    freq.put("ash", 125);
    freq.put("pup", 37);
    freq.put("asn", 25);
    freq.put("pur", 65);
    freq.put("pus", 93);
    freq.put(" F ", 11);
    freq.put("asB", 8);
    freq.put("KS ", 8);
    freq.put("OY ", 97);
    freq.put("asM", 8);
    freq.put("Clo", 7);
    freq.put("Cla", 46);
    freq.put("bul", 50);
    freq.put("ImA", 7);
    freq.put("st ", 351);
    freq.put("Im ", 7);
    freq.put("nct", 8);
    freq.put("ncu", 7);
    freq.put("nch", 72);
    freq.put("nci", 53);
    freq.put("nco", 21);
    freq.put("eJu", 7);
    freq.put("nce", 253);
    freq.put("tfr", 24);
    freq.put("ste", 239);
    freq.put("stf", 24);
    freq.put("dto", 21);
    freq.put("sta", 441);
    freq.put("stl", 12);
    freq.put("stm", 16);
    freq.put("stn", 12);
    freq.put("sto", 504);
    freq.put("sth", 10);
    freq.put("sti", 183);
    freq.put("buc", 7);
    freq.put("stu", 63);
    freq.put("str", 97);
    freq.put("sts", 11);
    freq.put("dtr", 31);
    freq.put("sty", 17);
    freq.put("NiK", 8);
    freq.put("Goo", 108);
    freq.put("ka ", 2483);
    freq.put("ncy", 42);
    freq.put("God", 33);
    freq.put("Gos", 7);
    freq.put("lid", 32);
    freq.put("Nik", 14);
    freq.put("lif", 58);
    freq.put("lig", 240);
    freq.put("Nin", 8);
    freq.put("lia", 71);
    freq.put("Nil", 13);
    freq.put("lic", 125);
    freq.put("lil", 84);
    freq.put("Nic", 26);
    freq.put("lin", 734);
    freq.put("Nia", 7);
    freq.put("lih", 7);
    freq.put("Nig", 19);
    freq.put("Nie", 43);
    freq.put("lit", 498);
    freq.put("liv", 50);
    freq.put("liw", 68);
    freq.put("lip", 134);
    freq.put("liq", 7);
    freq.put("lir", 10);
    freq.put("lis", 197);
    freq.put("liz", 22);
    freq.put("kac", 13);
    freq.put("kab", 142);
    freq.put("kaa", 124);
    freq.put("kag", 129);
    freq.put("kae", 31);
    freq.put("kad", 103);
    freq.put("kak", 736);
    freq.put("kai", 453);
    freq.put("kah", 332);
    freq.put("kao", 13);
    freq.put("Go ", 22);
    freq.put("kam", 440);
    freq.put("eJa", 7);
    freq.put("kas", 1201);
    freq.put("kar", 155);
    freq.put("kap", 459);
    freq.put("kaw", 325);
    freq.put("kau", 100);
    freq.put("kat", 504);
    freq.put("rha", 17);
    freq.put("kay", 1250);
    freq.put("rhe", 15);
    freq.put("Tha", 65);
    freq.put("li ", 433);
    freq.put("bug", 15);
    freq.put("kaN", 7);
    freq.put("nca", 32);
    freq.put("aNg", 56);
    freq.put("aNa", 11);
    freq.put("aNi", 14);
    freq.put("yma", 13);
    freq.put("yme", 9);
    freq.put("ox ", 21);
    freq.put("ymo", 14);
    freq.put("ym ", 18);
    freq.put("oxo", 7);
    freq.put("x", 1140);
    freq.put("Pls", 9);
    freq.put("wow", 29);
    freq.put("wor", 82);
    freq.put("Ple", 13);
    freq.put("won", 28);
    freq.put("Pla", 16);
    freq.put("yde", 17);
    freq.put("adt", 29);
    freq.put("wo ", 13);
    freq.put("Wan", 12);
    freq.put("Wal", 245);
    freq.put("Wai", 13);
    freq.put("Wah", 19);
    freq.put("Wag", 153);
    freq.put("Waa", 10);
    freq.put("wen", 87);
    freq.put("Gon", 10);
    freq.put("Wat", 18);
    freq.put("Was", 7);
    freq.put(" t ", 649);
    freq.put(" ty", 38);
    freq.put(" tx", 7);
    freq.put(" tw", 195);
    freq.put(" tv", 17);
    freq.put(" tu", 443);
    freq.put(" tt", 11);
    freq.put(" ts", 106);
    freq.put(" tr", 213);
    freq.put("Wa ", 8);
    freq.put(" to", 619);
    freq.put(" tn", 16);
    freq.put(" tm", 7);
    freq.put(" tl", 65);
    freq.put(" ti", 545);
    freq.put(" th", 344);
    freq.put(" tg", 10);
    freq.put(" te", 230);
    freq.put(" ta", 2256);
    freq.put("iye", 16);
    freq.put("iya", 745);
    freq.put("iyo", 202);
    freq.put("iyu", 8);
    freq.put("adh", 11);
    freq.put("sKa", 11);
    freq.put("boi", 11);
    freq.put("gs ", 93);
    freq.put("lie", 81);
    freq.put("gss", 19);
    freq.put("gsu", 29);
    freq.put("gst", 19);
    freq.put("gsa", 116);
    freq.put("gse", 39);
    freq.put("lim", 133);
    freq.put("gsi", 45);
    freq.put("gsh", 10);
    freq.put("RC ", 10);
    freq.put("gso", 10);
    freq.put("lio", 14);
    freq.put("lii", 42);
    freq.put("Yve", 7);
    freq.put("hjo", 8);
    freq.put("lik", 212);
    freq.put("hjk", 18);
    freq.put("rwi", 7);
    freq.put("ee ", 338);
    freq.put("nDe", 9);
    freq.put("tut", 131);
    freq.put("eey", 44);
    freq.put("eex", 9);
    freq.put("OA ", 18);
    freq.put("eet", 261);
    freq.put("eew", 8);
    freq.put("eep", 68);
    freq.put("ees", 36);
    freq.put("eer", 31);
    freq.put("eem", 18);
    freq.put("eel", 216);
    freq.put("een", 178);
    freq.put("eeh", 18);
    freq.put("eek", 78);
    freq.put("eej", 16);
    freq.put("eee", 353);
    freq.put("eed", 38);
    freq.put("eeg", 12);
    freq.put("eea", 9);
    freq.put("eec", 16);
    freq.put("eeb", 9);
    freq.put("iAm", 10);
    freq.put("ru ", 14);
    freq.put("bg ", 8);
    freq.put(" Qu", 59);
    freq.put("Tss", 12);
    freq.put("id ", 168);
    freq.put("rui", 11);
    freq.put("run", 81);
    freq.put("rul", 14);
    freq.put("rum", 16);
    freq.put("rub", 8);
    freq.put("ruc", 7);
    freq.put("rua", 12);
    freq.put("cge", 31);
    freq.put("rue", 20);
    freq.put("ruz", 38);
    freq.put("rus", 123);
    freq.put("kal", 364);
    freq.put("rut", 9);
    freq.put("idA", 13);
    freq.put("Tho", 7);
    freq.put("idn", 12);
    freq.put("ido", 64);
    freq.put("idl", 7);
    freq.put("idi", 20);
    freq.put("idd", 9);
    freq.put("ide", 128);
    freq.put("ida", 87);
    freq.put("Eli", 8);
    freq.put("rho", 13);
    freq.put("Ell", 23);
    freq.put("Elm", 16);
    freq.put("Ele", 7);
    freq.put("aq ", 26);
    freq.put("The", 134);
    freq.put("ut ", 137);
    freq.put("aqu", 28);
    freq.put("pwe", 156);
    freq.put("pwa", 7);
    freq.put("uta", 190);
    freq.put("ute", 116);
    freq.put("uth", 14);
    freq.put("uti", 211);
    freq.put("uto", 140);
    freq.put("utr", 9);
    freq.put("uts", 10);
    freq.put("utt", 16);
    freq.put("utu", 136);
    freq.put("uty", 12);
    freq.put("naB", 35);
    freq.put("Bek", 18);
    freq.put("naK", 18);
    freq.put("Tu", 101);
    freq.put("Tr", 91);
    freq.put("Ts", 48);
    freq.put("Ice", 8);
    freq.put("naM", 15);
    freq.put("To", 127);
    freq.put("ulY", 8);
    freq.put("Th", 236);
    freq.put("Ti", 122);
    freq.put("naY", 10);
    freq.put("Ta", 546);
    freq.put("nab", 223);
    freq.put("A ", 1823);
    freq.put("naa", 232);
    freq.put("naf", 39);
    freq.put("nag", 1150);
    freq.put("nad", 84);
    freq.put("naj", 13);
    freq.put("nak", 1010);
    freq.put("nah", 219);
    freq.put("nai", 107);
    freq.put("nan", 906);
    freq.put("nao", 9);
    freq.put("nal", 544);
    freq.put("nam", 1515);
    freq.put("nar", 118);
    freq.put("nas", 354);
    freq.put("nap", 403);
    freq.put("nav", 9);
    freq.put("naw", 130);
    freq.put("nat", 587);
    freq.put("nau", 44);
    freq.put("nay", 247);
    freq.put("oon", 134);
    freq.put("tmr", 10);
    freq.put("T ", 2329);
    freq.put("Aa", 41);
    freq.put("na ", 5680);
    freq.put("Ab", 64);
    freq.put("dvi", 13);
    freq.put("Ad", 60);
    freq.put("Ag", 32);
    freq.put("Af", 18);
    freq.put("Ai", 38);
    freq.put("Ah", 77);
    freq.put("Ak", 153);
    freq.put("Am", 75);
    freq.put("Al", 195);
    freq.put("An", 1056);
    freq.put("Ap", 25);
    freq.put("As", 94);
    freq.put("Ar", 99);
    freq.put("Au", 24);
    freq.put("At", 122);
    freq.put("Aw", 68);
    freq.put("Av", 12);
    freq.put("Ay", 254);
    freq.put("gw", 128);
    freq.put("gv", 10);
    freq.put("gu", 963);
    freq.put("gt", 252);
    freq.put("Gis", 8);
    freq.put("Gir", 41);
    freq.put("gp", 372);
    freq.put("gz", 18);
    freq.put("gy", 254);
    freq.put("gg", 510);
    freq.put("gf", 28);
    freq.put("ge", 935);
    freq.put("gd", 152);
    freq.put("gc", 42);
    freq.put("gb", 191);
    freq.put("ga", 7058);
    freq.put("go", 828);
    freq.put("gn", 203);
    freq.put("gm", 193);
    freq.put("Gil", 9);
    freq.put("gk", 499);
    freq.put("gj", 21);
    freq.put("gi", 1633);
    freq.put("gh", 496);
    freq.put("Noo", 18);
    freq.put("gS", 28);
    freq.put("gR", 13);
    freq.put("gQ", 36);
    freq.put("gP", 29);
    freq.put("lke", 8);
    freq.put("gY", 10);
    freq.put("lka", 16);
    freq.put("gG", 9);
    freq.put("gF", 9);
    freq.put("gD", 29);
    freq.put("gC", 10);
    freq.put("gB", 28);
    freq.put("gA", 24);
    freq.put("Not", 7);
    freq.put("gN", 36);
    freq.put("gM", 19);
    freq.put("gL", 17);
    freq.put("gK", 12);
    freq.put("gJ", 9);
    freq.put("gI", 23);
    freq.put("gH", 16);
    freq.put("rtn", 10);
    freq.put("g ", 20389);
    freq.put("nnn", 58);
    freq.put("hi ", 123);
    freq.put("No ", 19);
    freq.put("lk ", 33);
    freq.put("Spa", 9);
    freq.put("nnm", 9);
    freq.put("zl", 19);
    freq.put("zm", 21);
    freq.put("zn", 7);
    freq.put("zo", 67);
    freq.put("zh", 13);
    freq.put("zi", 74);
    freq.put("oz ", 8);
    freq.put("zk", 38);
    freq.put("zd", 9);
    freq.put("ze", 120);
    freq.put("za", 209);
    freq.put("zb", 10);
    freq.put("zx", 7);
    freq.put("zy", 40);
    freq.put("zz", 152);
    freq.put("zt", 11);
    freq.put("zu", 16);
    freq.put("zv", 7);
    freq.put("zr", 13);
    freq.put("zs", 11);
    freq.put("zM", 8);
    freq.put("Ah ", 19);
    freq.put("zA", 9);
    freq.put("zC", 7);
    freq.put("ych", 22);
    freq.put("yco", 11);
    freq.put("yca", 11);
    freq.put("yce", 24);
    freq.put("oze", 7);
    freq.put("ull", 49);
    freq.put("oza", 16);
    freq.put("z ", 394);
    freq.put("Aha", 30);
    freq.put("Ahh", 18);
    freq.put("iep", 15);
    freq.put("wig", 9);
    freq.put("wif", 22);
    freq.put("wid", 7);
    freq.put("wia", 11);
    freq.put("win", 191);
    freq.put("wim", 16);
    freq.put("wil", 33);
    freq.put("wii", 10);
    freq.put("iet", 33);
    freq.put("wit", 194);
    freq.put("wis", 57);
    freq.put("wiy", 8);
    freq.put("Jh", 27);
    freq.put("Ji", 26);
    freq.put("JS ", 8);
    freq.put("wi ", 127);
    freq.put("ien", 239);
    freq.put("ied", 19);
    freq.put("ief", 13);
    freq.put("rt ", 194);
    freq.put(" va", 28);
    freq.put(" ve", 29);
    freq.put(" vi", 188);
    freq.put(" vo", 23);
    freq.put(" vs", 11);
    freq.put("HI ", 11);
    freq.put(" v ", 10);
    freq.put("hic", 84);
    freq.put("TO ", 75);
    freq.put("sMo", 10);
    freq.put("sMe", 15);
    freq.put("sMa", 12);
    freq.put("bin", 182);
    freq.put("RA ", 51);
    freq.put("EG ", 7);
    freq.put("map", 110);
    freq.put("hlo", 14);
    freq.put("hli", 9);
    freq.put("hle", 23);
    freq.put("hla", 12);
    freq.put("max", 12);
    freq.put("ece", 17);
    freq.put("eca", 39);
    freq.put("CE ", 29);
    freq.put("eco", 37);
    freq.put("eck", 45);
    freq.put("eci", 35);
    freq.put("ech", 74);
    freq.put("ecu", 17);
    freq.put("ect", 141);
    freq.put("ecs", 8);
    freq.put("ecr", 19);
    freq.put("rs ", 224);
    freq.put("cy ", 37);
    freq.put("AN ", 241);
    freq.put(" Sy", 17);
    freq.put(" Sp", 21);
    freq.put(" Sw", 23);
    freq.put(" St", 79);
    freq.put(" Su", 157);
    freq.put(" Sk", 7);
    freq.put(" Sh", 180);
    freq.put(" Si", 373);
    freq.put(" Sn", 7);
    freq.put(" So", 181);
    freq.put(" Sl", 16);
    freq.put(" Sm", 22);
    freq.put(" Sc", 18);
    freq.put(" Sa", 767);
    freq.put(" Sg", 16);
    freq.put(" Se", 83);
    freq.put("rsl", 9);
    freq.put("cyr", 7);
    freq.put("rso", 27);
    freq.put("rsh", 12);
    freq.put("rsi", 22);
    freq.put("rse", 41);
    freq.put("rsa", 17);
    freq.put("R", 2566);
    freq.put("rst", 78);
    freq.put("lPa", 9);
    freq.put("rss", 8);
    freq.put("bek", 11);
    freq.put("beh", 14);
    freq.put("ben", 59);
    freq.put("bel", 87);
    freq.put("beb", 43);
    freq.put("bec", 10);
    freq.put("bea", 37);
    freq.put("beg", 7);
    freq.put("bed", 11);
    freq.put("bee", 37);
    freq.put("bey", 28);
    freq.put("tG", 10);
    freq.put("ber", 134);
    freq.put("bes", 101);
    freq.put(" S ", 28);
    freq.put("bet", 38);
    freq.put("py ", 79);
    freq.put("aw ", 976);
    freq.put("ur ", 50);
    freq.put("arm", 67);
    freq.put("BA ", 61);
    freq.put("aww", 28);
    freq.put("awt", 7);
    freq.put("aws", 7);
    freq.put("gPa", 10);
    freq.put("awo", 15);
    freq.put("awn", 18);
    freq.put("awk", 10);
    freq.put("awi", 185);
    freq.put("pya", 11);
    freq.put("awe", 28);
    freq.put("pye", 7);
    freq.put("awa", 993);
    freq.put("urd", 15);
    freq.put("ure", 208);
    freq.put("urg", 14);
    freq.put("ura", 130);
    freq.put("url", 9);
    freq.put("urn", 19);
    freq.put("uro", 163);
    freq.put("uri", 45);
    freq.put("urk", 9);
    freq.put("urt", 32);
    freq.put("uru", 16);
    freq.put("urp", 13);
    freq.put("urr", 16);
    freq.put("urs", 46);
    freq.put("bun", 37);
    freq.put("ury", 8);
    freq.put("ngD", 27);
    freq.put("ngG", 9);
    freq.put("ngA", 10);
    freq.put("ngB", 15);
    freq.put("ngC", 8);
    freq.put("ngL", 11);
    freq.put("ngM", 12);
    freq.put("ngN", 30);
    freq.put("ngH", 14);
    freq.put("ngI", 19);
    freq.put("ngK", 9);
    freq.put("ngT", 9);
    freq.put("ngP", 20);
    freq.put("ngS", 14);
    freq.put("ngY", 9);
    freq.put("Nga", 170);
    freq.put("ngd", 15);
    freq.put("nge", 282);
    freq.put("ngg", 343);
    freq.put("nga", 1962);
    freq.put("ngb", 20);
    freq.put("ngc", 9);
    freq.put("ngl", 86);
    freq.put("ngm", 22);
    freq.put("ngn", 37);
    freq.put("ngo", 97);
    freq.put("ngh", 72);
    freq.put("ngi", 369);
    freq.put("ngj", 10);
    freq.put("ngk", 124);
    freq.put("sh ", 237);
    freq.put("ngu", 70);
    freq.put("ngw", 9);
    freq.put("ngp", 16);
    freq.put("bud", 13);
    freq.put("ngr", 42);
    freq.put("ngs", 99);
    freq.put("ngy", 96);
    freq.put("mga", 844);
    freq.put("mgi", 10);
    freq.put("eFo", 10);
    freq.put("tba", 23);
    freq.put("sht", 24);
    freq.put("shu", 27);
    freq.put("shy", 10);
    freq.put("sha", 157);
    freq.put("she", 87);
    freq.put("dpa", 9);
    freq.put("shh", 14);
    freq.put("shi", 159);
    freq.put("shl", 12);
    freq.put("shm", 7);
    freq.put("sho", 114);
    freq.put("ke ", 244);
    freq.put("lup", 19);
    freq.put("lur", 15);
    freq.put("lus", 42);
    freq.put("lut", 31);
    freq.put("luu", 7);
    freq.put("luw", 10);
    freq.put("luy", 12);
    freq.put("lub", 32);
    freq.put("luc", 44);
    freq.put("lue", 30);
    freq.put("lug", 29);
    freq.put("luh", 27);
    freq.put("lui", 15);
    freq.put("luk", 10);
    freq.put("lul", 39);
    freq.put("lum", 111);
    freq.put("lun", 77);
    freq.put("ken", 111);
    freq.put("kem", 10);
    freq.put("kel", 58);
    freq.put("kei", 13);
    freq.put("kee", 33);
    freq.put("ked", 10);
    freq.put("Mga", 94);
    freq.put("kea", 18);
    freq.put("iEl", 11);
    freq.put("key", 25);
    freq.put("kev", 14);
    freq.put("ket", 76);
    freq.put("kes", 59);
    freq.put("ker", 41);
    freq.put("lu ", 14);
    freq.put("ot ", 435);
    freq.put("Loo", 11);
    freq.put("Lol", 88);
    freq.put("Lor", 22);
    freq.put("Lov", 91);
    freq.put("Lou", 15);
    freq.put("yaA", 32);
    freq.put("iny", 93);
    freq.put("yay", 58);
    freq.put("yat", 90);
    freq.put("yaw", 178);
    freq.put("yap", 10);
    freq.put("yas", 17);
    freq.put("yar", 95);
    freq.put("yam", 48);
    freq.put("yal", 31);
    freq.put("yan", 1396);
    freq.put("yai", 11);
    freq.put("yah", 58);
    freq.put("yak", 104);
    freq.put("yad", 88);
    freq.put("yag", 43);
    freq.put("yaa", 79);
    freq.put("yac", 11);
    freq.put("yab", 26);
    freq.put("oth", 53);
    freq.put("oti", 39);
    freq.put("oto", 147);
    freq.put("ota", 70);
    freq.put("ote", 166);
    freq.put("ots", 31);
    freq.put("ott", 19);
    freq.put("And", 69);
    freq.put("Ang", 655);
    freq.put("Ana", 24);
    freq.put("Ann", 46);
    freq.put("Ano", 159);
    freq.put("Ant", 31);
    freq.put("Anu", 23);
    freq.put(" il", 169);
    freq.put("Ans", 10);
    freq.put("Any", 13);
    freq.put("Yon", 10);
    freq.put("You", 69);
    freq.put("wkw", 8);
    freq.put("zy ", 21);
    freq.put("i", 41583);
    freq.put("ksi", 32);
    freq.put(" xD", 135);
    freq.put("Be", 167);
    freq.put(" xi", 8);
    freq.put("Ba", 730);
    freq.put("Bb", 11);
    freq.put("Bl", 58);
    freq.put(" xa", 19);
    freq.put("Bo", 163);
    freq.put("Bh", 8);
    freq.put("Bi", 178);
    freq.put("Bk", 8);
    freq.put("Bu", 200);
    freq.put("Bw", 23);
    freq.put("Br", 89);
    freq.put("By", 13);
    freq.put(" xt", 9);
    freq.put("B ", 158);
    freq.put(" x ", 52);
    freq.put("GS ", 12);
    freq.put("TI ", 27);
    freq.put("yLo", 10);
    freq.put("U ", 96);
    freq.put("ubr", 9);
    freq.put("?", 258);
    freq.put("swi", 28);
    freq.put("Uy", 28);
    freq.put("RO ", 26);
    freq.put("Ut", 14);
    freq.put("Uw", 10);
    freq.put("Up", 24);
    freq.put("Us", 21);
    freq.put("Ur", 9);
    freq.put("Um", 41);
    freq.put("Ul", 17);
    freq.put("Un", 81);
    freq.put("Uh", 18);
    freq.put("Ug", 7);
    freq.put("LL ", 19);
    freq.put("dum", 38);
    freq.put("swo", 7);
    freq.put("swa", 10);
    freq.put("EE ", 20);
    freq.put("py", 140);
    freq.put("swe", 69);
    freq.put("h ", 2593);
    freq.put("eah", 38);
    freq.put("eak", 62);
    freq.put("hy", 129);
    freq.put("eam", 81);
    freq.put("eal", 66);
    freq.put("ean", 152);
    freq.put("eaa", 26);
    freq.put("hs", 46);
    freq.put("eac", 55);
    freq.put("eab", 12);
    freq.put("hv", 7);
    freq.put("ead", 59);
    freq.put("eag", 10);
    freq.put("hu", 575);
    freq.put("hj", 42);
    freq.put("hk", 20);
    freq.put("hh", 562);
    freq.put("hi", 2854);
    freq.put("PM ", 17);
    freq.put("ho", 1026);
    freq.put("hl", 74);
    freq.put("hm", 90);
    freq.put("hb", 24);
    freq.put("eap", 12);
    freq.put("eas", 121);
    freq.put("ear", 219);
    freq.put("eau", 20);
    freq.put("eat", 71);
    freq.put("hd", 49);
    freq.put("he", 1688);
    freq.put("dma", 8);
    freq.put("hR", 10);
    freq.put("pn", 39);
    freq.put("hP", 9);
    freq.put("dmo", 16);
    freq.put("hJ", 8);
    freq.put("te", 2313);
    freq.put("hN", 47);
    freq.put("hO", 7);
    freq.put("hM", 24);
    freq.put("hB", 14);
    freq.put("hC", 9);
    freq.put("hA", 17);
    freq.put("hF", 7);
    freq.put("hG", 11);
    freq.put("ID ", 9);
    freq.put("hE", 7);
    freq.put("hn ", 33);
    freq.put(" Uy", 24);
    freq.put(" Ut", 9);
    freq.put(" Uu", 7);
    freq.put(" Uw", 8);
    freq.put(" Up", 11);
    freq.put("lRo", 9);
    freq.put(" Us", 17);
    freq.put(" Ul", 14);
    freq.put(" Um", 39);
    freq.put(" Un", 64);
    freq.put(" Uh", 11);
    freq.put("Lun", 10);
    freq.put("rqu", 13);
    freq.put("ile", 118);
    freq.put("N", 2495);
    freq.put("hnd", 45);
    freq.put("hni", 11);
    freq.put("hnn", 7);
    freq.put(" U ", 14);
    freq.put("Ehh", 7);
    freq.put("aub", 25);
    freq.put("aud", 25);
    freq.put("aug", 27);
    freq.put("aum", 11);
    freq.put("aul", 77);
    freq.put("up ", 92);
    freq.put("aun", 79);
    freq.put("aup", 13);
    freq.put("aus", 90);
    freq.put("aur", 30);
    freq.put("auu", 22);
    freq.put("aut", 62);
    freq.put("auw", 31);
    freq.put("aux", 7);
    freq.put("BY ", 7);
    freq.put("ble", 173);
    freq.put("Eh ", 65);
    freq.put("upo", 28);
    freq.put("upl", 31);
    freq.put("upi", 23);
    freq.put("bla", 52);
    freq.put("upd", 12);
    freq.put("upe", 146);
    freq.put("upc", 7);
    freq.put("upa", 44);
    freq.put("oSi", 16);
    freq.put("Hha", 7);
    freq.put("upu", 51);
    freq.put("ups", 8);
    freq.put("upp", 19);
    freq.put("me ", 445);
    freq.put("neP", 10);
    freq.put("nen", 27);
    freq.put("Pum", 9);
    freq.put("Pun", 28);
    freq.put("eDa", 7);
    freq.put("nek", 7);
    freq.put("neh", 8);
    freq.put("nei", 12);
    freq.put("neg", 12);
    freq.put("ned", 38);
    freq.put("nee", 60);
    freq.put("neb", 36);
    freq.put("nec", 34);
    freq.put("nea", 31);
    freq.put("nez", 9);
    freq.put("nex", 64);
    freq.put("ney", 41);
    freq.put("Put", 22);
    freq.put("new", 46);
    freq.put("net", 127);
    freq.put("ner", 97);
    freq.put("nes", 195);
    freq.put("Pur", 21);
    freq.put("Pus", 13);
    freq.put("mee", 34);
    freq.put("med", 62);
    freq.put("meg", 17);
    freq.put("mea", 55);
    freq.put("mec", 9);
    freq.put("meb", 7);
    freq.put("mem", 39);
    freq.put("mel", 51);
    freq.put("meo", 11);
    freq.put("men", 206);
    freq.put("mei", 20);
    freq.put("meh", 17);
    freq.put("mek", 11);
    freq.put("mej", 18);
    freq.put("met", 28);
    freq.put("mew", 9);
    freq.put("mep", 11);
    freq.put("mes", 96);
    freq.put("mer", 191);
    freq.put("dru", 7);
    freq.put("ne ", 460);
    freq.put("sju", 7);
    freq.put("dri", 57);
    freq.put("dro", 21);
    freq.put("dra", 60);
    freq.put("dre", 78);
    freq.put("Tit", 18);
    freq.put("lwa", 18);
    freq.put("Ste", 15);
    freq.put("Sta", 28);
    freq.put("Sto", 10);
    freq.put("Sti", 8);
    freq.put("Str", 12);
    freq.put("V", 291);
    freq.put("Sty", 18);
    freq.put("Tim", 14);
    freq.put("Tin", 42);
    freq.put("Lie", 7);
    freq.put("Lif", 9);
    freq.put("Lig", 11);
    freq.put("Lia", 11);
    freq.put("Lib", 14);
    freq.put("Lil", 10);
    freq.put("Lim", 19);
    freq.put("Lin", 32);
    freq.put("ygi", 11);
    freq.put("Lik", 11);
    freq.put("Lit", 13);
    freq.put("ov ", 12);
    freq.put("Liz", 8);
    freq.put("Kab", 20);
    freq.put("Tig", 8);
    freq.put("Kag", 12);
    freq.put("Kad", 10);
    freq.put("Kak", 31);
    freq.put("Kai", 78);
    freq.put("Kah", 78);
    freq.put("Kan", 29);
    freq.put("Kam", 34);
    freq.put("Kal", 37);
    freq.put("Kas", 135);
    freq.put("Kar", 38);
    freq.put("Kap", 102);
    freq.put("Kaw", 14);
    freq.put("Kat", 155);
    freq.put("Kay", 153);
    freq.put("aPa", 35);
    freq.put("yg ", 14);
    freq.put("ova", 13);
    freq.put("ove", 460);
    freq.put("ovi", 46);
    freq.put("All", 25);
    freq.put("Ka ", 33);
    freq.put("Ali", 12);
    freq.put("Ale", 16);
    freq.put("Ala", 95);
    freq.put("Aly", 11);
    freq.put("Wow", 21);
    freq.put("Wor", 12);
    freq.put("Woo", 14);
    freq.put("Won", 7);
    freq.put("SS ", 37);
    freq.put(" zo", 8);
    freq.put("DL ", 11);
    freq.put(" zi", 10);
    freq.put(" za", 13);
    freq.put("is ", 451);
    freq.put("isS", 7);
    freq.put("isT", 10);
    freq.put("isM", 8);
    freq.put("isy", 23);
    freq.put("iss", 336);
    freq.put("isp", 18);
    freq.put(" z ", 10);
    freq.put("isu", 28);
    freq.put("ist", 342);
    freq.put("isk", 9);
    freq.put("isi", 344);
    freq.put("ish", 150);
    freq.put("iso", 57);
    freq.put("isn", 15);
    freq.put("ism", 63);
    freq.put("isl", 12);
    freq.put("isc", 36);
    freq.put("isa", 445);
    freq.put("ise", 108);
    freq.put("gy ", 36);
    freq.put("yBu", 10);
    freq.put("yBi", 9);
    freq.put("yBo", 10);
    freq.put("yBa", 39);
    freq.put("eu", 52);
    freq.put("BB ", 32);
    freq.put("Coo", 10);
    freq.put("gya", 149);
    freq.put("gyo", 30);
    freq.put("gyn", 7);
    freq.put("gym", 10);
    freq.put("oNa", 11);
    freq.put("uka", 356);
    freq.put("ty ", 156);
    freq.put("do ", 299);
    freq.put("tyl", 34);
    freq.put("tym", 7);
    freq.put("tyo", 16);
    freq.put("tya", 20);
    freq.put("CY ", 11);
    freq.put("typ", 12);
    freq.put("PO ", 30);
    freq.put("dok", 13);
    freq.put("don", 110);
    freq.put("doo", 42);
    freq.put("dol", 43);
    freq.put("dom", 31);
    freq.put("doc", 11);
    freq.put("m", 22120);
    freq.put("dog", 19);
    freq.put("doy", 10);
    freq.put("dor", 48);
    freq.put("dos", 8);
    freq.put("dow", 35);
    freq.put("dot", 16);
    freq.put("sAt", 11);
    freq.put(" We", 50);
    freq.put(" Wa", 475);
    freq.put(" Wo", 55);
    freq.put(" Wh", 55);
    freq.put(" Wi", 45);
    freq.put(" Wt", 7);
    freq.put("ba ", 1071);
    freq.put(" W ", 7);
    freq.put("AW ", 43);
    freq.put("baw", 103);
    freq.put("bat", 196);
    freq.put("bau", 30);
    freq.put("bar", 60);
    freq.put("bas", 361);
    freq.put("bay", 196);
    freq.put("bag", 345);
    freq.put("bad", 82);
    freq.put("bae", 126);
    freq.put("bab", 371);
    freq.put("bac", 61);
    freq.put("baa", 24);
    freq.put("ban", 454);
    freq.put("bao", 28);
    freq.put("bal", 296);
    freq.put("bam", 15);
    freq.put("bak", 313);
    freq.put("bah", 203);
    freq.put("bai", 46);
    freq.put("om ", 184);
    freq.put("un ", 927);
    freq.put("Rus", 7);
    freq.put("omb", 21);
    freq.put("C", 1051);
    freq.put("omg", 35);
    freq.put("omf", 11);
    freq.put("ome", 178);
    freq.put("omi", 79);
    freq.put("omo", 52);
    freq.put("omm", 69);
    freq.put("oms", 8);
    freq.put("omp", 45);
    freq.put("uns", 26);
    freq.put("unt", 274);
    freq.put("unu", 31);
    freq.put("unw", 18);
    freq.put("uny", 15);
    freq.put("una", 350);
    freq.put("unc", 45);
    freq.put("und", 147);
    freq.put("une", 32);
    freq.put("unf", 23);
    freq.put("ung", 2937);
    freq.put("uni", 69);
    freq.put("unl", 17);
    freq.put("unn", 31);
    freq.put("uno", 137);
    freq.put("eBe", 7);
    freq.put("eBa", 14);
    freq.put("C ", 107);
    freq.put("Pwe", 29);
    freq.put("eBr", 8);
    freq.put("mch", 8);
    freq.put("mce", 7);
    freq.put("mca", 9);
    freq.put("wde", 10);
    freq.put("Ci", 19);
    freq.put("Ch", 264);
    freq.put("Co", 132);
    freq.put("sly", 15);
    freq.put("Cl", 70);
    freq.put("Ca", 143);
    freq.put("Ce", 47);
    freq.put("Cy", 7);
    freq.put("slo", 15);
    freq.put("sli", 19);
    freq.put("sle", 34);
    freq.put("sla", 63);
    freq.put("Cu", 31);
    freq.put("Nab", 16);
    freq.put("ix", 75);
    freq.put("Naa", 26);
    freq.put("Nag", 171);
    freq.put("iq", 40);
    freq.put("ip", 825);
    freq.put("Nah", 18);
    freq.put("ir", 1060);
    freq.put("Nan", 94);
    freq.put("it", 3999);
    freq.put("iw", 266);
    freq.put("iv", 247);
    freq.put("Nar", 13);
    freq.put("Nas", 73);
    freq.put("Nap", 34);
    freq.put("ij", 40);
    freq.put("im", 1115);
    freq.put("il", 2718);
    freq.put("Nat", 47);
    freq.put("Nau", 14);
    freq.put("ia", 1111);
    freq.put("ic", 1298);
    freq.put("ib", 812);
    freq.put("ie", 1200);
    freq.put("id", 551);
    freq.put("ig", 1660);
    freq.put("if", 217);
    freq.put("V ", 114);
    freq.put("iX", 7);
    freq.put("iP", 19);
    freq.put("iS", 28);
    freq.put("iR", 11);
    freq.put("iT", 20);
    freq.put("iV", 12);
    freq.put("iK", 29);
    freq.put("iJ", 30);
    freq.put("iM", 28);
    freq.put("iL", 26);
    freq.put("iO", 9);
    freq.put("iN", 28);
    freq.put("iA", 24);
    freq.put("iC", 17);
    freq.put("iB", 18);
    freq.put("iE", 16);
    freq.put("iD", 23);
    freq.put("iG", 17);
    freq.put("iF", 14);
    freq.put("Na ", 53);
    freq.put("kis", 56);
    freq.put("kir", 31);
    freq.put("kip", 41);
    freq.put("kit", 957);
    freq.put("kik", 116);
    freq.put("kii", 14);
    freq.put("kin", 581);
    freq.put("kim", 64);
    freq.put("kil", 197);
    freq.put("kic", 7);
    freq.put("i ", 6589);
    freq.put("kia", 18);
    freq.put("kie", 36);
    freq.put("kid", 27);
    freq.put("Va", 29);
    freq.put("Ve", 32);
    freq.put("Vh", 9);
    freq.put("Vi", 74);
    freq.put("Vo", 30);
    freq.put("hMa", 7);
    freq.put("nk ", 77);
    freq.put("yem", 38);
    freq.put("yel", 30);
    freq.put("yeo", 13);
    freq.put("Jes", 20);
    freq.put("yea", 84);
    freq.put("yeb", 11);
    freq.put("yee", 20);
    freq.put("yed", 7);
    freq.put("yey", 15);
    freq.put("op ", 101);
    freq.put("yep", 13);
    freq.put("yes", 74);
    freq.put("yer", 38);
    freq.put("yet", 22);
    freq.put("aVi", 7);
    freq.put("opu", 7);
    freq.put("opp", 34);
    freq.put("opr", 7);
    freq.put("ops", 15);
    freq.put("ye ", 67);
    freq.put("opy", 21);
    freq.put("ope", 58);
    freq.put("opa", 27);
    freq.put("opl", 8);
    freq.put("opo", 48);
    freq.put("oph", 14);
    freq.put("opi", 48);
    freq.put("Art", 11);
    freq.put("eez", 12);
    freq.put("Ara", 27);
    freq.put("Are", 9);
    freq.put("Ari", 13);
    freq.put("www", 51);
    freq.put("Jel", 8);
    freq.put("ww ", 62);
    freq.put("TE ", 23);
    freq.put("Z", 94);
    freq.put("iqu", 33);
    freq.put("fs ", 10);
    freq.put("Ko ", 17);
    freq.put("EA ", 9);
    freq.put("Wif", 8);
    freq.put("Win", 7);
    freq.put("Wil", 19);
    freq.put("Wik", 7);
    freq.put("Wit", 15);
    freq.put("Wis", 8);
    freq.put("nky", 15);
    freq.put("di ", 1698);
    freq.put("aDr", 33);
    freq.put("eru", 13);
    freq.put("jha", 13);
    freq.put("dim", 8);
    freq.put("din", 617);
    freq.put("dio", 21);
    freq.put("jhe", 14);
    freq.put("dii", 12);
    freq.put("dik", 32);
    freq.put("did", 25);
    freq.put("die", 42);
    freq.put("ers", 230);
    freq.put("dia", 78);
    freq.put("jho", 10);
    freq.put("dic", 24);
    freq.put("diy", 28);
    freq.put("dit", 231);
    freq.put("mNa", 7);
    freq.put("div", 9);
    freq.put("dir", 34);
    freq.put("dis", 48);
    freq.put(" Yi", 10);
    freq.put(" Yo", 61);
    freq.put(" Ya", 90);
    freq.put(" Ye", 73);
    freq.put("ery", 122);
    freq.put("Gre", 27);
    freq.put("Gra", 79);
    freq.put(" Yu", 515);
    freq.put("tne", 25);
    freq.put("AM ", 36);
    freq.put("bo ", 75);
    freq.put("tna", 22);
    freq.put("DS ", 11);
    freq.put(" Y ", 11);
    freq.put("box", 12);
    freq.put("boy", 78);
    freq.put("tni", 7);
    freq.put("bor", 58);
    freq.put("bos", 86);
    freq.put("bot", 80);
    freq.put("bou", 26);
    freq.put("bow", 9);
    freq.put("Wo", 61);
    freq.put("bok", 13);
    freq.put("bol", 33);
    freq.put("bon", 107);
    freq.put("boo", 83);
    freq.put("bob", 49);
    freq.put("erk", 16);
    freq.put("bod", 13);
    freq.put("bog", 37);
    freq.put("ayM", 14);
    freq.put("oo ", 394);
    freq.put("ayF", 7);
    freq.put("ayB", 45);
    freq.put("ayT", 12);
    freq.put("aym", 17);
    freq.put("ayl", 40);
    freq.put("ayo", 1632);
    freq.put("ayn", 44);
    freq.put("ayi", 58);
    freq.put("ayk", 9);
    freq.put("aye", 80);
    freq.put("ayd", 16);
    freq.put("ayg", 15);
    freq.put("aya", 1482);
    freq.put("ayc", 13);
    freq.put("ayb", 26);
    freq.put("ayy", 58);
    freq.put("ayz", 7);
    freq.put("ayu", 69);
    freq.put("ayt", 18);
    freq.put("ul ", 64);
    freq.put("ayp", 19);
    freq.put("ays", 95);
    freq.put("ayr", 17);
    freq.put("ood", 325);
    freq.put("oog", 11);
    freq.put("oof", 13);
    freq.put("Ben", 18);
    freq.put("Bel", 14);
    freq.put("oob", 44);
    freq.put("oom", 45);
    freq.put("ool", 120);
    freq.put("ooo", 333);
    freq.put("Bea", 28);
    freq.put("ooh", 21);
    freq.put("ook", 111);
    freq.put("oot", 45);
    freq.put("oop", 12);
    freq.put("oos", 18);
    freq.put("oor", 42);
    freq.put("Ber", 20);
    freq.put("Bes", 18);
    freq.put("ooy", 14);
    freq.put("Bet", 11);
    freq.put("fly", 10);
    freq.put("uly", 13);
    freq.put("aMo", 12);
    freq.put("ay ", 3206);
    freq.put("ult", 30);
    freq.put("ulu", 70);
    freq.put("fli", 20);
    freq.put("uli", 339);
    freq.put("ulo", 482);
    freq.put("flo", 39);
    freq.put("fla", 15);
    freq.put("ula", 393);
    freq.put("ule", 42);
    freq.put("ma ", 638);
    freq.put("nyy", 7);
    freq.put("nyw", 8);
    freq.put("nyt", 20);
    freq.put("nyo", 277);
    freq.put("nya", 513);
    freq.put("nye", 21);
    freq.put("sng", 14);
    freq.put("mas", 587);
    freq.put("mar", 380);
    freq.put("mau", 36);
    freq.put("mat", 544);
    freq.put("maw", 81);
    freq.put("sna", 43);
    freq.put("may", 955);
    freq.put("sno", 22);
    freq.put("maz", 20);
    freq.put("sni", 7);
    freq.put("maa", 146);
    freq.put("mac", 43);
    freq.put("mab", 176);
    freq.put("mae", 45);
    freq.put("mad", 205);
    freq.put("mag", 1586);
    freq.put("mai", 171);
    freq.put("mah", 398);
    freq.put("mak", 471);
    freq.put("maj", 13);
    freq.put("mam", 319);
    freq.put("mal", 530);
    freq.put("mao", 19);
    freq.put("man", 2083);
    freq.put("maS", 16);
    freq.put("Edi", 16);
    freq.put("q", 404);
    freq.put("ny ", 70);
    freq.put("lse", 13);
    freq.put("gee", 21);
    freq.put("lsa", 8);
    freq.put("lso", 7);
    freq.put("lss", 12);
    freq.put("kk ", 12);
    freq.put(" aa", 124);
    freq.put(" ab", 105);
    freq.put(" ac", 71);
    freq.put(" ad", 78);
    freq.put(" ae", 11);
    freq.put(" af", 31);
    freq.put(" ag", 195);
    freq.put(" ah", 313);
    freq.put(" ai", 66);
    freq.put(" aj", 10);
    freq.put(" ak", 2494);
    freq.put(" al", 462);
    freq.put(" am", 150);
    freq.put(" an", 2913);
    freq.put(" ap", 81);
    freq.put(" aq", 35);
    freq.put(" ar", 242);
    freq.put(" as", 170);
    freq.put(" at", 760);
    freq.put(" au", 31);
    freq.put(" av", 11);
    freq.put(" aw", 111);
    freq.put(" ay", 529);
    freq.put("Ng ", 19);
    freq.put("Shu", 25);
    freq.put("ls ", 128);
    freq.put("Sha", 48);
    freq.put("kki", 19);
    freq.put("She", 32);
    freq.put("kkk", 13);
    freq.put("😭", 27);
    freq.put("Shi", 73);
    freq.put("kka", 23);
    freq.put("Sho", 32);
    freq.put(" a ", 93);
    freq.put("😁", 13);
    freq.put("😂", 51);
    freq.put("😍", 8);
    freq.put("😊", 13);
    freq.put("aTa", 11);
    freq.put("aTw", 8);
    freq.put("Luc", 7);
    freq.put("Lum", 10);
    freq.put("or ", 312);
    freq.put("Ken", 18);
    freq.put("Kel", 20);
    freq.put("Kev", 16);

    init3();
  }
  private static void init3() {
    
    freq.put("Ker", 9);
    freq.put("RT ", 1876);
    freq.put("G", 1462);
    freq.put("ory", 41);
    freq.put("ort", 143);
    freq.put("orr", 178);
    freq.put("ors", 30);
    freq.put("orp", 8);
    freq.put("orn", 113);
    freq.put("oro", 19);
    freq.put("orl", 25);
    freq.put("orm", 69);
    freq.put("ork", 73);
    freq.put("ori", 156);
    freq.put("org", 21);
    freq.put("ord", 76);
    freq.put("ore", 177);
    freq.put("orb", 11);
    freq.put("ora", 162);
    freq.put("Apr", 9);
    freq.put("orP", 9);
    freq.put("orM", 7);
    freq.put("orK", 7);
    freq.put("orD", 7);
    freq.put("Yay", 15);
    freq.put("Yan", 71);
    freq.put("ua ", 25);
    freq.put("Yaa", 13);
    freq.put("IS ", 40);
    freq.put("iw ", 48);
    freq.put("Do", 118);
    freq.put("Dm", 7);
    freq.put("Dj", 13);
    freq.put("Di", 383);
    freq.put("De", 128);
    freq.put("Da", 354);
    freq.put("Dy", 18);
    freq.put("Dw", 7);
    freq.put("Du", 20);
    freq.put("Dr", 124);
    freq.put("iwa", 194);
    freq.put("iwo", 7);
    freq.put("rFo", 7);
    freq.put("D ", 595);
    freq.put("imC", 7);
    freq.put("ge ", 372);
    freq.put("We", 63);
    freq.put("Wa", 499);
    freq.put("HA ", 502);
    freq.put("Wi", 73);
    freq.put("Wh", 63);
    freq.put("Wt", 8);
    freq.put("Wr", 7);
    freq.put("ges", 31);
    freq.put("ger", 108);
    freq.put("get", 99);
    freq.put(" 😁", 8);
    freq.put(" 😂", 23);
    freq.put("geh", 8);
    freq.put("geo", 9);
    freq.put("gen", 68);
    freq.put(" 😊", 10);
    freq.put("gel", 155);
    freq.put("W ", 122);
    freq.put(" 😭", 11);
    freq.put("tu ", 9);
    freq.put("j ", 74);
    freq.put("ain", 484);
    freq.put("tup", 16);
    freq.put("CH ", 10);
    freq.put("jt", 8);
    freq.put("ju", 156);
    freq.put("tur", 143);
    freq.put("tus", 21);
    freq.put("jp", 12);
    freq.put("jr", 12);
    freq.put("js", 15);
    freq.put("jl", 9);
    freq.put("jm", 28);
    freq.put("jn", 8);
    freq.put("jo", 359);
    freq.put("jh", 42);
    freq.put("ji", 63);
    freq.put("jj", 12);
    freq.put("jk", 69);
    freq.put("jd", 8);
    freq.put("je", 236);
    freq.put("tub", 34);
    freq.put("tuw", 49);
    freq.put("tud", 46);
    freq.put("ja", 351);
    freq.put("jb", 8);
    freq.put("jc", 14);
    freq.put("tuh", 21);
    freq.put("tui", 9);
    freq.put("jR", 7);
    freq.put("tuk", 20);
    freq.put("tul", 374);
    freq.put("tum", 109);
    freq.put("tun", 129);
    freq.put("rLa", 15);
    freq.put("cla", 95);
    freq.put("tua", 22);
    freq.put("Ty", 14);
    freq.put("Tw", 61);
    freq.put("tug", 18);
    freq.put("cqu", 7);
    freq.put("naS", 12);
    freq.put("hda", 31);
    freq.put("oi ", 36);
    freq.put("paJ", 10);
    freq.put("pap", 385);
    freq.put("par", 805);
    freq.put("Te", 128);
    freq.put("pat", 493);
    freq.put("pau", 67);
    freq.put("paw", 11);
    freq.put("pay", 78);
    freq.put("s", 27529);
    freq.put("paa", 77);
    freq.put("pab", 34);
    freq.put("pac", 29);
    freq.put("pad", 116);
    freq.put("pag", 1255);
    freq.put("pah", 53);
    freq.put("pai", 30);
    freq.put("pak", 270);
    freq.put("pal", 588);
    freq.put("pam", 78);
    freq.put("pan", 858);
    freq.put("pao", 31);
    freq.put("oin", 41);
    freq.put("Hnd", 9);
    freq.put("nac", 19);
    freq.put("oid", 10);
    freq.put("oic", 25);
    freq.put("ois", 20);
    freq.put("oir", 7);
    freq.put("pa ", 1520);
    freq.put("bha", 10);
    freq.put("mo ", 2245);
    freq.put("moy", 20);
    freq.put("mos", 32);
    freq.put("mor", 118);
    freq.put("mov", 60);
    freq.put("mou", 17);
    freq.put("mot", 73);
    freq.put("mok", 19);
    freq.put("moo", 25);
    freq.put("mon", 360);
    freq.put("mom", 62);
    freq.put("mol", 12);
    freq.put("moc", 11);
    freq.put("mob", 10);
    freq.put("mog", 10);
    freq.put("mod", 25);
    freq.put("Nee", 7);
    freq.put("Nex", 13);
    freq.put("Nev", 14);
    freq.put("New", 31);
    freq.put(" cj", 7);
    freq.put("Med", 48);
    freq.put("Meg", 8);
    freq.put(" ci", 25);
    freq.put(" cn", 8);
    freq.put(" co", 873);
    freq.put(" cl", 125);
    freq.put("Mem", 8);
    freq.put("Mel", 9);
    freq.put("Men", 9);
    freq.put("Meh", 14);
    freq.put("kmi", 10);
    freq.put(" ce", 57);
    freq.put(" cy", 18);
    freq.put("Mer", 19);
    freq.put(" cr", 125);
    freq.put(" cp", 14);
    freq.put(" ct", 11);
    freq.put(" cu", 88);
    freq.put("hAn", 8);
    freq.put("Dra", 10);
    freq.put("Dre", 104);
    freq.put("Me ", 23);
    freq.put(" c ", 30);
    freq.put("yyy", 161);
    freq.put("yyT", 20);
    freq.put("Ac", 30);
    freq.put("yy ", 154);
    freq.put("e", 28918);
    freq.put("dva", 12);
    freq.put("Ove", 11);
    freq.put("u", 17147);
    freq.put("Val", 15);
    freq.put("iu ", 13);
    freq.put("gs", 419);
    freq.put("gr", 405);
    freq.put("hy ", 38);
    freq.put("ws ", 45);
    freq.put("DJ ", 21);
    freq.put("ium", 7);
    freq.put("edn", 11);
    freq.put("rDa", 8);
    freq.put("aja", 24);
    freq.put("ius", 17);
    freq.put("hye", 7);
    freq.put("hyp", 13);
    freq.put("hys", 8);
    freq.put("hyu", 14);
    freq.put("gg ", 30);
    freq.put("Gin", 43);
    freq.put("aba", 1120);
    freq.put("abb", 33);
    freq.put("gl", 387);
    freq.put("abe", 268);
    freq.put("abh", 8);
    freq.put("abi", 671);
    freq.put("abl", 60);
    freq.put("abo", 149);
    freq.put("abr", 31);
    freq.put("abs", 46);
    freq.put("abu", 122);
    freq.put("aby", 94);
    freq.put("ggu", 9);
    freq.put("ggs", 7);
    freq.put("K", 2426);
    freq.put("ggy", 11);
    freq.put("gge", 27);
    freq.put("ggg", 50);
    freq.put("gT", 29);
    freq.put("gga", 241);
    freq.put("ggo", 34);
    freq.put("ggi", 75);
    freq.put("ab ", 40);
    freq.put("lki", 11);
    freq.put("eyM", 9);
    freq.put("eya", 37);
    freq.put("eyc", 9);
    freq.put("eyb", 34);
    freq.put("eye", 67);
    freq.put("eyd", 8);
    freq.put("twe", 142);
    freq.put("eyi", 15);
    freq.put("twi", 109);
    freq.put("eym", 10);
    freq.put("eyl", 8);
    freq.put("eyo", 27);
    freq.put("eyn", 31);
    freq.put("eyp", 10);
    freq.put("eys", 19);
    freq.put("eyr", 14);
    freq.put("eyt", 9);
    freq.put("de ", 287);
    freq.put("eyz", 8);
    freq.put("OU ", 15);
    freq.put("gO", 7);
    freq.put("ey ", 156);
    freq.put("dez", 16);
    freq.put("dep", 16);
    freq.put("der", 98);
    freq.put("des", 74);
    freq.put("det", 17);
    freq.put("dev", 12);
    freq.put("del", 100);
    freq.put("dem", 14);
    freq.put("den", 127);
    freq.put("deo", 48);
    freq.put("sGa", 9);
    freq.put("dea", 41);
    freq.put("deb", 10);
    freq.put("dec", 24);
    freq.put("ded", 30);
    freq.put("dee", 46);
    freq.put("def", 8);
    freq.put("deg", 7);
    freq.put("ryn", 28);
    freq.put("ryo", 45);
    freq.put("ryl", 44);
    freq.put("ryi", 8);
    freq.put("cse", 34);
    freq.put("ryd", 11);
    freq.put("rye", 27);
    freq.put("rya", 45);
    freq.put("ryt", 7);
    freq.put("rys", 14);
    freq.put("Don", 65);
    freq.put("bka", 9);
    freq.put("Dol", 8);
    freq.put("Dom", 8);
    freq.put("pas", 343);
    freq.put("Dor", 11);
    freq.put("cs ", 51);
    freq.put("ry ", 313);
    freq.put("uh ", 54);
    freq.put("ok ", 445);
    freq.put("Ba ", 16);
    freq.put("AY ", 169);
    freq.put("pci", 7);
    freq.put("pca", 8);
    freq.put("Baw", 20);
    freq.put("Bat", 78);
    freq.put("okr", 7);
    freq.put("Bar", 20);
    freq.put("Bas", 49);
    freq.put("uha", 260);
    freq.put("uho", 36);
    freq.put("uhm", 10);
    freq.put("uhh", 22);
    freq.put("Bay", 11);
    freq.put("oka", 168);
    freq.put("Bag", 33);
    freq.put("Bad", 18);
    freq.put("uhu", 166);
    freq.put("Bab", 67);
    freq.put("Bac", 11);
    freq.put("oki", 25);
    freq.put("Bal", 45);
    freq.put("Bak", 181);
    freq.put("oko", 192);
    freq.put("okS", 9);
    freq.put("okO", 7);
    freq.put("mm ", 60);
    freq.put("Omg", 15);
    freq.put("E ", 443);
    freq.put("akf", 7);
    freq.put("mmy", 61);
    freq.put("mmm", 78);
    freq.put("Una", 10);
    freq.put("mmo", 10);
    freq.put("sba", 10);
    freq.put("mmi", 33);
    freq.put("sbe", 11);
    freq.put("mme", 69);
    freq.put("Uni", 18);
    freq.put("sbh", 9);
    freq.put("sbi", 8);
    freq.put("mma", 36);
    freq.put("Em", 23);
    freq.put("El", 75);
    freq.put("Eo", 7);
    freq.put("En", 62);
    freq.put("Ei", 17);
    freq.put("Eh", 83);
    freq.put("Ek", 15);
    freq.put("Ee", 10);
    freq.put("Ed", 34);
    freq.put("Ef", 8);
    freq.put("Ea", 18);
    freq.put("Ec", 10);
    freq.put("Ey", 8);
    freq.put("Ex", 42);
    freq.put("Eu", 16);
    freq.put("Et", 29);
    freq.put("Ew", 25);
    freq.put("Ev", 27);
    freq.put("Ep", 12);
    freq.put("Es", 25);
    freq.put("Er", 39);
    freq.put("tow", 13);
    freq.put("koS", 8);
    freq.put(" el", 83);
    freq.put("koh", 28);
    freq.put(" en", 87);
    freq.put(" eh", 869);
    freq.put(" ei", 20);
    freq.put("koo", 39);
    freq.put(" ek", 28);
    freq.put(" ed", 42);
    freq.put(" ee", 71);
    freq.put(" ef", 27);
    freq.put(" eg", 9);
    freq.put("kod", 34);
    freq.put(" eb", 7);
    freq.put(" ec", 10);
    freq.put("koy", 27);
    freq.put(" ex", 109);
    freq.put(" ey", 25);
    freq.put(" et", 29);
    freq.put(" eu", 10);
    freq.put("kos", 33);
    freq.put("kor", 22);
    freq.put(" ep", 46);
    freq.put("kot", 100);
    freq.put(" er", 44);
    freq.put(" es", 38);
    freq.put("Sla", 9);
    freq.put("Xi", 20);
    freq.put("ko ", 5463);
    freq.put(" e ", 275);
    freq.put("At ", 43);
    freq.put("AD ", 34);
    freq.put("k ", 1607);
    freq.put("Kit", 17);
    freq.put("Kin", 41);
    freq.put("Kim", 35);
    freq.put("Kil", 25);
    freq.put("kA", 8);
    freq.put("Ate", 44);
    freq.put("kO", 8);
    freq.put("kN", 7);
    freq.put("kS", 15);
    freq.put("kQ", 8);
    freq.put("kT", 7);
    freq.put("kY", 8);
    freq.put("kc", 48);
    freq.put("kb", 42);
    freq.put("ka", 10163);
    freq.put("kg", 23);
    freq.put("kf", 13);
    freq.put("ke", 767);
    freq.put("kd", 13);
    freq.put("kk", 93);
    freq.put("kj", 8);
    freq.put("ki", 2346);
    freq.put("kh", 177);
    freq.put("ko", 6468);
    freq.put("kn", 111);
    freq.put("km", 49);
    freq.put("kl", 160);
    freq.put("ks", 361);
    freq.put("kr", 95);
    freq.put("kp", 50);
    freq.put("kw", 103);
    freq.put("ku", 1089);
    freq.put("kt", 195);
    freq.put("kz", 12);
    freq.put("ky", 185);
    freq.put("Xia", 12);
    freq.put("IWa", 8);
    freq.put("aLa", 32);
    freq.put("Opo", 12);
    freq.put("ph", 225);
    freq.put(" Be", 86);
    freq.put(" Ba", 532);
    freq.put(" Bl", 37);
    freq.put(" Bo", 105);
    freq.put(" Bi", 145);
    freq.put(" Bu", 161);
    freq.put(" Bw", 23);
    freq.put("ik ", 158);
    freq.put(" Br", 49);
    freq.put(" By", 10);
    freq.put("DD ", 19);
    freq.put("iks", 25);
    freq.put(" B ", 26);
    freq.put("iku", 17);
    freq.put("ikt", 10);
    freq.put("ika", 398);
    freq.put("GE ", 15);
    freq.put("ike", 98);
    freq.put("Sen", 35);
    freq.put("ikk", 32);
    freq.put("iki", 173);
    freq.put("ikh", 8);
    freq.put("iko", 84);
    freq.put("rBa", 62);
    freq.put("ikl", 7);
    freq.put("Yeh", 7);
    freq.put("Yel", 7);
    freq.put("Yea", 18);
    freq.put("lG ", 8);
    freq.put("Yey", 11);
    freq.put("Yes", 31);
    freq.put("lbu", 17);
    freq.put("ga ", 2702);
    freq.put("ND ", 21);
    freq.put("HE ", 19);
    freq.put("gay", 667);
    freq.put("gaw", 350);
    freq.put("gau", 41);
    freq.put("gat", 113);
    freq.put("gas", 92);
    freq.put("gar", 94);
    freq.put("gap", 58);
    freq.put("gan", 1316);
    freq.put("gam", 158);
    freq.put("gal", 589);
    freq.put("gak", 17);
    freq.put("gai", 35);
    freq.put("gah", 33);
    freq.put("gag", 201);
    freq.put("gae", 13);
    freq.put("gad", 169);
    freq.put("gab", 122);
    freq.put("gaa", 69);
    freq.put("lba", 13);
    freq.put("fut", 8);
    freq.put("gaP", 13);
    freq.put("gaN", 55);
    freq.put("fue", 9);
    freq.put("gaK", 33);
    freq.put("fuc", 8);
    freq.put("fun", 8);
    freq.put("rar", 49);
    freq.put("ful", 44);
    freq.put("gaD", 30);
    freq.put("sy ", 80);
    freq.put("ewi", 13);
    freq.put("ewo", 12);
    freq.put("bs ", 46);
    freq.put("ewa", 57);
    freq.put("ewe", 12);
    freq.put("ews", 40);
    freq.put("sya", 367);
    freq.put("sye", 23);
    freq.put("dge", 31);
    freq.put("dgi", 8);
    freq.put("syo", 147);
    freq.put("OW ", 34);
    freq.put("sym", 8);
    freq.put("ew ", 97);
    freq.put("y", 17977);
    freq.put("lda", 17);
    freq.put("lde", 22);
    freq.put("ldi", 16);
    freq.put("ldo", 17);
    freq.put("bi ", 387);
    freq.put("cut", 83);
    freq.put("cus", 18);
    freq.put("rgu", 8);
    freq.put("cup", 7);
    freq.put("rgy", 9);
    freq.put("rga", 28);
    freq.put("rge", 40);
    freq.put("cua", 12);
    freq.put("rgi", 9);
    freq.put("cum", 7);
    freq.put("Jha", 12);
    freq.put("bio", 13);
    freq.put("Din", 17);
    freq.put("ld ", 61);
    freq.put("bik", 10);
    freq.put("bih", 155);
    freq.put("bii", 12);
    freq.put("big", 348);
    freq.put("bid", 15);
    freq.put("bie", 33);
    freq.put("bib", 61);
    freq.put("Dia", 15);
    freq.put("Dib", 12);
    freq.put("Dic", 13);
    freq.put("AL ", 76);
    freq.put("biy", 11);
    freq.put("Dit", 15);
    freq.put("bit", 71);
    freq.put("bir", 39);
    freq.put("bis", 42);
    freq.put("aCr", 7);
    freq.put("oe ", 14);
    freq.put("gDr", 18);
    freq.put("pez", 12);
    freq.put("pet", 37);
    freq.put("pep", 10);
    freq.put("per", 680);
    freq.put("pes", 21);
    freq.put("pel", 29);
    freq.put("pen", 106);
    freq.put("pek", 23);
    freq.put("ped", 17);
    freq.put("pee", 20);
    freq.put("peg", 27);
    freq.put("pea", 30);
    freq.put("pec", 28);
    freq.put("liE", 9);
    freq.put("Boy", 42);
    freq.put("oey", 10);
    freq.put("oes", 15);
    freq.put("Bor", 11);
    freq.put("Bos", 17);
    freq.put("Bot", 7);
    freq.put("O", 1077);
    freq.put("Bon", 22);
    freq.put("oel", 7);
    freq.put("Bob", 22);
    freq.put("uso", 121);
    freq.put("pe ", 82);
    freq.put("usm", 9);
    freq.put("nsh", 30);
    freq.put("nsi", 139);
    freq.put("nso", 38);
    freq.put("nsa", 218);
    freq.put("nse", 57);
    freq.put("nsf", 10);
    freq.put("nsy", 39);
    freq.put("nsp", 24);
    freq.put("nst", 45);
    freq.put("nsu", 14);
    freq.put("nsw", 7);
    freq.put(" a", 9111);
    freq.put("mka", 23);
    freq.put(" tp", 20);
    freq.put("nsD", 38);
    freq.put("mki", 8);
    freq.put("ust", 534);
    freq.put("uss", 20);
    freq.put(" R ", 12);
    freq.put("ns ", 155);
    freq.put("sde", 7);
    freq.put("sdf", 29);
    freq.put("sda", 25);
    freq.put("Oo ", 116);
    freq.put("zha", 7);
    freq.put("lyr", 8);
    freq.put("lys", 25);
    freq.put("lyy", 12);
    freq.put("lyz", 9);
    freq.put("lye", 11);
    freq.put("lya", 48);
    freq.put("lyb", 7);
    freq.put("lyn", 55);
    freq.put("Nya", 14);
    freq.put("lyk", 7);
    freq.put("Map", 14);
    freq.put("Mas", 139);
    freq.put(" gu", 482);
    freq.put(" gr", 189);
    freq.put("Mat", 82);
    freq.put("May", 237);
    freq.put(" gy", 14);
    freq.put("Maa", 25);
    freq.put(" gg", 20);
    freq.put(" gd", 11);
    freq.put("Mab", 40);
    freq.put("Mae", 16);
    freq.put("Mad", 39);
    freq.put("Mag", 217);
    freq.put(" ga", 923);
    freq.put("Mai", 15);
    freq.put("Mah", 62);
    freq.put("Mak", 68);
    freq.put(" gm", 21);
    freq.put("Mam", 39);
    freq.put("Mal", 92);
    freq.put(" gh", 8);
    freq.put("Man", 111);
    freq.put("Mee", 10);
    freq.put("kme", 12);
    freq.put("ly ", 205);
    freq.put("kma", 14);
    freq.put("Ma ", 19);
    freq.put(" g ", 13);
    freq.put(" b", 4487);
    freq.put(" c", 2074);
    freq.put(" ca", 231);
    freq.put(" f", 959);
    freq.put(" g", 2438);
    freq.put(" d", 3582);
    freq.put(" e", 2053);
    freq.put(" j", 749);
    freq.put(" k", 11403);
    freq.put(" h", 4600);
    freq.put(" i", 3243);
    freq.put(" n", 16562);
    freq.put(" o", 1413);
    freq.put(" l", 4439);
    freq.put(" cg", 34);
    freq.put(" r", 1166);
    freq.put(" s", 9226);
    freq.put(" p", 7878);
    freq.put(" q", 112);
    freq.put(" v", 323);
    freq.put(" w", 1578);
    freq.put(" t", 5817);
    freq.put(" u", 1322);
    freq.put(" z", 84);
    freq.put(" x", 288);
    freq.put(" y", 2547);
    freq.put("ap ", 586);
    freq.put(" B", 1661);
    freq.put(" C", 766);
    freq.put(" A", 2677);
    freq.put(" F", 468);
    freq.put(" G", 1204);
    freq.put(" D", 1764);
    freq.put(" E", 577);
    freq.put(" J", 600);
    freq.put(" K", 2069);
    freq.put(" H", 3187);
    freq.put(" I", 1162);
    freq.put(" N", 2118);
    freq.put(" O", 873);
    freq.put(" L", 1088);
    freq.put(" M", 2767);
    freq.put(" R", 2330);
    freq.put(" S", 2601);
    freq.put(" P", 2455);
    freq.put(" Q", 156);
    freq.put(" V", 169);
    freq.put(" W", 858);
    freq.put(" T", 1716);
    freq.put(" U", 370);
    freq.put(" Z", 53);
    freq.put(" X", 394);
    freq.put(" Y", 939);
    freq.put(" ?", 139);
    freq.put("nKa", 19);
    freq.put("nKo", 7);
    freq.put("Ori", 9);
    freq.put("Ora", 11);
    freq.put("oci", 13);
    freq.put("ock", 68);
    freq.put("Or ", 11);
    freq.put(" Do", 85);
    freq.put("Ver", 15);
    freq.put(" Dj", 11);
    freq.put(" Di", 346);
    freq.put("oce", 15);
    freq.put(" De", 83);
    freq.put(" Da", 299);
    freq.put("ii ", 83);
    freq.put(" Dy", 11);
    freq.put(" Du", 17);
    freq.put(" Dr", 24);
    freq.put("cha", 264);
    freq.put("Fr", 80);
    freq.put("che", 202);
    freq.put("chi", 191);
    freq.put("chl", 11);
    freq.put("cho", 186);
    freq.put("Fa", 99);
    freq.put("chr", 29);
    freq.put("chu", 44);
    freq.put("chy", 8);
    freq.put("Fl", 16);
    freq.put("Fo", 96);
    freq.put("iit", 33);
    freq.put("iiw", 20);
    freq.put("iip", 8);
    freq.put("iis", 92);
    freq.put("iir", 14);
    freq.put("iiy", 28);
    freq.put(" D ", 233);
    freq.put("iie", 22);
    freq.put("iig", 10);
    freq.put("iia", 18);
    freq.put("GG ", 10);
    freq.put("iic", 14);
    freq.put("iib", 8);
    freq.put("iim", 10);
    freq.put("iin", 119);
    freq.put("iii", 204);
    freq.put("iik", 9);
    freq.put("ch ", 188);
    freq.put("f", 2601);
    freq.put("ocu", 8);
    freq.put("F ", 55);
    freq.put("SM ", 16);
    freq.put("Yi", 12);
    freq.put("Yh", 7);
    freq.put("afi", 13);
    freq.put("Yo", 98);
    freq.put("Yn", 11);
    freq.put("Ya", 130);
    freq.put("gch", 13);
    freq.put("aff", 29);
    freq.put("Ye", 92);
    freq.put("afa", 16);
    freq.put("gco", 15);
    freq.put("tai", 26);
    freq.put("aft", 36);
    freq.put("afu", 15);
    freq.put("Yu", 531);
    freq.put("afr", 30);
    freq.put("Yv", 10);
    freq.put("sip", 144);
    freq.put("Y ", 392);
    freq.put("lG", 14);
    freq.put("lD", 17);
    freq.put("tsM", 23);
    freq.put("da ", 456);
    freq.put("lC", 8);
    freq.put("lA", 20);
    freq.put("lN", 11);
    freq.put("lO", 11);
    freq.put("lM", 22);
    freq.put("lJ", 7);
    freq.put("tsA", 8);
    freq.put("lT", 9);
    freq.put("Nk", 13);
    freq.put("lR", 22);
    freq.put("lS", 18);
    freq.put("lP", 24);
    freq.put("tsS", 9);
    freq.put("lY", 16);
    freq.put("lf", 73);
    freq.put("lg", 105);
    freq.put("ld", 184);
    freq.put("le", 1729);
    freq.put("lb", 63);
    freq.put("lc", 64);
    freq.put("la", 10681);
    freq.put("ln", 244);
    freq.put("lo", 2572);
    freq.put("ll", 1251);
    freq.put("lm", 126);
    freq.put("lj", 24);
    freq.put("lk", 88);
    freq.put("lh", 44);
    freq.put("li", 3378);
    freq.put("lv", 61);
    freq.put("lw", 25);
    freq.put("lt", 92);
    freq.put("lu", 592);
    freq.put("lr", 55);
    freq.put("ls", 206);
    freq.put("lp", 103);
    freq.put("tsy", 13);
    freq.put("tsu", 41);
    freq.put("lz", 27);
    freq.put("tss", 22);
    freq.put("taA", 10);
    freq.put("dad", 80);
    freq.put("dae", 15);
    freq.put("dag", 45);
    freq.put("daa", 73);
    freq.put("dab", 12);
    freq.put("dal", 230);
    freq.put("dam", 308);
    freq.put("dan", 188);
    freq.put("dah", 169);
    freq.put("dai", 23);
    freq.put("dak", 33);
    freq.put("dat", 139);
    freq.put("dav", 13);
    freq.put("daw", 224);
    freq.put("dap", 113);
    freq.put("dar", 46);
    freq.put("das", 47);
    freq.put("day", 305);
    freq.put("CK ", 15);
    freq.put("sih", 8);
    freq.put("l ", 2271);
    freq.put("emb", 30);
    freq.put("eu ", 10);
    freq.put("ts ", 329);
    freq.put("emi", 41);
    freq.put("lfo", 7);
    freq.put("lfi", 8);
    freq.put("lfr", 18);
    freq.put("Fee", 31);
    freq.put("rez", 27);
    freq.put("rey", 66);
    freq.put("rer", 62);
    freq.put("res", 228);
    freq.put("rep", 93);
    freq.put("req", 16);
    freq.put("rev", 61);
    freq.put("rew", 15);
    freq.put("ret", 82);
    freq.put("rek", 21);
    freq.put("reh", 46);
    freq.put("rei", 26);
    freq.put("ren", 185);
    freq.put("reo", 13);
    freq.put("rel", 108);
    freq.put("rem", 28);
    freq.put("reb", 11);
    freq.put("rec", 65);
    freq.put("rea", 216);
    freq.put("ref", 24);
    freq.put("reg", 44);
    freq.put("red", 83);
    freq.put("ree", 119);
    freq.put("lf ", 31);
    freq.put("qua", 18);
    freq.put("bwa", 21);
    freq.put("que", 90);
    freq.put("qui", 78);
    freq.put("bwi", 16);
    freq.put("quo", 21);
    freq.put("Ipa", 25);
    freq.put("re ", 590);
    freq.put("aAn", 37);
    freq.put("aAk", 7);
    freq.put("ud ", 78);
    freq.put("lib", 90);
    freq.put("og ", 430);
    freq.put("ogy", 15);
    freq.put("pg ", 15);
    freq.put("ogu", 15);
    freq.put("udy", 27);
    freq.put("ogs", 10);
    freq.put("ogr", 19);
    freq.put("ogo", 17);
    freq.put("uda", 20);
    freq.put("ogi", 57);
    freq.put("udg", 14);
    freq.put("udd", 8);
    freq.put("ude", 50);
    freq.put("oge", 13);
    freq.put("udi", 24);
    freq.put("oga", 10);
    freq.put("udo", 13);
    freq.put("udl", 7);
    freq.put("ogQ", 28);
    freq.put("Pen", 8);
    freq.put("ogS", 11);
    freq.put("Pap", 60);
    freq.put("Par", 169);
    freq.put("Pas", 53);
    freq.put("Pat", 129);
    freq.put("Pau", 27);
    freq.put("nqu", 10);
    freq.put("Pay", 7);
    freq.put("Paa", 33);
    freq.put("Pab", 11);
    freq.put("Pac", 23);
    freq.put("Pad", 27);
    freq.put("Pag", 168);
    freq.put("Pah", 14);
    freq.put("Pai", 7);
    freq.put("Pak", 42);
    freq.put("Pal", 28);
    freq.put("Pam", 22);
    freq.put("Pan", 112);
    freq.put("mii", 33);
    freq.put("mih", 17);
    freq.put("mik", 65);
    freq.put("mim", 39);
    freq.put("mil", 159);
    freq.put("min", 651);
    freq.put("mia", 23);
    freq.put("mic", 45);
    freq.put("mib", 9);
    freq.put("mie", 31);
    freq.put("mid", 9);
    freq.put("mig", 81);
    freq.put("miy", 12);
    freq.put("mip", 10);
    freq.put("mis", 271);
    freq.put("mir", 27);
    freq.put("mit", 170);
    freq.put("Pa ", 40);
    freq.put("sfo", 7);
    freq.put("sfe", 8);
    freq.put("mi ", 441);
    freq.put("MoS", 8);
    freq.put(" iS", 10);
    freq.put(" iJ", 7);
    freq.put(" iL", 9);
    freq.put(" iA", 12);
    freq.put("kst", 8);
    freq.put(" iz", 8);
    freq.put("kss", 11);
    freq.put("Mos", 8);
    freq.put("Mor", 35);
    freq.put(" ir", 24);
    freq.put(" is", 439);
    freq.put("ksy", 21);
    freq.put("Mov", 11);
    freq.put(" iv", 11);
    freq.put("Mot", 8);
    freq.put(" ih", 30);
    freq.put(" ii", 73);
    freq.put(" ik", 219);
    freq.put("Moo", 8);
    freq.put("Mon", 38);
    freq.put(" in", 616);
    freq.put(" ia", 215);
    freq.put("kso", 9);
    freq.put(" ic", 31);
    freq.put(" id", 52);
    freq.put("ksh", 11);
    freq.put(" if", 29);
    freq.put(" ig", 21);
    freq.put("ks ", 177);
    freq.put(" i ", 122);
    freq.put("Mo ", 27);
    freq.put("wo", 186);
    freq.put("Qna", 12);
    freq.put("wm", 9);
    freq.put("wl", 56);
    freq.put("wk", 20);
    freq.put("S", 3027);
    freq.put("wt", 76);
    freq.put("ws", 76);
    freq.put("wr", 29);
    freq.put("uia", 13);
    freq.put("ohn", 45);
    freq.put("ab", 2685);
    freq.put("ohh", 21);
    freq.put("ohi", 10);
    freq.put("ys ", 107);
    freq.put("Hon", 11);
    freq.put("wy", 38);
    freq.put("ohe", 11);
    freq.put("ak", 7304);
    freq.put("OL ", 93);
    freq.put("Hom", 9);
    freq.put("cos", 21);
    freq.put("oha", 50);
    freq.put("IK ", 10);
    freq.put("uio", 11);
    freq.put("cou", 74);
    freq.put("uin", 52);
    freq.put("tHa", 37);
    freq.put("ysi", 15);
    freq.put("ysh", 10);
    freq.put("yso", 14);
    freq.put("ysa", 32);
    freq.put("cov", 11);
    freq.put("Hot", 7);
    freq.put("yse", 16);
    freq.put("uir", 15);
    freq.put("yss", 30);
    freq.put("Hor", 7);
    freq.put("wM", 7);
    freq.put("yst", 18);
    freq.put(" Fr", 43);
    freq.put(" Fu", 21);
    freq.put("Hop", 11);
    freq.put(" Fa", 69);
    freq.put(" Fe", 44);
    freq.put(" Fi", 54);
    freq.put(" Fo", 42);
    freq.put("io ", 96);
    freq.put("coa", 7);
    freq.put("uiz", 15);
    freq.put("coc", 16);
    freq.put("rMa", 8);
    freq.put("Car", 33);
    freq.put("cod", 10);
    freq.put("SO ", 27);
    freq.put("iou", 58);
    freq.put("ior", 14);
    freq.put("ion", 317);
    freq.put("iol", 15);
    freq.put("GA ", 117);
    freq.put("wyp", 12);
    freq.put("cp ", 15);
    freq.put("wyn", 7);
    freq.put("con", 160);
    freq.put("fy ", 14);
    freq.put("BV ", 9);
    freq.put("adv", 16);
    freq.put("gmi", 12);
    freq.put("adu", 49);
    freq.put("adr", 35);
    freq.put("ads", 19);
    freq.put("gma", 131);
    freq.put("adz", 9);
    freq.put("ady", 66);
    freq.put("adg", 12);
    freq.put("add", 44);
    freq.put("ade", 109);
    freq.put("ada", 316);
    freq.put("ado", 210);
    freq.put("adl", 12);
    freq.put("adm", 15);
    freq.put("gmu", 29);
    freq.put("adi", 156);
    freq.put("oBa", 11);
    freq.put("kc ", 35);
    freq.put("ad ", 569);
    freq.put("LR ", 9);
    freq.put("nja", 23);
    freq.put("nje", 9);
    freq.put("ui ", 24);
    freq.put("njo", 47);
    freq.put("dc ", 11);
    freq.put("esA", 13);
    freq.put("esI", 9);
    freq.put("esu", 22);
    freq.put("est", 247);
    freq.put("ess", 317);
    freq.put("esp", 50);
    freq.put("esy", 23);
    freq.put("tma", 27);
    freq.put("ese", 120);
    freq.put("esd", 19);
    freq.put("esc", 27);
    freq.put("tme", 13);
    freq.put("esa", 83);
    freq.put("eso", 49);
    freq.put("esm", 15);
    freq.put("esl", 10);
    freq.put("esk", 14);
    freq.put("esi", 53);
    freq.put("esh", 41);
    freq.put("OS ", 28);
    freq.put("es ", 726);
    freq.put("Twe", 31);
    freq.put("Twi", 29);
    freq.put("bu ", 11);
    freq.put("dil", 77);
    freq.put("ec ", 23);
    freq.put("rco", 17);
    freq.put("rch", 28);
    freq.put("rci", 31);
    freq.put("rce", 31);
    freq.put("rca", 13);
    freq.put("buy", 10);
    freq.put("bur", 23);
    freq.put("bus", 101);
    freq.put("buw", 12);
    freq.put("but", 105);
    freq.put("buk", 235);
    freq.put("buh", 144);
    freq.put("Del", 16);
    freq.put("buo", 29);
    freq.put("Den", 10);
    freq.put("bum", 90);
    freq.put("bub", 20);
    freq.put("Dea", 37);
    freq.put("bua", 11);
    freq.put("Dee", 14);
    freq.put("Def", 7);
    freq.put("bue", 12);
    freq.put("ㅋㅋ", 8);
    freq.put("j", 1576);
    freq.put("rc ", 10);
    freq.put("pik", 31);
    freq.put("pil", 102);
    freq.put("pim", 8);
    freq.put("pin", 594);
    freq.put("pio", 8);
    freq.put("pia", 25);
    freq.put("pic", 139);
    freq.put("pid", 21);
    freq.put("pie", 18);
    freq.put("aGa", 9);
    freq.put("pig", 22);
    freq.put("piz", 12);
    freq.put("pip", 31);
    freq.put("pir", 51);
    freq.put("pis", 52);
    freq.put("pit", 144);
    freq.put("oad", 116);
    freq.put("oac", 8);
    freq.put("oan", 32);
    freq.put("oat", 7);
    freq.put("ubu", 48);
    freq.put("Ace", 7);
    freq.put("pi ", 31);
    freq.put("ube", 25);
    freq.put("uba", 41);
    freq.put("ubb", 15);
    freq.put("Act", 9);
    freq.put("ubl", 18);
    freq.put("ubo", 74);
    freq.put("ubi", 30);
    freq.put("ubj", 17);
    freq.put("oa ", 17);
    freq.put("Boo", 19);
    freq.put("dey", 8);
    freq.put("nwa", 25);
    freq.put("Oka", 72);
    freq.put("mwa", 7);
    freq.put("G ", 932);
    freq.put("Gw", 30);
    freq.put("Gu", 195);
    freq.put("Gr", 121);
    freq.put("mni", 13);
    freq.put("Ok ", 20);
    freq.put("Ge", 81);
    freq.put("Ga", 259);
    freq.put("ait", 118);
    freq.put("Go", 210);
    freq.put("Gn", 9);
    freq.put("Gl", 35);
    freq.put("Gi", 132);
    freq.put("Gh", 7);
    freq.put(" kb", 13);
    freq.put(" kc", 38);
    freq.put(" ka", 5878);
    freq.put(" kg", 13);
    freq.put(" ke", 169);
    freq.put(" kk", 7);
    freq.put(" kh", 34);
    freq.put(" ki", 590);
    freq.put(" kn", 79);
    freq.put(" ko", 3338);
    freq.put(" kl", 35);
    freq.put(" km", 25);
    freq.put(" kr", 55);
    freq.put(" ks", 29);
    freq.put(" kp", 29);
    freq.put(" kw", 55);
    freq.put(" kt", 14);
    freq.put(" ku", 876);
    freq.put(" ky", 52);
    freq.put("kuy", 81);
    freq.put("Fin", 24);
    freq.put("kut", 16);
    freq.put("Z ", 34);
    freq.put("kur", 20);
    freq.put("kup", 9);
    freq.put("kun", 591);
    freq.put("kum", 123);
    freq.put("kul", 111);
    freq.put("kuk", 25);
    freq.put("kuh", 55);
    freq.put("scr", 20);
    freq.put(" k ", 51);
    freq.put("aij", 8);
    freq.put("TT ", 14);
    freq.put("Zi", 9);
    freq.put("Ze", 9);
    freq.put("ty", 303);
    freq.put("Za", 19);
    freq.put("Zz", 7);
    freq.put("aib", 116);
    freq.put("ku ", 28);
    freq.put("zma", 10);
    freq.put("Kon", 24);
    freq.put("Kor", 8);
    freq.put("Kow", 17);
    freq.put("m ", 1359);
    freq.put("mE", 9);
    freq.put("mD", 7);
    freq.put("mG", 13);
    freq.put("mA", 28);
    freq.put("mC", 26);
    freq.put("mB", 13);
    freq.put("mM", 34);
    freq.put("mL", 12);
    freq.put("mN", 14);
    freq.put("mK", 13);
    freq.put("mJ", 20);
    freq.put("mT", 14);
    freq.put("mV", 12);
    freq.put("mP", 15);
    freq.put("mS", 20);
    freq.put("mR", 11);
    freq.put("mY", 7);
    freq.put("me", 1420);
    freq.put("md", 136);
    freq.put("mg", 957);
    freq.put("mf", 20);
    freq.put("ma", 9630);
    freq.put("mc", 52);
    freq.put("mb", 329);
    freq.put("mm", 380);
    freq.put("ml", 73);
    freq.put("mo", 3155);
    freq.put("mn", 145);
    freq.put("mi", 2124);
    freq.put("mh", 37);
    freq.put("mk", 56);
    freq.put("mj", 52);
    freq.put("mu", 834);
    freq.put("mt", 30);
    freq.put("mw", 13);
    freq.put("mv", 10);
    freq.put("mp", 469);
    freq.put("ms", 163);
    freq.put("mr", 60);
    freq.put("my", 257);
    freq.put("mx", 12);
    freq.put("mz", 14);
    freq.put("enA", 21);
    freq.put("enC", 7);
    freq.put("enI", 8);
    freq.put("ena", 152);
    freq.put("nOn", 8);
    freq.put("enc", 69);
    freq.put("end", 368);
    freq.put("ene", 116);
    freq.put("eng", 269);
    freq.put("enh", 7);
    freq.put("eni", 86);
    freq.put("enj", 35);
    freq.put("enl", 12);
    freq.put("enn", 60);
    freq.put("eno", 35);
    freq.put("enp", 8);
    freq.put("enr", 28);
    freq.put("ens", 158);
    freq.put("ent", 451);
    freq.put("enu", 13);
    freq.put("eny", 28);
    freq.put("enz", 35);
    freq.put("ON ", 93);
    freq.put("II ", 8);
    freq.put("en ", 381);
    freq.put("TA ", 63);
    freq.put(" Hy", 7);
    freq.put(" Hu", 111);
    freq.put(" Hi", 389);
    freq.put(" Hh", 8);
    freq.put(" Ho", 82);
    freq.put(" Hn", 12);
    freq.put(" Hm", 25);
    freq.put(" Ha", 1483);
    freq.put(" He", 142);
    freq.put("ima", 106);
    freq.put("imc", 10);
    freq.put("imb", 39);
    freq.put("ime", 203);
    freq.put("imd", 25);
    freq.put("imi", 109);
    freq.put("cle", 20);
    freq.put("imk", 10);
    freq.put("imj", 21);
    freq.put("imm", 47);
    freq.put("iml", 40);
    freq.put("imo", 80);
    freq.put("imp", 106);
    freq.put("ims", 19);
    freq.put("imu", 97);
    freq.put("imy", 14);
    freq.put("clu", 9);
    freq.put("lMe", 7);
    freq.put("SA ", 162);
    freq.put("im ", 120);
    freq.put("bra", 256);
    freq.put("gol", 15);
    freq.put("goo", 64);
    freq.put("gon", 122);
    freq.put("goi", 7);
    freq.put("god", 67);
    freq.put("aji", 10);
    freq.put("SI ", 39);
    freq.put("goy", 15);
    freq.put("ajo", 17);
    freq.put("got", 80);
    freq.put("gov", 8);
    freq.put("gop", 9);
    freq.put("gos", 23);
    freq.put("gor", 22);
    freq.put("W", 962);
    freq.put("Vib", 7);
    freq.put("Vic", 24);
    freq.put("Vin", 8);
    freq.put("go ", 356);
    freq.put("Vil", 11);
    freq.put("aj ", 18);
    freq.put("be ", 277);
    freq.put("nho", 10);
    freq.put("nhi", 20);
    freq.put("nir", 33);
    freq.put("toy", 11);
    freq.put("tor", 144);
    freq.put("tos", 72);
    freq.put("top", 91);
    freq.put("equ", 28);
    freq.put("EU ", 8);
    freq.put("tot", 96);
    freq.put("tou", 16);
    freq.put("tok", 121);
    freq.put("toh", 37);
    freq.put("ton", 206);
    freq.put("too", 110);
    freq.put("tol", 49);
    freq.put("tom", 100);
    freq.put("tob", 10);
    freq.put("toc", 13);
    freq.put("tog", 34);
    freq.put("tod", 36);
    freq.put("toe", 7);
    freq.put("apw", 7);
    freq.put("Fuc", 11);
    freq.put("to ", 1414);
    freq.put("thu", 12);
    freq.put("raf", 26);
    freq.put("rag", 33);
    freq.put("rad", 117);
    freq.put("rae", 11);
    freq.put("rab", 179);
    freq.put("rac", 81);
    freq.put("raa", 71);
    freq.put("ran", 614);
    freq.put("rao", 7);
    freq.put("ral", 123);
    freq.put("ram", 339);
    freq.put("rak", 20);
    freq.put("rah", 61);
    freq.put("rai", 63);
    freq.put("rav", 24);
    freq.put("raw", 148);
    freq.put("rat", 105);
    freq.put("rau", 13);
    freq.put("lbe", 11);
    freq.put("ras", 120);
    freq.put("rap", 394);
    freq.put("raz", 9);
    freq.put("lbo", 9);
    freq.put("ray", 80);
    freq.put("Sye", 7);
    freq.put("thn", 10);
    freq.put("It ", 15);
    freq.put("thi", 90);
    freq.put("ra ", 939);
    freq.put("thh", 8);
    freq.put("bse", 10);
    freq.put("bsa", 7);
    freq.put("Ito", 11);
    freq.put("thd", 29);
    freq.put("Ita", 7);
    freq.put("AS ", 54);
    freq.put("Its", 45);
    freq.put("gBa", 12);
    freq.put("Bin", 47);
    freq.put("och", 27);
    freq.put("Bil", 18);
    freq.put("oco", 47);
    freq.put("oca", 25);
    freq.put("Big", 34);
    freq.put("Bie", 9);
    freq.put("Bib", 7);
    freq.put("Bia", 7);
    freq.put("Bit", 14);
    freq.put("Bir", 10);
    freq.put("oct", 8);
    freq.put("Aan", 7);
    freq.put("Aar", 7);
    freq.put("oc ", 13);
    freq.put("nut", 34);
    freq.put("nuu", 8);
    freq.put("nur", 20);
    freq.put("nus", 24);
    freq.put("Per", 165);
    freq.put("nun", 451);
    freq.put("nuo", 85);
    freq.put("nul", 18);
    freq.put("num", 47);
    freq.put("nuk", 13);
    freq.put("nuh", 26);
    freq.put("Ped", 7);
    freq.put("nug", 14);
    freq.put("nue", 15);
    freq.put("nub", 19);
    freq.put("eTo", 14);
    freq.put("muu", 18);
    freq.put("mut", 55);
    freq.put("muw", 19);
    freq.put("mup", 9);
    freq.put("mus", 79);
    freq.put("mur", 41);
    freq.put("muy", 7);
    freq.put("muc", 21);
    freq.put("mub", 7);
    freq.put("mum", 13);
    freq.put("mul", 90);
    freq.put("mun", 251);
    freq.put("muh", 16);
    freq.put("muk", 137);
    freq.put("Exc", 18);
    freq.put("XD ", 131);
    freq.put("nu ", 68);
    freq.put("mu ", 46);
    freq.put("kwa", 30);
    freq.put(" me", 366);
    freq.put(" mg", 871);
    freq.put("kwe", 66);
    freq.put(" ma", 5419);
    freq.put(" mc", 12);
    freq.put(" mm", 19);
    freq.put(" mn", 22);
    freq.put(" mo", 2607);
    freq.put(" mh", 18);
    freq.put(" mi", 367);
    freq.put(" mj", 13);
    freq.put(" mk", 29);
    freq.put(" mu", 407);
    freq.put("xx ", 24);
    freq.put(" mp", 8);
    freq.put(" mr", 16);
    freq.put(" ms", 26);
    freq.put(" my", 97);
    freq.put("yMi", 10);
    freq.put(" m ", 69);
    freq.put("Cru", 42);
    freq.put("xxx", 9);
    freq.put("Cra", 7);
    freq.put("Cri", 10);
    freq.put("TV ", 35);
    freq.put("n", 64616);
    freq.put("ape", 73);
    freq.put("Iam", 49);
    freq.put("elO", 7);
    freq.put("elA", 7);
    freq.put("elG", 7);
    freq.put("elD", 8);
    freq.put("elR", 12);
    freq.put("elS", 12);
    freq.put("elP", 10);
    freq.put("eli", 366);
    freq.put("elo", 129);
    freq.put("ell", 354);
    freq.put("elm", 13);
    freq.put("elb", 11);
    freq.put("elc", 22);
    freq.put("ela", 305);
    freq.put("elf", 21);
    freq.put("elg", 10);
    freq.put("eld", 22);
    freq.put("ele", 121);
    freq.put("ely", 59);
    freq.put("nMa", 12);
    freq.put("elr", 12);
    freq.put("els", 50);
    freq.put("elp", 39);
    freq.put("elv", 10);
    freq.put("elt", 13);
    freq.put("elu", 9);
    freq.put("D", 2272);
    freq.put("OH ", 23);
    freq.put("el ", 275);
    freq.put("ywa", 11);
    freq.put("hs ", 17);
    freq.put("vit", 22);
    freq.put(" Ju", 124);
    freq.put(" Jo", 89);
    freq.put(" Ji", 18);
    freq.put(" Jh", 17);
    freq.put(" Jk", 14);
    freq.put(" Je", 77);
    freq.put(" Ja", 103);
    freq.put("ick", 140);
    freq.put("ici", 111);
    freq.put("Hy", 9);
    freq.put("ico", 88);
    freq.put("icl", 8);
    freq.put("ica", 178);
    freq.put("ice", 247);
    freq.put("Hu", 117);
    freq.put("Hh", 10);
    freq.put("Hi", 410);
    freq.put("Hn", 15);
    freq.put("Ho", 101);
    freq.put("Hm", 26);
    freq.put("ics", 84);
    freq.put("Ha", 1556);
    freq.put("He", 167);
    freq.put("hsa", 13);
    freq.put("SC ", 7);
    freq.put("awr", 10);
    freq.put("twa", 8);
    freq.put(" J ", 14);
    freq.put("ic ", 177);
    freq.put("H ", 249);
    freq.put("thr", 37);
    freq.put("ppa", 26);
    freq.put("aha", 7087);
    freq.put("ppe", 71);
    freq.put("ahe", 35);
    freq.put("nPa", 8);
    freq.put("ppi", 32);
    freq.put("ahi", 742);
    freq.put("ppo", 23);
    freq.put("aho", 124);
    freq.put("ppl", 23);
    freq.put("ppr", 14);
    freq.put("ppp", 9);
    freq.put("aht", 8);
    freq.put("ahu", 40);
    freq.put("ppy", 90);
    freq.put("giv", 11);
    freq.put("git", 176);
    freq.put("gis", 128);
    freq.put("gir", 113);
    freq.put("gip", 12);
    freq.put("GM ", 8);
    freq.put("gig", 82);
    freq.put("gif", 11);
    freq.put("gie", 34);
    freq.put("gid", 20);
    freq.put("gic", 15);
    freq.put("gib", 10);
    freq.put("gia", 23);
    freq.put("gio", 9);
    freq.put("gin", 679);
    freq.put("gil", 69);
    freq.put("gii", 26);
    freq.put("ah ", 425);
    freq.put("pp ", 21);
    freq.put("eyy", 36);
    freq.put("Vol", 8);
    freq.put("Von", 10);
    freq.put("gi ", 189);
    freq.put("nH", 10);
    freq.put("nI", 18);
    freq.put("nJ", 13);
    freq.put("nK", 34);
    freq.put("nL", 23);
    freq.put("nM", 28);
    freq.put("nN", 16);
    freq.put("nO", 24);
    freq.put("nng", 8);
    freq.put("nA", 57);
    freq.put("nB", 28);
    freq.put("nC", 30);
    freq.put("nD", 24);
    freq.put("nE", 22);
    freq.put("nF", 8);
    freq.put("nG", 28);
    freq.put("nY", 12);
    freq.put("nny", 35);
    freq.put("nP", 21);
    freq.put("nR", 18);
    freq.put("nS", 40);
    freq.put("nT", 24);
    freq.put("nV", 9);
    freq.put("nh", 51);
    freq.put("ni", 3242);
    freq.put("nj", 100);
    freq.put("nk", 286);
    freq.put("nl", 307);
    freq.put("nm", 194);
    freq.put("nn", 631);
    freq.put("no", 2126);
    freq.put("tit", 90);
    freq.put("na", 13822);
    freq.put("nb", 85);
    freq.put("nc", 514);
    freq.put("nd", 2833);
    freq.put("ne", 1525);
    freq.put("nf", 83);
    freq.put("ng", 21418);
    freq.put("nx", 19);
    freq.put("ny", 955);
    freq.put("nz", 155);
    freq.put("tio", 223);
    freq.put("tih", 8);
    freq.put("tii", 35);
    freq.put("ES ", 105);
    freq.put("np", 66);
    freq.put("nq", 13);
    freq.put("nr", 78);
    freq.put("ns", 872);
    freq.put("nt", 1764);
    freq.put("nu", 867);
    freq.put("nv", 50);
    freq.put("nw", 41);
    freq.put("squ", 15);
    freq.put("nn ", 61);
    freq.put("Lec", 11);
    freq.put("n ", 11827);
    freq.put("ti ", 368);
    freq.put("roi", 13);
    freq.put("roj", 11);
    freq.put("rol", 51);
    freq.put("rom", 77);
    freq.put("ron", 229);
    freq.put("roo", 52);
    freq.put("lls", 31);
    freq.put("roa", 14);
    freq.put("rob", 92);
    freq.put("roc", 39);
    freq.put("rod", 21);
    freq.put("rof", 19);
    freq.put("rog", 15);
    freq.put("rox", 8);
    freq.put("roy", 9);
    freq.put("lli", 96);
    freq.put("mg ", 51);
    freq.put("llo", 205);
    freq.put("llm", 21);
    freq.put("lll", 18);
    freq.put("rop", 25);
    freq.put("lla", 208);
    freq.put("ros", 80);
    freq.put("rot", 28);
    freq.put("rou", 57);
    freq.put("rov", 11);
    freq.put("row", 46);
    freq.put("Dad", 20);
    freq.put("Dal", 36);
    freq.put("Dam", 32);
    freq.put("Dan", 64);
    freq.put("Dah", 40);
    freq.put("Dai", 7);
    freq.put("Dat", 20);
    freq.put("Dav", 8);
    freq.put("Dap", 33);
    freq.put("Dar", 19);
    freq.put("Day", 39);
    freq.put("kle", 17);
    freq.put("ro ", 920);
    freq.put("tw ", 10);
    freq.put("ll ", 233);
    freq.put("kla", 99);
    freq.put("ict", 103);
    freq.put("klo", 7);
    freq.put("Res", 9);
    freq.put("Rep", 11);
    freq.put("Ret", 13);
    freq.put("kli", 14);
    freq.put("Ren", 14);
    freq.put("Rel", 15);
    freq.put("Rec", 7);
    freq.put("aKa", 62);
    freq.put("Rea", 15);
    freq.put("Reg", 7);
    freq.put("Red", 10);
    freq.put("Bwa", 17);
    freq.put("Que", 31);
    freq.put("Qui", 12);
    freq.put("Quo", 84);
    freq.put("ㅋ", 11);
    freq.put("Aga", 10);
    freq.put("pm ", 21);
    freq.put("Agu", 11);
    freq.put("😁?", 9);
    freq.put("eRe", 10);
    freq.put("ngt", 11);
    freq.put("msu", 17);
    freq.put("mso", 13);
    freq.put("msh", 7);
    freq.put("mse", 7);
    freq.put("msa", 10);
    freq.put("Evi", 8);
    freq.put("dp ", 7);
    freq.put("Eve", 14);
    freq.put("yja", 16);
    freq.put("yjo", 11);
    freq.put(" ch", 382);
    freq.put("ms ", 58);
    freq.put(" on", 128);
    freq.put(" oo", 180);
    freq.put(" ol", 27);
    freq.put(" om", 41);
    freq.put("kyo", 23);
    freq.put(" ok", 185);
    freq.put(" oh", 166);
    freq.put("Min", 94);
    freq.put(" of", 97);
    freq.put(" og", 10);
    freq.put("kya", 21);
    freq.put(" ob", 8);
    freq.put(" oc", 11);
    freq.put("Mig", 25);
    freq.put(" oy", 27);
    freq.put(" ov", 31);
    freq.put(" ow", 22);
    freq.put(" ot", 11);
    freq.put("Mir", 10);
    freq.put(" or", 163);
    freq.put(" os", 7);
    freq.put(" op", 43);
    freq.put("cob", 7);
    freq.put("ky ", 37);
    freq.put(" o ", 136);
    freq.put("dih", 43);
    freq.put("Fan", 32);
    freq.put("gta", 113);
    freq.put("gte", 28);
    freq.put("gti", 27);
    freq.put("gto", 12);
    freq.put("gtr", 18);
    freq.put("gtu", 20);
    freq.put("gtw", 12);
    freq.put("ahh", 203);
    freq.put("ahn", 9);
    freq.put("ng ", 17293);
    freq.put("ahm", 9);
    freq.put("EN ", 22);
    freq.put("ejo", 25);
    freq.put("eje", 23);
    freq.put("eja", 18);
    freq.put("nCa", 8);
    freq.put("UG ", 7);
    freq.put("ahA", 7);
    freq.put("yup", 25);
    freq.put("yus", 14);
    freq.put("yuu", 16);
    freq.put("yut", 12);
    freq.put("yuk", 12);
    freq.put("yum", 25);
    freq.put("yun", 1446);
    freq.put("hu ", 79);
    freq.put("iam", 239);
    freq.put("ial", 109);
    freq.put("iao", 8);
    freq.put("ian", 321);
    freq.put("iah", 12);
    freq.put("iad", 8);
    freq.put("iag", 14);
    freq.put("iaa", 34);
    freq.put("iac", 8);
    freq.put("iay", 16);
    freq.put("iaz", 9);
    freq.put("iat", 24);
    freq.put("iap", 11);
    freq.put("ias", 26);
    freq.put("iar", 25);
    freq.put("hue", 10);
    freq.put("hug", 20);
    freq.put("hua", 21);
    freq.put("hub", 10);
    freq.put("huc", 10);
    freq.put("hul", 60);
    freq.put("hum", 44);
    freq.put("hun", 28);
    freq.put("huh", 131);
    freq.put("huk", 10);
    freq.put("hut", 29);
    freq.put("huu", 8);
    freq.put("huw", 20);
    freq.put("hup", 7);
    freq.put("hur", 27);
    freq.put("hus", 18);
    freq.put("huy", 10);
    freq.put("ia ", 185);
    freq.put("r", 17136);
    freq.put("pre", 134);
    freq.put("ane", 134);
    freq.put("anf", 8);
    freq.put("ang", 8742);
    freq.put("pra", 55);
    freq.put("ana", 1392);
    freq.put("anb", 16);
    freq.put("anc", 211);
    freq.put("anl", 70);
    freq.put("anm", 21);
    freq.put("pro", 190);
    freq.put("ano", 844);
    freq.put("pri", 110);
    freq.put("ani", 657);
    freq.put("anj", 34);
    freq.put("ank", 109);
    freq.put("ant", 493);
    freq.put("uy ", 55);
    freq.put("anp", 13);
    freq.put("anr", 9);
    freq.put("ans", 263);
    freq.put("any", 256);
    freq.put("anz", 70);
    freq.put("anD", 14);
    freq.put("anG", 11);
    freq.put(" L ", 20);
    freq.put("anL", 7);
    freq.put("anM", 7);
    freq.put("kan", 733);
    freq.put("anO", 9);
    freq.put("gku", 18);
    freq.put("GO ", 27);
    freq.put("anK", 18);
    freq.put("gki", 47);
    freq.put("gko", 56);
    freq.put("anS", 11);
    freq.put("gka", 346);
    freq.put("gke", 11);
    freq.put("uys", 44);
    freq.put("an ", 5565);
    freq.put("uyy", 7);
    freq.put("uya", 157);
    freq.put("uyo", 14);
    freq.put(" Le", 59);
    freq.put(" La", 261);
    freq.put(" Lo", 211);
    freq.put(" Li", 109);
    freq.put(" Lu", 41);
    freq.put("eMe", 7);
    freq.put("nlu", 15);
    freq.put("tka", 8);
    freq.put("nly", 15);
    freq.put("eMo", 13);
    freq.put("itl", 17);
    freq.put("nla", 67);
    freq.put("nle", 7);
    freq.put("nli", 65);
    freq.put("dy ", 90);
    freq.put("ss ", 515);
    freq.put("nlo", 86);
    freq.put("nln", 43);
    freq.put("ssy", 30);
    freq.put("ssu", 46);
    freq.put("H", 3344);
    freq.put("ssw", 13);
    freq.put("sss", 175);
    freq.put("ssr", 8);
    freq.put("ssm", 46);
    freq.put("ssl", 18);
    freq.put("sso", 17);
    freq.put("dyo", 85);
    freq.put("ssi", 104);
    freq.put("ssh", 17);
    freq.put("sse", 68);
    freq.put("dye", 12);
    freq.put("ssa", 92);
    freq.put("dya", 133);
    freq.put("rms", 10);
    freq.put("iLo", 8);
    freq.put("rmy", 8);
    freq.put("iLi", 7);
    freq.put("rma", 83);
    freq.put("rme", 27);
    freq.put("lng", 219);
    freq.put("rmi", 29);
    freq.put("rmo", 19);
    freq.put("rm ", 49);
    freq.put("sLi", 7);
    freq.put("nno", 23);
    freq.put("poy", 40);
    freq.put("pow", 16);
    freq.put("pot", 59);
    freq.put("por", 94);
    freq.put("pos", 479);
    freq.put("pop", 45);
    freq.put("pon", 196);
    freq.put("poo", 21);
    freq.put("pol", 44);
    freq.put("gNa", 31);
    freq.put("poi", 26);
    freq.put("pog", 33);
    freq.put("pod", 11);
    freq.put("poc", 8);
    freq.put("eOf", 9);
    freq.put("nni", 68);
    freq.put("Bus", 14);
    freq.put("But", 53);
    freq.put("WA ", 20);
    freq.put("Buk", 26);
    freq.put("Buh", 28);
    freq.put("Bun", 11);
    freq.put("yMo", 9);
    freq.put("Bul", 19);
    freq.put("Bum", 9);
    freq.put("nne", 183);
    freq.put("nna", 130);
    freq.put("po ", 545);
    freq.put("oks", 19);
    freq.put("ePi", 13);
    freq.put("ePa", 18);
    freq.put("I ", 520);
    freq.put("uhi", 28);
    freq.put("Eto", 19);
    freq.put("tiy", 12);
    freq.put("Iy", 10);
    freq.put("tiz", 7);
    freq.put("Ip", 37);
    freq.put("Is", 100);
    freq.put("Ir", 16);
    freq.put("It", 91);
    freq.put("Iw", 7);
    freq.put("yhe", 8);
    freq.put("Ii", 11);
    freq.put("Ih", 7);
    freq.put("Ik", 89);
    freq.put("Im", 71);
    freq.put("Il", 36);
    freq.put("In", 243);
    freq.put("Ia", 60);
    freq.put("oke", 99);
    freq.put("Ic", 14);
    freq.put("Ib", 39);
    freq.put("tiv", 50);
    freq.put("Ig", 10);
    freq.put("If", 7);
    freq.put("tiw", 27);
    freq.put(" qt", 7);
    freq.put(" qu", 42);
    freq.put("tip", 45);
    freq.put("Ban", 148);
    freq.put("tir", 32);
    freq.put("tis", 88);
    freq.put("til", 39);
    freq.put("tim", 197);
    freq.put("tin", 874);
    freq.put("Bah", 16);
    freq.put("yc", 89);
    freq.put("tik", 47);
    freq.put(" q ", 37);
    freq.put("tid", 85);
    freq.put("ich", 107);
    freq.put("tie", 50);
    freq.put("tif", 26);
    freq.put("tig", 90);
    freq.put("Pil", 42);
    freq.put("Pin", 117);
    freq.put("Pic", 10);
    freq.put("tia", 35);
    freq.put("tib", 27);
    freq.put("wba", 22);
    freq.put("tic", 104);
    freq.put("Kuy", 23);
    freq.put("HT ", 10);
    freq.put("Kun", 190);
    freq.put("Kum", 19);
    freq.put("Kul", 16);
    freq.put("o ", 16644);
    freq.put("oO", 10);
    freq.put("oN", 23);
    freq.put("oM", 41);
    freq.put("oL", 19);
    freq.put("oK", 26);
    freq.put("oJ", 9);
    freq.put("oG", 15);
    freq.put("oF", 9);
    freq.put("oE", 7);
    freq.put("oD", 28);
    freq.put("oC", 14);
    freq.put("oB", 19);
    freq.put("oA", 11);
    freq.put("bbl", 12);
    freq.put("oY", 9);
    freq.put("oT", 28);
    freq.put("oS", 39);
    freq.put("oR", 9);
    freq.put("oP", 26);
    freq.put("oo", 1723);
    freq.put("on", 4948);
    freq.put("om", 767);
    freq.put("ol", 1253);
    freq.put("ok", 994);
    freq.put("oj", 51);
    freq.put("oi", 178);
    freq.put("oh", 419);
    freq.put("og", 668);
    freq.put("of", 201);
    freq.put("oe", 74);
    freq.put("od", 784);
    freq.put("oc", 246);
    freq.put("ob", 539);
    freq.put("oa", 209);
    freq.put("oz", 40);
    freq.put("oy", 648);
    freq.put("ox", 48);
    freq.put("ow", 626);
    freq.put("ov", 539);
    freq.put("ou", 834);
    freq.put("ot", 1030);
    freq.put("os", 1329);
    freq.put("or", 1700);
    freq.put("oq", 12);
    freq.put("op", 418);
    freq.put("LE ", 27);
    freq.put("nAn", 14);
    freq.put("nAs", 17);
    freq.put("FB ", 30);
    freq.put("OB ", 11);
    freq.put("ehu", 12);
    freq.put("EL ", 23);
    freq.put("ehe", 358);
    freq.put("RD ", 13);
    freq.put("eha", 36);
    freq.put("eho", 22);
    freq.put("ehh", 69);
    freq.put("jua", 10);
    freq.put("jud", 37);
    freq.put("jun", 14);
    freq.put("UE ", 13);
    freq.put("jul", 22);
    freq.put("jus", 46);
    freq.put("OD ", 29);
    freq.put("eh ", 891);
    freq.put("aRo", 10);
    freq.put("rve", 22);
    freq.put("rvi", 44);
    freq.put("hw ", 8);
    freq.put("igu", 113);
    freq.put("igt", 9);
    freq.put("igs", 7);
    freq.put("IC ", 21);
    freq.put("igy", 46);
    freq.put("igg", 20);
    freq.put("ige", 174);
    freq.put("iga", 288);
    freq.put("igo", 82);
    freq.put("ign", 72);
    freq.put("igl", 91);
    freq.put("igi", 166);
    freq.put("igh", 190);
    freq.put("ynd", 9);
    freq.put("hwa", 8);
    freq.put("SG ", 8);
    freq.put("ig ", 350);
    freq.put("pto", 26);
    freq.put("alo", 461);
    freq.put("all", 234);
    freq.put("alm", 38);
    freq.put("alk", 61);
    freq.put("pti", 15);
    freq.put("ali", 1166);
    freq.put("alf", 22);
    freq.put("alg", 16);
    freq.put("pte", 8);
    freq.put("ale", 170);
    freq.put("alb", 26);
    freq.put("lly", 85);
    freq.put("pta", 16);
    freq.put("ala", 4398);
    freq.put("aly", 47);
    freq.put("alv", 26);
    freq.put("alw", 11);
    freq.put("alt", 25);
    freq.put("alu", 135);
    freq.put("als", 29);
    freq.put("alp", 20);
    freq.put("Tsk", 23);
    freq.put(" N ", 14);
    freq.put("GI ", 10);
    freq.put("alP", 9);
    freq.put("llp", 24);
    freq.put("far", 10);
    freq.put("fas", 14);
    freq.put("fav", 17);
    freq.put("fat", 10);
    freq.put("pt ", 16);
    freq.put("uwi", 113);
    freq.put("fai", 28);
    freq.put("fan", 96);
    freq.put("fal", 7);
    freq.put("fam", 25);
    freq.put("fac", 40);
    freq.put("uwa", 103);
    freq.put("uwe", 15);
    freq.put(" Ni", 79);
    freq.put(" Nk", 12);
    freq.put(" No", 73);
    freq.put(" Na", 847);
    freq.put(" Ne", 85);
    freq.put(" Ng", 137);
    freq.put(" Ny", 28);
    freq.put(" Nu", 38);
    freq.put("teh", 38);
    freq.put("tek", 22);
    freq.put("tel", 63);
    freq.put("tem", 27);
    freq.put("ten", 121);
    freq.put("teo", 7);
    freq.put("tea", 61);
    freq.put("tec", 19);
    freq.put("ted", 117);
    freq.put("tee", 41);
    freq.put("eKa", 8);
    freq.put("teg", 10);
    freq.put("tex", 102);
    freq.put("tez", 10);
    freq.put("nbo", 12);
    freq.put("tep", 22);
    freq.put("nba", 37);
    freq.put("tes", 157);
    freq.put("tet", 20);
    freq.put("ror", 15);
    freq.put("nbe", 7);
    freq.put("sug", 25);
    freq.put("sue", 14);
    freq.put("suc", 15);
    freq.put("sub", 56);
    freq.put("suo", 19);
    freq.put("sun", 124);
    freq.put("sum", 156);
    freq.put("sul", 57);
    freq.put("suk", 85);
    freq.put("suh", 8);
    freq.put("suu", 8);
    freq.put("sus", 76);
    freq.put("lle", 255);
    freq.put("sup", 106);
    freq.put("suy", 7);
    freq.put("te ", 731);
    freq.put("su ", 9);
    freq.put("ya ", 2071);
    freq.put("rks", 14);
    freq.put("Tor", 11);
    freq.put("Top", 7);
    freq.put("Ung", 25);
    freq.put("Tot", 14);
    freq.put("rke", 33);
    freq.put("Ton", 12);
    freq.put("rka", 22);
    freq.put("Tom", 16);
    freq.put("rki", 16);
    freq.put("Unl", 10);
    freq.put("ToT", 7);
    freq.put("ToM", 9);
    freq.put("In ", 8);
    freq.put("rk ", 59);
    freq.put("To ", 11);
    freq.put("Int", 15);
    freq.put("Ins", 15);
    freq.put("Ini", 19);
    freq.put("v", 2080);
    freq.put("Ind", 50);
    freq.put("Ing", 27);
    freq.put("Ina", 72);
    freq.put("oyQ", 8);
    freq.put("gHa", 8);
    freq.put("oyB", 13);
    freq.put("oyz", 8);
    freq.put("oyy", 19);
    freq.put("oys", 22);
    freq.put("oyo", 14);
    freq.put("oyn", 9);
    freq.put("oyf", 31);
    freq.put("oye", 10);
    freq.put("oyd", 15);
    freq.put("oyc", 25);
    freq.put("oya", 39);
    freq.put("Gli", 10);
    freq.put("Glo", 13);
    freq.put("Aki", 12);
    freq.put("Ako", 110);
    freq.put("Aka", 22);
    freq.put("lha", 17);
    freq.put("lhi", 12);
    freq.put("oy ", 361);
    freq.put("yn ", 64);
    freq.put("L", 1449);
    freq.put("ynB", 8);
    freq.put("Ero", 7);
    freq.put("Eri", 12);
    freq.put("ynn", 12);
    freq.put("yno", 13);
    freq.put("yni", 19);
    freq.put("Ran", 20);
    freq.put("yne", 31);
    freq.put("Ral", 12);
    freq.put("Ram", 15);
    freq.put("yna", 52);
    freq.put(" sy", 278);
    freq.put("Mus", 13);
    freq.put(" sp", 72);
    freq.put(" sw", 74);
    freq.put(" st", 222);
    freq.put(" su", 467);
    freq.put(" sk", 41);
    freq.put(" sh", 257);
    freq.put(" si", 1800);
    freq.put(" sn", 45);
    freq.put(" so", 383);
    freq.put(" sl", 47);
    freq.put(" sm", 49);
    freq.put(" sb", 24);
    freq.put(" sc", 116);
    freq.put("Mun", 8);
    freq.put(" sg", 13);
    freq.put("Muk", 16);
    freq.put(" se", 247);
    freq.put("iza", 35);
    freq.put("ize", 44);
    freq.put("gur", 101);
    freq.put("izi", 7);
    freq.put("izo", 18);
    freq.put("izz", 38);
    freq.put(" em", 48);
    freq.put("kok", 9);
    freq.put("kom", 10);
    freq.put(" s ", 135);
    freq.put("kol", 23);
    freq.put("iz ", 40);
    freq.put("kon", 526);
    freq.put("wla", 34);
    freq.put("X ", 53);
    freq.put(" ea", 32);
    freq.put("Rey", 16);
    freq.put("kog", 11);
    freq.put("gpl", 8);
    freq.put("gpo", 17);
    freq.put("gpi", 25);
    freq.put("jec", 35);
    freq.put("gpa", 273);
    freq.put("TL ", 10);
    freq.put("gpu", 27);
    freq.put("gpr", 9);
    freq.put("No", 93);
    freq.put("kop", 25);
    freq.put(" ev", 62);
    freq.put(" ew", 42);
    freq.put("Nun", 16);
    freq.put("kow", 17);
    freq.put("nGi", 7);
    freq.put("efr", 9);
    freq.put("efu", 13);
    freq.put("efi", 10);
    freq.put("efo", 15);
    freq.put("efa", 9);
    freq.put("efe", 20);
    freq.put("eff", 43);
    freq.put("Kwe", 8);
    freq.put("ef ", 20);
    freq.put("rte", 89);
    freq.put("rta", 42);
    freq.put("rtl", 10);
    freq.put("rto", 23);
    freq.put("cdo", 9);
    freq.put("rti", 80);
    freq.put("rth", 54);
    freq.put("rtu", 13);
    freq.put("rts", 40);
    freq.put("rty", 50);
    freq.put("iey", 9);
    freq.put("Ju", 160);
    freq.put("ies", 88);
    freq.put("ier", 31);
    freq.put("IA ", 13);
    freq.put("iew", 46);
    freq.put("iev", 17);
    freq.put("Jo", 123);
    freq.put("iem", 9);
    freq.put("iel", 229);
    freq.put("Jk", 14);
    freq.put("Je", 98);
    freq.put("iec", 8);
    freq.put("ieb", 27);
    freq.put("iee", 55);
    freq.put("Ja", 174);
    freq.put("ieg", 21);
    freq.put("Jc", 7);
    freq.put("hip", 36);
    freq.put("hir", 201);
    freq.put("his", 74);
    freq.put("hit", 370);
    freq.put("hiu", 11);
    freq.put("hiw", 18);
    freq.put("hiy", 76);
    freq.put("hiz", 12);
    freq.put("hia", 22);
    freq.put("hib", 7);
    freq.put("b", 10623);
    freq.put("hid", 10);
    freq.put("hie", 66);
    freq.put("hig", 39);
    freq.put("hih", 133);
    freq.put("hii", 20);
    freq.put("hik", 22);
    freq.put("hil", 303);
    freq.put("him", 48);
    freq.put("hin", 1124);
    freq.put("bf ", 15);
    freq.put("ie ", 249);
    freq.put("J ", 73);
    freq.put("arp", 10);
    freq.put("arq", 8);
    freq.put("arr", 90);
    freq.put("ars", 67);
    freq.put("art", 290);
    freq.put("aru", 75);
    freq.put("arv", 16);
    freq.put("ary", 89);
    freq.put("ara", 1527);
    freq.put("arb", 26);
    freq.put("arc", 89);
    freq.put("ard", 126);
    freq.put("are", 276);
    freq.put("arg", 45);
    freq.put("arh", 9);
    freq.put("ari", 552);
    freq.put("arj", 10);
    freq.put("ark", 71);
    freq.put("arl", 138);
    freq.put("uu ", 41);
    freq.put("arn", 27);
    freq.put("aro", 149);
    freq.put("oTh", 10);
    freq.put("al ", 862);
    freq.put(" P ", 84);
    freq.put("uuu", 90);
    freq.put("uuw", 12);
    freq.put("uus", 14);
    freq.put("ar ", 214);
    freq.put("uul", 25);
    freq.put("uun", 17);
    freq.put("fgh", 26);
    freq.put("uuh", 14);
    freq.put("uub", 14);
    freq.put(" Pr", 83);
    freq.put("c", 6782);
    freq.put(" Pw", 30);
    freq.put(" Pu", 103);
    freq.put(" Pa", 860);
    freq.put(" Pe", 187);
    freq.put(" Pi", 155);
    freq.put(" Ph", 36);
    freq.put(" Po", 65);
    freq.put(" Pl", 35);
    freq.put("pS", 7);
    freq.put("Fav", 13);
    freq.put("pB", 8);
    freq.put("tga", 7);
    freq.put("pr", 502);
    freq.put("ps", 142);
    freq.put("pp", 332);
    freq.put("dul", 25);
    freq.put("pw", 174);
    freq.put("pt", 92);
    freq.put("pu", 674);
    freq.put("pz", 9);
    freq.put("dua", 29);
    freq.put("duc", 9);
    freq.put("dud", 10);
    freq.put("dug", 23);
    freq.put("pb", 16);
    freq.put("pc", 32);
    freq.put("pa", 7177);
    freq.put("pf", 12);
    freq.put("pg", 38);
    freq.put("pd", 38);
    freq.put("pe", 1147);
    freq.put("pj", 7);
    freq.put("pk", 15);
    freq.put("dur", 12);
    freq.put("pi", 1302);
    freq.put("dut", 7);
    freq.put("po", 1642);
    freq.put("pl", 476);
    freq.put("pm", 37);
    freq.put("yTa", 26);
    freq.put("gem", 14);
    freq.put("p ", 1783);
    freq.put("riz", 50);
    freq.put("rix", 25);
    freq.put("riv", 36);
    freq.put("rit", 100);
    freq.put("rir", 9);
    freq.put("ris", 251);
    freq.put("rip", 98);
    freq.put("riq", 14);
    freq.put("rin", 656);
    freq.put("rio", 69);
    freq.put("ril", 112);
    freq.put("rim", 16);
    freq.put("rik", 33);
    freq.put("rii", 19);
    freq.put("rif", 13);
    freq.put("rig", 52);
    freq.put("rid", 44);
    freq.put("rie", 305);
    freq.put("rib", 9);
    freq.put("ric", 141);
    freq.put("ria", 135);
    freq.put("YO ", 97);
    freq.put("Cor", 13);
    freq.put("Ila", 19);
    freq.put("Com", 18);
    freq.put("Col", 28);
    freq.put("ri ", 134);
    freq.put("Con", 27);
    freq.put("ahd", 7);
    freq.put("ths", 18);
    freq.put("Ai ", 7);
    freq.put("bOn", 17);
    freq.put("Air", 9);
    freq.put("ljk", 10);
    freq.put("zz ", 42);
    freq.put("zzz", 37);
    freq.put("zzy", 11);
    freq.put("zza", 31);
    freq.put("aMi", 8);
    freq.put("Rom", 12);
    freq.put("Ron", 9);
    freq.put("Roo", 9);
    freq.put("aMa", 33);
    freq.put("Rob", 15);
    freq.put("Roc", 13);
    freq.put("yle", 83);
    freq.put("yla", 45);
    freq.put("ylo", 20);
    freq.put("yll", 35);
    freq.put("Ros", 13);
    freq.put("yli", 22);
    freq.put("wn ", 37);
    freq.put(" uy", 30);
    freq.put(" ut", 47);
    freq.put(" uu", 33);
    freq.put(" uw", 24);
    freq.put(" up", 81);
    freq.put(" ur", 8);
    freq.put(" us", 65);
    freq.put(" ul", 234);
    freq.put(" um", 173);
    freq.put(" un", 466);
    freq.put(" uh", 18);
    freq.put(" ui", 14);
    freq.put(" ug", 63);
    freq.put(" ub", 18);
    freq.put("ixi", 17);
    freq.put("xpl", 9);
    freq.put("xpe", 24);
    freq.put("wnl", 21);
    freq.put(" u ", 27);
    freq.put("Ms ", 10);
    freq.put("ca ", 94);
    freq.put("ix ", 23);
    freq.put("z", 1383);
    freq.put("Sup", 71);
    freq.put("HH ", 13);
    freq.put("AtI", 7);
    freq.put("gru", 8);
    freq.put("grr", 8);
    freq.put("GV ", 19);
    freq.put("gre", 115);
    freq.put("gra", 213);
    freq.put("gro", 36);
    freq.put("gri", 11);
    freq.put("eda", 42);
    freq.put("edd", 8);
    freq.put("ede", 215);
    freq.put("edj", 9);
    freq.put("edi", 67);
    freq.put("LA ", 113);
    freq.put("edo", 15);
    freq.put("edm", 7);
    freq.put("edr", 17);
    freq.put("eds", 15);
    freq.put("ugo", 29);
    freq.put("edy", 84);
    freq.put("FF ", 12);
    freq.put("edM", 7);
    freq.put("EH ", 41);
    freq.put("ugb", 10);
    freq.put("uga", 84);
    freq.put("ed ", 297);
    freq.put("cay", 19);
    freq.put("P", 2834);
    freq.put("Kyl", 8);
    freq.put("car", 99);
    freq.put("Kyu", 7);
    freq.put("rro", 38);
    freq.put("rri", 38);
    freq.put("rre", 76);
    freq.put("rra", 31);
    freq.put("ugs", 7);
    freq.put("rry", 186);
    freq.put("rrr", 49);
    freq.put("bda", 10);
    freq.put("Uu", 7);
    freq.put("ugu", 32);
    freq.put("IG ", 21);
    freq.put("Thi", 14);
    freq.put("Yup", 7);
    freq.put("rr ", 36);
    freq.put("Yun", 497);
    freq.put("hka", 8);
    freq.put("caa", 14);
    freq.put("apr", 26);
    freq.put("aps", 31);
    freq.put("app", 197);
    freq.put("Mik", 36);
    freq.put("apt", 41);
    freq.put("apu", 94);
    freq.put("aph", 21);
    freq.put("api", 226);
    freq.put("apo", 567);
    freq.put("apl", 11);
    freq.put("NT ", 11);
    freq.put("gQu", 34);
    freq.put("apa", 1516);
    freq.put("Mil", 10);
    freq.put("usg", 10);
    freq.put("use", 59);
    freq.put("fee", 172);
    freq.put("usc", 7);
    freq.put("fec", 19);
    freq.put("usa", 143);
    freq.put("fen", 7);
    freq.put("Hum", 17);
    freq.put("fel", 21);
    freq.put(" oi", 15);
    freq.put("Huh", 53);
    freq.put("usi", 69);
    freq.put("ush", 140);
    freq.put("usu", 61);
    freq.put("Huw", 24);
    freq.put("fer", 42);
    freq.put("fes", 16);
    freq.put("usp", 20);
    freq.put("Mic", 24);
    freq.put("usy", 50);
    freq.put("Gud", 9);
    freq.put("Gum", 12);
    freq.put("Gus", 114);
    freq.put("Gut", 15);
    freq.put("Guy", 19);
    freq.put(" Ru", 20);
    freq.put("fe ", 59);
    freq.put("us ", 175);
    freq.put(" Ry", 14);
    freq.put(" Re", 102);
    freq.put(" Ra", 60);
    freq.put(" Ro", 67);
    freq.put(" Ri", 44);
    freq.put(" Rh", 11);
    freq.put("tat", 239);
    freq.put("tau", 17);
    freq.put("taw", 227);
    freq.put("tap", 355);
    freq.put("tar", 159);
    freq.put("tas", 121);
    freq.put("tay", 628);
    freq.put("tad", 29);
    freq.put("tae", 19);
    freq.put("taf", 7);
    freq.put("tag", 227);
    freq.put("taa", 74);
    freq.put("tab", 96);
    freq.put("tac", 12);
    freq.put("tal", 735);
    freq.put("tam", 268);
    freq.put("tan", 758);
    freq.put("tao", 314);
    freq.put("tah", 54);
    freq.put("Mis", 130);
    freq.put("tak", 143);
    freq.put("sis", 128);
    freq.put("sir", 64);
    freq.put(" ou", 54);
    freq.put("taP", 9);
    freq.put("siv", 7);
    freq.put("sit", 70);
    freq.put("Uyy", 7);
    freq.put("siz", 10);
    freq.put("siy", 276);
    freq.put("six", 7);
    freq.put("sic", 57);
    freq.put("sib", 34);
    freq.put("sia", 32);
    freq.put("sig", 215);
    freq.put("kyu", 33);
    freq.put("sie", 19);
    freq.put("sid", 47);
    freq.put("sik", 59);
    freq.put("sii", 13);
    freq.put("dwi", 10);
    freq.put("sio", 45);
    freq.put("sin", 707);
    freq.put("sim", 98);
    freq.put("sil", 252);
    freq.put("ta ", 1525);
    freq.put("Eks", 7);
    freq.put("Uy ", 18);
    freq.put("dw ", 8);
    freq.put("si ", 1119);
    freq.put("kbo", 13);
    freq.put("kba", 8);
    freq.put("byu", 10);
    freq.put("ea ", 66);
    freq.put("bye", 25);
    freq.put("Dya", 7);
    freq.put("bya", 15);
    freq.put("Cas", 16);
    freq.put("Iba", 29);
    freq.put("Cat", 9);
    freq.put("Can", 20);
    freq.put("Cam", 11);
    freq.put("Cal", 22);
    freq.put("Cab", 8);
    freq.put("Pre", 21);
    freq.put("nfe", 7);
    freq.put("Pra", 14);
    freq.put("nfa", 13);
    freq.put("nfo", 24);
    freq.put("Pro", 43);
    freq.put("Pri", 38);
    freq.put("nfi", 21);
    freq.put("by ", 99);
    freq.put("oui", 27);
    freq.put("oun", 87);
    freq.put("oul", 13);
    freq.put("ouc", 14);
    freq.put("oug", 22);
    freq.put("oud", 24);
    freq.put("ous", 121);
    freq.put("our", 108);
    freq.put("oup", 30);
    freq.put("ouu", 14);
    freq.put("out", 115);
    freq.put("lt ", 11);
    freq.put("ou ", 218);
    freq.put("g", 36911);
    freq.put("lty", 9);
    freq.put("lta", 14);
    freq.put("lte", 7);
    freq.put("lti", 14);
    freq.put("lth", 7);
    freq.put("lto", 15);
    freq.put("K ", 175);
    freq.put("Ka", 1000);
    freq.put("Ke", 82);
    freq.put("Ki", 145);
    freq.put("Kh", 19);
    freq.put("Ko", 105);
    freq.put("Kn", 9);
    freq.put("Kl", 7);
    freq.put("Kr", 40);
    freq.put("Kp", 7);
    freq.put("Kw", 14);
    freq.put("Ku", 267);
    freq.put("vas", 10);
    freq.put("Ky", 20);
    freq.put("uar", 21);
    freq.put("ybi", 7);
    freq.put("aSa", 30);
    freq.put("ybo", 14);
    freq.put("yba", 33);
    freq.put("aSi", 7);
    freq.put("ybe", 34);
    freq.put("seo", 8);
    freq.put("hr", 147);
    freq.put("hp", 23);
    freq.put("Po ", 13);
    freq.put("whe", 11);
    freq.put("wha", 45);
    freq.put("who", 22);
    freq.put("whi", 16);
    freq.put("hw", 26);
    freq.put("ht", 785);
    freq.put("why", 16);
    freq.put("Pot", 15);
    freq.put("Por", 17);
    freq.put("Pog", 15);
    freq.put("Cha", 64);
    freq.put("NI ", 23);
    freq.put("hc", 17);
    freq.put("oMa", 16);
    freq.put("ha", 11260);
    freq.put(" w ", 21);
    freq.put("hf", 14);
    freq.put("oMo", 8);
    freq.put("hg", 14);
    freq.put("q ", 87);
    freq.put("TH ", 16);
    freq.put("Jas", 12);
    freq.put(" we", 169);
    freq.put("qu", 209);
    freq.put("qt", 9);
    freq.put(" wa", 983);
    freq.put(" wo", 107);
    freq.put(" wl", 32);
    freq.put(" wh", 89);
    freq.put(" wi", 128);
    freq.put("Jam", 18);
    freq.put(" wr", 10);
    freq.put("dmi", 14);
    freq.put("Chu", 13);
    freq.put("ebe", 68);
    freq.put("eba", 30);
    freq.put("ebl", 7);
    freq.put("RN ", 16);
    freq.put("ebi", 16);
    freq.put("jo ", 30);
    freq.put("ebu", 20);
    freq.put("ebr", 48);
    freq.put("ebs", 11);
    freq.put("hU", 8);
    freq.put("Tex", 20);
    freq.put("dla", 16);
    freq.put("dle", 22);
    freq.put("mCh", 10);
    freq.put("Ri", 69);
    freq.put("dlu", 10);
    freq.put("jor", 17);
    freq.put("jos", 21);
    freq.put("eb ", 22);
    freq.put("jow", 14);
    freq.put("joy", 55);
    freq.put("yMa", 15);
    freq.put("joa", 11);
    freq.put("job", 8);
    freq.put("joe", 8);
    freq.put("jog", 9);
    freq.put("joh", 29);
    freq.put("joi", 10);
    freq.put("jok", 56);
    freq.put("jol", 13);
    freq.put("jon", 32);
    freq.put("joo", 13);
    freq.put("dl ", 8);
    freq.put("hD", 8);
    freq.put("rpr", 16);
    freq.put("rpu", 8);
    freq.put("rpa", 10);
    freq.put("rpe", 7);
    freq.put("hm ", 18);
    freq.put("rpo", 12);
    freq.put("Jua", 22);
    freq.put("Jud", 23);
    freq.put("Jun", 30);
    freq.put("Jul", 45);
    freq.put("Jus", 24);
    freq.put("ikm", 8);
    freq.put("bby", 31);
    freq.put("IE ", 9);
    freq.put("hmy", 12);
    freq.put("hmm", 24);
    freq.put("hma", 14);
    freq.put("bb ", 12);
    freq.put("AR ", 22);
    freq.put("avo", 35);
    freq.put("avi", 44);
    freq.put("ave", 85);
    freq.put("ava", 29);
    freq.put("gSo", 13);
    freq.put(" T ", 77);
    freq.put("Gwa", 20);
    freq.put("av ", 7);
    freq.put(" Ty", 11);
    freq.put(" Tw", 37);
    freq.put(" Tu", 87);
    freq.put(" Ts", 44);
    freq.put(" Tr", 71);
    freq.put(" To", 90);
    freq.put(" Ti", 99);
    freq.put(" Th", 186);
    freq.put(" Te", 93);
    freq.put(" Ta", 451);
    freq.put("mfo", 9);
    freq.put("tch", 109);
    freq.put("sku", 11);
    freq.put("now", 75);
    freq.put("sky", 21);
    freq.put("ske", 25);
    freq.put("Uwi", 7);
    freq.put("Fai", 7);
    freq.put("ska", 44);
    freq.put("Fam", 8);
    freq.put("Fac", 23);
    freq.put("sko", 29);
    freq.put("ski", 29);
    freq.put("T", 2071);
    freq.put("tc ", 7);
    freq.put("sk ", 71);
    freq.put("Sub", 8);
    freq.put("Sun", 25);
    freq.put("Sum", 21);
    freq.put("Sul", 10);
    freq.put("kda", 7);
    freq.put("iDo", 7);
    freq.put("Sus", 13);
    freq.put("Sur", 17);
    freq.put("iDi", 9);
    freq.put("nd ", 434);
    freq.put("ndi", 1187);
    freq.put("ndl", 7);
    freq.put("ndo", 137);
    freq.put("nda", 671);
    freq.put("nde", 123);
    freq.put("ndy", 49);
    freq.put("ndz", 9);
    freq.put("nds", 66);
    freq.put("ndr", 43);
    freq.put("ndu", 29);
    freq.put("ndt", 10);
    freq.put("owl", 12);
    freq.put("own", 66);
    freq.put("owi", 17);
    freq.put("owe", 61);
    freq.put("owd", 8);
    freq.put("owa", 21);
    freq.put("owb", 25);
    freq.put("owy", 16);
    freq.put("owt", 47);
    freq.put("oww", 14);
    freq.put("ows", 21);
    freq.put("Ami", 22);
    freq.put("vai", 8);
    freq.put("van", 43);
    freq.put("val", 32);
    freq.put("vac", 13);
    freq.put("vad", 9);
    freq.put("var", 17);
    freq.put("Amp", 8);
    freq.put("vat", 22);
    freq.put("ow ", 258);
    freq.put("Tek", 17);
    freq.put("Ten", 9);
    freq.put("Tea", 23);
    freq.put("va ", 23);
    freq.put("Tee", 14);
    freq.put("lve", 17);
    freq.put("lva", 16);
    freq.put("Ter", 10);
    freq.put("lvi", 12);
    freq.put("mys", 7);
    freq.put("myu", 10);
    freq.put("Aft", 11);
    freq.put("myk", 7);
    freq.put("myj", 7);
    freq.put("myo", 7);
    freq.put("myn", 19);
    freq.put("mya", 13);
    freq.put("mye", 7);
    freq.put("my ", 116);
    freq.put("Oy ", 11);
    freq.put(" xx", 8);
  }
  
}

