package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class TR {
  private static final String name = "tr";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public TR() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 2553064;
    n_words[1] = 2986554;
    n_words[2] = 2471731;

    freq.put("çın", 262);
    freq.put("çım", 31);
    freq.put("çıl", 268);
    freq.put("çık", 1729);
    freq.put("çıy", 54);
    freq.put("çır", 133);
    freq.put("çıp", 41);
    freq.put("şor", 27);
    freq.put("çı ", 188);
    freq.put(" yü", 821);
    freq.put(" yö", 203);
    freq.put("hoş", 243);
    freq.put(" y ", 32);
    freq.put("aja", 33);
    freq.put("e ", 49883);
    freq.put(" yi", 1296);
    freq.put(" yl", 43);
    freq.put(" yo", 3731);
    freq.put(" ya", 14825);
    freq.put("k", 108177);
    freq.put(" ye", 4149);
    freq.put(" yu", 552);
    freq.put("İft", 29);
    freq.put("Lü", 68);
    freq.put("dna", 30);
    freq.put("çığ", 49);
    freq.put("dn ", 67);
    freq.put("Le", 145);
    freq.put("La", 230);
    freq.put("Lo", 84);
    freq.put("Li", 379);
    freq.put("Lu", 81);
    freq.put("hoc", 234);
    freq.put("hon", 103);
    freq.put("hoo", 34);
    freq.put("hol", 27);
    freq.put("how", 80);
    freq.put("hot", 33);
    freq.put("hor", 38);
    freq.put("hos", 76);
    freq.put("hop", 36);
    freq.put(" yı", 922);
    freq.put("A", 7272);
    freq.put("L ", 506);
    freq.put("Ö", 780);
    freq.put("ho ", 56);
    freq.put("DP ", 29);
    freq.put("xi", 27);
    freq.put("mdü", 26);
    freq.put("fir", 137);
    freq.put("fis", 58);
    freq.put("rö", 172);
    freq.put("fiz", 34);
    freq.put("fiy", 207);
    freq.put("rç", 731);
    freq.put("fif", 59);
    freq.put("fik", 210);
    freq.put("Hil", 50);
    freq.put("fil", 645);
    freq.put("fim", 49);
    freq.put(" Va", 289);
    freq.put(" Ve", 321);
    freq.put(" Vi", 155);
    freq.put(" Vo", 48);
    freq.put("atç", 58);
    freq.put("atö", 41);
    freq.put("fi ", 159);
    freq.put("uo ", 28);
    freq.put("atü", 90);
    freq.put("mdi", 1094);
    freq.put("mda", 1092);
    freq.put("mde", 987);
    freq.put("mdu", 46);
    freq.put("rt", 4285);
    freq.put("ru", 10450);
    freq.put("Ağu", 80);
    freq.put("rp", 274);
    freq.put("rr", 917);
    freq.put("rs", 5697);
    freq.put("smu", 27);
    freq.put("sms", 30);
    freq.put("ry", 455);
    freq.put("rz", 224);
    freq.put("rd", 9058);
    freq.put("re", 10287);
    freq.put("rf", 206);
    freq.put("rg", 963);
    freq.put("ra", 17759);
    freq.put("rb", 1124);
    freq.put("Hiç", 108);
    freq.put("rl", 5478);
    freq.put("rm", 4932);
    freq.put("rn", 767);
    freq.put("ro", 1927);
    freq.put("rh", 425);
    freq.put("ri", 16805);
    freq.put("sma", 488);
    freq.put("rk", 6916);
    freq.put("IM ", 65);
    freq.put("Ege", 34);
    freq.put("ate", 911);
    freq.put("atc", 38);
    freq.put("ata", 1565);
    freq.put("ato", 86);
    freq.put("atl", 1124);
    freq.put("atm", 634);
    freq.put("atk", 48);
    freq.put("ath", 32);
    freq.put("ati", 1127);
    freq.put("att", 1009);
    freq.put("atu", 135);
    freq.put("r ", 41889);
    freq.put("şok", 48);
    freq.put("ds ", 30);
    freq.put("aty", 27);
    freq.put("Dun", 38);
    freq.put("Dua", 29);
    freq.put("Duy", 49);
    freq.put("Dur", 67);
    freq.put("für", 96);
    freq.put("Hür", 47);
    freq.put("Ceb", 35);
    freq.put("Cen", 36);
    freq.put("Cem", 68);
    freq.put("Cev", 26);
    freq.put("nz ", 77);
    freq.put("YA ", 53);
    freq.put("fiğ", 26);
    freq.put("nza", 46);
    freq.put("nze", 148);
    freq.put("nzi", 76);
    freq.put("rş", 970);
    freq.put("vgi", 552);
    freq.put("Asy", 28);
    freq.put("vga", 57);
    freq.put(" fb", 54);
    freq.put("atı", 1912);
    freq.put("Ask", 42);
    freq.put("Asl", 104);
    freq.put("mdı", 123);
    freq.put("rı", 9335);
    freq.put("smı", 64);
    freq.put("lpa", 31);
    freq.put("ğı ", 924);
    freq.put("zte", 26);
    freq.put("kı ", 473);
    freq.put("irç", 26);
    freq.put("yfa", 185);
    freq.put("yfi", 97);
    freq.put("bi ", 4824);
    freq.put("X", 51);
    freq.put("kıs", 472);
    freq.put("kır", 358);
    freq.put("ğıd", 36);
    freq.put("kıv", 42);
    freq.put("kıt", 31);
    freq.put("kız", 726);
    freq.put("kıy", 487);
    freq.put("ğıl", 44);
    freq.put("kıc", 127);
    freq.put("İK ", 31);
    freq.put("ğıt", 67);
    freq.put("ğır", 206);
    freq.put("kın", 1057);
    freq.put("ğıy", 208);
    freq.put("kıl", 690);
    freq.put("gın", 210);
    freq.put("gım", 101);
    freq.put("gıl", 149);
    freq.put("irr", 33);
    freq.put("irs", 697);
    freq.put("irt", 188);
    freq.put("gıb", 40);
    freq.put("irv", 30);
    freq.put("iri", 2777);
    freq.put("irk", 296);
    freq.put("irl", 829);
    freq.put("irm", 865);
    freq.put("irn", 27);
    freq.put("iro", 43);
    freq.put("ira", 1093);
    freq.put("irb", 154);
    freq.put("gıt", 33);
    freq.put("ird", 903);
    freq.put("ire", 895);
    freq.put("irg", 83);
    freq.put("DM ", 37);
    freq.put("şiz", 47);
    freq.put("şiy", 130);
    freq.put("şit", 70);
    freq.put("şis", 49);
    freq.put("şir", 154);
    freq.put("gı ", 139);
    freq.put("şin", 335);
    freq.put("ıca", 573);
    freq.put("şil", 170);
    freq.put("şik", 403);
    freq.put("ıce", 40);
    freq.put("ir ", 10028);
    freq.put("şif", 47);
    freq.put("şid", 71);
    freq.put("and", 2080);
    freq.put("ygı", 122);
    freq.put("fra", 105);
    freq.put("fre", 257);
    freq.put("fri", 100);
    freq.put("çük", 169);
    freq.put("ann", 478);
    freq.put("kış", 306);
    freq.put("cun", 187);
    freq.put("ğış", 56);
    freq.put("bin", 583);
    freq.put("irş", 151);
    freq.put("bil", 4593);
    freq.put("bim", 270);
    freq.put("jk ", 43);
    freq.put("ıcı", 380);
    freq.put("bii", 144);
    freq.put("şiş", 74);
    freq.put("tlı", 302);
    freq.put("olü", 77);
    freq.put("hah", 1176);
    freq.put("hai", 39);
    freq.put("hak", 790);
    freq.put("hal", 1448);
    freq.put("ham", 194);
    freq.put("han", 927);
    freq.put("haa", 117);
    freq.put("hab", 740);
    freq.put("hac", 119);
    freq.put("had", 380);
    freq.put("haf", 535);
    freq.put("Or", 247);
    freq.put("hay", 1658);
    freq.put("haz", 372);
    freq.put("bnm", 35);
    freq.put("hap", 77);
    freq.put("azı", 1739);
    freq.put("har", 680);
    freq.put("has", 324);
    freq.put("hat", 1004);
    freq.put("hav", 374);
    freq.put("Iyi", 29);
    freq.put("kök", 29);
    freq.put("köt", 290);
    freq.put("kör", 70);
    freq.put("köp", 94);
    freq.put("köy", 140);
    freq.put("ha ", 2359);
    freq.put("soğ", 71);
    freq.put("ola", 3777);
    freq.put("olc", 393);
    freq.put("old", 2218);
    freq.put("ole", 198);
    freq.put("ığa", 90);
    freq.put("olg", 41);
    freq.put("oli", 265);
    freq.put("olk", 43);
    freq.put("oll", 483);
    freq.put("olm", 2880);
    freq.put("olo", 225);
    freq.put("ols", 1870);
    freq.put("olt", 55);
    freq.put("olu", 2951);
    freq.put("an ", 14874);
    freq.put("fot", 309);
    freq.put("for", 288);
    freq.put("umr", 57);
    freq.put("ume", 70);
    freq.put("umd", 305);
    freq.put("uma", 1007);
    freq.put("umc", 34);
    freq.put("umb", 33);
    freq.put("fol", 150);
    freq.put("uml", 287);
    freq.put("fon", 355);
    freq.put("umi", 27);
    freq.put("umh", 79);
    freq.put("umk", 28);
    freq.put("ol ", 1117);
    freq.put("İş", 200);
    freq.put("ştu", 275);
    freq.put("o", 80762);
    freq.put("um ", 6729);
    freq.put("Fed", 42);
    freq.put("mbo", 65);
    freq.put("mbi", 69);
    freq.put("sog", 39);
    freq.put("sof", 49);
    freq.put("Fen", 449);
    freq.put("mbe", 141);
    freq.put("sok", 232);
    freq.put("som", 48);
    freq.put("sol", 187);
    freq.put("son", 2524);
    freq.put("sos", 88);
    freq.put("sor", 1041);
    freq.put("Fer", 45);
    freq.put("Fes", 37);
    freq.put("sov", 28);
    freq.put("soy", 358);
    freq.put("mbu", 35);
    freq.put("soz", 86);
    freq.put("Yüz", 40);
    freq.put("az ", 2212);
    freq.put("so ", 30);
    freq.put("ğzı", 106);
    freq.put("azi", 646);
    freq.put("azl", 496);
    freq.put("azm", 384);
    freq.put("aza", 1473);
    freq.put("azc", 36);
    freq.put("azd", 435);
    freq.put("aze", 484);
    freq.put("azg", 105);
    freq.put("azz", 78);
    freq.put("İç", 127);
    freq.put("köş", 49);
    freq.put("azs", 259);
    freq.put("Sir", 27);
    freq.put("Siv", 30);
    freq.put("Siz", 188);
    freq.put("şa ", 207);
    freq.put("kha", 47);
    freq.put("Sin", 83);
    freq.put("Sim", 57);
    freq.put("Sil", 37);
    freq.put("us", 3325);
    freq.put("İ ", 391);
    freq.put("E", 3023);
    freq.put("ığı", 1970);
    freq.put("İr", 45);
    freq.put("İs", 644);
    freq.put("İt", 41);
    freq.put("İz", 179);
    freq.put("İy", 147);
    freq.put("İb", 33);
    freq.put("İf", 34);
    freq.put("İd", 37);
    freq.put("İk", 106);
    freq.put("İh", 28);
    freq.put("İn", 467);
    freq.put("İl", 232);
    freq.put("İm", 49);
    freq.put("osy", 131);
    freq.put("lr ", 54);
    freq.put("osp", 74);
    freq.put("oss", 26);
    freq.put("osu", 634);
    freq.put("ost", 474);
    freq.put("şkı", 201);
    freq.put("osk", 32);
    freq.put("osm", 39);
    freq.put("oso", 26);
    freq.put("osa", 122);
    freq.put("ose", 57);
    freq.put("osg", 26);
    freq.put("üba", 98);
    freq.put("ıp", 1008);
    freq.put("ıs", 2368);
    freq.put("ır", 7377);
    freq.put("übe", 37);
    freq.put("ıt", 478);
    freq.put("ıv", 127);
    freq.put("ıy", 5489);
    freq.put("ız", 4763);
    freq.put("vey", 148);
    freq.put("ıc", 1055);
    freq.put("ıb", 139);
    freq.put("ıd", 709);
    freq.put("ıg", 247);
    freq.put("ıf", 200);
    freq.put("ven", 391);
    freq.put("ıh", 67);
    freq.put("ık", 6691);
    freq.put("vem", 31);
    freq.put("ım", 10418);
    freq.put("ıl", 6078);
    freq.put("ıo", 167);
    freq.put("ın", 18610);
    freq.put("lri", 26);
    freq.put("Mü", 218);
    freq.put("Tat", 60);
    freq.put("Tar", 133);
    freq.put("Tay", 57);
    freq.put("ı ", 21159);
    freq.put("Tab", 57);
    freq.put("Tam", 146);
    freq.put("Tan", 121);
    freq.put("Tah", 26);
    freq.put("Tak", 186);
    freq.put("bd", 75);
    freq.put("M ", 507);
    freq.put("şar", 903);
    freq.put("ıkm", 328);
    freq.put("sı", 9250);
    freq.put("ıç", 175);
    freq.put("biç", 42);
    freq.put("übü", 55);
    freq.put("Me", 871);
    freq.put("Ma", 778);
    freq.put("ydi", 853);
    freq.put("Mo", 206);
    freq.put("yde", 158);
    freq.put("Mi", 308);
    freq.put("yda", 219);
    freq.put("Mu", 377);
    freq.put("uff", 35);
    freq.put("ydu", 341);
    freq.put("İM ", 56);
    freq.put("şk ", 283);
    freq.put("ipa", 35);
    freq.put("ipe", 46);
    freq.put("iph", 42);
    freq.put("ipi", 52);
    freq.put("ipn", 28);
    freq.put("ipl", 179);
    freq.put("ips", 45);
    freq.put("ipt", 129);
    freq.put("yga", 31);
    freq.put("şai", 30);
    freq.put("şah", 101);
    freq.put("şka", 751);
    freq.put("ip ", 1644);
    freq.put("şke", 233);
    freq.put("şki", 147);
    freq.put("şkl", 34);
    freq.put("ığ", 2143);
    freq.put("şku", 32);
    freq.put("şkt", 34);
    freq.put("ıı", 721);
    freq.put("sü", 1192);
    freq.put("ygu", 326);
    freq.put("ipç", 67);
    freq.put("Mı", 33);
    freq.put("ydı", 816);
    freq.put("s ", 5013);
    freq.put("sy", 790);
    freq.put("ss", 1083);
    freq.put("sr", 282);
    freq.put("sp", 784);
    freq.put("sv", 115);
    freq.put("su", 6154);
    freq.put("Mec", 45);
    freq.put("sk", 1689);
    freq.put("sj", 52);
    freq.put("si", 16073);
    freq.put("sh", 294);
    freq.put("so", 4903);
    freq.put("sn", 430);
    freq.put("sm", 1311);
    freq.put("sl", 2181);
    freq.put("sc", 153);
    freq.put("sb", 78);
    freq.put("sa", 16310);
    freq.put("sg", 74);
    freq.put("sf", 181);
    freq.put("se", 13975);
    freq.put("sd", 134);
    freq.put("KA ", 60);
    freq.put("ttp", 53);
    freq.put("ttu", 189);
    freq.put("ttt", 41);
    freq.put("tti", 1639);
    freq.put("Kam", 38);
    freq.put("ttl", 26);
    freq.put("tta", 421);
    freq.put("tte", 915);
    freq.put("jin", 61);
    freq.put("jim", 42);
    freq.put("jik", 40);
    freq.put("jis", 38);
    freq.put("rzı", 35);
    freq.put("Ç", 1130);
    freq.put("ğüm", 91);
    freq.put("nsf", 133);
    freq.put("Kaz", 67);
    freq.put("tt ", 131);
    freq.put("meğ", 101);
    freq.put("LI ", 40);
    freq.put("ji ", 105);
    freq.put("", 92);
    freq.put("mlı", 97);
    freq.put("blo", 108);
    freq.put("hce", 106);
    freq.put("ble", 132);
    freq.put("bla", 192);
    freq.put("ova", 133);
    freq.put("sağ", 337);
    freq.put("onk", 26);
    freq.put("oni", 117);
    freq.put("ono", 99);
    freq.put("onl", 787);
    freq.put("onm", 32);
    freq.put("onb", 45);
    freq.put("onc", 193);
    freq.put("ona", 632);
    freq.put("saç", 217);
    freq.put("ong", 57);
    freq.put("ond", 507);
    freq.put("one", 384);
    freq.put("██", 35);
    freq.put("ony", 120);
    freq.put("onr", 1265);
    freq.put("ons", 322);
    freq.put("ont", 151);
    freq.put("onu", 3026);
    freq.put("rz ", 57);
    freq.put("uku", 147);
    freq.put("ukt", 149);
    freq.put("uks", 58);
    freq.put("ukl", 574);
    freq.put("ukk", 64);
    freq.put("uki", 36);
    freq.put("uke", 51);
    freq.put("uka", 135);
    freq.put(" Zo", 51);
    freq.put(" Zi", 65);
    freq.put(" Ze", 69);
    freq.put("on ", 2166);
    freq.put(" Za", 227);
    freq.put("Öyl", 66);
    freq.put("rza", 37);
    freq.put("vek", 45);
    freq.put("rzi", 28);
    freq.put("rzu", 29);
    freq.put("uk ", 1318);
    freq.put("sak", 643);
    freq.put("saj", 256);
    freq.put("sai", 63);
    freq.put("sah", 557);
    freq.put("sao", 60);
    freq.put("san", 4376);
    freq.put("sam", 824);
    freq.put("sal", 875);
    freq.put("sac", 130);
    freq.put("sab", 692);
    freq.put("saa", 678);
    freq.put("sag", 140);
    freq.put("saf", 130);
    freq.put("sad", 690);
    freq.put("say", 1185);
    freq.put("sas", 179);
    freq.put("sar", 1021);
    freq.put("sap", 219);
    freq.put("sav", 257);
    freq.put("sat", 428);
    freq.put("zon", 408);
    freq.put("cuğ", 124);
    freq.put("zor", 517);
    freq.put("ukç", 33);
    freq.put("sa ", 2297);
    freq.put("meş", 42);
    freq.put("İR ", 82);
    freq.put("sdf", 28);
    freq.put("YE ", 35);
    freq.put("oğm", 29);
    freq.put("ülü", 295);
    freq.put("uy", 5382);
    freq.put("uz", 4491);
    freq.put("uu", 597);
    freq.put(" bö", 776);
    freq.put(" bü", 771);
    freq.put("uv", 302);
    freq.put("up", 956);
    freq.put("NE ", 51);
    freq.put("cil", 465);
    freq.put("ülk", 254);
    freq.put("um", 10383);
    freq.put(" b ", 79);
    freq.put("ülm", 192);
    freq.put("üll", 79);
    freq.put("ıgı", 197);
    freq.put("üld", 181);
    freq.put("vki", 27);
    freq.put("un", 14015);
    freq.put("vkl", 39);
    freq.put("ült", 79);
    freq.put("çin", 2175);
    freq.put("Düş", 68);
    freq.put("ud", 776);
    freq.put("ciy", 116);
    freq.put(" be", 8829);
    freq.put(" ba", 8227);
    freq.put(" bb", 32);
    freq.put(" bl", 126);
    freq.put(" bo", 1686);
    freq.put("ül ", 371);
    freq.put(" bi", 15594);
    freq.put(" bk", 37);
    freq.put(" bj", 34);
    freq.put(" bu", 7732);
    freq.put("rü", 1635);
    freq.put("s", 91232);
    freq.put(" br", 140);
    freq.put("vk ", 34);
    freq.put(" by", 37);
    freq.put("yze", 57);
    freq.put("fin", 193);
    freq.put("ive", 194);
    freq.put("iva", 148);
    freq.put("şe ", 241);
    freq.put("ivi", 122);
    freq.put("ivr", 54);
    freq.put("bü ", 38);
    freq.put(" bı", 942);
    freq.put("IR ", 39);
    freq.put("vus", 28);
    freq.put("şek", 565);
    freq.put("şeh", 231);
    freq.put("şen", 155);
    freq.put("şem", 149);
    freq.put("şel", 49);
    freq.put("I", 752);
    freq.put("şeb", 35);
    freq.put("şey", 1700);
    freq.put(" gu", 1145);
    freq.put("şes", 31);
    freq.put("şer", 178);
    freq.put("şet", 40);
    freq.put("büm", 111);
    freq.put("bül", 32);
    freq.put("bün", 72);
    freq.put("bük", 26);
    freq.put("DI ", 32);
    freq.put("Şik", 42);
    freq.put(" ıc", 67);
    freq.put("büy", 502);
    freq.put("Şim", 119);
    freq.put("büt", 205);
    freq.put("Dün", 210);
    freq.put("büs", 95);
    freq.put("bür", 34);
    freq.put("gde", 62);
    freq.put("hız", 88);
    freq.put("hır", 65);
    freq.put("hım", 96);
    freq.put("hın", 68);
    freq.put("hıc", 33);
    freq.put("ssı", 59);
    freq.put(" go", 1141);
    freq.put("NA ", 53);
    freq.put("hı ", 51);
    freq.put(" gi", 4814);
    freq.put("ezz", 41);
    freq.put("ezu", 49);
    freq.put("ezs", 168);
    freq.put("ezl", 80);
    freq.put("ezm", 78);
    freq.put("İle", 37);
    freq.put("ezo", 191);
    freq.put("ezi", 266);
    freq.put("ezd", 113);
    freq.put("eze", 249);
    freq.put("İlk", 93);
    freq.put("eza", 297);
    freq.put("ezb", 29);
    freq.put("ac ", 222);
    freq.put("ddi", 314);
    freq.put("Hoş", 40);
    freq.put("dda", 84);
    freq.put("aş", 6601);
    freq.put("aı", 32);
    freq.put("ez ", 975);
    freq.put("tv ", 189);
    freq.put("acc", 27);
    freq.put("aca", 2702);
    freq.put("ace", 469);
    freq.put("ack", 104);
    freq.put("aci", 559);
    freq.put("ach", 32);
    freq.put("acm", 99);
    freq.put("acl", 85);
    freq.put("acu", 30);
    freq.put("act", 69);
    freq.put("ağ", 3036);
    freq.put("Ni", 207);
    freq.put("aç", 2865);
    freq.put("No", 104);
    freq.put("Na", 270);
    freq.put("bjk", 33);
    freq.put("Ne", 864);
    freq.put("Nu", 72);
    freq.put("hev", 30);
    freq.put("hep", 792);
    freq.put("her", 2097);
    freq.put("hes", 226);
    freq.put("hey", 212);
    freq.put("hed", 132);
    freq.put("hee", 73);
    freq.put("hec", 27);
    freq.put("hel", 186);
    freq.put("hem", 571);
    freq.put("hen", 160);
    freq.put("heh", 188);
    freq.put("N ", 718);
    freq.put("he ", 315);
    freq.put("aa", 3257);
    freq.put("ac", 5430);
    freq.put("ab", 6622);
    freq.put("ae", 81);
    freq.put("Hoc", 65);
    freq.put("ag", 1230);
    freq.put("af", 2978);
    freq.put("ai", 907);
    freq.put("ah", 8696);
    freq.put("Hol", 26);
    freq.put("aj", 553);
    freq.put("am", 18347);
    freq.put("al", 20176);
    freq.put("ao", 159);
    freq.put("an", 39344);
    freq.put("aq", 53);
    freq.put("ap", 6071);
    freq.put("as", 11506);
    freq.put("ar", 41453);
    freq.put("au", 131);
    freq.put("at", 11337);
    freq.put("aw", 72);
    freq.put("av", 2712);
    freq.put("ay", 16801);
    freq.put("ax", 44);
    freq.put("az", 8503);
    freq.put("ğ", 15849);
    freq.put("aL", 32);
    freq.put("acı", 972);
    freq.put("a ", 50600);
    freq.put("oh ", 51);
    freq.put("rv", 337);
    freq.put("agu", 32);
    freq.put("at ", 2088);
    freq.put("AZ ", 26);
    freq.put("sci", 32);
    freq.put("sca", 38);
    freq.put("mnu", 44);
    freq.put("mni", 33);
    freq.put(" a", 28785);
    freq.put("Fil", 101);
    freq.put("gök", 59);
    freq.put("zmi", 285);
    freq.put("gön", 268);
    freq.put("göl", 39);
    freq.put("göm", 41);
    freq.put("tv", 311);
    freq.put("tw", 732);
    freq.put("tt", 4008);
    freq.put("zma", 347);
    freq.put("tr", 1336);
    freq.put("ts", 897);
    freq.put("tp", 67);
    freq.put("zme", 208);
    freq.put("göz", 544);
    freq.put("to", 2426);
    freq.put("tl", 3583);
    freq.put("tm", 3395);
    freq.put("tk", 348);
    freq.put("th", 358);
    freq.put("ti", 10868);
    freq.put("gör", 1582);
    freq.put("gös", 209);
    freq.put("td", 57);
    freq.put("te", 12606);
    freq.put("tb", 463);
    freq.put("viş", 65);
    freq.put(" dı", 394);
    freq.put("ta", 14730);
    freq.put("smi", 299);
    freq.put("rc", 1119);
    freq.put("mn ", 59);
    freq.put("sme", 338);
    freq.put("zm ", 66);
    freq.put("eçt", 195);
    freq.put("eçi", 407);
    freq.put("rj", 148);
    freq.put("eçm", 284);
    freq.put("t ", 9042);
    freq.put(" w", 371);
    freq.put("tü", 2353);
    freq.put("tö", 148);
    freq.put("tç", 169);
    freq.put("tş", 28);
    freq.put("via", 239);
    freq.put("vid", 122);
    freq.put("vik", 33);
    freq.put("vin", 372);
    freq.put("vil", 139);
    freq.put("vim", 119);
    freq.put("vir", 162);
    freq.put("vis", 121);
    freq.put("viv", 33);
    freq.put("vit", 89);
    freq.put("viz", 114);
    freq.put("viy", 390);
    freq.put("ünm", 175);
    freq.put("ünl", 378);
    freq.put("üni", 91);
    freq.put("ünk", 338);
    freq.put("üne", 613);
    freq.put("ünd", 857);
    freq.put("üna", 273);
    freq.put("ünc", 205);
    freq.put(" d ", 116);
    freq.put("ökh", 29);
    freq.put("üny", 485);
    freq.put("VE ", 42);
    freq.put("ünt", 62);
    freq.put("öke", 35);
    freq.put("üns", 50);
    freq.put("vi ", 196);
    freq.put(" do", 2118);
    freq.put("kle", 2449);
    freq.put(" dm", 45);
    freq.put(" dk", 116);
    freq.put("kla", 2577);
    freq.put(" di", 4970);
    freq.put(" de", 12304);
    freq.put("ün ", 2462);
    freq.put(" da", 6776);
    freq.put("tı", 7051);
    freq.put("klu", 203);
    freq.put("ök ", 28);
    freq.put(" du", 2190);
    freq.put("zmı", 154);
    freq.put(" dr", 45);
    freq.put("viç", 29);
    freq.put("ökü", 79);
    freq.put("ünü", 1160);
    freq.put("atr", 100);
    freq.put("ats", 218);
    freq.put(" dü", 1957);
    freq.put("klü", 70);
    freq.put(" dö", 709);
    freq.put("ito", 30);
    freq.put("itl", 270);
    freq.put("itm", 569);
    freq.put("ith", 40);
    freq.put("iti", 677);
    freq.put("ite", 572);
    freq.put("itc", 33);
    freq.put("ita", 520);
    freq.put("ity", 47);
    freq.put("itv", 29);
    freq.put("itt", 991);
    freq.put("itu", 31);
    freq.put("itr", 37);
    freq.put("its", 165);
    freq.put("İnş", 31);
    freq.put("rış", 325);
    freq.put("ar ", 11433);
    freq.put("Kıs", 42);
    freq.put("Kır", 50);
    freq.put("Kıv", 29);
    freq.put(" Aç", 97);
    freq.put("şge", 50);
    freq.put("Kız", 100);
    freq.put("it ", 835);
    freq.put("aaş", 30);
    freq.put("Kıl", 46);
    freq.put("eva", 685);
    freq.put(" A ", 146);
    freq.put("tre", 212);
    freq.put("yış", 34);
    freq.put("fta", 889);
    freq.put("fte", 85);
    freq.put("fti", 36);
    freq.put(" Aa", 30);
    freq.put(" Ab", 152);
    freq.put(" Ac", 119);
    freq.put(" Ad", 331);
    freq.put(" Af", 106);
    freq.put(" Ag", 43);
    freq.put(" Ah", 194);
    freq.put(" Ai", 51);
    freq.put("sıı", 32);
    freq.put(" Ak", 340);
    freq.put(" Al", 1139);
    freq.put(" Am", 441);
    freq.put(" An", 703);
    freq.put(" Ap", 69);
    freq.put(" Ar", 735);
    freq.put(" As", 248);
    freq.put(" At", 244);
    freq.put(" Av", 198);
    freq.put(" Ay", 473);
    freq.put(" Az", 147);
    freq.put("sığ", 44);
    freq.put("ft ", 62);
    freq.put("w", 2186);
    freq.put("Fra", 75);
    freq.put("rır", 121);
    freq.put("rıs", 213);
    freq.put("rıp", 61);
    freq.put("İns", 206);
    freq.put("rız", 179);
    freq.put("İnt", 53);
    freq.put("rıy", 433);
    freq.put("rıd", 91);
    freq.put("rıc", 146);
    freq.put("rın", 2822);
    freq.put("rıl", 509);
    freq.put("rım", 1772);
    freq.put("sıç", 45);
    freq.put("rık", 84);
    freq.put("İng", 47);
    freq.put("jes", 42);
    freq.put("", 101);
    freq.put("aa ", 876);
    freq.put("jen", 26);
    freq.put("küç", 153);
    freq.put("rı ", 2412);
    freq.put("aad", 33);
    freq.put("aaa", 874);
    freq.put("aam", 54);
    freq.put("aal", 115);
    freq.put("aan", 93);
    freq.put("aah", 57);
    freq.put("LU ", 29);
    freq.put("aat", 793);
    freq.put("je ", 40);
    freq.put("aar", 52);
    freq.put("aay", 41);
    freq.put("sız", 619);
    freq.put("sıy", 214);
    freq.put("sır", 389);
    freq.put("sıt", 40);
    freq.put("sık", 498);
    freq.put("kü ", 362);
    freq.put("sın", 3825);
    freq.put("sım", 220);
    freq.put("sıl", 866);
    freq.put("sıc", 101);
    freq.put("sıf", 49);
    freq.put("sıd", 60);
    freq.put("yım", 705);
    freq.put("yıl", 849);
    freq.put("yın", 890);
    freq.put("ex ", 74);
    freq.put("tp ", 52);
    freq.put("yıf", 29);
    freq.put("yıc", 31);
    freq.put("yıy", 36);
    freq.put("yız", 169);
    freq.put("yıt", 38);
    freq.put("yıp", 252);
    freq.put("yıs", 93);
    freq.put(" Ağ", 171);
    freq.put("kür", 418);
    freq.put("küs", 64);
    freq.put("M", 3308);
    freq.put("küz", 36);
    freq.put("Ist", 84);
    freq.put("küf", 113);
    freq.put("kül", 93);
    freq.put("küm", 105);
    freq.put("kün", 100);
    freq.put("sı ", 2118);
    freq.put("â", 201);
    freq.put("yı ", 1134);
    freq.put("Aşk", 126);
    freq.put(" Aş", 161);
    freq.put("Hah", 42);
    freq.put("Hak", 123);
    freq.put("Hal", 124);
    freq.put("Ham", 52);
    freq.put("Han", 131);
    freq.put("Hab", 142);
    freq.put("Had", 109);
    freq.put("Haf", 48);
    freq.put("seç", 177);
    freq.put("Hay", 485);
    freq.put("Haz", 50);
    freq.put("oje", 108);
    freq.put("ugr", 64);
    freq.put("Har", 75);
    freq.put("Has", 88);
    freq.put("Hat", 70);
    freq.put("Hav", 81);
    freq.put("oji", 120);
    freq.put("rf ", 85);
    freq.put("Ha ", 26);
    freq.put("ğü", 411);
    freq.put("cre", 99);
    freq.put("rfo", 30);
    freq.put("Fot", 39);
    freq.put("sev", 2161);
    freq.put("set", 260);
    freq.put("ses", 594);
    freq.put("ser", 625);
    freq.put("For", 55);
    freq.put("sep", 31);
    freq.put("sez", 195);
    freq.put("sey", 991);
    freq.put("sef", 250);
    freq.put("see", 32);
    freq.put("lış", 850);
    freq.put("sec", 83);
    freq.put("seb", 172);
    freq.put("ugü", 626);
    freq.put("sen", 4214);
    freq.put("sem", 519);
    freq.put("sel", 773);
    freq.put("sek", 547);
    freq.put("seh", 76);
    freq.put(" fı", 205);
    freq.put("ğ ", 207);
    freq.put("ue ", 72);
    freq.put("se ", 1899);
    freq.put("ğz", 112);
    freq.put("ğu", 1793);
    freq.put("ğr", 1271);
    freq.put("ğo", 96);
    freq.put("ğn", 59);
    freq.put("ğm", 300);
    freq.put("ğl", 1199);
    freq.put("ği", 4991);
    freq.put("ğe", 975);
    freq.put("ğd", 163);
    freq.put("ğa", 728);
    freq.put("od ", 61);
    freq.put("nri", 31);
    freq.put("nra", 1270);
    freq.put("Ola", 80);
    freq.put("mla", 956);
    freq.put("Old", 33);
    freq.put("mle", 990);
    freq.put("mli", 315);
    freq.put("Olm", 73);
    freq.put("Ols", 51);
    freq.put("Olu", 54);
    freq.put("mlu", 98);
    freq.put("ğğ", 70);
    freq.put("ami", 815);
    freq.put("vol", 66);
    freq.put("vor", 45);
    freq.put("aml", 624);
    freq.put("amo", 29);
    freq.put("lül", 259);
    freq.put("ğı", 3385);
    freq.put("amc", 79);
    freq.put("amb", 143);
    freq.put("vo ", 32);
    freq.put("kno", 46);
    freq.put(" fr", 108);
    freq.put(" fu", 351);
    freq.put("kni", 67);
    freq.put("Sok", 37);
    freq.put("Som", 113);
    freq.put("Son", 333);
    freq.put(" fa", 1932);
    freq.put("Sos", 31);
    freq.put("Sor", 85);
    freq.put(" fe", 736);
    freq.put(" fi", 992);
    freq.put(" fl", 67);
    freq.put(" fo", 635);
    freq.put("uğ", 1489);
    freq.put("İsl", 37);
    freq.put("O ", 515);
    freq.put("amp", 412);
    freq.put("İsr", 83);
    freq.put("İsp", 51);
    freq.put("ciğ", 34);
    freq.put("İst", 388);
    freq.put("On", 221);
    freq.put("uş", 1959);
    freq.put("Ol", 332);
    freq.put("Ok", 171);
    freq.put("Oh", 68);
    freq.put("Of", 81);
    freq.put("Od", 37);
    freq.put("ıkç", 62);
    freq.put("bö", 781);
    freq.put("Oz", 56);
    freq.put("Oy", 105);
    freq.put("bü", 1134);
    freq.put("Ot", 84);
    freq.put("Os", 56);
    freq.put("ıkö", 51);
    freq.put("Op", 40);
    freq.put("söl", 26);
    freq.put("d", 104396);
    freq.put("söz", 407);
    freq.put("söy", 678);
    freq.put("söv", 30);
    freq.put("lp ", 73);
    freq.put("b ", 365);
    freq.put("ık ", 2985);
    freq.put("tçe", 26);
    freq.put("tçi", 76);
    freq.put("agı", 110);
    freq.put("ıkk", 54);
    freq.put("be", 11706);
    freq.put("şat", 46);
    freq.put("şas", 41);
    freq.put("ba", 11904);
    freq.put("bb", 236);
    freq.put("ıkl", 954);
    freq.put("bl", 513);
    freq.put("bm", 32);
    freq.put("ıka", 749);
    freq.put("bo", 2739);
    freq.put("bi", 21917);
    freq.put("bj", 45);
    freq.put("bk", 44);
    freq.put("bu", 8998);
    freq.put("şad", 62);
    freq.put("şac", 61);
    freq.put("şab", 41);
    freq.put("br", 575);
    freq.put("bs", 67);
    freq.put("ıks", 109);
    freq.put("şan", 447);
    freq.put("şam", 726);
    freq.put("şal", 256);
    freq.put("şak", 156);
    freq.put("by", 117);
    freq.put("bz", 249);
    freq.put("ıkt", 532);
    freq.put("Osm", 36);
    freq.put("DE ", 69);
    freq.put(" C ", 63);
    freq.put("ci ", 797);
    freq.put("Oğ", 28);
    freq.put("u ", 16148);
    freq.put("Fe", 630);
    freq.put(" Ch", 101);
    freq.put(" Ci", 147);
    freq.put(" Co", 216);
    freq.put(" Cl", 35);
    freq.put(" Ca", 441);
    freq.put(" Ce", 302);
    freq.put(" Cr", 28);
    freq.put(" Cu", 158);
    freq.put("cic", 63);
    freq.put("cia", 36);
    freq.put("cig", 35);
    freq.put("cid", 222);
    freq.put("cik", 547);
    freq.put("ut", 3226);
    freq.put("cih", 107);
    freq.put("cin", 731);
    freq.put("cim", 268);
    freq.put("ur", 9172);
    freq.put("cis", 162);
    freq.put("ul", 5881);
    freq.put("uo", 89);
    freq.put("cip", 44);
    freq.put("ui", 65);
    freq.put("uh", 699);
    freq.put("uk", 2672);
    freq.put("cit", 39);
    freq.put("ue", 213);
    freq.put("ciz", 52);
    freq.put("ug", 1468);
    freq.put("uf", 219);
    freq.put("ua", 664);
    freq.put("uc", 1033);
    freq.put("ub", 392);
    freq.put("bı", 1525);
    freq.put("ıkı", 694);
    freq.put("şağ", 72);
    freq.put("ag ", 49);
    freq.put("tçı", 51);
    freq.put("Dİ ", 28);
    freq.put("ago", 70);
    freq.put("agm", 105);
    freq.put("agl", 175);
    freq.put("agi", 308);
    freq.put("şaş", 128);
    freq.put("age", 46);
    freq.put("aga", 151);
    freq.put("çbi", 164);
    freq.put("agz", 29);
    freq.put("rüp", 32);
    freq.put("uç", 526);
    freq.put("agr", 67);
    freq.put("pul", 34);
    freq.put("ev ", 225);
    freq.put("tr ", 38);
    freq.put(" Wa", 42);
    freq.put("ziğ", 59);
    freq.put(" şı", 40);
    freq.put("boş", 272);
    freq.put("Öze", 63);
    freq.put("Özd", 34);
    freq.put("tri", 238);
    freq.put("evi", 1265);
    freq.put("evk", 118);
    freq.put("evl", 532);
    freq.put("evm", 304);
    freq.put("tro", 208);
    freq.put("tra", 517);
    freq.put("rdü", 414);
    freq.put("evc", 31);
    freq.put("evd", 573);
    freq.put("eve", 1104);
    freq.put("evg", 564);
    freq.put("evz", 36);
    freq.put("evr", 214);
    freq.put("evs", 73);
    freq.put("evv", 34);
    freq.put("le ", 6624);
    freq.put("lığ", 725);
    freq.put("odr", 73);
    freq.put("uef", 53);
    freq.put("odu", 296);
    freq.put("Blo", 28);
    freq.put("odo", 37);
    freq.put("oda", 329);
    freq.put("Bla", 30);
    freq.put("ode", 146);
    freq.put("lıı", 37);
    freq.put("rd ", 65);
    freq.put("Çek", 48);
    freq.put("Çel", 27);
    freq.put("leb", 169);
    freq.put("lec", 554);
    freq.put("led", 901);
    freq.put("lee", 111);
    freq.put("lef", 319);
    freq.put("leg", 48);
    freq.put("lek", 429);
    freq.put("lel", 179);
    freq.put("lem", 1759);
    freq.put("len", 2268);
    freq.put("lep", 31);
    freq.put("ler", 11439);
    freq.put("les", 613);
    freq.put("let", 1056);
    freq.put("lev", 105);
    freq.put("lex", 58);
    freq.put("ley", 1113);
    freq.put("lez", 36);
    freq.put("rdu", 1053);
    freq.put("ğre", 487);
    freq.put("ğra", 302);
    freq.put("rde", 2061);
    freq.put("cte", 32);
    freq.put("rda", 2051);
    freq.put("cta", 36);
    freq.put("rdo", 207);
    freq.put("ğru", 350);
    freq.put("rdi", 1755);
    freq.put("cti", 113);
    freq.put(" şu", 619);
    freq.put(" şo", 96);
    freq.put(" şi", 1039);
    freq.put(" şe", 1667);
    freq.put(" şa", 1148);
    freq.put("zit", 29);
    freq.put("zir", 137);
    freq.put("zis", 127);
    freq.put("zip", 33);
    freq.put("ziz", 136);
    freq.put("ziy", 246);
    freq.put(" şö", 75);
    freq.put("zid", 55);
    freq.put("zin", 700);
    freq.put("evı", 28);
    freq.put("zil", 214);
    freq.put("zim", 640);
    freq.put("zik", 254);
    freq.put("zih", 51);
    freq.put("on", 10073);
    freq.put("İna", 37);
    freq.put(" Dü", 330);
    freq.put("zi ", 1109);
    freq.put("lıç", 50);
    freq.put(" şü", 101);
    freq.put("tük", 91);
    freq.put("tün", 489);
    freq.put("tüm", 334);
    freq.put("tül", 92);
    freq.put("tüs", 51);
    freq.put("tür", 690);
    freq.put("tüy", 49);
    freq.put("rdı", 1353);
    freq.put("İnc", 47);
    freq.put("lı ", 2168);
    freq.put("leğ", 74);
    freq.put("afl", 129);
    freq.put("tü ", 442);
    freq.put("npi", 54);
    freq.put("npa", 50);
    freq.put("Q", 42);
    freq.put("lıy", 1003);
    freq.put("Onl", 55);
    freq.put("lıt", 29);
    freq.put("Ona", 30);
    freq.put("lıp", 140);
    freq.put("lır", 444);
    freq.put("lıs", 308);
    freq.put("lıl", 175);
    freq.put("lım", 1000);
    freq.put("lın", 810);
    freq.put("lıo", 34);
    freq.put("lık", 1412);
    freq.put("lıd", 59);
    freq.put("lıg", 52);
    freq.put("aff", 91);
    freq.put("leş", 367);
    freq.put("mı ", 2123);
    freq.put("Ayn", 91);
    freq.put("Ayk", 31);
    freq.put("vmi", 72);
    freq.put("Ayd", 64);
    freq.put("vme", 266);
    freq.put("Aya", 38);
    freq.put("zg", 508);
    freq.put("Ayr", 71);
    freq.put("ÜN ", 26);
    freq.put("kp ", 37);
    freq.put(" h ", 47);
    freq.put("üjd", 30);
    freq.put("mıc", 36);
    freq.put("mıd", 60);
    freq.put("mım", 82);
    freq.put("Ay ", 39);
    freq.put("mıo", 29);
    freq.put("mın", 654);
    freq.put("mıs", 352);
    freq.put("kıp", 152);
    freq.put("mıy", 868);
    freq.put("mız", 991);
    freq.put("lze", 27);
    freq.put("Sak", 54);
    freq.put("Sah", 65);
    freq.put("San", 245);
    freq.put("Sam", 99);
    freq.put("Sal", 70);
    freq.put("", 96);
    freq.put("Sab", 175);
    freq.put("Saa", 63);
    freq.put(" hu", 260);
    freq.put("Sad", 92);
    freq.put(" hi", 1550);
    freq.put(" ho", 653);
    freq.put(" hm", 51);
    freq.put("ğın", 972);
    freq.put("Sar", 126);
    freq.put(" ha", 8019);
    freq.put("ğrı", 114);
    freq.put("ğım", 738);
    freq.put(" he", 4302);
    freq.put("Sat", 31);
    freq.put("zc", 266);
    freq.put("bı ", 344);
    freq.put("nçl", 143);
    freq.put(" Eğ", 104);
    freq.put("baa", 48);
    freq.put("bıd", 29);
    freq.put("nç ", 315);
    freq.put(" hü", 141);
    freq.put("bın", 114);
    freq.put("bıl", 141);
    freq.put("bım", 53);
    freq.put("Saç", 32);
    freq.put("bık", 45);
    freq.put("ğız", 116);
    freq.put("bıt", 28);
    freq.put(" Eş", 26);
    freq.put("bır", 620);
    freq.put("kım", 581);
    freq.put("bız", 44);
    freq.put("bıy", 32);
    freq.put("iht", 231);
    freq.put("mıı", 28);
    freq.put("ihi", 179);
    freq.put("Sağ", 61);
    freq.put("ihl", 39);
    freq.put("iha", 300);
    freq.put(" hı", 269);
    freq.put("cı ", 679);
    freq.put("UN ", 48);
    freq.put("lüğ", 101);
    freq.put("ih ", 247);
    freq.put("Ayı", 35);
    freq.put("cık", 309);
    freq.put("lız", 35);
    freq.put("cım", 171);
    freq.put("cıl", 394);
    freq.put("cıd", 29);
    freq.put("cıy", 85);
    freq.put("cıs", 125);
    freq.put("cır", 36);
    freq.put("mış", 1631);
    freq.put("cıt", 30);
    freq.put(" E ", 85);
    freq.put("ck ", 170);
    freq.put(" El", 220);
    freq.put(" Em", 171);
    freq.put(" En", 298);
    freq.put(" Ek", 135);
    freq.put(" Ed", 115);
    freq.put(" Ee", 33);
    freq.put(" Ef", 46);
    freq.put(" Eg", 44);
    freq.put(" Eb", 40);
    freq.put(" Ec", 28);
    freq.put(" Ey", 268);
    freq.put(" Ez", 29);
    freq.put(" Et", 66);
    freq.put(" Eu", 31);
    freq.put(" Ev", 306);
    freq.put(" Er", 492);
    freq.put(" Es", 195);
    freq.put("AA ", 54);
    freq.put("cki", 26);
    freq.put("cks", 38);
    freq.put("lıc", 142);
    freq.put("gıd", 48);
    freq.put("gıc", 37);
    freq.put("Şu ", 98);
    freq.put("lgı", 78);
    freq.put("ğlı", 231);
    freq.put("jan", 76);
    freq.put("ıc ", 36);
    freq.put("oğu", 423);
    freq.put("gıy", 35);
    freq.put("cı", 2151);
    freq.put("çli", 63);
    freq.put("irc", 103);
    freq.put("çla", 290);
    freq.put("çle", 126);
    freq.put("gır", 64);
    freq.put("etç", 68);
    freq.put("şi ", 490);
    freq.put("çlu", 59);
    freq.put("Pr", 134);
    freq.put("Pu", 34);
    freq.put("oma", 349);
    freq.put("Pa", 485);
    freq.put("Pe", 231);
    freq.put("Ph", 54);
    freq.put("Pi", 102);
    freq.put("Po", 224);
    freq.put("Pl", 77);
    freq.put("et ", 3504);
    freq.put("tl ", 69);
    freq.put("vş", 73);
    freq.put("vı", 158);
    freq.put("P ", 340);
    freq.put("etr", 200);
    freq.put("ets", 264);
    freq.put("etv", 27);
    freq.put("etw", 43);
    freq.put("ett", 1276);
    freq.put("tsi", 303);
    freq.put("etb", 63);
    freq.put("etc", 38);
    freq.put("tla", 1092);
    freq.put("eta", 124);
    freq.put("çlü", 56);
    freq.put("tle", 1024);
    freq.put("lo", 1180);
    freq.put("etk", 191);
    freq.put("eth", 36);
    freq.put("eti", 1990);
    freq.put("eto", 50);
    freq.put("etl", 646);
    freq.put("etm", 1456);
    freq.put("ck", 350);
    freq.put("ci", 4010);
    freq.put("ch", 307);
    freq.put("co", 1681);
    freq.put("cn", 160);
    freq.put("Her", 494);
    freq.put("cl", 290);
    freq.put("cc", 92);
    freq.put("cb", 75);
    freq.put("ca", 8317);
    freq.put("Hey", 39);
    freq.put("ce", 9178);
    freq.put("cd", 104);
    freq.put("uce", 27);
    freq.put("uca", 295);
    freq.put("cs", 41);
    freq.put("cr", 196);
    freq.put("li", 17659);
    freq.put("vü", 106);
    freq.put("cv", 33);
    freq.put("cu", 2192);
    freq.put("ct", 265);
    freq.put("Ger", 158);
    freq.put("zgü", 169);
    freq.put("Gec", 111);
    freq.put("çlı", 97);
    freq.put("Gen", 138);
    freq.put("güç", 77);
    freq.put("lgi", 652);
    freq.put(" Ça", 202);
    freq.put("lga", 85);
    freq.put("lge", 156);
    freq.put("uc ", 60);
    freq.put("unt", 50);
    freq.put("ğlu", 366);
    freq.put("cvp", 28);
    freq.put("ğla", 436);
    freq.put("ğle", 152);
    freq.put("rbi", 286);
    freq.put("rbe", 112);
    freq.put("eur", 41);
    freq.put("rba", 657);
    freq.put("va", 7015);
    freq.put("vb", 48);
    freq.put("vc", 125);
    freq.put("vd", 691);
    freq.put("ve", 8171);
    freq.put("vg", 630);
    freq.put("vi", 2376);
    freq.put("vk", 121);
    freq.put("vl", 643);
    freq.put("vm", 382);
    freq.put("vo", 205);
    freq.put("vp", 31);
    freq.put("vr", 687);
    freq.put("vs", 324);
    freq.put("vu", 807);
    freq.put("vv", 112);
    freq.put("cü", 415);
    freq.put("vy", 54);
    freq.put("vz", 41);
    freq.put("güz", 1198);
    freq.put("etı", 43);
    freq.put("gür", 127);
    freq.put("güt", 36);
    freq.put("zgu", 44);
    freq.put("güv", 128);
    freq.put("zgi", 73);
    freq.put("gül", 403);
    freq.put("güm", 38);
    freq.put("gün", 2416);
    freq.put("zga", 83);
    freq.put("güc", 78);
    freq.put("zge", 118);
    freq.put("v ", 748);
    freq.put("pho", 62);
    freq.put("şii", 62);
    freq.put("Lan", 44);
    freq.put("phe", 76);
    freq.put("off", 157);
    freq.put("ofe", 27);
    freq.put("ofi", 117);
    freq.put("ofr", 45);
    freq.put("ofs", 29);
    freq.put("İZ ", 60);
    freq.put("ömü", 68);
    freq.put("web", 28);
    freq.put("wee", 296);
    freq.put("wer", 73);
    freq.put("Oha", 31);
    freq.put("yrı", 416);
    freq.put("mhu", 78);
    freq.put("kçı", 44);
    freq.put("gur", 154);
    freq.put("AT ", 38);
    freq.put("vsi", 134);
    freq.put(" ht", 79);
    freq.put("inş", 175);
    freq.put("Say", 115);
    freq.put("vs ", 96);
    freq.put(" ju", 34);
    freq.put("Sav", 66);
    freq.put(" jo", 31);
    freq.put("kri", 119);
    freq.put("kro", 31);
    freq.put(" je", 52);
    freq.put("kra", 517);
    freq.put(" ja", 57);
    freq.put("kre", 133);
    freq.put("şt", 2495);
    freq.put("üçü", 216);
    freq.put("inç", 133);
    freq.put("yri", 111);
    freq.put("yrm", 30);
    freq.put("yra", 581);
    freq.put("yre", 164);
    freq.put("yru", 77);
    freq.put("iny", 30);
    freq.put("inz", 27);
    freq.put("int", 283);
    freq.put("ins", 1585);
    freq.put("inl", 1299);
    freq.put("inm", 169);
    freq.put("inn", 137);
    freq.put("ino", 46);
    freq.put("inh", 33);
    freq.put("ini", 6033);
    freq.put("üçl", 76);
    freq.put("ink", 203);
    freq.put("ind", 3429);
    freq.put("ine", 3092);
    freq.put("ing", 330);
    freq.put("ina", 1076);
    freq.put("inc", 761);
    freq.put("eo ", 129);
    freq.put("UL ", 29);
    freq.put("Şar", 54);
    freq.put("DA ", 79);
    freq.put("ıor", 41);
    freq.put("kça", 96);
    freq.put("rey", 320);
    freq.put("kçe", 187);
    freq.put("kçi", 40);
    freq.put("Şak", 28);
    freq.put("üç ", 84);
    freq.put("in ", 14137);
    freq.put("Şam", 86);
    freq.put("tıp", 103);
    freq.put("eom", 35);
    freq.put("eol", 45);
    freq.put("Tur", 242);
    freq.put("aln", 303);
    freq.put("Tut", 36);
    freq.put("AH ", 49);
    freq.put("nkı", 30);
    freq.put(" G ", 68);
    freq.put("erı", 217);
    freq.put("ğma", 38);
    freq.put("cm ", 32);
    freq.put("ald", 1593);
    freq.put(" Gu", 179);
    freq.put(" Gr", 83);
    freq.put("Hz ", 41);
    freq.put("erş", 252);
    freq.put("brı", 38);
    freq.put(" Ge", 715);
    freq.put(" Ga", 441);
    freq.put(" Go", 184);
    freq.put("lü", 2307);
    freq.put(" Gi", 239);
    freq.put("cmi", 63);
    freq.put("bn", 167);
    freq.put("cme", 51);
    freq.put("cma", 95);
    freq.put("akç", 31);
    freq.put("KK ", 112);
    freq.put("tmi", 458);
    freq.put("lağ", 63);
    freq.put("███", 29);
    freq.put(" Gö", 343);
    freq.put(" Gü", 625);
    freq.put("Cr", 28);
    freq.put("gli", 74);
    freq.put("aky", 52);
    freq.put("aks", 748);
    freq.put("gla", 135);
    freq.put("akp", 32);
    freq.put("gle", 242);
    freq.put("aku", 28);
    freq.put("akt", 1313);
    freq.put("akk", 472);
    freq.put("aki", 2320);
    freq.put("laş", 810);
    freq.put("ako", 51);
    freq.put("üğü", 378);
    freq.put("akm", 554);
    freq.put("akl", 1613);
    freq.put("aka", 1905);
    freq.put("glu", 71);
    freq.put("ake", 282);
    freq.put("akd", 49);
    freq.put("nk ", 242);
    freq.put("bro", 49);
    freq.put("bri", 229);
    freq.put("bre", 98);
    freq.put("OR ", 41);
    freq.put("Fu", 123);
    freq.put("er ", 9833);
    freq.put("tn ", 42);
    freq.put("nka", 467);
    freq.put("nke", 55);
    freq.put("nki", 435);
    freq.put("laç", 48);
    freq.put("nkl", 87);
    freq.put("nko", 32);
    freq.put("nkt", 32);
    freq.put("nku", 84);
    freq.put("ert", 359);
    freq.put("erv", 229);
    freq.put("err", 195);
    freq.put("ih", 1168);
    freq.put("ery", 146);
    freq.put("erz", 57);
    freq.put("erd", 2410);
    freq.put("ere", 3383);
    freq.put("erf", 44);
    freq.put("erg", 261);
    freq.put("era", 955);
    freq.put("erb", 607);
    freq.put("erc", 453);
    freq.put("erl", 1351);
    freq.put("erm", 762);
    freq.put("ern", 315);
    freq.put("ero", 112);
    freq.put("erh", 282);
    freq.put("eri", 9203);
    freq.put("erj", 70);
    freq.put("erk", 1832);
    freq.put("Abd", 29);
    freq.put("Abi", 84);
    freq.put("uar", 76);
    freq.put("la ", 4143);
    freq.put("uat", 27);
    freq.put("uam", 36);
    freq.put("ual", 61);
    freq.put("uan", 265);
    freq.put("ki ", 4588);
    freq.put("akı", 1723);
    freq.put("Çar", 28);
    freq.put("Çal", 39);
    freq.put("Çak", 32);
    freq.put(" rü", 139);
    freq.put("bıs", 27);
    freq.put("lal", 390);
    freq.put("lam", 2790);
    freq.put("lan", 5132);
    freq.put("lah", 1157);
    freq.put("laj", 35);
    freq.put("lak", 582);
    freq.put("lad", 962);
    freq.put("laf", 210);
    freq.put("lag", 29);
    freq.put("laa", 99);
    freq.put("lab", 635);
    freq.put("lac", 952);
    freq.put("lay", 1705);
    freq.put("laz", 419);
    freq.put("lat", 1196);
    freq.put("ua ", 75);
    freq.put("lav", 113);
    freq.put("nkü", 335);
    freq.put("lar", 13820);
    freq.put("las", 744);
    freq.put("erö", 115);
    freq.put("erç", 479);
    freq.put("iP", 44);
    freq.put("ğne", 27);
    freq.put("zed", 33);
    freq.put("zek", 141);
    freq.put("zeh", 31);
    freq.put("zen", 703);
    freq.put("Eyl", 190);
    freq.put("zel", 2104);
    freq.put("zem", 145);
    freq.put("zer", 595);
    freq.put("zes", 29);
    freq.put("zev", 100);
    freq.put(" lı", 69);
    freq.put("zey", 165);
    freq.put("ktı", 825);
    freq.put("Ey ", 36);
    freq.put("ze ", 1102);
    freq.put("ntü", 73);
    freq.put("İçi", 94);
    freq.put("Sır", 56);
    freq.put("l", 145707);
    freq.put("Sık", 29);
    freq.put("Sın", 26);
    freq.put("Sıc", 29);
    freq.put("ihn", 49);
    freq.put("ır ", 2411);
    freq.put("lş", 28);
    freq.put("nt ", 265);
    freq.put(" Öğ", 61);
    freq.put("ıra", 985);
    freq.put("ırc", 33);
    freq.put("ırd", 410);
    freq.put("ıre", 26);
    freq.put("ırf", 48);
    freq.put("ntr", 101);
    freq.put("ntu", 46);
    freq.put("ırm", 547);
    freq.put("nti", 418);
    freq.put("ırr", 50);
    freq.put("ırs", 385);
    freq.put("ırt", 171);
    freq.put("ntl", 26);
    freq.put("nto", 71);
    freq.put("nta", 228);
    freq.put("nte", 383);
    freq.put("öst", 217);
    freq.put("i ", 45735);
    freq.put("zıy", 161);
    freq.put("zır", 272);
    freq.put("zıs", 45);
    freq.put("zıp", 58);
    freq.put("zın", 431);
    freq.put("zıl", 281);
    freq.put("zım", 539);
    freq.put("zık", 154);
    freq.put("kt ", 39);
    freq.put("teb", 114);
    freq.put(" le", 377);
    freq.put("B", 8725);
    freq.put(" la", 1766);
    freq.put(" lo", 110);
    freq.put(" li", 865);
    freq.put(" lu", 104);
    freq.put("Sev", 289);
    freq.put("dağ", 153);
    freq.put("Ses", 41);
    freq.put("Ser", 150);
    freq.put("ktu", 289);
    freq.put("Sez", 49);
    freq.put("ktr", 93);
    freq.put("kto", 215);
    freq.put("kti", 991);
    freq.put("Sen", 539);
    freq.put("Sem", 28);
    freq.put("Sel", 106);
    freq.put("Sek", 29);
    freq.put("kta", 1381);
    freq.put("zı ", 752);
    freq.put("ntı", 349);
    freq.put("İyi", 143);
    freq.put("ter", 2555);
    freq.put("çu ", 49);
    freq.put("Qu", 26);
    freq.put(" Öm", 46);
    freq.put(" Öl", 75);
    freq.put(" Ön", 108);
    freq.put("Fl", 36);
    freq.put(" Öy", 68);
    freq.put("pır", 37);
    freq.put(" lü", 215);
    freq.put("ktü", 58);
    freq.put("tse", 159);
    freq.put("çuk", 77);
    freq.put("ktö", 53);
    freq.put("çur", 26);
    freq.put("d ", 1073);
    freq.put("ım ", 6751);
    freq.put("ğğğ", 45);
    freq.put("em ", 2508);
    freq.put("Fo", 132);
    freq.put("hro", 31);
    freq.put("hri", 87);
    freq.put("hre", 43);
    freq.put("hra", 58);
    freq.put("dn", 143);
    freq.put("do", 2671);
    freq.put("dl", 139);
    freq.put("dm", 198);
    freq.put("dj", 36);
    freq.put("dk", 162);
    freq.put("dh", 32);
    freq.put("di", 21916);
    freq.put("df", 65);
    freq.put("dg", 71);
    freq.put("dd", 704);
    freq.put("de", 30187);
    freq.put("db", 30);
    freq.put("da", 24755);
    freq.put("ımm", 151);
    freq.put("ıml", 231);
    freq.put("dy", 331);
    freq.put("dv", 53);
    freq.put("tsa", 120);
    freq.put("ımc", 152);
    freq.put("du", 7197);
    freq.put("dr", 659);
    freq.put("ds", 99);
    freq.put("dp", 27);
    freq.put("cın", 184);
    freq.put("eme", 3858);
    freq.put("emd", 268);
    freq.put("ema", 295);
    freq.put("emb", 112);
    freq.put("emm", 161);
    freq.put("eml", 445);
    freq.put("emo", 94);
    freq.put("emn", 74);
    freq.put("emi", 2537);
    freq.put("emu", 36);
    freq.put("emp", 59);
    freq.put("ems", 99);
    freq.put("emr", 66);
    freq.put("̅", 30);
    freq.put("w ", 384);
    freq.put(" I ", 131);
    freq.put("il ", 2413);
    freq.put("co ", 79);
    freq.put(" Iy", 31);
    freq.put("we", 459);
    freq.put("wa", 135);
    freq.put("wo", 47);
    freq.put("wn", 26);
    freq.put(" Is", 140);
    freq.put("wi", 733);
    freq.put("wh", 26);
    freq.put("ww", 163);
    freq.put("dü", 3424);
    freq.put(" Il", 69);
    freq.put(" In", 105);
    freq.put("dö", 726);
    freq.put("BU ", 30);
    freq.put("ilg", 642);
    freq.put("ild", 1132);
    freq.put("ile", 5038);
    freq.put("ilb", 32);
    freq.put("ilc", 68);
    freq.put("ila", 753);
    freq.put("ilo", 101);
    freq.put("ill", 935);
    freq.put("ilm", 1705);
    freq.put("ilk", 636);
    freq.put("ili", 4353);
    freq.put("ilt", 87);
    freq.put("ils", 265);
    freq.put("cok", 861);
    freq.put("com", 170);
    freq.put("col", 36);
    freq.put("coo", 82);
    freq.put("ily", 247);
    freq.put("ımı", 1593);
    freq.put("dı", 9455);
    freq.put("gn ", 33);
    freq.put("emı", 63);
    freq.put("ai ", 43);
    freq.put("ait", 81);
    freq.put("air", 97);
    freq.put("aim", 29);
    freq.put("ail", 401);
    freq.put("ET ", 66);
    freq.put("ain", 83);
    freq.put("bne", 47);
    freq.put("aik", 57);
    freq.put("aid", 26);
    freq.put("ni ", 6342);
    freq.put("Müs", 36);
    freq.put("Müz", 48);
    freq.put("ep ", 703);
    freq.put("th ", 50);
    freq.put("nik", 234);
    freq.put("nih", 59);
    freq.put("nii", 66);
    freq.put("nin", 3202);
    freq.put("nil", 268);
    freq.put("nim", 1513);
    freq.put("nic", 112);
    freq.put("nif", 33);
    freq.put("coş", 40);
    freq.put("nie", 45);
    freq.put("niz", 2193);
    freq.put("niy", 909);
    freq.put("Y", 3217);
    freq.put("nis", 214);
    freq.put("nip", 74);
    freq.put("niv", 109);
    freq.put("nit", 61);
    freq.put("ept", 43);
    freq.put("epr", 80);
    freq.put("eps", 250);
    freq.put("î", 42);
    freq.put("epl", 85);
    freq.put("epk", 82);
    freq.put("thi", 85);
    freq.put("epi", 176);
    freq.put("the", 128);
    freq.put("epe", 135);
    freq.put("tha", 52);
    freq.put("rn ", 91);
    freq.put("İş ", 36);
    freq.put("zcü", 27);
    freq.put("Öğ", 62);
    freq.put("üst", 432);
    freq.put("Gaz", 89);
    freq.put("Gar", 32);
    freq.put("Gal", 239);
    freq.put("üsa", 37);
    freq.put("üsl", 102);
    freq.put("rni", 31);
    freq.put("lcu", 295);
    freq.put("Tra", 206);
    freq.put("rna", 136);
    freq.put("rne", 329);
    freq.put("lce", 93);
    freq.put("lca", 220);
    freq.put("İşt", 95);
    freq.put("rnu", 83);
    freq.put("lci", 45);
    freq.put("obü", 78);
    freq.put("üs ", 66);
    freq.put("zce", 107);
    freq.put("zca", 77);
    freq.put(" nı", 300);
    freq.put("yke", 107);
    freq.put("üş", 1767);
    freq.put("üsü", 179);
    freq.put("yko", 26);
    freq.put("yku", 399);
    freq.put("Ley", 26);
    freq.put("plu", 112);
    freq.put("ple", 290);
    freq.put("pla", 740);
    freq.put("plo", 30);
    freq.put("pli", 73);
    freq.put("obo", 30);
    freq.put("obl", 61);
    freq.put("yk ", 33);
    freq.put("obi", 99);
    freq.put("üğ", 401);
    freq.put("obe", 56);
    freq.put("oba", 61);
    freq.put("obu", 46);
    freq.put("obs", 27);
    freq.put("üü", 102);
    freq.put("üç", 390);
    freq.put("Çün", 110);
    freq.put("Cum", 128);
    freq.put("wal", 37);
    freq.put("war", 41);
    freq.put("ıpl", 49);
    freq.put(" nü", 33);
    freq.put("Öl", 76);
    freq.put("Öm", 46);
    freq.put("Ön", 109);
    freq.put("Oda", 26);
    freq.put("Öz", 228);
    freq.put("üv", 181);
    freq.put("üt", 744);
    freq.put("ür", 4171);
    freq.put("üs", 936);
    freq.put("üp", 466);
    freq.put(" n ", 48);
    freq.put("üz", 3383);
    freq.put("üy", 1672);
    freq.put("üf", 213);
    freq.put("cüm", 139);
    freq.put("cün", 41);
    freq.put("üe", 39);
    freq.put("üb", 210);
    freq.put("üc", 441);
    freq.put("cük", 42);
    freq.put("ün", 7244);
    freq.put("ül", 1958);
    freq.put("üm", 2344);
    freq.put("üj", 33);
    freq.put("ük", 1746);
    freq.put("üh", 64);
    freq.put(" ni", 1061);
    freq.put("umu", 1048);
    freq.put(" no", 499);
    freq.put(" na", 1439);
    freq.put(" ne", 5128);
    freq.put(" nd", 177);
    freq.put("ü ", 2970);
    freq.put(" nu", 323);
    freq.put(" nt", 26);
    freq.put("ums", 62);
    freq.put("ykı", 31);
    freq.put("cağ", 506);
    freq.put("gu ", 171);
    freq.put("yve", 31);
    freq.put("yva", 208);
    freq.put("umm", 164);
    freq.put("guc", 47);
    freq.put("ekç", 34);
    freq.put("gun", 1146);
    freq.put("gum", 161);
    freq.put("gul", 356);
    freq.put("gus", 104);
    freq.put("p", 21839);
    freq.put(" Kı", 332);
    freq.put("guv", 38);
    freq.put("gut", 33);
    freq.put("guz", 379);
    freq.put("hte", 201);
    freq.put("nıı", 31);
    freq.put("hta", 132);
    freq.put("hti", 222);
    freq.put("OK ", 73);
    freq.put("htt", 66);
    freq.put("tığ", 393);
    freq.put("IN ", 85);
    freq.put("ek ", 5398);
    freq.put("ht ", 60);
    freq.put("Şer", 28);
    freq.put("Şen", 59);
    freq.put("Şeh", 56);
    freq.put("tış", 164);
    freq.put("eko", 174);
    freq.put("ekn", 115);
    freq.put("ekm", 311);
    freq.put("ekl", 2140);
    freq.put("ekk", 489);
    freq.put("eki", 1833);
    freq.put("eke", 634);
    freq.put("ekc", 26);
    freq.put("nış", 111);
    freq.put("eka", 240);
    freq.put("ekt", 1262);
    freq.put("eks", 576);
    freq.put("ekr", 287);
    freq.put("uzl", 153);
    freq.put("uzm", 33);
    freq.put("uzi", 46);
    freq.put("uzd", 142);
    freq.put("uze", 689);
    freq.put("uza", 383);
    freq.put("uzz", 44);
    freq.put("uzu", 693);
    freq.put(" ih", 294);
    freq.put("Öne", 27);
    freq.put(" Ka", 1522);
    freq.put("Önc", 43);
    freq.put(" Ke", 475);
    freq.put(" Ki", 380);
    freq.put(" Ko", 482);
    freq.put(" Kl", 40);
    freq.put(" Kr", 70);
    freq.put("Lüt", 55);
    freq.put(" Ku", 434);
    freq.put("ksa", 655);
    freq.put("ca ", 1444);
    freq.put(" im", 288);
    freq.put("F", 2149);
    freq.put("uz ", 2130);
    freq.put("fb ", 45);
    freq.put("ibi", 2026);
    freq.put(" K ", 51);
    freq.put("ibn", 33);
    freq.put("cas", 99);
    freq.put("iba", 322);
    freq.put("cap", 30);
    freq.put("ibe", 137);
    freq.put("cat", 71);
    freq.put("cak", 2385);
    freq.put("iby", 42);
    freq.put("cai", 30);
    freq.put("cah", 40);
    freq.put("can", 1247);
    freq.put("cam", 843);
    freq.put("cal", 337);
    freq.put("cab", 296);
    freq.put("ibr", 55);
    freq.put("AK ", 87);
    freq.put("cag", 193);
    freq.put("ibu", 29);
    freq.put("cad", 156);
    freq.put("ao ", 34);
    freq.put("spr", 79);
    freq.put("spu", 55);
    freq.put("spi", 82);
    freq.put("nı ", 3353);
    freq.put("spo", 366);
    freq.put("spa", 146);
    freq.put("spe", 32);
    freq.put("tı ", 1127);
    freq.put(" Kö", 93);
    freq.put(" Kü", 135);
    freq.put("nır", 558);
    freq.put("nıs", 44);
    freq.put("nıp", 53);
    freq.put("nıt", 90);
    freq.put("nız", 1399);
    freq.put("nıy", 492);
    freq.put("nıc", 56);
    freq.put("nıf", 81);
    freq.put("nıd", 81);
    freq.put("nık", 48);
    freq.put("nın", 2247);
    freq.put("nıl", 185);
    freq.put("nım", 1002);
    freq.put("ght", 46);
    freq.put("tıg", 45);
    freq.put("tıc", 93);
    freq.put("tıl", 448);
    freq.put("tım", 825);
    freq.put("tın", 891);
    freq.put("tık", 1137);
    freq.put("ibü", 57);
    freq.put("tır", 1160);
    freq.put("tıs", 119);
    freq.put("tıy", 350);
    freq.put("jın", 38);
    freq.put("Ru", 120);
    freq.put("Che", 29);
    freq.put("eç", 1526);
    freq.put("no ", 108);
    freq.put("Re", 308);
    freq.put("Ra", 339);
    freq.put("Ro", 118);
    freq.put("Ri", 83);
    freq.put("Yüc", 28);
    freq.put("soh", 55);
    freq.put("nol", 208);
    freq.put("nom", 86);
    freq.put("non", 70);
    freq.put("lmü", 77);
    freq.put("nok", 125);
    freq.put("jı ", 66);
    freq.put("mba", 191);
    freq.put("rlü", 173);
    freq.put("R ", 535);
    freq.put("not", 105);
    freq.put("nor", 97);
    freq.put("nos", 27);
    freq.put("h", 31133);
    freq.put("Yür", 36);
    freq.put("em", 10873);
    freq.put("el", 14732);
    freq.put("eo", 324);
    freq.put("en", 35920);
    freq.put("ei", 237);
    freq.put("eh", 1177);
    freq.put("ek", 13791);
    freq.put("ej", 72);
    freq.put("Rü", 44);
    freq.put("ed", 9745);
    freq.put("eg", 1323);
    freq.put("ef", 1655);
    freq.put("ea", 516);
    freq.put("rl ", 39);
    freq.put("ec", 4754);
    freq.put("eb", 2058);
    freq.put("ey", 9824);
    freq.put("ex", 133);
    freq.put("ez", 2634);
    freq.put("lm ", 304);
    freq.put("et", 11095);
    freq.put("ew", 121);
    freq.put("ev", 5867);
    freq.put("ep", 1666);
    freq.put("es", 9594);
    freq.put("er", 35980);
    freq.put("rli", 804);
    freq.put("rle", 1632);
    freq.put("rla", 2046);
    freq.put("lmu", 647);
    freq.put("lmi", 977);
    freq.put("lml", 71);
    freq.put("rlu", 169);
    freq.put("lma", 3828);
    freq.put("lme", 1389);
    freq.put("ael", 29);
    freq.put("zan", 793);
    freq.put("zal", 207);
    freq.put("zam", 1496);
    freq.put("zak", 213);
    freq.put("zah", 53);
    freq.put("zaf", 39);
    freq.put("zad", 43);
    freq.put("zab", 28);
    freq.put("zac", 47);
    freq.put("zay", 127);
    freq.put("zat", 635);
    freq.put("zar", 754);
    freq.put("zas", 135);
    freq.put("xt", 28);
    freq.put("Eur", 30);
    freq.put("yid", 121);
    freq.put("yif", 101);
    freq.put("yic", 115);
    freq.put("yim", 1342);
    freq.put("yil", 295);
    freq.put("yin", 1475);
    freq.put("yik", 102);
    freq.put("yit", 35);
    freq.put("yip", 351);
    freq.put("yis", 148);
    freq.put("yir", 219);
    freq.put("yiy", 365);
    freq.put("yiz", 310);
    freq.put("ştü", 128);
    freq.put("x ", 213);
    freq.put("za ", 562);
    freq.put("mrü", 37);
    freq.put("yi ", 2790);
    freq.put("Of ", 33);
    freq.put("lmı", 363);
    freq.put("rlı", 550);
    freq.put("Pho", 48);
    freq.put("eş", 2182);
    freq.put("Off", 38);
    freq.put("ö", 12524);
    freq.put("ıva", 61);
    freq.put("şti", 686);
    freq.put("şta", 142);
    freq.put("şte", 594);
    freq.put("mru", 65);
    freq.put("eğ", 3663);
    freq.put("mre", 109);
    freq.put(" p ", 67);
    freq.put("y ", 4217);
    freq.put(" ps", 70);
    freq.put(" pr", 608);
    freq.put(" pu", 176);
    freq.put(" pa", 1850);
    freq.put(" pe", 767);
    freq.put(" pk", 55);
    freq.put(" pi", 457);
    freq.put(" po", 471);
    freq.put(" pl", 234);
    freq.put("uva", 175);
    freq.put("yti", 33);
    freq.put("yta", 80);
    freq.put("göb", 27);
    freq.put("Kra", 36);
    freq.put("EM ", 28);
    freq.put("vun", 105);
    freq.put("vul", 88);
    freq.put("vuk", 57);
    freq.put("vut", 43);
    freq.put("vur", 284);
    freq.put(" Mı", 33);
    freq.put("vuz", 73);
    freq.put("yt ", 49);
    freq.put(" pı", 40);
    freq.put("hva", 73);
    freq.put("hve", 171);
    freq.put("twe", 253);
    freq.put("Ölü", 41);
    freq.put(" Mü", 216);
    freq.put(" Oz", 55);
    freq.put("eis", 44);
    freq.put("tlu", 636);
    freq.put("eil", 43);
    freq.put("ein", 43);
    freq.put("ceg", 162);
    freq.put("cec", 36);
    freq.put("yl", 5661);
    freq.put(" Me", 864);
    freq.put(" Ma", 768);
    freq.put(" Mo", 205);
    freq.put(" Mi", 302);
    freq.put(" Mu", 376);
    freq.put("yc", 174);
    freq.put("yb", 428);
    freq.put("cek", 1802);
    freq.put("ete", 953);
    freq.put("vuş", 55);
    freq.put("ceh", 48);
    freq.put("tli", 407);
    freq.put(" M ", 86);
    freq.put("cet", 33);
    freq.put("am ", 4263);
    freq.put("ps ", 36);
    freq.put("lü ", 455);
    freq.put("ucu", 456);
    freq.put("Hep", 114);
    freq.put("cm", 269);
    freq.put("ıçı", 31);
    freq.put("cez", 227);
    freq.put("ff ", 255);
    freq.put("lük", 257);
    freq.put("amk", 161);
    freq.put("psi", 347);
    freq.put("amm", 133);
    freq.put("lün", 96);
    freq.put("lüm", 430);
    freq.put("Adı", 34);
    freq.put("ama", 8585);
    freq.put("lüb", 62);
    freq.put("nmü", 50);
    freq.put("psa", 112);
    freq.put("ame", 349);
    freq.put("amd", 388);
    freq.put("amy", 27);
    freq.put("lüy", 219);
    freq.put("lür", 71);
    freq.put("ams", 178);
    freq.put("lüp", 58);
    freq.put("amu", 119);
    freq.put("ß", 34);
    freq.put("lüt", 168);
    freq.put("t", 79603);
    freq.put("yna", 571);
    freq.put("Hel", 49);
    freq.put("nm ", 145);
    freq.put("Hem", 77);
    freq.put("ucl", 51);
    freq.put("uck", 57);
    freq.put("uci", 31);
    freq.put("şba", 128);
    freq.put("nmu", 52);
    freq.put("yoğ", 87);
    freq.put("nme", 752);
    freq.put("nma", 977);
    freq.put("nmi", 289);
    freq.put("sra", 215);
    freq.put("sre", 38);
    freq.put("Çok", 230);
    freq.put("Çoc", 49);
    freq.put("Ada", 206);
    freq.put("amı", 1836);
    freq.put("psı", 51);
    freq.put("log", 117);
    freq.put("loj", 116);
    freq.put("lok", 47);
    freq.put("lon", 219);
    freq.put("loo", 31);
    freq.put("lol", 37);
    freq.put("lom", 35);
    freq.put("lor", 47);
    freq.put("los", 57);
    freq.put("lov", 32);
    freq.put("low", 147);
    freq.put("ıç ", 43);
    freq.put("fsa", 89);
    freq.put("ğda", 61);
    freq.put("J", 275);
    freq.put("ğdu", 51);
    freq.put("rji", 95);
    freq.put("lo ", 138);
    freq.put("Tv ", 72);
    freq.put("Win", 27);
    freq.put("Gel", 157);
    freq.put("ıça", 38);
    freq.put("Çık", 42);
    freq.put("nmı", 261);
    freq.put("Esk", 95);
    freq.put("yoo", 121);
    freq.put("yon", 1199);
    freq.put("yom", 174);
    freq.put("yol", 975);
    freq.put("yok", 2382);
    freq.put("yog", 47);
    freq.put("yod", 166);
    freq.put("yoz", 34);
    freq.put("you", 61);
    freq.put("yos", 452);
    freq.put("yor", 11990);
    freq.put("Lar", 31);
    freq.put("c ", 922);
    freq.put("yo ", 991);
    freq.put("IK ", 84);
    freq.put("mp ", 37);
    freq.put("Sı", 169);
    freq.put("tör", 126);
    freq.put("ıt ", 94);
    freq.put("şve", 99);
    freq.put("şvu", 41);
    freq.put("ıtt", 43);
    freq.put(" rö", 35);
    freq.put("mpa", 134);
    freq.put("mpo", 39);
    freq.put("mpl", 27);
    freq.put("mpi", 294);
    freq.put("ıta", 53);
    freq.put("ıtl", 66);
    freq.put("ıtm", 52);
    freq.put("fı", 627);
    freq.put("üze", 1816);
    freq.put("egı", 86);
    freq.put("dı ", 2098);
    freq.put(" ru", 204);
    freq.put(" rt", 51);
    freq.put("vet", 727);
    freq.put(" re", 1197);
    freq.put(" ra", 880);
    freq.put("ver", 2557);
    freq.put(" ro", 180);
    freq.put(" ri", 112);
    freq.put("ves", 146);
    freq.put("şay", 94);
    freq.put("dır", 1602);
    freq.put("dıs", 27);
    freq.put("dıy", 151);
    freq.put("dız", 105);
    freq.put("dıg", 102);
    freq.put("dıl", 88);
    freq.put("dım", 1743);
    freq.put("dın", 1618);
    freq.put("dık", 595);
    freq.put("ase", 124);
    freq.put("ıtı", 107);
    freq.put(" Fr", 104);
    freq.put("S ", 399);
    freq.put("ash", 59);
    freq.put("ved", 73);
    freq.put("vee", 38);
    freq.put("asm", 160);
    freq.put("pus", 31);
    freq.put("vec", 35);
    freq.put(" Üs", 46);
    freq.put("fö", 42);
    freq.put("Sp", 125);
    freq.put("fü", 123);
    freq.put(" Üz", 52);
    freq.put("Su", 364);
    freq.put("St", 191);
    freq.put("Si", 588);
    freq.put("Sh", 101);
    freq.put("So", 687);
    freq.put("Sc", 31);
    freq.put(" Ün", 82);
    freq.put("Sa", 1384);
    freq.put(" Ül", 44);
    freq.put("vel", 80);
    freq.put("Se", 1394);
    freq.put("EK ", 52);
    freq.put("çsa", 26);
    freq.put("çsi", 28);
    freq.put("RE ", 42);
    freq.put("dığ", 830);
    freq.put("f ", 1494);
    freq.put("hha", 117);
    freq.put("hhh", 142);
    freq.put("dıı", 63);
    freq.put("fr", 488);
    freq.put("fs", 230);
    freq.put("ft", 1115);
    freq.put("fu", 446);
    freq.put("Sü", 127);
    freq.put("dış", 202);
    freq.put("Sö", 114);
    freq.put("fa", 3386);
    freq.put("fb", 60);
    freq.put("hh ", 174);
    freq.put("fe", 2153);
    freq.put("ff", 645);
    freq.put("fg", 37);
    freq.put("fi", 1928);
    freq.put("fk", 67);
    freq.put("fl", 454);
    freq.put("fm", 26);
    freq.put("fo", 1176);
    freq.put("a", 301924);
    freq.put("egi", 747);
    freq.put("ego", 53);
    freq.put("egl", 102);
    freq.put("ega", 57);
    freq.put("ege", 204);
    freq.put("ce ", 3207);
    freq.put("ncı", 195);
    freq.put("uvv", 46);
    freq.put("os ", 300);
    freq.put("fff", 190);
    freq.put("ffe", 103);
    freq.put("uve", 73);
    freq.put(" On", 219);
    freq.put(" Ol", 329);
    freq.put(" Ok", 171);
    freq.put(" Oh", 68);
    freq.put(" Of", 80);
    freq.put(" Od", 37);
    freq.put("if ", 298);
    freq.put("stı", 197);
    freq.put(" Oy", 101);
    freq.put("Geç", 84);
    freq.put(" Ot", 84);
    freq.put(" Or", 245);
    freq.put(" Os", 56);
    freq.put(" Op", 39);
    freq.put("yi", 7902);
    freq.put("yh", 100);
    freq.put("yk", 664);
    freq.put("ced", 155);
    freq.put("ym", 855);
    freq.put("ceb", 343);
    freq.put("yo", 18821);
    freq.put("yn", 1633);
    freq.put("ya", 25013);
    freq.put("cen", 296);
    freq.put("cem", 541);
    freq.put("cel", 741);
    freq.put("ye", 11917);
    freq.put("yd", 2450);
    freq.put("yg", 530);
    freq.put("yf", 333);
    freq.put("yy", 445);
    freq.put("cev", 293);
    freq.put("yz", 84);
    freq.put("ces", 266);
    freq.put("cer", 214);
    freq.put("cep", 86);
    freq.put("yp", 31);
    freq.put("ys", 900);
    freq.put("yr", 1461);
    freq.put("yu", 2927);
    freq.put("yt", 216);
    freq.put("cey", 93);
    freq.put("yv", 254);
    freq.put("ift", 272);
    freq.put("ifr", 39);
    freq.put(" O ", 421);
    freq.put("ife", 61);
    freq.put("ifa", 187);
    freq.put("ifl", 118);
    freq.put("ifi", 107);
    freq.put("dig", 636);
    freq.put("Ene", 27);
    freq.put("Eng", 36);
    freq.put("pu ", 93);
    freq.put("nc ", 75);
    freq.put("as ", 427);
    freq.put("liş", 240);
    freq.put("kağ", 48);
    freq.put("Beş", 154);
    freq.put("En ", 194);
    freq.put("asr", 55);
    freq.put("pun", 27);
    freq.put("asp", 69);
    freq.put("ve ", 3803);
    freq.put("asu", 73);
    freq.put("ast", 652);
    freq.put("asy", 367);
    freq.put("pua", 91);
    freq.put("asa", 1485);
    freq.put("yü", 1569);
    freq.put("puz", 35);
    freq.put("asd", 59);
    freq.put("ask", 644);
    freq.put("asi", 1753);
    freq.put("liğ", 466);
    freq.put("aso", 73);
    freq.put("pur", 29);
    freq.put("yö", 208);
    freq.put(" F ", 60);
    freq.put("ayı", 3418);
    freq.put("dis", 368);
    freq.put("kaş", 55);
    freq.put("yı", 4996);
    freq.put("st ", 474);
    freq.put("ceğ", 490);
    freq.put("kaç", 548);
    freq.put("tfe", 268);
    freq.put("tff", 35);
    freq.put("tfa", 28);
    freq.put("ncu", 224);
    freq.put("nch", 39);
    freq.put(" Oğ", 28);
    freq.put("ncl", 39);
    freq.put("nco", 29);
    freq.put("nca", 916);
    freq.put("nce", 2202);
    freq.put("ste", 2329);
    freq.put("sta", 1491);
    freq.put("stl", 214);
    freq.put("sto", 244);
    freq.put("sti", 1344);
    freq.put("stt", 34);
    freq.put("stu", 346);
    freq.put("yş", 43);
    freq.put("Gol", 32);
    freq.put("Goo", 68);
    freq.put("ka ", 1456);
    freq.put("üya", 114);
    freq.put("üyl", 42);
    freq.put("üyo", 705);
    freq.put("Çin", 32);
    freq.put("Ajd", 27);
    freq.put("lid", 201);
    freq.put("lie", 47);
    freq.put("Nih", 49);
    freq.put("lig", 488);
    freq.put("lia", 51);
    freq.put("lib", 272);
    freq.put("lic", 204);
    freq.put("lil", 439);
    freq.put("lim", 1754);
    freq.put("lin", 1331);
    freq.put("lio", 88);
    freq.put("lih", 36);
    freq.put("lii", 53);
    freq.put("lik", 1939);
    freq.put("lit", 210);
    freq.put("liv", 39);
    freq.put("Niy", 37);
    freq.put("lip", 178);
    freq.put("lir", 1931);
    freq.put("lis", 947);
    freq.put("liy", 2395);
    freq.put("liz", 221);
    freq.put("kac", 309);
    freq.put("kab", 401);
    freq.put("kaa", 38);
    freq.put("kaf", 392);
    freq.put("kad", 3393);
    freq.put("kak", 168);
    freq.put("kah", 323);
    freq.put("kan", 2094);
    freq.put("kam", 325);
    freq.put("kal", 2992);
    freq.put("kas", 538);
    freq.put("kar", 3338);
    freq.put("kap", 669);
    freq.put("kav", 151);
    freq.put("rho", 41);
    freq.put("kat", 849);
    freq.put("rha", 338);
    freq.put("kaz", 436);
    freq.put("kay", 897);
    freq.put("li ", 3877);
    freq.put("nci", 485);
    freq.put("stü", 284);
    freq.put(" tı", 169);
    freq.put("ymu", 127);
    freq.put("yma", 233);
    freq.put("yme", 77);
    freq.put("ymi", 206);
    freq.put("ymo", 29);
    freq.put(" Aj", 45);
    freq.put(" tş", 28);
    freq.put("ym ", 56);
    freq.put("x", 440);
    freq.put("ız ", 2516);
    freq.put("üşe", 174);
    freq.put("üşl", 36);
    freq.put("üşm", 252);
    freq.put("rça", 143);
    freq.put("rçe", 442);
    freq.put("Pla", 70);
    freq.put("rçi", 40);
    freq.put("rçl", 34);
    freq.put("str", 131);
    freq.put("ızl", 615);
    freq.put("ızm", 48);
    freq.put("ıza", 285);
    freq.put("ızc", 51);
    freq.put("ızd", 270);
    freq.put("üş ", 171);
    freq.put("rç ", 33);
    freq.put("üye", 102);
    freq.put("ası", 4471);
    freq.put("gme", 42);
    freq.put(" t ", 57);
    freq.put("iy ", 34);
    freq.put("hçe", 456);
    freq.put(" tw", 683);
    freq.put(" tv", 162);
    freq.put(" tu", 1025);
    freq.put(" tt", 50);
    freq.put(" ts", 40);
    freq.put(" tr", 565);
    freq.put("N", 1749);
    freq.put(" to", 836);
    freq.put(" tm", 45);
    freq.put(" tl", 74);
    freq.put(" ti", 326);
    freq.put(" th", 97);
    freq.put(" tf", 36);
    freq.put(" te", 3476);
    freq.put(" ta", 5580);
    freq.put("ymı", 98);
    freq.put("iyd", 313);
    freq.put("iya", 843);
    freq.put("iyc", 66);
    freq.put("iym", 152);
    freq.put("iyl", 539);
    freq.put("iyo", 7630);
    freq.put("iyi", 2798);
    freq.put("iys", 140);
    freq.put("adi", 1350);
    freq.put("uçl", 128);
    freq.put("ızı", 810);
    freq.put("uça", 69);
    freq.put("uçu", 104);
    freq.put("uçt", 47);
    freq.put("gs ", 55);
    freq.put(" tü", 688);
    freq.put(" tö", 35);
    freq.put("uç ", 140);
    freq.put("lif", 124);
    freq.put("FA ", 106);
    freq.put("vye", 41);
    freq.put("ee ", 448);
    freq.put("özü", 457);
    freq.put("ruç", 85);
    freq.put("ış", 3868);
    freq.put("eey", 28);
    freq.put("eet", 334);
    freq.put("eer", 59);
    freq.put("eem", 28);
    freq.put("eel", 35);
    freq.put("een", 68);
    freq.put("eek", 29);
    freq.put("eee", 489);
    freq.put("ru ", 642);
    freq.put("Ağ", 171);
    freq.put("id ", 166);
    freq.put("ruk", 82);
    freq.put("ruh", 127);
    freq.put("run", 751);
    freq.put("rul", 425);
    freq.put("rum", 5573);
    freq.put("rub", 87);
    freq.put("ruc", 141);
    freq.put("rud", 49);
    freq.put("Tı", 48);
    freq.put("ruz", 1084);
    freq.put("ruy", 401);
    freq.put("rur", 203);
    freq.put("rus", 238);
    freq.put("rup", 307);
    freq.put("nağ", 41);
    freq.put("rut", 31);
    freq.put("ruu", 59);
    freq.put("ido", 30);
    freq.put("idi", 1220);
    freq.put("idd", 379);
    freq.put("ide", 1840);
    freq.put("ida", 264);
    freq.put("Tü", 836);
    freq.put("Eli", 56);
    freq.put("Ele", 46);
    freq.put("aq ", 33);
    freq.put("The", 54);
    freq.put("ut ", 352);
    freq.put("El ", 34);
    freq.put("utb", 356);
    freq.put("uta", 281);
    freq.put("utf", 71);
    freq.put("Aç", 97);
    freq.put("ute", 29);
    freq.put("uti", 41);
    freq.put("uto", 35);
    freq.put("utl", 811);
    freq.put("utm", 335);
    freq.put("uts", 127);
    freq.put("utt", 204);
    freq.put("utu", 492);
    freq.put("Bek", 83);
    freq.put("Tv", 78);
    freq.put("Tw", 221);
    freq.put("Tu", 395);
    freq.put("Tr", 286);
    freq.put("To", 227);
    freq.put("Th", 79);
    freq.put("Ti", 111);
    freq.put("Te", 704);
    freq.put("Ta", 901);
    freq.put("nab", 108);
    freq.put("nac", 167);
    freq.put("naa", 71);
    freq.put("nad", 265);
    freq.put("nak", 197);
    freq.put("nah", 105);
    freq.put("nan", 1044);
    freq.put("nal", 685);
    freq.put("nam", 468);
    freq.put("nar", 358);
    freq.put("nas", 1050);
    freq.put("nap", 214);
    freq.put("nav", 148);
    freq.put("nat", 346);
    freq.put("naz", 100);
    freq.put("nay", 588);
    freq.put("bzo", 210);
    freq.put("ook", 450);
    freq.put("T ", 610);
    freq.put("Aa", 32);
    freq.put("na ", 5639);
    freq.put("Ab", 153);
    freq.put("e", 234009);
    freq.put("Ad", 337);
    freq.put("Ag", 43);
    freq.put("Af", 106);
    freq.put("Ai", 51);
    freq.put("Ah", 196);
    freq.put("Ak", 342);
    freq.put("Aj", 45);
    freq.put("Am", 445);
    freq.put("Al", 1150);
    freq.put("An", 706);
    freq.put("Ap", 73);
    freq.put("As", 257);
    freq.put("Bey", 159);
    freq.put("ruş", 81);
    freq.put("Av", 198);
    freq.put("Ay", 474);
    freq.put("Uzu", 45);
    freq.put("Az", 148);
    freq.put("gu", 2705);
    freq.put("Git", 74);
    freq.put("gs", 87);
    freq.put("Gir", 48);
    freq.put("gz", 58);
    freq.put("zü", 1014);
    freq.put("ge", 9561);
    freq.put("gd", 126);
    freq.put("Gib", 32);
    freq.put("ga", 1959);
    freq.put("go", 1388);
    freq.put("gn", 110);
    freq.put("gm", 173);
    freq.put("gl", 578);
    freq.put("ass", 115);
    freq.put("gi", 9225);
    freq.put("gh", 81);
    freq.put("lko", 138);
    freq.put("lkm", 63);
    freq.put("hük", 42);
    freq.put("lki", 290);
    freq.put("lke", 360);
    freq.put("lka", 162);
    freq.put("hüz", 28);
    freq.put("lkt", 60);
    freq.put("hür", 27);
    freq.put("kce", 114);
    freq.put("kca", 54);
    freq.put("kci", 36);
    freq.put("g ", 636);
    freq.put("hi ", 199);
    freq.put("lk ", 720);
    freq.put("Spo", 88);
    freq.put("zl", 3957);
    freq.put("zm", 1146);
    freq.put("zn", 59);
    freq.put("zo", 1021);
    freq.put("zi", 3943);
    freq.put("oz ", 182);
    freq.put("zk", 85);
    freq.put("zd", 1952);
    freq.put("ze", 5540);
    freq.put("gü", 4557);
    freq.put("za", 5253);
    freq.put("zb", 66);
    freq.put("sö", 1218);
    freq.put("öv", 160);
    freq.put("zy", 177);
    freq.put("zz", 380);
    freq.put("zt", 64);
    freq.put("zu", 1211);
    freq.put("zr", 39);
    freq.put("zs", 562);
    freq.put("Ah ", 46);
    freq.put("Ş ", 96);
    freq.put("yca", 93);
    freq.put("yce", 58);
    freq.put("ozg", 27);
    freq.put("ozd", 51);
    freq.put("oze", 104);
    freq.put("oza", 97);
    freq.put("ıım", 80);
    freq.put("ozl", 211);
    freq.put("ozm", 81);
    freq.put("z ", 13828);
    freq.put("ozi", 63);
    freq.put("ozu", 284);
    freq.put("Aha", 47);
    freq.put("Şu", 140);
    freq.put("Ahm", 80);
    freq.put(" vı", 35);
    freq.put("Şi", 223);
    freq.put("Şa", 278);
    freq.put("Şe", 230);
    freq.put("win", 28);
    freq.put("Yin", 78);
    freq.put("wit", 644);
    freq.put(" vü", 28);
    freq.put("gı", 944);
    freq.put("üşü", 892);
    freq.put("lkı", 166);
    freq.put("ııı", 371);
    freq.put("oç ", 42);
    freq.put(" va", 4257);
    freq.put("tşk", 26);
    freq.put(" ve", 5572);
    freq.put(" vi", 514);
    freq.put("Şı", 31);
    freq.put(" vo", 94);
    freq.put(" vs", 102);
    freq.put(" vu", 237);
    freq.put("zı", 2800);
    freq.put(" v ", 28);
    freq.put("of ", 140);
    freq.put("beğ", 257);
    freq.put("rsı", 427);
    freq.put("öy ", 110);
    freq.put("Fac", 162);
    freq.put("RA ", 40);
    freq.put("beş", 99);
    freq.put("ç", 19505);
    freq.put(" Sı", 169);
    freq.put("öyl", 1932);
    freq.put("ec ", 49);
    freq.put("mar", 733);
    freq.put("hli", 85);
    freq.put("hle", 51);
    freq.put("hla", 158);
    freq.put("mav", 49);
    freq.put("ece", 3550);
    freq.put("eca", 176);
    freq.put("CE ", 34);
    freq.put("ecn", 45);
    freq.put("ecm", 91);
    freq.put("ecl", 42);
    freq.put("eck", 33);
    freq.put("eci", 463);
    freq.put("ect", 99);
    freq.put("ecr", 65);
    freq.put("rs ", 257);
    freq.put("mah", 187);
    freq.put("AN ", 171);
    freq.put(" Sp", 120);
    freq.put(" St", 184);
    freq.put(" Su", 362);
    freq.put(" Sh", 99);
    freq.put(" Si", 579);
    freq.put(" So", 685);
    freq.put(" Sc", 30);
    freq.put(" Sa", 1374);
    freq.put(" Se", 1392);
    freq.put("rsl", 87);
    freq.put("rsn", 48);
    freq.put("rso", 71);
    freq.put("rsh", 44);
    freq.put("rsi", 1234);
    freq.put("rse", 937);
    freq.put("şük", 83);
    freq.put("rsa", 1546);
    freq.put("şün", 621);
    freq.put("şüp", 44);
    freq.put("şür", 130);
    freq.put("R", 1513);
    freq.put("ğol", 96);
    freq.put("rsu", 887);
    freq.put("bek", 915);
    freq.put("urç", 30);
    freq.put("ben", 5326);
    freq.put("bel", 778);
    freq.put("beb", 296);
    freq.put("bec", 110);
    freq.put("bea", 45);
    freq.put("beg", 101);
    freq.put("bed", 253);
    freq.put("bee", 73);
    freq.put("AL ", 46);
    freq.put("bey", 492);
    freq.put("ber", 1438);
    freq.put("bes", 218);
    freq.put(" S ", 114);
    freq.put("bet", 529);
    freq.put("ari", 2559);
    freq.put("py ", 31);
    freq.put("st", 7171);
    freq.put("aw ", 29);
    freq.put("ur ", 2047);
    freq.put(" Sü", 124);
    freq.put(" Sö", 114);
    freq.put("arm", 759);
    freq.put("asl", 768);
    freq.put("rsü", 64);
    freq.put("but", 78);
    freq.put("urd", 794);
    freq.put("ure", 187);
    freq.put("urg", 94);
    freq.put("ura", 1146);
    freq.put("urb", 97);
    freq.put("urc", 141);
    freq.put("url", 271);
    freq.put("urm", 498);
    freq.put("urn", 108);
    freq.put("uro", 83);
    freq.put("uri", 217);
    freq.put("urk", 427);
    freq.put("urt", 400);
    freq.put("uru", 1755);
    freq.put("urr", 41);
    freq.put("urs", 606);
    freq.put("bun", 1136);
    freq.put("yaş", 863);
    freq.put("bul", 1767);
    freq.put("nge", 297);
    freq.put("yüd", 29);
    freq.put("nga", 73);
    freq.put("üşs", 33);
    freq.put("ngl", 28);
    freq.put("ngo", 28);
    freq.put("ngi", 581);
    freq.put("sh ", 48);
    freq.put("ngu", 28);
    freq.put("yür", 203);
    freq.put("bud", 75);
    freq.put("yüz", 467);
    freq.put("yağ", 286);
    freq.put("üşt", 173);
    freq.put("tbo", 421);
    freq.put("ng ", 264);
    freq.put("yü ", 26);
    freq.put("sha", 76);
    freq.put("shi", 44);
    freq.put("sho", 64);
    freq.put("ke ", 536);
    freq.put("lup", 154);
    freq.put("lur", 1234);
    freq.put("lus", 179);
    freq.put("lut", 81);
    freq.put("luy", 871);
    freq.put("lub", 74);
    freq.put("luc", 157);
    freq.put("zyı", 27);
    freq.put("luk", 537);
    freq.put("lul", 241);
    freq.put("lum", 448);
    freq.put("lun", 819);
    freq.put("ken", 2929);
    freq.put("kem", 353);
    freq.put("kel", 362);
    freq.put("kek", 414);
    freq.put("ked", 294);
    freq.put("kec", 54);
    freq.put("Yaş", 83);
    freq.put("kez", 304);
    freq.put("key", 310);
    freq.put("ket", 655);
    freq.put("kes", 1263);
    freq.put("ker", 745);
    freq.put("şlı", 270);
    freq.put("lu ", 1664);
    freq.put("Yıl", 197);
    freq.put("ot ", 137);
    freq.put("ty", 150);
    freq.put("yay", 506);
    freq.put("yaz", 1833);
    freq.put("yat", 1573);
    freq.put("yaw", 35);
    freq.put("yav", 239);
    freq.put("yap", 3581);
    freq.put("yas", 752);
    freq.put("yar", 2006);
    freq.put("yam", 426);
    freq.put("yal", 1184);
    freq.put("yan", 3096);
    freq.put("yah", 215);
    freq.put("yak", 1028);
    freq.put("yaj", 38);
    freq.put("yad", 357);
    freq.put("yag", 91);
    freq.put("yaf", 36);
    freq.put("yaa", 491);
    freq.put("yac", 677);
    freq.put("yab", 242);
    freq.put("oth", 46);
    freq.put("oti", 48);
    freq.put("otl", 34);
    freq.put("oto", 612);
    freq.put("ota", 67);
    freq.put("ote", 223);
    freq.put("ott", 31);
    freq.put("otu", 376);
    freq.put("And", 54);
    freq.put("Ana", 122);
    freq.put("öbe", 56);
    freq.put("Anl", 100);
    freq.put("Ann", 96);
    freq.put("Ank", 157);
    freq.put("Ant", 72);
    freq.put("ngı", 54);
    freq.put("ya ", 5233);
    freq.put("Yol", 66);
    freq.put("Yok", 181);
    freq.put("luş", 191);
    freq.put("mz ", 27);
    freq.put("You", 26);
    freq.put("Yor", 58);
    freq.put("şlu", 35);
    freq.put("keğ", 63);
    freq.put("şla", 1181);
    freq.put("şle", 436);
    freq.put("şli", 103);
    freq.put("yaç", 45);
    freq.put("amn", 26);
    freq.put("luğ", 214);
    freq.put("mza", 80);
    freq.put("zya", 37);
    freq.put("i", 220912);
    freq.put("zyo", 76);
    freq.put("ksi", 746);
    freq.put("keş", 136);
    freq.put("Bır", 40);
    freq.put("hı", 493);
    freq.put("Be", 1761);
    freq.put("Ba", 1854);
    freq.put("Bl", 69);
    freq.put("Bo", 327);
    freq.put("Bi", 1784);
    freq.put("Bu", 1754);
    freq.put("Br", 81);
    freq.put("B ", 264);
    freq.put("hş", 30);
    freq.put("GS ", 68);
    freq.put("işm", 219);
    freq.put("işl", 370);
    freq.put("işk", 177);
    freq.put("işi", 1283);
    freq.put("işe", 527);
    freq.put("işa", 92);
    freq.put("jla", 76);
    freq.put("işt", 976);
    freq.put("işs", 109);
    freq.put("U ", 164);
    freq.put("BD ", 68);
    freq.put("rşi", 33);
    freq.put("Bö", 115);
    freq.put("Bü", 220);
    freq.put("rşa", 49);
    freq.put("rşe", 397);
    freq.put("lçi", 36);
    freq.put("Uy", 152);
    freq.put("Uz", 99);
    freq.put("lça", 36);
    freq.put("Us", 35);
    freq.put("iş ", 1562);
    freq.put("Um", 75);
    freq.put("Ul", 115);
    freq.put("Un", 94);
    freq.put("lçu", 28);
    freq.put("dun", 455);
    freq.put("U", 902);
    freq.put("MA ", 43);
    freq.put("ea ", 79);
    freq.put("vşa", 54);
    freq.put("h ", 2649);
    freq.put("Şah", 30);
    freq.put("dm ", 131);
    freq.put("duy", 634);
    freq.put("Şan", 26);
    freq.put("eak", 28);
    freq.put("hy", 49);
    freq.put("eam", 26);
    freq.put("eal", 99);
    freq.put("ean", 58);
    freq.put("eaa", 33);
    freq.put("hs", 251);
    freq.put("hp", 48);
    freq.put("hv", 252);
    freq.put("ht", 719);
    freq.put("hu", 807);
    freq.put("hj", 26);
    freq.put("hk", 136);
    freq.put("hh", 500);
    freq.put("hi", 3022);
    freq.put("hn", 159);
    freq.put("ho", 1075);
    freq.put("hl", 341);
    freq.put("hm", 480);
    freq.put("hb", 111);
    freq.put("hc", 126);
    freq.put("ear", 46);
    freq.put("ph", 172);
    freq.put("hd", 80);
    freq.put("he", 5113);
    freq.put("dus", 249);
    freq.put("duu", 32);
    freq.put("pl", 1297);
    freq.put("vra", 141);
    freq.put(" Uy", 151);
    freq.put(" Uz", 97);
    freq.put(" Us", 35);
    freq.put(" Ul", 115);
    freq.put(" Um", 75);
    freq.put(" Un", 94);
    freq.put("hü", 173);
    freq.put(" ̅ ", 28);
    freq.put("göt", 191);
    freq.put("hç", 475);
    freq.put("hne", 78);
    freq.put("hni", 55);
    freq.put("rşı", 451);
    freq.put("şın", 606);
    freq.put("şım", 455);
    freq.put("şıl", 268);
    freq.put("şık", 304);
    freq.put("aul", 30);
    freq.put("up ", 442);
    freq.put("şıs", 73);
    freq.put("şır", 297);
    freq.put("şıp", 37);
    freq.put("şız", 26);
    freq.put("şıy", 404);
    freq.put("iye", 4304);
    freq.put("upo", 36);
    freq.put("upl", 37);
    freq.put("şı ", 409);
    freq.put("upe", 79);
    freq.put("upa", 273);
    freq.put("me ", 1867);
    freq.put(" Çı", 64);
    freq.put("nen", 545);
    freq.put("nel", 552);
    freq.put("nem", 903);
    freq.put("nek", 273);
    freq.put("nef", 244);
    freq.put("neg", 38);
    freq.put("ned", 1018);
    freq.put("nee", 56);
    freq.put("neb", 87);
    freq.put("nec", 148);
    freq.put("nez", 38);
    freq.put("ney", 676);
    freq.put("nev", 65);
    freq.put("dr ", 80);
    freq.put("net", 802);
    freq.put("ner", 1700);
    freq.put("nes", 347);
    freq.put("Alı", 49);
    freq.put("mee", 36);
    freq.put("med", 1536);
    freq.put("meg", 45);
    freq.put("mec", 109);
    freq.put("mem", 1018);
    freq.put("mel", 959);
    freq.put("men", 1191);
    freq.put("meh", 36);
    freq.put("mek", 2463);
    freq.put("met", 832);
    freq.put("mev", 89);
    freq.put("mes", 1437);
    freq.put("mer", 728);
    freq.put("mey", 1636);
    freq.put("mez", 1015);
    freq.put("dru", 66);
    freq.put("ne ", 7164);
    freq.put("dri", 158);
    freq.put("dro", 164);
    freq.put("dra", 61);
    freq.put("dre", 105);
    freq.put("Kaç", 51);
    freq.put("Ü", 345);
    freq.put("Ste", 30);
    freq.put("Sta", 91);
    freq.put(" Çü", 113);
    freq.put("Sto", 30);
    freq.put("ğaz", 82);
    freq.put("V", 991);
    freq.put("şığ", 40);
    freq.put("Lig", 145);
    freq.put("Lib", 46);
    freq.put("Lin", 28);
    freq.put("ygi", 38);
    freq.put("Lit", 28);
    freq.put("neş", 127);
    freq.put("ov ", 32);
    freq.put("Lis", 31);
    freq.put("ğal", 57);
    freq.put("Kaf", 49);
    freq.put("Kad", 284);
    freq.put("Kah", 48);
    freq.put("Kan", 131);
    freq.put("Al ", 29);
    freq.put("Kal", 154);
    freq.put("Kas", 61);
    freq.put("Kar", 330);
    freq.put("Kap", 67);
    freq.put("Kav", 29);
    freq.put("Kat", 46);
    freq.put("öde", 84);
    freq.put("Kay", 105);
    freq.put("ovu", 30);
    freq.put("neğ", 63);
    freq.put(" Çe", 148);
    freq.put("ove", 73);
    freq.put(" Ço", 317);
    freq.put("ovi", 31);
    freq.put(" Çi", 97);
    freq.put("All", 474);
    freq.put("Alm", 81);
    freq.put("Ali", 135);
    freq.put("Ald", 31);
    freq.put("Ale", 60);
    freq.put("Alb", 32);
    freq.put("Ala", 66);
    freq.put("Alt", 122);
    freq.put("düs", 39);
    freq.put("dür", 460);
    freq.put("düz", 296);
    freq.put(" ı ", 250);
    freq.put("dük", 131);
    freq.put("dün", 559);
    freq.put("düm", 283);
    freq.put("dül", 76);
    freq.put("uğ ", 36);
    freq.put(" ır", 37);
    freq.put(" ıs", 231);
    freq.put(" ıy", 72);
    freq.put(" ız", 47);
    freq.put("dü ", 213);
    freq.put(" ıl", 54);
    freq.put(" ım", 71);
    freq.put(" ın", 504);
    freq.put("uğa", 27);
    freq.put("uğr", 148);
    freq.put("uğu", 1243);
    freq.put("doğ", 674);
    freq.put("nşa", 160);
    freq.put(" zm", 35);
    freq.put(" zo", 542);
    freq.put(" zi", 233);
    freq.put(" ze", 339);
    freq.put(" za", 2207);
    freq.put(" zu", 35);
    freq.put("is ", 1162);
    freq.put("zde", 845);
    freq.put("nş ", 43);
    freq.put("isy", 126);
    freq.put("iss", 331);
    freq.put("isr", 56);
    freq.put("isp", 69);
    freq.put("isv", 32);
    freq.put("ist", 2890);
    freq.put("isk", 168);
    freq.put("isi", 2874);
    freq.put("ish", 30);
    freq.put("isn", 31);
    freq.put("ism", 270);
    freq.put("isl", 314);
    freq.put("isa", 371);
    freq.put("ise", 613);
    freq.put("düş", 1054);
    freq.put("düğ", 230);
    freq.put(" ış", 69);
    freq.put("ty ", 64);
    freq.put("öşe", 56);
    freq.put("do ", 87);
    freq.put("ttı", 505);
    freq.put("tya", 40);
    freq.put("dok", 249);
    freq.put("don", 357);
    freq.put("dol", 635);
    freq.put("dom", 39);
    freq.put("m", 116788);
    freq.put("dog", 193);
    freq.put("doy", 55);
    freq.put("dor", 47);
    freq.put("dos", 231);
    freq.put(" zı", 54);
    freq.put("dow", 31);
    freq.put("şş", 223);
    freq.put(" We", 34);
    freq.put("Özl", 43);
    freq.put("kus", 255);
    freq.put(" Wh", 27);
    freq.put(" Wi", 61);
    freq.put("mcı", 159);
    freq.put("slı", 343);
    freq.put("ba ", 861);
    freq.put("bat", 164);
    freq.put("ak ", 6296);
    freq.put("bar", 703);
    freq.put("bas", 1124);
    freq.put("baz", 393);
    freq.put("şı", 2991);
    freq.put("bay", 812);
    freq.put("bag", 96);
    freq.put("bad", 73);
    freq.put("bab", 312);
    freq.put("bac", 94);
    freq.put("unç", 29);
    freq.put("ban", 1253);
    freq.put("bal", 414);
    freq.put("bam", 173);
    freq.put("bak", 1856);
    freq.put("bah", 1197);
    freq.put("om ", 327);
    freq.put("Efe", 34);
    freq.put("Ruh", 33);
    freq.put("iş", 5463);
    freq.put("un ", 5768);
    freq.put("Rus", 49);
    freq.put("omb", 178);
    freq.put("C", 1826);
    freq.put("ome", 112);
    freq.put("omi", 184);
    freq.put("omo", 50);
    freq.put("omp", 40);
    freq.put("omu", 283);
    freq.put("uns", 71);
    freq.put("kiş", 477);
    freq.put("unu", 3312);
    freq.put("iğ", 2486);
    freq.put("uny", 124);
    freq.put("una", 1062);
    freq.put("unc", 554);
    freq.put("und", 1320);
    freq.put("une", 174);
    freq.put("unf", 49);
    freq.put("ung", 62);
    freq.put("uni", 54);
    freq.put("unk", 85);
    freq.put("unl", 755);
    freq.put("unm", 260);
    freq.put("unn", 63);
    freq.put("bağ", 339);
    freq.put("iç", 3780);
    freq.put("şy", 51);
    freq.put("şv", 156);
    freq.put("şu", 1202);
    freq.put("C ", 132);
    freq.put("şs", 348);
    freq.put("şr", 30);
    freq.put("şo", 130);
    freq.put("şm", 1498);
    freq.put("şl", 2052);
    freq.put("şk", 1772);
    freq.put("şi", 3202);
    freq.put("şg", 95);
    freq.put("şe", 3492);
    freq.put("şd", 37);
    freq.put("şb", 160);
    freq.put("şa", 3449);
    freq.put("mci", 89);
    freq.put("zdü", 26);
    freq.put("baş", 1899);
    freq.put("mca", 82);
    freq.put("mcu", 30);
    freq.put("Ci", 153);
    freq.put("Ch", 103);
    freq.put("Co", 219);
    freq.put("Cl", 41);
    freq.put("slu", 66);
    freq.put("Ca", 451);
    freq.put("Ce", 308);
    freq.put("slo", 26);
    freq.put("sli", 315);
    freq.put("akr", 50);
    freq.put("sle", 545);
    freq.put("sla", 757);
    freq.put("Cu", 158);
    freq.put("ş ", 5322);
    freq.put("iy", 16887);
    freq.put("ix", 54);
    freq.put("iz", 11237);
    freq.put("ip", 2349);
    freq.put("is", 9451);
    freq.put("ir", 19531);
    freq.put("iu", 52);
    freq.put("it", 4988);
    freq.put("iv", 578);
    freq.put("ii", 1392);
    freq.put("Nas", 117);
    freq.put("ik", 8787);
    freq.put("ij", 51);
    freq.put("im", 19226);
    freq.put("il", 18585);
    freq.put("io", 553);
    freq.put("in", 33384);
    freq.put("ia", 753);
    freq.put("ic", 2830);
    freq.put("ib", 2758);
    freq.put("ie", 471);
    freq.put("id", 3978);
    freq.put("ig", 1870);
    freq.put("if", 1142);
    freq.put("V ", 164);
    freq.put("şü", 1005);
    freq.put("şö", 104);
    freq.put("şç", 63);
    freq.put("kiz", 261);
    freq.put("kiy", 853);
    freq.put("kis", 508);
    freq.put("kir", 440);
    freq.put("kip", 514);
    freq.put("kit", 344);
    freq.put("kik", 302);
    freq.put("kii", 55);
    freq.put("kin", 852);
    freq.put("kim", 1335);
    freq.put("kil", 949);
    freq.put("kic", 92);
    freq.put("kib", 123);
    freq.put("kid", 144);
    freq.put("slü", 66);
    freq.put("Va", 289);
    freq.put("Ve", 324);
    freq.put("ışv", 44);
    freq.put("Vi", 157);
    freq.put("Vo", 48);
    freq.put("omş", 40);
    freq.put("yek", 28);
    freq.put("yem", 649);
    freq.put("yel", 317);
    freq.put("yen", 1931);
    freq.put("yea", 50);
    freq.put("yec", 570);
    freq.put("yeb", 162);
    freq.put("yee", 26);
    freq.put("yed", 328);
    freq.put("yey", 143);
    freq.put("op ", 167);
    freq.put("Gön", 49);
    freq.put("yes", 303);
    freq.put("yer", 1580);
    freq.put("yet", 1378);
    freq.put("Açı", 67);
    freq.put("opt", 62);
    freq.put("opu", 152);
    freq.put("opr", 85);
    freq.put("ye ", 4276);
    freq.put("opy", 32);
    freq.put("ope", 118);
    freq.put(" uğ", 170);
    freq.put("opa", 162);
    freq.put("opl", 340);
    freq.put("opo", 29);
    freq.put("Göz", 100);
    freq.put("Ars", 43);
    freq.put("Art", 151);
    freq.put("vda", 57);
    freq.put("Ara", 178);
    freq.put("Ard", 128);
    freq.put("Are", 27);
    freq.put("vdi", 294);
    freq.put("Ark", 108);
    freq.put("Arm", 27);
    freq.put("www", 82);
    freq.put("çeğ", 48);
    freq.put("ıba", 34);
    freq.put("zu ", 184);
    freq.put("bra", 105);
    freq.put("İL ", 54);
    freq.put("opü", 26);
    freq.put("ww ", 78);
    freq.put("zur", 137);
    freq.put("çeş", 42);
    freq.put("zuc", 34);
    freq.put("zuk", 71);
    freq.put("zun", 430);
    freq.put("zul", 149);
    freq.put("zum", 136);
    freq.put("yeş", 43);
    freq.put("TE ", 50);
    freq.put("Z", 503);
    freq.put("böc", 31);
    freq.put("çe ", 490);
    freq.put("Üzü", 26);
    freq.put("böl", 216);
    freq.put("çes", 65);
    freq.put("çer", 274);
    freq.put("çev", 109);
    freq.put("çet", 28);
    freq.put("çey", 50);
    freq.put("çec", 49);
    freq.put("RK ", 37);
    freq.put("çek", 996);
    freq.put("çen", 236);
    freq.put("çem", 57);
    freq.put("çel", 189);
    freq.put("ıbı", 58);
    freq.put("üüü", 53);
    freq.put("fsi", 84);
    freq.put(" Yü", 125);
    freq.put(" Yö", 39);
    freq.put("flı", 27);
    freq.put("di ", 4379);
    freq.put("Tun", 43);
    freq.put("şim", 1054);
    freq.put("dil", 1108);
    freq.put("dim", 2780);
    freq.put("din", 2244);
    freq.put("dio", 91);
    freq.put("dii", 151);
    freq.put("dik", 1216);
    freq.put("did", 119);
    freq.put("die", 80);
    freq.put("Böy", 53);
    freq.put("ers", 1650);
    freq.put("dia", 109);
    freq.put("dib", 47);
    freq.put("dic", 173);
    freq.put("diy", 3827);
    freq.put("diz", 329);
    freq.put("dit", 49);
    freq.put("dip", 184);
    freq.put("dir", 2287);
    freq.put("Böl", 60);
    freq.put(" Yi", 122);
    freq.put("Gru", 33);
    freq.put(" Yo", 366);
    freq.put(" Ya", 1340);
    freq.put(" Ye", 510);
    freq.put("ğu ", 506);
    freq.put(" Yu", 103);
    freq.put("çök", 39);
    freq.put("mağ", 116);
    freq.put("çöz", 128);
    freq.put("AM ", 41);
    freq.put("bo ", 35);
    freq.put("çöp", 27);
    freq.put("ğus", 107);
    freq.put("ğur", 81);
    freq.put("ğuk", 42);
    freq.put("ğun", 611);
    freq.put("ğum", 304);
    freq.put("ğul", 29);
    freq.put("boy", 398);
    freq.put("boz", 247);
    freq.put("hbe", 79);
    freq.put("bor", 87);
    freq.put("bos", 106);
    freq.put("bot", 29);
    freq.put("bou", 30);
    freq.put("maş", 66);
    freq.put("bok", 164);
    freq.put("bol", 679);
    freq.put("bom", 125);
    freq.put("bon", 69);
    freq.put("boo", 299);
    freq.put("bod", 41);
    freq.put("bog", 30);
    freq.put("ınt", 191);
    freq.put("oo ", 172);
    freq.put("diğ", 1349);
    freq.put("aym", 155);
    freq.put("ayl", 664);
    freq.put("ayo", 43);
    freq.put("ayn", 767);
    freq.put("ayi", 1010);
    freq.put("ayk", 116);
    freq.put("aye", 386);
    freq.put("ayd", 1117);
    freq.put("ayg", 166);
    freq.put("ayf", 207);
    freq.put("aya", 5400);
    freq.put("ayb", 345);
    freq.put("İ", 2754);
    freq.put("ayy", 152);
    freq.put("Aş", 164);
    freq.put("ayt", 78);
    freq.put("ul ", 901);
    freq.put("ayv", 137);
    freq.put("ays", 100);
    freq.put("ayr", 1097);
    freq.put("ood", 51);
    freq.put("oog", 95);
    freq.put("Ben", 925);
    freq.put("Bel", 177);
    freq.put("ool", 66);
    freq.put("ooo", 410);
    freq.put("Bed", 34);
    freq.put("diş", 123);
    freq.put("maç", 638);
    freq.put("oor", 53);
    freq.put("Ber", 71);
    freq.put("Bes", 39);
    freq.put("uls", 61);
    freq.put("ay ", 1343);
    freq.put("ult", 100);
    freq.put("ulu", 1338);
    freq.put("fli", 78);
    freq.put("ulk", 33);
    freq.put("uli", 28);
    freq.put("ull", 726);
    freq.put("fln", 30);
    freq.put("fla", 168);
    freq.put("ulc", 56);
    freq.put("ula", 1498);
    freq.put("fle", 121);
    freq.put("uld", 487);
    freq.put("ule", 125);
    freq.put("sn ", 185);
    freq.put("boğ", 73);
    freq.put("ma ", 5621);
    freq.put("nyo", 78);
    freq.put("yön", 200);
    freq.put("nya", 1003);
    freq.put("nye", 45);
    freq.put("mas", 1981);
    freq.put("sne", 32);
    freq.put("mat", 165);
    freq.put("sna", 50);
    freq.put("may", 2468);
    freq.put("maz", 1726);
    freq.put("maa", 160);
    freq.put("mac", 367);
    freq.put("mad", 1896);
    freq.put("mag", 68);
    freq.put("mai", 118);
    freq.put(" Yı", 209);
    freq.put("mak", 2515);
    freq.put("mam", 1631);
    freq.put("mal", 1550);
    freq.put("man", 3484);
    freq.put("ğuş", 29);
    freq.put("ulü", 127);
    freq.put("Ede", 37);
    freq.put("Edi", 51);
    freq.put("q", 238);
    freq.put("ny ", 31);
    freq.put("lse", 289);
    freq.put("lsa", 775);
    freq.put("lsk", 28);
    freq.put("lsi", 322);
    freq.put("lsu", 1272);
    freq.put("kk ", 197);
    freq.put(" aa", 120);
    freq.put(" ab", 795);
    freq.put(" ac", 1019);
    freq.put(" ad", 1657);
    freq.put("zsı", 115);
    freq.put(" af", 210);
    freq.put(" ag", 211);
    freq.put(" ah", 516);
    freq.put(" ai", 179);
    freq.put(" aj", 47);
    freq.put(" ak", 1220);
    freq.put(" al", 3760);
    freq.put(" am", 3097);
    freq.put(" an", 3156);
    freq.put(" ap", 155);
    freq.put(" aq", 38);
    freq.put(" ar", 4024);
    freq.put(" as", 987);
    freq.put(" at", 1483);
    freq.put("gem", 61);
    freq.put(" av", 212);
    freq.put(" ay", 2335);
    freq.put(" az", 597);
    freq.put("gel", 3607);
    freq.put("kku", 127);
    freq.put("pıl", 332);
    freq.put("Sha", 34);
    freq.put("kki", 89);
    freq.put("pın", 93);
    freq.put("kkk", 128);
    freq.put("kke", 140);
    freq.put("kka", 419);
    freq.put("Sho", 48);
    freq.put(" a ", 727);
    freq.put("pıp", 49);
    freq.put("Yağ", 26);
    freq.put("ödü", 51);
    freq.put("ücü", 165);
    freq.put("pıy", 341);
    freq.put("akş", 263);
    freq.put("lsü", 29);
    freq.put("or ", 4638);
    freq.put("Ken", 162);
    freq.put("Kem", 64);
    freq.put("Kel", 28);
    freq.put(" aç", 1027);
    freq.put("Kes", 69);
    freq.put("Ker", 29);
    freq.put("kkü", 301);
    freq.put("RT ", 283);
    freq.put("G", 3336);
    freq.put("ory", 35);
    freq.put("orv", 28);
    freq.put("ort", 714);
    freq.put("oru", 7208);
    freq.put("orr", 81);
    freq.put("ors", 1160);
    freq.put("orn", 74);
    freq.put("oro", 104);
    freq.put("orl", 729);
    freq.put("orm", 921);
    freq.put("ork", 384);
    freq.put("ori", 125);
    freq.put("org", 229);
    freq.put("ord", 856);
    freq.put("ore", 222);
    freq.put("orb", 52);
    freq.put("orc", 49);
    freq.put("ora", 594);
    freq.put("üce", 108);
    freq.put("üca", 68);
    freq.put("App", 43);
    freq.put("ücu", 45);
    freq.put("ücr", 49);
    freq.put("Dı", 44);
    freq.put("Yay", 52);
    freq.put("Yaz", 143);
    freq.put("Yat", 31);
    freq.put("Yav", 27);
    freq.put("kkı", 199);
    freq.put("Yap", 110);
    freq.put("Yas", 49);
    freq.put("Yar", 255);
    freq.put("Yal", 113);
    freq.put("Yan", 151);
    freq.put("Yah", 26);
    freq.put("Yak", 73);
    freq.put(" aş", 653);
    freq.put("Oto", 34);
    freq.put("lap", 40);
    freq.put("Ote", 29);
    freq.put("Dü", 331);
    freq.put("Dö", 64);
    freq.put("İN ", 109);
    freq.put("lsı", 190);
    freq.put("Ya ", 139);
    freq.put(" ağ", 510);
    freq.put("zse", 108);
    freq.put("zsa", 149);
    freq.put("zsi", 135);
    freq.put("Keş", 50);
    freq.put("Do", 388);
    freq.put("Di", 399);
    freq.put("De", 830);
    freq.put("Da", 395);
    freq.put("Du", 263);
    freq.put("Dr", 57);
    freq.put("D ", 1241);
    freq.put("ge ", 226);
    freq.put("üle", 364);
    freq.put("We", 34);
    freq.put("Wa", 43);
    freq.put("Wi", 62);
    freq.put("Wh", 27);
    freq.put("agü", 27);
    freq.put("ges", 106);
    freq.put("ger", 1854);
    freq.put("get", 294);
    freq.put("gez", 182);
    freq.put("gey", 45);
    freq.put("gec", 1236);
    freq.put("geb", 32);
    freq.put("ged", 28);
    freq.put("gen", 688);
    freq.put("RI ", 39);
    freq.put("Ş", 1062);
    freq.put("W ", 29);
    freq.put("zet", 285);
    freq.put("paş", 39);
    freq.put("tu ", 325);
    freq.put("j ", 296);
    freq.put("dk ", 119);
    freq.put("tuy", 87);
    freq.put("tuz", 30);
    freq.put("tup", 61);
    freq.put("ju", 48);
    freq.put("tur", 1049);
    freq.put("tus", 53);
    freq.put("tut", 486);
    freq.put("tuv", 34);
    freq.put("js", 40);
    freq.put("jl", 87);
    freq.put("jo", 52);
    freq.put("geç", 1137);
    freq.put("ji", 349);
    freq.put("tun", 357);
    freq.put("jk", 77);
    freq.put("jd", 124);
    freq.put("je", 215);
    freq.put("tub", 36);
    freq.put("İki", 93);
    freq.put("ja", 199);
    freq.put("cli", 71);
    freq.put("tuh", 36);
    freq.put("tuk", 169);
    freq.put("tul", 253);
    freq.put("tum", 333);
    freq.put("cla", 105);
    freq.put("paç", 31);
    freq.put("tug", 43);
    freq.put("hdi", 40);
    freq.put(" bn", 109);
    freq.put("jı", 137);
    freq.put("pap", 34);
    freq.put("par", 1245);
    freq.put("pas", 169);
    freq.put("pat", 399);
    freq.put("tuğ", 119);
    freq.put("pay", 307);
    freq.put("paz", 232);
    freq.put("pab", 83);
    freq.put("pac", 195);
    freq.put("pad", 53);
    freq.put("pah", 47);
    freq.put("pak", 98);
    freq.put("pal", 210);
    freq.put("pam", 162);
    freq.put("pan", 640);
    freq.put("oin", 26);
    freq.put("A ", 863);
    freq.put("oid", 33);
    freq.put("tuş", 47);
    freq.put("pa ", 268);
    freq.put("rör", 125);
    freq.put("mo ", 35);
    freq.put("içt", 72);
    freq.put("içe", 267);
    freq.put("içb", 163);
    freq.put(" cü", 146);
    freq.put("içm", 68);
    freq.put("içi", 2292);
    freq.put("mor", 82);
    freq.put("mou", 29);
    freq.put("mot", 71);
    freq.put("mok", 61);
    freq.put("mon", 95);
    freq.put("mob", 38);
    freq.put("mod", 175);
    freq.put("zle", 1964);
    freq.put("zla", 903);
    freq.put("zli", 463);
    freq.put("zlu", 141);
    freq.put("Uya", 35);
    freq.put("iç ", 805);
    freq.put("Ned", 121);
    freq.put("Ney", 94);
    freq.put("New", 37);
    freq.put("Net", 37);
    freq.put("Ner", 69);
    freq.put("Med", 50);
    freq.put("kme", 287);
    freq.put(" ci", 906);
    freq.put(" cn", 104);
    freq.put(" co", 1495);
    freq.put(" cl", 37);
    freq.put("Mel", 49);
    freq.put("Men", 38);
    freq.put("Meh", 90);
    freq.put("kmi", 187);
    freq.put(" ce", 1078);
    freq.put("Met", 70);

    init3();
  }
  private static void init3() {
    
    freq.put("kmu", 86);
    freq.put("Mev", 55);
    freq.put("Mes", 128);
    freq.put("Mer", 209);
    freq.put(" cv", 33);
    freq.put(" cu", 271);
    freq.put("Ne ", 363);
    freq.put("km ", 47);
    freq.put(" c ", 32);
    freq.put("ıfı", 63);
    freq.put("zlü", 142);
    freq.put("yyy", 144);
    freq.put("yya", 33);
    freq.put("yyi", 60);
    freq.put("üm ", 1115);
    freq.put("eş ", 233);
    freq.put("zlı", 310);
    freq.put("Ac", 119);
    freq.put("yy ", 155);
    freq.put("ümi", 37);
    freq.put("ümk", 59);
    freq.put("üml", 186);
    freq.put("eşt", 176);
    freq.put("üma", 64);
    freq.put("svi", 31);
    freq.put("ümd", 111);
    freq.put("üme", 208);
    freq.put("Avr", 113);
    freq.put("eşe", 478);
    freq.put("eşk", 174);
    freq.put("eşi", 689);
    freq.put("üms", 55);
    freq.put("eşm", 133);
    freq.put("eşl", 112);
    freq.put("sve", 60);
    freq.put("Uza", 38);
    freq.put("Uyk", 49);
    freq.put("ıft", 29);
    freq.put("Ar", 741);
    freq.put("Ü ", 66);
    freq.put("At", 244);
    freq.put("iği", 2127);
    freq.put("iğe", 255);
    freq.put("iğr", 43);
    freq.put("Üs", 46);
    freq.put("Üz", 52);
    freq.put("u", 86594);
    freq.put("kmı", 271);
    freq.put("Ün", 83);
    freq.put("Ül", 44);
    freq.put(" cı", 186);
    freq.put("ıf ", 53);
    freq.put("Gid", 46);
    freq.put("Val", 64);
    freq.put("değ", 1949);
    freq.put("gt", 42);
    freq.put("Var", 95);
    freq.put("Vat", 26);
    freq.put("gr", 919);
    freq.put("ws ", 26);
    freq.put("aji", 34);
    freq.put("ajl", 73);
    freq.put("ium", 31);
    freq.put("deş", 286);
    freq.put("ÇE ", 31);
    freq.put("got", 52);
    freq.put("gg", 45);
    freq.put("ajd", 31);
    freq.put("eyı", 62);
    freq.put("SI ", 41);
    freq.put("gb", 50);
    freq.put("zü ", 139);
    freq.put("ça ", 228);
    freq.put("aba", 1748);
    freq.put("abb", 140);
    freq.put("şş ", 59);
    freq.put("abi", 2221);
    freq.put("abl", 225);
    freq.put("abo", 44);
    freq.put("abr", 159);
    freq.put("Doğ", 115);
    freq.put("abz", 215);
    freq.put("ırk", 118);
    freq.put("çay", 116);
    freq.put("zür", 58);
    freq.put("ırl", 746);
    freq.put("K", 4526);
    freq.put("çat", 83);
    freq.put("ças", 38);
    freq.put("çar", 211);
    freq.put("çan", 79);
    freq.put("çam", 49);
    freq.put("çal", 684);
    freq.put("çak", 198);
    freq.put("züm", 207);
    freq.put("zül", 178);
    freq.put("zün", 324);
    freq.put("çab", 88);
    freq.put("zük", 40);
    freq.put("ab ", 47);
    freq.put("Süp", 53);
    freq.put("Sür", 37);
    freq.put("eya", 252);
    freq.put("eyc", 27);
    freq.put("eyb", 70);
    freq.put("eye", 2489);
    freq.put("eyd", 428);
    freq.put("eyf", 114);
    freq.put("eyi", 2457);
    freq.put("eyh", 54);
    freq.put("eyk", 75);
    freq.put("twi", 455);
    freq.put("eym", 128);
    freq.put("eyl", 818);
    freq.put("eyo", 57);
    freq.put("eyn", 147);
    freq.put("eys", 372);
    freq.put("eyr", 124);
    freq.put("eyt", 108);
    freq.put("eyv", 82);
    freq.put("de ", 10973);
    freq.put("eyz", 77);
    freq.put("ey ", 1723);
    freq.put("dep", 120);
    freq.put("der", 2678);
    freq.put("des", 720);
    freq.put("det", 207);
    freq.put("dev", 675);
    freq.put("deh", 31);
    freq.put("dei", 44);
    freq.put("dek", 672);
    freq.put("del", 607);
    freq.put("dem", 1732);
    freq.put("den", 5839);
    freq.put("deo", 190);
    freq.put("deb", 154);
    freq.put("dec", 750);
    freq.put("ded", 989);
    freq.put("dee", 73);
    freq.put("def", 256);
    freq.put("deg", 545);
    freq.put("çağ", 133);
    freq.put("ryo", 35);
    freq.put("iPh", 30);
    freq.put("rye", 56);
    freq.put("rya", 183);
    freq.put("şör", 29);
    freq.put("şöy", 60);
    freq.put("Dok", 77);
    freq.put("Don", 34);
    freq.put("Dol", 38);
    freq.put("Dos", 57);
    freq.put("şşş", 98);
    freq.put("ry ", 110);
    freq.put("abı", 466);
    freq.put("aşı", 1559);
    freq.put("ok ", 5658);
    freq.put(" eş", 189);
    freq.put("koş", 115);
    freq.put("AY ", 49);
    freq.put("pca", 55);
    freq.put("şma", 883);
    freq.put("Bat", 52);
    freq.put("okr", 63);
    freq.put("oku", 1277);
    freq.put("okt", 607);
    freq.put("uha", 285);
    freq.put("oky", 27);
    freq.put("Baz", 200);
    freq.put("Bay", 186);
    freq.put("oka", 312);
    freq.put("uht", 153);
    freq.put(" eğ", 274);
    freq.put("Bab", 87);
    freq.put("oki", 36);
    freq.put("okk", 93);
    freq.put("okm", 108);
    freq.put("okl", 115);
    freq.put("oko", 45);
    freq.put("fa ", 509);
    freq.put("mm ", 588);
    freq.put("uşa", 196);
    freq.put("E ", 606);
    freq.put("uşm", 211);
    freq.put("uşl", 82);
    freq.put("uşs", 51);
    freq.put("şec", 39);
    freq.put("kı", 5627);
    freq.put("uşu", 353);
    freq.put("uşt", 263);
    freq.put("Unu", 57);
    freq.put("mmu", 40);
    freq.put("mmm", 522);
    freq.put("sba", 29);
    freq.put("mmi", 53);
    freq.put("mme", 128);
    freq.put("kş", 329);
    freq.put("Em", 174);
    freq.put("El", 221);
    freq.put("En", 308);
    freq.put("Ek", 141);
    freq.put("Ee", 33);
    freq.put("Ed", 116);
    freq.put("Eg", 45);
    freq.put("Ef", 46);
    freq.put("Ec", 28);
    freq.put("Eb", 40);
    freq.put("Ey", 268);
    freq.put("Ez", 29);
    freq.put("Eu", 32);
    freq.put("Et", 66);
    freq.put("Ev", 308);
    freq.put("Es", 196);
    freq.put("Er", 493);
    freq.put("gö", 3002);
    freq.put("aş ", 756);
    freq.put("ıı ", 135);
    freq.put(" el", 1020);
    freq.put(" em", 363);
    freq.put(" en", 1508);
    freq.put(" eh", 112);
    freq.put("kol", 558);
    freq.put(" ek", 566);
    freq.put(" ed", 2268);
    freq.put(" ee", 80);
    freq.put(" ef", 172);
    freq.put(" eg", 155);
    freq.put("kod", 71);
    freq.put(" eb", 48);
    freq.put(" ec", 41);
    freq.put("koy", 524);
    freq.put("koz", 38);
    freq.put(" ey", 270);
    freq.put(" ez", 156);
    freq.put(" et", 1900);
    freq.put("kop", 200);
    freq.put("kos", 76);
    freq.put("kor", 565);
    freq.put("kot", 91);
    freq.put(" er", 937);
    freq.put("kov", 104);
    freq.put("aşv", 41);
    freq.put("aşt", 328);
    freq.put("aşe", 26);
    freq.put("aşb", 129);
    freq.put("aşa", 1068);
    freq.put("aşm", 242);
    freq.put("aşl", 1117);
    freq.put("aşk", 1146);
    freq.put("aşi", 54);
    freq.put("kâ", 30);
    freq.put("b", 63310);
    freq.put("kç", 389);
    freq.put("ko ", 71);
    freq.put(" e ", 547);
    freq.put("zıc", 35);
    freq.put("kö", 730);
    freq.put("kü", 1555);
    freq.put("Eğ", 104);
    freq.put("k ", 28872);
    freq.put("koç", 32);
    freq.put("Kit", 47);
    freq.put("Kim", 175);
    freq.put("Ate", 30);
    freq.put("Ata", 111);
    freq.put("akv", 26);
    freq.put("Atl", 36);
    freq.put("Eş", 26);
    freq.put("kc", 230);
    freq.put("kb", 94);
    freq.put("ka", 19498);
    freq.put("ke", 8572);
    freq.put("kd", 243);
    freq.put("kk", 1675);
    freq.put("ki", 12013);
    freq.put("kh", 72);
    freq.put("ko", 4532);
    freq.put("kn", 210);
    freq.put("km", 1689);
    freq.put("kl", 7517);
    freq.put("ks", 2373);
    freq.put("kr", 842);
    freq.put("kp", 56);
    freq.put("kv", 32);
    freq.put("ku", 4958);
    freq.put("kt", 5011);
    freq.put("kz", 27);
    freq.put("ky", 162);
    freq.put("ıde", 56);
    freq.put("ıda", 253);
    freq.put(" Bö", 115);
    freq.put(" Bü", 219);
    freq.put("İra", 28);
    freq.put("öğü", 27);
    freq.put("Kİ ", 33);
    freq.put("ikç", 72);
    freq.put(" Be", 1754);
    freq.put(" Ba", 1839);
    freq.put(" Bl", 66);
    freq.put(" Bo", 323);
    freq.put(" Bi", 1778);
    freq.put(" Bu", 1750);
    freq.put("ik ", 3263);
    freq.put("Sey", 32);
    freq.put(" Br", 80);
    freq.put("DD ", 28);
    freq.put("iks", 122);
    freq.put("ikr", 106);
    freq.put("ıın", 38);
    freq.put(" B ", 62);
    freq.put("öğr", 388);
    freq.put("ikt", 777);
    freq.put("ikc", 47);
    freq.put("ika", 1110);
    freq.put("ike", 450);
    freq.put("kte", 1041);
    freq.put("öğl", 26);
    freq.put("iki", 1001);
    freq.put("iko", 223);
    freq.put("ikm", 114);
    freq.put("ikl", 1139);
    freq.put("Yem", 58);
    freq.put("Yen", 221);
    freq.put("SK ", 29);
    freq.put("Yer", 78);
    freq.put("Yet", 62);
    freq.put("lbu", 47);
    freq.put("ga ", 265);
    freq.put("çiş", 31);
    freq.put("gaz", 272);
    freq.put("gay", 123);
    freq.put("gat", 33);
    freq.put("gas", 63);
    freq.put("gar", 423);
    freq.put("rak", 2112);
    freq.put("gan", 249);
    freq.put("gam", 74);
    freq.put("gal", 341);
    freq.put("ıdı", 358);
    freq.put("rav", 70);
    freq.put("fut", 274);
    freq.put("fur", 52);
    freq.put("ırı", 1211);
    freq.put("lbe", 128);
    freq.put("ful", 34);
    freq.put("rap", 180);
    freq.put("lbi", 231);
    freq.put("sya", 259);
    freq.put("sye", 36);
    freq.put("syo", 444);
    freq.put(" Bı", 64);
    freq.put("ew ", 44);
    freq.put("AŞ ", 40);
    freq.put("y", 93998);
    freq.put("çö", 208);
    freq.put("lda", 459);
    freq.put("lde", 844);
    freq.put(" Şı", 28);
    freq.put("ldi", 1980);
    freq.put("çü", 449);
    freq.put("ldo", 38);
    freq.put("ldm", 29);
    freq.put("ldu", 2362);
    freq.put("cut", 47);
    freq.put("cus", 110);
    freq.put("rgu", 173);
    freq.put("cuz", 37);
    freq.put("cuy", 45);
    freq.put("cug", 54);
    freq.put("rga", 156);
    freq.put("cud", 37);
    freq.put("rge", 197);
    freq.put("çün", 187);
    freq.put("rgi", 159);
    freq.put("cum", 266);
    freq.put("cul", 268);
    freq.put("cuk", 536);
    freq.put("rgo", 28);
    freq.put("Dil", 58);
    freq.put("Din", 60);
    freq.put("ld ", 84);
    freq.put("bik", 115);
    freq.put("Dik", 35);
    freq.put("bid", 263);
    freq.put("bie", 32);
    freq.put("bic", 59);
    freq.put("biz", 1439);
    freq.put("Diy", 54);
    freq.put("biy", 262);
    freq.put("nsı", 271);
    freq.put("bit", 751);
    freq.put("bir", 7703);
    freq.put("bis", 322);
    freq.put("üyü", 668);
    freq.put("rg ", 33);
    freq.put("api", 377);
    freq.put("cu ", 403);
    freq.put("ütü", 319);
    freq.put("çu", 229);
    freq.put("çt", 592);
    freq.put("çs", 100);
    freq.put("çr", 29);
    freq.put("uf ", 34);
    freq.put("çe", 2685);
    freq.put("çd", 27);
    freq.put("çb", 165);
    freq.put("ça", 1989);
    freq.put("ço", 2879);
    freq.put("çm", 613);
    freq.put("çl", 693);
    freq.put("çk", 62);
    freq.put("çi", 3478);
    freq.put("ldü", 375);
    freq.put("üt ", 41);
    freq.put("pey", 61);
    freq.put("pet", 47);
    freq.put("rgü", 121);
    freq.put("per", 593);
    freq.put("pes", 73);
    freq.put("pem", 37);
    freq.put("pen", 125);
    freq.put("pek", 364);
    freq.put("ped", 40);
    freq.put("Boy", 31);
    freq.put("ufa", 65);
    freq.put("Bor", 42);
    freq.put("Bos", 31);
    freq.put("use", 125);
    freq.put("O", 2288);
    freq.put("Bol", 30);
    freq.put("ç ", 2360);
    freq.put("Bod", 32);
    freq.put("ufu", 40);
    freq.put("ütf", 219);
    freq.put(" gı", 196);
    freq.put("üth", 42);
    freq.put("pe ", 118);
    freq.put("usm", 155);
    freq.put("nsi", 334);
    freq.put("nsl", 107);
    freq.put("nso", 49);
    freq.put("nsa", 1792);
    freq.put("nse", 392);
    freq.put("ğün", 180);
    freq.put("nsp", 98);
    freq.put("nst", 49);
    freq.put("nsu", 134);
    freq.put(" gö", 2968);
    freq.put(" Öz", 228);
    freq.put("mka", 58);
    freq.put(" gü", 3515);
    freq.put("usu", 1318);
    freq.put("mki", 171);
    freq.put("ust", 620);
    freq.put("Maç", 62);
    freq.put("uss", 47);
    freq.put(" R ", 38);
    freq.put("ğü ", 102);
    freq.put("oğr", 497);
    freq.put("ns ", 236);
    freq.put(" ça", 1316);
    freq.put(" Şu", 139);
    freq.put("Ulu", 38);
    freq.put(" Şi", 223);
    freq.put("oğd", 35);
    freq.put("ldı", 1617);
    freq.put("oğa", 315);
    freq.put("sda", 26);
    freq.put(" Şa", 278);
    freq.put("oğl", 356);
    freq.put("Ula", 59);
    freq.put(" Şe", 229);
    freq.put("rgı", 70);
    freq.put("mk ", 165);
    freq.put("biş", 346);
    freq.put("fey", 33);
    freq.put("peş", 70);
    freq.put("lye", 39);
    freq.put("nsü", 42);
    freq.put("lya", 249);
    freq.put(" e", 12719);
    freq.put("lyo", 171);
    freq.put("Mas", 39);
    freq.put("Mar", 156);
    freq.put(" gr", 205);
    freq.put(" gs", 44);
    freq.put("Boğ", 31);
    freq.put("tva", 33);
    freq.put("Mac", 43);
    freq.put(" ge", 8268);
    freq.put(" gb", 29);
    freq.put("Mad", 107);
    freq.put(" j", 221);
    freq.put(" ga", 864);
    freq.put("Mah", 41);
    freq.put("Mak", 39);
    freq.put("mkü", 59);
    freq.put("Mal", 73);
    freq.put("Man", 85);
    freq.put("çı", 2846);
    freq.put(" ch", 78);
    freq.put("ly ", 47);
    freq.put("kma", 765);
    freq.put("Boş", 40);
    freq.put(" g ", 54);
    freq.put(" b", 45251);
    freq.put(" c", 6058);
    freq.put(" ca", 1590);
    freq.put(" f", 5175);
    freq.put(" g", 23367);
    freq.put(" d", 31937);
    freq.put("ön ", 58);
    freq.put("Az ", 50);
    freq.put(" k", 27402);
    freq.put(" h", 15495);
    freq.put(" i", 18637);
    freq.put(" n", 9093);
    freq.put(" o", 21644);
    freq.put(" l", 3578);
    freq.put(" m", 12334);
    freq.put(" r", 2863);
    freq.put(" s", 28558);
    freq.put(" p", 5014);
    freq.put(" q", 65);
    freq.put(" v", 10909);
    freq.put("Mek", 32);
    freq.put(" t", 14002);
    freq.put(" u", 4698);
    freq.put(" z", 3496);
    freq.put(" x", 85);
    freq.put(" y", 26683);
    freq.put(" B", 8680);
    freq.put(" C", 1785);
    freq.put(" A", 7220);
    freq.put(" F", 2132);
    freq.put(" G", 3318);
    freq.put(" D", 6515);
    freq.put(" E", 3004);
    freq.put(" J", 272);
    freq.put(" K", 4482);
    freq.put(" H", 3722);
    freq.put(" I", 740);
    freq.put(" N", 1708);
    freq.put(" O", 2269);
    freq.put(" L", 972);
    freq.put(" M", 3267);
    freq.put(" R", 1453);
    freq.put(" S", 5952);
    freq.put(" P", 1916);
    freq.put(" Q", 39);
    freq.put(" V", 983);
    freq.put(" W", 233);
    freq.put(" T", 4918);
    freq.put(" U", 891);
    freq.put(" Z", 487);
    freq.put(" X", 51);
    freq.put(" Y", 3196);
    freq.put("vli", 69);
    freq.put("Azi", 70);
    freq.put("öne", 647);
    freq.put("önd", 319);
    freq.put("önc", 525);
    freq.put("vla", 161);
    freq.put("önm", 79);
    freq.put("önl", 90);
    freq.put("vle", 383);
    freq.put(" Dı", 42);
    freq.put("Fı", 44);
    freq.put("dde", 240);
    freq.put("û", 37);
    freq.put(" ç", 7121);
    freq.put(" ö", 4166);
    freq.put("nuç", 113);
    freq.put(" ü", 1771);
    freq.put(" Ç", 1124);
    freq.put("Ort", 74);
    freq.put(" Ö", 779);
    freq.put("Orh", 28);
    freq.put("Ord", 30);
    freq.put(" Ü", 344);
    freq.put("Ora", 34);
    freq.put("ock", 53);
    freq.put("İta", 26);
    freq.put("önü", 464);
    freq.put("̅ ", 29);
    freq.put("Yı", 211);
    freq.put("çmı", 42);
    freq.put("afı", 326);
    freq.put(" Do", 383);
    freq.put("Ver", 67);
    freq.put(" Di", 392);
    freq.put(" De", 825);
    freq.put(" Da", 389);
    freq.put("ii ", 405);
    freq.put(" Du", 262);
    freq.put(" Dr", 57);
    freq.put("cha", 50);
    freq.put("Fr", 104);
    freq.put("che", 83);
    freq.put("chi", 27);
    freq.put("Fa", 475);
    freq.put("Yü", 126);
    freq.put("Fi", 222);
    freq.put(" Ş", 1054);
    freq.put(" ş", 4818);
    freq.put("Yö", 39);
    freq.put("iir", 93);
    freq.put(" D ", 1047);
    freq.put(" İ", 2749);
    freq.put(" ı", 1479);
    freq.put("Ve ", 184);
    freq.put("iim", 146);
    freq.put("iil", 76);
    freq.put("iin", 44);
    freq.put("iii", 461);
    freq.put("ch ", 63);
    freq.put("dön", 541);
    freq.put("dök", 56);
    freq.put("f", 14717);
    freq.put("Bir", 909);
    freq.put("F ", 242);
    freq.put("döv", 71);
    freq.put("dör", 43);
    freq.put("Dön", 42);
    freq.put(" Dö", 64);
    freq.put("Yi", 125);
    freq.put("çmi", 179);
    freq.put("afo", 35);
    freq.put("afi", 405);
    freq.put("Yo", 367);
    freq.put("Ya", 1341);
    freq.put("afe", 208);
    freq.put("çma", 198);
    freq.put("Ye", 513);
    freq.put("afa", 599);
    freq.put("çme", 189);
    freq.put("aft", 677);
    freq.put("Yu", 104);
    freq.put("ıms", 71);
    freq.put("afr", 35);
    freq.put("sis", 238);
    freq.put("Y ", 120);
    freq.put("af ", 370);
    freq.put(" çü", 175);
    freq.put("da ", 11264);
    freq.put("ıma", 573);
    freq.put("lf", 59);
    freq.put("lg", 1033);
    freq.put("ld", 7846);
    freq.put("le", 28419);
    freq.put("lb", 587);
    freq.put("lc", 701);
    freq.put("la", 36400);
    freq.put("ln", 381);
    freq.put("ıme", 30);
    freq.put("ll", 5745);
    freq.put("lm", 7735);
    freq.put("lk", 2073);
    freq.put("lh", 71);
    freq.put("ımd", 476);
    freq.put("lv", 97);
    freq.put("lt", 1283);
    freq.put("lu", 7084);
    freq.put("lr", 174);
    freq.put("ls", 2995);
    freq.put("lp", 168);
    freq.put("tsu", 79);
    freq.put("lz", 39);
    freq.put("reç", 43);
    freq.put("ly", 586);
    freq.put("dad", 87);
    freq.put("daf", 46);
    freq.put("dag", 48);
    freq.put("daa", 78);
    freq.put("dal", 379);
    freq.put("dam", 1255);
    freq.put("dan", 4003);
    freq.put("dah", 1710);
    freq.put("dai", 70);
    freq.put("dak", 1021);
    freq.put("dat", 101);
    freq.put("dav", 360);
    freq.put("dar", 2138);
    freq.put("das", 429);
    freq.put("day", 740);
    freq.put(" öğ", 417);
    freq.put("l ", 10913);
    freq.put("ts ", 63);
    freq.put("pül", 33);
    freq.put("mü ", 216);
    freq.put("miş", 1802);
    freq.put("rez", 168);
    freq.put("lç", 189);
    freq.put("vüz", 39);
    freq.put("lâ", 56);
    freq.put("ğmu", 115);
    freq.put("rer", 183);
    freq.put("res", 806);
    freq.put("rep", 65);
    freq.put("rev", 109);
    freq.put("ret", 1011);
    freq.put("rek", 1731);
    freq.put("reh", 35);
    freq.put("rei", 31);
    freq.put("ren", 1464);
    freq.put("rel", 270);
    freq.put("rem", 489);
    freq.put("reb", 173);
    freq.put("rec", 402);
    freq.put("vüc", 31);
    freq.put("rea", 88);
    freq.put("ref", 141);
    freq.put("reg", 44);
    freq.put("red", 401);
    freq.put("ree", 53);
    freq.put("mür", 75);
    freq.put("müs", 93);
    freq.put(" iy", 1737);
    freq.put("müt", 51);
    freq.put("müz", 268);
    freq.put("müy", 93);
    freq.put("qua", 26);
    freq.put("müc", 65);
    freq.put("que", 35);
    freq.put("müd", 73);
    freq.put("mük", 49);
    freq.put("müh", 27);
    freq.put("mün", 160);
    freq.put("mül", 38);
    freq.put("müm", 72);
    freq.put("re ", 2070);
    freq.put("rüy", 237);
    freq.put("og ", 50);
    freq.put(" öd", 136);
    freq.put(" ök", 38);
    freq.put("nuy", 254);
    freq.put(" öm", 76);
    freq.put(" öl", 681);
    freq.put(" ön", 1025);
    freq.put(" öp", 139);
    freq.put(" ör", 126);
    freq.put(" öt", 64);
    freq.put(" öv", 32);
    freq.put(" öy", 615);
    freq.put(" öz", 701);
    freq.put("udu", 389);
    freq.put("ogu", 186);
    freq.put("ogr", 477);
    freq.put("ogl", 184);
    freq.put("uda", 283);
    freq.put("rüs", 69);
    freq.put("udi", 34);
    freq.put("oga", 102);
    freq.put("üve", 170);
    freq.put("nun", 1475);
    freq.put(" ̅", 29);
    freq.put("Dış", 29);
    freq.put("nul", 82);
    freq.put("rün", 398);
    freq.put("lı", 9590);
    freq.put("daş", 645);
    freq.put("tsı", 122);
    freq.put("Par", 198);
    freq.put("Pat", 39);
    freq.put("Paz", 77);
    freq.put("mii", 53);
    freq.put("mih", 26);
    freq.put("mik", 183);
    freq.put("mim", 153);
    freq.put("mil", 594);
    freq.put("mio", 59);
    freq.put("min", 1427);
    freq.put("mic", 117);
    freq.put("mid", 155);
    freq.put("miy", 1665);
    freq.put("miz", 1532);
    freq.put("mis", 1277);
    freq.put("mir", 372);
    freq.put("mit", 98);
    freq.put("reğ", 96);
    freq.put("vde", 278);
    freq.put("sfe", 140);
    freq.put("mus", 633);
    freq.put("mi ", 3319);
    freq.put("müş", 223);
    freq.put(" iP", 43);
    freq.put("ksu", 83);
    freq.put("kst", 40);
    freq.put(" iz", 990);
    freq.put(" ip", 156);
    freq.put("Mor", 32);
    freq.put(" ir", 96);
    freq.put(" is", 2888);
    freq.put(" it", 256);
    freq.put("kse", 289);
    freq.put(" ii", 63);
    freq.put(" ik", 655);
    freq.put(" il", 2309);
    freq.put("Mon", 34);
    freq.put(" in", 3139);
    freq.put(" ia", 32);
    freq.put(" ib", 114);
    freq.put(" ic", 685);
    freq.put(" id", 226);
    freq.put(" if", 240);
    freq.put("Mod", 53);
    freq.put("ölç", 26);
    freq.put("ölü", 412);
    freq.put("ükü", 137);
    freq.put("ks ", 91);
    freq.put(" i ", 386);
    freq.put("ükç", 28);
    freq.put(" Iz", 34);
    freq.put("Zor", 37);
    freq.put("ksü", 32);
    freq.put("ük ", 852);
    freq.put(" iç", 2608);
    freq.put(" Fı", 44);
    freq.put("wl", 32);
    freq.put("ölm", 108);
    freq.put("vru", 237);
    freq.put("öle", 188);
    freq.put("öld", 218);
    freq.put("ölg", 56);
    freq.put("S", 5992);
    freq.put("vre", 127);
    freq.put("vri", 137);
    freq.put("ükt", 46);
    freq.put("ükr", 37);
    freq.put("üks", 171);
    freq.put("ükl", 216);
    freq.put("ükk", 57);
    freq.put("ws", 46);
    freq.put("üke", 130);
    freq.put(" iş", 1298);
    freq.put("oho", 40);
    freq.put("ohh", 45);
    freq.put("ad", 12599);
    freq.put("ak", 18096);
    freq.put(" iğ", 51);
    freq.put("oha", 68);
    freq.put("cor", 29);
    freq.put("ohb", 56);
    freq.put("ysi", 37);
    freq.put("ksı", 350);
    freq.put("ysa", 248);
    freq.put("yse", 514);
    freq.put("UM ", 56);
    freq.put("ysu", 39);
    freq.put("Ülk", 43);
    freq.put("coz", 49);
    freq.put(" Fu", 123);
    freq.put(" Fa", 473);
    freq.put(" Fe", 629);
    freq.put(" Fi", 214);
    freq.put(" Fl", 36);
    freq.put(" Fo", 132);
    freq.put("io ", 118);
    freq.put("coc", 155);
    freq.put("niş", 79);
    freq.put("ios", 45);
    freq.put("ior", 137);
    freq.put("ion", 148);
    freq.put("iom", 29);
    freq.put("con", 73);
    freq.put("çoo", 66);
    freq.put("adr", 289);
    freq.put("çok", 2238);
    freq.put("Değ", 77);
    freq.put("gma", 60);
    freq.put("bep", 51);
    freq.put("çoc", 384);
    freq.put("ady", 97);
    freq.put("add", 170);
    freq.put("ade", 1143);
    freq.put("ada", 5807);
    freq.put("ado", 99);
    freq.put("adl", 70);
    freq.put("adm", 26);
    freq.put("gmu", 49);
    freq.put("çor", 29);
    freq.put("rcı", 47);
    freq.put("ad ", 171);
    freq.put("Acı", 41);
    freq.put("esu", 73);
    freq.put("est", 700);
    freq.put("ess", 304);
    freq.put("tmu", 75);
    freq.put("esp", 127);
    freq.put("esy", 45);
    freq.put("tma", 895);
    freq.put("ese", 1139);
    freq.put("esc", 32);
    freq.put("tme", 1706);
    freq.put("esa", 631);
    freq.put("piş", 138);
    freq.put("esn", 61);
    freq.put("esm", 388);
    freq.put("esl", 322);
    freq.put("esk", 358);
    freq.put("tmm", 43);
    freq.put("esi", 4205);
    freq.put("Bül", 38);
    freq.put("Büy", 112);
    freq.put("Büt", 58);
    freq.put("tm ", 46);
    freq.put("es ", 981);
    freq.put("Twe", 35);
    freq.put("Twi", 179);
    freq.put("piç", 31);
    freq.put("bu ", 3760);
    freq.put("rcu", 121);
    freq.put("rci", 203);
    freq.put("rce", 351);
    freq.put("yşe", 33);
    freq.put("rca", 321);
    freq.put("buz", 41);
    freq.put("buy", 191);
    freq.put("bur", 898);
    freq.put("bus", 95);
    freq.put("Der", 137);
    freq.put("Des", 45);
    freq.put("Det", 31);
    freq.put("Dev", 119);
    freq.put("buk", 173);
    freq.put("çoğ", 96);
    freq.put("Del", 31);
    freq.put("Dem", 140);
    freq.put("Den", 111);
    freq.put("buc", 35);
    freq.put("Ded", 39);
    freq.put("bug", 602);
    freq.put("Def", 27);
    freq.put("Lİ ", 45);
    freq.put("adı", 3281);
    freq.put("j", 1730);
    freq.put("Rİ ", 47);
    freq.put("pik", 69);
    freq.put("pil", 112);
    freq.put("pim", 111);
    freq.put("pin", 147);
    freq.put("pic", 64);
    freq.put("piy", 429);
    freq.put("AB ", 32);
    freq.put("ub ", 29);
    freq.put("pir", 68);
    freq.put("pis", 174);
    freq.put("pit", 71);
    freq.put("üp ", 128);
    freq.put("eğe", 640);
    freq.put("ümü", 428);
    freq.put("eği", 2813);
    freq.put("eğm", 51);
    freq.put("eğl", 112);
    freq.put("ubu", 130);
    freq.put("Aca", 30);
    freq.put("pi ", 54);
    freq.put("ube", 76);
    freq.put("uba", 79);
    freq.put("ubl", 26);
    freq.put("tmı", 140);
    freq.put("üpl", 26);
    freq.put("esı", 110);
    freq.put("üph", 44);
    freq.put("üpe", 215);
    freq.put("ısa", 195);
    freq.put("ıse", 53);
    freq.put("ısk", 94);
    freq.put("ısm", 107);
    freq.put("ısl", 63);
    freq.put("ıss", 35);
    freq.put("ısr", 31);
    freq.put(" kö", 586);
    freq.put("ıst", 148);
    freq.put(" kü", 473);
    freq.put("Oku", 119);
    freq.put("ğme", 109);
    freq.put("mı", 6958);
    freq.put("G ", 106);
    freq.put("ıs ", 170);
    freq.put("mş", 96);
    freq.put("Gu", 179);
    freq.put("Gr", 83);
    freq.put("zdu", 52);
    freq.put("Ge", 717);
    freq.put("zdi", 247);
    freq.put("Ga", 444);
    freq.put("Go", 186);
    freq.put("zda", 428);
    freq.put("Gi", 242);
    freq.put(" ka", 11417);
    freq.put(" kd", 51);
    freq.put(" ke", 2836);
    freq.put(" ki", 3700);
    freq.put(" ko", 3617);
    freq.put(" kl", 187);
    freq.put(" km", 50);
    freq.put(" kr", 212);
    freq.put(" ku", 2372);
    freq.put("kuz", 214);
    freq.put("kuy", 329);
    freq.put("kuv", 35);
    freq.put("kut", 328);
    freq.put("Z ", 195);
    freq.put("kur", 951);
    freq.put("kup", 124);
    freq.put("kun", 333);
    freq.put("kum", 405);
    freq.put("kul", 1188);
    freq.put("kuk", 75);
    freq.put("kud", 129);
    freq.put("kuc", 69);
    freq.put(" k ", 77);
    freq.put("ını", 3971);
    freq.put("zmn", 36);
    freq.put("TT ", 64);
    freq.put("Gö", 343);
    freq.put("Zo", 51);
    freq.put("Zi", 69);
    freq.put("Ze", 75);
    freq.put("Gü", 629);
    freq.put("Za", 228);
    freq.put("enı", 188);
    freq.put("ku ", 325);
    freq.put("Gök", 62);
    freq.put("tu", 3591);
    freq.put("Kom", 44);
    freq.put("Kol", 40);
    freq.put("Kon", 122);
    freq.put("Koc", 42);
    freq.put("Koy", 31);
    freq.put("ör ", 157);
    freq.put("vp ", 29);
    freq.put("Gör", 81);
    freq.put("Kor", 73);
    freq.put("tn", 102);
    freq.put("m ", 34858);
    freq.put("enç", 244);
    freq.put("zdı", 317);
    freq.put("enü", 67);
    freq.put("klı", 903);
    freq.put("örs", 42);
    freq.put("ört", 104);
    freq.put("tf", 381);
    freq.put("ısı", 1422);
    freq.put("örg", 42);
    freq.put("öre", 529);
    freq.put("örd", 300);
    freq.put("öri", 28);
    freq.put("örn", 55);
    freq.put("örm", 284);
    freq.put("örl", 60);
    freq.put("me", 15247);
    freq.put("md", 3402);
    freq.put("mg", 29);
    freq.put("eç ", 168);
    freq.put("ma", 25700);
    freq.put("g", 36385);
    freq.put("mc", 390);
    freq.put("mb", 556);
    freq.put("mm", 1544);
    freq.put("ml", 2484);
    freq.put("mo", 691);
    freq.put("mn", 182);
    freq.put("mi", 13005);
    freq.put("mh", 89);
    freq.put("mk", 518);
    freq.put("tc", 140);
    freq.put("mu", 5190);
    freq.put("mt", 46);
    freq.put("mp", 598);
    freq.put("ms", 1196);
    freq.put("mr", 275);
    freq.put("my", 132);
    freq.put("mz", 173);
    freq.put("kuş", 116);
    freq.put("ıns", 58);
    freq.put("Koç", 28);
    freq.put("ınd", 3041);
    freq.put("ıne", 66);
    freq.put("ına", 1824);
    freq.put("ınc", 307);
    freq.put("ınl", 580);
    freq.put("ınm", 125);
    freq.put("ınn", 84);
    freq.put("ınk", 35);
    freq.put("ena", 480);
    freq.put("enc", 1020);
    freq.put("end", 3252);
    freq.put("ene", 2509);
    freq.put("enf", 36);
    freq.put("eng", 424);
    freq.put("eni", 6339);
    freq.put("enk", 262);
    freq.put("enl", 988);
    freq.put("enm", 618);
    freq.put("enn", 203);
    freq.put("eno", 38);
    freq.put("ens", 339);
    freq.put("ent", 413);
    freq.put("enu", 28);
    freq.put("eny", 32);
    freq.put("enz", 216);
    freq.put("nuş", 492);
    freq.put("ON ", 44);
    freq.put("örü", 681);
    freq.put(" kı", 1727);
    freq.put("ın ", 8073);
    freq.put("en ", 17894);
    freq.put("mü", 1636);
    freq.put(" Hz", 41);
    freq.put("Üni", 55);
    freq.put(" Hu", 76);
    freq.put(" Hi", 291);
    freq.put(" Ho", 207);
    freq.put(" Ha", 1707);
    freq.put(" He", 884);
    freq.put("ima", 407);
    freq.put("imc", 63);
    freq.put("imb", 49);
    freq.put("ime", 707);
    freq.put("imd", 1739);
    freq.put("imi", 2739);
    freq.put("cle", 44);
    freq.put("imk", 174);
    freq.put("imm", 217);
    freq.put("iml", 569);
    freq.put("imo", 45);
    freq.put("çiç", 50);
    freq.put("imp", 32);
    freq.put("ims", 529);
    freq.put("clu", 37);
    freq.put("imz", 68);
    freq.put("toğ", 179);
    freq.put("SA ", 33);
    freq.put(" H ", 28);
    freq.put("im ", 11272);
    freq.put("ğiş", 306);
    freq.put(" Hü", 95);
    freq.put("gol", 310);
    freq.put("goo", 51);
    freq.put("gon", 89);
    freq.put("çis", 29);
    freq.put("çir", 173);
    freq.put("çiz", 74);
    freq.put("çiy", 136);
    freq.put("çif", 58);
    freq.put("çic", 28);
    freq.put("goz", 156);
    freq.put("raş", 160);
    freq.put("çim", 227);
    freq.put("çil", 181);
    freq.put("çik", 67);
    freq.put("gos", 77);
    freq.put("gor", 465);
    freq.put("ağı", 1386);
    freq.put("nid", 171);
    freq.put("W", 237);
    freq.put("Vic", 26);
    freq.put("Vid", 83);
    freq.put("go ", 72);
    freq.put("eçe", 407);
    freq.put("çi ", 174);
    freq.put("aj ", 218);
    freq.put("rağ", 131);
    freq.put("be ", 620);
    freq.put("raç", 71);
    freq.put("nho", 31);
    freq.put("lbü", 111);
    freq.put("nir", 530);
    freq.put("vve", 67);
    freq.put("toz", 27);
    freq.put("toy", 39);
    freq.put("tor", 420);
    freq.put("tos", 209);
    freq.put("top", 628);
    freq.put("tok", 83);
    freq.put("ton", 162);
    freq.put("tol", 88);
    freq.put("tom", 81);
    freq.put("tob", 121);
    freq.put("tog", 73);
    freq.put("Fut", 87);
    freq.put(" Hı", 71);
    freq.put("to ", 209);
    freq.put("raf", 951);
    freq.put("rag", 113);
    freq.put("rad", 1048);
    freq.put("rab", 756);
    freq.put("ağr", 108);
    freq.put("raa", 53);
    freq.put("ran", 1391);
    freq.put("ral", 913);
    freq.put("ram", 1356);
    freq.put("raj", 32);
    freq.put("ağz", 96);
    freq.put("rah", 403);
    freq.put("rai", 140);
    freq.put("lba", 46);
    freq.put("rat", 459);
    freq.put("ağd", 89);
    freq.put("rar", 961);
    freq.put("ras", 1025);
    freq.put("ağa", 267);
    freq.put("ağo", 96);
    freq.put("ağm", 183);
    freq.put("ağl", 608);
    freq.put("raz", 574);
    freq.put("ray", 934);
    freq.put("ğiz", 76);
    freq.put("ğiy", 38);
    freq.put("ğit", 82);
    freq.put("ğin", 1214);
    freq.put("ğim", 896);
    freq.put("ğil", 1430);
    freq.put("ra ", 3396);
    freq.put("şüm", 26);
    freq.put("ağ ", 115);
    freq.put("abe", 963);
    freq.put("ajı", 122);
    freq.put("AS ", 34);
    freq.put("ği ", 890);
    freq.put("şüy", 35);
    freq.put("pkk", 53);
    freq.put("pki", 88);
    freq.put("Bin", 27);
    freq.put("Bil", 262);
    freq.put("oca", 510);
    freq.put("ür ", 778);
    freq.put("Küç", 41);
    freq.put("Biz", 306);
    freq.put("Bit", 39);
    freq.put("ocu", 619);
    freq.put("abu", 320);
    freq.put(" mı", 1277);
    freq.put("ürp", 34);
    freq.put("ürs", 83);
    freq.put("ürr", 56);
    freq.put("ürt", 82);
    freq.put("Bi ", 139);
    freq.put("üre", 576);
    freq.put("ürd", 145);
    freq.put("Sİ ", 41);
    freq.put("ürk", 1098);
    freq.put("ürm", 146);
    freq.put("ürl", 365);
    freq.put("nuz", 621);
    freq.put("rüz", 77);
    freq.put("nuv", 26);
    freq.put("rüt", 27);
    freq.put("nut", 468);
    freq.put("nur", 138);
    freq.put("nus", 346);
    freq.put("Per", 47);
    freq.put("rür", 112);
    freq.put("rüm", 108);
    freq.put("rül", 118);
    freq.put("Pen", 27);
    freq.put("num", 389);
    freq.put("nuk", 39);
    freq.put("rük", 28);
    freq.put("Pek", 61);
    freq.put("nud", 92);
    freq.put("nuc", 119);
    freq.put("rüc", 38);
    freq.put("rüb", 27);
    freq.put("mut", 730);
    freq.put("Kür", 40);
    freq.put("mur", 322);
    freq.put("muy", 327);
    freq.put("muz", 386);
    freq.put("mud", 91);
    freq.put("mua", 53);
    freq.put("muc", 43);
    freq.put("mub", 36);
    freq.put("mum", 80);
    freq.put("mun", 263);
    freq.put("muh", 303);
    freq.put("muk", 59);
    freq.put("zbe", 42);
    freq.put("rü ", 154);
    freq.put("nu ", 2468);
    freq.put("ell", 1028);
    freq.put("ürü", 657);
    freq.put("çtı", 140);
    freq.put("mu ", 897);
    freq.put(" me", 2134);
    freq.put(" ma", 2791);
    freq.put(" mo", 404);
    freq.put(" mi", 2668);
    freq.put(" mu", 1877);
    freq.put(" ms", 73);
    freq.put("üse", 41);
    freq.put(" m ", 146);
    freq.put("öpü", 55);
    freq.put("TV ", 118);
    freq.put("Tüm", 67);
    freq.put("n", 178334);
    freq.put("Tür", 735);
    freq.put("muş", 853);
    freq.put(" mü", 817);
    freq.put("çta", 148);
    freq.put("rüş", 170);
    freq.put("çte", 43);
    freq.put("çti", 240);
    freq.put("HP ", 69);
    freq.put("öpr", 32);
    freq.put("öpe", 123);
    freq.put("öpo", 28);
    freq.put("vic", 98);
    freq.put("ıls", 168);
    freq.put("ıll", 292);
    freq.put("ılm", 665);
    freq.put("ılg", 49);
    freq.put("ıld", 722);
    freq.put("ıle", 101);
    freq.put("ıla", 1511);
    freq.put("elk", 281);
    freq.put("eli", 3920);
    freq.put("elo", 113);
    freq.put("Hü", 95);
    freq.put("elm", 695);
    freq.put("elb", 81);
    freq.put("elc", 54);
    freq.put("ela", 580);
    freq.put("elg", 81);
    freq.put("eld", 1142);
    freq.put("ele", 3404);
    freq.put("els", 298);
    freq.put("elv", 30);
    freq.put("elt", 107);
    freq.put("D", 6573);
    freq.put("İzm", 98);
    freq.put("İzl", 57);
    freq.put("ahı", 203);
    freq.put("ıl ", 1044);
    freq.put("el ", 2593);
    freq.put("tiş", 132);
    freq.put(" Ju", 42);
    freq.put(" Jo", 60);
    freq.put("nş", 261);
    freq.put(" Je", 44);
    freq.put(" Ja", 64);
    freq.put("ick", 57);
    freq.put("ici", 991);
    freq.put("ich", 41);
    freq.put("ico", 52);
    freq.put("icb", 37);
    freq.put("ica", 403);
    freq.put("elç", 61);
    freq.put("ice", 707);
    freq.put("Hu", 76);
    freq.put("Hi", 292);
    freq.put("Ho", 207);
    freq.put("icr", 30);
    freq.put("Ha", 1712);
    freq.put("ict", 56);
    freq.put("tiğ", 342);
    freq.put("hse", 128);
    freq.put("hsi", 40);
    freq.put("hsu", 28);
    freq.put("ic ", 331);
    freq.put("nı", 9903);
    freq.put("H ", 121);
    freq.put("ahc", 113);
    freq.put("aha", 3740);
    freq.put("ahe", 31);
    freq.put("ökt", 41);
    freq.put("ahh", 195);
    freq.put("ahi", 658);
    freq.put("ahn", 83);
    freq.put("ahl", 155);
    freq.put("ppl", 49);
    freq.put("ahr", 104);
    freq.put("ahs", 196);
    freq.put("ahv", 246);
    freq.put("aht", 150);
    freq.put("ahu", 266);
    freq.put("git", 975);
    freq.put("gis", 339);
    freq.put("gir", 848);
    freq.put("giz", 153);
    freq.put("giy", 271);
    freq.put("nç", 539);
    freq.put("çki", 28);
    freq.put("gid", 1182);
    freq.put("nü", 1797);
    freq.put("gib", 1686);
    freq.put("gin", 924);
    freq.put("gim", 589);
    freq.put("gil", 1233);
    freq.put("nö", 37);
    freq.put("ah ", 1599);
    freq.put("pp ", 30);
    freq.put("ılı", 1421);
    freq.put("eyy", 71);
    freq.put("Söz", 70);
    freq.put("Söy", 34);
    freq.put("Vol", 37);
    freq.put("gi ", 954);
    freq.put("elı", 102);
    freq.put("mşu", 38);
    freq.put("oşu", 152);
    freq.put("nnn", 331);
    freq.put("oşv", 49);
    freq.put("ahç", 467);
    freq.put("nni", 49);
    freq.put("nne", 607);
    freq.put("nna", 57);
    freq.put("oşg", 53);
    freq.put("oşa", 88);
    freq.put("oşl", 60);
    freq.put("oşk", 35);
    freq.put("nh", 54);
    freq.put("ni", 16442);
    freq.put("nj", 45);
    freq.put("nk", 1871);
    freq.put("nl", 9358);
    freq.put("nm", 2570);
    freq.put("nn", 1510);
    freq.put("no", 968);
    freq.put("tit", 28);
    freq.put("na", 11803);
    freq.put("nb", 646);
    freq.put("nc", 4253);
    freq.put("nd", 15239);
    freq.put("ne", 15014);
    freq.put("nf", 149);
    freq.put("ng", 1455);
    freq.put("til", 540);
    freq.put("ny", 1200);
    freq.put("nz", 388);
    freq.put("tio", 133);
    freq.put("tih", 143);
    freq.put("tii", 32);
    freq.put("ES ", 27);
    freq.put("np", 117);
    freq.put("nr", 1410);
    freq.put("ns", 3720);
    freq.put("nt", 2052);
    freq.put("nu", 7258);
    freq.put("nv", 51);
    freq.put("tic", 200);
    freq.put("Hz", 41);
    freq.put("nn ", 347);
    freq.put("cnu", 41);
    freq.put("oş ", 268);
    freq.put("n ", 66775);
    freq.put("Hı", 71);
    freq.put("ti ", 1784);
    freq.put("roi", 40);
    freq.put("roj", 79);
    freq.put("rol", 225);
    freq.put("rom", 145);
    freq.put("ron", 189);
    freq.put("rob", 89);
    freq.put("roc", 26);
    freq.put("rod", 34);
    freq.put("rof", 140);
    freq.put("rog", 242);
    freq.put("roy", 38);
    freq.put("lli", 817);
    freq.put("llo", 174);
    freq.put("lll", 128);
    freq.put("rop", 34);
    freq.put("ror", 31);
    freq.put("icd", 63);
    freq.put("rot", 63);
    freq.put("lle", 1250);
    freq.put("Dal", 28);
    freq.put("Dah", 106);
    freq.put("Dak", 26);
    freq.put(" üç", 104);
    freq.put("Dav", 62);
    freq.put("dey", 503);
    freq.put("ro ", 166);
    freq.put("Cin", 37);
    freq.put("ll ", 257);
    freq.put("cnm", 88);
    freq.put("msı", 120);
    freq.put("jde", 32);
    freq.put("He", 886);
    freq.put("llü", 42);
    freq.put("jda", 62);
    freq.put("kli", 1226);
    freq.put("pma", 660);
    freq.put("Rec", 27);
    freq.put("Rea", 49);
    freq.put("pmi", 49);
    freq.put(" üs", 329);
    freq.put(" ür", 101);
    freq.put(" üz", 478);
    freq.put(" üy", 56);
    freq.put("ı", 94866);
    freq.put(" üc", 43);
    freq.put(" ün", 221);
    freq.put(" üm", 42);
    freq.put(" ül", 245);
    freq.put("yüc", 26);
    freq.put(" oğ", 94);
    freq.put(" ü ", 55);
    freq.put("şuy", 125);
    freq.put("yüm", 45);
    freq.put("yır", 506);
    freq.put("şur", 79);
    freq.put("yük", 673);
    freq.put("şun", 190);
    freq.put("şum", 106);
    freq.put("şul", 50);
    freq.put("şua", 67);
    freq.put("msu", 102);
    freq.put("msn", 54);
    freq.put("msj", 31);
    freq.put("msi", 164);
    freq.put("mse", 525);
    freq.put("msa", 52);
    freq.put("Evi", 32);
    freq.put("Evl", 26);
    freq.put("llı", 193);
    freq.put("Evd", 35);
    freq.put("Eve", 165);
    freq.put("Dağ", 35);
    freq.put("roğ", 69);
    freq.put("ms ", 80);
    freq.put(" on", 1827);
    freq.put(" oo", 84);
    freq.put(" ol", 11529);
    freq.put(" om", 76);
    freq.put(" oj", 29);
    freq.put(" ok", 1009);
    freq.put(" oh", 157);
    freq.put("Min", 30);
    freq.put(" üş", 60);
    freq.put("█", 44);
    freq.put("kya", 81);
    freq.put(" ob", 29);
    freq.put(" oz", 290);
    freq.put(" oy", 1297);
    freq.put(" ot", 598);
    freq.put(" ou", 26);
    freq.put(" or", 1346);
    freq.put(" os", 43);
    freq.put(" op", 120);
    freq.put("pmı", 150);
    freq.put(" o ", 2300);
    freq.put("ahk", 114);
    freq.put("ıp ", 864);
    freq.put("ulm", 335);
    freq.put("övm", 32);
    freq.put("öve", 47);
    freq.put("ahm", 213);
    freq.put("rnı", 29);
    freq.put("EN ", 162);
    freq.put("eji", 38);
    freq.put("yu ", 349);
    freq.put("anş", 34);
    freq.put("övü", 33);
    freq.put("anı", 4679);
    freq.put("yuy", 268);
    freq.put("yuz", 191);
    freq.put("yup", 51);
    freq.put("yus", 53);
    freq.put("yur", 271);
    freq.put("yut", 68);
    freq.put("yuh", 33);
    freq.put("yuk", 184);
    freq.put("yum", 449);
    freq.put("yul", 37);
    freq.put("yun", 811);
    freq.put("yuc", 41);
    freq.put("yud", 53);
    freq.put("anç", 107);
    freq.put("hu ", 174);
    freq.put("prü", 32);
    freq.put("iam", 31);
    freq.put("ial", 47);
    freq.put("ian", 116);
    freq.put("iad", 37);
    freq.put("ias", 31);
    freq.put("hum", 48);
    freq.put("hun", 66);
    freq.put("huk", 61);
    freq.put("huu", 30);
    freq.put("hur", 187);
    freq.put("huy", 34);
    freq.put("huz", 100);
    freq.put("ia ", 187);
    freq.put("r", 156861);
    freq.put(" Lü", 67);
    freq.put("pre", 145);
    freq.put("ane", 867);
    freq.put("ang", 431);
    freq.put("pra", 132);
    freq.put("ana", 3869);
    freq.put("anb", 542);
    freq.put("anc", 506);
    freq.put("anl", 4239);
    freq.put("anm", 970);
    freq.put("pro", 488);
    freq.put("ano", 133);
    freq.put("pri", 176);
    freq.put("ani", 2061);
    freq.put("ank", 731);
    freq.put("ant", 679);
    freq.put("anu", 84);
    freq.put("anp", 105);
    freq.put("anr", 90);
    freq.put("ans", 1008);
    freq.put("any", 368);
    freq.put("anz", 60);
    freq.put("uys", 84);
    freq.put("uyr", 69);
    freq.put("uyu", 1342);
    freq.put("uya", 716);
    freq.put("uyd", 227);
    freq.put("uyg", 307);
    freq.put("uyk", 309);
    freq.put("uym", 153);
    freq.put("uyl", 125);
    freq.put("uyo", 1973);
    freq.put(" Le", 106);
    freq.put(" La", 165);
    freq.put(" Lo", 80);
    freq.put(" Li", 351);
    freq.put(" Lu", 60);
    freq.put("nlu", 249);
    freq.put("tka", 34);
    freq.put("rmü", 77);
    freq.put("tki", 207);
    freq.put("nla", 5250);
    freq.put("nle", 2054);
    freq.put("nli", 690);
    freq.put("dy ", 63);
    freq.put("ss ", 150);
    freq.put("uh ", 85);
    freq.put("tne", 28);
    freq.put("tk ", 28);
    freq.put("ssu", 34);
    freq.put("H", 3728);
    freq.put("lug", 74);
    freq.put("sss", 101);
    freq.put("dyo", 86);
    freq.put("ssi", 292);
    freq.put("sse", 256);
    freq.put("ssa", 80);
    freq.put("dya", 117);
    freq.put("kşa", 287);
    freq.put("ğen", 227);
    freq.put("rmu", 471);
    freq.put("nlü", 216);
    freq.put("rma", 1662);
    freq.put("lni", 46);
    freq.put("rme", 1372);
    freq.put("ğer", 564);
    freq.put("rmi", 601);
    freq.put("Onu", 80);
    freq.put("för", 31);
    freq.put("ssü", 30);
    freq.put("ğe ", 166);
    freq.put("rm ", 184);
    freq.put("Öy", 68);
    freq.put("ln ", 37);
    freq.put("poz", 86);
    freq.put("oşt", 39);
    freq.put("pot", 28);
    freq.put("por", 553);
    freq.put("pos", 54);
    freq.put("pop", 72);
    freq.put("pon", 87);
    freq.put("pol", 188);
    freq.put("Buy", 35);
    freq.put("Bur", 245);
    freq.put("Bun", 183);
    freq.put("Bul", 68);
    freq.put("Bug", 243);
    freq.put("nlı", 834);
    freq.put("tkı", 38);
    freq.put("po ", 29);
    freq.put("üg", 30);
    freq.put("üd", 258);
    freq.put("Bu ", 891);
    freq.put("oks", 397);
    freq.put("Fır", 33);
    freq.put("Bar", 185);
    freq.put("Bas", 118);
    freq.put("I ", 451);
    freq.put("rmı", 467);
    freq.put("lnı", 256);
    freq.put("tiy", 962);
    freq.put("Iy", 31);
    freq.put("Iz", 34);
    freq.put("tiz", 50);
    freq.put("Is", 141);
    freq.put("yha", 48);
    freq.put("uhu", 91);
    freq.put("Il", 69);
    freq.put("In", 112);
    freq.put("oke", 57);
    freq.put("tiv", 103);
    freq.put("tip", 127);
    freq.put("Ban", 157);
    freq.put("tir", 1872);
    freq.put("tis", 225);
    freq.put("Bal", 89);
    freq.put("tim", 1271);
    freq.put("tin", 1288);
    freq.put("Bak", 216);
    freq.put("gıs", 38);
    freq.put("Bah", 86);
    freq.put("ötü", 474);
    freq.put("lçe", 44);
    freq.put("tik", 917);
    freq.put("tid", 80);
    freq.put("tif", 191);
    freq.put("tig", 211);
    freq.put("oç", 76);
    freq.put("tib", 90);
    freq.put("nüş", 91);
    freq.put("Güz", 91);
    freq.put("Kuz", 61);
    freq.put("Kut", 27);
    freq.put("Kur", 143);
    freq.put("Güv", 33);
    freq.put("alt", 686);
    freq.put("Kul", 87);
    freq.put("Gül", 94);
    freq.put("Gün", 349);
    freq.put("öte", 55);
    freq.put("o ", 5050);
    freq.put("vzu", 29);
    freq.put("oL", 29);
    freq.put("oo", 1455);
    freq.put("öt ", 28);
    freq.put("om", 1707);
    freq.put("ol", 16696);
    freq.put("ok", 8952);
    freq.put("oj", 246);
    freq.put("oi", 86);
    freq.put("oh", 319);
    freq.put("og", 1088);
    freq.put("of", 600);
    freq.put("oe", 53);
    freq.put("od", 1034);
    freq.put("oc", 1249);
    freq.put("ob", 498);
    freq.put("oa", 61);
    freq.put("oz", 1176);
    freq.put("oy", 2918);
    freq.put("ox", 37);
    freq.put("ow", 361);
    freq.put("ov", 354);
    freq.put("ou", 358);
    freq.put("ot", 1617);
    freq.put("os", 2069);
    freq.put("or", 18598);
    freq.put("op", 1288);
    freq.put("LE ", 52);
    freq.put("nü ", 478);
    freq.put("FB ", 97);
    freq.put("ehr", 53);
    freq.put("cü ", 107);
    freq.put("EL ", 41);
    freq.put("ehd", 41);
    freq.put("ehe", 259);
    freq.put("eha", 44);
    freq.put("ehl", 79);
    freq.put("ehm", 108);
    freq.put("ehh", 38);
    freq.put("ehi", 354);
    freq.put("nüm", 149);
    freq.put("nül", 113);
    freq.put("nün", 400);
    freq.put("nüp", 35);
    freq.put("nür", 48);
    freq.put("nüy", 232);
    freq.put("nüz", 161);
    freq.put("eh ", 85);
    freq.put("rva", 134);
    freq.put("rve", 87);
    freq.put("rvi", 111);
    freq.put("cbi", 36);
    freq.put("oğ", 1667);
    freq.put("ige", 81);
    freq.put("igd", 58);
    freq.put("iga", 160);
    freq.put("igi", 1260);
    freq.put("igh", 48);
    freq.put("oş", 842);
    freq.put("ş", 30161);
    freq.put("ig ", 121);
    freq.put("pto", 31);
    freq.put("alo", 136);
    freq.put("all", 1535);
    freq.put("alm", 916);
    freq.put("alk", 590);
    freq.put("pti", 235);
    freq.put("ali", 2147);
    freq.put("alg", 95);
    freq.put("pte", 111);
    freq.put("ale", 819);
    freq.put("alb", 373);
    freq.put("alc", 82);
    freq.put("pta", 277);
    freq.put("ala", 4732);
    freq.put("aly", 168);
    freq.put("alv", 31);
    freq.put("ptu", 35);
    freq.put("alu", 75);
    freq.put("als", 183);
    freq.put("alp", 122);
    freq.put("suç", 107);
    freq.put("faz", 354);
    freq.put("fay", 145);
    freq.put("rkı", 609);
    freq.put("far", 510);
    freq.put("fas", 180);
    freq.put("fat", 118);
    freq.put("fak", 241);
    freq.put("fai", 34);
    freq.put("fan", 143);
    freq.put("llu", 80);
    freq.put("fal", 523);
    freq.put("fam", 132);
    freq.put("fab", 35);
    freq.put("fac", 218);
    freq.put("fad", 99);
    freq.put(" Ni", 205);
    freq.put(" No", 103);
    freq.put(" Na", 265);
    freq.put("Öme", 32);
    freq.put(" Ne", 857);
    freq.put(" Nu", 72);
    freq.put("teh", 76);
    freq.put("tei", 29);
    freq.put("tek", 1227);
    freq.put("tel", 830);
    freq.put("tem", 842);
    freq.put("ten", 1933);
    freq.put("teo", 27);
    freq.put("alç", 49);
    freq.put("Akı", 35);
    freq.put("tec", 192);
    freq.put("ted", 438);
    freq.put("tee", 32);
    freq.put("nbu", 529);
    freq.put("teg", 27);
    freq.put("tey", 320);
    freq.put("tez", 70);
    freq.put("ptü", 26);
    freq.put("tep", 213);
    freq.put("nba", 59);
    freq.put("tes", 892);
    freq.put("tet", 48);
    freq.put("lla", 2725);
    freq.put("tev", 53);
    freq.put("suf", 27);
    freq.put("ros", 177);
    freq.put("suc", 54);
    freq.put("sua", 79);
    freq.put("sun", 3542);
    freq.put("sum", 127);
    freq.put("sul", 117);
    freq.put("KP ", 53);
    freq.put("suu", 27);
    freq.put("sut", 53);
    freq.put("sus", 211);
    freq.put("sur", 353);
    freq.put("sup", 81);
    freq.put("suz", 338);
    freq.put("suy", 187);
    freq.put("te ", 2112);
    freq.put("Akş", 29);
    freq.put("su ", 758);
    freq.put("rkt", 70);
    freq.put("rku", 221);
    freq.put("Tor", 31);
    freq.put("Top", 83);
    freq.put("rke", 2594);
    freq.put("rka", 1199);
    freq.put("rkc", 77);
    freq.put("rkl", 221);
    freq.put("rkm", 73);
    freq.put("vı ", 28);
    freq.put("rko", 34);
    freq.put("rki", 803);
    freq.put("mma", 46);
    freq.put("vır", 41);
    freq.put("uş ", 720);
    freq.put("rk ", 797);
    freq.put("ptı", 599);
    freq.put("alı", 3537);
    freq.put("AR ", 101);
    freq.put("faş", 26);
    freq.put("Int", 31);
    freq.put("Ins", 32);
    freq.put("v", 23630);
    freq.put("rkü", 47);
    freq.put("rkç", 91);
    freq.put("oyu", 862);
    freq.put("oys", 57);
    freq.put("oyn", 549);
    freq.put("oym", 104);
    freq.put("oyl", 617);
    freq.put("oyi", 36);
    freq.put("teş", 411);
    freq.put("oyd", 125);
    freq.put("oya", 285);
    freq.put("Aks", 27);
    freq.put("Akl", 57);
    freq.put("Aka", 41);
    freq.put("lha", 57);
    freq.put("teğ", 56);
    freq.put("oy ", 182);
    freq.put(" sü", 749);
    freq.put(" sö", 1179);
    freq.put("yn ", 58);
    freq.put("Ert", 53);
    freq.put("Ers", 36);
    freq.put("L", 1206);
    freq.put("Erd", 117);
    freq.put("Erg", 40);
    freq.put("Erm", 29);
    freq.put("Ero", 33);
    freq.put("Erk", 119);
    freq.put("Rad", 35);
    freq.put("Rab", 45);
    freq.put("yni", 203);
    freq.put("yne", 204);
    freq.put("Ram", 114);
    freq.put("Rak", 26);
    freq.put("Rah", 33);
    freq.put("ynu", 131);
    freq.put("Mut", 66);
    freq.put("Mus", 92);
    freq.put("Mur", 48);
    freq.put(" sp", 191);
    freq.put(" st", 312);
    freq.put(" su", 1276);
    freq.put(" sk", 70);
    freq.put(" sh", 86);
    freq.put(" si", 2812);
    freq.put(" sn", 80);
    freq.put(" so", 4551);
    freq.put(" sl", 48);
    freq.put(" sm", 64);
    freq.put(" sa", 7402);
    freq.put("Muh", 84);
    freq.put(" se", 8065);
    freq.put("iza", 160);
    freq.put("izc", 116);
    freq.put("izd", 607);
    freq.put("ize", 1045);
    freq.put("izg", 51);
    freq.put("izi", 2239);
    freq.put("izl", 1501);
    freq.put("izm", 284);
    freq.put("izs", 57);
    freq.put("izy", 77);
    freq.put("izz", 66);
    freq.put("kok", 205);
    freq.put("kom", 288);
    freq.put(" s ", 154);
    freq.put("iz ", 4798);
    freq.put("kon", 1383);
    freq.put("Bağ", 46);
    freq.put("koc", 146);
    freq.put("özl", 672);
    freq.put("özg", 90);
    freq.put("öze", 325);
    freq.put("özd", 57);
    freq.put("özy", 29);
    freq.put("TL ", 214);
    freq.put("Res", 63);
    freq.put("ynı", 409);
    freq.put(" eu", 43);
    freq.put(" ev", 1374);
    freq.put("öz ", 234);
    freq.put("Nur", 42);
    freq.put(" es", 598);
    freq.put("efr", 147);
    freq.put("efs", 121);
    freq.put("eft", 36);
    freq.put("efi", 92);
    freq.put("efl", 31);
    freq.put("efo", 331);
    freq.put("efa", 276);
    freq.put("efe", 434);
    freq.put(" sı", 1366);
    freq.put("Öğr", 52);
    freq.put("ef ", 129);
    freq.put("rte", 340);
    freq.put("rta", 881);
    freq.put("cda", 67);
    freq.put("rtm", 145);
    freq.put("rtl", 178);
    freq.put("rto", 35);
    freq.put("rti", 462);
    freq.put("pş", 27);
    freq.put("rtu", 188);
    freq.put("rtt", 130);
    freq.put("arç", 155);
    freq.put("Ju", 43);
    freq.put("ier", 45);
    freq.put("iet", 29);
    freq.put("Jo", 61);
    freq.put("iel", 42);
    freq.put("ien", 50);
    freq.put("Je", 44);
    freq.put("Ja", 66);
    freq.put("ieg", 40);
    freq.put("hip", 147);
    freq.put("hir", 258);
    freq.put("his", 288);
    freq.put("hit", 230);
    freq.put("rt ", 618);
    freq.put("hiy", 29);
    freq.put("hiz", 84);
    freq.put("hib", 81);
    freq.put("hic", 217);
    freq.put("hid", 46);
    freq.put("duğ", 777);
    freq.put("hih", 48);
    freq.put("hik", 72);
    freq.put("hil", 169);
    freq.put("him", 99);
    freq.put("hin", 151);
    freq.put("pı", 1145);
    freq.put("Baş", 375);
    freq.put("ie ", 171);
    freq.put("arp", 127);
    freq.put("arr", 140);
    freq.put("ars", 940);
    freq.put("art", 1882);
    freq.put("aru", 39);
    freq.put("ary", 137);
    freq.put("arz", 107);
    freq.put("ara", 6902);
    freq.put("arb", 155);
    freq.put("arc", 301);
    freq.put("ard", 2910);
    freq.put("are", 791);
    freq.put("arf", 80);
    freq.put("arg", 148);
    freq.put("arh", 45);
    freq.put("rtü", 72);
    freq.put("arj", 49);
    freq.put("ark", 2477);
    freq.put("arl", 1078);
    freq.put("uu ", 100);
    freq.put("arn", 109);
    freq.put("aro", 113);
    freq.put("riş", 148);
    freq.put("Şey", 29);
    freq.put("al ", 1863);
    freq.put(" P ", 104);
    freq.put("Faz", 39);
    freq.put("uuu", 272);
    freq.put("uum", 74);
    freq.put("uun", 45);
    freq.put("hiç", 806);
    freq.put(" Pr", 133);
    freq.put("c", 31174);
    freq.put(" Pu", 32);
    freq.put(" Pa", 470);
    freq.put(" Pe", 227);
    freq.put(" Pi", 101);
    freq.put(" Po", 218);
    freq.put(" Pl", 74);
    freq.put("pr", 1018);
    freq.put("ps", 615);
    freq.put("pp", 171);
    freq.put("duk", 329);
    freq.put("dul", 89);
    freq.put("dum", 845);
    freq.put("pt", 1350);
    freq.put("pu", 465);
    freq.put("dua", 110);
    freq.put("py", 78);
    freq.put("dud", 50);
    freq.put("dug", 295);
    freq.put("pc", 110);
    freq.put("duz", 82);
    freq.put("pa", 4272);
    freq.put("pe", 1677);
    freq.put("pk", 194);
    freq.put("dur", 1554);
    freq.put("pi", 1593);
    freq.put("pn", 40);
    freq.put("po", 1225);
    freq.put("duv", 57);
    freq.put("pm", 895);
    freq.put("Eme", 32);
    freq.put("Emi", 41);
    freq.put("rtı", 1080);
    freq.put("Emr", 56);
    freq.put("du ", 1454);
    freq.put("hiş", 47);
    freq.put("p ", 5006);
    freq.put("riz", 578);
    freq.put("ğar", 47);
    freq.put("riy", 977);
    freq.put("rit", 127);
    freq.put("rir", 349);
    freq.put("ris", 674);
    freq.put("rip", 297);
    freq.put("rin", 4159);
    freq.put("rio", 36);
    freq.put("ril", 670);
    freq.put("rim", 2678);
    freq.put("rik", 591);
    freq.put("rih", 237);
    freq.put("rii", 43);
    freq.put("rif", 125);
    freq.put("ğan", 207);
    freq.put("rid", 258);
    freq.put("rie", 40);
    freq.put("rib", 114);
    freq.put("ric", 275);
    freq.put("ria", 67);
    freq.put("Nİ ", 44);
    freq.put("pü", 126);
    freq.put("arş", 529);
    freq.put("pç", 114);
    freq.put("arı", 7092);
    freq.put("ğa ", 238);
    freq.put("Cok", 96);
    freq.put("ri ", 4095);
    freq.put("yık", 158);
    freq.put("ış ", 1428);
    freq.put("üz ", 334);
    freq.put("aç ", 656);
    freq.put("şsı", 85);
    freq.put("pış", 41);
    freq.put("üzi", 187);
    freq.put("üzm", 39);
    freq.put("üzl", 75);
    freq.put("ışa", 244);
    freq.put("ışm", 409);
    freq.put("ışl", 232);
    freq.put("ışk", 41);
    freq.put("üzd", 200);
    freq.put("üzg", 118);
    freq.put("üzy", 33);
    freq.put("Ail", 41);
    freq.put("ışt", 420);
    freq.put("ışs", 95);
    freq.put("açm", 222);
    freq.put("açl", 254);
    freq.put("açi", 28);
    freq.put("ylü", 298);
    freq.put("aça", 220);
    freq.put("açt", 228);
    freq.put("açs", 30);
    freq.put("böy", 485);
    freq.put("ıys", 71);
    freq.put("ıym", 78);
    freq.put("ıyl", 531);
    freq.put("ıyo", 3718);
    freq.put("ıye", 82);
    freq.put("ıyd", 100);
    freq.put("ıya", 316);
    freq.put("ıyc", 29);
    freq.put("zz ", 117);
    freq.put("sk ", 97);
    freq.put("zzz", 103);
    freq.put("üzü", 497);
    freq.put("zze", 63);
    freq.put("zza", 36);
    freq.put("ylu", 81);
    freq.put("yle", 3687);
    freq.put("yla", 1350);
    freq.put("yli", 84);
    freq.put("Üst", 35);
    freq.put("pıc", 65);
    freq.put(" uy", 1425);
    freq.put(" uz", 670);
    freq.put(" ut", 101);
    freq.put(" up", 26);
    freq.put("pım", 41);
    freq.put(" ur", 32);
    freq.put(" us", 225);
    freq.put(" ul", 328);
    freq.put(" um", 304);
    freq.put(" un", 714);
    freq.put("pıs", 30);
    freq.put("ışı", 857);
    freq.put(" ue", 54);
    freq.put(" uf", 79);
    freq.put(" ug", 70);
    freq.put(" uc", 134);
    freq.put("kde", 50);
    freq.put("açı", 1180);
    freq.put("pı ", 45);
    freq.put(" u ", 166);
    freq.put("şsi", 106);
    freq.put("şsa", 49);
    freq.put("ix ", 39);
    freq.put("şse", 39);
    freq.put("z", 44446);
    freq.put("şsu", 48);
    freq.put(" uç", 150);
    freq.put("gru", 222);
    freq.put("ylı", 113);
    freq.put("gre", 181);
    freq.put("gra", 391);
    freq.put("gri", 68);
    freq.put("ıyı", 509);
    freq.put("cir", 161);
    freq.put("eda", 245);
    freq.put("â ", 38);
    freq.put("edd", 76);
    freq.put("ede", 3797);
    freq.put("edi", 5082);
    freq.put("LA ", 47);
    freq.put("edy", 121);
    freq.put("FF ", 130);
    freq.put("şu ", 490);
    freq.put("fın", 168);
    freq.put("apş", 26);
    freq.put("fım", 52);
    freq.put("fız", 33);
    freq.put("fır", 175);
    freq.put("fıs", 31);
    freq.put("uga", 45);
    freq.put("ed ", 135);
    freq.put("caz", 142);
    freq.put("âl", 40);
    freq.put("apı", 1026);
    freq.put("cay", 138);
    freq.put("P", 1980);
    freq.put(" çı", 1398);
    freq.put("fı ", 111);
    freq.put("civ", 46);
    freq.put("rri", 80);
    freq.put("rre", 57);
    freq.put("rra", 72);
    freq.put("cav", 65);
    freq.put("rry", 57);
    freq.put("rrr", 308);
    freq.put("taş", 413);
    freq.put("bdu", 30);
    freq.put("ugu", 655);
    freq.put("rac", 445);
    freq.put("rr ", 213);
    freq.put("Yun", 38);
    freq.put("hka", 30);
    freq.put("caa", 35);
    freq.put("hke", 43);
    freq.put("tağ", 45);
    freq.put("apr", 40);
    freq.put("aps", 192);
    freq.put("app", 49);
    freq.put("apt", 973);
    freq.put("apu", 28);
    freq.put("apk", 26);
    freq.put("taç", 36);
    freq.put("apo", 93);
    freq.put("apl", 216);
    freq.put("apm", 836);
    freq.put("apc", 55);
    freq.put("apa", 1456);
    freq.put("Mil", 165);
    freq.put("fed", 131);
    freq.put(" çu", 30);
    freq.put("fec", 34);
    freq.put("usa", 224);
    freq.put("fen", 783);
    freq.put("fel", 100);
    freq.put("usl", 149);
    freq.put("usi", 26);
    freq.put(" of", 298);
    freq.put("fet", 203);
    freq.put(" çe", 793);
    freq.put("fer", 480);
    freq.put("fes", 211);
    freq.put(" og", 144);
    freq.put(" ço", 2811);
    freq.put(" od", 226);
    freq.put("usy", 33);
    freq.put(" çi", 354);
    freq.put("Gun", 78);
    freq.put("edı", 136);
    freq.put("ap ", 627);
    freq.put(" Ru", 118);
    freq.put("fe ", 89);
    freq.put("us ", 491);
    freq.put(" Re", 300);
    freq.put(" Ra", 327);
    freq.put(" Ro", 115);
    freq.put(" Ri", 70);
    freq.put("tat", 613);
    freq.put("tav", 201);
    freq.put("tap", 244);
    freq.put("tar", 1763);
    freq.put("tas", 720);
    freq.put("tay", 519);
    freq.put("taz", 39);
    freq.put("tad", 369);
    freq.put("taf", 93);
    freq.put("tag", 53);
    freq.put("taa", 52);
    freq.put("tab", 685);
    freq.put("tac", 175);
    freq.put("tal", 780);
    freq.put("tam", 951);
    freq.put("tan", 3098);
    freq.put("tah", 181);
    freq.put("taj", 87);
    freq.put("tak", 1514);
    freq.put(" çö", 206);
    freq.put("sir", 256);
    freq.put("sip", 97);
    freq.put("Uyu", 40);
    freq.put("siv", 74);
    freq.put("sit", 368);
    freq.put("siz", 1874);
    freq.put("siy", 715);
    freq.put("sic", 105);
    freq.put("sig", 124);
    freq.put("sif", 49);
    freq.put("sid", 157);
    freq.put("sik", 559);
    freq.put("sii", 42);
    freq.put("sin", 5940);
    freq.put("sim", 1101);
    freq.put("sil", 643);
    freq.put("Eki", 60);
    freq.put("ta ", 2025);
    freq.put("rrı", 26);
    freq.put(" Rü", 44);
    freq.put("si ", 3539);
    freq.put("owl", 27);
    freq.put("kba", 31);
    freq.put("öb", 78);
    freq.put("kbe", 31);
    freq.put("Kı", 334);
    freq.put("cto", 40);
    freq.put("bya", 49);
    freq.put("Car", 39);
    freq.put("üdü", 164);
    freq.put("Can", 222);
    freq.put("Cam", 35);
    freq.put("Cad", 44);
    freq.put("nfo", 70);
    freq.put("Pro", 103);
    freq.put("ltü", 64);
    freq.put("ekı", 52);
    freq.put(" İç", 127);
    freq.put("by ", 36);
    freq.put("oun", 35);
    freq.put("ous", 58);
    freq.put("our", 67);
    freq.put("out", 51);
    freq.put("şmı", 108);
    freq.put("lt ", 104);
    freq.put("ows", 36);
    freq.put("aol", 69);
    freq.put("ou ", 62);
    freq.put("üda", 37);
    freq.put("üde", 34);
    freq.put("ltr", 30);
    freq.put("ltu", 71);
    freq.put("ltt", 41);
    freq.put("vab", 50);
    freq.put("lta", 144);
    freq.put("lte", 115);
    freq.put("lti", 174);
    freq.put("ü", 31904);
    freq.put("ltm", 56);
    freq.put("Umu", 31);
    freq.put("K ", 732);
    freq.put("müb", 80);
    freq.put("tıd", 49);
    freq.put("Ka", 1535);
    freq.put("Ke", 478);
    freq.put("Ki", 385);
    freq.put("Ko", 483);
    freq.put("Kl", 40);
    freq.put("Kr", 70);
    freq.put("Ku", 435);
    freq.put("şmü", 27);
    freq.put("ybi", 40);
    freq.put("sed", 260);
    freq.put("ybo", 80);
    freq.put("Uma", 39);
    freq.put("ybe", 273);
    freq.put("Yön", 36);
    freq.put("IZ ", 46);
    freq.put("ltı", 416);
    freq.put("hr", 245);
    freq.put("nrı", 73);
    freq.put("ER ", 136);
    freq.put("Kö", 93);
    freq.put("Kü", 136);
    freq.put("Por", 43);
    freq.put("vcı", 69);
    freq.put("Pol", 79);
    freq.put("şme", 374);
    freq.put("şmi", 58);
    freq.put("Cha", 39);
    freq.put("NI ", 31);
    freq.put("ha", 13508);
    freq.put(" w ", 37);
    freq.put("eat", 30);
    freq.put("q ", 60);
    freq.put("rpı", 43);
    freq.put("skı", 77);
    freq.put(" we", 63);
    freq.put("qu", 78);
    freq.put(" wa", 77);
    freq.put(" wi", 59);
    freq.put(" ww", 63);
    freq.put("va ", 353);
    freq.put("ebe", 571);
    freq.put("eba", 69);
    freq.put("ebo", 302);
    freq.put("ebi", 870);
    freq.put("pçi", 69);
    freq.put("ebr", 122);
    freq.put("avş", 47);
    freq.put("dli", 29);
    freq.put(" Tı", 44);
    freq.put("Bı", 64);
    freq.put("eb ", 42);
    freq.put("avı", 58);
    freq.put("Zam", 81);
    freq.put("Zaf", 32);
    freq.put("Zat", 52);
    freq.put("avü", 43);
    freq.put("rpr", 38);
    freq.put("rpa", 41);
    freq.put("ikk", 210);
    freq.put("rpi", 39);
    freq.put("bbi", 65);
    freq.put("bbe", 99);
    freq.put(" İy", 146);
    freq.put("hmm", 47);
    freq.put("hmi", 68);
    freq.put("hme", 300);
    freq.put("hma", 41);
    freq.put(" Tü", 825);
    freq.put(" İb", 33);
    freq.put("é", 26);
    freq.put("avy", 40);
    freq.put("avu", 451);
    freq.put("avr", 269);
    freq.put("avs", 115);
    freq.put("avl", 68);
    freq.put(" İk", 106);
    freq.put("avo", 58);
    freq.put("avi", 169);
    freq.put("ave", 126);
    freq.put("avg", 58);
    freq.put("ava", 965);
    freq.put("avc", 67);
    freq.put("fka", 28);
    freq.put(" T ", 48);
    freq.put("av ", 118);
    freq.put(" Tw", 212);
    freq.put(" Tv", 75);
    freq.put(" Tu", 384);
    freq.put(" Tr", 285);
    freq.put(" To", 227);
    freq.put("dlı", 41);
    freq.put(" Ti", 105);
    freq.put(" Th", 79);
    freq.put(" Te", 699);
    freq.put(" Ta", 898);
    freq.put("vaş", 232);
    freq.put("tci", 34);
    freq.put("tce", 43);
    freq.put("sku", 30);
    freq.put("Far", 44);
    freq.put("Fat", 69);
    freq.put("ske", 432);
    freq.put("Fak", 37);
    freq.put("ska", 327);
    freq.put("Fal", 30);
    freq.put("skl", 39);
    freq.put("sko", 76);
    freq.put("ski", 524);
    freq.put("öş", 68);
    freq.put("T", 4980);
    freq.put("Teş", 73);
    freq.put("car", 162);
    freq.put("Çü", 114);
    freq.put("ndü", 306);
    freq.put("öğ", 457);
    freq.put("kdi", 34);
    freq.put("Sua", 32);
    freq.put("Sun", 33);
    freq.put("Sul", 32);
    freq.put("kda", 59);
    freq.put("Sur", 86);
    freq.put("Sup", 31);
    freq.put("kdr", 46);
    freq.put("nd ", 124);
    freq.put(" İş", 200);
    freq.put("Ç ", 77);
    freq.put("Su ", 54);
    freq.put("Eğe", 61);
    freq.put("Eği", 27);
    freq.put("ndi", 2503);
    freq.put("ndo", 59);
    freq.put("ndn", 26);
    freq.put("nda", 5738);
    freq.put("nde", 5035);
    freq.put("ndy", 26);
    freq.put("Çe", 148);
    freq.put("Ça", 202);
    freq.put("Ço", 317);
    freq.put("ndr", 120);
    freq.put("ndu", 284);
    freq.put("Çi", 100);
    freq.put("süm", 27);
    freq.put("sün", 233);
    freq.put("öc", 43);
    freq.put("öd", 140);
    freq.put("öf", 58);
    freq.put("ög", 29);
    freq.put("owe", 58);
    freq.put("ök", 315);
    freq.put("öl", 1089);
    freq.put("öm", 159);
    freq.put("ön", 2232);
    freq.put("öp", 317);
    freq.put("ör", 2312);
    freq.put("ös", 252);
    freq.put("öt", 586);
    freq.put("süz", 53);
    freq.put("süt", 42);
    freq.put("öy", 2105);
    freq.put("öz", 1982);
    freq.put("süp", 179);
    freq.put("sür", 517);
    freq.put("Ami", 28);
    freq.put("vak", 195);
    freq.put("vah", 54);
    freq.put("van", 378);
    freq.put("öce", 29);
    freq.put("val", 712);
    freq.put("vam", 413);
    freq.put("Ama", 314);
    freq.put("vaa", 59);
    freq.put("Ame", 65);
    freq.put("vad", 81);
    freq.put("vaz", 123);
    freq.put("ee", 1664);
    freq.put("vay", 140);
    freq.put("ştı", 624);
    freq.put("var", 3557);
    freq.put("vas", 255);
    freq.put("vap", 233);
    freq.put("vat", 136);
    freq.put("ö ", 38);
    freq.put("üfr", 29);
    freq.put("sü ", 77);
    freq.put("ow ", 174);
    freq.put("üfe", 40);
    freq.put("Tek", 179);
    freq.put("Tel", 84);
    freq.put("Tem", 54);
    freq.put("Teb", 38);
    freq.put("lve", 35);
    freq.put("lva", 45);
    freq.put("Ter", 106);
    freq.put("Tes", 46);
    freq.put(" İs", 644);
    freq.put(" İr", 44);
    freq.put(" İt", 40);
    freq.put(" İz", 178);
    freq.put("Oyu", 46);
    freq.put("eu", 82);
    freq.put(" İf", 34);
    freq.put("öö", 35);
    freq.put(" İd", 37);
    freq.put("mya", 29);
    freq.put(" İh", 28);
    freq.put(" İn", 462);
    freq.put(" İm", 43);
    freq.put(" İl", 230);
    freq.put("Çı", 64);
    freq.put("ıvı", 31);
    freq.put("Afr", 66);
    freq.put("ndı", 947);
    freq.put("üfü", 97);
    freq.put("my ", 31);
  }
  
}

