package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class UK {
  private static final String name = "uk";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public UK() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 689589;
    n_words[1] = 816334;
    n_words[2] = 668227;

    freq.put("біц", 66);
    freq.put("бір", 119);
    freq.put("біс", 22);
    freq.put("біт", 70);
    freq.put("Вик", 26);
    freq.put("Вин", 34);
    freq.put("ькр", 20);
    freq.put("Виб", 23);
    freq.put("Вид", 17);
    freq.put("пок", 272);
    freq.put("пол", 331);
    freq.put("поо", 19);
    freq.put("поп", 121);
    freq.put("пом", 329);
    freq.put("пон", 163);
    freq.put("пов", 582);
    freq.put("пог", 188);
    freq.put("поб", 144);
    freq.put("пож", 58);
    freq.put("поз", 218);
    freq.put("под", 643);
    freq.put("пое", 12);
    freq.put("пош", 65);
    freq.put("че ", 158);
    freq.put("пою", 9);
    freq.put("поя", 36);
    freq.put("пот", 301);
    freq.put("пор", 433);
    freq.put("пос", 377);
    freq.put("поц", 10);
    freq.put("поч", 366);
    freq.put("пох", 50);
    freq.put("ею ", 85);
    freq.put("со ", 16);
    freq.put(" Аз", 90);
    freq.put("пої", 66);
    freq.put("Вищ", 9);
    freq.put("Виш", 11);
    freq.put("Вис", 22);
    freq.put(" Ад", 26);
    freq.put("бін", 41);
    freq.put("біо", 14);
    freq.put("бій", 49);
    freq.put("біл", 479);
    freq.put("бід", 61);
    freq.put("біж", 16);
    freq.put("біз", 34);
    freq.put("біб", 19);
    freq.put("бів", 17);
    freq.put("біг", 47);
    freq.put("ей ", 332);
    freq.put(" Ам", 38);
    freq.put("НЕ ", 32);
    freq.put("смі", 84);
    freq.put("ть ", 2787);
    freq.put("смс", 9);
    freq.put("смо", 16);
    freq.put("сме", 56);
    freq.put("сма", 62);
    freq.put("оє ", 91);
    freq.put("вча", 142);
    freq.put("езк", 23);
    freq.put("ези", 107);
    freq.put("езп", 100);
    freq.put("вче", 57);
    freq.put("езн", 94);
    freq.put("вчи", 188);
    freq.put("езв", 19);
    freq.put("еза", 65);
    freq.put("вчо", 54);
    freq.put("ам ", 609);
    freq.put("Ю", 142);
    freq.put(" Ні", 116);
    freq.put("ФА ", 12);
    freq.put("езі", 17);
    freq.put("вчу", 27);
    freq.put("уме", 57);
    freq.put("езу", 53);
    freq.put("езс", 10);
    freq.put("езр", 24);
    freq.put("Ве", 144);
    freq.put("Вж", 33);
    freq.put("Вз", 12);
    freq.put("Ва", 200);
    freq.put("ьня", 12);
    freq.put("Вн", 12);
    freq.put("Во", 278);
    freq.put("ьну", 58);
    freq.put("Ви", 248);
    freq.put("зії", 22);
    freq.put("Вл", 52);
    freq.put("зія", 10);
    freq.put("зір", 47);
    freq.put("ьні", 169);
    freq.put("ідх", 29);
    freq.put("Ско", 29);
    freq.put("Ска", 28);
    freq.put("С", 1481);
    freq.put("ПА ", 16);
    freq.put("обу", 161);
    freq.put("Е ", 113);
    freq.put("Скі", 11);
    freq.put("Ві", 487);
    freq.put("зій", 24);
    freq.put("Льв", 332);
    freq.put("зів", 56);
    freq.put("зіг", 40);
    freq.put("зіб", 29);
    freq.put("зіз", 13);
    freq.put("Ене", 10);
    freq.put("Вч", 28);
    freq.put("Вр", 10);
    freq.put("Вс", 142);
    freq.put("ьно", 354);
    freq.put("Ву", 13);
    freq.put("ьна", 83);
    freq.put("ьне", 69);
    freq.put("Є", 313);
    freq.put("РЄ ", 9);
    freq.put(" дя", 86);
    freq.put("оо ", 22);
    freq.put("ід", 3704);
    freq.put("Ш ", 9);
    freq.put(" ду", 530);
    freq.put(" др", 237);
    freq.put("За ", 89);
    freq.put(" до", 1847);
    freq.put("ня ", 2178);
    freq.put(" дн", 215);
    freq.put(" Яп", 15);
    freq.put(" Ян", 160);
    freq.put(" Як", 314);
    freq.put(" дл", 417);
    freq.put("омб", 33);
    freq.put("ома", 339);
    freq.put("оме", 204);
    freq.put("оми", 243);
    freq.put("омл", 43);
    freq.put(" ди", 397);
    freq.put("омн", 32);
    freq.put("омп", 127);
    freq.put("омо", 329);
    freq.put("Зві", 11);
    freq.put("тиш", 17);
    freq.put("тия", 10);
    freq.put(" дж", 25);
    freq.put("тис", 611);
    freq.put("тир", 80);
    freq.put("тит", 136);
    freq.put("тих", 79);
    freq.put("тиф", 11);
    freq.put("тич", 181);
    freq.put("тиц", 33);
    freq.put("тий", 84);
    freq.put("тил", 108);
    freq.put("тик", 238);
    freq.put("тин", 229);
    freq.put("тим", 295);
    freq.put("тип", 43);
    freq.put("омі", 244);
    freq.put("тиг", 23);
    freq.put("тив", 305);
    freq.put("тиз", 25);
    freq.put("тиж", 102);
    freq.put("омс", 15);
    freq.put("ому", 1059);
    freq.put(" да", 304);
    freq.put(" Яц", 12);
    freq.put("Щер", 13);
    freq.put(" Яр", 19);
    freq.put("цтв", 73);
    freq.put("обе", 36);
    freq.put("де ", 530);
    freq.put("Та ", 42);
    freq.put("зеї", 11);
    freq.put("МБ ", 10);
    freq.put("зет", 43);
    freq.put("зер", 52);
    freq.put("Іде", 9);
    freq.put("ю ", 3029);
    freq.put("зей", 10);
    freq.put("зен", 64);
    freq.put("зем", 80);
    freq.put("Ця ", 15);
    freq.put("ляй", 11);
    freq.put("лял", 34);
    freq.put("ляк", 36);
    freq.put("лян", 106);
    freq.put("лям", 22);
    freq.put("ляг", 10);
    freq.put("ляв", 19);
    freq.put("ляд", 178);
    freq.put("ляж", 14);
    freq.put("іад", 24);
    freq.put("ии ", 12);
    freq.put("ішу", 22);
    freq.put("чя ", 31);
    freq.put("Той", 9);
    freq.put("Том", 31);
    freq.put("Тоб", 9);
    freq.put("х", 6203);
    freq.put("Тор", 11);
    freq.put("юте", 18);
    freq.put("ішн", 100);
    freq.put("ішо", 48);
    freq.put("іши", 127);
    freq.put("ішл", 26);
    freq.put("ішк", 35);
    freq.put("іше", 171);
    freq.put("яяя", 16);
    freq.put("ляє", 91);
    freq.put("дзв", 63);
    freq.put("ляш", 14);
    freq.put("ляю", 62);
    freq.put("ляр", 50);
    freq.put("лят", 162);
    freq.put("лях", 49);
    freq.put("ляч", 12);
    freq.put("ляц", 33);
    freq.put("Ви ", 57);
    freq.put("Шев", 41);
    freq.put("чет", 100);
    freq.put("чес", 53);
    freq.put("чер", 412);
    freq.put("по ", 333);
    freq.put("чеш", 33);
    freq.put("соф", 19);
    freq.put("соц", 77);
    freq.put("сор", 60);
    freq.put("сот", 30);
    freq.put("сою", 23);
    freq.put("соб", 260);
    freq.put("сов", 127);
    freq.put("сом", 93);
    freq.put("сон", 126);
    freq.put("сок", 65);
    freq.put("сол", 72);
    freq.put("чев", 38);
    freq.put("чек", 111);
    freq.put("чей", 19);
    freq.put("чен", 312);
    freq.put("чем", 66);
    freq.put(" Ін", 131);
    freq.put("бі ", 314);
    freq.put("ейб", 20);
    freq.put("ейд", 24);
    freq.put("ейл", 11);
    freq.put("ейк", 21);
    freq.put("ейн", 38);
    freq.put("ейм", 49);
    freq.put("тьо", 35);
    freq.put("тьк", 59);
    freq.put("тьб", 24);
    freq.put("дав", 241);
    freq.put("тьс", 1042);
    freq.put("ейс", 70);
    freq.put("ейт", 36);
    freq.put("ейц", 9);
    freq.put("ейш", 9);
    freq.put("чні", 119);
    freq.put("ез ", 429);
    freq.put("Дяк", 48);
    freq.put("арт", 363);
    freq.put("арс", 61);
    freq.put("аме", 197);
    freq.put("амв", 11);
    freq.put("амб", 22);
    freq.put("ама", 210);
    freq.put("амп", 33);
    freq.put("амо", 199);
    freq.put("амн", 11);
    freq.put("амк", 29);
    freq.put("ами", 449);
    freq.put("аму", 68);
    freq.put("амі", 154);
    freq.put("ншу", 11);
    freq.put("ьга", 9);
    freq.put("ьго", 16);
    freq.put("ншо", 22);
    freq.put("В ", 435);
    freq.put("ьте", 43);
    freq.put("нши", 51);
    freq.put("ард", 54);
    freq.put("Оба", 16);
    freq.put("ьти", 15);
    freq.put("Обл", 10);
    freq.put("с", 25868);
    freq.put("їв ", 107);
    freq.put("ари", 178);
    freq.put("Ел", 28);
    freq.put("Ек", 67);
    freq.put("іаС", 13);
    freq.put("нша", 14);
    freq.put("ВН ", 9);
    freq.put("От ", 18);
    freq.put("зі ", 275);
    freq.put("езл", 22);
    freq.put("Зах", 63);
    freq.put("Зар", 34);
    freq.put("Зас", 20);
    freq.put("езо", 54);
    freq.put("ткі", 63);
    freq.put("ооп", 15);
    freq.put("ооо", 40);
    freq.put("тку", 193);
    freq.put("Шу", 23);
    freq.put("ооб", 24);
    freq.put("Шк", 26);
    freq.put("Ши", 10);
    freq.put("Шо", 22);
    freq.put("тка", 109);
    freq.put("Шв", 23);
    freq.put("тко", 110);
    freq.put("оох", 13);
    freq.put("Ше", 59);
    freq.put("езе", 67);
    freq.put("Зам", 16);
    freq.put("Зап", 44);
    freq.put("Зак", 75);
    freq.put("Зал", 22);
    freq.put("Зад", 9);
    freq.put("Япо", 15);
    freq.put("Заб", 23);
    freq.put("Зав", 64);
    freq.put("Заг", 17);
    freq.put("Ще ", 27);
    freq.put(" Я ", 299);
    freq.put("нял", 42);
    freq.put("няк", 11);
    freq.put("З", 1042);
    freq.put("ням", 80);
    freq.put("няв", 25);
    freq.put("ом ", 939);
    freq.put("ти ", 3922);
    freq.put("няш", 12);
    freq.put("ЄС ", 42);
    freq.put("няю", 15);
    freq.put("нят", 125);
    freq.put("няч", 20);
    freq.put("нях", 17);
    freq.put("няє", 26);
    freq.put("дей", 111);
    freq.put("дек", 55);
    freq.put("ы ", 26);
    freq.put("дем", 99);
    freq.put("ден", 625);
    freq.put("део", 306);
    freq.put("деп", 142);
    freq.put("деа", 16);
    freq.put("деб", 21);
    freq.put("дев", 13);
    freq.put("узе", 31);
    freq.put("юш", 10);
    freq.put("юю", 103);
    freq.put("юр", 59);
    freq.put("юс", 264);
    freq.put("ют", 1003);
    freq.put("зпл", 11);
    freq.put("юх", 14);
    freq.put("юц", 9);
    freq.put("юч", 182);
    freq.put("Таб", 19);
    freq.put("меш", 28);
    freq.put("ебр", 12);
    freq.put("Так", 99);
    freq.put("ює", 131);
    freq.put("Там", 15);
    freq.put("Тар", 19);
    freq.put("Тат", 12);
    freq.put("іх ", 176);
    freq.put("юй", 10);
    freq.put("юк", 75);
    freq.put("зе ", 19);
    freq.put("юм", 15);
    freq.put("юн", 47);
    freq.put("юб", 308);
    freq.put("юв", 202);
    freq.put("юг", 13);
    freq.put("юд", 479);
    freq.put("юз", 42);
    freq.put("узі", 87);
    freq.put("деш", 55);
    freq.put("дещ", 13);
    freq.put("узь", 19);
    freq.put("узя", 15);
    freq.put("дея", 40);
    freq.put("дер", 241);
    freq.put("дес", 136);
    freq.put("дет", 90);
    freq.put("дец", 17);
    freq.put("иии", 11);
    freq.put("ужн", 17);
    freq.put("ля ", 838);
    freq.put("джи", 17);
    freq.put("ужи", 45);
    freq.put("Чит", 18);
    freq.put("То ", 13);
    freq.put("дже", 236);
    freq.put("уже", 296);
    freq.put("джа", 38);
    freq.put("ужа", 11);
    freq.put("Чим", 10);
    freq.put("ужб", 55);
    freq.put("іш ", 18);
    freq.put("ког", 442);
    freq.put("ков", 579);
    freq.put("коб", 11);
    freq.put("коз", 19);
    freq.put("кож", 106);
    freq.put("дбу", 120);
    freq.put("кол", 790);
    freq.put("кок", 9);
    freq.put("коп", 40);
    freq.put("коо", 12);
    freq.put("кон", 562);
    freq.put("ком", 705);
    freq.put("ик ", 343);
    freq.put("іют", 27);
    freq.put("іюс", 20);
    freq.put("от ", 129);
    freq.put("ия ", 16);
    freq.put("кої", 290);
    freq.put("коє", 10);
    freq.put("кот", 84);
    freq.put("кос", 109);
    freq.put("кор", 358);
    freq.put("дба", 40);
    freq.put("кох", 73);
    freq.put("дбо", 14);
    freq.put("кош", 58);
    freq.put("дби", 11);
    freq.put("лбо", 14);
    freq.put("имо", 234);
    freq.put("имк", 46);
    freq.put("ими", 275);
    freq.put("име", 104);
    freq.put("Кір", 34);
    freq.put("има", 295);
    freq.put("єкт", 15);
    freq.put("Для", 34);
    freq.put("оря", 98);
    freq.put("орю", 51);
    freq.put("орщ", 14);
    freq.put("Ці", 62);
    freq.put("орч", 57);
    freq.put("орц", 29);
    freq.put("орс", 55);
    freq.put("исі", 11);
    freq.put("орт", 267);
    freq.put("ись", 427);
    freq.put("ися", 465);
    freq.put("ист", 625);
    freq.put("орі", 521);
    freq.put("Ць", 14);
    freq.put("Ця", 15);
    freq.put("иси", 14);
    freq.put("иск", 98);
    freq.put("исл", 67);
    freq.put("Це", 160);
    freq.put("исо", 78);
    freq.put("исп", 24);
    freq.put("иса", 211);
    freq.put("исв", 21);
    freq.put("исе", 22);
    freq.put("орн", 112);
    freq.put("орм", 245);
    freq.put("орп", 10);
    freq.put("Сту", 29);
    freq.put("ори", 507);
    freq.put("орк", 37);
    freq.put("оре", 138);
    freq.put("орд", 128);
    freq.put("орб", 11);
    freq.put("ора", 405);
    freq.put("орг", 123);
    freq.put("орв", 21);
    freq.put("имі", 83);
    freq.put("Кіл", 15);
    freq.put("Кіп", 12);
    freq.put("Кін", 14);
    freq.put("имч", 10);
    freq.put("иму", 217);
    freq.put("имс", 13);
    freq.put("улк", 10);
    freq.put("зус", 108);
    freq.put("пка", 10);
    freq.put("зур", 12);
    freq.put("пко", 12);
    freq.put("Вг", 18);
    freq.put("пки", 10);
    freq.put("зут", 11);
    freq.put("ню", 250);
    freq.put("ує ", 338);
    freq.put("діє", 31);
    freq.put("дії", 103);
    freq.put("дія", 92);
    freq.put("дію", 47);
    freq.put("ції", 332);
    freq.put("діс", 46);
    freq.put("дір", 21);
    freq.put("лсі", 10);
    freq.put("ст ", 175);
    freq.put("ьч", 21);
    freq.put("рги", 14);
    freq.put("рго", 75);
    freq.put("ьс", 1202);
    freq.put("ью", 76);
    freq.put("ья", 59);
    freq.put("рга", 103);
    freq.put("ьш", 297);
    freq.put("рге", 21);
    freq.put("ьє", 9);
    freq.put("нп", 22);
    freq.put(" є ", 284);
    freq.put("щ", 3301);
    freq.put("ргі", 78);
    freq.put("зум", 176);
    freq.put("ьз", 13);
    freq.put("ьд", 13);
    freq.put("юк ", 39);
    freq.put("ьв", 382);
    freq.put("ьг", 38);
    freq.put("мей", 23);
    freq.put("ьо", 1092);
    freq.put("ргу", 26);
    freq.put("ьм", 180);
    freq.put("ьн", 1151);
    freq.put("ьк", 3042);
    freq.put("ьй", 82);
    freq.put("дін", 24);
    freq.put("дім", 12);
    freq.put("діо", 65);
    freq.put("дій", 142);
    freq.put("діл", 206);
    freq.put("мем", 13);
    freq.put("діз", 26);
    freq.put("діж", 23);
    freq.put("діб", 19);
    freq.put("діа", 51);
    freq.put("дів", 307);
    freq.put("ціє", 60);
    freq.put("тів", 396);
    freq.put("егу", 13);
    freq.put("вуй", 9);
    freq.put("вук", 15);
    freq.put("вул", 87);
    freq.put("тіл", 319);
    freq.put("тік", 50);
    freq.put("тій", 76);
    freq.put(" М ", 18);
    freq.put("вув", 60);
    freq.put("егш", 12);
    freq.put("Пів", 20);
    freq.put("егі", 131);
    freq.put(" іг", 32);
    freq.put(" ів", 10);
    freq.put(" ід", 62);
    freq.put("Під", 93);
    freq.put(" ін", 427);
    freq.put(" ім", 75);
    freq.put("еше", 17);
    freq.put("сра", 18);
    freq.put("ешк", 40);
    freq.put("тч ", 27);
    freq.put("ІЙ ", 9);
    freq.put("ешт", 98);
    freq.put("йог", 173);
    freq.put("срі", 12);
    freq.put(" іс", 130);
    freq.put(" іт", 20);
    freq.put("тії", 40);
    freq.put("вує", 46);
    freq.put("тіт", 12);
    freq.put("еге", 18);
    freq.put("тір", 12);
    freq.put("вуш", 12);
    freq.put("ега", 59);
    freq.put("его", 49);
    freq.put("вуч", 26);
    freq.put("егл", 32);
    freq.put("егк", 23);
    freq.put("вут", 11);
    freq.put("еги", 16);
    freq.put("ніа", 16);
    freq.put("ніб", 23);
    freq.put("нів", 434);
    freq.put("ніг", 97);
    freq.put("нід", 23);
    freq.put("ніж", 85);
    freq.put("ніз", 74);
    freq.put("ххх", 10);
    freq.put("ній", 274);
    freq.put("нік", 228);
    freq.put("ніл", 9);
    freq.put("нім", 130);
    freq.put("нін", 33);
    freq.put("П", 2021);
    freq.put("ніп", 54);
    freq.put("Соб", 18);
    freq.put("Сон", 12);
    freq.put("Сол", 17);
    freq.put("Ці ", 9);
    freq.put("Соф", 9);
    freq.put("Соц", 10);
    freq.put("шло", 33);
    freq.put("нір", 28);
    freq.put("ніс", 342);
    freq.put("ніт", 75);
    freq.put("ніф", 10);
    freq.put("ніх", 80);
    freq.put("ніц", 29);
    freq.put("ніч", 199);
    freq.put("ніш", 189);
    freq.put("ьйо", 82);
    freq.put("нію", 22);
    freq.put("нія", 104);
    freq.put("ніє", 23);
    freq.put("нії", 80);
    freq.put("ігі", 39);
    freq.put("ігр", 80);
    freq.put("Аме", 27);
    freq.put("ігу", 28);
    freq.put("Єд", 15);
    freq.put("ов ", 431);
    freq.put("Єв", 165);
    freq.put("КО ", 12);
    freq.put("іга", 88);
    freq.put("іге", 10);
    freq.put("Жан", 12);
    freq.put("ігн", 34);
    freq.put("іго", 45);
    freq.put(" гл", 50);
    freq.put(" го", 743);
    freq.put(" га", 295);
    freq.put(" ге", 90);
    freq.put("охи", 56);
    freq.put("ьни", 392);
    freq.put("чік", 68);
    freq.put("чіп", 15);
    freq.put("чів", 53);
    freq.put("ЕО ", 64);
    freq.put("чіт", 9);
    freq.put("чір", 65);
    freq.put("чіс", 10);
    freq.put("це ", 811);
    freq.put("рс ", 49);
    freq.put(" гі", 87);
    freq.put(" гу", 118);
    freq.put(" гр", 572);
    freq.put("ика", 567);
    freq.put("икн", 16);
    freq.put("ико", 311);
    freq.put("ики", 364);
    freq.put("икл", 127);
    freq.put("ко ", 588);
    freq.put("АЗ ", 9);
    freq.put("отя", 46);
    freq.put("оть", 34);
    freq.put("оту", 162);
    freq.put("отр", 340);
    freq.put("оті", 234);
    freq.put("ияв", 52);
    freq.put("ію ", 399);
    freq.put("иян", 27);
    freq.put("отк", 67);
    freq.put("оти", 293);
    freq.put("ото", 410);
    freq.put("отн", 49);
    freq.put("отв", 10);
    freq.put("ота", 132);
    freq.put("оте", 137);
    freq.put("икі", 201);
    freq.put("Уго", 9);
    freq.put("икр", 36);
    freq.put("ику", 122);
    freq.put("кці", 159);
    freq.put("Л", 982);
    freq.put("им ", 664);
    freq.put("пим", 9);
    freq.put("пин", 76);
    freq.put("пил", 82);
    freq.put("пив", 65);
    freq.put("пиш", 90);
    freq.put("пир", 16);
    freq.put("пис", 309);
    freq.put("пит", 265);
    freq.put("Ц ", 15);
    freq.put("ис ", 53);
    freq.put("Що", 137);
    freq.put("Ща", 16);
    freq.put("Ще", 46);
    freq.put("лід", 158);
    freq.put("Ман", 14);
    freq.put("Мам", 11);
    freq.put("Мал", 26);
    freq.put("Мак", 30);
    freq.put("Май", 45);
    freq.put("уєш", 41);
    freq.put("рба", 27);
    freq.put("КУ ", 21);
    freq.put("рби", 10);
    freq.put("Ча", 55);
    freq.put("рбо", 18);
    freq.put("очн", 115);
    freq.put(" оц", 35);
    freq.put("озп", 142);
    freq.put("рбі", 14);
    freq.put("рбу", 21);
    freq.put("лій", 71);
    freq.put("уєм", 78);
    freq.put("уєн", 11);
    freq.put("Мат", 26);
    freq.put("Мар", 80);
    freq.put("вхо", 12);
    freq.put("ТБ ", 15);
    freq.put("еее", 17);
    freq.put(" єк", 15);
    freq.put(" єд", 64);
    freq.put(" єв", 68);
    freq.put("ста", 1215);
    freq.put("ств", 268);
    freq.put("сте", 255);
    freq.put("сти", 708);
    freq.put("рг ", 19);
    freq.put("сто", 738);
    freq.put("стр", 628);
    freq.put("стс", 12);
    freq.put("сту", 393);
    freq.put("ь ", 5692);
    freq.put("сть", 446);
    freq.put("стю", 89);
    freq.put("стя", 100);
    freq.put("Джо", 17);
    freq.put("сті", 635);
    freq.put(" єр", 63);
    freq.put("дж", 445);
    freq.put("ді ", 390);
    freq.put("йка", 22);
    freq.put(" і ", 1934);
    freq.put("Ель", 12);
    freq.put("йки", 21);
    freq.put("йко", 17);
    freq.put("Ужг", 34);
    freq.put("яп", 17);
    freq.put("ян", 463);
    freq.put("ям", 347);
    freq.put("ял", 166);
    freq.put("як", 1893);
    freq.put("яй", 36);
    freq.put("яз", 139);
    freq.put("яж", 43);
    freq.put("яд", 315);
    freq.put("ву ", 369);
    freq.put("яв", 302);
    freq.put("яб", 18);
    freq.put(" Тр", 100);
    freq.put("еш ", 133);
    freq.put("Сил", 10);
    freq.put("Син", 14);
    freq.put("Те", 165);
    freq.put(" Тю", 10);
    freq.put("ую ", 212);
    freq.put("Сир", 12);
    freq.put("яя", 27);
    freq.put("ИЙ ", 30);
    freq.put("йкі", 10);
    freq.put("яш", 36);
    freq.put("яч", 259);
    freq.put("яц", 106);
    freq.put("Люд", 41);
    freq.put("ят", 983);
    freq.put("яс", 97);
    freq.put("Люб", 44);
    freq.put("йкр", 59);
    freq.put("йку", 14);
    freq.put("яє", 145);
    freq.put("ні ", 2829);
    freq.put(" Бі", 112);
    freq.put("Цік", 40);
    freq.put("дю", 19);
    freq.put("їду", 41);
    freq.put(" ба", 525);
    freq.put(" бе", 399);
    freq.put(" би", 112);
    freq.put(" бл", 200);
    freq.put(" бо", 401);
    freq.put("дви", 22);
    freq.put("овл", 122);
    freq.put("овк", 71);
    freq.put("ови", 1163);
    freq.put("ово", 819);
    freq.put("овн", 402);
    freq.put("овг", 49);
    freq.put("овб", 21);
    freq.put("ова", 743);
    freq.put("овз", 9);
    freq.put("овж", 67);
    freq.put("Є ", 63);
    freq.put("в", 34788);
    freq.put("Змі", 16);
    freq.put("ібл", 40);
    freq.put("ові", 906);
    freq.put("ову", 348);
    freq.put("овт", 83);
    freq.put("овс", 140);
    freq.put("овч", 37);
    freq.put("овц", 36);
    freq.put("овх", 13);
    freq.put(" бі", 471);
    freq.put("іг ", 105);
    freq.put(" бу", 1331);
    freq.put(" бю", 35);
    freq.put("рст", 66);
    freq.put("рсу", 21);
    freq.put("рсь", 104);
    freq.put("ьчи", 12);
    freq.put("рсі", 66);
    freq.put(" г ", 12);
    freq.put("чі ", 298);
    freq.put("цер", 79);
    freq.put("цес", 27);
    freq.put("цею", 16);
    freq.put("Чу", 39);
    freq.put("цев", 39);
    freq.put("цеп", 19);
    freq.put("цем", 41);
    freq.put("цен", 180);
    freq.put("цей", 83);
    freq.put("єї ", 64);
    freq.put("рса", 17);
    freq.put("рсе", 22);
    freq.put("рси", 41);
    freq.put("рсо", 50);
    freq.put("рсп", 11);
    freq.put(" ем", 24);
    freq.put("Наз", 21);
    freq.put("Над", 41);
    freq.put(" еп", 17);
    freq.put("Нав", 45);
    freq.put(" ек", 192);
    freq.put(" ел", 55);
    freq.put("Нап", 25);
    freq.put("Най", 39);
    freq.put("оже", 373);
    freq.put("фор", 190);
    freq.put("фот", 203);
    freq.put("їде", 23);
    freq.put("ожн", 302);
    freq.put("ожл", 68);
    freq.put("ожи", 56);
    freq.put("хо", 1270);
    freq.put("їхн", 17);
    freq.put("ям ", 188);
    freq.put("ожч", 20);
    freq.put("ожц", 15);
    freq.put("ожу", 173);
    freq.put("фон", 108);
    freq.put("фом", 9);
    freq.put("ру ", 280);
    freq.put("фол", 28);
    freq.put("Нац", 45);
    freq.put("ожі", 20);
    freq.put("Наф", 10);
    freq.put("Нат", 23);
    freq.put("Нар", 79);
    freq.put("Нас", 39);
    freq.put(" еф", 31);
    freq.put(" ех", 13);
    freq.put(" ер", 9);
    freq.put("Наш", 31);
    freq.put("аса", 97);
    freq.put("асв", 11);
    freq.put("асе", 50);
    freq.put("аси", 128);
    freq.put("аск", 71);
    freq.put("асл", 106);
    freq.put("асм", 12);
    freq.put("асн", 330);
    freq.put("асо", 128);
    freq.put("асп", 72);
    freq.put("шив", 75);
    freq.put("нзі", 11);
    freq.put("шил", 73);
    freq.put("шик", 20);
    freq.put("рхі", 19);
    freq.put("шин", 63);
    freq.put("шим", 62);
    freq.put("У", 1923);
    freq.put("мча", 12);
    freq.put("ури", 112);
    freq.put("мчу", 11);
    freq.put("гил", 13);
    freq.put("гин", 51);
    freq.put("шит", 63);
    freq.put("шис", 12);
    freq.put("шир", 27);
    freq.put("асі", 103);
    freq.put("асс", 12);
    freq.put("аст", 668);
    freq.put("асу", 111);
    freq.put("асф", 9);
    freq.put("ась", 186);
    freq.put("ася", 141);
    freq.put("лею", 19);
    freq.put("леч", 18);
    freq.put("леф", 56);
    freq.put("лет", 92);
    freq.put("лес", 42);
    freq.put("лер", 64);
    freq.put("Тим", 115);
    freq.put("зга", 35);
    freq.put("згл", 20);
    freq.put("зго", 33);
    freq.put("згр", 11);
    freq.put("Тис", 10);
    freq.put("уяв", 27);
    freq.put("чуж", 21);
    freq.put("леп", 16);
    freq.put("лен", 454);
    freq.put("лем", 108);
    freq.put("лек", 191);
    freq.put("лей", 41);
    freq.put("Де ", 26);
    freq.put("леж", 69);
    freq.put("лед", 26);
    freq.put("лег", 101);
    freq.put("лев", 63);
    freq.put("леб", 12);
    freq.put(" Ві", 476);
    freq.put("двя", 12);
    freq.put(" Вч", 28);
    freq.put(" Вс", 142);
    freq.put(" Вр", 10);
    freq.put(" Ву", 13);
    freq.put("офі", 99);
    freq.put("офс", 10);
    freq.put("офо", 28);
    freq.put("офе", 46);
    freq.put("урі", 34);
    freq.put(" Ве", 144);
    freq.put("їзд", 74);
    freq.put(" Вз", 12);
    freq.put(" Вж", 33);
    freq.put(" Ва", 197);
    freq.put(" Вг", 18);
    freq.put(" Вн", 12);
    freq.put(" Во", 275);
    freq.put(" Ви", 247);
    freq.put(" Вл", 52);
    freq.put("ТП ", 27);
    freq.put("хор", 92);
    freq.put("хос", 13);
    freq.put("хот", 102);
    freq.put("хоч", 379);
    freq.put("уру", 47);
    freq.put("иха", 48);
    freq.put("ихо", 139);
    freq.put("ихи", 15);
    freq.put("Тра", 17);
    freq.put("Тре", 42);
    freq.put("Три", 15);
    freq.put("Тро", 14);
    freq.put("ихі", 82);
    freq.put("хов", 169);
    freq.put("ход", 325);
    freq.put("хож", 26);
    freq.put("хол", 54);
    freq.put("хом", 21);
    freq.put("хоп", 27);
    freq.put("Мол", 28);
    freq.put("Мож", 41);
    freq.put("Мов", 12);
    freq.put("тє ", 11);
    freq.put("рза", 17);
    freq.put("ец ", 14);
    freq.put("ме ", 137);
    freq.put("еб ", 10);
    freq.put("Моя", 11);
    freq.put("Мос", 40);
    freq.put("Мор", 23);
    freq.put("ой", 268);
    freq.put("ок", 1907);
    freq.put("ол", 3466);
    freq.put("ом", 3686);
    freq.put("он", 2845);
    freq.put("оо", 143);
    freq.put("оп", 1235);
    freq.put("оа", 26);
    freq.put("об", 3098);
    freq.put("вят", 145);
    freq.put("ог", 3843);
    freq.put("од", 3894);
    freq.put("ое", 139);
    freq.put("ож", 1129);
    freq.put("оз", 1523);
    freq.put("сфе", 24);
    freq.put("сфа", 11);
    freq.put("ефе", 25);
    freq.put("сфо", 18);
    freq.put("ефо", 76);
    freq.put("к", 26512);
    freq.put("ефі", 28);
    freq.put("ху ", 74);
    freq.put("ге ", 24);
    freq.put("оє", 242);
    freq.put("оі", 24);
    freq.put("ої", 1232);
    freq.put("ош", 526);
    freq.put("ощ", 193);
    freq.put("вян", 14);
    freq.put("ою", 960);
    freq.put("оя", 175);
    freq.put("ор", 4168);
    freq.put("ос", 3148);
    freq.put("от", 2075);
    freq.put("оу", 71);
    freq.put("оф", 215);
    freq.put("ох", 440);
    freq.put("оц", 264);
    freq.put("оч", 1439);
    freq.put("йму", 9);
    freq.put("лі ", 526);
    freq.put("Ч ", 11);
    freq.put("зел", 19);
    freq.put(" Ек", 67);
    freq.put("йме", 16);
    freq.put("йма", 57);
    freq.put("ймо", 53);
    freq.put("іб ", 37);
    freq.put("нщи", 28);
    freq.put("руш", 66);
    freq.put("рую", 15);
    freq.put("ож ", 57);
    freq.put("рут", 141);
    freq.put("рур", 11);
    freq.put("рус", 70);
    freq.put("руч", 77);
    freq.put("рух", 51);
    freq.put("ьси", 12);
    freq.put("На ", 325);
    freq.put(" е ", 10);
    freq.put("рує", 24);
    freq.put("їх ", 159);
    freq.put("збі", 71);
    freq.put("яму", 10);
    freq.put("збу", 36);
    freq.put("збр", 17);
    freq.put("збо", 17);
    freq.put("зби", 81);
    freq.put("ями", 90);
    freq.put("збе", 30);
    freq.put("ямо", 26);
    freq.put("зба", 32);
    freq.put("ьсь", 105);
    freq.put("ься", 1041);
    freq.put("ьст", 29);
    freq.put("рук", 129);
    freq.put("рул", 12);
    freq.put("руй", 19);
    freq.put("руп", 91);
    freq.put("рум", 41);
    freq.put("рун", 40);
    freq.put("рув", 58);
    freq.put("руг", 166);
    freq.put("Лит", 18);
    freq.put("руб", 38);
    freq.put("руж", 62);
    freq.put("руз", 103);
    freq.put("руд", 71);
    freq.put("ши ", 37);
    freq.put("ас ", 456);
    freq.put("Гру", 22);
    freq.put("ги ", 194);
    freq.put(" ©", 13);
    freq.put("кщо", 208);
    freq.put("Гри", 31);
    freq.put("Гро", 18);
    freq.put("Гра", 21);
    freq.put("Гре", 20);
    freq.put("дго", 24);
    freq.put("лга", 14);
    freq.put("лго", 9);
    freq.put(" Ас", 17);
    freq.put(" Ар", 60);
    freq.put(" Ах", 21);
    freq.put("Дея", 9);
    freq.put("Дер", 48);
    freq.put("ях ", 114);
    freq.put("оці", 167);
    freq.put("ж", 6009);
    freq.put("Ти ", 47);
    freq.put("оце", 45);
    freq.put("іші", 20);
    freq.put("оци", 11);
    freq.put(" Аг", 20);
    freq.put(" Ав", 51);
    freq.put(" Аб", 14);
    freq.put("єди", 34);
    freq.put("Дем", 24);
    freq.put("Ден", 94);
    freq.put("єдн", 56);
    freq.put("Деп", 34);
    freq.put(" Ал", 123);
    freq.put(" Ак", 23);
    freq.put("Дев", 11);
    freq.put(" Ан", 143);
    freq.put("ле ", 526);
    freq.put("цин", 23);
    freq.put("с ", 1185);
    freq.put("цим", 21);
    freq.put(" В ", 374);
    freq.put("тці", 20);
    freq.put("бго", 24);
    freq.put("рем", 268);
    freq.put("рен", 309);
    freq.put("рео", 10);
    freq.put("реп", 92);
    freq.put("их ", 1177);
    freq.put("рей", 91);
    freq.put("рек", 252);
    freq.put("рел", 38);
    freq.put("ред", 435);
    freq.put("реж", 116);
    freq.put("рез", 530);
    freq.put("реа", 97);
    freq.put("реб", 262);
    freq.put("рев", 158);
    freq.put("рег", 171);
    freq.put("чня", 38);
    freq.put("чну", 49);
    freq.put("чни", 296);
    freq.put("чно", 306);
    freq.put("реє", 32);
    freq.put("реї", 20);
    freq.put("чне", 61);
    freq.put("реш", 102);
    freq.put("рещ", 11);
    freq.put("реф", 35);
    freq.put("рех", 33);
    freq.put("рец", 46);
    freq.put("реч", 113);
    freq.put("рер", 23);
    freq.put("рес", 247);
    freq.put("рет", 154);
    freq.put("ВР ", 16);
    freq.put("И ", 104);
    freq.put("хо ", 25);
    freq.put("мер", 250);
    freq.put("мет", 168);
    freq.put("вст", 141);
    freq.put("мец", 24);
    freq.put("меч", 28);
    freq.put("всю", 28);
    freq.put("вся", 390);
    freq.put("ебу", 34);
    freq.put("цик", 20);
    freq.put("фа ", 20);
    freq.put("всі", 351);
    freq.put("Чи ", 48);
    freq.put("ебі", 24);
    freq.put("сце", 104);
    freq.put("еце", 19);
    freq.put("сця", 30);
    freq.put("ець", 274);
    freq.put("ецт", 18);
    freq.put("сці", 21);
    freq.put("еці", 70);
    freq.put("еби", 11);
    freq.put("все", 344);
    freq.put("мед", 93);
    freq.put("меж", 37);
    freq.put("ебо", 29);
    freq.put("еба", 242);
    freq.put("мел", 50);
    freq.put("ебе", 314);
    freq.put("мен", 1217);
    freq.put("йом", 116);
    freq.put("йон", 159);
    freq.put("йоз", 28);
    freq.put("Фут", 12);
    freq.put("йоб", 14);
    freq.put("йов", 19);
    freq.put("Офі", 12);
    freq.put("о ", 12167);
    freq.put("Сме", 9);
    freq.put("Сма", 10);
    freq.put("впа", 48);
    freq.put("хує", 14);
    freq.put("худ", 18);
    freq.put("хув", 32);
    freq.put("хун", 28);
    freq.put("хул", 9);
    freq.put("хуй", 25);
    freq.put("ліж", 23);
    freq.put("ліз", 167);
    freq.put("Че", 319);
    freq.put("лів", 170);
    freq.put("ліг", 45);
    freq.put("ліб", 13);
    freq.put("ліо", 29);
    freq.put("Чо", 148);
    freq.put("лім", 78);
    freq.put("лін", 189);
    freq.put("лік", 205);
    freq.put("Чи", 95);
    freq.put("ібр", 39);
    freq.put("дзе", 24);
    freq.put("э", 18);
    freq.put("лії", 39);
    freq.put("ліє", 21);
    freq.put("ібн", 129);
    freq.put("іба", 19);
    freq.put("ібе", 18);
    freq.put("ліц", 109);
    freq.put("ліч", 40);
    freq.put("ліф", 21);
    freq.put("літ", 330);
    freq.put("ліс", 185);
    freq.put("лію", 12);
    freq.put("лія", 43);
    freq.put("дзн", 52);
    freq.put("ліш", 11);
    freq.put("Дум", 15);
    freq.put("Дуж", 24);
    freq.put("АР ", 12);
    freq.put("юва", 195);
    freq.put("йви", 13);
    freq.put("йва", 13);
    freq.put("із ", 214);
    freq.put("Дур", 9);
    freq.put("од ", 84);
    freq.put(" з ", 1738);
    freq.put("фи ", 16);
    freq.put(" йт", 19);
    freq.put("ахо", 135);
    freq.put("вел", 176);
    freq.put("вей", 12);
    freq.put("вен", 117);
    freq.put("СН ", 16);
    freq.put("ау ", 9);
    freq.put("веб", 9);
    freq.put("вез", 34);
    freq.put("вед", 157);
    freq.put("КИ ", 16);
    freq.put("ґр", 10);
    freq.put("Йо", 35);
    freq.put("мс ", 11);
    freq.put("о", 60588);
    freq.put("нгу", 47);
    freq.put("їст", 37);
    freq.put("жго", 39);
    freq.put("не ", 3151);
    freq.put("вет", 30);
    freq.put("вер", 450);
    freq.put("вес", 191);
    freq.put("вец", 73);
    freq.put("веч", 102);
    freq.put(" йо", 228);
    freq.put(" йд", 67);
    freq.put("ьяр", 23);
    freq.put("ТІ ", 9);
    freq.put("ахи", 99);
    freq.put("ахл", 20);
    freq.put("аха", 194);
    freq.put("ахв", 15);
    freq.put("муж", 18);
    freq.put("муз", 102);
    freq.put("муд", 26);
    freq.put("мув", 60);
    freq.put("мум", 15);
    freq.put("мун", 58);
    freq.put("яч ", 55);
    freq.put("пі", 1781);
    freq.put("пє", 16);
    freq.put("мул", 38);
    freq.put("пя", 11);
    freq.put("пч", 37);
    freq.put("пц", 75);
    freq.put("пф", 9);
    freq.put("пу", 516);
    freq.put("пт", 92);
    freq.put("пс", 62);
    freq.put("пр", 4426);
    freq.put("пп", 20);
    freq.put("по", 5152);
    freq.put("пн", 170);
    freq.put("пл", 672);
    freq.put("пк", 41);
    freq.put("пи", 1045);
    freq.put("пе", 1962);
    freq.put("па", 1468);
    freq.put("рщи", 20);
    freq.put("муч", 21);
    freq.put("АН ", 10);
    freq.put("мур", 18);
    freq.put("мус", 57);
    freq.put("мую", 36);
    freq.put("ахі", 80);
    freq.put("муш", 17);
    freq.put("нго", 20);
    freq.put("мує", 28);
    freq.put("Лон", 12);
    freq.put("нгл", 53);
    freq.put("нге", 15);
    freq.put("ус ", 52);
    freq.put("ахр", 9);
    freq.put("ахт", 39);
    freq.put("ьян", 17);
    freq.put("Д", 1455);
    freq.put("ууу", 36);
    freq.put("ііі", 9);
    freq.put("яке", 42);
    freq.put("яка", 135);
    freq.put("якб", 20);
    freq.put("зпе", 78);
    freq.put("яки", 295);
    freq.put("нні", 267);
    freq.put("яку", 194);
    freq.put("якр", 16);
    freq.put("зпр", 18);
    freq.put("якш", 15);
    freq.put("якщ", 145);
    freq.put("які", 236);
    freq.put("ив ", 517);
    freq.put("ясо", 12);
    freq.put("ясн", 45);
    freq.put("яск", 14);
    freq.put(" Д ", 9);
    freq.put("иді", 64);
    freq.put("віс", 118);
    freq.put("вір", 244);
    freq.put("па ", 75);
    freq.put("віщ", 23);
    freq.put("віш", 46);
    freq.put(" са", 382);
    freq.put(" св", 711);
    freq.put("иду", 38);
    freq.put(" се", 603);
    freq.put("идя", 12);
    freq.put(" ск", 464);
    freq.put(" сл", 296);
    freq.put(" см", 171);
    freq.put(" сн", 121);
    freq.put(" со", 360);
    freq.put(" сп", 930);
    freq.put(" Жу", 21);
    freq.put(" Че", 318);
    freq.put("євс", 10);
    freq.put("євр", 65);
    freq.put("ич ", 123);
    freq.put("куд", 49);
    freq.put("куб", 14);
    freq.put("кув", 189);
    freq.put(" Жі", 12);
    freq.put("кум", 45);
    freq.put("кун", 18);
    freq.put("куп", 150);
    freq.put("куй", 10);
    freq.put("кул", 119);
    freq.put("кух", 12);
    freq.put("куч", 23);
    freq.put("кур", 222);
    freq.put("кус", 45);
    freq.put("кут", 28);
    freq.put("кую", 148);
    freq.put("кує", 75);
    freq.put(" Жа", 31);
    freq.put("л ", 495);
    freq.put(" Же", 15);
    freq.put("єво", 15);
    freq.put("єва", 48);
    freq.put(" Жо", 16);
    freq.put(" ср", 22);
    freq.put("идж", 38);
    freq.put("иде", 121);
    freq.put(" су", 383);
    freq.put(" сф", 31);
    freq.put(" сх", 73);
    freq.put("идб", 17);
    freq.put("ида", 167);
    freq.put("идо", 20);
    freq.put("идн", 34);
    freq.put("идл", 16);
    freq.put("идк", 47);
    freq.put(" сю", 28);
    freq.put("иди", 41);
    freq.put("вів", 301);
    freq.put("віа", 16);
    freq.put("віз", 84);
    freq.put("віж", 25);
    freq.put(" сі", 144);
    freq.put("від", 2034);
    freq.put("віл", 127);
    freq.put("вік", 158);
    freq.put("вій", 173);
    freq.put("він", 220);
    freq.put("вім", 11);
    freq.put("Кли", 49);
    freq.put("Кла", 11);
    freq.put("ки ", 1807);
    freq.put("Клі", 16);
    freq.put("бто", 21);
    freq.put("дь ", 157);
    freq.put("зча", 14);
    freq.put("мут", 92);
    freq.put("Ми ", 54);
    freq.put("рла", 58);
    freq.put("без", 324);
    freq.put("бел", 22);
    freq.put("бен", 24);
    freq.put("щий", 34);
    freq.put("щим", 12);
    freq.put("щин", 205);
    freq.put("ет ", 198);
    freq.put("ьщи", 10);
    freq.put("ЗС ", 12);
    freq.put("рлі", 23);
    freq.put("щит", 24);
    freq.put("щир", 20);
    freq.put("щих", 26);
    freq.put("бер", 212);
    freq.put("бет", 15);
    freq.put("аху", 84);
    freq.put("ізь", 42);
    freq.put("А", 1058);
    freq.put("Джи", 9);
    freq.put("ізр", 9);
    freq.put("ізу", 46);
    freq.put("удр", 20);
    freq.put("ізм", 36);
    freq.put("ізн", 227);
    freq.put("ізо", 40);
    freq.put("ізи", 49);
    freq.put("ізк", 14);
    freq.put("ізд", 33);
    freq.put("іза", 110);
    freq.put("ізв", 15);
    freq.put(" зу", 143);
    freq.put(" зр", 289);
    freq.put("Нов", 248);
    freq.put("вза", 103);
    freq.put("оди", 725);
    freq.put("одк", 24);
    freq.put("одн", 906);
    freq.put("одо", 519);
    freq.put("ода", 496);
    freq.put("оде", 76);
    freq.put("одз", 14);
    freq.put("одж", 145);
    freq.put("ТУ ", 9);
    freq.put("мва", 10);
    freq.put("одш", 9);
    freq.put("одь", 27);
    freq.put("одя", 74);
    freq.put("одс", 19);
    freq.put("одр", 57);
    freq.put("оду", 234);
    freq.put("взя", 50);
    freq.put(" зд", 180);
    freq.put(" зе", 76);
    freq.put(" зв", 299);
    freq.put(" зг", 66);
    freq.put(" за", 3432);
    freq.put(" зб", 199);
    freq.put("Нор", 10);
    freq.put(" зм", 225);
    freq.put(" зн", 620);
    freq.put(" зл", 75);
    freq.put(" зи", 46);
    freq.put("оді", 450);
    freq.put("рчі", 9);
    freq.put("уєт", 96);
    freq.put("нец", 137);
    freq.put("нес", 163);
    freq.put("нер", 211);
    freq.put("аун", 22);
    freq.put("Джа", 12);
    freq.put("ве ", 146);
    freq.put("нею", 25);
    freq.put("нещ", 10);
    freq.put("неш", 22);
    freq.put("ауд", 14);
    freq.put("неї", 48);
    freq.put("рчу", 27);
    freq.put("шко", 179);
    freq.put("шки", 67);
    freq.put("©", 13);
    freq.put("Й ", 55);
    freq.put("зпо", 127);
    freq.put("Це ", 107);
    freq.put("мсь", 23);
    freq.put("яко", 143);
    freq.put("гко", 21);
    freq.put("мст", 41);
    freq.put("рча", 14);
    freq.put("рчо", 19);
    freq.put("рчи", 31);
    freq.put("нед", 106);
    freq.put("нез", 100);
    freq.put("РА ", 14);
    freq.put("неб", 74);
    freq.put("неа", 9);
    freq.put("нег", 20);
    freq.put("нев", 90);
    freq.put("нен", 275);
    freq.put("жці", 15);
    freq.put("неп", 80);
    freq.put("нео", 32);
    freq.put("ней", 31);
    freq.put("нел", 13);
    freq.put("нек", 9);
    freq.put("ячн", 44);
    freq.put("ячо", 26);
    freq.put("ких", 256);
    freq.put("ячи", 39);
    freq.put("му ", 1274);
    freq.put("ячк", 13);
    freq.put("яче", 26);
    freq.put("киш", 9);
    freq.put("яча", 13);
    freq.put("кия", 10);
    freq.put("йт ", 24);
    freq.put("уся", 26);
    freq.put("киї", 42);
    freq.put("усь", 88);
    freq.put("усу", 14);
    freq.put("уст", 241);
    freq.put("ах ", 493);
    freq.put("зни", 155);
    freq.put("зно", 150);
    freq.put("зна", 727);
    freq.put("зне", 71);
    freq.put("зня", 99);
    freq.put("зні", 65);
    freq.put("п ", 274);
    freq.put("усл", 14);
    freq.put("уск", 91);
    freq.put("ья ", 11);
    freq.put("уси", 42);
    freq.put("усп", 62);
    freq.put("усо", 17);
    freq.put("усн", 11);
    freq.put("усм", 9);
    freq.put("ячі", 29);
    freq.put("івс", 277);
    freq.put("усе", 12);
    freq.put("нг ", 53);
    freq.put("кид", 49);
    freq.put("рщ ", 9);
    freq.put("кин", 86);
    freq.put("ким", 184);
    freq.put("ячу", 14);
    freq.put("ивш", 15);
    freq.put(" Ді", 55);
    freq.put("ивч", 21);
    freq.put("ивц", 15);
    freq.put("ивс", 191);
    freq.put("иву", 63);
    freq.put(" Дя", 51);
    freq.put("Рів", 32);
    freq.put("Різ", 12);
    freq.put("тім", 86);
    freq.put("иві", 200);
    freq.put(" Ду", 63);
    freq.put(" Др", 66);
    freq.put("як ", 639);
    freq.put("Цен", 21);
    freq.put("Цей", 14);
    freq.put("ІТ ", 9);
    freq.put("єтк", 9);
    freq.put("єц", 22);
    freq.put("Цер", 14);
    freq.put(" До", 328);
    freq.put(" Дн", 97);
    freq.put(" Дм", 14);
    freq.put(" Дл", 35);
    freq.put(" Ди", 118);
    freq.put("єт", 628);
    freq.put(" Де", 275);
    freq.put(" Дв", 19);
    freq.put(" Да", 71);
    freq.put("ивн", 178);
    freq.put("иво", 244);
    freq.put("Міл", 40);
    freq.put("ивл", 57);
    freq.put("ивк", 11);
    freq.put("иве", 117);
    freq.put("ива", 400);
    freq.put(" с ", 139);
    freq.put("пад", 150);
    freq.put("пав", 46);
    freq.put("паг", 11);
    freq.put("пам", 101);
    freq.put("єк", 18);
    freq.put("пап", 31);
    freq.put("пак", 31);
    freq.put("пал", 164);
    freq.put("Кни", 14);
    freq.put("ку ", 1456);
    freq.put("лі", 2569);
    freq.put("Ч", 705);
    freq.put("лє", 41);
    freq.put("лу", 661);
    freq.put("лт", 81);
    freq.put("лс", 17);
    freq.put("лр", 21);
    freq.put("ичк", 89);
    freq.put("ичи", 48);
    freq.put("иче", 37);
    freq.put("ля", 1764);
    freq.put("лю", 1303);
    freq.put("ича", 169);
    freq.put("ль", 3113);
    freq.put("лг", 31);
    freq.put("лб", 20);
    freq.put("ла", 3641);
    freq.put("ле", 1944);
    freq.put("лд", 25);
    freq.put("лл", 136);
    freq.put("лк", 213);
    freq.put("ли", 4015);
    freq.put("ло", 2923);
    freq.put("лн", 54);
    freq.put("ліп", 50);
    freq.put("ичі", 13);
    freq.put("пах", 21);
    freq.put("пац", 19);
    freq.put("пач", 12);
    freq.put("пар", 249);
    freq.put("пас", 105);
    freq.put("пат", 243);
    freq.put("хма", 34);
    freq.put("паш", 12);
    freq.put("хме", 9);
    freq.put("пає", 18);
    freq.put("ид ", 17);
    freq.put("Мих", 24);
    freq.put("Мит", 18);
    freq.put("Мир", 15);
    freq.put("рйо", 28);
    freq.put("віч", 61);
    freq.put("дьт", 24);
    freq.put("Мук", 12);
    freq.put("дьк", 14);
    freq.put("дьм", 15);
    freq.put("Мик", 68);
    freq.put("мбу", 17);
    freq.put(" си", 270);
    freq.put("мбі", 13);
    freq.put("ете", 105);
    freq.put("ета", 125);
    freq.put("етв", 48);
    freq.put("етн", 44);
    freq.put("ето", 52);
    freq.put("ети", 98);
    freq.put("етк", 19);
    freq.put("идш", 11);
    freq.put("еті", 95);
    freq.put("етр", 135);
    freq.put("етс", 12);
    freq.put("ету", 87);
    freq.put("еть", 204);
    freq.put("етю", 10);
    freq.put("етя", 15);
    freq.put("мбо", 11);
    freq.put("іхт", 35);
    freq.put("рне", 141);
    freq.put("бли", 188);
    freq.put("рна", 228);
    freq.put("бло", 86);
    freq.put("рно", 297);
    freq.put("бла", 192);
    freq.put("рни", 180);
    freq.put("бле", 124);
    freq.put("щой", 9);
    freq.put("щод", 87);
    freq.put("И", 18);
    freq.put("щоб", 180);
    freq.put("щов", 12);
    freq.put("щог", 11);
    freq.put("Вчо", 17);
    freq.put("Хор", 18);
    freq.put("Хот", 12);
    freq.put("Хоч", 68);
    freq.put("ер ", 456);
    freq.put("дше", 11);
    freq.put("рні", 275);
    freq.put("щор", 11);
    freq.put("блі", 120);
    freq.put("бля", 93);
    freq.put("блю", 132);
    freq.put("рну", 79);
    freq.put("блу", 15);
    freq.put("рню", 10);
    freq.put("рня", 22);
    freq.put(" Ру", 49);
    freq.put("Пшо", 9);
    freq.put("мні", 61);
    freq.put("сюд", 28);
    freq.put(" Рі", 72);
    freq.put("ДА ", 29);
    freq.put("Юще", 13);
    freq.put("мни", 73);
    freq.put("мно", 117);
    freq.put("мна", 49);
    freq.put("мне", 14);
    freq.put(" Ра", 150);
    freq.put(" Ре", 125);
    freq.put(" Ри", 37);
    freq.put(" Ро", 248);
    freq.put(" Жи", 129);
    freq.put("іл ", 38);
    freq.put(" ст", 1057);
    freq.put("йже", 99);
    freq.put("бме", 12);
    freq.put(" сц", 27);
    freq.put(" сь", 283);
    freq.put("м ", 3422);
    freq.put("ійс", 221);
    freq.put("ійц", 22);
    freq.put("ійш", 32);
    freq.put("Жов", 10);
    freq.put("ійд", 14);
    freq.put("ійк", 17);
    freq.put("ійм", 19);
    freq.put("ійн", 308);
    freq.put("хм ", 13);
    freq.put(" нє", 42);
    freq.put(" ні", 579);
    freq.put("вба", 24);
    freq.put("вбо", 23);
    freq.put("вби", 47);
    freq.put("шо ", 172);
    freq.put(" ну", 208);
    freq.put(" нь", 61);
    freq.put(" ня", 9);
    freq.put(" Ів", 117);
    freq.put("ююч", 11);
    freq.put("юют", 56);
    freq.put("го ", 2221);
    freq.put("єнк", 16);
    freq.put(" не", 3101);
    freq.put(" на", 4668);
    freq.put("ач ", 30);
    freq.put(" но", 656);
    freq.put(" ни", 135);
    freq.put("цю ", 84);
    freq.put("П ", 90);
    freq.put("іко", 169);
    freq.put("шал", 23);
    freq.put("Ен", 18);
    freq.put("шан", 39);
    freq.put("ащу", 10);
    freq.put("нпр", 12);
    freq.put("ащі", 15);
    freq.put("яд ", 127);
    freq.put("гає", 46);
    freq.put("Я", 864);
    freq.put("Зро", 14);
    freq.put("гаю", 43);
    freq.put("гар", 194);
    freq.put("Чек", 9);
    freq.put("гат", 180);
    freq.put("гах", 17);
    freq.put("гац", 9);
    freq.put("Чем", 27);
    freq.put("гай", 20);
    freq.put("Чер", 250);
    freq.put("гам", 31);
    freq.put("ган", 229);
    freq.put("ух ", 33);
    freq.put("гав", 21);
    freq.put("гад", 113);
    freq.put("газ", 126);
    freq.put("цьк", 364);
    freq.put("цьо", 162);
    freq.put("шає", 21);
    freq.put("мят", 9);
    freq.put("шаш", 9);
    freq.put("шаю", 10);
    freq.put("ащо", 13);
    freq.put("аща", 10);
    freq.put("шат", 16);
    freq.put("шар", 15);
    freq.put("аще", 121);
    freq.put("шах", 24);
    freq.put("кві", 130);
    freq.put(" у ", 1401);
    freq.put("зли", 29);
    freq.put("зло", 44);
    freq.put("яжк", 11);
    freq.put("зла", 21);
    freq.put("учу", 9);
    freq.put("кс ", 90);
    freq.put("яжн", 10);
    freq.put("їн ", 23);
    freq.put("злі", 12);
    freq.put("учи", 88);
    freq.put("учк", 18);
    freq.put("учн", 59);
    freq.put("учо", 10);
    freq.put("уча", 146);
    freq.put("уче", 34);
    freq.put("ква", 99);
    freq.put("кви", 48);
    freq.put("Шко", 20);
    freq.put(" хм", 37);
    freq.put(" хо", 631);
    freq.put(" хл", 74);
    freq.put(" хе", 25);
    freq.put(" хз", 9);
    freq.put(" ха", 150);
    freq.put(" хв", 95);
    freq.put(" Кр", 156);
    freq.put(" Ку", 83);
    freq.put("Зе", 35);
    freq.put("Зд", 32);
    freq.put("Зг", 13);
    freq.put("Зв", 28);
    freq.put("Зб", 49);
    freq.put("За", 513);
    freq.put("Зо", 20);
    freq.put("Зн", 47);
    freq.put("Зм", 22);
    freq.put("Зл", 11);
    freq.put("Зу", 14);
    freq.put("хи ", 85);
    freq.put("Зр", 15);
    freq.put("цих", 21);
    freq.put(" Кн", 20);
    freq.put("Зі", 19);
    freq.put("тат", 427);
    freq.put(" Ки", 294);
    freq.put(" Кл", 96);
    freq.put(" Ке", 27);
    freq.put(" Ка", 264);
    freq.put(" Кв", 26);
    freq.put(" Ча", 55);
    freq.put("циф", 10);
    freq.put("К ", 194);
    freq.put(" хт", 211);
    freq.put(" ху", 45);
    freq.put(" Чо", 148);
    freq.put(" хі", 50);
    freq.put("Рез", 12);
    freq.put("Реа", 18);
    freq.put("Рег", 28);
    freq.put("рн ", 88);
    freq.put(" Чи", 95);
    freq.put("бл ", 9);
    freq.put("еро", 154);
    freq.put("ерп", 65);
    freq.put("ерм", 49);
    freq.put("ерн", 476);
    freq.put("ерк", 136);
    freq.put("ерл", 52);
    freq.put("ери", 191);
    freq.put("ерй", 24);
    freq.put("ерж", 147);
    freq.put("ерз", 17);
    freq.put("ерд", 74);
    freq.put("ере", 1545);
    freq.put("ерв", 160);
    freq.put("ерг", 152);
    freq.put("ера", 251);
    freq.put("ерб", 35);
    freq.put("аф ", 14);
    freq.put("чле", 16);
    freq.put("ері", 381);
    freq.put("еря", 15);
    freq.put("ерш", 307);
    freq.put("ерц", 46);
    freq.put("ерч", 11);
    freq.put("ерф", 15);
    freq.put("ерх", 66);
    freq.put("ерт", 263);
    freq.put("еру", 84);
    freq.put("ерс", 189);
    freq.put("Рес", 9);
    freq.put("Жу", 21);
    freq.put("сю ", 27);
    freq.put("Жі", 12);
    freq.put(" Р ", 13);
    freq.put("Жа", 31);
    freq.put("Же", 16);
    freq.put("Жи", 129);
    freq.put("Жо", 16);
    freq.put(" Чу", 39);
    freq.put("Рос", 89);
    freq.put("іль", 1256);
    freq.put("ілю", 31);
    freq.put("іля", 122);
    freq.put("ДВ ", 9);
    freq.put("ілу", 42);
    freq.put("Жит", 114);
    freq.put("рли", 18);
    freq.put("ілі", 163);
    freq.put("іли", 143);
    freq.put("ілк", 80);
    freq.put("ілл", 53);
    freq.put("іло", 175);
    freq.put("іла", 116);
    freq.put("ілб", 10);
    freq.put("іле", 52);
    freq.put("ме", 2100);
    freq.put("мв", 21);
    freq.put("ма", 2846);
    freq.put("мб", 73);
    freq.put("мо", 2974);
    freq.put("мп", 338);
    freq.put("мм", 54);
    freq.put("мн", 330);
    freq.put("мк", 192);
    freq.put("мл", 182);
    freq.put("ми", 1623);
    freq.put(" лу", 61);
    freq.put("вго", 42);
    freq.put("вге", 19);
    freq.put(" лю", 614);
    freq.put(" ля", 39);
    freq.put(" ль", 52);
    freq.put("Ша", 65);
    freq.put("жби", 18);
    freq.put("жбо", 12);
    freq.put("жба", 21);
    freq.put("ій ", 984);
    freq.put("тки", 120);
    freq.put("мі", 2196);
    freq.put("мє", 12);
    freq.put(" ле", 124);
    freq.put(" ли", 233);
    freq.put(" ло", 60);
    freq.put("мц", 35);
    freq.put("мч", 28);
    freq.put("мф", 15);
    freq.put("мт", 18);
    freq.put("му", 1888);
    freq.put("мр", 51);
    freq.put("мс", 87);
    freq.put("мя", 14);
    freq.put("шоб", 27);
    freq.put("шог", 81);
    freq.put("шов", 124);
    freq.put("ачу", 91);
    freq.put("шок", 42);
    freq.put("шон", 11);
    freq.put("шом", 44);
    freq.put("ачі", 84);
    freq.put("йшл", 157);
    freq.put("ьщі", 21);
    freq.put("йшо", 95);
    freq.put("цюю", 27);
    freq.put("гої", 9);
    freq.put("гот", 165);
    freq.put("Фор", 22);
    freq.put("гор", 233);
    freq.put("гос", 112);
    freq.put("гою", 35);
    freq.put("год", 699);
    freq.put("гов", 229);
    freq.put("гог", 19);
    freq.put("гоп", 16);
    freq.put("гом", 61);
    freq.put("гон", 50);
    freq.put("гол", 397);
    freq.put("юю ", 31);
    freq.put("нба", 18);
    freq.put("рш ", 21);
    freq.put("цюв", 49);
    freq.put("шої", 28);
    freq.put("шос", 38);
    freq.put("шоу", 12);
    freq.put("аче", 159);
    freq.put(" н ", 17);
    freq.put("ача", 189);
    freq.put("ачо", 14);
    freq.put("ачн", 68);
    freq.put("ачк", 31);
    freq.put("ачи", 239);
    freq.put("шою", 35);
    freq.put("ллі", 32);
    freq.put("лля", 39);
    freq.put("ша ", 149);
    freq.put("уху", 38);
    freq.put("яди", 11);
    freq.put("ядк", 20);
    freq.put("ядн", 9);
    freq.put("ядо", 29);
    freq.put("яда", 40);
    freq.put("ядж", 12);
    freq.put("ядь", 11);
    freq.put("яду", 26);
    freq.put("уха", 134);
    freq.put("га ", 228);
    freq.put("ухо", 52);
    freq.put("ухн", 16);
    freq.put("яді", 17);
    freq.put("ухи", 13);
    freq.put("лло", 18);
    freq.put("Му", 51);
    freq.put("лла", 14);
    freq.put("ць ", 229);
    freq.put("вєт", 10);
    freq.put(" ук", 344);
    freq.put(" ул", 32);
    freq.put(" уп", 43);
    freq.put(" ум", 45);
    freq.put("Біл", 69);
    freq.put(" ув", 60);
    freq.put(" уг", 23);
    freq.put("ижу", 10);
    freq.put("Біз", 14);
    freq.put(" уж", 50);
    freq.put("Біб", 13);
    freq.put(" уд", 29);
    freq.put("їну", 85);
    freq.put("їнс", 342);
    freq.put("їнц", 99);
    freq.put("ксо", 17);
    freq.put("ксп", 87);
    freq.put("ієв", 13);
    freq.put("кск", 18);
    freq.put("кси", 37);
    freq.put("ксе", 14);
    freq.put("ієн", 41);
    freq.put("їні", 202);
    freq.put("кса", 61);
    freq.put("т", 35495);
    freq.put("лн ", 47);
    freq.put("уч ", 12);
    freq.put("кст", 42);
    freq.put("ксу", 28);
    freq.put("ією", 99);
    freq.put("їнк", 12);
    freq.put("їни", 286);
    freq.put("їно", 31);
    freq.put("ієї", 31);
    freq.put("ксі", 26);
    freq.put("їна", 155);
    freq.put("їне", 9);
    freq.put("ижи", 14);
    freq.put("ижк", 41);
    freq.put("ижн", 66);
    freq.put(" уя", 27);
    freq.put(" ут", 33);
    freq.put("ижа", 9);
    freq.put(" ур", 62);
    freq.put(" ус", 144);
    freq.put("иже", 9);
    freq.put("ижд", 50);
    freq.put(" ух", 10);
    freq.put("нян", 60);
    freq.put("Кр", 158);
    freq.put("Ку", 89);
    freq.put("Кі", 93);
    freq.put("хис", 69);
    freq.put("брі", 15);
    freq.put("зст", 10);
    freq.put("хищ", 17);
    freq.put("бру", 22);
    freq.put("бри", 76);
    freq.put("бро", 94);
    freq.put("бра", 241);
    freq.put(" К ", 14);
    freq.put("бре", 105);
    freq.put("зсл", 20);
    freq.put("хил", 29);
    freq.put("Кн", 20);
    freq.put("Ко", 368);
    freq.put("Ки", 294);
    freq.put("Кл", 96);
    freq.put("Ке", 27);
    freq.put("Ка", 266);
    freq.put("Кв", 26);
    freq.put("аб ", 12);
    freq.put(" че", 555);
    freq.put(" ча", 386);
    freq.put("СЯ ", 13);
    freq.put(" чо", 337);
    freq.put(" чл", 16);
    freq.put(" чи", 382);
    freq.put("х ", 2330);
    freq.put("тчі", 25);
    freq.put("иць", 92);
    freq.put(" Мі", 198);
    freq.put(" дз", 36);
    freq.put("иця", 81);
    freq.put(" Му", 50);
    freq.put(" Ме", 318);
    freq.put(" Ма", 294);
    freq.put(" Мо", 197);
    freq.put(" Ми", 198);
    freq.put("зу ", 144);
    freq.put("н ", 1631);
    freq.put(" чі", 23);
    freq.put("тча", 9);
    freq.put(" чу", 190);
    freq.put("тчи", 17);
    freq.put("Дім", 9);
    freq.put("Дів", 15);
    freq.put("агл", 9);
    freq.put("аги", 75);
    freq.put("аго", 131);
    freq.put("агн", 19);
    freq.put("ага", 471);
    freq.put("аге", 15);
    freq.put("г", 9480);
    freq.put("Луц", 167);
    freq.put("Луг", 14);
    freq.put(" Гл", 23);
    freq.put("Лук", 16);
    freq.put(" Го", 166);
    freq.put("Хм ", 10);
    freq.put("агу", 44);
    freq.put("агр", 49);
    freq.put("Кер", 15);
    freq.put("агі", 38);
    freq.put(" Га", 140);
    freq.put("Діт", 9);
    freq.put("Ісп", 12);
    freq.put("сь ", 1537);
    freq.put("Тіл", 37);
    freq.put("ірт", 20);
    freq.put("мп ", 20);
    freq.put(" є", 539);
    freq.put("єц ", 10);
    freq.put("иба", 46);
    freq.put(" Т ", 23);
    freq.put("ірі", 47);
    freq.put("Іст", 22);
    freq.put(" Фу", 22);
    freq.put(" Фр", 159);
    freq.put("Бер", 42);
    freq.put("фре", 10);
    freq.put(" р ", 44);
    freq.put("фра", 65);
    freq.put("фро", 11);
    freq.put("сні", 186);
    freq.put("тіс", 27);
    freq.put(" З ", 118);
    freq.put(" Щ", 222);
    freq.put(" Гі", 21);
    freq.put("Без", 42);
    freq.put(" г", 2001);
    freq.put(" Фо", 75);
    freq.put(" Фе", 42);
    freq.put(" Фа", 29);
    freq.put("узи", 107);
    freq.put("мід", 12);
    freq.put("міз", 12);
    freq.put("дел", 41);
    freq.put("міг", 39);
    freq.put("мів", 57);
    freq.put("мін", 444);
    freq.put("мім", 20);
    freq.put("мій", 80);
    freq.put(" Гр", 116);
    freq.put("міл", 198);
    freq.put("мік", 46);
    freq.put("тек", 65);
    freq.put("тел", 219);
    freq.put("тей", 59);
    freq.put("тео", 24);
    freq.put("теп", 218);
    freq.put("тем", 147);
    freq.put("тен", 87);
    freq.put("тег", 42);
    freq.put("теа", 36);
    freq.put("теб", 174);
    freq.put("теж", 112);
    freq.put("тез", 11);
    freq.put("чог", 212);
    freq.put("ань", 78);
    freq.put(" м", 5070);
    freq.put("уза", 11);
    freq.put("іп ", 19);
    freq.put("тет", 79);
    freq.put("тер", 594);
    freq.put("тес", 100);
    freq.put("тец", 35);
    freq.put("теч", 17);
    freq.put("тех", 58);
    freq.put("міх", 17);
    freq.put("міч", 54);
    freq.put("міс", 524);
    freq.put("мір", 74);
    freq.put("міт", 141);
    freq.put("мія", 27);
    freq.put("кт ", 99);
    freq.put("міщ", 30);
    freq.put("міш", 39);
    freq.put("міє", 36);
    freq.put("мії", 27);
    freq.put("ук ", 89);
    freq.put("умі", 174);
    freq.put("лту", 10);
    freq.put("уму", 53);
    freq.put(" В", 2329);
    freq.put("їж", 34);
    freq.put("іні", 208);
    freq.put("іню", 27);
    freq.put("іня", 21);
    freq.put("інь", 57);
    freq.put(" Б", 901);
    freq.put("дмі", 55);
    freq.put("інш", 100);
    freq.put("інц", 81);
    freq.put("інч", 71);
    freq.put("інф", 75);
    freq.put("інт", 126);
    freq.put("іну", 66);
    freq.put(" З", 1039);
    freq.put("іно", 189);
    freq.put("інн", 178);
    freq.put("інк", 129);
    freq.put(" Д", 1441);
    freq.put("іни", 116);
    freq.put("інд", 26);
    freq.put("іне", 77);
    freq.put("інв", 25);
    freq.put("інг", 46);
    freq.put("іна", 272);
    freq.put("дма", 11);
    freq.put("дме", 13);
    freq.put(" Л", 977);
    freq.put("дмо", 49);
    freq.put("умн", 44);
    freq.put("умо", 68);
    freq.put(" Й", 51);
    freq.put("уми", 19);
    freq.put("умк", 87);
    freq.put("їл", 31);
    freq.put("лта", 51);
    freq.put("ума", 257);
    freq.put(" П", 2006);
    freq.put(" М", 1449);
    freq.put(" п ", 106);
    freq.put("вну", 42);
    freq.put("вню", 12);
    freq.put("вня", 128);
    freq.put("вні", 171);
    freq.put("Рум", 12);
    freq.put("же ", 1118);
    freq.put("Ю ", 37);
    freq.put("ють", 878);
    freq.put("КА ", 26);
    freq.put("юто", 51);
    freq.put("ютн", 21);
    freq.put("ря ", 40);
    freq.put(" зі", 233);
    freq.put("Тан", 12);
    freq.put("Рус", 15);
    freq.put("вна", 94);
    freq.put("вне", 153);
    freq.put("вни", 359);
    freq.put("вно", 343);
    freq.put("нн ", 12);
    freq.put("йти", 93);
    freq.put("йте", 203);
    freq.put("пчи", 30);
    freq.put("озе", 45);
    freq.put("оїд", 36);
    freq.put("оїз", 34);
    freq.put("оїв", 19);
    freq.put("оїм", 63);
    freq.put("оїй", 30);
    freq.put("оїх", 72);
    freq.put("оїс", 10);
    freq.put("оїт", 20);
    freq.put("нла", 23);
    freq.put("є ", 1821);
    freq.put("йті", 25);
    freq.put("іри", 74);
    freq.put("Вго", 17);
    freq.put("юл", 13);
    freq.put("ка ", 1809);
    freq.put("йту", 10);
    freq.put("рис", 249);
    freq.put("хно", 31);
    freq.put(" Сл", 54);
    freq.put("риц", 27);
    freq.put("аба", 88);
    freq.put("абе", 54);
    freq.put(" ч ", 10);
    freq.put("аби", 82);
    freq.put("абк", 14);
    freq.put("абл", 57);
    freq.put("абм", 23);
    freq.put("або", 190);
    freq.put("Стр", 28);
    freq.put("нє", 103);
    freq.put("ні", 5532);
    freq.put("зує", 23);
    freq.put("нх", 11);
    freq.put("нф", 165);
    freq.put("нч", 149);
    freq.put("нц", 594);
    freq.put("нс", 1055);
    freq.put("нр", 24);
    freq.put("ну", 1883);
    freq.put("нт", 1188);
    freq.put("нь", 1073);
    freq.put("ня", 2645);
    freq.put("еї ", 84);
    freq.put("нщ", 30);
    freq.put("нш", 190);
    freq.put("ны", 10);
    freq.put("зую", 23);
    freq.put("не", 5062);
    freq.put("нд", 578);
    freq.put("нз", 37);
    freq.put("нж", 16);
    freq.put("нб", 22);
    freq.put("на", 8720);
    freq.put("нг", 234);
    freq.put("нв", 38);
    freq.put("нн", 2250);
    freq.put("зул", 46);
    freq.put("но", 5138);
    freq.put("ни", 4720);
    freq.put("нл", 29);
    freq.put("нк", 1232);
    freq.put("Ста", 94);
    freq.put("Сте", 15);
    freq.put("їй ", 52);
    freq.put("Сти", 13);
    freq.put("Сто", 24);
    freq.put("абр", 50);
    freq.put("абс", 35);
    freq.put("абу", 174);
    freq.put("абі", 60);
    freq.put("рпо", 12);
    freq.put("рпн", 37);
    freq.put("рпл", 27);
    freq.put("аг ", 10);
    freq.put("рпа", 115);
    freq.put("Оке", 12);
    freq.put(" Єд", 15);
    freq.put("Хме", 19);
    freq.put("рил", 144);
    freq.put("Окс", 16);
    freq.put("бал", 108);
    freq.put("рпі", 19);
    freq.put("рпр", 9);
    freq.put("хну", 23);
    freq.put(" Ту", 47);
    freq.put(" Тя", 16);
    freq.put("рим", 445);
    freq.put("сьо", 366);
    freq.put("риг", 64);
    freq.put("сьм", 18);
    freq.put(" Ті", 52);
    freq.put("ськ", 1936);
    freq.put("рив", 372);
    freq.put("риб", 76);
    freq.put("риз", 107);
    freq.put("баз", 12);
    freq.put("мпі", 130);
    freq.put("ц", 5922);
    freq.put("мпа", 83);
    freq.put("мпе", 35);
    freq.put("мпл", 25);
    freq.put("мпо", 27);
    freq.put("пря", 59);
    freq.put(" Те", 165);
    freq.put(" Та", 242);
    freq.put(" Тв", 42);
    freq.put(" То", 101);
    freq.put(" Ти", 197);
    freq.put("виш", 51);
    freq.put("йду", 58);
    freq.put("юди", 267);
    freq.put("юдн", 11);
    freq.put("юде", 97);
    freq.put("юдж", 43);
    freq.put("при", 977);
    freq.put(" зо", 149);
    freq.put("юдь", 10);
    freq.put("юдя", 25);
    freq.put("юдс", 16);
    freq.put("йдо", 14);
    freq.put("йди", 11);
    freq.put("йде", 140);
    freq.put("йда", 45);
    freq.put("аук", 37);
    freq.put("мі ", 146);
    freq.put("укі", 11);
    freq.put("неч", 24);
    freq.put("укт", 44);
    freq.put("уку", 51);
    freq.put("укр", 368);
    freq.put("укц", 19);
    freq.put("М", 1454);
    freq.put("нет", 177);
    freq.put("св", 862);
    freq.put("іпр", 63);
    freq.put("іпс", 11);
    freq.put("те ", 525);
    freq.put("іпе", 23);
    freq.put("іпа", 21);
    freq.put("єрі", 9);
    freq.put("іпо", 14);
    freq.put(" Зі", 17);
    freq.put("лра", 9);
    freq.put("уки", 37);
    freq.put("ьма", 11);
    freq.put("лрд", 12);
    freq.put("ука", 190);
    freq.put("уке", 14);
    freq.put("ьме", 20);
    freq.put("шка", 75);
    freq.put("впл", 17);
    freq.put(" пі", 1113);
    freq.put("впе", 53);
    freq.put(" пт", 13);
    freq.put(" пу", 76);
    freq.put(" пр", 3561);
    freq.put(" пс", 31);
    freq.put("ічо", 88);
    freq.put("фар", 21);
    freq.put("я", 14143);
    freq.put("фан", 47);
    freq.put("фал", 21);
    freq.put("фак", 72);
    freq.put("фай", 18);
    freq.put("ін ", 384);
    freq.put(" по", 3725);
    freq.put(" пл", 291);
    freq.put(" пи", 304);
    freq.put(" пе", 1035);
    freq.put(" па", 583);
    freq.put("впр", 30);
    freq.put("ум ", 64);
    freq.put("шви", 64);
    freq.put("Вер", 55);
    freq.put("Вес", 15);
    freq.put("ннь", 12);
    freq.put("ння", 1556);
    freq.put("нню", 26);
    freq.put("нну", 17);
    freq.put("ряч", 46);
    freq.put("рят", 120);
    freq.put("жеж", 38);
    freq.put("Юл", 27);
    freq.put("жев", 13);
    freq.put("Юн", 14);
    freq.put("жем", 22);
    freq.put("жен", 324);
    freq.put("жел", 12);
    freq.put("Ющ", 13);
    freq.put("жет", 65);
    freq.put("жер", 47);
    freq.put("жес", 13);
    freq.put("Юр", 56);
    freq.put("жеш", 18);
    freq.put("рям", 65);
    freq.put("рян", 34);
    freq.put("ряд", 120);
    freq.put("ют ", 11);
    freq.put("нно", 98);
    freq.put("нни", 194);
    freq.put("нне", 12);
    freq.put("нна", 44);
    freq.put("Вел", 45);
    freq.put("кає", 116);
    freq.put("каш", 25);
    freq.put("каю", 103);
    freq.put("кас", 116);
    freq.put("кар", 318);
    freq.put("кау", 13);
    freq.put("кат", 169);
    freq.put("ках", 110);
    freq.put("каф", 17);
    freq.put("кач", 52);
    freq.put("кац", 30);
    freq.put("ої ", 930);
    freq.put("єї", 64);
    freq.put("єє", 43);
    freq.put("єю", 125);
    freq.put("Між", 30);
    freq.put("єш", 233);
    freq.put("Мін", 52);
    freq.put("єх", 12);
    freq.put("Мій", 21);
    freq.put("інс", 72);
    freq.put("єр", 130);
    freq.put("єс", 55);
    freq.put("єп", 24);
    freq.put("єм", 410);
    freq.put("єн", 112);
    freq.put("Міс", 31);
    freq.put("єл", 17);
    freq.put("єз", 11);
    freq.put("ов", 5857);
    freq.put("єв", 261);
    freq.put("єб", 16);
    freq.put("кай", 46);
    freq.put("кал", 140);
    freq.put("как", 15);
    freq.put("кан", 261);
    freq.put("кам", 203);
    freq.put("кап", 34);
    freq.put("каб", 20);
    freq.put("кав", 277);
    freq.put("кад", 37);
    freq.put("каз", 268);
    freq.put("каж", 163);
    freq.put("гур", 55);
    freq.put("пси", 20);
    freq.put("код", 85);
    freq.put("ОН ", 25);
    freq.put("яв ", 60);
    freq.put("шся", 44);
    freq.put("псі", 11);
    freq.put("шку", 20);
    freq.put("аяв", 57);
    freq.put("гум", 18);
    freq.put("псу", 12);
    freq.put("гул", 59);
    freq.put("губ", 30);
    freq.put("гув", 19);
    freq.put("се ", 391);
    freq.put("ПУ ", 19);
    freq.put("Шах", 30);
    freq.put("Ів", 118);
    freq.put("Іг", 23);
    freq.put("Ід", 14);
    freq.put("Із", 20);
    freq.put("Іл", 14);
    freq.put("Ін", 132);
    freq.put("шкі", 47);
    freq.put("Ір", 25);
    freq.put("Іс", 41);
    freq.put("Іт", 21);
    freq.put("нем", 201);
    freq.put(" О ", 63);
    freq.put("Шан", 22);
    freq.put("кис", 11);
    freq.put("тую", 63);
    freq.put("туш", 19);
    freq.put("туц", 17);
    freq.put("тур", 271);
    freq.put("тус", 37);
    freq.put("тут", 159);
    freq.put("сли", 80);
    freq.put("сло", 139);
    freq.put("тує", 69);
    freq.put("сла", 137);
    freq.put("сле", 14);
    freq.put("еор", 35);
    freq.put("Гай", 10);
    freq.put("Гал", 49);
    freq.put("Газ", 28);
    freq.put(" Шк", 26);
    freq.put("ю", 6094);
    freq.put("еоб", 26);
    freq.put("еог", 9);
    freq.put("еод", 13);
    freq.put("Гар", 21);
    freq.put("еол", 9);
    freq.put("еон", 12);
    freq.put("сля", 189);
    freq.put("сль", 14);
    freq.put("слу", 191);
    freq.put("тун", 12);
    freq.put("туп", 211);
    freq.put("туй", 11);
    freq.put("тук", 22);
    freq.put("тул", 21);
    freq.put("туд", 114);
    freq.put("туж", 9);
    freq.put("туа", 74);
    freq.put("слі", 137);
    freq.put("тув", 247);
    freq.put("азд", 30);
    freq.put("азе", 48);
    freq.put("азв", 80);
    freq.put("аза", 224);
    freq.put("еду", 71);
    freq.put("азо", 74);
    freq.put("азм", 9);
    freq.put("азн", 28);
    freq.put("азк", 29);
    freq.put("ази", 129);
    freq.put("ІВ ", 17);
    freq.put("хає", 26);
    freq.put("хаю", 41);
    freq.put("хах", 147);
    freq.put("хат", 121);
    freq.put("хар", 53);
    freq.put("хан", 85);
    freq.put("хал", 60);
    freq.put("хай", 87);
    freq.put("хав", 39);
    freq.put("хаб", 20);
    freq.put("азі", 75);
    freq.put("ща ", 41);
    freq.put("Я ", 360);
    freq.put("азу", 161);
    freq.put("фт ", 9);
    freq.put("Ф", 589);
    freq.put("фо ", 24);
    freq.put("Що ", 77);
    freq.put("сім", 190);
    freq.put("сін", 28);
    freq.put("сіо", 20);
    freq.put("сій", 124);
    freq.put("сіл", 66);
    freq.put("сід", 62);
    freq.put("сіб", 38);
    freq.put("сів", 84);
    freq.put(" Шу", 23);
    freq.put("дре", 32);
    freq.put("дра", 101);
    freq.put("дро", 75);
    freq.put("дри", 32);
    freq.put("дрі", 84);
    freq.put("дру", 252);
    freq.put("НИ ", 13);
    freq.put("дря", 13);
    freq.put("Пре", 96);
    freq.put(" Ши", 10);
    freq.put("Пра", 54);
    freq.put(" Шо", 22);
    freq.put("сіє", 23);
    freq.put(" Шв", 23);
    freq.put("Про", 273);
    freq.put("сії", 93);
    freq.put("При", 171);
    freq.put(" Ше", 59);
    freq.put("кою", 212);
    freq.put("сію", 26);
    freq.put("сія", 108);
    freq.put("сіх", 104);
    freq.put("січ", 53);
    freq.put("сіт", 9);
    freq.put("кір", 11);
    freq.put("аєш", 141);
    freq.put("нфі", 10);
    freq.put("аєт", 410);
    freq.put("тбо", 76);
    freq.put("Зел", 10);
    freq.put("Зем", 20);
    freq.put("єд", 108);
    freq.put("до ", 809);
    freq.put("нфо", 90);
    freq.put("нфе", 44);
    freq.put("аєм", 132);
    freq.put("аєв", 12);
    freq.put("уса", 17);
    freq.put("По ", 16);
    freq.put("тюк", 11);
    freq.put("диш", 18);
    freq.put("дич", 42);
    freq.put("диц", 39);
    freq.put("дих", 31);
    freq.put("дит", 315);
    freq.put("дис", 82);
    freq.put("дир", 26);
    freq.put("Фе", 44);
    freq.put("РК ", 15);
    freq.put("дип", 18);
    freq.put("кий", 729);
    freq.put("дин", 514);
    freq.put("дим", 68);
    freq.put("дил", 90);
    freq.put("дик", 44);
    freq.put("дий", 17);
    freq.put("диз", 13);
    freq.put("дид", 38);
    freq.put("див", 338);
    freq.put("диб", 12);
    freq.put("ски", 48);
    freq.put("ско", 125);
    freq.put("пи ", 106);
    freq.put("ору", 223);
    freq.put(" Бе", 109);
    freq.put("Р", 785);
    freq.put("явн", 21);
    freq.put("явк", 10);
    freq.put("явл", 61);
    freq.put("яви", 105);
    freq.put("Фре", 13);
    freq.put("гда", 9);
    freq.put("явс", 14);
    freq.put("ису", 46);
    freq.put("циг", 11);
    freq.put("гу ", 207);
    freq.put("ая ", 23);
    freq.put(" щи", 22);
    freq.put(" що", 1596);
    freq.put(" ща", 87);
    freq.put(" ще", 378);
    freq.put("себ", 115);
    freq.put("сез", 37);
    freq.put("сел", 143);
    freq.put("сек", 73);
    freq.put("сен", 114);
    freq.put("сем", 22);
    freq.put("исн", 84);
    freq.put("ец", 422);
    freq.put("Гов", 11);
    freq.put("Гон", 11);
    freq.put("Гол", 82);
    freq.put("І ", 323);
    freq.put("Ци", 11);
    freq.put("їль", 10);
    freq.put(" Ос", 95);
    freq.put(" Ор", 36);
    freq.put(" От", 46);
    freq.put(" Ох", 11);
    freq.put(" Оф", 14);
    freq.put(" Оц", 13);
    freq.put(" Ол", 122);
    freq.put(" Ок", 34);
    freq.put(" Он", 12);
    freq.put(" Оп", 43);
    freq.put(" Об", 69);
    freq.put(" Ог", 19);
    freq.put("щу ", 13);
    freq.put("Гор", 28);
    freq.put("Гос", 13);
    freq.put("сес", 68);
    freq.put("сер", 319);
    freq.put("сеу", 27);
    freq.put("оро", 864);
    freq.put("тхн", 9);
    freq.put(" Бо", 152);
    freq.put("зят", 29);
    freq.put("ео ", 285);
    freq.put("зям", 10);
    freq.put("хва", 40);
    freq.put("зял", 17);
    freq.put("хво", 47);
    freq.put("хви", 48);
    freq.put("зяв", 18);
    freq.put("Чуд", 17);
    freq.put(" Гу", 46);
    freq.put("ту ", 571);
    freq.put("щат", 17);
    freq.put("щас", 97);
    freq.put("Яц", 12);
    freq.put("бну", 13);
    freq.put("Яр", 19);
    freq.put("Все", 77);
    freq.put("аз ", 278);
    freq.put("бні", 23);
    freq.put("Ь ", 46);
    freq.put(" № ", 51);
    freq.put("ха ", 91);
    freq.put("ЛА ", 14);
    freq.put("Вст", 10);
    freq.put("Всі", 44);
    freq.put("бни", 64);
    freq.put("Ян", 160);
    freq.put("Як", 315);
    freq.put("щад", 10);
    freq.put("бно", 83);
    freq.put("бна", 17);
    freq.put(" Ці", 61);
    freq.put("Щос", 15);
    freq.put("уац", 35);
    freq.put("фто", 17);
    freq.put(" Ць", 14);
    freq.put(" Ця", 15);
    freq.put("млю", 17);
    freq.put("мля", 27);
    freq.put("млр", 12);
    freq.put("млі", 30);
    freq.put("дця", 12);
    freq.put("млн", 47);
    freq.put("дці", 11);
    freq.put(" Це", 159);
    freq.put("Бло", 29);
    freq.put(" Ци", 11);
    freq.put("Бла", 14);
    freq.put("Щой", 11);
    freq.put(" Дж", 54);
    freq.put("Щод", 11);
    freq.put("Щоб", 16);
    freq.put("нці", 329);
    freq.put("нцу", 19);
    freq.put("їба", 11);
    freq.put("сі ", 370);
    freq.put("фії", 18);
    freq.put("нцю", 21);
    freq.put("нця", 91);
    freq.put("Сам", 21);
    freq.put("з", 14149);
    freq.put("др ", 28);
    freq.put("иви", 260);
    freq.put(" ві", 2265);
    freq.put("нце", 96);
    freq.put("нци", 21);
    freq.put("івд", 17);
    freq.put("нех", 20);
    freq.put("уу ", 20);
    freq.put("уал", 57);
    freq.put("дох", 21);
    freq.put("доч", 30);
    freq.put("дос", 154);
    freq.put("дор", 240);
    freq.put("дот", 27);
    freq.put("дою", 18);
    freq.put("дощ", 53);
    freq.put("дод", 117);
    freq.put("доз", 57);
    freq.put("дож", 17);
    freq.put("доб", 406);
    freq.put("дог", 46);
    freq.put("дов", 432);
    freq.put("дон", 96);
    freq.put("дом", 302);
    freq.put("доп", 140);
    freq.put("дол", 99);
    freq.put("док", 114);
    freq.put("ає ", 771);
    freq.put("влю", 92);
    freq.put("вля", 166);
    freq.put("Пок", 26);
    freq.put("Пол", 136);
    freq.put("влі", 62);
    freq.put("Поп", 16);
    freq.put("Пом", 22);
    freq.put("Пон", 13);
    freq.put("Пов", 26);
    freq.put("Пог", 76);
    freq.put("Поб", 11);
    freq.put("Поз", 14);
    freq.put("Под", 60);
    freq.put("ідк", 282);
    freq.put("Кур", 17);
    freq.put("ідо", 182);
    freq.put("іум", 12);
    freq.put("юрм", 10);
    freq.put("юри", 10);
    freq.put("ди ", 764);
    freq.put("Куб", 26);
    freq.put("Куп", 10);
    freq.put("Кул", 10);
    freq.put("Пош", 10);
    freq.put("Пот", 29);
    freq.put("Пор", 30);
    freq.put("Пос", 39);
    freq.put("чці", 21);
    freq.put("Поч", 18);
    freq.put("вле", 88);
    freq.put("вла", 177);
    freq.put("вло", 9);
    freq.put("вли", 9);
    freq.put("Тел", 13);
    freq.put("Теп", 25);
    freq.put("Тем", 9);
    freq.put("Іго", 19);
    freq.put("ичо", 10);
    freq.put("уві", 17);
    freq.put("дкі", 31);
    freq.put("Ш", 270);
    freq.put("іс ", 67);
    freq.put("дкр", 149);
    freq.put("дку", 56);
    freq.put("ичн", 301);
    freq.put("дка", 58);
    freq.put("ува", 1442);
    freq.put("дки", 56);
    freq.put("дкл", 25);
    freq.put("уво", 9);
    freq.put("дко", 86);
    freq.put("цві", 15);
    freq.put("Тер", 71);
    freq.put("рт", 998);
    freq.put("ру", 1596);
    freq.put("рр", 46);
    freq.put("рс", 466);
    freq.put("рц", 94);
    freq.put("рч", 112);
    freq.put("рф", 23);
    freq.put("рх", 96);
    freq.put("рш", 410);
    freq.put("рщ", 31);
    freq.put("рю", 131);
    freq.put("ря", 481);
    freq.put("рь", 62);
    freq.put("рі", 2706);
    freq.put("рє", 27);
    freq.put("пу ", 76);
    freq.put("Аха", 12);
    freq.put("ічн", 315);
    freq.put("шу ", 110);
    freq.put("ічи", 13);
    freq.put("ічк", 44);
    freq.put("ичч", 26);
    freq.put("іче", 34);
    freq.put("іча", 48);
    freq.put("філ", 136);
    freq.put("ічч", 25);
    freq.put("ичу", 17);
    freq.put("ічі", 38);
    freq.put("рв", 243);
    freq.put("рг", 339);
    freq.put("ра", 6800);
    freq.put("рб", 103);
    freq.put("рж", 184);
    freq.put("рз", 40);
    freq.put("рд", 308);
    freq.put("ре", 3798);
    freq.put("рк", 502);
    freq.put("рл", 123);
    freq.put("ри", 3590);
    freq.put("рй", 28);
    freq.put("ро", 7255);
    freq.put("рп", 240);
    freq.put("рм", 403);
    freq.put("рн", 1328);
    freq.put(" Ша", 65);
    freq.put("пня", 49);
    freq.put("пні", 22);
    freq.put("жіт", 27);
    freq.put("жно", 114);
    freq.put("ощо", 9);
    freq.put("жни", 58);
    freq.put("оща", 34);
    freq.put("жне", 14);
    freq.put("жна", 261);
    freq.put("още", 12);
    freq.put("Дми", 14);
    freq.put("ідс", 119);
    freq.put("ідр", 89);
    freq.put("жні", 77);
    freq.put("ощі", 33);
    freq.put("іду", 79);
    freq.put("жню", 21);
    freq.put("жня", 46);
    freq.put("жнь", 15);
    freq.put("ві ", 693);
    freq.put("ощь", 56);
    freq.put("ощу", 15);
    freq.put("жін", 103);
    freq.put("ідч", 94);
    freq.put("жів", 11);
    freq.put("пни", 44);
    freq.put("пно", 34);
    freq.put("Від", 197);
    freq.put("Віл", 19);
    freq.put("Вік", 54);
    freq.put("Вій", 11);
    freq.put("Він", 70);
    freq.put("ее ", 13);
    freq.put("діт", 120);
    freq.put("ьц", 24);
    freq.put("ем ", 230);
    freq.put("ьф", 21);
    freq.put(" Хт", 74);
    freq.put("ьт", 196);
    freq.put("ЗА ", 15);
    freq.put("Ну ", 69);
    freq.put("Віт", 83);
    freq.put("Віс", 9);
    freq.put("Вір", 14);
    freq.put("гий", 32);
    freq.put("ьь", 9);
    freq.put("спе", 164);
    freq.put("спа", 164);
    freq.put("еяк", 41);
    freq.put("спл", 42);
    freq.put(" яр", 15);
    freq.put("спи", 102);
    freq.put("ай ", 278);
    freq.put("тят", 39);
    freq.put("ьщ", 41);
    freq.put("тяч", 38);
    freq.put("екц", 42);
    freq.put("екр", 84);
    freq.put("екс", 249);
    freq.put("ект", 284);
    freq.put("еку", 32);
    freq.put("екі", 30);
    freq.put("ВА ", 18);
    freq.put("еко", 176);
    freq.put("еки", 43);
    freq.put("екл", 76);
    freq.put("екз", 21);
    freq.put("ека", 165);
    freq.put("екв", 18);
    freq.put("спі", 260);
    freq.put("тяк", 12);
    freq.put("тям", 41);
    freq.put("тян", 21);
    freq.put("тяг", 82);
    freq.put("тяж", 14);
    freq.put(" ян", 77);
    freq.put(" як", 1576);
    freq.put(" яй", 12);
    freq.put(" яз", 119);
    freq.put(" яв", 64);
    freq.put("мку", 55);
    freq.put(" яб", 9);
    freq.put("алт", 18);
    freq.put("алу", 104);
    freq.put("иїж", 9);
    freq.put("иїд", 12);
    freq.put("иїв", 161);
    freq.put("аля", 44);
    freq.put("аль", 895);
    freq.put("алі", 620);
    freq.put("Ор", 36);
    freq.put("Ос", 97);
    freq.put("От", 46);
    freq.put("Оф", 14);
    freq.put("Ох", 11);
    freq.put("Оц", 13);
    freq.put("п", 17871);
    freq.put("Ок", 34);
    freq.put("Ол", 129);
    freq.put("Он", 14);
    freq.put("Оп", 43);
    freq.put("Об", 69);
    freq.put("Ог", 19);
    freq.put("Од", 94);
    freq.put("ала", 725);
    freq.put("Сев", 9);
    freq.put("але", 664);
    freq.put("алк", 52);
    freq.put("алл", 13);
    freq.put("али", 908);
    freq.put("иїх", 18);
    freq.put("ало", 352);
    freq.put("ьб", 70);
    freq.put("ьп", 12);
    freq.put("Муз", 16);
    freq.put("ьво", 138);
    freq.put("ьві", 233);
    freq.put("ол ", 105);
    freq.put("Ї ", 17);
    freq.put("ойш", 37);
    freq.put("фф", 19);
    freq.put("фт", 43);
    freq.put("фу", 124);
    freq.put("фр", 103);
    freq.put("фс", 11);
    freq.put("між", 86);
    freq.put("Е", 176);
    freq.put("фі", 590);
    freq.put("пів", 206);
    freq.put("Щас", 15);
    freq.put("шли", 80);
    freq.put("фо", 588);
    freq.put("ойо", 15);
    freq.put("фл", 36);
    freq.put("фи", 21);
    freq.put("ойн", 34);
    freq.put("віт", 927);
    freq.put("гік", 9);
    freq.put("фе", 253);
    freq.put("нт ", 170);
    freq.put("фа", 237);
    freq.put("шла", 83);
    freq.put("гів", 68);
    freq.put("егр", 24);
    freq.put("іск", 19);
    freq.put("ісл", 181);
    freq.put("іси", 19);
    freq.put("ісо", 21);
    freq.put("єст", 41);
    freq.put("існ", 164);
    freq.put("Укр", 903);
    freq.put("ісе", 18);
    freq.put("іся", 83);
    freq.put("ісь", 110);
    freq.put("іст", 1015);
    freq.put("ісу", 17);
    freq.put("ісц", 130);
    freq.put("ув ", 227);
    freq.put("тін", 62);
    freq.put("я ", 8132);
    freq.put("ісі", 61);
    freq.put("йк ", 14);
    freq.put("пул", 22);
    freq.put("пун", 21);
    freq.put(" із", 188);
    freq.put("пуб", 38);
    freq.put("пув", 10);
    freq.put("йці", 23);
    freq.put("иша", 42);
    freq.put("її ", 84);
    freq.put("ише", 132);
    freq.put("ишк", 22);
    freq.put("иши", 116);
    freq.put("ишн", 38);
    freq.put("шув", 16);
    freq.put("шук", 78);
    freq.put("іч ", 118);
    freq.put("л", 23127);
    freq.put("шує", 36);
    freq.put(" Од", 93);
    freq.put("шут", 31);
    freq.put("юці", 9);
    freq.put("БК ", 10);
    freq.put("РО ", 21);
    freq.put("шую", 18);
    freq.put("ишу", 47);
    freq.put("р ", 1396);
    freq.put("всь", 563);
    freq.put("Усі", 9);
    freq.put("йце", 9);
    freq.put("иші", 19);
    freq.put("пус", 178);
    freq.put("пут", 138);
    freq.put("пух", 11);
    freq.put(" Ба", 161);
    freq.put("Фак", 11);
    freq.put("ул", 1118);
    freq.put("ук", 1059);
    freq.put("уй", 158);
    freq.put("уп", 633);
    freq.put("ун", 367);
    freq.put("ум", 853);
    freq.put("уг", 271);
    freq.put("ув", 1753);
    freq.put("уб", 325);
    freq.put("уа", 123);
    freq.put("уз", 298);
    freq.put("уж", 475);
    freq.put("уе", 13);
    freq.put("уд", 1465);
    freq.put("ущ", 18);
    freq.put("уш", 208);
    freq.put("уя", 35);
    freq.put("ую", 563);
    freq.put("уу", 68);
    freq.put("ут", 1614);
    freq.put("ус", 867);
    freq.put("ур", 1016);
    freq.put("уч", 393);
    freq.put("уц", 237);
    freq.put("ух", 317);
    freq.put("уф", 24);
    freq.put("уї", 23);
    freq.put("ує", 577);
    freq.put("бе ", 286);
    freq.put("Шве", 19);
    freq.put("жі ", 88);
    freq.put("Ві ", 9);
    freq.put("Б", 919);
    freq.put("тст", 10);
    freq.put("тсь", 102);
    freq.put("ему", 44);
    freq.put("емі", 75);
    freq.put("емл", 58);
    freq.put("еми", 75);
    freq.put("емо", 299);
    freq.put("емп", 97);
    freq.put("емн", 63);
    freq.put("ема", 210);
    freq.put("еме", 53);
    freq.put("тса", 10);
    freq.put("айк", 112);
    freq.put("айл", 40);
    freq.put("айм", 55);
    freq.put("айн", 179);
    freq.put("айо", 155);
    freq.put("айп", 30);
    freq.put("айб", 117);
    freq.put("айв", 44);
    freq.put("айд", 115);
    freq.put("айж", 99);
    freq.put("ея ", 21);
    freq.put("сп ", 9);
    freq.put("ек ", 16);
    freq.put("Піс", 48);
    freq.put("упа", 71);
    freq.put(" я ", 1205);
    freq.put("айш", 78);
    freq.put("тя ", 331);
    freq.put("айс", 74);
    freq.put("айт", 209);
    freq.put("айф", 21);
    freq.put("айц", 9);
    freq.put("айч", 11);
    freq.put("Жін", 12);
    freq.put("бюд", 32);
    freq.put("вую", 39);
    freq.put("ВО ", 14);
    freq.put("ал ", 194);
    freq.put("тіш", 56);
    freq.put("тія", 26);
    freq.put("тію", 16);
    freq.put("рир", 20);
    freq.put("О ", 458);
    freq.put("олт", 52);
    freq.put("олу", 77);
    freq.put("оль", 208);
    freq.put("олю", 70);
    freq.put("оля", 110);
    freq.put("олє", 10);
    freq.put("олі", 432);
    freq.put("дто", 21);
    freq.put("дтв", 30);
    freq.put(" Бл", 65);
    freq.put("дтр", 74);
    freq.put("ола", 183);
    freq.put("олг", 19);
    freq.put("олд", 9);
    freq.put("оле", 193);
    freq.put("оли", 820);
    freq.put("олк", 33);
    freq.put("олл", 27);
    freq.put("оло", 1094);
    freq.put("нті", 82);
    freq.put("нтр", 141);
    freq.put("нтс", 39);
    freq.put("нту", 111);
    freq.put("гні", 17);
    freq.put("нтн", 19);
    freq.put("нто", 43);
    freq.put("нти", 156);
    freq.put("нте", 179);
    freq.put("ой ", 120);
    freq.put("нта", 235);
    freq.put("ф ", 53);
    freq.put("опц", 37);
    freq.put("опч", 29);
    freq.put("опр", 83);
    freq.put("опт", 30);
    freq.put("опу", 70);
    freq.put("№", 52);
    freq.put("опі", 84);
    freq.put(" Ющ", 13);
    freq.put("Хай", 12);
    freq.put(" Юр", 56);
    freq.put("лаг", 31);
    freq.put("дво", 98);
    freq.put(" Юл", 27);
    freq.put(" Юн", 14);
    freq.put("лай", 66);
    freq.put("лак", 30);
    freq.put("Хар", 76);
    freq.put("лам", 132);
    freq.put("лан", 192);
    freq.put("опн", 9);
    freq.put("опо", 392);
    freq.put("опи", 104);
    freq.put("опк", 12);
    freq.put("опл", 58);
    freq.put("опе", 163);
    freq.put("ину", 331);
    freq.put("опа", 124);
    freq.put("тле", 20);
    freq.put("тла", 16);
    freq.put("ца ", 21);
    freq.put("лас", 702);
    freq.put("аер", 22);
    freq.put("тло", 46);
    freq.put("тли", 17);
    freq.put("лат", 162);
    freq.put("лац", 13);
    freq.put("нюю", 29);
    freq.put("Лес", 10);
    freq.put("ьфі", 11);
    freq.put("нює", 18);
    freq.put("у", 23494);
    freq.put("іте", 156);
    freq.put("Ру", 56);
    freq.put("Лео", 12);
    freq.put("нюк", 33);
    freq.put("уд ", 52);
    freq.put("нюв", 32);
    freq.put("Лев", 13);
    freq.put(" ма", 998);
    freq.put("ужі", 9);
    freq.put("льф", 15);
    freq.put("льц", 23);
    freq.put("льч", 21);
    freq.put("льс", 157);
    freq.put("льт", 166);
    freq.put("лья", 39);
    freq.put("льш", 296);
    freq.put("льщ", 41);
    freq.put("джу", 130);
    freq.put("льд", 12);
    freq.put("іби", 23);
    freq.put("льз", 13);
    freq.put("ужк", 14);
    freq.put("льб", 34);
    freq.put("льв", 50);
    freq.put("льг", 27);
    freq.put("льм", 117);
    freq.put("льн", 1149);
    freq.put("льо", 117);
    freq.put("льп", 12);
    freq.put("льй", 80);
    freq.put("льк", 452);
    freq.put("Час", 33);
    freq.put("Цьо", 14);
    freq.put("Й", 51);
    freq.put("По", 563);
    freq.put("Пл", 34);
    freq.put("До ", 78);
    freq.put("Пи", 27);
    freq.put("Пе", 178);
    freq.put("Па", 185);
    freq.put("ийс", 50);
    freq.put("ийт", 20);
    freq.put("ийш", 100);
    freq.put("оя ", 79);
    freq.put("ийд", 35);
    freq.put("Пі", 190);
    freq.put("ийм", 30);
    freq.put("ийн", 38);
    freq.put("Пш", 9);
    freq.put("пці", 54);
    freq.put("Пу", 27);
    freq.put("Пр", 606);
    freq.put("итн", 44);
    freq.put(" мр", 40);
    freq.put("осе", 45);
    freq.put("Ті", 53);
    freq.put("ите", 131);
    freq.put("Дин", 43);
    freq.put("Див", 34);
    freq.put("єпр", 14);
    freq.put("Дис", 12);
    freq.put("Дир", 10);
    freq.put("осн", 46);
    freq.put(" б ", 174);
    freq.put("иют", 23);
    freq.put("йст", 33);
    freq.put("раї", 1246);
    freq.put("рає", 65);
    freq.put("ТВі", 11);
    freq.put("щос", 134);
    freq.put("рау", 12);
    freq.put("рат", 402);
    freq.put("рас", 161);
    freq.put("рар", 14);
    freq.put("рач", 22);
    freq.put("рац", 258);
    freq.put("рах", 151);
    freq.put("раф", 117);
    freq.put("ращ", 227);
    freq.put("раш", 74);
    freq.put("раю", 64);
    freq.put("хн", 143);
    freq.put("хм", 64);
    freq.put("Л ", 34);
    freq.put("хи", 219);
    freq.put("хл", 110);
    freq.put("хе", 61);
    freq.put("хз", 9);
    freq.put("ха", 818);
    freq.put("хв", 149);
    freq.put("хх", 28);
    freq.put("хр", 61);
    freq.put("ху", 236);
    freq.put("хт", 304);
    freq.put("хє", 10);
    freq.put("хі", 326);
    freq.put("раг", 33);
    freq.put("рав", 780);
    freq.put("раб", 41);
    freq.put("блр", 9);
    freq.put("раз", 487);
    freq.put("раж", 87);
    freq.put("рад", 421);
    freq.put("рал", 179);
    freq.put("рак", 96);
    freq.put("рай", 116);
    freq.put("раи", 16);
    freq.put("рап", 68);
    freq.put("ран", 624);
    freq.put("рам", 209);
    freq.put("рок", 524);
    freq.put("іє ", 36);
    freq.put("сут", 33);
    freq.put("сус", 46);
    freq.put("сур", 19);
    freq.put("суч", 25);
    freq.put("сую", 17);
    freq.put("сує", 24);
    freq.put("нш ", 10);
    freq.put("ежі", 40);
    freq.put("ежу", 20);
    freq.put("ежи", 84);
    freq.put("ежн", 61);
    freq.put("ежа", 45);
    freq.put("еже", 25);
    freq.put("ан ", 232);
    freq.put("сув", 118);
    freq.put("суб", 40);
    freq.put("суа", 14);
    freq.put("суд", 145);
    freq.put("сул", 17);
    freq.put("сук", 13);
    freq.put("суп", 46);
    freq.put("сун", 27);
    freq.put("сум", 103);
    freq.put("апт", 16);
    freq.put("апу", 30);
    freq.put("апр", 118);
    freq.put("апі", 41);
    freq.put("Яп", 15);
    freq.put("ьм ", 60);
    freq.put("ІК ", 9);
    freq.put("оєп", 10);
    freq.put("нє ", 66);
    freq.put("йли", 9);
    freq.put("йло", 17);
    freq.put("щал", 10);
    freq.put("апо", 102);
    freq.put("апл", 46);
    freq.put("апи", 198);
    freq.put("цян", 15);
    freq.put("апе", 95);
    freq.put("апа", 87);
    freq.put("рин", 168);
    freq.put("тна", 36);
    freq.put("тне", 22);
    freq.put("тни", 177);
    freq.put("тно", 105);
    freq.put("цял", 9);
    freq.put("зач", 37);
    freq.put("ашн", 67);
    freq.put("Збі", 32);
    freq.put("БУ ", 13);
    freq.put("тні", 151);
    freq.put("тнє", 16);
    freq.put("оп ", 24);
    freq.put("тну", 21);
    freq.put("тню", 10);
    freq.put("тня", 115);
    freq.put("тнь", 31);
    freq.put("цан", 16);
    freq.put("уді", 79);
    freq.put("ить", 593);
    freq.put("дді", 44);
    freq.put("ддя", 10);
    freq.put("уду", 201);
    freq.put("удь", 114);
    freq.put("удд", 25);
    freq.put("уде", 478);
    freq.put("удж", 12);
    freq.put("уда", 44);
    freq.put("ню ", 120);
    freq.put("удн", 76);
    freq.put("удо", 150);
    freq.put("дда", 29);
    freq.put("уди", 181);
    freq.put("цар", 10);
    freq.put("цях", 41);
    freq.put("итр", 50);
    freq.put("иту", 132);
    freq.put("цят", 14);
    freq.put("Із ", 11);
    freq.put("іха", 14);
    freq.put("іхи", 10);
    freq.put("ЕС ", 19);
    freq.put("Ж ", 10);
    freq.put("шев", 28);
    freq.put("ль ", 270);
    freq.put("іху", 14);
    freq.put("і", 39307);
    freq.put("вщи", 123);
    freq.put("шей", 23);
    freq.put("чьо", 13);
    freq.put("зин", 49);
    freq.put("оян", 9);
    freq.put("ояв", 14);
    freq.put("Дод", 18);
    freq.put("Доб", 59);
    freq.put("Дов", 18);
    freq.put("Дон", 75);
    freq.put("Дом", 11);
    freq.put("Доп", 13);
    freq.put("єнн", 22);
    freq.put("Дол", 12);
    freq.put("Док", 9);
    freq.put("єнт", 36);
    freq.put("Дос", 9);
    freq.put("Дор", 16);
    freq.put("ий ", 2622);
    freq.put("Вла", 48);
    freq.put("єні", 11);
    freq.put("ояс", 29);
    freq.put("оят", 19);
    freq.put("мію", 71);
    freq.put("ию ", 9);
    freq.put("Мер", 23);
    freq.put("Мет", 37);
    freq.put("мле", 43);
    freq.put("ці", 2621);
    freq.put("грі", 36);
    freq.put("Мед", 26);
    freq.put("Мел", 11);
    freq.put("Мен", 182);
    freq.put("цт", 74);
    freq.put("сни", 248);
    freq.put("сно", 261);
    freq.put("сна", 54);
    freq.put("сне", 50);
    freq.put("Брю", 12);
    freq.put("Ла", 42);
    freq.put("вці", 175);
    freq.put("Ле", 62);
    freq.put("ць", 759);
    freq.put("Ли", 36);
    freq.put("Ло", 41);
    freq.put("ця", 425);
    freq.put("вця", 41);
    freq.put("Лі", 81);
    freq.put("Лу", 213);
    freq.put("Ля", 16);
    freq.put("Лю", 96);
    freq.put("Ль", 334);
    freq.put("Бри", 14);
    freq.put("Бро", 12);
    freq.put("пан", 138);
    freq.put("Бра", 21);
    freq.put("Йог", 14);
    freq.put("ра ", 803);
    freq.put("сня", 70);
    freq.put("сню", 46);
    freq.put("сну", 97);
    freq.put("анц", 168);
    freq.put("анч", 40);
    freq.put("анр", 9);
    freq.put("анс", 248);
    freq.put("ант", 205);
    freq.put("ану", 146);
    freq.put("Слу", 15);
    freq.put("аню", 13);
    freq.put("аня", 41);
    freq.put("анш", 9);
    freq.put("анщ", 9);
    freq.put("ані", 501);
    freq.put("кен", 11);
    freq.put("ятк", 76);
    freq.put("еж ", 114);
    freq.put("су ", 169);
    freq.put("анд", 261);
    freq.put("ане", 121);
    freq.put("ана", 304);
    freq.put("Сло", 17);
    freq.put("анг", 54);
    freq.put("анн", 926);
    freq.put("ано", 517);
    freq.put("Сла", 12);
    freq.put("ани", 222);
    freq.put("анк", 351);
    freq.put("сб", 15);
    freq.put("са", 936);
    freq.put("ьми", 44);
    freq.put("се", 1359);
    freq.put("си", 877);
    freq.put("сл", 907);
    freq.put("ск", 923);
    freq.put("сн", 1016);
    freq.put("см", 247);
    freq.put("сп", 1417);
    freq.put("со", 995);
    freq.put("сс", 65);
    freq.put("ср", 34);
    freq.put("су", 888);
    freq.put("ст", 5773);
    freq.put("сх", 82);
    freq.put("сф", 53);
    freq.put("сц", 170);
    freq.put("ьму", 23);
    freq.put("сь", 3901);
    freq.put("ся", 2596);
    freq.put("сю", 73);
    freq.put("сі", 1433);
    freq.put("ьмі", 15);
    freq.put("Аза", 81);
    freq.put("Спі", 17);
    freq.put("аСт", 13);
    freq.put("Спр", 20);
    freq.put("ВК ", 48);
    freq.put("ьо ", 51);
    freq.put("едв", 16);
    freq.put("еда", 99);
    freq.put("едб", 16);
    freq.put("едж", 26);
    freq.put("еде", 94);
    freq.put("едл", 17);
    freq.put("еди", 133);
    freq.put("едо", 61);
    freq.put("едм", 14);
    freq.put("едн", 46);
    freq.put("ца", 57);
    freq.put("едр", 19);
    freq.put("едс", 60);
    freq.put("едь", 10);
    freq.put("еді", 149);
    freq.put("Спе", 12);
    freq.put("Спа", 12);
    freq.put("Спо", 32);
    freq.put("ци", 184);
    freq.put("гі", 577);
    freq.put("гш", 12);
    freq.put("цо", 22);
    freq.put("гу", 444);
    freq.put("гт", 43);
    freq.put("гр", 1041);
    freq.put("Аль", 20);
    freq.put("Еко", 14);
    freq.put("Фра", 133);
    freq.put("Не ", 119);
    freq.put("Екс", 51);
    freq.put("Ост", 24);
    freq.put(" а ", 768);
    freq.put("Але", 87);
    freq.put("Ось", 40);
    freq.put("гл", 394);
    freq.put("гк", 25);
    freq.put("ги", 327);
    freq.put("го", 4300);
    freq.put("гн", 175);
    freq.put("гг", 18);
    freq.put("гв", 11);
    freq.put("га", 1466);
    freq.put("ге", 235);
    freq.put("гд", 15);
    freq.put("он ", 238);
    freq.put("фія", 15);
    freq.put("фіч", 10);
    freq.put("фіц", 52);
    freq.put("фіс", 22);
    freq.put("фір", 35);
    freq.put("огі", 121);
    freq.put("огр", 232);
    freq.put("огт", 16);
    freq.put("огу", 88);
    freq.put("ьон", 19);
    freq.put("іва", 148);
    freq.put("івз", 9);
    freq.put("іве", 111);
    freq.put("ьом", 126);
    freq.put("івл", 28);
    freq.put("івк", 68);
    freq.put("іви", 10);
    freq.put("івп", 18);
    freq.put("іво", 11);
    freq.put("івн", 248);
    freq.put("івм", 9);
    freq.put(" вх", 18);
    freq.put(" вч", 129);
    freq.put(" вс", 853);
    freq.put(" вр", 103);
    freq.put(" ву", 102);
    freq.put(" вт", 86);
    freq.put(" ве", 468);
    freq.put(" вд", 94);
    freq.put(" вз", 159);
    freq.put(" вж", 365);
    freq.put(" вб", 76);
    freq.put(" ва", 463);
    freq.put(" вв", 89);
    freq.put(" вн", 77);
    freq.put(" вм", 63);
    freq.put(" вп", 127);
    freq.put(" во", 557);
    freq.put(" ви", 1943);
    freq.put(" вл", 181);
    freq.put(" вк", 76);
    freq.put("іву", 13);
    freq.put("івт", 34);
    freq.put("нь ", 679);
    freq.put("івр", 19);
    freq.put("івч", 142);
    freq.put("івц", 143);
    freq.put("івщ", 93);
    freq.put("оги", 105);
    freq.put("огл", 149);
    freq.put("огн", 35);
    freq.put("ого", 2837);
    freq.put("ога", 175);
    freq.put("оге", 9);
    freq.put("фін", 97);
    freq.put("М ", 73);
    freq.put("фік", 60);
    freq.put("фіз", 34);
    freq.put("фіг", 72);
    freq.put("піт", 48);
    freq.put("пір", 33);
    freq.put("піс", 231);
    freq.put("піц", 9);
    freq.put("піч", 21);
    freq.put("піх", 28);
    freq.put("піш", 77);
    freq.put("зд ", 19);
    freq.put("Яка", 24);
    freq.put("Якб", 12);
    freq.put("Яко", 13);
    freq.put("Яки", 27);
    freq.put("рр ", 9);
    freq.put("яю ", 24);
    freq.put("утн", 75);
    freq.put("лю ", 244);
    freq.put("изи", 36);
    freq.put("Якщ", 63);
    freq.put("Які", 17);
    freq.put("піа", 31);
    freq.put("піз", 49);
    freq.put("під", 656);
    freq.put("пік", 30);
    freq.put("піл", 155);
    freq.put("пій", 42);
    freq.put("піо", 75);
    freq.put("пін", 27);
    freq.put("яна", 34);
    freq.put("яне", 17);
    freq.put("янк", 37);
    freq.put("яни", 102);
    freq.put("яно", 35);
    freq.put("янн", 15);
    freq.put("да ", 513);
    freq.put("рте", 42);
    freq.put("д", 21886);
    freq.put("ртв", 28);
    freq.put("ртн", 43);
    freq.put("рто", 99);
    freq.put("рти", 136);
    freq.put("ртк", 38);
    freq.put("ртф", 12);
    freq.put("ртс", 9);
    freq.put("рту", 114);
    freq.put("рть", 26);
    freq.put("рті", 138);
    freq.put("яшк", 20);
    freq.put("ил ", 21);
    freq.put("т ", 1637);
    freq.put("яні", 29);
    freq.put("яну", 37);
    freq.put("янс", 59);
    freq.put("янц", 10);
    freq.put("кше", 13);
    freq.put("оу ", 25);
    freq.put("кшо", 14);
    freq.put("іям", 20);
    freq.put("іян", 21);
    freq.put("ир ", 56);
    freq.put("іяк", 49);
    freq.put("іял", 36);
    freq.put("ині", 332);
    freq.put("инь", 62);
    freq.put("лаб", 29);
    freq.put("лав", 138);
    freq.put("иня", 47);
    freq.put("лад", 359);
    freq.put("лаз", 19);
    freq.put("два", 76);
    freq.put("инц", 41);
    freq.put("лал", 39);
    freq.put("две", 34);
    freq.put("инс", 116);
    freq.put("инт", 18);
    freq.put("лап", 18);
    freq.put("лар", 52);
    freq.put("инн", 91);
    freq.put("ино", 194);
    freq.put("ини", 537);
    freq.put("лах", 25);
    freq.put("инк", 155);
    freq.put("лач", 29);
    freq.put("лаш", 45);
    freq.put("ине", 61);
    freq.put("ина", 497);
    freq.put("инг", 78);
    freq.put("лає", 12);
    freq.put("лаї", 18);
    freq.put("уни", 19);
    freq.put("дві", 80);
    freq.put("іях", 14);
    freq.put("іят", 12);
    freq.put("осв", 74);
    freq.put("оса", 38);
    freq.put("ито", 190);
    freq.put("ити", 1076);
    freq.put("итл", 23);
    freq.put("итк", 71);
    freq.put("оск", 76);
    freq.put("осл", 134);
    freq.put("оси", 195);
    freq.put("осо", 159);
    freq.put("осп", 92);
    freq.put("осм", 27);
    freq.put("итв", 33);
    freq.put("пет", 41);
    freq.put("пес", 13);
    freq.put("пер", 1386);
    freq.put("печ", 75);
    freq.put("пец", 62);
    freq.put("Уда", 11);
    freq.put("Нік", 20);
    freq.put("Нім", 32);
    freq.put("ТА ", 14);
    freq.put("Ніч", 20);
    freq.put("пел", 26);
    freq.put("пек", 99);
    freq.put("пей", 32);
    freq.put("осі", 247);
    freq.put("пен", 70);
    freq.put("пев", 87);
    freq.put("иті", 32);
    freq.put("пед", 49);
    freq.put("ост", 1074);
    freq.put("осу", 101);
    freq.put("итя", 50);
    freq.put("осс", 20);
    freq.put("рв ", 30);
    freq.put("осф", 9);
    freq.put("итс", 9);
    freq.put("ося", 197);
    freq.put("ось", 533);
    freq.put("итт", 193);
    freq.put("Жур", 18);
    freq.put("рді", 28);
    freq.put("ча ", 182);
    freq.put("аже", 109);
    freq.put("ажд", 24);
    freq.put("Каб", 37);
    freq.put("ажк", 44);
    freq.put("рдо", 56);
    freq.put("рдн", 12);
    freq.put("рди", 53);
    freq.put("рдж", 31);
    freq.put("рде", 35);
    freq.put("рда", 20);
    freq.put("НА ", 40);
    freq.put("ед ", 137);
    freq.put("Сьо", 123);
    freq.put("а", 59091);
    freq.put("ьок", 9);
    freq.put("ьод", 22);
    freq.put("ьоз", 19);
    freq.put("ьог", 642);
    freq.put("ьов", 52);
    freq.put("ьою", 11);
    freq.put("ьох", 43);
    freq.put("ьор", 24);
    freq.put("ьот", 16);
    freq.put("ьої", 35);
    freq.put("Оди", 22);
    freq.put("Одн", 25);
    freq.put("Оде", 44);
    freq.put("оні", 305);
    freq.put("онц", 114);
    freq.put("онч", 19);
    freq.put("онф", 50);
    freq.put("онт", 136);
    freq.put("ону", 189);
    freq.put("онс", 112);
    freq.put("оню", 11);
    freq.put("оня", 52);
    freq.put("онь", 27);
    freq.put("Нех", 11);
    freq.put("Нес", 11);
    freq.put("зра", 68);
    freq.put("єєє", 22);
    freq.put(" ау", 18);
    freq.put(" ат", 29);
    freq.put(" ас", 45);
    freq.put(" ар", 57);
    freq.put(" ах", 75);
    freq.put(" аф", 17);
    freq.put(" аг", 52);
    freq.put(" ав", 215);
    freq.put(" аб", 149);
    freq.put(" аа", 24);
    freq.put(" аж", 34);
    freq.put(" ае", 22);
    freq.put(" ад", 65);
    freq.put(" ал", 466);
    freq.put(" ак", 153);
    freq.put(" ай", 23);
    freq.put(" ап", 29);
    freq.put(" ан", 115);
    freq.put("ор ", 205);
    freq.put("Нед", 13);
    freq.put("Нез", 20);
    freq.put("Нев", 16);
    freq.put("Нен", 11);
    freq.put("Нем", 14);
    freq.put("Неп", 14);
    freq.put(" ам", 37);
    freq.put("онд", 65);
    freq.put("оне", 191);
    freq.put("онг", 9);
    freq.put("она", 528);
    freq.put("онб", 15);
    freq.put("оно", 232);
    freq.put("онн", 120);
    freq.put("онк", 93);
    freq.put("онл", 16);
    freq.put("они", 290);
    freq.put("г ", 362);
    freq.put("Мі", 201);
    freq.put("І", 621);
    freq.put("бкі", 13);
    freq.put("Зна", 26);
    freq.put("ьці", 12);
    freq.put("цуз", 19);
    freq.put("ньк", 139);
    freq.put("цук", 18);
    freq.put("ньо", 198);
    freq.put(" в ", 2445);
    freq.put("рот", 291);
    freq.put("Ма", 295);
    freq.put("Мо", 198);
    freq.put("Ми", 198);
    freq.put("ог ", 63);
    freq.put("зда", 93);
    freq.put("рой", 70);
    freq.put("здв", 17);
    freq.put("зде", 17);
    freq.put("Як ", 151);
    freq.put("зди", 33);
    freq.put("здк", 9);
    freq.put("здо", 100);
    freq.put("бкл", 10);
    freq.put("ром", 281);
    freq.put("яют", 68);
    freq.put("лює", 38);
    freq.put("люю", 27);
    freq.put("бка", 20);
    freq.put("рре", 12);
    freq.put("люц", 9);
    freq.put("люч", 49);
    freq.put("лют", 82);
    freq.put("люс", 84);
    freq.put("люн", 16);
    freq.put("люк", 11);
    freq.put("СК ", 9);
    freq.put("люз", 11);
    freq.put("люд", 370);
    freq.put("люв", 67);
    freq.put("афі", 80);
    freq.put("люб", 255);
    freq.put("пі ", 47);
    freq.put("ита", 380);
    freq.put("зді", 52);
    freq.put("здр", 23);
    freq.put("зду", 20);
    freq.put("здя", 10);
    freq.put("тф", 23);
    freq.put("тх", 12);
    freq.put("тц", 30);
    freq.put("тч", 103);
    freq.put("тр", 2723);
    freq.put("тс", 158);
    freq.put("Пат", 13);
    freq.put("ту", 1983);
    freq.put("ть", 4019);
    freq.put("тю", 150);
    freq.put("тя", 602);
    freq.put("тє", 45);
    freq.put("ті", 2101);
    freq.put("ян ", 62);
    freq.put("іще", 32);
    freq.put("іщо", 21);
    freq.put("рт ", 150);
    freq.put("илі", 60);
    freq.put("уша", 15);
    freq.put("даж", 23);
    freq.put("дад", 17);
    freq.put("илю", 27);
    freq.put("иля", 24);
    freq.put("даб", 11);
    freq.put("уши", 16);
    freq.put("илу", 34);
    freq.put("ушк", 28);
    freq.put("дам", 41);
    freq.put("дал", 278);
    freq.put("ушн", 33);
    freq.put("дай", 39);
    freq.put("дач", 81);
    freq.put("дац", 17);
    freq.put("дах", 29);
    freq.put("ушу", 32);
    freq.put("ило", 161);
    freq.put("дат", 259);
    freq.put("дас", 19);
    freq.put("дар", 147);
    freq.put("даю", 86);
    freq.put("ила", 472);
    freq.put("иле", 29);
    freq.put("дає", 152);
    freq.put("уші", 20);
    freq.put("те", 2628);
    freq.put("та", 5536);
    freq.put("тб", 89);
    freq.put("Пав", 23);
    freq.put("тм", 33);
    freq.put("Пан", 13);
    freq.put("то", 4128);
    freq.put("Пап", 18);
    freq.put("ти", 6614);
    freq.put("тк", 609);
    freq.put("Зно", 11);

    init3();
  }
  private static void init3() {
    
    freq.put("їха", 91);
    freq.put("ири", 53);
    freq.put("ія ", 765);
    freq.put("иро", 117);
    freq.put("ирн", 26);
    freq.put("плі", 53);
    freq.put("ира", 183);
    freq.put("ире", 47);
    freq.put("плу", 16);
    freq.put("пля", 50);
    freq.put("плю", 59);
    freq.put("ла ", 1482);
    freq.put("ч", 8453);
    freq.put("ин ", 282);
    freq.put("пла", 292);
    freq.put("пле", 65);
    freq.put("пли", 47);
    freq.put("оут", 12);
    freq.put("ирі", 146);
    freq.put("пло", 82);
    freq.put("ирщ", 15);
    freq.put("ирь", 9);
    freq.put("иру", 36);
    freq.put("ирс", 32);
    freq.put("рві", 21);
    freq.put("ос ", 70);
    freq.put("рву", 16);
    freq.put("ит ", 34);
    freq.put("Ні ", 22);
    freq.put("ів ", 2181);
    freq.put("ожа", 26);
    freq.put("рве", 22);
    freq.put("рва", 62);
    freq.put("рвн", 38);
    freq.put("рво", 33);
    freq.put("рви", 16);
    freq.put("сся", 15);
    freq.put("чам", 10);
    freq.put("чан", 100);
    freq.put("ссі", 9);
    freq.put("чай", 109);
    freq.put("чак", 10);
    freq.put("чал", 134);
    freq.put("Н", 1701);
    freq.put("чав", 56);
    freq.put("вті", 24);
    freq.put("втр", 228);
    freq.put("вто", 255);
    freq.put("втн", 44);
    freq.put("вти", 13);
    freq.put("вте", 22);
    freq.put("ТО ", 133);
    freq.put("чаю", 55);
    freq.put("чах", 16);
    freq.put("чар", 46);
    freq.put("час", 440);
    freq.put("чат", 229);
    freq.put("ссе", 10);
    freq.put("еща", 18);
    freq.put("еще", 10);
    freq.put("чає", 81);
    freq.put("ещо", 12);
    freq.put("Лід", 12);
    freq.put("Ліг", 14);
    freq.put("Лік", 9);
    freq.put("Н ", 91);
    freq.put("и", 39978);
    freq.put(" ї ", 16);
    freq.put("Чел", 9);
    freq.put("Ме", 319);
    freq.put("Літ", 13);
    freq.put("гас", 13);
    freq.put("ржи", 18);
    freq.put("кн", 190);
    freq.put("паю", 10);
    freq.put("Тур", 23);
    freq.put("А ", 585);
    freq.put("Тут", 12);
    freq.put("НО ", 29);
    freq.put("елл", 19);
    freq.put("гач", 13);
    freq.put("кл", 751);
    freq.put("рта", 140);
    freq.put("ехт", 13);
    freq.put("гал", 165);
    freq.put("ехі", 12);
    freq.put("ев ", 28);
    freq.put("а ", 14631);
    freq.put("нга", 15);
    freq.put("Рад", 109);
    freq.put("Ран", 10);
    freq.put("схв", 12);
    freq.put("ЧК ", 9);
    freq.put("схо", 50);
    freq.put("ехн", 66);
    freq.put("ехо", 17);
    freq.put("еха", 41);
    freq.put("еан", 17);
    freq.put("еак", 12);
    freq.put("еал", 105);
    freq.put("ьк ", 57);
    freq.put("Дра", 9);
    freq.put("еат", 50);
    freq.put("хта", 39);
    freq.put("хто", 246);
    freq.put("і ", 10867);
    freq.put("ащи", 72);
    freq.put("йна", 46);
    freq.put("йне", 44);
    freq.put("іа ", 12);
    freq.put("йни", 151);
    freq.put("йно", 190);
    freq.put("об ", 301);
    freq.put("йня", 55);
    freq.put("йні", 46);
    freq.put(" д ", 14);
    freq.put("вжу", 33);
    freq.put("іжо", 14);
    freq.put("іжн", 101);
    freq.put("озч", 18);
    freq.put("озр", 53);
    freq.put("озс", 38);
    freq.put("озт", 10);
    freq.put("озу", 179);
    freq.put("іжж", 10);
    freq.put("іже", 10);
    freq.put("озш", 14);
    freq.put("іжа", 9);
    freq.put("озі", 76);
    freq.put("жу ", 234);
    freq.put("озд", 58);
    freq.put("ьт ", 10);
    freq.put("ар ", 161);
    freq.put("оза", 77);
    freq.put("озб", 72);
    freq.put("вже", 382);
    freq.put("вжд", 143);
    freq.put("озм", 111);
    freq.put("озн", 75);
    freq.put("озо", 33);
    freq.put("вжи", 20);
    freq.put("ози", 200);
    freq.put("стк", 68);
    freq.put("вжн", 38);
    freq.put("озл", 14);
    freq.put("мрі", 41);
    freq.put("юка", 18);
    freq.put("за ", 836);
    freq.put("аті", 148);
    freq.put(" уз", 9);
    freq.put("атх", 10);
    freq.put(" жа", 93);
    freq.put("атч", 78);
    freq.put("атс", 45);
    freq.put("атр", 121);
    freq.put("ату", 216);
    freq.put("атт", 85);
    freq.put("ать", 181);
    freq.put("атя", 38);
    freq.put("атю", 14);
    freq.put(" жо", 103);
    freq.put("ате", 101);
    freq.put(" жу", 133);
    freq.put("ата", 214);
    freq.put("атв", 30);
    freq.put("атн", 115);
    freq.put("ато", 348);
    freq.put("ати", 2046);
    freq.put("атл", 11);
    freq.put("атк", 151);
    freq.put(" жі", 103);
    freq.put("бє", 13);
    freq.put("бі", 1399);
    freq.put("бс", 81);
    freq.put("бр", 570);
    freq.put("бу", 2037);
    freq.put("бт", 26);
    freq.put("бх", 21);
    freq.put("мог", 231);
    freq.put("гло", 19);
    freq.put("гли", 46);
    freq.put("бю", 49);
    freq.put("рце", 31);
    freq.put("клі", 72);
    freq.put("кль", 13);
    freq.put("клю", 44);
    freq.put("кля", 9);
    freq.put("клу", 46);
    freq.put("кло", 28);
    freq.put("кли", 85);
    freq.put("рці", 36);
    freq.put("Шук", 13);
    freq.put("кле", 16);
    freq.put("кла", 427);
    freq.put(" Си", 56);
    freq.put(" Ск", 87);
    freq.put("рця", 20);
    freq.put("ба", 1554);
    freq.put("бг", 24);
    freq.put("бв", 12);
    freq.put("бе", 916);
    freq.put("глу", 10);
    freq.put("би", 974);
    freq.put("бл", 992);
    freq.put("бк", 89);
    freq.put("бн", 210);
    freq.put("бм", 48);
    freq.put("бо", 1639);
    freq.put("глі", 54);
    freq.put("цов", 10);
    freq.put("зва", 103);
    freq.put("зво", 109);
    freq.put("яйц", 12);
    freq.put("зви", 169);
    freq.put("оч ", 56);
    freq.put("Х", 478);
    freq.put("ип ", 16);
    freq.put("Нє ", 10);
    freq.put(" Б ", 11);
    freq.put("щув", 12);
    freq.put("мої", 96);
    freq.put("д ", 1606);
    freq.put("уті", 52);
    freq.put("уюч", 40);
    freq.put("уют", 269);
    freq.put("уюс", 30);
    freq.put("ечу", 11);
    freq.put("ечч", 36);
    freq.put("Пар", 64);
    freq.put("ечі", 124);
    freq.put("Пас", 12);
    freq.put("Не", 271);
    freq.put(" їх", 167);
    freq.put("тт", 480);
    freq.put(" їс", 27);
    freq.put("Но", 271);
    freq.put("Ни", 11);
    freq.put(" її", 83);
    freq.put("Нє", 13);
    freq.put("Ні", 117);
    freq.put(" їж", 23);
    freq.put(" їз", 33);
    freq.put(" їд", 38);
    freq.put("Ну", 74);
    freq.put(" їб", 10);
    freq.put(" їм", 45);
    freq.put(" їй", 20);
    freq.put("ечк", 41);
    freq.put("ті ", 874);
    freq.put("ечо", 26);
    freq.put("ечн", 48);
    freq.put("еча", 23);
    freq.put("ече", 87);
    freq.put("ав", 3938);
    freq.put("аг", 868);
    freq.put("аа", 260);
    freq.put("аб", 859);
    freq.put("аж", 711);
    freq.put("аз", 1203);
    freq.put("ад", 2005);
    freq.put("ае", 38);
    freq.put("ак", 2457);
    freq.put("яг", 175);
    freq.put("аи", 17);
    freq.put("ай", 1682);
    freq.put("ао", 20);
    freq.put("ап", 762);
    freq.put("ам", 2025);
    freq.put("ан", 4486);
    freq.put("евд", 10);
    freq.put("вра", 73);
    freq.put("евж", 9);
    freq.put("аС", 14);
    freq.put("ева", 69);
    freq.put("евн", 99);
    freq.put("ево", 47);
    freq.put("еви", 90);
    freq.put("вро", 237);
    freq.put("йпо", 9);
    freq.put("вру", 14);
    freq.put("евч", 43);
    freq.put("аі", 11);
    freq.put("аї", 1317);
    freq.put("ає", 1494);
    freq.put("ы", 72);
    freq.put("вря", 23);
    freq.put("ат", 4168);
    freq.put("ау", 121);
    freq.put("ар", 3280);
    freq.put("ас", 2718);
    freq.put("ац", 776);
    freq.put("ач", 934);
    freq.put("аф", 218);
    freq.put("ах", 1217);
    freq.put("аш", 522);
    freq.put("ащ", 246);
    freq.put("аю", 1091);
    freq.put("ая", 96);
    freq.put("ех ", 18);
    freq.put("ьки", 989);
    freq.put("Ант", 11);
    freq.put("ько", 820);
    freq.put("ька", 432);
    freq.put("ьке", 66);
    freq.put("уше", 42);
    freq.put("иль", 150);
    freq.put("ькі", 400);
    freq.put("Анд", 52);
    freq.put("Анж", 9);
    freq.put("Ана", 20);
    freq.put("Анг", 28);
    freq.put("Анн", 9);
    freq.put("ьку", 247);
    freq.put("дан", 221);
    freq.put("дак", 31);
    freq.put("илк", 33);
    freq.put("или", 615);
    freq.put("обт", 19);
    freq.put("йн ", 40);
    freq.put("обр", 266);
    freq.put("обс", 34);
    freq.put("обх", 21);
    freq.put("іан", 64);
    freq.put(" ді", 426);
    freq.put("іал", 137);
    freq.put("іа", 350);
    freq.put("іб", 317);
    freq.put("ів", 3661);
    freq.put("іг", 472);
    freq.put("обі", 534);
    freq.put("іж", 325);
    freq.put("із", 862);
    freq.put("ій", 1640);
    freq.put("ік", 1302);
    freq.put("іл", 2287);
    freq.put("ім", 777);
    freq.put("ін", 2365);
    freq.put("іо", 504);
    freq.put("іп", 198);
    freq.put("ір", 845);
    freq.put("іс", 1936);
    freq.put("іт", 2035);
    freq.put("іу", 18);
    freq.put("іф", 40);
    freq.put("іх", 269);
    freq.put("іц", 290);
    freq.put("іч", 754);
    freq.put("іш", 624);
    freq.put("іщ", 67);
    freq.put(" де", 828);
    freq.put(" дв", 188);
    freq.put("ію", 467);
    freq.put("ія", 943);
    freq.put("обв", 11);
    freq.put("обг", 22);
    freq.put("оба", 360);
    freq.put("іац", 22);
    freq.put("іє", 279);
    freq.put("іар", 16);
    freq.put("іі", 21);
    freq.put("ії", 945);
    freq.put("обк", 31);
    freq.put("обл", 419);
    freq.put("оби", 380);
    freq.put("обо", 405);
    freq.put("обм", 22);
    freq.put("обн", 43);
    freq.put(" дО", 36);
    freq.put("ОЮ ", 11);
    freq.put("мці", 25);
    freq.put("мця", 9);
    freq.put("жур", 126);
    freq.put("жут", 98);
    freq.put("арі", 304);
    freq.put("жуч", 9);
    freq.put("нші", 21);
    freq.put("жую", 43);
    freq.put("ару", 105);
    freq.put("ьтр", 10);
    freq.put("ьту", 41);
    freq.put("арр", 10);
    freq.put("жує", 46);
    freq.put("арц", 11);
    freq.put("арх", 24);
    freq.put("арш", 60);
    freq.put("аря", 68);
    freq.put("арю", 9);
    freq.put("іж ", 110);
    freq.put("арг", 16);
    freq.put("ьта", 52);
    freq.put("арб", 21);
    freq.put("ара", 438);
    freq.put("оз ", 32);
    freq.put("арж", 21);
    freq.put("аре", 155);
    freq.put("яю", 100);
    freq.put("арл", 54);
    freq.put("арк", 209);
    freq.put("нше", 57);
    freq.put("арп", 148);
    freq.put("аро", 461);
    freq.put("арн", 251);
    freq.put("арм", 50);
    freq.put("жув", 34);
    freq.put(" Кі", 93);
    freq.put("ящ", 10);
    freq.put("ег ", 18);
    freq.put("ях", 142);
    freq.put("зам", 149);
    freq.put("зан", 66);
    freq.put("цип", 16);
    freq.put("зап", 235);
    freq.put("зай", 76);
    freq.put("зак", 313);
    freq.put("зал", 334);
    freq.put("зад", 106);
    freq.put("циз", 9);
    freq.put("заз", 30);
    freq.put("заб", 257);
    freq.put("зав", 518);
    freq.put("заг", 185);
    freq.put("іги", 21);
    freq.put("яр", 97);
    freq.put(" ж ", 253);
    freq.put(" лі", 382);
    freq.put("рфо", 9);
    freq.put("кну", 30);
    freq.put("кни", 90);
    freq.put("кно", 29);
    freq.put("тв", 896);
    freq.put("кна", 17);
    freq.put("кне", 16);
    freq.put("ат ", 185);
    freq.put("тн", 687);
    freq.put("зає", 31);
    freq.put("зая", 45);
    freq.put("заф", 17);
    freq.put("зах", 179);
    freq.put("зац", 97);
    freq.put("Пал", 10);
    freq.put("зар", 351);
    freq.put("зас", 192);
    freq.put("зат", 164);
    freq.put("цит", 13);
    freq.put("кци", 11);
    freq.put("Губ", 10);
    freq.put("кл ", 11);
    freq.put("зв ", 35);
    freq.put("Гур", 14);
    freq.put("б ", 595);
    freq.put("дО", 36);
    freq.put("оче", 225);
    freq.put("оча", 252);
    freq.put("ифр", 11);
    freq.put(" хр", 45);
    freq.put("очо", 62);
    freq.put("очи", 238);
    freq.put("очк", 101);
    freq.put("ифі", 34);
    freq.put("Кос", 20);
    freq.put("Кор", 49);
    freq.put("Кох", 11);
    freq.put("до", 3220);
    freq.put("дп", 291);
    freq.put("дм", 137);
    freq.put("дн", 1806);
    freq.put("дк", 467);
    freq.put("дл", 501);
    freq.put("ди", 2486);
    freq.put("АМ ", 11);
    freq.put("Дже", 10);
    freq.put("дз", 162);
    freq.put("дд", 97);
    freq.put("Уже", 9);
    freq.put("дв", 329);
    freq.put("дг", 39);
    freq.put("да", 2245);
    freq.put("дб", 196);
    freq.put("ипе", 38);
    freq.put("ипа", 78);
    freq.put("ипо", 15);
    freq.put("ипн", 22);
    freq.put("ипл", 36);
    freq.put("ипи", 53);
    freq.put("ипу", 84);
    freq.put("ипр", 27);
    freq.put("ді", 1756);
    freq.put("дє", 20);
    freq.put("ипі", 14);
    freq.put("дя", 316);
    freq.put("дь", 224);
    freq.put(" Бу", 124);
    freq.put("дш", 32);
    freq.put("дц", 26);
    freq.put("дч", 105);
    freq.put("дх", 36);
    freq.put("дт", 142);
    freq.put("ду", 1565);
    freq.put("др", 626);
    freq.put("дс", 291);
    freq.put("Ков", 18);
    freq.put("очі", 147);
    freq.put("Кож", 22);
    freq.put("Кол", 86);
    freq.put("Кон", 57);
    freq.put("Ком", 62);
    freq.put("очу", 225);
    freq.put("кту", 69);
    freq.put("ктр", 48);
    freq.put("кті", 59);
    freq.put("ох ", 99);
    freq.put(" ру", 160);
    freq.put("урк", 19);
    freq.put("урм", 9);
    freq.put("урн", 211);
    freq.put("уро", 83);
    freq.put("ура", 131);
    freq.put("урб", 28);
    freq.put("урв", 10);
    freq.put("ург", 30);
    freq.put(" ря", 45);
    freq.put("уре", 39);
    freq.put(" рі", 368);
    freq.put(" Г ", 11);
    freq.put("що ", 1402);
    freq.put("яць", 31);
    freq.put(" ра", 723);
    freq.put("яці", 65);
    freq.put(" ре", 642);
    freq.put("уря", 27);
    freq.put("урс", 109);
    freq.put("урт", 54);
    freq.put(" ри", 62);
    freq.put(" ро", 1522);
    freq.put("ї ", 2125);
    freq.put("кте", 23);
    freq.put("кта", 24);
    freq.put("кто", 144);
    freq.put("кти", 190);
    freq.put("Два", 9);
    freq.put(" Ен", 17);
    freq.put("ига", 63);
    freq.put("ВС ", 15);
    freq.put(" Ел", 27);
    freq.put("игл", 40);
    freq.put("иги", 18);
    freq.put("иго", 51);
    freq.put("игн", 17);
    freq.put("игі", 27);
    freq.put("ба ", 291);
    freq.put("ри ", 566);
    freq.put("де", 2613);
    freq.put("арч", 30);
    freq.put("игу", 22);
    freq.put("игр", 43);
    freq.put("у ", 8524);
    freq.put("був", 319);
    freq.put("буд", 759);
    freq.put("бул", 425);
    freq.put("бук", 18);
    freq.put("буй", 12);
    freq.put("Тяг", 15);
    freq.put("бун", 11);
    freq.put("бум", 12);
    freq.put("зфо", 9);
    freq.put("хло", 69);
    freq.put("хли", 18);
    freq.put(" Бр", 71);
    freq.put("рку", 70);
    freq.put("ркі", 64);
    freq.put(" Фі", 57);
    freq.put("зув", 46);
    freq.put("рко", 89);
    freq.put("рки", 47);
    freq.put("ьшо", 24);
    freq.put("рке", 26);
    freq.put("рка", 146);
    freq.put("ркв", 24);
    freq.put("чо ", 9);
    freq.put("бує", 17);
    freq.put("бут", 260);
    freq.put("бус", 37);
    freq.put("бур", 29);
    freq.put("бух", 41);
    freq.put("єш ", 188);
    freq.put("бую", 13);
    freq.put("чих", 35);
    freq.put("чис", 71);
    freq.put("чит", 347);
    freq.put("чиш", 24);
    freq.put("есі", 123);
    freq.put(" й", 506);
    freq.put("есь", 145);
    freq.put("еся", 67);
    freq.put("есс", 10);
    freq.put("есу", 51);
    freq.put("ест", 313);
    freq.put("Щ", 226);
    freq.put("ма ", 370);
    freq.put("увс", 48);
    freq.put("аци", 11);
    freq.put("Яро", 10);
    freq.put("еси", 38);
    freq.put("есл", 32);
    freq.put("еск", 20);
    freq.put("есн", 140);
    freq.put("есп", 45);
    freq.put("есо", 31);
    freq.put("еса", 30);
    freq.put("есв", 21);
    freq.put("есе", 87);
    freq.put("чиз", 13);
    freq.put("чив", 111);
    freq.put("чим", 99);
    freq.put("чин", 317);
    freq.put("чий", 78);
    freq.put("чик", 85);
    freq.put("чил", 150);
    freq.put("вд", 312);
    freq.put("ве", 1528);
    freq.put("вж", 623);
    freq.put("вз", 183);
    freq.put("ва", 4665);
    freq.put("вб", 105);
    freq.put("вв", 101);
    freq.put("вг", 77);
    freq.put("вм", 96);
    freq.put("вн", 1312);
    freq.put("во", 3116);
    freq.put("вп", 176);
    freq.put("ви", 4399);
    freq.put("вк", 361);
    freq.put("вл", 612);
    freq.put("вє", 31);
    freq.put("ві", 5305);
    freq.put("вх", 33);
    freq.put("вц", 232);
    freq.put("вч", 474);
    freq.put("вр", 382);
    freq.put("вс", 1844);
    freq.put("вт", 606);
    freq.put("ву", 713);
    freq.put("вя", 180);
    freq.put("вш", 51);
    freq.put("вщ", 124);
    freq.put("вы", 13);
    freq.put("е ", 9665);
    freq.put("ід ", 867);
    freq.put("зуп", 29);
    freq.put("йбо", 12);
    freq.put("йбл", 18);
    freq.put("йбу", 42);
    freq.put("йбі", 62);
    freq.put("ш ", 583);
    freq.put("ші ", 207);
    freq.put("ікл", 10);
    freq.put("іки", 65);
    freq.put("ове", 336);
    freq.put("ікн", 29);
    freq.put("ікв", 22);
    freq.put("іка", 396);
    freq.put("іке", 23);
    freq.put(" и ", 14);
    freq.put("гі ", 15);
    freq.put("вво", 9);
    freq.put("вве", 31);
    freq.put("ью ", 69);
    freq.put("вва", 47);
    freq.put("іку", 185);
    freq.put("ікт", 52);
    freq.put("ікс", 22);
    freq.put("ікр", 19);
    freq.put("ікі", 47);
    freq.put("жад", 9);
    freq.put("жав", 105);
    freq.put("жан", 58);
    freq.put("жай", 9);
    freq.put("жал", 67);
    freq.put("утк", 49);
    freq.put("Єди", 13);
    freq.put("шнь", 36);
    freq.put("шня", 14);
    freq.put("нд ", 31);
    freq.put(" кн", 86);
    freq.put(" км", 15);
    freq.put(" ко", 1489);
    freq.put(" ки", 141);
    freq.put(" кл", 226);
    freq.put(" ке", 51);
    freq.put("шні", 82);
    freq.put("Уд", 12);
    freq.put(" ка", 597);
    freq.put(" кв", 174);
    freq.put("гше", 11);
    freq.put(" кр", 568);
    freq.put(" ку", 323);
    freq.put("шно", 49);
    freq.put("шни", 47);
    freq.put("шне", 11);
    freq.put(" кі", 235);
    freq.put("шна", 10);
    freq.put("лин", 256);
    freq.put("жає", 44);
    freq.put("зм ", 32);
    freq.put("фля", 9);
    freq.put("жах", 31);
    freq.put("жар", 29);
    freq.put("жат", 51);
    freq.put("жаю", 67);
    freq.put("лив", 368);
    freq.put("охо", 126);
    freq.put("їх", 268);
    freq.put(" тю", 15);
    freq.put("їт", 27);
    freq.put("їс", 46);
    freq.put("ицю", 50);
    freq.put("ицт", 50);
    freq.put("охв", 14);
    freq.put("оха", 92);
    freq.put("її", 87);
    freq.put("Дав", 20);
    freq.put("иці", 323);
    freq.put(" т", 6722);
    freq.put(" у", 2492);
    freq.put(" р", 3593);
    freq.put(" с", 6514);
    freq.put(" ц", 1517);
    freq.put(" ч", 1920);
    freq.put(" ф", 976);
    freq.put(" х", 1420);
    freq.put(" ш", 872);
    freq.put(" щ", 2097);
    freq.put(" ю", 121);
    freq.put(" я", 3325);
    freq.put("їжд", 14);
    freq.put(" Ге", 67);
    freq.put("иби", 35);
    freq.put("ибл", 14);
    freq.put(" і", 2918);
    freq.put(" ї", 477);
    freq.put("ибо", 239);
    freq.put(" яч", 11);
    freq.put("ур ", 33);
    freq.put(" Т", 1133);
    freq.put(" У", 1917);
    freq.put(" Р", 782);
    freq.put(" С", 1458);
    freq.put(" Ц", 328);
    freq.put(" Ч", 705);
    freq.put(" Ф", 586);
    freq.put(" Х", 473);
    freq.put("ибр", 22);
    freq.put(" ят", 144);
    freq.put(" Ш", 270);
    freq.put("ибу", 51);
    freq.put(" Ю", 141);
    freq.put(" Я", 861);
    freq.put(" в", 10786);
    freq.put("ярм", 10);
    freq.put(" а", 2410);
    freq.put(" б", 3802);
    freq.put(" ж", 1080);
    freq.put(" з", 7809);
    freq.put(" д", 5606);
    freq.put(" е", 424);
    freq.put(" к", 3954);
    freq.put(" л", 1768);
    freq.put(" и", 42);
    freq.put(" яс", 53);
    freq.put(" о", 2773);
    freq.put(" п", 10870);
    freq.put("ибі", 28);
    freq.put(" н", 9495);
    freq.put(" І", 621);
    freq.put(" Ї", 39);
    freq.put(" Є", 311);
    freq.put("Дар", 11);
    freq.put("охі", 19);
    freq.put("їз", 81);
    freq.put("ици", 12);
    freq.put(" А", 1040);
    freq.put("їд", 91);
    freq.put(" Ж", 249);
    freq.put("їв", 243);
    freq.put("їб", 14);
    freq.put(" Е", 174);
    freq.put(" К", 1567);
    freq.put("ица", 17);
    freq.put("їн", 1248);
    freq.put("їм", 109);
    freq.put("ице", 26);
    freq.put("оху", 14);
    freq.put("їй", 52);
    freq.put(" Н", 1691);
    freq.put("Ґ", 9);
    freq.put("хне", 22);
    freq.put(" бр", 134);
    freq.put("рищ", 10);
    freq.put("риш", 34);
    freq.put("рия", 15);
    freq.put("рию", 24);
    freq.put("бат", 84);
    freq.put("рит", 335);
    freq.put("бар", 50);
    freq.put("бас", 46);
    freq.put("рич", 87);
    freq.put("бач", 274);
    freq.put("рих", 86);
    freq.put("риф", 21);
    freq.put("риї", 38);
    freq.put("бає", 140);
    freq.put("риє", 121);
    freq.put("хні", 44);
    freq.put("бак", 39);
    freq.put("рик", 221);
    freq.put("рий", 191);
    freq.put("бай", 27);
    freq.put("рип", 53);
    freq.put("бам", 21);
    freq.put("бан", 143);
    freq.put("бав", 53);
    freq.put("баг", 136);
    freq.put("хня", 9);
    freq.put("баб", 32);
    freq.put("баж", 61);
    freq.put("риж", 15);
    freq.put("рид", 88);
    freq.put("лиш", 240);
    freq.put(" Ґ", 9);
    freq.put("чот", 22);
    freq.put("чор", 133);
    freq.put("чос", 11);
    freq.put("бу ", 60);
    freq.put("чої", 20);
    freq.put("иш ", 104);
    freq.put("лих", 32);
    freq.put(" И", 17);
    freq.put("рк ", 19);
    freq.put("Яце", 12);
    freq.put("ТИ ", 31);
    freq.put("еук", 28);
    freq.put("чов", 16);
    freq.put(" О", 810);
    freq.put("чок", 32);
    freq.put("чол", 120);
    freq.put("чом", 98);
    freq.put("лон", 72);
    freq.put("ел ", 16);
    freq.put("ман", 243);
    freq.put("мам", 60);
    freq.put("мал", 356);
    freq.put("мак", 52);
    freq.put("май", 208);
    freq.put("маз", 20);
    freq.put("маж", 15);
    freq.put("мад", 77);
    freq.put("маг", 135);
    freq.put("мав", 99);
    freq.put("маб", 37);
    freq.put("мая", 9);
    freq.put("маю", 170);
    freq.put("маш", 46);
    freq.put("мач", 32);
    freq.put("мац", 62);
    freq.put("мах", 37);
    freq.put("мат", 317);
    freq.put("мас", 50);
    freq.put("мар", 165);
    freq.put("має", 271);
    freq.put("чи ", 291);
    freq.put("ес ", 100);
    freq.put("є", 4184);
    freq.put("еє", 53);
    freq.put("еї", 105);
    freq.put("хро", 16);
    freq.put("ея", 67);
    freq.put("ею", 90);
    freq.put("ещ", 52);
    freq.put("еш", 312);
    freq.put("хри", 9);
    freq.put("ех", 180);
    freq.put("еф", 152);
    freq.put("еч", 424);
    freq.put("хре", 16);
    freq.put("ес", 1270);
    freq.put("ер", 5392);
    freq.put("еу", 35);
    freq.put("ет", 1288);
    freq.put("в ", 7011);
    freq.put("м", 18629);
    freq.put("ен", 5052);
    freq.put("ем", 1254);
    freq.put("еп", 691);
    freq.put("ео", 429);
    freq.put("ей", 642);
    freq.put("ел", 1005);
    freq.put("ек", 1249);
    freq.put("ее", 40);
    freq.put("ед", 991);
    freq.put("ез", 1133);
    freq.put("еж", 396);
    freq.put("еб", 707);
    freq.put("еа", 207);
    freq.put("ег", 407);
    freq.put("ев", 663);
    freq.put("Кав", 11);
    freq.put(" Зб", 49);
    freq.put("ші", 263);
    freq.put("ідб", 149);
    freq.put("іда", 169);
    freq.put("ідг", 35);
    freq.put("ідв", 65);
    freq.put("іде", 415);
    freq.put("ідд", 64);
    freq.put("ідз", 58);
    freq.put("ідж", 22);
    freq.put("шт", 334);
    freq.put("шу", 318);
    freq.put("шр", 37);
    freq.put("шс", 44);
    freq.put("ідн", 311);
    freq.put("ідм", 81);
    freq.put("ідп", 282);
    freq.put("ІІ ", 14);
    freq.put("вдр", 16);
    freq.put("вду", 11);
    freq.put("вдя", 24);
    freq.put("вді", 47);
    freq.put("спу", 15);
    freq.put("спр", 300);
    freq.put("вде", 16);
    freq.put("оен", 11);
    freq.put("оек", 105);
    freq.put("вда", 147);
    freq.put("вдо", 35);
    freq.put("вди", 9);
    freq.put("шк", 397);
    freq.put("шл", 254);
    freq.put("ши", 655);
    freq.put("ідт", 113);
    freq.put("шо", 651);
    freq.put("шп", 22);
    freq.put("шм", 9);
    freq.put("шн", 275);
    freq.put("шв", 79);
    freq.put("ідш", 11);
    freq.put("ша", 339);
    freq.put("ідь", 33);
    freq.put("ше", 972);
    freq.put("іді", 81);
    freq.put("либ", 9);
    freq.put("Сер", 61);
    freq.put("ік ", 244);
    freq.put("шій", 19);
    freq.put("В", 2334);
    freq.put("гію", 13);
    freq.put("гія", 30);
    freq.put("шлю", 9);
    freq.put("шля", 34);
    freq.put("гіч", 36);
    freq.put("гіт", 30);
    freq.put("гір", 39);
    freq.put("гії", 41);
    freq.put("гіє", 10);
    freq.put("афу", 24);
    freq.put("афт", 20);
    freq.put("афо", 17);
    freq.put("алю", 96);
    freq.put("афе", 25);
    freq.put("афа", 16);
    freq.put("гіо", 110);
    freq.put("гіп", 13);
    freq.put("гім", 19);
    freq.put("гін", 22);
    freq.put("жчи", 20);
    freq.put("гій", 47);
    freq.put("жче", 22);
    freq.put("гід", 46);
    freq.put("жча", 16);
    freq.put("гіг", 9);
    freq.put("шіс", 16);
    freq.put("шіт", 13);
    freq.put("Інф", 34);
    freq.put("зму", 55);
    freq.put("Інт", 39);
    freq.put("яль", 37);
    freq.put("гно", 34);
    freq.put("жа ", 43);
    freq.put("гни", 20);
    freq.put("гне", 25);
    freq.put("змі", 190);
    freq.put("гна", 20);
    freq.put("рши", 119);
    freq.put("ршо", 59);
    freq.put("рша", 36);
    freq.put(" к ", 18);
    freq.put("рше", 83);
    freq.put("нди", 92);
    freq.put("ндо", 36);
    freq.put("єю ", 124);
    freq.put("нда", 103);
    freq.put("нде", 60);
    freq.put("нду", 71);
    freq.put("ндр", 106);
    freq.put("рші", 31);
    freq.put("ршу", 26);
    freq.put("ршр", 33);
    freq.put("нді", 51);
    freq.put("гня", 18);
    freq.put("гну", 34);
    freq.put("Іно", 10);
    freq.put("яла", 51);
    freq.put("змо", 96);
    freq.put("зма", 22);
    freq.put("яли", 63);
    freq.put("рд ", 45);
    freq.put("цме", 9);
    freq.put("зме", 19);
    freq.put("яло", 10);
    freq.put("жли", 101);
    freq.put(" ен", 23);
    freq.put("фей", 17);
    freq.put("фек", 21);
    freq.put("ац ", 14);
    freq.put(" ме", 1122);
    freq.put("іті", 72);
    freq.put("ьш ", 40);
    freq.put(" мо", 1300);
    freq.put(" мн", 36);
    freq.put(" мм", 19);
    freq.put(" мл", 65);
    freq.put(" ми", 308);
    freq.put("Рі", 75);
    freq.put(" мі", 886);
    freq.put("шпа", 17);
    freq.put("Ра", 151);
    freq.put(" му", 216);
    freq.put("МІ ", 28);
    freq.put("Ре", 125);
    freq.put("Ри", 38);
    freq.put("Ро", 250);
    freq.put("єшс", 26);
    freq.put(" Зу", 13);
    freq.put("ОК ", 18);
    freq.put("фер", 90);
    freq.put("фес", 79);
    freq.put("ут ", 188);
    freq.put("У ", 790);
    freq.put("зиц", 129);
    freq.put("зич", 29);
    freq.put("зит", 68);
    freq.put("рьо", 48);
    freq.put("ії ", 900);
    freq.put("наж", 13);
    freq.put("наз", 125);
    freq.put("над", 266);
    freq.put("нав", 432);
    freq.put("наг", 89);
    freq.put("цяв", 12);
    freq.put("наб", 59);
    freq.put("цям", 62);
    freq.put("нап", 198);
    freq.put("нам", 216);
    freq.put("нан", 140);
    freq.put("нак", 81);
    freq.put("нал", 566);
    freq.put("най", 429);
    freq.put("ашл", 15);
    freq.put("ашк", 47);
    freq.put("аши", 71);
    freq.put("ашо", 76);
    freq.put("Вже", 31);
    freq.put("ли ", 1834);
    freq.put("аша", 45);
    freq.put("аше", 20);
    freq.put("цяє", 15);
    freq.put("наї", 9);
    freq.put("нає", 148);
    freq.put(" т ", 21);
    freq.put("ашу", 24);
    freq.put("ашт", 43);
    freq.put("нац", 71);
    freq.put("нач", 240);
    freq.put("наф", 13);
    freq.put("нах", 101);
    freq.put("нат", 223);
    freq.put("нау", 36);
    freq.put("нар", 348);
    freq.put("нас", 420);
    freq.put("наю", 131);
    freq.put("ная", 12);
    freq.put("цяю", 14);
    freq.put("аші", 60);
    freq.put("наш", 139);
    freq.put("зид", 97);
    freq.put("зив", 60);
    freq.put("зим", 55);
    freq.put("кр ", 37);
    freq.put("зик", 110);
    freq.put("зил", 26);
    freq.put("язн", 23);
    freq.put("язи", 10);
    freq.put("язк", 40);
    freq.put("яза", 41);
    freq.put("сві", 368);
    freq.put("лка", 45);
    freq.put("цу", 58);
    freq.put("ює ", 81);
    freq.put("лки", 34);
    freq.put("лко", 57);
    freq.put("цю", 218);
    freq.put("свя", 126);
    freq.put("кеа", 12);
    freq.put("кел", 9);
    freq.put("кей", 9);
    freq.put(" фу", 85);
    freq.put(" фр", 66);
    freq.put("ято", 79);
    freq.put("ятн", 37);
    freq.put("ие ", 16);
    freq.put("яти", 225);
    freq.put(" фі", 268);
    freq.put("яте", 13);
    freq.put("ята", 76);
    freq.put("ять", 333);
    freq.put("ятт", 28);
    freq.put("яту", 61);
    freq.put("кет", 43);
    freq.put(" фо", 303);
    freq.put("кер", 76);
    freq.put("кес", 18);
    freq.put(" фл", 12);
    freq.put("яті", 30);
    freq.put(" фе", 65);
    freq.put(" фа", 168);
    freq.put("сва", 15);
    freq.put("лку", 62);
    freq.put("цв", 22);
    freq.put("це", 1323);
    freq.put("сви", 17);
    freq.put("цк", 14);
    freq.put("цм", 11);
    freq.put("сво", 323);
    freq.put("лкі", 12);
    freq.put("Гла", 11);
    freq.put("їми", 18);
    freq.put(" Йо", 35);
    freq.put("изм", 33);
    freq.put("изн", 148);
    freq.put("аах", 9);
    freq.put("изд", 10);
    freq.put("изв", 14);
    freq.put("иза", 31);
    freq.put("щ ", 48);
    freq.put("щи", 339);
    freq.put("изі", 10);
    freq.put("изь", 40);
    freq.put("ааа", 158);
    freq.put("рм ", 26);
    freq.put("аак", 13);
    freq.put("изу", 23);
    freq.put("ржа", 115);
    freq.put("іша", 51);
    freq.put("зро", 252);
    freq.put("Суд", 26);
    freq.put("дя ", 11);
    freq.put("Суп", 16);
    freq.put("Сум", 22);
    freq.put("роє", 17);
    freq.put("рої", 59);
    freq.put("роі", 11);
    freq.put("рощ", 28);
    freq.put("рош", 209);
    freq.put("роя", 17);
    freq.put("рою", 48);
    freq.put("рос", 493);
    freq.put("рор", 51);
    freq.put("бку", 29);
    freq.put("рох", 102);
    freq.put("роф", 61);
    freq.put("роч", 77);
    freq.put("роц", 74);
    freq.put("бки", 12);
    freq.put("рол", 145);
    freq.put("Іта", 20);
    freq.put("рон", 212);
    freq.put("ф", 2115);
    freq.put("роп", 261);
    freq.put("ся ", 2293);
    freq.put("роб", 765);
    freq.put("рог", 285);
    freq.put("ров", 555);
    freq.put("рое", 115);
    freq.put("род", 598);
    freq.put("роз", 886);
    freq.put("рож", 97);
    freq.put("НІ ", 31);
    freq.put("ЦЕ ", 10);
    freq.put("Сус", 11);
    freq.put("зру", 28);
    freq.put("зрі", 12);
    freq.put("оюс", 18);
    freq.put("мм ", 27);
    freq.put("рми", 19);
    freq.put(" ет", 21);
    freq.put("юзі", 9);
    freq.put("К", 1577);
    freq.put("мон", 119);
    freq.put("мом", 83);
    freq.put("мол", 114);
    freq.put("мок", 51);
    freq.put("мод", 47);
    freq.put("моз", 25);
    freq.put("мож", 629);
    freq.put("моб", 68);
    freq.put("Фу", 22);
    freq.put("Фр", 159);
    freq.put("мов", 468);
    freq.put(" Са", 88);
    freq.put("Бал", 14);
    freq.put(" Св", 121);
    freq.put(" Се", 106);
    freq.put("Бан", 26);
    freq.put("Фі", 58);
    freq.put("Баг", 15);
    freq.put("Риб", 13);
    freq.put("Баб", 13);
    freq.put(" См", 29);
    freq.put(" Сн", 15);
    freq.put(" Со", 98);
    freq.put(" Сп", 100);
    freq.put(" Ст", 199);
    freq.put(" Су", 99);
    freq.put(" Сх", 19);
    freq.put("Бат", 22);
    freq.put("моє", 59);
    freq.put("Бар", 29);
    freq.put(" Сь", 127);
    freq.put(" ла", 183);
    freq.put("Фо", 77);
    freq.put("моя", 44);
    freq.put("мою", 50);
    freq.put("мощ", 60);
    freq.put("мош", 100);
    freq.put(" Сі", 39);
    freq.put("моч", 9);
    freq.put("моц", 14);
    freq.put("мос", 116);
    freq.put("мор", 120);
    freq.put("Фа", 29);
    freq.put("мот", 49);
    freq.put("юзи", 10);
    freq.put("км ", 13);
    freq.put("ший", 130);
    freq.put("уй ", 65);
    freq.put("ва ", 862);
    freq.put("фе ", 12);
    freq.put("зор", 33);
    freq.put("цює", 44);
    freq.put("аца", 19);
    freq.put("ьше", 186);
    freq.put("аце", 14);
    freq.put(" м ", 55);
    freq.put("нве", 26);
    freq.put("нва", 9);
    freq.put("ьши", 16);
    freq.put("р", 34022);
    freq.put("Р ", 119);
    freq.put("ьшу", 9);
    freq.put("аць", 19);
    freq.put("ацю", 111);
    freq.put("ьші", 13);
    freq.put("аці", 550);
    freq.put("зов", 106);
    freq.put("зоб", 17);
    freq.put("зок", 28);
    freq.put("зол", 34);
    freq.put("зоо", 9);
    freq.put("ачє", 10);
    freq.put("зом", 50);
    freq.put("зон", 68);
    freq.put("рь ", 9);
    freq.put("кру", 133);
    freq.put("іїв", 26);
    freq.put("Ул", 9);
    freq.put("Ук", 908);
    freq.put("ута", 171);
    freq.put("утб", 77);
    freq.put("Уп", 13);
    freq.put("Ун", 14);
    freq.put("уте", 17);
    freq.put("Уг", 12);
    freq.put("Ув", 9);
    freq.put("ути", 328);
    freq.put("уто", 66);
    freq.put("Уж", 46);
    freq.put("крі", 38);
    freq.put("лий", 55);
    freq.put("лик", 224);
    freq.put("лил", 70);
    freq.put("лим", 38);
    freq.put(" тр", 789);
    freq.put(" ту", 338);
    freq.put("лип", 32);
    freq.put(" ть", 14);
    freq.put(" тя", 27);
    freq.put("аш ", 47);
    freq.put("лиж", 37);
    freq.put("лиз", 59);
    freq.put("ярд", 22);
    freq.put(" ті", 270);
    freq.put("ця ", 235);
    freq.put("на ", 4187);
    freq.put("кза", 38);
    freq.put("ярн", 16);
    freq.put("яри", 10);
    freq.put(" те", 956);
    freq.put("лищ", 13);
    freq.put("ярі", 17);
    freq.put(" та", 2121);
    freq.put(" тв", 347);
    freq.put("лис", 373);
    freq.put("лит", 127);
    freq.put(" то", 1036);
    freq.put(" ти", 766);
    freq.put("лиц", 104);
    freq.put("лич", 125);
    freq.put("утт", 49);
    freq.put("уту", 13);
    freq.put("утр", 34);
    freq.put("Ус", 28);
    freq.put("Ур", 44);
    freq.put("Уч", 19);
    freq.put("уть", 462);
    freq.put("кри", 331);
    freq.put("зи ", 89);
    freq.put("крм", 10);
    freq.put("кро", 95);
    freq.put("кра", 1709);
    freq.put("кре", 102);
    freq.put("крз", 15);
    freq.put(" Зд", 31);
    freq.put(" Зе", 35);
    freq.put(" Зв", 28);
    freq.put(" Зг", 13);
    freq.put(" За", 510);
    freq.put("Ж", 250);
    freq.put(" Зо", 20);
    freq.put(" Зм", 22);
    freq.put(" Зн", 47);
    freq.put(" Зл", 11);
    freq.put("Кир", 13);
    freq.put("Кит", 23);
    freq.put("ят ", 19);
    freq.put("ке ", 244);
    freq.put("Киє", 125);
    freq.put("Киї", 117);
    freq.put("Фот", 40);
    freq.put("ших", 79);
    freq.put(" Зр", 15);
    freq.put("ївс", 100);
    freq.put("ївщ", 9);
    freq.put("ц ", 69);
    freq.put("юєш", 10);
    freq.put("юєт", 30);
    freq.put("чна", 88);
    freq.put("їм ", 84);
    freq.put("бсо", 17);
    freq.put("бсл", 10);
    freq.put("рмі", 38);
    freq.put("що", 1875);
    freq.put("ща", 201);
    freq.put("ще", 631);
    freq.put("рхо", 47);
    freq.put("рму", 49);
    freq.put("из ", 9);
    freq.put("рме", 15);
    freq.put("аа ", 49);
    freq.put("рма", 187);
    freq.put("рмо", 55);
    freq.put("рмл", 10);
    freq.put("щі", 90);
    freq.put("щь", 56);
    freq.put("щу", 49);
    freq.put("бст", 30);
    freq.put("зці", 10);
    freq.put("дяк", 91);
    freq.put("дям", 27);
    freq.put("дян", 49);
    freq.put("дяг", 20);
    freq.put("хз ", 9);
    freq.put("чку", 51);
    freq.put("сяч", 79);
    freq.put("сяц", 71);
    freq.put("сят", 60);
    freq.put("щью", 56);
    freq.put("сяг", 27);
    freq.put("ро ", 900);
    freq.put("сяк", 13);
    freq.put("чко", 85);
    freq.put("чки", 85);
    freq.put("дят", 74);
    freq.put("дяч", 29);
    freq.put("чка", 118);
    freq.put("вши", 35);
    freq.put("ммм", 13);
    freq.put("вша", 13);
    freq.put("ї", 4494);
    freq.put("юба", 10);
    freq.put("юбл", 147);
    freq.put("юби", 71);
    freq.put("юбо", 55);
    freq.put("си ", 134);
    freq.put(" С ", 17);
    freq.put("Дру", 44);
    freq.put("мо ", 389);
    freq.put("Ф ", 19);
    freq.put("їть", 19);
    freq.put("ойк", 12);
    freq.put("ває", 170);
    freq.put("уйн", 19);
    freq.put("вас", 79);
    freq.put("вар", 260);
    freq.put("ват", 741);
    freq.put("вах", 16);
    freq.put("вач", 61);
    freq.put("вац", 12);
    freq.put("ваш", 48);
    freq.put("ваю", 156);
    freq.put("ваг", 87);
    freq.put("вав", 226);
    freq.put("вад", 36);
    freq.put("важ", 188);
    freq.put("вай", 82);
    freq.put("вал", 660);
    freq.put("вак", 49);
    freq.put("ван", 761);
    freq.put("вам", 125);
    freq.put("уйт", 55);
    freq.put("уйс", 10);
    freq.put("ойд", 25);
    freq.put("ТЬ ", 23);
    freq.put("Фін", 9);
    freq.put("Філ", 22);
    freq.put("іо ", 37);
    freq.put("че", 1319);
    freq.put("ча", 1489);
    freq.put("чо", 686);
    freq.put("чн", 964);
    freq.put("чл", 18);
    freq.put("чк", 347);
    freq.put("чи", 1639);
    freq.put("ціо", 111);
    freq.put("цін", 93);
    freq.put("ціл", 79);
    freq.put("ул ", 47);
    freq.put("цій", 202);
    freq.put("ців", 258);
    freq.put("ціа", 101);
    freq.put("ція", 336);
    freq.put("чі", 541);
    freq.put("чє", 20);
    freq.put("ш", 5272);
    freq.put("чч", 93);
    freq.put("чц", 21);
    freq.put("чу", 762);
    freq.put("чт", 14);
    freq.put("чя", 37);
    freq.put("во ", 521);
    freq.put("Фір", 11);
    freq.put("іми", 17);
    freq.put("імк", 9);
    freq.put("імн", 43);
    freq.put("імп", 70);
    freq.put("імо", 21);
    freq.put("іма", 80);
    freq.put("іме", 98);
    freq.put("уно", 45);
    freq.put("луз", 15);
    freq.put("луж", 59);
    freq.put("луб", 54);
    freq.put("унк", 69);
    freq.put("луг", 42);
    freq.put("лув", 17);
    freq.put("лун", 22);
    freq.put("вмі", 56);
    freq.put("лук", 14);
    freq.put(" А ", 283);
    freq.put(" о ", 125);
    freq.put("вми", 13);
    freq.put("уні", 102);
    freq.put("лух", 113);
    freq.put("яху", 10);
    freq.put("луч", 73);
    freq.put("луц", 25);
    freq.put("лур", 9);
    freq.put("лут", 13);
    freq.put("уну", 10);
    freq.put("унт", 22);
    freq.put("імі", 53);
    freq.put("іму", 17);
    freq.put("жку", 23);
    freq.put("рю ", 39);
    freq.put("Євг", 17);
    freq.put("гг ", 9);
    freq.put("О", 862);
    freq.put("но ", 1733);
    freq.put("іса", 18);
    freq.put("жки", 42);
    freq.put("жко", 56);
    freq.put("Євр", 142);
    freq.put("оін", 12);
    freq.put("жка", 31);
    freq.put("гет", 26);
    freq.put("гер", 40);
    freq.put("ягу", 11);
    freq.put("Сім", 16);
    freq.put("ягл", 9);
    freq.put("ягн", 56);
    freq.put("яго", 26);
    freq.put("яга", 42);
    freq.put("гед", 9);
    freq.put("гео", 11);
    freq.put("са ", 97);
    freq.put("гел", 15);
    freq.put("Хм", 33);
    freq.put("лом", 114);
    freq.put("Хо", 116);
    freq.put("лок", 81);
    freq.put("лол", 15);
    freq.put("Хл", 17);
    freq.put("Хе", 23);
    freq.put("лоз", 14);
    freq.put("лод", 279);
    freq.put("лов", 553);
    freq.put("Ха", 115);
    freq.put("лоб", 36);
    freq.put("кби", 32);
    freq.put(" шу", 61);
    freq.put(" шт", 71);
    freq.put(" шл", 41);
    freq.put(" шк", 156);
    freq.put(" ши", 32);
    freq.put(" шп", 22);
    freq.put("ав ", 871);
    freq.put(" шв", 68);
    freq.put(" ша", 95);
    freq.put(" ше", 50);
    freq.put("лош", 30);
    freq.put("лощ", 30);
    freq.put("лоч", 54);
    freq.put("лох", 25);
    freq.put("лот", 66);
    freq.put("Хр", 18);
    freq.put("лор", 43);
    freq.put("Хт", 75);
    freq.put("лої", 11);
    freq.put("Хі", 17);
    freq.put(" Не", 268);
    freq.put(" На", 759);
    freq.put(" Но", 269);
    freq.put(" ун", 67);
    freq.put(" Ни", 11);
    freq.put("йну", 36);
    freq.put("ик", 2110);
    freq.put("ил", 1632);
    freq.put("ии", 32);
    freq.put("ий", 2940);
    freq.put("ип", 392);
    freq.put("им", 1982);
    freq.put("ин", 2878);
    freq.put("ив", 2305);
    freq.put("иг", 293);
    freq.put("иб", 465);
    freq.put("иж", 250);
    freq.put("из", 373);
    freq.put("ид", 659);
    freq.put("ие", 23);
    freq.put("адя", 55);
    freq.put("ген", 82);
    freq.put(" уб", 18);
    freq.put("адц", 14);
    freq.put("аду", 152);
    freq.put("адт", 20);
    freq.put("адс", 59);
    freq.put("адр", 47);
    freq.put("ижч", 35);
    freq.put("аді", 254);
    freq.put("тфо", 16);
    freq.put("Ква", 13);
    freq.put(" Г", 651);
    freq.put("ДР ", 10);
    freq.put("адо", 135);
    freq.put("адн", 94);
    freq.put("адм", 28);
    freq.put("адл", 9);
    freq.put("адк", 68);
    freq.put("ади", 279);
    freq.put("адз", 35);
    freq.put("адж", 57);
    freq.put("аде", 63);
    freq.put("адв", 20);
    freq.put("ада", 394);
    freq.put(" Нє", 13);
    freq.put("иш", 557);
    freq.put("ищ", 136);
    freq.put("ию", 33);
    freq.put("ия", 109);
    freq.put("ит", 3058);
    freq.put("ир", 759);
    freq.put("ис", 2255);
    freq.put("иц", 661);
    freq.put("ич", 836);
    freq.put("иф", 65);
    freq.put("их", 1493);
    freq.put(" Ну", 73);
    freq.put("иї", 213);
    freq.put("иє", 262);
    freq.put("С ", 180);
    freq.put("зьк", 72);
    freq.put("зьм", 22);
    freq.put("Усп", 9);
    freq.put("би ", 260);
    freq.put("дО ", 36);
    freq.put("ЧА ", 11);
    freq.put("йця", 15);
    freq.put("ми ", 1049);
    freq.put("ієт", 21);
    freq.put(" У ", 660);
    freq.put("бод", 81);
    freq.put("бож", 36);
    freq.put("е", 34456);
    freq.put("бов", 119);
    freq.put("ієш", 19);
    freq.put("бом", 60);
    freq.put("бой", 14);
    freq.put("бок", 64);
    freq.put("бол", 168);
    freq.put("боч", 41);
    freq.put("бор", 448);
    freq.put("бот", 188);
    freq.put("бою", 84);
    freq.put("боя", 10);
    freq.put("боє", 15);
    freq.put(" Ко", 361);
    freq.put("дхо", 24);
    freq.put("іод", 21);
    freq.put("іон", 330);
    freq.put("іол", 25);
    freq.put("уле", 10);
    freq.put("ула", 205);
    freq.put("уло", 256);
    freq.put("вої", 236);
    freq.put("ули", 215);
    freq.put("воє", 124);
    freq.put("воя", 22);
    freq.put("вою", 139);
    freq.put("ч ", 442);
    freq.put("вот", 12);
    freq.put("вос", 136);
    freq.put("вор", 423);
    freq.put("воч", 13);
    freq.put("вох", 30);
    freq.put("вол", 225);
    freq.put("вок", 65);
    freq.put("вой", 10);
    freq.put("улі", 40);
    freq.put("воп", 9);
    freq.put("воо", 10);
    freq.put("вон", 346);
    freq.put("вом", 101);
    freq.put("вог", 214);
    freq.put("вов", 166);
    freq.put("воб", 75);
    freq.put("воз", 27);
    freq.put("вод", 196);
    freq.put("улу", 9);
    freq.put("уль", 195);
    freq.put("уля", 88);
    freq.put("улю", 34);
    freq.put("іот", 47);
    freq.put("іор", 14);
    freq.put(" уч", 77);
    freq.put("ім ", 339);
    freq.put(" ой", 26);
    freq.put(" ол", 26);
    freq.put(" ок", 106);
    freq.put(" он", 40);
    freq.put(" ом", 20);
    freq.put(" оп", 184);
    freq.put(" оо", 11);
    freq.put(" об", 610);
    freq.put(" ог", 83);
    freq.put(" ов", 11);
    freq.put(" од", 396);
    freq.put(" оз", 37);
    freq.put("лу ", 155);
    freq.put("ун ", 16);
    freq.put(" ош", 11);
    freq.put(" ос", 396);
    freq.put(" ор", 108);
    freq.put(" от", 285);
    freq.put(" ох", 45);
    freq.put(" оф", 70);
    freq.put(" оч", 122);
    freq.put("іжк", 39);
    freq.put("іжи", 10);
    freq.put("жда", 24);
    freq.put("жде", 56);
    freq.put("ждж", 15);
    freq.put("жди", 144);
    freq.put("зкі", 10);
    freq.put("рюв", 28);
    freq.put("штр", 26);
    freq.put("зку", 26);
    freq.put("зкр", 12);
    freq.put("нок", 198);
    freq.put("нол", 46);
    freq.put("ном", 393);
    freq.put("нон", 13);
    freq.put("ноп", 125);
    freq.put("ноб", 16);
    freq.put("нов", 837);
    freq.put("ног", 568);
    freq.put("нод", 34);
    freq.put("нож", 13);
    freq.put("ноз", 56);
    freq.put("шту", 77);
    freq.put(" х ", 19);
    freq.put("ишс", 14);
    freq.put("ної", 315);
    freq.put("нош", 14);
    freq.put("іат", 38);
    freq.put("ною", 219);
    freq.put("нор", 101);
    freq.put("нос", 224);
    freq.put("нот", 28);
    freq.put("ноу", 16);
    freq.put("ноф", 13);
    freq.put("ноч", 107);
    freq.put("зко", 61);
    freq.put("зкл", 9);
    freq.put("зки", 18);
    freq.put("рюю", 17);
    freq.put("ре ", 133);
    freq.put("зка", 51);
    freq.put("рює", 20);
    freq.put("сат", 80);
    freq.put("сар", 12);
    freq.put("уце", 36);
    freq.put("сац", 16);
    freq.put("сах", 34);
    freq.put(" ці", 307);
    freq.put("б", 11331);
    freq.put(" цу", 18);
    freq.put(" ць", 160);
    freq.put(" ця", 29);
    freq.put(" цю", 27);
    freq.put(" цв", 15);
    freq.put(" це", 862);
    freq.put(" ци", 90);
    freq.put("усі", 150);
    freq.put("сал", 58);
    freq.put("уць", 159);
    freq.put("сай", 69);
    freq.put("сам", 270);
    freq.put("сан", 117);
    freq.put("сав", 49);
    freq.put("З ", 146);
    freq.put("саж", 34);
    freq.put("сад", 78);
    freq.put("ОМ ", 9);
    freq.put("уці", 31);
    freq.put("яг ", 18);
    freq.put("АІ ", 20);
    freq.put(" Ла", 41);
    freq.put("озв", 130);
    freq.put(" Ле", 61);
    freq.put(" Ли", 36);
    freq.put("озг", 43);
    freq.put(" Ло", 41);
    freq.put("Х ", 26);
    freq.put("ло ", 668);
    freq.put("авч", 101);
    freq.put("авц", 35);
    freq.put("авс", 160);
    freq.put("авр", 31);
    freq.put("аву", 89);
    freq.put("авт", 371);
    freq.put("авщ", 13);
    freq.put("авш", 10);
    freq.put("аві", 301);
    freq.put("озк", 74);
    freq.put("Дм", 14);
    freq.put("аве", 116);
    freq.put("авд", 182);
    freq.put("авж", 181);
    freq.put("ПР ", 23);
    freq.put("ава", 369);
    freq.put("авн", 236);
    freq.put("авм", 19);
    freq.put("авп", 20);
    freq.put("аво", 192);
    freq.put("ави", 350);
    freq.put("авл", 152);
    freq.put("авк", 116);
    freq.put("ґ", 43);
    freq.put(" Лі", 80);
    freq.put("ЖЕ ", 14);
    freq.put(" Лу", 213);
    freq.put(" Лю", 95);
    freq.put(" Ля", 16);
    freq.put(" Ль", 334);
    freq.put("Ї", 39);
    freq.put("и ", 13031);
    freq.put("зти", 11);
    freq.put("хен", 10);
    freq.put("хем", 10);
    freq.put(" Н ", 10);
    freq.put("бхі", 19);
    freq.put("ША ", 65);
    freq.put("Оль", 12);
    freq.put("Олі", 33);
    freq.put("Іра", 12);
    freq.put("ад ", 176);
    freq.put("Оле", 70);
    freq.put("хеш", 10);
    freq.put("хер", 10);
    freq.put("Хло", 14);
    freq.put(" Ще", 43);
    freq.put("Са", 89);
    freq.put("Св", 123);
    freq.put("Се", 107);
    freq.put("зь ", 14);
    freq.put("Си", 58);
    freq.put("Сл", 54);
    freq.put("Ск", 87);
    freq.put("Сн", 20);
    freq.put("См", 29);
    freq.put("Сп", 100);
    freq.put("Со", 98);
    freq.put(" й ", 176);
    freq.put("бив", 147);
    freq.put("бид", 14);
    freq.put("бил", 103);
    freq.put("бий", 9);
    freq.put("бин", 22);
    freq.put("бит", 240);
    freq.put("бир", 115);
    freq.put("бис", 21);
    freq.put("биц", 10);
    freq.put("биш", 18);
    freq.put("ИК ", 10);
    freq.put("ощ ", 25);
    freq.put("Су", 100);
    freq.put("Ст", 214);
    freq.put("Сх", 19);
    freq.put("Сь", 127);
    freq.put("Сі", 39);
    freq.put("мив", 21);
    freq.put("мин", 59);
    freq.put("мим", 14);
    freq.put("мил", 90);
    freq.put("мик", 12);
    freq.put("мий", 56);
    freq.put("бо ", 270);
    freq.put(" Ук", 904);
    freq.put(" Ул", 9);
    freq.put(" Уп", 13);
    freq.put(" Ун", 14);
    freq.put(" Ув", 9);
    freq.put(" Уг", 12);
    freq.put(" Уж", 44);
    freq.put(" Уд", 12);
    freq.put(" Ур", 44);
    freq.put(" Ус", 28);
    freq.put(" Уч", 19);
    freq.put("мих", 16);
    freq.put("мит", 73);
    freq.put("мис", 38);
    freq.put("мир", 163);
    freq.put("Юрі", 32);
    freq.put("дчу", 80);
    freq.put("тчу", 14);
    freq.put("фут", 65);
    freq.put("Гі", 21);
    freq.put("Гу", 46);
    freq.put(" же", 86);
    freq.put("Гр", 117);
    freq.put("Гл", 23);
    freq.put("Зда", 20);
    freq.put("Го", 166);
    freq.put("Га", 142);
    freq.put("Ге", 69);
    freq.put(" жи", 292);
    freq.put("бмі", 30);
    freq.put("фув", 19);
    freq.put("Юри", 11);
    freq.put("дчи", 11);
    freq.put("тв ", 27);
    freq.put("єв ", 14);
    freq.put("тас", 25);
    freq.put("тар", 299);
    freq.put("Рок", 12);
    freq.put("тах", 52);
    freq.put("Ром", 29);
    freq.put("тач", 48);
    freq.put("тац", 50);
    freq.put("Роб", 21);
    freq.put("таш", 25);
    freq.put("Роз", 83);
    freq.put("таю", 132);
    freq.put("тає", 126);
    freq.put("Хто", 75);
    freq.put("таб", 54);
    freq.put("таа", 10);
    freq.put("таг", 14);
    freq.put("тав", 422);
    freq.put("тад", 26);
    freq.put("таж", 54);
    freq.put("тай", 88);
    freq.put("тал", 385);
    freq.put("так", 1170);
    freq.put("тан", 599);
    freq.put("там", 265);
    freq.put("тап", 14);
    freq.put("дн ", 11);
    freq.put("уп ", 32);
    freq.put("хєр", 10);
    freq.put("йш", 260);
    freq.put("йс", 441);
    freq.put("йр", 14);
    freq.put("йт", 368);
    freq.put("йф", 21);
    freq.put("йч", 18);
    freq.put("йц", 55);
    freq.put("цік", 134);
    freq.put("йл", 55);
    freq.put("йк", 167);
    freq.put("йн", 620);
    freq.put("йм", 164);
    freq.put("йп", 33);
    freq.put("йо", 540);
    freq.put("йб", 140);
    freq.put("йв", 51);
    freq.put("йд", 285);
    freq.put("йз", 9);
    freq.put("йж", 99);
    freq.put("іт ", 146);
    freq.put("іру", 38);
    freq.put("цію", 164);
    freq.put("іря", 34);
    freq.put("ірю", 21);
    freq.put("ірш", 34);
    freq.put("убл", 53);
    freq.put("убк", 27);
    freq.put("дпи", 56);
    freq.put("уби", 31);
    freq.put("дпо", 136);
    freq.put("убо", 64);
    freq.put("убн", 12);
    freq.put("уба", 19);
    freq.put("убе", 28);
    freq.put("вк ", 20);
    freq.put("й", 8103);
    freq.put("НУ ", 16);
    freq.put("Т ", 67);
    freq.put("йс ", 11);
    freq.put("№ ", 51);
    freq.put("убу", 12);
    freq.put("дпу", 27);
    freq.put("дпр", 56);
    freq.put("жи ", 37);
    freq.put("іра", 24);
    freq.put("ірв", 34);
    freq.put("ірн", 146);
    freq.put("ірм", 15);
    freq.put("іро", 76);
    freq.put("убі", 36);
    freq.put("ірк", 78);
    freq.put("юст", 9);
    freq.put("нк ", 36);
    freq.put("єра", 26);
    freq.put("єро", 9);
    freq.put("юся", 63);
    freq.put("юсь", 159);
    freq.put("єри", 13);
    freq.put("Кри", 60);
    freq.put("жор", 30);
    freq.put("Кра", 46);
    freq.put("шті", 77);
    freq.put("Кре", 21);
    freq.put(" Єв", 165);
    freq.put("зву", 37);
    freq.put("прі", 39);
    freq.put("чь", 19);
    freq.put("ше ", 608);
    freq.put("вий", 432);
    freq.put("вил", 320);
    freq.put("вик", 214);
    freq.put("вин", 454);
    freq.put("вим", 169);
    freq.put("вип", 158);
    freq.put("пру", 19);
    freq.put("виб", 300);
    freq.put("аю ", 498);
    freq.put("виг", 103);
    freq.put("вив", 151);
    freq.put("вид", 244);
    freq.put("виз", 83);
    freq.put("виж", 13);
    freq.put("вищ", 63);
    freq.put("пре", 290);
    freq.put("пра", 740);
    freq.put("вия", 45);
    freq.put("вис", 252);
    freq.put("вир", 137);
    freq.put("про", 2270);
    freq.put("вит", 286);
    freq.put("вих", 241);
    freq.put("вич", 284);
    freq.put("виц", 13);
    freq.put("вяч", 9);
    freq.put("зві", 119);
    freq.put("жод", 24);
    freq.put("жов", 57);
    freq.put("жон", 9);
    freq.put("жок", 12);
    freq.put("што", 63);
    freq.put("шти", 19);
    freq.put("ште", 12);
    freq.put("шта", 47);
    freq.put("Крі", 16);
    freq.put("ним", 292);
    freq.put("нин", 53);
    freq.put("ник", 755);
    freq.put("нил", 99);
    freq.put("ний", 1060);
    freq.put("ниж", 63);
    freq.put("низ", 26);
    freq.put("нив", 43);
    freq.put("ниг", 57);
    freq.put("ниб", 15);
    freq.put("Вол", 202);
    freq.put("Вон", 30);
    freq.put("гти", 37);
    freq.put("Вод", 10);
    freq.put("Вор", 16);
    freq.put("спо", 350);
    freq.put("ниш", 9);
    freq.put("нищ", 15);
    freq.put("ниц", 274);
    freq.put("нич", 66);
    freq.put("них", 518);
    freq.put("нит", 103);
    freq.put("нис", 12);
    freq.put("еп ", 20);
    freq.put(" П ", 24);
    freq.put("кіш", 11);
    freq.put("скр", 40);
    freq.put("кіс", 100);
    freq.put("ску", 80);
    freq.put("скі", 84);
    freq.put("кіл", 193);
    freq.put("аж ", 68);
    freq.put("кій", 137);
    freq.put("скл", 101);
    freq.put("кіп", 16);
    freq.put("скн", 17);
    freq.put("кін", 239);
    freq.put("кім", 28);
    freq.put("ска", 338);
    freq.put("ків", 658);
    freq.put("скв", 28);
    freq.put("ске", 16);
    freq.put("кід", 10);
    freq.put("ене", 610);
    freq.put("енд", 118);
    freq.put("енз", 22);
    freq.put("ена", 198);
    freq.put("енн", 880);
    freq.put("енп", 12);
    freq.put("ено", 226);
    freq.put("ени", 206);
    freq.put("енк", 350);
    freq.put("тра", 747);
    freq.put("тре", 362);
    freq.put("три", 497);
    freq.put("тро", 327);
    freq.put("Сар", 11);
    freq.put("ФК ", 9);
    freq.put("иєд", 15);
    freq.put("иєв", 130);
    freq.put("аин", 16);
    freq.put("трі", 482);
    freq.put("иєм", 95);
    freq.put("тру", 153);
    freq.put("трь", 26);
    freq.put("тря", 29);
    freq.put("енч", 12);
    freq.put("енц", 69);
    freq.put("енс", 87);
    freq.put("ену", 56);
    freq.put("ент", 591);
    freq.put("ень", 642);
    freq.put("еня", 23);
    freq.put("еню", 19);
    freq.put("енщ", 11);
    freq.put("енш", 69);
    freq.put("ені", 685);
    freq.put("унд", 20);
    freq.put("МУ ", 11);
    freq.put("тві", 268);
    freq.put("мки", 53);
    freq.put("мкн", 15);
    freq.put("мко", 16);
    freq.put("мка", 49);
    freq.put("уна", 36);
    freq.put("тву", 15);
    freq.put("Луч", 9);
    freq.put(" Хм", 33);
    freq.put(" Хо", 116);
    freq.put(" Хл", 17);
    freq.put(" Хе", 23);
    freq.put(" Ха", 111);
    freq.put("ГА ", 9);
    freq.put(" Хр", 18);
    freq.put("фу ", 12);
    freq.put(" Ху", 11);
    freq.put(" Хі", 17);
    freq.put("Г ", 16);
    freq.put("тво", 359);
    freq.put("бз", 10);
    freq.put("тви", 32);
    freq.put("тве", 79);
    freq.put("тва", 111);
    freq.put("гля", 191);
    freq.put("глю", 10);
    freq.put("хір", 13);
    freq.put("хіт", 23);
    freq.put("нча", 9);
    freq.put("нче", 34);
    freq.put("нчи", 65);
    freq.put("зве", 52);
    freq.put("та ", 1225);
    freq.put("нчу", 30);
    freq.put("хім", 17);
    freq.put("хін", 11);
    freq.put("хів", 32);
    freq.put("хід", 187);
    freq.put("іту", 93);
    freq.put("ітт", 106);
    freq.put("ітс", 9);
    freq.put("ітр", 45);
    freq.put("ітч", 20);
    freq.put("ітя", 23);
    freq.put("іть", 314);
    freq.put("дна", 161);
    freq.put("Арт", 13);
    freq.put("Арс", 9);
    freq.put("упе", 60);
    freq.put("дне", 84);
    freq.put("дни", 222);
    freq.put("упи", 166);
    freq.put("упл", 24);
    freq.put("упк", 10);
    freq.put("упн", 89);
    freq.put("дно", 360);
    freq.put("упо", 33);
    freq.put("ччя", 36);
    freq.put("й ", 4669);
    freq.put("ччи", 48);
    freq.put("упр", 32);
    freq.put("упу", 46);
    freq.put("дну", 68);
    freq.put("Аре", 13);
    freq.put("упц", 31);
    freq.put("днь", 20);
    freq.put("дня", 170);
    freq.put("ітв", 10);
    freq.put("іта", 319);
    freq.put("дні", 699);
    freq.put("упі", 31);
    freq.put("ітл", 58);
    freq.put("ітк", 50);
    freq.put("іти", 330);
    freq.put("іто", 90);
    freq.put("ітн", 175);
    freq.put("оєю", 16);
    freq.put("шру", 34);
    freq.put("уб ", 24);
    freq.put("жис", 20);
    freq.put("жир", 41);
    freq.put("жит", 286);
    freq.put("оєї", 33);
    freq.put("Тр", 102);
    freq.put("Ту", 47);
    freq.put("Тю", 10);
    freq.put("Тя", 16);
    freq.put("йсь", 281);
    freq.put("йся", 27);
    freq.put("вка", 85);
    freq.put("вко", 55);
    freq.put("вкл", 27);
    freq.put("пця", 11);
    freq.put("вки", 74);
    freq.put("йсн", 45);
    freq.put("вку", 67);
    freq.put("йси", 9);
    freq.put("вкр", 14);
    freq.put("вкі", 12);
    freq.put("Та", 244);
    freq.put("Тв", 44);
    freq.put("То", 101);
    freq.put("Ти", 197);
    freq.put("ір ", 174);
    freq.put("жин", 39);
    freq.put("жим", 26);
    freq.put("оєн", 15);
    freq.put("оєм", 54);
    freq.put("жил", 24);
    freq.put("жик", 20);
    freq.put("жиг", 9);
    freq.put("жив", 135);
    freq.put("НС ", 29);
    freq.put("Фер", 11);
    freq.put("Фес", 10);
    freq.put(" Є ", 35);
    freq.put("нка", 235);
    freq.put("єр ", 50);
    freq.put("нко", 333);
    freq.put("нки", 129);
    freq.put("ви ", 371);
    freq.put("Вал", 30);
    freq.put("Вак", 18);
    freq.put("Вам", 22);
    freq.put("гри", 100);
    freq.put("грн", 79);
    freq.put("гро", 196);
    freq.put("гра", 459);
    freq.put("шен", 253);
    freq.put("гре", 34);
    freq.put("гру", 122);
    freq.put("ь", 13862);
    freq.put("Вас", 43);
    freq.put("Вар", 29);
    freq.put("пр ", 22);
    freq.put("аюс", 75);
    freq.put("Ваш", 22);
    freq.put("ают", 430);
    freq.put("аюч", 71);
    freq.put("нкц", 13);
    freq.put("нкт", 21);
    freq.put("нку", 307);
    freq.put("шт ", 10);
    freq.put("нкі", 141);
    freq.put("ни ", 1217);
    freq.put("еєс", 37);
    freq.put(" По", 559);
    freq.put(" Пл", 33);
    freq.put(" Пи", 27);
    freq.put(" Пе", 177);
    freq.put(" Па", 182);
    freq.put("епа", 35);
    freq.put("гла", 57);
    freq.put("епе", 173);
    freq.put("епл", 80);
    freq.put("епи", 25);
    freq.put("епо", 104);
    freq.put("Т", 1138);
    freq.put("Сві", 36);
    freq.put("ажі", 28);
    freq.put("ажу", 91);
    freq.put("ажч", 11);
    freq.put("Кар", 74);
    freq.put("тте", 78);
    freq.put("Кат", 20);
    freq.put("єві", 90);
    freq.put("Свя", 28);
    freq.put("ття", 279);
    freq.put("ажа", 173);
    freq.put("Кал", 19);
    freq.put("Кан", 34);
    freq.put("Кам", 12);
    freq.put("Кап", 14);
    freq.put("ск ", 41);
    freq.put("ажи", 91);
    freq.put("ажл", 33);
    freq.put("кі ", 578);
    freq.put("ажн", 26);
    freq.put("Сво", 49);
    freq.put("уар", 10);
    freq.put("тті", 82);
    freq.put("ттє", 15);
    freq.put("епу", 137);
    freq.put("епт", 16);
    freq.put("епр", 53);
    freq.put(" Пі", 190);
    freq.put("епі", 23);
    freq.put(" Пш", 9);
    freq.put(" Пу", 27);
    freq.put(" Пр", 603);
    freq.put("ен ", 139);
    freq.put("тр ", 89);
    freq.put("Опо", 27);
    freq.put("иє ", 15);
    freq.put("Схі", 10);
    freq.put("км", 21);
    freq.put("ело", 105);
    freq.put("ко", 5187);
    freq.put("ки", 3249);
    freq.put("кк", 16);
    freq.put("ели", 171);
    freq.put("кд", 11);
    freq.put("ке", 450);
    freq.put("еле", 247);
    freq.put("кз", 42);
    freq.put("ка", 4411);
    freq.put("кб", 37);
    freq.put("кв", 295);
    freq.put("ела", 45);
    freq.put("Був", 11);
    freq.put("Буд", 43);
    freq.put("Бул", 10);
    freq.put("Бук", 24);
    freq.put("акі", 175);
    freq.put("акш", 15);
    freq.put("акц", 89);
    freq.put("акс", 46);
    freq.put("акр", 59);
    freq.put("аку", 94);
    freq.put("акт", 220);
    freq.put("ако", 309);
    freq.put("аки", 275);
    freq.put("акл", 69);
    freq.put("аке", 148);
    freq.put(" юр", 10);
    freq.put(" ют", 26);
    freq.put("ака", 249);
    freq.put("Бур", 9);
    freq.put("тюр", 18);
    freq.put("еля", 41);
    freq.put("елю", 17);
    freq.put("ель", 200);
    freq.put("кш", 35);
    freq.put("кщ", 208);
    freq.put("кц", 173);
    freq.put("кр", 2507);
    freq.put("кс", 434);
    freq.put("кт", 665);
    freq.put("ку", 2637);
    freq.put("елі", 123);
    freq.put("кі", 2013);
    freq.put("ьбо", 31);
    freq.put("ьби", 10);
    freq.put("ьба", 15);
    freq.put("Г", 655);
    freq.put("ще ", 492);
    freq.put("Ого", 10);
    freq.put("ГО ", 20);
    freq.put("На", 765);
    freq.put("іди", 31);
    freq.put("чує", 36);
    freq.put("ж ", 644);
    freq.put("ідл", 29);
    freq.put("дує", 41);
    freq.put("дую", 39);
    freq.put("душ", 51);
    freq.put("дуч", 13);
    freq.put("дух", 14);
    freq.put("дут", 118);
    freq.put("дур", 54);
    freq.put("дус", 20);
    freq.put("ок ", 654);
    freq.put("то ", 1322);
    freq.put("тл", 112);
    freq.put("дуп", 10);
    freq.put("дум", 304);
    freq.put("дук", 33);
    freq.put("дуж", 214);
    freq.put("дув", 100);
    freq.put("дуб", 9);
    freq.put(" №", 52);
    freq.put("Яну", 138);
    freq.put("Бож", 12);
    freq.put("Бог", 25);
    freq.put("Бол", 10);
    freq.put("хв ", 11);
    freq.put("ну ", 1002);
    freq.put("тме", 10);
    freq.put("Бор", 35);
    freq.put("ріс", 34);
    freq.put("уг ", 31);
    freq.put("нса", 26);
    freq.put("ріт", 37);
    freq.put("нсе", 19);
    freq.put("нси", 15);
    freq.put("нсл", 25);
    freq.put("нсп", 56);
    freq.put("нсо", 48);
    freq.put("аїв", 25);
    freq.put("річ", 234);
    freq.put("Тві", 33);
    freq.put("аїн", 1227);
    freq.put("аїл", 17);
    freq.put("Тво", 11);
    freq.put("Да", 71);
    freq.put("нсу", 34);
    freq.put("нст", 102);
    freq.put("нсь", 622);
    freq.put("нсі", 50);
    freq.put("іфі", 16);
    freq.put("дло", 26);
    freq.put("НЯ ", 17);
    freq.put("ЩО ", 9);
    freq.put("дли", 29);
    freq.put(" І ", 168);
    freq.put("іфт", 10);
    freq.put("щів", 11);
    freq.put("чу ", 252);
    freq.put("Бі", 117);
    freq.put("Бр", 72);
    freq.put("Бу", 126);
    freq.put("ечи", 23);
    freq.put("Пет", 23);
    freq.put("Пер", 124);
    freq.put("Бю", 9);
    freq.put("Ба", 169);
    freq.put("Бе", 109);
    freq.put("Пен", 9);
    freq.put("Бл", 65);
    freq.put("Бо", 154);
    freq.put("длі", 12);
    freq.put("для", 418);
    freq.put("єму", 46);
    freq.put("Упр", 9);
    freq.put("ємс", 24);
    freq.put("ємц", 12);
    freq.put("Дня", 24);
    freq.put("Дні", 53);
    freq.put("Д ", 38);
    freq.put("Чор", 55);
    freq.put("Чог", 14);
    freq.put("Чол", 26);
    freq.put("Чом", 39);
    freq.put("рі ", 385);
    freq.put("оюз", 22);
    freq.put("оюв", 10);
    freq.put("Дне", 19);
    freq.put("ємо", 195);
    freq.put("ємн", 83);
    freq.put("яє ", 79);
    freq.put("зч", 18);
    freq.put("зц", 11);
    freq.put("зх", 9);
    freq.put("зф", 12);
    freq.put("зу", 644);
    freq.put("зт", 22);
    freq.put("зс", 52);
    freq.put("зр", 383);
    freq.put("зя", 90);
    freq.put("зь", 114);
    freq.put("зш", 14);
    freq.put("зі", 558);
    freq.put("зз", 14);
    freq.put("зе", 319);
    freq.put("зд", 408);
    freq.put("зг", 117);
    freq.put("зв", 630);
    freq.put("зб", 290);
    freq.put("за", 4256);
    freq.put("зп", 249);
    freq.put("зо", 383);
    freq.put("зн", 1287);
    freq.put("зм", 424);
    freq.put("зл", 129);
    freq.put("зк", 189);
    freq.put("зи", 731);
    freq.put("ал", 4722);
    freq.put("Ав", 53);
    freq.put("Аг", 20);
    freq.put("ьзи", 11);
    freq.put("Аб", 14);
    freq.put("Аз", 90);
    freq.put("Ад", 26);
    freq.put("Ак", 25);
    freq.put("Ал", 129);
    freq.put("к ", 3086);
    freq.put("Ам", 38);
    freq.put("Ан", 148);
    freq.put("еве", 45);
    freq.put(" ю ", 54);
    freq.put("вре", 10);
    freq.put("тю ", 95);
    freq.put("ври", 9);
    freq.put("ак ", 681);
    freq.put("лоп", 93);
    freq.put("Ар", 60);
    freq.put("Ас", 17);
    freq.put("Аф", 12);
    freq.put("Ах", 21);
    freq.put("Хер", 14);
    freq.put("лож", 9);
    freq.put("дст", 108);
    freq.put("дсу", 36);
    freq.put("дсь", 94);
    freq.put("евс", 39);
    freq.put("ріа", 103);
    freq.put("лог", 242);
    freq.put("щен", 111);
    freq.put("Ава", 14);
    freq.put("Авт", 26);
    freq.put("ці ", 729);
    freq.put("еві", 141);
    freq.put("рім", 30);
    freq.put("ою ", 890);
    freq.put("врі", 12);
    freq.put("жа", 552);
    freq.put("жб", 63);
    freq.put("жг", 39);
    freq.put("жд", 245);
    freq.put("же", 1706);
    freq.put("жж", 15);
    freq.put("жи", 668);
    freq.put("жк", 160);
    freq.put("жл", 107);
    freq.put("жн", 623);
    freq.put("жо", 167);
    freq.put("тоя", 24);
    freq.put("тою", 40);
    freq.put(" Що", 137);
    freq.put("Ц", 329);
    freq.put(" Ща", 15);
    freq.put("тот", 21);
    freq.put("тос", 120);
    freq.put("тор", 625);
    freq.put("точ", 114);
    freq.put("тоц", 13);
    freq.put("уко", 214);
    freq.put("ока", 195);
    freq.put("окз", 14);
    freq.put("оке", 19);
    freq.put("окл", 40);
    freq.put("оки", 187);
    freq.put("тої", 32);
    freq.put("око", 154);
    freq.put("оку", 317);
    freq.put("окт", 10);
    freq.put("окс", 28);
    freq.put("окр", 132);
    freq.put("тол", 114);
    freq.put("ток", 132);
    freq.put("той", 73);
    freq.put("топ", 99);
    freq.put("окі", 134);
    freq.put("тон", 63);
    freq.put("том", 448);
    freq.put("тог", 217);
    freq.put("тов", 268);
    freq.put("тоб", 223);
    freq.put("Пут", 17);
    freq.put("тож", 36);
    freq.put("тод", 90);
    freq.put("жр", 12);
    freq.put("жу", 624);
    freq.put("жц", 19);
    freq.put("жч", 69);
    freq.put("жі", 244);
    freq.put("ду ", 513);
    freq.put("Бо ", 28);
    freq.put(" шо", 254);
    freq.put("нул", 152);
    freq.put("нук", 137);
    freq.put("нуй", 17);
    freq.put("нуд", 10);
    freq.put("нув", 206);
    freq.put("нує", 75);
    freq.put("ную", 51);
    freq.put("Іва", 114);
    freq.put("нут", 184);
    freq.put("нус", 19);
    freq.put("іця", 59);
    freq.put("нс ", 41);
    freq.put("уго", 58);
    freq.put("уги", 47);
    freq.put("угл", 16);
    freq.put("уге", 20);
    freq.put("іці", 161);
    freq.put("уга", 55);
    freq.put("аї ", 25);
    freq.put("Пла", 21);
    freq.put("кит", 16);
    freq.put("угу", 30);
    freq.put("іце", 33);
    freq.put("угі", 11);
    freq.put(" Іг", 22);
    freq.put("оші", 64);
    freq.put("щі ", 68);
    freq.put(" Ід", 13);
    freq.put(" Із", 20);
    freq.put(" Іл", 14);
    freq.put(" Аф", 12);
    freq.put("єте", 80);
    freq.put("ючі", 14);
    freq.put("Ху", 11);
    freq.put("ошу", 72);
    freq.put("ошт", 92);
    freq.put("лос", 431);
    freq.put("чув", 103);
    freq.put("чуд", 99);
    freq.put("Уря", 27);
    freq.put("чуй", 11);
    freq.put("чул", 13);
    freq.put("чук", 64);
    freq.put("пту", 9);
    freq.put("пто", 12);
    freq.put("чут", 105);
    freq.put("пти", 27);
    freq.put("пта", 19);
    freq.put("чую", 27);
    freq.put("ища", 35);
    freq.put("Б ", 48);
    freq.put("ище", 49);
    freq.put("ищи", 21);
    freq.put("ищо", 10);
    freq.put("оше", 167);
    freq.put("оша", 11);
    freq.put("Уні", 12);
    freq.put("ошо", 19);
    freq.put("оши", 43);
    freq.put("ошк", 36);
    freq.put(" Іс", 40);
    freq.put(" Ір", 25);
    freq.put(" Іт", 20);
    freq.put("юча", 12);
    freq.put("єть", 506);
    freq.put("ючи", 128);
    freq.put("До", 334);
    freq.put("ріу", 9);
    freq.put("Дн", 97);
    freq.put("ріх", 11);
    freq.put("Дл", 35);
    freq.put("Ди", 120);
    freq.put("Дж", 54);
    freq.put("ріш", 162);
    freq.put("Де", 275);
    freq.put("Дв", 19);
    freq.put("рія", 128);
    freq.put("рію", 71);
    freq.put("ріє", 43);
    freq.put("рії", 129);
    freq.put("єм ", 37);
    freq.put("Ді", 57);
    freq.put("ріб", 141);
    freq.put("Дя", 51);
    freq.put("ріг", 46);
    freq.put("рів", 440);
    freq.put("рід", 54);
    freq.put("різ", 125);
    freq.put("ріж", 29);
    freq.put("рій", 131);
    freq.put("ріл", 77);
    freq.put("рік", 124);
    freq.put("рін", 86);
    freq.put("Ду", 65);
    freq.put("Др", 66);
    freq.put("ріо", 51);
    freq.put("Юлі", 18);
    freq.put("яєм", 12);
    freq.put("ЛЯ ", 9);
    freq.put("Гер", 32);
    freq.put("сит", 145);
    freq.put("сир", 26);
    freq.put("сис", 43);
    freq.put("сиф", 14);
    freq.put("сих", 23);
    freq.put("сиш", 9);
    freq.put("н", 44697);
    freq.put("сив", 52);
    freq.put("сид", 70);
    freq.put("з ", 2751);
    freq.put("сик", 20);
    freq.put("сил", 169);
    freq.put("сип", 37);
    freq.put("сим", 34);
    freq.put("син", 67);
    freq.put("Ген", 25);
    freq.put("яєш", 12);
    freq.put("яєт", 36);
  }
  
}

