package com.rmtheis.langdetect.profile;

import java.util.HashMap;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

public class VI {
  private static final String name = "vi";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public VI() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 209730;
    n_words[1] = 275958;
    n_words[2] = 202674;

    freq.put("oểi", 59);
    freq.put("rà ", 5);
    freq.put("oển", 80);
    freq.put("oểc", 22);
    freq.put("dã ", 16);
    freq.put("oểt", 21);
    freq.put("típ", 5);
    freq.put("tíc", 15);
    freq.put("tín", 59);
    freq.put("oể ", 3);
    freq.put("rào", 6);
    freq.put("ràn", 6);
    freq.put("ràu", 4);
    freq.put("Lư", 9);
    freq.put(" jể", 6);
    freq.put(" yê", 130);
    freq.put("ĐIể", 3);
    freq.put("tí ", 27);
    freq.put("lào", 4);
    freq.put("làn", 18);
    freq.put("làm", 309);
    freq.put("lày", 3);
    freq.put(" Ul", 3);
    freq.put(" y ", 16);
    freq.put("hoă", 5);
    freq.put("là ", 834);
    freq.put("ù", 371);
    freq.put(" yh", 8);
    freq.put(" yk", 3);
    freq.put(" yo", 19);
    freq.put(" ya", 10);
    freq.put("k", 3272);
    freq.put("oài", 53);
    freq.put(" yu", 6);
    freq.put("ED ", 3);
    freq.put("Lâ", 5);
    freq.put("Lã", 3);
    freq.put("Là", 22);
    freq.put("Lá", 6);
    freq.put("Lê", 10);
    freq.put("nô ", 3);
    freq.put("Lý", 5);
    freq.put("Lú", 6);
    freq.put("Lù", 5);
    freq.put("hoà", 42);
    freq.put("hoá", 34);
    freq.put("hoé", 3);
    freq.put("uăn", 7);
    freq.put("pé ", 6);
    freq.put("nôn", 8);
    freq.put("uân", 13);
    freq.put("hé ", 79);
    freq.put("Le", 24);
    freq.put("La", 38);
    freq.put("Lo", 36);
    freq.put("Ưể", 9);
    freq.put("Li", 36);
    freq.put("Lu", 12);
    freq.put("èm ", 36);
    freq.put("Ly", 5);
    freq.put("hoe", 11);
    freq.put("hoc", 18);
    freq.put("hoa", 45);
    freq.put("hon", 52);
    freq.put("hoo", 3);
    freq.put("hol", 4);
    freq.put("hom", 6);
    freq.put("hok", 28);
    freq.put("hoi", 24);
    freq.put("how", 31);
    freq.put("hot", 18);
    freq.put("hou", 7);
    freq.put("hos", 3);
    freq.put("hop", 7);
    freq.put("kô ", 3);
    freq.put("hox", 4);
    freq.put("hoy", 10);
    freq.put("A", 258);
    freq.put("L ", 43);
    freq.put("Mìn", 65);
    freq.put("ho ", 453);
    freq.put("ys ", 6);
    freq.put(" V ", 9);
    freq.put("Sển", 6);
    freq.put("Sểa", 6);
    freq.put("Sểc", 6);
    freq.put("Eun", 31);
    freq.put("Sểp", 4);
    freq.put("rô", 15);
    freq.put("rõ", 27);
    freq.put("rò", 33);
    freq.put("uot", 6);
    freq.put("rù", 53);
    freq.put("rú", 21);
    freq.put("uoc", 9);
    freq.put("fic", 23);
    freq.put("fia", 5);
    freq.put("rà", 22);
    freq.put("rá", 43);
    freq.put("râ", 6);
    freq.put("Hig", 3);
    freq.put("rì", 44);
    freq.put("rí", 25);
    freq.put("uoi", 17);
    freq.put("fin", 3);
    freq.put("uon", 25);
    freq.put("rê", 89);
    freq.put("fim", 8);
    freq.put(" Va", 4);
    freq.put(" Ve", 7);
    freq.put(" Vi", 80);
    freq.put("Sể ", 25);
    freq.put(" Vo", 8);
    freq.put(" Vn", 7);
    freq.put(" Vs", 3);
    freq.put(" Vu", 8);
    freq.put(" Vt", 5);
    freq.put("Hi ", 5);
    freq.put("fi ", 4);
    freq.put("õm ", 3);
    freq.put("àh ", 43);
    freq.put("rS", 4);
    freq.put(" ể ", 350);
    freq.put("ũi", 5);
    freq.put("ũn", 360);
    freq.put("hét", 58);
    freq.put("ũg", 24);
    freq.put("rt", 54);
    freq.put("ru", 123);
    freq.put("rv", 8);
    freq.put("rp", 4);
    freq.put("rr", 30);
    freq.put("rs", 18);
    freq.put("ry", 16);
    freq.put("rd", 33);
    freq.put("re", 174);
    freq.put("rf", 12);
    freq.put("rg", 33);
    freq.put("ra", 512);
    freq.put("rb", 4);
    freq.put("rc", 59);
    freq.put("rl", 40);
    freq.put("rm", 23);
    freq.put("rn", 17);
    freq.put("ro", 290);
    freq.put("ri", 128);
    freq.put("rk", 23);
    freq.put(" Và", 15);
    freq.put(" Vã", 4);
    freq.put(" Vâ", 8);
    freq.put(" ển", 166);
    freq.put(" ểo", 5);
    freq.put(" ểm", 31);
    freq.put(" Vé", 5);
    freq.put(" ểc", 23);
    freq.put(" ểa", 40);
    freq.put(" Vì", 12);
    freq.put(" ểy", 74);
    freq.put(" Vô", 4);
    freq.put("ũ ", 50);
    freq.put(" ểp", 7);
    freq.put(" ểt", 4);
    freq.put(" ểu", 4);
    freq.put("ate", 15);
    freq.put("atc", 3);
    freq.put("hg", 18);
    freq.put("ata", 4);
    freq.put("ati", 25);
    freq.put("att", 6);
    freq.put("atu", 3);
    freq.put("r ", 376);
    freq.put("sm ", 6);
    freq.put("̀", 3);
    freq.put("Dun", 3);
    freq.put(" Vĩ", 3);
    freq.put(" Vă", 22);
    freq.put("vể", 1027);
    freq.put("xin", 59);
    freq.put(" Vũ", 8);
    freq.put("xi ", 9);
    freq.put("rư", 115);
    freq.put("phể", 386);
    freq.put("í", 628);
    freq.put("rơ", 11);
    freq.put("kna", 3);
    freq.put("hua", 29);
    freq.put("cể", 1227);
    freq.put("máy", 47);
    freq.put(" fb", 16);
    freq.put("rũ", 4);
    freq.put("ră", 27);
    freq.put("uý ", 13);
    freq.put("가 ", 5);
    freq.put("Ã", 31);
    freq.put("nén", 3);
    freq.put("ném", 11);
    freq.put("uýt", 11);
    freq.put("X", 160);
    freq.put("net", 22);
    freq.put("neu", 4);
    freq.put("ƯểC", 3);
    freq.put("Rin", 3);
    freq.put(" Lê", 10);
    freq.put("wt ", 12);
    freq.put("ÊN ", 4);
    freq.put("meb", 8);
    freq.put("irt", 4);
    freq.put("irl", 26);
    freq.put("irm", 4);
    freq.put("iro", 3);
    freq.put("ira", 9);
    freq.put("irc", 3);
    freq.put("ire", 9);
    freq.put("ép ", 23);
    freq.put(" hể", 935);
    freq.put("DM ", 5);
    freq.put("VIể", 4);
    freq.put("oki", 12);
    freq.put("ir ", 6);
    freq.put("and", 41);
    freq.put("lâu", 48);
    freq.put("mes", 10);
    freq.put("íp ", 8);
    freq.put("fre", 6);
    freq.put("đy ", 4);
    freq.put("ểY ", 6);
    freq.put("ank", 34);
    freq.put("HN ", 9);
    freq.put("uy ", 42);
    freq.put("oàn", 160);
    freq.put("bil", 3);
    freq.put(" ye", 22);
    freq.put("Ok", 3);
    freq.put("êm ", 98);
    freq.put("uà ", 12);
    freq.put("wán", 3);
    freq.put("Oh", 23);
    freq.put("bí", 30);
    freq.put("rơi", 9);
    freq.put("Cư ", 12);
    freq.put("wá ", 30);
    freq.put("kMi", 3);
    freq.put(" áo", 37);
    freq.put("hah", 100);
    freq.put("hai", 99);
    freq.put("hak", 3);
    freq.put("ham", 40);
    freq.put("han", 157);
    freq.put("hao", 17);
    freq.put("hac", 14);
    freq.put("hae", 17);
    freq.put("bù", 17);
    freq.put("hay", 189);
    freq.put("haz", 3);
    freq.put("hap", 10);
    freq.put("har", 7);
    freq.put("hat", 23);
    freq.put("hau", 88);
    freq.put(" Xã", 4);
    freq.put("èo ", 30);
    freq.put("ha ", 201);
    freq.put("bn ", 3);
    freq.put("ola", 8);
    freq.put("old", 5);
    freq.put("ole", 4);
    freq.put("MP ", 4);
    freq.put(" íc", 3);
    freq.put("oli", 5);
    freq.put(" X ", 21);
    freq.put("oll", 12);
    freq.put("olo", 3);
    freq.put(" ít", 25);
    freq.put("ểểể", 6);
    freq.put("ump", 4);
    freq.put("for", 11);
    freq.put("fox", 3);
    freq.put("umb", 6);
    freq.put("umm", 7);
    freq.put("fon", 4);
    freq.put("foo", 3);
    freq.put("umi", 6);
    freq.put("ol ", 34);
    freq.put(" Xi", 11);
    freq.put(" í ", 28);
    freq.put(" Xa", 10);
    freq.put(" gơ", 5);
    freq.put(" Xe", 16);
    freq.put("Còn", 14);
    freq.put(" Xu", 10);
    freq.put("huô", 3);
    freq.put("o", 6854);
    freq.put("fo ", 11);
    freq.put("um ", 70);
    freq.put("khă", 8);
    freq.put("àj ", 3);
    freq.put("khù", 9);
    freq.put("khú", 4);
    freq.put("sof", 6);
    freq.put("soi", 6);
    freq.put("mbe", 3);
    freq.put("khó", 71);
    freq.put("khô", 147);
    freq.put("sol", 3);
    freq.put("soo", 9);
    freq.put("son", 17);
    freq.put("khí", 5);
    freq.put("khá", 95);
    freq.put("Nó ", 13);
    freq.put("còn", 206);
    freq.put("so ", 16);
    freq.put("sơ ", 4);
    freq.put("óa ", 39);
    freq.put("Nói", 10);
    freq.put("aza", 5);
    freq.put("Siw", 5);
    freq.put("khu", 28);
    freq.put("khi", 149);
    freq.put("khj", 3);
    freq.put("kho", 80);
    freq.put("kha", 13);
    freq.put("fân", 3);
    freq.put("Sim", 29);
    freq.put("E", 183);
    freq.put("Ido", 3);
    freq.put("kh ", 4);
    freq.put("Ú", 3);
    freq.put("Vì ", 12);
    freq.put("iây", 3);
    freq.put("hó ", 58);
    freq.put("Web", 3);
    freq.put("oss", 6);
    freq.put("ost", 30);
    freq.put("osh", 5);
    freq.put("oso", 4);
    freq.put("ose", 5);
    freq.put("Đôn", 13);
    freq.put("ver", 48);
    freq.put("ves", 9);
    freq.put("Đôi", 4);
    freq.put("mĩ ", 5);
    freq.put("sư", 41);
    freq.put("vey", 3);
    freq.put("Ta ", 8);
    freq.put("ươg", 4);
    freq.put("ven", 9);
    freq.put("ươi", 9);
    freq.put("sơ", 6);
    freq.put("ươn", 135);
    freq.put("hóc", 30);
    freq.put("hóa", 22);
    freq.put("Má", 19);
    freq.put("Mà", 31);
    freq.put("Mã", 6);
    freq.put("hóe", 7);
    freq.put("Mí", 3);
    freq.put(" ｡）", 3);
    freq.put("hói", 8);
    freq.put("hón", 17);
    freq.put("Mè", 3);
    freq.put("hóm", 17);
    freq.put("Mô", 4);
    freq.put("Mó", 3);
    freq.put("os ", 4);
    freq.put("Mú", 7);
    freq.put("bể", 1322);
    freq.put("Tae", 3);
    freq.put("ve ", 54);
    freq.put("Tal", 8);
    freq.put("Tam", 4);
    freq.put("Tai", 6);
    freq.put("M ", 136);
    freq.put("să", 4);
    freq.put("gét", 3);
    freq.put("tưn", 5);
    freq.put("sĩ", 11);
    freq.put("Me", 12);
    freq.put("Ma", 54);
    freq.put("Mo", 33);
    freq.put("Mn", 5);
    freq.put("Mi", 134);
    freq.put("Mu", 47);
    freq.put("Oá", 3);
    freq.put("Mr", 16);
    freq.put("Khể", 14);
    freq.put("My", 4);
    freq.put("tư ", 14);
    freq.put("út ", 44);
    freq.put("Tểt", 9);
    freq.put("rì ", 7);
    freq.put("Tểp", 8);
    freq.put("Tển", 17);
    freq.put("Tểm", 6);
    freq.put("Mư", 3);
    freq.put("ipt", 3);
    freq.put("Tểi", 34);
    freq.put("Tểc", 5);
    freq.put("JJ ", 15);
    freq.put("ip ", 48);
    freq.put("rìn", 35);
    freq.put("Tìn", 7);
    freq.put("Tìm", 3);
    freq.put("sú", 6);
    freq.put("tươ", 9);
    freq.put("Dân", 8);
    freq.put("só", 14);
    freq.put("sô", 5);
    freq.put("sé", 3);
    freq.put("sâ", 19);
    freq.put("sá", 95);
    freq.put("sà", 12);
    freq.put("té ", 3);
    freq.put("om ", 49);
    freq.put("TF ", 7);
    freq.put("ST ", 19);
    freq.put("tăn", 28);
    freq.put("ư", 1900);
    freq.put("tăm", 4);
    freq.put("s ", 904);
    freq.put("uHy", 3);
    freq.put("uể", 798);
    freq.put("sy", 5);
    freq.put("ss", 425);
    freq.put("sr", 6);
    freq.put("sp", 19);
    freq.put("sw", 4);
    freq.put("sv", 3);
    freq.put("su", 137);
    freq.put("st", 131);
    freq.put("sk", 8);
    freq.put("sj", 4);
    freq.put("si", 170);
    freq.put("sh", 96);
    freq.put("so", 66);
    freq.put("sn", 15);
    freq.put("sm", 10);
    freq.put("sl", 9);
    freq.put("sc", 14);
    freq.put("sb", 8);
    freq.put("sa", 520);
    freq.put("sg", 6);
    freq.put("sf", 4);
    freq.put("se", 89);
    freq.put("ròn", 5);
    freq.put("Kan", 15);
    freq.put("tto", 6);
    freq.put("tte", 21);
    freq.put("ác ", 407);
    freq.put("nin", 8);
    freq.put("Gà ", 5);
    freq.put("tt ", 10);
    freq.put(" đò", 15);
    freq.put(" đó", 413);
    freq.put(" đô", 47);
    freq.put("ji ", 8);
    freq.put(" đù", 13);
    freq.put(" đú", 108);
    freq.put("ách", 95);
    freq.put(" đà", 44);
    freq.put(" đá", 102);
    freq.put(" đâ", 375);
    freq.put(" đã", 198);
    freq.put("ÀI ", 3);
    freq.put(" đé", 3);
    freq.put(" đê", 58);
    freq.put(" đì", 11);
    freq.put(" đí", 10);
    freq.put("dể ", 125);
    freq.put(" đ ", 20);
    freq.put("món", 8);
    freq.put("blo", 18);
    freq.put("ble", 4);
    freq.put("bla", 10);
    freq.put("Jon", 3);
    freq.put("Joo", 9);
    freq.put("Mèo", 3);
    freq.put("ăn", 375);
    freq.put("dển", 71);
    freq.put("dểo", 35);
    freq.put("dểm", 7);
    freq.put(" đt", 18);
    freq.put(" đu", 21);
    freq.put("dểi", 32);
    freq.put(" đy", 5);
    freq.put("dểc", 31);
    freq.put("yên", 64);
    freq.put("dểa", 6);
    freq.put("Jo ", 4);
    freq.put(" đa", 261);
    freq.put("hc ", 3);
    freq.put(" đc", 192);
    freq.put(" đe", 51);
    freq.put(" đg", 4);
    freq.put(" đh", 3);
    freq.put(" đi", 823);
    freq.put(" đj", 3);
    freq.put(" đk", 13);
    freq.put(" đm", 9);
    freq.put("dểp", 11);
    freq.put(" đo", 47);
    freq.put("onk", 3);
    freq.put("oni", 5);
    freq.put("onn", 6);
    freq.put("onl", 35);
    freq.put("onc", 14);
    freq.put("£ ", 3);
    freq.put("onf", 5);
    freq.put("ong", 483);
    freq.put("ond", 3);
    freq.put("one", 47);
    freq.put("ukM", 3);
    freq.put("ony", 5);
    freq.put("Cô ", 6);
    freq.put("ons", 12);
    freq.put("ont", 70);
    freq.put(" đư", 160);
    freq.put(" đơ", 24);
    freq.put("ukm", 3);
    freq.put("uki", 15);
    freq.put("uke", 6);
    freq.put("õi ", 4);
    freq.put(" Ze", 3);
    freq.put("on ", 422);
    freq.put(" Za", 3);
    freq.put(" fể", 30);
    freq.put("xúc", 12);
    freq.put("Côn", 33);
    freq.put("AT ", 6);
    freq.put("uk ", 88);
    freq.put("saj", 4);
    freq.put("sai", 11);
    freq.put("sao", 338);
    freq.put("san", 41);
    freq.put("sam", 8);
    freq.put("ÂM ", 3);
    freq.put("ính", 132);
    freq.put("say", 4);
    freq.put(" đă", 25);
    freq.put("sav", 3);
    freq.put("sau", 87);
    freq.put("sat", 4);
    freq.put("gôi", 11);
    freq.put("zon", 4);
    freq.put("ax ", 3);
    freq.put(" đĩ", 14);
    freq.put("sa ", 9);
    freq.put("óc ", 97);
    freq.put("ín ", 15);
    freq.put("gô ", 4);
    freq.put("axi", 6);
    freq.put("NGể", 3);
    freq.put("đam", 7);
    freq.put("ià ", 53);
    freq.put(" Ct", 7);
    freq.put("uB", 3);
    freq.put(" bá", 143);
    freq.put(" bà", 164);
    freq.put(" bã", 6);
    freq.put(" bâ", 41);
    freq.put(" bí", 30);
    freq.put(" bì", 21);
    freq.put(" bé", 92);
    freq.put(" bè", 7);
    freq.put(" bê", 49);
    freq.put(" bô", 16);
    freq.put(" bó", 34);
    freq.put(" bò", 5);
    freq.put(" bù", 17);
    freq.put(" bú", 3);
    freq.put("vân", 21);
    freq.put("NE ", 8);
    freq.put("Xã ", 4);
    freq.put(" b ", 21);
    freq.put("ul", 48);
    freq.put("cài", 5);
    freq.put("càn", 42);
    freq.put("uh", 75);
    freq.put("fir", 7);
    freq.put("vươ", 3);
    freq.put("vây", 4);
    freq.put(" be", 21);
    freq.put(" bf", 3);
    freq.put(" ba", 205);
    freq.put("fit", 3);
    freq.put(" bl", 28);
    freq.put(" bo", 54);
    freq.put(" bn", 3);
    freq.put(" bi", 318);
    freq.put(" bh", 8);
    freq.put(" bj", 4);
    freq.put(" bu", 90);
    freq.put(" bt", 24);
    freq.put("s", 3527);
    freq.put(" br", 8);
    freq.put("cà ", 4);
    freq.put("fểi", 23);
    freq.put(" by", 7);
    freq.put("iÃ¡", 4);
    freq.put("pển", 9);
    freq.put(" bơ", 8);
    freq.put(" bư", 10);
    freq.put("uog", 4);
    freq.put("nít", 6);
    freq.put("níu", 3);
    freq.put("rã", 3);
    freq.put("pể ", 12);
    freq.put("fil", 12);
    freq.put("Xuể", 3);
    freq.put("ive", 29);
    freq.put(" bă", 9);
    freq.put("ivi", 6);
    freq.put("dù ", 31);
    freq.put("gểa", 15);
    freq.put("gểc", 28);
    freq.put("I", 157);
    freq.put("gểm", 42);
    freq.put("ét ", 72);
    freq.put("gển", 75);
    freq.put("gểp", 52);
    freq.put("dùn", 33);
    freq.put("Mar", 7);
    freq.put("gểu", 11);
    freq.put("gểt", 18);
    freq.put("gểy", 10);
    freq.put("rên", 87);
    freq.put("My ", 3);
    freq.put("NA ", 4);
    freq.put("Nă", 3);
    freq.put("dươ", 4);
    freq.put("Man", 9);
    freq.put("tể", 986);
    freq.put("ac ", 33);
    freq.put("Vĩn", 3);
    freq.put("kíc", 6);
    freq.put("acc", 21);
    freq.put("ace", 14);
    freq.put("ack", 34);
    freq.put("ach", 15);
    freq.put(" Mí", 3);
    freq.put("dd ", 8);
    freq.put("Nh", 183);
    freq.put("Ni", 37);
    freq.put("Hoà", 18);
    freq.put("No", 22);
    freq.put("Na", 46);
    freq.put("Ne", 30);
    freq.put("Ng", 135);
    freq.put("Ny", 3);
    freq.put("het", 10);
    freq.put("her", 9);
    freq.put("hes", 3);
    freq.put("đòi", 12);
    freq.put("hey", 3);
    freq.put("đòn", 3);
    freq.put("hed", 3);
    freq.put("hee", 11);
    freq.put("hea", 9);
    freq.put("hec", 12);
    freq.put("hel", 6);
    freq.put("hem", 28);
    freq.put("hen", 35);
    freq.put("heo", 77);
    freq.put("heh", 25);
    freq.put("N ", 144);
    freq.put("đoà", 6);
    freq.put("Won", 16);
    freq.put("he ", 201);
    freq.put("aa", 121);
    freq.put("ành", 162);
    freq.put("ac", 130);
    freq.put("ab", 32);
    freq.put("ae", 100);
    freq.put("ad", 62);
    freq.put("ag", 73);
    freq.put("Hoa", 15);
    freq.put("Hon", 5);
    freq.put("ah", 295);
    freq.put("Nâ", 3);
    freq.put("aj", 18);
    freq.put("am", 257);
    freq.put("al", 104);
    freq.put("ao", 628);
    freq.put("an", 1630);
    freq.put("aq", 4);
    freq.put("ap", 73);
    freq.put("as", 73);
    freq.put("ar", 149);
    freq.put("au", 275);
    freq.put("at", 134);
    freq.put("aw", 6);
    freq.put("av", 37);
    freq.put("ay", 692);
    freq.put("ax", 12);
    freq.put("Nó", 23);
    freq.put("Nô", 3);
    freq.put("viể", 86);
    freq.put("cp ", 6);
    freq.put("HoM", 4);
    freq.put("dưn", 9);
    freq.put("a ", 3346);
    freq.put("Ho ", 11);
    freq.put("àn ", 235);
    freq.put("oh ", 13);
    freq.put("at ", 68);
    freq.put("dư ", 3);
    freq.put("Fir", 4);
    freq.put("sce", 4);
    freq.put("Fin", 3);
    freq.put("scr", 4);
    freq.put("ơ", 853);
    freq.put("ty", 50);
    freq.put("tv", 7);
    freq.put("tw", 114);
    freq.put("tt", 52);
    freq.put("tu", 223);
    freq.put("tr", 1186);
    freq.put("ts", 35);
    freq.put("tp", 5);
    freq.put("tn", 25);
    freq.put("to", 222);
    freq.put("tl", 14);
    freq.put("tj", 5);
    freq.put("tk", 15);
    freq.put("th", 3080);
    freq.put("ti", 467);
    freq.put("tf", 5);
    freq.put("tg", 8);
    freq.put("td", 7);
    freq.put("te", 208);
    freq.put("tb", 5);
    freq.put("tc", 7);
    freq.put("ta", 417);
    freq.put("óe ", 7);
    freq.put("mn ", 21);
    freq.put("t ", 3404);
    freq.put(" ểh", 19);
    freq.put("văn", 20);
    freq.put(" ểi", 17);
    freq.put("Hòa", 3);
    freq.put("tÃ", 3);
    freq.put("tý", 6);
    freq.put("tú", 9);
    freq.put("tù", 10);
    freq.put("tô", 118);
    freq.put("tò", 10);
    freq.put("đít", 7);
    freq.put("xog", 10);
    freq.put("tì", 100);
    freq.put("tí", 110);
    freq.put("tê", 56);
    freq.put("tè", 4);
    freq.put("té", 4);
    freq.put("xon", 86);
    freq.put("tâ", 45);
    freq.put("tà", 24);
    freq.put("tá", 58);
    freq.put("yểu", 7);
    freq.put("yểt", 45);
    freq.put("yển", 204);
    freq.put("vic", 9);
    freq.put("via", 59);
    freq.put("vid", 25);
    freq.put("vie", 26);
    freq.put("vin", 8);
    freq.put("dưể", 24);
    freq.put("vit", 3);
    freq.put("câu", 50);
    freq.put("cây", 9);
    freq.put("¡", 13);
    freq.put(" d ", 6);
    freq.put("vi ", 18);
    freq.put("tă", 33);
    freq.put(" do", 132);
    freq.put(" dk", 6);
    freq.put(" di", 111);
    freq.put(" dg", 4);
    freq.put(" de", 44);
    freq.put(" dc", 144);
    freq.put(" db", 4);
    freq.put(" da", 106);
    freq.put(" dz", 20);
    freq.put("tĩ", 3);
    freq.put(" dv", 4);
    freq.put(" du", 61);
    freq.put(" dr", 3);
    freq.put("viê", 32);
    freq.put("xuy", 4);
    freq.put("Nể", 60);
    freq.put("há", 440);
    freq.put("nãy", 23);
    freq.put("não", 13);
    freq.put(" dí", 5);
    freq.put(" dì", 29);
    freq.put(" dé", 4);
    freq.put(" dã", 18);
    freq.put("sôi", 4);
    freq.put("tư", 111);
    freq.put(" dà", 58);
    freq.put(" dù", 70);
    freq.put("ghé", 39);
    freq.put("úp ", 22);
    freq.put(" dõ", 4);
    freq.put(" dô", 3);
    freq.put(" dò", 6);
    freq.put("tơ", 6);
    freq.put("IP ", 5);
    freq.put(" Mo", 23);
    freq.put("ith", 3);
    freq.put("iti", 4);
    freq.put("ite", 13);
    freq.put("ita", 9);
    freq.put("ity", 6);
    freq.put("itt", 20);
    freq.put("itu", 3);
    freq.put("its", 4);
    freq.put(" bể", 1321);
    freq.put("rểp", 6);
    freq.put("kái", 4);
    freq.put("it ", 45);
    freq.put("À ", 24);
    freq.put("cc ", 27);
    freq.put("tra", 139);
    freq.put("rểi", 478);
    freq.put(" A ", 41);
    freq.put("MG ", 5);
    freq.put("đc ", 188);
    freq.put("TB ", 6);
    freq.put("ãi ", 83);
    freq.put("SH ", 7);
    freq.put(" Ac", 7);
    freq.put(" Ad", 9);
    freq.put(" Af", 3);
    freq.put(" Ah", 7);
    freq.put(" Ai", 22);
    freq.put(" Al", 6);
    freq.put(" An", 74);
    freq.put(" Ao", 3);
    freq.put(" Ap", 8);
    freq.put(" Ar", 4);
    freq.put(" As", 4);
    freq.put(" Au", 3);
    freq.put("NG ", 55);
    freq.put("ft ", 9);
    freq.put("w", 629);
    freq.put("HD ", 14);
    freq.put("jes", 4);
    freq.put("aa ", 16);
    freq.put("lè ", 3);
    freq.put("ág ", 12);
    freq.put("aaa", 97);
    freq.put("Ý ", 13);
    freq.put("OT ", 5);
    freq.put(" cể", 1227);
    freq.put("tp ", 4);
    freq.put("Du ", 7);
    freq.put("vưể", 13);
    freq.put("bh ", 8);
    freq.put("M", 728);
    freq.put("â", 980);
    freq.put("exp", 4);
    freq.put("hg ", 18);
    freq.put("exy", 4);
    freq.put("Hah", 5);
    freq.put("Hai", 17);
    freq.put("Ham", 3);
    freq.put("Han", 12);
    freq.put("Hac", 4);
    freq.put("Hae", 33);
    freq.put("Hay", 11);
    freq.put(" ói", 3);
    freq.put("Hap", 5);
    freq.put(" óc", 11);
    freq.put("Kể ", 20);
    freq.put("rf ", 8);
    freq.put("áh", 15);
    freq.put("ug ", 36);
    freq.put(" để", 1810);
    freq.put("oj ", 4);
    freq.put("rfe", 3);
    freq.put("cre", 11);
    freq.put("cri", 3);
    freq.put("vùn", 5);
    freq.put("cro", 6);
    freq.put("ser", 10);
    freq.put("For", 5);
    freq.put("sex", 5);
    freq.put("sea", 10);
    freq.put("seo", 6);
    freq.put("sen", 14);
    freq.put("sem", 5);
    freq.put("se ", 27);
    freq.put("úm ", 6);
    freq.put("pda", 4);
    freq.put("rõ ", 27);
    freq.put("nr ", 3);
    freq.put("tiv", 3);
    freq.put("xan", 13);
    freq.put("Job", 5);
    freq.put("sle", 3);
    freq.put(" fá", 6);
    freq.put(" fâ", 3);
    freq.put("mũ ", 7);
    freq.put("xa ", 20);
    freq.put("đư", 160);
    freq.put("voi", 8);
    freq.put("vot", 29);
    freq.put(" My", 4);
    freq.put("rde", 14);
    freq.put(" f ", 5);
    freq.put("Đún", 10);
    freq.put("hép", 13);
    freq.put("vo ", 12);
    freq.put("hém", 8);
    freq.put("hén", 3);
    freq.put(" fr", 7);
    freq.put(" fu", 8);
    freq.put("Hôm", 16);
    freq.put("Son", 10);
    freq.put(" fa", 135);
    freq.put(" fc", 7);
    freq.put("Sor", 8);
    freq.put(" fe", 4);
    freq.put(" fi", 41);
    freq.put(" fl", 7);
    freq.put(" fo", 17);
    freq.put("tưể", 81);
    freq.put("O ", 90);
    freq.put("uă", 7);
    freq.put(" Că", 7);
    freq.put("On", 12);
    freq.put(" Cũ", 4);
    freq.put("bà", 164);
    freq.put("bá", 143);
    freq.put("bâ", 41);
    freq.put("bã", 6);
    freq.put("bì", 21);
    freq.put("Of", 8);
    freq.put("bè", 7);
    freq.put("bé", 92);
    freq.put("bê", 49);
    freq.put("ăm ", 126);
    freq.put("bô", 16);
    freq.put("bò", 5);
    freq.put("bó", 34);
    freq.put("Or", 3);
    freq.put("bú", 3);
    freq.put("Op", 13);
    freq.put("d", 1761);
    freq.put("Mể", 139);
    freq.put("Khu", 15);
    freq.put("Khi", 12);
    freq.put("Kho", 5);
    freq.put("Kha", 5);
    freq.put("b ", 116);
    freq.put(" Cơ", 10);
    freq.put(" Cư", 18);
    freq.put("ũng", 355);
    freq.put("dõi", 4);
    freq.put("Tên", 6);
    freq.put("be", 49);
    freq.put("bf", 3);
    freq.put("ba", 241);
    freq.put("bb", 3);
    freq.put("bl", 34);
    freq.put("bn", 5);
    freq.put("bo", 88);
    freq.put("bh", 8);
    freq.put("bi", 341);
    freq.put("bj", 5);
    freq.put("bt", 26);
    freq.put("bu", 124);
    freq.put("Yê", 20);
    freq.put("br", 12);
    freq.put("bs", 17);
    freq.put("ũn ", 5);
    freq.put("by", 14);
    freq.put("Fu", 10);
    freq.put("Khô", 18);
    freq.put("Khê", 5);
    freq.put("vãi", 22);
    freq.put("Khá", 6);
    freq.put("bơ", 8);
    freq.put(" C ", 17);
    freq.put("GD ", 5);
    freq.put("bư", 10);
    freq.put("đa ", 6);
    freq.put("SJ ", 23);
    freq.put("u ", 2446);
    freq.put("đau", 33);
    freq.put(" Ch", 281);
    freq.put(" Ci", 4);
    freq.put(" Co", 36);
    freq.put(" Cl", 6);
    freq.put(" Ca", 24);
    freq.put("uM", 5);
    freq.put("mơ ", 21);
    freq.put("đag", 9);
    freq.put("uH", 4);
    freq.put("sể", 609);
    freq.put("đan", 205);
    freq.put("uC", 4);
    freq.put(" Cu", 19);
    freq.put("cia", 4);
    freq.put("uy", 374);
    freq.put("ux", 6);
    freq.put("uz", 3);
    freq.put("uu", 16);
    freq.put("ut", 80);
    freq.put("uw", 4);
    freq.put("uv", 5);
    freq.put("up", 73);
    freq.put("us", 47);
    freq.put("ur", 25);
    freq.put("um", 101);
    freq.put("cir", 3);
    freq.put("uo", 61);
    freq.put("un", 489);
    freq.put("ui", 193);
    freq.put("qá ", 39);
    freq.put("uk", 122);
    freq.put("uj", 16);
    freq.put("ue", 42);
    freq.put("ud", 7);
    freq.put("ug", 41);
    freq.put("ua", 347);
    freq.put("uc", 43);
    freq.put("ub", 38);
    freq.put("ưng", 248);
    freq.put("bă", 9);
    freq.put("lê ", 3);
    freq.put("zểi", 13);
    freq.put("ag ", 36);
    freq.put("zểy", 18);
    freq.put(" Câ", 6);
    freq.put(" Cà", 4);
    freq.put(" Cá", 91);
    freq.put("ÀO ", 8);
    freq.put(" Cù", 6);
    freq.put(" Cò", 14);
    freq.put(" Có", 45);
    freq.put(" Cô", 39);
    freq.put("uý", 25);
    freq.put("zể ", 26);
    freq.put("lên", 160);
    freq.put("uô", 107);
    freq.put("age", 21);
    freq.put("aga", 7);
    freq.put("uê", 54);
    freq.put("uá", 336);
    freq.put("uà", 14);
    freq.put("uâ", 13);
    freq.put("tr ", 20);
    freq.put("cơn", 5);
    freq.put("cơm", 14);
    freq.put(" Ă", 4);
    freq.put("Ji ", 4);
    freq.put("tri", 37);
    freq.put("evi", 3);
    freq.put("và ", 229);
    freq.put("tro", 191);
    freq.put(" Xể", 7);
    freq.put("trc", 42);
    freq.put("tre", 37);
    freq.put("eve", 17);
    freq.put("trg", 26);
    freq.put("try", 3);
    freq.put("cơ ", 82);
    freq.put("tru", 55);
    freq.put("le ", 77);
    freq.put("ody", 5);
    freq.put("uen", 25);
    freq.put("Blo", 5);
    freq.put("oda", 4);
    freq.put("Bla", 4);
    freq.put("ode", 8);
    freq.put("mũi", 5);
    freq.put("ct ", 15);
    freq.put("rd ", 15);
    freq.put("lea", 5);
    freq.put("lec", 4);
    freq.put("lee", 3);
    freq.put("ue ", 10);
    freq.put("len", 7);
    freq.put("ler", 5);
    freq.put("les", 3);
    freq.put("let", 7);
    freq.put("od ", 27);
    freq.put("ley", 3);
    freq.put("Ân ", 3);
    freq.put("trê", 83);
    freq.put("trí", 22);
    freq.put("trì", 35);
    freq.put("ctr", 3);
    freq.put("trá", 29);
    freq.put("trà", 6);
    freq.put("trù", 9);
    freq.put("trú", 8);
    freq.put("cta", 5);
    freq.put("trò", 26);
    freq.put("trô", 15);
    freq.put("tră", 14);
    freq.put("Ôn", 3);
    freq.put("Đ", 322);
    freq.put("Ôi", 7);
    freq.put(" 가가", 3);
    freq.put("khể", 137);
    freq.put("sg ", 5);
    freq.put("Ô ", 6);
    freq.put("zi", 9);
    freq.put("CểA", 3);
    freq.put("Cểu", 14);
    freq.put("On ", 3);
    freq.put("Cểp", 6);
    freq.put("íh ", 4);
    freq.put("Cểm", 9);
    freq.put("Cển", 26);
    freq.put("trư", 100);
    freq.put("Cểa", 3);
    freq.put("Cểc", 3);
    freq.put("chà", 27);
    freq.put("Q", 116);
    freq.put("afi", 8);
    freq.put("Onl", 4);
    freq.put("One", 5);
    freq.put("trơ", 3);
    freq.put("afe", 6);
    freq.put("Cể ", 26);
    freq.put("úm", 6);
    freq.put("ún", 209);
    freq.put("úi", 11);
    freq.put("Lúc", 6);
    freq.put("chì", 4);
    freq.put("úg", 13);
    freq.put("TY ", 7);
    freq.put("úa", 13);
    freq.put("úc", 168);
    freq.put("út", 44);
    freq.put("úp", 22);
    freq.put("Sa ", 3);
    freq.put(" h ", 188);
    freq.put("SaJ", 5);
    freq.put("ể", 23072);
    freq.put("ú ", 105);
    freq.put("Saj", 6);
    freq.put(" hy", 17);
    freq.put("Sao", 30);
    freq.put("San", 5);
    freq.put("Sam", 5);
    freq.put("Sal", 4);
    freq.put(" hs", 4);
    freq.put(" hq", 6);
    freq.put(" hp", 3);
    freq.put(" hw", 3);
    freq.put("Đ ", 5);
    freq.put(" hu", 93);
    freq.put(" ht", 7);
    freq.put(" hk", 4);
    freq.put(" hj", 7);
    freq.put(" hi", 190);
    freq.put(" ho", 193);
    freq.put(" hn", 47);
    freq.put(" hc", 4);
    freq.put(" ha", 350);
    freq.put(" he", 69);
    freq.put("kpo", 5);
    freq.put("Vô ", 4);
    freq.put("ìm ", 58);
    freq.put("hể ", 1961);
    freq.put("hểp", 123);
    freq.put("hểt", 608);
    freq.put("hểu", 105);
    freq.put("hểy", 346);
    freq.put("hểc", 423);
    freq.put("hểa", 32);
    freq.put("hểg", 17);
    freq.put("hểe", 9);
    freq.put("hểk", 4);
    freq.put("hểi", 528);
    freq.put("hển", 668);
    freq.put("hểo", 25);
    freq.put("hểm", 88);
    freq.put(" hú", 27);
    freq.put(" hù", 10);
    freq.put(" hó", 33);
    freq.put(" hò", 18);
    freq.put(" hô", 147);
    freq.put(" hê", 17);
    freq.put(" hé", 19);
    freq.put(" hè", 6);
    freq.put(" hí", 24);
    freq.put(" hì", 122);
    freq.put(" hã", 33);
    freq.put(" hâ", 20);
    freq.put(" há", 72);
    freq.put(" hà", 147);
    freq.put("tát", 9);
    freq.put("IT ", 3);
    freq.put("ihi", 6);
    freq.put("tác", 14);
    freq.put("tám", 3);
    freq.put("tán", 7);
    freq.put("táo", 8);
    freq.put("tái", 6);
    freq.put("tá ", 7);
    freq.put("ih ", 3);
    freq.put("én ", 10);
    freq.put("zz", 43);
    freq.put("nHa", 8);
    freq.put("nHo", 5);
    freq.put("ểP ", 5);
    freq.put("ý", 293);
    freq.put(" E ", 26);
    freq.put("MC ", 12);
    freq.put("Cá ", 6);
    freq.put("đg ", 4);
    freq.put("ck ", 86);
    freq.put(" hư", 33);
    freq.put("ãm ", 5);
    freq.put("Són", 4);
    freq.put(" hơ", 152);
    freq.put(" El", 6);
    freq.put(" Em", 41);
    freq.put(" En", 9);
    freq.put(" Eb", 3);
    freq.put("Cát", 3);
    freq.put("Cái", 35);
    freq.put("Các", 45);
    freq.put(" Eu", 32);
    freq.put("cke", 5);
    freq.put("AA ", 3);
    freq.put("vào", 176);
    freq.put("vàn", 32);
    freq.put("vài", 3);
    freq.put("cũ", 380);
    freq.put("vái", 3);
    freq.put("rể", 952);
    freq.put("phư", 10);
    freq.put("jan", 4);
    freq.put("ae ", 58);
    freq.put("lô ", 7);
    freq.put("jae", 7);
    freq.put("vư", 16);
    freq.put("aeH", 4);
    freq.put("aeM", 3);
    freq.put("că", 26);
    freq.put("h", 17543);
    freq.put("aeb", 5);
    freq.put("aeg", 3);
    freq.put("lôi", 7);
    freq.put("aej", 10);
    freq.put("ael", 3);
    freq.put("ja ", 4);
    freq.put("Pr", 9);
    freq.put("btw", 3);
    freq.put("vũ", 11);
    freq.put("C", 885);
    freq.put("Hiể", 32);
    freq.put("Pe", 7);
    freq.put("Ph", 102);
    freq.put("Pi", 8);
    freq.put("Po", 12);
    freq.put("Pl", 3);
    freq.put("et ", 95);
    freq.put("đôn", 18);
    freq.put("đôi", 18);
    freq.put("cơ", 101);
    freq.put("P ", 88);
    freq.put("eun", 7);
    freq.put("bt ", 18);
    freq.put("cư", 136);
    freq.put("ets", 10);
    freq.put(" Vể", 63);
    freq.put("vă", 20);
    freq.put("euk", 46);
    freq.put("ett", 6);
    freq.put("vđ", 5);
    freq.put("CR ", 4);
    freq.put("eta", 5);
    freq.put("tle", 7);
    freq.put("ete", 7);
    freq.put("tli", 3);
    freq.put("eti", 6);
    freq.put("etn", 4);
    freq.put("và", 440);
    freq.put("vá", 14);
    freq.put("vâ", 26);
    freq.put("vã", 22);
    freq.put("co", 530);
    freq.put("cn", 9);
    freq.put("cm", 14);
    freq.put("cl", 18);
    freq.put("cc", 32);
    freq.put("vé", 30);
    freq.put("ca", 191);
    freq.put("vì", 120);
    freq.put("ce", 61);
    freq.put("Hee", 17);
    freq.put("vò", 9);
    freq.put("cx", 7);
    freq.put("vô", 50);
    freq.put("cs", 6);
    freq.put("vù", 6);
    freq.put("cp", 9);
    freq.put("uck", 8);
    freq.put("cu", 166);
    freq.put("uch", 8);
    freq.put("Gen", 3);
    freq.put("phê", 8);
    freq.put("phé", 5);
    freq.put("phí", 22);
    freq.put("phâ", 12);
    freq.put("phá", 70);
    freq.put("phà", 3);
    freq.put("phú", 27);
    freq.put("phù", 4);
    freq.put("He ", 3);
    freq.put("uc ", 21);
    freq.put("phó", 6);
    freq.put("phò", 14);
    freq.put("kê ", 4);
    freq.put("phô", 4);
    freq.put("rbe", 3);
    freq.put("va", 68);
    freq.put("xiể", 4);
    freq.put("vd", 6);
    freq.put("ve", 130);
    freq.put("cã", 12);
    freq.put("vi", 275);
    freq.put("cá", 825);
    freq.put("vk", 8);
    freq.put("vl", 6);
    freq.put("vn", 27);
    freq.put("vo", 56);
    freq.put("cú", 16);
    freq.put("cù", 73);
    freq.put("vs", 115);
    freq.put("vu", 72);
    freq.put("có", 816);
    freq.put("cò", 207);
    freq.put("cô", 155);
    freq.put("of ", 16);
    freq.put("v ", 54);
    freq.put("phi", 65);
    freq.put("pho", 18);
    freq.put("pha", 16);
    freq.put("loà", 3);
    freq.put("kì ", 26);
    freq.put("phu", 4);
    freq.put("quá", 328);
    freq.put("off", 14);
    freq.put("quà", 11);
    freq.put("oft", 7);
    freq.put("xem", 179);
    freq.put("web", 16);
    freq.put("wee", 35);
    freq.put("Oh ", 6);
    freq.put("wen", 6);
    freq.put("dìm", 15);
    freq.put("wer", 8);
    freq.put("ió", 11);
    freq.put("xe ", 36);
    freq.put("CN ", 4);
    freq.put(" yể", 10);
    freq.put("nve", 4);
    freq.put("Ohm", 15);
    freq.put("bão", 4);
    freq.put("ĐI ", 3);
    freq.put("vé ", 26);
    freq.put("hí ", 71);
    freq.put(" j ", 224);
    freq.put("hít", 5);
    freq.put("vs ", 114);
    freq.put("hím", 6);
    freq.put("hín", 54);
    freq.put("hía", 10);
    freq.put("híc", 109);
    freq.put("rưa", 8);
    freq.put("Sch", 3);
    freq.put("Đã", 13);
    freq.put(" ju", 5);
    freq.put(" jo", 7);
    freq.put(" ji", 9);
    freq.put("Sau", 7);
    freq.put(" je", 10);
    freq.put(" ja", 11);
    freq.put("hoể", 75);
    freq.put("yri", 5);
    freq.put("Lể", 67);
    freq.put(" Ô ", 4);
    freq.put("ưu ", 19);
    freq.put("Ư ", 3);
    freq.put(" Ôn", 3);
    freq.put(" Ôi", 7);
    freq.put("Xem", 11);
    freq.put("int", 10);
    freq.put("inv", 3);
    freq.put("inn", 3);
    freq.put("ino", 3);
    freq.put("inh", 255);
    freq.put("ini", 11);
    freq.put("ink", 37);
    freq.put("ind", 19);
    freq.put("ine", 34);
    freq.put("inf", 7);
    freq.put("ing", 84);
    freq.put("ina", 14);
    freq.put("inb", 3);
    freq.put("inc", 3);
    freq.put("Vũ ", 4);
    freq.put("eo ", 126);
    freq.put("Ân", 3);
    freq.put("Âu", 5);
    freq.put("DA ", 9);
    freq.put("U", 82);
    freq.put("in ", 267);
    freq.put("ê", 1412);
    freq.put("Vũn", 4);
    freq.put("eon", 8);
    freq.put("eow", 4);
    freq.put("eou", 3);
    freq.put("lê", 165);
    freq.put("hĩa", 13);
    freq.put("lè", 3);
    freq.put(" G ", 23);
    freq.put("đem", 10);
    freq.put("đeo", 17);
    freq.put("đen", 16);
    freq.put("ão ", 41);
    freq.put("lò", 22);
    freq.put(" Gu", 6);
    freq.put(" Gr", 4);
    freq.put("Ci", 4);
    freq.put("hĩ ", 64);
    freq.put(" Ge", 8);
    freq.put(" Ga", 15);
    freq.put(" Go", 19);
    freq.put(" Gh", 7);
    freq.put(" Gi", 107);
    freq.put("đe ", 3);
    freq.put("lý", 24);
    freq.put("lú", 94);
    freq.put("NY ", 8);
    freq.put("lù", 9);
    freq.put("Uể", 11);
    freq.put("Dểo", 7);
    freq.put("Bể", 142);
    freq.put(" xể", 78);
    freq.put("Dểc", 5);
    freq.put("Dểy", 3);
    freq.put("è ", 63);
    freq.put("Sin", 10);
    freq.put("ểU ", 7);
    freq.put("ak ", 32);
    freq.put("ái ", 738);
    freq.put("À", 12);
    freq.put(" Gò", 5);
    freq.put("Dể ", 11);
    freq.put("èn", 11);
    freq.put("èo", 30);
    freq.put(" Gà", 7);
    freq.put("èm", 36);
    freq.put("gle", 13);
    freq.put("aku", 5);
    freq.put("aki", 4);
    freq.put("akn", 4);
    freq.put("aka", 8);
    freq.put("ake", 8);
    freq.put("nk ", 52);
    freq.put(" ưu", 6);
    freq.put(" ưa", 4);
    freq.put("bri", 4);
    freq.put("mùn", 6);
    freq.put("mùa", 17);
    freq.put("bre", 3);
    freq.put(" ưn", 3);
    freq.put("OR ", 20);
    freq.put(" Uể", 4);
    freq.put("er ", 156);
    freq.put("tn ", 19);
    freq.put("đún", 89);
    freq.put("ió ", 11);
    freq.put("đúg", 6);
    freq.put("ir", 67);
    freq.put("nki", 6);
    freq.put(" ư ", 5);
    freq.put("mù ", 7);
    freq.put("Nam", 26);
    freq.put("ert", 16);
    freq.put("ㅠ", 6);
    freq.put("erv", 7);
    freq.put("erp", 4);
    freq.put("err", 5);
    freq.put("ers", 7);
    freq.put("ere", 7);
    freq.put("erf", 12);
    freq.put("CT ", 6);
    freq.put("era", 12);
    freq.put("đú ", 10);
    freq.put("erm", 12);
    freq.put("ern", 10);
    freq.put("ero", 3);
    freq.put("eri", 6);
    freq.put("uay", 29);
    freq.put("Tp ", 6);
    freq.put("uar", 3);
    freq.put("la ", 50);
    freq.put("uah", 4);
    freq.put("uan", 48);
    freq.put("Nay", 3);
    freq.put("xển", 6);
    freq.put("xểp", 8);
    freq.put("xểu", 26);
    freq.put("xôn", 6);
    freq.put("xểy", 5);
    freq.put("ểj ", 21);
    freq.put("lam", 14);
    freq.put("lan", 25);
    freq.put("lao", 4);
    freq.put("lah", 6);
    freq.put("lai", 14);
    freq.put("Béo", 3);
    freq.put("lag", 13);
    freq.put("lac", 5);
    freq.put("lay", 11);
    freq.put("laz", 4);
    freq.put("lat", 4);
    freq.put("ua ", 256);
    freq.put("mpi", 3);
    freq.put("lap", 8);
    freq.put("lar", 3);
    freq.put("las", 7);
    freq.put("xể ", 26);
    freq.put("uwo", 3);
    freq.put("ểp ", 721);
    freq.put("luể", 18);
    freq.put(" lă", 14);
    freq.put("ze ", 9);
    freq.put(" lũ", 14);
    freq.put(" ùi", 6);
    freq.put("l", 4076);
    freq.put("úg ", 13);
    freq.put("ngể", 306);
    freq.put(" lư", 63);
    freq.put("nt ", 109);
    freq.put("wgm", 4);
    freq.put("mv ", 7);
    freq.put("bá ", 4);
    freq.put("ít ", 69);
    freq.put("xg ", 3);
    freq.put("nti", 21);
    freq.put("nth", 3);
    freq.put("nto", 3);
    freq.put("ntn", 14);
    freq.put("nta", 9);
    freq.put("nte", 28);
    freq.put("bát", 5);
    freq.put("YS ", 3);
    freq.put("bác", 26);
    freq.put("bán", 74);
    freq.put("báo", 27);
    freq.put(" l ", 12);
    freq.put("cúp", 4);
    freq.put("Đài", 3);
    freq.put("­", 5);
    freq.put("Hê ", 3);
    freq.put("kt ", 4);
    freq.put(" le", 15);
    freq.put("B", 465);
    freq.put(" la", 120);
    freq.put(" lo", 153);
    freq.put(" li", 107);
    freq.put(" lu", 173);
    freq.put("Đà ", 3);
    freq.put(" ls", 4);
    freq.put("cú ", 3);
    freq.put(" ly", 7);
    freq.put("đêm", 34);
    freq.put("Ser", 4);
    freq.put("ktr", 4);
    freq.put("Sea", 3);
    freq.put("Câ", 6);
    freq.put("Seo", 3);
    freq.put("Sen", 3);
    freq.put("Q ", 19);
    freq.put("Loể", 4);
    freq.put("tev", 5);
    freq.put("Qu", 98);
    freq.put(" lâ", 48);
    freq.put(" lá", 20);
    freq.put(" là", 1168);
    freq.put(" lí", 12);
    freq.put(" lê", 165);
    freq.put(" lé", 12);
    freq.put(" lè", 3);
    freq.put(" lô", 20);
    freq.put(" ló", 8);
    freq.put(" lò", 22);
    freq.put(" lý", 24);
    freq.put(" lú", 94);
    freq.put(" lù", 9);
    freq.put("d ", 195);
    freq.put("Mể ", 33);
    freq.put("Vể ", 13);
    freq.put("Tàu", 5);
    freq.put("em ", 649);
    freq.put("thư", 95);
    freq.put("Tài", 6);
    freq.put("do", 175);
    freq.put("dl", 3);
    freq.put("dm", 6);
    freq.put("dk", 6);
    freq.put("wá", 39);
    freq.put("di", 141);
    freq.put("dg", 5);
    freq.put("dd", 12);
    freq.put("de", 111);
    freq.put("db", 5);
    freq.put("wê", 4);
    freq.put("da", 137);
    freq.put("dz", 20);
    freq.put("Mểy", 16);
    freq.put("dy", 8);
    freq.put("dv", 4);
    freq.put("dt", 4);
    freq.put("du", 67);
    freq.put("dr", 9);
    freq.put("ds", 4);
    freq.put("eme", 7);
    freq.put("Vểa", 6);
    freq.put("ema", 4);
    freq.put("VÀ ", 5);
    freq.put("Vểi", 4);
    freq.put("emo", 9);
    freq.put("emi", 3);
    freq.put("Vển", 7);
    freq.put("Vểt", 5);
    freq.put("Vểy", 23);
    freq.put("dT", 4);
    freq.put("w ", 165);
    freq.put(" I ", 20);
    freq.put("thă", 16);
    freq.put("il ", 12);
    freq.put("xD ", 14);
    freq.put("co ", 28);
    freq.put("xét", 5);
    freq.put("wg", 5);
    freq.put("dì", 29);
    freq.put("dí", 5);
    freq.put("wa", 69);
    freq.put("dé", 4);
    freq.put("wo", 62);
    freq.put("wn", 44);
    freq.put(" Is", 5);
    freq.put("dâ", 28);
    freq.put("dã", 18);
    freq.put("dà", 58);
    freq.put("dá", 29);
    freq.put("ww", 46);
    freq.put("wt", 14);
    freq.put("ws", 28);
    freq.put(" Im", 10);
    freq.put(" In", 34);
    freq.put("dù", 70);
    freq.put("dô", 3);
    freq.put("dõ", 4);
    freq.put(" Id", 4);
    freq.put("cop", 6);
    freq.put("ild", 4);
    freq.put("ile", 15);
    freq.put("cou", 11);
    freq.put("GB ", 3);
    freq.put("cov", 4);
    freq.put("coy", 3);
    freq.put("ill", 13);
    freq.put("ilm", 5);
    freq.put("ili", 4);
    freq.put("coa", 3);
    freq.put("AE ", 8);
    freq.put("cod", 5);
    freq.put("coi", 85);
    freq.put("com", 40);
    freq.put("ily", 4);
    freq.put("áo ", 125);
    freq.put("gn ", 4);
    freq.put("ai ", 604);
    freq.put("niê", 5);
    freq.put("Cũn", 4);
    freq.put("óp ", 14);
    freq.put("aiD", 4);
    freq.put("thý", 4);
    freq.put("Này", 4);
    freq.put("thú", 20);
    freq.put("thù", 3);
    freq.put("aiz", 25);
    freq.put("ait", 3);
    freq.put("thô", 213);
    freq.put("thó", 7);
    freq.put("air", 3);
    freq.put("ail", 10);
    freq.put("ET ", 6);
    freq.put("Nàn", 3);
    freq.put("thê", 47);
    freq.put("thé", 5);
    freq.put("thè", 32);
    freq.put("aig", 8);
    freq.put("thâ", 32);
    freq.put("thá", 75);
    freq.put("gnm", 3);
    freq.put("ni ", 17);
    freq.put(" Sể", 52);
    freq.put("dư", 41);
    freq.put("wă", 4);
    freq.put("ể ", 6037);
    freq.put("ôn ", 142);
    freq.put("ep ", 37);
    freq.put("th ", 25);
    freq.put("ểI", 29);
    freq.put("ểO", 5);
    freq.put("ểN", 54);
    freq.put("ểM", 12);
    freq.put("nim", 5);
    freq.put("ểC", 17);
    freq.put("nic", 13);
    freq.put("ểA", 9);
    freq.put("nig", 7);
    freq.put("nie", 20);
    freq.put("ểY", 7);
    freq.put("Y", 127);
    freq.put("nis", 3);
    freq.put("ểP", 6);
    freq.put("niv", 3);
    freq.put("ểU", 7);
    freq.put("ểT", 24);
    freq.put("ểk", 9);
    freq.put("ểj", 21);
    freq.put("ểi", 3453);
    freq.put("ểh", 28);
    freq.put("ểo", 240);
    freq.put("ển", 4619);
    freq.put("ểm", 722);
    freq.put("ểc", 1464);
    freq.put("ểa", 1045);
    freq.put("ểg", 60);
    freq.put("ểe", 26);
    freq.put("tho", 59);
    freq.put("epo", 4);
    freq.put("ểy", 1164);
    freq.put("thj", 5);
    freq.put("thi", 175);
    freq.put("thg", 6);
    freq.put("the", 110);
    freq.put("ểp", 733);
    freq.put("tha", 109);
    freq.put("ểt", 2185);
    freq.put(" nơ", 15);
    freq.put("Tr ", 5);
    freq.put("rn ", 3);
    freq.put("ìa ", 37);
    freq.put(" nư", 34);
    freq.put("wăn", 3);
    freq.put("zể", 59);
    freq.put("Gam", 5);
    freq.put("sĩ ", 11);
    freq.put(" Nă", 3);
    freq.put("Tri", 7);
    freq.put("rni", 5);
    freq.put("Tro", 14);
    freq.put("Tra", 26);
    freq.put("ĩu ", 3);
    freq.put("Tre", 3);
    freq.put("rne", 5);
    freq.put("§n", 3);
    freq.put("Tru", 30);
    freq.put("Tok", 4);
    freq.put("Bài", 4);
    freq.put("Lee", 17);
    freq.put(" nă", 88);
    freq.put("Giể", 40);
    freq.put("｡ ", 3);
    freq.put("Trê", 5);
    freq.put("Ä", 5);
    freq.put("Trà", 3);
    freq.put("ple", 27);
    freq.put("táº", 3);
    freq.put("pla", 14);
    freq.put("yk ", 6);
    freq.put("ùi ", 58);
    freq.put("obi", 12);
    freq.put("obs", 5);
    freq.put(" vể", 1027);
    freq.put(" ｡", 3);
    freq.put("túc", 3);
    freq.put("wan", 11);
    freq.put("wal", 7);
    freq.put("wai", 3);
    freq.put("wae", 4);
    freq.put("HIể", 5);
    freq.put(" né", 16);
    freq.put(" nè", 36);
    freq.put("eSu", 3);
    freq.put(" nê", 157);
    freq.put(" ní", 10);
    freq.put(" nì", 6);
    freq.put(" ná", 7);
    freq.put(" nà", 684);
    freq.put(" nã", 36);
    freq.put(" nâ", 6);
    freq.put("xy ", 7);
    freq.put(" nú", 7);
    freq.put("YểN", 5);
    freq.put(" nó", 524);
    freq.put(" nô", 11);
    freq.put(" （", 3);
    freq.put("wa ", 32);
    freq.put("Đâu", 4);
    freq.put(" n ", 35);
    freq.put("Đây", 5);
    freq.put("Trư", 9);
    freq.put("hái", 31);
    freq.put("hán", 90);
    freq.put("háo", 8);
    freq.put("hác", 81);
    freq.put("hág", 4);
    freq.put("háy", 5);
    freq.put("háp", 13);
    freq.put("hát", 108);
    freq.put("háu", 13);
    freq.put(" ni", 45);
    freq.put(" nh", 2164);
    freq.put(" no", 63);
    freq.put(" na", 222);
    freq.put(" nc", 38);
    freq.put(" ne", 41);
    freq.put(" ng", 1354);
    freq.put(" nu", 32);
    freq.put(" nt", 24);
    freq.put("fá", 6);
    freq.put("há ", 74);
    freq.put("Si", 52);
    freq.put("Hìn", 12);
    freq.put("HQ ", 7);
    freq.put("가가", 3);
    freq.put("To ", 7);
    freq.put("gu ", 32);
    freq.put("ó ", 1628);
    freq.put("­nh", 3);
    freq.put("fol", 5);
    freq.put("umo", 4);
    freq.put("EO ", 6);
    freq.put("ruể", 10);
    freq.put("gui", 3);
    freq.put("óp", 14);
    freq.put("guo", 4);
    freq.put("RY ", 4);
    freq.put("ót", 17);
    freq.put("p", 2329);
    freq.put("ói", 258);
    freq.put("ón", 110);
    freq.put("óm", 31);
    freq.put("óc", 97);
    freq.put("guy", 55);
    freq.put("óe", 8);
    freq.put("hta", 3);
    freq.put("OK ", 4);
    freq.put("htt", 3);
    freq.put("mây", 8);
    freq.put("mâu", 3);
    freq.put("IN ", 9);
    freq.put("Tây", 4);
    freq.put("ek ", 6);
    freq.put("Tâm", 3);
    freq.put("Tân", 8);
    freq.put("đăn", 25);
    freq.put("ht ", 15);
    freq.put("v", 2635);
    freq.put("eke", 12);
    freq.put("CM ", 22);
    freq.put("PC ", 5);
    freq.put("đin", 4);
    freq.put("đii", 4);
    freq.put(" Ke", 6);
    freq.put(" Kh", 82);
    freq.put(" Ki", 59);
    freq.put(" Ko", 20);
    freq.put(" Ku", 3);
    freq.put(" Ky", 54);
    freq.put("Tể", 133);
    freq.put("Mon", 16);
    freq.put("F", 112);
    freq.put("fb ", 16);
    freq.put("ÂU ", 3);
    freq.put("BS ", 9);
    freq.put(" K ", 12);
    freq.put("cas", 5);
    freq.put("iba", 6);
    freq.put("cap", 7);
    freq.put("đi ", 626);
    freq.put("cau", 4);
    freq.put("cat", 5);
    freq.put("cai", 24);
    freq.put("cao", 44);
    freq.put("can", 21);
    freq.put("cam", 22);
    freq.put("ghì", 3);
    freq.put("ghè", 3);
    freq.put("caf", 3);
    freq.put("ghê", 42);
    freq.put("ểi ", 3400);
    freq.put("ao ", 600);
    freq.put("ám ", 50);
    freq.put("spo", 4);
    freq.put("spa", 10);
    freq.put(" à ", 111);
    freq.put("điê", 72);
    freq.put(" Kí", 7);
    freq.put("lòn", 19);
    freq.put("aov", 8);
    freq.put("ght", 11);
    freq.put(" àk", 4);
    freq.put(" àh", 39);
    freq.put("ghe", 134);
    freq.put("ER ", 25);
    freq.put("gha", 12);
    freq.put("ghi", 60);
    freq.put("Cha", 17);
    freq.put("Che", 9);
    freq.put("Chi", 28);
    freq.put("no ", 36);
    freq.put("Ry", 7);
    freq.put("Jap", 3);
    freq.put("Cho", 19);
    freq.put("Re", 13);
    freq.put("Ra", 10);
    freq.put("Ro", 12);
    freq.put("Ri", 8);
    freq.put("Mún", 6);
    freq.put("nom", 3);
    freq.put("non", 11);
    freq.put("noi", 14);
    freq.put("R ", 69);
    freq.put("not", 8);
    freq.put("now", 4);
    freq.put("xă", 5);
    freq.put("sưể", 28);
    freq.put("em", 694);
    freq.put("el", 72);
    freq.put("eo", 147);
    freq.put("en", 315);
    freq.put("ei", 8);
    freq.put("eh", 39);
    freq.put("ek", 20);
    freq.put("ej", 10);
    freq.put("ee", 136);
    freq.put("ed", 29);
    freq.put("eg", 10);
    freq.put("ef", 9);
    freq.put("ea", 112);
    freq.put("Chí", 28);
    freq.put("ec", 53);
    freq.put("eb", 49);
    freq.put("ey", 29);
    freq.put("ex", 14);
    freq.put("Siê", 3);
    freq.put("eu", 98);
    freq.put("et", 148);
    freq.put("ew", 44);
    freq.put("ev", 23);
    freq.put("ep", 56);
    freq.put("es", 92);
    freq.put("er", 276);
    freq.put("eM", 5);
    freq.put("eH", 5);
    freq.put("eT", 7);
    freq.put("eP", 3);
    freq.put("eS", 4);
    freq.put("rld", 7);
    freq.put("òng", 52);
    freq.put("e ", 1337);
    freq.put("xư", 15);
    freq.put("rls", 3);
    freq.put("lôn", 6);
    freq.put("hh ", 11);
    freq.put("xi", 76);
    freq.put("xo", 116);
    freq.put("zai", 71);
    freq.put("xa", 41);
    freq.put("xg", 3);
    freq.put("xe", 217);
    freq.put("xx", 90);
    freq.put("xy", 7);
    freq.put("ểt ", 2144);
    freq.put("xp", 6);
    freq.put("xu", 78);
    freq.put("Phí", 3);
    freq.put("fl", 12);
    freq.put("Phá", 14);
    freq.put("xD", 40);
    freq.put("Phú", 5);
    freq.put(" ý ", 207);
    freq.put("Phò", 9);
    freq.put("úc ", 167);
    freq.put("x ", 116);
    freq.put("aJu", 5);
    freq.put("za ", 10);
    freq.put("Pa", 26);
    freq.put("bí ", 11);
    freq.put("xé", 7);
    freq.put("xì", 11);
    freq.put("xí", 7);
    freq.put("xã", 7);
    freq.put("xà", 17);
    freq.put("xá", 20);
    freq.put("xú", 15);
    freq.put("tôi", 105);
    freq.put("xù", 3);
    freq.put("tôn", 4);
    freq.put("xó", 10);
    freq.put("xô", 10);
    freq.put("Phi", 12);
    freq.put("Pho", 18);
    freq.put("Pha", 3);
    freq.put("mr ", 3);
    freq.put("Chơ", 7);
    freq.put("Off", 6);
    freq.put("Chư", 10);
    freq.put("bít", 17);
    freq.put("tô ", 5);
    freq.put("ò", 425);
    freq.put(" tể", 986);
    freq.put("가", 8);
    freq.put("oé ", 4);
    freq.put(" p ", 22);
    freq.put("hãy", 23);
    freq.put("hãi", 4);
    freq.put("hãn", 3);
    freq.put("hãm", 3);
    freq.put(" pr", 11);
    freq.put(" pp", 4);
    freq.put(" pa", 44);
    freq.put(" pe", 14);
    freq.put(" pk", 3);
    freq.put(" pi", 27);
    freq.put(" ph", 671);
    freq.put(" po", 27);
    freq.put(" pm", 7);
    freq.put(" pl", 13);
    freq.put("TQ ", 3);
    freq.put("hã ", 4);
    freq.put(" Mư", 3);
    freq.put("Bây", 6);
    freq.put("zì ", 3);
    freq.put("vu ", 10);
    freq.put("sàn", 12);
    freq.put(" pà", 13);
    freq.put(" pé", 8);
    freq.put("zìa", 5);
    freq.put("EM ", 4);
    freq.put("vua", 3);
    freq.put("yể", 257);
    freq.put("vuj", 4);
    freq.put("vui", 46);
    freq.put("màu", 28);
    freq.put("liể", 20);
    freq.put(" ㅋㅋ", 3);
    freq.put("mày", 29);
    freq.put("màn", 11);
    freq.put("màh", 4);
    freq.put("mài", 4);
    freq.put(" Mà", 31);
    freq.put(" Má", 19);
    freq.put(" Mã", 6);
    freq.put(" Mì", 66);
    freq.put("ăg ", 4);
    freq.put("kè", 7);
    freq.put(" Mè", 3);
    freq.put(" Mô", 4);
    freq.put("pà ", 8);
    freq.put("đoá", 7);
    freq.put(" Mó", 3);
    freq.put(" Mú", 7);
    freq.put("mà ", 648);
    freq.put("kí ", 14);
    freq.put("pài", 3);
    freq.put("Thể", 106);
    freq.put("SD ", 17);
    freq.put("yl", 6);
    freq.put(" Me", 11);
    freq.put("kì", 62);
    freq.put(" Ma", 53);
    freq.put(" Mn", 5);
    freq.put("AO ", 5);
    freq.put(" Mi", 113);
    freq.put("khe", 16);
    freq.put(" Mu", 46);
    freq.put(" Mr", 16);
    freq.put("xíu", 3);
    freq.put("Cùn", 5);
    freq.put("đô ", 10);
    freq.put("NS ", 10);
    freq.put("ux ", 5);
    freq.put("Ä", 3);
    freq.put(" M ", 32);
    freq.put("cco", 4);
    freq.put("đo ", 5);
    freq.put("ck", 104);
    freq.put("ác", 504);
    freq.put("ểk ", 9);
    freq.put("ág", 12);
    freq.put("ái", 741);
    freq.put("am ", 173);
    freq.put("ám", 51);
    freq.put("ci", 10);
    freq.put("áo", 127);
    freq.put("án", 453);
    freq.put("rươ", 4);
    freq.put("áp", 35);
    freq.put("ch", 3147);
    freq.put("áu", 41);
    freq.put("át", 181);
    freq.put("áy", 71);
    freq.put("ê ", 202);
    freq.put("Đă", 4);
    freq.put("cb", 16);
    freq.put("ami", 11);
    freq.put("á ", 719);
    freq.put("amo", 6);
    freq.put("ama", 19);
    freq.put("êu", 243);
    freq.put("ame", 20);
    freq.put("đơ", 24);
    freq.put("êm", 98);
    freq.put("ên", 859);
    freq.put("êh", 4);
    freq.put("amp", 4);
    freq.put("ams", 11);
    freq.put(" âm", 6);
    freq.put(" âu", 8);
    freq.put("t", 11378);
    freq.put(" rể", 637);
    freq.put(" ây", 3);
    freq.put("Đư", 5);
    freq.put("cr", 23);
    freq.put("sr ", 3);
    freq.put("ót ", 17);
    freq.put("ÀY ", 3);
    freq.put("Heh", 6);
    freq.put("ct", 35);
    freq.put("tdo", 4);
    freq.put("nme", 4);
    freq.put("đĩ", 14);
    freq.put("áº", 14);
    freq.put("YJ ", 15);
    freq.put("sra", 3);
    freq.put("đă", 25);
    freq.put("đó", 413);
    freq.put("đò", 15);
    freq.put("đô", 47);
    freq.put("đù", 13);
    freq.put("đú", 108);
    freq.put("ĐT ", 4);
    freq.put("đá", 102);
    freq.put("đà", 44);
    freq.put("đã", 198);
    freq.put("đâ", 376);
    freq.put("đé", 3);
    freq.put("đè", 8);
    freq.put("đê", 58);
    freq.put("đí", 10);
    freq.put("đì", 11);
    freq.put("loc", 5);
    freq.put("loa", 21);
    freq.put("log", 23);
    freq.put("loi", 4);
    freq.put("lon", 15);
    freq.put("loo", 3);
    freq.put("lol", 16);
    freq.put("lop", 4);
    freq.put("lov", 14);
    freq.put("low", 12);
    freq.put("J", 164);
    freq.put("Đa", 10);
    freq.put("Đi", 29);
    freq.put("lo ", 30);
    freq.put("fể", 30);
    freq.put("Mua", 10);
    freq.put("đu", 21);
    freq.put("đt", 18);
    freq.put("đy", 5);
    freq.put("đa", 261);
    freq.put("đc", 192);
    freq.put("đe", 51);
    freq.put("đg", 4);
    freq.put("đi", 823);
    freq.put("đh", 3);
    freq.put("đk", 13);
    freq.put("đj", 3);
    freq.put("đm", 9);
    freq.put("đo", 47);
    freq.put("yoo", 4);
    freq.put("Lam", 3);
    freq.put("Lan", 11);
    freq.put("Lai", 7);
    freq.put("Văn", 22);
    freq.put("you", 14);
    freq.put("Đó", 5);
    freq.put("c ", 2710);
    freq.put("Đô", 19);
    freq.put("Đú", 13);
    freq.put("úa ", 13);
    freq.put("Đâ", 9);
    freq.put("đ ", 26);
    freq.put("Đà", 11);
    freq.put("Đá", 8);
    freq.put("Đê", 4);
    freq.put("Đì", 5);
    freq.put("rSi", 4);
    freq.put("La ", 10);
    freq.put("yo ", 15);
    freq.put("ùm ", 15);
    freq.put("QUể", 3);
    freq.put("Sể", 52);
    freq.put("Bra", 5);
    freq.put("mp ", 6);
    freq.put("", 3);
    freq.put("rùn", 8);
    freq.put("rùm", 3);
    freq.put("rùi", 37);
    freq.put("rùa", 3);
    freq.put(" rõ", 27);
    freq.put("dzể", 16);
    freq.put(" rò", 6);
    freq.put("mpl", 15);
    freq.put(" rù", 43);
    freq.put(" rú", 12);
    freq.put(" rá", 13);
    freq.put(" rà", 13);
    freq.put(" râ", 6);
    freq.put(" rì", 6);
    freq.put("xăn", 4);
    freq.put("Hà ", 42);
    freq.put(" r ", 91);
    freq.put("Sơ", 8);
    freq.put("Cưể", 5);
    freq.put(" ru", 27);
    freq.put("Hàn", 33);
    freq.put(" re", 38);
    freq.put(" ra", 272);
    freq.put(" ro", 32);
    freq.put(" ri", 25);
    freq.put("TS ", 9);
    freq.put(" rư", 6);
    freq.put(" Cr", 7);
    freq.put("vc", 3);
    freq.put(" rơ", 8);
    freq.put("LFs", 4);
    freq.put("Nể ", 8);
    freq.put("S ", 106);
    freq.put("để", 1811);
    freq.put("ểN ", 33);
    freq.put("câ", 69);
    freq.put("cà", 56);
    freq.put("LF ", 26);
    freq.put("sâu", 6);
    freq.put("Ss", 11);
    freq.put("Sr", 3);
    freq.put("Sp", 5);
    freq.put("Nểu", 12);
    freq.put("Su", 73);
    freq.put("St", 19);
    freq.put("FC ", 8);
    freq.put("Nểi", 30);
    freq.put("fâ", 3);
    freq.put("Sh", 26);
    freq.put("So", 30);
    freq.put("Nển", 3);
    freq.put("Sl", 5);
    freq.put("Sc", 4);
    freq.put("Sa", 72);
    freq.put("sân", 13);
    freq.put("Se", 19);
    freq.put("rưể", 100);
    freq.put("loể", 56);
    freq.put("f ", 65);
    freq.put("hhe", 3);
    freq.put("hhh", 96);
    freq.put(" ră", 12);
    freq.put("Mì", 66);
    freq.put("eg ", 3);
    freq.put("fr", 9);
    freq.put("ft", 13);
    freq.put("fu", 11);
    freq.put("Só", 5);
    freq.put("fa", 139);
    freq.put("fb", 16);
    freq.put("fc", 9);
    freq.put("fe", 19);
    freq.put("ff", 24);
    freq.put("fi", 66);
    freq.put("Sá", 10);
    freq.put("Sà", 7);
    freq.put(" rũ", 4);
    freq.put("fo", 38);
    freq.put("a", 9182);
    freq.put("Mã ", 4);
    freq.put("Để", 138);
    freq.put("lăn", 14);
    freq.put("Xể ", 3);
    freq.put("hót", 8);
    freq.put("ce ", 25);
    freq.put("y ", 3062);
    freq.put("Thư", 11);
    freq.put("ffi", 4);
    freq.put("Thơ", 3);
    freq.put("Cli", 4);
    freq.put(" On", 7);
    freq.put(" Ok", 3);
    freq.put(" Oh", 23);
    freq.put(" Of", 8);
    freq.put(" Or", 3);
    freq.put(" Op", 13);
    freq.put("yh", 9);
    freq.put("yk", 7);
    freq.put("ym", 6);
    freq.put("ceb", 9);
    freq.put("yo", 40);
    freq.put("yn", 6);
    freq.put("ya", 29);
    freq.put("cen", 6);
    freq.put("yb", 3);
    freq.put("ye", 50);
    freq.put("yy", 17);
    freq.put("cer", 11);
    freq.put("cep", 6);
    freq.put("uv ", 3);
    freq.put("yp", 3);
    freq.put("ys", 10);
    freq.put("yr", 7);
    freq.put("yu", 152);
    freq.put("ff ", 16);
    freq.put("ift", 3);
    freq.put(" O ", 31);
    freq.put("đm ", 9);
    freq.put("ifo", 3);
    freq.put("ifi", 3);
    freq.put("Eng", 7);
    freq.put("ểm ", 696);
    freq.put("as ", 10);
    freq.put(" Oá", 3);
    freq.put("Thă", 4);
    freq.put("ass", 16);
    freq.put("yê", 187);
    freq.put("gTe", 3);
    freq.put("ast", 10);
    freq.put("asy", 3);
    freq.put("ase", 11);
    freq.put("asi", 7);
    freq.put("ash", 8);
    freq.put("aso", 3);
    freq.put(" F ", 9);
    freq.put(" pể", 25);
    freq.put("Ima", 5);
    freq.put("đâu", 222);
    freq.put(" Mể", 138);
    freq.put("đây", 144);
    freq.put("đoể", 24);
    freq.put("nc ", 39);
    freq.put("đâm", 7);
    freq.put("st ", 53);
    freq.put("liê", 17);
    freq.put("tfi", 4);
    freq.put("Thô", 18);
    freq.put("nch", 10);
    freq.put("Thí", 11);
    freq.put("Thì", 12);
    freq.put("Thê", 5);
    freq.put("nco", 5);
    freq.put("nca", 8);
    freq.put("nce", 25);
    freq.put("Thá", 14);
    freq.put("Thà", 13);
    freq.put("ste", 13);
    freq.put("sta", 19);
    freq.put("YH ", 6);
    freq.put("sto", 6);
    freq.put("sti", 9);
    freq.put("str", 22);
    freq.put("sty", 3);
    freq.put("Goo", 14);
    freq.put("ka ", 5);
    freq.put("lid", 3);
    freq.put("lie", 6);
    freq.put("húg", 3);
    freq.put("Nin", 6);
    freq.put("lib", 3);
    freq.put("Nim", 22);
    freq.put("lim", 4);
    freq.put("lin", 61);
    freq.put("hún", 49);
    freq.put("lik", 10);
    freq.put("hút", 23);
    freq.put("liv", 15);
    freq.put("lip", 16);
    freq.put("lis", 10);
    freq.put("úi ", 11);
    freq.put("kak", 7);
    freq.put("Thu", 14);
    freq.put("kar", 3);
    freq.put("Thi", 29);
    freq.put("răm", 9);
    freq.put("Tha", 26);
    freq.put("li ", 5);
    freq.put("hú ", 78);
    freq.put(" Á ", 10);
    freq.put("ÚC ", 3);
    freq.put(" tĩ", 3);
    freq.put(" tă", 33);
    freq.put(" Án", 3);
    freq.put(" Áo", 4);
    freq.put(" Áp", 3);
    freq.put("ã", 469);
    freq.put("áº£", 4);
    freq.put("áº§", 3);
    freq.put("ym ", 4);
    freq.put("x", 1042);
    freq.put("bé ", 45);
    freq.put(" tư", 111);
    freq.put("sư ", 11);
    freq.put(" tơ", 6);
    freq.put("Chể", 63);
    freq.put("wow", 3);
    freq.put("wor", 9);
    freq.put("woo", 23);
    freq.put("won", 23);
    freq.put("Rể", 27);
    freq.put("ơj ", 5);
    freq.put("béo", 43);
    freq.put("Phể", 20);
    freq.put("mh ", 7);
    freq.put("Lể ", 8);
    freq.put(" t ", 259);
    freq.put("Đưể", 5);
    freq.put(" ty", 33);
    freq.put("boy", 11);
    freq.put(" tw", 109);
    freq.put(" tv", 3);
    freq.put(" tu", 208);
    freq.put(" ts", 14);
    freq.put(" tr", 1139);
    freq.put("N", 694);
    freq.put(" to", 178);
    freq.put(" tn", 7);
    freq.put(" tl", 3);
    freq.put(" tk", 14);
    freq.put("Lểc", 10);
    freq.put(" ti", 380);
    freq.put(" th", 3060);
    freq.put("Lển", 7);
    freq.put(" te", 35);
    freq.put(" ta", 343);
    freq.put("Lểi", 17);
    freq.put("LểI", 3);
    freq.put("nói", 210);
    freq.put("nón", 11);
    freq.put("boi", 3);
    freq.put("xể", 78);
    freq.put("gs ", 7);
    freq.put("bok", 3);
    freq.put("õ ", 42);
    freq.put(" tý", 6);
    freq.put(" tú", 9);
    freq.put(" tù", 10);
    freq.put("nó ", 308);
    freq.put(" tô", 117);
    freq.put(" tó", 55);
    freq.put(" tò", 10);
    freq.put(" tí", 110);
    freq.put(" tì", 100);
    freq.put(" tê", 56);
    freq.put(" té", 4);
    freq.put(" tè", 4);
    freq.put("húa", 6);
    freq.put(" tâ", 45);
    freq.put(" tá", 58);
    freq.put(" tà", 24);
    freq.put("húc", 48);
    freq.put("lic", 11);
    freq.put("õm", 3);
    freq.put("õi", 4);
    freq.put("gsh", 3);
    freq.put(" tÃ", 3);
    freq.put("hjx", 3);
    freq.put("hjh", 3);
    freq.put("Máy", 6);
    freq.put("ee ", 39);
    freq.put("Tư", 10);
    freq.put("dì ", 14);
    freq.put("hj ", 10);
    freq.put("eet", 43);
    freq.put("eep", 5);
    freq.put("Má ", 12);
    freq.put("een", 15);
    freq.put("eee", 16);
    freq.put("eec", 8);
    freq.put("cg ", 4);
    freq.put("ru ", 7);
    freq.put("ãy ", 56);
    freq.put("mì ", 11);
    freq.put(" Qu", 98);
    freq.put("xác", 17);
    freq.put("id ", 23);
    freq.put("rui", 3);
    freq.put("run", 47);
    freq.put("ruo", 4);
    freq.put("rum", 18);
    freq.put("AM ", 9);
    freq.put("rua", 3);
    freq.put("rug", 3);
    freq.put("ruy", 22);
    freq.put("mìh", 14);
    freq.put("mìn", 368);
    freq.put(" Q ", 5);
    freq.put("ido", 6);
    freq.put("ide", 22);
    freq.put("ida", 3);
    freq.put("Tú", 3);
    freq.put("Tô", 29);
    freq.put("Tó", 6);
    freq.put("ểo ", 238);
    freq.put("Tì", 11);
    freq.put("Tí", 10);
    freq.put("Tê", 6);
    freq.put("aq ", 3);
    freq.put("Tâ", 15);
    freq.put("The", 19);
    freq.put("Tà", 11);
    freq.put("ut ", 36);
    freq.put("ghể", 62);
    freq.put("utf", 4);
    freq.put("ute", 21);
    freq.put("uto", 4);
    freq.put("utu", 5);
    freq.put("uty", 4);
    freq.put(" Kể", 24);
    freq.put("Tw", 3);
    freq.put("Tu", 33);
    freq.put("Tr", 151);
    freq.put("Ts", 25);
    freq.put("điể", 98);
    freq.put("To", 73);
    freq.put("đài", 5);
    freq.put("đàn", 30);
    freq.put("đào", 5);
    freq.put("Th", 295);
    freq.put("Ti", 49);
    freq.put("Te", 37);
    freq.put("Ta", 40);
    freq.put("nac", 4);
    freq.put("Bưể", 3);
    freq.put("nag", 3);
    freq.put("nae", 4);
    freq.put("nai", 14);
    freq.put("nan", 10);
    freq.put("nao", 6);
    freq.put("nal", 8);
    freq.put("nam", 28);
    freq.put("nar", 8);
    freq.put("nat", 6);
    freq.put("nay", 218);
    freq.put("oon", 37);
    freq.put("eHy", 4);
    freq.put("T ", 371);
    freq.put("na ", 29);
    freq.put("e", 3883);
    freq.put("Ad", 9);
    freq.put("Af", 4);
    freq.put("Ai", 22);
    freq.put("Ah", 7);
    freq.put("Al", 6);
    freq.put("Ao", 3);
    freq.put("An", 74);
    freq.put("Ap", 8);
    freq.put("As", 5);
    freq.put("Ar", 4);
    freq.put("Au", 3);
    freq.put("ú", 599);
    freq.put("zì", 8);
    freq.put("gu", 100);
    freq.put("gt", 10);
    freq.put("gs", 21);
    freq.put("Gir", 6);
    freq.put("gq", 3);
    freq.put("zà", 6);
    freq.put("gy", 6);
    freq.put("gg", 7);
    freq.put("ge", 56);
    freq.put("gd", 5);
    freq.put("gb", 3);
    freq.put("Gia", 20);
    freq.put("go", 151);
    freq.put("gn", 11);
    freq.put("gm", 13);
    freq.put("gl", 15);
    freq.put("gj", 3);
    freq.put("gi", 791);
    freq.put("gh", 451);
    freq.put("Non", 5);
    freq.put("gT", 3);
    freq.put("Nok", 4);
    freq.put("Tể ", 46);
    freq.put("gH", 4);
    freq.put("g ", 5496);
    freq.put("No ", 7);
    freq.put("lk ", 11);
    freq.put(" vư", 16);
    freq.put("Spa", 3);
    freq.put("gõ", 9);
    freq.put("gô", 21);
    freq.put("gó", 28);
    freq.put("gò", 7);
    freq.put("ze", 11);
    freq.put("za", 87);
    freq.put("gù", 5);
    freq.put("đ", 4923);
    freq.put("gàn", 12);
    freq.put("gào", 20);
    freq.put("gã", 11);
    freq.put("gâ", 28);
    freq.put("gá", 78);
    freq.put("gà", 226);
    freq.put("zu", 10);
    freq.put("gì", 229);
    freq.put("gê", 8);
    freq.put("gé", 3);
    freq.put("Ah ", 5);
    freq.put("Án ", 3);
    freq.put(" vũ", 11);
    freq.put("Để ", 17);
    freq.put(" vă", 20);
    freq.put("z ", 49);
    freq.put("ĐểT", 3);
    freq.put(" vđ", 5);
    freq.put("ĐểI", 3);
    freq.put("ĐểN", 5);
    freq.put("gà ", 15);
    freq.put("rũ ", 3);
    freq.put("Trể", 36);
    freq.put("Đểt", 11);
    freq.put("Đểu", 8);
    freq.put("Đểi", 23);
    freq.put("Đển", 25);
    freq.put("Đểo", 3);
    freq.put("năn", 8);
    freq.put("Đểm", 4);
    freq.put("Đểc", 16);
    freq.put("ùa ", 36);
    freq.put("win", 5);
    freq.put("dài", 29);
    freq.put("wit", 26);
    freq.put(" vá", 14);
    freq.put(" và", 440);
    freq.put(" vã", 22);
    freq.put(" vâ", 26);
    freq.put(" vé", 30);
    freq.put(" vì", 120);
    freq.put(" vò", 9);
    freq.put(" vô", 50);
    freq.put(" vù", 6);
    freq.put("dà ", 3);
    freq.put("gĩ", 5);
    freq.put("ox ", 15);
    freq.put(" nể", 484);
    freq.put("Mr ", 9);
    freq.put("hiu", 13);
    freq.put(" va", 43);
    freq.put(" vc", 3);
    freq.put(" ve", 37);
    freq.put(" vd", 5);
    freq.put(" vi", 240);
    freq.put("tò ", 5);
    freq.put(" vk", 8);
    freq.put(" vl", 6);
    freq.put(" vo", 52);
    freq.put(" vn", 26);
    freq.put(" vs", 115);
    freq.put(" vu", 71);
    freq.put("vđ ", 5);
    freq.put("NH ", 22);
    freq.put("gư", 191);
    freq.put("HI ", 6);
    freq.put("gơ", 17);
    freq.put(" v ", 23);
    freq.put("tòa", 5);
    freq.put("MrS", 4);
    freq.put("hic", 11);
    freq.put("TO ", 4);
    freq.put("Ã­n", 3);
    freq.put("Bìn", 18);
    freq.put("cô ", 64);
    freq.put("băn", 8);
    freq.put("jn ", 3);
    freq.put("Đêm", 4);
    freq.put("wể", 3);
    freq.put("côn", 87);
    freq.put("ơ ", 181);
    freq.put("hla", 3);
    freq.put("ưa ", 242);
    freq.put("ơg", 4);
    freq.put("CE ", 3);
    freq.put("ơi", 309);
    freq.put("ơj", 5);
    freq.put("ơm", 25);
    freq.put("ơn", 321);
    freq.put("ect", 14);
    freq.put("ecr", 3);
    freq.put("dể", 377);
    freq.put("Æ ", 3);
    freq.put(" Sơ", 8);
    freq.put("rs ", 4);
    freq.put("Vtr", 5);
    freq.put("art", 23);
    freq.put("mê ", 10);
    freq.put(" Sr", 3);
    freq.put(" Ss", 11);
    freq.put("be ", 17);
    freq.put(" St", 17);
    freq.put(" Su", 69);
    freq.put(" Sh", 23);
    freq.put(" Si", 46);
    freq.put(" So", 30);
    freq.put(" Sl", 5);
    freq.put("gĩ ", 5);
    freq.put(" Sc", 4);
    freq.put(" Sa", 72);
    freq.put(" Se", 19);
    freq.put("xã ", 7);
    freq.put("rsi", 4);
    freq.put("ểể", 7);
    freq.put("rse", 6);
    freq.put("XH ", 5);
    freq.put("thể", 1291);
    freq.put("vòn", 8);
    freq.put("ben", 3);
    freq.put("bel", 3);
    freq.put("niể", 12);
    freq.put("bea", 4);
    freq.put("MU ", 3);
    freq.put(" Cể", 100);
    freq.put("ber", 7);
    freq.put("bes", 4);
    freq.put(" S ", 19);
    freq.put("ãi", 84);
    freq.put("ão", 41);
    freq.put("ãn", 22);
    freq.put("ãm", 6);
    freq.put("ãy", 56);
    freq.put("py ", 9);
    freq.put("ểa ", 1029);
    freq.put("aw ", 4);
    freq.put("ur ", 12);
    freq.put("ìa", 40);
    freq.put("Lý ", 4);
    freq.put(" Só", 4);
    freq.put("ìm", 59);
    freq.put("ìh", 16);
    freq.put("ìu", 19);
    freq.put(" Sà", 7);
    freq.put(" Sá", 10);
    freq.put("ã ", 259);
    freq.put("vl ", 4);
    freq.put("lúc", 91);
    freq.put("áu ", 41);
    freq.put("Sán", 8);
    freq.put("ì ", 870);
    freq.put("uro", 3);
    freq.put("tĩn", 3);
    freq.put("Del", 4);
    freq.put("buo", 4);
    freq.put("bểm", 7);
    freq.put("bển", 580);
    freq.put("bểo", 107);
    freq.put("bểi", 36);
    freq.put("ngH", 4);
    freq.put("bểa", 26);
    freq.put("bểc", 38);
    freq.put("ngT", 3);
    freq.put("bểy", 8);
    freq.put("bểt", 108);
    freq.put("tb ", 4);
    freq.put("bểp", 7);
    freq.put(" （｡", 3);
    freq.put("ngd", 4);
    freq.put("nge", 20);
    freq.put("luô", 83);
    freq.put("nga", 54);
    freq.put("kểc", 7);
    freq.put("ngl", 3);
    freq.put("ngm", 7);
    freq.put("kểo", 3);
    freq.put("ngo", 109);
    freq.put("ngh", 295);
    freq.put("ngi", 11);
    freq.put("sh ", 12);
    freq.put("kểt", 36);
    freq.put("kểp", 16);
    freq.put("ngs", 16);
    freq.put("b", 3075);
    freq.put("bể ", 389);
    freq.put("ttt", 5);
    freq.put("Lươ", 4);
    freq.put("ng ", 5099);
    freq.put("kể ", 97);
    freq.put("sha", 4);
    freq.put("shi", 43);
    freq.put("sho", 31);
    freq.put("Sr ", 3);
    freq.put("ke ", 40);
    freq.put("lus", 3);
    freq.put("ngà", 180);
    freq.put("ngá", 6);
    freq.put("ngâ", 9);
    freq.put("ngã", 6);
    freq.put("luy", 5);
    freq.put("ngô", 13);
    freq.put("ngõ", 3);
    freq.put("luc", 5);
    freq.put("lue", 3);
    freq.put("ngó", 7);
    freq.put("ngù", 3);
    freq.put("lun", 51);
    freq.put("kem", 9);
    freq.put("kek", 13);
    freq.put("ked", 4);
    freq.put("sểm", 37);
    freq.put("ket", 4);
    freq.put("ker", 6);
    freq.put("ũ", 443);
    freq.put("ot ", 29);
    freq.put("Lon", 14);
    freq.put("nên", 151);
    freq.put("Lol", 3);
    freq.put("Lov", 6);
    freq.put("nêu", 3);
    freq.put("áp ", 29);
    freq.put("lểt", 13);
    freq.put("lểu", 5);
    freq.put("An ", 9);
    freq.put("oke", 6);
    freq.put("lểp", 43);
    freq.put("đè ", 3);
    freq.put("lểy", 40);
    freq.put("yao", 3);
    freq.put("yan", 4);
    freq.put("Đăn", 4);
    freq.put("lểc", 60);
    freq.put("lểa", 20);
    freq.put("lển", 160);
    freq.put("lểm", 151);
    freq.put("lểi", 406);
    freq.put("oti", 5);
    freq.put("Rye", 4);
    freq.put("oto", 7);
    freq.put("ote", 44);
    freq.put("ott", 4);
    freq.put("And", 3);
    freq.put("Ano", 3);
    freq.put("Anh", 56);
    freq.put("ngĩ", 5);
    freq.put("lể ", 77);
    freq.put("ya ", 15);
    freq.put("Yoo", 6);
    freq.put("ơn ", 182);
    freq.put("dân", 13);
    freq.put("dây", 9);
    freq.put("You", 10);
    freq.put("dâu", 5);
    freq.put("xài", 14);
    freq.put("PP ", 4);
    freq.put("ân ", 204);
    freq.put(" lể", 981);
    freq.put("ngơ", 11);
    freq.put("gân", 9);
    freq.put("ngư", 160);
    freq.put("gây", 18);
    freq.put(" xD", 40);
    freq.put("hĩ", 79);
    freq.put("uMi", 5);
    freq.put("iêu", 59);
    freq.put("Be", 20);
    freq.put(" xi", 66);
    freq.put("oác", 5);
    freq.put("Ba", 41);
    freq.put("inM", 3);
    freq.put("Bl", 13);
    freq.put("oán", 35);
    freq.put(" xa", 41);
    freq.put("Bo", 14);
    freq.put(" xg", 3);
    freq.put("Bi", 30);
    freq.put(" xe", 217);
    freq.put("Bu", 14);
    freq.put("oát", 9);
    freq.put("Br", 8);
    freq.put("hă", 54);
    freq.put("gơ ", 14);
    freq.put(" xu", 77);
    freq.put("hũ", 4);
    freq.put("B ", 63);
    freq.put("oá ", 11);
    freq.put(" x ", 44);
    freq.put("đt ", 18);
    freq.put("tìn", 65);
    freq.put("tìm", 34);
    freq.put("hư", 802);
    freq.put("êng", 23);
    freq.put("hơ", 263);
    freq.put("U ", 41);
    freq.put(" xé", 7);
    freq.put("Bà", 8);
    freq.put("Bá", 46);
    freq.put(" xí", 7);
    freq.put(" xì", 11);
    freq.put(" xã", 7);
    freq.put("Bí", 4);
    freq.put(" xá", 20);
    freq.put(" xà", 17);
    freq.put("Bé", 5);
    freq.put("Bô", 6);
    freq.put(" xú", 15);
    freq.put(" xù", 3);
    freq.put("Bó", 3);
    freq.put(" xó", 10);
    freq.put(" xô", 10);
    freq.put("Up", 5);
    freq.put(" đè", 8);
    freq.put("Un", 6);
    freq.put("Uh", 15);
    freq.put("Uk", 3);
    freq.put("pt", 12);
    freq.put("duo", 11);
    freq.put(" Gể", 13);
    freq.put("Đìn", 5);
    freq.put("EE ", 3);
    freq.put("ea ", 7);
    freq.put("h ", 3320);
    freq.put("Luv", 3);
    freq.put("duy", 8);
    freq.put("eah", 7);
    freq.put("eak", 8);
    freq.put("hy", 43);
    freq.put("eam", 23);
    freq.put("eal", 6);
    freq.put("ean", 7);
    freq.put(" xă", 5);
    freq.put("CG ", 3);
    freq.put("hp", 4);
    freq.put("hq", 6);
    freq.put("ead", 8);
    freq.put("ht", 23);
    freq.put("hu", 685);
    freq.put("hj", 25);
    freq.put("hk", 7);
    freq.put("hh", 116);
    freq.put("hi", 1101);
    freq.put("PM ", 3);
    freq.put("ho", 895);
    freq.put("hl", 4);
    freq.put("hm", 41);
    freq.put("hc", 8);
    freq.put("eas", 14);
    freq.put("ear", 16);
    freq.put("eau", 4);
    freq.put("eat", 6);
    freq.put("hd", 8);
    freq.put("he", 445);
    freq.put("dmi", 3);
    freq.put("Hâm", 4);
    freq.put(" ơ ", 12);
    freq.put("hn ", 5);
    freq.put("Lểp", 3);
    freq.put(" Up", 5);
    freq.put("mè ", 3);
    freq.put(" ưể", 16);
    freq.put(" Un", 4);
    freq.put("để ", 392);
    freq.put(" Uh", 13);
    freq.put(" Uk", 3);
    freq.put("hú", 210);
    freq.put("hù", 34);
    freq.put("hý", 5);
    freq.put("hò", 43);
    freq.put("hó", 172);
    freq.put("hô", 549);
    freq.put("hê", 144);
    freq.put("Mểt", 29);
    freq.put("hé", 172);
    freq.put("hì", 689);
    freq.put("hí", 264);
    freq.put("hâ", 162);
    freq.put("hã", 38);
    freq.put("hà", 514);
    freq.put(" tp", 3);
    freq.put("hna", 43);
    freq.put("mèo", 10);
    freq.put("đểp", 210);
    freq.put("đểu", 175);
    freq.put("đểt", 82);
    freq.put(" ơi", 154);
    freq.put("đểy", 132);
    freq.put(" ơn", 21);
    freq.put("đểc", 111);
    freq.put("đểa", 68);
    freq.put("đểg", 7);
    freq.put("hÃ", 6);
    freq.put("đểi", 174);
    freq.put(" xư", 15);
    freq.put("đểo", 16);
    freq.put("đển", 428);
    freq.put("đểm", 11);
    freq.put(" tj", 5);
    freq.put("Lểa", 4);
    freq.put(" tg", 6);
    freq.put("ểc ", 1339);
    freq.put("aul", 4);
    freq.put("up ", 26);
    freq.put("aut", 4);
    freq.put("àg ", 9);
    freq.put(" ê ", 12);
    freq.put("cưể", 88);
    freq.put("ểch", 101);
    freq.put("au ", 248);
    freq.put("upl", 11);
    freq.put("MA ", 5);
    freq.put("âng", 23);
    freq.put("upd", 3);
    freq.put("upe", 28);
    freq.put("hcm", 3);
    freq.put("upp", 3);
    freq.put("me ", 51);
    freq.put("íc ", 8);
    freq.put("nen", 9);
    freq.put("nel", 4);
    freq.put("uyể", 247);
    freq.put("ney", 11);
    freq.put("new", 10);
    freq.put("sj ", 4);
    freq.put("KHể", 4);
    freq.put("ner", 10);
    freq.put("nes", 9);
    freq.put("mee", 3);
    freq.put("ích", 136);
    freq.put("mem", 9);
    freq.put("mel", 9);
    freq.put("men", 27);
    freq.put("MÀ ", 4);
    freq.put("mer", 8);
    freq.put("ne ", 61);
    freq.put("orm", 6);
    freq.put("dro", 4);
    freq.put("đươ", 7);
    freq.put("kg ", 7);
    freq.put("cm ", 10);
    freq.put("Vé ", 4);
    freq.put("Tiv", 5);
    freq.put("Á", 24);
    freq.put("Ste", 5);
    freq.put("Sta", 6);
    freq.put("Sto", 6);
    freq.put("V", 361);
    freq.put("Tin", 16);
    freq.put("ìu ", 18);
    freq.put("Ăn", 4);
    freq.put("Lin", 8);
    freq.put("Lik", 6);
    freq.put("Liv", 7);
    freq.put("ĩa ", 24);
    freq.put("Kar", 6);
    freq.put("yêu", 122);
    freq.put("nè ", 31);
    freq.put("dểy", 34);
    freq.put("ova", 9);
    freq.put("ove", 26);
    freq.put("ovi", 5);
    freq.put("dểt", 11);
    freq.put("dểu", 12);
    freq.put("buể", 58);
    freq.put("Ă", 4);
    freq.put("rác", 12);
    freq.put("rán", 16);
    freq.put("ráo", 3);
    freq.put("rái", 9);
    freq.put(" zì", 8);
    freq.put("gì ", 225);
    freq.put("Ú ", 3);
    freq.put(" zà", 6);
    freq.put(" zô", 5);
    freq.put("ona", 17);
    freq.put("PR ", 3);
    freq.put("ưểp", 9);
    freq.put("bóp", 5);
    freq.put("ưểt", 29);
    freq.put("ưểu", 4);
    freq.put("bón", 23);
    freq.put("ưểi", 277);
    freq.put("ưển", 305);
    freq.put("ưểm", 4);
    freq.put("ưểc", 206);
    freq.put("ưểg", 9);
    freq.put("Wor", 3);
    freq.put("Woo", 17);
    freq.put("HMo", 9);
    freq.put("SS ", 20);
    freq.put(" zi", 4);
    freq.put("oãn", 3);
    freq.put(" za", 73);
    freq.put("xu ", 6);
    freq.put(" zu", 7);
    freq.put("is ", 24);
    freq.put("HM ", 4);
    freq.put("iss", 17);
    freq.put(" z ", 7);
    freq.put("ist", 16);
    freq.put("ish", 6);
    freq.put("isa", 4);
    freq.put("ÔI ", 6);
    freq.put("xui", 8);
    freq.put("ise", 4);
    freq.put("rểt", 104);
    freq.put("rểu", 10);
    freq.put("lá ", 3);
    freq.put("uát", 3);
    freq.put("uái", 6);
    freq.put("rểm", 11);
    freq.put("rển", 120);
    freq.put("jjj", 11);
    freq.put("uán", 14);
    freq.put("Ã¡c", 3);
    freq.put("đơn", 16);
    freq.put("rểa", 16);
    freq.put("rểc", 24);
    freq.put("lán", 3);
    freq.put("láo", 5);
    freq.put("lái", 4);
    freq.put("đơ ", 7);
    freq.put("lát", 5);
    freq.put("uá ", 295);
    freq.put("Ã¡ ", 4);
    freq.put("rể ", 176);
    freq.put("jj ", 3);
    freq.put("ty ", 44);
    freq.put("do ", 47);
    freq.put("tyl", 4);
    freq.put("căm", 5);
    freq.put("căn", 21);
    freq.put("doi", 5);
    freq.put("don", 27);
    freq.put("dol", 8);
    freq.put("dom", 7);
    freq.put("doc", 7);
    freq.put("doa", 14);
    freq.put("m", 7272);
    freq.put("dog", 3);
    freq.put("dor", 3);
    freq.put("dow", 50);
    freq.put(" We", 6);
    freq.put(" Wa", 4);
    freq.put("Că", 7);
    freq.put(" Wo", 30);
    freq.put(" Wh", 6);
    freq.put(" Wi", 12);
    freq.put("Tuể", 6);
    freq.put("èn ", 11);
    freq.put("ba ", 16);
    freq.put("Đau", 3);
    freq.put("Có ", 45);
    freq.put("Đan", 5);
    freq.put("Cũ", 4);
    freq.put("bas", 5);
    freq.put("bay", 28);
    freq.put("quể", 104);
    freq.put("bab", 10);
    freq.put("bac", 18);
    freq.put("ban", 58);
    freq.put("bao", 82);
    freq.put("bal", 5);
    freq.put("bak", 4);
    freq.put("bai", 6);
    freq.put("Vă", 22);
    freq.put("lể", 981);
    freq.put("Vĩ", 3);
    freq.put("Cơ", 10);
    freq.put("un ", 110);
    freq.put("ài ", 265);
    freq.put("Cư", 18);
    freq.put("omb", 4);
    freq.put("oma", 9);
    freq.put("ome", 15);
    freq.put("omi", 6);
    freq.put("omo", 6);
    freq.put("omm", 9);
    freq.put("omp", 3);
    freq.put("unH", 12);
    freq.put("uns", 8);
    freq.put("unt", 9);
    freq.put("ểe ", 26);
    freq.put("Vũ", 8);
    freq.put("áy ", 70);
    freq.put("una", 3);
    freq.put("unb", 3);
    freq.put("und", 8);
    freq.put("unf", 4);
    freq.put("ung", 260);
    freq.put("unh", 20);
    freq.put("uni", 17);
    freq.put("Lùn", 3);
    freq.put("unk", 4);
    freq.put("unn", 12);
    freq.put("iú", 14);
    freq.put("ón ", 19);
    freq.put("miể", 35);
    freq.put("ía ", 12);
    freq.put("iê", 309);
    freq.put("iá", 140);
    freq.put("ià", 67);
    freq.put("iã", 4);
    freq.put("iâ", 4);
    freq.put("C ", 85);
    freq.put("iãy", 4);
    freq.put("iÃ", 5);
    freq.put("óng", 91);
    freq.put("Và", 15);
    freq.put("Vâ", 8);
    freq.put("Vã", 4);
    freq.put("Co", 38);
    freq.put("Cl", 6);
    freq.put("Vé", 5);
    freq.put("Ca", 24);
    freq.put("Vì", 12);
    freq.put("Vô", 4);
    freq.put("Cr", 8);
    freq.put("sla", 5);
    freq.put("Cu", 20);
    freq.put("Ct", 7);
    freq.put("ix", 24);
    freq.put("iz", 46);
    freq.put("ip", 60);
    freq.put("is", 75);
    freq.put("Nai", 3);
    freq.put("iu", 51);
    freq.put("it", 116);
    freq.put("iw", 10);
    freq.put("iv", 38);
    freq.put("ii", 85);
    freq.put("ih", 13);
    freq.put("ik", 74);
    freq.put("ij", 5);
    freq.put("im", 208);
    freq.put("il", 61);
    freq.put("io", 79);
    freq.put("in", 772);
    freq.put("ia", 336);
    freq.put("ic", 146);
    freq.put("ib", 11);
    freq.put("ie", 168);
    freq.put("id", 60);
    freq.put("ig", 47);
    freq.put("if", 15);
    freq.put("V ", 41);
    freq.put("đê ", 21);
    freq.put("iP", 12);
    freq.put("hòn", 21);
    freq.put("hòi", 3);
    freq.put("iO", 4);
    freq.put("hòa", 13);
    freq.put("iD", 5);
    freq.put("Na ", 10);
    freq.put("kis", 6);
    freq.put("kir", 8);
    freq.put("kiu", 6);
    freq.put("kin", 59);
    freq.put("kim", 3);
    freq.put("i ", 7785);
    freq.put("kia", 88);
    freq.put("kie", 14);
    freq.put("Va", 5);
    freq.put("Ve", 7);
    freq.put("Vi", 80);
    freq.put("Cá", 91);
    freq.put("Cà", 4);
    freq.put("Vn", 7);
    freq.put("Vo", 8);
    freq.put("Cù", 6);
    freq.put("Vs", 3);
    freq.put("Vt", 5);
    freq.put("Vu", 8);
    freq.put("Có", 45);
    freq.put("Cò", 14);
    freq.put("hò ", 5);
    freq.put("Cô", 39);
    freq.put("yeo", 7);
    freq.put("yen", 9);
    freq.put("yea", 6);
    freq.put("op ", 37);
    freq.put("gôn", 6);
    freq.put("yep", 4);
    freq.put("yes", 8);
    freq.put("yeu", 3);
    freq.put("Đó ", 3);
    freq.put("vd ", 4);
    freq.put("Áp ", 3);
    freq.put("opp", 25);
    freq.put("ye ", 7);
    freq.put("opy", 3);
    freq.put("opa", 3);
    freq.put(" dâ", 28);
    freq.put(" dá", 29);
    freq.put("www", 34);
    freq.put("Tóc", 3);
    freq.put(" ể", 753);
    freq.put("ơng", 135);
    freq.put("PT ", 3);
    freq.put("ww ", 11);
    freq.put("zui", 6);
    freq.put("Yể", 9);
    freq.put("vì ", 119);
    freq.put("tè ", 3);
    freq.put("TE ", 7);
    freq.put("Z", 19);
    freq.put("chể", 1215);
    freq.put("zà ", 5);
    freq.put("HO ", 4);
    freq.put(" Dể", 38);
    freq.put("lãn", 6);
    freq.put("lão", 21);
    freq.put("Cơ ", 10);
    freq.put("lãi", 7);
    freq.put("Win", 9);
    freq.put("Wil", 3);
    freq.put("nks", 18);
    freq.put(" Yê", 20);
    freq.put("ưg ", 17);
    freq.put("nky", 4);
    freq.put("LH ", 5);
    freq.put("di ", 24);
    freq.put(" Đa", 10);
    freq.put(" Đi", 29);
    freq.put("din", 13);
    freq.put("dio", 5);
    freq.put("die", 19);
    freq.put("jhj", 3);
    freq.put("dia", 6);
    freq.put("dic", 3);
    freq.put("dit", 3);
    freq.put("diu", 3);
    freq.put("dis", 4);
    freq.put(" Yo", 20);
    freq.put(" Ya", 7);
    freq.put("Điể", 13);
    freq.put(" Ye", 26);
    freq.put("cuể", 70);
    freq.put("Gra", 3);
    freq.put(" Yu", 16);
    freq.put(" Đó", 5);
    freq.put(" Đô", 19);
    freq.put(" Đú", 13);
    freq.put(" Đã", 13);
    freq.put(" Đâ", 9);
    freq.put(" Đá", 8);
    freq.put(" Đà", 11);
    freq.put("bo ", 10);
    freq.put(" Đê", 4);
    freq.put("mô ", 8);
    freq.put(" Đì", 5);
    freq.put(" Y ", 7);
    freq.put("xù ", 3);
    freq.put("box", 9);
    freq.put("vô ", 50);
    freq.put("bos", 4);
    freq.put("biể", 241);
    freq.put("Diể", 10);
    freq.put("Wo", 37);
    freq.put("môi", 7);
    freq.put("môn", 26);
    freq.put("bom", 6);
    freq.put("bon", 11);
    freq.put("boo", 24);
    freq.put("àk ", 6);
    freq.put("cểy", 3);
    freq.put("oo ", 28);
    freq.put("cểu", 67);
    freq.put("cểt", 15);
    freq.put("cểp", 38);
    freq.put("cểm", 80);
    freq.put("cển", 110);
    freq.put("cểi", 9);
    freq.put(" gể", 261);
    freq.put("Wh", 6);
    freq.put("cểa", 476);
    freq.put("cểc", 39);
    freq.put("ayo", 5);
    freq.put("aya", 3);
    freq.put("fl ", 7);
    freq.put("ul ", 31);
    freq.put("ays", 5);
    freq.put("ood", 22);
    freq.put("oog", 10);
    freq.put("Ben", 4);
    freq.put("ooc", 5);
    freq.put("oom", 6);
    freq.put("ool", 10);
    freq.put("ooo", 22);
    freq.put("Bea", 5);
    freq.put("ook", 56);
    freq.put(" Đă", 4);
    freq.put("oor", 4);
    freq.put("Ber", 3);
    freq.put("cể ", 386);
    freq.put("ểg ", 60);
    freq.put("ay ", 658);
    freq.put("ult", 3);
    freq.put("ull", 8);
    freq.put("sn ", 12);
    freq.put("ma ", 51);
    freq.put("iám", 6);
    freq.put("iáo", 12);
    freq.put("gõ ", 9);
    freq.put("iác", 20);
    freq.put("mar", 4);
    freq.put("mau", 9);
    freq.put("mat", 15);
    freq.put("may", 24);
    freq.put("mac", 4);
    freq.put("mad", 3);
    freq.put("mag", 9);
    freq.put("maf", 3);
    freq.put("mai", 87);
    freq.put("mah", 4);
    freq.put("mak", 9);
    freq.put("mam", 4);
    freq.put("mal", 6);
    freq.put("mao", 3);
    freq.put("man", 75);
    freq.put(" Đư", 5);
    freq.put("iá ", 95);
    freq.put("q", 791);
    freq.put("ny ", 14);
    freq.put("hôg", 3);
    freq.put("lse", 4);
    freq.put("Luô", 3);
    freq.put("Nga", 6);
    freq.put("lsa", 5);
    freq.put("hôn", 214);
    freq.put("hôm", 106);
    freq.put("Ngo", 7);
    freq.put("Ngh", 21);
    freq.put("hôi", 202);
    freq.put("Ngu", 23);
    freq.put("kk ", 6);
    freq.put(" aa", 10);
    freq.put(" ab", 3);
    freq.put(" ac", 30);
    freq.put(" ad", 9);
    freq.put(" Bể", 142);
    freq.put(" ag", 3);
    freq.put(" ah", 157);
    freq.put(" ai", 167);
    freq.put(" ak", 16);
    freq.put(" al", 29);
    freq.put(" am", 5);
    freq.put(" an", 459);
    freq.put(" ao", 7);
    freq.put(" ap", 11);
    freq.put(" ar", 6);
    freq.put(" as", 6);
    freq.put(" at", 7);
    freq.put(" au", 5);
    freq.put(" av", 15);
    freq.put(" ay", 10);
    freq.put("Ng ", 3);
    freq.put("ls ", 3);
    freq.put("hô ", 22);
    freq.put("kki", 3);
    freq.put("kkk", 14);
    freq.put("Shi", 9);
    freq.put("Sho", 11);
    freq.put(" a ", 174);
    freq.put("iàu", 6);
    freq.put("đèn", 4);
    freq.put("Dư", 13);
    freq.put("Ngà", 11);
    freq.put("Ngâ", 5);
    freq.put("Ngô", 7);
    freq.put("or ", 40);
    freq.put("cá ", 16);
    freq.put("ㅋ", 14);
    freq.put("RT ", 45);
    freq.put("G", 283);
    freq.put("ory", 3);
    freq.put("ort", 8);
    freq.put("oru", 5);
    freq.put("orr", 10);
    freq.put("orn", 6);
    freq.put("nì ", 6);
    freq.put("orl", 8);
    freq.put("són", 8);
    freq.put("ùy ", 5);
    freq.put("ori", 8);
    freq.put("ord", 18);
    freq.put("ore", 21);
    freq.put("sóc", 3);
    freq.put("ora", 6);
    freq.put("iàn", 5);
    freq.put("App", 7);
    freq.put("cái", 539);
    freq.put("cáo", 12);
    freq.put("cán", 7);
    freq.put("các", 244);
    freq.put("ríc", 3);
    freq.put("Yan", 3);
    freq.put("lau", 13);
    freq.put("Tín", 5);
    freq.put("Dâ", 10);
    freq.put("Dù", 8);
    freq.put("rí ", 20);
    freq.put("Ya ", 3);
    freq.put("IS ", 6);
    freq.put("Do", 51);
    freq.put("Di", 24);
    freq.put("De", 7);
    freq.put("Da", 29);
    freq.put("Du", 15);
    freq.put("Dr", 5);
    freq.put("iwo", 7);
    freq.put("tên", 54);
    freq.put("Ngư", 28);
    freq.put("hể", 4980);
    freq.put("D ", 147);
    freq.put("ge ", 30);
    freq.put("lí ", 9);
    freq.put("We", 6);
    freq.put("Wa", 4);
    freq.put("HA ", 3);
    freq.put("Wi", 12);
    freq.put("Là ", 8);
    freq.put("ger", 10);
    freq.put("ùg ", 5);
    freq.put("tuý", 3);
    freq.put("cg", 7);
    freq.put("gen", 6);
    freq.put("gel", 3);
    freq.put("Lào", 3);
    freq.put("Làm", 9);
    freq.put("W ", 8);
    freq.put("ó", 2226);
    freq.put("BểN", 4);
    freq.put("tu ", 11);
    freq.put("j ", 305);
    freq.put("ㅋㅋ ", 3);
    freq.put("Bển", 54);
    freq.put("Bểo", 8);
    freq.put("Bểa", 3);
    freq.put("Bểc", 14);
    freq.put("FO ", 15);
    freq.put("dk ", 6);
    freq.put("uể ", 55);
    freq.put("Bểt", 13);
    freq.put("tuy", 31);
    freq.put("jx", 4);
    freq.put("ju", 24);
    freq.put("tui", 68);
    freq.put("jn", 4);
    freq.put("jo", 19);
    freq.put("jh", 3);
    freq.put("ji", 15);
    freq.put("jj", 15);
    freq.put("jk", 3);
    freq.put("je", 15);
    freq.put("tub", 4);
    freq.put("tuc", 3);
    freq.put("ja", 19);
    freq.put("uểt", 113);
    freq.put("Bể ", 39);
    freq.put("uểy", 4);
    freq.put("uểg", 7);
    freq.put("uểc", 111);
    freq.put("uển", 410);
    freq.put("uểm", 4);
    freq.put("Bôn", 6);
    freq.put("uểi", 90);
    freq.put("tun", 18);
    freq.put("tuo", 8);
    freq.put("Kiể", 20);
    freq.put("đó ", 355);
    freq.put("ãng", 9);
    freq.put("mò ", 10);
    freq.put("kể", 168);
    freq.put("Tp", 6);
    freq.put("fểt", 3);
    freq.put("đóa", 3);
    freq.put("đói", 12);
    freq.put("đón", 31);
    freq.put("hda", 5);
    freq.put("àm ", 329);
    freq.put("（｡ ", 3);
    freq.put("oi ", 218);
    freq.put("par", 10);
    freq.put("pas", 9);
    freq.put("pac", 3);
    freq.put("pag", 7);
    freq.put("pai", 4);
    freq.put("uj ", 9);
    freq.put("pam", 16);
    freq.put("pan", 9);
    freq.put("Hna", 4);
    freq.put("oin", 3);
    freq.put("oim", 3);
    freq.put("A ", 91);
    freq.put("Xể", 7);
    freq.put("oid", 4);
    freq.put("vk ", 8);
    freq.put("uju", 6);
    freq.put("nà", 686);
    freq.put("pa ", 48);
    freq.put("ểy ", 1143);
    freq.put("Up ", 4);
    freq.put("dv ", 3);
    freq.put("sv ", 3);
    freq.put("mo ", 9);
    freq.put("ím ", 9);
    freq.put("ún ", 57);
    freq.put(" câ", 69);
    freq.put(" cã", 12);
    freq.put(" cà", 56);
    freq.put(" cá", 825);
    freq.put(" cú", 16);
    freq.put(" cù", 73);
    freq.put(" cò", 207);
    freq.put(" có", 816);
    freq.put(" cô", 154);
    freq.put("vũ ", 11);
    freq.put("oăn", 9);
    freq.put("mor", 15);
    freq.put("mov", 3);
    freq.put("mou", 5);
    freq.put("mot", 6);
    freq.put("moi", 15);
    freq.put("moo", 6);
    freq.put("mon", 24);
    freq.put("mom", 3);
    freq.put("mob", 4);
    freq.put("mod", 4);
    freq.put("úng", 151);
    freq.put("Ebo", 3);
    freq.put("New", 21);
    freq.put("Neu", 3);
    freq.put(" ck", 18);
    freq.put(" ch", 2732);
    freq.put(" cn", 8);
    freq.put(" co", 493);
    freq.put(" cl", 17);
    freq.put(" cm", 10);
    freq.put(" cb", 15);
    freq.put(" cc", 7);
    freq.put(" ca", 163);
    freq.put(" cg", 7);
    freq.put(" cx", 7);
    freq.put(" cr", 11);
    freq.put(" cp", 8);
    freq.put(" ct", 7);
    freq.put(" cu", 160);
    freq.put("fát", 6);
    freq.put("｡", 6);
    freq.put("km ", 7);
    freq.put(" c ", 56);
    freq.put("VD ", 4);
    freq.put("yyy", 11);
    freq.put("nân", 4);
    freq.put("º§n", 3);
    freq.put("Lê ", 7);
    freq.put("Ac", 8);
    freq.put("yy ", 5);
    freq.put("Ae", 3);
    freq.put("Mưa", 3);
    freq.put(" cơ", 101);
    freq.put("cãi", 11);
    freq.put(" cư", 136);
    freq.put("iể ", 163);
    freq.put("Ó ", 7);
    freq.put(" cũ", 380);
    freq.put("gê ", 6);
    freq.put("iểi", 104);
    freq.put("iển", 576);
    freq.put("iểm", 129);
    freq.put("iểc", 93);
    freq.put(" că", 26);
    freq.put("iểa", 14);
    freq.put("iểg", 10);
    freq.put("iểy", 15);
    freq.put("iểp", 72);
    freq.put("iểu", 432);
    freq.put("iểt", 410);
    freq.put("US ", 4);
    freq.put("u", 6130);
    freq.put("gw", 3);
    freq.put("iu ", 45);
    freq.put("ũi ", 4);
    freq.put("gr", 8);
    freq.put("hy ", 10);
    freq.put("ws ", 28);
    freq.put("DJ ", 5);
    freq.put("iun", 4);
    freq.put("TA ", 3);
    freq.put("hyu", 29);
    freq.put("ga", 112);
    freq.put("ù ", 67);
    freq.put("zô", 5);
    freq.put("jể ", 5);
    freq.put("gg ", 4);
    freq.put("aba", 4);
    freq.put("abe", 7);
    freq.put("abl", 3);
    freq.put("sể ", 378);
    freq.put("HC ", 3);
    freq.put("aby", 7);
    freq.put("ùi", 60);
    freq.put("ùh", 3);
    freq.put("ùm", 15);
    freq.put("ùn", 173);
    freq.put("ùa", 36);
    freq.put("K", 379);
    freq.put("ùg", 6);
    freq.put("ùy", 5);
    freq.put("jển", 4);
    freq.put("ab ", 3);
    freq.put("à", 4873);
    freq.put("sển", 67);
    freq.put("sểa", 30);
    freq.put("sểc", 37);
    freq.put("sểt", 7);
    freq.put("Lâm", 4);
    freq.put("sểp", 40);
    freq.put("gể ", 176);
    freq.put("eye", 4);
    freq.put("twe", 32);
    freq.put("twi", 22);
    freq.put("iúp", 14);
    freq.put("twt", 14);
    freq.put("de ", 20);
    freq.put("giu", 3);
    freq.put("EH ", 3);
    freq.put("ký ", 10);
    freq.put("ey ", 21);
    freq.put("tw ", 45);
    freq.put("dep", 5);
    freq.put("der", 25);
    freq.put("des", 3);
    freq.put("del", 7);
    freq.put("den", 20);
    freq.put("deo", 14);
    freq.put("deb", 6);
    freq.put("dec", 4);
    freq.put("âm ", 89);
    freq.put("Do ", 3);
    freq.put("go ", 12);
    freq.put("iPa", 3);
    freq.put("đu ", 6);
    freq.put("wp ", 4);
    freq.put("iPh", 8);
    freq.put("tể ", 355);
    freq.put("Don", 35);
    freq.put("Doa", 5);
    freq.put("Dow", 4);
    freq.put("P", 253);
    freq.put("tểt", 82);
    freq.put("tểu", 3);
    freq.put("cs ", 4);
    freq.put("ry ", 14);
    freq.put("tển", 110);
    freq.put("tểo", 13);
    freq.put("tểm", 52);
    freq.put("tểj", 3);
    freq.put("tểi", 267);
    freq.put("tểc", 55);
    freq.put("tểa", 9);
    freq.put("uh ", 32);
    freq.put("ào ", 532);
    freq.put("ok ", 87);
    freq.put("vuể", 7);
    freq.put("Ba ", 6);
    freq.put("ĩ ", 97);
    freq.put("AY ", 7);
    freq.put("Bar", 6);
    freq.put("oky", 6);
    freq.put("uhm", 10);
    freq.put("ĩu", 3);
    freq.put("uhu", 25);
    freq.put(" òa", 13);
    freq.put("Bac", 3);
    freq.put("ĩn", 7);
    freq.put("ĩa", 25);
    freq.put("Bao", 4);
    freq.put("ki ", 18);
    freq.put("uhy", 6);
    freq.put("tuể", 59);
    freq.put("jể", 14);
    freq.put("）", 3);
    freq.put("rôn", 14);
    freq.put("sb ", 4);
    freq.put("mm ", 7);
    freq.put("kĩ", 4);
    freq.put("Tư ", 3);
    freq.put("E ", 76);
    freq.put("gểi", 156);
    freq.put("mmm", 8);
    freq.put("mme", 8);
    freq.put("Uni", 4);
    freq.put("mma", 10);
    freq.put("Em", 41);
    freq.put("El", 6);
    freq.put("En", 10);
    freq.put("dùm", 5);
    freq.put("Ea", 3);
    freq.put("Eb", 3);
    freq.put("tor", 14);
    freq.put("Ex", 3);
    freq.put("Eu", 33);
    freq.put("top", 10);
    freq.put("zo", 5);
    freq.put("Gió", 3);
    freq.put("hèo", 5);
    freq.put("hèn", 4);
    freq.put("hèm", 31);
    freq.put("gày", 177);
    freq.put(" el", 3);
    freq.put(" em", 417);
    freq.put(" en", 16);
    freq.put(" eo", 6);
    freq.put("Tưể", 7);
    freq.put("kon", 10);
    freq.put(" ed", 3);
    freq.put("X ", 29);
    freq.put("Kiê", 5);
    freq.put(" ex", 5);
    freq.put(" ev", 7);
    freq.put(" ep", 7);
    freq.put(" er", 3);
    freq.put("hè ", 6);
    freq.put("Sli", 4);
    freq.put("WP ", 4);
    freq.put("ká", 5);
    freq.put("kà", 4);
    freq.put("ko ", 583);
    freq.put("ké", 18);
    freq.put("Xa", 10);
    freq.put(" e ", 301);
    freq.put("kí", 39);
    freq.put("Xe", 16);
    freq.put("đìn", 9);
    freq.put("kò", 5);
    freq.put("kô", 3);
    freq.put("ký", 10);
    freq.put("Xu", 10);
    freq.put("vể ", 335);
    freq.put("này", 358);
    freq.put("Giá", 28);
    freq.put("vn ", 25);
    freq.put("Già", 3);
    freq.put("nào", 276);
    freq.put("nàn", 31);
    freq.put("nàh", 3);
    freq.put("k ", 862);
    freq.put("Kin", 10);
    freq.put("Kim", 16);
    freq.put("vểa", 70);
    freq.put("vểc", 3);
    freq.put("vểi", 216);
    freq.put("kM", 3);
    freq.put("vểt", 25);
    freq.put("vểy", 224);
    freq.put("nà ", 11);
    freq.put("kb", 4);
    freq.put("ka", 28);
    freq.put("kg", 11);
    freq.put("ke", 83);
    freq.put("kk", 29);
    freq.put("Xã", 4);
    freq.put("ki", 347);
    freq.put("kh", 776);
    freq.put("ko", 608);
    freq.put("kn", 7);
    freq.put("km", 8);
    freq.put("kl", 3);
    freq.put("ks", 28);
    freq.put("kp", 6);
    freq.put("ku", 19);
    freq.put("kt", 10);
    freq.put("ky", 26);
    freq.put(" Bá", 46);
    freq.put(" Bà", 8);
    freq.put(" Bâ", 6);
    freq.put(" Bí", 4);
    freq.put(" Bì", 18);
    freq.put(" Bé", 5);
    freq.put("Xin", 8);
    freq.put(" Bô", 6);
    freq.put(" Bó", 3);
    freq.put("£", 8);
    freq.put("cũ ", 10);
    freq.put("Opp", 9);
    freq.put("hơ ", 11);
    freq.put("Ope", 4);
    freq.put("Luể", 3);
    freq.put("kín", 17);
    freq.put("kà ", 3);
    freq.put("hơi", 111);
    freq.put("hơj", 4);
    freq.put("cũg", 24);
    freq.put("hơm", 7);
    freq.put("hơn", 130);
    freq.put("cũn", 346);
    freq.put("ph", 682);
    freq.put(" Be", 18);
    freq.put(" Ba", 39);
    freq.put(" Bl", 12);
    freq.put(" Bo", 14);
    freq.put(" Bi", 29);
    freq.put(" Bu", 13);
    freq.put("ik ", 51);
    freq.put(" Br", 8);
    freq.put("Ngể", 21);
    freq.put("Ye ", 3);
    freq.put("dô ", 3);
    freq.put("DD ", 6);
    freq.put("bơi", 3);
    freq.put("MF ", 3);
    freq.put(" B ", 22);
    freq.put("ika", 3);
    freq.put("ike", 16);
    freq.put("YeS", 3);
    freq.put("TC ", 4);
    freq.put("Yeo", 5);
    freq.put("Nâu", 3);
    freq.put("SK ", 7);
    freq.put("bơ ", 3);
    freq.put("Yes", 6);
    freq.put("Dể", 38);
    freq.put("lbu", 25);
    freq.put("ga ", 19);
    freq.put("lém", 7);
    freq.put("nhí", 3);
    freq.put("HE ", 3);
    freq.put("nhì", 121);
    freq.put("gay", 46);
    freq.put("gap", 6);
    freq.put("gan", 13);
    freq.put("gam", 6);
    freq.put(" Bư", 4);
    freq.put("gai", 5);
    freq.put("gag", 4);
    freq.put("fuc", 3);
    freq.put("ful", 5);
    freq.put("Đểp", 10);
    freq.put("Fs ", 4);
    freq.put("dg ", 4);
    freq.put("sy ", 4);
    freq.put("nhó", 29);
    freq.put("ewo", 3);
    freq.put("LV ", 3);
    freq.put("ews", 19);
    freq.put("năm", 80);
    freq.put("Yên", 7);
    freq.put("Yêu", 13);
    freq.put(" Bă", 5);
    freq.put("ew ", 19);
    freq.put("y", 3923);
    freq.put("Ê ", 3);
    freq.put("lde", 4);
    freq.put("Di ", 3);
    freq.put("bi ", 23);
    freq.put("Á ", 13);
    freq.put("cut", 21);
    freq.put("cus", 4);
    freq.put(" Yể", 3);
    freq.put("cux", 3);
    freq.put("cua", 14);
    freq.put("dàn", 23);
    freq.put("cuo", 8);
    freq.put("cun", 20);
    freq.put("bin", 11);
    freq.put("Din", 3);
    freq.put("ld ", 12);
    freq.put("bik", 23);
    freq.put("bif", 3);
    freq.put("bie", 7);
    freq.put("bia", 8);
    freq.put("bit", 7);
    freq.put("bir", 4);
    freq.put(" gư", 3);
    freq.put("Đi ", 11);
    freq.put("Áo", 4);
    freq.put("Án", 3);

    init3();
  }
  private static void init3() {
    
    freq.put("rg ", 27);
    freq.put("Áp", 3);
    freq.put("ai", 679);
    freq.put("cu ", 19);
    freq.put(" Để", 138);
    freq.put(" lã", 36);
    freq.put("oe ", 18);
    freq.put(" ô ", 18);
    freq.put("Điê", 4);
    freq.put("per", 43);
    freq.put("pen", 3);
    freq.put("Boy", 3);
    freq.put("biê", 3);
    freq.put("măm", 3);
    freq.put("O", 158);
    freq.put("diể", 48);
    freq.put(" ôn", 40);
    freq.put(" ôm", 22);
    freq.put(" ôi", 41);
    freq.put("oel", 3);
    freq.put("fec", 4);
    freq.put("pe ", 4);
    freq.put("nsi", 8);
    freq.put("ròi", 5);
    freq.put("nsc", 3);
    freq.put("Năm", 3);
    freq.put("nst", 4);
    freq.put("nsu", 8);
    freq.put(" gõ", 5);
    freq.put(" gò", 6);
    freq.put(" gó", 21);
    freq.put("ăm", 127);
    freq.put("ăg", 4);
    freq.put("gó ", 3);
    freq.put("tÃ­", 3);
    freq.put(" gâ", 14);
    freq.put(" gã", 5);
    freq.put(" gà", 35);
    freq.put(" gá", 70);
    freq.put(" gì", 228);
    freq.put(" gê", 8);
    freq.put(" gé", 3);
    freq.put("ns ", 51);
    freq.put("Ult", 3);
    freq.put("rò ", 22);
    freq.put("góp", 6);
    freq.put("gót", 3);
    freq.put("mk ", 5);
    freq.put("góc", 5);
    freq.put("gói", 8);
    freq.put("gón", 3);
    freq.put("lyr", 3);
    freq.put("hêm", 52);
    freq.put("hên", 7);
    freq.put(" gu", 6);
    freq.put("Mat", 3);
    freq.put("May", 3);
    freq.put(" gg", 4);
    freq.put("Mac", 4);
    freq.put(" ge", 6);
    freq.put(" ga", 38);
    freq.put("Mai", 17);
    freq.put(" go", 19);
    freq.put("º", 15);
    freq.put(" gh", 116);
    freq.put(" gi", 763);
    freq.put("Med", 4);
    freq.put("TX ", 4);
    freq.put("ly ", 17);
    freq.put("hê ", 80);
    freq.put("Ny ", 3);
    freq.put(" g ", 11);
    freq.put(" b", 2779);
    freq.put(" c", 7829);
    freq.put(" a", 1138);
    freq.put(" f", 289);
    freq.put(" g", 1646);
    freq.put(" d", 1337);
    freq.put(" e", 781);
    freq.put(" j", 293);
    freq.put(" k", 2489);
    freq.put(" h", 3012);
    freq.put(" i", 138);
    freq.put(" n", 6157);
    freq.put(" o", 266);
    freq.put(" l", 3318);
    freq.put(" m", 3856);
    freq.put(" r", 1292);
    freq.put(" s", 2280);
    freq.put(" p", 912);
    freq.put(" q", 769);
    freq.put(" v", 2438);
    freq.put(" w", 250);
    freq.put(" t", 7554);
    freq.put(" u", 164);
    freq.put(" z", 162);
    freq.put(" x", 853);
    freq.put(" y", 227);
    freq.put(" B", 458);
    freq.put(" C", 860);
    freq.put(" A", 245);
    freq.put(" F", 108);
    freq.put(" G", 280);
    freq.put(" D", 326);
    freq.put(" E", 180);
    freq.put(" J", 152);
    freq.put(" K", 375);
    freq.put(" H", 730);
    freq.put(" I", 125);
    freq.put(" N", 631);
    freq.put(" O", 147);
    freq.put(" L", 359);
    freq.put(" M", 689);
    freq.put(" R", 148);
    freq.put(" S", 621);
    freq.put(" P", 229);
    freq.put(" Q", 116);
    freq.put(" V", 356);
    freq.put(" W", 95);
    freq.put(" T", 1390);
    freq.put(" U", 75);
    freq.put(" Z", 19);
    freq.put(" X", 160);
    freq.put(" Y", 119);
    freq.put("chă", 22);
    freq.put(" Fr", 4);
    freq.put("ét", 73);
    freq.put(" â", 18);
    freq.put(" à", 166);
    freq.put(" á", 168);
    freq.put(" ê", 16);
    freq.put(" é", 9);
    freq.put(" í", 63);
    freq.put(" ò", 18);
    freq.put(" ó", 19);
    freq.put(" ô", 125);
    freq.put(" ú", 8);
    freq.put(" ù", 13);
    freq.put(" ý", 213);
    freq.put(" Â", 9);
    freq.put(" À", 10);
    freq.put(" Á", 24);
    freq.put(" Ä", 4);
    freq.put("thì", 409);
    freq.put("bùn", 13);
    freq.put(" Ô", 17);
    freq.put(" Ú", 3);
    freq.put(" Ý", 10);
    freq.put("och", 3);
    freq.put(" Dư", 13);
    freq.put("chơ", 90);
    freq.put(" ", 3);
    freq.put("uôi", 11);
    freq.put("uôn", 93);
    freq.put("chư", 166);
    freq.put(" ", 3);
    freq.put("Dù ", 7);
    freq.put("bù ", 4);
    freq.put(" Do", 50);
    freq.put("Ver", 5);
    freq.put(" Di", 23);
    freq.put(" De", 7);
    freq.put(" Da", 25);
    freq.put("ii ", 9);
    freq.put("tà ", 4);
    freq.put(" Du", 15);
    freq.put(" Dr", 5);
    freq.put("éo ", 76);
    freq.put("cha", 70);
    freq.put("Fr", 5);
    freq.put("Fs", 4);
    freq.put("che", 34);
    freq.put("chi", 124);
    freq.put("chj", 4);
    freq.put("cho", 429);
    freq.put("Fa", 28);
    freq.put("cht", 3);
    freq.put("chu", 270);
    freq.put("Fi", 13);
    freq.put("Fl", 3);
    freq.put("Fo", 10);
    freq.put("tàu", 8);
    freq.put(" D ", 39);
    freq.put("GG ", 3);
    freq.put("iii", 72);
    freq.put("tài", 10);
    freq.put("ch ", 371);
    freq.put(" ă", 130);
    freq.put("Băn", 5);
    freq.put("f", 469);
    freq.put("F ", 66);
    freq.put(" Đ", 322);
    freq.put(" đ", 4915);
    freq.put("thơ", 9);
    freq.put("SM ", 25);
    freq.put("Mển", 4);
    freq.put(" Dâ", 10);
    freq.put(" Dù", 8);
    freq.put("AB ", 3);
    freq.put("chá", 48);
    freq.put("châ", 40);
    freq.put("Mểi", 23);
    freq.put("Yo", 20);
    freq.put("Ya", 8);
    freq.put("ché", 15);
    freq.put("chê", 14);
    freq.put("Ye", 26);
    freq.put("chí", 55);
    freq.put("chó", 19);
    freq.put("chù", 5);
    freq.put("chú", 103);
    freq.put("Yu", 17);
    freq.put("Mểe", 12);
    freq.put(" Ơ", 7);
    freq.put(" ơ", 187);
    freq.put("Mểc", 4);
    freq.put("act", 6);
    freq.put(" Ư", 4);
    freq.put("dc", 144);
    freq.put(" ư", 35);
    freq.put("｡）", 3);
    freq.put("Y ", 54);
    freq.put("kéo", 13);
    freq.put("da ", 26);
    freq.put("Mểu", 4);
    freq.put("lf", 6);
    freq.put("ld", 21);
    freq.put("le", 119);
    freq.put("lb", 29);
    freq.put("§", 4);
    freq.put("la", 193);
    freq.put("lo", 216);
    freq.put("ll", 73);
    freq.put("lm", 7);
    freq.put("lk", 16);
    freq.put("li", 188);
    freq.put("lv", 3);
    freq.put("lt", 6);
    freq.put("lu", 181);
    freq.put("ls", 14);
    freq.put("Cuể", 12);
    freq.put("tsu", 10);
    freq.put("ly", 22);
    freq.put("dae", 4);
    freq.put("dam", 3);
    freq.put("dan", 24);
    freq.put("dao", 6);
    freq.put("quý", 11);
    freq.put("dai", 5);
    freq.put("dat", 9);
    freq.put("dau", 10);
    freq.put("quâ", 7);
    freq.put("dar", 5);
    freq.put("quê", 30);
    freq.put("day", 35);
    freq.put("CK ", 6);
    freq.put("l ", 240);
    freq.put("sio", 8);
    freq.put("eu ", 38);
    freq.put("ts ", 15);
    freq.put("Tuy", 13);
    freq.put("lâ", 48);
    freq.put("lã", 36);
    freq.put("là", 1168);
    freq.put("lá", 20);
    freq.put("res", 8);
    freq.put("rep", 15);
    freq.put("lí", 12);
    freq.put("rev", 4);
    freq.put("ret", 5);
    freq.put("lé", 12);
    freq.put("Tui", 8);
    freq.put("lô", 21);
    freq.put("ren", 26);
    freq.put("ló", 8);
    freq.put("rem", 5);
    freq.put("rea", 30);
    freq.put("ref", 5);
    freq.put("ree", 8);
    freq.put("lf ", 4);
    freq.put("quy", 45);
    freq.put("qua", 142);
    freq.put("que", 29);
    freq.put("qui", 4);
    freq.put("zô ", 5);
    freq.put("òg ", 4);
    freq.put("re ", 54);
    freq.put("og ", 53);
    freq.put("miê", 3);
    freq.put("nưể", 29);
    freq.put("lũ", 14);
    freq.put("iể", 2021);
    freq.put("Vể", 63);
    freq.put("lă", 14);
    freq.put("ogl", 10);
    freq.put("ogo", 5);
    freq.put("udi", 3);
    freq.put("kiể", 132);
    freq.put("Par", 12);
    freq.put("Pad", 5);
    freq.put("mil", 5);
    freq.put("min", 66);
    freq.put("mic", 3);
    freq.put("mie", 4);
    freq.put("quă", 7);
    freq.put("bây", 38);
    freq.put("mis", 4);
    freq.put("Cể", 100);
    freq.put("mi ", 19);
    freq.put("lư", 63);
    freq.put("tý ", 6);
    freq.put(" iP", 11);
    freq.put("hìu", 17);
    freq.put(" zể", 43);
    freq.put("hìn", 244);
    freq.put(" iO", 4);
    freq.put(" ip", 5);
    freq.put(" is", 9);
    freq.put(" it", 9);
    freq.put(" iu", 22);
    freq.put(" im", 6);
    freq.put(" in", 38);
    freq.put("Mob", 6);
    freq.put(" id", 4);
    freq.put(" ie", 3);
    freq.put("VN ", 20);
    freq.put("ĐH ", 7);
    freq.put("xuể", 53);
    freq.put("hì ", 428);
    freq.put("ks ", 22);
    freq.put(" i ", 19);
    freq.put("we", 68);
    freq.put("ĩ", 133);
    freq.put(" iê", 4);
    freq.put("õ", 50);
    freq.put("S", 642);
    freq.put("cùg", 4);
    freq.put("wi", 40);
    freq.put("wh", 9);
    freq.put("cùn", 67);
    freq.put("è", 145);
    freq.put("UYể", 6);
    freq.put("wp", 4);
    freq.put("ăn ", 237);
    freq.put("uid", 4);
    freq.put("dò", 6);
    freq.put("af", 20);
    freq.put("Nà", 7);
    freq.put("ohe", 3);
    freq.put("ak", 65);
    freq.put("OL ", 17);
    freq.put("ăng", 138);
    freq.put("cor", 8);
    freq.put("àng", 264);
    freq.put("Hot", 11);
    freq.put("uit", 4);
    freq.put("đk ", 8);
    freq.put(" Fu", 10);
    freq.put(" Fa", 25);
    freq.put(" Fi", 12);
    freq.put(" Fl", 3);
    freq.put(" Fo", 9);
    freq.put("io ", 10);
    freq.put("az", 14);
    freq.put("váy", 6);
    freq.put("tây", 6);
    freq.put("SO ", 4);
    freq.put("MB ", 7);
    freq.put("ior", 15);
    freq.put("ion", 46);
    freq.put("tâm", 35);
    freq.put("ioi", 3);
    freq.put("tân", 3);
    freq.put("ém ", 30);
    freq.put("con", 327);
    freq.put("aJ", 5);
    freq.put("Gể ", 3);
    freq.put("gmi", 6);
    freq.put("Caf", 3);
    freq.put("add", 5);
    freq.put("ade", 7);
    freq.put("ada", 3);
    freq.put("adm", 3);
    freq.put("adi", 6);
    freq.put("GểI", 3);
    freq.put("Hyu", 44);
    freq.put("KH ", 5);
    freq.put("gm ", 4);
    freq.put("Gểp", 3);
    freq.put("ad ", 31);
    freq.put("nja", 4);
    freq.put("ui ", 177);
    freq.put("dc ", 141);
    freq.put("esu", 7);
    freq.put("est", 23);
    freq.put("ess", 20);
    freq.put("ese", 4);
    freq.put("esi", 3);
    freq.put("esh", 4);
    freq.put(" dể", 376);
    freq.put("OS ", 7);
    freq.put("by ", 9);
    freq.put("es ", 24);
    freq.put("Twi", 3);
    freq.put("oun", 10);
    freq.put("Liể", 4);
    freq.put("rch", 8);
    freq.put("rca", 4);
    freq.put("bus", 4);
    freq.put("but", 9);
    freq.put("bun", 4);
    freq.put("múa", 5);
    freq.put("bum", 27);
    freq.put("buc", 3);
    freq.put("mún", 40);
    freq.put("ㅋㅋ", 10);
    freq.put("j", 468);
    freq.put("rc ", 46);
    freq.put("pik", 4);
    freq.put("pin", 10);
    freq.put("pic", 14);
    freq.put("ub ", 27);
    freq.put("àu ", 53);
    freq.put("oad", 16);
    freq.put("oan", 52);
    freq.put("oai", 9);
    freq.put("buý", 4);
    freq.put("Ach", 4);
    freq.put("buô", 3);
    freq.put("ube", 5);
    freq.put("uba", 3);
    freq.put("oa ", 73);
    freq.put("xóa", 5);
    freq.put("xóm", 3);
    freq.put(" kà", 3);
    freq.put(" ká", 4);
    freq.put("mă", 4);
    freq.put(" kê", 47);
    freq.put(" kè", 7);
    freq.put(" ké", 18);
    freq.put(" kì", 61);
    freq.put(" kí", 37);
    freq.put(" kô", 3);
    freq.put(" ký", 10);
    freq.put("Uhm", 11);
    freq.put("mĩ", 5);
    freq.put("G ", 102);
    freq.put("bài", 98);
    freq.put("bàn", 19);
    freq.put("IểN", 8);
    freq.put("IểM", 3);
    freq.put("Hưn", 7);
    freq.put("IểU", 3);
    freq.put("IểT", 5);
    freq.put("Gu", 7);
    freq.put("Gr", 5);
    freq.put("KM ", 3);
    freq.put("mũ", 12);
    freq.put("bà ", 42);
    freq.put("Ge", 8);
    freq.put("íu ", 9);
    freq.put("Ga", 15);
    freq.put("Go", 19);
    freq.put("Gi", 108);
    freq.put("Gh", 7);
    freq.put(" kb", 3);
    freq.put(" ka", 13);
    freq.put(" kg", 9);
    freq.put(" ke", 22);
    freq.put(" kk", 11);
    freq.put(" kh", 774);
    freq.put(" ki", 290);
    freq.put(" kn", 3);
    freq.put(" ko", 601);
    freq.put(" km", 3);
    freq.put(" ks", 3);
    freq.put(" kp", 5);
    freq.put(" kt", 10);
    freq.put(" ku", 12);
    freq.put(" ky", 11);
    freq.put("mơ", 23);
    freq.put("kut", 4);
    freq.put("Z ", 7);
    freq.put("thí", 111);
    freq.put("eco", 3);
    freq.put("ain", 14);
    freq.put("mư", 37);
    freq.put("mng", 4);
    freq.put(" k ", 346);
    freq.put("eck", 16);
    freq.put("TT ", 36);
    freq.put("Gò", 5);
    freq.put("Ze", 3);
    freq.put("Za", 3);
    freq.put("dín", 3);
    freq.put("Gà", 7);
    freq.put("thà", 76);
    freq.put("ku ", 13);
    freq.put("m ", 3256);
    freq.put("Ko ", 19);
    freq.put("xoá", 3);
    freq.put("me", 131);
    freq.put("ểI ", 26);
    freq.put("ma", 318);
    freq.put("mb", 16);
    freq.put("mm", 35);
    freq.put("mo", 97);
    freq.put("mn", 28);
    freq.put("mi", 147);
    freq.put("mh", 7);
    freq.put("mk", 5);
    freq.put("mu", 253);
    freq.put("mv", 7);
    freq.put("mp", 27);
    freq.put("ms", 30);
    freq.put("mr", 5);
    freq.put("my", 19);
    freq.put("Hươ", 6);
    freq.put("ena", 4);
    freq.put("enc", 6);
    freq.put("end", 24);
    freq.put("ene", 10);
    freq.put("eng", 16);
    freq.put("enh", 5);
    freq.put("eni", 6);
    freq.put("enj", 3);
    freq.put("ent", 46);
    freq.put("mÃ", 3);
    freq.put("ON ", 11);
    freq.put(" kĩ", 4);
    freq.put("II ", 4);
    freq.put("en ", 185);
    freq.put("má", 116);
    freq.put("mà", 744);
    freq.put("mã", 32);
    freq.put("mâ", 11);
    freq.put("mí", 21);
    freq.put("mì", 393);
    freq.put("đưa", 27);
    freq.put("mé", 3);
    freq.put("mè", 14);
    freq.put("mê", 10);
    freq.put("mô", 42);
    freq.put("mó", 12);
    freq.put("mò", 11);
    freq.put("núi", 3);
    freq.put("mù", 33);
    freq.put("mú", 45);
    freq.put(" Hy", 39);
    freq.put("DB ", 4);
    freq.put(" Hw", 3);
    freq.put(" Hu", 19);
    freq.put(" Hi", 47);
    freq.put(" Ho", 74);
    freq.put(" Hn", 4);
    freq.put(" Ha", 83);
    freq.put(" He", 33);
    freq.put("ima", 3);
    freq.put("ime", 19);
    freq.put("cli", 15);
    freq.put("imi", 5);
    freq.put("goá", 10);
    freq.put("goà", 33);
    freq.put("imo", 5);
    freq.put("imp", 12);
    freq.put("ãnh", 4);
    freq.put(" H ", 15);
    freq.put("im ", 157);
    freq.put("nhă", 4);
    freq.put("Viê", 4);
    freq.put("éc ", 4);
    freq.put("hqu", 3);
    freq.put("ãn ", 9);
    freq.put("dòn", 3);
    freq.put("hqa", 3);
    freq.put(" Hú", 4);
    freq.put(" Hó", 3);
    freq.put(" Hò", 3);
    freq.put(" Hô", 17);
    freq.put(" Hê", 3);
    freq.put("BT ", 3);
    freq.put(" Hì", 12);
    freq.put(" Hã", 6);
    freq.put(" Hâ", 6);
    freq.put(" Há", 5);
    freq.put(" Hà", 78);
    freq.put("nio", 15);
    freq.put("gom", 3);
    freq.put("gol", 5);
    freq.put("goo", 17);
    freq.put("gon", 30);
    freq.put("goa", 18);
    freq.put("aju", 9);
    freq.put("áh ", 12);
    freq.put(" wể", 3);
    freq.put("Lên", 3);
    freq.put("đuể", 8);
    freq.put("như", 432);
    freq.put("W", 101);
    freq.put("THể", 13);
    freq.put("Vic", 3);
    freq.put("Vid", 6);
    freq.put("Vie", 14);
    freq.put("Vin", 9);
    freq.put("ì", 1859);
    freq.put("Căn", 7);
    freq.put("ểT ", 24);
    freq.put("aj ", 6);
    freq.put("Cây", 3);
    freq.put(" Sp", 5);
    freq.put("nhe", 9);
    freq.put("nhg", 9);
    freq.put("nha", 245);
    freq.put("nho", 19);
    freq.put("nhi", 183);
    freq.put("nhh", 5);
    freq.put("nhu", 30);
    freq.put("nhy", 12);
    freq.put("mưể", 10);
    freq.put("Ã­", 4);
    freq.put("Ã£", 3);
    freq.put("tos", 3);
    freq.put("Ã¡", 12);
    freq.put("tou", 4);
    freq.put("tok", 7);
    freq.put("toi", 6);
    freq.put("ton", 7);
    freq.put("nit", 5);
    freq.put("tom", 4);
    freq.put("toa", 5);
    freq.put("tod", 3);
    freq.put("toe", 4);
    freq.put("nh ", 2322);
    freq.put("Ì ", 4);
    freq.put("Fuc", 4);
    freq.put(" Tể", 133);
    freq.put("ôm ", 148);
    freq.put("to ", 51);
    freq.put("ept", 6);
    freq.put("rag", 3);
    freq.put("rad", 5);
    freq.put("rae", 4);
    freq.put("nhá", 43);
    freq.put("nhà", 212);
    freq.put("nhã", 4);
    freq.put("nhâ", 44);
    freq.put("ran", 110);
    freq.put("rao", 16);
    freq.put("ram", 6);
    freq.put("nhé", 86);
    freq.put("rai", 38);
    freq.put("rat", 15);
    freq.put("rap", 9);
    freq.put("âu ", 363);
    freq.put("bs ", 9);
    freq.put("nhú", 6);
    freq.put("Ã ", 10);
    freq.put("ông", 444);
    freq.put("toé", 3);
    freq.put("toà", 78);
    freq.put("toá", 10);
    freq.put("Â", 9);
    freq.put("ra ", 283);
    freq.put(" Hư", 18);
    freq.put("bsi", 3);
    freq.put(" Hơ", 3);
    freq.put("thd", 4);
    freq.put("trể", 278);
    freq.put("R", 153);
    freq.put("ểu", 995);
    freq.put("epa", 3);
    freq.put("đùa", 10);
    freq.put("ép", 24);
    freq.put("nuô", 7);
    freq.put(" mũ", 12);
    freq.put("tó", 55);
    freq.put("ém", 30);
    freq.put("éo", 77);
    freq.put("én", 13);
    freq.put("éc", 4);
    freq.put("Bin", 4);
    freq.put("muô", 3);
    freq.put("ock", 10);
    freq.put("oco", 4);
    freq.put("òg", 5);
    freq.put("òa", 36);
    freq.put(" út", 4);
    freq.put("òn", 289);
    freq.put("ocu", 3);
    freq.put("òi", 32);
    freq.put("xoa", 10);
    freq.put(" mĩ", 5);
    freq.put("é ", 176);
    freq.put(" mă", 4);
    freq.put("oc ", 32);
    freq.put("nơi", 13);
    freq.put("ò ", 56);
    freq.put(" dư", 41);
    freq.put("pkò", 3);
    freq.put("Per", 3);
    freq.put("nuo", 3);
    freq.put("eTe", 3);
    freq.put("nua", 13);
    freq.put("mus", 5);
    freq.put("mua", 100);
    freq.put("muc", 3);
    freq.put("mub", 3);
    freq.put("muo", 4);
    freq.put("muh", 3);
    freq.put(" mơ", 23);
    freq.put("XD ", 15);
    freq.put(" mư", 37);
    freq.put("Ban", 11);
    freq.put("mu ", 5);
    freq.put(" me", 50);
    freq.put(" ma", 248);
    freq.put(" mm", 4);
    freq.put(" mn", 25);
    freq.put(" mo", 60);
    freq.put(" mh", 6);
    freq.put(" mi", 103);
    freq.put(" mk", 5);
    freq.put(" mu", 251);
    freq.put(" mv", 7);
    freq.put("xx ", 10);
    freq.put(" mr", 4);
    freq.put(" ms", 13);
    freq.put(" my", 17);
    freq.put("Hể ", 46);
    freq.put("tùm", 3);
    freq.put(" m ", 242);
    freq.put("HểT", 7);
    freq.put("xxx", 74);
    freq.put("HểC", 4);
    freq.put("tùy", 5);
    freq.put("Hã", 6);
    freq.put("HểI", 6);
    freq.put("HểN", 15);
    freq.put("TV ", 5);
    freq.put("Hểt", 7);
    freq.put("n", 21555);
    freq.put("Hểc", 10);
    freq.put("mát", 8);
    freq.put("Hểi", 44);
    freq.put("Hển", 15);
    freq.put("ă", 508);
    freq.put(" mà", 744);
    freq.put(" má", 116);
    freq.put(" mâ", 11);
    freq.put(" mã", 32);
    freq.put(" mì", 393);
    freq.put(" mí", 21);
    freq.put(" mè", 14);
    freq.put(" mé", 3);
    freq.put(" mê", 10);
    freq.put(" mô", 42);
    freq.put(" mò", 11);
    freq.put(" mó", 12);
    freq.put(" mù", 33);
    freq.put(" mú", 45);
    freq.put(" mÃ", 3);
    freq.put("hà ", 245);
    freq.put("HP ", 6);
    freq.put("Đán", 5);
    freq.put("Kể", 24);
    freq.put("hài", 17);
    freq.put("hào", 33);
    freq.put("hàn", 209);
    freq.put("hàm", 4);
    freq.put("hàg", 3);
    freq.put("ìn", 851);
    freq.put("Xa ", 7);
    freq.put("kèm", 3);
    freq.put("lưể", 45);
    freq.put("Hú", 4);
    freq.put("eli", 10);
    freq.put("cnó", 5);
    freq.put("ell", 14);
    freq.put("Hò", 3);
    freq.put("Hó", 3);
    freq.put("Hô", 17);
    freq.put("ele", 3);
    freq.put("Hê", 4);
    freq.put("Hì", 12);
    freq.put("Hâ", 6);
    freq.put("els", 4);
    freq.put("Hà", 78);
    freq.put("Há", 5);
    freq.put("D", 374);
    freq.put("cân", 8);
    freq.put("kè ", 4);
    freq.put("nơ", 15);
    freq.put("el ", 30);
    freq.put("nư", 34);
    freq.put("hs ", 3);
    freq.put(" Ju", 25);
    freq.put("mã ", 4);
    freq.put(" Jo", 22);
    freq.put(" Ji", 9);
    freq.put(" Je", 6);
    freq.put(" Ja", 24);
    freq.put("ick", 15);
    freq.put("thu", 138);
    freq.put("Hy", 50);
    freq.put("ico", 7);
    freq.put("ica", 4);
    freq.put("Hw", 3);
    freq.put("ice", 10);
    freq.put("Hu", 20);
    freq.put("Hi", 49);
    freq.put("Hn", 4);
    freq.put("Ho", 80);
    freq.put("ics", 4);
    freq.put("icr", 4);
    freq.put("Ha", 98);
    freq.put("He", 35);
    freq.put("mãn", 5);
    freq.put("mãi", 23);
    freq.put("nă", 88);
    freq.put(" J ", 5);
    freq.put("xưa", 11);
    freq.put("ic ", 75);
    freq.put("cn ", 3);
    freq.put("ũg ", 24);
    freq.put("H ", 101);
    freq.put("ppa", 40);
    freq.put("áng", 162);
    freq.put("ahh", 5);
    freq.put("ánh", 90);
    freq.put("ppl", 8);
    freq.put("ppp", 29);
    freq.put("ppy", 6);
    freq.put("nè", 36);
    freq.put("né", 16);
    freq.put("nê", 157);
    freq.put("nì", 6);
    freq.put("ní", 10);
    freq.put("đj ", 3);
    freq.put("ná", 7);
    freq.put("nâ", 7);
    freq.put("nã", 36);
    freq.put("Ư", 4);
    freq.put("gif", 3);
    freq.put("nú", 7);
    freq.put("gia", 107);
    freq.put("gio", 10);
    freq.put("gin", 7);
    freq.put("nó", 530);
    freq.put("nô", 11);
    freq.put("ah ", 175);
    freq.put("pp ", 5);
    freq.put("án ", 197);
    freq.put("Hư", 18);
    freq.put("gi ", 10);
    freq.put("Hơ", 3);
    freq.put("nH", 16);
    freq.put("nM", 3);
    freq.put("nni", 16);
    freq.put("Huể", 4);
    freq.put("nne", 5);
    freq.put("nna", 7);
    freq.put("giÃ", 4);
    freq.put("nny", 5);
    freq.put("nh", 4531);
    freq.put("ni", 118);
    freq.put("nj", 7);
    freq.put("nk", 87);
    freq.put("gió", 8);
    freq.put("nm", 7);
    freq.put("nn", 38);
    freq.put("no", 83);
    freq.put("tit", 8);
    freq.put("na", 350);
    freq.put("nb", 14);
    freq.put("nc", 87);
    freq.put("nd", 101);
    freq.put("giú", 12);
    freq.put("nf", 22);
    freq.put("ng", 6499);
    freq.put("til", 3);
    freq.put("ny", 23);
    freq.put("nz", 4);
    freq.put("tio", 31);
    freq.put("giã", 4);
    freq.put("giâ", 4);
    freq.put("giá", 109);
    freq.put("già", 64);
    freq.put("np", 3);
    freq.put("tie", 13);
    freq.put("nr", 3);
    freq.put("ns", 82);
    freq.put("nt", 196);
    freq.put("nu", 35);
    freq.put("nv", 8);
    freq.put("nw", 5);
    freq.put("nn ", 3);
    freq.put("ich", 15);
    freq.put(" Rể", 23);
    freq.put("n ", 6763);
    freq.put("ti ", 13);
    freq.put("roi", 20);
    freq.put("lly", 5);
    freq.put("rol", 6);
    freq.put("rom", 10);
    freq.put("ron", 194);
    freq.put("roo", 6);
    freq.put("rod", 3);
    freq.put("rog", 6);
    freq.put("lli", 5);
    freq.put("llo", 15);
    freq.put("lll", 10);
    freq.put("rop", 3);
    freq.put("lla", 7);
    freq.put("ros", 4);
    freq.put("rot", 7);
    freq.put("rou", 3);
    freq.put("lle", 4);
    freq.put("Dan", 5);
    freq.put("Quá", 6);
    freq.put("Quà", 3);
    freq.put("Dav", 4);
    freq.put("Dar", 3);
    freq.put("gể", 588);
    freq.put("Day", 7);
    freq.put("òa ", 31);
    freq.put("ro ", 12);
    freq.put("Vân", 8);
    freq.put("Ts ", 24);
    freq.put("Cit", 3);
    freq.put("ll ", 24);
    freq.put("Da ", 3);
    freq.put("HÀ ", 4);
    freq.put("ict", 7);
    freq.put("roà", 6);
    freq.put("Rep", 3);
    freq.put("bểu", 11);
    freq.put("Rea", 4);
    freq.put("Trì", 3);
    freq.put("Quy", 6);
    freq.put("gư ", 3);
    freq.put("Qua", 10);
    freq.put("ươ", 154);
    freq.put("pm ", 6);
    freq.put("ểu ", 989);
    freq.put("ày ", 568);
    freq.put(" ㅠ", 6);
    freq.put("º§", 3);
    freq.put("º£", 4);
    freq.put("ngt", 9);
    freq.put("ngu", 67);
    freq.put(" ㅋ", 3);
    freq.put("msu", 7);
    freq.put("gươ", 7);
    freq.put("ư ", 360);
    freq.put("bìn", 16);
    freq.put("bìa", 5);
    freq.put("¡c ", 3);
    freq.put("ưu", 19);
    freq.put("ơg ", 4);
    freq.put("ưa", 247);
    freq.put("ưg", 17);
    freq.put("ưn", 249);
    freq.put("ms ", 14);
    freq.put(" on", 50);
    freq.put(" ol", 7);
    freq.put("kyo", 6);
    freq.put(" ok", 14);
    freq.put(" oh", 12);
    freq.put(" oi", 4);
    freq.put(" of", 30);
    freq.put(" og", 3);
    freq.put("Mic", 6);
    freq.put(" oc", 4);
    freq.put(" oa", 14);
    freq.put("Ct ", 5);
    freq.put(" oy", 6);
    freq.put("Mis", 5);
    freq.put(" ou", 16);
    freq.put(" or", 21);
    freq.put(" os", 3);
    freq.put(" op", 26);
    freq.put(" uể", 30);
    freq.put("Æ", 3);
    freq.put("ky ", 3);
    freq.put(" o ", 33);
    freq.put("rúg", 3);
    freq.put("rúc", 4);
    freq.put("rút", 10);
    freq.put("dép", 4);
    freq.put("sán", 61);
    freq.put("sác", 11);
    freq.put("Cut", 3);
    freq.put("Gòn", 3);
    freq.put("Đã ", 12);
    freq.put("ech", 11);
    freq.put("sát", 17);
    freq.put("gta", 6);
    freq.put("TP ", 21);
    freq.put(" Lư", 9);
    freq.put("àà", 3);
    freq.put("ppo", 3);
    freq.put("hâm", 24);
    freq.put("hân", 115);
    freq.put("ểM ", 12);
    freq.put("hâu", 18);
    freq.put("à ", 2336);
    freq.put(" ăn", 130);
    freq.put("Ăn ", 3);
    freq.put("EN ", 10);
    freq.put("đua", 3);
    freq.put("ejo", 8);
    freq.put("yu ", 47);
    freq.put("àg", 9);
    freq.put("àj", 4);
    freq.put("àk", 7);
    freq.put("àh", 47);
    freq.put("ài", 270);
    freq.put("àn", 664);
    freq.put("ào", 537);
    freq.put("àm", 331);
    freq.put("yuH", 3);
    freq.put("răn", 18);
    freq.put("yuM", 5);
    freq.put("àu", 53);
    freq.put("ày", 578);
    freq.put("gir", 20);
    freq.put("NHể", 4);
    freq.put("PHể", 6);
    freq.put("yup", 3);
    freq.put("yuh", 6);
    freq.put("yuk", 45);
    freq.put("hiể", 481);
    freq.put("yum", 3);
    freq.put("yun", 32);
    freq.put("hu ", 84);
    freq.put("má ", 23);
    freq.put("iam", 4);
    freq.put("ial", 4);
    freq.put("iao", 24);
    freq.put("ian", 39);
    freq.put("iai", 9);
    freq.put("iaf", 3);
    freq.put("CL ", 4);
    freq.put("riể", 32);
    freq.put("ias", 6);
    freq.put("Tiể", 18);
    freq.put("hug", 25);
    freq.put("máu", 25);
    freq.put("tiê", 27);
    freq.put("huc", 7);
    freq.put("hul", 22);
    freq.put("hum", 20);
    freq.put("hun", 111);
    freq.put("huh", 30);
    freq.put("hui", 26);
    freq.put("hut", 3);
    freq.put("mác", 3);
    freq.put("SE ", 3);
    freq.put("mái", 9);
    freq.put("uyê", 56);
    freq.put("Ý", 10);
    freq.put("huy", 163);
    freq.put(" Lã", 3);
    freq.put(" Lâ", 5);
    freq.put(" Lá", 6);
    freq.put(" Là", 22);
    freq.put("kên", 7);
    freq.put("ia ", 178);
    freq.put("r", 3502);
    freq.put("kêu", 37);
    freq.put(" Lý", 5);
    freq.put(" Lú", 6);
    freq.put(" Lù", 5);
    freq.put("pre", 5);
    freq.put("ane", 4);
    freq.put("ang", 423);
    freq.put("ana", 26);
    freq.put("anb", 7);
    freq.put("anc", 25);
    freq.put("anm", 4);
    freq.put("pro", 10);
    freq.put("ano", 6);
    freq.put("anh", 581);
    freq.put("ani", 3);
    freq.put("lói", 3);
    freq.put("ant", 22);
    freq.put("pể", 25);
    freq.put("ý ", 274);
    freq.put("ans", 53);
    freq.put("any", 7);
    freq.put(" ác", 11);
    freq.put(" L ", 10);
    freq.put(" áh", 12);
    freq.put("anH", 3);
    freq.put(" ám", 6);
    freq.put(" án", 21);
    freq.put("xì ", 9);
    freq.put(" áp", 6);
    freq.put("đh ", 3);
    freq.put(" át", 3);
    freq.put("ểh ", 23);
    freq.put("ýt", 11);
    freq.put("an ", 362);
    freq.put("huê", 22);
    freq.put("uya", 8);
    freq.put("uye", 10);
    freq.put("uyk", 3);
    freq.put("uyn", 4);
    freq.put(" á ", 62);
    freq.put(" Le", 23);
    freq.put(" La", 36);
    freq.put(" Lo", 34);
    freq.put(" Li", 36);
    freq.put(" Lu", 12);
    freq.put(" Ly", 5);
    freq.put("eMi", 3);
    freq.put("itl", 3);
    freq.put("nli", 8);
    freq.put("dy ", 7);
    freq.put("ss ", 381);
    freq.put("nlo", 3);
    freq.put("Muể", 9);
    freq.put(" sể", 608);
    freq.put("hươ", 87);
    freq.put("tk ", 7);
    freq.put("H", 768);
    freq.put("sss", 6);
    freq.put("nl ", 31);
    freq.put("ssi", 10);
    freq.put("ssa", 3);
    freq.put("lum", 4);
    freq.put("ôi ", 428);
    freq.put("Và ", 7);
    freq.put("rma", 9);
    freq.put("tna", 4);
    freq.put("Vào", 5);
    freq.put("rm ", 9);
    freq.put("por", 10);
    freq.put("pos", 23);
    freq.put("pop", 8);
    freq.put("poo", 4);
    freq.put("Bum", 5);
    freq.put("bên", 43);
    freq.put("yh ", 9);
    freq.put("ùn ", 19);
    freq.put("I ", 80);
    freq.put("hư ", 283);
    freq.put("bê ", 6);
    freq.put("nl", 44);
    freq.put("Sơn", 7);
    freq.put("Is", 6);
    freq.put("ùng", 152);
    freq.put("hưu", 3);
    freq.put("Im", 11);
    freq.put("hưn", 187);
    freq.put("In", 37);
    freq.put("Bab", 3);
    freq.put("hưa", 160);
    freq.put("hưg", 15);
    freq.put("Id", 4);
    freq.put("ㅋ ", 3);
    freq.put("suể", 21);
    freq.put(" qu", 712);
    freq.put("tip", 3);
    freq.put("ne", 160);
    freq.put(" qa", 5);
    freq.put(" qe", 4);
    freq.put("tim", 25);
    freq.put(" òi", 4);
    freq.put("tin", 106);
    freq.put("Kểt", 3);
    freq.put("oé", 6);
    freq.put("oã", 3);
    freq.put("oá", 81);
    freq.put("oà", 217);
    freq.put("tic", 10);
    freq.put(" qá", 40);
    freq.put("o ", 3242);
    freq.put("oM", 5);
    freq.put(" Nể", 60);
    freq.put("GIể", 4);
    freq.put("oo", 206);
    freq.put("on", 1147);
    freq.put("om", 105);
    freq.put("ol", 85);
    freq.put("ok", 126);
    freq.put("oj", 5);
    freq.put("oi", 236);
    freq.put("oh", 22);
    freq.put("og", 72);
    freq.put("of", 38);
    freq.put("oe", 22);
    freq.put("od", 49);
    freq.put("oc", 60);
    freq.put("ob", 23);
    freq.put("oa", 159);
    freq.put("ểO ", 4);
    freq.put("ô", 1431);
    freq.put("oy", 40);
    freq.put("ox", 19);
    freq.put("ow", 121);
    freq.put("ov", 41);
    freq.put("ou", 88);
    freq.put("ot", 99);
    freq.put("os", 59);
    freq.put("or", 148);
    freq.put("op", 76);
    freq.put("ju ", 14);
    freq.put("FB ", 5);
    freq.put("ehe", 27);
    freq.put("uê ", 36);
    freq.put("Nhể", 77);
    freq.put("juj", 3);
    freq.put("jun", 3);
    freq.put("jum", 3);
    freq.put("tơi", 4);
    freq.put("uên", 18);
    freq.put("eh ", 4);
    freq.put("rvi", 4);
    freq.put("oă", 9);
    freq.put("Xe ", 5);
    freq.put("IC ", 4);
    freq.put("ige", 3);
    freq.put("iga", 4);
    freq.put("igo", 11);
    freq.put("ign", 7);
    freq.put("igi", 4);
    freq.put("igh", 15);
    freq.put("cb ", 13);
    freq.put("hwa", 5);
    freq.put("kìa", 29);
    freq.put("kìm", 5);
    freq.put("alo", 3);
    freq.put("all", 13);
    freq.put("alk", 15);
    freq.put("ali", 4);
    freq.put("ald", 3);
    freq.put("ale", 8);
    freq.put("alb", 26);
    freq.put("bưể", 9);
    freq.put("ala", 7);
    freq.put("fa ", 3);
    freq.put("Như", 35);
    freq.put("suý", 3);
    freq.put("lý ", 24);
    freq.put("TRể", 4);
    freq.put("oể", 187);
    freq.put("al ", 20);
    freq.put("pt ", 8);
    freq.put("fai", 11);
    freq.put("fan", 113);
    freq.put("fam", 3);
    freq.put(" Ni", 34);
    freq.put(" Nh", 180);
    freq.put(" No", 20);
    freq.put(" Na", 45);
    freq.put(" Ne", 27);
    freq.put(" Ng", 135);
    freq.put("tểp", 32);
    freq.put("tel", 11);
    freq.put("ten", 4);
    freq.put("teo", 5);
    freq.put("tea", 9);
    freq.put("tec", 5);
    freq.put("tee", 7);
    freq.put("nbo", 8);
    freq.put("ter", 46);
    freq.put("tes", 5);
    freq.put("teu", 16);
    freq.put("nbe", 3);
    freq.put("sub", 29);
    freq.put("sua", 7);
    freq.put("suo", 3);
    freq.put("sun", 30);
    freq.put("suk", 4);
    freq.put("sus", 3);
    freq.put("sup", 9);
    freq.put("suy", 7);
    freq.put("te ", 87);
    freq.put("su ", 14);
    freq.put(" Nà", 7);
    freq.put(" Nâ", 3);
    freq.put(" Tâ", 15);
    freq.put(" Nó", 23);
    freq.put(" Nô", 3);
    freq.put("Top", 7);
    freq.put("Tow", 5);
    freq.put("Tou", 4);
    freq.put("rke", 4);
    freq.put("đã ", 193);
    freq.put("ình", 719);
    freq.put("rki", 3);
    freq.put("In ", 6);
    freq.put("rk ", 14);
    freq.put("đãi", 5);
    freq.put("ìn ", 131);
    freq.put("á", 3006);
    freq.put("Nhà", 21);
    freq.put("Int", 14);
    freq.put("Nhì", 18);
    freq.put("ík ", 3);
    freq.put("Ink", 6);
    freq.put("Inf", 5);
    freq.put("ann", 8);
    freq.put("gHa", 3);
    freq.put("Toà", 27);
    freq.put("Toá", 8);
    freq.put("hù ", 8);
    freq.put("Ơ", 7);
    freq.put("Nh ", 3);
    freq.put("ôn", 591);
    freq.put("ôm", 148);
    freq.put("ôi", 440);
    freq.put("ôg", 12);
    freq.put("oya", 3);
    freq.put(" À ", 6);
    freq.put("kĩ ", 4);
    freq.put("hùa", 3);
    freq.put("Nha", 12);
    freq.put("Sàn", 3);
    freq.put("hùi", 5);
    freq.put("Nhi", 9);
    freq.put("hùn", 15);
    freq.put("Âu ", 5);
    freq.put("ô ", 229);
    freq.put("oy ", 28);
    freq.put(" sú", 6);
    freq.put(" só", 14);
    freq.put(" sô", 5);
    freq.put(" sé", 3);
    freq.put(" sâ", 19);
    freq.put(" sà", 12);
    freq.put(" sá", 95);
    freq.put("yn ", 3);
    freq.put("bè ", 6);
    freq.put("L", 363);
    freq.put("Ran", 3);
    freq.put("Rai", 3);
    freq.put("Mus", 8);
    freq.put(" sr", 3);
    freq.put(" ss", 358);
    freq.put(" sp", 18);
    freq.put("Hác", 3);
    freq.put(" sv", 3);
    freq.put(" st", 32);
    freq.put(" su", 93);
    freq.put(" sj", 4);
    freq.put(" sk", 3);
    freq.put(" sh", 64);
    freq.put(" si", 111);
    freq.put(" sn", 12);
    freq.put(" so", 48);
    freq.put(" sl", 6);
    freq.put(" sm", 8);
    freq.put(" sb", 4);
    freq.put(" sc", 8);
    freq.put(" sa", 492);
    freq.put(" sg", 5);
    freq.put(" se", 49);
    freq.put("ize", 8);
    freq.put("MuC", 3);
    freq.put("izz", 23);
    freq.put("koi", 3);
    freq.put("Hóa", 3);
    freq.put("Mu ", 3);
    freq.put("CH ", 7);
    freq.put(" s ", 112);
    freq.put("óa", 42);
    freq.put("iz ", 11);
    freq.put("（", 3);
    freq.put(" sư", 41);
    freq.put(" Ý ", 10);
    freq.put("hưể", 64);
    freq.put("Iể", 22);
    freq.put(" sơ", 6);
    freq.put("có ", 811);
    freq.put("i", 13091);
    freq.put("ểA ", 7);
    freq.put("êu ", 241);
    freq.put("LG ", 3);
    freq.put("Buể", 3);
    freq.put("efo", 4);
    freq.put(" Ti", 49);
    freq.put(" sĩ", 11);
    freq.put("Bác", 3);
    freq.put("Bán", 41);
    freq.put(" să", 4);
    freq.put("rth", 4);
    freq.put("hi ", 287);
    freq.put("mí ", 16);
    freq.put("OF ", 3);
    freq.put("săn", 3);
    freq.put("Ju", 31);
    freq.put("ies", 3);
    freq.put("ieu", 26);
    freq.put("iet", 36);
    freq.put("iew", 8);
    freq.put("Jo", 24);
    freq.put("iem", 8);
    freq.put("Ji", 9);
    freq.put("ien", 29);
    freq.put("Je", 7);
    freq.put("Ja", 26);
    freq.put("hip", 22);
    freq.put("his", 4);
    freq.put("hit", 14);
    freq.put("rt ", 42);
    freq.put("hix", 18);
    freq.put("mít", 4);
    freq.put("hiz", 3);
    freq.put("hia", 13);
    freq.put("Xi", 11);
    freq.put("hie", 21);
    freq.put("hih", 7);
    freq.put("hik", 16);
    freq.put("him", 56);
    freq.put("hin", 31);
    freq.put(" 가", 5);
    freq.put("bf ", 3);
    freq.put("ghĩ", 76);
    freq.put("kê", 48);
    freq.put("ie ", 44);
    freq.put("J ", 71);
    freq.put("ars", 4);
    freq.put("AN ", 19);
    freq.put("ara", 21);
    freq.put("arc", 13);
    freq.put("ard", 12);
    freq.put("are", 11);
    freq.put("NV ", 3);
    freq.put("ari", 15);
    freq.put("ark", 19);
    freq.put("arl", 3);
    freq.put("uu ", 3);
    freq.put("aro", 3);
    freq.put(" P ", 20);
    freq.put(" Ăn", 4);
    freq.put("uuu", 12);
    freq.put("ar ", 16);
    freq.put(" xo", 115);
    freq.put("hiê", 91);
    freq.put(" Pr", 9);
    freq.put("c", 11241);
    freq.put(" Pa", 21);
    freq.put(" Pe", 7);
    freq.put(" Pi", 6);
    freq.put(" Ph", 91);
    freq.put(" Po", 11);
    freq.put("Em ", 40);
    freq.put("riê", 15);
    freq.put("oái", 18);
    freq.put("Tiê", 3);
    freq.put("tgi", 5);
    freq.put("iêm", 5);
    freq.put("iên", 240);
    freq.put("pr", 16);
    freq.put("pp", 96);
    freq.put("dun", 13);
    freq.put("pu", 4);
    freq.put("Rểt", 3);
    freq.put("dua", 3);
    freq.put("py", 9);
    freq.put("pc", 6);
    freq.put("pa", 115);
    freq.put("Rểi", 5);
    freq.put("pd", 4);
    freq.put("pe", 58);
    freq.put("pj", 3);
    freq.put("pk", 3);
    freq.put("KR ", 3);
    freq.put("pi", 35);
    freq.put("po", 56);
    freq.put("pl", 51);
    freq.put("pm", 8);
    freq.put(" Lể", 67);
    freq.put("iê ", 3);
    freq.put("du ", 26);
    freq.put("p ", 1083);
    freq.put("ói ", 257);
    freq.put("Rể ", 10);
    freq.put("rit", 3);
    freq.put("ris", 5);
    freq.put("rip", 6);
    freq.put("rin", 14);
    freq.put("ril", 3);
    freq.put("đá ", 27);
    freq.put("aha", 99);
    freq.put("rig", 3);
    freq.put("rid", 3);
    freq.put("rie", 6);
    freq.put("ric", 9);
    freq.put("ria", 3);
    freq.put("pà", 13);
    freq.put("pé", 8);
    freq.put("Cor", 7);
    freq.put("Cou", 3);
    freq.put("đáp", 3);
    freq.put("đág", 4);
    freq.put("đám", 8);
    freq.put("đáo", 4);
    freq.put("đán", 50);
    freq.put("Com", 4);
    freq.put("ri ", 17);
    freq.put("Con", 18);
    freq.put("huể", 123);
    freq.put("qa ", 7);
    freq.put(" Ân", 3);
    freq.put(" Âu", 5);
    freq.put("Quể", 66);
    freq.put("Ai ", 19);
    freq.put("ìh ", 16);
    freq.put("gưể", 177);
    freq.put("ĩnh", 7);
    freq.put("Áo ", 4);
    freq.put("zz ", 20);
    freq.put("Isr", 3);
    freq.put("zzz", 17);
    freq.put("gáp", 4);
    freq.put(" Ka", 24);
    freq.put("vển", 151);
    freq.put("gái", 68);
    freq.put("zza", 4);
    freq.put("lũ ", 13);
    freq.put("Ron", 3);
    freq.put("Roc", 3);
    freq.put("yle", 3);
    freq.put("ơi ", 301);
    freq.put("wn ", 42);
    freq.put(" ut", 6);
    freq.put("Hãy", 3);
    freq.put(" up", 23);
    freq.put(" um", 9);
    freq.put(" un", 21);
    freq.put(" uh", 33);
    freq.put(" ui", 7);
    freq.put(" uk", 16);
    freq.put("Miể", 9);
    freq.put(" u ", 10);
    freq.put("ca ", 30);
    freq.put("ix ", 21);
    freq.put("đĩa", 12);
    freq.put("Tôi", 24);
    freq.put("z", 308);
    freq.put("HH ", 3);
    freq.put("ênh", 12);
    freq.put("gra", 4);
    freq.put("gro", 3);
    freq.put("ưể", 847);
    freq.put("Dươ", 11);
    freq.put("Bâ", 6);
    freq.put("Bì", 18);
    freq.put("cưa", 3);
    freq.put("ểC ", 15);
    freq.put("â ", 4);
    freq.put("edi", 8);
    freq.put("LA ", 3);
    freq.put("Hể", 171);
    freq.put("FF ", 10);
    freq.put("mểo", 4);
    freq.put("mển", 93);
    freq.put("mểm", 29);
    freq.put("가가 ", 3);
    freq.put("mểj", 3);
    freq.put("mểi", 303);
    freq.put("mểe", 5);
    freq.put("mểc", 71);
    freq.put("mểa", 4);
    freq.put("mểy", 183);
    freq.put("UểN", 5);
    freq.put("mểu", 15);
    freq.put("mểt", 351);
    freq.put("mểp", 7);
    freq.put("ed ", 16);
    freq.put("xưể", 3);
    freq.put("âm", 89);
    freq.put("ân", 231);
    freq.put("cay", 3);
    freq.put("âu", 378);
    freq.put("ây", 270);
    freq.put("mể ", 164);
    freq.put("car", 6);
    freq.put("Kyu", 55);
    freq.put("rro", 3);
    freq.put("rre", 5);
    freq.put("rry", 5);
    freq.put("hk ", 6);
    freq.put("rrr", 13);
    freq.put("lưu", 6);
    freq.put("lưn", 6);
    freq.put("Mà ", 28);
    freq.put("cac", 12);
    freq.put("Yun", 9);
    freq.put("Ul", 3);
    freq.put("DT ", 5);
    freq.put("ÁI ", 5);
    freq.put("Lểy", 9);
    freq.put("ên ", 818);
    freq.put("Ô", 17);
    freq.put("app", 16);
    freq.put("nể", 485);
    freq.put("", 6);
    freq.put("ểng", 1605);
    freq.put("apo", 4);
    freq.put("lùn", 7);
    freq.put("apa", 6);
    freq.put("ểnh", 311);
    freq.put("tiể", 219);
    freq.put("use", 3);
    freq.put("fc ", 7);
    freq.put("Hun", 3);
    freq.put("Min", 99);
    freq.put("usi", 14);
    freq.put("MV ", 14);
    freq.put("ust", 4);
    freq.put(" R ", 5);
    freq.put("█", 4);
    freq.put("siê", 11);
    freq.put("Huy", 8);
    freq.put("ển ", 2660);
    freq.put("ap ", 42);
    freq.put("fe ", 6);
    freq.put("us ", 18);
    freq.put(" Ry", 7);
    freq.put(" Re", 13);
    freq.put("nda", 6);
    freq.put(" Ra", 9);
    freq.put(" Ro", 9);
    freq.put(" Ri", 8);
    freq.put("lươ", 4);
    freq.put("tat", 6);
    freq.put("tap", 5);
    freq.put("tar", 19);
    freq.put("tax", 5);
    freq.put("tay", 45);
    freq.put("tag", 5);
    freq.put("giể", 411);
    freq.put("tab", 4);
    freq.put("tal", 8);
    freq.put("tam", 5);
    freq.put("tan", 13);
    freq.put("tao", 23);
    freq.put("tai", 26);
    freq.put("tak", 4);
    freq.put("sis", 8);
    freq.put("Mir", 5);
    freq.put("sit", 6);
    freq.put("siz", 8);
    freq.put("sic", 14);
    freq.put("sia", 12);
    freq.put("sig", 8);
    freq.put("kyu", 15);
    freq.put("sie", 4);
    freq.put("KT ", 4);
    freq.put("sin", 52);
    freq.put("sim", 22);
    freq.put("sil", 5);
    freq.put("ôg ", 12);
    freq.put("ta ", 238);
    freq.put("si ", 5);
    freq.put("muể", 125);
    freq.put("ýt ", 10);
    freq.put("cto", 4);
    freq.put("bye", 4);
    freq.put("nuể", 3);
    freq.put("Car", 7);
    freq.put("kb ", 3);
    freq.put("Can", 3);
    freq.put("Cam", 3);
    freq.put("Ôi ", 7);
    freq.put("Ghé", 3);
    freq.put("òi ", 30);
    freq.put("nfo", 11);
    freq.put("Pro", 3);
    freq.put("nfl", 3);
    freq.put("nfi", 4);
    freq.put("cti", 8);
    freq.put("Ss ", 11);
    freq.put(" Ä", 3);
    freq.put("oui", 3);
    freq.put("sún", 3);
    freq.put("­n", 3);
    freq.put("oul", 3);
    freq.put("ouc", 4);
    freq.put("Biể", 16);
    freq.put("ous", 6);
    freq.put("our", 10);
    freq.put("oup", 10);
    freq.put("out", 18);
    freq.put("hý ", 5);
    freq.put("Aoi", 3);
    freq.put("ou ", 19);
    freq.put("ltr", 3);
    freq.put("（｡", 3);
    freq.put("g", 8812);
    freq.put("K ", 40);
    freq.put("dTa", 4);
    freq.put("bôn", 12);
    freq.put(" ㅠ ", 5);
    freq.put("Ka", 24);
    freq.put("Ke", 7);
    freq.put("Ki", 59);
    freq.put("Kh", 82);
    freq.put("Ko", 20);
    freq.put("bô ", 4);
    freq.put("Ku", 3);
    freq.put("Ky", 55);
    freq.put("gã ", 7);
    freq.put("Cre", 4);
    freq.put("tóm", 7);
    freq.put(" mể", 1237);
    freq.put("Bă", 5);
    freq.put("tóc", 40);
    freq.put("tóa", 4);
    freq.put("hr", 5);
    freq.put("hs", 5);
    freq.put("Po ", 3);
    freq.put("wha", 4);
    freq.put("dám", 21);
    freq.put("dán", 8);
    freq.put("Kí", 7);
    freq.put("hw", 5);
    freq.put("râu", 3);
    freq.put("Pos", 4);
    freq.put("Poo", 3);
    freq.put("hn", 53);
    freq.put("Dic", 3);
    freq.put("ㅠ ", 5);
    freq.put("goể", 18);
    freq.put("ha", 996);
    freq.put(" w ", 32);
    freq.put("hf", 3);
    freq.put("oMi", 4);
    freq.put("CÓ ", 4);
    freq.put(" Tư", 10);
    freq.put("q ", 4);
    freq.put("Vãi", 4);
    freq.put("TH ", 5);
    freq.put("Viể", 37);
    freq.put(" wg", 5);
    freq.put(" we", 24);
    freq.put("qu", 723);
    freq.put("qt", 3);
    freq.put(" wa", 47);
    freq.put(" wo", 39);
    freq.put(" wh", 8);
    freq.put(" wi", 13);
    freq.put("qa", 8);
    freq.put(" ww", 10);
    freq.put("qe", 4);
    freq.put(" wp", 4);
    freq.put("Chu", 58);
    freq.put("eba", 13);
    freq.put("ebo", 10);
    freq.put("ebu", 7);
    freq.put("ebs", 4);
    freq.put("Jae", 18);
    freq.put(" Hể", 130);
    freq.put("Ơ ", 8);
    freq.put("CHể", 13);
    freq.put("eb ", 11);
    freq.put("joo", 10);
    freq.put(" wá", 39);
    freq.put(" wê", 4);
    freq.put("qá", 41);
    freq.put("CD ", 5);
    freq.put(" wă", 4);
    freq.put("hm ", 39);
    freq.put("iki", 3);
    freq.put("rpo", 4);
    freq.put("Jun", 23);
    freq.put("IE ", 3);
    freq.put("cx ", 7);
    freq.put("Ju ", 5);
    freq.put(" Ơ ", 6);
    freq.put(" Tú", 3);
    freq.put("é", 409);
    freq.put(" Tô", 29);
    freq.put(" Tó", 6);
    freq.put(" Tí", 10);
    freq.put(" Tì", 11);
    freq.put(" Tê", 6);
    freq.put("kòg", 3);
    freq.put(" Tà", 11);
    freq.put("¡ ", 4);
    freq.put("mưa", 25);
    freq.put("avi", 8);
    freq.put("ave", 12);
    freq.put("ava", 10);
    freq.put("Sài", 4);
    freq.put("nhể", 670);
    freq.put(" ép", 4);
    freq.put("Hwa", 3);
    freq.put(" éo", 5);
    freq.put("MT ", 7);
    freq.put(" T ", 179);
    freq.put("¡c", 3);
    freq.put("Vui", 4);
    freq.put("av ", 5);
    freq.put(" Tw", 3);
    freq.put(" Tu", 32);
    freq.put(" Ts", 24);
    freq.put(" Tr", 148);
    freq.put(" Tp", 6);
    freq.put(" To", 68);
    freq.put("ㅋㅋㅋ", 6);
    freq.put(" Th", 293);
    freq.put(" Te", 29);
    freq.put(" Ta", 35);
    freq.put("Kín", 4);
    freq.put("tch", 3);
    freq.put(" kể", 165);
    freq.put("át ", 178);
    freq.put("Fan", 13);
    freq.put("Fac", 11);
    freq.put("T", 1437);
    freq.put("sk ", 5);
    freq.put("óm ", 31);
    freq.put("Sun", 28);
    freq.put("Suk", 6);
    freq.put("qen", 4);
    freq.put("Sup", 22);
    freq.put("iDa", 4);
    freq.put("cưn", 23);
    freq.put("nd ", 45);
    freq.put("Hú ", 3);
    freq.put("Su ", 11);
    freq.put("Gể", 16);
    freq.put("ndT", 4);
    freq.put("ndi", 9);
    freq.put("Phư", 9);
    freq.put("ndo", 22);
    freq.put("cư ", 20);
    freq.put("nde", 4);
    freq.put("hè", 46);
    freq.put("ND ", 14);
    freq.put("Hưể", 4);
    freq.put("ndr", 3);
    freq.put("ây ", 264);
    freq.put("Chà", 12);
    freq.put("owo", 4);
    freq.put("own", 44);
    freq.put("owe", 8);
    freq.put("Châ", 8);
    freq.put("hăn", 32);
    freq.put("ows", 9);
    freq.put("hăm", 19);
    freq.put("vai", 13);
    freq.put("van", 9);
    freq.put("vao", 6);
    freq.put("nểp", 11);
    freq.put("nểt", 12);
    freq.put("nểu", 56);
    freq.put("nểi", 81);
    freq.put("vay", 7);
    freq.put("nểm", 11);
    freq.put("nển", 47);
    freq.put("nểa", 190);
    freq.put("vat", 10);
    freq.put("òn ", 236);
    freq.put("đưể", 125);
    freq.put("xao", 4);
    freq.put("ow ", 51);
    freq.put("rl ", 26);
    freq.put("va ", 19);
    freq.put("nể ", 67);
    freq.put("Teu", 31);
    freq.put("lm ", 5);
    freq.put("Chú", 17);
    freq.put("í ", 210);
    freq.put("ít", 69);
    freq.put("Bư", 4);
    freq.put("mể", 1238);
    freq.put("ơm ", 23);
    freq.put("Ch", 285);
    freq.put("my ", 17);
    freq.put("bò ", 4);
    freq.put("ía", 12);
    freq.put("íc", 144);
    freq.put("ím", 9);
    freq.put(" U ", 10);
    freq.put("ín", 148);
    freq.put("íh", 7);
    freq.put("ík", 3);
    freq.put("íu", 9);
    freq.put(" xx", 14);
    freq.put("§n ", 3);
    freq.put("íp", 8);
  }
  
}

