package com.rmtheis.langdetect.profile;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.NGram;

import java.util.HashMap;

public class ZHCN {
  private static final String name = "zh-cn";
  private static final HashMap<String, Integer> freq = new HashMap<String, Integer>();
  private static final int[] n_words = new int[NGram.N_GRAM];

  public ZHCN() {
    init();  
  }

  public final LangProfile getLangProfile() {
    return new LangProfile(name, freq, n_words);
  }
  
  private void init() {
    n_words[0] = 450340;
    n_words[1] = 468445;
    n_words[2] = 361847;

    freq.put("为中", 26);
    freq.put("俘之三", 9);
    freq.put("为丢", 9);
    freq.put("之。丹", 42);
    freq.put("仞，", 25);
    freq.put("为丹", 81);
    freq.put("乱临 ", 17);
    freq.put("为临", 58);
    freq.put("俘之专", 10);
    freq.put("亟", 450);
    freq.put(" 丢坤", 7);
    freq.put("之。三", 82);
    freq.put("为三", 223);
    freq.put("丹华", 43);
    freq.put("之。一", 9);
    freq.put("之。丁", 38);
    freq.put("人专乘", 11);
    freq.put("人专乙", 11);
    freq.put("之。丛", 10);
    freq.put("之。丘", 10);
    freq.put("为丘", 35);
    freq.put("临", 22383);
    freq.put("为丛", 17);
    freq.put("为且", 30);
    freq.put("之。专", 68);
    freq.put("之。且", 41);
    freq.put("人专之", 60);
    freq.put("人专临", 19);
    freq.put("俘之之", 8);
    freq.put("，专 ", 17);
    freq.put("临的，", 43);
    freq.put("人专丹", 12);
    freq.put("亞三", 15);
    freq.put("之三丘", 271);
    freq.put("亞丁", 16);
    freq.put("临俘的", 8);
    freq.put("为乱", 8);
    freq.put("之。之", 67);
    freq.put("为乎", 165);
    freq.put("为么", 11);
    freq.put("人专专", 127);
    freq.put(" ･ ", 8);
    freq.put("乘华 ", 21);
    freq.put("之。乘", 24);
    freq.put("人专万", 14);
    freq.put("为乘", 98);
    freq.put("人专丁", 47);
    freq.put("在专", 358);
    freq.put("人专三", 71);
    freq.put("之临。", 37);
    freq.put("在丑", 8);
    freq.put("中之之", 22);
    freq.put("专乘中", 7);
    freq.put("专乘临", 51);
    freq.put("为人", 13);
    freq.put("仞！", 17);
    freq.put("专月三", 9);
    freq.put("专乘一", 8);
    freq.put("专乘丁", 86);
    freq.put("专乘万", 25);
    freq.put("专乘丈", 7);
    freq.put("专乘三", 168);
    freq.put("三年", 127);
    freq.put("专乘专", 159);
    freq.put("专乘且", 24);
    freq.put("之。临", 22);
    freq.put("之之》", 9);
    freq.put("之之《", 12);
    freq.put("专乘丘", 19);
    freq.put("专乘丙", 14);
    freq.put("丹且的", 22);
    freq.put("专乘丛", 19);
    freq.put("之之、", 11);
    freq.put("丛丁，", 30);
    freq.put("之日", 150);
    freq.put("日，中", 7);
    freq.put("且乘乘", 12);
    freq.put("专乘乱", 7);
    freq.put("《华", 12);
    freq.put("专月之", 19);
    freq.put("之三丁", 746);
    freq.put("专丁华", 11);
    freq.put(" 一乘", 7);
    freq.put(" 临：", 8);
    freq.put("？丹三", 12);
    freq.put("专乘么", 8);
    freq.put("专乘之", 87);
    freq.put("？丹丁", 7);
    freq.put(" 临，", 22);
    freq.put("乘临临", 26);
    freq.put("专乘乘", 27);
    freq.put("专乘乙", 22);
    freq.put("为仗", 12);
    freq.put("？丹专", 23);
    freq.put("国·", 33);
    freq.put("为万", 18);
    freq.put("「 ", 13);
    freq.put("三是仗", 18);
    freq.put("为一", 34);
    freq.put("丁， ", 42);
    freq.put("之。万", 14);
    freq.put("劈劈 ", 24);
    freq.put("丹之年", 12);
    freq.put("丘且，", 8);
    freq.put("乘专，", 36);
    freq.put("邡", 9);
    freq.put("三一年", 12);
    freq.put("临、丹", 8);
    freq.put("临丘万", 16);
    freq.put("《丢", 7);
    freq.put("丈大", 20);
    freq.put("专华乘", 13);
    freq.put("为丙", 11);
    freq.put(" 大", 363);
    freq.put("专华中", 9);
    freq.put("专华临", 34);
    freq.put("，是丁", 10);
    freq.put("丛乙，", 9);
    freq.put("丛的 ", 19);
    freq.put("三是人", 10);
    freq.put("专华丁", 36);
    freq.put("月三三", 8);
    freq.put("专华三", 47);
    freq.put("丢丁。", 9);
    freq.put("专华专", 44);
    freq.put("年在", 9);
    freq.put("三华的", 12);
    freq.put("么一专", 22);
    freq.put("为专", 114);
    freq.put("且万，", 11);
    freq.put("三是乙", 24);
    freq.put("三是乘", 79);
    freq.put("三是乎", 21);
    freq.put("▽≦", 9);
    freq.put("三是之", 111);
    freq.put("国 ", 143);
    freq.put("三是么", 17);
    freq.put("丹专是", 56);
    freq.put("丰，", 23);
    freq.put("为侄", 33);
    freq.put("临丘专", 69);
    freq.put("么么万", 15);
    freq.put("》 ", 136);
    freq.put("专丁丢", 20);
    freq.put("日专，", 8);
    freq.put("三是丛", 26);
    freq.put("三是丙", 12);
    freq.put("三是丘", 34);
    freq.put("之丘 ", 70);
    freq.put("三是且", 7);
    freq.put("三是专", 99);
    freq.put("坏", 179);
    freq.put("之丹的", 40);
    freq.put("一专在", 7);
    freq.put("三是三", 199);
    freq.put("三是万", 29);
    freq.put("之乙冲", 15);
    freq.put("临三 ", 210);
    freq.put("专、三", 31);
    freq.put("三是丁", 128);
    freq.put("三是一", 33);
    freq.put("三是为", 18);
    freq.put("三是丹", 69);
    freq.put("专华于", 11);
    freq.put("三是临", 59);
    freq.put("么！丹", 8);
    freq.put("三是中", 8);
    freq.put("三是丢", 16);
    freq.put("万且丁", 32);
    freq.put("乘丁万", 31);
    freq.put("，乘年", 7);
    freq.put("之专】", 10);
    freq.put("【之临", 10);
    freq.put("万且三", 60);
    freq.put("侃", 85);
    freq.put("万且专", 63);
    freq.put("万且且", 10);
    freq.put("之专。", 104);
    freq.put("万且丘", 7);
    freq.put("之机", 237);
    freq.put("之专》", 10);
    freq.put("【之专", 11);
    freq.put("丛。乘", 7);
    freq.put("？丁", 51);
    freq.put("专临、", 8);
    freq.put("暧丑", 8);
    freq.put("之月", 52);
    freq.put("之丫", 19);
    freq.put("【之丁", 12);
    freq.put("万且临", 11);
    freq.put("专临】", 9);
    freq.put("么乎么", 14);
    freq.put("【之三", 15);
    freq.put("国丛专", 7);
    freq.put("丛。丹", 9);
    freq.put("万且之", 34);
    freq.put("丛。临", 7);
    freq.put("万且乘", 8);
    freq.put("丁丢的", 10);
    freq.put("在大", 29);
    freq.put("兢", 125);
    freq.put("是： ", 7);
    freq.put("为之", 258);
    freq.put("丛。且", 7);
    freq.put("乘丁在", 7);
    freq.put("，万临", 18);
    freq.put("〒", 8);
    freq.put("侥专", 27);
    freq.put("【之之", 7);
    freq.put("临华于", 18);
    freq.put("乘丛专", 17);
    freq.put("丹且是", 17);
    freq.put(" 人人", 10);
    freq.put("俘，三", 8);
    freq.put("之三人", 44);
    freq.put("一之在", 28);
    freq.put("丙且三", 9);
    freq.put("丁乱丁", 28);
    freq.put("临丘之", 46);
    freq.put("丁乱三", 31);
    freq.put("坤临", 24);
    freq.put("三亥乙", 7);
    freq.put("丁乱临", 8);
    freq.put("且丙三", 12);
    freq.put("丈丹三", 7);
    freq.put("¬", 22);
    freq.put("三亥之", 19);
    freq.put("丈丹专", 11);
    freq.put("丁中国", 22);
    freq.put("乘丘中", 9);
    freq.put("俘，丹", 8);
    freq.put("专俩三", 11);
    freq.put("为乙", 18);
    freq.put("！！", 732);
    freq.put("！＂", 8);
    freq.put("俘，之", 8);
    freq.put("丹么么", 22);
    freq.put(" 乙 ", 20);
    freq.put("！（", 17);
    freq.put("丘的", 469);
    freq.put("在一专", 16);
    freq.put("且丁 ", 19);
    freq.put("丐之之", 10);
    freq.put("丹冲", 23);
    freq.put("！？", 7);
    freq.put("三专的", 268);
    freq.put("临华专", 15);
    freq.put("专专丁", 492);
    freq.put("三亥专", 13);
    freq.put("： ", 540);
    freq.put("之临、", 12);
    freq.put("三亥三", 23);
    freq.put("丘丙丘", 7);
    freq.put("之三亨", 7);
    freq.put("临华丁", 11);
    freq.put("丹为乎", 8);
    freq.put("丘丙丙", 8);
    freq.put("丈丹乘", 7);
    freq.put("三），", 7);
    freq.put("临华三", 17);
    freq.put("丁三 ", 287);
    freq.put("三亥万", 8);
    freq.put("于华是", 8);
    freq.put("临：专", 9);
    freq.put("三丈丹", 9);
    freq.put("仗丁之", 11);
    freq.put("亂丁", 8);
    freq.put(" 国专", 36);
    freq.put("临丘乘", 16);
    freq.put("之是", 940);
    freq.put("亂三", 14);
    freq.put("三丈临", 16);
    freq.put("临：丁", 9);
    freq.put("丙丛 ", 31);
    freq.put(" 丁年", 26);
    freq.put("仗丁乙", 10);
    freq.put("丐。。", 7);
    freq.put("临：三", 14);
    freq.put("丙丁的", 27);
    freq.put("临的", 896);
    freq.put(" 国三", 21);
    freq.put("三丈丘", 16);
    freq.put("万年", 38);
    freq.put("大三专", 48);
    freq.put("三大乱", 10);
    freq.put("的临，", 9);
    freq.put("临：丹", 9);
    freq.put("三丈专", 15);
    freq.put("大三丛", 8);
    freq.put("乘丘丁", 17);
    freq.put("大三丘", 17);
    freq.put("大三万", 30);
    freq.put("三丈丈", 8);
    freq.put("三丈三", 31);
    freq.put("大三丁", 56);
    freq.put("三之的", 335);
    freq.put("三丈丁", 14);
    freq.put("大三三", 124);
    freq.put("丢么。", 7);
    freq.put("坤丘", 11);
    freq.put("仗丁三", 14);
    freq.put("临：乘", 8);
    freq.put("仗丁丁", 10);
    freq.put(" 万之", 235);
    freq.put("（丛", 9);
    freq.put(" （万", 26);
    freq.put("之三亟", 9);
    freq.put("临：之", 14);
    freq.put("仗丁专", 12);
    freq.put("坤且", 8);
    freq.put("专仗仗", 8);
    freq.put("乞", 261);
    freq.put("丹专么", 22);
    freq.put("之丘", 1120);
    freq.put("丛。", 197);
    freq.put("丛、", 41);
    freq.put("坤专", 65);
    freq.put("三丈之", 29);
    freq.put("▽╰ ", 12);
    freq.put("之乱的", 11);
    freq.put("华拼", 7);
    freq.put("大三之", 54);
    freq.put("三的之", 189);
    freq.put("专仗三", 15);
    freq.put("之，是", 16);
    freq.put("专仗丁", 8);
    freq.put("」", 251);
    freq.put("临是之", 7);
    freq.put("３", 9);
    freq.put("专是丘", 31);
    freq.put("专仗专", 7);
    freq.put("国大专", 28);
    freq.put("ア", 32);
    freq.put("专专】", 21);
    freq.put("专丈 ", 10);
    freq.put("专在且", 16);
    freq.put("丹丁华", 12);
    freq.put("丟", 28);
    freq.put("专专》", 17);
    freq.put("国大三", 11);
    freq.put("专专、", 22);
    freq.put("的专 ", 39);
    freq.put("专专。", 163);
    freq.put("专仗之", 17);
    freq.put("么丁，", 12);
    freq.put("『三", 10);
    freq.put("丁万的", 27);
    freq.put("临是三", 16);
    freq.put("的！", 52);
    freq.put("丛专的", 17);
    freq.put("。三万", 30);
    freq.put("之丙，", 23);
    freq.put("丹临万", 10);
    freq.put("临丘乱", 7);
    freq.put("丛丁：", 8);
    freq.put("，万丁", 30);
    freq.put("丘万丁", 18);
    freq.put("丹乘乘", 23);
    freq.put("么的专", 15);
    freq.put("丙，", 168);
    freq.put("三乘之", 136);
    freq.put("丙！", 36);
    freq.put("嗯。", 11);
    freq.put("丹乘之", 39);
    freq.put("丙；", 7);
    freq.put("丙：", 16);
    freq.put("么的丁", 13);
    freq.put("是三乘", 25);
    freq.put("么的三", 17);
    freq.put("：大专", 9);
    freq.put("가 ", 67);
    freq.put("么的临", 9);
    freq.put("万乱之", 16);
    freq.put("丁，在", 17);
    freq.put("之国人", 26);
    freq.put(" 佛之", 20);
    freq.put("丹在", 166);
    freq.put("丹乘丘", 15);
    freq.put(" 乩", 32);
    freq.put("是三三", 198);
    freq.put("华是", 15);
    freq.put("是三万", 53);
    freq.put("丹乘专", 38);
    freq.put(" 之月", 26);
    freq.put("是三丁", 68);
    freq.put("是三一", 22);
    freq.put("丛乘 ", 15);
    freq.put("丹乘三", 58);
    freq.put("是三丛", 16);
    freq.put("是三丙", 7);
    freq.put("是三丘", 35);
    freq.put("万乱临", 7);
    freq.put("么的之", 8);
    freq.put("丹乘万", 10);
    freq.put("丁么。", 19);
    freq.put(" 佛专", 10);
    freq.put("丹乘丹", 25);
    freq.put("万乱三", 9);
    freq.put("且丹 ", 10);
    freq.put("是三丢", 10);
    freq.put("万乱丁", 13);
    freq.put("万大", 50);
    freq.put("乙丙三", 17);
    freq.put("三乘乙", 33);
    freq.put("是三丹", 26);
    freq.put(" 之机", 15);
    freq.put("丁》 ", 15);
    freq.put("万乱专", 19);
    freq.put("丢丘专", 9);
    freq.put("━", 10);
    freq.put("丁。。", 43);
    freq.put("乘丘乘", 13);
    freq.put("之国专", 59);
    freq.put("大的乙", 8);
    freq.put("乎日", 8);
    freq.put("之国万", 21);
    freq.put("丘中国", 14);
    freq.put("三大临", 18);
    freq.put("之国丁", 40);
    freq.put("之国一", 7);
    freq.put("丛丛的", 13);
    freq.put("大的之", 7);
    freq.put("之国三", 114);
    freq.put(" 丹俩", 11);
    freq.put("之国临", 31);
    freq.put(" 丁俩", 10);
    freq.put("丁丁。", 86);
    freq.put("之国丹", 9);
    freq.put("丁丁「", 10);
    freq.put("］", 9);
    freq.put("丁》", 64);
    freq.put("大的专", 13);
    freq.put("丘的丛", 7);
    freq.put("华三", 521);
    freq.put("坤乙", 23);
    freq.put("三的专", 242);
    freq.put("乘丘之", 27);
    freq.put("丁丁》", 11);
    freq.put("晗", 7);
    freq.put("大的三", 24);
    freq.put("之国之", 42);
    freq.put("之三、", 21);
    freq.put("为三专", 21);
    freq.put("之三专", 961);
    freq.put("丘丙之", 11);
    freq.put("大的临", 8);
    freq.put("三坤专", 13);
    freq.put("是三人", 11);
    freq.put("大专专", 58);
    freq.put("么丹临", 12);
    freq.put("在丘三", 8);
    freq.put("哟 ", 17);
    freq.put("且临丛", 8);
    freq.put("且临丘", 13);
    freq.put("专之】", 14);
    freq.put("¯﹃¯", 7);
    freq.put("且临专", 39);
    freq.put("中。 ", 7);
    freq.put("大临专", 17);
    freq.put("且临且", 10);
    freq.put(" 丹乘", 112);
    freq.put(" 丹乙", 41);
    freq.put("且临三", 44);
    freq.put("专之、", 21);
    freq.put("临丹。", 8);
    freq.put("专之。", 171);
    freq.put("且临丁", 26);
    freq.put("大专丛", 8);
    freq.put("三仗丹", 9);
    freq.put("专之《", 16);
    freq.put("乘之人", 7);
    freq.put("且临丹", 15);
    freq.put("三仗丁", 15);
    freq.put("三人么", 8);
    freq.put(" 佛佛", 154);
    freq.put("三人之", 74);
    freq.put("三仗三", 27);
    freq.put("且临临", 11);
    freq.put(" 丛丁", 36);
    freq.put("三仗专", 14);
    freq.put("三的一", 47);
    freq.put("三人乘", 9);
    freq.put("三人乙", 7);
    freq.put("三的丁", 180);
    freq.put("之怜", 27);
    freq.put(" 丹丈", 17);
    freq.put(" 丹三", 407);
    freq.put(" 丹一", 27);
    freq.put(" 丹丁", 217);
    freq.put(" 丹万", 100);
    freq.put("且临之", 56);
    freq.put(" 丹丙", 66);
    freq.put(" 丹丛", 64);
    freq.put("三人临", 21);
    freq.put("乙三之", 128);
    freq.put(" 丹丐", 10);
    freq.put("三人丹", 16);
    freq.put("三人为", 7);
    freq.put(" 丹专", 388);
    freq.put(" 丹且", 130);
    freq.put("且专是", 43);
    freq.put("噢", 35);
    freq.put("三人万", 23);
    freq.put("三人三", 112);
    freq.put(" 丹丢", 21);
    freq.put("三仗之", 24);
    freq.put(" 之是", 87);
    freq.put(" 丹丹", 106);
    freq.put("三人专", 121);
    freq.put("三人且", 7);
    freq.put("三人丘", 16);
    freq.put(" 丹临", 174);
    freq.put("，丘临", 38);
    freq.put("三年之", 18);
    freq.put("。临专", 27);
    freq.put("专且，", 22);
    freq.put("。临丘", 8);
    freq.put("、华", 8);
    freq.put("丈乙", 45);
    freq.put("丹国", 45);
    freq.put("专丁国", 10);
    freq.put("万么，", 10);
    freq.put("之一丹", 14);
    freq.put("，丘中", 7);
    freq.put("三大丘", 12);
    freq.put("。临三", 18);
    freq.put(" 丹仗", 14);
    freq.put("三大万", 50);
    freq.put("，丘专", 25);
    freq.put("之一万", 39);
    freq.put("之一丈", 7);
    freq.put("之一三", 145);
    freq.put("丙三是", 7);
    freq.put("，丘丛", 8);
    freq.put("侄 ", 12);
    freq.put("╯ ", 24);
    freq.put("，丘万", 10);
    freq.put("之一专", 235);
    freq.put("之一且", 11);
    freq.put("，丘丁", 25);
    freq.put("国的专", 10);
    freq.put("之一丘", 10);
    freq.put("临乎么", 19);
    freq.put("，丘三", 54);
    freq.put("佇", 19);
    freq.put("三年三", 18);
    freq.put("三年万", 11);
    freq.put(" 丹亞", 7);
    freq.put("日，专", 10);
    freq.put("丁）、", 21);
    freq.put("三年专", 9);
    freq.put("。临之", 26);
    freq.put("，中三", 20);
    freq.put("之一之", 91);
    freq.put(" 丰", 51);
    freq.put("之一乎", 11);
    freq.put("，丘乘", 7);
    freq.put("三仗仗", 11);
    freq.put("乘乘。", 7);
    freq.put("之临是", 12);
    freq.put("临乎丁", 7);
    freq.put("之一乘", 18);
    freq.put("丛丹。", 7);
    freq.put("三年临", 11);
    freq.put("，丘之", 31);
    freq.put("仗丹三", 10);
    freq.put("年三丹", 11);
    freq.put("且之 ", 54);
    freq.put(" 且乘", 20);
    freq.put("乱、", 11);
    freq.put("丹。 ", 23);
    freq.put("乱。", 59);
    freq.put(" 且之", 189);
    freq.put("为丘之", 7);
    freq.put(" 年", 479);
    freq.put("丛的", 263);
    freq.put("乱《", 9);
    freq.put("国的丁", 16);
    freq.put("丛专是", 8);
    freq.put("年三专", 31);
    freq.put("乘专：", 13);
    freq.put("之】 ", 28);
    freq.put("年三三", 37);
    freq.put(" 专 ", 260);
    freq.put("年三万", 13);
    freq.put("年三丁", 18);
    freq.put("亟 ", 81);
    freq.put("丁丁的", 154);
    freq.put("丁的", 1157);
    freq.put("专丘大", 7);
    freq.put(" 且且", 32);
    freq.put(" 且专", 159);
    freq.put("俘俘", 19);
    freq.put("倪之三", 16);
    freq.put(" 且三", 120);
    freq.put(" 且万", 26);
    freq.put(" 且丁", 45);
    freq.put(" 且丹", 25);
    freq.put("彦", 26);
    freq.put("的三亥", 8);
    freq.put("临？ ", 15);
    freq.put(" 且临", 43);
    freq.put("三一大", 7);
    freq.put("的三人", 18);
    freq.put("年三之", 29);
    freq.put("年的三", 10);
    freq.put(" 三", 5643);
    freq.put("的三么", 12);
    freq.put("▽╰", 12);
    freq.put("的三之", 401);
    freq.put("仗乎", 11);
    freq.put("仗之", 166);
    freq.put("仗么", 25);
    freq.put("。之临", 9);
    freq.put("乘专丹", 51);
    freq.put("佛专之", 16);
    freq.put("的三乘", 24);
    freq.put("的三乙", 31);
    freq.put("年的专", 14);
    freq.put("丹丁 ", 59);
    freq.put("。之为", 21);
    freq.put("仗乘", 26);
    freq.put("国丁丁", 28);
    freq.put("ㅠㅠㅠ", 19);
    freq.put("。之丁", 31);
    freq.put("国丁万", 24);
    freq.put(" 之日", 35);
    freq.put("国丁三", 27);
    freq.put("。之三", 52);
    freq.put("。丹乘", 11);
    freq.put("。之且", 37);
    freq.put("国丁专", 23);
    freq.put("。之专", 69);
    freq.put("冲是", 14);
    freq.put("。之丘", 7);
    freq.put("仗万", 24);
    freq.put("丘三 ", 67);
    freq.put("的三丈", 8);
    freq.put("的三三", 454);
    freq.put("仗丁", 115);
    freq.put("仗一", 17);
    freq.put("的三万", 65);
    freq.put("的三一", 25);
    freq.put("的三丁", 151);
    freq.put("仗三", 180);
    freq.put("仗丈", 10);
    freq.put("临专丘", 53);
    freq.put("仗且", 23);
    freq.put("仗专", 128);
    freq.put("的三丙", 13);
    freq.put("仗丑", 14);
    freq.put("的三丛", 38);
    freq.put("的三且", 15);
    freq.put("仗丛", 36);
    freq.put(" 丛么", 10);
    freq.put("仗丙", 29);
    freq.put("仗丘", 57);
    freq.put("专三在", 64);
    freq.put(" ：三", 7);
    freq.put("仗丢", 28);
    freq.put("国丁之", 24);
    freq.put("丘乱 ", 10);
    freq.put("中三的", 10);
    freq.put("。之之", 45);
    freq.put("仗临", 39);
    freq.put("的三丹", 33);
    freq.put("的三临", 107);
    freq.put("国丁乘", 7);
    freq.put("。之乘", 7);
    freq.put("万丁。", 17);
    freq.put("仗丹", 47);
    freq.put(" 华三", 18);
    freq.put("万三且", 41);
    freq.put("万三专", 451);
    freq.put("丹一万", 9);
    freq.put("华临丘", 9);
    freq.put(" 华丁", 42);
    freq.put("丹一三", 30);
    freq.put("万三丛", 33);
    freq.put("三，之", 294);
    freq.put("万三丙", 23);
    freq.put("万三丘", 85);
    freq.put("万三万", 144);
    freq.put("丹一专", 32);
    freq.put("万三丁", 226);
    freq.put("万三一", 51);
    freq.put("专人在", 14);
    freq.put("且大三", 7);
    freq.put("万三三", 459);
    freq.put("万三丈", 11);
    freq.put("万三临", 102);
    freq.put("万三丰", 10);
    freq.put("万三为", 20);
    freq.put("仗俩", 7);
    freq.put("乙三丘", 32);
    freq.put("临乱临", 19);
    freq.put("万三丢", 15);
    freq.put("丹一临", 11);
    freq.put("三，乱", 18);
    freq.put("专的，", 59);
    freq.put("万三中", 16);
    freq.put("丹一丹", 7);
    freq.put("乘乙，", 11);
    freq.put("华临专", 36);
    freq.put("三，万", 73);
    freq.put(" 华之", 12);
    freq.put("乘之丁", 73);
    freq.put("三，一", 56);
    freq.put("乎是", 9);
    freq.put("一专冲", 7);
    freq.put("丹一之", 48);
    freq.put("万三乙", 32);
    freq.put("万三乘", 82);
    freq.put(" 华乙", 27);
    freq.put("三，且", 174);
    freq.put("三，专", 259);
    freq.put("且大之", 12);
    freq.put("丹一乙", 7);
    freq.put("万三之", 386);
    freq.put("俘仗", 7);
    freq.put("三，丘", 56);
    freq.put("万三么", 29);
    freq.put("三，丢", 8);
    freq.put("万三乱", 10);
    freq.put("乘之丛", 17);
    freq.put("三，中", 21);
    freq.put("乘之丘", 16);
    freq.put("三，临", 86);
    freq.put("、冲", 8);
    freq.put("乙临么", 8);
    freq.put("三，为", 13);
    freq.put("三，丹", 127);
    freq.put("俘三", 111);
    freq.put("俘丁", 45);
    freq.put("乙的丢", 7);
    freq.put("俘万", 11);
    freq.put("华于 ", 12);
    freq.put("俘丛", 35);
    freq.put("俘丘", 13);
    freq.put("丙丙 ", 11);
    freq.put("俘专", 50);
    freq.put("乙的临", 15);
    freq.put("俘丑", 11);
    freq.put("仗佛", 13);
    freq.put("俘且", 23);
    freq.put("丙丘乘", 8);
    freq.put("乙的三", 44);
    freq.put("俘丢", 27);
    freq.put("乙的万", 8);
    freq.put("丹大之", 7);
    freq.put("万三人", 81);
    freq.put("乙的丁", 32);
    freq.put("丙丘之", 31);
    freq.put("临爬", 10);
    freq.put("俘丹", 15);
    freq.put("乙的丛", 7);
    freq.put("乙的丘", 9);
    freq.put("三乙冲", 12);
    freq.put("之年的", 13);
    freq.put("乙的专", 39);
    freq.put("俘临", 25);
    freq.put("为专之", 14);
    freq.put("万三仗", 18);
    freq.put("俘之", 101);
    freq.put("俘么", 22);
    freq.put("。专丹", 10);
    freq.put("三，于", 7);
    freq.put("之且，", 68);
    freq.put("三丑，", 7);
    freq.put("俘乘", 16);
    freq.put("俘乙", 22);
    freq.put("） ", 224);
    freq.put("乙丁。", 13);
    freq.put("大临 ", 15);
    freq.put("。专丘", 7);
    freq.put("乙的之", 22);
    freq.put("为专专", 32);
    freq.put("。专且", 14);
    freq.put("丙丘专", 15);
    freq.put("之丢 ", 43);
    freq.put("。专专", 61);
    freq.put("乱", 2675);
    freq.put("丙丘三", 17);
    freq.put("丹大专", 15);
    freq.put("。专三", 69);
    freq.put("乙的乘", 10);
    freq.put("乙的乙", 8);
    freq.put("【华丁", 10);
    freq.put("俘乱", 7);
    freq.put("三，人", 8);
    freq.put("。专丁", 23);
    freq.put("三大", 408);
    freq.put("，並", 8);
    freq.put("万丢丢", 7);
    freq.put("丰的", 10);
    freq.put("《丘三", 16);
    freq.put("丢丢之", 20);
    freq.put("专（ ", 8);
    freq.put("丑之三", 15);
    freq.put("三国", 377);
    freq.put("万丢丁", 10);
    freq.put("丑之丁", 35);
    freq.put("丘临乙", 14);
    freq.put("万丢三", 9);
    freq.put("在华", 33);
    freq.put("丹乙 ", 21);
    freq.put("丑之专", 12);
    freq.put("丘临之", 96);
    freq.put("丹国之", 7);
    freq.put("丘临么", 8);
    freq.put("丘临临", 36);
    freq.put("俩～俩", 8);
    freq.put("ˇ", 7);
    freq.put("之丹，", 31);
    freq.put(" 倪", 16);
    freq.put("丹之在", 9);
    freq.put("丘临丹", 31);
    freq.put("丑之之", 16);
    freq.put("￥", 7);
    freq.put("丛是", 45);
    freq.put("丘临丛", 22);
    freq.put("万丢之", 18);
    freq.put("丘临丙", 9);
    freq.put("丘临丘", 29);
    freq.put("丘临万", 13);
    freq.put("。丹之", 21);
    freq.put("丘临丁", 52);
    freq.put("丘临一", 9);
    freq.put("一年之", 11);
    freq.put("丘临三", 86);
    freq.put("丘临丈", 10);
    freq.put("在么之", 23);
    freq.put("，丰", 30);
    freq.put("乘之之", 160);
    freq.put("丁《专", 8);
    freq.put("乘之么", 21);
    freq.put("丁《三", 8);
    freq.put("丘且的", 7);
    freq.put("乘专的", 54);
    freq.put("乘临 ", 46);
    freq.put("乘丢坤", 20);
    freq.put("中国·", 33);
    freq.put("丁在 ", 10);
    freq.put("丹丙专", 63);
    freq.put("乱丹之", 8);
    freq.put("临人之", 19);
    freq.put(" 亨", 17);
    freq.put("华么", 15);
    freq.put("国丛之", 7);
    freq.put("晟", 11);
    freq.put("之中。", 7);
    freq.put(" 傀", 9);
    freq.put("之万 ", 96);
    freq.put("临人丘", 9);
    freq.put("临人丛", 8);
    freq.put("的之国", 11);
    freq.put("丘丫丁", 11);
    freq.put("乘之乘", 23);
    freq.put("三华，", 9);
    freq.put("乘之乙", 11);
    freq.put("乱丹三", 8);
    freq.put("临人三", 30);
    freq.put("临三在", 20);
    freq.put("么 ", 449);
    freq.put(" 兢", 18);
    freq.put("临丰，", 10);
    freq.put("丛丹专", 24);
    freq.put("日华", 69);
    freq.put("在乘之", 15);
    freq.put("么专 ", 19);
    freq.put("，且", 1122);
    freq.put("的？", 48);
    freq.put("丹且，", 16);
    freq.put("乙乙。", 10);
    freq.put("的之在", 13);
    freq.put("，专", 1775);
    freq.put("之丁 ", 372);
    freq.put(" 三是", 83);
    freq.put("在乘三", 14);
    freq.put("》三之", 14);
    freq.put(" 临的", 40);
    freq.put("侃之", 9);
    freq.put("临俘之", 11);
    freq.put("侄", 158);
    freq.put("【机丛", 7);
    freq.put("，之的", 12);
    freq.put("临丛且", 8);
    freq.put("／", 12);
    freq.put("】", 716);
    freq.put("三坏", 20);
    freq.put(" 丢丙", 9);
    freq.put("仞的", 7);
    freq.put("日在三", 8);
    freq.put("的；", 8);
    freq.put("」之", 18);
    freq.put("┳", 7);
    freq.put("三坤", 62);
    freq.put("侃丁", 10);
    freq.put("临丛丛", 9);
    freq.put(" 冲", 88);
    freq.put("，丁年", 9);
    freq.put("（专丁", 8);
    freq.put("临丛万", 11);
    freq.put("专：＂", 8);
    freq.put("（专三", 14);
    freq.put("」三", 20);
    freq.put("！临之", 9);
    freq.put("乘三一", 22);
    freq.put("（专专", 19);
    freq.put("」专", 11);
    freq.put("」丘", 7);
    freq.put("三且中", 8);
    freq.put(" 丁坤", 12);
    freq.put("，乱丹", 7);
    freq.put("，乱临", 7);
    freq.put("临丛丁", 18);
    freq.put("之丛丹", 13);
    freq.put("三且丹", 63);
    freq.put("之丛临", 48);
    freq.put("三且临", 46);
    freq.put("，乱丘", 8);
    freq.put("╭ ", 19);
    freq.put("三且丈", 14);
    freq.put("三且三", 176);
    freq.put("，乱且", 7);
    freq.put("三且万", 44);
    freq.put("之丛万", 21);
    freq.put("临国之", 9);
    freq.put("之丛丁", 62);
    freq.put("三且一", 35);
    freq.put("，乱专", 28);
    freq.put("万坤", 28);
    freq.put("之丛丙", 7);
    freq.put("，乱三", 13);
    freq.put("三且丘", 14);
    freq.put("三且丙", 15);
    freq.put("三且且", 22);
    freq.put("，乱丁", 15);
    freq.put("之丛专", 58);
    freq.put("三且丑", 8);
    freq.put("亞之", 14);
    freq.put("丁万，", 49);
    freq.put("国人 ", 8);
    freq.put("丹（", 8);
    freq.put(" 刨", 50);
    freq.put("专丁大", 8);
    freq.put("专）", 101);
    freq.put("丹大", 53);
    freq.put("乘专乙", 19);
    freq.put(" 丁圳", 16);
    freq.put("丛之。", 52);
    freq.put("临国丁", 15);
    freq.put("三专；", 9);
    freq.put("万圳", 7);
    freq.put("三且之", 134);
    freq.put("三且么", 11);
    freq.put("临国三", 22);
    freq.put("专（", 82);
    freq.put("，乎", 59);
    freq.put("临国专", 13);
    freq.put("之丛乙", 11);
    freq.put("之丛乘", 8);
    freq.put("三且乘", 41);
    freq.put("，乱之", 21);
    freq.put("大之专", 19);
    freq.put("万在", 73);
    freq.put("临？", 55);
    freq.put("的「", 9);
    freq.put("的《", 21);
    freq.put("临；", 17);
    freq.put("丙丁：", 8);
    freq.put("的。", 231);
    freq.put("？】", 19);
    freq.put("的、", 11);
    freq.put("？』", 7);
    freq.put("丙丁，", 29);
    freq.put("临，", 821);
    freq.put("的是丹", 8);
    freq.put("咔", 8);
    freq.put("临（", 18);
    freq.put("临）", 23);
    freq.put("华于的", 7);
    freq.put("临乘 ", 59);
    freq.put("三中国", 71);
    freq.put(" 三日", 14);
    freq.put("的是临", 8);
    freq.put("临！", 107);
    freq.put("三且于", 12);
    freq.put("大之三", 38);
    freq.put("的是三", 28);
    freq.put("专丁：", 25);
    freq.put("三之；", 19);
    freq.put("三之：", 80);
    freq.put("的是丁", 20);
    freq.put("三之？", 30);
    freq.put("的是万", 7);
    freq.put("侮", 97);
    freq.put("三之！", 48);
    freq.put("的国", 65);
    freq.put("的是专", 15);
    freq.put("《大", 13);
    freq.put("临万乘", 11);
    freq.put("三之，", 511);
    freq.put("临～", 8);
    freq.put("丹专三", 336);
    freq.put("蝉", 8);
    freq.put("三为是", 11);
    freq.put("临临是", 8);
    freq.put("三是丑", 7);
    freq.put("临国人", 11);
    freq.put("的是之", 7);
    freq.put("专，", 1910);
    freq.put("华且", 17);
    freq.put(" 劈", 49);
    freq.put("万、专", 8);
    freq.put("大之万", 9);
    freq.put("万、三", 13);
    freq.put("之乱，", 12);
    freq.put("佛三三", 8);
    freq.put("丢，丹", 12);
    freq.put("丢，临", 10);
    freq.put("佛三万", 10);
    freq.put("██", 23);
    freq.put("，亥", 15);
    freq.put("丁丈临", 12);
    freq.put("佛三专", 9);
    freq.put("丁丈丹", 10);
    freq.put("且在 ", 7);
    freq.put("专、之", 24);
    freq.put("丁丈丁", 14);
    freq.put("之丁日", 8);
    freq.put("¬ ", 21);
    freq.put("丁丈三", 22);
    freq.put(" 华", 175);
    freq.put("丢，专", 17);
    freq.put("丁丈专", 18);
    freq.put("丁丈丑", 8);
    freq.put("丢，三", 18);
    freq.put("之丘且", 15);
    freq.put("乙丛之", 19);
    freq.put("丁丈丙", 7);
    freq.put("丢，丁", 9);
    freq.put("专！", 183);
    freq.put("。丁专", 30);
    freq.put("佛三之", 13);
    freq.put("三专：", 118);
    freq.put("丘（", 15);
    freq.put("丘）", 13);
    freq.put("三专？", 14);
    freq.put("丘，", 535);
    freq.put("乙丛临", 7);
    freq.put("丘！", 73);
    freq.put("丘：", 61);
    freq.put("丘；", 32);
    freq.put("三专）", 15);
    freq.put("丈华", 9);
    freq.put("丘？", 38);
    freq.put("三专，", 374);
    freq.put("三专！", 22);
    freq.put("，乘在", 9);
    freq.put("乙丛专", 23);
    freq.put("临专，", 135);
    freq.put("丢，乘", 7);
    freq.put("临专（", 11);
    freq.put("临专）", 7);
    freq.put("丁丈之", 13);
    freq.put("专、丁", 8);
    freq.put("乙丛丁", 11);
    freq.put("临专：", 21);
    freq.put("丢，之", 16);
    freq.put("专、专", 16);
    freq.put("三之大", 65);
    freq.put("乙丛三", 24);
    freq.put("，丹且", 70);
    freq.put("，丹专", 209);
    freq.put("丁人 ", 37);
    freq.put("，丹丘", 21);
    freq.put("，丹丙", 14);
    freq.put("，丹丛", 17);
    freq.put("，丹万", 63);
    freq.put(" 叶", 11);
    freq.put("，丹丁", 73);
    freq.put("丙", 4454);
    freq.put("，丹三", 128);
    freq.put("仗丘之", 7);
    freq.put("，丹临", 50);
    freq.put("，丹丰", 9);
    freq.put("丹三，", 49);
    freq.put("万国", 33);
    freq.put("，丹丹", 48);
    freq.put("丹的 ", 23);
    freq.put("丁之是", 62);
    freq.put("丹专丁", 144);
    freq.put("丘之，", 72);
    freq.put("，丹乘", 22);
    freq.put("，丹乙", 13);
    freq.put("丘专。", 29);
    freq.put("三《专", 8);
    freq.put("临临丹", 47);
    freq.put("俘", 831);
    freq.put("，丹么", 15);
    freq.put("，丹之", 145);
    freq.put("万。 ", 38);
    freq.put("是 ", 255);
    freq.put("专且的", 8);
    freq.put("丈丘丁", 16);
    freq.put("丈丘三", 14);
    freq.put("丢俩", 15);
    freq.put("﹏ ", 10);
    freq.put("专。 ", 204);
    freq.put("乘专么", 23);
    freq.put("乙丘 ", 31);
    freq.put("是丛？", 7);
    freq.put("丹丛乘", 7);
    freq.put(" 亟亟", 9);
    freq.put("专。临", 14);
    freq.put("丹？ ", 19);
    freq.put("一是", 8);
    freq.put("丈丘临", 7);
    freq.put("丢俘", 17);
    freq.put("专乙 ", 53);
    freq.put("～俩～", 8);
    freq.put("乘万乘", 8);
    freq.put("丈丘之", 14);
    freq.put("三劈", 40);
    freq.put("在在", 7);
    freq.put("三《三", 7);
    freq.put(" 吾", 8);
    freq.put("大仗", 15);
    freq.put("三么。", 20);
    freq.put("之专、", 17);
    freq.put("三为 ", 28);
    freq.put("大临", 118);
    freq.put("专吾专", 16);
    freq.put("大丹", 39);
    freq.put("么乘，", 7);
    freq.put("俩俩", 90);
    freq.put("大丢", 49);
    freq.put("大中", 8);
    freq.put("大且", 10);
    freq.put("大专", 517);
    freq.put("大丑", 14);
    freq.put("大丐", 14);
    freq.put("大丛", 29);
    freq.put("三临 ", 210);
    freq.put("大丘", 46);
    freq.put("大万", 214);
    freq.put("一丹 ", 12);
    freq.put("大丁", 175);
    freq.put("大一", 8);
    freq.put("丹！！", 9);
    freq.put(" 哟", 7);
    freq.put("大三", 495);
    freq.put("大丈", 44);
    freq.put(" 咦", 11);
    freq.put("大乱", 33);
    freq.put("丹三的", 57);
    freq.put("是人三", 10);
    freq.put("侏 ", 10);
    freq.put("万之。", 64);
    freq.put("人】 ", 7);
    freq.put(" 咀", 15);
    freq.put("丫 ", 50);
    freq.put("万冲", 28);
    freq.put("丘丘丢", 8);
    freq.put("大乙", 37);
    freq.put("大乘", 45);
    freq.put("三刨", 8);
    freq.put("大之", 240);
    freq.put("大么", 14);
    freq.put("：一", 31);
    freq.put("丛丛？", 7);
    freq.put("专乙么", 9);
    freq.put(" 啧", 13);
    freq.put("俩乱", 15);
    freq.put("乘三之", 182);
    freq.put("乘三乎", 10);
    freq.put("丛丛，", 12);
    freq.put(" 乘在", 12);
    freq.put("乘三乘", 39);
    freq.put("乘三乙", 28);
    freq.put("丛丛！", 8);
    freq.put("专丁年", 21);
    freq.put("俩乙", 18);
    freq.put("俩乘", 29);
    freq.put("的俩之", 7);
    freq.put("三叶", 7);
    freq.put("俩么", 17);
    freq.put("俩之", 148);
    freq.put("丢仗", 35);
    freq.put("专亥", 33);
    freq.put(" 刨，", 9);
    freq.put("三日，", 9);
    freq.put("俩丹", 18);
    freq.put("丢亥", 13);
    freq.put("日在", 29);
    freq.put("乘三万", 56);
    freq.put("国·之", 33);
    freq.put("乘三三", 340);
    freq.put("俩临", 54);
    freq.put("日之 ", 13);
    freq.put("乘三专", 203);
    freq.put("俩中", 9);
    freq.put("乘三丘", 68);
    freq.put("乘三丙", 11);
    freq.put("俩丢", 28);
    freq.put("丢人", 32);
    freq.put("俩丙", 32);
    freq.put("俩丘", 27);
    freq.put("俩丛", 28);
    freq.put("乙丘丁", 20);
    freq.put("呦", 7);
    freq.put("俩专", 60);
    freq.put("俩且", 27);
    freq.put("大俘", 14);
    freq.put("俩三", 108);
    freq.put("╰", 48);
    freq.put("乘三临", 82);
    freq.put("〜 ", 26);
    freq.put("】丘", 24);
    freq.put("俩丁", 63);
    freq.put("乘三丹", 58);
    freq.put("乘三为", 17);
    freq.put("俩万", 16);
    freq.put("；专", 34);
    freq.put("在国", 25);
    freq.put("丢三万", 16);
    freq.put("；丘", 17);
    freq.put("丙的", 133);
    freq.put(" 的 ", 30);
    freq.put("；丁", 26);
    freq.put("；一", 13);
    freq.put("；万", 15);
    freq.put("丢乱", 30);
    freq.put("丢三丘", 11);
    freq.put("丁的！", 7);
    freq.put("丁的，", 50);
    freq.put("丢三专", 39);
    freq.put(" 嗅", 8);
    freq.put("丢乎", 7);
    freq.put("三亞之", 9);
    freq.put("丢么", 60);
    freq.put("万三日", 11);
    freq.put("俩仗", 32);
    freq.put("丢之", 328);
    freq.put("之俩俩", 9);
    freq.put("丢三丹", 10);
    freq.put("劈 ", 54);
    freq.put("丢乘", 52);
    freq.put("丢乙", 104);
    freq.put("俩人", 16);
    freq.put("临】 ", 11);
    freq.put("乘万丘", 8);
    freq.put("丢丢", 139);
    freq.put("；乘", 11);
    freq.put("专么？", 10);
    freq.put("丢临", 155);
    freq.put("专么！", 7);
    freq.put("丘之的", 42);
    freq.put("￣ ", 43);
    freq.put(" 喵", 9);
    freq.put("；之", 42);
    freq.put("专么，", 21);
    freq.put("丢丹", 54);
    freq.put("丢为", 12);
    freq.put("丘丙，", 9);
    freq.put("丹丢临", 7);
    freq.put("丢万", 111);
    freq.put("丢一", 25);
    freq.put("丢丁", 311);
    freq.put("大佐", 9);
    freq.put("丢丈", 53);
    freq.put("丢三", 394);
    freq.put("丢且", 55);
    freq.put("丢丐", 11);
    freq.put("丢丑", 46);
    freq.put("丢专", 236);
    freq.put("乘三人", 37);
    freq.put("丢丘", 89);
    freq.put("丢丙", 57);
    freq.put("乙乘的", 7);
    freq.put("丢丛", 433);
    freq.put("一三乘", 19);
    freq.put("一三乙", 10);
    freq.put("？之三", 7);
    freq.put("乘且乘", 13);
    freq.put("一三么", 15);
    freq.put(" 乘人", 8);
    freq.put("？之专", 11);
    freq.put("一三之", 114);
    freq.put("三在于", 7);
    freq.put("万华", 117);
    freq.put("乘且之", 44);
    freq.put("挞", 9);
    freq.put("且专么", 16);
    freq.put("咧", 20);
    freq.put("三（专", 8);
    freq.put("乱专是", 9);
    freq.put(" 丁华", 10);
    freq.put("之年，", 15);
    freq.put("三（三", 7);
    freq.put("？之为", 7);
    freq.put("丹仗三", 7);
    freq.put("一三丘", 21);
    freq.put("一三丙", 7);
    freq.put("一三丛", 18);
    freq.put("乘且专", 33);
    freq.put("三乎人", 17);
    freq.put(" 之乎", 12);
    freq.put("？之之", 9);
    freq.put("一三专", 92);
    freq.put("一三且", 14);
    freq.put("乘且万", 10);
    freq.put("一三三", 170);
    freq.put("乘且丁", 32);
    freq.put("乘且一", 8);
    freq.put("一三一", 9);
    freq.put("三傀", 15);
    freq.put("乘且三", 58);
    freq.put("一三万", 52);
    freq.put("一三丹", 37);
    freq.put("乘且临", 21);
    freq.put("中 ", 80);
    freq.put("丁临：", 15);
    freq.put("一三临", 34);
    freq.put("之之。", 151);
    freq.put("乘且丹", 13);
    freq.put("乎么乘", 35);
    freq.put("三（之", 7);
    freq.put(" 乘仗", 11);
    freq.put("专。乘", 17);
    freq.put("三在丛", 11);
    freq.put("三在丘", 8);
    freq.put("三在专", 50);
    freq.put("的丛，", 7);
    freq.put("丛乘专", 33);
    freq.put("三在且", 8);
    freq.put("一三仗", 11);
    freq.put("丛乘三", 26);
    freq.put(" 乘丹", 42);
    freq.put("三在三", 78);
    freq.put("的丛？", 12);
    freq.put("三在一", 12);
    freq.put(" 乘丰", 8);
    freq.put("三在万", 8);
    freq.put(" 国", 131);
    freq.put("专是 ", 40);
    freq.put(" 乘三", 259);
    freq.put("乘的万", 14);
    freq.put("且一专", 33);
    freq.put("乱丘之", 8);
    freq.put(" 乘丁", 114);
    freq.put(" 乘一", 19);
    freq.put(" 乘万", 36);
    freq.put("三在临", 23);
    freq.put("且一万", 7);
    freq.put(" 乘丙", 42);
    freq.put(" 乘丘", 46);
    freq.put("三乎么", 125);
    freq.put("´", 24);
    freq.put("且一丁", 7);
    freq.put("三乎之", 22);
    freq.put(" 乘专", 226);
    freq.put("专三俩", 15);
    freq.put(" 嗯。", 7);
    freq.put("。人三", 10);
    freq.put(" 乘且", 33);
    freq.put("么丹 ", 7);
    freq.put("么专。", 11);
    freq.put("三在乘", 12);
    freq.put("三在乙", 12);
    freq.put("乙丢。", 8);
    freq.put("三在之", 52);
    freq.put("三在么", 8);
    freq.put("丛乘之", 16);
    freq.put("三在乎", 12);
    freq.put("乱丘临", 11);
    freq.put("三大 ", 7);
    freq.put(" 乘乱", 11);
    freq.put("丁专国", 12);
    freq.put(" 乘之", 132);
    freq.put(" 乘么", 15);
    freq.put("三乎丘", 9);
    freq.put("三乎丙", 9);
    freq.put("韦", 10);
    freq.put("乱丘三", 7);
    freq.put("且一乙", 7);
    freq.put("三乎专", 29);
    freq.put(" 乘乙", 20);
    freq.put("三倪", 9);
    freq.put("三乎三", 24);
    freq.put("是万专", 24);
    freq.put("丛丢 ", 7);
    freq.put("且一之", 15);
    freq.put("三乎丁", 15);
    freq.put("三的 ", 106);
    freq.put("。丹专", 55);
    freq.put(" 坤", 22);
    freq.put(" 于华", 19);
    freq.put("专三乙", 105);
    freq.put("专三乘", 162);
    freq.put(" ω ", 7);
    freq.put("专三么", 72);
    freq.put("专三乎", 43);
    freq.put("专三乱", 33);
    freq.put("丁乱专", 19);
    freq.put("乎么丹", 42);
    freq.put(" 坏", 12);
    freq.put("！之专", 10);
    freq.put(" 年。", 7);
    freq.put("专三专", 1062);
    freq.put("专三丑", 15);
    freq.put("专三丐", 14);
    freq.put("专三且", 124);
    freq.put("专三丛", 142);
    freq.put(" 在", 199);
    freq.put("专三丘", 222);
    freq.put("临中丁", 29);
    freq.put("专三丁", 654);
    freq.put("专三一", 106);
    freq.put("专三万", 368);
    freq.put("乖", 104);
    freq.put("乱三 ", 16);
    freq.put("临中三", 11);
    freq.put("专三三", 1550);
    freq.put("专三丈", 25);
    freq.put("俩临之", 10);
    freq.put("专三丰", 11);
    freq.put("中三，", 11);
    freq.put("专三临", 339);
    freq.put("专三为", 64);
    freq.put("专三丹", 182);
    freq.put("三冲", 114);
    freq.put("、专", 147);
    freq.put("专三丢", 47);
    freq.put("且、", 11);
    freq.put("乱乙 ", 7);
    freq.put("专三中", 44);
    freq.put("之大专", 29);
    freq.put("专三仗", 36);
    freq.put("之仗 ", 59);
    freq.put("丛；", 11);
    freq.put("丛：", 43);
    freq.put("大 ", 39);
    freq.put("丛？", 293);
    freq.put(" 侏", 34);
    freq.put("之大丁", 21);
    freq.put("丛！", 83);
    freq.put("之大万", 37);
    freq.put("之大三", 54);
    freq.put("丛）", 8);
    freq.put("丛（", 16);
    freq.put("丁～", 10);
    freq.put("乘之在", 11);
    freq.put("之大临", 10);
    freq.put("之丙。", 8);
    freq.put("临万 ", 21);
    freq.put("临专大", 14);
    freq.put("丢临之", 16);
    freq.put("丁！", 169);
    freq.put("丢临临", 15);
    freq.put("之丁劈", 9);
    freq.put("乙且之", 12);
    freq.put("三亥乘", 9);
    freq.put("丁）", 62);
    freq.put("丁（", 49);
    freq.put("丁，", 1264);
    freq.put("且三，", 27);
    freq.put("乎且是", 18);
    freq.put("之大之", 32);
    freq.put("且专丁", 59);
    freq.put("一专大", 8);
    freq.put("丁？", 83);
    freq.put("万劈", 8);
    freq.put("之大乱", 8);
    freq.put("丛一专", 9);
    freq.put("、大", 10);
    freq.put("一日", 13);
    freq.put("专三人", 55);
    freq.put("，三是", 74);
    freq.put("丛一丁", 7);
    freq.put("丢临丁", 12);
    freq.put("临于之", 12);
    freq.put("专三亥", 12);
    freq.put(" 、之", 8);
    freq.put("是在专", 11);
    freq.put("丢临三", 15);
    freq.put("三？之", 7);
    freq.put("的之专", 172);
    freq.put("三仞", 21);
    freq.put("亥亥", 22);
    freq.put("在万临", 7);
    freq.put("的之丛", 15);
    freq.put("的之丘", 24);
    freq.put("且丙丁", 11);
    freq.put("的之万", 50);
    freq.put("？专", 66);
    freq.put("的之丁", 144);
    freq.put("中丁之", 12);
    freq.put(" 之丘", 92);
    freq.put("的之三", 197);
    freq.put("丛临，", 24);
    freq.put("　 ", 150);
    freq.put(" 之丙", 62);
    freq.put("三！ ", 61);
    freq.put("仗专是", 8);
    freq.put("的之丹", 14);
    freq.put("万三大", 16);
    freq.put(" （《", 12);
    freq.put("么之么", 8);
    freq.put("丛， ", 9);
    freq.put("中丛 ", 7);
    freq.put("临且是", 14);
    freq.put("人，乘", 21);
    freq.put("三丙的", 16);
    freq.put("···", 30);
    freq.put("么之丹", 11);
    freq.put("三亟", 46);
    freq.put("三亞", 30);
    freq.put("的之乘", 21);
    freq.put("的之乙", 32);
    freq.put("丁专 ", 292);
    freq.put("三之日", 18);
    freq.put("三于", 232);
    freq.put("中丁三", 19);
    freq.put("三亂", 8);
    freq.put("人，丹", 13);
    freq.put("的之之", 127);
    freq.put("的之么", 10);
    freq.put("三，大", 10);
    freq.put("人，万", 9);
    freq.put("三人", 681);
    freq.put("人，丁", 21);
    freq.put("中丁临", 35);
    freq.put("的之乱", 11);
    freq.put("么之专", 37);
    freq.put("人，三", 39);
    freq.put("专乱三", 39);
    freq.put("么之且", 7);
    freq.put("三亨", 26);
    freq.put("么之三", 85);
    freq.put(" 三，", 69);
    freq.put("在万之", 23);
    freq.put("人，专", 24);
    freq.put("亥仗", 11);
    freq.put("临日", 21);
    freq.put("三亥", 206);
    freq.put("人，丘", 7);
    freq.put("年之", 138);
    freq.put("三乙", 968);
    freq.put("傀", 129);
    freq.put("三乞", 45);
    freq.put("专丘俩", 10);
    freq.put("亥丢", 15);
    freq.put("三么", 543);
    freq.put("三之", 10059);
    freq.put("亥丹", 13);
    freq.put("乱丁 ", 19);
    freq.put("三乎", 319);
    freq.put("亥临", 19);
    freq.put(" 之中", 14);
    freq.put("乙之 ", 83);
    freq.put("乙临：", 7);
    freq.put("三乱", 296);
    freq.put("专乱万", 9);
    freq.put("亥万", 32);
    freq.put("的之人", 27);
    freq.put("三乩", 8);
    freq.put("乙临，", 14);
    freq.put("亥丙", 23);
    freq.put("亥丘", 19);
    freq.put("亥丛", 15);
    freq.put("丈丈的", 7);
    freq.put("丹之俘", 7);
    freq.put("亥专", 40);
    freq.put("乙临！", 7);
    freq.put("三丙", 569);
    freq.put("三丘", 2301);
    freq.put("三丛", 1069);
    freq.put("三丑", 124);
    freq.put("三丐", 76);
    freq.put("三专", 8546);
    freq.put("三丕", 10);
    freq.put("三且", 1155);
    freq.put("丙之，", 25);
    freq.put("三三", 13609);
    freq.put("三丈", 220);
    freq.put("专在专", 79);
    freq.put("三丁", 5655);
    freq.put("三一", 938);
    freq.put("之丐，", 9);
    freq.put("三万", 3256);
    freq.put("三丹", 1680);
    freq.put("丫专", 14);
    freq.put("三为", 433);
    freq.put("丘是专", 9);
    freq.put("亥之", 98);
    freq.put("丰三万", 7);
    freq.put("三丰", 129);
    freq.put("三临", 3068);
    freq.put("之！之", 10);
    freq.put("三丫", 21);
    freq.put("亥乙", 57);
    freq.put("亥乘", 13);
    freq.put("三丢", 401);
    freq.put("丘是三", 10);
    freq.put("圳三", 18);
    freq.put("三俘", 85);
    freq.put(" 　 ", 101);
    freq.put("大乱之", 7);
    freq.put("三一乘", 12);
    freq.put("三一乙", 26);
    freq.put("的。丹", 7);
    freq.put("丹之乱", 10);
    freq.put("三一之", 80);
    freq.put("专乱临", 11);
    freq.put("三一乎", 18);
    freq.put("。丹丁", 39);
    freq.put("的。三", 17);
    freq.put("华大万", 11);
    freq.put("专丘么", 14);
    freq.put("临，临", 37);
    freq.put("仗三之", 24);
    freq.put("丹之乎", 10);
    freq.put("专丘乎", 7);
    freq.put("三俩", 148);
    freq.put("丁乱之", 24);
    freq.put("耶", 40);
    freq.put("专丘乘", 21);
    freq.put("专丘乙", 21);
    freq.put("的。专", 10);
    freq.put("丹之乘", 34);
    freq.put("的。且", 8);
    freq.put("？三", 80);
    freq.put("华》 ", 10);
    freq.put("三一专", 243);
    freq.put("专丘丢", 13);
    freq.put("。』", 8);
    freq.put("亥俩", 15);
    freq.put("之么。", 28);
    freq.put("三一且", 10);
    freq.put("三一丛", 15);
    freq.put("三一丘", 17);
    freq.put("为丁", 133);
    freq.put("丹之中", 10);
    freq.put("三一丁", 64);
    freq.put("仕", 77);
    freq.put("三一万", 40);
    freq.put("三侏", 20);
    freq.put("专在三", 102);
    freq.put("专丘丹", 52);
    freq.put("三侃", 12);
    freq.put("三一三", 233);
    freq.put("三侄", 18);
    freq.put("仗三万", 11);
    freq.put("专丘丁", 114);
    freq.put("丁年的", 11);
    freq.put("丹之一", 26);
    freq.put("之丹是", 19);
    freq.put("丁么的", 11);
    freq.put("三一临", 79);
    freq.put("之么？", 26);
    freq.put("专丘丈", 8);
    freq.put("万乘乘", 10);
    freq.put("丹之三", 292);
    freq.put("三一丹", 11);
    freq.put("丢劈", 11);
    freq.put("三丢人", 7);
    freq.put("仗三三", 24);
    freq.put("乘专是", 35);
    freq.put("丹之专", 148);
    freq.put("专丘专", 158);
    freq.put("之么，", 34);
    freq.put("亥俘", 7);
    freq.put("三侮", 16);
    freq.put("专丘丘", 36);
    freq.put("之么！", 9);
    freq.put("丹之丙", 18);
    freq.put("专丘丛", 31);
    freq.put("三侥", 32);
    freq.put("临专的", 83);
    freq.put(" 之仗", 15);
    freq.put("临乙，", 31);
    freq.put("华的三", 7);
    freq.put("三佛", 108);
    freq.put("之人且", 7);
    freq.put("之人丛", 7);
    freq.put("？佛佛", 7);
    freq.put("之人丁", 31);
    freq.put("三万。", 63);
    freq.put("三万、", 14);
    freq.put("之人三", 70);
    freq.put("万丘的", 7);
    freq.put("乙三临", 26);
    freq.put("专丛、", 9);
    freq.put("之人临", 12);
    freq.put("专丛。", 22);
    freq.put("之人丹", 12);
    freq.put("丘日", 14);
    freq.put("丙三丛", 10);
    freq.put("乘丢之", 8);
    freq.put("专丘仗", 21);
    freq.put("丁仗的", 8);
    freq.put("专是万", 38);
    freq.put("丹的是", 7);
    freq.put("之人乙", 8);
    freq.put("年专", 113);
    freq.put("三亥丁", 10);
    freq.put("三伎", 8);
    freq.put("之人之", 38);
    freq.put("亨 ", 8);
    freq.put("大专三", 65);
    freq.put("仗三人", 7);
    freq.put("乘么 ", 8);
    freq.put("的在", 18);
    freq.put("的三大", 11);
    freq.put("丑丐的", 7);
    freq.put("俩劈", 12);
    freq.put("大华", 10);
    freq.put("乘丢丁", 8);
    freq.put("临，丙", 8);
    freq.put("丢万之", 17);
    freq.put("人。。", 11);
    freq.put("，乘乱", 10);
    freq.put("于 ", 132);
    freq.put("万佛", 9);
    freq.put("之中临", 9);
    freq.put("仗仗", 508);
    freq.put("年万", 74);
    freq.put("丘晗", 7);
    freq.put("＞", 24);
    freq.put("之中万", 10);
    freq.put("之中丁", 11);
    freq.put("是丁乎", 9);
    freq.put("三中之", 25);
    freq.put("是丁之", 55);
    freq.put("，乘乙", 14);
    freq.put("，乘乘", 15);
    freq.put("丹在丹", 40);
    freq.put("之中专", 14);
    freq.put("尴", 7);
    freq.put("̶", 22);
    freq.put("，乘之", 89);
    freq.put("》临丁", 11);
    freq.put("，乘么", 9);
    freq.put(" 于三", 7);
    freq.put("临专是", 31);
    freq.put("，乘临", 36);
    freq.put("嗅", 16);
    freq.put("万丹，", 14);
    freq.put("？一", 11);
    freq.put("，乘丹", 23);
    freq.put("是丁临", 55);
    freq.put("三中临", 8);
    freq.put("丢冲", 63);
    freq.put("的万万", 9);
    freq.put("之仗！", 17);
    freq.put("，乘且", 38);
    freq.put("，乘专", 160);
    freq.put("丘是", 69);
    freq.put("三中万", 14);
    freq.put("亥乙三", 11);
    freq.put("兢丘", 7);
    freq.put("专】", 150);
    freq.put("专【", 10);
    freq.put("，乘丛", 11);
    freq.put("之仗，", 33);
    freq.put("，乘丙", 7);
    freq.put("，乘丘", 8);
    freq.put("，乘万", 29);
    freq.put("专《", 25);
    freq.put("三中专", 19);
    freq.put(" 国万", 46);
    freq.put("三专是", 122);
    freq.put("乙丹 ", 8);
    freq.put("专」", 25);
    freq.put("专「", 19);
    freq.put("专。", 732);
    freq.put("专、", 149);
    freq.put("专　", 10);
    freq.put("是丁丛", 10);
    freq.put("三乘 ", 71);
    freq.put("之仗？", 21);
    freq.put("是丁丘", 12);
    freq.put("丁之；", 8);
    freq.put("万专，", 61);
    freq.put(" ≧▽", 9);
    freq.put("丁之？", 18);
    freq.put("之一大", 8);
    freq.put("之乘 ", 45);
    freq.put("三之机", 50);
    freq.put("丹三是", 50);
    freq.put("万俘", 25);
    freq.put("三俩的", 7);
    freq.put("临月", 7);
    freq.put("丁之，", 266);
    freq.put("丁之！", 40);
    freq.put("丘丹，", 18);
    freq.put("乙丢之", 13);
    freq.put("临机", 61);
    freq.put("且， ", 7);
    freq.put("专三大", 62);
    freq.put("，丹在", 12);
    freq.put("万俩", 43);
    freq.put("··", 42);
    freq.put("乓", 36);
    freq.put("三且国", 10);
    freq.put("佛的", 10);
    freq.put("，俩", 40);
    freq.put("是丁人", 19);
    freq.put("的年临", 8);
    freq.put("丘之是", 10);
    freq.put("万国专", 12);
    freq.put("万侥", 10);
    freq.put("的俘三", 7);
    freq.put("中丹丁", 12);
    freq.put("丛的是", 7);
    freq.put("三】 ", 27);
    freq.put("三且在", 10);
    freq.put("之华三", 20);
    freq.put("万乙", 210);
    freq.put("万乘", 216);
    freq.put(" 丁乱", 23);
    freq.put("么专临", 19);
    freq.put("丹丁人", 8);
    freq.put("万乎", 71);
    freq.put("万之", 2042);
    freq.put("在日三", 13);
    freq.put("万么", 118);
    freq.put("么专丁", 22);
    freq.put("么专万", 11);
    freq.put("万乱", 113);
    freq.put("且乙之", 13);
    freq.put(" 丁么", 44);
    freq.put("丙三乙", 11);
    freq.put("氪", 23);
    freq.put("之机 ", 18);
    freq.put(" 丁乎", 33);
    freq.put("么专专", 55);
    freq.put("华三临", 21);
    freq.put("丘丁 ", 88);
    freq.put(" 丁乙", 66);
    freq.put("之华临", 17);
    freq.put(" 丁丢", 27);
    freq.put("あ", 19);
    freq.put("万专", 1565);
    freq.put("之华之", 16);
    freq.put("万丑", 33);
    freq.put("万丐", 25);
    freq.put("万丛", 224);
    freq.put("万丙", 154);
    freq.put("万丘", 319);
    freq.put("万万", 509);
    freq.put("之： ", 79);
    freq.put("三专月", 7);
    freq.put(" 丁临", 214);
    freq.put("且乙丹", 12);
    freq.put("之华乘", 12);
    freq.put("万一", 122);
    freq.put(" 丁丹", 58);
    freq.put("且且 ", 11);
    freq.put("丘，乘", 27);
    freq.put("万三", 3138);
    freq.put("万丈", 45);
    freq.put("吱吱", 8);
    freq.put("三专机", 13);
    freq.put("万临", 721);
    freq.put("且乙三", 10);
    freq.put("万丰", 23);
    freq.put(" 丁丈", 19);
    freq.put(" 丁三", 426);
    freq.put("么专么", 14);
    freq.put("万为", 40);
    freq.put("嗯", 67);
    freq.put("丘机", 36);
    freq.put(" 丁丑", 14);
    freq.put(" 丁专", 274);
    freq.put(" 丁且", 36);
    freq.put("万丢", 77);
    freq.put(" 丁丘", 65);
    freq.put(" 丁丙", 49);
    freq.put("万中", 90);
    freq.put(" 丁丛", 94);
    freq.put("万丫", 8);
    freq.put("之华于", 13);
    freq.put("之丈丹", 7);
    freq.put("临丙之", 20);
    freq.put(" 丙 ", 11);
    freq.put("万仞", 8);
    freq.put("咀三", 7);
    freq.put("三乎丛", 7);
    freq.put("专丘之", 122);
    freq.put("三之是", 157);
    freq.put("之丈丘", 13);
    freq.put("之的", 1311);
    freq.put("坤的", 26);
    freq.put("之丈专", 22);
    freq.put("是乙专", 12);
    freq.put("之丈丈", 7);
    freq.put("临是", 90);
    freq.put("是乙三", 12);
    freq.put(" 丁仗", 22);
    freq.put("丕三", 14);
    freq.put("是乙丁", 9);
    freq.put("临丙三", 21);
    freq.put("》专专", 10);
    freq.put("万亟", 11);
    freq.put("临丙丁", 16);
    freq.put(" 之人", 21);
    freq.put("三在华", 9);
    freq.put("临丙丙", 7);
    freq.put("万于", 90);
    freq.put(" 丁人", 40);
    freq.put("临丙专", 13);
    freq.put("国且之", 8);
    freq.put("乎三，", 7);
    freq.put("三为，", 11);
    freq.put("万人", 148);
    freq.put("万亥", 13);
    freq.put("之丈之", 12);
    freq.put("是乙之", 14);
    freq.put("么专仗", 9);
    freq.put("临临，", 35);
    freq.put("临丙临", 20);
    freq.put("华三】", 7);
    freq.put("之？丹", 7);
    freq.put("乙临 ", 42);
    freq.put("万乙 ", 9);
    freq.put("丛专万", 16);
    freq.put("专俩俩", 11);
    freq.put(" ？ ", 15);
    freq.put("乘三仗", 18);
    freq.put("日之", 92);
    freq.put("丢丙，", 8);
    freq.put("之？三", 9);
    freq.put("临丁 ", 118);
    freq.put("日乘", 43);
    freq.put("之？丁", 8);
    freq.put(" 国之", 17);
    freq.put("丼", 15);
    freq.put("万临 ", 42);
    freq.put(" ╭ ", 9);
    freq.put("年丁专", 7);
    freq.put("丛专三", 110);
    freq.put("大国", 14);
    freq.put("丘乙 ", 20);
    freq.put("日丹", 49);
    freq.put("之万么", 18);
    freq.put("日临", 26);
    freq.put("年丁三", 9);
    freq.put("的丁人", 31);
    freq.put("丢专，", 14);
    freq.put("日三", 431);
    freq.put("乘三在", 12);
    freq.put("日万", 31);
    freq.put("日丁", 83);
    freq.put("丹丛 ", 15);
    freq.put("日丙", 7);
    freq.put("日丘", 17);
    freq.put("日丛", 11);
    freq.put("丘丘的", 27);
    freq.put("刨。", 8);
    freq.put("日且", 20);
    freq.put("华人三", 13);
    freq.put("日专", 170);
    freq.put("丢坤", 51);
    freq.put("咀", 49);
    freq.put("之：专", 12);
    freq.put("丁乘的", 27);
    freq.put("国三临", 21);
    freq.put("乙： ", 22);
    freq.put("在俩", 10);
    freq.put("大三乘", 7);
    freq.put("国三丘", 21);
    freq.put("在俘", 8);
    freq.put("佛佛佛", 289);
    freq.put("的丁乎", 8);
    freq.put("的丁么", 16);
    freq.put("的丁之", 134);
    freq.put("国三三", 136);
    freq.put("、三", 245);
    freq.put("丙乘三", 12);
    freq.put("丛专丛", 11);
    freq.put("国三丁", 42);
    freq.put("丁的是", 36);
    freq.put("丙乘丁", 7);
    freq.put("的丁乘", 15);
    freq.put("的丁乙", 18);
    freq.put("国三万", 46);
    freq.put("）；", 16);
    freq.put("三丛的", 61);
    freq.put("丢在", 9);
    freq.put("的丁临", 60);
    freq.put("临丛的", 12);
    freq.put("），", 37);
    freq.put("的丁丹", 14);
    freq.put("国三乘", 7);
    freq.put("的丁万", 34);
    freq.put("的丁一", 11);
    freq.put("乘丛？", 8);
    freq.put("丙丁丘", 12);
    freq.put("鑫", 8);
    freq.put("的丁丈", 7);
    freq.put("的丁三", 201);
    freq.put("乙万：", 10);
    freq.put("国三么", 9);
    freq.put("国三之", 122);
    freq.put("之万丢", 9);
    freq.put("乘丛，", 8);
    freq.put("的丁专", 162);
    freq.put("的丁丘", 25);
    freq.put("的丁丙", 26);
    freq.put("的丁丛", 76);
    freq.put("丙三的", 12);
    freq.put("三乙万", 16);
    freq.put("么乘。", 7);
    freq.put("乘。", 132);
    freq.put("丹丘专", 23);
    freq.put("乘、", 32);
    freq.put("一，", 27);
    freq.put("万三机", 7);
    freq.put("么临？", 10);
    freq.put("丹丘三", 54);
    freq.put("专万仗", 10);
    freq.put("一：", 8);
    freq.put("乘】", 10);
    freq.put("中之万", 7);
    freq.put("在乘", 78);
    freq.put("在乙", 67);
    freq.put("丁日", 62);
    freq.put("丑三之", 12);
    freq.put("丑的丁", 9);
    freq.put("丁俩仗", 9);
    freq.put("么。 ", 42);
    freq.put("丹丘临", 66);
    freq.put("丑的三", 8);
    freq.put("在之", 354);
    freq.put("在么", 45);
    freq.put("在乎", 49);
    freq.put("丑的专", 9);
    freq.put("中之丘", 7);
    freq.put("丹丘乘", 10);
    freq.put("在丹", 249);
    freq.put("丛人三", 8);
    freq.put("在临", 109);
    freq.put("丹丘之", 34);
    freq.put("、丢", 15);
    freq.put("在中", 73);
    freq.put("在丢", 20);
    freq.put("丑三临", 11);
    freq.put("在丛", 62);
    freq.put("在丘", 49);
    freq.put("在丙", 30);
    freq.put("丑三三", 25);
    freq.put("　－－", 36);
    freq.put("在丐", 7);
    freq.put("丙专 ", 65);
    freq.put("丑三丁", 16);
    freq.put("在且", 53);
    freq.put("在丈", 7);
    freq.put("在三", 526);
    freq.put("在一", 76);
    freq.put("在丁", 253);
    freq.put("在万", 86);
    freq.put("丑三专", 12);
    freq.put(" 。 ", 66);
    freq.put("槿冲", 11);
    freq.put("丙，乘", 9);
    freq.put("专万人", 17);
    freq.put("丙，之", 26);
    freq.put(" 的临", 12);
    freq.put("（之）", 9);
    freq.put("丁俩之", 9);
    freq.put("专临大", 16);
    freq.put("么三，", 21);
    freq.put("乘。 ", 36);
    freq.put("丹丙 ", 7);
    freq.put("在人", 11);
    freq.put("丙，且", 20);
    freq.put("乙三、", 8);
    freq.put("丙，专", 23);
    freq.put("～～", 28);
    freq.put("乙三。", 11);
    freq.put("且专的", 17);
    freq.put("丢乙三", 8);
    freq.put("临专且", 28);
    freq.put("丛专么", 12);
    freq.put("丙，万", 8);
    freq.put("大坤", 12);
    freq.put("之一年", 12);
    freq.put("丙，丁", 11);
    freq.put("丙，三", 24);
    freq.put("丙，临", 7);
    freq.put(" 的三", 59);
    freq.put("丁俩且", 7);
    freq.put("三：临", 13);
    freq.put("拼", 65);
    freq.put("丢仗 ", 8);
    freq.put("在于", 29);
    freq.put(" 万，", 35);
    freq.put("的乱临", 13);
    freq.put("丈丛", 30);
    freq.put("丈丘", 127);
    freq.put("丈丙", 30);
    freq.put("丈专", 223);
    freq.put("丈丑", 29);
    freq.put("丈且", 20);
    freq.put("冲的", 24);
    freq.put("国的之", 11);
    freq.put("丈丈", 58);
    freq.put(" 乱", 267);
    freq.put("劈临", 15);
    freq.put("乖的", 7);
    freq.put("丈一", 9);
    freq.put("丈丁", 157);
    freq.put("丈万", 43);
    freq.put("丈丹", 84);
    freq.put("丁乘人", 9);
    freq.put(" 之", 3596);
    freq.put(" 么", 243);
    freq.put(" 乎", 162);
    freq.put("丈临", 100);
    freq.put("丐。", 27);
    freq.put("乘，万", 7);
    freq.put("的乱丁", 8);
    freq.put("丈丢", 45);
    freq.put(" 乘", 1368);
    freq.put(" 乙", 644);
    freq.put(" 乞", 25);
    freq.put("的乱三", 14);
    freq.put(" 丢", 544);
    freq.put("丈乘", 13);
    freq.put("之！ ", 85);
    freq.put(" 並", 24);
    freq.put("丁乘仗", 7);
    freq.put(" 丫", 26);
    freq.put(" 中", 513);
    freq.put("丈之", 177);
    freq.put("丈么", 33);
    freq.put("国的三", 30);
    freq.put("临之么", 41);
    freq.put(" 临", 1919);
    freq.put(" 为", 165);
    freq.put("丢之 ", 35);
    freq.put(" 丹", 2722);
    freq.put("乘之仗", 7);
    freq.put("丁丘，", 53);
    freq.put(" 一", 357);
    freq.put(" 丁", 2807);
    freq.put(" 万", 1303);
    freq.put("丹专。", 24);
    freq.put(" 丈", 193);
    freq.put("丈乱", 17);
    freq.put("丁乙 ", 71);
    freq.put(" 专", 4068);
    freq.put(" 丐", 69);
    freq.put(" 丑", 71);
    freq.put(" 且", 892);
    freq.put(" 丕", 8);
    freq.put(" 乩 ", 10);
    freq.put(" 丛", 638);
    freq.put(" 丘", 683);
    freq.put(" 丙", 401);
    freq.put("专万的", 65);
    freq.put("丁乘专", 88);
    freq.put("乘之三", 200);
    freq.put("ㄅ", 11);
    freq.put("丁乘且", 17);
    freq.put("。且丁", 15);
    freq.put("丁乘丛", 7);
    freq.put("丁乘丘", 23);
    freq.put("丁乘丙", 7);
    freq.put("乘之万", 37);
    freq.put("华临三", 50);
    freq.put("么丑三", 7);
    freq.put("丁乘一", 7);
    freq.put("丁乘丁", 74);
    freq.put("丈于", 9);
    freq.put("丁乘万", 23);
    freq.put("华临丁", 18);
    freq.put("乘之专", 99);
    freq.put("丁乘三", 101);
    freq.put("乘之且", 22);
    freq.put("丈人", 21);
    freq.put("之怜的", 9);
    freq.put(" 为之", 28);
    freq.put("丁乘临", 28);
    freq.put("万：三", 9);
    freq.put("乘之丢", 13);
    freq.put("丁乘丹", 22);
    freq.put("　　乱", 11);
    freq.put("丁乘丢", 9);
    freq.put("乘之丹", 25);
    freq.put(" 仗", 203);
    freq.put("临之乙", 49);
    freq.put(" 仞", 48);
    freq.put("万：专", 9);
    freq.put("乘之临", 71);
    freq.put("华临乘", 8);
    freq.put("丁且的", 19);
    freq.put(" 亥", 69);
    freq.put("丁乘乘", 14);
    freq.put("丁乘乙", 12);
    freq.put("丈仗", 16);
    freq.put(" 亳", 9);
    freq.put("华临之", 28);
    freq.put("的仗！", 9);
    freq.put("国丁年", 8);
    freq.put(" 人", 250);
    freq.put("丁乘之", 90);
    freq.put(" 亂", 12);
    freq.put("丛临 ", 39);
    freq.put("丁丁是", 33);
    freq.put(" 于", 88);
    freq.put("丁是", 360);
    freq.put("丐：", 7);
    freq.put("且三是", 50);
    freq.put(" 亞", 21);
    freq.put(" 亟", 43);
    freq.put("冲且", 9);
    freq.put("耶稣", 8);
    freq.put("万的人", 11);
    freq.put("为大", 11);
    freq.put("大丐丢", 7);
    freq.put("乱专，", 15);
    freq.put("一临的", 33);
    freq.put(" 嗯嗯", 7);
    freq.put("大，之", 9);
    freq.put("亥专专", 8);
    freq.put("亂的 ", 9);
    freq.put("乘， ", 10);
    freq.put("，于华", 16);
    freq.put(" 佛", 212);
    freq.put("亥专三", 8);
    freq.put("僅", 18);
    freq.put("乘，丹", 24);
    freq.put("啧 ", 8);
    freq.put("三且华", 16);
    freq.put("大，三", 9);
    freq.put("乘，临", 11);
    freq.put("临之 ", 188);
    freq.put("为乎么", 162);
    freq.put(" 伎", 9);
    freq.put("的么 ", 7);
    freq.put("万专 ", 89);
    freq.put("大，专", 7);
    freq.put("专丹在", 7);
    freq.put("万的临", 18);
    freq.put("丰之万", 11);
    freq.put("临之万", 87);
    freq.put("万的丹", 13);
    freq.put(" 俩", 95);
    freq.put("≦ ", 16);
    freq.put("么么 ", 11);
    freq.put("三： ", 53);
    freq.put("万的专", 66);
    freq.put("之是，", 12);
    freq.put("专冲之", 13);
    freq.put("万的丘", 12);
    freq.put(" 丁之", 390);
    freq.put("万的丛", 14);
    freq.put("临中国", 24);
    freq.put("专三国", 53);
    freq.put("万的一", 10);
    freq.put("万的丁", 39);
    freq.put("之是：", 7);
    freq.put("万的万", 14);
    freq.put("乙。 ", 35);
    freq.put("万的三", 73);
    freq.put(" 俘", 54);
    freq.put("冲临", 47);
    freq.put(" 侥", 15);
    freq.put("丁月", 24);
    freq.put("丑专丁", 8);
    freq.put("๑", 13);
    freq.put(" 侃", 12);
    freq.put("临。专", 23);
    freq.put("是在三", 16);
    freq.put(" 侄", 12);
    freq.put("丁： ", 60);
    freq.put("乎的", 48);
    freq.put("是在丁", 7);
    freq.put("丘，乱", 8);
    freq.put("丁机", 35);
    freq.put("丑专三", 10);
    freq.put("丁丁机", 9);
    freq.put("华的之", 7);
    freq.put("专乱丘", 9);
    freq.put("三乙丁", 81);
    freq.put("年乘", 14);
    freq.put("年乙", 7);
    freq.put("专乱专", 24);
    freq.put("三乙三", 130);
    freq.put("三乙且", 11);
    freq.put(" 丛 ", 25);
    freq.put("的万乱", 15);
    freq.put("的人临", 11);
    freq.put("三乙专", 96);
    freq.put("的人丹", 12);
    freq.put("是三之", 144);
    freq.put("专乱丁", 14);
    freq.put("：", 2379);
    freq.put("三乙丙", 19);
    freq.put("三乙丘", 42);
    freq.put("三乙丛", 21);
    freq.put("的人丁", 18);
    freq.put("的人万", 11);
    freq.put("三乙丢", 18);
    freq.put("的人三", 71);
    freq.put("的万之", 60);
    freq.put("《华乘", 7);
    freq.put("一专仗", 11);
    freq.put("万乘之", 29);
    freq.put("三乙临", 53);
    freq.put("的人专", 27);
    freq.put("丁仗，", 24);
    freq.put("，之机", 13);
    freq.put("的人且", 9);
    freq.put("丰之三", 9);
    freq.put("的万乙", 8);
    freq.put("三乙丹", 19);
    freq.put("丈仗专", 7);
    freq.put("丁仗！", 16);
    freq.put("一专人", 91);
    freq.put("之乱丁", 22);
    freq.put("专乱乙", 10);
    freq.put("专乱乘", 7);
    freq.put("年丛", 29);
    freq.put("年丘", 20);
    freq.put("年且", 40);
    freq.put("三乙么", 8);
    freq.put("三乙之", 77);
    freq.put("专乱之", 37);
    freq.put("丙乙 ", 15);
    freq.put("的万临", 23);
    freq.put("年三", 221);
    freq.put("坏之", 37);
    freq.put("三乙乙", 45);
    freq.put("万乘丹", 16);
    freq.put("年一", 28);
    freq.put("年丁", 62);
    freq.put("的万丁", 26);
    freq.put("万乘丁", 13);
    freq.put("年丹", 32);
    freq.put("的人之", 26);
    freq.put("的万三", 47);
    freq.put("丘乱的", 10);
    freq.put("万乘三", 36);
    freq.put("万乘且", 10);
    freq.put("的万专", 33);
    freq.put("年中", 11);
    freq.put("三乙乱", 8);
    freq.put("万乘专", 27);
    freq.put("的人乘", 7);
    freq.put("的万丘", 10);
    freq.put("万乘丙", 7);
    freq.put("「专」", 8);
    freq.put("丙？", 9);
    freq.put("、么", 15);
    freq.put("、之", 128);
    freq.put("一专乱", 8);
    freq.put("、乙", 46);
    freq.put("、乘", 31);
    freq.put("一专乘", 27);
    freq.put("一专乙", 29);
    freq.put("丁临。", 32);
    freq.put("丢乙乙", 7);
    freq.put("丛大三", 15);
    freq.put("、乱", 10);
    freq.put("一专之", 147);
    freq.put("一专么", 8);
    freq.put("丢乙之", 11);
    freq.put("之之年", 36);
    freq.put("国万三", 40);
    freq.put("、丁", 127);
    freq.put("、一", 12);
    freq.put("一专丹", 17);
    freq.put("、万", 52);
    freq.put("镉", 9);
    freq.put("、丈", 11);
    freq.put("么临，", 15);
    freq.put("中丘专", 7);
    freq.put("一专临", 49);
    freq.put("冲乙", 24);
    freq.put("、丑", 8);
    freq.put("为国", 11);
    freq.put("三乙仗", 13);
    freq.put("、且", 12);
    freq.put("一专中", 8);
    freq.put("一专丢", 13);
    freq.put("、丘", 52);
    freq.put("、丛", 36);
    freq.put("一专丛", 22);
    freq.put("一专丘", 27);
    freq.put("一专丙", 18);
    freq.put("年人", 14);
    freq.put("乘之一", 30);
    freq.put("一专专", 164);
    freq.put("丁年，", 9);
    freq.put("、中", 15);
    freq.put("一专且", 14);
    freq.put("一专三", 219);
    freq.put("三，冲", 7);
    freq.put("、临", 91);
    freq.put("三是在", 19);
    freq.put("、丹", 76);
    freq.put("一专一", 7);
    freq.put("一专丁", 107);
    freq.put("之么的", 19);
    freq.put("一专万", 33);
    freq.put(" 、丘", 7);
    freq.put("之。在", 7);
    freq.put("为在", 7);
    freq.put("三丘。", 52);
    freq.put(" 丢之", 18);
    freq.put("，丁人", 16);
    freq.put("坏临", 8);
    freq.put(" 丢乙", 13);
    freq.put("，之是", 113);
    freq.put(" 가가", 58);
    freq.put("坏三", 27);
    freq.put("、俩", 8);
    freq.put("么么临", 37);
    freq.put("专临三", 312);
    freq.put("坏丁", 10);
    freq.put("乙专人", 7);
    freq.put("丁丐三", 9);
    freq.put("乙临的", 25);
    freq.put("冲之", 139);
    freq.put("坏专", 8);
    freq.put(" 丢万", 7);
    freq.put(" 丢丁", 21);
    freq.put("专万丘", 25);
    freq.put("乙专万", 21);
    freq.put(" 丢三", 19);
    freq.put("是万于", 7);
    freq.put(" 丢丑", 32);
    freq.put(" 丢专", 14);
    freq.put("人专在", 9);
    freq.put(" 丢丛", 295);
    freq.put("月丙 ", 8);
    freq.put("临的是", 11);
    freq.put(" 丢丢", 24);
    freq.put("专！！", 25);
    freq.put(" 丢临", 9);
    freq.put("乙专丘", 18);
    freq.put("乎之临", 7);
    freq.put("一年三", 11);
    freq.put("一三大", 9);
    freq.put("乙专三", 66);
    freq.put("丹乘丛", 8);
    freq.put("专乘在", 7);
    freq.put("乙专丁", 37);
    freq.put("丁是之", 50);
    freq.put("专国专", 16);
    freq.put("，丁丢", 11);
    freq.put("丁是么", 13);
    freq.put("乙专丛", 12);
    freq.put("乙专专", 75);
    freq.put("专丁在", 10);
    freq.put("专丈三", 10);
    freq.put("，丁丹", 33);
    freq.put("是万之", 17);
    freq.put("，丁临", 59);
    freq.put("丁是乘", 7);
    freq.put("乎之丁", 12);
    freq.put("，丁三", 196);
    freq.put("丛临的", 24);
    freq.put("乎之三", 17);
    freq.put("，丁万", 30);
    freq.put("，丁一", 8);
    freq.put("，丁丁", 129);
    freq.put("乙专丹", 18);
    freq.put("乎之专", 12);
    freq.put("，丁丘", 42);
    freq.put("，丁丙", 13);
    freq.put("，丁丛", 60);
    freq.put("，丁且", 24);
    freq.put("人", 4229);
    freq.put("丘　", 11);
    freq.put("，丁专", 151);
    freq.put("丁是万", 8);
    freq.put("日，在", 8);
    freq.put("丘、", 39);
    freq.put("乎么 ", 45);
    freq.put("丁是丁", 36);
    freq.put("人，且", 33);
    freq.put("三丙，", 18);
    freq.put("于临专", 7);
    freq.put("丁是三", 58);
    freq.put("于临三", 10);
    freq.put("乙专乙", 8);
    freq.put("乙专乘", 11);
    freq.put("丁是专", 31);
    freq.put("丹乘且", 22);
    freq.put("人大丁", 7);
    freq.put("是万万", 10);
    freq.put("丁是丛", 9);
    freq.put("，丁乱", 13);
    freq.put("丁是丘", 16);
    freq.put("三专》", 31);
    freq.put("，丁乎", 24);
    freq.put("，丁么", 39);
    freq.put("丁是丢", 7);
    freq.put("，丁之", 179);
    freq.put("丁丹的", 45);
    freq.put("乎之之", 11);
    freq.put("丁是临", 11);
    freq.put("，丁乘", 38);
    freq.put("，丁乙", 25);
    freq.put("专么的", 10);
    freq.put(" 三的", 25);
    freq.put("丁是丹", 19);
    freq.put(" 丢人", 7);
    freq.put("三，华", 10);
    freq.put("伎", 42);
    freq.put("临冲专", 8);
    freq.put("〜", 71);
    freq.put("之！", 336);
    freq.put("且丘临", 15);
    freq.put("是三专", 87);
    freq.put("之）", 34);
    freq.put("之（", 58);
    freq.put("么么丁", 25);
    freq.put("之，", 2371);
    freq.put("日三临", 16);
    freq.put("之；", 71);
    freq.put("专专丐", 9);
    freq.put("之？", 175);
    freq.put("丁中三", 13);
    freq.put("临冲之", 9);
    freq.put("丢三三", 50);
    freq.put("；之之", 9);
    freq.put("丁中丁", 8);
    freq.put("人万临", 8);
    freq.put("仗劈", 8);
    freq.put("丘的乘", 7);
    freq.put("么丘 ", 8);
    freq.put("丘： ", 12);
    freq.put("专专专", 1115);
    freq.put("万三华", 25);
    freq.put("乘是丹", 11);
    freq.put("之专国", 14);
    freq.put("日专专", 12);
    freq.put(" 之怜", 7);
    freq.put("日专丁", 8);
    freq.put("乙专临", 42);
    freq.put("之～", 13);
    freq.put("日专三", 27);
    freq.put("临临的", 57);
    freq.put("乙专之", 98);
    freq.put("专丹之", 131);
    freq.put("专丹乎", 7);
    freq.put("乎么。", 14);
    freq.put("在临专", 18);
    freq.put("丹乘临", 25);
    freq.put("专丹乙", 23);
    freq.put("三丛人", 9);
    freq.put("于专之", 26);
    freq.put("坤三三", 7);
    freq.put("丁是一", 12);
    freq.put("冲", 1029);
    freq.put("丁：丁", 20);
    freq.put("乱，丁", 8);
    freq.put("专丹丁", 76);
    freq.put("丢大", 11);
    freq.put("专丹万", 31);
    freq.put("专丹三", 216);
    freq.put("专丹专", 154);
    freq.put("丁】 ", 30);
    freq.put("专丹且", 36);
    freq.put("专丹丛", 32);
    freq.put("专丹丙", 10);
    freq.put("专丹丘", 29);
    freq.put("于专临", 7);
    freq.put("于专三", 34);
    freq.put("是三临", 48);
    freq.put("坤三之", 16);
    freq.put("于专丁", 13);
    freq.put("，之日", 10);
    freq.put("大万之", 27);
    freq.put("丁日丁", 7);
    freq.put("专丹临", 59);
    freq.put("丁日三", 17);
    freq.put("是万三", 50);
    freq.put("专丹丹", 53);
    freq.put("于专专", 19);
    freq.put("乘丁乘", 16);
    freq.put("乘丁乙", 23);
    freq.put("人万专", 17);
    freq.put("?🙇", 7);
    freq.put("三；之", 9);
    freq.put(" 人 ", 14);
    freq.put("（《", 13);
    freq.put(" 且华", 10);
    freq.put("乘丁之", 75);
    freq.put("丘丹的", 16);
    freq.put("三俩，", 7);
    freq.put("丁之的", 133);
    freq.put("是万丁", 11);
    freq.put("是丁乱", 7);
    freq.put("伎的", 7);
    freq.put("丘丛丁", 17);
    freq.put("临。且", 16);
    freq.put("专的丛", 20);
    freq.put("（三之", 9);
    freq.put("乘丁丘", 20);
    freq.put("乘丁丙", 18);
    freq.put("乘丁丛", 22);
    freq.put("中之三", 42);
    freq.put("三；三", 10);
    freq.put("乘丁专", 69);
    freq.put("乘丁且", 11);
    freq.put("大专 ", 39);
    freq.put("佛！", 17);
    freq.put("乘丁丁", 97);
    freq.put("的？ ", 16);
    freq.put("之三 ", 420);
    freq.put("佛，", 42);
    freq.put("乘丁丹", 28);
    freq.put("（三专", 20);
    freq.put("（三且", 10);
    freq.put("乘丁临", 81);
    freq.put("?😭", 15);
    freq.put("丘，专", 64);
    freq.put("三国的", 21);
    freq.put("是万临", 9);
    freq.put("（三三", 17);
    freq.put("临丙丘", 7);
    freq.put("＃", 10);
    freq.put("么么乘", 10);
    freq.put("万人三", 31);
    freq.put("侥 ", 16);
    freq.put("万人丁", 8);
    freq.put("大大", 15);
    freq.put("华专丹", 10);
    freq.put("乱的专", 11);
    freq.put("一之临", 21);
    freq.put("年万之", 11);
    freq.put("一之丹", 19);
    freq.put("华专临", 18);
    freq.put("万人专", 21);
    freq.put("华专三", 57);
    freq.put("一之丁", 80);
    freq.put("一之万", 32);
    freq.put("华专丁", 28);
    freq.put("专为 ", 15);
    freq.put("一之三", 126);
    freq.put("华专万", 7);
    freq.put("一之专", 55);
    freq.put("丢丑专", 7);
    freq.put("一之且", 9);
    freq.put("一之丛", 7);
    freq.put("一之丘", 13);
    freq.put("一之丙", 8);
    freq.put("么之临", 25);
    freq.put("乙》", 12);
    freq.put("万丹的", 20);
    freq.put("万人之", 22);
    freq.put("乙、", 37);
    freq.put("乙　", 7);
    freq.put("乙。", 152);
    freq.put("乱的之", 10);
    freq.put("铊中丹", 12);
    freq.put("万人乙", 7);
    freq.put("乙】", 14);
    freq.put("且是 ", 37);
    freq.put("年万三", 15);
    freq.put("乘丁人", 8);
    freq.put("华专之", 51);
    freq.put("一之之", 52);
    freq.put("一之乎", 9);
    freq.put("一之乘", 15);
    freq.put("一之乙", 15);
    freq.put("在丹丁", 14);
    freq.put("丘乘临", 7);
    freq.put("在丹三", 20);
    freq.put("仗？丁", 7);
    freq.put("【 ", 47);
    freq.put("乘）", 9);
    freq.put("仗？专", 13);
    freq.put("丘乘专", 27);
    freq.put("丘乘且", 7);
    freq.put("俩专专", 10);
    freq.put("专丘且", 40);
    freq.put("丘乘丘", 9);
    freq.put("临冲丁", 7);
    freq.put("丹佛", 18);
    freq.put("仗？丹", 7);
    freq.put("丢丛，", 15);
    freq.put("丘乘三", 34);
    freq.put("乎丈", 10);
    freq.put("且专，", 25);
    freq.put(" 之！", 7);
    freq.put("仗？之", 9);
    freq.put(" ！！", 16);
    freq.put("三人在", 13);
    freq.put("在丹之", 34);
    freq.put(" 中丁", 29);
    freq.put(" 之，", 33);
    freq.put(" 之：", 12);
    freq.put(" 么 ", 16);
    freq.put(" 丹在", 97);
    freq.put("丘中三", 8);
    freq.put("叶三", 11);
    freq.put("之国国", 15);
    freq.put(" ﹏ ", 9);
    freq.put("中国丛", 57);
    freq.put("丘丁乘", 10);
    freq.put(" 万的", 22);
    freq.put("叶专", 14);
    freq.put("临大的", 13);
    freq.put("三，是", 24);
    freq.put("丘乘之", 21);
    freq.put("临丁一", 14);
    freq.put("临丁丁", 139);
    freq.put("丹俩", 37);
    freq.put("一的", 17);
    freq.put("丙三，", 20);
    freq.put("丐，丹", 7);
    freq.put("丢。 ", 16);
    freq.put("人三 ", 28);
    freq.put("丘于华", 7);
    freq.put("乎且且", 7);
    freq.put("之乙：", 18);
    freq.put("兢，", 10);
    freq.put("乘乱丁", 7);
    freq.put("丘的临", 17);
    freq.put("专且是", 35);
    freq.put("丁专！", 26);
    freq.put("中国。", 12);
    freq.put("丹俘", 34);
    freq.put("：丹且", 9);
    freq.put("，丹大", 7);
    freq.put("：丹专", 19);
    freq.put("国临三", 15);
    freq.put("乘乱专", 10);
    freq.put("丐，三", 10);
    freq.put(" 日，", 72);
    freq.put(" 日）", 13);
    freq.put("「三三", 13);
    freq.put(" 专俩", 7);
    freq.put("丘乘 ", 20);
    freq.put("「三专", 8);
    freq.put("之在的", 7);
    freq.put("专的三", 247);
    freq.put("乘乱之", 7);
    freq.put("：丹之", 11);
    freq.put("月之之", 11);
    freq.put("丑。", 40);
    freq.put("丘乙乙", 8);
    freq.put("丘俩 ", 8);
    freq.put("专丙 ", 16);
    freq.put("三且大", 7);
    freq.put("临丁丹", 29);
    freq.put("，万丹", 16);
    freq.put("机丹", 15);
    freq.put("丹乱", 44);
    freq.put("专丁乱", 23);
    freq.put("且 ", 296);
    freq.put("仗之三", 12);
    freq.put("丹么", 163);
    freq.put("丹之", 1582);
    freq.put("，万三", 134);
    freq.put("机三", 76);
    freq.put("丙是", 21);
    freq.put("丹乎", 93);
    freq.put("仗之丁", 11);
    freq.put("，万一", 7);
    freq.put("机万", 69);
    freq.put("丘的之", 51);
    freq.put("，万万", 22);
    freq.put("仗之万", 7);
    freq.put("丹乙", 245);
    freq.put("丹乘", 432);
    freq.put("仗之丛", 7);
    freq.put("专丁乘", 67);
    freq.put("机丘", 15);
    freq.put("丹乞", 11);
    freq.put(" 、乘", 7);
    freq.put("，万专", 59);
    freq.put("仗之专", 12);
    freq.put("，万且", 19);
    freq.put("机专", 127);
    freq.put("丹丫", 10);
    freq.put("丹中", 50);
    freq.put("专丁中", 14);
    freq.put("人 ", 299);
    freq.put("丹丢", 111);
    freq.put("三丛，", 63);
    freq.put("丹丹", 567);
    freq.put("乘、三", 10);
    freq.put("专丁丹", 72);
    freq.put("丹为", 26);
    freq.put(" 、临", 10);
    freq.put("之：", 261);
    freq.put("丹丰", 52);
    freq.put("临丛，", 16);
    freq.put("乙之，", 56);
    freq.put("三丛？", 38);
    freq.put("丹临", 726);
    freq.put("丘的丹", 8);
    freq.put("专丁临", 172);
    freq.put("丹三", 2124);
    freq.put("丹丈", 51);
    freq.put("仗之之", 10);
    freq.put("专丁丈", 23);
    freq.put("机么", 10);
    freq.put("丘的丁", 50);
    freq.put("机之", 81);
    freq.put("丹丁", 1058);
    freq.put("丹一", 170);
    freq.put("专丁丁", 343);
    freq.put("专丁一", 18);
    freq.put("专丁万", 94);
    freq.put("丹万", 459);
    freq.put("丹丙", 184);
    freq.put("丹丘", 358);
    freq.put("丹丛", 284);
    freq.put("，万乙", 7);
    freq.put("机乘", 8);
    freq.put("大之，", 8);
    freq.put("丹丑", 31);
    freq.put("丹丐", 27);
    freq.put("丹专", 2090);
    freq.put("万乙丘", 12);
    freq.put("丙临。", 11);
    freq.put("丹且", 628);
    freq.put("乘丛的", 8);
    freq.put("专丁且", 62);
    freq.put("俩之专", 10);
    freq.put("丹丛专", 19);
    freq.put("《丘", 25);
    freq.put("！三之", 15);
    freq.put("；且之", 7);
    freq.put("《专", 60);
    freq.put("๑ ", 8);
    freq.put("机丛华", 7);
    freq.put("《三", 91);
    freq.put("丁圳之", 10);
    freq.put("俩之三", 8);
    freq.put("《万", 28);
    freq.put("《丁", 34);
    freq.put("亥，三", 8);
    freq.put("，之乘", 19);
    freq.put("《丹", 26);
    freq.put("《临", 40);
    freq.put("国临丁", 14);
    freq.put("为乘专", 17);
    freq.put("《中", 23);
    freq.put(" 丹国", 9);
    freq.put("临乙的", 28);
    freq.put("乞 ", 26);
    freq.put("並三三", 8);
    freq.put("专丁仗", 17);
    freq.put("丹仗", 97);
    freq.put("丁圳专", 8);
    freq.put("《乘", 16);
    freq.put("在国三", 10);
    freq.put("在国万", 7);
    freq.put("丹亥", 8);
    freq.put("･ ", 16);
    freq.put("专丁亥", 7);
    freq.put("临丁乙", 29);
    freq.put("专丁人", 38);
    freq.put("丹人", 46);
    freq.put("《之", 43);
    freq.put("俩之之", 12);
    freq.put("丁圳三", 14);
    freq.put("丹临。", 9);
    freq.put("丘的人", 10);
    freq.put("亥，之", 7);
    freq.put("乘万，", 10);
    freq.put("专丁于", 20);
    freq.put("丹于", 43);
    freq.put("－－", 42);
    freq.put("－临", 37);
    freq.put("专佛三", 9);
    freq.put("专乘华", 28);
    freq.put("乙！ ", 13);
    freq.put("丹亟", 54);
    freq.put("丹亞", 9);
    freq.put("专乘丹", 28);
    freq.put("丘丘，", 30);
    freq.put(" 丹么", 28);
    freq.put("晟乙", 7);
    freq.put(" 丹之", 308);
    freq.put("丙丹丁", 11);
    freq.put("仞╁", 13);
    freq.put("之乙乱", 11);
    freq.put("专的是", 24);
    freq.put("丙丹三", 11);
    freq.put("临丁乎", 7);
    freq.put("之乙之", 88);
    freq.put("。劈劈", 7);
    freq.put("之乙么", 9);
    freq.put("么； ", 7);
    freq.put("丹丹乙", 11);
    freq.put("丹丹乘", 17);
    freq.put("之的。", 18);
    freq.put("之乙乙", 38);
    freq.put("之乙乘", 8);
    freq.put("临么之", 16);
    freq.put("临么么", 22);
    freq.put("▽", 52);
    freq.put("丹丹么", 8);
    freq.put("丹丹之", 58);
    freq.put("万三在", 16);
    freq.put("丹丹临", 30);
    freq.put("一丁。", 7);
    freq.put("丢之。", 17);
    freq.put("之乙丢", 11);
    freq.put("丹丹丹", 21);
    freq.put("亞倉", 8);
    freq.put("之乙丹", 9);
    freq.put("乙仗。", 11);
    freq.put("丹丹丢", 10);
    freq.put("临的乱", 7);
    freq.put("丙丹之", 8);
    freq.put("之乙临", 49);
    freq.put("年华", 11);
    freq.put("之乙三", 99);
    freq.put("之乙丈", 11);
    freq.put("乎，", 53);
    freq.put("丹丹专", 75);
    freq.put(" 中专", 19);
    freq.put("之乙丁", 66);
    freq.put("丹丛临", 8);
    freq.put("之乙万", 7);
    freq.put("丹丹丘", 12);
    freq.put("三，在", 27);
    freq.put("专丛丘", 21);
    freq.put("之乙丛", 35);
    freq.put("之乙丙", 11);
    freq.put("之乙丘", 38);
    freq.put("丹丹丁", 28);
    freq.put("临么三", 20);
    freq.put("之乙专", 66);
    freq.put("丹丹三", 73);
    freq.put("且丙专", 10);
    freq.put("临么丁", 16);
    freq.put("之乙且", 8);
    freq.put("是，丁", 8);
    freq.put("：之之", 25);
    freq.put("中万之", 9);
    freq.put("一丹的", 15);
    freq.put("丘一之", 15);
    freq.put("在丁丹", 8);
    freq.put("是，专", 8);
    freq.put("临丢 ", 10);
    freq.put("在丁临", 23);
    freq.put("在丁三", 42);
    freq.put("是仗坤", 9);
    freq.put("在丁万", 7);
    freq.put("万临专", 97);
    freq.put("侶", 7);
    freq.put("是，丹", 9);
    freq.put("在丁专", 34);
    freq.put("之乙仗", 11);
    freq.put("：之三", 32);
    freq.put("丘一专", 27);
    freq.put("之", 54953);
    freq.put("：之万", 10);
    freq.put("：之丁", 15);
    freq.put("丘一三", 15);
    freq.put("。专在", 29);
    freq.put("三万乙", 38);
    freq.put("是，乘", 7);
    freq.put("丘一丁", 15);
    freq.put("三万乘", 49);
    freq.put("丘一万", 7);
    freq.put("：之专", 52);
    freq.put("在丁之", 37);
    freq.put("在丁乎", 7);
    freq.put("丙日", 7);
    freq.put("丘一临", 9);
    freq.put("哒", 8);
    freq.put("机，专", 8);
    freq.put("：之临", 11);
    freq.put("：且三", 17);
    freq.put("丛专，", 22);
    freq.put("临仗 ", 22);
    freq.put("　　－", 36);
    freq.put("丢专专", 32);
    freq.put("丢专三", 24);
    freq.put("丢专万", 8);
    freq.put("丢专一", 7);
    freq.put("丢专丁", 11);
    freq.put(" 丘之", 90);
    freq.put(" 丘么", 9);
    freq.put("之；三", 18);
    freq.put("万仗 ", 21);
    freq.put("三丹。", 14);
    freq.put("丢专临", 11);
    freq.put("三万之", 412);
    freq.put("专年之", 8);
    freq.put(" 丘乙", 23);
    freq.put(" 丘乘", 12);
    freq.put("丢专丢", 7);
    freq.put("且丛三", 11);
    freq.put("，三的", 17);
    freq.put("｀", 13);
    freq.put("丰专月", 10);
    freq.put("丢专乘", 8);
    freq.put("：且之", 17);
    freq.put("么且 ", 7);
    freq.put(" 丘丢", 8);
    freq.put("丁且，", 25);
    freq.put("且中 ", 10);
    freq.put(" 丘丹", 20);
    freq.put("丢专之", 24);
    freq.put("丘人三", 10);
    freq.put(" 丘临", 59);
    freq.put("丘人临", 9);
    freq.put(" 丘三", 94);
    freq.put("之；之", 8);
    freq.put("乎的 ", 7);
    freq.put(" 丘丁", 66);
    freq.put(" 丘万", 21);
    freq.put("专年三", 13);
    freq.put("专年且", 9);
    freq.put(" 丘丙", 8);
    freq.put(" 丘丘", 36);
    freq.put("专年专", 12);
    freq.put(" 丘专", 68);
    freq.put(" 丘丑", 11);
    freq.put("且丛之", 24);
    freq.put(" 丘且", 9);
    freq.put("丹万万", 11);
    freq.put("傀丁", 9);
    freq.put("之且一", 13);
    freq.put("专机", 72);
    freq.put("专丢乙", 13);
    freq.put("冲：", 8);
    freq.put("，丢丁", 12);
    freq.put("傀专", 14);
    freq.put("，丢三", 9);
    freq.put("专丢之", 18);
    freq.put("临一之", 19);
    freq.put("両", 7);
    freq.put("仗坤", 39);
    freq.put("侃专", 23);
    freq.put("冲丁 ", 15);
    freq.put("人》", 20);
    freq.put("人、", 12);
    freq.put("三乙乘", 26);
    freq.put("傀丹", 9);
    freq.put("专， ", 61);
    freq.put("人】", 9);
    freq.put("专丢专", 26);
    freq.put("丹乱三", 8);
    freq.put(" 仗 ", 22);
    freq.put("专丢丛", 14);
    freq.put("专丢丘", 11);
    freq.put("国专 ", 14);
    freq.put("临一万", 9);
    freq.put(" 丘人", 8);
    freq.put("专丢丁", 28);
    freq.put("专丢万", 13);
    freq.put("丁丘的", 43);
    freq.put("？且丁", 9);
    freq.put("，丢之", 17);
    freq.put("专丢三", 47);
    freq.put("临一三", 38);
    freq.put(" 丹丘", 74);
    freq.put("专万：", 11);
    freq.put("专丢临", 13);
    freq.put("万三国", 12);
    freq.put("人乙之", 8);
    freq.put("临一丹", 7);
    freq.put("仗在", 13);
    freq.put("专丢丢", 12);
    freq.put("丹万且", 19);
    freq.put("专万，", 61);
    freq.put("机专，", 8);
    freq.put("　　", 349);
    freq.put("乘专专", 223);
    freq.put("丛傀", 7);
    freq.put(" （ ", 9);
    freq.put("之么乘", 10);
    freq.put(" 三佛", 14);
    freq.put("之么么", 43);
    freq.put("╯▽", 12);
    freq.put("之么之", 32);
    freq.put("是丙之", 8);
    freq.put("之为丘", 7);
    freq.put("丁傀", 16);
    freq.put("三人丁", 47);
    freq.put("　三专", 8);
    freq.put("之么临", 24);
    freq.put("三》 ", 9);
    freq.put("乙，丘", 8);
    freq.put("三一，", 7);
    freq.put("之么丘", 13);
    freq.put("丹之！", 12);
    freq.put("之么丛", 7);
    freq.put("之么专", 36);
    freq.put("之么且", 9);
    freq.put("乘专一", 19);
    freq.put("仗！ ", 34);
    freq.put("丁专。", 60);
    freq.put("丁专、", 22);
    freq.put("乘专丁", 107);
    freq.put("是丙三", 7);
    freq.put("之么丁", 15);
    freq.put("专丘：", 9);
    freq.put("一专的", 11);
    freq.put("三乙的", 37);
    freq.put(" 临之", 341);
    freq.put(" 临俩", 12);
    freq.put("乙，丁", 20);
    freq.put("丈专 ", 19);
    freq.put("丘万 ", 24);
    freq.put(" 三俩", 21);
    freq.put("专丹一", 14);
    freq.put("临乙丘", 19);
    freq.put("在乘专", 8);
    freq.put("临乙且", 9);
    freq.put("之人，", 28);
    freq.put("临乙专", 36);
    freq.put("丘乱之", 10);
    freq.put("专专乙", 87);
    freq.put("之么仗", 7);
    freq.put("之三一", 114);
    freq.put("丹万临", 21);
    freq.put("临乙临", 26);
    freq.put("███", 21);
    freq.put("为专临", 9);
    freq.put("临乙之", 33);
    freq.put("乙，临", 14);
    freq.put(" 丹丰", 15);
    freq.put("临乙乙", 11);
    freq.put("》：", 14);
    freq.put("年的", 77);
    freq.put("是之临", 19);
    freq.put("丘乱三", 10);
    freq.put("丰年", 23);
    freq.put("丘乱丁", 7);
    freq.put("万】 ", 7);
    freq.put("丘乱专", 7);
    freq.put("万，之", 68);
    freq.put(" 三乱", 21);
    freq.put("且的 ", 11);
    freq.put("的，", 430);
    freq.put("乙专的", 23);
    freq.put("万，乘", 26);
    freq.put("万，乙", 7);
    freq.put("专的大", 7);
    freq.put("丛临丹", 9);
    freq.put("丛临临", 14);
    freq.put("的之，", 26);
    freq.put("专】 ", 70);
    freq.put("是丛的", 8);
    freq.put(" 三乘", 94);
    freq.put("丛冲", 19);
    freq.put(" 　　", 224);
    freq.put("丛临三", 65);
    freq.put("丁丹之", 81);
    freq.put("，丁的", 19);
    freq.put("是么", 88);
    freq.put("丛临丁", 22);
    freq.put(" 三么", 27);
    freq.put(" 三之", 826);
    freq.put("丁丹乙", 13);
    freq.put("丁丹乘", 12);
    freq.put(" 三乎", 32);
    freq.put("丛临且", 9);
    freq.put("万，乱", 7);
    freq.put("丛临专", 29);
    freq.put(" 三丹", 83);
    freq.put(" 三为", 21);
    freq.put("专丹丢", 11);
    freq.put(" 三丰", 11);
    freq.put("万，丁", 48);
    freq.put(" 三临", 249);
    freq.put("是乙丘", 9);
    freq.put("丁丹丢", 7);
    freq.put("万，丛", 10);
    freq.put("丁丹丹", 24);
    freq.put(" 三中", 8);
    freq.put("丁丹临", 25);
    freq.put(" 三丢", 25);
    freq.put("临】", 22);
    freq.put("万，且", 39);
    freq.put(" 三並", 9);
    freq.put(" 三丘", 220);
    freq.put("ㅠ", 51);
    freq.put(" 三丛", 76);
    freq.put("丁丹三", 111);
    freq.put("么之？", 25);
    freq.put("丛临之", 51);
    freq.put(" 三丐", 8);
    freq.put("【中国", 8);
    freq.put("丁丹万", 20);
    freq.put(" 三专", 598);
    freq.put("丁丹丁", 55);
    freq.put("丁丹一", 12);
    freq.put(" 三丈", 24);
    freq.put(" 三三", 1508);
    freq.put("丁冲", 73);
    freq.put("丁丹丙", 7);
    freq.put("丁丹丘", 14);
    freq.put("么之，", 27);
    freq.put("丁丁冲", 13);
    freq.put(" 三一", 87);
    freq.put("丁丹且", 25);
    freq.put("，之年", 25);
    freq.put("万，临", 17);
    freq.put("丁丹专", 102);
    freq.put("临》", 30);
    freq.put("是乙", 110);
    freq.put("三～", 11);
    freq.put("丙之之", 47);
    freq.put("乙临临", 20);
    freq.put("丹的丙", 11);
    freq.put("丙之乙", 7);
    freq.put("之丐之", 8);
    freq.put("专么华", 7);
    freq.put("亥，", 48);
    freq.put(" 临冲", 7);
    freq.put("乙临丛", 7);
    freq.put("乙临丘", 13);
    freq.put("乙临丙", 7);
    freq.put("临。", 349);
    freq.put("丛是专", 8);
    freq.put("坏的", 12);
    freq.put("亥！", 7);
    freq.put("乙临专", 45);
    freq.put(" 三仗", 10);
    freq.put("丛是三", 11);
    freq.put("是之乘", 10);
    freq.put("年，之", 10);
    freq.put("丙丁。", 12);
    freq.put("乙临丁", 23);
    freq.put(" 丢的", 7);
    freq.put("丙之丁", 27);
    freq.put("丙之一", 11);
    freq.put("丙之万", 20);
    freq.put("三？", 130);
    freq.put("之一丁", 69);
    freq.put("丛三。", 18);
    freq.put("丙之三", 43);
    freq.put("乙中国", 8);
    freq.put("丙之专", 38);
    freq.put("三（", 81);
    freq.put("丘的丘", 15);
    freq.put("三，", 2243);
    freq.put("丙之且", 19);
    freq.put("丁的华", 9);
    freq.put("之丐三", 7);
    freq.put("三＂", 8);
    freq.put("俩俩俩", 11);
    freq.put(" 三亥", 44);
    freq.put("年，专", 9);
    freq.put("临丑三", 9);
    freq.put("丛是之", 8);
    freq.put("乙临之", 60);
    freq.put(" 三于", 16);
    freq.put("丙之临", 10);
    freq.put("年，三", 19);
    freq.put("三且是", 23);
    freq.put("三】丘", 13);
    freq.put("， ", 506);
    freq.put("。临丹", 11);
    freq.put("，冲之", 15);
    freq.put("¯﹃", 7);
    freq.put("「", 256);
    freq.put("，丘丘", 22);
    freq.put("一三。", 27);
    freq.put("人。 ", 25);
    freq.put("之临 ", 191);
    freq.put("于。", 25);
    freq.put(" 嗯，", 12);
    freq.put("么专，", 15);
    freq.put("乙，之", 50);
    freq.put("亳", 21);
    freq.put("么专？", 10);
    freq.put("临临人", 11);
    freq.put("丁之俘", 7);
    freq.put("专丹的", 52);
    freq.put("，冲三", 7);
    freq.put("丁亨之", 7);
    freq.put("丹的丹", 12);
    freq.put("万；", 11);
    freq.put("万：", 67);
    freq.put("国国专", 11);
    freq.put("，于是", 28);
    freq.put("国国三", 8);
    freq.put("×", 11);
    freq.put("仗仗，", 7);
    freq.put("丹三国", 13);
    freq.put("专 ", 3428);
    freq.put("国国丁", 8);
    freq.put("万）", 20);
    freq.put("万（", 22);
    freq.put("乘丁么", 12);
    freq.put("一丘 ", 9);
    freq.put(" 丁，", 9);
    freq.put("丢丢 ", 10);
    freq.put("：丁", 142);
    freq.put(" ╰ ", 16);
    freq.put("之，冲", 8);
    freq.put("¯︶", 7);
    freq.put(" 丁：", 8);
    freq.put("年丹专", 11);
    freq.put("人一三", 9);
    freq.put("！佛佛", 7);
    freq.put("日三 ", 33);
    freq.put("之月 ", 16);
    freq.put("三之在", 64);
    freq.put("乎三之", 39);
    freq.put("临临乙", 16);
    freq.put("临临乘", 31);
    freq.put("是三", 963);
    freq.put("三专国", 18);
    freq.put("之乘。", 8);
    freq.put("三为之", 56);
    freq.put("临圳", 9);
    freq.put("三为乎", 15);
    freq.put("临临之", 136);
    freq.put("三仗，", 41);
    freq.put("临临么", 11);
    freq.put("丙丁在", 8);
    freq.put("临在", 126);
    freq.put("丘国", 25);
    freq.put("三为乘", 28);
    freq.put("丙！ ", 12);
    freq.put("之镖", 7);
    freq.put("临丙，", 10);
    freq.put("人一之", 8);
    freq.put("乱中国", 15);
    freq.put("的丙临", 11);
    freq.put("临临丰", 13);
    freq.put("专·", 14);
    freq.put("三为中", 11);
    freq.put("临临临", 45);
    freq.put("临坏", 15);
    freq.put("三为临", 14);
    freq.put("三为丹", 21);
    freq.put("万。三", 16);
    freq.put("三为一", 13);
    freq.put("三为丁", 30);
    freq.put("临临丙", 12);
    freq.put("乎三三", 47);
    freq.put("临临专", 202);
    freq.put("三为三", 67);
    freq.put("乎三丁", 11);
    freq.put("乎三万", 9);
    freq.put("临临且", 14);
    freq.put("，大之", 8);
    freq.put("乎三丘", 9);
    freq.put("三为专", 34);
    freq.put("三为且", 9);
    freq.put("的丙三", 17);
    freq.put("乘丁乱", 7);
    freq.put("三为丘", 7);
    freq.put("乎三专", 25);
    freq.put("临坤", 25);
    freq.put("临临一", 12);
    freq.put("临临万", 33);
    freq.put("的丙丁", 50);
    freq.put("丹的乘", 11);
    freq.put("三丢 ", 20);
    freq.put("于三 ", 7);
    freq.put("是丘", 173);
    freq.put("万丹之", 40);
    freq.put("丁之于", 7);
    freq.put("丘丁、", 7);
    freq.put("丘丁。", 23);
    freq.put("万丹乙", 10);
    freq.put("丞", 44);
    freq.put("丁之人", 20);
    freq.put("临临俘", 7);
    freq.put("一之的", 27);
    freq.put("中三华", 52);
    freq.put("之仗之", 22);
    freq.put("之中，", 11);
    freq.put("华专的", 8);
    freq.put("丘坤", 27);
    freq.put("且丙之", 11);
    freq.put("丛厥", 9);
    freq.put("丁叶", 10);
    freq.put("万丹万", 9);
    freq.put("大之之", 32);
    freq.put("万丹丁", 35);
    freq.put("三国人", 25);
    freq.put("丁之仗", 30);
    freq.put("万丹三", 47);
    freq.put("万丹且", 33);
    freq.put("万丹专", 58);
    freq.put("万丹丘", 7);
    freq.put("之仗丁", 10);
    freq.put("丘在", 61);
    freq.put("临国", 121);
    freq.put("之仗三", 10);
    freq.put("亥乙，", 8);
    freq.put("之仗专", 14);
    freq.put("万丹临", 19);
    freq.put("万丹丹", 21);
    freq.put("人丘临", 8);
    freq.put("丁之丛", 72);
    freq.put("丁之丙", 42);
    freq.put("丁之丘", 90);
    freq.put("丘丹且", 9);
    freq.put("丁之专", 434);
    freq.put("丁之丑", 7);
    freq.put("丁丁华", 15);
    freq.put("丹三在", 31);
    freq.put("丁华", 124);
    freq.put("丘丹丁", 13);
    freq.put("丁之三", 582);
    freq.put("丁之丈", 13);
    freq.put("丘丹三", 41);
    freq.put("丁之丁", 387);
    freq.put("丁之一", 63);
    freq.put("丁之万", 176);
    freq.put("丁之丹", 97);
    freq.put("丁大临", 7);
    freq.put("丘丹临", 10);
    freq.put("丘丹丹", 7);
    freq.put("丁之临", 171);
    freq.put(" 专的", 24);
    freq.put("丁之中", 29);
    freq.put("丁之丢", 25);
    freq.put("三国之", 48);
    freq.put("，丹是", 25);
    freq.put("丹乙丘", 9);
    freq.put("丢万 ", 18);
    freq.put("π", 10);
    freq.put("丁之乙", 60);
    freq.put("丁之乘", 67);
    freq.put("三国临", 11);
    freq.put("华三 ", 81);
    freq.put("丁之之", 431);
    freq.put("丁之么", 38);
    freq.put("丁之乎", 18);
    freq.put("之一乙", 22);
    freq.put("是丁万", 14);
    freq.put("丘丹之", 25);
    freq.put("乘丁的", 38);
    freq.put("丕 ", 10);
    freq.put("万！ ", 9);
    freq.put("三国专", 63);
    freq.put("丁！ ", 45);
    freq.put("乘丁三", 101);
    freq.put("丁之乱", 14);
    freq.put("╯", 55);
    freq.put("三国丁", 22);
    freq.put("乘专人", 39);
    freq.put("三国万", 23);
    freq.put("三国三", 85);
    freq.put("之在乘", 9);
    freq.put("三之冲", 11);
    freq.put("一丁", 400);
    freq.put("一万", 249);
    freq.put("一丈", 32);
    freq.put("一三", 1043);
    freq.put("一专", 1327);
    freq.put("２", 11);
    freq.put("丁大丁", 7);
    freq.put("一且", 76);
    freq.put("仗。丁", 7);
    freq.put("乙：万", 18);
    freq.put("一丛", 59);
    freq.put("一丘", 79);
    freq.put("一丙", 53);
    freq.put("丹临的", 19);
    freq.put("临丁《", 9);
    freq.put("一丢", 32);
    freq.put(" 万仗", 7);
    freq.put(" 且乙", 7);
    freq.put("中之，", 7);
    freq.put("临冲", 59);
    freq.put("一临", 297);
    freq.put("一丹", 104);
    freq.put("之在丛", 7);
    freq.put("，且丘", 15);
    freq.put("一之", 671);
    freq.put("一么", 20);
    freq.put("之在专", 48);
    freq.put("一乎", 93);
    freq.put("丛人 ", 13);
    freq.put("华华 ", 27);
    freq.put("之在三", 52);
    freq.put("之专在", 51);
    freq.put("丁劈；", 10);
    freq.put("之在一", 7);
    freq.put("之在丁", 19);
    freq.put("一乘", 99);
    freq.put("一乙", 133);
    freq.put("之在万", 9);
    freq.put("之在丹", 24);
    freq.put("万临。", 15);
    freq.put("丙的三", 20);
    freq.put("丁的国", 9);
    freq.put("之在临", 12);
    freq.put("丙的丁", 9);
    freq.put("丘乙。", 7);
    freq.put("一乱", 17);
    freq.put("在，", 35);
    freq.put("丙的专", 29);
    freq.put("（之丹", 7);
    freq.put("在丹的", 73);
    freq.put("万", 15206);
    freq.put("么三丹", 12);
    freq.put("丈万三", 7);
    freq.put("：万三", 10);
    freq.put("丈的之", 11);
    freq.put("的三仗", 9);
    freq.put("临》 ", 9);
    freq.put("一亥", 12);
    freq.put("么三丘", 19);
    freq.put("之（专", 7);
    freq.put(" 万乘", 18);
    freq.put(" 万乙", 16);
    freq.put("么三一", 9);
    freq.put("么三丁", 51);
    freq.put("三华华", 22);
    freq.put("（之三", 11);
    freq.put("专三日", 21);
    freq.put("么三万", 23);
    freq.put("一人", 19);
    freq.put("临大之", 10);
    freq.put("临且 ", 16);
    freq.put("丘丈三", 7);
    freq.put(" 万么", 7);
    freq.put("╁", 13);
    freq.put(" 万临", 55);
    freq.put("丈的专", 11);
    freq.put("刨，", 23);
    freq.put("万丙 ", 12);
    freq.put(" 万丹", 26);
    freq.put("：万之", 13);
    freq.put("之在于", 7);
    freq.put(" 万中", 9);
    freq.put("丈的三", 10);
    freq.put("临大专", 19);
    freq.put(" 万且", 34);
    freq.put(" 万专", 106);
    freq.put("！大", 10);
    freq.put("么三乘", 8);
    freq.put("之，在", 30);
    freq.put(" 万丛", 30);
    freq.put(" 万丘", 28);
    freq.put(" 万丙", 23);
    freq.put("（之之", 8);
    freq.put("之（之", 7);
    freq.put("临大万", 12);
    freq.put(" 万丁", 54);
    freq.put("是三么", 7);
    freq.put("临大三", 49);
    freq.put(" 万三", 358);
    freq.put("─", 10);
    freq.put("丁；三", 7);
    freq.put("么。。", 38);
    freq.put("丘丙 ", 11);
    freq.put("乘丘 ", 21);
    freq.put("日丹乘", 11);
    freq.put("丰", 805);
    freq.put("、丁丙", 7);
    freq.put("乘 ", 472);
    freq.put("圳之丁", 7);
    freq.put("且国三", 7);
    freq.put("之？！", 9);
    freq.put("之，国", 9);
    freq.put("麽", 12);
    freq.put("大丘丁", 8);
    freq.put(" 乘日", 8);
    freq.put("之之的", 164);
    freq.put("丢丘 ", 10);
    freq.put("乱的三", 12);
    freq.put("日，", 113);
    freq.put("日）", 13);
    freq.put(" 。临", 10);
    freq.put("乘三是", 51);
    freq.put("丹且华", 7);
    freq.put("～俩", 9);
    freq.put("乘。三", 8);
    freq.put("是丁三", 103);
    freq.put("仗，专", 41);
    freq.put("仗，且", 20);
    freq.put("是丢丁", 9);
    freq.put("仗，三", 44);
    freq.put("）之", 18);
    freq.put("仗，一", 8);
    freq.put("仗，丁", 28);
    freq.put("乘。。", 12);
    freq.put("仗，丹", 25);
    freq.put("临仗！", 11);
    freq.put(" 。。", 56);
    freq.put("机的", 21);
    freq.put(" 。丹", 8);
    freq.put(" 且丘", 7);
    freq.put("仗，临", 8);
    freq.put("临仗，", 14);
    freq.put("乘丛之", 37);
    freq.put("国三，", 25);
    freq.put("临仗？", 9);
    freq.put("仗，乘", 9);
    freq.put("之亥之", 8);
    freq.put("是丢之", 8);
    freq.put("潇", 8);
    freq.put("）专", 18);
    freq.put("丢是", 12);
    freq.put("乘丛临", 8);
    freq.put("）三", 33);
    freq.put("仗，之", 27);
    freq.put("且华丁", 8);
    freq.put("丢丁专", 30);
    freq.put("）丁", 13);
    freq.put("且华三", 14);
    freq.put("）万", 9);
    freq.put("）丹", 7);
    freq.put("一乙 ", 14);
    freq.put("乙三 ", 45);
    freq.put("的丁，", 11);
    freq.put("三专冲", 21);
    freq.put("丙丈 ", 8);
    freq.put("一俩", 8);
    freq.put("丹的", 658);
    freq.put("专丁的", 135);
    freq.put("乘丛三", 8);
    freq.put("丘冲", 31);
    freq.put("乙乙乙", 18);
    freq.put("乘丛丁", 13);
    freq.put("丁万华", 21);
    freq.put("乱专丁", 12);
    freq.put("乱专万", 8);
    freq.put("，临临", 36);
    freq.put("乱专三", 35);
    freq.put("临丹 ", 42);
    freq.put("乱专专", 38);
    freq.put("且三的", 18);
    freq.put("丐 ", 83);
    freq.put("乎丁丁", 10);
    freq.put("为一专", 19);
    freq.put("乱专丘", 8);
    freq.put("，临专", 83);
    freq.put(" ﹁", 10);
    freq.put("人临之", 19);
    freq.put("，临且", 8);
    freq.put("，临丛", 9);
    freq.put("，临丘", 17);
    freq.put(" ﹏", 10);
    freq.put(" 月三", 13);
    freq.put("，临一", 10);
    freq.put("，临万", 17);
    freq.put("乱专临", 7);
    freq.put("，临三", 89);
    freq.put("丁国", 46);
    freq.put("乎丁三", 10);
    freq.put("丁乙》", 7);
    freq.put("乱专之", 41);
    freq.put("丹专 ", 94);
    freq.put("乘人临", 7);
    freq.put("丁乙。", 22);
    freq.put("专三月", 12);
    freq.put("丘一的", 8);
    freq.put(" 月乘", 12);
    freq.put("《人三", 7);
    freq.put("乎丁专", 12);
    freq.put("临叶", 16);
    freq.put("专三机", 13);
    freq.put("，临乙", 9);
    freq.put("，临乘", 24);
    freq.put("丛国", 9);
    freq.put(" 月之", 19);
    freq.put("丁且是", 16);
    freq.put("，临之", 108);
    freq.put("丹。。", 32);
    freq.put("之是仗", 7);
    freq.put(" 乘是", 31);
    freq.put("，临人", 11);
    freq.put("之是丢", 8);
    freq.put("临丹三", 73);
    freq.put("之是丹", 55);
    freq.put("之是为", 11);
    freq.put("中三国", 8);
    freq.put("之是临", 46);
    freq.put("俩三之", 15);
    freq.put("乙「", 8);
    freq.put("之是三", 146);
    freq.put("乎丁丙", 7);
    freq.put("之是丁", 78);
    freq.put("之是一", 33);
    freq.put("之是万", 35);
    freq.put("万的？", 7);
    freq.put("之是丙", 8);
    freq.put("之是丘", 28);
    freq.put("之是丛", 19);
    freq.put("是三乙", 10);
    freq.put("丁丘俩", 8);
    freq.put("万的，", 21);
    freq.put("，临于", 19);
    freq.put("｡ ", 19);
    freq.put("俩三专", 9);
    freq.put("俩三丘", 13);
    freq.put("临华", 100);
    freq.put("俩三丁", 7);
    freq.put("之是么", 14);
    freq.put("之是之", 84);
    freq.put("华华", 67);
    freq.put("丁丙。", 14);
    freq.put("之是乎", 9);
    freq.put("丛且 ", 7);
    freq.put("之乙的", 28);
    freq.put("之是乙", 22);
    freq.put("丹丹的", 23);
    freq.put("之万。", 23);
    freq.put("为专丁", 7);
    freq.put("三之华", 41);
    freq.put(" ｡", 21);
    freq.put("丘华", 24);
    freq.put(" ･", 13);
    freq.put("丁丘乘", 11);
    freq.put("丁丘乙", 14);
    freq.put("，三仗", 8);
    freq.put("三专华", 69);
    freq.put("临劈", 19);
    freq.put("⊙", 24);
    freq.put("丁丘之", 107);
    freq.put("丁丘么", 10);
    freq.put("坤丹", 17);
    freq.put("国华临", 7);
    freq.put("之三佛", 7);
    freq.put("临专华", 7);
    freq.put("国华三", 8);
    freq.put("丙之的", 11);
    freq.put("乱乘的", 10);
    freq.put("丛之 ", 111);
    freq.put("么？ ", 51);
    freq.put(" ～", 16);
    freq.put("丁丘专", 87);
    freq.put("临之。", 81);
    freq.put("丁丘且", 14);
    freq.put("丁丘丛", 20);
    freq.put("，三于", 17);
    freq.put("的么。", 8);
    freq.put("丛仗！", 7);
    freq.put("丁丘一", 7);
    freq.put("万专。", 15);
    freq.put("丁丘万", 18);
    freq.put("专丢的", 7);
    freq.put("一丛之", 9);
    freq.put("丁丘三", 103);
    freq.put("丛专 ", 188);
    freq.put(" ＂", 14);
    freq.put(" ＃", 8);
    freq.put(" ！", 79);
    freq.put("丁丘临", 58);
    freq.put("丁在专", 20);
    freq.put(" （", 249);
    freq.put(" ）", 84);
    freq.put(" ，", 367);
    freq.put("国华乘", 10);
    freq.put("「专专", 8);
    freq.put(" ：", 81);
    freq.put(" ；", 41);
    freq.put(" ＞", 10);
    freq.put(" ？", 35);
    freq.put("，三人", 26);
    freq.put("国丁临", 11);
    freq.put(" ￣", 45);
    freq.put("：大", 17);
    freq.put("丁丘仗", 7);
    freq.put("乘之，", 28);
    freq.put("，三乎", 24);
    freq.put("乘之！", 11);
    freq.put("，三么", 19);
    freq.put("丁坏", 32);
    freq.put("，三之", 359);
    freq.put("丹专在", 60);
    freq.put("华临，", 10);
    freq.put("丢专的", 7);
    freq.put("乙。。", 22);
    freq.put("，三乘", 32);
    freq.put("，三乙", 20);
    freq.put("丁乘，", 28);
    freq.put(" 临人", 14);
    freq.put("﹃¯", 7);
    freq.put("丁坤", 45);
    freq.put("侮 ", 10);
    freq.put("乎且之", 9);
    freq.put("仗乙", 19);
    freq.put("刹", 10);
    freq.put("丛在", 37);
    freq.put("三机 ", 8);
    freq.put("，三万", 109);
    freq.put("，三一", 35);
    freq.put("，三丁", 162);
    freq.put("，三三", 602);
    freq.put("，三且", 77);
    freq.put("，三专", 331);
    freq.put("佛", 1345);
    freq.put("的仗三", 9);
    freq.put("，三丘", 79);
    freq.put("，三丙", 15);
    freq.put("，三丛", 17);
    freq.put("，三丢", 7);
    freq.put("，三中", 7);
    freq.put("丹三华", 12);
    freq.put("丁丁在", 36);
    freq.put("，三临", 108);
    freq.put("丁圳", 53);
    freq.put("临的丘", 13);
    freq.put("且三在", 15);
    freq.put("丛坤", 8);
    freq.put("，三丹", 39);
    freq.put("，三为", 29);
    freq.put("丘国三", 8);
    freq.put("가가", 182);
    freq.put("为是", 22);
    freq.put("丁于 ", 7);
    freq.put("：三专", 28);
    freq.put(" 专）", 10);
    freq.put("：三丘", 7);
    freq.put("【", 687);
    freq.put("三丙仗", 10);
    freq.put("：三丁", 20);
    freq.put("：三三", 57);
    freq.put("：三临", 14);
    freq.put("坏，", 12);
    freq.put("，之在", 9);
    freq.put("亥的", 34);
    freq.put("丘屡", 11);
    freq.put("三丁 ", 338);
    freq.put("临丘 ", 47);
    freq.put("临一临", 9);
    freq.put("丙华", 9);
    freq.put("三乘。", 19);
    freq.put("丈三 ", 7);
    freq.put("丙专乘", 8);
    freq.put("人专是", 13);
    freq.put("：三之", 39);
    freq.put("专！三", 8);
    freq.put("丁在丹", 11);
    freq.put("专，丛", 23);
    freq.put("倪乘且", 7);
    freq.put("专！丁", 10);
    freq.put("万于 ", 20);
    freq.put("在丹专", 22);
    freq.put("专！专", 10);
    freq.put("亞之三", 8);
    freq.put("丁临 ", 130);
    freq.put("乙专，", 37);
    freq.put(" 侏亥", 25);
    freq.put("丹乙仗", 7);
    freq.put("三丙之", 68);
    freq.put("佛佛，", 30);
    freq.put("的之的", 7);
    freq.put("专机专", 20);
    freq.put("丐丁之", 7);
    freq.put("佛佛！", 15);
    freq.put("乩佛", 7);
    freq.put("丁在之", 14);
    freq.put(" 年之", 32);
    freq.put("国之之", 53);
    freq.put("专机之", 11);
    freq.put("三丙万", 15);
    freq.put("国之临", 21);
    freq.put("三丙丁", 53);
    freq.put("大之丘", 9);
    freq.put("人之 ", 24);
    freq.put("﹏", 21);
    freq.put("三丙且", 7);
    freq.put("冲，", 36);
    freq.put("三丙丑", 7);
    freq.put("三丙专", 61);
    freq.put("万三俘", 11);
    freq.put("三丙丙", 13);
    freq.put("三丙丘", 40);
    freq.put("三丙丛", 26);
    freq.put("国之专", 45);
    freq.put("临人 ", 14);
    freq.put("国之万", 27);
    freq.put("三丙临", 34);
    freq.put("国之丁", 22);
    freq.put("的三丘", 55);
    freq.put("，之乱", 7);
    freq.put("三丙丹", 13);
    freq.put("国之三", 64);
    freq.put(" 临国", 27);
    freq.put("专万是", 14);
    freq.put("三乙，", 43);
    freq.put("万丘临", 18);
    freq.put("之人的", 26);
    freq.put("专乱，", 18);
    freq.put("万丘丹", 9);
    freq.put("三乙：", 21);
    freq.put("万丘丁", 34);
    freq.put("三丘 ", 161);
    freq.put("的人，", 59);
    freq.put("丁仗三", 15);
    freq.put("万丘专", 45);
    freq.put("在丹临", 12);
    freq.put("乘专在", 27);
    freq.put("的三专", 241);
    freq.put("万丘丘", 13);
    freq.put("万丘丙", 7);
    freq.put("丁仗丁", 16);
    freq.put("万丘丛", 11);
    freq.put("乘丙临", 14);
    freq.put("万丛 ", 23);
    freq.put("年，", 91);
    freq.put("之是大", 8);
    freq.put("年（", 7);
    freq.put("！咚", 7);
    freq.put("丁年人", 11);
    freq.put("乘丙专", 9);
    freq.put("，佛佛", 30);
    freq.put(" ， ", 31);
    freq.put("万丘之", 31);
    freq.put("乘丙丁", 17);
    freq.put("丁仗之", 7);
    freq.put("乘丙三", 10);
    freq.put("万丘乘", 9);
    freq.put("万丘乙", 12);
    freq.put("（丁三", 10);
    freq.put("！一之", 7);
    freq.put("么临之", 24);
    freq.put("乘临乙", 15);
    freq.put("丘丛 ", 19);
    freq.put("丁年之", 21);
    freq.put("乩么", 13);
    freq.put("😭?", 16);
    freq.put("丛大", 41);
    freq.put("丢丙三", 8);
    freq.put("??", 7);
    freq.put("在中国", 52);
    freq.put("（丁之", 7);
    freq.put("么临丁", 28);
    freq.put("专且华", 8);
    freq.put("在万专", 9);
    freq.put("么临三", 26);
    freq.put("临乘。", 23);
    freq.put("之临的", 111);
    freq.put("么临专", 28);
    freq.put("在丹乎", 8);
    freq.put("人的 ", 10);
    freq.put("丁年丹", 7);
    freq.put("丁丁大", 26);
    freq.put("仗三的", 11);
    freq.put("专丘的", 40);
    freq.put("丁年一", 8);
    freq.put("丁年丁", 10);
    freq.put("丁仗仗", 9);
    freq.put("丁年三", 12);
    freq.put("，之国", 36);
    freq.put("丁年专", 22);
    freq.put("一专，", 18);
    freq.put("且三大", 12);
    freq.put("么临丹", 9);
    freq.put("三俩专", 10);
    freq.put("临丈专", 13);
    freq.put("佛乙", 9);
    freq.put("佛乘", 10);
    freq.put("．", 9);
    freq.put("三俩丁", 14);
    freq.put("佛之", 76);
    freq.put(" 且佛", 9);
    freq.put("。。 ", 171);
    freq.put("三俩三", 18);
    freq.put("临乱丁", 12);
    freq.put(" 临乎", 12);
    freq.put("（ ", 107);
    freq.put("万且是", 8);
    freq.put("丛丁万", 11);
    freq.put("丘年", 10);
    freq.put("佛专", 63);
    freq.put("佛且", 25);
    freq.put("佛丛", 7);
    freq.put("佛丘", 16);
    freq.put("临乱三", 13);
    freq.put("佛丁", 45);
    freq.put("佛一", 7);
    freq.put("佛万", 13);
    freq.put("三，么", 18);
    freq.put("丛么亟", 19);
    freq.put("佛三", 69);
    freq.put("三俩之", 20);
    freq.put("佛临", 24);
    freq.put("佛丹", 10);
    freq.put("之佛", 40);
    freq.put("（三）", 8);
    freq.put("丘乘乙", 11);
    freq.put("丁丛 ", 90);
    freq.put("佛仗", 9);
    freq.put("之侥", 14);
    freq.put("一丙丁", 12);
    freq.put("临乱专", 10);
    freq.put("丘仗，", 11);
    freq.put("专在 ", 15);
    freq.put(" 华专", 28);
    freq.put("华中三", 10);
    freq.put("华专）", 14);
    freq.put("之中的", 10);
    freq.put("华专，", 18);
    freq.put(" 临丹", 90);
    freq.put("之侄", 9);

    init2();
  }
  private static void init2() {
    
    freq.put("之侏", 18);
    freq.put("一之，", 21);
    freq.put("华专：", 8);
    freq.put("丑丁之", 9);
    freq.put("三，乙", 36);
    freq.put("丘之年", 8);
    freq.put("一丙之", 8);
    freq.put("之俩", 96);
    freq.put("之「三", 9);
    freq.put("乘专丢", 8);
    freq.put("万丘，", 7);
    freq.put("年万，", 7);
    freq.put("是丁的", 31);
    freq.put("三中的", 9);
    freq.put("，乘的", 23);
    freq.put("在万三", 23);
    freq.put("之俘", 63);
    freq.put("之丢", 416);
    freq.put("临庚", 14);
    freq.put("之並", 21);
    freq.put("佛佛", 572);
    freq.put("丙且专", 13);
    freq.put("之中", 277);
    freq.put("之丁乎", 18);
    freq.put("之丰", 97);
    freq.put("万三丹", 70);
    freq.put("于华丹", 14);
    freq.put("之临", 2356);
    freq.put("大三是", 7);
    freq.put("之为", 392);
    freq.put("之丹", 1232);
    freq.put("于华临", 14);
    freq.put("！！！", 386);
    freq.put("之丁", 4340);
    freq.put("之一", 825);
    freq.put("之万", 1800);
    freq.put("（临丁", 7);
    freq.put("于华三", 55);
    freq.put("坤三", 43);
    freq.put("于华万", 10);
    freq.put("坤万", 10);
    freq.put("之三", 8990);
    freq.put("之丈", 172);
    freq.put("于华丁", 19);
    freq.put("坤丁", 25);
    freq.put("之专", 5991);
    freq.put("之丑", 96);
    freq.put("之丐", 103);
    freq.put("于华丛", 8);
    freq.put("坤丛", 9);
    freq.put("之丕", 11);
    freq.put("之且", 1106);
    freq.put("之丛", 989);
    freq.put("之丙", 452);
    freq.put("于华且", 8);
    freq.put("于华专", 37);
    freq.put("之丞", 11);
    freq.put("专乘日", 7);
    freq.put("临丙的", 7);
    freq.put("之乩", 8);
    freq.put("之乱", 253);
    freq.put("丙且之", 10);
    freq.put("于华之", 35);
    freq.put("坤之", 35);
    freq.put("之之", 5962);
    freq.put("之三】", 13);
    freq.put("之么", 499);
    freq.put("之乎", 158);
    freq.put(" 华临", 23);
    freq.put("乘乘之", 33);
    freq.put("之乖", 11);
    freq.put("坤乘", 7);
    freq.put("于华乘", 12);
    freq.put("之三。", 108);
    freq.put("之乙", 834);
    freq.put("之乘", 1049);
    freq.put("之乞", 22);
    freq.put("的丢三", 14);
    freq.put(" 丫 ", 10);
    freq.put(" 临且", 19);
    freq.put("之亥", 60);
    freq.put("之亨", 22);
    freq.put("三华 ", 65);
    freq.put("临丘。", 15);
    freq.put("的丢万", 11);
    freq.put("之万冲", 9);
    freq.put("之人", 460);
    freq.put("丘； ", 7);
    freq.put("丛之丙", 15);
    freq.put("日华三", 26);
    freq.put("的丢丢", 10);
    freq.put("之于", 132);
    freq.put("侥。", 7);
    freq.put("之丙乘", 13);
    freq.put("之丹。", 14);
    freq.put("之亟", 25);
    freq.put("之亞", 7);
    freq.put("的丢之", 11);
    freq.put("三之年", 33);
    freq.put("专丹，", 32);
    freq.put("的丢乙", 13);
    freq.put(" 临万", 24);
    freq.put("万的", 476);
    freq.put("三，丈", 9);
    freq.put("专丹：", 12);
    freq.put("三，三", 365);
    freq.put("倪 ", 10);
    freq.put(" 丁的", 52);
    freq.put("乙 ", 542);
    freq.put("临年", 11);
    freq.put("：丹丁", 10);
    freq.put("之仗", 285);
    freq.put("临三。", 53);
    freq.put("之仕", 12);
    freq.put("专么大", 8);
    freq.put("坤仗", 13);
    freq.put("三俩俩", 10);
    freq.put("之仞", 19);
    freq.put("가", 260);
    freq.put("三丛之", 127);
    freq.put("三丛么", 16);
    freq.put("丢坤三", 13);
    freq.put("三並 ", 11);
    freq.put("万三乎", 19);
    freq.put("华乱", 7);
    freq.put("三丛乙", 19);
    freq.put("三丛乘", 18);
    freq.put("么专丘", 42);
    freq.put("临丛之", 57);
    freq.put("机，", 29);
    freq.put("丙在", 31);
    freq.put("华之", 162);
    freq.put("仗之，", 11);
    freq.put("丑丁三", 8);
    freq.put("是三国", 13);
    freq.put("三，丛", 33);
    freq.put("华乘", 152);
    freq.put("华乙", 42);
    freq.put("三丛乱", 9);
    freq.put("月之三", 11);
    freq.put("ε", 14);
    freq.put("丈，三", 10);
    freq.put("三，丙", 18);
    freq.put("国三的", 21);
    freq.put("三丛丁", 80);
    freq.put("丹丢专", 15);
    freq.put("三丛万", 18);
    freq.put("华中", 14);
    freq.put("三丛三", 127);
    freq.put(" ）临", 7);
    freq.put("大之临", 24);
    freq.put("临丛丘", 10);
    freq.put("三丛专", 84);
    freq.put("华丹", 28);
    freq.put("华为", 8);
    freq.put("乘万人", 11);
    freq.put("），专", 7);
    freq.put("三华丁", 44);
    freq.put("三丛且", 10);
    freq.put("三丛丛", 33);
    freq.put("三丛丙", 12);
    freq.put("三丛丘", 36);
    freq.put("华临", 234);
    freq.put("临丛三", 48);
    freq.put("是三是", 78);
    freq.put("三丛丢", 14);
    freq.put("临丛临", 21);
    freq.put("丹，", 326);
    freq.put("专丁，", 142);
    freq.put("丹！", 55);
    freq.put("华丁", 322);
    freq.put("专丁！", 19);
    freq.put("丘的，", 13);
    freq.put("之丑 ", 8);
    freq.put("华万", 25);
    freq.put("华丘", 14);
    freq.put("华丙", 16);
    freq.put("丹；", 7);
    freq.put("丹：", 56);
    freq.put("丈，之", 18);
    freq.put("丹？", 33);
    freq.put("三丛临", 37);
    freq.put("大之丁", 18);
    freq.put("三丛丹", 20);
    freq.put("华专", 352);
    freq.put("国。 ", 7);
    freq.put("；三", 79);
    freq.put("】乱", 13);
    freq.put("噢 ", 8);
    freq.put("之仗。", 15);
    freq.put("中国 ", 64);
    freq.put("丁冲丁", 12);
    freq.put("三丛仗", 11);
    freq.put("乙丛的", 13);
    freq.put("俩之，", 13);
    freq.put("三，日", 9);
    freq.put("乘万之", 29);
    freq.put("丹临叶", 11);
    freq.put("】乙", 13);
    freq.put("】乘", 8);
    freq.put("丘丘乙", 19);
    freq.put("。专于", 8);
    freq.put(" 临华", 8);
    freq.put("人三。", 20);
    freq.put("丘之三", 134);
    freq.put("丘丘之", 44);
    freq.put("临大", 142);
    freq.put("】之", 36);
    freq.put("】临", 19);
    freq.put("丘丘临", 19);
    freq.put("】丹", 13);
    freq.put("丘丘丹", 10);
    freq.put("乘在", 96);
    freq.put("丑 ", 95);
    freq.put("华人", 25);
    freq.put("坤，", 25);
    freq.put("丹， ", 11);
    freq.put("乘万丹", 20);
    freq.put("丁冲之", 14);
    freq.put("】中", 16);
    freq.put("丘丘专", 48);
    freq.put("】专", 29);
    freq.put("之丁丘", 90);
    freq.put("】中国", 10);
    freq.put("华于", 114);
    freq.put("乘万三", 61);
    freq.put("丘丘丛", 11);
    freq.put("日的", 16);
    freq.put("丘丘丘", 11);
    freq.put("乘万丁", 27);
    freq.put("】丁", 39);
    freq.put("】一", 11);
    freq.put("丘丘丁", 34);
    freq.put("丘丘万", 10);
    freq.put("三爬", 8);
    freq.put("】万", 16);
    freq.put("】三", 55);
    freq.put("倉 ", 7);
    freq.put("丘丘三", 67);
    freq.put("丘丘丈", 7);
    freq.put("乘万专", 33);
    freq.put("且专乎", 8);
    freq.put("且专之", 125);
    freq.put("三丁》", 12);
    freq.put(" 之之", 452);
    freq.put(" 之么", 21);
    freq.put("之丘的", 41);
    freq.put("三丁、", 13);
    freq.put("三丁。", 87);
    freq.put("仗？？", 7);
    freq.put("且专乘", 39);
    freq.put("且专乙", 10);
    freq.put(" 之乘", 58);
    freq.put(" 丈 ", 14);
    freq.put("丹日三", 10);
    freq.put("专丙。", 7);
    freq.put("瞧", 16);
    freq.put("丢丛专", 289);
    freq.put("的三日", 7);
    freq.put(" 之乱", 12);
    freq.put("。于是", 10);
    freq.put("且。", 31);
    freq.put("丢丛三", 44);
    freq.put("丛中三", 9);
    freq.put("。中国", 17);
    freq.put(" 之一", 39);
    freq.put(" 之丁", 298);
    freq.put(" 之万", 85);
    freq.put("且专三", 162);
    freq.put("且专万", 47);
    freq.put(" 之丈", 14);
    freq.put(" 之三", 700);
    freq.put("且专一", 10);
    freq.put("专丹华", 10);
    freq.put(" 之专", 392);
    freq.put(" 之丑", 11);
    freq.put("且专丛", 7);
    freq.put("且专丘", 19);
    freq.put("专：丁", 33);
    freq.put(" 之丛", 72);
    freq.put("且专且", 27);
    freq.put("，劈劈", 13);
    freq.put("且专专", 173);
    freq.put("丙临 ", 18);
    freq.put(" 之丢", 52);
    freq.put(" 丹是", 50);
    freq.put("且专丢", 7);
    freq.put("丘大", 56);
    freq.put("丛丛 ", 43);
    freq.put(" 之临", 189);
    freq.put("且专丹", 66);
    freq.put(" 之为", 96);
    freq.put("且专临", 40);
    freq.put(" 之丹", 66);
    freq.put("三专大", 40);
    freq.put("丢丛之", 14);
    freq.put("丙三万", 27);
    freq.put("丹在三", 21);
    freq.put("丙三丁", 36);
    freq.put("丙三一", 7);
    freq.put("。。", 1650);
    freq.put(" 日之", 43);
    freq.put("。」", 18);
    freq.put("临，丹", 61);
    freq.put("丹在丁", 12);
    freq.put("丙三三", 57);
    freq.put("临，丢", 9);
    freq.put(" 日乘", 20);
    freq.put("。】", 10);
    freq.put("丙三专", 49);
    freq.put("万三于", 10);
    freq.put("丹在专", 17);
    freq.put("丙三丙", 11);
    freq.put("丙三丘", 16);
    freq.put("临，中", 12);
    freq.put("临，专", 104);
    freq.put("之乘乘", 23);
    freq.put("中之的", 7);
    freq.put("临，且", 65);
    freq.put("临，丛", 8);
    freq.put("⊙ ", 9);
    freq.put("三丛俩", 7);
    freq.put("临，丘", 13);
    freq.put("中", 2777);
    freq.put("丙三临", 14);
    freq.put("临，丁", 57);
    freq.put("临，一", 16);
    freq.put("临，万", 28);
    freq.put("临，三", 132);
    freq.put("丙三丹", 9);
    freq.put("三乱，", 16);
    freq.put("丹在之", 11);
    freq.put(" 日三", 131);
    freq.put(" 日万", 7);
    freq.put(" 之于", 7);
    freq.put(" 日丁", 42);
    freq.put("丙三之", 70);
    freq.put("丛万，", 7);
    freq.put("丹在乘", 8);
    freq.put("之的临", 55);
    freq.put("丰华", 9);
    freq.put("丙三乘", 10);
    freq.put(" 日专", 104);
    freq.put("｀ ", 8);
    freq.put(" 之亥", 7);
    freq.put("临，乙", 11);
    freq.put("临，乘", 43);
    freq.put("丹万么", 8);
    freq.put("丙国", 8);
    freq.put(" 日丹", 17);
    freq.put("临，之", 99);
    freq.put("丹临 ", 32);
    freq.put("　　丁", 11);
    freq.put("丛专丁", 41);
    freq.put("丛？ ", 85);
    freq.put("　　三", 33);
    freq.put("之的 ", 58);
    freq.put("丁且之", 62);
    freq.put("乘之的", 19);
    freq.put("　　专", 19);
    freq.put("丘丁丛", 22);
    freq.put("丛专专", 85);
    freq.put("华临的", 11);
    freq.put("丁且乘", 15);
    freq.put("丘么 ", 10);
    freq.put("丛专丢", 7);
    freq.put("万三亥", 9);
    freq.put("　　中", 28);
    freq.put("丛专临", 31);
    freq.put("且丛，", 7);
    freq.put("丛专丹", 21);
    freq.put("专之在", 34);
    freq.put("丁且万", 35);
    freq.put("丘丁专", 84);
    freq.put("丁且丁", 49);
    freq.put("　　之", 15);
    freq.put("之《三", 18);
    freq.put("屌", 11);
    freq.put("丛专之", 77);
    freq.put("丁且三", 81);
    freq.put("丁且且", 21);
    freq.put("丁且专", 47);
    freq.put("丛专乙", 16);
    freq.put("丛专乘", 15);
    freq.put("丁且丘", 11);
    freq.put("；丹", 10);
    freq.put("一丁 ", 24);
    freq.put("丁且丢", 7);
    freq.put("丐专三", 11);
    freq.put(" 且是", 105);
    freq.put("丁且临", 15);
    freq.put("乙丙之", 10);
    freq.put("三日华", 29);
    freq.put("丁且丹", 19);
    freq.put("╁丁", 13);
    freq.put("乎俩", 7);
    freq.put("冲丑", 16);
    freq.put("冲专", 118);
    freq.put("专万乱", 15);
    freq.put("。之是", 11);
    freq.put("冲丘", 32);
    freq.put("冲丛", 28);
    freq.put("机临", 16);
    freq.put("冲万", 56);
    freq.put("冲丁", 143);
    freq.put("冲三", 107);
    freq.put("丈的", 76);
    freq.put("专万乙", 16);
    freq.put("专万乘", 22);
    freq.put("冲丹", 53);
    freq.put("丁丁年", 12);
    freq.put("专万之", 214);
    freq.put("大丹专", 9);
    freq.put("丁年", 166);
    freq.put("冲丢", 12);
    freq.put("专万乎", 9);
    freq.put("乩佛佛", 7);
    freq.put("国，之", 7);
    freq.put("丘丁万", 20);
    freq.put("机专之", 19);
    freq.put("专万丹", 51);
    freq.put("专丁之", 428);
    freq.put("丁且于", 10);
    freq.put("专的国", 8);
    freq.put("专万临", 85);
    freq.put("丛专仗", 8);
    freq.put("月丹", 16);
    freq.put("专万中", 12);
    freq.put("专万丢", 8);
    freq.put("临） ", 9);
    freq.put("专丢，", 17);
    freq.put("专丁乎", 16);
    freq.put("专万丙", 14);
    freq.put("国，专", 9);
    freq.put("专万丛", 19);
    freq.put("的三是", 46);
    freq.put("丛之，", 74);
    freq.put("《人", 8);
    freq.put(" 的", 288);
    freq.put("机专专", 13);
    freq.put("仗是", 11);
    freq.put("专万专", 185);
    freq.put("大丹之", 7);
    freq.put("专万且", 30);
    freq.put("人丁 ", 7);
    freq.put("专万三", 329);
    freq.put("机专万", 7);
    freq.put("专万丁", 128);
    freq.put("专万一", 7);
    freq.put("国，三", 9);
    freq.put("机专三", 18);
    freq.put("专万万", 74);
    freq.put("中的三", 10);
    freq.put("三丹 ", 72);
    freq.put("劈；", 11);
    freq.put("乙，丹", 25);
    freq.put("机丁", 29);
    freq.put("之华 ", 18);
    freq.put("中的专", 8);
    freq.put("乎么", 840);
    freq.put("大丁是", 8);
    freq.put("乎之", 135);
    freq.put("乎乎", 37);
    freq.put("丁丹乎", 11);
    freq.put("倪", 95);
    freq.put("，万丘", 9);
    freq.put("乎乘", 40);
    freq.put("乎乙", 13);
    freq.put("万三是", 19);
    freq.put("乘三年", 7);
    freq.put("中的之", 8);
    freq.put("乎丢", 22);
    freq.put("机丛", 21);
    freq.put("乎丹", 18);
    freq.put("丛华三", 12);
    freq.put("乎临", 38);
    freq.put("临么？", 7);
    freq.put("乎三", 210);
    freq.put("之乙，", 44);
    freq.put("乎一", 16);
    freq.put("乎丁", 100);
    freq.put("且丢之", 8);
    freq.put("乎万", 28);
    freq.put("乎丘", 33);
    freq.put("乎丙", 32);
    freq.put("临么，", 9);
    freq.put("丘的乙", 12);
    freq.put("丹丹，", 15);
    freq.put("乎专", 170);
    freq.put("乎且", 59);
    freq.put("临么！", 9);
    freq.put("乙的是", 8);
    freq.put("冲丁。", 10);
    freq.put("一临丘", 13);
    freq.put("一临专", 18);
    freq.put("且且丹", 13);
    freq.put("国专丁", 25);
    freq.put("一临三", 28);
    freq.put("一临万", 9);
    freq.put("一临丁", 13);
    freq.put("一临丹", 9);
    freq.put("一临临", 17);
    freq.put("临丛？", 14);
    freq.put("乙丙丁", 9);
    freq.put("乎仗", 15);
    freq.put("一临乙", 9);
    freq.put("乎亥", 7);
    freq.put("乎人", 62);
    freq.put("。专是", 23);
    freq.put("一临之", 14);
    freq.put("在乙乙", 7);
    freq.put("日专之", 19);
    freq.put("乘一之", 31);
    freq.put("丙丘丁", 22);
    freq.put("啧", 38);
    freq.put("专丁为", 7);
    freq.put("。专一", 7);
    freq.put("为专三", 16);
    freq.put("乘丹 ", 15);
    freq.put("丘丁之", 100);
    freq.put("之且在", 8);
    freq.put("之丛的", 30);
    freq.put("丛丘 ", 19);
    freq.put("　", 797);
    freq.put("乙，且", 20);
    freq.put("丘且专", 17);
    freq.put("乙，专", 40);
    freq.put("乘专且", 21);
    freq.put("一丈专", 9);
    freq.put("乘专丛", 29);
    freq.put("乘专丘", 13);
    freq.put("乘专丙", 10);
    freq.put(" 之华", 12);
    freq.put("的人是", 14);
    freq.put("丘且万", 7);
    freq.put("」！ ", 23);
    freq.put("一丈三", 8);
    freq.put(" 专丙", 29);
    freq.put("乘专万", 51);
    freq.put("丘且丁", 10);
    freq.put(" 、丹", 7);
    freq.put("乘专三", 202);
    freq.put("三于 ", 14);
    freq.put("丘且三", 44);
    freq.put("乙，三", 58);
    freq.put("乘专丰", 7);
    freq.put("专丁丰", 9);
    freq.put("╁丁 ", 13);
    freq.put("乘专临", 68);
    freq.put("乘专为", 13);
    freq.put("丁国专", 9);
    freq.put("且万乙", 7);
    freq.put("俘三，", 15);
    freq.put("爬", 38);
    freq.put("丘且丹", 8);
    freq.put(" → ", 58);
    freq.put("丁国三", 11);
    freq.put("且万之", 57);
    freq.put("丘的万", 17);
    freq.put("丢的专", 17);
    freq.put("且万临", 14);
    freq.put("，万之", 65);
    freq.put("丛乙专", 17);
    freq.put("乘专乘", 38);
    freq.put("且万丹", 18);
    freq.put("专丁三", 518);
    freq.put("乙，乘", 21);
    freq.put("丛乙三", 10);
    freq.put("且且丘", 12);
    freq.put("乘专之", 180);
    freq.put("丛乙丁", 18);
    freq.put("丘且之", 27);
    freq.put("三乱 ", 23);
    freq.put("且万专", 42);
    freq.put("且万且", 7);
    freq.put("且万丛", 9);
    freq.put("专华，", 7);
    freq.put("丘的一", 15);
    freq.put(" 专丈", 12);
    freq.put("专华）", 13);
    freq.put(" 临侏", 7);
    freq.put("之三仗", 46);
    freq.put("且万丁", 26);
    freq.put("且万万", 10);
    freq.put(" 、三", 18);
    freq.put("且万三", 100);
    freq.put("专华：", 12);
    freq.put(" ￣ ", 18);
    freq.put("丰专", 166);
    freq.put(" 日华", 19);
    freq.put("的", 12008);
    freq.put("丰且", 46);
    freq.put("丰丛", 7);
    freq.put("丰丘", 13);
    freq.put("、丁之", 15);
    freq.put("日丹专", 31);
    freq.put("丰丁", 67);
    freq.put("丰万", 20);
    freq.put("？丁专", 7);
    freq.put("丰三", 129);
    freq.put("、丁乙", 7);
    freq.put("之之 ", 393);
    freq.put("人丘丁", 8);
    freq.put("专丁丛", 75);
    freq.put("的， ", 15);
    freq.put("：《", 23);
    freq.put("丰临", 25);
    freq.put("人丘三", 7);
    freq.put("丰丹", 12);
    freq.put("，万乘", 8);
    freq.put("人丘专", 9);
    freq.put("，且 ", 14);
    freq.put("丘的专", 61);
    freq.put("、丁丁", 12);
    freq.put("人是三", 9);
    freq.put("丰乘", 10);
    freq.put("丰乙", 16);
    freq.put("、丁三", 17);
    freq.put("万之且", 37);
    freq.put("专丁专", 397);
    freq.put("三是，", 11);
    freq.put("一专是", 26);
    freq.put("、丁专", 21);
    freq.put("丰之", 114);
    freq.put("丰乎", 14);
    freq.put("专丁丑", 14);
    freq.put("丛丘专", 16);
    freq.put("劈丐之", 7);
    freq.put("，三大", 8);
    freq.put("于丹专", 8);
    freq.put("人丘之", 7);
    freq.put("、丁临", 12);
    freq.put("丘临的", 45);
    freq.put("于丹丁", 7);
    freq.put("且万于", 7);
    freq.put("年年", 7);
    freq.put("临的之", 82);
    freq.put("丘三。", 14);
    freq.put("亟临", 13);
    freq.put("俘之，", 14);
    freq.put("，之三", 384);
    freq.put("是，三", 13);
    freq.put("，之万", 76);
    freq.put("仞专", 7);
    freq.put(" 三年", 18);
    freq.put("，之一", 22);
    freq.put("，之丁", 150);
    freq.put("仞三", 8);
    freq.put("临的乙", 21);
    freq.put("临的乘", 20);
    freq.put("，临大", 11);
    freq.put("，之丛", 28);
    freq.put("，之丘", 46);
    freq.put("，之丙", 26);
    freq.put("乎丁丛", 12);
    freq.put("，之且", 166);
    freq.put("丘临乘", 47);
    freq.put("【临专", 12);
    freq.put("，之专", 276);
    freq.put("ﾟ", 15);
    freq.put("为，", 33);
    freq.put("在专 ", 27);
    freq.put("乘人专", 10);
    freq.put("冲冲", 13);
    freq.put("丁三、", 13);
    freq.put("《丛", 12);
    freq.put("，之丢", 15);
    freq.put("劈劈。", 9);
    freq.put("，之为", 74);
    freq.put("在中三", 11);
    freq.put("，之丹", 34);
    freq.put("，之临", 76);
    freq.put("丁丛！", 17);
    freq.put("之三华", 41);
    freq.put("。三于", 9);
    freq.put("临的三", 125);
    freq.put("临的丈", 9);
    freq.put("，之之", 234);
    freq.put("，之么", 15);
    freq.put("临的丁", 87);
    freq.put("临的一", 18);
    freq.put("临的万", 11);
    freq.put("临的丛", 16);
    freq.put("临的丙", 8);
    freq.put("仞之", 7);
    freq.put("丢丁 ", 32);
    freq.put("，之乙", 23);
    freq.put("临的专", 128);
    freq.put("俩的", 55);
    freq.put("」的", 12);
    freq.put("丁丛：", 8);
    freq.put("临的丢", 9);
    freq.put("人专：", 9);
    freq.put("且之丛", 19);
    freq.put(" 临于", 31);
    freq.put("临的丹", 15);
    freq.put("人专，", 21);
    freq.put("丁丛？", 32);
    freq.put("丛的。", 7);
    freq.put("临的临", 50);
    freq.put("，丁是", 35);
    freq.put("丛丁临", 31);
    freq.put("丛丁丹", 13);
    freq.put(" 临乱", 16);
    freq.put("丈。 ", 12);
    freq.put("丢的之", 12);
    freq.put("专华华", 22);
    freq.put("专月，", 9);
    freq.put("丛丁专", 39);
    freq.put("﹁ ", 10);
    freq.put("乙专是", 10);
    freq.put(" 临乙", 61);
    freq.put(" 临乘", 58);
    freq.put("丛丁丛", 18);
    freq.put("乘人三", 24);
    freq.put("丛丁丘", 9);
    freq.put("专乘，", 30);
    freq.put("专丘在", 7);
    freq.put("丛丁丁", 37);
    freq.put("，之人", 7);
    freq.put("国。", 22);
    freq.put("丛丁三", 85);
    freq.put("国《", 13);
    freq.put("仞仞", 26);
    freq.put(" 丙三", 49);
    freq.put(" 临临", 172);
    freq.put("。丁三", 47);
    freq.put("三；", 77);
    freq.put("。 ", 1737);
    freq.put(" 临丢", 9);
    freq.put("万之丢", 9);
    freq.put(" 临丛", 29);
    freq.put("丈槿", 11);
    freq.put(" 临丙", 19);
    freq.put(" 临丘", 64);
    freq.put("丛丁乙", 8);
    freq.put("丛丁乘", 12);
    freq.put(" 临专", 246);
    freq.put("临的人", 53);
    freq.put("一专月", 20);
    freq.put(" 是之", 18);
    freq.put(" 临三", 204);
    freq.put(" 临丈", 18);
    freq.put("丛丁之", 66);
    freq.put(" 专乎", 18);
    freq.put("亨之 ", 13);
    freq.put("之哟", 8);
    freq.put(" 临丁", 144);
    freq.put(" 临一", 7);
    freq.put("·之三", 9);
    freq.put("专俘 ", 14);
    freq.put("专临 ", 311);
    freq.put("之乎三", 11);
    freq.put("·之一", 22);
    freq.put("之在", 334);
    freq.put("大乘三", 16);
    freq.put("之乎丁", 14);
    freq.put("丹丢三", 11);
    freq.put("的临丹", 10);
    freq.put("专人三", 140);
    freq.put("之乎丛", 7);
    freq.put("丹丢丁", 11);
    freq.put("的临丰", 10);
    freq.put("之乎专", 15);
    freq.put("的临临", 35);
    freq.put("的临三", 110);
    freq.put("乎华", 11);
    freq.put("国丛 ", 14);
    freq.put("的临丁", 50);
    freq.put("的临万", 13);
    freq.put("的临丛", 16);
    freq.put("的临丙", 7);
    freq.put("的临丘", 19);
    freq.put("之专 ", 366);
    freq.put("的临专", 72);
    freq.put("大三，", 9);
    freq.put("乘乘丁", 14);
    freq.put("仗丁，", 7);
    freq.put("之乎之", 8);
    freq.put("之乎么", 47);
    freq.put("之坤", 29);
    freq.put("万且，", 9);
    freq.put("坤坤", 38);
    freq.put("三人，", 30);
    freq.put("丹丢之", 10);
    freq.put("万万 ", 34);
    freq.put("丘临专", 112);
    freq.put("的临乱", 8);
    freq.put("～", 207);
    freq.put("的临之", 81);
    freq.put("俩", 1295);
    freq.put("之坏", 11);
    freq.put("日三，", 28);
    freq.put("的临乙", 18);
    freq.put("的临乘", 8);
    freq.put("【乘华", 11);
    freq.put("乘乘万", 7);
    freq.put("么丁么", 11);
    freq.put("么丁之", 33);
    freq.put("专仗，", 29);
    freq.put("专于 ", 27);
    freq.put("专仗！", 20);
    freq.put("么丁乘", 10);
    freq.put("的临人", 7);
    freq.put("专", 55102);
    freq.put("丛！ ", 16);
    freq.put("专仗？", 8);
    freq.put("！佛", 8);
    freq.put("《乙", 23);
    freq.put("中，丁", 7);
    freq.put("亨", 143);
    freq.put("三且的", 29);
    freq.put("中，三", 13);
    freq.put("中，专", 8);
    freq.put("么亟 ", 7);
    freq.put("丁丑，", 11);
    freq.put("：「", 17);
    freq.put("么丁三", 29);
    freq.put("兢兢", 46);
    freq.put("么丁丁", 25);
    freq.put("么丁丙", 8);
    freq.put("么丁丛", 10);
    freq.put("丁三》", 7);
    freq.put("么丁专", 18);
    freq.put("：【", 15);
    freq.put("丁三。", 75);
    freq.put(" 乙。", 9);
    freq.put("专三冲", 9);
    freq.put("专丹是", 29);
    freq.put("且丁。", 8);
    freq.put("且之乙", 24);
    freq.put("么丁临", 17);
    freq.put("丁一 ", 12);
    freq.put("三日丹", 20);
    freq.put("临在丛", 9);
    freq.put("临在专", 7);
    freq.put("，丹的", 29);
    freq.put("临在三", 18);
    freq.put("三淀", 7);
    freq.put("临在丁", 13);
    freq.put("一大", 39);
    freq.put("、丹之", 15);
    freq.put("三日专", 8);
    freq.put("一乘 ", 12);
    freq.put("之》 ", 11);
    freq.put("三日三", 32);
    freq.put("丙丛。", 7);
    freq.put("丹丁临", 53);
    freq.put("三日丁", 9);
    freq.put("●", 11);
    freq.put("临在之", 13);
    freq.put("，乘三", 152);
    freq.put("为临之", 11);
    freq.put("、丹三", 12);
    freq.put("的乙仗", 12);
    freq.put("三日之", 9);
    freq.put("、丹专", 8);
    freq.put("的乙临", 14);
    freq.put("！之", 81);
    freq.put("一之是", 14);
    freq.put("亥之 ", 8);
    freq.put("劈冲", 16);
    freq.put("！乙", 12);
    freq.put("！乘", 46);
    freq.put("的专。", 13);
    freq.put("专专 ", 624);
    freq.put("的乙丢", 12);
    freq.put("丘之临", 46);
    freq.put("华，专", 8);
    freq.put("临丰专", 13);
    freq.put("丁丈的", 14);
    freq.put("的乙丛", 22);
    freq.put("且之人", 20);
    freq.put("的乙专", 24);
    freq.put("中专之", 20);
    freq.put("的乙三", 37);
    freq.put("专万华", 32);
    freq.put("的乙丁", 31);
    freq.put("！丁", 75);
    freq.put("！一", 10);
    freq.put("！万", 30);
    freq.put("！三", 107);
    freq.put("中专临", 7);
    freq.put("么仗 ", 9);
    freq.put("！专", 95);
    freq.put("！且", 31);
    freq.put("！丙", 11);
    freq.put("！丘", 21);
    freq.put("！丛", 15);
    freq.put("之国", 492);
    freq.put("！丢", 7);
    freq.put("的乙乙", 15);
    freq.put("丁丹，", 37);
    freq.put("中专专", 14);
    freq.put("是为之", 47);
    freq.put("丁之年", 12);
    freq.put("？么么", 7);
    freq.put("！临", 32);
    freq.put("中专三", 27);
    freq.put("的乙之", 33);
    freq.put("！丹", 101);
    freq.put("华，之", 8);
    freq.put("中专丁", 10);
    freq.put("丙万临", 11);
    freq.put("丛丹丁", 18);
    freq.put("且临，", 9);
    freq.put("丙万丹", 7);
    freq.put("□", 9);
    freq.put("丙万丁", 14);
    freq.put("三。临", 24);
    freq.put("乙一三", 8);
    freq.put("丙万三", 19);
    freq.put("嗯 ", 13);
    freq.put("乙一专", 9);
    freq.put("大的", 99);
    freq.put("丙万专", 8);
    freq.put("三仗？", 18);
    freq.put("丹丁三", 120);
    freq.put("之兢", 7);
    freq.put("丁么 ", 46);
    freq.put(" 丹，", 8);
    freq.put(" 氪", 23);
    freq.put("三！丁", 12);
    freq.put("乱丛之", 9);
    freq.put("专丁机", 11);
    freq.put("丹机", 20);
    freq.put("丹月", 7);
    freq.put("三！", 161);
    freq.put("且专在", 43);
    freq.put(" 之在", 21);
    freq.put("丙万之", 13);
    freq.put("一年", 75);
    freq.put("华。", 12);
    freq.put(" 万年", 10);
    freq.put("专且万", 34);
    freq.put("专且一", 9);
    freq.put("专； ", 14);
    freq.put("人仗 ", 7);
    freq.put("６", 9);
    freq.put("日三人", 16);
    freq.put("专且三", 128);
    freq.put("专且且", 23);
    freq.put("之冲", 82);
    freq.put(" 俩之", 17);
    freq.put("万么丁", 10);
    freq.put("丘，乙", 9);
    freq.put("专且专", 54);
    freq.put("且于，", 7);
    freq.put("临，在", 10);
    freq.put("＝", 10);
    freq.put("万么三", 10);
    freq.put("丁。 ", 119);
    freq.put("之一，", 11);
    freq.put("丛，三", 58);
    freq.put("专且临", 33);
    freq.put(" 、丁", 14);
    freq.put("、中国", 8);
    freq.put("乘三么", 11);
    freq.put("丁之大", 19);
    freq.put("专且丹", 13);
    freq.put("专且为", 7);
    freq.put("三年，", 13);
    freq.put("丘，三", 92);
    freq.put("丘，万", 11);
    freq.put(" 俩专", 7);
    freq.put("丘，丁", 47);
    freq.put("专且之", 89);
    freq.put(" 俩三", 7);
    freq.put("丘，丘", 16);
    freq.put("丘，且", 38);
    freq.put("万么么", 14);
    freq.put("万么之", 9);
    freq.put("丙俩", 16);
    freq.put("俩丁三", 11);
    freq.put("丘，丹", 34);
    freq.put("丘，临", 26);
    freq.put("丙三", 463);
    freq.put("丙丈", 36);
    freq.put(" 가 ", 8);
    freq.put("丙丁", 547);
    freq.put("之倪", 17);
    freq.put("丢三的", 25);
    freq.put("丙万", 115);
    freq.put("丙丙", 122);
    freq.put("丙丘", 204);
    freq.put("丙丛", 167);
    freq.put("专专！", 33);
    freq.put("吖", 11);
    freq.put("丙丑", 41);
    freq.put("丙丐", 24);
    freq.put("丙专", 359);
    freq.put("么的，", 16);
    freq.put("丙且", 61);
    freq.put("乙乘乘", 7);
    freq.put("丙中", 13);
    freq.put("？？ ", 9);
    freq.put("丙丢", 33);
    freq.put("是。。", 7);
    freq.put("丙丹", 87);
    freq.put(" 俩俩", 17);
    freq.put("专之 ", 515);
    freq.put("丙临", 239);
    freq.put("丙么", 43);
    freq.put("丙之", 431);
    freq.put("专丁是", 44);
    freq.put("人人三", 10);
    freq.put("丹是", 218);
    freq.put("丙乎", 11);
    freq.put("临人专", 26);
    freq.put("乙乘临", 13);
    freq.put("丙乙", 97);
    freq.put("丙乘", 73);
    freq.put("丹乘，", 9);
    freq.put("丹丁乙", 23);
    freq.put("丢的", 120);
    freq.put("于丁 ", 7);
    freq.put("　丹", 8);
    freq.put("专仗的", 13);
    freq.put(" 丹于", 16);
    freq.put("乙乘专", 10);
    freq.put(" 【 ", 36);
    freq.put("丙乱", 46);
    freq.put("三临：", 18);
    freq.put("乙乘丁", 10);
    freq.put("的丹 ", 8);
    freq.put("丢的 ", 15);
    freq.put("且机专", 7);
    freq.put("是么么", 24);
    freq.put("丙于", 16);
    freq.put("、之专", 24);
    freq.put("在是之", 7);
    freq.put("、之三", 25);
    freq.put("丙亟", 7);
    freq.put("丁乱，", 12);
    freq.put("、之丁", 13);
    freq.put("之国，", 7);
    freq.put("临人丁", 18);
    freq.put("之傀", 13);
    freq.put("之乙中", 7);
    freq.put("丙亥", 16);
    freq.put("、之临", 9);
    freq.put("丙人", 16);
    freq.put("　之", 23);
    freq.put(" 之国", 102);
    freq.put("乘三的", 44);
    freq.put("捏", 36);
    freq.put("、之之", 19);
    freq.put("乘乘 ", 9);
    freq.put("，丑三", 8);
    freq.put("丛丹 ", 20);
    freq.put("丙仗", 42);
    freq.put("是么专", 8);
    freq.put("么乙 ", 30);
    freq.put("丈之专", 20);
    freq.put("是么临", 17);
    freq.put("丁） ", 15);
    freq.put("专的临", 70);
    freq.put("丰专之", 28);
    freq.put("乘乙临", 10);
    freq.put("临乱，", 8);
    freq.put(" 专】", 27);
    freq.put("万三；", 8);
    freq.put("专的丹", 22);
    freq.put("乘丘丛", 12);
    freq.put("丘丁，", 39);
    freq.put("洒", 12);
    freq.put("专的丢", 9);
    freq.put(" 专。", 10);
    freq.put("专的中", 12);
    freq.put("：丁临", 11);
    freq.put("万三，", 85);
    freq.put("丛乘的", 10);
    freq.put("亟。", 20);
    freq.put("华丁 ", 35);
    freq.put("乘乙专", 11);
    freq.put("且之。", 15);
    freq.put("：丁三", 22);
    freq.put("乘乙丘", 14);
    freq.put("：丁万", 7);
    freq.put("丛。之", 9);
    freq.put("丁（三", 7);
    freq.put("专的丘", 55);
    freq.put("冲临之", 11);
    freq.put("：丁丁", 17);
    freq.put("乱 ", 174);
    freq.put("专的万", 24);
    freq.put("专的一", 21);
    freq.put("专的丁", 118);
    freq.put("乘乙三", 13);
    freq.put("专的丈", 10);
    freq.put("：丁专", 13);
    freq.put("丰专三", 16);
    freq.put("丹丹且", 28);
    freq.put("三且乙", 10);
    freq.put("丰专万", 7);
    freq.put("之且于", 11);
    freq.put("丰专专", 18);
    freq.put("丹丹是", 8);
    freq.put(" 三大", 17);
    freq.put("乱。专", 9);
    freq.put("：丁之", 15);
    freq.put("乘乙乙", 13);
    freq.put("专的乘", 35);
    freq.put("之华", 196);
    freq.put("三並", 55);
    freq.put("人之的", 12);
    freq.put("丰专丹", 7);
    freq.put("丘亂的", 9);
    freq.put("：丁乙", 11);
    freq.put("乘乙之", 17);
    freq.put("专的么", 14);
    freq.put("丰专临", 7);
    freq.put("专的之", 104);
    freq.put("丹是之", 13);
    freq.put("之且乙", 11);
    freq.put("俘，", 47);
    freq.put("临么专", 11);
    freq.put("丹日", 24);
    freq.put("专丁日", 10);
    freq.put("人丹三", 21);
    freq.put("之且么", 10);
    freq.put("人丹专", 11);
    freq.put("三丑之", 17);
    freq.put("之且之", 155);
    freq.put("乙的，", 15);
    freq.put("丐三之", 7);
    freq.put("丙么 ", 7);
    freq.put("之且乱", 12);
    freq.put("冲临仕", 8);
    freq.put("人丹临", 7);
    freq.put("　乱", 12);
    freq.put("大万 ", 16);
    freq.put("万在三", 11);
    freq.put("坤丘 ", 7);
    freq.put("是仗，", 12);
    freq.put("之且丘", 17);
    freq.put("丹是三", 43);
    freq.put("之且丛", 11);
    freq.put("之且且", 29);
    freq.put("人丹之", 16);
    freq.put("丹是丁", 37);
    freq.put("丹是一", 12);
    freq.put("乘且的", 7);
    freq.put("三丑三", 12);
    freq.put("之叶", 9);
    freq.put("呗", 16);
    freq.put("之且万", 57);
    freq.put("一三的", 26);
    freq.put("。丹的", 7);
    freq.put("万丁 ", 47);
    freq.put("丐三三", 12);
    freq.put("专的仗", 9);
    freq.put("之且丹", 46);
    freq.put("之且临", 31);
    freq.put("三丑临", 8);
    freq.put("丰专人", 7);
    freq.put("之且中", 10);
    freq.put("丹是丹", 9);
    freq.put("乙丙，", 11);
    freq.put("是丹 ", 9);
    freq.put("之刨", 9);
    freq.put("之是在", 11);
    freq.put("临临三", 129);
    freq.put("並", 264);
    freq.put("万一专", 31);
    freq.put("年三，", 9);
    freq.put("在乎专", 15);
    freq.put("丢专是", 7);
    freq.put("万一三", 16);
    freq.put("劈", 548);
    freq.put("万一万", 10);
    freq.put("专丰三", 30);
    freq.put("万一丁", 16);
    freq.put("ア ", 9);
    freq.put("丛丁的", 18);
    freq.put("三万：", 8);
    freq.put("佐", 19);
    freq.put(" 且，", 7);
    freq.put(" 乱丘", 18);
    freq.put("丢临的", 8);
    freq.put("一临，", 37);
    freq.put("万一之", 22);
    freq.put("槿", 11);
    freq.put("、三之", 42);
    freq.put("乎国", 12);
    freq.put("仗～", 12);
    freq.put("么丹乘", 8);
    freq.put("三万，", 131);
    freq.put("乙丢三", 18);
    freq.put("之劈", 38);
    freq.put("三亥，", 22);
    freq.put("的三，", 19);
    freq.put("仗！", 199);
    freq.put("仗，", 286);
    freq.put("仗（", 7);
    freq.put("专万在", 11);
    freq.put("专三的", 251);
    freq.put("仗？", 149);
    freq.put("仗：", 12);
    freq.put("铊中", 12);
    freq.put("临。之", 18);
    freq.put("专》 ", 39);
    freq.put("在丁丁", 31);
    freq.put("乙丁 ", 64);
    freq.put("仗专丁", 15);
    freq.put("万乎专", 8);
    freq.put("丛临在", 24);
    freq.put("丹且丹", 17);
    freq.put("仗专三", 15);
    freq.put("丹且临", 15);
    freq.put("仗专专", 10);
    freq.put("专月的", 14);
    freq.put("专乘的", 50);
    freq.put("丹且丛", 21);
    freq.put("丹且丘", 13);
    freq.put("丹且且", 10);
    freq.put("乘丘三", 29);
    freq.put("丹且专", 97);
    freq.put("在丁丛", 7);
    freq.put("丹且三", 108);
    freq.put("的之是", 36);
    freq.put("丹且一", 13);
    freq.put("丹且丁", 52);
    freq.put("仗专之", 18);
    freq.put("乙之临", 31);
    freq.put("乎大", 7);
    freq.put(" 三在", 24);
    freq.put("丹之机", 8);
    freq.put("万乎么", 40);
    freq.put("乙之丹", 19);
    freq.put("丹且乘", 30);
    freq.put("丹且乙", 9);
    freq.put("丹且之", 71);
    freq.put(" 乱丁", 17);
    freq.put("冲专么", 17);
    freq.put("冲专之", 9);
    freq.put("之临乘", 55);
    freq.put("丁、之", 8);
    freq.put("临俩专", 8);
    freq.put("临俩三", 7);
    freq.put("临俩丁", 8);
    freq.put("之的乘", 20);
    freq.put("专：么", 7);
    freq.put("＂ ", 14);
    freq.put("丁丢之", 23);
    freq.put("万日", 17);
    freq.put("专：乙", 8);
    freq.put("乘临。", 9);
    freq.put("丁丢乘", 7);
    freq.put("丁丢乙", 8);
    freq.put("中万三", 8);
    freq.put("为丘丁", 7);
    freq.put("丁丢丢", 7);
    freq.put("乙之么", 9);
    freq.put("丁、丁", 14);
    freq.put("冲专三", 20);
    freq.put("专：中", 16);
    freq.put("么】", 9);
    freq.put("丁、三", 20);
    freq.put("冲专丁", 10);
    freq.put("么》", 7);
    freq.put("专：丹", 21);
    freq.put("丁丢临", 8);
    freq.put("丁、专", 14);
    freq.put("临俩之", 7);
    freq.put("么。", 166);
    freq.put("么、", 17);
    freq.put("专：临", 18);
    freq.put("冲专专", 10);
    freq.put("俘三 ", 9);
    freq.put("丁丢丁", 25);
    freq.put("专：三", 56);
    freq.put("」！", 29);
    freq.put("，在丁", 10);
    freq.put(" 丰且", 7);
    freq.put("╮ ", 30);
    freq.put("丁丢三", 25);
    freq.put("专：一", 9);
    freq.put("（专）", 18);
    freq.put("专：万", 10);
    freq.put("人专的", 19);
    freq.put("丁、临", 8);
    freq.put("丁丢专", 21);
    freq.put("丁丢且", 10);
    freq.put("三是", 1228);
    freq.put(" ￣▽", 11);
    freq.put("：之丘", 10);
    freq.put("丁丢丛", 17);
    freq.put("丁、丹", 8);
    freq.put("专：且", 19);
    freq.put("之丹之", 143);
    freq.put("是乎么", 88);
    freq.put("之丹么", 11);
    freq.put("之丹乙", 20);
    freq.put("之丹乘", 33);
    freq.put("万为 ", 8);
    freq.put("丘！！", 9);
    freq.put("丑之，", 10);
    freq.put(" 乱万", 7);
    freq.put("的之机", 19);
    freq.put("，在专", 16);
    freq.put("、丘专", 8);
    freq.put("之丹三", 152);
    freq.put("之丹丁", 80);
    freq.put("之丹一", 14);
    freq.put("之丹万", 53);
    freq.put("专丘是", 9);
    freq.put("之丹丛", 25);
    freq.put("之丹丙", 16);
    freq.put("之丹丘", 41);
    freq.put("之丹专", 145);
    freq.put("、丘三", 8);
    freq.put("之丹且", 57);
    freq.put("之丁。", 87);
    freq.put("之丁、", 14);
    freq.put("临且丁", 30);
    freq.put(" 乱三", 58);
    freq.put("之丹丢", 10);
    freq.put("之丢乘", 7);
    freq.put("之丹丹", 36);
    freq.put("乘丈之", 7);
    freq.put("丘临，", 36);
    freq.put("乘仗 ", 17);
    freq.put("之丹临", 60);
    freq.put("，临冲", 7);
    freq.put(" 三国", 54);
    freq.put("！乘三", 7);
    freq.put("之丹仗", 13);
    freq.put("三华乘", 30);
    freq.put("丢。。", 10);
    freq.put("之且是", 29);
    freq.put("三华之", 18);
    freq.put("，大三", 32);
    freq.put("三华临", 30);
    freq.put("，大丁", 12);
    freq.put("三月", 39);
    freq.put("临专 ", 140);
    freq.put("丹丘丘", 18);
    freq.put("，大专", 27);
    freq.put("专华的", 7);
    freq.put("三机", 87);
    freq.put("丙丙专", 9);
    freq.put(" 的丁", 17);
    freq.put("三华专", 44);
    freq.put("三华三", 87);
    freq.put("临人，", 7);
    freq.put("丹三亥", 8);
    freq.put("丘之", 1187);
    freq.put("三专乙", 96);
    freq.put("三专乘", 184);
    freq.put("丘乎", 47);
    freq.put("，在 ", 11);
    freq.put("为丹三", 8);
    freq.put("三专之", 1030);
    freq.put("临侏", 20);
    freq.put("丘乘", 228);
    freq.put("三专么", 99);
    freq.put("丘乞", 9);
    freq.put("三专乎", 24);
    freq.put("的仗", 72);
    freq.put("丢专丘", 8);
    freq.put("丘之仗", 9);
    freq.put("丹三人", 10);
    freq.put("丈丹的", 14);
    freq.put("临专之", 340);
    freq.put("临专么", 24);
    freq.put("三专乱", 53);
    freq.put("丢丢专", 17);
    freq.put("临专乘", 52);
    freq.put("专俩的", 11);
    freq.put("临侥", 7);
    freq.put("三专丛", 125);
    freq.put("丘丈", 78);
    freq.put("三专丘", 230);
    freq.put("临俘", 64);
    freq.put("三专专", 1300);
    freq.put("丹专大", 18);
    freq.put("丘一", 123);
    freq.put("三专丐", 8);
    freq.put("临专丢", 23);
    freq.put("仗仗仗", 363);
    freq.put("三专且", 102);
    freq.put("临。三", 26);
    freq.put("丘丛", 286);
    freq.put("丘丘", 490);
    freq.put("丘丙", 130);
    freq.put("临专为", 8);
    freq.put("临专丹", 51);
    freq.put("，乘是", 13);
    freq.put("丘专", 1182);
    freq.put("三之俩", 11);
    freq.put("丘丑", 49);
    freq.put("三专万", 326);
    freq.put("丘且", 187);
    freq.put("临。丹", 10);
    freq.put("三专为", 25);
    freq.put("三专丹", 160);
    freq.put(" 之大", 13);
    freq.put(" 于是", 15);
    freq.put("丘中", 56);
    freq.put("丘丢", 117);
    freq.put("丙丙三", 9);
    freq.put("三专丰", 15);
    freq.put("乙丛？", 7);
    freq.put("万机", 7);
    freq.put("临专一", 22);
    freq.put("三专临", 387);
    freq.put("丘为", 14);
    freq.put("丹三仗", 15);
    freq.put("丘丹", 280);
    freq.put("临专丛", 38);
    freq.put("三专中", 36);
    freq.put("临俩", 90);
    freq.put("三专丢", 36);
    freq.put("丘丰", 17);
    freq.put("》三", 45);
    freq.put("丘临", 824);
    freq.put("乙丛，", 23);
    freq.put("丘之之", 121);
    freq.put("丘之么", 21);
    freq.put("三。之", 51);
    freq.put("丹三丢", 11);
    freq.put("，在之", 22);
    freq.put("三专仗", 25);
    freq.put("之丢丈", 8);
    freq.put("年专 ", 8);
    freq.put("三。乘", 14);
    freq.put("丹三临", 86);
    freq.put("丘之乘", 21);
    freq.put("→", 139);
    freq.put("仗仗 ", 33);
    freq.put("么丁乙", 7);
    freq.put("丹三丹", 81);
    freq.put("丘仗", 98);
    freq.put("丹三为", 19);
    freq.put("且丁的", 12);
    freq.put("丹三万", 105);
    freq.put("丹三丁", 189);
    freq.put("丹三一", 36);
    freq.put("丈丁 ", 12);
    freq.put("丹三三", 352);
    freq.put("丹三丈", 9);
    freq.put("的 ", 716);
    freq.put("丹三且", 51);
    freq.put("丁之在", 16);
    freq.put("丹三丑", 9);
    freq.put("丹三专", 227);
    freq.put("丘丹在", 9);
    freq.put("临专仗", 15);
    freq.put("丹三丙", 30);
    freq.put("丹三丘", 104);
    freq.put("丹三丛", 26);
    freq.put("？ ", 501);
    freq.put("三。三", 78);
    freq.put("﹃", 7);
    freq.put(" π ", 7);
    freq.put("丘于", 27);
    freq.put("临佛", 15);
    freq.put("丘亂", 15);
    freq.put("三。丁", 30);
    freq.put("丘之一", 16);
    freq.put("丘之丁", 88);
    freq.put("丘之万", 26);
    freq.put("三。万", 13);
    freq.put("並 ", 37);
    freq.put("丘之丛", 19);
    freq.put("丘之丘", 32);
    freq.put("丘之丙", 10);
    freq.put("丹三乱", 13);
    freq.put("三专于", 35);
    freq.put("乙乙之", 37);
    freq.put("丘之专", 118);
    freq.put("三。专", 54);
    freq.put("三。且", 22);
    freq.put("丘之且", 17);
    freq.put("丢专丹", 7);
    freq.put("三专人", 88);
    freq.put("三专 ", 530);
    freq.put("丘之中", 7);
    freq.put("三之佛", 9);
    freq.put("专三年", 14);
    freq.put("三之 ", 684);
    freq.put("丹三么", 13);
    freq.put("丹三之", 268);
    freq.put("丘亥", 25);
    freq.put("丘人", 108);
    freq.put("三。丹", 32);
    freq.put("丘之丹", 27);
    freq.put("三三、", 70);
    freq.put("三三。", 194);
    freq.put("三三」", 8);
    freq.put("丹三乙", 26);
    freq.put("丹三乘", 34);
    freq.put("三三》", 16);
    freq.put("三三《", 9);
    freq.put("临亟", 27);
    freq.put("一乙之", 11);
    freq.put("丁万之", 134);
    freq.put("华乘专", 13);
    freq.put("丁万么", 11);
    freq.put("三之人", 93);
    freq.put("华乘丘", 8);
    freq.put("临于", 149);
    freq.put("丘佛", 11);
    freq.put("华乘万", 29);
    freq.put("华乘丁", 7);
    freq.put("丁万乙", 12);
    freq.put("丁万乘", 14);
    freq.put("丘，之", 70);
    freq.put("华乘三", 25);
    freq.put("乘的人", 25);
    freq.put("专且丁", 84);
    freq.put("之丛，", 35);
    freq.put("三且，", 43);
    freq.put("丘之俩", 8);
    freq.put("临人", 186);
    freq.put("的丈", 71);
    freq.put("之乘是", 18);
    freq.put("之丛？", 58);
    freq.put("国万 ", 34);
    freq.put("临亨", 8);
    freq.put("的万", 264);
    freq.put("临亥", 34);
    freq.put("三日", 165);
    freq.put("三之于", 31);
    freq.put("大丁 ", 8);
    freq.put("临仞", 14);
    freq.put("一乙三", 8);
    freq.put("丁万三", 169);
    freq.put("丁万万", 37);
    freq.put("临仗", 124);
    freq.put("丙丁仗", 7);
    freq.put("临仕", 15);
    freq.put("丁万丁", 115);
    freq.put("丁万一", 7);
    freq.put("丁万丛", 14);
    freq.put("丁万丙", 10);
    freq.put("之年", 268);
    freq.put("丁万且", 21);
    freq.put("丁万专", 110);
    freq.put("华乘之", 16);
    freq.put("三之仗", 54);
    freq.put("丁之国", 27);
    freq.put("丁万丢", 8);
    freq.put("之日 ", 7);
    freq.put("临丹", 743);
    freq.put("丁万丹", 24);
    freq.put("万是", 127);
    freq.put("丁万临", 50);
    freq.put("的丛", 255);
    freq.put("亂的", 12);
    freq.put(" 丘丫", 9);
    freq.put("临乱之", 12);
    freq.put("三专俘", 14);
    freq.put("丙丁丙", 8);
    freq.put("乘的丢", 7);
    freq.put("临丘", 607);
    freq.put("三之临", 391);
    freq.put("三之为", 20);
    freq.put("三之丹", 202);
    freq.put("临丕", 8);
    freq.put("丹的。", 10);
    freq.put("临专", 2648);
    freq.put("临丐", 26);
    freq.put("临丑", 64);
    freq.put("三之丢", 60);
    freq.put("丘俘", 44);
    freq.put("乘的临", 27);
    freq.put("丙丁三", 38);
    freq.put("临丈", 110);
    freq.put("临三", 2844);
    freq.put("临万", 413);
    freq.put("丙丁万", 8);
    freq.put("专日之", 7);
    freq.put("三之中", 53);
    freq.put("临丁", 1710);
    freq.put("三之专", 1150);
    freq.put("三之丑", 21);
    freq.put("三之丐", 17);
    freq.put("临为", 32);
    freq.put("丘人专", 48);
    freq.put("乘的丁", 32);
    freq.put("乘的一", 9);
    freq.put("三之丛", 177);
    freq.put("丙丁临", 29);
    freq.put("丁人。", 10);
    freq.put("三之丘", 195);
    freq.put("乘的三", 59);
    freq.put("的专", 1691);
    freq.put("三专俩", 16);
    freq.put("三之一", 175);
    freq.put("乘的专", 53);
    freq.put("临丫", 11);
    freq.put("丹", 14770);
    freq.put("三之三", 1759);
    freq.put("三之丈", 35);
    freq.put("乘的丛", 11);
    freq.put("乘的丘", 14);
    freq.put("临乞", 17);
    freq.put("三之乱", 61);
    freq.put("是「", 10);
    freq.put("万。。", 20);
    freq.put("丙丁乘", 15);
    freq.put("临乘", 671);
    freq.put("临乙", 429);
    freq.put("是。", 12);
    freq.put("浏", 30);
    freq.put("临临", 1242);
    freq.put("临乎", 70);
    freq.put("啧啧啧", 7);
    freq.put("临临在", 7);
    freq.put("临之", 2895);
    freq.put("临么", 183);
    freq.put("专日三", 29);
    freq.put("之乱专", 19);
    freq.put("？丹", 69);
    freq.put("三之乙", 132);
    freq.put("三之乘", 187);
    freq.put("乘的之", 64);
    freq.put("专日丹", 7);
    freq.put("临乱", 137);
    freq.put("丘专 ", 105);
    freq.put("丁万人", 14);
    freq.put("一万 ", 27);
    freq.put("三之之", 1050);
    freq.put("之乱三", 31);
    freq.put("三之么", 82);
    freq.put("三之乎", 30);
    freq.put("乘的乙", 18);
    freq.put("乘的乘", 9);
    freq.put("＂", 116);
    freq.put("之大", 262);
    freq.put("丛丛丛", 12);
    freq.put("的丢", 99);
    freq.put("于国之", 14);
    freq.put("丛丛专", 19);
    freq.put("之国的", 18);
    freq.put("丛丛三", 20);
    freq.put("。→", 7);
    freq.put("丛丛丁", 11);
    freq.put("丛丛丹", 7);
    freq.put("三拼", 9);
    freq.put("暧", 8);
    freq.put("俩～", 14);
    freq.put("丁之冲", 8);
    freq.put("丁的人", 28);
    freq.put("之，俩", 9);
    freq.put("万的之", 37);
    freq.put("专。。", 70);
    freq.put(" 三华", 41);
    freq.put("乙丘。", 7);
    freq.put("丛丛乘", 12);
    freq.put("乙万 ", 8);
    freq.put("乘三，", 55);
    freq.put("之临乙", 23);
    freq.put("。三 ", 11);
    freq.put("于国三", 10);
    freq.put("于国专", 7);
    freq.put("丛丛之", 25);
    freq.put("三么 ", 47);
    freq.put("专乙。", 18);
    freq.put("俩：", 12);
    freq.put("在，丹", 10);
    freq.put("俩，", 71);
    freq.put("俩！", 9);
    freq.put("专之！", 23);
    freq.put("专」 ", 7);
    freq.put("么一之", 7);
    freq.put("丢三，", 27);
    freq.put("丁的专", 159);
    freq.put("专么乘", 14);
    freq.put("专么乙", 14);
    freq.put("三临。", 53);
    freq.put("丁的丛", 36);
    freq.put("丁的丘", 16);
    freq.put("丁的丙", 16);
    freq.put("丁的万", 28);
    freq.put("是，", 72);
    freq.put("乘乱三", 11);
    freq.put("丁的一", 19);
    freq.put("丁的丁", 124);
    freq.put("专么么", 46);
    freq.put("是专丁", 50);
    freq.put("专么之", 42);
    freq.put("¯︶¯", 7);
    freq.put("专么乎", 7);
    freq.put("丁的三", 178);
    freq.put(" 丘丛", 18);
    freq.put("丁的临", 37);
    freq.put("？乙", 16);
    freq.put("丙乱之", 9);
    freq.put("丁的丹", 18);
    freq.put("华》专", 8);
    freq.put("丁的丢", 7);
    freq.put("丫。", 11);
    freq.put("专么专", 56);
    freq.put("专么且", 8);
    freq.put("专么丘", 7);
    freq.put("是三的", 10);
    freq.put("丁的乘", 60);
    freq.put("丁的乙", 15);
    freq.put("专么一", 16);
    freq.put("专么丁", 51);
    freq.put("丛的乙", 8);
    freq.put("专么万", 13);
    freq.put("专么三", 87);
    freq.put("丘，一", 15);
    freq.put("丁的之", 107);
    freq.put("丁的么", 11);
    freq.put("的乞", 7);
    freq.put("丙乱三", 8);
    freq.put("！！ ", 104);
    freq.put("丁的乱", 8);
    freq.put("丢，", 140);
    freq.put("专么丹", 18);
    freq.put("专么丢", 13);
    freq.put("万之 ", 178);
    freq.put("丢？", 10);
    freq.put("劈冲丁", 16);
    freq.put("丢：", 25);
    freq.put("之于华", 37);
    freq.put("的乘", 251);
    freq.put("是丛三", 11);
    freq.put("？么", 8);
    freq.put("在且之", 10);
    freq.put("丈丘，", 8);
    freq.put("是丛专", 8);
    freq.put("三且丁", 113);
    freq.put("丢", 3800);
    freq.put("仕丛", 13);
    freq.put("《中国", 18);
    freq.put("专且乘", 16);
    freq.put("专人 ", 36);
    freq.put("仕专", 10);
    freq.put("仕三", 19);
    freq.put("是丛临", 11);
    freq.put(" 之年", 38);
    freq.put("》丁", 22);
    freq.put("三且丛", 15);
    freq.put("傀三", 21);
    freq.put("之丛丛", 16);
    freq.put("丘。且", 10);
    freq.put("三年的", 9);
    freq.put("丁亟 ", 7);
    freq.put("在且三", 12);
    freq.put(" ╯▽", 11);
    freq.put("在且专", 10);
    freq.put("在是", 43);
    freq.put("之俩，", 12);
    freq.put(" 日在", 22);
    freq.put("三且专", 108);
    freq.put("三。 ", 215);
    freq.put("佛大", 22);
    freq.put("之，人", 8);
    freq.put("俘专专", 8);
    freq.put(" 日", 618);
    freq.put("么乘三", 17);
    freq.put("之，么", 15);
    freq.put("爬三", 11);
    freq.put("么乘专", 20);
    freq.put("专？ ", 42);
    freq.put("傀丛", 9);
    freq.put("劈。", 21);
    freq.put("一乙，", 11);
    freq.put("丈之 ", 14);
    freq.put("之，乘", 102);
    freq.put("之，乙", 41);
    freq.put("且临的", 15);
    freq.put("丢丘之", 11);
    freq.put("吱", 14);
    freq.put("丢乙的", 11);
    freq.put("之，乱", 15);
    freq.put("么乘丹", 8);
    freq.put("大，", 48);
    freq.put("之，万", 72);
    freq.put("之，一", 39);
    freq.put("之，丁", 196);
    freq.put("么乘之", 27);
    freq.put("么丁的", 15);
    freq.put(" 丹的", 70);
    freq.put("之，三", 359);
    freq.put("咚！", 8);
    freq.put("之，且", 149);
    freq.put("之，专", 265);
    freq.put("乙丢 ", 13);
    freq.put("之：乘", 10);
    freq.put("之，丘", 50);
    freq.put("丹丹丛", 10);
    freq.put("之，丛", 35);
    freq.put("三人的", 22);
    freq.put("之，丢", 17);
    freq.put("华专专", 38);
    freq.put("之，中", 16);
    freq.put("丢冲专", 21);
    freq.put("一乙：", 11);
    freq.put("之，临", 102);
    freq.put("之，丰", 8);
    freq.put("之，丹", 161);
    freq.put("之，为", 11);
    freq.put("国万专", 19);
    freq.put("且三仗", 14);
    freq.put("丛亟", 7);
    freq.put("😭", 22);
    freq.put("丁丁仗", 32);
    freq.put("人。", 78);
    freq.put("丁仗", 238);
    freq.put("丛于", 17);
    freq.put("丁仞", 26);
    freq.put("中三之", 70);
    freq.put("丛人", 67);
    freq.put("）、 ", 9);
    freq.put("丐之。", 7);
    freq.put("是之 ", 7);
    freq.put("之为 ", 15);
    freq.put("丛亥", 18);
    freq.put("丙一", 29);
    freq.put("丁亂", 10);
    freq.put("丛仗", 66);
    freq.put("中。", 21);
    freq.put("的三的", 8);
    freq.put("专三：", 47);
    freq.put("丁丁于", 13);
    freq.put("专三？", 24);
    freq.put("丛仞", 9);
    freq.put("丁于", 93);
    freq.put("且三于", 7);
    freq.put("丹丹万", 23);
    freq.put("专三（", 8);
    freq.put("中三临", 19);
    freq.put("丁亟", 31);
    freq.put("之丛么", 8);
    freq.put("丁丁亥", 9);
    freq.put("撸之", 11);
    freq.put("三，国", 9);
    freq.put("丁亥", 62);
    freq.put("之丛之", 142);
    freq.put("且三人", 11);
    freq.put("中三丁", 28);
    freq.put("丁亨", 14);
    freq.put("中三万", 26);
    freq.put("中三丘", 8);
    freq.put("中三丛", 10);
    freq.put("中三专", 54);
    freq.put("丁人", 412);
    freq.put("丁丁人", 35);
    freq.put("丛专", 909);
    freq.put("丛丑", 23);
    freq.put("丛丐", 16);
    freq.put("且三乘", 52);
    freq.put("且三乙", 19);
    freq.put("丛且", 123);
    freq.put("丛丛", 263);
    freq.put("丁么", 509);
    freq.put("丛丙", 94);
    freq.put("丛丘", 211);
    freq.put("丁丁么", 32);
    freq.put("丁丁之", 413);
    freq.put("丁乎", 257);
    freq.put("丛丁", 537);
    freq.put("丛一", 38);
    freq.put("丛万", 176);
    freq.put("且三之", 193);
    freq.put("丁乙", 780);
    freq.put("丁乘", 730);
    freq.put("丛三", 957);
    freq.put("丛丈", 34);
    freq.put("丁丁乙", 84);
    freq.put("丁丁乘", 80);
    freq.put("丁乞", 13);
    freq.put("乘之是", 12);
    freq.put("丛临", 444);
    freq.put("丛为", 17);
    freq.put("丛丹", 250);
    freq.put("三丛！", 13);
    freq.put("丁乱", 227);
    freq.put("丛丢", 66);
    freq.put("丁丁乱", 21);
    freq.put("傀之", 15);
    freq.put("丛丫", 8);
    freq.put("丁乘是", 7);
    freq.put("丛中", 38);
    freq.put("丁丁", 3738);
    freq.put("丁一", 256);
    freq.put("丁丁万", 103);
    freq.put("丁丁丁", 318);
    freq.put("丁丁一", 30);
    freq.put("丁万", 1032);
    freq.put("且三丛", 22);
    freq.put("丁三", 5161);
    freq.put("丁丈", 170);
    freq.put("丛乙", 132);
    freq.put("丛乘", 194);
    freq.put("丁丁三", 498);
    freq.put("丁丁丈", 7);
    freq.put("，临国", 16);
    freq.put("且三专", 168);
    freq.put("丁丑", 90);
    freq.put("丁丐", 52);
    freq.put("丁专", 3809);
    freq.put("三的《", 11);
    freq.put("丁之华", 8);
    freq.put("丁丁专", 348);
    freq.put("丁丙", 458);
    freq.put("丁丘", 912);
    freq.put("丁丛", 965);
    freq.put("丛么", 94);
    freq.put("三的。", 33);
    freq.put("丁丁丘", 98);
    freq.put("丁丁丛", 71);
    freq.put("丛乱", 38);
    freq.put("丁丢", 254);
    freq.put("且三丹", 49);
    freq.put("且三为", 13);
    freq.put("丁丁丢", 14);
    freq.put("丁丁中", 13);
    freq.put("丁丫", 7);
    freq.put("丁中", 96);
    freq.put("丁丁临", 156);
    freq.put("丁丁丰", 9);
    freq.put("丁丹", 778);
    freq.put("丢临，", 11);
    freq.put("专丰之", 11);
    freq.put("丁为", 54);
    freq.put("丁丁丹", 90);
    freq.put("且三丢", 12);
    freq.put("丹亟 ", 8);
    freq.put("于中国", 8);
    freq.put("之年丹", 7);
    freq.put("之年临", 16);
    freq.put("俘的", 38);
    freq.put("丁俘", 58);
    freq.put("乎年", 10);
    freq.put("丁丁俘", 8);
    freq.put(" 年 ", 132);
    freq.put("丑。 ", 8);
    freq.put("乙乘之", 9);
    freq.put("丁俩", 85);
    freq.put("丁丁俩", 9);
    freq.put("之三于", 28);
    freq.put("之年专", 21);
    freq.put("乘： ", 9);
    freq.put("之年三", 54);
    freq.put("一大丁", 14);
    freq.put("专坏", 21);
    freq.put("之年万", 16);
    freq.put("的丛人", 8);
    freq.put("之年丁", 7);
    freq.put(" 、专", 25);
    freq.put("一三：", 8);
    freq.put("丁侄", 7);
    freq.put("丛俘", 26);
    freq.put("的丘专", 33);
    freq.put("一三，", 73);
    freq.put("。乙三", 9);
    freq.put(" 机", 12);
    freq.put("一三！", 9);
    freq.put("之俘之", 8);
    freq.put("丁侥", 12);
    freq.put(" 月", 497);
    freq.put("？」", 10);
    freq.put("乙丙的", 7);
    freq.put(" 丐 ", 10);
    freq.put("之年之", 29);
    freq.put("丛俩", 34);
    freq.put("专乎三", 48);
    freq.put("丙丘的", 9);
    freq.put("且么 ", 8);
    freq.put("的丛万", 7);
    freq.put("。。三", 48);
    freq.put("的丛丁", 30);
    freq.put("。。万", 16);
    freq.put("之丙 ", 24);
    freq.put("。。丁", 40);
    freq.put("的丛三", 28);
    freq.put("三，丁", 193);
    freq.put("万三的", 68);
    freq.put("丛乘，", 10);
    freq.put("的丛专", 23);
    freq.put("三在，", 10);
    freq.put("丁佛", 30);
    freq.put("。。且", 15);
    freq.put("。。专", 44);
    freq.put("的丛丙", 7);
    freq.put(" 乘，", 7);
    freq.put(" 亥 ", 7);
    freq.put("丛三丹", 20);
    freq.put("嘱", 10);
    freq.put("之日万", 13);
    freq.put("的丛临", 30);
    freq.put("三的万", 44);
    freq.put("。。丹", 56);
    freq.put("。。临", 15);
    freq.put("的乘临", 33);
    freq.put("。。之", 23);
    freq.put("丛佛", 7);
    freq.put("的丛之", 29);
    freq.put("国之大", 8);
    freq.put("。。乘", 21);
    freq.put("大丁之", 28);
    freq.put("临丹是", 8);
    freq.put("。在", 33);
    freq.put("中之", 211);
    freq.put("大万的", 10);
    freq.put("之专月", 7);
    freq.put("丹仗 ", 16);
    freq.put("三（ ", 19);
    freq.put("中乙", 21);
    freq.put("中乘", 12);
    freq.put("在一之", 37);
    freq.put("丐之专", 7);
    freq.put("！丹之", 8);
    freq.put("临。丁", 18);
    freq.put("专乎专", 22);
    freq.put(" 年，", 34);
    freq.put("万仗，", 12);
    freq.put("中万", 60);
    freq.put("中丁", 135);
    freq.put("中一", 9);
    freq.put("中三", 515);
    freq.put("中且", 10);
    freq.put("万乱，", 7);
    freq.put("！丹丹", 8);
    freq.put("中专", 121);
    freq.put("！丹临", 7);
    freq.put("是丹的", 41);
    freq.put("中丘", 27);
    freq.put("中丛", 25);
    freq.put("丛？丹", 15);
    freq.put("三之（", 13);
    freq.put("！丹三", 16);
    freq.put("的俩", 26);
    freq.put("！丹丁", 11);
    freq.put("临之在", 11);
    freq.put("╮", 41);
    freq.put("人？ ", 7);
    freq.put("中临", 47);
    freq.put("一三 ", 76);
    freq.put("万专在", 12);
    freq.put("万丁的", 19);
    freq.put("中丹", 35);
    freq.put("！丹专", 13);
    freq.put("专是丁", 82);
    freq.put("专是一", 38);
    freq.put("丛】", 14);
    freq.put("华丁的", 8);
    freq.put("三的乙", 33);
    freq.put("专是三", 185);
    freq.put("》", 547);
    freq.put(" 乘 ", 22);
    freq.put("仞仞仞", 12);
    freq.put("专是专", 108);
    freq.put("华之临", 10);
    freq.put("乱的", 70);
    freq.put("三的么", 9);
    freq.put("专是丙", 12);
    freq.put("华之丹", 7);
    freq.put("专是丛", 28);
    freq.put("丛」", 10);
    freq.put("华之丁", 17);
    freq.put("专是丢", 12);
    freq.put("乙冲，", 13);
    freq.put("华之万", 7);
    freq.put("华之三", 32);
    freq.put("么丹之", 16);
    freq.put("专是中", 10);
    freq.put("是", 5823);
    freq.put("三的乱", 12);
    freq.put("在冲", 9);
    freq.put("华之专", 18);
    freq.put("劈亟", 7);
    freq.put("专是临", 46);
    freq.put("专是丹", 61);
    freq.put("三在 ", 21);
    freq.put("专是为", 8);
    freq.put("三大之", 52);
    freq.put("丁、", 120);
    freq.put("国丹三", 9);
    freq.put("丁。", 557);
    freq.put("丁丁、", 17);
    freq.put("三的丛", 49);
    freq.put("三的丘", 52);
    freq.put("三的丙", 27);
    freq.put("专是么", 14);
    freq.put("专是之", 85);
    freq.put("丁《", 39);
    freq.put("丁」", 25);
    freq.put("丁「", 17);
    freq.put("三大丹", 10);
    freq.put("专是乎", 29);
    freq.put("丁】", 78);
    freq.put("丁【", 7);
    freq.put("丁丁】", 12);
    freq.put("三的丈", 11);
    freq.put("三的三", 333);
    freq.put("专是乙", 25);
    freq.put("专是乘", 51);
    freq.put("且三。", 9);
    freq.put("之的三", 203);
    freq.put("么丹丁", 9);
    freq.put("三大专", 53);
    freq.put("三的丹", 19);
    freq.put("么丹三", 21);
    freq.put("三的临", 84);
    freq.put("华之之", 21);
    freq.put("三大丛", 8);
    freq.put("乘日", 28);
    freq.put("专是乱", 12);
    freq.put("三的中", 12);
    freq.put("三大丁", 26);
    freq.put("华之乙", 7);
    freq.put(" 刨 ", 12);
    freq.put("三的丢", 14);
    freq.put("三大三", 58);
    freq.put("三三 ", 1019);
    freq.put(" ～ ", 8);
    freq.put("之中国", 65);
    freq.put("专乎丛", 12);
    freq.put("丛之是", 10);
    freq.put("人乘之", 11);
    freq.put("是么之", 8);
    freq.put("临！ ", 31);
    freq.put("坤专之", 9);
    freq.put("丘专乘", 15);
    freq.put("之年。", 9);
    freq.put(" 专是", 117);
    freq.put("。」 ", 9);
    freq.put("丘么临", 12);
    freq.put("乱乙三", 7);
    freq.put("乙丁的", 30);
    freq.put("乱乙丁", 8);
    freq.put("三丛：", 7);
    freq.put("临；三", 7);
    freq.put("坤", 493);
    freq.put("于华", 262);
    freq.put("人乘三", 10);
    freq.put("三乘大", 15);
    freq.put("专三 ", 486);
    freq.put("临万专", 44);
    freq.put("之机的", 9);
    freq.put("临万且", 7);
    freq.put("之么丹", 7);
    freq.put("临万丛", 8);
    freq.put("临万丘", 9);
    freq.put("。。。", 741);
    freq.put("！丁之", 14);
    freq.put(" 在之", 23);
    freq.put("临万丁", 20);
    freq.put("临万万", 22);
    freq.put("日三在", 7);
    freq.put("临万三", 71);
    freq.put("之仞 ", 9);
    freq.put("丢之丁", 17);
    freq.put("丁大，", 8);
    freq.put("临万临", 37);
    freq.put("临万丹", 13);
    freq.put("临之国", 19);
    freq.put("！丁丁", 10);
    freq.put(" 在专", 32);
    freq.put("　三且", 8);
    freq.put("。于", 15);
    freq.put("！丁三", 8);
    freq.put(" 在三", 29);
    freq.put("丘专乱", 7);
    freq.put("丢临 ", 14);
    freq.put("临万之", 46);
    freq.put(" 在丁", 11);
    freq.put("乩么丁", 13);
    freq.put(" 在万", 7);
    freq.put(" 在丹", 17);
    freq.put("三么的", 20);
    freq.put(" 在中", 11);
    freq.put("临之仗", 11);
    freq.put("三临于", 15);
    freq.put("乘月", 13);
    freq.put("专人，", 49);
    freq.put("丈", 2001);
    freq.put("专。丹", 23);
    freq.put("啧啧", 22);
    freq.put("专乙乱", 7);
    freq.put("临丹临", 33);
    freq.put("丛丛。", 12);
    freq.put("专。专", 42);
    freq.put("乙丘丘", 11);
    freq.put("丈丘 ", 11);
    freq.put("专。且", 30);
    freq.put("专乙之", 66);
    freq.put("乙丘专", 33);
    freq.put("三临亥", 7);
    freq.put("华》华", 13);
    freq.put("哔哔哔", 16);
    freq.put("乙丘三", 34);
    freq.put("三临人", 27);
    freq.put("专。万", 7);
    freq.put("专乙乙", 30);
    freq.put("专乙乘", 13);
    freq.put("专乙丢", 8);
    freq.put("侏亨", 12);
    freq.put("侏亥", 27);
    freq.put("丁专】", 11);
    freq.put("乘中国", 19);
    freq.put("专乙临", 35);
    freq.put("三临仗", 19);
    freq.put("专乙丹", 9);
    freq.put("之三大", 44);
    freq.put("专乙丁", 48);
    freq.put("专乙万", 35);
    freq.put("专乙三", 81);
    freq.put(" ； ", 17);
    freq.put("专乙专", 64);
    freq.put("乙丘之", 37);
    freq.put("专乙且", 14);
    freq.put("专乙丛", 16);
    freq.put("专。之", 43);
    freq.put("专乙丙", 10);
    freq.put("专乙丘", 29);
    freq.put("之，大", 16);
    freq.put("之于之", 9);
    freq.put("三临丈", 12);
    freq.put("三临三", 427);
    freq.put("丫之", 12);
    freq.put("三临万", 80);
    freq.put("三临一", 24);
    freq.put("三临丁", 252);
    freq.put("丙】", 7);
    freq.put("！之三", 20);
    freq.put("丁的。", 21);
    freq.put("三临丛", 50);
    freq.put("三临丘", 83);
    freq.put("三临丙", 21);
    freq.put("乎丛三", 7);
    freq.put("三临且", 41);
    freq.put("丹之，", 38);
    freq.put("三临专", 342);
    freq.put("三临丑", 7);
    freq.put("三临中", 11);
    freq.put("侏之", 9);
    freq.put("之么三", 37);
    freq.put("临丘大", 11);
    freq.put("三临丢", 28);
    freq.put("临三且", 28);
    freq.put("专乙仗", 7);
    freq.put("是专万", 25);
    freq.put("三临丹", 84);
    freq.put("人俘", 8);
    freq.put("三临临", 157);
    freq.put("之万的", 67);
    freq.put("三临乎", 8);
    freq.put("丫丁", 21);
    freq.put("三临之", 387);
    freq.put("三临么", 21);
    freq.put("之于三", 13);
    freq.put("之于丁", 7);
    freq.put("！之之", 13);
    freq.put("专么。", 22);
    freq.put("三临乘", 93);
    freq.put("三临乙", 66);
    freq.put("冲之，", 7);
    freq.put("之于专", 17);
    freq.put("侏三", 20);
    freq.put("丫丫", 12);
    freq.put("侏丁", 13);
    freq.put("丢之丹", 8);
    freq.put("之乱 ", 14);
    freq.put("乙丢，", 7);
    freq.put("是丙丁", 7);
    freq.put("丫临", 16);
    freq.put("侏专", 18);
    freq.put("三临乱", 23);
    freq.put("专丁？", 7);
    freq.put("机之人", 13);
    freq.put("乙之。", 23);
    freq.put("仗的三", 17);
    freq.put("年之，", 13);
    freq.put("乙万三", 21);
    freq.put(" 的人", 9);
    freq.put("临乙三", 55);
    freq.put(" 为侄", 12);
    freq.put("乘是", 132);
    freq.put("乞三之", 7);
    freq.put("的冲专", 7);
    freq.put("丁专华", 50);
    freq.put("丛万丁", 13);
    freq.put("临乙万", 9);
    freq.put("的丰丁", 8);
    freq.put("丛万万", 9);
    freq.put("丛万三", 32);
    freq.put("临乙丁", 30);
    freq.put("丛万专", 34);
    freq.put("在临之", 14);
    freq.put("三临俘", 8);
    freq.put("丛专。", 12);
    freq.put("俩 ", 117);
    freq.put("、临丁", 10);
    freq.put("丘。。", 13);
    freq.put("乘三 ", 98);
    freq.put("三么？", 16);
    freq.put("日之三", 22);
    freq.put("三临俩", 12);
    freq.put("乙万，", 9);
    freq.put("丛万临", 10);
    freq.put("三么，", 21);
    freq.put("乘乘的", 10);
    freq.put("三丁年", 14);
    freq.put("三么！", 14);
    freq.put("日之专", 15);
    freq.put(" 氪 ", 17);
    freq.put("丛丹的", 9);
    freq.put("劈丛", 7);
    freq.put("劈专", 13);
    freq.put("劈丐", 13);
    freq.put("临乙丛", 8);
    freq.put(" 为丁", 11);
    freq.put("劈且", 7);
    freq.put("专之的", 186);
    freq.put("劈丈", 7);
    freq.put("劈三", 38);
    freq.put("劈丁", 17);
    freq.put("劈万", 10);
    freq.put("万大之", 7);
    freq.put("劈丹", 7);
    freq.put("大", 2562);
    freq.put(" 的万", 10);
    freq.put("之临之", 303);
    freq.put("丢三 ", 28);
    freq.put("丹： ", 16);
    freq.put("； ", 158);
    freq.put("仗的人", 7);
    freq.put(" 的专", 48);
    freq.put("丹人三", 13);
    freq.put("，丙之", 18);
    freq.put(" 为乎", 80);
    freq.put("丢 ", 231);
    freq.put("万大专", 11);
    freq.put("劈之", 38);
    freq.put("万之，", 116);
    freq.put("万之！", 17);
    freq.put("亞丁三", 7);
    freq.put("万大三", 11);
    freq.put("仞", 267);
    freq.put(" 的之", 30);
    freq.put("，丙专", 13);
    freq.put("乙三是", 11);
    freq.put("劈乱", 7);
    freq.put("，丙丘", 7);
    freq.put("，丙丛", 9);
    freq.put("。为之", 7);
    freq.put("，丙丁", 19);
    freq.put("，丙三", 19);
    freq.put("临之华", 11);
    freq.put("，是", 143);
    freq.put("之丛 ", 170);
    freq.put("三且 ", 43);
    freq.put("么万之", 9);
    freq.put("且大", 37);
    freq.put("丢且之", 14);
    freq.put("万专华", 8);
    freq.put("三三仗", 56);
    freq.put("厥", 35);
    freq.put("是俩", 13);
    freq.put("三丁大", 13);
    freq.put("国人之", 17);
    freq.put("日临之", 8);
    freq.put("万三？", 8);
    freq.put("咚！咚", 7);
    freq.put("且丘乘", 8);
    freq.put("专在的", 32);
    freq.put("专、临", 7);
    freq.put("丘《", 8);
    freq.put("丘》", 28);
    freq.put("之日，", 22);
    freq.put("丘。", 199);
    freq.put("三专】", 28);
    freq.put("是侄", 7);
    freq.put("是侃", 7);
    freq.put("么万专", 14);
    freq.put("三三人", 124);
    freq.put("三三亥", 31);
    freq.put("三专《", 7);
    freq.put("专是", 1026);
    freq.put("且丘丹", 8);
    freq.put("么万三", 16);
    freq.put("三专。", 114);
    freq.put("三专、", 42);
    freq.put("丘】", 20);
    freq.put("丢且三", 8);
    freq.put("国人丹", 8);
    freq.put("机之，", 10);
    freq.put("临专》", 14);
    freq.put("且丘三", 15);
    freq.put("三三亟", 9);
    freq.put("丹万 ", 16);
    freq.put("临专。", 45);
    freq.put("国人三", 36);
    freq.put("临专、", 13);
    freq.put("的日三", 24);
    freq.put("国人专", 19);
    freq.put("三三于", 48);
    freq.put("且丘专", 14);
    freq.put("临专】", 7);
    freq.put("三三乱", 59);
    freq.put("万三！", 7);
    freq.put("的是 ", 12);
    freq.put("之丛三", 91);
    freq.put("之专的", 212);
    freq.put("是佛", 7);
    freq.put("丁人：", 10);
    freq.put("丘乎，", 7);
    freq.put("专临的", 166);
    freq.put("倣", 22);
    freq.put("。大", 18);
    freq.put("丹三。", 25);
    freq.put("丁丛。", 29);
    freq.put("三三乙", 163);
    freq.put("三三乘", 232);
    freq.put("乘么三", 11);
    freq.put("之→", 7);
    freq.put("丁乙的", 56);
    freq.put("三三乎", 43);
    freq.put("三三么", 85);
    freq.put("三三之", 1775);
    freq.put("三三临", 522);
    freq.put("三三丰", 15);
    freq.put("丘之「", 7);
    freq.put("丘之。", 46);
    freq.put("三。。", 71);
    freq.put("三三丹", 337);
    freq.put("三三为", 76);
    freq.put("于国", 47);
    freq.put("三三丢", 98);
    freq.put("三三中", 27);
    freq.put("一万，", 11);
    freq.put("丘专，", 59);
    freq.put("为乘丁", 8);
    freq.put("三三且", 170);
    freq.put("三三丑", 21);
    freq.put("三三丐", 12);
    freq.put("三三专", 1572);
    freq.put("为乘三", 15);
    freq.put("专的专", 198);
    freq.put("三三丙", 98);
    freq.put("三三丘", 334);
    freq.put("三三丛", 185);
    freq.put("万万的", 15);
    freq.put("三三万", 576);
    freq.put("三三丁", 1052);
    freq.put("三三一", 141);
    freq.put("机专 ", 13);
    freq.put("三三三", 2325);
    freq.put("三三丈", 35);
    freq.put("于在", 26);
    freq.put("丁丈 ", 11);
    freq.put("乘乙丛", 8);
    freq.put("丹万乎", 8);
    freq.put("丹万之", 52);
    freq.put("之三年", 25);
    freq.put("丁丢，", 7);
    freq.put("是仗", 69);
    freq.put(" 乘的", 29);
    freq.put("三三俩", 11);
    freq.put("丹万乙", 12);
    freq.put("华大", 20);
    freq.put("丁（专", 7);
    freq.put("且在专", 7);
    freq.put("三三俘", 17);
    freq.put("丹的人", 17);
    freq.put("且在三", 11);
    freq.put("丘丫", 18);
    freq.put("专专的", 233);
    freq.put("且在丁", 8);
    freq.put("专国之", 10);
    freq.put("是于", 8);
    freq.put("丹万丁", 30);
    freq.put("丁万。", 12);
    freq.put("丹万三", 77);
    freq.put("乙丛 ", 25);
    freq.put("丹万专", 54);
    freq.put("丙。。", 11);
    freq.put("万丈三", 7);
    freq.put("丹万丘", 7);
    freq.put("圳之", 16);
    freq.put("》！", 8);
    freq.put("专一万", 21);
    freq.put("是亥", 14);
    freq.put("》，", 32);
    freq.put("专月", 97);
    freq.put("是人", 30);
    freq.put("，丹一", 13);
    freq.put("丹万丹", 23);
    freq.put("且丁专", 74);
    freq.put("？？", 79);
    freq.put("是乎", 108);
    freq.put("℃", 18);
    freq.put("是之", 559);
    freq.put(" 乙之", 67);
    freq.put("丹的三", 100);
    freq.put("丹的万", 11);
    freq.put("万。之", 7);
    freq.put("丹的一", 13);
    freq.put("丹的丁", 57);
    freq.put("人三大", 8);
    freq.put("临」", 13);
    freq.put("临《", 22);
    freq.put("丹的丛", 17);
    freq.put("丹的丘", 17);
    freq.put("是乘", 258);
    freq.put("临三么", 23);
    freq.put("丁人临", 19);
    freq.put("丹的专", 126);
    freq.put("？！", 38);
    freq.put("临、", 83);
    freq.put("丁人三", 56);
    freq.put("三之】", 14);
    freq.put("乘的。", 9);
    freq.put("丁人丁", 18);
    freq.put("丹的丢", 10);
    freq.put("三三佛", 17);
    freq.put("丁人万", 18);
    freq.put("三之。", 277);
    freq.put("三之、", 24);
    freq.put("，丹 ", 11);
    freq.put("人三在", 7);
    freq.put("）临丹", 7);
    freq.put("三之》", 11);
    freq.put("三之《", 8);
    freq.put("丹的临", 26);
    freq.put("丁人专", 36);
    freq.put("是乱", 33);
    freq.put("之万华", 10);
    freq.put("丰专丁", 13);
    freq.put("丹的之", 73);
    freq.put("丹的么", 8);
    freq.put("是丈", 19);
    freq.put("是万", 181);
    freq.put("是丁", 531);
    freq.put("是一", 207);
    freq.put("万。且", 10);
    freq.put("是丛", 136);
    freq.put("万。专", 17);
    freq.put("是丙", 51);
    freq.put("丹的乙", 16);
    freq.put("是且", 56);
    freq.put("是专", 603);
    freq.put("一丁人", 9);
    freq.put("是丑", 20);
    freq.put("是丐", 11);
    freq.put("是中", 65);
    freq.put("丁人之", 57);
    freq.put("是丢", 61);
    freq.put("丁人乘", 17);
    freq.put("之乱。", 8);
    freq.put("仗丘 ", 7);
    freq.put("是为", 67);
    freq.put("是丹", 322);
    freq.put("是临", 230);
    freq.put("是丰", 8);
    freq.put("国临华", 7);
    freq.put("丹乙专", 15);
    freq.put("丑之 ", 13);
    freq.put("么仗", 54);
    freq.put("丹乙丛", 10);
    freq.put("。　　", 9);
    freq.put("丹乙万", 7);
    freq.put("丹乙丁", 19);
    freq.put("丹乙三", 31);
    freq.put("丹乙临", 15);
    freq.put("万之：", 19);
    freq.put("的中三", 12);
    freq.put("华（", 7);
    freq.put("丘！ ", 15);
    freq.put("乙乙，", 16);
    freq.put("乱之丁", 22);
    freq.put("且于 ", 17);
    freq.put("么亟", 25);
    freq.put("丹乙乙", 12);
    freq.put(" 【丹", 16);
    freq.put("华）", 22);
    freq.put("乘仗，", 7);
    freq.put("丘临 ", 63);
    freq.put("丹乙之", 24);
    freq.put("么人", 30);
    freq.put("乱之丛", 10);
    freq.put("万中三", 21);
    freq.put("之临万", 44);
    freq.put("之：丁", 11);
    freq.put("么亥", 12);
    freq.put("丢丘三", 9);
    freq.put("么乘", 141);
    freq.put("么乙", 127);
    freq.put("之丁俩", 12);
    freq.put("丁在三", 33);
    freq.put("之丛丘", 16);
    freq.put("』", 56);
    freq.put("专的乙", 30);
    freq.put("１", 12);
    freq.put("么之", 539);
    freq.put("么么", 456);
    freq.put("么乎", 28);
    freq.put("丛", 8840);
    freq.put("乘临且", 11);
    freq.put("乘临专", 58);
    freq.put("华，", 34);
    freq.put("么乱", 32);
    freq.put("乘临丘", 7);
    freq.put("乘临万", 7);
    freq.put("乘临丁", 48);
    freq.put("乘临一", 8);
    freq.put("专，大", 17);
    freq.put("乘临三", 52);
    freq.put("么丛", 65);
    freq.put("么丘", 99);
    freq.put("么丙", 32);
    freq.put(" 三乙", 57);
    freq.put("乘乘丛", 14);
    freq.put("么专", 479);
    freq.put("么丑", 33);
    freq.put("三丹万", 35);
    freq.put("么且", 97);
    freq.put("丘乘，", 18);
    freq.put("么丈", 23);
    freq.put("么三", 610);
    freq.put("么一", 64);
    freq.put("么丁", 308);
    freq.put("么万", 96);
    freq.put("机三专", 12);
    freq.put("么丹", 164);
    freq.put(" 三乞", 11);
    freq.put("么丰", 8);
    freq.put("专大之", 24);
    freq.put("么临", 245);
    freq.put("乘临乘", 14);
    freq.put("临之冲", 8);
    freq.put("么中", 12);
    freq.put("么丢", 36);
    freq.put("乘临之", 58);
    freq.put("丛临万", 9);
    freq.put("且的是", 7);
    freq.put("之丁乱", 27);
    freq.put("之且乘", 30);
    freq.put("＂丁", 10);
    freq.put("之丁之", 526);
    freq.put("之丁么", 67);
    freq.put("专丑三", 10);
    freq.put("么俩", 13);
    freq.put("丛临丘", 20);
    freq.put("之丁乙", 120);
    freq.put("之丁乘", 67);
    freq.put("是一专", 114);
    freq.put("之丁丢", 22);
    freq.put("俘三之", 13);
    freq.put("之丹」", 8);
    freq.put("：丹三", 15);
    freq.put("之丁中", 15);
    freq.put("之丁丰", 8);
    freq.put("专的人", 35);
    freq.put("之丁临", 219);
    freq.put("之丁为", 9);
    freq.put("之丁丹", 78);
    freq.put("丁专在", 26);
    freq.put("槟", 9);
    freq.put("之丁丁", 402);
    freq.put("之丁一", 44);
    freq.put("之丁万", 119);
    freq.put("之丁三", 538);
    freq.put("之丁丈", 17);
    freq.put("临亥的", 7);
    freq.put("之丁专", 435);
    freq.put("之丁丑", 7);
    freq.put("之丁且", 62);
    freq.put("之丁丛", 92);
    freq.put("之丁丙", 47);
    freq.put("机三三", 12);
    freq.put("么侥", 7);
    freq.put("么佛", 10);
    freq.put("万，三", 98);
    freq.put("＂，", 7);
    freq.put("，日三", 27);
    freq.put("专丛是", 9);
    freq.put("＂专", 8);
    freq.put("国乘丁", 10);
    freq.put("专日", 64);
    freq.put("在乙三", 23);
    freq.put("是中三", 10);
    freq.put("　临", 9);
    freq.put("万，一", 10);
    freq.put("之丁仗", 27);
    freq.put("三万是", 53);
    freq.put("［", 8);
    freq.put("，日", 33);
    freq.put("」 ", 43);
    freq.put("之丁亥", 11);
    freq.put("的国专", 12);
    freq.put("三侄专", 7);
    freq.put("、三三", 68);
    freq.put("之丁人", 45);
    freq.put("万，万", 18);
    freq.put("。人", 12);
    freq.put("￣▽￣", 14);
    freq.put("之丁于", 9);
    freq.put("临俘 ", 9);
    freq.put("丢丁的", 9);
    freq.put("，丁", 1221);
    freq.put("）三三", 9);
    freq.put("丁乙冲", 8);
    freq.put(" 专丛", 86);
    freq.put(" 专丘", 76);
    freq.put("之的是", 9);
    freq.put("亟丘", 14);
    freq.put(" 专专", 716);
    freq.put("且之中", 9);
    freq.put("亟专", 23);
    freq.put(" 专且", 32);
    freq.put("且之临", 48);
    freq.put(" 专三", 627);
    freq.put("在三的", 7);
    freq.put("亟三", 33);
    freq.put(" 专一", 24);
    freq.put("《之专", 9);
    freq.put("年三 ", 10);
    freq.put(" 专万", 128);
    freq.put("亟丁", 28);
    freq.put("且之丹", 47);
    freq.put("且之万", 47);
    freq.put(" 专丹", 77);
    freq.put("且之一", 26);
    freq.put("且之丁", 86);
    freq.put(" 专丰", 16);
    freq.put("丁大的", 7);
    freq.put(" 专临", 307);
    freq.put("且之三", 248);
    freq.put("且之且", 30);
    freq.put("且之专", 159);
    freq.put("专的。", 37);
    freq.put(" 专中", 7);
    freq.put(" 专丢", 18);
    freq.put("亟丢", 7);
    freq.put("且之丘", 21);
    freq.put("且之丙", 13);
    freq.put(" 专乘", 68);
    freq.put(" 专乙", 73);
    freq.put(" 三丙", 35);
    freq.put("华：", 28);
    freq.put("大人", 12);
    freq.put(" 专之", 452);
    freq.put(" 专么", 34);
    freq.put("亟之", 27);
    freq.put("亟么", 13);
    freq.put("万，中", 10);
    freq.put("是临丹", 9);
    freq.put("临俩 ", 7);
    freq.put("丹丁仗", 8);
    freq.put(" 专乱", 8);
    freq.put("且之之", 131);
    freq.put("且之么", 8);
    freq.put("＂丹", 7);
    freq.put(" 三丑", 8);
    freq.put("丹丁。", 8);
    freq.put("且之乘", 95);
    freq.put(" 且 ", 24);
    freq.put("亟亟", 21);
    freq.put(" 坤坤", 8);
    freq.put("丹丁丹", 19);
    freq.put("的丈三", 8);
    freq.put(" 三且", 102);
    freq.put("专临。", 55);
    freq.put("专国丁", 7);
    freq.put(" 专于", 33);
    freq.put("是之的", 9);
    freq.put("的丈专", 15);
    freq.put("临机专", 7);
    freq.put("丹丁丢", 8);
    freq.put(" 专人", 43);
    freq.put("丹丁丙", 15);
    freq.put("丹丁丘", 24);
    freq.put("丹丁丛", 59);
    freq.put("万，丹", 35);
    freq.put("丹丁且", 15);
    freq.put("年的 ", 8);
    freq.put("丹丁专", 107);
    freq.put("之是中", 9);
    freq.put("专，在", 20);
    freq.put("丛临乘", 10);
    freq.put("丹丁万", 24);
    freq.put("的丈临", 8);
    freq.put("丹丁丁", 144);
    freq.put("丹丁一", 7);
    freq.put("丛临乙", 9);
    freq.put("，国三", 8);
    freq.put("的丈之", 8);
    freq.put("丁丹丛", 14);
    freq.put("乙丁：", 9);
    freq.put("，丈", 49);
    freq.put("丹丁乱", 8);
    freq.put(" 专仗", 32);
    freq.put("，国万", 8);
    freq.put("乙丁，", 30);
    freq.put(" 三丁", 337);
    freq.put("之且专", 125);
    freq.put("丛专丘", 12);
    freq.put("･", 21);
    freq.put("丹丁乘", 24);
    freq.put("仗 ", 505);
    freq.put("的三 ", 31);
    freq.put("机三之", 8);
    freq.put("且之仗", 9);
    freq.put("丹丁乎", 10);
    freq.put("丹丁么", 14);
    freq.put("丹丁之", 135);
    freq.put(" 三万", 259);
    freq.put("之且三", 191);
    freq.put("庚之", 11);
    freq.put("三丹是", 11);
    freq.put("乱：", 8);
    freq.put("丐的专", 8);
    freq.put("华丁，", 22);
    freq.put("乱！", 13);
    freq.put("人：三", 9);
    freq.put("华丁：", 11);
    freq.put("乱，", 114);
    freq.put("专丛 ", 79);
    freq.put("之、之", 7);
    freq.put("丹是专", 23);
    freq.put("乙临丹", 8);
    freq.put("是大专", 9);
    freq.put("之且丁", 98);
    freq.put("临之年", 7);
    freq.put("是大三", 9);
    freq.put("万三 ", 240);
    freq.put("吾", 45);
    freq.put("庚三", 7);
    freq.put("丛万之", 24);
    freq.put("丁专大", 24);
    freq.put("万侄", 11);
    freq.put("之、临", 13);
    freq.put("之、丁", 12);
    freq.put("三， ", 85);
    freq.put("之、三", 32);
    freq.put("丁临仗", 16);
    freq.put("之、专", 16);
    freq.put("丑丁 ", 7);
    freq.put("丐三丁", 7);
    freq.put("之丢之", 43);
    freq.put("人是", 48);
    freq.put("之侏丁", 7);
    freq.put("一丢三", 22);
    freq.put("大临之", 8);
    freq.put("且中国", 12);
    freq.put("乙的 ", 19);
    freq.put("，为之", 18);
    freq.put("，为乎", 9);
    freq.put("大万，", 11);
    freq.put("华于临", 9);
    freq.put("人且三", 12);
    freq.put("华于三", 16);
    freq.put("俘 ", 64);
    freq.put("人且丁", 9);
    freq.put("华于丁", 15);
    freq.put(" 年的", 24);
    freq.put("华于专", 12);
    freq.put("人且专", 7);
    freq.put("乎！", 8);
    freq.put("大临丁", 12);
    freq.put(" 专俘", 17);
    freq.put("之丢三", 40);
    freq.put("丙丘，", 21);
    freq.put("大临三", 18);
    freq.put("之丢一", 7);
    freq.put("之丢丁", 35);
    freq.put("之丢万", 13);
    freq.put("，为三", 9);
    freq.put("之丢丛", 21);
    freq.put("之丢丘", 9);
    freq.put("是丹，", 9);
    freq.put("乙丙 ", 11);
    freq.put("之丢专", 25);
    freq.put("丙丘 ", 11);
    freq.put("。专 ", 7);
    freq.put("临丢坤", 13);
    freq.put("。日三", 8);
    freq.put("华于之", 7);
    freq.put("万丁：", 11);
    freq.put("是仗 ", 15);
    freq.put("三亟 ", 7);
    freq.put("是丘临", 16);
    freq.put(" ← ", 18);
    freq.put("大临临", 9);
    freq.put("万在之", 13);
    freq.put("乙临且", 7);
    freq.put("丙丙之", 7);
    freq.put("？专在", 7);
    freq.put("且丹之", 32);
    freq.put("么丘之", 15);
    freq.put("么人三", 8);
    freq.put("专之？", 21);
    freq.put("专之：", 37);
    freq.put("中临三", 7);
    freq.put("且丹乘", 8);
    freq.put("且丹乙", 7);
    freq.put("且在", 58);
    freq.put("专之，", 347);
    freq.put("？？？", 37);
    freq.put("临丑之", 7);
    freq.put("专之）", 8);
    freq.put("怜", 31);
    freq.put("三丁在", 30);
    freq.put("么，乘", 21);
    freq.put("🙇", 9);
    freq.put("么，之", 35);
    freq.put("么的 ", 16);
    freq.put("😱", 8);
    freq.put("且丹三", 54);
    freq.put("么，丹", 17);
    freq.put("么丘三", 7);
    freq.put("三万 ", 165);
    freq.put("且丹一", 11);
    freq.put("且丹丁", 10);
    freq.put("么丘专", 10);
    freq.put("且丹丘", 7);
    freq.put("且丹丛", 8);
    freq.put("且丹且", 15);
    freq.put("乘", 11117);
    freq.put("万之的", 44);
    freq.put("且丹专", 51);
    freq.put(" ㅠㅠ", 10);
    freq.put("么，且", 17);
    freq.put("么，专", 19);
    freq.put("😘", 8);
    freq.put("是三 ", 12);
    freq.put("😆", 7);
    freq.put("😁", 7);
    freq.put("且丹丹", 12);
    freq.put("么，三", 31);
    freq.put("😂", 7);
    freq.put("且丹临", 15);
    freq.put("丹乘 ", 23);
    freq.put("一临 ", 29);
    freq.put("么，丁", 19);
    freq.put("中国是", 8);
    freq.put(" 三人", 73);
    freq.put("三：", 308);
    freq.put("万是乎", 8);
    freq.put("万是之", 14);
    freq.put("🙇?", 7);
    freq.put("人大之", 7);
    freq.put("之国 ", 30);
    freq.put("之三国", 26);
    freq.put("年，丹", 8);
    freq.put("丘乘丁", 13);
    freq.put("之三冲", 15);
    freq.put(" ℃ ", 16);
    freq.put("▽≦ ", 9);
    freq.put("万是丹", 7);
    freq.put("三）", 61);
    freq.put("乙万的", 8);
    freq.put("万是三", 12);
    freq.put("乙乙专", 21);
    freq.put("之丐丁", 7);
    freq.put("　专专", 8);
    freq.put("。三的", 7);
    freq.put("万是丁", 14);
    freq.put("且三三", 279);
    freq.put("丛丹，", 16);
    freq.put(" 仞╁", 13);
    freq.put("临于华", 17);
    freq.put("万是专", 15);
    freq.put("乘乘，", 10);
    freq.put("是专丙", 7);
    freq.put("是专丘", 22);
    freq.put("是专丛", 19);
    freq.put("嗯，", 17);
    freq.put("于丘专", 7);
    freq.put("三仗 ", 55);
    freq.put("丙、", 27);
    freq.put("是专专", 94);
    freq.put("丙。", 80);
    freq.put("是专三", 102);
    freq.put("丙之丛", 7);
    freq.put("三的仗", 10);
    freq.put("乘丹三", 50);
    freq.put("亙", 11);
    freq.put("：么", 12);
    freq.put("【在", 7);
    freq.put("浏临", 30);
    freq.put("于丘三", 7);
    freq.put("【专临", 8);
    freq.put("是专丹", 9);
    freq.put("【专三", 8);
    freq.put("的丰专", 7);
    freq.put("是专临", 77);
    freq.put("亟三三", 8);
    freq.put("【专专", 9);
    freq.put("且临 ", 18);
    freq.put("万三：", 10);
    freq.put("≧▽≦", 9);
    freq.put("丈之的", 8);
    freq.put("三人 ", 50);
    freq.put("是专乘", 15);
    freq.put("－", 95);
    freq.put("是专么", 20);
    freq.put("是专之", 55);
    freq.put("是专乎", 8);
    freq.put("乘丹临", 12);
    freq.put("【专之", 16);
    freq.put("￣", 84);
    freq.put(" 丹 ", 36);
    freq.put("丁么，", 37);
    freq.put("。国", 7);
    freq.put("丁么？", 14);
    freq.put("：乙", 30);
    freq.put("之一 ", 14);
    freq.put("月专三", 8);
    freq.put("侄三", 27);
    freq.put("专大专", 48);
    freq.put("专人的", 50);
    freq.put("专大三", 34);
    freq.put("专大丈", 7);
    freq.put("专大丁", 19);
    freq.put("冲，三", 8);
    freq.put("侄专", 28);
    freq.put("专大万", 28);
    freq.put("专大丹", 8);
    freq.put("是专人", 8);
    freq.put("专大临", 20);
    freq.put("丛、丁", 10);
    freq.put("：丛三", 7);
    freq.put("侄丹", 10);
    freq.put("且国", 18);
    freq.put("且三一", 49);
    freq.put("侄之", 10);
    freq.put("圳专", 14);
    freq.put("赈专", 12);
    freq.put("丁仗？", 15);
    freq.put("专丈专", 18);
    freq.put("靓", 10);
    freq.put("亥之，", 7);
    freq.put("侄乘", 8);
    freq.put("圳丁", 13);
    freq.put("专一年", 10);
    freq.put("且三丁", 167);
    freq.put("三年 ", 8);
    freq.put("之临大", 19);
    freq.put("丘大三", 9);
    freq.put("且丁乘", 18);
    freq.put("的的", 8);
    freq.put("专亟 ", 7);
    freq.put("大丙", 8);
    freq.put("临乘之", 52);
    freq.put("：仗", 7);
    freq.put("是临临", 14);
    freq.put("万且 ", 11);
    freq.put("是临三", 35);
    freq.put("丘在丁", 8);
    freq.put("专专，", 380);
    freq.put("是临丁", 14);
    freq.put("丘在三", 15);
    freq.put("专俘，", 16);
    freq.put("是临丘", 9);
    freq.put("仗仗的", 8);
    freq.put("专专）", 13);
    freq.put("丘大临", 7);
    freq.put("是临专", 29);
    freq.put(" 乙仗", 14);
    freq.put("丁三亞", 7);
    freq.put("且丁人", 7);
    freq.put("丁三于", 7);
    freq.put("丛。 ", 48);
    freq.put("是临之", 48);
    freq.put("丁三人", 41);
    freq.put("且丁么", 20);
    freq.put("是临乘", 14);
    freq.put("是临乙", 8);
    freq.put("丁三亥", 11);
    freq.put("且丁之", 78);
    freq.put("丈丹 ", 9);
    freq.put("：乎", 9);
    freq.put("之丹 ", 69);
    freq.put("丁三乙", 71);
    freq.put("丁三乘", 87);
    freq.put("：之", 213);
    freq.put("，华临", 9);
    freq.put("三丁：", 39);
    freq.put("且冲", 20);
    freq.put("三万！", 10);
    freq.put("丁三乎", 16);
    freq.put("：乘", 78);
    freq.put("丁三么", 40);
    freq.put("丁三之", 678);
    freq.put(" 乙乱", 8);
    freq.put("：三", 254);
    freq.put(" 乙么", 12);
    freq.put("国专华", 9);
    freq.put("专专？", 20);
    freq.put("丛劈", 8);
    freq.put("专专；", 10);
    freq.put("专专：", 101);
    freq.put("丁三乱", 19);
    freq.put("且丁乙", 14);
    freq.put("，华专", 7);
    freq.put(" 乙乘", 19);
    freq.put(" 乙乙", 48);
    freq.put("机万，", 10);
    freq.put("丁乱 ", 17);
    freq.put("，华丁", 12);
    freq.put("：乱", 18);
    freq.put("三丁冲", 9);
    freq.put("且丁临", 44);
    freq.put("丁三丙", 48);
    freq.put("丁三丘", 169);
    freq.put("丁三丛", 61);
    freq.put("丁三且", 87);
    freq.put(" 乙丢", 11);
    freq.put("：万", 69);
    freq.put("丁三丑", 8);
    freq.put("丁三丐", 7);
    freq.put("丁三专", 562);
    freq.put("且丁丹", 27);
    freq.put(" 乙丹", 13);
    freq.put("且是在", 9);
    freq.put("丁三三", 800);
    freq.put("丁三丈", 18);
    freq.put("且丁丢", 8);
    freq.put("：丛", 26);
    freq.put("：且", 57);
    freq.put("三亥 ", 10);
    freq.put("丁三万", 234);
    freq.put("丁三丁", 413);
    freq.put("丁三一", 44);
    freq.put("：专", 144);
    freq.put("且丁且", 11);
    freq.put(" 乙三", 58);
    freq.put("丁三丹", 108);
    freq.put("》的", 22);
    freq.put("丁三临", 234);
    freq.put("且丁丘", 16);
    freq.put("丁三丰", 12);
    freq.put("：丢", 15);
    freq.put("且丁丛", 18);
    freq.put("丁三中", 33);
    freq.put("么仗？", 12);
    freq.put("乙机", 8);
    freq.put("且丁丁", 116);
    freq.put("：为", 11);
    freq.put("：临", 86);
    freq.put("：丘", 29);
    freq.put(" 乙专", 66);
    freq.put("且丁丈", 7);
    freq.put("且丁三", 121);
    freq.put("丁三丢", 23);
    freq.put("。且临", 10);
    freq.put("、万之", 9);
    freq.put("之专？", 24);
    freq.put("之专；", 10);
    freq.put("之专：", 67);
    freq.put("临丁万", 52);
    freq.put("之机丁", 12);
    freq.put("之专！", 24);
    freq.put("丙大", 10);
    freq.put("大三 ", 15);
    freq.put("。且中", 9);
    freq.put("之专，", 224);
    freq.put("三丈 ", 11);
    freq.put("之机三", 33);
    freq.put("之专（", 11);
    freq.put("丙丛专", 8);
    freq.put("。且且", 20);
    freq.put(" 丁是", 29);
    freq.put("亂 ", 9);
    freq.put("专临！", 9);
    freq.put("。且专", 31);
    freq.put("专临，", 119);
    freq.put(" 乙临", 49);
    freq.put("之机丹", 7);
    freq.put("专临）", 7);
    freq.put("临： ", 17);
    freq.put("丙丛丁", 10);
    freq.put("丁三俩", 9);
    freq.put("丙丛三", 14);
    freq.put("在三万", 29);
    freq.put("专临：", 36);
    freq.put(" 乙丈", 7);
    freq.put("ㅠㅠ", 32);
    freq.put("、万三", 14);
    freq.put("：中", 69);
    freq.put("一万的", 8);
    freq.put("丘专的", 53);
    freq.put("之机之", 19);
    freq.put("之机么", 7);
    freq.put("）的", 14);
    freq.put("丁三为", 40);
    freq.put("仗丁 ", 7);
    freq.put(" 乙丁", 52);
    freq.put("丙丛之", 25);
    freq.put("万万，", 24);
    freq.put("且！", 15);
    freq.put("国", 2959);
    freq.put("。且之", 56);
    freq.put("亂", 93);
    freq.put("的专丛", 47);
    freq.put("的专丘", 254);
    freq.put("的专丙", 9);
    freq.put("专丈丘", 10);
    freq.put("三丰三", 15);
    freq.put("的专专", 275);
    freq.put("且丁丙", 10);
    freq.put("三丰专", 23);
    freq.put("中乙之", 7);
    freq.put("临丘乙", 12);
    freq.put("丁在丁", 14);
    freq.put("之于 ", 8);
    freq.put("三丰且", 7);
    freq.put("的专三", 301);
    freq.put("的专万", 29);
    freq.put(" 乙万", 37);
    freq.put("的专丁", 118);
    freq.put(" 乙丘", 18);
    freq.put("三佛大", 18);
    freq.put("的专丹", 27);
    freq.put("专仗 ", 50);
    freq.put("的专临", 90);
    freq.put("侬", 8);
    freq.put("万？", 34);
    freq.put("丛！！", 20);
    freq.put("且丁万", 25);
    freq.put("专么丛", 7);
    freq.put("么", 5545);
    freq.put("丘丙的", 10);
    freq.put("：丹", 108);
    freq.put("淀", 12);
    freq.put("的专乘", 31);
    freq.put("的专乙", 20);
    freq.put("三丰之", 29);
    freq.put("！】", 7);
    freq.put("的专之", 230);
    freq.put("的专么", 18);
    freq.put("专丈之", 19);
    freq.put("乙是", 32);
    freq.put("临三万", 108);
    freq.put("临乘丛", 14);
    freq.put("临是 ", 7);
    freq.put("一", 5197);
    freq.put("乱临临", 7);
    freq.put("万！", 36);
    freq.put("之机专", 39);
    freq.put("之。 ", 281);
    freq.put("为 ", 85);
    freq.put("临三一", 30);
    freq.put("丑，专", 13);
    freq.put("乘专。", 17);
    freq.put("乘华之", 7);
    freq.put("万，", 559);
    freq.put("乱临专", 12);
    freq.put("，专乎", 20);
    freq.put("俘之 ", 11);
    freq.put("乙日", 10);
    freq.put("，专之", 231);
    freq.put("，专么", 19);
    freq.put("专人。", 11);
    freq.put("乱临丁", 12);
    freq.put("且三中", 7);
    freq.put("临丁三", 242);
    freq.put("，专乘", 25);
    freq.put("，专乙", 19);
    freq.put("乘华专", 8);
    freq.put("三丁华", 17);
    freq.put("，专丢", 10);
    freq.put("ω", 23);
    freq.put("乘华丁", 11);
    freq.put("，专临", 87);
    freq.put("人专 ", 30);
    freq.put("之冲是", 8);
    freq.put("，专为", 8);
    freq.put("，专丹", 45);
    freq.put("丁乎的", 15);
    freq.put("，专万", 54);
    freq.put("，专一", 26);
    freq.put("，专丁", 121);
    freq.put("，专丈", 9);
    freq.put("，专三", 310);
    freq.put("且华", 76);
    freq.put("，专且", 48);
    freq.put("丁铊中", 10);
    freq.put("，，，", 11);
    freq.put("亞 ", 10);
    freq.put("丢丁，", 20);
    freq.put("，专丛", 29);
    freq.put("，专丘", 39);
    freq.put("，专丙", 8);
    freq.put("专乘 ", 56);
    freq.put("么；", 10);
    freq.put("丁临是", 13);
    freq.put("丹丁铊", 8);
    freq.put("丰。", 7);
    freq.put("么？", 168);
    freq.put("，中国", 81);
    freq.put("丈槿冲", 11);
    freq.put("国丈", 8);
    freq.put(" 乙丙", 9);
    freq.put("，嗯", 7);
    freq.put("在的之", 7);
    freq.put("仗的 ", 8);
    freq.put("人之是", 10);
    freq.put("临乘丹", 25);
    freq.put("。华", 13);
    freq.put("。丹是", 7);
    freq.put("兕", 8);
    freq.put("的专人", 10);
    freq.put("，专人", 16);
    freq.put("｡", 22);
    freq.put("­ ", 10);
    freq.put(" 乙丛", 28);
    freq.put("，专于", 16);
    freq.put("在的三", 11);
    freq.put("丘三一", 21);
    freq.put("丘三丁", 108);
    freq.put("乘丈丁", 14);
    freq.put("丘三万", 48);
    freq.put("丘三三", 235);
    freq.put("侃之三", 7);
    freq.put("国人", 158);
    freq.put("「临", 13);
    freq.put("丘三专", 174);
    freq.put("丘三且", 19);
    freq.put("丁，丹", 80);
    freq.put("丘三丘", 59);
    freq.put("丘三丙", 11);
    freq.put("仞。", 13);
    freq.put("丘三丛", 22);
    freq.put("「丹", 12);
    freq.put("丘三丢", 11);
    freq.put("乙仗 ", 24);
    freq.put("三丘是", 14);
    freq.put("俩，丁", 8);
    freq.put("丁，万", 35);
    freq.put("临三仗", 13);
    freq.put("。且万", 14);
    freq.put("丁，一", 19);
    freq.put("俩，三", 13);
    freq.put("「且", 8);
    freq.put("丘三临", 64);
    freq.put("「专", 33);
    freq.put("丁，丘", 33);
    freq.put("丛的之", 18);
    freq.put("ω ", 9);
    freq.put("丘三为", 12);
    freq.put("丁，专", 146);
    freq.put("「丘", 10);
    freq.put("之丘仗", 7);
    freq.put("专华 ", 59);
    freq.put("丘三么", 11);
    freq.put("临的。", 20);
    freq.put("丘三之", 200);
    freq.put("丘三乘", 24);
    freq.put("丘三乙", 24);
    freq.put("丁，乱", 14);
    freq.put("三（丁", 10);
    freq.put("三乘在", 15);
    freq.put("之临？", 8);
    freq.put("丛的丘", 7);
    freq.put("丁，之", 176);
    freq.put("之临：", 7);
    freq.put("。且三", 28);
    freq.put("俩，之", 8);
    freq.put("丛的专", 37);
    freq.put("之临，", 97);
    freq.put("丘三乱", 8);
    freq.put("临三于", 11);
    freq.put("丛的三", 49);
    freq.put("丢丛 ", 14);
    freq.put("丁，乙", 16);
    freq.put("乞，", 11);
    freq.put("【华", 15);
    freq.put("之临！", 9);
    freq.put("国临", 116);
    freq.put("乘三丁", 151);
    freq.put("之一临", 42);
    freq.put("国丹", 26);
    freq.put("临三乱", 17);
    freq.put("国丢", 8);
    freq.put("国中", 7);
    freq.put("之丘乱", 9);
    freq.put("国且", 26);
    freq.put("之之？", 18);
    freq.put("之丘之", 108);
    freq.put("临三乘", 62);
    freq.put("临三乙", 38);
    freq.put("之之；", 13);
    freq.put("之之：", 24);
    freq.put("。刨", 9);
    freq.put("国丘", 32);
    freq.put("国丛", 75);
    freq.put("之丘乘", 18);
    freq.put("之之，", 284);
    freq.put("国万", 167);
    freq.put("国丁", 185);
    freq.put("之之（", 8);
    freq.put("临三之", 332);
    freq.put("丘三人", 12);
    freq.put("之之！", 35);
    freq.put("拼之", 20);
    freq.put("国乱", 14);
    freq.put("临三丹", 62);
    freq.put("丛的人", 9);
    freq.put("临三临", 132);
    freq.put("之丘丢", 19);
    freq.put("之丘丹", 21);
    freq.put("之万大", 14);
    freq.put("丘三仗", 7);
    freq.put(" 丑之", 16);
    freq.put("之丘临", 78);
    freq.put("乱之专", 28);
    freq.put("之丘三", 110);
    freq.put("临三丘", 127);
    freq.put("临三丙", 26);
    freq.put("临三丛", 46);
    freq.put("么！ ", 27);
    freq.put("之丘丁", 101);
    freq.put("国乙", 16);
    freq.put("丁三侏", 9);
    freq.put("之丘万", 48);
    freq.put("之丘丘", 44);
    freq.put("之丘丙", 17);
    freq.put("之丘丛", 31);
    freq.put("临三丈", 12);
    freq.put("临三三", 496);
    freq.put("专中三", 33);
    freq.put(" 是万", 7);
    freq.put("人三华", 18);
    freq.put("乘三且", 44);
    freq.put("之丘专", 117);
    freq.put("。万", 89);
    freq.put("国么", 7);
    freq.put("国之", 299);
    freq.put("三是 ", 60);
    freq.put(" 人，", 12);
    freq.put("　　　", 100);
    freq.put("乱之，", 16);
    freq.put("丁（ ", 9);
    freq.put("丹，乘", 11);
    freq.put(" 是丁", 13);
    freq.put("亥乘人", 7);
    freq.put("华丁万", 10);
    freq.put("乘三丛", 33);
    freq.put("三丹！", 10);
    freq.put("乎乎么", 13);
    freq.put("丢三丁", 26);
    freq.put("三丹，", 43);
    freq.put("大俩", 11);
    freq.put("、专之", 10);
    freq.put("机三，", 7);
    freq.put("乱是", 22);
    freq.put("三丹：", 7);
    freq.put(" ！ ", 20);
    freq.put("之丁大", 32);
    freq.put("三並亂", 7);
    freq.put("、专临", 18);
    freq.put("的丙之", 9);
    freq.put("，么", 102);
    freq.put("。丘三", 9);
    freq.put("丹丹 ", 32);
    freq.put("乘在丹", 8);
    freq.put("临么 ", 18);
    freq.put("、专专", 25);
    freq.put("乘乙 ", 11);
    freq.put("乘在丁", 11);
    freq.put("，乙仗", 8);
    freq.put("乎乎三", 9);
    freq.put("华丁专", 43);
    freq.put("乘在三", 19);
    freq.put(" 是专", 12);
    freq.put("、专丁", 15);
    freq.put("→ ", 86);
    freq.put("、专三", 30);
    freq.put("，乙临", 11);
    freq.put(" 丁一", 9);
    freq.put("，乙丹", 7);
    freq.put("是一临", 11);
    freq.put(" 么么", 54);
    freq.put("冲。", 7);
    freq.put("之，于", 10);
    freq.put("人，", 246);
    freq.put("乎专三", 41);
    freq.put("临丢丛", 9);
    freq.put("是一万", 9);
    freq.put("是一丁", 7);
    freq.put("，乙专", 16);
    freq.put("临丹的", 21);
    freq.put("乎专丁", 7);
    freq.put("临丢专", 14);
    freq.put("，乙丘", 11);
    freq.put("人！", 22);
    freq.put("，乙丛", 10);
    freq.put("临丢三", 11);
    freq.put("人？", 12);
    freq.put("，乙丁", 11);
    freq.put("丐的", 35);
    freq.put("人；", 9);
    freq.put("临丢丁", 9);
    freq.put("乎专专", 15);
    freq.put("乎专且", 28);
    freq.put("，乙三", 46);
    freq.put("丙临的", 7);
    freq.put("丁中的", 11);
    freq.put("丛丘，", 12);
    freq.put("且之国", 20);
    freq.put("乘丹，", 7);
    freq.put("中万 ", 7);
    freq.put(" 专国", 8);
    freq.put("专万】", 7);
    freq.put("在丛丁", 8);
    freq.put("，乙乙", 16);
    freq.put("是一之", 21);
    freq.put("专之日", 18);
    freq.put("万丁仗", 9);
    freq.put("临丢之", 16);
    freq.put("丘丘 ", 39);
    freq.put("在丛专", 7);
    freq.put("专万。", 27);
    freq.put("，乙之", 26);
    freq.put("之中丘", 7);
    freq.put("之； ", 8);
    freq.put("且之在", 10);
    freq.put("丘么，", 7);
    freq.put("丁，三", 205);
    freq.put("专，于", 9);
    freq.put("三丰丁", 15);
    freq.put("临临丢", 8);
    freq.put("乘乎么", 9);
    freq.put("之的，", 43);
    freq.put("丁三佛", 13);
    freq.put("；且", 19);
    freq.put("么且之", 15);
    freq.put(" 仗仗", 27);
    freq.put(" 专在", 141);
    freq.put(" 劈劈", 30);
    freq.put("丛？？", 10);
    freq.put("丢专 ", 11);
    freq.put("专丐三", 12);
    freq.put("临临丛", 16);
    freq.put("丢之！", 7);
    freq.put("一丹三", 9);
    freq.put("丢之，", 20);
    freq.put(" 丘 ", 21);
    freq.put("一丁，", 18);
    freq.put("丹，且", 24);
    freq.put("日，之", 18);
    freq.put(" 嗯", 42);
    freq.put("临临丘", 24);
    freq.put("乘乘三", 54);
    freq.put("乙仗！", 7);
    freq.put("丹且万", 19);
    freq.put("乎的专", 7);
    freq.put("乙仗，", 11);
    freq.put("丁」！", 7);
    freq.put("丑且", 16);
    freq.put(" 《临", 18);
    freq.put(" 是么", 8);
    freq.put("专丈丁", 16);
    freq.put("乎。", 19);
    freq.put("年中国", 8);
    freq.put("么且三", 10);
    freq.put("且中丁", 7);
    freq.put("么且专", 14);
    freq.put("丘人 ", 7);
    freq.put("且中三", 14);
    freq.put("：华", 10);
    freq.put("专，丘", 20);
    freq.put("专，丙", 10);
    freq.put("冲丁丁", 13);
    freq.put("专，且", 151);
    freq.put("丁丙的", 20);
    freq.put("三华", 431);
    freq.put("冲丁三", 20);
    freq.put("丁丰三", 10);
    freq.put("冲丁专", 9);
    freq.put("的国三", 46);
    freq.put("丁丰丁", 9);
    freq.put("专，一", 38);
    freq.put("专，丁", 141);
    freq.put("国专之", 91);
    freq.put("专，丹", 143);
    freq.put("专，为", 10);
    freq.put("专，临", 94);
    freq.put(" 仗之", 10);
    freq.put("专，中", 20);
    freq.put("临临丈", 9);
    freq.put("么丹专", 20);
    freq.put("国专乙", 18);
    freq.put("华丁之", 22);
    freq.put("丘乙的", 16);
    freq.put("专，丢", 12);
    freq.put("专，乘", 123);
    freq.put(" 是乘", 8);
    freq.put("是乘临", 9);
    freq.put("丹，丁", 26);
    freq.put("冲丁之", 18);
    freq.put("之乙 ", 63);
    freq.put(" 【日", 7);
    freq.put("专，乎", 12);
    freq.put("专，么", 12);
    freq.put("国专丹", 7);
    freq.put("专，之", 238);
    freq.put("专丈临", 11);
    freq.put("国专临", 12);
    freq.put("临临丁", 118);
    freq.put("是乘丘", 10);
    freq.put("国专三", 86);
    freq.put(" 仗丁", 15);
    freq.put("国专万", 15);
    freq.put("；临", 17);
    freq.put("为，三", 8);
    freq.put("专，乱", 15);
    freq.put("坯", 13);
    freq.put(" 仗三", 23);
    freq.put("专丢 ", 20);
    freq.put("国专丛", 7);
    freq.put("亥三的", 7);
    freq.put("国专丘", 10);
    freq.put("丹，三", 49);
    freq.put("国专专", 63);
    freq.put("么大", 22);
    freq.put(" 仗丘", 7);
    freq.put("丁，丁", 116);
    freq.put("【临", 37);
    freq.put("【丹", 19);
    freq.put("人三亥", 18);
    freq.put("丹么 ", 12);
    freq.put("专丘机", 12);
    freq.put("【中", 12);
    freq.put("【专", 74);
    freq.put("一乎之", 9);
    freq.put("【丛", 16);
    freq.put("【丘", 20);
    freq.put("仗？ ", 34);
    freq.put("专之机", 29);
    freq.put(" 么之", 23);
    freq.put("是专在", 9);
    freq.put("【丁", 73);
    freq.put("【万", 17);
    freq.put("【三", 94);
    freq.put("么三么", 8);
    freq.put("之专丁", 415);
    freq.put("叶 ", 7);
    freq.put("三丛。", 36);
    freq.put("专俩之", 12);
    freq.put(" 么临", 7);
    freq.put("丢三临", 14);
    freq.put("且丘之", 18);
    freq.put("一乎三", 13);
    freq.put("华》", 53);
    freq.put("且佛", 35);
    freq.put("一乎丁", 9);
    freq.put(" 【机", 7);
    freq.put("【乘", 21);
    freq.put("【乙", 26);
    freq.put(" 么三", 38);
    freq.put("【之", 77);
    freq.put("一乎专", 11);
    freq.put("人三临", 47);
    freq.put("丘万的", 19);
    freq.put("）", 773);
    freq.put("。万之", 12);
    freq.put("人三为", 8);
    freq.put("人三丹", 26);
    freq.put("么三之", 78);
    freq.put("丢三之", 52);
    freq.put("人三且", 11);
    freq.put("人三专", 81);
    freq.put("人三丛", 7);
    freq.put("人三丘", 17);
    freq.put("人三万", 47);
    freq.put("临三华", 11);
    freq.put("人三丁", 66);
    freq.put("万丹乘", 12);
    freq.put("人三三", 160);
    freq.put("。万丁", 10);
    freq.put("乘是丛", 7);
    freq.put("。万三", 19);
    freq.put("三乞丁", 10);
    freq.put("丹临，", 21);
    freq.put("。万专", 14);
    freq.put("三丁俘", 10);
    freq.put("且俩", 18);
    freq.put("。佛", 13);
    freq.put("】【", 19);
    freq.put("么三的", 21);
    freq.put("三丁俩", 9);
    freq.put("是大", 39);
    freq.put("人三乘", 10);
    freq.put("人三乙", 9);
    freq.put("丘丘。", 10);
    freq.put("为三临", 14);
    freq.put("专为临", 11);
    freq.put("国华", 38);
    freq.put("人三之", 81);
    freq.put("且为", 37);
    freq.put("三丁丈", 25);
    freq.put("且丹", 318);
    freq.put("­", 13);
    freq.put("且临", 337);
    freq.put("丢三乙", 11);
    freq.put("机 ", 56);
    freq.put("三丁一", 35);
    freq.put("且丰", 18);
    freq.put("且中", 83);
    freq.put("三丁丙", 76);
    freq.put("三丁丘", 163);
    freq.put("三丁丛", 119);
    freq.put("专丙临", 28);
    freq.put("三丁且", 63);
    freq.put("专丙丹", 12);
    freq.put("乓 ", 7);
    freq.put("且丢", 57);
    freq.put("三丁专", 627);
    freq.put("乘华华", 15);
    freq.put("？专三", 15);
    freq.put("专丙丁", 38);
    freq.put("专丙万", 12);
    freq.put("且丛", 93);
    freq.put("且丘", 152);
    freq.put("且丙", 82);
    freq.put("，专华", 7);
    freq.put("且且", 313);
    freq.put("且专", 1097);
    freq.put("三丁丢", 44);
    freq.put("专丙专", 15);
    freq.put("之之丙", 38);
    freq.put("三丁丹", 136);
    freq.put("且丈", 35);
    freq.put("且三", 1625);
    freq.put("专丙丛", 20);
    freq.put("且万", 391);
    freq.put("？专专", 13);
    freq.put("专丙丘", 18);
    freq.put("三丁丰", 12);
    freq.put("且一", 134);
    freq.put("且丁", 784);
    freq.put(" 、 ", 26);
    freq.put("乙三的", 25);
    freq.put("三丁乎", 33);
    freq.put("三丁么", 72);
    freq.put("三丁之", 674);
    freq.put("丘的 ", 25);
    freq.put("丹 ", 591);
    freq.put("专丁 ", 237);
    freq.put("且专。", 8);
    freq.put("且乱", 44);
    freq.put("。仗", 14);
    freq.put("三丁乙", 94);
    freq.put("三丁乘", 112);
    freq.put(" 乙冲", 11);
    freq.put("丁华乘", 9);
    freq.put("且乘", 266);
    freq.put("且乙", 92);
    freq.put("专丙之", 33);
    freq.put("丘俩之", 11);
    freq.put("丁三冲", 14);
    freq.put("且乎", 38);
    freq.put("且之", 1339);
    freq.put("且么", 58);
    freq.put("一） ", 7);
    freq.put("大万丁", 11);
    freq.put("专丙乙", 10);
    freq.put("三丁乱", 35);
    freq.put("乞丘", 15);
    freq.put("乞丛", 7);
    freq.put("且人", 25);
    freq.put("。丁", 262);
    freq.put("乞丐", 10);
    freq.put("乞专", 16);
    freq.put("。丈", 13);
    freq.put("。三", 528);
    freq.put("乘的", 448);
    freq.put("。且", 243);
    freq.put("乞三", 33);
    freq.put("三丁亟", 9);
    freq.put("。专", 415);
    freq.put("乞丁", 16);
    freq.put("。丘", 50);
    freq.put("。丙", 21);
    freq.put("。丛", 41);
    freq.put("中国，", 30);
    freq.put("临专在", 13);
    freq.put("。丢", 19);
    freq.put("三丁亥", 9);
    freq.put("。中", 27);
    freq.put("且于", 67);
    freq.put("俩之 ", 23);
    freq.put("丘丢三", 14);
    freq.put("乘丘的", 14);
    freq.put("乞丢", 7);
    freq.put("劈劈劈", 35);
    freq.put("《 ", 24);
    freq.put("。丹", 271);
    freq.put("。为", 12);
    freq.put("︶¯ ", 7);
    freq.put("乞乞", 9);
    freq.put("专：之", 71);
    freq.put("。乎", 12);
    freq.put("。么", 18);
    freq.put("乞乖", 7);
    freq.put("。之", 370);
    freq.put("三三大", 91);
    freq.put("乞之", 27);
    freq.put("三之国", 35);
    freq.put("三丁仗", 39);
    freq.put("。乘", 148);
    freq.put("。乙", 45);
    freq.put("一丹，", 11);
    freq.put("且仗", 31);
    freq.put("丑：", 7);
    freq.put("丑！", 18);
    freq.put("乘是丁", 10);
    freq.put("之》三", 9);
    freq.put("。乱", 36);
    freq.put("丘丢之", 8);
    freq.put("丑！！", 7);
    freq.put("丑，", 73);
    freq.put("가가가", 116);
    freq.put("：丈", 11);
    freq.put("专临是", 20);
    freq.put("丁丛的", 23);
    freq.put("丁三国", 11);
    freq.put("专：乘", 21);
    freq.put("专三佛", 8);
    freq.put("三冲之", 14);
    freq.put("日三的", 14);
    freq.put("乱亥", 7);
    freq.put("之专是", 64);
    freq.put("之专丰", 12);
    freq.put("丘：之", 10);
    freq.put("中国劈", 10);
    freq.put("佛。", 17);
    freq.put("佛、", 10);
    freq.put("日专 ", 37);
    freq.put("万万是", 7);
    freq.put("丘的。", 13);
    freq.put("丙临丘", 10);
    freq.put("三冲专", 14);
    freq.put("丐之 ", 8);
    freq.put("三冲三", 15);
    freq.put("专） ", 42);
    freq.put("三冲丁", 26);
    freq.put(" 中华", 19);
    freq.put("三三年", 10);
    freq.put("专专机", 9);
    freq.put("三中，", 9);
    freq.put("之三俩", 16);
    freq.put("丁乎 ", 11);
    freq.put("临机丁", 8);
    freq.put("之三俘", 10);
    freq.put("仗、", 9);
    freq.put("丈专之", 22);
    freq.put("三专在", 66);
    freq.put("专专月", 15);
    freq.put("丈专乙", 7);
    freq.put("乙）", 11);
    freq.put("乙（", 11);
    freq.put("是丹且", 9);
    freq.put("乙，", 338);
    freq.put("乙！", 42);
    freq.put("临机三", 11);
    freq.put("乙；", 19);
    freq.put("乙：", 90);
    freq.put("丈专临", 17);
    freq.put("专丹 ", 55);
    freq.put("之的国", 7);
    freq.put("丈专三", 26);
    freq.put("丈专专", 26);
    freq.put("丈专丘", 7);
    freq.put("专的", 1382);
    freq.put("丰三，", 8);
    freq.put("之三乱", 45);
    freq.put("丰之，", 7);
    freq.put("专乎之", 22);
    freq.put("丘丹专", 30);
    freq.put("专乎么", 63);
    freq.put(" 一临", 14);
    freq.put("且乘临", 7);
    freq.put("＜", 15);
    freq.put("专临机", 8);
    freq.put("之。", 1295);
    freq.put("之、", 144);
    freq.put("之　", 12);
    freq.put(" 一万", 19);
    freq.put("，中丁", 8);
    freq.put("之》", 54);
    freq.put("之《", 56);
    freq.put(" 一三", 64);
    freq.put("坤。", 10);
    freq.put("且是仗", 7);
    freq.put("之」", 20);
    freq.put("之「", 30);
    freq.put(" 一专", 95);
    freq.put("之】", 74);
    freq.put("之三么", 67);
    freq.put("之三乎", 44);
    freq.put("且乘丘", 8);
    freq.put(" 一丛", 8);
    freq.put("大专之", 148);
    freq.put("且乘且", 9);
    freq.put("且乘专", 24);
    freq.put("之〜", 9);
    freq.put(" 丰专", 15);
    freq.put("之三丹", 254);
    freq.put("丁之丐", 10);
    freq.put("大专临", 13);
    freq.put(" ¬ ", 20);
    freq.put("大专丹", 10);
    freq.put("之三丰", 18);
    freq.put("尴亟", 7);
    freq.put("兢兢兢", 17);
    freq.put("』 ", 21);
    freq.put(" 专华", 35);
    freq.put("之三中", 50);
    freq.put("之之日", 14);
    freq.put("之三丢", 43);
    freq.put("丁之且", 79);
    freq.put("之三並", 12);
    freq.put("之三丛", 158);
    freq.put("之三丙", 78);
    freq.put("三； ", 26);
    freq.put("且乘之", 33);
    freq.put("大专且", 7);
    freq.put(" 一之", 62);
    freq.put("大专丘", 7);
    freq.put("之三丑", 14);
    freq.put("丛丙三", 7);
    freq.put("之三且", 141);
    freq.put("大专丁", 52);
    freq.put("之三三", 1462);
    freq.put("之三丈", 28);
    freq.put("大专万", 12);
    freq.put("【三丁", 14);
    freq.put("乘丁 ", 43);
    freq.put(" 一乙", 9);
    freq.put("乱临三", 9);
    freq.put("之三万", 401);
    freq.put("一之 ", 39);
    freq.put("专为三", 27);
    freq.put("临丘三", 60);
    freq.put("华专 ", 30);
    freq.put("专为丁", 13);
    freq.put("临丘丁", 46);
    freq.put("临丘一", 7);
    freq.put("专专是", 156);
    freq.put("临丘丛", 11);
    freq.put("临丘丙", 7);
    freq.put("临丘丘", 28);
    freq.put("专为专", 21);
    freq.put("丘专：", 15);
    freq.put("丛丙丁", 8);
    freq.put("且是乘", 24);
    freq.put("且是乙", 8);
    freq.put("侥三", 20);
    freq.put("专：丛", 7);
    freq.put("三临大", 31);
    freq.put("临乘乙", 12);
    freq.put("丁； ", 21);
    freq.put("三丢的", 14);
    freq.put("且是之", 59);
    freq.put("，人", 54);
    freq.put("侥丙", 8);
    freq.put("侥丘", 9);
    freq.put("临丘丹", 15);
    freq.put("的：", 12);
    freq.put("临丘临", 22);
    freq.put("丘仗 ", 22);
    freq.put("且是为", 15);
    freq.put("专为之", 12);
    freq.put("且是丹", 37);
    freq.put("专为乎", 9);
    freq.put("临乘乘", 16);
    freq.put("乎，之", 9);
    freq.put("大专人", 8);
    freq.put("且是临", 10);
    freq.put("仞╁丁", 13);
    freq.put("」，", 22);
    freq.put("专：专", 30);
    freq.put("侥乱", 7);
    freq.put("之三亥", 13);
    freq.put("之丢，", 18);
    freq.put("且是丛", 11);
    freq.put("且是丘", 9);
    freq.put("坤坤 ", 7);
    freq.put("：在", 15);
    freq.put("侥之", 17);
    freq.put("且是专", 68);
    freq.put("且是且", 15);
    freq.put("且是三", 83);
    freq.put("侥乙", 8);
    freq.put("丁三在", 31);
    freq.put("且是一", 21);
    freq.put("且是丁", 56);
    freq.put("且是万", 20);
    freq.put("专国三", 59);
    freq.put("的人 ", 42);
    freq.put("三乘么", 18);
    freq.put(" 丛临", 74);
    freq.put(" 丛丹", 15);
    freq.put("三丘：", 9);
    freq.put("丐", 802);

    init3();
  }
  private static void init3() {
    
    freq.put("三乘乘", 37);
    freq.put("，中之", 8);
    freq.put("一三丁", 68);
    freq.put("乘之丙", 9);
    freq.put("三么人", 8);
    freq.put(" 丛专", 47);
    freq.put("三乙 ", 58);
    freq.put("丘三在", 9);
    freq.put(" 丛丛", 54);
    freq.put(" 丛丘", 15);
    freq.put(" 丛丙", 11);
    freq.put("年一丹", 16);
    freq.put("为三万", 15);
    freq.put(" ๑", 7);
    freq.put("俘的专", 7);
    freq.put(" 丛万", 40);
    freq.put("为三丁", 13);
    freq.put("专乱 ", 36);
    freq.put("三、万", 11);
    freq.put("丙乙之", 7);
    freq.put("为三三", 53);
    freq.put("三乘丈", 12);
    freq.put("三乘三", 227);
    freq.put("之仗仗", 13);
    freq.put("临之大", 8);
    freq.put("三乘一", 22);
    freq.put("三乘丁", 101);
    freq.put("三乘万", 40);
    freq.put("三乘丛", 26);
    freq.put("三乘丘", 42);
    freq.put("三乘丙", 11);
    freq.put("三乘专", 131);
    freq.put("三乘且", 42);
    freq.put("万丛，", 9);
    freq.put("三乘丢", 8);
    freq.put(" 丛乘", 21);
    freq.put("专乎丁", 9);
    freq.put("三乘丹", 34);
    freq.put("丙乙丁", 9);
    freq.put("大三临", 30);
    freq.put(" 丛之", 104);
    freq.put("万且", 317);
    freq.put("为三之", 23);
    freq.put("三乘临", 69);
    freq.put("乙乙 ", 36);
    freq.put(" 专，", 31);
    freq.put(" ╮ ", 14);
    freq.put("之之是", 84);
    freq.put("的一临", 12);
    freq.put("，专国", 8);
    freq.put("国在", 10);
    freq.put("丹丙之", 14);
    freq.put("的一万", 13);
    freq.put(" 亞三", 7);
    freq.put("的一丁", 19);
    freq.put("的一三", 63);
    freq.put("的一且", 9);
    freq.put("的一专", 52);
    freq.put("三、专", 15);
    freq.put("丘丛，", 12);
    freq.put("，且是", 186);
    freq.put("在之国", 26);
    freq.put("的一丘", 8);
    freq.put("之丘在", 13);
    freq.put("三乘于", 7);
    freq.put("专中，", 14);
    freq.put("三丙。", 8);
    freq.put(" 么专", 8);
    freq.put("国劈冲", 9);
    freq.put("丹丙丘", 9);
    freq.put("丹丙丛", 8);
    freq.put(" 亞丁", 9);
    freq.put("丹丙丁", 24);
    freq.put("一专 ", 81);
    freq.put("丹丙三", 16);
    freq.put("、 ", 107);
    freq.put("的一乎", 7);
    freq.put("的一之", 16);
    freq.put("乱临之", 19);
    freq.put("三乘人", 25);
    freq.put("丛丙么", 7);
    freq.put("的一乙", 8);
    freq.put("临三国", 9);
    freq.put("专中国", 129);
    freq.put("坏 ", 8);
    freq.put("三万的", 130);
    freq.put("之丁年", 19);
    freq.put("专丛的", 29);
    freq.put("中之丁", 13);
    freq.put("：临之", 19);
    freq.put("丛华", 32);
    freq.put("乎么仗", 21);
    freq.put("一且三", 15);
    freq.put("丁仗。", 14);
    freq.put("专三俘", 7);
    freq.put("国国", 37);
    freq.put("，专在", 87);
    freq.put("三、临", 11);
    freq.put("丢丁是", 7);
    freq.put("乎么人", 9);
    freq.put(" 丢 ", 16);
    freq.put("一且乙", 12);
    freq.put("乙么 ", 15);
    freq.put("：临丘", 7);
    freq.put("丈三，", 12);
    freq.put("：临专", 16);
    freq.put("乎之 ", 12);
    freq.put("丙丑之", 7);
    freq.put("之之机", 23);
    freq.put("临于丹", 9);
    freq.put("丁三仗", 26);
    freq.put("乎么乱", 8);
    freq.put("丛乘丁", 11);
    freq.put("丹之么", 13);
    freq.put("专专（", 15);
    freq.put("三在丁", 44);
    freq.put("临于专", 15);
    freq.put("丁临！", 11);
    freq.put("丁临，", 101);
    freq.put("乙专 ", 45);
    freq.put("临于丘", 7);
    freq.put("乎么之", 87);
    freq.put("临于丁", 8);
    freq.put(" 乘临", 69);
    freq.put("临于三", 34);
    freq.put("佛佛 ", 99);
    freq.put("大三丹", 8);
    freq.put("浏临之", 24);
    freq.put("丹之是", 32);
    freq.put("乎，专", 7);
    freq.put("乎么临", 36);
    freq.put(" 乘丈", 7);
    freq.put("氪 ", 17);
    freq.put("人之，", 16);
    freq.put("乎么万", 19);
    freq.put("乎么丁", 49);
    freq.put("丁是 ", 16);
    freq.put("乎么三", 116);
    freq.put("之专日", 12);
    freq.put("乎么且", 15);
    freq.put("乎么专", 105);
    freq.put("艹", 15);
    freq.put("三的大", 12);
    freq.put("佐三", 7);
    freq.put("乎么丘", 17);
    freq.put("乎么丛", 9);
    freq.put("三丘！", 27);
    freq.put("乱专。", 8);
    freq.put("专在临", 20);
    freq.put("丁乙之", 74);
    freq.put("丁，大", 11);
    freq.put("丛之！", 14);
    freq.put(" 乩么", 13);
    freq.put("丛之？", 7);
    freq.put("丈丑之", 7);
    freq.put("丁乙乙", 26);
    freq.put("丁乙乘", 8);
    freq.put("丛之：", 23);
    freq.put("为三丘", 23);
    freq.put("为丁之", 14);
    freq.put(" 乘丛", 27);
    freq.put("三的国", 10);
    freq.put("侥", 202);
    freq.put("之万仗", 20);
    freq.put("丘三大", 8);
    freq.put("专在丘", 7);
    freq.put("专在丛", 15);
    freq.put("，专专", 329);
    freq.put("专在一", 15);
    freq.put("专在丁", 46);
    freq.put("专在万", 21);
    freq.put("乘乙的", 14);
    freq.put("丈 ", 133);
    freq.put("么三人", 9);
    freq.put("丁铊", 11);
    freq.put("丁乙三", 59);
    freq.put("丁乙万", 13);
    freq.put("之万人", 15);
    freq.put("丁乙丁", 70);
    freq.put("丁乙一", 11);
    freq.put("乎，三", 8);
    freq.put("丁乙丙", 10);
    freq.put("丁乙丘", 30);
    freq.put("丁乙丛", 22);
    freq.put("丁乙且", 9);
    freq.put("之！丹", 9);
    freq.put("。丁乙", 9);
    freq.put(" ?", 24);
    freq.put("丁乙专", 50);
    freq.put("专在乘", 14);
    freq.put("专在乙", 7);
    freq.put("之！三", 10);
    freq.put(" 专年", 14);
    freq.put("丁乙丢", 7);
    freq.put("丛仗 ", 11);
    freq.put("之在之", 39);
    freq.put("丁乙丹", 24);
    freq.put("且一三", 25);
    freq.put("临三大", 16);
    freq.put("之丁《", 7);
    freq.put("专在么", 8);
    freq.put("丁乙临", 42);
    freq.put(" 丁大", 12);
    freq.put("专在之", 83);
    freq.put("三三劈", 8);
    freq.put("之万于", 12);
    freq.put("之万乱", 17);
    freq.put("是华", 14);
    freq.put("专（专", 16);
    freq.put("丹丘，", 21);
    freq.put("万： ", 13);
    freq.put("丘临：", 8);
    freq.put("国大", 49);
    freq.put("专（三", 16);
    freq.put("丁乙仗", 12);
    freq.put(" 丈乙", 7);
    freq.put("三，仗", 9);
    freq.put("为且三", 12);
    freq.put("之万乙", 34);
    freq.put("之万乘", 35);
    freq.put("乘之 ", 59);
    freq.put("之丁】", 25);
    freq.put("。丁之", 35);
    freq.put("丁乘 ", 42);
    freq.put("中国", 1176);
    freq.put("华临 ", 8);
    freq.put("之万之", 262);
    freq.put("专在于", 7);
    freq.put("之万临", 79);
    freq.put("之万丹", 48);
    freq.put("丁，且", 97);
    freq.put(" ¯", 12);
    freq.put(" ¬", 21);
    freq.put("之丁冲", 10);
    freq.put("乙仗的", 7);
    freq.put(" ´", 19);
    freq.put("专（之", 14);
    freq.put("之万中", 15);
    freq.put("乘丹丛", 9);
    freq.put("丙的之", 15);
    freq.put("之万专", 180);
    freq.put("之万且", 34);
    freq.put("≧", 17);
    freq.put("之万丙", 15);
    freq.put("之万丘", 32);
    freq.put("之万丛", 22);
    freq.put("，俩之", 10);
    freq.put("之万丁", 109);
    freq.put("之万一", 15);
    freq.put("之万万", 49);
    freq.put("之万三", 318);
    freq.put("之万丈", 9);
    freq.put("的么之", 8);
    freq.put("乘，三", 37);
    freq.put("的么么", 7);
    freq.put("万专乙", 11);
    freq.put("万专乘", 27);
    freq.put("万之一", 21);
    freq.put("临之之", 312);
    freq.put("乘，丁", 29);
    freq.put("人在丁", 9);
    freq.put("人在三", 13);
    freq.put("万专么", 13);
    freq.put("万专之", 222);
    freq.put("乘，且", 27);
    freq.put("乘，专", 30);
    freq.put("临之乘", 46);
    freq.put("万专乎", 12);
    freq.put("万专乱", 13);
    freq.put("丛在之", 8);
    freq.put("亥", 797);
    freq.put("，丰专", 8);
    freq.put("人的", 186);
    freq.put("专乎人", 12);
    freq.put("丹么！", 35);
    freq.put("丐？", 12);
    freq.put("丐！", 14);
    freq.put("三乎丢", 7);
    freq.put("临丹：", 9);
    freq.put("临之乱", 11);
    freq.put("为", 1675);
    freq.put("丐，", 52);
    freq.put("，专大", 9);
    freq.put("万专专", 260);
    freq.put("乘，之", 42);
    freq.put("万专且", 15);
    freq.put("的么三", 8);
    freq.put("临之丁", 169);
    freq.put("铉", 10);
    freq.put("万专丘", 29);
    freq.put("万专丛", 19);
    freq.put("临之三", 452);
    freq.put("万专丁", 105);
    freq.put("万专一", 16);
    freq.put("临之且", 67);
    freq.put("丁丘、", 7);
    freq.put("乘丹的", 9);
    freq.put("临之专", 301);
    freq.put("万专万", 38);
    freq.put("乘，乘", 19);
    freq.put("万专三", 279);
    freq.put("丁丘》", 9);
    freq.put("丹之乙", 22);
    freq.put("临之丛", 186);
    freq.put("临之丘", 50);
    freq.put("临之丙", 17);
    freq.put("临之丢", 21);
    freq.put("万专临", 66);
    freq.put("丹专，", 64);
    freq.put("万专丹", 53);
    freq.put("丹专！", 18);
    freq.put(" 兢兢", 10);
    freq.put("《临专", 20);
    freq.put("丹专：", 27);
    freq.put("临之临", 135);
    freq.put("万专丢", 12);
    freq.put("万专中", 15);
    freq.put("临之丹", 71);
    freq.put("三：丁", 26);
    freq.put("丁：之", 27);
    freq.put("三：万", 9);
    freq.put("三：三", 32);
    freq.put("么么丹", 34);
    freq.put("乙。专", 10);
    freq.put("乱之的", 18);
    freq.put("万的 ", 35);
    freq.put("乙。三", 19);
    freq.put("乘丹丁", 21);
    freq.put("三：专", 23);
    freq.put("三：且", 8);
    freq.put("三：丘", 7);
    freq.put("且一乘", 17);
    freq.put("：专之", 26);
    freq.put("么么专", 86);
    freq.put("三丹的", 77);
    freq.put("么么丑", 7);
    freq.put("么么且", 11);
    freq.put("专是在", 19);
    freq.put("么么丘", 9);
    freq.put("三：中", 11);
    freq.put("机三的", 7);
    freq.put(" 乘乘", 46);
    freq.put("专丘万", 31);
    freq.put("三：丹", 10);
    freq.put("么么三", 44);
    freq.put("三三华", 72);
    freq.put("三的乘", 26);
    freq.put("丛且，", 7);
    freq.put("丁：三", 22);
    freq.put("乙乘三", 21);
    freq.put("：专专", 26);
    freq.put(" 万人", 23);
    freq.put("三：之", 28);
    freq.put("：专丁", 8);
    freq.put("丁：专", 13);
    freq.put("丁：且", 7);
    freq.put("：专三", 22);
    freq.put("：专临", 17);
    freq.put("丁：中", 17);
    freq.put("丹丛。", 7);
    freq.put("么么乙", 10);
    freq.put("万专人", 9);
    freq.put("丁：丹", 13);
    freq.put("么么之", 75);
    freq.put("么么么", 9);
    freq.put("丁：临", 12);
    freq.put("丙之是", 8);
    freq.put("临丁且", 24);
    freq.put("乘（", 7);
    freq.put("一、", 10);
    freq.put("！万之", 8);
    freq.put("乘，", 290);
    freq.put("临丁专", 180);
    freq.put("乘！", 46);
    freq.put("临丁丘", 48);
    freq.put("临丁丙", 23);
    freq.put("临丁丛", 42);
    freq.put("乘：", 43);
    freq.put("万临乱", 8);
    freq.put("万乙临", 13);
    freq.put("仗。。", 66);
    freq.put("乘？", 14);
    freq.put("丹丛之", 90);
    freq.put("之？ ", 64);
    freq.put("乙乘 ", 7);
    freq.put("刨 ", 26);
    freq.put("万乙丹", 8);
    freq.put("临丁临", 91);
    freq.put("万乙丁", 18);
    freq.put("万临么", 11);
    freq.put("中国的", 67);
    freq.put(" 是的", 13);
    freq.put("万临之", 86);
    freq.put("之丁华", 14);
    freq.put("万乙三", 14);
    freq.put("万乙专", 17);
    freq.put("临丁丢", 15);
    freq.put("万临乘", 32);
    freq.put("万临乙", 9);
    freq.put("丘乙之", 24);
    freq.put("万乙丛", 8);
    freq.put("乘丘，", 12);
    freq.put("诶 ", 9);
    freq.put("。三是", 8);
    freq.put("丘乙临", 17);
    freq.put("！万三", 9);
    freq.put("。劈", 9);
    freq.put("临丁乘", 49);
    freq.put("日 ", 103);
    freq.put("丹丛丁", 11);
    freq.put("万临临", 48);
    freq.put("万临丹", 34);
    freq.put("丹丛三", 26);
    freq.put("临丁么", 23);
    freq.put("临丁之", 199);
    freq.put("万临丁", 30);
    freq.put("丘乙专", 23);
    freq.put("临丁乱", 7);
    freq.put("万临万", 10);
    freq.put("丘乙丘", 8);
    freq.put("万临三", 92);
    freq.put("么三仗", 13);
    freq.put("万乙之", 24);
    freq.put("丘乙丁", 23);
    freq.put("三临国", 8);
    freq.put("万临且", 15);
    freq.put("丑的", 52);
    freq.put("万临丘", 17);
    freq.put("丘乙三", 34);
    freq.put("万临丛", 10);
    freq.put("是冲", 11);
    freq.put("万乙乙", 16);
    freq.put("三佛丁", 8);
    freq.put("三佛三", 15);
    freq.put("三佛专", 14);
    freq.put("专三之", 1198);
    freq.put("国三 ", 24);
    freq.put("丁，临", 50);
    freq.put("乙丁丘", 19);
    freq.put("临中之", 9);
    freq.put("俩。。", 7);
    freq.put("之三）", 9);
    freq.put("临丁人", 14);
    freq.put("丢乘三", 7);
    freq.put("么三。", 13);
    freq.put("之三（", 17);
    freq.put("万临仗", 7);
    freq.put("丢乘丁", 7);
    freq.put("乙：三", 10);
    freq.put("丁丑之", 14);
    freq.put("临丁仗", 9);
    freq.put("的丁 ", 9);
    freq.put("三佛之", 10);
    freq.put("乙三，", 53);
    freq.put("临乘的", 40);
    freq.put("三华于", 12);
    freq.put("之之乘", 118);
    freq.put("为丁临", 9);
    freq.put("乙三：", 10);
    freq.put("丁丙，", 26);
    freq.put("。　", 10);
    freq.put("「丁", 24);
    freq.put("丢乘之", 7);
    freq.put(" 万。", 10);
    freq.put("万之是", 36);
    freq.put("乙：之", 8);
    freq.put("丙专之", 41);
    freq.put("国临之", 16);
    freq.put("么。三", 7);
    freq.put("中之 ", 34);
    freq.put("乱万临", 9);
    freq.put("年之月", 7);
    freq.put("丈乙专", 8);
    freq.put("么三临", 25);
    freq.put("「三", 34);
    freq.put("，一之", 41);
    freq.put("专人是", 9);
    freq.put("乙丁丁", 39);
    freq.put("乱万专", 9);
    freq.put(" 三、", 10);
    freq.put("乱万三", 13);
    freq.put("丛的么", 7);
    freq.put("丹丘 ", 12);
    freq.put("丁，丛", 22);
    freq.put("丙专三", 42);
    freq.put("～专", 7);
    freq.put("么。之", 8);
    freq.put("三三冲", 21);
    freq.put("丙专丁", 23);
    freq.put("丁，丙", 11);
    freq.put("丙专万", 13);
    freq.put("丙专丘", 7);
    freq.put("丘三丹", 24);
    freq.put("丙专专", 34);
    freq.put("国临专", 19);
    freq.put("在 ", 140);
    freq.put("，一临", 17);
    freq.put("丈专的", 8);
    freq.put("乙？ ", 7);
    freq.put("π ", 7);
    freq.put("，一三", 62);
    freq.put("～三", 10);
    freq.put("，一万", 19);
    freq.put("丙专丢", 8);
    freq.put("乙佛", 10);
    freq.put("，一丁", 27);
    freq.put("，一丙", 11);
    freq.put("，一专", 76);
    freq.put("专专在", 53);
    freq.put("临乘万", 11);
    freq.put("乘。且", 9);
    freq.put("于", 1629);
    freq.put("专一丹", 12);
    freq.put("么华", 17);
    freq.put("临且，", 11);
    freq.put("专一临", 14);
    freq.put("专一三", 106);
    freq.put(" π", 10);
    freq.put(" 。丁", 8);
    freq.put("临三人", 23);
    freq.put("三临在", 22);
    freq.put("专一丁", 40);
    freq.put(" ω", 9);
    freq.put(" 。三", 12);
    freq.put("《专之", 14);
    freq.put("专一丘", 9);
    freq.put("专一丙", 7);
    freq.put("为且专", 7);
    freq.put("。专之", 64);
    freq.put(" 。专", 11);
    freq.put("专一专", 78);
    freq.put("专三丙", 62);
    freq.put("丙专临", 12);
    freq.put("于乘专", 8);
    freq.put("临之的", 63);
    freq.put("＞ ", 7);
    freq.put("么三专", 64);
    freq.put("乘。之", 7);
    freq.put("）、", 32);
    freq.put("）。", 19);
    freq.put("丁俩 ", 10);
    freq.put("专一之", 58);
    freq.put("专一乎", 11);
    freq.put("专之冲", 9);
    freq.put("《专三", 8);
    freq.put("绮", 12);
    freq.put("专一乘", 17);
    freq.put("专一乙", 11);
    freq.put("《专专", 12);
    freq.put("乘丛。", 7);
    freq.put("丁三大", 23);
    freq.put("于中", 16);
    freq.put("之中 ", 9);
    freq.put("三三国", 63);
    freq.put("于的", 14);
    freq.put("于丢", 7);
    freq.put("丘么", 129);
    freq.put("于丹", 42);
    freq.put("在华临", 7);
    freq.put("▽￣", 14);
    freq.put("临三亥", 7);
    freq.put("于临", 56);
    freq.put("乙丹之", 19);
    freq.put("于三", 205);
    freq.put("三丢，", 16);
    freq.put("，丛乘", 9);
    freq.put("于一", 13);
    freq.put("于丁", 92);
    freq.put("·之", 41);
    freq.put("于万", 47);
    freq.put("于丘", 36);
    freq.put("于丙", 7);
    freq.put("于丛", 13);
    freq.put("，丛之", 45);
    freq.put("于专", 141);
    freq.put("于且", 29);
    freq.put("三中 ", 14);
    freq.put("的丘三", 41);
    freq.put("乙丹专", 14);
    freq.put("，丛丹", 8);
    freq.put("，丛临", 16);
    freq.put("丘乘的", 8);
    freq.put("的丘万", 9);
    freq.put("乙丹丁", 7);
    freq.put("么三三", 110);
    freq.put("于乱", 10);
    freq.put("临乘一", 20);
    freq.put("乙丹三", 34);
    freq.put("于么", 9);
    freq.put("乙丹临", 7);
    freq.put("于之", 128);
    freq.put("，丛丛", 9);
    freq.put("丁乱的", 10);
    freq.put("，丛专", 26);
    freq.put("大万丛", 7);
    freq.put("¯ ", 11);
    freq.put("于乘", 35);
    freq.put("于乙", 12);
    freq.put("丘乙", 262);
    freq.put("·专", 11);
    freq.put("的丘丁", 31);
    freq.put("，丛三", 25);
    freq.put("，丛万", 8);
    freq.put("，丛丁", 14);
    freq.put("且，专", 35);
    freq.put("且，且", 14);
    freq.put("之乘丢", 13);
    freq.put("「之", 22);
    freq.put("之乘丹", 37);
    freq.put("且，丁", 18);
    freq.put("且，三", 38);
    freq.put("之乘临", 48);
    freq.put("的是", 179);
    freq.put("且，临", 14);
    freq.put("之乘一", 11);
    freq.put("丁三年", 10);
    freq.put("且，丹", 15);
    freq.put("之乘万", 29);
    freq.put("之乘丘", 26);
    freq.put("之乘丙", 12);
    freq.put("之乘丛", 15);
    freq.put("之乘专", 163);
    freq.put("之乘且", 27);
    freq.put("丹之临", 65);
    freq.put("丁！！", 22);
    freq.put("丁，乘", 59);
    freq.put("且，乙", 10);
    freq.put("且，乘", 10);
    freq.put("三】三", 14);
    freq.put("且，之", 43);
    freq.put("之乘乱", 7);
    freq.put("万丑丑", 7);
    freq.put("之乘么", 13);
    freq.put("之乘之", 95);
    freq.put("乘临于", 8);
    freq.put("华三，", 75);
    freq.put("是在", 72);
    freq.put("丢万，", 7);
    freq.put("丛的丁", 24);
    freq.put("华三：", 8);
    freq.put("之乘乙", 11);
    freq.put("～之", 12);
    freq.put("临临。", 21);
    freq.put("华丛", 32);
    freq.put("丘丁丘", 24);
    freq.put("丘丁丙", 11);
    freq.put("月丘", 7);
    freq.put("月丙", 14);
    freq.put("临之一", 67);
    freq.put("丈的丁", 9);
    freq.put("乘一专", 49);
    freq.put("月专", 18);
    freq.put("中华", 60);
    freq.put("丘丁且", 11);
    freq.put("月且", 7);
    freq.put("丘丁三", 131);
    freq.put("乘一三", 38);
    freq.put("月三", 43);
    freq.put("丘丁一", 9);
    freq.put("丘丁丁", 97);
    freq.put("月丁", 30);
    freq.put("月万", 12);
    freq.put("〞", 16);
    freq.put("丘丁丹", 20);
    freq.put("丙在三", 9);
    freq.put("专～", 12);
    freq.put("，，", 23);
    freq.put("丘丁临", 58);
    freq.put("月临", 12);
    freq.put("且且之", 30);
    freq.put("是国", 12);
    freq.put("月中", 7);
    freq.put("之：之", 13);
    freq.put("丘丁丢", 11);
    freq.put(" 丁 ", 66);
    freq.put("丘丁乙", 10);
    freq.put("月乘", 19);
    freq.put("丢丢，", 12);
    freq.put("佛专丁", 7);
    freq.put("之：丹", 11);
    freq.put("乙的", 312);
    freq.put("且且临", 10);
    freq.put("丘丁么", 17);
    freq.put("月之", 69);
    freq.put("是丹临", 17);
    freq.put("一年，", 8);
    freq.put("佛专专", 7);
    freq.put("丹乎么", 50);
    freq.put("专；", 50);
    freq.put("专：", 556);
    freq.put("丘乱", 93);
    freq.put("专？", 112);
    freq.put("在临丁", 11);
    freq.put("且且专", 44);
    freq.put("且且且", 13);
    freq.put("佛专临", 7);
    freq.put("且且三", 49);
    freq.put("于佛", 11);
    freq.put("之：万", 10);
    freq.put("万 ", 770);
    freq.put("临专乱", 34);
    freq.put("专＂", 9);
    freq.put("且且丁", 19);
    freq.put("且且一", 17);
    freq.put("且且万", 12);
    freq.put("年 ", 194);
    freq.put("的月", 8);
    freq.put("丁丛，", 37);
    freq.put("丁之】", 11);
    freq.put("三专丙", 54);
    freq.put("三的华", 15);
    freq.put("三三坤", 7);
    freq.put("丘丹。", 8);
    freq.put("丘三", 1383);
    freq.put("乘人丁", 7);
    freq.put("之丈 ", 9);
    freq.put("丁之。", 129);
    freq.put("丁之、", 25);
    freq.put(" 丙临", 12);
    freq.put(" 丛三", 76);
    freq.put("乙乱三", 9);
    freq.put(" 万万", 33);
    freq.put(" 丙丁", 51);
    freq.put("丹华丁", 7);
    freq.put(" 丙万", 18);
    freq.put(" 丙丘", 19);
    freq.put(" 丙丙", 18);
    freq.put(" 丙丛", 26);
    freq.put("的机", 23);
    freq.put("的丘之", 31);
    freq.put("三三坏", 7);
    freq.put(" 丙专", 32);
    freq.put(" 丙且", 8);
    freq.put("三专丑", 9);
    freq.put("乱三，", 7);
    freq.put("丘丁", 952);
    freq.put("临日三", 11);
    freq.put("乍", 35);
    freq.put("丹于华", 18);
    freq.put("丘万", 298);
    freq.put("专乙冲", 11);
    freq.put("三三在", 106);
    freq.put(" 丙之", 36);
    freq.put("国专", 417);
    freq.put("乙乱之", 9);
    freq.put("三亨之", 7);
    freq.put("临丙 ", 16);
    freq.put("三专三", 1339);
    freq.put("三专丈", 24);
    freq.put("三国《", 7);
    freq.put("丘专是", 13);
    freq.put("：丙", 12);
    freq.put("丛，且", 33);
    freq.put("丁专乱", 13);
    freq.put("　丁", 15);
    freq.put("丛，专", 44);
    freq.put("国丙", 11);
    freq.put("　三", 52);
    freq.put("丛，丘", 7);
    freq.put("丹之丁", 124);
    freq.put("丛，丛", 7);
    freq.put("　专", 27);
    freq.put("，专年", 7);
    freq.put("丛，万", 11);
    freq.put("丛，丁", 28);
    freq.put("　且", 10);
    freq.put("　丘", 9);
    freq.put("丘丐", 16);
    freq.put("丛，临", 23);
    freq.put("丁临的", 91);
    freq.put("三专一", 59);
    freq.put("丛仗，", 10);
    freq.put("乙乙的", 29);
    freq.put("丁专乙", 47);
    freq.put("丁专乘", 82);
    freq.put("丛，丹", 24);
    freq.put("　中", 28);
    freq.put("么乱三", 10);
    freq.put("临。万", 10);
    freq.put("的之 ", 25);
    freq.put("丁专之", 454);
    freq.put("专中之", 36);
    freq.put("丁专么", 41);
    freq.put("丁专乎", 15);
    freq.put("国一", 15);
    freq.put("丁专临", 158);
    freq.put("丁专为", 8);
    freq.put("丁专丹", 98);
    freq.put("之丁在", 30);
    freq.put("丛，乘", 16);
    freq.put("丛，乙", 10);
    freq.put("丁专丢", 11);
    freq.put("么之 ", 48);
    freq.put("丁专中", 24);
    freq.put("丛，之", 36);
    freq.put("丁专专", 501);
    freq.put("临专丈", 9);
    freq.put("丁专且", 39);
    freq.put("丁专丛", 44);
    freq.put("国三", 709);
    freq.put("丁专丙", 31);
    freq.put("丁专丘", 83);
    freq.put("三？ ", 46);
    freq.put("中丁 ", 9);
    freq.put("丁专丁", 277);
    freq.put("丁专一", 28);
    freq.put("丁专万", 116);
    freq.put("临专万", 56);
    freq.put("丁专三", 545);
    freq.put("丁专丈", 11);
    freq.put("！", 2963);
    freq.put("乱丁临", 10);
    freq.put("乙之丁", 31);
    freq.put("乙之一", 17);
    freq.put("乙之万", 22);
    freq.put("乙之三", 89);
    freq.put("乱丁丹", 10);
    freq.put("亥 ", 90);
    freq.put("临乙。", 16);
    freq.put("临。临", 13);
    freq.put("乙之专", 48);
    freq.put("万中国", 32);
    freq.put("乙之且", 7);
    freq.put("乙之丛", 20);
    freq.put("丁丁！", 23);
    freq.put("乙之丘", 11);
    freq.put("（一", 8);
    freq.put("三万）", 7);
    freq.put("丘之人", 9);
    freq.put("丁专仗", 24);
    freq.put("临三为", 11);
    freq.put("乱丁专", 20);
    freq.put("专丛，", 33);
    freq.put("仗么么", 10);
    freq.put("乱丁万", 10);
    freq.put("乱丁丁", 27);
    freq.put("之佛佛", 8);
    freq.put("丁？ ", 24);
    freq.put("专丛？", 25);
    freq.put("乱丁三", 27);
    freq.put("、三丘", 9);
    freq.put("乙之之", 89);
    freq.put("丁专人", 36);
    freq.put("丁乎是", 7);
    freq.put("丹丘丛", 14);
    freq.put("、三专", 28);
    freq.put("丁丁（", 8);
    freq.put("劈华", 7);
    freq.put("乙之乙", 13);
    freq.put("乙之乘", 20);
    freq.put("、三丁", 18);
    freq.put("的中国", 45);
    freq.put("、三丹", 10);
    freq.put("临三中", 11);
    freq.put("、三临", 16);
    freq.put("丘乱。", 9);
    freq.put("临专专", 338);
    freq.put("丈三", 209);
    freq.put("丈三的", 11);
    freq.put("三 ", 3877);
    freq.put(" ，且", 31);
    freq.put("丁专于", 27);
    freq.put("乱丁之", 26);
    freq.put("且之大", 13);
    freq.put("的。 ", 59);
    freq.put("劈劈", 115);
    freq.put("丁；", 40);
    freq.put("丁：", 263);
    freq.put("丛临。", 10);
    freq.put("专三于", 30);
    freq.put("临三丢", 12);
    freq.put(" 丛！", 9);
    freq.put("丁丁：", 39);
    freq.put(" 专大", 16);
    freq.put("丘丛的", 12);
    freq.put("专丘 ", 123);
    freq.put("丹之 ", 111);
    freq.put("仗三 ", 8);
    freq.put("（中", 12);
    freq.put("仗！！", 54);
    freq.put("是中国", 44);
    freq.put("之：三", 29);
    freq.put("丢临专", 17);
    freq.put("三。乙", 11);
    freq.put("ㅋㅋ", 19);
    freq.put("在乘丘", 10);
    freq.put("的日", 30);
    freq.put("三的冲", 7);
    freq.put("丁丹。", 12);
    freq.put("之丘一", 8);
    freq.put("三一 ", 10);
    freq.put("丘之乙", 16);
    freq.put("亟，三", 7);
    freq.put(" 三。", 9);
    freq.put("丛三之", 121);
    freq.put("丛三么", 7);
    freq.put("乘么之", 8);
    freq.put("专中专", 22);
    freq.put("乘么么", 32);
    freq.put("三丘的", 172);
    freq.put("国乘", 24);
    freq.put("丛三乙", 13);
    freq.put("丛三乘", 8);
    freq.put("三在丹", 19);
    freq.put("丁专俩", 8);
    freq.put("临三专", 334);
    freq.put("之丁国", 9);
    freq.put("丘万，", 14);
    freq.put("之佛之", 7);
    freq.put("么专三", 73);
    freq.put("丁专俘", 12);
    freq.put("丑专，", 7);
    freq.put("亨之", 41);
    freq.put("之人 ", 43);
    freq.put("冲万之", 8);
    freq.put("乙临。", 20);
    freq.put("三临华", 15);
    freq.put("丙之。", 25);
    freq.put("丛三三", 181);
    freq.put("丛三丁", 81);
    freq.put("丛三一", 12);
    freq.put("丛三万", 39);
    freq.put("丛三丛", 31);
    freq.put("专中万", 8);
    freq.put("丛三丘", 31);
    freq.put("丛三专", 81);
    freq.put("之，丈", 7);
    freq.put("乘丢 ", 8);
    freq.put("丛三且", 19);
    freq.put(" 在 ", 15);
    freq.put("中华三", 37);
    freq.put("亨专", 13);
    freq.put("临三丁", 200);
    freq.put("么在", 19);
    freq.put("亨三", 21);
    freq.put("冲万三", 11);
    freq.put("亨丁", 8);
    freq.put("丛三临", 39);
    freq.put("之的中", 10);
    freq.put("万仗！", 10);
    freq.put("￣▽", 14);
    freq.put("且之是", 29);
    freq.put("丘么三", 8);
    freq.put("一丁之", 30);
    freq.put("之的丢", 8);
    freq.put("丢之之", 27);
    freq.put("丘么专", 12);
    freq.put("专。丁", 26);
    freq.put("之的丹", 27);
    freq.put("一丁乘", 11);
    freq.put("一丁乙", 13);
    freq.put("乙仗之", 14);
    freq.put("丛？三", 20);
    freq.put("　　 ", 36);
    freq.put("之的丈", 9);
    freq.put("嘤", 9);
    freq.put("的，三", 64);
    freq.put("丛？丁", 9);
    freq.put("之的万", 28);
    freq.put("之的一", 34);
    freq.put("之的丁", 121);
    freq.put("之的丘", 31);
    freq.put("之的丙", 12);
    freq.put("之的丛", 24);
    freq.put("之的且", 10);
    freq.put("万么 ", 12);
    freq.put("丛？专", 8);
    freq.put("之的专", 203);
    freq.put("一丁一", 11);
    freq.put("一丁丁", 37);
    freq.put("丢之万", 15);
    freq.put("乙仗专", 10);
    freq.put("人俩", 10);
    freq.put("一丁万", 9);
    freq.put("丘么之", 18);
    freq.put("一丁三", 94);
    freq.put("丑。。", 8);
    freq.put("丢之三", 45);
    freq.put("一丁专", 52);
    freq.put("一丁且", 7);
    freq.put("三仗", 358);
    freq.put("丢之专", 30);
    freq.put("之的乱", 8);
    freq.put("丛？之", 12);
    freq.put("之的么", 11);
    freq.put("丁且 ", 15);
    freq.put("之的之", 146);
    freq.put("之乙。", 16);
    freq.put("丢之临", 8);
    freq.put("一丁临", 15);
    freq.put("之的乙", 31);
    freq.put("丹丹。", 9);
    freq.put("一丁丹", 9);
    freq.put("临么。", 7);
    freq.put("且", 9377);
    freq.put("日丁三", 13);
    freq.put("人丁之", 31);
    freq.put("丹丁是", 8);
    freq.put("丘机 ", 9);
    freq.put("之的人", 45);
    freq.put("冲 ", 54);
    freq.put("人丁三", 28);
    freq.put("人丁万", 10);
    freq.put("的之临", 74);
    freq.put("人丁丁", 30);
    freq.put("且丈之", 7);
    freq.put("人丁丛", 14);
    freq.put("人丁丘", 10);
    freq.put("专万 ", 96);
    freq.put("人丁且", 9);
    freq.put("人丁专", 13);
    freq.put("三。丘", 11);
    freq.put("专专华", 93);
    freq.put("人丁丹", 8);
    freq.put("临专人", 52);
    freq.put("人丁临", 13);
    freq.put("之的仗", 8);
    freq.put("丘亟", 11);
    freq.put("专。三", 56);
    freq.put("乱之三", 41);
    freq.put(" 人三", 89);
    freq.put("三丹丢", 11);
    freq.put("三丹中", 8);
    freq.put("。乘专", 44);
    freq.put("。乘且", 9);
    freq.put("之之冲", 13);
    freq.put("。乘三", 37);
    freq.put("三丹临", 78);
    freq.put(" 专月", 26);
    freq.put("人，之", 34);
    freq.put("人人", 21);
    freq.put("。乘丁", 10);
    freq.put("三丹丹", 68);
    freq.put(" 人专", 26);
    freq.put("乱之且", 9);
    freq.put("人于", 12);
    freq.put("三丹丁", 120);
    freq.put("三丹一", 23);
    freq.put("丰之年", 10);
    freq.put("么之之", 48);
    freq.put("中的 ", 9);
    freq.put("于之之", 13);
    freq.put("三丹三", 303);
    freq.put("三丹且", 88);
    freq.put("乱之丹", 14);
    freq.put("专丑丈", 8);
    freq.put("丁丁？", 9);
    freq.put("三丹专", 226);
    freq.put("么么的", 10);
    freq.put("！专之", 10);
    freq.put("乱在", 16);
    freq.put("丘三的", 37);
    freq.put("三丹丙", 14);
    freq.put("三丹丘", 38);
    freq.put("三丹丛", 29);
    freq.put("乱之临", 14);
    freq.put("乱之之", 48);
    freq.put(" 人之", 39);
    freq.put("乎 ", 55);
    freq.put("赈", 12);
    freq.put("是乘三", 45);
    freq.put("么专丛", 8);
    freq.put("。乘之", 11);
    freq.put("于之临", 9);
    freq.put("临铉", 7);
    freq.put("之专华", 55);
    freq.put("！专专", 21);
    freq.put("于之丁", 8);
    freq.put("于之三", 25);
    freq.put("专临华", 18);
    freq.put("三丹乎", 18);
    freq.put("三丹么", 25);
    freq.put("三丹之", 148);
    freq.put("专丑之", 13);
    freq.put("丘之丢", 10);
    freq.put("！专丁", 11);
    freq.put("于之专", 12);
    freq.put("！专三", 20);
    freq.put("人仗", 32);
    freq.put("三丹乙", 15);
    freq.put("三丹乘", 55);
    freq.put("丛丘乘", 11);
    freq.put("乘丹乘", 9);
    freq.put("乖三", 13);
    freq.put("中丁专", 16);
    freq.put("人丢", 31);
    freq.put("丛丘之", 23);
    freq.put("人丹", 95);
    freq.put("人为", 14);
    freq.put("人临", 134);
    freq.put("乘丹之", 36);
    freq.put("人丰", 9);
    freq.put("三丹人", 7);
    freq.put(" 。且", 9);
    freq.put("丹人专", 8);
    freq.put("人丈", 13);
    freq.put("人三", 826);
    freq.put("丘丁的", 35);
    freq.put("人万", 109);
    freq.put("人一", 38);
    freq.put("人丁", 229);
    freq.put("之人专", 76);
    freq.put("专丘，", 120);
    freq.put("临专中", 7);
    freq.put("人丘", 70);
    freq.put("人丙", 24);
    freq.put("人丛", 50);
    freq.put("人且", 63);
    freq.put("乖丹", 20);
    freq.put("之乱丘", 12);
    freq.put("仗，万", 13);
    freq.put("人丑", 8);
    freq.put("人专", 566);
    freq.put("丛丘丘", 14);
    freq.put("三，乘", 103);
    freq.put("乘丹专", 56);
    freq.put("乘丹且", 17);
    freq.put("丢三是", 8);
    freq.put("乘丹丘", 7);
    freq.put("ㅋ", 26);
    freq.put("诶", 20);
    freq.put("专乙，", 28);
    freq.put("丛丘三", 21);
    freq.put("乘丛乙", 7);
    freq.put("万专的", 33);
    freq.put("乖乖", 7);
    freq.put("丛丘丁", 14);
    freq.put("临专乙", 38);
    freq.put("人乱", 21);
    freq.put("嗯嗯", 11);
    freq.put("人乎", 20);
    freq.put("人么", 31);
    freq.put("人之", 479);
    freq.put("专于华", 24);
    freq.put("乘丹丹", 15);
    freq.put("丈临 ", 19);
    freq.put("三在中", 9);
    freq.put("三丹仗", 14);
    freq.put("人乘", 58);
    freq.put("人乙", 48);
    freq.put("丹人之", 10);
    freq.put("三丁，", 244);
    freq.put("三丁）", 8);
    freq.put("三丁（", 7);
    freq.put("，大", 105);
    freq.put("三丁！", 36);
    freq.put("专专冲", 9);
    freq.put("三丁？", 19);
    freq.put("三丁；", 14);
    freq.put("中国人", 83);
    freq.put(" ¯︶", 7);
    freq.put("且：", 13);
    freq.put("丑仗", 23);
    freq.put("三？专", 7);
    freq.put("丘俩，", 8);
    freq.put("专丙，", 9);
    freq.put("且，", 260);
    freq.put("丹临俩", 12);
    freq.put("是乘丁", 25);
    freq.put("三並三", 8);
    freq.put("＾", 10);
    freq.put("临乘三", 82);
    freq.put("么之丛", 8);
    freq.put("华 ", 263);
    freq.put("丑人", 7);
    freq.put(" 三：", 8);
    freq.put("临乘丁", 38);
    freq.put("么专是", 12);
    freq.put("乘在一", 11);
    freq.put(" 「专", 7);
    freq.put("临乘丘", 10);
    freq.put(" ） ", 31);
    freq.put("大之 ", 20);
    freq.put("临乘且", 9);
    freq.put("临乘专", 80);
    freq.put("三丛 ", 77);
    freq.put("么临的", 24);
    freq.put("临乘丢", 19);
    freq.put("临丛 ", 36);
    freq.put("乘！ ", 14);
    freq.put(" 是仗", 14);
    freq.put("临乘临", 24);
    freq.put("丑乱", 18);
    freq.put("三之亥", 8);
    freq.put("。＂", 15);
    freq.put("《三丁", 8);
    freq.put("丁丹！", 8);
    freq.put("（万三", 82);
    freq.put("。（", 38);
    freq.put("《三三", 18);
    freq.put("临丁的", 66);
    freq.put("三在", 481);
    freq.put("中国丹", 9);
    freq.put("《三专", 12);
    freq.put(" 是丹", 14);
    freq.put(" 之乙", 71);
    freq.put("中国临", 37);
    freq.put("三乘：", 12);
    freq.put("一丹之", 13);
    freq.put("中国三", 236);
    freq.put("且华专", 13);
    freq.put(" 是三", 37);
    freq.put("丑乙", 22);
    freq.put("丑乘", 20);
    freq.put("中国万", 23);
    freq.put("中国丁", 70);
    freq.put(" 是一", 8);
    freq.put("丑乞", 9);
    freq.put("丁冲 ", 8);
    freq.put("丘丢，", 7);
    freq.put("中国丘", 18);
    freq.put(" 是丘", 8);
    freq.put("中国且", 15);
    freq.put("丑之", 152);
    freq.put("丹，之", 40);
    freq.put("中国专", 125);
    freq.put("丹，临", 12);
    freq.put("丑临", 44);
    freq.put("丑丹", 38);
    freq.put("丹丘丹", 10);
    freq.put("《三之", 18);
    freq.put("丹，丹", 44);
    freq.put("】 ", 283);
    freq.put("丑丢", 31);
    freq.put("丹丛的", 10);
    freq.put("乘乘在", 10);
    freq.put("么之一", 9);
    freq.put("专之丰", 11);
    freq.put("丑丑", 31);
    freq.put("丑丐", 26);
    freq.put("丑专", 77);
    freq.put("么之丁", 51);
    freq.put("万临的", 22);
    freq.put("丹，专", 36);
    freq.put("中国之", 113);
    freq.put("的大专", 10);
    freq.put("丑丙", 17);
    freq.put("丑丘", 33);
    freq.put("丑丛", 22);
    freq.put("丹，丘", 7);
    freq.put("么之万", 20);
    freq.put("丑丁", 65);
    freq.put("丹，万", 11);
    freq.put("中国乙", 7);
    freq.put("中国乘", 14);
    freq.put("丑万", 15);
    freq.put("叶", 82);
    freq.put("丑三", 129);
    freq.put("丑丈", 18);
    freq.put("倉並", 7);
    freq.put(" 丈丹", 10);
    freq.put("三乘", 1347);
    freq.put(" 丈临", 14);
    freq.put("之】之", 7);
    freq.put("是的，", 7);
    freq.put("丑俩", 9);
    freq.put(" 丈丢", 10);
    freq.put("丁为三", 7);
    freq.put(" 丈丘", 21);
    freq.put(" 丈专", 29);
    freq.put("机。", 17);
    freq.put(" 丈三", 16);
    freq.put("丙临之", 21);
    freq.put(" 丈丁", 17);
    freq.put("且。。", 10);
    freq.put(" 丛乙", 12);
    freq.put("丙临临", 9);
    freq.put("劈。。", 7);
    freq.put("丹临于", 8);
    freq.put("丑侥", 7);
    freq.put("临之为", 10);
    freq.put("三乖", 9);
    freq.put("乘于华", 10);
    freq.put("专丁》", 10);
    freq.put(" 之 ", 112);
    freq.put("丹《", 10);
    freq.put("丹」", 12);
    freq.put("丙临丛", 11);
    freq.put("丁为乎", 7);
    freq.put("丹、", 25);
    freq.put("专丁。", 73);
    freq.put("丙临且", 7);
    freq.put("丹。", 123);
    freq.put("丙临专", 35);
    freq.put("且专 ", 37);
    freq.put(" 丈之", 10);
    freq.put("三于华", 40);
    freq.put("丙临三", 23);
    freq.put("丹】", 10);
    freq.put("专丁】", 10);
    freq.put("丙临丁", 13);
    freq.put("之丑专", 12);
    freq.put("兢 ", 13);
    freq.put("丹临乘", 60);
    freq.put("丹临乙", 8);
    freq.put("三", 74056);
    freq.put("）临", 12);
    freq.put("俩之。", 14);
    freq.put("临， ", 21);
    freq.put("丹临之", 102);
    freq.put("丹临么", 8);
    freq.put("之丑三", 8);
    freq.put("亞", 98);
    freq.put("丙三 ", 26);
    freq.put("之专冲", 9);
    freq.put("的大", 65);
    freq.put("丹在 ", 16);
    freq.put("丹中国", 26);
    freq.put("。专万", 12);
    freq.put("▽￣ ", 12);
    freq.put(" 啧啧", 13);
    freq.put("》。", 13);
    freq.put("人三，", 14);
    freq.put(" 【丘", 17);
    freq.put("丹临丛", 12);
    freq.put("丹临丘", 13);
    freq.put("丹临丙", 10);
    freq.put("丹临且", 8);
    freq.put("丹临专", 103);
    freq.put("丙专的", 17);
    freq.put("专么在", 8);
    freq.put("丹临三", 73);
    freq.put("之丑之", 12);
    freq.put("亥三", 57);
    freq.put("乎", 2294);
    freq.put("，且华", 10);
    freq.put("丹临丁", 64);
    freq.put("丹临丹", 23);
    freq.put("专之国", 38);
    freq.put("丹临临", 37);
    freq.put(" 日 ", 75);
    freq.put("倪丁", 7);
    freq.put("之之华", 32);
    freq.put(" 专日", 7);
    freq.put(" 乎三", 8);
    freq.put("丰三三", 13);
    freq.put("丹乘丙", 7);
    freq.put("的丘人", 13);
    freq.put(" 乎丁", 13);
    freq.put("亥丁", 33);
    freq.put("丁万丘", 21);
    freq.put("。一专", 10);
    freq.put("，乙丙", 7);
    freq.put("乙俘", 24);
    freq.put(" 乎丛", 9);
    freq.put("临三日", 7);
    freq.put(" 乎专", 12);
    freq.put("丰三专", 17);
    freq.put("丰三且", 7);
    freq.put(" 乎且", 7);
    freq.put("乙俩", 35);
    freq.put("一乙专", 34);
    freq.put("之乘的", 44);
    freq.put("专之么", 57);
    freq.put("三俩 ", 18);
    freq.put("－－临", 36);
    freq.put("丰三临", 8);
    freq.put("，临丹", 29);
    freq.put(" 仞，", 7);
    freq.put(" 乎么", 57);
    freq.put(" 乎之", 9);
    freq.put("丰三之", 13);
    freq.put("人：", 23);
    freq.put("乙侏", 7);
    freq.put("为丁三", 19);
    freq.put("丙仗 ", 7);
    freq.put("。丁丛", 11);
    freq.put("。丁丘", 9);
    freq.put("为丁丁", 12);
    freq.put("。丁万", 7);
    freq.put("。丁丁", 39);
    freq.put("为丁专", 16);
    freq.put("的丹丹", 8);
    freq.put("之三；", 10);
    freq.put("之三：", 42);
    freq.put("。丁临", 18);
    freq.put("之三？", 20);
    freq.put("日专】", 14);
    freq.put(" 【临", 30);
    freq.put("。丁丹", 8);
    freq.put("大专！", 7);
    freq.put("╰ ", 38);
    freq.put("佛 ", 126);
    freq.put("之三，", 327);
    freq.put("之三！", 21);
    freq.put("大专，", 8);
    freq.put("临丘，", 27);
    freq.put("专为，", 19);
    freq.put("的丘临", 23);
    freq.put("（华专", 9);
    freq.put("临丘：", 8);
    freq.put("专乱。", 11);
    freq.put("的丘丢", 8);
    freq.put("的丘丛", 9);
    freq.put("的丘丘", 21);
    freq.put("的丘且", 7);
    freq.put("？三专", 7);
    freq.put(" 乎人", 9);
    freq.put("？三三", 13);
    freq.put("？三万", 8);
    freq.put("三？三", 7);
    freq.put("？三丁", 7);
    freq.put("的丘一", 7);
    freq.put("专丹。", 18);
    freq.put("乙丹的", 11);
    freq.put("在临临", 8);
    freq.put("专临国", 8);
    freq.put("且丁是", 30);
    freq.put("丹之。", 17);
    freq.put("乙是之", 7);
    freq.put("的丘乙", 14);
    freq.put("的丘乘", 7);
    freq.put("丛么 ", 17);
    freq.put("在临三", 20);
    freq.put(" 乱乘", 7);
    freq.put("丁三是", 91);
    freq.put("？三之", 15);
    freq.put(" 【中", 10);
    freq.put("且是，", 16);
    freq.put("的丘么", 11);
    freq.put("的年", 15);
    freq.put("临丞", 8);
    freq.put("（丘", 12);
    freq.put("之 ", 3539);
    freq.put("（专", 94);
    freq.put("坤 ", 30);
    freq.put("『", 58);
    freq.put("三之丰", 27);
    freq.put("。且是", 23);
    freq.put("（丁", 46);
    freq.put("之?", 8);
    freq.put("（万", 92);
    freq.put("乙仗", 142);
    freq.put("临丛", 380);
    freq.put("（丹", 16);
    freq.put("丙丁丛", 16);
    freq.put("乱丁的", 9);
    freq.put("临丙", 188);
    freq.put("，临丁", 48);
    freq.put("（临", 24);
    freq.put("丙丁且", 10);
    freq.put("临且", 308);
    freq.put("专专国", 19);
    freq.put("丛丁。", 18);
    freq.put("（乘", 8);
    freq.put("（乙", 7);
    freq.put("乙于", 15);
    freq.put("中华专", 7);
    freq.put("（之", 66);
    freq.put("（么", 8);
    freq.put("乎专之", 14);
    freq.put("丙丁专", 64);
    freq.put("乙亟", 10);
    freq.put("乘丁。", 13);
    freq.put(" 月丁", 12);
    freq.put("乱华", 22);
    freq.put("』『", 8);
    freq.put(" 乱之", 40);
    freq.put("乙亥", 17);
    freq.put(" 专丁", 261);
    freq.put("乙人", 25);
    freq.put("乙专且", 10);
    freq.put("日华 ", 9);
    freq.put("乙么", 79);
    freq.put("乙之", 756);
    freq.put("乙乎", 10);
    freq.put("的大之", 7);
    freq.put("乙乙", 368);
    freq.put("乙乘", 126);
    freq.put("（于", 8);
    freq.put("乙乞", 7);
    freq.put(" 乱临", 14);
    freq.put("丹专的", 103);
    freq.put("丘仗。", 8);
    freq.put("月的", 22);
    freq.put("一之。", 11);
    freq.put("倪乘", 7);
    freq.put("丙丁丁", 29);
    freq.put("三仗！", 20);
    freq.put("的专是", 17);
    freq.put("临一", 171);
    freq.put("倪之", 39);
    freq.put("乙乱", 64);
    freq.put("三中", 270);
    freq.put("乙三", 878);
    freq.put("乙丈", 56);
    freq.put("的大丁", 7);
    freq.put("乙丁", 632);
    freq.put("乙一", 46);
    freq.put("的大三", 12);
    freq.put("乙万", 203);
    freq.put("乙丙", 126);
    freq.put("乙丘", 300);
    freq.put("乙丛", 236);
    freq.put("丘俩", 62);
    freq.put("乙丑", 27);
    freq.put("乙丐", 27);
    freq.put("乙专", 670);
    freq.put("乙丕", 7);
    freq.put("乙且", 99);
    freq.put("乙中", 38);
    freq.put("的是，", 13);
    freq.put("丘？ ", 8);
    freq.put("乙丢", 117);
    freq.put("丈专，", 16);
    freq.put("乙並", 7);
    freq.put("乙丹", 161);
    freq.put("亥万三", 8);
    freq.put("乙为", 12);
    freq.put("勺", 24);
    freq.put("乙临", 452);
    freq.put("乘乘乘", 23);
    freq.put("三乙、", 7);
    freq.put("乙之的", 20);
    freq.put("丁丛大", 14);
    freq.put("丈丈 ", 9);
    freq.put("临丰", 66);
    freq.put("万于之", 7);
    freq.put("丁临人", 20);
    freq.put(" 【华", 15);
    freq.put("的人。", 20);
    freq.put("丁于丁", 10);
    freq.put("丁临于", 13);
    freq.put(" 乱乙", 7);
    freq.put("丁于三", 13);
    freq.put("¯", 32);
    freq.put("之冲之", 8);
    freq.put("临中", 109);
    freq.put("丁于专", 7);
    freq.put("三之万", 267);
    freq.put("丈三之", 24);
    freq.put("之之国", 56);
    freq.put("丈三临", 9);
    freq.put("，专是", 102);
    freq.put("专！ ", 45);
    freq.put(" 之的", 15);
    freq.put("华", 2774);
    freq.put("之乱之", 34);
    freq.put(" 乱专", 30);
    freq.put("万于三", 7);
    freq.put("年。", 23);
    freq.put("丈三专", 23);
    freq.put("丈三丘", 8);
    freq.put("临丢", 162);
    freq.put("丁于之", 13);
    freq.put("丈三丁", 15);
    freq.put("之冲三", 9);
    freq.put("丈三万", 10);
    freq.put("丈三三", 26);
    freq.put("之冲丁", 7);
    freq.put("之临国", 8);
    freq.put("丁临丢", 8);
    freq.put("么丛三", 8);
    freq.put("丹丘乙", 8);
    freq.put("丁临中", 7);
    freq.put("专之仗", 34);
    freq.put("。佛佛", 11);
    freq.put("丹俘之", 12);
    freq.put("丁临临", 114);
    freq.put("丙丁乙", 16);
    freq.put("丁临丹", 72);
    freq.put("丁临万", 27);
    freq.put("丁临一", 16);
    freq.put("人之之", 54);
    freq.put("之乱临", 9);
    freq.put("丁临丈", 9);
    freq.put("丁临三", 264);
    freq.put("丁临且", 34);
    freq.put("人之乘", 7);
    freq.put("人之乙", 10);
    freq.put("丁临丛", 38);
    freq.put("丁临丘", 54);
    freq.put("丁临丙", 17);
    freq.put("、、", 8);
    freq.put("三于国", 7);
    freq.put("，年临", 8);
    freq.put("。丹临", 9);
    freq.put("一三是", 23);
    freq.put("乘且是", 15);
    freq.put("丹乘丁", 40);
    freq.put("三一乱", 9);
    freq.put("人之丹", 12);
    freq.put("人之为", 8);
    freq.put("丁临乱", 8);
    freq.put("人之临", 25);
    freq.put(" 中国", 305);
    freq.put("临专丁", 183);
    freq.put("乘临丹", 24);
    freq.put("三丘俩", 7);
    freq.put("人之三", 81);
    freq.put("丁临乎", 7);
    freq.put("乎么，", 27);
    freq.put("。丹且", 16);
    freq.put("人之万", 11);
    freq.put("╭", 42);
    freq.put("人之丁", 60);
    freq.put("丁临么", 16);
    freq.put("丹之之", 224);
    freq.put("人之丘", 22);
    freq.put("人之丙", 7);
    freq.put("丁专的", 97);
    freq.put("人之且", 8);
    freq.put("。丹万", 19);
    freq.put("乎么？", 41);
    freq.put("丁临乘", 58);
    freq.put("人之专", 31);
    freq.put("丁，是", 12);
    freq.put("三丘丈", 13);
    freq.put("三丘三", 271);
    freq.put("万丘 ", 20);
    freq.put("丙丁之", 46);
    freq.put("三丘一", 27);
    freq.put("三丘丁", 165);
    freq.put(" ，之", 48);
    freq.put("三丘万", 62);
    freq.put("之是且", 10);
    freq.put("０", 12);
    freq.put("三丘丘", 89);
    freq.put("三丘丙", 15);
    freq.put("三丘专", 230);
    freq.put("三丘丑", 7);
    freq.put("三丘且", 41);
    freq.put(" ，乘", 17);
    freq.put("万丛之", 27);
    freq.put("三丘中", 9);
    freq.put("三丘丢", 18);
    freq.put("丘三是", 15);
    freq.put("万丛乘", 7);
    freq.put("三丘丹", 48);
    freq.put("为三，", 10);
    freq.put("三丘临", 149);
    freq.put(" ，万", 13);
    freq.put("三丘之", 218);
    freq.put("三丘么", 27);
    freq.put("三丘乎", 9);
    freq.put(" ，丁", 35);
    freq.put("丙丛，", 11);
    freq.put("，人专", 13);
    freq.put("，仗仗", 10);
    freq.put(" ，三", 34);
    freq.put("丛三的", 28);
    freq.put("，人三", 17);
    freq.put("三丘乘", 40);
    freq.put("三丘乙", 26);
    freq.put(" ，专", 55);
    freq.put("之三的", 254);
    freq.put("万丛临", 14);
    freq.put("万丛三", 28);
    freq.put("万丛丁", 17);
    freq.put("万丛丘", 9);
    freq.put(" ，临", 20);
    freq.put("丙乙，", 9);
    freq.put("万丛专", 13);
    freq.put("三丘乱", 28);
    freq.put("之乱丙", 8);
    freq.put(" ，丹", 20);
    freq.put("丘丛丹", 8);
    freq.put("丹之丢", 15);
    freq.put("三丘亂", 9);
    freq.put("乙专。", 22);
    freq.put("丘丛临", 14);
    freq.put("，仗三", 11);
    freq.put("之之在", 36);
    freq.put("国是", 12);
    freq.put("佛佛。", 14);
    freq.put("丘丛丛", 13);
    freq.put("丘丛丘", 10);
    freq.put("人的乙", 8);
    freq.put("丘丛专", 28);
    freq.put("丛丹三", 36);
    freq.put("三丘人", 54);
    freq.put("丘丛三", 39);
    freq.put("人的之", 28);
    freq.put("么乙临", 7);
    freq.put("，且在", 14);
    freq.put("丘丛万", 7);
    freq.put("丁年 ", 11);
    freq.put("之丘是", 10);
    freq.put("人的临", 13);
    freq.put("临专丙", 18);
    freq.put("丢丹专", 9);
    freq.put("临三是", 30);
    freq.put("专在丹", 84);
    freq.put("乩 ", 17);
    freq.put("三丘仗", 16);
    freq.put("丘丛乙", 7);
    freq.put("人的丘", 9);
    freq.put("么临 ", 9);
    freq.put("丁临丁", 159);
    freq.put("人的专", 23);
    freq.put("ε ", 8);
    freq.put("丘丛之", 43);
    freq.put("人的三", 32);
    freq.put("专丘临", 68);
    freq.put("人的丁", 24);
    freq.put("之日华", 7);
    freq.put("丐临", 19);
    freq.put("丐丹", 8);
    freq.put("临丹丢", 10);
    freq.put("丐丢", 20);
    freq.put("临丹丹", 43);
    freq.put("丈。", 35);
    freq.put("丹专乱", 12);
    freq.put(" 月 ", 402);
    freq.put("丹之丹", 39);
    freq.put("丹么临", 8);
    freq.put(" あ", 12);
    freq.put("丐专", 31);
    freq.put("丐丐", 28);
    freq.put("乱专 ", 14);
    freq.put("之专专", 864);
    freq.put("丐且", 8);
    freq.put("丐丛", 16);
    freq.put("丐丘", 30);
    freq.put("丐丙", 11);
    freq.put("临丹一", 7);
    freq.put("临丹丁", 60);
    freq.put("丹专乙", 24);
    freq.put("丐丁", 39);
    freq.put("临丹丘", 18);
    freq.put("临丹丛", 14);
    freq.put("临丹且", 18);
    freq.put("丐三", 75);
    freq.put("丁临专", 223);
    freq.put("专丘一", 14);
    freq.put("乘临中", 28);
    freq.put("临之！", 17);
    freq.put("临之，", 144);
    freq.put("万专：", 9);
    freq.put("为丹专", 28);
    freq.put("的。之", 13);
    freq.put("万专？", 8);
    freq.put("的么？", 10);
    freq.put("丹专为", 12);
    freq.put("丹专丹", 41);
    freq.put("国丛三", 7);
    freq.put("临之？", 13);
    freq.put("临之：", 10);
    freq.put("之是专", 127);
    freq.put("丹专临", 87);
    freq.put(" 。", 249);
    freq.put("丹么之", 13);
    freq.put(" 　", 341);
    freq.put(" 、", 163);
    freq.put("临丹么", 32);
    freq.put("仗三丁", 20);
    freq.put("临丹之", 70);
    freq.put(" 《", 168);
    freq.put(" 》", 39);
    freq.put("丐乘", 21);
    freq.put("丐乙", 28);
    freq.put(" 『", 29);
    freq.put(" 「", 55);
    freq.put(" 」", 21);
    freq.put("丹专丛", 29);
    freq.put(" 【", 555);
    freq.put(" 】", 56);
    freq.put("临丹乘", 14);
    freq.put("临丹乙", 15);
    freq.put("专丘三", 153);
    freq.put("丹专专", 284);
    freq.put("丐之", 75);
    freq.put("丐么", 11);
    freq.put("丹专且", 39);
    freq.put("丛乎么", 11);
    freq.put("丛且之", 17);
    freq.put("乘之。", 27);
    freq.put("之是 ", 38);
    freq.put("的佛", 14);
    freq.put("丛之的", 31);
    freq.put("。丹丹", 10);
    freq.put("之专丈", 8);
    freq.put("仗三专", 9);
    freq.put("万临！", 8);
    freq.put("丛且三", 21);
    freq.put("乘大的", 7);
    freq.put("丹之且", 32);
    freq.put("丛且丁", 18);
    freq.put("丹之丛", 22);
    freq.put("专丘丙", 11);
    freq.put("丛且专", 11);
    freq.put("丹之丘", 28);
    freq.put("丐仗", 8);
    freq.put("是之国", 9);
    freq.put("三的是", 37);
    freq.put("丛丛临", 7);
    freq.put("侏亥 ", 25);
    freq.put("丰丁，", 8);
    freq.put("、", 1434);
    freq.put(" ㅠ", 10);
    freq.put("丁丙三", 42);
    freq.put("丛之丈", 8);
    freq.put("于是之", 8);
    freq.put("҉", 15);
    freq.put("之专丹", 115);
    freq.put("丁丙万", 8);
    freq.put("国之 ", 7);
    freq.put("丁丙丁", 79);
    freq.put("丛之一", 14);
    freq.put("乘大", 52);
    freq.put("丁丙丙", 7);
    freq.put("丁丙丘", 11);
    freq.put("丁丙丛", 20);
    freq.put("丁丙且", 7);
    freq.put("万华三", 64);
    freq.put("丁丙专", 20);
    freq.put("么？三", 10);
    freq.put("在丛三", 12);
    freq.put("日万专", 9);
    freq.put("吾专", 20);
    freq.put("》华", 22);
    freq.put("么？丹", 9);
    freq.put("吾三", 7);
    freq.put("丁丙丹", 10);
    freq.put("丁丰专", 16);
    freq.put("丁丙临", 16);
    freq.put("亥三之", 7);
    freq.put("之丰之", 16);
    freq.put("专在，", 14);
    freq.put("之人丘", 9);
    freq.put("丁乙，", 39);
    freq.put("丛之么", 14);
    freq.put("丁丙之", 39);
    freq.put("万华乘", 9);
    freq.put("之专丢", 44);
    freq.put("丁乙！", 9);
    freq.put("乙且专", 12);
    freq.put("丹丢 ", 7);
    freq.put("丁丙乙", 14);
    freq.put("丁丙乘", 11);
    freq.put("乙且三", 18);
    freq.put("乙且万", 8);
    freq.put("三乱大", 7);
    freq.put("专，专", 225);
    freq.put("三丙 ", 30);
    freq.put("亥三专", 8);
    freq.put("之丰专", 20);
    freq.put("乙且丹", 8);
    freq.put("丁华于", 8);
    freq.put("国专的", 7);
    freq.put("且乱之", 8);
    freq.put("亥三丁", 7);
    freq.put("丁丘 ", 66);
    freq.put("丁三华", 18);
    freq.put("于是丹", 7);
    freq.put("是乘的", 30);
    freq.put("之丰三", 15);
    freq.put("专临丛", 59);
    freq.put("丛之乱", 7);
    freq.put("专，三", 308);
    freq.put("侮三", 10);
    freq.put(" 之且", 99);
    freq.put("乘三丢", 11);
    freq.put("之三机", 13);
    freq.put("█", 27);
    freq.put("丁临之", 282);
    freq.put(" 《中", 8);
    freq.put("丛。三", 11);
    freq.put("侮丑", 7);
    freq.put("之之大", 30);
    freq.put("专，万", 62);
    freq.put("之是乘", 43);
    freq.put("三机之", 15);
    freq.put(" 《专", 11);
    freq.put("一临。", 10);
    freq.put("万的。", 18);
    freq.put(" 《三", 22);
    freq.put("丐侄", 11);
    freq.put("丛之人", 9);
    freq.put(" 《万", 12);
    freq.put("侮临", 9);
    freq.put("的华", 80);
    freq.put("之专乙", 66);
    freq.put("。丹三", 41);
    freq.put("临乞三", 7);
    freq.put("之专乘", 114);
    freq.put("一专。", 12);
    freq.put("丁之》", 12);
    freq.put("丛之仗", 9);
    freq.put("╯▽╰", 12);
    freq.put("，三 ", 43);
    freq.put("丁华丁", 11);
    freq.put("三机万", 21);
    freq.put("之万：", 8);
    freq.put("。乱之", 9);
    freq.put("之万？", 7);
    freq.put("的仗 ", 10);
    freq.put("三机专", 21);
    freq.put(" 《之", 11);
    freq.put("丁华专", 17);
    freq.put("之万）", 7);
    freq.put("丁临乙", 47);
    freq.put("之万，", 84);
    freq.put("丘", 11829);
    freq.put("专冲丹", 8);
    freq.put("一 ", 50);
    freq.put("在之丁", 20);
    freq.put("万之国", 13);
    freq.put("为之之", 23);
    freq.put("专冲三", 9);
    freq.put("在之万", 14);
    freq.put("刨之", 8);
    freq.put("人三的", 32);
    freq.put("为之乙", 8);
    freq.put("仗。 ", 25);
    freq.put("临、之", 18);
    freq.put("专丰专", 21);
    freq.put("、乙三", 9);
    freq.put("丙专，", 11);
    freq.put("是乘之", 18);
    freq.put(" 嗯 ", 9);
    freq.put("乘佛", 12);
    freq.put("为之丹", 20);
    freq.put("为之临", 19);
    freq.put("之专乱", 31);
    freq.put("为乘的", 10);
    freq.put("】之之", 9);
    freq.put("为之三", 45);
    freq.put("华华三", 10);
    freq.put("三丘丛", 42);
    freq.put("刨专", 18);
    freq.put("为之万", 10);
    freq.put("为之丁", 18);
    freq.put("日。", 16);
    freq.put("是日三", 10);
    freq.put("为之丘", 8);
    freq.put("之在 ", 13);
    freq.put("刨丁", 8);
    freq.put("为之专", 44);
    freq.put("丛。丁", 8);
    freq.put("丈，", 71);
    freq.put("俩。 ", 7);
    freq.put("临且且", 7);
    freq.put("么三 ", 32);
    freq.put("临且三", 59);
    freq.put("。三国", 7);
    freq.put("在之临", 26);
    freq.put("之（ ", 9);
    freq.put("丹丰之", 15);
    freq.put("专专大", 46);
    freq.put("临且万", 7);
    freq.put("专，乙", 22);
    freq.put("临仗。", 9);
    freq.put("三临是", 13);
    freq.put("丈！", 17);
    freq.put("，是之", 26);
    freq.put("万丙之", 13);
    freq.put("临且临", 19);
    freq.put("！之是", 7);
    freq.put("～ ", 51);
    freq.put("，是乘", 8);
    freq.put("丁仗 ", 48);
    freq.put("劈，丁", 7);
    freq.put("年临", 85);
    freq.put("丹丰专", 11);
    freq.put("【丁专", 16);
    freq.put("丹丰且", 8);
    freq.put("临且之", 44);
    freq.put("【丁丁", 17);
    freq.put("乘俘", 10);
    freq.put("万丙临", 8);
    freq.put("哔", 25);
    freq.put(" 万 ", 73);
    freq.put("【丁三", 15);
    freq.put("，是一", 8);
    freq.put("乘俩", 33);
    freq.put("万丙丁", 23);
    freq.put("× ", 7);
    freq.put("专临乘", 79);
    freq.put("，是三", 29);
    freq.put("万丙三", 15);
    freq.put("，是专", 16);
    freq.put("万丙专", 15);
    freq.put("万丙丘", 10);
    freq.put("丹仗之", 8);
    freq.put("乘丈", 56);
    freq.put("乘三", 1827);
    freq.put("乘丘临", 65);
    freq.put("月", 794);
    freq.put("乘一", 150);
    freq.put("乘丁", 850);
    freq.put("乘万", 313);
    freq.put("临丁：", 17);
    freq.put("丁丙 ", 49);
    freq.put("乘丛", 186);
    freq.put("乘丘", 310);
    freq.put("乘丙", 161);
    freq.put("丹之人", 7);
    freq.put("临丁，", 71);
    freq.put("乘专", 1496);
    freq.put("乘丐", 25);
    freq.put("乘丑", 28);
    freq.put("乞的", 12);
    freq.put("乘且", 316);
    freq.put("三临》", 16);
    freq.put("乘丘专", 14);
    freq.put("乘丫", 8);
    freq.put("丘丙专", 8);
    freq.put("乘中", 27);
    freq.put("乘丢", 99);
    freq.put("在", 3229);
    freq.put("乘丘丘", 11);
    freq.put("乘为", 15);
    freq.put("丘丙丁", 13);
    freq.put("之专大", 23);
    freq.put("乘丹", 331);
    freq.put("乘丰", 31);
    freq.put("的冲", 27);
    freq.put("乘临", 547);
    freq.put("乘之", 1115);
    freq.put("乘么", 105);
    freq.put("乘乎", 42);
    freq.put("》华三", 17);
    freq.put("丹丛？", 13);
    freq.put("乘乘", 313);
    freq.put("乘乙", 201);
    freq.put("三临、", 9);
    freq.put("丹丛，", 17);
    freq.put(" 俘之", 8);
    freq.put("专之年", 23);
    freq.put("：中三", 17);
    freq.put("乘丘乙", 8);
    freq.put("专之是", 137);
    freq.put("万临，", 35);
    freq.put("丑三。", 8);
    freq.put("在《", 9);
    freq.put("专丁么", 51);
    freq.put("在。", 13);
    freq.put("乘乱", 71);
    freq.put("丘乙，", 9);
    freq.put("丛三 ", 59);
    freq.put("乘于", 39);
    freq.put("国三是", 10);
    freq.put("三丁的", 200);
    freq.put("丈临三", 15);
    freq.put("丈临专", 7);
    freq.put("乘亟", 12);
    freq.put("是乘专", 36);
    freq.put("乙三乙", 18);
    freq.put("乙三乘", 9);
    freq.put("中日", 12);
    freq.put("丘俩的", 7);
    freq.put("三乘，", 33);
    freq.put("专丙的", 7);
    freq.put("乘亥", 24);
    freq.put("乘人", 80);
    freq.put("三临机", 9);
    freq.put("且的", 160);
    freq.put("之，佛", 13);
    freq.put("丁丘丘", 38);
    freq.put("丰三丁", 10);
    freq.put(" 仗专", 14);
    freq.put("乙三万", 27);
    freq.put("乙三丁", 71);
    freq.put("乙三一", 8);
    freq.put("专华之", 23);
    freq.put("乙三三", 147);
    freq.put("乙三且", 17);
    freq.put("怜的", 9);
    freq.put("乙三专", 71);
    freq.put("乙", 7919);
    freq.put("乘丛 ", 11);
    freq.put("乙三丙", 7);
    freq.put("乘仗", 81);
    freq.put("乙三丛", 11);
    freq.put("乘丙 ", 34);
    freq.put("是乘万", 7);
    freq.put("的机万", 12);
    freq.put("乙三丢", 10);
    freq.put(" 仗丛", 8);
    freq.put("万之在", 11);
    freq.put("丁丘丁", 86);
    freq.put("且华 ", 9);
    freq.put("之临在", 8);
    freq.put("乙三丹", 19);
    freq.put("一丘之", 16);
    freq.put("丘丁：", 12);
    freq.put("，丢", 91);
    freq.put("俩且三", 8);
    freq.put("专乱", 279);
    freq.put("，中", 129);
    freq.put("，丫", 12);
    freq.put("，临", 634);
    freq.put("丕俩", 10);
    freq.put("月，", 23);
    freq.put("丘丁！", 8);
    freq.put("之专人", 44);
    freq.put("，为", 63);
    freq.put("，丹", 1052);
    freq.put("，万", 462);
    freq.put("专乙", 694);
    freq.put("专乘", 1045);
    freq.put("专乞", 22);
    freq.put("，一", 300);
    freq.put("俩仗 ", 7);
    freq.put("专乖", 22);
    freq.put("在之年", 7);
    freq.put("，三", 2368);
    freq.put("专之", 6609);
    freq.put("丁丛人", 9);
    freq.put("专之大", 34);
    freq.put("专么", 619);
    freq.put("专乎", 269);
    freq.put("，丐", 20);
    freq.put("，丑", 34);
    freq.put("，丛", 201);
    freq.put("，丘", 291);
    freq.put("，丙", 126);
    freq.put("专为", 172);
    freq.put("专丹", 1221);
    freq.put("丹国三", 8);
    freq.put("一丘丁", 9);
    freq.put("专丰", 106);
    freq.put("人。之", 7);
    freq.put("丢丢丁", 9);
    freq.put("专临", 2717);
    freq.put("专丫", 18);
    freq.put("一丘丘", 7);
    freq.put("专中", 283);
    freq.put("，乱", 126);
    freq.put("一年万", 7);
    freq.put("专丢", 310);
    freq.put("丁丛仗", 10);
    freq.put("专丛", 839);
    freq.put("之专年", 8);
    freq.put("专丙", 345);
    freq.put("专丘", 1401);
    freq.put("囧", 7);
    freq.put("专专", 8060);
    freq.put("专丑", 89);
    freq.put("专丐", 71);
    freq.put("，之", 1993);
    freq.put("专丕", 7);
    freq.put("专且", 694);
    freq.put("专三", 8649);
    freq.put("专丈", 164);
    freq.put("且且，", 12);
    freq.put("，乞", 10);
    freq.put("专丁", 3589);
    freq.put("专一", 439);
    freq.put("专万", 1700);
    freq.put("，乘", 766);
    freq.put("，乙", 213);
    freq.put("丁丛三", 124);
    freq.put("丁丘丹", 13);
    freq.put("乱三么", 9);
    freq.put("乱三之", 50);
    freq.put("丁丛丁", 68);
    freq.put("丁丛一", 9);
    freq.put("丁丛万", 12);
    freq.put("丁丛丛", 24);
    freq.put("丁丛丙", 10);
    freq.put("丁丛丘", 14);
    freq.put("丁丛专", 71);
    freq.put("在日", 14);
    freq.put("丁丛且", 26);
    freq.put("日三专", 50);
    freq.put("专仞", 17);
    freq.put("，于", 67);
    freq.put("日三丘", 7);
    freq.put("专仗", 255);
    freq.put("专三华", 43);
    freq.put("日三丁", 57);
    freq.put("之月三", 9);
    freq.put("丁丛丹", 51);
    freq.put("日三万", 9);
    freq.put("日三三", 67);
    freq.put("，亟", 8);
    freq.put("乘万万", 8);
    freq.put("么乘 ", 8);
    freq.put("丁丛临", 31);
    freq.put("丁丛之", 103);
    freq.put("专人", 715);
    freq.put("丁丛么", 12);
    freq.put("乱三三", 59);
    freq.put("丁丛乎", 8);
    freq.put("乱三万", 16);
    freq.put("乱三丁", 30);
    freq.put(" 么乙", 20);
    freq.put("为乘是", 7);
    freq.put("丁丛乙", 10);
    freq.put("丁丛乘", 54);
    freq.put("乱三丙", 7);
    freq.put("乱三丘", 8);
    freq.put("乱三丛", 8);
    freq.put("三三是", 198);
    freq.put("临临 ", 104);
    freq.put("乱三专", 71);
    freq.put("专亟", 30);
    freq.put("日三乙", 7);
    freq.put("专三是", 124);
    freq.put("，仗", 56);
    freq.put("之月之", 12);
    freq.put("专于", 248);
    freq.put("乱三临", 15);
    freq.put("日三之", 40);
    freq.put("丁仞 ", 8);
    freq.put("，《", 9);
    freq.put("临丘的", 39);
    freq.put("，", 15085);
    freq.put("之中三", 64);
    freq.put("是丁么", 10);
    freq.put("三丢临", 21);
    freq.put("于三临", 9);
    freq.put("专佛", 41);
    freq.put("三丢三", 69);
    freq.put("于三三", 40);
    freq.put("于，", 28);
    freq.put("，伎", 9);
    freq.put("三丢丁", 43);
    freq.put("于三丁", 13);
    freq.put("于三万", 10);
    freq.put("三丢万", 13);
    freq.put("三丢丘", 13);
    freq.put("于三丘", 9);
    freq.put("三丢丛", 24);
    freq.put("丹乘的", 16);
    freq.put("于三专", 27);
    freq.put("三丢专", 19);
    freq.put("國", 13);
    freq.put("是人专", 7);
    freq.put("国人的", 10);
    freq.put("丁么大", 7);
    freq.put("万】", 20);
    freq.put("乙三大", 10);
    freq.put("万。", 185);
    freq.put("万、", 42);
    freq.put("专么临", 27);
    freq.put("万「", 7);
    freq.put("万》", 10);
    freq.put("万《", 21);
    freq.put("丢！", 21);
    freq.put("三丢么", 8);
    freq.put("于三之", 39);
    freq.put(" 丁。", 7);
    freq.put("三丢之", 38);
    freq.put("万丹 ", 12);
    freq.put("丹万是", 8);
    freq.put("临丢丘", 7);
    freq.put("丐乘之", 10);
    freq.put("三丢乙", 14);
    freq.put("丁乘！", 7);
    freq.put("是丁乘", 8);
    freq.put("，佛", 49);
    freq.put("临丛专", 28);
    freq.put("【乙万", 9);
    freq.put(" 大专", 165);
    freq.put("，侮", 9);
    freq.put(" 大万", 12);
    freq.put("专俩", 101);
    freq.put(" 大丁", 21);
    freq.put(" 大丈", 9);
    freq.put(" 大三", 72);
    freq.put("华三之", 52);
    freq.put(" 大临", 13);
    freq.put("专俘", 127);
    freq.put("之乘，", 46);
    freq.put("丁劈", 42);
    freq.put("咦", 14);
    freq.put("且乘的", 13);
    freq.put(" 《 ", 13);
    freq.put("丘丹 ", 18);
    freq.put("华三乙", 7);
    freq.put(" 大丢", 7);
    freq.put("丕之", 12);
    freq.put("万，专", 73);
    freq.put("丁之 ", 334);
    freq.put("丁！丁", 8);
    freq.put("丁！三", 7);
    freq.put("么丛之", 11);
    freq.put("三三机", 15);
    freq.put("三国 ", 23);
    freq.put("华三丹", 8);
    freq.put("专侮", 12);
    freq.put(" 大之", 13);
    freq.put("专侥", 11);
    freq.put("屡", 31);
    freq.put("华三三", 63);
    freq.put("丢万三", 15);
    freq.put("的坤", 10);
    freq.put("华三丁", 30);
    freq.put("华三万", 12);
    freq.put("丕专", 9);
    freq.put("丢万专", 10);
    freq.put("专侏", 17);
    freq.put("大专的", 11);
    freq.put("专侃", 12);
    freq.put("华三专", 68);
    freq.put("丁！丹", 12);
    freq.put("，俘", 16);
    freq.put("专侄", 8);
    freq.put("的之。", 13);
    freq.put("俩俩 ", 21);
    freq.put(" （中", 8);
    freq.put(" （专", 19);
    freq.put("刨", 165);
    freq.put("是日", 11);
    freq.put(" （三", 36);
    freq.put("三》之", 9);
    freq.put(" （丁", 8);
    freq.put("喽", 12);
    freq.put("三中丁", 16);
    freq.put("仗！三", 8);
    freq.put(" ╯", 42);
    freq.put("之么 ", 63);
    freq.put("日", 1415);
    freq.put("年临临", 9);
    freq.put("仗！专", 8);
    freq.put("）； ", 16);
    freq.put("是丁丁", 58);
    freq.put(" ╰", 18);
    freq.put(" （之", 22);
    freq.put("三中三", 58);
    freq.put("仗！丹", 14);
    freq.put("么之。", 29);
    freq.put("三》三", 8);
    freq.put(" 么丑", 10);
    freq.put("三万俩", 13);
    freq.put("专坤专", 7);
    freq.put("之中之", 29);
    freq.put("啧啧 ", 8);
    freq.put("丁华 ", 11);
    freq.put("丘万临", 11);
    freq.put(" 丹大", 7);
    freq.put("专》", 99);
    freq.put("稣", 8);
    freq.put("丘万三", 58);
    freq.put("丘万万", 13);
    freq.put("丫", 239);
    freq.put("临乙 ", 37);
    freq.put("丙临，", 16);
    freq.put("亥。", 24);
    freq.put("丑专专", 12);
    freq.put(" （于", 7);
    freq.put("丘万丘", 12);
    freq.put("丘万丙", 7);
    freq.put("是丁专", 70);
    freq.put("丘万专", 25);
    freq.put("，乘丁", 45);
    freq.put("丛三，", 34);
    freq.put("三】", 82);
    freq.put("三【", 8);
    freq.put("，乘一", 10);
    freq.put("三乘的", 57);
    freq.put("是一三", 15);
    freq.put("三》", 54);
    freq.put("三《", 50);
    freq.put("三」", 22);
    freq.put("三「", 26);
    freq.put("华】", 10);
    freq.put("三、", 211);
    freq.put("三　", 9);
    freq.put("三。", 857);
    freq.put(" 么丁", 9);
    freq.put("为丹之", 8);
    freq.put("丘万之", 32);
    freq.put("丑专之", 8);
    freq.put("丙乙的", 8);
    freq.put("么是", 31);
    freq.put("临乱乙", 10);
    freq.put("丁之：", 18);
    freq.put("乱，且", 11);
    freq.put("三！！", 16);
    freq.put("乱，专", 10);
    freq.put("－临临", 37);
    freq.put("　－", 36);
    freq.put("三三日", 16);
    freq.put("乱，三", 23);
    freq.put("三万于", 24);
    freq.put("丙丁丹", 12);
    freq.put("专丛人", 9);
    freq.put("且的三", 23);
    freq.put("乘是专", 13);
    freq.put("乱，丹", 10);
    freq.put("乙万华", 24);
    freq.put("且的丁", 18);
    freq.put("的。。", 32);
    freq.put("三万人", 28);
    freq.put("乘是丘", 8);
    freq.put("人万三", 16);
    freq.put("专】三", 10);
    freq.put("乱大", 14);
    freq.put("︶", 18);
    freq.put("且的专", 22);
    freq.put("人万丁", 10);
    freq.put("专】丁", 9);
    freq.put("乘是三", 22);
    freq.put("三万仗", 14);
    freq.put("乱，乘", 9);
    freq.put("之丁是", 48);
    freq.put("丁丹 ", 55);
    freq.put("乱，之", 9);
    freq.put(" 三 ", 184);
    freq.put("且的之", 15);
    freq.put("乎么的", 48);
    freq.put("专丘。", 31);
    freq.put("万， ", 14);
    freq.put("丁专：", 57);
    freq.put("丁专？", 9);
    freq.put("专】之", 7);
    freq.put("专丛仗", 7);
    freq.put("人万之", 12);
    freq.put("三之且", 153);
    freq.put("丁在", 177);
    freq.put("丁专（", 9);
    freq.put("乘是之", 12);
    freq.put("丁专，", 166);
    freq.put("丁", 36568);
    freq.put("乙之！", 48);
    freq.put("三万且", 56);
    freq.put("三万专", 328);
    freq.put("三万丑", 9);
    freq.put("专丛中", 7);
    freq.put("。临丁", 16);
    freq.put("三万丛", 52);
    freq.put("乘临机", 8);
    freq.put("三万丙", 30);
    freq.put("三万丘", 75);
    freq.put("三万万", 94);
    freq.put("专丛临", 40);
    freq.put("三万丁", 224);
    freq.put("三万一", 30);
    freq.put(" 仞 ", 9);
    freq.put("专丛丹", 53);
    freq.put("三万三", 707);
    freq.put("三万丈", 10);
    freq.put("专丛万", 13);
    freq.put("三万临", 134);
    freq.put("专丛丁", 43);
    freq.put("国三丹", 7);
    freq.put("专丛三", 78);
    freq.put("三万为", 9);
    freq.put("三万丹", 83);
    freq.put("专丛且", 17);
    freq.put("三万丢", 14);
    freq.put("专丛专", 65);
    freq.put("乱丁，", 11);
    freq.put("三万中", 21);
    freq.put("专丛丙", 8);
    freq.put("〜〜", 7);
    freq.put("专丛丛", 22);
    freq.put("！三丘", 8);
    freq.put("！三专", 15);
    freq.put("三之丙", 48);
    freq.put("！三三", 24);
    freq.put("丘。专", 10);
    freq.put("三万乎", 14);
    freq.put("！三万", 9);
    freq.put("！三丁", 7);
    freq.put("三万么", 27);
    freq.put("丙之 ", 44);
    freq.put("三万乱", 14);
    freq.put("专丛么", 23);
    freq.put("专丛之", 118);
    freq.put("之丐 ", 10);
    freq.put("丘。三", 21);
    freq.put("专丛乙", 14);
    freq.put("专丛乘", 9);
    freq.put("之为专", 31);
    freq.put("是之专", 65);
    freq.put("）、三", 13);
    freq.put("是之丘", 20);
    freq.put("是之丛", 9);
    freq.put("，刨", 15);
    freq.put("是之丁", 46);
    freq.put("丁亥 ", 12);
    freq.put("之为一", 8);
    freq.put("之为丁", 33);
    freq.put("之为万", 11);
    freq.put("是之万", 18);
    freq.put("是之三", 98);
    freq.put("之为三", 62);
    freq.put("乎乘三", 9);
    freq.put("专在是", 40);
    freq.put("（中国", 9);
    freq.put("的劈", 10);
    freq.put("之为临", 15);
    freq.put("为万三", 7);
    freq.put("是之丹", 12);
    freq.put("是之为", 53);
    freq.put("三丘大", 7);
    freq.put("是之丢", 7);
    freq.put("丹仗。", 8);
    freq.put("丹丁的", 42);
    freq.put("机", 666);
    freq.put("是之乙", 17);
    freq.put("中三 ", 17);
    freq.put("之为乘", 48);
    freq.put("之为之", 47);
    freq.put("是之之", 64);
    freq.put("：三万", 14);
    freq.put("！咚！", 7);
    freq.put("年", 1391);
    freq.put("丁·", 8);
    freq.put("大丈，", 7);
    freq.put("临之机", 11);
    freq.put("；三之", 9);
    freq.put("在三专", 64);
    freq.put("在三且", 8);
    freq.put("乙临三", 51);
    freq.put("在三丘", 21);
    freq.put("在三丛", 7);
    freq.put("在三一", 16);
    freq.put("在三丁", 28);
    freq.put("← ", 25);
    freq.put("丹专国", 8);
    freq.put("《丁三", 8);
    freq.put("在三三", 114);
    freq.put("丛乘。", 8);
    freq.put("亟的", 9);
    freq.put("是丛之", 30);
    freq.put("临万，", 18);
    freq.put("且之的", 27);
    freq.put("在三临", 18);
    freq.put("刨哟", 7);
    freq.put("丁大三", 40);
    freq.put("丁大万", 9);
    freq.put("在三丹", 12);
    freq.put("是之人", 13);
    freq.put("，劈", 21);
    freq.put("丛 ", 809);
    freq.put("撸", 26);
    freq.put("丁大专", 14);
    freq.put("三之丁", 770);
    freq.put("丹专之", 217);
    freq.put("；三三", 18);
    freq.put("在三乘", 8);
    freq.put("在三乙", 8);
    freq.put("；三丁", 8);
    freq.put("在大专", 17);
    freq.put("丘丈专", 7);
    freq.put("丹么三", 16);
    freq.put("丹亟三", 8);
    freq.put("；三专", 12);
    freq.put("在三之", 112);
    freq.put("之万是", 13);
    freq.put("丹专乎", 12);
    freq.put("丁 ", 2184);
    freq.put("丁大之", 8);
    freq.put("丁丁 ", 267);
    freq.put(" ╯ ", 18);
    freq.put("专劈", 23);
    freq.put("丑丢之", 7);
    freq.put("且三 ", 58);
    freq.put("乙丈 ", 10);
    freq.put("临丹万", 16);
    freq.put(" 年丹", 10);
    freq.put(" 年临", 15);
    freq.put("。临临", 9);
    freq.put(" 年中", 8);
    freq.put("且么之", 10);
    freq.put(" 倪之", 7);
    freq.put("丰之之", 9);
    freq.put("丐在", 8);
    freq.put("之年 ", 23);
    freq.put("三坤三", 7);
    freq.put(" 亥亥", 10);
    freq.put(" 年且", 10);
    freq.put(" 年专", 26);
    freq.put("丙丙的", 10);
    freq.put("丹专乘", 55);
    freq.put("专华", 397);
    freq.put(" 年三", 89);
    freq.put("专专临", 415);
    freq.put(" 年万", 28);
    freq.put("么一三", 13);
    freq.put("之，乎", 13);
    freq.put(" 年丁", 14);
    freq.put("丰之专", 12);
    freq.put(" 丐丐", 7);
    freq.put("人临三", 22);
    freq.put("中，", 65);
    freq.put("人临丁", 14);
    freq.put("之丢的", 24);
    freq.put("专三。", 134);
    freq.put("专三、", 28);
    freq.put("人临丘", 7);
    freq.put("且么三", 10);
    freq.put("专三》", 8);
    freq.put("专三《", 10);
    freq.put(" 丐三", 7);
    freq.put("之，之", 361);
    freq.put("人临专", 18);
    freq.put("，华", 51);
    freq.put("临之是", 20);
    freq.put("人临丹", 12);
    freq.put("临丹专", 111);
    freq.put("万专是", 23);
    freq.put("丁临大", 13);
    freq.put("乙婊", 9);
    freq.put("专叶", 7);
    freq.put("坏之 ", 7);
    freq.put("之丙丹", 11);
    freq.put("丕", 90);
    freq.put(" 亥丙", 7);
    freq.put("专是：", 8);
    freq.put("？", 1634);
    freq.put("之丙临", 30);
    freq.put("之丙三", 42);
    freq.put("的丛 ", 18);
    freq.put("之丙丁", 59);
    freq.put("之丙万", 10);
    freq.put("乙冲万", 36);
    freq.put("之丙丛", 7);
    freq.put("之丙丙", 7);
    freq.put("之丙丘", 19);
    freq.put("临丈三", 8);
    freq.put("之丙专", 39);
    freq.put("之丙丑", 8);
    freq.put("临丈丁", 7);
    freq.put("三的？", 14);
    freq.put(" 亥之", 10);
    freq.put("乎邡", 9);
    freq.put("　中三", 27);
    freq.put("三的，", 59);
    freq.put(" 亥乙", 7);
    freq.put("之丙乱", 13);
    freq.put("专厥", 10);
    freq.put("三的！", 9);
    freq.put("之丙之", 54);
    freq.put("乙冲之", 7);
    freq.put("专专丛", 112);
    freq.put("丛之国", 8);
    freq.put("之丙乙", 8);
    freq.put("于：", 7);
    freq.put("临丈之", 7);
    freq.put("专专且", 94);
    freq.put("么丹？", 8);
    freq.put("年之丁", 16);
    freq.put(" 人丘", 7);
    freq.put("万之仗", 13);
    freq.put("年之三", 20);
    freq.put("年之且", 8);
    freq.put("年之专", 12);
    freq.put("人丛之", 8);
    freq.put("三丁三", 853);
    freq.put("三么乘", 15);
    freq.put("三么乙", 12);
    freq.put("。三之", 79);
    freq.put("劈乙", 9);
    freq.put("乙万之", 31);
    freq.put("三的", 1930);
    freq.put("三么之", 50);
    freq.put("三么么", 48);
    freq.put("三么乎", 8);
    freq.put("·", 134);
    freq.put("仗之 ", 20);
    freq.put("专专三", 1298);
    freq.put("临丁是", 10);
    freq.put("三丁万", 171);
    freq.put("三么丹", 16);
    freq.put("三丁丁", 532);
    freq.put("年之之", 19);
    freq.put("三么临", 14);
    freq.put("临三乎", 8);
    freq.put("丹专丈", 8);
    freq.put("。三丹", 9);
    freq.put("。三临", 17);
    freq.put("之华丁", 33);
    freq.put("临之人", 14);
    freq.put("乙万丹", 10);
    freq.put("乙万万", 7);
    freq.put("三么丛", 13);
    freq.put("三么丘", 11);
    freq.put("万之人", 14);
    freq.put("乙万丁", 13);
    freq.put("。三三", 151);
    freq.put("三么专", 44);
    freq.put("临丛丹", 11);
    freq.put("三么且", 11);
    freq.put("。三丁", 32);
    freq.put("三么三", 59);
    freq.put("乙万专", 13);
    freq.put("。三丘", 28);
    freq.put("。三且", 14);
    freq.put("三么丁", 25);
    freq.put("。三专", 78);
    freq.put("万之乙", 39);
    freq.put("万之乘", 52);
    freq.put("丹专一", 34);
    freq.put("丹专万", 74);
    freq.put("丁三？", 12);
    freq.put("！！之", 12);
    freq.put("万之么", 20);
    freq.put("万之之", 201);
    freq.put("劈，", 29);
    freq.put("且。 ", 8);
    freq.put("三丢冲", 12);
    freq.put("劈！", 9);
    freq.put("？丁之", 7);
    freq.put("临之日", 7);
    freq.put("丢的丁", 14);
    freq.put("，傀", 7);
    freq.put("日，三", 29);
    freq.put("万之乱", 8);
    freq.put("三丁丑", 10);
    freq.put("丢的三", 17);
    freq.put("丹专丙", 15);
    freq.put("之华专", 31);
    freq.put("丹专丘", 19);
    freq.put("大。", 20);
    freq.put("丁的 ", 63);
    freq.put("万之丙", 16);
    freq.put("万之丘", 42);
    freq.put("万之丛", 25);
    freq.put("！！丁", 11);
    freq.put("且丹的", 11);
    freq.put("专专乱", 25);
    freq.put("万之专", 217);
    freq.put("！！三", 21);
    freq.put("丙乱 ", 7);
    freq.put("之专俘", 17);
    freq.put("万之三", 305);
    freq.put("万之丈", 7);
    freq.put("！！专", 12);
    freq.put("万之丁", 149);
    freq.put("三万华", 7);
    freq.put("万之万", 64);
    freq.put("万之丹", 57);
    freq.put("万之为", 9);
    freq.put("之机万", 17);
    freq.put("的！！", 9);
    freq.put("万之临", 101);
    freq.put("乙大", 18);
    freq.put("专么 ", 41);
    freq.put("万之中", 9);
    freq.put("专傀", 7);
    freq.put("！！丹", 11);
    freq.put("专丙三", 47);
    freq.put("丁三（", 17);
    freq.put("。", 8318);
    freq.put("专丹乘", 30);
    freq.put("（", 868);
    freq.put("专人丁", 44);
    freq.put("专人万", 20);
    freq.put("专人丛", 9);
    freq.put("专人专", 78);
    freq.put("且丑", 31);
    freq.put("专大的", 9);
    freq.put("专人且", 9);
    freq.put("是丛 ", 12);
    freq.put("专人丢", 8);
    freq.put("傭", 13);
    freq.put("之，丙", 21);
    freq.put("专人丹", 16);
    freq.put("乙丘，", 23);
    freq.put("月三之", 7);
    freq.put("专人临", 19);
    freq.put("专人之", 100);
    freq.put("乘三。", 16);
    freq.put("三丁为", 9);
    freq.put(" 丁乘", 54);
    freq.put("专人乙", 7);
    freq.put("三丁临", 319);
    freq.put(" 乙，", 7);
    freq.put("月 ", 449);
    freq.put("丁乘。", 16);
    freq.put("乙专：", 15);
    freq.put("（三", 107);
    freq.put("国劈", 11);
    freq.put(" （华", 10);
    freq.put("俩、", 9);
    freq.put("专乙：", 7);
    freq.put("俩。", 39);
    freq.put("专乙？", 7);
    freq.put("丘。 ", 56);
    freq.put(" 之。", 11);
    freq.put("三临，", 127);
    freq.put("丢三。", 9);
    freq.put("三临！", 13);
    freq.put("临乘，", 35);
    freq.put("，冲", 40);
    freq.put("：中国", 39);
    freq.put("的丘大", 7);
    freq.put("咚", 9);
    freq.put("乎丛，", 8);
    freq.put("丹！ ", 13);
    freq.put("冲之之", 15);
    freq.put("、乘三", 8);
    freq.put("三丙乙", 20);
    freq.put("丈之三", 23);
    freq.put("丈之丁", 8);
    freq.put("专专么", 72);
    freq.put("专专之", 884);
    freq.put("冲之专", 29);
    freq.put("专冲", 78);
    freq.put("丫，", 10);
    freq.put("临：", 122);
    freq.put("冲之丁", 9);
    freq.put("冲之三", 20);
    freq.put("！乘专", 8);
    freq.put("丈之乘", 7);
    freq.put("之， ", 86);
    freq.put("丢、", 15);
    freq.put("丢。", 67);
    freq.put("乩", 90);
    freq.put("乙丢专", 9);
    freq.put("丢》", 9);
    freq.put("丈之之", 23);
    freq.put("专且丘", 12);
    freq.put("一）", 7);
    freq.put("乙丢丁", 8);
    freq.put("专？之", 7);
    freq.put("万丁", 1066);
    freq.put("于是", 69);
    freq.put("，在中", 9);
    freq.put("且专人", 19);
    freq.put("专且丙", 8);
    freq.put("的亟", 8);
    freq.put("，在丹", 8);
    freq.put("，在万", 7);
    freq.put("之三在", 71);
    freq.put("。专临", 25);
    freq.put("》之", 46);
    freq.put("的亥", 23);
    freq.put("三且。", 7);
    freq.put("，在三", 36);
    freq.put("之丛。", 18);
    freq.put("乱三国", 7);
    freq.put("的人", 373);
    freq.put("》乘", 7);
    freq.put("丁万是", 7);
    freq.put(" 丁丁", 410);
    freq.put("临于 ", 8);
    freq.put("丹万，", 20);
    freq.put("丘日三", 8);
    freq.put("》中", 11);
    freq.put("丹万（", 9);
    freq.put("的仞", 11);
    freq.put("》临", 19);
    freq.put("丁三的", 197);
    freq.put("的仕", 9);
    freq.put(" 가", 67);
    freq.put("》万", 13);
    freq.put("丘 ", 765);
    freq.put(" 丁万", 79);
    freq.put(" 乙的", 7);
    freq.put("並亞", 8);
    freq.put("》专", 41);
    freq.put("是三大", 8);
    freq.put("並亂", 11);
    freq.put("～～ ", 8);
    freq.put("么专之", 51);
    freq.put("临。 ", 80);
    freq.put("》丘", 7);
    freq.put("临！！", 8);
    freq.put("丈丁三", 23);
    freq.put("丹的，", 17);
    freq.put("？丛", 10);
    freq.put("丹三 ", 58);
    freq.put("专国", 126);
    freq.put("的三", 1902);
    freq.put("丈丁丁", 9);
    freq.put("丘大的", 8);
    freq.put("？且", 20);
    freq.put("仗仗丹", 7);
    freq.put("的一", 236);
    freq.put("的丁", 1102);
    freq.put("之为丹", 42);
    freq.put("万丹", 417);
    freq.put("的丘", 316);
    freq.put("的丙", 141);
    freq.put("？万", 13);
    freq.put("的且", 71);
    freq.put("丈丁专", 14);
    freq.put("丰且专", 8);
    freq.put("且乎么", 18);
    freq.put("的丐", 15);
    freq.put("的丑", 29);
    freq.put("的中", 70);
    freq.put("丁人，", 19);
    freq.put("？为", 7);
    freq.put("仗仗专", 9);
    freq.put("年专三", 21);
    freq.put("年专万", 8);
    freq.put("？临", 18);
    freq.put("是临的", 9);
    freq.put("？中", 7);
    freq.put("的丹", 206);
    freq.put("乘冲", 18);
    freq.put("的临", 532);
    freq.put("並之", 14);
    freq.put("仗仗三", 10);
    freq.put("年专专", 20);
    freq.put("的丰", 21);
    freq.put("的乎", 22);
    freq.put("丈丁之", 16);
    freq.put("丰且之", 11);
    freq.put("的之", 1166);
    freq.put("的么", 90);
    freq.put("？乘", 24);
    freq.put("三丙三", 52);
    freq.put("专丁乙", 68);
    freq.put("之且的", 31);
    freq.put("是？", 7);
    freq.put("？乎", 8);
    freq.put("？之", 60);
    freq.put("是：", 29);
    freq.put("並並", 27);
    freq.put("的乙", 259);
    freq.put("三于丘", 9);
    freq.put("，国", 32);
    freq.put("么专乘", 10);
    freq.put("亟亟 ", 7);
    freq.put("並专", 7);
    freq.put("年专之", 12);
    freq.put("丹专人", 24);
    freq.put("並丘", 7);
    freq.put("丘之 ", 117);
    freq.put("並丁", 10);
    freq.put("》之三", 13);
    freq.put("並三", 29);
    freq.put("》之万", 7);
    freq.put("的乱", 62);
    freq.put("三的且", 15);
    freq.put("万仗", 94);
    freq.put("仗佛佛", 10);
    freq.put("之日之", 7);
    freq.put("大丁专", 14);
    freq.put("，在", 173);
    freq.put("国万丁", 9);
    freq.put("三丁于", 19);
    freq.put("大丁三", 28);
    freq.put("。一", 46);
    freq.put("么！！", 10);
    freq.put("大丁丁", 11);
    freq.put("专坤", 23);
    freq.put("中三乙", 10);
    freq.put("中三乘", 18);
    freq.put("三丐三", 12);
    freq.put("之之于", 17);
    freq.put("的乘之", 27);
    freq.put("华乘 ", 10);
    freq.put("三丐丘", 7);
    freq.put("万丁，", 20);
    freq.put("之丘乙", 34);
    freq.put("是乙临", 10);
    freq.put("三乱之", 41);
    freq.put("之日三", 37);
    freq.put("大丁乘", 8);
    freq.put("专圳", 8);
    freq.put("婊", 19);
    freq.put("专在", 710);
    freq.put("且且是", 7);
    freq.put("的俘", 25);
    freq.put("国万之", 19);
    freq.put("並並並", 8);
    freq.put("之日专", 15);
    freq.put("丹专于", 10);
    freq.put("临丹华", 8);
    freq.put("的乘丛", 7);
    freq.put("机之三", 8);
    freq.put("的乘丙", 9);
    freq.put("的乘丘", 7);
    freq.put("丘专人", 21);
    freq.put("三丐之", 8);
    freq.put("的乘专", 21);
    freq.put("並三 ", 7);
    freq.put("丁万 ", 55);
    freq.put("乙丛。", 11);
    freq.put("的乘三", 45);
    freq.put("丙。 ", 24);
    freq.put(" 中丛", 9);
    freq.put("仗", 3333);
    freq.put("的乘丁", 27);
    freq.put("的乘一", 7);
    freq.put("丘乎专", 9);
    freq.put("乘的 ", 25);
    freq.put("中国大", 37);
    freq.put("丘专乙", 12);
    freq.put("乎万三", 8);
    freq.put("仗的", 75);
    freq.put("丁专日", 9);
    freq.put("丘专之", 113);
    freq.put("丘专么", 18);
    freq.put("一万之", 17);
    freq.put("丁丛在", 8);
    freq.put("万乙冲", 8);
    freq.put("珉", 8);
    freq.put("乎丛", 69);
    freq.put("丙丁 ", 59);
    freq.put("临 ", 1487);
    freq.put("丘专专", 147);
    freq.put("一万且", 9);
    freq.put("？佛", 8);
    freq.put("一万专", 18);
    freq.put("丘专且", 18);
    freq.put("丘专丛", 10);
    freq.put("丘专丘", 32);
    freq.put(" 是", 200);
    freq.put("一万万", 21);
    freq.put("丘专丁", 76);
    freq.put("丘专万", 30);
    freq.put("一万一", 8);
    freq.put("一万丁", 12);
    freq.put("丘乎么", 10);
    freq.put("丘专三", 162);
    freq.put("一万三", 36);
    freq.put("一万临", 30);
    freq.put("丘专临", 77);
    freq.put("三三？", 20);
    freq.put("丘专丹", 27);
    freq.put("专三！", 13);
    freq.put("三三；", 18);
    freq.put("三三：", 77);
    freq.put("丘专丢", 7);
    freq.put("三三！", 30);
    freq.put("三三，", 492);
    freq.put("三三）", 12);
    freq.put("三三（", 15);
    freq.put("丘专中", 12);
    freq.put("三丹大", 7);
    freq.put("万华专", 13);
    freq.put("，么之", 12);
    freq.put("，么么", 31);
    freq.put("丁丁，", 211);
    freq.put("丛之三", 165);
    freq.put("、丙", 15);
    freq.put("丹且 ", 27);
    freq.put("专之（", 11);
    freq.put("。临", 157);
    freq.put("之丈三", 21);
    freq.put("之临丢", 21);
    freq.put("。丰", 9);
    freq.put("专三，", 267);
    freq.put("丛之万", 30);
    freq.put("中三三", 100);
    freq.put("乘华", 75);
    freq.put("专吾", 18);
    freq.put("丛之丁", 83);
    freq.put("三丁人", 47);
    freq.put("，么三", 15);
    freq.put(" ： ", 28);
    freq.put("之丈丁", 12);
    freq.put("之临丘", 67);
    freq.put("丁专是", 43);
    freq.put("之临丙", 19);
    freq.put("之丁！", 26);
    freq.put("临专临", 121);
    freq.put("丘丢丁", 13);
    freq.put("之丁）", 9);
    freq.put("之丁（", 9);
    freq.put("之丁，", 179);
    freq.put("丘临。", 12);
    freq.put("之丁：", 31);
    freq.put("丁丁且", 53);
    freq.put("之丁？", 9);
    freq.put("丛之丘", 27);
    freq.put("丛之丛", 15);
    freq.put("佛之之", 9);
    freq.put("人大", 30);
    freq.put("丛之且", 21);
    freq.put("之临专", 244);
    freq.put("国三专", 131);
    freq.put("丁乎么", 32);
    freq.put("丁乎之", 23);
    freq.put("＂临", 8);
    freq.put("乱临的", 8);
    freq.put("丛之专", 115);
    freq.put("之临丈", 9);
    freq.put("丁乎乘", 8);
    freq.put("《之丁", 8);
    freq.put("三万在", 24);
    freq.put("丁丢 ", 15);
    freq.put("俘三丁", 8);
    freq.put("佛之三", 9);
    freq.put("俘三三", 11);
    freq.put("专： ", 139);
    freq.put("佛之丁", 12);
    freq.put("丁乎临", 12);
    freq.put("俘三专", 11);
    freq.put("＂乘", 9);
    freq.put("佛之专", 12);
    freq.put("专之华", 33);
    freq.put("丁乎万", 8);
    freq.put("丁乎丁", 17);
    freq.put("之临一", 16);
    freq.put("冲专 ", 8);
    freq.put("丁乎三", 36);
    freq.put("丁乎且", 8);
    freq.put("丁乎专", 16);
    freq.put("为中国", 19);
    freq.put("丁乎丛", 9);
    freq.put("之丘。", 26);
    freq.put("︶¯", 7);
    freq.put("之的大", 11);
    freq.put("万丘三", 44);
    freq.put("乙乙丢", 8);
    freq.put("之之丹", 148);
    freq.put("】三之", 8);
    freq.put("之之为", 14);
    freq.put("乙乙丘", 8);
    freq.put("国的", 121);
    freq.put("乙乙万", 9);
    freq.put("乙乙丁", 24);
    freq.put("丛之丹", 41);
    freq.put("乙乙三", 31);
    freq.put("丁之", 4301);
    freq.put("丁丁乎", 23);
    freq.put("丁专机", 7);
    freq.put("丛之临", 35);
    freq.put("丁大 ", 7);
    freq.put("。（专", 9);
    freq.put(" ｡ ", 18);
    freq.put("之之中", 33);
    freq.put("乘丙之", 18);
    freq.put("】三三", 10);
    freq.put("三万国", 7);
    freq.put("℃ ", 16);
    freq.put("专丰年", 8);
    freq.put("且三乎", 11);
    freq.put("】三丘", 8);
    freq.put("临三的", 89);
    freq.put("且三么", 13);
    freq.put("专中的", 8);
    freq.put("】三专", 7);
    freq.put("三俘之", 17);
    freq.put("乘劈", 13);
    freq.put("么～", 7);
    freq.put("丑，丹", 8);
    freq.put("于万之", 10);
    freq.put("丑", 1219);
    freq.put("；", 498);
    freq.put("临丁、", 11);
    freq.put(" 《大", 7);
    freq.put("丛之之", 99);
    freq.put("（《丘", 12);
    freq.put("之大，", 9);
    freq.put(" 】 ", 19);
    freq.put("乘临！", 9);
    freq.put("丑，三", 8);
    freq.put("临丁。", 36);
    freq.put("乘临，", 22);
    freq.put("丑，丁", 8);
    freq.put("么：", 14);
    freq.put("是且三", 8);
    freq.put("三俘三", 17);
    freq.put("凄", 14);
    freq.put("是且丁", 10);
    freq.put("≧▽", 9);
    freq.put("于万三", 12);
    freq.put("么（", 8);
    freq.put("么，", 225);
    freq.put("三俘专", 7);
    freq.put("么！", 120);
    freq.put("是且且", 8);
    freq.put("乙乙仗", 8);
    freq.put("丛三是", 12);
    freq.put("」。", 20);
    freq.put("」「", 11);
    freq.put("大乙临", 7);
    freq.put("丑，之", 7);
    freq.put("丛之乙", 20);
    freq.put("丛之乘", 39);
    freq.put("乱专", 251);
    freq.put("华丁丁", 28);
    freq.put("乱且", 45);
    freq.put("乱丙", 40);
    freq.put("乱丘", 99);
    freq.put("乱丛", 39);
    freq.put("华丁三", 43);
    freq.put("乱丁", 220);
    freq.put("乱一", 11);
    freq.put("专的 ", 88);
    freq.put("乱万", 52);
    freq.put("乱三", 371);
    freq.put("乱丈", 16);
    freq.put("万日三", 7);
    freq.put("国：", 8);
    freq.put("在三 ", 12);
    freq.put("가가 ", 56);
    freq.put("乱临", 153);
    freq.put("乱丹", 60);
    freq.put("乱丢", 22);
    freq.put("华丁临", 18);
    freq.put("于是专", 8);
    freq.put("乱中", 28);
    freq.put("之之丈", 19);
    freq.put("万丁人", 12);
    freq.put("乱乙", 68);
    freq.put("乱乘", 61);
    freq.put("之！！", 56);
    freq.put("乱。 ", 16);
    freq.put("年三的", 15);
    freq.put("（华", 18);
    freq.put("国，", 57);
    freq.put("乱么", 20);
    freq.put("乱之", 352);
    freq.put("之之万", 208);
    freq.put("乱乎", 12);
    freq.put("乱乱", 30);
    freq.put("。日", 8);
    freq.put("么丹的", 7);
    freq.put("之之一", 92);
    freq.put("丙三且", 14);
    freq.put("三大的", 34);
    freq.put("万（ ", 13);
    freq.put("?", 153);
    freq.put("、丛之", 9);
    freq.put("人在", 59);
    freq.put("大万专", 23);
    freq.put("乙华", 15);
    freq.put("丢么之", 7);
    freq.put("万丁乱", 9);
    freq.put("大万万", 9);
    freq.put("是丹之", 20);
    freq.put("且三丘", 39);
    freq.put("大万三", 51);
    freq.put("且三丙", 16);
    freq.put("大万临", 9);
    freq.put("【三之", 8);
    freq.put("万丁乙", 22);
    freq.put("万丁乘", 13);
    freq.put("乱人", 15);
    freq.put("大万丹", 10);
    freq.put("、临三", 20);
    freq.put("三万大", 11);
    freq.put("且三且", 43);
    freq.put("万丁之", 138);
    freq.put("、临专", 13);
    freq.put("万丁么", 21);
    freq.put("丙丙，", 10);
    freq.put("丘俘三", 7);
    freq.put("、临丘", 7);
    freq.put("中的", 64);
    freq.put("仗。", 174);
    freq.put("万丁丹", 23);
    freq.put("万丁临", 67);
    freq.put("是丹专", 56);
    freq.put("之丢：", 8);
    freq.put("亥三三", 9);
    freq.put("国专机", 7);
    freq.put("是丹三", 57);
    freq.put("是丹万", 8);
    freq.put("且日", 12);
    freq.put("是丹丁", 26);
    freq.put("【三三", 38);
    freq.put("万丁丛", 30);
    freq.put("万丁丙", 17);
    freq.put("万丁丘", 31);
    freq.put("三丁日", 7);
    freq.put("！丹的", 8);
    freq.put("万丁且", 20);
    freq.put("万丁专", 109);
    freq.put("、临之", 11);
    freq.put("丹是 ", 8);
    freq.put("万丁三", 156);
    freq.put("万丁丈", 9);
    freq.put("万丁万", 49);
    freq.put("丹丈专", 10);
    freq.put("【三专", 8);
    freq.put("之且 ", 32);
    freq.put("万丁丁", 113);
    freq.put("丁且", 502);
    freq.put(" 专：", 37);
    freq.put("三、三", 46);
    freq.put(" 临么", 20);
    freq.put("万三】", 24);
    freq.put("丙劈", 15);
    freq.put("乙丁仗", 8);
    freq.put("乎丛 ", 10);
    freq.put("三、丁", 23);
    freq.put("侏", 157);
    freq.put("丛之", 1217);
    freq.put("亟，", 34);
    freq.put("万三。", 30);
    freq.put("万三、", 8);
    freq.put(" 《丹", 9);
    freq.put("亟！", 12);
    freq.put("且三万", 77);
    freq.put("丁丁丙", 26);
    freq.put("且之，", 45);
    freq.put("三丘，", 71);
    freq.put("丛乎", 29);
    freq.put("三、丹", 14);
    freq.put("侮丁", 14);
    freq.put("在的", 49);
    freq.put("：乘丁", 8);
    freq.put("乙劈", 15);
    freq.put("三、之", 31);
    freq.put("：乘三", 17);
    freq.put("丘丑丁", 8);
    freq.put("：乘专", 13);
    freq.put("人三日", 24);
    freq.put("刨刨", 10);
    freq.put("之之乙", 86);
    freq.put("是丘乙", 8);
    freq.put(" ℃", 18);
    freq.put("乙丁人", 17);
    freq.put("丁並", 8);
    freq.put("之丢临", 25);
    freq.put("且三临", 73);
    freq.put("乙丁乙", 10);
    freq.put("乙丁乘", 9);
    freq.put("俘。", 21);
    freq.put("，三在", 7);
    freq.put("←", 33);
    freq.put("乙丁之", 77);
    freq.put("为丛之", 7);
    freq.put("庚", 34);
    freq.put("。在专", 7);
    freq.put("专》之", 10);
    freq.put("丁丰", 64);
    freq.put("之倪之", 8);
    freq.put("丹丁，", 32);
    freq.put("专，是", 22);
    freq.put("丁临", 2097);
    freq.put("乱且专", 7);
    freq.put("乙丁丛", 8);
    freq.put("乙丁且", 15);
    freq.put("临亟丁", 8);
    freq.put("丢三乘", 8);
    freq.put("乙丁专", 55);
    freq.put("乙丁三", 73);
    freq.put("【日", 7);
    freq.put("乙丁万", 16);
    freq.put("乙乙临", 23);
    freq.put("乱且三", 12);
    freq.put("乙丁丹", 17);
    freq.put("乙丁临", 36);
    freq.put(" →", 98);
    freq.put(" ←", 26);
    freq.put("乱之国", 9);
    freq.put("乱俩", 11);
    freq.put("临一专", 51);
    freq.put("临之中", 22);
    freq.put("且机", 9);
    freq.put(" ≧", 14);
    freq.put("万为三", 7);
    freq.put("三临的", 104);
    freq.put("镖", 7);
    freq.put("丹之万", 70);
    freq.put("么的。", 8);
    freq.put("乱之 ", 27);
    freq.put("丁么之", 34);
    freq.put("丁么么", 19);
    freq.put("喵", 36);
    freq.put("丁么乘", 9);
    freq.put("丁么乙", 19);
    freq.put("在专三", 59);
    freq.put("丫的", 14);
    freq.put(" ∩", 9);
    freq.put("中国国", 15);
    freq.put("◕", 7);
    freq.put("丁么临", 26);
    freq.put("丁么丹", 15);
    freq.put("哟", 37);
    freq.put("丁么丁", 30);
    freq.put("丁么万", 9);
    freq.put(" 《丁", 11);
    freq.put("丁么三", 67);
    freq.put("万乱。", 7);
    freq.put("丁么专", 45);
    freq.put("丁么且", 8);
    freq.put("丁么丘", 13);
    freq.put("乙冲", 92);
    freq.put("乘万的", 9);
    freq.put("丁。一", 8);
    freq.put("丁。丁", 20);
    freq.put("丁。三", 42);
    freq.put("丁。专", 46);
    freq.put("丁。且", 19);
    freq.put("专大，", 10);
    freq.put("人三是", 14);
    freq.put("专且 ", 35);
    freq.put("专；三", 8);
    freq.put("丁。临", 13);
    freq.put("乘三华", 7);
    freq.put("丁。丹", 17);
    freq.put("乙丘的", 15);
    freq.put("乘俩 ", 7);
    freq.put("噢噢", 8);
    freq.put("之俘三", 9);
    freq.put("日丁丁", 24);
    freq.put("丁。之", 35);
    freq.put("俩丁 ", 7);
    freq.put("丁。乘", 12);
    freq.put("专乙的", 19);
    freq.put("丛乱之", 7);
    freq.put("丘， ", 15);
    freq.put("之年且", 8);
    freq.put("华华】", 9);
    freq.put(" ⊙", 8);
    freq.put("专之俩", 10);
    freq.put("专之且", 95);
    freq.put("专之丑", 14);
    freq.put("专之丐", 10);
    freq.put("专之专", 735);
    freq.put("【机", 7);
    freq.put("于丁之", 11);
    freq.put(" 【乙", 19);
    freq.put(" 【乘", 18);
    freq.put("专之丙", 40);
    freq.put("专之丘", 122);
    freq.put("专之丛", 93);
    freq.put("且是", 554);
    freq.put("专之万", 240);
    freq.put("专之丁", 565);
    freq.put("专之一", 67);
    freq.put("三的人", 59);
    freq.put("的丹之", 21);
    freq.put(" 【之", 65);
    freq.put("∩ ", 9);
    freq.put("专之三", 1042);
    freq.put("专之丈", 18);
    freq.put("劈的", 25);
    freq.put("专之临", 288);
    freq.put("三丁是", 33);
    freq.put("三仗。", 27);
    freq.put("丙 ", 298);
    freq.put("专之丹", 120);
    freq.put("专之为", 20);
    freq.put("专之丢", 49);
    freq.put("专之中", 43);
    freq.put(" 【专", 53);
    freq.put("于丁丁", 11);
    freq.put("的丹丘", 10);
    freq.put("的丹丛", 9);
    freq.put(" 【丛", 13);
    freq.put("于丁三", 15);
    freq.put("专之乙", 89);
    freq.put("专之乘", 117);
    freq.put("的丹专", 23);
    freq.put("于丁专", 11);
    freq.put(" 【丁", 57);
    freq.put(" 【万", 14);
    freq.put("的丹三", 38);
    freq.put("，三国", 23);
    freq.put("丹中三", 9);
    freq.put(" 《乙", 8);
    freq.put(" 【三", 81);
    freq.put("专之乎", 13);
    freq.put("专大", 259);
    freq.put("的丹丁", 25);
    freq.put("专之之", 690);
    freq.put("三人。", 9);
    freq.put("专之乱", 34);
    freq.put("丁大", 148);
    freq.put("≦", 17);
    freq.put("的丹临", 15);
    freq.put("之年一", 8);
    freq.put("丁于华", 17);
    freq.put("丹之的", 16);
    freq.put("乘乙丁", 16);
    freq.put("乘年", 27);
    freq.put("么乙之", 10);
    freq.put("丁华三", 16);
    freq.put("且于。", 19);
    freq.put("亞三 ", 7);
    freq.put("专之于", 8);
    freq.put("〝", 16);
    freq.put("。是", 10);
    freq.put(" 冲乙", 7);
    freq.put("专之人", 68);
    freq.put("丛丹之", 50);
    freq.put("圳", 109);
    freq.put("踹", 8);
    freq.put(" 冲之", 17);
    freq.put("么乙丁", 9);
    freq.put("丛丹丹", 7);
    freq.put("丛万的", 8);
    freq.put("乘乘临", 15);
    freq.put("么乙三", 8);
    freq.put("乘乘丹", 8);
    freq.put("铊", 16);
    freq.put("国三丛", 9);
    freq.put("专亥乙", 7);
    freq.put("丛丹临", 8);
    freq.put("乘乘专", 36);
    freq.put(" 冲专", 12);
    freq.put("乘乘且", 9);
    freq.put("丁临华", 20);
    freq.put("乘乘丘", 8);
    freq.put("之） ", 20);
    freq.put(" 冲丁", 7);
    freq.put("：一专", 11);
    freq.put(" 冲三", 12);
    freq.put("屌丛", 11);
    freq.put("之专且", 87);
    freq.put("之专丑", 7);
    freq.put("俩的三", 12);
    freq.put("专临丢", 17);
    freq.put("临、专", 8);
    freq.put("专临中", 15);
    freq.put("的临 ", 7);
    freq.put("之专丙", 38);
    freq.put("之专丘", 137);
    freq.put("之专丛", 77);
    freq.put("专年", 73);
    freq.put("专临临", 141);
    freq.put("在之之", 45);
    freq.put("之专万", 225);
    freq.put("专临丰", 8);
    freq.put("之专一", 59);
    freq.put("临一丁", 14);
    freq.put("之专三", 958);
    freq.put("专临丹", 68);
    freq.put("之机，", 15);
    freq.put("国丛丘", 11);
    freq.put("之专临", 254);
    freq.put("专临万", 49);
    freq.put("专临一", 26);
    freq.put("专临丁", 194);
    freq.put("临仗专", 8);
    freq.put("专临丈", 11);
    freq.put("万万乘", 13);
    freq.put("之乎 ", 11);
    freq.put("之专为", 22);
    freq.put("专临且", 54);
    freq.put("专临专", 296);
    freq.put("之专中", 65);
    freq.put("专临丘", 48);
    freq.put("专临丙", 20);
    freq.put("万万之", 50);
    freq.put("哔哔", 18);
    freq.put("万万临", 28);
    freq.put("在之丘", 9);
    freq.put("在之专", 44);
    freq.put("万万丹", 10);
    freq.put("专丁丙", 28);
    freq.put("，年", 14);
    freq.put("在之三", 87);
    freq.put("专专俩", 13);
    freq.put("专临乱", 13);
    freq.put("国三一", 9);
    freq.put("之年乘", 7);
    freq.put("之专乎", 33);
    freq.put("之专么", 82);
    freq.put("之专之", 679);
    freq.put("三丁中", 25);
    freq.put("万万且", 12);
    freq.put("临万的", 13);
    freq.put("在之丹", 7);
    freq.put("三专丁", 496);
    freq.put("专专俘", 7);
    freq.put("万万专", 62);
    freq.put("（于国", 7);
    freq.put("专丁丘", 84);
    freq.put("专临么", 15);
    freq.put("万万丘", 15);
    freq.put("万万丛", 11);
    freq.put("专临之", 272);
    freq.put("三三的", 495);
    freq.put("万万万", 28);
    freq.put("万万丁", 40);
    freq.put("丛。。", 30);
    freq.put("万万三", 81);
    freq.put("专临乙", 43);
    freq.put(" ﹁ ", 10);
    freq.put("专于中", 10);
    freq.put("临丹，", 23);
    freq.put("丘的三", 62);
    freq.put("的专，", 60);
    freq.put("么华乘", 8);
    freq.put("之专于", 30);
    freq.put("专临人", 22);
    freq.put("专于丹", 13);
    freq.put("丛！专", 8);
    freq.put("专于万", 7);
    freq.put("专于丁", 12);
    freq.put("专临于", 7);
    freq.put("之三乙", 169);
    freq.put("乙坤", 11);
    freq.put("专于三", 30);
    freq.put("专于专", 30);
    freq.put("日华》", 11);
    freq.put("专于丘", 7);
    freq.put("之专仗", 22);
    freq.put(" 》 ", 13);
    freq.put("专冲丁", 10);
    freq.put("大三的", 15);
    freq.put("佛丁专", 7);
    freq.put("乙在", 14);
    freq.put("人华", 8);
    freq.put("专专佛", 8);
    freq.put("么丁 ", 41);
    freq.put("且丘的", 7);
    freq.put("专于之", 26);
    freq.put("专临仗", 12);
    freq.put("三亥。", 8);
    freq.put("丁丑 ", 8);
    freq.put("一乘三", 14);
    freq.put("丁一三", 52);
    freq.put("乙？", 24);
    freq.put("专专人", 115);
    freq.put("一乘丁", 7);
    freq.put("丁一丁", 26);
    freq.put(" ╮", 19);
    freq.put("丁一万", 11);
    freq.put(" ╭", 29);
    freq.put("丁一丘", 9);
    freq.put("一乘专", 17);
    freq.put("丁一专", 51);
    freq.put("专俘丁", 9);
    freq.put("丛，", 367);
    freq.put("专冲专", 11);
    freq.put("年临专", 10);
    freq.put("专俘三", 16);
    freq.put("丁人的", 19);
    freq.put("专专于", 25);
    freq.put("乙国", 14);
    freq.put("大三。", 11);
    freq.put("丁一临", 16);
    freq.put("一乘之", 9);
    freq.put("丁一之", 29);
    freq.put("是的", 16);
    freq.put("丈专丁", 13);
    freq.put("之三是", 137);
    freq.put("飙", 13);
    freq.put("的丁丁", 186);
    freq.put("之的华", 8);
    freq.put("专专仗", 40);
    freq.put("专俘之", 14);
    freq.put("年临之", 8);
    freq.put("专侏专", 7);
    freq.put("的且之", 15);
    freq.put("年临人", 16);
    freq.put("专专丹", 197);
    freq.put("专专为", 25);
    freq.put("倉", 41);
    freq.put("华的", 41);
    freq.put("专仗。", 26);
    freq.put("专专丰", 9);
    freq.put("专专中", 56);
    freq.put("专仞 ", 7);
    freq.put("专专丢", 46);
    freq.put("专专丙", 45);
    freq.put("专专丘", 157);
    freq.put("亥之三", 10);
    freq.put("，乎且", 12);
    freq.put("万乙，", 11);
    freq.put("机万专", 9);
    freq.put("专专丑", 13);
    freq.put(" ●", 7);
    freq.put("亥之丁", 8);
    freq.put("机万三", 8);
    freq.put("，乎三", 8);
    freq.put("专专丈", 18);
    freq.put("专专万", 215);
    freq.put("临丈 ", 12);
    freq.put("亥之专", 7);
    freq.put("专专一", 52);
    freq.put("的且三", 10);
    freq.put("：）", 10);
    freq.put("丁三；", 10);
    freq.put("丁三：", 25);
    freq.put("之乘三", 169);
    freq.put("的且丁", 7);
    freq.put("的且万", 7);
    freq.put("专临俩", 9);
    freq.put("：＂", 12);
    freq.put("丁三，", 214);
    freq.put("丁三）", 8);
    freq.put("三） ", 26);
    freq.put("丁三！", 24);
    freq.put("！ ", 677);
    freq.put("亥之之", 14);
    freq.put("专专乘", 127);
    freq.put("大之的", 9);
    freq.put("专专乎", 40);
    freq.put("，乎么", 20);
    freq.put("ㅋㅋㅋ", 12);
    freq.put("且丁，", 14);
    freq.put("乘丁，", 36);
    freq.put("之专俩", 12);
    freq.put("！?", 7);
    freq.put("临专三", 480);
    freq.put("之之人", 48);
    freq.put("三于临", 7);
    freq.put("。→ ", 7);
    freq.put("丘三，", 35);
    freq.put("之临乱", 8);
    freq.put("丘三：", 9);
    freq.put("人冲", 10);
    freq.put("三丘在", 14);
    freq.put("三乱乙", 10);
    freq.put("三乱乘", 14);
    freq.put("之。。", 194);
    freq.put(" 中三", 82);
    freq.put("三于专", 20);
    freq.put("丁丘。", 12);
    freq.put("乘专 ", 73);
    freq.put("乘临的", 22);
    freq.put("之临么", 24);
    freq.put("三于三", 33);
    freq.put("乙， ", 11);
    freq.put("丘且 ", 8);
    freq.put("三于万", 10);
    freq.put("三于丁", 10);
    freq.put("劈劈，", 13);
    freq.put("在乱", 14);
    freq.put("三乱丹", 13);
    freq.put("之临丹", 63);
    freq.put("之临临", 94);
    freq.put("三乱临", 16);
    freq.put("之临丰", 7);
    freq.put("之临中", 13);
    freq.put("丢！ ", 10);
    freq.put("么的", 153);
    freq.put("三于乘", 7);
    freq.put("三乘是", 12);
    freq.put("之临丛", 31);
    freq.put("之临且", 35);
    freq.put("之之仗", 25);
    freq.put("在华三", 13);
    freq.put("之临丑", 14);
    freq.put("三乱专", 35);
    freq.put(" 中之", 18);
    freq.put("丛的，", 15);
    freq.put("三乱三", 21);
    freq.put("之临三", 381);
    freq.put("三于之", 22);
    freq.put("三乱万", 7);
    freq.put("丛乙 ", 11);
    freq.put("三乱丁", 21);
    freq.put("之临丁", 181);
    freq.put("，且专", 106);
    freq.put("的，丁", 31);
    freq.put("的，一", 8);
    freq.put("的，万", 19);
    freq.put("，且且", 64);
    freq.put("，且丛", 8);
    freq.put("之之临", 245);
    freq.put("，且丙", 8);
    freq.put("亨专三", 7);
    freq.put("的，专", 50);
    freq.put("丹乙的", 8);
    freq.put("，且丁", 71);
    freq.put("，且一", 9);
    freq.put("，且万", 52);
    freq.put("的，且", 53);
    freq.put("的华丁", 14);
    freq.put("，且三", 237);
    freq.put("之三日", 14);
    freq.put("之之丢", 45);
    freq.put("专乘、", 7);
    freq.put("专乘。", 15);
    freq.put("丹丘丁", 16);
    freq.put("是丘丘", 14);
    freq.put("之之丘", 116);
    freq.put("之之丛", 78);
    freq.put("，且临", 22);
    freq.put("之之且", 96);
    freq.put("，且丹", 38);
    freq.put("之临仗", 15);
    freq.put("之之丑", 8);
    freq.put("之之丐", 10);
    freq.put("之之专", 668);
    freq.put("是丘专", 17);
    freq.put("丰 ", 23);
    freq.put("之之三", 1036);
    freq.put("是丘三", 24);
    freq.put("的，临", 23);
    freq.put("之乘丁", 91);
    freq.put("的，丹", 36);
    freq.put("是丘万", 8);
    freq.put("之之丁", 424);
    freq.put("是丘丁", 18);
    freq.put("，且中", 23);
    freq.put(" 『三", 9);
    freq.put("丁华大", 11);
    freq.put("之临人", 17);
    freq.put("的，之", 53);
    freq.put("，且乘", 30);
    freq.put("之之乱", 16);
    freq.put(" 一丁", 32);
    freq.put("之三乘", 206);
    freq.put("，且之", 160);
    freq.put("的，乘", 22);
    freq.put("，且乱", 7);
    freq.put("临三？", 8);
    freq.put("之丘，", 54);
    freq.put("且乘三", 63);
    freq.put("临三：", 13);
    freq.put("临三，", 89);
    freq.put("之临于", 10);
    freq.put("之之乎", 16);
    freq.put("之之么", 51);
    freq.put("之之之", 643);
    freq.put("是丘之", 18);
    freq.put("临三！", 11);
    freq.put("乱仗", 23);
    freq.put("临乘华", 7);
    freq.put("在专丁", 15);
    freq.put("在专万", 13);
    freq.put("《", 561);
    freq.put("在专专", 73);
    freq.put("临且丘", 9);
    freq.put("且乘丁", 27);
    freq.put("之专机", 10);
    freq.put("之三之", 1252);
    freq.put("乘丘。", 9);
    freq.put("，之 ", 20);
    freq.put("丢丁乙", 7);
    freq.put("临且专", 28);
    freq.put("在专临", 31);
    freq.put("仞 ", 78);
    freq.put("中之专", 34);
    freq.put("乱临，", 8);
    freq.put("在专丹", 9);
    freq.put("丢丁之", 39);
    freq.put("丢丁临", 28);
    freq.put("《万之", 20);
    freq.put("在专之", 55);
    freq.put("的华于", 10);
    freq.put("临、三", 12);
    freq.put("之之俩", 9);
    freq.put("在专乘", 12);
    freq.put("之之俘", 9);
    freq.put("专乎，", 11);
    freq.put("临的 ", 54);
    freq.put("临。。", 31);
    freq.put("专华》", 21);
    freq.put("丢丁丁", 16);
    freq.put("，专：", 7);
    freq.put("丢丁三", 30);
    freq.put("之三为", 47);
    freq.put("乘丰 ", 9);
    freq.put("冲三专", 15);
    freq.put("丁临在", 26);
    freq.put("丛丁 ", 51);
    freq.put("冲三三", 16);
    freq.put("的华乘", 9);
    freq.put("冲三丁", 10);
    freq.put("之临俘", 10);
    freq.put("∩", 17);
    freq.put("在专人", 9);
    freq.put("丘仗！", 15);
    freq.put("﹁", 10);
    freq.put("人之在", 7);
    freq.put("乎么是", 16);
    freq.put("的华三", 10);
    freq.put("冲三之", 19);
    freq.put("的华专", 10);
    freq.put("之三临", 378);
    freq.put(" 临 ", 59);
    freq.put("中国华", 32);
    freq.put("之丁的", 146);
    freq.put("的华临", 20);
  }
  
}

