package;

import openfl.Lib;
import openfl.Assets;
import openfl.display.*;
import openfl.events.*;
import openfl.geom.*;
import openfl.media.*;
import openfl.text.*;
import openfl.utils.*;
import openfl.filters.*;
import openfl.sensors.*;
import openfl.system.System;
import Pen;

class Main extends Sprite {
	private var inited:Bool;
	private var menu:BitmapData;
	private var menuBitmap:Bitmap;
	private var menutr:BitmapData;
	private var menutrBitmap:Bitmap;
	private var help:BitmapData;
	private var helpBitmap:Bitmap;
	private var stageBg:BitmapData;
	private var stageBack:Bitmap;
	private var stageBg1:BitmapData;
	private var stageBack1:Bitmap;	
	private var stageBg2:BitmapData;
	private var stageBack2:Bitmap;
	private var stageBg3:BitmapData;
	private var stageBack3:Bitmap;
	private var stageBg4:BitmapData;
	private var stageBack4:Bitmap;
	private var stageBg5:BitmapData;
	private var stageBack5:Bitmap;
	private var stageBg6:BitmapData;
	private var stageBack6:Bitmap;
	
	private var levelaPlay:Sound;
	private var levelbPlay:Sound;
	private var menuMp3Play:Sound;
	private var gameoverPlay:Sound;
	private var errorPlay:Sound;
	
	private var jump1Play:Sound;
	private var jump2Play:Sound;
	private var jump3Play:Sound;
	private var jump4Play:Sound;
	private var jump5Play:Sound;
	private var jump6Play:Sound;
	private var jump7Play:Sound;
	private var jump8Play:Sound;
	private var jump9Play:Sound;
	private var jump10Play:Sound;
	
	private var hit1Play:Sound;
	private var hit2Play:Sound;
	private var hit3Play:Sound;
	private var hit4Play:Sound;
	private var hit5Play:Sound;
	private var hit6Play:Sound;
	private var hit7Play:Sound;
	private var hit8Play:Sound;
	private var hit9Play:Sound;
	private var hit10Play:Sound;
	private var hit11Play:Sound;
	private var hit12Play:Sound;
	private var hit13Play:Sound;
	private var hit14Play:Sound;
	
	private var w1Play:Sound;
	private var w2Play:Sound;
	private var w3Play:Sound;
	private var w4Play:Sound;
	private var w5Play:Sound;
	private var w6Play:Sound;
	private var w7Play:Sound;
	private var w8Play:Sound;
	private var w9Play:Sound;
	private var w10Play:Sound;
	
	private var p1Play:Sound;
	private var p2Play:Sound;
	private var p3Play:Sound;

	private var acc:Accelerometer;
	private var accX:Float = 0;		
	private var initialSpeedStart:Float = 15;
	private var displayArray:Array<DisplayObject>;
	private var m:Matrix;
	private var once:Bool = true;
	private var width2:Float = 810 * 2.2;
	private var radRandom:Int = 0;
	private var radRandomChance:Int = 0;
	private var st:SoundTransform = new SoundTransform();
	private var st2:SoundTransform = new SoundTransform();
	private var st3:SoundTransform = new SoundTransform();
	private var stt:SoundChannel = new SoundChannel();
	private var stt2:SoundChannel = new SoundChannel();
	private var stt3:SoundChannel = new SoundChannel();
	private var drawArcDetail:Float = 8;
	private var radRand:Int = 60 + 60 + 60 + 60 + 60 + 30;
	private var radRandTiltChance:Int = 5;
	private var radRandMinimum:Int = 200;
	
	private var jumpCount:Int = 0;
	private var jumpCountHelp:Int = 0;
	private var jumping:Bool = false;
	private var difficulty:Float = 0;
	private var difficultyMax:Float = 360;
	private var initial:Int = 0;
		
	private var arc:Sprite = new Sprite();
	private var arcRotate:Float = 0;
	private var center:Point = new Point();
	
	private var ball:Sprite = new Sprite();
	private var ballRed:Sprite = new Sprite();
	private var quad:Sprite = new Sprite();
	private var stageBackground:Bitmap = new Bitmap();
		
	private var arrowKeyUp:Bool = false;
	private var arrowKeyDown:Bool = false;
	private var arrowKeyLeft:Bool = false;
	private var arrowKeyRight:Bool = false;
	private var speedSlide:Float = 0;
	private var speedSlidePower:Float = 0;
	private var speedSlideMax:Float = 0;
	private var speedAccelerate:Float = 0;
	private var speedAcceleratePower:Float = 0;
	private var speedAccelerateMax:Float = 0;
	private var difficultySlice:Int = 1;
	private var maxNumberOfChildren:Int = 20;
		
	private var frameDisplay:TextField = new TextField();
	private var frameDisplayTextFormatter:TextFormat = new TextFormat();
	private var frameDisplayShow:TextField = new TextField();
	private var frameDisplayShowTextFormatter:TextFormat = new TextFormat();
	private var frameCount:Int = 0;
	private var frameCountSave:Int = 0;
	private var childSelect:DisplayObject;
		
	private var starsPen:Pen;
	private var displayCount:Int = 1;
	
	private var tick:Int = 0;
	private var ticker:Int = 0;
	private var tickerLeft:Int = 0;
	private var tickerRight:Int = 0;
		
	private var timer:Float = 0;
	private var initialPos:Float = 0;
	private var finalPos:Float = 0;
	private var currentPos:Float = 0;
	private var initialSpeed:Float = 0;
	private var startPosition:Float = 0;
	private var gravity:Float = 1.2;
	private var decay:Float = 0.5;
	private var wildCard:Int = 2;
	private var wildStep:Float = 1.03;
	private var wildStepSpeed:Float = 0.005;
	private var jumpLock:Bool = false;
	private var levelLock:Int = 0;
	private var levelColor:Int = 0x0000FF;

	private function drawArc (obj:Sprite, centerX:Float, centerY:Float, innerRadius:Int, outerRadius:Int, startAngle:Float, arcAngle:Float, steps:Int) {
		var twoPI = 2 * Math.PI;
		var angleStep = arcAngle/steps;
		var angle, i, endAngle;
		var angle, i, endAngle;
		var xx = centerX + Math.cos(startAngle * twoPI) * innerRadius;
		var yy = centerY + Math.sin(startAngle * twoPI) * innerRadius;
		var startPoint = {x:xx, y:yy};
		obj.graphics.moveTo(xx, yy);
		var i:Int = 0;
		for (i in 1...steps + 1) {
			angle = (startAngle + i * angleStep) * twoPI;
			xx = centerX + Math.cos(angle) * innerRadius;
			yy = centerY + Math.sin(angle) * innerRadius;
			obj.graphics.lineTo(xx, yy);
		}
		endAngle = startAngle + arcAngle;
		for (i in 0...steps + 1) {
			angle = (endAngle - i * angleStep) * twoPI;
			xx = centerX + Math.cos(angle) * outerRadius;
			yy = centerY + Math.sin(angle) * outerRadius;
			obj.graphics.lineTo(xx, yy);
		}
		obj.graphics.lineTo(startPoint.x, startPoint.y);
	}
	
	public function new() {
		super();
		
		menu = Assets.getBitmapData("img/menu.png");
		menuBitmap = new Bitmap(menu);
		menutr = Assets.getBitmapData("img/tr.png");
		menutrBitmap = new Bitmap(menutr);
		#if mobile
			help = Assets.getBitmapData("img/help-mobile.png");
		#else
			help = Assets.getBitmapData("img/help.png");
		#end
		helpBitmap = new Bitmap(help);

		stageBg = Assets.getBitmapData("img/bgt.jpg");
		stageBack = new Bitmap(stageBg);
		stageBg1 = Assets.getBitmapData("img/bgt1.jpg");
		stageBack1 = new Bitmap(stageBg1);
		stageBg2 = Assets.getBitmapData("img/bgt2.jpg");
		stageBack2 = new Bitmap(stageBg2);
		stageBg3 = Assets.getBitmapData("img/bgt3.jpg");
		stageBack3 = new Bitmap(stageBg3);
		stageBg4 = Assets.getBitmapData("img/bgt4.jpg");
		stageBack4 = new Bitmap(stageBg4);
		stageBg5 = Assets.getBitmapData("img/bgt5.jpg");
		stageBack5 = new Bitmap(stageBg5);
		stageBg6 = Assets.getBitmapData("img/bgt6.jpg");
		stageBack6 = new Bitmap(stageBg6);
		
		levelaPlay = Assets.getSound("audio/levela.wav");
		levelbPlay = Assets.getSound("audio/levelb.wav");
		menuMp3Play = Assets.getSound("audio/menu.wav");
		gameoverPlay = Assets.getSound("audio/gameover.wav");
		errorPlay = Assets.getSound("audio/error.wav");
		
		jump1Play = Assets.getSound("audio/jump01.wav");
		jump2Play = Assets.getSound("audio/jump02.wav");
		jump3Play = Assets.getSound("audio/jump03.wav");
		jump4Play = Assets.getSound("audio/jump04.wav");
		jump5Play = Assets.getSound("audio/jump05.wav");
		jump6Play = Assets.getSound("audio/jump06.wav");
		jump7Play = Assets.getSound("audio/jump07.wav");
		jump8Play = Assets.getSound("audio/jump08.wav");
		jump9Play = Assets.getSound("audio/jump09.wav");
		jump10Play = Assets.getSound("audio/jump10.wav");
		
		hit1Play = Assets.getSound("audio/hit01.wav");
		hit2Play = Assets.getSound("audio/hit02.wav");
		hit3Play = Assets.getSound("audio/hit03.wav");
		hit4Play = Assets.getSound("audio/hit04.wav");
		hit5Play = Assets.getSound("audio/hit05.wav");
		hit6Play = Assets.getSound("audio/hit06.wav");
		hit7Play = Assets.getSound("audio/hit07.wav");
		hit8Play = Assets.getSound("audio/hit08.wav");
		hit9Play = Assets.getSound("audio/hit09.wav");
		hit10Play = Assets.getSound("audio/hit10.wav");
		hit11Play = Assets.getSound("audio/hit11.wav");
		hit12Play = Assets.getSound("audio/hit12.wav");
		hit13Play = Assets.getSound("audio/hit13.wav");
		hit14Play = Assets.getSound("audio/hit14.wav");
		
		w1Play = Assets.getSound("audio/w1.wav");
		w2Play = Assets.getSound("audio/w2.wav");
		w3Play = Assets.getSound("audio/w3.wav");
		w4Play = Assets.getSound("audio/w4.wav");
		w5Play = Assets.getSound("audio/w5.wav");
		w6Play = Assets.getSound("audio/w6.wav");
		w7Play = Assets.getSound("audio/w7.wav");
		w8Play = Assets.getSound("audio/w8.wav");
		w9Play = Assets.getSound("audio/w9.wav");
		w10Play = Assets.getSound("audio/w10.wav");
		
		p1Play = Assets.getSound("audio/p1.wav");
		p2Play = Assets.getSound("audio/p2.wav");
		p3Play = Assets.getSound("audio/p3.wav");
	
		addEventListener(Event.ADDED_TO_STAGE, added);
	}
	
	public function added(e):Void {
		this.removeEventListener(Event.ADDED_TO_STAGE, added);
		stage.addEventListener(Event.RESIZE, resize);
		#if ios
			haxe.Timer.delay(init, 100); // iOS 6
		#else
			init();
		#end
	}
	
	private function init():Void {
		if (inited) return;
		inited = true;
		stage.scaleMode = StageScaleMode.NO_SCALE;
		menuBitmap = new Bitmap(menu);
		helpBitmap = new Bitmap(help);
		stageBack = new Bitmap(stageBg);
		stageBack1 = new Bitmap(stageBg1);
		stageBack2 = new Bitmap(stageBg2);
		stageBack3 = new Bitmap(stageBg3);
		stageBack4 = new Bitmap(stageBg4);
		stageBack5 = new Bitmap(stageBg5);
		stageBack6 = new Bitmap(stageBg6);
		var diff:Int = 10;
		stageBack.width = stage.stageWidth;
		stageBack.height = stage.stageHeight + diff;
		stageBack1.width = stage.stageWidth;
		stageBack1.height = stage.stageHeight + diff;
		stageBack2.width = stage.stageWidth;
		stageBack2.height = stage.stageHeight + diff;
		stageBack3.width = stage.stageWidth;
		stageBack3.height = stage.stageHeight + diff;
		stageBack4.width = stage.stageWidth;
		stageBack4.height = stage.stageHeight + diff;
		stageBack5.width = stage.stageWidth;
		stageBack5.height = stage.stageHeight + diff;
		stageBack6.width = stage.stageWidth;
		stageBack6.height = stage.stageHeight + diff;		
		if (stage.stageHeight > 1070)  initialSpeedStart = 26;
		else initialSpeedStart = stage.stageHeight / 32;
		var type:Int = randomNumber(0, 12);
		
		stageBackground = stageBack;
		stageBackground.name = "Background";
		
		// Ball
		ball.graphics.lineStyle();
		ball.graphics.beginFill(0xFFFFFF);
		ball.graphics.drawCircle(0, 0, stage.stageWidth / 30);
		ball.graphics.endFill();
		ball.name = "Ball";
		ball.x = stage.stageWidth / 2;
		ball.y = stage.stageHeight - stage.stageHeight / 3;
		ballRed.graphics.lineStyle();
		ballRed.graphics.beginFill(0xFF0000); // Red
		ballRed.graphics.drawCircle(0, 0, stage.stageWidth / 30);
		ballRed.graphics.endFill();
		ballRed.name = "BallRed";
		ballRed.x = ball.x;
		ballRed.y = ball.y;
		quad.name = "Quad";
		quad.addChild(ballRed);
		quad.addChild(ball);
		startPosition = ball.y;
		ball.removeEventListener(Event.ENTER_FRAME, moveBallUp);
		timer = 0;
		initialPos = ball.y;
		ball.addEventListener(Event.ENTER_FRAME, moveBallDown);
		center = new Point(stage.stageWidth / 2, stage.stageHeight / 2);
		// SoundMixer.stopAll();
		st.volume = 0.2;
		st2.volume = 0.15;
		st3.volume = 0.75;
		stt = levelbPlay.play(0, 66666666, st3);
		
		floorFiller();
			
		helpBitmap.name = "HelpBitmap";
		stage.addChild(helpBitmap);
		// Mouse.hide();
		frameDisplay.autoSize = TextFieldAutoSize.LEFT;
		frameDisplay.background = true;
		frameDisplay.backgroundColor = 0x000000;
		frameDisplayTextFormatter.bold = true;
		frameDisplayTextFormatter.size = 35;
		frameDisplay.selectable = false;
		frameDisplay.defaultTextFormat = frameDisplayTextFormatter;
		frameDisplay.htmlText = "<b>Score:</b> " + frameCount;
		frameDisplay.x = 370;
		frameDisplay.y = 8;
		frameDisplay.textColor = levelColor;
		frameDisplayShow.autoSize = TextFieldAutoSize.LEFT;
		frameDisplayShow.background = false;
		frameDisplayShow.backgroundColor = 0x000000;
		frameDisplayShowTextFormatter.bold = true;
		frameDisplayShowTextFormatter.size = 25;
		frameDisplayShow.selectable = false;
		frameDisplayShow.defaultTextFormat = frameDisplayShowTextFormatter;
		frameDisplayShow.htmlText = "0";
		frameDisplayShow.x = stage.stageWidth - frameDisplayShow.width - 10;
		frameDisplayShow.y = stage.stageHeight - frameDisplayShow.height - 10;
		frameDisplayShow.alpha = 0.35;
		frameDisplayShow.textColor = levelColor;
		stage.addChild(frameDisplayShow);
			
		stage.addEventListener(KeyboardEvent.KEY_UP, keyUp);
		stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDown);
		stage.addEventListener(Event.ENTER_FRAME, onEnter);
		
		#if mobile
			acc = new Accelerometer();
			acc.addEventListener(AccelerometerEvent.UPDATE, updateAcc); // iOS 6
			stage.addEventListener(TouchEvent.TOUCH_BEGIN, stageTouch);
		#else
			null;
		#end
	}
	
	private function stageTouch (tevent:TouchEvent):Void {
		jumpCount++;
		jumpCountHelp++;
		jumpLock = true;
		if (jumpCountHelp > 0) {
			jumpCountHelp = 0;
			var helpDisplay:DisplayObject = stage.getChildByName("HelpBitmap");
			if (helpDisplay == null) null;
			else stage.removeChild(helpDisplay);
		}
		if (jumpCount < 4) {
			jumping = true;
			ball.removeEventListener(Event.ENTER_FRAME, moveBallDown);
			timer = 0;
			currentPos = ball.y;
			initialSpeed = initialSpeedStart;
			ball.addEventListener(Event.ENTER_FRAME, moveBallUp);
			switch (randomNumber(1, 10)) {
				case 1:
					jump1Play.play(0, 0, st);
				case 2:
					jump2Play.play(0, 0, st);
				case 3:
					jump3Play.play(0, 0, st);
				case 4:
					jump4Play.play(0, 0, st);
				case 5:
					jump5Play.play(0, 0, st);
				case 6:
					jump6Play.play(0, 0, st);
				case 7:
					jump7Play.play(0, 0, st);
				case 8:
					jump8Play.play(0, 0, st);
				case 9:
					jump9Play.play(0, 0, st);
				case 10:
					jump10Play.play(0, 0, st);
			}
		}	
	}

	private function floorFiller():Void {
		ball.alpha = 1.0;
		jumping = true;
		initial = 10;
		arrowKeyUp = false;
		arrowKeyDown = false;
		arrowKeyLeft = false;
		arrowKeyRight = false;
		speedSlide = 0;
		speedSlidePower = 0.05;
		speedSlideMax = speedSlidePower * 80;
		speedAccelerate = 1.0;
		speedAcceleratePower = 0.0001;
		speedAccelerateMax = 2.0;
		if (once) {
			stage.addChild(stageBackground);
			stage.addChild(quad);
			once = false;
		}
		var stop:Bool = true;
		while (stop) {
			for (index in 0...stage.numChildren - 1) {
				childSelect = stage.getChildAt(index);
				if (childSelect.name == "Arc" || childSelect.name == "ArcRed"|| childSelect.name == "ArcGreen") {
					if (childSelect.width >= width2) {
						stop = false;
					} else {
						rotateCenter(childSelect, speedSlide * 2, 1.03);
					}
				}
			}
			
			if (stage.getChildAt(2).scaleX > 0.028) {
				var arcAdd:Sprite = new Sprite();
				var stageMatrix:Matrix = new Matrix();
				stageMatrix.createBox(0, 0, 0, stage.stageWidth, stage.stageHeight);
				arcAdd.graphics.lineStyle();
				arcAdd.graphics.beginFill(levelColor);
				radRandom = randomNumber(radRandMinimum, radRand);
				if (initial > 0) {
					initial--;
					radRandom = 180;
					drawArc (arcAdd, 0, 0, 60, 100, 0.2, 36 / 359, Math.round(36.0 / drawArcDetail));
				} else {
					drawArc (arcAdd, 0, 0, 60, 100, 0, radRandom / 359, Math.round(radRandom / drawArcDetail));
					rotateCenter(arcAdd, randomNumber(0, 360), 1.0);
				}
				arcAdd.graphics.endFill();
				arcAdd.x = stage.stageWidth / 2;
				arcAdd.y = stage.stageHeight / 2;
				arcAdd.scaleX = 0.02;
				arcAdd.scaleY = 0.02;
				arcAdd.name = "Arc";
				stage.addChildAt(arcAdd, 2);
			}
		}
	}	

	private function stage_onResize (event:Event):Void {
		null;
	}
	
	public function onEnter(event:Event):Void {
		// Slide
		if (arrowKeyLeft && Math.abs(speedSlide) < speedSlideMax) {
			if (speedSlide > 0) speedSlide *= -1;
			else speedSlide -= speedSlidePower * 3;
		} else if (speedSlide < 0) {
			if (speedSlidePower * 2 < speedSlide) speedSlide = 0;
			else speedSlide += speedSlidePower * 2;
		}
		if (arrowKeyRight && Math.abs(speedSlide) < speedSlideMax) {
			if (speedSlide < 0) speedSlide *= -1;
			else speedSlide += speedSlidePower * 3;
		} else if (speedSlide > 0) {
			if (speedSlidePower * 2 > speedSlide) speedSlide = 0;
			else speedSlide -= speedSlidePower * 2;
		}
		if (arrowKeyDown) {
			speedSlide -= speedSlidePower;
		}
		if (arrowKeyLeft && tickerLeft < 35) {
			tickerLeft++;
			rotateCenter(quad, 1, 1.0);
		} else if (tickerLeft > 0) {
			rotateCenter(quad, -2, 1.0);
			tickerLeft--;
			tickerLeft--;
		}
		if (arrowKeyRight && tickerRight < 35) {
			tickerRight++;
			rotateCenter(quad, -1, 1.0);
		} else if (tickerRight > 0) {
			rotateCenter(quad, 2, 1.0);
			tickerRight--;
			tickerRight--;
		}
		if (stage.getChildAt(2).scaleX > 0.028) {
			var arcAdd:Sprite = new Sprite();
			radRandom = randomNumber(radRandMinimum, radRand);
			var arcRed:Bool = false;
			var arcGreen:Bool = false;
			var arcBlack:Bool = false;
			if (randomNumber(0, 5) == 0) {
				var arcRand:Int = randomNumber(0, 2);
				if (arcRand > 1) arcRed = true;
				else if (arcRand > 0) {
					if (levelLock > 2) arcBlack = true;
					else arcRed = true;
				}
				else arcGreen = true;
			} else {
				arcRed = false;
				arcGreen = false;
				arcBlack = false;
			}
			if (arcRed)	arcAdd.graphics.beginFill(0xFF0000, 1);
			else if (arcGreen) arcAdd.graphics.beginFill(0xFFFF00, 1);
			else if (arcBlack) {
				var stageMatrix:Matrix = new Matrix();
				stageMatrix.createBox(0, 0, 0, stage.stageWidth, stage.stageWidth);
				arcAdd.graphics.lineStyle();
				arcAdd.graphics.beginFill(0x000000);
			} else {
				var stageMatrix:Matrix = new Matrix();
				stageMatrix.createBox(0, 0, 0, stage.stageWidth, stage.stageWidth);
				arcAdd.graphics.lineStyle();
				arcAdd.graphics.beginFill(levelColor);
			}
			radRandomChance = randomNumber(0, radRandTiltChance);
			if (radRandomChance == 0) {
				radRandom = 360;
			}
			if (arcRed || arcGreen) {
				var starsObject:Object = {
					starsX: 10,
					starsY: 20,
					starsNumOfCorners: 5,
					starsRadiusInside: randomNumber(5, 6),
					starsRadiusOutside: 15,
					starsRotation: 0,
				}
				starsPen = new Pen(arcAdd.graphics);
				starsPen.drawStar(starsObject.starsX,
					starsObject.starsY,
					starsObject.starsNumOfCorners,
					starsObject.starsRadiusInside,
					starsObject.starsRadiusOutside,
					starsObject.starsRotation
				);
			} else drawArc(arcAdd, 0, 0, 60, 100, 0, radRandom / 359, Math.round(radRandom / drawArcDetail));
			arcAdd.graphics.endFill();
			arcAdd.x = stage.stageWidth / 2;
			arcAdd.y = stage.stageHeight / 2;
	
			arcAdd.scaleX = 0.02;
			arcAdd.scaleY = 0.02;
			
			rotateCenter(arcAdd, randomNumber(0, 360), 1.0);
			if (arcRed) arcAdd.name = "ArcRed";
			else if (arcGreen) arcAdd.name = "ArcGreen";
			else if (arcBlack) arcAdd.name = "ArcBlack";
			else arcAdd.name = "Arc";
			stage.addChildAt(arcAdd, 2);
		}
			
		for (index in 0...stage.numChildren - 1) {
			childSelect = stage.getChildAt(index);
			if (childSelect.name == "Arc" || childSelect.name == "ArcRed" || childSelect.name == "ArcGreen"|| childSelect.name == "ArcBlack") {
				if (childSelect.width > stage.stageWidth * 1.7) {
					stage.removeChild(childSelect);
					break;
				} else {
					if (wildCard == 2) wildStep = 1.025;
					else if (wildCard == 0) {
						wildStep += 0.03;
						if (wildStep > 1.6) wildCard = 1;
					} else if (wildCard == 1) {
						wildStep -= 0.005;
						if (wildStep <= 1.025) {
							wildCard = 2;
							wildStep = 1.025;
						}
					}
					rotateCenter(childSelect, speedSlide, wildStep - wildStepSpeed);
				}
			}
		}
	
		var helpDisplay:DisplayObject = stage.getChildByName("HelpBitmap");
		if (jumping == false && helpDisplay == null) {
			var point:Point = new Point();
			point.x = ball.x + ball.width / 2;
			point.y = ball.y + ball.height;
			var displayy:Array<DisplayObject> = stage.getObjectsUnderPoint(point);
			if (displayy.length > 1 && wildCard == 2) {
				
				if (displayy.length == 3 ) displayCount = 2;
				else displayCount = 1;
				if (displayy[displayCount].name == "ArcBlack") {
					if (Math.abs(frameCount - frameCountSave) > 60) {
						if (ball.alpha > 0) ball.alpha -= 0.5;
						else game0ver();
						errorPlay.play(0, 0, st2);
					}
				} else if (displayy[displayCount].name == "ArcRed") {
					frameCountSave = frameCount;
					var childIndexInt:Int = stage.getChildIndex(displayy[displayCount]);
					stage.removeChildAt(childIndexInt);
					
					var addDO1:DisplayObject = stage.getChildAt(childIndexInt-1);
					var add1:Sprite = new Sprite();
					var addMatrix1:Matrix = new Matrix();
					addMatrix1.createBox(0,0,0,stage.stageWidth,stage.stageWidth);
					add1.graphics.lineStyle();
					add1.graphics.beginFill(levelColor);
					this.drawArc (add1, 0, 0, 60, 100, 0, 359 / 359, Math.round(359 / drawArcDetail));
					add1.graphics.endFill();
					add1.x = addDO1.x;
					add1.y = addDO1.y;
					add1.scaleX = addDO1.scaleX;
					add1.scaleY = addDO1.scaleY;
					add1.name = "Arc";
					stage.removeChildAt(childIndexInt-1);
					stage.addChildAt(add1, childIndexInt - 1);
					
					var addDO2:DisplayObject = stage.getChildAt(childIndexInt-2);
					var add2:Sprite = new Sprite();
					var addMatrix2:Matrix = new Matrix();
					addMatrix2.createBox(0,0,0,stage.stageWidth,stage.stageWidth);
					add2.graphics.lineStyle();
					add2.graphics.beginFill(levelColor);
					this.drawArc (add2, 0, 0, 60, 100, 0, 359 / 359, Math.round(359 / drawArcDetail));
					add2.graphics.endFill();
					add2.x = addDO2.x;
					add2.y = addDO2.y;
					add2.scaleX = addDO2.scaleX;
					add2.scaleY = addDO2.scaleY;
					add2.name = "Arc";
					stage.removeChildAt(childIndexInt-2);
					stage.addChildAt(add2, childIndexInt - 2);

					var addDO3:DisplayObject = stage.getChildAt(childIndexInt-3);
					var add3:Sprite = new Sprite();
					var addMatrix3:Matrix = new Matrix();
					addMatrix3.createBox(0,0,0,stage.stageWidth,stage.stageWidth);
					add3.graphics.lineStyle();
					add3.graphics.beginFill(levelColor);
					this.drawArc (add3, 0, 0, 60, 100, 0, 359 / 359, Math.round(359 / drawArcDetail));
					add3.graphics.endFill();
					add3.x = addDO3.x;
					add3.y = addDO3.y;
					add3.scaleX = addDO3.scaleX;
					add3.scaleY = addDO3.scaleY;
					add3.name = "Arc";
					stage.removeChildAt(childIndexInt-3);
					stage.addChildAt(add3, childIndexInt - 3);
					
					var addDO4:DisplayObject = stage.getChildAt(childIndexInt-4);
					var add4:Sprite = new Sprite();
					var addMatrix4:Matrix = new Matrix();
					addMatrix4.createBox(0,0,0,stage.stageWidth,stage.stageWidth);
					add4.graphics.lineStyle();
					add4.graphics.beginFill(levelColor);
					this.drawArc (add4, 0, 0, 60, 100, 0, 359 / 359, Math.round(359 / drawArcDetail));
					add4.graphics.endFill();
					add4.x = addDO4.x;
					add4.y = addDO4.y;
					add4.scaleX = addDO4.scaleX;
					add4.scaleY = addDO4.scaleY;
					add4.name = "Arc";
					stage.removeChildAt(childIndexInt-4);
					stage.addChildAt(add4, childIndexInt - 4);
					
					var addDO5:DisplayObject = stage.getChildAt(childIndexInt-5);
					var add5:Sprite = new Sprite();
					var addMatrix5:Matrix = new Matrix();
					addMatrix5.createBox(0,0,0,stage.stageWidth,stage.stageWidth);
					add5.graphics.lineStyle();
					add5.graphics.beginFill(levelColor);
					this.drawArc (add5, 0, 0, 60, 100, 0, 359 / 359, Math.round(359 / drawArcDetail));
					add5.graphics.endFill();
					add5.x = addDO5.x;
					add5.y = addDO5.y;
					add5.scaleX = addDO5.scaleX;
					add5.scaleY = addDO5.scaleY;
					add5.name = "Arc";
					stage.removeChildAt(childIndexInt-5);
					stage.addChildAt(add5, childIndexInt - 5);
					
					var addDO6:DisplayObject = stage.getChildAt(childIndexInt-6);
					var add6:Sprite = new Sprite();
					var addMatrix6:Matrix = new Matrix();
					addMatrix6.createBox(0,0,0,stage.stageWidth,stage.stageWidth);
					add6.graphics.lineStyle();
					add6.graphics.beginFill(levelColor);
					this.drawArc (add6, 0, 0, 60, 100, 0, 359 / 359, Math.round(359 / drawArcDetail));
					add6.graphics.endFill();
					add6.x = addDO6.x;
					add6.y = addDO6.y;
					add6.scaleX = addDO6.scaleX;
					add6.scaleY = addDO6.scaleY;
					add6.name = "Arc";
					stage.removeChildAt(childIndexInt-6);
					stage.addChildAt(add6, childIndexInt - 6);					

					switch (randomNumber(1, 3)) {
						case 1:
							p1Play.play(0, 0, st);
						case 2:
							p2Play.play(0, 0, st);
						case 3:
							p3Play.play(0, 0, st);
					}
				} else if (displayy[displayCount].name == "ArcGreen") {
					frameCountSave = frameCount;
					wildCard = 0;
					jumpCount++;
					jumpCountHelp++;
					if (jumpCountHelp > 0) {
						jumpLock = true;
						jumpCountHelp = 0;
						var helpDisplay:DisplayObject = stage.getChildByName("HelpBitmap");
						if (helpDisplay == null) null;
						else stage.removeChild(helpDisplay);
					}
					if (jumpCount < 4) {
						jumping = true;
						null;
						ball.removeEventListener(Event.ENTER_FRAME, moveBallDown);
						timer = 0;
						currentPos = ball.y;
						initialSpeed = initialSpeedStart;
						ball.addEventListener(Event.ENTER_FRAME, moveBallUp);
							
						switch (randomNumber(1, 10)) {
							case 1:
								w1Play.play(0, 0, st);
							case 2:
								w2Play.play(0, 0, st);
							case 3:
								w3Play.play(0, 0, st);
							case 4:
								w4Play.play(0, 0, st);
							case 5:
								w5Play.play(0, 0, st);
							case 6:
								w6Play.play(0, 0, st);
							case 7:
								w7Play.play(0, 0, st);
							case 8:
								w8Play.play(0, 0, st);
							case 9:
								w9Play.play(0, 0, st);
							case 10:
								w10Play.play(0, 0, st);
						}
					}
				} 
			} else {
				if (Math.abs(frameCount - frameCountSave) > 60) {
					if (ball.alpha > 0) ball.alpha -= 0.1;
					else game0ver();
					errorPlay.play(0, 0, st2);
				}
			}
		}
		if (ball.alpha < 1.0) ball.alpha += 0.05;
		if (helpDisplay == null) frameCount++;
		if (frameCount % 5 == 0) {
			frameDisplayShow.x = stage.stageWidth - frameDisplayShow.width - 10;
			frameDisplayShow.y = stage.stageHeight - frameDisplayShow.height - 10;
			frameDisplay.textColor = levelColor;
			frameDisplayShow.textColor = levelColor;
			frameDisplay.htmlText = " Score: " + frameCount + " Level " + levelLock + "/6 ";
			frameDisplayShow.htmlText = " Score: " + frameCount + " Level " + levelLock + "/6 ";
		}
	}
		
	private function onMenu(mouseEvent:MouseEvent):Void {
		stage.removeEventListener(MouseEvent.CLICK, onMenu);
		stage.removeEventListener(KeyboardEvent.KEY_DOWN, keyDownMenu);
		stage.removeChild(menuBitmap);
		stage.removeChild(stageBackground);
		ball.alpha = 1.0;
		ball.x = stage.stageWidth / 2;
		ball.y = stage.stageHeight - stage.stageHeight / 3;
		ballRed.x = ball.x;
		ballRed.y = ball.y;
		startPosition = ball.y;			
		frameCount = 0;
		stage.removeChild(frameDisplay);
		stage.addChild(frameDisplayShow);
		timer = 0;
		initialPos = ball.y;
		ball.addEventListener(Event.ENTER_FRAME, moveBallDown);
		
		var helpDisplay:DisplayObject = stage.getChildByName("HelpBitmap");
		if (helpDisplay == null) null;
		else stage.removeChild(helpDisplay);
		stage.removeChild(frameDisplayShow);
		menutrBitmap.name = "HelpBitmap";
		stage.addChild(menutrBitmap);
		var schrott:DisplayObject;
		while ((schrott = stage.getChildByName("Arc")) != null) {
			stage.removeChild(schrott);
		}
		while ((schrott = stage.getChildByName("ArcRed")) != null) {
			stage.removeChild(schrott);
		}
		while ((schrott = stage.getChildByName("ArcGreen")) != null) {
			stage.removeChild(schrott);
		}
		while ((schrott = stage.getChildByName("ArcBlack")) != null) {
			stage.removeChild(schrott);
		}
		
		var xInt:Float = mouseEvent.stageX;
		var yInt:Float = mouseEvent.stageY;
		if (xInt < 297 && yInt < 272) {
			// Level1
			radRand = 60 + 60 + 60 + 60 + 60 + 30;
			radRandTiltChance = 5;
			wildStepSpeed = 0.005;
			levelLock = 1;
			levelColor = 0x00FF00;
			stageBackground = stageBack1;
		}
		if (xInt > 297 && yInt < 272 && xInt < 513) {
			// Level2
			radRand = 60 + 60 + 60 + 60 + 60;
			radRandTiltChance = 7;
			wildStepSpeed = 0.004;
			levelLock = 2;
			levelColor = 0xc0ff00;
			stageBackground = stageBack2;
		}
		if (xInt > 513 && yInt < 272) {
			// Level3
			radRand = 60 + 60 + 60 + 60;
			radRandTiltChance = 8;
			wildStepSpeed = 0.003;
			levelLock = 3;
			levelColor = 0xe9fe00;
			stageBackground = stageBack3;
		}
		if (yInt > 272 && xInt < 298) {
			// Level4
			radRand = 60 + 60 + 60 + 30;
			radRandTiltChance = 9;
			wildStepSpeed = 0.002;
			levelLock = 4;
			levelColor = 0xfcff00;
			stageBackground = stageBack4;
		}
		if (yInt > 272 && xInt > 298 && xInt < 513) {
			// Level5
			radRand = 60 + 60;
			radRandTiltChance = 10;
			wildStepSpeed = 0.001;
			levelLock = 5;
			levelColor = 0xff9000;
			stageBackground = stageBack5;
		}
		if (yInt > 272 && xInt > 513) {
			// Level6
			radRand = 60 + 50;
			radRandTiltChance = 12;
			wildStepSpeed = 0.001;
			levelLock = 6;
			levelColor = 0xff0000;
			stageBackground = stageBack6;
		} 
		if (yInt > 520 && xInt > 520) {
			// Level else
			radRand = 60 + 60 + 60 + 60 + 60 + 30;
			radRandTiltChance = 5;
			wildStepSpeed = 0.005;
			levelLock = 1;
			levelColor = 0x00FF00;
			stageBackground = stageBack1;
		}
		stageBackground.name = "Background";
		stage.addChildAt(stageBackground, 0);
		stt.stop();
		stt2.stop();
		stt3.stop();
		if (randomNumber(0, 1) == 0) stt2 = levelaPlay.play(0, 999999, st3);
		else stt = levelbPlay.play(0, 999999, st3);
		
		floorFiller();
		#if mobile
			stage.addEventListener(TouchEvent.TOUCH_BEGIN, stageTouch);
		#else
			null;
		#end
		stage.addEventListener(KeyboardEvent.KEY_UP, keyUp);
		stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDown);
		stage.addEventListener(Event.ENTER_FRAME, onEnter);
	}

	private function rotateCenter (ob:DisplayObject, angleDegrees:Float, scale:Float):Void {
		m = ob.transform.matrix;
		m.tx -= center.x;
		m.ty -= center.y;
		m.rotate(angleDegrees * (Math.PI / 180));
		m.scale(scale, scale);
		m.tx += center.x;
		m.ty += center.y;
		ob.transform.matrix = m;
	}	
	
	private function keyDownMenu(keyEvent:KeyboardEvent):Void {
		switch (keyEvent.keyCode) {
			case 32: //Space
				onMenu(new MouseEvent(MouseEvent.CLICK));
			case 10: // Enter 
				onMenu(new MouseEvent(MouseEvent.CLICK));
			case 81: // Q - Quit
				openfl.system.System.exit(0);
			case 27: // Esc
				openfl.system.System.exit(0);
		}
	}
	
	private function keyDown(keyEvent:KeyboardEvent):Void {
		switch (keyEvent.keyCode) {
			case 32: // Space
				jumpCount++;
				jumpCountHelp++;
				if (jumpCountHelp > 0) {
					jumpLock = true;
					jumpCountHelp = 0;
					var helpDisplay:DisplayObject = stage.getChildByName("HelpBitmap");
					if (helpDisplay == null) null;
					else {
						stage.removeChild(helpDisplay);
						stage.addChild(frameDisplayShow);
					}
				}
				
				if (jumpCount < 4) {
					jumping = true;
					null;
					ball.removeEventListener(Event.ENTER_FRAME, moveBallDown);
					timer = 0;
					currentPos = ball.y;
					initialSpeed = initialSpeedStart;
					ball.addEventListener(Event.ENTER_FRAME, moveBallUp);
				
					switch (randomNumber(1, 10)) {
						case 1:
							jump1Play.play(0, 0, st);
						case 2:
							jump2Play.play(0, 0, st);
						case 3:
							jump3Play.play(0, 0, st);
						case 4:
							jump4Play.play(0, 0, st);
						case 5:
							jump5Play.play(0, 0, st);
						case 6:
							jump6Play.play(0, 0, st);
						case 7:
							jump7Play.play(0, 0, st);
						case 8:
							jump8Play.play(0, 0, st);
						case 9:
							jump9Play.play(0, 0, st);
						case 10:
							jump10Play.play(0, 0, st);
					}
				}
				
			case 38: // Up
				arrowKeyUp = true;
			case 40: // Down
				arrowKeyDown = true;
			case 87: // W
				arrowKeyUp = true;
			case 83: // S
				arrowKeyDown = true;
			#if mobile
				case 37: // Left
					if (jumpLock) arrowKeyLeft = true;
				case 39: // Right
					if (jumpLock) arrowKeyRight = true;
				case 65: // A
					if (jumpLock) arrowKeyLeft = true;
				case 68: // D
					if (jumpLock) arrowKeyRight = true;
			#else
				case 37: // Left
					arrowKeyLeft = true;
				case 39: // Right
					arrowKeyRight = true;
				case 65: // A
					arrowKeyLeft = true;
				case 68: // D
					arrowKeyRight = true;
			#end
			/*
			case 70: // F - Fullscreen
				if (stage.displayState != NORMAL) stage.displayState = NORMAL;
				else stage.displayState = FULL_SCREEN;
			*/
			case 81: // Q - Quit
				openfl.system.System.exit(0);
			case 27: // Esc
				openfl.system.System.exit(0);
		}
	}
	
	private function keyUp(keyEvent:KeyboardEvent):Void {
		switch (keyEvent.keyCode) {
			case 38: // Up
				arrowKeyUp = false;
			case 40: // Down
				arrowKeyDown = false;
			case 87: // W
				arrowKeyUp = false;
			case 83: // S
				arrowKeyDown = false;
				
			case 37: // Left
				arrowKeyLeft = false;
			case 39: // Right
				arrowKeyRight = false;
			case 65: // A
				arrowKeyLeft = false;
			case 68: // D
				arrowKeyRight = false;
		}
	}
	
	private function moveBallDown(e:Event):Void {
		timer += 1;
		ball.y = initialPos + 0.5 * gravity * (timer * timer);
		ballRed.y = ball.y;
		
		if (ball.y + ball.height > stage.stageHeight) {
			finalPos = ball.y;
			ball.removeEventListener(Event.ENTER_FRAME, moveBallDown);
			if (finalPos - initialPos < 0.1 * ball.height) ball.removeEventListener(Event.ENTER_FRAME, moveBallUp);
			else {
				switch (randomNumber(1, 14)) {
					case 1:
						hit1Play.play(0, 0, st);
					case 2:
						hit2Play.play(0, 0, st);
					case 3:
						hit3Play.play(0, 0, st);
					case 4:
						hit4Play.play(0, 0, st);
					case 5:
						hit5Play.play(0, 0, st);
					case 6:
						hit6Play.play(0, 0, st);
					case 7:
						hit7Play.play(0, 0, st);
					case 8:
						hit8Play.play(0, 0, st);
					case 9:
						hit9Play.play(0, 0, st);
					case 10:
						hit10Play.play(0, 0, st);
					case 11:
						hit11Play.play(0, 0, st);
					case 12:
						hit12Play.play(0, 0, st);
					case 13:
						hit13Play.play(0, 0, st);
					case 14:
						hit14Play.play(0, 0, st);
				}
				jumping = false;
				jumpCount = 0;
				initialSpeed = decay * Math.sqrt(2 * Math.abs(finalPos - initialPos));
				timer = 0;
				currentPos=ball.y;
				ball.addEventListener(Event.ENTER_FRAME, moveBallUp);
			}
		}		
	}

	private function moveBallUp(e:Event):Void {
		timer += 1;
		var positionA:Float = ball.y;
		ball.y = currentPos - initialSpeed * timer + 0.5 * gravity * (timer * timer);
		ballRed.y = ball.y;
		var positionB:Float = ball.y;
		if (positionB > positionA) {
			ball.removeEventListener(Event.ENTER_FRAME, moveBallUp);
			timer = 0;
			initialPos = ball.y;
			ball.addEventListener(Event.ENTER_FRAME, moveBallDown);
		}
	}
	
	private function game0ver():Void {
		stage.removeEventListener(Event.ENTER_FRAME, onEnter);
		stage.removeEventListener(KeyboardEvent.KEY_UP, keyUp);
		stage.removeEventListener(KeyboardEvent.KEY_DOWN, keyDown);
		ball.removeEventListener(Event.ENTER_FRAME, moveBallUp);
		ball.removeEventListener(Event.ENTER_FRAME, moveBallDown);
		#if mobile
			stage.removeEventListener(TouchEvent.TOUCH_BEGIN, stageTouch);
		#else
			null;
		#end
		
		stt.stop();
		stt2.stop();
		stt3 = menuMp3Play.play(0, 99999, st2);
		gameoverPlay.play(0,0,st3);
		jumpLock = false;
		
		stage.addEventListener(MouseEvent.CLICK, onMenu);
		stage.addChild(menuBitmap);
		stage.removeChild(frameDisplayShow);
		stage.addChild(frameDisplay);
		stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDownMenu);
	}
	
	function resize(e) {
		// openfl.system.System.exit(0);
	}
	
	private function randomNumber(low:Int, high:Int):Int {
		var low:Int = low;
		var high:Int = high;
		return Math.round(Math.random() * (high - low)) + low;
	}
	
	private function updateAcc(ev:AccelerometerEvent):Void {
		#if ios
			if (ev.accelerationY > 0.035 && jumpLock) {
				arrowKeyLeft = true;
				arrowKeyRight = false;
			} else if (ev.accelerationY < -0.035 && jumpLock) {
				arrowKeyLeft = false;
				arrowKeyRight = true;
			} else {
				arrowKeyLeft = false;
				arrowKeyRight = false;
			}
		#else
			if (ev.accelerationY < -0.035 && jumpLock) {
				arrowKeyLeft = true;
				arrowKeyRight = false;
			} else if (ev.accelerationY > 0.035 && jumpLock) {
				arrowKeyLeft = false;
				arrowKeyRight = true;
			} else {
				arrowKeyLeft = false;
				arrowKeyRight = false;
			}
		#end
		/*
		trace("x:" + Event.accelerationX);
		trace("y:" + Event.accelerationY);
		trace("z:" + Event.accelerationZ);
		*/
	}
	
	public static function main() {
		Lib.current.stage.align = flash.display.StageAlign.TOP_LEFT;
		Lib.current.stage.scaleMode = flash.display.StageScaleMode.NO_SCALE;
		Lib.current.addChild(new Main());
	}
}