package;

import openfl.display.Graphics;
import openfl.display.BitmapData;
import openfl.geom.Matrix;

class Pen {
	private var _gTarget:Graphics;
	private var _bLineStyleSet:Bool;

	public function Pen(gTarget:Graphics) {
		_gTarget = gTarget;
	}
	
	public function new(gTarget:Graphics) {
		_gTarget = gTarget;
	}
	
	public function lineStyle(nThickness:Float = 1, nRGB:UInt = 0, nAlpha:Float = 1, bPixelHinting:Bool = false, sScaleMode:String = "normal", sCaps:String = null, sJoints:String = null, nMiterLimit:Float = 3):Void {
		_gTarget.lineStyle(nThickness, nRGB, nAlpha, bPixelHinting, null, null, null, nMiterLimit);
		_bLineStyleSet = true;
	}
    
	public function lineGradientStyle(sType:String, aColors:Array<UInt>, aAlphas:Array<Float>, aRatios:Array<Int>, mtxTransform:Matrix = null, sMethod:String = "pad", sInterpolation:String = "rgb", nFocalPoint:Float = 0):Void {
		if(!_bLineStyleSet) {
			lineStyle();	
		}
	}

	public function beginFill(nRGB:Int, nAlpha:Float = 1):Void {
		_gTarget.beginFill(nRGB, nAlpha);
	}

	public function beginGradientFill(sFillType:String, aColors:Array<UInt>, aAlphas:Array<Float>, aRatios:Array<Int>, mtxTransform:Matrix = null, sMethod:String = "pad", sInterpolation:String = "rgb", nFocalPoint:Float = 0):Void {
		null;
	}
    
	public function beginBitmapFill(bmpData:BitmapData, mtxTransform:Matrix = null, bRepeat:Bool = true, bSmooth:Bool = false):Void {
		_gTarget.beginBitmapFill(bmpData, mtxTransform, bRepeat, bSmooth);
	}

	public function endFill():Void {
		_gTarget.endFill();
	}

	public function clear():Void {
		_gTarget.clear();
		_bLineStyleSet = false;
	}

	public function moveTo(nX:Float, nY:Float):Void {
		_gTarget.moveTo(nX, nY);
	}
	
	public function lineTo(nX:Float, nY:Float):Void {
		if(!_bLineStyleSet) {
			lineStyle();
		}
		_gTarget.lineTo(nX, nY);
	}

	public function curveTo(nCtrlX:Float, nCtrlY:Float, nAnchorX:Float, nAnchorY:Float):Void {
		if(!_bLineStyleSet) {
			lineStyle();
		}
		_gTarget.curveTo(nCtrlX, nCtrlY, nAnchorX, nAnchorY);
	}

	public function drawLine(nX0:Float, nY0:Float, nX1:Float, nY1:Float):Void {
		if(!_bLineStyleSet) {
			lineStyle();
		}
		_gTarget.moveTo(nX0, nY0);
		_gTarget.lineTo(nX1, nY1);
	}

	public function drawCurve(nX:Float, nY:Float, nCtrlX:Float, nCtrlY:Float, nAnchorX:Float, nAnchorY:Float):Void {
		if(!_bLineStyleSet) {
			lineStyle();
		}
		_gTarget.moveTo(nX, nY);
		_gTarget.curveTo(nCtrlX, nCtrlY, nAnchorX, nAnchorY);
	}

	public function drawRect(nX:Float, nY:Float, nWidth:Float, nHeight:Float):Void {
		if(!_bLineStyleSet) {
			lineStyle();
		}
		_gTarget.drawRect(nX, nY, nWidth, nHeight);
	}
    
	public function drawRoundRect(nX:Float, nY:Float, nWidth:Float, nHeight:Float, nRadius:Float):Void {
		if(!_bLineStyleSet) {
			lineStyle();
		}
		_gTarget.drawRoundRect(nX, nY, nWidth, nHeight, nRadius);
	}

	public function drawRoundRectComplex(nX:Float, nY:Float, nWidth:Float, nHeight:Float, nA:Float, nB:Float, nC:Float, nD:Float):Void {
		if(!_bLineStyleSet) {
			lineStyle();
		}
		_gTarget.drawRoundRectComplex(nX, nY, nWidth, nHeight, nA, nB, nC, nD);
	}

	public function drawCircle(nX:Float, nY:Float, nRadius:Float):Void {
		if(!_bLineStyleSet) {
			lineStyle();
		}
		_gTarget.drawCircle(nX, nY, nRadius);
	}

	public function drawSlice (nArc:Float, nRadius:Float, nStartingAngle:Float, nX:Float, nY:Float):Void {
		null;
	}

	public function drawEllipse (nX:Float, nY:Float, nRadiusX:Float, nRadiusY:Float):Void {
		var nAngleDelta:Float = Math.PI / 4;
		var nAngle:Float = 0;
		var nCtrlDistX:Float = nRadiusX / Math.cos(nAngleDelta/2);
		var nCtrlDistY:Float = nRadiusY / Math.cos(nAngleDelta/2);
		var nCtrlX:Float;
		var nCtrlY:Float;
		var nAnchorX:Float;
		var nAnchorY:Float;
	
		moveTo(nX + nRadiusX, nY);
		var i:Int = 0;
		for (i in 0...8) {
			nAngle += nAngleDelta;
			nCtrlX = nX + Math.cos(nAngle-(nAngleDelta/2))*(nCtrlDistX);
			nCtrlY = nY + Math.sin(nAngle-(nAngleDelta/2))*(nCtrlDistY);
			nAnchorX = nX + Math.cos(nAngle) * nRadiusX;
			nAnchorY = nY + Math.sin(nAngle) * nRadiusY;
			this.curveTo(nCtrlX, nCtrlY, nAnchorX, nAnchorY);
		}
	}
	
	public function drawTriangle (nX:Float, nY:Float, nAB:Float, nAC:Float, nAngle:Float, nRotation:Float = 0):Void {
		nRotation = nRotation * Math.PI / 180;
		nAngle = nAngle * Math.PI / 180;
	
		var nBx:Float = Math.cos(nAngle - nRotation) * nAB;
		var nBy:Float = Math.sin(nAngle - nRotation) * nAB;
		var nCx:Float = Math.cos(-nRotation) * nAC;
		var nCy:Float = Math.sin(-nRotation) * nAC;

		var nCentroidX:Float = 0;
		var nCentroidY:Float = 0;
		
		drawLine(-nCentroidX + nX, -nCentroidY + nY, nCx - nCentroidX + nX, nCy - nCentroidY + nY);
		lineTo(nBx - nCentroidX + nX, nBy - nCentroidY + nY);
		lineTo(-nCentroidX + nX, -nCentroidY + nY);
	}
	
	public function drawRegularPolygon (nX:Float, nY:Float, nSides:Int, nLength:Float, nRotation:Float = 0):Void {
		nRotation = nRotation * Math.PI / 180;
		var nAngle:Float = (2 * Math.PI) / nSides;
		var nRadius:Float = (nLength/2)/Math.sin(nAngle/2);
		var nPx:Float = (Math.cos(nRotation) * nRadius) + nX;
		var nPy:Float = (Math.sin(nRotation) * nRadius) + nY;
		
		moveTo(nPx, nPy);

		var i:Int = 0;
		for (i in 1...nSides) {
			nPx = (Math.cos((nAngle * i) + nRotation) * nRadius) + nX;
			nPy = (Math.sin((nAngle * i) + nRotation) * nRadius) + nY;
			lineTo(nPx, nPy);
		}
	}

	public function drawStar(nX:Float, nY:Float, nPoints:Int, nInnerRadius:Float, nOuterRadius:Float, nRotation:Float = 0):Void {
		if(nPoints < 3) {
			return;
		}

		var nAngleDelta:Float = (Math.PI * 2) / nPoints;
		nRotation = Math.PI * (nRotation - 90) / 180;
	
		var nAngle:Float = nRotation;

		var nPenX:Float = nX + Math.cos(nAngle + nAngleDelta / 2) * nInnerRadius;
		var nPenY:Float = nY + Math.sin(nAngle + nAngleDelta / 2) * nInnerRadius;

		moveTo(nPenX, nPenY);
		nAngle += nAngleDelta;
		var i = 0;
		for (i in 0...nPoints) {
			nPenX = nX + Math.cos(nAngle) * nOuterRadius;
			nPenY = nY + Math.sin(nAngle) * nOuterRadius;
			lineTo(nPenX, nPenY);
			nPenX = nX + Math.cos(nAngle + nAngleDelta / 2) * nInnerRadius;
			nPenY = nY + Math.sin(nAngle + nAngleDelta / 2) * nInnerRadius;
			lineTo(nPenX, nPenY);
			nAngle += nAngleDelta;
		}
	}
  }