package;

import openfl.Lib;
import openfl.display.*;
import openfl.text.*;
import openfl.events.*;
import openfl.utils.*;
import openfl.filters.*;
import openfl.media.*;

@:font("assets/preloader/font/4mini.ttf") class Mini extends Font {}

class Preloader extends NMEPreloader {
	
	private var stageStageWidth:Int = 810;
	private var stageStageHeight:Int = 520;
	private var runOnce:Bool = true;
	
	private var textLoading:TextField = new TextField();
	private var textLoadingFormat:TextFormat = new TextFormat();
	
	public function new() {
		super();
		removeChild(progress);
		removeChild(outline);
	}

	public override function onUpdate(bytesLoaded:Int, bytesTotal:Int):Void {
		if (runOnce) {
			runOnce = false;
			init();
		}
		textLoading.text = "Loading Game: " + Math.round((bytesLoaded * 100) / bytesTotal) +  "%";
	}

	private function init():Void {
		Lib.current.stage.stageWidth = stageStageWidth;
		Lib.current.stage.stageHeight = stageStageHeight;
		Lib.current.stage.align = flash.display.StageAlign.TOP_LEFT;
		Lib.current.stage.scaleMode = flash.display.StageScaleMode.NO_SCALE;
		
		textLoading.selectable = false;
		textLoading.embedFonts = true;
		textLoading.antiAliasType = AntiAliasType.NORMAL;
		textLoadingFormat.size = 15;
		textLoadingFormat.color = 0xAAAAAA;
		textLoadingFormat.font = "4Mini";
		textLoading.autoSize = TextFieldAutoSize.LEFT;
		textLoading.defaultTextFormat = textLoadingFormat;
		textLoading.setTextFormat (textLoadingFormat);
		textLoading.x = 100;
		textLoading.y = 200;
		textLoading.text = "Initializing.";	
		
		this.addChild(textLoading);
	}
	
	public override function onLoaded () {
		stage.addEventListener(MouseEvent.CLICK, close);
	}
    
	private function close(event:MouseEvent):Void {
		this.dispatchEvent (new Event (Event.COMPLETE));
	}
}