// textgen.h : Text Generator class

#ifndef _TEXTGEN_H
#define _TEXTGEN_H

#include "java2html.h"

class TextGenerator {
  public :
    virtual void generate( const char *s ) const { (*sout) << s ; }
    virtual void generateln( const char *s ) const
	{ 
	    generate( s ) ;
	    (*sout) << endl ; 
	}
    virtual void generateEntire( const char *s ) const
	{
	    startTextGeneration() ;
	    generate(s) ;
	    endTextGeneration() ;
	}
    virtual void startTextGeneration() const {}
    virtual void endTextGeneration() const {}
    virtual void beginText( const char *s ) const
	{
	    startTextGeneration() ;
	    if ( s )
		generate( s ) ;
	}
    virtual void endText( const char *s ) const
	{
	    if ( s )
		generate( s ) ;
	    endTextGeneration() ;
	}
} ;

// Decorator
class TextDecorator : public TextGenerator {
  protected :
    TextGenerator *decorated ;
  
  public :
    TextDecorator( TextGenerator *t ) : decorated( t ) {}

    virtual void startTextGeneration() const 
    { 
	startDecorate() ;
	if ( decorated )
	    decorated->startTextGeneration() ;
    }
    virtual void endTextGeneration() const 
    { 
	if ( decorated )
	    decorated->endTextGeneration() ;
	endDecorate() ;
    }

    // pure virtual functions
    virtual void startDecorate() const = 0 ;
    virtual void endDecorate() const = 0 ;
} ;

#endif
