/*
 * Decompiled with CFR 0.152.
 */
package javaanpr.gui.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javaanpr.Main;
import javaanpr.gui.tools.FileListModel;
import javaanpr.gui.tools.ImageFileFilter;
import javaanpr.gui.windows.FrameHelp;
import javaanpr.imageanalysis.CarSnapshot;
import javaanpr.imageanalysis.Photo;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;

public class FrameMain
extends JFrame {
    static final long serialVersionUID = 0L;
    CarSnapshot car;
    BufferedImage panelCarContent;
    JFileChooser fileChooser;
    private FileListModel fileListModel;
    int selectedIndex = -1;
    private JMenuItem aboutItem;
    private JLabel bottomLine;
    private JMenuItem exitItem;
    private JList fileList;
    private JScrollPane fileListScrollPane;
    private JMenuItem helpItem;
    private JMenu helpMenu;
    private JMenu imageMenu;
    private JMenuBar menuBar;
    private JMenuItem openDirectoryItem;
    private JPanel panelCar;
    private JLabel recognitionLabel;
    private JButton recognizeButton;

    public FrameMain() {
        this.initComponents();
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileSelectionMode(2);
        this.fileChooser.setFileFilter(new ImageFileFilter());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = this.getWidth();
        int height = this.getHeight();
        this.setLocation((screenSize.width - width) / 2, (screenSize.height - height) / 2);
        this.setVisible(true);
    }

    private void initComponents() {
        this.recognitionLabel = new JLabel();
        this.panelCar = new JPanel(){
            static final long serialVersionUID = 0L;

            public void paint(Graphics g) {
                super.paint(g);
                g.drawImage(FrameMain.this.panelCarContent, 0, 0, null);
            }
        };
        this.fileListScrollPane = new JScrollPane();
        this.fileList = new JList();
        this.recognizeButton = new JButton();
        this.bottomLine = new JLabel();
        this.menuBar = new JMenuBar();
        this.imageMenu = new JMenu();
        this.openDirectoryItem = new JMenuItem();
        this.exitItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.aboutItem = new JMenuItem();
        this.helpItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("JavaANPR");
        this.setResizable(false);
        this.recognitionLabel.setBackground(new Color(0, 0, 0));
        this.recognitionLabel.setFont(new Font("Arial", 0, 24));
        this.recognitionLabel.setForeground(new Color(255, 204, 51));
        this.recognitionLabel.setHorizontalAlignment(0);
        this.recognitionLabel.setText(null);
        this.recognitionLabel.setBorder(BorderFactory.createEtchedBorder());
        this.recognitionLabel.setOpaque(true);
        this.panelCar.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout panelCarLayout = new GroupLayout(this.panelCar);
        this.panelCar.setLayout(panelCarLayout);
        panelCarLayout.setHorizontalGroup(panelCarLayout.createParallelGroup(1).add(0, 585, Short.MAX_VALUE));
        panelCarLayout.setVerticalGroup(panelCarLayout.createParallelGroup(1).add(0, 477, Short.MAX_VALUE));
        this.fileListScrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.fileListScrollPane.setVerticalScrollBarPolicy(22);
        this.fileList.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.fileList.setFont(new Font("Arial", 0, 11));
        this.fileList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                FrameMain.this.fileListValueChanged(evt);
            }
        });
        this.fileListScrollPane.setViewportView(this.fileList);
        this.recognizeButton.setFont(new Font("Arial", 0, 11));
        this.recognizeButton.setText("recognize plate");
        this.recognizeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrameMain.this.recognizeButtonActionPerformed(evt);
            }
        });
        this.bottomLine.setFont(new Font("Arial", 0, 11));
        this.bottomLine.setText("Copyright (c) 2006 Ondrej Martinsky");
        this.menuBar.setFont(new Font("Arial", 0, 11));
        this.imageMenu.setText("Image");
        this.imageMenu.setFont(new Font("Arial", 0, 11));
        this.openDirectoryItem.setFont(new Font("Arial", 0, 11));
        this.openDirectoryItem.setText("Load snapshots from directory");
        this.openDirectoryItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrameMain.this.openDirectoryItemActionPerformed(evt);
            }
        });
        this.imageMenu.add(this.openDirectoryItem);
        this.exitItem.setFont(new Font("Arial", 0, 11));
        this.exitItem.setText("Exit");
        this.exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrameMain.this.exitItemActionPerformed(evt);
            }
        });
        this.imageMenu.add(this.exitItem);
        this.menuBar.add(this.imageMenu);
        this.helpMenu.setText("Help");
        this.helpMenu.setFont(new Font("Arial", 0, 11));
        this.helpMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrameMain.this.helpMenuActionPerformed(evt);
            }
        });
        this.aboutItem.setFont(new Font("Arial", 0, 11));
        this.aboutItem.setText("About");
        this.aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrameMain.this.aboutItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutItem);
        this.helpItem.setFont(new Font("Arial", 0, 11));
        this.helpItem.setText("Help");
        this.helpItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FrameMain.this.helpItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.helpItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(2).add(1, this.bottomLine, -1, 589, Short.MAX_VALUE).add(1, this.panelCar, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add(layout.createParallelGroup(2).add(this.fileListScrollPane, -1, 190, Short.MAX_VALUE).add(1, this.recognitionLabel, -1, 190, Short.MAX_VALUE).add(this.recognizeButton, -1, 190, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.fileListScrollPane, -1, 402, Short.MAX_VALUE).addPreferredGap(0).add(this.recognizeButton).addPreferredGap(0).add(this.recognitionLabel, -2, 44, -2)).add(this.panelCar, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add(this.bottomLine)));
        this.pack();
    }

    private void helpMenuActionPerformed(ActionEvent evt) {
    }

    private void helpItemActionPerformed(ActionEvent evt) {
        new FrameHelp(FrameHelp.SHOW_HELP);
    }

    private void aboutItemActionPerformed(ActionEvent evt) {
        new FrameHelp(FrameHelp.SHOW_ABOUT);
    }

    private void recognizeButtonActionPerformed(ActionEvent evt) {
        Object plate = null;
        new RecognizeThread(this).start();
    }

    private void fileListValueChanged(ListSelectionEvent evt) {
        int selectedNow = this.fileList.getSelectedIndex();
        if (selectedNow != -1 && this.selectedIndex != selectedNow) {
            this.recognitionLabel.setText(this.fileListModel.fileList.elementAt((int)selectedNow).recognizedPlate);
            this.selectedIndex = selectedNow;
            String path = ((FileListModel.FileListModelEntry)this.fileListModel.getElementAt((int)selectedNow)).fullPath;
            new LoadImageThread(this, path).start();
        }
    }

    private void exitItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void openDirectoryItemActionPerformed(ActionEvent evt) {
        this.fileChooser.setFileSelectionMode(1);
        this.fileChooser.setDialogTitle("Load snapshots from directory");
        int returnValue = this.fileChooser.showOpenDialog((Component)evt.getSource());
        if (returnValue != 0) {
            return;
        }
        String fileURL = this.fileChooser.getSelectedFile().getAbsolutePath();
        File selectedFile = new File(fileURL);
        this.fileListModel = new FileListModel();
        for (String fileName : selectedFile.list()) {
            if (!ImageFileFilter.accept(fileName)) continue;
            this.fileListModel.addFileListModelEntry(fileName, selectedFile + File.separator + fileName);
        }
        this.fileList.setModel(this.fileListModel);
    }

    public class LoadImageThread
    extends Thread {
        FrameMain parentFrame = null;
        String url = null;

        public LoadImageThread(FrameMain parentFrame, String url) {
            this.parentFrame = parentFrame;
            this.url = url;
        }

        public void run() {
            try {
                this.parentFrame.car = new CarSnapshot(this.url);
                this.parentFrame.panelCarContent = this.parentFrame.car.duplicate().getBi();
                this.parentFrame.panelCarContent = Photo.linearResizeBi(this.parentFrame.panelCarContent, this.parentFrame.panelCar.getWidth(), this.parentFrame.panelCar.getHeight());
                this.parentFrame.panelCar.paint(this.parentFrame.panelCar.getGraphics());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public class RecognizeThread
    extends Thread {
        FrameMain parentFrame = null;

        public RecognizeThread(FrameMain parentFrame) {
            this.parentFrame = parentFrame;
        }

        public void run() {
            String recognizedText = "";
            this.parentFrame.recognitionLabel.setText("processing ...");
            int index = this.parentFrame.selectedIndex;
            try {
                recognizedText = Main.systemLogic.recognize(this.parentFrame.car);
            }
            catch (Exception ex) {
                this.parentFrame.recognitionLabel.setText("");
                return;
            }
            this.parentFrame.recognitionLabel.setText(recognizedText);
            ((FrameMain)this.parentFrame).fileListModel.fileList.elementAt((int)index).recognizedPlate = recognizedText;
        }
    }
}

