/*
 * Decompiled with CFR 0.152.
 */
package javaanpr.imageanalysis;

import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javaanpr.imageanalysis.Band;
import javaanpr.imageanalysis.Graph;
import javaanpr.intelligence.Intelligence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BandGraph
extends Graph {
    Band handle;
    private static double peakFootConstant = Intelligence.configurator.getDoubleProperty("bandgraph_peakfootconstant");
    private static double peakDiffMultiplicationConstant = Intelligence.configurator.getDoubleProperty("bandgraph_peakDiffMultiplicationConstant");

    public BandGraph(Band handle) {
        this.handle = handle;
    }

    public Vector<Graph.Peak> findPeaks(int count) {
        Vector<Graph.Peak> outPeaks = new Vector<Graph.Peak>();
        for (int c = 0; c < count; ++c) {
            float maxValue = 0.0f;
            int maxIndex = 0;
            for (int i = 0; i < this.yValues.size(); ++i) {
                if (!this.allowedInterval(outPeaks, i) || !(((Float)this.yValues.elementAt(i)).floatValue() >= maxValue)) continue;
                maxValue = ((Float)this.yValues.elementAt(i)).floatValue();
                maxIndex = i;
            }
            int leftIndex = this.indexOfLeftPeakRel(maxIndex, peakFootConstant);
            int rightIndex = this.indexOfRightPeakRel(maxIndex, peakFootConstant);
            int diff = rightIndex - leftIndex;
            leftIndex = (int)((double)leftIndex - peakDiffMultiplicationConstant * (double)diff);
            rightIndex = (int)((double)rightIndex + peakDiffMultiplicationConstant * (double)diff);
            outPeaks.add(new Graph.Peak(this, Math.max(0, leftIndex), maxIndex, Math.min(this.yValues.size() - 1, rightIndex)));
        }
        Vector<Graph.Peak> outPeaksFiltered = new Vector<Graph.Peak>();
        for (Graph.Peak p : outPeaks) {
            if (p.getDiff() <= 2 * this.handle.getHeight() || p.getDiff() >= 15 * this.handle.getHeight()) continue;
            outPeaksFiltered.add(p);
        }
        Collections.sort(outPeaksFiltered, new PeakComparer(this.yValues));
        this.peaks = outPeaksFiltered;
        return outPeaksFiltered;
    }

    public int indexOfLeftPeakAbs(int peak, double peakFootConstantAbs) {
        int index = peak;
        boolean counter = false;
        int i = peak;
        while (i >= 0 && !((double)((Float)this.yValues.elementAt(index = i--)).floatValue() < peakFootConstantAbs)) {
        }
        return Math.max(0, index);
    }

    public int indexOfRightPeakAbs(int peak, double peakFootConstantAbs) {
        int index = peak;
        boolean counter = false;
        int i = peak;
        while (i < this.yValues.size() && !((double)((Float)this.yValues.elementAt(index = i++)).floatValue() < peakFootConstantAbs)) {
        }
        return Math.min(this.yValues.size(), index);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PeakComparer
    implements Comparator {
        Vector<Float> yValues = null;

        public PeakComparer(Vector<Float> yValues) {
            this.yValues = yValues;
        }

        private float getPeakValue(Object peak) {
            return this.yValues.elementAt(((Graph.Peak)peak).getCenter()).floatValue();
        }

        public int compare(Object peak1, Object peak2) {
            double comparison = this.getPeakValue(peak2) - this.getPeakValue(peak1);
            if (comparison < 0.0) {
                return -1;
            }
            if (comparison > 0.0) {
                return 1;
            }
            return 0;
        }
    }
}

