/*
 * Decompiled with CFR 0.152.
 */
package javaanpr.imageanalysis;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;

public class HoughTransformation {
    public static int RENDER_ALL = 1;
    public static int RENDER_TRANSFORMONLY = 0;
    public static int COLOR_BW = 0;
    public static int COLOR_HUE = 1;
    float[][] bitmap;
    Point maxPoint = null;
    private int width;
    private int height;
    public float angle = 0.0f;
    public float dx = 0.0f;
    public float dy = 0.0f;

    public HoughTransformation(int width, int height) {
        this.bitmap = new float[width][height];
        this.width = width;
        this.height = height;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.bitmap[x][y] = 0.0f;
            }
        }
    }

    public void addLine(int x, int y, float brightness) {
        float xf = 2.0f * (float)x / (float)this.width - 1.0f;
        float yf = 2.0f * (float)y / (float)this.height - 1.0f;
        for (int a = 0; a < this.width; ++a) {
            float af = 2.0f * (float)a / (float)this.width - 1.0f;
            float bf = yf - af * xf;
            int b = (int)((bf + 1.0f) * (float)this.height / 2.0f);
            if (0 >= b || b >= this.height - 1) continue;
            float[] fArray = this.bitmap[a];
            int n = b;
            fArray[n] = fArray[n] + brightness;
        }
    }

    private float getMaxValue() {
        float maxValue = 0.0f;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                maxValue = Math.max(maxValue, this.bitmap[x][y]);
            }
        }
        return maxValue;
    }

    private Point computeMaxPoint() {
        float max = 0.0f;
        int maxX = 0;
        int maxY = 0;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                float curr = this.bitmap[x][y];
                if (!(curr >= max)) continue;
                maxX = x;
                maxY = y;
                max = curr;
            }
        }
        return new Point(maxX, maxY);
    }

    public Point getMaxPoint() {
        if (this.maxPoint == null) {
            this.maxPoint = this.computeMaxPoint();
        }
        return this.maxPoint;
    }

    private float getAverageValue() {
        float sum = 0.0f;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                sum += this.bitmap[x][y];
            }
        }
        return sum / (float)(this.width * this.height);
    }

    public BufferedImage render(int renderType, int colorType) {
        float average = this.getAverageValue();
        BufferedImage output = new BufferedImage(this.width, this.height, 1);
        Graphics2D g = output.createGraphics();
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                int value = (int)(255.0f * this.bitmap[x][y] / average / 3.0f);
                value = Math.max(0, Math.min(value, 255));
                if (colorType == COLOR_BW) {
                    output.setRGB(x, y, new Color(value, value, value).getRGB());
                    continue;
                }
                output.setRGB(x, y, Color.HSBtoRGB(0.67f - (float)value / 255.0f * 2.0f / 3.0f, 1.0f, 1.0f));
            }
        }
        this.maxPoint = this.computeMaxPoint();
        g.setColor(Color.ORANGE);
        float a = 2.0f * (float)this.maxPoint.x / (float)this.width - 1.0f;
        float b = 2.0f * (float)this.maxPoint.y / (float)this.height - 1.0f;
        float x0f = -1.0f;
        float y0f = a * x0f + b;
        float x1f = 1.0f;
        float y1f = a * x1f + b;
        int y0 = (int)((y0f + 1.0f) * (float)this.height / 2.0f);
        int y1 = (int)((y1f + 1.0f) * (float)this.height / 2.0f);
        int dx = this.width;
        int dy = y1 - y0;
        this.dx = dx;
        this.dy = dy;
        this.angle = (float)(180.0 * Math.atan(this.dy / this.dx) / Math.PI);
        if (renderType == RENDER_ALL) {
            g.drawOval(this.maxPoint.x - 5, this.maxPoint.y - 5, 10, 10);
            g.drawLine(0, this.height / 2 - dy / 2 - 1, this.width, this.height / 2 + dy / 2 - 1);
            g.drawLine(0, this.height / 2 - dy / 2 + 0, this.width, this.height / 2 + dy / 2 + 0);
            g.drawLine(0, this.height / 2 - dy / 2 + 1, this.width, this.height / 2 + dy / 2 + 1);
        }
        return output;
    }
}

