/*
 * Decompiled with CFR 0.152.
 */
package javaanpr.imageanalysis;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Stack;
import java.util.Vector;
import javaanpr.imageanalysis.Photo;

public class PixelMap {
    private Piece bestPiece = null;
    boolean[][] matrix;
    private int width;
    private int height;

    public PixelMap(Photo bi) {
        this.matrixInit(bi);
    }

    void matrixInit(Photo bi) {
        this.width = bi.getWidth();
        this.height = bi.getHeight();
        this.matrix = new boolean[this.width][this.height];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.matrix[x][y] = (double)bi.getBrightness(x, y) < 0.5;
            }
        }
    }

    public BufferedImage render() {
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (this.matrix[x][y]) {
                    image.setRGB(x, y, Color.BLACK.getRGB());
                    continue;
                }
                image.setRGB(x, y, Color.WHITE.getRGB());
            }
        }
        return image;
    }

    public Piece getBestPiece() {
        this.reduceOtherPieces();
        if (this.bestPiece == null) {
            return new Piece();
        }
        return this.bestPiece;
    }

    private boolean getPointValue(int x, int y) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return false;
        }
        return this.matrix[x][y];
    }

    private boolean isBoundaryPoint(int x, int y) {
        if (!this.getPointValue(x, y)) {
            return false;
        }
        return !this.getPointValue(x - 1, y - 1) || !this.getPointValue(x - 1, y + 1) || !this.getPointValue(x + 1, y - 1) || !this.getPointValue(x + 1, y + 1) || !this.getPointValue(x, y + 1) || !this.getPointValue(x, y - 1) || !this.getPointValue(x + 1, y) || !this.getPointValue(x - 1, y);
    }

    private int n(int x, int y) {
        int n = 0;
        if (this.getPointValue(x - 1, y - 1)) {
            ++n;
        }
        if (this.getPointValue(x - 1, y + 1)) {
            ++n;
        }
        if (this.getPointValue(x + 1, y - 1)) {
            ++n;
        }
        if (this.getPointValue(x + 1, y + 1)) {
            ++n;
        }
        if (this.getPointValue(x, y + 1)) {
            ++n;
        }
        if (this.getPointValue(x, y - 1)) {
            ++n;
        }
        if (this.getPointValue(x + 1, y)) {
            ++n;
        }
        if (this.getPointValue(x - 1, y)) {
            ++n;
        }
        return n;
    }

    private int t(int x, int y) {
        int n = 0;
        for (int i = 2; i <= 8; ++i) {
            if (this.p(i, x, y) || !this.p(i + 1, x, y)) continue;
            ++n;
        }
        if (!this.p(9, x, y) && this.p(2, x, y)) {
            ++n;
        }
        return n;
    }

    private boolean p(int i, int x, int y) {
        if (i == 1) {
            return this.getPointValue(x, y);
        }
        if (i == 2) {
            return this.getPointValue(x, y - 1);
        }
        if (i == 3) {
            return this.getPointValue(x + 1, y - 1);
        }
        if (i == 4) {
            return this.getPointValue(x + 1, y);
        }
        if (i == 5) {
            return this.getPointValue(x + 1, y + 1);
        }
        if (i == 6) {
            return this.getPointValue(x, y + 1);
        }
        if (i == 7) {
            return this.getPointValue(x - 1, y + 1);
        }
        if (i == 8) {
            return this.getPointValue(x - 1, y);
        }
        if (i == 9) {
            return this.getPointValue(x - 1, y - 1);
        }
        return false;
    }

    private boolean step1passed(int x, int y) {
        int n = this.n(x, y);
        return !(2 > n || n > 6 || this.t(x, y) != 1 || this.p(2, x, y) && this.p(4, x, y) && this.p(6, x, y) || this.p(4, x, y) && this.p(6, x, y) && this.p(8, x, y));
    }

    private boolean step2passed(int x, int y) {
        int n = this.n(x, y);
        return !(2 > n || n > 6 || this.t(x, y) != 1 || this.p(2, x, y) && this.p(4, x, y) && this.p(8, x, y) || this.p(2, x, y) && this.p(6, x, y) && this.p(8, x, y));
    }

    private void findBoundaryPoints(PointSet set) {
        if (!set.isEmpty()) {
            set.clear();
        }
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (!this.isBoundaryPoint(x, y)) continue;
                set.add(new Point(x, y));
            }
        }
    }

    public PixelMap skeletonize() {
        boolean cont;
        PointSet flaggedPoints = new PointSet();
        PointSet boundaryPoints = new PointSet();
        do {
            cont = false;
            this.findBoundaryPoints(boundaryPoints);
            for (Point p : boundaryPoints) {
                if (!this.step1passed(p.x, p.y)) continue;
                flaggedPoints.add(p);
            }
            if (!flaggedPoints.isEmpty()) {
                cont = true;
            }
            for (Point p : flaggedPoints) {
                this.matrix[p.x][p.y] = false;
                boundaryPoints.remove(p);
            }
            flaggedPoints.clear();
            for (Point p : boundaryPoints) {
                if (!this.step2passed(p.x, p.y)) continue;
                flaggedPoints.add(p);
            }
            if (!flaggedPoints.isEmpty()) {
                cont = true;
            }
            for (Point p : flaggedPoints) {
                this.matrix[p.x][p.y] = false;
            }
            boundaryPoints.clear();
            flaggedPoints.clear();
        } while (cont);
        return this;
    }

    public PixelMap reduceNoise() {
        PointSet pointsToReduce = new PointSet();
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (this.n(x, y) >= 4) continue;
                pointsToReduce.add(new Point(x, y));
            }
        }
        for (Point p : pointsToReduce) {
            this.matrix[p.x][p.y] = false;
        }
        return this;
    }

    private boolean isInPieces(PieceSet pieces, int x, int y) {
        for (Piece piece : pieces) {
            for (Point point : piece) {
                if (!point.equals(x, y)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean seedShouldBeAdded(Piece piece, Point p) {
        if (p.x < 0 || p.y < 0 || p.x >= this.width || p.y >= this.height) {
            return false;
        }
        if (!this.matrix[p.x][p.y]) {
            return false;
        }
        for (Point piecePoint : piece) {
            if (!piecePoint.equals(p)) continue;
            return false;
        }
        return true;
    }

    private Piece createPiece(PointSet unsorted) {
        Piece piece = new Piece();
        PointSet stack = new PointSet();
        stack.push(unsorted.lastElement());
        while (!stack.isEmpty()) {
            Point p = (Point)stack.pop();
            if (!this.seedShouldBeAdded(piece, p)) continue;
            piece.add(p);
            unsorted.removePoint(p);
            stack.push(new Point(p.x + 1, p.y));
            stack.push(new Point(p.x - 1, p.y));
            stack.push(new Point(p.x, p.y + 1));
            stack.push(new Point(p.x, p.y - 1));
        }
        piece.createStatistics();
        return piece;
    }

    public PieceSet findPieces() {
        PieceSet pieces = new PieceSet();
        PointSet unsorted = new PointSet();
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (!this.matrix[x][y]) continue;
                unsorted.add(new Point(x, y));
            }
        }
        while (!unsorted.isEmpty()) {
            pieces.add(this.createPiece(unsorted));
        }
        return pieces;
    }

    public PixelMap reduceOtherPieces() {
        int i;
        if (this.bestPiece != null) {
            return this;
        }
        PieceSet pieces = this.findPieces();
        int maxCost = 0;
        int maxIndex = 0;
        for (i = 0; i < pieces.size(); ++i) {
            if (((Piece)pieces.elementAt(i)).cost() <= maxCost) continue;
            maxCost = ((Piece)pieces.elementAt(i)).cost();
            maxIndex = i;
        }
        for (i = 0; i < pieces.size(); ++i) {
            if (i == maxIndex) continue;
            ((Piece)pieces.elementAt(i)).bleachPiece();
        }
        if (pieces.size() != 0) {
            this.bestPiece = (Piece)pieces.elementAt(maxIndex);
        }
        return this;
    }

    public class Piece
    extends PointSet {
        static final long serialVersionUID = 0L;
        public int mostLeftPoint;
        public int mostRightPoint;
        public int mostTopPoint;
        public int mostBottomPoint;
        public int width;
        public int height;
        public int centerX;
        public int centerY;
        public float magnitude;
        public int numberOfBlackPoints;
        public int numberOfAllPoints;

        public BufferedImage render() {
            if (this.numberOfAllPoints == 0) {
                return null;
            }
            BufferedImage image = new BufferedImage(this.width, this.height, 1);
            for (int x = this.mostLeftPoint; x <= this.mostRightPoint; ++x) {
                for (int y = this.mostTopPoint; y <= this.mostBottomPoint; ++y) {
                    if (PixelMap.this.matrix[x][y]) {
                        image.setRGB(x - this.mostLeftPoint, y - this.mostTopPoint, Color.BLACK.getRGB());
                        continue;
                    }
                    image.setRGB(x - this.mostLeftPoint, y - this.mostTopPoint, Color.WHITE.getRGB());
                }
            }
            return image;
        }

        public void createStatistics() {
            this.mostLeftPoint = this.mostLeftPoint();
            this.mostRightPoint = this.mostRightPoint();
            this.mostTopPoint = this.mostTopPoint();
            this.mostBottomPoint = this.mostBottomPoint();
            this.width = this.mostRightPoint - this.mostLeftPoint + 1;
            this.height = this.mostBottomPoint - this.mostTopPoint + 1;
            this.centerX = (this.mostLeftPoint + this.mostRightPoint) / 2;
            this.centerY = (this.mostTopPoint + this.mostBottomPoint) / 2;
            this.numberOfBlackPoints = this.numberOfBlackPoints();
            this.numberOfAllPoints = this.numberOfAllPoints();
            this.magnitude = this.magnitude();
        }

        public int cost() {
            return this.numberOfAllPoints - this.numberOfBlackPoints();
        }

        public void bleachPiece() {
            for (Point p : this) {
                PixelMap.this.matrix[p.x][p.y] = false;
            }
        }

        private float magnitude() {
            return (float)this.numberOfBlackPoints / (float)this.numberOfAllPoints;
        }

        private int numberOfBlackPoints() {
            return this.size();
        }

        private int numberOfAllPoints() {
            return this.width * this.height;
        }

        private int mostLeftPoint() {
            int position = Integer.MAX_VALUE;
            for (Point p : this) {
                position = Math.min(position, p.x);
            }
            return position;
        }

        private int mostRightPoint() {
            int position = 0;
            for (Point p : this) {
                position = Math.max(position, p.x);
            }
            return position;
        }

        private int mostTopPoint() {
            int position = Integer.MAX_VALUE;
            for (Point p : this) {
                position = Math.min(position, p.y);
            }
            return position;
        }

        private int mostBottomPoint() {
            int position = 0;
            for (Point p : this) {
                position = Math.max(position, p.y);
            }
            return position;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PieceSet
    extends Vector<Piece> {
        static final long serialVersionUID = 0L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PointSet
    extends Stack<Point> {
        static final long serialVersionUID = 0L;

        private PointSet() {
        }

        public void removePoint(Point p) {
            Point toRemove = null;
            for (Point px : this) {
                if (!px.equals(p)) continue;
                toRemove = px;
            }
            this.remove(toRemove);
        }
    }

    private class Point {
        int x;
        int y;

        Point(int x, int y) {
            this.x = x;
            this.y = y;
        }

        boolean equals(Point p2) {
            return p2.x == this.x && p2.y == this.y;
        }

        boolean equals(int x, int y) {
            return x == this.x && y == this.y;
        }

        public boolean value() {
            return PixelMap.this.matrix[this.x][this.y];
        }
    }
}

