/*
 * Decompiled with CFR 0.152.
 */
package javaanpr.imageanalysis;

import java.util.Vector;
import javaanpr.imageanalysis.Graph;
import javaanpr.imageanalysis.Plate;
import javaanpr.intelligence.Intelligence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlateHorizontalGraph
extends Graph {
    private static double peakFootConstant = Intelligence.configurator.getDoubleProperty("platehorizontalgraph_peakfootconstant");
    private static int horizontalDetectionType = Intelligence.configurator.getIntProperty("platehorizontalgraph_detectionType");
    Plate handle;

    public PlateHorizontalGraph(Plate handle) {
        this.handle = handle;
    }

    public float derivation(int index1, int index2) {
        return ((Float)this.yValues.elementAt(index1)).floatValue() - ((Float)this.yValues.elementAt(index2)).floatValue();
    }

    public Vector<Graph.Peak> findPeak(int count) {
        if (horizontalDetectionType == 1) {
            return this.findPeak_edgedetection(count);
        }
        return this.findPeak_derivate(count);
    }

    public Vector<Graph.Peak> findPeak_derivate(int count) {
        int b;
        int a;
        float maxVal = this.getMaxValue();
        for (a = 2; (double)(-this.derivation(a, a + 4)) < (double)maxVal * 0.2 && a < this.yValues.size() - 2 - 2 - 4; ++a) {
        }
        for (b = this.yValues.size() - 1 - 2; (double)this.derivation(b - 4, b) < (double)maxVal * 0.2 && b > a + 2; --b) {
        }
        Vector<Graph.Peak> outPeaks = new Vector<Graph.Peak>();
        outPeaks.add(new Graph.Peak(a, b));
        this.peaks = outPeaks;
        return outPeaks;
    }

    public Vector<Graph.Peak> findPeak_edgedetection(int count) {
        float average = this.getAverageValue();
        int a = 0;
        while (((Float)this.yValues.elementAt(a)).floatValue() < average) {
            ++a;
        }
        int b = this.yValues.size() - 1;
        while (((Float)this.yValues.elementAt(b)).floatValue() < average) {
            --b;
        }
        Vector<Graph.Peak> outPeaks = new Vector<Graph.Peak>();
        a = Math.max(a - 5, 0);
        b = Math.min(b + 5, this.yValues.size());
        outPeaks.add(new Graph.Peak(a, b));
        this.peaks = outPeaks;
        return outPeaks;
    }
}

