/*
 * Decompiled with CFR 0.152.
 */
package javaanpr.intelligence;

import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Vector;
import javaanpr.Main;
import javaanpr.configurator.Configurator;
import javaanpr.gui.TimeMeter;
import javaanpr.imageanalysis.Band;
import javaanpr.imageanalysis.CarSnapshot;
import javaanpr.imageanalysis.Char;
import javaanpr.imageanalysis.HoughTransformation;
import javaanpr.imageanalysis.Photo;
import javaanpr.imageanalysis.Plate;
import javaanpr.intelligence.Parser;
import javaanpr.intelligence.RecognizedPlate;
import javaanpr.recognizer.CharacterRecognizer;
import javaanpr.recognizer.KnnPatternClassificator;
import javaanpr.recognizer.NeuralPatternClassificator;

public class Intelligence {
    private long lastProcessDuration = 0L;
    public static Configurator configurator = new Configurator("." + File.separator + "config.xml");
    public static CharacterRecognizer chrRecog;
    public static Parser parser;
    public boolean enableReportGeneration;

    public Intelligence(boolean enableReportGeneration) throws Exception {
        this.enableReportGeneration = enableReportGeneration;
        int classification_method = configurator.getIntProperty("intelligence_classification_method");
        chrRecog = classification_method == 0 ? new KnnPatternClassificator() : new NeuralPatternClassificator();
        parser = new Parser();
    }

    public long lastProcessDuration() {
        return this.lastProcessDuration;
    }

    public String recognize(CarSnapshot carSnapshot) throws Exception {
        TimeMeter time = new TimeMeter();
        int syntaxAnalysisMode = configurator.getIntProperty("intelligence_syntaxanalysis");
        int skewDetectionMode = configurator.getIntProperty("intelligence_skewdetection");
        if (this.enableReportGeneration) {
            Main.rg.insertText("<h1>Automatic Number Plate Recognition Report</h1>");
            Main.rg.insertText("<span>Image width: " + carSnapshot.getWidth() + " px</span>");
            Main.rg.insertText("<span>Image height: " + carSnapshot.getHeight() + " px</span>");
            Main.rg.insertText("<h2>Vertical and Horizontal plate projection</h2>");
            Main.rg.insertImage(carSnapshot.renderGraph(), "snapshotgraph", 0, 0);
            Main.rg.insertImage(carSnapshot.getBiWithAxes(), "snapshot", 0, 0);
        }
        for (Band b : carSnapshot.getBands()) {
            if (this.enableReportGeneration) {
                Main.rg.insertText("<div class='bandtxt'><h4>Band<br></h4>");
                Main.rg.insertImage(b.getBi(), "bandsmall", 250, 30);
                Main.rg.insertText("<span>Band width : " + b.getWidth() + " px</span>");
                Main.rg.insertText("<span>Band height : " + b.getHeight() + " px</span>");
                Main.rg.insertText("</div>");
            }
            for (Plate plate : b.getPlates()) {
                Vector<Char> chars;
                if (this.enableReportGeneration) {
                    Main.rg.insertText("<div class='platetxt'><h4>Plate<br></h4>");
                    Main.rg.insertImage(plate.getBi(), "platesmall", 120, 30);
                    Main.rg.insertText("<span>Plate width : " + plate.getWidth() + " px</span>");
                    Main.rg.insertText("<span>Plate height : " + plate.getHeight() + " px</span>");
                    Main.rg.insertText("</div>");
                }
                Plate notNormalizedCopy = null;
                BufferedImage renderedHoughTransform = null;
                HoughTransformation hough = null;
                if (this.enableReportGeneration || skewDetectionMode != 0) {
                    notNormalizedCopy = plate.clone();
                    notNormalizedCopy.horizontalEdgeDetector(notNormalizedCopy.getBi());
                    hough = notNormalizedCopy.getHoughTransformation();
                    renderedHoughTransform = hough.render(HoughTransformation.RENDER_ALL, HoughTransformation.COLOR_BW);
                }
                if (skewDetectionMode != 0) {
                    AffineTransform shearTransform = AffineTransform.getShearInstance(0.0, -((double)hough.dy) / (double)hough.dx);
                    BufferedImage core = Plate.createBlankBi(plate.getBi());
                    core.createGraphics().drawRenderedImage(plate.getBi(), shearTransform);
                    plate = new Plate(core);
                }
                plate.normalize();
                float plateWHratio = (float)plate.getWidth() / (float)plate.getHeight();
                if ((double)plateWHratio < configurator.getDoubleProperty("intelligence_minPlateWidthHeightRatio") || (double)plateWHratio > configurator.getDoubleProperty("intelligence_maxPlateWidthHeightRatio") || (chars = plate.getChars()).size() < configurator.getIntProperty("intelligence_minimumChars") || chars.size() > configurator.getIntProperty("intelligence_maximumChars") || (double)plate.getCharsWidthDispersion(chars) > configurator.getDoubleProperty("intelligence_maxCharWidthDispersion")) continue;
                if (this.enableReportGeneration) {
                    Main.rg.insertText("<h2>Detected band</h2>");
                    Main.rg.insertImage(b.getBiWithAxes(), "band", 0, 0);
                    Main.rg.insertImage(b.renderGraph(), "bandgraph", 0, 0);
                    Main.rg.insertText("<h2>Detected plate</h2>");
                    Plate plateCopy = plate.clone();
                    plateCopy.linearResize(450, 90);
                    Main.rg.insertImage(plateCopy.getBiWithAxes(), "plate", 0, 0);
                    Main.rg.insertImage(plateCopy.renderGraph(), "plategraph", 0, 0);
                }
                if (this.enableReportGeneration) {
                    Main.rg.insertText("<h2>Skew detection</h2>");
                    Main.rg.insertImage(notNormalizedCopy.getBi(), "skewimage", 0, 0);
                    Main.rg.insertImage(renderedHoughTransform, "skewtransform", 0, 0);
                    Main.rg.insertText("Detected skew angle : <b>" + hough.angle + "</b>");
                }
                RecognizedPlate recognizedPlate = new RecognizedPlate();
                if (this.enableReportGeneration) {
                    Main.rg.insertText("<h2>Character segmentation</h2>");
                    Main.rg.insertText("<div class='charsegment'>");
                    for (Char chr : chars) {
                        Main.rg.insertImage(Photo.linearResizeBi(chr.getBi(), 70, 100), "", 0, 0);
                    }
                    Main.rg.insertText("</div>");
                }
                for (Char chr : chars) {
                    chr.normalize();
                }
                float averageHeight = plate.getAveragePieceHeight(chars);
                float averageContrast = plate.getAveragePieceContrast(chars);
                float averageBrightness = plate.getAveragePieceBrightness(chars);
                float averageHue = plate.getAveragePieceHue(chars);
                float averageSaturation = plate.getAveragePieceSaturation(chars);
                for (Char chr : chars) {
                    boolean ok = true;
                    String errorFlags = "";
                    float widthHeightRatio = chr.pieceWidth;
                    if ((double)(widthHeightRatio /= (float)chr.pieceHeight) < configurator.getDoubleProperty("intelligence_minCharWidthHeightRatio") || (double)widthHeightRatio > configurator.getDoubleProperty("intelligence_maxCharWidthHeightRatio")) {
                        errorFlags = errorFlags + "WHR ";
                        ok = false;
                        if (!this.enableReportGeneration) continue;
                    }
                    if ((chr.positionInPlate.x1 < 2 || chr.positionInPlate.x2 > plate.getWidth() - 1) && (double)widthHeightRatio < 0.12) {
                        errorFlags = errorFlags + "POS ";
                        ok = false;
                        if (!this.enableReportGeneration) continue;
                    }
                    float contrastCost = Math.abs(chr.statisticContrast - averageContrast);
                    float brightnessCost = Math.abs(chr.statisticAverageBrightness - averageBrightness);
                    float hueCost = Math.abs(chr.statisticAverageHue - averageHue);
                    float saturationCost = Math.abs(chr.statisticAverageSaturation - averageSaturation);
                    float heightCost = ((float)chr.pieceHeight - averageHeight) / averageHeight;
                    if ((double)brightnessCost > configurator.getDoubleProperty("intelligence_maxBrightnessCostDispersion")) {
                        errorFlags = errorFlags + "BRI ";
                        ok = false;
                        if (!this.enableReportGeneration) continue;
                    }
                    if ((double)contrastCost > configurator.getDoubleProperty("intelligence_maxContrastCostDispersion")) {
                        errorFlags = errorFlags + "CON ";
                        ok = false;
                        if (!this.enableReportGeneration) continue;
                    }
                    if ((double)hueCost > configurator.getDoubleProperty("intelligence_maxHueCostDispersion")) {
                        errorFlags = errorFlags + "HUE ";
                        ok = false;
                        if (!this.enableReportGeneration) continue;
                    }
                    if ((double)saturationCost > configurator.getDoubleProperty("intelligence_maxSaturationCostDispersion")) {
                        errorFlags = errorFlags + "SAT ";
                        ok = false;
                        if (!this.enableReportGeneration) continue;
                    }
                    if ((double)heightCost < -configurator.getDoubleProperty("intelligence_maxHeightCostDispersion")) {
                        errorFlags = errorFlags + "HEI ";
                        ok = false;
                        if (!this.enableReportGeneration) continue;
                    }
                    float similarityCost = 0.0f;
                    CharacterRecognizer.RecognizedChar rc = null;
                    if (ok) {
                        rc = chrRecog.recognize(chr);
                        similarityCost = rc.getPatterns().elementAt(0).getCost();
                        if ((double)similarityCost > configurator.getDoubleProperty("intelligence_maxSimilarityCostDispersion")) {
                            errorFlags = errorFlags + "NEU ";
                            ok = false;
                            if (!this.enableReportGeneration) continue;
                        }
                    }
                    if (ok) {
                        recognizedPlate.addChar(rc);
                    }
                    if (!this.enableReportGeneration) continue;
                    Main.rg.insertText("<div class='heuristictable'>");
                    Main.rg.insertImage(Photo.linearResizeBi(chr.getBi(), chr.getWidth() * 2, chr.getHeight() * 2), "skeleton", 0, 0);
                    Main.rg.insertText("<span class='name'>WHR</span><span class='value'>" + widthHeightRatio + "</span>");
                    Main.rg.insertText("<span class='name'>HEI</span><span class='value'>" + heightCost + "</span>");
                    Main.rg.insertText("<span class='name'>NEU</span><span class='value'>" + similarityCost + "</span>");
                    Main.rg.insertText("<span class='name'>CON</span><span class='value'>" + contrastCost + "</span>");
                    Main.rg.insertText("<span class='name'>BRI</span><span class='value'>" + brightnessCost + "</span>");
                    Main.rg.insertText("<span class='name'>HUE</span><span class='value'>" + hueCost + "</span>");
                    Main.rg.insertText("<span class='name'>SAT</span><span class='value'>" + saturationCost + "</span>");
                    Main.rg.insertText("</table>");
                    if (errorFlags.length() != 0) {
                        Main.rg.insertText("<span class='errflags'>" + errorFlags + "</span>");
                    }
                    Main.rg.insertText("</div>");
                }
                if (recognizedPlate.chars.size() < configurator.getIntProperty("intelligence_minimumChars")) continue;
                this.lastProcessDuration = time.getTime();
                String parsedOutput = parser.parse(recognizedPlate, syntaxAnalysisMode);
                if (this.enableReportGeneration) {
                    Main.rg.insertText("<span class='recognized'>");
                    Main.rg.insertText("Recognized plate : " + parsedOutput);
                    Main.rg.insertText("</span>");
                }
                return parsedOutput;
            }
        }
        this.lastProcessDuration = time.getTime();
        return null;
    }
}

