/*
 * Decompiled with CFR 0.152.
 */
package javaanpr.neuralnetwork;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.Random;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeuralNetwork {
    private Vector<NeuralLayer> listLayers = new Vector();
    private Random randomGenerator;

    public NeuralNetwork(Vector<Integer> dimensions) {
        for (int i = 0; i < dimensions.size(); ++i) {
            this.listLayers.add(new NeuralLayer(dimensions.elementAt(i), this));
        }
        this.randomGenerator = new Random();
    }

    public NeuralNetwork(String fileName) throws ParserConfigurationException, SAXException, IOException, ParseException {
        this.loadFromXml(fileName);
        this.randomGenerator = new Random();
    }

    public Vector<Double> test(Vector<Double> inputs) {
        if (inputs.size() != this.getLayer(0).numberOfNeurons()) {
            throw new ArrayIndexOutOfBoundsException("[Error] NN-Test: You are trying to pass vector with " + inputs.size() + " values into neural layer with " + this.getLayer(0).numberOfNeurons() + " neurons. Consider using another network, or another descriptors.");
        }
        return this.activities(inputs);
    }

    public void learn(SetOfIOPairs trainingSet, int maxK, double eps, double lambda, double micro) {
        if (trainingSet.pairs.size() == 0) {
            throw new NullPointerException("[Error] NN-Learn: You are using an empty training set, neural network couldn't be trained.");
        }
        if (trainingSet.pairs.elementAt((int)0).inputs.size() != this.getLayer(0).numberOfNeurons()) {
            throw new ArrayIndexOutOfBoundsException("[Error] NN-Test: You are trying to pass vector with " + trainingSet.pairs.elementAt((int)0).inputs.size() + " values into neural layer with " + this.getLayer(0).numberOfNeurons() + " neurons. Consider using another network, or another descriptors.");
        }
        if (trainingSet.pairs.elementAt((int)0).outputs.size() != this.getLayer(this.numberOfLayers() - 1).numberOfNeurons()) {
            throw new ArrayIndexOutOfBoundsException("[Error] NN-Test:  You are trying to pass vector with " + trainingSet.pairs.elementAt((int)0).inputs.size() + " values into neural layer with " + this.getLayer(0).numberOfNeurons() + " neurons. Consider using another network, or another descriptors.");
        }
        this.adaptation(trainingSet, maxK, eps, lambda, micro);
    }

    public int numberOfLayers() {
        return this.listLayers.size();
    }

    private void loadFromXml(String fileName) throws ParserConfigurationException, SAXException, IOException, ParseException {
        System.out.println("NeuralNetwork : loading network topology from file " + fileName);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document doc = parser.parse(fileName);
        Element nodeNeuralNetwork = doc.getDocumentElement();
        if (!nodeNeuralNetwork.getNodeName().equals("neuralNetwork")) {
            throw new ParseException("[Error] NN-Load: Parse error in XML file, neural network couldn't be loaded.", 0);
        }
        NodeList nodeNeuralNetworkContent = nodeNeuralNetwork.getChildNodes();
        for (int innc = 0; innc < nodeNeuralNetworkContent.getLength(); ++innc) {
            Node nodeStructure = nodeNeuralNetworkContent.item(innc);
            if (!nodeStructure.getNodeName().equals("structure")) continue;
            NodeList nodeStructureContent = nodeStructure.getChildNodes();
            for (int isc = 0; isc < nodeStructureContent.getLength(); ++isc) {
                Node nodeLayer = nodeStructureContent.item(isc);
                if (!nodeLayer.getNodeName().equals("layer")) continue;
                NeuralLayer neuralLayer = new NeuralLayer(this);
                this.listLayers.add(neuralLayer);
                NodeList nodeLayerContent = nodeLayer.getChildNodes();
                for (int ilc = 0; ilc < nodeLayerContent.getLength(); ++ilc) {
                    Node nodeNeuron = nodeLayerContent.item(ilc);
                    if (!nodeNeuron.getNodeName().equals("neuron")) continue;
                    Neuron neuron = new Neuron(Double.parseDouble(((Element)nodeNeuron).getAttribute("threshold")), neuralLayer);
                    neuralLayer.listNeurons.add(neuron);
                    NodeList nodeNeuronContent = nodeNeuron.getChildNodes();
                    for (int inc = 0; inc < nodeNeuronContent.getLength(); ++inc) {
                        Node nodeNeuralInput = nodeNeuronContent.item(inc);
                        if (!nodeNeuralInput.getNodeName().equals("input")) continue;
                        NeuralInput neuralInput = new NeuralInput(Double.parseDouble(((Element)nodeNeuralInput).getAttribute("weight")), neuron);
                        neuron.listInputs.add(neuralInput);
                    }
                }
            }
        }
    }

    public void saveToXml(String fileName) throws ParserConfigurationException, FileNotFoundException, TransformerException, TransformerConfigurationException {
        System.out.println("Saving network topology to file " + fileName);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document doc = parser.newDocument();
        Element root = doc.createElement("neuralNetwork");
        root.setAttribute("dateOfExport", new Date().toString());
        Element layers = doc.createElement("structure");
        layers.setAttribute("numberOfLayers", Integer.toString(this.numberOfLayers()));
        for (int il = 0; il < this.numberOfLayers(); ++il) {
            Element layer = doc.createElement("layer");
            layer.setAttribute("index", Integer.toString(il));
            layer.setAttribute("numberOfNeurons", Integer.toString(this.getLayer(il).numberOfNeurons()));
            for (int in = 0; in < this.getLayer(il).numberOfNeurons(); ++in) {
                Element neuron = doc.createElement("neuron");
                neuron.setAttribute("index", Integer.toString(in));
                neuron.setAttribute("NumberOfInputs", Integer.toString(this.getLayer(il).getNeuron(in).numberOfInputs()));
                neuron.setAttribute("threshold", Double.toString(this.getLayer((int)il).getNeuron((int)in).threshold));
                for (int ii = 0; ii < this.getLayer(il).getNeuron(in).numberOfInputs(); ++ii) {
                    Element input = doc.createElement("input");
                    input.setAttribute("index", Integer.toString(ii));
                    input.setAttribute("weight", Double.toString(this.getLayer((int)il).getNeuron((int)in).getInput((int)ii).weight));
                    neuron.appendChild(input);
                }
                layer.appendChild(neuron);
            }
            layers.appendChild(layer);
        }
        root.appendChild(layers);
        doc.appendChild(root);
        File xmlOutputFile = new File(fileName);
        FileOutputStream fos = new FileOutputStream(xmlOutputFile);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(fos);
        transformer.setOutputProperty("encoding", "iso-8859-2");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
    }

    private double random() {
        return this.randomGenerator.nextDouble();
    }

    private void computeGradient(Gradients gradients, Vector<Double> inputs, Vector<Double> requiredOutputs) {
        this.activities(inputs);
        for (int il = this.numberOfLayers() - 1; il >= 1; --il) {
            int ii;
            int in;
            NeuralLayer currentLayer = this.getLayer(il);
            if (currentLayer.isLayerTop()) {
                Neuron currentNeuron;
                for (in = 0; in < currentLayer.numberOfNeurons(); ++in) {
                    currentNeuron = currentLayer.getNeuron(in);
                    gradients.setThreshold(il, in, currentNeuron.output * (1.0 - currentNeuron.output) * (currentNeuron.output - requiredOutputs.elementAt(in)));
                }
                for (in = 0; in < currentLayer.numberOfNeurons(); ++in) {
                    currentNeuron = currentLayer.getNeuron(in);
                    for (ii = 0; ii < currentNeuron.numberOfInputs(); ++ii) {
                        NeuralInput currentInput = currentNeuron.getInput(ii);
                        gradients.setWeight(il, in, ii, gradients.getThreshold(il, in) * currentLayer.lowerLayer().getNeuron((int)ii).output);
                    }
                }
                continue;
            }
            for (in = 0; in < currentLayer.numberOfNeurons(); ++in) {
                double aux = 0.0;
                for (int ia = 0; ia < currentLayer.upperLayer().numberOfNeurons(); ++ia) {
                    aux += gradients.getThreshold(il + 1, ia) * currentLayer.upperLayer().getNeuron((int)ia).getInput((int)in).weight;
                }
                gradients.setThreshold(il, in, currentLayer.getNeuron((int)in).output * (1.0 - currentLayer.getNeuron((int)in).output) * aux);
            }
            for (in = 0; in < currentLayer.numberOfNeurons(); ++in) {
                Neuron currentNeuron = currentLayer.getNeuron(in);
                for (ii = 0; ii < currentNeuron.numberOfInputs(); ++ii) {
                    NeuralInput currentInput = currentNeuron.getInput(ii);
                    gradients.setWeight(il, in, ii, gradients.getThreshold(il, in) * currentLayer.lowerLayer().getNeuron((int)ii).output);
                }
            }
        }
    }

    private void computeTotalGradient(Gradients totalGradients, Gradients partialGradients, SetOfIOPairs trainingSet) {
        totalGradients.resetGradients();
        for (SetOfIOPairs.IOPair pair : trainingSet.pairs) {
            this.computeGradient(partialGradients, pair.inputs, pair.outputs);
            for (int il = this.numberOfLayers() - 1; il >= 1; --il) {
                NeuralLayer currentLayer = this.getLayer(il);
                for (int in = 0; in < currentLayer.numberOfNeurons(); ++in) {
                    totalGradients.incrementThreshold(il, in, partialGradients.getThreshold(il, in));
                    for (int ii = 0; ii < currentLayer.lowerLayer().numberOfNeurons(); ++ii) {
                        totalGradients.incrementWeight(il, in, ii, partialGradients.getWeight(il, in, ii));
                    }
                }
            }
        }
    }

    private void adaptation(SetOfIOPairs trainingSet, int maxK, double eps, double lambda, double micro) {
        Gradients deltaGradients = new Gradients(this);
        Gradients totalGradients = new Gradients(this);
        Gradients partialGradients = new Gradients(this);
        System.out.println("setting up random weights and thresholds ...");
        for (int il = this.numberOfLayers() - 1; il >= 1; --il) {
            NeuralLayer currentLayer = this.getLayer(il);
            for (int in = 0; in < currentLayer.numberOfNeurons(); ++in) {
                Neuron currentNeuron = currentLayer.getNeuron(in);
                currentNeuron.threshold = 2.0 * this.random() - 1.0;
                for (int ii = 0; ii < currentNeuron.numberOfInputs(); ++ii) {
                    currentNeuron.getInput((int)ii).weight = 2.0 * this.random() - 1.0;
                }
            }
        }
        int currK = 0;
        double currE = Double.POSITIVE_INFINITY;
        System.out.println("entering adaptation loop ... (maxK = " + maxK + ")");
        while (currK < maxK && currE > eps) {
            this.computeTotalGradient(totalGradients, partialGradients, trainingSet);
            for (int il = this.numberOfLayers() - 1; il >= 1; --il) {
                double delta;
                Neuron currentNeuron;
                int in;
                NeuralLayer currentLayer = this.getLayer(il);
                for (in = 0; in < currentLayer.numberOfNeurons(); ++in) {
                    currentNeuron = currentLayer.getNeuron(in);
                    delta = -lambda * totalGradients.getThreshold(il, in) + micro * deltaGradients.getThreshold(il, in);
                    currentNeuron.threshold += delta;
                    deltaGradients.setThreshold(il, in, delta);
                }
                for (in = 0; in < currentLayer.numberOfNeurons(); ++in) {
                    currentNeuron = currentLayer.getNeuron(in);
                    for (int ii = 0; ii < currentNeuron.numberOfInputs(); ++ii) {
                        delta = -lambda * totalGradients.getWeight(il, in, ii) + micro * deltaGradients.getWeight(il, in, ii);
                        currentNeuron.getInput((int)ii).weight += delta;
                        deltaGradients.setWeight(il, in, ii, delta);
                    }
                }
            }
            currE = totalGradients.getGradientAbs();
            if (++currK % 25 != 0) continue;
            System.out.println("currK=" + currK + "   currE=" + currE);
        }
    }

    private Vector<Double> activities(Vector<Double> inputs) {
        for (int il = 0; il < this.numberOfLayers(); ++il) {
            for (int in = 0; in < this.getLayer(il).numberOfNeurons(); ++in) {
                double sum = this.getLayer((int)il).getNeuron((int)in).threshold;
                for (int ii = 0; ii < this.getLayer(il).getNeuron(in).numberOfInputs(); ++ii) {
                    if (il == 0) {
                        sum += this.getLayer((int)il).getNeuron((int)in).getInput((int)ii).weight * inputs.elementAt(in);
                        continue;
                    }
                    sum += this.getLayer((int)il).getNeuron((int)in).getInput((int)ii).weight * this.getLayer((int)(il - 1)).getNeuron((int)ii).output;
                }
                this.getLayer((int)il).getNeuron((int)in).output = this.gainFunction(sum);
            }
        }
        Vector<Double> output = new Vector<Double>();
        for (int i = 0; i < this.getLayer(this.numberOfLayers() - 1).numberOfNeurons(); ++i) {
            output.add(this.getLayer((int)(this.numberOfLayers() - 1)).getNeuron((int)i).output);
        }
        return output;
    }

    private double gainFunction(double x) {
        return 1.0 / (1.0 + Math.exp(-x));
    }

    private NeuralLayer getLayer(int index) {
        return this.listLayers.elementAt(index);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Gradients {
        Vector<Vector<Double>> thresholds;
        Vector<Vector<Vector<Double>>> weights;
        NeuralNetwork neuralNetwork;

        Gradients(NeuralNetwork network) {
            this.neuralNetwork = network;
            this.initGradients();
        }

        public void initGradients() {
            this.thresholds = new Vector();
            this.weights = new Vector();
            for (int il = 0; il < this.neuralNetwork.numberOfLayers(); ++il) {
                this.thresholds.add(new Vector());
                this.weights.add(new Vector());
                for (int in = 0; in < this.neuralNetwork.getLayer(il).numberOfNeurons(); ++in) {
                    this.thresholds.elementAt(il).add(0.0);
                    this.weights.elementAt(il).add(new Vector());
                    for (int ii = 0; ii < this.neuralNetwork.getLayer(il).getNeuron(in).numberOfInputs(); ++ii) {
                        this.weights.elementAt(il).elementAt(in).add(0.0);
                    }
                }
            }
        }

        public void resetGradients() {
            for (int il = 0; il < this.neuralNetwork.numberOfLayers(); ++il) {
                for (int in = 0; in < this.neuralNetwork.getLayer(il).numberOfNeurons(); ++in) {
                    this.setThreshold(il, in, 0.0);
                    for (int ii = 0; ii < this.neuralNetwork.getLayer(il).getNeuron(in).numberOfInputs(); ++ii) {
                        this.setWeight(il, in, ii, 0.0);
                    }
                }
            }
        }

        public double getThreshold(int il, int in) {
            return this.thresholds.elementAt(il).elementAt(in);
        }

        public void setThreshold(int il, int in, double value) {
            this.thresholds.elementAt(il).setElementAt(value, in);
        }

        public void incrementThreshold(int il, int in, double value) {
            this.setThreshold(il, in, this.getThreshold(il, in) + value);
        }

        public double getWeight(int il, int in, int ii) {
            return this.weights.elementAt(il).elementAt(in).elementAt(ii);
        }

        public void setWeight(int il, int in, int ii, double value) {
            this.weights.elementAt(il).elementAt(in).setElementAt(value, ii);
        }

        public void incrementWeight(int il, int in, int ii, double value) {
            this.setWeight(il, in, ii, this.getWeight(il, in, ii) + value);
        }

        public double getGradientAbs() {
            double currE = 0.0;
            for (int il = 1; il < this.neuralNetwork.numberOfLayers(); ++il) {
                currE += this.vectorAbs(this.thresholds.elementAt(il));
                currE += this.doubleVectorAbs(this.weights.elementAt(il));
            }
            return currE;
        }

        private double doubleVectorAbs(Vector<Vector<Double>> doubleVector) {
            double totalX = 0.0;
            for (Vector<Double> vector : doubleVector) {
                totalX += Math.pow(this.vectorAbs(vector), 2.0);
            }
            return Math.sqrt(totalX);
        }

        private double vectorAbs(Vector<Double> vector) {
            double totalX = 0.0;
            for (Double x : vector) {
                totalX += Math.pow(x, 2.0);
            }
            return Math.sqrt(totalX);
        }
    }

    private class NeuralLayer {
        private Vector<Neuron> listNeurons = new Vector();
        int index;
        NeuralNetwork neuralNetwork;

        NeuralLayer(NeuralNetwork neuralNetwork2) {
            this.neuralNetwork = neuralNetwork2;
            this.index = this.neuralNetwork.numberOfLayers();
        }

        NeuralLayer(int numberOfNeurons, NeuralNetwork neuralNetwork2) {
            this.neuralNetwork = neuralNetwork2;
            this.index = this.neuralNetwork.numberOfLayers();
            for (int i = 0; i < numberOfNeurons; ++i) {
                if (this.index == 0) {
                    this.listNeurons.add(new Neuron(1, 0.0, this));
                    continue;
                }
                this.listNeurons.add(new Neuron(this.neuralNetwork.getLayer(this.index - 1).numberOfNeurons(), 0.0, this));
            }
        }

        public int numberOfNeurons() {
            return this.listNeurons.size();
        }

        public boolean isLayerTop() {
            return this.index == this.neuralNetwork.numberOfLayers() - 1;
        }

        public boolean isLayerBottom() {
            return this.index == 0;
        }

        public NeuralLayer upperLayer() {
            if (this.isLayerTop()) {
                return null;
            }
            return this.neuralNetwork.getLayer(this.index + 1);
        }

        public NeuralLayer lowerLayer() {
            if (this.isLayerBottom()) {
                return null;
            }
            return this.neuralNetwork.getLayer(this.index - 1);
        }

        public Neuron getNeuron(int index) {
            return this.listNeurons.elementAt(index);
        }
    }

    private class Neuron {
        private Vector<NeuralInput> listInputs = new Vector();
        int index;
        public double threshold;
        public double output;
        NeuralLayer neuralLayer;

        Neuron(double threshold, NeuralLayer neuralLayer) {
            this.threshold = threshold;
            this.neuralLayer = neuralLayer;
            this.index = this.neuralLayer.numberOfNeurons();
        }

        Neuron(int numberOfInputs, double threshold, NeuralLayer neuralLayer) {
            this.threshold = threshold;
            this.neuralLayer = neuralLayer;
            this.index = this.neuralLayer.numberOfNeurons();
            for (int i = 0; i < numberOfInputs; ++i) {
                this.listInputs.add(new NeuralInput(1.0, this));
            }
        }

        public int numberOfInputs() {
            return this.listInputs.size();
        }

        public NeuralInput getInput(int index) {
            return this.listInputs.elementAt(index);
        }
    }

    private class NeuralInput {
        double weight;
        int index;
        Neuron neuron;

        NeuralInput(double weight, Neuron neuron) {
            this.neuron = neuron;
            this.weight = weight;
            this.index = this.neuron.numberOfInputs();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetOfIOPairs {
        Vector<IOPair> pairs = new Vector();

        public void addIOPair(Vector<Double> inputs, Vector<Double> outputs) {
            this.addIOPair(new IOPair(inputs, outputs));
        }

        public void addIOPair(IOPair pair) {
            this.pairs.add(pair);
        }

        int size() {
            return this.pairs.size();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class IOPair {
            Vector<Double> inputs;
            Vector<Double> outputs;

            public IOPair(Vector<Double> inputs, Vector<Double> outputs) {
                this.inputs = new Vector<Double>(inputs);
                this.outputs = new Vector<Double>(outputs);
            }
        }
    }
}

