/*
 * Decompiled with CFR 0.152.
 */
package javaanpr.recognizer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javaanpr.imageanalysis.Char;

public abstract class CharacterRecognizer {
    public static char[] alphabet = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    public static float[][] features = new float[][]{{0.0f, 1.0f, 0.0f, 1.0f}, {1.0f, 0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f, 1.0f}, {1.0f, 1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 1.0f}, {1.0f, 0.0f, 0.0f, 0.0f}, {1.0f, 1.0f, 1.0f, 0.0f}, {0.0f, 1.0f, 1.0f, 1.0f}, {0.0f, 0.0f, 1.0f, 0.0f}, {0.0f, 1.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 1.0f, 1.0f}, {1.0f, 1.0f, 0.0f, 1.0f}};

    public abstract RecognizedChar recognize(Char var1) throws Exception;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RecognizedChar {
        private Vector<RecognizedPattern> patterns = new Vector();
        private boolean isSorted = false;

        RecognizedChar() {
        }

        public void addPattern(RecognizedPattern pattern) {
            this.patterns.add(pattern);
        }

        public boolean isSorted() {
            return this.isSorted;
        }

        public void sort(int direction) {
            if (this.isSorted) {
                return;
            }
            this.isSorted = true;
            Collections.sort(this.patterns, new PatternComparer(direction));
        }

        public Vector<RecognizedPattern> getPatterns() {
            if (this.isSorted) {
                return this.patterns;
            }
            return null;
        }

        public RecognizedPattern getPattern(int i) {
            if (this.isSorted) {
                return this.patterns.elementAt(i);
            }
            return null;
        }

        public BufferedImage render() {
            int width = 500;
            int height = 200;
            BufferedImage histogram = new BufferedImage(width + 20, height + 20, 1);
            Graphics2D graphic = histogram.createGraphics();
            graphic.setColor(Color.LIGHT_GRAY);
            Rectangle backRect = new Rectangle(0, 0, width + 20, height + 20);
            graphic.fill(backRect);
            graphic.draw(backRect);
            graphic.setColor(Color.BLACK);
            int colWidth = width / this.patterns.size();
            for (int ay = 0; ay <= 100; ay += 10) {
                int y = 15 + (int)((float)(100 - ay) / 100.0f * (float)(height - 20));
                graphic.drawString(new Integer(ay).toString(), 3, y + 11);
                graphic.drawLine(25, y + 5, 35, y + 5);
            }
            graphic.drawLine(35, 19, 35, height);
            graphic.setColor(Color.BLUE);
            for (int i = 0; i < this.patterns.size(); ++i) {
                int left = i * colWidth + 42;
                int top = height - (int)(this.patterns.elementAt(i).cost * (float)(height - 20));
                graphic.drawRect(left, top, colWidth - 2, height - top);
                graphic.drawString(this.patterns.elementAt(i).chr + " ", left + 2, top - 8);
            }
            return histogram;
        }

        public class PatternComparer
        implements Comparator {
            int direction;

            public PatternComparer(int direction) {
                this.direction = direction;
            }

            public int compare(Object o1, Object o2) {
                float cost1 = ((RecognizedPattern)o1).getCost();
                float cost2 = ((RecognizedPattern)o2).getCost();
                int ret = 0;
                if (cost1 < cost2) {
                    ret = -1;
                }
                if (cost1 > cost2) {
                    ret = 1;
                }
                if (this.direction == 1) {
                    ret *= -1;
                }
                return ret;
            }
        }

        public class RecognizedPattern {
            private char chr;
            private float cost;

            RecognizedPattern(char chr, float value) {
                this.chr = chr;
                this.cost = value;
            }

            public char getChar() {
                return this.chr;
            }

            public float getCost() {
                return this.cost;
            }
        }
    }
}

