/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.util.Vector;

class TestReport {
    Vector<TestRecord> records = new Vector();

    TestReport() {
    }

    void addRecord(TestRecord testRecord) {
        this.records.add(testRecord);
    }

    void printStatistics() {
        int weightedScoreCount = 0;
        int binaryScoreCount = 0;
        int characterCount = 0;
        System.out.println("----------------------------------------------");
        System.out.println("Defective plates\n");
        for (TestRecord record : this.records) {
            characterCount += record.getLength();
            weightedScoreCount += record.getGoodCount();
            binaryScoreCount += record.isOk() ? 1 : 0;
            if (record.isOk()) continue;
            System.out.println(record.plate + " ~ " + record.recognizedPlate + " (" + (float)record.getGoodCount() / (float)record.getLength() * 100.0f + "% ok)");
        }
        System.out.println("\n----------------------------------------------");
        System.out.println("Test report statistics\n");
        System.out.println("Total number of plates     : " + this.records.size());
        System.out.println("Total number of characters : " + characterCount);
        System.out.println("Binary score               : " + (float)binaryScoreCount / (float)this.records.size() * 100.0f);
        System.out.println("Weighted score             : " + (float)weightedScoreCount / (float)characterCount * 100.0f);
    }

    class TestRecord {
        String name;
        String plate;
        String recognizedPlate;
        int good;
        int length;

        TestRecord(String name, String plate, String recognizedPlate) {
            this.name = name.trim();
            this.plate = plate.trim();
            this.recognizedPlate = recognizedPlate.trim();
            this.compute();
        }

        private void compute() {
            int i;
            this.length = Math.max(this.plate.length(), this.recognizedPlate.length());
            int g1 = 0;
            int g2 = 0;
            for (i = 0; i < this.length; ++i) {
                if (this.getChar(this.plate, i) != this.getChar(this.recognizedPlate, i)) continue;
                ++g1;
            }
            for (i = 0; i < this.length; ++i) {
                if (this.getChar(this.plate, this.length - i - 1) != this.getChar(this.recognizedPlate, this.length - i - 1)) continue;
                ++g2;
            }
            this.good = Math.max(g1, g2);
        }

        private char getChar(String string, int position) {
            if (position >= string.length()) {
                return ' ';
            }
            if (position < 0) {
                return ' ';
            }
            return string.charAt(position);
        }

        public int getGoodCount() {
            return this.good;
        }

        public int getLength() {
            return this.length;
        }

        public boolean isOk() {
            return this.length == this.good;
        }
    }
}

