/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ThreadLocalBuffers;
import org.eclipse.jetty.io.nio.DirectNIOBuffer;
import org.eclipse.jetty.io.nio.IndirectNIOBuffer;

public class WebSocketBuffers {
    private final ThreadLocalBuffers _buffers;

    public WebSocketBuffers(final int bufferSize) {
        this._buffers = new ThreadLocalBuffers(){

            protected Buffer newHeader(int size) {
                return new DirectNIOBuffer(bufferSize);
            }

            protected Buffer newBuffer(int size) {
                return new IndirectNIOBuffer(bufferSize);
            }

            protected boolean isHeader(Buffer buffer) {
                return buffer instanceof DirectNIOBuffer;
            }
        };
    }

    public Buffer getBuffer() {
        return this._buffers.getBuffer();
    }

    public Buffer getDirectBuffer() {
        return this._buffers.getHeader();
    }

    public void returnBuffer(Buffer buffer) {
        this._buffers.returnBuffer(buffer);
    }
}

