/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketBuffers;
import org.eclipse.jetty.websocket.WebSocketGenerator;
import org.eclipse.jetty.websocket.WebSocketParser;

public class WebSocketConnection
implements Connection,
WebSocket.Outbound {
    final Connector _connector;
    final EndPoint _endp;
    final WebSocketParser _parser;
    final WebSocketGenerator _generator;
    final long _timestamp;
    final WebSocket _websocket;
    final int _maxIdleTimeMs = 30000;

    public WebSocketConnection(Connector connector, WebSocketBuffers buffers, EndPoint endpoint, long timestamp, WebSocket websocket) {
        this._connector = connector;
        this._endp = endpoint;
        this._timestamp = timestamp;
        this._websocket = websocket;
        this._generator = new WebSocketGenerator(buffers, this._endp);
        this._parser = new WebSocketParser(buffers, endpoint, new WebSocketParser.EventHandler(){

            public void onFrame(byte frame, String data) {
                try {
                    WebSocketConnection.this._websocket.onMessage(frame, data);
                }
                catch (ThreadDeath th) {
                    throw th;
                }
                catch (Throwable th) {
                    Log.warn((Throwable)th);
                }
            }

            public void onFrame(byte frame, Buffer buffer) {
                try {
                    byte[] array = buffer.array();
                    WebSocketConnection.this._websocket.onMessage(frame, array, buffer.getIndex(), buffer.length());
                }
                catch (ThreadDeath th) {
                    throw th;
                }
                catch (Throwable th) {
                    Log.warn((Throwable)th);
                }
            }
        });
    }

    public void handle() throws IOException {
        boolean more = true;
        try {
            while (more) {
                int flushed = this._generator.flush();
                int filled = this._parser.parseNext();
                boolean bl = more = flushed > 0 || filled > 0 || !this._parser.isBufferEmpty() || !this._generator.isBufferEmpty();
                if (filled >= 0 && flushed >= 0) continue;
                this._endp.close();
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (this._endp.isOpen()) {
                this._connector.persist(this._endp);
            } else {
                this._websocket.onDisconnect();
            }
        }
    }

    public boolean isOpen() {
        return this._endp != null && this._endp.isOpen();
    }

    public boolean isIdle() {
        return this._parser.isBufferEmpty() && this._generator.isBufferEmpty();
    }

    public boolean isSuspended() {
        return false;
    }

    public long getTimeStamp() {
        return this._timestamp;
    }

    public void sendMessage(byte frame, String content) throws IOException {
        this._generator.addFrame(frame, content, 30000);
        this._generator.flush();
        this._connector.persist(this._endp);
    }

    public void sendMessage(byte frame, byte[] content) throws IOException {
        this._generator.addFrame(frame, content, 30000);
        this._generator.flush();
        this._connector.persist(this._endp);
    }

    public void sendMessage(byte frame, byte[] content, int offset, int length) throws IOException {
        this._generator.addFrame(frame, content, offset, length, 30000);
        this._generator.flush();
        this._connector.persist(this._endp);
    }

    public void disconnect() {
        try {
            this._generator.flush(30000L);
            this._endp.close();
        }
        catch (IOException e) {
            Log.ignore((Throwable)e);
        }
    }

    public void fill(Buffer buffer) {
        this._parser.fill(buffer);
    }
}

