/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.UpgradeConnectionException;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketBuffers;
import org.eclipse.jetty.websocket.WebSocketConnection;

public abstract class WebSocketServlet
extends HttpServlet {
    WebSocketBuffers _buffers;

    public void init() throws ServletException {
        String bs = this.getInitParameter("bufferSize");
        this._buffers = new WebSocketBuffers(bs == null ? 8192 : Integer.parseInt(bs));
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if ("WebSocket".equals(request.getHeader("Upgrade")) && "HTTP/1.1".equals(request.getProtocol())) {
            String protocol = request.getHeader("WebSocket-Protocol");
            WebSocket websocket = this.doWebSocketConnect(request, protocol);
            if (websocket != null) {
                HttpConnection http = HttpConnection.getCurrentConnection();
                ConnectedEndPoint endp = (ConnectedEndPoint)http.getEndPoint();
                WebSocketConnection connection = new WebSocketConnection(http.getConnector(), this._buffers, (EndPoint)endp, http.getTimeStamp(), websocket);
                String uri = request.getRequestURI();
                String host = request.getHeader("Host");
                String origin = request.getHeader("Origin");
                origin = this.checkOrigin(request, host, origin);
                response.setHeader("Upgrade", "WebSocket");
                response.addHeader("Connection", "Upgrade");
                response.addHeader("WebSocket-Origin", origin);
                response.addHeader("WebSocket-Location", "ws://" + host + uri);
                if (protocol != null) {
                    response.addHeader("WebSocket-Protocol", protocol);
                }
                response.sendError(101, "Web Socket Protocol Handshake");
                response.flushBuffer();
                connection.fill(((HttpParser)http.getParser()).getHeaderBuffer());
                connection.fill(((HttpParser)http.getParser()).getBodyBuffer());
                websocket.onConnect(connection);
                throw new UpgradeConnectionException((Connection)connection);
            }
            response.sendError(503);
        } else {
            super.service(request, response);
        }
    }

    protected String checkOrigin(HttpServletRequest request, String host, String origin) {
        if (origin == null) {
            origin = host;
        }
        return origin;
    }

    protected abstract WebSocket doWebSocketConnect(HttpServletRequest var1, String var2);
}

