package comet;

import org.eclipse.jetty.continuation.Continuation;

import javax.servlet.ServletResponse;
import java.io.IOException;
import java.util.ArrayList;

/**
 * User: Ilia
 * Date: 05.03.2010
 * Time: 15:33:35
 * http://wiki.eclipse.org/Jetty/Feature/Continuations
 * http://blogs.webtide.com/gregw/entry/continuations_to_continue
 * http://download.eclipse.org/jetty/stable-7/xref/com/acme/ChatServlet.html
 */
public class ClientManager {
    ArrayList<Continuation> continuations = new ArrayList<Continuation>(10);

    public synchronized void registerClient(Continuation continuation) {
        continuations.add(continuation);
    }

    public synchronized void broadcastMessage(String message) {
        for(Continuation continuation: continuations) {
            continuation.setAttribute("message", message);
            continuation.resume();
        }
        continuations.clear();
    }

    private static ClientManager ourInstance = new ClientManager();

    public static ClientManager getInstance() {
        return ourInstance;
    }

    private ClientManager() {   }

}
