package comet;

import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationSupport;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * User: Ilia
 * Date: 05.03.2010
 * Time: 14:26:50
 */
public class SubscribeServlet extends HttpServlet {

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {

        Continuation continuation = ContinuationSupport.getContinuation(req);

        if (continuation.isInitial()) {
            continuation.suspend();
            ClientManager.getInstance().registerClient(continuation);
        } else {
            String message = (String)continuation.getAttribute("message");
            resp.setContentType("text/plain;charset=utf-8");
            resp.getWriter().print(message);            
        }

    }
}
