sys = require('sys'),
http = require('http');
url = require('url')

clientManager = new function() {
    var clients = []

    this.registerClient = function(client) {
      clients.push(client)
    }

    this.broadcastMessage = function(message) {
      for(var i=0; i<clients.length; i++) {
        var client = clients[i]
        client.writeHeader(200, {'Content-Type': 'text/plain;charset=utf-8'})
      //  sys.puts(sys.inspect(client))
      //  sys.puts(sys.inspect(message))
        client.write(message.toString(), 'utf-8')
        client.close()
      }
      clients = []
    }
}

http.createServer(function (req, res) {
  var urlParsed = url.parse(req.url, true)

  if (urlParsed.pathname == '/publish') {
    //sys.puts(sys.inspect(urlParsed.query.message))
    clientManager.broadcastMessage(urlParsed.query.message)
    res.writeHeader(200, {'Content-Type': 'text/plain;charset=utf-8'})
    res.write('ok', 'utf-8')
    res.close()
  }

  if (urlParsed.pathname == '/subscribe') {
    clientManager.registerClient(res)
  }

  //sys.puts(urlParsed.pathname)

}).listen(8002);
sys.puts('Server running at 127.0.0.1:8002/');
