from twisted.web import server, resource
from twisted.application import service, internet
from twisted.internet import reactor
from twisted.internet.defer import Deferred
from twisted.python import log, logfile
from twisted.python.log import ILogObserver

import psyco
psyco.full()


class ClientManager:
    clients = []
    def registerClient(self, client):
        self.clients.append(client)

    def broadcastMessage(self, message):
        for client in self.clients:
            client.setHeader('content-type','text/plain;charset=utf-8')
            client.write(message)
            client.finish()
        self.clients = []



class CometServer(resource.Resource):

    isLeaf = False
    def __init__(self):
        resource.Resource.__init__(self)
        self.registerChildren()

    def registerChildren(self):
        self.putChild('subscribe', Subscribe() )
        self.putChild('publish', Publish() )

    def getChild( self, path, req ):
        if path == '':
            return self
        else:
            return resource.Resource.getChild( self, path, req )


class Subscribe(resource.Resource):
    isLeaf = True
    def render_GET(self, req):
        clientManager.registerClient(req)
#        req.channel.transport.setTcpKeepAlive(1)
#        req.channel.transport.socket.setsockopt(socket.SOL_TCP, socket.TCP_KEEPINTVL, 200)
        return server.NOT_DONE_YET


class Publish(resource.Resource):
    isLeaf = True
    def render_POST(self, req):
        clientManager.broadcastMessage(req.args['message'][0])
        return "ok"


clientManager = ClientManager()
application = service.Application("App")
application.setComponent(ILogObserver, lambda _: None)



site = server.Site(CometServer())


service = internet.TCPServer(8001, site, backlog = 128)
service.setServiceParent(application)

