/*
 * Decompiled with CFR 0.152.
 */
package org.multiply.processing;

import java.lang.reflect.Method;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import processing.core.PApplet;

public class TimedEventGenerator {
    public static final String VERSION = "1.0";
    private static final String defaultEventName = "onTimerEvent";
    private static final int defaultIntervalMs = 500;
    private PApplet parentApplet;
    private ScheduledExecutorService executor;
    private String timerEventName;
    private Method timerEvent;
    private int intervalMs;
    private boolean isEnabled;
    private ScheduledFuture<?> currentTask;

    public TimedEventGenerator(PApplet pApplet) {
        this(pApplet, defaultEventName, true);
    }

    public TimedEventGenerator(PApplet pApplet, String string) {
        this(pApplet, string, true);
    }

    public TimedEventGenerator(PApplet pApplet, String string, boolean bl) {
        this(pApplet, string, bl, 500);
    }

    public TimedEventGenerator(PApplet pApplet, String string, boolean bl, int n) {
        this.parentApplet = pApplet;
        this.timerEventName = string;
        this.isEnabled = bl;
        this.intervalMs = n;
        try {
            this.timerEvent = pApplet.getClass().getMethod(string, null);
        }
        catch (Exception exception) {
            this.isEnabled = false;
            throw new RuntimeException("Your sketch is using the TimedEventGenerator without defining the target method " + string + "()!");
        }
        this.executor = Executors.newSingleThreadScheduledExecutor();
        if (bl) {
            this.scheduleTask();
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled) {
            this.cancelTask();
        } else {
            this.scheduleTask();
        }
        this.isEnabled = bl;
    }

    public int getIntervalMs() {
        return this.intervalMs;
    }

    public void setIntervalMs(int n) {
        this.intervalMs = n;
        if (this.isEnabled) {
            this.cancelTask();
            this.scheduleTask();
        }
    }

    public static String version() {
        return VERSION;
    }

    private void scheduleTask() {
        this.currentTask = this.executor.scheduleAtFixedRate(new MethodInvoker(), this.intervalMs, this.intervalMs, TimeUnit.MILLISECONDS);
    }

    private void cancelTask() {
        this.currentTask.cancel(true);
    }

    private class MethodInvoker
    implements Runnable {
        private MethodInvoker() {
        }

        @Override
        public void run() {
            try {
                TimedEventGenerator.this.timerEvent.invoke((Object)TimedEventGenerator.this.parentApplet, new Object[0]);
            }
            catch (Exception exception) {
                System.err.println("Disabling " + TimedEventGenerator.this.timerEventName + "() for TimedEventGenerator " + "because of an error.");
                exception.printStackTrace();
                TimedEventGenerator.this.cancelTask();
            }
        }
    }
}

