/*
 * Decompiled with CFR 0.152.
 */
package ca.probability.jeff.metropolis;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class MetropolisApp
extends JPanel
implements Runnable,
KeyListener {
    private static final long serialVersionUID = -3999169206661400443L;
    private final DecimalFormat df2 = new DecimalFormat("#.##");
    private final DecimalFormat df4 = new DecimalFormat("0.0000");
    private final DecimalFormat df8 = new DecimalFormat("#.########");
    private int j;
    private int k;
    private int ix;
    private int iproposal;
    private int igamma = 2;
    private double SUM;
    private double mean;
    private double tmpdouble;
    private int iteration;
    private boolean REDRAW = true;
    private final boolean FORCEDREDRAW = true;
    private boolean SHOWLINES = true;
    private int targetmode = 1;
    private int speedcontrol = 2;
    private final int MINNUMSTATES = 3;
    private final int MAXNUMSTATES = 10;
    private final double[] idens = new double[11];
    private final int[] denscount = new int[11];
    private int numstates = 6;
    private double smalldensval = 1.0E-4;
    private double densmean;
    private double diff;
    private int segment;
    private int itmp;
    private boolean accept;
    private boolean JUMPONE;
    private boolean RECOUNT;
    private boolean keyjustpressed = false;
    private boolean RESTARTING = true;
    private int ADAPTLEVEL = 1;
    private Image holdImage;
    private Graphics holdGraphics;

    public static void main(String[] args) {
        System.setProperty("sun.java2d.opengl", "true");
        SwingUtilities.invokeLater(MetropolisApp::launch);
    }

    public static void launch() {
        Dimension appSize = new Dimension(800, 440);
        MetropolisApp main = new MetropolisApp();
        JFrame frame = new JFrame("Metropolis");
        frame.setPreferredSize(appSize);
        frame.setFocusable(true);
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(main);
        frame.setFocusable(true);
        frame.addKeyListener(main);
        frame.pack();
        frame.setVisible(true);
        main.init();
        main.start();
    }

    public void init() {
        this.holdImage = this.createImage(this.getSize().width, this.getSize().height);
        this.holdGraphics = this.holdImage.getGraphics();
    }

    @Override
    public void run() {
        if (this.RESTARTING) {
            this.setdens();
            this.zerocount();
            if (this.ADAPTLEVEL > 1) {
                this.igamma = 2;
            }
            this.ix = this.numstates - 1;
            this.RECOUNT = false;
            this.JUMPONE = false;
            this.REDRAW = true;
            this.RESTARTING = false;
        } else if (this.RECOUNT) {
            this.zerocount();
            this.RECOUNT = false;
        }
        ++this.iteration;
        this.SUM += (double)this.ix;
        this.denscount[this.ix] = this.denscount[this.ix] + 1;
        this.itmp = 2 * this.igamma + 1;
        this.iproposal = this.ix;
        while (this.iproposal == this.ix) {
            this.iproposal = this.ix + (int)(Math.random() * (double)this.itmp) - this.igamma;
        }
        this.accept = this.iproposal >= 1 && this.iproposal <= this.numstates && this.idens[this.ix] * Math.random() < this.idens[this.iproposal];
        this.segment = 1;
        while (this.segment <= 5) {
            this.updatenpause();
            ++this.segment;
        }
        if (this.accept) {
            this.ix = this.iproposal;
        }
        if (this.ADAPTLEVEL == 3 || this.ADAPTLEVEL == 2 && (double)this.iteration * Math.random() < 1.0) {
            if (this.accept) {
                ++this.igamma;
            } else if (this.igamma > 1) {
                --this.igamma;
            }
        }
    }

    public void updatenpause() {
        if (!(this.RESTARTING || this.RECOUNT || this.speedcontrol >= 5 && this.segment != 1 && !this.keyjustpressed || this.segment >= 5 && !this.accept)) {
            this.itmp = 10 * (this.speedcontrol - 5) * (this.speedcontrol - 5);
            if (this.speedcontrol <= 5 || this.keyjustpressed || this.iteration == this.iteration / this.itmp * this.itmp) {
                this.callRepaintAndSync();
            }
            this.keyjustpressed = false;
            if (this.speedcontrol <= 1) {
                this.JUMPONE = false;
                while (!(this.speedcontrol > 1 || this.JUMPONE || this.RESTARTING || this.RECOUNT)) {
                    this.dosleep(50L);
                }
            } else if (this.speedcontrol == 2) {
                this.dosleep(1000L);
            } else if (this.speedcontrol == 3) {
                this.dosleep(250L);
            } else if (this.speedcontrol == 4) {
                this.dosleep(50L);
            } else if (this.speedcontrol == 5) {
                this.dosleep(40L);
            } else if (this.speedcontrol >= 6) {
                this.dosleep(20L);
            }
            this.REDRAW = true;
            this.JUMPONE = false;
        }
    }

    @Override
    public void paint(Graphics g) {
        int xzero = this.getSize().width / 8;
        int yzero = this.getSize().height * 3 / 4;
        int xspacing = this.getSize().width * 42 / 80 / this.numstates;
        int xaxislength = this.getSize().width * 11 / 16;
        int axiswidth = this.getSize().width * 3 / 800;
        int markrad = this.getSize().height / 36;
        int circlerad = this.getSize().height / 30;
        int stateheight = yzero + this.getSize().height / 8;
        int propheight = stateheight + this.getSize().height * 5 / 72;
        int textx = this.getSize().width * 3 / 4;
        int texty = this.getSize().height / 12;
        int textinc = this.getSize().height / 16;
        int fontheight = this.getSize().width / 60;
        int yspacing = this.getSize().height / 11;
        int yaxislength = this.getSize().height * 25 / 44;
        boolean xmarkspacing = true;
        double ymarkspacing = 0.1;
        Font strongfont = new Font("TimesRoman", 1, fontheight);
        g.setFont(strongfont);
        int MINBLUERECT = this.getSize().height / 220;
        int BARWIDTH = this.getSize().width / 88;
        int dlen = this.getSize().height / 20;
        if (this.REDRAW) {
            g.setColor(Color.pink);
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            g.setColor(Color.red);
            g.fillRect(xzero - axiswidth / 2, yzero - yaxislength, axiswidth, yaxislength);
            g.fillRect(xzero, yzero - axiswidth / 2, xaxislength, axiswidth);
            g.drawString("state", xzero + xaxislength - 30, yzero + 40);
            g.drawLine(xzero + xaxislength + 2, yzero, xzero + xaxislength - 20, yzero - 10);
            g.drawLine(xzero + xaxislength + 2, yzero, xzero + xaxislength - 20, yzero + 10);
            g.drawLine(xzero, yzero - yaxislength - 2, xzero - 10, yzero - yaxislength + 20);
            g.drawLine(xzero, yzero - yaxislength - 2, xzero + 10, yzero - yaxislength + 20);
            this.k = 0;
            while (this.k <= (xaxislength - 30) / xspacing) {
                this.tmpdouble = Math.floor(100 * this.k * 1) / 100.0;
                this.itmp = xzero + this.k * xspacing;
                g.drawString("" + this.k * 1, this.itmp - 3, yzero + markrad + 15);
                g.drawLine(this.itmp, yzero - markrad, this.itmp, yzero + markrad);
                ++this.k;
            }
            this.k = 0;
            while (this.k <= (yaxislength - 30) / yspacing) {
                this.tmpdouble = Math.floor((double)(100 * this.k) * 0.1) / 100.0;
                this.itmp = yzero - this.k * yspacing;
                g.drawString("" + this.tmpdouble, xzero - markrad - 30, this.itmp + 5);
                g.drawLine(xzero - markrad, this.itmp, xzero + markrad, this.itmp);
                ++this.k;
            }
            g.setColor(Color.blue);
            this.j = 1;
            while (this.j <= this.numstates) {
                this.itmp = (int)Math.floor(this.idens[this.j] * (double)yspacing / 0.1);
                if (this.itmp < MINBLUERECT) {
                    this.itmp = MINBLUERECT;
                }
                g.fillRect(xzero + this.j * xspacing + 2, yzero - this.itmp, BARWIDTH, this.itmp);
                ++this.j;
            }
            g.drawString("target", xzero - this.getSize().width / 10, yzero - yaxislength - 0);
            if (this.SHOWLINES) {
                this.itmp = (int)Math.floor((double)xzero + this.densmean * (double)xspacing / 1.0);
                g.drawLine(this.itmp, yzero - yaxislength, this.itmp, yzero - yaxislength + dlen);
            }
        } else {
            g.setColor(Color.pink);
            g.fillRect(xzero, yzero - 50, 200, 40);
        }
        g.setColor(Color.black);
        this.mean = this.SUM / (double)this.iteration;
        g.drawString("Metropolis Algorithm applet, by Jeffrey S. Rosenthal", xzero / 5, texty / 2);
        g.drawString("Mean state: " + this.df2.format(this.mean), textx, texty);
        g.drawString("Iteration: " + this.iteration, textx, texty + textinc);
        g.drawString("Current State: " + this.ix, textx, texty + 2 * textinc);
        g.drawString("Gamma: " + this.igamma, textx, texty + 3 * textinc);
        this.diff = 0.0;
        this.j = 1;
        while (this.j <= this.numstates) {
            this.diff += Math.abs(this.idens[this.j] - (double)this.denscount[this.j] / (double)this.iteration);
            ++this.j;
        }
        g.drawString("TV dist: " + this.df4.format(0.5 * this.diff), textx, texty + 4 * textinc);
        g.drawString("Animation: " + this.speedcontrol, textx, texty + 5 * textinc);
        if (this.ADAPTLEVEL == 3) {
            g.drawString("Adapt: yes", textx, texty + 6 * textinc);
        } else if (this.ADAPTLEVEL == 1) {
            g.drawString("Adapt: no", textx, texty + 6 * textinc);
        } else if (this.ADAPTLEVEL == 2) {
            g.drawString("Adapt: decr", textx, texty + 6 * textinc);
        }
        if (this.targetmode == 3) {
            g.drawString("t[2]: " + this.df8.format(this.idens[2]), textx, texty + 7 * textinc);
        }
        if (this.SHOWLINES) {
            this.itmp = (int)Math.floor((double)xzero + this.mean * (double)xspacing / 1.0);
            g.drawLine(this.itmp, yzero - yaxislength, this.itmp, yzero - yaxislength + dlen);
            this.j = 1;
            while (this.j <= this.numstates) {
                this.itmp = (int)Math.floor((double)this.denscount[this.j] / (double)this.iteration * (double)yspacing / 0.1);
                g.fillRect(xzero + this.j * xspacing - BARWIDTH - 2, yzero - this.itmp, BARWIDTH, this.itmp);
                ++this.j;
            }
        }
        g.setColor(Color.black);
        if (this.segment == 5 && this.accept) {
            this.fillcircle(g, xzero + this.iproposal * xspacing, stateheight, circlerad);
        } else {
            this.fillcircle(g, xzero + this.ix * xspacing, stateheight, circlerad);
        }
        if (this.segment == 2) {
            g.setColor(Color.white);
            this.j = this.ix - this.igamma;
            while (this.j <= this.ix + this.igamma) {
                if (this.j != this.ix) {
                    this.fillcircle(g, xzero + this.j * xspacing, propheight, circlerad);
                }
                ++this.j;
            }
        } else if (this.segment == 3) {
            g.setColor(Color.yellow);
            this.fillcircle(g, xzero + this.iproposal * xspacing, propheight, circlerad);
        } else if (this.segment >= 4) {
            if (this.accept) {
                g.setColor(Color.green);
            } else {
                g.setColor(Color.red);
            }
            this.fillcircle(g, xzero + this.iproposal * xspacing, propheight, circlerad);
        }
    }

    public void setdens() {
        switch (this.targetmode) {
            case 1: {
                this.idens[5] = 0.15;
                this.idens[3] = 0.15;
                this.idens[1] = 0.15;
                this.idens[2] = 0.09;
                this.idens[6] = 0.23;
                this.idens[4] = 0.23;
                this.idens[10] = 0.1;
                this.idens[9] = 0.1;
                this.idens[8] = 0.1;
                this.idens[7] = 0.1;
                break;
            }
            case 2: {
                this.j = 1;
                while (this.j <= this.numstates) {
                    this.idens[this.j] = 0.5 - Math.log(Math.random());
                    ++this.j;
                }
                break;
            }
            case 3: {
                this.j = 1;
                while (this.j <= this.numstates) {
                    this.idens[this.j] = (1.0 - this.smalldensval) / (double)(this.numstates - 1);
                    ++this.j;
                }
                this.idens[2] = this.smalldensval;
            }
        }
        double tmpsum = 0.0;
        this.j = 1;
        while (this.j <= this.numstates) {
            tmpsum += this.idens[this.j];
            ++this.j;
        }
        this.j = 1;
        while (this.j <= this.numstates) {
            this.idens[this.j] = this.idens[this.j] / tmpsum;
            ++this.j;
        }
        this.densmean = 0.0;
        this.j = 1;
        while (this.j <= this.numstates) {
            this.densmean += (double)this.j * this.idens[this.j];
            ++this.j;
        }
    }

    public void zerocount() {
        this.mean = 0.0;
        this.SUM = 0.0;
        this.iteration = 0;
        this.j = 1;
        while (this.j <= this.numstates) {
            this.denscount[this.j] = 0;
            ++this.j;
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(this.holdGraphics);
        g.drawImage(this.holdImage, 0, 0, this);
    }

    public void dosleep(long nummilisecs) {
        try {
            Thread.sleep(nummilisecs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void fillcircle(Graphics g, int xx, int yy, int rr) {
        g.fillOval(xx - rr, yy - rr, 2 * rr, 2 * rr);
    }

    public void start() {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        executor.scheduleAtFixedRate(this, 0L, 16L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        char keystroke = e.getKeyChar();
        if (keystroke >= '0' && keystroke <= '9') {
            this.speedcontrol = keystroke - 48;
            if (keystroke > '0') {
                this.JUMPONE = true;
            }
        }
        if (keystroke == 'r') {
            this.RESTARTING = true;
        }
        if (keystroke == 'z') {
            this.RECOUNT = true;
        }
        if (keystroke == 's') {
            boolean bl = this.SHOWLINES = !this.SHOWLINES;
        }
        if (keystroke == '+' && this.numstates < 10) {
            ++this.numstates;
            this.smalldensval = Math.min(this.smalldensval, 1.0 / (double)this.numstates);
            this.RESTARTING = true;
        }
        if (keystroke == '-' && this.numstates > 3) {
            --this.numstates;
            this.RESTARTING = true;
        }
        if (keystroke == '>' && this.targetmode == 3) {
            this.smalldensval = Math.min(10.0 * this.smalldensval, 1.0 / (double)this.numstates);
            this.setdens();
            this.RESTARTING = true;
        }
        if (keystroke == '<' && this.targetmode == 3) {
            this.smalldensval = this.smalldensval > 0.1 ? 0.1 : (this.smalldensval /= 10.0);
            this.setdens();
            this.RESTARTING = true;
        }
        if (keystroke == 'g') {
            ++this.targetmode;
            if (this.targetmode == 4) {
                this.targetmode = 1;
            }
            this.RESTARTING = true;
        }
        if (keystroke == 'y') {
            this.ADAPTLEVEL = 3;
        }
        if (keystroke == 'd') {
            this.ADAPTLEVEL = 2;
        }
        if (keystroke == 'n') {
            this.ADAPTLEVEL = 1;
        }
        if (keystroke == 'o') {
            this.ADAPTLEVEL = 1;
            this.igamma = 1;
        }
        if (keystroke == 't') {
            this.ADAPTLEVEL = 1;
            this.igamma = 2;
        }
        if (keystroke == 'p') {
            ++this.igamma;
        }
        if (keystroke == 'm' && this.igamma >= 2) {
            --this.igamma;
        }
        if (keystroke == 'F') {
            this.igamma = 50;
        }
        if (keystroke == 'A') {
            this.iproposal = 1;
            this.ix = 1;
        }
        if (keystroke == 'B') {
            this.ix = this.iproposal = this.numstates;
        }
        this.keyjustpressed = true;
        this.callRepaintAndSync();
    }

    final void callRepaintAndSync() {
        this.repaint();
        Toolkit.getDefaultToolkit().sync();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

