#!/usr/bin/env python
"""
Show all keys in the dynamic store
"""
import sys
from Foundation import NSObject
from SystemConfiguration import UNSystemConfigurationDynamicStore

def getStore(store=None):
    if store is None:
        store = UNSystemConfigurationDynamicStore.alloc().initWithName_(u'AllKeys')
    return store

ALLKEYSPATTERN = ur'.*'
def getAllKeys(store=None):
    # Typical Example: State:/IOKit/PowerSources/InternalBattery-0
    ds = getStore(store)
    return ds.keyListForPattern_(ALLKEYSPATTERN)

def main():
    store = getStore()
    keys = getAllKeys(store)
    for key in keys:
        print key
        print store.valueForKey_(key)

if __name__=='__main__':
    main()
