#!/usr/bin/env python
"""
Show or monitor battery status
"""
import sys
from Foundation import NSObject
from SystemConfiguration import UNSystemConfigurationDynamicStore
from AppKit import NSApplication
from PyObjCTools import AppHelper

def getStore(store=None):
    if store is None:
        store = UNSystemConfigurationDynamicStore.alloc().initWithName_(u'BatteryDemoNew')
    return store

BATTERYPATTERN = ur'.*/InternalBattery[^/]+'
def getBatteryKeys(store=None):
    # Typical Example: State:/IOKit/PowerSources/InternalBattery-0
    ds = getStore(store)
    return ds.keyListForPattern_(BATTERYPATTERN)

def iterBatteryInfo(dct):
    def v(k, units=''):
        return '%-20s: %s%s' % (k, dct[k], units)
    if not dct[u'Is Charging'] and dct[u'Time to Empty'] < 0:
        yield v(u'Current Capacity', '% (charged)')
        return
    yield v(u"Current Capacity", '%')
    if dct[u'Is Charging']:
        yield v(u"Time to Full Charge", ' min')
    else:
        yield v(u"Time to Empty", ' min')

def main():
    store = getStore()
    keys = getBatteryKeys(store)
    if not keys:
        raise SystemExit, "You're not on a laptop!"
    for key in keys:
        info = iterBatteryInfo(store.valueForKey_(key))
        print key
        print '\n'.join(['\t%s' % (line,) for line in info])

class FollowBatteryDelegate(NSObject):
    def init(self):
        self = super(FollowBatteryDelegate, self).init()
        self.last = {}
        return self

    def keysChanged_inDynamicStore_(self, changed, store):
        for key in changed:
            info = iterBatteryInfo(store.valueForKey_(key))
            print key
            print '\n'.join(['\t%s' % (line,) for line in info])

def follow():
    store = getStore()
    keys = getBatteryKeys(store)
    if not keys:
        raise SystemExit, "You're not on a laptop!"
    delegate = FollowBatteryDelegate.alloc().init()
    store.setDelegate_(delegate)
    delegate.keysChanged_inDynamicStore_(keys, store)
    store.notifyValuesForKeys_matchingPatterns_(None, [BATTERYPATTERN])
    store.addToCurrentRunLoop()
    AppHelper.runConsoleEventLoop()
    
if __name__=='__main__':
    if '-f' in sys.argv[1:]:
        follow()
    else:
        main()
