#!/usr/bin/env python
"""
Show all keys in the dynamic store
"""
import sys
from Foundation import NSObject
from SystemConfiguration import UNSystemConfigurationPreferences
def getStore(store=None):
    if store is None:
        return UNSystemConfigurationPreferences.alloc().initWithName_(u"UNSystemConfiguration")
    return store

def getAllKeys(store=None):
    ds = getStore(store)
    return ds.keyList()

def main():
    store = getStore()
    keys = getAllKeys(store)
    for key in keys:
        print key
        print store.valueForKey_(key)

if __name__=='__main__':
    main()
