from util import Enumerator
class SCNetworkConnectionFlags(Enumerator):
     kSCNetworkFlagsTransientConnection =  1<<0
     kSCNetworkFlagsReachable  =  1<<1
     kSCNetworkFlagsConnectionRequired =  1<<2
     kSCNetworkFlagsConnectionAutomatic =  1<<3
     kSCNetworkFlagsInterventionRequired =  1<<4

class SCStatusCodes(Enumerator):
        # Generic status codes
        kSCStatusOK    = 0 
        kSCStatusOK__doc__ = """Success"""
        kSCStatusFailed    = 1001 
        kSCStatusFailed__doc__ = """Non-specific failure"""
        kSCStatusInvalidArgument  = 1002 
        kSCStatusInvalidArgument__doc__ = """Invalid argument"""
        kSCStatusAccessError__doc__ = """Permission denied.  Must be root to obtain lock.  Could not create access/create preferences"""
        kSCStatusAccessError   = 1003
        kSCStatusNoKey    = 1004 
        kSCStatusNoKey__doc__ = """No such key"""
        kSCStatusKeyExists   = 1005 
        kSCStatusKeyExists__doc__ = """Key already defined"""
        kSCStatusLocked    = 1006 
        kSCStatusLocked__doc__ = """Lock already held"""
        kSCStatusNeedLock   = 1007 
        kSCStatusNeedLock__doc__ = """Lock required for this operation"""
        # SCDynamicStore status codes
        kSCStatusNoStoreSession   = 2001 
        kSCStatusNoStoreSession__doc__ = """Configuration daemon session not active"""
        kSCStatusNoStoreServer   = 2002 
        kSCStatusNoStoreServer__doc__ = """Configuration daemon not (no longer) available"""
        kSCStatusNotifierActive   = 2003 
        kSCStatusNotifierActive__doc__ = """Notifier is currently active"""
        # SCPreferences status codes
        kSCStatusNoPrefsSession   = 3001 
        kSCStatusNoPrefsSession__doc__ = """Preference session not active"""
        kSCStatusPrefsBusy   = 3002 
        kSCStatusPrefsBusy__doc__ = """Preferences update currently in progress"""
        kSCStatusNoConfigFile   = 3003 
        kSCStatusNoConfigFile__doc__ = """Configuration file not found"""
        kSCStatusNoLink    = 3004 
        kSCStatusNoLink__doc__ = """No such link"""
        kSCStatusStale    = 3005 
        kSCStatusStale__doc__ = """Write attempted on stale version of object"""
        kSCStatusMaxLink   = 3006 
        kSCStatusMaxLink__doc__ = """Maximum link count exceeded"""
        # SCNetwork status codes
        kSCStatusReachabilityUnknown  = 4001 
        kSCStatusReachabilityUnknown__doc__ = """Network reachability cannot be determined"""

_globals = globals()
for _v in _globals.values():
    if isinstance(_v, type) and issubclass(_v, Enumerator):
        _globals.update(_v.__keys__)
del _globals, _v
