import objc, Foundation, os
def _findFramework(framework):
    SEARCHPATH = (
        os.path.split(__file__)[0],
        Foundation.NSBundle.mainBundle().resourcePath(),
        os.path.expanduser('~/Library/Frameworks'),
        '/Library/Frameworks',
        '/System/Library/Frameworks',
        '/Network/Library/Frameworks',
    )
    for path in SEARCHPATH:
        path = os.path.realpath(os.path.join(path, framework+'.framework'))
        if os.path.exists(path):
            return path
    else:
        raise ImportError, "Couldn't find %s.framework" % (framework,)
objc.loadBundle('UNSystemConfiguration', globals(), bundle_path=_findFramework('UNSystemConfiguration'))
del objc, Foundation, os, _findFramework
