import os
from distutils.core import setup
from distutils.extension import Extension
from distutils.command import sdist, build, install
from distutils.util import get_platform
from distutils.sysconfig import get_python_version
from setupext import Data_Files, install_Data_Files
import distutils.command
distutils.command.install_data = install_Data_Files

NAME = 'SystemConfiguration'
def ghetto_build():
    oldcwd = os.getcwd()
    try:
        os.mkdir('build')
    except:
        pass
    os.chdir('src')
    for tool in ('xcodebuild', 'pbxbuild'):
        if os.path.exists(os.path.join('/usr/bin', tool)):
            break
    else:
        raise ValueError, "Install Developer Tools"
    os.system("/usr/bin/%s OBJROOT=../build/temp.%s-%s SYMROOT=../build/lib.%s-%s/%s" % (tool, get_platform(), get_python_version(), get_platform(), get_python_version(), NAME))
    os.chdir(oldcwd)

import sys
for _test in 'install', 'build', 'bdist_dumb':
    if _test in sys.argv:
        ghetto_build()
        break

setup(
    name        = NAME,
    version     = '0.3',
    description = "Pythonic wrapper for the Apple's SystemConfiguration API",
    long_description = "Pythonic wrapper for Apple's SystemConfiguration API in OS X\nIncludes functionality up to Mac OS X 10.2.",
    url         = 'http://undefined.org/python/#SystemConfiguration',
    maintainer  = 'Bob Ippolito',
    maintainer_email = 'bob@redivi.com',
    license     = 'Python',
    platforms   = ['Mac OSX'],
    keywords    = [NAME, 'Network', 'Power', 'Management', 'Preferences'],
    data_files  = [Data_Files(
        base_dir = 'install_platlib',
        copy_to = NAME,
        template = ['recursive-include build/lib.%s-%s/%s/UNSystemConfiguration.framework *' % (get_platform(), get_python_version(), NAME),],
        strip_dirs = 3,
        preserve_path = 1,
    ),],
    packages = [NAME],
    package_dir = {NAME:'lib'},
    cmdclass = {
        "install_data":install_Data_Files,
        "sdist":sdist.sdist,
        "build":build.build,
        "install":install.install,
    },
)
