#import "UNSystemConfiguration_Prefix.h"
@interface UNSystemConfigurationDynamicStore : NSObject
{
    SCDynamicStoreRef _dynamicStore;
    id _delegate;
    CFRunLoopSourceRef _rlsource;
    BOOL _attachedToRL;
}
-initWithName:(NSString*)name;
-(void)keysChanged:(NSArray*)changedKeys;
-delegate;
-setDelegate:(id)delegate;
-setDynamicStore:(SCDynamicStoreRef)sRef;
-(SCDynamicStoreRef)dynamicStore;
-(CFRunLoopSourceRef)CFRunLoopSourceForOrder:(CFIndex)order;
-(CFRunLoopSourceRef)CFRunLoopSource;
-(void)addToCurrentRunLoop;
-(void)removeFromCurrentRunLoop;
/*
+(BOOL)setDHCPClientPreferencesForApplication:(NSString*)applicationID options:(NSArray*)options;
+(NSArray*)DHCPClientPreferencesForApplication:(NSString*)applicationID;
+(NSData*)DHCPInfoOptionDataForInfo:(NSDictionary*)info code:(UInt8)code;
+(NSDate*)DHCPInfoLeaseStartTimeForInfo:(NSDictionary*)info;
-(NSDictionary*)DHCPInfoForService:(NSString*)serviceId;
*/
-(NSString*)computerName;
-(NSDictionary*)consoleUser;
-(NSString*)localHostName;
-(NSString*)location;
-(NSDictionary*)proxies;
+(NSString*)networkGlobalEntityKeyForDomain:(NSString*)domain entity:(NSString*)entity;
+(NSString*)networkInterfaceKeyForDomain:(NSString*)domain;
+(NSString*)networkInterfaceEntityKeyForDomain:(NSString*)domain interfaceName:(NSString*)ifname entity:(NSString*)entity;
+(NSString*)networkServiceEntityKeyForDomain:(NSString*)domain service:(NSString*)serviceId entity:(NSString*)entity;
+(NSString*)computerNameKey;
+(NSString*)consoleUserKey;
+(NSString*)hostNamesKey;
+(NSString*)locationKey;
+(NSString*)proxiesKey;
-(NSArray*)keyListForPattern:(NSString*)pattern;
-(void)addValue:(id)value forKey:(NSString*)key;
-(void)addTemporaryValue:(id)value forKey:(NSString*)key;
-valueForKey:(NSString*)key;
-(NSDictionary*)valuesForKeys:(NSArray*)keys matchingPatterns:(NSArray*)patterns;
-(void)setValue:(id)value forKey:(NSString*)key;
-(void)setKeysAndValues:(NSDictionary*)kv removeKeys:(NSArray*)removeKeys notifyKeys:(NSArray*)notifyKeys;
-(void)removeValueForKey:(NSString*)key;
-(void)notifyValueForKey:(NSString*)key;
-(void)notifyValuesForKeys:(NSArray*)keys matchingPatterns:(NSArray*)patterns;
-(NSArray*)notifiedKeys;
+(NSNumber*)checkReachabilityForAddress:(NSData*)addr;
+(NSNumber*)checkReachabilityForName:(NSString*)name;
@end

@protocol UNSystemConfigurationDynamicStoreDelegate
-(void)keysChanged:(NSArray*)changedKeys inDynamicStore:(UNSystemConfigurationDynamicStore*)dStore;
@end
