#import "UNSystemConfigurationErrors.h"

NSDictionary* _SCStatusCodes;
@implementation UNSystemConfigurationErrors
+errorForValue:(NSNumber*)errVal
{
    return [_SCStatusCodes objectForKey:errVal];
}

+(void)checkError
{
    int scErr = SCError();
    id errObj;
    NSDictionary* rval;
    if (scErr == kSCStatusOK) {
        scErr = kSCStatusFailed;
    }
    errObj = [NSNumber numberWithInt:scErr];
    rval = [UNSystemConfigurationErrors errorForValue:errObj];
    if (rval == nil)
    {
        rval = [NSDictionary dictionaryWithObjectsAndKeys:@"unknown",@"name",errObj,@"value",@"Unknown Error",@"doc",nil,nil];
    }
    [[NSException exceptionWithName:[rval objectForKey:@"name"] reason:[rval objectForKey:@"doc"] userInfo:rval] raise];
}

+(void)load
{
    _SCStatusCodes = [[NSDictionary dictionaryWithObjectsAndKeys:[NSDictionary dictionaryWithObjectsAndKeys:@"kSCStatusOK", @"name", [NSNumber numberWithInt:kSCStatusOK], @"value", @"Success", @"doc", nil, nil],[NSNumber numberWithInt:kSCStatusOK],[NSDictionary dictionaryWithObjectsAndKeys:@"kSCStatusReachabilityUnknown", @"name", [NSNumber numberWithInt:kSCStatusReachabilityUnknown], @"value", @"Network reachability cannot be determined", @"doc", nil, nil],[NSNumber numberWithInt:kSCStatusReachabilityUnknown],[NSDictionary dictionaryWithObjectsAndKeys:@"kSCStatusFailed", @"name", [NSNumber numberWithInt:kSCStatusFailed], @"value", @"Non-specific failure", @"doc", nil, nil],[NSNumber numberWithInt:kSCStatusFailed],[NSDictionary dictionaryWithObjectsAndKeys:@"kSCStatusInvalidArgument", @"name", [NSNumber numberWithInt:kSCStatusInvalidArgument], @"value", @"Invalid argument", @"doc", nil, nil],[NSNumber numberWithInt:kSCStatusInvalidArgument],[NSDictionary dictionaryWithObjectsAndKeys:@"kSCStatusAccessError", @"name", [NSNumber numberWithInt:kSCStatusAccessError], @"value", @"Permission denied.  Must be root to obtain lock.  Could not create access/create preferences", @"doc", nil, nil],[NSNumber numberWithInt:kSCStatusAccessError],[NSDictionary dictionaryWithObjectsAndKeys:@"kSCStatusNoKey", @"name", [NSNumber numberWithInt:kSCStatusNoKey], @"value", @"No such key", @"doc", nil, nil],[NSNumber numberWithInt:kSCStatusNoKey],[NSDictionary dictionaryWithObjectsAndKeys:@"kSCStatusKeyExists", @"name", [NSNumber numberWithInt:kSCStatusKeyExists], @"value", @"Key already defined", @"doc", nil, nil],[NSNumber numberWithInt:kSCStatusKeyExists],[NSDictionary dictionaryWithObjectsAndKeys:@"kSCStatusLocked", @"name", [NSNumber numberWithInt:kSCStatusLocked], @"value", @"Lock already held", @"doc", nil, nil],[NSNumber numberWithInt:kSCStatusLocked],[NSDictionary dictionaryWithObjectsAndKeys:@"kSCStatusNeedLock", @"name", [NSNumber numberWithInt:kSCStatusNeedLock], @"value", @"Lock required for this operation", @"doc", nil, nil],[NSNumber numberWithInt:kSCStatusNeedLock],[NSDictionary dictionaryWithObjectsAndKeys:@"kSCStatusNoStoreSession", @"name", [NSNumber numberWithInt:kSCStatusNoStoreSession], @"value", @"Configuration daemon session not active", @"doc", nil, nil],[NSNumber numberWithInt:kSCStatusNoStoreSession],[NSDictionary dictionaryWithObjectsAndKeys:@"kSCStatusNoStoreServer", @"name", [NSNumber numberWithInt:kSCStatusNoStoreServer], @"value", @"Configuration daemon not (no longer) available", @"doc", nil, nil],[NSNumber numberWithInt:kSCStatusNoStoreServer],[NSDictionary dictionaryWithObjectsAndKeys:@"kSCStatusNotifierActive", @"name", [NSNumber numberWithInt:kSCStatusNotifierActive], @"value", @"Notifier is currently active", @"doc", nil, nil],[NSNumber numberWithInt:kSCStatusNotifierActive],[NSDictionary dictionaryWithObjectsAndKeys:@"kSCStatusNoPrefsSession", @"name", [NSNumber numberWithInt:kSCStatusNoPrefsSession], @"value", @"Preference session not active", @"doc", nil, nil],[NSNumber numberWithInt:kSCStatusNoPrefsSession],[NSDictionary dictionaryWithObjectsAndKeys:@"kSCStatusPrefsBusy", @"name", [NSNumber numberWithInt:kSCStatusPrefsBusy], @"value", @"Preferences update currently in progress", @"doc", nil, nil],[NSNumber numberWithInt:kSCStatusPrefsBusy],[NSDictionary dictionaryWithObjectsAndKeys:@"kSCStatusNoConfigFile", @"name", [NSNumber numberWithInt:kSCStatusNoConfigFile], @"value", @"Configuration file not found", @"doc", nil, nil],[NSNumber numberWithInt:kSCStatusNoConfigFile],[NSDictionary dictionaryWithObjectsAndKeys:@"kSCStatusNoLink", @"name", [NSNumber numberWithInt:kSCStatusNoLink], @"value", @"No such link", @"doc", nil, nil],[NSNumber numberWithInt:kSCStatusNoLink],[NSDictionary dictionaryWithObjectsAndKeys:@"kSCStatusStale", @"name", [NSNumber numberWithInt:kSCStatusStale], @"value", @"Write attempted on stale version of object", @"doc", nil, nil],[NSNumber numberWithInt:kSCStatusStale],[NSDictionary dictionaryWithObjectsAndKeys:@"kSCStatusMaxLink", @"name", [NSNumber numberWithInt:kSCStatusMaxLink], @"value", @"Maximum link count exceeded", @"doc", nil, nil],[NSNumber numberWithInt:kSCStatusMaxLink],nil,nil] retain];
}
@end
