#import "UNSystemConfigurationPreferences.h"
#import "UNSystemConfigurationErrors.h"

@implementation UNSystemConfigurationPreferences
-init
{
    self = [super init];
    _preferences = NULL;
    return self;
}

-initWithName:(NSString*)name
{
    return [self initWithName:name prefs:nil];
}

-initWithName:(NSString*)name prefs:(NSString*)prefsId
{
    SCPreferencesRef rval = SCPreferencesCreate(NULL, (CFStringRef)name, (CFStringRef)prefsId);
    if (rval == NULL) [UNSystemConfigurationErrors checkError];
    self = [self init];
    return [self setPreferences:rval];
}

-setPreferences:(SCPreferencesRef)pRef
{
    _preferences = pRef;
    return self;
}

-(SCPreferencesRef)preferences
{
    return _preferences;
}

-(NSString*)uniqueChildPathForPrefix:(NSString*)prefix
{
    if (prefix == nil) {
        [NSException raise:NSInvalidArgumentException format:@"prefix may not be nil"];
    }
    return [(NSString*)SCPreferencesPathCreateUniqueChild([self preferences], (CFStringRef)prefix) autorelease];
}

-(NSDictionary*)valueForPath:(NSString*)path
{
    if (path == nil) {
        [NSException raise:NSInvalidArgumentException format:@"path may not be nil"];
    }
    return [(NSDictionary*)SCPreferencesPathGetValue([self preferences], (CFStringRef)path) autorelease];
}

-(NSString*)linkForPath:(NSString*)path
{
    if (path == nil) {
        [NSException raise:NSInvalidArgumentException format:@"path may not be nil"];
    }
    return [(NSString*)SCPreferencesPathGetLink([self preferences], (CFStringRef)path) autorelease];
}

-(void)setValue:(NSDictionary*)value forPath:(NSString*)path
{
    if (value == nil) {
        [NSException raise:NSInvalidArgumentException format:@"value may not be nil"];
    }
    if (path == nil) {
        [NSException raise:NSInvalidArgumentException format:@"path may not be nil"];
    }
    if (!SCPreferencesPathSetValue([self preferences], (CFStringRef)path, (CFDictionaryRef)value)) {
        [UNSystemConfigurationErrors checkError];
    }
}

-(void)setLink:(NSString*)link forPath:(NSString*)path
{
    if (link == nil) {
        [NSException raise:NSInvalidArgumentException format:@"link may not be nil"];
    }
    if (path == nil) {
        [NSException raise:NSInvalidArgumentException format:@"path may not be nil"];
    }
    if (!SCPreferencesPathSetLink([self preferences], (CFStringRef)path, (CFStringRef)link)) {
        [UNSystemConfigurationErrors checkError];
    }
}

-(void)removeValueForPath:(NSString*)path
{
    if (path == nil) {
        [NSException raise:NSInvalidArgumentException format:@"path may not be nil"];
    }
    if (!SCPreferencesPathRemoveValue([self preferences], (CFStringRef)path)) {
        [UNSystemConfigurationErrors checkError];
    }
}

/*
-(BOOL)setComputerName:(NSString*)name
{
    return [self setComputerName:name withCFStringEncoding:kCFStringEncodingUTF8];
}

-(BOOL)setComputerName:(NSString*)name withCFStringEncoding:(CFStringEncoding)encoding
{
    return (BOOL)SCPreferencesSetComputerName([self preferences], (CFStringRef)name, encoding);
}

-(BOOL)setLocalHostName:(NSString*)name
{
    return (BOOL)SCPreferencesSetLocalHostName([self preferences], (CFStringRef)name);
}
*/

-(void)lockAsync
{
    if (!SCPreferencesLock([self preferences], FALSE)) {
        [UNSystemConfigurationErrors checkError];
    }
}

-(void)lock
{
    if (!SCPreferencesLock([self preferences], TRUE)) {
        [UNSystemConfigurationErrors checkError];
    }
}

-(void)commit
{
    if (!SCPreferencesCommitChanges([self preferences])) {
        [UNSystemConfigurationErrors checkError];
    }
}

-(void)apply
{
    if (!SCPreferencesApplyChanges([self preferences])) {
        [UNSystemConfigurationErrors checkError];
    }
}

-(void)unlock
{
    if (!SCPreferencesUnlock([self preferences])) {
        [UNSystemConfigurationErrors checkError];
    }
}

-(NSData*)signature
{
    return [(NSData*)SCPreferencesGetSignature([self preferences]) autorelease];
}

-(NSArray*)keyList
{
    return [(NSArray*)SCPreferencesCopyKeyList([self preferences]) autorelease];
}

-valueForKey:(NSString*)key
{
    return [(NSObject*)SCPreferencesGetValue([self preferences], (CFStringRef)key) autorelease];
}

-(void)addValue:(id)value forKey:(NSString*)key
{
    if (value == nil) {
        [NSException raise:NSInvalidArgumentException format:@"value may not be nil"];
    }
    if (key == nil) {
        [NSException raise:NSInvalidArgumentException format:@"key may not be nil"];
    }
    if (!SCPreferencesAddValue([self preferences], (CFStringRef)key, (CFPropertyListRef)value)) {
        [UNSystemConfigurationErrors checkError];
    }
}

-(void)setValue:(id)value forKey:(NSString*)key
{
    if (value == nil) {
        [NSException raise:NSInvalidArgumentException format:@"value may not be nil"];
    }
    if (key == nil) {
        [NSException raise:NSInvalidArgumentException format:@"key may not be nil"];
    }
    if (!SCPreferencesSetValue([self preferences], (CFStringRef)key, (CFPropertyListRef)value)) {
        [UNSystemConfigurationErrors checkError];
    }
}

-(void)removeValueForKey:(NSString*)key
{
    if (key == nil) {
        [NSException raise:NSInvalidArgumentException format:@"key may not be nil"];
    }
    if (!SCPreferencesRemoveValue([self preferences], (CFStringRef)key)) {
        [UNSystemConfigurationErrors checkError];
    }
}

#if 0
-(NSString*)pathForSet:(NSString*)setId
{
    if (setId != nil) {
        return [NSString stringWithFormat:@"/%@/%@", kSCPrefSets, setId];
    } else {
        return [self valueForKey:(NSString*)kSCPrefCurrentSet];
    }
}

-(NSString*)servicesPathForSet:(NSString*)setId
{
    NSString *setPath = [self pathForSet:setId];
    if (setPath == nil) {
        return nil;
    }
    return [NSString stringWithFormat:@"%@/%@/%@", setPath, kSCCompNetwork, kSCCompService];
}

-(NSString*)globalsPathForSet:(NSString*)setId
{
    NSString *setPath = [self pathForSet:setId];
    if (setPath == nil) {
        return nil;
    }
    return [NSString stringWithFormat:@"%@/%@/%@", setPath, kSCCompNetwork, kSCCompGlobal];
 }

-(NSString*)resolvedPathForSet:(NSString*)setId service:(NSString*)serviceId
{
    //NSString *servicePath;
    NSString *linkPath;
    NSString *setServicesPath;
    if (serviceId == nil) {
        return [self globalsPathForSet:setId];
    }
    if ((setServicesPath = [self servicesPathForSet:setId]) == nil) {
        return nil;
    }
    if ((linkPath = [NSString stringWithFormat:@"%@/%@", setServicesPath, serviceId]) == nil) {
        return nil;
    }
    return [self linkForPath:linkPath];
}

-(NSString*)entityPathForSet:(NSString*)setId service:(NSString*)serviceId protocol:(NSString*)proto
{
    NSString* servicePath;
    if ((servicePath = [self resolvedPathForSet:setId service:serviceId]) == nil) {
        return nil;
    }
    return [NSString stringWithFormat:@"%@/%@", servicePath, proto];
}

-(void)setPropertyValue:(NSString*)value forKey:(NSString*)key atPath:(NSString*)path
{
    NSMutableDictionary *pDict;
    if ((pDict = [(NSDictionary*)[self valueForKey:path] mutableCopy]) == nil) {
        [UNSystemConfigurationErrors checkError];
    }
    [pDict setObject:value forKey:key];
    [self setValue:pDict forKey:path];
}

-propertyValueForKey:(NSString*)key atPath:(NSString*)path
{
    return [[self valueForKey:path] valueForKey:path];
}

-(NSString*)userVisibleNameForSet:(NSString*)setId
{
    NSString *setPath;
    //NSDictionary *setDict;
    if ((setPath = [self pathForSet:setId]) == nil) {
        return nil;
    }
    return [self propertyValueForKey:(NSString*)kSCPropUserDefinedName atPath:setPath];
}

+(NSString*)serviceOrSetForPath:(NSString*)path
{
    NSArray* pathComponents = [path componentsSeparatedByString:@"/"];
    if ((pathComponents == nil) || ([pathComponents count] != 3)) {
        return nil;
    }
    return (NSString*)[pathComponents objectAtIndex:2];
}

-(NSString*)currentSet
{
    return [UNSystemConfigurationPreferences serviceOrSetForPath:[self valueForKey:(NSString*)kSCPrefCurrentSet]];
}

-(void)setCurrentSet:(NSString*)setId
{
    NSString *setPath = [self pathForSet:setId];
    [self setValue:setPath forKey:(NSString*)kSCPrefCurrentSet];
}

-(NSDictionary*)entitiesForSet:(NSString*)setId service:(NSString*)serviceId
{
    NSString *servicePath;
    if ((servicePath = [self resolvedPathForSet:setId service:serviceId]) == nil) {
        return nil;
    }
    return [self valueForKey:servicePath];
}

-(NSString*)userVisibleNameForSet:(NSString*)setId service:(NSString*)serviceId
{
    NSDictionary *entitiesDict;
    if ((entitiesDict = [self entitiesForSet:setId service:serviceId]) == nil) {
        return nil;
    }
    return [entitiesDict valueForKey:(NSString*)kSCPropUserDefinedName];
}
    
-(NSString*)bsdNameForSet:(NSString*)setId service:(NSString*)serviceId
{
    return [[self valueForKey:[self entityPathForSet:setId service:serviceId protocol:(NSString*)kSCEntNetInterface]] valueForKey:(NSString*)kSCPropNetInterfaceDeviceName];
}
#endif
@end
