from SystemConfiguration import *
import os

from Foundation import NSObject, NSRunLoop, NSDate
class SCDelegate(NSObject):
    def init(self):
        self = super(SCDelegate, self).init()
        self.last = {}
        return self

    def keysChanged_inDynamicStore_(self, changed, store):
        for key in changed:
            info = store.valueForKey_(key).items()
            info.sort()
            print "----"
            for k,v in info:
                # deltas only
                if k in self.last and self.last[k] == v:
                    continue
                self.last[k] = v
                print "%-20s%s" % (k, v)

def main():
    ds = UNSystemConfigurationDynamicStore.alloc().initWithName_('FTest')
    print "You are:", ds.consoleUser()
    print "Your hostname is:", ds.localHostName()
    print "Your computer name is:", ds.computerName()
    networkLocation()
    proxySettings()
    networkingDevices()
    try:
        twistedBatteryMonitor()
    except:
        pass

def networkLocation():
    pf = UNSystemConfigurationPreferences.alloc().initWithName_('FTest')
    print "You're using network location:", pf.valueForPath_(getCurrentLocation())[kSCPropUserDefinedName]
    
def proxySettings():
    ds = UNSystemConfigurationDynamicStore.alloc().initWithName_('FTest')
    proxies = ds.proxies().items()
    proxies.sort()
    print "Your proxy settings are:"
    for proxy, value in proxies:
        print '  %s = %s' % (proxy, value)

def getCurrentLocation():
    pf = UNSystemConfigurationPreferences.alloc().initWithName_('FTest')
    return pf.valueForKey_(kSCPrefCurrentSet)

def networkingDevices():
    pf = UNSystemConfigurationPreferences.alloc().initWithName_('FTest')
    services = [(int(a), a, b) for a,b in pf.valueForKey_(kSCPrefNetworkServices).iteritems()]
    services.sort()
    print 'You have these networking devices configured:'
    for serviceId, serviceStr, service in services:
        interface = service[kSCEntNetInterface]
        print '  (%s) %s' % (
            interface.get(kSCPropNetInterfaceDeviceName, None),
            interface.get(kSCPropUserDefinedName, None),
        )

def twistedBatteryMonitor():
    BATTERYPATTERN = r'.*/InternalBattery[^/]+'
    ds = UNSystemConfigurationDynamicStore.alloc().initWithName_('FTest')
    batteryKeys = list(ds.keyListForPattern_(BATTERYPATTERN))
    if not batteryKeys:
        print "You're not on a laptop!"
        return
    # Note that this needs 10/20/03 or later Twisted CVS to work.
    from twisted.internet import cfreactor
    rl = NSRunLoop.currentRunLoop()
    cfreactor.install(runLoop=rl.getCFRunLoop())
    from twisted.internet import reactor
    # Trick twisted into starting/stopping the CFRunLoop, should
    # change the interface for this so you can state it from install
    # or run.
    reactor.inheritedRunLoop = False
    ds.setDelegate_(SCDelegate.alloc().init())
    ds.addToCurrentRunLoop()
    ds.notifyValuesForKeys_matchingPatterns_(None, [BATTERYPATTERN])
    ds.delegate().keysChanged_inDynamicStore_(batteryKeys, ds)
    def _stop():
        print "Stopping."
        ds.removeFromCurrentRunLoop()
        reactor.stop()
    reactor.callLater(15.0, _stop)
    reactor.run()

if __name__=='__main__':
    main()
